// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__19609 = arguments.length;
switch (G__19609) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__19612 = arguments.length;
switch (G__19612) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2771__auto___19665 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_19643){
var state_val_19644 = (state_19643[(1)]);
if((state_val_19644 === (1))){
var state_19643__$1 = state_19643;
var statearr_19645_19666 = state_19643__$1;
(statearr_19645_19666[(2)] = null);

(statearr_19645_19666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19644 === (2))){
var _ = (function (){var statearr_19646 = state_19643;
(statearr_19646[(4)] = cljs.core.cons((5),(state_19643[(4)])));

return statearr_19646;
})();
var inst_19620 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19620)){
var statearr_19647_19667 = state_19643__$1;
(statearr_19647_19667[(1)] = (6));

} else {
var statearr_19648_19668 = state_19643__$1;
(statearr_19648_19668[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19644 === (3))){
var inst_19641 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19643__$1,inst_19641);
} else {
if((state_val_19644 === (4))){
var inst_19613 = (state_19643[(2)]);
var inst_19614 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_19613);
var state_19643__$1 = state_19643;
var statearr_19650_19669 = state_19643__$1;
(statearr_19650_19669[(2)] = inst_19614);

(statearr_19650_19669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19644 === (5))){
var _ = (function (){var statearr_19651 = state_19643;
(statearr_19651[(4)] = cljs.core.rest((state_19643[(4)])));

return statearr_19651;
})();
var state_19643__$1 = state_19643;
var ex19649 = (state_19643__$1[(2)]);
var statearr_19652_19670 = state_19643__$1;
(statearr_19652_19670[(5)] = ex19649);


var statearr_19653_19671 = state_19643__$1;
(statearr_19653_19671[(1)] = (4));

(statearr_19653_19671[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19644 === (6))){
var inst_19622 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19623 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_19624 = cljs.core.PersistentHashMap.fromArrays(inst_19622,inst_19623);
var inst_19625 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_19624);
var inst_19626 = (function(){throw inst_19625})();
var state_19643__$1 = state_19643;
var statearr_19654_19672 = state_19643__$1;
(statearr_19654_19672[(2)] = inst_19626);

(statearr_19654_19672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19644 === (7))){
var inst_19628 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19630 = [operation,data,pc,opts];
var inst_19631 = (new cljs.core.PersistentVector(null,4,(5),inst_19629,inst_19630,null));
var inst_19632 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19628,inst_19631);
var inst_19633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19634 = [operation,data,pc,opts];
var inst_19635 = (new cljs.core.PersistentVector(null,4,(5),inst_19633,inst_19634,null));
var inst_19636 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_19635], 0));
var state_19643__$1 = (function (){var statearr_19655 = state_19643;
(statearr_19655[(7)] = inst_19632);

return statearr_19655;
})();
var statearr_19656_19673 = state_19643__$1;
(statearr_19656_19673[(2)] = inst_19636);

(statearr_19656_19673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19644 === (8))){
var inst_19638 = (state_19643[(2)]);
var _ = (function (){var statearr_19657 = state_19643;
(statearr_19657[(4)] = cljs.core.rest((state_19643[(4)])));

return statearr_19657;
})();
var state_19643__$1 = state_19643;
var statearr_19658_19674 = state_19643__$1;
(statearr_19658_19674[(2)] = inst_19638);

(statearr_19658_19674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2749__auto__ = null;
var fluree$db$operations$state_machine__2749__auto____0 = (function (){
var statearr_19659 = [null,null,null,null,null,null,null,null];
(statearr_19659[(0)] = fluree$db$operations$state_machine__2749__auto__);

(statearr_19659[(1)] = (1));

return statearr_19659;
});
var fluree$db$operations$state_machine__2749__auto____1 = (function (state_19643){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_19643);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e19660){var ex__2752__auto__ = e19660;
var statearr_19661_19675 = state_19643;
(statearr_19661_19675[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_19643[(4)]))){
var statearr_19662_19676 = state_19643;
(statearr_19662_19676[(1)] = cljs.core.first((state_19643[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19677 = state_19643;
state_19643 = G__19677;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2749__auto__ = function(state_19643){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2749__auto____1.call(this,state_19643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2749__auto____0;
fluree$db$operations$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2749__auto____1;
return fluree$db$operations$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_19663 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_19663[(6)] = c__2771__auto___19665);

return statearr_19663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__19679 = arguments.length;
switch (G__19679) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__19680){
var map__19681 = p__19680;
var map__19681__$1 = cljs.core.__destructure_map(map__19681);
var opts = map__19681__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19681__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__19682 = session;
var map__19682__$1 = cljs.core.__destructure_map(map__19682);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19682__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19682__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19682__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5774__auto__ = [];
var len__5768__auto___19709 = arguments.length;
var i__5769__auto___19710 = (0);
while(true){
if((i__5769__auto___19710 < len__5768__auto___19709)){
args__5774__auto__.push((arguments[i__5769__auto___19710]));

var G__19711 = (i__5769__auto___19710 + (1));
i__5769__auto___19710 = G__19711;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__19686){
var vec__19687 = p__19686;
var map__19690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19687,(0),null);
var map__19690__$1 = cljs.core.__destructure_map(map__19690);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19690__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19690__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__19687;
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_19702){
var state_val_19703 = (state_19702[(1)]);
if((state_val_19703 === (1))){
var inst_19692 = session;
var inst_19693 = cljs.core.__destructure_map(inst_19692);
var inst_19694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19693,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19693,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19696 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19693,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19697 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_19698 = [inst_19694,inst_19695,toBlock,toTime];
var inst_19699 = cljs.core.PersistentHashMap.fromArrays(inst_19697,inst_19698);
var inst_19700 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_19696,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_19699);
var state_19702__$1 = state_19702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19702__$1,inst_19700);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2749__auto__ = null;
var fluree$db$operations$state_machine__2749__auto____0 = (function (){
var statearr_19704 = [null,null,null,null,null,null,null];
(statearr_19704[(0)] = fluree$db$operations$state_machine__2749__auto__);

(statearr_19704[(1)] = (1));

return statearr_19704;
});
var fluree$db$operations$state_machine__2749__auto____1 = (function (state_19702){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_19702);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e19705){var ex__2752__auto__ = e19705;
var statearr_19706_19712 = state_19702;
(statearr_19706_19712[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_19702[(4)]))){
var statearr_19707_19713 = state_19702;
(statearr_19707_19713[(1)] = cljs.core.first((state_19702[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19714 = state_19702;
state_19702 = G__19714;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2749__auto__ = function(state_19702){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2749__auto____1.call(this,state_19702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2749__auto____0;
fluree$db$operations$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2749__auto____1;
return fluree$db$operations$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_19708 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_19708[(6)] = c__2771__auto__);

return statearr_19708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq19684){
var G__19685 = cljs.core.first(seq19684);
var seq19684__$1 = cljs.core.next(seq19684);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19685,seq19684__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__19715 = session;
var map__19715__$1 = cljs.core.__destructure_map(map__19715);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19715__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19715__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19715__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__19717 = arguments.length;
switch (G__19717) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__19718 = opts;
var map__19718__$1 = cljs.core.__destructure_map(map__19718);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19718__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19718__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
