// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20989){var e = e20989;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20990_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20990_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20990_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20990_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20990_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20991_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20991_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20992_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20992_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20997 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20997,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20997,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20993_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20993_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__21000 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21000,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21000,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20994_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20994_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20995_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20995_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20996_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20996_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21003_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__21003_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__21004 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__21004) : intersecting_vars.call(null,G__21004));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__21007,optional_QMARK_,fuel,max_fuel){
var map__21008 = p__21007;
var map__21008__$1 = cljs.core.__destructure_map(map__21008);
var res = map__21008__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21008__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_21074){
var state_val_21075 = (state_21074[(1)]);
if((state_val_21075 === (7))){
var inst_21063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21064 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_21065 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21064,clause);
var inst_21066 = [null,inst_21065];
var inst_21067 = (new cljs.core.PersistentVector(null,2,(5),inst_21063,inst_21066,null));
var state_21074__$1 = state_21074;
var statearr_21076_21104 = state_21074__$1;
(statearr_21076_21104[(2)] = inst_21067);

(statearr_21076_21104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (1))){
var state_21074__$1 = state_21074;
var statearr_21077_21105 = state_21074__$1;
(statearr_21077_21105[(2)] = null);

(statearr_21077_21105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (4))){
var inst_21009 = (state_21074[(2)]);
var state_21074__$1 = state_21074;
var statearr_21078_21106 = state_21074__$1;
(statearr_21078_21106[(2)] = inst_21009);

(statearr_21078_21106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (15))){
var inst_21052 = (state_21074[(2)]);
var inst_21053 = fluree.db.util.async.throw_err(inst_21052);
var inst_21054 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_21053);
var inst_21055 = cljs.core.count(inst_21054);
var inst_21056 = fluree.db.query.analytical.add_fuel(inst_21055,fuel,max_fuel);
var inst_21057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21058 = [inst_21053,r];
var inst_21059 = (new cljs.core.PersistentVector(null,2,(5),inst_21057,inst_21058,null));
var state_21074__$1 = (function (){var statearr_21079 = state_21074;
(statearr_21079[(7)] = inst_21056);

return statearr_21079;
})();
var statearr_21080_21107 = state_21074__$1;
(statearr_21080_21107[(2)] = inst_21059);

(statearr_21080_21107[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (13))){
var inst_21018 = (state_21074[(8)]);
var inst_21031 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_21032 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_21031);
var inst_21033 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_21018);
var inst_21034 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_21033);
var inst_21035 = cljs.core.set(inst_21034);
var inst_21036 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_21032);
var inst_21037 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_21036);
var inst_21038 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21035,inst_21037);
var inst_21039 = (function (){var all_wd = inst_21018;
var optional = inst_21032;
var all_wd_vars = inst_21035;
var all_vars = inst_21038;
return (function (p1__21005_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__21005_SHARP_) : all_vars.call(null,p1__21005_SHARP_));
});
})();
var inst_21040 = cljs.core.keys(vars);
var inst_21041 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21039,inst_21040);
var inst_21042 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_21041);
var inst_21043 = cljs.core.set(inst_21042);
var inst_21044 = (function (){var all_wd = inst_21018;
var optional = inst_21032;
var all_wd_vars = inst_21035;
var all_vars = inst_21038;
var intersecting_vars = inst_21043;
return (function (p1__21006_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__21006_SHARP_);
});
})();
var inst_21045 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21044,inst_21018);
var inst_21046 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_21045);
var inst_21047 = fluree.db.query.analytical.select_from_tuples(inst_21046,res);
var inst_21048 = fluree.db.query.analytical.replace_vars_wikidata(inst_21018,inst_21043,vars);
var inst_21049 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_21043,inst_21038);
var inst_21050 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_21048,inst_21046,inst_21047,inst_21049,inst_21032);
var state_21074__$1 = state_21074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21074__$1,(15),inst_21050);
} else {
if((state_val_21075 === (6))){
var inst_21019 = (state_21074[(9)]);
var inst_21017 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_21018 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_21017);
var inst_21019__$1 = optional_QMARK_;
var state_21074__$1 = (function (){var statearr_21081 = state_21074;
(statearr_21081[(8)] = inst_21018);

(statearr_21081[(9)] = inst_21019__$1);

return statearr_21081;
})();
if(cljs.core.truth_(inst_21019__$1)){
var statearr_21082_21108 = state_21074__$1;
(statearr_21082_21108[(1)] = (9));

} else {
var statearr_21083_21109 = state_21074__$1;
(statearr_21083_21109[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (3))){
var inst_21072 = (state_21074[(2)]);
var state_21074__$1 = state_21074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21074__$1,inst_21072);
} else {
if((state_val_21075 === (12))){
var inst_21027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21028 = [null,r];
var inst_21029 = (new cljs.core.PersistentVector(null,2,(5),inst_21027,inst_21028,null));
var state_21074__$1 = state_21074;
var statearr_21084_21110 = state_21074__$1;
(statearr_21084_21110[(2)] = inst_21029);

(statearr_21084_21110[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (2))){
var _ = (function (){var statearr_21085 = state_21074;
(statearr_21085[(4)] = cljs.core.cons((5),(state_21074[(4)])));

return statearr_21085;
})();
var inst_21015 = (r == null);
var state_21074__$1 = state_21074;
if(cljs.core.truth_(inst_21015)){
var statearr_21086_21111 = state_21074__$1;
(statearr_21086_21111[(1)] = (6));

} else {
var statearr_21087_21112 = state_21074__$1;
(statearr_21087_21112[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (11))){
var inst_21025 = (state_21074[(2)]);
var state_21074__$1 = state_21074;
if(cljs.core.truth_(inst_21025)){
var statearr_21089_21113 = state_21074__$1;
(statearr_21089_21113[(1)] = (12));

} else {
var statearr_21090_21114 = state_21074__$1;
(statearr_21090_21114[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (9))){
var inst_21018 = (state_21074[(8)]);
var inst_21021 = cljs.core.empty_QMARK_(inst_21018);
var inst_21022 = (!(inst_21021));
var state_21074__$1 = state_21074;
var statearr_21091_21115 = state_21074__$1;
(statearr_21091_21115[(2)] = inst_21022);

(statearr_21091_21115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (5))){
var _ = (function (){var statearr_21092 = state_21074;
(statearr_21092[(4)] = cljs.core.rest((state_21074[(4)])));

return statearr_21092;
})();
var state_21074__$1 = state_21074;
var ex21088 = (state_21074__$1[(2)]);
var statearr_21093_21116 = state_21074__$1;
(statearr_21093_21116[(5)] = ex21088);


if((ex21088 instanceof Error)){
var statearr_21094_21117 = state_21074__$1;
(statearr_21094_21117[(1)] = (4));

(statearr_21094_21117[(5)] = null);

} else {
throw ex21088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (14))){
var inst_21061 = (state_21074[(2)]);
var state_21074__$1 = state_21074;
var statearr_21095_21118 = state_21074__$1;
(statearr_21095_21118[(2)] = inst_21061);

(statearr_21095_21118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (10))){
var inst_21019 = (state_21074[(9)]);
var state_21074__$1 = state_21074;
var statearr_21096_21119 = state_21074__$1;
(statearr_21096_21119[(2)] = inst_21019);

(statearr_21096_21119[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21075 === (8))){
var inst_21069 = (state_21074[(2)]);
var _ = (function (){var statearr_21097 = state_21074;
(statearr_21097[(4)] = cljs.core.rest((state_21074[(4)])));

return statearr_21097;
})();
var state_21074__$1 = state_21074;
var statearr_21098_21120 = state_21074__$1;
(statearr_21098_21120[(2)] = inst_21069);

(statearr_21098_21120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto____0 = (function (){
var statearr_21099 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21099[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto__);

(statearr_21099[(1)] = (1));

return statearr_21099;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto____1 = (function (state_21074){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_21074);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e21100){var ex__2752__auto__ = e21100;
var statearr_21101_21121 = state_21074;
(statearr_21101_21121[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_21074[(4)]))){
var statearr_21102_21122 = state_21074;
(statearr_21102_21122[(1)] = cljs.core.first((state_21074[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21123 = state_21074;
state_21074 = G__21123;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto__ = function(state_21074){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto____1.call(this,state_21074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_21103 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_21103[(6)] = c__2771__auto__);

return statearr_21103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__21125 = arguments.length;
switch (G__21125) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_21219){
var state_val_21220 = (state_21219[(1)]);
if((state_val_21220 === (7))){
var inst_21132 = (state_21219[(7)]);
var inst_21142 = clojure.string.starts_with_QMARK_(inst_21132,"$fdb");
var state_21219__$1 = state_21219;
if(inst_21142){
var statearr_21221_21270 = state_21219__$1;
(statearr_21221_21270[(1)] = (9));

} else {
var statearr_21222_21271 = state_21219__$1;
(statearr_21222_21271[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (20))){
var state_21219__$1 = state_21219;
var statearr_21223_21272 = state_21219__$1;
(statearr_21223_21272[(2)] = null);

(statearr_21223_21272[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (27))){
var inst_21182 = (state_21219[(8)]);
var state_21219__$1 = state_21219;
var statearr_21224_21273 = state_21219__$1;
(statearr_21224_21273[(2)] = inst_21182);

(statearr_21224_21273[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (1))){
var state_21219__$1 = state_21219;
var statearr_21225_21274 = state_21219__$1;
(statearr_21225_21274[(2)] = null);

(statearr_21225_21274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (24))){
var inst_21205 = (state_21219[(2)]);
var state_21219__$1 = state_21219;
var statearr_21226_21275 = state_21219__$1;
(statearr_21226_21275[(2)] = inst_21205);

(statearr_21226_21275[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (4))){
var inst_21126 = (state_21219[(2)]);
var state_21219__$1 = state_21219;
var statearr_21227_21276 = state_21219__$1;
(statearr_21227_21276[(2)] = inst_21126);

(statearr_21227_21276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (15))){
var inst_21149 = (state_21219[(9)]);
var inst_21155 = (state_21219[(2)]);
var inst_21156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21157 = cljs.core.PersistentVector.EMPTY;
var inst_21158 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_21159 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21157,inst_21158);
var inst_21160 = [inst_21149,inst_21159];
var inst_21161 = (new cljs.core.PersistentVector(null,2,(5),inst_21156,inst_21160,null));
var state_21219__$1 = (function (){var statearr_21228 = state_21219;
(statearr_21228[(10)] = inst_21155);

return statearr_21228;
})();
var statearr_21229_21277 = state_21219__$1;
(statearr_21229_21277[(2)] = inst_21161);

(statearr_21229_21277[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (21))){
var inst_21208 = (state_21219[(2)]);
var state_21219__$1 = state_21219;
var statearr_21230_21278 = state_21219__$1;
(statearr_21230_21278[(2)] = inst_21208);

(statearr_21230_21278[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (13))){
var inst_21149 = (state_21219[(9)]);
var inst_21152 = (function(){throw inst_21149})();
var state_21219__$1 = state_21219;
var statearr_21231_21279 = state_21219__$1;
(statearr_21231_21279[(2)] = inst_21152);

(statearr_21231_21279[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (22))){
var inst_21173 = (state_21219[(11)]);
var inst_21171 = (state_21219[(12)]);
var inst_21175 = fluree.db.query.analytical.parse_block_from_source(inst_21171);
var inst_21176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21177 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_21173];
var inst_21178 = (new cljs.core.PersistentVector(null,2,(5),inst_21176,inst_21177,null));
var inst_21179 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_21178);
var state_21219__$1 = (function (){var statearr_21232 = state_21219;
(statearr_21232[(13)] = inst_21175);

return statearr_21232;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21219__$1,(25),inst_21179);
} else {
if((state_val_21220 === (29))){
var inst_21186 = (state_21219[(2)]);
var inst_21187 = fluree.db.util.async.throw_err(inst_21186);
var state_21219__$1 = state_21219;
var statearr_21233_21280 = state_21219__$1;
(statearr_21233_21280[(2)] = inst_21187);

(statearr_21233_21280[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (6))){
var inst_21135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21136 = cljs.core.PersistentVector.EMPTY;
var inst_21137 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_21138 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21136,inst_21137);
var inst_21139 = [db,inst_21138];
var inst_21140 = (new cljs.core.PersistentVector(null,2,(5),inst_21135,inst_21139,null));
var state_21219__$1 = state_21219;
var statearr_21234_21281 = state_21219__$1;
(statearr_21234_21281[(2)] = inst_21140);

(statearr_21234_21281[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (28))){
var inst_21190 = (state_21219[(2)]);
var inst_21191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21192 = cljs.core.PersistentVector.EMPTY;
var inst_21193 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_21194 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21192,inst_21193);
var inst_21195 = [inst_21190,inst_21194];
var inst_21196 = (new cljs.core.PersistentVector(null,2,(5),inst_21191,inst_21195,null));
var state_21219__$1 = state_21219;
var statearr_21235_21282 = state_21219__$1;
(statearr_21235_21282[(2)] = inst_21196);

(statearr_21235_21282[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (25))){
var inst_21175 = (state_21219[(13)]);
var inst_21181 = (state_21219[(2)]);
var inst_21182 = fluree.db.util.async.throw_err(inst_21181);
var state_21219__$1 = (function (){var statearr_21236 = state_21219;
(statearr_21236[(8)] = inst_21182);

return statearr_21236;
})();
if(cljs.core.truth_(inst_21175)){
var statearr_21237_21283 = state_21219__$1;
(statearr_21237_21283[(1)] = (26));

} else {
var statearr_21238_21284 = state_21219__$1;
(statearr_21238_21284[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (17))){
var state_21219__$1 = state_21219;
var statearr_21239_21285 = state_21219__$1;
(statearr_21239_21285[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (3))){
var inst_21217 = (state_21219[(2)]);
var state_21219__$1 = state_21219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21219__$1,inst_21217);
} else {
if((state_val_21220 === (12))){
var inst_21149 = (state_21219[(9)]);
var inst_21148 = (state_21219[(2)]);
var inst_21149__$1 = fluree.db.util.async.throw_err(inst_21148);
var inst_21150 = fluree.db.util.core.exception_QMARK_(inst_21149__$1);
var state_21219__$1 = (function (){var statearr_21241 = state_21219;
(statearr_21241[(9)] = inst_21149__$1);

return statearr_21241;
})();
if(inst_21150){
var statearr_21242_21286 = state_21219__$1;
(statearr_21242_21286[(1)] = (13));

} else {
var statearr_21243_21287 = state_21219__$1;
(statearr_21243_21287[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (2))){
var inst_21132 = (state_21219[(7)]);
var _ = (function (){var statearr_21244 = state_21219;
(statearr_21244[(4)] = cljs.core.cons((5),(state_21219[(4)])));

return statearr_21244;
})();
var inst_21132__$1 = cljs.core.first(clause);
var inst_21133 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_21132__$1);
var state_21219__$1 = (function (){var statearr_21245 = state_21219;
(statearr_21245[(7)] = inst_21132__$1);

return statearr_21245;
})();
if(inst_21133){
var statearr_21246_21288 = state_21219__$1;
(statearr_21246_21288[(1)] = (6));

} else {
var statearr_21247_21289 = state_21219__$1;
(statearr_21247_21289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (23))){
var inst_21132 = (state_21219[(7)]);
var inst_21198 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21132)," is not supported in Fluree"].join('');
var inst_21199 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21200 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21201 = cljs.core.PersistentHashMap.fromArrays(inst_21199,inst_21200);
var inst_21202 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21198,inst_21201);
var inst_21203 = (function(){throw inst_21202})();
var state_21219__$1 = state_21219;
var statearr_21248_21290 = state_21219__$1;
(statearr_21248_21290[(2)] = inst_21203);

(statearr_21248_21290[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (19))){
var inst_21132 = (state_21219[(7)]);
var inst_21173 = (state_21219[(11)]);
var inst_21170 = fluree.db.query.analytical.isolate_source_name(inst_21132);
var inst_21171 = fluree.db.query.analytical.isolate_source_block(inst_21132);
var inst_21172 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_21170);
var inst_21173__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_21172);
var state_21219__$1 = (function (){var statearr_21249 = state_21219;
(statearr_21249[(11)] = inst_21173__$1);

(statearr_21249[(12)] = inst_21171);

return statearr_21249;
})();
if(cljs.core.truth_(inst_21173__$1)){
var statearr_21250_21291 = state_21219__$1;
(statearr_21250_21291[(1)] = (22));

} else {
var statearr_21251_21292 = state_21219__$1;
(statearr_21251_21292[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (11))){
var inst_21212 = (state_21219[(2)]);
var state_21219__$1 = state_21219;
var statearr_21253_21293 = state_21219__$1;
(statearr_21253_21293[(2)] = inst_21212);

(statearr_21253_21293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (9))){
var inst_21132 = (state_21219[(7)]);
var inst_21144 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_21132,(4));
var inst_21145 = fluree.db.query.analytical.parse_block_from_source(inst_21144);
var inst_21146 = fluree.db.time_travel.as_of_block(db,inst_21145);
var state_21219__$1 = state_21219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21219__$1,(12),inst_21146);
} else {
if((state_val_21220 === (5))){
var _ = (function (){var statearr_21254 = state_21219;
(statearr_21254[(4)] = cljs.core.rest((state_21219[(4)])));

return statearr_21254;
})();
var state_21219__$1 = state_21219;
var ex21252 = (state_21219__$1[(2)]);
var statearr_21255_21294 = state_21219__$1;
(statearr_21255_21294[(5)] = ex21252);


if((ex21252 instanceof Error)){
var statearr_21256_21295 = state_21219__$1;
(statearr_21256_21295[(1)] = (4));

(statearr_21256_21295[(5)] = null);

} else {
throw ex21252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (14))){
var state_21219__$1 = state_21219;
var statearr_21257_21296 = state_21219__$1;
(statearr_21257_21296[(2)] = null);

(statearr_21257_21296[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (26))){
var inst_21182 = (state_21219[(8)]);
var inst_21175 = (state_21219[(13)]);
var inst_21184 = fluree.db.time_travel.as_of_block(inst_21182,inst_21175);
var state_21219__$1 = state_21219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21219__$1,(29),inst_21184);
} else {
if((state_val_21220 === (16))){
var inst_21165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21166 = ["$wd",clause];
var inst_21167 = (new cljs.core.PersistentVector(null,2,(5),inst_21165,inst_21166,null));
var state_21219__$1 = state_21219;
var statearr_21258_21297 = state_21219__$1;
(statearr_21258_21297[(2)] = inst_21167);

(statearr_21258_21297[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (10))){
var inst_21132 = (state_21219[(7)]);
var inst_21163 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21132);
var state_21219__$1 = state_21219;
if(inst_21163){
var statearr_21259_21298 = state_21219__$1;
(statearr_21259_21298[(1)] = (16));

} else {
var statearr_21260_21299 = state_21219__$1;
(statearr_21260_21299[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (18))){
var inst_21210 = (state_21219[(2)]);
var state_21219__$1 = state_21219;
var statearr_21261_21300 = state_21219__$1;
(statearr_21261_21300[(2)] = inst_21210);

(statearr_21261_21300[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21220 === (8))){
var inst_21214 = (state_21219[(2)]);
var _ = (function (){var statearr_21262 = state_21219;
(statearr_21262[(4)] = cljs.core.rest((state_21219[(4)])));

return statearr_21262;
})();
var state_21219__$1 = state_21219;
var statearr_21263_21301 = state_21219__$1;
(statearr_21263_21301[(2)] = inst_21214);

(statearr_21263_21301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2749__auto__ = null;
var fluree$db$query$analytical$state_machine__2749__auto____0 = (function (){
var statearr_21264 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21264[(0)] = fluree$db$query$analytical$state_machine__2749__auto__);

(statearr_21264[(1)] = (1));

return statearr_21264;
});
var fluree$db$query$analytical$state_machine__2749__auto____1 = (function (state_21219){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_21219);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e21265){var ex__2752__auto__ = e21265;
var statearr_21266_21302 = state_21219;
(statearr_21266_21302[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_21219[(4)]))){
var statearr_21267_21303 = state_21219;
(statearr_21267_21303[(1)] = cljs.core.first((state_21219[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21304 = state_21219;
state_21219 = G__21304;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2749__auto__ = function(state_21219){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2749__auto____1.call(this,state_21219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2749__auto____0;
fluree$db$query$analytical$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2749__auto____1;
return fluree$db$query$analytical$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_21268 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_21268[(6)] = c__2771__auto__);

return statearr_21268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21305){
var vec__21306 = p__21305;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21306,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21306,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21309_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__21309_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__21313 = subjects;
var vec__21314 = G__21313;
var seq__21315 = cljs.core.seq(vec__21314);
var first__21316 = cljs.core.first(seq__21315);
var seq__21315__$1 = cljs.core.next(seq__21315);
var subject = first__21316;
var r = seq__21315__$1;
var acc = expanded_map;
var G__21313__$1 = G__21313;
var acc__$1 = acc;
while(true){
var vec__21320 = G__21313__$1;
var seq__21321 = cljs.core.seq(vec__21320);
var first__21322 = cljs.core.first(seq__21321);
var seq__21321__$1 = cljs.core.next(seq__21321);
var subject__$1 = first__21322;
var r__$1 = seq__21321__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__21323 = r__$1;
var G__21324 = acc__$2;
G__21313__$1 = G__21323;
acc__$1 = G__21324;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__21313__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21320,seq__21321,first__21322,seq__21321__$1,subject__$1,r__$1,acc__$2,G__21313,vec__21314,seq__21315,first__21316,seq__21315__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__21313__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21320,seq__21321,first__21322,seq__21321__$1,subject__$1,r__$1,acc__$2,G__21313,vec__21314,seq__21315,first__21316,seq__21315__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__21313__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21320,seq__21321,first__21322,seq__21321__$1,subject__$1,r__$1,acc__$2,G__21313,vec__21314,seq__21315,first__21316,seq__21315__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__21313__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21320,seq__21321,first__21322,seq__21321__$1,subject__$1,r__$1,acc__$2,G__21313,vec__21314,seq__21315,first__21316,seq__21315__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__21313__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21320,seq__21321,first__21322,seq__21321__$1,subject__$1,r__$1,acc__$2,G__21313,vec__21314,seq__21315,first__21316,seq__21315__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__21313__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21320,seq__21321,first__21322,seq__21321__$1,subject__$1,r__$1,acc__$2,G__21313,vec__21314,seq__21315,first__21316,seq__21315__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__21325 = r__$1;
var G__21326 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__21313__$1 = G__21325;
acc__$1 = G__21326;
continue;
} else {
var G__21327 = subjects;
var G__21328 = acc_STAR_;
G__21313__$1 = G__21327;
acc__$1 = G__21328;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21329_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__21329_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_21420){
var state_val_21421 = (state_21420[(1)]);
if((state_val_21421 === (7))){
var state_21420__$1 = state_21420;
var statearr_21422_21468 = state_21420__$1;
(statearr_21422_21468[(2)] = (100));

(statearr_21422_21468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (20))){
var inst_21369 = (state_21420[(7)]);
var state_21420__$1 = state_21420;
var statearr_21423_21469 = state_21420__$1;
(statearr_21423_21469[(2)] = inst_21369);

(statearr_21423_21469[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (1))){
var state_21420__$1 = state_21420;
var statearr_21424_21470 = state_21420__$1;
(statearr_21424_21470[(2)] = null);

(statearr_21424_21470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (24))){
var inst_21406 = (state_21420[(8)]);
var inst_21407 = (state_21420[(9)]);
var inst_21408 = (state_21420[(10)]);
var inst_21341 = (state_21420[(11)]);
var inst_21411 = (function (){var max_depth = inst_21341;
var recur_map__$1 = inst_21407;
var subjects = inst_21406;
var tuples = inst_21408;
return (function (p1__21330_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__21330_SHARP_)],null));
});
})();
var inst_21412 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21411,inst_21408);
var inst_21413 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_21412);
var state_21420__$1 = state_21420;
var statearr_21425_21471 = state_21420__$1;
(statearr_21425_21471[(2)] = inst_21413);

(statearr_21425_21471[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (4))){
var inst_21331 = (state_21420[(2)]);
var state_21420__$1 = state_21420;
var statearr_21426_21472 = state_21420__$1;
(statearr_21426_21472[(2)] = inst_21331);

(statearr_21426_21472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (15))){
var inst_21354 = (state_21420[(12)]);
var inst_21365 = cljs.core.PersistentVector.EMPTY;
var inst_21366 = cljs.core.seq(inst_21354);
var inst_21367 = cljs.core.first(inst_21366);
var inst_21368 = cljs.core.next(inst_21366);
var inst_21369 = inst_21365;
var inst_21370 = inst_21354;
var state_21420__$1 = (function (){var statearr_21427 = state_21420;
(statearr_21427[(7)] = inst_21369);

(statearr_21427[(13)] = inst_21370);

(statearr_21427[(14)] = inst_21368);

(statearr_21427[(15)] = inst_21367);

return statearr_21427;
})();
var statearr_21428_21473 = state_21420__$1;
(statearr_21428_21473[(2)] = null);

(statearr_21428_21473[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (21))){
var inst_21390 = (state_21420[(2)]);
var state_21420__$1 = state_21420;
var statearr_21429_21474 = state_21420__$1;
(statearr_21429_21474[(2)] = inst_21390);

(statearr_21429_21474[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (13))){
var inst_21403 = (state_21420[(2)]);
var state_21420__$1 = state_21420;
var statearr_21430_21475 = state_21420__$1;
(statearr_21430_21475[(2)] = inst_21403);

(statearr_21430_21475[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (22))){
var inst_21369 = (state_21420[(7)]);
var inst_21377 = (state_21420[(16)]);
var inst_21384 = (state_21420[(2)]);
var inst_21385 = fluree.db.util.async.throw_err(inst_21384);
var inst_21386 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_21369,inst_21385);
var inst_21369__$1 = inst_21386;
var inst_21370 = inst_21377;
var state_21420__$1 = (function (){var statearr_21431 = state_21420;
(statearr_21431[(7)] = inst_21369__$1);

(statearr_21431[(13)] = inst_21370);

return statearr_21431;
})();
var statearr_21432_21476 = state_21420__$1;
(statearr_21432_21476[(2)] = null);

(statearr_21432_21476[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (6))){
var inst_21337 = (state_21420[(17)]);
var state_21420__$1 = state_21420;
var statearr_21433_21477 = state_21420__$1;
(statearr_21433_21477[(2)] = inst_21337);

(statearr_21433_21477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (25))){
var inst_21415 = (state_21420[(2)]);
var _ = (function (){var statearr_21434 = state_21420;
(statearr_21434[(4)] = cljs.core.rest((state_21420[(4)])));

return statearr_21434;
})();
var state_21420__$1 = state_21420;
var statearr_21435_21478 = state_21420__$1;
(statearr_21435_21478[(2)] = inst_21415);

(statearr_21435_21478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (17))){
var inst_21376 = (state_21420[(18)]);
var inst_21370 = (state_21420[(13)]);
var inst_21375 = cljs.core.seq(inst_21370);
var inst_21376__$1 = cljs.core.first(inst_21375);
var inst_21377 = cljs.core.next(inst_21375);
var state_21420__$1 = (function (){var statearr_21436 = state_21420;
(statearr_21436[(18)] = inst_21376__$1);

(statearr_21436[(16)] = inst_21377);

return statearr_21436;
})();
if(cljs.core.truth_(inst_21376__$1)){
var statearr_21437_21479 = state_21420__$1;
(statearr_21437_21479[(1)] = (19));

} else {
var statearr_21438_21480 = state_21420__$1;
(statearr_21438_21480[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (3))){
var inst_21418 = (state_21420[(2)]);
var state_21420__$1 = state_21420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21420__$1,inst_21418);
} else {
if((state_val_21421 === (12))){
var inst_21343 = (state_21420[(19)]);
var inst_21354 = (state_21420[(12)]);
var inst_21349 = cljs.core.vals(inst_21343);
var inst_21350 = cljs.core.flatten(inst_21349);
var inst_21351 = cljs.core.set(inst_21350);
var inst_21352 = cljs.core.keys(inst_21343);
var inst_21353 = cljs.core.set(inst_21352);
var inst_21354__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_21351,inst_21353);
var inst_21355 = cljs.core.empty_QMARK_(inst_21354__$1);
var state_21420__$1 = (function (){var statearr_21439 = state_21420;
(statearr_21439[(12)] = inst_21354__$1);

return statearr_21439;
})();
if(inst_21355){
var statearr_21440_21481 = state_21420__$1;
(statearr_21440_21481[(1)] = (14));

} else {
var statearr_21441_21482 = state_21420__$1;
(statearr_21441_21482[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (2))){
var inst_21337 = (state_21420[(17)]);
var _ = (function (){var statearr_21442 = state_21420;
(statearr_21442[(4)] = cljs.core.cons((5),(state_21420[(4)])));

return statearr_21442;
})();
var inst_21337__$1 = depth;
var state_21420__$1 = (function (){var statearr_21443 = state_21420;
(statearr_21443[(17)] = inst_21337__$1);

return statearr_21443;
})();
if(cljs.core.truth_(inst_21337__$1)){
var statearr_21444_21483 = state_21420__$1;
(statearr_21444_21483[(1)] = (6));

} else {
var statearr_21445_21484 = state_21420__$1;
(statearr_21445_21484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (23))){
var inst_21408 = (state_21420[(10)]);
var state_21420__$1 = state_21420;
var statearr_21446_21485 = state_21420__$1;
(statearr_21446_21485[(2)] = inst_21408);

(statearr_21446_21485[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (19))){
var inst_21376 = (state_21420[(18)]);
var inst_21379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21380 = [inst_21376,predicate];
var inst_21381 = (new cljs.core.PersistentVector(null,2,(5),inst_21379,inst_21380,null));
var inst_21382 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21381);
var state_21420__$1 = state_21420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21420__$1,(22),inst_21382);
} else {
if((state_val_21421 === (11))){
var inst_21343 = (state_21420[(19)]);
var state_21420__$1 = state_21420;
var statearr_21448_21486 = state_21420__$1;
(statearr_21448_21486[(2)] = inst_21343);

(statearr_21448_21486[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (9))){
var inst_21344 = (state_21420[(20)]);
var inst_21341 = (state_21420[(11)]);
var inst_21346 = (inst_21344 >= inst_21341);
var state_21420__$1 = state_21420;
if(cljs.core.truth_(inst_21346)){
var statearr_21449_21487 = state_21420__$1;
(statearr_21449_21487[(1)] = (11));

} else {
var statearr_21450_21488 = state_21420__$1;
(statearr_21450_21488[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (5))){
var _ = (function (){var statearr_21451 = state_21420;
(statearr_21451[(4)] = cljs.core.rest((state_21420[(4)])));

return statearr_21451;
})();
var state_21420__$1 = state_21420;
var ex21447 = (state_21420__$1[(2)]);
var statearr_21452_21489 = state_21420__$1;
(statearr_21452_21489[(5)] = ex21447);


if((ex21447 instanceof Error)){
var statearr_21453_21490 = state_21420__$1;
(statearr_21453_21490[(1)] = (4));

(statearr_21453_21490[(5)] = null);

} else {
throw ex21447;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (14))){
var inst_21343 = (state_21420[(19)]);
var state_21420__$1 = state_21420;
var statearr_21454_21491 = state_21420__$1;
(statearr_21454_21491[(2)] = inst_21343);

(statearr_21454_21491[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (16))){
var inst_21401 = (state_21420[(2)]);
var state_21420__$1 = state_21420;
var statearr_21455_21492 = state_21420__$1;
(statearr_21455_21492[(2)] = inst_21401);

(statearr_21455_21492[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (10))){
var inst_21406 = (state_21420[(8)]);
var inst_21407 = (state_21420[(9)]);
var inst_21405 = (state_21420[(2)]);
var inst_21406__$1 = cljs.core.keys(inst_21405);
var inst_21407__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_21406__$1,inst_21405);
var inst_21408 = fluree.db.query.analytical.recur_map__GT_tuples(inst_21406__$1,inst_21407__$1);
var state_21420__$1 = (function (){var statearr_21456 = state_21420;
(statearr_21456[(8)] = inst_21406__$1);

(statearr_21456[(9)] = inst_21407__$1);

(statearr_21456[(10)] = inst_21408);

return statearr_21456;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_21457_21493 = state_21420__$1;
(statearr_21457_21493[(1)] = (23));

} else {
var statearr_21458_21494 = state_21420__$1;
(statearr_21458_21494[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (18))){
var inst_21343 = (state_21420[(19)]);
var inst_21344 = (state_21420[(20)]);
var inst_21392 = (state_21420[(2)]);
var inst_21393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21394 = [(0),(2)];
var inst_21395 = (new cljs.core.PersistentVector(null,2,(5),inst_21393,inst_21394,null));
var inst_21396 = fluree.db.query.analytical.get_ns_arrays(inst_21395,inst_21392);
var inst_21397 = fluree.db.query.analytical.tuples__GT_map(inst_21343,inst_21396);
var inst_21398 = (inst_21344 + (1));
var inst_21343__$1 = inst_21397;
var inst_21344__$1 = inst_21398;
var state_21420__$1 = (function (){var statearr_21459 = state_21420;
(statearr_21459[(19)] = inst_21343__$1);

(statearr_21459[(20)] = inst_21344__$1);

return statearr_21459;
})();
var statearr_21460_21495 = state_21420__$1;
(statearr_21460_21495[(2)] = null);

(statearr_21460_21495[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21421 === (8))){
var inst_21341 = (state_21420[(2)]);
var inst_21342 = recur_map;
var inst_21343 = inst_21342;
var inst_21344 = (1);
var state_21420__$1 = (function (){var statearr_21461 = state_21420;
(statearr_21461[(19)] = inst_21343);

(statearr_21461[(20)] = inst_21344);

(statearr_21461[(11)] = inst_21341);

return statearr_21461;
})();
var statearr_21462_21496 = state_21420__$1;
(statearr_21462_21496[(2)] = null);

(statearr_21462_21496[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto____0 = (function (){
var statearr_21463 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21463[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto__);

(statearr_21463[(1)] = (1));

return statearr_21463;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto____1 = (function (state_21420){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_21420);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e21464){var ex__2752__auto__ = e21464;
var statearr_21465_21497 = state_21420;
(statearr_21465_21497[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_21420[(4)]))){
var statearr_21466_21498 = state_21420;
(statearr_21466_21498[(1)] = cljs.core.first((state_21420[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21499 = state_21420;
state_21420 = G__21499;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto__ = function(state_21420){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto____1.call(this,state_21420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_21467 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_21467[(6)] = c__2771__auto__);

return statearr_21467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__21500,clause,fuel,max_fuel){
var map__21501 = p__21500;
var map__21501__$1 = cljs.core.__destructure_map(map__21501);
var res = map__21501__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21501__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21501__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21501__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_21612){
var state_val_21613 = (state_21612[(1)]);
if((state_val_21613 === (7))){
var inst_21518 = (state_21612[(7)]);
var state_21612__$1 = state_21612;
var statearr_21614_21667 = state_21612__$1;
(statearr_21614_21667[(2)] = inst_21518);

(statearr_21614_21667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (20))){
var inst_21546 = (state_21612[(8)]);
var inst_21577 = typeof inst_21546 === 'number';
var state_21612__$1 = state_21612;
if(cljs.core.truth_(inst_21577)){
var statearr_21615_21668 = state_21612__$1;
(statearr_21615_21668[(1)] = (22));

} else {
var statearr_21616_21669 = state_21612__$1;
(statearr_21616_21669[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (27))){
var inst_21592 = (state_21612[(2)]);
var state_21612__$1 = state_21612;
var statearr_21617_21670 = state_21612__$1;
(statearr_21617_21670[(2)] = inst_21592);

(statearr_21617_21670[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (1))){
var state_21612__$1 = state_21612;
var statearr_21618_21671 = state_21612__$1;
(statearr_21618_21671[(2)] = null);

(statearr_21618_21671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (24))){
var inst_21594 = (state_21612[(2)]);
var state_21612__$1 = state_21612;
var statearr_21619_21672 = state_21612__$1;
(statearr_21619_21672[(2)] = inst_21594);

(statearr_21619_21672[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (4))){
var inst_21502 = (state_21612[(2)]);
var state_21612__$1 = state_21612;
var statearr_21620_21673 = state_21612__$1;
(statearr_21620_21673[(2)] = inst_21502);

(statearr_21620_21673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (15))){
var inst_21560 = (state_21612[(2)]);
var inst_21561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_21562 = fluree.db.query.analytical.variable_QMARK_(inst_21561);
var state_21612__$1 = (function (){var statearr_21621 = state_21612;
(statearr_21621[(9)] = inst_21560);

return statearr_21621;
})();
if(cljs.core.truth_(inst_21562)){
var statearr_21622_21674 = state_21612__$1;
(statearr_21622_21674[(1)] = (16));

} else {
var statearr_21623_21675 = state_21612__$1;
(statearr_21623_21675[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (21))){
var inst_21548 = (state_21612[(10)]);
var inst_21519 = (state_21612[(11)]);
var inst_21549 = (state_21612[(12)]);
var inst_21596 = (state_21612[(2)]);
var inst_21597 = fluree.db.query.analytical.tuples__GT_recur(db,inst_21549,inst_21596,inst_21519,inst_21548);
var state_21612__$1 = state_21612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21612__$1,(28),inst_21597);
} else {
if((state_val_21613 === (13))){
var inst_21528 = (state_21612[(13)]);
var inst_21552 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21528)].join('');
var inst_21553 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21554 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21555 = cljs.core.PersistentHashMap.fromArrays(inst_21553,inst_21554);
var inst_21556 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21552,inst_21555);
var inst_21557 = (function(){throw inst_21556})();
var state_21612__$1 = state_21612;
var statearr_21624_21676 = state_21612__$1;
(statearr_21624_21676[(2)] = inst_21557);

(statearr_21624_21676[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (22))){
var inst_21546 = (state_21612[(8)]);
var inst_21544 = (state_21612[(14)]);
var inst_21579 = cljs.core.PersistentHashMap.EMPTY;
var inst_21580 = cljs.core.flatten(inst_21544);
var inst_21581 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21579,inst_21546,inst_21580);
var state_21612__$1 = state_21612;
var statearr_21625_21677 = state_21612__$1;
(statearr_21625_21677[(2)] = inst_21581);

(statearr_21625_21677[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (6))){
var inst_21530 = (state_21612[(15)]);
var state_21612__$1 = state_21612;
var statearr_21626_21678 = state_21612__$1;
(statearr_21626_21678[(2)] = inst_21530);

(statearr_21626_21678[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (28))){
var inst_21599 = (state_21612[(2)]);
var inst_21600 = fluree.db.util.async.throw_err(inst_21599);
var state_21612__$1 = state_21612;
var statearr_21627_21679 = state_21612__$1;
(statearr_21627_21679[(2)] = inst_21600);

(statearr_21627_21679[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (25))){
var inst_21540 = (state_21612[(16)]);
var inst_21544 = (state_21612[(14)]);
var inst_21585 = cljs.core.PersistentHashMap.EMPTY;
var inst_21586 = cljs.core.first(inst_21540);
var inst_21587 = cljs.core.first(inst_21586);
var inst_21588 = cljs.core.flatten(inst_21544);
var inst_21589 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21585,inst_21587,inst_21588);
var state_21612__$1 = state_21612;
var statearr_21628_21680 = state_21612__$1;
(statearr_21628_21680[(2)] = inst_21589);

(statearr_21628_21680[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (17))){
var inst_21528 = (state_21612[(13)]);
var inst_21565 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21528)].join('');
var inst_21566 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21567 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21568 = cljs.core.PersistentHashMap.fromArrays(inst_21566,inst_21567);
var inst_21569 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21565,inst_21568);
var inst_21570 = (function(){throw inst_21569})();
var state_21612__$1 = state_21612;
var statearr_21629_21681 = state_21612__$1;
(statearr_21629_21681[(2)] = inst_21570);

(statearr_21629_21681[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (3))){
var inst_21610 = (state_21612[(2)]);
var state_21612__$1 = state_21612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21612__$1,inst_21610);
} else {
if((state_val_21613 === (12))){
var inst_21515 = (state_21612[(17)]);
var inst_21603 = (state_21612[(2)]);
var inst_21604 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_21605 = cljs.core.keys(inst_21515);
var inst_21606 = [inst_21605,vars,inst_21603];
var inst_21607 = cljs.core.PersistentHashMap.fromArrays(inst_21604,inst_21606);
var _ = (function (){var statearr_21630 = state_21612;
(statearr_21630[(4)] = cljs.core.rest((state_21612[(4)])));

return statearr_21630;
})();
var state_21612__$1 = state_21612;
var statearr_21631_21682 = state_21612__$1;
(statearr_21631_21682[(2)] = inst_21607);

(statearr_21631_21682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (2))){
var inst_21530 = (state_21612[(15)]);
var inst_21519 = (state_21612[(11)]);
var inst_21518 = (state_21612[(7)]);
var inst_21515 = (state_21612[(17)]);
var _ = (function (){var statearr_21632 = state_21612;
(statearr_21632[(4)] = cljs.core.cons((5),(state_21612[(4)])));

return statearr_21632;
})();
var inst_21512 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_21513 = cljs.core.__destructure_map(inst_21512);
var inst_21514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21513,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_21515__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21513,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_21516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21513,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_21517 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_21518__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21516);
var inst_21519__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_21516);
var inst_21521 = (function (){var map__21508 = inst_21513;
var search = inst_21514;
var rel = inst_21515__$1;
var opts = inst_21516;
var common_keys = inst_21517;
var object_fn = inst_21518__$1;
var recur_depth = inst_21519__$1;
return (function (p__21520,common_key){
var vec__21633 = p__21520;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21633,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21633,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__21636 = cljs.core._EQ_;
var expr__21637 = idx_of;
if(cljs.core.truth_((pred__21636.cljs$core$IFn$_invoke$arity$2 ? pred__21636.cljs$core$IFn$_invoke$arity$2((0),expr__21637) : pred__21636.call(null,(0),expr__21637)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__21636.cljs$core$IFn$_invoke$arity$2 ? pred__21636.cljs$core$IFn$_invoke$arity$2((1),expr__21637) : pred__21636.call(null,(1),expr__21637)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__21636.cljs$core$IFn$_invoke$arity$2 ? pred__21636.cljs$core$IFn$_invoke$arity$2((2),expr__21637) : pred__21636.call(null,(2),expr__21637)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__21637)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_21522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21523 = cljs.core.PersistentHashMap.EMPTY;
var inst_21524 = [inst_21523,inst_21514];
var inst_21525 = (new cljs.core.PersistentVector(null,2,(5),inst_21522,inst_21524,null));
var inst_21526 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21521,inst_21525,inst_21517);
var inst_21527 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21526,(0),null);
var inst_21528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21526,(1),null);
var inst_21529 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_21530__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21527);
var state_21612__$1 = (function (){var statearr_21639 = state_21612;
(statearr_21639[(18)] = inst_21529);

(statearr_21639[(15)] = inst_21530__$1);

(statearr_21639[(11)] = inst_21519__$1);

(statearr_21639[(13)] = inst_21528);

(statearr_21639[(7)] = inst_21518__$1);

(statearr_21639[(17)] = inst_21515__$1);

return statearr_21639;
})();
if(cljs.core.truth_(inst_21530__$1)){
var statearr_21640_21683 = state_21612__$1;
(statearr_21640_21683[(1)] = (6));

} else {
var statearr_21641_21684 = state_21612__$1;
(statearr_21641_21684[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (23))){
var inst_21546 = (state_21612[(8)]);
var inst_21583 = cljs.core.coll_QMARK_(inst_21546);
var state_21612__$1 = state_21612;
if(inst_21583){
var statearr_21642_21685 = state_21612__$1;
(statearr_21642_21685[(1)] = (25));

} else {
var statearr_21643_21686 = state_21612__$1;
(statearr_21643_21686[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (19))){
var inst_21544 = (state_21612[(14)]);
var inst_21574 = cljs.core.PersistentHashMap.EMPTY;
var inst_21575 = fluree.db.query.analytical.tuples__GT_map(inst_21574,inst_21544);
var state_21612__$1 = state_21612;
var statearr_21644_21687 = state_21612__$1;
(statearr_21644_21687[(2)] = inst_21575);

(statearr_21644_21687[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (11))){
var inst_21544 = (state_21612[(14)]);
var state_21612__$1 = state_21612;
var statearr_21646_21688 = state_21612__$1;
(statearr_21646_21688[(2)] = inst_21544);

(statearr_21646_21688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (9))){
var inst_21519 = (state_21612[(11)]);
var inst_21540 = (state_21612[(16)]);
var inst_21515 = (state_21612[(17)]);
var inst_21539 = (state_21612[(2)]);
var inst_21540__$1 = fluree.db.util.async.throw_err(inst_21539);
var inst_21541 = cljs.core.count(inst_21540__$1);
var inst_21542 = fluree.db.query.analytical.add_fuel(inst_21541,fuel,max_fuel);
var inst_21543 = cljs.core.vals(inst_21515);
var inst_21544 = fluree.db.query.analytical.get_ns_arrays(inst_21543,inst_21540__$1);
var state_21612__$1 = (function (){var statearr_21647 = state_21612;
(statearr_21647[(19)] = inst_21542);

(statearr_21647[(16)] = inst_21540__$1);

(statearr_21647[(14)] = inst_21544);

return statearr_21647;
})();
if(cljs.core.truth_(inst_21519)){
var statearr_21648_21689 = state_21612__$1;
(statearr_21648_21689[(1)] = (10));

} else {
var statearr_21649_21690 = state_21612__$1;
(statearr_21649_21690[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (5))){
var _ = (function (){var statearr_21650 = state_21612;
(statearr_21650[(4)] = cljs.core.rest((state_21612[(4)])));

return statearr_21650;
})();
var state_21612__$1 = state_21612;
var ex21645 = (state_21612__$1[(2)]);
var statearr_21651_21691 = state_21612__$1;
(statearr_21651_21691[(5)] = ex21645);


if((ex21645 instanceof Error)){
var statearr_21652_21692 = state_21612__$1;
(statearr_21652_21692[(1)] = (4));

(statearr_21652_21692[(5)] = null);

} else {
throw ex21645;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (14))){
var state_21612__$1 = state_21612;
var statearr_21653_21693 = state_21612__$1;
(statearr_21653_21693[(2)] = null);

(statearr_21653_21693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (26))){
var state_21612__$1 = state_21612;
var statearr_21654_21694 = state_21612__$1;
(statearr_21654_21694[(2)] = null);

(statearr_21654_21694[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (16))){
var state_21612__$1 = state_21612;
var statearr_21655_21695 = state_21612__$1;
(statearr_21655_21695[(2)] = null);

(statearr_21655_21695[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (10))){
var inst_21528 = (state_21612[(13)]);
var inst_21549 = (state_21612[(12)]);
var inst_21546 = cljs.core.first(inst_21528);
var inst_21547 = cljs.core.first(clause);
var inst_21548 = fluree.db.query.analytical.variable_QMARK_(inst_21547);
var inst_21549__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_21528,(1));
var inst_21550 = fluree.db.query.analytical.variable_QMARK_(inst_21549__$1);
var state_21612__$1 = (function (){var statearr_21656 = state_21612;
(statearr_21656[(10)] = inst_21548);

(statearr_21656[(8)] = inst_21546);

(statearr_21656[(12)] = inst_21549__$1);

return statearr_21656;
})();
if(cljs.core.truth_(inst_21550)){
var statearr_21657_21696 = state_21612__$1;
(statearr_21657_21696[(1)] = (13));

} else {
var statearr_21658_21697 = state_21612__$1;
(statearr_21658_21697[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (18))){
var inst_21548 = (state_21612[(10)]);
var inst_21572 = (state_21612[(2)]);
var state_21612__$1 = (function (){var statearr_21659 = state_21612;
(statearr_21659[(20)] = inst_21572);

return statearr_21659;
})();
if(cljs.core.truth_(inst_21548)){
var statearr_21660_21698 = state_21612__$1;
(statearr_21660_21698[(1)] = (19));

} else {
var statearr_21661_21699 = state_21612__$1;
(statearr_21661_21699[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21613 === (8))){
var inst_21529 = (state_21612[(18)]);
var inst_21528 = (state_21612[(13)]);
var inst_21534 = (state_21612[(2)]);
var inst_21535 = [inst_21534];
var inst_21536 = cljs.core.PersistentHashMap.fromArrays(inst_21529,inst_21535);
var inst_21537 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_21528,inst_21536);
var state_21612__$1 = state_21612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21612__$1,(9),inst_21537);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto____0 = (function (){
var statearr_21662 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21662[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto__);

(statearr_21662[(1)] = (1));

return statearr_21662;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto____1 = (function (state_21612){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_21612);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e21663){var ex__2752__auto__ = e21663;
var statearr_21664_21700 = state_21612;
(statearr_21664_21700[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_21612[(4)]))){
var statearr_21665_21701 = state_21612;
(statearr_21665_21701[(1)] = cljs.core.first((state_21612[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21702 = state_21612;
state_21612 = G__21702;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto__ = function(state_21612){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto____1.call(this,state_21612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_21666 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_21666[(6)] = c__2771__auto__);

return statearr_21666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__21703,res,clause){
var map__21704 = p__21703;
var map__21704__$1 = cljs.core.__destructure_map(map__21704);
var db = map__21704__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21704__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21704__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21704__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_21813){
var state_val_21814 = (state_21813[(1)]);
if((state_val_21814 === (7))){
var inst_21713 = (state_21813[(7)]);
var state_21813__$1 = state_21813;
var statearr_21815_21856 = state_21813__$1;
(statearr_21815_21856[(2)] = inst_21713);

(statearr_21815_21856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (20))){
var state_21813__$1 = state_21813;
var statearr_21816_21857 = state_21813__$1;
(statearr_21816_21857[(2)] = null);

(statearr_21816_21857[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (1))){
var state_21813__$1 = state_21813;
var statearr_21817_21858 = state_21813__$1;
(statearr_21817_21858[(2)] = null);

(statearr_21817_21858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (24))){
var inst_21715 = (state_21813[(8)]);
var inst_21786 = (state_21813[(2)]);
var inst_21787 = fluree.db.flake.sid__GT_cid(inst_21786);
var inst_21788 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_21787);
var inst_21789 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21791 = [inst_21715];
var inst_21792 = (new cljs.core.PersistentVector(null,1,(5),inst_21790,inst_21791,null));
var inst_21793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21795 = [inst_21788];
var inst_21796 = (new cljs.core.PersistentVector(null,1,(5),inst_21794,inst_21795,null));
var inst_21797 = [inst_21796];
var inst_21798 = (new cljs.core.PersistentVector(null,1,(5),inst_21793,inst_21797,null));
var inst_21799 = cljs.core.PersistentHashMap.EMPTY;
var inst_21800 = [inst_21792,inst_21798,inst_21799];
var inst_21801 = cljs.core.PersistentHashMap.fromArrays(inst_21789,inst_21800);
var state_21813__$1 = state_21813;
var statearr_21818_21859 = state_21813__$1;
(statearr_21818_21859[(2)] = inst_21801);

(statearr_21818_21859[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (4))){
var inst_21706 = (state_21813[(2)]);
var state_21813__$1 = state_21813;
var statearr_21819_21860 = state_21813__$1;
(statearr_21819_21860[(2)] = inst_21706);

(statearr_21819_21860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (15))){
var inst_21715 = (state_21813[(8)]);
var inst_21713 = (state_21813[(7)]);
var inst_21734 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_21735 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21737 = [inst_21713];
var inst_21738 = (new cljs.core.PersistentVector(null,1,(5),inst_21736,inst_21737,null));
var inst_21739 = (function (){var subject_var = inst_21713;
var object_var = inst_21715;
var min_sid = inst_21734;
var max_sid = (0);
return (function (p1__21705_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__21705_SHARP_);
});
})();
var inst_21740 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_21734,(0));
var inst_21741 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21739,inst_21740);
var inst_21742 = cljs.core.PersistentHashMap.EMPTY;
var inst_21743 = [inst_21738,inst_21741,inst_21742];
var inst_21744 = cljs.core.PersistentHashMap.fromArrays(inst_21735,inst_21743);
var state_21813__$1 = state_21813;
var statearr_21820_21861 = state_21813__$1;
(statearr_21820_21861[(2)] = inst_21744);

(statearr_21820_21861[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (21))){
var inst_21804 = (state_21813[(2)]);
var state_21813__$1 = state_21813;
var statearr_21821_21862 = state_21813__$1;
(statearr_21821_21862[(2)] = inst_21804);

(statearr_21821_21862[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (13))){
var inst_21715 = (state_21813[(8)]);
var state_21813__$1 = state_21813;
if(cljs.core.truth_(inst_21715)){
var statearr_21822_21863 = state_21813__$1;
(statearr_21822_21863[(1)] = (19));

} else {
var statearr_21823_21864 = state_21813__$1;
(statearr_21823_21864[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (22))){
var inst_21777 = (state_21813[(9)]);
var state_21813__$1 = state_21813;
var statearr_21824_21865 = state_21813__$1;
(statearr_21824_21865[(2)] = inst_21777);

(statearr_21824_21865[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (6))){
var inst_21715 = (state_21813[(8)]);
var state_21813__$1 = state_21813;
var statearr_21825_21866 = state_21813__$1;
(statearr_21825_21866[(2)] = inst_21715);

(statearr_21825_21866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (25))){
var inst_21783 = (state_21813[(2)]);
var inst_21784 = fluree.db.util.async.throw_err(inst_21783);
var state_21813__$1 = state_21813;
var statearr_21826_21867 = state_21813__$1;
(statearr_21826_21867[(2)] = inst_21784);

(statearr_21826_21867[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (17))){
var inst_21774 = (state_21813[(2)]);
var state_21813__$1 = state_21813;
var statearr_21827_21868 = state_21813__$1;
(statearr_21827_21868[(2)] = inst_21774);

(statearr_21827_21868[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (3))){
var inst_21811 = (state_21813[(2)]);
var state_21813__$1 = state_21813;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21813__$1,inst_21811);
} else {
if((state_val_21814 === (12))){
var inst_21728 = ["_tx",null,"_block",null];
var inst_21729 = (new cljs.core.PersistentArrayMap(null,2,inst_21728,null));
var inst_21730 = (new cljs.core.PersistentHashSet(null,inst_21729,null));
var inst_21731 = cljs.core.last(clause);
var inst_21732 = (inst_21730.cljs$core$IFn$_invoke$arity$1 ? inst_21730.cljs$core$IFn$_invoke$arity$1(inst_21731) : inst_21730.call(null,inst_21731));
var state_21813__$1 = state_21813;
if(cljs.core.truth_(inst_21732)){
var statearr_21828_21869 = state_21813__$1;
(statearr_21828_21869[(1)] = (15));

} else {
var statearr_21829_21870 = state_21813__$1;
(statearr_21829_21870[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (2))){
var inst_21713 = (state_21813[(7)]);
var _ = (function (){var statearr_21830 = state_21813;
(statearr_21830[(4)] = cljs.core.cons((5),(state_21813[(4)])));

return statearr_21830;
})();
var inst_21712 = cljs.core.first(clause);
var inst_21713__$1 = fluree.db.query.analytical.variable_QMARK_(inst_21712);
var inst_21714 = cljs.core.last(clause);
var inst_21715 = fluree.db.query.analytical.variable_QMARK_(inst_21714);
var state_21813__$1 = (function (){var statearr_21831 = state_21813;
(statearr_21831[(8)] = inst_21715);

(statearr_21831[(7)] = inst_21713__$1);

return statearr_21831;
})();
if(cljs.core.truth_(inst_21713__$1)){
var statearr_21832_21871 = state_21813__$1;
(statearr_21832_21871[(1)] = (6));

} else {
var statearr_21833_21872 = state_21813__$1;
(statearr_21833_21872[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (23))){
var inst_21777 = (state_21813[(9)]);
var inst_21781 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_21777);
var state_21813__$1 = state_21813;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21813__$1,(25),inst_21781);
} else {
if((state_val_21814 === (19))){
var inst_21777 = (state_21813[(9)]);
var inst_21777__$1 = cljs.core.first(clause);
var inst_21778 = typeof inst_21777__$1 === 'number';
var state_21813__$1 = (function (){var statearr_21834 = state_21813;
(statearr_21834[(9)] = inst_21777__$1);

return statearr_21834;
})();
if(cljs.core.truth_(inst_21778)){
var statearr_21835_21873 = state_21813__$1;
(statearr_21835_21873[(1)] = (22));

} else {
var statearr_21836_21874 = state_21813__$1;
(statearr_21836_21874[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (11))){
var inst_21808 = (state_21813[(2)]);
var _ = (function (){var statearr_21838 = state_21813;
(statearr_21838[(4)] = cljs.core.rest((state_21813[(4)])));

return statearr_21838;
})();
var state_21813__$1 = state_21813;
var statearr_21839_21875 = state_21813__$1;
(statearr_21839_21875[(2)] = inst_21808);

(statearr_21839_21875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (9))){
var inst_21721 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21722 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21723 = cljs.core.PersistentHashMap.fromArrays(inst_21721,inst_21722);
var inst_21724 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_21723);
var inst_21725 = (function(){throw inst_21724})();
var state_21813__$1 = state_21813;
var statearr_21840_21876 = state_21813__$1;
(statearr_21840_21876[(2)] = inst_21725);

(statearr_21840_21876[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (5))){
var _ = (function (){var statearr_21841 = state_21813;
(statearr_21841[(4)] = cljs.core.rest((state_21813[(4)])));

return statearr_21841;
})();
var state_21813__$1 = state_21813;
var ex21837 = (state_21813__$1[(2)]);
var statearr_21842_21877 = state_21813__$1;
(statearr_21842_21877[(5)] = ex21837);


if((ex21837 instanceof Error)){
var statearr_21843_21878 = state_21813__$1;
(statearr_21843_21878[(1)] = (4));

(statearr_21843_21878[(5)] = null);

} else {
throw ex21837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (14))){
var inst_21806 = (state_21813[(2)]);
var state_21813__$1 = state_21813;
var statearr_21844_21879 = state_21813__$1;
(statearr_21844_21879[(2)] = inst_21806);

(statearr_21844_21879[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (16))){
var inst_21747 = (state_21813[(10)]);
var inst_21749 = (state_21813[(11)]);
var inst_21750 = (state_21813[(12)]);
var inst_21746 = cljs.core.last(clause);
var inst_21747__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_21746);
var inst_21748 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_21749__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21748,inst_21747__$1);
var inst_21750__$1 = fluree.db.flake.min_subject_id(inst_21747__$1);
var inst_21751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21752 = [inst_21749__$1];
var inst_21753 = (new cljs.core.PersistentVector(null,1,(5),inst_21751,inst_21752,null));
var inst_21754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21755 = [inst_21750__$1];
var inst_21756 = (new cljs.core.PersistentVector(null,1,(5),inst_21754,inst_21755,null));
var inst_21757 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_21753,cljs.core._LT__EQ_,inst_21756);
var state_21813__$1 = (function (){var statearr_21845 = state_21813;
(statearr_21845[(10)] = inst_21747__$1);

(statearr_21845[(11)] = inst_21749__$1);

(statearr_21845[(12)] = inst_21750__$1);

return statearr_21845;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21813__$1,(18),inst_21757);
} else {
if((state_val_21814 === (10))){
var inst_21713 = (state_21813[(7)]);
var state_21813__$1 = state_21813;
if(cljs.core.truth_(inst_21713)){
var statearr_21846_21880 = state_21813__$1;
(statearr_21846_21880[(1)] = (12));

} else {
var statearr_21847_21881 = state_21813__$1;
(statearr_21847_21881[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (18))){
var inst_21715 = (state_21813[(8)]);
var inst_21747 = (state_21813[(10)]);
var inst_21749 = (state_21813[(11)]);
var inst_21713 = (state_21813[(7)]);
var inst_21750 = (state_21813[(12)]);
var inst_21759 = (state_21813[(2)]);
var inst_21760 = fluree.db.util.async.throw_err(inst_21759);
var inst_21761 = (function (){var subject_var = inst_21713;
var object_var = inst_21715;
var partition = inst_21747;
var max_sid = inst_21749;
var min_sid = inst_21750;
var flakes = inst_21760;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_21762 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_21761);
var inst_21763 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_21764 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_21762,inst_21763);
var inst_21765 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21767 = [inst_21713];
var inst_21768 = (new cljs.core.PersistentVector(null,1,(5),inst_21766,inst_21767,null));
var inst_21769 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_21764,inst_21760);
var inst_21770 = cljs.core.PersistentHashMap.EMPTY;
var inst_21771 = [inst_21768,inst_21769,inst_21770];
var inst_21772 = cljs.core.PersistentHashMap.fromArrays(inst_21765,inst_21771);
var state_21813__$1 = state_21813;
var statearr_21848_21882 = state_21813__$1;
(statearr_21848_21882[(2)] = inst_21772);

(statearr_21848_21882[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21814 === (8))){
var inst_21719 = (state_21813[(2)]);
var state_21813__$1 = state_21813;
if(cljs.core.truth_(inst_21719)){
var statearr_21849_21883 = state_21813__$1;
(statearr_21849_21883[(1)] = (9));

} else {
var statearr_21850_21884 = state_21813__$1;
(statearr_21850_21884[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto____0 = (function (){
var statearr_21851 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21851[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto__);

(statearr_21851[(1)] = (1));

return statearr_21851;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto____1 = (function (state_21813){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_21813);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e21852){var ex__2752__auto__ = e21852;
var statearr_21853_21885 = state_21813;
(statearr_21853_21885[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_21813[(4)]))){
var statearr_21854_21886 = state_21813;
(statearr_21854_21886[(1)] = cljs.core.first((state_21813[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21887 = state_21813;
state_21813 = G__21887;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto__ = function(state_21813){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto____1.call(this,state_21813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_21855 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_21855[(6)] = c__2771__auto__);

return statearr_21855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21894 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21894;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5522__auto__ = (function fluree$db$query$analytical$variance_$_iter__21895(s__21896){
return (new cljs.core.LazySeq(null,(function (){
var s__21896__$1 = s__21896;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__21896__$1);
if(temp__5804__auto__){
var s__21896__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21896__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__21896__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__21898 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__21897 = (0);
while(true){
if((i__21897 < size__5521__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__21897);
var delta = (x - mean);
cljs.core.chunk_append(b__21898,(delta * delta));

var G__21900 = (i__21897 + (1));
i__21897 = G__21900;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21898),fluree$db$query$analytical$variance_$_iter__21895(cljs.core.chunk_rest(s__21896__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21898),null);
}
} else {
var x = cljs.core.first(s__21896__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21895(cljs.core.rest(s__21896__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21899 = variance(coll);
return Math.sqrt(G__21899);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21901 = null;
var G__21901__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21901__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21901 = function(n,coll){
switch(arguments.length){
case 1:
return G__21901__1.call(this,n);
case 2:
return G__21901__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21901.cljs$core$IFn$_invoke$arity$1 = G__21901__1;
G__21901.cljs$core$IFn$_invoke$arity$2 = G__21901__2;
return G__21901;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21902 = null;
var G__21902__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21902__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21902 = function(n,coll){
switch(arguments.length){
case 1:
return G__21902__1.call(this,n);
case 2:
return G__21902__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21902.cljs$core$IFn$_invoke$arity$1 = G__21902__1;
G__21902.cljs$core$IFn$_invoke$arity$2 = G__21902__2;
return G__21902;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21903 = null;
var G__21903__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21903__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21903 = function(n,coll){
switch(arguments.length){
case 1:
return G__21903__1.call(this,n);
case 2:
return G__21903__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21903.cljs$core$IFn$_invoke$arity$1 = G__21903__1;
G__21903.cljs$core$IFn$_invoke$arity$2 = G__21903__2;
return G__21903;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__21904 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21904,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21904,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21904,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21907 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21910 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21910) : agg_fn.call(null,G__21910));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21907,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21907,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21911 = agg;
var map__21911__$1 = cljs.core.__destructure_map(map__21911);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21911__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21911__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21911__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21913 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21913,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21913,(1),null);
var map__21916 = res__$1;
var map__21916__$1 = cljs.core.__destructure_map(map__21916);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21916__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21916__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21912_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21912_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21917_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21917_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21918_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21918_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21919_SHARP_,p2__21920_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21919_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21920_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21921_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21921_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21924,row,b_tuple){
var vec__21925 = p__21924;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21925,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21925,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21922_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21922_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21923_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21923_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21928_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21928_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21929_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21929_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21934 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21936 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21935 = (function (p1__21930_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21930_SHARP_);
});
return fexpr__21935(G__21936);
})()),cljs.core.set(b_idxs));
var fexpr__21933 = (function (p1__21931_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21931_SHARP_);
});
return fexpr__21933(G__21934);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21932_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21932_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21937_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21937_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21938_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21938_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21943 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21945 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21944 = (function (p1__21939_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21939_SHARP_);
});
return fexpr__21944(G__21945);
})()),cljs.core.set(b_idxs));
var fexpr__21942 = (function (p1__21940_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21940_SHARP_);
});
return fexpr__21942(G__21943);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21941_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21941_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21947 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21947,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21947,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21946_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21946_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__21952 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21952,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21952,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21950_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21950_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21951_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21951_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21955,filters,optional_QMARK_){
var map__21956 = p__21955;
var map__21956__$1 = cljs.core.__destructure_map(map__21956);
var tuple_map = map__21956__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21956__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21956__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21956__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21957 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21957,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21957,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21960 = res;
var map__21960__$1 = cljs.core.__destructure_map(map__21960);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21960__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21960__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_22016){
var state_val_22017 = (state_22016[(1)]);
if((state_val_22017 === (7))){
var inst_21990 = (state_22016[(7)]);
var inst_21988 = (state_22016[(2)]);
var inst_21989 = fluree.db.util.async.throw_err(inst_21988);
var inst_21990__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21989,(0),null);
var inst_21991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21989,(1),null);
var inst_21992 = (inst_21990__$1 == null);
var state_22016__$1 = (function (){var statearr_22018 = state_22016;
(statearr_22018[(7)] = inst_21990__$1);

(statearr_22018[(8)] = inst_21991);

return statearr_22018;
})();
if(cljs.core.truth_(inst_21992)){
var statearr_22019_22048 = state_22016__$1;
(statearr_22019_22048[(1)] = (8));

} else {
var statearr_22020_22049 = state_22016__$1;
(statearr_22020_22049[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (1))){
var inst_21968 = optional_clauses;
var inst_21969 = cljs.core.seq(inst_21968);
var inst_21970 = cljs.core.first(inst_21969);
var inst_21971 = cljs.core.next(inst_21969);
var inst_21972 = where_tuples;
var inst_21973 = inst_21968;
var inst_21974 = inst_21972;
var state_22016__$1 = (function (){var statearr_22021 = state_22016;
(statearr_22021[(9)] = inst_21973);

(statearr_22021[(10)] = inst_21971);

(statearr_22021[(11)] = inst_21974);

(statearr_22021[(12)] = inst_21970);

return statearr_22021;
})();
var statearr_22022_22050 = state_22016__$1;
(statearr_22022_22050[(2)] = null);

(statearr_22022_22050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (4))){
var inst_21981 = (state_22016[(13)]);
var inst_21980 = (state_22016[(14)]);
var inst_21974 = (state_22016[(11)]);
var inst_21986 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21974,inst_21980,inst_21981,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21974,inst_21980,inst_21981,true,fuel,max_fuel,opts));
var state_22016__$1 = state_22016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22016__$1,(7),inst_21986);
} else {
if((state_val_22017 === (15))){
var state_22016__$1 = state_22016;
var statearr_22023_22051 = state_22016__$1;
(statearr_22023_22051[(2)] = null);

(statearr_22023_22051[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (13))){
var inst_22007 = (state_22016[(2)]);
var state_22016__$1 = state_22016;
var statearr_22024_22052 = state_22016__$1;
(statearr_22024_22052[(2)] = inst_22007);

(statearr_22024_22052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (6))){
var inst_22012 = (state_22016[(2)]);
var state_22016__$1 = state_22016;
var statearr_22025_22053 = state_22016__$1;
(statearr_22025_22053[(2)] = inst_22012);

(statearr_22025_22053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (3))){
var inst_22014 = (state_22016[(2)]);
var state_22016__$1 = state_22016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22016__$1,inst_22014);
} else {
if((state_val_22017 === (12))){
var state_22016__$1 = state_22016;
var statearr_22026_22054 = state_22016__$1;
(statearr_22026_22054[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (2))){
var inst_21973 = (state_22016[(9)]);
var inst_21980 = (state_22016[(14)]);
var inst_21979 = cljs.core.seq(inst_21973);
var inst_21980__$1 = cljs.core.first(inst_21979);
var inst_21981 = cljs.core.next(inst_21979);
var state_22016__$1 = (function (){var statearr_22028 = state_22016;
(statearr_22028[(13)] = inst_21981);

(statearr_22028[(14)] = inst_21980__$1);

return statearr_22028;
})();
if(cljs.core.truth_(inst_21980__$1)){
var statearr_22029_22055 = state_22016__$1;
(statearr_22029_22055[(1)] = (4));

} else {
var statearr_22030_22056 = state_22016__$1;
(statearr_22030_22056[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (11))){
var inst_21990 = (state_22016[(7)]);
var inst_21991 = (state_22016[(8)]);
var inst_21973 = inst_21991;
var inst_21974 = inst_21990;
var state_22016__$1 = (function (){var statearr_22031 = state_22016;
(statearr_22031[(9)] = inst_21973);

(statearr_22031[(11)] = inst_21974);

return statearr_22031;
})();
var statearr_22032_22057 = state_22016__$1;
(statearr_22032_22057[(2)] = null);

(statearr_22032_22057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (9))){
var inst_21980 = (state_22016[(14)]);
var inst_21996 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21980);
var state_22016__$1 = state_22016;
if(cljs.core.truth_(inst_21996)){
var statearr_22033_22058 = state_22016__$1;
(statearr_22033_22058[(1)] = (11));

} else {
var statearr_22034_22059 = state_22016__$1;
(statearr_22034_22059[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (5))){
var inst_21974 = (state_22016[(11)]);
var state_22016__$1 = state_22016;
var statearr_22035_22060 = state_22016__$1;
(statearr_22035_22060[(2)] = inst_21974);

(statearr_22035_22060[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (14))){
var inst_21990 = (state_22016[(7)]);
var inst_21991 = (state_22016[(8)]);
var inst_21974 = (state_22016[(11)]);
var inst_22001 = fluree.db.query.analytical.left_outer_join(inst_21974,inst_21990);
var inst_21973 = inst_21991;
var inst_21974__$1 = inst_22001;
var state_22016__$1 = (function (){var statearr_22036 = state_22016;
(statearr_22036[(9)] = inst_21973);

(statearr_22036[(11)] = inst_21974__$1);

return statearr_22036;
})();
var statearr_22037_22061 = state_22016__$1;
(statearr_22037_22061[(2)] = null);

(statearr_22037_22061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (16))){
var inst_22005 = (state_22016[(2)]);
var state_22016__$1 = state_22016;
var statearr_22039_22062 = state_22016__$1;
(statearr_22039_22062[(2)] = inst_22005);

(statearr_22039_22062[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (10))){
var inst_22009 = (state_22016[(2)]);
var state_22016__$1 = state_22016;
var statearr_22040_22063 = state_22016__$1;
(statearr_22040_22063[(2)] = inst_22009);

(statearr_22040_22063[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22017 === (8))){
var inst_21991 = (state_22016[(8)]);
var inst_21974 = (state_22016[(11)]);
var tmp22038 = inst_21974;
var inst_21973 = inst_21991;
var inst_21974__$1 = tmp22038;
var state_22016__$1 = (function (){var statearr_22041 = state_22016;
(statearr_22041[(9)] = inst_21973);

(statearr_22041[(11)] = inst_21974__$1);

return statearr_22041;
})();
var statearr_22042_22064 = state_22016__$1;
(statearr_22042_22064[(2)] = null);

(statearr_22042_22064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto____0 = (function (){
var statearr_22043 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22043[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto__);

(statearr_22043[(1)] = (1));

return statearr_22043;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto____1 = (function (state_22016){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_22016);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e22044){var ex__2752__auto__ = e22044;
var statearr_22045_22065 = state_22016;
(statearr_22045_22065[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_22016[(4)]))){
var statearr_22046_22066 = state_22016;
(statearr_22046_22066[(1)] = cljs.core.first((state_22016[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22067 = state_22016;
state_22016 = G__22067;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto__ = function(state_22016){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto____1.call(this,state_22016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_22047 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_22047[(6)] = c__2771__auto__);

return statearr_22047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__22069){
var vec__22070 = p__22069;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22070,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22070,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__22068_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__22068_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__22074,p__22075,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__22076 = p__22074;
var map__22076__$1 = cljs.core.__destructure_map(map__22076);
var q_map = map__22076__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22076__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__22077 = p__22075;
var map__22077__$1 = cljs.core.__destructure_map(map__22077);
var res = map__22077__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22077__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_22314){
var state_val_22315 = (state_22314[(1)]);
if((state_val_22315 === (65))){
var inst_22264 = (state_22314[(7)]);
var inst_22263 = (state_22314[(8)]);
var inst_22275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22276 = fluree.db.query.analytical.full_text__GT_tuples(inst_22263,res,inst_22264);
var inst_22277 = [inst_22276,r];
var inst_22278 = (new cljs.core.PersistentVector(null,2,(5),inst_22275,inst_22277,null));
var state_22314__$1 = state_22314;
var statearr_22316_22429 = state_22314__$1;
(statearr_22316_22429[(2)] = inst_22278);

(statearr_22316_22429[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (70))){
var inst_22290 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22317_22430 = state_22314__$1;
(statearr_22317_22430[(2)] = inst_22290);

(statearr_22317_22430[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (62))){
var inst_22264 = (state_22314[(7)]);
var inst_22272 = cljs.core.second(inst_22264);
var inst_22273 = clojure.string.starts_with_QMARK_(inst_22272,"fullText:");
var state_22314__$1 = state_22314;
if(inst_22273){
var statearr_22318_22431 = state_22314__$1;
(statearr_22318_22431[(1)] = (65));

} else {
var statearr_22319_22432 = state_22314__$1;
(statearr_22319_22432[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (7))){
var inst_22183 = (state_22314[(9)]);
var inst_22182 = cljs.core.count(clause);
var inst_22183__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_22182);
var state_22314__$1 = (function (){var statearr_22320 = state_22314;
(statearr_22320[(9)] = inst_22183__$1);

return statearr_22320;
})();
if(inst_22183__$1){
var statearr_22321_22433 = state_22314__$1;
(statearr_22321_22433[(1)] = (31));

} else {
var statearr_22322_22434 = state_22314__$1;
(statearr_22322_22434[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (59))){
var inst_22297 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22323_22435 = state_22314__$1;
(statearr_22323_22435[(2)] = inst_22297);

(statearr_22323_22435[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (20))){
var inst_22146 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22324_22436 = state_22314__$1;
(statearr_22324_22436[(2)] = inst_22146);

(statearr_22324_22436[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (58))){
var state_22314__$1 = state_22314;
var statearr_22325_22437 = state_22314__$1;
(statearr_22325_22437[(2)] = null);

(statearr_22325_22437[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (60))){
var inst_22263 = (state_22314[(8)]);
var inst_22261 = (state_22314[(2)]);
var inst_22262 = fluree.db.util.async.throw_err(inst_22261);
var inst_22263__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22262,(0),null);
var inst_22264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22262,(1),null);
var inst_22265 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_22263__$1);
var state_22314__$1 = (function (){var statearr_22326 = state_22314;
(statearr_22326[(7)] = inst_22264);

(statearr_22326[(8)] = inst_22263__$1);

return statearr_22326;
})();
if(inst_22265){
var statearr_22327_22438 = state_22314__$1;
(statearr_22327_22438[(1)] = (61));

} else {
var statearr_22328_22439 = state_22314__$1;
(statearr_22328_22439[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (27))){
var inst_22176 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22329_22440 = state_22314__$1;
(statearr_22329_22440[(2)] = inst_22176);

(statearr_22329_22440[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (1))){
var state_22314__$1 = state_22314;
var statearr_22330_22441 = state_22314__$1;
(statearr_22330_22441[(2)] = null);

(statearr_22330_22441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (69))){
var state_22314__$1 = state_22314;
var statearr_22331_22442 = state_22314__$1;
(statearr_22331_22442[(2)] = null);

(statearr_22331_22442[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (24))){
var inst_22140 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22332_22443 = state_22314__$1;
(statearr_22332_22443[(2)] = inst_22140);

(statearr_22332_22443[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (55))){
var inst_22246 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22247 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22248 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22249 = cljs.core.PersistentHashMap.fromArrays(inst_22247,inst_22248);
var inst_22250 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_22246,inst_22249);
var inst_22251 = (function(){throw inst_22250})();
var state_22314__$1 = state_22314;
var statearr_22333_22444 = state_22314__$1;
(statearr_22333_22444[(2)] = inst_22251);

(statearr_22333_22444[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (39))){
var inst_22203 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
if(cljs.core.truth_(inst_22203)){
var statearr_22334_22445 = state_22314__$1;
(statearr_22334_22445[(1)] = (40));

} else {
var statearr_22335_22446 = state_22314__$1;
(statearr_22335_22446[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (46))){
var inst_22303 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22336_22447 = state_22314__$1;
(statearr_22336_22447[(2)] = inst_22303);

(statearr_22336_22447[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (4))){
var inst_22078 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22337_22448 = state_22314__$1;
(statearr_22337_22448[(2)] = inst_22078);

(statearr_22337_22448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (54))){
var inst_22239 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22240 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22241 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22242 = cljs.core.PersistentHashMap.fromArrays(inst_22240,inst_22241);
var inst_22243 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_22239,inst_22242);
var inst_22244 = (function(){throw inst_22243})();
var state_22314__$1 = state_22314;
var statearr_22338_22449 = state_22314__$1;
(statearr_22338_22449[(2)] = inst_22244);

(statearr_22338_22449[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (15))){
var inst_22178 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22339_22450 = state_22314__$1;
(statearr_22339_22450[(2)] = inst_22178);

(statearr_22339_22450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (48))){
var inst_22227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22228 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_22229 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22228);
var inst_22230 = [inst_22229,r];
var inst_22231 = (new cljs.core.PersistentVector(null,2,(5),inst_22227,inst_22230,null));
var state_22314__$1 = state_22314;
var statearr_22340_22451 = state_22314__$1;
(statearr_22340_22451[(2)] = inst_22231);

(statearr_22340_22451[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (50))){
var inst_22301 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22341_22452 = state_22314__$1;
(statearr_22341_22452[(2)] = inst_22301);

(statearr_22341_22452[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (21))){
var inst_22112 = (state_22314[(10)]);
var inst_22124 = (state_22314[(11)]);
var inst_22116 = (state_22314[(12)]);
var inst_22091 = (state_22314[(13)]);
var inst_22115 = (state_22314[(14)]);
var inst_22117 = (state_22314[(15)]);
var inst_22087 = (state_22314[(16)]);
var inst_22123 = (state_22314[(17)]);
var inst_22114 = (state_22314[(18)]);
var inst_22128 = (state_22314[(2)]);
var inst_22129 = fluree.db.util.async.throw_err(inst_22128);
var inst_22130 = (function (){var seq__22110 = inst_22115;
var pred__22088 = inst_22091;
var new_res = inst_22129;
var rest = inst_22124;
var first__22121 = inst_22123;
var G__22108 = inst_22116;
var seq__22120 = inst_22124;
var tuples = inst_22117;
var vec__22119 = inst_22116;
var vec__22109 = inst_22112;
var first__22111 = inst_22114;
var expr__22089 = inst_22087;
var segment_type = inst_22087;
var clause_group = inst_22123;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_22131 = cljs.core.keys(vars);
var inst_22132 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_22130,inst_22129,inst_22131);
var inst_22133 = fluree.db.query.analytical.res_absorb_vars(inst_22132);
var state_22314__$1 = (function (){var statearr_22342 = state_22314;
(statearr_22342[(19)] = inst_22133);

return statearr_22342;
})();
if(cljs.core.truth_(inst_22117)){
var statearr_22343_22453 = state_22314__$1;
(statearr_22343_22453[(1)] = (22));

} else {
var statearr_22344_22454 = state_22314__$1;
(statearr_22344_22454[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (31))){
var inst_22185 = cljs.core.second(clause);
var inst_22186 = clojure.string.starts_with_QMARK_(inst_22185,"fullText:");
var state_22314__$1 = state_22314;
var statearr_22345_22455 = state_22314__$1;
(statearr_22345_22455[(2)] = inst_22186);

(statearr_22345_22455[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (32))){
var inst_22183 = (state_22314[(9)]);
var state_22314__$1 = state_22314;
var statearr_22346_22456 = state_22314__$1;
(statearr_22346_22456[(2)] = inst_22183);

(statearr_22346_22456[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (40))){
var inst_22205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22206 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_22314__$1 = (function (){var statearr_22347 = state_22314;
(statearr_22347[(20)] = inst_22205);

return statearr_22347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22314__$1,(43),inst_22206);
} else {
if((state_val_22315 === (56))){
var inst_22253 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22348_22457 = state_22314__$1;
(statearr_22348_22457[(2)] = inst_22253);

(statearr_22348_22457[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (33))){
var inst_22189 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
if(cljs.core.truth_(inst_22189)){
var statearr_22349_22458 = state_22314__$1;
(statearr_22349_22458[(1)] = (34));

} else {
var statearr_22350_22459 = state_22314__$1;
(statearr_22350_22459[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (13))){
var inst_22112 = (state_22314[(10)]);
var inst_22112__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22113 = cljs.core.seq(inst_22112__$1);
var inst_22114 = cljs.core.first(inst_22113);
var inst_22115 = cljs.core.next(inst_22113);
var inst_22116 = inst_22112__$1;
var inst_22117 = null;
var state_22314__$1 = (function (){var statearr_22351 = state_22314;
(statearr_22351[(10)] = inst_22112__$1);

(statearr_22351[(12)] = inst_22116);

(statearr_22351[(14)] = inst_22115);

(statearr_22351[(15)] = inst_22117);

(statearr_22351[(18)] = inst_22114);

return statearr_22351;
})();
var statearr_22352_22460 = state_22314__$1;
(statearr_22352_22460[(2)] = null);

(statearr_22352_22460[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (22))){
var inst_22124 = (state_22314[(11)]);
var inst_22117 = (state_22314[(15)]);
var inst_22133 = (state_22314[(19)]);
var inst_22135 = fluree.db.query.union.results(inst_22117,inst_22133);
var inst_22116 = inst_22124;
var inst_22117__$1 = inst_22135;
var state_22314__$1 = (function (){var statearr_22353 = state_22314;
(statearr_22353[(12)] = inst_22116);

(statearr_22353[(15)] = inst_22117__$1);

return statearr_22353;
})();
var statearr_22354_22461 = state_22314__$1;
(statearr_22354_22461[(2)] = null);

(statearr_22354_22461[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (36))){
var inst_22307 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22355_22462 = state_22314__$1;
(statearr_22355_22462[(2)] = inst_22307);

(statearr_22355_22462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (41))){
var inst_22213 = cljs.core.count(clause);
var inst_22214 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_22213);
var state_22314__$1 = state_22314;
if(inst_22214){
var statearr_22356_22463 = state_22314__$1;
(statearr_22356_22463[(1)] = (44));

} else {
var statearr_22357_22464 = state_22314__$1;
(statearr_22357_22464[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (43))){
var inst_22205 = (state_22314[(20)]);
var inst_22208 = (state_22314[(2)]);
var inst_22209 = fluree.db.util.async.throw_err(inst_22208);
var inst_22210 = [inst_22209,r];
var inst_22211 = (new cljs.core.PersistentVector(null,2,(5),inst_22205,inst_22210,null));
var state_22314__$1 = state_22314;
var statearr_22358_22465 = state_22314__$1;
(statearr_22358_22465[(2)] = inst_22211);

(statearr_22358_22465[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (61))){
var inst_22264 = (state_22314[(7)]);
var inst_22267 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_22264,r,res,optional_QMARK_,fuel,max_fuel);
var state_22314__$1 = state_22314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22314__$1,(64),inst_22267);
} else {
if((state_val_22315 === (29))){
var inst_22087 = (state_22314[(16)]);
var inst_22170 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_22087)].join('');
var inst_22171 = (new Error(inst_22170));
var inst_22172 = (function(){throw inst_22171})();
var state_22314__$1 = state_22314;
var statearr_22359_22466 = state_22314__$1;
(statearr_22359_22466[(2)] = inst_22172);

(statearr_22359_22466[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (44))){
var inst_22216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22217 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_22314__$1 = (function (){var statearr_22360 = state_22314;
(statearr_22360[(21)] = inst_22216);

return statearr_22360;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22314__$1,(47),inst_22217);
} else {
if((state_val_22315 === (6))){
var inst_22091 = (state_22314[(13)]);
var inst_22087 = (state_22314[(16)]);
var inst_22086 = cljs.core.keys(clause);
var inst_22087__$1 = cljs.core.first(inst_22086);
var inst_22091__$1 = cljs.core._EQ_;
var inst_22092 = (function (){var G__22361 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__22362 = inst_22087__$1;
return (inst_22091__$1.cljs$core$IFn$_invoke$arity$2 ? inst_22091__$1.cljs$core$IFn$_invoke$arity$2(G__22361,G__22362) : inst_22091__$1.call(null,G__22361,G__22362));
})();
var state_22314__$1 = (function (){var statearr_22363 = state_22314;
(statearr_22363[(13)] = inst_22091__$1);

(statearr_22363[(16)] = inst_22087__$1);

return statearr_22363;
})();
if(cljs.core.truth_(inst_22092)){
var statearr_22364_22467 = state_22314__$1;
(statearr_22364_22467[(1)] = (9));

} else {
var statearr_22365_22468 = state_22314__$1;
(statearr_22365_22468[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (28))){
var inst_22164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22165 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22166 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_22165,optional_QMARK_);
var inst_22167 = [inst_22166,r];
var inst_22168 = (new cljs.core.PersistentVector(null,2,(5),inst_22164,inst_22167,null));
var state_22314__$1 = state_22314;
var statearr_22366_22469 = state_22314__$1;
(statearr_22366_22469[(2)] = inst_22168);

(statearr_22366_22469[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (64))){
var inst_22269 = (state_22314[(2)]);
var inst_22270 = fluree.db.util.async.throw_err(inst_22269);
var state_22314__$1 = state_22314;
var statearr_22367_22470 = state_22314__$1;
(statearr_22367_22470[(2)] = inst_22270);

(statearr_22367_22470[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (51))){
var inst_22236 = cljs.core.first(clause);
var inst_22237 = cljs.core.sequential_QMARK_(inst_22236);
var state_22314__$1 = state_22314;
if(inst_22237){
var statearr_22368_22471 = state_22314__$1;
(statearr_22368_22471[(1)] = (54));

} else {
var statearr_22369_22472 = state_22314__$1;
(statearr_22369_22472[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (25))){
var inst_22091 = (state_22314[(13)]);
var inst_22087 = (state_22314[(16)]);
var inst_22152 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22153 = (function (){var segment_type = inst_22087;
var pred__22088 = inst_22091;
var expr__22089 = inst_22087;
var bindings = inst_22152;
return (function (p1__22073_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__22073_SHARP_);
});
})();
var inst_22154 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_22153,inst_22152);
var inst_22155 = cljs.core.PersistentHashMap.EMPTY;
var inst_22156 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_22155,inst_22154);
var inst_22157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22158 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22156);
var inst_22159 = [inst_22158,r];
var inst_22160 = (new cljs.core.PersistentVector(null,2,(5),inst_22157,inst_22159,null));
var state_22314__$1 = state_22314;
var statearr_22370_22473 = state_22314__$1;
(statearr_22370_22473[(2)] = inst_22160);

(statearr_22370_22473[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (34))){
var inst_22191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22192 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_22193 = [inst_22192,r];
var inst_22194 = (new cljs.core.PersistentVector(null,2,(5),inst_22191,inst_22193,null));
var state_22314__$1 = state_22314;
var statearr_22371_22474 = state_22314__$1;
(statearr_22371_22474[(2)] = inst_22194);

(statearr_22371_22474[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (17))){
var inst_22148 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22372_22475 = state_22314__$1;
(statearr_22372_22475[(2)] = inst_22148);

(statearr_22372_22475[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (3))){
var inst_22312 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22314__$1,inst_22312);
} else {
if((state_val_22315 === (12))){
var inst_22094 = (state_22314[(22)]);
var inst_22098 = (state_22314[(2)]);
var inst_22099 = fluree.db.util.async.throw_err(inst_22098);
var inst_22100 = [inst_22099,r];
var inst_22101 = (new cljs.core.PersistentVector(null,2,(5),inst_22094,inst_22100,null));
var state_22314__$1 = state_22314;
var statearr_22373_22476 = state_22314__$1;
(statearr_22373_22476[(2)] = inst_22101);

(statearr_22373_22476[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (2))){
var _ = (function (){var statearr_22374 = state_22314;
(statearr_22374[(4)] = cljs.core.cons((5),(state_22314[(4)])));

return statearr_22374;
})();
var inst_22084 = cljs.core.map_QMARK_(clause);
var state_22314__$1 = state_22314;
if(inst_22084){
var statearr_22375_22477 = state_22314__$1;
(statearr_22375_22477[(1)] = (6));

} else {
var statearr_22376_22478 = state_22314__$1;
(statearr_22376_22478[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (66))){
var state_22314__$1 = state_22314;
var statearr_22377_22479 = state_22314__$1;
(statearr_22377_22479[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (23))){
var inst_22124 = (state_22314[(11)]);
var inst_22133 = (state_22314[(19)]);
var inst_22116 = inst_22124;
var inst_22117 = inst_22133;
var state_22314__$1 = (function (){var statearr_22379 = state_22314;
(statearr_22379[(12)] = inst_22116);

(statearr_22379[(15)] = inst_22117);

return statearr_22379;
})();
var statearr_22380_22480 = state_22314__$1;
(statearr_22380_22480[(2)] = null);

(statearr_22380_22480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (47))){
var inst_22216 = (state_22314[(21)]);
var inst_22219 = (state_22314[(2)]);
var inst_22220 = fluree.db.util.async.throw_err(inst_22219);
var inst_22221 = [inst_22220,r];
var inst_22222 = (new cljs.core.PersistentVector(null,2,(5),inst_22216,inst_22221,null));
var state_22314__$1 = state_22314;
var statearr_22381_22481 = state_22314__$1;
(statearr_22381_22481[(2)] = inst_22222);

(statearr_22381_22481[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (35))){
var inst_22197 = (state_22314[(23)]);
var inst_22196 = cljs.core.count(clause);
var inst_22197__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_22196);
var state_22314__$1 = (function (){var statearr_22382 = state_22314;
(statearr_22382[(23)] = inst_22197__$1);

return statearr_22382;
})();
if(inst_22197__$1){
var statearr_22383_22482 = state_22314__$1;
(statearr_22383_22482[(1)] = (37));

} else {
var statearr_22384_22483 = state_22314__$1;
(statearr_22384_22483[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (19))){
var inst_22117 = (state_22314[(15)]);
var inst_22142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22143 = [inst_22117,r];
var inst_22144 = (new cljs.core.PersistentVector(null,2,(5),inst_22142,inst_22143,null));
var state_22314__$1 = state_22314;
var statearr_22385_22484 = state_22314__$1;
(statearr_22385_22484[(2)] = inst_22144);

(statearr_22385_22484[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (57))){
var inst_22259 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_22314__$1 = state_22314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22314__$1,(60),inst_22259);
} else {
if((state_val_22315 === (68))){
var inst_22264 = (state_22314[(7)]);
var inst_22263 = (state_22314[(8)]);
var inst_22281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22282 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_22263,res,inst_22264,fuel,max_fuel);
var state_22314__$1 = (function (){var statearr_22386 = state_22314;
(statearr_22386[(24)] = inst_22281);

return statearr_22386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22314__$1,(71),inst_22282);
} else {
if((state_val_22315 === (11))){
var inst_22180 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22388_22485 = state_22314__$1;
(statearr_22388_22485[(2)] = inst_22180);

(statearr_22388_22485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (9))){
var inst_22094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22095 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22096 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_22095,res,fuel,max_fuel,opts);
var state_22314__$1 = (function (){var statearr_22389 = state_22314;
(statearr_22389[(22)] = inst_22094);

return statearr_22389;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22314__$1,(12),inst_22096);
} else {
if((state_val_22315 === (5))){
var _ = (function (){var statearr_22390 = state_22314;
(statearr_22390[(4)] = cljs.core.rest((state_22314[(4)])));

return statearr_22390;
})();
var state_22314__$1 = state_22314;
var ex22387 = (state_22314__$1[(2)]);
var statearr_22391_22486 = state_22314__$1;
(statearr_22391_22486[(5)] = ex22387);


if((ex22387 instanceof Error)){
var statearr_22392_22487 = state_22314__$1;
(statearr_22392_22487[(1)] = (4));

(statearr_22392_22487[(5)] = null);

} else {
throw ex22387;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (14))){
var inst_22091 = (state_22314[(13)]);
var inst_22087 = (state_22314[(16)]);
var inst_22150 = (function (){var G__22393 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__22394 = inst_22087;
return (inst_22091.cljs$core$IFn$_invoke$arity$2 ? inst_22091.cljs$core$IFn$_invoke$arity$2(G__22393,G__22394) : inst_22091.call(null,G__22393,G__22394));
})();
var state_22314__$1 = state_22314;
if(cljs.core.truth_(inst_22150)){
var statearr_22395_22488 = state_22314__$1;
(statearr_22395_22488[(1)] = (25));

} else {
var statearr_22396_22489 = state_22314__$1;
(statearr_22396_22489[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (45))){
var inst_22224 = cljs.core.count(clause);
var inst_22225 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_22224);
var state_22314__$1 = state_22314;
if(inst_22225){
var statearr_22397_22490 = state_22314__$1;
(statearr_22397_22490[(1)] = (48));

} else {
var statearr_22398_22491 = state_22314__$1;
(statearr_22398_22491[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (53))){
var inst_22299 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22399_22492 = state_22314__$1;
(statearr_22399_22492[(2)] = inst_22299);

(statearr_22399_22492[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (26))){
var inst_22091 = (state_22314[(13)]);
var inst_22087 = (state_22314[(16)]);
var inst_22162 = (function (){var G__22400 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__22401 = inst_22087;
return (inst_22091.cljs$core$IFn$_invoke$arity$2 ? inst_22091.cljs$core$IFn$_invoke$arity$2(G__22400,G__22401) : inst_22091.call(null,G__22400,G__22401));
})();
var state_22314__$1 = state_22314;
if(cljs.core.truth_(inst_22162)){
var statearr_22402_22493 = state_22314__$1;
(statearr_22402_22493[(1)] = (28));

} else {
var statearr_22403_22494 = state_22314__$1;
(statearr_22403_22494[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (16))){
var inst_22116 = (state_22314[(12)]);
var inst_22123 = (state_22314[(17)]);
var inst_22122 = cljs.core.seq(inst_22116);
var inst_22123__$1 = cljs.core.first(inst_22122);
var inst_22124 = cljs.core.next(inst_22122);
var state_22314__$1 = (function (){var statearr_22404 = state_22314;
(statearr_22404[(11)] = inst_22124);

(statearr_22404[(17)] = inst_22123__$1);

return statearr_22404;
})();
if(cljs.core.truth_(inst_22123__$1)){
var statearr_22405_22495 = state_22314__$1;
(statearr_22405_22495[(1)] = (18));

} else {
var statearr_22406_22496 = state_22314__$1;
(statearr_22406_22496[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (38))){
var inst_22197 = (state_22314[(23)]);
var state_22314__$1 = state_22314;
var statearr_22407_22497 = state_22314__$1;
(statearr_22407_22497[(2)] = inst_22197);

(statearr_22407_22497[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (30))){
var inst_22174 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22408_22498 = state_22314__$1;
(statearr_22408_22498[(2)] = inst_22174);

(statearr_22408_22498[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (10))){
var inst_22091 = (state_22314[(13)]);
var inst_22087 = (state_22314[(16)]);
var inst_22103 = (function (){var G__22409 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__22410 = inst_22087;
return (inst_22091.cljs$core$IFn$_invoke$arity$2 ? inst_22091.cljs$core$IFn$_invoke$arity$2(G__22409,G__22410) : inst_22091.call(null,G__22409,G__22410));
})();
var state_22314__$1 = state_22314;
if(cljs.core.truth_(inst_22103)){
var statearr_22411_22499 = state_22314__$1;
(statearr_22411_22499[(1)] = (13));

} else {
var statearr_22412_22500 = state_22314__$1;
(statearr_22412_22500[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (18))){
var inst_22123 = (state_22314[(17)]);
var inst_22126 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_22123,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_22123,q_map,vars,fuel,max_fuel,opts));
var state_22314__$1 = state_22314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22314__$1,(21),inst_22126);
} else {
if((state_val_22315 === (52))){
var state_22314__$1 = state_22314;
var statearr_22413_22501 = state_22314__$1;
(statearr_22413_22501[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (67))){
var inst_22292 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22415_22502 = state_22314__$1;
(statearr_22415_22502[(2)] = inst_22292);

(statearr_22415_22502[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (71))){
var inst_22281 = (state_22314[(24)]);
var inst_22284 = (state_22314[(2)]);
var inst_22285 = fluree.db.util.async.throw_err(inst_22284);
var inst_22286 = [inst_22285,r];
var inst_22287 = (new cljs.core.PersistentVector(null,2,(5),inst_22281,inst_22286,null));
var state_22314__$1 = state_22314;
var statearr_22416_22503 = state_22314__$1;
(statearr_22416_22503[(2)] = inst_22287);

(statearr_22416_22503[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (42))){
var inst_22305 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22417_22504 = state_22314__$1;
(statearr_22417_22504[(2)] = inst_22305);

(statearr_22417_22504[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (37))){
var inst_22199 = cljs.core.second(clause);
var inst_22200 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22199,"rdf:type");
var state_22314__$1 = state_22314;
var statearr_22418_22505 = state_22314__$1;
(statearr_22418_22505[(2)] = inst_22200);

(statearr_22418_22505[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (63))){
var inst_22294 = (state_22314[(2)]);
var state_22314__$1 = state_22314;
var statearr_22419_22506 = state_22314__$1;
(statearr_22419_22506[(2)] = inst_22294);

(statearr_22419_22506[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (8))){
var inst_22309 = (state_22314[(2)]);
var _ = (function (){var statearr_22420 = state_22314;
(statearr_22420[(4)] = cljs.core.rest((state_22314[(4)])));

return statearr_22420;
})();
var state_22314__$1 = state_22314;
var statearr_22421_22507 = state_22314__$1;
(statearr_22421_22507[(2)] = inst_22309);

(statearr_22421_22507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22315 === (49))){
var inst_22233 = cljs.core.count(clause);
var inst_22234 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_22233);
var state_22314__$1 = state_22314;
if(inst_22234){
var statearr_22422_22508 = state_22314__$1;
(statearr_22422_22508[(1)] = (51));

} else {
var statearr_22423_22509 = state_22314__$1;
(statearr_22423_22509[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto____0 = (function (){
var statearr_22424 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22424[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto__);

(statearr_22424[(1)] = (1));

return statearr_22424;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto____1 = (function (state_22314){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_22314);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e22425){var ex__2752__auto__ = e22425;
var statearr_22426_22510 = state_22314;
(statearr_22426_22510[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_22314[(4)]))){
var statearr_22427_22511 = state_22314;
(statearr_22427_22511[(1)] = cljs.core.first((state_22314[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22512 = state_22314;
state_22314 = G__22512;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto__ = function(state_22314){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto____1.call(this,state_22314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_22428 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_22428[(6)] = c__2771__auto__);

return statearr_22428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__22514 = arguments.length;
switch (G__22514) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_22594){
var state_val_22595 = (state_22594[(1)]);
if((state_val_22595 === (7))){
var inst_22589 = (state_22594[(2)]);
var _ = (function (){var statearr_22596 = state_22594;
(statearr_22596[(4)] = cljs.core.rest((state_22594[(4)])));

return statearr_22596;
})();
var state_22594__$1 = state_22594;
var statearr_22597_22645 = state_22594__$1;
(statearr_22597_22645[(2)] = inst_22589);

(statearr_22597_22645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (20))){
var inst_22554 = (state_22594[(7)]);
var inst_22566 = (state_22594[(2)]);
var inst_22536 = inst_22554;
var inst_22537 = inst_22566;
var state_22594__$1 = (function (){var statearr_22598 = state_22594;
(statearr_22598[(8)] = inst_22536);

(statearr_22598[(9)] = inst_22537);

return statearr_22598;
})();
var statearr_22599_22646 = state_22594__$1;
(statearr_22599_22646[(2)] = null);

(statearr_22599_22646[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (1))){
var state_22594__$1 = state_22594;
var statearr_22600_22647 = state_22594__$1;
(statearr_22600_22647[(2)] = null);

(statearr_22600_22647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (24))){
var inst_22553 = (state_22594[(10)]);
var inst_22537 = (state_22594[(9)]);
var inst_22554 = (state_22594[(7)]);
var inst_22574 = fluree.db.query.analytical.inner_join(inst_22537,inst_22553);
var inst_22536 = inst_22554;
var inst_22537__$1 = inst_22574;
var state_22594__$1 = (function (){var statearr_22601 = state_22594;
(statearr_22601[(8)] = inst_22536);

(statearr_22601[(9)] = inst_22537__$1);

return statearr_22601;
})();
var statearr_22602_22648 = state_22594__$1;
(statearr_22602_22648[(2)] = null);

(statearr_22602_22648[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (4))){
var inst_22515 = (state_22594[(2)]);
var state_22594__$1 = state_22594;
var statearr_22604_22649 = state_22594__$1;
(statearr_22604_22649[(2)] = inst_22515);

(statearr_22604_22649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (15))){
var inst_22553 = (state_22594[(10)]);
var state_22594__$1 = state_22594;
if(cljs.core.truth_(inst_22553)){
var statearr_22605_22650 = state_22594__$1;
(statearr_22605_22650[(1)] = (18));

} else {
var statearr_22606_22651 = state_22594__$1;
(statearr_22606_22651[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (21))){
var inst_22537 = (state_22594[(9)]);
var inst_22554 = (state_22594[(7)]);
var tmp22603 = inst_22537;
var inst_22536 = inst_22554;
var inst_22537__$1 = tmp22603;
var state_22594__$1 = (function (){var statearr_22607 = state_22594;
(statearr_22607[(8)] = inst_22536);

(statearr_22607[(9)] = inst_22537__$1);

return statearr_22607;
})();
var statearr_22608_22652 = state_22594__$1;
(statearr_22608_22652[(2)] = null);

(statearr_22608_22652[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (13))){
var inst_22537 = (state_22594[(9)]);
var inst_22560 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_22537,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22561 = cljs.core.empty_QMARK_(inst_22560);
var state_22594__$1 = state_22594;
if(inst_22561){
var statearr_22609_22653 = state_22594__$1;
(statearr_22609_22653[(1)] = (15));

} else {
var statearr_22610_22654 = state_22594__$1;
(statearr_22610_22654[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (22))){
var state_22594__$1 = state_22594;
var statearr_22611_22655 = state_22594__$1;
(statearr_22611_22655[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (6))){
var inst_22543 = (state_22594[(11)]);
var inst_22536 = (state_22594[(8)]);
var inst_22542 = cljs.core.seq(inst_22536);
var inst_22543__$1 = cljs.core.first(inst_22542);
var inst_22544 = cljs.core.next(inst_22542);
var state_22594__$1 = (function (){var statearr_22613 = state_22594;
(statearr_22613[(11)] = inst_22543__$1);

(statearr_22613[(12)] = inst_22544);

return statearr_22613;
})();
if(cljs.core.truth_(inst_22543__$1)){
var statearr_22614_22656 = state_22594__$1;
(statearr_22614_22656[(1)] = (8));

} else {
var statearr_22615_22657 = state_22594__$1;
(statearr_22615_22657[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (25))){
var state_22594__$1 = state_22594;
var statearr_22616_22658 = state_22594__$1;
(statearr_22616_22658[(2)] = null);

(statearr_22616_22658[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (17))){
var inst_22582 = (state_22594[(2)]);
var state_22594__$1 = state_22594;
var statearr_22617_22659 = state_22594__$1;
(statearr_22617_22659[(2)] = inst_22582);

(statearr_22617_22659[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (3))){
var inst_22592 = (state_22594[(2)]);
var state_22594__$1 = state_22594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22594__$1,inst_22592);
} else {
if((state_val_22595 === (12))){
var inst_22553 = (state_22594[(10)]);
var inst_22554 = (state_22594[(7)]);
var inst_22536 = inst_22554;
var inst_22537 = inst_22553;
var state_22594__$1 = (function (){var statearr_22618 = state_22594;
(statearr_22618[(8)] = inst_22536);

(statearr_22618[(9)] = inst_22537);

return statearr_22618;
})();
var statearr_22619_22660 = state_22594__$1;
(statearr_22619_22660[(2)] = null);

(statearr_22619_22660[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (2))){
var _ = (function (){var statearr_22620 = state_22594;
(statearr_22620[(4)] = cljs.core.cons((5),(state_22594[(4)])));

return statearr_22620;
})();
var inst_22528 = where;
var inst_22529 = cljs.core.seq(inst_22528);
var inst_22530 = cljs.core.first(inst_22529);
var inst_22531 = cljs.core.next(inst_22529);
var inst_22532 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_22533 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_22534 = [inst_22533];
var inst_22535 = cljs.core.PersistentHashMap.fromArrays(inst_22532,inst_22534);
var inst_22536 = inst_22528;
var inst_22537 = inst_22535;
var state_22594__$1 = (function (){var statearr_22621 = state_22594;
(statearr_22621[(13)] = inst_22531);

(statearr_22621[(8)] = inst_22536);

(statearr_22621[(14)] = inst_22530);

(statearr_22621[(9)] = inst_22537);

return statearr_22621;
})();
var statearr_22622_22661 = state_22594__$1;
(statearr_22622_22661[(2)] = null);

(statearr_22622_22661[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (23))){
var inst_22580 = (state_22594[(2)]);
var state_22594__$1 = state_22594;
var statearr_22623_22662 = state_22594__$1;
(statearr_22623_22662[(2)] = inst_22580);

(statearr_22623_22662[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (19))){
var inst_22537 = (state_22594[(9)]);
var state_22594__$1 = state_22594;
var statearr_22624_22663 = state_22594__$1;
(statearr_22624_22663[(2)] = inst_22537);

(statearr_22624_22663[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (11))){
var inst_22543 = (state_22594[(11)]);
var inst_22551 = (state_22594[(2)]);
var inst_22552 = fluree.db.util.async.throw_err(inst_22551);
var inst_22553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22552,(0),null);
var inst_22554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22552,(1),null);
var inst_22555 = cljs.core.count(inst_22543);
var inst_22556 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_22555);
var state_22594__$1 = (function (){var statearr_22626 = state_22594;
(statearr_22626[(10)] = inst_22553);

(statearr_22626[(7)] = inst_22554);

return statearr_22626;
})();
if(inst_22556){
var statearr_22627_22664 = state_22594__$1;
(statearr_22627_22664[(1)] = (12));

} else {
var statearr_22628_22665 = state_22594__$1;
(statearr_22628_22665[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (9))){
var inst_22537 = (state_22594[(9)]);
var state_22594__$1 = state_22594;
var statearr_22629_22666 = state_22594__$1;
(statearr_22629_22666[(2)] = inst_22537);

(statearr_22629_22666[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (5))){
var _ = (function (){var statearr_22630 = state_22594;
(statearr_22630[(4)] = cljs.core.rest((state_22594[(4)])));

return statearr_22630;
})();
var state_22594__$1 = state_22594;
var ex22625 = (state_22594__$1[(2)]);
var statearr_22631_22667 = state_22594__$1;
(statearr_22631_22667[(5)] = ex22625);


if((ex22625 instanceof Error)){
var statearr_22632_22668 = state_22594__$1;
(statearr_22632_22668[(1)] = (4));

(statearr_22632_22668[(5)] = null);

} else {
throw ex22625;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (14))){
var inst_22584 = (state_22594[(2)]);
var state_22594__$1 = state_22594;
var statearr_22633_22669 = state_22594__$1;
(statearr_22633_22669[(2)] = inst_22584);

(statearr_22633_22669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (26))){
var inst_22578 = (state_22594[(2)]);
var state_22594__$1 = state_22594;
var statearr_22634_22670 = state_22594__$1;
(statearr_22634_22670[(2)] = inst_22578);

(statearr_22634_22670[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (16))){
var inst_22553 = (state_22594[(10)]);
var inst_22569 = (inst_22553 == null);
var state_22594__$1 = state_22594;
if(cljs.core.truth_(inst_22569)){
var statearr_22635_22671 = state_22594__$1;
(statearr_22635_22671[(1)] = (21));

} else {
var statearr_22636_22672 = state_22594__$1;
(statearr_22636_22672[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (10))){
var inst_22587 = (state_22594[(2)]);
var state_22594__$1 = state_22594;
var statearr_22637_22673 = state_22594__$1;
(statearr_22637_22673[(2)] = inst_22587);

(statearr_22637_22673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (18))){
var inst_22553 = (state_22594[(10)]);
var state_22594__$1 = state_22594;
var statearr_22638_22674 = state_22594__$1;
(statearr_22638_22674[(2)] = inst_22553);

(statearr_22638_22674[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22595 === (8))){
var inst_22543 = (state_22594[(11)]);
var inst_22544 = (state_22594[(12)]);
var inst_22537 = (state_22594[(9)]);
var inst_22549 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_22537,inst_22543,inst_22544,false,fuel,max_fuel,opts);
var state_22594__$1 = state_22594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22594__$1,(11),inst_22549);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2749__auto__ = null;
var fluree$db$query$analytical$state_machine__2749__auto____0 = (function (){
var statearr_22639 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22639[(0)] = fluree$db$query$analytical$state_machine__2749__auto__);

(statearr_22639[(1)] = (1));

return statearr_22639;
});
var fluree$db$query$analytical$state_machine__2749__auto____1 = (function (state_22594){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_22594);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e22640){var ex__2752__auto__ = e22640;
var statearr_22641_22675 = state_22594;
(statearr_22641_22675[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_22594[(4)]))){
var statearr_22642_22676 = state_22594;
(statearr_22642_22676[(1)] = cljs.core.first((state_22594[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22677 = state_22594;
state_22594 = G__22677;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2749__auto__ = function(state_22594){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2749__auto____1.call(this,state_22594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2749__auto____0;
fluree$db$query$analytical$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2749__auto____1;
return fluree$db$query$analytical$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_22643 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_22643[(6)] = c__2771__auto__);

return statearr_22643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_22712){
var state_val_22713 = (state_22712[(1)]);
if((state_val_22713 === (7))){
var inst_22689 = (state_22712[(7)]);
var inst_22694 = (state_22712[(8)]);
var inst_22696 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_22689,inst_22694,fuel,max_fuel,opts);
var state_22712__$1 = state_22712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22712__$1,(10),inst_22696);
} else {
if((state_val_22713 === (1))){
var state_22712__$1 = state_22712;
var statearr_22714_22739 = state_22712__$1;
(statearr_22714_22739[(2)] = null);

(statearr_22714_22739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (4))){
var inst_22678 = (state_22712[(2)]);
var state_22712__$1 = state_22712;
var statearr_22715_22740 = state_22712__$1;
(statearr_22715_22740[(2)] = inst_22678);

(statearr_22715_22740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (13))){
var inst_22707 = (state_22712[(2)]);
var _ = (function (){var statearr_22716 = state_22712;
(statearr_22716[(4)] = cljs.core.rest((state_22712[(4)])));

return statearr_22716;
})();
var state_22712__$1 = state_22712;
var statearr_22717_22741 = state_22712__$1;
(statearr_22717_22741[(2)] = inst_22707);

(statearr_22717_22741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (6))){
var inst_22689 = (state_22712[(7)]);
var inst_22693 = (state_22712[(2)]);
var inst_22694 = fluree.db.util.async.throw_err(inst_22693);
var state_22712__$1 = (function (){var statearr_22718 = state_22712;
(statearr_22718[(8)] = inst_22694);

return statearr_22718;
})();
if(cljs.core.truth_(inst_22689)){
var statearr_22719_22742 = state_22712__$1;
(statearr_22719_22742[(1)] = (7));

} else {
var statearr_22720_22743 = state_22712__$1;
(statearr_22720_22743[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (3))){
var inst_22710 = (state_22712[(2)]);
var state_22712__$1 = state_22712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22712__$1,inst_22710);
} else {
if((state_val_22713 === (12))){
var inst_22702 = (state_22712[(9)]);
var state_22712__$1 = state_22712;
var statearr_22721_22744 = state_22712__$1;
(statearr_22721_22744[(2)] = inst_22702);

(statearr_22721_22744[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (2))){
var _ = (function (){var statearr_22722 = state_22712;
(statearr_22722[(4)] = cljs.core.cons((5),(state_22712[(4)])));

return statearr_22722;
})();
var inst_22685 = q_map;
var inst_22686 = cljs.core.__destructure_map(inst_22685);
var inst_22687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22686,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22686,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_22689 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22686,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_22690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22686,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_22691 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_22688,q_map,inst_22687,fuel,max_fuel,opts);
var state_22712__$1 = (function (){var statearr_22723 = state_22712;
(statearr_22723[(7)] = inst_22689);

(statearr_22723[(10)] = inst_22690);

return statearr_22723;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22712__$1,(6),inst_22691);
} else {
if((state_val_22713 === (11))){
var inst_22702 = (state_22712[(9)]);
var inst_22690 = (state_22712[(10)]);
var inst_22704 = fluree.db.query.analytical.tuples__GT_filtered(inst_22702,inst_22690,null);
var state_22712__$1 = state_22712;
var statearr_22725_22745 = state_22712__$1;
(statearr_22725_22745[(2)] = inst_22704);

(statearr_22725_22745[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (9))){
var inst_22690 = (state_22712[(10)]);
var inst_22702 = (state_22712[(2)]);
var state_22712__$1 = (function (){var statearr_22726 = state_22712;
(statearr_22726[(9)] = inst_22702);

return statearr_22726;
})();
if(cljs.core.truth_(inst_22690)){
var statearr_22727_22746 = state_22712__$1;
(statearr_22727_22746[(1)] = (11));

} else {
var statearr_22728_22747 = state_22712__$1;
(statearr_22728_22747[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (5))){
var _ = (function (){var statearr_22729 = state_22712;
(statearr_22729[(4)] = cljs.core.rest((state_22712[(4)])));

return statearr_22729;
})();
var state_22712__$1 = state_22712;
var ex22724 = (state_22712__$1[(2)]);
var statearr_22730_22748 = state_22712__$1;
(statearr_22730_22748[(5)] = ex22724);


if((ex22724 instanceof Error)){
var statearr_22731_22749 = state_22712__$1;
(statearr_22731_22749[(1)] = (4));

(statearr_22731_22749[(5)] = null);

} else {
throw ex22724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (10))){
var inst_22698 = (state_22712[(2)]);
var inst_22699 = fluree.db.util.async.throw_err(inst_22698);
var state_22712__$1 = state_22712;
var statearr_22732_22750 = state_22712__$1;
(statearr_22732_22750[(2)] = inst_22699);

(statearr_22732_22750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22713 === (8))){
var inst_22694 = (state_22712[(8)]);
var state_22712__$1 = state_22712;
var statearr_22733_22751 = state_22712__$1;
(statearr_22733_22751[(2)] = inst_22694);

(statearr_22733_22751[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2749__auto____0 = (function (){
var statearr_22734 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22734[(0)] = fluree$db$query$analytical$q_$_state_machine__2749__auto__);

(statearr_22734[(1)] = (1));

return statearr_22734;
});
var fluree$db$query$analytical$q_$_state_machine__2749__auto____1 = (function (state_22712){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_22712);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e22735){var ex__2752__auto__ = e22735;
var statearr_22736_22752 = state_22712;
(statearr_22736_22752[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_22712[(4)]))){
var statearr_22737_22753 = state_22712;
(statearr_22737_22753[(1)] = cljs.core.first((state_22712[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22754 = state_22712;
state_22712 = G__22754;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2749__auto__ = function(state_22712){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2749__auto____1.call(this,state_22712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2749__auto____0;
fluree$db$query$analytical$q_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2749__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_22738 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_22738[(6)] = c__2771__auto__);

return statearr_22738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
