// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20769_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20769_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__20773 = coll;
var vec__20774 = G__20773;
var seq__20775 = cljs.core.seq(vec__20774);
var first__20776 = cljs.core.first(seq__20775);
var seq__20775__$1 = cljs.core.next(seq__20775);
var clause = first__20776;
var r = seq__20775__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20773__$1 = G__20773;
var res__$1 = res;
while(true){
var vec__20780 = G__20773__$1;
var seq__20781 = cljs.core.seq(vec__20780);
var first__20782 = cljs.core.first(seq__20781);
var seq__20781__$1 = cljs.core.next(seq__20781);
var clause__$1 = first__20782;
var r__$1 = seq__20781__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20783 = r__$1;
var G__20784 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__20773__$1 = G__20783;
res__$1 = G__20784;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__20785){
var map__20786 = p__20785;
var map__20786__$1 = cljs.core.__destructure_map(map__20786);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20786__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__20790 = coll;
var vec__20791 = G__20790;
var seq__20792 = cljs.core.seq(vec__20791);
var first__20793 = cljs.core.first(seq__20792);
var seq__20792__$1 = cljs.core.next(seq__20792);
var clause = first__20793;
var r = seq__20792__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20790__$1 = G__20790;
var res__$1 = res;
while(true){
var vec__20797 = G__20790__$1;
var seq__20798 = cljs.core.seq(vec__20797);
var first__20799 = cljs.core.first(seq__20798);
var seq__20798__$1 = cljs.core.next(seq__20798);
var clause__$1 = first__20799;
var r__$1 = seq__20798__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20800 = r__$1;
var G__20801 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__20790__$1 = G__20800;
res__$1 = G__20801;
continue;
} else {
var G__20802 = r__$1;
var G__20803 = res__$2;
G__20790__$1 = G__20802;
res__$1 = G__20803;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__20807 = coll;
var vec__20808 = G__20807;
var seq__20809 = cljs.core.seq(vec__20808);
var first__20810 = cljs.core.first(seq__20809);
var seq__20809__$1 = cljs.core.next(seq__20809);
var clause = first__20810;
var r = seq__20809__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20807__$1 = G__20807;
var res__$1 = res;
while(true){
var vec__20814 = G__20807__$1;
var seq__20815 = cljs.core.seq(vec__20814);
var first__20816 = cljs.core.first(seq__20815);
var seq__20815__$1 = cljs.core.next(seq__20815);
var clause__$1 = first__20816;
var r__$1 = seq__20815__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20817 = r__$1;
var G__20818 = res__$2;
G__20807__$1 = G__20817;
res__$1 = G__20818;
continue;
} else {
var G__20819 = r__$1;
var G__20820 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__20807__$1 = G__20819;
res__$1 = G__20820;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__20823 = clause;
var G__20823__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__20823):G__20823);
var G__20823__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__20823__$1)
;
var G__20823__$3 = (function (){var fexpr__20824 = (function (p1__20821_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20821_SHARP_)," ."].join('');
});
return fexpr__20824(G__20823__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__20825 = (function (p1__20822_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20822_SHARP_),"}"].join('');
});
return fexpr__20825(G__20823__$3);
} else {
return G__20823__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__20829 = opts;
var map__20829__$1 = cljs.core.__destructure_map(map__20829);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20829__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20829__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20829__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20829__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20829__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20826_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20826_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20827_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20827_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20828_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20828_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_20843){
var state_val_20844 = (state_20843[(1)]);
if((state_val_20844 === (1))){
var inst_20830 = fluree.db.util.core.url_encode(query);
var inst_20831 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20830)].join('');
var inst_20832 = ["User-Agent","Accept"];
var inst_20833 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_20834 = cljs.core.PersistentHashMap.fromArrays(inst_20832,inst_20833);
var inst_20835 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_20836 = [inst_20834,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_20837 = cljs.core.PersistentHashMap.fromArrays(inst_20835,inst_20836);
var inst_20838 = fluree.db.util.xhttp.get(inst_20831,inst_20837);
var state_20843__$1 = state_20843;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20843__$1,(2),inst_20838);
} else {
if((state_val_20844 === (2))){
var inst_20840 = (state_20843[(2)]);
var inst_20841 = fluree.db.util.async.throw_err(inst_20840);
var state_20843__$1 = state_20843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20843__$1,inst_20841);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto____0 = (function (){
var statearr_20845 = [null,null,null,null,null,null,null];
(statearr_20845[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto__);

(statearr_20845[(1)] = (1));

return statearr_20845;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto____1 = (function (state_20843){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_20843);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e20846){var ex__2752__auto__ = e20846;
var statearr_20847_20850 = state_20843;
(statearr_20847_20850[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_20843[(4)]))){
var statearr_20848_20851 = state_20843;
(statearr_20848_20851[(1)] = cljs.core.first((state_20843[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20852 = state_20843;
state_20843 = G__20852;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto__ = function(state_20843){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto____1.call(this,state_20843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_20849 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_20849[(6)] = c__2771__auto__);

return statearr_20849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_20870){
var state_val_20871 = (state_20870[(1)]);
if((state_val_20871 === (1))){
var inst_20853 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_20870__$1 = state_20870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20870__$1,(2),inst_20853);
} else {
if((state_val_20871 === (2))){
var inst_20856 = (state_20870[(7)]);
var inst_20855 = (state_20870[(2)]);
var inst_20856__$1 = fluree.db.util.async.throw_err(inst_20855);
var inst_20857 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20856__$1);
var inst_20858 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_20857);
var state_20870__$1 = (function (){var statearr_20872 = state_20870;
(statearr_20872[(7)] = inst_20856__$1);

return statearr_20872;
})();
if(inst_20858){
var statearr_20873_20882 = state_20870__$1;
(statearr_20873_20882[(1)] = (3));

} else {
var statearr_20874_20883 = state_20870__$1;
(statearr_20874_20883[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20871 === (3))){
var inst_20856 = (state_20870[(7)]);
var state_20870__$1 = state_20870;
var statearr_20875_20884 = state_20870__$1;
(statearr_20875_20884[(2)] = inst_20856);

(statearr_20875_20884[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20871 === (4))){
var inst_20856 = (state_20870[(7)]);
var inst_20861 = (function (){var body = inst_20856;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20862 = cljs.core.second(inst_20856);
var inst_20863 = cljs.core.second(inst_20862);
var inst_20864 = cljs.core.first(inst_20863);
var inst_20865 = cljs.core.second(inst_20864);
var inst_20866 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20861,inst_20865);
var state_20870__$1 = state_20870;
var statearr_20876_20885 = state_20870__$1;
(statearr_20876_20885[(2)] = inst_20866);

(statearr_20876_20885[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20871 === (5))){
var inst_20868 = (state_20870[(2)]);
var state_20870__$1 = state_20870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20870__$1,inst_20868);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto____0 = (function (){
var statearr_20877 = [null,null,null,null,null,null,null,null];
(statearr_20877[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto__);

(statearr_20877[(1)] = (1));

return statearr_20877;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto____1 = (function (state_20870){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_20870);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e20878){var ex__2752__auto__ = e20878;
var statearr_20879_20886 = state_20870;
(statearr_20879_20886[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_20870[(4)]))){
var statearr_20880_20887 = state_20870;
(statearr_20880_20887[(1)] = cljs.core.first((state_20870[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20888 = state_20870;
state_20870 = G__20888;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto__ = function(state_20870){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto____1.call(this,state_20870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_20881 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_20881[(6)] = c__2771__auto__);

return statearr_20881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20889_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20889_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20890_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20890_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20891_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20891_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20891_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20891_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_20937){
var state_val_20938 = (state_20937[(1)]);
if((state_val_20938 === (7))){
var inst_20902 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20937__$1 = state_20937;
var statearr_20939_20967 = state_20937__$1;
(statearr_20939_20967[(2)] = inst_20902);

(statearr_20939_20967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (1))){
var state_20937__$1 = state_20937;
var statearr_20940_20968 = state_20937__$1;
(statearr_20940_20968[(2)] = null);

(statearr_20940_20968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (4))){
var inst_20892 = (state_20937[(2)]);
var state_20937__$1 = state_20937;
var statearr_20941_20969 = state_20937__$1;
(statearr_20941_20969[(2)] = inst_20892);

(statearr_20941_20969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (15))){
var inst_20910 = (state_20937[(7)]);
var inst_20911 = (state_20937[(8)]);
var inst_20916 = (state_20937[(9)]);
var inst_20921 = (state_20937[(2)]);
var inst_20922 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20916,(0),inst_20921);
var inst_20923 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20924 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20910);
var inst_20925 = [inst_20911,inst_20924];
var inst_20926 = cljs.core.PersistentHashMap.fromArrays(inst_20923,inst_20925);
var inst_20927 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20922,inst_20926);
var inst_20928 = (function(){throw inst_20927})();
var state_20937__$1 = state_20937;
var statearr_20942_20970 = state_20937__$1;
(statearr_20942_20970[(2)] = inst_20928);

(statearr_20942_20970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (13))){
var inst_20915 = (state_20937[(10)]);
var state_20937__$1 = state_20937;
var statearr_20943_20971 = state_20937__$1;
(statearr_20943_20971[(2)] = inst_20915);

(statearr_20943_20971[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (6))){
var state_20937__$1 = state_20937;
var statearr_20944_20972 = state_20937__$1;
(statearr_20944_20972[(2)] = null);

(statearr_20944_20972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (3))){
var inst_20935 = (state_20937[(2)]);
var state_20937__$1 = state_20937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20937__$1,inst_20935);
} else {
if((state_val_20938 === (12))){
var inst_20932 = (state_20937[(2)]);
var _ = (function (){var statearr_20945 = state_20937;
(statearr_20945[(4)] = cljs.core.rest((state_20937[(4)])));

return statearr_20945;
})();
var state_20937__$1 = state_20937;
var statearr_20946_20973 = state_20937__$1;
(statearr_20946_20973[(2)] = inst_20932);

(statearr_20946_20973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (2))){
var _ = (function (){var statearr_20947 = state_20937;
(statearr_20947[(4)] = cljs.core.cons((5),(state_20937[(4)])));

return statearr_20947;
})();
var inst_20899 = cljs.core.empty_QMARK_(matching_vars);
var state_20937__$1 = state_20937;
if(inst_20899){
var statearr_20948_20974 = state_20937__$1;
(statearr_20948_20974[(1)] = (6));

} else {
var statearr_20949_20975 = state_20937__$1;
(statearr_20949_20975[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (11))){
var inst_20910 = (state_20937[(7)]);
var inst_20930 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20910,all_vars);
var state_20937__$1 = state_20937;
var statearr_20951_20976 = state_20937__$1;
(statearr_20951_20976[(2)] = inst_20930);

(statearr_20951_20976[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (9))){
var inst_20910 = (state_20937[(7)]);
var inst_20911 = (state_20937[(8)]);
var inst_20908 = (state_20937[(2)]);
var inst_20909 = fluree.db.util.async.throw_err(inst_20908);
var inst_20910__$1 = cljs.core.__destructure_map(inst_20909);
var inst_20911__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20910__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20910__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20913 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20911__$1);
var state_20937__$1 = (function (){var statearr_20952 = state_20937;
(statearr_20952[(7)] = inst_20910__$1);

(statearr_20952[(8)] = inst_20911__$1);

(statearr_20952[(11)] = inst_20912);

return statearr_20952;
})();
if(inst_20913){
var statearr_20953_20977 = state_20937__$1;
(statearr_20953_20977[(1)] = (10));

} else {
var statearr_20954_20978 = state_20937__$1;
(statearr_20954_20978[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (5))){
var _ = (function (){var statearr_20955 = state_20937;
(statearr_20955[(4)] = cljs.core.rest((state_20937[(4)])));

return statearr_20955;
})();
var state_20937__$1 = state_20937;
var ex20950 = (state_20937__$1[(2)]);
var statearr_20956_20979 = state_20937__$1;
(statearr_20956_20979[(5)] = ex20950);


if((ex20950 instanceof Error)){
var statearr_20957_20980 = state_20937__$1;
(statearr_20957_20980[(1)] = (4));

(statearr_20957_20980[(5)] = null);

} else {
throw ex20950;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (14))){
var state_20937__$1 = state_20937;
var statearr_20958_20981 = state_20937__$1;
(statearr_20958_20981[(2)] = (1000));

(statearr_20958_20981[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (10))){
var inst_20910 = (state_20937[(7)]);
var inst_20915 = (state_20937[(10)]);
var inst_20912 = (state_20937[(11)]);
var inst_20915__$1 = cljs.core.count(inst_20912);
var inst_20916 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20910);
var inst_20917 = (inst_20915__$1 < (1000));
var state_20937__$1 = (function (){var statearr_20959 = state_20937;
(statearr_20959[(10)] = inst_20915__$1);

(statearr_20959[(9)] = inst_20916);

return statearr_20959;
})();
if(cljs.core.truth_(inst_20917)){
var statearr_20960_20982 = state_20937__$1;
(statearr_20960_20982[(1)] = (13));

} else {
var statearr_20961_20983 = state_20937__$1;
(statearr_20961_20983[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20938 === (8))){
var inst_20904 = (state_20937[(2)]);
var inst_20905 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20904,optional_clauses);
var inst_20906 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20905);
var state_20937__$1 = state_20937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20937__$1,(9),inst_20906);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto____0 = (function (){
var statearr_20962 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20962[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto__);

(statearr_20962[(1)] = (1));

return statearr_20962;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto____1 = (function (state_20937){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_20937);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e20963){var ex__2752__auto__ = e20963;
var statearr_20964_20984 = state_20937;
(statearr_20964_20984[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_20937[(4)]))){
var statearr_20965_20985 = state_20937;
(statearr_20965_20985[(1)] = cljs.core.first((state_20937[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20986 = state_20937;
state_20937 = G__20986;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto__ = function(state_20937){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto____1.call(this,state_20937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_20966 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_20966[(6)] = c__2771__auto__);

return statearr_20966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
