// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14572 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14572,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14572,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14572,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14572,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14572,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14572,(5),null);
var G__14575 = idx;
var G__14575__$1 = (((G__14575 instanceof cljs.core.Keyword))?G__14575.fqn:null);
switch (G__14575__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14575__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14577 = idx;
var G__14577__$1 = (((G__14577 instanceof cljs.core.Keyword))?G__14577.fqn:null);
switch (G__14577__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14577__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14579 = idx;
var G__14579__$1 = (((G__14579 instanceof cljs.core.Keyword))?G__14579.fqn:null);
switch (G__14579__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14579__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14582 = arguments.length;
switch (G__14582) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14583 = (function (){var pred__14586 = cljs.core.identical_QMARK_;
var expr__14587 = test;
if(cljs.core.truth_((pred__14586.cljs$core$IFn$_invoke$arity$2 ? pred__14586.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14587) : pred__14586.call(null,cljs.core._EQ_,expr__14587)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14586.cljs$core$IFn$_invoke$arity$2 ? pred__14586.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14587) : pred__14586.call(null,cljs.core._LT_,expr__14587)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14586.cljs$core$IFn$_invoke$arity$2 ? pred__14586.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14587) : pred__14586.call(null,cljs.core._LT__EQ_,expr__14587)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14586.cljs$core$IFn$_invoke$arity$2 ? pred__14586.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14587) : pred__14586.call(null,cljs.core._GT_,expr__14587)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14586.cljs$core$IFn$_invoke$arity$2 ? pred__14586.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14587) : pred__14586.call(null,cljs.core._GT__EQ_,expr__14587)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14587)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14583,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14583,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14583,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14583,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_14826){
var state_val_14827 = (state_14826[(1)]);
if((state_val_14827 === (65))){
var inst_14797 = (state_14826[(7)]);
var inst_14741 = (state_14826[(8)]);
var inst_14797__$1 = (state_14826[(2)]);
var inst_14798 = cljs.core.count(inst_14797__$1);
var state_14826__$1 = (function (){var statearr_14828 = state_14826;
(statearr_14828[(7)] = inst_14797__$1);

(statearr_14828[(9)] = inst_14798);

return statearr_14828;
})();
if(cljs.core.truth_(inst_14741)){
var statearr_14829_14966 = state_14826__$1;
(statearr_14829_14966[(1)] = (81));

} else {
var statearr_14830_14967 = state_14826__$1;
(statearr_14830_14967[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (70))){
var inst_14772 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
if(cljs.core.truth_(inst_14772)){
var statearr_14831_14968 = state_14826__$1;
(statearr_14831_14968[(1)] = (71));

} else {
var statearr_14832_14969 = state_14826__$1;
(statearr_14832_14969[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (62))){
var inst_14725 = (state_14826[(10)]);
var inst_14711 = (state_14826[(11)]);
var inst_14740 = (state_14826[(2)]);
var inst_14741 = fluree.db.dbproto._rhs(inst_14725);
var state_14826__$1 = (function (){var statearr_14833 = state_14826;
(statearr_14833[(12)] = inst_14740);

(statearr_14833[(8)] = inst_14741);

return statearr_14833;
})();
if(cljs.core.truth_(inst_14711)){
var statearr_14834_14970 = state_14826__$1;
(statearr_14834_14970[(1)] = (63));

} else {
var statearr_14835_14971 = state_14826__$1;
(statearr_14835_14971[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (74))){
var inst_14765 = (state_14826[(13)]);
var inst_14779 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_14765);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(77),inst_14779);
} else {
if((state_val_14827 === (7))){
var inst_14602 = (state_14826[(14)]);
var state_14826__$1 = state_14826;
var statearr_14836_14972 = state_14826__$1;
(statearr_14836_14972[(2)] = inst_14602);

(statearr_14836_14972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (59))){
var inst_14688 = (state_14826[(15)]);
var inst_14687 = (state_14826[(16)]);
var inst_14732 = (state_14826[(17)]);
var inst_14731 = (state_14826[(2)]);
var inst_14732__$1 = fluree.db.util.async.throw_err(inst_14731);
var inst_14733 = fluree.db.flake.subrange(inst_14732__$1,start_test,inst_14687,end_test,inst_14688);
var inst_14734 = fluree.db.query.range.value_with_nil_pred(idx,inst_14687,inst_14688);
var state_14826__$1 = (function (){var statearr_14837 = state_14826;
(statearr_14837[(18)] = inst_14733);

(statearr_14837[(17)] = inst_14732__$1);

return statearr_14837;
})();
if(inst_14734){
var statearr_14838_14973 = state_14826__$1;
(statearr_14838_14973[(1)] = (60));

} else {
var statearr_14839_14974 = state_14826__$1;
(statearr_14839_14974[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (86))){
var inst_14806 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14840_14975 = state_14826__$1;
(statearr_14840_14975[(2)] = inst_14806);

(statearr_14840_14975[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (20))){
var inst_14603 = (state_14826[(19)]);
var inst_14651 = (state_14826[(20)]);
var inst_14650 = (state_14826[(2)]);
var inst_14651__$1 = (inst_14603 == null);
var state_14826__$1 = (function (){var statearr_14841 = state_14826;
(statearr_14841[(21)] = inst_14650);

(statearr_14841[(20)] = inst_14651__$1);

return statearr_14841;
})();
if(cljs.core.truth_(inst_14651__$1)){
var statearr_14842_14976 = state_14826__$1;
(statearr_14842_14976[(1)] = (22));

} else {
var statearr_14843_14977 = state_14826__$1;
(statearr_14843_14977[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (72))){
var inst_14758 = (state_14826[(22)]);
var inst_14776 = (inst_14758 + (1));
var inst_14777 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14826__$1 = (function (){var statearr_14844 = state_14826;
(statearr_14844[(23)] = inst_14776);

return statearr_14844;
})();
if(cljs.core.truth_(inst_14777)){
var statearr_14845_14978 = state_14826__$1;
(statearr_14845_14978[(1)] = (74));

} else {
var statearr_14846_14979 = state_14826__$1;
(statearr_14846_14979[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (58))){
var inst_14821 = (state_14826[(2)]);
var _ = (function (){var statearr_14847 = state_14826;
(statearr_14847[(4)] = cljs.core.rest((state_14826[(4)])));

return statearr_14847;
})();
var state_14826__$1 = state_14826;
var statearr_14848_14980 = state_14826__$1;
(statearr_14848_14980[(2)] = inst_14821);

(statearr_14848_14980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (60))){
var inst_14668 = (state_14826[(24)]);
var inst_14688 = (state_14826[(15)]);
var inst_14650 = (state_14826[(21)]);
var inst_14601 = (state_14826[(25)]);
var inst_14725 = (state_14826[(10)]);
var inst_14632 = (state_14826[(26)]);
var inst_14623 = (state_14826[(27)]);
var inst_14733 = (state_14826[(18)]);
var inst_14659 = (state_14826[(28)]);
var inst_14726 = (state_14826[(29)]);
var inst_14606 = (state_14826[(30)]);
var inst_14715 = (state_14826[(31)]);
var inst_14705 = (state_14826[(32)]);
var inst_14641 = (state_14826[(33)]);
var inst_14608 = (state_14826[(34)]);
var inst_14677 = (state_14826[(35)]);
var inst_14727 = (state_14826[(36)]);
var inst_14693 = (state_14826[(37)]);
var inst_14720 = (state_14826[(38)]);
var inst_14687 = (state_14826[(16)]);
var inst_14711 = (state_14826[(11)]);
var inst_14698 = (state_14826[(39)]);
var inst_14686 = (state_14826[(40)]);
var inst_14704 = (state_14826[(41)]);
var inst_14732 = (state_14826[(17)]);
var inst_14613 = (state_14826[(42)]);
var inst_14605 = (state_14826[(43)]);
var inst_14694 = (state_14826[(44)]);
var inst_14612 = (state_14826[(45)]);
var inst_14736 = (function (){var no_filter_QMARK_ = inst_14711;
var next_node = inst_14725;
var flakes = inst_14732;
var s1 = inst_14623;
var o2 = inst_14650;
var t1 = inst_14605;
var i = inst_14726;
var m1 = inst_14677;
var vec__14598 = inst_14608;
var root_node = inst_14720;
var to_t = inst_14705;
var s2 = inst_14632;
var p2 = inst_14668;
var permissions = inst_14694;
var limit = inst_14693;
var start_flake = inst_14687;
var acc = inst_14727;
var t2 = inst_14612;
var op1 = inst_14606;
var o1 = inst_14641;
var end_flake = inst_14688;
var base_result = inst_14733;
var p1 = inst_14659;
var idx_compare = inst_14698;
var vec__14595 = inst_14601;
var op2 = inst_14613;
var from_t = inst_14704;
var m2 = inst_14686;
var novelty = inst_14715;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_14737 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_14736,inst_14733,inst_14733);
var state_14826__$1 = state_14826;
var statearr_14849_14981 = state_14826__$1;
(statearr_14849_14981[(2)] = inst_14737);

(statearr_14849_14981[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (27))){
var inst_14610 = (state_14826[(46)]);
var inst_14660 = (state_14826[(47)]);
var inst_14659 = (state_14826[(2)]);
var inst_14660__$1 = (inst_14610 == null);
var state_14826__$1 = (function (){var statearr_14850 = state_14826;
(statearr_14850[(28)] = inst_14659);

(statearr_14850[(47)] = inst_14660__$1);

return statearr_14850;
})();
if(cljs.core.truth_(inst_14660__$1)){
var statearr_14851_14982 = state_14826__$1;
(statearr_14851_14982[(1)] = (28));

} else {
var statearr_14852_14983 = state_14826__$1;
(statearr_14852_14983[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (1))){
var state_14826__$1 = state_14826;
var statearr_14853_14984 = state_14826__$1;
(statearr_14853_14984[(2)] = null);

(statearr_14853_14984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (69))){
var inst_14693 = (state_14826[(37)]);
var inst_14758 = (state_14826[(22)]);
var inst_14770 = (inst_14758 > inst_14693);
var state_14826__$1 = state_14826;
var statearr_14854_14985 = state_14826__$1;
(statearr_14854_14985[(2)] = inst_14770);

(statearr_14854_14985[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (24))){
var inst_14655 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
if(cljs.core.truth_(inst_14655)){
var statearr_14855_14986 = state_14826__$1;
(statearr_14855_14986[(1)] = (25));

} else {
var statearr_14856_14987 = state_14826__$1;
(statearr_14856_14987[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (55))){
var inst_14720 = (state_14826[(38)]);
var inst_14687 = (state_14826[(16)]);
var inst_14719 = (state_14826[(2)]);
var inst_14720__$1 = fluree.db.util.async.throw_err(inst_14719);
var inst_14721 = fluree.db.dbproto._lookup_leaf(inst_14720__$1,inst_14687);
var state_14826__$1 = (function (){var statearr_14857 = state_14826;
(statearr_14857[(38)] = inst_14720__$1);

return statearr_14857;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(56),inst_14721);
} else {
if((state_val_14827 === (85))){
var inst_14801 = (state_14826[(48)]);
var state_14826__$1 = state_14826;
var statearr_14858_14988 = state_14826__$1;
(statearr_14858_14988[(2)] = inst_14801);

(statearr_14858_14988[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (39))){
var inst_14675 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14859_14989 = state_14826__$1;
(statearr_14859_14989[(2)] = inst_14675);

(statearr_14859_14989[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (88))){
var inst_14741 = (state_14826[(8)]);
var inst_14720 = (state_14826[(38)]);
var inst_14813 = fluree.db.dbproto._lookup_leaf(inst_14720,inst_14741);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(90),inst_14813);
} else {
if((state_val_14827 === (46))){
var inst_14689 = (state_14826[(49)]);
var state_14826__$1 = state_14826;
var statearr_14860_14990 = state_14826__$1;
(statearr_14860_14990[(2)] = inst_14689);

(statearr_14860_14990[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (4))){
var inst_14589 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14861_14991 = state_14826__$1;
(statearr_14861_14991[(2)] = inst_14589);

(statearr_14861_14991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (77))){
var inst_14781 = (state_14826[(2)]);
var inst_14782 = fluree.db.util.async.throw_err(inst_14781);
var state_14826__$1 = state_14826;
if(cljs.core.truth_(inst_14782)){
var statearr_14862_14992 = state_14826__$1;
(statearr_14862_14992[(1)] = (78));

} else {
var statearr_14863_14993 = state_14826__$1;
(statearr_14863_14993[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (54))){
var inst_14711 = (state_14826[(2)]);
var inst_14712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14713 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14714 = (new cljs.core.PersistentVector(null,2,(5),inst_14712,inst_14713,null));
var inst_14715 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14714);
var inst_14716 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14717 = fluree.db.dbproto._resolve(inst_14716);
var state_14826__$1 = (function (){var statearr_14864 = state_14826;
(statearr_14864[(31)] = inst_14715);

(statearr_14864[(11)] = inst_14711);

return statearr_14864;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(55),inst_14717);
} else {
if((state_val_14827 === (15))){
var inst_14604 = (state_14826[(50)]);
var state_14826__$1 = state_14826;
var statearr_14865_14994 = state_14826__$1;
(statearr_14865_14994[(2)] = inst_14604);

(statearr_14865_14994[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (48))){
var inst_14699 = (state_14826[(51)]);
var inst_14693 = (state_14826[(2)]);
var inst_14694 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14696 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14697 = (new cljs.core.PersistentVector(null,3,(5),inst_14695,inst_14696,null));
var inst_14698 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14697);
var inst_14699__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14826__$1 = (function (){var statearr_14866 = state_14826;
(statearr_14866[(51)] = inst_14699__$1);

(statearr_14866[(37)] = inst_14693);

(statearr_14866[(39)] = inst_14698);

(statearr_14866[(44)] = inst_14694);

return statearr_14866;
})();
if(cljs.core.truth_(inst_14699__$1)){
var statearr_14867_14995 = state_14826__$1;
(statearr_14867_14995[(1)] = (49));

} else {
var statearr_14868_14996 = state_14826__$1;
(statearr_14868_14996[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (50))){
var inst_14702 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14826__$1 = state_14826;
var statearr_14869_14997 = state_14826__$1;
(statearr_14869_14997[(2)] = inst_14702);

(statearr_14869_14997[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (75))){
var inst_14759 = (state_14826[(52)]);
var state_14826__$1 = state_14826;
var statearr_14870_14998 = state_14826__$1;
(statearr_14870_14998[(2)] = inst_14759);

(statearr_14870_14998[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (21))){
var inst_14646 = (state_14826[(2)]);
var inst_14647 = fluree.db.util.async.throw_err(inst_14646);
var state_14826__$1 = state_14826;
var statearr_14871_14999 = state_14826__$1;
(statearr_14871_14999[(2)] = inst_14647);

(statearr_14871_14999[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (31))){
var state_14826__$1 = state_14826;
var statearr_14872_15000 = state_14826__$1;
(statearr_14872_15000[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14872_15000[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (32))){
var inst_14610 = (state_14826[(46)]);
var state_14826__$1 = state_14826;
var statearr_14873_15001 = state_14826__$1;
(statearr_14873_15001[(2)] = inst_14610);

(statearr_14873_15001[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (40))){
var inst_14614 = (state_14826[(53)]);
var state_14826__$1 = state_14826;
var statearr_14874_15002 = state_14826__$1;
(statearr_14874_15002[(2)] = inst_14614);

(statearr_14874_15002[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (56))){
var inst_14723 = (state_14826[(2)]);
var inst_14724 = fluree.db.util.async.throw_err(inst_14723);
var inst_14725 = inst_14724;
var inst_14726 = (0);
var inst_14727 = null;
var state_14826__$1 = (function (){var statearr_14875 = state_14826;
(statearr_14875[(10)] = inst_14725);

(statearr_14875[(29)] = inst_14726);

(statearr_14875[(36)] = inst_14727);

return statearr_14875;
})();
var statearr_14876_15003 = state_14826__$1;
(statearr_14876_15003[(2)] = null);

(statearr_14876_15003[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (33))){
var inst_14607 = (state_14826[(54)]);
var inst_14668 = (state_14826[(2)]);
var state_14826__$1 = (function (){var statearr_14877 = state_14826;
(statearr_14877[(24)] = inst_14668);

return statearr_14877;
})();
if(cljs.core.truth_(inst_14607)){
var statearr_14878_15004 = state_14826__$1;
(statearr_14878_15004[(1)] = (34));

} else {
var statearr_14879_15005 = state_14826__$1;
(statearr_14879_15005[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (13))){
var inst_14628 = (state_14826[(2)]);
var inst_14629 = fluree.db.util.async.throw_err(inst_14628);
var state_14826__$1 = state_14826;
var statearr_14880_15006 = state_14826__$1;
(statearr_14880_15006[(2)] = inst_14629);

(statearr_14880_15006[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (22))){
var inst_14641 = (state_14826[(33)]);
var state_14826__$1 = state_14826;
var statearr_14881_15007 = state_14826__$1;
(statearr_14881_15007[(2)] = inst_14641);

(statearr_14881_15007[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (90))){
var inst_14797 = (state_14826[(7)]);
var inst_14798 = (state_14826[(9)]);
var inst_14815 = (state_14826[(2)]);
var inst_14816 = fluree.db.util.async.throw_err(inst_14815);
var inst_14725 = inst_14816;
var inst_14726 = inst_14798;
var inst_14727 = inst_14797;
var state_14826__$1 = (function (){var statearr_14882 = state_14826;
(statearr_14882[(10)] = inst_14725);

(statearr_14882[(29)] = inst_14726);

(statearr_14882[(36)] = inst_14727);

return statearr_14882;
})();
var statearr_14883_15008 = state_14826__$1;
(statearr_14883_15008[(2)] = null);

(statearr_14883_15008[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (36))){
var inst_14614 = (state_14826[(53)]);
var inst_14677 = (state_14826[(2)]);
var state_14826__$1 = (function (){var statearr_14884 = state_14826;
(statearr_14884[(35)] = inst_14677);

return statearr_14884;
})();
if(cljs.core.truth_(inst_14614)){
var statearr_14885_15009 = state_14826__$1;
(statearr_14885_15009[(1)] = (40));

} else {
var statearr_14886_15010 = state_14826__$1;
(statearr_14886_15010[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (41))){
var inst_14680 = (cljs.core._LT__EQ_ === end_test);
var state_14826__$1 = state_14826;
if(cljs.core.truth_(inst_14680)){
var statearr_14887_15011 = state_14826__$1;
(statearr_14887_15011[(1)] = (43));

} else {
var statearr_14888_15012 = state_14826__$1;
(statearr_14888_15012[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (89))){
var inst_14819 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14889_15013 = state_14826__$1;
(statearr_14889_15013[(2)] = inst_14819);

(statearr_14889_15013[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (43))){
var state_14826__$1 = state_14826;
var statearr_14890_15014 = state_14826__$1;
(statearr_14890_15014[(2)] = (2147483647));

(statearr_14890_15014[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (61))){
var inst_14733 = (state_14826[(18)]);
var state_14826__$1 = state_14826;
var statearr_14891_15015 = state_14826__$1;
(statearr_14891_15015[(2)] = inst_14733);

(statearr_14891_15015[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (29))){
var inst_14660 = (state_14826[(47)]);
var state_14826__$1 = state_14826;
var statearr_14892_15016 = state_14826__$1;
(statearr_14892_15016[(2)] = inst_14660);

(statearr_14892_15016[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (44))){
var state_14826__$1 = state_14826;
var statearr_14893_15017 = state_14826__$1;
(statearr_14893_15017[(2)] = fluree.db.util.core.min_integer);

(statearr_14893_15017[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (6))){
var inst_14602 = (state_14826[(14)]);
var inst_14617 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14602);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(9),inst_14617);
} else {
if((state_val_14827 === (28))){
var inst_14650 = (state_14826[(21)]);
var state_14826__$1 = state_14826;
var statearr_14894_15018 = state_14826__$1;
(statearr_14894_15018[(2)] = inst_14650);

(statearr_14894_15018[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (64))){
var inst_14740 = (state_14826[(12)]);
var inst_14726 = (state_14826[(29)]);
var inst_14754 = cljs.core.seq(inst_14740);
var inst_14755 = cljs.core.first(inst_14754);
var inst_14756 = cljs.core.next(inst_14754);
var inst_14757 = inst_14740;
var inst_14758 = inst_14726;
var inst_14759 = inst_14740;
var state_14826__$1 = (function (){var statearr_14895 = state_14826;
(statearr_14895[(52)] = inst_14759);

(statearr_14895[(55)] = inst_14756);

(statearr_14895[(56)] = inst_14755);

(statearr_14895[(22)] = inst_14758);

(statearr_14895[(57)] = inst_14757);

return statearr_14895;
})();
var statearr_14896_15019 = state_14826__$1;
(statearr_14896_15019[(2)] = null);

(statearr_14896_15019[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (51))){
var inst_14704 = (state_14826[(2)]);
var inst_14705 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_14706 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14826__$1 = (function (){var statearr_14897 = state_14826;
(statearr_14897[(32)] = inst_14705);

(statearr_14897[(41)] = inst_14704);

return statearr_14897;
})();
if(cljs.core.truth_(inst_14706)){
var statearr_14898_15020 = state_14826__$1;
(statearr_14898_15020[(1)] = (52));

} else {
var statearr_14899_15021 = state_14826__$1;
(statearr_14899_15021[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (25))){
var state_14826__$1 = state_14826;
var statearr_14900_15022 = state_14826__$1;
(statearr_14900_15022[(2)] = (-1));

(statearr_14900_15022[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (34))){
var inst_14607 = (state_14826[(54)]);
var state_14826__$1 = state_14826;
var statearr_14901_15023 = state_14826__$1;
(statearr_14901_15023[(2)] = inst_14607);

(statearr_14901_15023[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (17))){
var inst_14637 = (state_14826[(2)]);
var inst_14638 = fluree.db.util.async.throw_err(inst_14637);
var state_14826__$1 = state_14826;
var statearr_14902_15024 = state_14826__$1;
(statearr_14902_15024[(2)] = inst_14638);

(statearr_14902_15024[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (3))){
var inst_14824 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14826__$1,inst_14824);
} else {
if((state_val_14827 === (12))){
var inst_14604 = (state_14826[(50)]);
var inst_14632 = (state_14826[(2)]);
var inst_14633 = fluree.db.util.core.pred_ident_QMARK_(inst_14604);
var state_14826__$1 = (function (){var statearr_14903 = state_14826;
(statearr_14903[(26)] = inst_14632);

return statearr_14903;
})();
if(inst_14633){
var statearr_14904_15025 = state_14826__$1;
(statearr_14904_15025[(1)] = (14));

} else {
var statearr_14905_15026 = state_14826__$1;
(statearr_14905_15026[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (2))){
var inst_14601 = (state_14826[(25)]);
var inst_14602 = (state_14826[(14)]);
var inst_14608 = (state_14826[(34)]);
var _ = (function (){var statearr_14906 = state_14826;
(statearr_14906[(4)] = cljs.core.cons((5),(state_14826[(4)])));

return statearr_14906;
})();
var inst_14601__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14602__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14601__$1,(0),null);
var inst_14603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14601__$1,(1),null);
var inst_14604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14601__$1,(2),null);
var inst_14605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14601__$1,(3),null);
var inst_14606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14601__$1,(4),null);
var inst_14607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14601__$1,(5),null);
var inst_14608__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14609 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14608__$1,(0),null);
var inst_14610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14608__$1,(1),null);
var inst_14611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14608__$1,(2),null);
var inst_14612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14608__$1,(3),null);
var inst_14613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14608__$1,(4),null);
var inst_14614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14608__$1,(5),null);
var inst_14615 = fluree.db.util.core.pred_ident_QMARK_(inst_14602__$1);
var state_14826__$1 = (function (){var statearr_14907 = state_14826;
(statearr_14907[(54)] = inst_14607);

(statearr_14907[(53)] = inst_14614);

(statearr_14907[(25)] = inst_14601__$1);

(statearr_14907[(50)] = inst_14604);

(statearr_14907[(46)] = inst_14610);

(statearr_14907[(30)] = inst_14606);

(statearr_14907[(19)] = inst_14603);

(statearr_14907[(14)] = inst_14602__$1);

(statearr_14907[(34)] = inst_14608__$1);

(statearr_14907[(58)] = inst_14611);

(statearr_14907[(59)] = inst_14609);

(statearr_14907[(42)] = inst_14613);

(statearr_14907[(43)] = inst_14605);

(statearr_14907[(45)] = inst_14612);

return statearr_14907;
})();
if(inst_14615){
var statearr_14908_15027 = state_14826__$1;
(statearr_14908_15027[(1)] = (6));

} else {
var statearr_14909_15028 = state_14826__$1;
(statearr_14909_15028[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (66))){
var inst_14767 = (state_14826[(60)]);
var inst_14765 = (state_14826[(13)]);
var inst_14757 = (state_14826[(57)]);
var inst_14764 = cljs.core.seq(inst_14757);
var inst_14765__$1 = cljs.core.first(inst_14764);
var inst_14766 = cljs.core.next(inst_14764);
var inst_14767__$1 = (inst_14765__$1 == null);
var state_14826__$1 = (function (){var statearr_14910 = state_14826;
(statearr_14910[(60)] = inst_14767__$1);

(statearr_14910[(13)] = inst_14765__$1);

(statearr_14910[(61)] = inst_14766);

return statearr_14910;
})();
if(cljs.core.truth_(inst_14767__$1)){
var statearr_14911_15029 = state_14826__$1;
(statearr_14911_15029[(1)] = (68));

} else {
var statearr_14912_15030 = state_14826__$1;
(statearr_14912_15030[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (23))){
var inst_14651 = (state_14826[(20)]);
var state_14826__$1 = state_14826;
var statearr_14913_15031 = state_14826__$1;
(statearr_14913_15031[(2)] = inst_14651);

(statearr_14913_15031[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (47))){
var state_14826__$1 = state_14826;
var statearr_14914_15032 = state_14826__$1;
(statearr_14914_15032[(2)] = fluree.db.util.core.max_long);

(statearr_14914_15032[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (35))){
var inst_14671 = (cljs.core._GT__EQ_ === start_test);
var state_14826__$1 = state_14826;
if(cljs.core.truth_(inst_14671)){
var statearr_14915_15033 = state_14826__$1;
(statearr_14915_15033[(1)] = (37));

} else {
var statearr_14916_15034 = state_14826__$1;
(statearr_14916_15034[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (82))){
var inst_14741 = (state_14826[(8)]);
var state_14826__$1 = state_14826;
var statearr_14917_15035 = state_14826__$1;
(statearr_14917_15035[(2)] = inst_14741);

(statearr_14917_15035[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (76))){
var inst_14776 = (state_14826[(23)]);
var inst_14766 = (state_14826[(61)]);
var inst_14790 = (state_14826[(2)]);
var inst_14757 = inst_14766;
var inst_14758 = inst_14776;
var inst_14759 = inst_14790;
var state_14826__$1 = (function (){var statearr_14918 = state_14826;
(statearr_14918[(52)] = inst_14759);

(statearr_14918[(22)] = inst_14758);

(statearr_14918[(57)] = inst_14757);

return statearr_14918;
})();
var statearr_14919_15036 = state_14826__$1;
(statearr_14919_15036[(2)] = null);

(statearr_14919_15036[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (19))){
var inst_14611 = (state_14826[(58)]);
var state_14826__$1 = state_14826;
var statearr_14920_15037 = state_14826__$1;
(statearr_14920_15037[(2)] = inst_14611);

(statearr_14920_15037[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (57))){
var inst_14725 = (state_14826[(10)]);
var inst_14715 = (state_14826[(31)]);
var inst_14705 = (state_14826[(32)]);
var inst_14704 = (state_14826[(41)]);
var inst_14729 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_14725,inst_14704,inst_14705,inst_14715);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(59),inst_14729);
} else {
if((state_val_14827 === (68))){
var inst_14767 = (state_14826[(60)]);
var state_14826__$1 = state_14826;
var statearr_14921_15038 = state_14826__$1;
(statearr_14921_15038[(2)] = inst_14767);

(statearr_14921_15038[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (11))){
var inst_14609 = (state_14826[(59)]);
var state_14826__$1 = state_14826;
var statearr_14923_15039 = state_14826__$1;
(statearr_14923_15039[(2)] = inst_14609);

(statearr_14923_15039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (9))){
var inst_14619 = (state_14826[(2)]);
var inst_14620 = fluree.db.util.async.throw_err(inst_14619);
var state_14826__$1 = state_14826;
var statearr_14924_15040 = state_14826__$1;
(statearr_14924_15040[(2)] = inst_14620);

(statearr_14924_15040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (5))){
var _ = (function (){var statearr_14925 = state_14826;
(statearr_14925[(4)] = cljs.core.rest((state_14826[(4)])));

return statearr_14925;
})();
var state_14826__$1 = state_14826;
var ex14922 = (state_14826__$1[(2)]);
var statearr_14926_15041 = state_14826__$1;
(statearr_14926_15041[(5)] = ex14922);


if((ex14922 instanceof Error)){
var statearr_14927_15042 = state_14826__$1;
(statearr_14927_15042[(1)] = (4));

(statearr_14927_15042[(5)] = null);

} else {
throw ex14922;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (83))){
var inst_14809 = (state_14826[(2)]);
var inst_14810 = cljs.core.not(inst_14809);
var state_14826__$1 = state_14826;
if(inst_14810){
var statearr_14928_15043 = state_14826__$1;
(statearr_14928_15043[(1)] = (87));

} else {
var statearr_14929_15044 = state_14826__$1;
(statearr_14929_15044[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (14))){
var inst_14604 = (state_14826[(50)]);
var inst_14635 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14604);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(17),inst_14635);
} else {
if((state_val_14827 === (45))){
var inst_14684 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14930_15045 = state_14826__$1;
(statearr_14930_15045[(2)] = inst_14684);

(statearr_14930_15045[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (53))){
var state_14826__$1 = state_14826;
var statearr_14931_15046 = state_14826__$1;
(statearr_14931_15046[(2)] = true);

(statearr_14931_15046[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (78))){
var inst_14759 = (state_14826[(52)]);
var state_14826__$1 = state_14826;
var statearr_14932_15047 = state_14826__$1;
(statearr_14932_15047[(2)] = inst_14759);

(statearr_14932_15047[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (26))){
var inst_14603 = (state_14826[(19)]);
var state_14826__$1 = state_14826;
var statearr_14933_15048 = state_14826__$1;
(statearr_14933_15048[(2)] = inst_14603);

(statearr_14933_15048[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (16))){
var inst_14611 = (state_14826[(58)]);
var inst_14641 = (state_14826[(2)]);
var inst_14642 = fluree.db.util.core.pred_ident_QMARK_(inst_14611);
var state_14826__$1 = (function (){var statearr_14934 = state_14826;
(statearr_14934[(33)] = inst_14641);

return statearr_14934;
})();
if(inst_14642){
var statearr_14935_15049 = state_14826__$1;
(statearr_14935_15049[(1)] = (18));

} else {
var statearr_14936_15050 = state_14826__$1;
(statearr_14936_15050[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (81))){
var inst_14688 = (state_14826[(15)]);
var inst_14801 = (state_14826[(48)]);
var inst_14741 = (state_14826[(8)]);
var inst_14698 = (state_14826[(39)]);
var inst_14800 = (inst_14698.cljs$core$IFn$_invoke$arity$2 ? inst_14698.cljs$core$IFn$_invoke$arity$2(inst_14741,inst_14688) : inst_14698.call(null,inst_14741,inst_14688));
var inst_14801__$1 = (inst_14800 < (0));
var state_14826__$1 = (function (){var statearr_14937 = state_14826;
(statearr_14937[(48)] = inst_14801__$1);

return statearr_14937;
})();
if(cljs.core.truth_(inst_14801__$1)){
var statearr_14938_15051 = state_14826__$1;
(statearr_14938_15051[(1)] = (84));

} else {
var statearr_14939_15052 = state_14826__$1;
(statearr_14939_15052[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (79))){
var inst_14759 = (state_14826[(52)]);
var inst_14765 = (state_14826[(13)]);
var inst_14785 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_14759,inst_14765);
var state_14826__$1 = state_14826;
var statearr_14940_15053 = state_14826__$1;
(statearr_14940_15053[(2)] = inst_14785);

(statearr_14940_15053[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (38))){
var state_14826__$1 = state_14826;
var statearr_14941_15054 = state_14826__$1;
(statearr_14941_15054[(2)] = (2147483647));

(statearr_14941_15054[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (87))){
var inst_14797 = (state_14826[(7)]);
var state_14826__$1 = state_14826;
var statearr_14942_15055 = state_14826__$1;
(statearr_14942_15055[(2)] = inst_14797);

(statearr_14942_15055[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (30))){
var inst_14664 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
if(cljs.core.truth_(inst_14664)){
var statearr_14943_15056 = state_14826__$1;
(statearr_14943_15056[(1)] = (31));

} else {
var statearr_14944_15057 = state_14826__$1;
(statearr_14944_15057[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (73))){
var inst_14793 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14945_15058 = state_14826__$1;
(statearr_14945_15058[(2)] = inst_14793);

(statearr_14945_15058[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (10))){
var inst_14609 = (state_14826[(59)]);
var inst_14626 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14609);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(13),inst_14626);
} else {
if((state_val_14827 === (18))){
var inst_14611 = (state_14826[(58)]);
var inst_14644 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14611);
var state_14826__$1 = state_14826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14826__$1,(21),inst_14644);
} else {
if((state_val_14827 === (52))){
var inst_14668 = (state_14826[(24)]);
var inst_14632 = (state_14826[(26)]);
var inst_14623 = (state_14826[(27)]);
var inst_14659 = (state_14826[(28)]);
var inst_14694 = (state_14826[(44)]);
var inst_14708 = fluree.db.permissions_validate.no_filter_QMARK_(inst_14694,inst_14623,inst_14632,inst_14659,inst_14668);
var state_14826__$1 = state_14826;
var statearr_14946_15059 = state_14826__$1;
(statearr_14946_15059[(2)] = inst_14708);

(statearr_14946_15059[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (67))){
var inst_14795 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14947_15060 = state_14826__$1;
(statearr_14947_15060[(2)] = inst_14795);

(statearr_14947_15060[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (71))){
var inst_14759 = (state_14826[(52)]);
var inst_14727 = (state_14826[(36)]);
var inst_14774 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14759,inst_14727);
var state_14826__$1 = state_14826;
var statearr_14948_15061 = state_14826__$1;
(statearr_14948_15061[(2)] = inst_14774);

(statearr_14948_15061[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (42))){
var inst_14668 = (state_14826[(24)]);
var inst_14650 = (state_14826[(21)]);
var inst_14632 = (state_14826[(26)]);
var inst_14623 = (state_14826[(27)]);
var inst_14659 = (state_14826[(28)]);
var inst_14606 = (state_14826[(30)]);
var inst_14641 = (state_14826[(33)]);
var inst_14677 = (state_14826[(35)]);
var inst_14689 = (state_14826[(49)]);
var inst_14686 = (state_14826[(40)]);
var inst_14613 = (state_14826[(42)]);
var inst_14605 = (state_14826[(43)]);
var inst_14612 = (state_14826[(45)]);
var inst_14686__$1 = (state_14826[(2)]);
var inst_14687 = fluree.db.flake.__GT_Flake(inst_14623,inst_14659,inst_14641,inst_14605,inst_14606,inst_14677);
var inst_14688 = fluree.db.flake.__GT_Flake(inst_14632,inst_14668,inst_14650,inst_14612,inst_14613,inst_14686__$1);
var inst_14689__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14826__$1 = (function (){var statearr_14949 = state_14826;
(statearr_14949[(15)] = inst_14688);

(statearr_14949[(16)] = inst_14687);

(statearr_14949[(49)] = inst_14689__$1);

(statearr_14949[(40)] = inst_14686__$1);

return statearr_14949;
})();
if(cljs.core.truth_(inst_14689__$1)){
var statearr_14950_15062 = state_14826__$1;
(statearr_14950_15062[(1)] = (46));

} else {
var statearr_14951_15063 = state_14826__$1;
(statearr_14951_15063[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (80))){
var inst_14787 = (state_14826[(2)]);
var state_14826__$1 = state_14826;
var statearr_14952_15064 = state_14826__$1;
(statearr_14952_15064[(2)] = inst_14787);

(statearr_14952_15064[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (37))){
var state_14826__$1 = state_14826;
var statearr_14953_15065 = state_14826__$1;
(statearr_14953_15065[(2)] = fluree.db.util.core.min_integer);

(statearr_14953_15065[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (63))){
var inst_14740 = (state_14826[(12)]);
var inst_14726 = (state_14826[(29)]);
var inst_14727 = (state_14826[(36)]);
var inst_14693 = (state_14826[(37)]);
var inst_14743 = (inst_14693 - inst_14726);
var inst_14744 = fluree.db.flake.take(inst_14743,inst_14740);
var inst_14745 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14744,inst_14727);
var state_14826__$1 = state_14826;
var statearr_14954_15066 = state_14826__$1;
(statearr_14954_15066[(2)] = inst_14745);

(statearr_14954_15066[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (8))){
var inst_14609 = (state_14826[(59)]);
var inst_14623 = (state_14826[(2)]);
var inst_14624 = fluree.db.util.core.pred_ident_QMARK_(inst_14609);
var state_14826__$1 = (function (){var statearr_14955 = state_14826;
(statearr_14955[(27)] = inst_14623);

return statearr_14955;
})();
if(inst_14624){
var statearr_14956_15067 = state_14826__$1;
(statearr_14956_15067[(1)] = (10));

} else {
var statearr_14957_15068 = state_14826__$1;
(statearr_14957_15068[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (49))){
var inst_14699 = (state_14826[(51)]);
var state_14826__$1 = state_14826;
var statearr_14958_15069 = state_14826__$1;
(statearr_14958_15069[(2)] = inst_14699);

(statearr_14958_15069[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14827 === (84))){
var inst_14693 = (state_14826[(37)]);
var inst_14798 = (state_14826[(9)]);
var inst_14803 = (inst_14798 < inst_14693);
var state_14826__$1 = state_14826;
var statearr_14959_15070 = state_14826__$1;
(statearr_14959_15070[(2)] = inst_14803);

(statearr_14959_15070[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2749__auto__ = null;
var fluree$db$query$range$state_machine__2749__auto____0 = (function (){
var statearr_14960 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14960[(0)] = fluree$db$query$range$state_machine__2749__auto__);

(statearr_14960[(1)] = (1));

return statearr_14960;
});
var fluree$db$query$range$state_machine__2749__auto____1 = (function (state_14826){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_14826);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e14961){var ex__2752__auto__ = e14961;
var statearr_14962_15071 = state_14826;
(statearr_14962_15071[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_14826[(4)]))){
var statearr_14963_15072 = state_14826;
(statearr_14963_15072[(1)] = cljs.core.first((state_14826[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15073 = state_14826;
state_14826 = G__15073;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2749__auto__ = function(state_14826){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2749__auto____1.call(this,state_14826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2749__auto____0;
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2749__auto____1;
return fluree$db$query$range$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_14964 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_14964[(6)] = c__2771__auto__);

return statearr_14964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_15148){
var state_val_15149 = (state_15148[(1)]);
if((state_val_15149 === (7))){
var inst_15143 = (state_15148[(2)]);
var _ = (function (){var statearr_15150 = state_15148;
(statearr_15150[(4)] = cljs.core.rest((state_15148[(4)])));

return statearr_15150;
})();
var state_15148__$1 = state_15148;
var statearr_15151_15191 = state_15148__$1;
(statearr_15151_15191[(2)] = inst_15143);

(statearr_15151_15191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (20))){
var inst_15125 = (state_15148[(2)]);
var inst_15126 = fluree.db.util.async.throw_err(inst_15125);
var state_15148__$1 = state_15148;
var statearr_15152_15192 = state_15148__$1;
(statearr_15152_15192[(2)] = inst_15126);

(statearr_15152_15192[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (1))){
var state_15148__$1 = state_15148;
var statearr_15153_15193 = state_15148__$1;
(statearr_15153_15193[(2)] = null);

(statearr_15153_15193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (4))){
var inst_15074 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15154_15194 = state_15148__$1;
(statearr_15154_15194[(2)] = inst_15074);

(statearr_15154_15194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (15))){
var inst_15121 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15121)){
var statearr_15155_15195 = state_15148__$1;
(statearr_15155_15195[(1)] = (17));

} else {
var statearr_15156_15196 = state_15148__$1;
(statearr_15156_15196[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (21))){
var state_15148__$1 = state_15148;
var statearr_15157_15197 = state_15148__$1;
(statearr_15157_15197[(2)] = (0));

(statearr_15157_15197[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (13))){
var inst_15113 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15158_15198 = state_15148__$1;
(statearr_15158_15198[(2)] = inst_15113);

(statearr_15158_15198[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (22))){
var state_15148__$1 = state_15148;
var statearr_15159_15199 = state_15148__$1;
(statearr_15159_15199[(2)] = (1));

(statearr_15159_15199[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (6))){
var inst_15103 = (state_15148[(7)]);
var inst_15105 = (state_15148[(8)]);
var inst_15094 = (state_15148[(9)]);
var inst_15102 = cljs.core.seq(inst_15094);
var inst_15103__$1 = cljs.core.first(inst_15102);
var inst_15104 = cljs.core.next(inst_15102);
var inst_15105__$1 = (inst_15103__$1 == null);
var state_15148__$1 = (function (){var statearr_15160 = state_15148;
(statearr_15160[(7)] = inst_15103__$1);

(statearr_15160[(8)] = inst_15105__$1);

(statearr_15160[(10)] = inst_15104);

return statearr_15160;
})();
if(cljs.core.truth_(inst_15105__$1)){
var statearr_15161_15200 = state_15148__$1;
(statearr_15161_15200[(1)] = (8));

} else {
var statearr_15162_15201 = state_15148__$1;
(statearr_15162_15201[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (17))){
var inst_15103 = (state_15148[(7)]);
var inst_15123 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_15103);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15148__$1,(20),inst_15123);
} else {
if((state_val_15149 === (3))){
var inst_15146 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15148__$1,inst_15146);
} else {
if((state_val_15149 === (12))){
var inst_15096 = (state_15148[(11)]);
var inst_15111 = (inst_15096 >= subject_limit);
var state_15148__$1 = state_15148;
var statearr_15163_15202 = state_15148__$1;
(statearr_15163_15202[(2)] = inst_15111);

(statearr_15163_15202[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (2))){
var _ = (function (){var statearr_15164 = state_15148;
(statearr_15164[(4)] = cljs.core.cons((5),(state_15148[(4)])));

return statearr_15164;
})();
var inst_15087 = subject_groups;
var inst_15088 = cljs.core.seq(inst_15087);
var inst_15089 = cljs.core.first(inst_15088);
var inst_15090 = cljs.core.next(inst_15088);
var inst_15091 = flake_start;
var inst_15092 = subject_start;
var inst_15093 = cljs.core.PersistentVector.EMPTY;
var inst_15094 = inst_15087;
var inst_15095 = inst_15091;
var inst_15096 = inst_15092;
var inst_15097 = inst_15093;
var state_15148__$1 = (function (){var statearr_15165 = state_15148;
(statearr_15165[(12)] = inst_15095);

(statearr_15165[(11)] = inst_15096);

(statearr_15165[(13)] = inst_15097);

(statearr_15165[(14)] = inst_15089);

(statearr_15165[(15)] = inst_15090);

(statearr_15165[(9)] = inst_15094);

return statearr_15165;
})();
var statearr_15166_15203 = state_15148__$1;
(statearr_15166_15203[(2)] = null);

(statearr_15166_15203[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (23))){
var inst_15095 = (state_15148[(12)]);
var inst_15096 = (state_15148[(11)]);
var inst_15097 = (state_15148[(13)]);
var inst_15129 = (state_15148[(16)]);
var inst_15104 = (state_15148[(10)]);
var inst_15130 = (state_15148[(17)]);
var inst_15135 = (state_15148[(2)]);
var inst_15136 = (inst_15095 + inst_15130);
var inst_15137 = (inst_15096 + inst_15135);
var inst_15138 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15097,inst_15129);
var inst_15094 = inst_15104;
var inst_15095__$1 = inst_15136;
var inst_15096__$1 = inst_15137;
var inst_15097__$1 = inst_15138;
var state_15148__$1 = (function (){var statearr_15167 = state_15148;
(statearr_15167[(12)] = inst_15095__$1);

(statearr_15167[(11)] = inst_15096__$1);

(statearr_15167[(13)] = inst_15097__$1);

(statearr_15167[(9)] = inst_15094);

return statearr_15167;
})();
var statearr_15168_15204 = state_15148__$1;
(statearr_15168_15204[(2)] = null);

(statearr_15168_15204[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (19))){
var inst_15129 = (state_15148[(16)]);
var inst_15130 = (state_15148[(17)]);
var inst_15129__$1 = (state_15148[(2)]);
var inst_15130__$1 = cljs.core.count(inst_15129__$1);
var inst_15131 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_15130__$1);
var state_15148__$1 = (function (){var statearr_15169 = state_15148;
(statearr_15169[(16)] = inst_15129__$1);

(statearr_15169[(17)] = inst_15130__$1);

return statearr_15169;
})();
if(inst_15131){
var statearr_15170_15205 = state_15148__$1;
(statearr_15170_15205[(1)] = (21));

} else {
var statearr_15171_15206 = state_15148__$1;
(statearr_15171_15206[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (11))){
var inst_15108 = (state_15148[(18)]);
var state_15148__$1 = state_15148;
var statearr_15173_15207 = state_15148__$1;
(statearr_15173_15207[(2)] = inst_15108);

(statearr_15173_15207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (9))){
var inst_15095 = (state_15148[(12)]);
var inst_15108 = (state_15148[(18)]);
var inst_15108__$1 = (inst_15095 >= flake_limit);
var state_15148__$1 = (function (){var statearr_15174 = state_15148;
(statearr_15174[(18)] = inst_15108__$1);

return statearr_15174;
})();
if(cljs.core.truth_(inst_15108__$1)){
var statearr_15175_15208 = state_15148__$1;
(statearr_15175_15208[(1)] = (11));

} else {
var statearr_15176_15209 = state_15148__$1;
(statearr_15176_15209[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (5))){
var _ = (function (){var statearr_15177 = state_15148;
(statearr_15177[(4)] = cljs.core.rest((state_15148[(4)])));

return statearr_15177;
})();
var state_15148__$1 = state_15148;
var ex15172 = (state_15148__$1[(2)]);
var statearr_15178_15210 = state_15148__$1;
(statearr_15178_15210[(5)] = ex15172);


if((ex15172 instanceof Error)){
var statearr_15179_15211 = state_15148__$1;
(statearr_15179_15211[(1)] = (4));

(statearr_15179_15211[(5)] = null);

} else {
throw ex15172;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (14))){
var inst_15095 = (state_15148[(12)]);
var inst_15096 = (state_15148[(11)]);
var inst_15097 = (state_15148[(13)]);
var inst_15117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15118 = [inst_15095,inst_15096,inst_15097];
var inst_15119 = (new cljs.core.PersistentVector(null,3,(5),inst_15117,inst_15118,null));
var state_15148__$1 = state_15148;
var statearr_15180_15212 = state_15148__$1;
(statearr_15180_15212[(2)] = inst_15119);

(statearr_15180_15212[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (16))){
var inst_15141 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15181_15213 = state_15148__$1;
(statearr_15181_15213[(2)] = inst_15141);

(statearr_15181_15213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (10))){
var inst_15115 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15115)){
var statearr_15182_15214 = state_15148__$1;
(statearr_15182_15214[(1)] = (14));

} else {
var statearr_15183_15215 = state_15148__$1;
(statearr_15183_15215[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (18))){
var inst_15103 = (state_15148[(7)]);
var state_15148__$1 = state_15148;
var statearr_15184_15216 = state_15148__$1;
(statearr_15184_15216[(2)] = inst_15103);

(statearr_15184_15216[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (8))){
var inst_15105 = (state_15148[(8)]);
var state_15148__$1 = state_15148;
var statearr_15185_15217 = state_15148__$1;
(statearr_15185_15217[(2)] = inst_15105);

(statearr_15185_15217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto____0 = (function (){
var statearr_15186 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15186[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto__);

(statearr_15186[(1)] = (1));

return statearr_15186;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto____1 = (function (state_15148){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_15148);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e15187){var ex__2752__auto__ = e15187;
var statearr_15188_15218 = state_15148;
(statearr_15188_15218[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_15148[(4)]))){
var statearr_15189_15219 = state_15148;
(statearr_15189_15219[(1)] = cljs.core.first((state_15148[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15220 = state_15148;
state_15148 = G__15220;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto__ = function(state_15148){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto____1.call(this,state_15148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_15190 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_15190[(6)] = c__2771__auto__);

return statearr_15190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_15266){
var state_val_15267 = (state_15266[(1)]);
if((state_val_15267 === (7))){
var state_15266__$1 = state_15266;
var statearr_15268_15306 = state_15266__$1;
(statearr_15268_15306[(2)] = null);

(statearr_15268_15306[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (20))){
var inst_15252 = (state_15266[(2)]);
var inst_15253 = fluree.db.util.async.throw_err(inst_15252);
var inst_15231 = inst_15253;
var state_15266__$1 = (function (){var statearr_15269 = state_15266;
(statearr_15269[(7)] = inst_15231);

return statearr_15269;
})();
var statearr_15270_15307 = state_15266__$1;
(statearr_15270_15307[(2)] = null);

(statearr_15270_15307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (1))){
var state_15266__$1 = state_15266;
var statearr_15271_15308 = state_15266__$1;
(statearr_15271_15308[(2)] = null);

(statearr_15271_15308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (4))){
var inst_15221 = (state_15266[(2)]);
var state_15266__$1 = state_15266;
var statearr_15272_15309 = state_15266__$1;
(statearr_15272_15309[(2)] = inst_15221);

(statearr_15272_15309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (15))){
var inst_15248 = (state_15266[(8)]);
var inst_15231 = (state_15266[(7)]);
var inst_15248__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_15231);
var state_15266__$1 = (function (){var statearr_15273 = state_15266;
(statearr_15273[(8)] = inst_15248__$1);

return statearr_15273;
})();
if(cljs.core.truth_(inst_15248__$1)){
var statearr_15274_15310 = state_15266__$1;
(statearr_15274_15310[(1)] = (17));

} else {
var statearr_15275_15311 = state_15266__$1;
(statearr_15275_15311[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (13))){
var inst_15241 = (state_15266[(2)]);
var inst_15242 = fluree.db.util.async.throw_err(inst_15241);
var _ = (function (){var statearr_15276 = state_15266;
(statearr_15276[(4)] = cljs.core.rest((state_15266[(4)])));

return statearr_15276;
})();
var state_15266__$1 = state_15266;
var statearr_15277_15312 = state_15266__$1;
(statearr_15277_15312[(2)] = inst_15242);

(statearr_15277_15312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (6))){
var inst_15229 = (state_15266[(2)]);
var inst_15230 = fluree.db.util.async.throw_err(inst_15229);
var inst_15231 = inst_15230;
var state_15266__$1 = (function (){var statearr_15278 = state_15266;
(statearr_15278[(7)] = inst_15231);

return statearr_15278;
})();
var statearr_15279_15313 = state_15266__$1;
(statearr_15279_15313[(2)] = null);

(statearr_15279_15313[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (17))){
var inst_15248 = (state_15266[(8)]);
var inst_15250 = fluree.db.dbproto._lookup_leaf(root_node,inst_15248);
var state_15266__$1 = state_15266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15266__$1,(20),inst_15250);
} else {
if((state_val_15267 === (3))){
var inst_15264 = (state_15266[(2)]);
var state_15266__$1 = state_15266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15266__$1,inst_15264);
} else {
if((state_val_15267 === (12))){
var _ = (function (){var statearr_15281 = state_15266;
(statearr_15281[(4)] = cljs.core.rest((state_15266[(4)])));

return statearr_15281;
})();
var state_15266__$1 = state_15266;
var ex15280 = (state_15266__$1[(2)]);
var statearr_15282_15314 = state_15266__$1;
(statearr_15282_15314[(5)] = ex15280);


var statearr_15283_15315 = state_15266__$1;
(statearr_15283_15315[(1)] = (11));

(statearr_15283_15315[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (2))){
var _ = (function (){var statearr_15284 = state_15266;
(statearr_15284[(4)] = cljs.core.cons((5),(state_15266[(4)])));

return statearr_15284;
})();
var inst_15227 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_15266__$1 = state_15266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15266__$1,(6),inst_15227);
} else {
if((state_val_15267 === (19))){
var inst_15257 = (state_15266[(2)]);
var state_15266__$1 = state_15266;
var statearr_15285_15316 = state_15266__$1;
(statearr_15285_15316[(2)] = inst_15257);

(statearr_15285_15316[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (11))){
var inst_15233 = (state_15266[(2)]);
var state_15266__$1 = (function (){var statearr_15287 = state_15266;
(statearr_15287[(9)] = inst_15233);

return statearr_15287;
})();
var statearr_15288_15317 = state_15266__$1;
(statearr_15288_15317[(2)] = null);

(statearr_15288_15317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (9))){
var inst_15231 = (state_15266[(7)]);
var _ = (function (){var statearr_15289 = state_15266;
(statearr_15289[(4)] = cljs.core.cons((12),(state_15266[(4)])));

return statearr_15289;
})();
var inst_15239 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_15231,t,novelty,fast_forward_db_QMARK_);
var state_15266__$1 = state_15266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15266__$1,(13),inst_15239);
} else {
if((state_val_15267 === (5))){
var _ = (function (){var statearr_15290 = state_15266;
(statearr_15290[(4)] = cljs.core.rest((state_15266[(4)])));

return statearr_15290;
})();
var state_15266__$1 = state_15266;
var ex15286 = (state_15266__$1[(2)]);
var statearr_15291_15318 = state_15266__$1;
(statearr_15291_15318[(5)] = ex15286);


if((ex15286 instanceof Error)){
var statearr_15292_15319 = state_15266__$1;
(statearr_15292_15319[(1)] = (4));

(statearr_15292_15319[(5)] = null);

} else {
throw ex15286;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (14))){
var inst_15245 = (state_15266[(10)]);
var state_15266__$1 = state_15266;
var statearr_15293_15320 = state_15266__$1;
(statearr_15293_15320[(2)] = inst_15245);

(statearr_15293_15320[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (16))){
var inst_15259 = (state_15266[(2)]);
var state_15266__$1 = state_15266;
var statearr_15294_15321 = state_15266__$1;
(statearr_15294_15321[(2)] = inst_15259);

(statearr_15294_15321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (10))){
var inst_15245 = (state_15266[(10)]);
var inst_15245__$1 = (state_15266[(2)]);
var state_15266__$1 = (function (){var statearr_15295 = state_15266;
(statearr_15295[(10)] = inst_15245__$1);

return statearr_15295;
})();
if(cljs.core.truth_(inst_15245__$1)){
var statearr_15296_15322 = state_15266__$1;
(statearr_15296_15322[(1)] = (14));

} else {
var statearr_15297_15323 = state_15266__$1;
(statearr_15297_15323[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (18))){
var state_15266__$1 = state_15266;
var statearr_15298_15324 = state_15266__$1;
(statearr_15298_15324[(2)] = null);

(statearr_15298_15324[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (8))){
var inst_15261 = (state_15266[(2)]);
var _ = (function (){var statearr_15299 = state_15266;
(statearr_15299[(4)] = cljs.core.rest((state_15266[(4)])));

return statearr_15299;
})();
var state_15266__$1 = state_15266;
var statearr_15300_15325 = state_15266__$1;
(statearr_15300_15325[(2)] = inst_15261);

(statearr_15300_15325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto____0 = (function (){
var statearr_15301 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15301[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto__);

(statearr_15301[(1)] = (1));

return statearr_15301;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto____1 = (function (state_15266){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_15266);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e15302){var ex__2752__auto__ = e15302;
var statearr_15303_15326 = state_15266;
(statearr_15303_15326[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_15266[(4)]))){
var statearr_15304_15327 = state_15266;
(statearr_15304_15327[(1)] = cljs.core.first((state_15266[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15328 = state_15266;
state_15266 = G__15328;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto__ = function(state_15266){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto____1.call(this,state_15266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_15305 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_15305[(6)] = c__2771__auto__);

return statearr_15305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15335 = arguments.length;
switch (G__15335) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15336 = (function (){var pred__15339 = cljs.core.identical_QMARK_;
var expr__15340 = test;
if(cljs.core.truth_((pred__15339.cljs$core$IFn$_invoke$arity$2 ? pred__15339.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__15340) : pred__15339.call(null,cljs.core._EQ_,expr__15340)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15339.cljs$core$IFn$_invoke$arity$2 ? pred__15339.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__15340) : pred__15339.call(null,cljs.core._LT_,expr__15340)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__15339.cljs$core$IFn$_invoke$arity$2 ? pred__15339.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__15340) : pred__15339.call(null,cljs.core._LT__EQ_,expr__15340)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15339.cljs$core$IFn$_invoke$arity$2 ? pred__15339.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__15340) : pred__15339.call(null,cljs.core._GT_,expr__15340)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__15339.cljs$core$IFn$_invoke$arity$2 ? pred__15339.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__15340) : pred__15339.call(null,cljs.core._GT__EQ_,expr__15340)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15340)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15336,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15336,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15336,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15336,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_15712){
var state_val_15713 = (state_15712[(1)]);
if((state_val_15713 === (121))){
var inst_15668 = (state_15712[(7)]);
var state_15712__$1 = state_15712;
var statearr_15714_15910 = state_15712__$1;
(statearr_15714_15910[(2)] = inst_15668);

(statearr_15714_15910[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (65))){
var inst_15520 = (state_15712[(8)]);
var inst_15526 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15715 = state_15712;
(statearr_15715[(9)] = inst_15526);

return statearr_15715;
})();
if(cljs.core.truth_(inst_15520)){
var statearr_15716_15911 = state_15712__$1;
(statearr_15716_15911[(1)] = (66));

} else {
var statearr_15717_15912 = state_15712__$1;
(statearr_15717_15912[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (70))){
var inst_15704 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15718_15913 = state_15712__$1;
(statearr_15718_15913[(2)] = inst_15704);

(statearr_15718_15913[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (62))){
var inst_15519 = (state_15712[(2)]);
var inst_15520 = fluree.db.util.async.throw_err(inst_15519);
var inst_15521 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15712__$1 = (function (){var statearr_15719 = state_15712;
(statearr_15719[(8)] = inst_15520);

return statearr_15719;
})();
if(cljs.core.truth_(inst_15521)){
var statearr_15720_15914 = state_15712__$1;
(statearr_15720_15914[(1)] = (63));

} else {
var statearr_15721_15915 = state_15712__$1;
(statearr_15721_15915[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (74))){
var inst_15379 = (state_15712[(10)]);
var inst_15532 = (state_15712[(11)]);
var inst_15398 = (state_15712[(12)]);
var inst_15470 = (state_15712[(13)]);
var inst_15500 = (state_15712[(14)]);
var inst_15362 = (state_15712[(15)]);
var inst_15531 = (state_15712[(16)]);
var inst_15431 = (state_15712[(17)]);
var inst_15378 = (state_15712[(18)]);
var inst_15530 = (state_15712[(19)]);
var inst_15373 = (state_15712[(20)]);
var inst_15488 = (state_15712[(21)]);
var inst_15511 = (state_15712[(22)]);
var inst_15506 = (state_15712[(23)]);
var inst_15369 = (state_15712[(24)]);
var inst_15499 = (state_15712[(25)]);
var inst_15389 = (state_15712[(26)]);
var inst_15493 = (state_15712[(27)]);
var inst_15366 = (state_15712[(28)]);
var inst_15479 = (state_15712[(29)]);
var inst_15461 = (state_15712[(30)]);
var inst_15505 = (state_15712[(31)]);
var inst_15516 = (state_15712[(32)]);
var inst_15529 = (state_15712[(33)]);
var inst_15430 = (state_15712[(34)]);
var inst_15533 = (state_15712[(35)]);
var inst_15510 = (state_15712[(36)]);
var inst_15501 = (state_15712[(37)]);
var inst_15520 = (state_15712[(8)]);
var inst_15367 = (state_15712[(38)]);
var inst_15489 = (state_15712[(39)]);
var inst_15547 = (state_15712[(40)]);
var inst_15377 = (state_15712[(41)]);
var inst_15452 = (state_15712[(42)]);
var inst_15492 = (state_15712[(43)]);
var inst_15526 = (state_15712[(9)]);
var inst_15374 = (state_15712[(44)]);
var inst_15490 = (state_15712[(45)]);
var inst_15443 = (state_15712[(46)]);
var inst_15434 = (state_15712[(47)]);
var inst_15539 = (state_15712[(48)]);
var inst_15549 = (function (){var no_filter_QMARK_ = inst_15526;
var t = inst_15506;
var max_limit_QMARK_ = inst_15500;
var next_node = inst_15529;
var fast_forward_db_QMARK_ = inst_15511;
var s1 = inst_15389;
var o2 = inst_15452;
var t1 = inst_15366;
var predicate_fn = inst_15379;
var i = inst_15531;
var m1 = inst_15479;
var root_node = inst_15516;
var s2 = inst_15398;
var map__15361 = inst_15492;
var p2 = inst_15470;
var vec__15355 = inst_15430;
var permissions = inst_15501;
var G__15540 = inst_15547;
var limit = inst_15499;
var start_flake = inst_15489;
var flake_limit = inst_15493;
var offset = inst_15530;
var acc = inst_15533;
var t2 = inst_15373;
var map__15354 = inst_15377;
var op1 = inst_15367;
var o1 = inst_15443;
var end_flake = inst_15490;
var base_result = inst_15539;
var s = inst_15532;
var node_start = inst_15520;
var p1 = inst_15461;
var vec__15358 = inst_15431;
var subject_fn = inst_15378;
var vec__15348 = inst_15362;
var object_fn = inst_15434;
var idx_compare = inst_15505;
var vec__15351 = inst_15369;
var op2 = inst_15374;
var m2 = inst_15488;
var novelty = inst_15510;
return (function (p1__15330_SHARP_){
var G__15722 = p1__15330_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__15722) : subject_fn.call(null,G__15722));
});
})();
var inst_15550 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15549,inst_15547);
var state_15712__$1 = state_15712;
var statearr_15723_15916 = state_15712__$1;
(statearr_15723_15916[(2)] = inst_15550);

(statearr_15723_15916[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (110))){
var inst_15681 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15724_15917 = state_15712__$1;
(statearr_15724_15917[(2)] = inst_15681);

(statearr_15724_15917[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (7))){
var inst_15363 = (state_15712[(49)]);
var state_15712__$1 = state_15712;
var statearr_15725_15918 = state_15712__$1;
(statearr_15725_15918[(2)] = inst_15363);

(statearr_15725_15918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (59))){
var state_15712__$1 = state_15712;
var statearr_15726_15919 = state_15712__$1;
(statearr_15726_15919[(2)] = fluree.db.util.core.max_long);

(statearr_15726_15919[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (86))){
var inst_15526 = (state_15712[(9)]);
var state_15712__$1 = state_15712;
var statearr_15727_15920 = state_15712__$1;
(statearr_15727_15920[(2)] = inst_15526);

(statearr_15727_15920[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (20))){
var state_15712__$1 = state_15712;
var statearr_15728_15921 = state_15712__$1;
(statearr_15728_15921[(2)] = null);

(statearr_15728_15921[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (72))){
var inst_15539 = (state_15712[(48)]);
var state_15712__$1 = state_15712;
var statearr_15729_15922 = state_15712__$1;
(statearr_15729_15922[(2)] = inst_15539);

(statearr_15729_15922[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (58))){
var inst_15494 = (state_15712[(50)]);
var state_15712__$1 = state_15712;
var statearr_15730_15923 = state_15712__$1;
(statearr_15730_15923[(2)] = inst_15494);

(statearr_15730_15923[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (60))){
var inst_15499 = (state_15712[(25)]);
var inst_15499__$1 = (state_15712[(2)]);
var inst_15500 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15499__$1,fluree.db.util.core.max_long);
var inst_15501 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_15502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15503 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_15504 = (new cljs.core.PersistentVector(null,3,(5),inst_15502,inst_15503,null));
var inst_15505 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_15504);
var inst_15506 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_15507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15508 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_15509 = (new cljs.core.PersistentVector(null,2,(5),inst_15507,inst_15508,null));
var inst_15510 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_15509);
var inst_15511 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_15512 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_15513 = fluree.db.dbproto._resolve(inst_15512);
var state_15712__$1 = (function (){var statearr_15731 = state_15712;
(statearr_15731[(14)] = inst_15500);

(statearr_15731[(22)] = inst_15511);

(statearr_15731[(23)] = inst_15506);

(statearr_15731[(25)] = inst_15499__$1);

(statearr_15731[(31)] = inst_15505);

(statearr_15731[(36)] = inst_15510);

(statearr_15731[(37)] = inst_15501);

return statearr_15731;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(61),inst_15513);
} else {
if((state_val_15713 === (27))){
var inst_15432 = (state_15712[(51)]);
var state_15712__$1 = state_15712;
var statearr_15732_15924 = state_15712__$1;
(statearr_15732_15924[(2)] = inst_15432);

(statearr_15732_15924[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (1))){
var state_15712__$1 = state_15712;
var statearr_15733_15925 = state_15712__$1;
(statearr_15733_15925[(2)] = null);

(statearr_15733_15925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (69))){
var inst_15529 = (state_15712[(33)]);
var inst_15489 = (state_15712[(39)]);
var inst_15490 = (state_15712[(45)]);
var inst_15538 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_15529);
var inst_15539 = fluree.db.flake.subrange(inst_15538,start_test,inst_15489,end_test,inst_15490);
var inst_15541 = fluree.db.query.range.value_with_nil_pred(idx,inst_15489,inst_15490);
var state_15712__$1 = (function (){var statearr_15734 = state_15712;
(statearr_15734[(48)] = inst_15539);

return statearr_15734;
})();
if(inst_15541){
var statearr_15735_15926 = state_15712__$1;
(statearr_15735_15926[(1)] = (71));

} else {
var statearr_15736_15927 = state_15712__$1;
(statearr_15736_15927[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (101))){
var inst_15625 = (state_15712[(52)]);
var inst_15626 = (state_15712[(53)]);
var inst_15493 = (state_15712[(27)]);
var inst_15627 = (state_15712[(54)]);
var inst_15630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15631 = (inst_15627 - inst_15493);
var inst_15632 = (inst_15626 - inst_15631);
var inst_15633 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15632,inst_15625);
var inst_15634 = [inst_15493,inst_15633];
var inst_15635 = (new cljs.core.PersistentVector(null,2,(5),inst_15630,inst_15634,null));
var state_15712__$1 = state_15712;
var statearr_15737_15928 = state_15712__$1;
(statearr_15737_15928[(2)] = inst_15635);

(statearr_15737_15928[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (24))){
var inst_15379 = (state_15712[(10)]);
var inst_15398 = (state_15712[(12)]);
var inst_15380 = (state_15712[(55)]);
var inst_15371 = (state_15712[(56)]);
var inst_15362 = (state_15712[(15)]);
var inst_15378 = (state_15712[(18)]);
var inst_15412 = (state_15712[(57)]);
var inst_15368 = (state_15712[(58)]);
var inst_15373 = (state_15712[(20)]);
var inst_15369 = (state_15712[(24)]);
var inst_15372 = (state_15712[(59)]);
var inst_15389 = (state_15712[(26)]);
var inst_15366 = (state_15712[(28)]);
var inst_15365 = (state_15712[(60)]);
var inst_15375 = (state_15712[(61)]);
var inst_15364 = (state_15712[(62)]);
var inst_15367 = (state_15712[(38)]);
var inst_15377 = (state_15712[(41)]);
var inst_15374 = (state_15712[(44)]);
var inst_15422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15424 = [null,null];
var inst_15425 = (new cljs.core.PersistentVector(null,2,(5),inst_15423,inst_15424,null));
var inst_15426 = (function (){var bool = inst_15412;
var s1 = inst_15389;
var o2 = inst_15372;
var t1 = inst_15366;
var predicate_fn = inst_15379;
var m1 = inst_15368;
var s2 = inst_15398;
var p2 = inst_15371;
var t2 = inst_15373;
var map__15354 = inst_15377;
var op1 = inst_15367;
var o1 = inst_15365;
var p1 = inst_15364;
var subject_fn = inst_15378;
var vec__15348 = inst_15362;
var temp__5806__auto__ = inst_15412;
var object_fn = inst_15380;
var vec__15351 = inst_15369;
var op2 = inst_15374;
var m2 = inst_15375;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_15427 = [inst_15425,inst_15426];
var inst_15428 = (new cljs.core.PersistentVector(null,2,(5),inst_15422,inst_15427,null));
var state_15712__$1 = state_15712;
var statearr_15738_15929 = state_15712__$1;
(statearr_15738_15929[(2)] = inst_15428);

(statearr_15738_15929[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (102))){
var inst_15625 = (state_15712[(52)]);
var inst_15627 = (state_15712[(54)]);
var inst_15637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15638 = [inst_15627,inst_15625];
var inst_15639 = (new cljs.core.PersistentVector(null,2,(5),inst_15637,inst_15638,null));
var state_15712__$1 = state_15712;
var statearr_15739_15930 = state_15712__$1;
(statearr_15739_15930[(2)] = inst_15639);

(statearr_15739_15930[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (55))){
var state_15712__$1 = state_15712;
var statearr_15740_15931 = state_15712__$1;
(statearr_15740_15931[(2)] = (2147483647));

(statearr_15740_15931[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (85))){
var inst_15575 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
if(cljs.core.truth_(inst_15575)){
var statearr_15741_15932 = state_15712__$1;
(statearr_15741_15932[(1)] = (89));

} else {
var statearr_15742_15933 = state_15712__$1;
(statearr_15742_15933[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (39))){
var inst_15371 = (state_15712[(56)]);
var inst_15462 = (state_15712[(63)]);
var inst_15461 = (state_15712[(2)]);
var inst_15462__$1 = (inst_15371 == null);
var state_15712__$1 = (function (){var statearr_15743 = state_15712;
(statearr_15743[(30)] = inst_15461);

(statearr_15743[(63)] = inst_15462__$1);

return statearr_15743;
})();
if(cljs.core.truth_(inst_15462__$1)){
var statearr_15744_15934 = state_15712__$1;
(statearr_15744_15934[(1)] = (40));

} else {
var statearr_15745_15935 = state_15712__$1;
(statearr_15745_15935[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (88))){
var inst_15572 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15746_15936 = state_15712__$1;
(statearr_15746_15936[(2)] = inst_15572);

(statearr_15746_15936[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (46))){
var inst_15368 = (state_15712[(58)]);
var state_15712__$1 = state_15712;
var statearr_15747_15937 = state_15712__$1;
(statearr_15747_15937[(2)] = inst_15368);

(statearr_15747_15937[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (4))){
var inst_15342 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15748_15938 = state_15712__$1;
(statearr_15748_15938[(2)] = inst_15342);

(statearr_15748_15938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (77))){
var inst_15379 = (state_15712[(10)]);
var inst_15532 = (state_15712[(11)]);
var inst_15398 = (state_15712[(12)]);
var inst_15470 = (state_15712[(13)]);
var inst_15500 = (state_15712[(14)]);
var inst_15362 = (state_15712[(15)]);
var inst_15531 = (state_15712[(16)]);
var inst_15431 = (state_15712[(17)]);
var inst_15378 = (state_15712[(18)]);
var inst_15530 = (state_15712[(19)]);
var inst_15373 = (state_15712[(20)]);
var inst_15488 = (state_15712[(21)]);
var inst_15511 = (state_15712[(22)]);
var inst_15506 = (state_15712[(23)]);
var inst_15369 = (state_15712[(24)]);
var inst_15499 = (state_15712[(25)]);
var inst_15389 = (state_15712[(26)]);
var inst_15493 = (state_15712[(27)]);
var inst_15366 = (state_15712[(28)]);
var inst_15479 = (state_15712[(29)]);
var inst_15461 = (state_15712[(30)]);
var inst_15505 = (state_15712[(31)]);
var inst_15516 = (state_15712[(32)]);
var inst_15529 = (state_15712[(33)]);
var inst_15430 = (state_15712[(34)]);
var inst_15533 = (state_15712[(35)]);
var inst_15510 = (state_15712[(36)]);
var inst_15501 = (state_15712[(37)]);
var inst_15553 = (state_15712[(64)]);
var inst_15520 = (state_15712[(8)]);
var inst_15367 = (state_15712[(38)]);
var inst_15489 = (state_15712[(39)]);
var inst_15377 = (state_15712[(41)]);
var inst_15452 = (state_15712[(42)]);
var inst_15492 = (state_15712[(43)]);
var inst_15526 = (state_15712[(9)]);
var inst_15374 = (state_15712[(44)]);
var inst_15490 = (state_15712[(45)]);
var inst_15443 = (state_15712[(46)]);
var inst_15434 = (state_15712[(47)]);
var inst_15539 = (state_15712[(48)]);
var inst_15555 = (function (){var no_filter_QMARK_ = inst_15526;
var t = inst_15506;
var max_limit_QMARK_ = inst_15500;
var next_node = inst_15529;
var fast_forward_db_QMARK_ = inst_15511;
var s1 = inst_15389;
var o2 = inst_15452;
var t1 = inst_15366;
var predicate_fn = inst_15379;
var i = inst_15531;
var m1 = inst_15479;
var root_node = inst_15516;
var s2 = inst_15398;
var map__15361 = inst_15492;
var p2 = inst_15470;
var vec__15355 = inst_15430;
var permissions = inst_15501;
var G__15540 = inst_15553;
var limit = inst_15499;
var start_flake = inst_15489;
var flake_limit = inst_15493;
var offset = inst_15530;
var acc = inst_15533;
var t2 = inst_15373;
var map__15354 = inst_15377;
var op1 = inst_15367;
var o1 = inst_15443;
var end_flake = inst_15490;
var base_result = inst_15539;
var s = inst_15532;
var node_start = inst_15520;
var p1 = inst_15461;
var vec__15358 = inst_15431;
var subject_fn = inst_15378;
var vec__15348 = inst_15362;
var object_fn = inst_15434;
var idx_compare = inst_15505;
var vec__15351 = inst_15369;
var op2 = inst_15374;
var m2 = inst_15488;
var novelty = inst_15510;
return (function (p1__15331_SHARP_){
var G__15749 = p1__15331_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__15749) : predicate_fn.call(null,G__15749));
});
})();
var inst_15556 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15555,inst_15553);
var state_15712__$1 = state_15712;
var statearr_15750_15939 = state_15712__$1;
(statearr_15750_15939[(2)] = inst_15556);

(statearr_15750_15939[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (106))){
var inst_15566 = (state_15712[(65)]);
var state_15712__$1 = state_15712;
var statearr_15751_15940 = state_15712__$1;
(statearr_15751_15940[(2)] = inst_15566);

(statearr_15751_15940[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (119))){
var inst_15684 = (state_15712[(66)]);
var state_15712__$1 = state_15712;
var statearr_15752_15941 = state_15712__$1;
(statearr_15752_15941[(2)] = inst_15684);

(statearr_15752_15941[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (95))){
var inst_15532 = (state_15712[(11)]);
var inst_15499 = (state_15712[(25)]);
var inst_15607 = (state_15712[(67)]);
var inst_15609 = (state_15712[(68)]);
var inst_15599 = (state_15712[(69)]);
var inst_15608 = (state_15712[(70)]);
var inst_15607__$1 = cljs.core.count(inst_15599);
var inst_15608__$1 = (inst_15532 + inst_15607__$1);
var inst_15609__$1 = (inst_15608__$1 - inst_15499);
var inst_15610 = cljs.core.pos_int_QMARK_(inst_15609__$1);
var state_15712__$1 = (function (){var statearr_15753 = state_15712;
(statearr_15753[(67)] = inst_15607__$1);

(statearr_15753[(68)] = inst_15609__$1);

(statearr_15753[(70)] = inst_15608__$1);

return statearr_15753;
})();
if(inst_15610){
var statearr_15754_15942 = state_15712__$1;
(statearr_15754_15942[(1)] = (98));

} else {
var statearr_15755_15943 = state_15712__$1;
(statearr_15755_15943[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (54))){
var inst_15398 = (state_15712[(12)]);
var inst_15470 = (state_15712[(13)]);
var inst_15373 = (state_15712[(20)]);
var inst_15488 = (state_15712[(21)]);
var inst_15389 = (state_15712[(26)]);
var inst_15366 = (state_15712[(28)]);
var inst_15479 = (state_15712[(29)]);
var inst_15461 = (state_15712[(30)]);
var inst_15494 = (state_15712[(50)]);
var inst_15367 = (state_15712[(38)]);
var inst_15452 = (state_15712[(42)]);
var inst_15492 = (state_15712[(43)]);
var inst_15374 = (state_15712[(44)]);
var inst_15443 = (state_15712[(46)]);
var inst_15488__$1 = (state_15712[(2)]);
var inst_15489 = fluree.db.flake.__GT_Flake(inst_15389,inst_15461,inst_15443,inst_15366,inst_15367,inst_15479);
var inst_15490 = fluree.db.flake.__GT_Flake(inst_15398,inst_15470,inst_15452,inst_15373,inst_15374,inst_15488__$1);
var inst_15491 = opts;
var inst_15492__$1 = cljs.core.__destructure_map(inst_15491);
var inst_15493 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_15492__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_15494__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15492__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_15495 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_15492__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_15712__$1 = (function (){var statearr_15756 = state_15712;
(statearr_15756[(21)] = inst_15488__$1);

(statearr_15756[(71)] = inst_15495);

(statearr_15756[(27)] = inst_15493);

(statearr_15756[(50)] = inst_15494__$1);

(statearr_15756[(39)] = inst_15489);

(statearr_15756[(43)] = inst_15492__$1);

(statearr_15756[(45)] = inst_15490);

return statearr_15756;
})();
if(cljs.core.truth_(inst_15494__$1)){
var statearr_15757_15944 = state_15712__$1;
(statearr_15757_15944[(1)] = (58));

} else {
var statearr_15758_15945 = state_15712__$1;
(statearr_15758_15945[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (92))){
var inst_15532 = (state_15712[(11)]);
var inst_15588 = (state_15712[(72)]);
var inst_15531 = (state_15712[(16)]);
var inst_15530 = (state_15712[(19)]);
var inst_15533 = (state_15712[(35)]);
var inst_15591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15592 = (inst_15530 - inst_15588);
var inst_15593 = [inst_15592,inst_15531,inst_15532,inst_15533];
var inst_15594 = (new cljs.core.PersistentVector(null,4,(5),inst_15591,inst_15593,null));
var state_15712__$1 = state_15712;
var statearr_15759_15946 = state_15712__$1;
(statearr_15759_15946[(2)] = inst_15594);

(statearr_15759_15946[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (104))){
var inst_15650 = (state_15712[(2)]);
var inst_15651 = fluree.db.util.async.throw_err(inst_15650);
var state_15712__$1 = state_15712;
var statearr_15760_15947 = state_15712__$1;
(statearr_15760_15947[(2)] = inst_15651);

(statearr_15760_15947[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (15))){
var inst_15372 = (state_15712[(59)]);
var inst_15402 = cljs.core.boolean_QMARK_(inst_15372);
var state_15712__$1 = state_15712;
if(inst_15402){
var statearr_15761_15948 = state_15712__$1;
(statearr_15761_15948[(1)] = (17));

} else {
var statearr_15762_15949 = state_15712__$1;
(statearr_15762_15949[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (48))){
var inst_15375 = (state_15712[(61)]);
var inst_15479 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15763 = state_15712;
(statearr_15763[(29)] = inst_15479);

return statearr_15763;
})();
if(cljs.core.truth_(inst_15375)){
var statearr_15764_15950 = state_15712__$1;
(statearr_15764_15950[(1)] = (52));

} else {
var statearr_15765_15951 = state_15712__$1;
(statearr_15765_15951[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (50))){
var state_15712__$1 = state_15712;
var statearr_15766_15952 = state_15712__$1;
(statearr_15766_15952[(2)] = (2147483647));

(statearr_15766_15952[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (116))){
var inst_15684 = (state_15712[(66)]);
var inst_15692 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15767 = state_15712;
(statearr_15767[(73)] = inst_15692);

return statearr_15767;
})();
if(cljs.core.truth_(inst_15684)){
var statearr_15768_15953 = state_15712__$1;
(statearr_15768_15953[(1)] = (118));

} else {
var statearr_15769_15954 = state_15712__$1;
(statearr_15769_15954[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (75))){
var inst_15547 = (state_15712[(40)]);
var state_15712__$1 = state_15712;
var statearr_15770_15955 = state_15712__$1;
(statearr_15770_15955[(2)] = inst_15547);

(statearr_15770_15955[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (99))){
var inst_15608 = (state_15712[(70)]);
var inst_15617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15618 = [inst_15608,inst_15608];
var inst_15619 = (new cljs.core.PersistentVector(null,2,(5),inst_15617,inst_15618,null));
var state_15712__$1 = state_15712;
var statearr_15771_15956 = state_15712__$1;
(statearr_15771_15956[(2)] = inst_15619);

(statearr_15771_15956[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (21))){
var state_15712__$1 = state_15712;
var statearr_15772_15957 = state_15712__$1;
(statearr_15772_15957[(2)] = null);

(statearr_15772_15957[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (31))){
var inst_15433 = (state_15712[(74)]);
var state_15712__$1 = state_15712;
var statearr_15773_15958 = state_15712__$1;
(statearr_15773_15958[(2)] = inst_15433);

(statearr_15773_15958[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (113))){
var inst_15678 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15774_15959 = state_15712__$1;
(statearr_15774_15959[(2)] = inst_15678);

(statearr_15774_15959[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (32))){
var inst_15453 = (state_15712[(75)]);
var inst_15364 = (state_15712[(62)]);
var inst_15452 = (state_15712[(2)]);
var inst_15453__$1 = (inst_15364 == null);
var state_15712__$1 = (function (){var statearr_15775 = state_15712;
(statearr_15775[(75)] = inst_15453__$1);

(statearr_15775[(42)] = inst_15452);

return statearr_15775;
})();
if(cljs.core.truth_(inst_15453__$1)){
var statearr_15776_15960 = state_15712__$1;
(statearr_15776_15960[(1)] = (34));

} else {
var statearr_15777_15961 = state_15712__$1;
(statearr_15777_15961[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (40))){
var inst_15452 = (state_15712[(42)]);
var state_15712__$1 = state_15712;
var statearr_15778_15962 = state_15712__$1;
(statearr_15778_15962[(2)] = inst_15452);

(statearr_15778_15962[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (91))){
var inst_15566 = (state_15712[(65)]);
var inst_15664 = (state_15712[(2)]);
var inst_15665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15664,(0),null);
var inst_15666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15664,(1),null);
var inst_15667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15664,(2),null);
var inst_15668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15664,(3),null);
var state_15712__$1 = (function (){var statearr_15779 = state_15712;
(statearr_15779[(7)] = inst_15668);

(statearr_15779[(76)] = inst_15667);

(statearr_15779[(77)] = inst_15665);

(statearr_15779[(78)] = inst_15666);

return statearr_15779;
})();
if(cljs.core.truth_(inst_15566)){
var statearr_15780_15963 = state_15712__$1;
(statearr_15780_15963[(1)] = (105));

} else {
var statearr_15781_15964 = state_15712__$1;
(statearr_15781_15964[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (117))){
var inst_15688 = (state_15712[(2)]);
var inst_15689 = fluree.db.util.async.throw_err(inst_15688);
var state_15712__$1 = state_15712;
var statearr_15782_15965 = state_15712__$1;
(statearr_15782_15965[(2)] = inst_15689);

(statearr_15782_15965[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (108))){
var inst_15673 = (state_15712[(79)]);
var inst_15493 = (state_15712[(27)]);
var inst_15666 = (state_15712[(78)]);
var inst_15673__$1 = (inst_15666 < inst_15493);
var state_15712__$1 = (function (){var statearr_15783 = state_15712;
(statearr_15783[(79)] = inst_15673__$1);

return statearr_15783;
})();
if(cljs.core.truth_(inst_15673__$1)){
var statearr_15784_15966 = state_15712__$1;
(statearr_15784_15966[(1)] = (111));

} else {
var statearr_15785_15967 = state_15712__$1;
(statearr_15785_15967[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (56))){
var state_15712__$1 = state_15712;
var statearr_15786_15968 = state_15712__$1;
(statearr_15786_15968[(2)] = fluree.db.util.core.min_integer);

(statearr_15786_15968[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (33))){
var inst_15448 = (state_15712[(2)]);
var inst_15449 = fluree.db.util.async.throw_err(inst_15448);
var state_15712__$1 = state_15712;
var statearr_15787_15969 = state_15712__$1;
(statearr_15787_15969[(2)] = inst_15449);

(statearr_15787_15969[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (13))){
var inst_15394 = (state_15712[(2)]);
var inst_15395 = fluree.db.util.async.throw_err(inst_15394);
var state_15712__$1 = state_15712;
var statearr_15788_15970 = state_15712__$1;
(statearr_15788_15970[(2)] = inst_15395);

(statearr_15788_15970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (22))){
var inst_15408 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15789_15971 = state_15712__$1;
(statearr_15789_15971[(2)] = inst_15408);

(statearr_15789_15971[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (90))){
var inst_15379 = (state_15712[(10)]);
var inst_15532 = (state_15712[(11)]);
var inst_15398 = (state_15712[(12)]);
var inst_15588 = (state_15712[(72)]);
var inst_15470 = (state_15712[(13)]);
var inst_15500 = (state_15712[(14)]);
var inst_15362 = (state_15712[(15)]);
var inst_15531 = (state_15712[(16)]);
var inst_15431 = (state_15712[(17)]);
var inst_15587 = (state_15712[(80)]);
var inst_15378 = (state_15712[(18)]);
var inst_15565 = (state_15712[(81)]);
var inst_15530 = (state_15712[(19)]);
var inst_15373 = (state_15712[(20)]);
var inst_15488 = (state_15712[(21)]);
var inst_15511 = (state_15712[(22)]);
var inst_15506 = (state_15712[(23)]);
var inst_15369 = (state_15712[(24)]);
var inst_15499 = (state_15712[(25)]);
var inst_15389 = (state_15712[(26)]);
var inst_15493 = (state_15712[(27)]);
var inst_15366 = (state_15712[(28)]);
var inst_15479 = (state_15712[(29)]);
var inst_15461 = (state_15712[(30)]);
var inst_15505 = (state_15712[(31)]);
var inst_15516 = (state_15712[(32)]);
var inst_15529 = (state_15712[(33)]);
var inst_15430 = (state_15712[(34)]);
var inst_15533 = (state_15712[(35)]);
var inst_15566 = (state_15712[(65)]);
var inst_15510 = (state_15712[(36)]);
var inst_15501 = (state_15712[(37)]);
var inst_15520 = (state_15712[(8)]);
var inst_15367 = (state_15712[(38)]);
var inst_15489 = (state_15712[(39)]);
var inst_15377 = (state_15712[(41)]);
var inst_15452 = (state_15712[(42)]);
var inst_15492 = (state_15712[(43)]);
var inst_15526 = (state_15712[(9)]);
var inst_15374 = (state_15712[(44)]);
var inst_15490 = (state_15712[(45)]);
var inst_15443 = (state_15712[(46)]);
var inst_15434 = (state_15712[(47)]);
var inst_15539 = (state_15712[(48)]);
var inst_15586 = (function (){var no_filter_QMARK_ = inst_15526;
var base_result_SINGLEQUOTE_ = inst_15565;
var t = inst_15506;
var max_limit_QMARK_ = inst_15500;
var next_node = inst_15529;
var fast_forward_db_QMARK_ = inst_15511;
var s1 = inst_15389;
var o2 = inst_15452;
var t1 = inst_15366;
var predicate_fn = inst_15379;
var i = inst_15531;
var rhs = inst_15566;
var m1 = inst_15479;
var root_node = inst_15516;
var s2 = inst_15398;
var map__15361 = inst_15492;
var p2 = inst_15470;
var vec__15355 = inst_15430;
var permissions = inst_15501;
var limit = inst_15499;
var start_flake = inst_15489;
var flake_limit = inst_15493;
var offset = inst_15530;
var acc = inst_15533;
var t2 = inst_15373;
var map__15354 = inst_15377;
var op1 = inst_15367;
var o1 = inst_15443;
var end_flake = inst_15490;
var base_result = inst_15539;
var s = inst_15532;
var node_start = inst_15520;
var p1 = inst_15461;
var vec__15358 = inst_15431;
var subject_fn = inst_15378;
var vec__15348 = inst_15362;
var object_fn = inst_15434;
var idx_compare = inst_15505;
var vec__15351 = inst_15369;
var op2 = inst_15374;
var m2 = inst_15488;
var novelty = inst_15510;
return (function (p1__15333_SHARP_){
return p1__15333_SHARP_.s;
});
})();
var inst_15587__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_15586,inst_15565);
var inst_15588__$1 = cljs.core.count(inst_15587__$1);
var inst_15589 = (inst_15530 > inst_15588__$1);
var state_15712__$1 = (function (){var statearr_15790 = state_15712;
(statearr_15790[(72)] = inst_15588__$1);

(statearr_15790[(80)] = inst_15587__$1);

return statearr_15790;
})();
if(cljs.core.truth_(inst_15589)){
var statearr_15791_15972 = state_15712__$1;
(statearr_15791_15972[(1)] = (92));

} else {
var statearr_15792_15973 = state_15712__$1;
(statearr_15792_15973[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (109))){
var inst_15671 = (state_15712[(82)]);
var state_15712__$1 = state_15712;
var statearr_15793_15974 = state_15712__$1;
(statearr_15793_15974[(2)] = inst_15671);

(statearr_15793_15974[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (36))){
var inst_15457 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
if(cljs.core.truth_(inst_15457)){
var statearr_15794_15975 = state_15712__$1;
(statearr_15794_15975[(1)] = (37));

} else {
var statearr_15795_15976 = state_15712__$1;
(statearr_15795_15976[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (41))){
var inst_15462 = (state_15712[(63)]);
var state_15712__$1 = state_15712;
var statearr_15796_15977 = state_15712__$1;
(statearr_15796_15977[(2)] = inst_15462);

(statearr_15796_15977[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (118))){
var inst_15692 = (state_15712[(73)]);
var state_15712__$1 = state_15712;
var statearr_15797_15978 = state_15712__$1;
(statearr_15797_15978[(2)] = inst_15692);

(statearr_15797_15978[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (89))){
var inst_15532 = (state_15712[(11)]);
var inst_15531 = (state_15712[(16)]);
var inst_15565 = (state_15712[(81)]);
var inst_15493 = (state_15712[(27)]);
var inst_15533 = (state_15712[(35)]);
var inst_15577 = cljs.core.count(inst_15565);
var inst_15578 = (inst_15493 - inst_15531);
var inst_15579 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15578,inst_15565);
var inst_15580 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15533,inst_15579);
var inst_15581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15582 = (inst_15531 + inst_15577);
var inst_15583 = [(0),inst_15582,inst_15532,inst_15580];
var inst_15584 = (new cljs.core.PersistentVector(null,4,(5),inst_15581,inst_15583,null));
var state_15712__$1 = state_15712;
var statearr_15798_15979 = state_15712__$1;
(statearr_15798_15979[(2)] = inst_15584);

(statearr_15798_15979[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (100))){
var inst_15531 = (state_15712[(16)]);
var inst_15625 = (state_15712[(52)]);
var inst_15626 = (state_15712[(53)]);
var inst_15493 = (state_15712[(27)]);
var inst_15627 = (state_15712[(54)]);
var inst_15599 = (state_15712[(69)]);
var inst_15621 = (state_15712[(2)]);
var inst_15622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15621,(0),null);
var inst_15623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15621,(1),null);
var inst_15624 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15623,inst_15599);
var inst_15625__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_15624);
var inst_15626__$1 = cljs.core.count(inst_15625__$1);
var inst_15627__$1 = (inst_15531 + inst_15626__$1);
var inst_15628 = (inst_15627__$1 > inst_15493);
var state_15712__$1 = (function (){var statearr_15799 = state_15712;
(statearr_15799[(52)] = inst_15625__$1);

(statearr_15799[(53)] = inst_15626__$1);

(statearr_15799[(83)] = inst_15622);

(statearr_15799[(54)] = inst_15627__$1);

return statearr_15799;
})();
if(cljs.core.truth_(inst_15628)){
var statearr_15800_15980 = state_15712__$1;
(statearr_15800_15980[(1)] = (101));

} else {
var statearr_15801_15981 = state_15712__$1;
(statearr_15801_15981[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (122))){
var inst_15668 = (state_15712[(7)]);
var inst_15667 = (state_15712[(76)]);
var inst_15692 = (state_15712[(73)]);
var inst_15665 = (state_15712[(77)]);
var inst_15666 = (state_15712[(78)]);
var inst_15529 = inst_15692;
var inst_15530 = inst_15665;
var inst_15531 = inst_15666;
var inst_15532 = inst_15667;
var inst_15533 = inst_15668;
var state_15712__$1 = (function (){var statearr_15802 = state_15712;
(statearr_15802[(11)] = inst_15532);

(statearr_15802[(16)] = inst_15531);

(statearr_15802[(19)] = inst_15530);

(statearr_15802[(33)] = inst_15529);

(statearr_15802[(35)] = inst_15533);

return statearr_15802;
})();
var statearr_15803_15982 = state_15712__$1;
(statearr_15803_15982[(2)] = null);

(statearr_15803_15982[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (43))){
var state_15712__$1 = state_15712;
var statearr_15804_15983 = state_15712__$1;
(statearr_15804_15983[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15804_15983[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (61))){
var inst_15511 = (state_15712[(22)]);
var inst_15506 = (state_15712[(23)]);
var inst_15516 = (state_15712[(32)]);
var inst_15510 = (state_15712[(36)]);
var inst_15489 = (state_15712[(39)]);
var inst_15515 = (state_15712[(2)]);
var inst_15516__$1 = fluree.db.util.async.throw_err(inst_15515);
var inst_15517 = fluree.db.query.range.find_next_valid_node(inst_15516__$1,inst_15489,inst_15506,inst_15510,inst_15511);
var state_15712__$1 = (function (){var statearr_15805 = state_15712;
(statearr_15805[(32)] = inst_15516__$1);

return statearr_15805;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(62),inst_15517);
} else {
if((state_val_15713 === (29))){
var inst_15439 = (state_15712[(2)]);
var inst_15440 = fluree.db.util.async.throw_err(inst_15439);
var state_15712__$1 = state_15712;
var statearr_15806_15984 = state_15712__$1;
(statearr_15806_15984[(2)] = inst_15440);

(statearr_15806_15984[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (44))){
var inst_15371 = (state_15712[(56)]);
var state_15712__$1 = state_15712;
var statearr_15807_15985 = state_15712__$1;
(statearr_15807_15985[(2)] = inst_15371);

(statearr_15807_15985[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (93))){
var inst_15587 = (state_15712[(80)]);
var inst_15530 = (state_15712[(19)]);
var inst_15526 = (state_15712[(9)]);
var inst_15599 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_15530,inst_15587);
var state_15712__$1 = (function (){var statearr_15808 = state_15712;
(statearr_15808[(69)] = inst_15599);

return statearr_15808;
})();
if(cljs.core.truth_(inst_15526)){
var statearr_15809_15986 = state_15712__$1;
(statearr_15809_15986[(1)] = (95));

} else {
var statearr_15810_15987 = state_15712__$1;
(statearr_15810_15987[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (6))){
var inst_15363 = (state_15712[(49)]);
var inst_15383 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15363);
var state_15712__$1 = state_15712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(9),inst_15383);
} else {
if((state_val_15713 === (111))){
var inst_15499 = (state_15712[(25)]);
var inst_15667 = (state_15712[(76)]);
var inst_15675 = (inst_15667 < inst_15499);
var state_15712__$1 = state_15712;
var statearr_15811_15988 = state_15712__$1;
(statearr_15811_15988[(2)] = inst_15675);

(statearr_15811_15988[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (28))){
var inst_15433 = (state_15712[(74)]);
var inst_15443 = (state_15712[(2)]);
var inst_15444 = fluree.db.util.core.pred_ident_QMARK_(inst_15433);
var state_15712__$1 = (function (){var statearr_15812 = state_15712;
(statearr_15812[(46)] = inst_15443);

return statearr_15812;
})();
if(inst_15444){
var statearr_15813_15989 = state_15712__$1;
(statearr_15813_15989[(1)] = (30));

} else {
var statearr_15814_15990 = state_15712__$1;
(statearr_15814_15990[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (64))){
var state_15712__$1 = state_15712;
var statearr_15815_15991 = state_15712__$1;
(statearr_15815_15991[(2)] = true);

(statearr_15815_15991[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (103))){
var inst_15622 = (state_15712[(83)]);
var inst_15641 = (state_15712[(2)]);
var inst_15642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15641,(0),null);
var inst_15643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15641,(1),null);
var inst_15644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15645 = [inst_15642,inst_15622,inst_15643];
var inst_15646 = (new cljs.core.PersistentVector(null,3,(5),inst_15644,inst_15645,null));
var state_15712__$1 = state_15712;
var statearr_15816_15992 = state_15712__$1;
(statearr_15816_15992[(2)] = inst_15646);

(statearr_15816_15992[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (51))){
var inst_15477 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15817_15993 = state_15712__$1;
(statearr_15817_15993[(2)] = inst_15477);

(statearr_15817_15993[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (25))){
var inst_15431 = (state_15712[(17)]);
var inst_15430 = (state_15712[(34)]);
var inst_15432 = (state_15712[(51)]);
var inst_15430__$1 = (state_15712[(2)]);
var inst_15431__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15430__$1,(0),null);
var inst_15432__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15431__$1,(0),null);
var inst_15433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15431__$1,(1),null);
var inst_15434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15430__$1,(1),null);
var inst_15435 = fluree.db.util.core.pred_ident_QMARK_(inst_15432__$1);
var state_15712__$1 = (function (){var statearr_15818 = state_15712;
(statearr_15818[(17)] = inst_15431__$1);

(statearr_15818[(34)] = inst_15430__$1);

(statearr_15818[(51)] = inst_15432__$1);

(statearr_15818[(74)] = inst_15433);

(statearr_15818[(47)] = inst_15434);

return statearr_15818;
})();
if(inst_15435){
var statearr_15819_15994 = state_15712__$1;
(statearr_15819_15994[(1)] = (26));

} else {
var statearr_15820_15995 = state_15712__$1;
(statearr_15820_15995[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (34))){
var inst_15443 = (state_15712[(46)]);
var state_15712__$1 = state_15712;
var statearr_15821_15996 = state_15712__$1;
(statearr_15821_15996[(2)] = inst_15443);

(statearr_15821_15996[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (17))){
var inst_15372 = (state_15712[(59)]);
var state_15712__$1 = state_15712;
var statearr_15822_15997 = state_15712__$1;
(statearr_15822_15997[(2)] = inst_15372);

(statearr_15822_15997[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (3))){
var inst_15710 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15712__$1,inst_15710);
} else {
if((state_val_15713 === (12))){
var inst_15365 = (state_15712[(60)]);
var inst_15398 = (state_15712[(2)]);
var inst_15399 = cljs.core.boolean_QMARK_(inst_15365);
var state_15712__$1 = (function (){var statearr_15823 = state_15712;
(statearr_15823[(12)] = inst_15398);

return statearr_15823;
})();
if(inst_15399){
var statearr_15824_15998 = state_15712__$1;
(statearr_15824_15998[(1)] = (14));

} else {
var statearr_15825_15999 = state_15712__$1;
(statearr_15825_15999[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (2))){
var inst_15363 = (state_15712[(49)]);
var inst_15362 = (state_15712[(15)]);
var inst_15369 = (state_15712[(24)]);
var inst_15377 = (state_15712[(41)]);
var _ = (function (){var statearr_15826 = state_15712;
(statearr_15826[(4)] = cljs.core.cons((5),(state_15712[(4)])));

return statearr_15826;
})();
var inst_15362__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_15363__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15362__$1,(0),null);
var inst_15364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15362__$1,(1),null);
var inst_15365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15362__$1,(2),null);
var inst_15366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15362__$1,(3),null);
var inst_15367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15362__$1,(4),null);
var inst_15368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15362__$1,(5),null);
var inst_15369__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_15370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15369__$1,(0),null);
var inst_15371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15369__$1,(1),null);
var inst_15372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15369__$1,(2),null);
var inst_15373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15369__$1,(3),null);
var inst_15374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15369__$1,(4),null);
var inst_15375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15369__$1,(5),null);
var inst_15376 = opts;
var inst_15377__$1 = cljs.core.__destructure_map(inst_15376);
var inst_15378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15377__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_15379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15377__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_15380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15377__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_15381 = fluree.db.util.core.pred_ident_QMARK_(inst_15363__$1);
var state_15712__$1 = (function (){var statearr_15827 = state_15712;
(statearr_15827[(10)] = inst_15379);

(statearr_15827[(55)] = inst_15380);

(statearr_15827[(56)] = inst_15371);

(statearr_15827[(49)] = inst_15363__$1);

(statearr_15827[(15)] = inst_15362__$1);

(statearr_15827[(18)] = inst_15378);

(statearr_15827[(58)] = inst_15368);

(statearr_15827[(20)] = inst_15373);

(statearr_15827[(24)] = inst_15369__$1);

(statearr_15827[(59)] = inst_15372);

(statearr_15827[(28)] = inst_15366);

(statearr_15827[(60)] = inst_15365);

(statearr_15827[(84)] = inst_15370);

(statearr_15827[(61)] = inst_15375);

(statearr_15827[(62)] = inst_15364);

(statearr_15827[(38)] = inst_15367);

(statearr_15827[(41)] = inst_15377__$1);

(statearr_15827[(44)] = inst_15374);

return statearr_15827;
})();
if(inst_15381){
var statearr_15828_16000 = state_15712__$1;
(statearr_15828_16000[(1)] = (6));

} else {
var statearr_15829_16001 = state_15712__$1;
(statearr_15829_16001[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (66))){
var inst_15495 = (state_15712[(71)]);
var inst_15520 = (state_15712[(8)]);
var inst_15528 = cljs.core.PersistentVector.EMPTY;
var inst_15529 = inst_15520;
var inst_15530 = inst_15495;
var inst_15531 = (0);
var inst_15532 = (0);
var inst_15533 = inst_15528;
var state_15712__$1 = (function (){var statearr_15830 = state_15712;
(statearr_15830[(11)] = inst_15532);

(statearr_15830[(16)] = inst_15531);

(statearr_15830[(19)] = inst_15530);

(statearr_15830[(33)] = inst_15529);

(statearr_15830[(35)] = inst_15533);

return statearr_15830;
})();
var statearr_15831_16002 = state_15712__$1;
(statearr_15831_16002[(2)] = null);

(statearr_15831_16002[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (107))){
var inst_15684 = (state_15712[(66)]);
var inst_15684__$1 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15832 = state_15712;
(statearr_15832[(66)] = inst_15684__$1);

return statearr_15832;
})();
if(cljs.core.truth_(inst_15684__$1)){
var statearr_15833_16003 = state_15712__$1;
(statearr_15833_16003[(1)] = (114));

} else {
var statearr_15834_16004 = state_15712__$1;
(statearr_15834_16004[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (23))){
var inst_15380 = (state_15712[(55)]);
var inst_15372 = (state_15712[(59)]);
var inst_15365 = (state_15712[(60)]);
var inst_15415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15417 = [inst_15365,inst_15372];
var inst_15418 = (new cljs.core.PersistentVector(null,2,(5),inst_15416,inst_15417,null));
var inst_15419 = [inst_15418,inst_15380];
var inst_15420 = (new cljs.core.PersistentVector(null,2,(5),inst_15415,inst_15419,null));
var state_15712__$1 = state_15712;
var statearr_15835_16005 = state_15712__$1;
(statearr_15835_16005[(2)] = inst_15420);

(statearr_15835_16005[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (47))){
var inst_15473 = (cljs.core._GT__EQ_ === start_test);
var state_15712__$1 = state_15712;
if(cljs.core.truth_(inst_15473)){
var statearr_15836_16006 = state_15712__$1;
(statearr_15836_16006[(1)] = (49));

} else {
var statearr_15837_16007 = state_15712__$1;
(statearr_15837_16007[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (35))){
var inst_15453 = (state_15712[(75)]);
var state_15712__$1 = state_15712;
var statearr_15838_16008 = state_15712__$1;
(statearr_15838_16008[(2)] = inst_15453);

(statearr_15838_16008[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (82))){
var inst_15500 = (state_15712[(14)]);
var inst_15529 = (state_15712[(33)]);
var inst_15565 = (state_15712[(2)]);
var inst_15566 = fluree.db.dbproto._rhs(inst_15529);
var state_15712__$1 = (function (){var statearr_15839 = state_15712;
(statearr_15839[(81)] = inst_15565);

(statearr_15839[(65)] = inst_15566);

return statearr_15839;
})();
if(cljs.core.truth_(inst_15500)){
var statearr_15840_16009 = state_15712__$1;
(statearr_15840_16009[(1)] = (83));

} else {
var statearr_15841_16010 = state_15712__$1;
(statearr_15841_16010[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (76))){
var inst_15379 = (state_15712[(10)]);
var inst_15553 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15842 = state_15712;
(statearr_15842[(64)] = inst_15553);

return statearr_15842;
})();
if(cljs.core.truth_(inst_15379)){
var statearr_15843_16011 = state_15712__$1;
(statearr_15843_16011[(1)] = (77));

} else {
var statearr_15844_16012 = state_15712__$1;
(statearr_15844_16012[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (97))){
var inst_15533 = (state_15712[(35)]);
var inst_15653 = (state_15712[(2)]);
var inst_15654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15653,(0),null);
var inst_15655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15653,(1),null);
var inst_15656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15653,(2),null);
var inst_15657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15658 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15533,inst_15656);
var inst_15659 = [(0),inst_15654,inst_15655,inst_15658];
var inst_15660 = (new cljs.core.PersistentVector(null,4,(5),inst_15657,inst_15659,null));
var state_15712__$1 = state_15712;
var statearr_15845_16013 = state_15712__$1;
(statearr_15845_16013[(2)] = inst_15660);

(statearr_15845_16013[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (19))){
var inst_15410 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15846_16014 = state_15712__$1;
(statearr_15846_16014[(2)] = inst_15410);

(statearr_15846_16014[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (57))){
var inst_15486 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15847_16015 = state_15712__$1;
(statearr_15847_16015[(2)] = inst_15486);

(statearr_15847_16015[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (68))){
var inst_15707 = (state_15712[(2)]);
var _ = (function (){var statearr_15848 = state_15712;
(statearr_15848[(4)] = cljs.core.rest((state_15712[(4)])));

return statearr_15848;
})();
var state_15712__$1 = state_15712;
var statearr_15849_16016 = state_15712__$1;
(statearr_15849_16016[(2)] = inst_15707);

(statearr_15849_16016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (11))){
var inst_15370 = (state_15712[(84)]);
var state_15712__$1 = state_15712;
var statearr_15850_16017 = state_15712__$1;
(statearr_15850_16017[(2)] = inst_15370);

(statearr_15850_16017[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (115))){
var state_15712__$1 = state_15712;
var statearr_15852_16018 = state_15712__$1;
(statearr_15852_16018[(2)] = null);

(statearr_15852_16018[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (9))){
var inst_15385 = (state_15712[(2)]);
var inst_15386 = fluree.db.util.async.throw_err(inst_15385);
var state_15712__$1 = state_15712;
var statearr_15853_16019 = state_15712__$1;
(statearr_15853_16019[(2)] = inst_15386);

(statearr_15853_16019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (5))){
var _ = (function (){var statearr_15854 = state_15712;
(statearr_15854[(4)] = cljs.core.rest((state_15712[(4)])));

return statearr_15854;
})();
var state_15712__$1 = state_15712;
var ex15851 = (state_15712__$1[(2)]);
var statearr_15855_16020 = state_15712__$1;
(statearr_15855_16020[(5)] = ex15851);


if((ex15851 instanceof Error)){
var statearr_15856_16021 = state_15712__$1;
(statearr_15856_16021[(1)] = (4));

(statearr_15856_16021[(5)] = null);

} else {
throw ex15851;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (112))){
var inst_15673 = (state_15712[(79)]);
var state_15712__$1 = state_15712;
var statearr_15857_16022 = state_15712__$1;
(statearr_15857_16022[(2)] = inst_15673);

(statearr_15857_16022[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (83))){
var inst_15568 = (state_15712[(85)]);
var inst_15530 = (state_15712[(19)]);
var inst_15568__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_15530);
var state_15712__$1 = (function (){var statearr_15858 = state_15712;
(statearr_15858[(85)] = inst_15568__$1);

return statearr_15858;
})();
if(inst_15568__$1){
var statearr_15859_16023 = state_15712__$1;
(statearr_15859_16023[(1)] = (86));

} else {
var statearr_15860_16024 = state_15712__$1;
(statearr_15860_16024[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (14))){
var inst_15365 = (state_15712[(60)]);
var state_15712__$1 = state_15712;
var statearr_15861_16025 = state_15712__$1;
(statearr_15861_16025[(2)] = inst_15365);

(statearr_15861_16025[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (45))){
var inst_15368 = (state_15712[(58)]);
var inst_15470 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15862 = state_15712;
(statearr_15862[(13)] = inst_15470);

return statearr_15862;
})();
if(cljs.core.truth_(inst_15368)){
var statearr_15863_16026 = state_15712__$1;
(statearr_15863_16026[(1)] = (46));

} else {
var statearr_15864_16027 = state_15712__$1;
(statearr_15864_16027[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (53))){
var inst_15482 = (cljs.core._LT__EQ_ === end_test);
var state_15712__$1 = state_15712;
if(cljs.core.truth_(inst_15482)){
var statearr_15865_16028 = state_15712__$1;
(statearr_15865_16028[(1)] = (55));

} else {
var statearr_15866_16029 = state_15712__$1;
(statearr_15866_16029[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (78))){
var inst_15553 = (state_15712[(64)]);
var state_15712__$1 = state_15712;
var statearr_15867_16030 = state_15712__$1;
(statearr_15867_16030[(2)] = inst_15553);

(statearr_15867_16030[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (26))){
var inst_15432 = (state_15712[(51)]);
var inst_15437 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15432);
var state_15712__$1 = state_15712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(29),inst_15437);
} else {
if((state_val_15713 === (123))){
var inst_15702 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15868_16031 = state_15712__$1;
(statearr_15868_16031[(2)] = inst_15702);

(statearr_15868_16031[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (16))){
var inst_15412 = (state_15712[(57)]);
var inst_15412__$1 = (state_15712[(2)]);
var inst_15413 = (inst_15412__$1 == null);
var state_15712__$1 = (function (){var statearr_15869 = state_15712;
(statearr_15869[(57)] = inst_15412__$1);

return statearr_15869;
})();
if(cljs.core.truth_(inst_15413)){
var statearr_15870_16032 = state_15712__$1;
(statearr_15870_16032[(1)] = (23));

} else {
var statearr_15871_16033 = state_15712__$1;
(statearr_15871_16033[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (81))){
var inst_15559 = (state_15712[(86)]);
var state_15712__$1 = state_15712;
var statearr_15872_16034 = state_15712__$1;
(statearr_15872_16034[(2)] = inst_15559);

(statearr_15872_16034[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (120))){
var inst_15696 = (state_15712[(2)]);
var inst_15697 = cljs.core.not(inst_15696);
var state_15712__$1 = state_15712;
if(inst_15697){
var statearr_15873_16035 = state_15712__$1;
(statearr_15873_16035[(1)] = (121));

} else {
var statearr_15874_16036 = state_15712__$1;
(statearr_15874_16036[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (79))){
var inst_15434 = (state_15712[(47)]);
var inst_15559 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15875 = state_15712;
(statearr_15875[(86)] = inst_15559);

return statearr_15875;
})();
if(cljs.core.truth_(inst_15434)){
var statearr_15876_16037 = state_15712__$1;
(statearr_15876_16037[(1)] = (80));

} else {
var statearr_15877_16038 = state_15712__$1;
(statearr_15877_16038[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (38))){
var inst_15364 = (state_15712[(62)]);
var state_15712__$1 = state_15712;
var statearr_15878_16039 = state_15712__$1;
(statearr_15878_16039[(2)] = inst_15364);

(statearr_15878_16039[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (98))){
var inst_15499 = (state_15712[(25)]);
var inst_15607 = (state_15712[(67)]);
var inst_15609 = (state_15712[(68)]);
var inst_15612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15613 = (inst_15607 - inst_15609);
var inst_15614 = [inst_15499,inst_15613];
var inst_15615 = (new cljs.core.PersistentVector(null,2,(5),inst_15612,inst_15614,null));
var state_15712__$1 = state_15712;
var statearr_15879_16040 = state_15712__$1;
(statearr_15879_16040[(2)] = inst_15615);

(statearr_15879_16040[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (87))){
var inst_15568 = (state_15712[(85)]);
var state_15712__$1 = state_15712;
var statearr_15880_16041 = state_15712__$1;
(statearr_15880_16041[(2)] = inst_15568);

(statearr_15880_16041[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (30))){
var inst_15433 = (state_15712[(74)]);
var inst_15446 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15433);
var state_15712__$1 = state_15712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(33),inst_15446);
} else {
if((state_val_15713 === (73))){
var inst_15378 = (state_15712[(18)]);
var inst_15547 = (state_15712[(2)]);
var state_15712__$1 = (function (){var statearr_15881 = state_15712;
(statearr_15881[(40)] = inst_15547);

return statearr_15881;
})();
if(cljs.core.truth_(inst_15378)){
var statearr_15882_16042 = state_15712__$1;
(statearr_15882_16042[(1)] = (74));

} else {
var statearr_15883_16043 = state_15712__$1;
(statearr_15883_16043[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (96))){
var inst_15532 = (state_15712[(11)]);
var inst_15531 = (state_15712[(16)]);
var inst_15499 = (state_15712[(25)]);
var inst_15493 = (state_15712[(27)]);
var inst_15599 = (state_15712[(69)]);
var inst_15648 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_15599,inst_15531,inst_15532,inst_15493,inst_15499);
var state_15712__$1 = state_15712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(104),inst_15648);
} else {
if((state_val_15713 === (10))){
var inst_15370 = (state_15712[(84)]);
var inst_15392 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15370);
var state_15712__$1 = state_15712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(13),inst_15392);
} else {
if((state_val_15713 === (18))){
var state_15712__$1 = state_15712;
var statearr_15884_16044 = state_15712__$1;
(statearr_15884_16044[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (105))){
var inst_15671 = (state_15712[(82)]);
var inst_15505 = (state_15712[(31)]);
var inst_15566 = (state_15712[(65)]);
var inst_15490 = (state_15712[(45)]);
var inst_15670 = (inst_15505.cljs$core$IFn$_invoke$arity$2 ? inst_15505.cljs$core$IFn$_invoke$arity$2(inst_15566,inst_15490) : inst_15505.call(null,inst_15566,inst_15490));
var inst_15671__$1 = (inst_15670 < (0));
var state_15712__$1 = (function (){var statearr_15886 = state_15712;
(statearr_15886[(82)] = inst_15671__$1);

return statearr_15886;
})();
if(cljs.core.truth_(inst_15671__$1)){
var statearr_15887_16045 = state_15712__$1;
(statearr_15887_16045[(1)] = (108));

} else {
var statearr_15888_16046 = state_15712__$1;
(statearr_15888_16046[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (52))){
var inst_15375 = (state_15712[(61)]);
var state_15712__$1 = state_15712;
var statearr_15889_16047 = state_15712__$1;
(statearr_15889_16047[(2)] = inst_15375);

(statearr_15889_16047[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (114))){
var inst_15511 = (state_15712[(22)]);
var inst_15506 = (state_15712[(23)]);
var inst_15516 = (state_15712[(32)]);
var inst_15566 = (state_15712[(65)]);
var inst_15510 = (state_15712[(36)]);
var inst_15686 = fluree.db.query.range.find_next_valid_node(inst_15516,inst_15566,inst_15506,inst_15510,inst_15511);
var state_15712__$1 = state_15712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15712__$1,(117),inst_15686);
} else {
if((state_val_15713 === (67))){
var state_15712__$1 = state_15712;
var statearr_15890_16048 = state_15712__$1;
(statearr_15890_16048[(2)] = null);

(statearr_15890_16048[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (71))){
var inst_15379 = (state_15712[(10)]);
var inst_15532 = (state_15712[(11)]);
var inst_15398 = (state_15712[(12)]);
var inst_15470 = (state_15712[(13)]);
var inst_15500 = (state_15712[(14)]);
var inst_15362 = (state_15712[(15)]);
var inst_15531 = (state_15712[(16)]);
var inst_15431 = (state_15712[(17)]);
var inst_15378 = (state_15712[(18)]);
var inst_15530 = (state_15712[(19)]);
var inst_15373 = (state_15712[(20)]);
var inst_15488 = (state_15712[(21)]);
var inst_15511 = (state_15712[(22)]);
var inst_15506 = (state_15712[(23)]);
var inst_15369 = (state_15712[(24)]);
var inst_15499 = (state_15712[(25)]);
var inst_15389 = (state_15712[(26)]);
var inst_15493 = (state_15712[(27)]);
var inst_15366 = (state_15712[(28)]);
var inst_15479 = (state_15712[(29)]);
var inst_15461 = (state_15712[(30)]);
var inst_15505 = (state_15712[(31)]);
var inst_15516 = (state_15712[(32)]);
var inst_15529 = (state_15712[(33)]);
var inst_15430 = (state_15712[(34)]);
var inst_15533 = (state_15712[(35)]);
var inst_15510 = (state_15712[(36)]);
var inst_15501 = (state_15712[(37)]);
var inst_15520 = (state_15712[(8)]);
var inst_15367 = (state_15712[(38)]);
var inst_15489 = (state_15712[(39)]);
var inst_15377 = (state_15712[(41)]);
var inst_15452 = (state_15712[(42)]);
var inst_15492 = (state_15712[(43)]);
var inst_15526 = (state_15712[(9)]);
var inst_15374 = (state_15712[(44)]);
var inst_15490 = (state_15712[(45)]);
var inst_15443 = (state_15712[(46)]);
var inst_15434 = (state_15712[(47)]);
var inst_15539 = (state_15712[(48)]);
var inst_15543 = (function (){var no_filter_QMARK_ = inst_15526;
var t = inst_15506;
var max_limit_QMARK_ = inst_15500;
var next_node = inst_15529;
var fast_forward_db_QMARK_ = inst_15511;
var s1 = inst_15389;
var o2 = inst_15452;
var t1 = inst_15366;
var predicate_fn = inst_15379;
var i = inst_15531;
var m1 = inst_15479;
var root_node = inst_15516;
var s2 = inst_15398;
var map__15361 = inst_15492;
var p2 = inst_15470;
var vec__15355 = inst_15430;
var permissions = inst_15501;
var G__15540 = inst_15539;
var limit = inst_15499;
var start_flake = inst_15489;
var flake_limit = inst_15493;
var offset = inst_15530;
var acc = inst_15533;
var t2 = inst_15373;
var map__15354 = inst_15377;
var op1 = inst_15367;
var o1 = inst_15443;
var end_flake = inst_15490;
var base_result = inst_15539;
var s = inst_15532;
var node_start = inst_15520;
var p1 = inst_15461;
var vec__15358 = inst_15431;
var subject_fn = inst_15378;
var vec__15348 = inst_15362;
var object_fn = inst_15434;
var idx_compare = inst_15505;
var vec__15351 = inst_15369;
var op2 = inst_15374;
var m2 = inst_15488;
var novelty = inst_15510;
return (function (p1__15329_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15329_SHARP_.o,start_flake.o);
});
})();
var inst_15544 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15543,inst_15539);
var state_15712__$1 = state_15712;
var statearr_15891_16049 = state_15712__$1;
(statearr_15891_16049[(2)] = inst_15544);

(statearr_15891_16049[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (42))){
var inst_15466 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
if(cljs.core.truth_(inst_15466)){
var statearr_15892_16050 = state_15712__$1;
(statearr_15892_16050[(1)] = (43));

} else {
var statearr_15893_16051 = state_15712__$1;
(statearr_15893_16051[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (80))){
var inst_15379 = (state_15712[(10)]);
var inst_15532 = (state_15712[(11)]);
var inst_15398 = (state_15712[(12)]);
var inst_15470 = (state_15712[(13)]);
var inst_15500 = (state_15712[(14)]);
var inst_15362 = (state_15712[(15)]);
var inst_15531 = (state_15712[(16)]);
var inst_15431 = (state_15712[(17)]);
var inst_15378 = (state_15712[(18)]);
var inst_15530 = (state_15712[(19)]);
var inst_15373 = (state_15712[(20)]);
var inst_15488 = (state_15712[(21)]);
var inst_15511 = (state_15712[(22)]);
var inst_15506 = (state_15712[(23)]);
var inst_15369 = (state_15712[(24)]);
var inst_15499 = (state_15712[(25)]);
var inst_15389 = (state_15712[(26)]);
var inst_15493 = (state_15712[(27)]);
var inst_15366 = (state_15712[(28)]);
var inst_15479 = (state_15712[(29)]);
var inst_15461 = (state_15712[(30)]);
var inst_15505 = (state_15712[(31)]);
var inst_15516 = (state_15712[(32)]);
var inst_15529 = (state_15712[(33)]);
var inst_15430 = (state_15712[(34)]);
var inst_15533 = (state_15712[(35)]);
var inst_15510 = (state_15712[(36)]);
var inst_15501 = (state_15712[(37)]);
var inst_15520 = (state_15712[(8)]);
var inst_15367 = (state_15712[(38)]);
var inst_15489 = (state_15712[(39)]);
var inst_15559 = (state_15712[(86)]);
var inst_15377 = (state_15712[(41)]);
var inst_15452 = (state_15712[(42)]);
var inst_15492 = (state_15712[(43)]);
var inst_15526 = (state_15712[(9)]);
var inst_15374 = (state_15712[(44)]);
var inst_15490 = (state_15712[(45)]);
var inst_15443 = (state_15712[(46)]);
var inst_15434 = (state_15712[(47)]);
var inst_15539 = (state_15712[(48)]);
var inst_15561 = (function (){var no_filter_QMARK_ = inst_15526;
var t = inst_15506;
var max_limit_QMARK_ = inst_15500;
var next_node = inst_15529;
var fast_forward_db_QMARK_ = inst_15511;
var s1 = inst_15389;
var o2 = inst_15452;
var t1 = inst_15366;
var predicate_fn = inst_15379;
var i = inst_15531;
var m1 = inst_15479;
var root_node = inst_15516;
var s2 = inst_15398;
var map__15361 = inst_15492;
var p2 = inst_15470;
var vec__15355 = inst_15430;
var permissions = inst_15501;
var G__15540 = inst_15559;
var limit = inst_15499;
var start_flake = inst_15489;
var flake_limit = inst_15493;
var offset = inst_15530;
var acc = inst_15533;
var t2 = inst_15373;
var map__15354 = inst_15377;
var op1 = inst_15367;
var o1 = inst_15443;
var end_flake = inst_15490;
var base_result = inst_15539;
var s = inst_15532;
var node_start = inst_15520;
var p1 = inst_15461;
var vec__15358 = inst_15431;
var subject_fn = inst_15378;
var vec__15348 = inst_15362;
var object_fn = inst_15434;
var idx_compare = inst_15505;
var vec__15351 = inst_15369;
var op2 = inst_15374;
var m2 = inst_15488;
var novelty = inst_15510;
return (function (p1__15332_SHARP_){
var G__15894 = p1__15332_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15894) : object_fn.call(null,G__15894));
});
})();
var inst_15562 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15561,inst_15559);
var state_15712__$1 = state_15712;
var statearr_15895_16052 = state_15712__$1;
(statearr_15895_16052[(2)] = inst_15562);

(statearr_15895_16052[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (37))){
var state_15712__$1 = state_15712;
var statearr_15896_16053 = state_15712__$1;
(statearr_15896_16053[(2)] = (-1));

(statearr_15896_16053[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (63))){
var inst_15398 = (state_15712[(12)]);
var inst_15470 = (state_15712[(13)]);
var inst_15389 = (state_15712[(26)]);
var inst_15461 = (state_15712[(30)]);
var inst_15501 = (state_15712[(37)]);
var inst_15523 = fluree.db.permissions_validate.no_filter_QMARK_(inst_15501,inst_15389,inst_15398,inst_15461,inst_15470);
var state_15712__$1 = state_15712;
var statearr_15897_16054 = state_15712__$1;
(statearr_15897_16054[(2)] = inst_15523);

(statearr_15897_16054[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (94))){
var inst_15662 = (state_15712[(2)]);
var state_15712__$1 = state_15712;
var statearr_15898_16055 = state_15712__$1;
(statearr_15898_16055[(2)] = inst_15662);

(statearr_15898_16055[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (8))){
var inst_15370 = (state_15712[(84)]);
var inst_15389 = (state_15712[(2)]);
var inst_15390 = fluree.db.util.core.pred_ident_QMARK_(inst_15370);
var state_15712__$1 = (function (){var statearr_15899 = state_15712;
(statearr_15899[(26)] = inst_15389);

return statearr_15899;
})();
if(inst_15390){
var statearr_15900_16056 = state_15712__$1;
(statearr_15900_16056[(1)] = (10));

} else {
var statearr_15901_16057 = state_15712__$1;
(statearr_15901_16057[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (49))){
var state_15712__$1 = state_15712;
var statearr_15902_16058 = state_15712__$1;
(statearr_15902_16058[(2)] = fluree.db.util.core.min_integer);

(statearr_15902_16058[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15713 === (84))){
var inst_15500 = (state_15712[(14)]);
var state_15712__$1 = state_15712;
var statearr_15903_16059 = state_15712__$1;
(statearr_15903_16059[(2)] = inst_15500);

(statearr_15903_16059[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2749__auto__ = null;
var fluree$db$query$range$state_machine__2749__auto____0 = (function (){
var statearr_15904 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15904[(0)] = fluree$db$query$range$state_machine__2749__auto__);

(statearr_15904[(1)] = (1));

return statearr_15904;
});
var fluree$db$query$range$state_machine__2749__auto____1 = (function (state_15712){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_15712);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e15905){var ex__2752__auto__ = e15905;
var statearr_15906_16060 = state_15712;
(statearr_15906_16060[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_15712[(4)]))){
var statearr_15907_16061 = state_15712;
(statearr_15907_16061[(1)] = cljs.core.first((state_15712[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16062 = state_15712;
state_15712 = G__16062;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2749__auto__ = function(state_15712){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2749__auto____1.call(this,state_15712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2749__auto____0;
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2749__auto____1;
return fluree$db$query$range$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_15908 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_15908[(6)] = c__2771__auto__);

return statearr_15908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_16118){
var state_val_16119 = (state_16118[(1)]);
if((state_val_16119 === (7))){
var inst_16092 = (state_16118[(7)]);
var inst_16082 = (state_16118[(8)]);
var inst_16090 = fluree.db.flake.Flake__GT_parts(inst_16082);
var inst_16091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(0),null);
var inst_16092__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(1),null);
var inst_16093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(2),null);
var inst_16094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(3),null);
var inst_16095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(4),null);
var inst_16096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(5),null);
var inst_16097 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_16093,inst_16092__$1);
var state_16118__$1 = (function (){var statearr_16120 = state_16118;
(statearr_16120[(7)] = inst_16092__$1);

(statearr_16120[(9)] = inst_16095);

(statearr_16120[(10)] = inst_16091);

(statearr_16120[(11)] = inst_16094);

(statearr_16120[(12)] = inst_16096);

return statearr_16120;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16118__$1,(10),inst_16097);
} else {
if((state_val_16119 === (1))){
var inst_16070 = flakes;
var inst_16071 = cljs.core.seq(inst_16070);
var inst_16072 = cljs.core.first(inst_16071);
var inst_16073 = cljs.core.next(inst_16071);
var inst_16074 = cljs.core.PersistentVector.EMPTY;
var inst_16075 = inst_16070;
var inst_16076 = inst_16074;
var state_16118__$1 = (function (){var statearr_16121 = state_16118;
(statearr_16121[(13)] = inst_16072);

(statearr_16121[(14)] = inst_16076);

(statearr_16121[(15)] = inst_16075);

(statearr_16121[(16)] = inst_16073);

return statearr_16121;
})();
var statearr_16122_16140 = state_16118__$1;
(statearr_16122_16140[(2)] = null);

(statearr_16122_16140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16119 === (4))){
var inst_16082 = (state_16118[(8)]);
var inst_16085 = fluree.db.query.range.is_tag_flake_QMARK_(inst_16082);
var state_16118__$1 = state_16118;
if(inst_16085){
var statearr_16123_16141 = state_16118__$1;
(statearr_16123_16141[(1)] = (7));

} else {
var statearr_16124_16142 = state_16118__$1;
(statearr_16124_16142[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16119 === (6))){
var inst_16114 = (state_16118[(2)]);
var state_16118__$1 = state_16118;
var statearr_16125_16143 = state_16118__$1;
(statearr_16125_16143[(2)] = inst_16114);

(statearr_16125_16143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16119 === (3))){
var inst_16116 = (state_16118[(2)]);
var state_16118__$1 = state_16118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16118__$1,inst_16116);
} else {
if((state_val_16119 === (2))){
var inst_16082 = (state_16118[(8)]);
var inst_16075 = (state_16118[(15)]);
var inst_16081 = cljs.core.seq(inst_16075);
var inst_16082__$1 = cljs.core.first(inst_16081);
var inst_16083 = cljs.core.next(inst_16081);
var state_16118__$1 = (function (){var statearr_16126 = state_16118;
(statearr_16126[(17)] = inst_16083);

(statearr_16126[(8)] = inst_16082__$1);

return statearr_16126;
})();
if(cljs.core.truth_(inst_16082__$1)){
var statearr_16127_16144 = state_16118__$1;
(statearr_16127_16144[(1)] = (4));

} else {
var statearr_16128_16145 = state_16118__$1;
(statearr_16128_16145[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16119 === (9))){
var inst_16111 = (state_16118[(2)]);
var state_16118__$1 = state_16118;
var statearr_16129_16146 = state_16118__$1;
(statearr_16129_16146[(2)] = inst_16111);

(statearr_16129_16146[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16119 === (5))){
var inst_16076 = (state_16118[(14)]);
var state_16118__$1 = state_16118;
var statearr_16130_16147 = state_16118__$1;
(statearr_16130_16147[(2)] = inst_16076);

(statearr_16130_16147[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16119 === (10))){
var inst_16092 = (state_16118[(7)]);
var inst_16076 = (state_16118[(14)]);
var inst_16083 = (state_16118[(17)]);
var inst_16095 = (state_16118[(9)]);
var inst_16091 = (state_16118[(10)]);
var inst_16094 = (state_16118[(11)]);
var inst_16096 = (state_16118[(12)]);
var inst_16099 = (state_16118[(2)]);
var inst_16100 = fluree.db.util.async.throw_err(inst_16099);
var inst_16101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16102 = [inst_16091,inst_16092,inst_16100,inst_16094,inst_16095,inst_16096];
var inst_16103 = (new cljs.core.PersistentVector(null,6,(5),inst_16101,inst_16102,null));
var inst_16104 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_16103);
var inst_16105 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_16076,inst_16104);
var inst_16075 = inst_16083;
var inst_16076__$1 = inst_16105;
var state_16118__$1 = (function (){var statearr_16131 = state_16118;
(statearr_16131[(14)] = inst_16076__$1);

(statearr_16131[(15)] = inst_16075);

return statearr_16131;
})();
var statearr_16132_16148 = state_16118__$1;
(statearr_16132_16148[(2)] = null);

(statearr_16132_16148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16119 === (8))){
var inst_16076 = (state_16118[(14)]);
var inst_16083 = (state_16118[(17)]);
var inst_16082 = (state_16118[(8)]);
var inst_16108 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_16076,inst_16082);
var inst_16075 = inst_16083;
var inst_16076__$1 = inst_16108;
var state_16118__$1 = (function (){var statearr_16133 = state_16118;
(statearr_16133[(14)] = inst_16076__$1);

(statearr_16133[(15)] = inst_16075);

return statearr_16133;
})();
var statearr_16134_16149 = state_16118__$1;
(statearr_16134_16149[(2)] = null);

(statearr_16134_16149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto____0 = (function (){
var statearr_16135 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16135[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto__);

(statearr_16135[(1)] = (1));

return statearr_16135;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto____1 = (function (state_16118){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_16118);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e16136){var ex__2752__auto__ = e16136;
var statearr_16137_16150 = state_16118;
(statearr_16137_16150[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_16118[(4)]))){
var statearr_16138_16151 = state_16118;
(statearr_16138_16151[(1)] = cljs.core.first((state_16118[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16152 = state_16118;
state_16118 = G__16152;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto__ = function(state_16118){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto____1.call(this,state_16118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_16139 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_16139[(6)] = c__2771__auto__);

return statearr_16139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__16154 = arguments.length;
switch (G__16154) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_16324){
var state_val_16325 = (state_16324[(1)]);
if((state_val_16325 === (65))){
var state_16324__$1 = state_16324;
var statearr_16326_16426 = state_16324__$1;
(statearr_16326_16426[(2)] = null);

(statearr_16326_16426[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (70))){
var inst_16319 = (state_16324[(2)]);
var _ = (function (){var statearr_16327 = state_16324;
(statearr_16327[(4)] = cljs.core.rest((state_16324[(4)])));

return statearr_16327;
})();
var state_16324__$1 = state_16324;
var statearr_16328_16427 = state_16324__$1;
(statearr_16328_16427[(2)] = inst_16319);

(statearr_16328_16427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (62))){
var inst_16305 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16329_16428 = state_16324__$1;
(statearr_16329_16428[(2)] = inst_16305);

(statearr_16329_16428[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (7))){
var state_16324__$1 = state_16324;
var statearr_16330_16429 = state_16324__$1;
(statearr_16330_16429[(2)] = false);

(statearr_16330_16429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (59))){
var inst_16279 = (state_16324[(2)]);
var inst_16280 = fluree.db.util.async.throw_err(inst_16279);
var state_16324__$1 = state_16324;
var statearr_16331_16430 = state_16324__$1;
(statearr_16331_16430[(2)] = inst_16280);

(statearr_16331_16430[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (20))){
var state_16324__$1 = state_16324;
var statearr_16332_16431 = state_16324__$1;
(statearr_16332_16431[(2)] = null);

(statearr_16332_16431[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (58))){
var inst_16269 = (state_16324[(2)]);
var inst_16270 = fluree.db.util.async.throw_err(inst_16269);
var inst_16271 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_16270);
var state_16324__$1 = state_16324;
var statearr_16333_16432 = state_16324__$1;
(statearr_16333_16432[(2)] = inst_16271);

(statearr_16333_16432[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (60))){
var inst_16168 = (state_16324[(7)]);
var inst_16166 = (state_16324[(8)]);
var inst_16205 = (state_16324[(9)]);
var inst_16165 = (state_16324[(10)]);
var inst_16285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16286 = [inst_16166,inst_16165,inst_16205,inst_16168];
var inst_16287 = (new cljs.core.PersistentVector(null,4,(5),inst_16285,inst_16286,null));
var inst_16288 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16287,opts);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(63),inst_16288);
} else {
if((state_val_16325 === (27))){
var inst_16216 = (state_16324[(11)]);
var inst_16205 = (state_16324[(9)]);
var inst_16216__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_16205);
var state_16324__$1 = (function (){var statearr_16334 = state_16324;
(statearr_16334[(11)] = inst_16216__$1);

return statearr_16334;
})();
if(inst_16216__$1){
var statearr_16335_16433 = state_16324__$1;
(statearr_16335_16433[(1)] = (30));

} else {
var statearr_16336_16434 = state_16324__$1;
(statearr_16336_16434[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (1))){
var state_16324__$1 = state_16324;
var statearr_16337_16435 = state_16324__$1;
(statearr_16337_16435[(2)] = null);

(statearr_16337_16435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (69))){
var inst_16311 = (state_16324[(12)]);
var state_16324__$1 = state_16324;
var statearr_16338_16436 = state_16324__$1;
(statearr_16338_16436[(2)] = inst_16311);

(statearr_16338_16436[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (24))){
var inst_16166 = (state_16324[(8)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16166)){
var statearr_16339_16437 = state_16324__$1;
(statearr_16339_16437[(1)] = (27));

} else {
var statearr_16340_16438 = state_16324__$1;
(statearr_16340_16438[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (55))){
var inst_16205 = (state_16324[(9)]);
var inst_16263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16264 = [inst_16205];
var inst_16265 = (new cljs.core.PersistentVector(null,1,(5),inst_16263,inst_16264,null));
var inst_16266 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_16267 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16265,inst_16266);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(58),inst_16267);
} else {
if((state_val_16325 === (39))){
var inst_16236 = (state_16324[(2)]);
var inst_16237 = fluree.db.util.async.throw_err(inst_16236);
var state_16324__$1 = state_16324;
var statearr_16341_16439 = state_16324__$1;
(statearr_16341_16439[(2)] = inst_16237);

(statearr_16341_16439[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (46))){
var inst_16249 = (state_16324[(13)]);
var inst_16249__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_16324__$1 = (function (){var statearr_16342 = state_16324;
(statearr_16342[(13)] = inst_16249__$1);

return statearr_16342;
})();
if(cljs.core.truth_(inst_16249__$1)){
var statearr_16343_16440 = state_16324__$1;
(statearr_16343_16440[(1)] = (49));

} else {
var statearr_16344_16441 = state_16324__$1;
(statearr_16344_16441[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (4))){
var inst_16155 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16345_16442 = state_16324__$1;
(statearr_16345_16442[(2)] = inst_16155);

(statearr_16345_16442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (54))){
var inst_16261 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16261)){
var statearr_16346_16443 = state_16324__$1;
(statearr_16346_16443[(1)] = (55));

} else {
var statearr_16347_16444 = state_16324__$1;
(statearr_16347_16444[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (15))){
var inst_16167 = (state_16324[(14)]);
var inst_16186 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_16167);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(18),inst_16186);
} else {
if((state_val_16325 === (48))){
var inst_16307 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16348_16445 = state_16324__$1;
(statearr_16348_16445[(2)] = inst_16307);

(statearr_16348_16445[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (50))){
var inst_16168 = (state_16324[(7)]);
var inst_16164 = (state_16324[(15)]);
var inst_16166 = (state_16324[(8)]);
var inst_16205 = (state_16324[(9)]);
var inst_16180 = (state_16324[(16)]);
var inst_16169 = (state_16324[(17)]);
var inst_16175 = (state_16324[(18)]);
var inst_16249 = (state_16324[(13)]);
var inst_16165 = (state_16324[(10)]);
var inst_16253 = (function (){var t = inst_16168;
var temp__5802__auto__ = inst_16249;
var p = inst_16166;
var idx_predicate_QMARK_ = inst_16169;
var o = inst_16205;
var tag_predicate_QMARK_ = inst_16175;
var s = inst_16165;
var o_coerce_QMARK_ = inst_16180;
var vec__16161 = inst_16164;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_16324__$1 = state_16324;
var statearr_16349_16446 = state_16324__$1;
(statearr_16349_16446[(2)] = inst_16253);

(statearr_16349_16446[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (21))){
var inst_16201 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16350_16447 = state_16324__$1;
(statearr_16350_16447[(2)] = inst_16201);

(statearr_16350_16447[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (31))){
var inst_16216 = (state_16324[(11)]);
var state_16324__$1 = state_16324;
var statearr_16351_16448 = state_16324__$1;
(statearr_16351_16448[(2)] = inst_16216);

(statearr_16351_16448[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (32))){
var inst_16226 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16352_16449 = state_16324__$1;
(statearr_16352_16449[(2)] = inst_16226);

(statearr_16352_16449[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (40))){
var inst_16240 = (state_16324[(19)]);
var inst_16169 = (state_16324[(17)]);
var inst_16240__$1 = cljs.core.not(inst_16169);
var state_16324__$1 = (function (){var statearr_16353 = state_16324;
(statearr_16353[(19)] = inst_16240__$1);

return statearr_16353;
})();
if(inst_16240__$1){
var statearr_16354_16450 = state_16324__$1;
(statearr_16354_16450[(1)] = (43));

} else {
var statearr_16355_16451 = state_16324__$1;
(statearr_16355_16451[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (56))){
var inst_16168 = (state_16324[(7)]);
var inst_16166 = (state_16324[(8)]);
var inst_16255 = (state_16324[(20)]);
var inst_16165 = (state_16324[(10)]);
var inst_16273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16274 = [inst_16166,inst_16165,null,inst_16168];
var inst_16275 = (new cljs.core.PersistentVector(null,4,(5),inst_16273,inst_16274,null));
var inst_16276 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_16255);
var inst_16277 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16275,inst_16276);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(59),inst_16277);
} else {
if((state_val_16325 === (33))){
var inst_16205 = (state_16324[(9)]);
var inst_16219 = cljs.core.fn_QMARK_(inst_16205);
var inst_16220 = (!(inst_16219));
var state_16324__$1 = state_16324;
var statearr_16356_16452 = state_16324__$1;
(statearr_16356_16452[(2)] = inst_16220);

(statearr_16356_16452[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (13))){
var inst_16167 = (state_16324[(14)]);
var inst_16184 = fluree.db.query.range.tag_string_QMARK_(inst_16167);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16184)){
var statearr_16357_16453 = state_16324__$1;
(statearr_16357_16453[(1)] = (15));

} else {
var statearr_16358_16454 = state_16324__$1;
(statearr_16358_16454[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (22))){
var inst_16197 = (state_16324[(2)]);
var inst_16198 = fluree.db.util.async.throw_err(inst_16197);
var state_16324__$1 = state_16324;
var statearr_16359_16455 = state_16324__$1;
(statearr_16359_16455[(2)] = inst_16198);

(statearr_16359_16455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (36))){
var inst_16168 = (state_16324[(7)]);
var inst_16166 = (state_16324[(8)]);
var inst_16205 = (state_16324[(9)]);
var inst_16165 = (state_16324[(10)]);
var inst_16231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16232 = [inst_16166,inst_16205,inst_16165,inst_16168];
var inst_16233 = (new cljs.core.PersistentVector(null,4,(5),inst_16231,inst_16232,null));
var inst_16234 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_16233,opts);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(39),inst_16234);
} else {
if((state_val_16325 === (41))){
var inst_16166 = (state_16324[(8)]);
var state_16324__$1 = state_16324;
var statearr_16360_16456 = state_16324__$1;
(statearr_16360_16456[(2)] = inst_16166);

(statearr_16360_16456[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (43))){
var inst_16205 = (state_16324[(9)]);
var state_16324__$1 = state_16324;
var statearr_16361_16457 = state_16324__$1;
(statearr_16361_16457[(2)] = inst_16205);

(statearr_16361_16457[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (61))){
var inst_16205 = (state_16324[(9)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16205)){
var statearr_16362_16458 = state_16324__$1;
(statearr_16362_16458[(1)] = (64));

} else {
var statearr_16363_16459 = state_16324__$1;
(statearr_16363_16459[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (29))){
var inst_16229 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16229)){
var statearr_16364_16460 = state_16324__$1;
(statearr_16364_16460[(1)] = (36));

} else {
var statearr_16365_16461 = state_16324__$1;
(statearr_16365_16461[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (44))){
var inst_16240 = (state_16324[(19)]);
var state_16324__$1 = state_16324;
var statearr_16366_16462 = state_16324__$1;
(statearr_16366_16462[(2)] = inst_16240);

(statearr_16366_16462[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (6))){
var inst_16166 = (state_16324[(8)]);
var inst_16171 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_16166);
var inst_16172 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_16171);
var state_16324__$1 = state_16324;
var statearr_16367_16463 = state_16324__$1;
(statearr_16367_16463[(2)] = inst_16172);

(statearr_16367_16463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (28))){
var inst_16166 = (state_16324[(8)]);
var state_16324__$1 = state_16324;
var statearr_16368_16464 = state_16324__$1;
(statearr_16368_16464[(2)] = inst_16166);

(statearr_16368_16464[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (64))){
var inst_16168 = (state_16324[(7)]);
var inst_16166 = (state_16324[(8)]);
var inst_16205 = (state_16324[(9)]);
var inst_16165 = (state_16324[(10)]);
var inst_16294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16295 = [inst_16205,inst_16166,inst_16165,inst_16168];
var inst_16296 = (new cljs.core.PersistentVector(null,4,(5),inst_16294,inst_16295,null));
var inst_16297 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_16296,opts);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(67),inst_16297);
} else {
if((state_val_16325 === (51))){
var inst_16166 = (state_16324[(8)]);
var inst_16256 = (state_16324[(21)]);
var inst_16255 = (state_16324[(2)]);
var inst_16256__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_16166);
var state_16324__$1 = (function (){var statearr_16369 = state_16324;
(statearr_16369[(20)] = inst_16255);

(statearr_16369[(21)] = inst_16256__$1);

return statearr_16369;
})();
if(inst_16256__$1){
var statearr_16370_16465 = state_16324__$1;
(statearr_16370_16465[(1)] = (52));

} else {
var statearr_16371_16466 = state_16324__$1;
(statearr_16371_16466[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (25))){
var inst_16175 = (state_16324[(18)]);
var inst_16311 = (state_16324[(2)]);
var state_16324__$1 = (function (){var statearr_16372 = state_16324;
(statearr_16372[(12)] = inst_16311);

return statearr_16372;
})();
if(cljs.core.truth_(inst_16175)){
var statearr_16373_16467 = state_16324__$1;
(statearr_16373_16467[(1)] = (68));

} else {
var statearr_16374_16468 = state_16324__$1;
(statearr_16374_16468[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (34))){
var inst_16169 = (state_16324[(17)]);
var state_16324__$1 = state_16324;
var statearr_16375_16469 = state_16324__$1;
(statearr_16375_16469[(2)] = inst_16169);

(statearr_16375_16469[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (17))){
var inst_16203 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16376_16470 = state_16324__$1;
(statearr_16376_16470[(2)] = inst_16203);

(statearr_16376_16470[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (3))){
var inst_16322 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16324__$1,inst_16322);
} else {
if((state_val_16325 === (12))){
var inst_16167 = (state_16324[(14)]);
var state_16324__$1 = state_16324;
var statearr_16377_16471 = state_16324__$1;
(statearr_16377_16471[(2)] = inst_16167);

(statearr_16377_16471[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (2))){
var inst_16164 = (state_16324[(15)]);
var inst_16166 = (state_16324[(8)]);
var _ = (function (){var statearr_16378 = state_16324;
(statearr_16378[(4)] = cljs.core.cons((5),(state_16324[(4)])));

return statearr_16378;
})();
var inst_16164__$1 = fparts;
var inst_16165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16164__$1,(0),null);
var inst_16166__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16164__$1,(1),null);
var inst_16167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16164__$1,(2),null);
var inst_16168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16164__$1,(3),null);
var inst_16169 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_16166__$1);
var state_16324__$1 = (function (){var statearr_16379 = state_16324;
(statearr_16379[(7)] = inst_16168);

(statearr_16379[(15)] = inst_16164__$1);

(statearr_16379[(8)] = inst_16166__$1);

(statearr_16379[(17)] = inst_16169);

(statearr_16379[(10)] = inst_16165);

(statearr_16379[(14)] = inst_16167);

return statearr_16379;
})();
if(cljs.core.truth_(inst_16166__$1)){
var statearr_16380_16472 = state_16324__$1;
(statearr_16380_16472[(1)] = (6));

} else {
var statearr_16381_16473 = state_16324__$1;
(statearr_16381_16473[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (66))){
var inst_16303 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16382_16474 = state_16324__$1;
(statearr_16382_16474[(2)] = inst_16303);

(statearr_16382_16474[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (23))){
var inst_16168 = (state_16324[(7)]);
var inst_16166 = (state_16324[(8)]);
var inst_16205 = (state_16324[(9)]);
var inst_16165 = (state_16324[(10)]);
var inst_16207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16208 = [inst_16165,inst_16166,inst_16205,inst_16168];
var inst_16209 = (new cljs.core.PersistentVector(null,4,(5),inst_16207,inst_16208,null));
var inst_16210 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16209,opts);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(26),inst_16210);
} else {
if((state_val_16325 === (47))){
var inst_16166 = (state_16324[(8)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16166)){
var statearr_16383_16475 = state_16324__$1;
(statearr_16383_16475[(1)] = (60));

} else {
var statearr_16384_16476 = state_16324__$1;
(statearr_16384_16476[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (35))){
var inst_16223 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16385_16477 = state_16324__$1;
(statearr_16385_16477[(2)] = inst_16223);

(statearr_16385_16477[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (19))){
var inst_16166 = (state_16324[(8)]);
var inst_16167 = (state_16324[(14)]);
var inst_16193 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16166);
var inst_16194 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16193),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16167)].join('');
var inst_16195 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_16194);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(22),inst_16195);
} else {
if((state_val_16325 === (57))){
var inst_16282 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16386_16478 = state_16324__$1;
(statearr_16386_16478[(2)] = inst_16282);

(statearr_16386_16478[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (68))){
var inst_16311 = (state_16324[(12)]);
var inst_16313 = fluree.db.query.range.coerce_tag_flakes(db,inst_16311);
var state_16324__$1 = state_16324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16324__$1,(71),inst_16313);
} else {
if((state_val_16325 === (11))){
var inst_16180 = (state_16324[(16)]);
var inst_16180__$1 = (state_16324[(2)]);
var inst_16181 = cljs.core.not(inst_16180__$1);
var state_16324__$1 = (function (){var statearr_16388 = state_16324;
(statearr_16388[(16)] = inst_16180__$1);

return statearr_16388;
})();
if(inst_16181){
var statearr_16389_16479 = state_16324__$1;
(statearr_16389_16479[(1)] = (12));

} else {
var statearr_16390_16480 = state_16324__$1;
(statearr_16390_16480[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (9))){
var inst_16167 = (state_16324[(14)]);
var inst_16177 = typeof inst_16167 === 'string';
var state_16324__$1 = state_16324;
var statearr_16391_16481 = state_16324__$1;
(statearr_16391_16481[(2)] = inst_16177);

(statearr_16391_16481[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (5))){
var _ = (function (){var statearr_16392 = state_16324;
(statearr_16392[(4)] = cljs.core.rest((state_16324[(4)])));

return statearr_16392;
})();
var state_16324__$1 = state_16324;
var ex16387 = (state_16324__$1[(2)]);
var statearr_16393_16482 = state_16324__$1;
(statearr_16393_16482[(5)] = ex16387);


if((ex16387 instanceof Error)){
var statearr_16394_16483 = state_16324__$1;
(statearr_16394_16483[(1)] = (4));

(statearr_16394_16483[(5)] = null);

} else {
throw ex16387;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (14))){
var inst_16165 = (state_16324[(10)]);
var inst_16205 = (state_16324[(2)]);
var state_16324__$1 = (function (){var statearr_16395 = state_16324;
(statearr_16395[(9)] = inst_16205);

return statearr_16395;
})();
if(cljs.core.truth_(inst_16165)){
var statearr_16396_16484 = state_16324__$1;
(statearr_16396_16484[(1)] = (23));

} else {
var statearr_16397_16485 = state_16324__$1;
(statearr_16397_16485[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (45))){
var inst_16244 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16398_16486 = state_16324__$1;
(statearr_16398_16486[(2)] = inst_16244);

(statearr_16398_16486[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (53))){
var inst_16256 = (state_16324[(21)]);
var state_16324__$1 = state_16324;
var statearr_16399_16487 = state_16324__$1;
(statearr_16399_16487[(2)] = inst_16256);

(statearr_16399_16487[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (26))){
var inst_16212 = (state_16324[(2)]);
var inst_16213 = fluree.db.util.async.throw_err(inst_16212);
var state_16324__$1 = state_16324;
var statearr_16400_16488 = state_16324__$1;
(statearr_16400_16488[(2)] = inst_16213);

(statearr_16400_16488[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (16))){
var inst_16167 = (state_16324[(14)]);
var inst_16191 = typeof inst_16167 === 'string';
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16191)){
var statearr_16401_16489 = state_16324__$1;
(statearr_16401_16489[(1)] = (19));

} else {
var statearr_16402_16490 = state_16324__$1;
(statearr_16402_16490[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (38))){
var inst_16309 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
var statearr_16403_16491 = state_16324__$1;
(statearr_16403_16491[(2)] = inst_16309);

(statearr_16403_16491[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (30))){
var inst_16169 = (state_16324[(17)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16169)){
var statearr_16404_16492 = state_16324__$1;
(statearr_16404_16492[(1)] = (33));

} else {
var statearr_16405_16493 = state_16324__$1;
(statearr_16405_16493[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (10))){
var inst_16175 = (state_16324[(18)]);
var state_16324__$1 = state_16324;
var statearr_16406_16494 = state_16324__$1;
(statearr_16406_16494[(2)] = inst_16175);

(statearr_16406_16494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (18))){
var inst_16188 = (state_16324[(2)]);
var inst_16189 = fluree.db.util.async.throw_err(inst_16188);
var state_16324__$1 = state_16324;
var statearr_16407_16495 = state_16324__$1;
(statearr_16407_16495[(2)] = inst_16189);

(statearr_16407_16495[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (52))){
var inst_16205 = (state_16324[(9)]);
var inst_16258 = cljs.core.int_QMARK_(inst_16205);
var state_16324__$1 = state_16324;
var statearr_16408_16496 = state_16324__$1;
(statearr_16408_16496[(2)] = inst_16258);

(statearr_16408_16496[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (67))){
var inst_16299 = (state_16324[(2)]);
var inst_16300 = fluree.db.util.async.throw_err(inst_16299);
var state_16324__$1 = state_16324;
var statearr_16409_16497 = state_16324__$1;
(statearr_16409_16497[(2)] = inst_16300);

(statearr_16409_16497[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (71))){
var inst_16315 = (state_16324[(2)]);
var inst_16316 = fluree.db.util.async.throw_err(inst_16315);
var state_16324__$1 = state_16324;
var statearr_16410_16498 = state_16324__$1;
(statearr_16410_16498[(2)] = inst_16316);

(statearr_16410_16498[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (42))){
var inst_16247 = (state_16324[(2)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16247)){
var statearr_16411_16499 = state_16324__$1;
(statearr_16411_16499[(1)] = (46));

} else {
var statearr_16412_16500 = state_16324__$1;
(statearr_16412_16500[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (37))){
var inst_16166 = (state_16324[(8)]);
var state_16324__$1 = state_16324;
if(cljs.core.truth_(inst_16166)){
var statearr_16413_16501 = state_16324__$1;
(statearr_16413_16501[(1)] = (40));

} else {
var statearr_16414_16502 = state_16324__$1;
(statearr_16414_16502[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (63))){
var inst_16290 = (state_16324[(2)]);
var inst_16291 = fluree.db.util.async.throw_err(inst_16290);
var state_16324__$1 = state_16324;
var statearr_16415_16503 = state_16324__$1;
(statearr_16415_16503[(2)] = inst_16291);

(statearr_16415_16503[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (8))){
var inst_16175 = (state_16324[(18)]);
var inst_16175__$1 = (state_16324[(2)]);
var state_16324__$1 = (function (){var statearr_16416 = state_16324;
(statearr_16416[(18)] = inst_16175__$1);

return statearr_16416;
})();
if(cljs.core.truth_(inst_16175__$1)){
var statearr_16417_16504 = state_16324__$1;
(statearr_16417_16504[(1)] = (9));

} else {
var statearr_16418_16505 = state_16324__$1;
(statearr_16418_16505[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16325 === (49))){
var inst_16168 = (state_16324[(7)]);
var inst_16164 = (state_16324[(15)]);
var inst_16166 = (state_16324[(8)]);
var inst_16205 = (state_16324[(9)]);
var inst_16180 = (state_16324[(16)]);
var inst_16169 = (state_16324[(17)]);
var inst_16175 = (state_16324[(18)]);
var inst_16249 = (state_16324[(13)]);
var inst_16165 = (state_16324[(10)]);
var inst_16251 = (function (){var obj_fn = inst_16249;
var t = inst_16168;
var temp__5802__auto__ = inst_16249;
var p = inst_16166;
var idx_predicate_QMARK_ = inst_16169;
var o = inst_16205;
var tag_predicate_QMARK_ = inst_16175;
var s = inst_16165;
var o_coerce_QMARK_ = inst_16180;
var vec__16161 = inst_16164;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_16324__$1 = state_16324;
var statearr_16419_16506 = state_16324__$1;
(statearr_16419_16506[(2)] = inst_16251);

(statearr_16419_16506[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2749__auto__ = null;
var fluree$db$query$range$state_machine__2749__auto____0 = (function (){
var statearr_16420 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16420[(0)] = fluree$db$query$range$state_machine__2749__auto__);

(statearr_16420[(1)] = (1));

return statearr_16420;
});
var fluree$db$query$range$state_machine__2749__auto____1 = (function (state_16324){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_16324);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e16421){var ex__2752__auto__ = e16421;
var statearr_16422_16507 = state_16324;
(statearr_16422_16507[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_16324[(4)]))){
var statearr_16423_16508 = state_16324;
(statearr_16423_16508[(1)] = cljs.core.first((state_16324[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16509 = state_16324;
state_16324 = G__16509;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2749__auto__ = function(state_16324){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2749__auto____1.call(this,state_16324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2749__auto____0;
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2749__auto____1;
return fluree$db$query$range$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_16424 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_16424[(6)] = c__2771__auto__);

return statearr_16424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__16511 = arguments.length;
switch (G__16511) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_16546){
var state_val_16547 = (state_16546[(1)]);
if((state_val_16547 === (7))){
var inst_16533 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_16534 = ["Invalid collection name: ",inst_16533].join('');
var inst_16535 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16536 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_16537 = cljs.core.PersistentHashMap.fromArrays(inst_16535,inst_16536);
var inst_16538 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16534,inst_16537);
var inst_16539 = (function(){throw inst_16538})();
var state_16546__$1 = state_16546;
var statearr_16548_16568 = state_16546__$1;
(statearr_16548_16568[(2)] = inst_16539);

(statearr_16548_16568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (1))){
var state_16546__$1 = state_16546;
var statearr_16549_16569 = state_16546__$1;
(statearr_16549_16569[(2)] = null);

(statearr_16549_16569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (4))){
var inst_16512 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
var statearr_16550_16570 = state_16546__$1;
(statearr_16550_16570[(2)] = inst_16512);

(statearr_16550_16570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (6))){
var inst_16518 = (state_16546[(7)]);
var inst_16520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16521 = fluree.db.flake.max_subject_id(inst_16518);
var inst_16522 = [inst_16521];
var inst_16523 = (new cljs.core.PersistentVector(null,1,(5),inst_16520,inst_16522,null));
var inst_16524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16525 = fluree.db.flake.min_subject_id(inst_16518);
var inst_16526 = [inst_16525];
var inst_16527 = (new cljs.core.PersistentVector(null,1,(5),inst_16524,inst_16526,null));
var inst_16528 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16523,cljs.core._LT__EQ_,inst_16527,opts);
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16546__$1,(9),inst_16528);
} else {
if((state_val_16547 === (3))){
var inst_16544 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16546__$1,inst_16544);
} else {
if((state_val_16547 === (2))){
var inst_16518 = (state_16546[(7)]);
var _ = (function (){var statearr_16552 = state_16546;
(statearr_16552[(4)] = cljs.core.cons((5),(state_16546[(4)])));

return statearr_16552;
})();
var inst_16518__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_16546__$1 = (function (){var statearr_16553 = state_16546;
(statearr_16553[(7)] = inst_16518__$1);

return statearr_16553;
})();
if(cljs.core.truth_(inst_16518__$1)){
var statearr_16554_16571 = state_16546__$1;
(statearr_16554_16571[(1)] = (6));

} else {
var statearr_16555_16572 = state_16546__$1;
(statearr_16555_16572[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (9))){
var inst_16530 = (state_16546[(2)]);
var inst_16531 = fluree.db.util.async.throw_err(inst_16530);
var state_16546__$1 = state_16546;
var statearr_16556_16573 = state_16546__$1;
(statearr_16556_16573[(2)] = inst_16531);

(statearr_16556_16573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (5))){
var _ = (function (){var statearr_16557 = state_16546;
(statearr_16557[(4)] = cljs.core.rest((state_16546[(4)])));

return statearr_16557;
})();
var state_16546__$1 = state_16546;
var ex16551 = (state_16546__$1[(2)]);
var statearr_16558_16574 = state_16546__$1;
(statearr_16558_16574[(5)] = ex16551);


var statearr_16559_16575 = state_16546__$1;
(statearr_16559_16575[(1)] = (4));

(statearr_16559_16575[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (8))){
var inst_16541 = (state_16546[(2)]);
var _ = (function (){var statearr_16560 = state_16546;
(statearr_16560[(4)] = cljs.core.rest((state_16546[(4)])));

return statearr_16560;
})();
var state_16546__$1 = state_16546;
var statearr_16561_16576 = state_16546__$1;
(statearr_16561_16576[(2)] = inst_16541);

(statearr_16561_16576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2749__auto__ = null;
var fluree$db$query$range$state_machine__2749__auto____0 = (function (){
var statearr_16562 = [null,null,null,null,null,null,null,null];
(statearr_16562[(0)] = fluree$db$query$range$state_machine__2749__auto__);

(statearr_16562[(1)] = (1));

return statearr_16562;
});
var fluree$db$query$range$state_machine__2749__auto____1 = (function (state_16546){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_16546);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e16563){var ex__2752__auto__ = e16563;
var statearr_16564_16577 = state_16546;
(statearr_16564_16577[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_16546[(4)]))){
var statearr_16565_16578 = state_16546;
(statearr_16565_16578[(1)] = cljs.core.first((state_16546[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16579 = state_16546;
state_16546 = G__16579;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2749__auto__ = function(state_16546){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2749__auto____1.call(this,state_16546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2749__auto____0;
fluree$db$query$range$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2749__auto____1;
return fluree$db$query$range$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_16566 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_16566[(6)] = c__2771__auto__);

return statearr_16566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__16583 = flakes;
var vec__16584 = G__16583;
var seq__16585 = cljs.core.seq(vec__16584);
var first__16586 = cljs.core.first(seq__16585);
var seq__16585__$1 = cljs.core.next(seq__16585);
var flake_SINGLEQUOTE_ = first__16586;
var r = seq__16585__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16583__$1 = G__16583;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16592 = G__16583__$1;
var seq__16593 = cljs.core.seq(vec__16592);
var first__16594 = cljs.core.first(seq__16593);
var seq__16593__$1 = cljs.core.next(seq__16593);
var flake_SINGLEQUOTE___$1 = first__16594;
var r__$1 = seq__16593__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e16596){var e = e16596;
return null;
}})();
var map__16595 = cmd_map;
var map__16595__$1 = cljs.core.__destructure_map(map__16595);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16595__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16595__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16595__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16595__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16595__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16595__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16597 = r__$1;
var G__16598 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__16583__$1 = G__16597;
result_STAR___$1 = G__16598;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16607 = blocks;
var vec__16608 = G__16607;
var seq__16609 = cljs.core.seq(vec__16608);
var first__16610 = cljs.core.first(seq__16609);
var seq__16609__$1 = cljs.core.next(seq__16609);
var block_SINGLEQUOTE_ = first__16610;
var r = seq__16609__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16607__$1 = G__16607;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16615 = G__16607__$1;
var seq__16616 = cljs.core.seq(vec__16615);
var first__16617 = cljs.core.first(seq__16616);
var seq__16616__$1 = cljs.core.next(seq__16616);
var block_SINGLEQUOTE___$1 = first__16617;
var r__$1 = seq__16616__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16618 = block_SINGLEQUOTE___$1;
var map__16618__$1 = cljs.core.__destructure_map(map__16618);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16618__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16618__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16618__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16599_SHARP_){
var f = p1__16599_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16600_SHARP_){
var f = p1__16600_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,hash,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16601_SHARP_){
var f = p1__16601_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,hash,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,hash,instant,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16602_SHARP_){
var f = p1__16602_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,hash,instant,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16603_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__16603_SHARP_.p,(106));
});})(G__16607__$1,result_STAR___$1,map__16618,map__16618__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16615,seq__16616,first__16617,seq__16616__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16607,vec__16608,seq__16609,first__16610,seq__16609__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__16619 = r__$1;
var G__16620 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16607__$1 = G__16619;
result_STAR___$1 = G__16620;
continue;
}
break;
}
});
