// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_16638){
var state_val_16639 = (state_16638[(1)]);
if((state_val_16639 === (1))){
var state_16638__$1 = state_16638;
var statearr_16640_16654 = state_16638__$1;
(statearr_16640_16654[(2)] = null);

(statearr_16640_16654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16639 === (2))){
var _ = (function (){var statearr_16641 = state_16638;
(statearr_16641[(4)] = cljs.core.cons((5),(state_16638[(4)])));

return statearr_16641;
})();
var inst_16629 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_16638__$1 = state_16638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16638__$1,(6),inst_16629);
} else {
if((state_val_16639 === (3))){
var inst_16636 = (state_16638[(2)]);
var state_16638__$1 = state_16638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16638__$1,inst_16636);
} else {
if((state_val_16639 === (4))){
var inst_16623 = (state_16638[(2)]);
var state_16638__$1 = state_16638;
var statearr_16643_16655 = state_16638__$1;
(statearr_16643_16655[(2)] = inst_16623);

(statearr_16643_16655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16639 === (5))){
var _ = (function (){var statearr_16644 = state_16638;
(statearr_16644[(4)] = cljs.core.rest((state_16638[(4)])));

return statearr_16644;
})();
var state_16638__$1 = state_16638;
var ex16642 = (state_16638__$1[(2)]);
var statearr_16645_16656 = state_16638__$1;
(statearr_16645_16656[(5)] = ex16642);


if((ex16642 instanceof Error)){
var statearr_16646_16657 = state_16638__$1;
(statearr_16646_16657[(1)] = (4));

(statearr_16646_16657[(5)] = null);

} else {
throw ex16642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16639 === (6))){
var inst_16631 = (state_16638[(2)]);
var inst_16632 = fluree.db.util.async.throw_err(inst_16631);
var inst_16633 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16632);
var _ = (function (){var statearr_16647 = state_16638;
(statearr_16647[(4)] = cljs.core.rest((state_16638[(4)])));

return statearr_16647;
})();
var state_16638__$1 = state_16638;
var statearr_16648_16658 = state_16638__$1;
(statearr_16648_16658[(2)] = inst_16633);

(statearr_16648_16658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto____0 = (function (){
var statearr_16649 = [null,null,null,null,null,null,null];
(statearr_16649[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto__);

(statearr_16649[(1)] = (1));

return statearr_16649;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto____1 = (function (state_16638){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_16638);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e16650){var ex__2752__auto__ = e16650;
var statearr_16651_16659 = state_16638;
(statearr_16651_16659[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_16638[(4)]))){
var statearr_16652_16660 = state_16638;
(statearr_16652_16660[(1)] = cljs.core.first((state_16638[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16661 = state_16638;
state_16638 = G__16661;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto__ = function(state_16638){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto____1.call(this,state_16638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_16653 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_16653[(6)] = c__2771__auto__);

return statearr_16653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_16693){
var state_val_16694 = (state_16693[(1)]);
if((state_val_16694 === (7))){
var inst_16677 = (state_16693[(7)]);
var inst_16679 = cljs.core.empty_QMARK_(inst_16677);
var inst_16680 = (!(inst_16679));
var state_16693__$1 = state_16693;
var statearr_16695_16719 = state_16693__$1;
(statearr_16695_16719[(2)] = inst_16680);

(statearr_16695_16719[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (1))){
var state_16693__$1 = state_16693;
var statearr_16696_16720 = state_16693__$1;
(statearr_16696_16720[(2)] = null);

(statearr_16696_16720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (4))){
var inst_16663 = (state_16693[(2)]);
var state_16693__$1 = state_16693;
var statearr_16697_16721 = state_16693__$1;
(statearr_16697_16721[(2)] = inst_16663);

(statearr_16697_16721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (6))){
var inst_16669 = (state_16693[(8)]);
var inst_16677 = (state_16693[(7)]);
var inst_16675 = (state_16693[(2)]);
var inst_16676 = fluree.db.util.async.throw_err(inst_16675);
var inst_16677__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16669,inst_16676);
var state_16693__$1 = (function (){var statearr_16698 = state_16693;
(statearr_16698[(7)] = inst_16677__$1);

return statearr_16698;
})();
if(cljs.core.truth_(inst_16677__$1)){
var statearr_16699_16722 = state_16693__$1;
(statearr_16699_16722[(1)] = (7));

} else {
var statearr_16700_16723 = state_16693__$1;
(statearr_16700_16723[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (3))){
var inst_16691 = (state_16693[(2)]);
var state_16693__$1 = state_16693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16693__$1,inst_16691);
} else {
if((state_val_16694 === (12))){
var inst_16688 = (state_16693[(2)]);
var _ = (function (){var statearr_16701 = state_16693;
(statearr_16701[(4)] = cljs.core.rest((state_16693[(4)])));

return statearr_16701;
})();
var state_16693__$1 = state_16693;
var statearr_16702_16724 = state_16693__$1;
(statearr_16702_16724[(2)] = inst_16688);

(statearr_16702_16724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (2))){
var _ = (function (){var statearr_16703 = state_16693;
(statearr_16703[(4)] = cljs.core.cons((5),(state_16693[(4)])));

return statearr_16703;
})();
var inst_16669 = (function (){return (function (p1__16662_SHARP_){
return p1__16662_SHARP_.o;
});
})();
var inst_16670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16671 = [pred_id];
var inst_16672 = (new cljs.core.PersistentVector(null,1,(5),inst_16670,inst_16671,null));
var inst_16673 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16672);
var state_16693__$1 = (function (){var statearr_16704 = state_16693;
(statearr_16704[(8)] = inst_16669);

return statearr_16704;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16693__$1,(6),inst_16673);
} else {
if((state_val_16694 === (11))){
var state_16693__$1 = state_16693;
var statearr_16706_16725 = state_16693__$1;
(statearr_16706_16725[(2)] = true);

(statearr_16706_16725[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (9))){
var inst_16683 = (state_16693[(2)]);
var state_16693__$1 = state_16693;
if(cljs.core.truth_(inst_16683)){
var statearr_16707_16726 = state_16693__$1;
(statearr_16707_16726[(1)] = (10));

} else {
var statearr_16708_16727 = state_16693__$1;
(statearr_16708_16727[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (5))){
var _ = (function (){var statearr_16709 = state_16693;
(statearr_16709[(4)] = cljs.core.rest((state_16693[(4)])));

return statearr_16709;
})();
var state_16693__$1 = state_16693;
var ex16705 = (state_16693__$1[(2)]);
var statearr_16710_16728 = state_16693__$1;
(statearr_16710_16728[(5)] = ex16705);


if((ex16705 instanceof Error)){
var statearr_16711_16729 = state_16693__$1;
(statearr_16711_16729[(1)] = (4));

(statearr_16711_16729[(5)] = null);

} else {
throw ex16705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (10))){
var inst_16677 = (state_16693[(7)]);
var inst_16685 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_16677);
var state_16693__$1 = state_16693;
var statearr_16712_16730 = state_16693__$1;
(statearr_16712_16730[(2)] = inst_16685);

(statearr_16712_16730[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16694 === (8))){
var inst_16677 = (state_16693[(7)]);
var state_16693__$1 = state_16693;
var statearr_16713_16731 = state_16693__$1;
(statearr_16713_16731[(2)] = inst_16677);

(statearr_16713_16731[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_16714 = [null,null,null,null,null,null,null,null,null];
(statearr_16714[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto__);

(statearr_16714[(1)] = (1));

return statearr_16714;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto____1 = (function (state_16693){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_16693);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e16715){var ex__2752__auto__ = e16715;
var statearr_16716_16732 = state_16693;
(statearr_16716_16732[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_16693[(4)]))){
var statearr_16717_16733 = state_16693;
(statearr_16717_16733[(1)] = cljs.core.first((state_16693[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16734 = state_16693;
state_16693 = G__16734;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto__ = function(state_16693){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto____1.call(this,state_16693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_16718 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_16718[(6)] = c__2771__auto__);

return statearr_16718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_16815){
var state_val_16816 = (state_16815[(1)]);
if((state_val_16816 === (7))){
var state_16815__$1 = state_16815;
var statearr_16817_16855 = state_16815__$1;
(statearr_16817_16855[(2)] = flakes);

(statearr_16817_16855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (20))){
var inst_16772 = (state_16815[(7)]);
var inst_16805 = (state_16815[(2)]);
var inst_16764 = inst_16772;
var inst_16765 = inst_16805;
var state_16815__$1 = (function (){var statearr_16818 = state_16815;
(statearr_16818[(8)] = inst_16765);

(statearr_16818[(9)] = inst_16764);

return statearr_16818;
})();
var statearr_16819_16856 = state_16815__$1;
(statearr_16819_16856[(2)] = null);

(statearr_16819_16856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (1))){
var state_16815__$1 = state_16815;
var statearr_16820_16857 = state_16815__$1;
(statearr_16820_16857[(2)] = null);

(statearr_16820_16857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (4))){
var inst_16737 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
var statearr_16821_16858 = state_16815__$1;
(statearr_16821_16858[(2)] = inst_16737);

(statearr_16821_16858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (15))){
var inst_16771 = (state_16815[(10)]);
var inst_16789 = inst_16771.o;
var state_16815__$1 = state_16815;
var statearr_16822_16859 = state_16815__$1;
(statearr_16822_16859[(2)] = inst_16789);

(statearr_16822_16859[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (13))){
var inst_16808 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
var statearr_16823_16860 = state_16815__$1;
(statearr_16823_16860[(2)] = inst_16808);

(statearr_16823_16860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (6))){
var inst_16744 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16815__$1 = state_16815;
var statearr_16824_16861 = state_16815__$1;
(statearr_16824_16861[(2)] = inst_16744);

(statearr_16824_16861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (17))){
var inst_16786 = (state_16815[(2)]);
var inst_16787 = fluree.db.util.async.throw_err(inst_16786);
var state_16815__$1 = state_16815;
var statearr_16825_16862 = state_16815__$1;
(statearr_16825_16862[(2)] = inst_16787);

(statearr_16825_16862[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (3))){
var inst_16813 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16815__$1,inst_16813);
} else {
if((state_val_16816 === (12))){
var inst_16778 = (state_16815[(11)]);
var inst_16771 = (state_16815[(10)]);
var inst_16776 = inst_16771.p;
var inst_16777 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16776);
var inst_16778__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_16777);
var inst_16779 = inst_16771.op;
var inst_16780 = inst_16779 === false;
var inst_16781 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_16778__$1);
var state_16815__$1 = (function (){var statearr_16826 = state_16815;
(statearr_16826[(11)] = inst_16778__$1);

(statearr_16826[(12)] = inst_16780);

return statearr_16826;
})();
if(inst_16781){
var statearr_16827_16863 = state_16815__$1;
(statearr_16827_16863[(1)] = (14));

} else {
var statearr_16828_16864 = state_16815__$1;
(statearr_16828_16864[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (2))){
var _ = (function (){var statearr_16829 = state_16815;
(statearr_16829[(4)] = cljs.core.cons((5),(state_16815[(4)])));

return statearr_16829;
})();
var state_16815__$1 = state_16815;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16830_16865 = state_16815__$1;
(statearr_16830_16865[(1)] = (6));

} else {
var statearr_16831_16866 = state_16815__$1;
(statearr_16831_16866[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (19))){
var inst_16765 = (state_16815[(8)]);
var inst_16778 = (state_16815[(11)]);
var inst_16771 = (state_16815[(10)]);
var inst_16791 = (state_16815[(13)]);
var inst_16799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16800 = inst_16771.s;
var inst_16801 = [inst_16800,inst_16778,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16802 = (new cljs.core.PersistentVector(null,3,(5),inst_16799,inst_16801,null));
var inst_16803 = cljs.core.assoc_in(inst_16765,inst_16802,inst_16791);
var state_16815__$1 = state_16815;
var statearr_16832_16867 = state_16815__$1;
(statearr_16832_16867[(2)] = inst_16803);

(statearr_16832_16867[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (11))){
var inst_16765 = (state_16815[(8)]);
var state_16815__$1 = state_16815;
var statearr_16834_16868 = state_16815__$1;
(statearr_16834_16868[(2)] = inst_16765);

(statearr_16834_16868[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (9))){
var inst_16764 = (state_16815[(9)]);
var inst_16771 = (state_16815[(10)]);
var inst_16770 = cljs.core.seq(inst_16764);
var inst_16771__$1 = cljs.core.first(inst_16770);
var inst_16772 = cljs.core.next(inst_16770);
var inst_16773 = cljs.core.not(inst_16771__$1);
var state_16815__$1 = (function (){var statearr_16835 = state_16815;
(statearr_16835[(7)] = inst_16772);

(statearr_16835[(10)] = inst_16771__$1);

return statearr_16835;
})();
if(inst_16773){
var statearr_16836_16869 = state_16815__$1;
(statearr_16836_16869[(1)] = (11));

} else {
var statearr_16837_16870 = state_16815__$1;
(statearr_16837_16870[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (5))){
var _ = (function (){var statearr_16838 = state_16815;
(statearr_16838[(4)] = cljs.core.rest((state_16815[(4)])));

return statearr_16838;
})();
var state_16815__$1 = state_16815;
var ex16833 = (state_16815__$1[(2)]);
var statearr_16839_16871 = state_16815__$1;
(statearr_16839_16871[(5)] = ex16833);


if((ex16833 instanceof Error)){
var statearr_16840_16872 = state_16815__$1;
(statearr_16840_16872[(1)] = (4));

(statearr_16840_16872[(5)] = null);

} else {
throw ex16833;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (14))){
var inst_16771 = (state_16815[(10)]);
var inst_16783 = inst_16771.o;
var inst_16784 = fluree.db.query.schema.convert_type_to_kw(inst_16783,db);
var state_16815__$1 = state_16815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16815__$1,(17),inst_16784);
} else {
if((state_val_16816 === (16))){
var inst_16780 = (state_16815[(12)]);
var inst_16791 = (state_16815[(2)]);
var state_16815__$1 = (function (){var statearr_16841 = state_16815;
(statearr_16841[(13)] = inst_16791);

return statearr_16841;
})();
if(cljs.core.truth_(inst_16780)){
var statearr_16842_16873 = state_16815__$1;
(statearr_16842_16873[(1)] = (18));

} else {
var statearr_16843_16874 = state_16815__$1;
(statearr_16843_16874[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (10))){
var inst_16810 = (state_16815[(2)]);
var _ = (function (){var statearr_16844 = state_16815;
(statearr_16844[(4)] = cljs.core.rest((state_16815[(4)])));

return statearr_16844;
})();
var state_16815__$1 = state_16815;
var statearr_16845_16875 = state_16815__$1;
(statearr_16845_16875[(2)] = inst_16810);

(statearr_16845_16875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (18))){
var inst_16765 = (state_16815[(8)]);
var inst_16778 = (state_16815[(11)]);
var inst_16771 = (state_16815[(10)]);
var inst_16791 = (state_16815[(13)]);
var inst_16793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16794 = inst_16771.s;
var inst_16795 = [inst_16794,inst_16778,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16796 = (new cljs.core.PersistentVector(null,3,(5),inst_16793,inst_16795,null));
var inst_16797 = cljs.core.assoc_in(inst_16765,inst_16796,inst_16791);
var state_16815__$1 = state_16815;
var statearr_16846_16876 = state_16815__$1;
(statearr_16846_16876[(2)] = inst_16797);

(statearr_16846_16876[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16816 === (8))){
var inst_16747 = (state_16815[(2)]);
var inst_16748 = cljs.core.PersistentHashSet.EMPTY;
var inst_16749 = cljs.core.vals(tempids);
var inst_16750 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16748,inst_16749);
var inst_16751 = (function (){var pred_flakes = inst_16747;
var is_new_QMARK_ = inst_16750;
return (function (p1__16736_SHARP_,p2__16735_SHARP_){
var f = p2__16735_SHARP_;
return cljs.core.assoc_in(p1__16736_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16847 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16847) : is_new_QMARK_.call(null,G__16847));
})()));
});
})();
var inst_16752 = cljs.core.PersistentHashMap.EMPTY;
var inst_16753 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16751,inst_16752,inst_16747);
var inst_16761 = cljs.core.seq(inst_16747);
var inst_16762 = cljs.core.first(inst_16761);
var inst_16763 = cljs.core.next(inst_16761);
var inst_16764 = inst_16747;
var inst_16765 = inst_16753;
var state_16815__$1 = (function (){var statearr_16848 = state_16815;
(statearr_16848[(8)] = inst_16765);

(statearr_16848[(14)] = inst_16762);

(statearr_16848[(9)] = inst_16764);

(statearr_16848[(15)] = inst_16763);

return statearr_16848;
})();
var statearr_16849_16877 = state_16815__$1;
(statearr_16849_16877[(2)] = null);

(statearr_16849_16877[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto____0 = (function (){
var statearr_16850 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16850[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto__);

(statearr_16850[(1)] = (1));

return statearr_16850;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto____1 = (function (state_16815){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_16815);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e16851){var ex__2752__auto__ = e16851;
var statearr_16852_16878 = state_16815;
(statearr_16852_16878[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_16815[(4)]))){
var statearr_16853_16879 = state_16815;
(statearr_16853_16879[(1)] = cljs.core.first((state_16815[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16880 = state_16815;
state_16815 = G__16880;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto__ = function(state_16815){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto____1.call(this,state_16815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_16854 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_16854[(6)] = c__2771__auto__);

return statearr_16854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16882 = arguments.length;
switch (G__16882) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16885 = arguments.length;
switch (G__16885) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_17197){
var state_val_17198 = (state_17197[(1)]);
if((state_val_17198 === (121))){
var inst_17152 = (state_17197[(7)]);
var state_17197__$1 = state_17197;
var statearr_17199_17392 = state_17197__$1;
(statearr_17199_17392[(2)] = inst_17152);

(statearr_17199_17392[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (65))){
var inst_17051 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17051)){
var statearr_17200_17393 = state_17197__$1;
(statearr_17200_17393[(1)] = (66));

} else {
var statearr_17201_17394 = state_17197__$1;
(statearr_17201_17394[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (70))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17061 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_17062 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17061,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,3,inst_17061,null));
var inst_17063 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17062,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17062,null));
var inst_17064 = (inst_17063.cljs$core$IFn$_invoke$arity$1 ? inst_17063.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17063.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17064)){
var statearr_17202_17395 = state_17197__$1;
(statearr_17202_17395[(1)] = (72));

} else {
var statearr_17203_17396 = state_17197__$1;
(statearr_17203_17396[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (62))){
var inst_17041 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17204_17397 = state_17197__$1;
(statearr_17204_17397[(2)] = inst_17041);

(statearr_17204_17397[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (74))){
var inst_17147 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17205_17398 = state_17197__$1;
(statearr_17205_17398[(2)] = inst_17147);

(statearr_17205_17398[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (110))){
var inst_17174 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17174)){
var statearr_17206_17399 = state_17197__$1;
(statearr_17206_17399[(1)] = (117));

} else {
var statearr_17207_17400 = state_17197__$1;
(statearr_17207_17400[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (7))){
var inst_17192 = (state_17197[(2)]);
var _ = (function (){var statearr_17208 = state_17197;
(statearr_17208[(4)] = cljs.core.rest((state_17197[(4)])));

return statearr_17208;
})();
var state_17197__$1 = state_17197;
var statearr_17209_17401 = state_17197__$1;
(statearr_17209_17401[(2)] = inst_17192);

(statearr_17209_17401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (59))){
var inst_17045 = (state_17197[(10)]);
var inst_16925 = (state_17197[(11)]);
var inst_17044 = (state_17197[(2)]);
var inst_17045__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16925);
var state_17197__$1 = (function (){var statearr_17210 = state_17197;
(statearr_17210[(10)] = inst_17045__$1);

(statearr_17210[(12)] = inst_17044);

return statearr_17210;
})();
if(cljs.core.truth_(inst_17045__$1)){
var statearr_17211_17402 = state_17197__$1;
(statearr_17211_17402[(1)] = (63));

} else {
var statearr_17212_17403 = state_17197__$1;
(statearr_17212_17403[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (86))){
var inst_17087 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17213_17404 = state_17197__$1;
(statearr_17213_17404[(2)] = inst_17087);

(statearr_17213_17404[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (20))){
var inst_16951 = (state_17197[(13)]);
var inst_16925 = (state_17197[(11)]);
var inst_16951__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16925);
var state_17197__$1 = (function (){var statearr_17214 = state_17197;
(statearr_17214[(13)] = inst_16951__$1);

return statearr_17214;
})();
if(cljs.core.truth_(inst_16951__$1)){
var statearr_17215_17405 = state_17197__$1;
(statearr_17215_17405[(1)] = (23));

} else {
var statearr_17216_17406 = state_17197__$1;
(statearr_17216_17406[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (72))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17066 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17217_17407 = state_17197__$1;
(statearr_17217_17407[(2)] = inst_17066);

(statearr_17217_17407[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (58))){
var inst_17006 = (state_17197[(14)]);
var state_17197__$1 = state_17197;
var statearr_17218_17408 = state_17197__$1;
(statearr_17218_17408[(2)] = inst_17006);

(statearr_17218_17408[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (60))){
var inst_16924 = (state_17197[(15)]);
var inst_16913 = (state_17197[(16)]);
var inst_17032 = fluree.db.dbproto._p_prop(inst_16913,new cljs.core.Keyword(null,"name","name",1843675177),inst_16924);
var inst_17033 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17032)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_17034 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17035 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_17036 = cljs.core.PersistentHashMap.fromArrays(inst_17034,inst_17035);
var inst_17037 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17033,inst_17036);
var inst_17038 = (function(){throw inst_17037})();
var state_17197__$1 = state_17197;
var statearr_17219_17409 = state_17197__$1;
(statearr_17219_17409[(2)] = inst_17038);

(statearr_17219_17409[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (27))){
var inst_16954 = (state_17197[(17)]);
var state_17197__$1 = state_17197;
var statearr_17220_17410 = state_17197__$1;
(statearr_17220_17410[(2)] = inst_16954);

(statearr_17220_17410[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (1))){
var state_17197__$1 = state_17197;
var statearr_17221_17411 = state_17197__$1;
(statearr_17221_17411[(2)] = null);

(statearr_17221_17411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (69))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17222_17412 = state_17197__$1;
(statearr_17222_17412[(2)] = inst_17044);

(statearr_17222_17412[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (101))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17125 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17223_17413 = state_17197__$1;
(statearr_17223_17413[(2)] = inst_17125);

(statearr_17223_17413[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (24))){
var inst_16951 = (state_17197[(13)]);
var state_17197__$1 = state_17197;
var statearr_17224_17414 = state_17197__$1;
(statearr_17224_17414[(2)] = inst_16951);

(statearr_17224_17414[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (102))){
var inst_17127 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17225_17415 = state_17197__$1;
(statearr_17225_17415[(2)] = inst_17127);

(statearr_17225_17415[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (55))){
var inst_17023 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17226_17416 = state_17197__$1;
(statearr_17226_17416[(2)] = inst_17023);

(statearr_17226_17416[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (85))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17085 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17227_17417 = state_17197__$1;
(statearr_17227_17417[(2)] = inst_17085);

(statearr_17227_17417[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (39))){
var inst_16988 = (state_17197[(18)]);
var state_17197__$1 = state_17197;
var statearr_17228_17418 = state_17197__$1;
(statearr_17228_17418[(2)] = inst_16988);

(statearr_17228_17418[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (88))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17229_17419 = state_17197__$1;
(statearr_17229_17419[(2)] = inst_17044);

(statearr_17229_17419[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (46))){
var inst_17007 = (state_17197[(19)]);
var inst_16925 = (state_17197[(11)]);
var inst_17006 = (state_17197[(2)]);
var inst_17007__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16925);
var state_17197__$1 = (function (){var statearr_17230 = state_17197;
(statearr_17230[(19)] = inst_17007__$1);

(statearr_17230[(14)] = inst_17006);

return statearr_17230;
})();
if(cljs.core.truth_(inst_17007__$1)){
var statearr_17231_17420 = state_17197__$1;
(statearr_17231_17420[(1)] = (47));

} else {
var statearr_17232_17421 = state_17197__$1;
(statearr_17232_17421[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (4))){
var inst_16886 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17233_17422 = state_17197__$1;
(statearr_17233_17422[(2)] = inst_16886);

(statearr_17233_17422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (77))){
var inst_17145 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17234_17423 = state_17197__$1;
(statearr_17234_17423[(2)] = inst_17145);

(statearr_17234_17423[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (106))){
var inst_17137 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17235_17424 = state_17197__$1;
(statearr_17235_17424[(2)] = inst_17137);

(statearr_17235_17424[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (119))){
var inst_16923 = (state_17197[(20)]);
var inst_17187 = (state_17197[(2)]);
var inst_16912 = inst_16923;
var inst_16913 = inst_17187;
var state_17197__$1 = (function (){var statearr_17236 = state_17197;
(statearr_17236[(16)] = inst_16913);

(statearr_17236[(21)] = inst_16912);

return statearr_17236;
})();
var statearr_17237_17425 = state_17197__$1;
(statearr_17237_17425[(2)] = null);

(statearr_17237_17425[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (95))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17109 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17110 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_17109,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,5,inst_17109,null));
var inst_17111 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17110,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17110,null));
var inst_17112 = (inst_17111.cljs$core$IFn$_invoke$arity$1 ? inst_17111.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17111.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17112)){
var statearr_17238_17426 = state_17197__$1;
(statearr_17238_17426[(1)] = (96));

} else {
var statearr_17239_17427 = state_17197__$1;
(statearr_17239_17427[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (54))){
var inst_17014 = (state_17197[(22)]);
var state_17197__$1 = state_17197;
var statearr_17240_17428 = state_17197__$1;
(statearr_17240_17428[(2)] = inst_17014);

(statearr_17240_17428[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (92))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17241_17429 = state_17197__$1;
(statearr_17241_17429[(2)] = inst_17044);

(statearr_17241_17429[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (104))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17242_17430 = state_17197__$1;
(statearr_17242_17430[(2)] = inst_17044);

(statearr_17242_17430[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (15))){
var inst_16933 = (state_17197[(23)]);
var state_17197__$1 = state_17197;
var statearr_17243_17431 = state_17197__$1;
(statearr_17243_17431[(2)] = inst_16933);

(statearr_17243_17431[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (48))){
var inst_17007 = (state_17197[(19)]);
var state_17197__$1 = state_17197;
var statearr_17244_17432 = state_17197__$1;
(statearr_17244_17432[(2)] = inst_17007);

(statearr_17244_17432[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (50))){
var inst_16925 = (state_17197[(11)]);
var inst_17014 = (state_17197[(22)]);
var inst_17012 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_17013 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17012);
var inst_17014__$1 = inst_17013 === true;
var state_17197__$1 = (function (){var statearr_17245 = state_17197;
(statearr_17245[(22)] = inst_17014__$1);

return statearr_17245;
})();
if(cljs.core.truth_(inst_17014__$1)){
var statearr_17246_17433 = state_17197__$1;
(statearr_17246_17433[(1)] = (53));

} else {
var statearr_17247_17434 = state_17197__$1;
(statearr_17247_17434[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (116))){
var inst_17168 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17248_17435 = state_17197__$1;
(statearr_17248_17435[(2)] = inst_17168);

(statearr_17248_17435[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (75))){
var inst_17057 = (state_17197[(8)]);
var state_17197__$1 = state_17197;
var G__17249_17436 = inst_17057;
var G__17249_17437__$1 = (((G__17249_17436 instanceof cljs.core.Keyword))?G__17249_17436.fqn:null);
switch (G__17249_17437__$1) {
case "long":
var statearr_17250_17439 = state_17197__$1;
(statearr_17250_17439[(1)] = (79));


break;
case "bigint":
var statearr_17251_17440 = state_17197__$1;
(statearr_17251_17440[(1)] = (83));


break;
case "double":
var statearr_17252_17441 = state_17197__$1;
(statearr_17252_17441[(1)] = (87));


break;
case "float":
var statearr_17253_17442 = state_17197__$1;
(statearr_17253_17442[(1)] = (91));


break;
case "bigdec":
var statearr_17254_17443 = state_17197__$1;
(statearr_17254_17443[(1)] = (95));


break;
case "string":
var statearr_17255_17444 = state_17197__$1;
(statearr_17255_17444[(1)] = (99));


break;
case "instant":
var statearr_17256_17445 = state_17197__$1;
(statearr_17256_17445[(1)] = (103));


break;
default:
var statearr_17257_17446 = state_17197__$1;
(statearr_17257_17446[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (99))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17119 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_17120 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_17119,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,5,inst_17119,null));
var inst_17121 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17120,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17120,null));
var inst_17122 = (inst_17121.cljs$core$IFn$_invoke$arity$1 ? inst_17121.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17121.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17122)){
var statearr_17258_17447 = state_17197__$1;
(statearr_17258_17447[(1)] = (100));

} else {
var statearr_17259_17448 = state_17197__$1;
(statearr_17259_17448[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (21))){
var inst_16949 = (state_17197[(24)]);
var state_17197__$1 = state_17197;
var statearr_17260_17449 = state_17197__$1;
(statearr_17260_17449[(2)] = inst_16949);

(statearr_17260_17449[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (31))){
var inst_16965 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17261_17450 = state_17197__$1;
(statearr_17261_17450[(2)] = inst_16965);

(statearr_17261_17450[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (113))){
var inst_17171 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17262_17451 = state_17197__$1;
(statearr_17262_17451[(2)] = inst_17171);

(statearr_17262_17451[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (32))){
var state_17197__$1 = state_17197;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17263_17452 = state_17197__$1;
(statearr_17263_17452[(1)] = (35));

} else {
var statearr_17264_17453 = state_17197__$1;
(statearr_17264_17453[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (40))){
var inst_17001 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17001)){
var statearr_17265_17454 = state_17197__$1;
(statearr_17265_17454[(1)] = (44));

} else {
var statearr_17266_17455 = state_17197__$1;
(statearr_17266_17455[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (91))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17099 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17100 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17099,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,3,inst_17099,null));
var inst_17101 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17100,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17100,null));
var inst_17102 = (inst_17101.cljs$core$IFn$_invoke$arity$1 ? inst_17101.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17101.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17102)){
var statearr_17267_17456 = state_17197__$1;
(statearr_17267_17456[(1)] = (92));

} else {
var statearr_17268_17457 = state_17197__$1;
(statearr_17268_17457[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (117))){
var state_17197__$1 = state_17197;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17269_17458 = state_17197__$1;
(statearr_17269_17458[(1)] = (120));

} else {
var statearr_17270_17459 = state_17197__$1;
(statearr_17270_17459[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (108))){
var inst_17156 = (state_17197[(25)]);
var inst_16925 = (state_17197[(11)]);
var inst_17156__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16925);
var state_17197__$1 = (function (){var statearr_17271 = state_17197;
(statearr_17271[(25)] = inst_17156__$1);

return statearr_17271;
})();
if(cljs.core.truth_(inst_17156__$1)){
var statearr_17272_17460 = state_17197__$1;
(statearr_17272_17460[(1)] = (111));

} else {
var statearr_17273_17461 = state_17197__$1;
(statearr_17273_17461[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (56))){
var inst_17018 = (state_17197[(2)]);
var inst_17019 = fluree.db.util.async.throw_err(inst_17018);
var inst_17020 = cljs.core.not(inst_17019);
var state_17197__$1 = state_17197;
var statearr_17274_17462 = state_17197__$1;
(statearr_17274_17462[(2)] = inst_17020);

(statearr_17274_17462[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (33))){
var inst_16948 = (state_17197[(26)]);
var state_17197__$1 = state_17197;
var statearr_17275_17463 = state_17197__$1;
(statearr_17275_17463[(2)] = inst_16948);

(statearr_17275_17463[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (13))){
var inst_16943 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_16943)){
var statearr_17276_17464 = state_17197__$1;
(statearr_17276_17464[(1)] = (17));

} else {
var statearr_17277_17465 = state_17197__$1;
(statearr_17277_17465[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (22))){
var inst_16974 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_16974)){
var statearr_17278_17466 = state_17197__$1;
(statearr_17278_17466[(1)] = (32));

} else {
var statearr_17279_17467 = state_17197__$1;
(statearr_17279_17467[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (90))){
var inst_17097 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17280_17468 = state_17197__$1;
(statearr_17280_17468[(2)] = inst_17097);

(statearr_17280_17468[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (109))){
var inst_17154 = (state_17197[(27)]);
var state_17197__$1 = state_17197;
var statearr_17281_17469 = state_17197__$1;
(statearr_17281_17469[(2)] = inst_17154);

(statearr_17281_17469[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (36))){
var inst_16948 = (state_17197[(26)]);
var state_17197__$1 = state_17197;
var statearr_17282_17470 = state_17197__$1;
(statearr_17282_17470[(2)] = inst_16948);

(statearr_17282_17470[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (41))){
var inst_16925 = (state_17197[(11)]);
var inst_16993 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_16994 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16993);
var inst_16995 = inst_16994 === true;
var state_17197__$1 = state_17197;
var statearr_17283_17471 = state_17197__$1;
(statearr_17283_17471[(2)] = inst_16995);

(statearr_17283_17471[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (118))){
var inst_17152 = (state_17197[(7)]);
var state_17197__$1 = state_17197;
var statearr_17284_17472 = state_17197__$1;
(statearr_17284_17472[(2)] = inst_17152);

(statearr_17284_17472[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (89))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17095 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17285_17473 = state_17197__$1;
(statearr_17285_17473[(2)] = inst_17095);

(statearr_17285_17473[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (100))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17286_17474 = state_17197__$1;
(statearr_17286_17474[(2)] = inst_17044);

(statearr_17286_17474[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (122))){
var inst_17184 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17287_17475 = state_17197__$1;
(statearr_17287_17475[(2)] = inst_17184);

(statearr_17287_17475[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (43))){
var inst_16998 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17288_17476 = state_17197__$1;
(statearr_17288_17476[(2)] = inst_16998);

(statearr_17288_17476[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (61))){
var inst_17006 = (state_17197[(14)]);
var state_17197__$1 = state_17197;
var statearr_17289_17477 = state_17197__$1;
(statearr_17289_17477[(2)] = inst_17006);

(statearr_17289_17477[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (29))){
var inst_16925 = (state_17197[(11)]);
var inst_16960 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_16961 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16960);
var inst_16962 = inst_16961 === true;
var state_17197__$1 = state_17197;
var statearr_17290_17478 = state_17197__$1;
(statearr_17290_17478[(2)] = inst_16962);

(statearr_17290_17478[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (44))){
var inst_16987 = (state_17197[(28)]);
var inst_17003 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16987,"a component","a non-component",throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17291_17479 = state_17197__$1;
(statearr_17291_17479[(2)] = inst_17003);

(statearr_17291_17479[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (93))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17105 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17292_17480 = state_17197__$1;
(statearr_17292_17480[(2)] = inst_17105);

(statearr_17292_17480[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (6))){
var inst_16924 = (state_17197[(15)]);
var inst_16912 = (state_17197[(21)]);
var inst_16921 = cljs.core.seq(inst_16912);
var inst_16922 = cljs.core.first(inst_16921);
var inst_16923 = cljs.core.next(inst_16921);
var inst_16924__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16922,(0),null);
var inst_16925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16922,(1),null);
var inst_16926 = cljs.core.not(inst_16924__$1);
var state_17197__$1 = (function (){var statearr_17293 = state_17197;
(statearr_17293[(15)] = inst_16924__$1);

(statearr_17293[(11)] = inst_16925);

(statearr_17293[(20)] = inst_16923);

return statearr_17293;
})();
if(inst_16926){
var statearr_17294_17481 = state_17197__$1;
(statearr_17294_17481[(1)] = (8));

} else {
var statearr_17295_17482 = state_17197__$1;
(statearr_17295_17482[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (111))){
var inst_16925 = (state_17197[(11)]);
var inst_17160 = (state_17197[(29)]);
var inst_17158 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_17159 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17158);
var inst_17160__$1 = inst_17159 === true;
var state_17197__$1 = (function (){var statearr_17296 = state_17197;
(statearr_17296[(29)] = inst_17160__$1);

return statearr_17296;
})();
if(cljs.core.truth_(inst_17160__$1)){
var statearr_17297_17483 = state_17197__$1;
(statearr_17297_17483[(1)] = (114));

} else {
var statearr_17298_17484 = state_17197__$1;
(statearr_17298_17484[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (28))){
var inst_16968 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17299_17485 = state_17197__$1;
(statearr_17299_17485[(2)] = inst_16968);

(statearr_17299_17485[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (64))){
var inst_17045 = (state_17197[(10)]);
var state_17197__$1 = state_17197;
var statearr_17300_17486 = state_17197__$1;
(statearr_17300_17486[(2)] = inst_17045);

(statearr_17300_17486[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (103))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17129 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17130 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_17129,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,2,inst_17129,null));
var inst_17131 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17130,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17130,null));
var inst_17132 = (inst_17131.cljs$core$IFn$_invoke$arity$1 ? inst_17131.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17131.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17132)){
var statearr_17301_17487 = state_17197__$1;
(statearr_17301_17487[(1)] = (104));

} else {
var statearr_17302_17488 = state_17197__$1;
(statearr_17302_17488[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (51))){
var inst_17010 = (state_17197[(30)]);
var state_17197__$1 = state_17197;
var statearr_17303_17489 = state_17197__$1;
(statearr_17303_17489[(2)] = inst_17010);

(statearr_17303_17489[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (25))){
var inst_16971 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17304_17490 = state_17197__$1;
(statearr_17304_17490[(2)] = inst_16971);

(statearr_17304_17490[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (34))){
var inst_16925 = (state_17197[(11)]);
var inst_16988 = (state_17197[(18)]);
var inst_16987 = (state_17197[(2)]);
var inst_16988__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16925);
var state_17197__$1 = (function (){var statearr_17305 = state_17197;
(statearr_17305[(18)] = inst_16988__$1);

(statearr_17305[(28)] = inst_16987);

return statearr_17305;
})();
if(cljs.core.truth_(inst_16988__$1)){
var statearr_17306_17491 = state_17197__$1;
(statearr_17306_17491[(1)] = (38));

} else {
var statearr_17307_17492 = state_17197__$1;
(statearr_17307_17492[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (17))){
var inst_16913 = (state_17197[(16)]);
var inst_16945 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16913,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17308_17493 = state_17197__$1;
(statearr_17308_17493[(2)] = inst_16945);

(statearr_17308_17493[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (3))){
var inst_17195 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17197__$1,inst_17195);
} else {
if((state_val_17198 === (12))){
var inst_16929 = (state_17197[(31)]);
var state_17197__$1 = state_17197;
var statearr_17309_17494 = state_17197__$1;
(statearr_17309_17494[(2)] = inst_16929);

(statearr_17309_17494[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (2))){
var _ = (function (){var statearr_17310 = state_17197;
(statearr_17310[(4)] = cljs.core.cons((5),(state_17197[(4)])));

return statearr_17310;
})();
var inst_16905 = pred_changes;
var inst_16906 = cljs.core.seq(inst_16905);
var inst_16907 = cljs.core.first(inst_16906);
var inst_16908 = cljs.core.next(inst_16906);
var inst_16909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16907,(0),null);
var inst_16910 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16907,(1),null);
var inst_16911 = db;
var inst_16912 = inst_16905;
var inst_16913 = inst_16911;
var state_17197__$1 = (function (){var statearr_17311 = state_17197;
(statearr_17311[(16)] = inst_16913);

(statearr_17311[(21)] = inst_16912);

(statearr_17311[(32)] = inst_16909);

(statearr_17311[(33)] = inst_16910);

(statearr_17311[(34)] = inst_16908);

return statearr_17311;
})();
var statearr_17312_17495 = state_17197__$1;
(statearr_17312_17495[(2)] = null);

(statearr_17312_17495[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (66))){
var inst_17057 = (state_17197[(8)]);
var inst_16925 = (state_17197[(11)]);
var inst_17056 = (state_17197[(9)]);
var inst_17054 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_17055 = cljs.core.__destructure_map(inst_17054);
var inst_17056__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17055,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_17057__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17055,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_17058 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17057__$1,inst_17056__$1);
var state_17197__$1 = (function (){var statearr_17313 = state_17197;
(statearr_17313[(8)] = inst_17057__$1);

(statearr_17313[(9)] = inst_17056__$1);

return statearr_17313;
})();
if(inst_17058){
var statearr_17314_17496 = state_17197__$1;
(statearr_17314_17496[(1)] = (69));

} else {
var statearr_17315_17497 = state_17197__$1;
(statearr_17315_17497[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (107))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17139 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17316_17498 = state_17197__$1;
(statearr_17316_17498[(2)] = inst_17139);

(statearr_17316_17498[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (23))){
var inst_16925 = (state_17197[(11)]);
var inst_16954 = (state_17197[(17)]);
var inst_16953 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_16954__$1 = inst_16953 === true;
var state_17197__$1 = (function (){var statearr_17317 = state_17197;
(statearr_17317[(17)] = inst_16954__$1);

return statearr_17317;
})();
if(cljs.core.truth_(inst_16954__$1)){
var statearr_17318_17499 = state_17197__$1;
(statearr_17318_17499[(1)] = (26));

} else {
var statearr_17319_17500 = state_17197__$1;
(statearr_17319_17500[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (47))){
var inst_16925 = (state_17197[(11)]);
var inst_17010 = (state_17197[(30)]);
var inst_17009 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_17010__$1 = cljs.core.not(inst_17009);
var state_17197__$1 = (function (){var statearr_17320 = state_17197;
(statearr_17320[(30)] = inst_17010__$1);

return statearr_17320;
})();
if(inst_17010__$1){
var statearr_17321_17501 = state_17197__$1;
(statearr_17321_17501[(1)] = (50));

} else {
var statearr_17322_17502 = state_17197__$1;
(statearr_17322_17502[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (35))){
var inst_16977 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16978 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16979 = cljs.core.PersistentHashMap.fromArrays(inst_16977,inst_16978);
var inst_16980 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16979);
var inst_16981 = (function(){throw inst_16980})();
var state_17197__$1 = state_17197;
var statearr_17323_17503 = state_17197__$1;
(statearr_17323_17503[(2)] = inst_16981);

(statearr_17323_17503[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (82))){
var inst_17077 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17324_17504 = state_17197__$1;
(statearr_17324_17504[(2)] = inst_17077);

(statearr_17324_17504[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (76))){
var state_17197__$1 = state_17197;
var statearr_17325_17505 = state_17197__$1;
(statearr_17325_17505[(2)] = null);

(statearr_17325_17505[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (97))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17115 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17326_17506 = state_17197__$1;
(statearr_17326_17506[(2)] = inst_17115);

(statearr_17326_17506[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (19))){
var inst_16925 = (state_17197[(11)]);
var inst_16949 = (state_17197[(24)]);
var inst_16948 = (state_17197[(2)]);
var inst_16949__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16925);
var state_17197__$1 = (function (){var statearr_17327 = state_17197;
(statearr_17327[(26)] = inst_16948);

(statearr_17327[(24)] = inst_16949__$1);

return statearr_17327;
})();
if(cljs.core.truth_(inst_16949__$1)){
var statearr_17328_17507 = state_17197__$1;
(statearr_17328_17507[(1)] = (20));

} else {
var statearr_17329_17508 = state_17197__$1;
(statearr_17329_17508[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (57))){
var state_17197__$1 = state_17197;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17330_17509 = state_17197__$1;
(statearr_17330_17509[(1)] = (60));

} else {
var statearr_17331_17510 = state_17197__$1;
(statearr_17331_17510[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (68))){
var inst_16925 = (state_17197[(11)]);
var inst_17154 = (state_17197[(27)]);
var inst_17152 = (state_17197[(2)]);
var inst_17153 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_17154__$1 = inst_17153 === true;
var state_17197__$1 = (function (){var statearr_17332 = state_17197;
(statearr_17332[(27)] = inst_17154__$1);

(statearr_17332[(7)] = inst_17152);

return statearr_17332;
})();
if(cljs.core.truth_(inst_17154__$1)){
var statearr_17333_17511 = state_17197__$1;
(statearr_17333_17511[(1)] = (108));

} else {
var statearr_17334_17512 = state_17197__$1;
(statearr_17334_17512[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (11))){
var inst_16933 = (state_17197[(23)]);
var inst_16925 = (state_17197[(11)]);
var inst_16931 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_16932 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16931);
var inst_16933__$1 = inst_16932 === false;
var state_17197__$1 = (function (){var statearr_17335 = state_17197;
(statearr_17335[(23)] = inst_16933__$1);

return statearr_17335;
})();
if(cljs.core.truth_(inst_16933__$1)){
var statearr_17336_17513 = state_17197__$1;
(statearr_17336_17513[(1)] = (14));

} else {
var statearr_17337_17514 = state_17197__$1;
(statearr_17337_17514[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (115))){
var inst_17160 = (state_17197[(29)]);
var state_17197__$1 = state_17197;
var statearr_17339_17515 = state_17197__$1;
(statearr_17339_17515[(2)] = inst_17160);

(statearr_17339_17515[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (9))){
var inst_16925 = (state_17197[(11)]);
var inst_16929 = (state_17197[(31)]);
var inst_16929__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16925);
var state_17197__$1 = (function (){var statearr_17340 = state_17197;
(statearr_17340[(31)] = inst_16929__$1);

return statearr_17340;
})();
if(cljs.core.truth_(inst_16929__$1)){
var statearr_17341_17516 = state_17197__$1;
(statearr_17341_17516[(1)] = (11));

} else {
var statearr_17342_17517 = state_17197__$1;
(statearr_17342_17517[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (5))){
var _ = (function (){var statearr_17343 = state_17197;
(statearr_17343[(4)] = cljs.core.rest((state_17197[(4)])));

return statearr_17343;
})();
var state_17197__$1 = state_17197;
var ex17338 = (state_17197__$1[(2)]);
var statearr_17344_17518 = state_17197__$1;
(statearr_17344_17518[(5)] = ex17338);


if((ex17338 instanceof Error)){
var statearr_17345_17519 = state_17197__$1;
(statearr_17345_17519[(1)] = (4));

(statearr_17345_17519[(5)] = null);

} else {
throw ex17338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (112))){
var inst_17156 = (state_17197[(25)]);
var state_17197__$1 = state_17197;
var statearr_17346_17520 = state_17197__$1;
(statearr_17346_17520[(2)] = inst_17156);

(statearr_17346_17520[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (83))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17079 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17080 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17079,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,3,inst_17079,null));
var inst_17081 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17080,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17080,null));
var inst_17082 = (inst_17081.cljs$core$IFn$_invoke$arity$1 ? inst_17081.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17081.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17082)){
var statearr_17347_17521 = state_17197__$1;
(statearr_17347_17521[(1)] = (84));

} else {
var statearr_17348_17522 = state_17197__$1;
(statearr_17348_17522[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (14))){
var inst_16925 = (state_17197[(11)]);
var inst_16935 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_16936 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16935);
var inst_16937 = inst_16936 === true;
var state_17197__$1 = state_17197;
var statearr_17349_17523 = state_17197__$1;
(statearr_17349_17523[(2)] = inst_16937);

(statearr_17349_17523[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (45))){
var inst_16987 = (state_17197[(28)]);
var state_17197__$1 = state_17197;
var statearr_17350_17524 = state_17197__$1;
(statearr_17350_17524[(2)] = inst_16987);

(statearr_17350_17524[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (53))){
var inst_16924 = (state_17197[(15)]);
var inst_16913 = (state_17197[(16)]);
var inst_17016 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16913,inst_16924);
var state_17197__$1 = state_17197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17197__$1,(56),inst_17016);
} else {
if((state_val_17198 === (78))){
var inst_17142 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17351_17525 = state_17197__$1;
(statearr_17351_17525[(2)] = inst_17142);

(statearr_17351_17525[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (26))){
var inst_16925 = (state_17197[(11)]);
var inst_16958 = (state_17197[(35)]);
var inst_16956 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_16957 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16956);
var inst_16958__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16957);
var state_17197__$1 = (function (){var statearr_17352 = state_17197;
(statearr_17352[(35)] = inst_16958__$1);

return statearr_17352;
})();
if(inst_16958__$1){
var statearr_17353_17526 = state_17197__$1;
(statearr_17353_17526[(1)] = (29));

} else {
var statearr_17354_17527 = state_17197__$1;
(statearr_17354_17527[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (16))){
var inst_16940 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17355_17528 = state_17197__$1;
(statearr_17355_17528[(2)] = inst_16940);

(statearr_17355_17528[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (81))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17075 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17356_17529 = state_17197__$1;
(statearr_17356_17529[(2)] = inst_17075);

(statearr_17356_17529[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (120))){
var inst_17177 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17178 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_17179 = cljs.core.PersistentHashMap.fromArrays(inst_17177,inst_17178);
var inst_17180 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_17179);
var inst_17181 = (function(){throw inst_17180})();
var state_17197__$1 = state_17197;
var statearr_17357_17530 = state_17197__$1;
(statearr_17357_17530[(2)] = inst_17181);

(statearr_17357_17530[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (79))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17069 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17070 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_17069,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,2,inst_17069,null));
var inst_17071 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17070,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17070,null));
var inst_17072 = (inst_17071.cljs$core$IFn$_invoke$arity$1 ? inst_17071.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17071.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17072)){
var statearr_17358_17531 = state_17197__$1;
(statearr_17358_17531[(1)] = (80));

} else {
var statearr_17359_17532 = state_17197__$1;
(statearr_17359_17532[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (38))){
var inst_16925 = (state_17197[(11)]);
var inst_16991 = (state_17197[(36)]);
var inst_16990 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_16991__$1 = cljs.core.not(inst_16990);
var state_17197__$1 = (function (){var statearr_17360 = state_17197;
(statearr_17360[(36)] = inst_16991__$1);

return statearr_17360;
})();
if(inst_16991__$1){
var statearr_17361_17533 = state_17197__$1;
(statearr_17361_17533[(1)] = (41));

} else {
var statearr_17362_17534 = state_17197__$1;
(statearr_17362_17534[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (98))){
var inst_17117 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17363_17535 = state_17197__$1;
(statearr_17363_17535[(2)] = inst_17117);

(statearr_17363_17535[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (87))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17089 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17090 = (inst_17057.cljs$core$IFn$_invoke$arity$5 ? inst_17057.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17089,null) : inst_17057.call(null,cljs.core.PersistentArrayMap,null,3,inst_17089,null));
var inst_17091 = (inst_17057.cljs$core$IFn$_invoke$arity$4 ? inst_17057.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17090,null) : inst_17057.call(null,cljs.core.PersistentHashSet,null,inst_17090,null));
var inst_17092 = (inst_17091.cljs$core$IFn$_invoke$arity$1 ? inst_17091.cljs$core$IFn$_invoke$arity$1(inst_17056) : inst_17091.call(null,inst_17056));
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17092)){
var statearr_17364_17536 = state_17197__$1;
(statearr_17364_17536[(1)] = (88));

} else {
var statearr_17365_17537 = state_17197__$1;
(statearr_17365_17537[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (30))){
var inst_16958 = (state_17197[(35)]);
var state_17197__$1 = state_17197;
var statearr_17366_17538 = state_17197__$1;
(statearr_17366_17538[(2)] = inst_16958);

(statearr_17366_17538[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (73))){
var state_17197__$1 = state_17197;
var statearr_17367_17539 = state_17197__$1;
(statearr_17367_17539[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (96))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17369_17540 = state_17197__$1;
(statearr_17369_17540[(2)] = inst_17044);

(statearr_17369_17540[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (10))){
var inst_17190 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17370_17541 = state_17197__$1;
(statearr_17370_17541[(2)] = inst_17190);

(statearr_17370_17541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (18))){
var inst_16913 = (state_17197[(16)]);
var state_17197__$1 = state_17197;
var statearr_17371_17542 = state_17197__$1;
(statearr_17371_17542[(2)] = inst_16913);

(statearr_17371_17542[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (105))){
var inst_17057 = (state_17197[(8)]);
var inst_17056 = (state_17197[(9)]);
var inst_17135 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17056,inst_17057,throw_QMARK_);
var state_17197__$1 = state_17197;
var statearr_17372_17543 = state_17197__$1;
(statearr_17372_17543[(2)] = inst_17135);

(statearr_17372_17543[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (52))){
var inst_17026 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17373_17544 = state_17197__$1;
(statearr_17373_17544[(2)] = inst_17026);

(statearr_17373_17544[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (114))){
var inst_16925 = (state_17197[(11)]);
var inst_17162 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_17163 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17162);
var inst_17164 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_17163);
var inst_17165 = (!(inst_17164));
var state_17197__$1 = state_17197;
var statearr_17374_17545 = state_17197__$1;
(statearr_17374_17545[(2)] = inst_17165);

(statearr_17374_17545[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (67))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17375_17546 = state_17197__$1;
(statearr_17375_17546[(2)] = inst_17044);

(statearr_17375_17546[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (71))){
var inst_17149 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17376_17547 = state_17197__$1;
(statearr_17376_17547[(2)] = inst_17149);

(statearr_17376_17547[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (42))){
var inst_16991 = (state_17197[(36)]);
var state_17197__$1 = state_17197;
var statearr_17377_17548 = state_17197__$1;
(statearr_17377_17548[(2)] = inst_16991);

(statearr_17377_17548[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (80))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17378_17549 = state_17197__$1;
(statearr_17378_17549[(2)] = inst_17044);

(statearr_17378_17549[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (37))){
var inst_16984 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17379_17550 = state_17197__$1;
(statearr_17379_17550[(2)] = inst_16984);

(statearr_17379_17550[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (63))){
var inst_16925 = (state_17197[(11)]);
var inst_17047 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16925);
var inst_17048 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_17047);
var state_17197__$1 = state_17197;
var statearr_17380_17551 = state_17197__$1;
(statearr_17380_17551[(2)] = inst_17048);

(statearr_17380_17551[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (94))){
var inst_17107 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
var statearr_17381_17552 = state_17197__$1;
(statearr_17381_17552[(2)] = inst_17107);

(statearr_17381_17552[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (8))){
var inst_16913 = (state_17197[(16)]);
var state_17197__$1 = state_17197;
var statearr_17382_17553 = state_17197__$1;
(statearr_17382_17553[(2)] = inst_16913);

(statearr_17382_17553[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (49))){
var inst_17029 = (state_17197[(2)]);
var state_17197__$1 = state_17197;
if(cljs.core.truth_(inst_17029)){
var statearr_17383_17554 = state_17197__$1;
(statearr_17383_17554[(1)] = (57));

} else {
var statearr_17384_17555 = state_17197__$1;
(statearr_17384_17555[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17198 === (84))){
var inst_17044 = (state_17197[(12)]);
var state_17197__$1 = state_17197;
var statearr_17385_17556 = state_17197__$1;
(statearr_17385_17556[(2)] = inst_17044);

(statearr_17385_17556[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2749__auto__ = null;
var fluree$db$query$schema$state_machine__2749__auto____0 = (function (){
var statearr_17386 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17386[(0)] = fluree$db$query$schema$state_machine__2749__auto__);

(statearr_17386[(1)] = (1));

return statearr_17386;
});
var fluree$db$query$schema$state_machine__2749__auto____1 = (function (state_17197){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_17197);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e17387){var ex__2752__auto__ = e17387;
var statearr_17388_17557 = state_17197;
(statearr_17388_17557[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_17197[(4)]))){
var statearr_17389_17558 = state_17197;
(statearr_17389_17558[(1)] = cljs.core.first((state_17197[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17559 = state_17197;
state_17197 = G__17559;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2749__auto__ = function(state_17197){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2749__auto____1.call(this,state_17197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2749__auto____0;
fluree$db$query$schema$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2749__auto____1;
return fluree$db$query$schema$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_17390 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_17390[(6)] = c__2771__auto__);

return statearr_17390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__17561 = arguments.length;
switch (G__17561) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_17585){
var state_val_17586 = (state_17585[(1)]);
if((state_val_17586 === (7))){
var state_17585__$1 = state_17585;
var statearr_17587_17607 = state_17585__$1;
(statearr_17587_17607[(2)] = db);

(statearr_17587_17607[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17586 === (1))){
var state_17585__$1 = state_17585;
var statearr_17588_17608 = state_17585__$1;
(statearr_17588_17608[(2)] = null);

(statearr_17588_17608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17586 === (4))){
var inst_17562 = (state_17585[(2)]);
var state_17585__$1 = state_17585;
var statearr_17589_17609 = state_17585__$1;
(statearr_17589_17609[(2)] = inst_17562);

(statearr_17589_17609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17586 === (6))){
var inst_17571 = (state_17585[(7)]);
var inst_17570 = (state_17585[(2)]);
var inst_17571__$1 = fluree.db.util.async.throw_err(inst_17570);
var inst_17572 = cljs.core.empty_QMARK_(inst_17571__$1);
var state_17585__$1 = (function (){var statearr_17590 = state_17585;
(statearr_17590[(7)] = inst_17571__$1);

return statearr_17590;
})();
if(inst_17572){
var statearr_17591_17610 = state_17585__$1;
(statearr_17591_17610[(1)] = (7));

} else {
var statearr_17592_17611 = state_17585__$1;
(statearr_17592_17611[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17586 === (3))){
var inst_17583 = (state_17585[(2)]);
var state_17585__$1 = state_17585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17585__$1,inst_17583);
} else {
if((state_val_17586 === (2))){
var _ = (function (){var statearr_17594 = state_17585;
(statearr_17594[(4)] = cljs.core.cons((5),(state_17585[(4)])));

return statearr_17594;
})();
var inst_17568 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_17585__$1 = state_17585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17585__$1,(6),inst_17568);
} else {
if((state_val_17586 === (9))){
var inst_17580 = (state_17585[(2)]);
var _ = (function (){var statearr_17595 = state_17585;
(statearr_17595[(4)] = cljs.core.rest((state_17585[(4)])));

return statearr_17595;
})();
var state_17585__$1 = state_17585;
var statearr_17596_17612 = state_17585__$1;
(statearr_17596_17612[(2)] = inst_17580);

(statearr_17596_17612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17586 === (5))){
var _ = (function (){var statearr_17597 = state_17585;
(statearr_17597[(4)] = cljs.core.rest((state_17585[(4)])));

return statearr_17597;
})();
var state_17585__$1 = state_17585;
var ex17593 = (state_17585__$1[(2)]);
var statearr_17598_17613 = state_17585__$1;
(statearr_17598_17613[(5)] = ex17593);


if((ex17593 instanceof Error)){
var statearr_17599_17614 = state_17585__$1;
(statearr_17599_17614[(1)] = (4));

(statearr_17599_17614[(5)] = null);

} else {
throw ex17593;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17586 === (10))){
var inst_17577 = (state_17585[(2)]);
var inst_17578 = fluree.db.util.async.throw_err(inst_17577);
var state_17585__$1 = state_17585;
var statearr_17600_17615 = state_17585__$1;
(statearr_17600_17615[(2)] = inst_17578);

(statearr_17600_17615[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17586 === (8))){
var inst_17571 = (state_17585[(7)]);
var inst_17575 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_17571,db,true);
var state_17585__$1 = state_17585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17585__$1,(10),inst_17575);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2749__auto__ = null;
var fluree$db$query$schema$state_machine__2749__auto____0 = (function (){
var statearr_17601 = [null,null,null,null,null,null,null,null];
(statearr_17601[(0)] = fluree$db$query$schema$state_machine__2749__auto__);

(statearr_17601[(1)] = (1));

return statearr_17601;
});
var fluree$db$query$schema$state_machine__2749__auto____1 = (function (state_17585){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_17585);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e17602){var ex__2752__auto__ = e17602;
var statearr_17603_17616 = state_17585;
(statearr_17603_17616[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_17585[(4)]))){
var statearr_17604_17617 = state_17585;
(statearr_17604_17617[(1)] = cljs.core.first((state_17585[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17618 = state_17585;
state_17585 = G__17618;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2749__auto__ = function(state_17585){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2749__auto____1.call(this,state_17585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2749__auto____0;
fluree$db$query$schema$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2749__auto____1;
return fluree$db$query$schema$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_17605 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_17605[(6)] = c__2771__auto__);

return statearr_17605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__17620 = arguments.length;
switch (G__17620) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__17622 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17622,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17622,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17622,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__17625_SHARP_,p2__17626_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17625_SHARP_,p2__17626_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__17627_SHARP_){
var f = p1__17627_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_17693){
var state_val_17694 = (state_17693[(1)]);
if((state_val_17694 === (1))){
var state_17693__$1 = state_17693;
var statearr_17695_17713 = state_17693__$1;
(statearr_17695_17713[(2)] = null);

(statearr_17695_17713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17694 === (2))){
var _ = (function (){var statearr_17696 = state_17693;
(statearr_17696[(4)] = cljs.core.cons((5),(state_17693[(4)])));

return statearr_17696;
})();
var inst_17645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17646 = fluree.db.flake.max_subject_id((1));
var inst_17647 = [inst_17646];
var inst_17648 = (new cljs.core.PersistentVector(null,1,(5),inst_17645,inst_17647,null));
var inst_17649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17650 = [(0)];
var inst_17651 = (new cljs.core.PersistentVector(null,1,(5),inst_17649,inst_17650,null));
var inst_17652 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17648,cljs.core._LT__EQ_,inst_17651);
var state_17693__$1 = state_17693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17693__$1,(6),inst_17652);
} else {
if((state_val_17694 === (3))){
var inst_17691 = (state_17693[(2)]);
var state_17693__$1 = state_17693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17693__$1,inst_17691);
} else {
if((state_val_17694 === (4))){
var inst_17633 = (state_17693[(2)]);
var state_17693__$1 = state_17693;
var statearr_17698_17714 = state_17693__$1;
(statearr_17698_17714[(2)] = inst_17633);

(statearr_17698_17714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17694 === (5))){
var _ = (function (){var statearr_17699 = state_17693;
(statearr_17699[(4)] = cljs.core.rest((state_17693[(4)])));

return statearr_17699;
})();
var state_17693__$1 = state_17693;
var ex17697 = (state_17693__$1[(2)]);
var statearr_17700_17715 = state_17693__$1;
(statearr_17700_17715[(5)] = ex17697);


if((ex17697 instanceof Error)){
var statearr_17701_17716 = state_17693__$1;
(statearr_17701_17716[(1)] = (4));

(statearr_17701_17716[(5)] = null);

} else {
throw ex17697;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17694 === (6))){
var inst_17654 = (state_17693[(2)]);
var inst_17655 = fluree.db.util.async.throw_err(inst_17654);
var inst_17656 = (function (){var schema_flakes = inst_17655;
return (function (p1__17628_SHARP_){
return (p1__17628_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17657 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17656,inst_17655);
var inst_17658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17657,(0),null);
var inst_17659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17657,(1),null);
var inst_17660 = (function (){var schema_flakes = inst_17655;
var vec__17639 = inst_17657;
var collection_flakes = inst_17658;
var predicate_flakes = inst_17659;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17631_SHARP_,p2__17630_SHARP_){
var f = p2__17630_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17631_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_17661 = [(-1),"_tx"];
var inst_17662 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17663 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17664 = cljs.core.PersistentHashMap.fromArrays(inst_17662,inst_17663);
var inst_17665 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17666 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17667 = cljs.core.PersistentHashMap.fromArrays(inst_17665,inst_17666);
var inst_17668 = [inst_17664,inst_17667];
var inst_17669 = cljs.core.PersistentHashMap.fromArrays(inst_17661,inst_17668);
var inst_17670 = (function (){var schema_flakes = inst_17655;
var vec__17639 = inst_17657;
var collection_flakes = inst_17658;
var predicate_flakes = inst_17659;
return (function (p1__17629_SHARP_){
return p1__17629_SHARP_.s;
});
})();
var inst_17671 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17670,inst_17658);
var inst_17672 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17660,inst_17669,inst_17671);
var inst_17674 = (function (){var schema_flakes = inst_17655;
var vec__17639 = inst_17657;
var collection_flakes = inst_17658;
var predicate_flakes = inst_17659;
var coll = inst_17672;
return (function (p__17673,pred_flakes){
var vec__17702 = p__17673;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17702,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17702,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__17705 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__17705.cljs$core$IFn$_invoke$arity$1 ? fexpr__17705.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__17705.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_17675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17676 = cljs.core.PersistentHashMap.EMPTY;
var inst_17677 = cljs.core.PersistentHashSet.EMPTY;
var inst_17678 = [inst_17676,inst_17677];
var inst_17679 = (new cljs.core.PersistentVector(null,2,(5),inst_17675,inst_17678,null));
var inst_17680 = (function (){var schema_flakes = inst_17655;
var vec__17639 = inst_17657;
var collection_flakes = inst_17658;
var predicate_flakes = inst_17659;
var coll = inst_17672;
return (function (p1__17632_SHARP_){
return p1__17632_SHARP_.s;
});
})();
var inst_17681 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17680,inst_17659);
var inst_17682 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17674,inst_17679,inst_17681);
var inst_17683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17682,(0),null);
var inst_17684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17682,(1),null);
var inst_17685 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17686 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17687 = [inst_17686,inst_17672,inst_17683,inst_17684];
var inst_17688 = cljs.core.PersistentHashMap.fromArrays(inst_17685,inst_17687);
var _ = (function (){var statearr_17706 = state_17693;
(statearr_17706[(4)] = cljs.core.rest((state_17693[(4)])));

return statearr_17706;
})();
var state_17693__$1 = state_17693;
var statearr_17707_17717 = state_17693__$1;
(statearr_17707_17717[(2)] = inst_17688);

(statearr_17707_17717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2749__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2749__auto____0 = (function (){
var statearr_17708 = [null,null,null,null,null,null,null];
(statearr_17708[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2749__auto__);

(statearr_17708[(1)] = (1));

return statearr_17708;
});
var fluree$db$query$schema$schema_map_$_state_machine__2749__auto____1 = (function (state_17693){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_17693);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e17709){var ex__2752__auto__ = e17709;
var statearr_17710_17718 = state_17693;
(statearr_17710_17718[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_17693[(4)]))){
var statearr_17711_17719 = state_17693;
(statearr_17711_17719[(1)] = cljs.core.first((state_17693[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17720 = state_17693;
state_17693 = G__17720;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2749__auto__ = function(state_17693){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2749__auto____1.call(this,state_17693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2749__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2749__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_17712 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_17712[(6)] = c__2771__auto__);

return statearr_17712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_17762){
var state_val_17763 = (state_17762[(1)]);
if((state_val_17763 === (7))){
var inst_17745 = (state_17762[(2)]);
var inst_17746 = fluree.db.query.schema.flake__GT_pred_map(inst_17745);
var inst_17747 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17748 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17746,(114));
var inst_17749 = cljs.core.boolean$(inst_17748);
var inst_17750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17746,(110));
var inst_17751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17746,(117));
var inst_17752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_17751);
var inst_17753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17746,(111));
var inst_17754 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17746,(115));
var inst_17755 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17746,(112));
var inst_17756 = [inst_17749,inst_17750,inst_17752,inst_17753,inst_17754,inst_17755];
var inst_17757 = cljs.core.PersistentHashMap.fromArrays(inst_17747,inst_17756);
var _ = (function (){var statearr_17764 = state_17762;
(statearr_17764[(4)] = cljs.core.rest((state_17762[(4)])));

return statearr_17764;
})();
var state_17762__$1 = state_17762;
var statearr_17765_17788 = state_17762__$1;
(statearr_17765_17788[(2)] = inst_17757);

(statearr_17765_17788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (1))){
var state_17762__$1 = state_17762;
var statearr_17766_17789 = state_17762__$1;
(statearr_17766_17789[(2)] = null);

(statearr_17766_17789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (4))){
var inst_17721 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
var statearr_17767_17790 = state_17762__$1;
(statearr_17767_17790[(2)] = inst_17721);

(statearr_17767_17790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (6))){
var _ = (function (){var statearr_17768 = state_17762;
(statearr_17768[(4)] = cljs.core.cons((9),(state_17762[(4)])));

return statearr_17768;
})();
var inst_17733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17735 = ["_setting/id","root"];
var inst_17736 = (new cljs.core.PersistentVector(null,2,(5),inst_17734,inst_17735,null));
var inst_17737 = [inst_17736];
var inst_17738 = (new cljs.core.PersistentVector(null,1,(5),inst_17733,inst_17737,null));
var inst_17739 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17738);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17762__$1,(10),inst_17739);
} else {
if((state_val_17763 === (3))){
var inst_17760 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17762__$1,inst_17760);
} else {
if((state_val_17763 === (2))){
var _ = (function (){var statearr_17771 = state_17762;
(statearr_17771[(4)] = cljs.core.cons((5),(state_17762[(4)])));

return statearr_17771;
})();
var state_17762__$1 = state_17762;
var statearr_17772_17791 = state_17762__$1;
(statearr_17772_17791[(2)] = null);

(statearr_17772_17791[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (9))){
var _ = (function (){var statearr_17773 = state_17762;
(statearr_17773[(4)] = cljs.core.rest((state_17762[(4)])));

return statearr_17773;
})();
var state_17762__$1 = state_17762;
var ex17769 = (state_17762__$1[(2)]);
var statearr_17774_17792 = state_17762__$1;
(statearr_17774_17792[(5)] = ex17769);


var statearr_17775_17793 = state_17762__$1;
(statearr_17775_17793[(1)] = (8));

(statearr_17775_17793[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (5))){
var _ = (function (){var statearr_17776 = state_17762;
(statearr_17776[(4)] = cljs.core.rest((state_17762[(4)])));

return statearr_17776;
})();
var state_17762__$1 = state_17762;
var ex17770 = (state_17762__$1[(2)]);
var statearr_17777_17794 = state_17762__$1;
(statearr_17777_17794[(5)] = ex17770);


if((ex17770 instanceof Error)){
var statearr_17778_17795 = state_17762__$1;
(statearr_17778_17795[(1)] = (4));

(statearr_17778_17795[(5)] = null);

} else {
throw ex17770;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (10))){
var inst_17741 = (state_17762[(2)]);
var inst_17742 = fluree.db.util.async.throw_err(inst_17741);
var _ = (function (){var statearr_17779 = state_17762;
(statearr_17779[(4)] = cljs.core.rest((state_17762[(4)])));

return statearr_17779;
})();
var state_17762__$1 = state_17762;
var statearr_17780_17796 = state_17762__$1;
(statearr_17780_17796[(2)] = inst_17742);

(statearr_17780_17796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (8))){
var inst_17727 = (state_17762[(2)]);
var state_17762__$1 = (function (){var statearr_17781 = state_17762;
(statearr_17781[(7)] = inst_17727);

return statearr_17781;
})();
var statearr_17782_17797 = state_17762__$1;
(statearr_17782_17797[(2)] = null);

(statearr_17782_17797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2749__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2749__auto____0 = (function (){
var statearr_17783 = [null,null,null,null,null,null,null,null];
(statearr_17783[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2749__auto__);

(statearr_17783[(1)] = (1));

return statearr_17783;
});
var fluree$db$query$schema$setting_map_$_state_machine__2749__auto____1 = (function (state_17762){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_17762);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e17784){var ex__2752__auto__ = e17784;
var statearr_17785_17798 = state_17762;
(statearr_17785_17798[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_17762[(4)]))){
var statearr_17786_17799 = state_17762;
(statearr_17786_17799[(1)] = cljs.core.first((state_17762[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17800 = state_17762;
state_17762 = G__17800;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2749__auto__ = function(state_17762){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2749__auto____1.call(this,state_17762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2749__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2749__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_17787 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_17787[(6)] = c__2771__auto__);

return statearr_17787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
