// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_12277){
var state_val_12278 = (state_12277[(1)]);
if((state_val_12278 === (7))){
var inst_12272 = (state_12277[(2)]);
var _ = (function (){var statearr_12279 = state_12277;
(statearr_12279[(4)] = cljs.core.rest((state_12277[(4)])));

return statearr_12279;
})();
var state_12277__$1 = state_12277;
var statearr_12280_12302 = state_12277__$1;
(statearr_12280_12302[(2)] = inst_12272);

(statearr_12280_12302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (1))){
var state_12277__$1 = state_12277;
var statearr_12281_12303 = state_12277__$1;
(statearr_12281_12303[(2)] = null);

(statearr_12281_12303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (4))){
var inst_12234 = (state_12277[(2)]);
var state_12277__$1 = state_12277;
var statearr_12282_12304 = state_12277__$1;
(statearr_12282_12304[(2)] = inst_12234);

(statearr_12282_12304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (6))){
var inst_12259 = (state_12277[(7)]);
var inst_12252 = (state_12277[(8)]);
var inst_12258 = cljs.core.seq(inst_12252);
var inst_12259__$1 = cljs.core.first(inst_12258);
var inst_12260 = cljs.core.next(inst_12258);
var inst_12261 = cljs.core.not(inst_12259__$1);
var state_12277__$1 = (function (){var statearr_12283 = state_12277;
(statearr_12283[(7)] = inst_12259__$1);

(statearr_12283[(9)] = inst_12260);

return statearr_12283;
})();
if(inst_12261){
var statearr_12284_12305 = state_12277__$1;
(statearr_12284_12305[(1)] = (8));

} else {
var statearr_12285_12306 = state_12277__$1;
(statearr_12285_12306[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (3))){
var inst_12275 = (state_12277[(2)]);
var state_12277__$1 = state_12277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12277__$1,inst_12275);
} else {
if((state_val_12278 === (2))){
var _ = (function (){var statearr_12286 = state_12277;
(statearr_12286[(4)] = cljs.core.cons((5),(state_12277[(4)])));

return statearr_12286;
})();
var inst_12247 = chs;
var inst_12248 = cljs.core.seq(inst_12247);
var inst_12249 = cljs.core.first(inst_12248);
var inst_12250 = cljs.core.next(inst_12248);
var inst_12251 = coll;
var inst_12252 = inst_12247;
var inst_12253 = inst_12251;
var state_12277__$1 = (function (){var statearr_12287 = state_12277;
(statearr_12287[(10)] = inst_12253);

(statearr_12287[(11)] = inst_12249);

(statearr_12287[(12)] = inst_12250);

(statearr_12287[(8)] = inst_12252);

return statearr_12287;
})();
var statearr_12288_12307 = state_12277__$1;
(statearr_12288_12307[(2)] = null);

(statearr_12288_12307[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (11))){
var inst_12253 = (state_12277[(10)]);
var inst_12260 = (state_12277[(9)]);
var inst_12265 = (state_12277[(2)]);
var inst_12266 = fluree.db.util.async.throw_err(inst_12265);
var inst_12267 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12253,inst_12266);
var inst_12252 = inst_12260;
var inst_12253__$1 = inst_12267;
var state_12277__$1 = (function (){var statearr_12290 = state_12277;
(statearr_12290[(10)] = inst_12253__$1);

(statearr_12290[(8)] = inst_12252);

return statearr_12290;
})();
var statearr_12291_12308 = state_12277__$1;
(statearr_12291_12308[(2)] = null);

(statearr_12291_12308[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (9))){
var inst_12259 = (state_12277[(7)]);
var state_12277__$1 = state_12277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12277__$1,(11),inst_12259);
} else {
if((state_val_12278 === (5))){
var _ = (function (){var statearr_12292 = state_12277;
(statearr_12292[(4)] = cljs.core.rest((state_12277[(4)])));

return statearr_12292;
})();
var state_12277__$1 = state_12277;
var ex12289 = (state_12277__$1[(2)]);
var statearr_12293_12309 = state_12277__$1;
(statearr_12293_12309[(5)] = ex12289);


var statearr_12294_12310 = state_12277__$1;
(statearr_12294_12310[(1)] = (4));

(statearr_12294_12310[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (10))){
var inst_12270 = (state_12277[(2)]);
var state_12277__$1 = state_12277;
var statearr_12295_12311 = state_12277__$1;
(statearr_12295_12311[(2)] = inst_12270);

(statearr_12295_12311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12278 === (8))){
var inst_12253 = (state_12277[(10)]);
var state_12277__$1 = state_12277;
var statearr_12296_12312 = state_12277__$1;
(statearr_12296_12312[(2)] = inst_12253);

(statearr_12296_12312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_12297 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12297[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto__);

(statearr_12297[(1)] = (1));

return statearr_12297;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto____1 = (function (state_12277){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_12277);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e12298){var ex__2752__auto__ = e12298;
var statearr_12299_12313 = state_12277;
(statearr_12299_12313[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_12277[(4)]))){
var statearr_12300_12314 = state_12277;
(statearr_12300_12314[(1)] = cljs.core.first((state_12277[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12315 = state_12277;
state_12277 = G__12315;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto__ = function(state_12277){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto____1.call(this,state_12277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_12301 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_12301[(6)] = c__2771__auto__);

return statearr_12301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_12341){
var state_val_12342 = (state_12341[(1)]);
if((state_val_12342 === (7))){
var inst_12336 = (state_12341[(2)]);
var _ = (function (){var statearr_12343 = state_12341;
(statearr_12343[(4)] = cljs.core.rest((state_12341[(4)])));

return statearr_12343;
})();
var state_12341__$1 = state_12341;
var statearr_12344_12366 = state_12341__$1;
(statearr_12344_12366[(2)] = inst_12336);

(statearr_12344_12366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (1))){
var state_12341__$1 = state_12341;
var statearr_12345_12367 = state_12341__$1;
(statearr_12345_12367[(2)] = null);

(statearr_12345_12367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (4))){
var inst_12316 = (state_12341[(2)]);
var state_12341__$1 = state_12341;
var statearr_12346_12368 = state_12341__$1;
(statearr_12346_12368[(2)] = inst_12316);

(statearr_12346_12368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (6))){
var state_12341__$1 = state_12341;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12341__$1,(8),chan);
} else {
if((state_val_12342 === (3))){
var inst_12339 = (state_12341[(2)]);
var state_12341__$1 = state_12341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12341__$1,inst_12339);
} else {
if((state_val_12342 === (2))){
var _ = (function (){var statearr_12347 = state_12341;
(statearr_12347[(4)] = cljs.core.cons((5),(state_12341[(4)])));

return statearr_12347;
})();
var inst_12322 = coll;
var inst_12323 = inst_12322;
var state_12341__$1 = (function (){var statearr_12348 = state_12341;
(statearr_12348[(7)] = inst_12323);

return statearr_12348;
})();
var statearr_12349_12369 = state_12341__$1;
(statearr_12349_12369[(2)] = null);

(statearr_12349_12369[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (11))){
var inst_12334 = (state_12341[(2)]);
var state_12341__$1 = state_12341;
var statearr_12351_12370 = state_12341__$1;
(statearr_12351_12370[(2)] = inst_12334);

(statearr_12351_12370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (9))){
var inst_12323 = (state_12341[(7)]);
var state_12341__$1 = state_12341;
var statearr_12352_12371 = state_12341__$1;
(statearr_12352_12371[(2)] = inst_12323);

(statearr_12352_12371[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (5))){
var _ = (function (){var statearr_12353 = state_12341;
(statearr_12353[(4)] = cljs.core.rest((state_12341[(4)])));

return statearr_12353;
})();
var state_12341__$1 = state_12341;
var ex12350 = (state_12341__$1[(2)]);
var statearr_12354_12372 = state_12341__$1;
(statearr_12354_12372[(5)] = ex12350);


var statearr_12355_12373 = state_12341__$1;
(statearr_12355_12373[(1)] = (4));

(statearr_12355_12373[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (10))){
var inst_12323 = (state_12341[(7)]);
var inst_12327 = (state_12341[(8)]);
var inst_12331 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12323,inst_12327);
var inst_12323__$1 = inst_12331;
var state_12341__$1 = (function (){var statearr_12356 = state_12341;
(statearr_12356[(7)] = inst_12323__$1);

return statearr_12356;
})();
var statearr_12357_12374 = state_12341__$1;
(statearr_12357_12374[(2)] = null);

(statearr_12357_12374[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12342 === (8))){
var inst_12327 = (state_12341[(8)]);
var inst_12326 = (state_12341[(2)]);
var inst_12327__$1 = fluree.db.util.async.throw_err(inst_12326);
var inst_12328 = (inst_12327__$1 == null);
var state_12341__$1 = (function (){var statearr_12358 = state_12341;
(statearr_12358[(8)] = inst_12327__$1);

return statearr_12358;
})();
if(cljs.core.truth_(inst_12328)){
var statearr_12359_12375 = state_12341__$1;
(statearr_12359_12375[(1)] = (9));

} else {
var statearr_12360_12376 = state_12341__$1;
(statearr_12360_12376[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_12361 = [null,null,null,null,null,null,null,null,null];
(statearr_12361[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2749__auto__);

(statearr_12361[(1)] = (1));

return statearr_12361;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2749__auto____1 = (function (state_12341){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_12341);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e12362){var ex__2752__auto__ = e12362;
var statearr_12363_12377 = state_12341;
(statearr_12363_12377[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_12341[(4)]))){
var statearr_12364_12378 = state_12341;
(statearr_12364_12378[(1)] = cljs.core.first((state_12341[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12379 = state_12341;
state_12341 = G__12379;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2749__auto__ = function(state_12341){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2749__auto____1.call(this,state_12341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2749__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2749__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_12365 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_12365[(6)] = c__2771__auto__);

return statearr_12365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
