// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__64550 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64550__$1 = cljs.core.__destructure_map(map__64550);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64550__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64550__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__64551 = cljs.core.get_global_hierarchy;
return (fexpr__64551.cljs$core$IFn$_invoke$arity$0 ? fexpr__64551.cljs$core$IFn$_invoke$arity$0() : fexpr__64551.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__64552__delegate = function (conn_id,event,_){
return event;
};
var G__64552 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__64553__i = 0, G__64553__a = new Array(arguments.length -  2);
while (G__64553__i < G__64553__a.length) {G__64553__a[G__64553__i] = arguments[G__64553__i + 2]; ++G__64553__i;}
  _ = new cljs.core.IndexedSeq(G__64553__a,0,null);
} 
return G__64552__delegate.call(this,conn_id,event,_);};
G__64552.cljs$lang$maxFixedArity = 2;
G__64552.cljs$lang$applyTo = (function (arglist__64554){
var conn_id = cljs.core.first(arglist__64554);
arglist__64554 = cljs.core.next(arglist__64554);
var event = cljs.core.first(arglist__64554);
var _ = cljs.core.rest(arglist__64554);
return G__64552__delegate(conn_id,event,_);
});
G__64552.cljs$core$IFn$_invoke$arity$variadic = G__64552__delegate;
return G__64552;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__5045__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64572){
var state_val_64573 = (state_64572[(1)]);
if((state_val_64573 === (1))){
var inst_64555 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_64556 = flureeworker.conn_id__GT_db(conn_id,inst_64555);
var inst_64557 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_64558 = fluree.db.api.query.query(inst_64556,inst_64557);
var state_64572__$1 = state_64572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64572__$1,(2),inst_64558);
} else {
if((state_val_64573 === (2))){
var inst_64560 = (state_64572[(7)]);
var inst_64560__$1 = (state_64572[(2)]);
var inst_64561 = fluree.db.util.core.exception_QMARK_(inst_64560__$1);
var state_64572__$1 = (function (){var statearr_64574 = state_64572;
(statearr_64574[(7)] = inst_64560__$1);

return statearr_64574;
})();
if(inst_64561){
var statearr_64575_64588 = state_64572__$1;
(statearr_64575_64588[(1)] = (3));

} else {
var statearr_64576_64589 = state_64572__$1;
(statearr_64576_64589[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64573 === (3))){
var inst_64560 = (state_64572[(7)]);
var inst_64563 = flureeworker.error_return_map(inst_64560);
var state_64572__$1 = state_64572;
var statearr_64577_64590 = state_64572__$1;
(statearr_64577_64590[(2)] = inst_64563);

(statearr_64577_64590[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64573 === (4))){
var inst_64560 = (state_64572[(7)]);
var inst_64565 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64566 = [inst_64560,"loaded"];
var inst_64567 = cljs.core.PersistentHashMap.fromArrays(inst_64565,inst_64566);
var state_64572__$1 = state_64572;
var statearr_64578_64591 = state_64572__$1;
(statearr_64578_64591[(2)] = inst_64567);

(statearr_64578_64591[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64573 === (5))){
var inst_64569 = (state_64572[(2)]);
var inst_64570 = (function (){var G__64579 = conn_id;
var G__64580 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__64581 = id;
var G__64582 = inst_64569;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64579,G__64580,G__64581,G__64582) : flureeworker.worker_action.call(null,G__64579,G__64580,G__64581,G__64582));
})();
var state_64572__$1 = state_64572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64572__$1,inst_64570);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2749__auto__ = null;
var flureeworker$process_query_$_state_machine__2749__auto____0 = (function (){
var statearr_64583 = [null,null,null,null,null,null,null,null];
(statearr_64583[(0)] = flureeworker$process_query_$_state_machine__2749__auto__);

(statearr_64583[(1)] = (1));

return statearr_64583;
});
var flureeworker$process_query_$_state_machine__2749__auto____1 = (function (state_64572){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64572);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64584){var ex__2752__auto__ = e64584;
var statearr_64585_64592 = state_64572;
(statearr_64585_64592[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64572[(4)]))){
var statearr_64586_64593 = state_64572;
(statearr_64586_64593[(1)] = cljs.core.first((state_64572[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64594 = state_64572;
state_64572 = G__64594;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2749__auto__ = function(state_64572){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2749__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2749__auto____1.call(this,state_64572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2749__auto____0;
flureeworker$process_query_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2749__auto____1;
return flureeworker$process_query_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64587 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64587[(6)] = c__2771__auto__);

return statearr_64587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__64595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64595__$1 = cljs.core.__destructure_map(map__64595);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64595__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64595__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__64596 = cljs.core.seq(query_ids);
var chunk__64597 = null;
var count__64598 = (0);
var i__64599 = (0);
while(true){
if((i__64599 < count__64598)){
var id = chunk__64597.cljs$core$IIndexed$_nth$arity$2(null,i__64599);
flureeworker.process_query(conn_id,id,opts);


var G__64600 = seq__64596;
var G__64601 = chunk__64597;
var G__64602 = count__64598;
var G__64603 = (i__64599 + (1));
seq__64596 = G__64600;
chunk__64597 = G__64601;
count__64598 = G__64602;
i__64599 = G__64603;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__64596);
if(temp__5804__auto__){
var seq__64596__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64596__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__64596__$1);
var G__64604 = cljs.core.chunk_rest(seq__64596__$1);
var G__64605 = c__5567__auto__;
var G__64606 = cljs.core.count(c__5567__auto__);
var G__64607 = (0);
seq__64596 = G__64604;
chunk__64597 = G__64605;
count__64598 = G__64606;
i__64599 = G__64607;
continue;
} else {
var id = cljs.core.first(seq__64596__$1);
flureeworker.process_query(conn_id,id,opts);


var G__64608 = cljs.core.next(seq__64596__$1);
var G__64609 = null;
var G__64610 = (0);
var G__64611 = (0);
seq__64596 = G__64608;
chunk__64597 = G__64609;
count__64598 = G__64610;
i__64599 = G__64611;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__64612 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64612,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64612,(1),null);
var cb = (function (header,data){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64620){
var state_val_64621 = (state_64620[(1)]);
if((state_val_64621 === (1))){
var inst_64615 = cljs.core.async.timeout((100));
var state_64620__$1 = state_64620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64620__$1,(2),inst_64615);
} else {
if((state_val_64621 === (2))){
var inst_64617 = (state_64620[(2)]);
var inst_64618 = flureeworker.process_all_queries(conn_id);
var state_64620__$1 = (function (){var statearr_64622 = state_64620;
(statearr_64622[(7)] = inst_64617);

return statearr_64622;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64620__$1,inst_64618);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2749__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2749__auto____0 = (function (){
var statearr_64623 = [null,null,null,null,null,null,null,null];
(statearr_64623[(0)] = flureeworker$ledger_listener_$_state_machine__2749__auto__);

(statearr_64623[(1)] = (1));

return statearr_64623;
});
var flureeworker$ledger_listener_$_state_machine__2749__auto____1 = (function (state_64620){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64620);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64624){var ex__2752__auto__ = e64624;
var statearr_64625_64628 = state_64620;
(statearr_64625_64628[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64620[(4)]))){
var statearr_64626_64629 = state_64620;
(statearr_64626_64629[(1)] = cljs.core.first((state_64620[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64630 = state_64620;
state_64620 = G__64630;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2749__auto__ = function(state_64620){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2749__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2749__auto____1.call(this,state_64620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2749__auto____0;
flureeworker$ledger_listener_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2749__auto____1;
return flureeworker$ledger_listener_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64627 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64627[(6)] = c__2771__auto__);

return statearr_64627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__64631 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64631,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64631,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__64634 = config;
var map__64634__$1 = cljs.core.__destructure_map(map__64634);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64634__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64634__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64634__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64634__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64634__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64634__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__5045__auto__ = queries;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64635 = conn_data;
var map__64635__$1 = cljs.core.__destructure_map(map__64635);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64635__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64635__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64635__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__64636 = config;
var map__64636__$1 = cljs.core.__destructure_map(map__64636);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64636__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64636__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64636__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64636__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64642){
var state_val_64643 = (state_64642[(1)]);
if((state_val_64643 === (1))){
var inst_64637 = cljs.core.async.timeout((100));
var state_64642__$1 = state_64642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64642__$1,(2),inst_64637);
} else {
if((state_val_64643 === (2))){
var inst_64639 = (state_64642[(2)]);
var inst_64640 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_64642__$1 = (function (){var statearr_64644 = state_64642;
(statearr_64644[(7)] = inst_64639);

return statearr_64644;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64642__$1,inst_64640);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2749__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2749__auto____0 = (function (){
var statearr_64645 = [null,null,null,null,null,null,null,null];
(statearr_64645[(0)] = flureeworker$connect_STAR__$_state_machine__2749__auto__);

(statearr_64645[(1)] = (1));

return statearr_64645;
});
var flureeworker$connect_STAR__$_state_machine__2749__auto____1 = (function (state_64642){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64642);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64646){var ex__2752__auto__ = e64646;
var statearr_64647_64658 = state_64642;
(statearr_64647_64658[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64642[(4)]))){
var statearr_64648_64659 = state_64642;
(statearr_64648_64659[(1)] = cljs.core.first((state_64642[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64660 = state_64642;
state_64642 = G__64660;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2749__auto__ = function(state_64642){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2749__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2749__auto____1.call(this,state_64642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2749__auto____0;
flureeworker$connect_STAR__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2749__auto____1;
return flureeworker$connect_STAR__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64649 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64649[(6)] = c__2771__auto__);

return statearr_64649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__64650_64661 = conn_id;
var G__64651_64662 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64652_64663 = ref;
var G__64653_64664 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64650_64661,G__64651_64662,G__64652_64663,G__64653_64664) : flureeworker.worker_action.call(null,G__64650_64661,G__64651_64662,G__64652_64663,G__64653_64664));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__64654 = conn_id;
var G__64655 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64656 = ref;
var G__64657 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64654,G__64655,G__64656,G__64657) : flureeworker.worker_action.call(null,G__64654,G__64655,G__64656,G__64657));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__64666 = arguments.length;
switch (G__64666) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64667 = conn_data;
var map__64667__$1 = cljs.core.__destructure_map(map__64667);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64667__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64667__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64667__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64667__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__64674 = conn_id;
var G__64675 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64676 = ref;
var G__64677 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64674,G__64675,G__64676,G__64677) : flureeworker.worker_action.call(null,G__64674,G__64675,G__64676,G__64677));
}catch (e64669){var e = e64669;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64670 = conn_id;
var G__64671 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64672 = ref;
var G__64673 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64670,G__64671,G__64672,G__64673) : flureeworker.worker_action.call(null,G__64670,G__64671,G__64672,G__64673));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e64678){var e = e64678;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64679 = conn_id;
var G__64680 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64681 = ref;
var G__64682 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64679,G__64680,G__64681,G__64682) : flureeworker.worker_action.call(null,G__64679,G__64680,G__64681,G__64682));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__64683 = config_STAR_;
var map__64683__$1 = cljs.core.__destructure_map(map__64683);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64683__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64683__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64683__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64683__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64689){
var state_val_64690 = (state_64689[(1)]);
if((state_val_64690 === (1))){
var inst_64684 = cljs.core.async.timeout((100));
var state_64689__$1 = state_64689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64689__$1,(2),inst_64684);
} else {
if((state_val_64690 === (2))){
var inst_64686 = (state_64689[(2)]);
var inst_64687 = flureeworker.connect_STAR_(id,ref);
var state_64689__$1 = (function (){var statearr_64691 = state_64689;
(statearr_64691[(7)] = inst_64686);

return statearr_64691;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64689__$1,inst_64687);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2749__auto__ = null;
var flureeworker$connect_p_$_state_machine__2749__auto____0 = (function (){
var statearr_64692 = [null,null,null,null,null,null,null,null];
(statearr_64692[(0)] = flureeworker$connect_p_$_state_machine__2749__auto__);

(statearr_64692[(1)] = (1));

return statearr_64692;
});
var flureeworker$connect_p_$_state_machine__2749__auto____1 = (function (state_64689){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64689);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64693){var ex__2752__auto__ = e64693;
var statearr_64694_64705 = state_64689;
(statearr_64694_64705[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64689[(4)]))){
var statearr_64695_64706 = state_64689;
(statearr_64695_64706[(1)] = cljs.core.first((state_64689[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64707 = state_64689;
state_64689 = G__64707;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2749__auto__ = function(state_64689){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2749__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2749__auto____1.call(this,state_64689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2749__auto____0;
flureeworker$connect_p_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2749__auto____1;
return flureeworker$connect_p_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64696 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64696[(6)] = c__2771__auto__);

return statearr_64696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__64697 = id;
var G__64698 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64699 = ref;
var G__64700 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64697,G__64698,G__64699,G__64700) : flureeworker.worker_action.call(null,G__64697,G__64698,G__64699,G__64700));
})).catch((function (error){
var G__64701 = id;
var G__64702 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64703 = ref;
var G__64704 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64701,G__64702,G__64703,G__64704) : flureeworker.worker_action.call(null,G__64701,G__64702,G__64703,G__64704));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__5774__auto__ = [];
var len__5768__auto___64775 = arguments.length;
var i__5769__auto___64776 = (0);
while(true){
if((i__5769__auto___64776 < len__5768__auto___64775)){
args__5774__auto__.push((arguments[i__5769__auto___64776]));

var G__64777 = (i__5769__auto___64776 + (1));
i__5769__auto___64776 = G__64777;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((4) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5775__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__64713){
var vec__64714 = p__64713;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64714,(0),null);
var map__64717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64717__$1 = cljs.core.__destructure_map(map__64717);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64717__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64717__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64717__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64718 = conn_id;
var G__64719 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64720 = ref;
var G__64721 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64718,G__64719,G__64720,G__64721) : flureeworker.worker_action.call(null,G__64718,G__64719,G__64720,G__64721));
})());
var auth = null;
var c__2771__auto___64778 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64742){
var state_val_64743 = (state_64742[(1)]);
if((state_val_64743 === (1))){
var state_64742__$1 = state_64742;
var statearr_64744_64779 = state_64742__$1;
(statearr_64744_64779[(2)] = null);

(statearr_64744_64779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64743 === (2))){
var ___$1 = (function (){var statearr_64745 = state_64742;
(statearr_64745[(4)] = cljs.core.cons((5),(state_64742[(4)])));

return statearr_64745;
})();
var inst_64733 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_64734 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64746 = conn_id;
var G__64747 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64748 = ref;
var G__64749 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64746,G__64747,G__64748,G__64749) : flureeworker.worker_action.call(null,G__64746,G__64747,G__64748,G__64749));
});
})();
var inst_64735 = inst_64733.then(inst_64734);
var inst_64736 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64750){var ___$2 = e64750;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64751 = conn_id;
var G__64752 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64753 = ref;
var G__64754 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64751,G__64752,G__64753,G__64754) : flureeworker.worker_action.call(null,G__64751,G__64752,G__64753,G__64754));
} else {
var G__64755 = conn_id;
var G__64756 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64757 = ref;
var G__64758 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64755,G__64756,G__64757,G__64758) : flureeworker.worker_action.call(null,G__64755,G__64756,G__64757,G__64758));

}
});
})();
var inst_64737 = inst_64735.catch(inst_64736);
var ___$2 = (function (){var statearr_64759 = state_64742;
(statearr_64759[(4)] = cljs.core.rest((state_64742[(4)])));

return statearr_64759;
})();
var state_64742__$1 = state_64742;
var statearr_64760_64780 = state_64742__$1;
(statearr_64760_64780[(2)] = inst_64737);

(statearr_64760_64780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64743 === (3))){
var inst_64740 = (state_64742[(2)]);
var state_64742__$1 = state_64742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64742__$1,inst_64740);
} else {
if((state_val_64743 === (4))){
var inst_64722 = (state_64742[(2)]);
var inst_64723 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64724 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64722);
var inst_64725 = [(400),inst_64724];
var inst_64726 = cljs.core.PersistentHashMap.fromArrays(inst_64723,inst_64725);
var inst_64727 = (function (){var G__64762 = conn_id;
var G__64763 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64764 = ref;
var G__64765 = inst_64726;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64762,G__64763,G__64764,G__64765) : flureeworker.worker_action.call(null,G__64762,G__64763,G__64764,G__64765));
})();
var state_64742__$1 = state_64742;
var statearr_64766_64781 = state_64742__$1;
(statearr_64766_64781[(2)] = inst_64727);

(statearr_64766_64781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64743 === (5))){
var ___$1 = (function (){var statearr_64767 = state_64742;
(statearr_64767[(4)] = cljs.core.rest((state_64742[(4)])));

return statearr_64767;
})();
var state_64742__$1 = state_64742;
var ex64761 = (state_64742__$1[(2)]);
var statearr_64768_64782 = state_64742__$1;
(statearr_64768_64782[(5)] = ex64761);


var statearr_64769_64783 = state_64742__$1;
(statearr_64769_64783[(1)] = (4));

(statearr_64769_64783[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2749__auto__ = null;
var flureeworker$state_machine__2749__auto____0 = (function (){
var statearr_64770 = [null,null,null,null,null,null,null];
(statearr_64770[(0)] = flureeworker$state_machine__2749__auto__);

(statearr_64770[(1)] = (1));

return statearr_64770;
});
var flureeworker$state_machine__2749__auto____1 = (function (state_64742){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64742);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64771){var ex__2752__auto__ = e64771;
var statearr_64772_64784 = state_64742;
(statearr_64772_64784[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64742[(4)]))){
var statearr_64773_64785 = state_64742;
(statearr_64773_64785[(1)] = cljs.core.first((state_64742[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64786 = state_64742;
state_64742 = G__64786;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
flureeworker$state_machine__2749__auto__ = function(state_64742){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2749__auto____0.call(this);
case 1:
return flureeworker$state_machine__2749__auto____1.call(this,state_64742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2749__auto____0;
flureeworker$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2749__auto____1;
return flureeworker$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64774 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64774[(6)] = c__2771__auto___64778);

return statearr_64774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq64708){
var G__64709 = cljs.core.first(seq64708);
var seq64708__$1 = cljs.core.next(seq64708);
var G__64710 = cljs.core.first(seq64708__$1);
var seq64708__$2 = cljs.core.next(seq64708__$1);
var G__64711 = cljs.core.first(seq64708__$2);
var seq64708__$3 = cljs.core.next(seq64708__$2);
var G__64712 = cljs.core.first(seq64708__$3);
var seq64708__$4 = cljs.core.next(seq64708__$3);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64709,G__64710,G__64711,G__64712,seq64708__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__64787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64787__$1 = cljs.core.__destructure_map(map__64787);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64787__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64787__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64789 = conn_id;
var G__64790 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64791 = ref;
var G__64792 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64789,G__64790,G__64791,G__64792) : flureeworker.worker_action.call(null,G__64789,G__64790,G__64791,G__64792));
})());
var map__64788 = map_data;
var map__64788__$1 = cljs.core.__destructure_map(map__64788);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64788__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64788__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64788__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2771__auto___64846 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64813){
var state_val_64814 = (state_64813[(1)]);
if((state_val_64814 === (1))){
var state_64813__$1 = state_64813;
var statearr_64815_64847 = state_64813__$1;
(statearr_64815_64847[(2)] = null);

(statearr_64815_64847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64814 === (2))){
var ___$1 = (function (){var statearr_64816 = state_64813;
(statearr_64816[(4)] = cljs.core.cons((5),(state_64813[(4)])));

return statearr_64816;
})();
var inst_64804 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_64805 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64817 = conn_id;
var G__64818 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64819 = ref;
var G__64820 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64817,G__64818,G__64819,G__64820) : flureeworker.worker_action.call(null,G__64817,G__64818,G__64819,G__64820));
});
})();
var inst_64806 = inst_64804.then(inst_64805);
var inst_64807 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64821){var ___$2 = e64821;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64822 = conn_id;
var G__64823 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64824 = ref;
var G__64825 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64822,G__64823,G__64824,G__64825) : flureeworker.worker_action.call(null,G__64822,G__64823,G__64824,G__64825));
} else {
var G__64826 = conn_id;
var G__64827 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64828 = ref;
var G__64829 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64826,G__64827,G__64828,G__64829) : flureeworker.worker_action.call(null,G__64826,G__64827,G__64828,G__64829));

}
});
})();
var inst_64808 = inst_64806.catch(inst_64807);
var ___$2 = (function (){var statearr_64830 = state_64813;
(statearr_64830[(4)] = cljs.core.rest((state_64813[(4)])));

return statearr_64830;
})();
var state_64813__$1 = state_64813;
var statearr_64831_64848 = state_64813__$1;
(statearr_64831_64848[(2)] = inst_64808);

(statearr_64831_64848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64814 === (3))){
var inst_64811 = (state_64813[(2)]);
var state_64813__$1 = state_64813;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64813__$1,inst_64811);
} else {
if((state_val_64814 === (4))){
var inst_64793 = (state_64813[(2)]);
var inst_64794 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64795 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64793);
var inst_64796 = [(400),inst_64795];
var inst_64797 = cljs.core.PersistentHashMap.fromArrays(inst_64794,inst_64796);
var inst_64798 = (function (){var G__64833 = conn_id;
var G__64834 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64835 = ref;
var G__64836 = inst_64797;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64833,G__64834,G__64835,G__64836) : flureeworker.worker_action.call(null,G__64833,G__64834,G__64835,G__64836));
})();
var state_64813__$1 = state_64813;
var statearr_64837_64849 = state_64813__$1;
(statearr_64837_64849[(2)] = inst_64798);

(statearr_64837_64849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64814 === (5))){
var ___$1 = (function (){var statearr_64838 = state_64813;
(statearr_64838[(4)] = cljs.core.rest((state_64813[(4)])));

return statearr_64838;
})();
var state_64813__$1 = state_64813;
var ex64832 = (state_64813__$1[(2)]);
var statearr_64839_64850 = state_64813__$1;
(statearr_64839_64850[(5)] = ex64832);


var statearr_64840_64851 = state_64813__$1;
(statearr_64840_64851[(1)] = (4));

(statearr_64840_64851[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2749__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2749__auto____0 = (function (){
var statearr_64841 = [null,null,null,null,null,null,null];
(statearr_64841[(0)] = flureeworker$pw_generate_$_state_machine__2749__auto__);

(statearr_64841[(1)] = (1));

return statearr_64841;
});
var flureeworker$pw_generate_$_state_machine__2749__auto____1 = (function (state_64813){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64813);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64842){var ex__2752__auto__ = e64842;
var statearr_64843_64852 = state_64813;
(statearr_64843_64852[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64813[(4)]))){
var statearr_64844_64853 = state_64813;
(statearr_64844_64853[(1)] = cljs.core.first((state_64813[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64854 = state_64813;
state_64813 = G__64854;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2749__auto__ = function(state_64813){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2749__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2749__auto____1.call(this,state_64813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2749__auto____0;
flureeworker$pw_generate_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2749__auto____1;
return flureeworker$pw_generate_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64845 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64845[(6)] = c__2771__auto___64846);

return statearr_64845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64855_SHARP_){
return (js_array[p1__64855_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e64856){var e = e64856;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___64857 = cljs.core.not(self.document);
if(temp__5804__auto___64857){
var worker_QMARK__64858 = temp__5804__auto___64857;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__64859_64861 = null;
var G__64860_64862 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__64859_64861,G__64860_64862) : flureeworker.worker_action.call(null,G__64859_64861,G__64860_64862));
