// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__39631(s__39632){
return (new cljs.core.LazySeq(null,(function (){
var s__39632__$1 = s__39632;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39632__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39637 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39637,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39637,(1),null);
var iterys__5518__auto__ = ((function (s__39632__$1,vec__39637,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__39631_$_iter__39633(s__39634){
return (new cljs.core.LazySeq(null,((function (s__39632__$1,vec__39637,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__39634__$1 = s__39634;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39634__$1);
if(temp__5804__auto____$1){
var s__39634__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39634__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__39634__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__39636 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__39635 = (0);
while(true){
if((i__39635 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__39635);
cljs.core.chunk_append(b__39636,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__39690 = (i__39635 + (1));
i__39635 = G__39690;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39636),tailrecursion$priority_map$iter__39631_$_iter__39633(cljs.core.chunk_rest(s__39634__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39636),null);
}
} else {
var item = cljs.core.first(s__39634__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__39631_$_iter__39633(cljs.core.rest(s__39634__$2)));
}
} else {
return null;
}
break;
}
});})(s__39632__$1,vec__39637,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__39632__$1,vec__39637,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__39631(cljs.core.rest(s__39632__$1)));
} else {
var G__39691 = cljs.core.rest(s__39632__$1);
s__39632__$1 = G__39691;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__39640(s__39641){
return (new cljs.core.LazySeq(null,(function (){
var s__39641__$1 = s__39641;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39641__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39646 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39646,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39646,(1),null);
var iterys__5518__auto__ = ((function (s__39641__$1,vec__39646,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__39640_$_iter__39642(s__39643){
return (new cljs.core.LazySeq(null,((function (s__39641__$1,vec__39646,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__39643__$1 = s__39643;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39643__$1);
if(temp__5804__auto____$1){
var s__39643__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39643__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__39643__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__39645 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__39644 = (0);
while(true){
if((i__39644 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__39644);
cljs.core.chunk_append(b__39645,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__39692 = (i__39644 + (1));
i__39644 = G__39692;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39645),tailrecursion$priority_map$iter__39640_$_iter__39642(cljs.core.chunk_rest(s__39643__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39645),null);
}
} else {
var item = cljs.core.first(s__39643__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__39640_$_iter__39642(cljs.core.rest(s__39643__$2)));
}
} else {
return null;
}
break;
}
});})(s__39641__$1,vec__39646,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__39641__$1,vec__39646,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__39640(cljs.core.rest(s__39641__$1)));
} else {
var G__39693 = cljs.core.rest(s__39641__$1);
s__39641__$1 = G__39693;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__39649 = item;
var G__39650 = new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517);
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__39649,G__39650) : self__.item__GT_priority.call(null,G__39649,G__39650));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5802__auto__)){
var current_priority = temp__5802__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__39651(s__39652){
return (new cljs.core.LazySeq(null,(function (){
var s__39652__$1 = s__39652;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39652__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39657 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39657,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39657,(1),null);
var iterys__5518__auto__ = ((function (s__39652__$1,vec__39657,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__39651_$_iter__39653(s__39654){
return (new cljs.core.LazySeq(null,((function (s__39652__$1,vec__39657,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__39654__$1 = s__39654;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39654__$1);
if(temp__5804__auto____$1){
var s__39654__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39654__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__39654__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__39656 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__39655 = (0);
while(true){
if((i__39655 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__39655);
cljs.core.chunk_append(b__39656,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__39694 = (i__39655 + (1));
i__39655 = G__39694;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39656),tailrecursion$priority_map$iter__39651_$_iter__39653(cljs.core.chunk_rest(s__39654__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39656),null);
}
} else {
var item = cljs.core.first(s__39654__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__39651_$_iter__39653(cljs.core.rest(s__39654__$2)));
}
} else {
return null;
}
break;
}
});})(s__39652__$1,vec__39657,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__39652__$1,vec__39657,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__39651(cljs.core.rest(s__39652__$1)));
} else {
var G__39695 = cljs.core.rest(s__39652__$1);
s__39652__$1 = G__39695;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__39660(s__39661){
return (new cljs.core.LazySeq(null,(function (){
var s__39661__$1 = s__39661;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39661__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39666 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39666,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39666,(1),null);
var iterys__5518__auto__ = ((function (s__39661__$1,vec__39666,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__39660_$_iter__39662(s__39663){
return (new cljs.core.LazySeq(null,((function (s__39661__$1,vec__39666,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__39663__$1 = s__39663;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39663__$1);
if(temp__5804__auto____$1){
var s__39663__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39663__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__39663__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__39665 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__39664 = (0);
while(true){
if((i__39664 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__39664);
cljs.core.chunk_append(b__39665,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__39696 = (i__39664 + (1));
i__39664 = G__39696;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39665),tailrecursion$priority_map$iter__39660_$_iter__39662(cljs.core.chunk_rest(s__39663__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39665),null);
}
} else {
var item = cljs.core.first(s__39663__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__39660_$_iter__39662(cljs.core.rest(s__39663__$2)));
}
} else {
return null;
}
break;
}
});})(s__39661__$1,vec__39666,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__39661__$1,vec__39666,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__39660(cljs.core.rest(s__39661__$1)));
} else {
var G__39697 = cljs.core.rest(s__39661__$1);
s__39661__$1 = G__39697;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__39698 = null;
var G__39698__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__39698__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__39698 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__39698__2.call(this,self__,item);
case 3:
return G__39698__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__39698.cljs$core$IFn$_invoke$arity$2 = G__39698__2;
G__39698.cljs$core$IFn$_invoke$arity$3 = G__39698__3;
return G__39698;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args39630){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat((((args39630.length > (20)))?(function (){var G__39669 = args39630.slice((0),(20));
G__39669.push(args39630.slice((20)));

return G__39669;
})():args39630)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__39670 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__39670.cljs$core$IFn$_invoke$arity$1 ? fexpr__39670.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__39670.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__39671(s__39672){
return (new cljs.core.LazySeq(null,(function (){
var s__39672__$1 = s__39672;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39672__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39677 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39677,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39677,(1),null);
var iterys__5518__auto__ = ((function (s__39672__$1,vec__39677,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__39671_$_iter__39673(s__39674){
return (new cljs.core.LazySeq(null,((function (s__39672__$1,vec__39677,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__39674__$1 = s__39674;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39674__$1);
if(temp__5804__auto____$1){
var s__39674__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39674__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__39674__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__39676 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__39675 = (0);
while(true){
if((i__39675 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__39675);
cljs.core.chunk_append(b__39676,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__39699 = (i__39675 + (1));
i__39675 = G__39699;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39676),tailrecursion$priority_map$iter__39671_$_iter__39673(cljs.core.chunk_rest(s__39674__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39676),null);
}
} else {
var item = cljs.core.first(s__39674__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__39671_$_iter__39673(cljs.core.rest(s__39674__$2)));
}
} else {
return null;
}
break;
}
});})(s__39672__$1,vec__39677,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__39672__$1,vec__39677,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__39671(cljs.core.rest(s__39672__$1)));
} else {
var G__39700 = cljs.core.rest(s__39672__$1);
s__39672__$1 = G__39700;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__39680(s__39681){
return (new cljs.core.LazySeq(null,(function (){
var s__39681__$1 = s__39681;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39681__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39686 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39686,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39686,(1),null);
var iterys__5518__auto__ = ((function (s__39681__$1,vec__39686,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__39680_$_iter__39682(s__39683){
return (new cljs.core.LazySeq(null,((function (s__39681__$1,vec__39686,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__39683__$1 = s__39683;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39683__$1);
if(temp__5804__auto____$1){
var s__39683__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39683__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__39683__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__39685 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__39684 = (0);
while(true){
if((i__39684 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__39684);
cljs.core.chunk_append(b__39685,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__39701 = (i__39684 + (1));
i__39684 = G__39701;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39685),tailrecursion$priority_map$iter__39680_$_iter__39682(cljs.core.chunk_rest(s__39683__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39685),null);
}
} else {
var item = cljs.core.first(s__39683__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__39680_$_iter__39682(cljs.core.rest(s__39683__$2)));
}
} else {
return null;
}
break;
}
});})(s__39681__$1,vec__39686,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__39681__$1,vec__39686,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__39680(cljs.core.rest(s__39681__$1)));
} else {
var G__39702 = cljs.core.rest(s__39681__$1);
s__39681__$1 = G__39702;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__39689 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__39689) : self__.keyfn.call(null,G__39689));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__39704 = arguments.length;
switch (G__39704) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39707 = arguments.length;
var i__5769__auto___39708 = (0);
while(true){
if((i__5769__auto___39708 < len__5768__auto___39707)){
args__5774__auto__.push((arguments[i__5769__auto___39708]));

var G__39709 = (i__5769__auto___39708 + (1));
i__5769__auto___39708 = G__39709;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__39710 = cljs.core.nnext(in$);
var G__39711 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39710;
out = G__39711;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq39706){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39706));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39714 = arguments.length;
var i__5769__auto___39715 = (0);
while(true){
if((i__5769__auto___39715 < len__5768__auto___39714)){
args__5774__auto__.push((arguments[i__5769__auto___39715]));

var G__39716 = (i__5769__auto___39715 + (1));
i__5769__auto___39715 = G__39716;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__39717 = cljs.core.nnext(in$);
var G__39718 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39717;
out = G__39718;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq39712){
var G__39713 = cljs.core.first(seq39712);
var seq39712__$1 = cljs.core.next(seq39712);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39713,seq39712__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39721 = arguments.length;
var i__5769__auto___39722 = (0);
while(true){
if((i__5769__auto___39722 < len__5768__auto___39721)){
args__5774__auto__.push((arguments[i__5769__auto___39722]));

var G__39723 = (i__5769__auto___39722 + (1));
i__5769__auto___39722 = G__39723;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__39724 = cljs.core.nnext(in$);
var G__39725 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39724;
out = G__39725;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq39719){
var G__39720 = cljs.core.first(seq39719);
var seq39719__$1 = cljs.core.next(seq39719);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39720,seq39719__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39729 = arguments.length;
var i__5769__auto___39730 = (0);
while(true){
if((i__5769__auto___39730 < len__5768__auto___39729)){
args__5774__auto__.push((arguments[i__5769__auto___39730]));

var G__39731 = (i__5769__auto___39730 + (1));
i__5769__auto___39730 = G__39731;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__39732 = cljs.core.nnext(in$);
var G__39733 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39732;
out = G__39733;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq39726){
var G__39727 = cljs.core.first(seq39726);
var seq39726__$1 = cljs.core.next(seq39726);
var G__39728 = cljs.core.first(seq39726__$1);
var seq39726__$2 = cljs.core.next(seq39726__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39727,G__39728,seq39726__$2);
}));

