// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__65941 = arguments.length;
switch (G__65941) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___65980 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65962){
var state_val_65963 = (state_65962[(1)]);
if((state_val_65963 === (1))){
var state_65962__$1 = state_65962;
var statearr_65964_65981 = state_65962__$1;
(statearr_65964_65981[(2)] = null);

(statearr_65964_65981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65963 === (2))){
var _ = (function (){var statearr_65965 = state_65962;
(statearr_65965[(4)] = cljs.core.cons((5),(state_65962[(4)])));

return statearr_65965;
})();
var inst_65948 = fluree.db.session.db(conn,ledger,null);
var state_65962__$1 = state_65962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65962__$1,(7),inst_65948);
} else {
if((state_val_65963 === (3))){
var inst_65958 = (state_65962[(2)]);
var inst_65959 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65958);
var inst_65960 = cljs.core.async.close_BANG_(pc);
var state_65962__$1 = (function (){var statearr_65967 = state_65962;
(statearr_65967[(7)] = inst_65959);

return statearr_65967;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65962__$1,inst_65960);
} else {
if((state_val_65963 === (4))){
var inst_65942 = (state_65962[(2)]);
var state_65962__$1 = state_65962;
var statearr_65968_65982 = state_65962__$1;
(statearr_65968_65982[(2)] = inst_65942);

(statearr_65968_65982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65963 === (5))){
var _ = (function (){var statearr_65969 = state_65962;
(statearr_65969[(4)] = cljs.core.rest((state_65962[(4)])));

return statearr_65969;
})();
var state_65962__$1 = state_65962;
var ex65966 = (state_65962__$1[(2)]);
var statearr_65970_65983 = state_65962__$1;
(statearr_65970_65983[(5)] = ex65966);


var statearr_65971_65984 = state_65962__$1;
(statearr_65971_65984[(1)] = (4));

(statearr_65971_65984[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65963 === (6))){
var inst_65954 = (state_65962[(2)]);
var inst_65955 = fluree.db.util.async.throw_err(inst_65954);
var _ = (function (){var statearr_65972 = state_65962;
(statearr_65972[(4)] = cljs.core.rest((state_65962[(4)])));

return statearr_65972;
})();
var state_65962__$1 = state_65962;
var statearr_65973_65985 = state_65962__$1;
(statearr_65973_65985[(2)] = inst_65955);

(statearr_65973_65985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65963 === (7))){
var inst_65950 = (state_65962[(2)]);
var inst_65951 = fluree.db.util.async.throw_err(inst_65950);
var inst_65952 = fluree.db.time_travel.as_of_block(inst_65951,block);
var state_65962__$1 = state_65962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65962__$1,(6),inst_65952);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_65974 = [null,null,null,null,null,null,null,null];
(statearr_65974[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_65974[(1)] = (1));

return statearr_65974;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_65962){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65962);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65975){var ex__2730__auto__ = e65975;
var statearr_65976_65986 = state_65962;
(statearr_65976_65986[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65962[(4)]))){
var statearr_65977_65987 = state_65962;
(statearr_65977_65987[(1)] = cljs.core.first((state_65962[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65988 = state_65962;
state_65962 = G__65988;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_65962){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_65962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65978 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65978[(6)] = c__2749__auto___65980);

return statearr_65978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66029){
var state_val_66030 = (state_66029[(1)]);
if((state_val_66030 === (7))){
var inst_65998 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66029__$1 = state_66029;
if(inst_65998){
var statearr_66031_66062 = state_66029__$1;
(statearr_66031_66062[(1)] = (9));

} else {
var statearr_66032_66063 = state_66029__$1;
(statearr_66032_66063[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (1))){
var state_66029__$1 = state_66029;
var statearr_66033_66064 = state_66029__$1;
(statearr_66033_66064[(2)] = null);

(statearr_66033_66064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (4))){
var inst_65989 = (state_66029[(2)]);
var state_66029__$1 = state_66029;
var statearr_66034_66065 = state_66029__$1;
(statearr_66034_66065[(2)] = inst_65989);

(statearr_66034_66065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (15))){
var inst_66006 = (state_66029[(7)]);
var inst_66005 = (state_66029[(2)]);
var inst_66006__$1 = fluree.db.util.async.throw_err(inst_66005);
var state_66029__$1 = (function (){var statearr_66035 = state_66029;
(statearr_66035[(7)] = inst_66006__$1);

return statearr_66035;
})();
if(cljs.core.truth_(inst_66006__$1)){
var statearr_66036_66066 = state_66029__$1;
(statearr_66036_66066[(1)] = (16));

} else {
var statearr_66037_66067 = state_66029__$1;
(statearr_66037_66067[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (13))){
var state_66029__$1 = state_66029;
var statearr_66038_66068 = state_66029__$1;
(statearr_66038_66068[(2)] = null);

(statearr_66038_66068[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (6))){
var state_66029__$1 = state_66029;
var statearr_66039_66069 = state_66029__$1;
(statearr_66039_66069[(2)] = db);

(statearr_66039_66069[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (17))){
var inst_66010 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66011 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66012 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66013 = cljs.core.PersistentHashMap.fromArrays(inst_66011,inst_66012);
var inst_66014 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66010,inst_66013);
var inst_66015 = (function(){throw inst_66014})();
var state_66029__$1 = state_66029;
var statearr_66040_66070 = state_66029__$1;
(statearr_66040_66070[(2)] = inst_66015);

(statearr_66040_66070[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (3))){
var inst_66027 = (state_66029[(2)]);
var state_66029__$1 = state_66029;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66029__$1,inst_66027);
} else {
if((state_val_66030 === (12))){
var inst_66003 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66029__$1 = state_66029;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66029__$1,(15),inst_66003);
} else {
if((state_val_66030 === (2))){
var _ = (function (){var statearr_66041 = state_66029;
(statearr_66041[(4)] = cljs.core.cons((5),(state_66029[(4)])));

return statearr_66041;
})();
var inst_65995 = cljs.core.not(auth);
var state_66029__$1 = state_66029;
if(inst_65995){
var statearr_66042_66071 = state_66029__$1;
(statearr_66042_66071[(1)] = (6));

} else {
var statearr_66043_66072 = state_66029__$1;
(statearr_66043_66072[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (11))){
var inst_66022 = (state_66029[(2)]);
var state_66029__$1 = state_66029;
var statearr_66045_66073 = state_66029__$1;
(statearr_66045_66073[(2)] = inst_66022);

(statearr_66045_66073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (9))){
var inst_66000 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_66029__$1 = state_66029;
var statearr_66046_66074 = state_66029__$1;
(statearr_66046_66074[(2)] = inst_66000);

(statearr_66046_66074[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (5))){
var _ = (function (){var statearr_66047 = state_66029;
(statearr_66047[(4)] = cljs.core.rest((state_66029[(4)])));

return statearr_66047;
})();
var state_66029__$1 = state_66029;
var ex66044 = (state_66029__$1[(2)]);
var statearr_66048_66075 = state_66029__$1;
(statearr_66048_66075[(5)] = ex66044);


if((ex66044 instanceof Error)){
var statearr_66049_66076 = state_66029__$1;
(statearr_66049_66076[(1)] = (4));

(statearr_66049_66076[(5)] = null);

} else {
throw ex66044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (14))){
var inst_66020 = (state_66029[(2)]);
var state_66029__$1 = state_66029;
var statearr_66050_66077 = state_66029__$1;
(statearr_66050_66077[(2)] = inst_66020);

(statearr_66050_66077[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (16))){
var inst_66006 = (state_66029[(7)]);
var inst_66008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66006);
var state_66029__$1 = state_66029;
var statearr_66051_66078 = state_66029__$1;
(statearr_66051_66078[(2)] = inst_66008);

(statearr_66051_66078[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (10))){
var state_66029__$1 = state_66029;
var statearr_66052_66079 = state_66029__$1;
(statearr_66052_66079[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (18))){
var inst_66017 = (state_66029[(2)]);
var state_66029__$1 = state_66029;
var statearr_66054_66080 = state_66029__$1;
(statearr_66054_66080[(2)] = inst_66017);

(statearr_66054_66080[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66030 === (8))){
var inst_66024 = (state_66029[(2)]);
var _ = (function (){var statearr_66055 = state_66029;
(statearr_66055[(4)] = cljs.core.rest((state_66029[(4)])));

return statearr_66055;
})();
var state_66029__$1 = state_66029;
var statearr_66056_66081 = state_66029__$1;
(statearr_66056_66081[(2)] = inst_66024);

(statearr_66056_66081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_66057 = [null,null,null,null,null,null,null,null];
(statearr_66057[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_66057[(1)] = (1));

return statearr_66057;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_66029){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66029);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66058){var ex__2730__auto__ = e66058;
var statearr_66059_66082 = state_66029;
(statearr_66059_66082[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66029[(4)]))){
var statearr_66060_66083 = state_66029;
(statearr_66060_66083[(1)] = cljs.core.first((state_66029[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66084 = state_66029;
state_66029 = G__66084;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_66029){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_66029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66061 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66061[(6)] = c__2749__auto__);

return statearr_66061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66148){
var state_val_66149 = (state_66148[(1)]);
if((state_val_66149 === (7))){
var inst_66094 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66148__$1 = state_66148;
if(inst_66094){
var statearr_66150_66199 = state_66148__$1;
(statearr_66150_66199[(1)] = (9));

} else {
var statearr_66151_66200 = state_66148__$1;
(statearr_66151_66200[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (20))){
var inst_66118 = (state_66148[(7)]);
var state_66148__$1 = state_66148;
if(cljs.core.truth_(inst_66118)){
var statearr_66152_66201 = state_66148__$1;
(statearr_66152_66201[(1)] = (22));

} else {
var statearr_66153_66202 = state_66148__$1;
(statearr_66153_66202[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (27))){
var state_66148__$1 = state_66148;
var statearr_66154_66203 = state_66148__$1;
(statearr_66154_66203[(2)] = null);

(statearr_66154_66203[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (1))){
var state_66148__$1 = state_66148;
var statearr_66155_66204 = state_66148__$1;
(statearr_66155_66204[(2)] = null);

(statearr_66155_66204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (24))){
var inst_66132 = (state_66148[(2)]);
var state_66148__$1 = state_66148;
var statearr_66156_66205 = state_66148__$1;
(statearr_66156_66205[(2)] = inst_66132);

(statearr_66156_66205[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (4))){
var inst_66085 = (state_66148[(2)]);
var state_66148__$1 = state_66148;
var statearr_66157_66206 = state_66148__$1;
(statearr_66157_66206[(2)] = inst_66085);

(statearr_66157_66206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (15))){
var inst_66101 = (state_66148[(8)]);
var inst_66100 = (state_66148[(2)]);
var inst_66101__$1 = fluree.db.util.async.throw_err(inst_66100);
var state_66148__$1 = (function (){var statearr_66158 = state_66148;
(statearr_66158[(8)] = inst_66101__$1);

return statearr_66158;
})();
if(cljs.core.truth_(inst_66101__$1)){
var statearr_66159_66207 = state_66148__$1;
(statearr_66159_66207[(1)] = (16));

} else {
var statearr_66160_66208 = state_66148__$1;
(statearr_66160_66208[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (21))){
var inst_66134 = (state_66148[(9)]);
var inst_66134__$1 = (state_66148[(2)]);
var state_66148__$1 = (function (){var statearr_66161 = state_66148;
(statearr_66161[(9)] = inst_66134__$1);

return statearr_66161;
})();
if(cljs.core.truth_(inst_66134__$1)){
var statearr_66162_66209 = state_66148__$1;
(statearr_66162_66209[(1)] = (29));

} else {
var statearr_66163_66210 = state_66148__$1;
(statearr_66163_66210[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (31))){
var inst_66134 = (state_66148[(9)]);
var inst_66118 = (state_66148[(7)]);
var inst_66142 = (state_66148[(2)]);
var inst_66143 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66118,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_66134,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_66142], 0));
var _ = (function (){var statearr_66164 = state_66148;
(statearr_66164[(4)] = cljs.core.rest((state_66148[(4)])));

return statearr_66164;
})();
var state_66148__$1 = state_66148;
var statearr_66165_66211 = state_66148__$1;
(statearr_66165_66211[(2)] = inst_66143);

(statearr_66165_66211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (32))){
var inst_66138 = (state_66148[(2)]);
var inst_66139 = fluree.db.util.async.throw_err(inst_66138);
var state_66148__$1 = state_66148;
var statearr_66166_66212 = state_66148__$1;
(statearr_66166_66212[(2)] = inst_66139);

(statearr_66166_66212[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (13))){
var state_66148__$1 = state_66148;
var statearr_66167_66213 = state_66148__$1;
(statearr_66167_66213[(2)] = null);

(statearr_66167_66213[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (22))){
var inst_66118 = (state_66148[(7)]);
var inst_66122 = fluree.db.auth.roles(db,inst_66118);
var state_66148__$1 = state_66148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66148__$1,(25),inst_66122);
} else {
if((state_val_66149 === (29))){
var inst_66134 = (state_66148[(9)]);
var inst_66136 = fluree.db.permissions.permission_map(db,inst_66134,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66148__$1 = state_66148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66148__$1,(32),inst_66136);
} else {
if((state_val_66149 === (6))){
var state_66148__$1 = state_66148;
var statearr_66168_66214 = state_66148__$1;
(statearr_66168_66214[(2)] = null);

(statearr_66168_66214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (28))){
var inst_66130 = (state_66148[(2)]);
var state_66148__$1 = state_66148;
var statearr_66169_66215 = state_66148__$1;
(statearr_66169_66215[(2)] = inst_66130);

(statearr_66169_66215[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (25))){
var inst_66124 = (state_66148[(2)]);
var inst_66125 = fluree.db.util.async.throw_err(inst_66124);
var state_66148__$1 = state_66148;
var statearr_66170_66216 = state_66148__$1;
(statearr_66170_66216[(2)] = inst_66125);

(statearr_66170_66216[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (17))){
var inst_66104 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66105 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66106 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66107 = cljs.core.PersistentHashMap.fromArrays(inst_66105,inst_66106);
var inst_66108 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66104,inst_66107);
var inst_66109 = (function(){throw inst_66108})();
var state_66148__$1 = state_66148;
var statearr_66171_66217 = state_66148__$1;
(statearr_66171_66217[(2)] = inst_66109);

(statearr_66171_66217[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (3))){
var inst_66146 = (state_66148[(2)]);
var state_66148__$1 = state_66148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66148__$1,inst_66146);
} else {
if((state_val_66149 === (12))){
var inst_66098 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66148__$1 = state_66148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66148__$1,(15),inst_66098);
} else {
if((state_val_66149 === (2))){
var _ = (function (){var statearr_66172 = state_66148;
(statearr_66172[(4)] = cljs.core.cons((5),(state_66148[(4)])));

return statearr_66172;
})();
var inst_66091 = (auth == null);
var state_66148__$1 = state_66148;
if(cljs.core.truth_(inst_66091)){
var statearr_66173_66218 = state_66148__$1;
(statearr_66173_66218[(1)] = (6));

} else {
var statearr_66174_66219 = state_66148__$1;
(statearr_66174_66219[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (23))){
var state_66148__$1 = state_66148;
var statearr_66175_66220 = state_66148__$1;
(statearr_66175_66220[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (19))){
var state_66148__$1 = state_66148;
var statearr_66177_66221 = state_66148__$1;
(statearr_66177_66221[(2)] = roles);

(statearr_66177_66221[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (11))){
var inst_66116 = (state_66148[(2)]);
var state_66148__$1 = state_66148;
var statearr_66179_66222 = state_66148__$1;
(statearr_66179_66222[(2)] = inst_66116);

(statearr_66179_66222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (9))){
var state_66148__$1 = state_66148;
var statearr_66180_66223 = state_66148__$1;
(statearr_66180_66223[(2)] = (0));

(statearr_66180_66223[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (5))){
var _ = (function (){var statearr_66181 = state_66148;
(statearr_66181[(4)] = cljs.core.rest((state_66148[(4)])));

return statearr_66181;
})();
var state_66148__$1 = state_66148;
var ex66178 = (state_66148__$1[(2)]);
var statearr_66182_66224 = state_66148__$1;
(statearr_66182_66224[(5)] = ex66178);


if((ex66178 instanceof Error)){
var statearr_66183_66225 = state_66148__$1;
(statearr_66183_66225[(1)] = (4));

(statearr_66183_66225[(5)] = null);

} else {
throw ex66178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (14))){
var inst_66114 = (state_66148[(2)]);
var state_66148__$1 = state_66148;
var statearr_66184_66226 = state_66148__$1;
(statearr_66184_66226[(2)] = inst_66114);

(statearr_66184_66226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (26))){
var state_66148__$1 = state_66148;
var statearr_66185_66227 = state_66148__$1;
(statearr_66185_66227[(2)] = null);

(statearr_66185_66227[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (16))){
var inst_66101 = (state_66148[(8)]);
var state_66148__$1 = state_66148;
var statearr_66186_66228 = state_66148__$1;
(statearr_66186_66228[(2)] = inst_66101);

(statearr_66186_66228[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (30))){
var state_66148__$1 = state_66148;
var statearr_66187_66229 = state_66148__$1;
(statearr_66187_66229[(2)] = null);

(statearr_66187_66229[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (10))){
var state_66148__$1 = state_66148;
if(cljs.core.truth_(auth)){
var statearr_66188_66230 = state_66148__$1;
(statearr_66188_66230[(1)] = (12));

} else {
var statearr_66189_66231 = state_66148__$1;
(statearr_66189_66231[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (18))){
var inst_66111 = (state_66148[(2)]);
var state_66148__$1 = state_66148;
var statearr_66190_66232 = state_66148__$1;
(statearr_66190_66232[(2)] = inst_66111);

(statearr_66190_66232[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66149 === (8))){
var inst_66118 = (state_66148[(2)]);
var state_66148__$1 = (function (){var statearr_66191 = state_66148;
(statearr_66191[(7)] = inst_66118);

return statearr_66191;
})();
if(cljs.core.truth_(roles)){
var statearr_66192_66233 = state_66148__$1;
(statearr_66192_66233[(1)] = (19));

} else {
var statearr_66193_66234 = state_66148__$1;
(statearr_66193_66234[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_66194 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66194[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_66194[(1)] = (1));

return statearr_66194;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_66148){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66148);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66195){var ex__2730__auto__ = e66195;
var statearr_66196_66235 = state_66148;
(statearr_66196_66235[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66148[(4)]))){
var statearr_66197_66236 = state_66148;
(statearr_66197_66236[(1)] = cljs.core.first((state_66148[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66237 = state_66148;
state_66148 = G__66237;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_66148){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_66148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66198 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66198[(6)] = c__2749__auto__);

return statearr_66198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__66238 = db;
var map__66238__$1 = cljs.core.__destructure_map(map__66238);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66238__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66238__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66238__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66245){
var state_val_66246 = (state_66245[(1)]);
if((state_val_66246 === (1))){
var inst_66239 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66240 = fluree.db.session.db(conn,inst_66239,null);
var state_66245__$1 = state_66245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66245__$1,(2),inst_66240);
} else {
if((state_val_66246 === (2))){
var inst_66242 = (state_66245[(2)]);
var inst_66243 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66242);
var state_66245__$1 = state_66245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66245__$1,inst_66243);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_66247 = [null,null,null,null,null,null,null];
(statearr_66247[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_66247[(1)] = (1));

return statearr_66247;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_66245){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66245);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66248){var ex__2730__auto__ = e66248;
var statearr_66249_66276 = state_66245;
(statearr_66249_66276[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66245[(4)]))){
var statearr_66250_66277 = state_66245;
(statearr_66250_66277[(1)] = cljs.core.first((state_66245[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66278 = state_66245;
state_66245 = G__66278;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_66245){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_66245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66251 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66251[(6)] = c__2749__auto__);

return statearr_66251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66264){
var state_val_66265 = (state_66264[(1)]);
if((state_val_66265 === (1))){
var inst_66252 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66253 = fluree.db.session.db(conn,inst_66252,null);
var state_66264__$1 = state_66264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66264__$1,(2),inst_66253);
} else {
if((state_val_66265 === (2))){
var inst_66255 = (state_66264[(7)]);
var inst_66255__$1 = (state_66264[(2)]);
var inst_66256 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_66255__$1);
var inst_66257 = newer_block_QMARK_(inst_66256);
var state_66264__$1 = (function (){var statearr_66266 = state_66264;
(statearr_66266[(7)] = inst_66255__$1);

return statearr_66266;
})();
if(inst_66257){
var statearr_66267_66279 = state_66264__$1;
(statearr_66267_66279[(1)] = (3));

} else {
var statearr_66268_66280 = state_66264__$1;
(statearr_66268_66280[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66265 === (3))){
var inst_66255 = (state_66264[(7)]);
var inst_66259 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66255);
var state_66264__$1 = state_66264;
var statearr_66269_66281 = state_66264__$1;
(statearr_66269_66281[(2)] = inst_66259);

(statearr_66269_66281[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66265 === (4))){
var state_66264__$1 = state_66264;
var statearr_66270_66282 = state_66264__$1;
(statearr_66270_66282[(2)] = null);

(statearr_66270_66282[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66265 === (5))){
var inst_66262 = (state_66264[(2)]);
var state_66264__$1 = state_66264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66264__$1,inst_66262);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_66271 = [null,null,null,null,null,null,null,null];
(statearr_66271[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_66271[(1)] = (1));

return statearr_66271;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_66264){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66264);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66272){var ex__2730__auto__ = e66272;
var statearr_66273_66283 = state_66264;
(statearr_66273_66283[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66264[(4)]))){
var statearr_66274_66284 = state_66264;
(statearr_66274_66284[(1)] = cljs.core.first((state_66264[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66285 = state_66264;
state_66264 = G__66285;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_66264){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_66264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66275 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66275[(6)] = c__2749__auto__);

return statearr_66275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__66286 = db;
var map__66286__$1 = cljs.core.__destructure_map(map__66286);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66286__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66286__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66286__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___66362 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66336){
var state_val_66337 = (state_66336[(1)]);
if((state_val_66337 === (7))){
var inst_66302 = (state_66336[(7)]);
var inst_66313 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66302,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_66336__$1 = state_66336;
if(inst_66313){
var statearr_66338_66363 = state_66336__$1;
(statearr_66338_66363[(1)] = (9));

} else {
var statearr_66339_66364 = state_66336__$1;
(statearr_66339_66364[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (1))){
var inst_66295 = (state_66336[(8)]);
var inst_66287 = (state_66336[(9)]);
var inst_66287__$1 = cljs.core.async.timeout(timeout);
var inst_66295__$1 = res_port;
var inst_66296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66297 = [inst_66287__$1,inst_66295__$1];
var inst_66298 = (new cljs.core.PersistentVector(null,2,(5),inst_66296,inst_66297,null));
var state_66336__$1 = (function (){var statearr_66340 = state_66336;
(statearr_66340[(8)] = inst_66295__$1);

(statearr_66340[(9)] = inst_66287__$1);

return statearr_66340;
})();
return cljs.core.async.ioc_alts_BANG_(state_66336__$1,(2),inst_66298);
} else {
if((state_val_66337 === (4))){
var inst_66295 = (state_66336[(8)]);
var inst_66302 = (state_66336[(7)]);
var inst_66306 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66302,inst_66295);
var state_66336__$1 = state_66336;
if(inst_66306){
var statearr_66341_66365 = state_66336__$1;
(statearr_66341_66365[(1)] = (6));

} else {
var statearr_66342_66366 = state_66336__$1;
(statearr_66342_66366[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (13))){
var inst_66321 = (state_66336[(10)]);
var inst_66332 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66321);
var state_66336__$1 = state_66336;
var statearr_66343_66367 = state_66336__$1;
(statearr_66343_66367[(2)] = inst_66332);

(statearr_66343_66367[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (6))){
var inst_66300 = (state_66336[(11)]);
var inst_66311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66300,(0),null);
var state_66336__$1 = state_66336;
var statearr_66344_66368 = state_66336__$1;
(statearr_66344_66368[(2)] = inst_66311);

(statearr_66344_66368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (3))){
var state_66336__$1 = state_66336;
var statearr_66345_66369 = state_66336__$1;
(statearr_66345_66369[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_66345_66369[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (12))){
var inst_66325 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_66326 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66327 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_66328 = cljs.core.PersistentHashMap.fromArrays(inst_66326,inst_66327);
var inst_66329 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66325,inst_66328);
var inst_66330 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66329);
var state_66336__$1 = state_66336;
var statearr_66346_66370 = state_66336__$1;
(statearr_66346_66370[(2)] = inst_66330);

(statearr_66346_66370[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (2))){
var inst_66287 = (state_66336[(9)]);
var inst_66300 = (state_66336[(11)]);
var inst_66302 = (state_66336[(7)]);
var inst_66300__$1 = (state_66336[(2)]);
var inst_66301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66300__$1,(0),null);
var inst_66302__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66300__$1,(1),null);
var inst_66303 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66302__$1,inst_66287);
var state_66336__$1 = (function (){var statearr_66347 = state_66336;
(statearr_66347[(12)] = inst_66301);

(statearr_66347[(11)] = inst_66300__$1);

(statearr_66347[(7)] = inst_66302__$1);

return statearr_66347;
})();
if(inst_66303){
var statearr_66348_66371 = state_66336__$1;
(statearr_66348_66371[(1)] = (3));

} else {
var statearr_66349_66372 = state_66336__$1;
(statearr_66349_66372[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (11))){
var inst_66317 = (state_66336[(2)]);
var state_66336__$1 = state_66336;
var statearr_66350_66373 = state_66336__$1;
(statearr_66350_66373[(2)] = inst_66317);

(statearr_66350_66373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (9))){
var inst_66301 = (state_66336[(12)]);
var state_66336__$1 = state_66336;
var statearr_66351_66374 = state_66336__$1;
(statearr_66351_66374[(2)] = inst_66301);

(statearr_66351_66374[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (5))){
var inst_66321 = (state_66336[(10)]);
var inst_66321__$1 = (state_66336[(2)]);
var inst_66322 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_66323 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_66321__$1);
var state_66336__$1 = (function (){var statearr_66352 = state_66336;
(statearr_66352[(13)] = inst_66322);

(statearr_66352[(10)] = inst_66321__$1);

return statearr_66352;
})();
if(inst_66323){
var statearr_66353_66375 = state_66336__$1;
(statearr_66353_66375[(1)] = (12));

} else {
var statearr_66354_66376 = state_66336__$1;
(statearr_66354_66376[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (14))){
var inst_66334 = (state_66336[(2)]);
var state_66336__$1 = state_66336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66336__$1,inst_66334);
} else {
if((state_val_66337 === (10))){
var state_66336__$1 = state_66336;
var statearr_66355_66377 = state_66336__$1;
(statearr_66355_66377[(2)] = null);

(statearr_66355_66377[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66337 === (8))){
var inst_66319 = (state_66336[(2)]);
var state_66336__$1 = state_66336;
var statearr_66356_66378 = state_66336__$1;
(statearr_66356_66378[(2)] = inst_66319);

(statearr_66356_66378[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_66357 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66357[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_66357[(1)] = (1));

return statearr_66357;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_66336){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66336);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66358){var ex__2730__auto__ = e66358;
var statearr_66359_66379 = state_66336;
(statearr_66359_66379[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66336[(4)]))){
var statearr_66360_66380 = state_66336;
(statearr_66360_66380[(1)] = cljs.core.first((state_66336[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66381 = state_66336;
state_66336 = G__66381;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_66336){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_66336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66361 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66361[(6)] = c__2749__auto___66362);

return statearr_66361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__66383 = arguments.length;
switch (G__66383) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__66384){
var map__66385 = p__66384;
var map__66385__$1 = cljs.core.__destructure_map(map__66385);
var opts = map__66385__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66385__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66385__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66385__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66385__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66385__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___66474 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66436){
var state_val_66437 = (state_66436[(1)]);
if((state_val_66437 === (7))){
var inst_66398 = (state_66436[(7)]);
var inst_66400 = fluree.db.api.ledger.syncTo_db(inst_66398,syncTo,syncTimeout);
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66436__$1,(10),inst_66400);
} else {
if((state_val_66437 === (20))){
var inst_66422 = (state_66436[(8)]);
var state_66436__$1 = state_66436;
var statearr_66438_66475 = state_66436__$1;
(statearr_66438_66475[(2)] = inst_66422);

(statearr_66438_66475[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (1))){
var state_66436__$1 = state_66436;
var statearr_66439_66476 = state_66436__$1;
(statearr_66439_66476[(2)] = null);

(statearr_66439_66476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (4))){
var inst_66386 = (state_66436[(2)]);
var inst_66387 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66386);
var inst_66388 = cljs.core.async.close_BANG_(pc);
var state_66436__$1 = (function (){var statearr_66440 = state_66436;
(statearr_66440[(9)] = inst_66387);

return statearr_66440;
})();
var statearr_66441_66477 = state_66436__$1;
(statearr_66441_66477[(2)] = inst_66388);

(statearr_66441_66477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (15))){
var inst_66414 = (state_66436[(10)]);
var inst_66416 = fluree.db.api.ledger.add_db_permissions(inst_66414,auth,roles);
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66436__$1,(18),inst_66416);
} else {
if((state_val_66437 === (21))){
var inst_66430 = (state_66436[(2)]);
var inst_66431 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66430);
var _ = (function (){var statearr_66442 = state_66436;
(statearr_66442[(4)] = cljs.core.rest((state_66436[(4)])));

return statearr_66442;
})();
var state_66436__$1 = state_66436;
var statearr_66443_66478 = state_66436__$1;
(statearr_66443_66478[(2)] = inst_66431);

(statearr_66443_66478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (13))){
var inst_66414 = (state_66436[(2)]);
var state_66436__$1 = (function (){var statearr_66444 = state_66436;
(statearr_66444[(10)] = inst_66414);

return statearr_66444;
})();
if(cljs.core.truth_(roles)){
var statearr_66445_66479 = state_66436__$1;
(statearr_66445_66479[(1)] = (15));

} else {
var statearr_66446_66480 = state_66436__$1;
(statearr_66446_66480[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (22))){
var inst_66426 = (state_66436[(2)]);
var inst_66427 = fluree.db.util.async.throw_err(inst_66426);
var state_66436__$1 = state_66436;
var statearr_66447_66481 = state_66436__$1;
(statearr_66447_66481[(2)] = inst_66427);

(statearr_66447_66481[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (6))){
var inst_66397 = (state_66436[(2)]);
var inst_66398 = fluree.db.util.async.throw_err(inst_66397);
var state_66436__$1 = (function (){var statearr_66448 = state_66436;
(statearr_66448[(7)] = inst_66398);

return statearr_66448;
})();
if(cljs.core.truth_(syncTo)){
var statearr_66449_66482 = state_66436__$1;
(statearr_66449_66482[(1)] = (7));

} else {
var statearr_66450_66483 = state_66436__$1;
(statearr_66450_66483[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (17))){
var inst_66422 = (state_66436[(2)]);
var state_66436__$1 = (function (){var statearr_66451 = state_66436;
(statearr_66451[(8)] = inst_66422);

return statearr_66451;
})();
if(cljs.core.truth_(auth)){
var statearr_66452_66484 = state_66436__$1;
(statearr_66452_66484[(1)] = (19));

} else {
var statearr_66453_66485 = state_66436__$1;
(statearr_66453_66485[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (3))){
var inst_66434 = (state_66436[(2)]);
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66436__$1,inst_66434);
} else {
if((state_val_66437 === (12))){
var inst_66406 = (state_66436[(11)]);
var state_66436__$1 = state_66436;
var statearr_66454_66486 = state_66436__$1;
(statearr_66454_66486[(2)] = inst_66406);

(statearr_66454_66486[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (2))){
var _ = (function (){var statearr_66455 = state_66436;
(statearr_66455[(4)] = cljs.core.cons((5),(state_66436[(4)])));

return statearr_66455;
})();
var inst_66395 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66436__$1,(6),inst_66395);
} else {
if((state_val_66437 === (19))){
var inst_66422 = (state_66436[(8)]);
var inst_66424 = fluree.db.api.ledger.add_db_permissions(inst_66422,auth,roles);
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66436__$1,(22),inst_66424);
} else {
if((state_val_66437 === (11))){
var inst_66406 = (state_66436[(11)]);
var inst_66408 = fluree.db.time_travel.as_of_block(inst_66406,block);
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66436__$1,(14),inst_66408);
} else {
if((state_val_66437 === (9))){
var inst_66406 = (state_66436[(2)]);
var state_66436__$1 = (function (){var statearr_66457 = state_66436;
(statearr_66457[(11)] = inst_66406);

return statearr_66457;
})();
if(cljs.core.truth_(block)){
var statearr_66458_66487 = state_66436__$1;
(statearr_66458_66487[(1)] = (11));

} else {
var statearr_66459_66488 = state_66436__$1;
(statearr_66459_66488[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (5))){
var _ = (function (){var statearr_66460 = state_66436;
(statearr_66460[(4)] = cljs.core.rest((state_66436[(4)])));

return statearr_66460;
})();
var state_66436__$1 = state_66436;
var ex66456 = (state_66436__$1[(2)]);
var statearr_66461_66489 = state_66436__$1;
(statearr_66461_66489[(5)] = ex66456);


var statearr_66462_66490 = state_66436__$1;
(statearr_66462_66490[(1)] = (4));

(statearr_66462_66490[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (14))){
var inst_66410 = (state_66436[(2)]);
var inst_66411 = fluree.db.util.async.throw_err(inst_66410);
var state_66436__$1 = state_66436;
var statearr_66463_66491 = state_66436__$1;
(statearr_66463_66491[(2)] = inst_66411);

(statearr_66463_66491[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (16))){
var inst_66414 = (state_66436[(10)]);
var state_66436__$1 = state_66436;
var statearr_66464_66492 = state_66436__$1;
(statearr_66464_66492[(2)] = inst_66414);

(statearr_66464_66492[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (10))){
var inst_66402 = (state_66436[(2)]);
var inst_66403 = fluree.db.util.async.throw_err(inst_66402);
var state_66436__$1 = state_66436;
var statearr_66465_66493 = state_66436__$1;
(statearr_66465_66493[(2)] = inst_66403);

(statearr_66465_66493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (18))){
var inst_66418 = (state_66436[(2)]);
var inst_66419 = fluree.db.util.async.throw_err(inst_66418);
var state_66436__$1 = state_66436;
var statearr_66466_66494 = state_66436__$1;
(statearr_66466_66494[(2)] = inst_66419);

(statearr_66466_66494[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (8))){
var inst_66398 = (state_66436[(7)]);
var state_66436__$1 = state_66436;
var statearr_66467_66495 = state_66436__$1;
(statearr_66467_66495[(2)] = inst_66398);

(statearr_66467_66495[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_66468 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66468[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_66468[(1)] = (1));

return statearr_66468;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_66436){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66436);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66469){var ex__2730__auto__ = e66469;
var statearr_66470_66496 = state_66436;
(statearr_66470_66496[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66436[(4)]))){
var statearr_66471_66497 = state_66436;
(statearr_66471_66497[(1)] = cljs.core.first((state_66436[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66498 = state_66436;
state_66436 = G__66498;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_66436){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_66436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66472 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66472[(6)] = c__2749__auto___66474);

return statearr_66472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

