// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63450 = arguments.length;
switch (G__63450) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63492){
var state_val_63493 = (state_63492[(1)]);
if((state_val_63493 === (7))){
var inst_63462 = typeof user === 'string';
var state_63492__$1 = state_63492;
if(cljs.core.truth_(inst_63462)){
var statearr_63494_63523 = state_63492__$1;
(statearr_63494_63523[(1)] = (9));

} else {
var statearr_63495_63524 = state_63492__$1;
(statearr_63495_63524[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (1))){
var state_63492__$1 = state_63492;
var statearr_63496_63525 = state_63492__$1;
(statearr_63496_63525[(2)] = null);

(statearr_63496_63525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (4))){
var inst_63451 = (state_63492[(2)]);
var inst_63452 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63451], 0));
var inst_63453 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63451) : reject.call(null,inst_63451));
var state_63492__$1 = (function (){var statearr_63497 = state_63492;
(statearr_63497[(7)] = inst_63452);

return statearr_63497;
})();
var statearr_63498_63526 = state_63492__$1;
(statearr_63498_63526[(2)] = inst_63453);

(statearr_63498_63526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (15))){
var inst_63481 = (state_63492[(2)]);
var inst_63482 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63481);
var inst_63483 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63484 = cljs.core.constantly(inst_63482);
var inst_63485 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63483,inst_63484);
var inst_63486 = fluree.db.connection.add_token(conn,inst_63482);
var inst_63487 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_63481) : resolve.call(null,inst_63481));
var _ = (function (){var statearr_63499 = state_63492;
(statearr_63499[(4)] = cljs.core.rest((state_63492[(4)])));

return statearr_63499;
})();
var state_63492__$1 = (function (){var statearr_63500 = state_63492;
(statearr_63500[(8)] = inst_63486);

(statearr_63500[(9)] = inst_63485);

return statearr_63500;
})();
var statearr_63501_63527 = state_63492__$1;
(statearr_63501_63527[(2)] = inst_63487);

(statearr_63501_63527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (13))){
var state_63492__$1 = state_63492;
var statearr_63502_63528 = state_63492__$1;
(statearr_63502_63528[(2)] = null);

(statearr_63502_63528[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (6))){
var state_63492__$1 = state_63492;
var statearr_63503_63529 = state_63492__$1;
(statearr_63503_63529[(2)] = user);

(statearr_63503_63529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (3))){
var inst_63490 = (state_63492[(2)]);
var state_63492__$1 = state_63492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63492__$1,inst_63490);
} else {
if((state_val_63493 === (12))){
var state_63492__$1 = state_63492;
var statearr_63504_63530 = state_63492__$1;
(statearr_63504_63530[(2)] = user);

(statearr_63504_63530[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (2))){
var _ = (function (){var statearr_63505 = state_63492;
(statearr_63505[(4)] = cljs.core.cons((5),(state_63492[(4)])));

return statearr_63505;
})();
var inst_63459 = typeof user === 'number';
var state_63492__$1 = state_63492;
if(cljs.core.truth_(inst_63459)){
var statearr_63506_63531 = state_63492__$1;
(statearr_63506_63531[(1)] = (6));

} else {
var statearr_63507_63532 = state_63492__$1;
(statearr_63507_63532[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (11))){
var inst_63473 = (state_63492[(2)]);
var state_63492__$1 = state_63492;
var statearr_63509_63533 = state_63492__$1;
(statearr_63509_63533[(2)] = inst_63473);

(statearr_63509_63533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (9))){
var inst_63464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63465 = ["_user/username",user];
var inst_63466 = (new cljs.core.PersistentVector(null,2,(5),inst_63464,inst_63465,null));
var state_63492__$1 = state_63492;
var statearr_63510_63534 = state_63492__$1;
(statearr_63510_63534[(2)] = inst_63466);

(statearr_63510_63534[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (5))){
var _ = (function (){var statearr_63511 = state_63492;
(statearr_63511[(4)] = cljs.core.rest((state_63492[(4)])));

return statearr_63511;
})();
var state_63492__$1 = state_63492;
var ex63508 = (state_63492__$1[(2)]);
var statearr_63512_63535 = state_63492__$1;
(statearr_63512_63535[(5)] = ex63508);


var statearr_63513_63536 = state_63492__$1;
(statearr_63513_63536[(1)] = (4));

(statearr_63513_63536[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (14))){
var inst_63471 = (state_63492[(2)]);
var state_63492__$1 = state_63492;
var statearr_63514_63537 = state_63492__$1;
(statearr_63514_63537[(2)] = inst_63471);

(statearr_63514_63537[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (10))){
var state_63492__$1 = state_63492;
var statearr_63515_63538 = state_63492__$1;
(statearr_63515_63538[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63493 === (8))){
var inst_63475 = (state_63492[(2)]);
var inst_63476 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63477 = [account,inst_63475,password,expireSeconds,syncTo];
var inst_63478 = cljs.core.PersistentHashMap.fromArrays(inst_63476,inst_63477);
var inst_63479 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63478);
var state_63492__$1 = state_63492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63492__$1,(15),inst_63479);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_63517 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63517[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_63517[(1)] = (1));

return statearr_63517;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_63492){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63492);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63518){var ex__2730__auto__ = e63518;
var statearr_63519_63539 = state_63492;
(statearr_63519_63539[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63492[(4)]))){
var statearr_63520_63540 = state_63492;
(statearr_63520_63540[(1)] = cljs.core.first((state_63492[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63541 = state_63492;
state_63492 = G__63541;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_63492){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_63492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63521 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63521[(6)] = c__2749__auto__);

return statearr_63521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63543 = arguments.length;
switch (G__63543) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63552){
var state_val_63553 = (state_63552[(1)]);
if((state_val_63553 === (1))){
var inst_63544 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63546 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63547 = (new cljs.core.PersistentVector(null,4,(5),inst_63545,inst_63546,null));
var inst_63548 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63544,inst_63547);
var inst_63549 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63554 = cljs.core.seq(cljs.core.keys(x));
var chunk__63555 = null;
var count__63556 = (0);
var i__63557 = (0);
while(true){
if((i__63557 < count__63556)){
var k = chunk__63555.cljs$core$IIndexed$_nth$arity$2(null,i__63557);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63565 = seq__63554;
var G__63566 = chunk__63555;
var G__63567 = count__63556;
var G__63568 = (i__63557 + (1));
seq__63554 = G__63565;
chunk__63555 = G__63566;
count__63556 = G__63567;
i__63557 = G__63568;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__63554);
if(temp__5804__auto__){
var seq__63554__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63554__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__63554__$1);
var G__63569 = cljs.core.chunk_rest(seq__63554__$1);
var G__63570 = c__5568__auto__;
var G__63571 = cljs.core.count(c__5568__auto__);
var G__63572 = (0);
seq__63554 = G__63569;
chunk__63555 = G__63570;
count__63556 = G__63571;
i__63557 = G__63572;
continue;
} else {
var k = cljs.core.first(seq__63554__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63573 = cljs.core.next(seq__63554__$1);
var G__63574 = null;
var G__63575 = (0);
var G__63576 = (0);
seq__63554 = G__63573;
chunk__63555 = G__63574;
count__63556 = G__63575;
i__63557 = G__63576;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63550 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63549);
var state_63552__$1 = (function (){var statearr_63558 = state_63552;
(statearr_63558[(7)] = inst_63548);

return statearr_63558;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63552__$1,inst_63550);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_63559 = [null,null,null,null,null,null,null,null];
(statearr_63559[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_63559[(1)] = (1));

return statearr_63559;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_63552){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63552);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63560){var ex__2730__auto__ = e63560;
var statearr_63561_63577 = state_63552;
(statearr_63561_63577[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63552[(4)]))){
var statearr_63562_63578 = state_63552;
(statearr_63562_63578[(1)] = cljs.core.first((state_63552[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63579 = state_63552;
state_63552 = G__63579;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_63552){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_63552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63563 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63563[(6)] = c__2749__auto__);

return statearr_63563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63581 = arguments.length;
switch (G__63581) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63615){
var state_val_63616 = (state_63615[(1)]);
if((state_val_63616 === (1))){
var state_63615__$1 = state_63615;
var statearr_63617_63638 = state_63615__$1;
(statearr_63617_63638[(2)] = null);

(statearr_63617_63638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (2))){
var _ = (function (){var statearr_63618 = state_63615;
(statearr_63618[(4)] = cljs.core.cons((5),(state_63615[(4)])));

return statearr_63618;
})();
var inst_63590 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_63591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63592 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63593 = (new cljs.core.PersistentVector(null,1,(5),inst_63591,inst_63592,null));
var inst_63594 = cljs.core.PersistentHashMap.EMPTY;
var inst_63595 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63594);
var inst_63596 = cljs.core.assoc_in(inst_63590,inst_63593,inst_63595);
var inst_63597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63598 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63599 = (new cljs.core.PersistentVector(null,1,(5),inst_63597,inst_63598,null));
var inst_63600 = cljs.core.PersistentHashMap.EMPTY;
var inst_63601 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63600);
var inst_63602 = cljs.core.assoc_in(inst_63596,inst_63599,inst_63601);
var inst_63603 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63604 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63602);
var inst_63605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63606 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63603,null];
var inst_63607 = (new cljs.core.PersistentVector(null,4,(5),inst_63605,inst_63606,null));
var inst_63608 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63604,inst_63607);
var inst_63609 = (function (){var conn = inst_63602;
var pc = inst_63603;
return (function (x){
if((x == null)){
} else {
var seq__63619_63639 = cljs.core.seq(cljs.core.keys(x));
var chunk__63620_63640 = null;
var count__63621_63641 = (0);
var i__63622_63642 = (0);
while(true){
if((i__63622_63642 < count__63621_63641)){
var k_63643 = chunk__63620_63640.cljs$core$IIndexed$_nth$arity$2(null,i__63622_63642);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63643], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63643,null));


var G__63644 = seq__63619_63639;
var G__63645 = chunk__63620_63640;
var G__63646 = count__63621_63641;
var G__63647 = (i__63622_63642 + (1));
seq__63619_63639 = G__63644;
chunk__63620_63640 = G__63645;
count__63621_63641 = G__63646;
i__63622_63642 = G__63647;
continue;
} else {
var temp__5804__auto___63648 = cljs.core.seq(seq__63619_63639);
if(temp__5804__auto___63648){
var seq__63619_63649__$1 = temp__5804__auto___63648;
if(cljs.core.chunked_seq_QMARK_(seq__63619_63649__$1)){
var c__5568__auto___63650 = cljs.core.chunk_first(seq__63619_63649__$1);
var G__63651 = cljs.core.chunk_rest(seq__63619_63649__$1);
var G__63652 = c__5568__auto___63650;
var G__63653 = cljs.core.count(c__5568__auto___63650);
var G__63654 = (0);
seq__63619_63639 = G__63651;
chunk__63620_63640 = G__63652;
count__63621_63641 = G__63653;
i__63622_63642 = G__63654;
continue;
} else {
var k_63655 = cljs.core.first(seq__63619_63649__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63655], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63655,null));


var G__63656 = cljs.core.next(seq__63619_63649__$1);
var G__63657 = null;
var G__63658 = (0);
var G__63659 = (0);
seq__63619_63639 = G__63656;
chunk__63620_63640 = G__63657;
count__63621_63641 = G__63658;
i__63622_63642 = G__63659;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_63610 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63603,inst_63609);
var ___$1 = (function (){var statearr_63623 = state_63615;
(statearr_63623[(4)] = cljs.core.rest((state_63615[(4)])));

return statearr_63623;
})();
var state_63615__$1 = (function (){var statearr_63624 = state_63615;
(statearr_63624[(7)] = inst_63608);

return statearr_63624;
})();
var statearr_63625_63660 = state_63615__$1;
(statearr_63625_63660[(2)] = inst_63610);

(statearr_63625_63660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (3))){
var inst_63613 = (state_63615[(2)]);
var state_63615__$1 = state_63615;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63615__$1,inst_63613);
} else {
if((state_val_63616 === (4))){
var inst_63582 = (state_63615[(2)]);
var inst_63583 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63582], 0));
var inst_63584 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63582) : reject.call(null,inst_63582));
var state_63615__$1 = (function (){var statearr_63627 = state_63615;
(statearr_63627[(8)] = inst_63583);

return statearr_63627;
})();
var statearr_63628_63661 = state_63615__$1;
(statearr_63628_63661[(2)] = inst_63584);

(statearr_63628_63661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (5))){
var _ = (function (){var statearr_63629 = state_63615;
(statearr_63629[(4)] = cljs.core.rest((state_63615[(4)])));

return statearr_63629;
})();
var state_63615__$1 = state_63615;
var ex63626 = (state_63615__$1[(2)]);
var statearr_63630_63662 = state_63615__$1;
(statearr_63630_63662[(5)] = ex63626);


var statearr_63631_63663 = state_63615__$1;
(statearr_63631_63663[(1)] = (4));

(statearr_63631_63663[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_63632 = [null,null,null,null,null,null,null,null,null];
(statearr_63632[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_63632[(1)] = (1));

return statearr_63632;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_63615){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63615);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63633){var ex__2730__auto__ = e63633;
var statearr_63634_63664 = state_63615;
(statearr_63634_63664[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63615[(4)]))){
var statearr_63635_63665 = state_63615;
(statearr_63635_63665[(1)] = cljs.core.first((state_63615[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63666 = state_63615;
state_63615 = G__63666;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_63615){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_63615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63636 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63636[(6)] = c__2749__auto__);

return statearr_63636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63668 = arguments.length;
switch (G__63668) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63670 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63670,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63670,(1),null);
var cb_STAR_ = (function (header,data){
var G__63673 = cljs.core.clj__GT_js(header);
var G__63674 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__63673,G__63674) : callback.call(null,G__63673,G__63674));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63675 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63675,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63675,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63728){
var state_val_63729 = (state_63728[(1)]);
if((state_val_63729 === (7))){
var inst_63689 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63690 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63691 = cljs.core.PersistentHashMap.fromArrays(inst_63689,inst_63690);
var inst_63692 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63691);
var inst_63693 = (function(){throw inst_63692})();
var state_63728__$1 = state_63728;
var statearr_63730_63762 = state_63728__$1;
(statearr_63730_63762[(2)] = inst_63693);

(statearr_63730_63762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (1))){
var state_63728__$1 = state_63728;
var statearr_63731_63763 = state_63728__$1;
(statearr_63731_63763[(2)] = null);

(statearr_63731_63763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (4))){
var inst_63678 = (state_63728[(2)]);
var inst_63679 = cljs.core.clj__GT_js(inst_63678);
var inst_63680 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63679) : reject.call(null,inst_63679));
var state_63728__$1 = state_63728;
var statearr_63732_63764 = state_63728__$1;
(statearr_63732_63764[(2)] = inst_63680);

(statearr_63732_63764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (13))){
var inst_63707 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63708 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63709 = cljs.core.PersistentHashMap.fromArrays(inst_63707,inst_63708);
var inst_63710 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_63709);
var inst_63711 = (function(){throw inst_63710})();
var state_63728__$1 = state_63728;
var statearr_63733_63765 = state_63728__$1;
(statearr_63733_63765[(2)] = inst_63711);

(statearr_63733_63765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (6))){
var state_63728__$1 = state_63728;
var statearr_63734_63766 = state_63728__$1;
(statearr_63734_63766[(2)] = null);

(statearr_63734_63766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (3))){
var inst_63726 = (state_63728[(2)]);
var state_63728__$1 = state_63728;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63728__$1,inst_63726);
} else {
if((state_val_63729 === (12))){
var state_63728__$1 = state_63728;
var statearr_63735_63767 = state_63728__$1;
(statearr_63735_63767[(2)] = null);

(statearr_63735_63767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (2))){
var _ = (function (){var statearr_63736 = state_63728;
(statearr_63736[(4)] = cljs.core.cons((5),(state_63728[(4)])));

return statearr_63736;
})();
var inst_63686 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63728__$1 = state_63728;
if(cljs.core.truth_(inst_63686)){
var statearr_63737_63768 = state_63728__$1;
(statearr_63737_63768[(1)] = (6));

} else {
var statearr_63738_63769 = state_63728__$1;
(statearr_63738_63769[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (11))){
var inst_63704 = (state_63728[(2)]);
var state_63728__$1 = (function (){var statearr_63740 = state_63728;
(statearr_63740[(7)] = inst_63704);

return statearr_63740;
})();
if(cljs.core.truth_(password)){
var statearr_63741_63770 = state_63728__$1;
(statearr_63741_63770[(1)] = (12));

} else {
var statearr_63742_63771 = state_63728__$1;
(statearr_63742_63771[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (9))){
var state_63728__$1 = state_63728;
var statearr_63743_63772 = state_63728__$1;
(statearr_63743_63772[(2)] = null);

(statearr_63743_63772[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (5))){
var _ = (function (){var statearr_63744 = state_63728;
(statearr_63744[(4)] = cljs.core.rest((state_63728[(4)])));

return statearr_63744;
})();
var state_63728__$1 = state_63728;
var ex63739 = (state_63728__$1[(2)]);
var statearr_63745_63773 = state_63728__$1;
(statearr_63745_63773[(5)] = ex63739);


var statearr_63746_63774 = state_63728__$1;
(statearr_63746_63774[(1)] = (4));

(statearr_63746_63774[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (14))){
var inst_63713 = (state_63728[(2)]);
var inst_63714 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_63715 = fluree.db.util.core.without_nils(inst_63714);
var inst_63716 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63717 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63719 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63715,inst_63716,null];
var inst_63720 = (new cljs.core.PersistentVector(null,4,(5),inst_63718,inst_63719,null));
var inst_63721 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63717,inst_63720);
var inst_63722 = (function (){var _ = inst_63713;
var data = inst_63715;
var pc = inst_63716;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63747 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63747) : reject.call(null,G__63747));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63748 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63748) : reject.call(null,G__63748));
} else {
var G__63749 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63749) : resolve.call(null,G__63749));

}
}
});
})();
var inst_63723 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63716,inst_63722);
var _ = (function (){var statearr_63750 = state_63728;
(statearr_63750[(4)] = cljs.core.rest((state_63728[(4)])));

return statearr_63750;
})();
var state_63728__$1 = (function (){var statearr_63751 = state_63728;
(statearr_63751[(8)] = inst_63721);

return statearr_63751;
})();
var statearr_63752_63775 = state_63728__$1;
(statearr_63752_63775[(2)] = inst_63723);

(statearr_63752_63775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (10))){
var inst_63698 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63699 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63700 = cljs.core.PersistentHashMap.fromArrays(inst_63698,inst_63699);
var inst_63701 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_63700);
var inst_63702 = (function(){throw inst_63701})();
var state_63728__$1 = state_63728;
var statearr_63753_63776 = state_63728__$1;
(statearr_63753_63776[(2)] = inst_63702);

(statearr_63753_63776[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63729 === (8))){
var inst_63695 = (state_63728[(2)]);
var state_63728__$1 = (function (){var statearr_63754 = state_63728;
(statearr_63754[(9)] = inst_63695);

return statearr_63754;
})();
if(cljs.core.truth_(ledger)){
var statearr_63755_63777 = state_63728__$1;
(statearr_63755_63777[(1)] = (9));

} else {
var statearr_63756_63778 = state_63728__$1;
(statearr_63756_63778[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_63757 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63757[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_63757[(1)] = (1));

return statearr_63757;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_63728){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63728);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63758){var ex__2730__auto__ = e63758;
var statearr_63759_63779 = state_63728;
(statearr_63759_63779[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63728[(4)]))){
var statearr_63760_63780 = state_63728;
(statearr_63760_63780[(1)] = cljs.core.first((state_63728[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63781 = state_63728;
state_63728 = G__63781;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_63728){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_63728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63761 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63761[(6)] = c__2749__auto__);

return statearr_63761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63783 = arguments.length;
switch (G__63783) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63850){
var state_val_63851 = (state_63850[(1)]);
if((state_val_63851 === (7))){
var inst_63795 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63796 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63797 = cljs.core.PersistentHashMap.fromArrays(inst_63795,inst_63796);
var inst_63798 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63797);
var inst_63799 = (function(){throw inst_63798})();
var state_63850__$1 = state_63850;
var statearr_63852_63894 = state_63850__$1;
(statearr_63852_63894[(2)] = inst_63799);

(statearr_63852_63894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (20))){
var inst_63833 = (state_63850[(2)]);
var inst_63834 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63835 = [ledger,password,user,auth,expire];
var inst_63836 = cljs.core.PersistentHashMap.fromArrays(inst_63834,inst_63835);
var inst_63837 = fluree.db.util.core.without_nils(inst_63836);
var inst_63838 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63839 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63841 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63837,inst_63838,null];
var inst_63842 = (new cljs.core.PersistentVector(null,4,(5),inst_63840,inst_63841,null));
var inst_63843 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63839,inst_63842);
var inst_63844 = (function (){var _ = inst_63833;
var data = inst_63837;
var pc = inst_63838;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63853 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63853) : reject.call(null,G__63853));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63854 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63854) : reject.call(null,G__63854));
} else {
fluree.db.connection.add_token(conn,result);

var G__63855 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63855) : resolve.call(null,G__63855));

}
}
});
})();
var inst_63845 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63838,inst_63844);
var _ = (function (){var statearr_63856 = state_63850;
(statearr_63856[(4)] = cljs.core.rest((state_63850[(4)])));

return statearr_63856;
})();
var state_63850__$1 = (function (){var statearr_63857 = state_63850;
(statearr_63857[(7)] = inst_63843);

return statearr_63857;
})();
var statearr_63858_63895 = state_63850__$1;
(statearr_63858_63895[(2)] = inst_63845);

(statearr_63858_63895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (1))){
var state_63850__$1 = state_63850;
var statearr_63859_63896 = state_63850__$1;
(statearr_63859_63896[(2)] = null);

(statearr_63859_63896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (4))){
var inst_63784 = (state_63850[(2)]);
var inst_63785 = cljs.core.clj__GT_js(inst_63784);
var inst_63786 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63785) : reject.call(null,inst_63785));
var state_63850__$1 = state_63850;
var statearr_63860_63897 = state_63850__$1;
(statearr_63860_63897[(2)] = inst_63786);

(statearr_63860_63897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (15))){
var inst_63820 = (state_63850[(8)]);
var state_63850__$1 = state_63850;
var statearr_63861_63898 = state_63850__$1;
(statearr_63861_63898[(2)] = inst_63820);

(statearr_63861_63898[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (13))){
var inst_63813 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63814 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63815 = cljs.core.PersistentHashMap.fromArrays(inst_63813,inst_63814);
var inst_63816 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_63815);
var inst_63817 = (function(){throw inst_63816})();
var state_63850__$1 = state_63850;
var statearr_63862_63899 = state_63850__$1;
(statearr_63862_63899[(2)] = inst_63817);

(statearr_63862_63899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (6))){
var state_63850__$1 = state_63850;
var statearr_63863_63900 = state_63850__$1;
(statearr_63863_63900[(2)] = null);

(statearr_63863_63900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (17))){
var inst_63824 = (state_63850[(2)]);
var state_63850__$1 = state_63850;
if(cljs.core.truth_(inst_63824)){
var statearr_63864_63901 = state_63850__$1;
(statearr_63864_63901[(1)] = (18));

} else {
var statearr_63865_63902 = state_63850__$1;
(statearr_63865_63902[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (3))){
var inst_63848 = (state_63850[(2)]);
var state_63850__$1 = state_63850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63850__$1,inst_63848);
} else {
if((state_val_63851 === (12))){
var state_63850__$1 = state_63850;
var statearr_63866_63903 = state_63850__$1;
(statearr_63866_63903[(2)] = null);

(statearr_63866_63903[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (2))){
var _ = (function (){var statearr_63867 = state_63850;
(statearr_63867[(4)] = cljs.core.cons((5),(state_63850[(4)])));

return statearr_63867;
})();
var inst_63792 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63850__$1 = state_63850;
if(cljs.core.truth_(inst_63792)){
var statearr_63868_63904 = state_63850__$1;
(statearr_63868_63904[(1)] = (6));

} else {
var statearr_63869_63905 = state_63850__$1;
(statearr_63869_63905[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (19))){
var inst_63827 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63828 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63829 = cljs.core.PersistentHashMap.fromArrays(inst_63827,inst_63828);
var inst_63830 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_63829);
var inst_63831 = (function(){throw inst_63830})();
var state_63850__$1 = state_63850;
var statearr_63870_63906 = state_63850__$1;
(statearr_63870_63906[(2)] = inst_63831);

(statearr_63870_63906[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (11))){
var inst_63810 = (state_63850[(2)]);
var state_63850__$1 = (function (){var statearr_63872 = state_63850;
(statearr_63872[(9)] = inst_63810);

return statearr_63872;
})();
if(cljs.core.truth_(password)){
var statearr_63873_63907 = state_63850__$1;
(statearr_63873_63907[(1)] = (12));

} else {
var statearr_63874_63908 = state_63850__$1;
(statearr_63874_63908[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (9))){
var state_63850__$1 = state_63850;
var statearr_63875_63909 = state_63850__$1;
(statearr_63875_63909[(2)] = null);

(statearr_63875_63909[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (5))){
var _ = (function (){var statearr_63876 = state_63850;
(statearr_63876[(4)] = cljs.core.rest((state_63850[(4)])));

return statearr_63876;
})();
var state_63850__$1 = state_63850;
var ex63871 = (state_63850__$1[(2)]);
var statearr_63877_63910 = state_63850__$1;
(statearr_63877_63910[(5)] = ex63871);


var statearr_63878_63911 = state_63850__$1;
(statearr_63878_63911[(1)] = (4));

(statearr_63878_63911[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (14))){
var inst_63820 = (state_63850[(8)]);
var inst_63819 = (state_63850[(2)]);
var inst_63820__$1 = user;
var state_63850__$1 = (function (){var statearr_63879 = state_63850;
(statearr_63879[(8)] = inst_63820__$1);

(statearr_63879[(10)] = inst_63819);

return statearr_63879;
})();
if(cljs.core.truth_(inst_63820__$1)){
var statearr_63880_63912 = state_63850__$1;
(statearr_63880_63912[(1)] = (15));

} else {
var statearr_63881_63913 = state_63850__$1;
(statearr_63881_63913[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (16))){
var state_63850__$1 = state_63850;
var statearr_63882_63914 = state_63850__$1;
(statearr_63882_63914[(2)] = auth);

(statearr_63882_63914[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (10))){
var inst_63804 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63805 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63806 = cljs.core.PersistentHashMap.fromArrays(inst_63804,inst_63805);
var inst_63807 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_63806);
var inst_63808 = (function(){throw inst_63807})();
var state_63850__$1 = state_63850;
var statearr_63883_63915 = state_63850__$1;
(statearr_63883_63915[(2)] = inst_63808);

(statearr_63883_63915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (18))){
var state_63850__$1 = state_63850;
var statearr_63884_63916 = state_63850__$1;
(statearr_63884_63916[(2)] = null);

(statearr_63884_63916[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63851 === (8))){
var inst_63801 = (state_63850[(2)]);
var state_63850__$1 = (function (){var statearr_63885 = state_63850;
(statearr_63885[(11)] = inst_63801);

return statearr_63885;
})();
if(cljs.core.truth_(ledger)){
var statearr_63886_63917 = state_63850__$1;
(statearr_63886_63917[(1)] = (9));

} else {
var statearr_63887_63918 = state_63850__$1;
(statearr_63887_63918[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_63888 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63888[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_63888[(1)] = (1));

return statearr_63888;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_63850){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63850);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63889){var ex__2730__auto__ = e63889;
var statearr_63890_63919 = state_63850;
(statearr_63890_63919[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63850[(4)]))){
var statearr_63891_63920 = state_63850;
(statearr_63891_63920[(1)] = cljs.core.first((state_63850[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63921 = state_63850;
state_63850 = G__63921;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_63850){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_63850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63892 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63892[(6)] = c__2749__auto__);

return statearr_63892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63923 = arguments.length;
switch (G__63923) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63958){
var state_val_63959 = (state_63958[(1)]);
if((state_val_63959 === (1))){
var state_63958__$1 = state_63958;
var statearr_63960_63982 = state_63958__$1;
(statearr_63960_63982[(2)] = null);

(statearr_63960_63982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63959 === (2))){
var _ = (function (){var statearr_63961 = state_63958;
(statearr_63961[(4)] = cljs.core.cons((5),(state_63958[(4)])));

return statearr_63961;
})();
var inst_63932 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63958__$1 = state_63958;
if(cljs.core.truth_(inst_63932)){
var statearr_63962_63983 = state_63958__$1;
(statearr_63962_63983[(1)] = (6));

} else {
var statearr_63963_63984 = state_63958__$1;
(statearr_63963_63984[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63959 === (3))){
var inst_63956 = (state_63958[(2)]);
var state_63958__$1 = state_63958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63958__$1,inst_63956);
} else {
if((state_val_63959 === (4))){
var inst_63924 = (state_63958[(2)]);
var inst_63925 = cljs.core.clj__GT_js(inst_63924);
var inst_63926 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63925) : reject.call(null,inst_63925));
var state_63958__$1 = state_63958;
var statearr_63965_63985 = state_63958__$1;
(statearr_63965_63985[(2)] = inst_63926);

(statearr_63965_63985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63959 === (5))){
var _ = (function (){var statearr_63966 = state_63958;
(statearr_63966[(4)] = cljs.core.rest((state_63958[(4)])));

return statearr_63966;
})();
var state_63958__$1 = state_63958;
var ex63964 = (state_63958__$1[(2)]);
var statearr_63967_63986 = state_63958__$1;
(statearr_63967_63986[(5)] = ex63964);


var statearr_63968_63987 = state_63958__$1;
(statearr_63968_63987[(1)] = (4));

(statearr_63968_63987[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63959 === (6))){
var state_63958__$1 = state_63958;
var statearr_63969_63988 = state_63958__$1;
(statearr_63969_63988[(2)] = null);

(statearr_63969_63988[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63959 === (7))){
var inst_63935 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63936 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63937 = cljs.core.PersistentHashMap.fromArrays(inst_63935,inst_63936);
var inst_63938 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63937);
var inst_63939 = (function(){throw inst_63938})();
var state_63958__$1 = state_63958;
var statearr_63970_63989 = state_63958__$1;
(statearr_63970_63989[(2)] = inst_63939);

(statearr_63970_63989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63959 === (8))){
var inst_63941 = (state_63958[(2)]);
var inst_63942 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63943 = [jwt,expire];
var inst_63944 = cljs.core.PersistentHashMap.fromArrays(inst_63942,inst_63943);
var inst_63945 = fluree.db.util.core.without_nils(inst_63944);
var inst_63946 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63947 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63949 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63945,inst_63946,null];
var inst_63950 = (new cljs.core.PersistentVector(null,4,(5),inst_63948,inst_63949,null));
var inst_63951 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63947,inst_63950);
var inst_63952 = (function (){var _ = inst_63941;
var data = inst_63945;
var pc = inst_63946;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63971 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63971) : reject.call(null,G__63971));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63972 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63972) : resolve.call(null,G__63972));

}
});
})();
var inst_63953 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63946,inst_63952);
var _ = (function (){var statearr_63973 = state_63958;
(statearr_63973[(4)] = cljs.core.rest((state_63958[(4)])));

return statearr_63973;
})();
var state_63958__$1 = (function (){var statearr_63974 = state_63958;
(statearr_63974[(7)] = inst_63951);

return statearr_63974;
})();
var statearr_63975_63990 = state_63958__$1;
(statearr_63975_63990[(2)] = inst_63953);

(statearr_63975_63990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_63976 = [null,null,null,null,null,null,null,null];
(statearr_63976[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_63976[(1)] = (1));

return statearr_63976;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_63958){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63958);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63977){var ex__2730__auto__ = e63977;
var statearr_63978_63991 = state_63958;
(statearr_63978_63991[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63958[(4)]))){
var statearr_63979_63992 = state_63958;
(statearr_63979_63992[(1)] = cljs.core.first((state_63958[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63993 = state_63958;
state_63958 = G__63993;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_63958){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_63958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63980 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63980[(6)] = c__2749__auto__);

return statearr_63980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

