// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22942 = arguments.length;
switch (G__22942) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__22943 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__22943) : f.call(null,G__22943));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__22944 = cljs.core._deref(vol);
var G__22945 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22944,G__22945) : f.call(null,G__22944,G__22945));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__22946 = cljs.core._deref(vol);
var G__22947 = arg1;
var G__22948 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__22946,G__22947,G__22948) : f.call(null,G__22946,G__22947,G__22948));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__22949 = cljs.core._deref(vol);
var G__22950 = arg1;
var G__22951 = arg2;
var G__22952 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__22949,G__22950,G__22951,G__22952) : f.call(null,G__22949,G__22950,G__22951,G__22952));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22955 = arguments.length;
switch (G__22955) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22957 = null;
var G__22957__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22957__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22957__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22957 = function(result,flake){
switch(arguments.length){
case 0:
return G__22957__0.call(this);
case 1:
return G__22957__1.call(this,result);
case 2:
return G__22957__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22957.cljs$core$IFn$_invoke$arity$0 = G__22957__0;
G__22957.cljs$core$IFn$_invoke$arity$1 = G__22957__1;
G__22957.cljs$core$IFn$_invoke$arity$2 = G__22957__2;
return G__22957;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22958 = null;
var G__22958__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22958__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22958__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22958 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22958__0.call(this);
case 1:
return G__22958__1.call(this,result);
case 2:
return G__22958__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22958.cljs$core$IFn$_invoke$arity$0 = G__22958__0;
G__22958.cljs$core$IFn$_invoke$arity$1 = G__22958__1;
G__22958.cljs$core$IFn$_invoke$arity$2 = G__22958__2;
return G__22958;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22960 = res;
var G__22960__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22959_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22959_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22960):G__22960);
var G__22960__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22960__$1):G__22960__$1);
var G__22960__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22960__$2):G__22960__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22960__$3);
} else {
return G__22960__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22964 = arguments.length;
switch (G__22964) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23403){
var state_val_23404 = (state_23403[(1)]);
if((state_val_23404 === (121))){
var inst_23326 = (state_23403[(2)]);
var inst_23327 = fluree.db.util.async.throw_err(inst_23326);
var inst_23328 = cljs.core.seq(inst_23327);
var state_23403__$1 = state_23403;
if(inst_23328){
var statearr_23405_23619 = state_23403__$1;
(statearr_23405_23619[(1)] = (122));

} else {
var statearr_23406_23620 = state_23403__$1;
(statearr_23406_23620[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (65))){
var inst_23119 = (state_23403[(7)]);
var inst_23118 = (state_23403[(2)]);
var inst_23119__$1 = fluree.db.util.async.throw_err(inst_23118);
var inst_23120 = cljs.core.seq(inst_23119__$1);
var state_23403__$1 = (function (){var statearr_23407 = state_23403;
(statearr_23407[(7)] = inst_23119__$1);

return statearr_23407;
})();
if(inst_23120){
var statearr_23408_23621 = state_23403__$1;
(statearr_23408_23621[(1)] = (66));

} else {
var statearr_23409_23622 = state_23403__$1;
(statearr_23409_23622[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (70))){
var inst_23119 = (state_23403[(7)]);
var inst_23130 = cljs.core.count(inst_23119);
var inst_23131 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_23130);
var state_23403__$1 = state_23403;
var statearr_23410_23623 = state_23403__$1;
(statearr_23410_23623[(2)] = inst_23131);

(statearr_23410_23623[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (62))){
var inst_23109 = (state_23403[(8)]);
var inst_23112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23113 = inst_23109.o;
var inst_23114 = [inst_23113];
var inst_23115 = (new cljs.core.PersistentVector(null,1,(5),inst_23112,inst_23114,null));
var inst_23116 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23115);
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23403__$1,(65),inst_23116);
} else {
if((state_val_23404 === (74))){
var inst_23103 = (state_23403[(9)]);
var state_23403__$1 = state_23403;
var statearr_23411_23624 = state_23403__$1;
(statearr_23411_23624[(2)] = inst_23103);

(statearr_23411_23624[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (110))){
var inst_23288 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_23289 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_23288);
var inst_23290 = inst_23289 === true;
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23290)){
var statearr_23412_23625 = state_23403__$1;
(statearr_23412_23625[(1)] = (113));

} else {
var statearr_23413_23626 = state_23403__$1;
(statearr_23413_23626[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (130))){
var inst_23398 = (state_23403[(2)]);
var _ = (function (){var statearr_23414 = state_23403;
(statearr_23414[(4)] = cljs.core.rest((state_23403[(4)])));

return statearr_23414;
})();
var state_23403__$1 = state_23403;
var statearr_23415_23627 = state_23403__$1;
(statearr_23415_23627[(2)] = inst_23398);

(statearr_23415_23627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (128))){
var inst_23373 = (state_23403[(10)]);
var inst_23376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23377 = [acc,inst_23373];
var inst_23378 = (new cljs.core.PersistentVector(null,2,(5),inst_23376,inst_23377,null));
var state_23403__$1 = state_23403;
var statearr_23416_23628 = state_23403__$1;
(statearr_23416_23628[(2)] = inst_23378);

(statearr_23416_23628[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (7))){
var inst_22976 = (state_23403[(11)]);
var state_23403__$1 = state_23403;
var statearr_23417_23629 = state_23403__$1;
(statearr_23417_23629[(2)] = inst_22976);

(statearr_23417_23629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (59))){
var inst_23367 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23418_23630 = state_23403__$1;
(statearr_23418_23630[(2)] = inst_23367);

(statearr_23418_23630[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (86))){
var inst_23197 = (state_23403[(12)]);
var inst_23197__$1 = (state_23403[(2)]);
var state_23403__$1 = (function (){var statearr_23419 = state_23403;
(statearr_23419[(12)] = inst_23197__$1);

return statearr_23419;
})();
if(cljs.core.truth_(inst_23197__$1)){
var statearr_23420_23631 = state_23403__$1;
(statearr_23420_23631[(1)] = (88));

} else {
var statearr_23421_23632 = state_23403__$1;
(statearr_23421_23632[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (20))){
var inst_23017 = (state_23403[(13)]);
var inst_23005 = (state_23403[(14)]);
var inst_23018 = (state_23403[(15)]);
var inst_23016 = (state_23403[(2)]);
var inst_23017__$1 = cljs.core.__destructure_map(inst_23005);
var inst_23018__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23017__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23017__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_23020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23017__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23021 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23017__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_23022 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23017__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23017__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_23403__$1 = (function (){var statearr_23422 = state_23403;
(statearr_23422[(16)] = inst_23016);

(statearr_23422[(13)] = inst_23017__$1);

(statearr_23422[(17)] = inst_23023);

(statearr_23422[(15)] = inst_23018__$1);

(statearr_23422[(18)] = inst_23022);

(statearr_23422[(19)] = inst_23020);

(statearr_23422[(20)] = inst_23019);

(statearr_23422[(21)] = inst_23021);

return statearr_23422;
})();
if(cljs.core.truth_(inst_23018__$1)){
var statearr_23423_23633 = state_23403__$1;
(statearr_23423_23633[(1)] = (24));

} else {
var statearr_23424_23634 = state_23403__$1;
(statearr_23424_23634[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (72))){
var inst_23128 = (state_23403[(22)]);
var inst_23134 = (state_23403[(2)]);
var inst_23135 = cljs.core.seq(inst_23128);
var state_23403__$1 = (function (){var statearr_23425 = state_23403;
(statearr_23425[(23)] = inst_23134);

return statearr_23425;
})();
if(inst_23135){
var statearr_23426_23635 = state_23403__$1;
(statearr_23426_23635[(1)] = (73));

} else {
var statearr_23427_23636 = state_23403__$1;
(statearr_23427_23636[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (58))){
var inst_23005 = (state_23403[(14)]);
var inst_23150 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_23005);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23150)){
var statearr_23428_23637 = state_23403__$1;
(statearr_23428_23637[(1)] = (76));

} else {
var statearr_23429_23638 = state_23403__$1;
(statearr_23429_23638[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (60))){
var inst_23102 = (state_23403[(24)]);
var inst_23109 = (state_23403[(8)]);
var inst_23108 = cljs.core.seq(inst_23102);
var inst_23109__$1 = cljs.core.first(inst_23108);
var inst_23110 = cljs.core.next(inst_23108);
var state_23403__$1 = (function (){var statearr_23430 = state_23403;
(statearr_23430[(25)] = inst_23110);

(statearr_23430[(8)] = inst_23109__$1);

return statearr_23430;
})();
if(cljs.core.truth_(inst_23109__$1)){
var statearr_23431_23639 = state_23403__$1;
(statearr_23431_23639[(1)] = (62));

} else {
var statearr_23432_23640 = state_23403__$1;
(statearr_23432_23640[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (27))){
var inst_23026 = (state_23403[(26)]);
var inst_23022 = (state_23403[(18)]);
var inst_23026__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_23022);
var state_23403__$1 = (function (){var statearr_23433 = state_23403;
(statearr_23433[(26)] = inst_23026__$1);

return statearr_23433;
})();
if(inst_23026__$1){
var statearr_23434_23641 = state_23403__$1;
(statearr_23434_23641[(1)] = (30));

} else {
var statearr_23435_23642 = state_23403__$1;
(statearr_23435_23642[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (1))){
var state_23403__$1 = state_23403;
var statearr_23436_23643 = state_23403__$1;
(statearr_23436_23643[(2)] = null);

(statearr_23436_23643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (69))){
var inst_23124 = (state_23403[(2)]);
var inst_23125 = fluree.db.util.async.throw_err(inst_23124);
var state_23403__$1 = state_23403;
var statearr_23437_23644 = state_23403__$1;
(statearr_23437_23644[(2)] = inst_23125);

(statearr_23437_23644[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (101))){
var inst_23281 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23438_23645 = state_23403__$1;
(statearr_23438_23645[(2)] = inst_23281);

(statearr_23438_23645[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (24))){
var inst_23022 = (state_23403[(18)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23022)){
var statearr_23439_23646 = state_23403__$1;
(statearr_23439_23646[(1)] = (27));

} else {
var statearr_23440_23647 = state_23403__$1;
(statearr_23440_23647[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (102))){
var inst_23253 = (state_23403[(27)]);
var inst_23252 = (state_23403[(2)]);
var inst_23253__$1 = fluree.db.util.async.throw_err(inst_23252);
var inst_23254 = cljs.core.empty_QMARK_(inst_23253__$1);
var state_23403__$1 = (function (){var statearr_23441 = state_23403;
(statearr_23441[(27)] = inst_23253__$1);

return statearr_23441;
})();
if(inst_23254){
var statearr_23442_23648 = state_23403__$1;
(statearr_23442_23648[(1)] = (103));

} else {
var statearr_23443_23649 = state_23403__$1;
(statearr_23443_23649[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (135))){
var state_23403__$1 = state_23403;
var statearr_23444_23650 = state_23403__$1;
(statearr_23444_23650[(2)] = null);

(statearr_23444_23650[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (55))){
var inst_23005 = (state_23403[(14)]);
var inst_23078 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23005);
var state_23403__$1 = state_23403;
var statearr_23445_23651 = state_23403__$1;
(statearr_23445_23651[(2)] = inst_23078);

(statearr_23445_23651[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (85))){
var inst_23005 = (state_23403[(14)]);
var inst_23172 = (state_23403[(28)]);
var inst_23184 = inst_23172.o;
var inst_23185 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_23005);
var inst_23186 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_23184,inst_23185);
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23403__$1,(87),inst_23186);
} else {
if((state_val_23404 === (39))){
var inst_23053 = (state_23403[(29)]);
var inst_23021 = (state_23403[(21)]);
var inst_23053__$1 = cljs.core.not(inst_23021);
var state_23403__$1 = (function (){var statearr_23446 = state_23403;
(statearr_23446[(29)] = inst_23053__$1);

return statearr_23446;
})();
if(inst_23053__$1){
var statearr_23447_23652 = state_23403__$1;
(statearr_23447_23652[(1)] = (42));

} else {
var statearr_23448_23653 = state_23403__$1;
(statearr_23448_23653[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (88))){
var inst_23197 = (state_23403[(12)]);
var inst_23166 = (state_23403[(30)]);
var inst_23199 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23166,inst_23197);
var state_23403__$1 = state_23403;
var statearr_23449_23654 = state_23403__$1;
(statearr_23449_23654[(2)] = inst_23199);

(statearr_23449_23654[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (46))){
var inst_23020 = (state_23403[(19)]);
var state_23403__$1 = state_23403;
var statearr_23450_23655 = state_23403__$1;
(statearr_23450_23655[(2)] = inst_23020);

(statearr_23450_23655[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (4))){
var inst_22965 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23451_23656 = state_23403__$1;
(statearr_23451_23656[(2)] = inst_22965);

(statearr_23451_23656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (77))){
var inst_23212 = (state_23403[(31)]);
var inst_23212__$1 = componentFollow_QMARK_;
var state_23403__$1 = (function (){var statearr_23452 = state_23403;
(statearr_23452[(31)] = inst_23212__$1);

return statearr_23452;
})();
if(cljs.core.truth_(inst_23212__$1)){
var statearr_23453_23657 = state_23403__$1;
(statearr_23453_23657[(1)] = (91));

} else {
var statearr_23454_23658 = state_23403__$1;
(statearr_23454_23658[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (106))){
var inst_23233 = (state_23403[(32)]);
var inst_23267 = (state_23403[(2)]);
var inst_23268 = fluree.db.util.async.throw_err(inst_23267);
var inst_23269 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23233,inst_23268);
var state_23403__$1 = state_23403;
var statearr_23455_23659 = state_23403__$1;
(statearr_23455_23659[(2)] = inst_23269);

(statearr_23455_23659[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (119))){
var inst_23311 = (state_23403[(33)]);
var inst_23341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23342 = [inst_23311,offset_map];
var inst_23343 = (new cljs.core.PersistentVector(null,2,(5),inst_23341,inst_23342,null));
var state_23403__$1 = state_23403;
var statearr_23456_23660 = state_23403__$1;
(statearr_23456_23660[(2)] = inst_23343);

(statearr_23456_23660[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (95))){
var inst_23019 = (state_23403[(20)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23019)){
var statearr_23457_23661 = state_23403__$1;
(statearr_23457_23661[(1)] = (110));

} else {
var statearr_23458_23662 = state_23403__$1;
(statearr_23458_23662[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (54))){
var inst_23075 = (state_23403[(34)]);
var state_23403__$1 = state_23403;
var statearr_23459_23663 = state_23403__$1;
(statearr_23459_23663[(2)] = inst_23075);

(statearr_23459_23663[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (92))){
var inst_23212 = (state_23403[(31)]);
var state_23403__$1 = state_23403;
var statearr_23460_23664 = state_23403__$1;
(statearr_23460_23664[(2)] = inst_23212);

(statearr_23460_23664[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (104))){
var inst_22975 = (state_23403[(35)]);
var inst_23253 = (state_23403[(27)]);
var inst_23262 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_23263 = [true,inst_22975];
var inst_23264 = cljs.core.PersistentHashMap.fromArrays(inst_23262,inst_23263);
var inst_23265 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23264,inst_23253) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23264,inst_23253));
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23403__$1,(106),inst_23265);
} else {
if((state_val_23404 === (15))){
var inst_22975 = (state_23403[(35)]);
var inst_22998 = (state_23403[(36)]);
var inst_23002 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22998,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22975);
var state_23403__$1 = state_23403;
var statearr_23461_23665 = state_23403__$1;
(statearr_23461_23665[(2)] = inst_23002);

(statearr_23461_23665[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (48))){
var inst_23069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23070 = [null,offset_map];
var inst_23071 = (new cljs.core.PersistentVector(null,2,(5),inst_23069,inst_23070,null));
var state_23403__$1 = state_23403;
var statearr_23462_23666 = state_23403__$1;
(statearr_23462_23666[(2)] = inst_23071);

(statearr_23462_23666[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (50))){
var inst_23369 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23463_23667 = state_23403__$1;
(statearr_23463_23667[(2)] = inst_23369);

(statearr_23463_23667[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (116))){
var inst_23310 = (state_23403[(37)]);
var inst_23317 = (state_23403[(38)]);
var inst_23316 = cljs.core.seq(inst_23310);
var inst_23317__$1 = cljs.core.first(inst_23316);
var inst_23318 = cljs.core.next(inst_23316);
var state_23403__$1 = (function (){var statearr_23464 = state_23403;
(statearr_23464[(39)] = inst_23318);

(statearr_23464[(38)] = inst_23317__$1);

return statearr_23464;
})();
if(cljs.core.truth_(inst_23317__$1)){
var statearr_23465_23668 = state_23403__$1;
(statearr_23465_23668[(1)] = (118));

} else {
var statearr_23466_23669 = state_23403__$1;
(statearr_23466_23669[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (75))){
var inst_23110 = (state_23403[(25)]);
var inst_23140 = (state_23403[(2)]);
var inst_23102 = inst_23110;
var inst_23103 = inst_23140;
var state_23403__$1 = (function (){var statearr_23467 = state_23403;
(statearr_23467[(24)] = inst_23102);

(statearr_23467[(9)] = inst_23103);

return statearr_23467;
})();
var statearr_23468_23670 = state_23403__$1;
(statearr_23468_23670[(2)] = null);

(statearr_23468_23670[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (99))){
var inst_23005 = (state_23403[(14)]);
var inst_23239 = (state_23403[(40)]);
var inst_23242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23243 = inst_23239.o;
var inst_23244 = [inst_23243];
var inst_23245 = (new cljs.core.PersistentVector(null,1,(5),inst_23242,inst_23244,null));
var inst_23246 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23247 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_23005);
var inst_23248 = [inst_23247];
var inst_23249 = cljs.core.PersistentHashMap.fromArrays(inst_23246,inst_23248);
var inst_23250 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23245,inst_23249);
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23403__$1,(102),inst_23250);
} else {
if((state_val_23404 === (21))){
var inst_23009 = (state_23403[(41)]);
var state_23403__$1 = state_23403;
var statearr_23469_23671 = state_23403__$1;
(statearr_23469_23671[(2)] = inst_23009);

(statearr_23469_23671[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (31))){
var inst_23026 = (state_23403[(26)]);
var state_23403__$1 = state_23403;
var statearr_23470_23672 = state_23403__$1;
(statearr_23470_23672[(2)] = inst_23026);

(statearr_23470_23672[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (113))){
var inst_23016 = (state_23403[(16)]);
var inst_23017 = (state_23403[(13)]);
var inst_23005 = (state_23403[(14)]);
var inst_23023 = (state_23403[(17)]);
var inst_23018 = (state_23403[(15)]);
var inst_23022 = (state_23403[(18)]);
var inst_23020 = (state_23403[(19)]);
var inst_23019 = (state_23403[(20)]);
var inst_22990 = (state_23403[(42)]);
var inst_22975 = (state_23403[(35)]);
var inst_23021 = (state_23403[(21)]);
var inst_23292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23293 = (function (){var p = inst_23023;
var pred_spec__$1 = inst_22990;
var orderBy = inst_23021;
var multi_QMARK_ = inst_23018;
var limit = inst_23020;
var offset = inst_23022;
var map__22971 = inst_23017;
var k = inst_23016;
var compact_QMARK_ = inst_22975;
var pred_spec_SINGLEQUOTE_ = inst_23005;
var ref_QMARK_ = inst_23019;
return (function (p1__22961_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22961_SHARP_.o]);
});
})();
var inst_23294 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_23293,flakes);
var inst_23295 = [inst_23294,offset_map];
var inst_23296 = (new cljs.core.PersistentVector(null,2,(5),inst_23292,inst_23295,null));
var state_23403__$1 = state_23403;
var statearr_23471_23673 = state_23403__$1;
(statearr_23471_23673[(2)] = inst_23296);

(statearr_23471_23673[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (32))){
var inst_23032 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23472_23674 = state_23403__$1;
(statearr_23472_23674[(2)] = inst_23032);

(statearr_23472_23674[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (136))){
var inst_23394 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23473_23675 = state_23403__$1;
(statearr_23473_23675[(2)] = inst_23394);

(statearr_23473_23675[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (40))){
var inst_23018 = (state_23403[(15)]);
var state_23403__$1 = state_23403;
var statearr_23474_23676 = state_23403__$1;
(statearr_23474_23676[(2)] = inst_23018);

(statearr_23474_23676[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (129))){
var inst_23018 = (state_23403[(15)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23018)){
var statearr_23475_23677 = state_23403__$1;
(statearr_23475_23677[(1)] = (131));

} else {
var statearr_23476_23678 = state_23403__$1;
(statearr_23476_23678[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (91))){
var inst_23005 = (state_23403[(14)]);
var inst_23214 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_23005);
var state_23403__$1 = state_23403;
var statearr_23477_23679 = state_23403__$1;
(statearr_23477_23679[(2)] = inst_23214);

(statearr_23477_23679[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (117))){
var inst_23347 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23478_23680 = state_23403__$1;
(statearr_23478_23680[(2)] = inst_23347);

(statearr_23478_23680[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (108))){
var state_23403__$1 = state_23403;
var statearr_23479_23681 = state_23403__$1;
(statearr_23479_23681[(2)] = null);

(statearr_23479_23681[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (56))){
var inst_23080 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23480_23682 = state_23403__$1;
(statearr_23480_23682[(2)] = inst_23080);

(statearr_23480_23682[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (33))){
var inst_23023 = (state_23403[(17)]);
var inst_23040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23041 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_23023);
var state_23403__$1 = (function (){var statearr_23481 = state_23403;
(statearr_23481[(43)] = inst_23040);

return statearr_23481;
})();
if(cljs.core.truth_(inst_23041)){
var statearr_23482_23683 = state_23403__$1;
(statearr_23482_23683[(1)] = (36));

} else {
var statearr_23483_23684 = state_23403__$1;
(statearr_23483_23684[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (13))){
var inst_22990 = (state_23403[(42)]);
var state_23403__$1 = state_23403;
var statearr_23484_23685 = state_23403__$1;
(statearr_23484_23685[(2)] = inst_22990);

(statearr_23484_23685[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (22))){
var inst_23005 = (state_23403[(14)]);
var inst_23012 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23005);
var state_23403__$1 = state_23403;
var statearr_23485_23686 = state_23403__$1;
(statearr_23485_23686[(2)] = inst_23012);

(statearr_23485_23686[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (90))){
var inst_23173 = (state_23403[(44)]);
var inst_23202 = (state_23403[(2)]);
var inst_23165 = inst_23173;
var inst_23166 = inst_23202;
var state_23403__$1 = (function (){var statearr_23486 = state_23403;
(statearr_23486[(30)] = inst_23166);

(statearr_23486[(45)] = inst_23165);

return statearr_23486;
})();
var statearr_23487_23687 = state_23403__$1;
(statearr_23487_23687[(2)] = null);

(statearr_23487_23687[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (109))){
var inst_23240 = (state_23403[(46)]);
var inst_23271 = (state_23403[(47)]);
var inst_23277 = (state_23403[(2)]);
var inst_23232 = inst_23240;
var inst_23233 = inst_23271;
var state_23403__$1 = (function (){var statearr_23488 = state_23403;
(statearr_23488[(48)] = inst_23232);

(statearr_23488[(49)] = inst_23277);

(statearr_23488[(32)] = inst_23233);

return statearr_23488;
})();
var statearr_23489_23688 = state_23403__$1;
(statearr_23489_23688[(2)] = null);

(statearr_23489_23688[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (36))){
var inst_23023 = (state_23403[(17)]);
var inst_23043 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_23023,cljs.core.dec);
var state_23403__$1 = state_23403;
var statearr_23490_23689 = state_23403__$1;
(statearr_23490_23689[(2)] = inst_23043);

(statearr_23490_23689[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (41))){
var inst_23067 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23067)){
var statearr_23491_23690 = state_23403__$1;
(statearr_23491_23690[(1)] = (48));

} else {
var statearr_23492_23691 = state_23403__$1;
(statearr_23492_23691[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (118))){
var inst_23317 = (state_23403[(38)]);
var inst_23320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23321 = inst_23317.o;
var inst_23322 = [inst_23321];
var inst_23323 = (new cljs.core.PersistentVector(null,1,(5),inst_23320,inst_23322,null));
var inst_23324 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23323);
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23403__$1,(121),inst_23324);
} else {
if((state_val_23404 === (89))){
var inst_23166 = (state_23403[(30)]);
var state_23403__$1 = state_23403;
var statearr_23493_23692 = state_23403__$1;
(statearr_23493_23692[(2)] = inst_23166);

(statearr_23493_23692[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (100))){
var inst_23233 = (state_23403[(32)]);
var state_23403__$1 = state_23403;
var statearr_23494_23693 = state_23403__$1;
(statearr_23494_23693[(2)] = inst_23233);

(statearr_23494_23693[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (131))){
var inst_23016 = (state_23403[(16)]);
var inst_23373 = (state_23403[(10)]);
var inst_23372 = (state_23403[(50)]);
var inst_23381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23382 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_23016,inst_23372);
var inst_23383 = [inst_23382,inst_23373];
var inst_23384 = (new cljs.core.PersistentVector(null,2,(5),inst_23381,inst_23383,null));
var state_23403__$1 = state_23403;
var statearr_23495_23694 = state_23403__$1;
(statearr_23495_23694[(2)] = inst_23384);

(statearr_23495_23694[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (122))){
var inst_23311 = (state_23403[(33)]);
var inst_23318 = (state_23403[(39)]);
var inst_23317 = (state_23403[(38)]);
var inst_23330 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23331 = inst_23317.o;
var inst_23332 = [inst_23331];
var inst_23333 = cljs.core.PersistentHashMap.fromArrays(inst_23330,inst_23332);
var inst_23334 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23311,inst_23333);
var inst_23310 = inst_23318;
var inst_23311__$1 = inst_23334;
var state_23403__$1 = (function (){var statearr_23496 = state_23403;
(statearr_23496[(37)] = inst_23310);

(statearr_23496[(33)] = inst_23311__$1);

return statearr_23496;
})();
var statearr_23497_23695 = state_23403__$1;
(statearr_23497_23695[(2)] = null);

(statearr_23497_23695[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (43))){
var inst_23053 = (state_23403[(29)]);
var state_23403__$1 = state_23403;
var statearr_23498_23696 = state_23403__$1;
(statearr_23498_23696[(2)] = inst_23053);

(statearr_23498_23696[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (61))){
var inst_23089 = (state_23403[(51)]);
var inst_23146 = (state_23403[(2)]);
var inst_23147 = [inst_23146,offset_map];
var inst_23148 = (new cljs.core.PersistentVector(null,2,(5),inst_23089,inst_23147,null));
var state_23403__$1 = state_23403;
var statearr_23499_23697 = state_23403__$1;
(statearr_23499_23697[(2)] = inst_23148);

(statearr_23499_23697[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (29))){
var inst_23035 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23500_23698 = state_23403__$1;
(statearr_23500_23698[(2)] = inst_23035);

(statearr_23500_23698[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (44))){
var inst_23064 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23501_23699 = state_23403__$1;
(statearr_23501_23699[(2)] = inst_23064);

(statearr_23501_23699[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (93))){
var inst_23217 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23217)){
var statearr_23502_23700 = state_23403__$1;
(statearr_23502_23700[(1)] = (94));

} else {
var statearr_23503_23701 = state_23403__$1;
(statearr_23503_23701[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (6))){
var inst_22978 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22979 = (inst_22978 == null);
var state_23403__$1 = state_23403;
var statearr_23504_23702 = state_23403__$1;
(statearr_23504_23702[(2)] = inst_22979);

(statearr_23504_23702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (111))){
var state_23403__$1 = state_23403;
var statearr_23505_23703 = state_23403__$1;
(statearr_23505_23703[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (28))){
var inst_23022 = (state_23403[(18)]);
var state_23403__$1 = state_23403;
var statearr_23507_23704 = state_23403__$1;
(statearr_23507_23704[(2)] = inst_23022);

(statearr_23507_23704[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (134))){
var inst_23016 = (state_23403[(16)]);
var inst_23373 = (state_23403[(10)]);
var inst_23372 = (state_23403[(50)]);
var inst_23387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23388 = cljs.core.first(inst_23372);
var inst_23389 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_23016,inst_23388);
var inst_23390 = [inst_23389,inst_23373];
var inst_23391 = (new cljs.core.PersistentVector(null,2,(5),inst_23387,inst_23390,null));
var state_23403__$1 = state_23403;
var statearr_23508_23705 = state_23403__$1;
(statearr_23508_23705[(2)] = inst_23391);

(statearr_23508_23705[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (64))){
var inst_23144 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23509_23706 = state_23403__$1;
(statearr_23509_23706[(2)] = inst_23144);

(statearr_23509_23706[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (103))){
var inst_23239 = (state_23403[(40)]);
var inst_23233 = (state_23403[(32)]);
var inst_23256 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23257 = inst_23239.o;
var inst_23258 = [inst_23257];
var inst_23259 = cljs.core.PersistentHashMap.fromArrays(inst_23256,inst_23258);
var inst_23260 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23233,inst_23259);
var state_23403__$1 = state_23403;
var statearr_23510_23707 = state_23403__$1;
(statearr_23510_23707[(2)] = inst_23260);

(statearr_23510_23707[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (51))){
var inst_23075 = (state_23403[(34)]);
var inst_23005 = (state_23403[(14)]);
var inst_23075__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23005);
var state_23403__$1 = (function (){var statearr_23511 = state_23403;
(statearr_23511[(34)] = inst_23075__$1);

return statearr_23511;
})();
if(cljs.core.truth_(inst_23075__$1)){
var statearr_23512_23708 = state_23403__$1;
(statearr_23512_23708[(1)] = (54));

} else {
var statearr_23513_23709 = state_23403__$1;
(statearr_23513_23709[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (25))){
var inst_23018 = (state_23403[(15)]);
var state_23403__$1 = state_23403;
var statearr_23514_23710 = state_23403__$1;
(statearr_23514_23710[(2)] = inst_23018);

(statearr_23514_23710[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (34))){
var inst_23018 = (state_23403[(15)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23018)){
var statearr_23515_23711 = state_23403__$1;
(statearr_23515_23711[(1)] = (39));

} else {
var statearr_23516_23712 = state_23403__$1;
(statearr_23516_23712[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (125))){
var inst_23016 = (state_23403[(16)]);
var inst_23017 = (state_23403[(13)]);
var inst_23005 = (state_23403[(14)]);
var inst_23023 = (state_23403[(17)]);
var inst_23018 = (state_23403[(15)]);
var inst_23022 = (state_23403[(18)]);
var inst_23020 = (state_23403[(19)]);
var inst_23019 = (state_23403[(20)]);
var inst_22990 = (state_23403[(42)]);
var inst_22975 = (state_23403[(35)]);
var inst_23021 = (state_23403[(21)]);
var inst_23352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23353 = (function (){var p = inst_23023;
var pred_spec__$1 = inst_22990;
var orderBy = inst_23021;
var multi_QMARK_ = inst_23018;
var limit = inst_23020;
var offset = inst_23022;
var map__22971 = inst_23017;
var k = inst_23016;
var compact_QMARK_ = inst_22975;
var pred_spec_SINGLEQUOTE_ = inst_23005;
var ref_QMARK_ = inst_23019;
return (function (p1__22962_SHARP_){
return p1__22962_SHARP_.o;
});
})();
var inst_23354 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_23353,flakes);
var inst_23355 = [inst_23354,offset_map];
var inst_23356 = (new cljs.core.PersistentVector(null,2,(5),inst_23352,inst_23355,null));
var state_23403__$1 = state_23403;
var statearr_23517_23713 = state_23403__$1;
(statearr_23517_23713[(2)] = inst_23356);

(statearr_23517_23713[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (17))){
var inst_23005 = (state_23403[(14)]);
var inst_23006 = (state_23403[(52)]);
var inst_23005__$1 = (state_23403[(2)]);
var inst_23006__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_23005__$1);
var state_23403__$1 = (function (){var statearr_23518 = state_23403;
(statearr_23518[(14)] = inst_23005__$1);

(statearr_23518[(52)] = inst_23006__$1);

return statearr_23518;
})();
if(cljs.core.truth_(inst_23006__$1)){
var statearr_23519_23714 = state_23403__$1;
(statearr_23519_23714[(1)] = (18));

} else {
var statearr_23520_23715 = state_23403__$1;
(statearr_23520_23715[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (3))){
var inst_23401 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23403__$1,inst_23401);
} else {
if((state_val_23404 === (12))){
var inst_22990 = (state_23403[(42)]);
var inst_22995 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22990,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_23403__$1 = state_23403;
var statearr_23521_23716 = state_23403__$1;
(statearr_23521_23716[(2)] = inst_22995);

(statearr_23521_23716[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (2))){
var inst_22976 = (state_23403[(11)]);
var _ = (function (){var statearr_23522 = state_23403;
(statearr_23522[(4)] = cljs.core.cons((5),(state_23403[(4)])));

return statearr_23522;
})();
var inst_22975 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22976__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23403__$1 = (function (){var statearr_23523 = state_23403;
(statearr_23523[(11)] = inst_22976__$1);

(statearr_23523[(35)] = inst_22975);

return statearr_23523;
})();
if(cljs.core.truth_(inst_22976__$1)){
var statearr_23524_23717 = state_23403__$1;
(statearr_23524_23717[(1)] = (6));

} else {
var statearr_23525_23718 = state_23403__$1;
(statearr_23525_23718[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (66))){
var inst_23088 = (state_23403[(53)]);
var inst_23119 = (state_23403[(7)]);
var inst_23122 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23088,inst_23119) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23088,inst_23119));
var state_23403__$1 = state_23403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23403__$1,(69),inst_23122);
} else {
if((state_val_23404 === (107))){
var inst_23253 = (state_23403[(27)]);
var inst_23273 = cljs.core.count(inst_23253);
var inst_23274 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_23273);
var state_23403__$1 = state_23403;
var statearr_23526_23719 = state_23403__$1;
(statearr_23526_23719[(2)] = inst_23274);

(statearr_23526_23719[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (23))){
var inst_23014 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23527_23720 = state_23403__$1;
(statearr_23527_23720[(2)] = inst_23014);

(statearr_23527_23720[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (47))){
var inst_23061 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23528_23721 = state_23403__$1;
(statearr_23528_23721[(2)] = inst_23061);

(statearr_23528_23721[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (35))){
var inst_23372 = (state_23403[(50)]);
var inst_23371 = (state_23403[(2)]);
var inst_23372__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23371,(0),null);
var inst_23373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23371,(1),null);
var inst_23374 = cljs.core.empty_QMARK_(inst_23372__$1);
var state_23403__$1 = (function (){var statearr_23529 = state_23403;
(statearr_23529[(10)] = inst_23373);

(statearr_23529[(50)] = inst_23372__$1);

return statearr_23529;
})();
if(inst_23374){
var statearr_23530_23722 = state_23403__$1;
(statearr_23530_23722[(1)] = (128));

} else {
var statearr_23531_23723 = state_23403__$1;
(statearr_23531_23723[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (127))){
var inst_23359 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23532_23724 = state_23403__$1;
(statearr_23532_23724[(2)] = inst_23359);

(statearr_23532_23724[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (82))){
var inst_23166 = (state_23403[(30)]);
var state_23403__$1 = state_23403;
var statearr_23533_23725 = state_23403__$1;
(statearr_23533_23725[(2)] = inst_23166);

(statearr_23533_23725[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (76))){
var inst_23152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23160 = flakes;
var inst_23161 = cljs.core.seq(inst_23160);
var inst_23162 = cljs.core.first(inst_23161);
var inst_23163 = cljs.core.next(inst_23161);
var inst_23164 = cljs.core.PersistentVector.EMPTY;
var inst_23165 = inst_23160;
var inst_23166 = inst_23164;
var state_23403__$1 = (function (){var statearr_23534 = state_23403;
(statearr_23534[(54)] = inst_23162);

(statearr_23534[(55)] = inst_23152);

(statearr_23534[(30)] = inst_23166);

(statearr_23534[(45)] = inst_23165);

(statearr_23534[(56)] = inst_23163);

return statearr_23534;
})();
var statearr_23535_23726 = state_23403__$1;
(statearr_23535_23726[(2)] = null);

(statearr_23535_23726[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (97))){
var inst_23232 = (state_23403[(48)]);
var inst_23239 = (state_23403[(40)]);
var inst_23238 = cljs.core.seq(inst_23232);
var inst_23239__$1 = cljs.core.first(inst_23238);
var inst_23240 = cljs.core.next(inst_23238);
var state_23403__$1 = (function (){var statearr_23536 = state_23403;
(statearr_23536[(46)] = inst_23240);

(statearr_23536[(40)] = inst_23239__$1);

return statearr_23536;
})();
if(cljs.core.truth_(inst_23239__$1)){
var statearr_23537_23727 = state_23403__$1;
(statearr_23537_23727[(1)] = (99));

} else {
var statearr_23538_23728 = state_23403__$1;
(statearr_23538_23728[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (19))){
var inst_23005 = (state_23403[(14)]);
var inst_23009 = (state_23403[(41)]);
var inst_23009__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_23005);
var state_23403__$1 = (function (){var statearr_23539 = state_23403;
(statearr_23539[(41)] = inst_23009__$1);

return statearr_23539;
})();
if(cljs.core.truth_(inst_23009__$1)){
var statearr_23540_23729 = state_23403__$1;
(statearr_23540_23729[(1)] = (21));

} else {
var statearr_23541_23730 = state_23403__$1;
(statearr_23541_23730[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (57))){
var inst_23005 = (state_23403[(14)]);
var inst_23085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23086 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_23087 = (new cljs.core.PersistentVector(null,3,(5),inst_23085,inst_23086,null));
var inst_23088 = cljs.core.select_keys(inst_23005,inst_23087);
var inst_23089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23097 = flakes;
var inst_23098 = cljs.core.seq(inst_23097);
var inst_23099 = cljs.core.first(inst_23098);
var inst_23100 = cljs.core.next(inst_23098);
var inst_23101 = cljs.core.PersistentVector.EMPTY;
var inst_23102 = inst_23097;
var inst_23103 = inst_23101;
var state_23403__$1 = (function (){var statearr_23542 = state_23403;
(statearr_23542[(57)] = inst_23099);

(statearr_23542[(51)] = inst_23089);

(statearr_23542[(24)] = inst_23102);

(statearr_23542[(58)] = inst_23100);

(statearr_23542[(53)] = inst_23088);

(statearr_23542[(9)] = inst_23103);

return statearr_23542;
})();
var statearr_23543_23731 = state_23403__$1;
(statearr_23543_23731[(2)] = null);

(statearr_23543_23731[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (68))){
var inst_23128 = (state_23403[(2)]);
var state_23403__$1 = (function (){var statearr_23544 = state_23403;
(statearr_23544[(22)] = inst_23128);

return statearr_23544;
})();
if(cljs.core.truth_(fuel)){
var statearr_23545_23732 = state_23403__$1;
(statearr_23545_23732[(1)] = (70));

} else {
var statearr_23546_23733 = state_23403__$1;
(statearr_23546_23733[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (11))){
var inst_22990 = (state_23403[(42)]);
var inst_22990__$1 = (state_23403[(2)]);
var inst_22992 = cljs.core.contains_QMARK_(inst_22990__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22993 = (!(inst_22992));
var state_23403__$1 = (function (){var statearr_23547 = state_23403;
(statearr_23547[(42)] = inst_22990__$1);

return statearr_23547;
})();
if(inst_22993){
var statearr_23548_23734 = state_23403__$1;
(statearr_23548_23734[(1)] = (12));

} else {
var statearr_23549_23735 = state_23403__$1;
(statearr_23549_23735[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (115))){
var inst_23349 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23551_23736 = state_23403__$1;
(statearr_23551_23736[(2)] = inst_23349);

(statearr_23551_23736[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (9))){
var inst_22984 = cljs.core.first(flakes);
var inst_22985 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22984);
var inst_22986 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22987 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22985,inst_22986);
var state_23403__$1 = state_23403;
var statearr_23552_23737 = state_23403__$1;
(statearr_23552_23737[(2)] = inst_22987);

(statearr_23552_23737[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (5))){
var _ = (function (){var statearr_23553 = state_23403;
(statearr_23553[(4)] = cljs.core.rest((state_23403[(4)])));

return statearr_23553;
})();
var state_23403__$1 = state_23403;
var ex23550 = (state_23403__$1[(2)]);
var statearr_23554_23738 = state_23403__$1;
(statearr_23554_23738[(5)] = ex23550);


if((ex23550 instanceof Error)){
var statearr_23555_23739 = state_23403__$1;
(statearr_23555_23739[(1)] = (4));

(statearr_23555_23739[(5)] = null);

} else {
throw ex23550;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (112))){
var inst_23361 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23556_23740 = state_23403__$1;
(statearr_23556_23740[(2)] = inst_23361);

(statearr_23556_23740[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (83))){
var inst_23206 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23557_23741 = state_23403__$1;
(statearr_23557_23741[(2)] = inst_23206);

(statearr_23557_23741[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (14))){
var inst_22990 = (state_23403[(42)]);
var inst_22998 = (state_23403[(2)]);
var inst_22999 = cljs.core.contains_QMARK_(inst_22990,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_23000 = (!(inst_22999));
var state_23403__$1 = (function (){var statearr_23558 = state_23403;
(statearr_23558[(36)] = inst_22998);

return statearr_23558;
})();
if(inst_23000){
var statearr_23559_23742 = state_23403__$1;
(statearr_23559_23742[(1)] = (15));

} else {
var statearr_23560_23743 = state_23403__$1;
(statearr_23560_23743[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (45))){
var inst_23016 = (state_23403[(16)]);
var inst_23020 = (state_23403[(19)]);
var inst_23056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_23016);
var inst_23057 = cljs.core.count(inst_23056);
var inst_23058 = (inst_23057 >= inst_23020);
var state_23403__$1 = state_23403;
var statearr_23561_23744 = state_23403__$1;
(statearr_23561_23744[(2)] = inst_23058);

(statearr_23561_23744[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (53))){
var inst_23083 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23083)){
var statearr_23562_23745 = state_23403__$1;
(statearr_23562_23745[(1)] = (57));

} else {
var statearr_23563_23746 = state_23403__$1;
(statearr_23563_23746[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (78))){
var inst_23365 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23564_23747 = state_23403__$1;
(statearr_23564_23747[(2)] = inst_23365);

(statearr_23564_23747[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (132))){
var state_23403__$1 = state_23403;
var statearr_23566_23748 = state_23403__$1;
(statearr_23566_23748[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (26))){
var inst_23038 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23038)){
var statearr_23568_23749 = state_23403__$1;
(statearr_23568_23749[(1)] = (33));

} else {
var statearr_23569_23750 = state_23403__$1;
(statearr_23569_23750[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (123))){
var inst_23311 = (state_23403[(33)]);
var inst_23318 = (state_23403[(39)]);
var tmp23565 = inst_23311;
var inst_23310 = inst_23318;
var inst_23311__$1 = tmp23565;
var state_23403__$1 = (function (){var statearr_23570 = state_23403;
(statearr_23570[(37)] = inst_23310);

(statearr_23570[(33)] = inst_23311__$1);

return statearr_23570;
})();
var statearr_23571_23751 = state_23403__$1;
(statearr_23571_23751[(2)] = null);

(statearr_23571_23751[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (16))){
var inst_22998 = (state_23403[(36)]);
var state_23403__$1 = state_23403;
var statearr_23572_23752 = state_23403__$1;
(statearr_23572_23752[(2)] = inst_22998);

(statearr_23572_23752[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (133))){
var inst_23396 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23573_23753 = state_23403__$1;
(statearr_23573_23753[(2)] = inst_23396);

(statearr_23573_23753[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (81))){
var inst_23181 = (state_23403[(59)]);
var inst_23005 = (state_23403[(14)]);
var inst_23172 = (state_23403[(28)]);
var inst_23175 = cljs.core.deref(cache);
var inst_23176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23177 = inst_23172.o;
var inst_23178 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_23005);
var inst_23179 = [inst_23177,inst_23178];
var inst_23180 = (new cljs.core.PersistentVector(null,2,(5),inst_23176,inst_23179,null));
var inst_23181__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23175,inst_23180);
var state_23403__$1 = (function (){var statearr_23574 = state_23403;
(statearr_23574[(59)] = inst_23181__$1);

return statearr_23574;
})();
if(cljs.core.truth_(inst_23181__$1)){
var statearr_23575_23754 = state_23403__$1;
(statearr_23575_23754[(1)] = (84));

} else {
var statearr_23576_23755 = state_23403__$1;
(statearr_23576_23755[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (120))){
var inst_23345 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23577_23756 = state_23403__$1;
(statearr_23577_23756[(2)] = inst_23345);

(statearr_23577_23756[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (79))){
var inst_23172 = (state_23403[(28)]);
var inst_23165 = (state_23403[(45)]);
var inst_23171 = cljs.core.seq(inst_23165);
var inst_23172__$1 = cljs.core.first(inst_23171);
var inst_23173 = cljs.core.next(inst_23171);
var state_23403__$1 = (function (){var statearr_23578 = state_23403;
(statearr_23578[(28)] = inst_23172__$1);

(statearr_23578[(44)] = inst_23173);

return statearr_23578;
})();
if(cljs.core.truth_(inst_23172__$1)){
var statearr_23579_23757 = state_23403__$1;
(statearr_23579_23757[(1)] = (81));

} else {
var statearr_23580_23758 = state_23403__$1;
(statearr_23580_23758[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (38))){
var inst_23040 = (state_23403[(43)]);
var inst_23048 = (state_23403[(2)]);
var inst_23049 = [null,inst_23048];
var inst_23050 = (new cljs.core.PersistentVector(null,2,(5),inst_23040,inst_23049,null));
var state_23403__$1 = state_23403;
var statearr_23581_23759 = state_23403__$1;
(statearr_23581_23759[(2)] = inst_23050);

(statearr_23581_23759[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (126))){
var state_23403__$1 = state_23403;
var statearr_23582_23760 = state_23403__$1;
(statearr_23582_23760[(2)] = null);

(statearr_23582_23760[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (98))){
var inst_23219 = (state_23403[(60)]);
var inst_23283 = (state_23403[(2)]);
var inst_23284 = [inst_23283,offset_map];
var inst_23285 = (new cljs.core.PersistentVector(null,2,(5),inst_23219,inst_23284,null));
var state_23403__$1 = state_23403;
var statearr_23583_23761 = state_23403__$1;
(statearr_23583_23761[(2)] = inst_23285);

(statearr_23583_23761[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (124))){
var inst_23339 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23584_23762 = state_23403__$1;
(statearr_23584_23762[(2)] = inst_23339);

(statearr_23584_23762[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (87))){
var inst_23005 = (state_23403[(14)]);
var inst_23172 = (state_23403[(28)]);
var inst_23188 = (state_23403[(2)]);
var inst_23189 = fluree.db.util.async.throw_err(inst_23188);
var inst_23190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23191 = inst_23172.o;
var inst_23192 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_23005);
var inst_23193 = [inst_23191,inst_23192];
var inst_23194 = (new cljs.core.PersistentVector(null,2,(5),inst_23190,inst_23193,null));
var inst_23195 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_23194,inst_23189);
var state_23403__$1 = (function (){var statearr_23585 = state_23403;
(statearr_23585[(61)] = inst_23195);

return statearr_23585;
})();
var statearr_23586_23763 = state_23403__$1;
(statearr_23586_23763[(2)] = inst_23189);

(statearr_23586_23763[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (30))){
var inst_23023 = (state_23403[(17)]);
var inst_23028 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_23023);
var inst_23029 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_23028);
var state_23403__$1 = state_23403;
var statearr_23587_23764 = state_23403__$1;
(statearr_23587_23764[(2)] = inst_23029);

(statearr_23587_23764[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (73))){
var inst_23128 = (state_23403[(22)]);
var inst_23103 = (state_23403[(9)]);
var inst_23137 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23103,inst_23128);
var state_23403__$1 = state_23403;
var statearr_23588_23765 = state_23403__$1;
(statearr_23588_23765[(2)] = inst_23137);

(statearr_23588_23765[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (96))){
var inst_23363 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
var statearr_23589_23766 = state_23403__$1;
(statearr_23589_23766[(2)] = inst_23363);

(statearr_23589_23766[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (10))){
var state_23403__$1 = state_23403;
var statearr_23590_23767 = state_23403__$1;
(statearr_23590_23767[(2)] = pred_spec);

(statearr_23590_23767[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (18))){
var inst_23006 = (state_23403[(52)]);
var state_23403__$1 = state_23403;
var statearr_23591_23768 = state_23403__$1;
(statearr_23591_23768[(2)] = inst_23006);

(statearr_23591_23768[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (105))){
var inst_23271 = (state_23403[(2)]);
var state_23403__$1 = (function (){var statearr_23592 = state_23403;
(statearr_23592[(47)] = inst_23271);

return statearr_23592;
})();
if(cljs.core.truth_(fuel)){
var statearr_23593_23769 = state_23403__$1;
(statearr_23593_23769[(1)] = (107));

} else {
var statearr_23594_23770 = state_23403__$1;
(statearr_23594_23770[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (52))){
var inst_23073 = (state_23403[(62)]);
var state_23403__$1 = state_23403;
var statearr_23595_23771 = state_23403__$1;
(statearr_23595_23771[(2)] = inst_23073);

(statearr_23595_23771[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (114))){
var inst_23305 = flakes;
var inst_23306 = cljs.core.seq(inst_23305);
var inst_23307 = cljs.core.first(inst_23306);
var inst_23308 = cljs.core.next(inst_23306);
var inst_23309 = cljs.core.PersistentVector.EMPTY;
var inst_23310 = inst_23305;
var inst_23311 = inst_23309;
var state_23403__$1 = (function (){var statearr_23596 = state_23403;
(statearr_23596[(63)] = inst_23307);

(statearr_23596[(37)] = inst_23310);

(statearr_23596[(33)] = inst_23311);

(statearr_23596[(64)] = inst_23308);

return statearr_23596;
})();
var statearr_23597_23772 = state_23403__$1;
(statearr_23597_23772[(2)] = null);

(statearr_23597_23772[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (67))){
var state_23403__$1 = state_23403;
var statearr_23598_23773 = state_23403__$1;
(statearr_23598_23773[(2)] = null);

(statearr_23598_23773[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (71))){
var state_23403__$1 = state_23403;
var statearr_23599_23774 = state_23403__$1;
(statearr_23599_23774[(2)] = null);

(statearr_23599_23774[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (42))){
var inst_23020 = (state_23403[(19)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_23020)){
var statearr_23600_23775 = state_23403__$1;
(statearr_23600_23775[(1)] = (45));

} else {
var statearr_23601_23776 = state_23403__$1;
(statearr_23601_23776[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (80))){
var inst_23152 = (state_23403[(55)]);
var inst_23208 = (state_23403[(2)]);
var inst_23209 = [inst_23208,offset_map];
var inst_23210 = (new cljs.core.PersistentVector(null,2,(5),inst_23152,inst_23209,null));
var state_23403__$1 = state_23403;
var statearr_23602_23777 = state_23403__$1;
(statearr_23602_23777[(2)] = inst_23210);

(statearr_23602_23777[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (37))){
var inst_23023 = (state_23403[(17)]);
var inst_23022 = (state_23403[(18)]);
var inst_23045 = (inst_23022 - (1));
var inst_23046 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_23023,inst_23045);
var state_23403__$1 = state_23403;
var statearr_23603_23778 = state_23403__$1;
(statearr_23603_23778[(2)] = inst_23046);

(statearr_23603_23778[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (63))){
var inst_23103 = (state_23403[(9)]);
var state_23403__$1 = state_23403;
var statearr_23604_23779 = state_23403__$1;
(statearr_23604_23779[(2)] = inst_23103);

(statearr_23604_23779[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (94))){
var inst_23219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23227 = flakes;
var inst_23228 = cljs.core.seq(inst_23227);
var inst_23229 = cljs.core.first(inst_23228);
var inst_23230 = cljs.core.next(inst_23228);
var inst_23231 = cljs.core.PersistentVector.EMPTY;
var inst_23232 = inst_23227;
var inst_23233 = inst_23231;
var state_23403__$1 = (function (){var statearr_23605 = state_23403;
(statearr_23605[(48)] = inst_23232);

(statearr_23605[(65)] = inst_23230);

(statearr_23605[(60)] = inst_23219);

(statearr_23605[(66)] = inst_23229);

(statearr_23605[(32)] = inst_23233);

return statearr_23605;
})();
var statearr_23606_23780 = state_23403__$1;
(statearr_23606_23780[(2)] = null);

(statearr_23606_23780[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (8))){
var inst_22982 = (state_23403[(2)]);
var state_23403__$1 = state_23403;
if(cljs.core.truth_(inst_22982)){
var statearr_23607_23781 = state_23403__$1;
(statearr_23607_23781[(1)] = (9));

} else {
var statearr_23608_23782 = state_23403__$1;
(statearr_23608_23782[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (49))){
var inst_23073 = (state_23403[(62)]);
var inst_23073__$1 = cljs.core.not(recur_QMARK_);
var state_23403__$1 = (function (){var statearr_23609 = state_23403;
(statearr_23609[(62)] = inst_23073__$1);

return statearr_23609;
})();
if(inst_23073__$1){
var statearr_23610_23783 = state_23403__$1;
(statearr_23610_23783[(1)] = (51));

} else {
var statearr_23611_23784 = state_23403__$1;
(statearr_23611_23784[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23404 === (84))){
var inst_23181 = (state_23403[(59)]);
var state_23403__$1 = state_23403;
var statearr_23612_23785 = state_23403__$1;
(statearr_23612_23785[(2)] = inst_23181);

(statearr_23612_23785[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_23613 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23613[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_23613[(1)] = (1));

return statearr_23613;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_23403){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23403);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23614){var ex__2730__auto__ = e23614;
var statearr_23615_23786 = state_23403;
(statearr_23615_23786[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23403[(4)]))){
var statearr_23616_23787 = state_23403;
(statearr_23616_23787[(1)] = cljs.core.first((state_23403[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23788 = state_23403;
state_23403 = G__23788;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_23403){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_23403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23617 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23617[(6)] = c__2749__auto__);

return statearr_23617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23948){
var state_val_23949 = (state_23948[(1)]);
if((state_val_23949 === (7))){
var inst_23943 = (state_23948[(2)]);
var _ = (function (){var statearr_23950 = state_23948;
(statearr_23950[(4)] = cljs.core.rest((state_23948[(4)])));

return statearr_23950;
})();
var state_23948__$1 = state_23948;
var statearr_23951_24033 = state_23948__$1;
(statearr_23951_24033[(2)] = inst_23943);

(statearr_23951_24033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (20))){
var inst_23870 = (state_23948[(7)]);
var state_23948__$1 = state_23948;
var statearr_23952_24034 = state_23948__$1;
(statearr_23952_24034[(2)] = inst_23870);

(statearr_23952_24034[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (27))){
var inst_23825 = (state_23948[(8)]);
var state_23948__$1 = state_23948;
if(cljs.core.truth_(inst_23825)){
var statearr_23953_24035 = state_23948__$1;
(statearr_23953_24035[(1)] = (29));

} else {
var statearr_23954_24036 = state_23948__$1;
(statearr_23954_24036[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (1))){
var state_23948__$1 = state_23948;
var statearr_23955_24037 = state_23948__$1;
(statearr_23955_24037[(2)] = null);

(statearr_23955_24037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (24))){
var inst_23826 = (state_23948[(9)]);
var state_23948__$1 = state_23948;
var statearr_23956_24038 = state_23948__$1;
(statearr_23956_24038[(2)] = inst_23826);

(statearr_23956_24038[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (39))){
var inst_23862 = (state_23948[(10)]);
var state_23948__$1 = state_23948;
var statearr_23957_24039 = state_23948__$1;
(statearr_23957_24039[(2)] = inst_23862);

(statearr_23957_24039[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (46))){
var inst_23827 = (state_23948[(11)]);
var state_23948__$1 = state_23948;
var statearr_23958_24040 = state_23948__$1;
(statearr_23958_24040[(2)] = inst_23827);

(statearr_23958_24040[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (4))){
var inst_23789 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
var statearr_23959_24041 = state_23948__$1;
(statearr_23959_24041[(2)] = inst_23789);

(statearr_23959_24041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (15))){
var inst_23838 = (state_23948[(12)]);
var inst_23844 = cljs.core.count(inst_23838);
var inst_23845 = fluree.db.query.fql.add_fuel(fuel,inst_23844,max_fuel);
var state_23948__$1 = state_23948;
var statearr_23960_24042 = state_23948__$1;
(statearr_23960_24042[(2)] = inst_23845);

(statearr_23960_24042[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (48))){
var inst_23814 = (state_23948[(13)]);
var inst_23807 = (state_23948[(14)]);
var inst_23929 = (state_23948[(15)]);
var inst_23937 = (state_23948[(2)]);
var inst_23938 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23807,inst_23937,inst_23929);
var inst_23806 = inst_23814;
var inst_23807__$1 = inst_23938;
var state_23948__$1 = (function (){var statearr_23961 = state_23948;
(statearr_23961[(16)] = inst_23806);

(statearr_23961[(14)] = inst_23807__$1);

return statearr_23961;
})();
var statearr_23962_24043 = state_23948__$1;
(statearr_23962_24043[(2)] = null);

(statearr_23962_24043[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (50))){
var inst_23829 = (state_23948[(17)]);
var state_23948__$1 = state_23948;
var statearr_23963_24044 = state_23948__$1;
(statearr_23963_24044[(2)] = inst_23829);

(statearr_23963_24044[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (21))){
var inst_23826 = (state_23948[(9)]);
var state_23948__$1 = state_23948;
if(cljs.core.truth_(inst_23826)){
var statearr_23965_24045 = state_23948__$1;
(statearr_23965_24045[(1)] = (23));

} else {
var statearr_23966_24046 = state_23948__$1;
(statearr_23966_24046[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (31))){
var inst_23886 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
if(cljs.core.truth_(inst_23886)){
var statearr_23967_24047 = state_23948__$1;
(statearr_23967_24047[(1)] = (32));

} else {
var statearr_23968_24048 = state_23948__$1;
(statearr_23968_24048[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (32))){
var inst_23862 = (state_23948[(10)]);
var inst_23869 = (state_23948[(18)]);
var inst_23861 = (state_23948[(19)]);
var inst_23888 = (inst_23861 + (1));
var tmp23964 = inst_23862;
var inst_23860 = inst_23869;
var inst_23861__$1 = inst_23888;
var inst_23862__$1 = tmp23964;
var state_23948__$1 = (function (){var statearr_23969 = state_23948;
(statearr_23969[(10)] = inst_23862__$1);

(statearr_23969[(19)] = inst_23861__$1);

(statearr_23969[(20)] = inst_23860);

return statearr_23969;
})();
var statearr_23970_24049 = state_23948__$1;
(statearr_23970_24049[(2)] = null);

(statearr_23970_24049[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (40))){
var state_23948__$1 = state_23948;
if(cljs.core.truth_(fuel)){
var statearr_23971_24050 = state_23948__$1;
(statearr_23971_24050[(1)] = (42));

} else {
var statearr_23972_24051 = state_23948__$1;
(statearr_23972_24051[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (33))){
var state_23948__$1 = state_23948;
var statearr_23973_24052 = state_23948__$1;
(statearr_23973_24052[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (13))){
var inst_23838 = (state_23948[(12)]);
var state_23948__$1 = state_23948;
var statearr_23975_24053 = state_23948__$1;
(statearr_23975_24053[(2)] = inst_23838);

(statearr_23975_24053[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (22))){
var inst_23879 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
if(cljs.core.truth_(inst_23879)){
var statearr_23976_24054 = state_23948__$1;
(statearr_23976_24054[(1)] = (26));

} else {
var statearr_23977_24055 = state_23948__$1;
(statearr_23977_24055[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (36))){
var state_23948__$1 = state_23948;
var statearr_23978_24056 = state_23948__$1;
(statearr_23978_24056[(2)] = null);

(statearr_23978_24056[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (41))){
var inst_23869 = (state_23948[(18)]);
var inst_23861 = (state_23948[(19)]);
var inst_23918 = (state_23948[(2)]);
var inst_23919 = (inst_23861 + (1));
var inst_23860 = inst_23869;
var inst_23861__$1 = inst_23919;
var inst_23862 = inst_23918;
var state_23948__$1 = (function (){var statearr_23979 = state_23948;
(statearr_23979[(10)] = inst_23862);

(statearr_23979[(19)] = inst_23861__$1);

(statearr_23979[(20)] = inst_23860);

return statearr_23979;
})();
var statearr_23980_24057 = state_23948__$1;
(statearr_23980_24057[(2)] = null);

(statearr_23980_24057[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (43))){
var state_23948__$1 = state_23948;
var statearr_23981_24058 = state_23948__$1;
(statearr_23981_24058[(2)] = null);

(statearr_23981_24058[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (29))){
var inst_23825 = (state_23948[(8)]);
var inst_23861 = (state_23948[(19)]);
var inst_23883 = (inst_23861 < inst_23825);
var state_23948__$1 = state_23948;
var statearr_23982_24059 = state_23948__$1;
(statearr_23982_24059[(2)] = inst_23883);

(statearr_23982_24059[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (44))){
var inst_23898 = (state_23948[(21)]);
var inst_23902 = (state_23948[(22)]);
var inst_23911 = (state_23948[(2)]);
var inst_23912 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23902,inst_23898) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23902,inst_23898));
var state_23948__$1 = (function (){var statearr_23983 = state_23948;
(statearr_23983[(23)] = inst_23911);

return statearr_23983;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23948__$1,(45),inst_23912);
} else {
if((state_val_23949 === (6))){
var inst_23813 = (state_23948[(24)]);
var inst_23806 = (state_23948[(16)]);
var inst_23812 = cljs.core.seq(inst_23806);
var inst_23813__$1 = cljs.core.first(inst_23812);
var inst_23814 = cljs.core.next(inst_23812);
var inst_23815 = cljs.core.not(inst_23813__$1);
var state_23948__$1 = (function (){var statearr_23984 = state_23948;
(statearr_23984[(24)] = inst_23813__$1);

(statearr_23984[(13)] = inst_23814);

return statearr_23984;
})();
if(inst_23815){
var statearr_23985_24060 = state_23948__$1;
(statearr_23985_24060[(1)] = (8));

} else {
var statearr_23986_24061 = state_23948__$1;
(statearr_23986_24061[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (28))){
var inst_23927 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
var statearr_23987_24062 = state_23948__$1;
(statearr_23987_24062[(2)] = inst_23927);

(statearr_23987_24062[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (51))){
var inst_23935 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
var statearr_23988_24063 = state_23948__$1;
(statearr_23988_24063[(2)] = inst_23935);

(statearr_23988_24063[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (25))){
var inst_23877 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
var statearr_23989_24064 = state_23948__$1;
(statearr_23989_24064[(2)] = inst_23877);

(statearr_23989_24064[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (34))){
var inst_23925 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
var statearr_23990_24065 = state_23948__$1;
(statearr_23990_24065[(2)] = inst_23925);

(statearr_23990_24065[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (17))){
var inst_23838 = (state_23948[(12)]);
var inst_23848 = (state_23948[(2)]);
var inst_23856 = cljs.core.seq(inst_23838);
var inst_23857 = cljs.core.first(inst_23856);
var inst_23858 = cljs.core.next(inst_23856);
var inst_23859 = cljs.core.PersistentVector.EMPTY;
var inst_23860 = inst_23838;
var inst_23861 = (0);
var inst_23862 = inst_23859;
var state_23948__$1 = (function (){var statearr_23991 = state_23948;
(statearr_23991[(25)] = inst_23858);

(statearr_23991[(10)] = inst_23862);

(statearr_23991[(26)] = inst_23848);

(statearr_23991[(19)] = inst_23861);

(statearr_23991[(20)] = inst_23860);

(statearr_23991[(27)] = inst_23857);

return statearr_23991;
})();
var statearr_23992_24066 = state_23948__$1;
(statearr_23992_24066[(2)] = null);

(statearr_23992_24066[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (3))){
var inst_23946 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23948__$1,inst_23946);
} else {
if((state_val_23949 === (12))){
var state_23948__$1 = state_23948;
var statearr_23993_24067 = state_23948__$1;
(statearr_23993_24067[(2)] = fuel);

(statearr_23993_24067[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (2))){
var _ = (function (){var statearr_23994 = state_23948;
(statearr_23994[(4)] = cljs.core.cons((5),(state_23948[(4)])));

return statearr_23994;
})();
var inst_23802 = reverse_refs_specs;
var inst_23803 = cljs.core.seq(inst_23802);
var inst_23804 = cljs.core.first(inst_23803);
var inst_23805 = cljs.core.next(inst_23803);
var inst_23806 = inst_23802;
var inst_23807 = null;
var state_23948__$1 = (function (){var statearr_23995 = state_23948;
(statearr_23995[(16)] = inst_23806);

(statearr_23995[(14)] = inst_23807);

(statearr_23995[(28)] = inst_23805);

(statearr_23995[(29)] = inst_23804);

return statearr_23995;
})();
var statearr_23996_24068 = state_23948__$1;
(statearr_23996_24068[(2)] = null);

(statearr_23996_24068[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (23))){
var inst_23826 = (state_23948[(9)]);
var inst_23861 = (state_23948[(19)]);
var inst_23874 = (inst_23861 >= inst_23826);
var state_23948__$1 = state_23948;
var statearr_23997_24069 = state_23948__$1;
(statearr_23997_24069[(2)] = inst_23874);

(statearr_23997_24069[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (47))){
var inst_23828 = (state_23948[(30)]);
var state_23948__$1 = state_23948;
if(cljs.core.truth_(inst_23828)){
var statearr_23998_24070 = state_23948__$1;
(statearr_23998_24070[(1)] = (49));

} else {
var statearr_23999_24071 = state_23948__$1;
(statearr_23999_24071[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (35))){
var inst_23868 = (state_23948[(31)]);
var inst_23892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23893 = [inst_23868];
var inst_23894 = (new cljs.core.PersistentVector(null,1,(5),inst_23892,inst_23893,null));
var inst_23895 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23894);
var state_23948__$1 = state_23948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23948__$1,(38),inst_23895);
} else {
if((state_val_23949 === (19))){
var inst_23827 = (state_23948[(11)]);
var inst_23929 = (state_23948[(2)]);
var state_23948__$1 = (function (){var statearr_24000 = state_23948;
(statearr_24000[(15)] = inst_23929);

return statearr_24000;
})();
if(cljs.core.truth_(inst_23827)){
var statearr_24001_24072 = state_23948__$1;
(statearr_24001_24072[(1)] = (46));

} else {
var statearr_24002_24073 = state_23948__$1;
(statearr_24002_24073[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (11))){
var inst_23838 = (state_23948[(12)]);
var inst_23835 = (state_23948[(2)]);
var inst_23836 = fluree.db.util.async.throw_err(inst_23835);
var inst_23837 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_23836);
var inst_23838__$1 = cljs.core.not_empty(inst_23837);
var state_23948__$1 = (function (){var statearr_24004 = state_23948;
(statearr_24004[(12)] = inst_23838__$1);

return statearr_24004;
})();
if(cljs.core.truth_(inst_23838__$1)){
var statearr_24005_24074 = state_23948__$1;
(statearr_24005_24074[(1)] = (12));

} else {
var statearr_24006_24075 = state_23948__$1;
(statearr_24006_24075[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (9))){
var inst_23813 = (state_23948[(24)]);
var inst_23823 = (state_23948[(32)]);
var inst_23822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23813,(0),null);
var inst_23823__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23813,(1),null);
var inst_23824 = cljs.core.__destructure_map(inst_23823__$1);
var inst_23825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23824,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23826 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23824,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23824,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23824,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_23829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23824,new cljs.core.Keyword(null,"p","p",151049309));
var inst_23830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23831 = [subject_id,inst_23822];
var inst_23832 = (new cljs.core.PersistentVector(null,2,(5),inst_23830,inst_23831,null));
var inst_23833 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_23832);
var state_23948__$1 = (function (){var statearr_24007 = state_23948;
(statearr_24007[(11)] = inst_23827);

(statearr_24007[(17)] = inst_23829);

(statearr_24007[(8)] = inst_23825);

(statearr_24007[(9)] = inst_23826);

(statearr_24007[(30)] = inst_23828);

(statearr_24007[(32)] = inst_23823__$1);

return statearr_24007;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23948__$1,(11),inst_23833);
} else {
if((state_val_23949 === (5))){
var _ = (function (){var statearr_24008 = state_23948;
(statearr_24008[(4)] = cljs.core.rest((state_23948[(4)])));

return statearr_24008;
})();
var state_23948__$1 = state_23948;
var ex24003 = (state_23948__$1[(2)]);
var statearr_24009_24076 = state_23948__$1;
(statearr_24009_24076[(5)] = ex24003);


if((ex24003 instanceof Error)){
var statearr_24010_24077 = state_23948__$1;
(statearr_24010_24077[(1)] = (4));

(statearr_24010_24077[(5)] = null);

} else {
throw ex24003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (14))){
var inst_23842 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
if(cljs.core.truth_(inst_23842)){
var statearr_24011_24078 = state_23948__$1;
(statearr_24011_24078[(1)] = (15));

} else {
var statearr_24012_24079 = state_23948__$1;
(statearr_24012_24079[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (45))){
var inst_23862 = (state_23948[(10)]);
var inst_23914 = (state_23948[(2)]);
var inst_23915 = fluree.db.util.async.throw_err(inst_23914);
var inst_23916 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23862,inst_23915);
var state_23948__$1 = state_23948;
var statearr_24013_24080 = state_23948__$1;
(statearr_24013_24080[(2)] = inst_23916);

(statearr_24013_24080[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (26))){
var inst_23862 = (state_23948[(10)]);
var state_23948__$1 = state_23948;
var statearr_24014_24081 = state_23948__$1;
(statearr_24014_24081[(2)] = inst_23862);

(statearr_24014_24081[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (16))){
var state_23948__$1 = state_23948;
var statearr_24015_24082 = state_23948__$1;
(statearr_24015_24082[(2)] = null);

(statearr_24015_24082[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (38))){
var inst_23898 = (state_23948[(21)]);
var inst_23823 = (state_23948[(32)]);
var inst_23897 = (state_23948[(2)]);
var inst_23898__$1 = fluree.db.util.async.throw_err(inst_23897);
var inst_23899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23900 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23901 = (new cljs.core.PersistentVector(null,4,(5),inst_23899,inst_23900,null));
var inst_23902 = cljs.core.select_keys(inst_23823,inst_23901);
var inst_23903 = cljs.core.empty_QMARK_(inst_23898__$1);
var state_23948__$1 = (function (){var statearr_24016 = state_23948;
(statearr_24016[(21)] = inst_23898__$1);

(statearr_24016[(22)] = inst_23902);

return statearr_24016;
})();
if(inst_23903){
var statearr_24017_24083 = state_23948__$1;
(statearr_24017_24083[(1)] = (39));

} else {
var statearr_24018_24084 = state_23948__$1;
(statearr_24018_24084[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (30))){
var inst_23825 = (state_23948[(8)]);
var state_23948__$1 = state_23948;
var statearr_24019_24085 = state_23948__$1;
(statearr_24019_24085[(2)] = inst_23825);

(statearr_24019_24085[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (10))){
var inst_23941 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
var statearr_24020_24086 = state_23948__$1;
(statearr_24020_24086[(2)] = inst_23941);

(statearr_24020_24086[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (18))){
var inst_23868 = (state_23948[(31)]);
var inst_23860 = (state_23948[(20)]);
var inst_23870 = (state_23948[(7)]);
var inst_23867 = cljs.core.seq(inst_23860);
var inst_23868__$1 = cljs.core.first(inst_23867);
var inst_23869 = cljs.core.next(inst_23867);
var inst_23870__$1 = cljs.core.not(inst_23868__$1);
var state_23948__$1 = (function (){var statearr_24021 = state_23948;
(statearr_24021[(31)] = inst_23868__$1);

(statearr_24021[(18)] = inst_23869);

(statearr_24021[(7)] = inst_23870__$1);

return statearr_24021;
})();
if(inst_23870__$1){
var statearr_24022_24087 = state_23948__$1;
(statearr_24022_24087[(1)] = (20));

} else {
var statearr_24023_24088 = state_23948__$1;
(statearr_24023_24088[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (42))){
var inst_23898 = (state_23948[(21)]);
var inst_23907 = cljs.core.count(inst_23898);
var inst_23908 = fluree.db.query.fql.add_fuel(fuel,inst_23907,max_fuel);
var state_23948__$1 = state_23948;
var statearr_24024_24089 = state_23948__$1;
(statearr_24024_24089[(2)] = inst_23908);

(statearr_24024_24089[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (37))){
var inst_23923 = (state_23948[(2)]);
var state_23948__$1 = state_23948;
var statearr_24025_24090 = state_23948__$1;
(statearr_24025_24090[(2)] = inst_23923);

(statearr_24025_24090[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (8))){
var inst_23807 = (state_23948[(14)]);
var state_23948__$1 = state_23948;
var statearr_24026_24091 = state_23948__$1;
(statearr_24026_24091[(2)] = inst_23807);

(statearr_24026_24091[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23949 === (49))){
var inst_23828 = (state_23948[(30)]);
var state_23948__$1 = state_23948;
var statearr_24027_24092 = state_23948__$1;
(statearr_24027_24092[(2)] = inst_23828);

(statearr_24027_24092[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____0 = (function (){
var statearr_24028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24028[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__);

(statearr_24028[(1)] = (1));

return statearr_24028;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____1 = (function (state_23948){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23948);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24029){var ex__2730__auto__ = e24029;
var statearr_24030_24093 = state_23948;
(statearr_24030_24093[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23948[(4)]))){
var statearr_24031_24094 = state_23948;
(statearr_24031_24094[(1)] = cljs.core.first((state_23948[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24095 = state_23948;
state_23948 = G__24095;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__ = function(state_23948){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____1.call(this,state_23948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24032 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24032[(6)] = c__2749__auto__);

return statearr_24032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__24096 = select_spec;
var map__24096__$1 = cljs.core.__destructure_map(map__24096);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24096__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24096__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24210){
var state_val_24211 = (state_24210[(1)]);
if((state_val_24211 === (7))){
var inst_24122 = flakes;
var inst_24123 = cljs.core.seq(inst_24122);
var inst_24124 = cljs.core.first(inst_24123);
var inst_24125 = cljs.core.next(inst_24123);
var inst_24126 = cljs.core.PersistentVector.EMPTY;
var inst_24127 = inst_24122;
var inst_24128 = (0);
var inst_24129 = inst_24126;
var state_24210__$1 = (function (){var statearr_24212 = state_24210;
(statearr_24212[(7)] = inst_24124);

(statearr_24212[(8)] = inst_24127);

(statearr_24212[(9)] = inst_24128);

(statearr_24212[(10)] = inst_24129);

(statearr_24212[(11)] = inst_24125);

return statearr_24212;
})();
var statearr_24213_24279 = state_24210__$1;
(statearr_24213_24279[(2)] = null);

(statearr_24213_24279[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (20))){
var state_24210__$1 = state_24210;
var statearr_24214_24280 = state_24210__$1;
(statearr_24214_24280[(2)] = results);

(statearr_24214_24280[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (27))){
var state_24210__$1 = state_24210;
var statearr_24215_24281 = state_24210__$1;
(statearr_24215_24281[(2)] = null);

(statearr_24215_24281[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (1))){
var state_24210__$1 = state_24210;
var statearr_24216_24282 = state_24210__$1;
(statearr_24216_24282[(2)] = null);

(statearr_24216_24282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (24))){
var state_24210__$1 = state_24210;
var statearr_24217_24283 = state_24210__$1;
(statearr_24217_24283[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (39))){
var inst_24129 = (state_24210[(10)]);
var inst_24191 = (state_24210[(12)]);
var inst_24136 = (state_24210[(13)]);
var inst_24194 = (state_24210[(2)]);
var inst_24195 = fluree.db.util.async.throw_err(inst_24194);
var inst_24196 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24129,inst_24195);
var inst_24127 = inst_24136;
var inst_24128 = inst_24191;
var inst_24129__$1 = inst_24196;
var state_24210__$1 = (function (){var statearr_24219 = state_24210;
(statearr_24219[(8)] = inst_24127);

(statearr_24219[(9)] = inst_24128);

(statearr_24219[(10)] = inst_24129__$1);

return statearr_24219;
})();
var statearr_24220_24284 = state_24210__$1;
(statearr_24220_24284[(2)] = null);

(statearr_24220_24284[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (4))){
var inst_24097 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24221_24285 = state_24210__$1;
(statearr_24221_24285[(2)] = inst_24097);

(statearr_24221_24285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (15))){
var inst_24110 = (state_24210[(14)]);
var state_24210__$1 = state_24210;
var statearr_24222_24286 = state_24210__$1;
(statearr_24222_24286[(2)] = inst_24110);

(statearr_24222_24286[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (21))){
var inst_24106 = (state_24210[(15)]);
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inst_24106)){
var statearr_24223_24287 = state_24210__$1;
(statearr_24223_24287[(1)] = (23));

} else {
var statearr_24224_24288 = state_24210__$1;
(statearr_24224_24288[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (31))){
var inst_24174 = (state_24210[(16)]);
var state_24210__$1 = state_24210;
var statearr_24225_24289 = state_24210__$1;
(statearr_24225_24289[(2)] = inst_24174);

(statearr_24225_24289[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (32))){
var inst_24166 = (state_24210[(17)]);
var inst_24180 = (state_24210[(2)]);
var state_24210__$1 = (function (){var statearr_24226 = state_24210;
(statearr_24226[(18)] = inst_24180);

return statearr_24226;
})();
if(cljs.core.truth_(inst_24166)){
var statearr_24227_24290 = state_24210__$1;
(statearr_24227_24290[(1)] = (33));

} else {
var statearr_24228_24291 = state_24210__$1;
(statearr_24228_24291[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (33))){
var inst_24166 = (state_24210[(17)]);
var state_24210__$1 = state_24210;
var statearr_24229_24292 = state_24210__$1;
(statearr_24229_24292[(2)] = inst_24166);

(statearr_24229_24292[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (13))){
var inst_24146 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inst_24146)){
var statearr_24231_24293 = state_24210__$1;
(statearr_24231_24293[(1)] = (17));

} else {
var statearr_24232_24294 = state_24210__$1;
(statearr_24232_24294[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (22))){
var inst_24163 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24233_24295 = state_24210__$1;
(statearr_24233_24295[(2)] = inst_24163);

(statearr_24233_24295[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (36))){
var inst_24128 = (state_24210[(9)]);
var inst_24129 = (state_24210[(10)]);
var inst_24136 = (state_24210[(13)]);
var inst_24188 = (inst_24128 + (1));
var tmp24230 = inst_24129;
var inst_24127 = inst_24136;
var inst_24128__$1 = inst_24188;
var inst_24129__$1 = tmp24230;
var state_24210__$1 = (function (){var statearr_24234 = state_24210;
(statearr_24234[(8)] = inst_24127);

(statearr_24234[(9)] = inst_24128__$1);

(statearr_24234[(10)] = inst_24129__$1);

return statearr_24234;
})();
var statearr_24235_24296 = state_24210__$1;
(statearr_24235_24296[(2)] = null);

(statearr_24235_24296[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (29))){
var inst_24173 = (state_24210[(2)]);
var inst_24174 = fluree.db.util.async.throw_err(inst_24173);
var state_24210__$1 = (function (){var statearr_24236 = state_24210;
(statearr_24236[(16)] = inst_24174);

return statearr_24236;
})();
if(cljs.core.truth_(fuel)){
var statearr_24237_24297 = state_24210__$1;
(statearr_24237_24297[(1)] = (30));

} else {
var statearr_24238_24298 = state_24210__$1;
(statearr_24238_24298[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (6))){
var state_24210__$1 = state_24210;
var statearr_24239_24299 = state_24210__$1;
(statearr_24239_24299[(2)] = results);

(statearr_24239_24299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (28))){
var inst_24159 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24240_24300 = state_24210__$1;
(statearr_24240_24300[(2)] = inst_24159);

(statearr_24240_24300[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (25))){
var inst_24161 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24241_24301 = state_24210__$1;
(statearr_24241_24301[(2)] = inst_24161);

(statearr_24241_24301[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (34))){
var inst_24180 = (state_24210[(18)]);
var inst_24183 = cljs.core.empty_QMARK_(inst_24180);
var state_24210__$1 = state_24210;
var statearr_24242_24302 = state_24210__$1;
(statearr_24242_24302[(2)] = inst_24183);

(statearr_24242_24302[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (17))){
var inst_24129 = (state_24210[(10)]);
var inst_24148 = cljs.core.empty_QMARK_(inst_24129);
var state_24210__$1 = state_24210;
if(inst_24148){
var statearr_24243_24303 = state_24210__$1;
(statearr_24243_24303[(1)] = (20));

} else {
var statearr_24244_24304 = state_24210__$1;
(statearr_24244_24304[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (3))){
var inst_24208 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24210__$1,inst_24208);
} else {
if((state_val_24211 === (12))){
var inst_24110 = (state_24210[(14)]);
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inst_24110)){
var statearr_24245_24305 = state_24210__$1;
(statearr_24245_24305[(1)] = (14));

} else {
var statearr_24246_24306 = state_24210__$1;
(statearr_24246_24306[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (2))){
var _ = (function (){var statearr_24247 = state_24210;
(statearr_24247[(4)] = cljs.core.cons((5),(state_24210[(4)])));

return statearr_24247;
})();
var inst_24104 = select_spec;
var inst_24105 = cljs.core.__destructure_map(inst_24104);
var inst_24106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24105,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_24107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24105,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_24108 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24105,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_24109 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24105,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_24110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24105,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_24111 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_24112 = (inst_24109 > inst_24111);
var state_24210__$1 = (function (){var statearr_24248 = state_24210;
(statearr_24248[(14)] = inst_24110);

(statearr_24248[(19)] = inst_24108);

(statearr_24248[(20)] = inst_24107);

(statearr_24248[(15)] = inst_24106);

return statearr_24248;
})();
if(cljs.core.truth_(inst_24112)){
var statearr_24249_24307 = state_24210__$1;
(statearr_24249_24307[(1)] = (6));

} else {
var statearr_24250_24308 = state_24210__$1;
(statearr_24250_24308[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (23))){
var inst_24107 = (state_24210[(20)]);
var inst_24129 = (state_24210[(10)]);
var inst_24152 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_24107,inst_24129);
var state_24210__$1 = state_24210;
var statearr_24251_24309 = state_24210__$1;
(statearr_24251_24309[(2)] = inst_24152);

(statearr_24251_24309[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (35))){
var inst_24135 = (state_24210[(21)]);
var inst_24185 = (state_24210[(2)]);
var inst_24186 = fluree.db.query.fql.recur_select_spec(select_spec,inst_24135);
var state_24210__$1 = (function (){var statearr_24252 = state_24210;
(statearr_24252[(22)] = inst_24186);

return statearr_24252;
})();
if(cljs.core.truth_(inst_24185)){
var statearr_24253_24310 = state_24210__$1;
(statearr_24253_24310[(1)] = (36));

} else {
var statearr_24254_24311 = state_24210__$1;
(statearr_24254_24311[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (19))){
var inst_24201 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24255_24312 = state_24210__$1;
(statearr_24255_24312[(2)] = inst_24201);

(statearr_24255_24312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (11))){
var inst_24137 = (state_24210[(23)]);
var state_24210__$1 = state_24210;
var statearr_24257_24313 = state_24210__$1;
(statearr_24257_24313[(2)] = inst_24137);

(statearr_24257_24313[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (9))){
var inst_24137 = (state_24210[(23)]);
var inst_24135 = (state_24210[(21)]);
var inst_24127 = (state_24210[(8)]);
var inst_24134 = cljs.core.seq(inst_24127);
var inst_24135__$1 = cljs.core.first(inst_24134);
var inst_24136 = cljs.core.next(inst_24134);
var inst_24137__$1 = cljs.core.not(inst_24135__$1);
var state_24210__$1 = (function (){var statearr_24258 = state_24210;
(statearr_24258[(23)] = inst_24137__$1);

(statearr_24258[(21)] = inst_24135__$1);

(statearr_24258[(13)] = inst_24136);

return statearr_24258;
})();
if(inst_24137__$1){
var statearr_24259_24314 = state_24210__$1;
(statearr_24259_24314[(1)] = (11));

} else {
var statearr_24260_24315 = state_24210__$1;
(statearr_24260_24315[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (5))){
var _ = (function (){var statearr_24261 = state_24210;
(statearr_24261[(4)] = cljs.core.rest((state_24210[(4)])));

return statearr_24261;
})();
var state_24210__$1 = state_24210;
var ex24256 = (state_24210__$1[(2)]);
var statearr_24262_24316 = state_24210__$1;
(statearr_24262_24316[(5)] = ex24256);


if((ex24256 instanceof Error)){
var statearr_24263_24317 = state_24210__$1;
(statearr_24263_24317[(1)] = (4));

(statearr_24263_24317[(5)] = null);

} else {
throw ex24256;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (14))){
var inst_24110 = (state_24210[(14)]);
var inst_24128 = (state_24210[(9)]);
var inst_24141 = (inst_24128 < inst_24110);
var state_24210__$1 = state_24210;
var statearr_24264_24318 = state_24210__$1;
(statearr_24264_24318[(2)] = inst_24141);

(statearr_24264_24318[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (26))){
var inst_24107 = (state_24210[(20)]);
var inst_24129 = (state_24210[(10)]);
var inst_24155 = cljs.core.first(inst_24129);
var inst_24156 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_24107,inst_24155);
var state_24210__$1 = state_24210;
var statearr_24265_24319 = state_24210__$1;
(statearr_24265_24319[(2)] = inst_24156);

(statearr_24265_24319[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (16))){
var inst_24144 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24266_24320 = state_24210__$1;
(statearr_24266_24320[(2)] = inst_24144);

(statearr_24266_24320[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (38))){
var inst_24199 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24267_24321 = state_24210__$1;
(statearr_24267_24321[(2)] = inst_24199);

(statearr_24267_24321[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (30))){
var inst_24174 = (state_24210[(16)]);
var inst_24176 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_24177 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_24176,inst_24174);
var state_24210__$1 = state_24210;
var statearr_24268_24322 = state_24210__$1;
(statearr_24268_24322[(2)] = inst_24177);

(statearr_24268_24322[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (10))){
var inst_24203 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24269_24323 = state_24210__$1;
(statearr_24269_24323[(2)] = inst_24203);

(statearr_24269_24323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (18))){
var inst_24108 = (state_24210[(19)]);
var inst_24135 = (state_24210[(21)]);
var inst_24165 = inst_24135.o;
var inst_24166 = cljs.core.contains_QMARK_(inst_24108,inst_24165);
var inst_24168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24169 = [inst_24165];
var inst_24170 = (new cljs.core.PersistentVector(null,1,(5),inst_24168,inst_24169,null));
var inst_24171 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24170);
var state_24210__$1 = (function (){var statearr_24270 = state_24210;
(statearr_24270[(17)] = inst_24166);

return statearr_24270;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24210__$1,(29),inst_24171);
} else {
if((state_val_24211 === (37))){
var inst_24128 = (state_24210[(9)]);
var inst_24180 = (state_24210[(18)]);
var inst_24186 = (state_24210[(22)]);
var inst_24191 = (inst_24128 + (1));
var inst_24192 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_24186,inst_24180) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_24186,inst_24180));
var state_24210__$1 = (function (){var statearr_24271 = state_24210;
(statearr_24271[(12)] = inst_24191);

return statearr_24271;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24210__$1,(39),inst_24192);
} else {
if((state_val_24211 === (8))){
var inst_24205 = (state_24210[(2)]);
var _ = (function (){var statearr_24272 = state_24210;
(statearr_24272[(4)] = cljs.core.rest((state_24210[(4)])));

return statearr_24272;
})();
var state_24210__$1 = state_24210;
var statearr_24273_24324 = state_24210__$1;
(statearr_24273_24324[(2)] = inst_24205);

(statearr_24273_24324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_24274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24274[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__);

(statearr_24274[(1)] = (1));

return statearr_24274;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____1 = (function (state_24210){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24210);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24275){var ex__2730__auto__ = e24275;
var statearr_24276_24325 = state_24210;
(statearr_24276_24325[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24210[(4)]))){
var statearr_24277_24326 = state_24210;
(statearr_24277_24326[(1)] = cljs.core.first((state_24210[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24327 = state_24210;
state_24210 = G__24327;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__ = function(state_24210){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____1.call(this,state_24210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24278 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24278[(6)] = c__2749__auto__);

return statearr_24278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24508){
var state_val_24509 = (state_24508[(1)]);
if((state_val_24509 === (7))){
var state_24508__$1 = state_24508;
var statearr_24510_24596 = state_24508__$1;
(statearr_24510_24596[(2)] = null);

(statearr_24510_24596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (20))){
var inst_24366 = cljs.core.PersistentHashMap.EMPTY;
var state_24508__$1 = state_24508;
var statearr_24511_24597 = state_24508__$1;
(statearr_24511_24597[(2)] = inst_24366);

(statearr_24511_24597[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (27))){
var inst_24384 = (state_24508[(7)]);
var inst_24354 = (state_24508[(8)]);
var inst_24368 = (state_24508[(9)]);
var inst_24348 = (state_24508[(10)]);
var inst_24487 = (state_24508[(2)]);
var inst_24488 = (function (){var top_level_subject = inst_24348;
var select_spec = inst_24354;
var base_acc = inst_24368;
var acc_PLUS_refs = inst_24384;
var result = inst_24487;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_24489 = cljs.core.PersistentVector.EMPTY;
var inst_24490 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24354);
var inst_24491 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_24490);
var inst_24492 = cljs.core.vals(inst_24491);
var inst_24493 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24354);
var inst_24494 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_24493);
var inst_24495 = cljs.core.vals(inst_24494);
var inst_24496 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24492,inst_24495);
var inst_24497 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_24488,inst_24489,inst_24496);
var inst_24499 = (function (){var top_level_subject = inst_24348;
var select_spec = inst_24354;
var base_acc = inst_24368;
var acc_PLUS_refs = inst_24384;
var result = inst_24487;
var sort_preds = inst_24497;
return (function (acc,p__24498){
var vec__24512 = p__24498;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24512,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24512,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24512,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24512,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_24500 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_24499,inst_24487,inst_24497);
var state_24508__$1 = state_24508;
var statearr_24515_24598 = state_24508__$1;
(statearr_24515_24598[(2)] = inst_24500);

(statearr_24515_24598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (1))){
var state_24508__$1 = state_24508;
var statearr_24516_24599 = state_24508__$1;
(statearr_24516_24599[(2)] = null);

(statearr_24516_24599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (24))){
var inst_24384 = (state_24508[(7)]);
var inst_24384__$1 = (state_24508[(2)]);
var inst_24385 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_24386 = cljs.core.PersistentHashMap.EMPTY;
var inst_24387 = inst_24385;
var inst_24388 = inst_24384__$1;
var inst_24389 = inst_24386;
var state_24508__$1 = (function (){var statearr_24517 = state_24508;
(statearr_24517[(7)] = inst_24384__$1);

(statearr_24517[(11)] = inst_24388);

(statearr_24517[(12)] = inst_24389);

(statearr_24517[(13)] = inst_24387);

return statearr_24517;
})();
var statearr_24518_24600 = state_24508__$1;
(statearr_24518_24600[(2)] = null);

(statearr_24518_24600[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (39))){
var inst_24388 = (state_24508[(11)]);
var inst_24397 = (state_24508[(14)]);
var inst_24354 = (state_24508[(8)]);
var inst_24404 = (state_24508[(15)]);
var inst_24433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24434 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_24388,inst_24354,inst_24397,inst_24404,false);
var state_24508__$1 = (function (){var statearr_24519 = state_24508;
(statearr_24519[(16)] = inst_24433);

return statearr_24519;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24508__$1,(42),inst_24434);
} else {
if((state_val_24509 === (46))){
var inst_24389 = (state_24508[(12)]);
var inst_24397 = (state_24508[(14)]);
var inst_24387 = (state_24508[(13)]);
var inst_24451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24452 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24453 = cljs.core.first(inst_24397);
var inst_24454 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24453);
var inst_24455 = [inst_24454];
var inst_24456 = cljs.core.PersistentHashMap.fromArrays(inst_24452,inst_24455);
var inst_24457 = cljs.core.rest(inst_24387);
var inst_24458 = [inst_24456,inst_24457,inst_24389];
var inst_24459 = (new cljs.core.PersistentVector(null,3,(5),inst_24451,inst_24458,null));
var state_24508__$1 = state_24508;
var statearr_24520_24601 = state_24508__$1;
(statearr_24520_24601[(2)] = inst_24459);

(statearr_24520_24601[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (4))){
var inst_24328 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
var statearr_24521_24602 = state_24508__$1;
(statearr_24521_24602[(2)] = inst_24328);

(statearr_24521_24602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (15))){
var inst_24355 = (state_24508[(17)]);
var inst_24354 = (state_24508[(8)]);
var inst_24354__$1 = (state_24508[(2)]);
var inst_24355__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24354__$1);
var state_24508__$1 = (function (){var statearr_24522 = state_24508;
(statearr_24522[(17)] = inst_24355__$1);

(statearr_24522[(8)] = inst_24354__$1);

return statearr_24522;
})();
if(cljs.core.truth_(inst_24355__$1)){
var statearr_24523_24603 = state_24508__$1;
(statearr_24523_24603[(1)] = (16));

} else {
var statearr_24524_24604 = state_24508__$1;
(statearr_24524_24604[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (48))){
var inst_24470 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
var statearr_24525_24605 = state_24508__$1;
(statearr_24525_24605[(2)] = inst_24470);

(statearr_24525_24605[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (50))){
var state_24508__$1 = state_24508;
var statearr_24526_24606 = state_24508__$1;
(statearr_24526_24606[(2)] = null);

(statearr_24526_24606[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (21))){
var inst_24354 = (state_24508[(8)]);
var inst_24368 = (state_24508[(2)]);
var inst_24369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24370 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_24371 = (new cljs.core.PersistentVector(null,2,(5),inst_24369,inst_24370,null));
var inst_24372 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_24354,inst_24371);
var state_24508__$1 = (function (){var statearr_24527 = state_24508;
(statearr_24527[(9)] = inst_24368);

return statearr_24527;
})();
if(cljs.core.truth_(inst_24372)){
var statearr_24528_24607 = state_24508__$1;
(statearr_24528_24607[(1)] = (22));

} else {
var statearr_24529_24608 = state_24508__$1;
(statearr_24529_24608[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (31))){
var inst_24388 = (state_24508[(11)]);
var inst_24397 = (state_24508[(14)]);
var inst_24403 = (state_24508[(18)]);
var inst_24407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24408 = fluree.db.query.fql.flake__GT_recur(db,inst_24397,inst_24403,inst_24388,fuel,max_fuel,cache);
var state_24508__$1 = (function (){var statearr_24530 = state_24508;
(statearr_24530[(19)] = inst_24407);

return statearr_24530;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24508__$1,(34),inst_24408);
} else {
if((state_val_24509 === (32))){
var inst_24403 = (state_24508[(18)]);
var state_24508__$1 = state_24508;
if(cljs.core.truth_(inst_24403)){
var statearr_24531_24609 = state_24508__$1;
(statearr_24531_24609[(1)] = (35));

} else {
var statearr_24532_24610 = state_24508__$1;
(statearr_24532_24610[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (40))){
var inst_24444 = (state_24508[(20)]);
var inst_24354 = (state_24508[(8)]);
var inst_24443 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24354);
var inst_24444__$1 = cljs.core.empty_QMARK_(inst_24443);
var state_24508__$1 = (function (){var statearr_24533 = state_24508;
(statearr_24533[(20)] = inst_24444__$1);

return statearr_24533;
})();
if(inst_24444__$1){
var statearr_24534_24611 = state_24508__$1;
(statearr_24534_24611[(1)] = (43));

} else {
var statearr_24535_24612 = state_24508__$1;
(statearr_24535_24612[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (33))){
var inst_24397 = (state_24508[(14)]);
var inst_24476 = (state_24508[(2)]);
var inst_24477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24476,(0),null);
var inst_24478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24476,(1),null);
var inst_24479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24476,(2),null);
var inst_24480 = cljs.core.first(inst_24397);
var inst_24481 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24480);
var inst_24482 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24477,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24481);
var inst_24387 = inst_24478;
var inst_24388 = inst_24482;
var inst_24389 = inst_24479;
var state_24508__$1 = (function (){var statearr_24536 = state_24508;
(statearr_24536[(11)] = inst_24388);

(statearr_24536[(12)] = inst_24389);

(statearr_24536[(13)] = inst_24387);

return statearr_24536;
})();
var statearr_24537_24613 = state_24508__$1;
(statearr_24537_24613[(2)] = null);

(statearr_24537_24613[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (13))){
var inst_24348 = (state_24508[(10)]);
var inst_24351 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_24348);
var state_24508__$1 = state_24508;
var statearr_24538_24614 = state_24508__$1;
(statearr_24538_24614[(2)] = inst_24351);

(statearr_24538_24614[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (22))){
var inst_24354 = (state_24508[(8)]);
var inst_24374 = cljs.core.first(flakes);
var inst_24375 = fluree.db.query.fql.s(inst_24374);
var inst_24376 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_24354);
var inst_24377 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_24375,inst_24376);
var state_24508__$1 = state_24508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24508__$1,(25),inst_24377);
} else {
if((state_val_24509 === (36))){
var inst_24354 = (state_24508[(8)]);
var inst_24431 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24354);
var state_24508__$1 = state_24508;
if(cljs.core.truth_(inst_24431)){
var statearr_24539_24615 = state_24508__$1;
(statearr_24539_24615[(1)] = (39));

} else {
var statearr_24540_24616 = state_24508__$1;
(statearr_24540_24616[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (41))){
var inst_24472 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
var statearr_24541_24617 = state_24508__$1;
(statearr_24541_24617[(2)] = inst_24472);

(statearr_24541_24617[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (43))){
var inst_24354 = (state_24508[(8)]);
var inst_24446 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24354);
var state_24508__$1 = state_24508;
var statearr_24542_24618 = state_24508__$1;
(statearr_24542_24618[(2)] = inst_24446);

(statearr_24542_24618[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (29))){
var inst_24397 = (state_24508[(14)]);
var inst_24354 = (state_24508[(8)]);
var inst_24387 = (state_24508[(13)]);
var inst_24403 = (state_24508[(18)]);
var inst_24397__$1 = cljs.core.first(inst_24387);
var inst_24398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24399 = cljs.core.first(inst_24397__$1);
var inst_24400 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_24399);
var inst_24401 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_24400];
var inst_24402 = (new cljs.core.PersistentVector(null,3,(5),inst_24398,inst_24401,null));
var inst_24403__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_24354,inst_24402);
var inst_24404 = fluree.db.query.fql.component_follow_QMARK_(inst_24403__$1,inst_24354);
var inst_24405 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_24403__$1);
var state_24508__$1 = (function (){var statearr_24543 = state_24508;
(statearr_24543[(14)] = inst_24397__$1);

(statearr_24543[(18)] = inst_24403__$1);

(statearr_24543[(15)] = inst_24404);

return statearr_24543;
})();
if(cljs.core.truth_(inst_24405)){
var statearr_24544_24619 = state_24508__$1;
(statearr_24544_24619[(1)] = (31));

} else {
var statearr_24545_24620 = state_24508__$1;
(statearr_24545_24620[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (44))){
var inst_24444 = (state_24508[(20)]);
var state_24508__$1 = state_24508;
var statearr_24546_24621 = state_24508__$1;
(statearr_24546_24621[(2)] = inst_24444);

(statearr_24546_24621[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (6))){
var state_24508__$1 = state_24508;
var statearr_24547_24622 = state_24508__$1;
(statearr_24547_24622[(2)] = null);

(statearr_24547_24622[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (28))){
var inst_24388 = (state_24508[(11)]);
var state_24508__$1 = state_24508;
var statearr_24548_24623 = state_24508__$1;
(statearr_24548_24623[(2)] = inst_24388);

(statearr_24548_24623[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (51))){
var inst_24468 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
var statearr_24549_24624 = state_24508__$1;
(statearr_24549_24624[(2)] = inst_24468);

(statearr_24549_24624[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (25))){
var inst_24368 = (state_24508[(9)]);
var inst_24379 = (state_24508[(2)]);
var inst_24380 = fluree.db.util.async.throw_err(inst_24379);
var inst_24381 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_24368,inst_24380], 0));
var state_24508__$1 = state_24508;
var statearr_24550_24625 = state_24508__$1;
(statearr_24550_24625[(2)] = inst_24381);

(statearr_24550_24625[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (34))){
var inst_24407 = (state_24508[(19)]);
var inst_24389 = (state_24508[(12)]);
var inst_24387 = (state_24508[(13)]);
var inst_24410 = (state_24508[(2)]);
var inst_24411 = fluree.db.util.async.throw_err(inst_24410);
var inst_24412 = cljs.core.rest(inst_24387);
var inst_24413 = [inst_24411,inst_24412,inst_24389];
var inst_24414 = (new cljs.core.PersistentVector(null,3,(5),inst_24407,inst_24413,null));
var state_24508__$1 = state_24508;
var statearr_24551_24626 = state_24508__$1;
(statearr_24551_24626[(2)] = inst_24414);

(statearr_24551_24626[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (17))){
var inst_24354 = (state_24508[(8)]);
var inst_24358 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24354);
var state_24508__$1 = state_24508;
var statearr_24553_24627 = state_24508__$1;
(statearr_24553_24627[(2)] = inst_24358);

(statearr_24553_24627[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (3))){
var inst_24506 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24508__$1,inst_24506);
} else {
if((state_val_24509 === (12))){
var _ = (function (){var statearr_24554 = state_24508;
(statearr_24554[(4)] = cljs.core.rest((state_24508[(4)])));

return statearr_24554;
})();
var state_24508__$1 = state_24508;
var ex24552 = (state_24508__$1[(2)]);
var statearr_24555_24628 = state_24508__$1;
(statearr_24555_24628[(5)] = ex24552);


var statearr_24556_24629 = state_24508__$1;
(statearr_24556_24629[(1)] = (11));

(statearr_24556_24629[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (2))){
var _ = (function (){var statearr_24557 = state_24508;
(statearr_24557[(4)] = cljs.core.cons((5),(state_24508[(4)])));

return statearr_24557;
})();
var inst_24334 = cljs.core.not_empty(flakes);
var state_24508__$1 = state_24508;
if(cljs.core.truth_(inst_24334)){
var statearr_24558_24630 = state_24508__$1;
(statearr_24558_24630[(1)] = (6));

} else {
var statearr_24559_24631 = state_24508__$1;
(statearr_24559_24631[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (23))){
var inst_24368 = (state_24508[(9)]);
var state_24508__$1 = state_24508;
var statearr_24560_24632 = state_24508__$1;
(statearr_24560_24632[(2)] = inst_24368);

(statearr_24560_24632[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (47))){
var state_24508__$1 = state_24508;
var statearr_24561_24633 = state_24508__$1;
(statearr_24561_24633[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (35))){
var inst_24388 = (state_24508[(11)]);
var inst_24389 = (state_24508[(12)]);
var inst_24397 = (state_24508[(14)]);
var inst_24403 = (state_24508[(18)]);
var inst_24404 = (state_24508[(15)]);
var inst_24420 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_24388,inst_24403,inst_24397,inst_24404,false,inst_24389);
var state_24508__$1 = state_24508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24508__$1,(38),inst_24420);
} else {
if((state_val_24509 === (19))){
var inst_24348 = (state_24508[(10)]);
var inst_24362 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24363 = [inst_24348];
var inst_24364 = cljs.core.PersistentHashMap.fromArrays(inst_24362,inst_24363);
var state_24508__$1 = state_24508;
var statearr_24563_24634 = state_24508__$1;
(statearr_24563_24634[(2)] = inst_24364);

(statearr_24563_24634[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (11))){
var inst_24336 = (state_24508[(2)]);
var inst_24337 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_24336], 0));
var inst_24338 = (function(){throw inst_24336})();
var state_24508__$1 = (function (){var statearr_24565 = state_24508;
(statearr_24565[(21)] = inst_24337);

return statearr_24565;
})();
var statearr_24566_24635 = state_24508__$1;
(statearr_24566_24635[(2)] = inst_24338);

(statearr_24566_24635[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (9))){
var _ = (function (){var statearr_24567 = state_24508;
(statearr_24567[(4)] = cljs.core.cons((12),(state_24508[(4)])));

return statearr_24567;
})();
var inst_24344 = cljs.core.first(flakes);
var inst_24345 = fluree.db.query.fql.s(inst_24344);
var ___$1 = (function (){var statearr_24568 = state_24508;
(statearr_24568[(4)] = cljs.core.rest((state_24508[(4)])));

return statearr_24568;
})();
var state_24508__$1 = state_24508;
var statearr_24569_24636 = state_24508__$1;
(statearr_24569_24636[(2)] = inst_24345);

(statearr_24569_24636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (5))){
var _ = (function (){var statearr_24570 = state_24508;
(statearr_24570[(4)] = cljs.core.rest((state_24508[(4)])));

return statearr_24570;
})();
var state_24508__$1 = state_24508;
var ex24564 = (state_24508__$1[(2)]);
var statearr_24571_24637 = state_24508__$1;
(statearr_24571_24637[(5)] = ex24564);


if((ex24564 instanceof Error)){
var statearr_24572_24638 = state_24508__$1;
(statearr_24572_24638[(1)] = (4));

(statearr_24572_24638[(5)] = null);

} else {
throw ex24564;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (14))){
var state_24508__$1 = state_24508;
var statearr_24573_24639 = state_24508__$1;
(statearr_24573_24639[(2)] = base_select_spec);

(statearr_24573_24639[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (45))){
var inst_24449 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
if(cljs.core.truth_(inst_24449)){
var statearr_24574_24640 = state_24508__$1;
(statearr_24574_24640[(1)] = (46));

} else {
var statearr_24575_24641 = state_24508__$1;
(statearr_24575_24641[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (26))){
var inst_24387 = (state_24508[(13)]);
var inst_24391 = cljs.core.empty_QMARK_(inst_24387);
var state_24508__$1 = state_24508;
if(inst_24391){
var statearr_24576_24642 = state_24508__$1;
(statearr_24576_24642[(1)] = (28));

} else {
var statearr_24577_24643 = state_24508__$1;
(statearr_24577_24643[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (16))){
var inst_24355 = (state_24508[(17)]);
var state_24508__$1 = state_24508;
var statearr_24578_24644 = state_24508__$1;
(statearr_24578_24644[(2)] = inst_24355);

(statearr_24578_24644[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (38))){
var inst_24387 = (state_24508[(13)]);
var inst_24422 = (state_24508[(2)]);
var inst_24423 = fluree.db.util.async.throw_err(inst_24422);
var inst_24424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24423,(0),null);
var inst_24425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24423,(1),null);
var inst_24426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24427 = cljs.core.rest(inst_24387);
var inst_24428 = [inst_24424,inst_24427,inst_24425];
var inst_24429 = (new cljs.core.PersistentVector(null,3,(5),inst_24426,inst_24428,null));
var state_24508__$1 = state_24508;
var statearr_24579_24645 = state_24508__$1;
(statearr_24579_24645[(2)] = inst_24429);

(statearr_24579_24645[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (30))){
var inst_24485 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
var statearr_24580_24646 = state_24508__$1;
(statearr_24580_24646[(2)] = inst_24485);

(statearr_24580_24646[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (10))){
var inst_24348 = (state_24508[(2)]);
var inst_24349 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_24508__$1 = (function (){var statearr_24581 = state_24508;
(statearr_24581[(10)] = inst_24348);

return statearr_24581;
})();
if(cljs.core.truth_(inst_24349)){
var statearr_24582_24647 = state_24508__$1;
(statearr_24582_24647[(1)] = (13));

} else {
var statearr_24583_24648 = state_24508__$1;
(statearr_24583_24648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (18))){
var inst_24360 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
if(cljs.core.truth_(inst_24360)){
var statearr_24584_24649 = state_24508__$1;
(statearr_24584_24649[(1)] = (19));

} else {
var statearr_24585_24650 = state_24508__$1;
(statearr_24585_24650[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (42))){
var inst_24389 = (state_24508[(12)]);
var inst_24387 = (state_24508[(13)]);
var inst_24433 = (state_24508[(16)]);
var inst_24436 = (state_24508[(2)]);
var inst_24437 = fluree.db.util.async.throw_err(inst_24436);
var inst_24438 = cljs.core.first(inst_24437);
var inst_24439 = cljs.core.rest(inst_24387);
var inst_24440 = [inst_24438,inst_24439,inst_24389];
var inst_24441 = (new cljs.core.PersistentVector(null,3,(5),inst_24433,inst_24440,null));
var state_24508__$1 = state_24508;
var statearr_24586_24651 = state_24508__$1;
(statearr_24586_24651[(2)] = inst_24441);

(statearr_24586_24651[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (37))){
var inst_24474 = (state_24508[(2)]);
var state_24508__$1 = state_24508;
var statearr_24587_24652 = state_24508__$1;
(statearr_24587_24652[(2)] = inst_24474);

(statearr_24587_24652[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (8))){
var inst_24503 = (state_24508[(2)]);
var _ = (function (){var statearr_24588 = state_24508;
(statearr_24588[(4)] = cljs.core.rest((state_24508[(4)])));

return statearr_24588;
})();
var state_24508__$1 = state_24508;
var statearr_24589_24653 = state_24508__$1;
(statearr_24589_24653[(2)] = inst_24503);

(statearr_24589_24653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24509 === (49))){
var inst_24388 = (state_24508[(11)]);
var inst_24389 = (state_24508[(12)]);
var inst_24387 = (state_24508[(13)]);
var inst_24462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24463 = cljs.core.rest(inst_24387);
var inst_24464 = [inst_24388,inst_24463,inst_24389];
var inst_24465 = (new cljs.core.PersistentVector(null,3,(5),inst_24462,inst_24464,null));
var state_24508__$1 = state_24508;
var statearr_24590_24654 = state_24508__$1;
(statearr_24590_24654[(2)] = inst_24465);

(statearr_24590_24654[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____0 = (function (){
var statearr_24591 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24591[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__);

(statearr_24591[(1)] = (1));

return statearr_24591;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____1 = (function (state_24508){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24508);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24592){var ex__2730__auto__ = e24592;
var statearr_24593_24655 = state_24508;
(statearr_24593_24655[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24508[(4)]))){
var statearr_24594_24656 = state_24508;
(statearr_24594_24656[(1)] = cljs.core.first((state_24508[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24657 = state_24508;
state_24508 = G__24657;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__ = function(state_24508){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____1.call(this,state_24508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24595 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24595[(6)] = c__2749__auto__);

return statearr_24595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__24660 = arguments.length;
switch (G__24660) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24702){
var state_val_24703 = (state_24702[(1)]);
if((state_val_24703 === (7))){
var inst_24668 = (state_24702[(7)]);
var state_24702__$1 = state_24702;
var statearr_24704_24734 = state_24702__$1;
(statearr_24704_24734[(2)] = inst_24668);

(statearr_24704_24734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (1))){
var state_24702__$1 = state_24702;
var statearr_24705_24735 = state_24702__$1;
(statearr_24705_24735[(2)] = null);

(statearr_24705_24735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (4))){
var inst_24661 = (state_24702[(2)]);
var state_24702__$1 = state_24702;
var statearr_24706_24736 = state_24702__$1;
(statearr_24706_24736[(2)] = inst_24661);

(statearr_24706_24736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (15))){
var inst_24696 = (state_24702[(2)]);
var inst_24697 = fluree.db.util.async.throw_err(inst_24696);
var _ = (function (){var statearr_24707 = state_24702;
(statearr_24707[(4)] = cljs.core.rest((state_24702[(4)])));

return statearr_24707;
})();
var state_24702__$1 = state_24702;
var statearr_24708_24737 = state_24702__$1;
(statearr_24708_24737[(2)] = inst_24697);

(statearr_24708_24737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (13))){
var inst_24680 = (state_24702[(8)]);
var state_24702__$1 = state_24702;
var statearr_24709_24738 = state_24702__$1;
(statearr_24709_24738[(2)] = inst_24680);

(statearr_24709_24738[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (6))){
var inst_24668 = (state_24702[(7)]);
var inst_24670 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_24671 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24668,inst_24670);
var state_24702__$1 = state_24702;
var statearr_24710_24739 = state_24702__$1;
(statearr_24710_24739[(2)] = inst_24671);

(statearr_24710_24739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (3))){
var inst_24700 = (state_24702[(2)]);
var state_24702__$1 = state_24702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24702__$1,inst_24700);
} else {
if((state_val_24703 === (12))){
var inst_24680 = (state_24702[(8)]);
var inst_24682 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_24683 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24680,inst_24682);
var state_24702__$1 = state_24702;
var statearr_24711_24740 = state_24702__$1;
(statearr_24711_24740[(2)] = inst_24683);

(statearr_24711_24740[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (2))){
var _ = (function (){var statearr_24712 = state_24702;
(statearr_24712[(4)] = cljs.core.cons((5),(state_24702[(4)])));

return statearr_24712;
})();
var inst_24668 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_24702__$1 = (function (){var statearr_24713 = state_24702;
(statearr_24713[(7)] = inst_24668);

return statearr_24713;
})();
if(cljs.core.truth_(fuel)){
var statearr_24714_24741 = state_24702__$1;
(statearr_24714_24741[(1)] = (6));

} else {
var statearr_24715_24742 = state_24702__$1;
(statearr_24715_24742[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (11))){
var inst_24680 = (state_24702[(2)]);
var state_24702__$1 = (function (){var statearr_24717 = state_24702;
(statearr_24717[(8)] = inst_24680);

return statearr_24717;
})();
if(cljs.core.truth_(limit)){
var statearr_24718_24743 = state_24702__$1;
(statearr_24718_24743[(1)] = (12));

} else {
var statearr_24719_24744 = state_24702__$1;
(statearr_24719_24744[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (9))){
var inst_24674 = (state_24702[(9)]);
var inst_24676 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_24677 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24674,inst_24676);
var state_24702__$1 = state_24702;
var statearr_24720_24745 = state_24702__$1;
(statearr_24720_24745[(2)] = inst_24677);

(statearr_24720_24745[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (5))){
var _ = (function (){var statearr_24721 = state_24702;
(statearr_24721[(4)] = cljs.core.rest((state_24702[(4)])));

return statearr_24721;
})();
var state_24702__$1 = state_24702;
var ex24716 = (state_24702__$1[(2)]);
var statearr_24722_24746 = state_24702__$1;
(statearr_24722_24746[(5)] = ex24716);


if((ex24716 instanceof Error)){
var statearr_24723_24747 = state_24702__$1;
(statearr_24723_24747[(1)] = (4));

(statearr_24723_24747[(5)] = null);

} else {
throw ex24716;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (14))){
var inst_24686 = (state_24702[(2)]);
var inst_24687 = (function (){return (function (x){
var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__5043__auto__;
}
});
})();
var inst_24688 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_24687);
var inst_24689 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24686,inst_24688);
var inst_24690 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_24689,flakes);
var inst_24691 = cljs.core.PersistentVector.EMPTY;
var inst_24692 = (function (){var xf = inst_24689;
var flakes_by_sub = inst_24690;
return (function (p1__24658_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__24658_SHARP_);
});
})();
var inst_24693 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24692,inst_24690);
var inst_24694 = fluree.db.util.async.merge_into_QMARK_(inst_24691,inst_24693);
var state_24702__$1 = state_24702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24702__$1,(15),inst_24694);
} else {
if((state_val_24703 === (10))){
var inst_24674 = (state_24702[(9)]);
var state_24702__$1 = state_24702;
var statearr_24724_24748 = state_24702__$1;
(statearr_24724_24748[(2)] = inst_24674);

(statearr_24724_24748[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24703 === (8))){
var inst_24674 = (state_24702[(2)]);
var state_24702__$1 = (function (){var statearr_24725 = state_24702;
(statearr_24725[(9)] = inst_24674);

return statearr_24725;
})();
if(cljs.core.truth_(offset)){
var statearr_24726_24749 = state_24702__$1;
(statearr_24726_24749[(1)] = (9));

} else {
var statearr_24727_24750 = state_24702__$1;
(statearr_24727_24750[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_24728 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24728[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_24728[(1)] = (1));

return statearr_24728;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_24702){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24702);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24729){var ex__2730__auto__ = e24729;
var statearr_24730_24751 = state_24702;
(statearr_24730_24751[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24702[(4)]))){
var statearr_24731_24752 = state_24702;
(statearr_24731_24752[(1)] = cljs.core.first((state_24702[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24753 = state_24702;
state_24702 = G__24753;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_24702){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_24702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24732 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24732[(6)] = c__2749__auto__);

return statearr_24732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__24755 = arguments.length;
switch (G__24755) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24841){
var state_val_24842 = (state_24841[(1)]);
if((state_val_24842 === (7))){
var inst_24836 = (state_24841[(2)]);
var _ = (function (){var statearr_24844 = state_24841;
(statearr_24844[(4)] = cljs.core.rest((state_24841[(4)])));

return statearr_24844;
})();
var state_24841__$1 = state_24841;
var statearr_24845_24897 = state_24841__$1;
(statearr_24845_24897[(2)] = inst_24836);

(statearr_24845_24897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (20))){
var inst_24783 = (state_24841[(7)]);
var inst_24775 = (state_24841[(8)]);
var inst_24776 = (state_24841[(9)]);
var inst_24804 = (inst_24775 + (1));
var tmp24843 = inst_24776;
var inst_24774 = inst_24783;
var inst_24775__$1 = inst_24804;
var inst_24776__$1 = tmp24843;
var state_24841__$1 = (function (){var statearr_24846 = state_24841;
(statearr_24846[(8)] = inst_24775__$1);

(statearr_24846[(10)] = inst_24774);

(statearr_24846[(9)] = inst_24776__$1);

return statearr_24846;
})();
var statearr_24847_24898 = state_24841__$1;
(statearr_24847_24898[(2)] = null);

(statearr_24847_24898[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (27))){
var inst_24814 = (state_24841[(11)]);
var inst_24816 = cljs.core.count(inst_24814);
var inst_24817 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24816);
var state_24841__$1 = state_24841;
var statearr_24848_24899 = state_24841__$1;
(statearr_24848_24899[(2)] = inst_24817);

(statearr_24848_24899[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (1))){
var state_24841__$1 = state_24841;
var statearr_24849_24900 = state_24841__$1;
(statearr_24849_24900[(2)] = null);

(statearr_24849_24900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (24))){
var state_24841__$1 = state_24841;
var statearr_24850_24901 = state_24841__$1;
(statearr_24850_24901[(2)] = null);

(statearr_24850_24901[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (4))){
var inst_24756 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
var statearr_24851_24902 = state_24841__$1;
(statearr_24851_24902[(2)] = inst_24756);

(statearr_24851_24902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (15))){
var inst_24797 = (state_24841[(12)]);
var inst_24797__$1 = offset;
var state_24841__$1 = (function (){var statearr_24852 = state_24841;
(statearr_24852[(12)] = inst_24797__$1);

return statearr_24852;
})();
if(cljs.core.truth_(inst_24797__$1)){
var statearr_24853_24903 = state_24841__$1;
(statearr_24853_24903[(1)] = (17));

} else {
var statearr_24854_24904 = state_24841__$1;
(statearr_24854_24904[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (21))){
var state_24841__$1 = state_24841;
var statearr_24855_24905 = state_24841__$1;
(statearr_24855_24905[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (13))){
var inst_24792 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
var statearr_24857_24906 = state_24841__$1;
(statearr_24857_24906[(2)] = inst_24792);

(statearr_24857_24906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (22))){
var inst_24832 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
var statearr_24858_24907 = state_24841__$1;
(statearr_24858_24907[(2)] = inst_24832);

(statearr_24858_24907[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (29))){
var inst_24814 = (state_24841[(11)]);
var inst_24775 = (state_24841[(8)]);
var inst_24820 = (state_24841[(2)]);
var inst_24821 = (inst_24775 + (1));
var inst_24822 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_24814);
var state_24841__$1 = (function (){var statearr_24859 = state_24841;
(statearr_24859[(13)] = inst_24821);

(statearr_24859[(14)] = inst_24820);

return statearr_24859;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24841__$1,(30),inst_24822);
} else {
if((state_val_24842 === (6))){
var inst_24782 = (state_24841[(15)]);
var inst_24784 = (state_24841[(16)]);
var inst_24774 = (state_24841[(10)]);
var inst_24781 = cljs.core.seq(inst_24774);
var inst_24782__$1 = cljs.core.first(inst_24781);
var inst_24783 = cljs.core.next(inst_24781);
var inst_24784__$1 = (inst_24782__$1 == null);
var state_24841__$1 = (function (){var statearr_24860 = state_24841;
(statearr_24860[(15)] = inst_24782__$1);

(statearr_24860[(16)] = inst_24784__$1);

(statearr_24860[(7)] = inst_24783);

return statearr_24860;
})();
if(cljs.core.truth_(inst_24784__$1)){
var statearr_24861_24908 = state_24841__$1;
(statearr_24861_24908[(1)] = (8));

} else {
var statearr_24862_24909 = state_24841__$1;
(statearr_24862_24909[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (28))){
var state_24841__$1 = state_24841;
var statearr_24863_24910 = state_24841__$1;
(statearr_24863_24910[(2)] = null);

(statearr_24863_24910[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (25))){
var inst_24830 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
var statearr_24864_24911 = state_24841__$1;
(statearr_24864_24911[(2)] = inst_24830);

(statearr_24864_24911[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (17))){
var inst_24775 = (state_24841[(8)]);
var inst_24799 = (inst_24775 < offset);
var state_24841__$1 = state_24841;
var statearr_24865_24912 = state_24841__$1;
(statearr_24865_24912[(2)] = inst_24799);

(statearr_24865_24912[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (3))){
var inst_24839 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24841__$1,inst_24839);
} else {
if((state_val_24842 === (12))){
var inst_24787 = (state_24841[(17)]);
var state_24841__$1 = state_24841;
var statearr_24866_24913 = state_24841__$1;
(statearr_24866_24913[(2)] = inst_24787);

(statearr_24866_24913[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (2))){
var _ = (function (){var statearr_24867 = state_24841;
(statearr_24867[(4)] = cljs.core.cons((5),(state_24841[(4)])));

return statearr_24867;
})();
var inst_24769 = subjects;
var inst_24770 = cljs.core.seq(inst_24769);
var inst_24771 = cljs.core.first(inst_24770);
var inst_24772 = cljs.core.next(inst_24770);
var inst_24773 = cljs.core.PersistentVector.EMPTY;
var inst_24774 = inst_24769;
var inst_24775 = (0);
var inst_24776 = inst_24773;
var state_24841__$1 = (function (){var statearr_24868 = state_24841;
(statearr_24868[(8)] = inst_24775);

(statearr_24868[(18)] = inst_24771);

(statearr_24868[(10)] = inst_24774);

(statearr_24868[(9)] = inst_24776);

(statearr_24868[(19)] = inst_24772);

return statearr_24868;
})();
var statearr_24869_24914 = state_24841__$1;
(statearr_24869_24914[(2)] = null);

(statearr_24869_24914[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (23))){
var inst_24782 = (state_24841[(15)]);
var inst_24808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24809 = [inst_24782];
var inst_24810 = (new cljs.core.PersistentVector(null,1,(5),inst_24808,inst_24809,null));
var inst_24811 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24810);
var state_24841__$1 = state_24841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24841__$1,(26),inst_24811);
} else {
if((state_val_24842 === (19))){
var inst_24802 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
if(cljs.core.truth_(inst_24802)){
var statearr_24870_24915 = state_24841__$1;
(statearr_24870_24915[(1)] = (20));

} else {
var statearr_24871_24916 = state_24841__$1;
(statearr_24871_24916[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (11))){
var inst_24775 = (state_24841[(8)]);
var inst_24789 = (inst_24775 > limit);
var state_24841__$1 = state_24841;
var statearr_24873_24917 = state_24841__$1;
(statearr_24873_24917[(2)] = inst_24789);

(statearr_24873_24917[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (9))){
var inst_24787 = (state_24841[(17)]);
var inst_24787__$1 = limit;
var state_24841__$1 = (function (){var statearr_24874 = state_24841;
(statearr_24874[(17)] = inst_24787__$1);

return statearr_24874;
})();
if(cljs.core.truth_(inst_24787__$1)){
var statearr_24875_24918 = state_24841__$1;
(statearr_24875_24918[(1)] = (11));

} else {
var statearr_24876_24919 = state_24841__$1;
(statearr_24876_24919[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (5))){
var _ = (function (){var statearr_24877 = state_24841;
(statearr_24877[(4)] = cljs.core.rest((state_24841[(4)])));

return statearr_24877;
})();
var state_24841__$1 = state_24841;
var ex24872 = (state_24841__$1[(2)]);
var statearr_24878_24920 = state_24841__$1;
(statearr_24878_24920[(5)] = ex24872);


if((ex24872 instanceof Error)){
var statearr_24879_24921 = state_24841__$1;
(statearr_24879_24921[(1)] = (4));

(statearr_24879_24921[(5)] = null);

} else {
throw ex24872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (14))){
var inst_24776 = (state_24841[(9)]);
var state_24841__$1 = state_24841;
var statearr_24880_24922 = state_24841__$1;
(statearr_24880_24922[(2)] = inst_24776);

(statearr_24880_24922[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (26))){
var inst_24813 = (state_24841[(2)]);
var inst_24814 = fluree.db.util.async.throw_err(inst_24813);
var state_24841__$1 = (function (){var statearr_24881 = state_24841;
(statearr_24881[(11)] = inst_24814);

return statearr_24881;
})();
if(cljs.core.truth_(fuel)){
var statearr_24882_24923 = state_24841__$1;
(statearr_24882_24923[(1)] = (27));

} else {
var statearr_24883_24924 = state_24841__$1;
(statearr_24883_24924[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (16))){
var inst_24834 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
var statearr_24884_24925 = state_24841__$1;
(statearr_24884_24925[(2)] = inst_24834);

(statearr_24884_24925[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (30))){
var inst_24783 = (state_24841[(7)]);
var inst_24821 = (state_24841[(13)]);
var inst_24776 = (state_24841[(9)]);
var inst_24824 = (state_24841[(2)]);
var inst_24825 = fluree.db.util.async.throw_err(inst_24824);
var inst_24826 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24776,inst_24825);
var inst_24774 = inst_24783;
var inst_24775 = inst_24821;
var inst_24776__$1 = inst_24826;
var state_24841__$1 = (function (){var statearr_24885 = state_24841;
(statearr_24885[(8)] = inst_24775);

(statearr_24885[(10)] = inst_24774);

(statearr_24885[(9)] = inst_24776__$1);

return statearr_24885;
})();
var statearr_24886_24926 = state_24841__$1;
(statearr_24886_24926[(2)] = null);

(statearr_24886_24926[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (10))){
var inst_24794 = (state_24841[(2)]);
var state_24841__$1 = state_24841;
if(cljs.core.truth_(inst_24794)){
var statearr_24887_24927 = state_24841__$1;
(statearr_24887_24927[(1)] = (14));

} else {
var statearr_24888_24928 = state_24841__$1;
(statearr_24888_24928[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (18))){
var inst_24797 = (state_24841[(12)]);
var state_24841__$1 = state_24841;
var statearr_24889_24929 = state_24841__$1;
(statearr_24889_24929[(2)] = inst_24797);

(statearr_24889_24929[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24842 === (8))){
var inst_24784 = (state_24841[(16)]);
var state_24841__$1 = state_24841;
var statearr_24890_24930 = state_24841__$1;
(statearr_24890_24930[(2)] = inst_24784);

(statearr_24890_24930[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_24891 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24891[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_24891[(1)] = (1));

return statearr_24891;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_24841){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24841);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24892){var ex__2730__auto__ = e24892;
var statearr_24893_24931 = state_24841;
(statearr_24893_24931[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24841[(4)]))){
var statearr_24894_24932 = state_24841;
(statearr_24894_24932[(1)] = cljs.core.first((state_24841[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24933 = state_24841;
state_24841 = G__24933;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_24841){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_24841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24895 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24895[(6)] = c__2749__auto__);

return statearr_24895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24935 = arguments.length;
switch (G__24935) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24936){
var map__24937 = p__24936;
var map__24937__$1 = cljs.core.__destructure_map(map__24937);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24937__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24937__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25201){
var state_val_25202 = (state_25201[(1)]);
if((state_val_25202 === (65))){
var inst_25164 = (state_25201[(7)]);
var inst_25164__$1 = (state_25201[(2)]);
var state_25201__$1 = (function (){var statearr_25203 = state_25201;
(statearr_25203[(7)] = inst_25164__$1);

return statearr_25203;
})();
if(cljs.core.truth_(inst_25164__$1)){
var statearr_25204_25322 = state_25201__$1;
(statearr_25204_25322[(1)] = (66));

} else {
var statearr_25205_25323 = state_25201__$1;
(statearr_25205_25323[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (70))){
var inst_25167 = (state_25201[(8)]);
var state_25201__$1 = state_25201;
var statearr_25206_25324 = state_25201__$1;
(statearr_25206_25324[(2)] = inst_25167);

(statearr_25206_25324[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (62))){
var inst_25155 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25207_25325 = state_25201__$1;
(statearr_25207_25325[(2)] = inst_25155);

(statearr_25207_25325[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (74))){
var inst_25174 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25208_25326 = state_25201__$1;
(statearr_25208_25326[(2)] = inst_25174);

(statearr_25208_25326[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (7))){
var inst_24950 = (state_25201[(9)]);
var state_25201__$1 = state_25201;
var statearr_25209_25327 = state_25201__$1;
(statearr_25209_25327[(2)] = inst_24950);

(statearr_25209_25327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (59))){
var inst_24979 = (state_25201[(10)]);
var inst_25147 = cljs.core.empty_QMARK_(inst_24979);
var state_25201__$1 = state_25201;
if(inst_25147){
var statearr_25210_25328 = state_25201__$1;
(statearr_25210_25328[(1)] = (60));

} else {
var statearr_25211_25329 = state_25201__$1;
(statearr_25211_25329[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (20))){
var state_25201__$1 = state_25201;
if(cljs.core.truth_(offset)){
var statearr_25212_25330 = state_25201__$1;
(statearr_25212_25330[(1)] = (23));

} else {
var statearr_25213_25331 = state_25201__$1;
(statearr_25213_25331[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (72))){
var inst_25144 = (state_25201[(11)]);
var inst_24964 = (state_25201[(12)]);
var inst_25170 = cljs.core.count(inst_25144);
var inst_25171 = (inst_25170 > inst_24964);
var state_25201__$1 = state_25201;
var statearr_25214_25332 = state_25201__$1;
(statearr_25214_25332[(2)] = inst_25171);

(statearr_25214_25332[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (58))){
var inst_24979 = (state_25201[(10)]);
var inst_25144 = (state_25201[(11)]);
var inst_25145 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24979,inst_25144);
var state_25201__$1 = state_25201;
var statearr_25215_25333 = state_25201__$1;
(statearr_25215_25333[(2)] = inst_25145);

(statearr_25215_25333[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (60))){
var inst_24979 = (state_25201[(10)]);
var inst_25144 = (state_25201[(11)]);
var inst_25149 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24979,inst_25144);
var state_25201__$1 = state_25201;
var statearr_25216_25334 = state_25201__$1;
(statearr_25216_25334[(2)] = inst_25149);

(statearr_25216_25334[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (27))){
var inst_24994 = (state_25201[(13)]);
var state_25201__$1 = state_25201;
var statearr_25217_25335 = state_25201__$1;
(statearr_25217_25335[(2)] = inst_24994);

(statearr_25217_25335[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (1))){
var state_25201__$1 = state_25201;
var statearr_25218_25336 = state_25201__$1;
(statearr_25218_25336[(2)] = null);

(statearr_25218_25336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (69))){
var inst_24964 = (state_25201[(12)]);
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_24964)){
var statearr_25219_25337 = state_25201__$1;
(statearr_25219_25337[(1)] = (72));

} else {
var statearr_25220_25338 = state_25201__$1;
(statearr_25220_25338[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (24))){
var inst_24979 = (state_25201[(10)]);
var state_25201__$1 = state_25201;
var statearr_25221_25339 = state_25201__$1;
(statearr_25221_25339[(2)] = inst_24979);

(statearr_25221_25339[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (55))){
var inst_25133 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25222_25340 = state_25201__$1;
(statearr_25222_25340[(2)] = inst_25133);

(statearr_25222_25340[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (39))){
var inst_25141 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25223_25341 = state_25201__$1;
(statearr_25223_25341[(2)] = inst_25141);

(statearr_25223_25341[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (46))){
var inst_25023 = (state_25201[(14)]);
var inst_25005 = (state_25201[(15)]);
var inst_25099 = (inst_25023.cljs$core$IFn$_invoke$arity$2 ? inst_25023.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_25005) : inst_25023.call(null,cljs.core._LT_,inst_25005));
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_25099)){
var statearr_25224_25342 = state_25201__$1;
(statearr_25224_25342[(1)] = (49));

} else {
var statearr_25225_25343 = state_25201__$1;
(statearr_25225_25343[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (4))){
var inst_24938 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25226_25344 = state_25201__$1;
(statearr_25226_25344[(2)] = inst_24938);

(statearr_25226_25344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (77))){
var inst_25189 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25227_25345 = state_25201__$1;
(statearr_25227_25345[(2)] = inst_25189);

(statearr_25227_25345[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (54))){
var inst_25131 = cljs.core.PersistentVector.EMPTY;
var state_25201__$1 = state_25201;
var statearr_25228_25346 = state_25201__$1;
(statearr_25228_25346[(2)] = inst_25131);

(statearr_25228_25346[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (15))){
var inst_24949 = (state_25201[(16)]);
var inst_24974 = cljs.core.seq(inst_24949);
var inst_24975 = cljs.core.first(inst_24974);
var inst_24976 = cljs.core.next(inst_24974);
var inst_24977 = cljs.core.PersistentHashSet.EMPTY;
var inst_24978 = inst_24949;
var inst_24979 = inst_24977;
var state_25201__$1 = (function (){var statearr_25229 = state_25201;
(statearr_25229[(10)] = inst_24979);

(statearr_25229[(17)] = inst_24976);

(statearr_25229[(18)] = inst_24975);

(statearr_25229[(19)] = inst_24978);

return statearr_25229;
})();
var statearr_25230_25347 = state_25201__$1;
(statearr_25230_25347[(2)] = null);

(statearr_25230_25347[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (48))){
var inst_25096 = (state_25201[(2)]);
var inst_25097 = fluree.db.util.async.throw_err(inst_25096);
var state_25201__$1 = state_25201;
var statearr_25231_25348 = state_25201__$1;
(statearr_25231_25348[(2)] = inst_25097);

(statearr_25231_25348[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (50))){
var inst_25023 = (state_25201[(14)]);
var inst_25005 = (state_25201[(15)]);
var inst_25115 = (inst_25023.cljs$core$IFn$_invoke$arity$2 ? inst_25023.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_25005) : inst_25023.call(null,cljs.core._LT__EQ_,inst_25005));
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_25115)){
var statearr_25232_25349 = state_25201__$1;
(statearr_25232_25349[(1)] = (53));

} else {
var statearr_25233_25350 = state_25201__$1;
(statearr_25233_25350[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (75))){
var state_25201__$1 = state_25201;
if(cljs.core.truth_(offset)){
var statearr_25234_25351 = state_25201__$1;
(statearr_25234_25351[(1)] = (78));

} else {
var statearr_25235_25352 = state_25201__$1;
(statearr_25235_25352[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (21))){
var inst_25004 = (state_25201[(20)]);
var inst_24985 = (state_25201[(21)]);
var inst_25004__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24985,(0),null);
var inst_25005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24985,(1),null);
var inst_25006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24985,(2),null);
var inst_25007 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_25004__$1);
var inst_25008 = cljs.core.not(inst_25007);
var state_25201__$1 = (function (){var statearr_25236 = state_25201;
(statearr_25236[(22)] = inst_25006);

(statearr_25236[(20)] = inst_25004__$1);

(statearr_25236[(15)] = inst_25005);

return statearr_25236;
})();
if(inst_25008){
var statearr_25237_25353 = state_25201__$1;
(statearr_25237_25353[(1)] = (29));

} else {
var statearr_25238_25354 = state_25201__$1;
(statearr_25238_25354[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (31))){
var inst_25023 = (state_25201[(14)]);
var inst_25005 = (state_25201[(15)]);
var inst_25019 = (state_25201[(2)]);
var inst_25023__$1 = cljs.core.identical_QMARK_;
var inst_25024 = (inst_25023__$1.cljs$core$IFn$_invoke$arity$2 ? inst_25023__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_25005) : inst_25023__$1.call(null,cljs.core.not_EQ_,inst_25005));
var state_25201__$1 = (function (){var statearr_25239 = state_25201;
(statearr_25239[(23)] = inst_25019);

(statearr_25239[(14)] = inst_25023__$1);

return statearr_25239;
})();
if(cljs.core.truth_(inst_25024)){
var statearr_25240_25355 = state_25201__$1;
(statearr_25240_25355[(1)] = (32));

} else {
var statearr_25241_25356 = state_25201__$1;
(statearr_25241_25356[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (32))){
var inst_25006 = (state_25201[(22)]);
var inst_25004 = (state_25201[(20)]);
var inst_24964 = (state_25201[(12)]);
var inst_25026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25027 = [inst_25004,inst_25006];
var inst_25028 = (new cljs.core.PersistentVector(null,2,(5),inst_25026,inst_25027,null));
var inst_25029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25030 = [inst_25004];
var inst_25031 = (new cljs.core.PersistentVector(null,1,(5),inst_25029,inst_25030,null));
var inst_25032 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25033 = [inst_24964];
var inst_25034 = cljs.core.PersistentHashMap.fromArrays(inst_25032,inst_25033);
var inst_25035 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_25028,cljs.core._LT__EQ_,inst_25031,inst_25034);
var state_25201__$1 = state_25201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25201__$1,(35),inst_25035);
} else {
if((state_val_25202 === (40))){
var inst_25064 = (state_25201[(2)]);
var inst_25065 = fluree.db.util.async.throw_err(inst_25064);
var state_25201__$1 = state_25201;
var statearr_25242_25357 = state_25201__$1;
(statearr_25242_25357[(2)] = inst_25065);

(statearr_25242_25357[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (56))){
var inst_25128 = (state_25201[(2)]);
var inst_25129 = fluree.db.util.async.throw_err(inst_25128);
var state_25201__$1 = state_25201;
var statearr_25243_25358 = state_25201__$1;
(statearr_25243_25358[(2)] = inst_25129);

(statearr_25243_25358[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (33))){
var inst_25023 = (state_25201[(14)]);
var inst_25005 = (state_25201[(15)]);
var inst_25054 = (inst_25023.cljs$core$IFn$_invoke$arity$2 ? inst_25023.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_25005) : inst_25023.call(null,cljs.core._EQ_,inst_25005));
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_25054)){
var statearr_25244_25359 = state_25201__$1;
(statearr_25244_25359[(1)] = (37));

} else {
var statearr_25245_25360 = state_25201__$1;
(statearr_25245_25360[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (13))){
var state_25201__$1 = state_25201;
var statearr_25246_25361 = state_25201__$1;
(statearr_25246_25361[(2)] = limit);

(statearr_25246_25361[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (22))){
var inst_25191 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25247_25362 = state_25201__$1;
(statearr_25247_25362[(2)] = inst_25191);

(statearr_25247_25362[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (36))){
var inst_25038 = (state_25201[(24)]);
var inst_25050 = (state_25201[(2)]);
var inst_25051 = fluree.db.util.async.throw_err(inst_25050);
var inst_25052 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_25038,inst_25051);
var state_25201__$1 = state_25201;
var statearr_25248_25363 = state_25201__$1;
(statearr_25248_25363[(2)] = inst_25052);

(statearr_25248_25363[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (41))){
var inst_25006 = (state_25201[(22)]);
var inst_25004 = (state_25201[(20)]);
var inst_24964 = (state_25201[(12)]);
var inst_25069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25070 = [inst_25004,inst_25006];
var inst_25071 = (new cljs.core.PersistentVector(null,2,(5),inst_25069,inst_25070,null));
var inst_25072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25073 = [inst_25004];
var inst_25074 = (new cljs.core.PersistentVector(null,1,(5),inst_25072,inst_25073,null));
var inst_25075 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25076 = [inst_24964];
var inst_25077 = cljs.core.PersistentHashMap.fromArrays(inst_25075,inst_25076);
var inst_25078 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_25071,cljs.core._LT__EQ_,inst_25074,inst_25077);
var state_25201__$1 = state_25201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25201__$1,(44),inst_25078);
} else {
if((state_val_25202 === (43))){
var inst_25139 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25249_25364 = state_25201__$1;
(statearr_25249_25364[(2)] = inst_25139);

(statearr_25249_25364[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (61))){
var inst_24979 = (state_25201[(10)]);
var inst_25144 = (state_25201[(11)]);
var inst_25151 = cljs.core.PersistentHashSet.EMPTY;
var inst_25152 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25151,inst_25144);
var inst_25153 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24979,inst_25152);
var state_25201__$1 = state_25201;
var statearr_25250_25365 = state_25201__$1;
(statearr_25250_25365[(2)] = inst_25153);

(statearr_25250_25365[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (29))){
var inst_25004 = (state_25201[(20)]);
var inst_25010 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_25004);
var inst_25011 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25010)].join('');
var inst_25012 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25013 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25014 = cljs.core.PersistentHashMap.fromArrays(inst_25012,inst_25013);
var inst_25015 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25011,inst_25014);
var inst_25016 = (function(){throw inst_25015})();
var state_25201__$1 = state_25201;
var statearr_25251_25366 = state_25201__$1;
(statearr_25251_25366[(2)] = inst_25016);

(statearr_25251_25366[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (44))){
var inst_25080 = (state_25201[(2)]);
var inst_25081 = fluree.db.util.async.throw_err(inst_25080);
var state_25201__$1 = state_25201;
var statearr_25252_25367 = state_25201__$1;
(statearr_25252_25367[(2)] = inst_25081);

(statearr_25252_25367[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (6))){
var inst_24948 = (state_25201[(25)]);
var inst_24952 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24948);
var state_25201__$1 = state_25201;
var statearr_25253_25368 = state_25201__$1;
(statearr_25253_25368[(2)] = inst_24952);

(statearr_25253_25368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (28))){
var inst_24999 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25254_25369 = state_25201__$1;
(statearr_25254_25369[(2)] = inst_24999);

(statearr_25254_25369[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (64))){
var inst_25159 = (state_25201[(26)]);
var state_25201__$1 = state_25201;
var statearr_25255_25370 = state_25201__$1;
(statearr_25255_25370[(2)] = inst_25159);

(statearr_25255_25370[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (51))){
var inst_25135 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25256_25371 = state_25201__$1;
(statearr_25256_25371[(2)] = inst_25135);

(statearr_25256_25371[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (25))){
var inst_24994 = (state_25201[(2)]);
var state_25201__$1 = (function (){var statearr_25257 = state_25201;
(statearr_25257[(13)] = inst_24994);

return statearr_25257;
})();
if(cljs.core.truth_(limit)){
var statearr_25258_25372 = state_25201__$1;
(statearr_25258_25372[(1)] = (26));

} else {
var statearr_25259_25373 = state_25201__$1;
(statearr_25259_25373[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (34))){
var inst_24948 = (state_25201[(25)]);
var inst_25143 = (state_25201[(2)]);
var inst_25144 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_25143);
var state_25201__$1 = (function (){var statearr_25260 = state_25201;
(statearr_25260[(11)] = inst_25144);

return statearr_25260;
})();
var G__25261_25374 = inst_24948;
var G__25261_25375__$1 = (((G__25261_25374 instanceof cljs.core.Keyword))?G__25261_25374.fqn:null);
switch (G__25261_25375__$1) {
case "or":
var statearr_25262_25377 = state_25201__$1;
(statearr_25262_25377[(1)] = (58));


break;
case "and":
var statearr_25263_25378 = state_25201__$1;
(statearr_25263_25378[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25261_25375__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (17))){
var inst_25196 = (state_25201[(2)]);
var _ = (function (){var statearr_25264 = state_25201;
(statearr_25264[(4)] = cljs.core.rest((state_25201[(4)])));

return statearr_25264;
})();
var state_25201__$1 = state_25201;
var statearr_25265_25379 = state_25201__$1;
(statearr_25265_25379[(2)] = inst_25196);

(statearr_25265_25379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (3))){
var inst_25199 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25201__$1,inst_25199);
} else {
if((state_val_25202 === (12))){
var inst_24958 = (offset + limit);
var state_25201__$1 = state_25201;
var statearr_25266_25380 = state_25201__$1;
(statearr_25266_25380[(2)] = inst_24958);

(statearr_25266_25380[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (2))){
var inst_24950 = (state_25201[(9)]);
var _ = (function (){var statearr_25267 = state_25201;
(statearr_25267[(4)] = cljs.core.cons((5),(state_25201[(4)])));

return statearr_25267;
})();
var inst_24947 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_24948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24947,(0),null);
var inst_24949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24947,(1),null);
var inst_24950__$1 = limit;
var state_25201__$1 = (function (){var statearr_25268 = state_25201;
(statearr_25268[(25)] = inst_24948);

(statearr_25268[(16)] = inst_24949);

(statearr_25268[(9)] = inst_24950__$1);

return statearr_25268;
})();
if(cljs.core.truth_(inst_24950__$1)){
var statearr_25269_25381 = state_25201__$1;
(statearr_25269_25381[(1)] = (6));

} else {
var statearr_25270_25382 = state_25201__$1;
(statearr_25270_25382[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (66))){
var inst_25164 = (state_25201[(7)]);
var state_25201__$1 = state_25201;
var statearr_25271_25383 = state_25201__$1;
(statearr_25271_25383[(2)] = inst_25164);

(statearr_25271_25383[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (23))){
var inst_24979 = (state_25201[(10)]);
var inst_24991 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24979);
var state_25201__$1 = state_25201;
var statearr_25272_25384 = state_25201__$1;
(statearr_25272_25384[(2)] = inst_24991);

(statearr_25272_25384[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (47))){
var inst_25137 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25273_25385 = state_25201__$1;
(statearr_25273_25385[(2)] = inst_25137);

(statearr_25273_25385[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (35))){
var inst_25006 = (state_25201[(22)]);
var inst_25004 = (state_25201[(20)]);
var inst_24964 = (state_25201[(12)]);
var inst_25037 = (state_25201[(2)]);
var inst_25038 = fluree.db.util.async.throw_err(inst_25037);
var inst_25039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25040 = [inst_25004];
var inst_25041 = (new cljs.core.PersistentVector(null,1,(5),inst_25039,inst_25040,null));
var inst_25042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25043 = [inst_25004,inst_25006];
var inst_25044 = (new cljs.core.PersistentVector(null,2,(5),inst_25042,inst_25043,null));
var inst_25045 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25046 = [inst_24964];
var inst_25047 = cljs.core.PersistentHashMap.fromArrays(inst_25045,inst_25046);
var inst_25048 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25041,cljs.core._LT_,inst_25044,inst_25047);
var state_25201__$1 = (function (){var statearr_25274 = state_25201;
(statearr_25274[(24)] = inst_25038);

return statearr_25274;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25201__$1,(36),inst_25048);
} else {
if((state_val_25202 === (76))){
var inst_25158 = (state_25201[(27)]);
var inst_24986 = (state_25201[(28)]);
var inst_24978 = inst_24986;
var inst_24979 = inst_25158;
var state_25201__$1 = (function (){var statearr_25275 = state_25201;
(statearr_25275[(10)] = inst_24979);

(statearr_25275[(19)] = inst_24978);

return statearr_25275;
})();
var statearr_25276_25386 = state_25201__$1;
(statearr_25276_25386[(2)] = null);

(statearr_25276_25386[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (19))){
var inst_25193 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25277_25387 = state_25201__$1;
(statearr_25277_25387[(2)] = inst_25193);

(statearr_25277_25387[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (57))){
var inst_25159 = (state_25201[(26)]);
var inst_24948 = (state_25201[(25)]);
var inst_25158 = (state_25201[(2)]);
var inst_25159__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24948);
var state_25201__$1 = (function (){var statearr_25278 = state_25201;
(statearr_25278[(26)] = inst_25159__$1);

(statearr_25278[(27)] = inst_25158);

return statearr_25278;
})();
if(inst_25159__$1){
var statearr_25279_25388 = state_25201__$1;
(statearr_25279_25388[(1)] = (63));

} else {
var statearr_25280_25389 = state_25201__$1;
(statearr_25280_25389[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (68))){
var inst_25179 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_25179)){
var statearr_25281_25390 = state_25201__$1;
(statearr_25281_25390[(1)] = (75));

} else {
var statearr_25282_25391 = state_25201__$1;
(statearr_25282_25391[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (11))){
var inst_24949 = (state_25201[(16)]);
var inst_24964 = (state_25201[(2)]);
var inst_24965 = cljs.core.not_empty(inst_24949);
var state_25201__$1 = (function (){var statearr_25284 = state_25201;
(statearr_25284[(12)] = inst_24964);

return statearr_25284;
})();
if(cljs.core.truth_(inst_24965)){
var statearr_25285_25392 = state_25201__$1;
(statearr_25285_25392[(1)] = (15));

} else {
var statearr_25286_25393 = state_25201__$1;
(statearr_25286_25393[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (9))){
var state_25201__$1 = state_25201;
if(cljs.core.truth_(offset)){
var statearr_25287_25394 = state_25201__$1;
(statearr_25287_25394[(1)] = (12));

} else {
var statearr_25288_25395 = state_25201__$1;
(statearr_25288_25395[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (5))){
var _ = (function (){var statearr_25289 = state_25201;
(statearr_25289[(4)] = cljs.core.rest((state_25201[(4)])));

return statearr_25289;
})();
var state_25201__$1 = state_25201;
var ex25283 = (state_25201__$1[(2)]);
var statearr_25290_25396 = state_25201__$1;
(statearr_25290_25396[(5)] = ex25283);


if((ex25283 instanceof Error)){
var statearr_25291_25397 = state_25201__$1;
(statearr_25291_25397[(1)] = (4));

(statearr_25291_25397[(5)] = null);

} else {
throw ex25283;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (14))){
var inst_24961 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25292_25398 = state_25201__$1;
(statearr_25292_25398[(2)] = inst_24961);

(statearr_25292_25398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (45))){
var inst_25006 = (state_25201[(22)]);
var inst_25004 = (state_25201[(20)]);
var inst_24964 = (state_25201[(12)]);
var inst_25085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25086 = [inst_25004,inst_25006];
var inst_25087 = (new cljs.core.PersistentVector(null,2,(5),inst_25085,inst_25086,null));
var inst_25088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25089 = [inst_25004];
var inst_25090 = (new cljs.core.PersistentVector(null,1,(5),inst_25088,inst_25089,null));
var inst_25091 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25092 = [inst_24964];
var inst_25093 = cljs.core.PersistentHashMap.fromArrays(inst_25091,inst_25092);
var inst_25094 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25087,cljs.core._LT__EQ_,inst_25090,inst_25093);
var state_25201__$1 = state_25201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25201__$1,(48),inst_25094);
} else {
if((state_val_25202 === (53))){
var inst_25006 = (state_25201[(22)]);
var inst_25004 = (state_25201[(20)]);
var inst_24964 = (state_25201[(12)]);
var inst_25117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25118 = [inst_25004];
var inst_25119 = (new cljs.core.PersistentVector(null,1,(5),inst_25117,inst_25118,null));
var inst_25120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25121 = [inst_25004,inst_25006];
var inst_25122 = (new cljs.core.PersistentVector(null,2,(5),inst_25120,inst_25121,null));
var inst_25123 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25124 = [inst_24964];
var inst_25125 = cljs.core.PersistentHashMap.fromArrays(inst_25123,inst_25124);
var inst_25126 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25119,cljs.core._LT__EQ_,inst_25122,inst_25125);
var state_25201__$1 = state_25201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25201__$1,(56),inst_25126);
} else {
if((state_val_25202 === (78))){
var inst_25158 = (state_25201[(27)]);
var inst_25182 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_25158);
var state_25201__$1 = state_25201;
var statearr_25293_25399 = state_25201__$1;
(statearr_25293_25399[(2)] = inst_25182);

(statearr_25293_25399[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (26))){
var inst_24994 = (state_25201[(13)]);
var inst_24996 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_24994);
var state_25201__$1 = state_25201;
var statearr_25294_25400 = state_25201__$1;
(statearr_25294_25400[(2)] = inst_24996);

(statearr_25294_25400[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (16))){
var state_25201__$1 = state_25201;
var statearr_25295_25401 = state_25201__$1;
(statearr_25295_25401[(2)] = null);

(statearr_25295_25401[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (79))){
var inst_25158 = (state_25201[(27)]);
var state_25201__$1 = state_25201;
var statearr_25296_25402 = state_25201__$1;
(statearr_25296_25402[(2)] = inst_25158);

(statearr_25296_25402[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (38))){
var inst_25023 = (state_25201[(14)]);
var inst_25005 = (state_25201[(15)]);
var inst_25067 = (inst_25023.cljs$core$IFn$_invoke$arity$2 ? inst_25023.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_25005) : inst_25023.call(null,cljs.core._GT_,inst_25005));
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_25067)){
var statearr_25297_25403 = state_25201__$1;
(statearr_25297_25403[(1)] = (41));

} else {
var statearr_25298_25404 = state_25201__$1;
(statearr_25298_25404[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (30))){
var state_25201__$1 = state_25201;
var statearr_25299_25405 = state_25201__$1;
(statearr_25299_25405[(2)] = null);

(statearr_25299_25405[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (73))){
var inst_24964 = (state_25201[(12)]);
var state_25201__$1 = state_25201;
var statearr_25300_25406 = state_25201__$1;
(statearr_25300_25406[(2)] = inst_24964);

(statearr_25300_25406[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (10))){
var state_25201__$1 = state_25201;
var statearr_25301_25407 = state_25201__$1;
(statearr_25301_25407[(2)] = null);

(statearr_25301_25407[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (18))){
var inst_24985 = (state_25201[(21)]);
var inst_24978 = (state_25201[(19)]);
var inst_24984 = cljs.core.seq(inst_24978);
var inst_24985__$1 = cljs.core.first(inst_24984);
var inst_24986 = cljs.core.next(inst_24984);
var inst_24987 = cljs.core.not(inst_24985__$1);
var state_25201__$1 = (function (){var statearr_25302 = state_25201;
(statearr_25302[(28)] = inst_24986);

(statearr_25302[(21)] = inst_24985__$1);

return statearr_25302;
})();
if(inst_24987){
var statearr_25303_25408 = state_25201__$1;
(statearr_25303_25408[(1)] = (20));

} else {
var statearr_25304_25409 = state_25201__$1;
(statearr_25304_25409[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (52))){
var inst_25112 = (state_25201[(2)]);
var inst_25113 = fluree.db.util.async.throw_err(inst_25112);
var state_25201__$1 = state_25201;
var statearr_25305_25410 = state_25201__$1;
(statearr_25305_25410[(2)] = inst_25113);

(statearr_25305_25410[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (67))){
var inst_24948 = (state_25201[(25)]);
var inst_25167 = (state_25201[(8)]);
var inst_25167__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24948);
var state_25201__$1 = (function (){var statearr_25306 = state_25201;
(statearr_25306[(8)] = inst_25167__$1);

return statearr_25306;
})();
if(inst_25167__$1){
var statearr_25307_25411 = state_25201__$1;
(statearr_25307_25411[(1)] = (69));

} else {
var statearr_25308_25412 = state_25201__$1;
(statearr_25308_25412[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (71))){
var inst_25177 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25309_25413 = state_25201__$1;
(statearr_25309_25413[(2)] = inst_25177);

(statearr_25309_25413[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (42))){
var inst_25023 = (state_25201[(14)]);
var inst_25005 = (state_25201[(15)]);
var inst_25083 = (inst_25023.cljs$core$IFn$_invoke$arity$2 ? inst_25023.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_25005) : inst_25023.call(null,cljs.core._GT__EQ_,inst_25005));
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_25083)){
var statearr_25310_25414 = state_25201__$1;
(statearr_25310_25414[(1)] = (45));

} else {
var statearr_25311_25415 = state_25201__$1;
(statearr_25311_25415[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (80))){
var inst_25185 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
var statearr_25312_25416 = state_25201__$1;
(statearr_25312_25416[(2)] = inst_25185);

(statearr_25312_25416[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (37))){
var inst_25006 = (state_25201[(22)]);
var inst_25004 = (state_25201[(20)]);
var inst_24964 = (state_25201[(12)]);
var inst_25056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25057 = [inst_25004,inst_25006];
var inst_25058 = (new cljs.core.PersistentVector(null,2,(5),inst_25056,inst_25057,null));
var inst_25059 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25060 = [inst_24964];
var inst_25061 = cljs.core.PersistentHashMap.fromArrays(inst_25059,inst_25060);
var inst_25062 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25058,inst_25061);
var state_25201__$1 = state_25201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25201__$1,(40),inst_25062);
} else {
if((state_val_25202 === (63))){
var inst_25158 = (state_25201[(27)]);
var inst_25161 = cljs.core.empty_QMARK_(inst_25158);
var state_25201__$1 = state_25201;
var statearr_25313_25417 = state_25201__$1;
(statearr_25313_25417[(2)] = inst_25161);

(statearr_25313_25417[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (8))){
var inst_24955 = (state_25201[(2)]);
var state_25201__$1 = state_25201;
if(cljs.core.truth_(inst_24955)){
var statearr_25314_25418 = state_25201__$1;
(statearr_25314_25418[(1)] = (9));

} else {
var statearr_25315_25419 = state_25201__$1;
(statearr_25315_25419[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25202 === (49))){
var inst_25006 = (state_25201[(22)]);
var inst_25004 = (state_25201[(20)]);
var inst_24964 = (state_25201[(12)]);
var inst_25101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25102 = [inst_25004];
var inst_25103 = (new cljs.core.PersistentVector(null,1,(5),inst_25101,inst_25102,null));
var inst_25104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25105 = [inst_25004,inst_25006];
var inst_25106 = (new cljs.core.PersistentVector(null,2,(5),inst_25104,inst_25105,null));
var inst_25107 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25108 = [inst_24964];
var inst_25109 = cljs.core.PersistentHashMap.fromArrays(inst_25107,inst_25108);
var inst_25110 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25103,cljs.core._LT_,inst_25106,inst_25109);
var state_25201__$1 = state_25201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25201__$1,(52),inst_25110);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_25316 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25316[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_25316[(1)] = (1));

return statearr_25316;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_25201){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25201);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25317){var ex__2730__auto__ = e25317;
var statearr_25318_25420 = state_25201;
(statearr_25318_25420[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25201[(4)]))){
var statearr_25319_25421 = state_25201;
(statearr_25319_25421[(1)] = cljs.core.first((state_25201[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25422 = state_25201;
state_25201 = G__25422;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_25201){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_25201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25320 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25320[(6)] = c__2749__auto__);

return statearr_25320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_((function (p1__25423_SHARP_){
return ((typeof p1__25423_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__25423_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__25424_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__25424_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__25428 = vars;
var vec__25429 = G__25428;
var seq__25430 = cljs.core.seq(vec__25429);
var first__25431 = cljs.core.first(seq__25430);
var seq__25430__$1 = cljs.core.next(seq__25430);
var var$ = first__25431;
var r = seq__25430__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__25428__$1 = G__25428;
var all_vars__$1 = all_vars;
while(true){
var vec__25436 = G__25428__$1;
var seq__25437 = cljs.core.seq(vec__25436);
var first__25438 = cljs.core.first(seq__25437);
var seq__25437__$1 = cljs.core.next(seq__25437);
var var$__$1 = first__25438;
var r__$1 = seq__25437__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__25439 = cljs.core.set(all_vars__$2);
return (fexpr__25439.cljs$core$IFn$_invoke$arity$1 ? fexpr__25439.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__25439.call(null,var$__$1));
})())){
var G__25440 = r__$1;
var G__25441 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__25428__$1 = G__25440;
all_vars__$1 = G__25441;
continue;
} else {
var G__25442 = r__$1;
var G__25443 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__25428__$1 = G__25442;
all_vars__$1 = G__25443;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25478){
var state_val_25479 = (state_25478[(1)]);
if((state_val_25479 === (1))){
var inst_25451 = functionArray;
var inst_25452 = cljs.core.seq(inst_25451);
var inst_25453 = cljs.core.first(inst_25452);
var inst_25454 = cljs.core.next(inst_25452);
var inst_25455 = cljs.core.PersistentVector.EMPTY;
var inst_25456 = inst_25451;
var inst_25457 = inst_25455;
var state_25478__$1 = (function (){var statearr_25480 = state_25478;
(statearr_25480[(7)] = inst_25456);

(statearr_25480[(8)] = inst_25454);

(statearr_25480[(9)] = inst_25453);

(statearr_25480[(10)] = inst_25457);

return statearr_25480;
})();
var statearr_25481_25494 = state_25478__$1;
(statearr_25481_25494[(2)] = null);

(statearr_25481_25494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25479 === (2))){
var inst_25463 = (state_25478[(11)]);
var inst_25456 = (state_25478[(7)]);
var inst_25462 = cljs.core.seq(inst_25456);
var inst_25463__$1 = cljs.core.first(inst_25462);
var inst_25464 = cljs.core.next(inst_25462);
var state_25478__$1 = (function (){var statearr_25482 = state_25478;
(statearr_25482[(11)] = inst_25463__$1);

(statearr_25482[(12)] = inst_25464);

return statearr_25482;
})();
if(cljs.core.truth_(inst_25463__$1)){
var statearr_25483_25495 = state_25478__$1;
(statearr_25483_25495[(1)] = (4));

} else {
var statearr_25484_25496 = state_25478__$1;
(statearr_25484_25496[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25479 === (3))){
var inst_25476 = (state_25478[(2)]);
var state_25478__$1 = state_25478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25478__$1,inst_25476);
} else {
if((state_val_25479 === (4))){
var inst_25463 = (state_25478[(11)]);
var inst_25466 = (inst_25463.cljs$core$IFn$_invoke$arity$1 ? inst_25463.cljs$core$IFn$_invoke$arity$1(tuple) : inst_25463.call(null,tuple));
var state_25478__$1 = state_25478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25478__$1,(7),inst_25466);
} else {
if((state_val_25479 === (5))){
var inst_25457 = (state_25478[(10)]);
var state_25478__$1 = state_25478;
var statearr_25485_25497 = state_25478__$1;
(statearr_25485_25497[(2)] = inst_25457);

(statearr_25485_25497[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25479 === (6))){
var inst_25474 = (state_25478[(2)]);
var state_25478__$1 = state_25478;
var statearr_25486_25498 = state_25478__$1;
(statearr_25486_25498[(2)] = inst_25474);

(statearr_25486_25498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25479 === (7))){
var inst_25464 = (state_25478[(12)]);
var inst_25457 = (state_25478[(10)]);
var inst_25468 = (state_25478[(2)]);
var inst_25469 = fluree.db.util.async.throw_err(inst_25468);
var inst_25470 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25457,inst_25469);
var inst_25456 = inst_25464;
var inst_25457__$1 = inst_25470;
var state_25478__$1 = (function (){var statearr_25487 = state_25478;
(statearr_25487[(7)] = inst_25456);

(statearr_25487[(10)] = inst_25457__$1);

return statearr_25487;
})();
var statearr_25488_25499 = state_25478__$1;
(statearr_25488_25499[(2)] = null);

(statearr_25488_25499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____0 = (function (){
var statearr_25489 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25489[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__);

(statearr_25489[(1)] = (1));

return statearr_25489;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____1 = (function (state_25478){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25478);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25490){var ex__2730__auto__ = e25490;
var statearr_25491_25500 = state_25478;
(statearr_25491_25500[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25478[(4)]))){
var statearr_25492_25501 = state_25478;
(statearr_25492_25501[(1)] = cljs.core.first((state_25478[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25502 = state_25478;
state_25478 = G__25502;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__ = function(state_25478){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____1.call(this,state_25478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2727__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25493 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25493[(6)] = c__2749__auto__);

return statearr_25493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__25503){
var vec__25504 = p__25503;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25504,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25504,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25518){
var state_val_25519 = (state_25518[(1)]);
if((state_val_25519 === (1))){
var inst_25507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25508 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_25509 = [query_map,_id,query_opts];
var inst_25510 = cljs.core.PersistentHashMap.fromArrays(inst_25508,inst_25509);
var inst_25511 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_25510) : fluree.db.query.fql.query.call(null,db,inst_25510));
var state_25518__$1 = (function (){var statearr_25520 = state_25518;
(statearr_25520[(7)] = inst_25507);

return statearr_25520;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25518__$1,(2),inst_25511);
} else {
if((state_val_25519 === (2))){
var inst_25507 = (state_25518[(7)]);
var inst_25513 = (state_25518[(2)]);
var inst_25514 = fluree.db.util.async.throw_err(inst_25513);
var inst_25515 = [tuple_index,inst_25514];
var inst_25516 = (new cljs.core.PersistentVector(null,2,(5),inst_25507,inst_25515,null));
var state_25518__$1 = state_25518;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25518__$1,inst_25516);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0 = (function (){
var statearr_25521 = [null,null,null,null,null,null,null,null];
(statearr_25521[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2727__auto__);

(statearr_25521[(1)] = (1));

return statearr_25521;
});
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1 = (function (state_25518){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25518);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25522){var ex__2730__auto__ = e25522;
var statearr_25523_25526 = state_25518;
(statearr_25523_25526[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25518[(4)]))){
var statearr_25524_25527 = state_25518;
(statearr_25524_25527[(1)] = cljs.core.first((state_25518[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25528 = state_25518;
state_25518 = G__25528;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = function(state_25518){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1.call(this,state_25518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25525 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25525[(6)] = c__2749__auto__);

return statearr_25525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__25529 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25529,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25529,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25592){
var state_val_25593 = (state_25592[(1)]);
if((state_val_25593 === (7))){
var inst_25587 = (state_25592[(2)]);
var _ = (function (){var statearr_25594 = state_25592;
(statearr_25594[(4)] = cljs.core.rest((state_25592[(4)])));

return statearr_25594;
})();
var state_25592__$1 = state_25592;
var statearr_25595_25686 = state_25592__$1;
(statearr_25595_25686[(2)] = inst_25587);

(statearr_25595_25686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (20))){
var inst_25578 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25596_25687 = state_25592__$1;
(statearr_25596_25687[(2)] = inst_25578);

(statearr_25596_25687[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (1))){
var state_25592__$1 = state_25592;
var statearr_25597_25688 = state_25592__$1;
(statearr_25597_25688[(2)] = null);

(statearr_25597_25688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (4))){
var inst_25534 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25598_25689 = state_25592__$1;
(statearr_25598_25689[(2)] = inst_25534);

(statearr_25598_25689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (15))){
var inst_25554 = (state_25592[(7)]);
var inst_25563 = cljs.core.second(inst_25554);
var inst_25564 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_25563);
var inst_25565 = (inst_25564 > max_fuel);
var state_25592__$1 = state_25592;
if(cljs.core.truth_(inst_25565)){
var statearr_25599_25690 = state_25592__$1;
(statearr_25599_25690[(1)] = (18));

} else {
var statearr_25600_25691 = state_25592__$1;
(statearr_25600_25691[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (13))){
var state_25592__$1 = state_25592;
var statearr_25601_25692 = state_25592__$1;
(statearr_25601_25692[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (6))){
var inst_25542 = (state_25592[(8)]);
var state_25592__$1 = state_25592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25592__$1,(8),inst_25542);
} else {
if((state_val_25593 === (17))){
var inst_25581 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25603_25693 = state_25592__$1;
(statearr_25603_25693[(2)] = inst_25581);

(statearr_25603_25693[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (3))){
var inst_25590 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25592__$1,inst_25590);
} else {
if((state_val_25593 === (12))){
var inst_25543 = (state_25592[(9)]);
var inst_25554 = (state_25592[(7)]);
var inst_25560 = (inst_25543.cljs$core$IFn$_invoke$arity$0 ? inst_25543.cljs$core$IFn$_invoke$arity$0() : inst_25543.call(null));
var state_25592__$1 = (function (){var statearr_25604 = state_25592;
(statearr_25604[(10)] = inst_25560);

return statearr_25604;
})();
var statearr_25605_25694 = state_25592__$1;
(statearr_25605_25694[(2)] = inst_25554);

(statearr_25605_25694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (2))){
var inst_25543 = (state_25592[(9)]);
var inst_25542 = (state_25592[(8)]);
var _ = (function (){var statearr_25606 = state_25592;
(statearr_25606[(4)] = cljs.core.cons((5),(state_25592[(4)])));

return statearr_25606;
})();
var inst_25540 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_25541 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_25542__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_25543__$1 = (function (){var expandMaps = inst_25540;
var queue_ch = inst_25541;
var res_ch = inst_25542__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_25544 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_25545 = cljs.core.volatile_BANG_((0));
var inst_25546 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25544,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_25545);
var inst_25547 = (function (){var expandMaps = inst_25540;
var queue_ch = inst_25541;
var res_ch = inst_25542__$1;
var stop_BANG_ = inst_25543__$1;
var opts_STAR_ = inst_25546;
return (function (tuple_res,port){
var c__2749__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25639){
var state_val_25640 = (state_25639[(1)]);
if((state_val_25640 === (7))){
var state_25639__$1 = state_25639;
var statearr_25641_25695 = state_25639__$1;
(statearr_25641_25695[(2)] = tuple_res);

(statearr_25641_25695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25640 === (1))){
var state_25639__$1 = state_25639;
var statearr_25642_25696 = state_25639__$1;
(statearr_25642_25696[(2)] = null);

(statearr_25642_25696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25640 === (4))){
var inst_25607 = (state_25639[(2)]);
var inst_25608 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_25607);
var inst_25609 = cljs.core.async.close_BANG_(port);
var state_25639__$1 = (function (){var statearr_25643 = state_25639;
(statearr_25643[(7)] = inst_25608);

return statearr_25643;
})();
var statearr_25644_25697 = state_25639__$1;
(statearr_25644_25697[(2)] = inst_25609);

(statearr_25644_25697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25640 === (6))){
var inst_25616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25617 = [tuple_res];
var inst_25618 = (new cljs.core.PersistentVector(null,1,(5),inst_25616,inst_25617,null));
var state_25639__$1 = state_25639;
var statearr_25645_25698 = state_25639__$1;
(statearr_25645_25698[(2)] = inst_25618);

(statearr_25645_25698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25640 === (3))){
var inst_25637 = (state_25639[(2)]);
var state_25639__$1 = state_25639;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25639__$1,inst_25637);
} else {
if((state_val_25640 === (2))){
var ___$1 = (function (){var statearr_25647 = state_25639;
(statearr_25647[(4)] = cljs.core.cons((5),(state_25639[(4)])));

return statearr_25647;
})();
var state_25639__$1 = state_25639;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_25648_25699 = state_25639__$1;
(statearr_25648_25699[(1)] = (6));

} else {
var statearr_25649_25700 = state_25639__$1;
(statearr_25649_25700[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25640 === (9))){
var inst_25623 = (state_25639[(8)]);
var inst_25621 = (state_25639[(9)]);
var inst_25630 = (state_25639[(2)]);
var inst_25631 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_25621,inst_25630);
var inst_25632 = (inst_25623.cljs$core$IFn$_invoke$arity$1 ? inst_25623.cljs$core$IFn$_invoke$arity$1(inst_25631) : inst_25623.call(null,inst_25631));
var inst_25633 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_25632);
var inst_25634 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_25650 = state_25639;
(statearr_25650[(4)] = cljs.core.rest((state_25639[(4)])));

return statearr_25650;
})();
var state_25639__$1 = (function (){var statearr_25651 = state_25639;
(statearr_25651[(10)] = inst_25633);

return statearr_25651;
})();
var statearr_25652_25701 = state_25639__$1;
(statearr_25652_25701[(2)] = inst_25634);

(statearr_25652_25701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25640 === (5))){
var ___$1 = (function (){var statearr_25653 = state_25639;
(statearr_25653[(4)] = cljs.core.rest((state_25639[(4)])));

return statearr_25653;
})();
var state_25639__$1 = state_25639;
var ex25646 = (state_25639__$1[(2)]);
var statearr_25654_25702 = state_25639__$1;
(statearr_25654_25702[(5)] = ex25646);


var statearr_25655_25703 = state_25639__$1;
(statearr_25655_25703[(1)] = (4));

(statearr_25655_25703[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25640 === (8))){
var inst_25621 = (state_25639[(9)]);
var inst_25621__$1 = (state_25639[(2)]);
var inst_25622 = cljs.core.volatile_BANG_((0));
var inst_25623 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25621__$1;
var query_fuel = inst_25622;
return (function (p1__25533_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__25533_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25533_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_25624 = cljs.core.PersistentVector.EMPTY;
var inst_25625 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25621__$1;
var query_fuel = inst_25622;
return (function (p1__25532_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__25532_SHARP_);
});
})();
var inst_25626 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_25625,expandMaps);
var inst_25627 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_25626);
var inst_25628 = cljs.core.async.into(inst_25624,inst_25627);
var state_25639__$1 = (function (){var statearr_25656 = state_25639;
(statearr_25656[(8)] = inst_25623);

(statearr_25656[(9)] = inst_25621__$1);

return statearr_25656;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25639__$1,(9),inst_25628);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_25657 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25657[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_25657[(1)] = (1));

return statearr_25657;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_25639){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25639);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25658){var ex__2730__auto__ = e25658;
var statearr_25659_25704 = state_25639;
(statearr_25659_25704[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25639[(4)]))){
var statearr_25660_25705 = state_25639;
(statearr_25660_25705[(1)] = cljs.core.first((state_25639[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25706 = state_25639;
state_25639 = G__25706;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_25639){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_25639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25661 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25661[(6)] = c__2749__auto____$1);

return statearr_25661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto____$1;
});
})();
var inst_25548 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25541,tuples_res);
var inst_25549 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_25542__$1,inst_25547,inst_25541);
var inst_25550 = cljs.core.PersistentVector.EMPTY;
var inst_25551 = inst_25550;
var state_25592__$1 = (function (){var statearr_25662 = state_25592;
(statearr_25662[(9)] = inst_25543__$1);

(statearr_25662[(8)] = inst_25542__$1);

(statearr_25662[(11)] = inst_25551);

(statearr_25662[(12)] = inst_25549);

(statearr_25662[(13)] = inst_25548);

return statearr_25662;
})();
var statearr_25663_25707 = state_25592__$1;
(statearr_25663_25707[(2)] = null);

(statearr_25663_25707[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (19))){
var inst_25551 = (state_25592[(11)]);
var inst_25554 = (state_25592[(7)]);
var inst_25574 = cljs.core.first(inst_25554);
var inst_25575 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25551,inst_25574);
var inst_25551__$1 = inst_25575;
var state_25592__$1 = (function (){var statearr_25664 = state_25592;
(statearr_25664[(11)] = inst_25551__$1);

return statearr_25664;
})();
var statearr_25665_25708 = state_25592__$1;
(statearr_25665_25708[(2)] = null);

(statearr_25665_25708[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (11))){
var inst_25585 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25667_25709 = state_25592__$1;
(statearr_25667_25709[(2)] = inst_25585);

(statearr_25667_25709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (9))){
var inst_25551 = (state_25592[(11)]);
var state_25592__$1 = state_25592;
var statearr_25668_25710 = state_25592__$1;
(statearr_25668_25710[(2)] = inst_25551);

(statearr_25668_25710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (5))){
var _ = (function (){var statearr_25669 = state_25592;
(statearr_25669[(4)] = cljs.core.rest((state_25592[(4)])));

return statearr_25669;
})();
var state_25592__$1 = state_25592;
var ex25666 = (state_25592__$1[(2)]);
var statearr_25670_25711 = state_25592__$1;
(statearr_25670_25711[(5)] = ex25666);


if((ex25666 instanceof Error)){
var statearr_25671_25712 = state_25592__$1;
(statearr_25671_25712[(1)] = (4));

(statearr_25671_25712[(5)] = null);

} else {
throw ex25666;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (14))){
var inst_25583 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25672_25713 = state_25592__$1;
(statearr_25672_25713[(2)] = inst_25583);

(statearr_25672_25713[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (16))){
var state_25592__$1 = state_25592;
var statearr_25673_25714 = state_25592__$1;
(statearr_25673_25714[(2)] = null);

(statearr_25673_25714[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (10))){
var inst_25554 = (state_25592[(7)]);
var inst_25558 = fluree.db.util.core.exception_QMARK_(inst_25554);
var state_25592__$1 = state_25592;
if(inst_25558){
var statearr_25674_25715 = state_25592__$1;
(statearr_25674_25715[(1)] = (12));

} else {
var statearr_25675_25716 = state_25592__$1;
(statearr_25675_25716[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (18))){
var inst_25543 = (state_25592[(9)]);
var inst_25567 = (inst_25543.cljs$core$IFn$_invoke$arity$0 ? inst_25543.cljs$core$IFn$_invoke$arity$0() : inst_25543.call(null));
var inst_25568 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_25569 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25570 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_25571 = cljs.core.PersistentHashMap.fromArrays(inst_25569,inst_25570);
var inst_25572 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25568,inst_25571);
var state_25592__$1 = (function (){var statearr_25676 = state_25592;
(statearr_25676[(14)] = inst_25567);

return statearr_25676;
})();
var statearr_25677_25717 = state_25592__$1;
(statearr_25677_25717[(2)] = inst_25572);

(statearr_25677_25717[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (8))){
var inst_25554 = (state_25592[(7)]);
var inst_25554__$1 = (state_25592[(2)]);
var inst_25555 = (inst_25554__$1 == null);
var state_25592__$1 = (function (){var statearr_25678 = state_25592;
(statearr_25678[(7)] = inst_25554__$1);

return statearr_25678;
})();
if(cljs.core.truth_(inst_25555)){
var statearr_25679_25718 = state_25592__$1;
(statearr_25679_25718[(1)] = (9));

} else {
var statearr_25680_25719 = state_25592__$1;
(statearr_25680_25719[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_25681 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25681[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_25681[(1)] = (1));

return statearr_25681;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_25592){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25592);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25682){var ex__2730__auto__ = e25682;
var statearr_25683_25720 = state_25592;
(statearr_25683_25720[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25592[(4)]))){
var statearr_25684_25721 = state_25592;
(statearr_25684_25721[(1)] = cljs.core.first((state_25592[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25722 = state_25592;
state_25592 = G__25722;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_25592){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_25592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25685 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25685[(6)] = c__2749__auto__);

return statearr_25685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25723 = select;
var map__25723__$1 = cljs.core.__destructure_map(map__25723);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25723__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25723__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25723__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25726 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25726,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25726,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25726,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25724_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25724_SHARP_,compare_idx));
}):(function (p1__25725_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25725_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25731 = arguments.length;
switch (G__25731) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25732,p__25733,group_limit,opts){
var map__25734 = p__25732;
var map__25734__$1 = cljs.core.__destructure_map(map__25734);
var res = map__25734__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25734__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25735 = p__25733;
var map__25735__$1 = cljs.core.__destructure_map(map__25735);
var select_spec = map__25735__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25735__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25872){
var state_val_25873 = (state_25872[(1)]);
if((state_val_25873 === (7))){
var inst_25742 = (state_25872[(7)]);
var state_25872__$1 = state_25872;
var statearr_25874_25976 = state_25872__$1;
(statearr_25874_25976[(2)] = inst_25742);

(statearr_25874_25976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (59))){
var inst_25865 = (state_25872[(2)]);
var state_25872__$1 = state_25872;
var statearr_25875_25977 = state_25872__$1;
(statearr_25875_25977[(2)] = inst_25865);

(statearr_25875_25977[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (20))){
var inst_25781 = (state_25872[(8)]);
var inst_25778 = (state_25872[(9)]);
var inst_25777 = (state_25872[(2)]);
var inst_25778__$1 = cljs.core.__destructure_map(inst_25777);
var inst_25779 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25778__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25780 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25778__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25781__$1 = offset;
var state_25872__$1 = (function (){var statearr_25876 = state_25872;
(statearr_25876[(10)] = inst_25780);

(statearr_25876[(8)] = inst_25781__$1);

(statearr_25876[(9)] = inst_25778__$1);

(statearr_25876[(11)] = inst_25779);

return statearr_25876;
})();
if(cljs.core.truth_(inst_25781__$1)){
var statearr_25877_25978 = state_25872__$1;
(statearr_25877_25978[(1)] = (21));

} else {
var statearr_25878_25979 = state_25872__$1;
(statearr_25878_25979[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (58))){
var inst_25857 = (state_25872[(12)]);
var state_25872__$1 = state_25872;
var statearr_25879_25980 = state_25872__$1;
(statearr_25879_25980[(2)] = inst_25857);

(statearr_25879_25980[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (60))){
var inst_25861 = (state_25872[(2)]);
var inst_25862 = fluree.db.util.async.throw_err(inst_25861);
var state_25872__$1 = state_25872;
var statearr_25880_25981 = state_25872__$1;
(statearr_25880_25981[(2)] = inst_25862);

(statearr_25880_25981[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (27))){
var inst_25793 = cljs.core.not(inVector_QMARK_);
var state_25872__$1 = state_25872;
var statearr_25881_25982 = state_25872__$1;
(statearr_25881_25982[(2)] = inst_25793);

(statearr_25881_25982[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (1))){
var state_25872__$1 = state_25872;
var statearr_25882_25983 = state_25872__$1;
(statearr_25882_25983[(2)] = null);

(statearr_25882_25983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (24))){
var state_25872__$1 = state_25872;
var statearr_25883_25984 = state_25872__$1;
(statearr_25883_25984[(2)] = offset);

(statearr_25883_25984[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (55))){
var inst_25851 = (state_25872[(13)]);
var state_25872__$1 = state_25872;
var statearr_25884_25985 = state_25872__$1;
(statearr_25884_25985[(2)] = inst_25851);

(statearr_25884_25985[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (39))){
var inst_25819 = (state_25872[(14)]);
var inst_25821 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25822 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25819,inst_25821);
var state_25872__$1 = state_25872;
var statearr_25885_25986 = state_25872__$1;
(statearr_25885_25986[(2)] = inst_25822);

(statearr_25885_25986[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (46))){
var inst_25831 = (state_25872[(15)]);
var state_25872__$1 = state_25872;
var statearr_25886_25987 = state_25872__$1;
(statearr_25886_25987[(2)] = inst_25831);

(statearr_25886_25987[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (4))){
var inst_25736 = (state_25872[(2)]);
var state_25872__$1 = state_25872;
var statearr_25887_25988 = state_25872__$1;
(statearr_25887_25988[(2)] = inst_25736);

(statearr_25887_25988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (54))){
var inst_25851 = (state_25872[(13)]);
var inst_25845 = (state_25872[(16)]);
var inst_25853 = cljs.core.PersistentVector.EMPTY;
var inst_25854 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_25853,inst_25845,inst_25851);
var state_25872__$1 = state_25872;
var statearr_25888_25989 = state_25872__$1;
(statearr_25888_25989[(2)] = inst_25854);

(statearr_25888_25989[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (15))){
var inst_25763 = (state_25872[(17)]);
var inst_25765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25766 = [inst_25763];
var inst_25767 = (new cljs.core.PersistentVector(null,1,(5),inst_25765,inst_25766,null));
var state_25872__$1 = state_25872;
var statearr_25889_25990 = state_25872__$1;
(statearr_25889_25990[(2)] = inst_25767);

(statearr_25889_25990[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (48))){
var inst_25780 = (state_25872[(10)]);
var inst_25796 = (state_25872[(18)]);
var inst_25801 = (state_25872[(19)]);
var inst_25778 = (state_25872[(9)]);
var inst_25790 = (state_25872[(20)]);
var inst_25837 = (state_25872[(21)]);
var inst_25779 = (state_25872[(11)]);
var inst_25839 = (function (){var map__25772 = inst_25778;
var headers = inst_25779;
var tuples = inst_25780;
var offset_SINGLEQUOTE_ = inst_25790;
var single_result_QMARK_ = inst_25796;
var pp_keys = inst_25801;
var G__25802 = inst_25837;
return (function (p1__25729_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__25729_SHARP_);
});
})();
var inst_25840 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25839);
var inst_25841 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25837,inst_25840);
var state_25872__$1 = state_25872;
var statearr_25890_25991 = state_25872__$1;
(statearr_25890_25991[(2)] = inst_25841);

(statearr_25890_25991[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (50))){
var inst_25844 = (state_25872[(2)]);
var inst_25845 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_25844);
var state_25872__$1 = (function (){var statearr_25891 = state_25872;
(statearr_25891[(16)] = inst_25845);

return statearr_25891;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25892_25992 = state_25872__$1;
(statearr_25892_25992[(1)] = (51));

} else {
var statearr_25893_25993 = state_25872__$1;
(statearr_25893_25993[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (21))){
var inst_25783 = cljs.core.not(groupBy);
var state_25872__$1 = state_25872;
var statearr_25894_25994 = state_25872__$1;
(statearr_25894_25994[(2)] = inst_25783);

(statearr_25894_25994[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (31))){
var state_25872__$1 = state_25872;
var statearr_25895_25995 = state_25872__$1;
(statearr_25895_25995[(2)] = null);

(statearr_25895_25995[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (32))){
var inst_25796 = (state_25872[(18)]);
var inst_25779 = (state_25872[(11)]);
var inst_25801 = (state_25872[(2)]);
var inst_25803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25804 = fluree.db.query.fql.select_tuples_fn(inst_25779,vars,select);
var inst_25805 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25804);
var inst_25806 = [inst_25805];
var inst_25807 = (new cljs.core.PersistentVector(null,1,(5),inst_25803,inst_25806,null));
var state_25872__$1 = (function (){var statearr_25896 = state_25872;
(statearr_25896[(19)] = inst_25801);

(statearr_25896[(22)] = inst_25807);

return statearr_25896;
})();
if(cljs.core.truth_(inst_25796)){
var statearr_25897_25996 = state_25872__$1;
(statearr_25897_25996[(1)] = (33));

} else {
var statearr_25898_25997 = state_25872__$1;
(statearr_25898_25997[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (40))){
var inst_25819 = (state_25872[(14)]);
var state_25872__$1 = state_25872;
var statearr_25899_25998 = state_25872__$1;
(statearr_25899_25998[(2)] = inst_25819);

(statearr_25899_25998[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (56))){
var inst_25857 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25900 = state_25872;
(statearr_25900[(12)] = inst_25857);

return statearr_25900;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25901_25999 = state_25872__$1;
(statearr_25901_25999[(1)] = (57));

} else {
var statearr_25902_26000 = state_25872__$1;
(statearr_25902_26000[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (33))){
var inst_25807 = (state_25872[(22)]);
var inst_25809 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_25810 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25807,inst_25809);
var state_25872__$1 = state_25872;
var statearr_25903_26001 = state_25872__$1;
(statearr_25903_26001[(2)] = inst_25810);

(statearr_25903_26001[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (13))){
var inst_25752 = (state_25872[(23)]);
var state_25872__$1 = state_25872;
var statearr_25904_26002 = state_25872__$1;
(statearr_25904_26002[(2)] = inst_25752);

(statearr_25904_26002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (22))){
var inst_25781 = (state_25872[(8)]);
var state_25872__$1 = state_25872;
var statearr_25905_26003 = state_25872__$1;
(statearr_25905_26003[(2)] = inst_25781);

(statearr_25905_26003[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (36))){
var inst_25813 = (state_25872[(24)]);
var inst_25815 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_25816 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25813,inst_25815);
var state_25872__$1 = state_25872;
var statearr_25906_26004 = state_25872__$1;
(statearr_25906_26004[(2)] = inst_25816);

(statearr_25906_26004[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (41))){
var inst_25790 = (state_25872[(20)]);
var inst_25825 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25907 = state_25872;
(statearr_25907[(25)] = inst_25825);

return statearr_25907;
})();
if(cljs.core.truth_(inst_25790)){
var statearr_25908_26005 = state_25872__$1;
(statearr_25908_26005[(1)] = (42));

} else {
var statearr_25909_26006 = state_25872__$1;
(statearr_25909_26006[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (43))){
var inst_25825 = (state_25872[(25)]);
var state_25872__$1 = state_25872;
var statearr_25910_26007 = state_25872__$1;
(statearr_25910_26007[(2)] = inst_25825);

(statearr_25910_26007[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (29))){
var inst_25796 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25911 = state_25872;
(statearr_25911[(18)] = inst_25796);

return statearr_25911;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25912_26008 = state_25872__$1;
(statearr_25912_26008[(1)] = (30));

} else {
var statearr_25913_26009 = state_25872__$1;
(statearr_25913_26009[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (44))){
var inst_25831 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25914 = state_25872;
(statearr_25914[(15)] = inst_25831);

return statearr_25914;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25915_26010 = state_25872__$1;
(statearr_25915_26010[(1)] = (45));

} else {
var statearr_25916_26011 = state_25872__$1;
(statearr_25916_26011[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (6))){
var inst_25744 = cljs.core.count(select);
var inst_25745 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_25744);
var state_25872__$1 = state_25872;
var statearr_25917_26012 = state_25872__$1;
(statearr_25917_26012[(2)] = inst_25745);

(statearr_25917_26012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (28))){
var inst_25791 = (state_25872[(26)]);
var state_25872__$1 = state_25872;
var statearr_25918_26013 = state_25872__$1;
(statearr_25918_26013[(2)] = inst_25791);

(statearr_25918_26013[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (51))){
var inst_25780 = (state_25872[(10)]);
var inst_25779 = (state_25872[(11)]);
var inst_25848 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_25779,orderBy,inst_25780);
var state_25872__$1 = state_25872;
var statearr_25919_26014 = state_25872__$1;
(statearr_25919_26014[(2)] = inst_25848);

(statearr_25919_26014[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (25))){
var state_25872__$1 = state_25872;
var statearr_25920_26015 = state_25872__$1;
(statearr_25920_26015[(2)] = null);

(statearr_25920_26015[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (34))){
var inst_25807 = (state_25872[(22)]);
var state_25872__$1 = state_25872;
var statearr_25921_26016 = state_25872__$1;
(statearr_25921_26016[(2)] = inst_25807);

(statearr_25921_26016[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (17))){
var inst_25770 = (state_25872[(2)]);
var state_25872__$1 = state_25872;
var statearr_25922_26017 = state_25872__$1;
(statearr_25922_26017[(2)] = inst_25770);

(statearr_25922_26017[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (3))){
var inst_25870 = (state_25872[(2)]);
var state_25872__$1 = state_25872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25872__$1,inst_25870);
} else {
if((state_val_25873 === (12))){
var inst_25752 = (state_25872[(23)]);
var inst_25754 = cljs.core.first(select);
var inst_25755 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25754);
var inst_25756 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25755);
var inst_25757 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_25756,(1));
var inst_25758 = [inst_25757];
var inst_25759 = [inst_25752];
var inst_25760 = cljs.core.PersistentHashMap.fromArrays(inst_25758,inst_25759);
var state_25872__$1 = state_25872;
var statearr_25923_26018 = state_25872__$1;
(statearr_25923_26018[(2)] = inst_25760);

(statearr_25923_26018[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (2))){
var inst_25742 = (state_25872[(7)]);
var _ = (function (){var statearr_25924 = state_25872;
(statearr_25924[(4)] = cljs.core.cons((5),(state_25872[(4)])));

return statearr_25924;
})();
var inst_25742__$1 = aggregates;
var state_25872__$1 = (function (){var statearr_25925 = state_25872;
(statearr_25925[(7)] = inst_25742__$1);

return statearr_25925;
})();
if(cljs.core.truth_(inst_25742__$1)){
var statearr_25926_26019 = state_25872__$1;
(statearr_25926_26019[(1)] = (6));

} else {
var statearr_25927_26020 = state_25872__$1;
(statearr_25927_26020[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (23))){
var inst_25786 = (state_25872[(2)]);
var state_25872__$1 = state_25872;
if(cljs.core.truth_(inst_25786)){
var statearr_25928_26021 = state_25872__$1;
(statearr_25928_26021[(1)] = (24));

} else {
var statearr_25929_26022 = state_25872__$1;
(statearr_25929_26022[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (47))){
var inst_25837 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25930 = state_25872;
(statearr_25930[(21)] = inst_25837);

return statearr_25930;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25931_26023 = state_25872__$1;
(statearr_25931_26023[(1)] = (48));

} else {
var statearr_25932_26024 = state_25872__$1;
(statearr_25932_26024[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (35))){
var inst_25813 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25933 = state_25872;
(statearr_25933[(24)] = inst_25813);

return statearr_25933;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25934_26025 = state_25872__$1;
(statearr_25934_26025[(1)] = (36));

} else {
var statearr_25935_26026 = state_25872__$1;
(statearr_25935_26026[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (19))){
var state_25872__$1 = state_25872;
var statearr_25936_26027 = state_25872__$1;
(statearr_25936_26027[(2)] = res);

(statearr_25936_26027[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (57))){
var inst_25796 = (state_25872[(18)]);
var inst_25801 = (state_25872[(19)]);
var inst_25857 = (state_25872[(12)]);
var inst_25859 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_25801,inst_25796,db,fuel,max_fuel,opts,(8),inst_25857);
var state_25872__$1 = state_25872;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25872__$1,(60),inst_25859);
} else {
if((state_val_25873 === (11))){
var inst_25867 = (state_25872[(2)]);
var _ = (function (){var statearr_25938 = state_25872;
(statearr_25938[(4)] = cljs.core.rest((state_25872[(4)])));

return statearr_25938;
})();
var state_25872__$1 = state_25872;
var statearr_25939_26028 = state_25872__$1;
(statearr_25939_26028[(2)] = inst_25867);

(statearr_25939_26028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (9))){
var inst_25750 = cljs.core.first(aggregates);
var inst_25751 = fluree.db.query.analytical.calculate_aggregate(res,inst_25750);
var inst_25752 = cljs.core.second(inst_25751);
var state_25872__$1 = (function (){var statearr_25940 = state_25872;
(statearr_25940[(23)] = inst_25752);

return statearr_25940;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25941_26029 = state_25872__$1;
(statearr_25941_26029[(1)] = (12));

} else {
var statearr_25942_26030 = state_25872__$1;
(statearr_25942_26030[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (5))){
var _ = (function (){var statearr_25943 = state_25872;
(statearr_25943[(4)] = cljs.core.rest((state_25872[(4)])));

return statearr_25943;
})();
var state_25872__$1 = state_25872;
var ex25937 = (state_25872__$1[(2)]);
var statearr_25944_26031 = state_25872__$1;
(statearr_25944_26031[(5)] = ex25937);


if((ex25937 instanceof Error)){
var statearr_25945_26032 = state_25872__$1;
(statearr_25945_26032[(1)] = (4));

(statearr_25945_26032[(5)] = null);

} else {
throw ex25937;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (14))){
var inst_25763 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25946 = state_25872;
(statearr_25946[(17)] = inst_25763);

return statearr_25946;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25947_26033 = state_25872__$1;
(statearr_25947_26033[(1)] = (15));

} else {
var statearr_25948_26034 = state_25872__$1;
(statearr_25948_26034[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (45))){
var inst_25831 = (state_25872[(15)]);
var inst_25833 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_25834 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25831,inst_25833);
var state_25872__$1 = state_25872;
var statearr_25949_26035 = state_25872__$1;
(statearr_25949_26035[(2)] = inst_25834);

(statearr_25949_26035[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (53))){
var inst_25851 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25950 = state_25872;
(statearr_25950[(13)] = inst_25851);

return statearr_25950;
})();
var statearr_25951_26036 = state_25872__$1;
(statearr_25951_26036[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (26))){
var inst_25791 = (state_25872[(26)]);
var inst_25790 = (state_25872[(2)]);
var inst_25791__$1 = cljs.core.not(prettyPrint);
var state_25872__$1 = (function (){var statearr_25953 = state_25872;
(statearr_25953[(20)] = inst_25790);

(statearr_25953[(26)] = inst_25791__$1);

return statearr_25953;
})();
if(inst_25791__$1){
var statearr_25954_26037 = state_25872__$1;
(statearr_25954_26037[(1)] = (27));

} else {
var statearr_25955_26038 = state_25872__$1;
(statearr_25955_26038[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (16))){
var inst_25763 = (state_25872[(17)]);
var state_25872__$1 = state_25872;
var statearr_25956_26039 = state_25872__$1;
(statearr_25956_26039[(2)] = inst_25763);

(statearr_25956_26039[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (38))){
var inst_25819 = (state_25872[(2)]);
var state_25872__$1 = (function (){var statearr_25957 = state_25872;
(statearr_25957[(14)] = inst_25819);

return statearr_25957;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25958_26040 = state_25872__$1;
(statearr_25958_26040[(1)] = (39));

} else {
var statearr_25959_26041 = state_25872__$1;
(statearr_25959_26041[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (30))){
var inst_25798 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25872__$1 = state_25872;
var statearr_25960_26042 = state_25872__$1;
(statearr_25960_26042[(2)] = inst_25798);

(statearr_25960_26042[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (10))){
var state_25872__$1 = state_25872;
if(cljs.core.truth_(aggregates)){
var statearr_25961_26043 = state_25872__$1;
(statearr_25961_26043[(1)] = (18));

} else {
var statearr_25962_26044 = state_25872__$1;
(statearr_25962_26044[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (18))){
var inst_25774 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25872__$1 = state_25872;
var statearr_25963_26045 = state_25872__$1;
(statearr_25963_26045[(2)] = inst_25774);

(statearr_25963_26045[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (52))){
var inst_25780 = (state_25872[(10)]);
var state_25872__$1 = state_25872;
var statearr_25964_26046 = state_25872__$1;
(statearr_25964_26046[(2)] = inst_25780);

(statearr_25964_26046[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (42))){
var inst_25790 = (state_25872[(20)]);
var inst_25825 = (state_25872[(25)]);
var inst_25827 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_25790);
var inst_25828 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25825,inst_25827);
var state_25872__$1 = state_25872;
var statearr_25965_26047 = state_25872__$1;
(statearr_25965_26047[(2)] = inst_25828);

(statearr_25965_26047[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (37))){
var inst_25813 = (state_25872[(24)]);
var state_25872__$1 = state_25872;
var statearr_25966_26048 = state_25872__$1;
(statearr_25966_26048[(2)] = inst_25813);

(statearr_25966_26048[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (8))){
var inst_25748 = (state_25872[(2)]);
var state_25872__$1 = state_25872;
if(cljs.core.truth_(inst_25748)){
var statearr_25967_26049 = state_25872__$1;
(statearr_25967_26049[(1)] = (9));

} else {
var statearr_25968_26050 = state_25872__$1;
(statearr_25968_26050[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25873 === (49))){
var inst_25837 = (state_25872[(21)]);
var state_25872__$1 = state_25872;
var statearr_25969_26051 = state_25872__$1;
(statearr_25969_26051[(2)] = inst_25837);

(statearr_25969_26051[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_25970 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25970[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_25970[(1)] = (1));

return statearr_25970;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_25872){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25872);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25971){var ex__2730__auto__ = e25971;
var statearr_25972_26052 = state_25872;
(statearr_25972_26052[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25872[(4)]))){
var statearr_25973_26053 = state_25872;
(statearr_25973_26053[(1)] = cljs.core.first((state_25872[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26054 = state_25872;
state_25872 = G__26054;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_25872){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_25872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25974 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25974[(6)] = c__2749__auto__);

return statearr_25974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__26057,groupBy){
var map__26058 = p__26057;
var map__26058__$1 = cljs.core.__destructure_map(map__26058);
var res = map__26058__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26058__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26058__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__26059 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26059,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26059,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__26055_SHARP_){
return fluree.db.util.core.index_of(headers,p1__26055_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__26056_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__26056_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__26062 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26062,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26062,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__26065,p__26066,opts){
var map__26067 = p__26065;
var map__26067__$1 = cljs.core.__destructure_map(map__26067);
var res = map__26067__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26067__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26067__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__26068 = p__26066;
var map__26068__$1 = cljs.core.__destructure_map(map__26068);
var select_spec = map__26068__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26068__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26068__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26068__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26068__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26068__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26068__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26068__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26310){
var state_val_26311 = (state_26310[(1)]);
if((state_val_26311 === (65))){
var state_26310__$1 = state_26310;
var statearr_26312_26463 = state_26310__$1;
(statearr_26312_26463[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (70))){
var inst_26231 = (state_26310[(7)]);
var state_26310__$1 = state_26310;
var statearr_26314_26464 = state_26310__$1;
(statearr_26314_26464[(2)] = inst_26231);

(statearr_26314_26464[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (62))){
var state_26310__$1 = state_26310;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26315_26465 = state_26310__$1;
(statearr_26315_26465[(1)] = (64));

} else {
var statearr_26316_26466 = state_26310__$1;
(statearr_26316_26466[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (74))){
var inst_26147 = (state_26310[(8)]);
var inst_26138 = (state_26310[(9)]);
var inst_26206 = (state_26310[(10)]);
var inst_26239 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26138,inst_26147,inst_26206);
var state_26310__$1 = state_26310;
var statearr_26317_26467 = state_26310__$1;
(statearr_26317_26467[(2)] = inst_26239);

(statearr_26317_26467[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (7))){
var state_26310__$1 = state_26310;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26318_26468 = state_26310__$1;
(statearr_26318_26468[(1)] = (82));

} else {
var statearr_26319_26469 = state_26310__$1;
(statearr_26319_26469[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (59))){
var inst_26136 = (state_26310[(11)]);
var inst_26206 = (state_26310[(10)]);
var inst_26210 = cljs.core.count(inst_26206);
var inst_26211 = (inst_26136 - inst_26210);
var state_26310__$1 = state_26310;
var statearr_26320_26470 = state_26310__$1;
(statearr_26320_26470[(2)] = inst_26211);

(statearr_26320_26470[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (86))){
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_26321_26471 = state_26310__$1;
(statearr_26321_26471[(1)] = (89));

} else {
var statearr_26322_26472 = state_26310__$1;
(statearr_26322_26472[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (20))){
var state_26310__$1 = state_26310;
var statearr_26323_26473 = state_26310__$1;
(statearr_26323_26473[(2)] = (0));

(statearr_26323_26473[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (72))){
var inst_26236 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26236)){
var statearr_26324_26474 = state_26310__$1;
(statearr_26324_26474[(1)] = (73));

} else {
var statearr_26325_26475 = state_26310__$1;
(statearr_26325_26475[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (58))){
var state_26310__$1 = state_26310;
var statearr_26326_26476 = state_26310__$1;
(statearr_26326_26476[(2)] = null);

(statearr_26326_26476[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (60))){
var inst_26137 = (state_26310[(12)]);
var inst_26213 = (state_26310[(2)]);
var inst_26214 = (inst_26137 <= (0));
var state_26310__$1 = (function (){var statearr_26327 = state_26310;
(statearr_26327[(13)] = inst_26213);

return statearr_26327;
})();
if(cljs.core.truth_(inst_26214)){
var statearr_26328_26477 = state_26310__$1;
(statearr_26328_26477[(1)] = (61));

} else {
var statearr_26329_26478 = state_26310__$1;
(statearr_26329_26478[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (27))){
var inst_26136 = (state_26310[(11)]);
var inst_26160 = (inst_26136 < (1));
var state_26310__$1 = state_26310;
var statearr_26330_26479 = state_26310__$1;
(statearr_26330_26479[(2)] = inst_26160);

(statearr_26330_26479[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (1))){
var state_26310__$1 = state_26310;
var statearr_26331_26480 = state_26310__$1;
(statearr_26331_26480[(2)] = null);

(statearr_26331_26480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (69))){
var inst_26226 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26332_26481 = state_26310__$1;
(statearr_26332_26481[(2)] = inst_26226);

(statearr_26332_26481[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (24))){
var inst_26138 = (state_26310[(9)]);
var state_26310__$1 = state_26310;
var statearr_26333_26482 = state_26310__$1;
(statearr_26333_26482[(2)] = inst_26138);

(statearr_26333_26482[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (55))){
var inst_26136 = (state_26310[(11)]);
var inst_26196 = (state_26310[(14)]);
var inst_26203 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26136,inst_26196);
var state_26310__$1 = state_26310;
var statearr_26334_26483 = state_26310__$1;
(statearr_26334_26483[(2)] = inst_26203);

(statearr_26334_26483[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (85))){
var inst_26281 = (state_26310[(15)]);
var inst_26280 = (state_26310[(2)]);
var inst_26281__$1 = fluree.db.util.async.throw_err(inst_26280);
var inst_26282 = cljs.core.coll_QMARK_(inst_26281__$1);
var inst_26283 = (!(inst_26282));
var state_26310__$1 = (function (){var statearr_26335 = state_26310;
(statearr_26335[(15)] = inst_26281__$1);

return statearr_26335;
})();
if(inst_26283){
var statearr_26336_26484 = state_26310__$1;
(statearr_26336_26484[(1)] = (86));

} else {
var statearr_26337_26485 = state_26310__$1;
(statearr_26337_26485[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (39))){
var inst_26155 = (state_26310[(16)]);
var inst_26177 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_26178 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_26179 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_26155,inst_26177,inst_26178);
var state_26310__$1 = state_26310;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26310__$1,(42),inst_26179);
} else {
if((state_val_26311 === (88))){
var inst_26303 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26338_26486 = state_26310__$1;
(statearr_26338_26486[(2)] = inst_26303);

(statearr_26338_26486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (46))){
var inst_26137 = (state_26310[(12)]);
var inst_26191 = ((0) < inst_26137);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26191)){
var statearr_26339_26487 = state_26310__$1;
(statearr_26339_26487[(1)] = (49));

} else {
var statearr_26340_26488 = state_26310__$1;
(statearr_26340_26488[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (4))){
var inst_26069 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26341_26489 = state_26310__$1;
(statearr_26341_26489[(2)] = inst_26069);

(statearr_26341_26489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (77))){
var inst_26136 = (state_26310[(11)]);
var inst_26247 = (inst_26136 - (1));
var state_26310__$1 = state_26310;
var statearr_26342_26490 = state_26310__$1;
(statearr_26342_26490[(2)] = inst_26247);

(statearr_26342_26490[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (95))){
var inst_26281 = (state_26310[(15)]);
var state_26310__$1 = state_26310;
var statearr_26343_26491 = state_26310__$1;
(statearr_26343_26491[(2)] = inst_26281);

(statearr_26343_26491[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (54))){
var inst_26201 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26201)){
var statearr_26344_26492 = state_26310__$1;
(statearr_26344_26492[(1)] = (55));

} else {
var statearr_26345_26493 = state_26310__$1;
(statearr_26345_26493[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (92))){
var inst_26281 = (state_26310[(15)]);
var inst_26294 = cljs.core.first(inst_26281);
var state_26310__$1 = state_26310;
var statearr_26346_26494 = state_26310__$1;
(statearr_26346_26494[(2)] = inst_26294);

(statearr_26346_26494[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (15))){
var inst_26087 = (state_26310[(17)]);
var inst_26095 = (state_26310[(2)]);
var inst_26096 = fluree.db.util.async.throw_err(inst_26095);
var inst_26097 = [inst_26087];
var inst_26098 = [inst_26096];
var inst_26099 = cljs.core.PersistentHashMap.fromArrays(inst_26097,inst_26098);
var state_26310__$1 = state_26310;
var statearr_26347_26495 = state_26310__$1;
(statearr_26347_26495[(2)] = inst_26099);

(statearr_26347_26495[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (48))){
var inst_26259 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26348_26496 = state_26310__$1;
(statearr_26348_26496[(2)] = inst_26259);

(statearr_26348_26496[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (50))){
var inst_26182 = (state_26310[(18)]);
var state_26310__$1 = state_26310;
var statearr_26349_26497 = state_26310__$1;
(statearr_26349_26497[(2)] = inst_26182);

(statearr_26349_26497[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (75))){
var inst_26151 = (state_26310[(19)]);
var inst_26230 = (state_26310[(20)]);
var inst_26148 = (state_26310[(21)]);
var inst_26213 = (state_26310[(13)]);
var inst_26241 = (state_26310[(2)]);
var inst_26134 = inst_26148;
var inst_26135 = inst_26151;
var inst_26136 = inst_26213;
var inst_26137 = inst_26230;
var inst_26138 = inst_26241;
var state_26310__$1 = (function (){var statearr_26350 = state_26310;
(statearr_26350[(9)] = inst_26138);

(statearr_26350[(22)] = inst_26135);

(statearr_26350[(12)] = inst_26137);

(statearr_26350[(23)] = inst_26134);

(statearr_26350[(11)] = inst_26136);

return statearr_26350;
})();
var statearr_26351_26498 = state_26310__$1;
(statearr_26351_26498[(2)] = null);

(statearr_26351_26498[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (21))){
var inst_26115 = (state_26310[(24)]);
var inst_26127 = (state_26310[(25)]);
var inst_26119 = (state_26310[(26)]);
var inst_26132 = (state_26310[(2)]);
var inst_26133 = cljs.core.PersistentHashMap.EMPTY;
var inst_26134 = inst_26115;
var inst_26135 = inst_26119;
var inst_26136 = inst_26127;
var inst_26137 = inst_26132;
var inst_26138 = inst_26133;
var state_26310__$1 = (function (){var statearr_26352 = state_26310;
(statearr_26352[(9)] = inst_26138);

(statearr_26352[(22)] = inst_26135);

(statearr_26352[(12)] = inst_26137);

(statearr_26352[(23)] = inst_26134);

(statearr_26352[(11)] = inst_26136);

return statearr_26352;
})();
var statearr_26353_26499 = state_26310__$1;
(statearr_26353_26499[(2)] = null);

(statearr_26353_26499[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (31))){
var inst_26152 = (state_26310[(27)]);
var inst_26137 = (state_26310[(12)]);
var inst_26166 = (inst_26137 >= inst_26152);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26166)){
var statearr_26354_26500 = state_26310__$1;
(statearr_26354_26500[(1)] = (33));

} else {
var statearr_26355_26501 = state_26310__$1;
(statearr_26355_26501[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (32))){
var inst_26266 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26356_26502 = state_26310__$1;
(statearr_26356_26502[(2)] = inst_26266);

(statearr_26356_26502[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (40))){
var state_26310__$1 = state_26310;
var statearr_26357_26503 = state_26310__$1;
(statearr_26357_26503[(2)] = null);

(statearr_26357_26503[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (91))){
var inst_26291 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26358_26504 = state_26310__$1;
(statearr_26358_26504[(2)] = inst_26291);

(statearr_26358_26504[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (56))){
var inst_26196 = (state_26310[(14)]);
var state_26310__$1 = state_26310;
var statearr_26359_26505 = state_26310__$1;
(statearr_26359_26505[(2)] = inst_26196);

(statearr_26359_26505[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (33))){
var state_26310__$1 = state_26310;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26360_26506 = state_26310__$1;
(statearr_26360_26506[(1)] = (36));

} else {
var statearr_26361_26507 = state_26310__$1;
(statearr_26361_26507[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (13))){
var inst_26115 = (state_26310[(24)]);
var inst_26084 = (state_26310[(28)]);
var inst_26119 = (state_26310[(26)]);
var inst_26115__$1 = cljs.core.keys(inst_26084);
var inst_26116 = cljs.core.seq(inst_26115__$1);
var inst_26117 = cljs.core.first(inst_26116);
var inst_26118 = cljs.core.next(inst_26116);
var inst_26119__$1 = cljs.core.vals(inst_26084);
var inst_26120 = cljs.core.seq(inst_26119__$1);
var inst_26121 = cljs.core.first(inst_26120);
var inst_26122 = cljs.core.next(inst_26120);
var inst_26123 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_26310__$1 = (function (){var statearr_26362 = state_26310;
(statearr_26362[(24)] = inst_26115__$1);

(statearr_26362[(29)] = inst_26122);

(statearr_26362[(30)] = inst_26118);

(statearr_26362[(31)] = inst_26117);

(statearr_26362[(32)] = inst_26121);

(statearr_26362[(26)] = inst_26119__$1);

return statearr_26362;
})();
if(inst_26123){
var statearr_26363_26508 = state_26310__$1;
(statearr_26363_26508[(1)] = (16));

} else {
var statearr_26364_26509 = state_26310__$1;
(statearr_26364_26509[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (22))){
var inst_26135 = (state_26310[(22)]);
var inst_26134 = (state_26310[(23)]);
var inst_26146 = cljs.core.seq(inst_26134);
var inst_26147 = cljs.core.first(inst_26146);
var inst_26148 = cljs.core.next(inst_26146);
var inst_26149 = cljs.core.seq(inst_26135);
var inst_26150 = cljs.core.first(inst_26149);
var inst_26151 = cljs.core.next(inst_26149);
var inst_26152 = cljs.core.count(inst_26150);
var inst_26153 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_26154 = [headers,vars,inst_26150];
var inst_26155 = cljs.core.PersistentHashMap.fromArrays(inst_26153,inst_26154);
var inst_26156 = (inst_26150 == null);
var state_26310__$1 = (function (){var statearr_26365 = state_26310;
(statearr_26365[(8)] = inst_26147);

(statearr_26365[(27)] = inst_26152);

(statearr_26365[(19)] = inst_26151);

(statearr_26365[(16)] = inst_26155);

(statearr_26365[(21)] = inst_26148);

return statearr_26365;
})();
if(cljs.core.truth_(inst_26156)){
var statearr_26366_26510 = state_26310__$1;
(statearr_26366_26510[(1)] = (24));

} else {
var statearr_26367_26511 = state_26310__$1;
(statearr_26367_26511[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (90))){
var inst_26281 = (state_26310[(15)]);
var state_26310__$1 = state_26310;
var statearr_26368_26512 = state_26310__$1;
(statearr_26368_26512[(2)] = inst_26281);

(statearr_26368_26512[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (36))){
var inst_26137 = (state_26310[(12)]);
var inst_26169 = (inst_26137 - (1));
var state_26310__$1 = state_26310;
var statearr_26369_26513 = state_26310__$1;
(statearr_26369_26513[(2)] = inst_26169);

(statearr_26369_26513[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (41))){
var inst_26262 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26370_26514 = state_26310__$1;
(statearr_26370_26514[(2)] = inst_26262);

(statearr_26370_26514[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (89))){
var inst_26281 = (state_26310[(15)]);
var inst_26286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26287 = [inst_26281];
var inst_26288 = (new cljs.core.PersistentVector(null,1,(5),inst_26286,inst_26287,null));
var state_26310__$1 = state_26310;
var statearr_26371_26515 = state_26310__$1;
(statearr_26371_26515[(2)] = inst_26288);

(statearr_26371_26515[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (43))){
var inst_26182 = (state_26310[(18)]);
var inst_26185 = cljs.core.seq(inst_26182);
var state_26310__$1 = state_26310;
var statearr_26372_26516 = state_26310__$1;
(statearr_26372_26516[(2)] = inst_26185);

(statearr_26372_26516[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (61))){
var state_26310__$1 = state_26310;
var statearr_26373_26517 = state_26310__$1;
(statearr_26373_26517[(2)] = (0));

(statearr_26373_26517[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (29))){
var inst_26163 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26163)){
var statearr_26374_26518 = state_26310__$1;
(statearr_26374_26518[(1)] = (30));

} else {
var statearr_26375_26519 = state_26310__$1;
(statearr_26375_26519[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (44))){
var inst_26183 = (state_26310[(33)]);
var state_26310__$1 = state_26310;
var statearr_26376_26520 = state_26310__$1;
(statearr_26376_26520[(2)] = inst_26183);

(statearr_26376_26520[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (93))){
var state_26310__$1 = state_26310;
var statearr_26377_26521 = state_26310__$1;
(statearr_26377_26521[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (6))){
var inst_26076 = (state_26310[(34)]);
var inst_26076__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_26078 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_26310__$1 = (function (){var statearr_26379 = state_26310;
(statearr_26379[(34)] = inst_26076__$1);

(statearr_26379[(35)] = inst_26078);

return statearr_26379;
})();
if(cljs.core.truth_(inst_26076__$1)){
var statearr_26380_26522 = state_26310__$1;
(statearr_26380_26522[(1)] = (9));

} else {
var statearr_26381_26523 = state_26310__$1;
(statearr_26381_26523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (28))){
var inst_26136 = (state_26310[(11)]);
var state_26310__$1 = state_26310;
var statearr_26382_26524 = state_26310__$1;
(statearr_26382_26524[(2)] = inst_26136);

(statearr_26382_26524[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (64))){
var inst_26137 = (state_26310[(12)]);
var inst_26218 = (inst_26137 - (1));
var state_26310__$1 = state_26310;
var statearr_26383_26525 = state_26310__$1;
(statearr_26383_26525[(2)] = inst_26218);

(statearr_26383_26525[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (51))){
var inst_26136 = (state_26310[(11)]);
var inst_26196 = (state_26310[(2)]);
var state_26310__$1 = (function (){var statearr_26384 = state_26310;
(statearr_26384[(14)] = inst_26196);

return statearr_26384;
})();
if(cljs.core.truth_(inst_26136)){
var statearr_26385_26526 = state_26310__$1;
(statearr_26385_26526[(1)] = (52));

} else {
var statearr_26386_26527 = state_26310__$1;
(statearr_26386_26527[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (25))){
var inst_26136 = (state_26310[(11)]);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26136)){
var statearr_26387_26528 = state_26310__$1;
(statearr_26387_26528[(1)] = (27));

} else {
var statearr_26388_26529 = state_26310__$1;
(statearr_26388_26529[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (34))){
var state_26310__$1 = state_26310;
var statearr_26389_26530 = state_26310__$1;
(statearr_26389_26530[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (17))){
var state_26310__$1 = state_26310;
var statearr_26391_26531 = state_26310__$1;
(statearr_26391_26531[(2)] = limit);

(statearr_26391_26531[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (3))){
var inst_26308 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26310__$1,inst_26308);
} else {
if((state_val_26311 === (12))){
var inst_26084 = (state_26310[(28)]);
var inst_26086 = cljs.core.keys(inst_26084);
var inst_26087 = cljs.core.first(inst_26086);
var inst_26088 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_26089 = cljs.core.vals(inst_26084);
var inst_26090 = cljs.core.first(inst_26089);
var inst_26091 = [headers,vars,inst_26090];
var inst_26092 = cljs.core.PersistentHashMap.fromArrays(inst_26088,inst_26091);
var inst_26093 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_26092,select_spec,limit,opts);
var state_26310__$1 = (function (){var statearr_26392 = state_26310;
(statearr_26392[(17)] = inst_26087);

return statearr_26392;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26310__$1,(15),inst_26093);
} else {
if((state_val_26311 === (2))){
var _ = (function (){var statearr_26393 = state_26310;
(statearr_26393[(4)] = cljs.core.cons((5),(state_26310[(4)])));

return statearr_26393;
})();
var state_26310__$1 = state_26310;
if(cljs.core.truth_(groupBy)){
var statearr_26394_26532 = state_26310__$1;
(statearr_26394_26532[(1)] = (6));

} else {
var statearr_26395_26533 = state_26310__$1;
(statearr_26395_26533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (66))){
var inst_26228 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26396_26534 = state_26310__$1;
(statearr_26396_26534[(2)] = inst_26228);

(statearr_26396_26534[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (23))){
var inst_26270 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26397_26535 = state_26310__$1;
(statearr_26397_26535[(2)] = inst_26270);

(statearr_26397_26535[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (47))){
var inst_26136 = (state_26310[(11)]);
var inst_26244 = (inst_26136 == null);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26244)){
var statearr_26398_26536 = state_26310__$1;
(statearr_26398_26536[(1)] = (76));

} else {
var statearr_26399_26537 = state_26310__$1;
(statearr_26399_26537[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (35))){
var inst_26264 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26400_26538 = state_26310__$1;
(statearr_26400_26538[(2)] = inst_26264);

(statearr_26400_26538[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (82))){
var state_26310__$1 = state_26310;
var statearr_26401_26539 = state_26310__$1;
(statearr_26401_26539[(2)] = (1));

(statearr_26401_26539[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (76))){
var state_26310__$1 = state_26310;
var statearr_26402_26540 = state_26310__$1;
(statearr_26402_26540[(2)] = null);

(statearr_26402_26540[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (97))){
var inst_26299 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26403_26541 = state_26310__$1;
(statearr_26403_26541[(2)] = inst_26299);

(statearr_26403_26541[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (19))){
var inst_26128 = (state_26310[(36)]);
var state_26310__$1 = state_26310;
var statearr_26404_26542 = state_26310__$1;
(statearr_26404_26542[(2)] = inst_26128);

(statearr_26404_26542[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (57))){
var inst_26136 = (state_26310[(11)]);
var inst_26206 = (state_26310[(2)]);
var inst_26207 = (inst_26136 == null);
var state_26310__$1 = (function (){var statearr_26405 = state_26310;
(statearr_26405[(10)] = inst_26206);

return statearr_26405;
})();
if(cljs.core.truth_(inst_26207)){
var statearr_26406_26543 = state_26310__$1;
(statearr_26406_26543[(1)] = (58));

} else {
var statearr_26407_26544 = state_26310__$1;
(statearr_26407_26544[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (68))){
var state_26310__$1 = state_26310;
var statearr_26408_26545 = state_26310__$1;
(statearr_26408_26545[(2)] = null);

(statearr_26408_26545[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (11))){
var inst_26084 = (state_26310[(2)]);
var state_26310__$1 = (function (){var statearr_26410 = state_26310;
(statearr_26410[(28)] = inst_26084);

return statearr_26410;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26411_26546 = state_26310__$1;
(statearr_26411_26546[(1)] = (12));

} else {
var statearr_26412_26547 = state_26310__$1;
(statearr_26412_26547[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (9))){
var inst_26076 = (state_26310[(34)]);
var inst_26078 = (state_26310[(35)]);
var inst_26080 = cljs.core.sorted_map_by(inst_26076);
var inst_26081 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26080,inst_26078);
var state_26310__$1 = state_26310;
var statearr_26413_26548 = state_26310__$1;
(statearr_26413_26548[(2)] = inst_26081);

(statearr_26413_26548[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (5))){
var _ = (function (){var statearr_26414 = state_26310;
(statearr_26414[(4)] = cljs.core.rest((state_26310[(4)])));

return statearr_26414;
})();
var state_26310__$1 = state_26310;
var ex26409 = (state_26310__$1[(2)]);
var statearr_26415_26549 = state_26310__$1;
(statearr_26415_26549[(5)] = ex26409);


if((ex26409 instanceof Error)){
var statearr_26416_26550 = state_26310__$1;
(statearr_26416_26550[(1)] = (4));

(statearr_26416_26550[(5)] = null);

} else {
throw ex26409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (83))){
var state_26310__$1 = state_26310;
var statearr_26417_26551 = state_26310__$1;
(statearr_26417_26551[(2)] = limit);

(statearr_26417_26551[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (14))){
var inst_26272 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26418_26552 = state_26310__$1;
(statearr_26418_26552[(2)] = inst_26272);

(statearr_26418_26552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (45))){
var inst_26188 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
if(cljs.core.truth_(inst_26188)){
var statearr_26419_26553 = state_26310__$1;
(statearr_26419_26553[(1)] = (46));

} else {
var statearr_26420_26554 = state_26310__$1;
(statearr_26420_26554[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (53))){
var inst_26136 = (state_26310[(11)]);
var state_26310__$1 = state_26310;
var statearr_26421_26555 = state_26310__$1;
(statearr_26421_26555[(2)] = inst_26136);

(statearr_26421_26555[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (78))){
var inst_26137 = (state_26310[(12)]);
var inst_26249 = (state_26310[(2)]);
var inst_26250 = (inst_26137 <= (0));
var state_26310__$1 = (function (){var statearr_26422 = state_26310;
(statearr_26422[(37)] = inst_26249);

return statearr_26422;
})();
if(cljs.core.truth_(inst_26250)){
var statearr_26423_26556 = state_26310__$1;
(statearr_26423_26556[(1)] = (79));

} else {
var statearr_26424_26557 = state_26310__$1;
(statearr_26424_26557[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (26))){
var inst_26268 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26425_26558 = state_26310__$1;
(statearr_26425_26558[(2)] = inst_26268);

(statearr_26425_26558[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (16))){
var state_26310__$1 = state_26310;
var statearr_26426_26559 = state_26310__$1;
(statearr_26426_26559[(2)] = null);

(statearr_26426_26559[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (81))){
var inst_26147 = (state_26310[(8)]);
var inst_26249 = (state_26310[(37)]);
var inst_26138 = (state_26310[(9)]);
var inst_26151 = (state_26310[(19)]);
var inst_26148 = (state_26310[(21)]);
var inst_26182 = (state_26310[(18)]);
var inst_26255 = (state_26310[(2)]);
var inst_26256 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26138,inst_26147,inst_26182);
var inst_26134 = inst_26148;
var inst_26135 = inst_26151;
var inst_26136 = inst_26249;
var inst_26137 = inst_26255;
var inst_26138__$1 = inst_26256;
var state_26310__$1 = (function (){var statearr_26429 = state_26310;
(statearr_26429[(9)] = inst_26138__$1);

(statearr_26429[(22)] = inst_26135);

(statearr_26429[(12)] = inst_26137);

(statearr_26429[(23)] = inst_26134);

(statearr_26429[(11)] = inst_26136);

return statearr_26429;
})();
var statearr_26430_26560 = state_26310__$1;
(statearr_26430_26560[(2)] = null);

(statearr_26430_26560[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (79))){
var state_26310__$1 = state_26310;
var statearr_26431_26561 = state_26310__$1;
(statearr_26431_26561[(2)] = (0));

(statearr_26431_26561[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (38))){
var inst_26138 = (state_26310[(9)]);
var inst_26151 = (state_26310[(19)]);
var inst_26148 = (state_26310[(21)]);
var inst_26136 = (state_26310[(11)]);
var inst_26173 = (state_26310[(2)]);
var tmp26427 = inst_26138;
var tmp26428 = inst_26136;
var inst_26134 = inst_26148;
var inst_26135 = inst_26151;
var inst_26136__$1 = tmp26428;
var inst_26137 = inst_26173;
var inst_26138__$1 = tmp26427;
var state_26310__$1 = (function (){var statearr_26432 = state_26310;
(statearr_26432[(9)] = inst_26138__$1);

(statearr_26432[(22)] = inst_26135);

(statearr_26432[(12)] = inst_26137);

(statearr_26432[(23)] = inst_26134);

(statearr_26432[(11)] = inst_26136__$1);

return statearr_26432;
})();
var statearr_26433_26562 = state_26310__$1;
(statearr_26433_26562[(2)] = null);

(statearr_26433_26562[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (87))){
var state_26310__$1 = state_26310;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26434_26563 = state_26310__$1;
(statearr_26434_26563[(1)] = (92));

} else {
var statearr_26435_26564 = state_26310__$1;
(statearr_26435_26564[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (30))){
var inst_26138 = (state_26310[(9)]);
var state_26310__$1 = state_26310;
var statearr_26436_26565 = state_26310__$1;
(statearr_26436_26565[(2)] = inst_26138);

(statearr_26436_26565[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (73))){
var inst_26138 = (state_26310[(9)]);
var state_26310__$1 = state_26310;
var statearr_26437_26566 = state_26310__$1;
(statearr_26437_26566[(2)] = inst_26138);

(statearr_26437_26566[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (96))){
var state_26310__$1 = state_26310;
var statearr_26438_26567 = state_26310__$1;
(statearr_26438_26567[(2)] = null);

(statearr_26438_26567[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (10))){
var inst_26078 = (state_26310[(35)]);
var state_26310__$1 = state_26310;
var statearr_26439_26568 = state_26310__$1;
(statearr_26439_26568[(2)] = inst_26078);

(statearr_26439_26568[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (18))){
var inst_26128 = (state_26310[(36)]);
var inst_26127 = (state_26310[(2)]);
var inst_26128__$1 = offset;
var state_26310__$1 = (function (){var statearr_26440 = state_26310;
(statearr_26440[(25)] = inst_26127);

(statearr_26440[(36)] = inst_26128__$1);

return statearr_26440;
})();
if(cljs.core.truth_(inst_26128__$1)){
var statearr_26441_26569 = state_26310__$1;
(statearr_26441_26569[(1)] = (19));

} else {
var statearr_26442_26570 = state_26310__$1;
(statearr_26442_26570[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (52))){
var inst_26136 = (state_26310[(11)]);
var inst_26198 = ((0) < inst_26136);
var state_26310__$1 = state_26310;
var statearr_26443_26571 = state_26310__$1;
(statearr_26443_26571[(2)] = inst_26198);

(statearr_26443_26571[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (67))){
var inst_26152 = (state_26310[(27)]);
var inst_26137 = (state_26310[(12)]);
var inst_26206 = (state_26310[(10)]);
var inst_26221 = cljs.core.count(inst_26206);
var inst_26222 = (inst_26152 - inst_26221);
var inst_26223 = (inst_26137 - inst_26222);
var state_26310__$1 = state_26310;
var statearr_26444_26572 = state_26310__$1;
(statearr_26444_26572[(2)] = inst_26223);

(statearr_26444_26572[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (71))){
var inst_26206 = (state_26310[(10)]);
var inst_26234 = cljs.core.empty_QMARK_(inst_26206);
var state_26310__$1 = state_26310;
var statearr_26445_26573 = state_26310__$1;
(statearr_26445_26573[(2)] = inst_26234);

(statearr_26445_26573[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (42))){
var inst_26183 = (state_26310[(33)]);
var inst_26182 = (state_26310[(18)]);
var inst_26181 = (state_26310[(2)]);
var inst_26182__$1 = fluree.db.util.async.throw_err(inst_26181);
var inst_26183__$1 = cljs.core.coll_QMARK_(inst_26182__$1);
var state_26310__$1 = (function (){var statearr_26446 = state_26310;
(statearr_26446[(33)] = inst_26183__$1);

(statearr_26446[(18)] = inst_26182__$1);

return statearr_26446;
})();
if(inst_26183__$1){
var statearr_26447_26574 = state_26310__$1;
(statearr_26447_26574[(1)] = (43));

} else {
var statearr_26448_26575 = state_26310__$1;
(statearr_26448_26575[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (80))){
var inst_26137 = (state_26310[(12)]);
var inst_26253 = (inst_26137 - (1));
var state_26310__$1 = state_26310;
var statearr_26449_26576 = state_26310__$1;
(statearr_26449_26576[(2)] = inst_26253);

(statearr_26449_26576[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (37))){
var inst_26152 = (state_26310[(27)]);
var inst_26137 = (state_26310[(12)]);
var inst_26171 = (inst_26137 - inst_26152);
var state_26310__$1 = state_26310;
var statearr_26450_26577 = state_26310__$1;
(statearr_26450_26577[(2)] = inst_26171);

(statearr_26450_26577[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (63))){
var inst_26231 = (state_26310[(7)]);
var inst_26206 = (state_26310[(10)]);
var inst_26230 = (state_26310[(2)]);
var inst_26231__$1 = (inst_26206 == null);
var state_26310__$1 = (function (){var statearr_26451 = state_26310;
(statearr_26451[(7)] = inst_26231__$1);

(statearr_26451[(20)] = inst_26230);

return statearr_26451;
})();
if(cljs.core.truth_(inst_26231__$1)){
var statearr_26452_26578 = state_26310__$1;
(statearr_26452_26578[(1)] = (70));

} else {
var statearr_26453_26579 = state_26310__$1;
(statearr_26453_26579[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (94))){
var inst_26301 = (state_26310[(2)]);
var state_26310__$1 = state_26310;
var statearr_26454_26580 = state_26310__$1;
(statearr_26454_26580[(2)] = inst_26301);

(statearr_26454_26580[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (8))){
var inst_26305 = (state_26310[(2)]);
var _ = (function (){var statearr_26455 = state_26310;
(statearr_26455[(4)] = cljs.core.rest((state_26310[(4)])));

return statearr_26455;
})();
var state_26310__$1 = state_26310;
var statearr_26456_26581 = state_26310__$1;
(statearr_26456_26581[(2)] = inst_26305);

(statearr_26456_26581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (49))){
var inst_26137 = (state_26310[(12)]);
var inst_26182 = (state_26310[(18)]);
var inst_26193 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_26137,inst_26182);
var state_26310__$1 = state_26310;
var statearr_26457_26582 = state_26310__$1;
(statearr_26457_26582[(2)] = inst_26193);

(statearr_26457_26582[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26311 === (84))){
var inst_26277 = (state_26310[(2)]);
var inst_26278 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_26277,opts);
var state_26310__$1 = state_26310;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26310__$1,(85),inst_26278);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0 = (function (){
var statearr_26458 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26458[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__);

(statearr_26458[(1)] = (1));

return statearr_26458;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1 = (function (state_26310){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26310);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26459){var ex__2730__auto__ = e26459;
var statearr_26460_26583 = state_26310;
(statearr_26460_26583[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26310[(4)]))){
var statearr_26461_26584 = state_26310;
(statearr_26461_26584[(1)] = cljs.core.first((state_26310[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26585 = state_26310;
state_26310 = G__26585;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = function(state_26310){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1.call(this,state_26310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26462 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26462[(6)] = c__2749__auto__);

return statearr_26462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__26588,opts){
var map__26589 = p__26588;
var map__26589__$1 = cljs.core.__destructure_map(map__26589);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26589__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26589__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26589__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26589__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__26586_SHARP_){
return cljs.core.contains_QMARK_(p1__26586_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__26587_SHARP_){
return cljs.core.contains_QMARK_(p1__26587_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__5043__auto__){
var G__26591 = cljs.core.first(orderBy);
var fexpr__26590 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__26590.cljs$core$IFn$_invoke$arity$1 ? fexpr__26590.cljs$core$IFn$_invoke$arity$1(G__26591) : fexpr__26590.call(null,G__26591));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})(),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__26592,p__26593){
var map__26594 = p__26592;
var map__26594__$1 = cljs.core.__destructure_map(map__26594);
var query_map = map__26594__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26594__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__26595 = p__26593;
var map__26595__$1 = cljs.core.__destructure_map(map__26595);
var where_result = map__26595__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26595__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26595__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__26596 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5802__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5802__auto__)){
var index_of = temp__5802__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26596,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26596,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26596,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26629){
var state_val_26630 = (state_26629[(1)]);
if((state_val_26630 === (7))){
var inst_26608 = (state_26629[(7)]);
var state_26629__$1 = state_26629;
var statearr_26631_26654 = state_26629__$1;
(statearr_26631_26654[(2)] = inst_26608);

(statearr_26631_26654[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (1))){
var state_26629__$1 = state_26629;
var statearr_26632_26655 = state_26629__$1;
(statearr_26632_26655[(2)] = null);

(statearr_26632_26655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (4))){
var inst_26599 = (state_26629[(2)]);
var state_26629__$1 = state_26629;
var statearr_26633_26656 = state_26629__$1;
(statearr_26633_26656[(2)] = inst_26599);

(statearr_26633_26656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (13))){
var inst_26618 = (state_26629[(2)]);
var inst_26619 = fluree.db.util.async.throw_err(inst_26618);
var state_26629__$1 = state_26629;
var statearr_26634_26657 = state_26629__$1;
(statearr_26634_26657[(2)] = inst_26619);

(statearr_26634_26657[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (6))){
var inst_26608 = (state_26629[(7)]);
var inst_26607 = (state_26629[(2)]);
var inst_26608__$1 = fluree.db.util.async.throw_err(inst_26607);
var inst_26609 = fluree.db.util.core.exception_QMARK_(inst_26608__$1);
var state_26629__$1 = (function (){var statearr_26635 = state_26629;
(statearr_26635[(7)] = inst_26608__$1);

return statearr_26635;
})();
if(inst_26609){
var statearr_26636_26658 = state_26629__$1;
(statearr_26636_26658[(1)] = (7));

} else {
var statearr_26637_26659 = state_26629__$1;
(statearr_26637_26659[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (3))){
var inst_26627 = (state_26629[(2)]);
var state_26629__$1 = state_26629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26629__$1,inst_26627);
} else {
if((state_val_26630 === (12))){
var inst_26622 = (state_26629[(2)]);
var state_26629__$1 = state_26629;
var statearr_26638_26660 = state_26629__$1;
(statearr_26638_26660[(2)] = inst_26622);

(statearr_26638_26660[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (2))){
var _ = (function (){var statearr_26639 = state_26629;
(statearr_26639[(4)] = cljs.core.cons((5),(state_26629[(4)])));

return statearr_26639;
})();
var inst_26605 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_26629__$1 = state_26629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26629__$1,(6),inst_26605);
} else {
if((state_val_26630 === (11))){
var state_26629__$1 = state_26629;
var statearr_26641_26661 = state_26629__$1;
(statearr_26641_26661[(2)] = null);

(statearr_26641_26661[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (9))){
var inst_26624 = (state_26629[(2)]);
var _ = (function (){var statearr_26642 = state_26629;
(statearr_26642[(4)] = cljs.core.rest((state_26629[(4)])));

return statearr_26642;
})();
var state_26629__$1 = state_26629;
var statearr_26643_26662 = state_26629__$1;
(statearr_26643_26662[(2)] = inst_26624);

(statearr_26643_26662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (5))){
var _ = (function (){var statearr_26644 = state_26629;
(statearr_26644[(4)] = cljs.core.rest((state_26629[(4)])));

return statearr_26644;
})();
var state_26629__$1 = state_26629;
var ex26640 = (state_26629__$1[(2)]);
var statearr_26645_26663 = state_26629__$1;
(statearr_26645_26663[(5)] = ex26640);


if((ex26640 instanceof Error)){
var statearr_26646_26664 = state_26629__$1;
(statearr_26646_26664[(1)] = (4));

(statearr_26646_26664[(5)] = null);

} else {
throw ex26640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26630 === (10))){
var inst_26608 = (state_26629[(7)]);
var inst_26613 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_26608);
var inst_26614 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_26608);
var inst_26615 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_26613,inst_26614,query_map,opts);
var inst_26616 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_26608,inst_26615,opts);
var state_26629__$1 = state_26629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26629__$1,(13),inst_26616);
} else {
if((state_val_26630 === (8))){
var state_26629__$1 = state_26629;
var statearr_26647_26665 = state_26629__$1;
(statearr_26647_26665[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0 = (function (){
var statearr_26649 = [null,null,null,null,null,null,null,null];
(statearr_26649[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__);

(statearr_26649[(1)] = (1));

return statearr_26649;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1 = (function (state_26629){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26629);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26650){var ex__2730__auto__ = e26650;
var statearr_26651_26666 = state_26629;
(statearr_26651_26666[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26629[(4)]))){
var statearr_26652_26667 = state_26629;
(statearr_26652_26667[(1)] = cljs.core.first((state_26629[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26668 = state_26629;
state_26629 = G__26668;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = function(state_26629){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1.call(this,state_26629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26653 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26653[(6)] = c__2749__auto__);

return statearr_26653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__26669 = query_map;
var map__26669__$1 = cljs.core.__destructure_map(map__26669);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26669__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__26670 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__26670,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__26670;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = max_fuel;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27028){
var state_val_27029 = (state_27028[(1)]);
if((state_val_27029 === (121))){
var inst_26989 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27030_27225 = state_27028__$1;
(statearr_27030_27225[(2)] = inst_26989);

(statearr_27030_27225[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (65))){
var inst_26866 = typeof from === 'string';
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26866)){
var statearr_27031_27226 = state_27028__$1;
(statearr_27031_27226[(1)] = (72));

} else {
var statearr_27032_27227 = state_27028__$1;
(statearr_27032_27227[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (70))){
var inst_26734 = (state_27028[(7)]);
var inst_26732 = (state_27028[(8)]);
var inst_26859 = (state_27028[(2)]);
var inst_26860 = fluree.db.util.async.throw_err(inst_26859);
var inst_26861 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_26734,fuel,max_fuel,inst_26732,inst_26860);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(71),inst_26861);
} else {
if((state_val_27029 === (62))){
var inst_26839 = (state_27028[(9)]);
var state_27028__$1 = state_27028;
var statearr_27033_27228 = state_27028__$1;
(statearr_27033_27228[(2)] = inst_26839);

(statearr_27033_27228[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (74))){
var inst_26995 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27034_27229 = state_27028__$1;
(statearr_27034_27229[(2)] = inst_26995);

(statearr_27034_27229[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (110))){
var inst_26930 = (state_27028[(10)]);
var state_27028__$1 = state_27028;
var statearr_27035_27230 = state_27028__$1;
(statearr_27035_27230[(2)] = inst_26930);

(statearr_27035_27230[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (130))){
var inst_27015 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27036_27231 = state_27028__$1;
(statearr_27036_27231[(2)] = inst_27015);

(statearr_27036_27231[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (128))){
var inst_27006 = (state_27028[(11)]);
var inst_27011 = fluree.db.util.core.exception_QMARK_(inst_27006);
var inst_27012 = (!(inst_27011));
var state_27028__$1 = state_27028;
var statearr_27037_27232 = state_27028__$1;
(statearr_27037_27232[(2)] = inst_27012);

(statearr_27037_27232[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (7))){
var inst_26702 = (state_27028[(12)]);
var inst_26702__$1 = selectOne;
var state_27028__$1 = (function (){var statearr_27038 = state_27028;
(statearr_27038[(12)] = inst_26702__$1);

return statearr_27038;
})();
if(cljs.core.truth_(inst_26702__$1)){
var statearr_27039_27233 = state_27028__$1;
(statearr_27039_27233[(1)] = (9));

} else {
var statearr_27040_27234 = state_27028__$1;
(statearr_27040_27234[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (59))){
var inst_26722 = (state_27028[(13)]);
var inst_26734 = (state_27028[(7)]);
var inst_26732 = (state_27028[(8)]);
var inst_26817 = (state_27028[(14)]);
var inst_26831 = (state_27028[(2)]);
var inst_26832 = fluree.db.util.async.throw_err(inst_26831);
var inst_26833 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_26817,inst_26832);
var inst_26834 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_26734,fuel,max_fuel,inst_26732,inst_26833,inst_26722);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(60),inst_26834);
} else {
if((state_val_27029 === (86))){
var inst_26722 = (state_27028[(13)]);
var inst_26724 = (state_27028[(15)]);
var inst_26734 = (state_27028[(7)]);
var inst_26732 = (state_27028[(8)]);
var inst_26899 = (state_27028[(2)]);
var inst_26900 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_26734,fuel,max_fuel,inst_26732,inst_26899,inst_26722,inst_26724);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(87),inst_26900);
} else {
if((state_val_27029 === (20))){
var inst_26766 = (state_27028[(2)]);
var inst_26767 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26766,(0),null);
var inst_26768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26766,(1),null);
var inst_26769 = typeof where === 'string';
var state_27028__$1 = (function (){var statearr_27041 = state_27028;
(statearr_27041[(16)] = inst_26768);

(statearr_27041[(17)] = inst_26767);

return statearr_27041;
})();
if(cljs.core.truth_(inst_26769)){
var statearr_27042_27235 = state_27028__$1;
(statearr_27042_27235[(1)] = (30));

} else {
var statearr_27043_27236 = state_27028__$1;
(statearr_27043_27236[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (72))){
var inst_26721 = (state_27028[(18)]);
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26721)){
var statearr_27044_27237 = state_27028__$1;
(statearr_27044_27237[(1)] = (75));

} else {
var statearr_27045_27238 = state_27028__$1;
(statearr_27045_27238[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (58))){
var inst_26825 = (state_27028[(2)]);
var inst_26826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26827 = [from];
var inst_26828 = (new cljs.core.PersistentVector(null,1,(5),inst_26826,inst_26827,null));
var inst_26829 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26828,inst_26825);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(59),inst_26829);
} else {
if((state_val_27029 === (60))){
var inst_26836 = (state_27028[(2)]);
var inst_26837 = fluree.db.util.async.throw_err(inst_26836);
var state_27028__$1 = state_27028;
var statearr_27046_27239 = state_27028__$1;
(statearr_27046_27239[(2)] = inst_26837);

(statearr_27046_27239[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (27))){
var inst_26751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26752 = [null,null];
var inst_26753 = (new cljs.core.PersistentVector(null,2,(5),inst_26751,inst_26752,null));
var state_27028__$1 = state_27028;
var statearr_27047_27240 = state_27028__$1;
(statearr_27047_27240[(2)] = inst_26753);

(statearr_27047_27240[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (1))){
var state_27028__$1 = state_27028;
var statearr_27048_27241 = state_27028__$1;
(statearr_27048_27241[(2)] = null);

(statearr_27048_27241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (69))){
var inst_26856 = (state_27028[(2)]);
var inst_26857 = fluree.db.query.range._block_or_tx_collection(db,inst_26856);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(70),inst_26857);
} else {
if((state_val_27029 === (101))){
var inst_26962 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27049_27242 = state_27028__$1;
(statearr_27049_27242[(2)] = inst_26962);

(statearr_27049_27242[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (24))){
var inst_26721 = (state_27028[(18)]);
var inst_26746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26747 = [inst_26721,"ASC"];
var inst_26748 = (new cljs.core.PersistentVector(null,2,(5),inst_26746,inst_26747,null));
var state_27028__$1 = state_27028;
var statearr_27050_27243 = state_27028__$1;
(statearr_27050_27243[(2)] = inst_26748);

(statearr_27050_27243[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (102))){
var inst_26936 = (state_27028[(19)]);
var state_27028__$1 = state_27028;
var statearr_27051_27244 = state_27028__$1;
(statearr_27051_27244[(2)] = inst_26936);

(statearr_27051_27244[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (55))){
var inst_26721 = (state_27028[(18)]);
var inst_26817 = (state_27028[(2)]);
var state_27028__$1 = (function (){var statearr_27052 = state_27028;
(statearr_27052[(14)] = inst_26817);

return statearr_27052;
})();
if(cljs.core.truth_(inst_26721)){
var statearr_27053_27245 = state_27028__$1;
(statearr_27053_27245[(1)] = (56));

} else {
var statearr_27054_27246 = state_27028__$1;
(statearr_27054_27246[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (85))){
var inst_26891 = (state_27028[(20)]);
var inst_26895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26896 = [inst_26891];
var inst_26897 = (new cljs.core.PersistentVector(null,1,(5),inst_26895,inst_26896,null));
var state_27028__$1 = state_27028;
var statearr_27055_27247 = state_27028__$1;
(statearr_27055_27247[(2)] = inst_26897);

(statearr_27055_27247[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (39))){
var inst_26722 = (state_27028[(13)]);
var state_27028__$1 = state_27028;
var statearr_27056_27248 = state_27028__$1;
(statearr_27056_27248[(2)] = inst_26722);

(statearr_27056_27248[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (88))){
var inst_26905 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_27028__$1 = state_27028;
var statearr_27057_27249 = state_27028__$1;
(statearr_27057_27249[(2)] = inst_26905);

(statearr_27057_27249[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (46))){
var inst_26802 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26802)){
var statearr_27058_27250 = state_27028__$1;
(statearr_27058_27250[(1)] = (47));

} else {
var statearr_27059_27251 = state_27028__$1;
(statearr_27059_27251[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (4))){
var inst_26689 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27060_27252 = state_27028__$1;
(statearr_27060_27252[(2)] = inst_26689);

(statearr_27060_27252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (77))){
var inst_26875 = (state_27028[(2)]);
var inst_26876 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_26875);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(78),inst_26876);
} else {
if((state_val_27029 === (106))){
var state_27028__$1 = state_27028;
var statearr_27061_27253 = state_27028__$1;
(statearr_27061_27253[(2)] = null);

(statearr_27061_27253[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (119))){
var inst_26981 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_26982 = ["Invalid 'from' in query:",inst_26981].join('');
var inst_26983 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26984 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26985 = cljs.core.PersistentHashMap.fromArrays(inst_26983,inst_26984);
var inst_26986 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26982,inst_26985);
var state_27028__$1 = state_27028;
var statearr_27062_27254 = state_27028__$1;
(statearr_27062_27254[(2)] = inst_26986);

(statearr_27062_27254[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (95))){
var state_27028__$1 = state_27028;
var statearr_27063_27255 = state_27028__$1;
(statearr_27063_27255[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (54))){
var inst_26811 = (state_27028[(21)]);
var state_27028__$1 = state_27028;
var statearr_27065_27256 = state_27028__$1;
(statearr_27065_27256[(2)] = inst_26811);

(statearr_27065_27256[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (92))){
var inst_26910 = (state_27028[(22)]);
var state_27028__$1 = state_27028;
var statearr_27066_27257 = state_27028__$1;
(statearr_27066_27257[(2)] = inst_26910);

(statearr_27066_27257[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (104))){
var inst_26954 = (state_27028[(23)]);
var inst_26954__$1 = (state_27028[(2)]);
var state_27028__$1 = (function (){var statearr_27067 = state_27028;
(statearr_27067[(23)] = inst_26954__$1);

return statearr_27067;
})();
if(cljs.core.truth_(inst_26954__$1)){
var statearr_27068_27258 = state_27028__$1;
(statearr_27068_27258[(1)] = (109));

} else {
var statearr_27069_27259 = state_27028__$1;
(statearr_27069_27259[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (15))){
var inst_26725 = (state_27028[(24)]);
var inst_26723 = (state_27028[(25)]);
var inst_26729 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26725,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_26723);
var state_27028__$1 = state_27028;
var statearr_27070_27260 = state_27028__$1;
(statearr_27070_27260[(2)] = inst_26729);

(statearr_27070_27260[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (48))){
var inst_26839 = (state_27028[(9)]);
var inst_26839__$1 = typeof from === 'string';
var state_27028__$1 = (function (){var statearr_27071 = state_27028;
(statearr_27071[(9)] = inst_26839__$1);

return statearr_27071;
})();
if(cljs.core.truth_(inst_26839__$1)){
var statearr_27072_27261 = state_27028__$1;
(statearr_27072_27261[(1)] = (61));

} else {
var statearr_27073_27262 = state_27028__$1;
(statearr_27073_27262[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (50))){
var inst_26805 = (state_27028[(26)]);
var inst_26807 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_26808 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26805,inst_26807);
var state_27028__$1 = state_27028;
var statearr_27074_27263 = state_27028__$1;
(statearr_27074_27263[(2)] = inst_26808);

(statearr_27074_27263[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (116))){
var state_27028__$1 = state_27028;
var statearr_27075_27264 = state_27028__$1;
(statearr_27075_27264[(2)] = null);

(statearr_27075_27264[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (75))){
var inst_26869 = cljs.core.PersistentHashMap.EMPTY;
var state_27028__$1 = state_27028;
var statearr_27076_27265 = state_27028__$1;
(statearr_27076_27265[(2)] = inst_26869);

(statearr_27076_27265[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (99))){
var inst_26930 = (state_27028[(10)]);
var state_27028__$1 = state_27028;
var statearr_27077_27266 = state_27028__$1;
(statearr_27077_27266[(2)] = inst_26930);

(statearr_27077_27266[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (21))){
var inst_26721 = (state_27028[(18)]);
var inst_26738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26739 = cljs.core.second(inst_26721);
var inst_26740 = cljs.core.first(inst_26721);
var inst_26741 = [inst_26739,inst_26740];
var inst_26742 = (new cljs.core.PersistentVector(null,2,(5),inst_26738,inst_26741,null));
var state_27028__$1 = state_27028;
var statearr_27078_27267 = state_27028__$1;
(statearr_27078_27267[(2)] = inst_26742);

(statearr_27078_27267[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (31))){
var inst_26796 = (state_27028[(27)]);
var inst_26796__$1 = typeof from === 'string';
var state_27028__$1 = (function (){var statearr_27079 = state_27028;
(statearr_27079[(27)] = inst_26796__$1);

return statearr_27079;
})();
if(cljs.core.truth_(inst_26796__$1)){
var statearr_27080_27268 = state_27028__$1;
(statearr_27080_27268[(1)] = (44));

} else {
var statearr_27081_27269 = state_27028__$1;
(statearr_27081_27269[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (113))){
var state_27028__$1 = state_27028;
var statearr_27082_27270 = state_27028__$1;
(statearr_27082_27270[(2)] = null);

(statearr_27082_27270[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (32))){
var inst_26767 = (state_27028[(17)]);
var inst_27001 = (state_27028[(2)]);
var state_27028__$1 = (function (){var statearr_27083 = state_27028;
(statearr_27083[(28)] = inst_27001);

return statearr_27083;
})();
if(cljs.core.truth_(inst_26767)){
var statearr_27084_27271 = state_27028__$1;
(statearr_27084_27271[(1)] = (122));

} else {
var statearr_27085_27272 = state_27028__$1;
(statearr_27085_27272[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (40))){
var inst_26721 = (state_27028[(18)]);
var inst_26786 = (state_27028[(2)]);
var state_27028__$1 = (function (){var statearr_27086 = state_27028;
(statearr_27086[(29)] = inst_26786);

return statearr_27086;
})();
if(cljs.core.truth_(inst_26721)){
var statearr_27087_27273 = state_27028__$1;
(statearr_27087_27273[(1)] = (41));

} else {
var statearr_27088_27274 = state_27028__$1;
(statearr_27088_27274[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (129))){
var inst_27009 = (state_27028[(30)]);
var state_27028__$1 = state_27028;
var statearr_27089_27275 = state_27028__$1;
(statearr_27089_27275[(2)] = inst_27009);

(statearr_27089_27275[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (91))){
var inst_26912 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_27028__$1 = state_27028;
var statearr_27090_27276 = state_27028__$1;
(statearr_27090_27276[(2)] = inst_26912);

(statearr_27090_27276[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (117))){
var inst_26724 = (state_27028[(15)]);
var state_27028__$1 = state_27028;
var statearr_27091_27277 = state_27028__$1;
(statearr_27091_27277[(2)] = inst_26724);

(statearr_27091_27277[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (108))){
var inst_26951 = (state_27028[(2)]);
var inst_26952 = fluree.db.util.async.throw_err(inst_26951);
var state_27028__$1 = state_27028;
var statearr_27092_27278 = state_27028__$1;
(statearr_27092_27278[(2)] = inst_26952);

(statearr_27092_27278[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (56))){
var inst_26819 = cljs.core.PersistentHashMap.EMPTY;
var state_27028__$1 = state_27028;
var statearr_27093_27279 = state_27028__$1;
(statearr_27093_27279[(2)] = inst_26819);

(statearr_27093_27279[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (33))){
var state_27028__$1 = state_27028;
var statearr_27094_27280 = state_27028__$1;
(statearr_27094_27280[(2)] = from);

(statearr_27094_27280[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (13))){
var inst_26708 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26709 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26710 = cljs.core.PersistentHashMap.fromArrays(inst_26708,inst_26709);
var inst_26711 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_26710);
var inst_26712 = (function(){throw inst_26711})();
var state_27028__$1 = state_27028;
var statearr_27095_27281 = state_27028__$1;
(statearr_27095_27281[(2)] = inst_26712);

(statearr_27095_27281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (22))){
var inst_26721 = (state_27028[(18)]);
var inst_26744 = typeof inst_26721 === 'string';
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26744)){
var statearr_27096_27282 = state_27028__$1;
(statearr_27096_27282[(1)] = (24));

} else {
var statearr_27097_27283 = state_27028__$1;
(statearr_27097_27283[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (90))){
var inst_26903 = (state_27028[(31)]);
var inst_26908 = (state_27028[(2)]);
var state_27028__$1 = (function (){var statearr_27098 = state_27028;
(statearr_27098[(32)] = inst_26908);

return statearr_27098;
})();
var statearr_27099_27284 = state_27028__$1;
(statearr_27099_27284[(2)] = inst_26903);

(statearr_27099_27284[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (109))){
var inst_26954 = (state_27028[(23)]);
var inst_26930 = (state_27028[(10)]);
var inst_26956 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26930,inst_26954);
var state_27028__$1 = state_27028;
var statearr_27100_27285 = state_27028__$1;
(statearr_27100_27285[(2)] = inst_26956);

(statearr_27100_27285[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (36))){
var inst_26721 = (state_27028[(18)]);
var inst_26781 = (state_27028[(2)]);
var inst_26782 = fluree.db.util.async.throw_err(inst_26781);
var state_27028__$1 = (function (){var statearr_27101 = state_27028;
(statearr_27101[(33)] = inst_26782);

return statearr_27101;
})();
if(cljs.core.truth_(inst_26721)){
var statearr_27102_27286 = state_27028__$1;
(statearr_27102_27286[(1)] = (38));

} else {
var statearr_27103_27287 = state_27028__$1;
(statearr_27103_27287[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (41))){
var state_27028__$1 = state_27028;
var statearr_27104_27288 = state_27028__$1;
(statearr_27104_27288[(2)] = null);

(statearr_27104_27288[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (118))){
var inst_26970 = (state_27028[(34)]);
var inst_26734 = (state_27028[(7)]);
var inst_26966 = (state_27028[(35)]);
var inst_26732 = (state_27028[(8)]);
var inst_26974 = (state_27028[(2)]);
var inst_26975 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_26734,fuel,max_fuel,inst_26732,inst_26966,inst_26970,inst_26974);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(112),inst_26975);
} else {
if((state_val_27029 === (89))){
var state_27028__$1 = state_27028;
var statearr_27105_27289 = state_27028__$1;
(statearr_27105_27289[(2)] = null);

(statearr_27105_27289[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (100))){
var inst_26936 = (state_27028[(19)]);
var inst_26941 = cljs.core.int_QMARK_(inst_26936);
var state_27028__$1 = state_27028;
if(inst_26941){
var statearr_27106_27290 = state_27028__$1;
(statearr_27106_27290[(1)] = (102));

} else {
var statearr_27107_27291 = state_27028__$1;
(statearr_27107_27291[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (131))){
var inst_27006 = (state_27028[(11)]);
var inst_27020 = cljs.core.first(inst_27006);
var state_27028__$1 = state_27028;
var statearr_27108_27292 = state_27028__$1;
(statearr_27108_27292[(2)] = inst_27020);

(statearr_27108_27292[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (122))){
var inst_26768 = (state_27028[(16)]);
var inst_26767 = (state_27028[(17)]);
var inst_26722 = (state_27028[(13)]);
var inst_26724 = (state_27028[(15)]);
var inst_27001 = (state_27028[(28)]);
var inst_27003 = fluree.db.query.fql.sort_offset_and_limit_res(inst_26767,inst_26768,inst_26724,inst_26722,inst_27001);
var state_27028__$1 = state_27028;
var statearr_27109_27293 = state_27028__$1;
(statearr_27109_27293[(2)] = inst_27003);

(statearr_27109_27293[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (43))){
var inst_26782 = (state_27028[(33)]);
var inst_26786 = (state_27028[(29)]);
var inst_26734 = (state_27028[(7)]);
var inst_26732 = (state_27028[(8)]);
var inst_26790 = (state_27028[(2)]);
var inst_26791 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_26734,fuel,max_fuel,inst_26732,inst_26782,inst_26786,inst_26790);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(37),inst_26791);
} else {
if((state_val_27029 === (61))){
var inst_26841 = ["_tx",null,"_block",null];
var inst_26842 = (new cljs.core.PersistentArrayMap(null,2,inst_26841,null));
var inst_26843 = (new cljs.core.PersistentHashSet(null,inst_26842,null));
var inst_26844 = (inst_26843.cljs$core$IFn$_invoke$arity$1 ? inst_26843.cljs$core$IFn$_invoke$arity$1(from) : inst_26843.call(null,from));
var state_27028__$1 = state_27028;
var statearr_27110_27294 = state_27028__$1;
(statearr_27110_27294[(2)] = inst_26844);

(statearr_27110_27294[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (29))){
var inst_26756 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27111_27295 = state_27028__$1;
(statearr_27111_27295[(2)] = inst_26756);

(statearr_27111_27295[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (44))){
var inst_26798 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_26799 = clojure.string.includes_QMARK_(inst_26798,"/");
var state_27028__$1 = state_27028;
var statearr_27112_27296 = state_27028__$1;
(statearr_27112_27296[(2)] = inst_26799);

(statearr_27112_27296[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (93))){
var inst_26915 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26915)){
var statearr_27113_27297 = state_27028__$1;
(statearr_27113_27297[(1)] = (94));

} else {
var statearr_27114_27298 = state_27028__$1;
(statearr_27114_27298[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (6))){
var inst_26699 = (state_27028[(36)]);
var state_27028__$1 = state_27028;
var statearr_27115_27299 = state_27028__$1;
(statearr_27115_27299[(2)] = inst_26699);

(statearr_27115_27299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (111))){
var inst_26937 = (state_27028[(37)]);
var inst_26959 = (state_27028[(2)]);
var inst_26929 = inst_26937;
var inst_26930 = inst_26959;
var state_27028__$1 = (function (){var statearr_27116 = state_27028;
(statearr_27116[(38)] = inst_26929);

(statearr_27116[(10)] = inst_26930);

return statearr_27116;
})();
var statearr_27117_27300 = state_27028__$1;
(statearr_27117_27300[(2)] = null);

(statearr_27117_27300[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (28))){
var state_27028__$1 = state_27028;
var statearr_27118_27301 = state_27028__$1;
(statearr_27118_27301[(2)] = null);

(statearr_27118_27301[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (64))){
var inst_26721 = (state_27028[(18)]);
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26721)){
var statearr_27119_27302 = state_27028__$1;
(statearr_27119_27302[(1)] = (67));

} else {
var statearr_27120_27303 = state_27028__$1;
(statearr_27120_27303[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (103))){
var state_27028__$1 = state_27028;
if(cljs.core.truth_(fuel)){
var statearr_27121_27304 = state_27028__$1;
(statearr_27121_27304[(1)] = (105));

} else {
var statearr_27122_27305 = state_27028__$1;
(statearr_27122_27305[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (51))){
var inst_26805 = (state_27028[(26)]);
var state_27028__$1 = state_27028;
var statearr_27123_27306 = state_27028__$1;
(statearr_27123_27306[(2)] = inst_26805);

(statearr_27123_27306[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (25))){
var state_27028__$1 = state_27028;
var statearr_27124_27307 = state_27028__$1;
(statearr_27124_27307[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (34))){
var state_27028__$1 = state_27028;
var statearr_27126_27308 = state_27028__$1;
(statearr_27126_27308[(2)] = null);

(statearr_27126_27308[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (125))){
var inst_27006 = (state_27028[(11)]);
var inst_27009 = (state_27028[(30)]);
var inst_27009__$1 = cljs.core.coll_QMARK_(inst_27006);
var state_27028__$1 = (function (){var statearr_27127 = state_27028;
(statearr_27127[(30)] = inst_27009__$1);

return statearr_27127;
})();
if(inst_27009__$1){
var statearr_27128_27309 = state_27028__$1;
(statearr_27128_27309[(1)] = (128));

} else {
var statearr_27129_27310 = state_27028__$1;
(statearr_27129_27310[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (17))){
var inst_26721 = (state_27028[(18)]);
var inst_26732 = (state_27028[(2)]);
var inst_26733 = cljs.core.PersistentHashMap.EMPTY;
var inst_26734 = cljs.core.volatile_BANG_(inst_26733);
var state_27028__$1 = (function (){var statearr_27130 = state_27028;
(statearr_27130[(7)] = inst_26734);

(statearr_27130[(8)] = inst_26732);

return statearr_27130;
})();
if(cljs.core.truth_(inst_26721)){
var statearr_27131_27311 = state_27028__$1;
(statearr_27131_27311[(1)] = (18));

} else {
var statearr_27132_27312 = state_27028__$1;
(statearr_27132_27312[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (3))){
var inst_27026 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27028__$1,inst_27026);
} else {
if((state_val_27029 === (12))){
var inst_26705 = (state_27028[(39)]);
var state_27028__$1 = state_27028;
var statearr_27133_27313 = state_27028__$1;
(statearr_27133_27313[(2)] = inst_26705);

(statearr_27133_27313[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (2))){
var inst_26699 = (state_27028[(36)]);
var _ = (function (){var statearr_27134 = state_27028;
(statearr_27134[(4)] = cljs.core.cons((5),(state_27028[(4)])));

return statearr_27134;
})();
var inst_26699__$1 = select;
var state_27028__$1 = (function (){var statearr_27135 = state_27028;
(statearr_27135[(36)] = inst_26699__$1);

return statearr_27135;
})();
if(cljs.core.truth_(inst_26699__$1)){
var statearr_27136_27314 = state_27028__$1;
(statearr_27136_27314[(1)] = (6));

} else {
var statearr_27137_27315 = state_27028__$1;
(statearr_27137_27315[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (66))){
var inst_26997 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27138_27316 = state_27028__$1;
(statearr_27138_27316[(2)] = inst_26997);

(statearr_27138_27316[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (107))){
var inst_26936 = (state_27028[(19)]);
var inst_26948 = (state_27028[(2)]);
var inst_26949 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_26936,false);
var state_27028__$1 = (function (){var statearr_27139 = state_27028;
(statearr_27139[(40)] = inst_26948);

return statearr_27139;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(108),inst_26949);
} else {
if((state_val_27029 === (23))){
var inst_26760 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27140_27317 = state_27028__$1;
(statearr_27140_27317[(2)] = inst_26760);

(statearr_27140_27317[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (47))){
var inst_26805 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_27028__$1 = (function (){var statearr_27141 = state_27028;
(statearr_27141[(26)] = inst_26805);

return statearr_27141;
})();
if(cljs.core.truth_(fuel)){
var statearr_27142_27318 = state_27028__$1;
(statearr_27142_27318[(1)] = (50));

} else {
var statearr_27143_27319 = state_27028__$1;
(statearr_27143_27319[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (35))){
var inst_26722 = (state_27028[(13)]);
var inst_26724 = (state_27028[(15)]);
var inst_26775 = (state_27028[(2)]);
var inst_26776 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26777 = [inst_26722,inst_26724];
var inst_26778 = cljs.core.PersistentHashMap.fromArrays(inst_26776,inst_26777);
var inst_26779 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_26775,inst_26778);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(36),inst_26779);
} else {
if((state_val_27029 === (127))){
var inst_27018 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_27018)){
var statearr_27144_27320 = state_27028__$1;
(statearr_27144_27320[(1)] = (131));

} else {
var statearr_27145_27321 = state_27028__$1;
(statearr_27145_27321[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (82))){
var inst_26993 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27146_27322 = state_27028__$1;
(statearr_27146_27322[(2)] = inst_26993);

(statearr_27146_27322[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (76))){
var inst_26722 = (state_27028[(13)]);
var inst_26724 = (state_27028[(15)]);
var inst_26871 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26872 = [inst_26722,inst_26724];
var inst_26873 = cljs.core.PersistentHashMap.fromArrays(inst_26871,inst_26872);
var state_27028__$1 = state_27028;
var statearr_27147_27323 = state_27028__$1;
(statearr_27147_27323[(2)] = inst_26873);

(statearr_27147_27323[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (97))){
var inst_26929 = (state_27028[(38)]);
var inst_26936 = (state_27028[(19)]);
var inst_26935 = cljs.core.seq(inst_26929);
var inst_26936__$1 = cljs.core.first(inst_26935);
var inst_26937 = cljs.core.next(inst_26935);
var inst_26938 = cljs.core.not(inst_26936__$1);
var state_27028__$1 = (function (){var statearr_27148 = state_27028;
(statearr_27148[(37)] = inst_26937);

(statearr_27148[(19)] = inst_26936__$1);

return statearr_27148;
})();
if(inst_26938){
var statearr_27149_27324 = state_27028__$1;
(statearr_27149_27324[(1)] = (99));

} else {
var statearr_27150_27325 = state_27028__$1;
(statearr_27150_27325[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (19))){
var inst_26762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26763 = [null,null];
var inst_26764 = (new cljs.core.PersistentVector(null,2,(5),inst_26762,inst_26763,null));
var state_27028__$1 = state_27028;
var statearr_27151_27326 = state_27028__$1;
(statearr_27151_27326[(2)] = inst_26764);

(statearr_27151_27326[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (57))){
var inst_26722 = (state_27028[(13)]);
var inst_26724 = (state_27028[(15)]);
var inst_26821 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26822 = [inst_26722,inst_26724];
var inst_26823 = cljs.core.PersistentHashMap.fromArrays(inst_26821,inst_26822);
var state_27028__$1 = state_27028;
var statearr_27152_27327 = state_27028__$1;
(statearr_27152_27327[(2)] = inst_26823);

(statearr_27152_27327[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (68))){
var inst_26722 = (state_27028[(13)]);
var inst_26724 = (state_27028[(15)]);
var inst_26852 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26853 = [inst_26722,inst_26724];
var inst_26854 = cljs.core.PersistentHashMap.fromArrays(inst_26852,inst_26853);
var state_27028__$1 = state_27028;
var statearr_27153_27328 = state_27028__$1;
(statearr_27153_27328[(2)] = inst_26854);

(statearr_27153_27328[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (11))){
var inst_26716 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27154_27329 = state_27028__$1;
(statearr_27154_27329[(2)] = inst_26716);

(statearr_27154_27329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (115))){
var inst_26721 = (state_27028[(18)]);
var inst_26970 = (state_27028[(2)]);
var state_27028__$1 = (function (){var statearr_27156 = state_27028;
(statearr_27156[(34)] = inst_26970);

return statearr_27156;
})();
if(cljs.core.truth_(inst_26721)){
var statearr_27157_27330 = state_27028__$1;
(statearr_27157_27330[(1)] = (116));

} else {
var statearr_27158_27331 = state_27028__$1;
(statearr_27158_27331[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (9))){
var inst_26702 = (state_27028[(12)]);
var state_27028__$1 = state_27028;
var statearr_27159_27332 = state_27028__$1;
(statearr_27159_27332[(2)] = inst_26702);

(statearr_27159_27332[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (5))){
var _ = (function (){var statearr_27160 = state_27028;
(statearr_27160[(4)] = cljs.core.rest((state_27028[(4)])));

return statearr_27160;
})();
var state_27028__$1 = state_27028;
var ex27155 = (state_27028__$1[(2)]);
var statearr_27161_27333 = state_27028__$1;
(statearr_27161_27333[(5)] = ex27155);


if((ex27155 instanceof Error)){
var statearr_27162_27334 = state_27028__$1;
(statearr_27162_27334[(1)] = (4));

(statearr_27162_27334[(5)] = null);

} else {
throw ex27155;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (112))){
var inst_26977 = (state_27028[(2)]);
var inst_26978 = fluree.db.util.async.throw_err(inst_26977);
var state_27028__$1 = state_27028;
var statearr_27163_27335 = state_27028__$1;
(statearr_27163_27335[(2)] = inst_26978);

(statearr_27163_27335[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (83))){
var inst_26891 = (state_27028[(20)]);
var inst_26890 = (state_27028[(2)]);
var inst_26891__$1 = fluree.db.util.async.throw_err(inst_26890);
var inst_26892 = (inst_26891__$1 == null);
var state_27028__$1 = (function (){var statearr_27164 = state_27028;
(statearr_27164[(20)] = inst_26891__$1);

return statearr_27164;
})();
if(cljs.core.truth_(inst_26892)){
var statearr_27165_27336 = state_27028__$1;
(statearr_27165_27336[(1)] = (84));

} else {
var statearr_27166_27337 = state_27028__$1;
(statearr_27166_27337[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (14))){
var inst_26714 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27167_27338 = state_27028__$1;
(statearr_27167_27338[(2)] = inst_26714);

(statearr_27167_27338[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (45))){
var inst_26796 = (state_27028[(27)]);
var state_27028__$1 = state_27028;
var statearr_27168_27339 = state_27028__$1;
(statearr_27168_27339[(2)] = inst_26796);

(statearr_27168_27339[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (53))){
var inst_26811 = (state_27028[(21)]);
var inst_26813 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_26814 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26811,inst_26813);
var state_27028__$1 = state_27028;
var statearr_27169_27340 = state_27028__$1;
(statearr_27169_27340[(2)] = inst_26814);

(statearr_27169_27340[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (78))){
var inst_26734 = (state_27028[(7)]);
var inst_26732 = (state_27028[(8)]);
var inst_26878 = (state_27028[(2)]);
var inst_26879 = fluree.db.util.async.throw_err(inst_26878);
var inst_26880 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_26734,fuel,max_fuel,inst_26732,inst_26879);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(79),inst_26880);
} else {
if((state_val_27029 === (132))){
var inst_27006 = (state_27028[(11)]);
var state_27028__$1 = state_27028;
var statearr_27170_27341 = state_27028__$1;
(statearr_27170_27341[(2)] = inst_27006);

(statearr_27170_27341[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (26))){
var inst_26758 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27171_27342 = state_27028__$1;
(statearr_27171_27342[(2)] = inst_26758);

(statearr_27171_27342[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (123))){
var inst_27001 = (state_27028[(28)]);
var state_27028__$1 = state_27028;
var statearr_27172_27343 = state_27028__$1;
(statearr_27172_27343[(2)] = inst_27001);

(statearr_27172_27343[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (16))){
var inst_26725 = (state_27028[(24)]);
var state_27028__$1 = state_27028;
var statearr_27173_27344 = state_27028__$1;
(statearr_27173_27344[(2)] = inst_26725);

(statearr_27173_27344[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (133))){
var inst_27023 = (state_27028[(2)]);
var _ = (function (){var statearr_27174 = state_27028;
(statearr_27174[(4)] = cljs.core.rest((state_27028[(4)])));

return statearr_27174;
})();
var state_27028__$1 = state_27028;
var statearr_27175_27345 = state_27028__$1;
(statearr_27175_27345[(2)] = inst_27023);

(statearr_27175_27345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (81))){
var inst_26910 = (state_27028[(22)]);
var inst_26910__$1 = cljs.core.sequential_QMARK_(from);
var state_27028__$1 = (function (){var statearr_27176 = state_27028;
(statearr_27176[(22)] = inst_26910__$1);

return statearr_27176;
})();
if(inst_26910__$1){
var statearr_27177_27346 = state_27028__$1;
(statearr_27177_27346[(1)] = (91));

} else {
var statearr_27178_27347 = state_27028__$1;
(statearr_27178_27347[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (120))){
var state_27028__$1 = state_27028;
var statearr_27179_27348 = state_27028__$1;
(statearr_27179_27348[(2)] = null);

(statearr_27179_27348[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (79))){
var inst_26882 = (state_27028[(2)]);
var inst_26883 = fluree.db.util.async.throw_err(inst_26882);
var state_27028__$1 = state_27028;
var statearr_27180_27349 = state_27028__$1;
(statearr_27180_27349[(2)] = inst_26883);

(statearr_27180_27349[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (38))){
var state_27028__$1 = state_27028;
var statearr_27181_27350 = state_27028__$1;
(statearr_27181_27350[(2)] = null);

(statearr_27181_27350[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (126))){
var inst_27007 = (state_27028[(41)]);
var state_27028__$1 = state_27028;
var statearr_27182_27351 = state_27028__$1;
(statearr_27182_27351[(2)] = inst_27007);

(statearr_27182_27351[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (98))){
var inst_26721 = (state_27028[(18)]);
var inst_26964 = (state_27028[(2)]);
var inst_26965 = cljs.core.PersistentVector.EMPTY;
var inst_26966 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26965,inst_26964);
var state_27028__$1 = (function (){var statearr_27183 = state_27028;
(statearr_27183[(35)] = inst_26966);

return statearr_27183;
})();
if(cljs.core.truth_(inst_26721)){
var statearr_27184_27352 = state_27028__$1;
(statearr_27184_27352[(1)] = (113));

} else {
var statearr_27185_27353 = state_27028__$1;
(statearr_27185_27353[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (124))){
var inst_27007 = (state_27028[(41)]);
var inst_27006 = (state_27028[(2)]);
var inst_27007__$1 = selectOne;
var state_27028__$1 = (function (){var statearr_27186 = state_27028;
(statearr_27186[(11)] = inst_27006);

(statearr_27186[(41)] = inst_27007__$1);

return statearr_27186;
})();
if(cljs.core.truth_(inst_27007__$1)){
var statearr_27187_27354 = state_27028__$1;
(statearr_27187_27354[(1)] = (125));

} else {
var statearr_27188_27355 = state_27028__$1;
(statearr_27188_27355[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (87))){
var inst_26902 = (state_27028[(2)]);
var inst_26903 = fluree.db.util.async.throw_err(inst_26902);
var state_27028__$1 = (function (){var statearr_27189 = state_27028;
(statearr_27189[(31)] = inst_26903);

return statearr_27189;
})();
if(cljs.core.truth_(fuel)){
var statearr_27190_27356 = state_27028__$1;
(statearr_27190_27356[(1)] = (88));

} else {
var statearr_27191_27357 = state_27028__$1;
(statearr_27191_27357[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (30))){
var inst_26771 = typeof from === 'string';
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26771)){
var statearr_27192_27358 = state_27028__$1;
(statearr_27192_27358[(1)] = (33));

} else {
var statearr_27193_27359 = state_27028__$1;
(statearr_27193_27359[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (73))){
var inst_26885 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_27028__$1 = state_27028;
if(inst_26885){
var statearr_27194_27360 = state_27028__$1;
(statearr_27194_27360[(1)] = (80));

} else {
var statearr_27195_27361 = state_27028__$1;
(statearr_27195_27361[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (96))){
var inst_26991 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27196_27362 = state_27028__$1;
(statearr_27196_27362[(2)] = inst_26991);

(statearr_27196_27362[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (10))){
var inst_26705 = (state_27028[(39)]);
var inst_26705__$1 = selectDistinct;
var state_27028__$1 = (function (){var statearr_27197 = state_27028;
(statearr_27197[(39)] = inst_26705__$1);

return statearr_27197;
})();
if(cljs.core.truth_(inst_26705__$1)){
var statearr_27198_27363 = state_27028__$1;
(statearr_27198_27363[(1)] = (12));

} else {
var statearr_27199_27364 = state_27028__$1;
(statearr_27199_27364[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (18))){
var inst_26721 = (state_27028[(18)]);
var inst_26736 = cljs.core.vector_QMARK_(inst_26721);
var state_27028__$1 = state_27028;
if(inst_26736){
var statearr_27200_27365 = state_27028__$1;
(statearr_27200_27365[(1)] = (21));

} else {
var statearr_27201_27366 = state_27028__$1;
(statearr_27201_27366[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (105))){
var inst_26945 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_27028__$1 = state_27028;
var statearr_27202_27367 = state_27028__$1;
(statearr_27202_27367[(2)] = inst_26945);

(statearr_27202_27367[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (52))){
var inst_26811 = (state_27028[(2)]);
var state_27028__$1 = (function (){var statearr_27203 = state_27028;
(statearr_27203[(21)] = inst_26811);

return statearr_27203;
})();
var statearr_27204_27368 = state_27028__$1;
(statearr_27204_27368[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (114))){
var inst_26722 = (state_27028[(13)]);
var state_27028__$1 = state_27028;
var statearr_27206_27369 = state_27028__$1;
(statearr_27206_27369[(2)] = inst_26722);

(statearr_27206_27369[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (67))){
var inst_26850 = cljs.core.PersistentHashMap.EMPTY;
var state_27028__$1 = state_27028;
var statearr_27207_27370 = state_27028__$1;
(statearr_27207_27370[(2)] = inst_26850);

(statearr_27207_27370[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (71))){
var inst_26863 = (state_27028[(2)]);
var inst_26864 = fluree.db.util.async.throw_err(inst_26863);
var state_27028__$1 = state_27028;
var statearr_27208_27371 = state_27028__$1;
(statearr_27208_27371[(2)] = inst_26864);

(statearr_27208_27371[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (42))){
var inst_26724 = (state_27028[(15)]);
var state_27028__$1 = state_27028;
var statearr_27209_27372 = state_27028__$1;
(statearr_27209_27372[(2)] = inst_26724);

(statearr_27209_27372[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (80))){
var inst_26888 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_27028__$1 = state_27028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27028__$1,(83),inst_26888);
} else {
if((state_val_27029 === (37))){
var inst_26793 = (state_27028[(2)]);
var inst_26794 = fluree.db.util.async.throw_err(inst_26793);
var state_27028__$1 = state_27028;
var statearr_27210_27373 = state_27028__$1;
(statearr_27210_27373[(2)] = inst_26794);

(statearr_27210_27373[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (63))){
var inst_26847 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
if(cljs.core.truth_(inst_26847)){
var statearr_27211_27374 = state_27028__$1;
(statearr_27211_27374[(1)] = (64));

} else {
var statearr_27212_27375 = state_27028__$1;
(statearr_27212_27375[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (94))){
var inst_26924 = from;
var inst_26925 = cljs.core.seq(inst_26924);
var inst_26926 = cljs.core.first(inst_26925);
var inst_26927 = cljs.core.next(inst_26925);
var inst_26928 = cljs.core.PersistentVector.EMPTY;
var inst_26929 = inst_26924;
var inst_26930 = inst_26928;
var state_27028__$1 = (function (){var statearr_27213 = state_27028;
(statearr_27213[(42)] = inst_26926);

(statearr_27213[(43)] = inst_26927);

(statearr_27213[(38)] = inst_26929);

(statearr_27213[(10)] = inst_26930);

return statearr_27213;
})();
var statearr_27214_27376 = state_27028__$1;
(statearr_27214_27376[(2)] = null);

(statearr_27214_27376[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (8))){
var inst_26723 = (state_27028[(25)]);
var inst_26718 = (state_27028[(2)]);
var inst_26719 = opts_SINGLEQUOTE_;
var inst_26720 = cljs.core.__destructure_map(inst_26719);
var inst_26721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26720,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_26722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26720,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_26723__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26720,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_26724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26720,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_26725 = fluree.db.query.fql_parser.parse_db(db,inst_26718,opts_SINGLEQUOTE_);
var inst_26726 = (inst_26723__$1 == null);
var inst_26727 = cljs.core.not(inst_26726);
var state_27028__$1 = (function (){var statearr_27215 = state_27028;
(statearr_27215[(13)] = inst_26722);

(statearr_27215[(24)] = inst_26725);

(statearr_27215[(15)] = inst_26724);

(statearr_27215[(25)] = inst_26723__$1);

(statearr_27215[(18)] = inst_26721);

return statearr_27215;
})();
if(inst_26727){
var statearr_27216_27377 = state_27028__$1;
(statearr_27216_27377[(1)] = (15));

} else {
var statearr_27217_27378 = state_27028__$1;
(statearr_27217_27378[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (49))){
var inst_26999 = (state_27028[(2)]);
var state_27028__$1 = state_27028;
var statearr_27218_27379 = state_27028__$1;
(statearr_27218_27379[(2)] = inst_26999);

(statearr_27218_27379[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27029 === (84))){
var state_27028__$1 = state_27028;
var statearr_27219_27380 = state_27028__$1;
(statearr_27219_27380[(2)] = null);

(statearr_27219_27380[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2727__auto____0 = (function (){
var statearr_27220 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27220[(0)] = fluree$db$query$fql$query_$_state_machine__2727__auto__);

(statearr_27220[(1)] = (1));

return statearr_27220;
});
var fluree$db$query$fql$query_$_state_machine__2727__auto____1 = (function (state_27028){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27028);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27221){var ex__2730__auto__ = e27221;
var statearr_27222_27381 = state_27028;
(statearr_27222_27381[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27028[(4)]))){
var statearr_27223_27382 = state_27028;
(statearr_27223_27382[(1)] = cljs.core.first((state_27028[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27383 = state_27028;
state_27028 = G__27383;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2727__auto__ = function(state_27028){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2727__auto____1.call(this,state_27028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2727__auto____0;
fluree$db$query$fql$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27224 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27224[(6)] = c__2749__auto__);

return statearr_27224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}

});
