// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__66501 = opts_SINGLEQUOTE_;
var map__66501__$1 = cljs.core.__destructure_map(map__66501);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66501__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__66503 = arguments.length;
switch (G__66503) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__66506 = arguments.length;
switch (G__66506) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__66509 = arguments.length;
switch (G__66509) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__66512 = arguments.length;
switch (G__66512) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__66515 = arguments.length;
switch (G__66515) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__66518 = arguments.length;
switch (G__66518) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66527 = arguments.length;
var i__5770__auto___66528 = (0);
while(true){
if((i__5770__auto___66528 < len__5769__auto___66527)){
args__5775__auto__.push((arguments[i__5770__auto___66528]));

var G__66529 = (i__5770__auto___66528 + (1));
i__5770__auto___66528 = G__66529;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__66523){
var vec__66524 = p__66523;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66524,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq66520){
var G__66521 = cljs.core.first(seq66520);
var seq66520__$1 = cljs.core.next(seq66520);
var G__66522 = cljs.core.first(seq66520__$1);
var seq66520__$2 = cljs.core.next(seq66520__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66521,G__66522,seq66520__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66548){
var state_val_66549 = (state_66548[(1)]);
if((state_val_66549 === (1))){
var state_66548__$1 = state_66548;
var statearr_66550_66565 = state_66548__$1;
(statearr_66550_66565[(2)] = null);

(statearr_66550_66565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (2))){
var _ = (function (){var statearr_66551 = state_66548;
(statearr_66551[(4)] = cljs.core.cons((5),(state_66548[(4)])));

return statearr_66551;
})();
var state_66548__$1 = state_66548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66548__$1,(6),db);
} else {
if((state_val_66549 === (3))){
var inst_66546 = (state_66548[(2)]);
var state_66548__$1 = state_66548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66548__$1,inst_66546);
} else {
if((state_val_66549 === (4))){
var inst_66530 = (state_66548[(2)]);
var inst_66531 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66530], 0));
var inst_66532 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66530) : reject.call(null,inst_66530));
var state_66548__$1 = (function (){var statearr_66553 = state_66548;
(statearr_66553[(7)] = inst_66531);

return statearr_66553;
})();
var statearr_66554_66566 = state_66548__$1;
(statearr_66554_66566[(2)] = inst_66532);

(statearr_66554_66566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (5))){
var _ = (function (){var statearr_66555 = state_66548;
(statearr_66555[(4)] = cljs.core.rest((state_66548[(4)])));

return statearr_66555;
})();
var state_66548__$1 = state_66548;
var ex66552 = (state_66548__$1[(2)]);
var statearr_66556_66567 = state_66548__$1;
(statearr_66556_66567[(5)] = ex66552);


var statearr_66557_66568 = state_66548__$1;
(statearr_66557_66568[(1)] = (4));

(statearr_66557_66568[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (6))){
var inst_66539 = (state_66548[(2)]);
var inst_66540 = fluree.db.util.async.throw_err(inst_66539);
var inst_66541 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_66540);
var inst_66542 = cljs.core.clj__GT_js(inst_66541);
var inst_66543 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66542) : resolve.call(null,inst_66542));
var _ = (function (){var statearr_66558 = state_66548;
(statearr_66558[(4)] = cljs.core.rest((state_66548[(4)])));

return statearr_66558;
})();
var state_66548__$1 = state_66548;
var statearr_66559_66569 = state_66548__$1;
(statearr_66559_66569[(2)] = inst_66543);

(statearr_66559_66569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2727__auto__ = null;
var flureedb$db_schema_$_state_machine__2727__auto____0 = (function (){
var statearr_66560 = [null,null,null,null,null,null,null,null];
(statearr_66560[(0)] = flureedb$db_schema_$_state_machine__2727__auto__);

(statearr_66560[(1)] = (1));

return statearr_66560;
});
var flureedb$db_schema_$_state_machine__2727__auto____1 = (function (state_66548){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66548);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66561){var ex__2730__auto__ = e66561;
var statearr_66562_66570 = state_66548;
(statearr_66562_66570[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66548[(4)]))){
var statearr_66563_66571 = state_66548;
(statearr_66563_66571[(1)] = cljs.core.first((state_66548[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66572 = state_66548;
state_66548 = G__66572;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2727__auto__ = function(state_66548){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2727__auto____1.call(this,state_66548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2727__auto____0;
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2727__auto____1;
return flureedb$db_schema_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66564 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66564[(6)] = c__2749__auto__);

return statearr_66564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__66574 = arguments.length;
switch (G__66574) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66644){
var state_val_66645 = (state_66644[(1)]);
if((state_val_66645 === (7))){
var inst_66587 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66644__$1 = state_66644;
var statearr_66646_66691 = state_66644__$1;
(statearr_66646_66691[(2)] = inst_66587);

(statearr_66646_66691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (20))){
var inst_66595 = (state_66644[(7)]);
var inst_66619 = (state_66644[(2)]);
var state_66644__$1 = (function (){var statearr_66647 = state_66644;
(statearr_66647[(8)] = inst_66619);

return statearr_66647;
})();
if(cljs.core.truth_(inst_66595)){
var statearr_66648_66692 = state_66644__$1;
(statearr_66648_66692[(1)] = (21));

} else {
var statearr_66649_66693 = state_66644__$1;
(statearr_66649_66693[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (1))){
var state_66644__$1 = state_66644;
var statearr_66650_66694 = state_66644__$1;
(statearr_66650_66694[(2)] = null);

(statearr_66650_66694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (24))){
var inst_66626 = (state_66644[(2)]);
var inst_66627 = fluree.db.util.async.throw_err(inst_66626);
var state_66644__$1 = state_66644;
var statearr_66651_66695 = state_66644__$1;
(statearr_66651_66695[(2)] = inst_66627);

(statearr_66651_66695[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (4))){
var inst_66575 = (state_66644[(2)]);
var inst_66576 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66575], 0));
var inst_66577 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66575) : reject.call(null,inst_66575));
var state_66644__$1 = (function (){var statearr_66652 = state_66644;
(statearr_66652[(9)] = inst_66576);

return statearr_66652;
})();
var statearr_66653_66696 = state_66644__$1;
(statearr_66653_66696[(2)] = inst_66577);

(statearr_66653_66696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (15))){
var inst_66608 = (state_66644[(10)]);
var inst_66610 = fluree.db.util.core.without_nils(inst_66608);
var inst_66611 = fluree.db.util.json.stringify(inst_66610);
var state_66644__$1 = state_66644;
var statearr_66654_66697 = state_66644__$1;
(statearr_66654_66697[(2)] = inst_66611);

(statearr_66654_66697[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (21))){
var inst_66614 = (state_66644[(11)]);
var inst_66619 = (state_66644[(8)]);
var inst_66621 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66622 = [inst_66614,inst_66619];
var inst_66623 = cljs.core.PersistentHashMap.fromArrays(inst_66621,inst_66622);
var inst_66624 = fluree.db.operations.command_async(conn,inst_66623);
var state_66644__$1 = state_66644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66644__$1,(24),inst_66624);
} else {
if((state_val_66645 === (13))){
var inst_66596 = (state_66644[(12)]);
var inst_66603 = (inst_66596 + (30000));
var state_66644__$1 = state_66644;
var statearr_66655_66698 = state_66644__$1;
(statearr_66655_66698[(2)] = inst_66603);

(statearr_66655_66698[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (22))){
var inst_66608 = (state_66644[(10)]);
var inst_66629 = fluree.db.operations.unsigned_command_async(conn,inst_66608);
var state_66644__$1 = state_66644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66644__$1,(25),inst_66629);
} else {
if((state_val_66645 === (6))){
var state_66644__$1 = state_66644;
var statearr_66656_66699 = state_66644__$1;
(statearr_66656_66699[(2)] = null);

(statearr_66656_66699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (25))){
var inst_66631 = (state_66644[(2)]);
var inst_66632 = fluree.db.util.async.throw_err(inst_66631);
var state_66644__$1 = state_66644;
var statearr_66657_66700 = state_66644__$1;
(statearr_66657_66700[(2)] = inst_66632);

(statearr_66657_66700[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (17))){
var inst_66595 = (state_66644[(7)]);
var inst_66614 = (state_66644[(2)]);
var state_66644__$1 = (function (){var statearr_66658 = state_66644;
(statearr_66658[(11)] = inst_66614);

return statearr_66658;
})();
if(cljs.core.truth_(inst_66595)){
var statearr_66659_66701 = state_66644__$1;
(statearr_66659_66701[(1)] = (18));

} else {
var statearr_66660_66702 = state_66644__$1;
(statearr_66660_66702[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (3))){
var inst_66642 = (state_66644[(2)]);
var state_66644__$1 = state_66644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66644__$1,inst_66642);
} else {
if((state_val_66645 === (12))){
var inst_66593 = (state_66644[(13)]);
var state_66644__$1 = state_66644;
var statearr_66661_66703 = state_66644__$1;
(statearr_66661_66703[(2)] = inst_66593);

(statearr_66661_66703[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (2))){
var _ = (function (){var statearr_66662 = state_66644;
(statearr_66662[(4)] = cljs.core.cons((5),(state_66644[(4)])));

return statearr_66662;
})();
var inst_66584 = (opts == null);
var state_66644__$1 = state_66644;
if(cljs.core.truth_(inst_66584)){
var statearr_66663_66704 = state_66644__$1;
(statearr_66663_66704[(1)] = (6));

} else {
var statearr_66664_66705 = state_66644__$1;
(statearr_66664_66705[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (23))){
var inst_66634 = (state_66644[(2)]);
var inst_66635 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66636 = [(200),inst_66634];
var inst_66637 = cljs.core.PersistentHashMap.fromArrays(inst_66635,inst_66636);
var inst_66638 = cljs.core.clj__GT_js(inst_66637);
var inst_66639 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66638) : resolve.call(null,inst_66638));
var _ = (function (){var statearr_66665 = state_66644;
(statearr_66665[(4)] = cljs.core.rest((state_66644[(4)])));

return statearr_66665;
})();
var state_66644__$1 = state_66644;
var statearr_66666_66706 = state_66644__$1;
(statearr_66666_66706[(2)] = inst_66639);

(statearr_66666_66706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (19))){
var state_66644__$1 = state_66644;
var statearr_66667_66707 = state_66644__$1;
(statearr_66667_66707[(2)] = null);

(statearr_66667_66707[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (11))){
var inst_66593 = (state_66644[(13)]);
var inst_66600 = (state_66644[(2)]);
var state_66644__$1 = (function (){var statearr_66669 = state_66644;
(statearr_66669[(14)] = inst_66600);

return statearr_66669;
})();
if(cljs.core.truth_(inst_66593)){
var statearr_66670_66708 = state_66644__$1;
(statearr_66670_66708[(1)] = (12));

} else {
var statearr_66671_66709 = state_66644__$1;
(statearr_66671_66709[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (9))){
var inst_66592 = (state_66644[(15)]);
var state_66644__$1 = state_66644;
var statearr_66672_66710 = state_66644__$1;
(statearr_66672_66710[(2)] = inst_66592);

(statearr_66672_66710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (5))){
var _ = (function (){var statearr_66673 = state_66644;
(statearr_66673[(4)] = cljs.core.rest((state_66644[(4)])));

return statearr_66673;
})();
var state_66644__$1 = state_66644;
var ex66668 = (state_66644__$1[(2)]);
var statearr_66674_66711 = state_66644__$1;
(statearr_66674_66711[(5)] = ex66668);


var statearr_66675_66712 = state_66644__$1;
(statearr_66675_66712[(1)] = (4));

(statearr_66675_66712[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (14))){
var inst_66600 = (state_66644[(14)]);
var inst_66595 = (state_66644[(7)]);
var inst_66605 = (state_66644[(2)]);
var inst_66606 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_66607 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_66600,inst_66605];
var inst_66608 = cljs.core.PersistentHashMap.fromArrays(inst_66606,inst_66607);
var state_66644__$1 = (function (){var statearr_66676 = state_66644;
(statearr_66676[(10)] = inst_66608);

return statearr_66676;
})();
if(cljs.core.truth_(inst_66595)){
var statearr_66677_66713 = state_66644__$1;
(statearr_66677_66713[(1)] = (15));

} else {
var statearr_66678_66714 = state_66644__$1;
(statearr_66678_66714[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (16))){
var state_66644__$1 = state_66644;
var statearr_66679_66715 = state_66644__$1;
(statearr_66679_66715[(2)] = null);

(statearr_66679_66715[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (10))){
var inst_66596 = (state_66644[(12)]);
var state_66644__$1 = state_66644;
var statearr_66680_66716 = state_66644__$1;
(statearr_66680_66716[(2)] = inst_66596);

(statearr_66680_66716[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (18))){
var inst_66614 = (state_66644[(11)]);
var inst_66595 = (state_66644[(7)]);
var inst_66616 = fluree.crypto.sign_message(inst_66614,inst_66595);
var state_66644__$1 = state_66644;
var statearr_66681_66717 = state_66644__$1;
(statearr_66681_66717[(2)] = inst_66616);

(statearr_66681_66717[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66645 === (8))){
var inst_66592 = (state_66644[(15)]);
var inst_66589 = (state_66644[(2)]);
var inst_66590 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66589);
var inst_66591 = cljs.core.__destructure_map(inst_66589);
var inst_66592__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66591,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66593 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66591,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66594 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66591,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66591,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66596 = fluree.db.util.core.current_time_millis();
var state_66644__$1 = (function (){var statearr_66682 = state_66644;
(statearr_66682[(16)] = inst_66590);

(statearr_66682[(15)] = inst_66592__$1);

(statearr_66682[(13)] = inst_66593);

(statearr_66682[(17)] = inst_66594);

(statearr_66682[(12)] = inst_66596);

(statearr_66682[(7)] = inst_66595);

return statearr_66682;
})();
if(cljs.core.truth_(inst_66592__$1)){
var statearr_66683_66718 = state_66644__$1;
(statearr_66683_66718[(1)] = (9));

} else {
var statearr_66684_66719 = state_66644__$1;
(statearr_66684_66719[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66685 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66685[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66685[(1)] = (1));

return statearr_66685;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66644){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66644);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66686){var ex__2730__auto__ = e66686;
var statearr_66687_66720 = state_66644;
(statearr_66687_66720[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66644[(4)]))){
var statearr_66688_66721 = state_66644;
(statearr_66688_66721[(1)] = cljs.core.first((state_66644[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66722 = state_66644;
state_66644 = G__66722;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66644){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66689 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66689[(6)] = c__2749__auto__);

return statearr_66689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66741){
var state_val_66742 = (state_66741[(1)]);
if((state_val_66742 === (1))){
var state_66741__$1 = state_66741;
var statearr_66743_66758 = state_66741__$1;
(statearr_66743_66758[(2)] = null);

(statearr_66743_66758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66742 === (2))){
var _ = (function (){var statearr_66744 = state_66741;
(statearr_66744[(4)] = cljs.core.cons((5),(state_66741[(4)])));

return statearr_66744;
})();
var inst_66731 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_66741__$1 = state_66741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66741__$1,(6),inst_66731);
} else {
if((state_val_66742 === (3))){
var inst_66739 = (state_66741[(2)]);
var state_66741__$1 = state_66741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66741__$1,inst_66739);
} else {
if((state_val_66742 === (4))){
var inst_66723 = (state_66741[(2)]);
var inst_66724 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66723], 0));
var inst_66725 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66723) : reject.call(null,inst_66723));
var state_66741__$1 = (function (){var statearr_66746 = state_66741;
(statearr_66746[(7)] = inst_66724);

return statearr_66746;
})();
var statearr_66747_66759 = state_66741__$1;
(statearr_66747_66759[(2)] = inst_66725);

(statearr_66747_66759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66742 === (5))){
var _ = (function (){var statearr_66748 = state_66741;
(statearr_66748[(4)] = cljs.core.rest((state_66741[(4)])));

return statearr_66748;
})();
var state_66741__$1 = state_66741;
var ex66745 = (state_66741__$1[(2)]);
var statearr_66749_66760 = state_66741__$1;
(statearr_66749_66760[(5)] = ex66745);


var statearr_66750_66761 = state_66741__$1;
(statearr_66750_66761[(1)] = (4));

(statearr_66750_66761[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66742 === (6))){
var inst_66733 = (state_66741[(2)]);
var inst_66734 = fluree.db.util.async.throw_err(inst_66733);
var inst_66735 = cljs.core.clj__GT_js(inst_66734);
var inst_66736 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66735) : resolve.call(null,inst_66735));
var _ = (function (){var statearr_66751 = state_66741;
(statearr_66751[(4)] = cljs.core.rest((state_66741[(4)])));

return statearr_66751;
})();
var state_66741__$1 = state_66741;
var statearr_66752_66762 = state_66741__$1;
(statearr_66752_66762[(2)] = inst_66736);

(statearr_66752_66762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2727__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2727__auto____0 = (function (){
var statearr_66753 = [null,null,null,null,null,null,null,null];
(statearr_66753[(0)] = flureedb$ledger_stats_$_state_machine__2727__auto__);

(statearr_66753[(1)] = (1));

return statearr_66753;
});
var flureedb$ledger_stats_$_state_machine__2727__auto____1 = (function (state_66741){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66741);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66754){var ex__2730__auto__ = e66754;
var statearr_66755_66763 = state_66741;
(statearr_66755_66763[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66741[(4)]))){
var statearr_66756_66764 = state_66741;
(statearr_66756_66764[(1)] = cljs.core.first((state_66741[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66765 = state_66741;
state_66741 = G__66765;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2727__auto__ = function(state_66741){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2727__auto____1.call(this,state_66741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2727__auto____0;
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2727__auto____1;
return flureedb$ledger_stats_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66757 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66757[(6)] = c__2749__auto__);

return statearr_66757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__66767 = arguments.length;
switch (G__66767) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66891){
var state_val_66892 = (state_66891[(1)]);
if((state_val_66892 === (7))){
var inst_66790 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66891__$1 = state_66891;
var statearr_66893_66963 = state_66891__$1;
(statearr_66893_66963[(2)] = inst_66790);

(statearr_66893_66963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (20))){
var inst_66797 = (state_66891[(7)]);
var inst_66836 = (state_66891[(2)]);
var inst_66837 = fluree.db.util.core.current_time_millis();
var state_66891__$1 = (function (){var statearr_66894 = state_66891;
(statearr_66894[(8)] = inst_66836);

(statearr_66894[(9)] = inst_66837);

return statearr_66894;
})();
if(cljs.core.truth_(inst_66797)){
var statearr_66895_66964 = state_66891__$1;
(statearr_66895_66964[(1)] = (21));

} else {
var statearr_66896_66965 = state_66891__$1;
(statearr_66896_66965[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (27))){
var inst_66850 = (state_66891[(10)]);
var inst_66805 = (state_66891[(11)]);
var inst_66852 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66850,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_66805);
var state_66891__$1 = state_66891;
var statearr_66897_66966 = state_66891__$1;
(statearr_66897_66966[(2)] = inst_66852);

(statearr_66897_66966[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (1))){
var state_66891__$1 = state_66891;
var statearr_66898_66967 = state_66891__$1;
(statearr_66898_66967[(2)] = null);

(statearr_66898_66967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (24))){
var inst_66803 = (state_66891[(12)]);
var state_66891__$1 = state_66891;
var statearr_66899_66968 = state_66891__$1;
(statearr_66899_66968[(2)] = inst_66803);

(statearr_66899_66968[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (39))){
var inst_66873 = (state_66891[(2)]);
var inst_66874 = fluree.db.util.async.throw_err(inst_66873);
var state_66891__$1 = state_66891;
var statearr_66900_66969 = state_66891__$1;
(statearr_66900_66969[(2)] = inst_66874);

(statearr_66900_66969[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (4))){
var inst_66768 = (state_66891[(2)]);
var inst_66769 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66768], 0));
var inst_66770 = cljs.core.ex_data(inst_66768);
var inst_66771 = cljs.core.ex_message(inst_66768);
var inst_66772 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66770,new cljs.core.Keyword(null,"message","message",-406056002),inst_66771);
var inst_66773 = cljs.core.clj__GT_js(inst_66772);
var inst_66774 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66773) : reject.call(null,inst_66773));
var state_66891__$1 = (function (){var statearr_66901 = state_66891;
(statearr_66901[(13)] = inst_66769);

return statearr_66901;
})();
var statearr_66902_66970 = state_66891__$1;
(statearr_66902_66970[(2)] = inst_66774);

(statearr_66902_66970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (15))){
var inst_66826 = (state_66891[(14)]);
var inst_66828 = fluree.db.graphdb.validate_ledger_name(inst_66826,"alias");
var state_66891__$1 = state_66891;
var statearr_66903_66971 = state_66891__$1;
(statearr_66903_66971[(2)] = inst_66828);

(statearr_66903_66971[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (21))){
var inst_66797 = (state_66891[(7)]);
var state_66891__$1 = state_66891;
var statearr_66904_66972 = state_66891__$1;
(statearr_66904_66972[(2)] = inst_66797);

(statearr_66904_66972[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (31))){
var state_66891__$1 = state_66891;
var statearr_66905_66973 = state_66891__$1;
(statearr_66905_66973[(2)] = null);

(statearr_66905_66973[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (32))){
var inst_66799 = (state_66891[(15)]);
var inst_66861 = (state_66891[(2)]);
var state_66891__$1 = (function (){var statearr_66906 = state_66891;
(statearr_66906[(16)] = inst_66861);

return statearr_66906;
})();
if(cljs.core.truth_(inst_66799)){
var statearr_66907_66974 = state_66891__$1;
(statearr_66907_66974[(1)] = (33));

} else {
var statearr_66908_66975 = state_66891__$1;
(statearr_66908_66975[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (40))){
var inst_66878 = (state_66891[(2)]);
var inst_66879 = fluree.db.util.async.throw_err(inst_66878);
var state_66891__$1 = state_66891;
var statearr_66909_66976 = state_66891__$1;
(statearr_66909_66976[(2)] = inst_66879);

(statearr_66909_66976[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (33))){
var inst_66861 = (state_66891[(16)]);
var inst_66799 = (state_66891[(15)]);
var inst_66863 = fluree.crypto.sign_message(inst_66861,inst_66799);
var state_66891__$1 = state_66891;
var statearr_66910_66977 = state_66891__$1;
(statearr_66910_66977[(2)] = inst_66863);

(statearr_66910_66977[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (13))){
var state_66891__$1 = state_66891;
var statearr_66911_66978 = state_66891__$1;
(statearr_66911_66978[(2)] = null);

(statearr_66911_66978[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (22))){
var inst_66837 = (state_66891[(9)]);
var state_66891__$1 = state_66891;
var statearr_66912_66979 = state_66891__$1;
(statearr_66912_66979[(2)] = inst_66837);

(statearr_66912_66979[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (36))){
var inst_66861 = (state_66891[(16)]);
var inst_66866 = (state_66891[(17)]);
var inst_66868 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66869 = [inst_66861,inst_66866];
var inst_66870 = cljs.core.PersistentHashMap.fromArrays(inst_66868,inst_66869);
var inst_66871 = fluree.db.operations.command_async(conn,inst_66870);
var state_66891__$1 = state_66891;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66891__$1,(39),inst_66871);
} else {
if((state_val_66892 === (29))){
var inst_66799 = (state_66891[(15)]);
var inst_66855 = (state_66891[(2)]);
var state_66891__$1 = (function (){var statearr_66913 = state_66891;
(statearr_66913[(18)] = inst_66855);

return statearr_66913;
})();
if(cljs.core.truth_(inst_66799)){
var statearr_66914_66980 = state_66891__$1;
(statearr_66914_66980[(1)] = (30));

} else {
var statearr_66915_66981 = state_66891__$1;
(statearr_66915_66981[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (6))){
var state_66891__$1 = state_66891;
var statearr_66916_66982 = state_66891__$1;
(statearr_66916_66982[(2)] = null);

(statearr_66916_66982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (28))){
var inst_66850 = (state_66891[(10)]);
var state_66891__$1 = state_66891;
var statearr_66917_66983 = state_66891__$1;
(statearr_66917_66983[(2)] = inst_66850);

(statearr_66917_66983[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (25))){
var inst_66837 = (state_66891[(9)]);
var inst_66844 = (inst_66837 + (30000));
var state_66891__$1 = state_66891;
var statearr_66918_66984 = state_66891__$1;
(statearr_66918_66984[(2)] = inst_66844);

(statearr_66918_66984[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (34))){
var state_66891__$1 = state_66891;
var statearr_66919_66985 = state_66891__$1;
(statearr_66919_66985[(2)] = null);

(statearr_66919_66985[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (17))){
var inst_66807 = (state_66891[(19)]);
var inst_66831 = (state_66891[(2)]);
var state_66891__$1 = (function (){var statearr_66920 = state_66891;
(statearr_66920[(20)] = inst_66831);

return statearr_66920;
})();
if(cljs.core.truth_(inst_66807)){
var statearr_66921_66986 = state_66891__$1;
(statearr_66921_66986[(1)] = (18));

} else {
var statearr_66922_66987 = state_66891__$1;
(statearr_66922_66987[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (3))){
var inst_66889 = (state_66891[(2)]);
var state_66891__$1 = state_66891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66891__$1,inst_66889);
} else {
if((state_val_66892 === (12))){
var inst_66821 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_66891__$1 = state_66891;
var statearr_66923_66988 = state_66891__$1;
(statearr_66923_66988[(2)] = inst_66821);

(statearr_66923_66988[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (2))){
var _ = (function (){var statearr_66924 = state_66891;
(statearr_66924[(4)] = cljs.core.cons((5),(state_66891[(4)])));

return statearr_66924;
})();
var inst_66787 = (opts == null);
var state_66891__$1 = state_66891;
if(cljs.core.truth_(inst_66787)){
var statearr_66925_66989 = state_66891__$1;
(statearr_66925_66989[(1)] = (6));

} else {
var statearr_66926_66990 = state_66891__$1;
(statearr_66926_66990[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (23))){
var inst_66803 = (state_66891[(12)]);
var inst_66841 = (state_66891[(2)]);
var state_66891__$1 = (function (){var statearr_66927 = state_66891;
(statearr_66927[(21)] = inst_66841);

return statearr_66927;
})();
if(cljs.core.truth_(inst_66803)){
var statearr_66928_66991 = state_66891__$1;
(statearr_66928_66991[(1)] = (24));

} else {
var statearr_66929_66992 = state_66891__$1;
(statearr_66929_66992[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (35))){
var inst_66799 = (state_66891[(15)]);
var inst_66866 = (state_66891[(2)]);
var state_66891__$1 = (function (){var statearr_66930 = state_66891;
(statearr_66930[(17)] = inst_66866);

return statearr_66930;
})();
if(cljs.core.truth_(inst_66799)){
var statearr_66931_66993 = state_66891__$1;
(statearr_66931_66993[(1)] = (36));

} else {
var statearr_66932_66994 = state_66891__$1;
(statearr_66932_66994[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (19))){
var state_66891__$1 = state_66891;
var statearr_66933_66995 = state_66891__$1;
(statearr_66933_66995[(2)] = null);

(statearr_66933_66995[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (11))){
var inst_66807 = (state_66891[(19)]);
var inst_66810 = (state_66891[(22)]);
var inst_66817 = (state_66891[(23)]);
var inst_66817__$1 = (state_66891[(2)]);
var inst_66818 = fluree.db.graphdb.validate_ledger_name(inst_66817__$1,"ledger");
var inst_66819 = fluree.db.graphdb.validate_ledger_name(inst_66810,"network");
var state_66891__$1 = (function (){var statearr_66935 = state_66891;
(statearr_66935[(24)] = inst_66818);

(statearr_66935[(23)] = inst_66817__$1);

(statearr_66935[(25)] = inst_66819);

return statearr_66935;
})();
if(cljs.core.truth_(inst_66807)){
var statearr_66936_66996 = state_66891__$1;
(statearr_66936_66996[(1)] = (12));

} else {
var statearr_66937_66997 = state_66891__$1;
(statearr_66937_66997[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (9))){
var inst_66811 = (state_66891[(26)]);
var inst_66814 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_66811,(1));
var state_66891__$1 = state_66891;
var statearr_66938_66998 = state_66891__$1;
(statearr_66938_66998[(2)] = inst_66814);

(statearr_66938_66998[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (5))){
var _ = (function (){var statearr_66939 = state_66891;
(statearr_66939[(4)] = cljs.core.rest((state_66891[(4)])));

return statearr_66939;
})();
var state_66891__$1 = state_66891;
var ex66934 = (state_66891__$1[(2)]);
var statearr_66940_66999 = state_66891__$1;
(statearr_66940_66999[(5)] = ex66934);


var statearr_66941_67000 = state_66891__$1;
(statearr_66941_67000[(1)] = (4));

(statearr_66941_67000[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (14))){
var inst_66807 = (state_66891[(19)]);
var inst_66824 = (state_66891[(2)]);
var inst_66825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66824,(0),null);
var inst_66826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66824,(1),null);
var state_66891__$1 = (function (){var statearr_66942 = state_66891;
(statearr_66942[(27)] = inst_66825);

(statearr_66942[(14)] = inst_66826);

return statearr_66942;
})();
if(cljs.core.truth_(inst_66807)){
var statearr_66943_67001 = state_66891__$1;
(statearr_66943_67001[(1)] = (15));

} else {
var statearr_66944_67002 = state_66891__$1;
(statearr_66944_67002[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (26))){
var inst_66806 = (state_66891[(28)]);
var inst_66836 = (state_66891[(8)]);
var inst_66841 = (state_66891[(21)]);
var inst_66804 = (state_66891[(29)]);
var inst_66810 = (state_66891[(22)]);
var inst_66798 = (state_66891[(30)]);
var inst_66805 = (state_66891[(11)]);
var inst_66800 = (state_66891[(31)]);
var inst_66817 = (state_66891[(23)]);
var inst_66801 = (state_66891[(32)]);
var inst_66808 = (state_66891[(33)]);
var inst_66796 = (state_66891[(34)]);
var inst_66802 = (state_66891[(35)]);
var inst_66846 = (state_66891[(2)]);
var inst_66847 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_66848 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66810),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66817)].join('');
var inst_66849 = [inst_66848,inst_66801,inst_66802,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_66846,inst_66804,inst_66836,inst_66808,inst_66806,inst_66796,inst_66841,inst_66798,inst_66800];
var inst_66850 = cljs.core.PersistentHashMap.fromArrays(inst_66847,inst_66849);
var state_66891__$1 = (function (){var statearr_66945 = state_66891;
(statearr_66945[(10)] = inst_66850);

return statearr_66945;
})();
if(cljs.core.truth_(inst_66805)){
var statearr_66946_67003 = state_66891__$1;
(statearr_66946_67003[(1)] = (27));

} else {
var statearr_66947_67004 = state_66891__$1;
(statearr_66947_67004[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (16))){
var state_66891__$1 = state_66891;
var statearr_66948_67005 = state_66891__$1;
(statearr_66948_67005[(2)] = null);

(statearr_66948_67005[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (38))){
var inst_66881 = (state_66891[(2)]);
var inst_66882 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66883 = [(200),inst_66881];
var inst_66884 = cljs.core.PersistentHashMap.fromArrays(inst_66882,inst_66883);
var inst_66885 = cljs.core.clj__GT_js(inst_66884);
var inst_66886 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66885) : resolve.call(null,inst_66885));
var _ = (function (){var statearr_66949 = state_66891;
(statearr_66949[(4)] = cljs.core.rest((state_66891[(4)])));

return statearr_66949;
})();
var state_66891__$1 = state_66891;
var statearr_66950_67006 = state_66891__$1;
(statearr_66950_67006[(2)] = inst_66886);

(statearr_66950_67006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (30))){
var inst_66855 = (state_66891[(18)]);
var inst_66857 = fluree.db.util.core.without_nils(inst_66855);
var inst_66858 = fluree.db.util.json.stringify(inst_66857);
var state_66891__$1 = state_66891;
var statearr_66951_67007 = state_66891__$1;
(statearr_66951_67007[(2)] = inst_66858);

(statearr_66951_67007[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (10))){
var inst_66811 = (state_66891[(26)]);
var state_66891__$1 = state_66891;
var statearr_66952_67008 = state_66891__$1;
(statearr_66952_67008[(2)] = inst_66811);

(statearr_66952_67008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (18))){
var inst_66825 = (state_66891[(27)]);
var inst_66826 = (state_66891[(14)]);
var inst_66833 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66825),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66826)].join('');
var state_66891__$1 = state_66891;
var statearr_66953_67009 = state_66891__$1;
(statearr_66953_67009[(2)] = inst_66833);

(statearr_66953_67009[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66892 === (37))){
var inst_66855 = (state_66891[(18)]);
var inst_66876 = fluree.db.operations.unsigned_command_async(conn,inst_66855);
var state_66891__$1 = state_66891;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66891__$1,(40),inst_66876);
} else {
if((state_val_66892 === (8))){
var inst_66811 = (state_66891[(26)]);
var inst_66792 = (state_66891[(2)]);
var inst_66793 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66792);
var inst_66794 = cljs.core.__destructure_map(inst_66792);
var inst_66795 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66794,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_66797 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_66799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_66801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_66802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_66803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_66806 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_66807 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_66808 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66794,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_66809 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_66810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66809,(0),null);
var inst_66811__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66809,(1),null);
var inst_66812 = clojure.string.starts_with_QMARK_(inst_66811__$1,"$");
var state_66891__$1 = (function (){var statearr_66954 = state_66891;
(statearr_66954[(28)] = inst_66806);

(statearr_66954[(26)] = inst_66811__$1);

(statearr_66954[(29)] = inst_66804);

(statearr_66954[(7)] = inst_66797);

(statearr_66954[(36)] = inst_66793);

(statearr_66954[(19)] = inst_66807);

(statearr_66954[(22)] = inst_66810);

(statearr_66954[(15)] = inst_66799);

(statearr_66954[(12)] = inst_66803);

(statearr_66954[(30)] = inst_66798);

(statearr_66954[(11)] = inst_66805);

(statearr_66954[(37)] = inst_66795);

(statearr_66954[(31)] = inst_66800);

(statearr_66954[(32)] = inst_66801);

(statearr_66954[(33)] = inst_66808);

(statearr_66954[(34)] = inst_66796);

(statearr_66954[(35)] = inst_66802);

return statearr_66954;
})();
if(inst_66812){
var statearr_66955_67010 = state_66891__$1;
(statearr_66955_67010[(1)] = (9));

} else {
var statearr_66956_67011 = state_66891__$1;
(statearr_66956_67011[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_66957 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66957[(0)] = flureedb$state_machine__2727__auto__);

(statearr_66957[(1)] = (1));

return statearr_66957;
});
var flureedb$state_machine__2727__auto____1 = (function (state_66891){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66891);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66958){var ex__2730__auto__ = e66958;
var statearr_66959_67012 = state_66891;
(statearr_66959_67012[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66891[(4)]))){
var statearr_66960_67013 = state_66891;
(statearr_66960_67013[(1)] = cljs.core.first((state_66891[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67014 = state_66891;
state_66891 = G__67014;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_66891){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_66891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66961 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66961[(6)] = c__2749__auto__);

return statearr_66961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67034){
var state_val_67035 = (state_67034[(1)]);
if((state_val_67035 === (1))){
var state_67034__$1 = state_67034;
var statearr_67036_67052 = state_67034__$1;
(statearr_67036_67052[(2)] = null);

(statearr_67036_67052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67035 === (2))){
var _ = (function (){var statearr_67037 = state_67034;
(statearr_67037[(4)] = cljs.core.cons((5),(state_67034[(4)])));

return statearr_67037;
})();
var inst_67024 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_67025 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_67034__$1 = (function (){var statearr_67038 = state_67034;
(statearr_67038[(7)] = inst_67024);

return statearr_67038;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67034__$1,(6),inst_67025);
} else {
if((state_val_67035 === (3))){
var inst_67032 = (state_67034[(2)]);
var state_67034__$1 = state_67034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67034__$1,inst_67032);
} else {
if((state_val_67035 === (4))){
var inst_67015 = (state_67034[(2)]);
var inst_67016 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67015], 0));
var inst_67017 = cljs.core.clj__GT_js(inst_67015);
var inst_67018 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67017) : reject.call(null,inst_67017));
var state_67034__$1 = (function (){var statearr_67040 = state_67034;
(statearr_67040[(8)] = inst_67016);

return statearr_67040;
})();
var statearr_67041_67053 = state_67034__$1;
(statearr_67041_67053[(2)] = inst_67018);

(statearr_67041_67053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67035 === (5))){
var _ = (function (){var statearr_67042 = state_67034;
(statearr_67042[(4)] = cljs.core.rest((state_67034[(4)])));

return statearr_67042;
})();
var state_67034__$1 = state_67034;
var ex67039 = (state_67034__$1[(2)]);
var statearr_67043_67054 = state_67034__$1;
(statearr_67043_67054[(5)] = ex67039);


var statearr_67044_67055 = state_67034__$1;
(statearr_67044_67055[(1)] = (4));

(statearr_67044_67055[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67035 === (6))){
var inst_67027 = (state_67034[(2)]);
var inst_67028 = cljs.core.clj__GT_js(inst_67027);
var inst_67029 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67028) : resolve.call(null,inst_67028));
var _ = (function (){var statearr_67045 = state_67034;
(statearr_67045[(4)] = cljs.core.rest((state_67034[(4)])));

return statearr_67045;
})();
var state_67034__$1 = state_67034;
var statearr_67046_67056 = state_67034__$1;
(statearr_67046_67056[(2)] = inst_67029);

(statearr_67046_67056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2727__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_67047 = [null,null,null,null,null,null,null,null,null];
(statearr_67047[(0)] = flureedb$monitor_tx_$_state_machine__2727__auto__);

(statearr_67047[(1)] = (1));

return statearr_67047;
});
var flureedb$monitor_tx_$_state_machine__2727__auto____1 = (function (state_67034){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67034);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67048){var ex__2730__auto__ = e67048;
var statearr_67049_67057 = state_67034;
(statearr_67049_67057[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67034[(4)]))){
var statearr_67050_67058 = state_67034;
(statearr_67050_67058[(1)] = cljs.core.first((state_67034[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67059 = state_67034;
state_67034 = G__67059;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2727__auto__ = function(state_67034){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2727__auto____1.call(this,state_67034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2727__auto____0;
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2727__auto____1;
return flureedb$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67051 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67051[(6)] = c__2749__auto__);

return statearr_67051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__67061 = arguments.length;
switch (G__67061) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67087){
var state_val_67088 = (state_67087[(1)]);
if((state_val_67088 === (7))){
var inst_67073 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67087__$1 = state_67087;
var statearr_67089_67110 = state_67087__$1;
(statearr_67089_67110[(2)] = inst_67073);

(statearr_67089_67110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67088 === (1))){
var state_67087__$1 = state_67087;
var statearr_67090_67111 = state_67087__$1;
(statearr_67090_67111[(2)] = null);

(statearr_67090_67111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67088 === (4))){
var inst_67062 = (state_67087[(2)]);
var inst_67063 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67062], 0));
var inst_67064 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67062) : reject.call(null,inst_67062));
var state_67087__$1 = (function (){var statearr_67091 = state_67087;
(statearr_67091[(7)] = inst_67063);

return statearr_67091;
})();
var statearr_67092_67112 = state_67087__$1;
(statearr_67092_67112[(2)] = inst_67064);

(statearr_67092_67112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67088 === (6))){
var state_67087__$1 = state_67087;
var statearr_67093_67113 = state_67087__$1;
(statearr_67093_67113[(2)] = null);

(statearr_67093_67113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67088 === (3))){
var inst_67085 = (state_67087[(2)]);
var state_67087__$1 = state_67087;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67087__$1,inst_67085);
} else {
if((state_val_67088 === (2))){
var _ = (function (){var statearr_67095 = state_67087;
(statearr_67095[(4)] = cljs.core.cons((5),(state_67087[(4)])));

return statearr_67095;
})();
var inst_67070 = (opts == null);
var state_67087__$1 = state_67087;
if(cljs.core.truth_(inst_67070)){
var statearr_67096_67114 = state_67087__$1;
(statearr_67096_67114[(1)] = (6));

} else {
var statearr_67097_67115 = state_67087__$1;
(statearr_67097_67115[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67088 === (9))){
var inst_67080 = (state_67087[(2)]);
var inst_67081 = cljs.core.clj__GT_js(inst_67080);
var inst_67082 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67081) : resolve.call(null,inst_67081));
var _ = (function (){var statearr_67098 = state_67087;
(statearr_67098[(4)] = cljs.core.rest((state_67087[(4)])));

return statearr_67098;
})();
var state_67087__$1 = state_67087;
var statearr_67099_67116 = state_67087__$1;
(statearr_67099_67116[(2)] = inst_67082);

(statearr_67099_67116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67088 === (5))){
var _ = (function (){var statearr_67100 = state_67087;
(statearr_67100[(4)] = cljs.core.rest((state_67087[(4)])));

return statearr_67100;
})();
var state_67087__$1 = state_67087;
var ex67094 = (state_67087__$1[(2)]);
var statearr_67101_67117 = state_67087__$1;
(statearr_67101_67117[(5)] = ex67094);


var statearr_67102_67118 = state_67087__$1;
(statearr_67102_67118[(1)] = (4));

(statearr_67102_67118[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67088 === (8))){
var inst_67075 = (state_67087[(2)]);
var inst_67076 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67075);
var inst_67077 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67078 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67077,inst_67075);
var state_67087__$1 = (function (){var statearr_67103 = state_67087;
(statearr_67103[(8)] = inst_67076);

return statearr_67103;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67087__$1,(9),inst_67078);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_67104 = [null,null,null,null,null,null,null,null,null];
(statearr_67104[(0)] = flureedb$state_machine__2727__auto__);

(statearr_67104[(1)] = (1));

return statearr_67104;
});
var flureedb$state_machine__2727__auto____1 = (function (state_67087){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67087);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67105){var ex__2730__auto__ = e67105;
var statearr_67106_67119 = state_67087;
(statearr_67106_67119[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67087[(4)]))){
var statearr_67107_67120 = state_67087;
(statearr_67107_67120[(1)] = cljs.core.first((state_67087[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67121 = state_67087;
state_67087 = G__67121;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_67087){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_67087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67108 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67108[(6)] = c__2749__auto__);

return statearr_67108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__67123 = arguments.length;
switch (G__67123) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67152){
var state_val_67153 = (state_67152[(1)]);
if((state_val_67153 === (7))){
var inst_67135 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67152__$1 = state_67152;
var statearr_67154_67175 = state_67152__$1;
(statearr_67154_67175[(2)] = inst_67135);

(statearr_67154_67175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67153 === (1))){
var state_67152__$1 = state_67152;
var statearr_67155_67176 = state_67152__$1;
(statearr_67155_67176[(2)] = null);

(statearr_67155_67176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67153 === (4))){
var inst_67124 = (state_67152[(2)]);
var inst_67125 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67124], 0));
var inst_67126 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67124) : reject.call(null,inst_67124));
var state_67152__$1 = (function (){var statearr_67156 = state_67152;
(statearr_67156[(7)] = inst_67125);

return statearr_67156;
})();
var statearr_67157_67177 = state_67152__$1;
(statearr_67157_67177[(2)] = inst_67126);

(statearr_67157_67177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67153 === (6))){
var state_67152__$1 = state_67152;
var statearr_67158_67178 = state_67152__$1;
(statearr_67158_67178[(2)] = null);

(statearr_67158_67178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67153 === (3))){
var inst_67150 = (state_67152[(2)]);
var state_67152__$1 = state_67152;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67152__$1,inst_67150);
} else {
if((state_val_67153 === (2))){
var _ = (function (){var statearr_67160 = state_67152;
(statearr_67160[(4)] = cljs.core.cons((5),(state_67152[(4)])));

return statearr_67160;
})();
var inst_67132 = (opts == null);
var state_67152__$1 = state_67152;
if(cljs.core.truth_(inst_67132)){
var statearr_67161_67179 = state_67152__$1;
(statearr_67161_67179[(1)] = (6));

} else {
var statearr_67162_67180 = state_67152__$1;
(statearr_67162_67180[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67153 === (9))){
var inst_67137 = (state_67152[(8)]);
var inst_67140 = (state_67152[(2)]);
var inst_67141 = fluree.db.util.async.throw_err(inst_67140);
var inst_67142 = fluree.db.query.block.block_range(inst_67141,start,end,inst_67137);
var state_67152__$1 = state_67152;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67152__$1,(10),inst_67142);
} else {
if((state_val_67153 === (5))){
var _ = (function (){var statearr_67163 = state_67152;
(statearr_67163[(4)] = cljs.core.rest((state_67152[(4)])));

return statearr_67163;
})();
var state_67152__$1 = state_67152;
var ex67159 = (state_67152__$1[(2)]);
var statearr_67164_67181 = state_67152__$1;
(statearr_67164_67181[(5)] = ex67159);


var statearr_67165_67182 = state_67152__$1;
(statearr_67165_67182[(1)] = (4));

(statearr_67165_67182[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67153 === (10))){
var inst_67144 = (state_67152[(2)]);
var inst_67145 = fluree.db.util.async.throw_err(inst_67144);
var inst_67146 = cljs.core.clj__GT_js(inst_67145);
var inst_67147 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67146) : resolve.call(null,inst_67146));
var _ = (function (){var statearr_67166 = state_67152;
(statearr_67166[(4)] = cljs.core.rest((state_67152[(4)])));

return statearr_67166;
})();
var state_67152__$1 = state_67152;
var statearr_67167_67183 = state_67152__$1;
(statearr_67167_67183[(2)] = inst_67147);

(statearr_67167_67183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67153 === (8))){
var inst_67137 = (state_67152[(8)]);
var inst_67137__$1 = (state_67152[(2)]);
var inst_67138 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67137__$1], 0));
var state_67152__$1 = (function (){var statearr_67168 = state_67152;
(statearr_67168[(8)] = inst_67137__$1);

return statearr_67168;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67152__$1,(9),inst_67138);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_67169 = [null,null,null,null,null,null,null,null,null];
(statearr_67169[(0)] = flureedb$state_machine__2727__auto__);

(statearr_67169[(1)] = (1));

return statearr_67169;
});
var flureedb$state_machine__2727__auto____1 = (function (state_67152){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67152);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67170){var ex__2730__auto__ = e67170;
var statearr_67171_67184 = state_67152;
(statearr_67171_67184[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67152[(4)]))){
var statearr_67172_67185 = state_67152;
(statearr_67172_67185[(1)] = cljs.core.first((state_67152[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67186 = state_67152;
state_67152 = G__67186;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_67152){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_67152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67173 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67173[(6)] = c__2749__auto__);

return statearr_67173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__67188 = arguments.length;
switch (G__67188) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67223){
var state_val_67224 = (state_67223[(1)]);
if((state_val_67224 === (7))){
var inst_67201 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67223__$1 = state_67223;
var statearr_67225_67246 = state_67223__$1;
(statearr_67225_67246[(2)] = inst_67201);

(statearr_67225_67246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67224 === (1))){
var state_67223__$1 = state_67223;
var statearr_67226_67247 = state_67223__$1;
(statearr_67226_67247[(2)] = null);

(statearr_67226_67247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67224 === (4))){
var inst_67189 = (state_67223[(2)]);
var inst_67190 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67189], 0));
var inst_67191 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67189) : reject.call(null,inst_67189));
var state_67223__$1 = (function (){var statearr_67227 = state_67223;
(statearr_67227[(7)] = inst_67190);

return statearr_67227;
})();
var statearr_67228_67248 = state_67223__$1;
(statearr_67228_67248[(2)] = inst_67191);

(statearr_67228_67248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67224 === (6))){
var state_67223__$1 = state_67223;
var statearr_67229_67249 = state_67223__$1;
(statearr_67229_67249[(2)] = null);

(statearr_67229_67249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67224 === (3))){
var inst_67221 = (state_67223[(2)]);
var state_67223__$1 = state_67223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67223__$1,inst_67221);
} else {
if((state_val_67224 === (2))){
var _ = (function (){var statearr_67231 = state_67223;
(statearr_67231[(4)] = cljs.core.cons((5),(state_67223[(4)])));

return statearr_67231;
})();
var inst_67198 = (opts == null);
var state_67223__$1 = state_67223;
if(cljs.core.truth_(inst_67198)){
var statearr_67232_67250 = state_67223__$1;
(statearr_67232_67250[(1)] = (6));

} else {
var statearr_67233_67251 = state_67223__$1;
(statearr_67233_67251[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67224 === (9))){
var inst_67206 = (state_67223[(8)]);
var inst_67207 = (state_67223[(9)]);
var inst_67203 = (state_67223[(10)]);
var inst_67210 = (state_67223[(2)]);
var inst_67211 = fluree.db.util.async.throw_err(inst_67210);
var inst_67212 = fluree.db.query.block.block_range(inst_67211,inst_67206,inst_67207,inst_67203);
var state_67223__$1 = state_67223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67223__$1,(10),inst_67212);
} else {
if((state_val_67224 === (5))){
var _ = (function (){var statearr_67234 = state_67223;
(statearr_67234[(4)] = cljs.core.rest((state_67223[(4)])));

return statearr_67234;
})();
var state_67223__$1 = state_67223;
var ex67230 = (state_67223__$1[(2)]);
var statearr_67235_67252 = state_67223__$1;
(statearr_67235_67252[(5)] = ex67230);


var statearr_67236_67253 = state_67223__$1;
(statearr_67236_67253[(1)] = (4));

(statearr_67236_67253[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67224 === (10))){
var inst_67214 = (state_67223[(2)]);
var inst_67215 = fluree.db.util.async.throw_err(inst_67214);
var inst_67216 = fluree.db.query.range.block_with_tx_data(inst_67215);
var inst_67217 = cljs.core.clj__GT_js(inst_67216);
var inst_67218 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67217) : resolve.call(null,inst_67217));
var _ = (function (){var statearr_67237 = state_67223;
(statearr_67237[(4)] = cljs.core.rest((state_67223[(4)])));

return statearr_67237;
})();
var state_67223__$1 = state_67223;
var statearr_67238_67254 = state_67223__$1;
(statearr_67238_67254[(2)] = inst_67218);

(statearr_67238_67254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67224 === (8))){
var inst_67203 = (state_67223[(10)]);
var inst_67203__$1 = (state_67223[(2)]);
var inst_67204 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67205 = cljs.core.__destructure_map(inst_67204);
var inst_67206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67205,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_67207 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67205,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_67208 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67203__$1], 0));
var state_67223__$1 = (function (){var statearr_67239 = state_67223;
(statearr_67239[(8)] = inst_67206);

(statearr_67239[(9)] = inst_67207);

(statearr_67239[(10)] = inst_67203__$1);

return statearr_67239;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67223__$1,(9),inst_67208);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_67240 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_67240[(0)] = flureedb$state_machine__2727__auto__);

(statearr_67240[(1)] = (1));

return statearr_67240;
});
var flureedb$state_machine__2727__auto____1 = (function (state_67223){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67223);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67241){var ex__2730__auto__ = e67241;
var statearr_67242_67255 = state_67223;
(statearr_67242_67255[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67223[(4)]))){
var statearr_67243_67256 = state_67223;
(statearr_67243_67256[(1)] = cljs.core.first((state_67223[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67257 = state_67223;
state_67223 = G__67257;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_67223){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_67223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67244 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67244[(6)] = c__2749__auto__);

return statearr_67244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__67259 = arguments.length;
switch (G__67259) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67326){
var state_val_67327 = (state_67326[(1)]);
if((state_val_67327 === (7))){
var inst_67272 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67326__$1 = state_67326;
var statearr_67328_67369 = state_67326__$1;
(statearr_67328_67369[(2)] = inst_67272);

(statearr_67328_67369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (20))){
var inst_67274 = (state_67326[(7)]);
var inst_67268 = (state_67326[(8)]);
var inst_67310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67311 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_67312 = (new cljs.core.PersistentVector(null,1,(5),inst_67310,inst_67311,null));
var inst_67313 = cljs.core.assoc_in(inst_67274,inst_67312,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67314 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67268,inst_67313);
var state_67326__$1 = state_67326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67326__$1,(23),inst_67314);
} else {
if((state_val_67327 === (1))){
var state_67326__$1 = state_67326;
var statearr_67329_67370 = state_67326__$1;
(statearr_67329_67370[(2)] = null);

(statearr_67329_67370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (4))){
var inst_67260 = (state_67326[(2)]);
var inst_67261 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67260], 0));
var inst_67262 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67260) : reject.call(null,inst_67260));
var state_67326__$1 = (function (){var statearr_67330 = state_67326;
(statearr_67330[(9)] = inst_67261);

return statearr_67330;
})();
var statearr_67331_67371 = state_67326__$1;
(statearr_67331_67371[(2)] = inst_67262);

(statearr_67331_67371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (15))){
var inst_67298 = (state_67326[(2)]);
var inst_67299 = fluree.db.util.async.throw_err(inst_67298);
var state_67326__$1 = state_67326;
var statearr_67332_67372 = state_67326__$1;
(statearr_67332_67372[(2)] = inst_67299);

(statearr_67332_67372[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (21))){
var inst_67319 = (state_67326[(2)]);
var inst_67320 = cljs.core.clj__GT_js(inst_67319);
var inst_67321 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67320) : resolve.call(null,inst_67320));
var _ = (function (){var statearr_67333 = state_67326;
(statearr_67333[(4)] = cljs.core.rest((state_67326[(4)])));

return statearr_67333;
})();
var state_67326__$1 = state_67326;
var statearr_67334_67373 = state_67326__$1;
(statearr_67334_67373[(2)] = inst_67321);

(statearr_67334_67373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (13))){
var state_67326__$1 = state_67326;
var statearr_67335_67374 = state_67326__$1;
(statearr_67335_67374[(2)] = null);

(statearr_67335_67374[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (22))){
var inst_67307 = (state_67326[(2)]);
var inst_67308 = fluree.db.util.async.throw_err(inst_67307);
var state_67326__$1 = state_67326;
var statearr_67336_67375 = state_67326__$1;
(statearr_67336_67375[(2)] = inst_67308);

(statearr_67336_67375[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (6))){
var state_67326__$1 = state_67326;
var statearr_67337_67376 = state_67326__$1;
(statearr_67337_67376[(2)] = null);

(statearr_67337_67376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (17))){
var state_67326__$1 = state_67326;
var statearr_67338_67377 = state_67326__$1;
(statearr_67338_67377[(2)] = null);

(statearr_67338_67377[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (3))){
var inst_67324 = (state_67326[(2)]);
var state_67326__$1 = state_67326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67326__$1,inst_67324);
} else {
if((state_val_67327 === (12))){
var inst_67282 = (state_67326[(10)]);
var inst_67286 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_67326__$1 = (function (){var statearr_67339 = state_67326;
(statearr_67339[(11)] = inst_67286);

return statearr_67339;
})();
if(cljs.core.truth_(inst_67282)){
var statearr_67340_67378 = state_67326__$1;
(statearr_67340_67378[(1)] = (16));

} else {
var statearr_67341_67379 = state_67326__$1;
(statearr_67341_67379[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (2))){
var _ = (function (){var statearr_67342 = state_67326;
(statearr_67342[(4)] = cljs.core.cons((5),(state_67326[(4)])));

return statearr_67342;
})();
var inst_67268 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67269 = (opts == null);
var state_67326__$1 = (function (){var statearr_67343 = state_67326;
(statearr_67343[(8)] = inst_67268);

return statearr_67343;
})();
if(cljs.core.truth_(inst_67269)){
var statearr_67344_67380 = state_67326__$1;
(statearr_67344_67380[(1)] = (6));

} else {
var statearr_67345_67381 = state_67326__$1;
(statearr_67345_67381[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (23))){
var inst_67316 = (state_67326[(2)]);
var inst_67317 = fluree.db.util.async.throw_err(inst_67316);
var state_67326__$1 = state_67326;
var statearr_67346_67382 = state_67326__$1;
(statearr_67346_67382[(2)] = inst_67317);

(statearr_67346_67382[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (19))){
var inst_67274 = (state_67326[(7)]);
var inst_67302 = (state_67326[(12)]);
var inst_67268 = (state_67326[(8)]);
var inst_67305 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_67302,inst_67268,inst_67274);
var state_67326__$1 = state_67326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67326__$1,(22),inst_67305);
} else {
if((state_val_67327 === (11))){
var inst_67276 = (state_67326[(13)]);
var inst_67274 = (state_67326[(7)]);
var inst_67282 = (state_67326[(2)]);
var inst_67283 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_67274);
var inst_67284 = (inst_67276 == null);
var state_67326__$1 = (function (){var statearr_67348 = state_67326;
(statearr_67348[(10)] = inst_67282);

(statearr_67348[(14)] = inst_67283);

return statearr_67348;
})();
if(cljs.core.truth_(inst_67284)){
var statearr_67349_67383 = state_67326__$1;
(statearr_67349_67383[(1)] = (12));

} else {
var statearr_67350_67384 = state_67326__$1;
(statearr_67350_67384[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (9))){
var inst_67277 = (state_67326[(15)]);
var state_67326__$1 = state_67326;
var statearr_67351_67385 = state_67326__$1;
(statearr_67351_67385[(2)] = inst_67277);

(statearr_67351_67385[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (5))){
var _ = (function (){var statearr_67352 = state_67326;
(statearr_67352[(4)] = cljs.core.rest((state_67326[(4)])));

return statearr_67352;
})();
var state_67326__$1 = state_67326;
var ex67347 = (state_67326__$1[(2)]);
var statearr_67353_67386 = state_67326__$1;
(statearr_67353_67386[(5)] = ex67347);


var statearr_67354_67387 = state_67326__$1;
(statearr_67354_67387[(1)] = (4));

(statearr_67354_67387[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (14))){
var inst_67276 = (state_67326[(13)]);
var inst_67302 = (state_67326[(2)]);
var inst_67303 = (inst_67276 == null);
var state_67326__$1 = (function (){var statearr_67355 = state_67326;
(statearr_67355[(12)] = inst_67302);

return statearr_67355;
})();
if(cljs.core.truth_(inst_67303)){
var statearr_67356_67388 = state_67326__$1;
(statearr_67356_67388[(1)] = (19));

} else {
var statearr_67357_67389 = state_67326__$1;
(statearr_67357_67389[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (16))){
var inst_67282 = (state_67326[(10)]);
var inst_67288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67289 = ["_auth/id",inst_67282];
var inst_67290 = (new cljs.core.PersistentVector(null,2,(5),inst_67288,inst_67289,null));
var state_67326__$1 = state_67326;
var statearr_67358_67390 = state_67326__$1;
(statearr_67358_67390[(2)] = inst_67290);

(statearr_67358_67390[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (10))){
var inst_67274 = (state_67326[(7)]);
var inst_67280 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67274);
var state_67326__$1 = state_67326;
var statearr_67359_67391 = state_67326__$1;
(statearr_67359_67391[(2)] = inst_67280);

(statearr_67359_67391[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67327 === (18))){
var inst_67286 = (state_67326[(11)]);
var inst_67283 = (state_67326[(14)]);
var inst_67293 = (state_67326[(2)]);
var inst_67294 = [inst_67293,inst_67283];
var inst_67295 = cljs.core.PersistentHashMap.fromArrays(inst_67286,inst_67294);
var inst_67296 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67295], 0));
var state_67326__$1 = state_67326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67326__$1,(15),inst_67296);
} else {
if((state_val_67327 === (8))){
var inst_67277 = (state_67326[(15)]);
var inst_67274 = (state_67326[(7)]);
var inst_67274__$1 = (state_67326[(2)]);
var inst_67275 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67274__$1);
var inst_67276 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_67274__$1);
var inst_67277__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_67274__$1);
var state_67326__$1 = (function (){var statearr_67360 = state_67326;
(statearr_67360[(15)] = inst_67277__$1);

(statearr_67360[(13)] = inst_67276);

(statearr_67360[(7)] = inst_67274__$1);

(statearr_67360[(16)] = inst_67275);

return statearr_67360;
})();
if(cljs.core.truth_(inst_67277__$1)){
var statearr_67361_67392 = state_67326__$1;
(statearr_67361_67392[(1)] = (9));

} else {
var statearr_67362_67393 = state_67326__$1;
(statearr_67362_67393[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_67363 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67363[(0)] = flureedb$state_machine__2727__auto__);

(statearr_67363[(1)] = (1));

return statearr_67363;
});
var flureedb$state_machine__2727__auto____1 = (function (state_67326){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67326);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67364){var ex__2730__auto__ = e67364;
var statearr_67365_67394 = state_67326;
(statearr_67365_67394[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67326[(4)]))){
var statearr_67366_67395 = state_67326;
(statearr_67366_67395[(1)] = cljs.core.first((state_67326[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67396 = state_67326;
state_67326 = G__67396;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_67326){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_67326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67367 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67367[(6)] = c__2749__auto__);

return statearr_67367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67416){
var state_val_67417 = (state_67416[(1)]);
if((state_val_67417 === (1))){
var state_67416__$1 = state_67416;
var statearr_67418_67433 = state_67416__$1;
(statearr_67418_67433[(2)] = null);

(statearr_67418_67433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (2))){
var _ = (function (){var statearr_67419 = state_67416;
(statearr_67419[(4)] = cljs.core.cons((5),(state_67416[(4)])));

return statearr_67419;
})();
var inst_67405 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67406 = fluree.db.api.query.history_query_async(sources,inst_67405);
var state_67416__$1 = state_67416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67416__$1,(6),inst_67406);
} else {
if((state_val_67417 === (3))){
var inst_67414 = (state_67416[(2)]);
var state_67416__$1 = state_67416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67416__$1,inst_67414);
} else {
if((state_val_67417 === (4))){
var inst_67397 = (state_67416[(2)]);
var inst_67398 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67397], 0));
var inst_67399 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67397) : reject.call(null,inst_67397));
var state_67416__$1 = (function (){var statearr_67421 = state_67416;
(statearr_67421[(7)] = inst_67398);

return statearr_67421;
})();
var statearr_67422_67434 = state_67416__$1;
(statearr_67422_67434[(2)] = inst_67399);

(statearr_67422_67434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (5))){
var _ = (function (){var statearr_67423 = state_67416;
(statearr_67423[(4)] = cljs.core.rest((state_67416[(4)])));

return statearr_67423;
})();
var state_67416__$1 = state_67416;
var ex67420 = (state_67416__$1[(2)]);
var statearr_67424_67435 = state_67416__$1;
(statearr_67424_67435[(5)] = ex67420);


var statearr_67425_67436 = state_67416__$1;
(statearr_67425_67436[(1)] = (4));

(statearr_67425_67436[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (6))){
var inst_67408 = (state_67416[(2)]);
var inst_67409 = fluree.db.util.async.throw_err(inst_67408);
var inst_67410 = cljs.core.clj__GT_js(inst_67409);
var inst_67411 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67410) : resolve.call(null,inst_67410));
var _ = (function (){var statearr_67426 = state_67416;
(statearr_67426[(4)] = cljs.core.rest((state_67416[(4)])));

return statearr_67426;
})();
var state_67416__$1 = state_67416;
var statearr_67427_67437 = state_67416__$1;
(statearr_67427_67437[(2)] = inst_67411);

(statearr_67427_67437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2727__auto__ = null;
var flureedb$history_query_$_state_machine__2727__auto____0 = (function (){
var statearr_67428 = [null,null,null,null,null,null,null,null];
(statearr_67428[(0)] = flureedb$history_query_$_state_machine__2727__auto__);

(statearr_67428[(1)] = (1));

return statearr_67428;
});
var flureedb$history_query_$_state_machine__2727__auto____1 = (function (state_67416){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67416);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67429){var ex__2730__auto__ = e67429;
var statearr_67430_67438 = state_67416;
(statearr_67430_67438[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67416[(4)]))){
var statearr_67431_67439 = state_67416;
(statearr_67431_67439[(1)] = cljs.core.first((state_67416[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67440 = state_67416;
state_67416 = G__67440;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2727__auto__ = function(state_67416){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2727__auto____1.call(this,state_67416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2727__auto____0;
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2727__auto____1;
return flureedb$history_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67432 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67432[(6)] = c__2749__auto__);

return statearr_67432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67460){
var state_val_67461 = (state_67460[(1)]);
if((state_val_67461 === (1))){
var state_67460__$1 = state_67460;
var statearr_67462_67477 = state_67460__$1;
(statearr_67462_67477[(2)] = null);

(statearr_67462_67477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67461 === (2))){
var _ = (function (){var statearr_67463 = state_67460;
(statearr_67463[(4)] = cljs.core.cons((5),(state_67460[(4)])));

return statearr_67463;
})();
var inst_67449 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67450 = fluree.db.api.query.multi_query_async(sources,inst_67449);
var state_67460__$1 = state_67460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67460__$1,(6),inst_67450);
} else {
if((state_val_67461 === (3))){
var inst_67458 = (state_67460[(2)]);
var state_67460__$1 = state_67460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67460__$1,inst_67458);
} else {
if((state_val_67461 === (4))){
var inst_67441 = (state_67460[(2)]);
var inst_67442 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67441], 0));
var inst_67443 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67441) : reject.call(null,inst_67441));
var state_67460__$1 = (function (){var statearr_67465 = state_67460;
(statearr_67465[(7)] = inst_67442);

return statearr_67465;
})();
var statearr_67466_67478 = state_67460__$1;
(statearr_67466_67478[(2)] = inst_67443);

(statearr_67466_67478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67461 === (5))){
var _ = (function (){var statearr_67467 = state_67460;
(statearr_67467[(4)] = cljs.core.rest((state_67460[(4)])));

return statearr_67467;
})();
var state_67460__$1 = state_67460;
var ex67464 = (state_67460__$1[(2)]);
var statearr_67468_67479 = state_67460__$1;
(statearr_67468_67479[(5)] = ex67464);


var statearr_67469_67480 = state_67460__$1;
(statearr_67469_67480[(1)] = (4));

(statearr_67469_67480[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67461 === (6))){
var inst_67452 = (state_67460[(2)]);
var inst_67453 = fluree.db.util.async.throw_err(inst_67452);
var inst_67454 = cljs.core.clj__GT_js(inst_67453);
var inst_67455 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67454) : resolve.call(null,inst_67454));
var _ = (function (){var statearr_67470 = state_67460;
(statearr_67470[(4)] = cljs.core.rest((state_67460[(4)])));

return statearr_67470;
})();
var state_67460__$1 = state_67460;
var statearr_67471_67481 = state_67460__$1;
(statearr_67471_67481[(2)] = inst_67455);

(statearr_67471_67481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2727__auto__ = null;
var flureedb$multi_query_$_state_machine__2727__auto____0 = (function (){
var statearr_67472 = [null,null,null,null,null,null,null,null];
(statearr_67472[(0)] = flureedb$multi_query_$_state_machine__2727__auto__);

(statearr_67472[(1)] = (1));

return statearr_67472;
});
var flureedb$multi_query_$_state_machine__2727__auto____1 = (function (state_67460){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67460);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67473){var ex__2730__auto__ = e67473;
var statearr_67474_67482 = state_67460;
(statearr_67474_67482[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67460[(4)]))){
var statearr_67475_67483 = state_67460;
(statearr_67475_67483[(1)] = cljs.core.first((state_67460[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67484 = state_67460;
state_67460 = G__67484;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2727__auto__ = function(state_67460){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2727__auto____1.call(this,state_67460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2727__auto____0;
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2727__auto____1;
return flureedb$multi_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67476 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67476[(6)] = c__2749__auto__);

return statearr_67476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67504){
var state_val_67505 = (state_67504[(1)]);
if((state_val_67505 === (1))){
var state_67504__$1 = state_67504;
var statearr_67506_67521 = state_67504__$1;
(statearr_67506_67521[(2)] = null);

(statearr_67506_67521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67505 === (2))){
var _ = (function (){var statearr_67507 = state_67504;
(statearr_67507[(4)] = cljs.core.cons((5),(state_67504[(4)])));

return statearr_67507;
})();
var inst_67494 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67495 = fluree.db.api.query.query_async(sources,inst_67494);
var state_67504__$1 = state_67504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67504__$1,(6),inst_67495);
} else {
if((state_val_67505 === (3))){
var inst_67502 = (state_67504[(2)]);
var state_67504__$1 = state_67504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67504__$1,inst_67502);
} else {
if((state_val_67505 === (4))){
var inst_67485 = (state_67504[(2)]);
var inst_67486 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67485], 0));
var inst_67487 = cljs.core.clj__GT_js(inst_67485);
var inst_67488 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67487) : reject.call(null,inst_67487));
var state_67504__$1 = (function (){var statearr_67509 = state_67504;
(statearr_67509[(7)] = inst_67486);

return statearr_67509;
})();
var statearr_67510_67522 = state_67504__$1;
(statearr_67510_67522[(2)] = inst_67488);

(statearr_67510_67522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67505 === (5))){
var _ = (function (){var statearr_67511 = state_67504;
(statearr_67511[(4)] = cljs.core.rest((state_67504[(4)])));

return statearr_67511;
})();
var state_67504__$1 = state_67504;
var ex67508 = (state_67504__$1[(2)]);
var statearr_67512_67523 = state_67504__$1;
(statearr_67512_67523[(5)] = ex67508);


var statearr_67513_67524 = state_67504__$1;
(statearr_67513_67524[(1)] = (4));

(statearr_67513_67524[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67505 === (6))){
var inst_67497 = (state_67504[(2)]);
var inst_67498 = cljs.core.clj__GT_js(inst_67497);
var inst_67499 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67498) : resolve.call(null,inst_67498));
var _ = (function (){var statearr_67514 = state_67504;
(statearr_67514[(4)] = cljs.core.rest((state_67504[(4)])));

return statearr_67514;
})();
var state_67504__$1 = state_67504;
var statearr_67515_67525 = state_67504__$1;
(statearr_67515_67525[(2)] = inst_67499);

(statearr_67515_67525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2727__auto__ = null;
var flureedb$query_$_state_machine__2727__auto____0 = (function (){
var statearr_67516 = [null,null,null,null,null,null,null,null];
(statearr_67516[(0)] = flureedb$query_$_state_machine__2727__auto__);

(statearr_67516[(1)] = (1));

return statearr_67516;
});
var flureedb$query_$_state_machine__2727__auto____1 = (function (state_67504){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67504);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67517){var ex__2730__auto__ = e67517;
var statearr_67518_67526 = state_67504;
(statearr_67518_67526[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67504[(4)]))){
var statearr_67519_67527 = state_67504;
(statearr_67519_67527[(1)] = cljs.core.first((state_67504[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67528 = state_67504;
state_67504 = G__67528;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2727__auto__ = function(state_67504){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2727__auto____1.call(this,state_67504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2727__auto____0;
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2727__auto____1;
return flureedb$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67520 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67520[(6)] = c__2749__auto__);

return statearr_67520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__67530 = arguments.length;
switch (G__67530) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67557){
var state_val_67558 = (state_67557[(1)]);
if((state_val_67558 === (7))){
var inst_67544 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67557__$1 = state_67557;
var statearr_67559_67580 = state_67557__$1;
(statearr_67559_67580[(2)] = inst_67544);

(statearr_67559_67580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (1))){
var state_67557__$1 = state_67557;
var statearr_67560_67581 = state_67557__$1;
(statearr_67560_67581[(2)] = null);

(statearr_67560_67581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (4))){
var inst_67531 = (state_67557[(2)]);
var inst_67532 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67531], 0));
var inst_67533 = cljs.core.clj__GT_js(inst_67531);
var inst_67534 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67533) : reject.call(null,inst_67533));
var state_67557__$1 = (function (){var statearr_67561 = state_67557;
(statearr_67561[(7)] = inst_67532);

return statearr_67561;
})();
var statearr_67562_67582 = state_67557__$1;
(statearr_67562_67582[(2)] = inst_67534);

(statearr_67562_67582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (6))){
var state_67557__$1 = state_67557;
var statearr_67563_67583 = state_67557__$1;
(statearr_67563_67583[(2)] = null);

(statearr_67563_67583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (3))){
var inst_67555 = (state_67557[(2)]);
var state_67557__$1 = state_67557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67557__$1,inst_67555);
} else {
if((state_val_67558 === (2))){
var _ = (function (){var statearr_67565 = state_67557;
(statearr_67565[(4)] = cljs.core.cons((5),(state_67557[(4)])));

return statearr_67565;
})();
var inst_67540 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67541 = (opts == null);
var state_67557__$1 = (function (){var statearr_67566 = state_67557;
(statearr_67566[(8)] = inst_67540);

return statearr_67566;
})();
if(cljs.core.truth_(inst_67541)){
var statearr_67567_67584 = state_67557__$1;
(statearr_67567_67584[(1)] = (6));

} else {
var statearr_67568_67585 = state_67557__$1;
(statearr_67568_67585[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (9))){
var inst_67549 = (state_67557[(2)]);
var inst_67550 = fluree.db.util.async.throw_err(inst_67549);
var inst_67551 = cljs.core.clj__GT_js(inst_67550);
var inst_67552 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67551) : resolve.call(null,inst_67551));
var _ = (function (){var statearr_67569 = state_67557;
(statearr_67569[(4)] = cljs.core.rest((state_67557[(4)])));

return statearr_67569;
})();
var state_67557__$1 = state_67557;
var statearr_67570_67586 = state_67557__$1;
(statearr_67570_67586[(2)] = inst_67552);

(statearr_67570_67586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (5))){
var _ = (function (){var statearr_67571 = state_67557;
(statearr_67571[(4)] = cljs.core.rest((state_67557[(4)])));

return statearr_67571;
})();
var state_67557__$1 = state_67557;
var ex67564 = (state_67557__$1[(2)]);
var statearr_67572_67587 = state_67557__$1;
(statearr_67572_67587[(5)] = ex67564);


var statearr_67573_67588 = state_67557__$1;
(statearr_67573_67588[(1)] = (4));

(statearr_67573_67588[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (8))){
var inst_67540 = (state_67557[(8)]);
var inst_67546 = (state_67557[(2)]);
var inst_67547 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67540,inst_67546);
var state_67557__$1 = state_67557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67557__$1,(9),inst_67547);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_67574 = [null,null,null,null,null,null,null,null,null];
(statearr_67574[(0)] = flureedb$state_machine__2727__auto__);

(statearr_67574[(1)] = (1));

return statearr_67574;
});
var flureedb$state_machine__2727__auto____1 = (function (state_67557){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67557);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67575){var ex__2730__auto__ = e67575;
var statearr_67576_67589 = state_67557;
(statearr_67576_67589[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67557[(4)]))){
var statearr_67577_67590 = state_67557;
(statearr_67577_67590[(1)] = cljs.core.first((state_67557[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67591 = state_67557;
state_67557 = G__67591;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_67557){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_67557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67578 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67578[(6)] = c__2749__auto__);

return statearr_67578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
