// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.call(null,"set websocket id:",ws_id);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.call(null,"process event:",event_type,event_data);

var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__13829 = cljs.core.seq.call(null,callbacks);
var chunk__13830 = null;
var count__13831 = (0);
var i__13832 = (0);
while(true){
if((i__13832 < count__13831)){
var vec__13841 = cljs.core._nth.call(null,chunk__13830,i__13832);
var k = cljs.core.nth.call(null,vec__13841,(0),null);
var f = cljs.core.nth.call(null,vec__13841,(1),null);
try{f.call(null,event_type,event_data);
}catch (e13844){var e_13849 = e13844;
fluree.db.util.log.error.call(null,e_13849,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__13850 = seq__13829;
var G__13851 = chunk__13830;
var G__13852 = count__13831;
var G__13853 = (i__13832 + (1));
seq__13829 = G__13850;
chunk__13830 = G__13851;
count__13831 = G__13852;
i__13832 = G__13853;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__13829);
if(temp__5804__auto__){
var seq__13829__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13829__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__13829__$1);
var G__13854 = cljs.core.chunk_rest.call(null,seq__13829__$1);
var G__13855 = c__5568__auto__;
var G__13856 = cljs.core.count.call(null,c__5568__auto__);
var G__13857 = (0);
seq__13829 = G__13854;
chunk__13830 = G__13855;
count__13831 = G__13856;
i__13832 = G__13857;
continue;
} else {
var vec__13845 = cljs.core.first.call(null,seq__13829__$1);
var k = cljs.core.nth.call(null,vec__13845,(0),null);
var f = cljs.core.nth.call(null,vec__13845,(1),null);
try{f.call(null,event_type,event_data);
}catch (e13848){var e_13858 = e13848;
fluree.db.util.log.error.call(null,e_13858,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__13859 = cljs.core.next.call(null,seq__13829__$1);
var G__13860 = null;
var G__13861 = (0);
var G__13862 = (0);
seq__13829 = G__13859;
chunk__13830 = G__13860;
count__13831 = G__13861;
i__13832 = G__13862;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__13865 = msg;
var event_type = cljs.core.nth.call(null,vec__13865,(0),null);
var subject = cljs.core.nth.call(null,vec__13865,(1),null);
var event_data = cljs.core.nth.call(null,vec__13865,(2),null);
var error_data = cljs.core.nth.call(null,vec__13865,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__13868 = conn;
var map__13868__$1 = cljs.core.__destructure_map.call(null,map__13868);
var state = cljs.core.get.call(null,map__13868__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__13869 = event_type__$1;
var G__13869__$1 = (((G__13869 instanceof cljs.core.Keyword))?G__13869.fqn:null);
switch (G__13869__$1) {
case "response":
var temp__5804__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5804__auto__)){
var res_chan = temp__5804__auto__;
fluree.db.util.log.trace.call(null,"Found response channel for subject",subject);

cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__13863_SHARP_){
return cljs.core.dissoc.call(null,p1__13863_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__13870 = error_data;
var map__13870__$1 = cljs.core.__destructure_map.call(null,map__13870);
var message = cljs.core.get.call(null,map__13870__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e13864){var e = e13864;
return fluree.db.util.log.error.call(null,e);
}});
