// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62111_62280 = cljs.core.seq.call(null,servers);
var chunk__62112_62281 = null;
var count__62113_62282 = (0);
var i__62114_62283 = (0);
while(true){
if((i__62114_62283 < count__62113_62282)){
var server_62284 = cljs.core._nth.call(null,chunk__62112_62281,i__62114_62283);
var healthcheck_uri_62285 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62284),"/fdb/health"].join('');
var resp_chan_62286 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_62285,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___62287 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62287,healthcheck_uri_62285,resp_chan_62286,server_62284){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62287,healthcheck_uri_62285,resp_chan_62286,server_62284){
return (function (state_62175){
var state_val_62176 = (state_62175[(1)]);
if((state_val_62176 === (1))){
var state_62175__$1 = state_62175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62175__$1,(2),resp_chan_62286);
} else {
if((state_val_62176 === (2))){
var inst_62164 = (state_62175[(7)]);
var inst_62164__$1 = (state_62175[(2)]);
var inst_62165 = fluree.db.util.core.exception_QMARK_.call(null,inst_62164__$1);
var state_62175__$1 = (function (){var statearr_62177 = state_62175;
(statearr_62177[(7)] = inst_62164__$1);

return statearr_62177;
})();
if(inst_62165){
var statearr_62178_62288 = state_62175__$1;
(statearr_62178_62288[(1)] = (3));

} else {
var statearr_62179_62289 = state_62175__$1;
(statearr_62179_62289[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62176 === (3))){
var inst_62164 = (state_62175[(7)]);
var inst_62167 = cljs.core.ex_message.call(null,inst_62164);
var inst_62168 = cljs.core.ex_data.call(null,inst_62164);
var inst_62169 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_62167,inst_62168);
var state_62175__$1 = state_62175;
var statearr_62180_62290 = state_62175__$1;
(statearr_62180_62290[(2)] = inst_62169);

(statearr_62180_62290[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62176 === (4))){
var inst_62171 = cljs.core.async.put_BANG_.call(null,promise_chan,server_62284);
var state_62175__$1 = state_62175;
var statearr_62181_62291 = state_62175__$1;
(statearr_62181_62291[(2)] = inst_62171);

(statearr_62181_62291[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62176 === (5))){
var inst_62173 = (state_62175[(2)]);
var state_62175__$1 = state_62175;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62175__$1,inst_62173);
} else {
return null;
}
}
}
}
}
});})(seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62287,healthcheck_uri_62285,resp_chan_62286,server_62284))
;
return ((function (seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,switch__2745__auto__,c__2768__auto___62287,healthcheck_uri_62285,resp_chan_62286,server_62284){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_62182 = [null,null,null,null,null,null,null,null];
(statearr_62182[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_62182[(1)] = (1));

return statearr_62182;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_62175){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62175);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62183){var ex__2749__auto__ = e62183;
var statearr_62184_62292 = state_62175;
(statearr_62184_62292[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62175[(4)]))){
var statearr_62185_62293 = state_62175;
(statearr_62185_62293[(1)] = cljs.core.first.call(null,(state_62175[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62294 = state_62175;
state_62175 = G__62294;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_62175){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_62175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,switch__2745__auto__,c__2768__auto___62287,healthcheck_uri_62285,resp_chan_62286,server_62284))
})();
var state__2770__auto__ = (function (){var statearr_62186 = f__2769__auto__.call(null);
(statearr_62186[(6)] = c__2768__auto___62287);

return statearr_62186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62287,healthcheck_uri_62285,resp_chan_62286,server_62284))
);



var G__62295 = seq__62111_62280;
var G__62296 = chunk__62112_62281;
var G__62297 = count__62113_62282;
var G__62298 = (i__62114_62283 + (1));
seq__62111_62280 = G__62295;
chunk__62112_62281 = G__62296;
count__62113_62282 = G__62297;
i__62114_62283 = G__62298;
continue;
} else {
var temp__5804__auto___62299 = cljs.core.seq.call(null,seq__62111_62280);
if(temp__5804__auto___62299){
var seq__62111_62300__$1 = temp__5804__auto___62299;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62111_62300__$1)){
var c__5568__auto___62301 = cljs.core.chunk_first.call(null,seq__62111_62300__$1);
var G__62302 = cljs.core.chunk_rest.call(null,seq__62111_62300__$1);
var G__62303 = c__5568__auto___62301;
var G__62304 = cljs.core.count.call(null,c__5568__auto___62301);
var G__62305 = (0);
seq__62111_62280 = G__62302;
chunk__62112_62281 = G__62303;
count__62113_62282 = G__62304;
i__62114_62283 = G__62305;
continue;
} else {
var server_62306 = cljs.core.first.call(null,seq__62111_62300__$1);
var healthcheck_uri_62307 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62306),"/fdb/health"].join('');
var resp_chan_62308 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_62307,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___62309 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62309,healthcheck_uri_62307,resp_chan_62308,server_62306,seq__62111_62300__$1,temp__5804__auto___62299){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62309,healthcheck_uri_62307,resp_chan_62308,server_62306,seq__62111_62300__$1,temp__5804__auto___62299){
return (function (state_62199){
var state_val_62200 = (state_62199[(1)]);
if((state_val_62200 === (1))){
var state_62199__$1 = state_62199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62199__$1,(2),resp_chan_62308);
} else {
if((state_val_62200 === (2))){
var inst_62188 = (state_62199[(7)]);
var inst_62188__$1 = (state_62199[(2)]);
var inst_62189 = fluree.db.util.core.exception_QMARK_.call(null,inst_62188__$1);
var state_62199__$1 = (function (){var statearr_62201 = state_62199;
(statearr_62201[(7)] = inst_62188__$1);

return statearr_62201;
})();
if(inst_62189){
var statearr_62202_62310 = state_62199__$1;
(statearr_62202_62310[(1)] = (3));

} else {
var statearr_62203_62311 = state_62199__$1;
(statearr_62203_62311[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62200 === (3))){
var inst_62188 = (state_62199[(7)]);
var inst_62191 = cljs.core.ex_message.call(null,inst_62188);
var inst_62192 = cljs.core.ex_data.call(null,inst_62188);
var inst_62193 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_62191,inst_62192);
var state_62199__$1 = state_62199;
var statearr_62204_62312 = state_62199__$1;
(statearr_62204_62312[(2)] = inst_62193);

(statearr_62204_62312[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62200 === (4))){
var inst_62195 = cljs.core.async.put_BANG_.call(null,promise_chan,server_62306);
var state_62199__$1 = state_62199;
var statearr_62205_62313 = state_62199__$1;
(statearr_62205_62313[(2)] = inst_62195);

(statearr_62205_62313[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62200 === (5))){
var inst_62197 = (state_62199[(2)]);
var state_62199__$1 = state_62199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62199__$1,inst_62197);
} else {
return null;
}
}
}
}
}
});})(seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62309,healthcheck_uri_62307,resp_chan_62308,server_62306,seq__62111_62300__$1,temp__5804__auto___62299))
;
return ((function (seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,switch__2745__auto__,c__2768__auto___62309,healthcheck_uri_62307,resp_chan_62308,server_62306,seq__62111_62300__$1,temp__5804__auto___62299){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_62206 = [null,null,null,null,null,null,null,null];
(statearr_62206[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_62206[(1)] = (1));

return statearr_62206;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_62199){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62207){var ex__2749__auto__ = e62207;
var statearr_62208_62314 = state_62199;
(statearr_62208_62314[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62199[(4)]))){
var statearr_62209_62315 = state_62199;
(statearr_62209_62315[(1)] = cljs.core.first.call(null,(state_62199[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62316 = state_62199;
state_62199 = G__62316;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_62199){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_62199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,switch__2745__auto__,c__2768__auto___62309,healthcheck_uri_62307,resp_chan_62308,server_62306,seq__62111_62300__$1,temp__5804__auto___62299))
})();
var state__2770__auto__ = (function (){var statearr_62210 = f__2769__auto__.call(null);
(statearr_62210[(6)] = c__2768__auto___62309);

return statearr_62210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__62111_62280,chunk__62112_62281,count__62113_62282,i__62114_62283,c__2768__auto___62309,healthcheck_uri_62307,resp_chan_62308,server_62306,seq__62111_62300__$1,temp__5804__auto___62299))
);



var G__62317 = cljs.core.next.call(null,seq__62111_62300__$1);
var G__62318 = null;
var G__62319 = (0);
var G__62320 = (0);
seq__62111_62280 = G__62317;
chunk__62112_62281 = G__62318;
count__62113_62282 = G__62319;
i__62114_62283 = G__62320;
continue;
}
} else {
}
}
break;
}

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62254){
var state_val_62255 = (state_62254[(1)]);
if((state_val_62255 === (7))){
var inst_62226 = (state_62254[(7)]);
var inst_62233 = cljs.core._EQ_.call(null,inst_62226,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62254__$1 = state_62254;
if(inst_62233){
var statearr_62256_62321 = state_62254__$1;
(statearr_62256_62321[(1)] = (9));

} else {
var statearr_62257_62322 = state_62254__$1;
(statearr_62257_62322[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (1))){
var inst_62218 = (state_62254[(8)]);
var inst_62219 = (state_62254[(9)]);
var inst_62218__$1 = promise_chan;
var inst_62219__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_62220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62221 = [inst_62218__$1,inst_62219__$1];
var inst_62222 = (new cljs.core.PersistentVector(null,2,(5),inst_62220,inst_62221,null));
var state_62254__$1 = (function (){var statearr_62258 = state_62254;
(statearr_62258[(8)] = inst_62218__$1);

(statearr_62258[(9)] = inst_62219__$1);

return statearr_62258;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62254__$1,(2),inst_62222);
} else {
if((state_val_62255 === (4))){
var inst_62226 = (state_62254[(7)]);
var inst_62219 = (state_62254[(9)]);
var inst_62230 = cljs.core._EQ_.call(null,inst_62226,inst_62219);
var state_62254__$1 = state_62254;
if(inst_62230){
var statearr_62259_62323 = state_62254__$1;
(statearr_62259_62323[(1)] = (6));

} else {
var statearr_62260_62324 = state_62254__$1;
(statearr_62260_62324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (13))){
var state_62254__$1 = state_62254;
var statearr_62261_62325 = state_62254__$1;
(statearr_62261_62325[(2)] = null);

(statearr_62261_62325[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (6))){
var state_62254__$1 = state_62254;
var statearr_62262_62326 = state_62254__$1;
(statearr_62262_62326[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62262_62326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (3))){
var state_62254__$1 = state_62254;
var statearr_62263_62327 = state_62254__$1;
(statearr_62263_62327[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62263_62327[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (12))){
var inst_62244 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_62245 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62246 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62247 = cljs.core.PersistentHashMap.fromArrays(inst_62245,inst_62246);
var inst_62248 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_62247);
var inst_62249 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_62248);
var state_62254__$1 = (function (){var statearr_62264 = state_62254;
(statearr_62264[(10)] = inst_62244);

return statearr_62264;
})();
var statearr_62265_62328 = state_62254__$1;
(statearr_62265_62328[(2)] = inst_62249);

(statearr_62265_62328[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (2))){
var inst_62218 = (state_62254[(8)]);
var inst_62226 = (state_62254[(7)]);
var inst_62224 = (state_62254[(2)]);
var inst_62225 = cljs.core.nth.call(null,inst_62224,(0),null);
var inst_62226__$1 = cljs.core.nth.call(null,inst_62224,(1),null);
var inst_62227 = cljs.core._EQ_.call(null,inst_62226__$1,inst_62218);
var state_62254__$1 = (function (){var statearr_62266 = state_62254;
(statearr_62266[(11)] = inst_62225);

(statearr_62266[(7)] = inst_62226__$1);

return statearr_62266;
})();
if(inst_62227){
var statearr_62267_62329 = state_62254__$1;
(statearr_62267_62329[(1)] = (3));

} else {
var statearr_62268_62330 = state_62254__$1;
(statearr_62268_62330[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (11))){
var inst_62237 = (state_62254[(2)]);
var state_62254__$1 = state_62254;
var statearr_62269_62331 = state_62254__$1;
(statearr_62269_62331[(2)] = inst_62237);

(statearr_62269_62331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (9))){
var inst_62225 = (state_62254[(11)]);
var state_62254__$1 = state_62254;
var statearr_62270_62332 = state_62254__$1;
(statearr_62270_62332[(2)] = inst_62225);

(statearr_62270_62332[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (5))){
var inst_62241 = (state_62254[(2)]);
var inst_62242 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62241);
var state_62254__$1 = state_62254;
if(inst_62242){
var statearr_62271_62333 = state_62254__$1;
(statearr_62271_62333[(1)] = (12));

} else {
var statearr_62272_62334 = state_62254__$1;
(statearr_62272_62334[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (14))){
var inst_62252 = (state_62254[(2)]);
var state_62254__$1 = state_62254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62254__$1,inst_62252);
} else {
if((state_val_62255 === (10))){
var state_62254__$1 = state_62254;
var statearr_62273_62335 = state_62254__$1;
(statearr_62273_62335[(2)] = null);

(statearr_62273_62335[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62255 === (8))){
var inst_62239 = (state_62254[(2)]);
var state_62254__$1 = state_62254;
var statearr_62274_62336 = state_62254__$1;
(statearr_62274_62336[(2)] = inst_62239);

(statearr_62274_62336[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_62275 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62275[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_62275[(1)] = (1));

return statearr_62275;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_62254){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62276){var ex__2749__auto__ = e62276;
var statearr_62277_62337 = state_62254;
(statearr_62277_62337[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62254[(4)]))){
var statearr_62278_62338 = state_62254;
(statearr_62278_62338[(1)] = cljs.core.first.call(null,(state_62254[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62339 = state_62254;
state_62254 = G__62339;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_62254){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_62254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62279 = f__2769__auto__.call(null);
(statearr_62279[(6)] = c__2768__auto__);

return statearr_62279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62383){
var state_val_62384 = (state_62383[(1)]);
if((state_val_62384 === (7))){
var state_62383__$1 = state_62383;
var statearr_62385_62411 = state_62383__$1;
(statearr_62385_62411[(2)] = null);

(statearr_62385_62411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (1))){
var state_62383__$1 = state_62383;
var statearr_62386_62412 = state_62383__$1;
(statearr_62386_62412[(2)] = null);

(statearr_62386_62412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (4))){
var inst_62340 = (state_62383[(2)]);
var state_62383__$1 = state_62383;
var statearr_62387_62413 = state_62383__$1;
(statearr_62387_62413[(2)] = inst_62340);

(statearr_62387_62413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (6))){
var inst_62362 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_62383__$1 = state_62383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62383__$1,(9),inst_62362);
} else {
if((state_val_62384 === (3))){
var inst_62381 = (state_62383[(2)]);
var state_62383__$1 = state_62383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62383__$1,inst_62381);
} else {
if((state_val_62384 === (12))){
var inst_62375 = (state_62383[(2)]);
var state_62383__$1 = state_62383;
var statearr_62388_62414 = state_62383__$1;
(statearr_62388_62414[(2)] = inst_62375);

(statearr_62388_62414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (2))){
var inst_62351 = (state_62383[(7)]);
var inst_62356 = (state_62383[(8)]);
var inst_62346 = (state_62383[(9)]);
var _ = (function (){var statearr_62389 = state_62383;
(statearr_62389[(4)] = cljs.core.cons.call(null,(5),(state_62383[(4)])));

return statearr_62389;
})();
var inst_62346__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_62347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62348 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62349 = (new cljs.core.PersistentVector(null,2,(5),inst_62347,inst_62348,null));
var inst_62350 = (function (){var lock_id = inst_62346__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_62351__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62349,inst_62350);
var inst_62352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62353 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62354 = (new cljs.core.PersistentVector(null,3,(5),inst_62352,inst_62353,null));
var inst_62355 = cljs.core.get_in.call(null,inst_62351__$1,inst_62354);
var inst_62356__$1 = cljs.core._EQ_.call(null,inst_62346__$1,inst_62355);
var inst_62357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62358 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62359 = (new cljs.core.PersistentVector(null,3,(5),inst_62357,inst_62358,null));
var inst_62360 = cljs.core.get_in.call(null,inst_62351__$1,inst_62359);
var state_62383__$1 = (function (){var statearr_62390 = state_62383;
(statearr_62390[(10)] = inst_62360);

(statearr_62390[(7)] = inst_62351__$1);

(statearr_62390[(8)] = inst_62356__$1);

(statearr_62390[(9)] = inst_62346__$1);

return statearr_62390;
})();
if(inst_62356__$1){
var statearr_62391_62415 = state_62383__$1;
(statearr_62391_62415[(1)] = (6));

} else {
var statearr_62392_62416 = state_62383__$1;
(statearr_62392_62416[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (11))){
var inst_62360 = (state_62383[(10)]);
var inst_62367 = (state_62383[(11)]);
var inst_62366 = (state_62383[(12)]);
var inst_62373 = fluree.db.util.xhttp.try_socket.call(null,inst_62366,sub_chan,pub_chan,inst_62360,(60000),inst_62367);
var state_62383__$1 = state_62383;
var statearr_62394_62417 = state_62383__$1;
(statearr_62394_62417[(2)] = inst_62373);

(statearr_62394_62417[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (9))){
var inst_62360 = (state_62383[(10)]);
var inst_62351 = (state_62383[(7)]);
var inst_62356 = (state_62383[(8)]);
var inst_62366 = (state_62383[(12)]);
var inst_62346 = (state_62383[(9)]);
var inst_62364 = (state_62383[(13)]);
var inst_62364__$1 = (state_62383[(2)]);
var inst_62365 = clojure.string.replace.call(null,inst_62364__$1,"http","ws");
var inst_62366__$1 = [inst_62365,"/fdb/ws"].join('');
var inst_62367 = (function (){var lock_id = inst_62346;
var state = inst_62351;
var have_lock_QMARK_ = inst_62356;
var resp_chan = inst_62360;
var healthy_server = inst_62364__$1;
var ws_url = inst_62366__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_62368 = fluree.db.util.core.exception_QMARK_.call(null,inst_62364__$1);
var state_62383__$1 = (function (){var statearr_62395 = state_62383;
(statearr_62395[(11)] = inst_62367);

(statearr_62395[(12)] = inst_62366__$1);

(statearr_62395[(13)] = inst_62364__$1);

return statearr_62395;
})();
if(inst_62368){
var statearr_62396_62418 = state_62383__$1;
(statearr_62396_62418[(1)] = (10));

} else {
var statearr_62397_62419 = state_62383__$1;
(statearr_62397_62419[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (5))){
var _ = (function (){var statearr_62398 = state_62383;
(statearr_62398[(4)] = cljs.core.rest.call(null,(state_62383[(4)])));

return statearr_62398;
})();
var state_62383__$1 = state_62383;
var ex62393 = (state_62383__$1[(2)]);
var statearr_62399_62420 = state_62383__$1;
(statearr_62399_62420[(5)] = ex62393);


if((ex62393 instanceof Error)){
var statearr_62400_62421 = state_62383__$1;
(statearr_62400_62421[(1)] = (4));

(statearr_62400_62421[(5)] = null);

} else {
throw ex62393;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (10))){
var inst_62360 = (state_62383[(10)]);
var inst_62364 = (state_62383[(13)]);
var inst_62370 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_62371 = cljs.core.async.put_BANG_.call(null,inst_62360,inst_62364);
var state_62383__$1 = (function (){var statearr_62401 = state_62383;
(statearr_62401[(14)] = inst_62370);

return statearr_62401;
})();
var statearr_62402_62422 = state_62383__$1;
(statearr_62402_62422[(2)] = inst_62371);

(statearr_62402_62422[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62384 === (8))){
var inst_62360 = (state_62383[(10)]);
var inst_62378 = (state_62383[(2)]);
var _ = (function (){var statearr_62403 = state_62383;
(statearr_62403[(4)] = cljs.core.rest.call(null,(state_62383[(4)])));

return statearr_62403;
})();
var state_62383__$1 = (function (){var statearr_62404 = state_62383;
(statearr_62404[(15)] = inst_62378);

return statearr_62404;
})();
var statearr_62405_62423 = state_62383__$1;
(statearr_62405_62423[(2)] = inst_62360);

(statearr_62405_62423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_62406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62406[(0)] = fluree$db$connection$establish_socket_$_state_machine__2746__auto__);

(statearr_62406[(1)] = (1));

return statearr_62406;
});
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____1 = (function (state_62383){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62407){var ex__2749__auto__ = e62407;
var statearr_62408_62424 = state_62383;
(statearr_62408_62424[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62383[(4)]))){
var statearr_62409_62425 = state_62383;
(statearr_62409_62425[(1)] = cljs.core.first.call(null,(state_62383[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62426 = state_62383;
state_62383 = G__62426;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = function(state_62383){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____1.call(this,state_62383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62410 = f__2769__auto__.call(null);
(statearr_62410[(6)] = c__2768__auto__);

return statearr_62410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k62428,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__62432 = k62428;
var G__62432__$1 = (((G__62432 instanceof cljs.core.Keyword))?G__62432.fqn:null);
switch (G__62432__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k62428,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__62433){
var vec__62434 = p__62433;
var k__5367__auto__ = cljs.core.nth.call(null,vec__62434,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__62434,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62427){
var self__ = this;
var G__62427__$1 = this;
return (new cljs.core.RecordIter((0),G__62427__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (22 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62429,other62430){
var self__ = this;
var this62429__$1 = this;
return (((!((other62430 == null)))) && ((((this62429__$1.constructor === other62430.constructor)) && (((cljs.core._EQ_.call(null,this62429__$1.id,other62430.id)) && (((cljs.core._EQ_.call(null,this62429__$1.servers,other62430.servers)) && (((cljs.core._EQ_.call(null,this62429__$1.state,other62430.state)) && (((cljs.core._EQ_.call(null,this62429__$1.req_chan,other62430.req_chan)) && (((cljs.core._EQ_.call(null,this62429__$1.sub_chan,other62430.sub_chan)) && (((cljs.core._EQ_.call(null,this62429__$1.pub_chan,other62430.pub_chan)) && (((cljs.core._EQ_.call(null,this62429__$1.group,other62430.group)) && (((cljs.core._EQ_.call(null,this62429__$1.storage_read,other62430.storage_read)) && (((cljs.core._EQ_.call(null,this62429__$1.storage_write,other62430.storage_write)) && (((cljs.core._EQ_.call(null,this62429__$1.object_cache,other62430.object_cache)) && (((cljs.core._EQ_.call(null,this62429__$1.parallelism,other62430.parallelism)) && (((cljs.core._EQ_.call(null,this62429__$1.serializer,other62430.serializer)) && (((cljs.core._EQ_.call(null,this62429__$1.default_network,other62430.default_network)) && (((cljs.core._EQ_.call(null,this62429__$1.transactor_QMARK_,other62430.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this62429__$1.publish,other62430.publish)) && (((cljs.core._EQ_.call(null,this62429__$1.transact_handler,other62430.transact_handler)) && (((cljs.core._EQ_.call(null,this62429__$1.tx_private_key,other62430.tx_private_key)) && (((cljs.core._EQ_.call(null,this62429__$1.tx_key_id,other62430.tx_key_id)) && (((cljs.core._EQ_.call(null,this62429__$1.meta,other62430.meta)) && (((cljs.core._EQ_.call(null,this62429__$1.add_listener,other62430.add_listener)) && (((cljs.core._EQ_.call(null,this62429__$1.remove_listener,other62430.remove_listener)) && (((cljs.core._EQ_.call(null,this62429__$1.close,other62430.close)) && (cljs.core._EQ_.call(null,this62429__$1.__extmap,other62430.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k62428){
var self__ = this;
var this__5350__auto____$1 = this;
var G__62437 = k62428;
var G__62437__$1 = (((G__62437 instanceof cljs.core.Keyword))?G__62437.fqn:null);
switch (G__62437__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k62428);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__62427){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__62438 = cljs.core.keyword_identical_QMARK_;
var expr__62439 = k__5352__auto__;
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__62439))){
return (new fluree.db.connection.Connection(G__62427,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,G__62427,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62427,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62427,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62427,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62427,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62427,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__62427,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__62427,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__62427,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__62427,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62427,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62427,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62427,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62427,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62427,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62427,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62427,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62427,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62427,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62427,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62438.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__62439))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62427,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__62427),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__62427){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62427,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62431){
var extmap__5385__auto__ = (function (){var G__62441 = cljs.core.dissoc.call(null,G__62431,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__62431)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__62441);
} else {
return G__62441;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62431),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62431),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__62447 = servers_STAR_;
var vec__62448 = G__62447;
var seq__62449 = cljs.core.seq.call(null,vec__62448);
var first__62450 = cljs.core.first.call(null,seq__62449);
var seq__62449__$1 = cljs.core.next.call(null,seq__62449);
var server = first__62450;
var r = seq__62449__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62447__$1 = G__62447;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62454 = G__62447__$1;
var seq__62455 = cljs.core.seq.call(null,vec__62454);
var first__62456 = cljs.core.first.call(null,seq__62455);
var seq__62455__$1 = cljs.core.next.call(null,seq__62455);
var server__$1 = first__62456;
var r__$1 = seq__62455__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__62457 = r__$1;
var G__62458 = is_https_QMARK_;
var G__62459 = result_STAR_;
G__62447__$1 = G__62457;
https_QMARK___$1 = G__62458;
result__$1 = G__62459;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62460 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62460 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__62460);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62489){
var state_val_62490 = (state_62489[(1)]);
if((state_val_62490 === (7))){
var inst_62475 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62476 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62477 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62478 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62479 = fluree.db.connection.establish_socket.call(null,inst_62475,inst_62476,inst_62477,inst_62478);
var state_62489__$1 = state_62489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62489__$1,(9),inst_62479);
} else {
if((state_val_62490 === (1))){
var state_62489__$1 = state_62489;
var statearr_62491_62510 = state_62489__$1;
(statearr_62491_62510[(2)] = null);

(statearr_62491_62510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62490 === (4))){
var inst_62461 = (state_62489[(2)]);
var state_62489__$1 = state_62489;
var statearr_62492_62511 = state_62489__$1;
(statearr_62492_62511[(2)] = inst_62461);

(statearr_62492_62511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62490 === (6))){
var inst_62472 = (state_62489[(7)]);
var state_62489__$1 = state_62489;
var statearr_62493_62512 = state_62489__$1;
(statearr_62493_62512[(2)] = inst_62472);

(statearr_62493_62512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62490 === (3))){
var inst_62487 = (state_62489[(2)]);
var state_62489__$1 = state_62489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62489__$1,inst_62487);
} else {
if((state_val_62490 === (2))){
var inst_62472 = (state_62489[(7)]);
var _ = (function (){var statearr_62495 = state_62489;
(statearr_62495[(4)] = cljs.core.cons.call(null,(5),(state_62489[(4)])));

return statearr_62495;
})();
var inst_62467 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_62468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62469 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62470 = [inst_62469,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62471 = (new cljs.core.PersistentVector(null,3,(5),inst_62468,inst_62470,null));
var inst_62472__$1 = cljs.core.get_in.call(null,inst_62467,inst_62471);
var state_62489__$1 = (function (){var statearr_62496 = state_62489;
(statearr_62496[(7)] = inst_62472__$1);

return statearr_62496;
})();
if(cljs.core.truth_(inst_62472__$1)){
var statearr_62497_62513 = state_62489__$1;
(statearr_62497_62513[(1)] = (6));

} else {
var statearr_62498_62514 = state_62489__$1;
(statearr_62498_62514[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62490 === (9))){
var inst_62481 = (state_62489[(2)]);
var inst_62482 = fluree.db.util.async.throw_err.call(null,inst_62481);
var state_62489__$1 = state_62489;
var statearr_62499_62515 = state_62489__$1;
(statearr_62499_62515[(2)] = inst_62482);

(statearr_62499_62515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62490 === (5))){
var _ = (function (){var statearr_62500 = state_62489;
(statearr_62500[(4)] = cljs.core.rest.call(null,(state_62489[(4)])));

return statearr_62500;
})();
var state_62489__$1 = state_62489;
var ex62494 = (state_62489__$1[(2)]);
var statearr_62501_62516 = state_62489__$1;
(statearr_62501_62516[(5)] = ex62494);


if((ex62494 instanceof Error)){
var statearr_62502_62517 = state_62489__$1;
(statearr_62502_62517[(1)] = (4));

(statearr_62502_62517[(5)] = null);

} else {
throw ex62494;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62490 === (8))){
var inst_62484 = (state_62489[(2)]);
var _ = (function (){var statearr_62503 = state_62489;
(statearr_62503[(4)] = cljs.core.rest.call(null,(state_62489[(4)])));

return statearr_62503;
})();
var state_62489__$1 = state_62489;
var statearr_62504_62518 = state_62489__$1;
(statearr_62504_62518[(2)] = inst_62484);

(statearr_62504_62518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_62505 = [null,null,null,null,null,null,null,null];
(statearr_62505[(0)] = fluree$db$connection$get_socket_$_state_machine__2746__auto__);

(statearr_62505[(1)] = (1));

return statearr_62505;
});
var fluree$db$connection$get_socket_$_state_machine__2746__auto____1 = (function (state_62489){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62506){var ex__2749__auto__ = e62506;
var statearr_62507_62519 = state_62489;
(statearr_62507_62519[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62489[(4)]))){
var statearr_62508_62520 = state_62489;
(statearr_62508_62520[(1)] = cljs.core.first.call(null,(state_62489[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62521 = state_62489;
state_62489 = G__62521;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2746__auto__ = function(state_62489){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____1.call(this,state_62489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2746__auto____0;
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62509 = f__2769__auto__.call(null);
(statearr_62509[(6)] = c__2768__auto__);

return statearr_62509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e62522){var e = e62522;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62649){
var state_val_62650 = (state_62649[(1)]);
if((state_val_62650 === (7))){
var inst_62645 = (state_62649[(2)]);
var state_62649__$1 = state_62649;
var statearr_62652_62722 = state_62649__$1;
(statearr_62652_62722[(2)] = inst_62645);

(statearr_62652_62722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (20))){
var _ = (function (){var statearr_62653 = state_62649;
(statearr_62653[(4)] = cljs.core.rest.call(null,(state_62649[(4)])));

return statearr_62653;
})();
var state_62649__$1 = state_62649;
var ex62651 = (state_62649__$1[(2)]);
var statearr_62654_62723 = state_62649__$1;
(statearr_62654_62723[(5)] = ex62651);


var statearr_62655_62724 = state_62649__$1;
(statearr_62655_62724[(1)] = (10));

(statearr_62655_62724[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (27))){
var inst_62637 = (state_62649[(2)]);
var _ = (function (){var statearr_62656 = state_62649;
(statearr_62656[(4)] = cljs.core.rest.call(null,(state_62649[(4)])));

return statearr_62656;
})();
var state_62649__$1 = state_62649;
var statearr_62657_62725 = state_62649__$1;
(statearr_62657_62725[(2)] = inst_62637);

(statearr_62657_62725[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (1))){
var inst_62524 = (0);
var state_62649__$1 = (function (){var statearr_62658 = state_62649;
(statearr_62658[(7)] = inst_62524);

return statearr_62658;
})();
var statearr_62659_62726 = state_62649__$1;
(statearr_62659_62726[(2)] = null);

(statearr_62659_62726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (24))){
var inst_62615 = (state_62649[(8)]);
var inst_62615__$1 = (state_62649[(2)]);
var inst_62616 = inst_62615__$1 === true;
var state_62649__$1 = (function (){var statearr_62660 = state_62649;
(statearr_62660[(8)] = inst_62615__$1);

return statearr_62660;
})();
if(cljs.core.truth_(inst_62616)){
var statearr_62661_62727 = state_62649__$1;
(statearr_62661_62727[(1)] = (25));

} else {
var statearr_62662_62728 = state_62649__$1;
(statearr_62662_62728[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (4))){
var inst_62527 = (state_62649[(9)]);
var inst_62527__$1 = (state_62649[(2)]);
var state_62649__$1 = (function (){var statearr_62663 = state_62649;
(statearr_62663[(9)] = inst_62527__$1);

return statearr_62663;
})();
if(cljs.core.truth_(inst_62527__$1)){
var statearr_62664_62729 = state_62649__$1;
(statearr_62664_62729[(1)] = (5));

} else {
var statearr_62665_62730 = state_62649__$1;
(statearr_62665_62730[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (15))){
var inst_62540 = (state_62649[(10)]);
var state_62649__$1 = state_62649;
var statearr_62666_62731 = state_62649__$1;
(statearr_62666_62731[(2)] = inst_62540);

(statearr_62666_62731[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (21))){
var inst_62567 = (state_62649[(11)]);
var inst_62524 = (state_62649[(7)]);
var inst_62572 = (state_62649[(12)]);
var inst_62571 = (state_62649[(13)]);
var inst_62527 = (state_62649[(9)]);
var inst_62564 = (state_62649[(14)]);
var inst_62566 = (state_62649[(15)]);
var inst_62568 = (state_62649[(16)]);
var inst_62565 = (state_62649[(17)]);
var inst_62563 = (state_62649[(18)]);
var inst_62574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62575 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62571];
var inst_62576 = (new cljs.core.PersistentVector(null,2,(5),inst_62574,inst_62575,null));
var inst_62577 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_62576,inst_62566);
var inst_62604 = cljs.core.async.chan.call(null,(1));
var inst_62605 = (function (){var resp_chan = inst_62566;
var timeout = inst_62572;
var i = inst_62524;
var data = inst_62565;
var _ = inst_62563;
var req_id = inst_62571;
var operation = inst_62564;
var msg = inst_62527;
var vec__62559 = inst_62527;
var c__2768__auto____$1 = inst_62604;
var opts = inst_62567;
var map__62562 = inst_62568;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62602){
var state_val_62603 = (state_62602[(1)]);
if((state_val_62603 === (1))){
var inst_62581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62582 = cljs.core.async.timeout.call(null,timeout);
var inst_62583 = [resp_chan,inst_62582];
var inst_62584 = (new cljs.core.PersistentVector(null,2,(5),inst_62581,inst_62583,null));
var state_62602__$1 = state_62602;
return cljs.core.async.ioc_alts_BANG_.call(null,state_62602__$1,(2),inst_62584);
} else {
if((state_val_62603 === (2))){
var inst_62587 = (state_62602[(7)]);
var inst_62586 = (state_62602[(2)]);
var inst_62587__$1 = cljs.core.nth.call(null,inst_62586,(0),null);
var inst_62588 = cljs.core.nth.call(null,inst_62586,(1),null);
var inst_62589 = (function (){var vec__62578 = inst_62586;
var resp = inst_62587__$1;
var c = inst_62588;
return (function (p1__62523_SHARP_){
return cljs.core.dissoc.call(null,p1__62523_SHARP_,req_id);
});
})();
var inst_62590 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62589);
var inst_62591 = cljs.core._EQ_.call(null,inst_62588,resp_chan);
var state_62602__$1 = (function (){var statearr_62667 = state_62602;
(statearr_62667[(7)] = inst_62587__$1);

(statearr_62667[(8)] = inst_62590);

return statearr_62667;
})();
if(inst_62591){
var statearr_62668_62732 = state_62602__$1;
(statearr_62668_62732[(1)] = (3));

} else {
var statearr_62669_62733 = state_62602__$1;
(statearr_62669_62733[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62603 === (3))){
var inst_62587 = (state_62602[(7)]);
var state_62602__$1 = state_62602;
var statearr_62670_62734 = state_62602__$1;
(statearr_62670_62734[(2)] = inst_62587);

(statearr_62670_62734[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62603 === (4))){
var inst_62594 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62595 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62596 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62597 = cljs.core.PersistentHashMap.fromArrays(inst_62595,inst_62596);
var inst_62598 = cljs.core.ex_info.call(null,inst_62594,inst_62597);
var state_62602__$1 = state_62602;
var statearr_62671_62735 = state_62602__$1;
(statearr_62671_62735[(2)] = inst_62598);

(statearr_62671_62735[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62603 === (5))){
var inst_62600 = (state_62602[(2)]);
var state_62602__$1 = state_62602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62602__$1,inst_62600);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_62672 = [null,null,null,null,null,null,null,null,null];
(statearr_62672[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_62672[(1)] = (1));

return statearr_62672;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_62602){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62673){var ex__2749__auto__ = e62673;
var statearr_62674_62736 = state_62602;
(statearr_62674_62736[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62602[(4)]))){
var statearr_62675_62737 = state_62602;
(statearr_62675_62737[(1)] = cljs.core.first.call(null,(state_62602[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62738 = state_62602;
state_62602 = G__62738;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_62602){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_62602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62676 = f__2769__auto__.call(null);
(statearr_62676[(6)] = c__2768__auto____$1);

return statearr_62676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_62606 = cljs.core.async.impl.dispatch.run.call(null,inst_62605);
var state_62649__$1 = (function (){var statearr_62677 = state_62649;
(statearr_62677[(19)] = inst_62577);

(statearr_62677[(20)] = inst_62606);

return statearr_62677;
})();
var statearr_62678_62739 = state_62649__$1;
(statearr_62678_62739[(2)] = inst_62604);

(statearr_62678_62739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (31))){
var inst_62625 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_62649__$1 = state_62649;
var statearr_62679_62740 = state_62649__$1;
(statearr_62679_62740[(2)] = inst_62625);

(statearr_62679_62740[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (32))){
var state_62649__$1 = state_62649;
var statearr_62680_62741 = state_62649__$1;
(statearr_62680_62741[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (33))){
var inst_62633 = (state_62649[(2)]);
var state_62649__$1 = state_62649;
var statearr_62682_62742 = state_62649__$1;
(statearr_62682_62742[(2)] = inst_62633);

(statearr_62682_62742[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (13))){
var inst_62540 = (state_62649[(10)]);
var inst_62537 = (state_62649[(2)]);
var inst_62538 = cljs.core.nth.call(null,inst_62537,(0),null);
var inst_62539 = cljs.core.nth.call(null,inst_62537,(1),null);
var inst_62540__$1 = cljs.core.nth.call(null,inst_62537,(2),null);
var state_62649__$1 = (function (){var statearr_62683 = state_62649;
(statearr_62683[(21)] = inst_62539);

(statearr_62683[(22)] = inst_62538);

(statearr_62683[(10)] = inst_62540__$1);

return statearr_62683;
})();
if(cljs.core.truth_(inst_62540__$1)){
var statearr_62684_62743 = state_62649__$1;
(statearr_62684_62743[(1)] = (14));

} else {
var statearr_62685_62744 = state_62649__$1;
(statearr_62685_62744[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (22))){
var state_62649__$1 = state_62649;
var statearr_62686_62745 = state_62649__$1;
(statearr_62686_62745[(2)] = null);

(statearr_62686_62745[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (36))){
var inst_62631 = (state_62649[(2)]);
var state_62649__$1 = state_62649;
var statearr_62687_62746 = state_62649__$1;
(statearr_62687_62746[(2)] = inst_62631);

(statearr_62687_62746[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (29))){
var inst_62615 = (state_62649[(8)]);
var inst_62623 = (inst_62615 == null);
var state_62649__$1 = state_62649;
if(cljs.core.truth_(inst_62623)){
var statearr_62688_62747 = state_62649__$1;
(statearr_62688_62747[(1)] = (31));

} else {
var statearr_62689_62748 = state_62649__$1;
(statearr_62689_62748[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (6))){
var state_62649__$1 = state_62649;
var statearr_62690_62749 = state_62649__$1;
(statearr_62690_62749[(2)] = null);

(statearr_62690_62749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (28))){
var inst_62615 = (state_62649[(8)]);
var inst_62621 = fluree.db.util.log.error.call(null,inst_62615,"Error processing message in producer.");
var state_62649__$1 = state_62649;
var statearr_62691_62750 = state_62649__$1;
(statearr_62691_62750[(2)] = inst_62621);

(statearr_62691_62750[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (25))){
var state_62649__$1 = state_62649;
var statearr_62692_62751 = state_62649__$1;
(statearr_62692_62751[(2)] = null);

(statearr_62692_62751[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (34))){
var inst_62615 = (state_62649[(8)]);
var inst_62628 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_62615);
var state_62649__$1 = state_62649;
var statearr_62693_62752 = state_62649__$1;
(statearr_62693_62752[(2)] = inst_62628);

(statearr_62693_62752[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (17))){
var inst_62529 = (state_62649[(23)]);
var inst_62540 = (state_62649[(10)]);
var inst_62547 = cljs.core.async.put_BANG_.call(null,inst_62540,inst_62529);
var state_62649__$1 = state_62649;
var statearr_62694_62753 = state_62649__$1;
(statearr_62694_62753[(2)] = inst_62547);

(statearr_62694_62753[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (3))){
var inst_62647 = (state_62649[(2)]);
var state_62649__$1 = state_62649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62649__$1,inst_62647);
} else {
if((state_val_62650 === (12))){
var state_62649__$1 = state_62649;
var statearr_62695_62754 = state_62649__$1;
(statearr_62695_62754[(2)] = null);

(statearr_62695_62754[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (2))){
var state_62649__$1 = state_62649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62649__$1,(4),req_chan);
} else {
if((state_val_62650 === (23))){
var inst_62571 = (state_62649[(13)]);
var inst_62564 = (state_62649[(14)]);
var inst_62565 = (state_62649[(17)]);
var inst_62609 = (state_62649[(2)]);
var inst_62610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62611 = [inst_62564,inst_62571,inst_62565];
var inst_62612 = (new cljs.core.PersistentVector(null,3,(5),inst_62610,inst_62611,null));
var inst_62613 = publish_fn.call(null,conn,inst_62612);
var state_62649__$1 = (function (){var statearr_62696 = state_62649;
(statearr_62696[(24)] = inst_62609);

return statearr_62696;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62649__$1,(24),inst_62613);
} else {
if((state_val_62650 === (35))){
var state_62649__$1 = state_62649;
var statearr_62697_62755 = state_62649__$1;
(statearr_62697_62755[(2)] = null);

(statearr_62697_62755[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (19))){
var inst_62553 = (state_62649[(2)]);
var state_62649__$1 = state_62649;
var statearr_62698_62756 = state_62649__$1;
(statearr_62698_62756[(2)] = inst_62553);

(statearr_62698_62756[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (11))){
var inst_62527 = (state_62649[(9)]);
var state_62649__$1 = state_62649;
var statearr_62699_62757 = state_62649__$1;
(statearr_62699_62757[(2)] = inst_62527);

(statearr_62699_62757[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (9))){
var inst_62524 = (state_62649[(7)]);
var inst_62640 = (state_62649[(2)]);
var inst_62641 = (inst_62524 + (1));
var inst_62524__$1 = inst_62641;
var state_62649__$1 = (function (){var statearr_62700 = state_62649;
(statearr_62700[(7)] = inst_62524__$1);

(statearr_62700[(25)] = inst_62640);

return statearr_62700;
})();
var statearr_62701_62758 = state_62649__$1;
(statearr_62701_62758[(2)] = null);

(statearr_62701_62758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (5))){
var state_62649__$1 = state_62649;
var statearr_62702_62759 = state_62649__$1;
(statearr_62702_62759[(2)] = null);

(statearr_62702_62759[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (14))){
var inst_62540 = (state_62649[(10)]);
var inst_62542 = fluree.db.util.async.channel_QMARK_.call(null,inst_62540);
var state_62649__$1 = state_62649;
var statearr_62703_62760 = state_62649__$1;
(statearr_62703_62760[(2)] = inst_62542);

(statearr_62703_62760[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (26))){
var inst_62615 = (state_62649[(8)]);
var inst_62619 = fluree.db.util.core.exception_QMARK_.call(null,inst_62615);
var state_62649__$1 = state_62649;
if(inst_62619){
var statearr_62704_62761 = state_62649__$1;
(statearr_62704_62761[(1)] = (28));

} else {
var statearr_62705_62762 = state_62649__$1;
(statearr_62705_62762[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (16))){
var inst_62545 = (state_62649[(2)]);
var state_62649__$1 = state_62649;
if(cljs.core.truth_(inst_62545)){
var statearr_62706_62763 = state_62649__$1;
(statearr_62706_62763[(1)] = (17));

} else {
var statearr_62707_62764 = state_62649__$1;
(statearr_62707_62764[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (30))){
var inst_62635 = (state_62649[(2)]);
var state_62649__$1 = state_62649;
var statearr_62708_62765 = state_62649__$1;
(statearr_62708_62765[(2)] = inst_62635);

(statearr_62708_62765[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (10))){
var inst_62527 = (state_62649[(9)]);
var inst_62529 = (state_62649[(2)]);
var inst_62533 = cljs.core.sequential_QMARK_.call(null,inst_62527);
var state_62649__$1 = (function (){var statearr_62709 = state_62649;
(statearr_62709[(23)] = inst_62529);

return statearr_62709;
})();
if(inst_62533){
var statearr_62710_62766 = state_62649__$1;
(statearr_62710_62766[(1)] = (11));

} else {
var statearr_62711_62767 = state_62649__$1;
(statearr_62711_62767[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (18))){
var inst_62529 = (state_62649[(23)]);
var inst_62527 = (state_62649[(9)]);
var inst_62549 = cljs.core.pr_str.call(null,inst_62527);
var inst_62550 = ["Error processing ledger request, no valid return channel: ",inst_62549].join('');
var inst_62551 = fluree.db.util.log.error.call(null,inst_62529,inst_62550);
var state_62649__$1 = state_62649;
var statearr_62712_62768 = state_62649__$1;
(statearr_62712_62768[(2)] = inst_62551);

(statearr_62712_62768[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62650 === (8))){
var inst_62567 = (state_62649[(11)]);
var inst_62527 = (state_62649[(9)]);
var inst_62566 = (state_62649[(15)]);
var inst_62568 = (state_62649[(16)]);
var _ = (function (){var statearr_62713 = state_62649;
(statearr_62713[(4)] = cljs.core.cons.call(null,(20),(state_62649[(4)])));

return statearr_62713;
})();
var inst_62563 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_62527);
var inst_62564 = cljs.core.nth.call(null,inst_62527,(0),null);
var inst_62565 = cljs.core.nth.call(null,inst_62527,(1),null);
var inst_62566__$1 = cljs.core.nth.call(null,inst_62527,(2),null);
var inst_62567__$1 = cljs.core.nth.call(null,inst_62527,(3),null);
var inst_62568__$1 = cljs.core.__destructure_map.call(null,inst_62567__$1);
var inst_62569 = fluree.db.util.core.random_uuid.call(null);
var inst_62570 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62569);
var inst_62571 = cljs.core.get.call(null,inst_62568__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62570);
var inst_62572 = cljs.core.get.call(null,inst_62568__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62649__$1 = (function (){var statearr_62714 = state_62649;
(statearr_62714[(11)] = inst_62567__$1);

(statearr_62714[(12)] = inst_62572);

(statearr_62714[(13)] = inst_62571);

(statearr_62714[(14)] = inst_62564);

(statearr_62714[(15)] = inst_62566__$1);

(statearr_62714[(16)] = inst_62568__$1);

(statearr_62714[(17)] = inst_62565);

(statearr_62714[(18)] = inst_62563);

return statearr_62714;
})();
if(cljs.core.truth_(inst_62566__$1)){
var statearr_62715_62769 = state_62649__$1;
(statearr_62715_62769[(1)] = (21));

} else {
var statearr_62716_62770 = state_62649__$1;
(statearr_62716_62770[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_62717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62717[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_62717[(1)] = (1));

return statearr_62717;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_62649){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62718){var ex__2749__auto__ = e62718;
var statearr_62719_62771 = state_62649;
(statearr_62719_62771[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62649[(4)]))){
var statearr_62720_62772 = state_62649;
(statearr_62720_62772[(1)] = cljs.core.first.call(null,(state_62649[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62773 = state_62649;
state_62649 = G__62773;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_62649){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_62649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62721 = f__2769__auto__.call(null);
(statearr_62721[(6)] = c__2768__auto__);

return statearr_62721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62774 = conn;
var map__62774__$1 = cljs.core.__destructure_map.call(null,map__62774);
var sub_chan = cljs.core.get.call(null,map__62774__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62859){
var state_val_62860 = (state_62859[(1)]);
if((state_val_62860 === (7))){
var inst_62855 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62861_62912 = state_62859__$1;
(statearr_62861_62912[(2)] = inst_62855);

(statearr_62861_62912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (20))){
var inst_62793 = (state_62859[(7)]);
var inst_62807 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62808 = [inst_62793];
var inst_62809 = cljs.core.PersistentHashMap.fromArrays(inst_62807,inst_62808);
var inst_62810 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_62809);
var state_62859__$1 = state_62859;
var statearr_62862_62913 = state_62859__$1;
(statearr_62862_62913[(2)] = inst_62810);

(statearr_62862_62913[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (27))){
var state_62859__$1 = state_62859;
var statearr_62863_62914 = state_62859__$1;
(statearr_62863_62914[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (1))){
var inst_62775 = (0);
var state_62859__$1 = (function (){var statearr_62865 = state_62859;
(statearr_62865[(8)] = inst_62775);

return statearr_62865;
})();
var statearr_62866_62915 = state_62859__$1;
(statearr_62866_62915[(2)] = null);

(statearr_62866_62915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (24))){
var inst_62786 = (state_62859[(9)]);
var inst_62835 = fluree.db.util.core.exception_QMARK_.call(null,inst_62786);
var state_62859__$1 = state_62859;
if(inst_62835){
var statearr_62867_62916 = state_62859__$1;
(statearr_62867_62916[(1)] = (26));

} else {
var statearr_62868_62917 = state_62859__$1;
(statearr_62868_62917[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (4))){
var inst_62780 = (state_62859[(10)]);
var inst_62785 = (state_62859[(2)]);
var inst_62786 = cljs.core.nth.call(null,inst_62785,(0),null);
var inst_62787 = cljs.core.nth.call(null,inst_62785,(1),null);
var inst_62788 = cljs.core._EQ_.call(null,inst_62787,inst_62780);
var state_62859__$1 = (function (){var statearr_62869 = state_62859;
(statearr_62869[(9)] = inst_62786);

return statearr_62869;
})();
if(inst_62788){
var statearr_62870_62918 = state_62859__$1;
(statearr_62870_62918[(1)] = (5));

} else {
var statearr_62871_62919 = state_62859__$1;
(statearr_62871_62919[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (15))){
var inst_62793 = (state_62859[(7)]);
var inst_62802 = typeof inst_62793 === 'string';
var state_62859__$1 = state_62859;
if(cljs.core.truth_(inst_62802)){
var statearr_62872_62920 = state_62859__$1;
(statearr_62872_62920[(1)] = (17));

} else {
var statearr_62873_62921 = state_62859__$1;
(statearr_62873_62921[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (21))){
var state_62859__$1 = state_62859;
var statearr_62874_62922 = state_62859__$1;
(statearr_62874_62922[(2)] = null);

(statearr_62874_62922[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (31))){
var inst_62849 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62875_62923 = state_62859__$1;
(statearr_62875_62923[(2)] = inst_62849);

(statearr_62875_62923[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (13))){
var inst_62819 = (state_62859[(2)]);
var inst_62820 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62821 = fluree.db.connection.close_websocket.call(null,inst_62820);
var inst_62822 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62823 = fluree.db.session.close_all_sessions.call(null,inst_62822);
var state_62859__$1 = (function (){var statearr_62876 = state_62859;
(statearr_62876[(11)] = inst_62819);

(statearr_62876[(12)] = inst_62821);

return statearr_62876;
})();
var statearr_62877_62924 = state_62859__$1;
(statearr_62877_62924[(2)] = inst_62823);

(statearr_62877_62924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (22))){
var inst_62813 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62878_62925 = state_62859__$1;
(statearr_62878_62925[(2)] = inst_62813);

(statearr_62878_62925[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (29))){
var inst_62786 = (state_62859[(9)]);
var inst_62841 = fluree.db.util.json.parse.call(null,inst_62786);
var inst_62842 = cljs.core.pr_str.call(null,inst_62841);
var inst_62843 = fluree.db.util.log.trace.call(null,"Received message:",inst_62842);
var inst_62844 = fluree.db.util.json.parse.call(null,inst_62786);
var inst_62845 = fluree.db.conn_events.process_events.call(null,conn,inst_62844);
var inst_62775 = (0);
var state_62859__$1 = (function (){var statearr_62879 = state_62859;
(statearr_62879[(8)] = inst_62775);

(statearr_62879[(13)] = inst_62843);

(statearr_62879[(14)] = inst_62845);

return statearr_62879;
})();
var statearr_62880_62926 = state_62859__$1;
(statearr_62880_62926[(2)] = null);

(statearr_62880_62926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (6))){
var inst_62786 = (state_62859[(9)]);
var inst_62831 = (inst_62786 == null);
var state_62859__$1 = state_62859;
if(cljs.core.truth_(inst_62831)){
var statearr_62881_62927 = state_62859__$1;
(statearr_62881_62927[(1)] = (23));

} else {
var statearr_62882_62928 = state_62859__$1;
(statearr_62882_62928[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (28))){
var inst_62851 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62883_62929 = state_62859__$1;
(statearr_62883_62929[(2)] = inst_62851);

(statearr_62883_62929[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (25))){
var inst_62853 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62884_62930 = state_62859__$1;
(statearr_62884_62930[(2)] = inst_62853);

(statearr_62884_62930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (17))){
var inst_62793 = (state_62859[(7)]);
var inst_62804 = cljs.core.eval.call(null,inst_62793);
var state_62859__$1 = state_62859;
var statearr_62885_62931 = state_62859__$1;
(statearr_62885_62931[(2)] = inst_62804);

(statearr_62885_62931[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (3))){
var inst_62857 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62859__$1,inst_62857);
} else {
if((state_val_62860 === (12))){
var inst_62793 = (state_62859[(7)]);
var inst_62798 = cljs.core.fn_QMARK_.call(null,inst_62793);
var state_62859__$1 = state_62859;
if(inst_62798){
var statearr_62886_62932 = state_62859__$1;
(statearr_62886_62932[(1)] = (14));

} else {
var statearr_62887_62933 = state_62859__$1;
(statearr_62887_62933[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (2))){
var inst_62780 = (state_62859[(10)]);
var inst_62780__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_62781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62782 = [sub_chan,inst_62780__$1];
var inst_62783 = (new cljs.core.PersistentVector(null,2,(5),inst_62781,inst_62782,null));
var state_62859__$1 = (function (){var statearr_62888 = state_62859;
(statearr_62888[(10)] = inst_62780__$1);

return statearr_62888;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62859__$1,(4),inst_62783);
} else {
if((state_val_62860 === (23))){
var inst_62833 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_62859__$1 = state_62859;
var statearr_62889_62934 = state_62859__$1;
(statearr_62889_62934[(2)] = inst_62833);

(statearr_62889_62934[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (19))){
var inst_62815 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62890_62935 = state_62859__$1;
(statearr_62890_62935[(2)] = inst_62815);

(statearr_62890_62935[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (11))){
var inst_62796 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_62859__$1 = state_62859;
var statearr_62891_62936 = state_62859__$1;
(statearr_62891_62936[(2)] = inst_62796);

(statearr_62891_62936[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (9))){
var inst_62775 = (state_62859[(8)]);
var inst_62825 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_62826 = (inst_62775 + (1));
var inst_62775__$1 = inst_62826;
var state_62859__$1 = (function (){var statearr_62892 = state_62859;
(statearr_62892[(8)] = inst_62775__$1);

(statearr_62892[(15)] = inst_62825);

return statearr_62892;
})();
var statearr_62893_62937 = state_62859__$1;
(statearr_62893_62937[(2)] = null);

(statearr_62893_62937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (5))){
var inst_62775 = (state_62859[(8)]);
var inst_62790 = cljs.core._EQ_.call(null,(2),inst_62775);
var state_62859__$1 = state_62859;
if(inst_62790){
var statearr_62894_62938 = state_62859__$1;
(statearr_62894_62938[(1)] = (8));

} else {
var statearr_62895_62939 = state_62859__$1;
(statearr_62895_62939[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (14))){
var inst_62793 = (state_62859[(7)]);
var inst_62800 = inst_62793.call(null);
var state_62859__$1 = state_62859;
var statearr_62896_62940 = state_62859__$1;
(statearr_62896_62940[(2)] = inst_62800);

(statearr_62896_62940[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (26))){
var inst_62786 = (state_62859[(9)]);
var inst_62837 = fluree.db.util.log.error.call(null,inst_62786);
var inst_62775 = (0);
var state_62859__$1 = (function (){var statearr_62897 = state_62859;
(statearr_62897[(16)] = inst_62837);

(statearr_62897[(8)] = inst_62775);

return statearr_62897;
})();
var statearr_62898_62941 = state_62859__$1;
(statearr_62898_62941[(2)] = null);

(statearr_62898_62941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (16))){
var inst_62817 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62899_62942 = state_62859__$1;
(statearr_62899_62942[(2)] = inst_62817);

(statearr_62899_62942[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (30))){
var state_62859__$1 = state_62859;
var statearr_62900_62943 = state_62859__$1;
(statearr_62900_62943[(2)] = null);

(statearr_62900_62943[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (10))){
var inst_62829 = (state_62859[(2)]);
var state_62859__$1 = state_62859;
var statearr_62901_62944 = state_62859__$1;
(statearr_62901_62944[(2)] = inst_62829);

(statearr_62901_62944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (18))){
var state_62859__$1 = state_62859;
var statearr_62902_62945 = state_62859__$1;
(statearr_62902_62945[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62860 === (8))){
var inst_62793 = (state_62859[(7)]);
var inst_62792 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_62793__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62794 = (inst_62793__$1 == null);
var state_62859__$1 = (function (){var statearr_62904 = state_62859;
(statearr_62904[(7)] = inst_62793__$1);

(statearr_62904[(17)] = inst_62792);

return statearr_62904;
})();
if(cljs.core.truth_(inst_62794)){
var statearr_62905_62946 = state_62859__$1;
(statearr_62905_62946[(1)] = (11));

} else {
var statearr_62906_62947 = state_62859__$1;
(statearr_62906_62947[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0 = (function (){
var statearr_62907 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62907[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2746__auto__);

(statearr_62907[(1)] = (1));

return statearr_62907;
});
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1 = (function (state_62859){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62859);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62908){var ex__2749__auto__ = e62908;
var statearr_62909_62948 = state_62859;
(statearr_62909_62948[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62859[(4)]))){
var statearr_62910_62949 = state_62859;
(statearr_62910_62949[(1)] = cljs.core.first.call(null,(state_62859[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62950 = state_62859;
state_62859 = G__62950;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = function(state_62859){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1.call(this,state_62859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62911 = f__2769__auto__.call(null);
(statearr_62911[(6)] = c__2768__auto__);

return statearr_62911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62952 = arguments.length;
switch (G__62952) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62953 = opts;
var map__62953__$1 = cljs.core.__destructure_map.call(null,map__62953);
var private$ = cljs.core.get.call(null,map__62953__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__62953__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63005){
var state_val_63006 = (state_63005[(1)]);
if((state_val_63006 === (7))){
var inst_62963 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_62964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62965 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62966 = (new cljs.core.PersistentVector(null,2,(5),inst_62964,inst_62965,null));
var inst_62967 = cljs.core.get_in.call(null,inst_62963,inst_62966);
var state_63005__$1 = state_63005;
var statearr_63007_63038 = state_63005__$1;
(statearr_63007_63038[(2)] = inst_62967);

(statearr_63007_63038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (1))){
var state_63005__$1 = state_63005;
var statearr_63008_63039 = state_63005__$1;
(statearr_63008_63039[(2)] = null);

(statearr_63008_63039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (4))){
var inst_62954 = (state_63005[(2)]);
var state_63005__$1 = state_63005;
var statearr_63009_63040 = state_63005__$1;
(statearr_63009_63040[(2)] = inst_62954);

(statearr_63009_63040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (15))){
var inst_62974 = (state_63005[(7)]);
var inst_62993 = (state_63005[(2)]);
var inst_62994 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62995 = [(5000),inst_62993,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_62996 = cljs.core.PersistentHashMap.fromArrays(inst_62994,inst_62995);
var inst_62997 = fluree.db.util.xhttp.get.call(null,inst_62974,inst_62996);
var state_63005__$1 = state_63005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63005__$1,(16),inst_62997);
} else {
if((state_val_63006 === (13))){
var inst_62974 = (state_63005[(7)]);
var inst_62984 = (state_63005[(8)]);
var inst_62986 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62987 = [inst_62984];
var inst_62988 = cljs.core.PersistentHashMap.fromArrays(inst_62986,inst_62987);
var inst_62989 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_62974,inst_62988,private$);
var inst_62990 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62989);
var state_63005__$1 = state_63005;
var statearr_63010_63041 = state_63005__$1;
(statearr_63010_63041[(2)] = inst_62990);

(statearr_63010_63041[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (6))){
var inst_62960 = (state_63005[(9)]);
var state_63005__$1 = state_63005;
var statearr_63011_63042 = state_63005__$1;
(statearr_63011_63042[(2)] = inst_62960);

(statearr_63011_63042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (3))){
var inst_63003 = (state_63005[(2)]);
var state_63005__$1 = state_63005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63005__$1,inst_63003);
} else {
if((state_val_63006 === (12))){
var inst_62984 = (state_63005[(2)]);
var state_63005__$1 = (function (){var statearr_63012 = state_63005;
(statearr_63012[(8)] = inst_62984);

return statearr_63012;
})();
if(cljs.core.truth_(private$)){
var statearr_63013_63043 = state_63005__$1;
(statearr_63013_63043[(1)] = (13));

} else {
var statearr_63014_63044 = state_63005__$1;
(statearr_63014_63044[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (2))){
var inst_62960 = (state_63005[(9)]);
var _ = (function (){var statearr_63015 = state_63005;
(statearr_63015[(4)] = cljs.core.cons.call(null,(5),(state_63005[(4)])));

return statearr_63015;
})();
var inst_62960__$1 = jwt;
var state_63005__$1 = (function (){var statearr_63016 = state_63005;
(statearr_63016[(9)] = inst_62960__$1);

return statearr_63016;
})();
if(cljs.core.truth_(inst_62960__$1)){
var statearr_63017_63045 = state_63005__$1;
(statearr_63017_63045[(1)] = (6));

} else {
var statearr_63018_63046 = state_63005__$1;
(statearr_63018_63046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (11))){
var inst_62978 = (state_63005[(10)]);
var state_63005__$1 = state_63005;
var statearr_63020_63047 = state_63005__$1;
(statearr_63020_63047[(2)] = inst_62978);

(statearr_63020_63047[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (9))){
var inst_62970 = (state_63005[(11)]);
var inst_62969 = (state_63005[(12)]);
var inst_62973 = (state_63005[(2)]);
var inst_62974 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62973),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62970)].join('');
var inst_62976 = ["Accept"];
var inst_62977 = ["application/json"];
var inst_62978 = cljs.core.PersistentHashMap.fromArrays(inst_62976,inst_62977);
var state_63005__$1 = (function (){var statearr_63021 = state_63005;
(statearr_63021[(10)] = inst_62978);

(statearr_63021[(7)] = inst_62974);

return statearr_63021;
})();
if(cljs.core.truth_(inst_62969)){
var statearr_63022_63048 = state_63005__$1;
(statearr_63022_63048[(1)] = (10));

} else {
var statearr_63023_63049 = state_63005__$1;
(statearr_63023_63049[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (5))){
var _ = (function (){var statearr_63024 = state_63005;
(statearr_63024[(4)] = cljs.core.rest.call(null,(state_63005[(4)])));

return statearr_63024;
})();
var state_63005__$1 = state_63005;
var ex63019 = (state_63005__$1[(2)]);
var statearr_63025_63050 = state_63005__$1;
(statearr_63025_63050[(5)] = ex63019);


if((ex63019 instanceof Error)){
var statearr_63026_63051 = state_63005__$1;
(statearr_63026_63051[(1)] = (4));

(statearr_63026_63051[(5)] = null);

} else {
throw ex63019;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (14))){
var inst_62984 = (state_63005[(8)]);
var state_63005__$1 = state_63005;
var statearr_63027_63052 = state_63005__$1;
(statearr_63027_63052[(2)] = inst_62984);

(statearr_63027_63052[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (16))){
var inst_62999 = (state_63005[(2)]);
var inst_63000 = fluree.db.util.async.throw_err.call(null,inst_62999);
var _ = (function (){var statearr_63028 = state_63005;
(statearr_63028[(4)] = cljs.core.rest.call(null,(state_63005[(4)])));

return statearr_63028;
})();
var state_63005__$1 = state_63005;
var statearr_63029_63053 = state_63005__$1;
(statearr_63029_63053[(2)] = inst_63000);

(statearr_63029_63053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (10))){
var inst_62978 = (state_63005[(10)]);
var inst_62969 = (state_63005[(12)]);
var inst_62980 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62969)].join('');
var inst_62981 = cljs.core.assoc.call(null,inst_62978,"Authorization",inst_62980);
var state_63005__$1 = state_63005;
var statearr_63030_63054 = state_63005__$1;
(statearr_63030_63054[(2)] = inst_62981);

(statearr_63030_63054[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63006 === (8))){
var inst_62969 = (state_63005[(2)]);
var inst_62970 = clojure.string.replace.call(null,k,"_","/");
var inst_62971 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_63005__$1 = (function (){var statearr_63031 = state_63005;
(statearr_63031[(11)] = inst_62970);

(statearr_63031[(12)] = inst_62969);

return statearr_63031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63005__$1,(9),inst_62971);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_63032 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63032[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_63032[(1)] = (1));

return statearr_63032;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_63005){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63033){var ex__2749__auto__ = e63033;
var statearr_63034_63055 = state_63005;
(statearr_63034_63055[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63005[(4)]))){
var statearr_63035_63056 = state_63005;
(statearr_63035_63056[(1)] = cljs.core.first.call(null,(state_63005[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63057 = state_63005;
state_63005 = G__63057;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_63005){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_63005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63036 = f__2769__auto__.call(null);
(statearr_63036[(6)] = c__2768__auto__);

return statearr_63036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63058_SHARP_){
if(cljs.core.truth_(p1__63058_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__63059_SHARP_){
var or__5045__auto__ = p1__63059_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e63060){var e = e63060;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63061 = opts;
var map__63061__$1 = cljs.core.__destructure_map.call(null,map__63061);
var sub_chan = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__63061__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63102 = arguments.length;
var i__5770__auto___63103 = (0);
while(true){
if((i__5770__auto___63103 < len__5769__auto___63102)){
args__5775__auto__.push((arguments[i__5770__auto___63103]));

var G__63104 = (i__5770__auto___63103 + (1));
i__5770__auto___63103 = G__63104;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63064){
var vec__63065 = p__63064;
var opts = cljs.core.nth.call(null,vec__63065,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2768__auto___63105 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63085){
var state_val_63086 = (state_63085[(1)]);
if((state_val_63086 === (1))){
var inst_63068 = fluree.db.connection.get_socket.call(null,conn);
var state_63085__$1 = state_63085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63085__$1,(2),inst_63068);
} else {
if((state_val_63086 === (2))){
var inst_63071 = (state_63085[(7)]);
var inst_63070 = (state_63085[(8)]);
var inst_63070__$1 = (state_63085[(2)]);
var inst_63071__$1 = (inst_63070__$1 == null);
var state_63085__$1 = (function (){var statearr_63087 = state_63085;
(statearr_63087[(7)] = inst_63071__$1);

(statearr_63087[(8)] = inst_63070__$1);

return statearr_63087;
})();
if(cljs.core.truth_(inst_63071__$1)){
var statearr_63088_63106 = state_63085__$1;
(statearr_63088_63106[(1)] = (3));

} else {
var statearr_63089_63107 = state_63085__$1;
(statearr_63089_63107[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63086 === (3))){
var inst_63071 = (state_63085[(7)]);
var state_63085__$1 = state_63085;
var statearr_63090_63108 = state_63085__$1;
(statearr_63090_63108[(2)] = inst_63071);

(statearr_63090_63108[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63086 === (4))){
var inst_63070 = (state_63085[(8)]);
var inst_63074 = fluree.db.util.core.exception_QMARK_.call(null,inst_63070);
var state_63085__$1 = state_63085;
var statearr_63091_63109 = state_63085__$1;
(statearr_63091_63109[(2)] = inst_63074);

(statearr_63091_63109[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63086 === (5))){
var inst_63076 = (state_63085[(2)]);
var state_63085__$1 = state_63085;
if(cljs.core.truth_(inst_63076)){
var statearr_63092_63110 = state_63085__$1;
(statearr_63092_63110[(1)] = (6));

} else {
var statearr_63093_63111 = state_63085__$1;
(statearr_63093_63111[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63086 === (6))){
var inst_63070 = (state_63085[(8)]);
var inst_63078 = fluree.db.util.log.error.call(null,inst_63070,"Cannot establish connection to a healthy server, disconnecting.");
var inst_63079 = cljs.core.async.close_BANG_.call(null,conn);
var state_63085__$1 = (function (){var statearr_63094 = state_63085;
(statearr_63094[(9)] = inst_63078);

return statearr_63094;
})();
var statearr_63095_63112 = state_63085__$1;
(statearr_63095_63112[(2)] = inst_63079);

(statearr_63095_63112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63086 === (7))){
var inst_63081 = fluree.db.connection.msg_consumer.call(null,conn);
var state_63085__$1 = state_63085;
var statearr_63096_63113 = state_63085__$1;
(statearr_63096_63113[(2)] = inst_63081);

(statearr_63096_63113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63086 === (8))){
var inst_63083 = (state_63085[(2)]);
var state_63085__$1 = state_63085;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63085__$1,inst_63083);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_63097 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63097[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_63097[(1)] = (1));

return statearr_63097;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_63085){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63098){var ex__2749__auto__ = e63098;
var statearr_63099_63114 = state_63085;
(statearr_63099_63114[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63085[(4)]))){
var statearr_63100_63115 = state_63085;
(statearr_63100_63115[(1)] = cljs.core.first.call(null,(state_63085[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63116 = state_63085;
state_63085 = G__63116;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_63085){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_63085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63101 = f__2769__auto__.call(null);
(statearr_63101[(6)] = c__2768__auto___63105);

return statearr_63101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63062){
var G__63063 = cljs.core.first.call(null,seq63062);
var seq63062__$1 = cljs.core.next.call(null,seq63062);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63063,seq63062__$1);
}));

