// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ttl","ttl",-1115275118),(5000));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.call(null,fluree.db.dbfunctions.core.db_fn_cache_factory.call(null));
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_.call(null,fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory.call(null));
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__5043__auto__ = typeof value === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,value);
} else {
return and__5043__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.Symbol(null,"follow","follow",831213865,null),new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null)],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,302,null,302,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,1,715,null,715,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,1,522,null,522,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,428,null,428,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,389,null,389,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,727,null,727,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,534,null,534,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._SLASH_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,608,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,621,null,621,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,779,null,779,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,1,697,null,697,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,415,null,415,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,467,null,467,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,789,null,789,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,569,null,569,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,660,null,660,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,454,null,454,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,595,null,595,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",20,1,507,null,507,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,1,334,null,334,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,559,null,559,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,1,801,null,801,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,441,null,441,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,402,null,402,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,582,null,582,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",16,1,348,null,348,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,362,null,362,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,1,685,null,685,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,634,null,634,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,647,null,647,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,480,null,480,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,1,290,null,290,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,672,null,672,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__57590 = cljs.core.meta.call(null,f);
var map__57590__$1 = cljs.core.__destructure_map.call(null,map__57590);
var spec = cljs.core.get.call(null,map__57590__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
var arglists = cljs.core.get.call(null,map__57590__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var arglist = cljs.core.first.call(null,arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__5043__auto__ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,arglist).call(null,cljs.core.symbol.call(null,"&"));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,arglist).call(null,cljs.core.symbol.call(null,"args"));
} else {
return and__5043__auto__;
}
})();
var arity = ((cljs.core.not.call(null,_AMPERSAND_args_QMARK_))?cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,(function (p1__57589_SHARP_){
return (cljs.core.count.call(null,p1__57589_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"f","f",-1597136552),f,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"&args?","&args?",-1736256945),_AMPERSAND_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"code","code",1586293142),null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,fun,null,(1),null))))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57675){
var state_val_57676 = (state_57675[(1)]);
if((state_val_57676 === (7))){
var inst_57600 = cljs.core.deref.call(null,fluree.db.dbfunctions.core.db_fn_cache);
var inst_57601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57602 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(db);
var inst_57603 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_57604 = [fn_name,inst_57602,inst_57603];
var inst_57605 = (new cljs.core.PersistentVector(null,3,(5),inst_57601,inst_57604,null));
var inst_57606 = cljs.core.get.call(null,inst_57600,inst_57605);
var state_57675__$1 = state_57675;
var statearr_57677_57714 = state_57675__$1;
(statearr_57677_57714[(2)] = inst_57606);

(statearr_57677_57714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (1))){
var state_57675__$1 = state_57675;
var statearr_57678_57715 = state_57675__$1;
(statearr_57678_57715[(2)] = null);

(statearr_57678_57715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (4))){
var inst_57591 = (state_57675[(2)]);
var state_57675__$1 = state_57675;
var statearr_57679_57716 = state_57675__$1;
(statearr_57679_57716[(2)] = inst_57591);

(statearr_57679_57716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (15))){
var inst_57624 = (state_57675[(7)]);
var inst_57638 = (state_57675[(8)]);
var inst_57636 = (state_57675[(2)]);
var inst_57637 = cljs.core.get.call(null,inst_57624,"_fn/params");
var inst_57638__$1 = cljs.reader.read_string.call(null,inst_57637);
var inst_57639 = cljs.core.get.call(null,inst_57624,"_fn/code");
var inst_57640 = cljs.reader.read_string.call(null,inst_57639);
var inst_57641 = fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_57640,funType,inst_57638__$1);
var state_57675__$1 = (function (){var statearr_57680 = state_57675;
(statearr_57680[(8)] = inst_57638__$1);

(statearr_57680[(9)] = inst_57636);

return statearr_57680;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57675__$1,(16),inst_57641);
} else {
if((state_val_57676 === (13))){
var inst_57627 = cljs.core.pr_str.call(null,fn_name);
var inst_57628 = ["Unknown function: ",inst_57627].join('');
var inst_57629 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_57630 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_57631 = cljs.core.PersistentHashMap.fromArrays(inst_57629,inst_57630);
var inst_57632 = cljs.core.ex_info.call(null,inst_57628,inst_57631);
var inst_57633 = (function(){throw inst_57632})();
var state_57675__$1 = state_57675;
var statearr_57681_57717 = state_57675__$1;
(statearr_57681_57717[(2)] = inst_57633);

(statearr_57681_57717[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (6))){
var state_57675__$1 = state_57675;
var statearr_57682_57718 = state_57675__$1;
(statearr_57682_57718[(2)] = null);

(statearr_57682_57718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (17))){
var state_57675__$1 = state_57675;
var statearr_57683_57719 = state_57675__$1;
(statearr_57683_57719[(2)] = null);

(statearr_57683_57719[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (3))){
var inst_57673 = (state_57675[(2)]);
var state_57675__$1 = state_57675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57675__$1,inst_57673);
} else {
if((state_val_57676 === (12))){
var inst_57624 = (state_57675[(7)]);
var inst_57623 = (state_57675[(2)]);
var inst_57624__$1 = fluree.db.util.async.throw_err.call(null,inst_57623);
var inst_57625 = cljs.core.empty_QMARK_.call(null,inst_57624__$1);
var state_57675__$1 = (function (){var statearr_57684 = state_57675;
(statearr_57684[(7)] = inst_57624__$1);

return statearr_57684;
})();
if(inst_57625){
var statearr_57685_57720 = state_57675__$1;
(statearr_57685_57720[(1)] = (13));

} else {
var statearr_57686_57721 = state_57675__$1;
(statearr_57686_57721[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (2))){
var inst_57597 = (state_57675[(10)]);
var _ = (function (){var statearr_57687 = state_57675;
(statearr_57687[(4)] = cljs.core.cons.call(null,(5),(state_57675[(4)])));

return statearr_57687;
})();
var inst_57597__$1 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var state_57675__$1 = (function (){var statearr_57688 = state_57675;
(statearr_57688[(10)] = inst_57597__$1);

return statearr_57688;
})();
if(cljs.core.truth_(inst_57597__$1)){
var statearr_57689_57722 = state_57675__$1;
(statearr_57689_57722[(1)] = (6));

} else {
var statearr_57690_57723 = state_57675__$1;
(statearr_57690_57723[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (19))){
var inst_57658 = (state_57675[(11)]);
var inst_57668 = (state_57675[(2)]);
var state_57675__$1 = (function (){var statearr_57691 = state_57675;
(statearr_57691[(12)] = inst_57668);

return statearr_57691;
})();
var statearr_57692_57724 = state_57675__$1;
(statearr_57692_57724[(2)] = inst_57658);

(statearr_57692_57724[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (11))){
var inst_57670 = (state_57675[(2)]);
var _ = (function (){var statearr_57694 = state_57675;
(statearr_57694[(4)] = cljs.core.rest.call(null,(state_57675[(4)])));

return statearr_57694;
})();
var state_57675__$1 = state_57675;
var statearr_57695_57725 = state_57675__$1;
(statearr_57695_57725[(2)] = inst_57670);

(statearr_57695_57725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (9))){
var inst_57608 = (state_57675[(13)]);
var state_57675__$1 = state_57675;
var statearr_57696_57726 = state_57675__$1;
(statearr_57696_57726[(2)] = inst_57608);

(statearr_57696_57726[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (5))){
var _ = (function (){var statearr_57697 = state_57675;
(statearr_57697[(4)] = cljs.core.rest.call(null,(state_57675[(4)])));

return statearr_57697;
})();
var state_57675__$1 = state_57675;
var ex57693 = (state_57675__$1[(2)]);
var statearr_57698_57727 = state_57675__$1;
(statearr_57698_57727[(5)] = ex57693);


if((ex57693 instanceof Error)){
var statearr_57699_57728 = state_57675__$1;
(statearr_57699_57728[(1)] = (4));

(statearr_57699_57728[(5)] = null);

} else {
throw ex57693;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (14))){
var state_57675__$1 = state_57675;
var statearr_57700_57729 = state_57675__$1;
(statearr_57700_57729[(2)] = null);

(statearr_57700_57729[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (16))){
var inst_57624 = (state_57675[(7)]);
var inst_57638 = (state_57675[(8)]);
var inst_57597 = (state_57675[(10)]);
var inst_57608 = (state_57675[(13)]);
var inst_57636 = (state_57675[(9)]);
var inst_57620 = (state_57675[(14)]);
var inst_57643 = (state_57675[(2)]);
var inst_57644 = fluree.db.util.async.throw_err.call(null,inst_57643);
var inst_57645 = cljs.core.get.call(null,inst_57624,"_fn/spec");
var inst_57646 = cljs.core.PersistentVector.EMPTY;
var inst_57647 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_57648 = (function (){var forward_time_travel_db_QMARK_ = inst_57597;
var or__5045__auto__ = inst_57608;
var query = inst_57620;
var res = inst_57624;
var _ = inst_57636;
var params = inst_57638;
var code = inst_57644;
var spec = inst_57645;
return (function (x){
return cljs.core.symbol.call(null,x);
});
})();
var inst_57649 = cljs.core.mapv.call(null,inst_57648,inst_57638);
var inst_57650 = cljs.core.cons.call(null,inst_57647,inst_57649);
var inst_57651 = cljs.core.into.call(null,inst_57646,inst_57650);
var inst_57652 = fluree.db.dbfunctions.core.build_fn.call(null,inst_57651,inst_57644);
var inst_57653 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"&args?","&args?",-1736256945),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_57654 = cljs.core.count.call(null,inst_57638);
var inst_57655 = [inst_57654];
var inst_57656 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_57655);
var inst_57657 = [inst_57652,inst_57638,inst_57656,false,inst_57645,null];
var inst_57658 = cljs.core.PersistentHashMap.fromArrays(inst_57653,inst_57657);
var state_57675__$1 = (function (){var statearr_57701 = state_57675;
(statearr_57701[(11)] = inst_57658);

return statearr_57701;
})();
if(cljs.core.truth_(inst_57597)){
var statearr_57702_57730 = state_57675__$1;
(statearr_57702_57730[(1)] = (17));

} else {
var statearr_57703_57731 = state_57675__$1;
(statearr_57703_57731[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (10))){
var inst_57620 = (state_57675[(14)]);
var inst_57611 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_57612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57613 = ["_fn/params","_fn/code","_fn/spec"];
var inst_57614 = (new cljs.core.PersistentVector(null,3,(5),inst_57612,inst_57613,null));
var inst_57615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57616 = cljs.core.name.call(null,fn_name);
var inst_57617 = ["_fn/name",inst_57616];
var inst_57618 = (new cljs.core.PersistentVector(null,2,(5),inst_57615,inst_57617,null));
var inst_57619 = [inst_57614,inst_57618];
var inst_57620__$1 = cljs.core.PersistentHashMap.fromArrays(inst_57611,inst_57619);
var inst_57621 = fluree.db.dbproto._query.call(null,db,inst_57620__$1);
var state_57675__$1 = (function (){var statearr_57704 = state_57675;
(statearr_57704[(14)] = inst_57620__$1);

return statearr_57704;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57675__$1,(12),inst_57621);
} else {
if((state_val_57676 === (18))){
var inst_57658 = (state_57675[(11)]);
var inst_57661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57662 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(db);
var inst_57663 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_57664 = [fn_name,inst_57662,inst_57663];
var inst_57665 = (new cljs.core.PersistentVector(null,3,(5),inst_57661,inst_57664,null));
var inst_57666 = cljs.core.swap_BANG_.call(null,fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_57665,inst_57658);
var state_57675__$1 = state_57675;
var statearr_57705_57732 = state_57675__$1;
(statearr_57705_57732[(2)] = inst_57666);

(statearr_57705_57732[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57676 === (8))){
var inst_57608 = (state_57675[(13)]);
var inst_57608__$1 = (state_57675[(2)]);
var state_57675__$1 = (function (){var statearr_57706 = state_57675;
(statearr_57706[(13)] = inst_57608__$1);

return statearr_57706;
})();
if(cljs.core.truth_(inst_57608__$1)){
var statearr_57707_57733 = state_57675__$1;
(statearr_57707_57733[(1)] = (9));

} else {
var statearr_57708_57734 = state_57675__$1;
(statearr_57708_57734[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto____0 = (function (){
var statearr_57709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57709[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto__);

(statearr_57709[(1)] = (1));

return statearr_57709;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto____1 = (function (state_57675){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57710){var ex__2749__auto__ = e57710;
var statearr_57711_57735 = state_57675;
(statearr_57711_57735[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57675[(4)]))){
var statearr_57712_57736 = state_57675;
(statearr_57712_57736[(1)] = cljs.core.first.call(null,(state_57675[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57737 = state_57675;
state_57675 = G__57737;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto__ = function(state_57675){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto____1.call(this,state_57675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57713 = f__2769__auto__.call(null);
(statearr_57713[(6)] = c__2768__auto__);

return statearr_57713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__57739 = arguments.length;
switch (G__57739) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.call(null,db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_.call(null,db,fn_name,funType);
} else {
throw cljs.core.ex_info.call(null,"DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count.call(null,fn_str_coll) > (1))){
return ["(and ",clojure.string.join.call(null," ",fn_str_coll),")"].join('');
} else {
return cljs.core.first.call(null,fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__57743 = arguments.length;
switch (G__57743) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.call(null,db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.call(null,db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57873){
var state_val_57874 = (state_57873[(1)]);
if((state_val_57874 === (7))){
var inst_57868 = (state_57873[(2)]);
var _ = (function (){var statearr_57875 = state_57873;
(statearr_57875[(4)] = cljs.core.rest.call(null,(state_57873[(4)])));

return statearr_57875;
})();
var state_57873__$1 = state_57873;
var statearr_57876_57956 = state_57873__$1;
(statearr_57876_57956[(2)] = inst_57868);

(statearr_57876_57956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (20))){
var inst_57782 = (state_57873[(7)]);
var state_57873__$1 = state_57873;
var statearr_57877_57957 = state_57873__$1;
(statearr_57877_57957[(2)] = inst_57782);

(statearr_57877_57957[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (27))){
var inst_57769 = (state_57873[(8)]);
var inst_57795 = cljs.core.pr_str.call(null,vec);
var inst_57796 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57769)," used in function.",inst_57795].join('');
var inst_57797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_57798 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_57799 = cljs.core.PersistentHashMap.fromArrays(inst_57797,inst_57798);
var inst_57800 = cljs.core.ex_info.call(null,inst_57796,inst_57799);
var inst_57801 = (function(){throw inst_57800})();
var state_57873__$1 = state_57873;
var statearr_57878_57958 = state_57873__$1;
(statearr_57878_57958[(2)] = inst_57801);

(statearr_57878_57958[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (1))){
var state_57873__$1 = state_57873;
var statearr_57879_57959 = state_57873__$1;
(statearr_57879_57959[(2)] = null);

(statearr_57879_57959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (24))){
var inst_57792 = (state_57873[(9)]);
var inst_57792__$1 = cljs.core._EQ_.call(null,funType,"functionDec");
var state_57873__$1 = (function (){var statearr_57880 = state_57873;
(statearr_57880[(9)] = inst_57792__$1);

return statearr_57880;
})();
if(inst_57792__$1){
var statearr_57881_57960 = state_57873__$1;
(statearr_57881_57960[(1)] = (26));

} else {
var statearr_57882_57961 = state_57873__$1;
(statearr_57882_57961[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (39))){
var inst_57769 = (state_57873[(8)]);
var inst_57829 = (inst_57769 == null);
var state_57873__$1 = state_57873;
if(cljs.core.truth_(inst_57829)){
var statearr_57883_57962 = state_57873__$1;
(statearr_57883_57962[(1)] = (42));

} else {
var statearr_57884_57963 = state_57873__$1;
(statearr_57884_57963[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (46))){
var state_57873__$1 = state_57873;
var statearr_57885_57964 = state_57873__$1;
(statearr_57885_57964[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (4))){
var inst_57744 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57887_57965 = state_57873__$1;
(statearr_57887_57965[(2)] = inst_57744);

(statearr_57887_57965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (15))){
var inst_57769 = (state_57873[(8)]);
var inst_57780 = (inst_57769 instanceof cljs.core.Symbol);
var state_57873__$1 = state_57873;
if(cljs.core.truth_(inst_57780)){
var statearr_57888_57966 = state_57873__$1;
(statearr_57888_57966[(1)] = (17));

} else {
var statearr_57889_57967 = state_57873__$1;
(statearr_57889_57967[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (48))){
var inst_57836 = (state_57873[(2)]);
var inst_57837 = fluree.db.util.async.throw_err.call(null,inst_57836);
var state_57873__$1 = state_57873;
var statearr_57890_57968 = state_57873__$1;
(statearr_57890_57968[(2)] = inst_57837);

(statearr_57890_57968[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (50))){
var state_57873__$1 = state_57873;
var statearr_57891_57969 = state_57873__$1;
(statearr_57891_57969[(2)] = null);

(statearr_57891_57969[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (21))){
var inst_57763 = (state_57873[(10)]);
var inst_57769 = (state_57873[(8)]);
var inst_57770 = (state_57873[(11)]);
var inst_57757 = (state_57873[(12)]);
var inst_57760 = (state_57873[(13)]);
var inst_57782 = (state_57873[(7)]);
var inst_57789 = (state_57873[(14)]);
var inst_57762 = (state_57873[(15)]);
var inst_57759 = (state_57873[(16)]);
var inst_57785 = [inst_57769];
var inst_57786 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_57785);
var inst_57787 = (function (){var x = inst_57769;
var first__57767 = inst_57769;
var or__5045__auto__ = inst_57782;
var seq__57766 = inst_57770;
var r = inst_57770;
var first__57756 = inst_57759;
var vec__57765 = inst_57762;
var acc = inst_57763;
var vec__57754 = inst_57757;
var seq__57755 = inst_57760;
var G__57753 = inst_57762;
return (function (p1__57741_SHARP_){
return cljs.core.symbol.call(null,p1__57741_SHARP_);
});
})();
var inst_57788 = cljs.core.mapv.call(null,inst_57787,params);
var inst_57789__$1 = cljs.core.some.call(null,inst_57786,inst_57788);
var state_57873__$1 = (function (){var statearr_57892 = state_57873;
(statearr_57892[(14)] = inst_57789__$1);

return statearr_57892;
})();
if(cljs.core.truth_(inst_57789__$1)){
var statearr_57893_57970 = state_57873__$1;
(statearr_57893_57970[(1)] = (23));

} else {
var statearr_57894_57971 = state_57873__$1;
(statearr_57894_57971[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (31))){
var inst_57819 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
if(cljs.core.truth_(inst_57819)){
var statearr_57895_57972 = state_57873__$1;
(statearr_57895_57972[(1)] = (35));

} else {
var statearr_57896_57973 = state_57873__$1;
(statearr_57896_57973[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (32))){
var inst_57812 = (state_57873[(17)]);
var state_57873__$1 = state_57873;
var statearr_57897_57974 = state_57873__$1;
(statearr_57897_57974[(2)] = inst_57812);

(statearr_57897_57974[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (40))){
var inst_57854 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57898_57975 = state_57873__$1;
(statearr_57898_57975[(2)] = inst_57854);

(statearr_57898_57975[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (33))){
var inst_57769 = (state_57873[(8)]);
var inst_57815 = (inst_57769 == null);
var state_57873__$1 = state_57873;
var statearr_57899_57976 = state_57873__$1;
(statearr_57899_57976[(2)] = inst_57815);

(statearr_57899_57976[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (13))){
var inst_57763 = (state_57873[(10)]);
var inst_57770 = (state_57873[(11)]);
var inst_57862 = (state_57873[(2)]);
var inst_57863 = cljs.core.conj.call(null,inst_57763,inst_57862);
var inst_57762 = inst_57770;
var inst_57763__$1 = inst_57863;
var state_57873__$1 = (function (){var statearr_57900 = state_57873;
(statearr_57900[(10)] = inst_57763__$1);

(statearr_57900[(15)] = inst_57762);

return statearr_57900;
})();
var statearr_57901_57977 = state_57873__$1;
(statearr_57901_57977[(2)] = null);

(statearr_57901_57977[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (22))){
var inst_57807 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57902_57978 = state_57873__$1;
(statearr_57902_57978[(2)] = inst_57807);

(statearr_57902_57978[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (36))){
var inst_57769 = (state_57873[(8)]);
var inst_57822 = cljs.core.vector_QMARK_.call(null,inst_57769);
var state_57873__$1 = state_57873;
if(inst_57822){
var statearr_57903_57979 = state_57873__$1;
(statearr_57903_57979[(1)] = (38));

} else {
var statearr_57904_57980 = state_57873__$1;
(statearr_57904_57980[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (41))){
var inst_57826 = (state_57873[(2)]);
var inst_57827 = fluree.db.util.async.throw_err.call(null,inst_57826);
var state_57873__$1 = state_57873;
var statearr_57905_57981 = state_57873__$1;
(statearr_57905_57981[(2)] = inst_57827);

(statearr_57905_57981[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (43))){
var inst_57769 = (state_57873[(8)]);
var inst_57832 = cljs.core.list_QMARK_.call(null,inst_57769);
var state_57873__$1 = state_57873;
if(inst_57832){
var statearr_57906_57982 = state_57873__$1;
(statearr_57906_57982[(1)] = (45));

} else {
var statearr_57907_57983 = state_57873__$1;
(statearr_57907_57983[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (29))){
var inst_57809 = (state_57873[(18)]);
var state_57873__$1 = state_57873;
var statearr_57908_57984 = state_57873__$1;
(statearr_57908_57984[(2)] = inst_57809);

(statearr_57908_57984[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (44))){
var inst_57852 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57909_57985 = state_57873__$1;
(statearr_57909_57985[(2)] = inst_57852);

(statearr_57909_57985[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (6))){
var inst_57769 = (state_57873[(8)]);
var inst_57762 = (state_57873[(15)]);
var inst_57768 = cljs.core.seq.call(null,inst_57762);
var inst_57769__$1 = cljs.core.first.call(null,inst_57768);
var inst_57770 = cljs.core.next.call(null,inst_57768);
var inst_57771 = (inst_57769__$1 == null);
var state_57873__$1 = (function (){var statearr_57910 = state_57873;
(statearr_57910[(8)] = inst_57769__$1);

(statearr_57910[(11)] = inst_57770);

return statearr_57910;
})();
if(cljs.core.truth_(inst_57771)){
var statearr_57911_57986 = state_57873__$1;
(statearr_57911_57986[(1)] = (8));

} else {
var statearr_57912_57987 = state_57873__$1;
(statearr_57912_57987[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (28))){
var inst_57803 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57913_57988 = state_57873__$1;
(statearr_57913_57988[(2)] = inst_57803);

(statearr_57913_57988[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (51))){
var inst_57848 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57914_57989 = state_57873__$1;
(statearr_57914_57989[(2)] = inst_57848);

(statearr_57914_57989[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (25))){
var inst_57805 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57915_57990 = state_57873__$1;
(statearr_57915_57990[(2)] = inst_57805);

(statearr_57915_57990[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (34))){
var inst_57817 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57916_57991 = state_57873__$1;
(statearr_57916_57991[(2)] = inst_57817);

(statearr_57916_57991[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (17))){
var inst_57769 = (state_57873[(8)]);
var inst_57782 = (state_57873[(7)]);
var inst_57782__$1 = fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_57769);
var state_57873__$1 = (function (){var statearr_57917 = state_57873;
(statearr_57917[(7)] = inst_57782__$1);

return statearr_57917;
})();
if(cljs.core.truth_(inst_57782__$1)){
var statearr_57918_57992 = state_57873__$1;
(statearr_57918_57992[(1)] = (20));

} else {
var statearr_57919_57993 = state_57873__$1;
(statearr_57919_57993[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (3))){
var inst_57871 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57873__$1,inst_57871);
} else {
if((state_val_57874 === (12))){
var inst_57769 = (state_57873[(8)]);
var inst_57777 = typeof inst_57769 === 'number';
var state_57873__$1 = state_57873;
if(cljs.core.truth_(inst_57777)){
var statearr_57920_57994 = state_57873__$1;
(statearr_57920_57994[(1)] = (14));

} else {
var statearr_57921_57995 = state_57873__$1;
(statearr_57921_57995[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (2))){
var inst_57757 = (state_57873[(12)]);
var _ = (function (){var statearr_57922 = state_57873;
(statearr_57922[(4)] = cljs.core.cons.call(null,(5),(state_57873[(4)])));

return statearr_57922;
})();
var inst_57757__$1 = vec;
var inst_57758 = cljs.core.seq.call(null,inst_57757__$1);
var inst_57759 = cljs.core.first.call(null,inst_57758);
var inst_57760 = cljs.core.next.call(null,inst_57758);
var inst_57761 = cljs.core.PersistentVector.EMPTY;
var inst_57762 = inst_57757__$1;
var inst_57763 = inst_57761;
var state_57873__$1 = (function (){var statearr_57923 = state_57873;
(statearr_57923[(10)] = inst_57763);

(statearr_57923[(12)] = inst_57757__$1);

(statearr_57923[(13)] = inst_57760);

(statearr_57923[(15)] = inst_57762);

(statearr_57923[(16)] = inst_57759);

return statearr_57923;
})();
var statearr_57924_57996 = state_57873__$1;
(statearr_57924_57996[(2)] = null);

(statearr_57924_57996[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (23))){
var inst_57789 = (state_57873[(14)]);
var state_57873__$1 = state_57873;
var statearr_57925_57997 = state_57873__$1;
(statearr_57925_57997[(2)] = inst_57789);

(statearr_57925_57997[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (47))){
var inst_57850 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57926_57998 = state_57873__$1;
(statearr_57926_57998[(2)] = inst_57850);

(statearr_57926_57998[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (35))){
var inst_57769 = (state_57873[(8)]);
var state_57873__$1 = state_57873;
var statearr_57927_57999 = state_57873__$1;
(statearr_57927_57999[(2)] = inst_57769);

(statearr_57927_57999[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (19))){
var inst_57858 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57928_58000 = state_57873__$1;
(statearr_57928_58000[(2)] = inst_57858);

(statearr_57928_58000[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (11))){
var inst_57769 = (state_57873[(8)]);
var state_57873__$1 = state_57873;
var statearr_57930_58001 = state_57873__$1;
(statearr_57930_58001[(2)] = inst_57769);

(statearr_57930_58001[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (9))){
var inst_57769 = (state_57873[(8)]);
var inst_57774 = typeof inst_57769 === 'string';
var state_57873__$1 = state_57873;
if(cljs.core.truth_(inst_57774)){
var statearr_57931_58002 = state_57873__$1;
(statearr_57931_58002[(1)] = (11));

} else {
var statearr_57932_58003 = state_57873__$1;
(statearr_57932_58003[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (5))){
var _ = (function (){var statearr_57933 = state_57873;
(statearr_57933[(4)] = cljs.core.rest.call(null,(state_57873[(4)])));

return statearr_57933;
})();
var state_57873__$1 = state_57873;
var ex57929 = (state_57873__$1[(2)]);
var statearr_57934_58004 = state_57873__$1;
(statearr_57934_58004[(5)] = ex57929);


if((ex57929 instanceof Error)){
var statearr_57935_58005 = state_57873__$1;
(statearr_57935_58005[(1)] = (4));

(statearr_57935_58005[(5)] = null);

} else {
throw ex57929;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (14))){
var inst_57769 = (state_57873[(8)]);
var state_57873__$1 = state_57873;
var statearr_57936_58006 = state_57873__$1;
(statearr_57936_58006[(2)] = inst_57769);

(statearr_57936_58006[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (45))){
var inst_57769 = (state_57873[(8)]);
var inst_57834 = fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_57769,funType,params);
var state_57873__$1 = state_57873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57873__$1,(48),inst_57834);
} else {
if((state_val_57874 === (26))){
var inst_57792 = (state_57873[(9)]);
var state_57873__$1 = state_57873;
var statearr_57937_58007 = state_57873__$1;
(statearr_57937_58007[(2)] = inst_57792);

(statearr_57937_58007[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (16))){
var inst_57860 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57938_58008 = state_57873__$1;
(statearr_57938_58008[(2)] = inst_57860);

(statearr_57938_58008[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (38))){
var inst_57769 = (state_57873[(8)]);
var inst_57824 = fluree.db.dbfunctions.core.parse_vector.call(null,db,inst_57769,funType,params);
var state_57873__$1 = state_57873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57873__$1,(41),inst_57824);
} else {
if((state_val_57874 === (30))){
var inst_57769 = (state_57873[(8)]);
var inst_57812 = (state_57873[(17)]);
var inst_57812__$1 = inst_57769 === false;
var state_57873__$1 = (function (){var statearr_57939 = state_57873;
(statearr_57939[(17)] = inst_57812__$1);

return statearr_57939;
})();
if(cljs.core.truth_(inst_57812__$1)){
var statearr_57940_58009 = state_57873__$1;
(statearr_57940_58009[(1)] = (32));

} else {
var statearr_57941_58010 = state_57873__$1;
(statearr_57941_58010[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (10))){
var inst_57866 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57942_58011 = state_57873__$1;
(statearr_57942_58011[(2)] = inst_57866);

(statearr_57942_58011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (18))){
var inst_57769 = (state_57873[(8)]);
var inst_57809 = (state_57873[(18)]);
var inst_57809__$1 = inst_57769 === true;
var state_57873__$1 = (function (){var statearr_57943 = state_57873;
(statearr_57943[(18)] = inst_57809__$1);

return statearr_57943;
})();
if(cljs.core.truth_(inst_57809__$1)){
var statearr_57944_58012 = state_57873__$1;
(statearr_57944_58012[(1)] = (29));

} else {
var statearr_57945_58013 = state_57873__$1;
(statearr_57945_58013[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (42))){
var inst_57769 = (state_57873[(8)]);
var state_57873__$1 = state_57873;
var statearr_57946_58014 = state_57873__$1;
(statearr_57946_58014[(2)] = inst_57769);

(statearr_57946_58014[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (37))){
var inst_57856 = (state_57873[(2)]);
var state_57873__$1 = state_57873;
var statearr_57947_58015 = state_57873__$1;
(statearr_57947_58015[(2)] = inst_57856);

(statearr_57947_58015[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (8))){
var inst_57763 = (state_57873[(10)]);
var state_57873__$1 = state_57873;
var statearr_57948_58016 = state_57873__$1;
(statearr_57948_58016[(2)] = inst_57763);

(statearr_57948_58016[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57874 === (49))){
var inst_57769 = (state_57873[(8)]);
var inst_57840 = cljs.core.pr_str.call(null,inst_57769);
var inst_57841 = cljs.core.pr_str.call(null,vec);
var inst_57842 = ["Illegal element (",inst_57840,") in vector: ",inst_57841,"."].join('');
var inst_57843 = cljs.core.PersistentHashMap.EMPTY;
var inst_57844 = cljs.core.ex_info.call(null,inst_57842,inst_57843);
var inst_57845 = (function(){throw inst_57844})();
var state_57873__$1 = state_57873;
var statearr_57949_58017 = state_57873__$1;
(statearr_57949_58017[(2)] = inst_57845);

(statearr_57949_58017[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_57950 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57950[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_57950[(1)] = (1));

return statearr_57950;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_57873){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57951){var ex__2749__auto__ = e57951;
var statearr_57952_58018 = state_57873;
(statearr_57952_58018[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57873[(4)]))){
var statearr_57953_58019 = state_57873;
(statearr_57953_58019[(1)] = cljs.core.first.call(null,(state_57873[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58020 = state_57873;
state_57873 = G__58020;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_57873){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_57873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57954 = f__2769__auto__.call(null);
(statearr_57954[(6)] = c__2768__auto__);

return statearr_57954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5804__auto__ = cljs.core.get.call(null,fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.call(null,fn_name));
if(cljs.core.truth_(temp__5804__auto__)){
var local_fn = temp__5804__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn.call(null,local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize.call(null,fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__58023 = arguments.length;
switch (G__58023) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.call(null,db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.call(null,db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_58187){
var state_val_58188 = (state_58187[(1)]);
if((state_val_58188 === (7))){
var inst_58031 = (state_58187[(7)]);
var inst_58037 = fluree.db.dbfunctions.core.find_fn.call(null,db,inst_58031,type);
var state_58187__$1 = state_58187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58187__$1,(9),inst_58037);
} else {
if((state_val_58188 === (59))){
var inst_58080 = (state_58187[(8)]);
var inst_58151 = cljs.core.pr_str.call(null,inst_58080);
var inst_58152 = type.call(null,inst_58080);
var inst_58153 = cljs.core.pr_str.call(null,form);
var inst_58154 = ["Illegal element (",inst_58151,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58152),") in function argument: ",inst_58153,"."].join('');
var inst_58155 = cljs.core.PersistentHashMap.EMPTY;
var inst_58156 = cljs.core.ex_info.call(null,inst_58154,inst_58155);
var inst_58157 = (function(){throw inst_58156})();
var state_58187__$1 = state_58187;
var statearr_58189_58284 = state_58187__$1;
(statearr_58189_58284[(2)] = inst_58157);

(statearr_58189_58284[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (20))){
var inst_58086 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
if(cljs.core.truth_(inst_58086)){
var statearr_58190_58285 = state_58187__$1;
(statearr_58190_58285[(1)] = (21));

} else {
var statearr_58191_58286 = state_58187__$1;
(statearr_58191_58286[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (58))){
var inst_58147 = (state_58187[(2)]);
var inst_58148 = fluree.db.util.async.throw_err.call(null,inst_58147);
var state_58187__$1 = state_58187;
var statearr_58192_58287 = state_58187__$1;
(statearr_58192_58287[(2)] = inst_58148);

(statearr_58192_58287[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (60))){
var state_58187__$1 = state_58187;
var statearr_58193_58288 = state_58187__$1;
(statearr_58193_58288[(2)] = null);

(statearr_58193_58288[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (27))){
var inst_58092 = (state_58187[(2)]);
var inst_58093 = fluree.db.util.async.throw_err.call(null,inst_58092);
var state_58187__$1 = state_58187;
var statearr_58194_58289 = state_58187__$1;
(statearr_58194_58289[(2)] = inst_58093);

(statearr_58194_58289[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (1))){
var state_58187__$1 = state_58187;
var statearr_58195_58290 = state_58187__$1;
(statearr_58195_58290[(2)] = null);

(statearr_58195_58290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (24))){
var inst_58080 = (state_58187[(8)]);
var inst_58090 = fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_58080,type,params);
var state_58187__$1 = state_58187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58187__$1,(27),inst_58090);
} else {
if((state_val_58188 === (55))){
var inst_58080 = (state_58187[(8)]);
var inst_58145 = fluree.db.dbfunctions.core.parse_vector.call(null,db,inst_58080,type,params);
var state_58187__$1 = state_58187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58187__$1,(58),inst_58145);
} else {
if((state_val_58188 === (39))){
var inst_58128 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58196_58291 = state_58187__$1;
(statearr_58196_58291[(2)] = inst_58128);

(statearr_58196_58291[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (46))){
var inst_58130 = (state_58187[(9)]);
var state_58187__$1 = state_58187;
var statearr_58197_58292 = state_58187__$1;
(statearr_58197_58292[(2)] = inst_58130);

(statearr_58197_58292[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (4))){
var inst_58024 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58198_58293 = state_58187__$1;
(statearr_58198_58293[(2)] = inst_58024);

(statearr_58198_58293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (54))){
var inst_58164 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58199_58294 = state_58187__$1;
(statearr_58199_58294[(2)] = inst_58164);

(statearr_58199_58294[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (15))){
var inst_58032 = (state_58187[(10)]);
var inst_58061 = (state_58187[(2)]);
var inst_58069 = cljs.core.seq.call(null,inst_58032);
var inst_58070 = cljs.core.first.call(null,inst_58069);
var inst_58071 = cljs.core.next.call(null,inst_58069);
var inst_58072 = cljs.core.PersistentVector.EMPTY;
var inst_58073 = inst_58032;
var inst_58074 = inst_58072;
var state_58187__$1 = (function (){var statearr_58200 = state_58187;
(statearr_58200[(11)] = inst_58061);

(statearr_58200[(12)] = inst_58074);

(statearr_58200[(13)] = inst_58070);

(statearr_58200[(14)] = inst_58071);

(statearr_58200[(15)] = inst_58073);

return statearr_58200;
})();
var statearr_58201_58295 = state_58187__$1;
(statearr_58201_58295[(2)] = null);

(statearr_58201_58295[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (48))){
var inst_58140 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
if(cljs.core.truth_(inst_58140)){
var statearr_58202_58296 = state_58187__$1;
(statearr_58202_58296[(1)] = (52));

} else {
var statearr_58203_58297 = state_58187__$1;
(statearr_58203_58297[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (50))){
var inst_58080 = (state_58187[(8)]);
var inst_58136 = (inst_58080 == null);
var state_58187__$1 = state_58187;
var statearr_58204_58298 = state_58187__$1;
(statearr_58204_58298[(2)] = inst_58136);

(statearr_58204_58298[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (21))){
var inst_58080 = (state_58187[(8)]);
var inst_58088 = cljs.core.list_QMARK_.call(null,inst_58080);
var state_58187__$1 = state_58187;
if(inst_58088){
var statearr_58205_58299 = state_58187__$1;
(statearr_58205_58299[(1)] = (24));

} else {
var statearr_58206_58300 = state_58187__$1;
(statearr_58206_58300[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (31))){
var inst_58080 = (state_58187[(8)]);
var state_58187__$1 = state_58187;
var statearr_58207_58301 = state_58187__$1;
(statearr_58207_58301[(2)] = inst_58080);

(statearr_58207_58301[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (32))){
var inst_58080 = (state_58187[(8)]);
var inst_58101 = (inst_58080 instanceof cljs.core.Symbol);
var state_58187__$1 = state_58187;
if(cljs.core.truth_(inst_58101)){
var statearr_58208_58302 = state_58187__$1;
(statearr_58208_58302[(1)] = (34));

} else {
var statearr_58209_58303 = state_58187__$1;
(statearr_58209_58303[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (40))){
var inst_58110 = (state_58187[(16)]);
var state_58187__$1 = state_58187;
var statearr_58210_58304 = state_58187__$1;
(statearr_58210_58304[(2)] = inst_58110);

(statearr_58210_58304[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (56))){
var state_58187__$1 = state_58187;
var statearr_58211_58305 = state_58187__$1;
(statearr_58211_58305[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (33))){
var inst_58168 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58213_58306 = state_58187__$1;
(statearr_58213_58306[(2)] = inst_58168);

(statearr_58213_58306[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (13))){
var inst_58033 = (state_58187[(17)]);
var inst_58031 = (state_58187[(7)]);
var inst_58045 = (state_58187[(18)]);
var inst_58055 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58031),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58045),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58033),"."].join('');
var inst_58056 = cljs.core.PersistentHashMap.EMPTY;
var inst_58057 = cljs.core.ex_info.call(null,inst_58055,inst_58056);
var inst_58058 = (function(){throw inst_58057})();
var state_58187__$1 = state_58187;
var statearr_58214_58307 = state_58187__$1;
(statearr_58214_58307[(2)] = inst_58058);

(statearr_58214_58307[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (22))){
var inst_58074 = (state_58187[(12)]);
var state_58187__$1 = state_58187;
var statearr_58215_58308 = state_58187__$1;
(statearr_58215_58308[(2)] = inst_58074);

(statearr_58215_58308[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (36))){
var inst_58166 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58216_58309 = state_58187__$1;
(statearr_58216_58309[(2)] = inst_58166);

(statearr_58216_58309[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (41))){
var inst_58113 = (state_58187[(19)]);
var inst_58113__$1 = cljs.core._EQ_.call(null,type,"functionDec");
var state_58187__$1 = (function (){var statearr_58217 = state_58187;
(statearr_58217[(19)] = inst_58113__$1);

return statearr_58217;
})();
if(inst_58113__$1){
var statearr_58218_58310 = state_58187__$1;
(statearr_58218_58310[(1)] = (43));

} else {
var statearr_58219_58311 = state_58187__$1;
(statearr_58219_58311[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (43))){
var inst_58113 = (state_58187[(19)]);
var state_58187__$1 = state_58187;
var statearr_58220_58312 = state_58187__$1;
(statearr_58220_58312[(2)] = inst_58113);

(statearr_58220_58312[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (61))){
var inst_58160 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58221_58313 = state_58187__$1;
(statearr_58221_58313[(2)] = inst_58160);

(statearr_58221_58313[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (29))){
var inst_58080 = (state_58187[(8)]);
var inst_58098 = typeof inst_58080 === 'number';
var state_58187__$1 = state_58187;
if(cljs.core.truth_(inst_58098)){
var statearr_58222_58314 = state_58187__$1;
(statearr_58222_58314[(1)] = (31));

} else {
var statearr_58223_58315 = state_58187__$1;
(statearr_58223_58315[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (44))){
var inst_58080 = (state_58187[(8)]);
var inst_58116 = cljs.core.pr_str.call(null,form);
var inst_58117 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58080)," used in function argument: ",inst_58116].join('');
var inst_58118 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58119 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_58120 = cljs.core.PersistentHashMap.fromArrays(inst_58118,inst_58119);
var inst_58121 = cljs.core.ex_info.call(null,inst_58117,inst_58120);
var inst_58122 = (function(){throw inst_58121})();
var state_58187__$1 = state_58187;
var statearr_58224_58316 = state_58187__$1;
(statearr_58224_58316[(2)] = inst_58122);

(statearr_58224_58316[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (6))){
var inst_58034 = (state_58187[(20)]);
var state_58187__$1 = state_58187;
var statearr_58225_58317 = state_58187__$1;
(statearr_58225_58317[(2)] = inst_58034);

(statearr_58225_58317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (28))){
var inst_58080 = (state_58187[(8)]);
var state_58187__$1 = state_58187;
var statearr_58226_58318 = state_58187__$1;
(statearr_58226_58318[(2)] = inst_58080);

(statearr_58226_58318[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (51))){
var inst_58138 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58227_58319 = state_58187__$1;
(statearr_58227_58319[(2)] = inst_58138);

(statearr_58227_58319[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (25))){
var inst_58080 = (state_58187[(8)]);
var inst_58095 = typeof inst_58080 === 'string';
var state_58187__$1 = state_58187;
if(cljs.core.truth_(inst_58095)){
var statearr_58228_58320 = state_58187__$1;
(statearr_58228_58320[(1)] = (28));

} else {
var statearr_58229_58321 = state_58187__$1;
(statearr_58229_58321[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (34))){
var inst_58080 = (state_58187[(8)]);
var inst_58103 = (state_58187[(21)]);
var inst_58103__$1 = fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_58080);
var state_58187__$1 = (function (){var statearr_58230 = state_58187;
(statearr_58230[(21)] = inst_58103__$1);

return statearr_58230;
})();
if(cljs.core.truth_(inst_58103__$1)){
var statearr_58231_58322 = state_58187__$1;
(statearr_58231_58322[(1)] = (37));

} else {
var statearr_58232_58323 = state_58187__$1;
(statearr_58232_58323[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (17))){
var inst_58044 = (state_58187[(22)]);
var inst_58179 = (state_58187[(2)]);
var inst_58180 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_58181 = cljs.core.cons.call(null,inst_58180,inst_58179);
var inst_58182 = cljs.core.cons.call(null,inst_58044,inst_58181);
var _ = (function (){var statearr_58233 = state_58187;
(statearr_58233[(4)] = cljs.core.rest.call(null,(state_58187[(4)])));

return statearr_58233;
})();
var state_58187__$1 = state_58187;
var statearr_58234_58324 = state_58187__$1;
(statearr_58234_58324[(2)] = inst_58182);

(statearr_58234_58324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (3))){
var inst_58185 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58187__$1,inst_58185);
} else {
if((state_val_58188 === (12))){
var inst_58052 = (state_58187[(2)]);
var inst_58053 = cljs.core.not.call(null,inst_58052);
var state_58187__$1 = state_58187;
if(inst_58053){
var statearr_58235_58325 = state_58187__$1;
(statearr_58235_58325[(1)] = (13));

} else {
var statearr_58236_58326 = state_58187__$1;
(statearr_58236_58326[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (2))){
var inst_58032 = (state_58187[(10)]);
var inst_58034 = (state_58187[(20)]);
var inst_58031 = (state_58187[(7)]);
var _ = (function (){var statearr_58237 = state_58187;
(statearr_58237[(4)] = cljs.core.cons.call(null,(5),(state_58187[(4)])));

return statearr_58237;
})();
var inst_58031__$1 = cljs.core.first.call(null,form);
var inst_58032__$1 = cljs.core.rest.call(null,form);
var inst_58033 = cljs.core.count.call(null,inst_58032__$1);
var inst_58034__$1 = fluree.db.dbfunctions.core.find_local_fn.call(null,inst_58031__$1);
var state_58187__$1 = (function (){var statearr_58238 = state_58187;
(statearr_58238[(17)] = inst_58033);

(statearr_58238[(10)] = inst_58032__$1);

(statearr_58238[(20)] = inst_58034__$1);

(statearr_58238[(7)] = inst_58031__$1);

return statearr_58238;
})();
if(cljs.core.truth_(inst_58034__$1)){
var statearr_58239_58327 = state_58187__$1;
(statearr_58239_58327[(1)] = (6));

} else {
var statearr_58240_58328 = state_58187__$1;
(statearr_58240_58328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (23))){
var inst_58177 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58241_58329 = state_58187__$1;
(statearr_58241_58329[(2)] = inst_58177);

(statearr_58241_58329[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (47))){
var inst_58080 = (state_58187[(8)]);
var inst_58133 = (state_58187[(23)]);
var inst_58133__$1 = inst_58080 === false;
var state_58187__$1 = (function (){var statearr_58242 = state_58187;
(statearr_58242[(23)] = inst_58133__$1);

return statearr_58242;
})();
if(cljs.core.truth_(inst_58133__$1)){
var statearr_58243_58330 = state_58187__$1;
(statearr_58243_58330[(1)] = (49));

} else {
var statearr_58244_58331 = state_58187__$1;
(statearr_58244_58331[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (35))){
var inst_58080 = (state_58187[(8)]);
var inst_58130 = (state_58187[(9)]);
var inst_58130__$1 = inst_58080 === true;
var state_58187__$1 = (function (){var statearr_58245 = state_58187;
(statearr_58245[(9)] = inst_58130__$1);

return statearr_58245;
})();
if(cljs.core.truth_(inst_58130__$1)){
var statearr_58246_58332 = state_58187__$1;
(statearr_58246_58332[(1)] = (46));

} else {
var statearr_58247_58333 = state_58187__$1;
(statearr_58247_58333[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (19))){
var inst_58080 = (state_58187[(8)]);
var inst_58084 = inst_58080 === false;
var state_58187__$1 = state_58187;
var statearr_58248_58334 = state_58187__$1;
(statearr_58248_58334[(2)] = inst_58084);

(statearr_58248_58334[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (57))){
var inst_58162 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58249_58335 = state_58187__$1;
(statearr_58249_58335[(2)] = inst_58162);

(statearr_58249_58335[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (11))){
var inst_58033 = (state_58187[(17)]);
var inst_58045 = (state_58187[(18)]);
var inst_58050 = inst_58045.call(null,inst_58033);
var state_58187__$1 = state_58187;
var statearr_58251_58336 = state_58187__$1;
(statearr_58251_58336[(2)] = inst_58050);

(statearr_58251_58336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (9))){
var inst_58039 = (state_58187[(2)]);
var inst_58040 = fluree.db.util.async.throw_err.call(null,inst_58039);
var state_58187__$1 = state_58187;
var statearr_58252_58337 = state_58187__$1;
(statearr_58252_58337[(2)] = inst_58040);

(statearr_58252_58337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (5))){
var _ = (function (){var statearr_58253 = state_58187;
(statearr_58253[(4)] = cljs.core.rest.call(null,(state_58187[(4)])));

return statearr_58253;
})();
var state_58187__$1 = state_58187;
var ex58250 = (state_58187__$1[(2)]);
var statearr_58254_58338 = state_58187__$1;
(statearr_58254_58338[(5)] = ex58250);


if((ex58250 instanceof Error)){
var statearr_58255_58339 = state_58187__$1;
(statearr_58255_58339[(1)] = (4));

(statearr_58255_58339[(5)] = null);

} else {
throw ex58250;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (14))){
var state_58187__$1 = state_58187;
var statearr_58256_58340 = state_58187__$1;
(statearr_58256_58340[(2)] = null);

(statearr_58256_58340[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (45))){
var inst_58124 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58257_58341 = state_58187__$1;
(statearr_58257_58341[(2)] = inst_58124);

(statearr_58257_58341[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (53))){
var inst_58080 = (state_58187[(8)]);
var inst_58143 = cljs.core.vector_QMARK_.call(null,inst_58080);
var state_58187__$1 = state_58187;
if(inst_58143){
var statearr_58258_58342 = state_58187__$1;
(statearr_58258_58342[(1)] = (55));

} else {
var statearr_58259_58343 = state_58187__$1;
(statearr_58259_58343[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (26))){
var inst_58074 = (state_58187[(12)]);
var inst_58081 = (state_58187[(24)]);
var inst_58172 = (state_58187[(2)]);
var inst_58173 = cljs.core.conj.call(null,inst_58074,inst_58172);
var inst_58073 = inst_58081;
var inst_58074__$1 = inst_58173;
var state_58187__$1 = (function (){var statearr_58260 = state_58187;
(statearr_58260[(12)] = inst_58074__$1);

(statearr_58260[(15)] = inst_58073);

return statearr_58260;
})();
var statearr_58261_58344 = state_58187__$1;
(statearr_58261_58344[(2)] = null);

(statearr_58261_58344[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (16))){
var inst_58080 = (state_58187[(8)]);
var inst_58073 = (state_58187[(15)]);
var inst_58079 = cljs.core.seq.call(null,inst_58073);
var inst_58080__$1 = cljs.core.first.call(null,inst_58079);
var inst_58081 = cljs.core.next.call(null,inst_58079);
var state_58187__$1 = (function (){var statearr_58262 = state_58187;
(statearr_58262[(24)] = inst_58081);

(statearr_58262[(8)] = inst_58080__$1);

return statearr_58262;
})();
if(cljs.core.truth_(inst_58080__$1)){
var statearr_58263_58345 = state_58187__$1;
(statearr_58263_58345[(1)] = (18));

} else {
var statearr_58264_58346 = state_58187__$1;
(statearr_58264_58346[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (38))){
var inst_58061 = (state_58187[(11)]);
var inst_58047 = (state_58187[(25)]);
var inst_58033 = (state_58187[(17)]);
var inst_58042 = (state_58187[(26)]);
var inst_58074 = (state_58187[(12)]);
var inst_58081 = (state_58187[(24)]);
var inst_58070 = (state_58187[(13)]);
var inst_58071 = (state_58187[(14)]);
var inst_58032 = (state_58187[(10)]);
var inst_58044 = (state_58187[(22)]);
var inst_58080 = (state_58187[(8)]);
var inst_58110 = (state_58187[(16)]);
var inst_58031 = (state_58187[(7)]);
var inst_58046 = (state_58187[(27)]);
var inst_58043 = (state_58187[(28)]);
var inst_58073 = (state_58187[(15)]);
var inst_58103 = (state_58187[(21)]);
var inst_58045 = (state_58187[(18)]);
var inst_58106 = [inst_58080];
var inst_58107 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_58106);
var inst_58108 = (function (){var arity = inst_58045;
var args_n = inst_58033;
var fn_map = inst_58042;
var first__58068 = inst_58070;
var or__5045__auto__ = inst_58103;
var args = inst_58032;
var seq__58067 = inst_58071;
var r = inst_58081;
var map__58030 = inst_58043;
var vec__58066 = inst_58032;
var first__58078 = inst_58080;
var _ = inst_58061;
var vec__58076 = inst_58073;
var seq__58077 = inst_58081;
var acc = inst_58074;
var arglist = inst_58046;
var fn_name = inst_58031;
var G__58065 = inst_58073;
var _AMPERSAND_args_QMARK_ = inst_58047;
var arg = inst_58080;
var f = inst_58044;
return (function (p1__58021_SHARP_){
return cljs.core.symbol.call(null,p1__58021_SHARP_);
});
})();
var inst_58109 = cljs.core.mapv.call(null,inst_58108,params);
var inst_58110__$1 = cljs.core.some.call(null,inst_58107,inst_58109);
var state_58187__$1 = (function (){var statearr_58265 = state_58187;
(statearr_58265[(16)] = inst_58110__$1);

return statearr_58265;
})();
if(cljs.core.truth_(inst_58110__$1)){
var statearr_58266_58347 = state_58187__$1;
(statearr_58266_58347[(1)] = (40));

} else {
var statearr_58267_58348 = state_58187__$1;
(statearr_58267_58348[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (30))){
var inst_58170 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58268_58349 = state_58187__$1;
(statearr_58268_58349[(2)] = inst_58170);

(statearr_58268_58349[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (10))){
var inst_58047 = (state_58187[(25)]);
var state_58187__$1 = state_58187;
var statearr_58269_58350 = state_58187__$1;
(statearr_58269_58350[(2)] = inst_58047);

(statearr_58269_58350[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (18))){
var inst_58080 = (state_58187[(8)]);
var state_58187__$1 = state_58187;
var statearr_58270_58351 = state_58187__$1;
(statearr_58270_58351[(2)] = inst_58080);

(statearr_58270_58351[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (52))){
var inst_58080 = (state_58187[(8)]);
var state_58187__$1 = state_58187;
var statearr_58271_58352 = state_58187__$1;
(statearr_58271_58352[(2)] = inst_58080);

(statearr_58271_58352[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (42))){
var inst_58126 = (state_58187[(2)]);
var state_58187__$1 = state_58187;
var statearr_58272_58353 = state_58187__$1;
(statearr_58272_58353[(2)] = inst_58126);

(statearr_58272_58353[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (37))){
var inst_58103 = (state_58187[(21)]);
var state_58187__$1 = state_58187;
var statearr_58273_58354 = state_58187__$1;
(statearr_58273_58354[(2)] = inst_58103);

(statearr_58273_58354[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (8))){
var inst_58047 = (state_58187[(25)]);
var inst_58042 = (state_58187[(26)]);
var inst_58043 = (state_58187[(28)]);
var inst_58042__$1 = (state_58187[(2)]);
var inst_58043__$1 = cljs.core.__destructure_map.call(null,inst_58042__$1);
var inst_58044 = cljs.core.get.call(null,inst_58043__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_58045 = cljs.core.get.call(null,inst_58043__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_58046 = cljs.core.get.call(null,inst_58043__$1,new cljs.core.Keyword(null,"arglist","arglist",-1808272150));
var inst_58047__$1 = cljs.core.get.call(null,inst_58043__$1,new cljs.core.Keyword(null,"&args?","&args?",-1736256945));
var state_58187__$1 = (function (){var statearr_58274 = state_58187;
(statearr_58274[(25)] = inst_58047__$1);

(statearr_58274[(26)] = inst_58042__$1);

(statearr_58274[(22)] = inst_58044);

(statearr_58274[(27)] = inst_58046);

(statearr_58274[(28)] = inst_58043__$1);

(statearr_58274[(18)] = inst_58045);

return statearr_58274;
})();
if(cljs.core.truth_(inst_58047__$1)){
var statearr_58275_58355 = state_58187__$1;
(statearr_58275_58355[(1)] = (10));

} else {
var statearr_58276_58356 = state_58187__$1;
(statearr_58276_58356[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58188 === (49))){
var inst_58133 = (state_58187[(23)]);
var state_58187__$1 = state_58187;
var statearr_58277_58357 = state_58187__$1;
(statearr_58277_58357[(2)] = inst_58133);

(statearr_58277_58357[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_58278 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58278[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_58278[(1)] = (1));

return statearr_58278;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_58187){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_58187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e58279){var ex__2749__auto__ = e58279;
var statearr_58280_58358 = state_58187;
(statearr_58280_58358[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_58187[(4)]))){
var statearr_58281_58359 = state_58187;
(statearr_58281_58359[(1)] = cljs.core.first.call(null,(state_58187[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58360 = state_58187;
state_58187 = G__58360;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_58187){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_58187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_58282 = f__2769__auto__.call(null);
(statearr_58282[(6)] = c__2768__auto__);

return statearr_58282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__58362 = arguments.length;
switch (G__58362) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.call(null,db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_58444){
var state_val_58445 = (state_58444[(1)]);
if((state_val_58445 === (7))){
var inst_58372 = cljs.core._EQ_.call(null,fn_str,"false");
var state_58444__$1 = state_58444;
var statearr_58446_58494 = state_58444__$1;
(statearr_58446_58494[(2)] = inst_58372);

(statearr_58446_58494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (20))){
var inst_58422 = cljs.core._EQ_.call(null,type,"functionDec");
var state_58444__$1 = state_58444;
var statearr_58447_58495 = state_58444__$1;
(statearr_58447_58495[(2)] = inst_58422);

(statearr_58447_58495[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (1))){
var state_58444__$1 = state_58444;
var statearr_58448_58496 = state_58444__$1;
(statearr_58448_58496[(2)] = null);

(statearr_58448_58496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (24))){
var inst_58419 = (state_58444[(7)]);
var inst_58428 = cljs.core.eval.call(null,inst_58419);
var state_58444__$1 = state_58444;
var statearr_58450_58497 = state_58444__$1;
(statearr_58450_58497[(2)] = inst_58428);

(statearr_58450_58497[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (4))){
var inst_58363 = (state_58444[(2)]);
var state_58444__$1 = state_58444;
var statearr_58451_58498 = state_58444__$1;
(statearr_58451_58498[(2)] = inst_58363);

(statearr_58451_58498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (15))){
var _ = (function (){var statearr_58452 = state_58444;
(statearr_58452[(4)] = cljs.core.rest.call(null,(state_58444[(4)])));

return statearr_58452;
})();
var state_58444__$1 = state_58444;
var ex58449 = (state_58444__$1[(2)]);
var statearr_58453_58499 = state_58444__$1;
(statearr_58453_58499[(5)] = ex58449);


var statearr_58454_58500 = state_58444__$1;
(statearr_58454_58500[(1)] = (14));

(statearr_58454_58500[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (21))){
var inst_58420 = (state_58444[(8)]);
var state_58444__$1 = state_58444;
var statearr_58455_58501 = state_58444__$1;
(statearr_58455_58501[(2)] = inst_58420);

(statearr_58455_58501[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (13))){
var inst_58437 = (state_58444[(2)]);
var state_58444__$1 = state_58444;
var statearr_58456_58502 = state_58444__$1;
(statearr_58456_58502[(2)] = inst_58437);

(statearr_58456_58502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (22))){
var inst_58425 = (state_58444[(2)]);
var state_58444__$1 = state_58444;
if(cljs.core.truth_(inst_58425)){
var statearr_58457_58503 = state_58444__$1;
(statearr_58457_58503[(1)] = (23));

} else {
var statearr_58458_58504 = state_58444__$1;
(statearr_58458_58504[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (6))){
var inst_58369 = (state_58444[(9)]);
var state_58444__$1 = state_58444;
var statearr_58459_58505 = state_58444__$1;
(statearr_58459_58505[(2)] = inst_58369);

(statearr_58459_58505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (25))){
var inst_58430 = (state_58444[(2)]);
var inst_58431 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_58432 = [fn_str];
var inst_58433 = cljs.core.PersistentHashMap.fromArrays(inst_58431,inst_58432);
var inst_58434 = cljs.core.with_meta.call(null,inst_58430,inst_58433);
var _ = (function (){var statearr_58460 = state_58444;
(statearr_58460[(4)] = cljs.core.rest.call(null,(state_58444[(4)])));

return statearr_58460;
})();
var state_58444__$1 = state_58444;
var statearr_58461_58506 = state_58444__$1;
(statearr_58461_58506[(2)] = inst_58434);

(statearr_58461_58506[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (17))){
var inst_58395 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58396 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_58397 = cljs.core.PersistentHashMap.fromArrays(inst_58395,inst_58396);
var inst_58398 = cljs.core.ex_info.call(null,"Bad function",inst_58397);
var inst_58399 = (function(){throw inst_58398})();
var state_58444__$1 = state_58444;
var statearr_58462_58507 = state_58444__$1;
(statearr_58462_58507[(2)] = inst_58399);

(statearr_58462_58507[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (3))){
var inst_58442 = (state_58444[(2)]);
var state_58444__$1 = state_58444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58444__$1,inst_58442);
} else {
if((state_val_58445 === (12))){
var _ = (function (){var statearr_58463 = state_58444;
(statearr_58463[(4)] = cljs.core.cons.call(null,(15),(state_58444[(4)])));

return statearr_58463;
})();
var inst_58392 = cljs.core.re_matches.call(null,/(^\(.+\)$)/,fn_str);
var state_58444__$1 = state_58444;
if(cljs.core.truth_(inst_58392)){
var statearr_58464_58508 = state_58444__$1;
(statearr_58464_58508[(1)] = (16));

} else {
var statearr_58465_58509 = state_58444__$1;
(statearr_58465_58509[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (2))){
var inst_58369 = (state_58444[(9)]);
var _ = (function (){var statearr_58466 = state_58444;
(statearr_58466[(4)] = cljs.core.cons.call(null,(5),(state_58444[(4)])));

return statearr_58466;
})();
var inst_58369__$1 = cljs.core._EQ_.call(null,fn_str,"true");
var state_58444__$1 = (function (){var statearr_58467 = state_58444;
(statearr_58467[(9)] = inst_58369__$1);

return statearr_58467;
})();
if(inst_58369__$1){
var statearr_58468_58510 = state_58444__$1;
(statearr_58468_58510[(1)] = (6));

} else {
var statearr_58469_58511 = state_58444__$1;
(statearr_58469_58511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (23))){
var inst_58419 = (state_58444[(7)]);
var state_58444__$1 = state_58444;
var statearr_58470_58512 = state_58444__$1;
(statearr_58470_58512[(2)] = inst_58419);

(statearr_58470_58512[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (19))){
var inst_58420 = (state_58444[(8)]);
var inst_58405 = (state_58444[(2)]);
var inst_58406 = fluree.db.util.async.throw_err.call(null,inst_58405);
var inst_58407 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_58408 = (new cljs.core.List(null,inst_58407,null,(1),null));
var inst_58409 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_58410 = (new cljs.core.List(null,inst_58409,null,(1),null));
var inst_58411 = cljs.core.concat.call(null,inst_58410);
var inst_58412 = cljs.core.seq.call(null,inst_58411);
var inst_58413 = cljs.core.sequence.call(null,inst_58412);
var inst_58414 = cljs.core.vec.call(null,inst_58413);
var inst_58415 = (new cljs.core.List(null,inst_58414,null,(1),null));
var inst_58416 = (new cljs.core.List(null,inst_58406,null,(1),null));
var inst_58417 = cljs.core.concat.call(null,inst_58408,inst_58415,inst_58416);
var inst_58418 = cljs.core.seq.call(null,inst_58417);
var inst_58419 = cljs.core.sequence.call(null,inst_58418);
var inst_58420__$1 = params;
var state_58444__$1 = (function (){var statearr_58471 = state_58444;
(statearr_58471[(8)] = inst_58420__$1);

(statearr_58471[(7)] = inst_58419);

return statearr_58471;
})();
if(cljs.core.truth_(inst_58420__$1)){
var statearr_58472_58513 = state_58444__$1;
(statearr_58472_58513[(1)] = (20));

} else {
var statearr_58473_58514 = state_58444__$1;
(statearr_58473_58514[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (11))){
var inst_58439 = (state_58444[(2)]);
var _ = (function (){var statearr_58475 = state_58444;
(statearr_58475[(4)] = cljs.core.rest.call(null,(state_58444[(4)])));

return statearr_58475;
})();
var state_58444__$1 = state_58444;
var statearr_58476_58515 = state_58444__$1;
(statearr_58476_58515[(2)] = inst_58439);

(statearr_58476_58515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (9))){
var inst_58376 = (function (){return (function (n){
return cljs.reader.read_string.call(null,fn_str);
});
})();
var inst_58377 = fluree.db.dbfunctions.core.true_or_false = inst_58376;
var state_58444__$1 = state_58444;
var statearr_58477_58516 = state_58444__$1;
(statearr_58477_58516[(2)] = inst_58377);

(statearr_58477_58516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (5))){
var _ = (function (){var statearr_58478 = state_58444;
(statearr_58478[(4)] = cljs.core.rest.call(null,(state_58444[(4)])));

return statearr_58478;
})();
var state_58444__$1 = state_58444;
var ex58474 = (state_58444__$1[(2)]);
var statearr_58479_58517 = state_58444__$1;
(statearr_58479_58517[(5)] = ex58474);


if((ex58474 instanceof Error)){
var statearr_58480_58518 = state_58444__$1;
(statearr_58480_58518[(1)] = (4));

(statearr_58480_58518[(5)] = null);

} else {
throw ex58474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (14))){
var inst_58379 = (state_58444[(2)]);
var inst_58380 = (function(){throw inst_58379})();
var inst_58381 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_58382 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58383 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_58384 = cljs.core.PersistentHashMap.fromArrays(inst_58382,inst_58383);
var inst_58385 = cljs.core.ex_info.call(null,inst_58381,inst_58384);
var inst_58386 = (function(){throw inst_58385})();
var state_58444__$1 = (function (){var statearr_58481 = state_58444;
(statearr_58481[(10)] = inst_58380);

return statearr_58481;
})();
var statearr_58482_58519 = state_58444__$1;
(statearr_58482_58519[(2)] = inst_58386);

(statearr_58482_58519[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (16))){
var state_58444__$1 = state_58444;
var statearr_58483_58520 = state_58444__$1;
(statearr_58483_58520[(2)] = null);

(statearr_58483_58520[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (10))){
var state_58444__$1 = state_58444;
var statearr_58484_58521 = state_58444__$1;
(statearr_58484_58521[(2)] = null);

(statearr_58484_58521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58445 === (18))){
var inst_58401 = (state_58444[(2)]);
var inst_58402 = cljs.reader.read_string.call(null,fn_str);
var inst_58403 = fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_58402,type,params);
var state_58444__$1 = (function (){var statearr_58485 = state_58444;
(statearr_58485[(11)] = inst_58401);

return statearr_58485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58444__$1,(19),inst_58403);
} else {
if((state_val_58445 === (8))){
var inst_58374 = (state_58444[(2)]);
var state_58444__$1 = state_58444;
if(cljs.core.truth_(inst_58374)){
var statearr_58486_58522 = state_58444__$1;
(statearr_58486_58522[(1)] = (9));

} else {
var statearr_58487_58523 = state_58444__$1;
(statearr_58487_58523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_58488 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58488[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_58488[(1)] = (1));

return statearr_58488;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_58444){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_58444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e58489){var ex__2749__auto__ = e58489;
var statearr_58490_58524 = state_58444;
(statearr_58490_58524[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_58444[(4)]))){
var statearr_58491_58525 = state_58444;
(statearr_58491_58525[(1)] = cljs.core.first.call(null,(state_58444[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58526 = state_58444;
state_58444 = G__58526;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_58444){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_58444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_58492 = f__2769__auto__.call(null);
(statearr_58492[(6)] = c__2768__auto__);

return statearr_58492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_58554){
var state_val_58555 = (state_58554[(1)]);
if((state_val_58555 === (7))){
var inst_58541 = (state_58554[(7)]);
var state_58554__$1 = state_58554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58554__$1,(10),inst_58541);
} else {
if((state_val_58555 === (1))){
var state_58554__$1 = state_58554;
var statearr_58556_58576 = state_58554__$1;
(statearr_58556_58576[(2)] = null);

(statearr_58556_58576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58555 === (4))){
var inst_58527 = (state_58554[(2)]);
var state_58554__$1 = state_58554;
var statearr_58557_58577 = state_58554__$1;
(statearr_58557_58577[(2)] = inst_58527);

(statearr_58557_58577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58555 === (6))){
var inst_58541 = (state_58554[(7)]);
var inst_58536 = (state_58554[(8)]);
var inst_58539 = (state_58554[(2)]);
var inst_58540 = fluree.db.util.async.throw_err.call(null,inst_58539);
var inst_58541__$1 = inst_58540.call(null,inst_58536);
var inst_58542 = fluree.db.util.async.channel_QMARK_.call(null,inst_58541__$1);
var state_58554__$1 = (function (){var statearr_58558 = state_58554;
(statearr_58558[(7)] = inst_58541__$1);

return statearr_58558;
})();
if(inst_58542){
var statearr_58559_58578 = state_58554__$1;
(statearr_58559_58578[(1)] = (7));

} else {
var statearr_58560_58579 = state_58554__$1;
(statearr_58560_58579[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58555 === (3))){
var inst_58552 = (state_58554[(2)]);
var state_58554__$1 = state_58554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58554__$1,inst_58552);
} else {
if((state_val_58555 === (2))){
var _ = (function (){var statearr_58562 = state_58554;
(statearr_58562[(4)] = cljs.core.cons.call(null,(5),(state_58554[(4)])));

return statearr_58562;
})();
var inst_58533 = cljs.core.subs.call(null,o,(1));
var inst_58534 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_58535 = [db,block_instant,s,p,auth_id,fuel];
var inst_58536 = cljs.core.PersistentHashMap.fromArrays(inst_58534,inst_58535);
var inst_58537 = fluree.db.dbfunctions.core.parse_fn.call(null,db,inst_58533,"txn",null);
var state_58554__$1 = (function (){var statearr_58563 = state_58554;
(statearr_58563[(8)] = inst_58536);

return statearr_58563;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58554__$1,(6),inst_58537);
} else {
if((state_val_58555 === (9))){
var inst_58549 = (state_58554[(2)]);
var _ = (function (){var statearr_58564 = state_58554;
(statearr_58564[(4)] = cljs.core.rest.call(null,(state_58554[(4)])));

return statearr_58564;
})();
var state_58554__$1 = state_58554;
var statearr_58565_58580 = state_58554__$1;
(statearr_58565_58580[(2)] = inst_58549);

(statearr_58565_58580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58555 === (5))){
var _ = (function (){var statearr_58566 = state_58554;
(statearr_58566[(4)] = cljs.core.rest.call(null,(state_58554[(4)])));

return statearr_58566;
})();
var state_58554__$1 = state_58554;
var ex58561 = (state_58554__$1[(2)]);
var statearr_58567_58581 = state_58554__$1;
(statearr_58567_58581[(5)] = ex58561);


if((ex58561 instanceof Error)){
var statearr_58568_58582 = state_58554__$1;
(statearr_58568_58582[(1)] = (4));

(statearr_58568_58582[(5)] = null);

} else {
throw ex58561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58555 === (10))){
var inst_58545 = (state_58554[(2)]);
var inst_58546 = fluree.db.util.async.throw_err.call(null,inst_58545);
var state_58554__$1 = state_58554;
var statearr_58569_58583 = state_58554__$1;
(statearr_58569_58583[(2)] = inst_58546);

(statearr_58569_58583[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58555 === (8))){
var inst_58541 = (state_58554[(7)]);
var state_58554__$1 = state_58554;
var statearr_58570_58584 = state_58554__$1;
(statearr_58570_58584[(2)] = inst_58541);

(statearr_58570_58584[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_58571 = [null,null,null,null,null,null,null,null,null];
(statearr_58571[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__);

(statearr_58571[(1)] = (1));

return statearr_58571;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1 = (function (state_58554){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_58554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e58572){var ex__2749__auto__ = e58572;
var statearr_58573_58585 = state_58554;
(statearr_58573_58585[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_58554[(4)]))){
var statearr_58574_58586 = state_58554;
(statearr_58574_58586[(1)] = cljs.core.first.call(null,(state_58554[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58587 = state_58554;
state_58554 = G__58587;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__ = function(state_58554){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1.call(this,state_58554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_58575 = f__2769__auto__.call(null);
(statearr_58575[(6)] = c__2768__auto__);

return statearr_58575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
