// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___53821 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53872){
var state_val_53873 = (state_53872[(1)]);
if((state_val_53873 === (7))){
var inst_53867 = (state_53872[(2)]);
var _ = (function (){var statearr_53874 = state_53872;
(statearr_53874[(4)] = cljs.core.rest.call(null,(state_53872[(4)])));

return statearr_53874;
})();
var state_53872__$1 = state_53872;
var statearr_53875_53902 = state_53872__$1;
(statearr_53875_53902[(2)] = inst_53867);

(statearr_53875_53902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (1))){
var state_53872__$1 = state_53872;
var statearr_53876_53903 = state_53872__$1;
(statearr_53876_53903[(2)] = null);

(statearr_53876_53903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (4))){
var inst_53822 = (state_53872[(2)]);
var state_53872__$1 = state_53872;
var statearr_53877_53904 = state_53872__$1;
(statearr_53877_53904[(2)] = inst_53822);

(statearr_53877_53904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (13))){
var inst_53863 = (state_53872[(2)]);
var state_53872__$1 = state_53872;
var statearr_53878_53905 = state_53872__$1;
(statearr_53878_53905[(2)] = inst_53863);

(statearr_53878_53905[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (6))){
var inst_53840 = (state_53872[(7)]);
var inst_53847 = (state_53872[(8)]);
var inst_53846 = cljs.core.seq.call(null,inst_53840);
var inst_53847__$1 = cljs.core.first.call(null,inst_53846);
var inst_53848 = cljs.core.next.call(null,inst_53846);
var inst_53849 = cljs.core.not.call(null,inst_53847__$1);
var state_53872__$1 = (function (){var statearr_53879 = state_53872;
(statearr_53879[(9)] = inst_53848);

(statearr_53879[(8)] = inst_53847__$1);

return statearr_53879;
})();
if(inst_53849){
var statearr_53880_53906 = state_53872__$1;
(statearr_53880_53906[(1)] = (8));

} else {
var statearr_53881_53907 = state_53872__$1;
(statearr_53881_53907[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (3))){
var inst_53870 = (state_53872[(2)]);
var state_53872__$1 = state_53872;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53872__$1,inst_53870);
} else {
if((state_val_53873 === (12))){
var inst_53848 = (state_53872[(9)]);
var inst_53847 = (state_53872[(8)]);
var inst_53841 = (state_53872[(10)]);
var inst_53860 = cljs.core.conj.call(null,inst_53841,inst_53847);
var inst_53840 = inst_53848;
var inst_53841__$1 = inst_53860;
var state_53872__$1 = (function (){var statearr_53882 = state_53872;
(statearr_53882[(7)] = inst_53840);

(statearr_53882[(10)] = inst_53841__$1);

return statearr_53882;
})();
var statearr_53883_53908 = state_53872__$1;
(statearr_53883_53908[(2)] = null);

(statearr_53883_53908[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (2))){
var _ = (function (){var statearr_53884 = state_53872;
(statearr_53884[(4)] = cljs.core.cons.call(null,(5),(state_53872[(4)])));

return statearr_53884;
})();
var inst_53835 = args;
var inst_53836 = cljs.core.seq.call(null,inst_53835);
var inst_53837 = cljs.core.first.call(null,inst_53836);
var inst_53838 = cljs.core.next.call(null,inst_53836);
var inst_53839 = cljs.core.PersistentVector.EMPTY;
var inst_53840 = inst_53835;
var inst_53841 = inst_53839;
var state_53872__$1 = (function (){var statearr_53885 = state_53872;
(statearr_53885[(7)] = inst_53840);

(statearr_53885[(11)] = inst_53837);

(statearr_53885[(12)] = inst_53838);

(statearr_53885[(10)] = inst_53841);

return statearr_53885;
})();
var statearr_53886_53909 = state_53872__$1;
(statearr_53886_53909[(2)] = null);

(statearr_53886_53909[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (11))){
var inst_53847 = (state_53872[(8)]);
var state_53872__$1 = state_53872;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53872__$1,(14),inst_53847);
} else {
if((state_val_53873 === (9))){
var inst_53847 = (state_53872[(8)]);
var inst_53852 = fluree.db.util.async.channel_QMARK_.call(null,inst_53847);
var state_53872__$1 = state_53872;
if(inst_53852){
var statearr_53888_53910 = state_53872__$1;
(statearr_53888_53910[(1)] = (11));

} else {
var statearr_53889_53911 = state_53872__$1;
(statearr_53889_53911[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (5))){
var _ = (function (){var statearr_53890 = state_53872;
(statearr_53890[(4)] = cljs.core.rest.call(null,(state_53872[(4)])));

return statearr_53890;
})();
var state_53872__$1 = state_53872;
var ex53887 = (state_53872__$1[(2)]);
var statearr_53891_53912 = state_53872__$1;
(statearr_53891_53912[(5)] = ex53887);


if((ex53887 instanceof Error)){
var statearr_53892_53913 = state_53872__$1;
(statearr_53892_53913[(1)] = (4));

(statearr_53892_53913[(5)] = null);

} else {
throw ex53887;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (14))){
var inst_53848 = (state_53872[(9)]);
var inst_53841 = (state_53872[(10)]);
var inst_53855 = (state_53872[(2)]);
var inst_53856 = fluree.db.util.async.throw_err.call(null,inst_53855);
var inst_53857 = cljs.core.conj.call(null,inst_53841,inst_53856);
var inst_53840 = inst_53848;
var inst_53841__$1 = inst_53857;
var state_53872__$1 = (function (){var statearr_53893 = state_53872;
(statearr_53893[(7)] = inst_53840);

(statearr_53893[(10)] = inst_53841__$1);

return statearr_53893;
})();
var statearr_53894_53914 = state_53872__$1;
(statearr_53894_53914[(2)] = null);

(statearr_53894_53914[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (10))){
var inst_53865 = (state_53872[(2)]);
var state_53872__$1 = state_53872;
var statearr_53895_53915 = state_53872__$1;
(statearr_53895_53915[(2)] = inst_53865);

(statearr_53895_53915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53873 === (8))){
var inst_53841 = (state_53872[(10)]);
var state_53872__$1 = state_53872;
var statearr_53896_53916 = state_53872__$1;
(statearr_53896_53916[(2)] = inst_53841);

(statearr_53896_53916[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0 = (function (){
var statearr_53897 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53897[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__);

(statearr_53897[(1)] = (1));

return statearr_53897;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1 = (function (state_53872){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53872);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53898){var ex__2749__auto__ = e53898;
var statearr_53899_53917 = state_53872;
(statearr_53899_53917[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53872[(4)]))){
var statearr_53900_53918 = state_53872;
(statearr_53900_53918[(1)] = cljs.core.first.call(null,(state_53872[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53919 = state_53872;
state_53872 = G__53919;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = function(state_53872){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1.call(this,state_53872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53901 = f__2769__auto__.call(null);
(statearr_53901[(6)] = c__2768__auto__);

return statearr_53901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53920 = entry;
var res = cljs.core.nth.call(null,vec__53920,(0),null);
var cost = cljs.core.nth.call(null,vec__53920,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53968){
var state_val_53969 = (state_53968[(1)]);
if((state_val_53969 === (7))){
var state_53968__$1 = state_53968;
var statearr_53970_53999 = state_53968__$1;
(statearr_53970_53999[(2)] = coll);

(statearr_53970_53999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (1))){
var state_53968__$1 = state_53968;
var statearr_53971_54000 = state_53968__$1;
(statearr_53971_54000[(2)] = null);

(statearr_53971_54000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (4))){
var inst_53923 = (state_53968[(2)]);
var state_53968__$1 = state_53968;
var statearr_53972_54001 = state_53968__$1;
(statearr_53972_54001[(2)] = inst_53923);

(statearr_53972_54001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (15))){
var inst_53942 = (state_53968[(7)]);
var inst_53950 = (state_53968[(2)]);
var inst_53951 = fluree.db.dbfunctions.internal.nth.call(null,inst_53942,inst_53950);
var inst_53952 = cljs.core.count.call(null,inst_53942);
var inst_53953 = ((9) + inst_53952);
var inst_53954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53955 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53957 = [inst_53942,inst_53950];
var inst_53958 = (new cljs.core.PersistentVector(null,2,(5),inst_53956,inst_53957,null));
var inst_53959 = ["nth",inst_53958,inst_53951];
var inst_53960 = cljs.core.PersistentHashMap.fromArrays(inst_53955,inst_53959);
var inst_53961 = [inst_53960,inst_53953];
var inst_53962 = (new cljs.core.PersistentVector(null,2,(5),inst_53954,inst_53961,null));
var inst_53963 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53962);
var _ = (function (){var statearr_53973 = state_53968;
(statearr_53973[(4)] = cljs.core.rest.call(null,(state_53968[(4)])));

return statearr_53973;
})();
var state_53968__$1 = (function (){var statearr_53974 = state_53968;
(statearr_53974[(8)] = inst_53963);

return statearr_53974;
})();
var statearr_53975_54002 = state_53968__$1;
(statearr_53975_54002[(2)] = inst_53951);

(statearr_53975_54002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (13))){
var state_53968__$1 = state_53968;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53968__$1,(16),key);
} else {
if((state_val_53969 === (6))){
var state_53968__$1 = state_53968;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53968__$1,(9),coll);
} else {
if((state_val_53969 === (3))){
var inst_53966 = (state_53968[(2)]);
var state_53968__$1 = state_53968;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53968__$1,inst_53966);
} else {
if((state_val_53969 === (12))){
var inst_53942 = (state_53968[(2)]);
var inst_53943 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_53968__$1 = (function (){var statearr_53976 = state_53968;
(statearr_53976[(7)] = inst_53942);

return statearr_53976;
})();
if(inst_53943){
var statearr_53977_54003 = state_53968__$1;
(statearr_53977_54003[(1)] = (13));

} else {
var statearr_53978_54004 = state_53968__$1;
(statearr_53978_54004[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (2))){
var _ = (function (){var statearr_53979 = state_53968;
(statearr_53979[(4)] = cljs.core.cons.call(null,(5),(state_53968[(4)])));

return statearr_53979;
})();
var inst_53929 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53968__$1 = state_53968;
if(inst_53929){
var statearr_53980_54005 = state_53968__$1;
(statearr_53980_54005[(1)] = (6));

} else {
var statearr_53981_54006 = state_53968__$1;
(statearr_53981_54006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (11))){
var inst_53936 = (state_53968[(9)]);
var state_53968__$1 = state_53968;
var statearr_53983_54007 = state_53968__$1;
(statearr_53983_54007[(2)] = inst_53936);

(statearr_53983_54007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (9))){
var inst_53932 = (state_53968[(2)]);
var inst_53933 = fluree.db.util.async.throw_err.call(null,inst_53932);
var state_53968__$1 = state_53968;
var statearr_53984_54008 = state_53968__$1;
(statearr_53984_54008[(2)] = inst_53933);

(statearr_53984_54008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (5))){
var _ = (function (){var statearr_53985 = state_53968;
(statearr_53985[(4)] = cljs.core.rest.call(null,(state_53968[(4)])));

return statearr_53985;
})();
var state_53968__$1 = state_53968;
var ex53982 = (state_53968__$1[(2)]);
var statearr_53986_54009 = state_53968__$1;
(statearr_53986_54009[(5)] = ex53982);


if((ex53982 instanceof Error)){
var statearr_53987_54010 = state_53968__$1;
(statearr_53987_54010[(1)] = (4));

(statearr_53987_54010[(5)] = null);

} else {
throw ex53982;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (14))){
var state_53968__$1 = state_53968;
var statearr_53988_54011 = state_53968__$1;
(statearr_53988_54011[(2)] = key);

(statearr_53988_54011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (16))){
var inst_53946 = (state_53968[(2)]);
var inst_53947 = fluree.db.util.async.throw_err.call(null,inst_53946);
var state_53968__$1 = state_53968;
var statearr_53989_54012 = state_53968__$1;
(statearr_53989_54012[(2)] = inst_53947);

(statearr_53989_54012[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (10))){
var inst_53936 = (state_53968[(9)]);
var inst_53939 = cljs.core.vec.call(null,inst_53936);
var state_53968__$1 = state_53968;
var statearr_53990_54013 = state_53968__$1;
(statearr_53990_54013[(2)] = inst_53939);

(statearr_53990_54013[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53969 === (8))){
var inst_53936 = (state_53968[(9)]);
var inst_53936__$1 = (state_53968[(2)]);
var inst_53937 = cljs.core.set_QMARK_.call(null,inst_53936__$1);
var state_53968__$1 = (function (){var statearr_53991 = state_53968;
(statearr_53991[(9)] = inst_53936__$1);

return statearr_53991;
})();
if(inst_53937){
var statearr_53992_54014 = state_53968__$1;
(statearr_53992_54014[(1)] = (10));

} else {
var statearr_53993_54015 = state_53968__$1;
(statearr_53993_54015[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0 = (function (){
var statearr_53994 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53994[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__);

(statearr_53994[(1)] = (1));

return statearr_53994;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1 = (function (state_53968){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53968);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53995){var ex__2749__auto__ = e53995;
var statearr_53996_54016 = state_53968;
(statearr_53996_54016[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53968[(4)]))){
var statearr_53997_54017 = state_53968;
(statearr_53997_54017[(1)] = cljs.core.first.call(null,(state_53968[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54018 = state_53968;
state_53968 = G__54018;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = function(state_53968){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1.call(this,state_53968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53998 = f__2769__auto__.call(null);
(statearr_53998[(6)] = c__2768__auto__);

return statearr_53998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54079){
var state_val_54080 = (state_54079[(1)]);
if((state_val_54080 === (7))){
var state_54079__$1 = state_54079;
var statearr_54081_54115 = state_54079__$1;
(statearr_54081_54115[(2)] = test);

(statearr_54081_54115[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (20))){
var inst_54053 = (state_54079[(2)]);
var inst_54054 = fluree.db.util.async.throw_err.call(null,inst_54053);
var state_54079__$1 = state_54079;
var statearr_54082_54116 = state_54079__$1;
(statearr_54082_54116[(2)] = inst_54054);

(statearr_54082_54116[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (1))){
var state_54079__$1 = state_54079;
var statearr_54083_54117 = state_54079__$1;
(statearr_54083_54117[(2)] = null);

(statearr_54083_54117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (4))){
var inst_54019 = (state_54079[(2)]);
var state_54079__$1 = state_54079;
var statearr_54084_54118 = state_54079__$1;
(statearr_54084_54118[(2)] = inst_54019);

(statearr_54084_54118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (15))){
var inst_54037 = (state_54079[(7)]);
var inst_54045 = (state_54079[(2)]);
var inst_54046 = [inst_54045,f];
var inst_54047 = (new cljs.core.PersistentVector(null,2,(5),inst_54037,inst_54046,null));
var state_54079__$1 = state_54079;
var statearr_54085_54119 = state_54079__$1;
(statearr_54085_54119[(2)] = inst_54047);

(statearr_54085_54119[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (13))){
var state_54079__$1 = state_54079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54079__$1,(16),t);
} else {
if((state_val_54080 === (6))){
var state_54079__$1 = state_54079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54079__$1,(9),test);
} else {
if((state_val_54080 === (17))){
var state_54079__$1 = state_54079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54079__$1,(20),f);
} else {
if((state_val_54080 === (3))){
var inst_54077 = (state_54079[(2)]);
var state_54079__$1 = state_54079;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54079__$1,inst_54077);
} else {
if((state_val_54080 === (12))){
var inst_54035 = (state_54079[(8)]);
var inst_54061 = (state_54079[(2)]);
var inst_54062 = cljs.core.nth.call(null,inst_54061,(0),null);
var inst_54063 = cljs.core.nth.call(null,inst_54061,(1),null);
var inst_54064 = fluree.db.dbfunctions.internal.if_else.call(null,inst_54035,inst_54062,inst_54063);
var inst_54065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54066 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54068 = [inst_54035,inst_54062,inst_54063];
var inst_54069 = (new cljs.core.PersistentVector(null,3,(5),inst_54067,inst_54068,null));
var inst_54070 = ["if-else",inst_54069,inst_54064];
var inst_54071 = cljs.core.PersistentHashMap.fromArrays(inst_54066,inst_54070);
var inst_54072 = [inst_54071,(10)];
var inst_54073 = (new cljs.core.PersistentVector(null,2,(5),inst_54065,inst_54072,null));
var inst_54074 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54073);
var _ = (function (){var statearr_54086 = state_54079;
(statearr_54086[(4)] = cljs.core.rest.call(null,(state_54079[(4)])));

return statearr_54086;
})();
var state_54079__$1 = (function (){var statearr_54087 = state_54079;
(statearr_54087[(9)] = inst_54074);

return statearr_54087;
})();
var statearr_54088_54120 = state_54079__$1;
(statearr_54088_54120[(2)] = inst_54064);

(statearr_54088_54120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (2))){
var _ = (function (){var statearr_54089 = state_54079;
(statearr_54089[(4)] = cljs.core.cons.call(null,(5),(state_54079[(4)])));

return statearr_54089;
})();
var inst_54028 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_54079__$1 = state_54079;
if(inst_54028){
var statearr_54090_54121 = state_54079__$1;
(statearr_54090_54121[(1)] = (6));

} else {
var statearr_54091_54122 = state_54079__$1;
(statearr_54091_54122[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (19))){
var inst_54049 = (state_54079[(10)]);
var inst_54057 = (state_54079[(2)]);
var inst_54058 = [f,inst_54057];
var inst_54059 = (new cljs.core.PersistentVector(null,2,(5),inst_54049,inst_54058,null));
var state_54079__$1 = state_54079;
var statearr_54092_54123 = state_54079__$1;
(statearr_54092_54123[(2)] = inst_54059);

(statearr_54092_54123[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (11))){
var inst_54049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54050 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_54079__$1 = (function (){var statearr_54094 = state_54079;
(statearr_54094[(10)] = inst_54049);

return statearr_54094;
})();
if(inst_54050){
var statearr_54095_54124 = state_54079__$1;
(statearr_54095_54124[(1)] = (17));

} else {
var statearr_54096_54125 = state_54079__$1;
(statearr_54096_54125[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (9))){
var inst_54031 = (state_54079[(2)]);
var inst_54032 = fluree.db.util.async.throw_err.call(null,inst_54031);
var state_54079__$1 = state_54079;
var statearr_54097_54126 = state_54079__$1;
(statearr_54097_54126[(2)] = inst_54032);

(statearr_54097_54126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (5))){
var _ = (function (){var statearr_54098 = state_54079;
(statearr_54098[(4)] = cljs.core.rest.call(null,(state_54079[(4)])));

return statearr_54098;
})();
var state_54079__$1 = state_54079;
var ex54093 = (state_54079__$1[(2)]);
var statearr_54099_54127 = state_54079__$1;
(statearr_54099_54127[(5)] = ex54093);


if((ex54093 instanceof Error)){
var statearr_54100_54128 = state_54079__$1;
(statearr_54100_54128[(1)] = (4));

(statearr_54100_54128[(5)] = null);

} else {
throw ex54093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (14))){
var state_54079__$1 = state_54079;
var statearr_54101_54129 = state_54079__$1;
(statearr_54101_54129[(2)] = t);

(statearr_54101_54129[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (16))){
var inst_54041 = (state_54079[(2)]);
var inst_54042 = fluree.db.util.async.throw_err.call(null,inst_54041);
var state_54079__$1 = state_54079;
var statearr_54102_54130 = state_54079__$1;
(statearr_54102_54130[(2)] = inst_54042);

(statearr_54102_54130[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (10))){
var inst_54037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54038 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_54079__$1 = (function (){var statearr_54103 = state_54079;
(statearr_54103[(7)] = inst_54037);

return statearr_54103;
})();
if(inst_54038){
var statearr_54104_54131 = state_54079__$1;
(statearr_54104_54131[(1)] = (13));

} else {
var statearr_54105_54132 = state_54079__$1;
(statearr_54105_54132[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (18))){
var state_54079__$1 = state_54079;
var statearr_54106_54133 = state_54079__$1;
(statearr_54106_54133[(2)] = f);

(statearr_54106_54133[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54080 === (8))){
var inst_54035 = (state_54079[(8)]);
var inst_54035__$1 = (state_54079[(2)]);
var state_54079__$1 = (function (){var statearr_54107 = state_54079;
(statearr_54107[(8)] = inst_54035__$1);

return statearr_54107;
})();
if(cljs.core.truth_(inst_54035__$1)){
var statearr_54108_54134 = state_54079__$1;
(statearr_54108_54134[(1)] = (10));

} else {
var statearr_54109_54135 = state_54079__$1;
(statearr_54109_54135[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0 = (function (){
var statearr_54110 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54110[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__);

(statearr_54110[(1)] = (1));

return statearr_54110;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1 = (function (state_54079){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54111){var ex__2749__auto__ = e54111;
var statearr_54112_54136 = state_54079;
(statearr_54112_54136[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54079[(4)]))){
var statearr_54113_54137 = state_54079;
(statearr_54113_54137[(1)] = cljs.core.first.call(null,(state_54079[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54138 = state_54079;
state_54079 = G__54138;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = function(state_54079){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1.call(this,state_54079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54114 = f__2769__auto__.call(null);
(statearr_54114[(6)] = c__2768__auto__);

return statearr_54114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54168){
var state_val_54169 = (state_54168[(1)]);
if((state_val_54169 === (7))){
var state_54168__$1 = state_54168;
var statearr_54170_54189 = state_54168__$1;
(statearr_54170_54189[(2)] = arg);

(statearr_54170_54189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54169 === (1))){
var state_54168__$1 = state_54168;
var statearr_54171_54190 = state_54168__$1;
(statearr_54171_54190[(2)] = null);

(statearr_54171_54190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54169 === (4))){
var inst_54139 = (state_54168[(2)]);
var state_54168__$1 = state_54168;
var statearr_54172_54191 = state_54168__$1;
(statearr_54172_54191[(2)] = inst_54139);

(statearr_54172_54191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54169 === (6))){
var state_54168__$1 = state_54168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54168__$1,(9),arg);
} else {
if((state_val_54169 === (3))){
var inst_54166 = (state_54168[(2)]);
var state_54168__$1 = state_54168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54168__$1,inst_54166);
} else {
if((state_val_54169 === (2))){
var _ = (function (){var statearr_54174 = state_54168;
(statearr_54174[(4)] = cljs.core.cons.call(null,(5),(state_54168[(4)])));

return statearr_54174;
})();
var inst_54145 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54168__$1 = state_54168;
if(inst_54145){
var statearr_54175_54192 = state_54168__$1;
(statearr_54175_54192[(1)] = (6));

} else {
var statearr_54176_54193 = state_54168__$1;
(statearr_54176_54193[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54169 === (9))){
var inst_54148 = (state_54168[(2)]);
var inst_54149 = fluree.db.util.async.throw_err.call(null,inst_54148);
var state_54168__$1 = state_54168;
var statearr_54177_54194 = state_54168__$1;
(statearr_54177_54194[(2)] = inst_54149);

(statearr_54177_54194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54169 === (5))){
var _ = (function (){var statearr_54178 = state_54168;
(statearr_54178[(4)] = cljs.core.rest.call(null,(state_54168[(4)])));

return statearr_54178;
})();
var state_54168__$1 = state_54168;
var ex54173 = (state_54168__$1[(2)]);
var statearr_54179_54195 = state_54168__$1;
(statearr_54179_54195[(5)] = ex54173);


if((ex54173 instanceof Error)){
var statearr_54180_54196 = state_54168__$1;
(statearr_54180_54196[(1)] = (4));

(statearr_54180_54196[(5)] = null);

} else {
throw ex54173;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54169 === (8))){
var inst_54152 = (state_54168[(2)]);
var inst_54153 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_54152);
var inst_54154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54155 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54157 = [inst_54152];
var inst_54158 = (new cljs.core.PersistentVector(null,1,(5),inst_54156,inst_54157,null));
var inst_54159 = ["nil?",inst_54158,inst_54153];
var inst_54160 = cljs.core.PersistentHashMap.fromArrays(inst_54155,inst_54159);
var inst_54161 = [inst_54160,(10)];
var inst_54162 = (new cljs.core.PersistentVector(null,2,(5),inst_54154,inst_54161,null));
var inst_54163 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54162);
var _ = (function (){var statearr_54181 = state_54168;
(statearr_54181[(4)] = cljs.core.rest.call(null,(state_54168[(4)])));

return statearr_54181;
})();
var state_54168__$1 = (function (){var statearr_54182 = state_54168;
(statearr_54182[(7)] = inst_54163);

return statearr_54182;
})();
var statearr_54183_54197 = state_54168__$1;
(statearr_54183_54197[(2)] = inst_54153);

(statearr_54183_54197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54184 = [null,null,null,null,null,null,null,null];
(statearr_54184[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__);

(statearr_54184[(1)] = (1));

return statearr_54184;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1 = (function (state_54168){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54185){var ex__2749__auto__ = e54185;
var statearr_54186_54198 = state_54168;
(statearr_54186_54198[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54168[(4)]))){
var statearr_54187_54199 = state_54168;
(statearr_54187_54199[(1)] = cljs.core.first.call(null,(state_54168[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54200 = state_54168;
state_54168 = G__54200;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = function(state_54168){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1.call(this,state_54168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54188 = f__2769__auto__.call(null);
(statearr_54188[(6)] = c__2768__auto__);

return statearr_54188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54230){
var state_val_54231 = (state_54230[(1)]);
if((state_val_54231 === (7))){
var state_54230__$1 = state_54230;
var statearr_54232_54251 = state_54230__$1;
(statearr_54232_54251[(2)] = arg);

(statearr_54232_54251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54231 === (1))){
var state_54230__$1 = state_54230;
var statearr_54233_54252 = state_54230__$1;
(statearr_54233_54252[(2)] = null);

(statearr_54233_54252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54231 === (4))){
var inst_54201 = (state_54230[(2)]);
var state_54230__$1 = state_54230;
var statearr_54234_54253 = state_54230__$1;
(statearr_54234_54253[(2)] = inst_54201);

(statearr_54234_54253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54231 === (6))){
var state_54230__$1 = state_54230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54230__$1,(9),arg);
} else {
if((state_val_54231 === (3))){
var inst_54228 = (state_54230[(2)]);
var state_54230__$1 = state_54230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54230__$1,inst_54228);
} else {
if((state_val_54231 === (2))){
var _ = (function (){var statearr_54236 = state_54230;
(statearr_54236[(4)] = cljs.core.cons.call(null,(5),(state_54230[(4)])));

return statearr_54236;
})();
var inst_54207 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54230__$1 = state_54230;
if(inst_54207){
var statearr_54237_54254 = state_54230__$1;
(statearr_54237_54254[(1)] = (6));

} else {
var statearr_54238_54255 = state_54230__$1;
(statearr_54238_54255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54231 === (9))){
var inst_54210 = (state_54230[(2)]);
var inst_54211 = fluree.db.util.async.throw_err.call(null,inst_54210);
var state_54230__$1 = state_54230;
var statearr_54239_54256 = state_54230__$1;
(statearr_54239_54256[(2)] = inst_54211);

(statearr_54239_54256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54231 === (5))){
var _ = (function (){var statearr_54240 = state_54230;
(statearr_54240[(4)] = cljs.core.rest.call(null,(state_54230[(4)])));

return statearr_54240;
})();
var state_54230__$1 = state_54230;
var ex54235 = (state_54230__$1[(2)]);
var statearr_54241_54257 = state_54230__$1;
(statearr_54241_54257[(5)] = ex54235);


if((ex54235 instanceof Error)){
var statearr_54242_54258 = state_54230__$1;
(statearr_54242_54258[(1)] = (4));

(statearr_54242_54258[(5)] = null);

} else {
throw ex54235;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54231 === (8))){
var inst_54214 = (state_54230[(2)]);
var inst_54215 = fluree.db.dbfunctions.internal.not.call(null,inst_54214);
var inst_54216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54217 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54219 = [inst_54214];
var inst_54220 = (new cljs.core.PersistentVector(null,1,(5),inst_54218,inst_54219,null));
var inst_54221 = ["not?",inst_54220,inst_54215];
var inst_54222 = cljs.core.PersistentHashMap.fromArrays(inst_54217,inst_54221);
var inst_54223 = [inst_54222,(10)];
var inst_54224 = (new cljs.core.PersistentVector(null,2,(5),inst_54216,inst_54223,null));
var inst_54225 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54224);
var _ = (function (){var statearr_54243 = state_54230;
(statearr_54243[(4)] = cljs.core.rest.call(null,(state_54230[(4)])));

return statearr_54243;
})();
var state_54230__$1 = (function (){var statearr_54244 = state_54230;
(statearr_54244[(7)] = inst_54225);

return statearr_54244;
})();
var statearr_54245_54259 = state_54230__$1;
(statearr_54245_54259[(2)] = inst_54215);

(statearr_54245_54259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0 = (function (){
var statearr_54246 = [null,null,null,null,null,null,null,null];
(statearr_54246[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__);

(statearr_54246[(1)] = (1));

return statearr_54246;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1 = (function (state_54230){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54247){var ex__2749__auto__ = e54247;
var statearr_54248_54260 = state_54230;
(statearr_54248_54260[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54230[(4)]))){
var statearr_54249_54261 = state_54230;
(statearr_54249_54261[(1)] = cljs.core.first.call(null,(state_54230[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54262 = state_54230;
state_54230 = G__54262;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = function(state_54230){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1.call(this,state_54230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54250 = f__2769__auto__.call(null);
(statearr_54250[(6)] = c__2768__auto__);

return statearr_54250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54292){
var state_val_54293 = (state_54292[(1)]);
if((state_val_54293 === (7))){
var state_54292__$1 = state_54292;
var statearr_54294_54313 = state_54292__$1;
(statearr_54294_54313[(2)] = arg);

(statearr_54294_54313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54293 === (1))){
var state_54292__$1 = state_54292;
var statearr_54295_54314 = state_54292__$1;
(statearr_54295_54314[(2)] = null);

(statearr_54295_54314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54293 === (4))){
var inst_54263 = (state_54292[(2)]);
var state_54292__$1 = state_54292;
var statearr_54296_54315 = state_54292__$1;
(statearr_54296_54315[(2)] = inst_54263);

(statearr_54296_54315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54293 === (6))){
var state_54292__$1 = state_54292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54292__$1,(9),arg);
} else {
if((state_val_54293 === (3))){
var inst_54290 = (state_54292[(2)]);
var state_54292__$1 = state_54292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54292__$1,inst_54290);
} else {
if((state_val_54293 === (2))){
var _ = (function (){var statearr_54298 = state_54292;
(statearr_54298[(4)] = cljs.core.cons.call(null,(5),(state_54292[(4)])));

return statearr_54298;
})();
var inst_54269 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54292__$1 = state_54292;
if(inst_54269){
var statearr_54299_54316 = state_54292__$1;
(statearr_54299_54316[(1)] = (6));

} else {
var statearr_54300_54317 = state_54292__$1;
(statearr_54300_54317[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54293 === (9))){
var inst_54272 = (state_54292[(2)]);
var inst_54273 = fluree.db.util.async.throw_err.call(null,inst_54272);
var state_54292__$1 = state_54292;
var statearr_54301_54318 = state_54292__$1;
(statearr_54301_54318[(2)] = inst_54273);

(statearr_54301_54318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54293 === (5))){
var _ = (function (){var statearr_54302 = state_54292;
(statearr_54302[(4)] = cljs.core.rest.call(null,(state_54292[(4)])));

return statearr_54302;
})();
var state_54292__$1 = state_54292;
var ex54297 = (state_54292__$1[(2)]);
var statearr_54303_54319 = state_54292__$1;
(statearr_54303_54319[(5)] = ex54297);


if((ex54297 instanceof Error)){
var statearr_54304_54320 = state_54292__$1;
(statearr_54304_54320[(1)] = (4));

(statearr_54304_54320[(5)] = null);

} else {
throw ex54297;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54293 === (8))){
var inst_54276 = (state_54292[(2)]);
var inst_54277 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_54276);
var inst_54278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54279 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54281 = [inst_54276];
var inst_54282 = (new cljs.core.PersistentVector(null,1,(5),inst_54280,inst_54281,null));
var inst_54283 = ["empty?",inst_54282,inst_54277];
var inst_54284 = cljs.core.PersistentHashMap.fromArrays(inst_54279,inst_54283);
var inst_54285 = [inst_54284,(10)];
var inst_54286 = (new cljs.core.PersistentVector(null,2,(5),inst_54278,inst_54285,null));
var inst_54287 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54286);
var _ = (function (){var statearr_54305 = state_54292;
(statearr_54305[(4)] = cljs.core.rest.call(null,(state_54292[(4)])));

return statearr_54305;
})();
var state_54292__$1 = (function (){var statearr_54306 = state_54292;
(statearr_54306[(7)] = inst_54287);

return statearr_54306;
})();
var statearr_54307_54321 = state_54292__$1;
(statearr_54307_54321[(2)] = inst_54277);

(statearr_54307_54321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54308 = [null,null,null,null,null,null,null,null];
(statearr_54308[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__);

(statearr_54308[(1)] = (1));

return statearr_54308;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1 = (function (state_54292){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54309){var ex__2749__auto__ = e54309;
var statearr_54310_54322 = state_54292;
(statearr_54310_54322[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54292[(4)]))){
var statearr_54311_54323 = state_54292;
(statearr_54311_54323[(1)] = cljs.core.first.call(null,(state_54292[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54324 = state_54292;
state_54292 = G__54324;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = function(state_54292){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1.call(this,state_54292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54312 = f__2769__auto__.call(null);
(statearr_54312[(6)] = c__2768__auto__);

return statearr_54312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54369 = arguments.length;
var i__5770__auto___54370 = (0);
while(true){
if((i__5770__auto___54370 < len__5769__auto___54369)){
args__5775__auto__.push((arguments[i__5770__auto___54370]));

var G__54371 = (i__5770__auto___54370 + (1));
i__5770__auto___54370 = G__54371;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54352){
var state_val_54353 = (state_54352[(1)]);
if((state_val_54353 === (1))){
var state_54352__$1 = state_54352;
var statearr_54354_54372 = state_54352__$1;
(statearr_54354_54372[(2)] = null);

(statearr_54354_54372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (2))){
var _ = (function (){var statearr_54355 = state_54352;
(statearr_54355[(4)] = cljs.core.cons.call(null,(5),(state_54352[(4)])));

return statearr_54355;
})();
var inst_54333 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54352__$1 = state_54352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54352__$1,(6),inst_54333);
} else {
if((state_val_54353 === (3))){
var inst_54350 = (state_54352[(2)]);
var state_54352__$1 = state_54352;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54352__$1,inst_54350);
} else {
if((state_val_54353 === (4))){
var inst_54327 = (state_54352[(2)]);
var state_54352__$1 = state_54352;
var statearr_54357_54373 = state_54352__$1;
(statearr_54357_54373[(2)] = inst_54327);

(statearr_54357_54373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (5))){
var _ = (function (){var statearr_54358 = state_54352;
(statearr_54358[(4)] = cljs.core.rest.call(null,(state_54352[(4)])));

return statearr_54358;
})();
var state_54352__$1 = state_54352;
var ex54356 = (state_54352__$1[(2)]);
var statearr_54359_54374 = state_54352__$1;
(statearr_54359_54374[(5)] = ex54356);


if((ex54356 instanceof Error)){
var statearr_54360_54375 = state_54352__$1;
(statearr_54360_54375[(1)] = (4));

(statearr_54360_54375[(5)] = null);

} else {
throw ex54356;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (6))){
var inst_54335 = (state_54352[(2)]);
var inst_54336 = fluree.db.util.async.throw_err.call(null,inst_54335);
var inst_54337 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_54336);
var inst_54338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54339 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54341 = [inst_54336];
var inst_54342 = (new cljs.core.PersistentVector(null,1,(5),inst_54340,inst_54341,null));
var inst_54343 = ["str",inst_54342,inst_54337];
var inst_54344 = cljs.core.PersistentHashMap.fromArrays(inst_54339,inst_54343);
var inst_54345 = [inst_54344,(10)];
var inst_54346 = (new cljs.core.PersistentVector(null,2,(5),inst_54338,inst_54345,null));
var inst_54347 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54346);
var _ = (function (){var statearr_54361 = state_54352;
(statearr_54361[(4)] = cljs.core.rest.call(null,(state_54352[(4)])));

return statearr_54361;
})();
var state_54352__$1 = (function (){var statearr_54362 = state_54352;
(statearr_54362[(7)] = inst_54347);

return statearr_54362;
})();
var statearr_54363_54376 = state_54352__$1;
(statearr_54363_54376[(2)] = inst_54337);

(statearr_54363_54376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54364 = [null,null,null,null,null,null,null,null];
(statearr_54364[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54364[(1)] = (1));

return statearr_54364;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54352){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54365){var ex__2749__auto__ = e54365;
var statearr_54366_54377 = state_54352;
(statearr_54366_54377[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54352[(4)]))){
var statearr_54367_54378 = state_54352;
(statearr_54367_54378[(1)] = cljs.core.first.call(null,(state_54352[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54379 = state_54352;
state_54352 = G__54379;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54352){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54368 = f__2769__auto__.call(null);
(statearr_54368[(6)] = c__2768__auto__);

return statearr_54368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54325){
var G__54326 = cljs.core.first.call(null,seq54325);
var seq54325__$1 = cljs.core.next.call(null,seq54325);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54326,seq54325__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54405){
var state_val_54406 = (state_54405[(1)]);
if((state_val_54406 === (1))){
var state_54405__$1 = state_54405;
var statearr_54407_54422 = state_54405__$1;
(statearr_54407_54422[(2)] = null);

(statearr_54407_54422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54406 === (2))){
var _ = (function (){var statearr_54408 = state_54405;
(statearr_54408[(4)] = cljs.core.cons.call(null,(5),(state_54405[(4)])));

return statearr_54408;
})();
var inst_54386 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54405__$1 = state_54405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54405__$1,(6),inst_54386);
} else {
if((state_val_54406 === (3))){
var inst_54403 = (state_54405[(2)]);
var state_54405__$1 = state_54405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54405__$1,inst_54403);
} else {
if((state_val_54406 === (4))){
var inst_54380 = (state_54405[(2)]);
var state_54405__$1 = state_54405;
var statearr_54410_54423 = state_54405__$1;
(statearr_54410_54423[(2)] = inst_54380);

(statearr_54410_54423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54406 === (5))){
var _ = (function (){var statearr_54411 = state_54405;
(statearr_54411[(4)] = cljs.core.rest.call(null,(state_54405[(4)])));

return statearr_54411;
})();
var state_54405__$1 = state_54405;
var ex54409 = (state_54405__$1[(2)]);
var statearr_54412_54424 = state_54405__$1;
(statearr_54412_54424[(5)] = ex54409);


if((ex54409 instanceof Error)){
var statearr_54413_54425 = state_54405__$1;
(statearr_54413_54425[(1)] = (4));

(statearr_54413_54425[(5)] = null);

} else {
throw ex54409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54406 === (6))){
var inst_54388 = (state_54405[(2)]);
var inst_54389 = fluree.db.util.async.throw_err.call(null,inst_54388);
var inst_54390 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_54389);
var inst_54391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54392 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54394 = [inst_54389];
var inst_54395 = (new cljs.core.PersistentVector(null,1,(5),inst_54393,inst_54394,null));
var inst_54396 = ["subs",inst_54395,inst_54390];
var inst_54397 = cljs.core.PersistentHashMap.fromArrays(inst_54392,inst_54396);
var inst_54398 = [inst_54397,(30)];
var inst_54399 = (new cljs.core.PersistentVector(null,2,(5),inst_54391,inst_54398,null));
var inst_54400 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54399);
var _ = (function (){var statearr_54414 = state_54405;
(statearr_54414[(4)] = cljs.core.rest.call(null,(state_54405[(4)])));

return statearr_54414;
})();
var state_54405__$1 = (function (){var statearr_54415 = state_54405;
(statearr_54415[(7)] = inst_54400);

return statearr_54415;
})();
var statearr_54416_54426 = state_54405__$1;
(statearr_54416_54426[(2)] = inst_54390);

(statearr_54416_54426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0 = (function (){
var statearr_54417 = [null,null,null,null,null,null,null,null];
(statearr_54417[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__);

(statearr_54417[(1)] = (1));

return statearr_54417;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1 = (function (state_54405){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54418){var ex__2749__auto__ = e54418;
var statearr_54419_54427 = state_54405;
(statearr_54419_54427[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54405[(4)]))){
var statearr_54420_54428 = state_54405;
(statearr_54420_54428[(1)] = cljs.core.first.call(null,(state_54405[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54429 = state_54405;
state_54405 = G__54429;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = function(state_54405){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1.call(this,state_54405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54421 = f__2769__auto__.call(null);
(statearr_54421[(6)] = c__2768__auto__);

return statearr_54421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54459){
var state_val_54460 = (state_54459[(1)]);
if((state_val_54460 === (7))){
var state_54459__$1 = state_54459;
var statearr_54461_54480 = state_54459__$1;
(statearr_54461_54480[(2)] = str);

(statearr_54461_54480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54460 === (1))){
var state_54459__$1 = state_54459;
var statearr_54462_54481 = state_54459__$1;
(statearr_54462_54481[(2)] = null);

(statearr_54462_54481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54460 === (4))){
var inst_54430 = (state_54459[(2)]);
var state_54459__$1 = state_54459;
var statearr_54463_54482 = state_54459__$1;
(statearr_54463_54482[(2)] = inst_54430);

(statearr_54463_54482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54460 === (6))){
var state_54459__$1 = state_54459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54459__$1,(9),str);
} else {
if((state_val_54460 === (3))){
var inst_54457 = (state_54459[(2)]);
var state_54459__$1 = state_54459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54459__$1,inst_54457);
} else {
if((state_val_54460 === (2))){
var _ = (function (){var statearr_54465 = state_54459;
(statearr_54465[(4)] = cljs.core.cons.call(null,(5),(state_54459[(4)])));

return statearr_54465;
})();
var inst_54436 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54459__$1 = state_54459;
if(inst_54436){
var statearr_54466_54483 = state_54459__$1;
(statearr_54466_54483[(1)] = (6));

} else {
var statearr_54467_54484 = state_54459__$1;
(statearr_54467_54484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54460 === (9))){
var inst_54439 = (state_54459[(2)]);
var inst_54440 = fluree.db.util.async.throw_err.call(null,inst_54439);
var state_54459__$1 = state_54459;
var statearr_54468_54485 = state_54459__$1;
(statearr_54468_54485[(2)] = inst_54440);

(statearr_54468_54485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54460 === (5))){
var _ = (function (){var statearr_54469 = state_54459;
(statearr_54469[(4)] = cljs.core.rest.call(null,(state_54459[(4)])));

return statearr_54469;
})();
var state_54459__$1 = state_54459;
var ex54464 = (state_54459__$1[(2)]);
var statearr_54470_54486 = state_54459__$1;
(statearr_54470_54486[(5)] = ex54464);


if((ex54464 instanceof Error)){
var statearr_54471_54487 = state_54459__$1;
(statearr_54471_54487[(1)] = (4));

(statearr_54471_54487[(5)] = null);

} else {
throw ex54464;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54460 === (8))){
var inst_54443 = (state_54459[(2)]);
var inst_54444 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_54443);
var inst_54445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54446 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54448 = [inst_54443];
var inst_54449 = (new cljs.core.PersistentVector(null,1,(5),inst_54447,inst_54448,null));
var inst_54450 = ["lower-case",inst_54449,inst_54444];
var inst_54451 = cljs.core.PersistentHashMap.fromArrays(inst_54446,inst_54450);
var inst_54452 = [inst_54451,(10)];
var inst_54453 = (new cljs.core.PersistentVector(null,2,(5),inst_54445,inst_54452,null));
var inst_54454 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54453);
var _ = (function (){var statearr_54472 = state_54459;
(statearr_54472[(4)] = cljs.core.rest.call(null,(state_54459[(4)])));

return statearr_54472;
})();
var state_54459__$1 = (function (){var statearr_54473 = state_54459;
(statearr_54473[(7)] = inst_54454);

return statearr_54473;
})();
var statearr_54474_54488 = state_54459__$1;
(statearr_54474_54488[(2)] = inst_54444);

(statearr_54474_54488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0 = (function (){
var statearr_54475 = [null,null,null,null,null,null,null,null];
(statearr_54475[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__);

(statearr_54475[(1)] = (1));

return statearr_54475;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1 = (function (state_54459){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54476){var ex__2749__auto__ = e54476;
var statearr_54477_54489 = state_54459;
(statearr_54477_54489[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54459[(4)]))){
var statearr_54478_54490 = state_54459;
(statearr_54478_54490[(1)] = cljs.core.first.call(null,(state_54459[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54491 = state_54459;
state_54459 = G__54491;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = function(state_54459){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1.call(this,state_54459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54479 = f__2769__auto__.call(null);
(statearr_54479[(6)] = c__2768__auto__);

return statearr_54479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54521){
var state_val_54522 = (state_54521[(1)]);
if((state_val_54522 === (7))){
var state_54521__$1 = state_54521;
var statearr_54523_54542 = state_54521__$1;
(statearr_54523_54542[(2)] = str);

(statearr_54523_54542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54522 === (1))){
var state_54521__$1 = state_54521;
var statearr_54524_54543 = state_54521__$1;
(statearr_54524_54543[(2)] = null);

(statearr_54524_54543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54522 === (4))){
var inst_54492 = (state_54521[(2)]);
var state_54521__$1 = state_54521;
var statearr_54525_54544 = state_54521__$1;
(statearr_54525_54544[(2)] = inst_54492);

(statearr_54525_54544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54522 === (6))){
var state_54521__$1 = state_54521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54521__$1,(9),str);
} else {
if((state_val_54522 === (3))){
var inst_54519 = (state_54521[(2)]);
var state_54521__$1 = state_54521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54521__$1,inst_54519);
} else {
if((state_val_54522 === (2))){
var _ = (function (){var statearr_54527 = state_54521;
(statearr_54527[(4)] = cljs.core.cons.call(null,(5),(state_54521[(4)])));

return statearr_54527;
})();
var inst_54498 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54521__$1 = state_54521;
if(inst_54498){
var statearr_54528_54545 = state_54521__$1;
(statearr_54528_54545[(1)] = (6));

} else {
var statearr_54529_54546 = state_54521__$1;
(statearr_54529_54546[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54522 === (9))){
var inst_54501 = (state_54521[(2)]);
var inst_54502 = fluree.db.util.async.throw_err.call(null,inst_54501);
var state_54521__$1 = state_54521;
var statearr_54530_54547 = state_54521__$1;
(statearr_54530_54547[(2)] = inst_54502);

(statearr_54530_54547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54522 === (5))){
var _ = (function (){var statearr_54531 = state_54521;
(statearr_54531[(4)] = cljs.core.rest.call(null,(state_54521[(4)])));

return statearr_54531;
})();
var state_54521__$1 = state_54521;
var ex54526 = (state_54521__$1[(2)]);
var statearr_54532_54548 = state_54521__$1;
(statearr_54532_54548[(5)] = ex54526);


if((ex54526 instanceof Error)){
var statearr_54533_54549 = state_54521__$1;
(statearr_54533_54549[(1)] = (4));

(statearr_54533_54549[(5)] = null);

} else {
throw ex54526;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54522 === (8))){
var inst_54505 = (state_54521[(2)]);
var inst_54506 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_54505);
var inst_54507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54508 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54510 = [inst_54505];
var inst_54511 = (new cljs.core.PersistentVector(null,1,(5),inst_54509,inst_54510,null));
var inst_54512 = ["upper-case",inst_54511,inst_54506];
var inst_54513 = cljs.core.PersistentHashMap.fromArrays(inst_54508,inst_54512);
var inst_54514 = [inst_54513,(10)];
var inst_54515 = (new cljs.core.PersistentVector(null,2,(5),inst_54507,inst_54514,null));
var inst_54516 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54515);
var _ = (function (){var statearr_54534 = state_54521;
(statearr_54534[(4)] = cljs.core.rest.call(null,(state_54521[(4)])));

return statearr_54534;
})();
var state_54521__$1 = (function (){var statearr_54535 = state_54521;
(statearr_54535[(7)] = inst_54516);

return statearr_54535;
})();
var statearr_54536_54550 = state_54521__$1;
(statearr_54536_54550[(2)] = inst_54506);

(statearr_54536_54550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0 = (function (){
var statearr_54537 = [null,null,null,null,null,null,null,null];
(statearr_54537[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__);

(statearr_54537[(1)] = (1));

return statearr_54537;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1 = (function (state_54521){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54538){var ex__2749__auto__ = e54538;
var statearr_54539_54551 = state_54521;
(statearr_54539_54551[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54521[(4)]))){
var statearr_54540_54552 = state_54521;
(statearr_54540_54552[(1)] = cljs.core.first.call(null,(state_54521[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54553 = state_54521;
state_54521 = G__54553;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = function(state_54521){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1.call(this,state_54521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54541 = f__2769__auto__.call(null);
(statearr_54541[(6)] = c__2768__auto__);

return statearr_54541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54555 = arguments.length;
switch (G__54555) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54583){
var state_val_54584 = (state_54583[(1)]);
if((state_val_54584 === (1))){
var state_54583__$1 = state_54583;
var statearr_54585_54601 = state_54583__$1;
(statearr_54585_54601[(2)] = null);

(statearr_54585_54601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54584 === (2))){
var _ = (function (){var statearr_54586 = state_54583;
(statearr_54586[(4)] = cljs.core.cons.call(null,(5),(state_54583[(4)])));

return statearr_54586;
})();
var inst_54565 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_54583__$1 = state_54583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54583__$1,(6),inst_54565);
} else {
if((state_val_54584 === (3))){
var inst_54581 = (state_54583[(2)]);
var state_54583__$1 = state_54583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54583__$1,inst_54581);
} else {
if((state_val_54584 === (4))){
var inst_54556 = (state_54583[(2)]);
var state_54583__$1 = state_54583;
var statearr_54588_54602 = state_54583__$1;
(statearr_54588_54602[(2)] = inst_54556);

(statearr_54588_54602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54584 === (5))){
var _ = (function (){var statearr_54589 = state_54583;
(statearr_54589[(4)] = cljs.core.rest.call(null,(state_54583[(4)])));

return statearr_54589;
})();
var state_54583__$1 = state_54583;
var ex54587 = (state_54583__$1[(2)]);
var statearr_54590_54603 = state_54583__$1;
(statearr_54590_54603[(5)] = ex54587);


if((ex54587 instanceof Error)){
var statearr_54591_54604 = state_54583__$1;
(statearr_54591_54604[(1)] = (4));

(statearr_54591_54604[(5)] = null);

} else {
throw ex54587;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54584 === (6))){
var inst_54567 = (state_54583[(2)]);
var inst_54568 = fluree.db.util.async.throw_err.call(null,inst_54567);
var inst_54569 = cljs.core.nth.call(null,inst_54568,(0),null);
var inst_54570 = cljs.core.nth.call(null,inst_54568,(1),null);
var inst_54571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54572 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54573 = ["?s","?ctx",inst_54569];
var inst_54574 = cljs.core.PersistentHashMap.fromArrays(inst_54572,inst_54573);
var inst_54575 = ((10) + inst_54570);
var inst_54576 = [inst_54574,inst_54575];
var inst_54577 = (new cljs.core.PersistentVector(null,2,(5),inst_54571,inst_54576,null));
var inst_54578 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54577);
var _ = (function (){var statearr_54592 = state_54583;
(statearr_54592[(4)] = cljs.core.rest.call(null,(state_54583[(4)])));

return statearr_54592;
})();
var state_54583__$1 = (function (){var statearr_54593 = state_54583;
(statearr_54593[(7)] = inst_54578);

return statearr_54593;
})();
var statearr_54594_54605 = state_54583__$1;
(statearr_54594_54605[(2)] = inst_54569);

(statearr_54594_54605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54595 = [null,null,null,null,null,null,null,null];
(statearr_54595[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54595[(1)] = (1));

return statearr_54595;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54583){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54596){var ex__2749__auto__ = e54596;
var statearr_54597_54606 = state_54583;
(statearr_54597_54606[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54583[(4)]))){
var statearr_54598_54607 = state_54583;
(statearr_54598_54607[(1)] = cljs.core.first.call(null,(state_54583[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54608 = state_54583;
state_54583 = G__54608;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54583){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54599 = f__2769__auto__.call(null);
(statearr_54599[(6)] = c__2768__auto__);

return statearr_54599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54610 = arguments.length;
switch (G__54610) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54648){
var state_val_54649 = (state_54648[(1)]);
if((state_val_54649 === (7))){
var inst_54641 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54648__$1 = state_54648;
var statearr_54650_54670 = state_54648__$1;
(statearr_54650_54670[(2)] = inst_54641);

(statearr_54650_54670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (1))){
var state_54648__$1 = state_54648;
var statearr_54651_54671 = state_54648__$1;
(statearr_54651_54671[(2)] = null);

(statearr_54651_54671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (4))){
var inst_54611 = (state_54648[(2)]);
var state_54648__$1 = state_54648;
var statearr_54652_54672 = state_54648__$1;
(statearr_54652_54672[(2)] = inst_54611);

(statearr_54652_54672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (6))){
var inst_54622 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_54648__$1 = state_54648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54648__$1,(10),inst_54622);
} else {
if((state_val_54649 === (3))){
var inst_54646 = (state_54648[(2)]);
var state_54648__$1 = state_54648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54648__$1,inst_54646);
} else {
if((state_val_54649 === (2))){
var _ = (function (){var statearr_54654 = state_54648;
(statearr_54654[(4)] = cljs.core.cons.call(null,(5),(state_54648[(4)])));

return statearr_54654;
})();
var inst_54617 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54648__$1 = state_54648;
if(cljs.core.truth_(inst_54617)){
var statearr_54655_54673 = state_54648__$1;
(statearr_54655_54673[(1)] = (6));

} else {
var statearr_54656_54674 = state_54648__$1;
(statearr_54656_54674[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (9))){
var inst_54628 = (state_54648[(2)]);
var inst_54629 = fluree.db.util.async.throw_err.call(null,inst_54628);
var inst_54630 = cljs.core.nth.call(null,inst_54629,(0),null);
var inst_54631 = cljs.core.nth.call(null,inst_54629,(1),null);
var inst_54632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54633 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54634 = ["?p","?ctx",inst_54630];
var inst_54635 = cljs.core.PersistentHashMap.fromArrays(inst_54633,inst_54634);
var inst_54636 = ((10) + inst_54631);
var inst_54637 = [inst_54635,inst_54636];
var inst_54638 = (new cljs.core.PersistentVector(null,2,(5),inst_54632,inst_54637,null));
var inst_54639 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54638);
var state_54648__$1 = (function (){var statearr_54657 = state_54648;
(statearr_54657[(7)] = inst_54639);

return statearr_54657;
})();
var statearr_54658_54675 = state_54648__$1;
(statearr_54658_54675[(2)] = inst_54630);

(statearr_54658_54675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (5))){
var _ = (function (){var statearr_54659 = state_54648;
(statearr_54659[(4)] = cljs.core.rest.call(null,(state_54648[(4)])));

return statearr_54659;
})();
var state_54648__$1 = state_54648;
var ex54653 = (state_54648__$1[(2)]);
var statearr_54660_54676 = state_54648__$1;
(statearr_54660_54676[(5)] = ex54653);


if((ex54653 instanceof Error)){
var statearr_54661_54677 = state_54648__$1;
(statearr_54661_54677[(1)] = (4));

(statearr_54661_54677[(5)] = null);

} else {
throw ex54653;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (10))){
var inst_54624 = (state_54648[(2)]);
var inst_54625 = fluree.db.util.async.throw_err.call(null,inst_54624);
var inst_54626 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_54625);
var state_54648__$1 = state_54648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54648__$1,(9),inst_54626);
} else {
if((state_val_54649 === (8))){
var inst_54643 = (state_54648[(2)]);
var _ = (function (){var statearr_54662 = state_54648;
(statearr_54662[(4)] = cljs.core.rest.call(null,(state_54648[(4)])));

return statearr_54662;
})();
var state_54648__$1 = state_54648;
var statearr_54663_54678 = state_54648__$1;
(statearr_54663_54678[(2)] = inst_54643);

(statearr_54663_54678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54664 = [null,null,null,null,null,null,null,null];
(statearr_54664[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54664[(1)] = (1));

return statearr_54664;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54648){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54665){var ex__2749__auto__ = e54665;
var statearr_54666_54679 = state_54648;
(statearr_54666_54679[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54648[(4)]))){
var statearr_54667_54680 = state_54648;
(statearr_54667_54680[(1)] = cljs.core.first.call(null,(state_54648[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54681 = state_54648;
state_54648 = G__54681;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54648){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54668 = f__2769__auto__.call(null);
(statearr_54668[(6)] = c__2768__auto__);

return statearr_54668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54730 = arguments.length;
var i__5770__auto___54731 = (0);
while(true){
if((i__5770__auto___54731 < len__5769__auto___54730)){
args__5775__auto__.push((arguments[i__5770__auto___54731]));

var G__54732 = (i__5770__auto___54731 + (1));
i__5770__auto___54731 = G__54732;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54713){
var state_val_54714 = (state_54713[(1)]);
if((state_val_54714 === (1))){
var state_54713__$1 = state_54713;
var statearr_54715_54733 = state_54713__$1;
(statearr_54715_54733[(2)] = null);

(statearr_54715_54733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54714 === (2))){
var _ = (function (){var statearr_54716 = state_54713;
(statearr_54716[(4)] = cljs.core.cons.call(null,(5),(state_54713[(4)])));

return statearr_54716;
})();
var inst_54690 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54713__$1 = state_54713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54713__$1,(6),inst_54690);
} else {
if((state_val_54714 === (3))){
var inst_54711 = (state_54713[(2)]);
var state_54713__$1 = state_54713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54713__$1,inst_54711);
} else {
if((state_val_54714 === (4))){
var inst_54684 = (state_54713[(2)]);
var state_54713__$1 = state_54713;
var statearr_54718_54734 = state_54713__$1;
(statearr_54718_54734[(2)] = inst_54684);

(statearr_54718_54734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54714 === (5))){
var _ = (function (){var statearr_54719 = state_54713;
(statearr_54719[(4)] = cljs.core.rest.call(null,(state_54713[(4)])));

return statearr_54719;
})();
var state_54713__$1 = state_54713;
var ex54717 = (state_54713__$1[(2)]);
var statearr_54720_54735 = state_54713__$1;
(statearr_54720_54735[(5)] = ex54717);


if((ex54717 instanceof Error)){
var statearr_54721_54736 = state_54713__$1;
(statearr_54721_54736[(1)] = (4));

(statearr_54721_54736[(5)] = null);

} else {
throw ex54717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54714 === (6))){
var inst_54692 = (state_54713[(2)]);
var inst_54693 = fluree.db.util.async.throw_err.call(null,inst_54692);
var inst_54694 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_54693);
var inst_54695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54696 = [inst_54693];
var inst_54697 = (new cljs.core.PersistentVector(null,1,(5),inst_54695,inst_54696,null));
var inst_54698 = cljs.core.count.call(null,inst_54697);
var inst_54699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54700 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54702 = [inst_54693];
var inst_54703 = (new cljs.core.PersistentVector(null,1,(5),inst_54701,inst_54702,null));
var inst_54704 = ["and",inst_54703,inst_54694];
var inst_54705 = cljs.core.PersistentHashMap.fromArrays(inst_54700,inst_54704);
var inst_54706 = [inst_54705,inst_54698];
var inst_54707 = (new cljs.core.PersistentVector(null,2,(5),inst_54699,inst_54706,null));
var inst_54708 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54707);
var _ = (function (){var statearr_54722 = state_54713;
(statearr_54722[(4)] = cljs.core.rest.call(null,(state_54713[(4)])));

return statearr_54722;
})();
var state_54713__$1 = (function (){var statearr_54723 = state_54713;
(statearr_54723[(7)] = inst_54708);

return statearr_54723;
})();
var statearr_54724_54737 = state_54713__$1;
(statearr_54724_54737[(2)] = inst_54694);

(statearr_54724_54737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54725 = [null,null,null,null,null,null,null,null];
(statearr_54725[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54725[(1)] = (1));

return statearr_54725;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54713){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54726){var ex__2749__auto__ = e54726;
var statearr_54727_54738 = state_54713;
(statearr_54727_54738[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54713[(4)]))){
var statearr_54728_54739 = state_54713;
(statearr_54728_54739[(1)] = cljs.core.first.call(null,(state_54713[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54740 = state_54713;
state_54713 = G__54740;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54713){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54729 = f__2769__auto__.call(null);
(statearr_54729[(6)] = c__2768__auto__);

return statearr_54729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54682){
var G__54683 = cljs.core.first.call(null,seq54682);
var seq54682__$1 = cljs.core.next.call(null,seq54682);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54683,seq54682__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54789 = arguments.length;
var i__5770__auto___54790 = (0);
while(true){
if((i__5770__auto___54790 < len__5769__auto___54789)){
args__5775__auto__.push((arguments[i__5770__auto___54790]));

var G__54791 = (i__5770__auto___54790 + (1));
i__5770__auto___54790 = G__54791;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54772){
var state_val_54773 = (state_54772[(1)]);
if((state_val_54773 === (1))){
var state_54772__$1 = state_54772;
var statearr_54774_54792 = state_54772__$1;
(statearr_54774_54792[(2)] = null);

(statearr_54774_54792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54773 === (2))){
var _ = (function (){var statearr_54775 = state_54772;
(statearr_54775[(4)] = cljs.core.cons.call(null,(5),(state_54772[(4)])));

return statearr_54775;
})();
var inst_54749 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54772__$1 = state_54772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54772__$1,(6),inst_54749);
} else {
if((state_val_54773 === (3))){
var inst_54770 = (state_54772[(2)]);
var state_54772__$1 = state_54772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54772__$1,inst_54770);
} else {
if((state_val_54773 === (4))){
var inst_54743 = (state_54772[(2)]);
var state_54772__$1 = state_54772;
var statearr_54777_54793 = state_54772__$1;
(statearr_54777_54793[(2)] = inst_54743);

(statearr_54777_54793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54773 === (5))){
var _ = (function (){var statearr_54778 = state_54772;
(statearr_54778[(4)] = cljs.core.rest.call(null,(state_54772[(4)])));

return statearr_54778;
})();
var state_54772__$1 = state_54772;
var ex54776 = (state_54772__$1[(2)]);
var statearr_54779_54794 = state_54772__$1;
(statearr_54779_54794[(5)] = ex54776);


if((ex54776 instanceof Error)){
var statearr_54780_54795 = state_54772__$1;
(statearr_54780_54795[(1)] = (4));

(statearr_54780_54795[(5)] = null);

} else {
throw ex54776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54773 === (6))){
var inst_54751 = (state_54772[(2)]);
var inst_54752 = fluree.db.util.async.throw_err.call(null,inst_54751);
var inst_54753 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_54752);
var inst_54754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54755 = [inst_54752];
var inst_54756 = (new cljs.core.PersistentVector(null,1,(5),inst_54754,inst_54755,null));
var inst_54757 = cljs.core.count.call(null,inst_54756);
var inst_54758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54759 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54761 = [inst_54752];
var inst_54762 = (new cljs.core.PersistentVector(null,1,(5),inst_54760,inst_54761,null));
var inst_54763 = ["or",inst_54762,inst_54753];
var inst_54764 = cljs.core.PersistentHashMap.fromArrays(inst_54759,inst_54763);
var inst_54765 = [inst_54764,inst_54757];
var inst_54766 = (new cljs.core.PersistentVector(null,2,(5),inst_54758,inst_54765,null));
var inst_54767 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54766);
var _ = (function (){var statearr_54781 = state_54772;
(statearr_54781[(4)] = cljs.core.rest.call(null,(state_54772[(4)])));

return statearr_54781;
})();
var state_54772__$1 = (function (){var statearr_54782 = state_54772;
(statearr_54782[(7)] = inst_54767);

return statearr_54782;
})();
var statearr_54783_54796 = state_54772__$1;
(statearr_54783_54796[(2)] = inst_54753);

(statearr_54783_54796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54784 = [null,null,null,null,null,null,null,null];
(statearr_54784[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54784[(1)] = (1));

return statearr_54784;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54772){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54785){var ex__2749__auto__ = e54785;
var statearr_54786_54797 = state_54772;
(statearr_54786_54797[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54772[(4)]))){
var statearr_54787_54798 = state_54772;
(statearr_54787_54798[(1)] = cljs.core.first.call(null,(state_54772[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54799 = state_54772;
state_54772 = G__54799;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54772){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54788 = f__2769__auto__.call(null);
(statearr_54788[(6)] = c__2768__auto__);

return statearr_54788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54741){
var G__54742 = cljs.core.first.call(null,seq54741);
var seq54741__$1 = cljs.core.next.call(null,seq54741);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54742,seq54741__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54837){
var state_val_54838 = (state_54837[(1)]);
if((state_val_54838 === (7))){
var inst_54813 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54837__$1 = state_54837;
if(inst_54813){
var statearr_54839_54862 = state_54837__$1;
(statearr_54839_54862[(1)] = (10));

} else {
var statearr_54840_54863 = state_54837__$1;
(statearr_54840_54863[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (1))){
var state_54837__$1 = state_54837;
var statearr_54841_54864 = state_54837__$1;
(statearr_54841_54864[(2)] = null);

(statearr_54841_54864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (4))){
var inst_54800 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
var statearr_54842_54865 = state_54837__$1;
(statearr_54842_54865[(2)] = inst_54800);

(statearr_54842_54865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (13))){
var inst_54816 = (state_54837[(2)]);
var inst_54817 = fluree.db.util.async.throw_err.call(null,inst_54816);
var state_54837__$1 = state_54837;
var statearr_54843_54866 = state_54837__$1;
(statearr_54843_54866[(2)] = inst_54817);

(statearr_54843_54866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (6))){
var inst_54808 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54837__$1,(9),inst_54808);
} else {
if((state_val_54838 === (3))){
var inst_54835 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54837__$1,inst_54835);
} else {
if((state_val_54838 === (12))){
var inst_54820 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
var statearr_54844_54867 = state_54837__$1;
(statearr_54844_54867[(2)] = inst_54820);

(statearr_54844_54867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (2))){
var _ = (function (){var statearr_54845 = state_54837;
(statearr_54845[(4)] = cljs.core.cons.call(null,(5),(state_54837[(4)])));

return statearr_54845;
})();
var inst_54806 = cljs.core.vector_QMARK_.call(null,coll);
var state_54837__$1 = state_54837;
if(inst_54806){
var statearr_54846_54868 = state_54837__$1;
(statearr_54846_54868[(1)] = (6));

} else {
var statearr_54847_54869 = state_54837__$1;
(statearr_54847_54869[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (11))){
var state_54837__$1 = state_54837;
var statearr_54849_54870 = state_54837__$1;
(statearr_54849_54870[(2)] = coll);

(statearr_54849_54870[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (9))){
var inst_54810 = (state_54837[(2)]);
var inst_54811 = fluree.db.util.async.throw_err.call(null,inst_54810);
var state_54837__$1 = state_54837;
var statearr_54850_54871 = state_54837__$1;
(statearr_54850_54871[(2)] = inst_54811);

(statearr_54850_54871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (5))){
var _ = (function (){var statearr_54851 = state_54837;
(statearr_54851[(4)] = cljs.core.rest.call(null,(state_54837[(4)])));

return statearr_54851;
})();
var state_54837__$1 = state_54837;
var ex54848 = (state_54837__$1[(2)]);
var statearr_54852_54872 = state_54837__$1;
(statearr_54852_54872[(5)] = ex54848);


if((ex54848 instanceof Error)){
var statearr_54853_54873 = state_54837__$1;
(statearr_54853_54873[(1)] = (4));

(statearr_54853_54873[(5)] = null);

} else {
throw ex54848;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (10))){
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54837__$1,(13),coll);
} else {
if((state_val_54838 === (8))){
var inst_54822 = (state_54837[(2)]);
var inst_54823 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_54822);
var inst_54824 = cljs.core.count.call(null,inst_54823);
var inst_54825 = ((9) + inst_54824);
var inst_54826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54827 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54828 = ["count",inst_54822,inst_54824];
var inst_54829 = cljs.core.PersistentHashMap.fromArrays(inst_54827,inst_54828);
var inst_54830 = [inst_54829,inst_54825];
var inst_54831 = (new cljs.core.PersistentVector(null,2,(5),inst_54826,inst_54830,null));
var inst_54832 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54831);
var _ = (function (){var statearr_54854 = state_54837;
(statearr_54854[(4)] = cljs.core.rest.call(null,(state_54837[(4)])));

return statearr_54854;
})();
var state_54837__$1 = (function (){var statearr_54855 = state_54837;
(statearr_54855[(7)] = inst_54832);

return statearr_54855;
})();
var statearr_54856_54874 = state_54837__$1;
(statearr_54856_54874[(2)] = inst_54824);

(statearr_54856_54874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0 = (function (){
var statearr_54857 = [null,null,null,null,null,null,null,null];
(statearr_54857[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__);

(statearr_54857[(1)] = (1));

return statearr_54857;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1 = (function (state_54837){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54858){var ex__2749__auto__ = e54858;
var statearr_54859_54875 = state_54837;
(statearr_54859_54875[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54837[(4)]))){
var statearr_54860_54876 = state_54837;
(statearr_54860_54876[(1)] = cljs.core.first.call(null,(state_54837[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54877 = state_54837;
state_54837 = G__54877;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = function(state_54837){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1.call(this,state_54837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54861 = f__2769__auto__.call(null);
(statearr_54861[(6)] = c__2768__auto__);

return statearr_54861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54927){
var state_val_54928 = (state_54927[(1)]);
if((state_val_54928 === (7))){
var state_54927__$1 = state_54927;
var statearr_54929_54962 = state_54927__$1;
(statearr_54929_54962[(2)] = subject);

(statearr_54929_54962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (1))){
var state_54927__$1 = state_54927;
var statearr_54930_54963 = state_54927__$1;
(statearr_54930_54963[(2)] = null);

(statearr_54930_54963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (4))){
var inst_54878 = (state_54927[(2)]);
var state_54927__$1 = state_54927;
var statearr_54931_54964 = state_54927__$1;
(statearr_54931_54964[(2)] = inst_54878);

(statearr_54931_54964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (15))){
var inst_54891 = (state_54927[(7)]);
var state_54927__$1 = state_54927;
var statearr_54932_54965 = state_54927__$1;
(statearr_54932_54965[(2)] = inst_54891);

(statearr_54932_54965[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (13))){
var inst_54895 = (state_54927[(2)]);
var inst_54896 = fluree.db.util.async.throw_err.call(null,inst_54895);
var state_54927__$1 = state_54927;
var statearr_54933_54966 = state_54927__$1;
(statearr_54933_54966[(2)] = inst_54896);

(statearr_54933_54966[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (6))){
var state_54927__$1 = state_54927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54927__$1,(9),subject);
} else {
if((state_val_54928 === (17))){
var inst_54891 = (state_54927[(7)]);
var inst_54905 = cljs.core.first.call(null,inst_54891);
var state_54927__$1 = state_54927;
var statearr_54934_54967 = state_54927__$1;
(statearr_54934_54967[(2)] = inst_54905);

(statearr_54934_54967[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (3))){
var inst_54925 = (state_54927[(2)]);
var state_54927__$1 = state_54927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54927__$1,inst_54925);
} else {
if((state_val_54928 === (12))){
var inst_54891 = (state_54927[(7)]);
var inst_54899 = (state_54927[(2)]);
var inst_54900 = cljs.core.vector_QMARK_.call(null,inst_54891);
var state_54927__$1 = (function (){var statearr_54935 = state_54927;
(statearr_54935[(8)] = inst_54899);

return statearr_54935;
})();
if(inst_54900){
var statearr_54936_54968 = state_54927__$1;
(statearr_54936_54968[(1)] = (14));

} else {
var statearr_54937_54969 = state_54927__$1;
(statearr_54937_54969[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (2))){
var _ = (function (){var statearr_54938 = state_54927;
(statearr_54938[(4)] = cljs.core.cons.call(null,(5),(state_54927[(4)])));

return statearr_54938;
})();
var inst_54884 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54927__$1 = state_54927;
if(inst_54884){
var statearr_54939_54970 = state_54927__$1;
(statearr_54939_54970[(1)] = (6));

} else {
var statearr_54940_54971 = state_54927__$1;
(statearr_54940_54971[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (19))){
var inst_54908 = (state_54927[(2)]);
var state_54927__$1 = state_54927;
var statearr_54941_54972 = state_54927__$1;
(statearr_54941_54972[(2)] = inst_54908);

(statearr_54941_54972[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (11))){
var state_54927__$1 = state_54927;
var statearr_54943_54973 = state_54927__$1;
(statearr_54943_54973[(2)] = pred);

(statearr_54943_54973[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (9))){
var inst_54887 = (state_54927[(2)]);
var inst_54888 = fluree.db.util.async.throw_err.call(null,inst_54887);
var state_54927__$1 = state_54927;
var statearr_54944_54974 = state_54927__$1;
(statearr_54944_54974[(2)] = inst_54888);

(statearr_54944_54974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (5))){
var _ = (function (){var statearr_54945 = state_54927;
(statearr_54945[(4)] = cljs.core.rest.call(null,(state_54927[(4)])));

return statearr_54945;
})();
var state_54927__$1 = state_54927;
var ex54942 = (state_54927__$1[(2)]);
var statearr_54946_54975 = state_54927__$1;
(statearr_54946_54975[(5)] = ex54942);


if((ex54942 instanceof Error)){
var statearr_54947_54976 = state_54927__$1;
(statearr_54947_54976[(1)] = (4));

(statearr_54947_54976[(5)] = null);

} else {
throw ex54942;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (14))){
var inst_54891 = (state_54927[(7)]);
var inst_54902 = cljs.core.count.call(null,inst_54891);
var inst_54903 = cljs.core._EQ_.call(null,(1),inst_54902);
var state_54927__$1 = state_54927;
if(inst_54903){
var statearr_54948_54977 = state_54927__$1;
(statearr_54948_54977[(1)] = (17));

} else {
var statearr_54949_54978 = state_54927__$1;
(statearr_54949_54978[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (16))){
var inst_54891 = (state_54927[(7)]);
var inst_54899 = (state_54927[(8)]);
var inst_54911 = (state_54927[(2)]);
var inst_54912 = fluree.db.dbfunctions.internal.get.call(null,inst_54911,inst_54899);
var inst_54913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54914 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54916 = [inst_54891,inst_54899];
var inst_54917 = (new cljs.core.PersistentVector(null,2,(5),inst_54915,inst_54916,null));
var inst_54918 = ["get",inst_54917,inst_54912];
var inst_54919 = cljs.core.PersistentHashMap.fromArrays(inst_54914,inst_54918);
var inst_54920 = [inst_54919,(10)];
var inst_54921 = (new cljs.core.PersistentVector(null,2,(5),inst_54913,inst_54920,null));
var inst_54922 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54921);
var _ = (function (){var statearr_54950 = state_54927;
(statearr_54950[(4)] = cljs.core.rest.call(null,(state_54927[(4)])));

return statearr_54950;
})();
var state_54927__$1 = (function (){var statearr_54951 = state_54927;
(statearr_54951[(9)] = inst_54922);

return statearr_54951;
})();
var statearr_54952_54979 = state_54927__$1;
(statearr_54952_54979[(2)] = inst_54912);

(statearr_54952_54979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (10))){
var state_54927__$1 = state_54927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54927__$1,(13),pred);
} else {
if((state_val_54928 === (18))){
var inst_54891 = (state_54927[(7)]);
var state_54927__$1 = state_54927;
var statearr_54953_54980 = state_54927__$1;
(statearr_54953_54980[(2)] = inst_54891);

(statearr_54953_54980[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54928 === (8))){
var inst_54891 = (state_54927[(2)]);
var inst_54892 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_54927__$1 = (function (){var statearr_54954 = state_54927;
(statearr_54954[(7)] = inst_54891);

return statearr_54954;
})();
if(inst_54892){
var statearr_54955_54981 = state_54927__$1;
(statearr_54955_54981[(1)] = (10));

} else {
var statearr_54956_54982 = state_54927__$1;
(statearr_54956_54982[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0 = (function (){
var statearr_54957 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54957[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__);

(statearr_54957[(1)] = (1));

return statearr_54957;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1 = (function (state_54927){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54958){var ex__2749__auto__ = e54958;
var statearr_54959_54983 = state_54927;
(statearr_54959_54983[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54927[(4)]))){
var statearr_54960_54984 = state_54927;
(statearr_54960_54984[(1)] = cljs.core.first.call(null,(state_54927[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54985 = state_54927;
state_54927 = G__54985;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = function(state_54927){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1.call(this,state_54927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54961 = f__2769__auto__.call(null);
(statearr_54961[(6)] = c__2768__auto__);

return statearr_54961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55024){
var state_val_55025 = (state_55024[(1)]);
if((state_val_55025 === (7))){
var inst_54992 = (state_55024[(7)]);
var state_55024__$1 = state_55024;
var statearr_55026_55050 = state_55024__$1;
(statearr_55026_55050[(2)] = inst_54992);

(statearr_55026_55050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (1))){
var state_55024__$1 = state_55024;
var statearr_55027_55051 = state_55024__$1;
(statearr_55027_55051[(2)] = null);

(statearr_55027_55051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (4))){
var inst_54986 = (state_55024[(2)]);
var state_55024__$1 = state_55024;
var statearr_55028_55052 = state_55024__$1;
(statearr_55028_55052[(2)] = inst_54986);

(statearr_55028_55052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (6))){
var inst_54994 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55024__$1 = state_55024;
var statearr_55029_55053 = state_55024__$1;
(statearr_55029_55053[(2)] = inst_54994);

(statearr_55029_55053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (3))){
var inst_55022 = (state_55024[(2)]);
var state_55024__$1 = state_55024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55024__$1,inst_55022);
} else {
if((state_val_55025 === (12))){
var inst_55004 = (state_55024[(2)]);
var inst_55005 = fluree.db.util.async.throw_err.call(null,inst_55004);
var inst_55006 = cljs.core.nth.call(null,inst_55005,(0),null);
var inst_55007 = cljs.core.nth.call(null,inst_55005,(1),null);
var inst_55008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55009 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55010 = ["?pO","?ctx",inst_55006];
var inst_55011 = cljs.core.PersistentHashMap.fromArrays(inst_55009,inst_55010);
var inst_55012 = ((10) + inst_55007);
var inst_55013 = [inst_55011,inst_55012];
var inst_55014 = (new cljs.core.PersistentVector(null,2,(5),inst_55008,inst_55013,null));
var inst_55015 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55014);
var state_55024__$1 = (function (){var statearr_55030 = state_55024;
(statearr_55030[(8)] = inst_55015);

return statearr_55030;
})();
var statearr_55031_55054 = state_55024__$1;
(statearr_55031_55054[(2)] = inst_55006);

(statearr_55031_55054[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (2))){
var inst_54992 = (state_55024[(7)]);
var _ = (function (){var statearr_55032 = state_55024;
(statearr_55032[(4)] = cljs.core.cons.call(null,(5),(state_55024[(4)])));

return statearr_55032;
})();
var inst_54992__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55024__$1 = (function (){var statearr_55033 = state_55024;
(statearr_55033[(7)] = inst_54992__$1);

return statearr_55033;
})();
if(cljs.core.truth_(inst_54992__$1)){
var statearr_55034_55055 = state_55024__$1;
(statearr_55034_55055[(1)] = (6));

} else {
var statearr_55035_55056 = state_55024__$1;
(statearr_55035_55056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (11))){
var inst_55019 = (state_55024[(2)]);
var _ = (function (){var statearr_55037 = state_55024;
(statearr_55037[(4)] = cljs.core.rest.call(null,(state_55024[(4)])));

return statearr_55037;
})();
var state_55024__$1 = state_55024;
var statearr_55038_55057 = state_55024__$1;
(statearr_55038_55057[(2)] = inst_55019);

(statearr_55038_55057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (9))){
var inst_55002 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_55024__$1 = state_55024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55024__$1,(12),inst_55002);
} else {
if((state_val_55025 === (5))){
var _ = (function (){var statearr_55039 = state_55024;
(statearr_55039[(4)] = cljs.core.rest.call(null,(state_55024[(4)])));

return statearr_55039;
})();
var state_55024__$1 = state_55024;
var ex55036 = (state_55024__$1[(2)]);
var statearr_55040_55058 = state_55024__$1;
(statearr_55040_55058[(5)] = ex55036);


if((ex55036 instanceof Error)){
var statearr_55041_55059 = state_55024__$1;
(statearr_55041_55059[(1)] = (4));

(statearr_55041_55059[(5)] = null);

} else {
throw ex55036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (10))){
var inst_55017 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55024__$1 = state_55024;
var statearr_55042_55060 = state_55024__$1;
(statearr_55042_55060[(2)] = inst_55017);

(statearr_55042_55060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55025 === (8))){
var inst_54997 = (state_55024[(2)]);
var state_55024__$1 = state_55024;
if(cljs.core.truth_(inst_54997)){
var statearr_55043_55061 = state_55024__$1;
(statearr_55043_55061[(1)] = (9));

} else {
var statearr_55044_55062 = state_55024__$1;
(statearr_55044_55062[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_55045 = [null,null,null,null,null,null,null,null,null];
(statearr_55045[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_55045[(1)] = (1));

return statearr_55045;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_55024){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55046){var ex__2749__auto__ = e55046;
var statearr_55047_55063 = state_55024;
(statearr_55047_55063[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55024[(4)]))){
var statearr_55048_55064 = state_55024;
(statearr_55048_55064[(1)] = cljs.core.first.call(null,(state_55024[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55065 = state_55024;
state_55024 = G__55065;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = function(state_55024){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_55024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55049 = f__2769__auto__.call(null);
(statearr_55049[(6)] = c__2768__auto__);

return statearr_55049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55117){
var state_val_55118 = (state_55117[(1)]);
if((state_val_55118 === (7))){
var state_55117__$1 = state_55117;
var statearr_55119_55152 = state_55117__$1;
(statearr_55119_55152[(2)] = subject);

(statearr_55119_55152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (1))){
var state_55117__$1 = state_55117;
var statearr_55120_55153 = state_55117__$1;
(statearr_55120_55153[(2)] = null);

(statearr_55120_55153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (4))){
var inst_55066 = (state_55117[(2)]);
var state_55117__$1 = state_55117;
var statearr_55121_55154 = state_55117__$1;
(statearr_55121_55154[(2)] = inst_55066);

(statearr_55121_55154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (15))){
var inst_55079 = (state_55117[(7)]);
var state_55117__$1 = state_55117;
var statearr_55122_55155 = state_55117__$1;
(statearr_55122_55155[(2)] = inst_55079);

(statearr_55122_55155[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (13))){
var inst_55083 = (state_55117[(2)]);
var inst_55084 = fluree.db.util.async.throw_err.call(null,inst_55083);
var state_55117__$1 = state_55117;
var statearr_55123_55156 = state_55117__$1;
(statearr_55123_55156[(2)] = inst_55084);

(statearr_55123_55156[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (6))){
var state_55117__$1 = state_55117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55117__$1,(9),subject);
} else {
if((state_val_55118 === (17))){
var inst_55079 = (state_55117[(7)]);
var inst_55093 = cljs.core.first.call(null,inst_55079);
var state_55117__$1 = state_55117;
var statearr_55124_55157 = state_55117__$1;
(statearr_55124_55157[(2)] = inst_55093);

(statearr_55124_55157[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (3))){
var inst_55115 = (state_55117[(2)]);
var state_55117__$1 = state_55117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55117__$1,inst_55115);
} else {
if((state_val_55118 === (12))){
var inst_55079 = (state_55117[(7)]);
var inst_55087 = (state_55117[(2)]);
var inst_55088 = cljs.core.vector_QMARK_.call(null,inst_55079);
var state_55117__$1 = (function (){var statearr_55125 = state_55117;
(statearr_55125[(8)] = inst_55087);

return statearr_55125;
})();
if(inst_55088){
var statearr_55126_55158 = state_55117__$1;
(statearr_55126_55158[(1)] = (14));

} else {
var statearr_55127_55159 = state_55117__$1;
(statearr_55127_55159[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (2))){
var _ = (function (){var statearr_55128 = state_55117;
(statearr_55128[(4)] = cljs.core.cons.call(null,(5),(state_55117[(4)])));

return statearr_55128;
})();
var inst_55072 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55117__$1 = state_55117;
if(inst_55072){
var statearr_55129_55160 = state_55117__$1;
(statearr_55129_55160[(1)] = (6));

} else {
var statearr_55130_55161 = state_55117__$1;
(statearr_55130_55161[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (19))){
var inst_55096 = (state_55117[(2)]);
var state_55117__$1 = state_55117;
var statearr_55131_55162 = state_55117__$1;
(statearr_55131_55162[(2)] = inst_55096);

(statearr_55131_55162[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (11))){
var state_55117__$1 = state_55117;
var statearr_55133_55163 = state_55117__$1;
(statearr_55133_55163[(2)] = path);

(statearr_55133_55163[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (9))){
var inst_55075 = (state_55117[(2)]);
var inst_55076 = fluree.db.util.async.throw_err.call(null,inst_55075);
var state_55117__$1 = state_55117;
var statearr_55134_55164 = state_55117__$1;
(statearr_55134_55164[(2)] = inst_55076);

(statearr_55134_55164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (5))){
var _ = (function (){var statearr_55135 = state_55117;
(statearr_55135[(4)] = cljs.core.rest.call(null,(state_55117[(4)])));

return statearr_55135;
})();
var state_55117__$1 = state_55117;
var ex55132 = (state_55117__$1[(2)]);
var statearr_55136_55165 = state_55117__$1;
(statearr_55136_55165[(5)] = ex55132);


if((ex55132 instanceof Error)){
var statearr_55137_55166 = state_55117__$1;
(statearr_55137_55166[(1)] = (4));

(statearr_55137_55166[(5)] = null);

} else {
throw ex55132;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (14))){
var inst_55079 = (state_55117[(7)]);
var inst_55090 = cljs.core.count.call(null,inst_55079);
var inst_55091 = cljs.core._EQ_.call(null,(1),inst_55090);
var state_55117__$1 = state_55117;
if(inst_55091){
var statearr_55138_55167 = state_55117__$1;
(statearr_55138_55167[(1)] = (17));

} else {
var statearr_55139_55168 = state_55117__$1;
(statearr_55139_55168[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (16))){
var inst_55079 = (state_55117[(7)]);
var inst_55087 = (state_55117[(8)]);
var inst_55099 = (state_55117[(2)]);
var inst_55100 = fluree.db.dbfunctions.internal.get_all.call(null,inst_55099,inst_55087);
var inst_55101 = cljs.core.count.call(null,inst_55087);
var inst_55102 = ((9) + inst_55101);
var inst_55103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55104 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55106 = [inst_55079,inst_55087];
var inst_55107 = (new cljs.core.PersistentVector(null,2,(5),inst_55105,inst_55106,null));
var inst_55108 = ["get-all",inst_55107,inst_55100];
var inst_55109 = cljs.core.PersistentHashMap.fromArrays(inst_55104,inst_55108);
var inst_55110 = [inst_55109,inst_55102];
var inst_55111 = (new cljs.core.PersistentVector(null,2,(5),inst_55103,inst_55110,null));
var inst_55112 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55111);
var _ = (function (){var statearr_55140 = state_55117;
(statearr_55140[(4)] = cljs.core.rest.call(null,(state_55117[(4)])));

return statearr_55140;
})();
var state_55117__$1 = (function (){var statearr_55141 = state_55117;
(statearr_55141[(9)] = inst_55112);

return statearr_55141;
})();
var statearr_55142_55169 = state_55117__$1;
(statearr_55142_55169[(2)] = inst_55100);

(statearr_55142_55169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (10))){
var state_55117__$1 = state_55117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55117__$1,(13),path);
} else {
if((state_val_55118 === (18))){
var inst_55079 = (state_55117[(7)]);
var state_55117__$1 = state_55117;
var statearr_55143_55170 = state_55117__$1;
(statearr_55143_55170[(2)] = inst_55079);

(statearr_55143_55170[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55118 === (8))){
var inst_55079 = (state_55117[(2)]);
var inst_55080 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55117__$1 = (function (){var statearr_55144 = state_55117;
(statearr_55144[(7)] = inst_55079);

return statearr_55144;
})();
if(inst_55080){
var statearr_55145_55171 = state_55117__$1;
(statearr_55145_55171[(1)] = (10));

} else {
var statearr_55146_55172 = state_55117__$1;
(statearr_55146_55172[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0 = (function (){
var statearr_55147 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55147[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__);

(statearr_55147[(1)] = (1));

return statearr_55147;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1 = (function (state_55117){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55148){var ex__2749__auto__ = e55148;
var statearr_55149_55173 = state_55117;
(statearr_55149_55173[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55117[(4)]))){
var statearr_55150_55174 = state_55117;
(statearr_55150_55174[(1)] = cljs.core.first.call(null,(state_55117[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55175 = state_55117;
state_55117 = G__55175;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = function(state_55117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1.call(this,state_55117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55151 = f__2769__auto__.call(null);
(statearr_55151[(6)] = c__2768__auto__);

return statearr_55151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55214){
var state_val_55215 = (state_55214[(1)]);
if((state_val_55215 === (7))){
var state_55214__$1 = state_55214;
var statearr_55216_55240 = state_55214__$1;
(statearr_55216_55240[(2)] = subject);

(statearr_55216_55240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (1))){
var state_55214__$1 = state_55214;
var statearr_55217_55241 = state_55214__$1;
(statearr_55217_55241[(2)] = null);

(statearr_55217_55241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (4))){
var inst_55176 = (state_55214[(2)]);
var state_55214__$1 = state_55214;
var statearr_55218_55242 = state_55214__$1;
(statearr_55218_55242[(2)] = inst_55176);

(statearr_55218_55242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (13))){
var inst_55193 = (state_55214[(2)]);
var inst_55194 = fluree.db.util.async.throw_err.call(null,inst_55193);
var state_55214__$1 = state_55214;
var statearr_55219_55243 = state_55214__$1;
(statearr_55219_55243[(2)] = inst_55194);

(statearr_55219_55243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (6))){
var state_55214__$1 = state_55214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55214__$1,(9),subject);
} else {
if((state_val_55215 === (3))){
var inst_55212 = (state_55214[(2)]);
var state_55214__$1 = state_55214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55214__$1,inst_55212);
} else {
if((state_val_55215 === (12))){
var inst_55189 = (state_55214[(7)]);
var inst_55197 = (state_55214[(2)]);
var inst_55198 = fluree.db.dbfunctions.internal.get_in.call(null,inst_55189,inst_55197);
var inst_55199 = cljs.core.count.call(null,inst_55197);
var inst_55200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55201 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55203 = [inst_55189,inst_55197];
var inst_55204 = (new cljs.core.PersistentVector(null,2,(5),inst_55202,inst_55203,null));
var inst_55205 = ["get-in",inst_55204,inst_55198];
var inst_55206 = cljs.core.PersistentHashMap.fromArrays(inst_55201,inst_55205);
var inst_55207 = [inst_55206,inst_55199];
var inst_55208 = (new cljs.core.PersistentVector(null,2,(5),inst_55200,inst_55207,null));
var inst_55209 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55208);
var _ = (function (){var statearr_55220 = state_55214;
(statearr_55220[(4)] = cljs.core.rest.call(null,(state_55214[(4)])));

return statearr_55220;
})();
var state_55214__$1 = (function (){var statearr_55221 = state_55214;
(statearr_55221[(8)] = inst_55209);

return statearr_55221;
})();
var statearr_55222_55244 = state_55214__$1;
(statearr_55222_55244[(2)] = inst_55198);

(statearr_55222_55244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (2))){
var _ = (function (){var statearr_55223 = state_55214;
(statearr_55223[(4)] = cljs.core.cons.call(null,(5),(state_55214[(4)])));

return statearr_55223;
})();
var inst_55182 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55214__$1 = state_55214;
if(inst_55182){
var statearr_55224_55245 = state_55214__$1;
(statearr_55224_55245[(1)] = (6));

} else {
var statearr_55225_55246 = state_55214__$1;
(statearr_55225_55246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (11))){
var state_55214__$1 = state_55214;
var statearr_55227_55247 = state_55214__$1;
(statearr_55227_55247[(2)] = path);

(statearr_55227_55247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (9))){
var inst_55185 = (state_55214[(2)]);
var inst_55186 = fluree.db.util.async.throw_err.call(null,inst_55185);
var state_55214__$1 = state_55214;
var statearr_55228_55248 = state_55214__$1;
(statearr_55228_55248[(2)] = inst_55186);

(statearr_55228_55248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (5))){
var _ = (function (){var statearr_55229 = state_55214;
(statearr_55229[(4)] = cljs.core.rest.call(null,(state_55214[(4)])));

return statearr_55229;
})();
var state_55214__$1 = state_55214;
var ex55226 = (state_55214__$1[(2)]);
var statearr_55230_55249 = state_55214__$1;
(statearr_55230_55249[(5)] = ex55226);


if((ex55226 instanceof Error)){
var statearr_55231_55250 = state_55214__$1;
(statearr_55231_55250[(1)] = (4));

(statearr_55231_55250[(5)] = null);

} else {
throw ex55226;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55215 === (10))){
var state_55214__$1 = state_55214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55214__$1,(13),path);
} else {
if((state_val_55215 === (8))){
var inst_55189 = (state_55214[(2)]);
var inst_55190 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55214__$1 = (function (){var statearr_55232 = state_55214;
(statearr_55232[(7)] = inst_55189);

return statearr_55232;
})();
if(inst_55190){
var statearr_55233_55251 = state_55214__$1;
(statearr_55233_55251[(1)] = (10));

} else {
var statearr_55234_55252 = state_55214__$1;
(statearr_55234_55252[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0 = (function (){
var statearr_55235 = [null,null,null,null,null,null,null,null,null];
(statearr_55235[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__);

(statearr_55235[(1)] = (1));

return statearr_55235;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1 = (function (state_55214){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55236){var ex__2749__auto__ = e55236;
var statearr_55237_55253 = state_55214;
(statearr_55237_55253[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55214[(4)]))){
var statearr_55238_55254 = state_55214;
(statearr_55238_55254[(1)] = cljs.core.first.call(null,(state_55214[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55255 = state_55214;
state_55214 = G__55255;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = function(state_55214){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1.call(this,state_55214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55239 = f__2769__auto__.call(null);
(statearr_55239[(6)] = c__2768__auto__);

return statearr_55239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55300){
var state_val_55301 = (state_55300[(1)]);
if((state_val_55301 === (7))){
var state_55300__$1 = state_55300;
var statearr_55302_55331 = state_55300__$1;
(statearr_55302_55331[(2)] = coll);

(statearr_55302_55331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (1))){
var state_55300__$1 = state_55300;
var statearr_55303_55332 = state_55300__$1;
(statearr_55303_55332[(2)] = null);

(statearr_55303_55332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (4))){
var inst_55256 = (state_55300[(2)]);
var state_55300__$1 = state_55300;
var statearr_55304_55333 = state_55300__$1;
(statearr_55304_55333[(2)] = inst_55256);

(statearr_55304_55333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (15))){
var inst_55276 = (state_55300[(7)]);
var inst_55284 = (state_55300[(2)]);
var inst_55285 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_55276,inst_55284);
var inst_55286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55287 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55289 = [inst_55276,inst_55284];
var inst_55290 = (new cljs.core.PersistentVector(null,2,(5),inst_55288,inst_55289,null));
var inst_55291 = ["contains?",inst_55290,inst_55285];
var inst_55292 = cljs.core.PersistentHashMap.fromArrays(inst_55287,inst_55291);
var inst_55293 = [inst_55292,(10)];
var inst_55294 = (new cljs.core.PersistentVector(null,2,(5),inst_55286,inst_55293,null));
var inst_55295 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55294);
var _ = (function (){var statearr_55305 = state_55300;
(statearr_55305[(4)] = cljs.core.rest.call(null,(state_55300[(4)])));

return statearr_55305;
})();
var state_55300__$1 = (function (){var statearr_55306 = state_55300;
(statearr_55306[(8)] = inst_55295);

return statearr_55306;
})();
var statearr_55307_55334 = state_55300__$1;
(statearr_55307_55334[(2)] = inst_55285);

(statearr_55307_55334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (13))){
var state_55300__$1 = state_55300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55300__$1,(16),key);
} else {
if((state_val_55301 === (6))){
var state_55300__$1 = state_55300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55300__$1,(9),coll);
} else {
if((state_val_55301 === (3))){
var inst_55298 = (state_55300[(2)]);
var state_55300__$1 = state_55300;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55300__$1,inst_55298);
} else {
if((state_val_55301 === (12))){
var inst_55276 = (state_55300[(2)]);
var inst_55277 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_55300__$1 = (function (){var statearr_55308 = state_55300;
(statearr_55308[(7)] = inst_55276);

return statearr_55308;
})();
if(inst_55277){
var statearr_55309_55335 = state_55300__$1;
(statearr_55309_55335[(1)] = (13));

} else {
var statearr_55310_55336 = state_55300__$1;
(statearr_55310_55336[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (2))){
var _ = (function (){var statearr_55311 = state_55300;
(statearr_55311[(4)] = cljs.core.cons.call(null,(5),(state_55300[(4)])));

return statearr_55311;
})();
var inst_55262 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55300__$1 = state_55300;
if(inst_55262){
var statearr_55312_55337 = state_55300__$1;
(statearr_55312_55337[(1)] = (6));

} else {
var statearr_55313_55338 = state_55300__$1;
(statearr_55313_55338[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (11))){
var inst_55269 = (state_55300[(9)]);
var inst_55273 = cljs.core.flatten.call(null,inst_55269);
var inst_55274 = cljs.core.set.call(null,inst_55273);
var state_55300__$1 = state_55300;
var statearr_55315_55339 = state_55300__$1;
(statearr_55315_55339[(2)] = inst_55274);

(statearr_55315_55339[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (9))){
var inst_55265 = (state_55300[(2)]);
var inst_55266 = fluree.db.util.async.throw_err.call(null,inst_55265);
var state_55300__$1 = state_55300;
var statearr_55316_55340 = state_55300__$1;
(statearr_55316_55340[(2)] = inst_55266);

(statearr_55316_55340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (5))){
var _ = (function (){var statearr_55317 = state_55300;
(statearr_55317[(4)] = cljs.core.rest.call(null,(state_55300[(4)])));

return statearr_55317;
})();
var state_55300__$1 = state_55300;
var ex55314 = (state_55300__$1[(2)]);
var statearr_55318_55341 = state_55300__$1;
(statearr_55318_55341[(5)] = ex55314);


if((ex55314 instanceof Error)){
var statearr_55319_55342 = state_55300__$1;
(statearr_55319_55342[(1)] = (4));

(statearr_55319_55342[(5)] = null);

} else {
throw ex55314;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (14))){
var state_55300__$1 = state_55300;
var statearr_55320_55343 = state_55300__$1;
(statearr_55320_55343[(2)] = key);

(statearr_55320_55343[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (16))){
var inst_55280 = (state_55300[(2)]);
var inst_55281 = fluree.db.util.async.throw_err.call(null,inst_55280);
var state_55300__$1 = state_55300;
var statearr_55321_55344 = state_55300__$1;
(statearr_55321_55344[(2)] = inst_55281);

(statearr_55321_55344[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (10))){
var inst_55269 = (state_55300[(9)]);
var state_55300__$1 = state_55300;
var statearr_55322_55345 = state_55300__$1;
(statearr_55322_55345[(2)] = inst_55269);

(statearr_55322_55345[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55301 === (8))){
var inst_55269 = (state_55300[(9)]);
var inst_55269__$1 = (state_55300[(2)]);
var inst_55270 = cljs.core.set_QMARK_.call(null,inst_55269__$1);
var state_55300__$1 = (function (){var statearr_55323 = state_55300;
(statearr_55323[(9)] = inst_55269__$1);

return statearr_55323;
})();
if(inst_55270){
var statearr_55324_55346 = state_55300__$1;
(statearr_55324_55346[(1)] = (10));

} else {
var statearr_55325_55347 = state_55300__$1;
(statearr_55325_55347[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_55326 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55326[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__);

(statearr_55326[(1)] = (1));

return statearr_55326;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1 = (function (state_55300){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55327){var ex__2749__auto__ = e55327;
var statearr_55328_55348 = state_55300;
(statearr_55328_55348[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55300[(4)]))){
var statearr_55329_55349 = state_55300;
(statearr_55329_55349[(1)] = cljs.core.first.call(null,(state_55300[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55350 = state_55300;
state_55300 = G__55350;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = function(state_55300){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1.call(this,state_55300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55330 = f__2769__auto__.call(null);
(statearr_55330[(6)] = c__2768__auto__);

return statearr_55330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55422 = arguments.length;
var i__5770__auto___55423 = (0);
while(true){
if((i__5770__auto___55423 < len__5769__auto___55422)){
args__5775__auto__.push((arguments[i__5770__auto___55423]));

var G__55424 = (i__5770__auto___55423 + (1));
i__5770__auto___55423 = G__55424;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55396){
var state_val_55397 = (state_55396[(1)]);
if((state_val_55397 === (7))){
var inst_55362 = (state_55396[(7)]);
var inst_55366 = cljs.core.first.call(null,inst_55362);
var inst_55367 = cljs.core.coll_QMARK_.call(null,inst_55366);
var state_55396__$1 = state_55396;
var statearr_55398_55425 = state_55396__$1;
(statearr_55398_55425[(2)] = inst_55367);

(statearr_55398_55425[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (1))){
var state_55396__$1 = state_55396;
var statearr_55399_55426 = state_55396__$1;
(statearr_55399_55426[(2)] = null);

(statearr_55399_55426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (4))){
var inst_55353 = (state_55396[(2)]);
var state_55396__$1 = state_55396;
var statearr_55400_55427 = state_55396__$1;
(statearr_55400_55427[(2)] = inst_55353);

(statearr_55400_55427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (6))){
var inst_55364 = (state_55396[(8)]);
var inst_55362 = (state_55396[(7)]);
var inst_55361 = (state_55396[(2)]);
var inst_55362__$1 = fluree.db.util.async.throw_err.call(null,inst_55361);
var inst_55363 = cljs.core.count.call(null,inst_55362__$1);
var inst_55364__$1 = cljs.core._EQ_.call(null,(1),inst_55363);
var state_55396__$1 = (function (){var statearr_55401 = state_55396;
(statearr_55401[(8)] = inst_55364__$1);

(statearr_55401[(7)] = inst_55362__$1);

return statearr_55401;
})();
if(inst_55364__$1){
var statearr_55402_55428 = state_55396__$1;
(statearr_55402_55428[(1)] = (7));

} else {
var statearr_55403_55429 = state_55396__$1;
(statearr_55403_55429[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (3))){
var inst_55394 = (state_55396[(2)]);
var state_55396__$1 = state_55396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55396__$1,inst_55394);
} else {
if((state_val_55397 === (12))){
var inst_55375 = (state_55396[(2)]);
var inst_55376 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_55375);
var inst_55377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55378 = [inst_55375];
var inst_55379 = (new cljs.core.PersistentVector(null,1,(5),inst_55377,inst_55378,null));
var inst_55380 = cljs.core.count.call(null,inst_55379);
var inst_55381 = ((9) + inst_55380);
var inst_55382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55383 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55385 = [inst_55375];
var inst_55386 = (new cljs.core.PersistentVector(null,1,(5),inst_55384,inst_55385,null));
var inst_55387 = ["hash-set",inst_55386,inst_55376];
var inst_55388 = cljs.core.PersistentHashMap.fromArrays(inst_55383,inst_55387);
var inst_55389 = [inst_55388,inst_55381];
var inst_55390 = (new cljs.core.PersistentVector(null,2,(5),inst_55382,inst_55389,null));
var inst_55391 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55390);
var _ = (function (){var statearr_55404 = state_55396;
(statearr_55404[(4)] = cljs.core.rest.call(null,(state_55396[(4)])));

return statearr_55404;
})();
var state_55396__$1 = (function (){var statearr_55405 = state_55396;
(statearr_55405[(9)] = inst_55391);

return statearr_55405;
})();
var statearr_55406_55430 = state_55396__$1;
(statearr_55406_55430[(2)] = inst_55376);

(statearr_55406_55430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (2))){
var _ = (function (){var statearr_55407 = state_55396;
(statearr_55407[(4)] = cljs.core.cons.call(null,(5),(state_55396[(4)])));

return statearr_55407;
})();
var inst_55359 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55396__$1 = state_55396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55396__$1,(6),inst_55359);
} else {
if((state_val_55397 === (11))){
var inst_55362 = (state_55396[(7)]);
var state_55396__$1 = state_55396;
var statearr_55409_55431 = state_55396__$1;
(statearr_55409_55431[(2)] = inst_55362);

(statearr_55409_55431[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (9))){
var inst_55370 = (state_55396[(2)]);
var state_55396__$1 = state_55396;
if(cljs.core.truth_(inst_55370)){
var statearr_55410_55432 = state_55396__$1;
(statearr_55410_55432[(1)] = (10));

} else {
var statearr_55411_55433 = state_55396__$1;
(statearr_55411_55433[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (5))){
var _ = (function (){var statearr_55412 = state_55396;
(statearr_55412[(4)] = cljs.core.rest.call(null,(state_55396[(4)])));

return statearr_55412;
})();
var state_55396__$1 = state_55396;
var ex55408 = (state_55396__$1[(2)]);
var statearr_55413_55434 = state_55396__$1;
(statearr_55413_55434[(5)] = ex55408);


if((ex55408 instanceof Error)){
var statearr_55414_55435 = state_55396__$1;
(statearr_55414_55435[(1)] = (4));

(statearr_55414_55435[(5)] = null);

} else {
throw ex55408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (10))){
var inst_55362 = (state_55396[(7)]);
var inst_55372 = cljs.core.first.call(null,inst_55362);
var state_55396__$1 = state_55396;
var statearr_55415_55436 = state_55396__$1;
(statearr_55415_55436[(2)] = inst_55372);

(statearr_55415_55436[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55397 === (8))){
var inst_55364 = (state_55396[(8)]);
var state_55396__$1 = state_55396;
var statearr_55416_55437 = state_55396__$1;
(statearr_55416_55437[(2)] = inst_55364);

(statearr_55416_55437[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55417 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55417[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55417[(1)] = (1));

return statearr_55417;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55396){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55418){var ex__2749__auto__ = e55418;
var statearr_55419_55438 = state_55396;
(statearr_55419_55438[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55396[(4)]))){
var statearr_55420_55439 = state_55396;
(statearr_55420_55439[(1)] = cljs.core.first.call(null,(state_55396[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55440 = state_55396;
state_55396 = G__55440;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55396){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55421 = f__2769__auto__.call(null);
(statearr_55421[(6)] = c__2768__auto__);

return statearr_55421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55351){
var G__55352 = cljs.core.first.call(null,seq55351);
var seq55351__$1 = cljs.core.next.call(null,seq55351);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55352,seq55351__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55490 = arguments.length;
var i__5770__auto___55491 = (0);
while(true){
if((i__5770__auto___55491 < len__5769__auto___55490)){
args__5775__auto__.push((arguments[i__5770__auto___55491]));

var G__55492 = (i__5770__auto___55491 + (1));
i__5770__auto___55491 = G__55492;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55473){
var state_val_55474 = (state_55473[(1)]);
if((state_val_55474 === (1))){
var state_55473__$1 = state_55473;
var statearr_55475_55493 = state_55473__$1;
(statearr_55475_55493[(2)] = null);

(statearr_55475_55493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55474 === (2))){
var _ = (function (){var statearr_55476 = state_55473;
(statearr_55476[(4)] = cljs.core.cons.call(null,(5),(state_55473[(4)])));

return statearr_55476;
})();
var inst_55449 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55473__$1 = state_55473;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55473__$1,(6),inst_55449);
} else {
if((state_val_55474 === (3))){
var inst_55471 = (state_55473[(2)]);
var state_55473__$1 = state_55473;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55473__$1,inst_55471);
} else {
if((state_val_55474 === (4))){
var inst_55443 = (state_55473[(2)]);
var state_55473__$1 = state_55473;
var statearr_55478_55494 = state_55473__$1;
(statearr_55478_55494[(2)] = inst_55443);

(statearr_55478_55494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55474 === (5))){
var _ = (function (){var statearr_55479 = state_55473;
(statearr_55479[(4)] = cljs.core.rest.call(null,(state_55473[(4)])));

return statearr_55479;
})();
var state_55473__$1 = state_55473;
var ex55477 = (state_55473__$1[(2)]);
var statearr_55480_55495 = state_55473__$1;
(statearr_55480_55495[(5)] = ex55477);


if((ex55477 instanceof Error)){
var statearr_55481_55496 = state_55473__$1;
(statearr_55481_55496[(1)] = (4));

(statearr_55481_55496[(5)] = null);

} else {
throw ex55477;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55474 === (6))){
var inst_55451 = (state_55473[(2)]);
var inst_55452 = fluree.db.util.async.throw_err.call(null,inst_55451);
var inst_55453 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_55452);
var inst_55454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55455 = [inst_55452];
var inst_55456 = (new cljs.core.PersistentVector(null,1,(5),inst_55454,inst_55455,null));
var inst_55457 = cljs.core.count.call(null,inst_55456);
var inst_55458 = ((9) + inst_55457);
var inst_55459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55460 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55462 = [inst_55452];
var inst_55463 = (new cljs.core.PersistentVector(null,1,(5),inst_55461,inst_55462,null));
var inst_55464 = ["==",inst_55463,inst_55453];
var inst_55465 = cljs.core.PersistentHashMap.fromArrays(inst_55460,inst_55464);
var inst_55466 = [inst_55465,inst_55458];
var inst_55467 = (new cljs.core.PersistentVector(null,2,(5),inst_55459,inst_55466,null));
var inst_55468 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55467);
var _ = (function (){var statearr_55482 = state_55473;
(statearr_55482[(4)] = cljs.core.rest.call(null,(state_55473[(4)])));

return statearr_55482;
})();
var state_55473__$1 = (function (){var statearr_55483 = state_55473;
(statearr_55483[(7)] = inst_55468);

return statearr_55483;
})();
var statearr_55484_55497 = state_55473__$1;
(statearr_55484_55497[(2)] = inst_55453);

(statearr_55484_55497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55485 = [null,null,null,null,null,null,null,null];
(statearr_55485[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55485[(1)] = (1));

return statearr_55485;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55473){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55473);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55486){var ex__2749__auto__ = e55486;
var statearr_55487_55498 = state_55473;
(statearr_55487_55498[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55473[(4)]))){
var statearr_55488_55499 = state_55473;
(statearr_55488_55499[(1)] = cljs.core.first.call(null,(state_55473[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55500 = state_55473;
state_55473 = G__55500;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55473){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55489 = f__2769__auto__.call(null);
(statearr_55489[(6)] = c__2768__auto__);

return statearr_55489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55441){
var G__55442 = cljs.core.first.call(null,seq55441);
var seq55441__$1 = cljs.core.next.call(null,seq55441);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55442,seq55441__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55550 = arguments.length;
var i__5770__auto___55551 = (0);
while(true){
if((i__5770__auto___55551 < len__5769__auto___55550)){
args__5775__auto__.push((arguments[i__5770__auto___55551]));

var G__55552 = (i__5770__auto___55551 + (1));
i__5770__auto___55551 = G__55552;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55533){
var state_val_55534 = (state_55533[(1)]);
if((state_val_55534 === (1))){
var state_55533__$1 = state_55533;
var statearr_55535_55553 = state_55533__$1;
(statearr_55535_55553[(2)] = null);

(statearr_55535_55553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (2))){
var _ = (function (){var statearr_55536 = state_55533;
(statearr_55536[(4)] = cljs.core.cons.call(null,(5),(state_55533[(4)])));

return statearr_55536;
})();
var inst_55509 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55533__$1 = state_55533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55533__$1,(6),inst_55509);
} else {
if((state_val_55534 === (3))){
var inst_55531 = (state_55533[(2)]);
var state_55533__$1 = state_55533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55533__$1,inst_55531);
} else {
if((state_val_55534 === (4))){
var inst_55503 = (state_55533[(2)]);
var state_55533__$1 = state_55533;
var statearr_55538_55554 = state_55533__$1;
(statearr_55538_55554[(2)] = inst_55503);

(statearr_55538_55554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (5))){
var _ = (function (){var statearr_55539 = state_55533;
(statearr_55539[(4)] = cljs.core.rest.call(null,(state_55533[(4)])));

return statearr_55539;
})();
var state_55533__$1 = state_55533;
var ex55537 = (state_55533__$1[(2)]);
var statearr_55540_55555 = state_55533__$1;
(statearr_55540_55555[(5)] = ex55537);


if((ex55537 instanceof Error)){
var statearr_55541_55556 = state_55533__$1;
(statearr_55541_55556[(1)] = (4));

(statearr_55541_55556[(5)] = null);

} else {
throw ex55537;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (6))){
var inst_55511 = (state_55533[(2)]);
var inst_55512 = fluree.db.util.async.throw_err.call(null,inst_55511);
var inst_55513 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_55512);
var inst_55514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55515 = [inst_55512];
var inst_55516 = (new cljs.core.PersistentVector(null,1,(5),inst_55514,inst_55515,null));
var inst_55517 = cljs.core.count.call(null,inst_55516);
var inst_55518 = ((9) + inst_55517);
var inst_55519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55520 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55522 = [inst_55512];
var inst_55523 = (new cljs.core.PersistentVector(null,1,(5),inst_55521,inst_55522,null));
var inst_55524 = [">",inst_55523,inst_55513];
var inst_55525 = cljs.core.PersistentHashMap.fromArrays(inst_55520,inst_55524);
var inst_55526 = [inst_55525,inst_55518];
var inst_55527 = (new cljs.core.PersistentVector(null,2,(5),inst_55519,inst_55526,null));
var inst_55528 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55527);
var _ = (function (){var statearr_55542 = state_55533;
(statearr_55542[(4)] = cljs.core.rest.call(null,(state_55533[(4)])));

return statearr_55542;
})();
var state_55533__$1 = (function (){var statearr_55543 = state_55533;
(statearr_55543[(7)] = inst_55528);

return statearr_55543;
})();
var statearr_55544_55557 = state_55533__$1;
(statearr_55544_55557[(2)] = inst_55513);

(statearr_55544_55557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55545 = [null,null,null,null,null,null,null,null];
(statearr_55545[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55545[(1)] = (1));

return statearr_55545;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55533){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55546){var ex__2749__auto__ = e55546;
var statearr_55547_55558 = state_55533;
(statearr_55547_55558[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55533[(4)]))){
var statearr_55548_55559 = state_55533;
(statearr_55548_55559[(1)] = cljs.core.first.call(null,(state_55533[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55560 = state_55533;
state_55533 = G__55560;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55533){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55549 = f__2769__auto__.call(null);
(statearr_55549[(6)] = c__2768__auto__);

return statearr_55549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55501){
var G__55502 = cljs.core.first.call(null,seq55501);
var seq55501__$1 = cljs.core.next.call(null,seq55501);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55502,seq55501__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55610 = arguments.length;
var i__5770__auto___55611 = (0);
while(true){
if((i__5770__auto___55611 < len__5769__auto___55610)){
args__5775__auto__.push((arguments[i__5770__auto___55611]));

var G__55612 = (i__5770__auto___55611 + (1));
i__5770__auto___55611 = G__55612;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55593){
var state_val_55594 = (state_55593[(1)]);
if((state_val_55594 === (1))){
var state_55593__$1 = state_55593;
var statearr_55595_55613 = state_55593__$1;
(statearr_55595_55613[(2)] = null);

(statearr_55595_55613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (2))){
var _ = (function (){var statearr_55596 = state_55593;
(statearr_55596[(4)] = cljs.core.cons.call(null,(5),(state_55593[(4)])));

return statearr_55596;
})();
var inst_55569 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55593__$1 = state_55593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55593__$1,(6),inst_55569);
} else {
if((state_val_55594 === (3))){
var inst_55591 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55593__$1,inst_55591);
} else {
if((state_val_55594 === (4))){
var inst_55563 = (state_55593[(2)]);
var state_55593__$1 = state_55593;
var statearr_55598_55614 = state_55593__$1;
(statearr_55598_55614[(2)] = inst_55563);

(statearr_55598_55614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (5))){
var _ = (function (){var statearr_55599 = state_55593;
(statearr_55599[(4)] = cljs.core.rest.call(null,(state_55593[(4)])));

return statearr_55599;
})();
var state_55593__$1 = state_55593;
var ex55597 = (state_55593__$1[(2)]);
var statearr_55600_55615 = state_55593__$1;
(statearr_55600_55615[(5)] = ex55597);


if((ex55597 instanceof Error)){
var statearr_55601_55616 = state_55593__$1;
(statearr_55601_55616[(1)] = (4));

(statearr_55601_55616[(5)] = null);

} else {
throw ex55597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55594 === (6))){
var inst_55571 = (state_55593[(2)]);
var inst_55572 = fluree.db.util.async.throw_err.call(null,inst_55571);
var inst_55573 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_55572);
var inst_55574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55575 = [inst_55572];
var inst_55576 = (new cljs.core.PersistentVector(null,1,(5),inst_55574,inst_55575,null));
var inst_55577 = cljs.core.count.call(null,inst_55576);
var inst_55578 = ((9) + inst_55577);
var inst_55579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55580 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55582 = [inst_55572];
var inst_55583 = (new cljs.core.PersistentVector(null,1,(5),inst_55581,inst_55582,null));
var inst_55584 = ["<",inst_55583,inst_55573];
var inst_55585 = cljs.core.PersistentHashMap.fromArrays(inst_55580,inst_55584);
var inst_55586 = [inst_55585,inst_55578];
var inst_55587 = (new cljs.core.PersistentVector(null,2,(5),inst_55579,inst_55586,null));
var inst_55588 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55587);
var _ = (function (){var statearr_55602 = state_55593;
(statearr_55602[(4)] = cljs.core.rest.call(null,(state_55593[(4)])));

return statearr_55602;
})();
var state_55593__$1 = (function (){var statearr_55603 = state_55593;
(statearr_55603[(7)] = inst_55588);

return statearr_55603;
})();
var statearr_55604_55617 = state_55593__$1;
(statearr_55604_55617[(2)] = inst_55573);

(statearr_55604_55617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55605 = [null,null,null,null,null,null,null,null];
(statearr_55605[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55605[(1)] = (1));

return statearr_55605;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55593){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55606){var ex__2749__auto__ = e55606;
var statearr_55607_55618 = state_55593;
(statearr_55607_55618[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55593[(4)]))){
var statearr_55608_55619 = state_55593;
(statearr_55608_55619[(1)] = cljs.core.first.call(null,(state_55593[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55620 = state_55593;
state_55593 = G__55620;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55593){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55609 = f__2769__auto__.call(null);
(statearr_55609[(6)] = c__2768__auto__);

return statearr_55609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55561){
var G__55562 = cljs.core.first.call(null,seq55561);
var seq55561__$1 = cljs.core.next.call(null,seq55561);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55562,seq55561__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55670 = arguments.length;
var i__5770__auto___55671 = (0);
while(true){
if((i__5770__auto___55671 < len__5769__auto___55670)){
args__5775__auto__.push((arguments[i__5770__auto___55671]));

var G__55672 = (i__5770__auto___55671 + (1));
i__5770__auto___55671 = G__55672;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55653){
var state_val_55654 = (state_55653[(1)]);
if((state_val_55654 === (1))){
var state_55653__$1 = state_55653;
var statearr_55655_55673 = state_55653__$1;
(statearr_55655_55673[(2)] = null);

(statearr_55655_55673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55654 === (2))){
var _ = (function (){var statearr_55656 = state_55653;
(statearr_55656[(4)] = cljs.core.cons.call(null,(5),(state_55653[(4)])));

return statearr_55656;
})();
var inst_55629 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55653__$1 = state_55653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55653__$1,(6),inst_55629);
} else {
if((state_val_55654 === (3))){
var inst_55651 = (state_55653[(2)]);
var state_55653__$1 = state_55653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55653__$1,inst_55651);
} else {
if((state_val_55654 === (4))){
var inst_55623 = (state_55653[(2)]);
var state_55653__$1 = state_55653;
var statearr_55658_55674 = state_55653__$1;
(statearr_55658_55674[(2)] = inst_55623);

(statearr_55658_55674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55654 === (5))){
var _ = (function (){var statearr_55659 = state_55653;
(statearr_55659[(4)] = cljs.core.rest.call(null,(state_55653[(4)])));

return statearr_55659;
})();
var state_55653__$1 = state_55653;
var ex55657 = (state_55653__$1[(2)]);
var statearr_55660_55675 = state_55653__$1;
(statearr_55660_55675[(5)] = ex55657);


if((ex55657 instanceof Error)){
var statearr_55661_55676 = state_55653__$1;
(statearr_55661_55676[(1)] = (4));

(statearr_55661_55676[(5)] = null);

} else {
throw ex55657;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55654 === (6))){
var inst_55631 = (state_55653[(2)]);
var inst_55632 = fluree.db.util.async.throw_err.call(null,inst_55631);
var inst_55633 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_55632);
var inst_55634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55635 = [inst_55632];
var inst_55636 = (new cljs.core.PersistentVector(null,1,(5),inst_55634,inst_55635,null));
var inst_55637 = cljs.core.count.call(null,inst_55636);
var inst_55638 = ((9) + inst_55637);
var inst_55639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55640 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55642 = [inst_55632];
var inst_55643 = (new cljs.core.PersistentVector(null,1,(5),inst_55641,inst_55642,null));
var inst_55644 = ["<=",inst_55643,inst_55633];
var inst_55645 = cljs.core.PersistentHashMap.fromArrays(inst_55640,inst_55644);
var inst_55646 = [inst_55645,inst_55638];
var inst_55647 = (new cljs.core.PersistentVector(null,2,(5),inst_55639,inst_55646,null));
var inst_55648 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55647);
var _ = (function (){var statearr_55662 = state_55653;
(statearr_55662[(4)] = cljs.core.rest.call(null,(state_55653[(4)])));

return statearr_55662;
})();
var state_55653__$1 = (function (){var statearr_55663 = state_55653;
(statearr_55663[(7)] = inst_55648);

return statearr_55663;
})();
var statearr_55664_55677 = state_55653__$1;
(statearr_55664_55677[(2)] = inst_55633);

(statearr_55664_55677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55665 = [null,null,null,null,null,null,null,null];
(statearr_55665[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55665[(1)] = (1));

return statearr_55665;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55653){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55666){var ex__2749__auto__ = e55666;
var statearr_55667_55678 = state_55653;
(statearr_55667_55678[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55653[(4)]))){
var statearr_55668_55679 = state_55653;
(statearr_55668_55679[(1)] = cljs.core.first.call(null,(state_55653[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55680 = state_55653;
state_55653 = G__55680;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55669 = f__2769__auto__.call(null);
(statearr_55669[(6)] = c__2768__auto__);

return statearr_55669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55621){
var G__55622 = cljs.core.first.call(null,seq55621);
var seq55621__$1 = cljs.core.next.call(null,seq55621);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55622,seq55621__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55730 = arguments.length;
var i__5770__auto___55731 = (0);
while(true){
if((i__5770__auto___55731 < len__5769__auto___55730)){
args__5775__auto__.push((arguments[i__5770__auto___55731]));

var G__55732 = (i__5770__auto___55731 + (1));
i__5770__auto___55731 = G__55732;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55713){
var state_val_55714 = (state_55713[(1)]);
if((state_val_55714 === (1))){
var state_55713__$1 = state_55713;
var statearr_55715_55733 = state_55713__$1;
(statearr_55715_55733[(2)] = null);

(statearr_55715_55733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55714 === (2))){
var _ = (function (){var statearr_55716 = state_55713;
(statearr_55716[(4)] = cljs.core.cons.call(null,(5),(state_55713[(4)])));

return statearr_55716;
})();
var inst_55689 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55713__$1 = state_55713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55713__$1,(6),inst_55689);
} else {
if((state_val_55714 === (3))){
var inst_55711 = (state_55713[(2)]);
var state_55713__$1 = state_55713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55713__$1,inst_55711);
} else {
if((state_val_55714 === (4))){
var inst_55683 = (state_55713[(2)]);
var state_55713__$1 = state_55713;
var statearr_55718_55734 = state_55713__$1;
(statearr_55718_55734[(2)] = inst_55683);

(statearr_55718_55734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55714 === (5))){
var _ = (function (){var statearr_55719 = state_55713;
(statearr_55719[(4)] = cljs.core.rest.call(null,(state_55713[(4)])));

return statearr_55719;
})();
var state_55713__$1 = state_55713;
var ex55717 = (state_55713__$1[(2)]);
var statearr_55720_55735 = state_55713__$1;
(statearr_55720_55735[(5)] = ex55717);


if((ex55717 instanceof Error)){
var statearr_55721_55736 = state_55713__$1;
(statearr_55721_55736[(1)] = (4));

(statearr_55721_55736[(5)] = null);

} else {
throw ex55717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55714 === (6))){
var inst_55691 = (state_55713[(2)]);
var inst_55692 = fluree.db.util.async.throw_err.call(null,inst_55691);
var inst_55693 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_55692);
var inst_55694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55695 = [inst_55692];
var inst_55696 = (new cljs.core.PersistentVector(null,1,(5),inst_55694,inst_55695,null));
var inst_55697 = cljs.core.count.call(null,inst_55696);
var inst_55698 = ((9) + inst_55697);
var inst_55699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55700 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55702 = [inst_55692];
var inst_55703 = (new cljs.core.PersistentVector(null,1,(5),inst_55701,inst_55702,null));
var inst_55704 = [">=",inst_55703,inst_55693];
var inst_55705 = cljs.core.PersistentHashMap.fromArrays(inst_55700,inst_55704);
var inst_55706 = [inst_55705,inst_55698];
var inst_55707 = (new cljs.core.PersistentVector(null,2,(5),inst_55699,inst_55706,null));
var inst_55708 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55707);
var _ = (function (){var statearr_55722 = state_55713;
(statearr_55722[(4)] = cljs.core.rest.call(null,(state_55713[(4)])));

return statearr_55722;
})();
var state_55713__$1 = (function (){var statearr_55723 = state_55713;
(statearr_55723[(7)] = inst_55708);

return statearr_55723;
})();
var statearr_55724_55737 = state_55713__$1;
(statearr_55724_55737[(2)] = inst_55693);

(statearr_55724_55737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55725 = [null,null,null,null,null,null,null,null];
(statearr_55725[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55725[(1)] = (1));

return statearr_55725;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55713){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55726){var ex__2749__auto__ = e55726;
var statearr_55727_55738 = state_55713;
(statearr_55727_55738[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55713[(4)]))){
var statearr_55728_55739 = state_55713;
(statearr_55728_55739[(1)] = cljs.core.first.call(null,(state_55713[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55740 = state_55713;
state_55713 = G__55740;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55713){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55729 = f__2769__auto__.call(null);
(statearr_55729[(6)] = c__2768__auto__);

return statearr_55729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55681){
var G__55682 = cljs.core.first.call(null,seq55681);
var seq55681__$1 = cljs.core.next.call(null,seq55681);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55682,seq55681__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55790 = arguments.length;
var i__5770__auto___55791 = (0);
while(true){
if((i__5770__auto___55791 < len__5769__auto___55790)){
args__5775__auto__.push((arguments[i__5770__auto___55791]));

var G__55792 = (i__5770__auto___55791 + (1));
i__5770__auto___55791 = G__55792;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55773){
var state_val_55774 = (state_55773[(1)]);
if((state_val_55774 === (1))){
var state_55773__$1 = state_55773;
var statearr_55775_55793 = state_55773__$1;
(statearr_55775_55793[(2)] = null);

(statearr_55775_55793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55774 === (2))){
var _ = (function (){var statearr_55776 = state_55773;
(statearr_55776[(4)] = cljs.core.cons.call(null,(5),(state_55773[(4)])));

return statearr_55776;
})();
var inst_55749 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55773__$1 = state_55773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55773__$1,(6),inst_55749);
} else {
if((state_val_55774 === (3))){
var inst_55771 = (state_55773[(2)]);
var state_55773__$1 = state_55773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55773__$1,inst_55771);
} else {
if((state_val_55774 === (4))){
var inst_55743 = (state_55773[(2)]);
var state_55773__$1 = state_55773;
var statearr_55778_55794 = state_55773__$1;
(statearr_55778_55794[(2)] = inst_55743);

(statearr_55778_55794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55774 === (5))){
var _ = (function (){var statearr_55779 = state_55773;
(statearr_55779[(4)] = cljs.core.rest.call(null,(state_55773[(4)])));

return statearr_55779;
})();
var state_55773__$1 = state_55773;
var ex55777 = (state_55773__$1[(2)]);
var statearr_55780_55795 = state_55773__$1;
(statearr_55780_55795[(5)] = ex55777);


if((ex55777 instanceof Error)){
var statearr_55781_55796 = state_55773__$1;
(statearr_55781_55796[(1)] = (4));

(statearr_55781_55796[(5)] = null);

} else {
throw ex55777;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55774 === (6))){
var inst_55751 = (state_55773[(2)]);
var inst_55752 = fluree.db.util.async.throw_err.call(null,inst_55751);
var inst_55753 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_55752);
var inst_55754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55755 = [inst_55752];
var inst_55756 = (new cljs.core.PersistentVector(null,1,(5),inst_55754,inst_55755,null));
var inst_55757 = cljs.core.count.call(null,inst_55756);
var inst_55758 = ((9) + inst_55757);
var inst_55759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55760 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55762 = [inst_55752];
var inst_55763 = (new cljs.core.PersistentVector(null,1,(5),inst_55761,inst_55762,null));
var inst_55764 = ["not=",inst_55763,inst_55753];
var inst_55765 = cljs.core.PersistentHashMap.fromArrays(inst_55760,inst_55764);
var inst_55766 = [inst_55765,inst_55758];
var inst_55767 = (new cljs.core.PersistentVector(null,2,(5),inst_55759,inst_55766,null));
var inst_55768 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55767);
var _ = (function (){var statearr_55782 = state_55773;
(statearr_55782[(4)] = cljs.core.rest.call(null,(state_55773[(4)])));

return statearr_55782;
})();
var state_55773__$1 = (function (){var statearr_55783 = state_55773;
(statearr_55783[(7)] = inst_55768);

return statearr_55783;
})();
var statearr_55784_55797 = state_55773__$1;
(statearr_55784_55797[(2)] = inst_55753);

(statearr_55784_55797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55785 = [null,null,null,null,null,null,null,null];
(statearr_55785[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55785[(1)] = (1));

return statearr_55785;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55773){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55786){var ex__2749__auto__ = e55786;
var statearr_55787_55798 = state_55773;
(statearr_55787_55798[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55773[(4)]))){
var statearr_55788_55799 = state_55773;
(statearr_55788_55799[(1)] = cljs.core.first.call(null,(state_55773[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55800 = state_55773;
state_55773 = G__55800;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55773){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55789 = f__2769__auto__.call(null);
(statearr_55789[(6)] = c__2768__auto__);

return statearr_55789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55741){
var G__55742 = cljs.core.first.call(null,seq55741);
var seq55741__$1 = cljs.core.next.call(null,seq55741);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55742,seq55741__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55850 = arguments.length;
var i__5770__auto___55851 = (0);
while(true){
if((i__5770__auto___55851 < len__5769__auto___55850)){
args__5775__auto__.push((arguments[i__5770__auto___55851]));

var G__55852 = (i__5770__auto___55851 + (1));
i__5770__auto___55851 = G__55852;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55833){
var state_val_55834 = (state_55833[(1)]);
if((state_val_55834 === (1))){
var state_55833__$1 = state_55833;
var statearr_55835_55853 = state_55833__$1;
(statearr_55835_55853[(2)] = null);

(statearr_55835_55853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55834 === (2))){
var _ = (function (){var statearr_55836 = state_55833;
(statearr_55836[(4)] = cljs.core.cons.call(null,(5),(state_55833[(4)])));

return statearr_55836;
})();
var inst_55809 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55833__$1 = state_55833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55833__$1,(6),inst_55809);
} else {
if((state_val_55834 === (3))){
var inst_55831 = (state_55833[(2)]);
var state_55833__$1 = state_55833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55833__$1,inst_55831);
} else {
if((state_val_55834 === (4))){
var inst_55803 = (state_55833[(2)]);
var state_55833__$1 = state_55833;
var statearr_55838_55854 = state_55833__$1;
(statearr_55838_55854[(2)] = inst_55803);

(statearr_55838_55854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55834 === (5))){
var _ = (function (){var statearr_55839 = state_55833;
(statearr_55839[(4)] = cljs.core.rest.call(null,(state_55833[(4)])));

return statearr_55839;
})();
var state_55833__$1 = state_55833;
var ex55837 = (state_55833__$1[(2)]);
var statearr_55840_55855 = state_55833__$1;
(statearr_55840_55855[(5)] = ex55837);


if((ex55837 instanceof Error)){
var statearr_55841_55856 = state_55833__$1;
(statearr_55841_55856[(1)] = (4));

(statearr_55841_55856[(5)] = null);

} else {
throw ex55837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55834 === (6))){
var inst_55811 = (state_55833[(2)]);
var inst_55812 = fluree.db.util.async.throw_err.call(null,inst_55811);
var inst_55813 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_55812);
var inst_55814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55815 = [inst_55812];
var inst_55816 = (new cljs.core.PersistentVector(null,1,(5),inst_55814,inst_55815,null));
var inst_55817 = cljs.core.count.call(null,inst_55816);
var inst_55818 = ((9) + inst_55817);
var inst_55819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55820 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55822 = [inst_55812];
var inst_55823 = (new cljs.core.PersistentVector(null,1,(5),inst_55821,inst_55822,null));
var inst_55824 = ["max",inst_55823,inst_55813];
var inst_55825 = cljs.core.PersistentHashMap.fromArrays(inst_55820,inst_55824);
var inst_55826 = [inst_55825,inst_55818];
var inst_55827 = (new cljs.core.PersistentVector(null,2,(5),inst_55819,inst_55826,null));
var inst_55828 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55827);
var _ = (function (){var statearr_55842 = state_55833;
(statearr_55842[(4)] = cljs.core.rest.call(null,(state_55833[(4)])));

return statearr_55842;
})();
var state_55833__$1 = (function (){var statearr_55843 = state_55833;
(statearr_55843[(7)] = inst_55828);

return statearr_55843;
})();
var statearr_55844_55857 = state_55833__$1;
(statearr_55844_55857[(2)] = inst_55813);

(statearr_55844_55857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55845 = [null,null,null,null,null,null,null,null];
(statearr_55845[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55845[(1)] = (1));

return statearr_55845;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55833){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55846){var ex__2749__auto__ = e55846;
var statearr_55847_55858 = state_55833;
(statearr_55847_55858[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55833[(4)]))){
var statearr_55848_55859 = state_55833;
(statearr_55848_55859[(1)] = cljs.core.first.call(null,(state_55833[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55860 = state_55833;
state_55833 = G__55860;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55833){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55849 = f__2769__auto__.call(null);
(statearr_55849[(6)] = c__2768__auto__);

return statearr_55849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55801){
var G__55802 = cljs.core.first.call(null,seq55801);
var seq55801__$1 = cljs.core.next.call(null,seq55801);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55802,seq55801__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55910 = arguments.length;
var i__5770__auto___55911 = (0);
while(true){
if((i__5770__auto___55911 < len__5769__auto___55910)){
args__5775__auto__.push((arguments[i__5770__auto___55911]));

var G__55912 = (i__5770__auto___55911 + (1));
i__5770__auto___55911 = G__55912;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55893){
var state_val_55894 = (state_55893[(1)]);
if((state_val_55894 === (1))){
var state_55893__$1 = state_55893;
var statearr_55895_55913 = state_55893__$1;
(statearr_55895_55913[(2)] = null);

(statearr_55895_55913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55894 === (2))){
var _ = (function (){var statearr_55896 = state_55893;
(statearr_55896[(4)] = cljs.core.cons.call(null,(5),(state_55893[(4)])));

return statearr_55896;
})();
var inst_55869 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55893__$1 = state_55893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55893__$1,(6),inst_55869);
} else {
if((state_val_55894 === (3))){
var inst_55891 = (state_55893[(2)]);
var state_55893__$1 = state_55893;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55893__$1,inst_55891);
} else {
if((state_val_55894 === (4))){
var inst_55863 = (state_55893[(2)]);
var state_55893__$1 = state_55893;
var statearr_55898_55914 = state_55893__$1;
(statearr_55898_55914[(2)] = inst_55863);

(statearr_55898_55914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55894 === (5))){
var _ = (function (){var statearr_55899 = state_55893;
(statearr_55899[(4)] = cljs.core.rest.call(null,(state_55893[(4)])));

return statearr_55899;
})();
var state_55893__$1 = state_55893;
var ex55897 = (state_55893__$1[(2)]);
var statearr_55900_55915 = state_55893__$1;
(statearr_55900_55915[(5)] = ex55897);


if((ex55897 instanceof Error)){
var statearr_55901_55916 = state_55893__$1;
(statearr_55901_55916[(1)] = (4));

(statearr_55901_55916[(5)] = null);

} else {
throw ex55897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55894 === (6))){
var inst_55871 = (state_55893[(2)]);
var inst_55872 = fluree.db.util.async.throw_err.call(null,inst_55871);
var inst_55873 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_55872);
var inst_55874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55875 = [inst_55872];
var inst_55876 = (new cljs.core.PersistentVector(null,1,(5),inst_55874,inst_55875,null));
var inst_55877 = cljs.core.count.call(null,inst_55876);
var inst_55878 = ((9) + inst_55877);
var inst_55879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55880 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55882 = [inst_55872];
var inst_55883 = (new cljs.core.PersistentVector(null,1,(5),inst_55881,inst_55882,null));
var inst_55884 = ["min",inst_55883,inst_55873];
var inst_55885 = cljs.core.PersistentHashMap.fromArrays(inst_55880,inst_55884);
var inst_55886 = [inst_55885,inst_55878];
var inst_55887 = (new cljs.core.PersistentVector(null,2,(5),inst_55879,inst_55886,null));
var inst_55888 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55887);
var _ = (function (){var statearr_55902 = state_55893;
(statearr_55902[(4)] = cljs.core.rest.call(null,(state_55893[(4)])));

return statearr_55902;
})();
var state_55893__$1 = (function (){var statearr_55903 = state_55893;
(statearr_55903[(7)] = inst_55888);

return statearr_55903;
})();
var statearr_55904_55917 = state_55893__$1;
(statearr_55904_55917[(2)] = inst_55873);

(statearr_55904_55917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55905 = [null,null,null,null,null,null,null,null];
(statearr_55905[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55905[(1)] = (1));

return statearr_55905;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55893){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55906){var ex__2749__auto__ = e55906;
var statearr_55907_55918 = state_55893;
(statearr_55907_55918[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55893[(4)]))){
var statearr_55908_55919 = state_55893;
(statearr_55908_55919[(1)] = cljs.core.first.call(null,(state_55893[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55920 = state_55893;
state_55893 = G__55920;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55893){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55909 = f__2769__auto__.call(null);
(statearr_55909[(6)] = c__2768__auto__);

return statearr_55909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55861){
var G__55862 = cljs.core.first.call(null,seq55861);
var seq55861__$1 = cljs.core.next.call(null,seq55861);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55862,seq55861__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55922 = arguments.length;
switch (G__55922) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55967){
var state_val_55968 = (state_55967[(1)]);
if((state_val_55968 === (7))){
var state_55967__$1 = state_55967;
var statearr_55969_56106 = state_55967__$1;
(statearr_55969_56106[(2)] = query_map);

(statearr_55969_56106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (1))){
var state_55967__$1 = state_55967;
var statearr_55970_56107 = state_55967__$1;
(statearr_55970_56107[(2)] = null);

(statearr_55970_56107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (4))){
var inst_55923 = (state_55967[(2)]);
var state_55967__$1 = state_55967;
var statearr_55971_56108 = state_55967__$1;
(statearr_55971_56108[(2)] = inst_55923);

(statearr_55971_56108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (13))){
var inst_55945 = (state_55967[(7)]);
var inst_55949 = (state_55967[(2)]);
var inst_55950 = fluree.db.util.async.throw_err.call(null,inst_55949);
var inst_55951 = cljs.core.nth.call(null,inst_55950,(0),null);
var inst_55952 = cljs.core.nth.call(null,inst_55950,(1),null);
var inst_55953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55954 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55956 = [inst_55945];
var inst_55957 = (new cljs.core.PersistentVector(null,1,(5),inst_55955,inst_55956,null));
var inst_55958 = ["query",inst_55957,inst_55951];
var inst_55959 = cljs.core.PersistentHashMap.fromArrays(inst_55954,inst_55958);
var inst_55960 = [inst_55959,inst_55952];
var inst_55961 = (new cljs.core.PersistentVector(null,2,(5),inst_55953,inst_55960,null));
var inst_55962 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55961);
var _ = (function (){var statearr_55972 = state_55967;
(statearr_55972[(4)] = cljs.core.rest.call(null,(state_55967[(4)])));

return statearr_55972;
})();
var state_55967__$1 = (function (){var statearr_55973 = state_55967;
(statearr_55973[(8)] = inst_55962);

return statearr_55973;
})();
var statearr_55974_56109 = state_55967__$1;
(statearr_55974_56109[(2)] = inst_55951);

(statearr_55974_56109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (6))){
var state_55967__$1 = state_55967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55967__$1,(9),query_map);
} else {
if((state_val_55968 === (3))){
var inst_55965 = (state_55967[(2)]);
var state_55967__$1 = state_55967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55967__$1,inst_55965);
} else {
if((state_val_55968 === (12))){
var inst_55945 = (state_55967[(7)]);
var inst_55945__$1 = (state_55967[(2)]);
var inst_55946 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55947 = fluree.db.dbfunctions.internal.query.call(null,inst_55946,inst_55945__$1);
var state_55967__$1 = (function (){var statearr_55975 = state_55967;
(statearr_55975[(7)] = inst_55945__$1);

return statearr_55975;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55967__$1,(13),inst_55947);
} else {
if((state_val_55968 === (2))){
var _ = (function (){var statearr_55976 = state_55967;
(statearr_55976[(4)] = cljs.core.cons.call(null,(5),(state_55967[(4)])));

return statearr_55976;
})();
var inst_55932 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_55967__$1 = state_55967;
if(inst_55932){
var statearr_55977_56110 = state_55967__$1;
(statearr_55977_56110[(1)] = (6));

} else {
var statearr_55978_56111 = state_55967__$1;
(statearr_55978_56111[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (11))){
var inst_55939 = (state_55967[(9)]);
var state_55967__$1 = state_55967;
var statearr_55980_56112 = state_55967__$1;
(statearr_55980_56112[(2)] = inst_55939);

(statearr_55980_56112[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (9))){
var inst_55935 = (state_55967[(2)]);
var inst_55936 = fluree.db.util.async.throw_err.call(null,inst_55935);
var state_55967__$1 = state_55967;
var statearr_55981_56113 = state_55967__$1;
(statearr_55981_56113[(2)] = inst_55936);

(statearr_55981_56113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (5))){
var _ = (function (){var statearr_55982 = state_55967;
(statearr_55982[(4)] = cljs.core.rest.call(null,(state_55967[(4)])));

return statearr_55982;
})();
var state_55967__$1 = state_55967;
var ex55979 = (state_55967__$1[(2)]);
var statearr_55983_56114 = state_55967__$1;
(statearr_55983_56114[(5)] = ex55979);


if((ex55979 instanceof Error)){
var statearr_55984_56115 = state_55967__$1;
(statearr_55984_56115[(1)] = (4));

(statearr_55984_56115[(5)] = null);

} else {
throw ex55979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (10))){
var inst_55939 = (state_55967[(9)]);
var inst_55942 = fluree.db.util.json.parse.call(null,inst_55939);
var state_55967__$1 = state_55967;
var statearr_55985_56116 = state_55967__$1;
(statearr_55985_56116[(2)] = inst_55942);

(statearr_55985_56116[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (8))){
var inst_55939 = (state_55967[(9)]);
var inst_55939__$1 = (state_55967[(2)]);
var inst_55940 = typeof inst_55939__$1 === 'string';
var state_55967__$1 = (function (){var statearr_55986 = state_55967;
(statearr_55986[(9)] = inst_55939__$1);

return statearr_55986;
})();
if(cljs.core.truth_(inst_55940)){
var statearr_55987_56117 = state_55967__$1;
(statearr_55987_56117[(1)] = (10));

} else {
var statearr_55988_56118 = state_55967__$1;
(statearr_55988_56118[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55989 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55989[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55989[(1)] = (1));

return statearr_55989;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55967){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55990){var ex__2749__auto__ = e55990;
var statearr_55991_56119 = state_55967;
(statearr_55991_56119[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55967[(4)]))){
var statearr_55992_56120 = state_55967;
(statearr_55992_56120[(1)] = cljs.core.first.call(null,(state_55967[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56121 = state_55967;
state_55967 = G__56121;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55967){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55993 = f__2769__auto__.call(null);
(statearr_55993[(6)] = c__2768__auto__);

return statearr_55993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56064){
var state_val_56065 = (state_56064[(1)]);
if((state_val_56065 === (7))){
var state_56064__$1 = state_56064;
var statearr_56066_56122 = state_56064__$1;
(statearr_56066_56122[(2)] = select);

(statearr_56066_56122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (20))){
var inst_56034 = (state_56064[(2)]);
var inst_56035 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_56064__$1 = (function (){var statearr_56067 = state_56064;
(statearr_56067[(7)] = inst_56034);

return statearr_56067;
})();
if(inst_56035){
var statearr_56068_56123 = state_56064__$1;
(statearr_56068_56123[(1)] = (22));

} else {
var statearr_56069_56124 = state_56064__$1;
(statearr_56069_56124[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (1))){
var state_56064__$1 = state_56064;
var statearr_56070_56125 = state_56064__$1;
(statearr_56070_56125[(2)] = null);

(statearr_56070_56125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (24))){
var inst_56018 = (state_56064[(8)]);
var inst_56026 = (state_56064[(9)]);
var inst_56010 = (state_56064[(10)]);
var inst_56034 = (state_56064[(7)]);
var inst_56042 = (state_56064[(2)]);
var inst_56043 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56044 = fluree.db.dbfunctions.internal.query.call(null,inst_56043,inst_56010,inst_56018,inst_56026,inst_56034,inst_56042);
var state_56064__$1 = state_56064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56064__$1,(26),inst_56044);
} else {
if((state_val_56065 === (4))){
var inst_55994 = (state_56064[(2)]);
var state_56064__$1 = state_56064;
var statearr_56071_56126 = state_56064__$1;
(statearr_56071_56126[(2)] = inst_55994);

(statearr_56071_56126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (15))){
var state_56064__$1 = state_56064;
var statearr_56072_56127 = state_56064__$1;
(statearr_56072_56127[(2)] = where);

(statearr_56072_56127[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (21))){
var inst_56030 = (state_56064[(2)]);
var inst_56031 = fluree.db.util.async.throw_err.call(null,inst_56030);
var state_56064__$1 = state_56064;
var statearr_56073_56128 = state_56064__$1;
(statearr_56073_56128[(2)] = inst_56031);

(statearr_56073_56128[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (13))){
var inst_56014 = (state_56064[(2)]);
var inst_56015 = fluree.db.util.async.throw_err.call(null,inst_56014);
var state_56064__$1 = state_56064;
var statearr_56074_56129 = state_56064__$1;
(statearr_56074_56129[(2)] = inst_56015);

(statearr_56074_56129[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (22))){
var state_56064__$1 = state_56064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56064__$1,(25),limit);
} else {
if((state_val_56065 === (6))){
var state_56064__$1 = state_56064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56064__$1,(9),select);
} else {
if((state_val_56065 === (25))){
var inst_56038 = (state_56064[(2)]);
var inst_56039 = fluree.db.util.async.throw_err.call(null,inst_56038);
var state_56064__$1 = state_56064;
var statearr_56075_56130 = state_56064__$1;
(statearr_56075_56130[(2)] = inst_56039);

(statearr_56075_56130[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (17))){
var inst_56022 = (state_56064[(2)]);
var inst_56023 = fluree.db.util.async.throw_err.call(null,inst_56022);
var state_56064__$1 = state_56064;
var statearr_56076_56131 = state_56064__$1;
(statearr_56076_56131[(2)] = inst_56023);

(statearr_56076_56131[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (3))){
var inst_56062 = (state_56064[(2)]);
var state_56064__$1 = state_56064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56064__$1,inst_56062);
} else {
if((state_val_56065 === (12))){
var inst_56018 = (state_56064[(2)]);
var inst_56019 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_56064__$1 = (function (){var statearr_56077 = state_56064;
(statearr_56077[(8)] = inst_56018);

return statearr_56077;
})();
if(inst_56019){
var statearr_56078_56132 = state_56064__$1;
(statearr_56078_56132[(1)] = (14));

} else {
var statearr_56079_56133 = state_56064__$1;
(statearr_56079_56133[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (2))){
var _ = (function (){var statearr_56080 = state_56064;
(statearr_56080[(4)] = cljs.core.cons.call(null,(5),(state_56064[(4)])));

return statearr_56080;
})();
var inst_56003 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_56064__$1 = state_56064;
if(inst_56003){
var statearr_56081_56134 = state_56064__$1;
(statearr_56081_56134[(1)] = (6));

} else {
var statearr_56082_56135 = state_56064__$1;
(statearr_56082_56135[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (23))){
var state_56064__$1 = state_56064;
var statearr_56083_56136 = state_56064__$1;
(statearr_56083_56136[(2)] = limit);

(statearr_56083_56136[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (19))){
var state_56064__$1 = state_56064;
var statearr_56084_56137 = state_56064__$1;
(statearr_56084_56137[(2)] = block);

(statearr_56084_56137[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (11))){
var state_56064__$1 = state_56064;
var statearr_56086_56138 = state_56064__$1;
(statearr_56086_56138[(2)] = from);

(statearr_56086_56138[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (9))){
var inst_56006 = (state_56064[(2)]);
var inst_56007 = fluree.db.util.async.throw_err.call(null,inst_56006);
var state_56064__$1 = state_56064;
var statearr_56087_56139 = state_56064__$1;
(statearr_56087_56139[(2)] = inst_56007);

(statearr_56087_56139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (5))){
var _ = (function (){var statearr_56088 = state_56064;
(statearr_56088[(4)] = cljs.core.rest.call(null,(state_56064[(4)])));

return statearr_56088;
})();
var state_56064__$1 = state_56064;
var ex56085 = (state_56064__$1[(2)]);
var statearr_56089_56140 = state_56064__$1;
(statearr_56089_56140[(5)] = ex56085);


if((ex56085 instanceof Error)){
var statearr_56090_56141 = state_56064__$1;
(statearr_56090_56141[(1)] = (4));

(statearr_56090_56141[(5)] = null);

} else {
throw ex56085;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (14))){
var state_56064__$1 = state_56064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56064__$1,(17),where);
} else {
if((state_val_56065 === (26))){
var inst_56018 = (state_56064[(8)]);
var inst_56026 = (state_56064[(9)]);
var inst_56010 = (state_56064[(10)]);
var inst_56034 = (state_56064[(7)]);
var inst_56046 = (state_56064[(2)]);
var inst_56047 = fluree.db.util.async.throw_err.call(null,inst_56046);
var inst_56048 = cljs.core.nth.call(null,inst_56047,(0),null);
var inst_56049 = cljs.core.nth.call(null,inst_56047,(1),null);
var inst_56050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56051 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56053 = [inst_56010,inst_56018,inst_56026,inst_56034];
var inst_56054 = (new cljs.core.PersistentVector(null,4,(5),inst_56052,inst_56053,null));
var inst_56055 = ["query",inst_56054,inst_56048];
var inst_56056 = cljs.core.PersistentHashMap.fromArrays(inst_56051,inst_56055);
var inst_56057 = [inst_56056,inst_56049];
var inst_56058 = (new cljs.core.PersistentVector(null,2,(5),inst_56050,inst_56057,null));
var inst_56059 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56058);
var _ = (function (){var statearr_56091 = state_56064;
(statearr_56091[(4)] = cljs.core.rest.call(null,(state_56064[(4)])));

return statearr_56091;
})();
var state_56064__$1 = (function (){var statearr_56092 = state_56064;
(statearr_56092[(11)] = inst_56059);

return statearr_56092;
})();
var statearr_56093_56142 = state_56064__$1;
(statearr_56093_56142[(2)] = inst_56048);

(statearr_56093_56142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (16))){
var inst_56026 = (state_56064[(2)]);
var inst_56027 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_56064__$1 = (function (){var statearr_56094 = state_56064;
(statearr_56094[(9)] = inst_56026);

return statearr_56094;
})();
if(inst_56027){
var statearr_56095_56143 = state_56064__$1;
(statearr_56095_56143[(1)] = (18));

} else {
var statearr_56096_56144 = state_56064__$1;
(statearr_56096_56144[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56065 === (10))){
var state_56064__$1 = state_56064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56064__$1,(13),from);
} else {
if((state_val_56065 === (18))){
var state_56064__$1 = state_56064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56064__$1,(21),block);
} else {
if((state_val_56065 === (8))){
var inst_56010 = (state_56064[(2)]);
var inst_56011 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_56064__$1 = (function (){var statearr_56097 = state_56064;
(statearr_56097[(10)] = inst_56010);

return statearr_56097;
})();
if(inst_56011){
var statearr_56098_56145 = state_56064__$1;
(statearr_56098_56145[(1)] = (10));

} else {
var statearr_56099_56146 = state_56064__$1;
(statearr_56099_56146[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56100 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56100[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56100[(1)] = (1));

return statearr_56100;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56064){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56101){var ex__2749__auto__ = e56101;
var statearr_56102_56147 = state_56064;
(statearr_56102_56147[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56064[(4)]))){
var statearr_56103_56148 = state_56064;
(statearr_56103_56148[(1)] = cljs.core.first.call(null,(state_56064[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56149 = state_56064;
state_56064 = G__56149;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56064){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56104 = f__2769__auto__.call(null);
(statearr_56104[(6)] = c__2768__auto__);

return statearr_56104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56205){
var state_val_56206 = (state_56205[(1)]);
if((state_val_56206 === (7))){
var state_56205__$1 = state_56205;
var statearr_56207_56238 = state_56205__$1;
(statearr_56207_56238[(2)] = startSubject);

(statearr_56207_56238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (1))){
var state_56205__$1 = state_56205;
var statearr_56208_56239 = state_56205__$1;
(statearr_56208_56239[(2)] = null);

(statearr_56208_56239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (4))){
var inst_56150 = (state_56205[(2)]);
var state_56205__$1 = state_56205;
var statearr_56209_56240 = state_56205__$1;
(statearr_56209_56240[(2)] = inst_56150);

(statearr_56209_56240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (15))){
var inst_56182 = (state_56205[(2)]);
var inst_56183 = fluree.db.util.async.throw_err.call(null,inst_56182);
var inst_56184 = cljs.core.nth.call(null,inst_56183,(0),null);
var inst_56185 = cljs.core.nth.call(null,inst_56183,(1),null);
var inst_56186 = cljs.core.empty_QMARK_.call(null,inst_56184);
var state_56205__$1 = (function (){var statearr_56210 = state_56205;
(statearr_56210[(7)] = inst_56185);

return statearr_56210;
})();
if(inst_56186){
var statearr_56211_56241 = state_56205__$1;
(statearr_56211_56241[(1)] = (16));

} else {
var statearr_56212_56242 = state_56205__$1;
(statearr_56212_56242[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (13))){
var inst_56170 = (state_56205[(8)]);
var inst_56178 = (state_56205[(9)]);
var inst_56166 = (state_56205[(10)]);
var inst_56178__$1 = (state_56205[(2)]);
var inst_56179 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56180 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_56179,inst_56166,inst_56170,inst_56178__$1);
var state_56205__$1 = (function (){var statearr_56213 = state_56205;
(statearr_56213[(9)] = inst_56178__$1);

return statearr_56213;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56205__$1,(15),inst_56180);
} else {
if((state_val_56206 === (6))){
var state_56205__$1 = state_56205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56205__$1,(9),startSubject);
} else {
if((state_val_56206 === (17))){
var state_56205__$1 = state_56205;
var statearr_56214_56243 = state_56205__$1;
(statearr_56214_56243[(2)] = true);

(statearr_56214_56243[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (3))){
var inst_56203 = (state_56205[(2)]);
var state_56205__$1 = state_56205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56205__$1,inst_56203);
} else {
if((state_val_56206 === (12))){
var state_56205__$1 = state_56205;
var statearr_56215_56244 = state_56205__$1;
(statearr_56215_56244[(2)] = endSubject);

(statearr_56215_56244[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (2))){
var _ = (function (){var statearr_56216 = state_56205;
(statearr_56216[(4)] = cljs.core.cons.call(null,(5),(state_56205[(4)])));

return statearr_56216;
})();
var inst_56159 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_56205__$1 = state_56205;
if(inst_56159){
var statearr_56217_56245 = state_56205__$1;
(statearr_56217_56245[(1)] = (6));

} else {
var statearr_56218_56246 = state_56205__$1;
(statearr_56218_56246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (11))){
var state_56205__$1 = state_56205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56205__$1,(14),endSubject);
} else {
if((state_val_56206 === (9))){
var inst_56162 = (state_56205[(2)]);
var inst_56163 = fluree.db.util.async.throw_err.call(null,inst_56162);
var state_56205__$1 = state_56205;
var statearr_56220_56247 = state_56205__$1;
(statearr_56220_56247[(2)] = inst_56163);

(statearr_56220_56247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (5))){
var _ = (function (){var statearr_56221 = state_56205;
(statearr_56221[(4)] = cljs.core.rest.call(null,(state_56205[(4)])));

return statearr_56221;
})();
var state_56205__$1 = state_56205;
var ex56219 = (state_56205__$1[(2)]);
var statearr_56222_56248 = state_56205__$1;
(statearr_56222_56248[(5)] = ex56219);


if((ex56219 instanceof Error)){
var statearr_56223_56249 = state_56205__$1;
(statearr_56223_56249[(1)] = (4));

(statearr_56223_56249[(5)] = null);

} else {
throw ex56219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (14))){
var inst_56174 = (state_56205[(2)]);
var inst_56175 = fluree.db.util.async.throw_err.call(null,inst_56174);
var state_56205__$1 = state_56205;
var statearr_56224_56250 = state_56205__$1;
(statearr_56224_56250[(2)] = inst_56175);

(statearr_56224_56250[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (16))){
var state_56205__$1 = state_56205;
var statearr_56225_56251 = state_56205__$1;
(statearr_56225_56251[(2)] = false);

(statearr_56225_56251[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (10))){
var inst_56169 = (state_56205[(2)]);
var inst_56170 = fluree.db.util.async.throw_err.call(null,inst_56169);
var inst_56171 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_56205__$1 = (function (){var statearr_56226 = state_56205;
(statearr_56226[(8)] = inst_56170);

return statearr_56226;
})();
if(inst_56171){
var statearr_56227_56252 = state_56205__$1;
(statearr_56227_56252[(1)] = (11));

} else {
var statearr_56228_56253 = state_56205__$1;
(statearr_56228_56253[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (18))){
var inst_56170 = (state_56205[(8)]);
var inst_56178 = (state_56205[(9)]);
var inst_56185 = (state_56205[(7)]);
var inst_56166 = (state_56205[(10)]);
var inst_56190 = (state_56205[(2)]);
var inst_56191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56192 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56194 = [inst_56166,inst_56170,inst_56178];
var inst_56195 = (new cljs.core.PersistentVector(null,3,(5),inst_56193,inst_56194,null));
var inst_56196 = ["relationship?",inst_56195,inst_56190];
var inst_56197 = cljs.core.PersistentHashMap.fromArrays(inst_56192,inst_56196);
var inst_56198 = [inst_56197,inst_56185];
var inst_56199 = (new cljs.core.PersistentVector(null,2,(5),inst_56191,inst_56198,null));
var inst_56200 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56199);
var _ = (function (){var statearr_56229 = state_56205;
(statearr_56229[(4)] = cljs.core.rest.call(null,(state_56205[(4)])));

return statearr_56229;
})();
var state_56205__$1 = (function (){var statearr_56230 = state_56205;
(statearr_56230[(11)] = inst_56200);

return statearr_56230;
})();
var statearr_56231_56254 = state_56205__$1;
(statearr_56231_56254[(2)] = inst_56190);

(statearr_56231_56254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56206 === (8))){
var inst_56166 = (state_56205[(2)]);
var inst_56167 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_56205__$1 = (function (){var statearr_56232 = state_56205;
(statearr_56232[(10)] = inst_56166);

return statearr_56232;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56205__$1,(10),inst_56167);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_56233 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56233[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_56233[(1)] = (1));

return statearr_56233;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_56205){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56234){var ex__2749__auto__ = e56234;
var statearr_56235_56255 = state_56205;
(statearr_56235_56255[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56205[(4)]))){
var statearr_56236_56256 = state_56205;
(statearr_56236_56256[(1)] = cljs.core.first.call(null,(state_56205[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56257 = state_56205;
state_56205 = G__56257;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = function(state_56205){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_56205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56237 = f__2769__auto__.call(null);
(statearr_56237[(6)] = c__2768__auto__);

return statearr_56237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56294){
var state_val_56295 = (state_56294[(1)]);
if((state_val_56295 === (7))){
var state_56294__$1 = state_56294;
var statearr_56296_56316 = state_56294__$1;
(statearr_56296_56316[(2)] = pred_name);

(statearr_56296_56316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56295 === (1))){
var state_56294__$1 = state_56294;
var statearr_56297_56317 = state_56294__$1;
(statearr_56297_56317[(2)] = null);

(statearr_56297_56317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56295 === (4))){
var inst_56258 = (state_56294[(2)]);
var state_56294__$1 = state_56294;
var statearr_56298_56318 = state_56294__$1;
(statearr_56298_56318[(2)] = inst_56258);

(statearr_56298_56318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56295 === (6))){
var state_56294__$1 = state_56294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56294__$1,(9),pred_name);
} else {
if((state_val_56295 === (3))){
var inst_56292 = (state_56294[(2)]);
var state_56294__$1 = state_56294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56294__$1,inst_56292);
} else {
if((state_val_56295 === (2))){
var _ = (function (){var statearr_56300 = state_56294;
(statearr_56300[(4)] = cljs.core.cons.call(null,(5),(state_56294[(4)])));

return statearr_56300;
})();
var inst_56267 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_56294__$1 = state_56294;
if(inst_56267){
var statearr_56301_56319 = state_56294__$1;
(statearr_56301_56319[(1)] = (6));

} else {
var statearr_56302_56320 = state_56294__$1;
(statearr_56302_56320[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56295 === (9))){
var inst_56270 = (state_56294[(2)]);
var inst_56271 = fluree.db.util.async.throw_err.call(null,inst_56270);
var state_56294__$1 = state_56294;
var statearr_56303_56321 = state_56294__$1;
(statearr_56303_56321[(2)] = inst_56271);

(statearr_56303_56321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56295 === (5))){
var _ = (function (){var statearr_56304 = state_56294;
(statearr_56304[(4)] = cljs.core.rest.call(null,(state_56294[(4)])));

return statearr_56304;
})();
var state_56294__$1 = state_56294;
var ex56299 = (state_56294__$1[(2)]);
var statearr_56305_56322 = state_56294__$1;
(statearr_56305_56322[(5)] = ex56299);


if((ex56299 instanceof Error)){
var statearr_56306_56323 = state_56294__$1;
(statearr_56306_56323[(1)] = (4));

(statearr_56306_56323[(5)] = null);

} else {
throw ex56299;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56295 === (10))){
var inst_56274 = (state_56294[(7)]);
var inst_56278 = (state_56294[(2)]);
var inst_56279 = fluree.db.util.async.throw_err.call(null,inst_56278);
var inst_56280 = cljs.core.nth.call(null,inst_56279,(0),null);
var inst_56281 = cljs.core.nth.call(null,inst_56279,(1),null);
var inst_56282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56283 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56284 = ["max-pred-val",inst_56274,inst_56280];
var inst_56285 = cljs.core.PersistentHashMap.fromArrays(inst_56283,inst_56284);
var inst_56286 = (inst_56281 + (10));
var inst_56287 = [inst_56285,inst_56286];
var inst_56288 = (new cljs.core.PersistentVector(null,2,(5),inst_56282,inst_56287,null));
var inst_56289 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56288);
var _ = (function (){var statearr_56307 = state_56294;
(statearr_56307[(4)] = cljs.core.rest.call(null,(state_56294[(4)])));

return statearr_56307;
})();
var state_56294__$1 = (function (){var statearr_56308 = state_56294;
(statearr_56308[(8)] = inst_56289);

return statearr_56308;
})();
var statearr_56309_56324 = state_56294__$1;
(statearr_56309_56324[(2)] = inst_56280);

(statearr_56309_56324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56295 === (8))){
var inst_56274 = (state_56294[(7)]);
var inst_56274__$1 = (state_56294[(2)]);
var inst_56275 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56276 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_56275,inst_56274__$1,null);
var state_56294__$1 = (function (){var statearr_56310 = state_56294;
(statearr_56310[(7)] = inst_56274__$1);

return statearr_56310;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56294__$1,(10),inst_56276);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_56311 = [null,null,null,null,null,null,null,null,null];
(statearr_56311[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__);

(statearr_56311[(1)] = (1));

return statearr_56311;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1 = (function (state_56294){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56312){var ex__2749__auto__ = e56312;
var statearr_56313_56325 = state_56294;
(statearr_56313_56325[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56294[(4)]))){
var statearr_56314_56326 = state_56294;
(statearr_56314_56326[(1)] = cljs.core.first.call(null,(state_56294[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56327 = state_56294;
state_56294 = G__56327;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = function(state_56294){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1.call(this,state_56294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56315 = f__2769__auto__.call(null);
(statearr_56315[(6)] = c__2768__auto__);

return statearr_56315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56354){
var state_val_56355 = (state_56354[(1)]);
if((state_val_56355 === (7))){
var state_56354__$1 = state_56354;
var statearr_56356_56375 = state_56354__$1;
(statearr_56356_56375[(2)] = n);

(statearr_56356_56375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56355 === (1))){
var state_56354__$1 = state_56354;
var statearr_56357_56376 = state_56354__$1;
(statearr_56357_56376[(2)] = null);

(statearr_56357_56376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56355 === (4))){
var inst_56328 = (state_56354[(2)]);
var state_56354__$1 = state_56354;
var statearr_56358_56377 = state_56354__$1;
(statearr_56358_56377[(2)] = inst_56328);

(statearr_56358_56377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56355 === (6))){
var state_56354__$1 = state_56354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56354__$1,(9),n);
} else {
if((state_val_56355 === (3))){
var inst_56352 = (state_56354[(2)]);
var state_56354__$1 = state_56354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56354__$1,inst_56352);
} else {
if((state_val_56355 === (2))){
var _ = (function (){var statearr_56360 = state_56354;
(statearr_56360[(4)] = cljs.core.cons.call(null,(5),(state_56354[(4)])));

return statearr_56360;
})();
var inst_56334 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56354__$1 = state_56354;
if(inst_56334){
var statearr_56361_56378 = state_56354__$1;
(statearr_56361_56378[(1)] = (6));

} else {
var statearr_56362_56379 = state_56354__$1;
(statearr_56362_56379[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56355 === (9))){
var inst_56337 = (state_56354[(2)]);
var inst_56338 = fluree.db.util.async.throw_err.call(null,inst_56337);
var state_56354__$1 = state_56354;
var statearr_56363_56380 = state_56354__$1;
(statearr_56363_56380[(2)] = inst_56338);

(statearr_56363_56380[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56355 === (5))){
var _ = (function (){var statearr_56364 = state_56354;
(statearr_56364[(4)] = cljs.core.rest.call(null,(state_56354[(4)])));

return statearr_56364;
})();
var state_56354__$1 = state_56354;
var ex56359 = (state_56354__$1[(2)]);
var statearr_56365_56381 = state_56354__$1;
(statearr_56365_56381[(5)] = ex56359);


if((ex56359 instanceof Error)){
var statearr_56366_56382 = state_56354__$1;
(statearr_56366_56382[(1)] = (4));

(statearr_56366_56382[(5)] = null);

} else {
throw ex56359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56355 === (8))){
var inst_56341 = (state_56354[(2)]);
var inst_56342 = fluree.db.dbfunctions.internal.inc.call(null,inst_56341);
var inst_56343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56344 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56345 = ["inc",inst_56341,inst_56342];
var inst_56346 = cljs.core.PersistentHashMap.fromArrays(inst_56344,inst_56345);
var inst_56347 = [inst_56346,(10)];
var inst_56348 = (new cljs.core.PersistentVector(null,2,(5),inst_56343,inst_56347,null));
var inst_56349 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56348);
var _ = (function (){var statearr_56367 = state_56354;
(statearr_56367[(4)] = cljs.core.rest.call(null,(state_56354[(4)])));

return statearr_56367;
})();
var state_56354__$1 = (function (){var statearr_56368 = state_56354;
(statearr_56368[(7)] = inst_56349);

return statearr_56368;
})();
var statearr_56369_56383 = state_56354__$1;
(statearr_56369_56383[(2)] = inst_56342);

(statearr_56369_56383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0 = (function (){
var statearr_56370 = [null,null,null,null,null,null,null,null];
(statearr_56370[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__);

(statearr_56370[(1)] = (1));

return statearr_56370;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1 = (function (state_56354){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56371){var ex__2749__auto__ = e56371;
var statearr_56372_56384 = state_56354;
(statearr_56372_56384[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56354[(4)]))){
var statearr_56373_56385 = state_56354;
(statearr_56373_56385[(1)] = cljs.core.first.call(null,(state_56354[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56386 = state_56354;
state_56354 = G__56386;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = function(state_56354){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1.call(this,state_56354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56374 = f__2769__auto__.call(null);
(statearr_56374[(6)] = c__2768__auto__);

return statearr_56374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56413){
var state_val_56414 = (state_56413[(1)]);
if((state_val_56414 === (7))){
var state_56413__$1 = state_56413;
var statearr_56415_56434 = state_56413__$1;
(statearr_56415_56434[(2)] = n);

(statearr_56415_56434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56414 === (1))){
var state_56413__$1 = state_56413;
var statearr_56416_56435 = state_56413__$1;
(statearr_56416_56435[(2)] = null);

(statearr_56416_56435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56414 === (4))){
var inst_56387 = (state_56413[(2)]);
var state_56413__$1 = state_56413;
var statearr_56417_56436 = state_56413__$1;
(statearr_56417_56436[(2)] = inst_56387);

(statearr_56417_56436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56414 === (6))){
var state_56413__$1 = state_56413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56413__$1,(9),n);
} else {
if((state_val_56414 === (3))){
var inst_56411 = (state_56413[(2)]);
var state_56413__$1 = state_56413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56413__$1,inst_56411);
} else {
if((state_val_56414 === (2))){
var _ = (function (){var statearr_56419 = state_56413;
(statearr_56419[(4)] = cljs.core.cons.call(null,(5),(state_56413[(4)])));

return statearr_56419;
})();
var inst_56393 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56413__$1 = state_56413;
if(inst_56393){
var statearr_56420_56437 = state_56413__$1;
(statearr_56420_56437[(1)] = (6));

} else {
var statearr_56421_56438 = state_56413__$1;
(statearr_56421_56438[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56414 === (9))){
var inst_56396 = (state_56413[(2)]);
var inst_56397 = fluree.db.util.async.throw_err.call(null,inst_56396);
var state_56413__$1 = state_56413;
var statearr_56422_56439 = state_56413__$1;
(statearr_56422_56439[(2)] = inst_56397);

(statearr_56422_56439[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56414 === (5))){
var _ = (function (){var statearr_56423 = state_56413;
(statearr_56423[(4)] = cljs.core.rest.call(null,(state_56413[(4)])));

return statearr_56423;
})();
var state_56413__$1 = state_56413;
var ex56418 = (state_56413__$1[(2)]);
var statearr_56424_56440 = state_56413__$1;
(statearr_56424_56440[(5)] = ex56418);


if((ex56418 instanceof Error)){
var statearr_56425_56441 = state_56413__$1;
(statearr_56425_56441[(1)] = (4));

(statearr_56425_56441[(5)] = null);

} else {
throw ex56418;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56414 === (8))){
var inst_56400 = (state_56413[(2)]);
var inst_56401 = fluree.db.dbfunctions.internal.dec.call(null,inst_56400);
var inst_56402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56403 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56404 = ["dec",inst_56400,inst_56401];
var inst_56405 = cljs.core.PersistentHashMap.fromArrays(inst_56403,inst_56404);
var inst_56406 = [inst_56405,(10)];
var inst_56407 = (new cljs.core.PersistentVector(null,2,(5),inst_56402,inst_56406,null));
var inst_56408 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56407);
var _ = (function (){var statearr_56426 = state_56413;
(statearr_56426[(4)] = cljs.core.rest.call(null,(state_56413[(4)])));

return statearr_56426;
})();
var state_56413__$1 = (function (){var statearr_56427 = state_56413;
(statearr_56427[(7)] = inst_56408);

return statearr_56427;
})();
var statearr_56428_56442 = state_56413__$1;
(statearr_56428_56442[(2)] = inst_56401);

(statearr_56428_56442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0 = (function (){
var statearr_56429 = [null,null,null,null,null,null,null,null];
(statearr_56429[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__);

(statearr_56429[(1)] = (1));

return statearr_56429;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1 = (function (state_56413){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56430){var ex__2749__auto__ = e56430;
var statearr_56431_56443 = state_56413;
(statearr_56431_56443[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56413[(4)]))){
var statearr_56432_56444 = state_56413;
(statearr_56432_56444[(1)] = cljs.core.first.call(null,(state_56413[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56445 = state_56413;
state_56413 = G__56445;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = function(state_56413){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1.call(this,state_56413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56433 = f__2769__auto__.call(null);
(statearr_56433[(6)] = c__2768__auto__);

return statearr_56433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56495 = arguments.length;
var i__5770__auto___56496 = (0);
while(true){
if((i__5770__auto___56496 < len__5769__auto___56495)){
args__5775__auto__.push((arguments[i__5770__auto___56496]));

var G__56497 = (i__5770__auto___56496 + (1));
i__5770__auto___56496 = G__56497;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56478){
var state_val_56479 = (state_56478[(1)]);
if((state_val_56479 === (1))){
var state_56478__$1 = state_56478;
var statearr_56480_56498 = state_56478__$1;
(statearr_56480_56498[(2)] = null);

(statearr_56480_56498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56479 === (2))){
var _ = (function (){var statearr_56481 = state_56478;
(statearr_56481[(4)] = cljs.core.cons.call(null,(5),(state_56478[(4)])));

return statearr_56481;
})();
var inst_56454 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56478__$1 = state_56478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56478__$1,(6),inst_56454);
} else {
if((state_val_56479 === (3))){
var inst_56476 = (state_56478[(2)]);
var state_56478__$1 = state_56478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56478__$1,inst_56476);
} else {
if((state_val_56479 === (4))){
var inst_56448 = (state_56478[(2)]);
var state_56478__$1 = state_56478;
var statearr_56483_56499 = state_56478__$1;
(statearr_56483_56499[(2)] = inst_56448);

(statearr_56483_56499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56479 === (5))){
var _ = (function (){var statearr_56484 = state_56478;
(statearr_56484[(4)] = cljs.core.rest.call(null,(state_56478[(4)])));

return statearr_56484;
})();
var state_56478__$1 = state_56478;
var ex56482 = (state_56478__$1[(2)]);
var statearr_56485_56500 = state_56478__$1;
(statearr_56485_56500[(5)] = ex56482);


if((ex56482 instanceof Error)){
var statearr_56486_56501 = state_56478__$1;
(statearr_56486_56501[(1)] = (4));

(statearr_56486_56501[(5)] = null);

} else {
throw ex56482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56479 === (6))){
var inst_56456 = (state_56478[(2)]);
var inst_56457 = fluree.db.util.async.throw_err.call(null,inst_56456);
var inst_56458 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_56457);
var inst_56459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56460 = [inst_56457];
var inst_56461 = (new cljs.core.PersistentVector(null,1,(5),inst_56459,inst_56460,null));
var inst_56462 = cljs.core.count.call(null,inst_56461);
var inst_56463 = ((9) + inst_56462);
var inst_56464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56465 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56467 = [inst_56457];
var inst_56468 = (new cljs.core.PersistentVector(null,1,(5),inst_56466,inst_56467,null));
var inst_56469 = ["+",inst_56468,inst_56458];
var inst_56470 = cljs.core.PersistentHashMap.fromArrays(inst_56465,inst_56469);
var inst_56471 = [inst_56470,inst_56463];
var inst_56472 = (new cljs.core.PersistentVector(null,2,(5),inst_56464,inst_56471,null));
var inst_56473 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56472);
var _ = (function (){var statearr_56487 = state_56478;
(statearr_56487[(4)] = cljs.core.rest.call(null,(state_56478[(4)])));

return statearr_56487;
})();
var state_56478__$1 = (function (){var statearr_56488 = state_56478;
(statearr_56488[(7)] = inst_56473);

return statearr_56488;
})();
var statearr_56489_56502 = state_56478__$1;
(statearr_56489_56502[(2)] = inst_56458);

(statearr_56489_56502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56490 = [null,null,null,null,null,null,null,null];
(statearr_56490[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56490[(1)] = (1));

return statearr_56490;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56478){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56491){var ex__2749__auto__ = e56491;
var statearr_56492_56503 = state_56478;
(statearr_56492_56503[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56478[(4)]))){
var statearr_56493_56504 = state_56478;
(statearr_56493_56504[(1)] = cljs.core.first.call(null,(state_56478[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56505 = state_56478;
state_56478 = G__56505;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56478){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56494 = f__2769__auto__.call(null);
(statearr_56494[(6)] = c__2768__auto__);

return statearr_56494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56446){
var G__56447 = cljs.core.first.call(null,seq56446);
var seq56446__$1 = cljs.core.next.call(null,seq56446);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56447,seq56446__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56555 = arguments.length;
var i__5770__auto___56556 = (0);
while(true){
if((i__5770__auto___56556 < len__5769__auto___56555)){
args__5775__auto__.push((arguments[i__5770__auto___56556]));

var G__56557 = (i__5770__auto___56556 + (1));
i__5770__auto___56556 = G__56557;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56538){
var state_val_56539 = (state_56538[(1)]);
if((state_val_56539 === (1))){
var state_56538__$1 = state_56538;
var statearr_56540_56558 = state_56538__$1;
(statearr_56540_56558[(2)] = null);

(statearr_56540_56558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (2))){
var _ = (function (){var statearr_56541 = state_56538;
(statearr_56541[(4)] = cljs.core.cons.call(null,(5),(state_56538[(4)])));

return statearr_56541;
})();
var inst_56514 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56538__$1 = state_56538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56538__$1,(6),inst_56514);
} else {
if((state_val_56539 === (3))){
var inst_56536 = (state_56538[(2)]);
var state_56538__$1 = state_56538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56538__$1,inst_56536);
} else {
if((state_val_56539 === (4))){
var inst_56508 = (state_56538[(2)]);
var state_56538__$1 = state_56538;
var statearr_56543_56559 = state_56538__$1;
(statearr_56543_56559[(2)] = inst_56508);

(statearr_56543_56559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (5))){
var _ = (function (){var statearr_56544 = state_56538;
(statearr_56544[(4)] = cljs.core.rest.call(null,(state_56538[(4)])));

return statearr_56544;
})();
var state_56538__$1 = state_56538;
var ex56542 = (state_56538__$1[(2)]);
var statearr_56545_56560 = state_56538__$1;
(statearr_56545_56560[(5)] = ex56542);


if((ex56542 instanceof Error)){
var statearr_56546_56561 = state_56538__$1;
(statearr_56546_56561[(1)] = (4));

(statearr_56546_56561[(5)] = null);

} else {
throw ex56542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56539 === (6))){
var inst_56516 = (state_56538[(2)]);
var inst_56517 = fluree.db.util.async.throw_err.call(null,inst_56516);
var inst_56518 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_56517);
var inst_56519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56520 = [inst_56517];
var inst_56521 = (new cljs.core.PersistentVector(null,1,(5),inst_56519,inst_56520,null));
var inst_56522 = cljs.core.count.call(null,inst_56521);
var inst_56523 = ((9) + inst_56522);
var inst_56524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56525 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56527 = [inst_56517];
var inst_56528 = (new cljs.core.PersistentVector(null,1,(5),inst_56526,inst_56527,null));
var inst_56529 = ["-",inst_56528,inst_56518];
var inst_56530 = cljs.core.PersistentHashMap.fromArrays(inst_56525,inst_56529);
var inst_56531 = [inst_56530,inst_56523];
var inst_56532 = (new cljs.core.PersistentVector(null,2,(5),inst_56524,inst_56531,null));
var inst_56533 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56532);
var _ = (function (){var statearr_56547 = state_56538;
(statearr_56547[(4)] = cljs.core.rest.call(null,(state_56538[(4)])));

return statearr_56547;
})();
var state_56538__$1 = (function (){var statearr_56548 = state_56538;
(statearr_56548[(7)] = inst_56533);

return statearr_56548;
})();
var statearr_56549_56562 = state_56538__$1;
(statearr_56549_56562[(2)] = inst_56518);

(statearr_56549_56562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56550 = [null,null,null,null,null,null,null,null];
(statearr_56550[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56550[(1)] = (1));

return statearr_56550;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56538){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56551){var ex__2749__auto__ = e56551;
var statearr_56552_56563 = state_56538;
(statearr_56552_56563[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56538[(4)]))){
var statearr_56553_56564 = state_56538;
(statearr_56553_56564[(1)] = cljs.core.first.call(null,(state_56538[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56565 = state_56538;
state_56538 = G__56565;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56538){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56554 = f__2769__auto__.call(null);
(statearr_56554[(6)] = c__2768__auto__);

return statearr_56554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56506){
var G__56507 = cljs.core.first.call(null,seq56506);
var seq56506__$1 = cljs.core.next.call(null,seq56506);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56507,seq56506__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56615 = arguments.length;
var i__5770__auto___56616 = (0);
while(true){
if((i__5770__auto___56616 < len__5769__auto___56615)){
args__5775__auto__.push((arguments[i__5770__auto___56616]));

var G__56617 = (i__5770__auto___56616 + (1));
i__5770__auto___56616 = G__56617;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56598){
var state_val_56599 = (state_56598[(1)]);
if((state_val_56599 === (1))){
var state_56598__$1 = state_56598;
var statearr_56600_56618 = state_56598__$1;
(statearr_56600_56618[(2)] = null);

(statearr_56600_56618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (2))){
var _ = (function (){var statearr_56601 = state_56598;
(statearr_56601[(4)] = cljs.core.cons.call(null,(5),(state_56598[(4)])));

return statearr_56601;
})();
var inst_56574 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56598__$1 = state_56598;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56598__$1,(6),inst_56574);
} else {
if((state_val_56599 === (3))){
var inst_56596 = (state_56598[(2)]);
var state_56598__$1 = state_56598;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56598__$1,inst_56596);
} else {
if((state_val_56599 === (4))){
var inst_56568 = (state_56598[(2)]);
var state_56598__$1 = state_56598;
var statearr_56603_56619 = state_56598__$1;
(statearr_56603_56619[(2)] = inst_56568);

(statearr_56603_56619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (5))){
var _ = (function (){var statearr_56604 = state_56598;
(statearr_56604[(4)] = cljs.core.rest.call(null,(state_56598[(4)])));

return statearr_56604;
})();
var state_56598__$1 = state_56598;
var ex56602 = (state_56598__$1[(2)]);
var statearr_56605_56620 = state_56598__$1;
(statearr_56605_56620[(5)] = ex56602);


if((ex56602 instanceof Error)){
var statearr_56606_56621 = state_56598__$1;
(statearr_56606_56621[(1)] = (4));

(statearr_56606_56621[(5)] = null);

} else {
throw ex56602;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (6))){
var inst_56576 = (state_56598[(2)]);
var inst_56577 = fluree.db.util.async.throw_err.call(null,inst_56576);
var inst_56578 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_56577);
var inst_56579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56580 = [inst_56577];
var inst_56581 = (new cljs.core.PersistentVector(null,1,(5),inst_56579,inst_56580,null));
var inst_56582 = cljs.core.count.call(null,inst_56581);
var inst_56583 = ((9) + inst_56582);
var inst_56584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56585 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56587 = [inst_56577];
var inst_56588 = (new cljs.core.PersistentVector(null,1,(5),inst_56586,inst_56587,null));
var inst_56589 = ["*",inst_56588,inst_56578];
var inst_56590 = cljs.core.PersistentHashMap.fromArrays(inst_56585,inst_56589);
var inst_56591 = [inst_56590,inst_56583];
var inst_56592 = (new cljs.core.PersistentVector(null,2,(5),inst_56584,inst_56591,null));
var inst_56593 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56592);
var _ = (function (){var statearr_56607 = state_56598;
(statearr_56607[(4)] = cljs.core.rest.call(null,(state_56598[(4)])));

return statearr_56607;
})();
var state_56598__$1 = (function (){var statearr_56608 = state_56598;
(statearr_56608[(7)] = inst_56593);

return statearr_56608;
})();
var statearr_56609_56622 = state_56598__$1;
(statearr_56609_56622[(2)] = inst_56578);

(statearr_56609_56622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56610 = [null,null,null,null,null,null,null,null];
(statearr_56610[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56610[(1)] = (1));

return statearr_56610;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56598){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56598);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56611){var ex__2749__auto__ = e56611;
var statearr_56612_56623 = state_56598;
(statearr_56612_56623[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56598[(4)]))){
var statearr_56613_56624 = state_56598;
(statearr_56613_56624[(1)] = cljs.core.first.call(null,(state_56598[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56625 = state_56598;
state_56598 = G__56625;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56598){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56614 = f__2769__auto__.call(null);
(statearr_56614[(6)] = c__2768__auto__);

return statearr_56614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56566){
var G__56567 = cljs.core.first.call(null,seq56566);
var seq56566__$1 = cljs.core.next.call(null,seq56566);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56567,seq56566__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56675 = arguments.length;
var i__5770__auto___56676 = (0);
while(true){
if((i__5770__auto___56676 < len__5769__auto___56675)){
args__5775__auto__.push((arguments[i__5770__auto___56676]));

var G__56677 = (i__5770__auto___56676 + (1));
i__5770__auto___56676 = G__56677;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56658){
var state_val_56659 = (state_56658[(1)]);
if((state_val_56659 === (1))){
var state_56658__$1 = state_56658;
var statearr_56660_56678 = state_56658__$1;
(statearr_56660_56678[(2)] = null);

(statearr_56660_56678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56659 === (2))){
var _ = (function (){var statearr_56661 = state_56658;
(statearr_56661[(4)] = cljs.core.cons.call(null,(5),(state_56658[(4)])));

return statearr_56661;
})();
var inst_56634 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56658__$1 = state_56658;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56658__$1,(6),inst_56634);
} else {
if((state_val_56659 === (3))){
var inst_56656 = (state_56658[(2)]);
var state_56658__$1 = state_56658;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56658__$1,inst_56656);
} else {
if((state_val_56659 === (4))){
var inst_56628 = (state_56658[(2)]);
var state_56658__$1 = state_56658;
var statearr_56663_56679 = state_56658__$1;
(statearr_56663_56679[(2)] = inst_56628);

(statearr_56663_56679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56659 === (5))){
var _ = (function (){var statearr_56664 = state_56658;
(statearr_56664[(4)] = cljs.core.rest.call(null,(state_56658[(4)])));

return statearr_56664;
})();
var state_56658__$1 = state_56658;
var ex56662 = (state_56658__$1[(2)]);
var statearr_56665_56680 = state_56658__$1;
(statearr_56665_56680[(5)] = ex56662);


if((ex56662 instanceof Error)){
var statearr_56666_56681 = state_56658__$1;
(statearr_56666_56681[(1)] = (4));

(statearr_56666_56681[(5)] = null);

} else {
throw ex56662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56659 === (6))){
var inst_56636 = (state_56658[(2)]);
var inst_56637 = fluree.db.util.async.throw_err.call(null,inst_56636);
var inst_56638 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_56637);
var inst_56639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56640 = [inst_56637];
var inst_56641 = (new cljs.core.PersistentVector(null,1,(5),inst_56639,inst_56640,null));
var inst_56642 = cljs.core.count.call(null,inst_56641);
var inst_56643 = ((9) + inst_56642);
var inst_56644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56645 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56647 = [inst_56637];
var inst_56648 = (new cljs.core.PersistentVector(null,1,(5),inst_56646,inst_56647,null));
var inst_56649 = ["/",inst_56648,inst_56638];
var inst_56650 = cljs.core.PersistentHashMap.fromArrays(inst_56645,inst_56649);
var inst_56651 = [inst_56650,inst_56643];
var inst_56652 = (new cljs.core.PersistentVector(null,2,(5),inst_56644,inst_56651,null));
var inst_56653 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56652);
var _ = (function (){var statearr_56667 = state_56658;
(statearr_56667[(4)] = cljs.core.rest.call(null,(state_56658[(4)])));

return statearr_56667;
})();
var state_56658__$1 = (function (){var statearr_56668 = state_56658;
(statearr_56668[(7)] = inst_56653);

return statearr_56668;
})();
var statearr_56669_56682 = state_56658__$1;
(statearr_56669_56682[(2)] = inst_56638);

(statearr_56669_56682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56670 = [null,null,null,null,null,null,null,null];
(statearr_56670[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56670[(1)] = (1));

return statearr_56670;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56658){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56658);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56671){var ex__2749__auto__ = e56671;
var statearr_56672_56683 = state_56658;
(statearr_56672_56683[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56658[(4)]))){
var statearr_56673_56684 = state_56658;
(statearr_56673_56684[(1)] = cljs.core.first.call(null,(state_56658[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56685 = state_56658;
state_56658 = G__56685;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56658){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56674 = f__2769__auto__.call(null);
(statearr_56674[(6)] = c__2768__auto__);

return statearr_56674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56626){
var G__56627 = cljs.core.first.call(null,seq56626);
var seq56626__$1 = cljs.core.next.call(null,seq56626);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56627,seq56626__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56723){
var state_val_56724 = (state_56723[(1)]);
if((state_val_56724 === (7))){
var state_56723__$1 = state_56723;
var statearr_56725_56749 = state_56723__$1;
(statearr_56725_56749[(2)] = n);

(statearr_56725_56749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (1))){
var state_56723__$1 = state_56723;
var statearr_56726_56750 = state_56723__$1;
(statearr_56726_56750[(2)] = null);

(statearr_56726_56750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (4))){
var inst_56686 = (state_56723[(2)]);
var state_56723__$1 = state_56723;
var statearr_56727_56751 = state_56723__$1;
(statearr_56727_56751[(2)] = inst_56686);

(statearr_56727_56751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (13))){
var inst_56703 = (state_56723[(2)]);
var inst_56704 = fluree.db.util.async.throw_err.call(null,inst_56703);
var state_56723__$1 = state_56723;
var statearr_56728_56752 = state_56723__$1;
(statearr_56728_56752[(2)] = inst_56704);

(statearr_56728_56752[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (6))){
var state_56723__$1 = state_56723;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56723__$1,(9),n);
} else {
if((state_val_56724 === (3))){
var inst_56721 = (state_56723[(2)]);
var state_56723__$1 = state_56723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56723__$1,inst_56721);
} else {
if((state_val_56724 === (12))){
var inst_56699 = (state_56723[(7)]);
var inst_56707 = (state_56723[(2)]);
var inst_56708 = fluree.db.dbfunctions.internal.quot.call(null,inst_56699,inst_56707);
var inst_56709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56710 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56712 = [inst_56699,inst_56707];
var inst_56713 = (new cljs.core.PersistentVector(null,2,(5),inst_56711,inst_56712,null));
var inst_56714 = ["quot",inst_56713,inst_56708];
var inst_56715 = cljs.core.PersistentHashMap.fromArrays(inst_56710,inst_56714);
var inst_56716 = [inst_56715,(2)];
var inst_56717 = (new cljs.core.PersistentVector(null,2,(5),inst_56709,inst_56716,null));
var inst_56718 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56717);
var _ = (function (){var statearr_56729 = state_56723;
(statearr_56729[(4)] = cljs.core.rest.call(null,(state_56723[(4)])));

return statearr_56729;
})();
var state_56723__$1 = (function (){var statearr_56730 = state_56723;
(statearr_56730[(8)] = inst_56718);

return statearr_56730;
})();
var statearr_56731_56753 = state_56723__$1;
(statearr_56731_56753[(2)] = inst_56708);

(statearr_56731_56753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (2))){
var _ = (function (){var statearr_56732 = state_56723;
(statearr_56732[(4)] = cljs.core.cons.call(null,(5),(state_56723[(4)])));

return statearr_56732;
})();
var inst_56692 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56723__$1 = state_56723;
if(inst_56692){
var statearr_56733_56754 = state_56723__$1;
(statearr_56733_56754[(1)] = (6));

} else {
var statearr_56734_56755 = state_56723__$1;
(statearr_56734_56755[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (11))){
var state_56723__$1 = state_56723;
var statearr_56736_56756 = state_56723__$1;
(statearr_56736_56756[(2)] = d);

(statearr_56736_56756[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (9))){
var inst_56695 = (state_56723[(2)]);
var inst_56696 = fluree.db.util.async.throw_err.call(null,inst_56695);
var state_56723__$1 = state_56723;
var statearr_56737_56757 = state_56723__$1;
(statearr_56737_56757[(2)] = inst_56696);

(statearr_56737_56757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (5))){
var _ = (function (){var statearr_56738 = state_56723;
(statearr_56738[(4)] = cljs.core.rest.call(null,(state_56723[(4)])));

return statearr_56738;
})();
var state_56723__$1 = state_56723;
var ex56735 = (state_56723__$1[(2)]);
var statearr_56739_56758 = state_56723__$1;
(statearr_56739_56758[(5)] = ex56735);


if((ex56735 instanceof Error)){
var statearr_56740_56759 = state_56723__$1;
(statearr_56740_56759[(1)] = (4));

(statearr_56740_56759[(5)] = null);

} else {
throw ex56735;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (10))){
var state_56723__$1 = state_56723;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56723__$1,(13),d);
} else {
if((state_val_56724 === (8))){
var inst_56699 = (state_56723[(2)]);
var inst_56700 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56723__$1 = (function (){var statearr_56741 = state_56723;
(statearr_56741[(7)] = inst_56699);

return statearr_56741;
})();
if(inst_56700){
var statearr_56742_56760 = state_56723__$1;
(statearr_56742_56760[(1)] = (10));

} else {
var statearr_56743_56761 = state_56723__$1;
(statearr_56743_56761[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0 = (function (){
var statearr_56744 = [null,null,null,null,null,null,null,null,null];
(statearr_56744[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__);

(statearr_56744[(1)] = (1));

return statearr_56744;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1 = (function (state_56723){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56745){var ex__2749__auto__ = e56745;
var statearr_56746_56762 = state_56723;
(statearr_56746_56762[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56723[(4)]))){
var statearr_56747_56763 = state_56723;
(statearr_56747_56763[(1)] = cljs.core.first.call(null,(state_56723[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56764 = state_56723;
state_56723 = G__56764;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = function(state_56723){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1.call(this,state_56723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56748 = f__2769__auto__.call(null);
(statearr_56748[(6)] = c__2768__auto__);

return statearr_56748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56802){
var state_val_56803 = (state_56802[(1)]);
if((state_val_56803 === (7))){
var state_56802__$1 = state_56802;
var statearr_56804_56828 = state_56802__$1;
(statearr_56804_56828[(2)] = n);

(statearr_56804_56828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (1))){
var state_56802__$1 = state_56802;
var statearr_56805_56829 = state_56802__$1;
(statearr_56805_56829[(2)] = null);

(statearr_56805_56829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (4))){
var inst_56765 = (state_56802[(2)]);
var state_56802__$1 = state_56802;
var statearr_56806_56830 = state_56802__$1;
(statearr_56806_56830[(2)] = inst_56765);

(statearr_56806_56830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (13))){
var inst_56782 = (state_56802[(2)]);
var inst_56783 = fluree.db.util.async.throw_err.call(null,inst_56782);
var state_56802__$1 = state_56802;
var statearr_56807_56831 = state_56802__$1;
(statearr_56807_56831[(2)] = inst_56783);

(statearr_56807_56831[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (6))){
var state_56802__$1 = state_56802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56802__$1,(9),n);
} else {
if((state_val_56803 === (3))){
var inst_56800 = (state_56802[(2)]);
var state_56802__$1 = state_56802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56802__$1,inst_56800);
} else {
if((state_val_56803 === (12))){
var inst_56778 = (state_56802[(7)]);
var inst_56786 = (state_56802[(2)]);
var inst_56787 = fluree.db.dbfunctions.internal.mod.call(null,inst_56778,inst_56786);
var inst_56788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56789 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56791 = [inst_56778,inst_56786];
var inst_56792 = (new cljs.core.PersistentVector(null,2,(5),inst_56790,inst_56791,null));
var inst_56793 = ["mod",inst_56792,inst_56787];
var inst_56794 = cljs.core.PersistentHashMap.fromArrays(inst_56789,inst_56793);
var inst_56795 = [inst_56794,(2)];
var inst_56796 = (new cljs.core.PersistentVector(null,2,(5),inst_56788,inst_56795,null));
var inst_56797 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56796);
var _ = (function (){var statearr_56808 = state_56802;
(statearr_56808[(4)] = cljs.core.rest.call(null,(state_56802[(4)])));

return statearr_56808;
})();
var state_56802__$1 = (function (){var statearr_56809 = state_56802;
(statearr_56809[(8)] = inst_56797);

return statearr_56809;
})();
var statearr_56810_56832 = state_56802__$1;
(statearr_56810_56832[(2)] = inst_56787);

(statearr_56810_56832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (2))){
var _ = (function (){var statearr_56811 = state_56802;
(statearr_56811[(4)] = cljs.core.cons.call(null,(5),(state_56802[(4)])));

return statearr_56811;
})();
var inst_56771 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56802__$1 = state_56802;
if(inst_56771){
var statearr_56812_56833 = state_56802__$1;
(statearr_56812_56833[(1)] = (6));

} else {
var statearr_56813_56834 = state_56802__$1;
(statearr_56813_56834[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (11))){
var state_56802__$1 = state_56802;
var statearr_56815_56835 = state_56802__$1;
(statearr_56815_56835[(2)] = d);

(statearr_56815_56835[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (9))){
var inst_56774 = (state_56802[(2)]);
var inst_56775 = fluree.db.util.async.throw_err.call(null,inst_56774);
var state_56802__$1 = state_56802;
var statearr_56816_56836 = state_56802__$1;
(statearr_56816_56836[(2)] = inst_56775);

(statearr_56816_56836[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (5))){
var _ = (function (){var statearr_56817 = state_56802;
(statearr_56817[(4)] = cljs.core.rest.call(null,(state_56802[(4)])));

return statearr_56817;
})();
var state_56802__$1 = state_56802;
var ex56814 = (state_56802__$1[(2)]);
var statearr_56818_56837 = state_56802__$1;
(statearr_56818_56837[(5)] = ex56814);


if((ex56814 instanceof Error)){
var statearr_56819_56838 = state_56802__$1;
(statearr_56819_56838[(1)] = (4));

(statearr_56819_56838[(5)] = null);

} else {
throw ex56814;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56803 === (10))){
var state_56802__$1 = state_56802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56802__$1,(13),d);
} else {
if((state_val_56803 === (8))){
var inst_56778 = (state_56802[(2)]);
var inst_56779 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56802__$1 = (function (){var statearr_56820 = state_56802;
(statearr_56820[(7)] = inst_56778);

return statearr_56820;
})();
if(inst_56779){
var statearr_56821_56839 = state_56802__$1;
(statearr_56821_56839[(1)] = (10));

} else {
var statearr_56822_56840 = state_56802__$1;
(statearr_56822_56840[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0 = (function (){
var statearr_56823 = [null,null,null,null,null,null,null,null,null];
(statearr_56823[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__);

(statearr_56823[(1)] = (1));

return statearr_56823;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1 = (function (state_56802){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56824){var ex__2749__auto__ = e56824;
var statearr_56825_56841 = state_56802;
(statearr_56825_56841[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56802[(4)]))){
var statearr_56826_56842 = state_56802;
(statearr_56826_56842[(1)] = cljs.core.first.call(null,(state_56802[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56843 = state_56802;
state_56802 = G__56843;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = function(state_56802){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1.call(this,state_56802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56827 = f__2769__auto__.call(null);
(statearr_56827[(6)] = c__2768__auto__);

return statearr_56827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56881){
var state_val_56882 = (state_56881[(1)]);
if((state_val_56882 === (7))){
var state_56881__$1 = state_56881;
var statearr_56883_56907 = state_56881__$1;
(statearr_56883_56907[(2)] = n);

(statearr_56883_56907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (1))){
var state_56881__$1 = state_56881;
var statearr_56884_56908 = state_56881__$1;
(statearr_56884_56908[(2)] = null);

(statearr_56884_56908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (4))){
var inst_56844 = (state_56881[(2)]);
var state_56881__$1 = state_56881;
var statearr_56885_56909 = state_56881__$1;
(statearr_56885_56909[(2)] = inst_56844);

(statearr_56885_56909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (13))){
var inst_56861 = (state_56881[(2)]);
var inst_56862 = fluree.db.util.async.throw_err.call(null,inst_56861);
var state_56881__$1 = state_56881;
var statearr_56886_56910 = state_56881__$1;
(statearr_56886_56910[(2)] = inst_56862);

(statearr_56886_56910[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (6))){
var state_56881__$1 = state_56881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56881__$1,(9),n);
} else {
if((state_val_56882 === (3))){
var inst_56879 = (state_56881[(2)]);
var state_56881__$1 = state_56881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56881__$1,inst_56879);
} else {
if((state_val_56882 === (12))){
var inst_56857 = (state_56881[(7)]);
var inst_56865 = (state_56881[(2)]);
var inst_56866 = fluree.db.dbfunctions.internal.rem.call(null,inst_56857,inst_56865);
var inst_56867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56868 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56870 = [inst_56857,inst_56865];
var inst_56871 = (new cljs.core.PersistentVector(null,2,(5),inst_56869,inst_56870,null));
var inst_56872 = ["rem",inst_56871,inst_56866];
var inst_56873 = cljs.core.PersistentHashMap.fromArrays(inst_56868,inst_56872);
var inst_56874 = [inst_56873,(2)];
var inst_56875 = (new cljs.core.PersistentVector(null,2,(5),inst_56867,inst_56874,null));
var inst_56876 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56875);
var _ = (function (){var statearr_56887 = state_56881;
(statearr_56887[(4)] = cljs.core.rest.call(null,(state_56881[(4)])));

return statearr_56887;
})();
var state_56881__$1 = (function (){var statearr_56888 = state_56881;
(statearr_56888[(8)] = inst_56876);

return statearr_56888;
})();
var statearr_56889_56911 = state_56881__$1;
(statearr_56889_56911[(2)] = inst_56866);

(statearr_56889_56911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (2))){
var _ = (function (){var statearr_56890 = state_56881;
(statearr_56890[(4)] = cljs.core.cons.call(null,(5),(state_56881[(4)])));

return statearr_56890;
})();
var inst_56850 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56881__$1 = state_56881;
if(inst_56850){
var statearr_56891_56912 = state_56881__$1;
(statearr_56891_56912[(1)] = (6));

} else {
var statearr_56892_56913 = state_56881__$1;
(statearr_56892_56913[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (11))){
var state_56881__$1 = state_56881;
var statearr_56894_56914 = state_56881__$1;
(statearr_56894_56914[(2)] = d);

(statearr_56894_56914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (9))){
var inst_56853 = (state_56881[(2)]);
var inst_56854 = fluree.db.util.async.throw_err.call(null,inst_56853);
var state_56881__$1 = state_56881;
var statearr_56895_56915 = state_56881__$1;
(statearr_56895_56915[(2)] = inst_56854);

(statearr_56895_56915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (5))){
var _ = (function (){var statearr_56896 = state_56881;
(statearr_56896[(4)] = cljs.core.rest.call(null,(state_56881[(4)])));

return statearr_56896;
})();
var state_56881__$1 = state_56881;
var ex56893 = (state_56881__$1[(2)]);
var statearr_56897_56916 = state_56881__$1;
(statearr_56897_56916[(5)] = ex56893);


if((ex56893 instanceof Error)){
var statearr_56898_56917 = state_56881__$1;
(statearr_56898_56917[(1)] = (4));

(statearr_56898_56917[(5)] = null);

} else {
throw ex56893;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56882 === (10))){
var state_56881__$1 = state_56881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56881__$1,(13),d);
} else {
if((state_val_56882 === (8))){
var inst_56857 = (state_56881[(2)]);
var inst_56858 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56881__$1 = (function (){var statearr_56899 = state_56881;
(statearr_56899[(7)] = inst_56857);

return statearr_56899;
})();
if(inst_56858){
var statearr_56900_56918 = state_56881__$1;
(statearr_56900_56918[(1)] = (10));

} else {
var statearr_56901_56919 = state_56881__$1;
(statearr_56901_56919[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0 = (function (){
var statearr_56902 = [null,null,null,null,null,null,null,null,null];
(statearr_56902[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__);

(statearr_56902[(1)] = (1));

return statearr_56902;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1 = (function (state_56881){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56903){var ex__2749__auto__ = e56903;
var statearr_56904_56920 = state_56881;
(statearr_56904_56920[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56881[(4)]))){
var statearr_56905_56921 = state_56881;
(statearr_56905_56921[(1)] = cljs.core.first.call(null,(state_56881[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56922 = state_56881;
state_56881 = G__56922;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = function(state_56881){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1.call(this,state_56881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56906 = f__2769__auto__.call(null);
(statearr_56906[(6)] = c__2768__auto__);

return statearr_56906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56949){
var state_val_56950 = (state_56949[(1)]);
if((state_val_56950 === (7))){
var state_56949__$1 = state_56949;
var statearr_56951_56970 = state_56949__$1;
(statearr_56951_56970[(2)] = x);

(statearr_56951_56970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (1))){
var state_56949__$1 = state_56949;
var statearr_56952_56971 = state_56949__$1;
(statearr_56952_56971[(2)] = null);

(statearr_56952_56971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (4))){
var inst_56923 = (state_56949[(2)]);
var state_56949__$1 = state_56949;
var statearr_56953_56972 = state_56949__$1;
(statearr_56953_56972[(2)] = inst_56923);

(statearr_56953_56972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (6))){
var state_56949__$1 = state_56949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56949__$1,(9),x);
} else {
if((state_val_56950 === (3))){
var inst_56947 = (state_56949[(2)]);
var state_56949__$1 = state_56949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56949__$1,inst_56947);
} else {
if((state_val_56950 === (2))){
var _ = (function (){var statearr_56955 = state_56949;
(statearr_56955[(4)] = cljs.core.cons.call(null,(5),(state_56949[(4)])));

return statearr_56955;
})();
var inst_56929 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_56949__$1 = state_56949;
if(inst_56929){
var statearr_56956_56973 = state_56949__$1;
(statearr_56956_56973[(1)] = (6));

} else {
var statearr_56957_56974 = state_56949__$1;
(statearr_56957_56974[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (9))){
var inst_56932 = (state_56949[(2)]);
var inst_56933 = fluree.db.util.async.throw_err.call(null,inst_56932);
var state_56949__$1 = state_56949;
var statearr_56958_56975 = state_56949__$1;
(statearr_56958_56975[(2)] = inst_56933);

(statearr_56958_56975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (5))){
var _ = (function (){var statearr_56959 = state_56949;
(statearr_56959[(4)] = cljs.core.rest.call(null,(state_56949[(4)])));

return statearr_56959;
})();
var state_56949__$1 = state_56949;
var ex56954 = (state_56949__$1[(2)]);
var statearr_56960_56976 = state_56949__$1;
(statearr_56960_56976[(5)] = ex56954);


if((ex56954 instanceof Error)){
var statearr_56961_56977 = state_56949__$1;
(statearr_56961_56977[(1)] = (4));

(statearr_56961_56977[(5)] = null);

} else {
throw ex56954;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (8))){
var inst_56936 = (state_56949[(2)]);
var inst_56937 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_56936);
var inst_56938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56939 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56940 = ["boolean",inst_56936,inst_56937];
var inst_56941 = cljs.core.PersistentHashMap.fromArrays(inst_56939,inst_56940);
var inst_56942 = [inst_56941,(10)];
var inst_56943 = (new cljs.core.PersistentVector(null,2,(5),inst_56938,inst_56942,null));
var inst_56944 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56943);
var _ = (function (){var statearr_56962 = state_56949;
(statearr_56962[(4)] = cljs.core.rest.call(null,(state_56949[(4)])));

return statearr_56962;
})();
var state_56949__$1 = (function (){var statearr_56963 = state_56949;
(statearr_56963[(7)] = inst_56944);

return statearr_56963;
})();
var statearr_56964_56978 = state_56949__$1;
(statearr_56964_56978[(2)] = inst_56937);

(statearr_56964_56978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0 = (function (){
var statearr_56965 = [null,null,null,null,null,null,null,null];
(statearr_56965[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__);

(statearr_56965[(1)] = (1));

return statearr_56965;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1 = (function (state_56949){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56966){var ex__2749__auto__ = e56966;
var statearr_56967_56979 = state_56949;
(statearr_56967_56979[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56949[(4)]))){
var statearr_56968_56980 = state_56949;
(statearr_56968_56980[(1)] = cljs.core.first.call(null,(state_56949[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56981 = state_56949;
state_56949 = G__56981;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = function(state_56949){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1.call(this,state_56949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56969 = f__2769__auto__.call(null);
(statearr_56969[(6)] = c__2768__auto__);

return statearr_56969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57019){
var state_val_57020 = (state_57019[(1)]);
if((state_val_57020 === (7))){
var state_57019__$1 = state_57019;
var statearr_57021_57045 = state_57019__$1;
(statearr_57021_57045[(2)] = pattern);

(statearr_57021_57045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (1))){
var state_57019__$1 = state_57019;
var statearr_57022_57046 = state_57019__$1;
(statearr_57022_57046[(2)] = null);

(statearr_57022_57046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (4))){
var inst_56982 = (state_57019[(2)]);
var state_57019__$1 = state_57019;
var statearr_57023_57047 = state_57019__$1;
(statearr_57023_57047[(2)] = inst_56982);

(statearr_57023_57047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (13))){
var inst_56999 = (state_57019[(2)]);
var inst_57000 = fluree.db.util.async.throw_err.call(null,inst_56999);
var state_57019__$1 = state_57019;
var statearr_57024_57048 = state_57019__$1;
(statearr_57024_57048[(2)] = inst_57000);

(statearr_57024_57048[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (6))){
var state_57019__$1 = state_57019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57019__$1,(9),pattern);
} else {
if((state_val_57020 === (3))){
var inst_57017 = (state_57019[(2)]);
var state_57019__$1 = state_57019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57019__$1,inst_57017);
} else {
if((state_val_57020 === (12))){
var inst_56995 = (state_57019[(7)]);
var inst_57003 = (state_57019[(2)]);
var inst_57004 = fluree.db.dbfunctions.internal.re_find.call(null,inst_56995,inst_57003);
var inst_57005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57006 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57008 = [inst_56995,inst_57003];
var inst_57009 = (new cljs.core.PersistentVector(null,2,(5),inst_57007,inst_57008,null));
var inst_57010 = ["re-find",inst_57009,inst_57004];
var inst_57011 = cljs.core.PersistentHashMap.fromArrays(inst_57006,inst_57010);
var inst_57012 = [inst_57011,(10)];
var inst_57013 = (new cljs.core.PersistentVector(null,2,(5),inst_57005,inst_57012,null));
var inst_57014 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57013);
var _ = (function (){var statearr_57025 = state_57019;
(statearr_57025[(4)] = cljs.core.rest.call(null,(state_57019[(4)])));

return statearr_57025;
})();
var state_57019__$1 = (function (){var statearr_57026 = state_57019;
(statearr_57026[(8)] = inst_57014);

return statearr_57026;
})();
var statearr_57027_57049 = state_57019__$1;
(statearr_57027_57049[(2)] = inst_57004);

(statearr_57027_57049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (2))){
var _ = (function (){var statearr_57028 = state_57019;
(statearr_57028[(4)] = cljs.core.cons.call(null,(5),(state_57019[(4)])));

return statearr_57028;
})();
var inst_56988 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_57019__$1 = state_57019;
if(inst_56988){
var statearr_57029_57050 = state_57019__$1;
(statearr_57029_57050[(1)] = (6));

} else {
var statearr_57030_57051 = state_57019__$1;
(statearr_57030_57051[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (11))){
var state_57019__$1 = state_57019;
var statearr_57032_57052 = state_57019__$1;
(statearr_57032_57052[(2)] = string);

(statearr_57032_57052[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (9))){
var inst_56991 = (state_57019[(2)]);
var inst_56992 = fluree.db.util.async.throw_err.call(null,inst_56991);
var state_57019__$1 = state_57019;
var statearr_57033_57053 = state_57019__$1;
(statearr_57033_57053[(2)] = inst_56992);

(statearr_57033_57053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (5))){
var _ = (function (){var statearr_57034 = state_57019;
(statearr_57034[(4)] = cljs.core.rest.call(null,(state_57019[(4)])));

return statearr_57034;
})();
var state_57019__$1 = state_57019;
var ex57031 = (state_57019__$1[(2)]);
var statearr_57035_57054 = state_57019__$1;
(statearr_57035_57054[(5)] = ex57031);


if((ex57031 instanceof Error)){
var statearr_57036_57055 = state_57019__$1;
(statearr_57036_57055[(1)] = (4));

(statearr_57036_57055[(5)] = null);

} else {
throw ex57031;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57020 === (10))){
var state_57019__$1 = state_57019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57019__$1,(13),string);
} else {
if((state_val_57020 === (8))){
var inst_56995 = (state_57019[(2)]);
var inst_56996 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_57019__$1 = (function (){var statearr_57037 = state_57019;
(statearr_57037[(7)] = inst_56995);

return statearr_57037;
})();
if(inst_56996){
var statearr_57038_57056 = state_57019__$1;
(statearr_57038_57056[(1)] = (10));

} else {
var statearr_57039_57057 = state_57019__$1;
(statearr_57039_57057[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0 = (function (){
var statearr_57040 = [null,null,null,null,null,null,null,null,null];
(statearr_57040[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__);

(statearr_57040[(1)] = (1));

return statearr_57040;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1 = (function (state_57019){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57041){var ex__2749__auto__ = e57041;
var statearr_57042_57058 = state_57019;
(statearr_57042_57058[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57019[(4)]))){
var statearr_57043_57059 = state_57019;
(statearr_57043_57059[(1)] = cljs.core.first.call(null,(state_57019[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57060 = state_57019;
state_57019 = G__57060;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = function(state_57019){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1.call(this,state_57019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57044 = f__2769__auto__.call(null);
(statearr_57044[(6)] = c__2768__auto__);

return statearr_57044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57087){
var state_val_57088 = (state_57087[(1)]);
if((state_val_57088 === (7))){
var state_57087__$1 = state_57087;
var statearr_57089_57108 = state_57087__$1;
(statearr_57089_57108[(2)] = email);

(statearr_57089_57108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (1))){
var state_57087__$1 = state_57087;
var statearr_57090_57109 = state_57087__$1;
(statearr_57090_57109[(2)] = null);

(statearr_57090_57109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (4))){
var inst_57061 = (state_57087[(2)]);
var state_57087__$1 = state_57087;
var statearr_57091_57110 = state_57087__$1;
(statearr_57091_57110[(2)] = inst_57061);

(statearr_57091_57110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (6))){
var state_57087__$1 = state_57087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57087__$1,(9),email);
} else {
if((state_val_57088 === (3))){
var inst_57085 = (state_57087[(2)]);
var state_57087__$1 = state_57087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57087__$1,inst_57085);
} else {
if((state_val_57088 === (2))){
var _ = (function (){var statearr_57093 = state_57087;
(statearr_57093[(4)] = cljs.core.cons.call(null,(5),(state_57087[(4)])));

return statearr_57093;
})();
var inst_57067 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_57087__$1 = state_57087;
if(inst_57067){
var statearr_57094_57111 = state_57087__$1;
(statearr_57094_57111[(1)] = (6));

} else {
var statearr_57095_57112 = state_57087__$1;
(statearr_57095_57112[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (9))){
var inst_57070 = (state_57087[(2)]);
var inst_57071 = fluree.db.util.async.throw_err.call(null,inst_57070);
var state_57087__$1 = state_57087;
var statearr_57096_57113 = state_57087__$1;
(statearr_57096_57113[(2)] = inst_57071);

(statearr_57096_57113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (5))){
var _ = (function (){var statearr_57097 = state_57087;
(statearr_57097[(4)] = cljs.core.rest.call(null,(state_57087[(4)])));

return statearr_57097;
})();
var state_57087__$1 = state_57087;
var ex57092 = (state_57087__$1[(2)]);
var statearr_57098_57114 = state_57087__$1;
(statearr_57098_57114[(5)] = ex57092);


if((ex57092 instanceof Error)){
var statearr_57099_57115 = state_57087__$1;
(statearr_57099_57115[(1)] = (4));

(statearr_57099_57115[(5)] = null);

} else {
throw ex57092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (8))){
var inst_57074 = (state_57087[(2)]);
var inst_57075 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_57074);
var inst_57076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57077 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57078 = ["re-find",inst_57074,inst_57075];
var inst_57079 = cljs.core.PersistentHashMap.fromArrays(inst_57077,inst_57078);
var inst_57080 = [inst_57079,(10)];
var inst_57081 = (new cljs.core.PersistentVector(null,2,(5),inst_57076,inst_57080,null));
var inst_57082 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57081);
var _ = (function (){var statearr_57100 = state_57087;
(statearr_57100[(4)] = cljs.core.rest.call(null,(state_57087[(4)])));

return statearr_57100;
})();
var state_57087__$1 = (function (){var statearr_57101 = state_57087;
(statearr_57101[(7)] = inst_57082);

return statearr_57101;
})();
var statearr_57102_57116 = state_57087__$1;
(statearr_57102_57116[(2)] = inst_57075);

(statearr_57102_57116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_57103 = [null,null,null,null,null,null,null,null];
(statearr_57103[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__);

(statearr_57103[(1)] = (1));

return statearr_57103;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1 = (function (state_57087){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57104){var ex__2749__auto__ = e57104;
var statearr_57105_57117 = state_57087;
(statearr_57105_57117[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57087[(4)]))){
var statearr_57106_57118 = state_57087;
(statearr_57106_57118[(1)] = cljs.core.first.call(null,(state_57087[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57119 = state_57087;
state_57087 = G__57119;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = function(state_57087){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1.call(this,state_57087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57107 = f__2769__auto__.call(null);
(statearr_57107[(6)] = c__2768__auto__);

return statearr_57107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57166){
var state_val_57167 = (state_57166[(1)]);
if((state_val_57167 === (7))){
var inst_57136 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57166__$1 = state_57166;
if(cljs.core.truth_(inst_57136)){
var statearr_57168_57195 = state_57166__$1;
(statearr_57168_57195[(1)] = (9));

} else {
var statearr_57169_57196 = state_57166__$1;
(statearr_57169_57196[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (1))){
var state_57166__$1 = state_57166;
var statearr_57170_57197 = state_57166__$1;
(statearr_57170_57197[(2)] = null);

(statearr_57170_57197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (4))){
var inst_57120 = (state_57166[(2)]);
var state_57166__$1 = state_57166;
var statearr_57171_57198 = state_57166__$1;
(statearr_57171_57198[(2)] = inst_57120);

(statearr_57171_57198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (15))){
var inst_57147 = (state_57166[(2)]);
var state_57166__$1 = state_57166;
var statearr_57172_57199 = state_57166__$1;
(statearr_57172_57199[(2)] = inst_57147);

(statearr_57172_57199[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (13))){
var inst_57144 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57166__$1 = state_57166;
var statearr_57173_57200 = state_57166__$1;
(statearr_57173_57200[(2)] = inst_57144);

(statearr_57173_57200[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (6))){
var inst_57131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57132 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57133 = [inst_57132,(0)];
var inst_57134 = (new cljs.core.PersistentVector(null,2,(5),inst_57131,inst_57133,null));
var state_57166__$1 = state_57166;
var statearr_57174_57201 = state_57166__$1;
(statearr_57174_57201[(2)] = inst_57134);

(statearr_57174_57201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (3))){
var inst_57164 = (state_57166[(2)]);
var state_57166__$1 = state_57166;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57166__$1,inst_57164);
} else {
if((state_val_57167 === (12))){
var inst_57140 = (state_57166[(2)]);
var inst_57141 = fluree.db.util.async.throw_err.call(null,inst_57140);
var state_57166__$1 = state_57166;
var statearr_57175_57202 = state_57166__$1;
(statearr_57175_57202[(2)] = inst_57141);

(statearr_57175_57202[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (2))){
var _ = (function (){var statearr_57176 = state_57166;
(statearr_57176[(4)] = cljs.core.cons.call(null,(5),(state_57166[(4)])));

return statearr_57176;
})();
var inst_57129 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57166__$1 = state_57166;
if(cljs.core.truth_(inst_57129)){
var statearr_57177_57203 = state_57166__$1;
(statearr_57177_57203[(1)] = (6));

} else {
var statearr_57178_57204 = state_57166__$1;
(statearr_57178_57204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (11))){
var inst_57149 = (state_57166[(2)]);
var state_57166__$1 = state_57166;
var statearr_57180_57205 = state_57166__$1;
(statearr_57180_57205[(2)] = inst_57149);

(statearr_57180_57205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (9))){
var inst_57138 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_57166__$1 = state_57166;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57166__$1,(12),inst_57138);
} else {
if((state_val_57167 === (5))){
var _ = (function (){var statearr_57181 = state_57166;
(statearr_57181[(4)] = cljs.core.rest.call(null,(state_57166[(4)])));

return statearr_57181;
})();
var state_57166__$1 = state_57166;
var ex57179 = (state_57166__$1[(2)]);
var statearr_57182_57206 = state_57166__$1;
(statearr_57182_57206[(5)] = ex57179);


if((ex57179 instanceof Error)){
var statearr_57183_57207 = state_57166__$1;
(statearr_57183_57207[(1)] = (4));

(statearr_57183_57207[(5)] = null);

} else {
throw ex57179;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (14))){
var state_57166__$1 = state_57166;
var statearr_57184_57208 = state_57166__$1;
(statearr_57184_57208[(2)] = null);

(statearr_57184_57208[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (10))){
var state_57166__$1 = state_57166;
var statearr_57185_57209 = state_57166__$1;
(statearr_57185_57209[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57167 === (8))){
var inst_57151 = (state_57166[(2)]);
var inst_57152 = cljs.core.nth.call(null,inst_57151,(0),null);
var inst_57153 = cljs.core.nth.call(null,inst_57151,(1),null);
var inst_57154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57155 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57156 = ["?user_id","?ctx",inst_57152];
var inst_57157 = cljs.core.PersistentHashMap.fromArrays(inst_57155,inst_57156);
var inst_57158 = ((10) + inst_57153);
var inst_57159 = [inst_57157,inst_57158];
var inst_57160 = (new cljs.core.PersistentVector(null,2,(5),inst_57154,inst_57159,null));
var inst_57161 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57160);
var _ = (function (){var statearr_57187 = state_57166;
(statearr_57187[(4)] = cljs.core.rest.call(null,(state_57166[(4)])));

return statearr_57187;
})();
var state_57166__$1 = (function (){var statearr_57188 = state_57166;
(statearr_57188[(7)] = inst_57161);

return statearr_57188;
})();
var statearr_57189_57210 = state_57166__$1;
(statearr_57189_57210[(2)] = inst_57152);

(statearr_57189_57210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0 = (function (){
var statearr_57190 = [null,null,null,null,null,null,null,null];
(statearr_57190[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__);

(statearr_57190[(1)] = (1));

return statearr_57190;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1 = (function (state_57166){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57166);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57191){var ex__2749__auto__ = e57191;
var statearr_57192_57211 = state_57166;
(statearr_57192_57211[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57166[(4)]))){
var statearr_57193_57212 = state_57166;
(statearr_57193_57212[(1)] = cljs.core.first.call(null,(state_57166[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57213 = state_57166;
state_57166 = G__57213;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = function(state_57166){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1.call(this,state_57166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57194 = f__2769__auto__.call(null);
(statearr_57194[(6)] = c__2768__auto__);

return statearr_57194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57241){
var state_val_57242 = (state_57241[(1)]);
if((state_val_57242 === (7))){
var inst_57234 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57241__$1 = state_57241;
var statearr_57243_57262 = state_57241__$1;
(statearr_57243_57262[(2)] = inst_57234);

(statearr_57243_57262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (1))){
var state_57241__$1 = state_57241;
var statearr_57244_57263 = state_57241__$1;
(statearr_57244_57263[(2)] = null);

(statearr_57244_57263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (4))){
var inst_57214 = (state_57241[(2)]);
var state_57241__$1 = state_57241;
var statearr_57245_57264 = state_57241__$1;
(statearr_57245_57264[(2)] = inst_57214);

(statearr_57245_57264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (6))){
var inst_57222 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_57241__$1 = state_57241;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57241__$1,(9),inst_57222);
} else {
if((state_val_57242 === (3))){
var inst_57239 = (state_57241[(2)]);
var state_57241__$1 = state_57241;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57241__$1,inst_57239);
} else {
if((state_val_57242 === (2))){
var _ = (function (){var statearr_57247 = state_57241;
(statearr_57247[(4)] = cljs.core.cons.call(null,(5),(state_57241[(4)])));

return statearr_57247;
})();
var inst_57220 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57241__$1 = state_57241;
if(cljs.core.truth_(inst_57220)){
var statearr_57248_57265 = state_57241__$1;
(statearr_57248_57265[(1)] = (6));

} else {
var statearr_57249_57266 = state_57241__$1;
(statearr_57249_57266[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (9))){
var inst_57224 = (state_57241[(2)]);
var inst_57225 = fluree.db.util.async.throw_err.call(null,inst_57224);
var inst_57226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57227 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57228 = ["?auth_id","?ctx",inst_57225];
var inst_57229 = cljs.core.PersistentHashMap.fromArrays(inst_57227,inst_57228);
var inst_57230 = [inst_57229,(10)];
var inst_57231 = (new cljs.core.PersistentVector(null,2,(5),inst_57226,inst_57230,null));
var inst_57232 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57231);
var state_57241__$1 = (function (){var statearr_57250 = state_57241;
(statearr_57250[(7)] = inst_57232);

return statearr_57250;
})();
var statearr_57251_57267 = state_57241__$1;
(statearr_57251_57267[(2)] = inst_57225);

(statearr_57251_57267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (5))){
var _ = (function (){var statearr_57252 = state_57241;
(statearr_57252[(4)] = cljs.core.rest.call(null,(state_57241[(4)])));

return statearr_57252;
})();
var state_57241__$1 = state_57241;
var ex57246 = (state_57241__$1[(2)]);
var statearr_57253_57268 = state_57241__$1;
(statearr_57253_57268[(5)] = ex57246);


if((ex57246 instanceof Error)){
var statearr_57254_57269 = state_57241__$1;
(statearr_57254_57269[(1)] = (4));

(statearr_57254_57269[(5)] = null);

} else {
throw ex57246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (8))){
var inst_57236 = (state_57241[(2)]);
var _ = (function (){var statearr_57255 = state_57241;
(statearr_57255[(4)] = cljs.core.rest.call(null,(state_57241[(4)])));

return statearr_57255;
})();
var state_57241__$1 = state_57241;
var statearr_57256_57270 = state_57241__$1;
(statearr_57256_57270[(2)] = inst_57236);

(statearr_57256_57270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_57257 = [null,null,null,null,null,null,null,null];
(statearr_57257[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_57257[(1)] = (1));

return statearr_57257;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_57241){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57258){var ex__2749__auto__ = e57258;
var statearr_57259_57271 = state_57241;
(statearr_57259_57271[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57241[(4)]))){
var statearr_57260_57272 = state_57241;
(statearr_57260_57272[(1)] = cljs.core.first.call(null,(state_57241[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57273 = state_57241;
state_57241 = G__57273;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_57241){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_57241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57261 = f__2769__auto__.call(null);
(statearr_57261[(6)] = c__2768__auto__);

return statearr_57261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57275 = arguments.length;
switch (G__57275) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57317){
var state_val_57318 = (state_57317[(1)]);
if((state_val_57318 === (7))){
var state_57317__$1 = state_57317;
var statearr_57319_57349 = state_57317__$1;
(statearr_57319_57349[(2)] = seed);

(statearr_57319_57349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (1))){
var state_57317__$1 = state_57317;
var statearr_57320_57350 = state_57317__$1;
(statearr_57320_57350[(2)] = null);

(statearr_57320_57350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (4))){
var inst_57276 = (state_57317[(2)]);
var state_57317__$1 = state_57317;
var statearr_57321_57351 = state_57317__$1;
(statearr_57321_57351[(2)] = inst_57276);

(statearr_57321_57351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (15))){
var state_57317__$1 = state_57317;
var statearr_57322_57352 = state_57317__$1;
(statearr_57322_57352[(2)] = (10));

(statearr_57322_57352[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (13))){
var inst_57293 = (state_57317[(2)]);
var inst_57294 = fluree.db.util.async.throw_err.call(null,inst_57293);
var state_57317__$1 = state_57317;
var statearr_57323_57353 = state_57317__$1;
(statearr_57323_57353[(2)] = inst_57294);

(statearr_57323_57353[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (6))){
var state_57317__$1 = state_57317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57317__$1,(9),seed);
} else {
if((state_val_57318 === (3))){
var inst_57315 = (state_57317[(2)]);
var state_57317__$1 = state_57317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57317__$1,inst_57315);
} else {
if((state_val_57318 === (12))){
var inst_57297 = (state_57317[(7)]);
var inst_57297__$1 = (state_57317[(2)]);
var state_57317__$1 = (function (){var statearr_57324 = state_57317;
(statearr_57324[(7)] = inst_57297__$1);

return statearr_57324;
})();
if(cljs.core.truth_(inst_57297__$1)){
var statearr_57325_57354 = state_57317__$1;
(statearr_57325_57354[(1)] = (14));

} else {
var statearr_57326_57355 = state_57317__$1;
(statearr_57326_57355[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (2))){
var _ = (function (){var statearr_57327 = state_57317;
(statearr_57327[(4)] = cljs.core.cons.call(null,(5),(state_57317[(4)])));

return statearr_57327;
})();
var inst_57282 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_57317__$1 = state_57317;
if(inst_57282){
var statearr_57328_57356 = state_57317__$1;
(statearr_57328_57356[(1)] = (6));

} else {
var statearr_57329_57357 = state_57317__$1;
(statearr_57329_57357[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (11))){
var state_57317__$1 = state_57317;
var statearr_57331_57358 = state_57317__$1;
(statearr_57331_57358[(2)] = max);

(statearr_57331_57358[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (9))){
var inst_57285 = (state_57317[(2)]);
var inst_57286 = fluree.db.util.async.throw_err.call(null,inst_57285);
var state_57317__$1 = state_57317;
var statearr_57332_57359 = state_57317__$1;
(statearr_57332_57359[(2)] = inst_57286);

(statearr_57332_57359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (5))){
var _ = (function (){var statearr_57333 = state_57317;
(statearr_57333[(4)] = cljs.core.rest.call(null,(state_57317[(4)])));

return statearr_57333;
})();
var state_57317__$1 = state_57317;
var ex57330 = (state_57317__$1[(2)]);
var statearr_57334_57360 = state_57317__$1;
(statearr_57334_57360[(5)] = ex57330);


if((ex57330 instanceof Error)){
var statearr_57335_57361 = state_57317__$1;
(statearr_57335_57361[(1)] = (4));

(statearr_57335_57361[(5)] = null);

} else {
throw ex57330;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (14))){
var inst_57297 = (state_57317[(7)]);
var state_57317__$1 = state_57317;
var statearr_57336_57362 = state_57317__$1;
(statearr_57336_57362[(2)] = inst_57297);

(statearr_57336_57362[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (16))){
var inst_57289 = (state_57317[(8)]);
var inst_57301 = (state_57317[(2)]);
var inst_57302 = fluree.db.dbfunctions.internal.rand.call(null,inst_57289,inst_57301);
var inst_57303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57304 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57306 = [max,seed];
var inst_57307 = (new cljs.core.PersistentVector(null,2,(5),inst_57305,inst_57306,null));
var inst_57308 = ["rand",inst_57307,inst_57302];
var inst_57309 = cljs.core.PersistentHashMap.fromArrays(inst_57304,inst_57308);
var inst_57310 = [inst_57309,(10)];
var inst_57311 = (new cljs.core.PersistentVector(null,2,(5),inst_57303,inst_57310,null));
var inst_57312 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57311);
var _ = (function (){var statearr_57337 = state_57317;
(statearr_57337[(4)] = cljs.core.rest.call(null,(state_57317[(4)])));

return statearr_57337;
})();
var state_57317__$1 = (function (){var statearr_57338 = state_57317;
(statearr_57338[(9)] = inst_57312);

return statearr_57338;
})();
var statearr_57339_57363 = state_57317__$1;
(statearr_57339_57363[(2)] = inst_57302);

(statearr_57339_57363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57318 === (10))){
var state_57317__$1 = state_57317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57317__$1,(13),max);
} else {
if((state_val_57318 === (8))){
var inst_57289 = (state_57317[(2)]);
var inst_57290 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_57317__$1 = (function (){var statearr_57340 = state_57317;
(statearr_57340[(8)] = inst_57289);

return statearr_57340;
})();
if(inst_57290){
var statearr_57341_57364 = state_57317__$1;
(statearr_57341_57364[(1)] = (10));

} else {
var statearr_57342_57365 = state_57317__$1;
(statearr_57342_57365[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57343 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57343[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57343[(1)] = (1));

return statearr_57343;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57317){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57344){var ex__2749__auto__ = e57344;
var statearr_57345_57366 = state_57317;
(statearr_57345_57366[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57317[(4)]))){
var statearr_57346_57367 = state_57317;
(statearr_57346_57367[(1)] = cljs.core.first.call(null,(state_57317[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57368 = state_57317;
state_57317 = G__57368;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57317){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57347 = f__2769__auto__.call(null);
(statearr_57347[(6)] = c__2768__auto__);

return statearr_57347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57389){
var state_val_57390 = (state_57389[(1)]);
if((state_val_57390 === (1))){
var state_57389__$1 = state_57389;
var statearr_57391_57406 = state_57389__$1;
(statearr_57391_57406[(2)] = null);

(statearr_57391_57406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57390 === (2))){
var _ = (function (){var statearr_57392 = state_57389;
(statearr_57392[(4)] = cljs.core.cons.call(null,(5),(state_57389[(4)])));

return statearr_57392;
})();
var inst_57375 = fluree.db.util.core.random_uuid.call(null);
var inst_57376 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57375);
var inst_57377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57378 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57379 = cljs.core.PersistentVector.EMPTY;
var inst_57380 = ["uuid",inst_57379,inst_57376];
var inst_57381 = cljs.core.PersistentHashMap.fromArrays(inst_57378,inst_57380);
var inst_57382 = [inst_57381,(10)];
var inst_57383 = (new cljs.core.PersistentVector(null,2,(5),inst_57377,inst_57382,null));
var inst_57384 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57383);
var ___$1 = (function (){var statearr_57393 = state_57389;
(statearr_57393[(4)] = cljs.core.rest.call(null,(state_57389[(4)])));

return statearr_57393;
})();
var state_57389__$1 = (function (){var statearr_57394 = state_57389;
(statearr_57394[(7)] = inst_57384);

return statearr_57394;
})();
var statearr_57395_57407 = state_57389__$1;
(statearr_57395_57407[(2)] = inst_57376);

(statearr_57395_57407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57390 === (3))){
var inst_57387 = (state_57389[(2)]);
var state_57389__$1 = state_57389;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57389__$1,inst_57387);
} else {
if((state_val_57390 === (4))){
var inst_57369 = (state_57389[(2)]);
var state_57389__$1 = state_57389;
var statearr_57397_57408 = state_57389__$1;
(statearr_57397_57408[(2)] = inst_57369);

(statearr_57397_57408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57390 === (5))){
var _ = (function (){var statearr_57398 = state_57389;
(statearr_57398[(4)] = cljs.core.rest.call(null,(state_57389[(4)])));

return statearr_57398;
})();
var state_57389__$1 = state_57389;
var ex57396 = (state_57389__$1[(2)]);
var statearr_57399_57409 = state_57389__$1;
(statearr_57399_57409[(5)] = ex57396);


if((ex57396 instanceof Error)){
var statearr_57400_57410 = state_57389__$1;
(statearr_57400_57410[(1)] = (4));

(statearr_57400_57410[(5)] = null);

} else {
throw ex57396;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0 = (function (){
var statearr_57401 = [null,null,null,null,null,null,null,null];
(statearr_57401[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__);

(statearr_57401[(1)] = (1));

return statearr_57401;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1 = (function (state_57389){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57389);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57402){var ex__2749__auto__ = e57402;
var statearr_57403_57411 = state_57389;
(statearr_57403_57411[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57389[(4)]))){
var statearr_57404_57412 = state_57389;
(statearr_57404_57412[(1)] = cljs.core.first.call(null,(state_57389[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57413 = state_57389;
state_57389 = G__57413;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = function(state_57389){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1.call(this,state_57389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57405 = f__2769__auto__.call(null);
(statearr_57405[(6)] = c__2768__auto__);

return statearr_57405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57443){
var state_val_57444 = (state_57443[(1)]);
if((state_val_57444 === (7))){
var state_57443__$1 = state_57443;
var statearr_57445_57464 = state_57443__$1;
(statearr_57445_57464[(2)] = num);

(statearr_57445_57464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (1))){
var state_57443__$1 = state_57443;
var statearr_57446_57465 = state_57443__$1;
(statearr_57446_57465[(2)] = null);

(statearr_57446_57465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (4))){
var inst_57414 = (state_57443[(2)]);
var state_57443__$1 = state_57443;
var statearr_57447_57466 = state_57443__$1;
(statearr_57447_57466[(2)] = inst_57414);

(statearr_57447_57466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (6))){
var state_57443__$1 = state_57443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57443__$1,(9),num);
} else {
if((state_val_57444 === (3))){
var inst_57441 = (state_57443[(2)]);
var state_57443__$1 = state_57443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57443__$1,inst_57441);
} else {
if((state_val_57444 === (2))){
var _ = (function (){var statearr_57449 = state_57443;
(statearr_57449[(4)] = cljs.core.cons.call(null,(5),(state_57443[(4)])));

return statearr_57449;
})();
var inst_57420 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57443__$1 = state_57443;
if(inst_57420){
var statearr_57450_57467 = state_57443__$1;
(statearr_57450_57467[(1)] = (6));

} else {
var statearr_57451_57468 = state_57443__$1;
(statearr_57451_57468[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (9))){
var inst_57423 = (state_57443[(2)]);
var inst_57424 = fluree.db.util.async.throw_err.call(null,inst_57423);
var state_57443__$1 = state_57443;
var statearr_57452_57469 = state_57443__$1;
(statearr_57452_57469[(2)] = inst_57424);

(statearr_57452_57469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (5))){
var _ = (function (){var statearr_57453 = state_57443;
(statearr_57453[(4)] = cljs.core.rest.call(null,(state_57443[(4)])));

return statearr_57453;
})();
var state_57443__$1 = state_57443;
var ex57448 = (state_57443__$1[(2)]);
var statearr_57454_57470 = state_57443__$1;
(statearr_57454_57470[(5)] = ex57448);


if((ex57448 instanceof Error)){
var statearr_57455_57471 = state_57443__$1;
(statearr_57455_57471[(1)] = (4));

(statearr_57455_57471[(5)] = null);

} else {
throw ex57448;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (8))){
var inst_57427 = (state_57443[(2)]);
var inst_57428 = fluree.db.dbfunctions.internal.ceil.call(null,inst_57427);
var inst_57429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57430 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57432 = [fluree.db.dbfunctions.fns.ceil];
var inst_57433 = (new cljs.core.PersistentVector(null,1,(5),inst_57431,inst_57432,null));
var inst_57434 = ["",inst_57433,inst_57428];
var inst_57435 = cljs.core.PersistentHashMap.fromArrays(inst_57430,inst_57434);
var inst_57436 = [inst_57435,(10)];
var inst_57437 = (new cljs.core.PersistentVector(null,2,(5),inst_57429,inst_57436,null));
var inst_57438 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57437);
var _ = (function (){var statearr_57456 = state_57443;
(statearr_57456[(4)] = cljs.core.rest.call(null,(state_57443[(4)])));

return statearr_57456;
})();
var state_57443__$1 = (function (){var statearr_57457 = state_57443;
(statearr_57457[(7)] = inst_57438);

return statearr_57457;
})();
var statearr_57458_57472 = state_57443__$1;
(statearr_57458_57472[(2)] = inst_57428);

(statearr_57458_57472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0 = (function (){
var statearr_57459 = [null,null,null,null,null,null,null,null];
(statearr_57459[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__);

(statearr_57459[(1)] = (1));

return statearr_57459;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1 = (function (state_57443){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57460){var ex__2749__auto__ = e57460;
var statearr_57461_57473 = state_57443;
(statearr_57461_57473[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57443[(4)]))){
var statearr_57462_57474 = state_57443;
(statearr_57462_57474[(1)] = cljs.core.first.call(null,(state_57443[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57475 = state_57443;
state_57443 = G__57475;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = function(state_57443){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1.call(this,state_57443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57463 = f__2769__auto__.call(null);
(statearr_57463[(6)] = c__2768__auto__);

return statearr_57463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57505){
var state_val_57506 = (state_57505[(1)]);
if((state_val_57506 === (7))){
var state_57505__$1 = state_57505;
var statearr_57507_57526 = state_57505__$1;
(statearr_57507_57526[(2)] = num);

(statearr_57507_57526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (1))){
var state_57505__$1 = state_57505;
var statearr_57508_57527 = state_57505__$1;
(statearr_57508_57527[(2)] = null);

(statearr_57508_57527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (4))){
var inst_57476 = (state_57505[(2)]);
var state_57505__$1 = state_57505;
var statearr_57509_57528 = state_57505__$1;
(statearr_57509_57528[(2)] = inst_57476);

(statearr_57509_57528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (6))){
var state_57505__$1 = state_57505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57505__$1,(9),num);
} else {
if((state_val_57506 === (3))){
var inst_57503 = (state_57505[(2)]);
var state_57505__$1 = state_57505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57505__$1,inst_57503);
} else {
if((state_val_57506 === (2))){
var _ = (function (){var statearr_57511 = state_57505;
(statearr_57511[(4)] = cljs.core.cons.call(null,(5),(state_57505[(4)])));

return statearr_57511;
})();
var inst_57482 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57505__$1 = state_57505;
if(inst_57482){
var statearr_57512_57529 = state_57505__$1;
(statearr_57512_57529[(1)] = (6));

} else {
var statearr_57513_57530 = state_57505__$1;
(statearr_57513_57530[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (9))){
var inst_57485 = (state_57505[(2)]);
var inst_57486 = fluree.db.util.async.throw_err.call(null,inst_57485);
var state_57505__$1 = state_57505;
var statearr_57514_57531 = state_57505__$1;
(statearr_57514_57531[(2)] = inst_57486);

(statearr_57514_57531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (5))){
var _ = (function (){var statearr_57515 = state_57505;
(statearr_57515[(4)] = cljs.core.rest.call(null,(state_57505[(4)])));

return statearr_57515;
})();
var state_57505__$1 = state_57505;
var ex57510 = (state_57505__$1[(2)]);
var statearr_57516_57532 = state_57505__$1;
(statearr_57516_57532[(5)] = ex57510);


if((ex57510 instanceof Error)){
var statearr_57517_57533 = state_57505__$1;
(statearr_57517_57533[(1)] = (4));

(statearr_57517_57533[(5)] = null);

} else {
throw ex57510;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (8))){
var inst_57489 = (state_57505[(2)]);
var inst_57490 = fluree.db.dbfunctions.internal.floor.call(null,inst_57489);
var inst_57491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57492 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57494 = [fluree.db.dbfunctions.fns.floor];
var inst_57495 = (new cljs.core.PersistentVector(null,1,(5),inst_57493,inst_57494,null));
var inst_57496 = ["",inst_57495,inst_57490];
var inst_57497 = cljs.core.PersistentHashMap.fromArrays(inst_57492,inst_57496);
var inst_57498 = [inst_57497,(10)];
var inst_57499 = (new cljs.core.PersistentVector(null,2,(5),inst_57491,inst_57498,null));
var inst_57500 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57499);
var _ = (function (){var statearr_57518 = state_57505;
(statearr_57518[(4)] = cljs.core.rest.call(null,(state_57505[(4)])));

return statearr_57518;
})();
var state_57505__$1 = (function (){var statearr_57519 = state_57505;
(statearr_57519[(7)] = inst_57500);

return statearr_57519;
})();
var statearr_57520_57534 = state_57505__$1;
(statearr_57520_57534[(2)] = inst_57490);

(statearr_57520_57534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0 = (function (){
var statearr_57521 = [null,null,null,null,null,null,null,null];
(statearr_57521[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__);

(statearr_57521[(1)] = (1));

return statearr_57521;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1 = (function (state_57505){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57522){var ex__2749__auto__ = e57522;
var statearr_57523_57535 = state_57505;
(statearr_57523_57535[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57505[(4)]))){
var statearr_57524_57536 = state_57505;
(statearr_57524_57536[(1)] = cljs.core.first.call(null,(state_57505[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57537 = state_57505;
state_57505 = G__57537;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = function(state_57505){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1.call(this,state_57505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57525 = f__2769__auto__.call(null);
(statearr_57525[(6)] = c__2768__auto__);

return statearr_57525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57562){
var state_val_57563 = (state_57562[(1)]);
if((state_val_57563 === (1))){
var state_57562__$1 = state_57562;
var statearr_57564_57579 = state_57562__$1;
(statearr_57564_57579[(2)] = null);

(statearr_57564_57579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57563 === (2))){
var _ = (function (){var statearr_57565 = state_57562;
(statearr_57565[(4)] = cljs.core.cons.call(null,(5),(state_57562[(4)])));

return statearr_57565;
})();
var inst_57544 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_57562__$1 = state_57562;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57562__$1,(6),inst_57544);
} else {
if((state_val_57563 === (3))){
var inst_57560 = (state_57562[(2)]);
var state_57562__$1 = state_57562;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57562__$1,inst_57560);
} else {
if((state_val_57563 === (4))){
var inst_57538 = (state_57562[(2)]);
var state_57562__$1 = state_57562;
var statearr_57567_57580 = state_57562__$1;
(statearr_57567_57580[(2)] = inst_57538);

(statearr_57567_57580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57563 === (5))){
var _ = (function (){var statearr_57568 = state_57562;
(statearr_57568[(4)] = cljs.core.rest.call(null,(state_57562[(4)])));

return statearr_57568;
})();
var state_57562__$1 = state_57562;
var ex57566 = (state_57562__$1[(2)]);
var statearr_57569_57581 = state_57562__$1;
(statearr_57569_57581[(5)] = ex57566);


if((ex57566 instanceof Error)){
var statearr_57570_57582 = state_57562__$1;
(statearr_57570_57582[(1)] = (4));

(statearr_57570_57582[(5)] = null);

} else {
throw ex57566;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57563 === (6))){
var inst_57546 = (state_57562[(2)]);
var inst_57547 = fluree.db.util.async.throw_err.call(null,inst_57546);
var inst_57548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57549 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57551 = [compare_val,new_val];
var inst_57552 = (new cljs.core.PersistentVector(null,2,(5),inst_57550,inst_57551,null));
var inst_57553 = ["",inst_57552,inst_57547];
var inst_57554 = cljs.core.PersistentHashMap.fromArrays(inst_57549,inst_57553);
var inst_57555 = [inst_57554,(10)];
var inst_57556 = (new cljs.core.PersistentVector(null,2,(5),inst_57548,inst_57555,null));
var inst_57557 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57556);
var _ = (function (){var statearr_57571 = state_57562;
(statearr_57571[(4)] = cljs.core.rest.call(null,(state_57562[(4)])));

return statearr_57571;
})();
var state_57562__$1 = (function (){var statearr_57572 = state_57562;
(statearr_57572[(7)] = inst_57557);

return statearr_57572;
})();
var statearr_57573_57583 = state_57562__$1;
(statearr_57573_57583[(2)] = inst_57547);

(statearr_57573_57583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_57574 = [null,null,null,null,null,null,null,null];
(statearr_57574[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__);

(statearr_57574[(1)] = (1));

return statearr_57574;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1 = (function (state_57562){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57562);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57575){var ex__2749__auto__ = e57575;
var statearr_57576_57584 = state_57562;
(statearr_57576_57584[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57562[(4)]))){
var statearr_57577_57585 = state_57562;
(statearr_57577_57585[(1)] = cljs.core.first.call(null,(state_57562[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57586 = state_57562;
state_57562 = G__57586;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = function(state_57562){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1.call(this,state_57562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57578 = f__2769__auto__.call(null);
(statearr_57578[(6)] = c__2768__auto__);

return statearr_57578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
