// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29441 = arguments.length;
var i__5770__auto___29442 = (0);
while(true){
if((i__5770__auto___29442 < len__5769__auto___29441)){
args__5775__auto__.push((arguments[i__5770__auto___29442]));

var G__29443 = (i__5770__auto___29442 + (1));
i__5770__auto___29442 = G__29443;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq29438){
var G__29439 = cljs.core.first.call(null,seq29438);
var seq29438__$1 = cljs.core.next.call(null,seq29438);
var G__29440 = cljs.core.first.call(null,seq29438__$1);
var seq29438__$2 = cljs.core.next.call(null,seq29438__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29439,G__29440,seq29438__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e29444){var e = e29444;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e29445){var e = e29445;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e29446){var e = e29446;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e29447){var e = e29447;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e29448){var e = e29448;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29451 = arguments.length;
var i__5770__auto___29452 = (0);
while(true){
if((i__5770__auto___29452 < len__5769__auto___29451)){
args__5775__auto__.push((arguments[i__5770__auto___29452]));

var G__29453 = (i__5770__auto___29452 + (1));
i__5770__auto___29452 = G__29453;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29450){var e = e29450;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq29449){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29449));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29456 = arguments.length;
var i__5770__auto___29457 = (0);
while(true){
if((i__5770__auto___29457 < len__5769__auto___29456)){
args__5775__auto__.push((arguments[i__5770__auto___29457]));

var G__29458 = (i__5770__auto___29457 + (1));
i__5770__auto___29457 = G__29458;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29455){var e = e29455;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq29454){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29454));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e29459){var e = e29459;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29462 = arguments.length;
var i__5770__auto___29463 = (0);
while(true){
if((i__5770__auto___29463 < len__5769__auto___29462)){
args__5775__auto__.push((arguments[i__5770__auto___29463]));

var G__29464 = (i__5770__auto___29463 + (1));
i__5770__auto___29463 = G__29464;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e29461){var e = e29461;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq29460){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29460));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29467 = arguments.length;
var i__5770__auto___29468 = (0);
while(true){
if((i__5770__auto___29468 < len__5769__auto___29467)){
args__5775__auto__.push((arguments[i__5770__auto___29468]));

var G__29469 = (i__5770__auto___29468 + (1));
i__5770__auto___29468 = G__29469;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e29466){var e = e29466;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq29465){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29465));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e29470){var e = e29470;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e29471){var e = e29471;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29474 = arguments.length;
var i__5770__auto___29475 = (0);
while(true){
if((i__5770__auto___29475 < len__5769__auto___29474)){
args__5775__auto__.push((arguments[i__5770__auto___29475]));

var G__29476 = (i__5770__auto___29475 + (1));
i__5770__auto___29475 = G__29476;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29473){var e = e29473;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq29472){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29472));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29479 = arguments.length;
var i__5770__auto___29480 = (0);
while(true){
if((i__5770__auto___29480 < len__5769__auto___29479)){
args__5775__auto__.push((arguments[i__5770__auto___29480]));

var G__29481 = (i__5770__auto___29480 + (1));
i__5770__auto___29480 = G__29481;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29478){var e = e29478;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq29477){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29477));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29484 = arguments.length;
var i__5770__auto___29485 = (0);
while(true){
if((i__5770__auto___29485 < len__5769__auto___29484)){
args__5775__auto__.push((arguments[i__5770__auto___29485]));

var G__29486 = (i__5770__auto___29485 + (1));
i__5770__auto___29485 = G__29486;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e29483){var e = e29483;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq29482){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29482));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29489 = arguments.length;
var i__5770__auto___29490 = (0);
while(true){
if((i__5770__auto___29490 < len__5769__auto___29489)){
args__5775__auto__.push((arguments[i__5770__auto___29490]));

var G__29491 = (i__5770__auto___29490 + (1));
i__5770__auto___29490 = G__29491;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e29488){var e = e29488;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq29487){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29487));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29494 = arguments.length;
var i__5770__auto___29495 = (0);
while(true){
if((i__5770__auto___29495 < len__5769__auto___29494)){
args__5775__auto__.push((arguments[i__5770__auto___29495]));

var G__29496 = (i__5770__auto___29495 + (1));
i__5770__auto___29495 = G__29496;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e29493){var e = e29493;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq29492){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29492));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29499 = arguments.length;
var i__5770__auto___29500 = (0);
while(true){
if((i__5770__auto___29500 < len__5769__auto___29499)){
args__5775__auto__.push((arguments[i__5770__auto___29500]));

var G__29501 = (i__5770__auto___29500 + (1));
i__5770__auto___29500 = G__29501;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e29498){var e = e29498;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq29497){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29497));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29504 = arguments.length;
var i__5770__auto___29505 = (0);
while(true){
if((i__5770__auto___29505 < len__5769__auto___29504)){
args__5775__auto__.push((arguments[i__5770__auto___29505]));

var G__29506 = (i__5770__auto___29505 + (1));
i__5770__auto___29505 = G__29506;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e29503){var e = e29503;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq29502){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29502));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__29508 = arguments.length;
switch (G__29508) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29536){
var state_val_29537 = (state_29536[(1)]);
if((state_val_29537 === (7))){
var inst_29521 = (state_29536[(7)]);
var inst_29524 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29521,"query",query_map);
var state_29536__$1 = state_29536;
var statearr_29538_29624 = state_29536__$1;
(statearr_29538_29624[(2)] = inst_29524);

(statearr_29538_29624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29537 === (1))){
var state_29536__$1 = state_29536;
var statearr_29539_29625 = state_29536__$1;
(statearr_29539_29625[(2)] = null);

(statearr_29539_29625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29537 === (4))){
var inst_29509 = (state_29536[(2)]);
var state_29536__$1 = state_29536;
var statearr_29540_29626 = state_29536__$1;
(statearr_29540_29626[(2)] = inst_29509);

(statearr_29540_29626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29537 === (6))){
var inst_29521 = (state_29536[(7)]);
var inst_29521__$1 = (state_29536[(2)]);
var inst_29522 = fluree.db.util.core.exception_QMARK_.call(null,inst_29521__$1);
var state_29536__$1 = (function (){var statearr_29541 = state_29536;
(statearr_29541[(7)] = inst_29521__$1);

return statearr_29541;
})();
if(inst_29522){
var statearr_29542_29627 = state_29536__$1;
(statearr_29542_29627[(1)] = (7));

} else {
var statearr_29543_29628 = state_29536__$1;
(statearr_29543_29628[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29537 === (3))){
var inst_29534 = (state_29536[(2)]);
var state_29536__$1 = state_29536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29536__$1,inst_29534);
} else {
if((state_val_29537 === (2))){
var inst_29515 = (state_29536[(8)]);
var _ = (function (){var statearr_29545 = state_29536;
(statearr_29545[(4)] = cljs.core.cons.call(null,(5),(state_29536[(4)])));

return statearr_29545;
})();
var inst_29515__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_29516 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_29517 = cljs.core.assoc.call(null,inst_29516,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_29515__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_29518 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_29517);
var inst_29519 = fluree.db.query.fql.query.call(null,db,inst_29518);
var state_29536__$1 = (function (){var statearr_29546 = state_29536;
(statearr_29546[(8)] = inst_29515__$1);

return statearr_29546;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29536__$1,(6),inst_29519);
} else {
if((state_val_29537 === (9))){
var inst_29531 = (state_29536[(2)]);
var _ = (function (){var statearr_29547 = state_29536;
(statearr_29547[(4)] = cljs.core.rest.call(null,(state_29536[(4)])));

return statearr_29547;
})();
var state_29536__$1 = state_29536;
var statearr_29548_29629 = state_29536__$1;
(statearr_29548_29629[(2)] = inst_29531);

(statearr_29548_29629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29537 === (5))){
var _ = (function (){var statearr_29549 = state_29536;
(statearr_29549[(4)] = cljs.core.rest.call(null,(state_29536[(4)])));

return statearr_29549;
})();
var state_29536__$1 = state_29536;
var ex29544 = (state_29536__$1[(2)]);
var statearr_29550_29630 = state_29536__$1;
(statearr_29550_29630[(5)] = ex29544);


if((ex29544 instanceof Error)){
var statearr_29551_29631 = state_29536__$1;
(statearr_29551_29631[(1)] = (4));

(statearr_29551_29631[(5)] = null);

} else {
throw ex29544;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29537 === (8))){
var inst_29521 = (state_29536[(7)]);
var inst_29515 = (state_29536[(8)]);
var inst_29526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29527 = cljs.core.deref.call(null,inst_29515);
var inst_29528 = [inst_29521,inst_29527];
var inst_29529 = (new cljs.core.PersistentVector(null,2,(5),inst_29526,inst_29528,null));
var state_29536__$1 = state_29536;
var statearr_29552_29632 = state_29536__$1;
(statearr_29552_29632[(2)] = inst_29529);

(statearr_29552_29632[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_29553 = [null,null,null,null,null,null,null,null,null];
(statearr_29553[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_29553[(1)] = (1));

return statearr_29553;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_29536){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29554){var ex__2749__auto__ = e29554;
var statearr_29555_29633 = state_29536;
(statearr_29555_29633[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29536[(4)]))){
var statearr_29556_29634 = state_29536;
(statearr_29556_29634[(1)] = cljs.core.first.call(null,(state_29536[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29635 = state_29536;
state_29536 = G__29635;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_29536){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_29536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29557 = f__2769__auto__.call(null);
(statearr_29557[(6)] = c__2768__auto__);

return statearr_29557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29602){
var state_val_29603 = (state_29602[(1)]);
if((state_val_29603 === (7))){
var inst_29588 = (state_29602[(2)]);
var inst_29589 = fluree.db.query.fql.query.call(null,db,inst_29588);
var state_29602__$1 = state_29602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29602__$1,(8),inst_29589);
} else {
if((state_val_29603 === (1))){
var inst_29558 = typeof select === 'string';
var state_29602__$1 = state_29602;
if(cljs.core.truth_(inst_29558)){
var statearr_29604_29636 = state_29602__$1;
(statearr_29604_29636[(1)] = (2));

} else {
var statearr_29605_29637 = state_29602__$1;
(statearr_29605_29637[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (4))){
var inst_29564 = (state_29602[(7)]);
var inst_29571 = (state_29602[(8)]);
var inst_29563 = (state_29602[(2)]);
var inst_29564__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_29565 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29566 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_29567 = [inst_29564__$1,(100000)];
var inst_29568 = cljs.core.PersistentHashMap.fromArrays(inst_29566,inst_29567);
var inst_29569 = [inst_29563,from,where,block,limit,inst_29568];
var inst_29570 = cljs.core.PersistentHashMap.fromArrays(inst_29565,inst_29569);
var inst_29571__$1 = fluree.db.util.core.without_nils.call(null,inst_29570);
var inst_29572 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29571__$1);
var inst_29573 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29571__$1);
var inst_29574 = cljs.core.first.call(null,inst_29573);
var inst_29575 = fluree.db.dbfunctions.internal.str.call(null,inst_29574);
var inst_29576 = cljs.core._EQ_.call(null,"[",inst_29575);
var inst_29577 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29571__$1);
var inst_29578 = cljs.core.last.call(null,inst_29577);
var inst_29579 = fluree.db.dbfunctions.internal.str.call(null,inst_29578);
var inst_29580 = cljs.core._EQ_.call(null,"]",inst_29579);
var inst_29581 = fluree.db.dbfunctions.internal.and.call(null,inst_29572,inst_29576,inst_29580);
var state_29602__$1 = (function (){var statearr_29606 = state_29602;
(statearr_29606[(7)] = inst_29564__$1);

(statearr_29606[(8)] = inst_29571__$1);

return statearr_29606;
})();
if(cljs.core.truth_(inst_29581)){
var statearr_29607_29638 = state_29602__$1;
(statearr_29607_29638[(1)] = (5));

} else {
var statearr_29608_29639 = state_29602__$1;
(statearr_29608_29639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (6))){
var inst_29571 = (state_29602[(8)]);
var state_29602__$1 = state_29602;
var statearr_29609_29640 = state_29602__$1;
(statearr_29609_29640[(2)] = inst_29571);

(statearr_29609_29640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (3))){
var state_29602__$1 = state_29602;
var statearr_29610_29641 = state_29602__$1;
(statearr_29610_29641[(2)] = select);

(statearr_29610_29641[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (2))){
var inst_29560 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_29602__$1 = state_29602;
var statearr_29611_29642 = state_29602__$1;
(statearr_29611_29642[(2)] = inst_29560);

(statearr_29611_29642[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (11))){
var inst_29600 = (state_29602[(2)]);
var state_29602__$1 = state_29602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29602__$1,inst_29600);
} else {
if((state_val_29603 === (9))){
var inst_29591 = (state_29602[(9)]);
var state_29602__$1 = state_29602;
var statearr_29612_29643 = state_29602__$1;
(statearr_29612_29643[(2)] = inst_29591);

(statearr_29612_29643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (5))){
var inst_29571 = (state_29602[(8)]);
var inst_29583 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29571);
var inst_29584 = cljs.reader.read_string.call(null,inst_29583);
var inst_29585 = cljs.core.assoc.call(null,inst_29571,new cljs.core.Keyword(null,"where","where",-2044795965),inst_29584);
var state_29602__$1 = state_29602;
var statearr_29613_29644 = state_29602__$1;
(statearr_29613_29644[(2)] = inst_29585);

(statearr_29613_29644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (10))){
var inst_29564 = (state_29602[(7)]);
var inst_29591 = (state_29602[(9)]);
var inst_29595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29596 = cljs.core.deref.call(null,inst_29564);
var inst_29597 = [inst_29591,inst_29596];
var inst_29598 = (new cljs.core.PersistentVector(null,2,(5),inst_29595,inst_29597,null));
var state_29602__$1 = state_29602;
var statearr_29614_29645 = state_29602__$1;
(statearr_29614_29645[(2)] = inst_29598);

(statearr_29614_29645[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29603 === (8))){
var inst_29591 = (state_29602[(9)]);
var inst_29591__$1 = (state_29602[(2)]);
var inst_29592 = fluree.db.util.core.exception_QMARK_.call(null,inst_29591__$1);
var state_29602__$1 = (function (){var statearr_29615 = state_29602;
(statearr_29615[(9)] = inst_29591__$1);

return statearr_29615;
})();
if(inst_29592){
var statearr_29616_29646 = state_29602__$1;
(statearr_29616_29646[(1)] = (9));

} else {
var statearr_29617_29647 = state_29602__$1;
(statearr_29617_29647[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_29618 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29618[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_29618[(1)] = (1));

return statearr_29618;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_29602){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29619){var ex__2749__auto__ = e29619;
var statearr_29620_29648 = state_29602;
(statearr_29620_29648[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29602[(4)]))){
var statearr_29621_29649 = state_29602;
(statearr_29621_29649[(1)] = cljs.core.first.call(null,(state_29602[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29650 = state_29602;
state_29602 = G__29650;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_29602){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_29602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29622 = f__2769__auto__.call(null);
(statearr_29622[(6)] = c__2768__auto__);

return statearr_29622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__29654 = path;
var vec__29655 = G__29654;
var seq__29656 = cljs.core.seq.call(null,vec__29655);
var first__29657 = cljs.core.first.call(null,seq__29656);
var seq__29656__$1 = cljs.core.next.call(null,seq__29656);
var var$ = first__29657;
var r = seq__29656__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__29654__$1 = G__29654;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__29661 = G__29654__$1;
var seq__29662 = cljs.core.seq.call(null,vec__29661);
var first__29663 = cljs.core.first.call(null,seq__29662);
var seq__29662__$1 = cljs.core.next.call(null,seq__29662);
var var$__$1 = first__29663;
var r__$1 = seq__29662__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__29664 = r__$1;
var G__29665 = n__$2;
var G__29666 = next_clauses;
G__29654__$1 = G__29664;
n__$1 = G__29665;
where_clauses__$1 = G__29666;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__29667 = r__$1;
var G__29668 = next_n;
var G__29669 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__29654__$1 = G__29667;
n__$1 = G__29668;
where_clauses__$1 = G__29669;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29706){
var state_val_29707 = (state_29706[(1)]);
if((state_val_29707 === (7))){
var inst_29679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29680 = [path];
var inst_29681 = (new cljs.core.PersistentVector(null,1,(5),inst_29679,inst_29680,null));
var state_29706__$1 = state_29706;
var statearr_29708_29736 = state_29706__$1;
(statearr_29708_29736[(2)] = inst_29681);

(statearr_29708_29736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (1))){
var state_29706__$1 = state_29706;
var statearr_29709_29737 = state_29706__$1;
(statearr_29709_29737[(2)] = null);

(statearr_29709_29737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (4))){
var inst_29670 = (state_29706[(2)]);
var state_29706__$1 = state_29706;
var statearr_29710_29738 = state_29706__$1;
(statearr_29710_29738[(2)] = inst_29670);

(statearr_29710_29738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (13))){
var inst_29697 = (state_29706[(2)]);
var inst_29698 = fluree.db.util.async.throw_err.call(null,inst_29697);
var _ = (function (){var statearr_29711 = state_29706;
(statearr_29711[(4)] = cljs.core.rest.call(null,(state_29706[(4)])));

return statearr_29711;
})();
var state_29706__$1 = state_29706;
var statearr_29712_29739 = state_29706__$1;
(statearr_29712_29739[(2)] = inst_29698);

(statearr_29712_29739[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (6))){
var state_29706__$1 = state_29706;
var statearr_29714_29740 = state_29706__$1;
(statearr_29714_29740[(2)] = path);

(statearr_29714_29740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (3))){
var inst_29704 = (state_29706[(2)]);
var state_29706__$1 = state_29706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29706__$1,inst_29704);
} else {
if((state_val_29707 === (12))){
var _ = (function (){var statearr_29715 = state_29706;
(statearr_29715[(4)] = cljs.core.rest.call(null,(state_29706[(4)])));

return statearr_29715;
})();
var state_29706__$1 = state_29706;
var ex29713 = (state_29706__$1[(2)]);
var statearr_29716_29741 = state_29706__$1;
(statearr_29716_29741[(5)] = ex29713);


var statearr_29717_29742 = state_29706__$1;
(statearr_29717_29742[(1)] = (11));

(statearr_29717_29742[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (2))){
var _ = (function (){var statearr_29718 = state_29706;
(statearr_29718[(4)] = cljs.core.cons.call(null,(5),(state_29706[(4)])));

return statearr_29718;
})();
var inst_29676 = cljs.core.vector_QMARK_.call(null,path);
var state_29706__$1 = state_29706;
if(inst_29676){
var statearr_29719_29743 = state_29706__$1;
(statearr_29719_29743[(1)] = (6));

} else {
var statearr_29720_29744 = state_29706__$1;
(statearr_29720_29744[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (11))){
var inst_29683 = (state_29706[(7)]);
var inst_29688 = (state_29706[(2)]);
var inst_29689 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29688,"relationship?",startSubject,inst_29683,endSubject);
var state_29706__$1 = state_29706;
var statearr_29722_29745 = state_29706__$1;
(statearr_29722_29745[(2)] = inst_29689);

(statearr_29722_29745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (9))){
var inst_29687 = (state_29706[(8)]);
var _ = (function (){var statearr_29723 = state_29706;
(statearr_29723[(4)] = cljs.core.cons.call(null,(12),(state_29706[(4)])));

return statearr_29723;
})();
var inst_29695 = fluree.db.dbfunctions.internal.query.call(null,db,inst_29687);
var state_29706__$1 = state_29706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29706__$1,(13),inst_29695);
} else {
if((state_val_29707 === (5))){
var _ = (function (){var statearr_29724 = state_29706;
(statearr_29724[(4)] = cljs.core.rest.call(null,(state_29706[(4)])));

return statearr_29724;
})();
var state_29706__$1 = state_29706;
var ex29721 = (state_29706__$1[(2)]);
var statearr_29725_29746 = state_29706__$1;
(statearr_29725_29746[(5)] = ex29721);


if((ex29721 instanceof Error)){
var statearr_29726_29747 = state_29706__$1;
(statearr_29726_29747[(1)] = (4));

(statearr_29726_29747[(5)] = null);

} else {
throw ex29721;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (10))){
var inst_29701 = (state_29706[(2)]);
var _ = (function (){var statearr_29727 = state_29706;
(statearr_29727[(4)] = cljs.core.rest.call(null,(state_29706[(4)])));

return statearr_29727;
})();
var state_29706__$1 = state_29706;
var statearr_29728_29748 = state_29706__$1;
(statearr_29728_29748[(2)] = inst_29701);

(statearr_29728_29748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29707 === (8))){
var inst_29683 = (state_29706[(7)]);
var inst_29683__$1 = (state_29706[(2)]);
var inst_29684 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_29683__$1,endSubject);
var inst_29685 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_29686 = ["?var1",inst_29684];
var inst_29687 = cljs.core.PersistentHashMap.fromArrays(inst_29685,inst_29686);
var state_29706__$1 = (function (){var statearr_29729 = state_29706;
(statearr_29729[(8)] = inst_29687);

(statearr_29729[(7)] = inst_29683__$1);

return statearr_29729;
})();
var statearr_29730_29749 = state_29706__$1;
(statearr_29730_29749[(2)] = null);

(statearr_29730_29749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_29731 = [null,null,null,null,null,null,null,null,null];
(statearr_29731[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_29731[(1)] = (1));

return statearr_29731;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_29706){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29732){var ex__2749__auto__ = e29732;
var statearr_29733_29750 = state_29706;
(statearr_29733_29750[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29706[(4)]))){
var statearr_29734_29751 = state_29706;
(statearr_29734_29751[(1)] = cljs.core.first.call(null,(state_29706[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29752 = state_29706;
state_29706 = G__29752;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = function(state_29706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_29706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29735 = f__2769__auto__.call(null);
(statearr_29735[(6)] = c__2768__auto__);

return statearr_29735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e29753){var e = e29753;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e29754){var e = e29754;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e29755){var e = e29755;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e29756){var e = e29756;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29759 = arguments.length;
var i__5770__auto___29760 = (0);
while(true){
if((i__5770__auto___29760 < len__5769__auto___29759)){
args__5775__auto__.push((arguments[i__5770__auto___29760]));

var G__29761 = (i__5770__auto___29760 + (1));
i__5770__auto___29760 = G__29761;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e29758){var e = e29758;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq29757){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29757));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29764 = arguments.length;
var i__5770__auto___29765 = (0);
while(true){
if((i__5770__auto___29765 < len__5769__auto___29764)){
args__5775__auto__.push((arguments[i__5770__auto___29765]));

var G__29766 = (i__5770__auto___29765 + (1));
i__5770__auto___29765 = G__29766;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e29763){var e = e29763;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq29762){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29762));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29769 = arguments.length;
var i__5770__auto___29770 = (0);
while(true){
if((i__5770__auto___29770 < len__5769__auto___29769)){
args__5775__auto__.push((arguments[i__5770__auto___29770]));

var G__29771 = (i__5770__auto___29770 + (1));
i__5770__auto___29770 = G__29771;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e29768){var e = e29768;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq29767){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29767));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29774 = arguments.length;
var i__5770__auto___29775 = (0);
while(true){
if((i__5770__auto___29775 < len__5769__auto___29774)){
args__5775__auto__.push((arguments[i__5770__auto___29775]));

var G__29776 = (i__5770__auto___29775 + (1));
i__5770__auto___29775 = G__29776;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e29773){var e = e29773;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq29772){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29772));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e29777){var e = e29777;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e29778){var e = e29778;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e29779){var e = e29779;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e29780){var e = e29780;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e29781){var e = e29781;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__29787 = path;
var vec__29788 = G__29787;
var seq__29789 = cljs.core.seq.call(null,vec__29788);
var first__29790 = cljs.core.first.call(null,seq__29789);
var seq__29789__$1 = cljs.core.next.call(null,seq__29789);
var pred = first__29790;
var r = seq__29789__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__29787__$1 = G__29787;
var subjects__$1 = subjects;
while(true){
var vec__29794 = G__29787__$1;
var seq__29795 = cljs.core.seq.call(null,vec__29794);
var first__29796 = cljs.core.first.call(null,seq__29795);
var seq__29795__$1 = cljs.core.next.call(null,seq__29795);
var pred__$1 = first__29796;
var r__$1 = seq__29795__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__29787__$1,subjects__$1,vec__29794,seq__29795,first__29796,seq__29795__$1,pred__$1,r__$1,subjects__$2,G__29787,vec__29788,seq__29789,first__29790,seq__29789__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__29787__$1,subjects__$1,vec__29794,seq__29795,first__29796,seq__29795__$1,pred__$1,r__$1,subjects__$2,G__29787,vec__29788,seq__29789,first__29790,seq__29789__$1,pred,r,subjects){
return (function (p1__29782_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__29782_SHARP_,pred__$1);
});})(G__29787__$1,subjects__$1,vec__29794,seq__29795,first__29796,seq__29795__$1,pred__$1,r__$1,subjects__$2,G__29787,vec__29788,seq__29789,first__29790,seq__29789__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__29787__$1,subjects__$1,vec__29794,seq__29795,first__29796,seq__29795__$1,pred__$1,r__$1,subjects__$2,G__29787,vec__29788,seq__29789,first__29790,seq__29789__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__29797 = r__$1;
var G__29798 = next_subjects;
G__29787__$1 = G__29797;
subjects__$1 = G__29798;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e29783){var e = e29783;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e29799){var e = e29799;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e29800){var e = e29800;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29803 = arguments.length;
var i__5770__auto___29804 = (0);
while(true){
if((i__5770__auto___29804 < len__5769__auto___29803)){
args__5775__auto__.push((arguments[i__5770__auto___29804]));

var G__29805 = (i__5770__auto___29804 + (1));
i__5770__auto___29804 = G__29805;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e29802){var e = e29802;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq29801){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29801));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e29806){var e = e29806;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29809 = arguments.length;
var i__5770__auto___29810 = (0);
while(true){
if((i__5770__auto___29810 < len__5769__auto___29809)){
args__5775__auto__.push((arguments[i__5770__auto___29810]));

var G__29811 = (i__5770__auto___29810 + (1));
i__5770__auto___29810 = G__29811;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e29808){var e = e29808;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq29807){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29807));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e29812){var e = e29812;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29869){
var state_val_29870 = (state_29869[(1)]);
if((state_val_29870 === (7))){
var inst_29815 = (state_29869[(2)]);
var state_29869__$1 = state_29869;
var statearr_29871_29905 = state_29869__$1;
(statearr_29871_29905[(2)] = inst_29815);

(statearr_29871_29905[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (1))){
var state_29869__$1 = state_29869;
var statearr_29872_29906 = state_29869__$1;
(statearr_29872_29906[(2)] = null);

(statearr_29872_29906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (4))){
var inst_29814 = (state_29869[(2)]);
var state_29869__$1 = (function (){var statearr_29873 = state_29869;
(statearr_29873[(7)] = inst_29814);

return statearr_29873;
})();
var statearr_29874_29907 = state_29869__$1;
(statearr_29874_29907[(2)] = null);

(statearr_29874_29907[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (15))){
var inst_29850 = (state_29869[(8)]);
var inst_29837 = (state_29869[(9)]);
var inst_29839 = (state_29869[(10)]);
var inst_29849 = (state_29869[(11)]);
var inst_29852 = (state_29869[(12)]);
var inst_29840 = (state_29869[(13)]);
var inst_29856 = (function (){var db = inst_29837;
var prevT = inst_29839;
var db_SINGLEQUOTE_ = inst_29840;
var prev_vals = inst_29849;
var fuel = inst_29850;
var G__29851 = inst_29852;
return (function (p1__29813_SHARP_){
var f = p1__29813_SHARP_;
return f.o;
});
})();
var inst_29857 = inst_29856.call(null,inst_29852);
var state_29869__$1 = state_29869;
var statearr_29875_29908 = state_29869__$1;
(statearr_29875_29908[(2)] = inst_29857);

(statearr_29875_29908[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (13))){
var inst_29849 = (state_29869[(11)]);
var inst_29852 = (state_29869[(12)]);
var inst_29848 = (state_29869[(2)]);
var inst_29849__$1 = fluree.db.util.async.throw_err.call(null,inst_29848);
var inst_29850 = fluree.db.dbfunctions.internal.count.call(null,inst_29849__$1);
var inst_29852__$1 = cljs.core.first.call(null,inst_29849__$1);
var inst_29853 = (inst_29852__$1 == null);
var state_29869__$1 = (function (){var statearr_29876 = state_29869;
(statearr_29876[(8)] = inst_29850);

(statearr_29876[(11)] = inst_29849__$1);

(statearr_29876[(12)] = inst_29852__$1);

return statearr_29876;
})();
if(cljs.core.truth_(inst_29853)){
var statearr_29877_29909 = state_29869__$1;
(statearr_29877_29909[(1)] = (14));

} else {
var statearr_29878_29910 = state_29869__$1;
(statearr_29878_29910[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (6))){
var inst_29824 = (state_29869[(2)]);
var state_29869__$1 = state_29869;
var statearr_29879_29911 = state_29869__$1;
(statearr_29879_29911[(2)] = inst_29824);

(statearr_29879_29911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (3))){
var inst_29867 = (state_29869[(2)]);
var state_29869__$1 = state_29869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29869__$1,inst_29867);
} else {
if((state_val_29870 === (12))){
var inst_29864 = (state_29869[(2)]);
var _ = (function (){var statearr_29880 = state_29869;
(statearr_29880[(4)] = cljs.core.rest.call(null,(state_29869[(4)])));

return statearr_29880;
})();
var state_29869__$1 = state_29869;
var statearr_29881_29912 = state_29869__$1;
(statearr_29881_29912[(2)] = inst_29864);

(statearr_29881_29912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (2))){
var _ = (function (){var statearr_29883 = state_29869;
(statearr_29883[(4)] = cljs.core.cons.call(null,(9),(state_29869[(4)])));

return statearr_29883;
})();
var inst_29830 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29831 = typeof inst_29830 === 'string';
var state_29869__$1 = state_29869;
if(cljs.core.truth_(inst_29831)){
var statearr_29884_29913 = state_29869__$1;
(statearr_29884_29913[(1)] = (10));

} else {
var statearr_29885_29914 = state_29869__$1;
(statearr_29885_29914[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (11))){
var inst_29837 = (state_29869[(9)]);
var inst_29839 = (state_29869[(10)]);
var inst_29840 = (state_29869[(13)]);
var inst_29837__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29838 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_29837__$1);
var inst_29839__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_29838);
var inst_29840__$1 = cljs.core.assoc.call(null,inst_29837__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_29839__$1);
var inst_29841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29842 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29843 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29844 = [inst_29842,inst_29843];
var inst_29845 = (new cljs.core.PersistentVector(null,2,(5),inst_29841,inst_29844,null));
var inst_29846 = fluree.db.dbproto._search.call(null,inst_29840__$1,inst_29845);
var state_29869__$1 = (function (){var statearr_29886 = state_29869;
(statearr_29886[(9)] = inst_29837__$1);

(statearr_29886[(10)] = inst_29839__$1);

(statearr_29886[(13)] = inst_29840__$1);

return statearr_29886;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29869__$1,(13),inst_29846);
} else {
if((state_val_29870 === (9))){
var _ = (function (){var statearr_29887 = state_29869;
(statearr_29887[(4)] = cljs.core.rest.call(null,(state_29869[(4)])));

return statearr_29887;
})();
var state_29869__$1 = state_29869;
var ex29882 = (state_29869__$1[(2)]);
var statearr_29888_29915 = state_29869__$1;
(statearr_29888_29915[(5)] = ex29882);


var statearr_29889_29916 = state_29869__$1;
(statearr_29889_29916[(1)] = (4));

(statearr_29889_29916[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (5))){
var inst_29814 = (state_29869[(7)]);
var _ = (function (){var statearr_29890 = state_29869;
(statearr_29890[(4)] = cljs.core.cons.call(null,(8),(state_29869[(4)])));

return statearr_29890;
})();
var inst_29821 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29814,"?pO","Context Object");
var ___$1 = (function (){var statearr_29891 = state_29869;
(statearr_29891[(4)] = cljs.core.rest.call(null,(state_29869[(4)])));

return statearr_29891;
})();
var state_29869__$1 = state_29869;
var statearr_29892_29917 = state_29869__$1;
(statearr_29892_29917[(2)] = inst_29821);

(statearr_29892_29917[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (14))){
var state_29869__$1 = state_29869;
var statearr_29893_29918 = state_29869__$1;
(statearr_29893_29918[(2)] = null);

(statearr_29893_29918[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (16))){
var inst_29850 = (state_29869[(8)]);
var inst_29859 = (state_29869[(2)]);
var inst_29860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29861 = [inst_29859,inst_29850];
var inst_29862 = (new cljs.core.PersistentVector(null,2,(5),inst_29860,inst_29861,null));
var state_29869__$1 = state_29869;
var statearr_29895_29919 = state_29869__$1;
(statearr_29895_29919[(2)] = inst_29862);

(statearr_29895_29919[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (10))){
var inst_29833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29834 = [null,(0)];
var inst_29835 = (new cljs.core.PersistentVector(null,2,(5),inst_29833,inst_29834,null));
var state_29869__$1 = state_29869;
var statearr_29896_29920 = state_29869__$1;
(statearr_29896_29920[(2)] = inst_29835);

(statearr_29896_29920[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (8))){
var _ = (function (){var statearr_29897 = state_29869;
(statearr_29897[(4)] = cljs.core.rest.call(null,(state_29869[(4)])));

return statearr_29897;
})();
var state_29869__$1 = state_29869;
var ex29894 = (state_29869__$1[(2)]);
var statearr_29898_29921 = state_29869__$1;
(statearr_29898_29921[(5)] = ex29894);


var statearr_29899_29922 = state_29869__$1;
(statearr_29899_29922[(1)] = (7));

(statearr_29899_29922[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_29900 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29900[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_29900[(1)] = (1));

return statearr_29900;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_29869){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29901){var ex__2749__auto__ = e29901;
var statearr_29902_29923 = state_29869;
(statearr_29902_29923[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29869[(4)]))){
var statearr_29903_29924 = state_29869;
(statearr_29903_29924[(1)] = cljs.core.first.call(null,(state_29869[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29925 = state_29869;
state_29869 = G__29925;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = function(state_29869){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_29869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29904 = f__2769__auto__.call(null);
(statearr_29904[(6)] = c__2768__auto__);

return statearr_29904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29977){
var state_val_29978 = (state_29977[(1)]);
if((state_val_29978 === (7))){
var inst_29927 = (state_29977[(2)]);
var state_29977__$1 = state_29977;
var statearr_29979_30008 = state_29977__$1;
(statearr_29979_30008[(2)] = inst_29927);

(statearr_29979_30008[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (1))){
var state_29977__$1 = state_29977;
var statearr_29980_30009 = state_29977__$1;
(statearr_29980_30009[(2)] = null);

(statearr_29980_30009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (4))){
var inst_29926 = (state_29977[(2)]);
var state_29977__$1 = (function (){var statearr_29981 = state_29977;
(statearr_29981[(7)] = inst_29926);

return statearr_29981;
})();
var statearr_29982_30010 = state_29977__$1;
(statearr_29982_30010[(2)] = null);

(statearr_29982_30010[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (13))){
var inst_29972 = (state_29977[(2)]);
var _ = (function (){var statearr_29983 = state_29977;
(statearr_29983[(4)] = cljs.core.rest.call(null,(state_29977[(4)])));

return statearr_29983;
})();
var state_29977__$1 = state_29977;
var statearr_29984_30011 = state_29977__$1;
(statearr_29984_30011[(2)] = inst_29972);

(statearr_29984_30011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (6))){
var inst_29936 = (state_29977[(2)]);
var state_29977__$1 = state_29977;
var statearr_29985_30012 = state_29977__$1;
(statearr_29985_30012[(2)] = inst_29936);

(statearr_29985_30012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (3))){
var inst_29975 = (state_29977[(2)]);
var state_29977__$1 = state_29977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29977__$1,inst_29975);
} else {
if((state_val_29978 === (12))){
var inst_29959 = (state_29977[(8)]);
var inst_29968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29969 = [null,inst_29959];
var inst_29970 = (new cljs.core.PersistentVector(null,2,(5),inst_29968,inst_29969,null));
var state_29977__$1 = state_29977;
var statearr_29986_30013 = state_29977__$1;
(statearr_29986_30013[(2)] = inst_29970);

(statearr_29986_30013[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (2))){
var _ = (function (){var statearr_29988 = state_29977;
(statearr_29988[(4)] = cljs.core.cons.call(null,(9),(state_29977[(4)])));

return statearr_29988;
})();
var inst_29945 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29948 = [null,pred_name,"?o"];
var inst_29949 = (new cljs.core.PersistentVector(null,3,(5),inst_29947,inst_29948,null));
var inst_29950 = [inst_29949];
var inst_29951 = (new cljs.core.PersistentVector(null,1,(5),inst_29946,inst_29950,null));
var inst_29952 = ["?o",inst_29951,opts];
var inst_29953 = cljs.core.PersistentHashMap.fromArrays(inst_29945,inst_29952);
var inst_29954 = fluree.db.dbfunctions.internal.query.call(null,db,inst_29953);
var state_29977__$1 = state_29977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29977__$1,(10),inst_29954);
} else {
if((state_val_29978 === (11))){
var inst_29959 = (state_29977[(8)]);
var inst_29958 = (state_29977[(9)]);
var inst_29963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29964 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_29958);
var inst_29965 = [inst_29964,inst_29959];
var inst_29966 = (new cljs.core.PersistentVector(null,2,(5),inst_29963,inst_29965,null));
var state_29977__$1 = state_29977;
var statearr_29989_30014 = state_29977__$1;
(statearr_29989_30014[(2)] = inst_29966);

(statearr_29989_30014[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (9))){
var _ = (function (){var statearr_29990 = state_29977;
(statearr_29990[(4)] = cljs.core.rest.call(null,(state_29977[(4)])));

return statearr_29990;
})();
var state_29977__$1 = state_29977;
var ex29987 = (state_29977__$1[(2)]);
var statearr_29991_30015 = state_29977__$1;
(statearr_29991_30015[(5)] = ex29987);


var statearr_29992_30016 = state_29977__$1;
(statearr_29992_30016[(1)] = (4));

(statearr_29992_30016[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (5))){
var inst_29926 = (state_29977[(7)]);
var _ = (function (){var statearr_29994 = state_29977;
(statearr_29994[(4)] = cljs.core.cons.call(null,(8),(state_29977[(4)])));

return statearr_29994;
})();
var inst_29933 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29926,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_29995 = state_29977;
(statearr_29995[(4)] = cljs.core.rest.call(null,(state_29977[(4)])));

return statearr_29995;
})();
var state_29977__$1 = state_29977;
var statearr_29996_30017 = state_29977__$1;
(statearr_29996_30017[(2)] = inst_29933);

(statearr_29996_30017[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (10))){
var inst_29958 = (state_29977[(9)]);
var inst_29956 = (state_29977[(2)]);
var inst_29957 = fluree.db.util.async.throw_err.call(null,inst_29956);
var inst_29958__$1 = cljs.core.nth.call(null,inst_29957,(0),null);
var inst_29959 = cljs.core.nth.call(null,inst_29957,(1),null);
var inst_29960 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_29958__$1);
var inst_29961 = cljs.core.not.call(null,inst_29960);
var state_29977__$1 = (function (){var statearr_29997 = state_29977;
(statearr_29997[(8)] = inst_29959);

(statearr_29997[(9)] = inst_29958__$1);

return statearr_29997;
})();
if(inst_29961){
var statearr_29998_30018 = state_29977__$1;
(statearr_29998_30018[(1)] = (11));

} else {
var statearr_29999_30019 = state_29977__$1;
(statearr_29999_30019[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29978 === (8))){
var _ = (function (){var statearr_30000 = state_29977;
(statearr_30000[(4)] = cljs.core.rest.call(null,(state_29977[(4)])));

return statearr_30000;
})();
var state_29977__$1 = state_29977;
var ex29993 = (state_29977__$1[(2)]);
var statearr_30001_30020 = state_29977__$1;
(statearr_30001_30020[(5)] = ex29993);


var statearr_30002_30021 = state_29977__$1;
(statearr_30002_30021[(1)] = (7));

(statearr_30002_30021[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_30003 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30003[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__);

(statearr_30003[(1)] = (1));

return statearr_30003;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1 = (function (state_29977){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e30004){var ex__2749__auto__ = e30004;
var statearr_30005_30022 = state_29977;
(statearr_30005_30022[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29977[(4)]))){
var statearr_30006_30023 = state_29977;
(statearr_30006_30023[(1)] = cljs.core.first.call(null,(state_29977[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30024 = state_29977;
state_29977 = G__30024;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = function(state_29977){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1.call(this,state_29977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_30007 = f__2769__auto__.call(null);
(statearr_30007[(6)] = c__2768__auto__);

return statearr_30007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e30025){var e = e30025;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__30027 = arguments.length;
switch (G__30027) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_30097){
var state_val_30098 = (state_30097[(1)]);
if((state_val_30098 === (7))){
var inst_30029 = (state_30097[(2)]);
var state_30097__$1 = state_30097;
var statearr_30099_30143 = state_30097__$1;
(statearr_30099_30143[(2)] = inst_30029);

(statearr_30099_30143[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (20))){
var inst_30073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30074 = ["*"];
var inst_30075 = (new cljs.core.PersistentVector(null,1,(5),inst_30073,inst_30074,null));
var state_30097__$1 = state_30097;
var statearr_30100_30144 = state_30097__$1;
(statearr_30100_30144[(2)] = inst_30075);

(statearr_30100_30144[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (1))){
var state_30097__$1 = state_30097;
var statearr_30101_30145 = state_30097__$1;
(statearr_30101_30145[(2)] = null);

(statearr_30101_30145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (4))){
var inst_30028 = (state_30097[(2)]);
var state_30097__$1 = (function (){var statearr_30102 = state_30097;
(statearr_30102[(7)] = inst_30028);

return statearr_30102;
})();
var statearr_30103_30146 = state_30097__$1;
(statearr_30103_30146[(2)] = null);

(statearr_30103_30146[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (15))){
var inst_30092 = (state_30097[(2)]);
var _ = (function (){var statearr_30104 = state_30097;
(statearr_30104[(4)] = cljs.core.rest.call(null,(state_30097[(4)])));

return statearr_30104;
})();
var state_30097__$1 = state_30097;
var statearr_30105_30147 = state_30097__$1;
(statearr_30105_30147[(2)] = inst_30092);

(statearr_30105_30147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (21))){
var inst_30063 = (state_30097[(8)]);
var inst_30056 = (state_30097[(9)]);
var inst_30077 = (state_30097[(2)]);
var inst_30078 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30079 = cljs.core.PersistentHashMap.EMPTY;
var inst_30080 = [inst_30077,inst_30063,inst_30079];
var inst_30081 = cljs.core.PersistentHashMap.fromArrays(inst_30078,inst_30080);
var inst_30082 = fluree.db.dbfunctions.internal.query.call(null,inst_30056,inst_30081);
var state_30097__$1 = state_30097;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30097__$1,(22),inst_30082);
} else {
if((state_val_30098 === (13))){
var inst_30051 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30097__$1 = state_30097;
var statearr_30106_30148 = state_30097__$1;
(statearr_30106_30148[(2)] = inst_30051);

(statearr_30106_30148[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (22))){
var inst_30084 = (state_30097[(2)]);
var inst_30085 = fluree.db.util.async.throw_err.call(null,inst_30084);
var inst_30086 = cljs.core.nth.call(null,inst_30085,(0),null);
var inst_30087 = cljs.core.nth.call(null,inst_30085,(1),null);
var inst_30088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30089 = [inst_30086,inst_30087];
var inst_30090 = (new cljs.core.PersistentVector(null,2,(5),inst_30088,inst_30089,null));
var state_30097__$1 = state_30097;
var statearr_30107_30149 = state_30097__$1;
(statearr_30107_30149[(2)] = inst_30090);

(statearr_30107_30149[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (6))){
var inst_30038 = (state_30097[(2)]);
var state_30097__$1 = state_30097;
var statearr_30108_30150 = state_30097__$1;
(statearr_30108_30150[(2)] = inst_30038);

(statearr_30108_30150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (17))){
var inst_30060 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30061 = fluree.db.dbfunctions.internal.get.call(null,inst_30060,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_30097__$1 = state_30097;
var statearr_30109_30151 = state_30097__$1;
(statearr_30109_30151[(2)] = inst_30061);

(statearr_30109_30151[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (3))){
var inst_30095 = (state_30097[(2)]);
var state_30097__$1 = state_30097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30097__$1,inst_30095);
} else {
if((state_val_30098 === (12))){
var inst_30049 = (state_30097[(2)]);
var state_30097__$1 = state_30097;
if(cljs.core.truth_(inst_30049)){
var statearr_30110_30152 = state_30097__$1;
(statearr_30110_30152[(1)] = (13));

} else {
var statearr_30111_30153 = state_30097__$1;
(statearr_30111_30153[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (2))){
var inst_30044 = (state_30097[(10)]);
var _ = (function (){var statearr_30112 = state_30097;
(statearr_30112[(4)] = cljs.core.cons.call(null,(9),(state_30097[(4)])));

return statearr_30112;
})();
var inst_30044__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30097__$1 = (function (){var statearr_30113 = state_30097;
(statearr_30113[(10)] = inst_30044__$1);

return statearr_30113;
})();
if(cljs.core.truth_(inst_30044__$1)){
var statearr_30114_30154 = state_30097__$1;
(statearr_30114_30154[(1)] = (10));

} else {
var statearr_30115_30155 = state_30097__$1;
(statearr_30115_30155[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (19))){
var inst_30065 = cljs.core.PersistentVector.EMPTY;
var inst_30066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30067 = ["*"];
var inst_30068 = (new cljs.core.PersistentVector(null,1,(5),inst_30066,inst_30067,null));
var inst_30069 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_30070 = cljs.core.concat.call(null,inst_30068,inst_30069);
var inst_30071 = cljs.core.into.call(null,inst_30065,inst_30070);
var state_30097__$1 = state_30097;
var statearr_30117_30156 = state_30097__$1;
(statearr_30117_30156[(2)] = inst_30071);

(statearr_30117_30156[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (11))){
var inst_30044 = (state_30097[(10)]);
var state_30097__$1 = state_30097;
var statearr_30118_30157 = state_30097__$1;
(statearr_30118_30157[(2)] = inst_30044);

(statearr_30118_30157[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (9))){
var _ = (function (){var statearr_30119 = state_30097;
(statearr_30119[(4)] = cljs.core.rest.call(null,(state_30097[(4)])));

return statearr_30119;
})();
var state_30097__$1 = state_30097;
var ex30116 = (state_30097__$1[(2)]);
var statearr_30120_30158 = state_30097__$1;
(statearr_30120_30158[(5)] = ex30116);


var statearr_30121_30159 = state_30097__$1;
(statearr_30121_30159[(1)] = (4));

(statearr_30121_30159[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (5))){
var inst_30028 = (state_30097[(7)]);
var _ = (function (){var statearr_30122 = state_30097;
(statearr_30122[(4)] = cljs.core.cons.call(null,(8),(state_30097[(4)])));

return statearr_30122;
})();
var inst_30035 = fluree.db.dbfunctions.internal.function_error.call(null,inst_30028,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_30123 = state_30097;
(statearr_30123[(4)] = cljs.core.rest.call(null,(state_30097[(4)])));

return statearr_30123;
})();
var state_30097__$1 = state_30097;
var statearr_30124_30160 = state_30097__$1;
(statearr_30124_30160[(2)] = inst_30035);

(statearr_30124_30160[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (14))){
var inst_30057 = (state_30097[(11)]);
var inst_30056 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30057__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30097__$1 = (function (){var statearr_30125 = state_30097;
(statearr_30125[(9)] = inst_30056);

(statearr_30125[(11)] = inst_30057__$1);

return statearr_30125;
})();
if(cljs.core.truth_(inst_30057__$1)){
var statearr_30126_30161 = state_30097__$1;
(statearr_30126_30161[(1)] = (16));

} else {
var statearr_30127_30162 = state_30097__$1;
(statearr_30127_30162[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (16))){
var inst_30057 = (state_30097[(11)]);
var state_30097__$1 = state_30097;
var statearr_30128_30163 = state_30097__$1;
(statearr_30128_30163[(2)] = inst_30057);

(statearr_30128_30163[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (10))){
var inst_30046 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_30097__$1 = state_30097;
var statearr_30130_30164 = state_30097__$1;
(statearr_30130_30164[(2)] = inst_30046);

(statearr_30130_30164[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (18))){
var inst_30063 = (state_30097[(2)]);
var state_30097__$1 = (function (){var statearr_30131 = state_30097;
(statearr_30131[(8)] = inst_30063);

return statearr_30131;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30132_30165 = state_30097__$1;
(statearr_30132_30165[(1)] = (19));

} else {
var statearr_30133_30166 = state_30097__$1;
(statearr_30133_30166[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30098 === (8))){
var _ = (function (){var statearr_30134 = state_30097;
(statearr_30134[(4)] = cljs.core.rest.call(null,(state_30097[(4)])));

return statearr_30134;
})();
var state_30097__$1 = state_30097;
var ex30129 = (state_30097__$1[(2)]);
var statearr_30135_30167 = state_30097__$1;
(statearr_30135_30167[(5)] = ex30129);


var statearr_30136_30168 = state_30097__$1;
(statearr_30136_30168[(1)] = (7));

(statearr_30136_30168[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_30137 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30137[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_30137[(1)] = (1));

return statearr_30137;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_30097){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_30097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e30138){var ex__2749__auto__ = e30138;
var statearr_30139_30169 = state_30097;
(statearr_30139_30169[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_30097[(4)]))){
var statearr_30140_30170 = state_30097;
(statearr_30140_30170[(1)] = cljs.core.first.call(null,(state_30097[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30171 = state_30097;
state_30097 = G__30171;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_30097){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_30097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_30141 = f__2769__auto__.call(null);
(statearr_30141[(6)] = c__2768__auto__);

return statearr_30141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__30173 = arguments.length;
switch (G__30173) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_30217){
var state_val_30218 = (state_30217[(1)]);
if((state_val_30218 === (7))){
var inst_30195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30196 = ["*"];
var inst_30197 = (new cljs.core.PersistentVector(null,1,(5),inst_30195,inst_30196,null));
var state_30217__$1 = state_30217;
var statearr_30219_30239 = state_30217__$1;
(statearr_30219_30239[(2)] = inst_30197);

(statearr_30219_30239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (1))){
var state_30217__$1 = state_30217;
var statearr_30220_30240 = state_30217__$1;
(statearr_30220_30240[(2)] = null);

(statearr_30220_30240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (4))){
var inst_30174 = (state_30217[(2)]);
var inst_30175 = fluree.db.dbfunctions.internal.function_error.call(null,inst_30174,"?p","Context Object",additional_params);
var state_30217__$1 = state_30217;
var statearr_30221_30241 = state_30217__$1;
(statearr_30221_30241[(2)] = inst_30175);

(statearr_30221_30241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (6))){
var inst_30187 = cljs.core.PersistentVector.EMPTY;
var inst_30188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30189 = ["*"];
var inst_30190 = (new cljs.core.PersistentVector(null,1,(5),inst_30188,inst_30189,null));
var inst_30191 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_30192 = cljs.core.concat.call(null,inst_30190,inst_30191);
var inst_30193 = cljs.core.into.call(null,inst_30187,inst_30192);
var state_30217__$1 = state_30217;
var statearr_30222_30242 = state_30217__$1;
(statearr_30222_30242[(2)] = inst_30193);

(statearr_30222_30242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (3))){
var inst_30215 = (state_30217[(2)]);
var state_30217__$1 = state_30217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30217__$1,inst_30215);
} else {
if((state_val_30218 === (2))){
var _ = (function (){var statearr_30224 = state_30217;
(statearr_30224[(4)] = cljs.core.cons.call(null,(5),(state_30217[(4)])));

return statearr_30224;
})();
var inst_30184 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30185 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30217__$1 = (function (){var statearr_30225 = state_30217;
(statearr_30225[(7)] = inst_30184);

(statearr_30225[(8)] = inst_30185);

return statearr_30225;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30226_30243 = state_30217__$1;
(statearr_30226_30243[(1)] = (6));

} else {
var statearr_30227_30244 = state_30217__$1;
(statearr_30227_30244[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (9))){
var inst_30206 = (state_30217[(2)]);
var inst_30207 = fluree.db.util.async.throw_err.call(null,inst_30206);
var inst_30208 = cljs.core.nth.call(null,inst_30207,(0),null);
var inst_30209 = cljs.core.nth.call(null,inst_30207,(1),null);
var inst_30210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30211 = [inst_30208,inst_30209];
var inst_30212 = (new cljs.core.PersistentVector(null,2,(5),inst_30210,inst_30211,null));
var _ = (function (){var statearr_30228 = state_30217;
(statearr_30228[(4)] = cljs.core.rest.call(null,(state_30217[(4)])));

return statearr_30228;
})();
var state_30217__$1 = state_30217;
var statearr_30229_30245 = state_30217__$1;
(statearr_30229_30245[(2)] = inst_30212);

(statearr_30229_30245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (5))){
var _ = (function (){var statearr_30230 = state_30217;
(statearr_30230[(4)] = cljs.core.rest.call(null,(state_30217[(4)])));

return statearr_30230;
})();
var state_30217__$1 = state_30217;
var ex30223 = (state_30217__$1[(2)]);
var statearr_30231_30246 = state_30217__$1;
(statearr_30231_30246[(5)] = ex30223);


var statearr_30232_30247 = state_30217__$1;
(statearr_30232_30247[(1)] = (4));

(statearr_30232_30247[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (8))){
var inst_30184 = (state_30217[(7)]);
var inst_30185 = (state_30217[(8)]);
var inst_30199 = (state_30217[(2)]);
var inst_30200 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30201 = cljs.core.PersistentHashMap.EMPTY;
var inst_30202 = [inst_30199,inst_30185,inst_30201];
var inst_30203 = cljs.core.PersistentHashMap.fromArrays(inst_30200,inst_30202);
var inst_30204 = fluree.db.dbfunctions.internal.query.call(null,inst_30184,inst_30203);
var state_30217__$1 = state_30217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30217__$1,(9),inst_30204);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_30233 = [null,null,null,null,null,null,null,null,null];
(statearr_30233[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_30233[(1)] = (1));

return statearr_30233;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_30217){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_30217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e30234){var ex__2749__auto__ = e30234;
var statearr_30235_30248 = state_30217;
(statearr_30235_30248[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_30217[(4)]))){
var statearr_30236_30249 = state_30217;
(statearr_30236_30249[(1)] = cljs.core.first.call(null,(state_30217[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30250 = state_30217;
state_30217 = G__30250;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_30217){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_30217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_30237 = f__2769__auto__.call(null);
(statearr_30237[(6)] = c__2768__auto__);

return statearr_30237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_30294){
var state_val_30295 = (state_30294[(1)]);
if((state_val_30295 === (1))){
var state_30294__$1 = state_30294;
var statearr_30296_30310 = state_30294__$1;
(statearr_30296_30310[(2)] = null);

(statearr_30296_30310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30295 === (2))){
var _ = (function (){var statearr_30297 = state_30294;
(statearr_30297[(4)] = cljs.core.cons.call(null,(5),(state_30294[(4)])));

return statearr_30297;
})();
var inst_30261 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30263 = ["_user/_auth"];
var inst_30264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30265 = ["*"];
var inst_30266 = (new cljs.core.PersistentVector(null,1,(5),inst_30264,inst_30265,null));
var inst_30267 = [inst_30266];
var inst_30268 = cljs.core.PersistentHashMap.fromArrays(inst_30263,inst_30267);
var inst_30269 = [inst_30268];
var inst_30270 = (new cljs.core.PersistentVector(null,1,(5),inst_30262,inst_30269,null));
var inst_30271 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30272 = cljs.core.PersistentHashMap.EMPTY;
var inst_30273 = [inst_30270,inst_30271,inst_30272];
var inst_30274 = cljs.core.PersistentHashMap.fromArrays(inst_30261,inst_30273);
var inst_30275 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30276 = fluree.db.dbfunctions.internal.query.call(null,inst_30275,inst_30274);
var state_30294__$1 = state_30294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30294__$1,(6),inst_30276);
} else {
if((state_val_30295 === (3))){
var inst_30292 = (state_30294[(2)]);
var state_30294__$1 = state_30294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30294__$1,inst_30292);
} else {
if((state_val_30295 === (4))){
var inst_30251 = (state_30294[(2)]);
var inst_30252 = fluree.db.dbfunctions.internal.function_error.call(null,inst_30251,"?user_id-from-auth","Context Object");
var state_30294__$1 = state_30294;
var statearr_30299_30311 = state_30294__$1;
(statearr_30299_30311[(2)] = inst_30252);

(statearr_30299_30311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30295 === (5))){
var _ = (function (){var statearr_30300 = state_30294;
(statearr_30300[(4)] = cljs.core.rest.call(null,(state_30294[(4)])));

return statearr_30300;
})();
var state_30294__$1 = state_30294;
var ex30298 = (state_30294__$1[(2)]);
var statearr_30301_30312 = state_30294__$1;
(statearr_30301_30312[(5)] = ex30298);


var statearr_30302_30313 = state_30294__$1;
(statearr_30302_30313[(1)] = (4));

(statearr_30302_30313[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30295 === (6))){
var inst_30278 = (state_30294[(2)]);
var inst_30279 = fluree.db.util.async.throw_err.call(null,inst_30278);
var inst_30280 = cljs.core.nth.call(null,inst_30279,(0),null);
var inst_30281 = cljs.core.nth.call(null,inst_30279,(1),null);
var inst_30282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30283 = ["_user/_auth","_id"];
var inst_30284 = (new cljs.core.PersistentVector(null,2,(5),inst_30282,inst_30283,null));
var inst_30285 = fluree.db.dbfunctions.internal.get_in.call(null,inst_30280,inst_30284);
var inst_30286 = cljs.core.first.call(null,inst_30285);
var inst_30287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30288 = [inst_30286,inst_30281];
var inst_30289 = (new cljs.core.PersistentVector(null,2,(5),inst_30287,inst_30288,null));
var _ = (function (){var statearr_30303 = state_30294;
(statearr_30303[(4)] = cljs.core.rest.call(null,(state_30294[(4)])));

return statearr_30303;
})();
var state_30294__$1 = state_30294;
var statearr_30304_30314 = state_30294__$1;
(statearr_30304_30314[(2)] = inst_30289);

(statearr_30304_30314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0 = (function (){
var statearr_30305 = [null,null,null,null,null,null,null];
(statearr_30305[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__);

(statearr_30305[(1)] = (1));

return statearr_30305;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1 = (function (state_30294){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_30294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e30306){var ex__2749__auto__ = e30306;
var statearr_30307_30315 = state_30294;
(statearr_30307_30315[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_30294[(4)]))){
var statearr_30308_30316 = state_30294;
(statearr_30308_30316[(1)] = cljs.core.first.call(null,(state_30294[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30317 = state_30294;
state_30294 = G__30317;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = function(state_30294){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1.call(this,state_30294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_30309 = f__2769__auto__.call(null);
(statearr_30309[(6)] = c__2768__auto__);

return statearr_30309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_30334){
var state_val_30335 = (state_30334[(1)]);
if((state_val_30335 === (1))){
var state_30334__$1 = state_30334;
var statearr_30336_30350 = state_30334__$1;
(statearr_30336_30350[(2)] = null);

(statearr_30336_30350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30335 === (2))){
var _ = (function (){var statearr_30337 = state_30334;
(statearr_30337[(4)] = cljs.core.cons.call(null,(5),(state_30334[(4)])));

return statearr_30337;
})();
var inst_30324 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30325 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30326 = fluree.db.dbproto._subid.call(null,inst_30325,inst_30324);
var state_30334__$1 = state_30334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30334__$1,(6),inst_30326);
} else {
if((state_val_30335 === (3))){
var inst_30332 = (state_30334[(2)]);
var state_30334__$1 = state_30334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30334__$1,inst_30332);
} else {
if((state_val_30335 === (4))){
var inst_30318 = (state_30334[(2)]);
var state_30334__$1 = state_30334;
var statearr_30339_30351 = state_30334__$1;
(statearr_30339_30351[(2)] = inst_30318);

(statearr_30339_30351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30335 === (5))){
var _ = (function (){var statearr_30340 = state_30334;
(statearr_30340[(4)] = cljs.core.rest.call(null,(state_30334[(4)])));

return statearr_30340;
})();
var state_30334__$1 = state_30334;
var ex30338 = (state_30334__$1[(2)]);
var statearr_30341_30352 = state_30334__$1;
(statearr_30341_30352[(5)] = ex30338);


if((ex30338 instanceof Error)){
var statearr_30342_30353 = state_30334__$1;
(statearr_30342_30353[(1)] = (4));

(statearr_30342_30353[(5)] = null);

} else {
throw ex30338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30335 === (6))){
var inst_30328 = (state_30334[(2)]);
var inst_30329 = fluree.db.util.async.throw_err.call(null,inst_30328);
var _ = (function (){var statearr_30343 = state_30334;
(statearr_30343[(4)] = cljs.core.rest.call(null,(state_30334[(4)])));

return statearr_30343;
})();
var state_30334__$1 = state_30334;
var statearr_30344_30354 = state_30334__$1;
(statearr_30344_30354[(2)] = inst_30329);

(statearr_30344_30354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_30345 = [null,null,null,null,null,null,null];
(statearr_30345[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_30345[(1)] = (1));

return statearr_30345;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_30334){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_30334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e30346){var ex__2749__auto__ = e30346;
var statearr_30347_30355 = state_30334;
(statearr_30347_30355[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_30334[(4)]))){
var statearr_30348_30356 = state_30334;
(statearr_30348_30356[(1)] = cljs.core.first.call(null,(state_30334[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30357 = state_30334;
state_30334 = G__30357;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_30334){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_30334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_30349 = f__2769__auto__.call(null);
(statearr_30349[(6)] = c__2768__auto__);

return statearr_30349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__30358_SHARP_){
return p1__30358_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__30359_SHARP_){
return p1__30359_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e30360){var e = e30360;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__30361_SHARP_){
return p1__30361_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__30362_SHARP_){
return p1__30362_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e30363){var e = e30363;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e30364){var e = e30364;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_30444){
var state_val_30445 = (state_30444[(1)]);
if((state_val_30445 === (7))){
var inst_30383 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_30384 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30385 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30386 = cljs.core.PersistentHashMap.fromArrays(inst_30384,inst_30385);
var inst_30387 = cljs.core.ex_info.call(null,inst_30383,inst_30386);
var inst_30388 = (function(){throw inst_30387})();
var state_30444__$1 = state_30444;
var statearr_30446_30481 = state_30444__$1;
(statearr_30446_30481[(2)] = inst_30388);

(statearr_30446_30481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (1))){
var state_30444__$1 = state_30444;
var statearr_30447_30482 = state_30444__$1;
(statearr_30447_30482[(2)] = null);

(statearr_30447_30482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (4))){
var inst_30365 = (state_30444[(2)]);
var state_30444__$1 = state_30444;
var statearr_30448_30483 = state_30444__$1;
(statearr_30448_30483[(2)] = inst_30365);

(statearr_30448_30483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (15))){
var inst_30428 = (state_30444[(7)]);
var inst_30424 = (state_30444[(2)]);
var inst_30425 = fluree.db.util.async.throw_err.call(null,inst_30424);
var inst_30426 = cljs.core.nth.call(null,inst_30425,(0),null);
var inst_30427 = cljs.core.nth.call(null,inst_30425,(1),null);
var inst_30428__$1 = cljs.core.first.call(null,inst_30426);
var inst_30429 = cljs.core._EQ_.call(null,inst_30428__$1,compare_val);
var state_30444__$1 = (function (){var statearr_30449 = state_30444;
(statearr_30449[(7)] = inst_30428__$1);

(statearr_30449[(8)] = inst_30427);

return statearr_30449;
})();
if(inst_30429){
var statearr_30450_30484 = state_30444__$1;
(statearr_30450_30484[(1)] = (16));

} else {
var statearr_30451_30485 = state_30444__$1;
(statearr_30451_30485[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (13))){
var state_30444__$1 = state_30444;
var statearr_30452_30486 = state_30444__$1;
(statearr_30452_30486[(2)] = null);

(statearr_30452_30486[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (6))){
var state_30444__$1 = state_30444;
var statearr_30453_30487 = state_30444__$1;
(statearr_30453_30487[(2)] = null);

(statearr_30453_30487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (17))){
var inst_30428 = (state_30444[(7)]);
var inst_30432 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30428)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_30433 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30434 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30435 = cljs.core.PersistentHashMap.fromArrays(inst_30433,inst_30434);
var inst_30436 = cljs.core.ex_info.call(null,inst_30432,inst_30435);
var inst_30437 = (function(){throw inst_30436})();
var state_30444__$1 = state_30444;
var statearr_30454_30488 = state_30444__$1;
(statearr_30454_30488[(2)] = inst_30437);

(statearr_30454_30488[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (3))){
var inst_30442 = (state_30444[(2)]);
var state_30444__$1 = state_30444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30444__$1,inst_30442);
} else {
if((state_val_30445 === (12))){
var inst_30380 = (state_30444[(9)]);
var inst_30403 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_30380);
var inst_30404 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30405 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30406 = cljs.core.PersistentHashMap.fromArrays(inst_30404,inst_30405);
var inst_30407 = cljs.core.ex_info.call(null,inst_30403,inst_30406);
var inst_30408 = (function(){throw inst_30407})();
var state_30444__$1 = state_30444;
var statearr_30455_30489 = state_30444__$1;
(statearr_30455_30489[(2)] = inst_30408);

(statearr_30455_30489[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (2))){
var inst_30377 = (state_30444[(10)]);
var inst_30378 = (state_30444[(11)]);
var inst_30379 = (state_30444[(12)]);
var _ = (function (){var statearr_30456 = state_30444;
(statearr_30456[(4)] = cljs.core.cons.call(null,(5),(state_30444[(4)])));

return statearr_30456;
})();
var inst_30375 = _QMARK_ctx;
var inst_30376 = cljs.core.__destructure_map.call(null,inst_30375);
var inst_30377__$1 = cljs.core.get.call(null,inst_30376,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_30378__$1 = cljs.core.get.call(null,inst_30376,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_30379__$1 = cljs.core.get.call(null,inst_30376,new cljs.core.Keyword(null,"db","db",993250759));
var inst_30380 = fluree.db.dbproto._p_prop.call(null,inst_30379__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_30378__$1);
var state_30444__$1 = (function (){var statearr_30457 = state_30444;
(statearr_30457[(10)] = inst_30377__$1);

(statearr_30457[(9)] = inst_30380);

(statearr_30457[(11)] = inst_30378__$1);

(statearr_30457[(12)] = inst_30379__$1);

return statearr_30457;
})();
if(cljs.core.truth_(inst_30377__$1)){
var statearr_30458_30490 = state_30444__$1;
(statearr_30458_30490[(1)] = (6));

} else {
var statearr_30459_30491 = state_30444__$1;
(statearr_30459_30491[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (11))){
var inst_30378 = (state_30444[(11)]);
var inst_30379 = (state_30444[(12)]);
var inst_30400 = (state_30444[(2)]);
var inst_30401 = fluree.db.dbproto._p_prop.call(null,inst_30379,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_30378);
var state_30444__$1 = (function (){var statearr_30461 = state_30444;
(statearr_30461[(13)] = inst_30400);

return statearr_30461;
})();
if(cljs.core.truth_(inst_30401)){
var statearr_30462_30492 = state_30444__$1;
(statearr_30462_30492[(1)] = (12));

} else {
var statearr_30463_30493 = state_30444__$1;
(statearr_30463_30493[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (9))){
var state_30444__$1 = state_30444;
var statearr_30464_30494 = state_30444__$1;
(statearr_30464_30494[(2)] = null);

(statearr_30464_30494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (5))){
var _ = (function (){var statearr_30465 = state_30444;
(statearr_30465[(4)] = cljs.core.rest.call(null,(state_30444[(4)])));

return statearr_30465;
})();
var state_30444__$1 = state_30444;
var ex30460 = (state_30444__$1[(2)]);
var statearr_30466_30495 = state_30444__$1;
(statearr_30466_30495[(5)] = ex30460);


if((ex30460 instanceof Error)){
var statearr_30467_30496 = state_30444__$1;
(statearr_30467_30496[(1)] = (4));

(statearr_30467_30496[(5)] = null);

} else {
throw ex30460;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (14))){
var inst_30377 = (state_30444[(10)]);
var inst_30380 = (state_30444[(9)]);
var inst_30379 = (state_30444[(12)]);
var inst_30411 = (state_30444[(2)]);
var inst_30412 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30415 = [inst_30377,inst_30380,"?current-val"];
var inst_30416 = (new cljs.core.PersistentVector(null,3,(5),inst_30414,inst_30415,null));
var inst_30417 = [inst_30416];
var inst_30418 = (new cljs.core.PersistentVector(null,1,(5),inst_30413,inst_30417,null));
var inst_30419 = cljs.core.PersistentHashMap.EMPTY;
var inst_30420 = ["?current-val",inst_30418,inst_30419];
var inst_30421 = cljs.core.PersistentHashMap.fromArrays(inst_30412,inst_30420);
var inst_30422 = fluree.db.dbfunctions.internal.query.call(null,inst_30379,inst_30421);
var state_30444__$1 = (function (){var statearr_30468 = state_30444;
(statearr_30468[(14)] = inst_30411);

return statearr_30468;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30444__$1,(15),inst_30422);
} else {
if((state_val_30445 === (16))){
var state_30444__$1 = state_30444;
var statearr_30469_30497 = state_30444__$1;
(statearr_30469_30497[(2)] = new_val);

(statearr_30469_30497[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (10))){
var inst_30393 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_30394 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30395 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30396 = cljs.core.PersistentHashMap.fromArrays(inst_30394,inst_30395);
var inst_30397 = cljs.core.ex_info.call(null,inst_30393,inst_30396);
var inst_30398 = (function(){throw inst_30397})();
var state_30444__$1 = state_30444;
var statearr_30470_30498 = state_30444__$1;
(statearr_30470_30498[(2)] = inst_30398);

(statearr_30470_30498[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (18))){
var inst_30439 = (state_30444[(2)]);
var _ = (function (){var statearr_30471 = state_30444;
(statearr_30471[(4)] = cljs.core.rest.call(null,(state_30444[(4)])));

return statearr_30471;
})();
var state_30444__$1 = state_30444;
var statearr_30472_30499 = state_30444__$1;
(statearr_30472_30499[(2)] = inst_30439);

(statearr_30472_30499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (8))){
var inst_30380 = (state_30444[(9)]);
var inst_30390 = (state_30444[(2)]);
var state_30444__$1 = (function (){var statearr_30473 = state_30444;
(statearr_30473[(15)] = inst_30390);

return statearr_30473;
})();
if(cljs.core.truth_(inst_30380)){
var statearr_30474_30500 = state_30444__$1;
(statearr_30474_30500[(1)] = (9));

} else {
var statearr_30475_30501 = state_30444__$1;
(statearr_30475_30501[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_30476 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30476[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__);

(statearr_30476[(1)] = (1));

return statearr_30476;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1 = (function (state_30444){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_30444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e30477){var ex__2749__auto__ = e30477;
var statearr_30478_30502 = state_30444;
(statearr_30478_30502[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_30444[(4)]))){
var statearr_30479_30503 = state_30444;
(statearr_30479_30503[(1)] = cljs.core.first.call(null,(state_30444[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30504 = state_30444;
state_30444 = G__30504;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = function(state_30444){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1.call(this,state_30444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_30480 = f__2769__auto__.call(null);
(statearr_30480[(6)] = c__2768__auto__);

return statearr_30480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
