// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__27232 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__27232,(0),null);
var network = cljs.core.nth.call(null,vec__27232,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__27232,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__27235){
var map__27236 = p__27235;
var map__27236__$1 = cljs.core.__destructure_map.call(null,map__27236);
var opts = map__27236__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__27236__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27296){
var state_val_27297 = (state_27296[(1)]);
if((state_val_27297 === (7))){
var inst_27267 = cljs.core.not.call(null,reindex_QMARK_);
var state_27296__$1 = state_27296;
var statearr_27298_27322 = state_27296__$1;
(statearr_27298_27322[(2)] = inst_27267);

(statearr_27298_27322[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (1))){
var state_27296__$1 = state_27296;
var statearr_27299_27323 = state_27296__$1;
(statearr_27299_27323[(2)] = null);

(statearr_27299_27323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (4))){
var inst_27237 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
var statearr_27300_27324 = state_27296__$1;
(statearr_27300_27324[(2)] = inst_27237);

(statearr_27300_27324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (6))){
var inst_27265 = (state_27296[(7)]);
var inst_27257 = (state_27296[(8)]);
var inst_27251 = (state_27296[(9)]);
var inst_27250 = (state_27296[(2)]);
var inst_27251__$1 = fluree.db.util.async.throw_err.call(null,inst_27250);
var inst_27252 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_27253 = cljs.core.__destructure_map.call(null,inst_27252);
var inst_27254 = cljs.core.get.call(null,inst_27253,new cljs.core.Keyword(null,"post","post",269697687));
var inst_27255 = cljs.core.get.call(null,inst_27253,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_27256 = fluree.db.flake.size_bytes.call(null,inst_27251__$1);
var inst_27257__$1 = (inst_27255 + inst_27256);
var inst_27258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27259 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_27260 = (new cljs.core.PersistentVector(null,2,(5),inst_27258,inst_27259,null));
var inst_27261 = cljs.core.get_in.call(null,db,inst_27260);
var inst_27262 = cljs.core.__destructure_map.call(null,inst_27261);
var inst_27263 = cljs.core.get.call(null,inst_27262,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_27264 = cljs.core.get.call(null,inst_27262,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_27265__$1 = (inst_27257__$1 > inst_27264);
var state_27296__$1 = (function (){var statearr_27301 = state_27296;
(statearr_27301[(7)] = inst_27265__$1);

(statearr_27301[(10)] = inst_27263);

(statearr_27301[(8)] = inst_27257__$1);

(statearr_27301[(11)] = inst_27254);

(statearr_27301[(9)] = inst_27251__$1);

return statearr_27301;
})();
if(cljs.core.truth_(inst_27265__$1)){
var statearr_27302_27325 = state_27296__$1;
(statearr_27302_27325[(1)] = (7));

} else {
var statearr_27303_27326 = state_27296__$1;
(statearr_27303_27326[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (3))){
var inst_27294 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27296__$1,inst_27294);
} else {
if((state_val_27297 === (12))){
var inst_27257 = (state_27296[(8)]);
var inst_27254 = (state_27296[(11)]);
var inst_27251 = (state_27296[(9)]);
var inst_27280 = (state_27296[(2)]);
var inst_27281 = cljs.core.into.call(null,inst_27254,inst_27251);
var inst_27282 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_27283 = cljs.core.swap_BANG_.call(null,inst_27282,cljs.core.empty);
var inst_27284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27285 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27286 = (new cljs.core.PersistentVector(null,2,(5),inst_27284,inst_27285,null));
var inst_27287 = cljs.core.assoc_in.call(null,db,inst_27286,inst_27281);
var inst_27288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27289 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27290 = (new cljs.core.PersistentVector(null,2,(5),inst_27288,inst_27289,null));
var inst_27291 = cljs.core.assoc_in.call(null,inst_27287,inst_27290,inst_27257);
var _ = (function (){var statearr_27304 = state_27296;
(statearr_27304[(4)] = cljs.core.rest.call(null,(state_27296[(4)])));

return statearr_27304;
})();
var state_27296__$1 = (function (){var statearr_27305 = state_27296;
(statearr_27305[(12)] = inst_27283);

(statearr_27305[(13)] = inst_27280);

return statearr_27305;
})();
var statearr_27306_27327 = state_27296__$1;
(statearr_27306_27327[(2)] = inst_27291);

(statearr_27306_27327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (2))){
var _ = (function (){var statearr_27307 = state_27296;
(statearr_27307[(4)] = cljs.core.cons.call(null,(5),(state_27296[(4)])));

return statearr_27307;
})();
var inst_27245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27246 = [pred_id];
var inst_27247 = (new cljs.core.PersistentVector(null,1,(5),inst_27245,inst_27246,null));
var inst_27248 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_27247);
var state_27296__$1 = state_27296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27296__$1,(6),inst_27248);
} else {
if((state_val_27297 === (11))){
var state_27296__$1 = state_27296;
var statearr_27309_27328 = state_27296__$1;
(statearr_27309_27328[(2)] = null);

(statearr_27309_27328[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (9))){
var inst_27270 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
if(cljs.core.truth_(inst_27270)){
var statearr_27310_27329 = state_27296__$1;
(statearr_27310_27329[(1)] = (10));

} else {
var statearr_27311_27330 = state_27296__$1;
(statearr_27311_27330[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (5))){
var _ = (function (){var statearr_27312 = state_27296;
(statearr_27312[(4)] = cljs.core.rest.call(null,(state_27296[(4)])));

return statearr_27312;
})();
var state_27296__$1 = state_27296;
var ex27308 = (state_27296__$1[(2)]);
var statearr_27313_27331 = state_27296__$1;
(statearr_27313_27331[(5)] = ex27308);


if((ex27308 instanceof Error)){
var statearr_27314_27332 = state_27296__$1;
(statearr_27314_27332[(1)] = (4));

(statearr_27314_27332[(5)] = null);

} else {
throw ex27308;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (10))){
var inst_27272 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_27273 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_27274 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_27275 = cljs.core.PersistentHashMap.fromArrays(inst_27273,inst_27274);
var inst_27276 = cljs.core.ex_info.call(null,inst_27272,inst_27275);
var inst_27277 = (function(){throw inst_27276})();
var state_27296__$1 = state_27296;
var statearr_27315_27333 = state_27296__$1;
(statearr_27315_27333[(2)] = inst_27277);

(statearr_27315_27333[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27297 === (8))){
var inst_27265 = (state_27296[(7)]);
var state_27296__$1 = state_27296;
var statearr_27316_27334 = state_27296__$1;
(statearr_27316_27334[(2)] = inst_27265);

(statearr_27316_27334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0 = (function (){
var statearr_27317 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27317[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__);

(statearr_27317[(1)] = (1));

return statearr_27317;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1 = (function (state_27296){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27318){var ex__2749__auto__ = e27318;
var statearr_27319_27335 = state_27296;
(statearr_27319_27335[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27296[(4)]))){
var statearr_27320_27336 = state_27296;
(statearr_27320_27336[(1)] = cljs.core.first.call(null,(state_27296[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27337 = state_27296;
state_27296 = G__27337;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = function(state_27296){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1.call(this,state_27296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27321 = f__2769__auto__.call(null);
(statearr_27321[(6)] = c__2768__auto__);

return statearr_27321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__27342 = arguments.length;
switch (G__27342) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27538){
var state_val_27539 = (state_27538[(1)]);
if((state_val_27539 === (7))){
var state_27538__$1 = state_27538;
var statearr_27540_27607 = state_27538__$1;
(statearr_27540_27607[(2)] = null);

(statearr_27540_27607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (20))){
var inst_27381 = (state_27538[(7)]);
var inst_27380 = (state_27538[(8)]);
var inst_27462 = (state_27538[(9)]);
var inst_27463 = (state_27538[(10)]);
var inst_27464 = (state_27538[(11)]);
var inst_27460 = (state_27538[(12)]);
var inst_27431 = (state_27538[(13)]);
var inst_27461 = (state_27538[(14)]);
var inst_27474 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27476 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27477 = (new cljs.core.PersistentVector(null,2,(5),inst_27475,inst_27476,null));
var inst_27478 = cljs.core.get_in.call(null,inst_27431,inst_27477);
var inst_27479 = (inst_27380 + inst_27478);
var inst_27480 = [inst_27460,inst_27461,inst_27462,inst_27463,inst_27479];
var inst_27481 = cljs.core.PersistentHashMap.fromArrays(inst_27474,inst_27480);
var inst_27482 = cljs.core.assoc.call(null,inst_27431,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_27464,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_27481);
var state_27538__$1 = (function (){var statearr_27541 = state_27538;
(statearr_27541[(15)] = inst_27482);

return statearr_27541;
})();
if(cljs.core.truth_(inst_27381)){
var statearr_27542_27608 = state_27538__$1;
(statearr_27542_27608[(1)] = (23));

} else {
var statearr_27543_27609 = state_27538__$1;
(statearr_27543_27609[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (27))){
var inst_27482 = (state_27538[(15)]);
var state_27538__$1 = state_27538;
var statearr_27544_27610 = state_27538__$1;
(statearr_27544_27610[(2)] = inst_27482);

(statearr_27544_27610[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (1))){
var state_27538__$1 = state_27538;
var statearr_27545_27611 = state_27538__$1;
(statearr_27545_27611[(2)] = null);

(statearr_27545_27611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (24))){
var inst_27482 = (state_27538[(15)]);
var inst_27485 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_27482);
var inst_27486 = (inst_27485 == null);
var state_27538__$1 = state_27538;
var statearr_27546_27612 = state_27538__$1;
(statearr_27546_27612[(2)] = inst_27486);

(statearr_27546_27612[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (39))){
var inst_27521 = (state_27538[(16)]);
var inst_27514 = (state_27538[(17)]);
var inst_27512 = (state_27538[(18)]);
var inst_27471 = (state_27538[(19)]);
var inst_27513 = (state_27538[(20)]);
var inst_27528 = (state_27538[(2)]);
var inst_27459 = inst_27471;
var inst_27460 = inst_27513;
var inst_27461 = inst_27514;
var inst_27462 = inst_27521;
var inst_27463 = inst_27528;
var inst_27464 = inst_27512;
var state_27538__$1 = (function (){var statearr_27547 = state_27538;
(statearr_27547[(21)] = inst_27459);

(statearr_27547[(9)] = inst_27462);

(statearr_27547[(10)] = inst_27463);

(statearr_27547[(11)] = inst_27464);

(statearr_27547[(12)] = inst_27460);

(statearr_27547[(14)] = inst_27461);

return statearr_27547;
})();
var statearr_27548_27613 = state_27538__$1;
(statearr_27548_27613[(2)] = null);

(statearr_27548_27613[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (4))){
var inst_27343 = (state_27538[(2)]);
var state_27538__$1 = state_27538;
var statearr_27549_27614 = state_27538__$1;
(statearr_27549_27614[(2)] = inst_27343);

(statearr_27549_27614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (15))){
var inst_27403 = (state_27538[(22)]);
var state_27538__$1 = state_27538;
var statearr_27550_27615 = state_27538__$1;
(statearr_27550_27615[(2)] = inst_27403);

(statearr_27550_27615[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (21))){
var inst_27381 = (state_27538[(7)]);
var inst_27440 = (state_27538[(23)]);
var inst_27367 = (state_27538[(24)]);
var inst_27384 = (state_27538[(25)]);
var inst_27371 = (state_27538[(26)]);
var inst_27459 = (state_27538[(21)]);
var inst_27365 = (state_27538[(27)]);
var inst_27375 = (state_27538[(28)]);
var inst_27379 = (state_27538[(29)]);
var inst_27380 = (state_27538[(8)]);
var inst_27350 = (state_27538[(30)]);
var inst_27390 = (state_27538[(31)]);
var inst_27382 = (state_27538[(32)]);
var inst_27471 = (state_27538[(19)]);
var inst_27462 = (state_27538[(9)]);
var inst_27463 = (state_27538[(10)]);
var inst_27470 = (state_27538[(33)]);
var inst_27464 = (state_27538[(11)]);
var inst_27460 = (state_27538[(12)]);
var inst_27431 = (state_27538[(13)]);
var inst_27441 = (state_27538[(34)]);
var inst_27461 = (state_27538[(14)]);
var inst_27509 = inst_27470.s;
var inst_27510 = fluree.db.flake.sid__GT_cid.call(null,inst_27509);
var inst_27511 = (function (){var flakes_bytes = inst_27380;
var first__27468 = inst_27470;
var t = inst_27350;
var G__27435 = inst_27459;
var spot = inst_27460;
var seq__27467 = inst_27471;
var add_flakes = inst_27367;
var root_setting_change_QMARK_ = inst_27382;
var ref_QMARK__map = inst_27379;
var r = inst_27471;
var psot = inst_27461;
var add_pred_to_idx_QMARK_ = inst_27390;
var vec__27466 = inst_27459;
var _ = inst_27365;
var cid = inst_27510;
var ecount = inst_27464;
var pred_ecount = inst_27384;
var db_STAR_ = inst_27431;
var schema_change_QMARK_ = inst_27381;
var vec__27436 = inst_27367;
var add_preds = inst_27371;
var first__27438 = inst_27440;
var opst = inst_27463;
var seq__27437 = inst_27441;
var idx_QMARK__map = inst_27375;
var post = inst_27462;
var f = inst_27470;
return (function (p1__27340_SHARP_){
if(cljs.core.truth_(p1__27340_SHARP_)){
var x__5130__auto__ = p1__27340_SHARP_;
var y__5131__auto__ = f.s;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return f.s;
}
});
})();
var inst_27512 = cljs.core.update.call(null,inst_27464,inst_27510,inst_27511);
var inst_27513 = cljs.core.conj.call(null,inst_27460,inst_27470);
var inst_27514 = cljs.core.conj.call(null,inst_27461,inst_27470);
var inst_27515 = inst_27470.p;
var inst_27516 = cljs.core.get.call(null,inst_27375,inst_27515);
var state_27538__$1 = (function (){var statearr_27551 = state_27538;
(statearr_27551[(17)] = inst_27514);

(statearr_27551[(18)] = inst_27512);

(statearr_27551[(20)] = inst_27513);

return statearr_27551;
})();
if(cljs.core.truth_(inst_27516)){
var statearr_27552_27616 = state_27538__$1;
(statearr_27552_27616[(1)] = (34));

} else {
var statearr_27553_27617 = state_27538__$1;
(statearr_27553_27617[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (31))){
var inst_27497 = (state_27538[(35)]);
var state_27538__$1 = state_27538;
var statearr_27554_27618 = state_27538__$1;
(statearr_27554_27618[(2)] = inst_27497);

(statearr_27554_27618[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (32))){
var inst_27507 = (state_27538[(2)]);
var state_27538__$1 = state_27538;
var statearr_27555_27619 = state_27538__$1;
(statearr_27555_27619[(2)] = inst_27507);

(statearr_27555_27619[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (33))){
var inst_27497 = (state_27538[(35)]);
var inst_27502 = (state_27538[(2)]);
var inst_27503 = fluree.db.util.async.throw_err.call(null,inst_27502);
var inst_27504 = cljs.core.assoc.call(null,inst_27497,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27503);
var state_27538__$1 = state_27538;
var statearr_27556_27620 = state_27538__$1;
(statearr_27556_27620[(2)] = inst_27504);

(statearr_27556_27620[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (13))){
var inst_27367 = (state_27538[(24)]);
var inst_27380 = (state_27538[(8)]);
var inst_27350 = (state_27538[(30)]);
var inst_27431 = (state_27538[(13)]);
var inst_27421 = (state_27538[(2)]);
var inst_27422 = cljs.core.assoc.call(null,inst_27421,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27350);
var inst_27423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27424 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27425 = (new cljs.core.PersistentVector(null,2,(5),inst_27423,inst_27424,null));
var inst_27426 = cljs.core.update_in.call(null,inst_27422,inst_27425,cljs.core._PLUS_,inst_27380);
var inst_27427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27428 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_27429 = (new cljs.core.PersistentVector(null,2,(5),inst_27427,inst_27428,null));
var inst_27430 = cljs.core.count.call(null,inst_27367);
var inst_27431__$1 = cljs.core.update_in.call(null,inst_27426,inst_27429,cljs.core._PLUS_,inst_27430);
var inst_27439 = cljs.core.seq.call(null,inst_27367);
var inst_27440 = cljs.core.first.call(null,inst_27439);
var inst_27441 = cljs.core.next.call(null,inst_27439);
var inst_27442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27443 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_27444 = (new cljs.core.PersistentVector(null,2,(5),inst_27442,inst_27443,null));
var inst_27445 = cljs.core.get_in.call(null,inst_27431__$1,inst_27444);
var inst_27446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27447 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_27448 = (new cljs.core.PersistentVector(null,2,(5),inst_27446,inst_27447,null));
var inst_27449 = cljs.core.get_in.call(null,inst_27431__$1,inst_27448);
var inst_27450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27451 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27452 = (new cljs.core.PersistentVector(null,2,(5),inst_27450,inst_27451,null));
var inst_27453 = cljs.core.get_in.call(null,inst_27431__$1,inst_27452);
var inst_27454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27455 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27456 = (new cljs.core.PersistentVector(null,2,(5),inst_27454,inst_27455,null));
var inst_27457 = cljs.core.get_in.call(null,inst_27431__$1,inst_27456);
var inst_27458 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27459 = inst_27367;
var inst_27460 = inst_27445;
var inst_27461 = inst_27449;
var inst_27462 = inst_27453;
var inst_27463 = inst_27457;
var inst_27464 = inst_27458;
var state_27538__$1 = (function (){var statearr_27557 = state_27538;
(statearr_27557[(23)] = inst_27440);

(statearr_27557[(21)] = inst_27459);

(statearr_27557[(9)] = inst_27462);

(statearr_27557[(10)] = inst_27463);

(statearr_27557[(11)] = inst_27464);

(statearr_27557[(12)] = inst_27460);

(statearr_27557[(13)] = inst_27431__$1);

(statearr_27557[(34)] = inst_27441);

(statearr_27557[(14)] = inst_27461);

return statearr_27557;
})();
var statearr_27558_27621 = state_27538__$1;
(statearr_27558_27621[(2)] = null);

(statearr_27558_27621[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (22))){
var inst_27531 = (state_27538[(2)]);
var state_27538__$1 = state_27538;
var statearr_27559_27622 = state_27538__$1;
(statearr_27559_27622[(2)] = inst_27531);

(statearr_27559_27622[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (36))){
var inst_27379 = (state_27538[(29)]);
var inst_27470 = (state_27538[(33)]);
var inst_27521 = (state_27538[(2)]);
var inst_27522 = inst_27470.p;
var inst_27523 = cljs.core.get.call(null,inst_27379,inst_27522);
var state_27538__$1 = (function (){var statearr_27560 = state_27538;
(statearr_27560[(16)] = inst_27521);

return statearr_27560;
})();
if(cljs.core.truth_(inst_27523)){
var statearr_27561_27623 = state_27538__$1;
(statearr_27561_27623[(1)] = (37));

} else {
var statearr_27562_27624 = state_27538__$1;
(statearr_27562_27624[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (29))){
var inst_27482 = (state_27538[(15)]);
var inst_27492 = (state_27538[(2)]);
var inst_27493 = fluree.db.util.async.throw_err.call(null,inst_27492);
var inst_27494 = cljs.core.assoc.call(null,inst_27482,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27493);
var state_27538__$1 = state_27538;
var statearr_27563_27625 = state_27538__$1;
(statearr_27563_27625[(2)] = inst_27494);

(statearr_27563_27625[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (6))){
var inst_27350 = (state_27538[(30)]);
var inst_27355 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27356 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27357 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27355)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27356)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27350),"."].join('');
var inst_27358 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27359 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27360 = cljs.core.PersistentHashMap.fromArrays(inst_27358,inst_27359);
var inst_27361 = cljs.core.ex_info.call(null,inst_27357,inst_27360);
var inst_27362 = (function(){throw inst_27361})();
var state_27538__$1 = state_27538;
var statearr_27564_27626 = state_27538__$1;
(statearr_27564_27626[(2)] = inst_27362);

(statearr_27564_27626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (28))){
var inst_27382 = (state_27538[(32)]);
var inst_27497 = (state_27538[(2)]);
var state_27538__$1 = (function (){var statearr_27565 = state_27538;
(statearr_27565[(35)] = inst_27497);

return statearr_27565;
})();
if(cljs.core.truth_(inst_27382)){
var statearr_27566_27627 = state_27538__$1;
(statearr_27566_27627[(1)] = (30));

} else {
var statearr_27567_27628 = state_27538__$1;
(statearr_27567_27628[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (25))){
var inst_27488 = (state_27538[(2)]);
var state_27538__$1 = state_27538;
if(cljs.core.truth_(inst_27488)){
var statearr_27568_27629 = state_27538__$1;
(statearr_27568_27629[(1)] = (26));

} else {
var statearr_27569_27630 = state_27538__$1;
(statearr_27569_27630[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (34))){
var inst_27462 = (state_27538[(9)]);
var inst_27470 = (state_27538[(33)]);
var inst_27518 = cljs.core.conj.call(null,inst_27462,inst_27470);
var state_27538__$1 = state_27538;
var statearr_27570_27631 = state_27538__$1;
(statearr_27570_27631[(2)] = inst_27518);

(statearr_27570_27631[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (17))){
var inst_27410 = (state_27538[(36)]);
var inst_27414 = (state_27538[(2)]);
var inst_27415 = fluree.db.util.async.throw_err.call(null,inst_27414);
var inst_27402 = inst_27410;
var inst_27403 = inst_27415;
var state_27538__$1 = (function (){var statearr_27571 = state_27538;
(statearr_27571[(37)] = inst_27402);

(statearr_27571[(22)] = inst_27403);

return statearr_27571;
})();
var statearr_27572_27632 = state_27538__$1;
(statearr_27572_27632[(2)] = null);

(statearr_27572_27632[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (3))){
var inst_27536 = (state_27538[(2)]);
var state_27538__$1 = state_27538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27538__$1,inst_27536);
} else {
if((state_val_27539 === (12))){
var inst_27402 = (state_27538[(37)]);
var inst_27409 = (state_27538[(38)]);
var inst_27408 = cljs.core.seq.call(null,inst_27402);
var inst_27409__$1 = cljs.core.first.call(null,inst_27408);
var inst_27410 = cljs.core.next.call(null,inst_27408);
var state_27538__$1 = (function (){var statearr_27573 = state_27538;
(statearr_27573[(36)] = inst_27410);

(statearr_27573[(38)] = inst_27409__$1);

return statearr_27573;
})();
if(cljs.core.truth_(inst_27409__$1)){
var statearr_27574_27633 = state_27538__$1;
(statearr_27574_27633[(1)] = (14));

} else {
var statearr_27575_27634 = state_27538__$1;
(statearr_27575_27634[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (2))){
var inst_27350 = (state_27538[(30)]);
var _ = (function (){var statearr_27576 = state_27538;
(statearr_27576[(4)] = cljs.core.cons.call(null,(5),(state_27538[(4)])));

return statearr_27576;
})();
var inst_27349 = cljs.core.first.call(null,flakes);
var inst_27350__$1 = inst_27349.t;
var inst_27351 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27352 = (inst_27351 - (1));
var inst_27353 = cljs.core.not_EQ_.call(null,inst_27350__$1,inst_27352);
var state_27538__$1 = (function (){var statearr_27577 = state_27538;
(statearr_27577[(30)] = inst_27350__$1);

return statearr_27577;
})();
if(inst_27353){
var statearr_27578_27635 = state_27538__$1;
(statearr_27578_27635[(1)] = (6));

} else {
var statearr_27579_27636 = state_27538__$1;
(statearr_27579_27636[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (23))){
var inst_27381 = (state_27538[(7)]);
var state_27538__$1 = state_27538;
var statearr_27580_27637 = state_27538__$1;
(statearr_27580_27637[(2)] = inst_27381);

(statearr_27580_27637[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (35))){
var inst_27462 = (state_27538[(9)]);
var state_27538__$1 = state_27538;
var statearr_27581_27638 = state_27538__$1;
(statearr_27581_27638[(2)] = inst_27462);

(statearr_27581_27638[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (19))){
var inst_27533 = (state_27538[(2)]);
var _ = (function (){var statearr_27582 = state_27538;
(statearr_27582[(4)] = cljs.core.rest.call(null,(state_27538[(4)])));

return statearr_27582;
})();
var state_27538__$1 = state_27538;
var statearr_27583_27639 = state_27538__$1;
(statearr_27583_27639[(2)] = inst_27533);

(statearr_27583_27639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (11))){
var inst_27390 = (state_27538[(31)]);
var inst_27390__$1 = (state_27538[(2)]);
var inst_27398 = cljs.core.seq.call(null,inst_27390__$1);
var inst_27399 = cljs.core.first.call(null,inst_27398);
var inst_27400 = cljs.core.next.call(null,inst_27398);
var inst_27401 = db;
var inst_27402 = inst_27390__$1;
var inst_27403 = inst_27401;
var state_27538__$1 = (function (){var statearr_27585 = state_27538;
(statearr_27585[(37)] = inst_27402);

(statearr_27585[(22)] = inst_27403);

(statearr_27585[(31)] = inst_27390__$1);

(statearr_27585[(39)] = inst_27399);

(statearr_27585[(40)] = inst_27400);

return statearr_27585;
})();
var statearr_27586_27640 = state_27538__$1;
(statearr_27586_27640[(2)] = null);

(statearr_27586_27640[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (9))){
var inst_27367 = (state_27538[(24)]);
var inst_27384 = (state_27538[(25)]);
var inst_27386 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_27367,inst_27384);
var state_27538__$1 = state_27538;
var statearr_27587_27641 = state_27538__$1;
(statearr_27587_27641[(2)] = inst_27386);

(statearr_27587_27641[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (5))){
var _ = (function (){var statearr_27588 = state_27538;
(statearr_27588[(4)] = cljs.core.rest.call(null,(state_27538[(4)])));

return statearr_27588;
})();
var state_27538__$1 = state_27538;
var ex27584 = (state_27538__$1[(2)]);
var statearr_27589_27642 = state_27538__$1;
(statearr_27589_27642[(5)] = ex27584);


if((ex27584 instanceof Error)){
var statearr_27590_27643 = state_27538__$1;
(statearr_27590_27643[(1)] = (4));

(statearr_27590_27643[(5)] = null);

} else {
throw ex27584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (14))){
var inst_27403 = (state_27538[(22)]);
var inst_27409 = (state_27538[(38)]);
var inst_27412 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_27403,inst_27409,opts);
var state_27538__$1 = state_27538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27538__$1,(17),inst_27412);
} else {
if((state_val_27539 === (26))){
var inst_27482 = (state_27538[(15)]);
var inst_27490 = fluree.db.query.schema.schema_map.call(null,inst_27482);
var state_27538__$1 = state_27538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27538__$1,(29),inst_27490);
} else {
if((state_val_27539 === (16))){
var inst_27419 = (state_27538[(2)]);
var state_27538__$1 = state_27538;
var statearr_27591_27644 = state_27538__$1;
(statearr_27591_27644[(2)] = inst_27419);

(statearr_27591_27644[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (38))){
var inst_27463 = (state_27538[(10)]);
var state_27538__$1 = state_27538;
var statearr_27592_27645 = state_27538__$1;
(statearr_27592_27645[(2)] = inst_27463);

(statearr_27592_27645[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (30))){
var inst_27497 = (state_27538[(35)]);
var inst_27500 = fluree.db.query.schema.setting_map.call(null,inst_27497);
var state_27538__$1 = state_27538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27538__$1,(33),inst_27500);
} else {
if((state_val_27539 === (10))){
var inst_27388 = cljs.core.PersistentVector.EMPTY;
var state_27538__$1 = state_27538;
var statearr_27593_27646 = state_27538__$1;
(statearr_27593_27646[(2)] = inst_27388);

(statearr_27593_27646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (18))){
var inst_27459 = (state_27538[(21)]);
var inst_27470 = (state_27538[(33)]);
var inst_27469 = cljs.core.seq.call(null,inst_27459);
var inst_27470__$1 = cljs.core.first.call(null,inst_27469);
var inst_27471 = cljs.core.next.call(null,inst_27469);
var inst_27472 = cljs.core.not.call(null,inst_27470__$1);
var state_27538__$1 = (function (){var statearr_27594 = state_27538;
(statearr_27594[(19)] = inst_27471);

(statearr_27594[(33)] = inst_27470__$1);

return statearr_27594;
})();
if(inst_27472){
var statearr_27595_27647 = state_27538__$1;
(statearr_27595_27647[(1)] = (20));

} else {
var statearr_27596_27648 = state_27538__$1;
(statearr_27596_27648[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (37))){
var inst_27463 = (state_27538[(10)]);
var inst_27470 = (state_27538[(33)]);
var inst_27525 = cljs.core.conj.call(null,inst_27463,inst_27470);
var state_27538__$1 = state_27538;
var statearr_27597_27649 = state_27538__$1;
(statearr_27597_27649[(2)] = inst_27525);

(statearr_27597_27649[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27539 === (8))){
var inst_27381 = (state_27538[(7)]);
var inst_27367 = (state_27538[(24)]);
var inst_27371 = (state_27538[(26)]);
var inst_27365 = (state_27538[(27)]);
var inst_27375 = (state_27538[(28)]);
var inst_27350 = (state_27538[(30)]);
var inst_27365__$1 = (state_27538[(2)]);
var inst_27366 = (function (){var t = inst_27350;
var _ = inst_27365__$1;
return (function (p1__27338_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__27338_SHARP_.p));
});
})();
var inst_27367__$1 = cljs.core.filter.call(null,inst_27366,flakes);
var inst_27368 = cljs.core.PersistentHashSet.EMPTY;
var inst_27369 = (function (){var t = inst_27350;
var _ = inst_27365__$1;
var add_flakes = inst_27367__$1;
return (function (p1__27339_SHARP_){
return p1__27339_SHARP_.p;
});
})();
var inst_27370 = cljs.core.map.call(null,inst_27369,inst_27367__$1);
var inst_27371__$1 = cljs.core.into.call(null,inst_27368,inst_27370);
var inst_27372 = cljs.core.PersistentHashMap.EMPTY;
var inst_27373 = (function (){var t = inst_27350;
var _ = inst_27365__$1;
var add_flakes = inst_27367__$1;
var add_preds = inst_27371__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_27374 = cljs.core.map.call(null,inst_27373,inst_27371__$1);
var inst_27375__$1 = cljs.core.into.call(null,inst_27372,inst_27374);
var inst_27376 = cljs.core.PersistentHashMap.EMPTY;
var inst_27377 = (function (){var t = inst_27350;
var _ = inst_27365__$1;
var add_flakes = inst_27367__$1;
var add_preds = inst_27371__$1;
var idx_QMARK__map = inst_27375__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_27378 = cljs.core.map.call(null,inst_27377,inst_27371__$1);
var inst_27379 = cljs.core.into.call(null,inst_27376,inst_27378);
var inst_27380 = fluree.db.flake.size_bytes.call(null,inst_27367__$1);
var inst_27381__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_27367__$1);
var inst_27382 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_27367__$1);
var inst_27383 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27384 = cljs.core.get.call(null,inst_27383,(0));
var state_27538__$1 = (function (){var statearr_27598 = state_27538;
(statearr_27598[(7)] = inst_27381__$1);

(statearr_27598[(24)] = inst_27367__$1);

(statearr_27598[(25)] = inst_27384);

(statearr_27598[(26)] = inst_27371__$1);

(statearr_27598[(27)] = inst_27365__$1);

(statearr_27598[(28)] = inst_27375__$1);

(statearr_27598[(29)] = inst_27379);

(statearr_27598[(8)] = inst_27380);

(statearr_27598[(32)] = inst_27382);

return statearr_27598;
})();
if(cljs.core.truth_(inst_27381__$1)){
var statearr_27599_27650 = state_27538__$1;
(statearr_27599_27650[(1)] = (9));

} else {
var statearr_27600_27651 = state_27538__$1;
(statearr_27600_27651[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27601 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27601[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27601[(1)] = (1));

return statearr_27601;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27538){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27602){var ex__2749__auto__ = e27602;
var statearr_27603_27652 = state_27538;
(statearr_27603_27652[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27538[(4)]))){
var statearr_27604_27653 = state_27538;
(statearr_27604_27653[(1)] = cljs.core.first.call(null,(state_27538[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27654 = state_27538;
state_27538 = G__27654;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27538){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27605 = f__2769__auto__.call(null);
(statearr_27605[(6)] = c__2768__auto__);

return statearr_27605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__27656 = arguments.length;
switch (G__27656) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___27803 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27752){
var state_val_27753 = (state_27752[(1)]);
if((state_val_27753 === (7))){
var state_27752__$1 = state_27752;
var statearr_27754_27804 = state_27752__$1;
(statearr_27754_27804[(2)] = null);

(statearr_27754_27804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (20))){
var inst_27701 = (state_27752[(7)]);
var inst_27702 = (state_27752[(8)]);
var inst_27700 = (state_27752[(9)]);
var inst_27721 = (inst_27700 + (1));
var inst_27722 = cljs.core.assoc.call(null,inst_27702,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27721);
var inst_27723 = fluree.db.graphdb.with_t.call(null,inst_27722,inst_27701,opts);
var state_27752__$1 = state_27752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27752__$1,(23),inst_27723);
} else {
if((state_val_27753 === (1))){
var state_27752__$1 = state_27752;
var statearr_27755_27805 = state_27752__$1;
(statearr_27755_27805[(2)] = null);

(statearr_27755_27805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (24))){
var inst_27726 = (state_27752[(10)]);
var inst_27729 = cljs.core.assoc.call(null,inst_27726,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_27752__$1 = state_27752;
var statearr_27756_27806 = state_27752__$1;
(statearr_27756_27806[(2)] = inst_27729);

(statearr_27756_27806[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (4))){
var inst_27657 = (state_27752[(2)]);
var inst_27658 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_27657);
var state_27752__$1 = state_27752;
var statearr_27757_27807 = state_27752__$1;
(statearr_27757_27807[(2)] = inst_27658);

(statearr_27757_27807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (15))){
var inst_27708 = (state_27752[(11)]);
var state_27752__$1 = state_27752;
var statearr_27758_27808 = state_27752__$1;
(statearr_27758_27808[(2)] = inst_27708);

(statearr_27758_27808[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (21))){
var state_27752__$1 = state_27752;
var statearr_27759_27809 = state_27752__$1;
(statearr_27759_27809[(2)] = null);

(statearr_27759_27809[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (13))){
var inst_27744 = (state_27752[(2)]);
var inst_27745 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_27744);
var state_27752__$1 = state_27752;
var statearr_27760_27810 = state_27752__$1;
(statearr_27760_27810[(2)] = inst_27745);

(statearr_27760_27810[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (22))){
var inst_27740 = (state_27752[(2)]);
var state_27752__$1 = state_27752;
var statearr_27761_27811 = state_27752__$1;
(statearr_27761_27811[(2)] = inst_27740);

(statearr_27761_27811[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (6))){
var inst_27668 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27669 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27670 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27668)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27669)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27671 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27672 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27673 = cljs.core.PersistentHashMap.fromArrays(inst_27671,inst_27672);
var inst_27674 = cljs.core.ex_info.call(null,inst_27670,inst_27673);
var inst_27675 = (function(){throw inst_27674})();
var state_27752__$1 = state_27752;
var statearr_27764_27812 = state_27752__$1;
(statearr_27764_27812[(2)] = inst_27675);

(statearr_27764_27812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (25))){
var inst_27708 = (state_27752[(11)]);
var inst_27726 = (state_27752[(10)]);
var inst_27709 = (state_27752[(12)]);
var inst_27731 = inst_27708.t;
var inst_27732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27733 = [inst_27708];
var inst_27734 = (new cljs.core.PersistentVector(null,1,(5),inst_27732,inst_27733,null));
var inst_27699 = inst_27709;
var inst_27700 = inst_27731;
var inst_27701 = inst_27734;
var inst_27702 = inst_27726;
var state_27752__$1 = (function (){var statearr_27765 = state_27752;
(statearr_27765[(7)] = inst_27701);

(statearr_27765[(8)] = inst_27702);

(statearr_27765[(13)] = inst_27699);

(statearr_27765[(9)] = inst_27700);

return statearr_27765;
})();
var statearr_27766_27813 = state_27752__$1;
(statearr_27766_27813[(2)] = null);

(statearr_27766_27813[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (17))){
var inst_27708 = (state_27752[(11)]);
var inst_27701 = (state_27752[(7)]);
var inst_27702 = (state_27752[(8)]);
var inst_27700 = (state_27752[(9)]);
var inst_27709 = (state_27752[(12)]);
var inst_27717 = cljs.core.conj.call(null,inst_27701,inst_27708);
var tmp27762 = inst_27702;
var tmp27763 = inst_27700;
var inst_27699 = inst_27709;
var inst_27700__$1 = tmp27763;
var inst_27701__$1 = inst_27717;
var inst_27702__$1 = tmp27762;
var state_27752__$1 = (function (){var statearr_27767 = state_27752;
(statearr_27767[(7)] = inst_27701__$1);

(statearr_27767[(8)] = inst_27702__$1);

(statearr_27767[(13)] = inst_27699);

(statearr_27767[(9)] = inst_27700__$1);

return statearr_27767;
})();
var statearr_27768_27814 = state_27752__$1;
(statearr_27768_27814[(2)] = null);

(statearr_27768_27814[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (3))){
var inst_27750 = (state_27752[(2)]);
var state_27752__$1 = state_27752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27752__$1,inst_27750);
} else {
if((state_val_27753 === (12))){
var inst_27708 = (state_27752[(11)]);
var inst_27699 = (state_27752[(13)]);
var inst_27707 = cljs.core.seq.call(null,inst_27699);
var inst_27708__$1 = cljs.core.first.call(null,inst_27707);
var inst_27709 = cljs.core.next.call(null,inst_27707);
var state_27752__$1 = (function (){var statearr_27769 = state_27752;
(statearr_27769[(11)] = inst_27708__$1);

(statearr_27769[(12)] = inst_27709);

return statearr_27769;
})();
if(cljs.core.truth_(inst_27708__$1)){
var statearr_27770_27815 = state_27752__$1;
(statearr_27770_27815[(1)] = (14));

} else {
var statearr_27771_27816 = state_27752__$1;
(statearr_27771_27816[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (2))){
var _ = (function (){var statearr_27772 = state_27752;
(statearr_27772[(4)] = cljs.core.cons.call(null,(5),(state_27752[(4)])));

return statearr_27772;
})();
var inst_27664 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27665 = (inst_27664 + (1));
var inst_27666 = cljs.core.not_EQ_.call(null,block,inst_27665);
var state_27752__$1 = state_27752;
if(inst_27666){
var statearr_27773_27817 = state_27752__$1;
(statearr_27773_27817[(1)] = (6));

} else {
var statearr_27774_27818 = state_27752__$1;
(statearr_27774_27818[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (23))){
var inst_27708 = (state_27752[(11)]);
var inst_27725 = (state_27752[(2)]);
var inst_27726 = fluree.db.util.async.throw_err.call(null,inst_27725);
var inst_27727 = (inst_27708 == null);
var state_27752__$1 = (function (){var statearr_27775 = state_27752;
(statearr_27775[(10)] = inst_27726);

return statearr_27775;
})();
if(cljs.core.truth_(inst_27727)){
var statearr_27776_27819 = state_27752__$1;
(statearr_27776_27819[(1)] = (24));

} else {
var statearr_27777_27820 = state_27752__$1;
(statearr_27777_27820[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (19))){
var inst_27742 = (state_27752[(2)]);
var state_27752__$1 = state_27752;
var statearr_27778_27821 = state_27752__$1;
(statearr_27778_27821[(2)] = inst_27742);

(statearr_27778_27821[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (11))){
var inst_27747 = (state_27752[(2)]);
var _ = (function (){var statearr_27780 = state_27752;
(statearr_27780[(4)] = cljs.core.rest.call(null,(state_27752[(4)])));

return statearr_27780;
})();
var state_27752__$1 = state_27752;
var statearr_27781_27822 = state_27752__$1;
(statearr_27781_27822[(2)] = inst_27747);

(statearr_27781_27822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (9))){
var inst_27681 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_27682 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_27681);
var state_27752__$1 = state_27752;
var statearr_27782_27823 = state_27752__$1;
(statearr_27782_27823[(2)] = inst_27682);

(statearr_27782_27823[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (5))){
var _ = (function (){var statearr_27783 = state_27752;
(statearr_27783[(4)] = cljs.core.rest.call(null,(state_27752[(4)])));

return statearr_27783;
})();
var state_27752__$1 = state_27752;
var ex27779 = (state_27752__$1[(2)]);
var statearr_27784_27824 = state_27752__$1;
(statearr_27784_27824[(5)] = ex27779);


var statearr_27785_27825 = state_27752__$1;
(statearr_27785_27825[(1)] = (4));

(statearr_27785_27825[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (14))){
var inst_27708 = (state_27752[(11)]);
var inst_27700 = (state_27752[(9)]);
var inst_27711 = inst_27708.t;
var inst_27712 = cljs.core._EQ_.call(null,inst_27700,inst_27711);
var state_27752__$1 = state_27752;
var statearr_27786_27826 = state_27752__$1;
(statearr_27786_27826[(2)] = inst_27712);

(statearr_27786_27826[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (26))){
var inst_27737 = (state_27752[(2)]);
var state_27752__$1 = state_27752;
var statearr_27787_27827 = state_27752__$1;
(statearr_27787_27827[(2)] = inst_27737);

(statearr_27787_27827[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (16))){
var inst_27715 = (state_27752[(2)]);
var state_27752__$1 = state_27752;
if(cljs.core.truth_(inst_27715)){
var statearr_27788_27828 = state_27752__$1;
(statearr_27788_27828[(1)] = (17));

} else {
var statearr_27789_27829 = state_27752__$1;
(statearr_27789_27829[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (10))){
var inst_27684 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_27685 = cljs.core.first.call(null,inst_27684);
var inst_27693 = cljs.core.seq.call(null,inst_27684);
var inst_27694 = cljs.core.first.call(null,inst_27693);
var inst_27695 = cljs.core.next.call(null,inst_27693);
var inst_27696 = inst_27685.t;
var inst_27697 = cljs.core.PersistentVector.EMPTY;
var inst_27698 = db;
var inst_27699 = inst_27684;
var inst_27700 = inst_27696;
var inst_27701 = inst_27697;
var inst_27702 = inst_27698;
var state_27752__$1 = (function (){var statearr_27790 = state_27752;
(statearr_27790[(7)] = inst_27701);

(statearr_27790[(8)] = inst_27702);

(statearr_27790[(14)] = inst_27694);

(statearr_27790[(13)] = inst_27699);

(statearr_27790[(9)] = inst_27700);

(statearr_27790[(15)] = inst_27695);

return statearr_27790;
})();
var statearr_27791_27830 = state_27752__$1;
(statearr_27791_27830[(2)] = null);

(statearr_27791_27830[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (18))){
var state_27752__$1 = state_27752;
var statearr_27792_27831 = state_27752__$1;
(statearr_27792_27831[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27753 === (8))){
var inst_27678 = (state_27752[(2)]);
var inst_27679 = cljs.core.empty_QMARK_.call(null,flakes);
var state_27752__$1 = (function (){var statearr_27794 = state_27752;
(statearr_27794[(16)] = inst_27678);

return statearr_27794;
})();
if(inst_27679){
var statearr_27795_27832 = state_27752__$1;
(statearr_27795_27832[(1)] = (9));

} else {
var statearr_27796_27833 = state_27752__$1;
(statearr_27796_27833[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27797 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27797[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27797[(1)] = (1));

return statearr_27797;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27752){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27798){var ex__2749__auto__ = e27798;
var statearr_27799_27834 = state_27752;
(statearr_27799_27834[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27752[(4)]))){
var statearr_27800_27835 = state_27752;
(statearr_27800_27835[(1)] = cljs.core.first.call(null,(state_27752[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27836 = state_27752;
state_27752 = G__27836;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27752){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27801 = f__2769__auto__.call(null);
(statearr_27801[(6)] = c__2768__auto___27803);

return statearr_27801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27892){
var state_val_27893 = (state_27892[(1)]);
if((state_val_27893 === (7))){
var state_27892__$1 = state_27892;
var statearr_27894_27921 = state_27892__$1;
(statearr_27894_27921[(2)] = tt_id);

(statearr_27894_27921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (1))){
var state_27892__$1 = state_27892;
var statearr_27895_27922 = state_27892__$1;
(statearr_27895_27922[(2)] = null);

(statearr_27895_27922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (4))){
var inst_27837 = (state_27892[(2)]);
var state_27892__$1 = state_27892;
var statearr_27896_27923 = state_27892__$1;
(statearr_27896_27923[(2)] = inst_27837);

(statearr_27896_27923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (13))){
var inst_27885 = (state_27892[(2)]);
var state_27892__$1 = state_27892;
var statearr_27897_27924 = state_27892__$1;
(statearr_27897_27924[(2)] = inst_27885);

(statearr_27897_27924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (6))){
var inst_27845 = fluree.db.util.core.random_uuid.call(null);
var state_27892__$1 = state_27892;
var statearr_27898_27925 = state_27892__$1;
(statearr_27898_27925[(2)] = inst_27845);

(statearr_27898_27925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (3))){
var inst_27890 = (state_27892[(2)]);
var state_27892__$1 = state_27892;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27892__$1,inst_27890);
} else {
if((state_val_27893 === (12))){
var inst_27868 = (state_27892[(7)]);
var state_27892__$1 = state_27892;
var statearr_27899_27926 = state_27892__$1;
(statearr_27899_27926[(2)] = inst_27868);

(statearr_27899_27926[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (2))){
var _ = (function (){var statearr_27900 = state_27892;
(statearr_27900[(4)] = cljs.core.cons.call(null,(5),(state_27892[(4)])));

return statearr_27900;
})();
var inst_27843 = (tt_id == null);
var state_27892__$1 = state_27892;
if(cljs.core.truth_(inst_27843)){
var statearr_27901_27927 = state_27892__$1;
(statearr_27901_27927[(1)] = (6));

} else {
var statearr_27902_27928 = state_27892__$1;
(statearr_27902_27928[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (11))){
var inst_27868 = (state_27892[(7)]);
var inst_27875 = (state_27892[(8)]);
var inst_27878 = fluree.db.graphdb.with_t.call(null,inst_27868,inst_27875);
var state_27892__$1 = state_27892;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27892__$1,(14),inst_27878);
} else {
if((state_val_27893 === (9))){
var inst_27869 = (state_27892[(9)]);
var inst_27875 = (state_27892[(8)]);
var inst_27874 = cljs.core.seq.call(null,inst_27869);
var inst_27875__$1 = cljs.core.first.call(null,inst_27874);
var inst_27876 = cljs.core.next.call(null,inst_27874);
var state_27892__$1 = (function (){var statearr_27904 = state_27892;
(statearr_27904[(8)] = inst_27875__$1);

(statearr_27904[(10)] = inst_27876);

return statearr_27904;
})();
if(cljs.core.truth_(inst_27875__$1)){
var statearr_27905_27929 = state_27892__$1;
(statearr_27905_27929[(1)] = (11));

} else {
var statearr_27906_27930 = state_27892__$1;
(statearr_27906_27930[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (5))){
var _ = (function (){var statearr_27907 = state_27892;
(statearr_27907[(4)] = cljs.core.rest.call(null,(state_27892[(4)])));

return statearr_27907;
})();
var state_27892__$1 = state_27892;
var ex27903 = (state_27892__$1[(2)]);
var statearr_27908_27931 = state_27892__$1;
(statearr_27908_27931[(5)] = ex27903);


if((ex27903 instanceof Error)){
var statearr_27909_27932 = state_27892__$1;
(statearr_27909_27932[(1)] = (4));

(statearr_27909_27932[(5)] = null);

} else {
throw ex27903;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (14))){
var inst_27876 = (state_27892[(10)]);
var inst_27880 = (state_27892[(2)]);
var inst_27881 = fluree.db.util.async.throw_err.call(null,inst_27880);
var inst_27868 = inst_27881;
var inst_27869 = inst_27876;
var state_27892__$1 = (function (){var statearr_27910 = state_27892;
(statearr_27910[(7)] = inst_27868);

(statearr_27910[(9)] = inst_27869);

return statearr_27910;
})();
var statearr_27911_27933 = state_27892__$1;
(statearr_27911_27933[(2)] = null);

(statearr_27911_27933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (10))){
var inst_27887 = (state_27892[(2)]);
var _ = (function (){var statearr_27912 = state_27892;
(statearr_27912[(4)] = cljs.core.rest.call(null,(state_27892[(4)])));

return statearr_27912;
})();
var state_27892__$1 = state_27892;
var statearr_27913_27934 = state_27892__$1;
(statearr_27913_27934[(2)] = inst_27887);

(statearr_27913_27934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27893 === (8))){
var inst_27848 = (state_27892[(2)]);
var inst_27849 = (function (){var tt_id_SINGLEQUOTE_ = inst_27848;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27850 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27848);
var inst_27851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27852 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27853 = (new cljs.core.PersistentVector(null,4,(5),inst_27851,inst_27852,null));
var inst_27854 = cljs.core.reduce.call(null,inst_27849,inst_27850,inst_27853);
var inst_27855 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27856 = cljs.core.reverse.call(null,inst_27855);
var inst_27857 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27856);
var inst_27865 = cljs.core.seq.call(null,inst_27857);
var inst_27866 = cljs.core.first.call(null,inst_27865);
var inst_27867 = cljs.core.next.call(null,inst_27865);
var inst_27868 = inst_27854;
var inst_27869 = inst_27857;
var state_27892__$1 = (function (){var statearr_27914 = state_27892;
(statearr_27914[(11)] = inst_27867);

(statearr_27914[(7)] = inst_27868);

(statearr_27914[(9)] = inst_27869);

(statearr_27914[(12)] = inst_27866);

return statearr_27914;
})();
var statearr_27915_27935 = state_27892__$1;
(statearr_27915_27935[(2)] = null);

(statearr_27915_27935[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0 = (function (){
var statearr_27916 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27916[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__);

(statearr_27916[(1)] = (1));

return statearr_27916;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1 = (function (state_27892){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27892);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27917){var ex__2749__auto__ = e27917;
var statearr_27918_27936 = state_27892;
(statearr_27918_27936[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27892[(4)]))){
var statearr_27919_27937 = state_27892;
(statearr_27919_27937[(1)] = cljs.core.first.call(null,(state_27892[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27938 = state_27892;
state_27892 = G__27938;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = function(state_27892){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1.call(this,state_27892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27920 = f__2769__auto__.call(null);
(statearr_27920[(6)] = c__2768__auto__);

return statearr_27920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2768__auto___28125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28056){
var state_val_28057 = (state_28056[(1)]);
if((state_val_28057 === (7))){
var inst_27966 = (state_28056[(7)]);
var inst_27966__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_28056__$1 = (function (){var statearr_28058 = state_28056;
(statearr_28058[(7)] = inst_27966__$1);

return statearr_28058;
})();
if(inst_27966__$1){
var statearr_28059_28126 = state_28056__$1;
(statearr_28059_28126[(1)] = (13));

} else {
var statearr_28060_28127 = state_28056__$1;
(statearr_28060_28127[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (20))){
var state_28056__$1 = state_28056;
var statearr_28061_28128 = state_28056__$1;
(statearr_28061_28128[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (27))){
var inst_28002 = (state_28056[(8)]);
var inst_28006 = inst_28002.s;
var state_28056__$1 = state_28056;
var statearr_28063_28129 = state_28056__$1;
(statearr_28063_28129[(2)] = inst_28006);

(statearr_28063_28129[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (1))){
var state_28056__$1 = state_28056;
var statearr_28064_28130 = state_28056__$1;
(statearr_28064_28130[(2)] = null);

(statearr_28064_28130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (24))){
var inst_27996 = (state_28056[(9)]);
var inst_28000 = cljs.core.first.call(null,inst_27996);
var state_28056__$1 = state_28056;
var statearr_28065_28131 = state_28056__$1;
(statearr_28065_28131[(2)] = inst_28000);

(statearr_28065_28131[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (39))){
var state_28056__$1 = state_28056;
var statearr_28066_28132 = state_28056__$1;
(statearr_28066_28132[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (4))){
var inst_27939 = (state_28056[(2)]);
var inst_27940 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27941 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27942 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27943 = cljs.core.PersistentHashMap.fromArrays(inst_27941,inst_27942);
var inst_27944 = cljs.core.ex_info.call(null,inst_27940,inst_27943,inst_27939);
var inst_27945 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27944);
var state_28056__$1 = state_28056;
var statearr_28068_28133 = state_28056__$1;
(statearr_28068_28133[(2)] = inst_27945);

(statearr_28068_28133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (15))){
var inst_27973 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
if(cljs.core.truth_(inst_27973)){
var statearr_28069_28134 = state_28056__$1;
(statearr_28069_28134[(1)] = (16));

} else {
var statearr_28070_28135 = state_28056__$1;
(statearr_28070_28135[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (21))){
var inst_28022 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28071_28136 = state_28056__$1;
(statearr_28071_28136[(2)] = inst_28022);

(statearr_28071_28136[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (31))){
var inst_28020 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28072_28137 = state_28056__$1;
(statearr_28072_28137[(2)] = inst_28020);

(statearr_28072_28137[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (32))){
var inst_28026 = (state_28056[(10)]);
var inst_28028 = cljs.core.async.put_BANG_.call(null,return_chan,inst_28026);
var state_28056__$1 = state_28056;
var statearr_28073_28138 = state_28056__$1;
(statearr_28073_28138[(2)] = inst_28028);

(statearr_28073_28138[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (40))){
var inst_28049 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28074_28139 = state_28056__$1;
(statearr_28074_28139[(2)] = inst_28049);

(statearr_28074_28139[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (33))){
var inst_28026 = (state_28056[(10)]);
var inst_28030 = (state_28056[(11)]);
var inst_28030__$1 = (inst_28026 == null);
var state_28056__$1 = (function (){var statearr_28075 = state_28056;
(statearr_28075[(11)] = inst_28030__$1);

return statearr_28075;
})();
if(cljs.core.truth_(inst_28030__$1)){
var statearr_28076_28140 = state_28056__$1;
(statearr_28076_28140[(1)] = (35));

} else {
var statearr_28077_28141 = state_28056__$1;
(statearr_28077_28141[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (13))){
var inst_27968 = cljs.core.first.call(null,ident);
var inst_27969 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27968);
var inst_27970 = (inst_27969 == null);
var state_28056__$1 = state_28056;
var statearr_28078_28142 = state_28056__$1;
(statearr_28078_28142[(2)] = inst_27970);

(statearr_28078_28142[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (22))){
var inst_27996 = (state_28056[(9)]);
var inst_27995 = (state_28056[(2)]);
var inst_27996__$1 = fluree.db.util.async.throw_err.call(null,inst_27995);
var inst_27997 = (inst_27996__$1 == null);
var state_28056__$1 = (function (){var statearr_28079 = state_28056;
(statearr_28079[(9)] = inst_27996__$1);

return statearr_28079;
})();
if(cljs.core.truth_(inst_27997)){
var statearr_28080_28143 = state_28056__$1;
(statearr_28080_28143[(1)] = (23));

} else {
var statearr_28081_28144 = state_28056__$1;
(statearr_28081_28144[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (36))){
var inst_28030 = (state_28056[(11)]);
var state_28056__$1 = state_28056;
var statearr_28082_28145 = state_28056__$1;
(statearr_28082_28145[(2)] = inst_28030);

(statearr_28082_28145[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (41))){
var inst_28044 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_28056__$1 = state_28056;
var statearr_28083_28146 = state_28056__$1;
(statearr_28083_28146[(2)] = inst_28044);

(statearr_28083_28146[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (43))){
var inst_28047 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28084_28147 = state_28056__$1;
(statearr_28084_28147[(2)] = inst_28047);

(statearr_28084_28147[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (29))){
var inst_28011 = cljs.core.pr_str.call(null,ident);
var inst_28012 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_28011].join('');
var inst_28013 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28014 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_28015 = cljs.core.PersistentHashMap.fromArrays(inst_28013,inst_28014);
var inst_28016 = cljs.core.ex_info.call(null,inst_28012,inst_28015);
var inst_28017 = (function(){throw inst_28016})();
var state_28056__$1 = state_28056;
var statearr_28085_28148 = state_28056__$1;
(statearr_28085_28148[(2)] = inst_28017);

(statearr_28085_28148[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (6))){
var inst_27953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27954 = [ident];
var inst_27955 = (new cljs.core.PersistentVector(null,1,(5),inst_27953,inst_27954,null));
var inst_27956 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27955);
var state_28056__$1 = state_28056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28056__$1,(9),inst_27956);
} else {
if((state_val_28057 === (28))){
var inst_28008 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28086_28149 = state_28056__$1;
(statearr_28086_28149[(2)] = inst_28008);

(statearr_28086_28149[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (25))){
var inst_28002 = (state_28056[(8)]);
var inst_28002__$1 = (state_28056[(2)]);
var inst_28003 = (inst_28002__$1 == null);
var state_28056__$1 = (function (){var statearr_28087 = state_28056;
(statearr_28087[(8)] = inst_28002__$1);

return statearr_28087;
})();
if(cljs.core.truth_(inst_28003)){
var statearr_28088_28150 = state_28056__$1;
(statearr_28088_28150[(1)] = (26));

} else {
var statearr_28089_28151 = state_28056__$1;
(statearr_28089_28151[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (34))){
var inst_28051 = (state_28056[(2)]);
var _ = (function (){var statearr_28090 = state_28056;
(statearr_28090[(4)] = cljs.core.rest.call(null,(state_28056[(4)])));

return statearr_28090;
})();
var state_28056__$1 = state_28056;
var statearr_28091_28152 = state_28056__$1;
(statearr_28091_28152[(2)] = inst_28051);

(statearr_28091_28152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (17))){
var inst_27984 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_28056__$1 = state_28056;
if(inst_27984){
var statearr_28092_28153 = state_28056__$1;
(statearr_28092_28153[(1)] = (19));

} else {
var statearr_28093_28154 = state_28056__$1;
(statearr_28093_28154[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (3))){
var inst_28054 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28056__$1,inst_28054);
} else {
if((state_val_28057 === (12))){
var inst_27964 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28094_28155 = state_28056__$1;
(statearr_28094_28155[(2)] = inst_27964);

(statearr_28094_28155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (2))){
var _ = (function (){var statearr_28095 = state_28056;
(statearr_28095[(4)] = cljs.core.cons.call(null,(5),(state_28056[(4)])));

return statearr_28095;
})();
var inst_27951 = typeof ident === 'number';
var state_28056__$1 = state_28056;
if(cljs.core.truth_(inst_27951)){
var statearr_28096_28156 = state_28056__$1;
(statearr_28096_28156[(1)] = (6));

} else {
var statearr_28097_28157 = state_28056__$1;
(statearr_28097_28157[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (23))){
var state_28056__$1 = state_28056;
var statearr_28098_28158 = state_28056__$1;
(statearr_28098_28158[(2)] = null);

(statearr_28098_28158[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (35))){
var state_28056__$1 = state_28056;
var statearr_28099_28159 = state_28056__$1;
(statearr_28099_28159[(2)] = strict_QMARK_);

(statearr_28099_28159[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (19))){
var inst_27987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27988 = cljs.core.first.call(null,ident);
var inst_27989 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27988);
var inst_27990 = cljs.core.second.call(null,ident);
var inst_27991 = [inst_27989,inst_27990];
var inst_27992 = (new cljs.core.PersistentVector(null,2,(5),inst_27987,inst_27991,null));
var inst_27993 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27992);
var state_28056__$1 = state_28056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28056__$1,(22),inst_27993);
} else {
if((state_val_28057 === (11))){
var state_28056__$1 = state_28056;
var statearr_28101_28160 = state_28056__$1;
(statearr_28101_28160[(2)] = null);

(statearr_28101_28160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (9))){
var inst_27958 = (state_28056[(2)]);
var inst_27959 = fluree.db.util.async.throw_err.call(null,inst_27958);
var inst_27960 = cljs.core.not_empty.call(null,inst_27959);
var state_28056__$1 = state_28056;
if(cljs.core.truth_(inst_27960)){
var statearr_28102_28161 = state_28056__$1;
(statearr_28102_28161[(1)] = (10));

} else {
var statearr_28103_28162 = state_28056__$1;
(statearr_28103_28162[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (5))){
var _ = (function (){var statearr_28104 = state_28056;
(statearr_28104[(4)] = cljs.core.rest.call(null,(state_28056[(4)])));

return statearr_28104;
})();
var state_28056__$1 = state_28056;
var ex28100 = (state_28056__$1[(2)]);
var statearr_28105_28163 = state_28056__$1;
(statearr_28105_28163[(5)] = ex28100);


var statearr_28106_28164 = state_28056__$1;
(statearr_28106_28164[(1)] = (4));

(statearr_28106_28164[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (14))){
var inst_27966 = (state_28056[(7)]);
var state_28056__$1 = state_28056;
var statearr_28107_28165 = state_28056__$1;
(statearr_28107_28165[(2)] = inst_27966);

(statearr_28107_28165[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (26))){
var state_28056__$1 = state_28056;
var statearr_28108_28166 = state_28056__$1;
(statearr_28108_28166[(2)] = null);

(statearr_28108_28166[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (16))){
var inst_27975 = cljs.core.first.call(null,ident);
var inst_27976 = cljs.core.pr_str.call(null,inst_27975);
var inst_27977 = ["Subject ID lookup failed. The predicate ",inst_27976," does not exist."].join('');
var inst_27978 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27979 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27980 = cljs.core.PersistentHashMap.fromArrays(inst_27978,inst_27979);
var inst_27981 = cljs.core.ex_info.call(null,inst_27977,inst_27980);
var inst_27982 = (function(){throw inst_27981})();
var state_28056__$1 = state_28056;
var statearr_28109_28167 = state_28056__$1;
(statearr_28109_28167[(2)] = inst_27982);

(statearr_28109_28167[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (38))){
var inst_28036 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_28037 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28038 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_28039 = cljs.core.PersistentHashMap.fromArrays(inst_28037,inst_28038);
var inst_28040 = cljs.core.ex_info.call(null,inst_28036,inst_28039);
var inst_28041 = cljs.core.async.put_BANG_.call(null,return_chan,inst_28040);
var state_28056__$1 = state_28056;
var statearr_28110_28168 = state_28056__$1;
(statearr_28110_28168[(2)] = inst_28041);

(statearr_28110_28168[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (30))){
var state_28056__$1 = state_28056;
var statearr_28111_28169 = state_28056__$1;
(statearr_28111_28169[(2)] = null);

(statearr_28111_28169[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (10))){
var state_28056__$1 = state_28056;
var statearr_28112_28170 = state_28056__$1;
(statearr_28112_28170[(2)] = ident);

(statearr_28112_28170[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (18))){
var inst_28024 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28113_28171 = state_28056__$1;
(statearr_28113_28171[(2)] = inst_28024);

(statearr_28113_28171[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (42))){
var state_28056__$1 = state_28056;
var statearr_28114_28172 = state_28056__$1;
(statearr_28114_28172[(2)] = null);

(statearr_28114_28172[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (37))){
var inst_28034 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
if(cljs.core.truth_(inst_28034)){
var statearr_28115_28173 = state_28056__$1;
(statearr_28115_28173[(1)] = (38));

} else {
var statearr_28116_28174 = state_28056__$1;
(statearr_28116_28174[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (8))){
var inst_28026 = (state_28056[(10)]);
var inst_28026__$1 = (state_28056[(2)]);
var state_28056__$1 = (function (){var statearr_28117 = state_28056;
(statearr_28117[(10)] = inst_28026__$1);

return statearr_28117;
})();
if(cljs.core.truth_(inst_28026__$1)){
var statearr_28118_28175 = state_28056__$1;
(statearr_28118_28175[(1)] = (32));

} else {
var statearr_28119_28176 = state_28056__$1;
(statearr_28119_28176[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_28120 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28120[(0)] = fluree$db$graphdb$subid_$_state_machine__2746__auto__);

(statearr_28120[(1)] = (1));

return statearr_28120;
});
var fluree$db$graphdb$subid_$_state_machine__2746__auto____1 = (function (state_28056){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28121){var ex__2749__auto__ = e28121;
var statearr_28122_28177 = state_28056;
(statearr_28122_28177[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28056[(4)]))){
var statearr_28123_28178 = state_28056;
(statearr_28123_28178[(1)] = cljs.core.first.call(null,(state_28056[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28179 = state_28056;
state_28056 = G__28179;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2746__auto__ = function(state_28056){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____1.call(this,state_28056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2746__auto____0;
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2746__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28124 = f__2769__auto__.call(null);
(statearr_28124[(6)] = c__2768__auto___28125);

return statearr_28124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__28180){
var map__28181 = p__28180;
var map__28181__$1 = cljs.core.__destructure_map.call(null,map__28181);
var db = map__28181__$1;
var current_db_fn = cljs.core.get.call(null,map__28181__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__28181__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28197){
var state_val_28198 = (state_28197[(1)]);
if((state_val_28198 === (1))){
var state_28197__$1 = state_28197;
var statearr_28199_28213 = state_28197__$1;
(statearr_28199_28213[(2)] = null);

(statearr_28199_28213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28198 === (2))){
var _ = (function (){var statearr_28200 = state_28197;
(statearr_28200[(4)] = cljs.core.cons.call(null,(5),(state_28197[(4)])));

return statearr_28200;
})();
var inst_28188 = current_db_fn.call(null,db);
var state_28197__$1 = state_28197;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28197__$1,(6),inst_28188);
} else {
if((state_val_28198 === (3))){
var inst_28195 = (state_28197[(2)]);
var state_28197__$1 = state_28197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28197__$1,inst_28195);
} else {
if((state_val_28198 === (4))){
var inst_28182 = (state_28197[(2)]);
var state_28197__$1 = state_28197;
var statearr_28202_28214 = state_28197__$1;
(statearr_28202_28214[(2)] = inst_28182);

(statearr_28202_28214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28198 === (5))){
var _ = (function (){var statearr_28203 = state_28197;
(statearr_28203[(4)] = cljs.core.rest.call(null,(state_28197[(4)])));

return statearr_28203;
})();
var state_28197__$1 = state_28197;
var ex28201 = (state_28197__$1[(2)]);
var statearr_28204_28215 = state_28197__$1;
(statearr_28204_28215[(5)] = ex28201);


if((ex28201 instanceof Error)){
var statearr_28205_28216 = state_28197__$1;
(statearr_28205_28216[(1)] = (4));

(statearr_28205_28216[(5)] = null);

} else {
throw ex28201;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28198 === (6))){
var inst_28190 = (state_28197[(2)]);
var inst_28191 = fluree.db.util.async.throw_err.call(null,inst_28190);
var inst_28192 = cljs.core.assoc.call(null,inst_28191,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_28206 = state_28197;
(statearr_28206[(4)] = cljs.core.rest.call(null,(state_28197[(4)])));

return statearr_28206;
})();
var state_28197__$1 = state_28197;
var statearr_28207_28217 = state_28197__$1;
(statearr_28207_28217[(2)] = inst_28192);

(statearr_28207_28217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0 = (function (){
var statearr_28208 = [null,null,null,null,null,null,null];
(statearr_28208[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__);

(statearr_28208[(1)] = (1));

return statearr_28208;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1 = (function (state_28197){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28209){var ex__2749__auto__ = e28209;
var statearr_28210_28218 = state_28197;
(statearr_28210_28218[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28197[(4)]))){
var statearr_28211_28219 = state_28197;
(statearr_28211_28219[(1)] = cljs.core.first.call(null,(state_28197[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28220 = state_28197;
state_28197 = G__28220;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = function(state_28197){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1.call(this,state_28197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28212 = f__2769__auto__.call(null);
(statearr_28212[(6)] = c__2768__auto__);

return statearr_28212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__28221,property,collection){
var map__28222 = p__28221;
var map__28222__$1 = cljs.core.__destructure_map.call(null,map__28222);
var schema = cljs.core.get.call(null,map__28222__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__28223,property,predicate){
var map__28224 = p__28223;
var map__28224__$1 = cljs.core.__destructure_map.call(null,map__28224);
var this$ = map__28224__$1;
var schema = cljs.core.get.call(null,map__28224__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__28225 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__28225);
} else {
return G__28225;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__28227 = arguments.length;
switch (G__28227) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28259){
var state_val_28260 = (state_28259[(1)]);
if((state_val_28260 === (7))){
var state_28259__$1 = state_28259;
var statearr_28261_28355 = state_28259__$1;
(statearr_28261_28355[(2)] = null);

(statearr_28261_28355[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (1))){
var state_28259__$1 = state_28259;
var statearr_28262_28356 = state_28259__$1;
(statearr_28262_28356[(2)] = null);

(statearr_28262_28356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (4))){
var inst_28228 = (state_28259[(2)]);
var state_28259__$1 = state_28259;
var statearr_28263_28357 = state_28259__$1;
(statearr_28263_28357[(2)] = inst_28228);

(statearr_28263_28357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (6))){
var inst_28242 = (state_28259[(7)]);
var inst_28241 = (state_28259[(2)]);
var inst_28242__$1 = fluree.db.util.async.throw_err.call(null,inst_28241);
var inst_28243 = (inst_28242__$1 == null);
var state_28259__$1 = (function (){var statearr_28264 = state_28259;
(statearr_28264[(7)] = inst_28242__$1);

return statearr_28264;
})();
if(cljs.core.truth_(inst_28243)){
var statearr_28265_28358 = state_28259__$1;
(statearr_28265_28358[(1)] = (7));

} else {
var statearr_28266_28359 = state_28259__$1;
(statearr_28266_28359[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (3))){
var inst_28257 = (state_28259[(2)]);
var state_28259__$1 = state_28259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28259__$1,inst_28257);
} else {
if((state_val_28260 === (12))){
var inst_28254 = (state_28259[(2)]);
var _ = (function (){var statearr_28267 = state_28259;
(statearr_28267[(4)] = cljs.core.rest.call(null,(state_28259[(4)])));

return statearr_28267;
})();
var state_28259__$1 = state_28259;
var statearr_28268_28360 = state_28259__$1;
(statearr_28268_28360[(2)] = inst_28254);

(statearr_28268_28360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (2))){
var _ = (function (){var statearr_28269 = state_28259;
(statearr_28269[(4)] = cljs.core.cons.call(null,(5),(state_28259[(4)])));

return statearr_28269;
})();
var inst_28235 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_28236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28237 = [tag_id,(30)];
var inst_28238 = (new cljs.core.PersistentVector(null,2,(5),inst_28236,inst_28237,null));
var inst_28239 = fluree.db.query.range.index_range.call(null,inst_28235,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28238);
var state_28259__$1 = state_28259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28259__$1,(6),inst_28239);
} else {
if((state_val_28260 === (11))){
var inst_28248 = (state_28259[(8)]);
var inst_28252 = inst_28248.o;
var state_28259__$1 = state_28259;
var statearr_28271_28361 = state_28259__$1;
(statearr_28271_28361[(2)] = inst_28252);

(statearr_28271_28361[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (9))){
var inst_28248 = (state_28259[(8)]);
var inst_28248__$1 = (state_28259[(2)]);
var inst_28249 = (inst_28248__$1 == null);
var state_28259__$1 = (function (){var statearr_28272 = state_28259;
(statearr_28272[(8)] = inst_28248__$1);

return statearr_28272;
})();
if(cljs.core.truth_(inst_28249)){
var statearr_28273_28362 = state_28259__$1;
(statearr_28273_28362[(1)] = (10));

} else {
var statearr_28274_28363 = state_28259__$1;
(statearr_28274_28363[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (5))){
var _ = (function (){var statearr_28275 = state_28259;
(statearr_28275[(4)] = cljs.core.rest.call(null,(state_28259[(4)])));

return statearr_28275;
})();
var state_28259__$1 = state_28259;
var ex28270 = (state_28259__$1[(2)]);
var statearr_28276_28364 = state_28259__$1;
(statearr_28276_28364[(5)] = ex28270);


if((ex28270 instanceof Error)){
var statearr_28277_28365 = state_28259__$1;
(statearr_28277_28365[(1)] = (4));

(statearr_28277_28365[(5)] = null);

} else {
throw ex28270;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (10))){
var state_28259__$1 = state_28259;
var statearr_28278_28366 = state_28259__$1;
(statearr_28278_28366[(2)] = null);

(statearr_28278_28366[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28260 === (8))){
var inst_28242 = (state_28259[(7)]);
var inst_28246 = cljs.core.first.call(null,inst_28242);
var state_28259__$1 = state_28259;
var statearr_28279_28367 = state_28259__$1;
(statearr_28279_28367[(2)] = inst_28246);

(statearr_28279_28367[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_28280 = [null,null,null,null,null,null,null,null,null];
(statearr_28280[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_28280[(1)] = (1));

return statearr_28280;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_28259){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28281){var ex__2749__auto__ = e28281;
var statearr_28282_28368 = state_28259;
(statearr_28282_28368[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28259[(4)]))){
var statearr_28283_28369 = state_28259;
(statearr_28283_28369[(1)] = cljs.core.first.call(null,(state_28259[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28370 = state_28259;
state_28259 = G__28370;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_28259){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_28259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28284 = f__2769__auto__.call(null);
(statearr_28284[(6)] = c__2768__auto__);

return statearr_28284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28320){
var state_val_28321 = (state_28320[(1)]);
if((state_val_28321 === (7))){
var inst_28294 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28320__$1 = state_28320;
var statearr_28322_28371 = state_28320__$1;
(statearr_28322_28371[(2)] = inst_28294);

(statearr_28322_28371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (1))){
var state_28320__$1 = state_28320;
var statearr_28323_28372 = state_28320__$1;
(statearr_28323_28372[(2)] = null);

(statearr_28323_28372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (4))){
var inst_28285 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28324_28373 = state_28320__$1;
(statearr_28324_28373[(2)] = inst_28285);

(statearr_28324_28373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (15))){
var inst_28315 = (state_28320[(2)]);
var _ = (function (){var statearr_28325 = state_28320;
(statearr_28325[(4)] = cljs.core.rest.call(null,(state_28320[(4)])));

return statearr_28325;
})();
var state_28320__$1 = state_28320;
var statearr_28326_28374 = state_28320__$1;
(statearr_28326_28374[(2)] = inst_28315);

(statearr_28326_28374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (13))){
var inst_28300 = (state_28320[(7)]);
var inst_28306 = clojure.string.includes_QMARK_.call(null,inst_28300,":");
var state_28320__$1 = state_28320;
if(inst_28306){
var statearr_28327_28375 = state_28320__$1;
(statearr_28327_28375[(1)] = (16));

} else {
var statearr_28328_28376 = state_28320__$1;
(statearr_28328_28376[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (6))){
var state_28320__$1 = state_28320;
var statearr_28329_28377 = state_28320__$1;
(statearr_28329_28377[(2)] = pred);

(statearr_28329_28377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (17))){
var inst_28300 = (state_28320[(7)]);
var state_28320__$1 = state_28320;
var statearr_28330_28378 = state_28320__$1;
(statearr_28330_28378[(2)] = inst_28300);

(statearr_28330_28378[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (3))){
var inst_28318 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28320__$1,inst_28318);
} else {
if((state_val_28321 === (12))){
var inst_28304 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
if(cljs.core.truth_(inst_28304)){
var statearr_28331_28379 = state_28320__$1;
(statearr_28331_28379[(1)] = (13));

} else {
var statearr_28332_28380 = state_28320__$1;
(statearr_28332_28380[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (2))){
var _ = (function (){var statearr_28333 = state_28320;
(statearr_28333[(4)] = cljs.core.cons.call(null,(5),(state_28320[(4)])));

return statearr_28333;
})();
var inst_28291 = typeof pred === 'string';
var state_28320__$1 = state_28320;
if(cljs.core.truth_(inst_28291)){
var statearr_28334_28381 = state_28320__$1;
(statearr_28334_28381[(1)] = (6));

} else {
var statearr_28335_28382 = state_28320__$1;
(statearr_28335_28382[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (11))){
var inst_28296 = (state_28320[(8)]);
var state_28320__$1 = state_28320;
var statearr_28337_28383 = state_28320__$1;
(statearr_28337_28383[(2)] = inst_28296);

(statearr_28337_28383[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (9))){
var inst_28296 = (state_28320[(8)]);
var inst_28299 = (state_28320[(2)]);
var inst_28300 = fluree.db.util.async.throw_err.call(null,inst_28299);
var state_28320__$1 = (function (){var statearr_28338 = state_28320;
(statearr_28338[(7)] = inst_28300);

return statearr_28338;
})();
if(cljs.core.truth_(inst_28296)){
var statearr_28339_28384 = state_28320__$1;
(statearr_28339_28384[(1)] = (10));

} else {
var statearr_28340_28385 = state_28320__$1;
(statearr_28340_28385[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (5))){
var _ = (function (){var statearr_28341 = state_28320;
(statearr_28341[(4)] = cljs.core.rest.call(null,(state_28320[(4)])));

return statearr_28341;
})();
var state_28320__$1 = state_28320;
var ex28336 = (state_28320__$1[(2)]);
var statearr_28342_28386 = state_28320__$1;
(statearr_28342_28386[(5)] = ex28336);


if((ex28336 instanceof Error)){
var statearr_28343_28387 = state_28320__$1;
(statearr_28343_28387[(1)] = (4));

(statearr_28343_28387[(5)] = null);

} else {
throw ex28336;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (14))){
var state_28320__$1 = state_28320;
var statearr_28344_28388 = state_28320__$1;
(statearr_28344_28388[(2)] = null);

(statearr_28344_28388[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (16))){
var inst_28300 = (state_28320[(7)]);
var inst_28308 = clojure.string.split.call(null,inst_28300,/:/);
var inst_28309 = cljs.core.second.call(null,inst_28308);
var state_28320__$1 = state_28320;
var statearr_28345_28389 = state_28320__$1;
(statearr_28345_28389[(2)] = inst_28309);

(statearr_28345_28389[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (10))){
var inst_28300 = (state_28320[(7)]);
var state_28320__$1 = state_28320;
var statearr_28346_28390 = state_28320__$1;
(statearr_28346_28390[(2)] = inst_28300);

(statearr_28346_28390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (18))){
var inst_28312 = (state_28320[(2)]);
var state_28320__$1 = state_28320;
var statearr_28347_28391 = state_28320__$1;
(statearr_28347_28391[(2)] = inst_28312);

(statearr_28347_28391[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28321 === (8))){
var inst_28296 = (state_28320[(2)]);
var inst_28297 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_28320__$1 = (function (){var statearr_28348 = state_28320;
(statearr_28348[(8)] = inst_28296);

return statearr_28348;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28320__$1,(9),inst_28297);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_28349 = [null,null,null,null,null,null,null,null,null];
(statearr_28349[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_28349[(1)] = (1));

return statearr_28349;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_28320){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28350){var ex__2749__auto__ = e28350;
var statearr_28351_28392 = state_28320;
(statearr_28351_28392[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28320[(4)]))){
var statearr_28352_28393 = state_28320;
(statearr_28352_28393[(1)] = cljs.core.first.call(null,(state_28320[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28394 = state_28320;
state_28320 = G__28394;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_28320){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_28320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28353 = f__2769__auto__.call(null);
(statearr_28353[(6)] = c__2768__auto__);

return statearr_28353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__28396 = arguments.length;
switch (G__28396) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28429){
var state_val_28430 = (state_28429[(1)]);
if((state_val_28430 === (7))){
var state_28429__$1 = state_28429;
var statearr_28431_28519 = state_28429__$1;
(statearr_28431_28519[(2)] = null);

(statearr_28431_28519[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (1))){
var state_28429__$1 = state_28429;
var statearr_28432_28520 = state_28429__$1;
(statearr_28432_28520[(2)] = null);

(statearr_28432_28520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (4))){
var inst_28397 = (state_28429[(2)]);
var state_28429__$1 = state_28429;
var statearr_28433_28521 = state_28429__$1;
(statearr_28433_28521[(2)] = inst_28397);

(statearr_28433_28521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (6))){
var inst_28412 = (state_28429[(7)]);
var inst_28411 = (state_28429[(2)]);
var inst_28412__$1 = fluree.db.util.async.throw_err.call(null,inst_28411);
var inst_28413 = (inst_28412__$1 == null);
var state_28429__$1 = (function (){var statearr_28434 = state_28429;
(statearr_28434[(7)] = inst_28412__$1);

return statearr_28434;
})();
if(cljs.core.truth_(inst_28413)){
var statearr_28435_28522 = state_28429__$1;
(statearr_28435_28522[(1)] = (7));

} else {
var statearr_28436_28523 = state_28429__$1;
(statearr_28436_28523[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (3))){
var inst_28427 = (state_28429[(2)]);
var state_28429__$1 = state_28429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28429__$1,inst_28427);
} else {
if((state_val_28430 === (12))){
var inst_28424 = (state_28429[(2)]);
var _ = (function (){var statearr_28437 = state_28429;
(statearr_28437[(4)] = cljs.core.rest.call(null,(state_28429[(4)])));

return statearr_28437;
})();
var state_28429__$1 = state_28429;
var statearr_28438_28524 = state_28429__$1;
(statearr_28438_28524[(2)] = inst_28424);

(statearr_28438_28524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (2))){
var _ = (function (){var statearr_28439 = state_28429;
(statearr_28439[(4)] = cljs.core.cons.call(null,(5),(state_28429[(4)])));

return statearr_28439;
})();
var inst_28403 = (30);
var inst_28405 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_28406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28407 = [inst_28403,tag_name];
var inst_28408 = (new cljs.core.PersistentVector(null,2,(5),inst_28406,inst_28407,null));
var inst_28409 = fluree.db.query.range.index_range.call(null,inst_28405,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_28408);
var state_28429__$1 = state_28429;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28429__$1,(6),inst_28409);
} else {
if((state_val_28430 === (11))){
var inst_28418 = (state_28429[(8)]);
var inst_28422 = inst_28418.s;
var state_28429__$1 = state_28429;
var statearr_28441_28525 = state_28429__$1;
(statearr_28441_28525[(2)] = inst_28422);

(statearr_28441_28525[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (9))){
var inst_28418 = (state_28429[(8)]);
var inst_28418__$1 = (state_28429[(2)]);
var inst_28419 = (inst_28418__$1 == null);
var state_28429__$1 = (function (){var statearr_28442 = state_28429;
(statearr_28442[(8)] = inst_28418__$1);

return statearr_28442;
})();
if(cljs.core.truth_(inst_28419)){
var statearr_28443_28526 = state_28429__$1;
(statearr_28443_28526[(1)] = (10));

} else {
var statearr_28444_28527 = state_28429__$1;
(statearr_28444_28527[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (5))){
var _ = (function (){var statearr_28445 = state_28429;
(statearr_28445[(4)] = cljs.core.rest.call(null,(state_28429[(4)])));

return statearr_28445;
})();
var state_28429__$1 = state_28429;
var ex28440 = (state_28429__$1[(2)]);
var statearr_28446_28528 = state_28429__$1;
(statearr_28446_28528[(5)] = ex28440);


if((ex28440 instanceof Error)){
var statearr_28447_28529 = state_28429__$1;
(statearr_28447_28529[(1)] = (4));

(statearr_28447_28529[(5)] = null);

} else {
throw ex28440;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (10))){
var state_28429__$1 = state_28429;
var statearr_28448_28530 = state_28429__$1;
(statearr_28448_28530[(2)] = null);

(statearr_28448_28530[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28430 === (8))){
var inst_28412 = (state_28429[(7)]);
var inst_28416 = cljs.core.first.call(null,inst_28412);
var state_28429__$1 = state_28429;
var statearr_28449_28531 = state_28429__$1;
(statearr_28449_28531[(2)] = inst_28416);

(statearr_28449_28531[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_28450 = [null,null,null,null,null,null,null,null,null];
(statearr_28450[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_28450[(1)] = (1));

return statearr_28450;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_28429){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28451){var ex__2749__auto__ = e28451;
var statearr_28452_28532 = state_28429;
(statearr_28452_28532[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28429[(4)]))){
var statearr_28453_28533 = state_28429;
(statearr_28453_28533[(1)] = cljs.core.first.call(null,(state_28429[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28534 = state_28429;
state_28429 = G__28534;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_28429){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_28429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28454 = f__2769__auto__.call(null);
(statearr_28454[(6)] = c__2768__auto__);

return statearr_28454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28489){
var state_val_28490 = (state_28489[(1)]);
if((state_val_28490 === (7))){
var inst_28468 = typeof pred === 'string';
var state_28489__$1 = state_28489;
if(cljs.core.truth_(inst_28468)){
var statearr_28491_28535 = state_28489__$1;
(statearr_28491_28535[(1)] = (10));

} else {
var statearr_28492_28536 = state_28489__$1;
(statearr_28492_28536[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (1))){
var state_28489__$1 = state_28489;
var statearr_28493_28537 = state_28489__$1;
(statearr_28493_28537[(2)] = null);

(statearr_28493_28537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (4))){
var inst_28455 = (state_28489[(2)]);
var state_28489__$1 = state_28489;
var statearr_28494_28538 = state_28489__$1;
(statearr_28494_28538[(2)] = inst_28455);

(statearr_28494_28538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (15))){
var inst_28482 = (state_28489[(2)]);
var state_28489__$1 = state_28489;
var statearr_28495_28539 = state_28489__$1;
(statearr_28495_28539[(2)] = inst_28482);

(statearr_28495_28539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (13))){
var inst_28473 = (state_28489[(7)]);
var inst_28475 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28473),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_28476 = fluree.db.dbproto._tag_id.call(null,this$,inst_28475);
var state_28489__$1 = state_28489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28489__$1,(16),inst_28476);
} else {
if((state_val_28490 === (6))){
var inst_28463 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_28489__$1 = state_28489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28489__$1,(9),inst_28463);
} else {
if((state_val_28490 === (3))){
var inst_28487 = (state_28489[(2)]);
var state_28489__$1 = state_28489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28489__$1,inst_28487);
} else {
if((state_val_28490 === (12))){
var inst_28473 = (state_28489[(7)]);
var inst_28473__$1 = (state_28489[(2)]);
var state_28489__$1 = (function (){var statearr_28496 = state_28489;
(statearr_28496[(7)] = inst_28473__$1);

return statearr_28496;
})();
if(cljs.core.truth_(inst_28473__$1)){
var statearr_28497_28540 = state_28489__$1;
(statearr_28497_28540[(1)] = (13));

} else {
var statearr_28498_28541 = state_28489__$1;
(statearr_28498_28541[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (2))){
var _ = (function (){var statearr_28499 = state_28489;
(statearr_28499[(4)] = cljs.core.cons.call(null,(5),(state_28489[(4)])));

return statearr_28499;
})();
var inst_28461 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_28489__$1 = state_28489;
if(inst_28461){
var statearr_28500_28542 = state_28489__$1;
(statearr_28500_28542[(1)] = (6));

} else {
var statearr_28501_28543 = state_28489__$1;
(statearr_28501_28543[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (11))){
var inst_28471 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28489__$1 = state_28489;
var statearr_28503_28544 = state_28489__$1;
(statearr_28503_28544[(2)] = inst_28471);

(statearr_28503_28544[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (9))){
var inst_28465 = (state_28489[(2)]);
var inst_28466 = fluree.db.util.async.throw_err.call(null,inst_28465);
var state_28489__$1 = state_28489;
var statearr_28504_28545 = state_28489__$1;
(statearr_28504_28545[(2)] = inst_28466);

(statearr_28504_28545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (5))){
var _ = (function (){var statearr_28505 = state_28489;
(statearr_28505[(4)] = cljs.core.rest.call(null,(state_28489[(4)])));

return statearr_28505;
})();
var state_28489__$1 = state_28489;
var ex28502 = (state_28489__$1[(2)]);
var statearr_28506_28546 = state_28489__$1;
(statearr_28506_28546[(5)] = ex28502);


if((ex28502 instanceof Error)){
var statearr_28507_28547 = state_28489__$1;
(statearr_28507_28547[(1)] = (4));

(statearr_28507_28547[(5)] = null);

} else {
throw ex28502;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (14))){
var state_28489__$1 = state_28489;
var statearr_28508_28548 = state_28489__$1;
(statearr_28508_28548[(2)] = null);

(statearr_28508_28548[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (16))){
var inst_28478 = (state_28489[(2)]);
var inst_28479 = fluree.db.util.async.throw_err.call(null,inst_28478);
var state_28489__$1 = state_28489;
var statearr_28509_28549 = state_28489__$1;
(statearr_28509_28549[(2)] = inst_28479);

(statearr_28509_28549[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (10))){
var state_28489__$1 = state_28489;
var statearr_28510_28550 = state_28489__$1;
(statearr_28510_28550[(2)] = pred);

(statearr_28510_28550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (8))){
var inst_28484 = (state_28489[(2)]);
var _ = (function (){var statearr_28511 = state_28489;
(statearr_28511[(4)] = cljs.core.rest.call(null,(state_28489[(4)])));

return statearr_28511;
})();
var state_28489__$1 = state_28489;
var statearr_28512_28551 = state_28489__$1;
(statearr_28512_28551[(2)] = inst_28484);

(statearr_28512_28551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_28513 = [null,null,null,null,null,null,null,null];
(statearr_28513[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_28513[(1)] = (1));

return statearr_28513;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_28489){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28514){var ex__2749__auto__ = e28514;
var statearr_28515_28552 = state_28489;
(statearr_28515_28552[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28489[(4)]))){
var statearr_28516_28553 = state_28489;
(statearr_28516_28553[(1)] = cljs.core.first.call(null,(state_28489[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28554 = state_28489;
state_28489 = G__28554;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_28489){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_28489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28517 = f__2769__auto__.call(null);
(statearr_28517[(6)] = c__2768__auto__);

return statearr_28517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k28556,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__28560 = k28556;
var G__28560__$1 = (((G__28560 instanceof cljs.core.Keyword))?G__28560.fqn:null);
switch (G__28560__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28556,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__28561){
var vec__28562 = p__28561;
var k__5367__auto__ = cljs.core.nth.call(null,vec__28562,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__28562,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28555){
var self__ = this;
var G__28555__$1 = this;
return (new cljs.core.RecordIter((0),G__28555__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28557,other28558){
var self__ = this;
var this28557__$1 = this;
return (((!((other28558 == null)))) && ((((this28557__$1.constructor === other28558.constructor)) && (((cljs.core._EQ_.call(null,this28557__$1.conn,other28558.conn)) && (((cljs.core._EQ_.call(null,this28557__$1.network,other28558.network)) && (((cljs.core._EQ_.call(null,this28557__$1.dbid,other28558.dbid)) && (((cljs.core._EQ_.call(null,this28557__$1.block,other28558.block)) && (((cljs.core._EQ_.call(null,this28557__$1.t,other28558.t)) && (((cljs.core._EQ_.call(null,this28557__$1.tt_id,other28558.tt_id)) && (((cljs.core._EQ_.call(null,this28557__$1.stats,other28558.stats)) && (((cljs.core._EQ_.call(null,this28557__$1.spot,other28558.spot)) && (((cljs.core._EQ_.call(null,this28557__$1.psot,other28558.psot)) && (((cljs.core._EQ_.call(null,this28557__$1.post,other28558.post)) && (((cljs.core._EQ_.call(null,this28557__$1.opst,other28558.opst)) && (((cljs.core._EQ_.call(null,this28557__$1.schema,other28558.schema)) && (((cljs.core._EQ_.call(null,this28557__$1.settings,other28558.settings)) && (((cljs.core._EQ_.call(null,this28557__$1.index_configs,other28558.index_configs)) && (((cljs.core._EQ_.call(null,this28557__$1.schema_cache,other28558.schema_cache)) && (((cljs.core._EQ_.call(null,this28557__$1.novelty,other28558.novelty)) && (((cljs.core._EQ_.call(null,this28557__$1.permissions,other28558.permissions)) && (((cljs.core._EQ_.call(null,this28557__$1.fork,other28558.fork)) && (((cljs.core._EQ_.call(null,this28557__$1.fork_block,other28558.fork_block)) && (((cljs.core._EQ_.call(null,this28557__$1.current_db_fn,other28558.current_db_fn)) && (cljs.core._EQ_.call(null,this28557__$1.__extmap,other28558.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k28556){
var self__ = this;
var this__5350__auto____$1 = this;
var G__28565 = k28556;
var G__28565__$1 = (((G__28565 instanceof cljs.core.Keyword))?G__28565.fqn:null);
switch (G__28565__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k28556);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__28555){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__28566 = cljs.core.keyword_identical_QMARK_;
var expr__28567 = k__5352__auto__;
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__28567))){
return (new fluree.db.graphdb.GraphDb(G__28555,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__28555,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__28555,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__28555,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__28555,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__28555,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__28555,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__28555,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__28555,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__28555,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__28555,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__28555,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__28555,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__28555,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__28555,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__28555,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__28555,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__28555,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__28555,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28566.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__28567))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__28555,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__28555),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__28555){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__28555,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__28559){
var extmap__5385__auto__ = (function (){var G__28569 = cljs.core.dissoc.call(null,G__28559,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__28559)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__28569);
} else {
return G__28569;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__28559),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__28559),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
