// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k28601,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__28605 = k28601;
var G__28605__$1 = (((G__28605 instanceof cljs.core.Keyword))?G__28605.fqn:null);
switch (G__28605__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28601,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__28606){
var vec__28607 = p__28606;
var k__5367__auto__ = cljs.core.nth.call(null,vec__28607,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__28607,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28600){
var self__ = this;
var G__28600__$1 = this;
return (new cljs.core.RecordIter((0),G__28600__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28602,other28603){
var self__ = this;
var this28602__$1 = this;
return (((!((other28603 == null)))) && ((((this28602__$1.constructor === other28603.constructor)) && (((cljs.core._EQ_.call(null,this28602__$1.conn,other28603.conn)) && (((cljs.core._EQ_.call(null,this28602__$1.network,other28603.network)) && (((cljs.core._EQ_.call(null,this28602__$1.dbid,other28603.dbid)) && (((cljs.core._EQ_.call(null,this28602__$1.db_name,other28603.db_name)) && (((cljs.core._EQ_.call(null,this28602__$1.update_chan,other28603.update_chan)) && (((cljs.core._EQ_.call(null,this28602__$1.transact_chan,other28603.transact_chan)) && (((cljs.core._EQ_.call(null,this28602__$1.state,other28603.state)) && (((cljs.core._EQ_.call(null,this28602__$1.schema_cache,other28603.schema_cache)) && (((cljs.core._EQ_.call(null,this28602__$1.blank_db,other28603.blank_db)) && (((cljs.core._EQ_.call(null,this28602__$1.close,other28603.close)) && (((cljs.core._EQ_.call(null,this28602__$1.id,other28603.id)) && (cljs.core._EQ_.call(null,this28602__$1.__extmap,other28603.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k28601){
var self__ = this;
var this__5350__auto____$1 = this;
var G__28610 = k28601;
var G__28610__$1 = (((G__28610 instanceof cljs.core.Keyword))?G__28610.fqn:null);
switch (G__28610__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k28601);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__28600){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__28611 = cljs.core.keyword_identical_QMARK_;
var expr__28612 = k__5352__auto__;
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__28612))){
return (new fluree.db.session.DbSession(G__28600,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,G__28600,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__28600,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__28600,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__28600,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__28600,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__28600,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__28600,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__28600,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__28600,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28611.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__28612))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__28600,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__28600),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__28600){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__28600,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__28604){
var extmap__5385__auto__ = (function (){var G__28614 = cljs.core.dissoc.call(null,G__28604,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__28604)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__28614);
} else {
return G__28614;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__28604),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28604),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__28617 = session;
var map__28617__$1 = cljs.core.__destructure_map.call(null,map__28617);
var network = cljs.core.get.call(null,map__28617__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28617__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,dbid){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28659){
var state_val_28660 = (state_28659[(1)]);
if((state_val_28660 === (7))){
var inst_28633 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not found on this ledger group."].join('');
var inst_28634 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28635 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28636 = cljs.core.PersistentHashMap.fromArrays(inst_28634,inst_28635);
var inst_28637 = cljs.core.ex_info.call(null,inst_28633,inst_28636);
var inst_28638 = (function(){throw inst_28637})();
var state_28659__$1 = state_28659;
var statearr_28661_28684 = state_28659__$1;
(statearr_28661_28684[(2)] = inst_28638);

(statearr_28661_28684[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (1))){
var state_28659__$1 = state_28659;
var statearr_28662_28685 = state_28659__$1;
(statearr_28662_28685[(2)] = null);

(statearr_28662_28685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (4))){
var inst_28618 = (state_28659[(2)]);
var state_28659__$1 = state_28659;
var statearr_28663_28686 = state_28659__$1;
(statearr_28663_28686[(2)] = inst_28618);

(statearr_28663_28686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (6))){
var inst_28630 = (state_28659[(7)]);
var inst_28629 = (state_28659[(2)]);
var inst_28630__$1 = fluree.db.util.async.throw_err.call(null,inst_28629);
var inst_28631 = cljs.core.empty_QMARK_.call(null,inst_28630__$1);
var state_28659__$1 = (function (){var statearr_28664 = state_28659;
(statearr_28664[(7)] = inst_28630__$1);

return statearr_28664;
})();
if(inst_28631){
var statearr_28665_28687 = state_28659__$1;
(statearr_28665_28687[(1)] = (7));

} else {
var statearr_28666_28688 = state_28659__$1;
(statearr_28666_28688[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (3))){
var inst_28657 = (state_28659[(2)]);
var state_28659__$1 = state_28659;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28659__$1,inst_28657);
} else {
if((state_val_28660 === (12))){
var inst_28652 = (state_28659[(2)]);
var state_28659__$1 = state_28659;
var statearr_28667_28689 = state_28659__$1;
(statearr_28667_28689[(2)] = inst_28652);

(statearr_28667_28689[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (2))){
var _ = (function (){var statearr_28668 = state_28659;
(statearr_28668[(4)] = cljs.core.cons.call(null,(5),(state_28659[(4)])));

return statearr_28668;
})();
var inst_28624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28625 = [network,dbid];
var inst_28626 = (new cljs.core.PersistentVector(null,2,(5),inst_28624,inst_28625,null));
var inst_28627 = fluree.db.operations.ledger_info_async.call(null,conn,inst_28626);
var state_28659__$1 = state_28659;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28659__$1,(6),inst_28627);
} else {
if((state_val_28660 === (11))){
var inst_28630 = (state_28659[(7)]);
var state_28659__$1 = state_28659;
var statearr_28670_28690 = state_28659__$1;
(statearr_28670_28690[(2)] = inst_28630);

(statearr_28670_28690[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (9))){
var inst_28654 = (state_28659[(2)]);
var _ = (function (){var statearr_28671 = state_28659;
(statearr_28671[(4)] = cljs.core.rest.call(null,(state_28659[(4)])));

return statearr_28671;
})();
var state_28659__$1 = state_28659;
var statearr_28672_28691 = state_28659__$1;
(statearr_28672_28691[(2)] = inst_28654);

(statearr_28672_28691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (5))){
var _ = (function (){var statearr_28673 = state_28659;
(statearr_28673[(4)] = cljs.core.rest.call(null,(state_28659[(4)])));

return statearr_28673;
})();
var state_28659__$1 = state_28659;
var ex28669 = (state_28659__$1[(2)]);
var statearr_28674_28692 = state_28659__$1;
(statearr_28674_28692[(5)] = ex28669);


if((ex28669 instanceof Error)){
var statearr_28675_28693 = state_28659__$1;
(statearr_28675_28693[(1)] = (4));

(statearr_28675_28693[(5)] = null);

} else {
throw ex28669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (10))){
var inst_28630 = (state_28659[(7)]);
var inst_28643 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28630);
var inst_28644 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28643),"."].join('');
var inst_28645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28646 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28647 = cljs.core.PersistentHashMap.fromArrays(inst_28645,inst_28646);
var inst_28648 = cljs.core.ex_info.call(null,inst_28644,inst_28647);
var inst_28649 = (function(){throw inst_28648})();
var state_28659__$1 = state_28659;
var statearr_28676_28694 = state_28659__$1;
(statearr_28676_28694[(2)] = inst_28649);

(statearr_28676_28694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28660 === (8))){
var inst_28630 = (state_28659[(7)]);
var inst_28640 = fluree.db.session.ready_QMARK_.call(null,inst_28630);
var inst_28641 = (!(inst_28640));
var state_28659__$1 = state_28659;
if(inst_28641){
var statearr_28677_28695 = state_28659__$1;
(statearr_28677_28695[(1)] = (10));

} else {
var statearr_28678_28696 = state_28659__$1;
(statearr_28678_28696[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0 = (function (){
var statearr_28679 = [null,null,null,null,null,null,null,null];
(statearr_28679[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2746__auto__);

(statearr_28679[(1)] = (1));

return statearr_28679;
});
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1 = (function (state_28659){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28659);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28680){var ex__2749__auto__ = e28680;
var statearr_28681_28697 = state_28659;
(statearr_28681_28697[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28659[(4)]))){
var statearr_28682_28698 = state_28659;
(statearr_28682_28698[(1)] = cljs.core.first.call(null,(state_28659[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28699 = state_28659;
state_28659 = G__28699;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = function(state_28659){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1.call(this,state_28659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28683 = f__2769__auto__.call(null);
(statearr_28683[(6)] = c__2768__auto__);

return statearr_28683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__28700){
var map__28701 = p__28700;
var map__28701__$1 = cljs.core.__destructure_map.call(null,map__28701);
var blank_db = map__28701__$1;
var network = cljs.core.get.call(null,map__28701__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28701__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28776){
var state_val_28777 = (state_28776[(1)]);
if((state_val_28777 === (7))){
var inst_28719 = (state_28776[(7)]);
var inst_28718 = (state_28776[(2)]);
var inst_28719__$1 = fluree.db.util.async.throw_err.call(null,inst_28718);
var state_28776__$1 = (function (){var statearr_28778 = state_28776;
(statearr_28778[(7)] = inst_28719__$1);

return statearr_28778;
})();
if(cljs.core.truth_(inst_28719__$1)){
var statearr_28779_28814 = state_28776__$1;
(statearr_28779_28814[(1)] = (8));

} else {
var statearr_28780_28815 = state_28776__$1;
(statearr_28780_28815[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (20))){
var inst_28724 = (state_28776[(8)]);
var inst_28757 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28724)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid),"."].join('');
var inst_28758 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28759 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28760 = cljs.core.PersistentHashMap.fromArrays(inst_28758,inst_28759);
var inst_28761 = cljs.core.ex_info.call(null,inst_28757,inst_28760);
var inst_28762 = (function(){throw inst_28761})();
var state_28776__$1 = state_28776;
var statearr_28781_28816 = state_28776__$1;
(statearr_28781_28816[(2)] = inst_28762);

(statearr_28781_28816[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (1))){
var state_28776__$1 = state_28776;
var statearr_28782_28817 = state_28776__$1;
(statearr_28782_28817[(2)] = null);

(statearr_28782_28817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (4))){
var inst_28702 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
var statearr_28783_28818 = state_28776__$1;
(statearr_28783_28818[(2)] = inst_28702);

(statearr_28783_28818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (15))){
var inst_28766 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
var statearr_28784_28819 = state_28776__$1;
(statearr_28784_28819[(2)] = inst_28766);

(statearr_28784_28819[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (21))){
var inst_28764 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
var statearr_28785_28820 = state_28776__$1;
(statearr_28785_28820[(2)] = inst_28764);

(statearr_28785_28820[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (13))){
var inst_28723 = (state_28776[(9)]);
var inst_28728 = fluree.db.query.schema.schema_map.call(null,inst_28723);
var inst_28729 = fluree.db.query.schema.setting_map.call(null,inst_28723);
var inst_28730 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_28723);
var inst_28731 = cljs.core.swap_BANG_.call(null,inst_28730,cljs.core.empty);
var state_28776__$1 = (function (){var statearr_28786 = state_28776;
(statearr_28786[(10)] = inst_28729);

(statearr_28786[(11)] = inst_28731);

return statearr_28786;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28776__$1,(16),inst_28728);
} else {
if((state_val_28777 === (22))){
var inst_28724 = (state_28776[(8)]);
var inst_28752 = (state_28776[(2)]);
var inst_28753 = fluree.db.util.async.throw_err.call(null,inst_28752);
var inst_28754 = (inst_28724 + (1));
var inst_28723 = inst_28753;
var inst_28724__$1 = inst_28754;
var state_28776__$1 = (function (){var statearr_28787 = state_28776;
(statearr_28787[(9)] = inst_28723);

(statearr_28787[(8)] = inst_28724__$1);

return statearr_28787;
})();
var statearr_28788_28821 = state_28776__$1;
(statearr_28788_28821[(2)] = null);

(statearr_28788_28821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (6))){
var inst_28711 = (state_28776[(2)]);
var inst_28712 = fluree.db.util.async.throw_err.call(null,inst_28711);
var inst_28713 = cljs.core.__destructure_map.call(null,inst_28712);
var inst_28714 = cljs.core.get.call(null,inst_28713,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28715 = cljs.core.get.call(null,inst_28713,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_28716 = fluree.db.storage.core.reify_db.call(null,conn,network,dbid,blank_db,inst_28715);
var state_28776__$1 = (function (){var statearr_28789 = state_28776;
(statearr_28789[(12)] = inst_28714);

return statearr_28789;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28776__$1,(7),inst_28716);
} else {
if((state_val_28777 === (17))){
var inst_28723 = (state_28776[(9)]);
var inst_28734 = (state_28776[(13)]);
var inst_28736 = (state_28776[(2)]);
var inst_28737 = fluree.db.util.async.throw_err.call(null,inst_28736);
var inst_28738 = cljs.core.assoc.call(null,inst_28723,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28734,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28737);
var state_28776__$1 = state_28776;
var statearr_28790_28822 = state_28776__$1;
(statearr_28790_28822[(2)] = inst_28738);

(statearr_28790_28822[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (3))){
var inst_28774 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28776__$1,inst_28774);
} else {
if((state_val_28777 === (12))){
var inst_28768 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
var statearr_28791_28823 = state_28776__$1;
(statearr_28791_28823[(2)] = inst_28768);

(statearr_28791_28823[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (2))){
var _ = (function (){var statearr_28792 = state_28776;
(statearr_28792[(4)] = cljs.core.cons.call(null,(5),(state_28776[(4)])));

return statearr_28792;
})();
var inst_28709 = fluree.db.session.load_ledger_info.call(null,conn,network,dbid);
var state_28776__$1 = state_28776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28776__$1,(6),inst_28709);
} else {
if((state_val_28777 === (19))){
var inst_28723 = (state_28776[(9)]);
var inst_28743 = (state_28776[(14)]);
var inst_28746 = cljs.core.__destructure_map.call(null,inst_28743);
var inst_28747 = cljs.core.get.call(null,inst_28746,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28748 = cljs.core.get.call(null,inst_28746,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28749 = cljs.core.get.call(null,inst_28746,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28750 = fluree.db.dbproto._with.call(null,inst_28723,inst_28748,inst_28747);
var state_28776__$1 = (function (){var statearr_28793 = state_28776;
(statearr_28793[(15)] = inst_28749);

return statearr_28793;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28776__$1,(22),inst_28750);
} else {
if((state_val_28777 === (11))){
var inst_28724 = (state_28776[(8)]);
var inst_28714 = (state_28776[(12)]);
var inst_28726 = (inst_28724 > inst_28714);
var state_28776__$1 = state_28776;
if(cljs.core.truth_(inst_28726)){
var statearr_28795_28824 = state_28776__$1;
(statearr_28795_28824[(1)] = (13));

} else {
var statearr_28796_28825 = state_28776__$1;
(statearr_28796_28825[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (9))){
var state_28776__$1 = state_28776;
var statearr_28797_28826 = state_28776__$1;
(statearr_28797_28826[(2)] = null);

(statearr_28797_28826[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (5))){
var _ = (function (){var statearr_28798 = state_28776;
(statearr_28798[(4)] = cljs.core.rest.call(null,(state_28776[(4)])));

return statearr_28798;
})();
var state_28776__$1 = state_28776;
var ex28794 = (state_28776__$1[(2)]);
var statearr_28799_28827 = state_28776__$1;
(statearr_28799_28827[(5)] = ex28794);


if((ex28794 instanceof Error)){
var statearr_28800_28828 = state_28776__$1;
(statearr_28800_28828[(1)] = (4));

(statearr_28800_28828[(5)] = null);

} else {
throw ex28794;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (14))){
var inst_28724 = (state_28776[(8)]);
var inst_28740 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_28724);
var state_28776__$1 = state_28776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28776__$1,(18),inst_28740);
} else {
if((state_val_28777 === (16))){
var inst_28729 = (state_28776[(10)]);
var inst_28733 = (state_28776[(2)]);
var inst_28734 = fluree.db.util.async.throw_err.call(null,inst_28733);
var state_28776__$1 = (function (){var statearr_28801 = state_28776;
(statearr_28801[(13)] = inst_28734);

return statearr_28801;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28776__$1,(17),inst_28729);
} else {
if((state_val_28777 === (10))){
var inst_28771 = (state_28776[(2)]);
var _ = (function (){var statearr_28802 = state_28776;
(statearr_28802[(4)] = cljs.core.rest.call(null,(state_28776[(4)])));

return statearr_28802;
})();
var state_28776__$1 = state_28776;
var statearr_28803_28829 = state_28776__$1;
(statearr_28803_28829[(2)] = inst_28771);

(statearr_28803_28829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (18))){
var inst_28743 = (state_28776[(14)]);
var inst_28742 = (state_28776[(2)]);
var inst_28743__$1 = fluree.db.util.async.throw_err.call(null,inst_28742);
var state_28776__$1 = (function (){var statearr_28804 = state_28776;
(statearr_28804[(14)] = inst_28743__$1);

return statearr_28804;
})();
if(cljs.core.truth_(inst_28743__$1)){
var statearr_28805_28830 = state_28776__$1;
(statearr_28805_28830[(1)] = (19));

} else {
var statearr_28806_28831 = state_28776__$1;
(statearr_28806_28831[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28777 === (8))){
var inst_28719 = (state_28776[(7)]);
var inst_28721 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28719);
var inst_28722 = (inst_28721 + (1));
var inst_28723 = inst_28719;
var inst_28724 = inst_28722;
var state_28776__$1 = (function (){var statearr_28807 = state_28776;
(statearr_28807[(9)] = inst_28723);

(statearr_28807[(8)] = inst_28724);

return statearr_28807;
})();
var statearr_28808_28832 = state_28776__$1;
(statearr_28808_28832[(2)] = null);

(statearr_28808_28832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2746__auto____0 = (function (){
var statearr_28809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28809[(0)] = fluree$db$session$load_current_db_$_state_machine__2746__auto__);

(statearr_28809[(1)] = (1));

return statearr_28809;
});
var fluree$db$session$load_current_db_$_state_machine__2746__auto____1 = (function (state_28776){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28810){var ex__2749__auto__ = e28810;
var statearr_28811_28833 = state_28776;
(statearr_28811_28833[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28776[(4)]))){
var statearr_28812_28834 = state_28776;
(statearr_28812_28834[(1)] = cljs.core.first.call(null,(state_28776[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28835 = state_28776;
state_28776 = G__28835;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2746__auto__ = function(state_28776){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____1.call(this,state_28776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2746__auto____0;
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2746__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28813 = f__2769__auto__.call(null);
(statearr_28813[(6)] = c__2768__auto__);

return statearr_28813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__28836,old_db_ch,new_db_ch){
var map__28837 = p__28836;
var map__28837__$1 = cljs.core.__destructure_map.call(null,map__28837);
var state = cljs.core.get.call(null,map__28837__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__28838){
var map__28839 = p__28838;
var map__28839__$1 = cljs.core.__destructure_map.call(null,map__28839);
var s = map__28839__$1;
var current = cljs.core.get.call(null,map__28839__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__28840){
var map__28841 = p__28840;
var map__28841__$1 = cljs.core.__destructure_map.call(null,map__28841);
var state = cljs.core.get.call(null,map__28841__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__28842){
var map__28843 = p__28842;
var map__28843__$1 = cljs.core.__destructure_map.call(null,map__28843);
var conn = cljs.core.get.call(null,map__28843__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__28843__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__28843__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2768__auto___28880 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28863){
var state_val_28864 = (state_28863[(1)]);
if((state_val_28864 === (1))){
var state_28863__$1 = state_28863;
var statearr_28865_28881 = state_28863__$1;
(statearr_28865_28881[(2)] = null);

(statearr_28865_28881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28864 === (2))){
var _ = (function (){var statearr_28866 = state_28863;
(statearr_28866[(4)] = cljs.core.cons.call(null,(5),(state_28863[(4)])));

return statearr_28866;
})();
var inst_28853 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_28863__$1 = state_28863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28863__$1,(6),inst_28853);
} else {
if((state_val_28864 === (3))){
var inst_28861 = (state_28863[(2)]);
var state_28863__$1 = state_28863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28863__$1,inst_28861);
} else {
if((state_val_28864 === (4))){
var inst_28844 = (state_28863[(2)]);
var inst_28845 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_28846 = fluree.db.util.log.error.call(null,inst_28844,"Error reloading db");
var inst_28847 = cljs.core.async.put_BANG_.call(null,db_ch,inst_28844);
var state_28863__$1 = (function (){var statearr_28868 = state_28863;
(statearr_28868[(7)] = inst_28845);

(statearr_28868[(8)] = inst_28846);

return statearr_28868;
})();
var statearr_28869_28882 = state_28863__$1;
(statearr_28869_28882[(2)] = inst_28847);

(statearr_28869_28882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28864 === (5))){
var _ = (function (){var statearr_28870 = state_28863;
(statearr_28870[(4)] = cljs.core.rest.call(null,(state_28863[(4)])));

return statearr_28870;
})();
var state_28863__$1 = state_28863;
var ex28867 = (state_28863__$1[(2)]);
var statearr_28871_28883 = state_28863__$1;
(statearr_28871_28883[(5)] = ex28867);


var statearr_28872_28884 = state_28863__$1;
(statearr_28872_28884[(1)] = (4));

(statearr_28872_28884[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28864 === (6))){
var inst_28855 = (state_28863[(2)]);
var inst_28856 = fluree.db.util.async.throw_err.call(null,inst_28855);
var state_28863__$1 = state_28863;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28863__$1,(7),db_ch,inst_28856);
} else {
if((state_val_28864 === (7))){
var inst_28858 = (state_28863[(2)]);
var _ = (function (){var statearr_28873 = state_28863;
(statearr_28873[(4)] = cljs.core.rest.call(null,(state_28863[(4)])));

return statearr_28873;
})();
var state_28863__$1 = state_28863;
var statearr_28874_28885 = state_28863__$1;
(statearr_28874_28885[(2)] = inst_28858);

(statearr_28874_28885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0 = (function (){
var statearr_28875 = [null,null,null,null,null,null,null,null,null];
(statearr_28875[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__);

(statearr_28875[(1)] = (1));

return statearr_28875;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1 = (function (state_28863){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28876){var ex__2749__auto__ = e28876;
var statearr_28877_28886 = state_28863;
(statearr_28877_28886[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28863[(4)]))){
var statearr_28878_28887 = state_28863;
(statearr_28878_28887[(1)] = cljs.core.first.call(null,(state_28863[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28888 = state_28863;
state_28863 = G__28888;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = function(state_28863){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1.call(this,state_28863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28879 = f__2769__auto__.call(null);
(statearr_28879[(6)] = c__2768__auto___28880);

return statearr_28879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__28890 = arguments.length;
switch (G__28890) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__28891){
var map__28892 = p__28891;
var map__28892__$1 = cljs.core.__destructure_map.call(null,map__28892);
var session = map__28892__$1;
var blank_db = cljs.core.get.call(null,map__28892__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__28893,blank_db){
var map__28894 = p__28893;
var map__28894__$1 = cljs.core.__destructure_map.call(null,map__28894);
var session = map__28894__$1;
var conn = cljs.core.get.call(null,map__28894__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__28894__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__2768__auto___28932 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28914){
var state_val_28915 = (state_28914[(1)]);
if((state_val_28915 === (1))){
var state_28914__$1 = state_28914;
var statearr_28916_28933 = state_28914__$1;
(statearr_28916_28933[(2)] = null);

(statearr_28916_28933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (2))){
var _ = (function (){var statearr_28917 = state_28914;
(statearr_28917[(4)] = cljs.core.cons.call(null,(5),(state_28914[(4)])));

return statearr_28917;
})();
var inst_28904 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_28914__$1 = state_28914;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28914__$1,(6),inst_28904);
} else {
if((state_val_28915 === (3))){
var inst_28912 = (state_28914[(2)]);
var state_28914__$1 = state_28914;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28914__$1,inst_28912);
} else {
if((state_val_28915 === (4))){
var inst_28895 = (state_28914[(2)]);
var inst_28896 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_28897 = fluree.db.util.log.error.call(null,inst_28895,"Error loading current db");
var inst_28898 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_28895);
var state_28914__$1 = (function (){var statearr_28919 = state_28914;
(statearr_28919[(7)] = inst_28897);

(statearr_28919[(8)] = inst_28896);

return statearr_28919;
})();
var statearr_28920_28934 = state_28914__$1;
(statearr_28920_28934[(2)] = inst_28898);

(statearr_28920_28934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (5))){
var _ = (function (){var statearr_28921 = state_28914;
(statearr_28921[(4)] = cljs.core.rest.call(null,(state_28914[(4)])));

return statearr_28921;
})();
var state_28914__$1 = state_28914;
var ex28918 = (state_28914__$1[(2)]);
var statearr_28922_28935 = state_28914__$1;
(statearr_28922_28935[(5)] = ex28918);


var statearr_28923_28936 = state_28914__$1;
(statearr_28923_28936[(1)] = (4));

(statearr_28923_28936[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28915 === (6))){
var inst_28906 = (state_28914[(2)]);
var inst_28907 = fluree.db.util.async.throw_err.call(null,inst_28906);
var state_28914__$1 = state_28914;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28914__$1,(7),cur_ch,inst_28907);
} else {
if((state_val_28915 === (7))){
var inst_28909 = (state_28914[(2)]);
var _ = (function (){var statearr_28924 = state_28914;
(statearr_28924[(4)] = cljs.core.rest.call(null,(state_28914[(4)])));

return statearr_28924;
})();
var state_28914__$1 = state_28914;
var statearr_28925_28937 = state_28914__$1;
(statearr_28925_28937[(2)] = inst_28909);

(statearr_28925_28937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_28926 = [null,null,null,null,null,null,null,null,null];
(statearr_28926[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_28926[(1)] = (1));

return statearr_28926;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_28914){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28927){var ex__2749__auto__ = e28927;
var statearr_28928_28938 = state_28914;
(statearr_28928_28938[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28914[(4)]))){
var statearr_28929_28939 = state_28914;
(statearr_28929_28939[(1)] = cljs.core.first.call(null,(state_28914[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28940 = state_28914;
state_28914 = G__28940;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_28914){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_28914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28930 = f__2769__auto__.call(null);
(statearr_28930[(6)] = c__2768__auto___28932);

return statearr_28930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28942){
var state_val_28943 = (state_28942[(1)]);
if((state_val_28943 === (1))){
var state_28942__$1 = state_28942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28942__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_28944 = [null,null,null,null,null,null,null];
(statearr_28944[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_28944[(1)] = (1));

return statearr_28944;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_28942){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28945){var ex__2749__auto__ = e28945;
var statearr_28946_28949 = state_28942;
(statearr_28946_28949[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28942[(4)]))){
var statearr_28947_28950 = state_28942;
(statearr_28947_28950[(1)] = cljs.core.first.call(null,(state_28942[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28951 = state_28942;
state_28942 = G__28951;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_28942){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_28942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28948 = f__2769__auto__.call(null);
(statearr_28948[(6)] = c__2768__auto__);

return statearr_28948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28952){
var map__28953 = p__28952;
var map__28953__$1 = cljs.core.__destructure_map.call(null,map__28953);
var data = map__28953__$1;
var block = cljs.core.get.call(null,map__28953__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__28953__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__28953__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29012){
var state_val_29013 = (state_29012[(1)]);
if((state_val_29013 === (7))){
var inst_28964 = (state_29012[(7)]);
var inst_28967 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28968 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28969 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28967),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28968),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28964),". No-op."].join('');
var inst_28970 = fluree.db.util.log.info.call(null,inst_28969);
var state_29012__$1 = state_29012;
var statearr_29014_29048 = state_29012__$1;
(statearr_29014_29048[(2)] = inst_28970);

(statearr_29014_29048[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (1))){
var state_29012__$1 = state_29012;
var statearr_29015_29049 = state_29012__$1;
(statearr_29015_29049[(2)] = null);

(statearr_29015_29049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (4))){
var inst_28954 = (state_29012[(2)]);
var state_29012__$1 = state_29012;
var statearr_29016_29050 = state_29012__$1;
(statearr_29016_29050[(2)] = inst_28954);

(statearr_29016_29050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (15))){
var inst_28993 = (state_29012[(2)]);
var state_29012__$1 = state_29012;
var statearr_29017_29051 = state_29012__$1;
(statearr_29017_29051[(2)] = inst_28993);

(statearr_29017_29051[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (13))){
var inst_28984 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28986 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28987 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28988 = [inst_28986,inst_28987];
var inst_28989 = (new cljs.core.PersistentVector(null,2,(5),inst_28985,inst_28988,null));
var inst_28990 = fluree.db.conn_events.process_event.call(null,inst_28984,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_28989,data);
var state_29012__$1 = state_29012;
var statearr_29018_29052 = state_29012__$1;
(statearr_29018_29052[(2)] = inst_28990);

(statearr_29018_29052[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (6))){
var inst_28963 = (state_29012[(8)]);
var inst_28964 = (state_29012[(7)]);
var inst_28962 = (state_29012[(2)]);
var inst_28963__$1 = fluree.db.util.async.throw_err.call(null,inst_28962);
var inst_28964__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28963__$1);
var inst_28965 = (block <= inst_28964__$1);
var state_29012__$1 = (function (){var statearr_29019 = state_29012;
(statearr_29019[(8)] = inst_28963__$1);

(statearr_29019[(7)] = inst_28964__$1);

return statearr_29019;
})();
if(cljs.core.truth_(inst_28965)){
var statearr_29020_29053 = state_29012__$1;
(statearr_29020_29053[(1)] = (7));

} else {
var statearr_29021_29054 = state_29012__$1;
(statearr_29021_29054[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (17))){
var state_29012__$1 = state_29012;
var statearr_29022_29055 = state_29012__$1;
(statearr_29022_29055[(2)] = null);

(statearr_29022_29055[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (3))){
var inst_29010 = (state_29012[(2)]);
var state_29012__$1 = state_29012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29012__$1,inst_29010);
} else {
if((state_val_29013 === (12))){
var inst_29005 = (state_29012[(2)]);
var state_29012__$1 = state_29012;
var statearr_29023_29056 = state_29012__$1;
(statearr_29023_29056[(2)] = inst_29005);

(statearr_29023_29056[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (2))){
var inst_28960 = (state_29012[(9)]);
var _ = (function (){var statearr_29024 = state_29012;
(statearr_29024[(4)] = cljs.core.cons.call(null,(5),(state_29012[(4)])));

return statearr_29024;
})();
var inst_28960__$1 = fluree.db.session.current_db.call(null,session);
var state_29012__$1 = (function (){var statearr_29025 = state_29012;
(statearr_29025[(9)] = inst_28960__$1);

return statearr_29025;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29012__$1,(6),inst_28960__$1);
} else {
if((state_val_29013 === (11))){
var state_29012__$1 = state_29012;
var statearr_29027_29057 = state_29012__$1;
(statearr_29027_29057[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (9))){
var inst_29007 = (state_29012[(2)]);
var _ = (function (){var statearr_29029 = state_29012;
(statearr_29029[(4)] = cljs.core.rest.call(null,(state_29012[(4)])));

return statearr_29029;
})();
var state_29012__$1 = state_29012;
var statearr_29030_29058 = state_29012__$1;
(statearr_29030_29058[(2)] = inst_29007);

(statearr_29030_29058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (5))){
var _ = (function (){var statearr_29031 = state_29012;
(statearr_29031[(4)] = cljs.core.rest.call(null,(state_29012[(4)])));

return statearr_29031;
})();
var state_29012__$1 = state_29012;
var ex29026 = (state_29012__$1[(2)]);
var statearr_29032_29059 = state_29012__$1;
(statearr_29032_29059[(5)] = ex29026);


if((ex29026 instanceof Error)){
var statearr_29033_29060 = state_29012__$1;
(statearr_29033_29060[(1)] = (4));

(statearr_29033_29060[(5)] = null);

} else {
throw ex29026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (14))){
var state_29012__$1 = state_29012;
var statearr_29034_29061 = state_29012__$1;
(statearr_29034_29061[(2)] = null);

(statearr_29034_29061[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (16))){
var inst_28964 = (state_29012[(7)]);
var inst_28996 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28997 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28998 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28996),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28997),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28964),". Forcing a db reload."].join('');
var inst_28999 = fluree.db.util.log.info.call(null,inst_28998);
var inst_29000 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_29012__$1 = (function (){var statearr_29035 = state_29012;
(statearr_29035[(10)] = inst_28999);

return statearr_29035;
})();
var statearr_29036_29062 = state_29012__$1;
(statearr_29036_29062[(2)] = inst_29000);

(statearr_29036_29062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (10))){
var inst_28963 = (state_29012[(8)]);
var inst_28960 = (state_29012[(9)]);
var inst_28964 = (state_29012[(7)]);
var inst_28975 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28976 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28977 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28975),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28976),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28978 = fluree.db.util.log.trace.call(null,inst_28977);
var inst_28979 = (function (){var current_db_ch = inst_28960;
var current_db = inst_28963;
var current_block = inst_28964;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_28980 = cljs.core.map.call(null,inst_28979,flakes);
var inst_28981 = fluree.db.dbproto._with.call(null,inst_28963,block,inst_28980);
var inst_28982 = fluree.db.session.cas_db_BANG_.call(null,session,inst_28960,inst_28981);
var state_29012__$1 = (function (){var statearr_29037 = state_29012;
(statearr_29037[(11)] = inst_28978);

return statearr_29037;
})();
if(inst_28982){
var statearr_29038_29063 = state_29012__$1;
(statearr_29038_29063[(1)] = (13));

} else {
var statearr_29039_29064 = state_29012__$1;
(statearr_29039_29064[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (18))){
var inst_29003 = (state_29012[(2)]);
var state_29012__$1 = state_29012;
var statearr_29040_29065 = state_29012__$1;
(statearr_29040_29065[(2)] = inst_29003);

(statearr_29040_29065[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29013 === (8))){
var inst_28964 = (state_29012[(7)]);
var inst_28972 = ((1) + inst_28964);
var inst_28973 = cljs.core._EQ_.call(null,block,inst_28972);
var state_29012__$1 = state_29012;
if(inst_28973){
var statearr_29041_29066 = state_29012__$1;
(statearr_29041_29066[(1)] = (10));

} else {
var statearr_29042_29067 = state_29012__$1;
(statearr_29042_29067[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_29043 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29043[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_29043[(1)] = (1));

return statearr_29043;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_29012){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29044){var ex__2749__auto__ = e29044;
var statearr_29045_29068 = state_29012;
(statearr_29045_29068[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29012[(4)]))){
var statearr_29046_29069 = state_29012;
(statearr_29046_29069[(1)] = cljs.core.first.call(null,(state_29012[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29070 = state_29012;
state_29012 = G__29070;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_29012){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_29012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29047 = f__2769__auto__.call(null);
(statearr_29047[(6)] = c__2768__auto__);

return statearr_29047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29077){
var state_val_29078 = (state_29077[(1)]);
if((state_val_29078 === (1))){
var inst_29071 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_29072 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29073 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29074 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29072),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29073)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_29075 = fluree.db.util.log.debug.call(null,inst_29074);
var state_29077__$1 = (function (){var statearr_29079 = state_29077;
(statearr_29079[(7)] = inst_29071);

(statearr_29079[(8)] = inst_29075);

return statearr_29079;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29077__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_29080 = [null,null,null,null,null,null,null,null,null];
(statearr_29080[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_29080[(1)] = (1));

return statearr_29080;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_29077){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29081){var ex__2749__auto__ = e29081;
var statearr_29082_29085 = state_29077;
(statearr_29082_29085[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29077[(4)]))){
var statearr_29083_29086 = state_29077;
(statearr_29083_29086[(1)] = cljs.core.first.call(null,(state_29077[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29087 = state_29077;
state_29077 = G__29087;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_29077){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_29077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29084 = f__2769__auto__.call(null);
(statearr_29084[(6)] = c__2768__auto__);

return statearr_29084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__29089 = arguments.length;
switch (G__29089) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__29090){
var map__29091 = p__29090;
var map__29091__$1 = cljs.core.__destructure_map.call(null,map__29091);
var session = map__29091__$1;
var conn = cljs.core.get.call(null,map__29091__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__29091__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__29091__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__29091__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__29091__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__29091__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__29091__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29145){
var state_val_29146 = (state_29145[(1)]);
if((state_val_29146 === (7))){
var inst_29141 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
var statearr_29147_29178 = state_29145__$1;
(statearr_29147_29178[(2)] = inst_29141);

(statearr_29147_29178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (1))){
var state_29145__$1 = state_29145;
var statearr_29148_29179 = state_29145__$1;
(statearr_29148_29179[(2)] = null);

(statearr_29148_29179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (4))){
var inst_29096 = (state_29145[(7)]);
var inst_29095 = (state_29145[(2)]);
var inst_29096__$1 = fluree.db.util.async.throw_err.call(null,inst_29095);
var inst_29097 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_29098 = (inst_29096__$1 == null);
var state_29145__$1 = (function (){var statearr_29149 = state_29145;
(statearr_29149[(7)] = inst_29096__$1);

(statearr_29149[(8)] = inst_29097);

return statearr_29149;
})();
if(cljs.core.truth_(inst_29098)){
var statearr_29150_29180 = state_29145__$1;
(statearr_29150_29180[(1)] = (5));

} else {
var statearr_29151_29181 = state_29145__$1;
(statearr_29151_29181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (15))){
var inst_29133 = (state_29145[(2)]);
var state_29145__$1 = (function (){var statearr_29152 = state_29145;
(statearr_29152[(9)] = inst_29133);

return statearr_29152;
})();
var statearr_29153_29182 = state_29145__$1;
(statearr_29153_29182[(2)] = null);

(statearr_29153_29182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (13))){
var inst_29137 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
var statearr_29155_29183 = state_29145__$1;
(statearr_29155_29183[(2)] = inst_29137);

(statearr_29155_29183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (6))){
var inst_29097 = (state_29145[(8)]);
var inst_29103 = (inst_29097 == null);
var state_29145__$1 = state_29145;
if(cljs.core.truth_(inst_29103)){
var statearr_29156_29184 = state_29145__$1;
(statearr_29156_29184[(1)] = (8));

} else {
var statearr_29157_29185 = state_29145__$1;
(statearr_29157_29185[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (17))){
var _ = (function (){var statearr_29158 = state_29145;
(statearr_29158[(4)] = cljs.core.rest.call(null,(state_29145[(4)])));

return statearr_29158;
})();
var state_29145__$1 = state_29145;
var ex29154 = (state_29145__$1[(2)]);
var statearr_29159_29186 = state_29145__$1;
(statearr_29159_29186[(5)] = ex29154);


var statearr_29160_29187 = state_29145__$1;
(statearr_29160_29187[(1)] = (16));

(statearr_29160_29187[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (3))){
var inst_29143 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29145__$1,inst_29143);
} else {
if((state_val_29146 === (12))){
var state_29145__$1 = state_29145;
var statearr_29161_29188 = state_29145__$1;
(statearr_29161_29188[(2)] = null);

(statearr_29161_29188[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (2))){
var state_29145__$1 = state_29145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29145__$1,(4),update_chan);
} else {
if((state_val_29146 === (11))){
var state_29145__$1 = state_29145;
var statearr_29162_29189 = state_29145__$1;
(statearr_29162_29189[(2)] = null);

(statearr_29162_29189[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (9))){
var state_29145__$1 = state_29145;
var statearr_29163_29190 = state_29145__$1;
(statearr_29163_29190[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (5))){
var inst_29100 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_29101 = fluree.db.util.log.info.call(null,inst_29100);
var state_29145__$1 = state_29145;
var statearr_29165_29191 = state_29145__$1;
(statearr_29165_29191[(2)] = inst_29101);

(statearr_29165_29191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (14))){
var inst_29096 = (state_29145[(7)]);
var inst_29097 = (state_29145[(8)]);
var _ = (function (){var statearr_29166 = state_29145;
(statearr_29166[(4)] = cljs.core.cons.call(null,(17),(state_29145[(4)])));

return statearr_29166;
})();
var inst_29121 = cljs.core.nth.call(null,inst_29096,(0),null);
var inst_29122 = cljs.core.nth.call(null,inst_29096,(1),null);
var inst_29123 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_29124 = cljs.core.pr_str.call(null,inst_29096);
var inst_29125 = fluree.db.util.core.trunc.call(null,inst_29124,(200));
var inst_29126 = fluree.db.util.log.trace.call(null,inst_29123,inst_29125);
var inst_29127 = fluree.db.session.process_ledger_update.call(null,inst_29097,inst_29121,inst_29122);
var state_29145__$1 = (function (){var statearr_29167 = state_29145;
(statearr_29167[(10)] = inst_29126);

return statearr_29167;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29145__$1,(18),inst_29127);
} else {
if((state_val_29146 === (16))){
var inst_29096 = (state_29145[(7)]);
var inst_29111 = (state_29145[(2)]);
var inst_29112 = fluree.db.util.log.error.call(null,inst_29111,"Exception processing ledger updates for message: ",inst_29096);
var state_29145__$1 = state_29145;
var statearr_29168_29192 = state_29145__$1;
(statearr_29168_29192[(2)] = inst_29112);

(statearr_29168_29192[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (10))){
var inst_29139 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
var statearr_29169_29193 = state_29145__$1;
(statearr_29169_29193[(2)] = inst_29139);

(statearr_29169_29193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (18))){
var inst_29129 = (state_29145[(2)]);
var inst_29130 = fluree.db.util.async.throw_err.call(null,inst_29129);
var _ = (function (){var statearr_29170 = state_29145;
(statearr_29170[(4)] = cljs.core.rest.call(null,(state_29145[(4)])));

return statearr_29170;
})();
var state_29145__$1 = state_29145;
var statearr_29171_29194 = state_29145__$1;
(statearr_29171_29194[(2)] = inst_29130);

(statearr_29171_29194[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (8))){
var inst_29096 = (state_29145[(7)]);
var inst_29105 = cljs.core.first.call(null,inst_29096);
var inst_29106 = cljs.core.pr_str.call(null,inst_29105);
var inst_29107 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_29106].join('');
var inst_29108 = fluree.db.util.log.warn.call(null,inst_29107);
var state_29145__$1 = state_29145;
var statearr_29172_29195 = state_29145__$1;
(statearr_29172_29195[(2)] = inst_29108);

(statearr_29172_29195[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0 = (function (){
var statearr_29173 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29173[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__);

(statearr_29173[(1)] = (1));

return statearr_29173;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1 = (function (state_29145){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29174){var ex__2749__auto__ = e29174;
var statearr_29175_29196 = state_29145;
(statearr_29175_29196[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29145[(4)]))){
var statearr_29176_29197 = state_29145;
(statearr_29176_29197[(1)] = cljs.core.first.call(null,(state_29145[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29198 = state_29145;
state_29145 = G__29198;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = function(state_29145){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1.call(this,state_29145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29177 = f__2769__auto__.call(null);
(statearr_29177[(6)] = c__2768__auto__);

return statearr_29177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__29199){
var map__29200 = p__29199;
var map__29200__$1 = cljs.core.__destructure_map.call(null,map__29200);
var network = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__29200__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__29204 = block_result;
var map__29204__$1 = cljs.core.__destructure_map.call(null,map__29204);
var block = cljs.core.get.call(null,map__29204__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__29204__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__29204__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__29204__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__29204__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__29205 = tx_result;
var map__29205__$1 = cljs.core.__destructure_map.call(null,map__29205);
var t = cljs.core.get.call(null,map__29205__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__29205__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__29201_SHARP_){
return cljs.core._EQ_.call(null,t,p1__29201_SHARP_.t);
}):(function (p1__29202_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__29202_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__29203_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__29203_SHARP_))){
return cljs.core.nth.call(null,p1__29203_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__29206 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__29206,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__29206,(1),null);
var error = cljs.core.nth.call(null,vec__29206,(2),null);
var message = cljs.core.nth.call(null,vec__29206,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__29210 = arguments.length;
switch (G__29210) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__29211){
var map__29212 = p__29211;
var map__29212__$1 = cljs.core.__destructure_map.call(null,map__29212);
var state = cljs.core.get.call(null,map__29212__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__29212__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__29212__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__29212__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__29213 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__29213,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__29213,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__29213,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__29216 = cljs.core.seq.call(null,tids);
var chunk__29217 = null;
var count__29218 = (0);
var i__29219 = (0);
while(true){
if((i__29219 < count__29218)){
var tid = cljs.core._nth.call(null,chunk__29217,i__29219);
var temp__5804__auto___29332__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___29332__$1)){
var keyed_callbacks_29333 = temp__5804__auto___29332__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_29334 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__29260_29335 = cljs.core.seq.call(null,keyed_callbacks_29333);
var chunk__29261_29336 = null;
var count__29262_29337 = (0);
var i__29263_29338 = (0);
while(true){
if((i__29263_29338 < count__29262_29337)){
var vec__29272_29339 = cljs.core._nth.call(null,chunk__29261_29336,i__29263_29338);
var k_29340 = cljs.core.nth.call(null,vec__29272_29339,(0),null);
var f_29341 = cljs.core.nth.call(null,vec__29272_29339,(1),null);
try{f_29341.call(null,tx_response_29334);
}catch (e29275){var e_29342 = e29275;
fluree.db.util.log.error.call(null,e_29342,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29343 = seq__29260_29335;
var G__29344 = chunk__29261_29336;
var G__29345 = count__29262_29337;
var G__29346 = (i__29263_29338 + (1));
seq__29260_29335 = G__29343;
chunk__29261_29336 = G__29344;
count__29262_29337 = G__29345;
i__29263_29338 = G__29346;
continue;
} else {
var temp__5804__auto___29347__$2 = cljs.core.seq.call(null,seq__29260_29335);
if(temp__5804__auto___29347__$2){
var seq__29260_29348__$1 = temp__5804__auto___29347__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29260_29348__$1)){
var c__5568__auto___29349 = cljs.core.chunk_first.call(null,seq__29260_29348__$1);
var G__29350 = cljs.core.chunk_rest.call(null,seq__29260_29348__$1);
var G__29351 = c__5568__auto___29349;
var G__29352 = cljs.core.count.call(null,c__5568__auto___29349);
var G__29353 = (0);
seq__29260_29335 = G__29350;
chunk__29261_29336 = G__29351;
count__29262_29337 = G__29352;
i__29263_29338 = G__29353;
continue;
} else {
var vec__29276_29354 = cljs.core.first.call(null,seq__29260_29348__$1);
var k_29355 = cljs.core.nth.call(null,vec__29276_29354,(0),null);
var f_29356 = cljs.core.nth.call(null,vec__29276_29354,(1),null);
try{f_29356.call(null,tx_response_29334);
}catch (e29279){var e_29357 = e29279;
fluree.db.util.log.error.call(null,e_29357,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29358 = cljs.core.next.call(null,seq__29260_29348__$1);
var G__29359 = null;
var G__29360 = (0);
var G__29361 = (0);
seq__29260_29335 = G__29358;
chunk__29261_29336 = G__29359;
count__29262_29337 = G__29360;
i__29263_29338 = G__29361;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29362 = seq__29216;
var G__29363 = chunk__29217;
var G__29364 = count__29218;
var G__29365 = (i__29219 + (1));
seq__29216 = G__29362;
chunk__29217 = G__29363;
count__29218 = G__29364;
i__29219 = G__29365;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__29216);
if(temp__5804__auto____$1){
var seq__29216__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29216__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__29216__$1);
var G__29366 = cljs.core.chunk_rest.call(null,seq__29216__$1);
var G__29367 = c__5568__auto__;
var G__29368 = cljs.core.count.call(null,c__5568__auto__);
var G__29369 = (0);
seq__29216 = G__29366;
chunk__29217 = G__29367;
count__29218 = G__29368;
i__29219 = G__29369;
continue;
} else {
var tid = cljs.core.first.call(null,seq__29216__$1);
var temp__5804__auto___29370__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___29370__$2)){
var keyed_callbacks_29371 = temp__5804__auto___29370__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_29372 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__29280_29373 = cljs.core.seq.call(null,keyed_callbacks_29371);
var chunk__29281_29374 = null;
var count__29282_29375 = (0);
var i__29283_29376 = (0);
while(true){
if((i__29283_29376 < count__29282_29375)){
var vec__29292_29377 = cljs.core._nth.call(null,chunk__29281_29374,i__29283_29376);
var k_29378 = cljs.core.nth.call(null,vec__29292_29377,(0),null);
var f_29379 = cljs.core.nth.call(null,vec__29292_29377,(1),null);
try{f_29379.call(null,tx_response_29372);
}catch (e29295){var e_29380 = e29295;
fluree.db.util.log.error.call(null,e_29380,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29381 = seq__29280_29373;
var G__29382 = chunk__29281_29374;
var G__29383 = count__29282_29375;
var G__29384 = (i__29283_29376 + (1));
seq__29280_29373 = G__29381;
chunk__29281_29374 = G__29382;
count__29282_29375 = G__29383;
i__29283_29376 = G__29384;
continue;
} else {
var temp__5804__auto___29385__$3 = cljs.core.seq.call(null,seq__29280_29373);
if(temp__5804__auto___29385__$3){
var seq__29280_29386__$1 = temp__5804__auto___29385__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29280_29386__$1)){
var c__5568__auto___29387 = cljs.core.chunk_first.call(null,seq__29280_29386__$1);
var G__29388 = cljs.core.chunk_rest.call(null,seq__29280_29386__$1);
var G__29389 = c__5568__auto___29387;
var G__29390 = cljs.core.count.call(null,c__5568__auto___29387);
var G__29391 = (0);
seq__29280_29373 = G__29388;
chunk__29281_29374 = G__29389;
count__29282_29375 = G__29390;
i__29283_29376 = G__29391;
continue;
} else {
var vec__29296_29392 = cljs.core.first.call(null,seq__29280_29386__$1);
var k_29393 = cljs.core.nth.call(null,vec__29296_29392,(0),null);
var f_29394 = cljs.core.nth.call(null,vec__29296_29392,(1),null);
try{f_29394.call(null,tx_response_29372);
}catch (e29299){var e_29395 = e29299;
fluree.db.util.log.error.call(null,e_29395,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29396 = cljs.core.next.call(null,seq__29280_29386__$1);
var G__29397 = null;
var G__29398 = (0);
var G__29399 = (0);
seq__29280_29373 = G__29396;
chunk__29281_29374 = G__29397;
count__29282_29375 = G__29398;
i__29283_29376 = G__29399;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29400 = cljs.core.next.call(null,seq__29216__$1);
var G__29401 = null;
var G__29402 = (0);
var G__29403 = (0);
seq__29216 = G__29400;
chunk__29217 = G__29401;
count__29218 = G__29402;
i__29219 = G__29403;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_29404 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2768__auto___29405 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29316){
var state_val_29317 = (state_29316[(1)]);
if((state_val_29317 === (1))){
var state_29316__$1 = state_29316;
var statearr_29318_29406 = state_29316__$1;
(statearr_29318_29406[(2)] = null);

(statearr_29318_29406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (2))){
var inst_29301 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_29316__$1 = state_29316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29316__$1,(4),inst_29301);
} else {
if((state_val_29317 === (3))){
var inst_29314 = (state_29316[(2)]);
var state_29316__$1 = state_29316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29316__$1,inst_29314);
} else {
if((state_val_29317 === (4))){
var inst_29303 = (state_29316[(7)]);
var inst_29303__$1 = (state_29316[(2)]);
var inst_29304 = (inst_29303__$1 == null);
var state_29316__$1 = (function (){var statearr_29319 = state_29316;
(statearr_29319[(7)] = inst_29303__$1);

return statearr_29319;
})();
if(cljs.core.truth_(inst_29304)){
var statearr_29320_29407 = state_29316__$1;
(statearr_29320_29407[(1)] = (5));

} else {
var statearr_29321_29408 = state_29316__$1;
(statearr_29321_29408[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (5))){
var inst_29306 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_29307 = fluree.db.util.log.info.call(null,inst_29306);
var state_29316__$1 = state_29316;
var statearr_29322_29409 = state_29316__$1;
(statearr_29322_29409[(2)] = inst_29307);

(statearr_29322_29409[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (6))){
var inst_29303 = (state_29316[(7)]);
var inst_29309 = transact_handler_29404.call(null,conn,inst_29303);
var state_29316__$1 = (function (){var statearr_29323 = state_29316;
(statearr_29323[(8)] = inst_29309);

return statearr_29323;
})();
var statearr_29324_29410 = state_29316__$1;
(statearr_29324_29410[(2)] = null);

(statearr_29324_29410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (7))){
var inst_29312 = (state_29316[(2)]);
var state_29316__$1 = state_29316;
var statearr_29325_29411 = state_29316__$1;
(statearr_29325_29411[(2)] = inst_29312);

(statearr_29325_29411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_29326 = [null,null,null,null,null,null,null,null,null];
(statearr_29326[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_29326[(1)] = (1));

return statearr_29326;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_29316){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29327){var ex__2749__auto__ = e29327;
var statearr_29328_29412 = state_29316;
(statearr_29328_29412[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29316[(4)]))){
var statearr_29329_29413 = state_29316;
(statearr_29329_29413[(1)] = cljs.core.first.call(null,(state_29316[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29414 = state_29316;
state_29316 = G__29414;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_29316){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_29316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29330 = f__2769__auto__.call(null);
(statearr_29330[(6)] = c__2768__auto___29405);

return statearr_29330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__29417 = arguments.length;
switch (G__29417) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__29418 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__29415_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__29415_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__29418);
} else {
return G__29418;
}
})();
var seq__29419 = cljs.core.seq.call(null,sessions);
var chunk__29420 = null;
var count__29421 = (0);
var i__29422 = (0);
while(true){
if((i__29422 < count__29421)){
var session = cljs.core._nth.call(null,chunk__29420,i__29422);
fluree.db.session.close.call(null,session);


var G__29424 = seq__29419;
var G__29425 = chunk__29420;
var G__29426 = count__29421;
var G__29427 = (i__29422 + (1));
seq__29419 = G__29424;
chunk__29420 = G__29425;
count__29421 = G__29426;
i__29422 = G__29427;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__29419);
if(temp__5804__auto__){
var seq__29419__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29419__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__29419__$1);
var G__29428 = cljs.core.chunk_rest.call(null,seq__29419__$1);
var G__29429 = c__5568__auto__;
var G__29430 = cljs.core.count.call(null,c__5568__auto__);
var G__29431 = (0);
seq__29419 = G__29428;
chunk__29420 = G__29429;
count__29421 = G__29430;
i__29422 = G__29431;
continue;
} else {
var session = cljs.core.first.call(null,seq__29419__$1);
fluree.db.session.close.call(null,session);


var G__29432 = cljs.core.next.call(null,seq__29419__$1);
var G__29433 = null;
var G__29434 = (0);
var G__29435 = (0);
seq__29419 = G__29432;
chunk__29420 = G__29433;
count__29421 = G__29434;
i__29422 = G__29435;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
