// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18020){
var state_val_18021 = (state_18020[(1)]);
if((state_val_18021 === (7))){
var inst_18009 = (state_18020[(7)]);
var inst_18011 = fluree.db.storage.core.serde.call(null,conn);
var inst_18012 = fluree.db.serde.protocol._deserialize_block.call(null,inst_18011,inst_18009);
var state_18020__$1 = state_18020;
var statearr_18022_18041 = state_18020__$1;
(statearr_18022_18041[(2)] = inst_18012);

(statearr_18022_18041[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18021 === (1))){
var state_18020__$1 = state_18020;
var statearr_18023_18042 = state_18020__$1;
(statearr_18023_18042[(2)] = null);

(statearr_18023_18042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18021 === (4))){
var inst_17999 = (state_18020[(2)]);
var state_18020__$1 = state_18020;
var statearr_18024_18043 = state_18020__$1;
(statearr_18024_18043[(2)] = inst_17999);

(statearr_18024_18043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18021 === (6))){
var inst_18009 = (state_18020[(7)]);
var inst_18008 = (state_18020[(2)]);
var inst_18009__$1 = fluree.db.util.async.throw_err.call(null,inst_18008);
var state_18020__$1 = (function (){var statearr_18025 = state_18020;
(statearr_18025[(7)] = inst_18009__$1);

return statearr_18025;
})();
if(cljs.core.truth_(inst_18009__$1)){
var statearr_18026_18044 = state_18020__$1;
(statearr_18026_18044[(1)] = (7));

} else {
var statearr_18027_18045 = state_18020__$1;
(statearr_18027_18045[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18021 === (3))){
var inst_18018 = (state_18020[(2)]);
var state_18020__$1 = state_18020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18020__$1,inst_18018);
} else {
if((state_val_18021 === (2))){
var _ = (function (){var statearr_18029 = state_18020;
(statearr_18029[(4)] = cljs.core.cons.call(null,(5),(state_18020[(4)])));

return statearr_18029;
})();
var inst_18005 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_18006 = fluree.db.storage.core.storage_read.call(null,conn,inst_18005);
var state_18020__$1 = state_18020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18020__$1,(6),inst_18006);
} else {
if((state_val_18021 === (9))){
var inst_18015 = (state_18020[(2)]);
var _ = (function (){var statearr_18030 = state_18020;
(statearr_18030[(4)] = cljs.core.rest.call(null,(state_18020[(4)])));

return statearr_18030;
})();
var state_18020__$1 = state_18020;
var statearr_18031_18046 = state_18020__$1;
(statearr_18031_18046[(2)] = inst_18015);

(statearr_18031_18046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18021 === (5))){
var _ = (function (){var statearr_18032 = state_18020;
(statearr_18032[(4)] = cljs.core.rest.call(null,(state_18020[(4)])));

return statearr_18032;
})();
var state_18020__$1 = state_18020;
var ex18028 = (state_18020__$1[(2)]);
var statearr_18033_18047 = state_18020__$1;
(statearr_18033_18047[(5)] = ex18028);


if((ex18028 instanceof Error)){
var statearr_18034_18048 = state_18020__$1;
(statearr_18034_18048[(1)] = (4));

(statearr_18034_18048[(5)] = null);

} else {
throw ex18028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18021 === (8))){
var state_18020__$1 = state_18020;
var statearr_18035_18049 = state_18020__$1;
(statearr_18035_18049[(2)] = null);

(statearr_18035_18049[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____0 = (function (){
var statearr_18036 = [null,null,null,null,null,null,null,null];
(statearr_18036[(0)] = fluree$db$storage$core$read_block_$_state_machine__2746__auto__);

(statearr_18036[(1)] = (1));

return statearr_18036;
});
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____1 = (function (state_18020){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18037){var ex__2749__auto__ = e18037;
var statearr_18038_18050 = state_18020;
(statearr_18038_18050[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18020[(4)]))){
var statearr_18039_18051 = state_18020;
(statearr_18039_18051[(1)] = cljs.core.first.call(null,(state_18020[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18052 = state_18020;
state_18020 = G__18052;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = function(state_18020){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____1.call(this,state_18020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18040 = f__2769__auto__.call(null);
(statearr_18040[(6)] = c__2768__auto__);

return statearr_18040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18075){
var state_val_18076 = (state_18075[(1)]);
if((state_val_18076 === (7))){
var inst_18064 = (state_18075[(7)]);
var inst_18066 = fluree.db.storage.core.serde.call(null,conn);
var inst_18067 = fluree.db.serde.protocol._deserialize_block.call(null,inst_18066,inst_18064);
var state_18075__$1 = state_18075;
var statearr_18077_18096 = state_18075__$1;
(statearr_18077_18096[(2)] = inst_18067);

(statearr_18077_18096[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18076 === (1))){
var state_18075__$1 = state_18075;
var statearr_18078_18097 = state_18075__$1;
(statearr_18078_18097[(2)] = null);

(statearr_18078_18097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18076 === (4))){
var inst_18053 = (state_18075[(2)]);
var state_18075__$1 = state_18075;
var statearr_18079_18098 = state_18075__$1;
(statearr_18079_18098[(2)] = inst_18053);

(statearr_18079_18098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18076 === (6))){
var inst_18064 = (state_18075[(7)]);
var inst_18063 = (state_18075[(2)]);
var inst_18064__$1 = fluree.db.util.async.throw_err.call(null,inst_18063);
var state_18075__$1 = (function (){var statearr_18080 = state_18075;
(statearr_18080[(7)] = inst_18064__$1);

return statearr_18080;
})();
if(cljs.core.truth_(inst_18064__$1)){
var statearr_18081_18099 = state_18075__$1;
(statearr_18081_18099[(1)] = (7));

} else {
var statearr_18082_18100 = state_18075__$1;
(statearr_18082_18100[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18076 === (3))){
var inst_18073 = (state_18075[(2)]);
var state_18075__$1 = state_18075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18075__$1,inst_18073);
} else {
if((state_val_18076 === (2))){
var _ = (function (){var statearr_18084 = state_18075;
(statearr_18084[(4)] = cljs.core.cons.call(null,(5),(state_18075[(4)])));

return statearr_18084;
})();
var inst_18059 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_18060 = [inst_18059,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18061 = fluree.db.storage.core.storage_read.call(null,conn,inst_18060);
var state_18075__$1 = state_18075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18075__$1,(6),inst_18061);
} else {
if((state_val_18076 === (9))){
var inst_18070 = (state_18075[(2)]);
var _ = (function (){var statearr_18085 = state_18075;
(statearr_18085[(4)] = cljs.core.rest.call(null,(state_18075[(4)])));

return statearr_18085;
})();
var state_18075__$1 = state_18075;
var statearr_18086_18101 = state_18075__$1;
(statearr_18086_18101[(2)] = inst_18070);

(statearr_18086_18101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18076 === (5))){
var _ = (function (){var statearr_18087 = state_18075;
(statearr_18087[(4)] = cljs.core.rest.call(null,(state_18075[(4)])));

return statearr_18087;
})();
var state_18075__$1 = state_18075;
var ex18083 = (state_18075__$1[(2)]);
var statearr_18088_18102 = state_18075__$1;
(statearr_18088_18102[(5)] = ex18083);


if((ex18083 instanceof Error)){
var statearr_18089_18103 = state_18075__$1;
(statearr_18089_18103[(1)] = (4));

(statearr_18089_18103[(5)] = null);

} else {
throw ex18083;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18076 === (8))){
var state_18075__$1 = state_18075;
var statearr_18090_18104 = state_18075__$1;
(statearr_18090_18104[(2)] = null);

(statearr_18090_18104[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_18091 = [null,null,null,null,null,null,null,null];
(statearr_18091[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__);

(statearr_18091[(1)] = (1));

return statearr_18091;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1 = (function (state_18075){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18092){var ex__2749__auto__ = e18092;
var statearr_18093_18105 = state_18075;
(statearr_18093_18105[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18075[(4)]))){
var statearr_18094_18106 = state_18075;
(statearr_18094_18106[(1)] = cljs.core.first.call(null,(state_18075[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18107 = state_18075;
state_18075 = G__18107;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = function(state_18075){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1.call(this,state_18075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18095 = f__2769__auto__.call(null);
(statearr_18095[(6)] = c__2768__auto__);

return statearr_18095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18131){
var state_val_18132 = (state_18131[(1)]);
if((state_val_18132 === (1))){
var state_18131__$1 = state_18131;
var statearr_18133_18147 = state_18131__$1;
(statearr_18133_18147[(2)] = null);

(statearr_18133_18147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18132 === (2))){
var _ = (function (){var statearr_18134 = state_18131;
(statearr_18134[(4)] = cljs.core.cons.call(null,(5),(state_18131[(4)])));

return statearr_18134;
})();
var inst_18114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18115 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18116 = (new cljs.core.PersistentVector(null,3,(5),inst_18114,inst_18115,null));
var inst_18117 = cljs.core.select_keys.call(null,block_data,inst_18116);
var inst_18118 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18117);
var inst_18119 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_18118);
var inst_18120 = [inst_18119,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18121 = fluree.db.storage.core.serde.call(null,conn);
var inst_18122 = fluree.db.serde.protocol._serialize_block.call(null,inst_18121,inst_18117);
var inst_18123 = fluree.db.storage.core.storage_write.call(null,conn,inst_18120,inst_18122);
var state_18131__$1 = state_18131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18131__$1,(6),inst_18123);
} else {
if((state_val_18132 === (3))){
var inst_18129 = (state_18131[(2)]);
var state_18131__$1 = state_18131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18131__$1,inst_18129);
} else {
if((state_val_18132 === (4))){
var inst_18108 = (state_18131[(2)]);
var state_18131__$1 = state_18131;
var statearr_18136_18148 = state_18131__$1;
(statearr_18136_18148[(2)] = inst_18108);

(statearr_18136_18148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18132 === (5))){
var _ = (function (){var statearr_18137 = state_18131;
(statearr_18137[(4)] = cljs.core.rest.call(null,(state_18131[(4)])));

return statearr_18137;
})();
var state_18131__$1 = state_18131;
var ex18135 = (state_18131__$1[(2)]);
var statearr_18138_18149 = state_18131__$1;
(statearr_18138_18149[(5)] = ex18135);


if((ex18135 instanceof Error)){
var statearr_18139_18150 = state_18131__$1;
(statearr_18139_18150[(1)] = (4));

(statearr_18139_18150[(5)] = null);

} else {
throw ex18135;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18132 === (6))){
var inst_18125 = (state_18131[(2)]);
var inst_18126 = fluree.db.util.async.throw_err.call(null,inst_18125);
var _ = (function (){var statearr_18140 = state_18131;
(statearr_18140[(4)] = cljs.core.rest.call(null,(state_18131[(4)])));

return statearr_18140;
})();
var state_18131__$1 = state_18131;
var statearr_18141_18151 = state_18131__$1;
(statearr_18141_18151[(2)] = inst_18126);

(statearr_18141_18151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_18142 = [null,null,null,null,null,null,null];
(statearr_18142[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__);

(statearr_18142[(1)] = (1));

return statearr_18142;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1 = (function (state_18131){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18143){var ex__2749__auto__ = e18143;
var statearr_18144_18152 = state_18131;
(statearr_18144_18152[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18131[(4)]))){
var statearr_18145_18153 = state_18131;
(statearr_18145_18153[(1)] = cljs.core.first.call(null,(state_18131[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18154 = state_18131;
state_18131 = G__18154;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = function(state_18131){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1.call(this,state_18131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18146 = f__2769__auto__.call(null);
(statearr_18146[(6)] = c__2768__auto__);

return statearr_18146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18177){
var state_val_18178 = (state_18177[(1)]);
if((state_val_18178 === (1))){
var state_18177__$1 = state_18177;
var statearr_18179_18193 = state_18177__$1;
(statearr_18179_18193[(2)] = null);

(statearr_18179_18193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (2))){
var _ = (function (){var statearr_18180 = state_18177;
(statearr_18180[(4)] = cljs.core.cons.call(null,(5),(state_18177[(4)])));

return statearr_18180;
})();
var inst_18161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18162 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18163 = (new cljs.core.PersistentVector(null,3,(5),inst_18161,inst_18162,null));
var inst_18164 = cljs.core.select_keys.call(null,block_data,inst_18163);
var inst_18165 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18164);
var inst_18166 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_18165);
var inst_18167 = fluree.db.storage.core.serde.call(null,conn);
var inst_18168 = fluree.db.serde.protocol._serialize_block.call(null,inst_18167,inst_18164);
var inst_18169 = fluree.db.storage.core.storage_write.call(null,conn,inst_18166,inst_18168);
var state_18177__$1 = state_18177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18177__$1,(6),inst_18169);
} else {
if((state_val_18178 === (3))){
var inst_18175 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18177__$1,inst_18175);
} else {
if((state_val_18178 === (4))){
var inst_18155 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
var statearr_18182_18194 = state_18177__$1;
(statearr_18182_18194[(2)] = inst_18155);

(statearr_18182_18194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (5))){
var _ = (function (){var statearr_18183 = state_18177;
(statearr_18183[(4)] = cljs.core.rest.call(null,(state_18177[(4)])));

return statearr_18183;
})();
var state_18177__$1 = state_18177;
var ex18181 = (state_18177__$1[(2)]);
var statearr_18184_18195 = state_18177__$1;
(statearr_18184_18195[(5)] = ex18181);


if((ex18181 instanceof Error)){
var statearr_18185_18196 = state_18177__$1;
(statearr_18185_18196[(1)] = (4));

(statearr_18185_18196[(5)] = null);

} else {
throw ex18181;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (6))){
var inst_18171 = (state_18177[(2)]);
var inst_18172 = fluree.db.util.async.throw_err.call(null,inst_18171);
var _ = (function (){var statearr_18186 = state_18177;
(statearr_18186[(4)] = cljs.core.rest.call(null,(state_18177[(4)])));

return statearr_18186;
})();
var state_18177__$1 = state_18177;
var statearr_18187_18197 = state_18177__$1;
(statearr_18187_18197[(2)] = inst_18172);

(statearr_18187_18197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____0 = (function (){
var statearr_18188 = [null,null,null,null,null,null,null];
(statearr_18188[(0)] = fluree$db$storage$core$write_block_$_state_machine__2746__auto__);

(statearr_18188[(1)] = (1));

return statearr_18188;
});
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____1 = (function (state_18177){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18189){var ex__2749__auto__ = e18189;
var statearr_18190_18198 = state_18177;
(statearr_18190_18198[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18177[(4)]))){
var statearr_18191_18199 = state_18177;
(statearr_18191_18199[(1)] = cljs.core.first.call(null,(state_18177[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18200 = state_18177;
state_18177 = G__18200;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = function(state_18177){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____1.call(this,state_18177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18192 = f__2769__auto__.call(null);
(statearr_18192[(6)] = c__2768__auto__);

return statearr_18192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18220){
var state_val_18221 = (state_18220[(1)]);
if((state_val_18221 === (1))){
var state_18220__$1 = state_18220;
var statearr_18222_18236 = state_18220__$1;
(statearr_18222_18236[(2)] = null);

(statearr_18222_18236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18221 === (2))){
var _ = (function (){var statearr_18223 = state_18220;
(statearr_18223[(4)] = cljs.core.cons.call(null,(5),(state_18220[(4)])));

return statearr_18223;
})();
var inst_18207 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18208 = [history,next_his_key];
var inst_18209 = cljs.core.PersistentHashMap.fromArrays(inst_18207,inst_18208);
var inst_18210 = fluree.db.storage.core.serde.call(null,conn);
var inst_18211 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_18210,inst_18209);
var inst_18212 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_18211);
var state_18220__$1 = state_18220;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18220__$1,(6),inst_18212);
} else {
if((state_val_18221 === (3))){
var inst_18218 = (state_18220[(2)]);
var state_18220__$1 = state_18220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18220__$1,inst_18218);
} else {
if((state_val_18221 === (4))){
var inst_18201 = (state_18220[(2)]);
var state_18220__$1 = state_18220;
var statearr_18225_18237 = state_18220__$1;
(statearr_18225_18237[(2)] = inst_18201);

(statearr_18225_18237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18221 === (5))){
var _ = (function (){var statearr_18226 = state_18220;
(statearr_18226[(4)] = cljs.core.rest.call(null,(state_18220[(4)])));

return statearr_18226;
})();
var state_18220__$1 = state_18220;
var ex18224 = (state_18220__$1[(2)]);
var statearr_18227_18238 = state_18220__$1;
(statearr_18227_18238[(5)] = ex18224);


if((ex18224 instanceof Error)){
var statearr_18228_18239 = state_18220__$1;
(statearr_18228_18239[(1)] = (4));

(statearr_18228_18239[(5)] = null);

} else {
throw ex18224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18221 === (6))){
var inst_18214 = (state_18220[(2)]);
var inst_18215 = fluree.db.util.async.throw_err.call(null,inst_18214);
var _ = (function (){var statearr_18229 = state_18220;
(statearr_18229[(4)] = cljs.core.rest.call(null,(state_18220[(4)])));

return statearr_18229;
})();
var state_18220__$1 = state_18220;
var statearr_18230_18240 = state_18220__$1;
(statearr_18230_18240[(2)] = inst_18215);

(statearr_18230_18240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2746__auto____0 = (function (){
var statearr_18231 = [null,null,null,null,null,null,null];
(statearr_18231[(0)] = fluree$db$storage$core$write_history_$_state_machine__2746__auto__);

(statearr_18231[(1)] = (1));

return statearr_18231;
});
var fluree$db$storage$core$write_history_$_state_machine__2746__auto____1 = (function (state_18220){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18232){var ex__2749__auto__ = e18232;
var statearr_18233_18241 = state_18220;
(statearr_18233_18241[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18220[(4)]))){
var statearr_18234_18242 = state_18220;
(statearr_18234_18242[(1)] = cljs.core.first.call(null,(state_18220[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18243 = state_18220;
state_18220 = G__18243;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2746__auto__ = function(state_18220){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2746__auto____1.call(this,state_18220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18235 = f__2769__auto__.call(null);
(statearr_18235[(6)] = c__2768__auto__);

return statearr_18235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18269){
var state_val_18270 = (state_18269[(1)]);
if((state_val_18270 === (1))){
var state_18269__$1 = state_18269;
var statearr_18271_18288 = state_18269__$1;
(statearr_18271_18288[(2)] = null);

(statearr_18271_18288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18270 === (2))){
var inst_18250 = (state_18269[(7)]);
var _ = (function (){var statearr_18272 = state_18269;
(statearr_18272[(4)] = cljs.core.cons.call(null,(5),(state_18269[(4)])));

return statearr_18272;
})();
var inst_18250__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_18251 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18250__$1),"-his"].join('');
var inst_18252 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18253 = [flakes,inst_18251];
var inst_18254 = cljs.core.PersistentHashMap.fromArrays(inst_18252,inst_18253);
var inst_18255 = fluree.db.storage.core.serde.call(null,conn);
var inst_18256 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_18255,inst_18254);
var inst_18257 = fluree.db.storage.core.write_history.call(null,conn,history,inst_18251,null);
var inst_18258 = fluree.db.storage.core.storage_write.call(null,conn,inst_18250__$1,inst_18256);
var state_18269__$1 = (function (){var statearr_18273 = state_18269;
(statearr_18273[(7)] = inst_18250__$1);

(statearr_18273[(8)] = inst_18258);

return statearr_18273;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18269__$1,(6),inst_18257);
} else {
if((state_val_18270 === (3))){
var inst_18267 = (state_18269[(2)]);
var state_18269__$1 = state_18269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18269__$1,inst_18267);
} else {
if((state_val_18270 === (4))){
var inst_18244 = (state_18269[(2)]);
var state_18269__$1 = state_18269;
var statearr_18275_18289 = state_18269__$1;
(statearr_18275_18289[(2)] = inst_18244);

(statearr_18275_18289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18270 === (5))){
var _ = (function (){var statearr_18276 = state_18269;
(statearr_18276[(4)] = cljs.core.rest.call(null,(state_18269[(4)])));

return statearr_18276;
})();
var state_18269__$1 = state_18269;
var ex18274 = (state_18269__$1[(2)]);
var statearr_18277_18290 = state_18269__$1;
(statearr_18277_18290[(5)] = ex18274);


if((ex18274 instanceof Error)){
var statearr_18278_18291 = state_18269__$1;
(statearr_18278_18291[(1)] = (4));

(statearr_18278_18291[(5)] = null);

} else {
throw ex18274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18270 === (6))){
var inst_18258 = (state_18269[(8)]);
var inst_18260 = (state_18269[(2)]);
var inst_18261 = fluree.db.util.async.throw_err.call(null,inst_18260);
var state_18269__$1 = (function (){var statearr_18279 = state_18269;
(statearr_18279[(9)] = inst_18261);

return statearr_18279;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18269__$1,(7),inst_18258);
} else {
if((state_val_18270 === (7))){
var inst_18250 = (state_18269[(7)]);
var inst_18263 = (state_18269[(2)]);
var inst_18264 = fluree.db.util.async.throw_err.call(null,inst_18263);
var _ = (function (){var statearr_18280 = state_18269;
(statearr_18280[(4)] = cljs.core.rest.call(null,(state_18269[(4)])));

return statearr_18280;
})();
var state_18269__$1 = (function (){var statearr_18281 = state_18269;
(statearr_18281[(10)] = inst_18264);

return statearr_18281;
})();
var statearr_18282_18292 = state_18269__$1;
(statearr_18282_18292[(2)] = inst_18250);

(statearr_18282_18292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_18283 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18283[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__);

(statearr_18283[(1)] = (1));

return statearr_18283;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____1 = (function (state_18269){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18284){var ex__2749__auto__ = e18284;
var statearr_18285_18293 = state_18269;
(statearr_18285_18293[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18269[(4)]))){
var statearr_18286_18294 = state_18269;
(statearr_18286_18294[(1)] = cljs.core.first.call(null,(state_18269[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18295 = state_18269;
state_18269 = G__18295;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__ = function(state_18269){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____1.call(this,state_18269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18287 = f__2769__auto__.call(null);
(statearr_18287[(6)] = c__2768__auto__);

return statearr_18287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18312){
var state_val_18313 = (state_18312[(1)]);
if((state_val_18313 === (1))){
var state_18312__$1 = state_18312;
var statearr_18314_18329 = state_18312__$1;
(statearr_18314_18329[(2)] = null);

(statearr_18314_18329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18313 === (2))){
var _ = (function (){var statearr_18315 = state_18312;
(statearr_18315[(4)] = cljs.core.cons.call(null,(5),(state_18312[(4)])));

return statearr_18315;
})();
var inst_18302 = fluree.db.storage.core.serde.call(null,conn);
var inst_18303 = fluree.db.serde.protocol._serialize_branch.call(null,inst_18302,data);
var inst_18304 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_18303);
var state_18312__$1 = state_18312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18312__$1,(6),inst_18304);
} else {
if((state_val_18313 === (3))){
var inst_18310 = (state_18312[(2)]);
var state_18312__$1 = state_18312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18312__$1,inst_18310);
} else {
if((state_val_18313 === (4))){
var inst_18296 = (state_18312[(2)]);
var state_18312__$1 = state_18312;
var statearr_18317_18330 = state_18312__$1;
(statearr_18317_18330[(2)] = inst_18296);

(statearr_18317_18330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18313 === (5))){
var _ = (function (){var statearr_18318 = state_18312;
(statearr_18318[(4)] = cljs.core.rest.call(null,(state_18312[(4)])));

return statearr_18318;
})();
var state_18312__$1 = state_18312;
var ex18316 = (state_18312__$1[(2)]);
var statearr_18319_18331 = state_18312__$1;
(statearr_18319_18331[(5)] = ex18316);


if((ex18316 instanceof Error)){
var statearr_18320_18332 = state_18312__$1;
(statearr_18320_18332[(1)] = (4));

(statearr_18320_18332[(5)] = null);

} else {
throw ex18316;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18313 === (6))){
var inst_18306 = (state_18312[(2)]);
var inst_18307 = fluree.db.util.async.throw_err.call(null,inst_18306);
var _ = (function (){var statearr_18321 = state_18312;
(statearr_18321[(4)] = cljs.core.rest.call(null,(state_18312[(4)])));

return statearr_18321;
})();
var state_18312__$1 = (function (){var statearr_18322 = state_18312;
(statearr_18322[(7)] = inst_18307);

return statearr_18322;
})();
var statearr_18323_18333 = state_18312__$1;
(statearr_18323_18333[(2)] = key);

(statearr_18323_18333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0 = (function (){
var statearr_18324 = [null,null,null,null,null,null,null,null];
(statearr_18324[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__);

(statearr_18324[(1)] = (1));

return statearr_18324;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1 = (function (state_18312){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18325){var ex__2749__auto__ = e18325;
var statearr_18326_18334 = state_18312;
(statearr_18326_18334[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18312[(4)]))){
var statearr_18327_18335 = state_18312;
(statearr_18327_18335[(1)] = cljs.core.first.call(null,(state_18312[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18336 = state_18312;
state_18312 = G__18336;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = function(state_18312){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1.call(this,state_18312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18328 = f__2769__auto__.call(null);
(statearr_18328[(6)] = c__2768__auto__);

return statearr_18328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__18337_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__18337_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__18338){
var map__18339 = p__18338;
var map__18339__$1 = cljs.core.__destructure_map.call(null,map__18339);
var progress = map__18339__$1;
var garbage = cljs.core.get.call(null,map__18339__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18367){
var state_val_18368 = (state_18367[(1)]);
if((state_val_18368 === (1))){
var state_18367__$1 = state_18367;
var statearr_18369_18385 = state_18367__$1;
(statearr_18369_18385[(2)] = null);

(statearr_18369_18385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18368 === (2))){
var inst_18353 = (state_18367[(7)]);
var _ = (function (){var statearr_18370 = state_18367;
(statearr_18370[(4)] = cljs.core.cons.call(null,(5),(state_18367[(4)])));

return statearr_18370;
})();
var inst_18347 = db;
var inst_18348 = cljs.core.__destructure_map.call(null,inst_18347);
var inst_18349 = cljs.core.get.call(null,inst_18348,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18350 = cljs.core.get.call(null,inst_18348,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18351 = cljs.core.get.call(null,inst_18348,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18352 = cljs.core.get.call(null,inst_18348,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18353__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_18350,inst_18351,inst_18352);
var inst_18354 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_18355 = [inst_18351,inst_18352,garbage];
var inst_18356 = cljs.core.PersistentHashMap.fromArrays(inst_18354,inst_18355);
var inst_18357 = fluree.db.storage.core.serde.call(null,inst_18349);
var inst_18358 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_18357,inst_18356);
var inst_18359 = fluree.db.storage.core.storage_write.call(null,inst_18349,inst_18353__$1,inst_18358);
var state_18367__$1 = (function (){var statearr_18371 = state_18367;
(statearr_18371[(7)] = inst_18353__$1);

return statearr_18371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18367__$1,(6),inst_18359);
} else {
if((state_val_18368 === (3))){
var inst_18365 = (state_18367[(2)]);
var state_18367__$1 = state_18367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18367__$1,inst_18365);
} else {
if((state_val_18368 === (4))){
var inst_18340 = (state_18367[(2)]);
var state_18367__$1 = state_18367;
var statearr_18373_18386 = state_18367__$1;
(statearr_18373_18386[(2)] = inst_18340);

(statearr_18373_18386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18368 === (5))){
var _ = (function (){var statearr_18374 = state_18367;
(statearr_18374[(4)] = cljs.core.rest.call(null,(state_18367[(4)])));

return statearr_18374;
})();
var state_18367__$1 = state_18367;
var ex18372 = (state_18367__$1[(2)]);
var statearr_18375_18387 = state_18367__$1;
(statearr_18375_18387[(5)] = ex18372);


if((ex18372 instanceof Error)){
var statearr_18376_18388 = state_18367__$1;
(statearr_18376_18388[(1)] = (4));

(statearr_18376_18388[(5)] = null);

} else {
throw ex18372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18368 === (6))){
var inst_18353 = (state_18367[(7)]);
var inst_18361 = (state_18367[(2)]);
var inst_18362 = fluree.db.util.async.throw_err.call(null,inst_18361);
var _ = (function (){var statearr_18377 = state_18367;
(statearr_18377[(4)] = cljs.core.rest.call(null,(state_18367[(4)])));

return statearr_18377;
})();
var state_18367__$1 = (function (){var statearr_18378 = state_18367;
(statearr_18378[(8)] = inst_18362);

return statearr_18378;
})();
var statearr_18379_18389 = state_18367__$1;
(statearr_18379_18389[(2)] = inst_18353);

(statearr_18379_18389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_18380 = [null,null,null,null,null,null,null,null,null];
(statearr_18380[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__);

(statearr_18380[(1)] = (1));

return statearr_18380;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1 = (function (state_18367){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18381){var ex__2749__auto__ = e18381;
var statearr_18382_18390 = state_18367;
(statearr_18382_18390[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18367[(4)]))){
var statearr_18383_18391 = state_18367;
(statearr_18383_18391[(1)] = cljs.core.first.call(null,(state_18367[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18392 = state_18367;
state_18367 = G__18392;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = function(state_18367){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1.call(this,state_18367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18384 = f__2769__auto__.call(null);
(statearr_18384[(6)] = c__2768__auto__);

return statearr_18384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__18394 = arguments.length;
switch (G__18394) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18450){
var state_val_18451 = (state_18450[(1)]);
if((state_val_18451 === (7))){
var state_18450__$1 = state_18450;
var statearr_18452_18478 = state_18450__$1;
(statearr_18452_18478[(2)] = (0));

(statearr_18452_18478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (1))){
var state_18450__$1 = state_18450;
var statearr_18453_18479 = state_18450__$1;
(statearr_18453_18479[(2)] = null);

(statearr_18453_18479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (4))){
var inst_18395 = (state_18450[(2)]);
var state_18450__$1 = state_18450;
var statearr_18454_18480 = state_18450__$1;
(statearr_18454_18480[(2)] = inst_18395);

(statearr_18454_18480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (6))){
var inst_18420 = (state_18450[(7)]);
var state_18450__$1 = state_18450;
var statearr_18455_18481 = state_18450__$1;
(statearr_18455_18481[(2)] = inst_18420);

(statearr_18455_18481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (3))){
var inst_18448 = (state_18450[(2)]);
var state_18450__$1 = state_18450;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18450__$1,inst_18448);
} else {
if((state_val_18451 === (12))){
var inst_18417 = (state_18450[(8)]);
var inst_18444 = (state_18450[(2)]);
var inst_18445 = fluree.db.util.async.throw_err.call(null,inst_18444);
var _ = (function (){var statearr_18456 = state_18450;
(statearr_18456[(4)] = cljs.core.rest.call(null,(state_18450[(4)])));

return statearr_18456;
})();
var state_18450__$1 = (function (){var statearr_18457 = state_18450;
(statearr_18457[(9)] = inst_18445);

return statearr_18457;
})();
var statearr_18458_18482 = state_18450__$1;
(statearr_18458_18482[(2)] = inst_18417);

(statearr_18458_18482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (2))){
var inst_18408 = (state_18450[(10)]);
var inst_18410 = (state_18450[(11)]);
var inst_18420 = (state_18450[(7)]);
var inst_18412 = (state_18450[(12)]);
var _ = (function (){var statearr_18459 = state_18450;
(statearr_18459[(4)] = cljs.core.cons.call(null,(5),(state_18450[(4)])));

return statearr_18459;
})();
var inst_18402 = db;
var inst_18403 = cljs.core.__destructure_map.call(null,inst_18402);
var inst_18404 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18405 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_18406 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_18407 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_18408__$1 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_18409 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18410__$1 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18411 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_18412__$1 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18413 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_18414 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_18415 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_18416 = cljs.core.get.call(null,inst_18403,new cljs.core.Keyword(null,"post","post",269697687));
var inst_18417 = fluree.db.storage.core.ledger_root_key.call(null,inst_18404,inst_18412__$1,inst_18410__$1);
var inst_18418 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_18419 = fluree.db.storage.core.child_data.call(null,inst_18411);
var inst_18420__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_18408__$1);
var state_18450__$1 = (function (){var statearr_18460 = state_18450;
(statearr_18460[(10)] = inst_18408__$1);

(statearr_18460[(13)] = inst_18414);

(statearr_18460[(11)] = inst_18410__$1);

(statearr_18460[(7)] = inst_18420__$1);

(statearr_18460[(14)] = inst_18406);

(statearr_18460[(8)] = inst_18417);

(statearr_18460[(12)] = inst_18412__$1);

(statearr_18460[(15)] = inst_18419);

(statearr_18460[(16)] = inst_18405);

(statearr_18460[(17)] = inst_18415);

(statearr_18460[(18)] = inst_18418);

(statearr_18460[(19)] = inst_18413);

(statearr_18460[(20)] = inst_18416);

(statearr_18460[(21)] = inst_18409);

(statearr_18460[(22)] = inst_18407);

return statearr_18460;
})();
if(cljs.core.truth_(inst_18420__$1)){
var statearr_18461_18483 = state_18450__$1;
(statearr_18461_18483[(1)] = (6));

} else {
var statearr_18462_18484 = state_18450__$1;
(statearr_18462_18484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (11))){
var inst_18408 = (state_18450[(10)]);
var inst_18414 = (state_18450[(13)]);
var inst_18410 = (state_18450[(11)]);
var inst_18406 = (state_18450[(14)]);
var inst_18424 = (state_18450[(23)]);
var inst_18417 = (state_18450[(8)]);
var inst_18412 = (state_18450[(12)]);
var inst_18419 = (state_18450[(15)]);
var inst_18405 = (state_18450[(16)]);
var inst_18415 = (state_18450[(17)]);
var inst_18418 = (state_18450[(18)]);
var inst_18416 = (state_18450[(20)]);
var inst_18409 = (state_18450[(21)]);
var inst_18407 = (state_18450[(22)]);
var inst_18429 = (state_18450[(2)]);
var inst_18430 = fluree.db.storage.core.child_data.call(null,inst_18414);
var inst_18431 = fluree.db.storage.core.child_data.call(null,inst_18416);
var inst_18432 = fluree.db.util.core.current_time_millis.call(null);
var inst_18433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18434 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_18435 = (new cljs.core.PersistentVector(null,2,(5),inst_18433,inst_18434,null));
var inst_18436 = cljs.core.select_keys.call(null,inst_18408,inst_18435);
var inst_18437 = fluree.db.storage.core.child_data.call(null,inst_18407);
var inst_18438 = [inst_18410,inst_18419,inst_18412,inst_18424,inst_18429,inst_18430,inst_18431,inst_18405,inst_18432,inst_18406,inst_18415,inst_18436,inst_18437];
var inst_18439 = cljs.core.PersistentHashMap.fromArrays(inst_18418,inst_18438);
var inst_18440 = fluree.db.storage.core.serde.call(null,inst_18409);
var inst_18441 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_18440,inst_18439);
var inst_18442 = fluree.db.storage.core.storage_write.call(null,inst_18409,inst_18417,inst_18441);
var state_18450__$1 = state_18450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18450__$1,(12),inst_18442);
} else {
if((state_val_18451 === (9))){
var inst_18425 = (state_18450[(24)]);
var state_18450__$1 = state_18450;
var statearr_18464_18485 = state_18450__$1;
(statearr_18464_18485[(2)] = inst_18425);

(statearr_18464_18485[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (5))){
var _ = (function (){var statearr_18465 = state_18450;
(statearr_18465[(4)] = cljs.core.rest.call(null,(state_18450[(4)])));

return statearr_18465;
})();
var state_18450__$1 = state_18450;
var ex18463 = (state_18450__$1[(2)]);
var statearr_18466_18486 = state_18450__$1;
(statearr_18466_18486[(5)] = ex18463);


if((ex18463 instanceof Error)){
var statearr_18467_18487 = state_18450__$1;
(statearr_18467_18487[(1)] = (4));

(statearr_18467_18487[(5)] = null);

} else {
throw ex18463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (10))){
var inst_18413 = (state_18450[(19)]);
var state_18450__$1 = state_18450;
var statearr_18468_18488 = state_18450__$1;
(statearr_18468_18488[(2)] = inst_18413);

(statearr_18468_18488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18451 === (8))){
var inst_18425 = (state_18450[(24)]);
var inst_18424 = (state_18450[(2)]);
var inst_18425__$1 = custom_ecount;
var state_18450__$1 = (function (){var statearr_18469 = state_18450;
(statearr_18469[(24)] = inst_18425__$1);

(statearr_18469[(23)] = inst_18424);

return statearr_18469;
})();
if(cljs.core.truth_(inst_18425__$1)){
var statearr_18470_18489 = state_18450__$1;
(statearr_18470_18489[(1)] = (9));

} else {
var statearr_18471_18490 = state_18450__$1;
(statearr_18471_18490[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_18472 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18472[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_18472[(1)] = (1));

return statearr_18472;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_18450){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18450);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18473){var ex__2749__auto__ = e18473;
var statearr_18474_18491 = state_18450;
(statearr_18474_18491[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18450[(4)]))){
var statearr_18475_18492 = state_18450;
(statearr_18475_18492[(1)] = cljs.core.first.call(null,(state_18450[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18493 = state_18450;
state_18450 = G__18493;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_18450){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_18450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18476 = f__2769__auto__.call(null);
(statearr_18476[(6)] = c__2768__auto__);

return statearr_18476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___18552 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18526){
var state_val_18527 = (state_18526[(1)]);
if((state_val_18527 === (7))){
var inst_18506 = (state_18526[(7)]);
var state_18526__$1 = state_18526;
var statearr_18528_18553 = state_18526__$1;
(statearr_18528_18553[(2)] = inst_18506);

(statearr_18528_18553[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (1))){
var state_18526__$1 = state_18526;
var statearr_18529_18554 = state_18526__$1;
(statearr_18529_18554[(2)] = null);

(statearr_18529_18554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (4))){
var inst_18494 = (state_18526[(2)]);
var inst_18495 = error_fn.call(null);
var inst_18496 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18494);
var inst_18497 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18526__$1 = (function (){var statearr_18530 = state_18526;
(statearr_18530[(8)] = inst_18495);

(statearr_18530[(9)] = inst_18496);

return statearr_18530;
})();
var statearr_18531_18555 = state_18526__$1;
(statearr_18531_18555[(2)] = inst_18497);

(statearr_18531_18555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (6))){
var inst_18506 = (state_18526[(7)]);
var inst_18505 = (state_18526[(10)]);
var inst_18505__$1 = (state_18526[(2)]);
var inst_18506__$1 = (inst_18505__$1 == null);
var state_18526__$1 = (function (){var statearr_18532 = state_18526;
(statearr_18532[(7)] = inst_18506__$1);

(statearr_18532[(10)] = inst_18505__$1);

return statearr_18532;
})();
if(cljs.core.truth_(inst_18506__$1)){
var statearr_18533_18556 = state_18526__$1;
(statearr_18533_18556[(1)] = (7));

} else {
var statearr_18534_18557 = state_18526__$1;
(statearr_18534_18557[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (3))){
var inst_18524 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18526__$1,inst_18524);
} else {
if((state_val_18527 === (12))){
var inst_18521 = (state_18526[(2)]);
var _ = (function (){var statearr_18535 = state_18526;
(statearr_18535[(4)] = cljs.core.rest.call(null,(state_18526[(4)])));

return statearr_18535;
})();
var state_18526__$1 = state_18526;
var statearr_18536_18558 = state_18526__$1;
(statearr_18536_18558[(2)] = inst_18521);

(statearr_18536_18558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (2))){
var _ = (function (){var statearr_18537 = state_18526;
(statearr_18537[(4)] = cljs.core.cons.call(null,(5),(state_18526[(4)])));

return statearr_18537;
})();
var inst_18503 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18526__$1 = state_18526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(6),inst_18503);
} else {
if((state_val_18527 === (11))){
var inst_18505 = (state_18526[(10)]);
var inst_18515 = fluree.db.storage.core.serde.call(null,conn);
var inst_18516 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_18515,inst_18505);
var inst_18517 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18516);
var inst_18518 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_18517);
var inst_18519 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18518);
var state_18526__$1 = state_18526;
var statearr_18539_18559 = state_18526__$1;
(statearr_18539_18559[(2)] = inst_18519);

(statearr_18539_18559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (9))){
var inst_18511 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
if(cljs.core.truth_(inst_18511)){
var statearr_18540_18560 = state_18526__$1;
(statearr_18540_18560[(1)] = (10));

} else {
var statearr_18541_18561 = state_18526__$1;
(statearr_18541_18561[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (5))){
var _ = (function (){var statearr_18542 = state_18526;
(statearr_18542[(4)] = cljs.core.rest.call(null,(state_18526[(4)])));

return statearr_18542;
})();
var state_18526__$1 = state_18526;
var ex18538 = (state_18526__$1[(2)]);
var statearr_18543_18562 = state_18526__$1;
(statearr_18543_18562[(5)] = ex18538);


var statearr_18544_18563 = state_18526__$1;
(statearr_18544_18563[(1)] = (4));

(statearr_18544_18563[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (10))){
var inst_18513 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18526__$1 = state_18526;
var statearr_18545_18564 = state_18526__$1;
(statearr_18545_18564[(2)] = inst_18513);

(statearr_18545_18564[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (8))){
var inst_18505 = (state_18526[(10)]);
var inst_18509 = (inst_18505 instanceof Error);
var state_18526__$1 = state_18526;
var statearr_18546_18565 = state_18526__$1;
(statearr_18546_18565[(2)] = inst_18509);

(statearr_18546_18565[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2746__auto____0 = (function (){
var statearr_18547 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18547[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2746__auto__);

(statearr_18547[(1)] = (1));

return statearr_18547;
});
var fluree$db$storage$core$reify_history_$_state_machine__2746__auto____1 = (function (state_18526){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18548){var ex__2749__auto__ = e18548;
var statearr_18549_18566 = state_18526;
(statearr_18549_18566[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18526[(4)]))){
var statearr_18550_18567 = state_18526;
(statearr_18550_18567[(1)] = cljs.core.first.call(null,(state_18526[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18568 = state_18526;
state_18526 = G__18568;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2746__auto__ = function(state_18526){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2746__auto____1.call(this,state_18526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18551 = f__2769__auto__.call(null);
(statearr_18551[(6)] = c__2768__auto___18552);

return statearr_18551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__18570 = arguments.length;
switch (G__18570) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___18680 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18633){
var state_val_18634 = (state_18633[(1)]);
if((state_val_18634 === (7))){
var state_18633__$1 = state_18633;
var statearr_18635_18681 = state_18633__$1;
(statearr_18635_18681[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_18635_18681[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (20))){
var inst_18612 = cljs.core.PersistentVector.EMPTY;
var state_18633__$1 = state_18633;
var statearr_18636_18682 = state_18633__$1;
(statearr_18636_18682[(2)] = inst_18612);

(statearr_18636_18682[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (1))){
var state_18633__$1 = state_18633;
var statearr_18637_18683 = state_18633__$1;
(statearr_18637_18683[(2)] = null);

(statearr_18637_18683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (24))){
var state_18633__$1 = state_18633;
var statearr_18638_18684 = state_18633__$1;
(statearr_18638_18684[(2)] = null);

(statearr_18638_18684[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (4))){
var inst_18573 = (state_18633[(2)]);
var inst_18574 = error_fn.call(null);
var inst_18575 = cljs.core.async.put_BANG_.call(null,result_ch,inst_18573);
var inst_18576 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_18633__$1 = (function (){var statearr_18639 = state_18633;
(statearr_18639[(7)] = inst_18575);

(statearr_18639[(8)] = inst_18574);

return statearr_18639;
})();
var statearr_18640_18685 = state_18633__$1;
(statearr_18640_18685[(2)] = inst_18576);

(statearr_18640_18685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (15))){
var inst_18598 = (state_18633[(2)]);
var state_18633__$1 = state_18633;
var statearr_18641_18686 = state_18633__$1;
(statearr_18641_18686[(2)] = inst_18598);

(statearr_18641_18686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (21))){
var inst_18586 = (state_18633[(9)]);
var inst_18602 = (state_18633[(10)]);
var inst_18615 = (state_18633[(11)]);
var inst_18585 = (state_18633[(12)]);
var inst_18587 = (state_18633[(13)]);
var inst_18622 = (state_18633[(2)]);
var inst_18623 = (function (){var base_node = inst_18585;
var first_flake = inst_18586;
var node_t = inst_18587;
var source = inst_18602;
var coll = inst_18615;
var conj_QMARK_ = inst_18622;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__5045__auto__ = remove_preds;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_18624 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18585);
var inst_18625 = cljs.core.reduce.call(null,inst_18623,inst_18624,inst_18615);
var inst_18626 = cljs.core.doall.call(null,inst_18625);
var inst_18627 = cljs.core.assoc.call(null,inst_18585,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18626);
var inst_18628 = cljs.core.async.put_BANG_.call(null,result_ch,inst_18627);
var _ = (function (){var statearr_18642 = state_18633;
(statearr_18642[(4)] = cljs.core.rest.call(null,(state_18633[(4)])));

return statearr_18642;
})();
var state_18633__$1 = state_18633;
var statearr_18643_18687 = state_18633__$1;
(statearr_18643_18687[(2)] = inst_18628);

(statearr_18643_18687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (13))){
var state_18633__$1 = state_18633;
var statearr_18644_18688 = state_18633__$1;
(statearr_18644_18688[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_18644_18688[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (22))){
var inst_18586 = (state_18633[(9)]);
var inst_18602 = (state_18633[(10)]);
var inst_18615 = (state_18633[(11)]);
var inst_18585 = (state_18633[(12)]);
var inst_18587 = (state_18633[(13)]);
var inst_18616 = (function (){var base_node = inst_18585;
var first_flake = inst_18586;
var node_t = inst_18587;
var source = inst_18602;
var coll = inst_18615;
return (function (f){
return f.op === true;
});
})();
var state_18633__$1 = state_18633;
var statearr_18645_18689 = state_18633__$1;
(statearr_18645_18689[(2)] = inst_18616);

(statearr_18645_18689[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (6))){
var inst_18585 = (state_18633[(12)]);
var inst_18587 = (state_18633[(13)]);
var inst_18584 = (state_18633[(2)]);
var inst_18585__$1 = fluree.db.util.async.throw_err.call(null,inst_18584);
var inst_18586 = fluree.db.dbproto._first_flake.call(null,inst_18585__$1);
var inst_18587__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_18585__$1);
var inst_18588 = (inst_18587__$1 > t);
var state_18633__$1 = (function (){var statearr_18646 = state_18633;
(statearr_18646[(9)] = inst_18586);

(statearr_18646[(12)] = inst_18585__$1);

(statearr_18646[(13)] = inst_18587__$1);

return statearr_18646;
})();
if(cljs.core.truth_(inst_18588)){
var statearr_18647_18690 = state_18633__$1;
(statearr_18647_18690[(1)] = (7));

} else {
var statearr_18648_18691 = state_18633__$1;
(statearr_18648_18691[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (17))){
var inst_18586 = (state_18633[(9)]);
var inst_18603 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_18586,rhs,leftmost_QMARK_,t);
var state_18633__$1 = state_18633;
var statearr_18649_18692 = state_18633__$1;
(statearr_18649_18692[(2)] = inst_18603);

(statearr_18649_18692[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (3))){
var inst_18631 = (state_18633[(2)]);
var state_18633__$1 = state_18633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18633__$1,inst_18631);
} else {
if((state_val_18634 === (12))){
var inst_18600 = (state_18633[(2)]);
var state_18633__$1 = state_18633;
var statearr_18650_18693 = state_18633__$1;
(statearr_18650_18693[(2)] = inst_18600);

(statearr_18650_18693[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (2))){
var _ = (function (){var statearr_18651 = state_18633;
(statearr_18651[(4)] = cljs.core.cons.call(null,(5),(state_18633[(4)])));

return statearr_18651;
})();
var inst_18582 = fluree.db.dbproto._resolve.call(null,node);
var state_18633__$1 = state_18633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18633__$1,(6),inst_18582);
} else {
if((state_val_18634 === (23))){
var inst_18586 = (state_18633[(9)]);
var inst_18602 = (state_18633[(10)]);
var inst_18615 = (state_18633[(11)]);
var inst_18585 = (state_18633[(12)]);
var inst_18587 = (state_18633[(13)]);
var inst_18618 = (function (){var base_node = inst_18585;
var first_flake = inst_18586;
var node_t = inst_18587;
var source = inst_18602;
var coll = inst_18615;
return (function (f){
return f.op === false;
});
})();
var state_18633__$1 = state_18633;
var statearr_18652_18694 = state_18633__$1;
(statearr_18652_18694[(2)] = inst_18618);

(statearr_18652_18694[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (19))){
var inst_18605 = (state_18633[(14)]);
var inst_18608 = (state_18633[(2)]);
var inst_18609 = fluree.db.util.async.throw_err.call(null,inst_18608);
var inst_18610 = cljs.core.take_while.call(null,inst_18605,inst_18609);
var state_18633__$1 = state_18633;
var statearr_18653_18695 = state_18633__$1;
(statearr_18653_18695[(2)] = inst_18610);

(statearr_18653_18695[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (11))){
var inst_18587 = (state_18633[(13)]);
var inst_18594 = cljs.core._EQ_.call(null,inst_18587,t);
var state_18633__$1 = state_18633;
if(inst_18594){
var statearr_18655_18696 = state_18633__$1;
(statearr_18655_18696[(1)] = (13));

} else {
var statearr_18656_18697 = state_18633__$1;
(statearr_18656_18697[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (9))){
var inst_18602 = (state_18633[(10)]);
var inst_18602__$1 = (state_18633[(2)]);
var state_18633__$1 = (function (){var statearr_18657 = state_18633;
(statearr_18657[(10)] = inst_18602__$1);

return statearr_18657;
})();
var G__18658_18698 = inst_18602__$1;
var G__18658_18699__$1 = (((G__18658_18698 instanceof cljs.core.Keyword))?G__18658_18698.fqn:null);
switch (G__18658_18699__$1) {
case "novelty":
var statearr_18659_18701 = state_18633__$1;
(statearr_18659_18701[(1)] = (17));


break;
case "history":
var statearr_18660_18702 = state_18633__$1;
(statearr_18660_18702[(1)] = (18));


break;
case "none":
var statearr_18661_18703 = state_18633__$1;
(statearr_18661_18703[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18658_18699__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (5))){
var _ = (function (){var statearr_18662 = state_18633;
(statearr_18662[(4)] = cljs.core.rest.call(null,(state_18633[(4)])));

return statearr_18662;
})();
var state_18633__$1 = state_18633;
var ex18654 = (state_18633__$1[(2)]);
var statearr_18663_18704 = state_18633__$1;
(statearr_18663_18704[(5)] = ex18654);


var statearr_18664_18705 = state_18633__$1;
(statearr_18664_18705[(1)] = (4));

(statearr_18664_18705[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (14))){
var state_18633__$1 = state_18633;
var statearr_18665_18706 = state_18633__$1;
(statearr_18665_18706[(2)] = null);

(statearr_18665_18706[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (16))){
var inst_18602 = (state_18633[(10)]);
var inst_18615 = (state_18633[(2)]);
var state_18633__$1 = (function (){var statearr_18666 = state_18633;
(statearr_18666[(11)] = inst_18615);

return statearr_18666;
})();
var G__18667_18707 = inst_18602;
var G__18667_18708__$1 = (((G__18667_18707 instanceof cljs.core.Keyword))?G__18667_18707.fqn:null);
switch (G__18667_18708__$1) {
case "novelty":
var statearr_18668_18710 = state_18633__$1;
(statearr_18668_18710[(1)] = (22));


break;
case "history":
var statearr_18669_18711 = state_18633__$1;
(statearr_18669_18711[(1)] = (23));


break;
case "none":
var statearr_18670_18712 = state_18633__$1;
(statearr_18670_18712[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18667_18708__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (10))){
var state_18633__$1 = state_18633;
var statearr_18671_18713 = state_18633__$1;
(statearr_18671_18713[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_18671_18713[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18634 === (18))){
var inst_18586 = (state_18633[(9)]);
var inst_18602 = (state_18633[(10)]);
var inst_18585 = (state_18633[(12)]);
var inst_18587 = (state_18633[(13)]);
var inst_18605 = (function (){var base_node = inst_18585;
var first_flake = inst_18586;
var node_t = inst_18587;
var source = inst_18602;
return (function (p1__18572_SHARP_){
return (p1__18572_SHARP_.t <= t);
});
})();
var inst_18606 = fluree.db.dbproto._resolve_history.call(null,node);
var state_18633__$1 = (function (){var statearr_18672 = state_18633;
(statearr_18672[(14)] = inst_18605);

return statearr_18672;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18633__$1,(19),inst_18606);
} else {
if((state_val_18634 === (8))){
var inst_18587 = (state_18633[(13)]);
var inst_18591 = (inst_18587 < t);
var state_18633__$1 = state_18633;
if(cljs.core.truth_(inst_18591)){
var statearr_18673_18714 = state_18633__$1;
(statearr_18673_18714[(1)] = (10));

} else {
var statearr_18674_18715 = state_18633__$1;
(statearr_18674_18715[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____0 = (function (){
var statearr_18675 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18675[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__);

(statearr_18675[(1)] = (1));

return statearr_18675;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____1 = (function (state_18633){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18676){var ex__2749__auto__ = e18676;
var statearr_18677_18716 = state_18633;
(statearr_18677_18716[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18633[(4)]))){
var statearr_18678_18717 = state_18633;
(statearr_18678_18717[(1)] = cljs.core.first.call(null,(state_18633[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18718 = state_18633;
state_18633 = G__18718;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__ = function(state_18633){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____1.call(this,state_18633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18679 = f__2769__auto__.call(null);
(statearr_18679[(6)] = c__2768__auto___18680);

return statearr_18679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18778){
var state_val_18779 = (state_18778[(1)]);
if((state_val_18779 === (7))){
var inst_18729 = (state_18778[(7)]);
var inst_18733 = (inst_18729 <= from_t);
var state_18778__$1 = state_18778;
var statearr_18780_18820 = state_18778__$1;
(statearr_18780_18820[(2)] = inst_18733);

(statearr_18780_18820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (20))){
var inst_18763 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_18764 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18763)].join('');
var inst_18765 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18766 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18767 = cljs.core.PersistentHashMap.fromArrays(inst_18765,inst_18766);
var inst_18768 = cljs.core.ex_info.call(null,inst_18764,inst_18767);
var inst_18769 = (function(){throw inst_18768})();
var state_18778__$1 = state_18778;
var statearr_18781_18821 = state_18778__$1;
(statearr_18781_18821[(2)] = inst_18769);

(statearr_18781_18821[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (1))){
var state_18778__$1 = state_18778;
var statearr_18782_18822 = state_18778__$1;
(statearr_18782_18822[(2)] = null);

(statearr_18782_18822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (4))){
var inst_18721 = (state_18778[(2)]);
var inst_18722 = fluree.db.util.log.error.call(null,inst_18721);
var inst_18723 = (function(){throw inst_18721})();
var state_18778__$1 = (function (){var statearr_18783 = state_18778;
(statearr_18783[(8)] = inst_18722);

return statearr_18783;
})();
var statearr_18784_18823 = state_18778__$1;
(statearr_18784_18823[(2)] = inst_18723);

(statearr_18784_18823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (15))){
var inst_18748 = (state_18778[(2)]);
var state_18778__$1 = (function (){var statearr_18785 = state_18778;
(statearr_18785[(9)] = inst_18748);

return statearr_18785;
})();
if(cljs.core.truth_(from_t)){
var statearr_18786_18824 = state_18778__$1;
(statearr_18786_18824[(1)] = (16));

} else {
var statearr_18787_18825 = state_18778__$1;
(statearr_18787_18825[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (21))){
var inst_18759 = (state_18778[(10)]);
var inst_18758 = (state_18778[(11)]);
var inst_18757 = (state_18778[(12)]);
var inst_18771 = (state_18778[(2)]);
var inst_18772 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_18758,inst_18759,leftmost_QMARK_,to_t);
var inst_18773 = cljs.core.into.call(null,inst_18772,inst_18757);
var _ = (function (){var statearr_18788 = state_18778;
(statearr_18788[(4)] = cljs.core.rest.call(null,(state_18778[(4)])));

return statearr_18788;
})();
var state_18778__$1 = (function (){var statearr_18789 = state_18778;
(statearr_18789[(13)] = inst_18771);

return statearr_18789;
})();
var statearr_18790_18826 = state_18778__$1;
(statearr_18790_18826[(2)] = inst_18773);

(statearr_18790_18826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (13))){
var inst_18729 = (state_18778[(7)]);
var inst_18741 = (state_18778[(14)]);
var inst_18744 = (function (){var node_t = inst_18729;
var G__18737 = inst_18741;
return (function (p1__18719_SHARP_){
return (p1__18719_SHARP_.t < to_t);
});
})();
var inst_18745 = cljs.core.drop_while.call(null,inst_18744,inst_18741);
var state_18778__$1 = state_18778;
var statearr_18791_18827 = state_18778__$1;
(statearr_18791_18827[(2)] = inst_18745);

(statearr_18791_18827[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (6))){
var inst_18730 = (state_18778[(15)]);
var state_18778__$1 = state_18778;
var statearr_18792_18828 = state_18778__$1;
(statearr_18792_18828[(2)] = inst_18730);

(statearr_18792_18828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (17))){
var inst_18748 = (state_18778[(9)]);
var state_18778__$1 = state_18778;
var statearr_18793_18829 = state_18778__$1;
(statearr_18793_18829[(2)] = inst_18748);

(statearr_18793_18829[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (3))){
var inst_18776 = (state_18778[(2)]);
var state_18778__$1 = state_18778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18778__$1,inst_18776);
} else {
if((state_val_18779 === (12))){
var inst_18729 = (state_18778[(7)]);
var inst_18740 = (state_18778[(2)]);
var inst_18741 = fluree.db.util.async.throw_err.call(null,inst_18740);
var inst_18742 = (to_t > inst_18729);
var state_18778__$1 = (function (){var statearr_18794 = state_18778;
(statearr_18794[(14)] = inst_18741);

return statearr_18794;
})();
if(cljs.core.truth_(inst_18742)){
var statearr_18795_18830 = state_18778__$1;
(statearr_18795_18830[(1)] = (13));

} else {
var statearr_18796_18831 = state_18778__$1;
(statearr_18796_18831[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (2))){
var inst_18730 = (state_18778[(15)]);
var _ = (function (){var statearr_18797 = state_18778;
(statearr_18797[(4)] = cljs.core.cons.call(null,(5),(state_18778[(4)])));

return statearr_18797;
})();
var inst_18729 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_18730__$1 = (from_t == null);
var state_18778__$1 = (function (){var statearr_18798 = state_18778;
(statearr_18798[(7)] = inst_18729);

(statearr_18798[(15)] = inst_18730__$1);

return statearr_18798;
})();
if(cljs.core.truth_(inst_18730__$1)){
var statearr_18799_18832 = state_18778__$1;
(statearr_18799_18832[(1)] = (6));

} else {
var statearr_18800_18833 = state_18778__$1;
(statearr_18800_18833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (19))){
var state_18778__$1 = state_18778;
var statearr_18801_18834 = state_18778__$1;
(statearr_18801_18834[(2)] = null);

(statearr_18801_18834[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (11))){
var inst_18757 = (state_18778[(2)]);
var inst_18758 = fluree.db.dbproto._first_flake.call(null,node);
var inst_18759 = fluree.db.dbproto._rhs.call(null,node);
var inst_18760 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18778__$1 = (function (){var statearr_18803 = state_18778;
(statearr_18803[(10)] = inst_18759);

(statearr_18803[(11)] = inst_18758);

(statearr_18803[(12)] = inst_18757);

return statearr_18803;
})();
if(cljs.core.truth_(inst_18760)){
var statearr_18804_18835 = state_18778__$1;
(statearr_18804_18835[(1)] = (19));

} else {
var statearr_18805_18836 = state_18778__$1;
(statearr_18805_18836[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (9))){
var inst_18738 = fluree.db.dbproto._resolve_history.call(null,node);
var state_18778__$1 = state_18778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18778__$1,(12),inst_18738);
} else {
if((state_val_18779 === (5))){
var _ = (function (){var statearr_18806 = state_18778;
(statearr_18806[(4)] = cljs.core.rest.call(null,(state_18778[(4)])));

return statearr_18806;
})();
var state_18778__$1 = state_18778;
var ex18802 = (state_18778__$1[(2)]);
var statearr_18807_18837 = state_18778__$1;
(statearr_18807_18837[(5)] = ex18802);


var statearr_18808_18838 = state_18778__$1;
(statearr_18808_18838[(1)] = (4));

(statearr_18808_18838[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (14))){
var inst_18741 = (state_18778[(14)]);
var state_18778__$1 = state_18778;
var statearr_18809_18839 = state_18778__$1;
(statearr_18809_18839[(2)] = inst_18741);

(statearr_18809_18839[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (16))){
var inst_18729 = (state_18778[(7)]);
var inst_18748 = (state_18778[(9)]);
var inst_18750 = (function (){var node_t = inst_18729;
var G__18737 = inst_18748;
return (function (p1__18720_SHARP_){
return (p1__18720_SHARP_.t <= from_t);
});
})();
var inst_18751 = cljs.core.take_while.call(null,inst_18750,inst_18748);
var state_18778__$1 = state_18778;
var statearr_18810_18840 = state_18778__$1;
(statearr_18810_18840[(2)] = inst_18751);

(statearr_18810_18840[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (10))){
var state_18778__$1 = state_18778;
var statearr_18811_18841 = state_18778__$1;
(statearr_18811_18841[(2)] = null);

(statearr_18811_18841[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (18))){
var inst_18754 = (state_18778[(2)]);
var state_18778__$1 = state_18778;
var statearr_18812_18842 = state_18778__$1;
(statearr_18812_18842[(2)] = inst_18754);

(statearr_18812_18842[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18779 === (8))){
var inst_18735 = (state_18778[(2)]);
var state_18778__$1 = state_18778;
if(cljs.core.truth_(inst_18735)){
var statearr_18813_18843 = state_18778__$1;
(statearr_18813_18843[(1)] = (9));

} else {
var statearr_18814_18844 = state_18778__$1;
(statearr_18814_18844[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____0 = (function (){
var statearr_18815 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18815[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__);

(statearr_18815[(1)] = (1));

return statearr_18815;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____1 = (function (state_18778){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18816){var ex__2749__auto__ = e18816;
var statearr_18817_18845 = state_18778;
(statearr_18817_18845[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18778[(4)]))){
var statearr_18818_18846 = state_18778;
(statearr_18818_18846[(1)] = cljs.core.first.call(null,(state_18778[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18847 = state_18778;
state_18778 = G__18847;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__ = function(state_18778){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____1.call(this,state_18778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18819 = f__2769__auto__.call(null);
(statearr_18819[(6)] = c__2768__auto__);

return statearr_18819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__5045__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18868){
var state_val_18869 = (state_18868[(1)]);
if((state_val_18869 === (7))){
var inst_18857 = (state_18868[(7)]);
var inst_18859 = fluree.db.storage.core.serde.call(null,conn);
var inst_18860 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_18859,inst_18857);
var state_18868__$1 = state_18868;
var statearr_18870_18889 = state_18868__$1;
(statearr_18870_18889[(2)] = inst_18860);

(statearr_18870_18889[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18869 === (1))){
var state_18868__$1 = state_18868;
var statearr_18871_18890 = state_18868__$1;
(statearr_18871_18890[(2)] = null);

(statearr_18871_18890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18869 === (4))){
var inst_18848 = (state_18868[(2)]);
var state_18868__$1 = state_18868;
var statearr_18872_18891 = state_18868__$1;
(statearr_18872_18891[(2)] = inst_18848);

(statearr_18872_18891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18869 === (6))){
var inst_18857 = (state_18868[(7)]);
var inst_18856 = (state_18868[(2)]);
var inst_18857__$1 = fluree.db.util.async.throw_err.call(null,inst_18856);
var state_18868__$1 = (function (){var statearr_18873 = state_18868;
(statearr_18873[(7)] = inst_18857__$1);

return statearr_18873;
})();
if(cljs.core.truth_(inst_18857__$1)){
var statearr_18874_18892 = state_18868__$1;
(statearr_18874_18892[(1)] = (7));

} else {
var statearr_18875_18893 = state_18868__$1;
(statearr_18875_18893[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18869 === (3))){
var inst_18866 = (state_18868[(2)]);
var state_18868__$1 = state_18868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18868__$1,inst_18866);
} else {
if((state_val_18869 === (2))){
var _ = (function (){var statearr_18877 = state_18868;
(statearr_18877[(4)] = cljs.core.cons.call(null,(5),(state_18868[(4)])));

return statearr_18877;
})();
var inst_18854 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18868__$1 = state_18868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18868__$1,(6),inst_18854);
} else {
if((state_val_18869 === (9))){
var inst_18863 = (state_18868[(2)]);
var _ = (function (){var statearr_18878 = state_18868;
(statearr_18878[(4)] = cljs.core.rest.call(null,(state_18868[(4)])));

return statearr_18878;
})();
var state_18868__$1 = state_18868;
var statearr_18879_18894 = state_18868__$1;
(statearr_18879_18894[(2)] = inst_18863);

(statearr_18879_18894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18869 === (5))){
var _ = (function (){var statearr_18880 = state_18868;
(statearr_18880[(4)] = cljs.core.rest.call(null,(state_18868[(4)])));

return statearr_18880;
})();
var state_18868__$1 = state_18868;
var ex18876 = (state_18868__$1[(2)]);
var statearr_18881_18895 = state_18868__$1;
(statearr_18881_18895[(5)] = ex18876);


if((ex18876 instanceof Error)){
var statearr_18882_18896 = state_18868__$1;
(statearr_18882_18896[(1)] = (4));

(statearr_18882_18896[(5)] = null);

} else {
throw ex18876;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18869 === (8))){
var state_18868__$1 = state_18868;
var statearr_18883_18897 = state_18868__$1;
(statearr_18883_18897[(2)] = null);

(statearr_18883_18897[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0 = (function (){
var statearr_18884 = [null,null,null,null,null,null,null,null];
(statearr_18884[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2746__auto__);

(statearr_18884[(1)] = (1));

return statearr_18884;
});
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1 = (function (state_18868){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18885){var ex__2749__auto__ = e18885;
var statearr_18886_18898 = state_18868;
(statearr_18886_18898[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18868[(4)]))){
var statearr_18887_18899 = state_18868;
(statearr_18887_18899[(1)] = cljs.core.first.call(null,(state_18868[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18900 = state_18868;
state_18868 = G__18900;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = function(state_18868){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1.call(this,state_18868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18888 = f__2769__auto__.call(null);
(statearr_18888[(6)] = c__2768__auto__);

return statearr_18888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___18979 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18951){
var state_val_18952 = (state_18951[(1)]);
if((state_val_18952 === (7))){
var inst_18918 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18919 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18920 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18921 = cljs.core.PersistentHashMap.fromArrays(inst_18919,inst_18920);
var inst_18922 = cljs.core.ex_info.call(null,inst_18918,inst_18921);
var inst_18923 = (function(){throw inst_18922})();
var state_18951__$1 = state_18951;
var statearr_18953_18980 = state_18951__$1;
(statearr_18953_18980[(2)] = inst_18923);

(statearr_18953_18980[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (1))){
var state_18951__$1 = state_18951;
var statearr_18954_18981 = state_18951__$1;
(statearr_18954_18981[(2)] = null);

(statearr_18954_18981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (4))){
var inst_18901 = (state_18951[(2)]);
var inst_18902 = error_fn.call(null);
var inst_18903 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18901);
var inst_18904 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18951__$1 = (function (){var statearr_18955 = state_18951;
(statearr_18955[(7)] = inst_18902);

(statearr_18955[(8)] = inst_18903);

return statearr_18955;
})();
var statearr_18956_18982 = state_18951__$1;
(statearr_18956_18982[(2)] = inst_18904);

(statearr_18956_18982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (6))){
var inst_18915 = (state_18951[(9)]);
var inst_18914 = (state_18951[(2)]);
var inst_18915__$1 = fluree.db.util.async.throw_err.call(null,inst_18914);
var inst_18916 = (inst_18915__$1 == null);
var state_18951__$1 = (function (){var statearr_18957 = state_18951;
(statearr_18957[(9)] = inst_18915__$1);

return statearr_18957;
})();
if(cljs.core.truth_(inst_18916)){
var statearr_18958_18983 = state_18951__$1;
(statearr_18958_18983[(1)] = (7));

} else {
var statearr_18959_18984 = state_18951__$1;
(statearr_18959_18984[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (3))){
var inst_18949 = (state_18951[(2)]);
var state_18951__$1 = state_18951;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18951__$1,inst_18949);
} else {
if((state_val_18952 === (12))){
var inst_18915 = (state_18951[(9)]);
var inst_18932 = (state_18951[(2)]);
var inst_18933 = cljs.core.__destructure_map.call(null,inst_18915);
var inst_18934 = cljs.core.get.call(null,inst_18933,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18935 = cljs.core.get.call(null,inst_18933,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18936 = config;
var inst_18937 = cljs.core.__destructure_map.call(null,inst_18936);
var inst_18938 = cljs.core.get.call(null,inst_18937,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18940 = (function (){var data = inst_18915;
var _ = inst_18932;
var map__18910 = inst_18933;
var children = inst_18934;
var rhs = inst_18935;
var map__18911 = inst_18937;
var comparator = inst_18938;
return (function (idx,p__18939){
var map__18960 = p__18939;
var map__18960__$1 = cljs.core.__destructure_map.call(null,map__18960);
var child = map__18960__$1;
var id = cljs.core.get.call(null,map__18960__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__18960__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__18960__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__18960__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__18960__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (idx === (0));
} else {
return and__5043__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_18941 = cljs.core.map_indexed.call(null,inst_18940,inst_18934);
var inst_18942 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_18941);
var inst_18943 = cljs.core.interleave.call(null,inst_18942,inst_18941);
var inst_18944 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_18938,inst_18943);
var inst_18945 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_18935,inst_18944,config,leftmost_QMARK_);
var inst_18946 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18945);
var _ = (function (){var statearr_18961 = state_18951;
(statearr_18961[(4)] = cljs.core.rest.call(null,(state_18951[(4)])));

return statearr_18961;
})();
var state_18951__$1 = state_18951;
var statearr_18962_18985 = state_18951__$1;
(statearr_18962_18985[(2)] = inst_18946);

(statearr_18962_18985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (2))){
var _ = (function (){var statearr_18963 = state_18951;
(statearr_18963[(4)] = cljs.core.cons.call(null,(5),(state_18951[(4)])));

return statearr_18963;
})();
var inst_18912 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_18951__$1 = state_18951;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18951__$1,(6),inst_18912);
} else {
if((state_val_18952 === (11))){
var state_18951__$1 = state_18951;
var statearr_18965_18986 = state_18951__$1;
(statearr_18965_18986[(2)] = null);

(statearr_18965_18986[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (9))){
var inst_18915 = (state_18951[(9)]);
var inst_18926 = (state_18951[(2)]);
var inst_18927 = fluree.db.util.core.exception_QMARK_.call(null,inst_18915);
var state_18951__$1 = (function (){var statearr_18966 = state_18951;
(statearr_18966[(10)] = inst_18926);

return statearr_18966;
})();
if(inst_18927){
var statearr_18967_18987 = state_18951__$1;
(statearr_18967_18987[(1)] = (10));

} else {
var statearr_18968_18988 = state_18951__$1;
(statearr_18968_18988[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (5))){
var _ = (function (){var statearr_18969 = state_18951;
(statearr_18969[(4)] = cljs.core.rest.call(null,(state_18951[(4)])));

return statearr_18969;
})();
var state_18951__$1 = state_18951;
var ex18964 = (state_18951__$1[(2)]);
var statearr_18970_18989 = state_18951__$1;
(statearr_18970_18989[(5)] = ex18964);


var statearr_18971_18990 = state_18951__$1;
(statearr_18971_18990[(1)] = (4));

(statearr_18971_18990[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (10))){
var inst_18915 = (state_18951[(9)]);
var inst_18929 = (function(){throw inst_18915})();
var state_18951__$1 = state_18951;
var statearr_18972_18991 = state_18951__$1;
(statearr_18972_18991[(2)] = inst_18929);

(statearr_18972_18991[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18952 === (8))){
var state_18951__$1 = state_18951;
var statearr_18973_18992 = state_18951__$1;
(statearr_18973_18992[(2)] = null);

(statearr_18973_18992[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____0 = (function (){
var statearr_18974 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18974[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__);

(statearr_18974[(1)] = (1));

return statearr_18974;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____1 = (function (state_18951){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18951);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18975){var ex__2749__auto__ = e18975;
var statearr_18976_18993 = state_18951;
(statearr_18976_18993[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18951[(4)]))){
var statearr_18977_18994 = state_18951;
(statearr_18977_18994[(1)] = cljs.core.first.call(null,(state_18951[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18995 = state_18951;
state_18951 = G__18995;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__ = function(state_18951){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____1.call(this,state_18951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18978 = f__2769__auto__.call(null);
(statearr_18978[(6)] = c__2768__auto___18979);

return statearr_18978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19016){
var state_val_19017 = (state_19016[(1)]);
if((state_val_19017 === (7))){
var state_19016__$1 = state_19016;
var statearr_19018_19038 = state_19016__$1;
(statearr_19018_19038[(2)] = null);

(statearr_19018_19038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19017 === (1))){
var state_19016__$1 = state_19016;
var statearr_19019_19039 = state_19016__$1;
(statearr_19019_19039[(2)] = null);

(statearr_19019_19039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19017 === (4))){
var inst_18996 = (state_19016[(2)]);
var state_19016__$1 = state_19016;
var statearr_19020_19040 = state_19016__$1;
(statearr_19020_19040[(2)] = inst_18996);

(statearr_19020_19040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19017 === (6))){
var inst_19002 = (state_19016[(7)]);
var inst_19004 = fluree.db.storage.core.serde.call(null,conn);
var state_19016__$1 = (function (){var statearr_19021 = state_19016;
(statearr_19021[(8)] = inst_19004);

return statearr_19021;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19016__$1,(9),inst_19002);
} else {
if((state_val_19017 === (3))){
var inst_19014 = (state_19016[(2)]);
var state_19016__$1 = state_19016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19016__$1,inst_19014);
} else {
if((state_val_19017 === (2))){
var inst_19002 = (state_19016[(7)]);
var _ = (function (){var statearr_19023 = state_19016;
(statearr_19023[(4)] = cljs.core.cons.call(null,(5),(state_19016[(4)])));

return statearr_19023;
})();
var inst_19002__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_19016__$1 = (function (){var statearr_19024 = state_19016;
(statearr_19024[(7)] = inst_19002__$1);

return statearr_19024;
})();
if(cljs.core.truth_(inst_19002__$1)){
var statearr_19025_19041 = state_19016__$1;
(statearr_19025_19041[(1)] = (6));

} else {
var statearr_19026_19042 = state_19016__$1;
(statearr_19026_19042[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19017 === (9))){
var inst_19004 = (state_19016[(8)]);
var inst_19006 = (state_19016[(2)]);
var inst_19007 = fluree.db.util.async.throw_err.call(null,inst_19006);
var inst_19008 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_19004,inst_19007);
var state_19016__$1 = state_19016;
var statearr_19027_19043 = state_19016__$1;
(statearr_19027_19043[(2)] = inst_19008);

(statearr_19027_19043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19017 === (5))){
var _ = (function (){var statearr_19028 = state_19016;
(statearr_19028[(4)] = cljs.core.rest.call(null,(state_19016[(4)])));

return statearr_19028;
})();
var state_19016__$1 = state_19016;
var ex19022 = (state_19016__$1[(2)]);
var statearr_19029_19044 = state_19016__$1;
(statearr_19029_19044[(5)] = ex19022);


if((ex19022 instanceof Error)){
var statearr_19030_19045 = state_19016__$1;
(statearr_19030_19045[(1)] = (4));

(statearr_19030_19045[(5)] = null);

} else {
throw ex19022;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19017 === (8))){
var inst_19011 = (state_19016[(2)]);
var _ = (function (){var statearr_19031 = state_19016;
(statearr_19031[(4)] = cljs.core.rest.call(null,(state_19016[(4)])));

return statearr_19031;
})();
var state_19016__$1 = state_19016;
var statearr_19032_19046 = state_19016__$1;
(statearr_19032_19046[(2)] = inst_19011);

(statearr_19032_19046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_19033 = [null,null,null,null,null,null,null,null,null];
(statearr_19033[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__);

(statearr_19033[(1)] = (1));

return statearr_19033;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1 = (function (state_19016){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19034){var ex__2749__auto__ = e19034;
var statearr_19035_19047 = state_19016;
(statearr_19035_19047[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19016[(4)]))){
var statearr_19036_19048 = state_19016;
(statearr_19036_19048[(1)] = cljs.core.first.call(null,(state_19016[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19049 = state_19016;
state_19016 = G__19049;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = function(state_19016){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1.call(this,state_19016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19037 = f__2769__auto__.call(null);
(statearr_19037[(6)] = c__2768__auto__);

return statearr_19037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___19122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19094){
var state_val_19095 = (state_19094[(1)]);
if((state_val_19095 === (7))){
var inst_19066 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_19067 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19068 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_19069 = cljs.core.PersistentHashMap.fromArrays(inst_19067,inst_19068);
var inst_19070 = cljs.core.ex_info.call(null,inst_19066,inst_19069);
var inst_19071 = (function(){throw inst_19070})();
var state_19094__$1 = state_19094;
var statearr_19096_19123 = state_19094__$1;
(statearr_19096_19123[(2)] = inst_19071);

(statearr_19096_19123[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (1))){
var state_19094__$1 = state_19094;
var statearr_19097_19124 = state_19094__$1;
(statearr_19097_19124[(2)] = null);

(statearr_19097_19124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (4))){
var inst_19050 = (state_19094[(2)]);
var inst_19051 = error_fn.call(null);
var inst_19052 = cljs.core.async.put_BANG_.call(null,return_ch,inst_19050);
var inst_19053 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_19094__$1 = (function (){var statearr_19098 = state_19094;
(statearr_19098[(7)] = inst_19052);

(statearr_19098[(8)] = inst_19051);

return statearr_19098;
})();
var statearr_19099_19125 = state_19094__$1;
(statearr_19099_19125[(2)] = inst_19053);

(statearr_19099_19125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (6))){
var inst_19063 = (state_19094[(9)]);
var inst_19063__$1 = (state_19094[(2)]);
var inst_19064 = (inst_19063__$1 == null);
var state_19094__$1 = (function (){var statearr_19100 = state_19094;
(statearr_19100[(9)] = inst_19063__$1);

return statearr_19100;
})();
if(cljs.core.truth_(inst_19064)){
var statearr_19101_19126 = state_19094__$1;
(statearr_19101_19126[(1)] = (7));

} else {
var statearr_19102_19127 = state_19094__$1;
(statearr_19102_19127[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (3))){
var inst_19092 = (state_19094[(2)]);
var state_19094__$1 = state_19094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19094__$1,inst_19092);
} else {
if((state_val_19095 === (12))){
var inst_19063 = (state_19094[(9)]);
var inst_19080 = (state_19094[(2)]);
var inst_19081 = cljs.core.__destructure_map.call(null,inst_19063);
var inst_19082 = cljs.core.get.call(null,inst_19081,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_19083 = cljs.core.get.call(null,inst_19081,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_19084 = config;
var inst_19085 = cljs.core.__destructure_map.call(null,inst_19084);
var inst_19086 = cljs.core.get.call(null,inst_19085,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_19087 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_19086,inst_19082);
var inst_19088 = fluree.db.index.data_node.call(null,block,t,inst_19087,rhs,config);
var inst_19089 = cljs.core.async.put_BANG_.call(null,return_ch,inst_19088);
var _ = (function (){var statearr_19103 = state_19094;
(statearr_19103[(4)] = cljs.core.rest.call(null,(state_19094[(4)])));

return statearr_19103;
})();
var state_19094__$1 = (function (){var statearr_19104 = state_19094;
(statearr_19104[(10)] = inst_19080);

(statearr_19104[(11)] = inst_19083);

return statearr_19104;
})();
var statearr_19105_19128 = state_19094__$1;
(statearr_19105_19128[(2)] = inst_19089);

(statearr_19105_19128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (2))){
var _ = (function (){var statearr_19106 = state_19094;
(statearr_19106[(4)] = cljs.core.cons.call(null,(5),(state_19094[(4)])));

return statearr_19106;
})();
var inst_19061 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_19094__$1 = state_19094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19094__$1,(6),inst_19061);
} else {
if((state_val_19095 === (11))){
var state_19094__$1 = state_19094;
var statearr_19108_19129 = state_19094__$1;
(statearr_19108_19129[(2)] = null);

(statearr_19108_19129[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (9))){
var inst_19063 = (state_19094[(9)]);
var inst_19074 = (state_19094[(2)]);
var inst_19075 = fluree.db.util.core.exception_QMARK_.call(null,inst_19063);
var state_19094__$1 = (function (){var statearr_19109 = state_19094;
(statearr_19109[(12)] = inst_19074);

return statearr_19109;
})();
if(inst_19075){
var statearr_19110_19130 = state_19094__$1;
(statearr_19110_19130[(1)] = (10));

} else {
var statearr_19111_19131 = state_19094__$1;
(statearr_19111_19131[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (5))){
var _ = (function (){var statearr_19112 = state_19094;
(statearr_19112[(4)] = cljs.core.rest.call(null,(state_19094[(4)])));

return statearr_19112;
})();
var state_19094__$1 = state_19094;
var ex19107 = (state_19094__$1[(2)]);
var statearr_19113_19132 = state_19094__$1;
(statearr_19113_19132[(5)] = ex19107);


var statearr_19114_19133 = state_19094__$1;
(statearr_19114_19133[(1)] = (4));

(statearr_19114_19133[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (10))){
var inst_19063 = (state_19094[(9)]);
var inst_19077 = (function(){throw inst_19063})();
var state_19094__$1 = state_19094;
var statearr_19115_19134 = state_19094__$1;
(statearr_19115_19134[(2)] = inst_19077);

(statearr_19115_19134[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (8))){
var state_19094__$1 = state_19094;
var statearr_19116_19135 = state_19094__$1;
(statearr_19116_19135[(2)] = null);

(statearr_19116_19135[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_19117 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19117[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__);

(statearr_19117[(1)] = (1));

return statearr_19117;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____1 = (function (state_19094){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19118){var ex__2749__auto__ = e19118;
var statearr_19119_19136 = state_19094;
(statearr_19119_19136[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19094[(4)]))){
var statearr_19120_19137 = state_19094;
(statearr_19120_19137[(1)] = cljs.core.first.call(null,(state_19094[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19138 = state_19094;
state_19094 = G__19138;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__ = function(state_19094){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____1.call(this,state_19094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19121 = f__2769__auto__.call(null);
(statearr_19121[(6)] = c__2768__auto___19122);

return statearr_19121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k19140,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__19144 = k19140;
var G__19144__$1 = (((G__19144 instanceof cljs.core.Keyword))?G__19144.fqn:null);
switch (G__19144__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19140,else__5346__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__19145){
var vec__19146 = p__19145;
var k__5367__auto__ = cljs.core.nth.call(null,vec__19146,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__19146,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19139){
var self__ = this;
var G__19139__$1 = this;
return (new cljs.core.RecordIter((0),G__19139__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19141,other19142){
var self__ = this;
var this19141__$1 = this;
return (((!((other19142 == null)))) && ((((this19141__$1.constructor === other19142.constructor)) && (((cljs.core._EQ_.call(null,this19141__$1.conn,other19142.conn)) && (((cljs.core._EQ_.call(null,this19141__$1.config,other19142.config)) && (((cljs.core._EQ_.call(null,this19141__$1.network,other19142.network)) && (((cljs.core._EQ_.call(null,this19141__$1.dbid,other19142.dbid)) && (((cljs.core._EQ_.call(null,this19141__$1.id,other19142.id)) && (((cljs.core._EQ_.call(null,this19141__$1.leaf,other19142.leaf)) && (((cljs.core._EQ_.call(null,this19141__$1.first,other19142.first)) && (((cljs.core._EQ_.call(null,this19141__$1.rhs,other19142.rhs)) && (((cljs.core._EQ_.call(null,this19141__$1.size,other19142.size)) && (((cljs.core._EQ_.call(null,this19141__$1.block,other19142.block)) && (((cljs.core._EQ_.call(null,this19141__$1.t,other19142.t)) && (((cljs.core._EQ_.call(null,this19141__$1.tt_id,other19142.tt_id)) && (((cljs.core._EQ_.call(null,this19141__$1.leftmost_QMARK_,other19142.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this19141__$1.tempid,other19142.tempid)) && (cljs.core._EQ_.call(null,this19141__$1.__extmap,other19142.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k19140){
var self__ = this;
var this__5350__auto____$1 = this;
var G__19149 = k19140;
var G__19149__$1 = (((G__19149 instanceof cljs.core.Keyword))?G__19149.fqn:null);
switch (G__19149__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k19140);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__19139){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__19150 = cljs.core.keyword_identical_QMARK_;
var expr__19151 = k__5352__auto__;
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(G__19139,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__19139,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__19139,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__19139,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__19139,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__19139,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__19139,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__19139,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__19139,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__19139,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__19139,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__19139,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__19139,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19150.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__19151))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__19139,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__19139),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__19139){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__19139,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__19143){
var extmap__5385__auto__ = (function (){var G__19153 = cljs.core.dissoc.call(null,G__19143,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__19143)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19153);
} else {
return G__19153;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__19143),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__19143),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__5045__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__19156 = blank_db;
var map__19156__$1 = cljs.core.__destructure_map.call(null,map__19156);
var network = cljs.core.get.call(null,map__19156__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__19156__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__19156__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__19157 = root_data;
var map__19157__$1 = cljs.core.__destructure_map.call(null,map__19157);
var block = cljs.core.get.call(null,map__19157__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__19157__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__19157__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__19157__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19179){
var state_val_19180 = (state_19179[(1)]);
if((state_val_19180 === (7))){
var state_19179__$1 = state_19179;
var statearr_19181_19201 = state_19179__$1;
(statearr_19181_19201[(2)] = null);

(statearr_19181_19201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19180 === (1))){
var state_19179__$1 = state_19179;
var statearr_19182_19202 = state_19179__$1;
(statearr_19182_19202[(2)] = null);

(statearr_19182_19202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19180 === (4))){
var inst_19158 = (state_19179[(2)]);
var state_19179__$1 = state_19179;
var statearr_19183_19203 = state_19179__$1;
(statearr_19183_19203[(2)] = inst_19158);

(statearr_19183_19203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19180 === (6))){
var inst_19165 = (state_19179[(7)]);
var inst_19167 = fluree.db.storage.core.serde.call(null,conn);
var state_19179__$1 = (function (){var statearr_19184 = state_19179;
(statearr_19184[(8)] = inst_19167);

return statearr_19184;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19179__$1,(9),inst_19165);
} else {
if((state_val_19180 === (3))){
var inst_19177 = (state_19179[(2)]);
var state_19179__$1 = state_19179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19179__$1,inst_19177);
} else {
if((state_val_19180 === (2))){
var inst_19165 = (state_19179[(7)]);
var _ = (function (){var statearr_19186 = state_19179;
(statearr_19186[(4)] = cljs.core.cons.call(null,(5),(state_19179[(4)])));

return statearr_19186;
})();
var inst_19164 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_19165__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_19164);
var state_19179__$1 = (function (){var statearr_19187 = state_19179;
(statearr_19187[(7)] = inst_19165__$1);

return statearr_19187;
})();
if(cljs.core.truth_(inst_19165__$1)){
var statearr_19188_19204 = state_19179__$1;
(statearr_19188_19204[(1)] = (6));

} else {
var statearr_19189_19205 = state_19179__$1;
(statearr_19189_19205[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19180 === (9))){
var inst_19167 = (state_19179[(8)]);
var inst_19169 = (state_19179[(2)]);
var inst_19170 = fluree.db.util.async.throw_err.call(null,inst_19169);
var inst_19171 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_19167,inst_19170);
var state_19179__$1 = state_19179;
var statearr_19190_19206 = state_19179__$1;
(statearr_19190_19206[(2)] = inst_19171);

(statearr_19190_19206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19180 === (5))){
var _ = (function (){var statearr_19191 = state_19179;
(statearr_19191[(4)] = cljs.core.rest.call(null,(state_19179[(4)])));

return statearr_19191;
})();
var state_19179__$1 = state_19179;
var ex19185 = (state_19179__$1[(2)]);
var statearr_19192_19207 = state_19179__$1;
(statearr_19192_19207[(5)] = ex19185);


if((ex19185 instanceof Error)){
var statearr_19193_19208 = state_19179__$1;
(statearr_19193_19208[(1)] = (4));

(statearr_19193_19208[(5)] = null);

} else {
throw ex19185;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19180 === (8))){
var inst_19174 = (state_19179[(2)]);
var _ = (function (){var statearr_19194 = state_19179;
(statearr_19194[(4)] = cljs.core.rest.call(null,(state_19179[(4)])));

return statearr_19194;
})();
var state_19179__$1 = state_19179;
var statearr_19195_19209 = state_19179__$1;
(statearr_19195_19209[(2)] = inst_19174);

(statearr_19195_19209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_19196 = [null,null,null,null,null,null,null,null,null];
(statearr_19196[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__);

(statearr_19196[(1)] = (1));

return statearr_19196;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1 = (function (state_19179){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19197){var ex__2749__auto__ = e19197;
var statearr_19198_19210 = state_19179;
(statearr_19198_19210[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19179[(4)]))){
var statearr_19199_19211 = state_19179;
(statearr_19199_19211[(1)] = cljs.core.first.call(null,(state_19179[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19212 = state_19179;
state_19179 = G__19212;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = function(state_19179){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1.call(this,state_19179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19200 = f__2769__auto__.call(null);
(statearr_19200[(6)] = c__2768__auto__);

return statearr_19200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19234){
var state_val_19235 = (state_19234[(1)]);
if((state_val_19235 === (7))){
var inst_19223 = (state_19234[(7)]);
var inst_19225 = fluree.db.storage.core.serde.call(null,conn);
var inst_19226 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_19225,inst_19223);
var state_19234__$1 = state_19234;
var statearr_19236_19255 = state_19234__$1;
(statearr_19236_19255[(2)] = inst_19226);

(statearr_19236_19255[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19235 === (1))){
var state_19234__$1 = state_19234;
var statearr_19237_19256 = state_19234__$1;
(statearr_19237_19256[(2)] = null);

(statearr_19237_19256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19235 === (4))){
var inst_19213 = (state_19234[(2)]);
var state_19234__$1 = state_19234;
var statearr_19238_19257 = state_19234__$1;
(statearr_19238_19257[(2)] = inst_19213);

(statearr_19238_19257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19235 === (6))){
var inst_19223 = (state_19234[(7)]);
var inst_19222 = (state_19234[(2)]);
var inst_19223__$1 = fluree.db.util.async.throw_err.call(null,inst_19222);
var state_19234__$1 = (function (){var statearr_19239 = state_19234;
(statearr_19239[(7)] = inst_19223__$1);

return statearr_19239;
})();
if(cljs.core.truth_(inst_19223__$1)){
var statearr_19240_19258 = state_19234__$1;
(statearr_19240_19258[(1)] = (7));

} else {
var statearr_19241_19259 = state_19234__$1;
(statearr_19241_19259[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19235 === (3))){
var inst_19232 = (state_19234[(2)]);
var state_19234__$1 = state_19234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19234__$1,inst_19232);
} else {
if((state_val_19235 === (2))){
var _ = (function (){var statearr_19243 = state_19234;
(statearr_19243[(4)] = cljs.core.cons.call(null,(5),(state_19234[(4)])));

return statearr_19243;
})();
var inst_19219 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_19220 = fluree.db.storage.core.storage_read.call(null,conn,inst_19219);
var state_19234__$1 = state_19234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19234__$1,(6),inst_19220);
} else {
if((state_val_19235 === (9))){
var inst_19229 = (state_19234[(2)]);
var _ = (function (){var statearr_19244 = state_19234;
(statearr_19244[(4)] = cljs.core.rest.call(null,(state_19234[(4)])));

return statearr_19244;
})();
var state_19234__$1 = state_19234;
var statearr_19245_19260 = state_19234__$1;
(statearr_19245_19260[(2)] = inst_19229);

(statearr_19245_19260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19235 === (5))){
var _ = (function (){var statearr_19246 = state_19234;
(statearr_19246[(4)] = cljs.core.rest.call(null,(state_19234[(4)])));

return statearr_19246;
})();
var state_19234__$1 = state_19234;
var ex19242 = (state_19234__$1[(2)]);
var statearr_19247_19261 = state_19234__$1;
(statearr_19247_19261[(5)] = ex19242);


if((ex19242 instanceof Error)){
var statearr_19248_19262 = state_19234__$1;
(statearr_19248_19262[(1)] = (4));

(statearr_19248_19262[(5)] = null);

} else {
throw ex19242;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19235 === (8))){
var state_19234__$1 = state_19234;
var statearr_19249_19263 = state_19234__$1;
(statearr_19249_19263[(2)] = null);

(statearr_19249_19263[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0 = (function (){
var statearr_19250 = [null,null,null,null,null,null,null,null];
(statearr_19250[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__);

(statearr_19250[(1)] = (1));

return statearr_19250;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1 = (function (state_19234){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19251){var ex__2749__auto__ = e19251;
var statearr_19252_19264 = state_19234;
(statearr_19252_19264[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19234[(4)]))){
var statearr_19253_19265 = state_19234;
(statearr_19253_19265[(1)] = cljs.core.first.call(null,(state_19234[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19266 = state_19234;
state_19234 = G__19266;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = function(state_19234){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1.call(this,state_19234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19254 = f__2769__auto__.call(null);
(statearr_19254[(6)] = c__2768__auto__);

return statearr_19254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19302){
var state_val_19303 = (state_19302[(1)]);
if((state_val_19303 === (7))){
var inst_19276 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_19277 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19278 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_19279 = cljs.core.PersistentHashMap.fromArrays(inst_19277,inst_19278);
var inst_19280 = cljs.core.ex_info.call(null,inst_19276,inst_19279);
var inst_19281 = (function(){throw inst_19280})();
var state_19302__$1 = state_19302;
var statearr_19304_19326 = state_19302__$1;
(statearr_19304_19326[(2)] = inst_19281);

(statearr_19304_19326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19303 === (1))){
var state_19302__$1 = state_19302;
var statearr_19305_19327 = state_19302__$1;
(statearr_19305_19327[(2)] = null);

(statearr_19305_19327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19303 === (4))){
var inst_19267 = (state_19302[(2)]);
var state_19302__$1 = state_19302;
var statearr_19306_19328 = state_19302__$1;
(statearr_19306_19328[(2)] = inst_19267);

(statearr_19306_19328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19303 === (6))){
var state_19302__$1 = state_19302;
var statearr_19307_19329 = state_19302__$1;
(statearr_19307_19329[(2)] = null);

(statearr_19307_19329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19303 === (3))){
var inst_19300 = (state_19302[(2)]);
var state_19302__$1 = state_19302;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19302__$1,inst_19300);
} else {
if((state_val_19303 === (2))){
var inst_19273 = (state_19302[(7)]);
var _ = (function (){var statearr_19308 = state_19302;
(statearr_19308[(4)] = cljs.core.cons.call(null,(5),(state_19302[(4)])));

return statearr_19308;
})();
var inst_19273__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_19302__$1 = (function (){var statearr_19309 = state_19302;
(statearr_19309[(7)] = inst_19273__$1);

return statearr_19309;
})();
if(cljs.core.truth_(inst_19273__$1)){
var statearr_19310_19330 = state_19302__$1;
(statearr_19310_19330[(1)] = (6));

} else {
var statearr_19311_19331 = state_19302__$1;
(statearr_19311_19331[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19303 === (11))){
var inst_19292 = (state_19302[(8)]);
var inst_19295 = (state_19302[(2)]);
var inst_19296 = fluree.db.util.async.throw_err.call(null,inst_19295);
var inst_19297 = cljs.core.assoc.call(null,inst_19292,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_19296);
var _ = (function (){var statearr_19313 = state_19302;
(statearr_19313[(4)] = cljs.core.rest.call(null,(state_19302[(4)])));

return statearr_19313;
})();
var state_19302__$1 = state_19302;
var statearr_19314_19332 = state_19302__$1;
(statearr_19314_19332[(2)] = inst_19297);

(statearr_19314_19332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19303 === (9))){
var inst_19287 = (state_19302[(9)]);
var inst_19285 = (state_19302[(2)]);
var inst_19286 = fluree.db.util.async.throw_err.call(null,inst_19285);
var inst_19287__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_19286);
var inst_19288 = fluree.db.query.schema.schema_map.call(null,inst_19287__$1);
var state_19302__$1 = (function (){var statearr_19315 = state_19302;
(statearr_19315[(9)] = inst_19287__$1);

return statearr_19315;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19302__$1,(10),inst_19288);
} else {
if((state_val_19303 === (5))){
var _ = (function (){var statearr_19316 = state_19302;
(statearr_19316[(4)] = cljs.core.rest.call(null,(state_19302[(4)])));

return statearr_19316;
})();
var state_19302__$1 = state_19302;
var ex19312 = (state_19302__$1[(2)]);
var statearr_19317_19333 = state_19302__$1;
(statearr_19317_19333[(5)] = ex19312);


if((ex19312 instanceof Error)){
var statearr_19318_19334 = state_19302__$1;
(statearr_19318_19334[(1)] = (4));

(statearr_19318_19334[(5)] = null);

} else {
throw ex19312;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19303 === (10))){
var inst_19292 = (state_19302[(8)]);
var inst_19287 = (state_19302[(9)]);
var inst_19290 = (state_19302[(2)]);
var inst_19291 = fluree.db.util.async.throw_err.call(null,inst_19290);
var inst_19292__$1 = cljs.core.assoc.call(null,inst_19287,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_19291);
var inst_19293 = fluree.db.query.schema.setting_map.call(null,inst_19292__$1);
var state_19302__$1 = (function (){var statearr_19319 = state_19302;
(statearr_19319[(8)] = inst_19292__$1);

return statearr_19319;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19302__$1,(11),inst_19293);
} else {
if((state_val_19303 === (8))){
var inst_19273 = (state_19302[(7)]);
var inst_19283 = (state_19302[(2)]);
var state_19302__$1 = (function (){var statearr_19320 = state_19302;
(statearr_19320[(10)] = inst_19283);

return statearr_19320;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19302__$1,(9),inst_19273);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0 = (function (){
var statearr_19321 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19321[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2746__auto__);

(statearr_19321[(1)] = (1));

return statearr_19321;
});
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1 = (function (state_19302){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19322){var ex__2749__auto__ = e19322;
var statearr_19323_19335 = state_19302;
(statearr_19323_19335[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19302[(4)]))){
var statearr_19324_19336 = state_19302;
(statearr_19324_19336[(1)] = cljs.core.first.call(null,(state_19302[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19337 = state_19302;
state_19302 = G__19337;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = function(state_19302){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1.call(this,state_19302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19325 = f__2769__auto__.call(null);
(statearr_19325[(6)] = c__2768__auto__);

return statearr_19325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__19339 = arguments.length;
switch (G__19339) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19392){
var state_val_19393 = (state_19392[(1)]);
if((state_val_19393 === (7))){
var inst_19349 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_19350 = (new Error(inst_19349));
var inst_19351 = (function(){throw inst_19350})();
var state_19392__$1 = state_19392;
var statearr_19394_19434 = state_19392__$1;
(statearr_19394_19434[(2)] = inst_19351);

(statearr_19394_19434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (20))){
var inst_19383 = (state_19392[(2)]);
var state_19392__$1 = state_19392;
var statearr_19395_19435 = state_19392__$1;
(statearr_19395_19435[(2)] = inst_19383);

(statearr_19395_19435[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (1))){
var state_19392__$1 = state_19392;
var statearr_19396_19436 = state_19392__$1;
(statearr_19396_19436[(2)] = null);

(statearr_19396_19436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (4))){
var inst_19340 = (state_19392[(2)]);
var state_19392__$1 = state_19392;
var statearr_19397_19437 = state_19392__$1;
(statearr_19397_19437[(2)] = inst_19340);

(statearr_19397_19437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (15))){
var inst_19358 = (state_19392[(7)]);
var state_19392__$1 = state_19392;
var statearr_19398_19438 = state_19392__$1;
(statearr_19398_19438[(2)] = inst_19358);

(statearr_19398_19438[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (21))){
var inst_19362 = (state_19392[(8)]);
var inst_19357 = (state_19392[(9)]);
var inst_19358 = (state_19392[(7)]);
var inst_19376 = (inst_19357 + (1));
var inst_19377 = cljs.core.conj.call(null,inst_19358,inst_19362);
var inst_19357__$1 = inst_19376;
var inst_19358__$1 = inst_19377;
var state_19392__$1 = (function (){var statearr_19399 = state_19392;
(statearr_19399[(9)] = inst_19357__$1);

(statearr_19399[(7)] = inst_19358__$1);

return statearr_19399;
})();
var statearr_19400_19439 = state_19392__$1;
(statearr_19400_19439[(2)] = null);

(statearr_19400_19439[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (13))){
var inst_19362 = (state_19392[(8)]);
var inst_19366 = (inst_19362 instanceof Error);
var state_19392__$1 = state_19392;
var statearr_19401_19440 = state_19392__$1;
(statearr_19401_19440[(2)] = inst_19366);

(statearr_19401_19440[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (22))){
var state_19392__$1 = state_19392;
var statearr_19402_19441 = state_19392__$1;
(statearr_19402_19441[(2)] = null);

(statearr_19402_19441[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (6))){
var state_19392__$1 = state_19392;
var statearr_19403_19442 = state_19392__$1;
(statearr_19403_19442[(2)] = null);

(statearr_19403_19442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (17))){
var inst_19385 = (state_19392[(2)]);
var state_19392__$1 = state_19392;
var statearr_19404_19443 = state_19392__$1;
(statearr_19404_19443[(2)] = inst_19385);

(statearr_19404_19443[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (3))){
var inst_19390 = (state_19392[(2)]);
var state_19392__$1 = state_19392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19392__$1,inst_19390);
} else {
if((state_val_19393 === (12))){
var inst_19363 = (state_19392[(10)]);
var state_19392__$1 = state_19392;
var statearr_19405_19444 = state_19392__$1;
(statearr_19405_19444[(2)] = inst_19363);

(statearr_19405_19444[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (2))){
var _ = (function (){var statearr_19406 = state_19392;
(statearr_19406[(4)] = cljs.core.cons.call(null,(5),(state_19392[(4)])));

return statearr_19406;
})();
var inst_19346 = (end >= start);
var state_19392__$1 = state_19392;
if(cljs.core.truth_(inst_19346)){
var statearr_19407_19445 = state_19392__$1;
(statearr_19407_19445[(1)] = (6));

} else {
var statearr_19408_19446 = state_19392__$1;
(statearr_19408_19446[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (23))){
var inst_19381 = (state_19392[(2)]);
var state_19392__$1 = state_19392;
var statearr_19409_19447 = state_19392__$1;
(statearr_19409_19447[(2)] = inst_19381);

(statearr_19409_19447[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (19))){
var state_19392__$1 = state_19392;
var statearr_19410_19448 = state_19392__$1;
(statearr_19410_19448[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (11))){
var inst_19363 = (state_19392[(10)]);
var inst_19362 = (state_19392[(8)]);
var inst_19362__$1 = (state_19392[(2)]);
var inst_19363__$1 = (inst_19362__$1 == null);
var state_19392__$1 = (function (){var statearr_19413 = state_19392;
(statearr_19413[(10)] = inst_19363__$1);

(statearr_19413[(8)] = inst_19362__$1);

return statearr_19413;
})();
if(cljs.core.truth_(inst_19363__$1)){
var statearr_19414_19449 = state_19392__$1;
(statearr_19414_19449[(1)] = (12));

} else {
var statearr_19415_19450 = state_19392__$1;
(statearr_19415_19450[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (9))){
var inst_19357 = (state_19392[(9)]);
var inst_19360 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_19357);
var state_19392__$1 = state_19392;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19392__$1,(11),inst_19360);
} else {
if((state_val_19393 === (5))){
var _ = (function (){var statearr_19416 = state_19392;
(statearr_19416[(4)] = cljs.core.rest.call(null,(state_19392[(4)])));

return statearr_19416;
})();
var state_19392__$1 = state_19392;
var ex19412 = (state_19392__$1[(2)]);
var statearr_19417_19451 = state_19392__$1;
(statearr_19417_19451[(5)] = ex19412);


if((ex19412 instanceof Error)){
var statearr_19418_19452 = state_19392__$1;
(statearr_19418_19452[(1)] = (4));

(statearr_19418_19452[(5)] = null);

} else {
throw ex19412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (14))){
var inst_19368 = (state_19392[(2)]);
var state_19392__$1 = state_19392;
if(cljs.core.truth_(inst_19368)){
var statearr_19419_19453 = state_19392__$1;
(statearr_19419_19453[(1)] = (15));

} else {
var statearr_19420_19454 = state_19392__$1;
(statearr_19420_19454[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (16))){
var inst_19357 = (state_19392[(9)]);
var inst_19371 = cljs.core._EQ_.call(null,inst_19357,end);
var state_19392__$1 = state_19392;
if(inst_19371){
var statearr_19421_19455 = state_19392__$1;
(statearr_19421_19455[(1)] = (18));

} else {
var statearr_19422_19456 = state_19392__$1;
(statearr_19422_19456[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (10))){
var inst_19387 = (state_19392[(2)]);
var _ = (function (){var statearr_19423 = state_19392;
(statearr_19423[(4)] = cljs.core.rest.call(null,(state_19392[(4)])));

return statearr_19423;
})();
var state_19392__$1 = state_19392;
var statearr_19424_19457 = state_19392__$1;
(statearr_19424_19457[(2)] = inst_19387);

(statearr_19424_19457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (18))){
var inst_19362 = (state_19392[(8)]);
var inst_19358 = (state_19392[(7)]);
var inst_19373 = cljs.core.conj.call(null,inst_19358,inst_19362);
var state_19392__$1 = state_19392;
var statearr_19425_19458 = state_19392__$1;
(statearr_19425_19458[(2)] = inst_19373);

(statearr_19425_19458[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19393 === (8))){
var inst_19353 = (state_19392[(2)]);
var inst_19354 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19355 = start;
var inst_19356 = cljs.core.PersistentVector.EMPTY;
var inst_19357 = inst_19355;
var inst_19358 = inst_19356;
var state_19392__$1 = (function (){var statearr_19426 = state_19392;
(statearr_19426[(11)] = inst_19353);

(statearr_19426[(12)] = inst_19354);

(statearr_19426[(9)] = inst_19357);

(statearr_19426[(7)] = inst_19358);

return statearr_19426;
})();
var statearr_19427_19459 = state_19392__$1;
(statearr_19427_19459[(2)] = null);

(statearr_19427_19459[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_19428 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19428[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_19428[(1)] = (1));

return statearr_19428;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_19392){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19429){var ex__2749__auto__ = e19429;
var statearr_19430_19460 = state_19392;
(statearr_19430_19460[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19392[(4)]))){
var statearr_19431_19461 = state_19392;
(statearr_19431_19461[(1)] = cljs.core.first.call(null,(state_19392[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19462 = state_19392;
state_19392 = G__19462;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_19392){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_19392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19432 = f__2769__auto__.call(null);
(statearr_19432[(6)] = c__2768__auto__);

return statearr_19432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19478){
var state_val_19479 = (state_19478[(1)]);
if((state_val_19479 === (1))){
var state_19478__$1 = state_19478;
var statearr_19480_19494 = state_19478__$1;
(statearr_19480_19494[(2)] = null);

(statearr_19480_19494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (2))){
var _ = (function (){var statearr_19481 = state_19478;
(statearr_19481[(4)] = cljs.core.cons.call(null,(5),(state_19478[(4)])));

return statearr_19481;
})();
var inst_19469 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_19478__$1 = state_19478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19478__$1,(6),inst_19469);
} else {
if((state_val_19479 === (3))){
var inst_19476 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19478__$1,inst_19476);
} else {
if((state_val_19479 === (4))){
var inst_19463 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
var statearr_19483_19495 = state_19478__$1;
(statearr_19483_19495[(2)] = inst_19463);

(statearr_19483_19495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (5))){
var _ = (function (){var statearr_19484 = state_19478;
(statearr_19484[(4)] = cljs.core.rest.call(null,(state_19478[(4)])));

return statearr_19484;
})();
var state_19478__$1 = state_19478;
var ex19482 = (state_19478__$1[(2)]);
var statearr_19485_19496 = state_19478__$1;
(statearr_19485_19496[(5)] = ex19482);


if((ex19482 instanceof Error)){
var statearr_19486_19497 = state_19478__$1;
(statearr_19486_19497[(1)] = (4));

(statearr_19486_19497[(5)] = null);

} else {
throw ex19482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (6))){
var inst_19471 = (state_19478[(2)]);
var inst_19472 = fluree.db.util.async.throw_err.call(null,inst_19471);
var inst_19473 = cljs.core.first.call(null,inst_19472);
var _ = (function (){var statearr_19487 = state_19478;
(statearr_19487[(4)] = cljs.core.rest.call(null,(state_19478[(4)])));

return statearr_19487;
})();
var state_19478__$1 = state_19478;
var statearr_19488_19498 = state_19478__$1;
(statearr_19488_19498[(2)] = inst_19473);

(statearr_19488_19498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2746__auto____0 = (function (){
var statearr_19489 = [null,null,null,null,null,null,null];
(statearr_19489[(0)] = fluree$db$storage$core$block_$_state_machine__2746__auto__);

(statearr_19489[(1)] = (1));

return statearr_19489;
});
var fluree$db$storage$core$block_$_state_machine__2746__auto____1 = (function (state_19478){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19490){var ex__2749__auto__ = e19490;
var statearr_19491_19499 = state_19478;
(statearr_19491_19499[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19478[(4)]))){
var statearr_19492_19500 = state_19478;
(statearr_19492_19500[(1)] = cljs.core.first.call(null,(state_19478[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19501 = state_19478;
state_19478 = G__19501;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2746__auto__ = function(state_19478){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2746__auto____1.call(this,state_19478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2746__auto____0;
fluree$db$storage$core$block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19493 = f__2769__auto__.call(null);
(statearr_19493[(6)] = c__2768__auto__);

return statearr_19493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
