// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__60246 = arguments.length;
switch (G__60246) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___60394 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60333){
var state_val_60334 = (state_60333[(1)]);
if((state_val_60334 === (7))){
var inst_60264 = (state_60333[(7)]);
var inst_60267 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_60264);
var state_60333__$1 = state_60333;
var statearr_60335_60395 = state_60333__$1;
(statearr_60335_60395[(2)] = inst_60267);

(statearr_60335_60395[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (20))){
var inst_60288 = (state_60333[(8)]);
var inst_60259 = (state_60333[(9)]);
var inst_60292 = fluree.db.auth.roles(inst_60259,inst_60288);
var state_60333__$1 = state_60333;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60333__$1,(23),inst_60292);
} else {
if((state_val_60334 === (27))){
var inst_60259 = (state_60333[(9)]);
var inst_60307 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60308 = fluree.db.time_travel.as_of_block(inst_60259,inst_60307);
var state_60333__$1 = state_60333;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60333__$1,(30),inst_60308);
} else {
if((state_val_60334 === (1))){
var state_60333__$1 = state_60333;
var statearr_60336_60396 = state_60333__$1;
(statearr_60336_60396[(2)] = null);

(statearr_60336_60396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (24))){
var inst_60300 = (state_60333[(10)]);
var inst_60259 = (state_60333[(9)]);
var inst_60302 = fluree.db.permissions.permission_map(inst_60259,inst_60300,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60333__$1 = state_60333;
var statearr_60337_60397 = state_60333__$1;
(statearr_60337_60397[(2)] = inst_60302);

(statearr_60337_60397[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (4))){
var inst_60247 = (state_60333[(2)]);
var inst_60248 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60247);
var inst_60249 = cljs.core.async.close_BANG_(pc);
var state_60333__$1 = (function (){var statearr_60338 = state_60333;
(statearr_60338[(11)] = inst_60248);

return statearr_60338;
})();
var statearr_60339_60398 = state_60333__$1;
(statearr_60339_60398[(2)] = inst_60249);

(statearr_60339_60398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (15))){
var inst_60264 = (state_60333[(7)]);
var inst_60278 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_60264)," unknown."].join('');
var inst_60279 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60280 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_60281 = cljs.core.PersistentHashMap.fromArrays(inst_60279,inst_60280);
var inst_60282 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60278,inst_60281);
var inst_60283 = (function(){throw inst_60282})();
var state_60333__$1 = state_60333;
var statearr_60340_60399 = state_60333__$1;
(statearr_60340_60399[(2)] = inst_60283);

(statearr_60340_60399[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (21))){
var state_60333__$1 = state_60333;
var statearr_60341_60400 = state_60333__$1;
(statearr_60341_60400[(2)] = null);

(statearr_60341_60400[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (31))){
var inst_60314 = (state_60333[(12)]);
var inst_60264 = (state_60333[(7)]);
var inst_60316 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60314,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_60264);
var state_60333__$1 = state_60333;
var statearr_60342_60401 = state_60333__$1;
(statearr_60342_60401[(2)] = inst_60316);

(statearr_60342_60401[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (32))){
var inst_60314 = (state_60333[(12)]);
var state_60333__$1 = state_60333;
var statearr_60343_60402 = state_60333__$1;
(statearr_60343_60402[(2)] = inst_60314);

(statearr_60343_60402[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (33))){
var inst_60300 = (state_60333[(10)]);
var inst_60319 = (state_60333[(2)]);
var state_60333__$1 = (function (){var statearr_60344 = state_60333;
(statearr_60344[(13)] = inst_60319);

return statearr_60344;
})();
if(cljs.core.truth_(inst_60300)){
var statearr_60345_60403 = state_60333__$1;
(statearr_60345_60403[(1)] = (34));

} else {
var statearr_60346_60404 = state_60333__$1;
(statearr_60346_60404[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (13))){
var inst_60275 = (state_60333[(14)]);
var inst_60274 = (state_60333[(2)]);
var inst_60275__$1 = fluree.db.util.async.throw_err(inst_60274);
var state_60333__$1 = (function (){var statearr_60347 = state_60333;
(statearr_60347[(14)] = inst_60275__$1);

return statearr_60347;
})();
if(cljs.core.truth_(inst_60275__$1)){
var statearr_60348_60405 = state_60333__$1;
(statearr_60348_60405[(1)] = (14));

} else {
var statearr_60349_60406 = state_60333__$1;
(statearr_60349_60406[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (22))){
var inst_60298 = (state_60333[(2)]);
var state_60333__$1 = state_60333;
var statearr_60350_60407 = state_60333__$1;
(statearr_60350_60407[(2)] = inst_60298);

(statearr_60350_60407[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (36))){
var inst_60327 = (state_60333[(2)]);
var inst_60328 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60327);
var _ = (function (){var statearr_60351 = state_60333;
(statearr_60351[(4)] = cljs.core.rest((state_60333[(4)])));

return statearr_60351;
})();
var state_60333__$1 = state_60333;
var statearr_60352_60408 = state_60333__$1;
(statearr_60352_60408[(2)] = inst_60328);

(statearr_60352_60408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (29))){
var inst_60264 = (state_60333[(7)]);
var inst_60314 = (state_60333[(2)]);
var state_60333__$1 = (function (){var statearr_60353 = state_60333;
(statearr_60353[(12)] = inst_60314);

return statearr_60353;
})();
if(cljs.core.truth_(inst_60264)){
var statearr_60354_60409 = state_60333__$1;
(statearr_60354_60409[(1)] = (31));

} else {
var statearr_60355_60410 = state_60333__$1;
(statearr_60355_60410[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (6))){
var inst_60264 = (state_60333[(7)]);
var inst_60258 = (state_60333[(2)]);
var inst_60259 = fluree.db.util.async.throw_err(inst_60258);
var inst_60260 = opts;
var inst_60261 = cljs.core.__destructure_map(inst_60260);
var inst_60262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60261,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_60263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60261,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_60264__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60261,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60261,new cljs.core.Keyword(null,"block","block",664686210));
var state_60333__$1 = (function (){var statearr_60356 = state_60333;
(statearr_60356[(15)] = inst_60262);

(statearr_60356[(16)] = inst_60265);

(statearr_60356[(17)] = inst_60263);

(statearr_60356[(9)] = inst_60259);

(statearr_60356[(7)] = inst_60264__$1);

return statearr_60356;
})();
if(cljs.core.truth_(inst_60264__$1)){
var statearr_60357_60411 = state_60333__$1;
(statearr_60357_60411[(1)] = (7));

} else {
var statearr_60358_60412 = state_60333__$1;
(statearr_60358_60412[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (28))){
var inst_60259 = (state_60333[(9)]);
var state_60333__$1 = state_60333;
var statearr_60359_60413 = state_60333__$1;
(statearr_60359_60413[(2)] = inst_60259);

(statearr_60359_60413[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (25))){
var state_60333__$1 = state_60333;
var statearr_60360_60414 = state_60333__$1;
(statearr_60360_60414[(2)] = null);

(statearr_60360_60414[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (34))){
var inst_60305 = (state_60333[(18)]);
var state_60333__$1 = state_60333;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60333__$1,(37),inst_60305);
} else {
if((state_val_60334 === (17))){
var inst_60262 = (state_60333[(15)]);
var state_60333__$1 = state_60333;
var statearr_60361_60415 = state_60333__$1;
(statearr_60361_60415[(2)] = inst_60262);

(statearr_60361_60415[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (3))){
var inst_60331 = (state_60333[(2)]);
var state_60333__$1 = state_60333;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60333__$1,inst_60331);
} else {
if((state_val_60334 === (12))){
var inst_60262 = (state_60333[(15)]);
var inst_60288 = (state_60333[(2)]);
var state_60333__$1 = (function (){var statearr_60362 = state_60333;
(statearr_60362[(8)] = inst_60288);

return statearr_60362;
})();
if(cljs.core.truth_(inst_60262)){
var statearr_60363_60416 = state_60333__$1;
(statearr_60363_60416[(1)] = (17));

} else {
var statearr_60364_60417 = state_60333__$1;
(statearr_60364_60417[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (2))){
var _ = (function (){var statearr_60365 = state_60333;
(statearr_60365[(4)] = cljs.core.cons((5),(state_60333[(4)])));

return statearr_60365;
})();
var inst_60256 = fluree.db.session.db(conn,ledger,null);
var state_60333__$1 = state_60333;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60333__$1,(6),inst_60256);
} else {
if((state_val_60334 === (23))){
var inst_60294 = (state_60333[(2)]);
var inst_60295 = fluree.db.util.async.throw_err(inst_60294);
var state_60333__$1 = state_60333;
var statearr_60366_60418 = state_60333__$1;
(statearr_60366_60418[(2)] = inst_60295);

(statearr_60366_60418[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (35))){
var inst_60319 = (state_60333[(13)]);
var state_60333__$1 = state_60333;
var statearr_60367_60419 = state_60333__$1;
(statearr_60367_60419[(2)] = inst_60319);

(statearr_60367_60419[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (19))){
var inst_60300 = (state_60333[(10)]);
var inst_60300__$1 = (state_60333[(2)]);
var state_60333__$1 = (function (){var statearr_60368 = state_60333;
(statearr_60368[(10)] = inst_60300__$1);

return statearr_60368;
})();
if(cljs.core.truth_(inst_60300__$1)){
var statearr_60369_60420 = state_60333__$1;
(statearr_60369_60420[(1)] = (24));

} else {
var statearr_60370_60421 = state_60333__$1;
(statearr_60370_60421[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (11))){
var state_60333__$1 = state_60333;
var statearr_60372_60422 = state_60333__$1;
(statearr_60372_60422[(2)] = null);

(statearr_60372_60422[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (9))){
var inst_60270 = (state_60333[(2)]);
var state_60333__$1 = state_60333;
if(cljs.core.truth_(inst_60270)){
var statearr_60373_60423 = state_60333__$1;
(statearr_60373_60423[(1)] = (10));

} else {
var statearr_60374_60424 = state_60333__$1;
(statearr_60374_60424[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (5))){
var _ = (function (){var statearr_60375 = state_60333;
(statearr_60375[(4)] = cljs.core.rest((state_60333[(4)])));

return statearr_60375;
})();
var state_60333__$1 = state_60333;
var ex60371 = (state_60333__$1[(2)]);
var statearr_60376_60425 = state_60333__$1;
(statearr_60376_60425[(5)] = ex60371);


var statearr_60377_60426 = state_60333__$1;
(statearr_60377_60426[(1)] = (4));

(statearr_60377_60426[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (14))){
var inst_60275 = (state_60333[(14)]);
var state_60333__$1 = state_60333;
var statearr_60378_60427 = state_60333__$1;
(statearr_60378_60427[(2)] = inst_60275);

(statearr_60378_60427[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (26))){
var inst_60265 = (state_60333[(16)]);
var inst_60305 = (state_60333[(2)]);
var state_60333__$1 = (function (){var statearr_60379 = state_60333;
(statearr_60379[(18)] = inst_60305);

return statearr_60379;
})();
if(cljs.core.truth_(inst_60265)){
var statearr_60380_60428 = state_60333__$1;
(statearr_60380_60428[(1)] = (27));

} else {
var statearr_60381_60429 = state_60333__$1;
(statearr_60381_60429[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (16))){
var inst_60285 = (state_60333[(2)]);
var state_60333__$1 = state_60333;
var statearr_60382_60430 = state_60333__$1;
(statearr_60382_60430[(2)] = inst_60285);

(statearr_60382_60430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (30))){
var inst_60310 = (state_60333[(2)]);
var inst_60311 = fluree.db.util.async.throw_err(inst_60310);
var state_60333__$1 = state_60333;
var statearr_60383_60431 = state_60333__$1;
(statearr_60383_60431[(2)] = inst_60311);

(statearr_60383_60431[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (10))){
var inst_60259 = (state_60333[(9)]);
var inst_60264 = (state_60333[(7)]);
var inst_60272 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_60259,inst_60264);
var state_60333__$1 = state_60333;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60333__$1,(13),inst_60272);
} else {
if((state_val_60334 === (18))){
var inst_60288 = (state_60333[(8)]);
var state_60333__$1 = state_60333;
if(cljs.core.truth_(inst_60288)){
var statearr_60384_60432 = state_60333__$1;
(statearr_60384_60432[(1)] = (20));

} else {
var statearr_60385_60433 = state_60333__$1;
(statearr_60385_60433[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (37))){
var inst_60319 = (state_60333[(13)]);
var inst_60322 = (state_60333[(2)]);
var inst_60323 = fluree.db.util.async.throw_err(inst_60322);
var inst_60324 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60319,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60323);
var state_60333__$1 = state_60333;
var statearr_60386_60434 = state_60333__$1;
(statearr_60386_60434[(2)] = inst_60324);

(statearr_60386_60434[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60334 === (8))){
var inst_60264 = (state_60333[(7)]);
var state_60333__$1 = state_60333;
var statearr_60387_60435 = state_60333__$1;
(statearr_60387_60435[(2)] = inst_60264);

(statearr_60387_60435[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_60388 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60388[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_60388[(1)] = (1));

return statearr_60388;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_60333){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60333);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60389){var ex__2730__auto__ = e60389;
var statearr_60390_60436 = state_60333;
(statearr_60390_60436[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60333[(4)]))){
var statearr_60391_60437 = state_60333;
(statearr_60391_60437[(1)] = cljs.core.first((state_60333[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60438 = state_60333;
state_60333 = G__60438;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_60333){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_60333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60392 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60392[(6)] = c__2749__auto___60394);

return statearr_60392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60579){
var state_val_60580 = (state_60579[(1)]);
if((state_val_60580 === (7))){
var inst_60459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60460 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60461 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60462 = [inst_60460,inst_60461];
var inst_60463 = (new cljs.core.PersistentVector(null,2,(5),inst_60459,inst_60462,null));
var state_60579__$1 = state_60579;
var statearr_60581_60651 = state_60579__$1;
(statearr_60581_60651[(2)] = inst_60463);

(statearr_60581_60651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (20))){
var inst_60489 = (state_60579[(7)]);
var state_60579__$1 = state_60579;
var statearr_60582_60652 = state_60579__$1;
(statearr_60582_60652[(2)] = inst_60489);

(statearr_60582_60652[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (27))){
var state_60579__$1 = state_60579;
var statearr_60583_60653 = state_60579__$1;
(statearr_60583_60653[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (1))){
var state_60579__$1 = state_60579;
var statearr_60585_60654 = state_60579__$1;
(statearr_60585_60654[(2)] = null);

(statearr_60585_60654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (24))){
var inst_60488 = (state_60579[(8)]);
var state_60579__$1 = state_60579;
if(cljs.core.truth_(inst_60488)){
var statearr_60586_60655 = state_60579__$1;
(statearr_60586_60655[(1)] = (26));

} else {
var statearr_60587_60656 = state_60579__$1;
(statearr_60587_60656[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (39))){
var inst_60535 = (state_60579[(9)]);
var inst_60534 = (state_60579[(10)]);
var inst_60560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60561 = [inst_60534,inst_60535];
var inst_60562 = (new cljs.core.PersistentVector(null,2,(5),inst_60560,inst_60561,null));
var state_60579__$1 = state_60579;
var statearr_60588_60657 = state_60579__$1;
(statearr_60588_60657[(2)] = inst_60562);

(statearr_60588_60657[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (4))){
var inst_60439 = (state_60579[(2)]);
var state_60579__$1 = state_60579;
var statearr_60589_60658 = state_60579__$1;
(statearr_60589_60658[(2)] = inst_60439);

(statearr_60589_60658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (15))){
var inst_60473 = (state_60579[(11)]);
var inst_60468 = (state_60579[(12)]);
var inst_60482 = (state_60579[(2)]);
var inst_60483 = [inst_60473,inst_60482];
var inst_60484 = (new cljs.core.PersistentVector(null,2,(5),inst_60468,inst_60483,null));
var state_60579__$1 = state_60579;
var statearr_60590_60659 = state_60579__$1;
(statearr_60590_60659[(2)] = inst_60484);

(statearr_60590_60659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (21))){
var inst_60488 = (state_60579[(8)]);
var state_60579__$1 = state_60579;
var statearr_60591_60660 = state_60579__$1;
(statearr_60591_60660[(2)] = inst_60488);

(statearr_60591_60660[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (31))){
var inst_60529 = (state_60579[(2)]);
var state_60579__$1 = state_60579;
var statearr_60592_60661 = state_60579__$1;
(statearr_60592_60661[(2)] = inst_60529);

(statearr_60592_60661[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (32))){
var inst_60535 = (state_60579[(9)]);
var inst_60538 = cljs.core.pos_int_QMARK_(inst_60535);
var state_60579__$1 = state_60579;
var statearr_60593_60662 = state_60579__$1;
(statearr_60593_60662[(2)] = inst_60538);

(statearr_60593_60662[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (40))){
var inst_60490 = (state_60579[(13)]);
var inst_60566 = (state_60579[(14)]);
var inst_60564 = (state_60579[(2)]);
var inst_60565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60564,(0),null);
var inst_60566__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60564,(1),null);
var inst_60567 = (inst_60566__$1 > inst_60490);
var state_60579__$1 = (function (){var statearr_60594 = state_60579;
(statearr_60594[(14)] = inst_60566__$1);

(statearr_60594[(15)] = inst_60565);

return statearr_60594;
})();
if(cljs.core.truth_(inst_60567)){
var statearr_60595_60663 = state_60579__$1;
(statearr_60595_60663[(1)] = (41));

} else {
var statearr_60596_60664 = state_60579__$1;
(statearr_60596_60664[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (33))){
var inst_60536 = (state_60579[(16)]);
var state_60579__$1 = state_60579;
var statearr_60597_60665 = state_60579__$1;
(statearr_60597_60665[(2)] = inst_60536);

(statearr_60597_60665[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (13))){
var inst_60474 = (state_60579[(17)]);
var inst_60476 = fluree.db.time_travel.block_to_int_format(db,inst_60474);
var state_60579__$1 = state_60579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60579__$1,(16),inst_60476);
} else {
if((state_val_60580 === (22))){
var inst_60507 = (state_60579[(2)]);
var state_60579__$1 = state_60579;
if(cljs.core.truth_(inst_60507)){
var statearr_60598_60666 = state_60579__$1;
(statearr_60598_60666[(1)] = (23));

} else {
var statearr_60599_60667 = state_60579__$1;
(statearr_60599_60667[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (36))){
var state_60579__$1 = state_60579;
var statearr_60600_60668 = state_60579__$1;
(statearr_60600_60668[(2)] = null);

(statearr_60600_60668[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (41))){
var inst_60490 = (state_60579[(13)]);
var state_60579__$1 = state_60579;
var statearr_60601_60669 = state_60579__$1;
(statearr_60601_60669[(2)] = inst_60490);

(statearr_60601_60669[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (43))){
var inst_60565 = (state_60579[(15)]);
var inst_60571 = (state_60579[(2)]);
var inst_60572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60573 = [inst_60565,inst_60571];
var inst_60574 = (new cljs.core.PersistentVector(null,2,(5),inst_60572,inst_60573,null));
var _ = (function (){var statearr_60602 = state_60579;
(statearr_60602[(4)] = cljs.core.rest((state_60579[(4)])));

return statearr_60602;
})();
var state_60579__$1 = state_60579;
var statearr_60603_60670 = state_60579__$1;
(statearr_60603_60670[(2)] = inst_60574);

(statearr_60603_60670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (29))){
var inst_60465 = (state_60579[(18)]);
var inst_60520 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60465], 0));
var inst_60521 = ["Invalid block range provided: ",inst_60520].join('');
var inst_60522 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60523 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60524 = cljs.core.PersistentHashMap.fromArrays(inst_60522,inst_60523);
var inst_60525 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60521,inst_60524);
var inst_60526 = (function(){throw inst_60525})();
var state_60579__$1 = state_60579;
var statearr_60604_60671 = state_60579__$1;
(statearr_60604_60671[(2)] = inst_60526);

(statearr_60604_60671[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (6))){
var inst_60457 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60579__$1 = state_60579;
var statearr_60605_60672 = state_60579__$1;
(statearr_60605_60672[(2)] = inst_60457);

(statearr_60605_60672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (28))){
var inst_60531 = (state_60579[(2)]);
var state_60579__$1 = state_60579;
var statearr_60606_60673 = state_60579__$1;
(statearr_60606_60673[(2)] = inst_60531);

(statearr_60606_60673[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (25))){
var inst_60534 = (state_60579[(10)]);
var inst_60536 = (state_60579[(16)]);
var inst_60533 = (state_60579[(2)]);
var inst_60534__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60533,(0),null);
var inst_60535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60533,(1),null);
var inst_60536__$1 = cljs.core.pos_int_QMARK_(inst_60534__$1);
var state_60579__$1 = (function (){var statearr_60607 = state_60579;
(statearr_60607[(9)] = inst_60535);

(statearr_60607[(10)] = inst_60534__$1);

(statearr_60607[(16)] = inst_60536__$1);

return statearr_60607;
})();
if(inst_60536__$1){
var statearr_60608_60674 = state_60579__$1;
(statearr_60608_60674[(1)] = (32));

} else {
var statearr_60609_60675 = state_60579__$1;
(statearr_60609_60675[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (34))){
var inst_60541 = (state_60579[(2)]);
var inst_60542 = cljs.core.not(inst_60541);
var state_60579__$1 = state_60579;
if(inst_60542){
var statearr_60610_60676 = state_60579__$1;
(statearr_60610_60676[(1)] = (35));

} else {
var statearr_60611_60677 = state_60579__$1;
(statearr_60611_60677[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (17))){
var inst_60488 = (state_60579[(8)]);
var inst_60490 = (state_60579[(13)]);
var inst_60493 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60488], 0));
var inst_60494 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60490], 0));
var inst_60495 = ["Start block is out of range for this ledger. Start block provided: ",inst_60493,". Database block: ",inst_60494].join('');
var inst_60496 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60497 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60498 = cljs.core.PersistentHashMap.fromArrays(inst_60496,inst_60497);
var inst_60499 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60495,inst_60498);
var inst_60500 = (function(){throw inst_60499})();
var state_60579__$1 = state_60579;
var statearr_60612_60678 = state_60579__$1;
(statearr_60612_60678[(2)] = inst_60500);

(statearr_60612_60678[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (3))){
var inst_60577 = (state_60579[(2)]);
var state_60579__$1 = state_60579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60579__$1,inst_60577);
} else {
if((state_val_60580 === (12))){
var inst_60465 = (state_60579[(18)]);
var inst_60474 = (state_60579[(17)]);
var inst_60472 = (state_60579[(2)]);
var inst_60473 = fluree.db.util.async.throw_err(inst_60472);
var inst_60474__$1 = cljs.core.second(inst_60465);
var state_60579__$1 = (function (){var statearr_60613 = state_60579;
(statearr_60613[(11)] = inst_60473);

(statearr_60613[(17)] = inst_60474__$1);

return statearr_60613;
})();
if(cljs.core.truth_(inst_60474__$1)){
var statearr_60614_60679 = state_60579__$1;
(statearr_60614_60679[(1)] = (13));

} else {
var statearr_60615_60680 = state_60579__$1;
(statearr_60615_60680[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (2))){
var _ = (function (){var statearr_60616 = state_60579;
(statearr_60616[(4)] = cljs.core.cons((5),(state_60579[(4)])));

return statearr_60616;
})();
var inst_60454 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60455 = cljs.core.sequential_QMARK_(inst_60454);
var state_60579__$1 = state_60579;
if(inst_60455){
var statearr_60617_60681 = state_60579__$1;
(statearr_60617_60681[(1)] = (6));

} else {
var statearr_60618_60682 = state_60579__$1;
(statearr_60618_60682[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (23))){
var inst_60488 = (state_60579[(8)]);
var inst_60489 = (state_60579[(7)]);
var inst_60509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60510 = [inst_60488,inst_60489];
var inst_60511 = (new cljs.core.PersistentVector(null,2,(5),inst_60509,inst_60510,null));
var state_60579__$1 = state_60579;
var statearr_60619_60683 = state_60579__$1;
(statearr_60619_60683[(2)] = inst_60511);

(statearr_60619_60683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (35))){
var inst_60465 = (state_60579[(18)]);
var inst_60544 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60465], 0));
var inst_60545 = ["Invalid block range provided: ",inst_60544].join('');
var inst_60546 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60547 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60548 = cljs.core.PersistentHashMap.fromArrays(inst_60546,inst_60547);
var inst_60549 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60545,inst_60548);
var inst_60550 = (function(){throw inst_60549})();
var state_60579__$1 = state_60579;
var statearr_60620_60684 = state_60579__$1;
(statearr_60620_60684[(2)] = inst_60550);

(statearr_60620_60684[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (19))){
var inst_60488 = (state_60579[(8)]);
var inst_60503 = (state_60579[(2)]);
var state_60579__$1 = (function (){var statearr_60621 = state_60579;
(statearr_60621[(19)] = inst_60503);

return statearr_60621;
})();
if(cljs.core.truth_(inst_60488)){
var statearr_60622_60685 = state_60579__$1;
(statearr_60622_60685[(1)] = (20));

} else {
var statearr_60623_60686 = state_60579__$1;
(statearr_60623_60686[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (11))){
var inst_60488 = (state_60579[(8)]);
var inst_60490 = (state_60579[(13)]);
var inst_60487 = (state_60579[(2)]);
var inst_60488__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60487,(0),null);
var inst_60489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60487,(1),null);
var inst_60490__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60491 = (inst_60488__$1 > inst_60490__$1);
var state_60579__$1 = (function (){var statearr_60625 = state_60579;
(statearr_60625[(8)] = inst_60488__$1);

(statearr_60625[(13)] = inst_60490__$1);

(statearr_60625[(7)] = inst_60489);

return statearr_60625;
})();
if(cljs.core.truth_(inst_60491)){
var statearr_60626_60687 = state_60579__$1;
(statearr_60626_60687[(1)] = (17));

} else {
var statearr_60627_60688 = state_60579__$1;
(statearr_60627_60688[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (9))){
var inst_60465 = (state_60579[(18)]);
var inst_60468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60469 = cljs.core.first(inst_60465);
var inst_60470 = fluree.db.time_travel.block_to_int_format(db,inst_60469);
var state_60579__$1 = (function (){var statearr_60628 = state_60579;
(statearr_60628[(12)] = inst_60468);

return statearr_60628;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60579__$1,(12),inst_60470);
} else {
if((state_val_60580 === (5))){
var _ = (function (){var statearr_60629 = state_60579;
(statearr_60629[(4)] = cljs.core.rest((state_60579[(4)])));

return statearr_60629;
})();
var state_60579__$1 = state_60579;
var ex60624 = (state_60579__$1[(2)]);
var statearr_60630_60689 = state_60579__$1;
(statearr_60630_60689[(5)] = ex60624);


if((ex60624 instanceof Error)){
var statearr_60631_60690 = state_60579__$1;
(statearr_60631_60690[(1)] = (4));

(statearr_60631_60690[(5)] = null);

} else {
throw ex60624;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (14))){
var state_60579__$1 = state_60579;
var statearr_60632_60691 = state_60579__$1;
(statearr_60632_60691[(2)] = null);

(statearr_60632_60691[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (26))){
var inst_60488 = (state_60579[(8)]);
var inst_60514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60515 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60516 = [inst_60488,inst_60515];
var inst_60517 = (new cljs.core.PersistentVector(null,2,(5),inst_60514,inst_60516,null));
var state_60579__$1 = state_60579;
var statearr_60633_60692 = state_60579__$1;
(statearr_60633_60692[(2)] = inst_60517);

(statearr_60633_60692[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (16))){
var inst_60478 = (state_60579[(2)]);
var inst_60479 = fluree.db.util.async.throw_err(inst_60478);
var state_60579__$1 = state_60579;
var statearr_60634_60693 = state_60579__$1;
(statearr_60634_60693[(2)] = inst_60479);

(statearr_60634_60693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (38))){
var inst_60535 = (state_60579[(9)]);
var inst_60534 = (state_60579[(10)]);
var inst_60556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60557 = [inst_60535,inst_60534];
var inst_60558 = (new cljs.core.PersistentVector(null,2,(5),inst_60556,inst_60557,null));
var state_60579__$1 = state_60579;
var statearr_60635_60694 = state_60579__$1;
(statearr_60635_60694[(2)] = inst_60558);

(statearr_60635_60694[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (30))){
var state_60579__$1 = state_60579;
var statearr_60636_60695 = state_60579__$1;
(statearr_60636_60695[(2)] = null);

(statearr_60636_60695[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (10))){
var inst_60465 = (state_60579[(18)]);
var state_60579__$1 = state_60579;
var statearr_60637_60696 = state_60579__$1;
(statearr_60637_60696[(2)] = inst_60465);

(statearr_60637_60696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (18))){
var state_60579__$1 = state_60579;
var statearr_60638_60697 = state_60579__$1;
(statearr_60638_60697[(2)] = null);

(statearr_60638_60697[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (42))){
var inst_60566 = (state_60579[(14)]);
var state_60579__$1 = state_60579;
var statearr_60639_60698 = state_60579__$1;
(statearr_60639_60698[(2)] = inst_60566);

(statearr_60639_60698[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (37))){
var inst_60535 = (state_60579[(9)]);
var inst_60534 = (state_60579[(10)]);
var inst_60553 = (state_60579[(2)]);
var inst_60554 = (inst_60535 < inst_60534);
var state_60579__$1 = (function (){var statearr_60640 = state_60579;
(statearr_60640[(20)] = inst_60553);

return statearr_60640;
})();
if(cljs.core.truth_(inst_60554)){
var statearr_60641_60699 = state_60579__$1;
(statearr_60641_60699[(1)] = (38));

} else {
var statearr_60642_60700 = state_60579__$1;
(statearr_60642_60700[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (8))){
var inst_60465 = (state_60579[(18)]);
var inst_60465__$1 = (state_60579[(2)]);
var inst_60466 = cljs.core.some(cljs.core.string_QMARK_,inst_60465__$1);
var state_60579__$1 = (function (){var statearr_60643 = state_60579;
(statearr_60643[(18)] = inst_60465__$1);

return statearr_60643;
})();
if(cljs.core.truth_(inst_60466)){
var statearr_60644_60701 = state_60579__$1;
(statearr_60644_60701[(1)] = (9));

} else {
var statearr_60645_60702 = state_60579__$1;
(statearr_60645_60702[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_60646 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60646[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_60646[(1)] = (1));

return statearr_60646;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_60579){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60579);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60647){var ex__2730__auto__ = e60647;
var statearr_60648_60703 = state_60579;
(statearr_60648_60703[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60579[(4)]))){
var statearr_60649_60704 = state_60579;
(statearr_60649_60704[(1)] = cljs.core.first((state_60579[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60705 = state_60579;
state_60579 = G__60705;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_60579){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_60579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60650 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60650[(6)] = c__2749__auto__);

return statearr_60650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60855){
var state_val_60856 = (state_60855[(1)]);
if((state_val_60856 === (7))){
var inst_60767 = (state_60855[(2)]);
var inst_60768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60767,(0),null);
var inst_60769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60767,(1),null);
var inst_60777 = cljs.core.vals(inst_60769);
var inst_60778 = cljs.core.seq(inst_60777);
var inst_60779 = cljs.core.first(inst_60778);
var inst_60780 = cljs.core.next(inst_60778);
var inst_60781 = cljs.core.PersistentVector.EMPTY;
var inst_60782 = inst_60777;
var inst_60783 = inst_60781;
var state_60855__$1 = (function (){var statearr_60857 = state_60855;
(statearr_60857[(7)] = inst_60768);

(statearr_60857[(8)] = inst_60779);

(statearr_60857[(9)] = inst_60780);

(statearr_60857[(10)] = inst_60782);

(statearr_60857[(11)] = inst_60783);

return statearr_60857;
})();
var statearr_60858_60911 = state_60855__$1;
(statearr_60858_60911[(2)] = null);

(statearr_60858_60911[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (20))){
var inst_60789 = (state_60855[(12)]);
var inst_60794 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60795 = cljs.core.PersistentHashMap.EMPTY;
var inst_60796 = [true,inst_60795];
var inst_60797 = cljs.core.PersistentHashMap.fromArrays(inst_60794,inst_60796);
var inst_60798 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60797,inst_60789);
var state_60855__$1 = state_60855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60855__$1,(22),inst_60798);
} else {
if((state_val_60856 === (27))){
var inst_60843 = (state_60855[(2)]);
var state_60855__$1 = state_60855;
var statearr_60859_60912 = state_60855__$1;
(statearr_60859_60912[(2)] = inst_60843);

(statearr_60859_60912[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (1))){
var state_60855__$1 = state_60855;
var statearr_60860_60913 = state_60855__$1;
(statearr_60860_60913[(2)] = null);

(statearr_60860_60913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (24))){
var inst_60807 = (state_60855[(13)]);
var inst_60845 = (state_60855[(2)]);
var inst_60846 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60847 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60848 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60849 = [inst_60847,inst_60848,inst_60807,inst_60845];
var inst_60850 = cljs.core.PersistentHashMap.fromArrays(inst_60846,inst_60849);
var _ = (function (){var statearr_60862 = state_60855;
(statearr_60862[(4)] = cljs.core.rest((state_60855[(4)])));

return statearr_60862;
})();
var state_60855__$1 = state_60855;
var statearr_60863_60914 = state_60855__$1;
(statearr_60863_60914[(2)] = inst_60850);

(statearr_60863_60914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (4))){
var inst_60708 = (state_60855[(2)]);
var state_60855__$1 = state_60855;
var statearr_60864_60915 = state_60855__$1;
(statearr_60864_60915[(2)] = inst_60708);

(statearr_60864_60915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (15))){
var inst_60726 = (state_60855[(14)]);
var inst_60753 = (state_60855[(15)]);
var inst_60731 = (state_60855[(16)]);
var inst_60739 = (state_60855[(17)]);
var inst_60746 = (state_60855[(18)]);
var inst_60724 = (state_60855[(19)]);
var inst_60732 = (state_60855[(20)]);
var inst_60748 = (state_60855[(21)]);
var inst_60727 = (state_60855[(22)]);
var inst_60730 = (state_60855[(23)]);
var inst_60738 = (state_60855[(24)]);
var inst_60759 = (function (){var subject = inst_60746;
var flake = inst_60738;
var r = inst_60739;
var asserted_subjects = inst_60731;
var flake_SINGLEQUOTE_ = inst_60753;
var retracted_subjects = inst_60732;
var vec__60721 = inst_60724;
var seq__60735 = inst_60739;
var first__60736 = inst_60738;
var seq__60722 = inst_60727;
var asserted_QMARK_ = inst_60748;
var vec__60734 = inst_60730;
var first__60723 = inst_60726;
var G__60720 = inst_60730;
return (function (p1__60707_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60707_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60760 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60732,inst_60746,inst_60759);
var tmp60861 = inst_60731;
var inst_60730__$1 = inst_60739;
var inst_60731__$1 = tmp60861;
var inst_60732__$1 = inst_60760;
var state_60855__$1 = (function (){var statearr_60865 = state_60855;
(statearr_60865[(16)] = inst_60731__$1);

(statearr_60865[(20)] = inst_60732__$1);

(statearr_60865[(23)] = inst_60730__$1);

return statearr_60865;
})();
var statearr_60866_60916 = state_60855__$1;
(statearr_60866_60916[(2)] = null);

(statearr_60866_60916[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (21))){
var inst_60805 = (state_60855[(2)]);
var state_60855__$1 = state_60855;
var statearr_60867_60917 = state_60855__$1;
(statearr_60867_60917[(2)] = inst_60805);

(statearr_60867_60917[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (13))){
var inst_60748 = (state_60855[(21)]);
var inst_60753 = (state_60855[(2)]);
var state_60855__$1 = (function (){var statearr_60868 = state_60855;
(statearr_60868[(15)] = inst_60753);

return statearr_60868;
})();
if(cljs.core.truth_(inst_60748)){
var statearr_60869_60918 = state_60855__$1;
(statearr_60869_60918[(1)] = (14));

} else {
var statearr_60870_60919 = state_60855__$1;
(statearr_60870_60919[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (22))){
var inst_60790 = (state_60855[(25)]);
var inst_60783 = (state_60855[(11)]);
var inst_60800 = (state_60855[(2)]);
var inst_60801 = fluree.db.util.async.throw_err(inst_60800);
var inst_60802 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60783,inst_60801);
var inst_60782 = inst_60790;
var inst_60783__$1 = inst_60802;
var state_60855__$1 = (function (){var statearr_60871 = state_60855;
(statearr_60871[(10)] = inst_60782);

(statearr_60871[(11)] = inst_60783__$1);

return statearr_60871;
})();
var statearr_60872_60920 = state_60855__$1;
(statearr_60872_60920[(2)] = null);

(statearr_60872_60920[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (6))){
var inst_60730 = (state_60855[(23)]);
var inst_60738 = (state_60855[(24)]);
var inst_60737 = cljs.core.seq(inst_60730);
var inst_60738__$1 = cljs.core.first(inst_60737);
var inst_60739 = cljs.core.next(inst_60737);
var inst_60740 = cljs.core.not(inst_60738__$1);
var state_60855__$1 = (function (){var statearr_60873 = state_60855;
(statearr_60873[(17)] = inst_60739);

(statearr_60873[(24)] = inst_60738__$1);

return statearr_60873;
})();
if(inst_60740){
var statearr_60874_60921 = state_60855__$1;
(statearr_60874_60921[(1)] = (8));

} else {
var statearr_60875_60922 = state_60855__$1;
(statearr_60875_60922[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (28))){
var inst_60821 = (state_60855[(26)]);
var inst_60828 = (state_60855[(27)]);
var inst_60838 = (state_60855[(2)]);
var inst_60839 = fluree.db.util.async.throw_err(inst_60838);
var inst_60840 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60821,inst_60839);
var inst_60820 = inst_60828;
var inst_60821__$1 = inst_60840;
var state_60855__$1 = (function (){var statearr_60876 = state_60855;
(statearr_60876[(26)] = inst_60821__$1);

(statearr_60876[(28)] = inst_60820);

return statearr_60876;
})();
var statearr_60877_60923 = state_60855__$1;
(statearr_60877_60923[(2)] = null);

(statearr_60877_60923[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (25))){
var inst_60821 = (state_60855[(26)]);
var state_60855__$1 = state_60855;
var statearr_60878_60924 = state_60855__$1;
(statearr_60878_60924[(2)] = inst_60821);

(statearr_60878_60924[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (17))){
var inst_60789 = (state_60855[(12)]);
var inst_60782 = (state_60855[(10)]);
var inst_60788 = cljs.core.seq(inst_60782);
var inst_60789__$1 = cljs.core.first(inst_60788);
var inst_60790 = cljs.core.next(inst_60788);
var inst_60791 = cljs.core.not(inst_60789__$1);
var state_60855__$1 = (function (){var statearr_60879 = state_60855;
(statearr_60879[(12)] = inst_60789__$1);

(statearr_60879[(25)] = inst_60790);

return statearr_60879;
})();
if(inst_60791){
var statearr_60880_60925 = state_60855__$1;
(statearr_60880_60925[(1)] = (19));

} else {
var statearr_60881_60926 = state_60855__$1;
(statearr_60881_60926[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (3))){
var inst_60853 = (state_60855[(2)]);
var state_60855__$1 = state_60855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60855__$1,inst_60853);
} else {
if((state_val_60856 === (12))){
var inst_60738 = (state_60855[(24)]);
var inst_60751 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_60738);
var state_60855__$1 = state_60855;
var statearr_60882_60927 = state_60855__$1;
(statearr_60882_60927[(2)] = inst_60751);

(statearr_60882_60927[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (2))){
var inst_60724 = (state_60855[(19)]);
var _ = (function (){var statearr_60883 = state_60855;
(statearr_60883[(4)] = cljs.core.cons((5),(state_60855[(4)])));

return statearr_60883;
})();
var inst_60724__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60725 = cljs.core.seq(inst_60724__$1);
var inst_60726 = cljs.core.first(inst_60725);
var inst_60727 = cljs.core.next(inst_60725);
var inst_60728 = cljs.core.PersistentHashMap.EMPTY;
var inst_60729 = cljs.core.PersistentHashMap.EMPTY;
var inst_60730 = inst_60724__$1;
var inst_60731 = inst_60728;
var inst_60732 = inst_60729;
var state_60855__$1 = (function (){var statearr_60884 = state_60855;
(statearr_60884[(14)] = inst_60726);

(statearr_60884[(16)] = inst_60731);

(statearr_60884[(19)] = inst_60724__$1);

(statearr_60884[(20)] = inst_60732);

(statearr_60884[(22)] = inst_60727);

(statearr_60884[(23)] = inst_60730);

return statearr_60884;
})();
var statearr_60885_60928 = state_60855__$1;
(statearr_60885_60928[(2)] = null);

(statearr_60885_60928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (23))){
var inst_60827 = (state_60855[(29)]);
var inst_60820 = (state_60855[(28)]);
var inst_60826 = cljs.core.seq(inst_60820);
var inst_60827__$1 = cljs.core.first(inst_60826);
var inst_60828 = cljs.core.next(inst_60826);
var inst_60829 = cljs.core.not(inst_60827__$1);
var state_60855__$1 = (function (){var statearr_60886 = state_60855;
(statearr_60886[(29)] = inst_60827__$1);

(statearr_60886[(27)] = inst_60828);

return statearr_60886;
})();
if(inst_60829){
var statearr_60887_60929 = state_60855__$1;
(statearr_60887_60929[(1)] = (25));

} else {
var statearr_60888_60930 = state_60855__$1;
(statearr_60888_60930[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (19))){
var inst_60783 = (state_60855[(11)]);
var state_60855__$1 = state_60855;
var statearr_60889_60931 = state_60855__$1;
(statearr_60889_60931[(2)] = inst_60783);

(statearr_60889_60931[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (11))){
var inst_60738 = (state_60855[(24)]);
var state_60855__$1 = state_60855;
var statearr_60891_60932 = state_60855__$1;
(statearr_60891_60932[(2)] = inst_60738);

(statearr_60891_60932[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (9))){
var inst_60748 = (state_60855[(21)]);
var inst_60738 = (state_60855[(24)]);
var inst_60746 = inst_60738.s;
var inst_60747 = inst_60738.op;
var inst_60748__$1 = inst_60747 === true;
var state_60855__$1 = (function (){var statearr_60893 = state_60855;
(statearr_60893[(18)] = inst_60746);

(statearr_60893[(21)] = inst_60748__$1);

return statearr_60893;
})();
if(cljs.core.truth_(inst_60748__$1)){
var statearr_60894_60933 = state_60855__$1;
(statearr_60894_60933[(1)] = (11));

} else {
var statearr_60895_60934 = state_60855__$1;
(statearr_60895_60934[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (5))){
var _ = (function (){var statearr_60896 = state_60855;
(statearr_60896[(4)] = cljs.core.rest((state_60855[(4)])));

return statearr_60896;
})();
var state_60855__$1 = state_60855;
var ex60890 = (state_60855__$1[(2)]);
var statearr_60897_60935 = state_60855__$1;
(statearr_60897_60935[(5)] = ex60890);


if((ex60890 instanceof Error)){
var statearr_60898_60936 = state_60855__$1;
(statearr_60898_60936[(1)] = (4));

(statearr_60898_60936[(5)] = null);

} else {
throw ex60890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (14))){
var inst_60726 = (state_60855[(14)]);
var inst_60753 = (state_60855[(15)]);
var inst_60731 = (state_60855[(16)]);
var inst_60739 = (state_60855[(17)]);
var inst_60746 = (state_60855[(18)]);
var inst_60724 = (state_60855[(19)]);
var inst_60732 = (state_60855[(20)]);
var inst_60748 = (state_60855[(21)]);
var inst_60727 = (state_60855[(22)]);
var inst_60730 = (state_60855[(23)]);
var inst_60738 = (state_60855[(24)]);
var inst_60755 = (function (){var subject = inst_60746;
var flake = inst_60738;
var r = inst_60739;
var asserted_subjects = inst_60731;
var flake_SINGLEQUOTE_ = inst_60753;
var retracted_subjects = inst_60732;
var vec__60721 = inst_60724;
var seq__60735 = inst_60739;
var first__60736 = inst_60738;
var seq__60722 = inst_60727;
var asserted_QMARK_ = inst_60748;
var vec__60734 = inst_60730;
var first__60723 = inst_60726;
var G__60720 = inst_60730;
return (function (p1__60706_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60706_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60756 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60731,inst_60746,inst_60755);
var tmp60892 = inst_60732;
var inst_60730__$1 = inst_60739;
var inst_60731__$1 = inst_60756;
var inst_60732__$1 = tmp60892;
var state_60855__$1 = (function (){var statearr_60899 = state_60855;
(statearr_60899[(16)] = inst_60731__$1);

(statearr_60899[(20)] = inst_60732__$1);

(statearr_60899[(23)] = inst_60730__$1);

return statearr_60899;
})();
var statearr_60900_60937 = state_60855__$1;
(statearr_60900_60937[(2)] = null);

(statearr_60900_60937[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (26))){
var inst_60827 = (state_60855[(29)]);
var inst_60832 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60833 = cljs.core.PersistentHashMap.EMPTY;
var inst_60834 = [true,inst_60833];
var inst_60835 = cljs.core.PersistentHashMap.fromArrays(inst_60832,inst_60834);
var inst_60836 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60835,inst_60827);
var state_60855__$1 = state_60855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60855__$1,(28),inst_60836);
} else {
if((state_val_60856 === (16))){
var inst_60763 = (state_60855[(2)]);
var state_60855__$1 = state_60855;
var statearr_60901_60938 = state_60855__$1;
(statearr_60901_60938[(2)] = inst_60763);

(statearr_60901_60938[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (10))){
var inst_60765 = (state_60855[(2)]);
var state_60855__$1 = state_60855;
var statearr_60902_60939 = state_60855__$1;
(statearr_60902_60939[(2)] = inst_60765);

(statearr_60902_60939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (18))){
var inst_60768 = (state_60855[(7)]);
var inst_60807 = (state_60855[(2)]);
var inst_60815 = cljs.core.vals(inst_60768);
var inst_60816 = cljs.core.seq(inst_60815);
var inst_60817 = cljs.core.first(inst_60816);
var inst_60818 = cljs.core.next(inst_60816);
var inst_60819 = cljs.core.PersistentVector.EMPTY;
var inst_60820 = inst_60815;
var inst_60821 = inst_60819;
var state_60855__$1 = (function (){var statearr_60903 = state_60855;
(statearr_60903[(30)] = inst_60817);

(statearr_60903[(26)] = inst_60821);

(statearr_60903[(13)] = inst_60807);

(statearr_60903[(28)] = inst_60820);

(statearr_60903[(31)] = inst_60818);

return statearr_60903;
})();
var statearr_60904_60940 = state_60855__$1;
(statearr_60904_60940[(2)] = null);

(statearr_60904_60940[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60856 === (8))){
var inst_60731 = (state_60855[(16)]);
var inst_60732 = (state_60855[(20)]);
var inst_60742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60743 = [inst_60731,inst_60732];
var inst_60744 = (new cljs.core.PersistentVector(null,2,(5),inst_60742,inst_60743,null));
var state_60855__$1 = state_60855;
var statearr_60905_60941 = state_60855__$1;
(statearr_60905_60941[(2)] = inst_60744);

(statearr_60905_60941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_60906 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60906[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_60906[(1)] = (1));

return statearr_60906;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_60855){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60855);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60907){var ex__2730__auto__ = e60907;
var statearr_60908_60942 = state_60855;
(statearr_60908_60942[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60855[(4)]))){
var statearr_60909_60943 = state_60855;
(statearr_60909_60943[(1)] = cljs.core.first((state_60855[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60944 = state_60855;
state_60855 = G__60944;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_60855){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_60855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60910 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60910[(6)] = c__2749__auto__);

return statearr_60910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60976){
var state_val_60977 = (state_60976[(1)]);
if((state_val_60977 === (1))){
var inst_60945 = cljs.core.volatile_BANG_((0));
var inst_60946 = cljs.core.PersistentHashMap.EMPTY;
var inst_60947 = cljs.core.volatile_BANG_(inst_60946);
var inst_60948 = cljs.core.first(resp);
var inst_60949 = cljs.core.rest(resp);
var inst_60950 = cljs.core.PersistentVector.EMPTY;
var inst_60951 = inst_60945;
var inst_60952 = inst_60947;
var inst_60953 = inst_60948;
var inst_60954 = inst_60949;
var inst_60955 = inst_60950;
var state_60976__$1 = (function (){var statearr_60978 = state_60976;
(statearr_60978[(7)] = inst_60955);

(statearr_60978[(8)] = inst_60953);

(statearr_60978[(9)] = inst_60951);

(statearr_60978[(10)] = inst_60952);

(statearr_60978[(11)] = inst_60954);

return statearr_60978;
})();
var statearr_60979_60994 = state_60976__$1;
(statearr_60979_60994[(2)] = null);

(statearr_60979_60994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60977 === (2))){
var inst_60953 = (state_60976[(8)]);
var inst_60951 = (state_60976[(9)]);
var inst_60952 = (state_60976[(10)]);
var inst_60957 = fluree.db.api.query.format_block_resp_pretty(db,inst_60953,inst_60952,inst_60951);
var state_60976__$1 = state_60976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60976__$1,(4),inst_60957);
} else {
if((state_val_60977 === (3))){
var inst_60974 = (state_60976[(2)]);
var state_60976__$1 = state_60976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60976__$1,inst_60974);
} else {
if((state_val_60977 === (4))){
var inst_60955 = (state_60976[(7)]);
var inst_60954 = (state_60976[(11)]);
var inst_60959 = (state_60976[(2)]);
var inst_60960 = fluree.db.util.async.throw_err(inst_60959);
var inst_60961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60962 = [inst_60960];
var inst_60963 = (new cljs.core.PersistentVector(null,1,(5),inst_60961,inst_60962,null));
var inst_60964 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60955,inst_60963);
var inst_60965 = cljs.core.first(inst_60954);
var state_60976__$1 = (function (){var statearr_60982 = state_60976;
(statearr_60982[(12)] = inst_60964);

return statearr_60982;
})();
if(cljs.core.truth_(inst_60965)){
var statearr_60983_60995 = state_60976__$1;
(statearr_60983_60995[(1)] = (5));

} else {
var statearr_60984_60996 = state_60976__$1;
(statearr_60984_60996[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60977 === (5))){
var inst_60964 = (state_60976[(12)]);
var inst_60951 = (state_60976[(9)]);
var inst_60952 = (state_60976[(10)]);
var inst_60954 = (state_60976[(11)]);
var inst_60967 = cljs.core.first(inst_60954);
var inst_60968 = cljs.core.rest(inst_60954);
var tmp60980 = inst_60951;
var tmp60981 = inst_60952;
var inst_60951__$1 = tmp60980;
var inst_60952__$1 = tmp60981;
var inst_60953 = inst_60967;
var inst_60954__$1 = inst_60968;
var inst_60955 = inst_60964;
var state_60976__$1 = (function (){var statearr_60985 = state_60976;
(statearr_60985[(7)] = inst_60955);

(statearr_60985[(8)] = inst_60953);

(statearr_60985[(9)] = inst_60951__$1);

(statearr_60985[(10)] = inst_60952__$1);

(statearr_60985[(11)] = inst_60954__$1);

return statearr_60985;
})();
var statearr_60986_60997 = state_60976__$1;
(statearr_60986_60997[(2)] = null);

(statearr_60986_60997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60977 === (6))){
var inst_60964 = (state_60976[(12)]);
var state_60976__$1 = state_60976;
var statearr_60987_60998 = state_60976__$1;
(statearr_60987_60998[(2)] = inst_60964);

(statearr_60987_60998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60977 === (7))){
var inst_60972 = (state_60976[(2)]);
var state_60976__$1 = state_60976;
var statearr_60988_60999 = state_60976__$1;
(statearr_60988_60999[(2)] = inst_60972);

(statearr_60988_60999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_60989 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60989[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_60989[(1)] = (1));

return statearr_60989;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_60976){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60976);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60990){var ex__2730__auto__ = e60990;
var statearr_60991_61000 = state_60976;
(statearr_60991_61000[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60976[(4)]))){
var statearr_60992_61001 = state_60976;
(statearr_60992_61001[(1)] = cljs.core.first((state_60976[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61002 = state_60976;
state_60976 = G__61002;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_60976){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_60976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60993 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60993[(6)] = c__2749__auto__);

return statearr_60993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__61004 = arguments.length;
switch (G__61004) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__61006){
var map__61007 = p__61006;
var map__61007__$1 = cljs.core.__destructure_map(map__61007);
var query = map__61007__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__61007__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61092){
var state_val_61093 = (state_61092[(1)]);
if((state_val_61093 === (7))){
var inst_61018 = (state_61092[(7)]);
var inst_61022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61023 = ["_auth/id",inst_61018];
var inst_61024 = (new cljs.core.PersistentVector(null,2,(5),inst_61022,inst_61023,null));
var state_61092__$1 = state_61092;
var statearr_61094_61138 = state_61092__$1;
(statearr_61094_61138[(2)] = inst_61024);

(statearr_61094_61138[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (20))){
var inst_61072 = (state_61092[(2)]);
var inst_61073 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_61092__$1 = (function (){var statearr_61095 = state_61092;
(statearr_61095[(8)] = inst_61072);

return statearr_61095;
})();
if(cljs.core.truth_(inst_61073)){
var statearr_61096_61139 = state_61092__$1;
(statearr_61096_61139[(1)] = (22));

} else {
var statearr_61097_61140 = state_61092__$1;
(statearr_61097_61140[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (27))){
var inst_61075 = (state_61092[(9)]);
var inst_61019 = (state_61092[(10)]);
var inst_61081 = (state_61092[(2)]);
var inst_61082 = fluree.db.util.core.response_time_formatted(inst_61019);
var inst_61083 = [(200),inst_61081,(100),inst_61082];
var inst_61084 = cljs.core.PersistentHashMap.fromArrays(inst_61075,inst_61083);
var state_61092__$1 = state_61092;
var statearr_61098_61141 = state_61092__$1;
(statearr_61098_61141[(2)] = inst_61084);

(statearr_61098_61141[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (1))){
var state_61092__$1 = state_61092;
var statearr_61099_61142 = state_61092__$1;
(statearr_61099_61142[(2)] = null);

(statearr_61099_61142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (24))){
var inst_61087 = (state_61092[(2)]);
var _ = (function (){var statearr_61100 = state_61092;
(statearr_61100[(4)] = cljs.core.rest((state_61092[(4)])));

return statearr_61100;
})();
var state_61092__$1 = state_61092;
var statearr_61101_61143 = state_61092__$1;
(statearr_61101_61143[(2)] = inst_61087);

(statearr_61101_61143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (4))){
var inst_61008 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
var statearr_61102_61144 = state_61092__$1;
(statearr_61102_61144[(2)] = inst_61008);

(statearr_61102_61144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (15))){
var inst_61059 = (state_61092[(11)]);
var state_61092__$1 = state_61092;
var statearr_61103_61145 = state_61092__$1;
(statearr_61103_61145[(2)] = inst_61059);

(statearr_61103_61145[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (21))){
var inst_61068 = (state_61092[(2)]);
var inst_61069 = fluree.db.util.async.throw_err(inst_61068);
var state_61092__$1 = state_61092;
var statearr_61104_61146 = state_61092__$1;
(statearr_61104_61146[(2)] = inst_61069);

(statearr_61104_61146[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (13))){
var inst_61017 = (state_61092[(12)]);
var inst_61059 = (state_61092[(11)]);
var inst_61058 = (state_61092[(2)]);
var inst_61059__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_61017);
var state_61092__$1 = (function (){var statearr_61105 = state_61092;
(statearr_61105[(11)] = inst_61059__$1);

(statearr_61105[(13)] = inst_61058);

return statearr_61105;
})();
if(cljs.core.truth_(inst_61059__$1)){
var statearr_61106_61147 = state_61092__$1;
(statearr_61106_61147[(1)] = (15));

} else {
var statearr_61107_61148 = state_61092__$1;
(statearr_61107_61148[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (22))){
var inst_61072 = (state_61092[(8)]);
var inst_61075 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61076 = cljs.core.sequential_QMARK_(inst_61072);
var state_61092__$1 = (function (){var statearr_61108 = state_61092;
(statearr_61108[(9)] = inst_61075);

return statearr_61108;
})();
if(inst_61076){
var statearr_61109_61149 = state_61092__$1;
(statearr_61109_61149[(1)] = (25));

} else {
var statearr_61110_61150 = state_61092__$1;
(statearr_61110_61150[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (6))){
var inst_61017 = (state_61092[(12)]);
var inst_61033 = (state_61092[(14)]);
var inst_61032 = (state_61092[(2)]);
var inst_61033__$1 = fluree.db.util.async.throw_err(inst_61032);
var inst_61034 = fluree.db.api.query.resolve_block_range(inst_61033__$1,inst_61017);
var state_61092__$1 = (function (){var statearr_61111 = state_61092;
(statearr_61111[(14)] = inst_61033__$1);

return statearr_61111;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61092__$1,(10),inst_61034);
} else {
if((state_val_61093 === (25))){
var inst_61072 = (state_61092[(8)]);
var inst_61078 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_61072);
var state_61092__$1 = state_61092;
var statearr_61112_61151 = state_61092__$1;
(statearr_61112_61151[(2)] = inst_61078);

(statearr_61112_61151[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (17))){
var inst_61064 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
if(cljs.core.truth_(inst_61064)){
var statearr_61113_61152 = state_61092__$1;
(statearr_61113_61152[(1)] = (18));

} else {
var statearr_61114_61153 = state_61092__$1;
(statearr_61114_61153[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (3))){
var inst_61090 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61092__$1,inst_61090);
} else {
if((state_val_61093 === (12))){
var inst_61017 = (state_61092[(12)]);
var inst_61050 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61017], 0));
var inst_61051 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_61050].join('');
var inst_61052 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61053 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61054 = cljs.core.PersistentHashMap.fromArrays(inst_61052,inst_61053);
var inst_61055 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61051,inst_61054);
var inst_61056 = (function(){throw inst_61055})();
var state_61092__$1 = state_61092;
var statearr_61115_61154 = state_61092__$1;
(statearr_61115_61154[(2)] = inst_61056);

(statearr_61115_61154[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (2))){
var inst_61018 = (state_61092[(7)]);
var _ = (function (){var statearr_61116 = state_61092;
(statearr_61116[(4)] = cljs.core.cons((5),(state_61092[(4)])));

return statearr_61116;
})();
var inst_61017 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61018__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_61019 = fluree.db.util.core.current_time_millis();
var inst_61020 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_61092__$1 = (function (){var statearr_61117 = state_61092;
(statearr_61117[(12)] = inst_61017);

(statearr_61117[(10)] = inst_61019);

(statearr_61117[(7)] = inst_61018__$1);

(statearr_61117[(15)] = inst_61020);

return statearr_61117;
})();
if(cljs.core.truth_(inst_61018__$1)){
var statearr_61118_61155 = state_61092__$1;
(statearr_61118_61155[(1)] = (7));

} else {
var statearr_61119_61156 = state_61092__$1;
(statearr_61119_61156[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (23))){
var inst_61072 = (state_61092[(8)]);
var state_61092__$1 = state_61092;
var statearr_61120_61157 = state_61092__$1;
(statearr_61120_61157[(2)] = inst_61072);

(statearr_61120_61157[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (19))){
var inst_61058 = (state_61092[(13)]);
var state_61092__$1 = state_61092;
var statearr_61121_61158 = state_61092__$1;
(statearr_61121_61158[(2)] = inst_61058);

(statearr_61121_61158[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (11))){
var inst_61039 = (state_61092[(16)]);
var inst_61038 = (state_61092[(17)]);
var inst_61033 = (state_61092[(14)]);
var inst_61045 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_61033,inst_61038,inst_61039,opts);
var state_61092__$1 = state_61092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61092__$1,(14),inst_61045);
} else {
if((state_val_61093 === (9))){
var inst_61020 = (state_61092[(15)]);
var inst_61027 = (state_61092[(2)]);
var inst_61028 = [inst_61027];
var inst_61029 = cljs.core.PersistentHashMap.fromArrays(inst_61020,inst_61028);
var inst_61030 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_61029);
var state_61092__$1 = state_61092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61092__$1,(6),inst_61030);
} else {
if((state_val_61093 === (5))){
var _ = (function (){var statearr_61123 = state_61092;
(statearr_61123[(4)] = cljs.core.rest((state_61092[(4)])));

return statearr_61123;
})();
var state_61092__$1 = state_61092;
var ex61122 = (state_61092__$1[(2)]);
var statearr_61124_61159 = state_61092__$1;
(statearr_61124_61159[(5)] = ex61122);


if((ex61122 instanceof Error)){
var statearr_61125_61160 = state_61092__$1;
(statearr_61125_61160[(1)] = (4));

(statearr_61125_61160[(5)] = null);

} else {
throw ex61122;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (14))){
var inst_61047 = (state_61092[(2)]);
var inst_61048 = fluree.db.util.async.throw_err(inst_61047);
var state_61092__$1 = state_61092;
var statearr_61126_61161 = state_61092__$1;
(statearr_61126_61161[(2)] = inst_61048);

(statearr_61126_61161[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (26))){
var inst_61072 = (state_61092[(8)]);
var state_61092__$1 = state_61092;
var statearr_61127_61162 = state_61092__$1;
(statearr_61127_61162[(2)] = inst_61072);

(statearr_61127_61162[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (16))){
var inst_61017 = (state_61092[(12)]);
var inst_61062 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_61017);
var state_61092__$1 = state_61092;
var statearr_61128_61163 = state_61092__$1;
(statearr_61128_61163[(2)] = inst_61062);

(statearr_61128_61163[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (10))){
var inst_61017 = (state_61092[(12)]);
var inst_61036 = (state_61092[(2)]);
var inst_61037 = fluree.db.util.async.throw_err(inst_61036);
var inst_61038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61037,(0),null);
var inst_61039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61037,(1),null);
var inst_61040 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_61041 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_61017,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_61042 = cljs.core.keys(inst_61041);
var inst_61043 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61040,inst_61042);
var state_61092__$1 = (function (){var statearr_61129 = state_61092;
(statearr_61129[(16)] = inst_61039);

(statearr_61129[(17)] = inst_61038);

return statearr_61129;
})();
if(inst_61043){
var statearr_61130_61164 = state_61092__$1;
(statearr_61130_61164[(1)] = (11));

} else {
var statearr_61131_61165 = state_61092__$1;
(statearr_61131_61165[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (18))){
var inst_61033 = (state_61092[(14)]);
var inst_61058 = (state_61092[(13)]);
var inst_61066 = fluree.db.api.query.format_blocks_resp_pretty(inst_61033,inst_61058);
var state_61092__$1 = state_61092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61092__$1,(21),inst_61066);
} else {
if((state_val_61093 === (8))){
var state_61092__$1 = state_61092;
var statearr_61132_61166 = state_61092__$1;
(statearr_61132_61166[(2)] = null);

(statearr_61132_61166[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_61133 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61133[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_61133[(1)] = (1));

return statearr_61133;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_61092){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61092);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61134){var ex__2730__auto__ = e61134;
var statearr_61135_61167 = state_61092;
(statearr_61135_61167[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61092[(4)]))){
var statearr_61136_61168 = state_61092;
(statearr_61136_61168[(1)] = cljs.core.first((state_61092[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61169 = state_61092;
state_61092 = G__61169;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_61092){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_61092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61137 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61137[(6)] = c__2749__auto__);

return statearr_61137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__61170 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61170,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61170,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61170,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61170,(3),null);
var vec__61173 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61173,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61173,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__61176 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61176,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61176,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___61180 = arguments.length;
var i__5770__auto___61181 = (0);
while(true){
if((i__5770__auto___61181 < len__5769__auto___61180)){
args__5775__auto__.push((arguments[i__5770__auto___61181]));

var G__61182 = (i__5770__auto___61181 + (1));
i__5770__auto___61181 = G__61182;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq61179){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq61179));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61378){
var state_val_61379 = (state_61378[(1)]);
if((state_val_61379 === (7))){
var inst_61298 = (state_61378[(7)]);
var inst_61305 = (state_61378[(8)]);
var inst_61304 = cljs.core.seq(inst_61298);
var inst_61305__$1 = cljs.core.first(inst_61304);
var inst_61306 = cljs.core.next(inst_61304);
var state_61378__$1 = (function (){var statearr_61380 = state_61378;
(statearr_61380[(9)] = inst_61306);

(statearr_61380[(8)] = inst_61305__$1);

return statearr_61380;
})();
if(cljs.core.truth_(inst_61305__$1)){
var statearr_61381_61481 = state_61378__$1;
(statearr_61381_61481[(1)] = (9));

} else {
var statearr_61382_61482 = state_61378__$1;
(statearr_61382_61482[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (20))){
var inst_61368 = (state_61378[(2)]);
var state_61378__$1 = state_61378;
var statearr_61383_61483 = state_61378__$1;
(statearr_61383_61483[(2)] = inst_61368);

(statearr_61383_61483[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (27))){
var inst_61323 = (state_61378[(10)]);
var inst_61344 = (state_61378[(11)]);
var inst_61326 = (state_61378[(12)]);
var inst_61346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61347 = [inst_61326,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61348 = (new cljs.core.PersistentVector(null,2,(5),inst_61346,inst_61347,null));
var inst_61349 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61344,inst_61348,fluree.db.api.query.min_safe,inst_61323);
var state_61378__$1 = state_61378;
var statearr_61384_61484 = state_61378__$1;
(statearr_61384_61484[(2)] = inst_61349);

(statearr_61384_61484[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (1))){
var state_61378__$1 = state_61378;
var statearr_61385_61485 = state_61378__$1;
(statearr_61385_61485[(2)] = null);

(statearr_61385_61485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (24))){
var inst_61305 = (state_61378[(8)]);
var inst_61336 = (state_61378[(13)]);
var inst_61326 = (state_61378[(12)]);
var inst_61338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61339 = [inst_61326,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61340 = (new cljs.core.PersistentVector(null,2,(5),inst_61338,inst_61339,null));
var inst_61341 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61336,inst_61340,cljs.core.conj,inst_61305);
var state_61378__$1 = state_61378;
var statearr_61387_61486 = state_61378__$1;
(statearr_61387_61486[(2)] = inst_61341);

(statearr_61387_61486[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (4))){
var inst_61184 = (state_61378[(2)]);
var state_61378__$1 = state_61378;
var statearr_61388_61487 = state_61378__$1;
(statearr_61388_61487[(2)] = inst_61184);

(statearr_61388_61487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (15))){
var inst_61306 = (state_61378[(9)]);
var inst_61299 = (state_61378[(14)]);
var tmp61386 = inst_61299;
var inst_61298 = inst_61306;
var inst_61299__$1 = tmp61386;
var state_61378__$1 = (function (){var statearr_61389 = state_61378;
(statearr_61389[(7)] = inst_61298);

(statearr_61389[(14)] = inst_61299__$1);

return statearr_61389;
})();
var statearr_61390_61488 = state_61378__$1;
(statearr_61390_61488[(2)] = null);

(statearr_61390_61488[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (21))){
var inst_61299 = (state_61378[(14)]);
var inst_61326 = (state_61378[(12)]);
var inst_61330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61331 = [inst_61326,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61332 = (new cljs.core.PersistentVector(null,2,(5),inst_61330,inst_61331,null));
var inst_61333 = cljs.core.assoc_in(inst_61299,inst_61332,inst_61326);
var state_61378__$1 = state_61378;
var statearr_61391_61489 = state_61378__$1;
(statearr_61391_61489[(2)] = inst_61333);

(statearr_61391_61489[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (31))){
var inst_61352 = (state_61378[(15)]);
var state_61378__$1 = state_61378;
var statearr_61392_61490 = state_61378__$1;
(statearr_61392_61490[(2)] = inst_61352);

(statearr_61392_61490[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (32))){
var inst_61306 = (state_61378[(9)]);
var inst_61360 = (state_61378[(2)]);
var inst_61298 = inst_61306;
var inst_61299 = inst_61360;
var state_61378__$1 = (function (){var statearr_61393 = state_61378;
(statearr_61393[(7)] = inst_61298);

(statearr_61393[(14)] = inst_61299);

return statearr_61393;
})();
var statearr_61394_61491 = state_61378__$1;
(statearr_61394_61491[(2)] = null);

(statearr_61394_61491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (33))){
var inst_61299 = (state_61378[(14)]);
var state_61378__$1 = state_61378;
var statearr_61395_61492 = state_61378__$1;
(statearr_61395_61492[(2)] = inst_61299);

(statearr_61395_61492[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (13))){
var inst_61308 = (state_61378[(16)]);
var state_61378__$1 = state_61378;
var statearr_61396_61493 = state_61378__$1;
(statearr_61396_61493[(2)] = inst_61308);

(statearr_61396_61493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (22))){
var inst_61299 = (state_61378[(14)]);
var state_61378__$1 = state_61378;
var statearr_61397_61494 = state_61378__$1;
(statearr_61397_61494[(2)] = inst_61299);

(statearr_61397_61494[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (29))){
var inst_61352 = (state_61378[(2)]);
var state_61378__$1 = (function (){var statearr_61398 = state_61378;
(statearr_61398[(15)] = inst_61352);

return statearr_61398;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61399_61495 = state_61378__$1;
(statearr_61399_61495[(1)] = (30));

} else {
var statearr_61400_61496 = state_61378__$1;
(statearr_61400_61496[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (6))){
var inst_61284 = (state_61378[(2)]);
var inst_61285 = fluree.db.util.async.throw_err(inst_61284);
var inst_61293 = resp;
var inst_61294 = cljs.core.seq(inst_61293);
var inst_61295 = cljs.core.first(inst_61294);
var inst_61296 = cljs.core.next(inst_61294);
var inst_61297 = cljs.core.PersistentHashMap.EMPTY;
var inst_61298 = inst_61293;
var inst_61299 = inst_61297;
var state_61378__$1 = (function (){var statearr_61401 = state_61378;
(statearr_61401[(17)] = inst_61295);

(statearr_61401[(7)] = inst_61298);

(statearr_61401[(14)] = inst_61299);

(statearr_61401[(18)] = inst_61296);

(statearr_61401[(19)] = inst_61285);

return statearr_61401;
})();
var statearr_61402_61497 = state_61378__$1;
(statearr_61402_61497[(2)] = null);

(statearr_61402_61497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (28))){
var inst_61344 = (state_61378[(11)]);
var state_61378__$1 = state_61378;
var statearr_61403_61498 = state_61378__$1;
(statearr_61403_61498[(2)] = inst_61344);

(statearr_61403_61498[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (25))){
var inst_61336 = (state_61378[(13)]);
var state_61378__$1 = state_61378;
var statearr_61404_61499 = state_61378__$1;
(statearr_61404_61499[(2)] = inst_61336);

(statearr_61404_61499[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (34))){
var state_61378__$1 = state_61378;
var statearr_61405_61500 = state_61378__$1;
(statearr_61405_61500[(2)] = null);

(statearr_61405_61500[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (17))){
var inst_61370 = (state_61378[(2)]);
var state_61378__$1 = state_61378;
var statearr_61406_61501 = state_61378__$1;
(statearr_61406_61501[(2)] = inst_61370);

(statearr_61406_61501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (3))){
var inst_61376 = (state_61378[(2)]);
var state_61378__$1 = state_61378;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61378__$1,inst_61376);
} else {
if((state_val_61379 === (12))){
var inst_61305 = (state_61378[(8)]);
var inst_61285 = (state_61378[(19)]);
var inst_61310 = fluree.db.api.query.auth_match(auth,inst_61285,inst_61305);
var inst_61311 = cljs.core.not(inst_61310);
var state_61378__$1 = state_61378;
var statearr_61407_61502 = state_61378__$1;
(statearr_61407_61502[(2)] = inst_61311);

(statearr_61407_61502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (2))){
var _ = (function (){var statearr_61408 = state_61378;
(statearr_61408[(4)] = cljs.core.cons((5),(state_61378[(4)])));

return statearr_61408;
})();
var inst_61190 = (function (){return (function (p1__61183_SHARP_){
return p1__61183_SHARP_.t;
});
})();
var inst_61191 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61190,resp);
var inst_61192 = cljs.core.set(inst_61191);
var inst_61280 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61281 = (function (){var ts = inst_61192;
var c__2749__auto____$1 = inst_61280;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61278){
var state_val_61279 = (state_61278[(1)]);
if((state_val_61279 === (7))){
var inst_61206 = (state_61278[(7)]);
var inst_61212 = (state_61278[(8)]);
var inst_61218 = (state_61278[(9)]);
var inst_61224 = (state_61278[(10)]);
var inst_61217 = (state_61278[(2)]);
var inst_61218__$1 = fluree.db.util.async.throw_err(inst_61217);
var inst_61220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61221 = [inst_61212,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61222 = (new cljs.core.PersistentVector(null,2,(5),inst_61220,inst_61221,null));
var inst_61223 = cljs.core.assoc_in(inst_61206,inst_61222,inst_61218__$1);
var inst_61224__$1 = auth;
var state_61278__$1 = (function (){var statearr_61409 = state_61278;
(statearr_61409[(9)] = inst_61218__$1);

(statearr_61409[(11)] = inst_61223);

(statearr_61409[(10)] = inst_61224__$1);

return statearr_61409;
})();
if(cljs.core.truth_(inst_61224__$1)){
var statearr_61410_61503 = state_61278__$1;
(statearr_61410_61503[(1)] = (8));

} else {
var statearr_61411_61504 = state_61278__$1;
(statearr_61411_61504[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (1))){
var inst_61200 = (state_61278[(12)]);
var inst_61200__$1 = ts;
var inst_61201 = cljs.core.seq(inst_61200__$1);
var inst_61202 = cljs.core.first(inst_61201);
var inst_61203 = cljs.core.next(inst_61201);
var inst_61204 = cljs.core.PersistentHashMap.EMPTY;
var inst_61205 = inst_61200__$1;
var inst_61206 = inst_61204;
var state_61278__$1 = (function (){var statearr_61412 = state_61278;
(statearr_61412[(13)] = inst_61205);

(statearr_61412[(7)] = inst_61206);

(statearr_61412[(12)] = inst_61200__$1);

(statearr_61412[(14)] = inst_61203);

(statearr_61412[(15)] = inst_61202);

return statearr_61412;
})();
var statearr_61413_61505 = state_61278__$1;
(statearr_61413_61505[(2)] = null);

(statearr_61413_61505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (4))){
var inst_61212 = (state_61278[(8)]);
var inst_61215 = fluree.db.time_travel.non_border_t_to_block(db,inst_61212);
var state_61278__$1 = state_61278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61278__$1,(7),inst_61215);
} else {
if((state_val_61279 === (13))){
var inst_61213 = (state_61278[(16)]);
var inst_61270 = (state_61278[(2)]);
var inst_61205 = inst_61213;
var inst_61206 = inst_61270;
var state_61278__$1 = (function (){var statearr_61414 = state_61278;
(statearr_61414[(13)] = inst_61205);

(statearr_61414[(7)] = inst_61206);

return statearr_61414;
})();
var statearr_61415_61506 = state_61278__$1;
(statearr_61415_61506[(2)] = null);

(statearr_61415_61506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (6))){
var inst_61274 = (state_61278[(2)]);
var state_61278__$1 = state_61278;
var statearr_61416_61507 = state_61278__$1;
(statearr_61416_61507[(2)] = inst_61274);

(statearr_61416_61507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (3))){
var inst_61276 = (state_61278[(2)]);
var state_61278__$1 = state_61278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61278__$1,inst_61276);
} else {
if((state_val_61279 === (12))){
var inst_61223 = (state_61278[(11)]);
var state_61278__$1 = state_61278;
var statearr_61417_61508 = state_61278__$1;
(statearr_61417_61508[(2)] = inst_61223);

(statearr_61417_61508[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (2))){
var inst_61205 = (state_61278[(13)]);
var inst_61212 = (state_61278[(8)]);
var inst_61211 = cljs.core.seq(inst_61205);
var inst_61212__$1 = cljs.core.first(inst_61211);
var inst_61213 = cljs.core.next(inst_61211);
var state_61278__$1 = (function (){var statearr_61418 = state_61278;
(statearr_61418[(8)] = inst_61212__$1);

(statearr_61418[(16)] = inst_61213);

return statearr_61418;
})();
if(cljs.core.truth_(inst_61212__$1)){
var statearr_61419_61509 = state_61278__$1;
(statearr_61419_61509[(1)] = (4));

} else {
var statearr_61420_61510 = state_61278__$1;
(statearr_61420_61510[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (11))){
var inst_61205 = (state_61278[(13)]);
var inst_61206 = (state_61278[(7)]);
var inst_61212 = (state_61278[(8)]);
var inst_61200 = (state_61278[(12)]);
var inst_61218 = (state_61278[(9)]);
var inst_61203 = (state_61278[(14)]);
var inst_61213 = (state_61278[(16)]);
var inst_61223 = (state_61278[(11)]);
var inst_61202 = (state_61278[(15)]);
var inst_61230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61231 = [inst_61212,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61232 = (new cljs.core.PersistentVector(null,2,(5),inst_61230,inst_61231,null));
var inst_61245 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61246 = (function (){var first__61199 = inst_61202;
var t = inst_61212;
var c__2749__auto____$2 = inst_61245;
var G__61196 = inst_61205;
var block = inst_61218;
var r = inst_61213;
var acc = inst_61206;
var vec__61197 = inst_61200;
var first__61210 = inst_61212;
var seq__61209 = inst_61213;
var seq__61198 = inst_61203;
var G__61219 = inst_61223;
var vec__61208 = inst_61205;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61243){
var state_val_61244 = (state_61243[(1)]);
if((state_val_61244 === (1))){
var state_61243__$1 = state_61243;
var statearr_61421_61511 = state_61243__$1;
(statearr_61421_61511[(2)] = null);

(statearr_61421_61511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (2))){
var ___$1 = (function (){var statearr_61422 = state_61243;
(statearr_61422[(4)] = cljs.core.cons((5),(state_61243[(4)])));

return statearr_61422;
})();
var ___$2 = (function (){var statearr_61423 = state_61243;
(statearr_61423[(4)] = cljs.core.rest((state_61243[(4)])));

return statearr_61423;
})();
var state_61243__$1 = state_61243;
var statearr_61424_61512 = state_61243__$1;
(statearr_61424_61512[(2)] = db);

(statearr_61424_61512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (3))){
var inst_61241 = (state_61243[(2)]);
var state_61243__$1 = state_61243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61243__$1,inst_61241);
} else {
if((state_val_61244 === (4))){
var inst_61233 = (state_61243[(2)]);
var state_61243__$1 = state_61243;
var statearr_61426_61513 = state_61243__$1;
(statearr_61426_61513[(2)] = inst_61233);

(statearr_61426_61513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61244 === (5))){
var ___$1 = (function (){var statearr_61427 = state_61243;
(statearr_61427[(4)] = cljs.core.rest((state_61243[(4)])));

return statearr_61427;
})();
var state_61243__$1 = state_61243;
var ex61425 = (state_61243__$1[(2)]);
var statearr_61428_61514 = state_61243__$1;
(statearr_61428_61514[(5)] = ex61425);


if((ex61425 instanceof Error)){
var statearr_61429_61515 = state_61243__$1;
(statearr_61429_61515[(1)] = (4));

(statearr_61429_61515[(5)] = null);

} else {
throw ex61425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_61430 = [null,null,null,null,null,null,null];
(statearr_61430[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_61430[(1)] = (1));

return statearr_61430;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_61243){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61243);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61431){var ex__2730__auto__ = e61431;
var statearr_61432_61516 = state_61243;
(statearr_61432_61516[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61243[(4)]))){
var statearr_61433_61517 = state_61243;
(statearr_61433_61517[(1)] = cljs.core.first((state_61243[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61518 = state_61243;
state_61243 = G__61518;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_61243){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_61243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61434 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61434[(6)] = c__2749__auto____$2);

return statearr_61434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_61247 = cljs.core.async.impl.dispatch.run(inst_61246);
var inst_61248 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_61249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61250 = ["?auth","?id"];
var inst_61251 = (new cljs.core.PersistentVector(null,2,(5),inst_61249,inst_61250,null));
var inst_61252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61254 = [inst_61212,"_tx/auth","?auth"];
var inst_61255 = (new cljs.core.PersistentVector(null,3,(5),inst_61253,inst_61254,null));
var inst_61256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61257 = ["?auth","_auth/id","?id"];
var inst_61258 = (new cljs.core.PersistentVector(null,3,(5),inst_61256,inst_61257,null));
var inst_61259 = [inst_61255,inst_61258];
var inst_61260 = (new cljs.core.PersistentVector(null,2,(5),inst_61252,inst_61259,null));
var inst_61261 = [inst_61251,inst_61260];
var inst_61262 = cljs.core.PersistentHashMap.fromArrays(inst_61248,inst_61261);
var inst_61263 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_61245,inst_61262) : fluree.db.api.query.query_async.call(null,inst_61245,inst_61262));
var state_61278__$1 = (function (){var statearr_61435 = state_61278;
(statearr_61435[(17)] = inst_61247);

(statearr_61435[(18)] = inst_61232);

return statearr_61435;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61278__$1,(14),inst_61263);
} else {
if((state_val_61279 === (9))){
var state_61278__$1 = state_61278;
var statearr_61436_61519 = state_61278__$1;
(statearr_61436_61519[(2)] = show_auth);

(statearr_61436_61519[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (5))){
var inst_61206 = (state_61278[(7)]);
var state_61278__$1 = state_61278;
var statearr_61437_61520 = state_61278__$1;
(statearr_61437_61520[(2)] = inst_61206);

(statearr_61437_61520[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (14))){
var inst_61223 = (state_61278[(11)]);
var inst_61232 = (state_61278[(18)]);
var inst_61265 = (state_61278[(2)]);
var inst_61266 = fluree.db.util.async.throw_err(inst_61265);
var inst_61267 = cljs.core.assoc_in(inst_61223,inst_61232,inst_61266);
var state_61278__$1 = state_61278;
var statearr_61438_61521 = state_61278__$1;
(statearr_61438_61521[(2)] = inst_61267);

(statearr_61438_61521[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (10))){
var inst_61228 = (state_61278[(2)]);
var state_61278__$1 = state_61278;
if(cljs.core.truth_(inst_61228)){
var statearr_61439_61522 = state_61278__$1;
(statearr_61439_61522[(1)] = (11));

} else {
var statearr_61440_61523 = state_61278__$1;
(statearr_61440_61523[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61279 === (8))){
var inst_61224 = (state_61278[(10)]);
var state_61278__$1 = state_61278;
var statearr_61441_61524 = state_61278__$1;
(statearr_61441_61524[(2)] = inst_61224);

(statearr_61441_61524[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_61442 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61442[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_61442[(1)] = (1));

return statearr_61442;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_61278){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61278);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61443){var ex__2730__auto__ = e61443;
var statearr_61444_61525 = state_61278;
(statearr_61444_61525[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61278[(4)]))){
var statearr_61445_61526 = state_61278;
(statearr_61445_61526[(1)] = cljs.core.first((state_61278[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61527 = state_61278;
state_61278 = G__61527;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_61278){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_61278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61446 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61446[(6)] = c__2749__auto____$1);

return statearr_61446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_61282 = cljs.core.async.impl.dispatch.run(inst_61281);
var state_61378__$1 = (function (){var statearr_61447 = state_61378;
(statearr_61447[(20)] = inst_61282);

return statearr_61447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61378__$1,(6),inst_61280);
} else {
if((state_val_61379 === (23))){
var inst_61336 = (state_61378[(2)]);
var state_61378__$1 = (function (){var statearr_61448 = state_61378;
(statearr_61448[(13)] = inst_61336);

return statearr_61448;
})();
var statearr_61449_61528 = state_61378__$1;
(statearr_61449_61528[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (35))){
var inst_61366 = (state_61378[(2)]);
var state_61378__$1 = state_61378;
var statearr_61451_61529 = state_61378__$1;
(statearr_61451_61529[(2)] = inst_61366);

(statearr_61451_61529[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (19))){
var state_61378__$1 = state_61378;
var statearr_61452_61530 = state_61378__$1;
(statearr_61452_61530[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (11))){
var inst_61317 = (state_61378[(2)]);
var state_61378__$1 = state_61378;
if(cljs.core.truth_(inst_61317)){
var statearr_61455_61531 = state_61378__$1;
(statearr_61455_61531[(1)] = (15));

} else {
var statearr_61456_61532 = state_61378__$1;
(statearr_61456_61532[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (9))){
var inst_61308 = (state_61378[(16)]);
var inst_61308__$1 = auth;
var state_61378__$1 = (function (){var statearr_61457 = state_61378;
(statearr_61457[(16)] = inst_61308__$1);

return statearr_61457;
})();
if(cljs.core.truth_(inst_61308__$1)){
var statearr_61458_61533 = state_61378__$1;
(statearr_61458_61533[(1)] = (12));

} else {
var statearr_61459_61534 = state_61378__$1;
(statearr_61459_61534[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (5))){
var _ = (function (){var statearr_61460 = state_61378;
(statearr_61460[(4)] = cljs.core.rest((state_61378[(4)])));

return statearr_61460;
})();
var state_61378__$1 = state_61378;
var ex61454 = (state_61378__$1[(2)]);
var statearr_61461_61535 = state_61378__$1;
(statearr_61461_61535[(5)] = ex61454);


if((ex61454 instanceof Error)){
var statearr_61462_61536 = state_61378__$1;
(statearr_61462_61536[(1)] = (4));

(statearr_61462_61536[(5)] = null);

} else {
throw ex61454;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (14))){
var inst_61314 = (state_61378[(2)]);
var state_61378__$1 = state_61378;
var statearr_61463_61537 = state_61378__$1;
(statearr_61463_61537[(2)] = inst_61314);

(statearr_61463_61537[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (26))){
var inst_61344 = (state_61378[(2)]);
var state_61378__$1 = (function (){var statearr_61464 = state_61378;
(statearr_61464[(11)] = inst_61344);

return statearr_61464;
})();
var statearr_61465_61538 = state_61378__$1;
(statearr_61465_61538[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (16))){
var inst_61305 = (state_61378[(8)]);
var state_61378__$1 = state_61378;
if(cljs.core.truth_(inst_61305)){
var statearr_61467_61539 = state_61378__$1;
(statearr_61467_61539[(1)] = (18));

} else {
var statearr_61468_61540 = state_61378__$1;
(statearr_61468_61540[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (30))){
var inst_61352 = (state_61378[(15)]);
var inst_61327 = (state_61378[(21)]);
var inst_61326 = (state_61378[(12)]);
var inst_61354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61355 = [inst_61326,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61356 = (new cljs.core.PersistentVector(null,2,(5),inst_61354,inst_61355,null));
var inst_61357 = cljs.core.assoc_in(inst_61352,inst_61356,inst_61327);
var state_61378__$1 = state_61378;
var statearr_61469_61541 = state_61378__$1;
(statearr_61469_61541[(2)] = inst_61357);

(statearr_61469_61541[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (10))){
var inst_61305 = (state_61378[(8)]);
var state_61378__$1 = state_61378;
var statearr_61470_61542 = state_61378__$1;
(statearr_61470_61542[(2)] = inst_61305);

(statearr_61470_61542[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (18))){
var inst_61323 = (state_61378[(10)]);
var inst_61305 = (state_61378[(8)]);
var inst_61285 = (state_61378[(19)]);
var inst_61323__$1 = inst_61305.t;
var inst_61324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61285,inst_61323__$1);
var inst_61325 = cljs.core.__destructure_map(inst_61324);
var inst_61326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61325,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61325,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61378__$1 = (function (){var statearr_61471 = state_61378;
(statearr_61471[(10)] = inst_61323__$1);

(statearr_61471[(21)] = inst_61327);

(statearr_61471[(12)] = inst_61326);

return statearr_61471;
})();
var statearr_61472_61543 = state_61378__$1;
(statearr_61472_61543[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61379 === (8))){
var inst_61372 = (state_61378[(2)]);
var inst_61373 = cljs.core.vals(inst_61372);
var _ = (function (){var statearr_61474 = state_61378;
(statearr_61474[(4)] = cljs.core.rest((state_61378[(4)])));

return statearr_61474;
})();
var state_61378__$1 = state_61378;
var statearr_61475_61544 = state_61378__$1;
(statearr_61475_61544[(2)] = inst_61373);

(statearr_61475_61544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_61476 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61476[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_61476[(1)] = (1));

return statearr_61476;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_61378){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61378);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61477){var ex__2730__auto__ = e61477;
var statearr_61478_61545 = state_61378;
(statearr_61478_61545[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61378[(4)]))){
var statearr_61479_61546 = state_61378;
(statearr_61479_61546[(1)] = cljs.core.first((state_61378[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61547 = state_61378;
state_61378 = G__61547;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_61378){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_61378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61480 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61480[(6)] = c__2749__auto__);

return statearr_61480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61674){
var state_val_61675 = (state_61674[(1)]);
if((state_val_61675 === (7))){
var inst_61570 = (state_61674[(7)]);
var inst_61572 = fluree.db.api.query.resolve_block_range(inst_61570,query_map);
var state_61674__$1 = state_61674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61674__$1,(10),inst_61572);
} else {
if((state_val_61675 === (20))){
var inst_61599 = (state_61674[(2)]);
var inst_61600 = fluree.db.util.async.throw_err(inst_61599);
var inst_61601 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61600);
var inst_61602 = (inst_61601 - (1));
var state_61674__$1 = state_61674;
var statearr_61676_61739 = state_61674__$1;
(statearr_61676_61739[(2)] = inst_61602);

(statearr_61676_61739[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (27))){
var state_61674__$1 = state_61674;
var statearr_61677_61740 = state_61674__$1;
(statearr_61677_61740[(2)] = null);

(statearr_61677_61740[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (1))){
var state_61674__$1 = state_61674;
var statearr_61678_61741 = state_61674__$1;
(statearr_61678_61741[(2)] = null);

(statearr_61678_61741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (24))){
var inst_61609 = (state_61674[(2)]);
var inst_61610 = fluree.db.util.async.throw_err(inst_61609);
var inst_61611 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61610);
var state_61674__$1 = state_61674;
var statearr_61679_61742 = state_61674__$1;
(statearr_61679_61742[(2)] = inst_61611);

(statearr_61679_61742[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (39))){
var inst_61646 = (state_61674[(2)]);
var inst_61647 = fluree.db.util.async.throw_err(inst_61646);
var state_61674__$1 = state_61674;
var statearr_61680_61743 = state_61674__$1;
(statearr_61680_61743[(2)] = inst_61647);

(statearr_61680_61743[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (4))){
var inst_61548 = (state_61674[(2)]);
var state_61674__$1 = state_61674;
var statearr_61681_61744 = state_61674__$1;
(statearr_61681_61744[(2)] = inst_61548);

(statearr_61681_61744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (15))){
var inst_61579 = (state_61674[(8)]);
var state_61674__$1 = state_61674;
var statearr_61682_61745 = state_61674__$1;
(statearr_61682_61745[(2)] = inst_61579);

(statearr_61682_61745[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (21))){
var inst_61580 = (state_61674[(9)]);
var inst_61570 = (state_61674[(7)]);
var inst_61607 = fluree.db.time_travel.as_of_block(inst_61570,inst_61580);
var state_61674__$1 = state_61674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61674__$1,(24),inst_61607);
} else {
if((state_val_61675 === (31))){
var inst_61564 = (state_61674[(10)]);
var state_61674__$1 = state_61674;
var statearr_61683_61746 = state_61674__$1;
(statearr_61683_61746[(2)] = inst_61564);

(statearr_61683_61746[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (32))){
var inst_61625 = (state_61674[(11)]);
var inst_61570 = (state_61674[(7)]);
var inst_61630 = (state_61674[(12)]);
var inst_61634 = (state_61674[(2)]);
var inst_61635 = fluree.db.api.query.format_history_resp(inst_61570,inst_61625,inst_61630,inst_61634);
var state_61674__$1 = state_61674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61674__$1,(29),inst_61635);
} else {
if((state_val_61675 === (40))){
var inst_61625 = (state_61674[(11)]);
var inst_61651 = (state_61674[(13)]);
var inst_61653 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61654 = cljs.core.count(inst_61625);
var inst_61655 = [inst_61651,inst_61654,(200)];
var inst_61656 = cljs.core.PersistentHashMap.fromArrays(inst_61653,inst_61655);
var state_61674__$1 = state_61674;
var statearr_61684_61747 = state_61674__$1;
(statearr_61684_61747[(2)] = inst_61656);

(statearr_61684_61747[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (33))){
var inst_61563 = (state_61674[(14)]);
var state_61674__$1 = state_61674;
var statearr_61685_61748 = state_61674__$1;
(statearr_61685_61748[(2)] = inst_61563);

(statearr_61685_61748[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (13))){
var inst_61669 = (state_61674[(2)]);
var _ = (function (){var statearr_61686 = state_61674;
(statearr_61686[(4)] = cljs.core.rest((state_61674[(4)])));

return statearr_61686;
})();
var state_61674__$1 = state_61674;
var statearr_61687_61749 = state_61674__$1;
(statearr_61687_61749[(2)] = inst_61669);

(statearr_61687_61749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (22))){
var inst_61570 = (state_61674[(7)]);
var inst_61613 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61570);
var state_61674__$1 = state_61674;
var statearr_61688_61750 = state_61674__$1;
(statearr_61688_61750[(2)] = inst_61613);

(statearr_61688_61750[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (36))){
var inst_61638 = (state_61674[(15)]);
var inst_61570 = (state_61674[(7)]);
var inst_61644 = fluree.db.api.query.format_blocks_resp_pretty(inst_61570,inst_61638);
var state_61674__$1 = state_61674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61674__$1,(39),inst_61644);
} else {
if((state_val_61675 === (41))){
var inst_61651 = (state_61674[(13)]);
var state_61674__$1 = state_61674;
var statearr_61689_61751 = state_61674__$1;
(statearr_61689_61751[(2)] = inst_61651);

(statearr_61689_61751[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (29))){
var inst_61563 = (state_61674[(14)]);
var inst_61637 = (state_61674[(2)]);
var inst_61638 = fluree.db.util.async.throw_err(inst_61637);
var state_61674__$1 = (function (){var statearr_61690 = state_61674;
(statearr_61690[(15)] = inst_61638);

return statearr_61690;
})();
if(cljs.core.truth_(inst_61563)){
var statearr_61691_61752 = state_61674__$1;
(statearr_61691_61752[(1)] = (33));

} else {
var statearr_61692_61753 = state_61674__$1;
(statearr_61692_61753[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (6))){
var inst_61560 = (state_61674[(16)]);
var inst_61569 = (state_61674[(2)]);
var inst_61570 = fluree.db.util.async.throw_err(inst_61569);
var state_61674__$1 = (function (){var statearr_61693 = state_61674;
(statearr_61693[(7)] = inst_61570);

return statearr_61693;
})();
if(cljs.core.truth_(inst_61560)){
var statearr_61694_61754 = state_61674__$1;
(statearr_61694_61754[(1)] = (7));

} else {
var statearr_61695_61755 = state_61674__$1;
(statearr_61695_61755[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (28))){
var inst_61565 = (state_61674[(17)]);
var inst_61630 = (state_61674[(2)]);
var state_61674__$1 = (function (){var statearr_61696 = state_61674;
(statearr_61696[(12)] = inst_61630);

return statearr_61696;
})();
if(cljs.core.truth_(inst_61565)){
var statearr_61697_61756 = state_61674__$1;
(statearr_61697_61756[(1)] = (30));

} else {
var statearr_61698_61757 = state_61674__$1;
(statearr_61698_61757[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (25))){
var inst_61566 = (state_61674[(18)]);
var inst_61624 = (state_61674[(2)]);
var inst_61625 = fluree.db.util.async.throw_err(inst_61624);
var state_61674__$1 = (function (){var statearr_61699 = state_61674;
(statearr_61699[(11)] = inst_61625);

return statearr_61699;
})();
if(cljs.core.truth_(inst_61566)){
var statearr_61700_61758 = state_61674__$1;
(statearr_61700_61758[(1)] = (26));

} else {
var statearr_61701_61759 = state_61674__$1;
(statearr_61701_61759[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (34))){
var inst_61562 = (state_61674[(19)]);
var state_61674__$1 = state_61674;
var statearr_61702_61760 = state_61674__$1;
(statearr_61702_61760[(2)] = inst_61562);

(statearr_61702_61760[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (17))){
var inst_61570 = (state_61674[(7)]);
var inst_61579 = (state_61674[(8)]);
var inst_61596 = (inst_61579 - (1));
var inst_61597 = fluree.db.time_travel.as_of_block(inst_61570,inst_61596);
var state_61674__$1 = state_61674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61674__$1,(20),inst_61597);
} else {
if((state_val_61675 === (3))){
var inst_61672 = (state_61674[(2)]);
var state_61674__$1 = state_61674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61674__$1,inst_61672);
} else {
if((state_val_61675 === (12))){
var inst_61661 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_61662 = ["History query not properly formatted. Provided ",inst_61661].join('');
var inst_61663 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61664 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61665 = cljs.core.PersistentHashMap.fromArrays(inst_61663,inst_61664);
var inst_61666 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61662,inst_61665);
var inst_61667 = (function(){throw inst_61666})();
var state_61674__$1 = state_61674;
var statearr_61703_61761 = state_61674__$1;
(statearr_61703_61761[(2)] = inst_61667);

(statearr_61703_61761[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (2))){
var _ = (function (){var statearr_61704 = state_61674;
(statearr_61704[(4)] = cljs.core.cons((5),(state_61674[(4)])));

return statearr_61704;
})();
var inst_61558 = query_map;
var inst_61559 = cljs.core.__destructure_map(inst_61558);
var inst_61560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61561 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61563 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61566 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61559,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61674__$1 = (function (){var statearr_61705 = state_61674;
(statearr_61705[(20)] = inst_61561);

(statearr_61705[(16)] = inst_61560);

(statearr_61705[(21)] = inst_61567);

(statearr_61705[(18)] = inst_61566);

(statearr_61705[(14)] = inst_61563);

(statearr_61705[(17)] = inst_61565);

(statearr_61705[(10)] = inst_61564);

(statearr_61705[(19)] = inst_61562);

return statearr_61705;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61674__$1,(6),sources);
} else {
if((state_val_61675 === (23))){
var inst_61561 = (state_61674[(20)]);
var inst_61605 = (state_61674[(22)]);
var inst_61570 = (state_61674[(7)]);
var inst_61615 = (state_61674[(2)]);
var inst_61616 = fluree.db.api.query.get_history_pattern(inst_61561);
var inst_61617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61616,(0),null);
var inst_61618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61616,(1),null);
var inst_61619 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61620 = [inst_61605,inst_61615];
var inst_61621 = cljs.core.PersistentHashMap.fromArrays(inst_61619,inst_61620);
var inst_61622 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_61570,inst_61618,cljs.core._EQ_,inst_61617,inst_61621);
var state_61674__$1 = state_61674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61674__$1,(25),inst_61622);
} else {
if((state_val_61675 === (35))){
var inst_61642 = (state_61674[(2)]);
var state_61674__$1 = state_61674;
if(cljs.core.truth_(inst_61642)){
var statearr_61706_61762 = state_61674__$1;
(statearr_61706_61762[(1)] = (36));

} else {
var statearr_61707_61763 = state_61674__$1;
(statearr_61707_61763[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (19))){
var inst_61580 = (state_61674[(9)]);
var inst_61605 = (state_61674[(2)]);
var state_61674__$1 = (function (){var statearr_61708 = state_61674;
(statearr_61708[(22)] = inst_61605);

return statearr_61708;
})();
if(cljs.core.truth_(inst_61580)){
var statearr_61709_61764 = state_61674__$1;
(statearr_61709_61764[(1)] = (21));

} else {
var statearr_61710_61765 = state_61674__$1;
(statearr_61710_61765[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (11))){
var inst_61567 = (state_61674[(21)]);
var inst_61579 = (state_61674[(8)]);
var inst_61589 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61567);
var state_61674__$1 = (function (){var statearr_61712 = state_61674;
(statearr_61712[(23)] = inst_61589);

return statearr_61712;
})();
if(cljs.core.truth_(inst_61579)){
var statearr_61713_61766 = state_61674__$1;
(statearr_61713_61766[(1)] = (14));

} else {
var statearr_61714_61767 = state_61674__$1;
(statearr_61714_61767[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (9))){
var inst_61578 = (state_61674[(2)]);
var inst_61579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61578,(0),null);
var inst_61580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61578,(1),null);
var inst_61581 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61582 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_61583 = cljs.core.keys(inst_61582);
var inst_61584 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61581,inst_61583);
var state_61674__$1 = (function (){var statearr_61715 = state_61674;
(statearr_61715[(9)] = inst_61580);

(statearr_61715[(8)] = inst_61579);

return statearr_61715;
})();
if(inst_61584){
var statearr_61716_61768 = state_61674__$1;
(statearr_61716_61768[(1)] = (11));

} else {
var statearr_61717_61769 = state_61674__$1;
(statearr_61717_61769[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (5))){
var _ = (function (){var statearr_61718 = state_61674;
(statearr_61718[(4)] = cljs.core.rest((state_61674[(4)])));

return statearr_61718;
})();
var state_61674__$1 = state_61674;
var ex61711 = (state_61674__$1[(2)]);
var statearr_61719_61770 = state_61674__$1;
(statearr_61719_61770[(5)] = ex61711);


if((ex61711 instanceof Error)){
var statearr_61720_61771 = state_61674__$1;
(statearr_61720_61771[(1)] = (4));

(statearr_61720_61771[(5)] = null);

} else {
throw ex61711;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (14))){
var inst_61579 = (state_61674[(8)]);
var inst_61591 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_61579);
var state_61674__$1 = state_61674;
var statearr_61721_61772 = state_61674__$1;
(statearr_61721_61772[(2)] = inst_61591);

(statearr_61721_61772[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (26))){
var inst_61566 = (state_61674[(18)]);
var inst_61627 = cljs.core.set(inst_61566);
var state_61674__$1 = state_61674;
var statearr_61722_61773 = state_61674__$1;
(statearr_61722_61773[(2)] = inst_61627);

(statearr_61722_61773[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (16))){
var inst_61594 = (state_61674[(2)]);
var state_61674__$1 = state_61674;
if(cljs.core.truth_(inst_61594)){
var statearr_61723_61774 = state_61674__$1;
(statearr_61723_61774[(1)] = (17));

} else {
var statearr_61724_61775 = state_61674__$1;
(statearr_61724_61775[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (38))){
var inst_61589 = (state_61674[(23)]);
var inst_61651 = (state_61674[(2)]);
var state_61674__$1 = (function (){var statearr_61725 = state_61674;
(statearr_61725[(13)] = inst_61651);

return statearr_61725;
})();
if(cljs.core.truth_(inst_61589)){
var statearr_61726_61776 = state_61674__$1;
(statearr_61726_61776[(1)] = (40));

} else {
var statearr_61727_61777 = state_61674__$1;
(statearr_61727_61777[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (30))){
var inst_61565 = (state_61674[(17)]);
var state_61674__$1 = state_61674;
var statearr_61728_61778 = state_61674__$1;
(statearr_61728_61778[(2)] = inst_61565);

(statearr_61728_61778[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (10))){
var inst_61574 = (state_61674[(2)]);
var inst_61575 = fluree.db.util.async.throw_err(inst_61574);
var state_61674__$1 = state_61674;
var statearr_61729_61779 = state_61674__$1;
(statearr_61729_61779[(2)] = inst_61575);

(statearr_61729_61779[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (18))){
var state_61674__$1 = state_61674;
var statearr_61730_61780 = state_61674__$1;
(statearr_61730_61780[(2)] = (-1));

(statearr_61730_61780[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (42))){
var inst_61659 = (state_61674[(2)]);
var state_61674__$1 = state_61674;
var statearr_61731_61781 = state_61674__$1;
(statearr_61731_61781[(2)] = inst_61659);

(statearr_61731_61781[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (37))){
var inst_61638 = (state_61674[(15)]);
var inst_61649 = fluree.db.api.query.block_Flakes__GT_vector(inst_61638);
var state_61674__$1 = state_61674;
var statearr_61732_61782 = state_61674__$1;
(statearr_61732_61782[(2)] = inst_61649);

(statearr_61732_61782[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61675 === (8))){
var state_61674__$1 = state_61674;
var statearr_61733_61783 = state_61674__$1;
(statearr_61733_61783[(2)] = null);

(statearr_61733_61783[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_61734 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61734[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_61734[(1)] = (1));

return statearr_61734;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_61674){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61674);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61735){var ex__2730__auto__ = e61735;
var statearr_61736_61784 = state_61674;
(statearr_61736_61784[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61674[(4)]))){
var statearr_61737_61785 = state_61674;
(statearr_61737_61785[(1)] = cljs.core.first((state_61674[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61786 = state_61674;
state_61674 = G__61786;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_61674){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_61674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61738 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61738[(6)] = c__2749__auto__);

return statearr_61738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61919){
var state_val_61920 = (state_61919[(1)]);
if((state_val_61920 === (7))){
var inst_61816 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_61817 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61816].join('');
var inst_61818 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61819 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61820 = cljs.core.PersistentHashMap.fromArrays(inst_61818,inst_61819);
var inst_61821 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61817,inst_61820);
var inst_61822 = (function(){throw inst_61821})();
var state_61919__$1 = state_61919;
var statearr_61921_62000 = state_61919__$1;
(statearr_61921_62000[(2)] = inst_61822);

(statearr_61921_62000[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (20))){
var inst_61854 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
if(cljs.core.truth_(inst_61854)){
var statearr_61922_62001 = state_61919__$1;
(statearr_61922_62001[(1)] = (21));

} else {
var statearr_61923_62002 = state_61919__$1;
(statearr_61923_62002[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (27))){
var inst_61798 = (state_61919[(7)]);
var state_61919__$1 = state_61919;
var statearr_61924_62003 = state_61919__$1;
(statearr_61924_62003[(2)] = inst_61798);

(statearr_61924_62003[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (1))){
var state_61919__$1 = state_61919;
var statearr_61925_62004 = state_61919__$1;
(statearr_61925_62004[(2)] = null);

(statearr_61925_62004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (24))){
var inst_61860 = (state_61919[(8)]);
var state_61919__$1 = state_61919;
var statearr_61926_62005 = state_61919__$1;
(statearr_61926_62005[(2)] = inst_61860);

(statearr_61926_62005[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (39))){
var inst_61804 = (state_61919[(9)]);
var state_61919__$1 = state_61919;
if(cljs.core.truth_(inst_61804)){
var statearr_61927_62006 = state_61919__$1;
(statearr_61927_62006[(1)] = (42));

} else {
var statearr_61928_62007 = state_61919__$1;
(statearr_61928_62007[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (46))){
var inst_61892 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61893 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61894 = cljs.core.PersistentHashMap.fromArrays(inst_61892,inst_61893);
var inst_61895 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_61894);
var inst_61896 = (function(){throw inst_61895})();
var state_61919__$1 = state_61919;
var statearr_61929_62008 = state_61919__$1;
(statearr_61929_62008[(2)] = inst_61896);

(statearr_61929_62008[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (4))){
var inst_61788 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
var statearr_61930_62009 = state_61919__$1;
(statearr_61930_62009[(2)] = inst_61788);

(statearr_61930_62009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (15))){
var inst_61839 = (state_61919[(10)]);
var inst_61801 = (state_61919[(11)]);
var inst_61841 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61839);
var inst_61842 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61839);
var inst_61843 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61839);
var inst_61844 = fluree.db.api.query.get_sources(inst_61841,inst_61842,inst_61843,inst_61801);
var state_61919__$1 = state_61919;
var statearr_61931_62010 = state_61919__$1;
(statearr_61931_62010[(2)] = inst_61844);

(statearr_61931_62010[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (48))){
var inst_61849 = (state_61919[(12)]);
var inst_61903 = (state_61919[(2)]);
var inst_61904 = fluree.db.util.async.throw_err(inst_61903);
var state_61919__$1 = (function (){var statearr_61932 = state_61919;
(statearr_61932[(13)] = inst_61904);

return statearr_61932;
})();
if(cljs.core.truth_(inst_61849)){
var statearr_61933_62011 = state_61919__$1;
(statearr_61933_62011[(1)] = (49));

} else {
var statearr_61934_62012 = state_61919__$1;
(statearr_61934_62012[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (50))){
var inst_61904 = (state_61919[(13)]);
var state_61919__$1 = state_61919;
var statearr_61935_62013 = state_61919__$1;
(statearr_61935_62013[(2)] = inst_61904);

(statearr_61935_62013[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (21))){
var inst_61856 = cljs.core.volatile_BANG_((0));
var state_61919__$1 = state_61919;
var statearr_61936_62014 = state_61919__$1;
(statearr_61936_62014[(2)] = inst_61856);

(statearr_61936_62014[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (31))){
var inst_61802 = (state_61919[(14)]);
var state_61919__$1 = state_61919;
if(cljs.core.truth_(inst_61802)){
var statearr_61937_62015 = state_61919__$1;
(statearr_61937_62015[(1)] = (33));

} else {
var statearr_61938_62016 = state_61919__$1;
(statearr_61938_62016[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (32))){
var inst_61879 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
var statearr_61939_62017 = state_61919__$1;
(statearr_61939_62017[(2)] = inst_61879);

(statearr_61939_62017[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (40))){
var inst_61881 = (state_61919[(15)]);
var state_61919__$1 = state_61919;
var statearr_61940_62018 = state_61919__$1;
(statearr_61940_62018[(2)] = inst_61881);

(statearr_61940_62018[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (33))){
var inst_61802 = (state_61919[(14)]);
var state_61919__$1 = state_61919;
var statearr_61941_62019 = state_61919__$1;
(statearr_61941_62019[(2)] = inst_61802);

(statearr_61941_62019[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (13))){
var inst_61799 = (state_61919[(16)]);
var inst_61828 = (state_61919[(2)]);
var inst_61829 = fluree.db.util.async.throw_err(inst_61828);
var inst_61830 = fluree.db.time_travel.as_of_block(inst_61829,inst_61799);
var state_61919__$1 = state_61919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61919__$1,(12),inst_61830);
} else {
if((state_val_61920 === (22))){
var state_61919__$1 = state_61919;
var statearr_61942_62020 = state_61919__$1;
(statearr_61942_62020[(2)] = null);

(statearr_61942_62020[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (36))){
var inst_61806 = (state_61919[(17)]);
var state_61919__$1 = state_61919;
var statearr_61943_62021 = state_61919__$1;
(statearr_61943_62021[(2)] = inst_61806);

(statearr_61943_62021[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (41))){
var inst_61889 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
if(cljs.core.truth_(inst_61889)){
var statearr_61944_62022 = state_61919__$1;
(statearr_61944_62022[(1)] = (45));

} else {
var statearr_61945_62023 = state_61919__$1;
(statearr_61945_62023[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (43))){
var inst_61800 = (state_61919[(18)]);
var state_61919__$1 = state_61919;
var statearr_61946_62024 = state_61919__$1;
(statearr_61946_62024[(2)] = inst_61800);

(statearr_61946_62024[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (29))){
var inst_61881 = (state_61919[(15)]);
var inst_61881__$1 = (state_61919[(2)]);
var state_61919__$1 = (function (){var statearr_61947 = state_61919;
(statearr_61947[(15)] = inst_61881__$1);

return statearr_61947;
})();
if(cljs.core.truth_(inst_61881__$1)){
var statearr_61948_62025 = state_61919__$1;
(statearr_61948_62025[(1)] = (39));

} else {
var statearr_61949_62026 = state_61919__$1;
(statearr_61949_62026[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (44))){
var inst_61886 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
var statearr_61950_62027 = state_61919__$1;
(statearr_61950_62027[(2)] = inst_61886);

(statearr_61950_62027[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (6))){
var state_61919__$1 = state_61919;
var statearr_61951_62028 = state_61919__$1;
(statearr_61951_62028[(2)] = null);

(statearr_61951_62028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (28))){
var inst_61803 = (state_61919[(19)]);
var state_61919__$1 = state_61919;
if(cljs.core.truth_(inst_61803)){
var statearr_61952_62029 = state_61919__$1;
(statearr_61952_62029[(1)] = (30));

} else {
var statearr_61953_62030 = state_61919__$1;
(statearr_61953_62030[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (51))){
var inst_61914 = (state_61919[(2)]);
var _ = (function (){var statearr_61954 = state_61919;
(statearr_61954[(4)] = cljs.core.rest((state_61919[(4)])));

return statearr_61954;
})();
var state_61919__$1 = state_61919;
var statearr_61955_62031 = state_61919__$1;
(statearr_61955_62031[(2)] = inst_61914);

(statearr_61955_62031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (25))){
var state_61919__$1 = state_61919;
var statearr_61956_62032 = state_61919__$1;
(statearr_61956_62032[(2)] = (1000000));

(statearr_61956_62032[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (34))){
var inst_61806 = (state_61919[(17)]);
var state_61919__$1 = state_61919;
if(cljs.core.truth_(inst_61806)){
var statearr_61957_62033 = state_61919__$1;
(statearr_61957_62033[(1)] = (36));

} else {
var statearr_61958_62034 = state_61919__$1;
(statearr_61958_62034[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (17))){
var inst_61850 = (state_61919[(20)]);
var inst_61805 = (state_61919[(21)]);
var inst_61848 = (state_61919[(2)]);
var inst_61849 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61805);
var inst_61850__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61805);
var state_61919__$1 = (function (){var statearr_61959 = state_61919;
(statearr_61959[(20)] = inst_61850__$1);

(statearr_61959[(12)] = inst_61849);

(statearr_61959[(22)] = inst_61848);

return statearr_61959;
})();
if(cljs.core.truth_(inst_61850__$1)){
var statearr_61960_62035 = state_61919__$1;
(statearr_61960_62035[(1)] = (18));

} else {
var statearr_61961_62036 = state_61919__$1;
(statearr_61961_62036[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (3))){
var inst_61917 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61919__$1,inst_61917);
} else {
if((state_val_61920 === (12))){
var inst_61832 = (state_61919[(2)]);
var inst_61833 = fluree.db.util.async.throw_err(inst_61832);
var state_61919__$1 = state_61919;
var statearr_61962_62037 = state_61919__$1;
(statearr_61962_62037[(2)] = inst_61833);

(statearr_61962_62037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (2))){
var inst_61799 = (state_61919[(16)]);
var inst_61806 = (state_61919[(17)]);
var inst_61800 = (state_61919[(18)]);
var inst_61798 = (state_61919[(7)]);
var inst_61797 = (state_61919[(23)]);
var inst_61803 = (state_61919[(19)]);
var inst_61805 = (state_61919[(21)]);
var inst_61802 = (state_61919[(14)]);
var inst_61804 = (state_61919[(9)]);
var inst_61801 = (state_61919[(11)]);
var _ = (function (){var statearr_61963 = state_61919;
(statearr_61963[(4)] = cljs.core.cons((5),(state_61919[(4)])));

return statearr_61963;
})();
var inst_61795 = flureeQL;
var inst_61796 = cljs.core.__destructure_map(inst_61795);
var inst_61797__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61798__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61799__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61800__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61801__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61802__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61803__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61804__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61805__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61806__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61796,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61807 = (function (){var construct = inst_61797__$1;
var select = inst_61798__$1;
var block = inst_61799__$1;
var where = inst_61800__$1;
var prefixes = inst_61801__$1;
var map__61794 = inst_61796;
var selectDistinct = inst_61802__$1;
var selectOne = inst_61803__$1;
var from = inst_61804__$1;
var opts = inst_61805__$1;
var selectReduced = inst_61806__$1;
return (function (p1__61787_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__61787_SHARP_);
});
})();
var inst_61808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61809 = [inst_61798__$1,inst_61803__$1,inst_61802__$1,inst_61806__$1];
var inst_61810 = (new cljs.core.PersistentVector(null,4,(5),inst_61808,inst_61809,null));
var inst_61811 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_61810);
var inst_61812 = cljs.core.count(inst_61811);
var inst_61813 = (inst_61807.cljs$core$IFn$_invoke$arity$1 ? inst_61807.cljs$core$IFn$_invoke$arity$1(inst_61812) : inst_61807.call(null,inst_61812));
var state_61919__$1 = (function (){var statearr_61964 = state_61919;
(statearr_61964[(16)] = inst_61799__$1);

(statearr_61964[(17)] = inst_61806__$1);

(statearr_61964[(18)] = inst_61800__$1);

(statearr_61964[(7)] = inst_61798__$1);

(statearr_61964[(23)] = inst_61797__$1);

(statearr_61964[(19)] = inst_61803__$1);

(statearr_61964[(21)] = inst_61805__$1);

(statearr_61964[(14)] = inst_61802__$1);

(statearr_61964[(9)] = inst_61804__$1);

(statearr_61964[(11)] = inst_61801__$1);

return statearr_61964;
})();
if(cljs.core.truth_(inst_61813)){
var statearr_61965_62038 = state_61919__$1;
(statearr_61965_62038[(1)] = (6));

} else {
var statearr_61966_62039 = state_61919__$1;
(statearr_61966_62039[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (23))){
var inst_61860 = (state_61919[(8)]);
var inst_61805 = (state_61919[(21)]);
var inst_61859 = (state_61919[(2)]);
var inst_61860__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61805);
var state_61919__$1 = (function (){var statearr_61967 = state_61919;
(statearr_61967[(24)] = inst_61859);

(statearr_61967[(8)] = inst_61860__$1);

return statearr_61967;
})();
if(cljs.core.truth_(inst_61860__$1)){
var statearr_61968_62040 = state_61919__$1;
(statearr_61968_62040[(1)] = (24));

} else {
var statearr_61969_62041 = state_61919__$1;
(statearr_61969_62041[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (47))){
var inst_61839 = (state_61919[(10)]);
var inst_61865 = (state_61919[(25)]);
var inst_61898 = (state_61919[(2)]);
var inst_61899 = fluree.db.util.core.current_time_millis();
var inst_61900 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61865);
var inst_61901 = fluree.db.query.fql.query(inst_61839,inst_61900);
var state_61919__$1 = (function (){var statearr_61970 = state_61919;
(statearr_61970[(26)] = inst_61899);

(statearr_61970[(27)] = inst_61898);

return statearr_61970;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61919__$1,(48),inst_61901);
} else {
if((state_val_61920 === (35))){
var inst_61877 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
var statearr_61971_62042 = state_61919__$1;
(statearr_61971_62042[(2)] = inst_61877);

(statearr_61971_62042[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (19))){
var inst_61849 = (state_61919[(12)]);
var state_61919__$1 = state_61919;
var statearr_61972_62043 = state_61919__$1;
(statearr_61972_62043[(2)] = inst_61849);

(statearr_61972_62043[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (11))){
var inst_61801 = (state_61919[(11)]);
var inst_61839 = (state_61919[(2)]);
var state_61919__$1 = (function (){var statearr_61974 = state_61919;
(statearr_61974[(10)] = inst_61839);

return statearr_61974;
})();
if(cljs.core.truth_(inst_61801)){
var statearr_61975_62044 = state_61919__$1;
(statearr_61975_62044[(1)] = (15));

} else {
var statearr_61976_62045 = state_61919__$1;
(statearr_61976_62045[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (9))){
var inst_61825 = (state_61919[(28)]);
var state_61919__$1 = state_61919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61919__$1,(13),inst_61825);
} else {
if((state_val_61920 === (5))){
var _ = (function (){var statearr_61977 = state_61919;
(statearr_61977[(4)] = cljs.core.rest((state_61919[(4)])));

return statearr_61977;
})();
var state_61919__$1 = state_61919;
var ex61973 = (state_61919__$1[(2)]);
var statearr_61978_62046 = state_61919__$1;
(statearr_61978_62046[(5)] = ex61973);


if((ex61973 instanceof Error)){
var statearr_61979_62047 = state_61919__$1;
(statearr_61979_62047[(1)] = (4));

(statearr_61979_62047[(5)] = null);

} else {
throw ex61973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (14))){
var inst_61836 = (state_61919[(2)]);
var inst_61837 = fluree.db.util.async.throw_err(inst_61836);
var state_61919__$1 = state_61919;
var statearr_61980_62048 = state_61919__$1;
(statearr_61980_62048[(2)] = inst_61837);

(statearr_61980_62048[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (45))){
var state_61919__$1 = state_61919;
var statearr_61981_62049 = state_61919__$1;
(statearr_61981_62049[(2)] = null);

(statearr_61981_62049[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (26))){
var inst_61859 = (state_61919[(24)]);
var inst_61798 = (state_61919[(7)]);
var inst_61805 = (state_61919[(21)]);
var inst_61848 = (state_61919[(22)]);
var inst_61864 = (state_61919[(2)]);
var inst_61865 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_61805,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61848,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61864,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61859], 0));
var state_61919__$1 = (function (){var statearr_61982 = state_61919;
(statearr_61982[(25)] = inst_61865);

return statearr_61982;
})();
if(cljs.core.truth_(inst_61798)){
var statearr_61983_62050 = state_61919__$1;
(statearr_61983_62050[(1)] = (27));

} else {
var statearr_61984_62051 = state_61919__$1;
(statearr_61984_62051[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (16))){
var inst_61846 = cljs.core.PersistentHashMap.EMPTY;
var state_61919__$1 = state_61919;
var statearr_61985_62052 = state_61919__$1;
(statearr_61985_62052[(2)] = inst_61846);

(statearr_61985_62052[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (38))){
var inst_61875 = (state_61919[(2)]);
var state_61919__$1 = state_61919;
var statearr_61986_62053 = state_61919__$1;
(statearr_61986_62053[(2)] = inst_61875);

(statearr_61986_62053[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (30))){
var inst_61803 = (state_61919[(19)]);
var state_61919__$1 = state_61919;
var statearr_61987_62054 = state_61919__$1;
(statearr_61987_62054[(2)] = inst_61803);

(statearr_61987_62054[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (10))){
var inst_61825 = (state_61919[(28)]);
var state_61919__$1 = state_61919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61919__$1,(14),inst_61825);
} else {
if((state_val_61920 === (18))){
var inst_61850 = (state_61919[(20)]);
var state_61919__$1 = state_61919;
var statearr_61988_62055 = state_61919__$1;
(statearr_61988_62055[(2)] = inst_61850);

(statearr_61988_62055[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (42))){
var inst_61804 = (state_61919[(9)]);
var state_61919__$1 = state_61919;
var statearr_61989_62056 = state_61919__$1;
(statearr_61989_62056[(2)] = inst_61804);

(statearr_61989_62056[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (37))){
var inst_61797 = (state_61919[(23)]);
var state_61919__$1 = state_61919;
var statearr_61990_62057 = state_61919__$1;
(statearr_61990_62057[(2)] = inst_61797);

(statearr_61990_62057[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (8))){
var inst_61799 = (state_61919[(16)]);
var inst_61824 = (state_61919[(2)]);
var inst_61825 = sources;
var state_61919__$1 = (function (){var statearr_61991 = state_61919;
(statearr_61991[(29)] = inst_61824);

(statearr_61991[(28)] = inst_61825);

return statearr_61991;
})();
if(cljs.core.truth_(inst_61799)){
var statearr_61992_62058 = state_61919__$1;
(statearr_61992_62058[(1)] = (9));

} else {
var statearr_61993_62059 = state_61919__$1;
(statearr_61993_62059[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61920 === (49))){
var inst_61904 = (state_61919[(13)]);
var inst_61839 = (state_61919[(10)]);
var inst_61859 = (state_61919[(24)]);
var inst_61899 = (state_61919[(26)]);
var inst_61906 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61907 = cljs.core.deref(inst_61859);
var inst_61908 = fluree.db.util.core.response_time_formatted(inst_61899);
var inst_61909 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61839);
var inst_61910 = [(200),inst_61904,inst_61907,inst_61908,inst_61909];
var inst_61911 = cljs.core.PersistentHashMap.fromArrays(inst_61906,inst_61910);
var state_61919__$1 = state_61919;
var statearr_61994_62060 = state_61919__$1;
(statearr_61994_62060[(2)] = inst_61911);

(statearr_61994_62060[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_61995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61995[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_61995[(1)] = (1));

return statearr_61995;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_61919){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61919);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61996){var ex__2730__auto__ = e61996;
var statearr_61997_62061 = state_61919;
(statearr_61997_62061[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61919[(4)]))){
var statearr_61998_62062 = state_61919;
(statearr_61998_62062[(1)] = cljs.core.first((state_61919[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62063 = state_61919;
state_61919 = G__62063;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_61919){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_61919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61999 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61999[(6)] = c__2749__auto__);

return statearr_61999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62204){
var state_val_62205 = (state_62204[(1)]);
if((state_val_62205 === (7))){
var inst_62199 = (state_62204[(2)]);
var _ = (function (){var statearr_62206 = state_62204;
(statearr_62206[(4)] = cljs.core.rest((state_62204[(4)])));

return statearr_62206;
})();
var state_62204__$1 = state_62204;
var statearr_62207_62283 = state_62204__$1;
(statearr_62207_62283[(2)] = inst_62199);

(statearr_62207_62283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (20))){
var inst_62171 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62208_62284 = state_62204__$1;
(statearr_62208_62284[(2)] = inst_62171);

(statearr_62208_62284[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (27))){
var inst_62151 = (state_62204[(7)]);
var state_62204__$1 = state_62204;
var statearr_62209_62285 = state_62204__$1;
(statearr_62209_62285[(2)] = inst_62151);

(statearr_62209_62285[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (1))){
var state_62204__$1 = state_62204;
var statearr_62210_62286 = state_62204__$1;
(statearr_62210_62286[(2)] = null);

(statearr_62210_62286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (24))){
var inst_62148 = (state_62204[(8)]);
var state_62204__$1 = state_62204;
var statearr_62211_62287 = state_62204__$1;
(statearr_62211_62287[(2)] = inst_62148);

(statearr_62211_62287[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (39))){
var inst_62105 = (state_62204[(9)]);
var inst_62138 = (state_62204[(10)]);
var inst_62116 = (state_62204[(11)]);
var inst_62182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62183 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_62116];
var inst_62184 = (new cljs.core.PersistentVector(null,2,(5),inst_62182,inst_62183,null));
var inst_62185 = cljs.core.assoc_in(inst_62105,inst_62184,inst_62138);
var state_62204__$1 = state_62204;
var statearr_62212_62288 = state_62204__$1;
(statearr_62212_62288[(2)] = inst_62185);

(statearr_62212_62288[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (4))){
var inst_62064 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62213_62289 = state_62204__$1;
(statearr_62213_62289[(2)] = inst_62064);

(statearr_62213_62289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (15))){
var inst_62103 = (state_62204[(12)]);
var inst_62138 = (state_62204[(10)]);
var inst_62141 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62138);
var inst_62142 = (inst_62103 == null);
var state_62204__$1 = (function (){var statearr_62214 = state_62204;
(statearr_62214[(13)] = inst_62141);

return statearr_62214;
})();
if(cljs.core.truth_(inst_62142)){
var statearr_62215_62290 = state_62204__$1;
(statearr_62215_62290[(1)] = (18));

} else {
var statearr_62216_62291 = state_62204__$1;
(statearr_62216_62291[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (21))){
var inst_62141 = (state_62204[(13)]);
var state_62204__$1 = state_62204;
var statearr_62217_62292 = state_62204__$1;
(statearr_62217_62292[(2)] = inst_62141);

(statearr_62217_62292[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (31))){
var state_62204__$1 = state_62204;
var statearr_62218_62293 = state_62204__$1;
(statearr_62218_62293[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (32))){
var inst_62167 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62220_62294 = state_62204__$1;
(statearr_62220_62294[(2)] = inst_62167);

(statearr_62220_62294[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (40))){
var inst_62136 = (state_62204[(14)]);
var state_62204__$1 = state_62204;
if(cljs.core.truth_(inst_62136)){
var statearr_62221_62295 = state_62204__$1;
(statearr_62221_62295[(1)] = (42));

} else {
var statearr_62222_62296 = state_62204__$1;
(statearr_62222_62296[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (33))){
var inst_62141 = (state_62204[(13)]);
var inst_62103 = (state_62204[(12)]);
var inst_62162 = ((inst_62141 > inst_62103) ? inst_62141 : inst_62103);
var state_62204__$1 = state_62204;
var statearr_62223_62297 = state_62204__$1;
(statearr_62223_62297[(2)] = inst_62162);

(statearr_62223_62297[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (13))){
var inst_62127 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62224_62298 = state_62204__$1;
(statearr_62224_62298[(2)] = inst_62127);

(statearr_62224_62298[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (22))){
var inst_62141 = (state_62204[(13)]);
var inst_62148 = (state_62204[(8)]);
var inst_62148__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62141);
var state_62204__$1 = (function (){var statearr_62225 = state_62204;
(statearr_62225[(8)] = inst_62148__$1);

return statearr_62225;
})();
if(inst_62148__$1){
var statearr_62226_62299 = state_62204__$1;
(statearr_62226_62299[(1)] = (24));

} else {
var statearr_62227_62300 = state_62204__$1;
(statearr_62227_62300[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (36))){
var inst_62104 = (state_62204[(15)]);
var inst_62138 = (state_62204[(10)]);
var inst_62176 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62138,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_62177 = (inst_62104 + inst_62176);
var state_62204__$1 = state_62204;
var statearr_62228_62301 = state_62204__$1;
(statearr_62228_62301[(2)] = inst_62177);

(statearr_62228_62301[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (41))){
var inst_62174 = (state_62204[(16)]);
var inst_62115 = (state_62204[(17)]);
var inst_62180 = (state_62204[(18)]);
var inst_62194 = (state_62204[(2)]);
var inst_62102 = inst_62115;
var inst_62103 = inst_62174;
var inst_62104 = inst_62180;
var inst_62105 = inst_62194;
var state_62204__$1 = (function (){var statearr_62229 = state_62204;
(statearr_62229[(12)] = inst_62103);

(statearr_62229[(9)] = inst_62105);

(statearr_62229[(19)] = inst_62102);

(statearr_62229[(15)] = inst_62104);

return statearr_62229;
})();
var statearr_62230_62302 = state_62204__$1;
(statearr_62230_62302[(2)] = null);

(statearr_62230_62302[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (43))){
var inst_62138 = (state_62204[(10)]);
var state_62204__$1 = state_62204;
var statearr_62231_62303 = state_62204__$1;
(statearr_62231_62303[(2)] = inst_62138);

(statearr_62231_62303[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (29))){
var inst_62156 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62232_62304 = state_62204__$1;
(statearr_62232_62304[(2)] = inst_62156);

(statearr_62232_62304[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (44))){
var inst_62105 = (state_62204[(9)]);
var inst_62116 = (state_62204[(11)]);
var inst_62191 = (state_62204[(2)]);
var inst_62192 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62105,inst_62116,inst_62191);
var state_62204__$1 = state_62204;
var statearr_62233_62305 = state_62204__$1;
(statearr_62233_62305[(2)] = inst_62192);

(statearr_62233_62305[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (6))){
var inst_62102 = (state_62204[(19)]);
var inst_62117 = (state_62204[(20)]);
var inst_62113 = cljs.core.seq(inst_62102);
var inst_62114 = cljs.core.first(inst_62113);
var inst_62115 = cljs.core.next(inst_62113);
var inst_62116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62114,(0),null);
var inst_62117__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62114,(1),null);
var inst_62118 = (inst_62117__$1 == null);
var state_62204__$1 = (function (){var statearr_62234 = state_62204;
(statearr_62234[(17)] = inst_62115);

(statearr_62234[(11)] = inst_62116);

(statearr_62234[(20)] = inst_62117__$1);

return statearr_62234;
})();
if(cljs.core.truth_(inst_62118)){
var statearr_62235_62306 = state_62204__$1;
(statearr_62235_62306[(1)] = (8));

} else {
var statearr_62236_62307 = state_62204__$1;
(statearr_62236_62307[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (28))){
var inst_62103 = (state_62204[(12)]);
var inst_62154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_62103);
var state_62204__$1 = state_62204;
var statearr_62237_62308 = state_62204__$1;
(statearr_62237_62308[(2)] = inst_62154);

(statearr_62237_62308[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (25))){
var inst_62151 = (state_62204[(7)]);
var inst_62103 = (state_62204[(12)]);
var inst_62151__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62103);
var state_62204__$1 = (function (){var statearr_62238 = state_62204;
(statearr_62238[(7)] = inst_62151__$1);

return statearr_62238;
})();
if(inst_62151__$1){
var statearr_62239_62309 = state_62204__$1;
(statearr_62239_62309[(1)] = (27));

} else {
var statearr_62240_62310 = state_62204__$1;
(statearr_62240_62310[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (34))){
var state_62204__$1 = state_62204;
var statearr_62241_62311 = state_62204__$1;
(statearr_62241_62311[(2)] = null);

(statearr_62241_62311[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (17))){
var inst_62135 = (state_62204[(21)]);
var inst_62174 = (state_62204[(2)]);
var state_62204__$1 = (function (){var statearr_62242 = state_62204;
(statearr_62242[(16)] = inst_62174);

return statearr_62242;
})();
if(cljs.core.truth_(inst_62135)){
var statearr_62243_62312 = state_62204__$1;
(statearr_62243_62312[(1)] = (36));

} else {
var statearr_62244_62313 = state_62204__$1;
(statearr_62244_62313[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (3))){
var inst_62202 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62204__$1,inst_62202);
} else {
if((state_val_62205 === (12))){
var inst_62105 = (state_62204[(9)]);
var state_62204__$1 = state_62204;
var statearr_62245_62314 = state_62204__$1;
(statearr_62245_62314[(2)] = inst_62105);

(statearr_62245_62314[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (2))){
var inst_62079 = (state_62204[(22)]);
var inst_62078 = (state_62204[(23)]);
var inst_62074 = (state_62204[(24)]);
var _ = (function (){var statearr_62246 = state_62204;
(statearr_62246[(4)] = cljs.core.cons((5),(state_62204[(4)])));

return statearr_62246;
})();
var inst_62070 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_62071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62072 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_62073 = (new cljs.core.PersistentVector(null,2,(5),inst_62071,inst_62072,null));
var inst_62074__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_62073);
var inst_62075 = (function (){var global_block = inst_62070;
var global_meta_QMARK_ = inst_62074__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_62076 = cljs.core.PersistentHashMap.EMPTY;
var inst_62077 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_62078__$1 = cljs.core.reduce_kv(inst_62075,inst_62076,inst_62077);
var inst_62079__$1 = fluree.db.util.core.current_time_millis();
var inst_62081 = (function (){var global_block = inst_62070;
var global_meta_QMARK_ = inst_62074__$1;
var queries = inst_62078__$1;
var start_time = inst_62079__$1;
return (function (p__62080){
var vec__62247 = p__62080;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62247,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62247,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_62082 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_62081,inst_62078__$1);
var inst_62096 = cljs.core.seq(inst_62082);
var inst_62097 = cljs.core.first(inst_62096);
var inst_62098 = cljs.core.next(inst_62096);
var inst_62099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62097,(0),null);
var inst_62100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62097,(1),null);
var inst_62101 = cljs.core.PersistentHashMap.EMPTY;
var inst_62102 = inst_62082;
var inst_62103 = null;
var inst_62104 = (0);
var inst_62105 = inst_62101;
var state_62204__$1 = (function (){var statearr_62250 = state_62204;
(statearr_62250[(12)] = inst_62103);

(statearr_62250[(25)] = inst_62098);

(statearr_62250[(26)] = inst_62099);

(statearr_62250[(9)] = inst_62105);

(statearr_62250[(22)] = inst_62079__$1);

(statearr_62250[(27)] = inst_62100);

(statearr_62250[(23)] = inst_62078__$1);

(statearr_62250[(19)] = inst_62102);

(statearr_62250[(15)] = inst_62104);

(statearr_62250[(24)] = inst_62074__$1);

return statearr_62250;
})();
var statearr_62251_62315 = state_62204__$1;
(statearr_62251_62315[(2)] = null);

(statearr_62251_62315[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (23))){
var inst_62169 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62252_62316 = state_62204__$1;
(statearr_62252_62316[(2)] = inst_62169);

(statearr_62252_62316[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (35))){
var inst_62165 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62253_62317 = state_62204__$1;
(statearr_62253_62317[(2)] = inst_62165);

(statearr_62253_62317[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (19))){
var inst_62141 = (state_62204[(13)]);
var inst_62103 = (state_62204[(12)]);
var inst_62145 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62103,inst_62141);
var state_62204__$1 = state_62204;
if(inst_62145){
var statearr_62254_62318 = state_62204__$1;
(statearr_62254_62318[(1)] = (21));

} else {
var statearr_62255_62319 = state_62204__$1;
(statearr_62255_62319[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (11))){
var inst_62103 = (state_62204[(12)]);
var inst_62105 = (state_62204[(9)]);
var inst_62079 = (state_62204[(22)]);
var inst_62104 = (state_62204[(15)]);
var inst_62121 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_62122 = fluree.db.util.core.response_time_formatted(inst_62079);
var inst_62123 = [inst_62105,inst_62104,inst_62103,inst_62122];
var inst_62124 = cljs.core.PersistentHashMap.fromArrays(inst_62121,inst_62123);
var state_62204__$1 = state_62204;
var statearr_62257_62320 = state_62204__$1;
(statearr_62257_62320[(2)] = inst_62124);

(statearr_62257_62320[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (9))){
var inst_62078 = (state_62204[(23)]);
var inst_62116 = (state_62204[(11)]);
var inst_62117 = (state_62204[(20)]);
var inst_62130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62131 = [inst_62116,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_62132 = (new cljs.core.PersistentVector(null,2,(5),inst_62130,inst_62131,null));
var inst_62133 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62078,inst_62132);
var inst_62134 = cljs.core.__destructure_map(inst_62133);
var inst_62135 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62134,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_62136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62134,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_62204__$1 = (function (){var statearr_62258 = state_62204;
(statearr_62258[(14)] = inst_62136);

(statearr_62258[(21)] = inst_62135);

return statearr_62258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62204__$1,(14),inst_62117);
} else {
if((state_val_62205 === (5))){
var _ = (function (){var statearr_62259 = state_62204;
(statearr_62259[(4)] = cljs.core.rest((state_62204[(4)])));

return statearr_62259;
})();
var state_62204__$1 = state_62204;
var ex62256 = (state_62204__$1[(2)]);
var statearr_62260_62321 = state_62204__$1;
(statearr_62260_62321[(5)] = ex62256);


var statearr_62261_62322 = state_62204__$1;
(statearr_62261_62322[(1)] = (4));

(statearr_62261_62322[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (14))){
var inst_62135 = (state_62204[(21)]);
var inst_62138 = (state_62204[(10)]);
var inst_62138__$1 = (state_62204[(2)]);
var inst_62139 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_62138__$1);
var state_62204__$1 = (function (){var statearr_62262 = state_62204;
(statearr_62262[(28)] = inst_62139);

(statearr_62262[(10)] = inst_62138__$1);

return statearr_62262;
})();
if(cljs.core.truth_(inst_62135)){
var statearr_62263_62323 = state_62204__$1;
(statearr_62263_62323[(1)] = (15));

} else {
var statearr_62264_62324 = state_62204__$1;
(statearr_62264_62324[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (26))){
var inst_62158 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
if(cljs.core.truth_(inst_62158)){
var statearr_62265_62325 = state_62204__$1;
(statearr_62265_62325[(1)] = (30));

} else {
var statearr_62266_62326 = state_62204__$1;
(statearr_62266_62326[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (16))){
var state_62204__$1 = state_62204;
var statearr_62267_62327 = state_62204__$1;
(statearr_62267_62327[(2)] = null);

(statearr_62267_62327[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (38))){
var inst_62139 = (state_62204[(28)]);
var inst_62180 = (state_62204[(2)]);
var state_62204__$1 = (function (){var statearr_62268 = state_62204;
(statearr_62268[(18)] = inst_62180);

return statearr_62268;
})();
if(cljs.core.truth_(inst_62139)){
var statearr_62269_62328 = state_62204__$1;
(statearr_62269_62328[(1)] = (39));

} else {
var statearr_62270_62329 = state_62204__$1;
(statearr_62270_62329[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (30))){
var state_62204__$1 = state_62204;
var statearr_62271_62330 = state_62204__$1;
(statearr_62271_62330[(2)] = (207));

(statearr_62271_62330[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (10))){
var inst_62197 = (state_62204[(2)]);
var state_62204__$1 = state_62204;
var statearr_62272_62331 = state_62204__$1;
(statearr_62272_62331[(2)] = inst_62197);

(statearr_62272_62331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (18))){
var inst_62141 = (state_62204[(13)]);
var state_62204__$1 = state_62204;
var statearr_62273_62332 = state_62204__$1;
(statearr_62273_62332[(2)] = inst_62141);

(statearr_62273_62332[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (42))){
var inst_62138 = (state_62204[(10)]);
var inst_62188 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_62138);
var state_62204__$1 = state_62204;
var statearr_62274_62333 = state_62204__$1;
(statearr_62274_62333[(2)] = inst_62188);

(statearr_62274_62333[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (37))){
var state_62204__$1 = state_62204;
var statearr_62275_62334 = state_62204__$1;
(statearr_62275_62334[(2)] = null);

(statearr_62275_62334[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62205 === (8))){
var inst_62074 = (state_62204[(24)]);
var state_62204__$1 = state_62204;
if(cljs.core.truth_(inst_62074)){
var statearr_62276_62335 = state_62204__$1;
(statearr_62276_62335[(1)] = (11));

} else {
var statearr_62277_62336 = state_62204__$1;
(statearr_62277_62336[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_62278 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62278[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_62278[(1)] = (1));

return statearr_62278;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_62204){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62204);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62279){var ex__2730__auto__ = e62279;
var statearr_62280_62337 = state_62204;
(statearr_62280_62337[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62204[(4)]))){
var statearr_62281_62338 = state_62204;
(statearr_62281_62338[(1)] = cljs.core.first((state_62204[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62339 = state_62204;
state_62204 = G__62339;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_62204){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_62204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62282 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62282[(6)] = c__2749__auto__);

return statearr_62282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__62340 = query_type;
var G__62340__$1 = (((G__62340 instanceof cljs.core.Keyword))?G__62340.fqn:null);
switch (G__62340__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62340__$1)].join('')));

}
});
