// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62387_62556 = cljs.core.seq(servers);
var chunk__62388_62557 = null;
var count__62389_62558 = (0);
var i__62390_62559 = (0);
while(true){
if((i__62390_62559 < count__62389_62558)){
var server_62560 = chunk__62388_62557.cljs$core$IIndexed$_nth$arity$2(null,i__62390_62559);
var healthcheck_uri_62561 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62560),"/fdb/health"].join('');
var resp_chan_62562 = fluree.db.util.xhttp.post_json(healthcheck_uri_62561,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___62563 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62563,healthcheck_uri_62561,resp_chan_62562,server_62560){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62563,healthcheck_uri_62561,resp_chan_62562,server_62560){
return (function (state_62451){
var state_val_62452 = (state_62451[(1)]);
if((state_val_62452 === (1))){
var state_62451__$1 = state_62451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62451__$1,(2),resp_chan_62562);
} else {
if((state_val_62452 === (2))){
var inst_62440 = (state_62451[(7)]);
var inst_62440__$1 = (state_62451[(2)]);
var inst_62441 = fluree.db.util.core.exception_QMARK_(inst_62440__$1);
var state_62451__$1 = (function (){var statearr_62453 = state_62451;
(statearr_62453[(7)] = inst_62440__$1);

return statearr_62453;
})();
if(inst_62441){
var statearr_62454_62564 = state_62451__$1;
(statearr_62454_62564[(1)] = (3));

} else {
var statearr_62455_62565 = state_62451__$1;
(statearr_62455_62565[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62452 === (3))){
var inst_62440 = (state_62451[(7)]);
var inst_62443 = cljs.core.ex_message(inst_62440);
var inst_62444 = cljs.core.ex_data(inst_62440);
var inst_62445 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62443,inst_62444], 0));
var state_62451__$1 = state_62451;
var statearr_62456_62566 = state_62451__$1;
(statearr_62456_62566[(2)] = inst_62445);

(statearr_62456_62566[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62452 === (4))){
var inst_62447 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62560);
var state_62451__$1 = state_62451;
var statearr_62457_62567 = state_62451__$1;
(statearr_62457_62567[(2)] = inst_62447);

(statearr_62457_62567[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62452 === (5))){
var inst_62449 = (state_62451[(2)]);
var state_62451__$1 = state_62451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62451__$1,inst_62449);
} else {
return null;
}
}
}
}
}
});})(seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62563,healthcheck_uri_62561,resp_chan_62562,server_62560))
;
return ((function (seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,switch__2726__auto__,c__2749__auto___62563,healthcheck_uri_62561,resp_chan_62562,server_62560){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_62458 = [null,null,null,null,null,null,null,null];
(statearr_62458[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_62458[(1)] = (1));

return statearr_62458;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_62451){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62451);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62459){var ex__2730__auto__ = e62459;
var statearr_62460_62568 = state_62451;
(statearr_62460_62568[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62451[(4)]))){
var statearr_62461_62569 = state_62451;
(statearr_62461_62569[(1)] = cljs.core.first((state_62451[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62570 = state_62451;
state_62451 = G__62570;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_62451){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_62451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,switch__2726__auto__,c__2749__auto___62563,healthcheck_uri_62561,resp_chan_62562,server_62560))
})();
var state__2751__auto__ = (function (){var statearr_62462 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62462[(6)] = c__2749__auto___62563);

return statearr_62462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62563,healthcheck_uri_62561,resp_chan_62562,server_62560))
);



var G__62571 = seq__62387_62556;
var G__62572 = chunk__62388_62557;
var G__62573 = count__62389_62558;
var G__62574 = (i__62390_62559 + (1));
seq__62387_62556 = G__62571;
chunk__62388_62557 = G__62572;
count__62389_62558 = G__62573;
i__62390_62559 = G__62574;
continue;
} else {
var temp__5804__auto___62575 = cljs.core.seq(seq__62387_62556);
if(temp__5804__auto___62575){
var seq__62387_62576__$1 = temp__5804__auto___62575;
if(cljs.core.chunked_seq_QMARK_(seq__62387_62576__$1)){
var c__5568__auto___62577 = cljs.core.chunk_first(seq__62387_62576__$1);
var G__62578 = cljs.core.chunk_rest(seq__62387_62576__$1);
var G__62579 = c__5568__auto___62577;
var G__62580 = cljs.core.count(c__5568__auto___62577);
var G__62581 = (0);
seq__62387_62556 = G__62578;
chunk__62388_62557 = G__62579;
count__62389_62558 = G__62580;
i__62390_62559 = G__62581;
continue;
} else {
var server_62582 = cljs.core.first(seq__62387_62576__$1);
var healthcheck_uri_62583 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62582),"/fdb/health"].join('');
var resp_chan_62584 = fluree.db.util.xhttp.post_json(healthcheck_uri_62583,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___62585 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582,seq__62387_62576__$1,temp__5804__auto___62575){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582,seq__62387_62576__$1,temp__5804__auto___62575){
return (function (state_62475){
var state_val_62476 = (state_62475[(1)]);
if((state_val_62476 === (1))){
var state_62475__$1 = state_62475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62475__$1,(2),resp_chan_62584);
} else {
if((state_val_62476 === (2))){
var inst_62464 = (state_62475[(7)]);
var inst_62464__$1 = (state_62475[(2)]);
var inst_62465 = fluree.db.util.core.exception_QMARK_(inst_62464__$1);
var state_62475__$1 = (function (){var statearr_62477 = state_62475;
(statearr_62477[(7)] = inst_62464__$1);

return statearr_62477;
})();
if(inst_62465){
var statearr_62478_62586 = state_62475__$1;
(statearr_62478_62586[(1)] = (3));

} else {
var statearr_62479_62587 = state_62475__$1;
(statearr_62479_62587[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62476 === (3))){
var inst_62464 = (state_62475[(7)]);
var inst_62467 = cljs.core.ex_message(inst_62464);
var inst_62468 = cljs.core.ex_data(inst_62464);
var inst_62469 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62467,inst_62468], 0));
var state_62475__$1 = state_62475;
var statearr_62480_62588 = state_62475__$1;
(statearr_62480_62588[(2)] = inst_62469);

(statearr_62480_62588[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62476 === (4))){
var inst_62471 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62582);
var state_62475__$1 = state_62475;
var statearr_62481_62589 = state_62475__$1;
(statearr_62481_62589[(2)] = inst_62471);

(statearr_62481_62589[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62476 === (5))){
var inst_62473 = (state_62475[(2)]);
var state_62475__$1 = state_62475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62475__$1,inst_62473);
} else {
return null;
}
}
}
}
}
});})(seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582,seq__62387_62576__$1,temp__5804__auto___62575))
;
return ((function (seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,switch__2726__auto__,c__2749__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582,seq__62387_62576__$1,temp__5804__auto___62575){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_62482 = [null,null,null,null,null,null,null,null];
(statearr_62482[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_62482[(1)] = (1));

return statearr_62482;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_62475){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62475);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62483){var ex__2730__auto__ = e62483;
var statearr_62484_62590 = state_62475;
(statearr_62484_62590[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62475[(4)]))){
var statearr_62485_62591 = state_62475;
(statearr_62485_62591[(1)] = cljs.core.first((state_62475[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62592 = state_62475;
state_62475 = G__62592;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_62475){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_62475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,switch__2726__auto__,c__2749__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582,seq__62387_62576__$1,temp__5804__auto___62575))
})();
var state__2751__auto__ = (function (){var statearr_62486 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62486[(6)] = c__2749__auto___62585);

return statearr_62486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__62387_62556,chunk__62388_62557,count__62389_62558,i__62390_62559,c__2749__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582,seq__62387_62576__$1,temp__5804__auto___62575))
);



var G__62593 = cljs.core.next(seq__62387_62576__$1);
var G__62594 = null;
var G__62595 = (0);
var G__62596 = (0);
seq__62387_62556 = G__62593;
chunk__62388_62557 = G__62594;
count__62389_62558 = G__62595;
i__62390_62559 = G__62596;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62530){
var state_val_62531 = (state_62530[(1)]);
if((state_val_62531 === (7))){
var inst_62502 = (state_62530[(7)]);
var inst_62509 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62502,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62530__$1 = state_62530;
if(inst_62509){
var statearr_62532_62597 = state_62530__$1;
(statearr_62532_62597[(1)] = (9));

} else {
var statearr_62533_62598 = state_62530__$1;
(statearr_62533_62598[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (1))){
var inst_62495 = (state_62530[(8)]);
var inst_62494 = (state_62530[(9)]);
var inst_62494__$1 = promise_chan;
var inst_62495__$1 = cljs.core.async.timeout((60000));
var inst_62496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62497 = [inst_62494__$1,inst_62495__$1];
var inst_62498 = (new cljs.core.PersistentVector(null,2,(5),inst_62496,inst_62497,null));
var state_62530__$1 = (function (){var statearr_62534 = state_62530;
(statearr_62534[(8)] = inst_62495__$1);

(statearr_62534[(9)] = inst_62494__$1);

return statearr_62534;
})();
return cljs.core.async.ioc_alts_BANG_(state_62530__$1,(2),inst_62498);
} else {
if((state_val_62531 === (4))){
var inst_62502 = (state_62530[(7)]);
var inst_62495 = (state_62530[(8)]);
var inst_62506 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62502,inst_62495);
var state_62530__$1 = state_62530;
if(inst_62506){
var statearr_62535_62599 = state_62530__$1;
(statearr_62535_62599[(1)] = (6));

} else {
var statearr_62536_62600 = state_62530__$1;
(statearr_62536_62600[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (13))){
var state_62530__$1 = state_62530;
var statearr_62537_62601 = state_62530__$1;
(statearr_62537_62601[(2)] = null);

(statearr_62537_62601[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (6))){
var state_62530__$1 = state_62530;
var statearr_62538_62602 = state_62530__$1;
(statearr_62538_62602[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62538_62602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (3))){
var state_62530__$1 = state_62530;
var statearr_62539_62603 = state_62530__$1;
(statearr_62539_62603[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62539_62603[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (12))){
var inst_62520 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_62521 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62522 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62523 = cljs.core.PersistentHashMap.fromArrays(inst_62521,inst_62522);
var inst_62524 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_62523);
var inst_62525 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_62524);
var state_62530__$1 = (function (){var statearr_62540 = state_62530;
(statearr_62540[(10)] = inst_62520);

return statearr_62540;
})();
var statearr_62541_62604 = state_62530__$1;
(statearr_62541_62604[(2)] = inst_62525);

(statearr_62541_62604[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (2))){
var inst_62502 = (state_62530[(7)]);
var inst_62494 = (state_62530[(9)]);
var inst_62500 = (state_62530[(2)]);
var inst_62501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62500,(0),null);
var inst_62502__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62500,(1),null);
var inst_62503 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62502__$1,inst_62494);
var state_62530__$1 = (function (){var statearr_62542 = state_62530;
(statearr_62542[(7)] = inst_62502__$1);

(statearr_62542[(11)] = inst_62501);

return statearr_62542;
})();
if(inst_62503){
var statearr_62543_62605 = state_62530__$1;
(statearr_62543_62605[(1)] = (3));

} else {
var statearr_62544_62606 = state_62530__$1;
(statearr_62544_62606[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (11))){
var inst_62513 = (state_62530[(2)]);
var state_62530__$1 = state_62530;
var statearr_62545_62607 = state_62530__$1;
(statearr_62545_62607[(2)] = inst_62513);

(statearr_62545_62607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (9))){
var inst_62501 = (state_62530[(11)]);
var state_62530__$1 = state_62530;
var statearr_62546_62608 = state_62530__$1;
(statearr_62546_62608[(2)] = inst_62501);

(statearr_62546_62608[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (5))){
var inst_62517 = (state_62530[(2)]);
var inst_62518 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62517);
var state_62530__$1 = state_62530;
if(inst_62518){
var statearr_62547_62609 = state_62530__$1;
(statearr_62547_62609[(1)] = (12));

} else {
var statearr_62548_62610 = state_62530__$1;
(statearr_62548_62610[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (14))){
var inst_62528 = (state_62530[(2)]);
var state_62530__$1 = state_62530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62530__$1,inst_62528);
} else {
if((state_val_62531 === (10))){
var state_62530__$1 = state_62530;
var statearr_62549_62611 = state_62530__$1;
(statearr_62549_62611[(2)] = null);

(statearr_62549_62611[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (8))){
var inst_62515 = (state_62530[(2)]);
var state_62530__$1 = state_62530;
var statearr_62550_62612 = state_62530__$1;
(statearr_62550_62612[(2)] = inst_62515);

(statearr_62550_62612[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_62551 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62551[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_62551[(1)] = (1));

return statearr_62551;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_62530){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62530);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62552){var ex__2730__auto__ = e62552;
var statearr_62553_62613 = state_62530;
(statearr_62553_62613[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62530[(4)]))){
var statearr_62554_62614 = state_62530;
(statearr_62554_62614[(1)] = cljs.core.first((state_62530[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62615 = state_62530;
state_62530 = G__62615;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_62530){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_62530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62555 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62555[(6)] = c__2749__auto__);

return statearr_62555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62659){
var state_val_62660 = (state_62659[(1)]);
if((state_val_62660 === (7))){
var state_62659__$1 = state_62659;
var statearr_62661_62687 = state_62659__$1;
(statearr_62661_62687[(2)] = null);

(statearr_62661_62687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (1))){
var state_62659__$1 = state_62659;
var statearr_62662_62688 = state_62659__$1;
(statearr_62662_62688[(2)] = null);

(statearr_62662_62688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (4))){
var inst_62616 = (state_62659[(2)]);
var state_62659__$1 = state_62659;
var statearr_62663_62689 = state_62659__$1;
(statearr_62663_62689[(2)] = inst_62616);

(statearr_62663_62689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (6))){
var inst_62638 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_62659__$1 = state_62659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62659__$1,(9),inst_62638);
} else {
if((state_val_62660 === (3))){
var inst_62657 = (state_62659[(2)]);
var state_62659__$1 = state_62659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62659__$1,inst_62657);
} else {
if((state_val_62660 === (12))){
var inst_62651 = (state_62659[(2)]);
var state_62659__$1 = state_62659;
var statearr_62664_62690 = state_62659__$1;
(statearr_62664_62690[(2)] = inst_62651);

(statearr_62664_62690[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (2))){
var inst_62627 = (state_62659[(7)]);
var inst_62632 = (state_62659[(8)]);
var inst_62622 = (state_62659[(9)]);
var _ = (function (){var statearr_62665 = state_62659;
(statearr_62665[(4)] = cljs.core.cons((5),(state_62659[(4)])));

return statearr_62665;
})();
var inst_62622__$1 = fluree.db.util.core.random_uuid();
var inst_62623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62624 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62625 = (new cljs.core.PersistentVector(null,2,(5),inst_62623,inst_62624,null));
var inst_62626 = (function (){var lock_id = inst_62622__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_62627__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62625,inst_62626);
var inst_62628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62629 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62630 = (new cljs.core.PersistentVector(null,3,(5),inst_62628,inst_62629,null));
var inst_62631 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62627__$1,inst_62630);
var inst_62632__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62622__$1,inst_62631);
var inst_62633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62634 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62635 = (new cljs.core.PersistentVector(null,3,(5),inst_62633,inst_62634,null));
var inst_62636 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62627__$1,inst_62635);
var state_62659__$1 = (function (){var statearr_62666 = state_62659;
(statearr_62666[(7)] = inst_62627__$1);

(statearr_62666[(8)] = inst_62632__$1);

(statearr_62666[(9)] = inst_62622__$1);

(statearr_62666[(10)] = inst_62636);

return statearr_62666;
})();
if(inst_62632__$1){
var statearr_62667_62691 = state_62659__$1;
(statearr_62667_62691[(1)] = (6));

} else {
var statearr_62668_62692 = state_62659__$1;
(statearr_62668_62692[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (11))){
var inst_62643 = (state_62659[(11)]);
var inst_62642 = (state_62659[(12)]);
var inst_62636 = (state_62659[(10)]);
var inst_62649 = fluree.db.util.xhttp.try_socket(inst_62642,sub_chan,pub_chan,inst_62636,(60000),inst_62643);
var state_62659__$1 = state_62659;
var statearr_62670_62693 = state_62659__$1;
(statearr_62670_62693[(2)] = inst_62649);

(statearr_62670_62693[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (9))){
var inst_62627 = (state_62659[(7)]);
var inst_62632 = (state_62659[(8)]);
var inst_62640 = (state_62659[(13)]);
var inst_62622 = (state_62659[(9)]);
var inst_62642 = (state_62659[(12)]);
var inst_62636 = (state_62659[(10)]);
var inst_62640__$1 = (state_62659[(2)]);
var inst_62641 = clojure.string.replace(inst_62640__$1,"http","ws");
var inst_62642__$1 = [inst_62641,"/fdb/ws"].join('');
var inst_62643 = (function (){var lock_id = inst_62622;
var state = inst_62627;
var have_lock_QMARK_ = inst_62632;
var resp_chan = inst_62636;
var healthy_server = inst_62640__$1;
var ws_url = inst_62642__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_62644 = fluree.db.util.core.exception_QMARK_(inst_62640__$1);
var state_62659__$1 = (function (){var statearr_62671 = state_62659;
(statearr_62671[(13)] = inst_62640__$1);

(statearr_62671[(11)] = inst_62643);

(statearr_62671[(12)] = inst_62642__$1);

return statearr_62671;
})();
if(inst_62644){
var statearr_62672_62694 = state_62659__$1;
(statearr_62672_62694[(1)] = (10));

} else {
var statearr_62673_62695 = state_62659__$1;
(statearr_62673_62695[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (5))){
var _ = (function (){var statearr_62674 = state_62659;
(statearr_62674[(4)] = cljs.core.rest((state_62659[(4)])));

return statearr_62674;
})();
var state_62659__$1 = state_62659;
var ex62669 = (state_62659__$1[(2)]);
var statearr_62675_62696 = state_62659__$1;
(statearr_62675_62696[(5)] = ex62669);


if((ex62669 instanceof Error)){
var statearr_62676_62697 = state_62659__$1;
(statearr_62676_62697[(1)] = (4));

(statearr_62676_62697[(5)] = null);

} else {
throw ex62669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (10))){
var inst_62640 = (state_62659[(13)]);
var inst_62636 = (state_62659[(10)]);
var inst_62646 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_62647 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62636,inst_62640);
var state_62659__$1 = (function (){var statearr_62677 = state_62659;
(statearr_62677[(14)] = inst_62646);

return statearr_62677;
})();
var statearr_62678_62698 = state_62659__$1;
(statearr_62678_62698[(2)] = inst_62647);

(statearr_62678_62698[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62660 === (8))){
var inst_62636 = (state_62659[(10)]);
var inst_62654 = (state_62659[(2)]);
var _ = (function (){var statearr_62679 = state_62659;
(statearr_62679[(4)] = cljs.core.rest((state_62659[(4)])));

return statearr_62679;
})();
var state_62659__$1 = (function (){var statearr_62680 = state_62659;
(statearr_62680[(15)] = inst_62654);

return statearr_62680;
})();
var statearr_62681_62699 = state_62659__$1;
(statearr_62681_62699[(2)] = inst_62636);

(statearr_62681_62699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_62682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62682[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_62682[(1)] = (1));

return statearr_62682;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_62659){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62659);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62683){var ex__2730__auto__ = e62683;
var statearr_62684_62700 = state_62659;
(statearr_62684_62700[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62659[(4)]))){
var statearr_62685_62701 = state_62659;
(statearr_62685_62701[(1)] = cljs.core.first((state_62659[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62702 = state_62659;
state_62659 = G__62702;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_62659){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_62659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62686 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62686[(6)] = c__2749__auto__);

return statearr_62686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k62704,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__62708 = k62704;
var G__62708__$1 = (((G__62708 instanceof cljs.core.Keyword))?G__62708.fqn:null);
switch (G__62708__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k62704,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__62709){
var vec__62710 = p__62709;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62710,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62710,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62703){
var self__ = this;
var G__62703__$1 = this;
return (new cljs.core.RecordIter((0),G__62703__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__62713 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__62713(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62705,other62706){
var self__ = this;
var this62705__$1 = this;
return (((!((other62706 == null)))) && ((((this62705__$1.constructor === other62706.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.id,other62706.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.servers,other62706.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.state,other62706.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.req_chan,other62706.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.sub_chan,other62706.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.pub_chan,other62706.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.group,other62706.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.storage_read,other62706.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.storage_write,other62706.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.object_cache,other62706.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.parallelism,other62706.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.serializer,other62706.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.default_network,other62706.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.transactor_QMARK_,other62706.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.publish,other62706.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.transact_handler,other62706.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.tx_private_key,other62706.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.tx_key_id,other62706.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.meta,other62706.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.add_listener,other62706.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.remove_listener,other62706.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.close,other62706.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62705__$1.__extmap,other62706.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k62704){
var self__ = this;
var this__5350__auto____$1 = this;
var G__62714 = k62704;
var G__62714__$1 = (((G__62714 instanceof cljs.core.Keyword))?G__62714.fqn:null);
switch (G__62714__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k62704);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__62703){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__62715 = cljs.core.keyword_identical_QMARK_;
var expr__62716 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__62718 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__62719 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62718,G__62719) : pred__62715.call(null,G__62718,G__62719));
})())){
return (new fluree.db.connection.Connection(G__62703,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62720 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__62721 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62720,G__62721) : pred__62715.call(null,G__62720,G__62721));
})())){
return (new fluree.db.connection.Connection(self__.id,G__62703,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62722 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__62723 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62722,G__62723) : pred__62715.call(null,G__62722,G__62723));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62703,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62724 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__62725 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62724,G__62725) : pred__62715.call(null,G__62724,G__62725));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62703,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62726 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__62727 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62726,G__62727) : pred__62715.call(null,G__62726,G__62727));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62703,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62728 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__62729 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62728,G__62729) : pred__62715.call(null,G__62728,G__62729));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62703,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62730 = new cljs.core.Keyword(null,"group","group",582596132);
var G__62731 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62730,G__62731) : pred__62715.call(null,G__62730,G__62731));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62703,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62732 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__62733 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62732,G__62733) : pred__62715.call(null,G__62732,G__62733));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__62703,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62734 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__62735 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62734,G__62735) : pred__62715.call(null,G__62734,G__62735));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__62703,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62736 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__62737 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62736,G__62737) : pred__62715.call(null,G__62736,G__62737));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__62703,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62738 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__62739 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62738,G__62739) : pred__62715.call(null,G__62738,G__62739));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__62703,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62740 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__62741 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62740,G__62741) : pred__62715.call(null,G__62740,G__62741));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62703,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62742 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__62743 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62742,G__62743) : pred__62715.call(null,G__62742,G__62743));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62703,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62744 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__62745 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62744,G__62745) : pred__62715.call(null,G__62744,G__62745));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62703,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62746 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__62747 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62746,G__62747) : pred__62715.call(null,G__62746,G__62747));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62703,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62748 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__62749 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62748,G__62749) : pred__62715.call(null,G__62748,G__62749));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62703,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62750 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__62751 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62750,G__62751) : pred__62715.call(null,G__62750,G__62751));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62703,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62752 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__62753 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62752,G__62753) : pred__62715.call(null,G__62752,G__62753));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62703,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62754 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__62755 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62754,G__62755) : pred__62715.call(null,G__62754,G__62755));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62703,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62756 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__62757 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62756,G__62757) : pred__62715.call(null,G__62756,G__62757));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62703,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62758 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__62759 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62758,G__62759) : pred__62715.call(null,G__62758,G__62759));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62703,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62760 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__62761 = expr__62716;
return (pred__62715.cljs$core$IFn$_invoke$arity$2 ? pred__62715.cljs$core$IFn$_invoke$arity$2(G__62760,G__62761) : pred__62715.call(null,G__62760,G__62761));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62703,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__62703),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__62703){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62703,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62707){
var extmap__5385__auto__ = (function (){var G__62762 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__62707,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__62707)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__62762);
} else {
return G__62762;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62707),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62707),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__62768 = servers_STAR_;
var vec__62769 = G__62768;
var seq__62770 = cljs.core.seq(vec__62769);
var first__62771 = cljs.core.first(seq__62770);
var seq__62770__$1 = cljs.core.next(seq__62770);
var server = first__62771;
var r = seq__62770__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62768__$1 = G__62768;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62775 = G__62768__$1;
var seq__62776 = cljs.core.seq(vec__62775);
var first__62777 = cljs.core.first(seq__62776);
var seq__62776__$1 = cljs.core.next(seq__62776);
var server__$1 = first__62777;
var r__$1 = seq__62776__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__62778 = r__$1;
var G__62779 = is_https_QMARK_;
var G__62780 = result_STAR_;
G__62768__$1 = G__62778;
https_QMARK___$1 = G__62779;
result__$1 = G__62780;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62781 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62781 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__62781);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62810){
var state_val_62811 = (state_62810[(1)]);
if((state_val_62811 === (7))){
var inst_62796 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62797 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62798 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62799 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62800 = fluree.db.connection.establish_socket(inst_62796,inst_62797,inst_62798,inst_62799);
var state_62810__$1 = state_62810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62810__$1,(9),inst_62800);
} else {
if((state_val_62811 === (1))){
var state_62810__$1 = state_62810;
var statearr_62812_62831 = state_62810__$1;
(statearr_62812_62831[(2)] = null);

(statearr_62812_62831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62811 === (4))){
var inst_62782 = (state_62810[(2)]);
var state_62810__$1 = state_62810;
var statearr_62813_62832 = state_62810__$1;
(statearr_62813_62832[(2)] = inst_62782);

(statearr_62813_62832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62811 === (6))){
var inst_62793 = (state_62810[(7)]);
var state_62810__$1 = state_62810;
var statearr_62814_62833 = state_62810__$1;
(statearr_62814_62833[(2)] = inst_62793);

(statearr_62814_62833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62811 === (3))){
var inst_62808 = (state_62810[(2)]);
var state_62810__$1 = state_62810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62810__$1,inst_62808);
} else {
if((state_val_62811 === (2))){
var inst_62793 = (state_62810[(7)]);
var _ = (function (){var statearr_62816 = state_62810;
(statearr_62816[(4)] = cljs.core.cons((5),(state_62810[(4)])));

return statearr_62816;
})();
var inst_62788 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62790 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62791 = [inst_62790,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62792 = (new cljs.core.PersistentVector(null,3,(5),inst_62789,inst_62791,null));
var inst_62793__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62788,inst_62792);
var state_62810__$1 = (function (){var statearr_62817 = state_62810;
(statearr_62817[(7)] = inst_62793__$1);

return statearr_62817;
})();
if(cljs.core.truth_(inst_62793__$1)){
var statearr_62818_62834 = state_62810__$1;
(statearr_62818_62834[(1)] = (6));

} else {
var statearr_62819_62835 = state_62810__$1;
(statearr_62819_62835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62811 === (9))){
var inst_62802 = (state_62810[(2)]);
var inst_62803 = fluree.db.util.async.throw_err(inst_62802);
var state_62810__$1 = state_62810;
var statearr_62820_62836 = state_62810__$1;
(statearr_62820_62836[(2)] = inst_62803);

(statearr_62820_62836[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62811 === (5))){
var _ = (function (){var statearr_62821 = state_62810;
(statearr_62821[(4)] = cljs.core.rest((state_62810[(4)])));

return statearr_62821;
})();
var state_62810__$1 = state_62810;
var ex62815 = (state_62810__$1[(2)]);
var statearr_62822_62837 = state_62810__$1;
(statearr_62822_62837[(5)] = ex62815);


if((ex62815 instanceof Error)){
var statearr_62823_62838 = state_62810__$1;
(statearr_62823_62838[(1)] = (4));

(statearr_62823_62838[(5)] = null);

} else {
throw ex62815;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62811 === (8))){
var inst_62805 = (state_62810[(2)]);
var _ = (function (){var statearr_62824 = state_62810;
(statearr_62824[(4)] = cljs.core.rest((state_62810[(4)])));

return statearr_62824;
})();
var state_62810__$1 = state_62810;
var statearr_62825_62839 = state_62810__$1;
(statearr_62825_62839[(2)] = inst_62805);

(statearr_62825_62839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_62826 = [null,null,null,null,null,null,null,null];
(statearr_62826[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_62826[(1)] = (1));

return statearr_62826;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_62810){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62810);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62827){var ex__2730__auto__ = e62827;
var statearr_62828_62840 = state_62810;
(statearr_62828_62840[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62810[(4)]))){
var statearr_62829_62841 = state_62810;
(statearr_62829_62841[(1)] = cljs.core.first((state_62810[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62842 = state_62810;
state_62810 = G__62842;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_62810){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_62810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62830 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62830[(6)] = c__2749__auto__);

return statearr_62830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e62843){var e = e62843;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62970){
var state_val_62971 = (state_62970[(1)]);
if((state_val_62971 === (7))){
var inst_62966 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
var statearr_62973_63043 = state_62970__$1;
(statearr_62973_63043[(2)] = inst_62966);

(statearr_62973_63043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (20))){
var _ = (function (){var statearr_62974 = state_62970;
(statearr_62974[(4)] = cljs.core.rest((state_62970[(4)])));

return statearr_62974;
})();
var state_62970__$1 = state_62970;
var ex62972 = (state_62970__$1[(2)]);
var statearr_62975_63044 = state_62970__$1;
(statearr_62975_63044[(5)] = ex62972);


var statearr_62976_63045 = state_62970__$1;
(statearr_62976_63045[(1)] = (10));

(statearr_62976_63045[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (27))){
var inst_62958 = (state_62970[(2)]);
var _ = (function (){var statearr_62977 = state_62970;
(statearr_62977[(4)] = cljs.core.rest((state_62970[(4)])));

return statearr_62977;
})();
var state_62970__$1 = state_62970;
var statearr_62978_63046 = state_62970__$1;
(statearr_62978_63046[(2)] = inst_62958);

(statearr_62978_63046[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (1))){
var inst_62845 = (0);
var state_62970__$1 = (function (){var statearr_62979 = state_62970;
(statearr_62979[(7)] = inst_62845);

return statearr_62979;
})();
var statearr_62980_63047 = state_62970__$1;
(statearr_62980_63047[(2)] = null);

(statearr_62980_63047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (24))){
var inst_62936 = (state_62970[(8)]);
var inst_62936__$1 = (state_62970[(2)]);
var inst_62937 = inst_62936__$1 === true;
var state_62970__$1 = (function (){var statearr_62981 = state_62970;
(statearr_62981[(8)] = inst_62936__$1);

return statearr_62981;
})();
if(cljs.core.truth_(inst_62937)){
var statearr_62982_63048 = state_62970__$1;
(statearr_62982_63048[(1)] = (25));

} else {
var statearr_62983_63049 = state_62970__$1;
(statearr_62983_63049[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (4))){
var inst_62848 = (state_62970[(9)]);
var inst_62848__$1 = (state_62970[(2)]);
var state_62970__$1 = (function (){var statearr_62984 = state_62970;
(statearr_62984[(9)] = inst_62848__$1);

return statearr_62984;
})();
if(cljs.core.truth_(inst_62848__$1)){
var statearr_62985_63050 = state_62970__$1;
(statearr_62985_63050[(1)] = (5));

} else {
var statearr_62986_63051 = state_62970__$1;
(statearr_62986_63051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (15))){
var inst_62861 = (state_62970[(10)]);
var state_62970__$1 = state_62970;
var statearr_62987_63052 = state_62970__$1;
(statearr_62987_63052[(2)] = inst_62861);

(statearr_62987_63052[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (21))){
var inst_62888 = (state_62970[(11)]);
var inst_62884 = (state_62970[(12)]);
var inst_62889 = (state_62970[(13)]);
var inst_62885 = (state_62970[(14)]);
var inst_62892 = (state_62970[(15)]);
var inst_62893 = (state_62970[(16)]);
var inst_62845 = (state_62970[(7)]);
var inst_62886 = (state_62970[(17)]);
var inst_62848 = (state_62970[(9)]);
var inst_62887 = (state_62970[(18)]);
var inst_62895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62896 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62892];
var inst_62897 = (new cljs.core.PersistentVector(null,2,(5),inst_62895,inst_62896,null));
var inst_62898 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62897,inst_62887);
var inst_62925 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62926 = (function (){var resp_chan = inst_62887;
var timeout = inst_62893;
var c__2749__auto____$1 = inst_62925;
var i = inst_62845;
var data = inst_62886;
var vec__62880 = inst_62848;
var _ = inst_62884;
var req_id = inst_62892;
var operation = inst_62885;
var msg = inst_62848;
var map__62883 = inst_62889;
var opts = inst_62888;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_62923){
var state_val_62924 = (state_62923[(1)]);
if((state_val_62924 === (1))){
var inst_62902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62903 = cljs.core.async.timeout(timeout);
var inst_62904 = [resp_chan,inst_62903];
var inst_62905 = (new cljs.core.PersistentVector(null,2,(5),inst_62902,inst_62904,null));
var state_62923__$1 = state_62923;
return cljs.core.async.ioc_alts_BANG_(state_62923__$1,(2),inst_62905);
} else {
if((state_val_62924 === (2))){
var inst_62908 = (state_62923[(7)]);
var inst_62907 = (state_62923[(2)]);
var inst_62908__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62907,(0),null);
var inst_62909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62907,(1),null);
var inst_62910 = (function (){var vec__62899 = inst_62907;
var resp = inst_62908__$1;
var c = inst_62909;
return (function (p1__62844_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__62844_SHARP_,req_id);
});
})();
var inst_62911 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62910);
var inst_62912 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62909,resp_chan);
var state_62923__$1 = (function (){var statearr_62988 = state_62923;
(statearr_62988[(7)] = inst_62908__$1);

(statearr_62988[(8)] = inst_62911);

return statearr_62988;
})();
if(inst_62912){
var statearr_62989_63053 = state_62923__$1;
(statearr_62989_63053[(1)] = (3));

} else {
var statearr_62990_63054 = state_62923__$1;
(statearr_62990_63054[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (3))){
var inst_62908 = (state_62923[(7)]);
var state_62923__$1 = state_62923;
var statearr_62991_63055 = state_62923__$1;
(statearr_62991_63055[(2)] = inst_62908);

(statearr_62991_63055[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (4))){
var inst_62915 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62916 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62917 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62918 = cljs.core.PersistentHashMap.fromArrays(inst_62916,inst_62917);
var inst_62919 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62915,inst_62918);
var state_62923__$1 = state_62923;
var statearr_62992_63056 = state_62923__$1;
(statearr_62992_63056[(2)] = inst_62919);

(statearr_62992_63056[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (5))){
var inst_62921 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62923__$1,inst_62921);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_62993 = [null,null,null,null,null,null,null,null,null];
(statearr_62993[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_62993[(1)] = (1));

return statearr_62993;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_62923){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62923);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e62994){var ex__2730__auto__ = e62994;
var statearr_62995_63057 = state_62923;
(statearr_62995_63057[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62923[(4)]))){
var statearr_62996_63058 = state_62923;
(statearr_62996_63058[(1)] = cljs.core.first((state_62923[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63059 = state_62923;
state_62923 = G__63059;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_62923){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_62923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_62997 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_62997[(6)] = c__2749__auto____$1);

return statearr_62997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_62927 = cljs.core.async.impl.dispatch.run(inst_62926);
var state_62970__$1 = (function (){var statearr_62998 = state_62970;
(statearr_62998[(19)] = inst_62927);

(statearr_62998[(20)] = inst_62898);

return statearr_62998;
})();
var statearr_62999_63060 = state_62970__$1;
(statearr_62999_63060[(2)] = inst_62925);

(statearr_62999_63060[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (31))){
var inst_62946 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62970__$1 = state_62970;
var statearr_63000_63061 = state_62970__$1;
(statearr_63000_63061[(2)] = inst_62946);

(statearr_63000_63061[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (32))){
var state_62970__$1 = state_62970;
var statearr_63001_63062 = state_62970__$1;
(statearr_63001_63062[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (33))){
var inst_62954 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
var statearr_63003_63063 = state_62970__$1;
(statearr_63003_63063[(2)] = inst_62954);

(statearr_63003_63063[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (13))){
var inst_62861 = (state_62970[(10)]);
var inst_62858 = (state_62970[(2)]);
var inst_62859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62858,(0),null);
var inst_62860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62858,(1),null);
var inst_62861__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62858,(2),null);
var state_62970__$1 = (function (){var statearr_63004 = state_62970;
(statearr_63004[(21)] = inst_62860);

(statearr_63004[(22)] = inst_62859);

(statearr_63004[(10)] = inst_62861__$1);

return statearr_63004;
})();
if(cljs.core.truth_(inst_62861__$1)){
var statearr_63005_63064 = state_62970__$1;
(statearr_63005_63064[(1)] = (14));

} else {
var statearr_63006_63065 = state_62970__$1;
(statearr_63006_63065[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (22))){
var state_62970__$1 = state_62970;
var statearr_63007_63066 = state_62970__$1;
(statearr_63007_63066[(2)] = null);

(statearr_63007_63066[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (36))){
var inst_62952 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
var statearr_63008_63067 = state_62970__$1;
(statearr_63008_63067[(2)] = inst_62952);

(statearr_63008_63067[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (29))){
var inst_62936 = (state_62970[(8)]);
var inst_62944 = (inst_62936 == null);
var state_62970__$1 = state_62970;
if(cljs.core.truth_(inst_62944)){
var statearr_63009_63068 = state_62970__$1;
(statearr_63009_63068[(1)] = (31));

} else {
var statearr_63010_63069 = state_62970__$1;
(statearr_63010_63069[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (6))){
var state_62970__$1 = state_62970;
var statearr_63011_63070 = state_62970__$1;
(statearr_63011_63070[(2)] = null);

(statearr_63011_63070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (28))){
var inst_62936 = (state_62970[(8)]);
var inst_62942 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62936,"Error processing message in producer."], 0));
var state_62970__$1 = state_62970;
var statearr_63012_63071 = state_62970__$1;
(statearr_63012_63071[(2)] = inst_62942);

(statearr_63012_63071[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (25))){
var state_62970__$1 = state_62970;
var statearr_63013_63072 = state_62970__$1;
(statearr_63013_63072[(2)] = null);

(statearr_63013_63072[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (34))){
var inst_62936 = (state_62970[(8)]);
var inst_62949 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62936], 0));
var state_62970__$1 = state_62970;
var statearr_63014_63073 = state_62970__$1;
(statearr_63014_63073[(2)] = inst_62949);

(statearr_63014_63073[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (17))){
var inst_62850 = (state_62970[(23)]);
var inst_62861 = (state_62970[(10)]);
var inst_62868 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62861,inst_62850);
var state_62970__$1 = state_62970;
var statearr_63015_63074 = state_62970__$1;
(statearr_63015_63074[(2)] = inst_62868);

(statearr_63015_63074[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (3))){
var inst_62968 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62970__$1,inst_62968);
} else {
if((state_val_62971 === (12))){
var state_62970__$1 = state_62970;
var statearr_63016_63075 = state_62970__$1;
(statearr_63016_63075[(2)] = null);

(statearr_63016_63075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (2))){
var state_62970__$1 = state_62970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62970__$1,(4),req_chan);
} else {
if((state_val_62971 === (23))){
var inst_62885 = (state_62970[(14)]);
var inst_62892 = (state_62970[(15)]);
var inst_62886 = (state_62970[(17)]);
var inst_62930 = (state_62970[(2)]);
var inst_62931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62932 = [inst_62885,inst_62892,inst_62886];
var inst_62933 = (new cljs.core.PersistentVector(null,3,(5),inst_62931,inst_62932,null));
var inst_62934 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62933) : publish_fn.call(null,conn,inst_62933));
var state_62970__$1 = (function (){var statearr_63017 = state_62970;
(statearr_63017[(24)] = inst_62930);

return statearr_63017;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62970__$1,(24),inst_62934);
} else {
if((state_val_62971 === (35))){
var state_62970__$1 = state_62970;
var statearr_63018_63076 = state_62970__$1;
(statearr_63018_63076[(2)] = null);

(statearr_63018_63076[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (19))){
var inst_62874 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
var statearr_63019_63077 = state_62970__$1;
(statearr_63019_63077[(2)] = inst_62874);

(statearr_63019_63077[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (11))){
var inst_62848 = (state_62970[(9)]);
var state_62970__$1 = state_62970;
var statearr_63020_63078 = state_62970__$1;
(statearr_63020_63078[(2)] = inst_62848);

(statearr_63020_63078[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (9))){
var inst_62845 = (state_62970[(7)]);
var inst_62961 = (state_62970[(2)]);
var inst_62962 = (inst_62845 + (1));
var inst_62845__$1 = inst_62962;
var state_62970__$1 = (function (){var statearr_63021 = state_62970;
(statearr_63021[(25)] = inst_62961);

(statearr_63021[(7)] = inst_62845__$1);

return statearr_63021;
})();
var statearr_63022_63079 = state_62970__$1;
(statearr_63022_63079[(2)] = null);

(statearr_63022_63079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (5))){
var state_62970__$1 = state_62970;
var statearr_63023_63080 = state_62970__$1;
(statearr_63023_63080[(2)] = null);

(statearr_63023_63080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (14))){
var inst_62861 = (state_62970[(10)]);
var inst_62863 = fluree.db.util.async.channel_QMARK_(inst_62861);
var state_62970__$1 = state_62970;
var statearr_63024_63081 = state_62970__$1;
(statearr_63024_63081[(2)] = inst_62863);

(statearr_63024_63081[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (26))){
var inst_62936 = (state_62970[(8)]);
var inst_62940 = fluree.db.util.core.exception_QMARK_(inst_62936);
var state_62970__$1 = state_62970;
if(inst_62940){
var statearr_63025_63082 = state_62970__$1;
(statearr_63025_63082[(1)] = (28));

} else {
var statearr_63026_63083 = state_62970__$1;
(statearr_63026_63083[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (16))){
var inst_62866 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
if(cljs.core.truth_(inst_62866)){
var statearr_63027_63084 = state_62970__$1;
(statearr_63027_63084[(1)] = (17));

} else {
var statearr_63028_63085 = state_62970__$1;
(statearr_63028_63085[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (30))){
var inst_62956 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
var statearr_63029_63086 = state_62970__$1;
(statearr_63029_63086[(2)] = inst_62956);

(statearr_63029_63086[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (10))){
var inst_62848 = (state_62970[(9)]);
var inst_62850 = (state_62970[(2)]);
var inst_62854 = cljs.core.sequential_QMARK_(inst_62848);
var state_62970__$1 = (function (){var statearr_63030 = state_62970;
(statearr_63030[(23)] = inst_62850);

return statearr_63030;
})();
if(inst_62854){
var statearr_63031_63087 = state_62970__$1;
(statearr_63031_63087[(1)] = (11));

} else {
var statearr_63032_63088 = state_62970__$1;
(statearr_63032_63088[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (18))){
var inst_62850 = (state_62970[(23)]);
var inst_62848 = (state_62970[(9)]);
var inst_62870 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62848], 0));
var inst_62871 = ["Error processing ledger request, no valid return channel: ",inst_62870].join('');
var inst_62872 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62850,inst_62871], 0));
var state_62970__$1 = state_62970;
var statearr_63033_63089 = state_62970__$1;
(statearr_63033_63089[(2)] = inst_62872);

(statearr_63033_63089[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (8))){
var inst_62888 = (state_62970[(11)]);
var inst_62889 = (state_62970[(13)]);
var inst_62848 = (state_62970[(9)]);
var inst_62887 = (state_62970[(18)]);
var _ = (function (){var statearr_63034 = state_62970;
(statearr_63034[(4)] = cljs.core.cons((20),(state_62970[(4)])));

return statearr_63034;
})();
var inst_62884 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_62848], 0));
var inst_62885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62848,(0),null);
var inst_62886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62848,(1),null);
var inst_62887__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62848,(2),null);
var inst_62888__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62848,(3),null);
var inst_62889__$1 = cljs.core.__destructure_map(inst_62888__$1);
var inst_62890 = fluree.db.util.core.random_uuid();
var inst_62891 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62890);
var inst_62892 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62889__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62891);
var inst_62893 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62889__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62970__$1 = (function (){var statearr_63035 = state_62970;
(statearr_63035[(11)] = inst_62888__$1);

(statearr_63035[(12)] = inst_62884);

(statearr_63035[(13)] = inst_62889__$1);

(statearr_63035[(14)] = inst_62885);

(statearr_63035[(15)] = inst_62892);

(statearr_63035[(16)] = inst_62893);

(statearr_63035[(17)] = inst_62886);

(statearr_63035[(18)] = inst_62887__$1);

return statearr_63035;
})();
if(cljs.core.truth_(inst_62887__$1)){
var statearr_63036_63090 = state_62970__$1;
(statearr_63036_63090[(1)] = (21));

} else {
var statearr_63037_63091 = state_62970__$1;
(statearr_63037_63091[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_63038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63038[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_63038[(1)] = (1));

return statearr_63038;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_62970){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_62970);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63039){var ex__2730__auto__ = e63039;
var statearr_63040_63092 = state_62970;
(statearr_63040_63092[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_62970[(4)]))){
var statearr_63041_63093 = state_62970;
(statearr_63041_63093[(1)] = cljs.core.first((state_62970[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63094 = state_62970;
state_62970 = G__63094;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_62970){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_62970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63042 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63042[(6)] = c__2749__auto__);

return statearr_63042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__63095 = conn;
var map__63095__$1 = cljs.core.__destructure_map(map__63095);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63095__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63180){
var state_val_63181 = (state_63180[(1)]);
if((state_val_63181 === (7))){
var inst_63176 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63182_63233 = state_63180__$1;
(statearr_63182_63233[(2)] = inst_63176);

(statearr_63182_63233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (20))){
var inst_63114 = (state_63180[(7)]);
var inst_63128 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_63129 = [inst_63114];
var inst_63130 = cljs.core.PersistentHashMap.fromArrays(inst_63128,inst_63129);
var inst_63131 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_63130], 0));
var state_63180__$1 = state_63180;
var statearr_63183_63234 = state_63180__$1;
(statearr_63183_63234[(2)] = inst_63131);

(statearr_63183_63234[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (27))){
var state_63180__$1 = state_63180;
var statearr_63184_63235 = state_63180__$1;
(statearr_63184_63235[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (1))){
var inst_63096 = (0);
var state_63180__$1 = (function (){var statearr_63186 = state_63180;
(statearr_63186[(8)] = inst_63096);

return statearr_63186;
})();
var statearr_63187_63236 = state_63180__$1;
(statearr_63187_63236[(2)] = null);

(statearr_63187_63236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (24))){
var inst_63107 = (state_63180[(9)]);
var inst_63156 = fluree.db.util.core.exception_QMARK_(inst_63107);
var state_63180__$1 = state_63180;
if(inst_63156){
var statearr_63188_63237 = state_63180__$1;
(statearr_63188_63237[(1)] = (26));

} else {
var statearr_63189_63238 = state_63180__$1;
(statearr_63189_63238[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (4))){
var inst_63101 = (state_63180[(10)]);
var inst_63106 = (state_63180[(2)]);
var inst_63107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63106,(0),null);
var inst_63108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63106,(1),null);
var inst_63109 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63108,inst_63101);
var state_63180__$1 = (function (){var statearr_63190 = state_63180;
(statearr_63190[(9)] = inst_63107);

return statearr_63190;
})();
if(inst_63109){
var statearr_63191_63239 = state_63180__$1;
(statearr_63191_63239[(1)] = (5));

} else {
var statearr_63192_63240 = state_63180__$1;
(statearr_63192_63240[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (15))){
var inst_63114 = (state_63180[(7)]);
var inst_63123 = typeof inst_63114 === 'string';
var state_63180__$1 = state_63180;
if(cljs.core.truth_(inst_63123)){
var statearr_63193_63241 = state_63180__$1;
(statearr_63193_63241[(1)] = (17));

} else {
var statearr_63194_63242 = state_63180__$1;
(statearr_63194_63242[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (21))){
var state_63180__$1 = state_63180;
var statearr_63195_63243 = state_63180__$1;
(statearr_63195_63243[(2)] = null);

(statearr_63195_63243[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (31))){
var inst_63170 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63196_63244 = state_63180__$1;
(statearr_63196_63244[(2)] = inst_63170);

(statearr_63196_63244[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (13))){
var inst_63140 = (state_63180[(2)]);
var inst_63141 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63142 = fluree.db.connection.close_websocket(inst_63141);
var inst_63143 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63144 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_63143);
var state_63180__$1 = (function (){var statearr_63197 = state_63180;
(statearr_63197[(11)] = inst_63140);

(statearr_63197[(12)] = inst_63142);

return statearr_63197;
})();
var statearr_63198_63245 = state_63180__$1;
(statearr_63198_63245[(2)] = inst_63144);

(statearr_63198_63245[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (22))){
var inst_63134 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63199_63246 = state_63180__$1;
(statearr_63199_63246[(2)] = inst_63134);

(statearr_63199_63246[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (29))){
var inst_63107 = (state_63180[(9)]);
var inst_63162 = fluree.db.util.json.parse(inst_63107);
var inst_63163 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63162], 0));
var inst_63164 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_63163], 0));
var inst_63165 = fluree.db.util.json.parse(inst_63107);
var inst_63166 = fluree.db.conn_events.process_events(conn,inst_63165);
var inst_63096 = (0);
var state_63180__$1 = (function (){var statearr_63200 = state_63180;
(statearr_63200[(13)] = inst_63166);

(statearr_63200[(14)] = inst_63164);

(statearr_63200[(8)] = inst_63096);

return statearr_63200;
})();
var statearr_63201_63247 = state_63180__$1;
(statearr_63201_63247[(2)] = null);

(statearr_63201_63247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (6))){
var inst_63107 = (state_63180[(9)]);
var inst_63152 = (inst_63107 == null);
var state_63180__$1 = state_63180;
if(cljs.core.truth_(inst_63152)){
var statearr_63202_63248 = state_63180__$1;
(statearr_63202_63248[(1)] = (23));

} else {
var statearr_63203_63249 = state_63180__$1;
(statearr_63203_63249[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (28))){
var inst_63172 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63204_63250 = state_63180__$1;
(statearr_63204_63250[(2)] = inst_63172);

(statearr_63204_63250[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (25))){
var inst_63174 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63205_63251 = state_63180__$1;
(statearr_63205_63251[(2)] = inst_63174);

(statearr_63205_63251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (17))){
var inst_63114 = (state_63180[(7)]);
var inst_63125 = cljs.core.eval(inst_63114);
var state_63180__$1 = state_63180;
var statearr_63206_63252 = state_63180__$1;
(statearr_63206_63252[(2)] = inst_63125);

(statearr_63206_63252[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (3))){
var inst_63178 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63180__$1,inst_63178);
} else {
if((state_val_63181 === (12))){
var inst_63114 = (state_63180[(7)]);
var inst_63119 = cljs.core.fn_QMARK_(inst_63114);
var state_63180__$1 = state_63180;
if(inst_63119){
var statearr_63207_63253 = state_63180__$1;
(statearr_63207_63253[(1)] = (14));

} else {
var statearr_63208_63254 = state_63180__$1;
(statearr_63208_63254[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (2))){
var inst_63101 = (state_63180[(10)]);
var inst_63101__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_63102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63103 = [sub_chan,inst_63101__$1];
var inst_63104 = (new cljs.core.PersistentVector(null,2,(5),inst_63102,inst_63103,null));
var state_63180__$1 = (function (){var statearr_63209 = state_63180;
(statearr_63209[(10)] = inst_63101__$1);

return statearr_63209;
})();
return cljs.core.async.ioc_alts_BANG_(state_63180__$1,(4),inst_63104);
} else {
if((state_val_63181 === (23))){
var inst_63154 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_63180__$1 = state_63180;
var statearr_63210_63255 = state_63180__$1;
(statearr_63210_63255[(2)] = inst_63154);

(statearr_63210_63255[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (19))){
var inst_63136 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63211_63256 = state_63180__$1;
(statearr_63211_63256[(2)] = inst_63136);

(statearr_63211_63256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (11))){
var inst_63117 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_63180__$1 = state_63180;
var statearr_63212_63257 = state_63180__$1;
(statearr_63212_63257[(2)] = inst_63117);

(statearr_63212_63257[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (9))){
var inst_63096 = (state_63180[(8)]);
var inst_63146 = fluree.db.connection.ping_transactor(conn);
var inst_63147 = (inst_63096 + (1));
var inst_63096__$1 = inst_63147;
var state_63180__$1 = (function (){var statearr_63213 = state_63180;
(statearr_63213[(15)] = inst_63146);

(statearr_63213[(8)] = inst_63096__$1);

return statearr_63213;
})();
var statearr_63214_63258 = state_63180__$1;
(statearr_63214_63258[(2)] = null);

(statearr_63214_63258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (5))){
var inst_63096 = (state_63180[(8)]);
var inst_63111 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_63096);
var state_63180__$1 = state_63180;
if(inst_63111){
var statearr_63215_63259 = state_63180__$1;
(statearr_63215_63259[(1)] = (8));

} else {
var statearr_63216_63260 = state_63180__$1;
(statearr_63216_63260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (14))){
var inst_63114 = (state_63180[(7)]);
var inst_63121 = (inst_63114.cljs$core$IFn$_invoke$arity$0 ? inst_63114.cljs$core$IFn$_invoke$arity$0() : inst_63114.call(null));
var state_63180__$1 = state_63180;
var statearr_63217_63261 = state_63180__$1;
(statearr_63217_63261[(2)] = inst_63121);

(statearr_63217_63261[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (26))){
var inst_63107 = (state_63180[(9)]);
var inst_63158 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63107], 0));
var inst_63096 = (0);
var state_63180__$1 = (function (){var statearr_63218 = state_63180;
(statearr_63218[(16)] = inst_63158);

(statearr_63218[(8)] = inst_63096);

return statearr_63218;
})();
var statearr_63219_63262 = state_63180__$1;
(statearr_63219_63262[(2)] = null);

(statearr_63219_63262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (16))){
var inst_63138 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63220_63263 = state_63180__$1;
(statearr_63220_63263[(2)] = inst_63138);

(statearr_63220_63263[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (30))){
var state_63180__$1 = state_63180;
var statearr_63221_63264 = state_63180__$1;
(statearr_63221_63264[(2)] = null);

(statearr_63221_63264[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (10))){
var inst_63150 = (state_63180[(2)]);
var state_63180__$1 = state_63180;
var statearr_63222_63265 = state_63180__$1;
(statearr_63222_63265[(2)] = inst_63150);

(statearr_63222_63265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (18))){
var state_63180__$1 = state_63180;
var statearr_63223_63266 = state_63180__$1;
(statearr_63223_63266[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63181 === (8))){
var inst_63114 = (state_63180[(7)]);
var inst_63113 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_63114__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63115 = (inst_63114__$1 == null);
var state_63180__$1 = (function (){var statearr_63225 = state_63180;
(statearr_63225[(7)] = inst_63114__$1);

(statearr_63225[(17)] = inst_63113);

return statearr_63225;
})();
if(cljs.core.truth_(inst_63115)){
var statearr_63226_63267 = state_63180__$1;
(statearr_63226_63267[(1)] = (11));

} else {
var statearr_63227_63268 = state_63180__$1;
(statearr_63227_63268[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_63228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63228[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_63228[(1)] = (1));

return statearr_63228;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_63180){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63180);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63229){var ex__2730__auto__ = e63229;
var statearr_63230_63269 = state_63180;
(statearr_63230_63269[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63180[(4)]))){
var statearr_63231_63270 = state_63180;
(statearr_63231_63270[(1)] = cljs.core.first((state_63180[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63271 = state_63180;
state_63180 = G__63271;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_63180){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_63180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63232 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63232[(6)] = c__2749__auto__);

return statearr_63232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__63273 = arguments.length;
switch (G__63273) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__63274 = opts;
var map__63274__$1 = cljs.core.__destructure_map(map__63274);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63274__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63274__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63326){
var state_val_63327 = (state_63326[(1)]);
if((state_val_63327 === (7))){
var inst_63284 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_63285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63286 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63287 = (new cljs.core.PersistentVector(null,2,(5),inst_63285,inst_63286,null));
var inst_63288 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63284,inst_63287);
var state_63326__$1 = state_63326;
var statearr_63328_63359 = state_63326__$1;
(statearr_63328_63359[(2)] = inst_63288);

(statearr_63328_63359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (1))){
var state_63326__$1 = state_63326;
var statearr_63329_63360 = state_63326__$1;
(statearr_63329_63360[(2)] = null);

(statearr_63329_63360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (4))){
var inst_63275 = (state_63326[(2)]);
var state_63326__$1 = state_63326;
var statearr_63330_63361 = state_63326__$1;
(statearr_63330_63361[(2)] = inst_63275);

(statearr_63330_63361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (15))){
var inst_63295 = (state_63326[(7)]);
var inst_63314 = (state_63326[(2)]);
var inst_63315 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_63316 = [(5000),inst_63314,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_63317 = cljs.core.PersistentHashMap.fromArrays(inst_63315,inst_63316);
var inst_63318 = fluree.db.util.xhttp.get(inst_63295,inst_63317);
var state_63326__$1 = state_63326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63326__$1,(16),inst_63318);
} else {
if((state_val_63327 === (13))){
var inst_63305 = (state_63326[(8)]);
var inst_63295 = (state_63326[(7)]);
var inst_63307 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_63308 = [inst_63305];
var inst_63309 = cljs.core.PersistentHashMap.fromArrays(inst_63307,inst_63308);
var inst_63310 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_63295,inst_63309,private$);
var inst_63311 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_63310);
var state_63326__$1 = state_63326;
var statearr_63331_63362 = state_63326__$1;
(statearr_63331_63362[(2)] = inst_63311);

(statearr_63331_63362[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (6))){
var inst_63281 = (state_63326[(9)]);
var state_63326__$1 = state_63326;
var statearr_63332_63363 = state_63326__$1;
(statearr_63332_63363[(2)] = inst_63281);

(statearr_63332_63363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (3))){
var inst_63324 = (state_63326[(2)]);
var state_63326__$1 = state_63326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63326__$1,inst_63324);
} else {
if((state_val_63327 === (12))){
var inst_63305 = (state_63326[(2)]);
var state_63326__$1 = (function (){var statearr_63333 = state_63326;
(statearr_63333[(8)] = inst_63305);

return statearr_63333;
})();
if(cljs.core.truth_(private$)){
var statearr_63334_63364 = state_63326__$1;
(statearr_63334_63364[(1)] = (13));

} else {
var statearr_63335_63365 = state_63326__$1;
(statearr_63335_63365[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (2))){
var inst_63281 = (state_63326[(9)]);
var _ = (function (){var statearr_63336 = state_63326;
(statearr_63336[(4)] = cljs.core.cons((5),(state_63326[(4)])));

return statearr_63336;
})();
var inst_63281__$1 = jwt;
var state_63326__$1 = (function (){var statearr_63337 = state_63326;
(statearr_63337[(9)] = inst_63281__$1);

return statearr_63337;
})();
if(cljs.core.truth_(inst_63281__$1)){
var statearr_63338_63366 = state_63326__$1;
(statearr_63338_63366[(1)] = (6));

} else {
var statearr_63339_63367 = state_63326__$1;
(statearr_63339_63367[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (11))){
var inst_63299 = (state_63326[(10)]);
var state_63326__$1 = state_63326;
var statearr_63341_63368 = state_63326__$1;
(statearr_63341_63368[(2)] = inst_63299);

(statearr_63341_63368[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (9))){
var inst_63291 = (state_63326[(11)]);
var inst_63290 = (state_63326[(12)]);
var inst_63294 = (state_63326[(2)]);
var inst_63295 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63294),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63291)].join('');
var inst_63297 = ["Accept"];
var inst_63298 = ["application/json"];
var inst_63299 = cljs.core.PersistentHashMap.fromArrays(inst_63297,inst_63298);
var state_63326__$1 = (function (){var statearr_63342 = state_63326;
(statearr_63342[(10)] = inst_63299);

(statearr_63342[(7)] = inst_63295);

return statearr_63342;
})();
if(cljs.core.truth_(inst_63290)){
var statearr_63343_63369 = state_63326__$1;
(statearr_63343_63369[(1)] = (10));

} else {
var statearr_63344_63370 = state_63326__$1;
(statearr_63344_63370[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (5))){
var _ = (function (){var statearr_63345 = state_63326;
(statearr_63345[(4)] = cljs.core.rest((state_63326[(4)])));

return statearr_63345;
})();
var state_63326__$1 = state_63326;
var ex63340 = (state_63326__$1[(2)]);
var statearr_63346_63371 = state_63326__$1;
(statearr_63346_63371[(5)] = ex63340);


if((ex63340 instanceof Error)){
var statearr_63347_63372 = state_63326__$1;
(statearr_63347_63372[(1)] = (4));

(statearr_63347_63372[(5)] = null);

} else {
throw ex63340;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (14))){
var inst_63305 = (state_63326[(8)]);
var state_63326__$1 = state_63326;
var statearr_63348_63373 = state_63326__$1;
(statearr_63348_63373[(2)] = inst_63305);

(statearr_63348_63373[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (16))){
var inst_63320 = (state_63326[(2)]);
var inst_63321 = fluree.db.util.async.throw_err(inst_63320);
var _ = (function (){var statearr_63349 = state_63326;
(statearr_63349[(4)] = cljs.core.rest((state_63326[(4)])));

return statearr_63349;
})();
var state_63326__$1 = state_63326;
var statearr_63350_63374 = state_63326__$1;
(statearr_63350_63374[(2)] = inst_63321);

(statearr_63350_63374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (10))){
var inst_63299 = (state_63326[(10)]);
var inst_63290 = (state_63326[(12)]);
var inst_63301 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63290)].join('');
var inst_63302 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63299,"Authorization",inst_63301);
var state_63326__$1 = state_63326;
var statearr_63351_63375 = state_63326__$1;
(statearr_63351_63375[(2)] = inst_63302);

(statearr_63351_63375[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (8))){
var inst_63290 = (state_63326[(2)]);
var inst_63291 = clojure.string.replace(k,"_","/");
var inst_63292 = fluree.db.connection.get_server(conn_id,servers);
var state_63326__$1 = (function (){var statearr_63352 = state_63326;
(statearr_63352[(11)] = inst_63291);

(statearr_63352[(12)] = inst_63290);

return statearr_63352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63326__$1,(9),inst_63292);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_63353 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63353[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_63353[(1)] = (1));

return statearr_63353;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_63326){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63326);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63354){var ex__2730__auto__ = e63354;
var statearr_63355_63376 = state_63326;
(statearr_63355_63376[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63326[(4)]))){
var statearr_63356_63377 = state_63326;
(statearr_63356_63377[(1)] = cljs.core.first((state_63326[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63378 = state_63326;
state_63326 = G__63378;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_63326){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_63326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63357 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63357[(6)] = c__2749__auto__);

return statearr_63357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63379_SHARP_){
if(cljs.core.truth_(p1__63379_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__63380_SHARP_){
var or__5045__auto__ = p1__63380_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e63381){var e = e63381;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63382 = opts;
var map__63382__$1 = cljs.core.__destructure_map(map__63382);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63382__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63382__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__63383_63384 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__63383_63384.cljs$core$IFn$_invoke$arity$0 ? fexpr__63383_63384.cljs$core$IFn$_invoke$arity$0() : fexpr__63383_63384.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63425 = arguments.length;
var i__5770__auto___63426 = (0);
while(true){
if((i__5770__auto___63426 < len__5769__auto___63425)){
args__5775__auto__.push((arguments[i__5770__auto___63426]));

var G__63427 = (i__5770__auto___63426 + (1));
i__5770__auto___63426 = G__63427;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63387){
var vec__63388 = p__63387;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63388,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___63428 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63408){
var state_val_63409 = (state_63408[(1)]);
if((state_val_63409 === (1))){
var inst_63391 = fluree.db.connection.get_socket(conn);
var state_63408__$1 = state_63408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63408__$1,(2),inst_63391);
} else {
if((state_val_63409 === (2))){
var inst_63393 = (state_63408[(7)]);
var inst_63394 = (state_63408[(8)]);
var inst_63393__$1 = (state_63408[(2)]);
var inst_63394__$1 = (inst_63393__$1 == null);
var state_63408__$1 = (function (){var statearr_63410 = state_63408;
(statearr_63410[(7)] = inst_63393__$1);

(statearr_63410[(8)] = inst_63394__$1);

return statearr_63410;
})();
if(cljs.core.truth_(inst_63394__$1)){
var statearr_63411_63429 = state_63408__$1;
(statearr_63411_63429[(1)] = (3));

} else {
var statearr_63412_63430 = state_63408__$1;
(statearr_63412_63430[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63409 === (3))){
var inst_63394 = (state_63408[(8)]);
var state_63408__$1 = state_63408;
var statearr_63413_63431 = state_63408__$1;
(statearr_63413_63431[(2)] = inst_63394);

(statearr_63413_63431[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63409 === (4))){
var inst_63393 = (state_63408[(7)]);
var inst_63397 = fluree.db.util.core.exception_QMARK_(inst_63393);
var state_63408__$1 = state_63408;
var statearr_63414_63432 = state_63408__$1;
(statearr_63414_63432[(2)] = inst_63397);

(statearr_63414_63432[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63409 === (5))){
var inst_63399 = (state_63408[(2)]);
var state_63408__$1 = state_63408;
if(cljs.core.truth_(inst_63399)){
var statearr_63415_63433 = state_63408__$1;
(statearr_63415_63433[(1)] = (6));

} else {
var statearr_63416_63434 = state_63408__$1;
(statearr_63416_63434[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63409 === (6))){
var inst_63393 = (state_63408[(7)]);
var inst_63401 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63393,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_63402 = cljs.core.async.close_BANG_(conn);
var state_63408__$1 = (function (){var statearr_63417 = state_63408;
(statearr_63417[(9)] = inst_63401);

return statearr_63417;
})();
var statearr_63418_63435 = state_63408__$1;
(statearr_63418_63435[(2)] = inst_63402);

(statearr_63418_63435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63409 === (7))){
var inst_63404 = fluree.db.connection.msg_consumer(conn);
var state_63408__$1 = state_63408;
var statearr_63419_63436 = state_63408__$1;
(statearr_63419_63436[(2)] = inst_63404);

(statearr_63419_63436[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63409 === (8))){
var inst_63406 = (state_63408[(2)]);
var state_63408__$1 = state_63408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63408__$1,inst_63406);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_63420 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63420[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_63420[(1)] = (1));

return statearr_63420;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_63408){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63408);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63421){var ex__2730__auto__ = e63421;
var statearr_63422_63437 = state_63408;
(statearr_63422_63437[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63408[(4)]))){
var statearr_63423_63438 = state_63408;
(statearr_63423_63438[(1)] = cljs.core.first((state_63408[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63439 = state_63408;
state_63408 = G__63439;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_63408){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_63408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63424 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63424[(6)] = c__2749__auto___63428);

return statearr_63424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63385){
var G__63386 = cljs.core.first(seq63385);
var seq63385__$1 = cljs.core.next(seq63385);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63386,seq63385__$1);
}));

