// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__65963 = arguments.length;
switch (G__65963) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___66002 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65984){
var state_val_65985 = (state_65984[(1)]);
if((state_val_65985 === (1))){
var state_65984__$1 = state_65984;
var statearr_65986_66003 = state_65984__$1;
(statearr_65986_66003[(2)] = null);

(statearr_65986_66003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65985 === (2))){
var _ = (function (){var statearr_65987 = state_65984;
(statearr_65987[(4)] = cljs.core.cons((5),(state_65984[(4)])));

return statearr_65987;
})();
var inst_65970 = fluree.db.session.db(conn,ledger,null);
var state_65984__$1 = state_65984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65984__$1,(7),inst_65970);
} else {
if((state_val_65985 === (3))){
var inst_65980 = (state_65984[(2)]);
var inst_65981 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65980);
var inst_65982 = cljs.core.async.close_BANG_(pc);
var state_65984__$1 = (function (){var statearr_65989 = state_65984;
(statearr_65989[(7)] = inst_65981);

return statearr_65989;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65984__$1,inst_65982);
} else {
if((state_val_65985 === (4))){
var inst_65964 = (state_65984[(2)]);
var state_65984__$1 = state_65984;
var statearr_65990_66004 = state_65984__$1;
(statearr_65990_66004[(2)] = inst_65964);

(statearr_65990_66004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65985 === (5))){
var _ = (function (){var statearr_65991 = state_65984;
(statearr_65991[(4)] = cljs.core.rest((state_65984[(4)])));

return statearr_65991;
})();
var state_65984__$1 = state_65984;
var ex65988 = (state_65984__$1[(2)]);
var statearr_65992_66005 = state_65984__$1;
(statearr_65992_66005[(5)] = ex65988);


var statearr_65993_66006 = state_65984__$1;
(statearr_65993_66006[(1)] = (4));

(statearr_65993_66006[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65985 === (6))){
var inst_65976 = (state_65984[(2)]);
var inst_65977 = fluree.db.util.async.throw_err(inst_65976);
var _ = (function (){var statearr_65994 = state_65984;
(statearr_65994[(4)] = cljs.core.rest((state_65984[(4)])));

return statearr_65994;
})();
var state_65984__$1 = state_65984;
var statearr_65995_66007 = state_65984__$1;
(statearr_65995_66007[(2)] = inst_65977);

(statearr_65995_66007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65985 === (7))){
var inst_65972 = (state_65984[(2)]);
var inst_65973 = fluree.db.util.async.throw_err(inst_65972);
var inst_65974 = fluree.db.time_travel.as_of_block(inst_65973,block);
var state_65984__$1 = state_65984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65984__$1,(6),inst_65974);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_65996 = [null,null,null,null,null,null,null,null];
(statearr_65996[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_65996[(1)] = (1));

return statearr_65996;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_65984){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65984);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65997){var ex__2687__auto__ = e65997;
var statearr_65998_66008 = state_65984;
(statearr_65998_66008[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65984[(4)]))){
var statearr_65999_66009 = state_65984;
(statearr_65999_66009[(1)] = cljs.core.first((state_65984[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66010 = state_65984;
state_65984 = G__66010;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_65984){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_65984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66000 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66000[(6)] = c__2706__auto___66002);

return statearr_66000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66051){
var state_val_66052 = (state_66051[(1)]);
if((state_val_66052 === (7))){
var inst_66020 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66051__$1 = state_66051;
if(inst_66020){
var statearr_66053_66084 = state_66051__$1;
(statearr_66053_66084[(1)] = (9));

} else {
var statearr_66054_66085 = state_66051__$1;
(statearr_66054_66085[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (1))){
var state_66051__$1 = state_66051;
var statearr_66055_66086 = state_66051__$1;
(statearr_66055_66086[(2)] = null);

(statearr_66055_66086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (4))){
var inst_66011 = (state_66051[(2)]);
var state_66051__$1 = state_66051;
var statearr_66056_66087 = state_66051__$1;
(statearr_66056_66087[(2)] = inst_66011);

(statearr_66056_66087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (15))){
var inst_66028 = (state_66051[(7)]);
var inst_66027 = (state_66051[(2)]);
var inst_66028__$1 = fluree.db.util.async.throw_err(inst_66027);
var state_66051__$1 = (function (){var statearr_66057 = state_66051;
(statearr_66057[(7)] = inst_66028__$1);

return statearr_66057;
})();
if(cljs.core.truth_(inst_66028__$1)){
var statearr_66058_66088 = state_66051__$1;
(statearr_66058_66088[(1)] = (16));

} else {
var statearr_66059_66089 = state_66051__$1;
(statearr_66059_66089[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (13))){
var state_66051__$1 = state_66051;
var statearr_66060_66090 = state_66051__$1;
(statearr_66060_66090[(2)] = null);

(statearr_66060_66090[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (6))){
var state_66051__$1 = state_66051;
var statearr_66061_66091 = state_66051__$1;
(statearr_66061_66091[(2)] = db);

(statearr_66061_66091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (17))){
var inst_66032 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66033 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66034 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66035 = cljs.core.PersistentHashMap.fromArrays(inst_66033,inst_66034);
var inst_66036 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66032,inst_66035);
var inst_66037 = (function(){throw inst_66036})();
var state_66051__$1 = state_66051;
var statearr_66062_66092 = state_66051__$1;
(statearr_66062_66092[(2)] = inst_66037);

(statearr_66062_66092[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (3))){
var inst_66049 = (state_66051[(2)]);
var state_66051__$1 = state_66051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66051__$1,inst_66049);
} else {
if((state_val_66052 === (12))){
var inst_66025 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66051__$1 = state_66051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66051__$1,(15),inst_66025);
} else {
if((state_val_66052 === (2))){
var _ = (function (){var statearr_66063 = state_66051;
(statearr_66063[(4)] = cljs.core.cons((5),(state_66051[(4)])));

return statearr_66063;
})();
var inst_66017 = cljs.core.not(auth);
var state_66051__$1 = state_66051;
if(inst_66017){
var statearr_66064_66093 = state_66051__$1;
(statearr_66064_66093[(1)] = (6));

} else {
var statearr_66065_66094 = state_66051__$1;
(statearr_66065_66094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (11))){
var inst_66044 = (state_66051[(2)]);
var state_66051__$1 = state_66051;
var statearr_66067_66095 = state_66051__$1;
(statearr_66067_66095[(2)] = inst_66044);

(statearr_66067_66095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (9))){
var inst_66022 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_66051__$1 = state_66051;
var statearr_66068_66096 = state_66051__$1;
(statearr_66068_66096[(2)] = inst_66022);

(statearr_66068_66096[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (5))){
var _ = (function (){var statearr_66069 = state_66051;
(statearr_66069[(4)] = cljs.core.rest((state_66051[(4)])));

return statearr_66069;
})();
var state_66051__$1 = state_66051;
var ex66066 = (state_66051__$1[(2)]);
var statearr_66070_66097 = state_66051__$1;
(statearr_66070_66097[(5)] = ex66066);


if((ex66066 instanceof Error)){
var statearr_66071_66098 = state_66051__$1;
(statearr_66071_66098[(1)] = (4));

(statearr_66071_66098[(5)] = null);

} else {
throw ex66066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (14))){
var inst_66042 = (state_66051[(2)]);
var state_66051__$1 = state_66051;
var statearr_66072_66099 = state_66051__$1;
(statearr_66072_66099[(2)] = inst_66042);

(statearr_66072_66099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (16))){
var inst_66028 = (state_66051[(7)]);
var inst_66030 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66028);
var state_66051__$1 = state_66051;
var statearr_66073_66100 = state_66051__$1;
(statearr_66073_66100[(2)] = inst_66030);

(statearr_66073_66100[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (10))){
var state_66051__$1 = state_66051;
var statearr_66074_66101 = state_66051__$1;
(statearr_66074_66101[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (18))){
var inst_66039 = (state_66051[(2)]);
var state_66051__$1 = state_66051;
var statearr_66076_66102 = state_66051__$1;
(statearr_66076_66102[(2)] = inst_66039);

(statearr_66076_66102[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (8))){
var inst_66046 = (state_66051[(2)]);
var _ = (function (){var statearr_66077 = state_66051;
(statearr_66077[(4)] = cljs.core.rest((state_66051[(4)])));

return statearr_66077;
})();
var state_66051__$1 = state_66051;
var statearr_66078_66103 = state_66051__$1;
(statearr_66078_66103[(2)] = inst_66046);

(statearr_66078_66103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0 = (function (){
var statearr_66079 = [null,null,null,null,null,null,null,null];
(statearr_66079[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__);

(statearr_66079[(1)] = (1));

return statearr_66079;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1 = (function (state_66051){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66051);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66080){var ex__2687__auto__ = e66080;
var statearr_66081_66104 = state_66051;
(statearr_66081_66104[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66051[(4)]))){
var statearr_66082_66105 = state_66051;
(statearr_66082_66105[(1)] = cljs.core.first((state_66051[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66106 = state_66051;
state_66051 = G__66106;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = function(state_66051){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1.call(this,state_66051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66083 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66083[(6)] = c__2706__auto__);

return statearr_66083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66170){
var state_val_66171 = (state_66170[(1)]);
if((state_val_66171 === (7))){
var inst_66116 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66170__$1 = state_66170;
if(inst_66116){
var statearr_66172_66221 = state_66170__$1;
(statearr_66172_66221[(1)] = (9));

} else {
var statearr_66173_66222 = state_66170__$1;
(statearr_66173_66222[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (20))){
var inst_66140 = (state_66170[(7)]);
var state_66170__$1 = state_66170;
if(cljs.core.truth_(inst_66140)){
var statearr_66174_66223 = state_66170__$1;
(statearr_66174_66223[(1)] = (22));

} else {
var statearr_66175_66224 = state_66170__$1;
(statearr_66175_66224[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (27))){
var state_66170__$1 = state_66170;
var statearr_66176_66225 = state_66170__$1;
(statearr_66176_66225[(2)] = null);

(statearr_66176_66225[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (1))){
var state_66170__$1 = state_66170;
var statearr_66177_66226 = state_66170__$1;
(statearr_66177_66226[(2)] = null);

(statearr_66177_66226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (24))){
var inst_66154 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
var statearr_66178_66227 = state_66170__$1;
(statearr_66178_66227[(2)] = inst_66154);

(statearr_66178_66227[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (4))){
var inst_66107 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
var statearr_66179_66228 = state_66170__$1;
(statearr_66179_66228[(2)] = inst_66107);

(statearr_66179_66228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (15))){
var inst_66123 = (state_66170[(8)]);
var inst_66122 = (state_66170[(2)]);
var inst_66123__$1 = fluree.db.util.async.throw_err(inst_66122);
var state_66170__$1 = (function (){var statearr_66180 = state_66170;
(statearr_66180[(8)] = inst_66123__$1);

return statearr_66180;
})();
if(cljs.core.truth_(inst_66123__$1)){
var statearr_66181_66229 = state_66170__$1;
(statearr_66181_66229[(1)] = (16));

} else {
var statearr_66182_66230 = state_66170__$1;
(statearr_66182_66230[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (21))){
var inst_66156 = (state_66170[(9)]);
var inst_66156__$1 = (state_66170[(2)]);
var state_66170__$1 = (function (){var statearr_66183 = state_66170;
(statearr_66183[(9)] = inst_66156__$1);

return statearr_66183;
})();
if(cljs.core.truth_(inst_66156__$1)){
var statearr_66184_66231 = state_66170__$1;
(statearr_66184_66231[(1)] = (29));

} else {
var statearr_66185_66232 = state_66170__$1;
(statearr_66185_66232[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (31))){
var inst_66156 = (state_66170[(9)]);
var inst_66140 = (state_66170[(7)]);
var inst_66164 = (state_66170[(2)]);
var inst_66165 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66140,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_66156,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_66164], 0));
var _ = (function (){var statearr_66186 = state_66170;
(statearr_66186[(4)] = cljs.core.rest((state_66170[(4)])));

return statearr_66186;
})();
var state_66170__$1 = state_66170;
var statearr_66187_66233 = state_66170__$1;
(statearr_66187_66233[(2)] = inst_66165);

(statearr_66187_66233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (32))){
var inst_66160 = (state_66170[(2)]);
var inst_66161 = fluree.db.util.async.throw_err(inst_66160);
var state_66170__$1 = state_66170;
var statearr_66188_66234 = state_66170__$1;
(statearr_66188_66234[(2)] = inst_66161);

(statearr_66188_66234[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (13))){
var state_66170__$1 = state_66170;
var statearr_66189_66235 = state_66170__$1;
(statearr_66189_66235[(2)] = null);

(statearr_66189_66235[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (22))){
var inst_66140 = (state_66170[(7)]);
var inst_66144 = fluree.db.auth.roles(db,inst_66140);
var state_66170__$1 = state_66170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66170__$1,(25),inst_66144);
} else {
if((state_val_66171 === (29))){
var inst_66156 = (state_66170[(9)]);
var inst_66158 = fluree.db.permissions.permission_map(db,inst_66156,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66170__$1 = state_66170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66170__$1,(32),inst_66158);
} else {
if((state_val_66171 === (6))){
var state_66170__$1 = state_66170;
var statearr_66190_66236 = state_66170__$1;
(statearr_66190_66236[(2)] = null);

(statearr_66190_66236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (28))){
var inst_66152 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
var statearr_66191_66237 = state_66170__$1;
(statearr_66191_66237[(2)] = inst_66152);

(statearr_66191_66237[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (25))){
var inst_66146 = (state_66170[(2)]);
var inst_66147 = fluree.db.util.async.throw_err(inst_66146);
var state_66170__$1 = state_66170;
var statearr_66192_66238 = state_66170__$1;
(statearr_66192_66238[(2)] = inst_66147);

(statearr_66192_66238[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (17))){
var inst_66126 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66127 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66128 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66129 = cljs.core.PersistentHashMap.fromArrays(inst_66127,inst_66128);
var inst_66130 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66126,inst_66129);
var inst_66131 = (function(){throw inst_66130})();
var state_66170__$1 = state_66170;
var statearr_66193_66239 = state_66170__$1;
(statearr_66193_66239[(2)] = inst_66131);

(statearr_66193_66239[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (3))){
var inst_66168 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66170__$1,inst_66168);
} else {
if((state_val_66171 === (12))){
var inst_66120 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66170__$1 = state_66170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66170__$1,(15),inst_66120);
} else {
if((state_val_66171 === (2))){
var _ = (function (){var statearr_66194 = state_66170;
(statearr_66194[(4)] = cljs.core.cons((5),(state_66170[(4)])));

return statearr_66194;
})();
var inst_66113 = (auth == null);
var state_66170__$1 = state_66170;
if(cljs.core.truth_(inst_66113)){
var statearr_66195_66240 = state_66170__$1;
(statearr_66195_66240[(1)] = (6));

} else {
var statearr_66196_66241 = state_66170__$1;
(statearr_66196_66241[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (23))){
var state_66170__$1 = state_66170;
var statearr_66197_66242 = state_66170__$1;
(statearr_66197_66242[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (19))){
var state_66170__$1 = state_66170;
var statearr_66199_66243 = state_66170__$1;
(statearr_66199_66243[(2)] = roles);

(statearr_66199_66243[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (11))){
var inst_66138 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
var statearr_66201_66244 = state_66170__$1;
(statearr_66201_66244[(2)] = inst_66138);

(statearr_66201_66244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (9))){
var state_66170__$1 = state_66170;
var statearr_66202_66245 = state_66170__$1;
(statearr_66202_66245[(2)] = (0));

(statearr_66202_66245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (5))){
var _ = (function (){var statearr_66203 = state_66170;
(statearr_66203[(4)] = cljs.core.rest((state_66170[(4)])));

return statearr_66203;
})();
var state_66170__$1 = state_66170;
var ex66200 = (state_66170__$1[(2)]);
var statearr_66204_66246 = state_66170__$1;
(statearr_66204_66246[(5)] = ex66200);


if((ex66200 instanceof Error)){
var statearr_66205_66247 = state_66170__$1;
(statearr_66205_66247[(1)] = (4));

(statearr_66205_66247[(5)] = null);

} else {
throw ex66200;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (14))){
var inst_66136 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
var statearr_66206_66248 = state_66170__$1;
(statearr_66206_66248[(2)] = inst_66136);

(statearr_66206_66248[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (26))){
var state_66170__$1 = state_66170;
var statearr_66207_66249 = state_66170__$1;
(statearr_66207_66249[(2)] = null);

(statearr_66207_66249[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (16))){
var inst_66123 = (state_66170[(8)]);
var state_66170__$1 = state_66170;
var statearr_66208_66250 = state_66170__$1;
(statearr_66208_66250[(2)] = inst_66123);

(statearr_66208_66250[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (30))){
var state_66170__$1 = state_66170;
var statearr_66209_66251 = state_66170__$1;
(statearr_66209_66251[(2)] = null);

(statearr_66209_66251[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (10))){
var state_66170__$1 = state_66170;
if(cljs.core.truth_(auth)){
var statearr_66210_66252 = state_66170__$1;
(statearr_66210_66252[(1)] = (12));

} else {
var statearr_66211_66253 = state_66170__$1;
(statearr_66211_66253[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (18))){
var inst_66133 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
var statearr_66212_66254 = state_66170__$1;
(statearr_66212_66254[(2)] = inst_66133);

(statearr_66212_66254[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (8))){
var inst_66140 = (state_66170[(2)]);
var state_66170__$1 = (function (){var statearr_66213 = state_66170;
(statearr_66213[(7)] = inst_66140);

return statearr_66213;
})();
if(cljs.core.truth_(roles)){
var statearr_66214_66255 = state_66170__$1;
(statearr_66214_66255[(1)] = (19));

} else {
var statearr_66215_66256 = state_66170__$1;
(statearr_66215_66256[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0 = (function (){
var statearr_66216 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66216[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__);

(statearr_66216[(1)] = (1));

return statearr_66216;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1 = (function (state_66170){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66170);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66217){var ex__2687__auto__ = e66217;
var statearr_66218_66257 = state_66170;
(statearr_66218_66257[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66170[(4)]))){
var statearr_66219_66258 = state_66170;
(statearr_66219_66258[(1)] = cljs.core.first((state_66170[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66259 = state_66170;
state_66170 = G__66259;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = function(state_66170){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1.call(this,state_66170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66220 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66220[(6)] = c__2706__auto__);

return statearr_66220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__66260 = db;
var map__66260__$1 = cljs.core.__destructure_map(map__66260);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66260__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66260__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66260__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66267){
var state_val_66268 = (state_66267[(1)]);
if((state_val_66268 === (1))){
var inst_66261 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66262 = fluree.db.session.db(conn,inst_66261,null);
var state_66267__$1 = state_66267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66267__$1,(2),inst_66262);
} else {
if((state_val_66268 === (2))){
var inst_66264 = (state_66267[(2)]);
var inst_66265 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66264);
var state_66267__$1 = state_66267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66267__$1,inst_66265);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_66269 = [null,null,null,null,null,null,null];
(statearr_66269[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_66269[(1)] = (1));

return statearr_66269;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_66267){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66267);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66270){var ex__2687__auto__ = e66270;
var statearr_66271_66298 = state_66267;
(statearr_66271_66298[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66267[(4)]))){
var statearr_66272_66299 = state_66267;
(statearr_66272_66299[(1)] = cljs.core.first((state_66267[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66300 = state_66267;
state_66267 = G__66300;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_66267){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_66267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66273 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66273[(6)] = c__2706__auto__);

return statearr_66273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66286){
var state_val_66287 = (state_66286[(1)]);
if((state_val_66287 === (1))){
var inst_66274 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66275 = fluree.db.session.db(conn,inst_66274,null);
var state_66286__$1 = state_66286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66286__$1,(2),inst_66275);
} else {
if((state_val_66287 === (2))){
var inst_66277 = (state_66286[(7)]);
var inst_66277__$1 = (state_66286[(2)]);
var inst_66278 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_66277__$1);
var inst_66279 = newer_block_QMARK_(inst_66278);
var state_66286__$1 = (function (){var statearr_66288 = state_66286;
(statearr_66288[(7)] = inst_66277__$1);

return statearr_66288;
})();
if(inst_66279){
var statearr_66289_66301 = state_66286__$1;
(statearr_66289_66301[(1)] = (3));

} else {
var statearr_66290_66302 = state_66286__$1;
(statearr_66290_66302[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66287 === (3))){
var inst_66277 = (state_66286[(7)]);
var inst_66281 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66277);
var state_66286__$1 = state_66286;
var statearr_66291_66303 = state_66286__$1;
(statearr_66291_66303[(2)] = inst_66281);

(statearr_66291_66303[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66287 === (4))){
var state_66286__$1 = state_66286;
var statearr_66292_66304 = state_66286__$1;
(statearr_66292_66304[(2)] = null);

(statearr_66292_66304[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66287 === (5))){
var inst_66284 = (state_66286[(2)]);
var state_66286__$1 = state_66286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66286__$1,inst_66284);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_66293 = [null,null,null,null,null,null,null,null];
(statearr_66293[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_66293[(1)] = (1));

return statearr_66293;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_66286){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66286);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66294){var ex__2687__auto__ = e66294;
var statearr_66295_66305 = state_66286;
(statearr_66295_66305[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66286[(4)]))){
var statearr_66296_66306 = state_66286;
(statearr_66296_66306[(1)] = cljs.core.first((state_66286[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66307 = state_66286;
state_66286 = G__66307;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_66286){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_66286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66297 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66297[(6)] = c__2706__auto__);

return statearr_66297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__66308 = db;
var map__66308__$1 = cljs.core.__destructure_map(map__66308);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66308__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66308__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66308__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2706__auto___66384 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66358){
var state_val_66359 = (state_66358[(1)]);
if((state_val_66359 === (7))){
var inst_66324 = (state_66358[(7)]);
var inst_66335 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66324,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_66358__$1 = state_66358;
if(inst_66335){
var statearr_66360_66385 = state_66358__$1;
(statearr_66360_66385[(1)] = (9));

} else {
var statearr_66361_66386 = state_66358__$1;
(statearr_66361_66386[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (1))){
var inst_66317 = (state_66358[(8)]);
var inst_66309 = (state_66358[(9)]);
var inst_66309__$1 = cljs.core.async.timeout(timeout);
var inst_66317__$1 = res_port;
var inst_66318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66319 = [inst_66309__$1,inst_66317__$1];
var inst_66320 = (new cljs.core.PersistentVector(null,2,(5),inst_66318,inst_66319,null));
var state_66358__$1 = (function (){var statearr_66362 = state_66358;
(statearr_66362[(8)] = inst_66317__$1);

(statearr_66362[(9)] = inst_66309__$1);

return statearr_66362;
})();
return cljs.core.async.ioc_alts_BANG_(state_66358__$1,(2),inst_66320);
} else {
if((state_val_66359 === (4))){
var inst_66317 = (state_66358[(8)]);
var inst_66324 = (state_66358[(7)]);
var inst_66328 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66324,inst_66317);
var state_66358__$1 = state_66358;
if(inst_66328){
var statearr_66363_66387 = state_66358__$1;
(statearr_66363_66387[(1)] = (6));

} else {
var statearr_66364_66388 = state_66358__$1;
(statearr_66364_66388[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (13))){
var inst_66343 = (state_66358[(10)]);
var inst_66354 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66343);
var state_66358__$1 = state_66358;
var statearr_66365_66389 = state_66358__$1;
(statearr_66365_66389[(2)] = inst_66354);

(statearr_66365_66389[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (6))){
var inst_66322 = (state_66358[(11)]);
var inst_66333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66322,(0),null);
var state_66358__$1 = state_66358;
var statearr_66366_66390 = state_66358__$1;
(statearr_66366_66390[(2)] = inst_66333);

(statearr_66366_66390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (3))){
var state_66358__$1 = state_66358;
var statearr_66367_66391 = state_66358__$1;
(statearr_66367_66391[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_66367_66391[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (12))){
var inst_66347 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_66348 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66349 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_66350 = cljs.core.PersistentHashMap.fromArrays(inst_66348,inst_66349);
var inst_66351 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66347,inst_66350);
var inst_66352 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66351);
var state_66358__$1 = state_66358;
var statearr_66368_66392 = state_66358__$1;
(statearr_66368_66392[(2)] = inst_66352);

(statearr_66368_66392[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (2))){
var inst_66322 = (state_66358[(11)]);
var inst_66324 = (state_66358[(7)]);
var inst_66309 = (state_66358[(9)]);
var inst_66322__$1 = (state_66358[(2)]);
var inst_66323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66322__$1,(0),null);
var inst_66324__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66322__$1,(1),null);
var inst_66325 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66324__$1,inst_66309);
var state_66358__$1 = (function (){var statearr_66369 = state_66358;
(statearr_66369[(12)] = inst_66323);

(statearr_66369[(11)] = inst_66322__$1);

(statearr_66369[(7)] = inst_66324__$1);

return statearr_66369;
})();
if(inst_66325){
var statearr_66370_66393 = state_66358__$1;
(statearr_66370_66393[(1)] = (3));

} else {
var statearr_66371_66394 = state_66358__$1;
(statearr_66371_66394[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (11))){
var inst_66339 = (state_66358[(2)]);
var state_66358__$1 = state_66358;
var statearr_66372_66395 = state_66358__$1;
(statearr_66372_66395[(2)] = inst_66339);

(statearr_66372_66395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (9))){
var inst_66323 = (state_66358[(12)]);
var state_66358__$1 = state_66358;
var statearr_66373_66396 = state_66358__$1;
(statearr_66373_66396[(2)] = inst_66323);

(statearr_66373_66396[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (5))){
var inst_66343 = (state_66358[(10)]);
var inst_66343__$1 = (state_66358[(2)]);
var inst_66344 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_66345 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_66343__$1);
var state_66358__$1 = (function (){var statearr_66374 = state_66358;
(statearr_66374[(10)] = inst_66343__$1);

(statearr_66374[(13)] = inst_66344);

return statearr_66374;
})();
if(inst_66345){
var statearr_66375_66397 = state_66358__$1;
(statearr_66375_66397[(1)] = (12));

} else {
var statearr_66376_66398 = state_66358__$1;
(statearr_66376_66398[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (14))){
var inst_66356 = (state_66358[(2)]);
var state_66358__$1 = state_66358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66358__$1,inst_66356);
} else {
if((state_val_66359 === (10))){
var state_66358__$1 = state_66358;
var statearr_66377_66399 = state_66358__$1;
(statearr_66377_66399[(2)] = null);

(statearr_66377_66399[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66359 === (8))){
var inst_66341 = (state_66358[(2)]);
var state_66358__$1 = state_66358;
var statearr_66378_66400 = state_66358__$1;
(statearr_66378_66400[(2)] = inst_66341);

(statearr_66378_66400[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0 = (function (){
var statearr_66379 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66379[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__);

(statearr_66379[(1)] = (1));

return statearr_66379;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1 = (function (state_66358){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66358);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66380){var ex__2687__auto__ = e66380;
var statearr_66381_66401 = state_66358;
(statearr_66381_66401[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66358[(4)]))){
var statearr_66382_66402 = state_66358;
(statearr_66382_66402[(1)] = cljs.core.first((state_66358[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66403 = state_66358;
state_66358 = G__66403;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = function(state_66358){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1.call(this,state_66358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66383 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66383[(6)] = c__2706__auto___66384);

return statearr_66383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__66405 = arguments.length;
switch (G__66405) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__66406){
var map__66407 = p__66406;
var map__66407__$1 = cljs.core.__destructure_map(map__66407);
var opts = map__66407__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66407__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66407__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66407__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66407__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66407__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2706__auto___66496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66458){
var state_val_66459 = (state_66458[(1)]);
if((state_val_66459 === (7))){
var inst_66420 = (state_66458[(7)]);
var inst_66422 = fluree.db.api.ledger.syncTo_db(inst_66420,syncTo,syncTimeout);
var state_66458__$1 = state_66458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66458__$1,(10),inst_66422);
} else {
if((state_val_66459 === (20))){
var inst_66444 = (state_66458[(8)]);
var state_66458__$1 = state_66458;
var statearr_66460_66497 = state_66458__$1;
(statearr_66460_66497[(2)] = inst_66444);

(statearr_66460_66497[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (1))){
var state_66458__$1 = state_66458;
var statearr_66461_66498 = state_66458__$1;
(statearr_66461_66498[(2)] = null);

(statearr_66461_66498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (4))){
var inst_66408 = (state_66458[(2)]);
var inst_66409 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66408);
var inst_66410 = cljs.core.async.close_BANG_(pc);
var state_66458__$1 = (function (){var statearr_66462 = state_66458;
(statearr_66462[(9)] = inst_66409);

return statearr_66462;
})();
var statearr_66463_66499 = state_66458__$1;
(statearr_66463_66499[(2)] = inst_66410);

(statearr_66463_66499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (15))){
var inst_66436 = (state_66458[(10)]);
var inst_66438 = fluree.db.api.ledger.add_db_permissions(inst_66436,auth,roles);
var state_66458__$1 = state_66458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66458__$1,(18),inst_66438);
} else {
if((state_val_66459 === (21))){
var inst_66452 = (state_66458[(2)]);
var inst_66453 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66452);
var _ = (function (){var statearr_66464 = state_66458;
(statearr_66464[(4)] = cljs.core.rest((state_66458[(4)])));

return statearr_66464;
})();
var state_66458__$1 = state_66458;
var statearr_66465_66500 = state_66458__$1;
(statearr_66465_66500[(2)] = inst_66453);

(statearr_66465_66500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (13))){
var inst_66436 = (state_66458[(2)]);
var state_66458__$1 = (function (){var statearr_66466 = state_66458;
(statearr_66466[(10)] = inst_66436);

return statearr_66466;
})();
if(cljs.core.truth_(roles)){
var statearr_66467_66501 = state_66458__$1;
(statearr_66467_66501[(1)] = (15));

} else {
var statearr_66468_66502 = state_66458__$1;
(statearr_66468_66502[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (22))){
var inst_66448 = (state_66458[(2)]);
var inst_66449 = fluree.db.util.async.throw_err(inst_66448);
var state_66458__$1 = state_66458;
var statearr_66469_66503 = state_66458__$1;
(statearr_66469_66503[(2)] = inst_66449);

(statearr_66469_66503[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (6))){
var inst_66419 = (state_66458[(2)]);
var inst_66420 = fluree.db.util.async.throw_err(inst_66419);
var state_66458__$1 = (function (){var statearr_66470 = state_66458;
(statearr_66470[(7)] = inst_66420);

return statearr_66470;
})();
if(cljs.core.truth_(syncTo)){
var statearr_66471_66504 = state_66458__$1;
(statearr_66471_66504[(1)] = (7));

} else {
var statearr_66472_66505 = state_66458__$1;
(statearr_66472_66505[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (17))){
var inst_66444 = (state_66458[(2)]);
var state_66458__$1 = (function (){var statearr_66473 = state_66458;
(statearr_66473[(8)] = inst_66444);

return statearr_66473;
})();
if(cljs.core.truth_(auth)){
var statearr_66474_66506 = state_66458__$1;
(statearr_66474_66506[(1)] = (19));

} else {
var statearr_66475_66507 = state_66458__$1;
(statearr_66475_66507[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (3))){
var inst_66456 = (state_66458[(2)]);
var state_66458__$1 = state_66458;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66458__$1,inst_66456);
} else {
if((state_val_66459 === (12))){
var inst_66428 = (state_66458[(11)]);
var state_66458__$1 = state_66458;
var statearr_66476_66508 = state_66458__$1;
(statearr_66476_66508[(2)] = inst_66428);

(statearr_66476_66508[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (2))){
var _ = (function (){var statearr_66477 = state_66458;
(statearr_66477[(4)] = cljs.core.cons((5),(state_66458[(4)])));

return statearr_66477;
})();
var inst_66417 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_66458__$1 = state_66458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66458__$1,(6),inst_66417);
} else {
if((state_val_66459 === (19))){
var inst_66444 = (state_66458[(8)]);
var inst_66446 = fluree.db.api.ledger.add_db_permissions(inst_66444,auth,roles);
var state_66458__$1 = state_66458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66458__$1,(22),inst_66446);
} else {
if((state_val_66459 === (11))){
var inst_66428 = (state_66458[(11)]);
var inst_66430 = fluree.db.time_travel.as_of_block(inst_66428,block);
var state_66458__$1 = state_66458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66458__$1,(14),inst_66430);
} else {
if((state_val_66459 === (9))){
var inst_66428 = (state_66458[(2)]);
var state_66458__$1 = (function (){var statearr_66479 = state_66458;
(statearr_66479[(11)] = inst_66428);

return statearr_66479;
})();
if(cljs.core.truth_(block)){
var statearr_66480_66509 = state_66458__$1;
(statearr_66480_66509[(1)] = (11));

} else {
var statearr_66481_66510 = state_66458__$1;
(statearr_66481_66510[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (5))){
var _ = (function (){var statearr_66482 = state_66458;
(statearr_66482[(4)] = cljs.core.rest((state_66458[(4)])));

return statearr_66482;
})();
var state_66458__$1 = state_66458;
var ex66478 = (state_66458__$1[(2)]);
var statearr_66483_66511 = state_66458__$1;
(statearr_66483_66511[(5)] = ex66478);


var statearr_66484_66512 = state_66458__$1;
(statearr_66484_66512[(1)] = (4));

(statearr_66484_66512[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (14))){
var inst_66432 = (state_66458[(2)]);
var inst_66433 = fluree.db.util.async.throw_err(inst_66432);
var state_66458__$1 = state_66458;
var statearr_66485_66513 = state_66458__$1;
(statearr_66485_66513[(2)] = inst_66433);

(statearr_66485_66513[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (16))){
var inst_66436 = (state_66458[(10)]);
var state_66458__$1 = state_66458;
var statearr_66486_66514 = state_66458__$1;
(statearr_66486_66514[(2)] = inst_66436);

(statearr_66486_66514[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (10))){
var inst_66424 = (state_66458[(2)]);
var inst_66425 = fluree.db.util.async.throw_err(inst_66424);
var state_66458__$1 = state_66458;
var statearr_66487_66515 = state_66458__$1;
(statearr_66487_66515[(2)] = inst_66425);

(statearr_66487_66515[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (18))){
var inst_66440 = (state_66458[(2)]);
var inst_66441 = fluree.db.util.async.throw_err(inst_66440);
var state_66458__$1 = state_66458;
var statearr_66488_66516 = state_66458__$1;
(statearr_66488_66516[(2)] = inst_66441);

(statearr_66488_66516[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66459 === (8))){
var inst_66420 = (state_66458[(7)]);
var state_66458__$1 = state_66458;
var statearr_66489_66517 = state_66458__$1;
(statearr_66489_66517[(2)] = inst_66420);

(statearr_66489_66517[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_66490 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66490[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_66490[(1)] = (1));

return statearr_66490;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_66458){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66458);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66491){var ex__2687__auto__ = e66491;
var statearr_66492_66518 = state_66458;
(statearr_66492_66518[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66458[(4)]))){
var statearr_66493_66519 = state_66458;
(statearr_66493_66519[(1)] = cljs.core.first((state_66458[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66520 = state_66458;
state_66458 = G__66520;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_66458){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_66458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66494 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66494[(6)] = c__2706__auto___66496);

return statearr_66494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

