// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64089 = arguments.length;
var i__5770__auto___64090 = (0);
while(true){
if((i__5770__auto___64090 < len__5769__auto___64089)){
args__5775__auto__.push((arguments[i__5770__auto___64090]));

var G__64091 = (i__5770__auto___64090 + (1));
i__5770__auto___64090 = G__64091;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__64021){
var vec__64022 = p__64021;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64022,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___64092 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64066){
var state_val_64067 = (state_64066[(1)]);
if((state_val_64067 === (7))){
var inst_64052 = (state_64066[(7)]);
var inst_64043 = (state_64066[(8)]);
var inst_64054 = fluree.db.time_travel.as_of_block(inst_64052,inst_64043);
var state_64066__$1 = state_64066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64066__$1,(10),inst_64054);
} else {
if((state_val_64067 === (1))){
var state_64066__$1 = state_64066;
var statearr_64068_64093 = state_64066__$1;
(statearr_64068_64093[(2)] = null);

(statearr_64068_64093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64067 === (4))){
var inst_64025 = (state_64066[(2)]);
var inst_64026 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64025], 0));
var inst_64027 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64025);
var inst_64028 = cljs.core.async.close_BANG_(pc);
var state_64066__$1 = (function (){var statearr_64069 = state_64066;
(statearr_64069[(9)] = inst_64026);

(statearr_64069[(10)] = inst_64027);

return statearr_64069;
})();
var statearr_64070_64094 = state_64066__$1;
(statearr_64070_64094[(2)] = inst_64028);

(statearr_64070_64094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64067 === (6))){
var inst_64043 = (state_64066[(8)]);
var inst_64047 = (state_64066[(11)]);
var inst_64046 = (state_64066[(12)]);
var inst_64050 = (state_64066[(2)]);
var inst_64051 = fluree.db.util.async.throw_err(inst_64050);
var inst_64052 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64051,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_64046,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_64047], 0));
var state_64066__$1 = (function (){var statearr_64071 = state_64066;
(statearr_64071[(7)] = inst_64052);

return statearr_64071;
})();
if(cljs.core.truth_(inst_64043)){
var statearr_64072_64095 = state_64066__$1;
(statearr_64072_64095[(1)] = (7));

} else {
var statearr_64073_64096 = state_64066__$1;
(statearr_64073_64096[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64067 === (3))){
var inst_64064 = (state_64066[(2)]);
var state_64066__$1 = state_64066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64066__$1,inst_64064);
} else {
if((state_val_64067 === (2))){
var _ = (function (){var statearr_64075 = state_64066;
(statearr_64075[(4)] = cljs.core.cons((5),(state_64066[(4)])));

return statearr_64075;
})();
var inst_64038 = opts;
var inst_64039 = cljs.core.__destructure_map(inst_64038);
var inst_64040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64039,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_64041 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64039,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_64042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64039,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64039,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64044 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_64045 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_64046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64045,(0),null);
var inst_64047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64045,(1),null);
var inst_64048 = fluree.db.session.db(conn,ledger,opts);
var state_64066__$1 = (function (){var statearr_64076 = state_64066;
(statearr_64076[(13)] = inst_64040);

(statearr_64076[(14)] = inst_64044);

(statearr_64076[(15)] = inst_64042);

(statearr_64076[(8)] = inst_64043);

(statearr_64076[(11)] = inst_64047);

(statearr_64076[(12)] = inst_64046);

(statearr_64076[(16)] = inst_64041);

return statearr_64076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64066__$1,(6),inst_64048);
} else {
if((state_val_64067 === (9))){
var inst_64060 = (state_64066[(2)]);
var inst_64061 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64060);
var _ = (function (){var statearr_64077 = state_64066;
(statearr_64077[(4)] = cljs.core.rest((state_64066[(4)])));

return statearr_64077;
})();
var state_64066__$1 = state_64066;
var statearr_64078_64097 = state_64066__$1;
(statearr_64078_64097[(2)] = inst_64061);

(statearr_64078_64097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64067 === (5))){
var _ = (function (){var statearr_64079 = state_64066;
(statearr_64079[(4)] = cljs.core.rest((state_64066[(4)])));

return statearr_64079;
})();
var state_64066__$1 = state_64066;
var ex64074 = (state_64066__$1[(2)]);
var statearr_64080_64098 = state_64066__$1;
(statearr_64080_64098[(5)] = ex64074);


var statearr_64081_64099 = state_64066__$1;
(statearr_64081_64099[(1)] = (4));

(statearr_64081_64099[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64067 === (10))){
var inst_64056 = (state_64066[(2)]);
var inst_64057 = fluree.db.util.async.throw_err(inst_64056);
var state_64066__$1 = state_64066;
var statearr_64082_64100 = state_64066__$1;
(statearr_64082_64100[(2)] = inst_64057);

(statearr_64082_64100[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64067 === (8))){
var inst_64052 = (state_64066[(7)]);
var state_64066__$1 = state_64066;
var statearr_64083_64101 = state_64066__$1;
(statearr_64083_64101[(2)] = inst_64052);

(statearr_64083_64101[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_64084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64084[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_64084[(1)] = (1));

return statearr_64084;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_64066){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64066);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64085){var ex__2687__auto__ = e64085;
var statearr_64086_64102 = state_64066;
(statearr_64086_64102[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64066[(4)]))){
var statearr_64087_64103 = state_64066;
(statearr_64087_64103[(1)] = cljs.core.first((state_64066[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64104 = state_64066;
state_64066 = G__64104;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_64066){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_64066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64088 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64088[(6)] = c__2706__auto___64092);

return statearr_64088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq64018){
var G__64019 = cljs.core.first(seq64018);
var seq64018__$1 = cljs.core.next(seq64018);
var G__64020 = cljs.core.first(seq64018__$1);
var seq64018__$2 = cljs.core.next(seq64018__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64019,G__64020,seq64018__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__64106 = arguments.length;
switch (G__64106) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64232){
var state_val_64233 = (state_64232[(1)]);
if((state_val_64233 === (7))){
var inst_64122 = (state_64232[(7)]);
var inst_64132 = (state_64232[(8)]);
var inst_64134 = fluree.db.time_travel.as_of_block(inst_64132,inst_64122);
var state_64232__$1 = state_64232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64232__$1,(10),inst_64134);
} else {
if((state_val_64233 === (20))){
var inst_64126 = (state_64232[(9)]);
var state_64232__$1 = state_64232;
var statearr_64234_64314 = state_64232__$1;
(statearr_64234_64314[(2)] = inst_64126);

(statearr_64234_64314[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (27))){
var inst_64120 = (state_64232[(10)]);
var state_64232__$1 = state_64232;
var statearr_64235_64315 = state_64232__$1;
(statearr_64235_64315[(2)] = inst_64120);

(statearr_64235_64315[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (1))){
var state_64232__$1 = state_64232;
var statearr_64236_64316 = state_64232__$1;
(statearr_64236_64316[(2)] = null);

(statearr_64236_64316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (24))){
var inst_64129 = (state_64232[(11)]);
var state_64232__$1 = state_64232;
if(cljs.core.truth_(inst_64129)){
var statearr_64237_64317 = state_64232__$1;
(statearr_64237_64317[(1)] = (26));

} else {
var statearr_64238_64318 = state_64232__$1;
(statearr_64238_64318[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (39))){
var inst_64194 = (state_64232[(12)]);
var inst_64197 = cljs.core.ex_data(inst_64194);
var inst_64198 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64199 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64197);
var inst_64200 = cljs.core.ex_message(inst_64194);
var inst_64201 = [inst_64199,inst_64200,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64202 = cljs.core.PersistentHashMap.fromArrays(inst_64198,inst_64201);
var state_64232__$1 = state_64232;
var statearr_64239_64319 = state_64232__$1;
(statearr_64239_64319[(2)] = inst_64202);

(statearr_64239_64319[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (46))){
var inst_64194 = (state_64232[(12)]);
var state_64232__$1 = state_64232;
var statearr_64240_64320 = state_64232__$1;
(statearr_64240_64320[(2)] = inst_64194);

(statearr_64240_64320[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (4))){
var inst_64107 = (state_64232[(2)]);
var inst_64108 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64107], 0));
var inst_64109 = cljs.core.ex_data(inst_64107);
var inst_64110 = cljs.core.ex_message(inst_64107);
var inst_64111 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64109,new cljs.core.Keyword(null,"message","message",-406056002),inst_64110);
var state_64232__$1 = (function (){var statearr_64241 = state_64232;
(statearr_64241[(13)] = inst_64108);

return statearr_64241;
})();
var statearr_64242_64321 = state_64232__$1;
(statearr_64242_64321[(2)] = inst_64111);

(statearr_64242_64321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (15))){
var state_64232__$1 = state_64232;
var statearr_64243_64322 = state_64232__$1;
(statearr_64243_64322[(2)] = (1000000));

(statearr_64243_64322[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (48))){
var inst_64194 = (state_64232[(12)]);
var state_64232__$1 = state_64232;
var statearr_64244_64323 = state_64232__$1;
(statearr_64244_64323[(2)] = inst_64194);

(statearr_64244_64323[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (50))){
var inst_64221 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
var statearr_64245_64324 = state_64232__$1;
(statearr_64245_64324[(2)] = inst_64221);

(statearr_64245_64324[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (21))){
var inst_64125 = (state_64232[(14)]);
var state_64232__$1 = state_64232;
if(cljs.core.truth_(inst_64125)){
var statearr_64246_64325 = state_64232__$1;
(statearr_64246_64325[(1)] = (23));

} else {
var statearr_64247_64326 = state_64232__$1;
(statearr_64247_64326[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (31))){
var inst_64183 = (state_64232[(2)]);
var inst_64184 = cljs.core.not(inst_64183);
var state_64232__$1 = state_64232;
if(inst_64184){
var statearr_64248_64327 = state_64232__$1;
(statearr_64248_64327[(1)] = (35));

} else {
var statearr_64249_64328 = state_64232__$1;
(statearr_64249_64328[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (32))){
var inst_64127 = (state_64232[(15)]);
var state_64232__$1 = state_64232;
var statearr_64250_64329 = state_64232__$1;
(statearr_64250_64329[(2)] = inst_64127);

(statearr_64250_64329[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (40))){
var inst_64157 = (state_64232[(16)]);
var state_64232__$1 = state_64232;
if(cljs.core.truth_(inst_64157)){
var statearr_64251_64330 = state_64232__$1;
(statearr_64251_64330[(1)] = (42));

} else {
var statearr_64252_64331 = state_64232__$1;
(statearr_64252_64331[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (33))){
var inst_64123 = (state_64232[(17)]);
var state_64232__$1 = state_64232;
var statearr_64253_64332 = state_64232__$1;
(statearr_64253_64332[(2)] = inst_64123);

(statearr_64253_64332[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (13))){
var inst_64152 = (state_64232[(18)]);
var inst_64128 = (state_64232[(19)]);
var inst_64150 = (state_64232[(2)]);
var inst_64151 = cljs.core.volatile_BANG_((0));
var inst_64152__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_64128);
var state_64232__$1 = (function (){var statearr_64254 = state_64232;
(statearr_64254[(18)] = inst_64152__$1);

(statearr_64254[(20)] = inst_64151);

(statearr_64254[(21)] = inst_64150);

return statearr_64254;
})();
if(cljs.core.truth_(inst_64152__$1)){
var statearr_64255_64333 = state_64232__$1;
(statearr_64255_64333[(1)] = (14));

} else {
var statearr_64256_64334 = state_64232__$1;
(statearr_64256_64334[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (22))){
var inst_64173 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
var statearr_64257_64335 = state_64232__$1;
(statearr_64257_64335[(2)] = inst_64173);

(statearr_64257_64335[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (36))){
var inst_64140 = (state_64232[(22)]);
var inst_64159 = (state_64232[(23)]);
var inst_64190 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64159);
var inst_64191 = fluree.db.query.fql.query(inst_64140,inst_64190);
var state_64232__$1 = state_64232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64232__$1,(38),inst_64191);
} else {
if((state_val_64233 === (41))){
var inst_64225 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
var statearr_64258_64336 = state_64232__$1;
(statearr_64258_64336[(2)] = inst_64225);

(statearr_64258_64336[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (43))){
var state_64232__$1 = state_64232;
var statearr_64259_64337 = state_64232__$1;
(statearr_64259_64337[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (29))){
var inst_64127 = (state_64232[(15)]);
var state_64232__$1 = state_64232;
if(cljs.core.truth_(inst_64127)){
var statearr_64261_64338 = state_64232__$1;
(statearr_64261_64338[(1)] = (32));

} else {
var statearr_64262_64339 = state_64232__$1;
(statearr_64262_64339[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (44))){
var inst_64223 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
var statearr_64263_64340 = state_64232__$1;
(statearr_64263_64340[(2)] = inst_64223);

(statearr_64263_64340[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (6))){
var inst_64122 = (state_64232[(7)]);
var inst_64131 = (state_64232[(2)]);
var inst_64132 = fluree.db.util.async.throw_err(inst_64131);
var state_64232__$1 = (function (){var statearr_64264 = state_64232;
(statearr_64264[(8)] = inst_64132);

return statearr_64264;
})();
if(cljs.core.truth_(inst_64122)){
var statearr_64265_64341 = state_64232__$1;
(statearr_64265_64341[(1)] = (7));

} else {
var statearr_64266_64342 = state_64232__$1;
(statearr_64266_64342[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (28))){
var inst_64169 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
var statearr_64267_64343 = state_64232__$1;
(statearr_64267_64343[(2)] = inst_64169);

(statearr_64267_64343[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (25))){
var inst_64171 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
var statearr_64268_64344 = state_64232__$1;
(statearr_64268_64344[(2)] = inst_64171);

(statearr_64268_64344[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (34))){
var inst_64180 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
var statearr_64269_64345 = state_64232__$1;
(statearr_64269_64345[(2)] = inst_64180);

(statearr_64269_64345[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (17))){
var inst_64121 = (state_64232[(24)]);
var state_64232__$1 = state_64232;
var statearr_64270_64346 = state_64232__$1;
(statearr_64270_64346[(2)] = inst_64121);

(statearr_64270_64346[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (3))){
var inst_64230 = (state_64232[(2)]);
var state_64232__$1 = state_64232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64232__$1,inst_64230);
} else {
if((state_val_64233 === (12))){
var inst_64148 = cljs.core.PersistentHashMap.EMPTY;
var state_64232__$1 = state_64232;
var statearr_64271_64347 = state_64232__$1;
(statearr_64271_64347[(2)] = inst_64148);

(statearr_64271_64347[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (2))){
var _ = (function (){var statearr_64272 = state_64232;
(statearr_64272[(4)] = cljs.core.cons((5),(state_64232[(4)])));

return statearr_64272;
})();
var inst_64118 = query_map;
var inst_64119 = cljs.core.__destructure_map(inst_64118);
var inst_64120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_64121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_64122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_64124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_64125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_64126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_64127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_64128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_64129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64119,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_64232__$1 = (function (){var statearr_64273 = state_64232;
(statearr_64273[(15)] = inst_64127);

(statearr_64273[(9)] = inst_64126);

(statearr_64273[(10)] = inst_64120);

(statearr_64273[(19)] = inst_64128);

(statearr_64273[(11)] = inst_64129);

(statearr_64273[(14)] = inst_64125);

(statearr_64273[(24)] = inst_64121);

(statearr_64273[(17)] = inst_64123);

(statearr_64273[(7)] = inst_64122);

(statearr_64273[(25)] = inst_64124);

return statearr_64273;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64232__$1,(6),sources);
} else {
if((state_val_64233 === (23))){
var inst_64125 = (state_64232[(14)]);
var state_64232__$1 = state_64232;
var statearr_64274_64348 = state_64232__$1;
(statearr_64274_64348[(2)] = inst_64125);

(statearr_64274_64348[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (47))){
var inst_64158 = (state_64232[(26)]);
var inst_64140 = (state_64232[(22)]);
var inst_64151 = (state_64232[(20)]);
var inst_64205 = (state_64232[(27)]);
var inst_64211 = (state_64232[(2)]);
var inst_64212 = cljs.core.deref(inst_64151);
var inst_64213 = fluree.db.util.core.response_time_formatted(inst_64158);
var inst_64214 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64140);
var inst_64215 = [(200),inst_64211,inst_64212,inst_64213,inst_64214];
var inst_64216 = cljs.core.PersistentHashMap.fromArrays(inst_64205,inst_64215);
var state_64232__$1 = state_64232;
var statearr_64275_64349 = state_64232__$1;
(statearr_64275_64349[(2)] = inst_64216);

(statearr_64275_64349[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (35))){
var inst_64186 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64187 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64188 = cljs.core.PersistentHashMap.fromArrays(inst_64186,inst_64187);
var state_64232__$1 = state_64232;
var statearr_64276_64350 = state_64232__$1;
(statearr_64276_64350[(2)] = inst_64188);

(statearr_64276_64350[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (19))){
var inst_64175 = (state_64232[(28)]);
var inst_64175__$1 = (state_64232[(2)]);
var state_64232__$1 = (function (){var statearr_64277 = state_64232;
(statearr_64277[(28)] = inst_64175__$1);

return statearr_64277;
})();
if(cljs.core.truth_(inst_64175__$1)){
var statearr_64278_64351 = state_64232__$1;
(statearr_64278_64351[(1)] = (29));

} else {
var statearr_64279_64352 = state_64232__$1;
(statearr_64279_64352[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (11))){
var inst_64140 = (state_64232[(22)]);
var inst_64141 = (state_64232[(29)]);
var inst_64124 = (state_64232[(25)]);
var inst_64143 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_64140);
var inst_64144 = fluree.db.connection_js.open_api_QMARK_(inst_64141);
var inst_64145 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_64140);
var inst_64146 = fluree.db.api_js.get_sources(inst_64141,inst_64143,inst_64144,inst_64145,inst_64124,db_fn);
var state_64232__$1 = state_64232;
var statearr_64281_64353 = state_64232__$1;
(statearr_64281_64353[(2)] = inst_64146);

(statearr_64281_64353[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (9))){
var inst_64140 = (state_64232[(22)]);
var inst_64124 = (state_64232[(25)]);
var inst_64140__$1 = (state_64232[(2)]);
var inst_64141 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_64140__$1);
var state_64232__$1 = (function (){var statearr_64282 = state_64232;
(statearr_64282[(22)] = inst_64140__$1);

(statearr_64282[(29)] = inst_64141);

return statearr_64282;
})();
if(cljs.core.truth_(inst_64124)){
var statearr_64283_64354 = state_64232__$1;
(statearr_64283_64354[(1)] = (11));

} else {
var statearr_64284_64355 = state_64232__$1;
(statearr_64284_64355[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (5))){
var _ = (function (){var statearr_64285 = state_64232;
(statearr_64285[(4)] = cljs.core.rest((state_64232[(4)])));

return statearr_64285;
})();
var state_64232__$1 = state_64232;
var ex64280 = (state_64232__$1[(2)]);
var statearr_64286_64356 = state_64232__$1;
(statearr_64286_64356[(5)] = ex64280);


var statearr_64287_64357 = state_64232__$1;
(statearr_64287_64357[(1)] = (4));

(statearr_64287_64357[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (14))){
var inst_64152 = (state_64232[(18)]);
var state_64232__$1 = state_64232;
var statearr_64288_64358 = state_64232__$1;
(statearr_64288_64358[(2)] = inst_64152);

(statearr_64288_64358[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (45))){
var inst_64194 = (state_64232[(12)]);
var inst_64208 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_64194);
var state_64232__$1 = state_64232;
var statearr_64289_64359 = state_64232__$1;
(statearr_64289_64359[(2)] = inst_64208);

(statearr_64289_64359[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (26))){
var inst_64129 = (state_64232[(11)]);
var state_64232__$1 = state_64232;
var statearr_64290_64360 = state_64232__$1;
(statearr_64290_64360[(2)] = inst_64129);

(statearr_64290_64360[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (16))){
var inst_64128 = (state_64232[(19)]);
var inst_64151 = (state_64232[(20)]);
var inst_64150 = (state_64232[(21)]);
var inst_64121 = (state_64232[(24)]);
var inst_64156 = (state_64232[(2)]);
var inst_64157 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_64128);
var inst_64158 = fluree.db.util.core.current_time_millis();
var inst_64159 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64128,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_64150,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_64156,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64151], 0));
var state_64232__$1 = (function (){var statearr_64291 = state_64232;
(statearr_64291[(26)] = inst_64158);

(statearr_64291[(16)] = inst_64157);

(statearr_64291[(23)] = inst_64159);

return statearr_64291;
})();
if(cljs.core.truth_(inst_64121)){
var statearr_64292_64361 = state_64232__$1;
(statearr_64292_64361[(1)] = (17));

} else {
var statearr_64293_64362 = state_64232__$1;
(statearr_64293_64362[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (38))){
var inst_64194 = (state_64232[(12)]);
var inst_64193 = (state_64232[(2)]);
var inst_64194__$1 = fluree.db.util.async.throw_err(inst_64193);
var inst_64195 = (inst_64194__$1 instanceof cljs.core.ExceptionInfo);
var state_64232__$1 = (function (){var statearr_64294 = state_64232;
(statearr_64294[(12)] = inst_64194__$1);

return statearr_64294;
})();
if(cljs.core.truth_(inst_64195)){
var statearr_64295_64363 = state_64232__$1;
(statearr_64295_64363[(1)] = (39));

} else {
var statearr_64296_64364 = state_64232__$1;
(statearr_64296_64364[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (30))){
var inst_64175 = (state_64232[(28)]);
var state_64232__$1 = state_64232;
var statearr_64297_64365 = state_64232__$1;
(statearr_64297_64365[(2)] = inst_64175);

(statearr_64297_64365[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (10))){
var inst_64136 = (state_64232[(2)]);
var inst_64137 = fluree.db.util.async.throw_err(inst_64136);
var state_64232__$1 = state_64232;
var statearr_64298_64366 = state_64232__$1;
(statearr_64298_64366[(2)] = inst_64137);

(statearr_64298_64366[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (18))){
var inst_64126 = (state_64232[(9)]);
var state_64232__$1 = state_64232;
if(cljs.core.truth_(inst_64126)){
var statearr_64299_64367 = state_64232__$1;
(statearr_64299_64367[(1)] = (20));

} else {
var statearr_64300_64368 = state_64232__$1;
(statearr_64300_64368[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (42))){
var inst_64194 = (state_64232[(12)]);
var inst_64205 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64206 = cljs.core.sequential_QMARK_(inst_64194);
var state_64232__$1 = (function (){var statearr_64301 = state_64232;
(statearr_64301[(27)] = inst_64205);

return statearr_64301;
})();
if(inst_64206){
var statearr_64302_64369 = state_64232__$1;
(statearr_64302_64369[(1)] = (45));

} else {
var statearr_64303_64370 = state_64232__$1;
(statearr_64303_64370[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (37))){
var inst_64227 = (state_64232[(2)]);
var _ = (function (){var statearr_64304 = state_64232;
(statearr_64304[(4)] = cljs.core.rest((state_64232[(4)])));

return statearr_64304;
})();
var state_64232__$1 = state_64232;
var statearr_64305_64371 = state_64232__$1;
(statearr_64305_64371[(2)] = inst_64227);

(statearr_64305_64371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (8))){
var inst_64132 = (state_64232[(8)]);
var state_64232__$1 = state_64232;
var statearr_64306_64372 = state_64232__$1;
(statearr_64306_64372[(2)] = inst_64132);

(statearr_64306_64372[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64233 === (49))){
var state_64232__$1 = state_64232;
var statearr_64307_64373 = state_64232__$1;
(statearr_64307_64373[(2)] = null);

(statearr_64307_64373[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_64308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64308[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_64308[(1)] = (1));

return statearr_64308;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_64232){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64232);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64309){var ex__2687__auto__ = e64309;
var statearr_64310_64374 = state_64232;
(statearr_64310_64374[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64232[(4)]))){
var statearr_64311_64375 = state_64232;
(statearr_64311_64375[(1)] = cljs.core.first((state_64232[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64376 = state_64232;
state_64232 = G__64376;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_64232){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_64232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64312 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64312[(6)] = c__2706__auto__);

return statearr_64312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__64377_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__64377_SHARP_);
}));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64399){
var state_val_64400 = (state_64399[(1)]);
if((state_val_64400 === (1))){
var inst_64381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64382 = [resp_chan,timeout_chan];
var inst_64383 = (new cljs.core.PersistentVector(null,2,(5),inst_64381,inst_64382,null));
var state_64399__$1 = state_64399;
return cljs.core.async.ioc_alts_BANG_(state_64399__$1,(2),inst_64383);
} else {
if((state_val_64400 === (2))){
var inst_64385 = (state_64399[(2)]);
var inst_64386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64385,(0),null);
var inst_64387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64385,(1),null);
var inst_64388 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_64387);
var state_64399__$1 = (function (){var statearr_64401 = state_64399;
(statearr_64401[(7)] = inst_64386);

return statearr_64401;
})();
if(inst_64388){
var statearr_64402_64412 = state_64399__$1;
(statearr_64402_64412[(1)] = (3));

} else {
var statearr_64403_64413 = state_64399__$1;
(statearr_64403_64413[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64400 === (3))){
var inst_64390 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_64391 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64392 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_64393 = [tid,(408),inst_64392];
var inst_64394 = cljs.core.PersistentHashMap.fromArrays(inst_64391,inst_64393);
var state_64399__$1 = (function (){var statearr_64404 = state_64399;
(statearr_64404[(8)] = inst_64390);

return statearr_64404;
})();
var statearr_64405_64414 = state_64399__$1;
(statearr_64405_64414[(2)] = inst_64394);

(statearr_64405_64414[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64400 === (4))){
var inst_64386 = (state_64399[(7)]);
var state_64399__$1 = state_64399;
var statearr_64406_64415 = state_64399__$1;
(statearr_64406_64415[(2)] = inst_64386);

(statearr_64406_64415[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64400 === (5))){
var inst_64397 = (state_64399[(2)]);
var state_64399__$1 = state_64399;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64399__$1,inst_64397);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0 = (function (){
var statearr_64407 = [null,null,null,null,null,null,null,null,null];
(statearr_64407[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__);

(statearr_64407[(1)] = (1));

return statearr_64407;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1 = (function (state_64399){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64399);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64408){var ex__2687__auto__ = e64408;
var statearr_64409_64416 = state_64399;
(statearr_64409_64416[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64399[(4)]))){
var statearr_64410_64417 = state_64399;
(statearr_64410_64417[(1)] = cljs.core.first((state_64399[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64418 = state_64399;
state_64399 = G__64418;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = function(state_64399){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1.call(this,state_64399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64411 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64411[(6)] = c__2706__auto__);

return statearr_64411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__64420 = arguments.length;
switch (G__64420) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__64421 = opts;
var map__64421__$1 = cljs.core.__destructure_map(map__64421);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64421__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64421__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64421__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64421__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__64422 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64422,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64422,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e64425){var e = e64425;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__64428 = arguments.length;
switch (G__64428) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64494){
var state_val_64495 = (state_64494[(1)]);
if((state_val_64495 === (7))){
var inst_64448 = (state_64494[(7)]);
var inst_64449 = (state_64494[(8)]);
var inst_64450 = (state_64494[(9)]);
var inst_64445 = (state_64494[(10)]);
var inst_64447 = (state_64494[(11)]);
var inst_64463 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_64464 = [ledger,txn,inst_64445,inst_64447,inst_64448,inst_64449,inst_64450];
var inst_64465 = cljs.core.PersistentHashMap.fromArrays(inst_64463,inst_64464);
var inst_64466 = fluree.db.util.core.without_nils(inst_64465);
var inst_64467 = fluree.db.operations.transact_async(conn,inst_64466);
var state_64494__$1 = state_64494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64494__$1,(13),inst_64467);
} else {
if((state_val_64495 === (20))){
var inst_64485 = (state_64494[(2)]);
var state_64494__$1 = state_64494;
var statearr_64496_64532 = state_64494__$1;
(statearr_64496_64532[(2)] = inst_64485);

(statearr_64496_64532[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (1))){
var state_64494__$1 = state_64494;
var statearr_64497_64533 = state_64494__$1;
(statearr_64497_64533[(2)] = null);

(statearr_64497_64533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (4))){
var inst_64429 = (state_64494[(2)]);
var inst_64430 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64429], 0));
var inst_64431 = cljs.core.ex_data(inst_64429);
var inst_64432 = cljs.core.ex_message(inst_64429);
var inst_64433 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64431,new cljs.core.Keyword(null,"message","message",-406056002),inst_64432);
var state_64494__$1 = (function (){var statearr_64498 = state_64494;
(statearr_64498[(12)] = inst_64430);

return statearr_64498;
})();
var statearr_64499_64534 = state_64494__$1;
(statearr_64499_64534[(2)] = inst_64433);

(statearr_64499_64534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (15))){
var inst_64444 = (state_64494[(13)]);
var inst_64469 = (state_64494[(14)]);
var inst_64472 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64469,inst_64444);
var state_64494__$1 = state_64494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64494__$1,(17),inst_64472);
} else {
if((state_val_64495 === (13))){
var inst_64443 = (state_64494[(15)]);
var inst_64469 = (state_64494[(2)]);
var state_64494__$1 = (function (){var statearr_64500 = state_64494;
(statearr_64500[(14)] = inst_64469);

return statearr_64500;
})();
if(cljs.core.truth_(inst_64443)){
var statearr_64501_64535 = state_64494__$1;
(statearr_64501_64535[(1)] = (14));

} else {
var statearr_64502_64536 = state_64494__$1;
(statearr_64502_64536[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (6))){
var inst_64442 = (state_64494[(16)]);
var inst_64443 = (state_64494[(15)]);
var inst_64452 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_64442,opts);
var inst_64453 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_64452);
var inst_64454 = fluree.db.operations.command_async(conn,inst_64452);
var state_64494__$1 = (function (){var statearr_64503 = state_64494;
(statearr_64503[(17)] = inst_64454);

(statearr_64503[(18)] = inst_64453);

return statearr_64503;
})();
if(cljs.core.truth_(inst_64443)){
var statearr_64504_64537 = state_64494__$1;
(statearr_64504_64537[(1)] = (9));

} else {
var statearr_64505_64538 = state_64494__$1;
(statearr_64505_64538[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (17))){
var inst_64474 = (state_64494[(19)]);
var inst_64474__$1 = (state_64494[(2)]);
var inst_64475 = (inst_64474__$1 instanceof cljs.core.ExceptionInfo);
var state_64494__$1 = (function (){var statearr_64506 = state_64494;
(statearr_64506[(19)] = inst_64474__$1);

return statearr_64506;
})();
if(cljs.core.truth_(inst_64475)){
var statearr_64507_64539 = state_64494__$1;
(statearr_64507_64539[(1)] = (18));

} else {
var statearr_64508_64540 = state_64494__$1;
(statearr_64508_64540[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (3))){
var inst_64492 = (state_64494[(2)]);
var state_64494__$1 = state_64494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64494__$1,inst_64492);
} else {
if((state_val_64495 === (12))){
var inst_64459 = (state_64494[(2)]);
var state_64494__$1 = state_64494;
var statearr_64509_64541 = state_64494__$1;
(statearr_64509_64541[(2)] = inst_64459);

(statearr_64509_64541[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (2))){
var inst_64442 = (state_64494[(16)]);
var _ = (function (){var statearr_64510 = state_64494;
(statearr_64510[(4)] = cljs.core.cons((5),(state_64494[(4)])));

return statearr_64510;
})();
var inst_64440 = opts;
var inst_64441 = cljs.core.__destructure_map(inst_64440);
var inst_64442__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64441,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_64443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64441,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_64444 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64441,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_64445 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64441,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64446 = fluree.db.util.core.current_time_millis();
var inst_64447 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64441,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_64446);
var inst_64448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64441,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_64449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64441,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_64450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64441,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_64494__$1 = (function (){var statearr_64511 = state_64494;
(statearr_64511[(13)] = inst_64444);

(statearr_64511[(7)] = inst_64448);

(statearr_64511[(8)] = inst_64449);

(statearr_64511[(16)] = inst_64442__$1);

(statearr_64511[(9)] = inst_64450);

(statearr_64511[(10)] = inst_64445);

(statearr_64511[(11)] = inst_64447);

(statearr_64511[(15)] = inst_64443);

return statearr_64511;
})();
if(cljs.core.truth_(inst_64442__$1)){
var statearr_64512_64542 = state_64494__$1;
(statearr_64512_64542[(1)] = (6));

} else {
var statearr_64513_64543 = state_64494__$1;
(statearr_64513_64543[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (19))){
var inst_64474 = (state_64494[(19)]);
var state_64494__$1 = state_64494;
var statearr_64514_64544 = state_64494__$1;
(statearr_64514_64544[(2)] = inst_64474);

(statearr_64514_64544[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (11))){
var inst_64461 = (state_64494[(2)]);
var state_64494__$1 = state_64494;
var statearr_64516_64545 = state_64494__$1;
(statearr_64516_64545[(2)] = inst_64461);

(statearr_64516_64545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (9))){
var inst_64454 = (state_64494[(17)]);
var state_64494__$1 = state_64494;
var statearr_64517_64546 = state_64494__$1;
(statearr_64517_64546[(2)] = inst_64454);

(statearr_64517_64546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (5))){
var _ = (function (){var statearr_64518 = state_64494;
(statearr_64518[(4)] = cljs.core.rest((state_64494[(4)])));

return statearr_64518;
})();
var state_64494__$1 = state_64494;
var ex64515 = (state_64494__$1[(2)]);
var statearr_64519_64547 = state_64494__$1;
(statearr_64519_64547[(5)] = ex64515);


var statearr_64520_64548 = state_64494__$1;
(statearr_64520_64548[(1)] = (4));

(statearr_64520_64548[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (14))){
var inst_64469 = (state_64494[(14)]);
var state_64494__$1 = state_64494;
var statearr_64521_64549 = state_64494__$1;
(statearr_64521_64549[(2)] = inst_64469);

(statearr_64521_64549[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (16))){
var inst_64487 = (state_64494[(2)]);
var state_64494__$1 = state_64494;
var statearr_64522_64550 = state_64494__$1;
(statearr_64522_64550[(2)] = inst_64487);

(statearr_64522_64550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (10))){
var inst_64444 = (state_64494[(13)]);
var inst_64453 = (state_64494[(18)]);
var inst_64457 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64453,inst_64444);
var state_64494__$1 = state_64494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64494__$1,(12),inst_64457);
} else {
if((state_val_64495 === (18))){
var inst_64474 = (state_64494[(19)]);
var inst_64477 = cljs.core.ex_data(inst_64474);
var inst_64478 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64479 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64477);
var inst_64480 = cljs.core.ex_message(inst_64474);
var inst_64481 = [inst_64479,inst_64480,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_64482 = cljs.core.PersistentHashMap.fromArrays(inst_64478,inst_64481);
var state_64494__$1 = state_64494;
var statearr_64523_64551 = state_64494__$1;
(statearr_64523_64551[(2)] = inst_64482);

(statearr_64523_64551[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (8))){
var inst_64489 = (state_64494[(2)]);
var _ = (function (){var statearr_64524 = state_64494;
(statearr_64524[(4)] = cljs.core.rest((state_64494[(4)])));

return statearr_64524;
})();
var state_64494__$1 = state_64494;
var statearr_64525_64552 = state_64494__$1;
(statearr_64525_64552[(2)] = inst_64489);

(statearr_64525_64552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_64526 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64526[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_64526[(1)] = (1));

return statearr_64526;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_64494){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64494);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64527){var ex__2687__auto__ = e64527;
var statearr_64528_64553 = state_64494;
(statearr_64528_64553[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64494[(4)]))){
var statearr_64529_64554 = state_64494;
(statearr_64529_64554[(1)] = cljs.core.first((state_64494[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64555 = state_64494;
state_64494 = G__64555;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_64494){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_64494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64530 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64530[(6)] = c__2706__auto__);

return statearr_64530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64557 = arguments.length;
var i__5770__auto___64558 = (0);
while(true){
if((i__5770__auto___64558 < len__5769__auto___64557)){
args__5775__auto__.push((arguments[i__5770__auto___64558]));

var G__64559 = (i__5770__auto___64558 + (1));
i__5770__auto___64558 = G__64559;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq64556){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq64556));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64590){
var state_val_64591 = (state_64590[(1)]);
if((state_val_64591 === (1))){
var inst_64560 = cljs.core.first(flakes);
var inst_64561 = cljs.core.rest(flakes);
var inst_64562 = cljs.core.PersistentVector.EMPTY;
var inst_64563 = inst_64560;
var inst_64564 = inst_64561;
var inst_64565 = inst_64562;
var state_64590__$1 = (function (){var statearr_64592 = state_64590;
(statearr_64592[(7)] = inst_64565);

(statearr_64592[(8)] = inst_64563);

(statearr_64592[(9)] = inst_64564);

return statearr_64592;
})();
var statearr_64593_64606 = state_64590__$1;
(statearr_64593_64606[(2)] = null);

(statearr_64593_64606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64591 === (2))){
var inst_64563 = (state_64590[(8)]);
var inst_64567 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_64568 = cljs.core.PersistentHashMap.EMPTY;
var inst_64569 = [true,inst_64568];
var inst_64570 = cljs.core.PersistentHashMap.fromArrays(inst_64567,inst_64569);
var inst_64571 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_64570,inst_64563);
var state_64590__$1 = state_64590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64590__$1,(4),inst_64571);
} else {
if((state_val_64591 === (3))){
var inst_64588 = (state_64590[(2)]);
var state_64590__$1 = state_64590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64590__$1,inst_64588);
} else {
if((state_val_64591 === (4))){
var inst_64565 = (state_64590[(7)]);
var inst_64564 = (state_64590[(9)]);
var inst_64573 = (state_64590[(2)]);
var inst_64574 = fluree.db.util.async.throw_err(inst_64573);
var inst_64575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64576 = [inst_64574];
var inst_64577 = (new cljs.core.PersistentVector(null,1,(5),inst_64575,inst_64576,null));
var inst_64578 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64565,inst_64577);
var inst_64579 = cljs.core.first(inst_64564);
var state_64590__$1 = (function (){var statearr_64594 = state_64590;
(statearr_64594[(10)] = inst_64578);

return statearr_64594;
})();
if(cljs.core.truth_(inst_64579)){
var statearr_64595_64607 = state_64590__$1;
(statearr_64595_64607[(1)] = (5));

} else {
var statearr_64596_64608 = state_64590__$1;
(statearr_64596_64608[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64591 === (5))){
var inst_64564 = (state_64590[(9)]);
var inst_64578 = (state_64590[(10)]);
var inst_64581 = cljs.core.first(inst_64564);
var inst_64582 = cljs.core.rest(inst_64564);
var inst_64563 = inst_64581;
var inst_64564__$1 = inst_64582;
var inst_64565 = inst_64578;
var state_64590__$1 = (function (){var statearr_64597 = state_64590;
(statearr_64597[(7)] = inst_64565);

(statearr_64597[(8)] = inst_64563);

(statearr_64597[(9)] = inst_64564__$1);

return statearr_64597;
})();
var statearr_64598_64609 = state_64590__$1;
(statearr_64598_64609[(2)] = null);

(statearr_64598_64609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64591 === (6))){
var inst_64578 = (state_64590[(10)]);
var state_64590__$1 = state_64590;
var statearr_64599_64610 = state_64590__$1;
(statearr_64599_64610[(2)] = inst_64578);

(statearr_64599_64610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64591 === (7))){
var inst_64586 = (state_64590[(2)]);
var state_64590__$1 = state_64590;
var statearr_64600_64611 = state_64590__$1;
(statearr_64600_64611[(2)] = inst_64586);

(statearr_64600_64611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_64601 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64601[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__);

(statearr_64601[(1)] = (1));

return statearr_64601;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1 = (function (state_64590){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64590);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64602){var ex__2687__auto__ = e64602;
var statearr_64603_64612 = state_64590;
(statearr_64603_64612[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64590[(4)]))){
var statearr_64604_64613 = state_64590;
(statearr_64604_64613[(1)] = cljs.core.first((state_64590[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64614 = state_64590;
state_64590 = G__64614;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = function(state_64590){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1.call(this,state_64590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64605 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64605[(6)] = c__2706__auto__);

return statearr_64605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64682){
var state_val_64683 = (state_64682[(1)]);
if((state_val_64683 === (7))){
var inst_64642 = (state_64682[(2)]);
var inst_64643 = fluree.db.util.async.throw_err(inst_64642);
var state_64682__$1 = state_64682;
var statearr_64684_64710 = state_64682__$1;
(statearr_64684_64710[(2)] = inst_64643);

(statearr_64684_64710[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (1))){
var inst_64619 = cljs.core.volatile_BANG_((0));
var inst_64620 = cljs.core.PersistentHashMap.EMPTY;
var inst_64621 = cljs.core.volatile_BANG_(inst_64620);
var inst_64622 = cljs.core.first(resp);
var inst_64623 = cljs.core.rest(resp);
var inst_64624 = cljs.core.PersistentVector.EMPTY;
var inst_64625 = inst_64619;
var inst_64626 = inst_64621;
var inst_64627 = inst_64622;
var inst_64628 = inst_64623;
var inst_64629 = inst_64624;
var state_64682__$1 = (function (){var statearr_64685 = state_64682;
(statearr_64685[(7)] = inst_64629);

(statearr_64685[(8)] = inst_64628);

(statearr_64685[(9)] = inst_64625);

(statearr_64685[(10)] = inst_64626);

(statearr_64685[(11)] = inst_64627);

return statearr_64685;
})();
var statearr_64686_64711 = state_64682__$1;
(statearr_64686_64711[(2)] = null);

(statearr_64686_64711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (4))){
var inst_64629 = (state_64682[(7)]);
var inst_64628 = (state_64682[(8)]);
var inst_64631 = (state_64682[(12)]);
var inst_64625 = (state_64682[(9)]);
var inst_64626 = (state_64682[(10)]);
var inst_64627 = (state_64682[(11)]);
var inst_64633 = (state_64682[(13)]);
var inst_64637 = (function (){var fuel = inst_64625;
var cache = inst_64626;
var curr_block = inst_64627;
var rest_blocks = inst_64628;
var acc = inst_64629;
var flakes = inst_64631;
var asserted = inst_64633;
return (function (p1__64616_SHARP_){
return p1__64616_SHARP_.s;
});
})();
var inst_64638 = cljs.core.group_by(inst_64637,inst_64633);
var inst_64639 = cljs.core.vals(inst_64638);
var inst_64640 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64626,inst_64625,inst_64639);
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(7),inst_64640);
} else {
if((state_val_64683 === (13))){
var inst_64670 = (state_64682[(14)]);
var state_64682__$1 = state_64682;
var statearr_64687_64712 = state_64682__$1;
(statearr_64687_64712[(2)] = inst_64670);

(statearr_64687_64712[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (6))){
var inst_64629 = (state_64682[(7)]);
var inst_64628 = (state_64682[(8)]);
var inst_64646 = (state_64682[(15)]);
var inst_64631 = (state_64682[(12)]);
var inst_64625 = (state_64682[(9)]);
var inst_64626 = (state_64682[(10)]);
var inst_64627 = (state_64682[(11)]);
var inst_64633 = (state_64682[(13)]);
var inst_64648 = (state_64682[(16)]);
var inst_64646__$1 = (state_64682[(2)]);
var inst_64647 = (function (){var fuel = inst_64625;
var cache = inst_64626;
var curr_block = inst_64627;
var rest_blocks = inst_64628;
var acc = inst_64629;
var flakes = inst_64631;
var asserted = inst_64633;
var asserted_SINGLEQUOTE_ = inst_64646__$1;
return (function (p1__64617_SHARP_){
return p1__64617_SHARP_.op === false;
});
})();
var inst_64648__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64647,inst_64631);
var inst_64649 = cljs.core.empty_QMARK_(inst_64648__$1);
var inst_64650 = (!(inst_64649));
var state_64682__$1 = (function (){var statearr_64690 = state_64682;
(statearr_64690[(15)] = inst_64646__$1);

(statearr_64690[(16)] = inst_64648__$1);

return statearr_64690;
})();
if(inst_64650){
var statearr_64691_64713 = state_64682__$1;
(statearr_64691_64713[(1)] = (8));

} else {
var statearr_64692_64714 = state_64682__$1;
(statearr_64692_64714[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (3))){
var inst_64680 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64682__$1,inst_64680);
} else {
if((state_val_64683 === (12))){
var inst_64628 = (state_64682[(8)]);
var inst_64625 = (state_64682[(9)]);
var inst_64626 = (state_64682[(10)]);
var inst_64670 = (state_64682[(14)]);
var inst_64673 = cljs.core.first(inst_64628);
var inst_64674 = cljs.core.rest(inst_64628);
var tmp64688 = inst_64625;
var tmp64689 = inst_64626;
var inst_64625__$1 = tmp64688;
var inst_64626__$1 = tmp64689;
var inst_64627 = inst_64673;
var inst_64628__$1 = inst_64674;
var inst_64629 = inst_64670;
var state_64682__$1 = (function (){var statearr_64693 = state_64682;
(statearr_64693[(7)] = inst_64629);

(statearr_64693[(8)] = inst_64628__$1);

(statearr_64693[(9)] = inst_64625__$1);

(statearr_64693[(10)] = inst_64626__$1);

(statearr_64693[(11)] = inst_64627);

return statearr_64693;
})();
var statearr_64694_64715 = state_64682__$1;
(statearr_64694_64715[(2)] = null);

(statearr_64694_64715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (2))){
var inst_64629 = (state_64682[(7)]);
var inst_64628 = (state_64682[(8)]);
var inst_64631 = (state_64682[(12)]);
var inst_64625 = (state_64682[(9)]);
var inst_64626 = (state_64682[(10)]);
var inst_64627 = (state_64682[(11)]);
var inst_64633 = (state_64682[(13)]);
var inst_64631__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_64627);
var inst_64632 = (function (){var fuel = inst_64625;
var cache = inst_64626;
var curr_block = inst_64627;
var rest_blocks = inst_64628;
var acc = inst_64629;
var flakes = inst_64631__$1;
return (function (p1__64615_SHARP_){
return p1__64615_SHARP_.op;
});
})();
var inst_64633__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64632,inst_64631__$1);
var inst_64634 = cljs.core.empty_QMARK_(inst_64633__$1);
var inst_64635 = (!(inst_64634));
var state_64682__$1 = (function (){var statearr_64695 = state_64682;
(statearr_64695[(12)] = inst_64631__$1);

(statearr_64695[(13)] = inst_64633__$1);

return statearr_64695;
})();
if(inst_64635){
var statearr_64696_64716 = state_64682__$1;
(statearr_64696_64716[(1)] = (4));

} else {
var statearr_64697_64717 = state_64682__$1;
(statearr_64697_64717[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (11))){
var inst_64658 = (state_64682[(2)]);
var inst_64659 = fluree.db.util.async.throw_err(inst_64658);
var state_64682__$1 = state_64682;
var statearr_64698_64718 = state_64682__$1;
(statearr_64698_64718[(2)] = inst_64659);

(statearr_64698_64718[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (9))){
var state_64682__$1 = state_64682;
var statearr_64699_64719 = state_64682__$1;
(statearr_64699_64719[(2)] = null);

(statearr_64699_64719[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (5))){
var state_64682__$1 = state_64682;
var statearr_64700_64720 = state_64682__$1;
(statearr_64700_64720[(2)] = null);

(statearr_64700_64720[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (14))){
var inst_64678 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
var statearr_64701_64721 = state_64682__$1;
(statearr_64701_64721[(2)] = inst_64678);

(statearr_64701_64721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (10))){
var inst_64629 = (state_64682[(7)]);
var inst_64628 = (state_64682[(8)]);
var inst_64646 = (state_64682[(15)]);
var inst_64627 = (state_64682[(11)]);
var inst_64662 = (state_64682[(2)]);
var inst_64663 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_64664 = [inst_64646,inst_64662];
var inst_64665 = cljs.core.PersistentHashMap.fromArrays(inst_64663,inst_64664);
var inst_64666 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64627,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_64665);
var inst_64667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64668 = [inst_64666];
var inst_64669 = (new cljs.core.PersistentVector(null,1,(5),inst_64667,inst_64668,null));
var inst_64670 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64629,inst_64669);
var inst_64671 = cljs.core.first(inst_64628);
var state_64682__$1 = (function (){var statearr_64702 = state_64682;
(statearr_64702[(14)] = inst_64670);

return statearr_64702;
})();
if(cljs.core.truth_(inst_64671)){
var statearr_64703_64722 = state_64682__$1;
(statearr_64703_64722[(1)] = (12));

} else {
var statearr_64704_64723 = state_64682__$1;
(statearr_64704_64723[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (8))){
var inst_64629 = (state_64682[(7)]);
var inst_64628 = (state_64682[(8)]);
var inst_64646 = (state_64682[(15)]);
var inst_64631 = (state_64682[(12)]);
var inst_64625 = (state_64682[(9)]);
var inst_64626 = (state_64682[(10)]);
var inst_64627 = (state_64682[(11)]);
var inst_64633 = (state_64682[(13)]);
var inst_64648 = (state_64682[(16)]);
var inst_64652 = (function (){var flakes = inst_64631;
var rest_blocks = inst_64628;
var curr_block = inst_64627;
var asserted_SINGLEQUOTE_ = inst_64646;
var acc = inst_64629;
var fuel = inst_64625;
var cache = inst_64626;
var retracted = inst_64648;
var asserted = inst_64633;
return (function (p1__64618_SHARP_){
return p1__64618_SHARP_.s;
});
})();
var inst_64653 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_64648);
var inst_64654 = cljs.core.group_by(inst_64652,inst_64653);
var inst_64655 = cljs.core.vals(inst_64654);
var inst_64656 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64626,inst_64625,inst_64655);
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(11),inst_64656);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_64705 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64705[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_64705[(1)] = (1));

return statearr_64705;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_64682){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64682);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64706){var ex__2687__auto__ = e64706;
var statearr_64707_64724 = state_64682;
(statearr_64707_64724[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64682[(4)]))){
var statearr_64708_64725 = state_64682;
(statearr_64708_64725[(1)] = cljs.core.first((state_64682[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64726 = state_64682;
state_64682 = G__64726;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_64682){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_64682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64709 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64709[(6)] = c__2706__auto__);

return statearr_64709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64826){
var state_val_64827 = (state_64826[(1)]);
if((state_val_64827 === (7))){
var inst_64791 = (state_64826[(7)]);
var inst_64798 = (state_64826[(8)]);
var inst_64797 = cljs.core.seq(inst_64791);
var inst_64798__$1 = cljs.core.first(inst_64797);
var inst_64799 = cljs.core.next(inst_64797);
var state_64826__$1 = (function (){var statearr_64828 = state_64826;
(statearr_64828[(9)] = inst_64799);

(statearr_64828[(8)] = inst_64798__$1);

return statearr_64828;
})();
if(cljs.core.truth_(inst_64798__$1)){
var statearr_64829_64866 = state_64826__$1;
(statearr_64829_64866[(1)] = (9));

} else {
var statearr_64830_64867 = state_64826__$1;
(statearr_64830_64867[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (1))){
var state_64826__$1 = state_64826;
var statearr_64831_64868 = state_64826__$1;
(statearr_64831_64868[(2)] = null);

(statearr_64831_64868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (4))){
var inst_64728 = (state_64826[(2)]);
var state_64826__$1 = state_64826;
var statearr_64832_64869 = state_64826__$1;
(statearr_64832_64869[(2)] = inst_64728);

(statearr_64832_64869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (6))){
var inst_64777 = (state_64826[(2)]);
var inst_64778 = fluree.db.util.async.throw_err(inst_64777);
var inst_64786 = resp;
var inst_64787 = cljs.core.seq(inst_64786);
var inst_64788 = cljs.core.first(inst_64787);
var inst_64789 = cljs.core.next(inst_64787);
var inst_64790 = cljs.core.PersistentHashMap.EMPTY;
var inst_64791 = inst_64786;
var inst_64792 = inst_64790;
var state_64826__$1 = (function (){var statearr_64833 = state_64826;
(statearr_64833[(10)] = inst_64788);

(statearr_64833[(7)] = inst_64791);

(statearr_64833[(11)] = inst_64792);

(statearr_64833[(12)] = inst_64778);

(statearr_64833[(13)] = inst_64789);

return statearr_64833;
})();
var statearr_64834_64870 = state_64826__$1;
(statearr_64834_64870[(2)] = null);

(statearr_64834_64870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (3))){
var inst_64824 = (state_64826[(2)]);
var state_64826__$1 = state_64826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64826__$1,inst_64824);
} else {
if((state_val_64827 === (2))){
var _ = (function (){var statearr_64835 = state_64826;
(statearr_64835[(4)] = cljs.core.cons((5),(state_64826[(4)])));

return statearr_64835;
})();
var inst_64734 = (function (){return (function (p1__64727_SHARP_){
return p1__64727_SHARP_.t;
});
})();
var inst_64735 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_64734,resp);
var inst_64736 = cljs.core.set(inst_64735);
var inst_64773 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_64774 = (function (){var ts = inst_64736;
var c__2706__auto____$1 = inst_64773;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64771){
var state_val_64772 = (state_64771[(1)]);
if((state_val_64772 === (1))){
var inst_64744 = ts;
var inst_64745 = cljs.core.seq(inst_64744);
var inst_64746 = cljs.core.first(inst_64745);
var inst_64747 = cljs.core.next(inst_64745);
var inst_64748 = cljs.core.PersistentHashMap.EMPTY;
var inst_64749 = inst_64744;
var inst_64750 = inst_64748;
var state_64771__$1 = (function (){var statearr_64836 = state_64771;
(statearr_64836[(7)] = inst_64747);

(statearr_64836[(8)] = inst_64750);

(statearr_64836[(9)] = inst_64746);

(statearr_64836[(10)] = inst_64749);

return statearr_64836;
})();
var statearr_64837_64871 = state_64771__$1;
(statearr_64837_64871[(2)] = null);

(statearr_64837_64871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64772 === (2))){
var inst_64756 = (state_64771[(11)]);
var inst_64749 = (state_64771[(10)]);
var inst_64755 = cljs.core.seq(inst_64749);
var inst_64756__$1 = cljs.core.first(inst_64755);
var inst_64757 = cljs.core.next(inst_64755);
var state_64771__$1 = (function (){var statearr_64838 = state_64771;
(statearr_64838[(11)] = inst_64756__$1);

(statearr_64838[(12)] = inst_64757);

return statearr_64838;
})();
if(cljs.core.truth_(inst_64756__$1)){
var statearr_64839_64872 = state_64771__$1;
(statearr_64839_64872[(1)] = (4));

} else {
var statearr_64840_64873 = state_64771__$1;
(statearr_64840_64873[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64772 === (3))){
var inst_64769 = (state_64771[(2)]);
var state_64771__$1 = state_64771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64771__$1,inst_64769);
} else {
if((state_val_64772 === (4))){
var inst_64756 = (state_64771[(11)]);
var inst_64759 = fluree.db.time_travel.non_border_t_to_block(db,inst_64756);
var state_64771__$1 = state_64771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64771__$1,(7),inst_64759);
} else {
if((state_val_64772 === (5))){
var inst_64750 = (state_64771[(8)]);
var state_64771__$1 = state_64771;
var statearr_64841_64874 = state_64771__$1;
(statearr_64841_64874[(2)] = inst_64750);

(statearr_64841_64874[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64772 === (6))){
var inst_64767 = (state_64771[(2)]);
var state_64771__$1 = state_64771;
var statearr_64842_64875 = state_64771__$1;
(statearr_64842_64875[(2)] = inst_64767);

(statearr_64842_64875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64772 === (7))){
var inst_64756 = (state_64771[(11)]);
var inst_64757 = (state_64771[(12)]);
var inst_64750 = (state_64771[(8)]);
var inst_64761 = (state_64771[(2)]);
var inst_64762 = fluree.db.util.async.throw_err(inst_64761);
var inst_64763 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64750,inst_64756,inst_64762);
var inst_64749 = inst_64757;
var inst_64750__$1 = inst_64763;
var state_64771__$1 = (function (){var statearr_64843 = state_64771;
(statearr_64843[(8)] = inst_64750__$1);

(statearr_64843[(10)] = inst_64749);

return statearr_64843;
})();
var statearr_64844_64876 = state_64771__$1;
(statearr_64844_64876[(2)] = null);

(statearr_64844_64876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_64845 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64845[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_64845[(1)] = (1));

return statearr_64845;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_64771){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64771);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64846){var ex__2687__auto__ = e64846;
var statearr_64847_64877 = state_64771;
(statearr_64847_64877[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64771[(4)]))){
var statearr_64848_64878 = state_64771;
(statearr_64848_64878[(1)] = cljs.core.first((state_64771[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64879 = state_64771;
state_64771 = G__64879;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_64771){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_64771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64849 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64849[(6)] = c__2706__auto____$1);

return statearr_64849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_64775 = cljs.core.async.impl.dispatch.run(inst_64774);
var state_64826__$1 = (function (){var statearr_64850 = state_64826;
(statearr_64850[(14)] = inst_64775);

return statearr_64850;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64826__$1,(6),inst_64773);
} else {
if((state_val_64827 === (11))){
var inst_64818 = (state_64826[(2)]);
var state_64826__$1 = state_64826;
var statearr_64852_64880 = state_64826__$1;
(statearr_64852_64880[(2)] = inst_64818);

(statearr_64852_64880[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (9))){
var inst_64799 = (state_64826[(9)]);
var inst_64792 = (state_64826[(11)]);
var inst_64778 = (state_64826[(12)]);
var inst_64798 = (state_64826[(8)]);
var inst_64801 = inst_64798.t;
var inst_64802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64778,inst_64801);
var inst_64803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64804 = [inst_64802,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64805 = (new cljs.core.PersistentVector(null,2,(5),inst_64803,inst_64804,null));
var inst_64806 = cljs.core.assoc_in(inst_64792,inst_64805,inst_64802);
var inst_64807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64808 = [inst_64802,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_64809 = (new cljs.core.PersistentVector(null,2,(5),inst_64807,inst_64808,null));
var inst_64810 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64806,inst_64809,cljs.core.conj,inst_64798);
var inst_64811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64812 = [inst_64802,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_64813 = (new cljs.core.PersistentVector(null,2,(5),inst_64811,inst_64812,null));
var inst_64814 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64810,inst_64813,fluree.db.api_js.min_safe,inst_64801);
var inst_64791 = inst_64799;
var inst_64792__$1 = inst_64814;
var state_64826__$1 = (function (){var statearr_64853 = state_64826;
(statearr_64853[(7)] = inst_64791);

(statearr_64853[(11)] = inst_64792__$1);

return statearr_64853;
})();
var statearr_64854_64881 = state_64826__$1;
(statearr_64854_64881[(2)] = null);

(statearr_64854_64881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (5))){
var _ = (function (){var statearr_64855 = state_64826;
(statearr_64855[(4)] = cljs.core.rest((state_64826[(4)])));

return statearr_64855;
})();
var state_64826__$1 = state_64826;
var ex64851 = (state_64826__$1[(2)]);
var statearr_64856_64882 = state_64826__$1;
(statearr_64856_64882[(5)] = ex64851);


if((ex64851 instanceof Error)){
var statearr_64857_64883 = state_64826__$1;
(statearr_64857_64883[(1)] = (4));

(statearr_64857_64883[(5)] = null);

} else {
throw ex64851;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (10))){
var inst_64792 = (state_64826[(11)]);
var state_64826__$1 = state_64826;
var statearr_64858_64884 = state_64826__$1;
(statearr_64858_64884[(2)] = inst_64792);

(statearr_64858_64884[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64827 === (8))){
var inst_64820 = (state_64826[(2)]);
var inst_64821 = cljs.core.vals(inst_64820);
var _ = (function (){var statearr_64859 = state_64826;
(statearr_64859[(4)] = cljs.core.rest((state_64826[(4)])));

return statearr_64859;
})();
var state_64826__$1 = state_64826;
var statearr_64860_64885 = state_64826__$1;
(statearr_64860_64885[(2)] = inst_64821);

(statearr_64860_64885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_64861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64861[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_64861[(1)] = (1));

return statearr_64861;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_64826){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64826);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64862){var ex__2687__auto__ = e64862;
var statearr_64863_64886 = state_64826;
(statearr_64863_64886[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64826[(4)]))){
var statearr_64864_64887 = state_64826;
(statearr_64864_64887[(1)] = cljs.core.first((state_64826[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64888 = state_64826;
state_64826 = G__64888;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_64826){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_64826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64865 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64865[(6)] = c__2706__auto__);

return statearr_64865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65033){
var state_val_65034 = (state_65033[(1)]);
if((state_val_65034 === (7))){
var inst_64913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64914 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64915 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64916 = [inst_64914,inst_64915];
var inst_64917 = (new cljs.core.PersistentVector(null,2,(5),inst_64913,inst_64916,null));
var state_65033__$1 = state_65033;
var statearr_65035_65106 = state_65033__$1;
(statearr_65035_65106[(2)] = inst_64917);

(statearr_65035_65106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (20))){
var inst_64943 = (state_65033[(7)]);
var state_65033__$1 = state_65033;
var statearr_65036_65107 = state_65033__$1;
(statearr_65036_65107[(2)] = inst_64943);

(statearr_65036_65107[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (27))){
var state_65033__$1 = state_65033;
var statearr_65037_65108 = state_65033__$1;
(statearr_65037_65108[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (1))){
var state_65033__$1 = state_65033;
var statearr_65039_65109 = state_65033__$1;
(statearr_65039_65109[(2)] = null);

(statearr_65039_65109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (24))){
var inst_64942 = (state_65033[(8)]);
var state_65033__$1 = state_65033;
if(cljs.core.truth_(inst_64942)){
var statearr_65040_65110 = state_65033__$1;
(statearr_65040_65110[(1)] = (26));

} else {
var statearr_65041_65111 = state_65033__$1;
(statearr_65041_65111[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (39))){
var inst_64988 = (state_65033[(9)]);
var inst_64989 = (state_65033[(10)]);
var inst_65014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65015 = [inst_64988,inst_64989];
var inst_65016 = (new cljs.core.PersistentVector(null,2,(5),inst_65014,inst_65015,null));
var state_65033__$1 = state_65033;
var statearr_65042_65112 = state_65033__$1;
(statearr_65042_65112[(2)] = inst_65016);

(statearr_65042_65112[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (4))){
var inst_64889 = (state_65033[(2)]);
var inst_64890 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64889], 0));
var inst_64891 = cljs.core.ex_data(inst_64889);
var inst_64892 = cljs.core.ex_message(inst_64889);
var inst_64893 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64891,new cljs.core.Keyword(null,"message","message",-406056002),inst_64892);
var state_65033__$1 = (function (){var statearr_65043 = state_65033;
(statearr_65043[(11)] = inst_64890);

return statearr_65043;
})();
var statearr_65044_65113 = state_65033__$1;
(statearr_65044_65113[(2)] = inst_64893);

(statearr_65044_65113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (15))){
var inst_64922 = (state_65033[(12)]);
var inst_64927 = (state_65033[(13)]);
var inst_64936 = (state_65033[(2)]);
var inst_64937 = [inst_64927,inst_64936];
var inst_64938 = (new cljs.core.PersistentVector(null,2,(5),inst_64922,inst_64937,null));
var state_65033__$1 = state_65033;
var statearr_65045_65114 = state_65033__$1;
(statearr_65045_65114[(2)] = inst_64938);

(statearr_65045_65114[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (21))){
var inst_64942 = (state_65033[(8)]);
var state_65033__$1 = state_65033;
var statearr_65046_65115 = state_65033__$1;
(statearr_65046_65115[(2)] = inst_64942);

(statearr_65046_65115[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (31))){
var inst_64983 = (state_65033[(2)]);
var state_65033__$1 = state_65033;
var statearr_65047_65116 = state_65033__$1;
(statearr_65047_65116[(2)] = inst_64983);

(statearr_65047_65116[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (32))){
var inst_64989 = (state_65033[(10)]);
var inst_64992 = cljs.core.pos_int_QMARK_(inst_64989);
var state_65033__$1 = state_65033;
var statearr_65048_65117 = state_65033__$1;
(statearr_65048_65117[(2)] = inst_64992);

(statearr_65048_65117[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (40))){
var inst_65020 = (state_65033[(14)]);
var inst_64944 = (state_65033[(15)]);
var inst_65018 = (state_65033[(2)]);
var inst_65019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65018,(0),null);
var inst_65020__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65018,(1),null);
var inst_65021 = (inst_65020__$1 > inst_64944);
var state_65033__$1 = (function (){var statearr_65049 = state_65033;
(statearr_65049[(14)] = inst_65020__$1);

(statearr_65049[(16)] = inst_65019);

return statearr_65049;
})();
if(cljs.core.truth_(inst_65021)){
var statearr_65050_65118 = state_65033__$1;
(statearr_65050_65118[(1)] = (41));

} else {
var statearr_65051_65119 = state_65033__$1;
(statearr_65051_65119[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (33))){
var inst_64990 = (state_65033[(17)]);
var state_65033__$1 = state_65033;
var statearr_65052_65120 = state_65033__$1;
(statearr_65052_65120[(2)] = inst_64990);

(statearr_65052_65120[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (13))){
var inst_64928 = (state_65033[(18)]);
var inst_64930 = fluree.db.time_travel.block_to_int_format(db,inst_64928);
var state_65033__$1 = state_65033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65033__$1,(16),inst_64930);
} else {
if((state_val_65034 === (22))){
var inst_64961 = (state_65033[(2)]);
var state_65033__$1 = state_65033;
if(cljs.core.truth_(inst_64961)){
var statearr_65053_65121 = state_65033__$1;
(statearr_65053_65121[(1)] = (23));

} else {
var statearr_65054_65122 = state_65033__$1;
(statearr_65054_65122[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (36))){
var state_65033__$1 = state_65033;
var statearr_65055_65123 = state_65033__$1;
(statearr_65055_65123[(2)] = null);

(statearr_65055_65123[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (41))){
var inst_64944 = (state_65033[(15)]);
var state_65033__$1 = state_65033;
var statearr_65056_65124 = state_65033__$1;
(statearr_65056_65124[(2)] = inst_64944);

(statearr_65056_65124[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (43))){
var inst_65019 = (state_65033[(16)]);
var inst_65025 = (state_65033[(2)]);
var inst_65026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65027 = [inst_65019,inst_65025];
var inst_65028 = (new cljs.core.PersistentVector(null,2,(5),inst_65026,inst_65027,null));
var _ = (function (){var statearr_65057 = state_65033;
(statearr_65057[(4)] = cljs.core.rest((state_65033[(4)])));

return statearr_65057;
})();
var state_65033__$1 = state_65033;
var statearr_65058_65125 = state_65033__$1;
(statearr_65058_65125[(2)] = inst_65028);

(statearr_65058_65125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (29))){
var inst_64919 = (state_65033[(19)]);
var inst_64974 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64919], 0));
var inst_64975 = ["Invalid block range provided: ",inst_64974].join('');
var inst_64976 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64977 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64978 = cljs.core.PersistentHashMap.fromArrays(inst_64976,inst_64977);
var inst_64979 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64975,inst_64978);
var inst_64980 = (function(){throw inst_64979})();
var state_65033__$1 = state_65033;
var statearr_65059_65126 = state_65033__$1;
(statearr_65059_65126[(2)] = inst_64980);

(statearr_65059_65126[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (6))){
var inst_64911 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65033__$1 = state_65033;
var statearr_65060_65127 = state_65033__$1;
(statearr_65060_65127[(2)] = inst_64911);

(statearr_65060_65127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (28))){
var inst_64985 = (state_65033[(2)]);
var state_65033__$1 = state_65033;
var statearr_65061_65128 = state_65033__$1;
(statearr_65061_65128[(2)] = inst_64985);

(statearr_65061_65128[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (25))){
var inst_64988 = (state_65033[(9)]);
var inst_64990 = (state_65033[(17)]);
var inst_64987 = (state_65033[(2)]);
var inst_64988__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64987,(0),null);
var inst_64989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64987,(1),null);
var inst_64990__$1 = cljs.core.pos_int_QMARK_(inst_64988__$1);
var state_65033__$1 = (function (){var statearr_65062 = state_65033;
(statearr_65062[(9)] = inst_64988__$1);

(statearr_65062[(17)] = inst_64990__$1);

(statearr_65062[(10)] = inst_64989);

return statearr_65062;
})();
if(inst_64990__$1){
var statearr_65063_65129 = state_65033__$1;
(statearr_65063_65129[(1)] = (32));

} else {
var statearr_65064_65130 = state_65033__$1;
(statearr_65064_65130[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (34))){
var inst_64995 = (state_65033[(2)]);
var inst_64996 = cljs.core.not(inst_64995);
var state_65033__$1 = state_65033;
if(inst_64996){
var statearr_65065_65131 = state_65033__$1;
(statearr_65065_65131[(1)] = (35));

} else {
var statearr_65066_65132 = state_65033__$1;
(statearr_65066_65132[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (17))){
var inst_64944 = (state_65033[(15)]);
var inst_64942 = (state_65033[(8)]);
var inst_64947 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64942], 0));
var inst_64948 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64944], 0));
var inst_64949 = ["Start block is out of range for this ledger. Start block provided: ",inst_64947,". Database block: ",inst_64948].join('');
var inst_64950 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64951 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64952 = cljs.core.PersistentHashMap.fromArrays(inst_64950,inst_64951);
var inst_64953 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64949,inst_64952);
var inst_64954 = (function(){throw inst_64953})();
var state_65033__$1 = state_65033;
var statearr_65067_65133 = state_65033__$1;
(statearr_65067_65133[(2)] = inst_64954);

(statearr_65067_65133[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (3))){
var inst_65031 = (state_65033[(2)]);
var state_65033__$1 = state_65033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65033__$1,inst_65031);
} else {
if((state_val_65034 === (12))){
var inst_64919 = (state_65033[(19)]);
var inst_64928 = (state_65033[(18)]);
var inst_64926 = (state_65033[(2)]);
var inst_64927 = fluree.db.util.async.throw_err(inst_64926);
var inst_64928__$1 = cljs.core.second(inst_64919);
var state_65033__$1 = (function (){var statearr_65068 = state_65033;
(statearr_65068[(13)] = inst_64927);

(statearr_65068[(18)] = inst_64928__$1);

return statearr_65068;
})();
if(cljs.core.truth_(inst_64928__$1)){
var statearr_65069_65134 = state_65033__$1;
(statearr_65069_65134[(1)] = (13));

} else {
var statearr_65070_65135 = state_65033__$1;
(statearr_65070_65135[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (2))){
var _ = (function (){var statearr_65071 = state_65033;
(statearr_65071[(4)] = cljs.core.cons((5),(state_65033[(4)])));

return statearr_65071;
})();
var inst_64908 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64909 = cljs.core.sequential_QMARK_(inst_64908);
var state_65033__$1 = state_65033;
if(inst_64909){
var statearr_65072_65136 = state_65033__$1;
(statearr_65072_65136[(1)] = (6));

} else {
var statearr_65073_65137 = state_65033__$1;
(statearr_65073_65137[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (23))){
var inst_64943 = (state_65033[(7)]);
var inst_64942 = (state_65033[(8)]);
var inst_64963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64964 = [inst_64942,inst_64943];
var inst_64965 = (new cljs.core.PersistentVector(null,2,(5),inst_64963,inst_64964,null));
var state_65033__$1 = state_65033;
var statearr_65074_65138 = state_65033__$1;
(statearr_65074_65138[(2)] = inst_64965);

(statearr_65074_65138[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (35))){
var inst_64919 = (state_65033[(19)]);
var inst_64998 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64919], 0));
var inst_64999 = ["Invalid block range provided: ",inst_64998].join('');
var inst_65000 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65001 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65002 = cljs.core.PersistentHashMap.fromArrays(inst_65000,inst_65001);
var inst_65003 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64999,inst_65002);
var inst_65004 = (function(){throw inst_65003})();
var state_65033__$1 = state_65033;
var statearr_65075_65139 = state_65033__$1;
(statearr_65075_65139[(2)] = inst_65004);

(statearr_65075_65139[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (19))){
var inst_64942 = (state_65033[(8)]);
var inst_64957 = (state_65033[(2)]);
var state_65033__$1 = (function (){var statearr_65076 = state_65033;
(statearr_65076[(20)] = inst_64957);

return statearr_65076;
})();
if(cljs.core.truth_(inst_64942)){
var statearr_65077_65140 = state_65033__$1;
(statearr_65077_65140[(1)] = (20));

} else {
var statearr_65078_65141 = state_65033__$1;
(statearr_65078_65141[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (11))){
var inst_64944 = (state_65033[(15)]);
var inst_64942 = (state_65033[(8)]);
var inst_64941 = (state_65033[(2)]);
var inst_64942__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64941,(0),null);
var inst_64943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64941,(1),null);
var inst_64944__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64945 = (inst_64942__$1 > inst_64944__$1);
var state_65033__$1 = (function (){var statearr_65080 = state_65033;
(statearr_65080[(7)] = inst_64943);

(statearr_65080[(15)] = inst_64944__$1);

(statearr_65080[(8)] = inst_64942__$1);

return statearr_65080;
})();
if(cljs.core.truth_(inst_64945)){
var statearr_65081_65142 = state_65033__$1;
(statearr_65081_65142[(1)] = (17));

} else {
var statearr_65082_65143 = state_65033__$1;
(statearr_65082_65143[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (9))){
var inst_64919 = (state_65033[(19)]);
var inst_64922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64923 = cljs.core.first(inst_64919);
var inst_64924 = fluree.db.time_travel.block_to_int_format(db,inst_64923);
var state_65033__$1 = (function (){var statearr_65083 = state_65033;
(statearr_65083[(12)] = inst_64922);

return statearr_65083;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65033__$1,(12),inst_64924);
} else {
if((state_val_65034 === (5))){
var _ = (function (){var statearr_65084 = state_65033;
(statearr_65084[(4)] = cljs.core.rest((state_65033[(4)])));

return statearr_65084;
})();
var state_65033__$1 = state_65033;
var ex65079 = (state_65033__$1[(2)]);
var statearr_65085_65144 = state_65033__$1;
(statearr_65085_65144[(5)] = ex65079);


var statearr_65086_65145 = state_65033__$1;
(statearr_65086_65145[(1)] = (4));

(statearr_65086_65145[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (14))){
var state_65033__$1 = state_65033;
var statearr_65087_65146 = state_65033__$1;
(statearr_65087_65146[(2)] = null);

(statearr_65087_65146[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (26))){
var inst_64942 = (state_65033[(8)]);
var inst_64968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64969 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64970 = [inst_64942,inst_64969];
var inst_64971 = (new cljs.core.PersistentVector(null,2,(5),inst_64968,inst_64970,null));
var state_65033__$1 = state_65033;
var statearr_65088_65147 = state_65033__$1;
(statearr_65088_65147[(2)] = inst_64971);

(statearr_65088_65147[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (16))){
var inst_64932 = (state_65033[(2)]);
var inst_64933 = fluree.db.util.async.throw_err(inst_64932);
var state_65033__$1 = state_65033;
var statearr_65089_65148 = state_65033__$1;
(statearr_65089_65148[(2)] = inst_64933);

(statearr_65089_65148[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (38))){
var inst_64988 = (state_65033[(9)]);
var inst_64989 = (state_65033[(10)]);
var inst_65010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65011 = [inst_64989,inst_64988];
var inst_65012 = (new cljs.core.PersistentVector(null,2,(5),inst_65010,inst_65011,null));
var state_65033__$1 = state_65033;
var statearr_65090_65149 = state_65033__$1;
(statearr_65090_65149[(2)] = inst_65012);

(statearr_65090_65149[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (30))){
var state_65033__$1 = state_65033;
var statearr_65091_65150 = state_65033__$1;
(statearr_65091_65150[(2)] = null);

(statearr_65091_65150[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (10))){
var inst_64919 = (state_65033[(19)]);
var state_65033__$1 = state_65033;
var statearr_65092_65151 = state_65033__$1;
(statearr_65092_65151[(2)] = inst_64919);

(statearr_65092_65151[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (18))){
var state_65033__$1 = state_65033;
var statearr_65093_65152 = state_65033__$1;
(statearr_65093_65152[(2)] = null);

(statearr_65093_65152[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (42))){
var inst_65020 = (state_65033[(14)]);
var state_65033__$1 = state_65033;
var statearr_65094_65153 = state_65033__$1;
(statearr_65094_65153[(2)] = inst_65020);

(statearr_65094_65153[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (37))){
var inst_64988 = (state_65033[(9)]);
var inst_64989 = (state_65033[(10)]);
var inst_65007 = (state_65033[(2)]);
var inst_65008 = (inst_64989 < inst_64988);
var state_65033__$1 = (function (){var statearr_65095 = state_65033;
(statearr_65095[(21)] = inst_65007);

return statearr_65095;
})();
if(cljs.core.truth_(inst_65008)){
var statearr_65096_65154 = state_65033__$1;
(statearr_65096_65154[(1)] = (38));

} else {
var statearr_65097_65155 = state_65033__$1;
(statearr_65097_65155[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65034 === (8))){
var inst_64919 = (state_65033[(19)]);
var inst_64919__$1 = (state_65033[(2)]);
var inst_64920 = cljs.core.some(cljs.core.string_QMARK_,inst_64919__$1);
var state_65033__$1 = (function (){var statearr_65098 = state_65033;
(statearr_65098[(19)] = inst_64919__$1);

return statearr_65098;
})();
if(cljs.core.truth_(inst_64920)){
var statearr_65099_65156 = state_65033__$1;
(statearr_65099_65156[(1)] = (9));

} else {
var statearr_65100_65157 = state_65033__$1;
(statearr_65100_65157[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_65101 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65101[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__);

(statearr_65101[(1)] = (1));

return statearr_65101;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_65033){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65033);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65102){var ex__2687__auto__ = e65102;
var statearr_65103_65158 = state_65033;
(statearr_65103_65158[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65033[(4)]))){
var statearr_65104_65159 = state_65033;
(statearr_65104_65159[(1)] = cljs.core.first((state_65033[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65160 = state_65033;
state_65033 = G__65160;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = function(state_65033){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_65033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65105 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65105[(6)] = c__2706__auto__);

return statearr_65105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__65162 = arguments.length;
switch (G__65162) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65253){
var state_val_65254 = (state_65253[(1)]);
if((state_val_65254 === (7))){
var inst_65185 = (state_65253[(7)]);
var inst_65188 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_65185);
var state_65253__$1 = state_65253;
var statearr_65255_65306 = state_65253__$1;
(statearr_65255_65306[(2)] = inst_65188);

(statearr_65255_65306[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (20))){
var inst_65224 = (state_65253[(8)]);
var inst_65227 = fluree.db.api_js.format_block_resp_pretty(db,inst_65224);
var state_65253__$1 = state_65253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65253__$1,(23),inst_65227);
} else {
if((state_val_65254 === (27))){
var inst_65233 = (state_65253[(9)]);
var inst_65239 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_65233);
var state_65253__$1 = state_65253;
var statearr_65256_65307 = state_65253__$1;
(statearr_65256_65307[(2)] = inst_65239);

(statearr_65256_65307[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (1))){
var state_65253__$1 = state_65253;
var statearr_65257_65308 = state_65253__$1;
(statearr_65257_65308[(2)] = null);

(statearr_65257_65308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (24))){
var inst_65233 = (state_65253[(9)]);
var inst_65236 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_65237 = cljs.core.sequential_QMARK_(inst_65233);
var state_65253__$1 = (function (){var statearr_65258 = state_65253;
(statearr_65258[(10)] = inst_65236);

return statearr_65258;
})();
if(inst_65237){
var statearr_65259_65309 = state_65253__$1;
(statearr_65259_65309[(1)] = (27));

} else {
var statearr_65260_65310 = state_65253__$1;
(statearr_65260_65310[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (4))){
var inst_65163 = (state_65253[(2)]);
var inst_65164 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65163], 0));
var inst_65165 = cljs.core.ex_data(inst_65163);
var inst_65166 = cljs.core.ex_message(inst_65163);
var inst_65167 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65165,new cljs.core.Keyword(null,"message","message",-406056002),inst_65166);
var state_65253__$1 = (function (){var statearr_65261 = state_65253;
(statearr_65261[(11)] = inst_65164);

return statearr_65261;
})();
var statearr_65262_65311 = state_65253__$1;
(statearr_65262_65311[(2)] = inst_65167);

(statearr_65262_65311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (15))){
var inst_65185 = (state_65253[(7)]);
var inst_65198 = (state_65253[(2)]);
var inst_65199 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65198,inst_65185);
var inst_65200 = (function(){throw inst_65199})();
var state_65253__$1 = state_65253;
var statearr_65263_65312 = state_65253__$1;
(statearr_65263_65312[(2)] = inst_65200);

(statearr_65263_65312[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (21))){
var inst_65224 = (state_65253[(8)]);
var state_65253__$1 = state_65253;
var statearr_65264_65313 = state_65253__$1;
(statearr_65264_65313[(2)] = inst_65224);

(statearr_65264_65313[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (13))){
var inst_65193 = (state_65253[(12)]);
var state_65253__$1 = state_65253;
var statearr_65265_65314 = state_65253__$1;
(statearr_65265_65314[(2)] = inst_65193);

(statearr_65265_65314[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (22))){
var inst_65233 = (state_65253[(2)]);
var inst_65234 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65253__$1 = (function (){var statearr_65266 = state_65253;
(statearr_65266[(9)] = inst_65233);

return statearr_65266;
})();
if(cljs.core.truth_(inst_65234)){
var statearr_65267_65315 = state_65253__$1;
(statearr_65267_65315[(1)] = (24));

} else {
var statearr_65268_65316 = state_65253__$1;
(statearr_65268_65316[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (29))){
var inst_65177 = (state_65253[(13)]);
var inst_65236 = (state_65253[(10)]);
var inst_65242 = (state_65253[(2)]);
var inst_65243 = fluree.db.util.core.response_time_formatted(inst_65177);
var inst_65244 = [(200),inst_65242,(100),inst_65243];
var inst_65245 = cljs.core.PersistentHashMap.fromArrays(inst_65236,inst_65244);
var state_65253__$1 = state_65253;
var statearr_65269_65317 = state_65253__$1;
(statearr_65269_65317[(2)] = inst_65245);

(statearr_65269_65317[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (6))){
var inst_65185 = (state_65253[(7)]);
var inst_65186 = (state_65253[(14)]);
var inst_65184 = (state_65253[(2)]);
var inst_65185__$1 = fluree.db.util.async.throw_err(inst_65184);
var inst_65186__$1 = cljs.core.map_QMARK_(inst_65185__$1);
var state_65253__$1 = (function (){var statearr_65270 = state_65253;
(statearr_65270[(7)] = inst_65185__$1);

(statearr_65270[(14)] = inst_65186__$1);

return statearr_65270;
})();
if(inst_65186__$1){
var statearr_65271_65318 = state_65253__$1;
(statearr_65271_65318[(1)] = (7));

} else {
var statearr_65272_65319 = state_65253__$1;
(statearr_65272_65319[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (28))){
var inst_65233 = (state_65253[(9)]);
var state_65253__$1 = state_65253;
var statearr_65273_65320 = state_65253__$1;
(statearr_65273_65320[(2)] = inst_65233);

(statearr_65273_65320[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (25))){
var inst_65233 = (state_65253[(9)]);
var state_65253__$1 = state_65253;
var statearr_65274_65321 = state_65253__$1;
(statearr_65274_65321[(2)] = inst_65233);

(statearr_65274_65321[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (17))){
var inst_65216 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_65217 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_65216].join('');
var inst_65218 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65219 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65220 = cljs.core.PersistentHashMap.fromArrays(inst_65218,inst_65219);
var inst_65221 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65217,inst_65220);
var inst_65222 = (function(){throw inst_65221})();
var state_65253__$1 = state_65253;
var statearr_65275_65322 = state_65253__$1;
(statearr_65275_65322[(2)] = inst_65222);

(statearr_65275_65322[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (3))){
var inst_65251 = (state_65253[(2)]);
var state_65253__$1 = state_65253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65253__$1,inst_65251);
} else {
if((state_val_65254 === (12))){
var inst_65185 = (state_65253[(7)]);
var inst_65203 = (state_65253[(2)]);
var inst_65204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65185,(0),null);
var inst_65205 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65185,(1),null);
var inst_65206 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_65207 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_65208 = cljs.core.keys(inst_65207);
var inst_65209 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65206,inst_65208);
var state_65253__$1 = (function (){var statearr_65276 = state_65253;
(statearr_65276[(15)] = inst_65203);

(statearr_65276[(16)] = inst_65205);

(statearr_65276[(17)] = inst_65204);

return statearr_65276;
})();
if(inst_65209){
var statearr_65277_65323 = state_65253__$1;
(statearr_65277_65323[(1)] = (16));

} else {
var statearr_65278_65324 = state_65253__$1;
(statearr_65278_65324[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (2))){
var _ = (function (){var statearr_65279 = state_65253;
(statearr_65279[(4)] = cljs.core.cons((5),(state_65253[(4)])));

return statearr_65279;
})();
var inst_65177 = fluree.db.util.core.current_time_millis();
var inst_65178 = db;
var inst_65179 = cljs.core.__destructure_map(inst_65178);
var inst_65180 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65179,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_65181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65179,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_65182 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_65253__$1 = (function (){var statearr_65280 = state_65253;
(statearr_65280[(18)] = inst_65180);

(statearr_65280[(13)] = inst_65177);

(statearr_65280[(19)] = inst_65181);

return statearr_65280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65253__$1,(6),inst_65182);
} else {
if((state_val_65254 === (23))){
var inst_65229 = (state_65253[(2)]);
var inst_65230 = fluree.db.util.async.throw_err(inst_65229);
var state_65253__$1 = state_65253;
var statearr_65281_65325 = state_65253__$1;
(statearr_65281_65325[(2)] = inst_65230);

(statearr_65281_65325[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (19))){
var inst_65213 = (state_65253[(2)]);
var inst_65214 = fluree.db.util.async.throw_err(inst_65213);
var state_65253__$1 = state_65253;
var statearr_65282_65326 = state_65253__$1;
(statearr_65282_65326[(2)] = inst_65214);

(statearr_65282_65326[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (11))){
var state_65253__$1 = state_65253;
var statearr_65284_65327 = state_65253__$1;
(statearr_65284_65327[(2)] = null);

(statearr_65284_65327[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (9))){
var inst_65191 = (state_65253[(2)]);
var state_65253__$1 = state_65253;
if(cljs.core.truth_(inst_65191)){
var statearr_65285_65328 = state_65253__$1;
(statearr_65285_65328[(1)] = (10));

} else {
var statearr_65286_65329 = state_65253__$1;
(statearr_65286_65329[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (5))){
var _ = (function (){var statearr_65287 = state_65253;
(statearr_65287[(4)] = cljs.core.rest((state_65253[(4)])));

return statearr_65287;
})();
var state_65253__$1 = state_65253;
var ex65283 = (state_65253__$1[(2)]);
var statearr_65288_65330 = state_65253__$1;
(statearr_65288_65330[(5)] = ex65283);


var statearr_65289_65331 = state_65253__$1;
(statearr_65289_65331[(1)] = (4));

(statearr_65289_65331[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (14))){
var inst_65180 = (state_65253[(18)]);
var inst_65181 = (state_65253[(19)]);
var inst_65196 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65180),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65181)].join('');
var state_65253__$1 = state_65253;
var statearr_65290_65332 = state_65253__$1;
(statearr_65290_65332[(2)] = inst_65196);

(statearr_65290_65332[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (26))){
var inst_65248 = (state_65253[(2)]);
var _ = (function (){var statearr_65291 = state_65253;
(statearr_65291[(4)] = cljs.core.rest((state_65253[(4)])));

return statearr_65291;
})();
var state_65253__$1 = state_65253;
var statearr_65292_65333 = state_65253__$1;
(statearr_65292_65333[(2)] = inst_65248);

(statearr_65292_65333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (16))){
var inst_65205 = (state_65253[(16)]);
var inst_65204 = (state_65253[(17)]);
var inst_65211 = fluree.db.query.block.block_range(db,inst_65204,inst_65205,opts);
var state_65253__$1 = state_65253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65253__$1,(19),inst_65211);
} else {
if((state_val_65254 === (10))){
var inst_65193 = (state_65253[(12)]);
var inst_65185 = (state_65253[(7)]);
var inst_65193__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_65185);
var state_65253__$1 = (function (){var statearr_65293 = state_65253;
(statearr_65293[(12)] = inst_65193__$1);

return statearr_65293;
})();
if(cljs.core.truth_(inst_65193__$1)){
var statearr_65294_65334 = state_65253__$1;
(statearr_65294_65334[(1)] = (13));

} else {
var statearr_65295_65335 = state_65253__$1;
(statearr_65295_65335[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (18))){
var inst_65224 = (state_65253[(2)]);
var inst_65225 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65253__$1 = (function (){var statearr_65296 = state_65253;
(statearr_65296[(8)] = inst_65224);

return statearr_65296;
})();
if(cljs.core.truth_(inst_65225)){
var statearr_65297_65336 = state_65253__$1;
(statearr_65297_65336[(1)] = (20));

} else {
var statearr_65298_65337 = state_65253__$1;
(statearr_65298_65337[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65254 === (8))){
var inst_65186 = (state_65253[(14)]);
var state_65253__$1 = state_65253;
var statearr_65299_65338 = state_65253__$1;
(statearr_65299_65338[(2)] = inst_65186);

(statearr_65299_65338[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_65300 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65300[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_65300[(1)] = (1));

return statearr_65300;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_65253){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65253);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65301){var ex__2687__auto__ = e65301;
var statearr_65302_65339 = state_65253;
(statearr_65302_65339[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65253[(4)]))){
var statearr_65303_65340 = state_65253;
(statearr_65303_65340[(1)] = cljs.core.first((state_65253[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65341 = state_65253;
state_65253 = G__65341;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_65253){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_65253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65304 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65304[(6)] = c__2706__auto__);

return statearr_65304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__65343 = arguments.length;
switch (G__65343) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65538){
var state_val_65539 = (state_65538[(1)]);
if((state_val_65539 === (62))){
var inst_65536 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65538__$1,inst_65536);
} else {
if((state_val_65539 === (7))){
var inst_65364 = (state_65538[(7)]);
var inst_65374 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65364);
var state_65538__$1 = state_65538;
var statearr_65540_65631 = state_65538__$1;
(statearr_65540_65631[(2)] = inst_65374);

(statearr_65540_65631[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (59))){
var inst_65524 = (state_65538[(2)]);
var inst_65525 = fluree.db.util.async.throw_err(inst_65524);
var state_65538__$1 = state_65538;
var statearr_65541_65632 = state_65538__$1;
(statearr_65541_65632[(2)] = inst_65525);

(statearr_65541_65632[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (20))){
var inst_65432 = (state_65538[(8)]);
var inst_65440 = (state_65538[(9)]);
var inst_65432__$1 = (state_65538[(2)]);
var inst_65433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65434 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65432__$1,(0));
var inst_65435 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65432__$1,(1));
var inst_65436 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65432__$1,(2));
var inst_65437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65432__$1,(3));
var inst_65438 = [inst_65434,inst_65435,inst_65436,inst_65437];
var inst_65439 = (new cljs.core.PersistentVector(null,4,(5),inst_65433,inst_65438,null));
var inst_65440__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65439,(0),null);
var inst_65441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65439,(1),null);
var inst_65442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65439,(2),null);
var inst_65443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65439,(3),null);
var inst_65444 = (inst_65440__$1 == null);
var inst_65445 = cljs.core.not(inst_65444);
var state_65538__$1 = (function (){var statearr_65542 = state_65538;
(statearr_65542[(10)] = inst_65441);

(statearr_65542[(8)] = inst_65432__$1);

(statearr_65542[(11)] = inst_65442);

(statearr_65542[(12)] = inst_65443);

(statearr_65542[(9)] = inst_65440__$1);

return statearr_65542;
})();
if(inst_65445){
var statearr_65543_65633 = state_65538__$1;
(statearr_65543_65633[(1)] = (30));

} else {
var statearr_65544_65634 = state_65538__$1;
(statearr_65544_65634[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (58))){
var inst_65372 = (state_65538[(13)]);
var inst_65528 = (state_65538[(2)]);
var state_65538__$1 = (function (){var statearr_65545 = state_65538;
(statearr_65545[(14)] = inst_65528);

return statearr_65545;
})();
if(cljs.core.truth_(inst_65372)){
var statearr_65546_65635 = state_65538__$1;
(statearr_65546_65635[(1)] = (60));

} else {
var statearr_65547_65636 = state_65538__$1;
(statearr_65547_65636[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (60))){
var inst_65516 = (state_65538[(15)]);
var inst_65528 = (state_65538[(14)]);
var inst_65530 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_65531 = cljs.core.count(inst_65516);
var inst_65532 = [inst_65528,inst_65531,(200)];
var inst_65533 = cljs.core.PersistentHashMap.fromArrays(inst_65530,inst_65532);
var state_65538__$1 = state_65538;
var statearr_65548_65637 = state_65538__$1;
(statearr_65548_65637[(2)] = inst_65533);

(statearr_65548_65637[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (27))){
var inst_65351 = (state_65538[(16)]);
var inst_65420 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65351)].join('');
var inst_65421 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65422 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65423 = cljs.core.PersistentHashMap.fromArrays(inst_65421,inst_65422);
var inst_65424 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65420,inst_65423);
var inst_65425 = (function(){throw inst_65424})();
var state_65538__$1 = state_65538;
var statearr_65549_65638 = state_65538__$1;
(statearr_65549_65638[(2)] = inst_65425);

(statearr_65549_65638[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (1))){
var inst_65348 = query_map;
var inst_65349 = cljs.core.__destructure_map(inst_65348);
var inst_65350 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65349,new cljs.core.Keyword(null,"block","block",664686210));
var inst_65351 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65349,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_65352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65349,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_65538__$1 = (function (){var statearr_65550 = state_65538;
(statearr_65550[(16)] = inst_65351);

(statearr_65550[(17)] = inst_65350);

(statearr_65550[(18)] = inst_65352);

return statearr_65550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(2),sources);
} else {
if((state_val_65539 === (24))){
var inst_65351 = (state_65538[(16)]);
var inst_65409 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65351)].join('');
var inst_65410 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65411 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65412 = cljs.core.PersistentHashMap.fromArrays(inst_65410,inst_65411);
var inst_65413 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65409,inst_65412);
var inst_65414 = (function(){throw inst_65413})();
var state_65538__$1 = state_65538;
var statearr_65551_65639 = state_65538__$1;
(statearr_65551_65639[(2)] = inst_65414);

(statearr_65551_65639[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (55))){
var inst_65352 = (state_65538[(18)]);
var inst_65519 = (state_65538[(2)]);
var inst_65520 = fluree.db.util.async.throw_err(inst_65519);
var state_65538__$1 = (function (){var statearr_65552 = state_65538;
(statearr_65552[(19)] = inst_65520);

return statearr_65552;
})();
if(cljs.core.truth_(inst_65352)){
var statearr_65553_65640 = state_65538__$1;
(statearr_65553_65640[(1)] = (56));

} else {
var statearr_65554_65641 = state_65538__$1;
(statearr_65554_65641[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (39))){
var inst_65441 = (state_65538[(10)]);
var inst_65442 = (state_65538[(11)]);
var inst_65443 = (state_65538[(12)]);
var inst_65440 = (state_65538[(9)]);
var inst_65464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65466 = [inst_65441,inst_65440,inst_65442,inst_65443];
var inst_65467 = (new cljs.core.PersistentVector(null,4,(5),inst_65465,inst_65466,null));
var inst_65468 = [inst_65467,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_65469 = (new cljs.core.PersistentVector(null,2,(5),inst_65464,inst_65468,null));
var state_65538__$1 = state_65538;
var statearr_65555_65642 = state_65538__$1;
(statearr_65555_65642[(2)] = inst_65469);

(statearr_65555_65642[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (46))){
var inst_65474 = (state_65538[(20)]);
var state_65538__$1 = state_65538;
var statearr_65556_65643 = state_65538__$1;
(statearr_65556_65643[(2)] = inst_65474);

(statearr_65556_65643[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (4))){
var state_65538__$1 = state_65538;
var statearr_65557_65644 = state_65538__$1;
(statearr_65557_65644[(2)] = null);

(statearr_65557_65644[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (54))){
var inst_65516 = (state_65538[(15)]);
var inst_65355 = (state_65538[(21)]);
var inst_65515 = (state_65538[(2)]);
var inst_65516__$1 = fluree.db.util.async.throw_err(inst_65515);
var inst_65517 = fluree.db.api_js.format_history_resp(inst_65355,inst_65516__$1);
var state_65538__$1 = (function (){var statearr_65558 = state_65538;
(statearr_65558[(15)] = inst_65516__$1);

return statearr_65558;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(55),inst_65517);
} else {
if((state_val_65539 === (15))){
var inst_65355 = (state_65538[(21)]);
var inst_65396 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65355);
var state_65538__$1 = state_65538;
var statearr_65559_65645 = state_65538__$1;
(statearr_65559_65645[(2)] = inst_65396);

(statearr_65559_65645[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (48))){
var inst_65441 = (state_65538[(10)]);
var inst_65442 = (state_65538[(11)]);
var inst_65443 = (state_65538[(12)]);
var inst_65440 = (state_65538[(9)]);
var inst_65485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65487 = [inst_65441,inst_65442,inst_65440,inst_65443];
var inst_65488 = (new cljs.core.PersistentVector(null,4,(5),inst_65486,inst_65487,null));
var inst_65489 = [inst_65488,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_65490 = (new cljs.core.PersistentVector(null,2,(5),inst_65485,inst_65489,null));
var state_65538__$1 = state_65538;
var statearr_65560_65646 = state_65538__$1;
(statearr_65560_65646[(2)] = inst_65490);

(statearr_65560_65646[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (50))){
var inst_65503 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65561_65647 = state_65538__$1;
(statearr_65561_65647[(2)] = inst_65503);

(statearr_65561_65647[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (21))){
var inst_65351 = (state_65538[(16)]);
var inst_65407 = cljs.core.empty_QMARK_(inst_65351);
var state_65538__$1 = state_65538;
if(inst_65407){
var statearr_65562_65648 = state_65538__$1;
(statearr_65562_65648[(1)] = (24));

} else {
var statearr_65563_65649 = state_65538__$1;
(statearr_65563_65649[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (31))){
var inst_65451 = (state_65538[(22)]);
var inst_65440 = (state_65538[(9)]);
var inst_65451__$1 = (inst_65440 == null);
var state_65538__$1 = (function (){var statearr_65564 = state_65538;
(statearr_65564[(22)] = inst_65451__$1);

return statearr_65564;
})();
if(cljs.core.truth_(inst_65451__$1)){
var statearr_65565_65650 = state_65538__$1;
(statearr_65565_65650[(1)] = (33));

} else {
var statearr_65566_65651 = state_65538__$1;
(statearr_65566_65651[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (32))){
var inst_65388 = (state_65538[(23)]);
var inst_65355 = (state_65538[(21)]);
var inst_65398 = (state_65538[(24)]);
var inst_65507 = (state_65538[(2)]);
var inst_65508 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65507,(0),null);
var inst_65509 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65507,(1),null);
var inst_65510 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_65511 = [inst_65388,inst_65398];
var inst_65512 = cljs.core.PersistentHashMap.fromArrays(inst_65510,inst_65511);
var inst_65513 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_65355,inst_65509,cljs.core._EQ_,inst_65508,inst_65512);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(54),inst_65513);
} else {
if((state_val_65539 === (40))){
var inst_65471 = (state_65538[(25)]);
var inst_65440 = (state_65538[(9)]);
var inst_65471__$1 = (inst_65440 == null);
var state_65538__$1 = (function (){var statearr_65567 = state_65538;
(statearr_65567[(25)] = inst_65471__$1);

return statearr_65567;
})();
if(cljs.core.truth_(inst_65471__$1)){
var statearr_65568_65652 = state_65538__$1;
(statearr_65568_65652[(1)] = (42));

} else {
var statearr_65569_65653 = state_65538__$1;
(statearr_65569_65653[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (56))){
var inst_65355 = (state_65538[(21)]);
var inst_65520 = (state_65538[(19)]);
var inst_65522 = fluree.db.api_js.format_block_resp_pretty(inst_65355,inst_65520);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(59),inst_65522);
} else {
if((state_val_65539 === (33))){
var inst_65441 = (state_65538[(10)]);
var inst_65454 = (state_65538[(26)]);
var inst_65453 = (inst_65441 == null);
var inst_65454__$1 = cljs.core.not(inst_65453);
var state_65538__$1 = (function (){var statearr_65570 = state_65538;
(statearr_65570[(26)] = inst_65454__$1);

return statearr_65570;
})();
if(inst_65454__$1){
var statearr_65571_65654 = state_65538__$1;
(statearr_65571_65654[(1)] = (36));

} else {
var statearr_65572_65655 = state_65538__$1;
(statearr_65572_65655[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (13))){
var inst_65382 = (state_65538[(2)]);
var inst_65383 = fluree.db.util.async.throw_err(inst_65382);
var inst_65384 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65383);
var inst_65385 = (inst_65384 - (1));
var state_65538__$1 = state_65538;
var statearr_65573_65656 = state_65538__$1;
(statearr_65573_65656[(2)] = inst_65385);

(statearr_65573_65656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (22))){
var state_65538__$1 = state_65538;
var statearr_65574_65657 = state_65538__$1;
(statearr_65574_65657[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (36))){
var inst_65442 = (state_65538[(11)]);
var inst_65456 = (inst_65442 == null);
var state_65538__$1 = state_65538;
var statearr_65576_65658 = state_65538__$1;
(statearr_65576_65658[(2)] = inst_65456);

(statearr_65576_65658[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (41))){
var inst_65505 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65577_65659 = state_65538__$1;
(statearr_65577_65659[(2)] = inst_65505);

(statearr_65577_65659[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (43))){
var inst_65471 = (state_65538[(25)]);
var state_65538__$1 = state_65538;
var statearr_65578_65660 = state_65538__$1;
(statearr_65578_65660[(2)] = inst_65471);

(statearr_65578_65660[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (61))){
var inst_65528 = (state_65538[(14)]);
var state_65538__$1 = state_65538;
var statearr_65579_65661 = state_65538__$1;
(statearr_65579_65661[(2)] = inst_65528);

(statearr_65579_65661[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (29))){
var inst_65428 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65580_65662 = state_65538__$1;
(statearr_65580_65662[(2)] = inst_65428);

(statearr_65580_65662[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (44))){
var inst_65483 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
if(cljs.core.truth_(inst_65483)){
var statearr_65581_65663 = state_65538__$1;
(statearr_65581_65663[(1)] = (48));

} else {
var statearr_65582_65664 = state_65538__$1;
(statearr_65582_65664[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (6))){
var inst_65359 = (state_65538[(2)]);
var inst_65360 = fluree.db.util.async.throw_err(inst_65359);
var state_65538__$1 = state_65538;
var statearr_65583_65665 = state_65538__$1;
(statearr_65583_65665[(2)] = inst_65360);

(statearr_65583_65665[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (28))){
var state_65538__$1 = state_65538;
var statearr_65584_65666 = state_65538__$1;
(statearr_65584_65666[(2)] = null);

(statearr_65584_65666[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (51))){
var inst_65351 = (state_65538[(16)]);
var inst_65493 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65351)].join('');
var inst_65494 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65495 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65496 = cljs.core.PersistentHashMap.fromArrays(inst_65494,inst_65495);
var inst_65497 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65493,inst_65496);
var inst_65498 = (function(){throw inst_65497})();
var state_65538__$1 = state_65538;
var statearr_65585_65667 = state_65538__$1;
(statearr_65585_65667[(2)] = inst_65498);

(statearr_65585_65667[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (25))){
var inst_65351 = (state_65538[(16)]);
var state_65538__$1 = state_65538;
var statearr_65586_65668 = state_65538__$1;
(statearr_65586_65668[(2)] = inst_65351);

(statearr_65586_65668[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (34))){
var inst_65451 = (state_65538[(22)]);
var state_65538__$1 = state_65538;
var statearr_65587_65669 = state_65538__$1;
(statearr_65587_65669[(2)] = inst_65451);

(statearr_65587_65669[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (17))){
var inst_65392 = (state_65538[(2)]);
var inst_65393 = fluree.db.util.async.throw_err(inst_65392);
var inst_65394 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65393);
var state_65538__$1 = state_65538;
var statearr_65588_65670 = state_65538__$1;
(statearr_65588_65670[(2)] = inst_65394);

(statearr_65588_65670[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (3))){
var inst_65355 = (state_65538[(21)]);
var inst_65357 = fluree.db.api_js.resolve_block_range(inst_65355,query_map);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(6),inst_65357);
} else {
if((state_val_65539 === (12))){
var inst_65365 = (state_65538[(27)]);
var inst_65388 = (state_65538[(2)]);
var state_65538__$1 = (function (){var statearr_65589 = state_65538;
(statearr_65589[(23)] = inst_65388);

return statearr_65589;
})();
if(cljs.core.truth_(inst_65365)){
var statearr_65590_65671 = state_65538__$1;
(statearr_65590_65671[(1)] = (14));

} else {
var statearr_65591_65672 = state_65538__$1;
(statearr_65591_65672[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (2))){
var inst_65350 = (state_65538[(17)]);
var inst_65354 = (state_65538[(2)]);
var inst_65355 = fluree.db.util.async.throw_err(inst_65354);
var state_65538__$1 = (function (){var statearr_65592 = state_65538;
(statearr_65592[(21)] = inst_65355);

return statearr_65592;
})();
if(cljs.core.truth_(inst_65350)){
var statearr_65593_65673 = state_65538__$1;
(statearr_65593_65673[(1)] = (3));

} else {
var statearr_65594_65674 = state_65538__$1;
(statearr_65594_65674[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (23))){
var inst_65430 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65595_65675 = state_65538__$1;
(statearr_65595_65675[(2)] = inst_65430);

(statearr_65595_65675[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (47))){
var inst_65480 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65596_65676 = state_65538__$1;
(statearr_65596_65676[(2)] = inst_65480);

(statearr_65596_65676[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (35))){
var inst_65462 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
if(cljs.core.truth_(inst_65462)){
var statearr_65597_65677 = state_65538__$1;
(statearr_65597_65677[(1)] = (39));

} else {
var statearr_65598_65678 = state_65538__$1;
(statearr_65598_65678[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (19))){
var inst_65351 = (state_65538[(16)]);
var inst_65405 = cljs.core.sequential_QMARK_(inst_65351);
var state_65538__$1 = state_65538;
if(inst_65405){
var statearr_65599_65679 = state_65538__$1;
(statearr_65599_65679[(1)] = (21));

} else {
var statearr_65600_65680 = state_65538__$1;
(statearr_65600_65680[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (57))){
var inst_65520 = (state_65538[(19)]);
var state_65538__$1 = state_65538;
var statearr_65601_65681 = state_65538__$1;
(statearr_65601_65681[(2)] = inst_65520);

(statearr_65601_65681[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (11))){
var state_65538__$1 = state_65538;
var statearr_65602_65682 = state_65538__$1;
(statearr_65602_65682[(2)] = (-1));

(statearr_65602_65682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (9))){
var inst_65377 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
if(cljs.core.truth_(inst_65377)){
var statearr_65603_65683 = state_65538__$1;
(statearr_65603_65683[(1)] = (10));

} else {
var statearr_65604_65684 = state_65538__$1;
(statearr_65604_65684[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (5))){
var inst_65364 = (state_65538[(7)]);
var inst_65363 = (state_65538[(2)]);
var inst_65364__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65363,(0),null);
var inst_65365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65363,(1),null);
var inst_65372 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65538__$1 = (function (){var statearr_65605 = state_65538;
(statearr_65605[(27)] = inst_65365);

(statearr_65605[(7)] = inst_65364__$1);

(statearr_65605[(13)] = inst_65372);

return statearr_65605;
})();
if(cljs.core.truth_(inst_65364__$1)){
var statearr_65606_65685 = state_65538__$1;
(statearr_65606_65685[(1)] = (7));

} else {
var statearr_65607_65686 = state_65538__$1;
(statearr_65607_65686[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (14))){
var inst_65365 = (state_65538[(27)]);
var inst_65355 = (state_65538[(21)]);
var inst_65390 = fluree.db.time_travel.as_of_block(inst_65355,inst_65365);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(17),inst_65390);
} else {
if((state_val_65539 === (45))){
var inst_65442 = (state_65538[(11)]);
var inst_65476 = (inst_65442 == null);
var inst_65477 = cljs.core.not(inst_65476);
var state_65538__$1 = state_65538;
var statearr_65608_65687 = state_65538__$1;
(statearr_65608_65687[(2)] = inst_65477);

(statearr_65608_65687[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (53))){
var inst_65501 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65609_65688 = state_65538__$1;
(statearr_65609_65688[(2)] = inst_65501);

(statearr_65609_65688[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (26))){
var inst_65417 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65610_65689 = state_65538__$1;
(statearr_65610_65689[(2)] = inst_65417);

(statearr_65610_65689[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (16))){
var inst_65351 = (state_65538[(16)]);
var inst_65398 = (state_65538[(2)]);
var inst_65399 = fluree.db.util.core.subj_ident_QMARK_(inst_65351);
var state_65538__$1 = (function (){var statearr_65611 = state_65538;
(statearr_65611[(24)] = inst_65398);

return statearr_65611;
})();
if(inst_65399){
var statearr_65612_65690 = state_65538__$1;
(statearr_65612_65690[(1)] = (18));

} else {
var statearr_65613_65691 = state_65538__$1;
(statearr_65613_65691[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (38))){
var inst_65459 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65614_65692 = state_65538__$1;
(statearr_65614_65692[(2)] = inst_65459);

(statearr_65614_65692[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (30))){
var inst_65432 = (state_65538[(8)]);
var inst_65447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65448 = [inst_65432,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_65449 = (new cljs.core.PersistentVector(null,2,(5),inst_65447,inst_65448,null));
var state_65538__$1 = state_65538;
var statearr_65615_65693 = state_65538__$1;
(statearr_65615_65693[(2)] = inst_65449);

(statearr_65615_65693[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (10))){
var inst_65364 = (state_65538[(7)]);
var inst_65355 = (state_65538[(21)]);
var inst_65379 = (inst_65364 - (1));
var inst_65380 = fluree.db.time_travel.as_of_block(inst_65355,inst_65379);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(13),inst_65380);
} else {
if((state_val_65539 === (18))){
var inst_65351 = (state_65538[(16)]);
var inst_65401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65402 = [inst_65351];
var inst_65403 = (new cljs.core.PersistentVector(null,1,(5),inst_65401,inst_65402,null));
var state_65538__$1 = state_65538;
var statearr_65616_65694 = state_65538__$1;
(statearr_65616_65694[(2)] = inst_65403);

(statearr_65616_65694[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (52))){
var state_65538__$1 = state_65538;
var statearr_65617_65695 = state_65538__$1;
(statearr_65617_65695[(2)] = null);

(statearr_65617_65695[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (42))){
var inst_65441 = (state_65538[(10)]);
var inst_65474 = (state_65538[(20)]);
var inst_65473 = (inst_65441 == null);
var inst_65474__$1 = cljs.core.not(inst_65473);
var state_65538__$1 = (function (){var statearr_65618 = state_65538;
(statearr_65618[(20)] = inst_65474__$1);

return statearr_65618;
})();
if(inst_65474__$1){
var statearr_65619_65696 = state_65538__$1;
(statearr_65619_65696[(1)] = (45));

} else {
var statearr_65620_65697 = state_65538__$1;
(statearr_65620_65697[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (37))){
var inst_65454 = (state_65538[(26)]);
var state_65538__$1 = state_65538;
var statearr_65621_65698 = state_65538__$1;
(statearr_65621_65698[(2)] = inst_65454);

(statearr_65621_65698[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (8))){
var inst_65364 = (state_65538[(7)]);
var state_65538__$1 = state_65538;
var statearr_65622_65699 = state_65538__$1;
(statearr_65622_65699[(2)] = inst_65364);

(statearr_65622_65699[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (49))){
var state_65538__$1 = state_65538;
var statearr_65623_65700 = state_65538__$1;
(statearr_65623_65700[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_65625 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65625[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_65625[(1)] = (1));

return statearr_65625;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_65538){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65538);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65626){var ex__2687__auto__ = e65626;
var statearr_65627_65701 = state_65538;
(statearr_65627_65701[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65538[(4)]))){
var statearr_65628_65702 = state_65538;
(statearr_65628_65702[(1)] = cljs.core.first((state_65538[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65703 = state_65538;
state_65538 = G__65703;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_65538){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_65538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65629 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65629[(6)] = c__2706__auto__);

return statearr_65629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__65711 = arguments.length;
switch (G__65711) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65704_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__65704_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65800){
var state_val_65801 = (state_65800[(1)]);
if((state_val_65801 === (7))){
var inst_65761 = (state_65800[(7)]);
var inst_65751 = (state_65800[(8)]);
var inst_65754 = (state_65800[(9)]);
var inst_65757 = (state_65800[(10)]);
var inst_65767 = (function (){var responses = inst_65751;
var responses_STAR_ = inst_65754;
var statuses = inst_65757;
var fuel = inst_65761;
return (function (p1__65707_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__65707_SHARP_);
});
})();
var inst_65768 = cljs.core.some(inst_65767,inst_65757);
var state_65800__$1 = state_65800;
if(cljs.core.truth_(inst_65768)){
var statearr_65802_65850 = state_65800__$1;
(statearr_65802_65850[(1)] = (9));

} else {
var statearr_65803_65851 = state_65800__$1;
(statearr_65803_65851[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (20))){
var inst_65795 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
var statearr_65804_65852 = state_65800__$1;
(statearr_65804_65852[(2)] = inst_65795);

(statearr_65804_65852[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (1))){
var inst_65746 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_65747 = (function (){var c__2706__auto____$1 = inst_65746;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65744){
var state_val_65745 = (state_65744[(1)]);
if((state_val_65745 === (1))){
var inst_65712 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_65713 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_65714 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65713,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_65715 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_65716 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_65717 = cljs.core.PersistentHashMap.EMPTY;
var inst_65718 = inst_65712;
var inst_65719 = inst_65714;
var inst_65720 = inst_65715;
var inst_65721 = inst_65716;
var inst_65722 = inst_65717;
var state_65744__$1 = (function (){var statearr_65805 = state_65744;
(statearr_65805[(7)] = inst_65721);

(statearr_65805[(8)] = inst_65718);

(statearr_65805[(9)] = inst_65722);

(statearr_65805[(10)] = inst_65719);

(statearr_65805[(11)] = inst_65720);

return statearr_65805;
})();
var statearr_65806_65853 = state_65744__$1;
(statearr_65806_65853[(2)] = null);

(statearr_65806_65853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65745 === (2))){
var inst_65719 = (state_65744[(10)]);
var inst_65724 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_65719);
var inst_65725 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_65724], 0));
var inst_65726 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65719,new cljs.core.Keyword(null,"opts","opts",155075701),inst_65725);
var inst_65727 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_65726,db_fn);
var state_65744__$1 = state_65744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65744__$1,(4),inst_65727);
} else {
if((state_val_65745 === (3))){
var inst_65742 = (state_65744[(2)]);
var state_65744__$1 = state_65744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65744__$1,inst_65742);
} else {
if((state_val_65745 === (4))){
var inst_65718 = (state_65744[(8)]);
var inst_65722 = (state_65744[(9)]);
var inst_65720 = (state_65744[(11)]);
var inst_65729 = (state_65744[(2)]);
var inst_65730 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65722,inst_65718,inst_65729);
var inst_65731 = cljs.core.first(inst_65720);
var state_65744__$1 = (function (){var statearr_65807 = state_65744;
(statearr_65807[(12)] = inst_65730);

return statearr_65807;
})();
if(cljs.core.truth_(inst_65731)){
var statearr_65808_65854 = state_65744__$1;
(statearr_65808_65854[(1)] = (5));

} else {
var statearr_65809_65855 = state_65744__$1;
(statearr_65809_65855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65745 === (5))){
var inst_65721 = (state_65744[(7)]);
var inst_65730 = (state_65744[(12)]);
var inst_65720 = (state_65744[(11)]);
var inst_65733 = cljs.core.first(inst_65720);
var inst_65734 = cljs.core.first(inst_65721);
var inst_65735 = cljs.core.rest(inst_65720);
var inst_65736 = cljs.core.rest(inst_65721);
var inst_65718 = inst_65733;
var inst_65719 = inst_65734;
var inst_65720__$1 = inst_65735;
var inst_65721__$1 = inst_65736;
var inst_65722 = inst_65730;
var state_65744__$1 = (function (){var statearr_65810 = state_65744;
(statearr_65810[(7)] = inst_65721__$1);

(statearr_65810[(8)] = inst_65718);

(statearr_65810[(9)] = inst_65722);

(statearr_65810[(10)] = inst_65719);

(statearr_65810[(11)] = inst_65720__$1);

return statearr_65810;
})();
var statearr_65811_65856 = state_65744__$1;
(statearr_65811_65856[(2)] = null);

(statearr_65811_65856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65745 === (6))){
var inst_65730 = (state_65744[(12)]);
var state_65744__$1 = state_65744;
var statearr_65812_65857 = state_65744__$1;
(statearr_65812_65857[(2)] = inst_65730);

(statearr_65812_65857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65745 === (7))){
var inst_65740 = (state_65744[(2)]);
var state_65744__$1 = state_65744;
var statearr_65813_65858 = state_65744__$1;
(statearr_65813_65858[(2)] = inst_65740);

(statearr_65813_65858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_65814 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65814[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_65814[(1)] = (1));

return statearr_65814;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_65744){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65744);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65815){var ex__2687__auto__ = e65815;
var statearr_65816_65859 = state_65744;
(statearr_65816_65859[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65744[(4)]))){
var statearr_65817_65860 = state_65744;
(statearr_65817_65860[(1)] = cljs.core.first((state_65744[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65861 = state_65744;
state_65744 = G__65861;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_65744){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_65744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65818 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65818[(6)] = c__2706__auto____$1);

return statearr_65818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_65748 = cljs.core.async.impl.dispatch.run(inst_65747);
var state_65800__$1 = (function (){var statearr_65819 = state_65800;
(statearr_65819[(11)] = inst_65748);

return statearr_65819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65800__$1,(2),inst_65746);
} else {
if((state_val_65801 === (4))){
var inst_65751 = (state_65800[(8)]);
var state_65800__$1 = state_65800;
var statearr_65820_65862 = state_65800__$1;
(statearr_65820_65862[(2)] = inst_65751);

(statearr_65820_65862[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (15))){
var state_65800__$1 = state_65800;
var statearr_65821_65863 = state_65800__$1;
(statearr_65821_65863[(2)] = (400));

(statearr_65821_65863[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (13))){
var state_65800__$1 = state_65800;
var statearr_65822_65864 = state_65800__$1;
(statearr_65822_65864[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (6))){
var inst_65757 = (state_65800[(10)]);
var inst_65765 = cljs.core.first(inst_65757);
var state_65800__$1 = state_65800;
var statearr_65824_65865 = state_65800__$1;
(statearr_65824_65865[(2)] = inst_65765);

(statearr_65824_65865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (17))){
var inst_65778 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
var statearr_65825_65866 = state_65800__$1;
(statearr_65825_65866[(2)] = inst_65778);

(statearr_65825_65866[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (3))){
var inst_65761 = (state_65800[(7)]);
var inst_65751 = (state_65800[(8)]);
var inst_65754 = (state_65800[(9)]);
var inst_65757 = (state_65800[(10)]);
var inst_65756 = cljs.core.vals(inst_65751);
var inst_65757__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_65756);
var inst_65758 = (function (){var responses = inst_65751;
var responses_STAR_ = inst_65754;
var statuses = inst_65757__$1;
return (function (p1__65705_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__65705_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_65759 = cljs.core.vals(inst_65751);
var inst_65760 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_65758,inst_65759);
var inst_65761__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_65760);
var inst_65762 = (function (){var responses = inst_65751;
var responses_STAR_ = inst_65754;
var statuses = inst_65757__$1;
var fuel = inst_65761__$1;
return (function (p1__65706_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__65706_SHARP_);
});
})();
var inst_65763 = cljs.core.every_QMARK_(inst_65762,inst_65757__$1);
var state_65800__$1 = (function (){var statearr_65826 = state_65800;
(statearr_65826[(7)] = inst_65761__$1);

(statearr_65826[(10)] = inst_65757__$1);

return statearr_65826;
})();
if(inst_65763){
var statearr_65827_65867 = state_65800__$1;
(statearr_65827_65867[(1)] = (6));

} else {
var statearr_65828_65868 = state_65800__$1;
(statearr_65828_65868[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (12))){
var state_65800__$1 = state_65800;
var statearr_65829_65869 = state_65800__$1;
(statearr_65829_65869[(2)] = (500));

(statearr_65829_65869[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (2))){
var inst_65751 = (state_65800[(8)]);
var inst_65750 = (state_65800[(2)]);
var inst_65751__$1 = fluree.db.util.async.throw_err(inst_65750);
var inst_65752 = (function (){var responses = inst_65751__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_65753 = cljs.core.PersistentHashMap.EMPTY;
var inst_65754 = cljs.core.reduce_kv(inst_65752,inst_65753,inst_65751__$1);
var state_65800__$1 = (function (){var statearr_65830 = state_65800;
(statearr_65830[(8)] = inst_65751__$1);

(statearr_65830[(9)] = inst_65754);

return statearr_65830;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_65831_65870 = state_65800__$1;
(statearr_65831_65870[(1)] = (3));

} else {
var statearr_65832_65871 = state_65800__$1;
(statearr_65832_65871[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (19))){
var inst_65784 = (state_65800[(12)]);
var inst_65761 = (state_65800[(7)]);
var inst_65754 = (state_65800[(9)]);
var inst_65793 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65754,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65784,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65761], 0));
var state_65800__$1 = state_65800;
var statearr_65833_65872 = state_65800__$1;
(statearr_65833_65872[(2)] = inst_65793);

(statearr_65833_65872[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (11))){
var inst_65782 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
var statearr_65834_65873 = state_65800__$1;
(statearr_65834_65873[(2)] = inst_65782);

(statearr_65834_65873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (9))){
var state_65800__$1 = state_65800;
var statearr_65835_65874 = state_65800__$1;
(statearr_65835_65874[(2)] = (207));

(statearr_65835_65874[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (5))){
var inst_65798 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65800__$1,inst_65798);
} else {
if((state_val_65801 === (14))){
var inst_65780 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
var statearr_65836_65875 = state_65800__$1;
(statearr_65836_65875[(2)] = inst_65780);

(statearr_65836_65875[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (16))){
var state_65800__$1 = state_65800;
var statearr_65837_65876 = state_65800__$1;
(statearr_65837_65876[(2)] = null);

(statearr_65837_65876[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (10))){
var inst_65761 = (state_65800[(7)]);
var inst_65751 = (state_65800[(8)]);
var inst_65754 = (state_65800[(9)]);
var inst_65757 = (state_65800[(10)]);
var inst_65771 = (function (){var responses = inst_65751;
var responses_STAR_ = inst_65754;
var statuses = inst_65757;
var fuel = inst_65761;
return (function (p1__65708_SHARP_){
return ((499) < p1__65708_SHARP_);
});
})();
var inst_65772 = cljs.core.some(inst_65771,inst_65757);
var state_65800__$1 = state_65800;
if(cljs.core.truth_(inst_65772)){
var statearr_65838_65877 = state_65800__$1;
(statearr_65838_65877[(1)] = (12));

} else {
var statearr_65839_65878 = state_65800__$1;
(statearr_65839_65878[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (18))){
var inst_65784 = (state_65800[(12)]);
var inst_65761 = (state_65800[(7)]);
var inst_65754 = (state_65800[(9)]);
var inst_65789 = (state_65800[(13)]);
var inst_65791 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65754,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65784,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65761,new cljs.core.Keyword(null,"block","block",664686210),inst_65789], 0));
var state_65800__$1 = state_65800;
var statearr_65840_65879 = state_65800__$1;
(statearr_65840_65879[(2)] = inst_65791);

(statearr_65840_65879[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65801 === (8))){
var inst_65784 = (state_65800[(12)]);
var inst_65761 = (state_65800[(7)]);
var inst_65751 = (state_65800[(8)]);
var inst_65754 = (state_65800[(9)]);
var inst_65789 = (state_65800[(13)]);
var inst_65757 = (state_65800[(10)]);
var inst_65784__$1 = (state_65800[(2)]);
var inst_65785 = (function (){var responses = inst_65751;
var responses_STAR_ = inst_65754;
var statuses = inst_65757;
var fuel = inst_65761;
var status = inst_65784__$1;
return (function (p1__65709_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__65709_SHARP_));
});
})();
var inst_65786 = cljs.core.vals(inst_65751);
var inst_65787 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_65785,inst_65786);
var inst_65788 = cljs.core.first(inst_65787);
var inst_65789__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65788);
var state_65800__$1 = (function (){var statearr_65841 = state_65800;
(statearr_65841[(12)] = inst_65784__$1);

(statearr_65841[(13)] = inst_65789__$1);

return statearr_65841;
})();
if(cljs.core.truth_(inst_65789__$1)){
var statearr_65842_65880 = state_65800__$1;
(statearr_65842_65880[(1)] = (18));

} else {
var statearr_65843_65881 = state_65800__$1;
(statearr_65843_65881[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_65844 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65844[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_65844[(1)] = (1));

return statearr_65844;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_65800){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65800);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65845){var ex__2687__auto__ = e65845;
var statearr_65846_65882 = state_65800;
(statearr_65846_65882[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65800[(4)]))){
var statearr_65847_65883 = state_65800;
(statearr_65847_65883[(1)] = cljs.core.first((state_65800[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65884 = state_65800;
state_65800 = G__65884;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_65800){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_65800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65848 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65848[(6)] = c__2706__auto__);

return statearr_65848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__65886 = arguments.length;
switch (G__65886) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__65887 = opts;
var map__65887__$1 = cljs.core.__destructure_map(map__65887);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65887__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65887__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65887__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65887__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__65888 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65888,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65888,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e65891){var e = e65891;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__65894 = arguments.length;
switch (G__65894) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65925){
var state_val_65926 = (state_65925[(1)]);
if((state_val_65926 === (7))){
var state_65925__$1 = state_65925;
var statearr_65927_65948 = state_65925__$1;
(statearr_65927_65948[(2)] = opts);

(statearr_65927_65948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65926 === (1))){
var state_65925__$1 = state_65925;
var statearr_65928_65949 = state_65925__$1;
(statearr_65928_65949[(2)] = null);

(statearr_65928_65949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65926 === (4))){
var inst_65895 = (state_65925[(2)]);
var inst_65896 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65895], 0));
var inst_65897 = cljs.core.ex_data(inst_65895);
var inst_65898 = cljs.core.ex_message(inst_65895);
var inst_65899 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65897,new cljs.core.Keyword(null,"message","message",-406056002),inst_65898);
var state_65925__$1 = (function (){var statearr_65929 = state_65925;
(statearr_65929[(7)] = inst_65896);

return statearr_65929;
})();
var statearr_65930_65950 = state_65925__$1;
(statearr_65930_65950[(2)] = inst_65899);

(statearr_65930_65950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65926 === (6))){
var inst_65909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65910 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_65911 = (new cljs.core.PersistentVector(null,1,(5),inst_65909,inst_65910,null));
var inst_65912 = cljs.core.assoc_in(opts,inst_65911,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65925__$1 = state_65925;
var statearr_65931_65951 = state_65925__$1;
(statearr_65931_65951[(2)] = inst_65912);

(statearr_65931_65951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65926 === (3))){
var inst_65923 = (state_65925[(2)]);
var state_65925__$1 = state_65925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65925__$1,inst_65923);
} else {
if((state_val_65926 === (2))){
var _ = (function (){var statearr_65933 = state_65925;
(statearr_65933[(4)] = cljs.core.cons((5),(state_65925[(4)])));

return statearr_65933;
})();
var inst_65905 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65906 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65907 = (inst_65906 == null);
var state_65925__$1 = (function (){var statearr_65934 = state_65925;
(statearr_65934[(8)] = inst_65905);

return statearr_65934;
})();
if(cljs.core.truth_(inst_65907)){
var statearr_65935_65952 = state_65925__$1;
(statearr_65935_65952[(1)] = (6));

} else {
var statearr_65936_65953 = state_65925__$1;
(statearr_65936_65953[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65926 === (9))){
var inst_65919 = (state_65925[(2)]);
var inst_65920 = fluree.db.util.async.throw_err(inst_65919);
var _ = (function (){var statearr_65937 = state_65925;
(statearr_65937[(4)] = cljs.core.rest((state_65925[(4)])));

return statearr_65937;
})();
var state_65925__$1 = state_65925;
var statearr_65938_65954 = state_65925__$1;
(statearr_65938_65954[(2)] = inst_65920);

(statearr_65938_65954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65926 === (5))){
var _ = (function (){var statearr_65939 = state_65925;
(statearr_65939[(4)] = cljs.core.rest((state_65925[(4)])));

return statearr_65939;
})();
var state_65925__$1 = state_65925;
var ex65932 = (state_65925__$1[(2)]);
var statearr_65940_65955 = state_65925__$1;
(statearr_65940_65955[(5)] = ex65932);


var statearr_65941_65956 = state_65925__$1;
(statearr_65941_65956[(1)] = (4));

(statearr_65941_65956[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65926 === (8))){
var inst_65905 = (state_65925[(8)]);
var inst_65915 = (state_65925[(2)]);
var inst_65916 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_65905,inst_65915);
var inst_65917 = fluree.db.operations.command_async(conn,inst_65916);
var state_65925__$1 = state_65925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65925__$1,(9),inst_65917);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_65942 = [null,null,null,null,null,null,null,null,null];
(statearr_65942[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_65942[(1)] = (1));

return statearr_65942;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_65925){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65925);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65943){var ex__2687__auto__ = e65943;
var statearr_65944_65957 = state_65925;
(statearr_65944_65957[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65925[(4)]))){
var statearr_65945_65958 = state_65925;
(statearr_65945_65958[(1)] = cljs.core.first((state_65925[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65959 = state_65925;
state_65925 = G__65959;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_65925){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_65925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65946 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65946[(6)] = c__2706__auto__);

return statearr_65946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

