// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62409_62578 = cljs.core.seq(servers);
var chunk__62410_62579 = null;
var count__62411_62580 = (0);
var i__62412_62581 = (0);
while(true){
if((i__62412_62581 < count__62411_62580)){
var server_62582 = chunk__62410_62579.cljs$core$IIndexed$_nth$arity$2(null,i__62412_62581);
var healthcheck_uri_62583 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62582),"/fdb/health"].join('');
var resp_chan_62584 = fluree.db.util.xhttp.post_json(healthcheck_uri_62583,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___62585 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582){
return (function (state_62473){
var state_val_62474 = (state_62473[(1)]);
if((state_val_62474 === (1))){
var state_62473__$1 = state_62473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62473__$1,(2),resp_chan_62584);
} else {
if((state_val_62474 === (2))){
var inst_62462 = (state_62473[(7)]);
var inst_62462__$1 = (state_62473[(2)]);
var inst_62463 = fluree.db.util.core.exception_QMARK_(inst_62462__$1);
var state_62473__$1 = (function (){var statearr_62475 = state_62473;
(statearr_62475[(7)] = inst_62462__$1);

return statearr_62475;
})();
if(inst_62463){
var statearr_62476_62586 = state_62473__$1;
(statearr_62476_62586[(1)] = (3));

} else {
var statearr_62477_62587 = state_62473__$1;
(statearr_62477_62587[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62474 === (3))){
var inst_62462 = (state_62473[(7)]);
var inst_62465 = cljs.core.ex_message(inst_62462);
var inst_62466 = cljs.core.ex_data(inst_62462);
var inst_62467 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62465,inst_62466], 0));
var state_62473__$1 = state_62473;
var statearr_62478_62588 = state_62473__$1;
(statearr_62478_62588[(2)] = inst_62467);

(statearr_62478_62588[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62474 === (4))){
var inst_62469 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62582);
var state_62473__$1 = state_62473;
var statearr_62479_62589 = state_62473__$1;
(statearr_62479_62589[(2)] = inst_62469);

(statearr_62479_62589[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62474 === (5))){
var inst_62471 = (state_62473[(2)]);
var state_62473__$1 = state_62473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62473__$1,inst_62471);
} else {
return null;
}
}
}
}
}
});})(seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582))
;
return ((function (seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,switch__2683__auto__,c__2706__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_62480 = [null,null,null,null,null,null,null,null];
(statearr_62480[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_62480[(1)] = (1));

return statearr_62480;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_62473){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62473);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e62481){var ex__2687__auto__ = e62481;
var statearr_62482_62590 = state_62473;
(statearr_62482_62590[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62473[(4)]))){
var statearr_62483_62591 = state_62473;
(statearr_62483_62591[(1)] = cljs.core.first((state_62473[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62592 = state_62473;
state_62473 = G__62592;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_62473){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_62473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,switch__2683__auto__,c__2706__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582))
})();
var state__2708__auto__ = (function (){var statearr_62484 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_62484[(6)] = c__2706__auto___62585);

return statearr_62484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62585,healthcheck_uri_62583,resp_chan_62584,server_62582))
);



var G__62593 = seq__62409_62578;
var G__62594 = chunk__62410_62579;
var G__62595 = count__62411_62580;
var G__62596 = (i__62412_62581 + (1));
seq__62409_62578 = G__62593;
chunk__62410_62579 = G__62594;
count__62411_62580 = G__62595;
i__62412_62581 = G__62596;
continue;
} else {
var temp__5804__auto___62597 = cljs.core.seq(seq__62409_62578);
if(temp__5804__auto___62597){
var seq__62409_62598__$1 = temp__5804__auto___62597;
if(cljs.core.chunked_seq_QMARK_(seq__62409_62598__$1)){
var c__5568__auto___62599 = cljs.core.chunk_first(seq__62409_62598__$1);
var G__62600 = cljs.core.chunk_rest(seq__62409_62598__$1);
var G__62601 = c__5568__auto___62599;
var G__62602 = cljs.core.count(c__5568__auto___62599);
var G__62603 = (0);
seq__62409_62578 = G__62600;
chunk__62410_62579 = G__62601;
count__62411_62580 = G__62602;
i__62412_62581 = G__62603;
continue;
} else {
var server_62604 = cljs.core.first(seq__62409_62598__$1);
var healthcheck_uri_62605 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62604),"/fdb/health"].join('');
var resp_chan_62606 = fluree.db.util.xhttp.post_json(healthcheck_uri_62605,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___62607 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62607,healthcheck_uri_62605,resp_chan_62606,server_62604,seq__62409_62598__$1,temp__5804__auto___62597){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62607,healthcheck_uri_62605,resp_chan_62606,server_62604,seq__62409_62598__$1,temp__5804__auto___62597){
return (function (state_62497){
var state_val_62498 = (state_62497[(1)]);
if((state_val_62498 === (1))){
var state_62497__$1 = state_62497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62497__$1,(2),resp_chan_62606);
} else {
if((state_val_62498 === (2))){
var inst_62486 = (state_62497[(7)]);
var inst_62486__$1 = (state_62497[(2)]);
var inst_62487 = fluree.db.util.core.exception_QMARK_(inst_62486__$1);
var state_62497__$1 = (function (){var statearr_62499 = state_62497;
(statearr_62499[(7)] = inst_62486__$1);

return statearr_62499;
})();
if(inst_62487){
var statearr_62500_62608 = state_62497__$1;
(statearr_62500_62608[(1)] = (3));

} else {
var statearr_62501_62609 = state_62497__$1;
(statearr_62501_62609[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62498 === (3))){
var inst_62486 = (state_62497[(7)]);
var inst_62489 = cljs.core.ex_message(inst_62486);
var inst_62490 = cljs.core.ex_data(inst_62486);
var inst_62491 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62489,inst_62490], 0));
var state_62497__$1 = state_62497;
var statearr_62502_62610 = state_62497__$1;
(statearr_62502_62610[(2)] = inst_62491);

(statearr_62502_62610[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62498 === (4))){
var inst_62493 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62604);
var state_62497__$1 = state_62497;
var statearr_62503_62611 = state_62497__$1;
(statearr_62503_62611[(2)] = inst_62493);

(statearr_62503_62611[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62498 === (5))){
var inst_62495 = (state_62497[(2)]);
var state_62497__$1 = state_62497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62497__$1,inst_62495);
} else {
return null;
}
}
}
}
}
});})(seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62607,healthcheck_uri_62605,resp_chan_62606,server_62604,seq__62409_62598__$1,temp__5804__auto___62597))
;
return ((function (seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,switch__2683__auto__,c__2706__auto___62607,healthcheck_uri_62605,resp_chan_62606,server_62604,seq__62409_62598__$1,temp__5804__auto___62597){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_62504 = [null,null,null,null,null,null,null,null];
(statearr_62504[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_62504[(1)] = (1));

return statearr_62504;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_62497){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62497);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e62505){var ex__2687__auto__ = e62505;
var statearr_62506_62612 = state_62497;
(statearr_62506_62612[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62497[(4)]))){
var statearr_62507_62613 = state_62497;
(statearr_62507_62613[(1)] = cljs.core.first((state_62497[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62614 = state_62497;
state_62497 = G__62614;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_62497){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_62497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,switch__2683__auto__,c__2706__auto___62607,healthcheck_uri_62605,resp_chan_62606,server_62604,seq__62409_62598__$1,temp__5804__auto___62597))
})();
var state__2708__auto__ = (function (){var statearr_62508 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_62508[(6)] = c__2706__auto___62607);

return statearr_62508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__62409_62578,chunk__62410_62579,count__62411_62580,i__62412_62581,c__2706__auto___62607,healthcheck_uri_62605,resp_chan_62606,server_62604,seq__62409_62598__$1,temp__5804__auto___62597))
);



var G__62615 = cljs.core.next(seq__62409_62598__$1);
var G__62616 = null;
var G__62617 = (0);
var G__62618 = (0);
seq__62409_62578 = G__62615;
chunk__62410_62579 = G__62616;
count__62411_62580 = G__62617;
i__62412_62581 = G__62618;
continue;
}
} else {
}
}
break;
}

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_62552){
var state_val_62553 = (state_62552[(1)]);
if((state_val_62553 === (7))){
var inst_62524 = (state_62552[(7)]);
var inst_62531 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62524,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62552__$1 = state_62552;
if(inst_62531){
var statearr_62554_62619 = state_62552__$1;
(statearr_62554_62619[(1)] = (9));

} else {
var statearr_62555_62620 = state_62552__$1;
(statearr_62555_62620[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (1))){
var inst_62517 = (state_62552[(8)]);
var inst_62516 = (state_62552[(9)]);
var inst_62516__$1 = promise_chan;
var inst_62517__$1 = cljs.core.async.timeout((60000));
var inst_62518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62519 = [inst_62516__$1,inst_62517__$1];
var inst_62520 = (new cljs.core.PersistentVector(null,2,(5),inst_62518,inst_62519,null));
var state_62552__$1 = (function (){var statearr_62556 = state_62552;
(statearr_62556[(8)] = inst_62517__$1);

(statearr_62556[(9)] = inst_62516__$1);

return statearr_62556;
})();
return cljs.core.async.ioc_alts_BANG_(state_62552__$1,(2),inst_62520);
} else {
if((state_val_62553 === (4))){
var inst_62517 = (state_62552[(8)]);
var inst_62524 = (state_62552[(7)]);
var inst_62528 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62524,inst_62517);
var state_62552__$1 = state_62552;
if(inst_62528){
var statearr_62557_62621 = state_62552__$1;
(statearr_62557_62621[(1)] = (6));

} else {
var statearr_62558_62622 = state_62552__$1;
(statearr_62558_62622[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (13))){
var state_62552__$1 = state_62552;
var statearr_62559_62623 = state_62552__$1;
(statearr_62559_62623[(2)] = null);

(statearr_62559_62623[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (6))){
var state_62552__$1 = state_62552;
var statearr_62560_62624 = state_62552__$1;
(statearr_62560_62624[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62560_62624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (3))){
var state_62552__$1 = state_62552;
var statearr_62561_62625 = state_62552__$1;
(statearr_62561_62625[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62561_62625[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (12))){
var inst_62542 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_62543 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62544 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62545 = cljs.core.PersistentHashMap.fromArrays(inst_62543,inst_62544);
var inst_62546 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_62545);
var inst_62547 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_62546);
var state_62552__$1 = (function (){var statearr_62562 = state_62552;
(statearr_62562[(10)] = inst_62542);

return statearr_62562;
})();
var statearr_62563_62626 = state_62552__$1;
(statearr_62563_62626[(2)] = inst_62547);

(statearr_62563_62626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (2))){
var inst_62524 = (state_62552[(7)]);
var inst_62516 = (state_62552[(9)]);
var inst_62522 = (state_62552[(2)]);
var inst_62523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62522,(0),null);
var inst_62524__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62522,(1),null);
var inst_62525 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62524__$1,inst_62516);
var state_62552__$1 = (function (){var statearr_62564 = state_62552;
(statearr_62564[(11)] = inst_62523);

(statearr_62564[(7)] = inst_62524__$1);

return statearr_62564;
})();
if(inst_62525){
var statearr_62565_62627 = state_62552__$1;
(statearr_62565_62627[(1)] = (3));

} else {
var statearr_62566_62628 = state_62552__$1;
(statearr_62566_62628[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (11))){
var inst_62535 = (state_62552[(2)]);
var state_62552__$1 = state_62552;
var statearr_62567_62629 = state_62552__$1;
(statearr_62567_62629[(2)] = inst_62535);

(statearr_62567_62629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (9))){
var inst_62523 = (state_62552[(11)]);
var state_62552__$1 = state_62552;
var statearr_62568_62630 = state_62552__$1;
(statearr_62568_62630[(2)] = inst_62523);

(statearr_62568_62630[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (5))){
var inst_62539 = (state_62552[(2)]);
var inst_62540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62539);
var state_62552__$1 = state_62552;
if(inst_62540){
var statearr_62569_62631 = state_62552__$1;
(statearr_62569_62631[(1)] = (12));

} else {
var statearr_62570_62632 = state_62552__$1;
(statearr_62570_62632[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (14))){
var inst_62550 = (state_62552[(2)]);
var state_62552__$1 = state_62552;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62552__$1,inst_62550);
} else {
if((state_val_62553 === (10))){
var state_62552__$1 = state_62552;
var statearr_62571_62633 = state_62552__$1;
(statearr_62571_62633[(2)] = null);

(statearr_62571_62633[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62553 === (8))){
var inst_62537 = (state_62552[(2)]);
var state_62552__$1 = state_62552;
var statearr_62572_62634 = state_62552__$1;
(statearr_62572_62634[(2)] = inst_62537);

(statearr_62572_62634[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_62573 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62573[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_62573[(1)] = (1));

return statearr_62573;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_62552){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62552);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e62574){var ex__2687__auto__ = e62574;
var statearr_62575_62635 = state_62552;
(statearr_62575_62635[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62552[(4)]))){
var statearr_62576_62636 = state_62552;
(statearr_62576_62636[(1)] = cljs.core.first((state_62552[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62637 = state_62552;
state_62552 = G__62637;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_62552){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_62552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_62577 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_62577[(6)] = c__2706__auto__);

return statearr_62577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_62681){
var state_val_62682 = (state_62681[(1)]);
if((state_val_62682 === (7))){
var state_62681__$1 = state_62681;
var statearr_62683_62709 = state_62681__$1;
(statearr_62683_62709[(2)] = null);

(statearr_62683_62709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (1))){
var state_62681__$1 = state_62681;
var statearr_62684_62710 = state_62681__$1;
(statearr_62684_62710[(2)] = null);

(statearr_62684_62710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (4))){
var inst_62638 = (state_62681[(2)]);
var state_62681__$1 = state_62681;
var statearr_62685_62711 = state_62681__$1;
(statearr_62685_62711[(2)] = inst_62638);

(statearr_62685_62711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (6))){
var inst_62660 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_62681__$1 = state_62681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62681__$1,(9),inst_62660);
} else {
if((state_val_62682 === (3))){
var inst_62679 = (state_62681[(2)]);
var state_62681__$1 = state_62681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62681__$1,inst_62679);
} else {
if((state_val_62682 === (12))){
var inst_62673 = (state_62681[(2)]);
var state_62681__$1 = state_62681;
var statearr_62686_62712 = state_62681__$1;
(statearr_62686_62712[(2)] = inst_62673);

(statearr_62686_62712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (2))){
var inst_62654 = (state_62681[(7)]);
var inst_62644 = (state_62681[(8)]);
var inst_62649 = (state_62681[(9)]);
var _ = (function (){var statearr_62687 = state_62681;
(statearr_62687[(4)] = cljs.core.cons((5),(state_62681[(4)])));

return statearr_62687;
})();
var inst_62644__$1 = fluree.db.util.core.random_uuid();
var inst_62645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62646 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62647 = (new cljs.core.PersistentVector(null,2,(5),inst_62645,inst_62646,null));
var inst_62648 = (function (){var lock_id = inst_62644__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_62649__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62647,inst_62648);
var inst_62650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62651 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62652 = (new cljs.core.PersistentVector(null,3,(5),inst_62650,inst_62651,null));
var inst_62653 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62649__$1,inst_62652);
var inst_62654__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62644__$1,inst_62653);
var inst_62655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62656 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62657 = (new cljs.core.PersistentVector(null,3,(5),inst_62655,inst_62656,null));
var inst_62658 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62649__$1,inst_62657);
var state_62681__$1 = (function (){var statearr_62688 = state_62681;
(statearr_62688[(7)] = inst_62654__$1);

(statearr_62688[(8)] = inst_62644__$1);

(statearr_62688[(9)] = inst_62649__$1);

(statearr_62688[(10)] = inst_62658);

return statearr_62688;
})();
if(inst_62654__$1){
var statearr_62689_62713 = state_62681__$1;
(statearr_62689_62713[(1)] = (6));

} else {
var statearr_62690_62714 = state_62681__$1;
(statearr_62690_62714[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (11))){
var inst_62665 = (state_62681[(11)]);
var inst_62664 = (state_62681[(12)]);
var inst_62658 = (state_62681[(10)]);
var inst_62671 = fluree.db.util.xhttp.try_socket(inst_62664,sub_chan,pub_chan,inst_62658,(60000),inst_62665);
var state_62681__$1 = state_62681;
var statearr_62692_62715 = state_62681__$1;
(statearr_62692_62715[(2)] = inst_62671);

(statearr_62692_62715[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (9))){
var inst_62654 = (state_62681[(7)]);
var inst_62644 = (state_62681[(8)]);
var inst_62664 = (state_62681[(12)]);
var inst_62662 = (state_62681[(13)]);
var inst_62649 = (state_62681[(9)]);
var inst_62658 = (state_62681[(10)]);
var inst_62662__$1 = (state_62681[(2)]);
var inst_62663 = clojure.string.replace(inst_62662__$1,"http","ws");
var inst_62664__$1 = [inst_62663,"/fdb/ws"].join('');
var inst_62665 = (function (){var lock_id = inst_62644;
var state = inst_62649;
var have_lock_QMARK_ = inst_62654;
var resp_chan = inst_62658;
var healthy_server = inst_62662__$1;
var ws_url = inst_62664__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_62666 = fluree.db.util.core.exception_QMARK_(inst_62662__$1);
var state_62681__$1 = (function (){var statearr_62693 = state_62681;
(statearr_62693[(11)] = inst_62665);

(statearr_62693[(12)] = inst_62664__$1);

(statearr_62693[(13)] = inst_62662__$1);

return statearr_62693;
})();
if(inst_62666){
var statearr_62694_62716 = state_62681__$1;
(statearr_62694_62716[(1)] = (10));

} else {
var statearr_62695_62717 = state_62681__$1;
(statearr_62695_62717[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (5))){
var _ = (function (){var statearr_62696 = state_62681;
(statearr_62696[(4)] = cljs.core.rest((state_62681[(4)])));

return statearr_62696;
})();
var state_62681__$1 = state_62681;
var ex62691 = (state_62681__$1[(2)]);
var statearr_62697_62718 = state_62681__$1;
(statearr_62697_62718[(5)] = ex62691);


if((ex62691 instanceof Error)){
var statearr_62698_62719 = state_62681__$1;
(statearr_62698_62719[(1)] = (4));

(statearr_62698_62719[(5)] = null);

} else {
throw ex62691;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (10))){
var inst_62662 = (state_62681[(13)]);
var inst_62658 = (state_62681[(10)]);
var inst_62668 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_62669 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62658,inst_62662);
var state_62681__$1 = (function (){var statearr_62699 = state_62681;
(statearr_62699[(14)] = inst_62668);

return statearr_62699;
})();
var statearr_62700_62720 = state_62681__$1;
(statearr_62700_62720[(2)] = inst_62669);

(statearr_62700_62720[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62682 === (8))){
var inst_62658 = (state_62681[(10)]);
var inst_62676 = (state_62681[(2)]);
var _ = (function (){var statearr_62701 = state_62681;
(statearr_62701[(4)] = cljs.core.rest((state_62681[(4)])));

return statearr_62701;
})();
var state_62681__$1 = (function (){var statearr_62702 = state_62681;
(statearr_62702[(15)] = inst_62676);

return statearr_62702;
})();
var statearr_62703_62721 = state_62681__$1;
(statearr_62703_62721[(2)] = inst_62658);

(statearr_62703_62721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_62704 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62704[(0)] = fluree$db$connection$establish_socket_$_state_machine__2684__auto__);

(statearr_62704[(1)] = (1));

return statearr_62704;
});
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____1 = (function (state_62681){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62681);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e62705){var ex__2687__auto__ = e62705;
var statearr_62706_62722 = state_62681;
(statearr_62706_62722[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62681[(4)]))){
var statearr_62707_62723 = state_62681;
(statearr_62707_62723[(1)] = cljs.core.first((state_62681[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62724 = state_62681;
state_62681 = G__62724;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = function(state_62681){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____1.call(this,state_62681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_62708 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_62708[(6)] = c__2706__auto__);

return statearr_62708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k62726,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__62730 = k62726;
var G__62730__$1 = (((G__62730 instanceof cljs.core.Keyword))?G__62730.fqn:null);
switch (G__62730__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k62726,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__62731){
var vec__62732 = p__62731;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62732,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62732,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62725){
var self__ = this;
var G__62725__$1 = this;
return (new cljs.core.RecordIter((0),G__62725__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__62735 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__62735(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62727,other62728){
var self__ = this;
var this62727__$1 = this;
return (((!((other62728 == null)))) && ((((this62727__$1.constructor === other62728.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.id,other62728.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.servers,other62728.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.state,other62728.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.req_chan,other62728.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.sub_chan,other62728.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.pub_chan,other62728.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.group,other62728.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.storage_read,other62728.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.storage_write,other62728.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.object_cache,other62728.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.parallelism,other62728.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.serializer,other62728.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.default_network,other62728.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.transactor_QMARK_,other62728.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.publish,other62728.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.transact_handler,other62728.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.tx_private_key,other62728.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.tx_key_id,other62728.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.meta,other62728.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.add_listener,other62728.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.remove_listener,other62728.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.close,other62728.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62727__$1.__extmap,other62728.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k62726){
var self__ = this;
var this__5350__auto____$1 = this;
var G__62736 = k62726;
var G__62736__$1 = (((G__62736 instanceof cljs.core.Keyword))?G__62736.fqn:null);
switch (G__62736__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k62726);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__62725){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__62737 = cljs.core.keyword_identical_QMARK_;
var expr__62738 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__62740 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__62741 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62740,G__62741) : pred__62737.call(null,G__62740,G__62741));
})())){
return (new fluree.db.connection.Connection(G__62725,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62742 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__62743 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62742,G__62743) : pred__62737.call(null,G__62742,G__62743));
})())){
return (new fluree.db.connection.Connection(self__.id,G__62725,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62744 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__62745 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62744,G__62745) : pred__62737.call(null,G__62744,G__62745));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62725,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62746 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__62747 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62746,G__62747) : pred__62737.call(null,G__62746,G__62747));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62725,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62748 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__62749 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62748,G__62749) : pred__62737.call(null,G__62748,G__62749));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62725,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62750 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__62751 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62750,G__62751) : pred__62737.call(null,G__62750,G__62751));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62725,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62752 = new cljs.core.Keyword(null,"group","group",582596132);
var G__62753 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62752,G__62753) : pred__62737.call(null,G__62752,G__62753));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62725,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62754 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__62755 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62754,G__62755) : pred__62737.call(null,G__62754,G__62755));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__62725,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62756 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__62757 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62756,G__62757) : pred__62737.call(null,G__62756,G__62757));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__62725,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62758 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__62759 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62758,G__62759) : pred__62737.call(null,G__62758,G__62759));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__62725,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62760 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__62761 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62760,G__62761) : pred__62737.call(null,G__62760,G__62761));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__62725,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62762 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__62763 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62762,G__62763) : pred__62737.call(null,G__62762,G__62763));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62725,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62764 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__62765 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62764,G__62765) : pred__62737.call(null,G__62764,G__62765));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62725,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62766 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__62767 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62766,G__62767) : pred__62737.call(null,G__62766,G__62767));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62725,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62768 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__62769 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62768,G__62769) : pred__62737.call(null,G__62768,G__62769));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62725,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62770 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__62771 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62770,G__62771) : pred__62737.call(null,G__62770,G__62771));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62725,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62772 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__62773 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62772,G__62773) : pred__62737.call(null,G__62772,G__62773));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62725,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62774 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__62775 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62774,G__62775) : pred__62737.call(null,G__62774,G__62775));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62725,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62776 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__62777 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62776,G__62777) : pred__62737.call(null,G__62776,G__62777));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62725,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62778 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__62779 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62778,G__62779) : pred__62737.call(null,G__62778,G__62779));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62725,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62780 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__62781 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62780,G__62781) : pred__62737.call(null,G__62780,G__62781));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62725,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62782 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__62783 = expr__62738;
return (pred__62737.cljs$core$IFn$_invoke$arity$2 ? pred__62737.cljs$core$IFn$_invoke$arity$2(G__62782,G__62783) : pred__62737.call(null,G__62782,G__62783));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62725,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__62725),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__62725){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62725,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62729){
var extmap__5385__auto__ = (function (){var G__62784 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__62729,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__62729)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__62784);
} else {
return G__62784;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62729),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62729),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__62790 = servers_STAR_;
var vec__62791 = G__62790;
var seq__62792 = cljs.core.seq(vec__62791);
var first__62793 = cljs.core.first(seq__62792);
var seq__62792__$1 = cljs.core.next(seq__62792);
var server = first__62793;
var r = seq__62792__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62790__$1 = G__62790;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62797 = G__62790__$1;
var seq__62798 = cljs.core.seq(vec__62797);
var first__62799 = cljs.core.first(seq__62798);
var seq__62798__$1 = cljs.core.next(seq__62798);
var server__$1 = first__62799;
var r__$1 = seq__62798__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__62800 = r__$1;
var G__62801 = is_https_QMARK_;
var G__62802 = result_STAR_;
G__62790__$1 = G__62800;
https_QMARK___$1 = G__62801;
result__$1 = G__62802;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62803 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62803 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__62803);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_62832){
var state_val_62833 = (state_62832[(1)]);
if((state_val_62833 === (7))){
var inst_62818 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62819 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62820 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62821 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62822 = fluree.db.connection.establish_socket(inst_62818,inst_62819,inst_62820,inst_62821);
var state_62832__$1 = state_62832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62832__$1,(9),inst_62822);
} else {
if((state_val_62833 === (1))){
var state_62832__$1 = state_62832;
var statearr_62834_62853 = state_62832__$1;
(statearr_62834_62853[(2)] = null);

(statearr_62834_62853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (4))){
var inst_62804 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62835_62854 = state_62832__$1;
(statearr_62835_62854[(2)] = inst_62804);

(statearr_62835_62854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (6))){
var inst_62815 = (state_62832[(7)]);
var state_62832__$1 = state_62832;
var statearr_62836_62855 = state_62832__$1;
(statearr_62836_62855[(2)] = inst_62815);

(statearr_62836_62855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (3))){
var inst_62830 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62832__$1,inst_62830);
} else {
if((state_val_62833 === (2))){
var inst_62815 = (state_62832[(7)]);
var _ = (function (){var statearr_62838 = state_62832;
(statearr_62838[(4)] = cljs.core.cons((5),(state_62832[(4)])));

return statearr_62838;
})();
var inst_62810 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62812 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62813 = [inst_62812,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62814 = (new cljs.core.PersistentVector(null,3,(5),inst_62811,inst_62813,null));
var inst_62815__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62810,inst_62814);
var state_62832__$1 = (function (){var statearr_62839 = state_62832;
(statearr_62839[(7)] = inst_62815__$1);

return statearr_62839;
})();
if(cljs.core.truth_(inst_62815__$1)){
var statearr_62840_62856 = state_62832__$1;
(statearr_62840_62856[(1)] = (6));

} else {
var statearr_62841_62857 = state_62832__$1;
(statearr_62841_62857[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (9))){
var inst_62824 = (state_62832[(2)]);
var inst_62825 = fluree.db.util.async.throw_err(inst_62824);
var state_62832__$1 = state_62832;
var statearr_62842_62858 = state_62832__$1;
(statearr_62842_62858[(2)] = inst_62825);

(statearr_62842_62858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (5))){
var _ = (function (){var statearr_62843 = state_62832;
(statearr_62843[(4)] = cljs.core.rest((state_62832[(4)])));

return statearr_62843;
})();
var state_62832__$1 = state_62832;
var ex62837 = (state_62832__$1[(2)]);
var statearr_62844_62859 = state_62832__$1;
(statearr_62844_62859[(5)] = ex62837);


if((ex62837 instanceof Error)){
var statearr_62845_62860 = state_62832__$1;
(statearr_62845_62860[(1)] = (4));

(statearr_62845_62860[(5)] = null);

} else {
throw ex62837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (8))){
var inst_62827 = (state_62832[(2)]);
var _ = (function (){var statearr_62846 = state_62832;
(statearr_62846[(4)] = cljs.core.rest((state_62832[(4)])));

return statearr_62846;
})();
var state_62832__$1 = state_62832;
var statearr_62847_62861 = state_62832__$1;
(statearr_62847_62861[(2)] = inst_62827);

(statearr_62847_62861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_62848 = [null,null,null,null,null,null,null,null];
(statearr_62848[(0)] = fluree$db$connection$get_socket_$_state_machine__2684__auto__);

(statearr_62848[(1)] = (1));

return statearr_62848;
});
var fluree$db$connection$get_socket_$_state_machine__2684__auto____1 = (function (state_62832){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62832);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e62849){var ex__2687__auto__ = e62849;
var statearr_62850_62862 = state_62832;
(statearr_62850_62862[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62832[(4)]))){
var statearr_62851_62863 = state_62832;
(statearr_62851_62863[(1)] = cljs.core.first((state_62832[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62864 = state_62832;
state_62832 = G__62864;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2684__auto__ = function(state_62832){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____1.call(this,state_62832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2684__auto____0;
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_62852 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_62852[(6)] = c__2706__auto__);

return statearr_62852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e62865){var e = e62865;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_62992){
var state_val_62993 = (state_62992[(1)]);
if((state_val_62993 === (7))){
var inst_62988 = (state_62992[(2)]);
var state_62992__$1 = state_62992;
var statearr_62995_63065 = state_62992__$1;
(statearr_62995_63065[(2)] = inst_62988);

(statearr_62995_63065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (20))){
var _ = (function (){var statearr_62996 = state_62992;
(statearr_62996[(4)] = cljs.core.rest((state_62992[(4)])));

return statearr_62996;
})();
var state_62992__$1 = state_62992;
var ex62994 = (state_62992__$1[(2)]);
var statearr_62997_63066 = state_62992__$1;
(statearr_62997_63066[(5)] = ex62994);


var statearr_62998_63067 = state_62992__$1;
(statearr_62998_63067[(1)] = (10));

(statearr_62998_63067[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (27))){
var inst_62980 = (state_62992[(2)]);
var _ = (function (){var statearr_62999 = state_62992;
(statearr_62999[(4)] = cljs.core.rest((state_62992[(4)])));

return statearr_62999;
})();
var state_62992__$1 = state_62992;
var statearr_63000_63068 = state_62992__$1;
(statearr_63000_63068[(2)] = inst_62980);

(statearr_63000_63068[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (1))){
var inst_62867 = (0);
var state_62992__$1 = (function (){var statearr_63001 = state_62992;
(statearr_63001[(7)] = inst_62867);

return statearr_63001;
})();
var statearr_63002_63069 = state_62992__$1;
(statearr_63002_63069[(2)] = null);

(statearr_63002_63069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (24))){
var inst_62958 = (state_62992[(8)]);
var inst_62958__$1 = (state_62992[(2)]);
var inst_62959 = inst_62958__$1 === true;
var state_62992__$1 = (function (){var statearr_63003 = state_62992;
(statearr_63003[(8)] = inst_62958__$1);

return statearr_63003;
})();
if(cljs.core.truth_(inst_62959)){
var statearr_63004_63070 = state_62992__$1;
(statearr_63004_63070[(1)] = (25));

} else {
var statearr_63005_63071 = state_62992__$1;
(statearr_63005_63071[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (4))){
var inst_62870 = (state_62992[(9)]);
var inst_62870__$1 = (state_62992[(2)]);
var state_62992__$1 = (function (){var statearr_63006 = state_62992;
(statearr_63006[(9)] = inst_62870__$1);

return statearr_63006;
})();
if(cljs.core.truth_(inst_62870__$1)){
var statearr_63007_63072 = state_62992__$1;
(statearr_63007_63072[(1)] = (5));

} else {
var statearr_63008_63073 = state_62992__$1;
(statearr_63008_63073[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (15))){
var inst_62883 = (state_62992[(10)]);
var state_62992__$1 = state_62992;
var statearr_63009_63074 = state_62992__$1;
(statearr_63009_63074[(2)] = inst_62883);

(statearr_63009_63074[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (21))){
var inst_62908 = (state_62992[(11)]);
var inst_62909 = (state_62992[(12)]);
var inst_62914 = (state_62992[(13)]);
var inst_62867 = (state_62992[(7)]);
var inst_62915 = (state_62992[(14)]);
var inst_62870 = (state_62992[(9)]);
var inst_62911 = (state_62992[(15)]);
var inst_62910 = (state_62992[(16)]);
var inst_62907 = (state_62992[(17)]);
var inst_62906 = (state_62992[(18)]);
var inst_62917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62918 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62914];
var inst_62919 = (new cljs.core.PersistentVector(null,2,(5),inst_62917,inst_62918,null));
var inst_62920 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62919,inst_62909);
var inst_62947 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62948 = (function (){var resp_chan = inst_62909;
var timeout = inst_62915;
var i = inst_62867;
var vec__62902 = inst_62870;
var data = inst_62908;
var map__62905 = inst_62911;
var _ = inst_62906;
var req_id = inst_62914;
var operation = inst_62907;
var msg = inst_62870;
var c__2706__auto____$1 = inst_62947;
var opts = inst_62910;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_62945){
var state_val_62946 = (state_62945[(1)]);
if((state_val_62946 === (1))){
var inst_62924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62925 = cljs.core.async.timeout(timeout);
var inst_62926 = [resp_chan,inst_62925];
var inst_62927 = (new cljs.core.PersistentVector(null,2,(5),inst_62924,inst_62926,null));
var state_62945__$1 = state_62945;
return cljs.core.async.ioc_alts_BANG_(state_62945__$1,(2),inst_62927);
} else {
if((state_val_62946 === (2))){
var inst_62930 = (state_62945[(7)]);
var inst_62929 = (state_62945[(2)]);
var inst_62930__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62929,(0),null);
var inst_62931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62929,(1),null);
var inst_62932 = (function (){var vec__62921 = inst_62929;
var resp = inst_62930__$1;
var c = inst_62931;
return (function (p1__62866_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__62866_SHARP_,req_id);
});
})();
var inst_62933 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62932);
var inst_62934 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62931,resp_chan);
var state_62945__$1 = (function (){var statearr_63010 = state_62945;
(statearr_63010[(7)] = inst_62930__$1);

(statearr_63010[(8)] = inst_62933);

return statearr_63010;
})();
if(inst_62934){
var statearr_63011_63075 = state_62945__$1;
(statearr_63011_63075[(1)] = (3));

} else {
var statearr_63012_63076 = state_62945__$1;
(statearr_63012_63076[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62946 === (3))){
var inst_62930 = (state_62945[(7)]);
var state_62945__$1 = state_62945;
var statearr_63013_63077 = state_62945__$1;
(statearr_63013_63077[(2)] = inst_62930);

(statearr_63013_63077[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62946 === (4))){
var inst_62937 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62938 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62939 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62940 = cljs.core.PersistentHashMap.fromArrays(inst_62938,inst_62939);
var inst_62941 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62937,inst_62940);
var state_62945__$1 = state_62945;
var statearr_63014_63078 = state_62945__$1;
(statearr_63014_63078[(2)] = inst_62941);

(statearr_63014_63078[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62946 === (5))){
var inst_62943 = (state_62945[(2)]);
var state_62945__$1 = state_62945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62945__$1,inst_62943);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_63015 = [null,null,null,null,null,null,null,null,null];
(statearr_63015[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_63015[(1)] = (1));

return statearr_63015;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_62945){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62945);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63016){var ex__2687__auto__ = e63016;
var statearr_63017_63079 = state_62945;
(statearr_63017_63079[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62945[(4)]))){
var statearr_63018_63080 = state_62945;
(statearr_63018_63080[(1)] = cljs.core.first((state_62945[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63081 = state_62945;
state_62945 = G__63081;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_62945){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_62945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63019 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63019[(6)] = c__2706__auto____$1);

return statearr_63019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_62949 = cljs.core.async.impl.dispatch.run(inst_62948);
var state_62992__$1 = (function (){var statearr_63020 = state_62992;
(statearr_63020[(19)] = inst_62949);

(statearr_63020[(20)] = inst_62920);

return statearr_63020;
})();
var statearr_63021_63082 = state_62992__$1;
(statearr_63021_63082[(2)] = inst_62947);

(statearr_63021_63082[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (31))){
var inst_62968 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62992__$1 = state_62992;
var statearr_63022_63083 = state_62992__$1;
(statearr_63022_63083[(2)] = inst_62968);

(statearr_63022_63083[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (32))){
var state_62992__$1 = state_62992;
var statearr_63023_63084 = state_62992__$1;
(statearr_63023_63084[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (33))){
var inst_62976 = (state_62992[(2)]);
var state_62992__$1 = state_62992;
var statearr_63025_63085 = state_62992__$1;
(statearr_63025_63085[(2)] = inst_62976);

(statearr_63025_63085[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (13))){
var inst_62883 = (state_62992[(10)]);
var inst_62880 = (state_62992[(2)]);
var inst_62881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62880,(0),null);
var inst_62882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62880,(1),null);
var inst_62883__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62880,(2),null);
var state_62992__$1 = (function (){var statearr_63026 = state_62992;
(statearr_63026[(21)] = inst_62881);

(statearr_63026[(22)] = inst_62882);

(statearr_63026[(10)] = inst_62883__$1);

return statearr_63026;
})();
if(cljs.core.truth_(inst_62883__$1)){
var statearr_63027_63086 = state_62992__$1;
(statearr_63027_63086[(1)] = (14));

} else {
var statearr_63028_63087 = state_62992__$1;
(statearr_63028_63087[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (22))){
var state_62992__$1 = state_62992;
var statearr_63029_63088 = state_62992__$1;
(statearr_63029_63088[(2)] = null);

(statearr_63029_63088[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (36))){
var inst_62974 = (state_62992[(2)]);
var state_62992__$1 = state_62992;
var statearr_63030_63089 = state_62992__$1;
(statearr_63030_63089[(2)] = inst_62974);

(statearr_63030_63089[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (29))){
var inst_62958 = (state_62992[(8)]);
var inst_62966 = (inst_62958 == null);
var state_62992__$1 = state_62992;
if(cljs.core.truth_(inst_62966)){
var statearr_63031_63090 = state_62992__$1;
(statearr_63031_63090[(1)] = (31));

} else {
var statearr_63032_63091 = state_62992__$1;
(statearr_63032_63091[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (6))){
var state_62992__$1 = state_62992;
var statearr_63033_63092 = state_62992__$1;
(statearr_63033_63092[(2)] = null);

(statearr_63033_63092[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (28))){
var inst_62958 = (state_62992[(8)]);
var inst_62964 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62958,"Error processing message in producer."], 0));
var state_62992__$1 = state_62992;
var statearr_63034_63093 = state_62992__$1;
(statearr_63034_63093[(2)] = inst_62964);

(statearr_63034_63093[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (25))){
var state_62992__$1 = state_62992;
var statearr_63035_63094 = state_62992__$1;
(statearr_63035_63094[(2)] = null);

(statearr_63035_63094[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (34))){
var inst_62958 = (state_62992[(8)]);
var inst_62971 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62958], 0));
var state_62992__$1 = state_62992;
var statearr_63036_63095 = state_62992__$1;
(statearr_63036_63095[(2)] = inst_62971);

(statearr_63036_63095[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (17))){
var inst_62872 = (state_62992[(23)]);
var inst_62883 = (state_62992[(10)]);
var inst_62890 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62883,inst_62872);
var state_62992__$1 = state_62992;
var statearr_63037_63096 = state_62992__$1;
(statearr_63037_63096[(2)] = inst_62890);

(statearr_63037_63096[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (3))){
var inst_62990 = (state_62992[(2)]);
var state_62992__$1 = state_62992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62992__$1,inst_62990);
} else {
if((state_val_62993 === (12))){
var state_62992__$1 = state_62992;
var statearr_63038_63097 = state_62992__$1;
(statearr_63038_63097[(2)] = null);

(statearr_63038_63097[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (2))){
var state_62992__$1 = state_62992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62992__$1,(4),req_chan);
} else {
if((state_val_62993 === (23))){
var inst_62908 = (state_62992[(11)]);
var inst_62914 = (state_62992[(13)]);
var inst_62907 = (state_62992[(17)]);
var inst_62952 = (state_62992[(2)]);
var inst_62953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62954 = [inst_62907,inst_62914,inst_62908];
var inst_62955 = (new cljs.core.PersistentVector(null,3,(5),inst_62953,inst_62954,null));
var inst_62956 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62955) : publish_fn.call(null,conn,inst_62955));
var state_62992__$1 = (function (){var statearr_63039 = state_62992;
(statearr_63039[(24)] = inst_62952);

return statearr_63039;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62992__$1,(24),inst_62956);
} else {
if((state_val_62993 === (35))){
var state_62992__$1 = state_62992;
var statearr_63040_63098 = state_62992__$1;
(statearr_63040_63098[(2)] = null);

(statearr_63040_63098[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (19))){
var inst_62896 = (state_62992[(2)]);
var state_62992__$1 = state_62992;
var statearr_63041_63099 = state_62992__$1;
(statearr_63041_63099[(2)] = inst_62896);

(statearr_63041_63099[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (11))){
var inst_62870 = (state_62992[(9)]);
var state_62992__$1 = state_62992;
var statearr_63042_63100 = state_62992__$1;
(statearr_63042_63100[(2)] = inst_62870);

(statearr_63042_63100[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (9))){
var inst_62867 = (state_62992[(7)]);
var inst_62983 = (state_62992[(2)]);
var inst_62984 = (inst_62867 + (1));
var inst_62867__$1 = inst_62984;
var state_62992__$1 = (function (){var statearr_63043 = state_62992;
(statearr_63043[(7)] = inst_62867__$1);

(statearr_63043[(25)] = inst_62983);

return statearr_63043;
})();
var statearr_63044_63101 = state_62992__$1;
(statearr_63044_63101[(2)] = null);

(statearr_63044_63101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (5))){
var state_62992__$1 = state_62992;
var statearr_63045_63102 = state_62992__$1;
(statearr_63045_63102[(2)] = null);

(statearr_63045_63102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (14))){
var inst_62883 = (state_62992[(10)]);
var inst_62885 = fluree.db.util.async.channel_QMARK_(inst_62883);
var state_62992__$1 = state_62992;
var statearr_63046_63103 = state_62992__$1;
(statearr_63046_63103[(2)] = inst_62885);

(statearr_63046_63103[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (26))){
var inst_62958 = (state_62992[(8)]);
var inst_62962 = fluree.db.util.core.exception_QMARK_(inst_62958);
var state_62992__$1 = state_62992;
if(inst_62962){
var statearr_63047_63104 = state_62992__$1;
(statearr_63047_63104[(1)] = (28));

} else {
var statearr_63048_63105 = state_62992__$1;
(statearr_63048_63105[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (16))){
var inst_62888 = (state_62992[(2)]);
var state_62992__$1 = state_62992;
if(cljs.core.truth_(inst_62888)){
var statearr_63049_63106 = state_62992__$1;
(statearr_63049_63106[(1)] = (17));

} else {
var statearr_63050_63107 = state_62992__$1;
(statearr_63050_63107[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (30))){
var inst_62978 = (state_62992[(2)]);
var state_62992__$1 = state_62992;
var statearr_63051_63108 = state_62992__$1;
(statearr_63051_63108[(2)] = inst_62978);

(statearr_63051_63108[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (10))){
var inst_62870 = (state_62992[(9)]);
var inst_62872 = (state_62992[(2)]);
var inst_62876 = cljs.core.sequential_QMARK_(inst_62870);
var state_62992__$1 = (function (){var statearr_63052 = state_62992;
(statearr_63052[(23)] = inst_62872);

return statearr_63052;
})();
if(inst_62876){
var statearr_63053_63109 = state_62992__$1;
(statearr_63053_63109[(1)] = (11));

} else {
var statearr_63054_63110 = state_62992__$1;
(statearr_63054_63110[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (18))){
var inst_62872 = (state_62992[(23)]);
var inst_62870 = (state_62992[(9)]);
var inst_62892 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62870], 0));
var inst_62893 = ["Error processing ledger request, no valid return channel: ",inst_62892].join('');
var inst_62894 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62872,inst_62893], 0));
var state_62992__$1 = state_62992;
var statearr_63055_63111 = state_62992__$1;
(statearr_63055_63111[(2)] = inst_62894);

(statearr_63055_63111[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62993 === (8))){
var inst_62909 = (state_62992[(12)]);
var inst_62870 = (state_62992[(9)]);
var inst_62911 = (state_62992[(15)]);
var inst_62910 = (state_62992[(16)]);
var _ = (function (){var statearr_63056 = state_62992;
(statearr_63056[(4)] = cljs.core.cons((20),(state_62992[(4)])));

return statearr_63056;
})();
var inst_62906 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_62870], 0));
var inst_62907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62870,(0),null);
var inst_62908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62870,(1),null);
var inst_62909__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62870,(2),null);
var inst_62910__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62870,(3),null);
var inst_62911__$1 = cljs.core.__destructure_map(inst_62910__$1);
var inst_62912 = fluree.db.util.core.random_uuid();
var inst_62913 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62912);
var inst_62914 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62911__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62913);
var inst_62915 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62911__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62992__$1 = (function (){var statearr_63057 = state_62992;
(statearr_63057[(11)] = inst_62908);

(statearr_63057[(12)] = inst_62909__$1);

(statearr_63057[(13)] = inst_62914);

(statearr_63057[(14)] = inst_62915);

(statearr_63057[(15)] = inst_62911__$1);

(statearr_63057[(16)] = inst_62910__$1);

(statearr_63057[(17)] = inst_62907);

(statearr_63057[(18)] = inst_62906);

return statearr_63057;
})();
if(cljs.core.truth_(inst_62909__$1)){
var statearr_63058_63112 = state_62992__$1;
(statearr_63058_63112[(1)] = (21));

} else {
var statearr_63059_63113 = state_62992__$1;
(statearr_63059_63113[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_63060 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63060[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_63060[(1)] = (1));

return statearr_63060;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_62992){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62992);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63061){var ex__2687__auto__ = e63061;
var statearr_63062_63114 = state_62992;
(statearr_63062_63114[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62992[(4)]))){
var statearr_63063_63115 = state_62992;
(statearr_63063_63115[(1)] = cljs.core.first((state_62992[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63116 = state_62992;
state_62992 = G__63116;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_62992){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_62992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63064 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63064[(6)] = c__2706__auto__);

return statearr_63064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__63117 = conn;
var map__63117__$1 = cljs.core.__destructure_map(map__63117);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63117__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63202){
var state_val_63203 = (state_63202[(1)]);
if((state_val_63203 === (7))){
var inst_63198 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63204_63255 = state_63202__$1;
(statearr_63204_63255[(2)] = inst_63198);

(statearr_63204_63255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (20))){
var inst_63136 = (state_63202[(7)]);
var inst_63150 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_63151 = [inst_63136];
var inst_63152 = cljs.core.PersistentHashMap.fromArrays(inst_63150,inst_63151);
var inst_63153 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_63152], 0));
var state_63202__$1 = state_63202;
var statearr_63205_63256 = state_63202__$1;
(statearr_63205_63256[(2)] = inst_63153);

(statearr_63205_63256[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (27))){
var state_63202__$1 = state_63202;
var statearr_63206_63257 = state_63202__$1;
(statearr_63206_63257[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (1))){
var inst_63118 = (0);
var state_63202__$1 = (function (){var statearr_63208 = state_63202;
(statearr_63208[(8)] = inst_63118);

return statearr_63208;
})();
var statearr_63209_63258 = state_63202__$1;
(statearr_63209_63258[(2)] = null);

(statearr_63209_63258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (24))){
var inst_63129 = (state_63202[(9)]);
var inst_63178 = fluree.db.util.core.exception_QMARK_(inst_63129);
var state_63202__$1 = state_63202;
if(inst_63178){
var statearr_63210_63259 = state_63202__$1;
(statearr_63210_63259[(1)] = (26));

} else {
var statearr_63211_63260 = state_63202__$1;
(statearr_63211_63260[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (4))){
var inst_63123 = (state_63202[(10)]);
var inst_63128 = (state_63202[(2)]);
var inst_63129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63128,(0),null);
var inst_63130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63128,(1),null);
var inst_63131 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63130,inst_63123);
var state_63202__$1 = (function (){var statearr_63212 = state_63202;
(statearr_63212[(9)] = inst_63129);

return statearr_63212;
})();
if(inst_63131){
var statearr_63213_63261 = state_63202__$1;
(statearr_63213_63261[(1)] = (5));

} else {
var statearr_63214_63262 = state_63202__$1;
(statearr_63214_63262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (15))){
var inst_63136 = (state_63202[(7)]);
var inst_63145 = typeof inst_63136 === 'string';
var state_63202__$1 = state_63202;
if(cljs.core.truth_(inst_63145)){
var statearr_63215_63263 = state_63202__$1;
(statearr_63215_63263[(1)] = (17));

} else {
var statearr_63216_63264 = state_63202__$1;
(statearr_63216_63264[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (21))){
var state_63202__$1 = state_63202;
var statearr_63217_63265 = state_63202__$1;
(statearr_63217_63265[(2)] = null);

(statearr_63217_63265[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (31))){
var inst_63192 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63218_63266 = state_63202__$1;
(statearr_63218_63266[(2)] = inst_63192);

(statearr_63218_63266[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (13))){
var inst_63162 = (state_63202[(2)]);
var inst_63163 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63164 = fluree.db.connection.close_websocket(inst_63163);
var inst_63165 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63166 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_63165);
var state_63202__$1 = (function (){var statearr_63219 = state_63202;
(statearr_63219[(11)] = inst_63162);

(statearr_63219[(12)] = inst_63164);

return statearr_63219;
})();
var statearr_63220_63267 = state_63202__$1;
(statearr_63220_63267[(2)] = inst_63166);

(statearr_63220_63267[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (22))){
var inst_63156 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63221_63268 = state_63202__$1;
(statearr_63221_63268[(2)] = inst_63156);

(statearr_63221_63268[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (29))){
var inst_63129 = (state_63202[(9)]);
var inst_63184 = fluree.db.util.json.parse(inst_63129);
var inst_63185 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63184], 0));
var inst_63186 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_63185], 0));
var inst_63187 = fluree.db.util.json.parse(inst_63129);
var inst_63188 = fluree.db.conn_events.process_events(conn,inst_63187);
var inst_63118 = (0);
var state_63202__$1 = (function (){var statearr_63222 = state_63202;
(statearr_63222[(13)] = inst_63188);

(statearr_63222[(14)] = inst_63186);

(statearr_63222[(8)] = inst_63118);

return statearr_63222;
})();
var statearr_63223_63269 = state_63202__$1;
(statearr_63223_63269[(2)] = null);

(statearr_63223_63269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (6))){
var inst_63129 = (state_63202[(9)]);
var inst_63174 = (inst_63129 == null);
var state_63202__$1 = state_63202;
if(cljs.core.truth_(inst_63174)){
var statearr_63224_63270 = state_63202__$1;
(statearr_63224_63270[(1)] = (23));

} else {
var statearr_63225_63271 = state_63202__$1;
(statearr_63225_63271[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (28))){
var inst_63194 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63226_63272 = state_63202__$1;
(statearr_63226_63272[(2)] = inst_63194);

(statearr_63226_63272[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (25))){
var inst_63196 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63227_63273 = state_63202__$1;
(statearr_63227_63273[(2)] = inst_63196);

(statearr_63227_63273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (17))){
var inst_63136 = (state_63202[(7)]);
var inst_63147 = cljs.core.eval(inst_63136);
var state_63202__$1 = state_63202;
var statearr_63228_63274 = state_63202__$1;
(statearr_63228_63274[(2)] = inst_63147);

(statearr_63228_63274[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (3))){
var inst_63200 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63202__$1,inst_63200);
} else {
if((state_val_63203 === (12))){
var inst_63136 = (state_63202[(7)]);
var inst_63141 = cljs.core.fn_QMARK_(inst_63136);
var state_63202__$1 = state_63202;
if(inst_63141){
var statearr_63229_63275 = state_63202__$1;
(statearr_63229_63275[(1)] = (14));

} else {
var statearr_63230_63276 = state_63202__$1;
(statearr_63230_63276[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (2))){
var inst_63123 = (state_63202[(10)]);
var inst_63123__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_63124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63125 = [sub_chan,inst_63123__$1];
var inst_63126 = (new cljs.core.PersistentVector(null,2,(5),inst_63124,inst_63125,null));
var state_63202__$1 = (function (){var statearr_63231 = state_63202;
(statearr_63231[(10)] = inst_63123__$1);

return statearr_63231;
})();
return cljs.core.async.ioc_alts_BANG_(state_63202__$1,(4),inst_63126);
} else {
if((state_val_63203 === (23))){
var inst_63176 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_63202__$1 = state_63202;
var statearr_63232_63277 = state_63202__$1;
(statearr_63232_63277[(2)] = inst_63176);

(statearr_63232_63277[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (19))){
var inst_63158 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63233_63278 = state_63202__$1;
(statearr_63233_63278[(2)] = inst_63158);

(statearr_63233_63278[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (11))){
var inst_63139 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_63202__$1 = state_63202;
var statearr_63234_63279 = state_63202__$1;
(statearr_63234_63279[(2)] = inst_63139);

(statearr_63234_63279[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (9))){
var inst_63118 = (state_63202[(8)]);
var inst_63168 = fluree.db.connection.ping_transactor(conn);
var inst_63169 = (inst_63118 + (1));
var inst_63118__$1 = inst_63169;
var state_63202__$1 = (function (){var statearr_63235 = state_63202;
(statearr_63235[(8)] = inst_63118__$1);

(statearr_63235[(15)] = inst_63168);

return statearr_63235;
})();
var statearr_63236_63280 = state_63202__$1;
(statearr_63236_63280[(2)] = null);

(statearr_63236_63280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (5))){
var inst_63118 = (state_63202[(8)]);
var inst_63133 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_63118);
var state_63202__$1 = state_63202;
if(inst_63133){
var statearr_63237_63281 = state_63202__$1;
(statearr_63237_63281[(1)] = (8));

} else {
var statearr_63238_63282 = state_63202__$1;
(statearr_63238_63282[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (14))){
var inst_63136 = (state_63202[(7)]);
var inst_63143 = (inst_63136.cljs$core$IFn$_invoke$arity$0 ? inst_63136.cljs$core$IFn$_invoke$arity$0() : inst_63136.call(null));
var state_63202__$1 = state_63202;
var statearr_63239_63283 = state_63202__$1;
(statearr_63239_63283[(2)] = inst_63143);

(statearr_63239_63283[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (26))){
var inst_63129 = (state_63202[(9)]);
var inst_63180 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63129], 0));
var inst_63118 = (0);
var state_63202__$1 = (function (){var statearr_63240 = state_63202;
(statearr_63240[(16)] = inst_63180);

(statearr_63240[(8)] = inst_63118);

return statearr_63240;
})();
var statearr_63241_63284 = state_63202__$1;
(statearr_63241_63284[(2)] = null);

(statearr_63241_63284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (16))){
var inst_63160 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63242_63285 = state_63202__$1;
(statearr_63242_63285[(2)] = inst_63160);

(statearr_63242_63285[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (30))){
var state_63202__$1 = state_63202;
var statearr_63243_63286 = state_63202__$1;
(statearr_63243_63286[(2)] = null);

(statearr_63243_63286[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (10))){
var inst_63172 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63244_63287 = state_63202__$1;
(statearr_63244_63287[(2)] = inst_63172);

(statearr_63244_63287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (18))){
var state_63202__$1 = state_63202;
var statearr_63245_63288 = state_63202__$1;
(statearr_63245_63288[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (8))){
var inst_63136 = (state_63202[(7)]);
var inst_63135 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_63136__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63137 = (inst_63136__$1 == null);
var state_63202__$1 = (function (){var statearr_63247 = state_63202;
(statearr_63247[(7)] = inst_63136__$1);

(statearr_63247[(17)] = inst_63135);

return statearr_63247;
})();
if(cljs.core.truth_(inst_63137)){
var statearr_63248_63289 = state_63202__$1;
(statearr_63248_63289[(1)] = (11));

} else {
var statearr_63249_63290 = state_63202__$1;
(statearr_63249_63290[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0 = (function (){
var statearr_63250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63250[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2684__auto__);

(statearr_63250[(1)] = (1));

return statearr_63250;
});
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1 = (function (state_63202){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63202);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63251){var ex__2687__auto__ = e63251;
var statearr_63252_63291 = state_63202;
(statearr_63252_63291[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63202[(4)]))){
var statearr_63253_63292 = state_63202;
(statearr_63253_63292[(1)] = cljs.core.first((state_63202[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63293 = state_63202;
state_63202 = G__63293;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = function(state_63202){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1.call(this,state_63202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63254 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63254[(6)] = c__2706__auto__);

return statearr_63254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__63295 = arguments.length;
switch (G__63295) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__63296 = opts;
var map__63296__$1 = cljs.core.__destructure_map(map__63296);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63296__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63296__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63348){
var state_val_63349 = (state_63348[(1)]);
if((state_val_63349 === (7))){
var inst_63306 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_63307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63308 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63309 = (new cljs.core.PersistentVector(null,2,(5),inst_63307,inst_63308,null));
var inst_63310 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63306,inst_63309);
var state_63348__$1 = state_63348;
var statearr_63350_63381 = state_63348__$1;
(statearr_63350_63381[(2)] = inst_63310);

(statearr_63350_63381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (1))){
var state_63348__$1 = state_63348;
var statearr_63351_63382 = state_63348__$1;
(statearr_63351_63382[(2)] = null);

(statearr_63351_63382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (4))){
var inst_63297 = (state_63348[(2)]);
var state_63348__$1 = state_63348;
var statearr_63352_63383 = state_63348__$1;
(statearr_63352_63383[(2)] = inst_63297);

(statearr_63352_63383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (15))){
var inst_63317 = (state_63348[(7)]);
var inst_63336 = (state_63348[(2)]);
var inst_63337 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_63338 = [(5000),inst_63336,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_63339 = cljs.core.PersistentHashMap.fromArrays(inst_63337,inst_63338);
var inst_63340 = fluree.db.util.xhttp.get(inst_63317,inst_63339);
var state_63348__$1 = state_63348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63348__$1,(16),inst_63340);
} else {
if((state_val_63349 === (13))){
var inst_63317 = (state_63348[(7)]);
var inst_63327 = (state_63348[(8)]);
var inst_63329 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_63330 = [inst_63327];
var inst_63331 = cljs.core.PersistentHashMap.fromArrays(inst_63329,inst_63330);
var inst_63332 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_63317,inst_63331,private$);
var inst_63333 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_63332);
var state_63348__$1 = state_63348;
var statearr_63353_63384 = state_63348__$1;
(statearr_63353_63384[(2)] = inst_63333);

(statearr_63353_63384[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (6))){
var inst_63303 = (state_63348[(9)]);
var state_63348__$1 = state_63348;
var statearr_63354_63385 = state_63348__$1;
(statearr_63354_63385[(2)] = inst_63303);

(statearr_63354_63385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (3))){
var inst_63346 = (state_63348[(2)]);
var state_63348__$1 = state_63348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63348__$1,inst_63346);
} else {
if((state_val_63349 === (12))){
var inst_63327 = (state_63348[(2)]);
var state_63348__$1 = (function (){var statearr_63355 = state_63348;
(statearr_63355[(8)] = inst_63327);

return statearr_63355;
})();
if(cljs.core.truth_(private$)){
var statearr_63356_63386 = state_63348__$1;
(statearr_63356_63386[(1)] = (13));

} else {
var statearr_63357_63387 = state_63348__$1;
(statearr_63357_63387[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (2))){
var inst_63303 = (state_63348[(9)]);
var _ = (function (){var statearr_63358 = state_63348;
(statearr_63358[(4)] = cljs.core.cons((5),(state_63348[(4)])));

return statearr_63358;
})();
var inst_63303__$1 = jwt;
var state_63348__$1 = (function (){var statearr_63359 = state_63348;
(statearr_63359[(9)] = inst_63303__$1);

return statearr_63359;
})();
if(cljs.core.truth_(inst_63303__$1)){
var statearr_63360_63388 = state_63348__$1;
(statearr_63360_63388[(1)] = (6));

} else {
var statearr_63361_63389 = state_63348__$1;
(statearr_63361_63389[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (11))){
var inst_63321 = (state_63348[(10)]);
var state_63348__$1 = state_63348;
var statearr_63363_63390 = state_63348__$1;
(statearr_63363_63390[(2)] = inst_63321);

(statearr_63363_63390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (9))){
var inst_63312 = (state_63348[(11)]);
var inst_63313 = (state_63348[(12)]);
var inst_63316 = (state_63348[(2)]);
var inst_63317 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63316),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63313)].join('');
var inst_63319 = ["Accept"];
var inst_63320 = ["application/json"];
var inst_63321 = cljs.core.PersistentHashMap.fromArrays(inst_63319,inst_63320);
var state_63348__$1 = (function (){var statearr_63364 = state_63348;
(statearr_63364[(10)] = inst_63321);

(statearr_63364[(7)] = inst_63317);

return statearr_63364;
})();
if(cljs.core.truth_(inst_63312)){
var statearr_63365_63391 = state_63348__$1;
(statearr_63365_63391[(1)] = (10));

} else {
var statearr_63366_63392 = state_63348__$1;
(statearr_63366_63392[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (5))){
var _ = (function (){var statearr_63367 = state_63348;
(statearr_63367[(4)] = cljs.core.rest((state_63348[(4)])));

return statearr_63367;
})();
var state_63348__$1 = state_63348;
var ex63362 = (state_63348__$1[(2)]);
var statearr_63368_63393 = state_63348__$1;
(statearr_63368_63393[(5)] = ex63362);


if((ex63362 instanceof Error)){
var statearr_63369_63394 = state_63348__$1;
(statearr_63369_63394[(1)] = (4));

(statearr_63369_63394[(5)] = null);

} else {
throw ex63362;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (14))){
var inst_63327 = (state_63348[(8)]);
var state_63348__$1 = state_63348;
var statearr_63370_63395 = state_63348__$1;
(statearr_63370_63395[(2)] = inst_63327);

(statearr_63370_63395[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (16))){
var inst_63342 = (state_63348[(2)]);
var inst_63343 = fluree.db.util.async.throw_err(inst_63342);
var _ = (function (){var statearr_63371 = state_63348;
(statearr_63371[(4)] = cljs.core.rest((state_63348[(4)])));

return statearr_63371;
})();
var state_63348__$1 = state_63348;
var statearr_63372_63396 = state_63348__$1;
(statearr_63372_63396[(2)] = inst_63343);

(statearr_63372_63396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (10))){
var inst_63321 = (state_63348[(10)]);
var inst_63312 = (state_63348[(11)]);
var inst_63323 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63312)].join('');
var inst_63324 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63321,"Authorization",inst_63323);
var state_63348__$1 = state_63348;
var statearr_63373_63397 = state_63348__$1;
(statearr_63373_63397[(2)] = inst_63324);

(statearr_63373_63397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (8))){
var inst_63312 = (state_63348[(2)]);
var inst_63313 = clojure.string.replace(k,"_","/");
var inst_63314 = fluree.db.connection.get_server(conn_id,servers);
var state_63348__$1 = (function (){var statearr_63374 = state_63348;
(statearr_63374[(11)] = inst_63312);

(statearr_63374[(12)] = inst_63313);

return statearr_63374;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63348__$1,(9),inst_63314);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_63375 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63375[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_63375[(1)] = (1));

return statearr_63375;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_63348){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63348);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63376){var ex__2687__auto__ = e63376;
var statearr_63377_63398 = state_63348;
(statearr_63377_63398[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63348[(4)]))){
var statearr_63378_63399 = state_63348;
(statearr_63378_63399[(1)] = cljs.core.first((state_63348[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63400 = state_63348;
state_63348 = G__63400;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_63348){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_63348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63379 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63379[(6)] = c__2706__auto__);

return statearr_63379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63401_SHARP_){
if(cljs.core.truth_(p1__63401_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__63402_SHARP_){
var or__5045__auto__ = p1__63402_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e63403){var e = e63403;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63404 = opts;
var map__63404__$1 = cljs.core.__destructure_map(map__63404);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63404__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63404__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__63405_63406 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__63405_63406.cljs$core$IFn$_invoke$arity$0 ? fexpr__63405_63406.cljs$core$IFn$_invoke$arity$0() : fexpr__63405_63406.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63447 = arguments.length;
var i__5770__auto___63448 = (0);
while(true){
if((i__5770__auto___63448 < len__5769__auto___63447)){
args__5775__auto__.push((arguments[i__5770__auto___63448]));

var G__63449 = (i__5770__auto___63448 + (1));
i__5770__auto___63448 = G__63449;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63409){
var vec__63410 = p__63409;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63410,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2706__auto___63450 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63430){
var state_val_63431 = (state_63430[(1)]);
if((state_val_63431 === (1))){
var inst_63413 = fluree.db.connection.get_socket(conn);
var state_63430__$1 = state_63430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63430__$1,(2),inst_63413);
} else {
if((state_val_63431 === (2))){
var inst_63415 = (state_63430[(7)]);
var inst_63416 = (state_63430[(8)]);
var inst_63415__$1 = (state_63430[(2)]);
var inst_63416__$1 = (inst_63415__$1 == null);
var state_63430__$1 = (function (){var statearr_63432 = state_63430;
(statearr_63432[(7)] = inst_63415__$1);

(statearr_63432[(8)] = inst_63416__$1);

return statearr_63432;
})();
if(cljs.core.truth_(inst_63416__$1)){
var statearr_63433_63451 = state_63430__$1;
(statearr_63433_63451[(1)] = (3));

} else {
var statearr_63434_63452 = state_63430__$1;
(statearr_63434_63452[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63431 === (3))){
var inst_63416 = (state_63430[(8)]);
var state_63430__$1 = state_63430;
var statearr_63435_63453 = state_63430__$1;
(statearr_63435_63453[(2)] = inst_63416);

(statearr_63435_63453[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63431 === (4))){
var inst_63415 = (state_63430[(7)]);
var inst_63419 = fluree.db.util.core.exception_QMARK_(inst_63415);
var state_63430__$1 = state_63430;
var statearr_63436_63454 = state_63430__$1;
(statearr_63436_63454[(2)] = inst_63419);

(statearr_63436_63454[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63431 === (5))){
var inst_63421 = (state_63430[(2)]);
var state_63430__$1 = state_63430;
if(cljs.core.truth_(inst_63421)){
var statearr_63437_63455 = state_63430__$1;
(statearr_63437_63455[(1)] = (6));

} else {
var statearr_63438_63456 = state_63430__$1;
(statearr_63438_63456[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63431 === (6))){
var inst_63415 = (state_63430[(7)]);
var inst_63423 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63415,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_63424 = cljs.core.async.close_BANG_(conn);
var state_63430__$1 = (function (){var statearr_63439 = state_63430;
(statearr_63439[(9)] = inst_63423);

return statearr_63439;
})();
var statearr_63440_63457 = state_63430__$1;
(statearr_63440_63457[(2)] = inst_63424);

(statearr_63440_63457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63431 === (7))){
var inst_63426 = fluree.db.connection.msg_consumer(conn);
var state_63430__$1 = state_63430;
var statearr_63441_63458 = state_63430__$1;
(statearr_63441_63458[(2)] = inst_63426);

(statearr_63441_63458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63431 === (8))){
var inst_63428 = (state_63430[(2)]);
var state_63430__$1 = state_63430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63430__$1,inst_63428);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_63442 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63442[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_63442[(1)] = (1));

return statearr_63442;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_63430){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63430);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63443){var ex__2687__auto__ = e63443;
var statearr_63444_63459 = state_63430;
(statearr_63444_63459[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63430[(4)]))){
var statearr_63445_63460 = state_63430;
(statearr_63445_63460[(1)] = cljs.core.first((state_63430[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63461 = state_63430;
state_63430 = G__63461;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_63430){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_63430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63446 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63446[(6)] = c__2706__auto___63450);

return statearr_63446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63407){
var G__63408 = cljs.core.first(seq63407);
var seq63407__$1 = cljs.core.next(seq63407);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63408,seq63407__$1);
}));

