// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ttl","ttl",-1115275118),(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__5043__auto__ = typeof value === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__5043__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.Symbol(null,"follow","follow",831213865,null),new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null)],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,311,null,311,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,1,724,null,724,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,241,null,241,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,1,168,null,168,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,822,null,822,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,1,531,null,531,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,437,null,437,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,1,156,null,156,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,398,null,398,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,1,267,null,267,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,97,null,97,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,736,null,736,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,543,null,543,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._SLASH_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,617,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,630,null,630,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,1,760,null,760,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,180,null,180,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,1,706,null,706,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,424,null,424,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,385,null,385,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,476,null,476,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,798,null,798,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,84,null,84,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,199,null,199,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,578,null,578,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,385,null,385,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,669,null,669,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,463,null,463,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,1,120,null,120,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,604,null,604,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",20,1,516,null,516,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,1,343,null,343,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,555,null,555,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,324,null,324,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,1,810,null,810,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,450,null,450,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,281,null,281,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,132,null,132,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,411,null,411,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,591,null,591,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,772,null,772,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",16,1,357,null,357,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,371,null,371,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,1,694,null,694,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,225,null,225,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,69,null,69,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,144,null,144,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,643,null,643,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,212,null,212,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,1,656,null,656,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,489,null,489,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,1,299,null,299,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,1,748,null,748,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,324,null,324,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,254,null,254,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,1,681,null,681,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__57882 = cljs.core.meta(f);
var map__57882__$1 = cljs.core.__destructure_map(map__57882);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57882__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57882__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__5043__auto__ = (function (){var G__57884 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__57883 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__57883.cljs$core$IFn$_invoke$arity$1 ? fexpr__57883.cljs$core$IFn$_invoke$arity$1(G__57884) : fexpr__57883.call(null,G__57884));
})();
if(cljs.core.truth_(and__5043__auto__)){
var G__57886 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__57885 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__57885.cljs$core$IFn$_invoke$arity$1 ? fexpr__57885.cljs$core$IFn$_invoke$arity$1(G__57886) : fexpr__57885.call(null,G__57886));
} else {
return and__5043__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__57881_SHARP_){
return (cljs.core.count(p1__57881_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"f","f",-1597136552),f,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"&args?","&args?",-1736256945),_AMPERSAND_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"code","code",1586293142),null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57971){
var state_val_57972 = (state_57971[(1)]);
if((state_val_57972 === (7))){
var inst_57896 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_57897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57898 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(db);
var inst_57899 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_57900 = [fn_name,inst_57898,inst_57899];
var inst_57901 = (new cljs.core.PersistentVector(null,3,(5),inst_57897,inst_57900,null));
var inst_57902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57896,inst_57901);
var state_57971__$1 = state_57971;
var statearr_57973_58010 = state_57971__$1;
(statearr_57973_58010[(2)] = inst_57902);

(statearr_57973_58010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (1))){
var state_57971__$1 = state_57971;
var statearr_57974_58011 = state_57971__$1;
(statearr_57974_58011[(2)] = null);

(statearr_57974_58011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (4))){
var inst_57887 = (state_57971[(2)]);
var state_57971__$1 = state_57971;
var statearr_57975_58012 = state_57971__$1;
(statearr_57975_58012[(2)] = inst_57887);

(statearr_57975_58012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (15))){
var inst_57920 = (state_57971[(7)]);
var inst_57934 = (state_57971[(8)]);
var inst_57932 = (state_57971[(2)]);
var inst_57933 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57920,"_fn/params");
var inst_57934__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_57933);
var inst_57935 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57920,"_fn/code");
var inst_57936 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_57935);
var inst_57937 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_57936,funType,inst_57934__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_57936,funType,inst_57934__$1));
var state_57971__$1 = (function (){var statearr_57976 = state_57971;
(statearr_57976[(9)] = inst_57932);

(statearr_57976[(8)] = inst_57934__$1);

return statearr_57976;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57971__$1,(16),inst_57937);
} else {
if((state_val_57972 === (13))){
var inst_57923 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_57924 = ["Unknown function: ",inst_57923].join('');
var inst_57925 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_57926 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_57927 = cljs.core.PersistentHashMap.fromArrays(inst_57925,inst_57926);
var inst_57928 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_57924,inst_57927);
var inst_57929 = (function(){throw inst_57928})();
var state_57971__$1 = state_57971;
var statearr_57977_58013 = state_57971__$1;
(statearr_57977_58013[(2)] = inst_57929);

(statearr_57977_58013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (6))){
var state_57971__$1 = state_57971;
var statearr_57978_58014 = state_57971__$1;
(statearr_57978_58014[(2)] = null);

(statearr_57978_58014[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (17))){
var state_57971__$1 = state_57971;
var statearr_57979_58015 = state_57971__$1;
(statearr_57979_58015[(2)] = null);

(statearr_57979_58015[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (3))){
var inst_57969 = (state_57971[(2)]);
var state_57971__$1 = state_57971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57971__$1,inst_57969);
} else {
if((state_val_57972 === (12))){
var inst_57920 = (state_57971[(7)]);
var inst_57919 = (state_57971[(2)]);
var inst_57920__$1 = fluree.db.util.async.throw_err(inst_57919);
var inst_57921 = cljs.core.empty_QMARK_(inst_57920__$1);
var state_57971__$1 = (function (){var statearr_57980 = state_57971;
(statearr_57980[(7)] = inst_57920__$1);

return statearr_57980;
})();
if(inst_57921){
var statearr_57981_58016 = state_57971__$1;
(statearr_57981_58016[(1)] = (13));

} else {
var statearr_57982_58017 = state_57971__$1;
(statearr_57982_58017[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (2))){
var inst_57893 = (state_57971[(10)]);
var _ = (function (){var statearr_57983 = state_57971;
(statearr_57983[(4)] = cljs.core.cons((5),(state_57971[(4)])));

return statearr_57983;
})();
var inst_57893__$1 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var state_57971__$1 = (function (){var statearr_57984 = state_57971;
(statearr_57984[(10)] = inst_57893__$1);

return statearr_57984;
})();
if(cljs.core.truth_(inst_57893__$1)){
var statearr_57985_58018 = state_57971__$1;
(statearr_57985_58018[(1)] = (6));

} else {
var statearr_57986_58019 = state_57971__$1;
(statearr_57986_58019[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (19))){
var inst_57954 = (state_57971[(11)]);
var inst_57964 = (state_57971[(2)]);
var state_57971__$1 = (function (){var statearr_57987 = state_57971;
(statearr_57987[(12)] = inst_57964);

return statearr_57987;
})();
var statearr_57988_58020 = state_57971__$1;
(statearr_57988_58020[(2)] = inst_57954);

(statearr_57988_58020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (11))){
var inst_57966 = (state_57971[(2)]);
var _ = (function (){var statearr_57990 = state_57971;
(statearr_57990[(4)] = cljs.core.rest((state_57971[(4)])));

return statearr_57990;
})();
var state_57971__$1 = state_57971;
var statearr_57991_58021 = state_57971__$1;
(statearr_57991_58021[(2)] = inst_57966);

(statearr_57991_58021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (9))){
var inst_57904 = (state_57971[(13)]);
var state_57971__$1 = state_57971;
var statearr_57992_58022 = state_57971__$1;
(statearr_57992_58022[(2)] = inst_57904);

(statearr_57992_58022[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (5))){
var _ = (function (){var statearr_57993 = state_57971;
(statearr_57993[(4)] = cljs.core.rest((state_57971[(4)])));

return statearr_57993;
})();
var state_57971__$1 = state_57971;
var ex57989 = (state_57971__$1[(2)]);
var statearr_57994_58023 = state_57971__$1;
(statearr_57994_58023[(5)] = ex57989);


if((ex57989 instanceof Error)){
var statearr_57995_58024 = state_57971__$1;
(statearr_57995_58024[(1)] = (4));

(statearr_57995_58024[(5)] = null);

} else {
throw ex57989;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (14))){
var state_57971__$1 = state_57971;
var statearr_57996_58025 = state_57971__$1;
(statearr_57996_58025[(2)] = null);

(statearr_57996_58025[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (16))){
var inst_57904 = (state_57971[(13)]);
var inst_57932 = (state_57971[(9)]);
var inst_57916 = (state_57971[(14)]);
var inst_57893 = (state_57971[(10)]);
var inst_57920 = (state_57971[(7)]);
var inst_57934 = (state_57971[(8)]);
var inst_57939 = (state_57971[(2)]);
var inst_57940 = fluree.db.util.async.throw_err(inst_57939);
var inst_57941 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57920,"_fn/spec");
var inst_57942 = cljs.core.PersistentVector.EMPTY;
var inst_57943 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_57944 = (function (){var forward_time_travel_db_QMARK_ = inst_57893;
var or__5045__auto__ = inst_57904;
var query = inst_57916;
var res = inst_57920;
var _ = inst_57932;
var params = inst_57934;
var code = inst_57940;
var spec = inst_57941;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_57945 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_57944,inst_57934);
var inst_57946 = cljs.core.cons(inst_57943,inst_57945);
var inst_57947 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_57942,inst_57946);
var inst_57948 = fluree.db.dbfunctions.core.build_fn(inst_57947,inst_57940);
var inst_57949 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"&args?","&args?",-1736256945),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_57950 = cljs.core.count(inst_57934);
var inst_57951 = [inst_57950];
var inst_57952 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_57951);
var inst_57953 = [inst_57948,inst_57934,inst_57952,false,inst_57941,null];
var inst_57954 = cljs.core.PersistentHashMap.fromArrays(inst_57949,inst_57953);
var state_57971__$1 = (function (){var statearr_57997 = state_57971;
(statearr_57997[(11)] = inst_57954);

return statearr_57997;
})();
if(cljs.core.truth_(inst_57893)){
var statearr_57998_58026 = state_57971__$1;
(statearr_57998_58026[(1)] = (17));

} else {
var statearr_57999_58027 = state_57971__$1;
(statearr_57999_58027[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (10))){
var inst_57916 = (state_57971[(14)]);
var inst_57907 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_57908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57909 = ["_fn/params","_fn/code","_fn/spec"];
var inst_57910 = (new cljs.core.PersistentVector(null,3,(5),inst_57908,inst_57909,null));
var inst_57911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57912 = cljs.core.name(fn_name);
var inst_57913 = ["_fn/name",inst_57912];
var inst_57914 = (new cljs.core.PersistentVector(null,2,(5),inst_57911,inst_57913,null));
var inst_57915 = [inst_57910,inst_57914];
var inst_57916__$1 = cljs.core.PersistentHashMap.fromArrays(inst_57907,inst_57915);
var inst_57917 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_57916__$1);
var state_57971__$1 = (function (){var statearr_58000 = state_57971;
(statearr_58000[(14)] = inst_57916__$1);

return statearr_58000;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57971__$1,(12),inst_57917);
} else {
if((state_val_57972 === (18))){
var inst_57954 = (state_57971[(11)]);
var inst_57957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57958 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(db);
var inst_57959 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_57960 = [fn_name,inst_57958,inst_57959];
var inst_57961 = (new cljs.core.PersistentVector(null,3,(5),inst_57957,inst_57960,null));
var inst_57962 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_57961,inst_57954);
var state_57971__$1 = state_57971;
var statearr_58001_58028 = state_57971__$1;
(statearr_58001_58028[(2)] = inst_57962);

(statearr_58001_58028[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57972 === (8))){
var inst_57904 = (state_57971[(13)]);
var inst_57904__$1 = (state_57971[(2)]);
var state_57971__$1 = (function (){var statearr_58002 = state_57971;
(statearr_58002[(13)] = inst_57904__$1);

return statearr_58002;
})();
if(cljs.core.truth_(inst_57904__$1)){
var statearr_58003_58029 = state_57971__$1;
(statearr_58003_58029[(1)] = (9));

} else {
var statearr_58004_58030 = state_57971__$1;
(statearr_58004_58030[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto____0 = (function (){
var statearr_58005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58005[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto__);

(statearr_58005[(1)] = (1));

return statearr_58005;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto____1 = (function (state_57971){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57971);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58006){var ex__2687__auto__ = e58006;
var statearr_58007_58031 = state_57971;
(statearr_58007_58031[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57971[(4)]))){
var statearr_58008_58032 = state_57971;
(statearr_58008_58032[(1)] = cljs.core.first((state_57971[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58033 = state_57971;
state_57971 = G__58033;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto__ = function(state_57971){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto____1.call(this,state_57971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58009 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58009[(6)] = c__2706__auto__);

return statearr_58009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__58035 = arguments.length;
switch (G__58035) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__58039 = arguments.length;
switch (G__58039) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58169){
var state_val_58170 = (state_58169[(1)]);
if((state_val_58170 === (7))){
var inst_58164 = (state_58169[(2)]);
var _ = (function (){var statearr_58171 = state_58169;
(statearr_58171[(4)] = cljs.core.rest((state_58169[(4)])));

return statearr_58171;
})();
var state_58169__$1 = state_58169;
var statearr_58172_58252 = state_58169__$1;
(statearr_58172_58252[(2)] = inst_58164);

(statearr_58172_58252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (20))){
var inst_58078 = (state_58169[(7)]);
var state_58169__$1 = state_58169;
var statearr_58173_58253 = state_58169__$1;
(statearr_58173_58253[(2)] = inst_58078);

(statearr_58173_58253[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (27))){
var inst_58065 = (state_58169[(8)]);
var inst_58091 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_58092 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58065)," used in function.",inst_58091].join('');
var inst_58093 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58094 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_58095 = cljs.core.PersistentHashMap.fromArrays(inst_58093,inst_58094);
var inst_58096 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_58092,inst_58095);
var inst_58097 = (function(){throw inst_58096})();
var state_58169__$1 = state_58169;
var statearr_58174_58254 = state_58169__$1;
(statearr_58174_58254[(2)] = inst_58097);

(statearr_58174_58254[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (1))){
var state_58169__$1 = state_58169;
var statearr_58175_58255 = state_58169__$1;
(statearr_58175_58255[(2)] = null);

(statearr_58175_58255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (24))){
var inst_58088 = (state_58169[(9)]);
var inst_58088__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_58169__$1 = (function (){var statearr_58176 = state_58169;
(statearr_58176[(9)] = inst_58088__$1);

return statearr_58176;
})();
if(inst_58088__$1){
var statearr_58177_58256 = state_58169__$1;
(statearr_58177_58256[(1)] = (26));

} else {
var statearr_58178_58257 = state_58169__$1;
(statearr_58178_58257[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (39))){
var inst_58065 = (state_58169[(8)]);
var inst_58125 = (inst_58065 == null);
var state_58169__$1 = state_58169;
if(cljs.core.truth_(inst_58125)){
var statearr_58179_58258 = state_58169__$1;
(statearr_58179_58258[(1)] = (42));

} else {
var statearr_58180_58259 = state_58169__$1;
(statearr_58180_58259[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (46))){
var state_58169__$1 = state_58169;
var statearr_58181_58260 = state_58169__$1;
(statearr_58181_58260[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (4))){
var inst_58040 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58183_58261 = state_58169__$1;
(statearr_58183_58261[(2)] = inst_58040);

(statearr_58183_58261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (15))){
var inst_58065 = (state_58169[(8)]);
var inst_58076 = (inst_58065 instanceof cljs.core.Symbol);
var state_58169__$1 = state_58169;
if(cljs.core.truth_(inst_58076)){
var statearr_58184_58262 = state_58169__$1;
(statearr_58184_58262[(1)] = (17));

} else {
var statearr_58185_58263 = state_58169__$1;
(statearr_58185_58263[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (48))){
var inst_58132 = (state_58169[(2)]);
var inst_58133 = fluree.db.util.async.throw_err(inst_58132);
var state_58169__$1 = state_58169;
var statearr_58186_58264 = state_58169__$1;
(statearr_58186_58264[(2)] = inst_58133);

(statearr_58186_58264[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (50))){
var state_58169__$1 = state_58169;
var statearr_58187_58265 = state_58169__$1;
(statearr_58187_58265[(2)] = null);

(statearr_58187_58265[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (21))){
var inst_58059 = (state_58169[(10)]);
var inst_58085 = (state_58169[(11)]);
var inst_58053 = (state_58169[(12)]);
var inst_58055 = (state_58169[(13)]);
var inst_58078 = (state_58169[(7)]);
var inst_58058 = (state_58169[(14)]);
var inst_58056 = (state_58169[(15)]);
var inst_58066 = (state_58169[(16)]);
var inst_58065 = (state_58169[(8)]);
var inst_58081 = [inst_58065];
var inst_58082 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_58081);
var inst_58083 = (function (){var x = inst_58065;
var vec__58061 = inst_58058;
var G__58049 = inst_58058;
var or__5045__auto__ = inst_58078;
var r = inst_58066;
var vec__58050 = inst_58053;
var seq__58062 = inst_58066;
var acc = inst_58059;
var first__58052 = inst_58055;
var seq__58051 = inst_58056;
var first__58063 = inst_58065;
return (function (p1__58037_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__58037_SHARP_);
});
})();
var inst_58084 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_58083,params);
var inst_58085__$1 = cljs.core.some(inst_58082,inst_58084);
var state_58169__$1 = (function (){var statearr_58188 = state_58169;
(statearr_58188[(11)] = inst_58085__$1);

return statearr_58188;
})();
if(cljs.core.truth_(inst_58085__$1)){
var statearr_58189_58266 = state_58169__$1;
(statearr_58189_58266[(1)] = (23));

} else {
var statearr_58190_58267 = state_58169__$1;
(statearr_58190_58267[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (31))){
var inst_58115 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
if(cljs.core.truth_(inst_58115)){
var statearr_58191_58268 = state_58169__$1;
(statearr_58191_58268[(1)] = (35));

} else {
var statearr_58192_58269 = state_58169__$1;
(statearr_58192_58269[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (32))){
var inst_58108 = (state_58169[(17)]);
var state_58169__$1 = state_58169;
var statearr_58193_58270 = state_58169__$1;
(statearr_58193_58270[(2)] = inst_58108);

(statearr_58193_58270[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (40))){
var inst_58150 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58194_58271 = state_58169__$1;
(statearr_58194_58271[(2)] = inst_58150);

(statearr_58194_58271[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (33))){
var inst_58065 = (state_58169[(8)]);
var inst_58111 = (inst_58065 == null);
var state_58169__$1 = state_58169;
var statearr_58195_58272 = state_58169__$1;
(statearr_58195_58272[(2)] = inst_58111);

(statearr_58195_58272[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (13))){
var inst_58059 = (state_58169[(10)]);
var inst_58066 = (state_58169[(16)]);
var inst_58158 = (state_58169[(2)]);
var inst_58159 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_58059,inst_58158);
var inst_58058 = inst_58066;
var inst_58059__$1 = inst_58159;
var state_58169__$1 = (function (){var statearr_58196 = state_58169;
(statearr_58196[(10)] = inst_58059__$1);

(statearr_58196[(14)] = inst_58058);

return statearr_58196;
})();
var statearr_58197_58273 = state_58169__$1;
(statearr_58197_58273[(2)] = null);

(statearr_58197_58273[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (22))){
var inst_58103 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58198_58274 = state_58169__$1;
(statearr_58198_58274[(2)] = inst_58103);

(statearr_58198_58274[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (36))){
var inst_58065 = (state_58169[(8)]);
var inst_58118 = cljs.core.vector_QMARK_(inst_58065);
var state_58169__$1 = state_58169;
if(inst_58118){
var statearr_58199_58275 = state_58169__$1;
(statearr_58199_58275[(1)] = (38));

} else {
var statearr_58200_58276 = state_58169__$1;
(statearr_58200_58276[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (41))){
var inst_58122 = (state_58169[(2)]);
var inst_58123 = fluree.db.util.async.throw_err(inst_58122);
var state_58169__$1 = state_58169;
var statearr_58201_58277 = state_58169__$1;
(statearr_58201_58277[(2)] = inst_58123);

(statearr_58201_58277[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (43))){
var inst_58065 = (state_58169[(8)]);
var inst_58128 = cljs.core.list_QMARK_(inst_58065);
var state_58169__$1 = state_58169;
if(inst_58128){
var statearr_58202_58278 = state_58169__$1;
(statearr_58202_58278[(1)] = (45));

} else {
var statearr_58203_58279 = state_58169__$1;
(statearr_58203_58279[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (29))){
var inst_58105 = (state_58169[(18)]);
var state_58169__$1 = state_58169;
var statearr_58204_58280 = state_58169__$1;
(statearr_58204_58280[(2)] = inst_58105);

(statearr_58204_58280[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (44))){
var inst_58148 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58205_58281 = state_58169__$1;
(statearr_58205_58281[(2)] = inst_58148);

(statearr_58205_58281[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (6))){
var inst_58058 = (state_58169[(14)]);
var inst_58065 = (state_58169[(8)]);
var inst_58064 = cljs.core.seq(inst_58058);
var inst_58065__$1 = cljs.core.first(inst_58064);
var inst_58066 = cljs.core.next(inst_58064);
var inst_58067 = (inst_58065__$1 == null);
var state_58169__$1 = (function (){var statearr_58206 = state_58169;
(statearr_58206[(16)] = inst_58066);

(statearr_58206[(8)] = inst_58065__$1);

return statearr_58206;
})();
if(cljs.core.truth_(inst_58067)){
var statearr_58207_58282 = state_58169__$1;
(statearr_58207_58282[(1)] = (8));

} else {
var statearr_58208_58283 = state_58169__$1;
(statearr_58208_58283[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (28))){
var inst_58099 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58209_58284 = state_58169__$1;
(statearr_58209_58284[(2)] = inst_58099);

(statearr_58209_58284[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (51))){
var inst_58144 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58210_58285 = state_58169__$1;
(statearr_58210_58285[(2)] = inst_58144);

(statearr_58210_58285[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (25))){
var inst_58101 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58211_58286 = state_58169__$1;
(statearr_58211_58286[(2)] = inst_58101);

(statearr_58211_58286[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (34))){
var inst_58113 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58212_58287 = state_58169__$1;
(statearr_58212_58287[(2)] = inst_58113);

(statearr_58212_58287[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (17))){
var inst_58078 = (state_58169[(7)]);
var inst_58065 = (state_58169[(8)]);
var inst_58078__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_58065) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_58065));
var state_58169__$1 = (function (){var statearr_58213 = state_58169;
(statearr_58213[(7)] = inst_58078__$1);

return statearr_58213;
})();
if(cljs.core.truth_(inst_58078__$1)){
var statearr_58214_58288 = state_58169__$1;
(statearr_58214_58288[(1)] = (20));

} else {
var statearr_58215_58289 = state_58169__$1;
(statearr_58215_58289[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (3))){
var inst_58167 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58169__$1,inst_58167);
} else {
if((state_val_58170 === (12))){
var inst_58065 = (state_58169[(8)]);
var inst_58073 = typeof inst_58065 === 'number';
var state_58169__$1 = state_58169;
if(cljs.core.truth_(inst_58073)){
var statearr_58216_58290 = state_58169__$1;
(statearr_58216_58290[(1)] = (14));

} else {
var statearr_58217_58291 = state_58169__$1;
(statearr_58217_58291[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (2))){
var inst_58053 = (state_58169[(12)]);
var _ = (function (){var statearr_58218 = state_58169;
(statearr_58218[(4)] = cljs.core.cons((5),(state_58169[(4)])));

return statearr_58218;
})();
var inst_58053__$1 = vec;
var inst_58054 = cljs.core.seq(inst_58053__$1);
var inst_58055 = cljs.core.first(inst_58054);
var inst_58056 = cljs.core.next(inst_58054);
var inst_58057 = cljs.core.PersistentVector.EMPTY;
var inst_58058 = inst_58053__$1;
var inst_58059 = inst_58057;
var state_58169__$1 = (function (){var statearr_58219 = state_58169;
(statearr_58219[(10)] = inst_58059);

(statearr_58219[(12)] = inst_58053__$1);

(statearr_58219[(13)] = inst_58055);

(statearr_58219[(14)] = inst_58058);

(statearr_58219[(15)] = inst_58056);

return statearr_58219;
})();
var statearr_58220_58292 = state_58169__$1;
(statearr_58220_58292[(2)] = null);

(statearr_58220_58292[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (23))){
var inst_58085 = (state_58169[(11)]);
var state_58169__$1 = state_58169;
var statearr_58221_58293 = state_58169__$1;
(statearr_58221_58293[(2)] = inst_58085);

(statearr_58221_58293[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (47))){
var inst_58146 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58222_58294 = state_58169__$1;
(statearr_58222_58294[(2)] = inst_58146);

(statearr_58222_58294[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (35))){
var inst_58065 = (state_58169[(8)]);
var state_58169__$1 = state_58169;
var statearr_58223_58295 = state_58169__$1;
(statearr_58223_58295[(2)] = inst_58065);

(statearr_58223_58295[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (19))){
var inst_58154 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58224_58296 = state_58169__$1;
(statearr_58224_58296[(2)] = inst_58154);

(statearr_58224_58296[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (11))){
var inst_58065 = (state_58169[(8)]);
var state_58169__$1 = state_58169;
var statearr_58226_58297 = state_58169__$1;
(statearr_58226_58297[(2)] = inst_58065);

(statearr_58226_58297[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (9))){
var inst_58065 = (state_58169[(8)]);
var inst_58070 = typeof inst_58065 === 'string';
var state_58169__$1 = state_58169;
if(cljs.core.truth_(inst_58070)){
var statearr_58227_58298 = state_58169__$1;
(statearr_58227_58298[(1)] = (11));

} else {
var statearr_58228_58299 = state_58169__$1;
(statearr_58228_58299[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (5))){
var _ = (function (){var statearr_58229 = state_58169;
(statearr_58229[(4)] = cljs.core.rest((state_58169[(4)])));

return statearr_58229;
})();
var state_58169__$1 = state_58169;
var ex58225 = (state_58169__$1[(2)]);
var statearr_58230_58300 = state_58169__$1;
(statearr_58230_58300[(5)] = ex58225);


if((ex58225 instanceof Error)){
var statearr_58231_58301 = state_58169__$1;
(statearr_58231_58301[(1)] = (4));

(statearr_58231_58301[(5)] = null);

} else {
throw ex58225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (14))){
var inst_58065 = (state_58169[(8)]);
var state_58169__$1 = state_58169;
var statearr_58232_58302 = state_58169__$1;
(statearr_58232_58302[(2)] = inst_58065);

(statearr_58232_58302[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (45))){
var inst_58065 = (state_58169[(8)]);
var inst_58130 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_58065,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_58065,funType,params));
var state_58169__$1 = state_58169;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58169__$1,(48),inst_58130);
} else {
if((state_val_58170 === (26))){
var inst_58088 = (state_58169[(9)]);
var state_58169__$1 = state_58169;
var statearr_58233_58303 = state_58169__$1;
(statearr_58233_58303[(2)] = inst_58088);

(statearr_58233_58303[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (16))){
var inst_58156 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58234_58304 = state_58169__$1;
(statearr_58234_58304[(2)] = inst_58156);

(statearr_58234_58304[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (38))){
var inst_58065 = (state_58169[(8)]);
var inst_58120 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_58065,funType,params);
var state_58169__$1 = state_58169;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58169__$1,(41),inst_58120);
} else {
if((state_val_58170 === (30))){
var inst_58108 = (state_58169[(17)]);
var inst_58065 = (state_58169[(8)]);
var inst_58108__$1 = inst_58065 === false;
var state_58169__$1 = (function (){var statearr_58235 = state_58169;
(statearr_58235[(17)] = inst_58108__$1);

return statearr_58235;
})();
if(cljs.core.truth_(inst_58108__$1)){
var statearr_58236_58305 = state_58169__$1;
(statearr_58236_58305[(1)] = (32));

} else {
var statearr_58237_58306 = state_58169__$1;
(statearr_58237_58306[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (10))){
var inst_58162 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58238_58307 = state_58169__$1;
(statearr_58238_58307[(2)] = inst_58162);

(statearr_58238_58307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (18))){
var inst_58105 = (state_58169[(18)]);
var inst_58065 = (state_58169[(8)]);
var inst_58105__$1 = inst_58065 === true;
var state_58169__$1 = (function (){var statearr_58239 = state_58169;
(statearr_58239[(18)] = inst_58105__$1);

return statearr_58239;
})();
if(cljs.core.truth_(inst_58105__$1)){
var statearr_58240_58308 = state_58169__$1;
(statearr_58240_58308[(1)] = (29));

} else {
var statearr_58241_58309 = state_58169__$1;
(statearr_58241_58309[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (42))){
var inst_58065 = (state_58169[(8)]);
var state_58169__$1 = state_58169;
var statearr_58242_58310 = state_58169__$1;
(statearr_58242_58310[(2)] = inst_58065);

(statearr_58242_58310[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (37))){
var inst_58152 = (state_58169[(2)]);
var state_58169__$1 = state_58169;
var statearr_58243_58311 = state_58169__$1;
(statearr_58243_58311[(2)] = inst_58152);

(statearr_58243_58311[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (8))){
var inst_58059 = (state_58169[(10)]);
var state_58169__$1 = state_58169;
var statearr_58244_58312 = state_58169__$1;
(statearr_58244_58312[(2)] = inst_58059);

(statearr_58244_58312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58170 === (49))){
var inst_58065 = (state_58169[(8)]);
var inst_58136 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_58065], 0));
var inst_58137 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_58138 = ["Illegal element (",inst_58136,") in vector: ",inst_58137,"."].join('');
var inst_58139 = cljs.core.PersistentHashMap.EMPTY;
var inst_58140 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_58138,inst_58139);
var inst_58141 = (function(){throw inst_58140})();
var state_58169__$1 = state_58169;
var statearr_58245_58313 = state_58169__$1;
(statearr_58245_58313[(2)] = inst_58141);

(statearr_58245_58313[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2684__auto____0 = (function (){
var statearr_58246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58246[(0)] = fluree$db$dbfunctions$core$state_machine__2684__auto__);

(statearr_58246[(1)] = (1));

return statearr_58246;
});
var fluree$db$dbfunctions$core$state_machine__2684__auto____1 = (function (state_58169){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58169);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58247){var ex__2687__auto__ = e58247;
var statearr_58248_58314 = state_58169;
(statearr_58248_58314[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58169[(4)]))){
var statearr_58249_58315 = state_58169;
(statearr_58249_58315[(1)] = cljs.core.first((state_58169[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58316 = state_58169;
state_58169 = G__58316;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2684__auto__ = function(state_58169){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2684__auto____1.call(this,state_58169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2684__auto____0;
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58250 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58250[(6)] = c__2706__auto__);

return statearr_58250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5804__auto__)){
var local_fn = temp__5804__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__58319 = arguments.length;
switch (G__58319) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58483){
var state_val_58484 = (state_58483[(1)]);
if((state_val_58484 === (7))){
var inst_58327 = (state_58483[(7)]);
var inst_58333 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_58327,type);
var state_58483__$1 = state_58483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58483__$1,(9),inst_58333);
} else {
if((state_val_58484 === (59))){
var inst_58376 = (state_58483[(8)]);
var inst_58447 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_58376], 0));
var inst_58448 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_58376) : type.call(null,inst_58376));
var inst_58449 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_58450 = ["Illegal element (",inst_58447,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58448),") in function argument: ",inst_58449,"."].join('');
var inst_58451 = cljs.core.PersistentHashMap.EMPTY;
var inst_58452 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_58450,inst_58451);
var inst_58453 = (function(){throw inst_58452})();
var state_58483__$1 = state_58483;
var statearr_58485_58580 = state_58483__$1;
(statearr_58485_58580[(2)] = inst_58453);

(statearr_58485_58580[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (20))){
var inst_58382 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
if(cljs.core.truth_(inst_58382)){
var statearr_58486_58581 = state_58483__$1;
(statearr_58486_58581[(1)] = (21));

} else {
var statearr_58487_58582 = state_58483__$1;
(statearr_58487_58582[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (58))){
var inst_58443 = (state_58483[(2)]);
var inst_58444 = fluree.db.util.async.throw_err(inst_58443);
var state_58483__$1 = state_58483;
var statearr_58488_58583 = state_58483__$1;
(statearr_58488_58583[(2)] = inst_58444);

(statearr_58488_58583[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (60))){
var state_58483__$1 = state_58483;
var statearr_58489_58584 = state_58483__$1;
(statearr_58489_58584[(2)] = null);

(statearr_58489_58584[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (27))){
var inst_58388 = (state_58483[(2)]);
var inst_58389 = fluree.db.util.async.throw_err(inst_58388);
var state_58483__$1 = state_58483;
var statearr_58490_58585 = state_58483__$1;
(statearr_58490_58585[(2)] = inst_58389);

(statearr_58490_58585[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (1))){
var state_58483__$1 = state_58483;
var statearr_58491_58586 = state_58483__$1;
(statearr_58491_58586[(2)] = null);

(statearr_58491_58586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (24))){
var inst_58376 = (state_58483[(8)]);
var inst_58386 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_58376,type,params);
var state_58483__$1 = state_58483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58483__$1,(27),inst_58386);
} else {
if((state_val_58484 === (55))){
var inst_58376 = (state_58483[(8)]);
var inst_58441 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_58376,type,params);
var state_58483__$1 = state_58483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58483__$1,(58),inst_58441);
} else {
if((state_val_58484 === (39))){
var inst_58424 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58492_58587 = state_58483__$1;
(statearr_58492_58587[(2)] = inst_58424);

(statearr_58492_58587[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (46))){
var inst_58426 = (state_58483[(9)]);
var state_58483__$1 = state_58483;
var statearr_58493_58588 = state_58483__$1;
(statearr_58493_58588[(2)] = inst_58426);

(statearr_58493_58588[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (4))){
var inst_58320 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58494_58589 = state_58483__$1;
(statearr_58494_58589[(2)] = inst_58320);

(statearr_58494_58589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (54))){
var inst_58460 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58495_58590 = state_58483__$1;
(statearr_58495_58590[(2)] = inst_58460);

(statearr_58495_58590[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (15))){
var inst_58328 = (state_58483[(10)]);
var inst_58357 = (state_58483[(2)]);
var inst_58365 = cljs.core.seq(inst_58328);
var inst_58366 = cljs.core.first(inst_58365);
var inst_58367 = cljs.core.next(inst_58365);
var inst_58368 = cljs.core.PersistentVector.EMPTY;
var inst_58369 = inst_58328;
var inst_58370 = inst_58368;
var state_58483__$1 = (function (){var statearr_58496 = state_58483;
(statearr_58496[(11)] = inst_58369);

(statearr_58496[(12)] = inst_58367);

(statearr_58496[(13)] = inst_58357);

(statearr_58496[(14)] = inst_58366);

(statearr_58496[(15)] = inst_58370);

return statearr_58496;
})();
var statearr_58497_58591 = state_58483__$1;
(statearr_58497_58591[(2)] = null);

(statearr_58497_58591[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (48))){
var inst_58436 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
if(cljs.core.truth_(inst_58436)){
var statearr_58498_58592 = state_58483__$1;
(statearr_58498_58592[(1)] = (52));

} else {
var statearr_58499_58593 = state_58483__$1;
(statearr_58499_58593[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (50))){
var inst_58376 = (state_58483[(8)]);
var inst_58432 = (inst_58376 == null);
var state_58483__$1 = state_58483;
var statearr_58500_58594 = state_58483__$1;
(statearr_58500_58594[(2)] = inst_58432);

(statearr_58500_58594[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (21))){
var inst_58376 = (state_58483[(8)]);
var inst_58384 = cljs.core.list_QMARK_(inst_58376);
var state_58483__$1 = state_58483;
if(inst_58384){
var statearr_58501_58595 = state_58483__$1;
(statearr_58501_58595[(1)] = (24));

} else {
var statearr_58502_58596 = state_58483__$1;
(statearr_58502_58596[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (31))){
var inst_58376 = (state_58483[(8)]);
var state_58483__$1 = state_58483;
var statearr_58503_58597 = state_58483__$1;
(statearr_58503_58597[(2)] = inst_58376);

(statearr_58503_58597[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (32))){
var inst_58376 = (state_58483[(8)]);
var inst_58397 = (inst_58376 instanceof cljs.core.Symbol);
var state_58483__$1 = state_58483;
if(cljs.core.truth_(inst_58397)){
var statearr_58504_58598 = state_58483__$1;
(statearr_58504_58598[(1)] = (34));

} else {
var statearr_58505_58599 = state_58483__$1;
(statearr_58505_58599[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (40))){
var inst_58406 = (state_58483[(16)]);
var state_58483__$1 = state_58483;
var statearr_58506_58600 = state_58483__$1;
(statearr_58506_58600[(2)] = inst_58406);

(statearr_58506_58600[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (56))){
var state_58483__$1 = state_58483;
var statearr_58507_58601 = state_58483__$1;
(statearr_58507_58601[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (33))){
var inst_58464 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58509_58602 = state_58483__$1;
(statearr_58509_58602[(2)] = inst_58464);

(statearr_58509_58602[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (13))){
var inst_58341 = (state_58483[(17)]);
var inst_58329 = (state_58483[(18)]);
var inst_58327 = (state_58483[(7)]);
var inst_58351 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58327),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58341),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58329),"."].join('');
var inst_58352 = cljs.core.PersistentHashMap.EMPTY;
var inst_58353 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_58351,inst_58352);
var inst_58354 = (function(){throw inst_58353})();
var state_58483__$1 = state_58483;
var statearr_58510_58603 = state_58483__$1;
(statearr_58510_58603[(2)] = inst_58354);

(statearr_58510_58603[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (22))){
var inst_58370 = (state_58483[(15)]);
var state_58483__$1 = state_58483;
var statearr_58511_58604 = state_58483__$1;
(statearr_58511_58604[(2)] = inst_58370);

(statearr_58511_58604[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (36))){
var inst_58462 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58512_58605 = state_58483__$1;
(statearr_58512_58605[(2)] = inst_58462);

(statearr_58512_58605[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (41))){
var inst_58409 = (state_58483[(19)]);
var inst_58409__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_58483__$1 = (function (){var statearr_58513 = state_58483;
(statearr_58513[(19)] = inst_58409__$1);

return statearr_58513;
})();
if(inst_58409__$1){
var statearr_58514_58606 = state_58483__$1;
(statearr_58514_58606[(1)] = (43));

} else {
var statearr_58515_58607 = state_58483__$1;
(statearr_58515_58607[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (43))){
var inst_58409 = (state_58483[(19)]);
var state_58483__$1 = state_58483;
var statearr_58516_58608 = state_58483__$1;
(statearr_58516_58608[(2)] = inst_58409);

(statearr_58516_58608[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (61))){
var inst_58456 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58517_58609 = state_58483__$1;
(statearr_58517_58609[(2)] = inst_58456);

(statearr_58517_58609[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (29))){
var inst_58376 = (state_58483[(8)]);
var inst_58394 = typeof inst_58376 === 'number';
var state_58483__$1 = state_58483;
if(cljs.core.truth_(inst_58394)){
var statearr_58518_58610 = state_58483__$1;
(statearr_58518_58610[(1)] = (31));

} else {
var statearr_58519_58611 = state_58483__$1;
(statearr_58519_58611[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (44))){
var inst_58376 = (state_58483[(8)]);
var inst_58412 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_58413 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58376)," used in function argument: ",inst_58412].join('');
var inst_58414 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58415 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_58416 = cljs.core.PersistentHashMap.fromArrays(inst_58414,inst_58415);
var inst_58417 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_58413,inst_58416);
var inst_58418 = (function(){throw inst_58417})();
var state_58483__$1 = state_58483;
var statearr_58520_58612 = state_58483__$1;
(statearr_58520_58612[(2)] = inst_58418);

(statearr_58520_58612[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (6))){
var inst_58330 = (state_58483[(20)]);
var state_58483__$1 = state_58483;
var statearr_58521_58613 = state_58483__$1;
(statearr_58521_58613[(2)] = inst_58330);

(statearr_58521_58613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (28))){
var inst_58376 = (state_58483[(8)]);
var state_58483__$1 = state_58483;
var statearr_58522_58614 = state_58483__$1;
(statearr_58522_58614[(2)] = inst_58376);

(statearr_58522_58614[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (51))){
var inst_58434 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58523_58615 = state_58483__$1;
(statearr_58523_58615[(2)] = inst_58434);

(statearr_58523_58615[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (25))){
var inst_58376 = (state_58483[(8)]);
var inst_58391 = typeof inst_58376 === 'string';
var state_58483__$1 = state_58483;
if(cljs.core.truth_(inst_58391)){
var statearr_58524_58616 = state_58483__$1;
(statearr_58524_58616[(1)] = (28));

} else {
var statearr_58525_58617 = state_58483__$1;
(statearr_58525_58617[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (34))){
var inst_58399 = (state_58483[(21)]);
var inst_58376 = (state_58483[(8)]);
var inst_58399__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_58376) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_58376));
var state_58483__$1 = (function (){var statearr_58526 = state_58483;
(statearr_58526[(21)] = inst_58399__$1);

return statearr_58526;
})();
if(cljs.core.truth_(inst_58399__$1)){
var statearr_58527_58618 = state_58483__$1;
(statearr_58527_58618[(1)] = (37));

} else {
var statearr_58528_58619 = state_58483__$1;
(statearr_58528_58619[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (17))){
var inst_58340 = (state_58483[(22)]);
var inst_58475 = (state_58483[(2)]);
var inst_58476 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_58477 = cljs.core.cons(inst_58476,inst_58475);
var inst_58478 = cljs.core.cons(inst_58340,inst_58477);
var _ = (function (){var statearr_58529 = state_58483;
(statearr_58529[(4)] = cljs.core.rest((state_58483[(4)])));

return statearr_58529;
})();
var state_58483__$1 = state_58483;
var statearr_58530_58620 = state_58483__$1;
(statearr_58530_58620[(2)] = inst_58478);

(statearr_58530_58620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (3))){
var inst_58481 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58483__$1,inst_58481);
} else {
if((state_val_58484 === (12))){
var inst_58348 = (state_58483[(2)]);
var inst_58349 = cljs.core.not(inst_58348);
var state_58483__$1 = state_58483;
if(inst_58349){
var statearr_58531_58621 = state_58483__$1;
(statearr_58531_58621[(1)] = (13));

} else {
var statearr_58532_58622 = state_58483__$1;
(statearr_58532_58622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (2))){
var inst_58328 = (state_58483[(10)]);
var inst_58330 = (state_58483[(20)]);
var inst_58327 = (state_58483[(7)]);
var _ = (function (){var statearr_58533 = state_58483;
(statearr_58533[(4)] = cljs.core.cons((5),(state_58483[(4)])));

return statearr_58533;
})();
var inst_58327__$1 = cljs.core.first(form);
var inst_58328__$1 = cljs.core.rest(form);
var inst_58329 = cljs.core.count(inst_58328__$1);
var inst_58330__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_58327__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_58327__$1));
var state_58483__$1 = (function (){var statearr_58534 = state_58483;
(statearr_58534[(10)] = inst_58328__$1);

(statearr_58534[(20)] = inst_58330__$1);

(statearr_58534[(18)] = inst_58329);

(statearr_58534[(7)] = inst_58327__$1);

return statearr_58534;
})();
if(cljs.core.truth_(inst_58330__$1)){
var statearr_58535_58623 = state_58483__$1;
(statearr_58535_58623[(1)] = (6));

} else {
var statearr_58536_58624 = state_58483__$1;
(statearr_58536_58624[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (23))){
var inst_58473 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58537_58625 = state_58483__$1;
(statearr_58537_58625[(2)] = inst_58473);

(statearr_58537_58625[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (47))){
var inst_58429 = (state_58483[(23)]);
var inst_58376 = (state_58483[(8)]);
var inst_58429__$1 = inst_58376 === false;
var state_58483__$1 = (function (){var statearr_58538 = state_58483;
(statearr_58538[(23)] = inst_58429__$1);

return statearr_58538;
})();
if(cljs.core.truth_(inst_58429__$1)){
var statearr_58539_58626 = state_58483__$1;
(statearr_58539_58626[(1)] = (49));

} else {
var statearr_58540_58627 = state_58483__$1;
(statearr_58540_58627[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (35))){
var inst_58426 = (state_58483[(9)]);
var inst_58376 = (state_58483[(8)]);
var inst_58426__$1 = inst_58376 === true;
var state_58483__$1 = (function (){var statearr_58541 = state_58483;
(statearr_58541[(9)] = inst_58426__$1);

return statearr_58541;
})();
if(cljs.core.truth_(inst_58426__$1)){
var statearr_58542_58628 = state_58483__$1;
(statearr_58542_58628[(1)] = (46));

} else {
var statearr_58543_58629 = state_58483__$1;
(statearr_58543_58629[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (19))){
var inst_58376 = (state_58483[(8)]);
var inst_58380 = inst_58376 === false;
var state_58483__$1 = state_58483;
var statearr_58544_58630 = state_58483__$1;
(statearr_58544_58630[(2)] = inst_58380);

(statearr_58544_58630[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (57))){
var inst_58458 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58545_58631 = state_58483__$1;
(statearr_58545_58631[(2)] = inst_58458);

(statearr_58545_58631[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (11))){
var inst_58341 = (state_58483[(17)]);
var inst_58329 = (state_58483[(18)]);
var inst_58346 = (inst_58341.cljs$core$IFn$_invoke$arity$1 ? inst_58341.cljs$core$IFn$_invoke$arity$1(inst_58329) : inst_58341.call(null,inst_58329));
var state_58483__$1 = state_58483;
var statearr_58547_58632 = state_58483__$1;
(statearr_58547_58632[(2)] = inst_58346);

(statearr_58547_58632[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (9))){
var inst_58335 = (state_58483[(2)]);
var inst_58336 = fluree.db.util.async.throw_err(inst_58335);
var state_58483__$1 = state_58483;
var statearr_58548_58633 = state_58483__$1;
(statearr_58548_58633[(2)] = inst_58336);

(statearr_58548_58633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (5))){
var _ = (function (){var statearr_58549 = state_58483;
(statearr_58549[(4)] = cljs.core.rest((state_58483[(4)])));

return statearr_58549;
})();
var state_58483__$1 = state_58483;
var ex58546 = (state_58483__$1[(2)]);
var statearr_58550_58634 = state_58483__$1;
(statearr_58550_58634[(5)] = ex58546);


if((ex58546 instanceof Error)){
var statearr_58551_58635 = state_58483__$1;
(statearr_58551_58635[(1)] = (4));

(statearr_58551_58635[(5)] = null);

} else {
throw ex58546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (14))){
var state_58483__$1 = state_58483;
var statearr_58552_58636 = state_58483__$1;
(statearr_58552_58636[(2)] = null);

(statearr_58552_58636[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (45))){
var inst_58420 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58553_58637 = state_58483__$1;
(statearr_58553_58637[(2)] = inst_58420);

(statearr_58553_58637[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (53))){
var inst_58376 = (state_58483[(8)]);
var inst_58439 = cljs.core.vector_QMARK_(inst_58376);
var state_58483__$1 = state_58483;
if(inst_58439){
var statearr_58554_58638 = state_58483__$1;
(statearr_58554_58638[(1)] = (55));

} else {
var statearr_58555_58639 = state_58483__$1;
(statearr_58555_58639[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (26))){
var inst_58377 = (state_58483[(24)]);
var inst_58370 = (state_58483[(15)]);
var inst_58468 = (state_58483[(2)]);
var inst_58469 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_58370,inst_58468);
var inst_58369 = inst_58377;
var inst_58370__$1 = inst_58469;
var state_58483__$1 = (function (){var statearr_58556 = state_58483;
(statearr_58556[(11)] = inst_58369);

(statearr_58556[(15)] = inst_58370__$1);

return statearr_58556;
})();
var statearr_58557_58640 = state_58483__$1;
(statearr_58557_58640[(2)] = null);

(statearr_58557_58640[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (16))){
var inst_58369 = (state_58483[(11)]);
var inst_58376 = (state_58483[(8)]);
var inst_58375 = cljs.core.seq(inst_58369);
var inst_58376__$1 = cljs.core.first(inst_58375);
var inst_58377 = cljs.core.next(inst_58375);
var state_58483__$1 = (function (){var statearr_58558 = state_58483;
(statearr_58558[(24)] = inst_58377);

(statearr_58558[(8)] = inst_58376__$1);

return statearr_58558;
})();
if(cljs.core.truth_(inst_58376__$1)){
var statearr_58559_58641 = state_58483__$1;
(statearr_58559_58641[(1)] = (18));

} else {
var statearr_58560_58642 = state_58483__$1;
(statearr_58560_58642[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (38))){
var inst_58369 = (state_58483[(11)]);
var inst_58399 = (state_58483[(21)]);
var inst_58406 = (state_58483[(16)]);
var inst_58367 = (state_58483[(12)]);
var inst_58328 = (state_58483[(10)]);
var inst_58338 = (state_58483[(25)]);
var inst_58377 = (state_58483[(24)]);
var inst_58341 = (state_58483[(17)]);
var inst_58339 = (state_58483[(26)]);
var inst_58342 = (state_58483[(27)]);
var inst_58329 = (state_58483[(18)]);
var inst_58357 = (state_58483[(13)]);
var inst_58340 = (state_58483[(22)]);
var inst_58343 = (state_58483[(28)]);
var inst_58327 = (state_58483[(7)]);
var inst_58366 = (state_58483[(14)]);
var inst_58376 = (state_58483[(8)]);
var inst_58370 = (state_58483[(15)]);
var inst_58402 = [inst_58376];
var inst_58403 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_58402);
var inst_58404 = (function (){var arity = inst_58341;
var args_n = inst_58329;
var fn_map = inst_58338;
var map__58326 = inst_58339;
var or__5045__auto__ = inst_58399;
var args = inst_58328;
var G__58361 = inst_58369;
var r = inst_58377;
var vec__58372 = inst_58369;
var first__58374 = inst_58376;
var seq__58373 = inst_58377;
var _ = inst_58357;
var acc = inst_58370;
var arglist = inst_58342;
var seq__58363 = inst_58367;
var fn_name = inst_58327;
var _AMPERSAND_args_QMARK_ = inst_58343;
var arg = inst_58376;
var first__58364 = inst_58366;
var vec__58362 = inst_58328;
var f = inst_58340;
return (function (p1__58317_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__58317_SHARP_);
});
})();
var inst_58405 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_58404,params);
var inst_58406__$1 = cljs.core.some(inst_58403,inst_58405);
var state_58483__$1 = (function (){var statearr_58561 = state_58483;
(statearr_58561[(16)] = inst_58406__$1);

return statearr_58561;
})();
if(cljs.core.truth_(inst_58406__$1)){
var statearr_58562_58643 = state_58483__$1;
(statearr_58562_58643[(1)] = (40));

} else {
var statearr_58563_58644 = state_58483__$1;
(statearr_58563_58644[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (30))){
var inst_58466 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58564_58645 = state_58483__$1;
(statearr_58564_58645[(2)] = inst_58466);

(statearr_58564_58645[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (10))){
var inst_58343 = (state_58483[(28)]);
var state_58483__$1 = state_58483;
var statearr_58565_58646 = state_58483__$1;
(statearr_58565_58646[(2)] = inst_58343);

(statearr_58565_58646[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (18))){
var inst_58376 = (state_58483[(8)]);
var state_58483__$1 = state_58483;
var statearr_58566_58647 = state_58483__$1;
(statearr_58566_58647[(2)] = inst_58376);

(statearr_58566_58647[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (52))){
var inst_58376 = (state_58483[(8)]);
var state_58483__$1 = state_58483;
var statearr_58567_58648 = state_58483__$1;
(statearr_58567_58648[(2)] = inst_58376);

(statearr_58567_58648[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (42))){
var inst_58422 = (state_58483[(2)]);
var state_58483__$1 = state_58483;
var statearr_58568_58649 = state_58483__$1;
(statearr_58568_58649[(2)] = inst_58422);

(statearr_58568_58649[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (37))){
var inst_58399 = (state_58483[(21)]);
var state_58483__$1 = state_58483;
var statearr_58569_58650 = state_58483__$1;
(statearr_58569_58650[(2)] = inst_58399);

(statearr_58569_58650[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (8))){
var inst_58338 = (state_58483[(25)]);
var inst_58339 = (state_58483[(26)]);
var inst_58343 = (state_58483[(28)]);
var inst_58338__$1 = (state_58483[(2)]);
var inst_58339__$1 = cljs.core.__destructure_map(inst_58338__$1);
var inst_58340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58339__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_58341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58339__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_58342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58339__$1,new cljs.core.Keyword(null,"arglist","arglist",-1808272150));
var inst_58343__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58339__$1,new cljs.core.Keyword(null,"&args?","&args?",-1736256945));
var state_58483__$1 = (function (){var statearr_58570 = state_58483;
(statearr_58570[(25)] = inst_58338__$1);

(statearr_58570[(17)] = inst_58341);

(statearr_58570[(26)] = inst_58339__$1);

(statearr_58570[(27)] = inst_58342);

(statearr_58570[(22)] = inst_58340);

(statearr_58570[(28)] = inst_58343__$1);

return statearr_58570;
})();
if(cljs.core.truth_(inst_58343__$1)){
var statearr_58571_58651 = state_58483__$1;
(statearr_58571_58651[(1)] = (10));

} else {
var statearr_58572_58652 = state_58483__$1;
(statearr_58572_58652[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58484 === (49))){
var inst_58429 = (state_58483[(23)]);
var state_58483__$1 = state_58483;
var statearr_58573_58653 = state_58483__$1;
(statearr_58573_58653[(2)] = inst_58429);

(statearr_58573_58653[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2684__auto____0 = (function (){
var statearr_58574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58574[(0)] = fluree$db$dbfunctions$core$state_machine__2684__auto__);

(statearr_58574[(1)] = (1));

return statearr_58574;
});
var fluree$db$dbfunctions$core$state_machine__2684__auto____1 = (function (state_58483){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58483);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58575){var ex__2687__auto__ = e58575;
var statearr_58576_58654 = state_58483;
(statearr_58576_58654[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58483[(4)]))){
var statearr_58577_58655 = state_58483;
(statearr_58577_58655[(1)] = cljs.core.first((state_58483[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58656 = state_58483;
state_58483 = G__58656;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2684__auto__ = function(state_58483){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2684__auto____1.call(this,state_58483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2684__auto____0;
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58578 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58578[(6)] = c__2706__auto__);

return statearr_58578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__58658 = arguments.length;
switch (G__58658) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58740){
var state_val_58741 = (state_58740[(1)]);
if((state_val_58741 === (7))){
var inst_58668 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_58740__$1 = state_58740;
var statearr_58742_58790 = state_58740__$1;
(statearr_58742_58790[(2)] = inst_58668);

(statearr_58742_58790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (20))){
var inst_58718 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_58740__$1 = state_58740;
var statearr_58743_58791 = state_58740__$1;
(statearr_58743_58791[(2)] = inst_58718);

(statearr_58743_58791[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (1))){
var state_58740__$1 = state_58740;
var statearr_58744_58792 = state_58740__$1;
(statearr_58744_58792[(2)] = null);

(statearr_58744_58792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (24))){
var inst_58715 = (state_58740[(7)]);
var inst_58724 = cljs.core.eval(inst_58715);
var state_58740__$1 = state_58740;
var statearr_58746_58793 = state_58740__$1;
(statearr_58746_58793[(2)] = inst_58724);

(statearr_58746_58793[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (4))){
var inst_58659 = (state_58740[(2)]);
var state_58740__$1 = state_58740;
var statearr_58747_58794 = state_58740__$1;
(statearr_58747_58794[(2)] = inst_58659);

(statearr_58747_58794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (15))){
var _ = (function (){var statearr_58748 = state_58740;
(statearr_58748[(4)] = cljs.core.rest((state_58740[(4)])));

return statearr_58748;
})();
var state_58740__$1 = state_58740;
var ex58745 = (state_58740__$1[(2)]);
var statearr_58749_58795 = state_58740__$1;
(statearr_58749_58795[(5)] = ex58745);


var statearr_58750_58796 = state_58740__$1;
(statearr_58750_58796[(1)] = (14));

(statearr_58750_58796[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (21))){
var inst_58716 = (state_58740[(8)]);
var state_58740__$1 = state_58740;
var statearr_58751_58797 = state_58740__$1;
(statearr_58751_58797[(2)] = inst_58716);

(statearr_58751_58797[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (13))){
var inst_58733 = (state_58740[(2)]);
var state_58740__$1 = state_58740;
var statearr_58752_58798 = state_58740__$1;
(statearr_58752_58798[(2)] = inst_58733);

(statearr_58752_58798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (22))){
var inst_58721 = (state_58740[(2)]);
var state_58740__$1 = state_58740;
if(cljs.core.truth_(inst_58721)){
var statearr_58753_58799 = state_58740__$1;
(statearr_58753_58799[(1)] = (23));

} else {
var statearr_58754_58800 = state_58740__$1;
(statearr_58754_58800[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (6))){
var inst_58665 = (state_58740[(9)]);
var state_58740__$1 = state_58740;
var statearr_58755_58801 = state_58740__$1;
(statearr_58755_58801[(2)] = inst_58665);

(statearr_58755_58801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (25))){
var inst_58726 = (state_58740[(2)]);
var inst_58727 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_58728 = [fn_str];
var inst_58729 = cljs.core.PersistentHashMap.fromArrays(inst_58727,inst_58728);
var inst_58730 = cljs.core.with_meta(inst_58726,inst_58729);
var _ = (function (){var statearr_58756 = state_58740;
(statearr_58756[(4)] = cljs.core.rest((state_58740[(4)])));

return statearr_58756;
})();
var state_58740__$1 = state_58740;
var statearr_58757_58802 = state_58740__$1;
(statearr_58757_58802[(2)] = inst_58730);

(statearr_58757_58802[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (17))){
var inst_58691 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58692 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_58693 = cljs.core.PersistentHashMap.fromArrays(inst_58691,inst_58692);
var inst_58694 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_58693);
var inst_58695 = (function(){throw inst_58694})();
var state_58740__$1 = state_58740;
var statearr_58758_58803 = state_58740__$1;
(statearr_58758_58803[(2)] = inst_58695);

(statearr_58758_58803[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (3))){
var inst_58738 = (state_58740[(2)]);
var state_58740__$1 = state_58740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58740__$1,inst_58738);
} else {
if((state_val_58741 === (12))){
var _ = (function (){var statearr_58759 = state_58740;
(statearr_58759[(4)] = cljs.core.cons((15),(state_58740[(4)])));

return statearr_58759;
})();
var inst_58688 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_58740__$1 = state_58740;
if(cljs.core.truth_(inst_58688)){
var statearr_58760_58804 = state_58740__$1;
(statearr_58760_58804[(1)] = (16));

} else {
var statearr_58761_58805 = state_58740__$1;
(statearr_58761_58805[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (2))){
var inst_58665 = (state_58740[(9)]);
var _ = (function (){var statearr_58762 = state_58740;
(statearr_58762[(4)] = cljs.core.cons((5),(state_58740[(4)])));

return statearr_58762;
})();
var inst_58665__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_58740__$1 = (function (){var statearr_58763 = state_58740;
(statearr_58763[(9)] = inst_58665__$1);

return statearr_58763;
})();
if(inst_58665__$1){
var statearr_58764_58806 = state_58740__$1;
(statearr_58764_58806[(1)] = (6));

} else {
var statearr_58765_58807 = state_58740__$1;
(statearr_58765_58807[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (23))){
var inst_58715 = (state_58740[(7)]);
var state_58740__$1 = state_58740;
var statearr_58766_58808 = state_58740__$1;
(statearr_58766_58808[(2)] = inst_58715);

(statearr_58766_58808[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (19))){
var inst_58716 = (state_58740[(8)]);
var inst_58701 = (state_58740[(2)]);
var inst_58702 = fluree.db.util.async.throw_err(inst_58701);
var inst_58703 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_58704 = (new cljs.core.List(null,inst_58703,null,(1),null));
var inst_58705 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_58706 = (new cljs.core.List(null,inst_58705,null,(1),null));
var inst_58707 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_58706);
var inst_58708 = cljs.core.seq(inst_58707);
var inst_58709 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_58708);
var inst_58710 = cljs.core.vec(inst_58709);
var inst_58711 = (new cljs.core.List(null,inst_58710,null,(1),null));
var inst_58712 = (new cljs.core.List(null,inst_58702,null,(1),null));
var inst_58713 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_58704,inst_58711,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_58712], 0));
var inst_58714 = cljs.core.seq(inst_58713);
var inst_58715 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_58714);
var inst_58716__$1 = params;
var state_58740__$1 = (function (){var statearr_58767 = state_58740;
(statearr_58767[(8)] = inst_58716__$1);

(statearr_58767[(7)] = inst_58715);

return statearr_58767;
})();
if(cljs.core.truth_(inst_58716__$1)){
var statearr_58768_58809 = state_58740__$1;
(statearr_58768_58809[(1)] = (20));

} else {
var statearr_58769_58810 = state_58740__$1;
(statearr_58769_58810[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (11))){
var inst_58735 = (state_58740[(2)]);
var _ = (function (){var statearr_58771 = state_58740;
(statearr_58771[(4)] = cljs.core.rest((state_58740[(4)])));

return statearr_58771;
})();
var state_58740__$1 = state_58740;
var statearr_58772_58811 = state_58740__$1;
(statearr_58772_58811[(2)] = inst_58735);

(statearr_58772_58811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (9))){
var inst_58672 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_58673 = fluree.db.dbfunctions.core.true_or_false = inst_58672;
var state_58740__$1 = state_58740;
var statearr_58773_58812 = state_58740__$1;
(statearr_58773_58812[(2)] = inst_58673);

(statearr_58773_58812[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (5))){
var _ = (function (){var statearr_58774 = state_58740;
(statearr_58774[(4)] = cljs.core.rest((state_58740[(4)])));

return statearr_58774;
})();
var state_58740__$1 = state_58740;
var ex58770 = (state_58740__$1[(2)]);
var statearr_58775_58813 = state_58740__$1;
(statearr_58775_58813[(5)] = ex58770);


if((ex58770 instanceof Error)){
var statearr_58776_58814 = state_58740__$1;
(statearr_58776_58814[(1)] = (4));

(statearr_58776_58814[(5)] = null);

} else {
throw ex58770;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (14))){
var inst_58675 = (state_58740[(2)]);
var inst_58676 = (function(){throw inst_58675})();
var inst_58677 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_58678 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58679 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_58680 = cljs.core.PersistentHashMap.fromArrays(inst_58678,inst_58679);
var inst_58681 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_58677,inst_58680);
var inst_58682 = (function(){throw inst_58681})();
var state_58740__$1 = (function (){var statearr_58777 = state_58740;
(statearr_58777[(10)] = inst_58676);

return statearr_58777;
})();
var statearr_58778_58815 = state_58740__$1;
(statearr_58778_58815[(2)] = inst_58682);

(statearr_58778_58815[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (16))){
var state_58740__$1 = state_58740;
var statearr_58779_58816 = state_58740__$1;
(statearr_58779_58816[(2)] = null);

(statearr_58779_58816[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (10))){
var state_58740__$1 = state_58740;
var statearr_58780_58817 = state_58740__$1;
(statearr_58780_58817[(2)] = null);

(statearr_58780_58817[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58741 === (18))){
var inst_58697 = (state_58740[(2)]);
var inst_58698 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_58699 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_58698,type,params);
var state_58740__$1 = (function (){var statearr_58781 = state_58740;
(statearr_58781[(11)] = inst_58697);

return statearr_58781;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58740__$1,(19),inst_58699);
} else {
if((state_val_58741 === (8))){
var inst_58670 = (state_58740[(2)]);
var state_58740__$1 = state_58740;
if(cljs.core.truth_(inst_58670)){
var statearr_58782_58818 = state_58740__$1;
(statearr_58782_58818[(1)] = (9));

} else {
var statearr_58783_58819 = state_58740__$1;
(statearr_58783_58819[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2684__auto____0 = (function (){
var statearr_58784 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58784[(0)] = fluree$db$dbfunctions$core$state_machine__2684__auto__);

(statearr_58784[(1)] = (1));

return statearr_58784;
});
var fluree$db$dbfunctions$core$state_machine__2684__auto____1 = (function (state_58740){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58740);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58785){var ex__2687__auto__ = e58785;
var statearr_58786_58820 = state_58740;
(statearr_58786_58820[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58740[(4)]))){
var statearr_58787_58821 = state_58740;
(statearr_58787_58821[(1)] = cljs.core.first((state_58740[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58822 = state_58740;
state_58740 = G__58822;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2684__auto__ = function(state_58740){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2684__auto____1.call(this,state_58740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2684__auto____0;
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58788 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58788[(6)] = c__2706__auto__);

return statearr_58788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58850){
var state_val_58851 = (state_58850[(1)]);
if((state_val_58851 === (7))){
var inst_58837 = (state_58850[(7)]);
var state_58850__$1 = state_58850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58850__$1,(10),inst_58837);
} else {
if((state_val_58851 === (1))){
var state_58850__$1 = state_58850;
var statearr_58852_58872 = state_58850__$1;
(statearr_58852_58872[(2)] = null);

(statearr_58852_58872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58851 === (4))){
var inst_58823 = (state_58850[(2)]);
var state_58850__$1 = state_58850;
var statearr_58853_58873 = state_58850__$1;
(statearr_58853_58873[(2)] = inst_58823);

(statearr_58853_58873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58851 === (6))){
var inst_58832 = (state_58850[(8)]);
var inst_58837 = (state_58850[(7)]);
var inst_58835 = (state_58850[(2)]);
var inst_58836 = fluree.db.util.async.throw_err(inst_58835);
var inst_58837__$1 = (inst_58836.cljs$core$IFn$_invoke$arity$1 ? inst_58836.cljs$core$IFn$_invoke$arity$1(inst_58832) : inst_58836.call(null,inst_58832));
var inst_58838 = fluree.db.util.async.channel_QMARK_(inst_58837__$1);
var state_58850__$1 = (function (){var statearr_58854 = state_58850;
(statearr_58854[(7)] = inst_58837__$1);

return statearr_58854;
})();
if(inst_58838){
var statearr_58855_58874 = state_58850__$1;
(statearr_58855_58874[(1)] = (7));

} else {
var statearr_58856_58875 = state_58850__$1;
(statearr_58856_58875[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58851 === (3))){
var inst_58848 = (state_58850[(2)]);
var state_58850__$1 = state_58850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58850__$1,inst_58848);
} else {
if((state_val_58851 === (2))){
var _ = (function (){var statearr_58858 = state_58850;
(statearr_58858[(4)] = cljs.core.cons((5),(state_58850[(4)])));

return statearr_58858;
})();
var inst_58829 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_58830 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_58831 = [db,block_instant,s,p,auth_id,fuel];
var inst_58832 = cljs.core.PersistentHashMap.fromArrays(inst_58830,inst_58831);
var inst_58833 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_58829,"txn",null);
var state_58850__$1 = (function (){var statearr_58859 = state_58850;
(statearr_58859[(8)] = inst_58832);

return statearr_58859;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58850__$1,(6),inst_58833);
} else {
if((state_val_58851 === (9))){
var inst_58845 = (state_58850[(2)]);
var _ = (function (){var statearr_58860 = state_58850;
(statearr_58860[(4)] = cljs.core.rest((state_58850[(4)])));

return statearr_58860;
})();
var state_58850__$1 = state_58850;
var statearr_58861_58876 = state_58850__$1;
(statearr_58861_58876[(2)] = inst_58845);

(statearr_58861_58876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58851 === (5))){
var _ = (function (){var statearr_58862 = state_58850;
(statearr_58862[(4)] = cljs.core.rest((state_58850[(4)])));

return statearr_58862;
})();
var state_58850__$1 = state_58850;
var ex58857 = (state_58850__$1[(2)]);
var statearr_58863_58877 = state_58850__$1;
(statearr_58863_58877[(5)] = ex58857);


if((ex58857 instanceof Error)){
var statearr_58864_58878 = state_58850__$1;
(statearr_58864_58878[(1)] = (4));

(statearr_58864_58878[(5)] = null);

} else {
throw ex58857;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58851 === (10))){
var inst_58841 = (state_58850[(2)]);
var inst_58842 = fluree.db.util.async.throw_err(inst_58841);
var state_58850__$1 = state_58850;
var statearr_58865_58879 = state_58850__$1;
(statearr_58865_58879[(2)] = inst_58842);

(statearr_58865_58879[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58851 === (8))){
var inst_58837 = (state_58850[(7)]);
var state_58850__$1 = state_58850;
var statearr_58866_58880 = state_58850__$1;
(statearr_58866_58880[(2)] = inst_58837);

(statearr_58866_58880[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_58867 = [null,null,null,null,null,null,null,null,null];
(statearr_58867[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__);

(statearr_58867[(1)] = (1));

return statearr_58867;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____1 = (function (state_58850){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58850);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58868){var ex__2687__auto__ = e58868;
var statearr_58869_58881 = state_58850;
(statearr_58869_58881[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58850[(4)]))){
var statearr_58870_58882 = state_58850;
(statearr_58870_58882[(1)] = cljs.core.first((state_58850[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58883 = state_58850;
state_58850 = G__58883;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__ = function(state_58850){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____1.call(this,state_58850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58871 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58871[(6)] = c__2706__auto__);

return statearr_58871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
