// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__27356 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27356,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27356,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27356,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__27359){
var map__27360 = p__27359;
var map__27360__$1 = cljs.core.__destructure_map(map__27360);
var opts = map__27360__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27360__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27420){
var state_val_27421 = (state_27420[(1)]);
if((state_val_27421 === (7))){
var inst_27391 = cljs.core.not(reindex_QMARK_);
var state_27420__$1 = state_27420;
var statearr_27422_27446 = state_27420__$1;
(statearr_27422_27446[(2)] = inst_27391);

(statearr_27422_27446[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (1))){
var state_27420__$1 = state_27420;
var statearr_27423_27447 = state_27420__$1;
(statearr_27423_27447[(2)] = null);

(statearr_27423_27447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (4))){
var inst_27361 = (state_27420[(2)]);
var state_27420__$1 = state_27420;
var statearr_27424_27448 = state_27420__$1;
(statearr_27424_27448[(2)] = inst_27361);

(statearr_27424_27448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (6))){
var inst_27381 = (state_27420[(7)]);
var inst_27375 = (state_27420[(8)]);
var inst_27389 = (state_27420[(9)]);
var inst_27374 = (state_27420[(2)]);
var inst_27375__$1 = fluree.db.util.async.throw_err(inst_27374);
var inst_27376 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_27377 = cljs.core.__destructure_map(inst_27376);
var inst_27378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27377,new cljs.core.Keyword(null,"post","post",269697687));
var inst_27379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27377,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_27380 = fluree.db.flake.size_bytes(inst_27375__$1);
var inst_27381__$1 = (inst_27379 + inst_27380);
var inst_27382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27383 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_27384 = (new cljs.core.PersistentVector(null,2,(5),inst_27382,inst_27383,null));
var inst_27385 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27384);
var inst_27386 = cljs.core.__destructure_map(inst_27385);
var inst_27387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27386,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_27388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27386,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_27389__$1 = (inst_27381__$1 > inst_27388);
var state_27420__$1 = (function (){var statearr_27425 = state_27420;
(statearr_27425[(7)] = inst_27381__$1);

(statearr_27425[(8)] = inst_27375__$1);

(statearr_27425[(10)] = inst_27387);

(statearr_27425[(9)] = inst_27389__$1);

(statearr_27425[(11)] = inst_27378);

return statearr_27425;
})();
if(cljs.core.truth_(inst_27389__$1)){
var statearr_27426_27449 = state_27420__$1;
(statearr_27426_27449[(1)] = (7));

} else {
var statearr_27427_27450 = state_27420__$1;
(statearr_27427_27450[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (3))){
var inst_27418 = (state_27420[(2)]);
var state_27420__$1 = state_27420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27420__$1,inst_27418);
} else {
if((state_val_27421 === (12))){
var inst_27381 = (state_27420[(7)]);
var inst_27375 = (state_27420[(8)]);
var inst_27378 = (state_27420[(11)]);
var inst_27404 = (state_27420[(2)]);
var inst_27405 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27378,inst_27375);
var inst_27406 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_27407 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27406,cljs.core.empty);
var inst_27408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27409 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27410 = (new cljs.core.PersistentVector(null,2,(5),inst_27408,inst_27409,null));
var inst_27411 = cljs.core.assoc_in(db,inst_27410,inst_27405);
var inst_27412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27413 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27414 = (new cljs.core.PersistentVector(null,2,(5),inst_27412,inst_27413,null));
var inst_27415 = cljs.core.assoc_in(inst_27411,inst_27414,inst_27381);
var _ = (function (){var statearr_27428 = state_27420;
(statearr_27428[(4)] = cljs.core.rest((state_27420[(4)])));

return statearr_27428;
})();
var state_27420__$1 = (function (){var statearr_27429 = state_27420;
(statearr_27429[(12)] = inst_27407);

(statearr_27429[(13)] = inst_27404);

return statearr_27429;
})();
var statearr_27430_27451 = state_27420__$1;
(statearr_27430_27451[(2)] = inst_27415);

(statearr_27430_27451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (2))){
var _ = (function (){var statearr_27431 = state_27420;
(statearr_27431[(4)] = cljs.core.cons((5),(state_27420[(4)])));

return statearr_27431;
})();
var inst_27369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27370 = [pred_id];
var inst_27371 = (new cljs.core.PersistentVector(null,1,(5),inst_27369,inst_27370,null));
var inst_27372 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_27371);
var state_27420__$1 = state_27420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27420__$1,(6),inst_27372);
} else {
if((state_val_27421 === (11))){
var state_27420__$1 = state_27420;
var statearr_27433_27452 = state_27420__$1;
(statearr_27433_27452[(2)] = null);

(statearr_27433_27452[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (9))){
var inst_27394 = (state_27420[(2)]);
var state_27420__$1 = state_27420;
if(cljs.core.truth_(inst_27394)){
var statearr_27434_27453 = state_27420__$1;
(statearr_27434_27453[(1)] = (10));

} else {
var statearr_27435_27454 = state_27420__$1;
(statearr_27435_27454[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (5))){
var _ = (function (){var statearr_27436 = state_27420;
(statearr_27436[(4)] = cljs.core.rest((state_27420[(4)])));

return statearr_27436;
})();
var state_27420__$1 = state_27420;
var ex27432 = (state_27420__$1[(2)]);
var statearr_27437_27455 = state_27420__$1;
(statearr_27437_27455[(5)] = ex27432);


if((ex27432 instanceof Error)){
var statearr_27438_27456 = state_27420__$1;
(statearr_27438_27456[(1)] = (4));

(statearr_27438_27456[(5)] = null);

} else {
throw ex27432;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (10))){
var inst_27396 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_27397 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_27398 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_27399 = cljs.core.PersistentHashMap.fromArrays(inst_27397,inst_27398);
var inst_27400 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27396,inst_27399);
var inst_27401 = (function(){throw inst_27400})();
var state_27420__$1 = state_27420;
var statearr_27439_27457 = state_27420__$1;
(statearr_27439_27457[(2)] = inst_27401);

(statearr_27439_27457[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27421 === (8))){
var inst_27389 = (state_27420[(9)]);
var state_27420__$1 = state_27420;
var statearr_27440_27458 = state_27420__$1;
(statearr_27440_27458[(2)] = inst_27389);

(statearr_27440_27458[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0 = (function (){
var statearr_27441 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27441[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__);

(statearr_27441[(1)] = (1));

return statearr_27441;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1 = (function (state_27420){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27420);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27442){var ex__2687__auto__ = e27442;
var statearr_27443_27459 = state_27420;
(statearr_27443_27459[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27420[(4)]))){
var statearr_27444_27460 = state_27420;
(statearr_27444_27460[(1)] = cljs.core.first((state_27420[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27461 = state_27420;
state_27420 = G__27461;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = function(state_27420){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1.call(this,state_27420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27445 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27445[(6)] = c__2706__auto__);

return statearr_27445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__27466 = arguments.length;
switch (G__27466) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27662){
var state_val_27663 = (state_27662[(1)]);
if((state_val_27663 === (7))){
var state_27662__$1 = state_27662;
var statearr_27664_27732 = state_27662__$1;
(statearr_27664_27732[(2)] = null);

(statearr_27664_27732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (20))){
var inst_27587 = (state_27662[(7)]);
var inst_27588 = (state_27662[(8)]);
var inst_27555 = (state_27662[(9)]);
var inst_27586 = (state_27662[(10)]);
var inst_27504 = (state_27662[(11)]);
var inst_27584 = (state_27662[(12)]);
var inst_27585 = (state_27662[(13)]);
var inst_27505 = (state_27662[(14)]);
var inst_27598 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27600 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27601 = (new cljs.core.PersistentVector(null,2,(5),inst_27599,inst_27600,null));
var inst_27602 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27555,inst_27601);
var inst_27603 = (inst_27504 + inst_27602);
var inst_27604 = [inst_27584,inst_27585,inst_27586,inst_27587,inst_27603];
var inst_27605 = cljs.core.PersistentHashMap.fromArrays(inst_27598,inst_27604);
var inst_27606 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_27555,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_27588,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_27605], 0));
var state_27662__$1 = (function (){var statearr_27665 = state_27662;
(statearr_27665[(15)] = inst_27606);

return statearr_27665;
})();
if(cljs.core.truth_(inst_27505)){
var statearr_27666_27733 = state_27662__$1;
(statearr_27666_27733[(1)] = (23));

} else {
var statearr_27667_27734 = state_27662__$1;
(statearr_27667_27734[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (27))){
var inst_27606 = (state_27662[(15)]);
var state_27662__$1 = state_27662;
var statearr_27668_27735 = state_27662__$1;
(statearr_27668_27735[(2)] = inst_27606);

(statearr_27668_27735[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (1))){
var state_27662__$1 = state_27662;
var statearr_27669_27736 = state_27662__$1;
(statearr_27669_27736[(2)] = null);

(statearr_27669_27736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (24))){
var inst_27606 = (state_27662[(15)]);
var inst_27609 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_27606);
var inst_27610 = (inst_27609 == null);
var state_27662__$1 = state_27662;
var statearr_27670_27737 = state_27662__$1;
(statearr_27670_27737[(2)] = inst_27610);

(statearr_27670_27737[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (39))){
var inst_27636 = (state_27662[(16)]);
var inst_27595 = (state_27662[(17)]);
var inst_27638 = (state_27662[(18)]);
var inst_27637 = (state_27662[(19)]);
var inst_27645 = (state_27662[(20)]);
var inst_27652 = (state_27662[(2)]);
var inst_27583 = inst_27595;
var inst_27584 = inst_27637;
var inst_27585 = inst_27638;
var inst_27586 = inst_27645;
var inst_27587 = inst_27652;
var inst_27588 = inst_27636;
var state_27662__$1 = (function (){var statearr_27671 = state_27662;
(statearr_27671[(7)] = inst_27587);

(statearr_27671[(8)] = inst_27588);

(statearr_27671[(10)] = inst_27586);

(statearr_27671[(21)] = inst_27583);

(statearr_27671[(12)] = inst_27584);

(statearr_27671[(13)] = inst_27585);

return statearr_27671;
})();
var statearr_27672_27738 = state_27662__$1;
(statearr_27672_27738[(2)] = null);

(statearr_27672_27738[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (4))){
var inst_27467 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27673_27739 = state_27662__$1;
(statearr_27673_27739[(2)] = inst_27467);

(statearr_27673_27739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (15))){
var inst_27527 = (state_27662[(22)]);
var state_27662__$1 = state_27662;
var statearr_27674_27740 = state_27662__$1;
(statearr_27674_27740[(2)] = inst_27527);

(statearr_27674_27740[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (21))){
var inst_27587 = (state_27662[(7)]);
var inst_27588 = (state_27662[(8)]);
var inst_27474 = (state_27662[(23)]);
var inst_27503 = (state_27662[(24)]);
var inst_27499 = (state_27662[(25)]);
var inst_27506 = (state_27662[(26)]);
var inst_27514 = (state_27662[(27)]);
var inst_27555 = (state_27662[(9)]);
var inst_27586 = (state_27662[(10)]);
var inst_27583 = (state_27662[(21)]);
var inst_27491 = (state_27662[(28)]);
var inst_27564 = (state_27662[(29)]);
var inst_27504 = (state_27662[(11)]);
var inst_27584 = (state_27662[(12)]);
var inst_27489 = (state_27662[(30)]);
var inst_27594 = (state_27662[(31)]);
var inst_27508 = (state_27662[(32)]);
var inst_27495 = (state_27662[(33)]);
var inst_27565 = (state_27662[(34)]);
var inst_27585 = (state_27662[(13)]);
var inst_27505 = (state_27662[(14)]);
var inst_27595 = (state_27662[(17)]);
var inst_27633 = inst_27594.s;
var inst_27634 = fluree.db.flake.sid__GT_cid(inst_27633);
var inst_27635 = (function (){var flakes_bytes = inst_27504;
var t = inst_27474;
var first__27562 = inst_27564;
var spot = inst_27584;
var add_flakes = inst_27491;
var root_setting_change_QMARK_ = inst_27506;
var ref_QMARK__map = inst_27503;
var r = inst_27595;
var psot = inst_27585;
var vec__27590 = inst_27583;
var add_pred_to_idx_QMARK_ = inst_27514;
var seq__27591 = inst_27595;
var _ = inst_27489;
var seq__27561 = inst_27565;
var first__27592 = inst_27594;
var cid = inst_27634;
var ecount = inst_27588;
var pred_ecount = inst_27508;
var db_STAR_ = inst_27555;
var schema_change_QMARK_ = inst_27505;
var add_preds = inst_27495;
var vec__27560 = inst_27491;
var opst = inst_27587;
var idx_QMARK__map = inst_27499;
var post = inst_27586;
var G__27559 = inst_27583;
var f = inst_27594;
return (function (p1__27464_SHARP_){
if(cljs.core.truth_(p1__27464_SHARP_)){
var x__5130__auto__ = p1__27464_SHARP_;
var y__5131__auto__ = f.s;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return f.s;
}
});
})();
var inst_27636 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_27588,inst_27634,inst_27635);
var inst_27637 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27584,inst_27594);
var inst_27638 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27585,inst_27594);
var inst_27639 = inst_27594.p;
var inst_27640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27499,inst_27639);
var state_27662__$1 = (function (){var statearr_27675 = state_27662;
(statearr_27675[(16)] = inst_27636);

(statearr_27675[(18)] = inst_27638);

(statearr_27675[(19)] = inst_27637);

return statearr_27675;
})();
if(cljs.core.truth_(inst_27640)){
var statearr_27676_27741 = state_27662__$1;
(statearr_27676_27741[(1)] = (34));

} else {
var statearr_27677_27742 = state_27662__$1;
(statearr_27677_27742[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (31))){
var inst_27621 = (state_27662[(35)]);
var state_27662__$1 = state_27662;
var statearr_27678_27743 = state_27662__$1;
(statearr_27678_27743[(2)] = inst_27621);

(statearr_27678_27743[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (32))){
var inst_27631 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27679_27744 = state_27662__$1;
(statearr_27679_27744[(2)] = inst_27631);

(statearr_27679_27744[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (33))){
var inst_27621 = (state_27662[(35)]);
var inst_27626 = (state_27662[(2)]);
var inst_27627 = fluree.db.util.async.throw_err(inst_27626);
var inst_27628 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27621,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27627);
var state_27662__$1 = state_27662;
var statearr_27680_27745 = state_27662__$1;
(statearr_27680_27745[(2)] = inst_27628);

(statearr_27680_27745[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (13))){
var inst_27474 = (state_27662[(23)]);
var inst_27555 = (state_27662[(9)]);
var inst_27491 = (state_27662[(28)]);
var inst_27504 = (state_27662[(11)]);
var inst_27545 = (state_27662[(2)]);
var inst_27546 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27545,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27474);
var inst_27547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27548 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27549 = (new cljs.core.PersistentVector(null,2,(5),inst_27547,inst_27548,null));
var inst_27550 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_27546,inst_27549,cljs.core._PLUS_,inst_27504);
var inst_27551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27552 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_27553 = (new cljs.core.PersistentVector(null,2,(5),inst_27551,inst_27552,null));
var inst_27554 = cljs.core.count(inst_27491);
var inst_27555__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_27550,inst_27553,cljs.core._PLUS_,inst_27554);
var inst_27563 = cljs.core.seq(inst_27491);
var inst_27564 = cljs.core.first(inst_27563);
var inst_27565 = cljs.core.next(inst_27563);
var inst_27566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27567 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_27568 = (new cljs.core.PersistentVector(null,2,(5),inst_27566,inst_27567,null));
var inst_27569 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27555__$1,inst_27568);
var inst_27570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27571 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_27572 = (new cljs.core.PersistentVector(null,2,(5),inst_27570,inst_27571,null));
var inst_27573 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27555__$1,inst_27572);
var inst_27574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27575 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27576 = (new cljs.core.PersistentVector(null,2,(5),inst_27574,inst_27575,null));
var inst_27577 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27555__$1,inst_27576);
var inst_27578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27579 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27580 = (new cljs.core.PersistentVector(null,2,(5),inst_27578,inst_27579,null));
var inst_27581 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27555__$1,inst_27580);
var inst_27582 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27583 = inst_27491;
var inst_27584 = inst_27569;
var inst_27585 = inst_27573;
var inst_27586 = inst_27577;
var inst_27587 = inst_27581;
var inst_27588 = inst_27582;
var state_27662__$1 = (function (){var statearr_27681 = state_27662;
(statearr_27681[(7)] = inst_27587);

(statearr_27681[(8)] = inst_27588);

(statearr_27681[(9)] = inst_27555__$1);

(statearr_27681[(10)] = inst_27586);

(statearr_27681[(21)] = inst_27583);

(statearr_27681[(29)] = inst_27564);

(statearr_27681[(12)] = inst_27584);

(statearr_27681[(34)] = inst_27565);

(statearr_27681[(13)] = inst_27585);

return statearr_27681;
})();
var statearr_27682_27746 = state_27662__$1;
(statearr_27682_27746[(2)] = null);

(statearr_27682_27746[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (22))){
var inst_27655 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27683_27747 = state_27662__$1;
(statearr_27683_27747[(2)] = inst_27655);

(statearr_27683_27747[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (36))){
var inst_27503 = (state_27662[(24)]);
var inst_27594 = (state_27662[(31)]);
var inst_27645 = (state_27662[(2)]);
var inst_27646 = inst_27594.p;
var inst_27647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27503,inst_27646);
var state_27662__$1 = (function (){var statearr_27684 = state_27662;
(statearr_27684[(20)] = inst_27645);

return statearr_27684;
})();
if(cljs.core.truth_(inst_27647)){
var statearr_27685_27748 = state_27662__$1;
(statearr_27685_27748[(1)] = (37));

} else {
var statearr_27686_27749 = state_27662__$1;
(statearr_27686_27749[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (29))){
var inst_27606 = (state_27662[(15)]);
var inst_27616 = (state_27662[(2)]);
var inst_27617 = fluree.db.util.async.throw_err(inst_27616);
var inst_27618 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27606,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27617);
var state_27662__$1 = state_27662;
var statearr_27687_27750 = state_27662__$1;
(statearr_27687_27750[(2)] = inst_27618);

(statearr_27687_27750[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (6))){
var inst_27474 = (state_27662[(23)]);
var inst_27479 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27480 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27481 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27479)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27480)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27474),"."].join('');
var inst_27482 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27483 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27484 = cljs.core.PersistentHashMap.fromArrays(inst_27482,inst_27483);
var inst_27485 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27481,inst_27484);
var inst_27486 = (function(){throw inst_27485})();
var state_27662__$1 = state_27662;
var statearr_27688_27751 = state_27662__$1;
(statearr_27688_27751[(2)] = inst_27486);

(statearr_27688_27751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (28))){
var inst_27506 = (state_27662[(26)]);
var inst_27621 = (state_27662[(2)]);
var state_27662__$1 = (function (){var statearr_27689 = state_27662;
(statearr_27689[(35)] = inst_27621);

return statearr_27689;
})();
if(cljs.core.truth_(inst_27506)){
var statearr_27690_27752 = state_27662__$1;
(statearr_27690_27752[(1)] = (30));

} else {
var statearr_27691_27753 = state_27662__$1;
(statearr_27691_27753[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (25))){
var inst_27612 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
if(cljs.core.truth_(inst_27612)){
var statearr_27692_27754 = state_27662__$1;
(statearr_27692_27754[(1)] = (26));

} else {
var statearr_27693_27755 = state_27662__$1;
(statearr_27693_27755[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (34))){
var inst_27586 = (state_27662[(10)]);
var inst_27594 = (state_27662[(31)]);
var inst_27642 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27586,inst_27594);
var state_27662__$1 = state_27662;
var statearr_27694_27756 = state_27662__$1;
(statearr_27694_27756[(2)] = inst_27642);

(statearr_27694_27756[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (17))){
var inst_27534 = (state_27662[(36)]);
var inst_27538 = (state_27662[(2)]);
var inst_27539 = fluree.db.util.async.throw_err(inst_27538);
var inst_27526 = inst_27534;
var inst_27527 = inst_27539;
var state_27662__$1 = (function (){var statearr_27695 = state_27662;
(statearr_27695[(22)] = inst_27527);

(statearr_27695[(37)] = inst_27526);

return statearr_27695;
})();
var statearr_27696_27757 = state_27662__$1;
(statearr_27696_27757[(2)] = null);

(statearr_27696_27757[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (3))){
var inst_27660 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27662__$1,inst_27660);
} else {
if((state_val_27663 === (12))){
var inst_27526 = (state_27662[(37)]);
var inst_27533 = (state_27662[(38)]);
var inst_27532 = cljs.core.seq(inst_27526);
var inst_27533__$1 = cljs.core.first(inst_27532);
var inst_27534 = cljs.core.next(inst_27532);
var state_27662__$1 = (function (){var statearr_27697 = state_27662;
(statearr_27697[(36)] = inst_27534);

(statearr_27697[(38)] = inst_27533__$1);

return statearr_27697;
})();
if(cljs.core.truth_(inst_27533__$1)){
var statearr_27698_27758 = state_27662__$1;
(statearr_27698_27758[(1)] = (14));

} else {
var statearr_27699_27759 = state_27662__$1;
(statearr_27699_27759[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (2))){
var inst_27474 = (state_27662[(23)]);
var _ = (function (){var statearr_27700 = state_27662;
(statearr_27700[(4)] = cljs.core.cons((5),(state_27662[(4)])));

return statearr_27700;
})();
var inst_27473 = cljs.core.first(flakes);
var inst_27474__$1 = inst_27473.t;
var inst_27475 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27476 = (inst_27475 - (1));
var inst_27477 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_27474__$1,inst_27476);
var state_27662__$1 = (function (){var statearr_27701 = state_27662;
(statearr_27701[(23)] = inst_27474__$1);

return statearr_27701;
})();
if(inst_27477){
var statearr_27702_27760 = state_27662__$1;
(statearr_27702_27760[(1)] = (6));

} else {
var statearr_27703_27761 = state_27662__$1;
(statearr_27703_27761[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (23))){
var inst_27505 = (state_27662[(14)]);
var state_27662__$1 = state_27662;
var statearr_27704_27762 = state_27662__$1;
(statearr_27704_27762[(2)] = inst_27505);

(statearr_27704_27762[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (35))){
var inst_27586 = (state_27662[(10)]);
var state_27662__$1 = state_27662;
var statearr_27705_27763 = state_27662__$1;
(statearr_27705_27763[(2)] = inst_27586);

(statearr_27705_27763[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (19))){
var inst_27657 = (state_27662[(2)]);
var _ = (function (){var statearr_27706 = state_27662;
(statearr_27706[(4)] = cljs.core.rest((state_27662[(4)])));

return statearr_27706;
})();
var state_27662__$1 = state_27662;
var statearr_27707_27764 = state_27662__$1;
(statearr_27707_27764[(2)] = inst_27657);

(statearr_27707_27764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (11))){
var inst_27514 = (state_27662[(27)]);
var inst_27514__$1 = (state_27662[(2)]);
var inst_27522 = cljs.core.seq(inst_27514__$1);
var inst_27523 = cljs.core.first(inst_27522);
var inst_27524 = cljs.core.next(inst_27522);
var inst_27525 = db;
var inst_27526 = inst_27514__$1;
var inst_27527 = inst_27525;
var state_27662__$1 = (function (){var statearr_27709 = state_27662;
(statearr_27709[(39)] = inst_27523);

(statearr_27709[(27)] = inst_27514__$1);

(statearr_27709[(22)] = inst_27527);

(statearr_27709[(37)] = inst_27526);

(statearr_27709[(40)] = inst_27524);

return statearr_27709;
})();
var statearr_27710_27765 = state_27662__$1;
(statearr_27710_27765[(2)] = null);

(statearr_27710_27765[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (9))){
var inst_27491 = (state_27662[(28)]);
var inst_27508 = (state_27662[(32)]);
var inst_27510 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_27491,inst_27508);
var state_27662__$1 = state_27662;
var statearr_27711_27766 = state_27662__$1;
(statearr_27711_27766[(2)] = inst_27510);

(statearr_27711_27766[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (5))){
var _ = (function (){var statearr_27712 = state_27662;
(statearr_27712[(4)] = cljs.core.rest((state_27662[(4)])));

return statearr_27712;
})();
var state_27662__$1 = state_27662;
var ex27708 = (state_27662__$1[(2)]);
var statearr_27713_27767 = state_27662__$1;
(statearr_27713_27767[(5)] = ex27708);


if((ex27708 instanceof Error)){
var statearr_27714_27768 = state_27662__$1;
(statearr_27714_27768[(1)] = (4));

(statearr_27714_27768[(5)] = null);

} else {
throw ex27708;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (14))){
var inst_27527 = (state_27662[(22)]);
var inst_27533 = (state_27662[(38)]);
var inst_27536 = fluree.db.graphdb.add_predicate_to_idx(inst_27527,inst_27533,opts);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27662__$1,(17),inst_27536);
} else {
if((state_val_27663 === (26))){
var inst_27606 = (state_27662[(15)]);
var inst_27614 = fluree.db.query.schema.schema_map(inst_27606);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27662__$1,(29),inst_27614);
} else {
if((state_val_27663 === (16))){
var inst_27543 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27715_27769 = state_27662__$1;
(statearr_27715_27769[(2)] = inst_27543);

(statearr_27715_27769[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (38))){
var inst_27587 = (state_27662[(7)]);
var state_27662__$1 = state_27662;
var statearr_27716_27770 = state_27662__$1;
(statearr_27716_27770[(2)] = inst_27587);

(statearr_27716_27770[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (30))){
var inst_27621 = (state_27662[(35)]);
var inst_27624 = fluree.db.query.schema.setting_map(inst_27621);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27662__$1,(33),inst_27624);
} else {
if((state_val_27663 === (10))){
var inst_27512 = cljs.core.PersistentVector.EMPTY;
var state_27662__$1 = state_27662;
var statearr_27717_27771 = state_27662__$1;
(statearr_27717_27771[(2)] = inst_27512);

(statearr_27717_27771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (18))){
var inst_27583 = (state_27662[(21)]);
var inst_27594 = (state_27662[(31)]);
var inst_27593 = cljs.core.seq(inst_27583);
var inst_27594__$1 = cljs.core.first(inst_27593);
var inst_27595 = cljs.core.next(inst_27593);
var inst_27596 = cljs.core.not(inst_27594__$1);
var state_27662__$1 = (function (){var statearr_27718 = state_27662;
(statearr_27718[(31)] = inst_27594__$1);

(statearr_27718[(17)] = inst_27595);

return statearr_27718;
})();
if(inst_27596){
var statearr_27719_27772 = state_27662__$1;
(statearr_27719_27772[(1)] = (20));

} else {
var statearr_27720_27773 = state_27662__$1;
(statearr_27720_27773[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (37))){
var inst_27587 = (state_27662[(7)]);
var inst_27594 = (state_27662[(31)]);
var inst_27649 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27587,inst_27594);
var state_27662__$1 = state_27662;
var statearr_27721_27774 = state_27662__$1;
(statearr_27721_27774[(2)] = inst_27649);

(statearr_27721_27774[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (8))){
var inst_27474 = (state_27662[(23)]);
var inst_27499 = (state_27662[(25)]);
var inst_27491 = (state_27662[(28)]);
var inst_27489 = (state_27662[(30)]);
var inst_27495 = (state_27662[(33)]);
var inst_27505 = (state_27662[(14)]);
var inst_27489__$1 = (state_27662[(2)]);
var inst_27490 = (function (){var t = inst_27474;
var _ = inst_27489__$1;
return (function (p1__27462_SHARP_){
return cljs.core.not((function (){var G__27722 = p1__27462_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__27722) : fluree.db.graphdb.exclude_predicates.call(null,G__27722));
})());
});
})();
var inst_27491__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_27490,flakes);
var inst_27492 = cljs.core.PersistentHashSet.EMPTY;
var inst_27493 = (function (){var t = inst_27474;
var _ = inst_27489__$1;
var add_flakes = inst_27491__$1;
return (function (p1__27463_SHARP_){
return p1__27463_SHARP_.p;
});
})();
var inst_27494 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27493,inst_27491__$1);
var inst_27495__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27492,inst_27494);
var inst_27496 = cljs.core.PersistentHashMap.EMPTY;
var inst_27497 = (function (){var t = inst_27474;
var _ = inst_27489__$1;
var add_flakes = inst_27491__$1;
var add_preds = inst_27495__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_27498 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27497,inst_27495__$1);
var inst_27499__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27496,inst_27498);
var inst_27500 = cljs.core.PersistentHashMap.EMPTY;
var inst_27501 = (function (){var t = inst_27474;
var _ = inst_27489__$1;
var add_flakes = inst_27491__$1;
var add_preds = inst_27495__$1;
var idx_QMARK__map = inst_27499__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_27502 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27501,inst_27495__$1);
var inst_27503 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27500,inst_27502);
var inst_27504 = fluree.db.flake.size_bytes(inst_27491__$1);
var inst_27505__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_27491__$1);
var inst_27506 = fluree.db.util.schema.setting_change_QMARK_(inst_27491__$1);
var inst_27507 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27508 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27507,(0));
var state_27662__$1 = (function (){var statearr_27723 = state_27662;
(statearr_27723[(24)] = inst_27503);

(statearr_27723[(25)] = inst_27499__$1);

(statearr_27723[(26)] = inst_27506);

(statearr_27723[(28)] = inst_27491__$1);

(statearr_27723[(11)] = inst_27504);

(statearr_27723[(30)] = inst_27489__$1);

(statearr_27723[(32)] = inst_27508);

(statearr_27723[(33)] = inst_27495__$1);

(statearr_27723[(14)] = inst_27505__$1);

return statearr_27723;
})();
if(cljs.core.truth_(inst_27505__$1)){
var statearr_27724_27775 = state_27662__$1;
(statearr_27724_27775[(1)] = (9));

} else {
var statearr_27725_27776 = state_27662__$1;
(statearr_27725_27776[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27726[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27726[(1)] = (1));

return statearr_27726;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27662){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27662);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27727){var ex__2687__auto__ = e27727;
var statearr_27728_27777 = state_27662;
(statearr_27728_27777[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27662[(4)]))){
var statearr_27729_27778 = state_27662;
(statearr_27729_27778[(1)] = cljs.core.first((state_27662[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27779 = state_27662;
state_27662 = G__27779;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27662){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27730 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27730[(6)] = c__2706__auto__);

return statearr_27730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__27781 = arguments.length;
switch (G__27781) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___27928 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27877){
var state_val_27878 = (state_27877[(1)]);
if((state_val_27878 === (7))){
var state_27877__$1 = state_27877;
var statearr_27879_27929 = state_27877__$1;
(statearr_27879_27929[(2)] = null);

(statearr_27879_27929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (20))){
var inst_27826 = (state_27877[(7)]);
var inst_27825 = (state_27877[(8)]);
var inst_27827 = (state_27877[(9)]);
var inst_27846 = (inst_27825 + (1));
var inst_27847 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27827,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27846);
var inst_27848 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_27847,inst_27826,opts);
var state_27877__$1 = state_27877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27877__$1,(23),inst_27848);
} else {
if((state_val_27878 === (1))){
var state_27877__$1 = state_27877;
var statearr_27880_27930 = state_27877__$1;
(statearr_27880_27930[(2)] = null);

(statearr_27880_27930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (24))){
var inst_27851 = (state_27877[(10)]);
var inst_27854 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27851,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_27877__$1 = state_27877;
var statearr_27881_27931 = state_27877__$1;
(statearr_27881_27931[(2)] = inst_27854);

(statearr_27881_27931[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (4))){
var inst_27782 = (state_27877[(2)]);
var inst_27783 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27782);
var state_27877__$1 = state_27877;
var statearr_27882_27932 = state_27877__$1;
(statearr_27882_27932[(2)] = inst_27783);

(statearr_27882_27932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (15))){
var inst_27833 = (state_27877[(11)]);
var state_27877__$1 = state_27877;
var statearr_27883_27933 = state_27877__$1;
(statearr_27883_27933[(2)] = inst_27833);

(statearr_27883_27933[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (21))){
var state_27877__$1 = state_27877;
var statearr_27884_27934 = state_27877__$1;
(statearr_27884_27934[(2)] = null);

(statearr_27884_27934[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (13))){
var inst_27869 = (state_27877[(2)]);
var inst_27870 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27869);
var state_27877__$1 = state_27877;
var statearr_27885_27935 = state_27877__$1;
(statearr_27885_27935[(2)] = inst_27870);

(statearr_27885_27935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (22))){
var inst_27865 = (state_27877[(2)]);
var state_27877__$1 = state_27877;
var statearr_27886_27936 = state_27877__$1;
(statearr_27886_27936[(2)] = inst_27865);

(statearr_27886_27936[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (6))){
var inst_27793 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27794 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27795 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27793)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27794)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27796 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27797 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27798 = cljs.core.PersistentHashMap.fromArrays(inst_27796,inst_27797);
var inst_27799 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27795,inst_27798);
var inst_27800 = (function(){throw inst_27799})();
var state_27877__$1 = state_27877;
var statearr_27889_27937 = state_27877__$1;
(statearr_27889_27937[(2)] = inst_27800);

(statearr_27889_27937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (25))){
var inst_27851 = (state_27877[(10)]);
var inst_27834 = (state_27877[(12)]);
var inst_27833 = (state_27877[(11)]);
var inst_27856 = inst_27833.t;
var inst_27857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27858 = [inst_27833];
var inst_27859 = (new cljs.core.PersistentVector(null,1,(5),inst_27857,inst_27858,null));
var inst_27824 = inst_27834;
var inst_27825 = inst_27856;
var inst_27826 = inst_27859;
var inst_27827 = inst_27851;
var state_27877__$1 = (function (){var statearr_27890 = state_27877;
(statearr_27890[(7)] = inst_27826);

(statearr_27890[(8)] = inst_27825);

(statearr_27890[(13)] = inst_27824);

(statearr_27890[(9)] = inst_27827);

return statearr_27890;
})();
var statearr_27891_27938 = state_27877__$1;
(statearr_27891_27938[(2)] = null);

(statearr_27891_27938[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (17))){
var inst_27834 = (state_27877[(12)]);
var inst_27826 = (state_27877[(7)]);
var inst_27825 = (state_27877[(8)]);
var inst_27833 = (state_27877[(11)]);
var inst_27827 = (state_27877[(9)]);
var inst_27842 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27826,inst_27833);
var tmp27887 = inst_27825;
var tmp27888 = inst_27827;
var inst_27824 = inst_27834;
var inst_27825__$1 = tmp27887;
var inst_27826__$1 = inst_27842;
var inst_27827__$1 = tmp27888;
var state_27877__$1 = (function (){var statearr_27892 = state_27877;
(statearr_27892[(7)] = inst_27826__$1);

(statearr_27892[(8)] = inst_27825__$1);

(statearr_27892[(13)] = inst_27824);

(statearr_27892[(9)] = inst_27827__$1);

return statearr_27892;
})();
var statearr_27893_27939 = state_27877__$1;
(statearr_27893_27939[(2)] = null);

(statearr_27893_27939[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (3))){
var inst_27875 = (state_27877[(2)]);
var state_27877__$1 = state_27877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27877__$1,inst_27875);
} else {
if((state_val_27878 === (12))){
var inst_27824 = (state_27877[(13)]);
var inst_27833 = (state_27877[(11)]);
var inst_27832 = cljs.core.seq(inst_27824);
var inst_27833__$1 = cljs.core.first(inst_27832);
var inst_27834 = cljs.core.next(inst_27832);
var state_27877__$1 = (function (){var statearr_27894 = state_27877;
(statearr_27894[(12)] = inst_27834);

(statearr_27894[(11)] = inst_27833__$1);

return statearr_27894;
})();
if(cljs.core.truth_(inst_27833__$1)){
var statearr_27895_27940 = state_27877__$1;
(statearr_27895_27940[(1)] = (14));

} else {
var statearr_27896_27941 = state_27877__$1;
(statearr_27896_27941[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (2))){
var _ = (function (){var statearr_27897 = state_27877;
(statearr_27897[(4)] = cljs.core.cons((5),(state_27877[(4)])));

return statearr_27897;
})();
var inst_27789 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27790 = (inst_27789 + (1));
var inst_27791 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27790);
var state_27877__$1 = state_27877;
if(inst_27791){
var statearr_27898_27942 = state_27877__$1;
(statearr_27898_27942[(1)] = (6));

} else {
var statearr_27899_27943 = state_27877__$1;
(statearr_27899_27943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (23))){
var inst_27833 = (state_27877[(11)]);
var inst_27850 = (state_27877[(2)]);
var inst_27851 = fluree.db.util.async.throw_err(inst_27850);
var inst_27852 = (inst_27833 == null);
var state_27877__$1 = (function (){var statearr_27900 = state_27877;
(statearr_27900[(10)] = inst_27851);

return statearr_27900;
})();
if(cljs.core.truth_(inst_27852)){
var statearr_27901_27944 = state_27877__$1;
(statearr_27901_27944[(1)] = (24));

} else {
var statearr_27902_27945 = state_27877__$1;
(statearr_27902_27945[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (19))){
var inst_27867 = (state_27877[(2)]);
var state_27877__$1 = state_27877;
var statearr_27903_27946 = state_27877__$1;
(statearr_27903_27946[(2)] = inst_27867);

(statearr_27903_27946[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (11))){
var inst_27872 = (state_27877[(2)]);
var _ = (function (){var statearr_27905 = state_27877;
(statearr_27905[(4)] = cljs.core.rest((state_27877[(4)])));

return statearr_27905;
})();
var state_27877__$1 = state_27877;
var statearr_27906_27947 = state_27877__$1;
(statearr_27906_27947[(2)] = inst_27872);

(statearr_27906_27947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (9))){
var inst_27806 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_27807 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27806);
var state_27877__$1 = state_27877;
var statearr_27907_27948 = state_27877__$1;
(statearr_27907_27948[(2)] = inst_27807);

(statearr_27907_27948[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (5))){
var _ = (function (){var statearr_27908 = state_27877;
(statearr_27908[(4)] = cljs.core.rest((state_27877[(4)])));

return statearr_27908;
})();
var state_27877__$1 = state_27877;
var ex27904 = (state_27877__$1[(2)]);
var statearr_27909_27949 = state_27877__$1;
(statearr_27909_27949[(5)] = ex27904);


var statearr_27910_27950 = state_27877__$1;
(statearr_27910_27950[(1)] = (4));

(statearr_27910_27950[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (14))){
var inst_27825 = (state_27877[(8)]);
var inst_27833 = (state_27877[(11)]);
var inst_27836 = inst_27833.t;
var inst_27837 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27825,inst_27836);
var state_27877__$1 = state_27877;
var statearr_27911_27951 = state_27877__$1;
(statearr_27911_27951[(2)] = inst_27837);

(statearr_27911_27951[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (26))){
var inst_27862 = (state_27877[(2)]);
var state_27877__$1 = state_27877;
var statearr_27912_27952 = state_27877__$1;
(statearr_27912_27952[(2)] = inst_27862);

(statearr_27912_27952[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (16))){
var inst_27840 = (state_27877[(2)]);
var state_27877__$1 = state_27877;
if(cljs.core.truth_(inst_27840)){
var statearr_27913_27953 = state_27877__$1;
(statearr_27913_27953[(1)] = (17));

} else {
var statearr_27914_27954 = state_27877__$1;
(statearr_27914_27954[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (10))){
var inst_27809 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_27810 = cljs.core.first(inst_27809);
var inst_27818 = cljs.core.seq(inst_27809);
var inst_27819 = cljs.core.first(inst_27818);
var inst_27820 = cljs.core.next(inst_27818);
var inst_27821 = inst_27810.t;
var inst_27822 = cljs.core.PersistentVector.EMPTY;
var inst_27823 = db;
var inst_27824 = inst_27809;
var inst_27825 = inst_27821;
var inst_27826 = inst_27822;
var inst_27827 = inst_27823;
var state_27877__$1 = (function (){var statearr_27915 = state_27877;
(statearr_27915[(14)] = inst_27820);

(statearr_27915[(7)] = inst_27826);

(statearr_27915[(8)] = inst_27825);

(statearr_27915[(13)] = inst_27824);

(statearr_27915[(15)] = inst_27819);

(statearr_27915[(9)] = inst_27827);

return statearr_27915;
})();
var statearr_27916_27955 = state_27877__$1;
(statearr_27916_27955[(2)] = null);

(statearr_27916_27955[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (18))){
var state_27877__$1 = state_27877;
var statearr_27917_27956 = state_27877__$1;
(statearr_27917_27956[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27878 === (8))){
var inst_27803 = (state_27877[(2)]);
var inst_27804 = cljs.core.empty_QMARK_(flakes);
var state_27877__$1 = (function (){var statearr_27919 = state_27877;
(statearr_27919[(16)] = inst_27803);

return statearr_27919;
})();
if(inst_27804){
var statearr_27920_27957 = state_27877__$1;
(statearr_27920_27957[(1)] = (9));

} else {
var statearr_27921_27958 = state_27877__$1;
(statearr_27921_27958[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27922 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27922[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27922[(1)] = (1));

return statearr_27922;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27877){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27877);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27923){var ex__2687__auto__ = e27923;
var statearr_27924_27959 = state_27877;
(statearr_27924_27959[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27877[(4)]))){
var statearr_27925_27960 = state_27877;
(statearr_27925_27960[(1)] = cljs.core.first((state_27877[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27961 = state_27877;
state_27877 = G__27961;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27877){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27926 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27926[(6)] = c__2706__auto___27928);

return statearr_27926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28017){
var state_val_28018 = (state_28017[(1)]);
if((state_val_28018 === (7))){
var state_28017__$1 = state_28017;
var statearr_28019_28046 = state_28017__$1;
(statearr_28019_28046[(2)] = tt_id);

(statearr_28019_28046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (1))){
var state_28017__$1 = state_28017;
var statearr_28020_28047 = state_28017__$1;
(statearr_28020_28047[(2)] = null);

(statearr_28020_28047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (4))){
var inst_27962 = (state_28017[(2)]);
var state_28017__$1 = state_28017;
var statearr_28021_28048 = state_28017__$1;
(statearr_28021_28048[(2)] = inst_27962);

(statearr_28021_28048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (13))){
var inst_28010 = (state_28017[(2)]);
var state_28017__$1 = state_28017;
var statearr_28022_28049 = state_28017__$1;
(statearr_28022_28049[(2)] = inst_28010);

(statearr_28022_28049[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (6))){
var inst_27970 = fluree.db.util.core.random_uuid();
var state_28017__$1 = state_28017;
var statearr_28023_28050 = state_28017__$1;
(statearr_28023_28050[(2)] = inst_27970);

(statearr_28023_28050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (3))){
var inst_28015 = (state_28017[(2)]);
var state_28017__$1 = state_28017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28017__$1,inst_28015);
} else {
if((state_val_28018 === (12))){
var inst_27993 = (state_28017[(7)]);
var state_28017__$1 = state_28017;
var statearr_28024_28051 = state_28017__$1;
(statearr_28024_28051[(2)] = inst_27993);

(statearr_28024_28051[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (2))){
var _ = (function (){var statearr_28025 = state_28017;
(statearr_28025[(4)] = cljs.core.cons((5),(state_28017[(4)])));

return statearr_28025;
})();
var inst_27968 = (tt_id == null);
var state_28017__$1 = state_28017;
if(cljs.core.truth_(inst_27968)){
var statearr_28026_28052 = state_28017__$1;
(statearr_28026_28052[(1)] = (6));

} else {
var statearr_28027_28053 = state_28017__$1;
(statearr_28027_28053[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (11))){
var inst_28000 = (state_28017[(8)]);
var inst_27993 = (state_28017[(7)]);
var inst_28003 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_27993,inst_28000);
var state_28017__$1 = state_28017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28017__$1,(14),inst_28003);
} else {
if((state_val_28018 === (9))){
var inst_28000 = (state_28017[(8)]);
var inst_27994 = (state_28017[(9)]);
var inst_27999 = cljs.core.seq(inst_27994);
var inst_28000__$1 = cljs.core.first(inst_27999);
var inst_28001 = cljs.core.next(inst_27999);
var state_28017__$1 = (function (){var statearr_28029 = state_28017;
(statearr_28029[(8)] = inst_28000__$1);

(statearr_28029[(10)] = inst_28001);

return statearr_28029;
})();
if(cljs.core.truth_(inst_28000__$1)){
var statearr_28030_28054 = state_28017__$1;
(statearr_28030_28054[(1)] = (11));

} else {
var statearr_28031_28055 = state_28017__$1;
(statearr_28031_28055[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (5))){
var _ = (function (){var statearr_28032 = state_28017;
(statearr_28032[(4)] = cljs.core.rest((state_28017[(4)])));

return statearr_28032;
})();
var state_28017__$1 = state_28017;
var ex28028 = (state_28017__$1[(2)]);
var statearr_28033_28056 = state_28017__$1;
(statearr_28033_28056[(5)] = ex28028);


if((ex28028 instanceof Error)){
var statearr_28034_28057 = state_28017__$1;
(statearr_28034_28057[(1)] = (4));

(statearr_28034_28057[(5)] = null);

} else {
throw ex28028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (14))){
var inst_28001 = (state_28017[(10)]);
var inst_28005 = (state_28017[(2)]);
var inst_28006 = fluree.db.util.async.throw_err(inst_28005);
var inst_27993 = inst_28006;
var inst_27994 = inst_28001;
var state_28017__$1 = (function (){var statearr_28035 = state_28017;
(statearr_28035[(9)] = inst_27994);

(statearr_28035[(7)] = inst_27993);

return statearr_28035;
})();
var statearr_28036_28058 = state_28017__$1;
(statearr_28036_28058[(2)] = null);

(statearr_28036_28058[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (10))){
var inst_28012 = (state_28017[(2)]);
var _ = (function (){var statearr_28037 = state_28017;
(statearr_28037[(4)] = cljs.core.rest((state_28017[(4)])));

return statearr_28037;
})();
var state_28017__$1 = state_28017;
var statearr_28038_28059 = state_28017__$1;
(statearr_28038_28059[(2)] = inst_28012);

(statearr_28038_28059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28018 === (8))){
var inst_27973 = (state_28017[(2)]);
var inst_27974 = (function (){var tt_id_SINGLEQUOTE_ = inst_27973;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27975 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27973);
var inst_27976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27977 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27978 = (new cljs.core.PersistentVector(null,4,(5),inst_27976,inst_27977,null));
var inst_27979 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27974,inst_27975,inst_27978);
var inst_27980 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27981 = cljs.core.reverse(inst_27980);
var inst_27982 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_27981);
var inst_27990 = cljs.core.seq(inst_27982);
var inst_27991 = cljs.core.first(inst_27990);
var inst_27992 = cljs.core.next(inst_27990);
var inst_27993 = inst_27979;
var inst_27994 = inst_27982;
var state_28017__$1 = (function (){var statearr_28039 = state_28017;
(statearr_28039[(9)] = inst_27994);

(statearr_28039[(11)] = inst_27991);

(statearr_28039[(7)] = inst_27993);

(statearr_28039[(12)] = inst_27992);

return statearr_28039;
})();
var statearr_28040_28060 = state_28017__$1;
(statearr_28040_28060[(2)] = null);

(statearr_28040_28060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0 = (function (){
var statearr_28041 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28041[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__);

(statearr_28041[(1)] = (1));

return statearr_28041;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1 = (function (state_28017){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28017);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28042){var ex__2687__auto__ = e28042;
var statearr_28043_28061 = state_28017;
(statearr_28043_28061[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28017[(4)]))){
var statearr_28044_28062 = state_28017;
(statearr_28044_28062[(1)] = cljs.core.first((state_28017[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28063 = state_28017;
state_28017 = G__28063;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = function(state_28017){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1.call(this,state_28017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28045 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28045[(6)] = c__2706__auto__);

return statearr_28045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___28250 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28181){
var state_val_28182 = (state_28181[(1)]);
if((state_val_28182 === (7))){
var inst_28091 = (state_28181[(7)]);
var inst_28091__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_28181__$1 = (function (){var statearr_28183 = state_28181;
(statearr_28183[(7)] = inst_28091__$1);

return statearr_28183;
})();
if(inst_28091__$1){
var statearr_28184_28251 = state_28181__$1;
(statearr_28184_28251[(1)] = (13));

} else {
var statearr_28185_28252 = state_28181__$1;
(statearr_28185_28252[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (20))){
var state_28181__$1 = state_28181;
var statearr_28186_28253 = state_28181__$1;
(statearr_28186_28253[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (27))){
var inst_28127 = (state_28181[(8)]);
var inst_28131 = inst_28127.s;
var state_28181__$1 = state_28181;
var statearr_28188_28254 = state_28181__$1;
(statearr_28188_28254[(2)] = inst_28131);

(statearr_28188_28254[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (1))){
var state_28181__$1 = state_28181;
var statearr_28189_28255 = state_28181__$1;
(statearr_28189_28255[(2)] = null);

(statearr_28189_28255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (24))){
var inst_28121 = (state_28181[(9)]);
var inst_28125 = cljs.core.first(inst_28121);
var state_28181__$1 = state_28181;
var statearr_28190_28256 = state_28181__$1;
(statearr_28190_28256[(2)] = inst_28125);

(statearr_28190_28256[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (39))){
var state_28181__$1 = state_28181;
var statearr_28191_28257 = state_28181__$1;
(statearr_28191_28257[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (4))){
var inst_28064 = (state_28181[(2)]);
var inst_28065 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_28066 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28067 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_28068 = cljs.core.PersistentHashMap.fromArrays(inst_28066,inst_28067);
var inst_28069 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_28065,inst_28068,inst_28064);
var inst_28070 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_28069);
var state_28181__$1 = state_28181;
var statearr_28193_28258 = state_28181__$1;
(statearr_28193_28258[(2)] = inst_28070);

(statearr_28193_28258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (15))){
var inst_28098 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
if(cljs.core.truth_(inst_28098)){
var statearr_28194_28259 = state_28181__$1;
(statearr_28194_28259[(1)] = (16));

} else {
var statearr_28195_28260 = state_28181__$1;
(statearr_28195_28260[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (21))){
var inst_28147 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
var statearr_28196_28261 = state_28181__$1;
(statearr_28196_28261[(2)] = inst_28147);

(statearr_28196_28261[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (31))){
var inst_28145 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
var statearr_28197_28262 = state_28181__$1;
(statearr_28197_28262[(2)] = inst_28145);

(statearr_28197_28262[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (32))){
var inst_28151 = (state_28181[(10)]);
var inst_28153 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_28151);
var state_28181__$1 = state_28181;
var statearr_28198_28263 = state_28181__$1;
(statearr_28198_28263[(2)] = inst_28153);

(statearr_28198_28263[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (40))){
var inst_28174 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
var statearr_28199_28264 = state_28181__$1;
(statearr_28199_28264[(2)] = inst_28174);

(statearr_28199_28264[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (33))){
var inst_28151 = (state_28181[(10)]);
var inst_28155 = (state_28181[(11)]);
var inst_28155__$1 = (inst_28151 == null);
var state_28181__$1 = (function (){var statearr_28200 = state_28181;
(statearr_28200[(11)] = inst_28155__$1);

return statearr_28200;
})();
if(cljs.core.truth_(inst_28155__$1)){
var statearr_28201_28265 = state_28181__$1;
(statearr_28201_28265[(1)] = (35));

} else {
var statearr_28202_28266 = state_28181__$1;
(statearr_28202_28266[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (13))){
var inst_28093 = cljs.core.first(ident);
var inst_28094 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_28093);
var inst_28095 = (inst_28094 == null);
var state_28181__$1 = state_28181;
var statearr_28203_28267 = state_28181__$1;
(statearr_28203_28267[(2)] = inst_28095);

(statearr_28203_28267[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (22))){
var inst_28121 = (state_28181[(9)]);
var inst_28120 = (state_28181[(2)]);
var inst_28121__$1 = fluree.db.util.async.throw_err(inst_28120);
var inst_28122 = (inst_28121__$1 == null);
var state_28181__$1 = (function (){var statearr_28204 = state_28181;
(statearr_28204[(9)] = inst_28121__$1);

return statearr_28204;
})();
if(cljs.core.truth_(inst_28122)){
var statearr_28205_28268 = state_28181__$1;
(statearr_28205_28268[(1)] = (23));

} else {
var statearr_28206_28269 = state_28181__$1;
(statearr_28206_28269[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (36))){
var inst_28155 = (state_28181[(11)]);
var state_28181__$1 = state_28181;
var statearr_28207_28270 = state_28181__$1;
(statearr_28207_28270[(2)] = inst_28155);

(statearr_28207_28270[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (41))){
var inst_28169 = cljs.core.async.close_BANG_(return_chan);
var state_28181__$1 = state_28181;
var statearr_28208_28271 = state_28181__$1;
(statearr_28208_28271[(2)] = inst_28169);

(statearr_28208_28271[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (43))){
var inst_28172 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
var statearr_28209_28272 = state_28181__$1;
(statearr_28209_28272[(2)] = inst_28172);

(statearr_28209_28272[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (29))){
var inst_28136 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_28137 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_28136].join('');
var inst_28138 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28139 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_28140 = cljs.core.PersistentHashMap.fromArrays(inst_28138,inst_28139);
var inst_28141 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28137,inst_28140);
var inst_28142 = (function(){throw inst_28141})();
var state_28181__$1 = state_28181;
var statearr_28210_28273 = state_28181__$1;
(statearr_28210_28273[(2)] = inst_28142);

(statearr_28210_28273[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (6))){
var inst_28078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28079 = [ident];
var inst_28080 = (new cljs.core.PersistentVector(null,1,(5),inst_28078,inst_28079,null));
var inst_28081 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28080);
var state_28181__$1 = state_28181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28181__$1,(9),inst_28081);
} else {
if((state_val_28182 === (28))){
var inst_28133 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
var statearr_28211_28274 = state_28181__$1;
(statearr_28211_28274[(2)] = inst_28133);

(statearr_28211_28274[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (25))){
var inst_28127 = (state_28181[(8)]);
var inst_28127__$1 = (state_28181[(2)]);
var inst_28128 = (inst_28127__$1 == null);
var state_28181__$1 = (function (){var statearr_28212 = state_28181;
(statearr_28212[(8)] = inst_28127__$1);

return statearr_28212;
})();
if(cljs.core.truth_(inst_28128)){
var statearr_28213_28275 = state_28181__$1;
(statearr_28213_28275[(1)] = (26));

} else {
var statearr_28214_28276 = state_28181__$1;
(statearr_28214_28276[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (34))){
var inst_28176 = (state_28181[(2)]);
var _ = (function (){var statearr_28215 = state_28181;
(statearr_28215[(4)] = cljs.core.rest((state_28181[(4)])));

return statearr_28215;
})();
var state_28181__$1 = state_28181;
var statearr_28216_28277 = state_28181__$1;
(statearr_28216_28277[(2)] = inst_28176);

(statearr_28216_28277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (17))){
var inst_28109 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_28181__$1 = state_28181;
if(inst_28109){
var statearr_28217_28278 = state_28181__$1;
(statearr_28217_28278[(1)] = (19));

} else {
var statearr_28218_28279 = state_28181__$1;
(statearr_28218_28279[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (3))){
var inst_28179 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28181__$1,inst_28179);
} else {
if((state_val_28182 === (12))){
var inst_28089 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
var statearr_28219_28280 = state_28181__$1;
(statearr_28219_28280[(2)] = inst_28089);

(statearr_28219_28280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (2))){
var _ = (function (){var statearr_28220 = state_28181;
(statearr_28220[(4)] = cljs.core.cons((5),(state_28181[(4)])));

return statearr_28220;
})();
var inst_28076 = typeof ident === 'number';
var state_28181__$1 = state_28181;
if(cljs.core.truth_(inst_28076)){
var statearr_28221_28281 = state_28181__$1;
(statearr_28221_28281[(1)] = (6));

} else {
var statearr_28222_28282 = state_28181__$1;
(statearr_28222_28282[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (23))){
var state_28181__$1 = state_28181;
var statearr_28223_28283 = state_28181__$1;
(statearr_28223_28283[(2)] = null);

(statearr_28223_28283[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (35))){
var state_28181__$1 = state_28181;
var statearr_28224_28284 = state_28181__$1;
(statearr_28224_28284[(2)] = strict_QMARK_);

(statearr_28224_28284[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (19))){
var inst_28112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28113 = cljs.core.first(ident);
var inst_28114 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_28113);
var inst_28115 = cljs.core.second(ident);
var inst_28116 = [inst_28114,inst_28115];
var inst_28117 = (new cljs.core.PersistentVector(null,2,(5),inst_28112,inst_28116,null));
var inst_28118 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_28117);
var state_28181__$1 = state_28181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28181__$1,(22),inst_28118);
} else {
if((state_val_28182 === (11))){
var state_28181__$1 = state_28181;
var statearr_28226_28285 = state_28181__$1;
(statearr_28226_28285[(2)] = null);

(statearr_28226_28285[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (9))){
var inst_28083 = (state_28181[(2)]);
var inst_28084 = fluree.db.util.async.throw_err(inst_28083);
var inst_28085 = cljs.core.not_empty(inst_28084);
var state_28181__$1 = state_28181;
if(cljs.core.truth_(inst_28085)){
var statearr_28227_28286 = state_28181__$1;
(statearr_28227_28286[(1)] = (10));

} else {
var statearr_28228_28287 = state_28181__$1;
(statearr_28228_28287[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (5))){
var _ = (function (){var statearr_28229 = state_28181;
(statearr_28229[(4)] = cljs.core.rest((state_28181[(4)])));

return statearr_28229;
})();
var state_28181__$1 = state_28181;
var ex28225 = (state_28181__$1[(2)]);
var statearr_28230_28288 = state_28181__$1;
(statearr_28230_28288[(5)] = ex28225);


var statearr_28231_28289 = state_28181__$1;
(statearr_28231_28289[(1)] = (4));

(statearr_28231_28289[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (14))){
var inst_28091 = (state_28181[(7)]);
var state_28181__$1 = state_28181;
var statearr_28232_28290 = state_28181__$1;
(statearr_28232_28290[(2)] = inst_28091);

(statearr_28232_28290[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (26))){
var state_28181__$1 = state_28181;
var statearr_28233_28291 = state_28181__$1;
(statearr_28233_28291[(2)] = null);

(statearr_28233_28291[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (16))){
var inst_28100 = cljs.core.first(ident);
var inst_28101 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28100], 0));
var inst_28102 = ["Subject ID lookup failed. The predicate ",inst_28101," does not exist."].join('');
var inst_28103 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28104 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_28105 = cljs.core.PersistentHashMap.fromArrays(inst_28103,inst_28104);
var inst_28106 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28102,inst_28105);
var inst_28107 = (function(){throw inst_28106})();
var state_28181__$1 = state_28181;
var statearr_28234_28292 = state_28181__$1;
(statearr_28234_28292[(2)] = inst_28107);

(statearr_28234_28292[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (38))){
var inst_28161 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_28162 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28163 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_28164 = cljs.core.PersistentHashMap.fromArrays(inst_28162,inst_28163);
var inst_28165 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28161,inst_28164);
var inst_28166 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_28165);
var state_28181__$1 = state_28181;
var statearr_28235_28293 = state_28181__$1;
(statearr_28235_28293[(2)] = inst_28166);

(statearr_28235_28293[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (30))){
var state_28181__$1 = state_28181;
var statearr_28236_28294 = state_28181__$1;
(statearr_28236_28294[(2)] = null);

(statearr_28236_28294[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (10))){
var state_28181__$1 = state_28181;
var statearr_28237_28295 = state_28181__$1;
(statearr_28237_28295[(2)] = ident);

(statearr_28237_28295[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (18))){
var inst_28149 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
var statearr_28238_28296 = state_28181__$1;
(statearr_28238_28296[(2)] = inst_28149);

(statearr_28238_28296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (42))){
var state_28181__$1 = state_28181;
var statearr_28239_28297 = state_28181__$1;
(statearr_28239_28297[(2)] = null);

(statearr_28239_28297[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (37))){
var inst_28159 = (state_28181[(2)]);
var state_28181__$1 = state_28181;
if(cljs.core.truth_(inst_28159)){
var statearr_28240_28298 = state_28181__$1;
(statearr_28240_28298[(1)] = (38));

} else {
var statearr_28241_28299 = state_28181__$1;
(statearr_28241_28299[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28182 === (8))){
var inst_28151 = (state_28181[(10)]);
var inst_28151__$1 = (state_28181[(2)]);
var state_28181__$1 = (function (){var statearr_28242 = state_28181;
(statearr_28242[(10)] = inst_28151__$1);

return statearr_28242;
})();
if(cljs.core.truth_(inst_28151__$1)){
var statearr_28243_28300 = state_28181__$1;
(statearr_28243_28300[(1)] = (32));

} else {
var statearr_28244_28301 = state_28181__$1;
(statearr_28244_28301[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2684__auto____0 = (function (){
var statearr_28245 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28245[(0)] = fluree$db$graphdb$subid_$_state_machine__2684__auto__);

(statearr_28245[(1)] = (1));

return statearr_28245;
});
var fluree$db$graphdb$subid_$_state_machine__2684__auto____1 = (function (state_28181){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28181);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28246){var ex__2687__auto__ = e28246;
var statearr_28247_28302 = state_28181;
(statearr_28247_28302[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28181[(4)]))){
var statearr_28248_28303 = state_28181;
(statearr_28248_28303[(1)] = cljs.core.first((state_28181[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28304 = state_28181;
state_28181 = G__28304;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2684__auto__ = function(state_28181){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____1.call(this,state_28181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2684__auto____0;
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2684__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28249 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28249[(6)] = c__2706__auto___28250);

return statearr_28249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__28305){
var map__28306 = p__28305;
var map__28306__$1 = cljs.core.__destructure_map(map__28306);
var db = map__28306__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28306__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28306__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28322){
var state_val_28323 = (state_28322[(1)]);
if((state_val_28323 === (1))){
var state_28322__$1 = state_28322;
var statearr_28324_28338 = state_28322__$1;
(statearr_28324_28338[(2)] = null);

(statearr_28324_28338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28323 === (2))){
var _ = (function (){var statearr_28325 = state_28322;
(statearr_28325[(4)] = cljs.core.cons((5),(state_28322[(4)])));

return statearr_28325;
})();
var inst_28313 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_28322__$1 = state_28322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28322__$1,(6),inst_28313);
} else {
if((state_val_28323 === (3))){
var inst_28320 = (state_28322[(2)]);
var state_28322__$1 = state_28322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28322__$1,inst_28320);
} else {
if((state_val_28323 === (4))){
var inst_28307 = (state_28322[(2)]);
var state_28322__$1 = state_28322;
var statearr_28327_28339 = state_28322__$1;
(statearr_28327_28339[(2)] = inst_28307);

(statearr_28327_28339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28323 === (5))){
var _ = (function (){var statearr_28328 = state_28322;
(statearr_28328[(4)] = cljs.core.rest((state_28322[(4)])));

return statearr_28328;
})();
var state_28322__$1 = state_28322;
var ex28326 = (state_28322__$1[(2)]);
var statearr_28329_28340 = state_28322__$1;
(statearr_28329_28340[(5)] = ex28326);


if((ex28326 instanceof Error)){
var statearr_28330_28341 = state_28322__$1;
(statearr_28330_28341[(1)] = (4));

(statearr_28330_28341[(5)] = null);

} else {
throw ex28326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28323 === (6))){
var inst_28315 = (state_28322[(2)]);
var inst_28316 = fluree.db.util.async.throw_err(inst_28315);
var inst_28317 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28316,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_28331 = state_28322;
(statearr_28331[(4)] = cljs.core.rest((state_28322[(4)])));

return statearr_28331;
})();
var state_28322__$1 = state_28322;
var statearr_28332_28342 = state_28322__$1;
(statearr_28332_28342[(2)] = inst_28317);

(statearr_28332_28342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0 = (function (){
var statearr_28333 = [null,null,null,null,null,null,null];
(statearr_28333[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__);

(statearr_28333[(1)] = (1));

return statearr_28333;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1 = (function (state_28322){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28322);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28334){var ex__2687__auto__ = e28334;
var statearr_28335_28343 = state_28322;
(statearr_28335_28343[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28322[(4)]))){
var statearr_28336_28344 = state_28322;
(statearr_28336_28344[(1)] = cljs.core.first((state_28322[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28345 = state_28322;
state_28322 = G__28345;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = function(state_28322){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1.call(this,state_28322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28337 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28337[(6)] = c__2706__auto__);

return statearr_28337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__28346,property,collection){
var map__28347 = p__28346;
var map__28347__$1 = cljs.core.__destructure_map(map__28347);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28347__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__28348 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__28348.cljs$core$IFn$_invoke$arity$1 ? fexpr__28348.cljs$core$IFn$_invoke$arity$1(property) : fexpr__28348.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__28349,property,predicate){
var map__28350 = p__28349;
var map__28350__$1 = cljs.core.__destructure_map(map__28350);
var this$ = map__28350__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28350__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__28351 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__28351.cljs$core$IFn$_invoke$arity$1 ? fexpr__28351.cljs$core$IFn$_invoke$arity$1(property) : fexpr__28351.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__28352 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__28352);
} else {
return G__28352;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__28354 = arguments.length;
switch (G__28354) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28386){
var state_val_28387 = (state_28386[(1)]);
if((state_val_28387 === (7))){
var state_28386__$1 = state_28386;
var statearr_28388_28482 = state_28386__$1;
(statearr_28388_28482[(2)] = null);

(statearr_28388_28482[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (1))){
var state_28386__$1 = state_28386;
var statearr_28389_28483 = state_28386__$1;
(statearr_28389_28483[(2)] = null);

(statearr_28389_28483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (4))){
var inst_28355 = (state_28386[(2)]);
var state_28386__$1 = state_28386;
var statearr_28390_28484 = state_28386__$1;
(statearr_28390_28484[(2)] = inst_28355);

(statearr_28390_28484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (6))){
var inst_28369 = (state_28386[(7)]);
var inst_28368 = (state_28386[(2)]);
var inst_28369__$1 = fluree.db.util.async.throw_err(inst_28368);
var inst_28370 = (inst_28369__$1 == null);
var state_28386__$1 = (function (){var statearr_28391 = state_28386;
(statearr_28391[(7)] = inst_28369__$1);

return statearr_28391;
})();
if(cljs.core.truth_(inst_28370)){
var statearr_28392_28485 = state_28386__$1;
(statearr_28392_28485[(1)] = (7));

} else {
var statearr_28393_28486 = state_28386__$1;
(statearr_28393_28486[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (3))){
var inst_28384 = (state_28386[(2)]);
var state_28386__$1 = state_28386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28386__$1,inst_28384);
} else {
if((state_val_28387 === (12))){
var inst_28381 = (state_28386[(2)]);
var _ = (function (){var statearr_28394 = state_28386;
(statearr_28394[(4)] = cljs.core.rest((state_28386[(4)])));

return statearr_28394;
})();
var state_28386__$1 = state_28386;
var statearr_28395_28487 = state_28386__$1;
(statearr_28395_28487[(2)] = inst_28381);

(statearr_28395_28487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (2))){
var _ = (function (){var statearr_28396 = state_28386;
(statearr_28396[(4)] = cljs.core.cons((5),(state_28386[(4)])));

return statearr_28396;
})();
var inst_28362 = fluree.db.dbproto._rootdb(this$);
var inst_28363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28364 = [tag_id,(30)];
var inst_28365 = (new cljs.core.PersistentVector(null,2,(5),inst_28363,inst_28364,null));
var inst_28366 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_28362,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28365);
var state_28386__$1 = state_28386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28386__$1,(6),inst_28366);
} else {
if((state_val_28387 === (11))){
var inst_28375 = (state_28386[(8)]);
var inst_28379 = inst_28375.o;
var state_28386__$1 = state_28386;
var statearr_28398_28488 = state_28386__$1;
(statearr_28398_28488[(2)] = inst_28379);

(statearr_28398_28488[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (9))){
var inst_28375 = (state_28386[(8)]);
var inst_28375__$1 = (state_28386[(2)]);
var inst_28376 = (inst_28375__$1 == null);
var state_28386__$1 = (function (){var statearr_28399 = state_28386;
(statearr_28399[(8)] = inst_28375__$1);

return statearr_28399;
})();
if(cljs.core.truth_(inst_28376)){
var statearr_28400_28489 = state_28386__$1;
(statearr_28400_28489[(1)] = (10));

} else {
var statearr_28401_28490 = state_28386__$1;
(statearr_28401_28490[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (5))){
var _ = (function (){var statearr_28402 = state_28386;
(statearr_28402[(4)] = cljs.core.rest((state_28386[(4)])));

return statearr_28402;
})();
var state_28386__$1 = state_28386;
var ex28397 = (state_28386__$1[(2)]);
var statearr_28403_28491 = state_28386__$1;
(statearr_28403_28491[(5)] = ex28397);


if((ex28397 instanceof Error)){
var statearr_28404_28492 = state_28386__$1;
(statearr_28404_28492[(1)] = (4));

(statearr_28404_28492[(5)] = null);

} else {
throw ex28397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (10))){
var state_28386__$1 = state_28386;
var statearr_28405_28493 = state_28386__$1;
(statearr_28405_28493[(2)] = null);

(statearr_28405_28493[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (8))){
var inst_28369 = (state_28386[(7)]);
var inst_28373 = cljs.core.first(inst_28369);
var state_28386__$1 = state_28386;
var statearr_28406_28494 = state_28386__$1;
(statearr_28406_28494[(2)] = inst_28373);

(statearr_28406_28494[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_28407 = [null,null,null,null,null,null,null,null,null];
(statearr_28407[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_28407[(1)] = (1));

return statearr_28407;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_28386){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28386);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28408){var ex__2687__auto__ = e28408;
var statearr_28409_28495 = state_28386;
(statearr_28409_28495[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28386[(4)]))){
var statearr_28410_28496 = state_28386;
(statearr_28410_28496[(1)] = cljs.core.first((state_28386[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28497 = state_28386;
state_28386 = G__28497;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_28386){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_28386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28411 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28411[(6)] = c__2706__auto__);

return statearr_28411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28447){
var state_val_28448 = (state_28447[(1)]);
if((state_val_28448 === (7))){
var inst_28421 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28447__$1 = state_28447;
var statearr_28449_28498 = state_28447__$1;
(statearr_28449_28498[(2)] = inst_28421);

(statearr_28449_28498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (1))){
var state_28447__$1 = state_28447;
var statearr_28450_28499 = state_28447__$1;
(statearr_28450_28499[(2)] = null);

(statearr_28450_28499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (4))){
var inst_28412 = (state_28447[(2)]);
var state_28447__$1 = state_28447;
var statearr_28451_28500 = state_28447__$1;
(statearr_28451_28500[(2)] = inst_28412);

(statearr_28451_28500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (15))){
var inst_28442 = (state_28447[(2)]);
var _ = (function (){var statearr_28452 = state_28447;
(statearr_28452[(4)] = cljs.core.rest((state_28447[(4)])));

return statearr_28452;
})();
var state_28447__$1 = state_28447;
var statearr_28453_28501 = state_28447__$1;
(statearr_28453_28501[(2)] = inst_28442);

(statearr_28453_28501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (13))){
var inst_28427 = (state_28447[(7)]);
var inst_28433 = clojure.string.includes_QMARK_(inst_28427,":");
var state_28447__$1 = state_28447;
if(inst_28433){
var statearr_28454_28502 = state_28447__$1;
(statearr_28454_28502[(1)] = (16));

} else {
var statearr_28455_28503 = state_28447__$1;
(statearr_28455_28503[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (6))){
var state_28447__$1 = state_28447;
var statearr_28456_28504 = state_28447__$1;
(statearr_28456_28504[(2)] = pred);

(statearr_28456_28504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (17))){
var inst_28427 = (state_28447[(7)]);
var state_28447__$1 = state_28447;
var statearr_28457_28505 = state_28447__$1;
(statearr_28457_28505[(2)] = inst_28427);

(statearr_28457_28505[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (3))){
var inst_28445 = (state_28447[(2)]);
var state_28447__$1 = state_28447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28447__$1,inst_28445);
} else {
if((state_val_28448 === (12))){
var inst_28431 = (state_28447[(2)]);
var state_28447__$1 = state_28447;
if(cljs.core.truth_(inst_28431)){
var statearr_28458_28506 = state_28447__$1;
(statearr_28458_28506[(1)] = (13));

} else {
var statearr_28459_28507 = state_28447__$1;
(statearr_28459_28507[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (2))){
var _ = (function (){var statearr_28460 = state_28447;
(statearr_28460[(4)] = cljs.core.cons((5),(state_28447[(4)])));

return statearr_28460;
})();
var inst_28418 = typeof pred === 'string';
var state_28447__$1 = state_28447;
if(cljs.core.truth_(inst_28418)){
var statearr_28461_28508 = state_28447__$1;
(statearr_28461_28508[(1)] = (6));

} else {
var statearr_28462_28509 = state_28447__$1;
(statearr_28462_28509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (11))){
var inst_28423 = (state_28447[(8)]);
var state_28447__$1 = state_28447;
var statearr_28464_28510 = state_28447__$1;
(statearr_28464_28510[(2)] = inst_28423);

(statearr_28464_28510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (9))){
var inst_28423 = (state_28447[(8)]);
var inst_28426 = (state_28447[(2)]);
var inst_28427 = fluree.db.util.async.throw_err(inst_28426);
var state_28447__$1 = (function (){var statearr_28465 = state_28447;
(statearr_28465[(7)] = inst_28427);

return statearr_28465;
})();
if(cljs.core.truth_(inst_28423)){
var statearr_28466_28511 = state_28447__$1;
(statearr_28466_28511[(1)] = (10));

} else {
var statearr_28467_28512 = state_28447__$1;
(statearr_28467_28512[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (5))){
var _ = (function (){var statearr_28468 = state_28447;
(statearr_28468[(4)] = cljs.core.rest((state_28447[(4)])));

return statearr_28468;
})();
var state_28447__$1 = state_28447;
var ex28463 = (state_28447__$1[(2)]);
var statearr_28469_28513 = state_28447__$1;
(statearr_28469_28513[(5)] = ex28463);


if((ex28463 instanceof Error)){
var statearr_28470_28514 = state_28447__$1;
(statearr_28470_28514[(1)] = (4));

(statearr_28470_28514[(5)] = null);

} else {
throw ex28463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (14))){
var state_28447__$1 = state_28447;
var statearr_28471_28515 = state_28447__$1;
(statearr_28471_28515[(2)] = null);

(statearr_28471_28515[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (16))){
var inst_28427 = (state_28447[(7)]);
var inst_28435 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_28427,/:/);
var inst_28436 = cljs.core.second(inst_28435);
var state_28447__$1 = state_28447;
var statearr_28472_28516 = state_28447__$1;
(statearr_28472_28516[(2)] = inst_28436);

(statearr_28472_28516[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (10))){
var inst_28427 = (state_28447[(7)]);
var state_28447__$1 = state_28447;
var statearr_28473_28517 = state_28447__$1;
(statearr_28473_28517[(2)] = inst_28427);

(statearr_28473_28517[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (18))){
var inst_28439 = (state_28447[(2)]);
var state_28447__$1 = state_28447;
var statearr_28474_28518 = state_28447__$1;
(statearr_28474_28518[(2)] = inst_28439);

(statearr_28474_28518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28448 === (8))){
var inst_28423 = (state_28447[(2)]);
var inst_28424 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_28447__$1 = (function (){var statearr_28475 = state_28447;
(statearr_28475[(8)] = inst_28423);

return statearr_28475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28447__$1,(9),inst_28424);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_28476 = [null,null,null,null,null,null,null,null,null];
(statearr_28476[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_28476[(1)] = (1));

return statearr_28476;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_28447){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28447);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28477){var ex__2687__auto__ = e28477;
var statearr_28478_28519 = state_28447;
(statearr_28478_28519[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28447[(4)]))){
var statearr_28479_28520 = state_28447;
(statearr_28479_28520[(1)] = cljs.core.first((state_28447[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28521 = state_28447;
state_28447 = G__28521;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_28447){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_28447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28480 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28480[(6)] = c__2706__auto__);

return statearr_28480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__28523 = arguments.length;
switch (G__28523) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28556){
var state_val_28557 = (state_28556[(1)]);
if((state_val_28557 === (7))){
var state_28556__$1 = state_28556;
var statearr_28558_28646 = state_28556__$1;
(statearr_28558_28646[(2)] = null);

(statearr_28558_28646[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (1))){
var state_28556__$1 = state_28556;
var statearr_28559_28647 = state_28556__$1;
(statearr_28559_28647[(2)] = null);

(statearr_28559_28647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (4))){
var inst_28524 = (state_28556[(2)]);
var state_28556__$1 = state_28556;
var statearr_28560_28648 = state_28556__$1;
(statearr_28560_28648[(2)] = inst_28524);

(statearr_28560_28648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (6))){
var inst_28539 = (state_28556[(7)]);
var inst_28538 = (state_28556[(2)]);
var inst_28539__$1 = fluree.db.util.async.throw_err(inst_28538);
var inst_28540 = (inst_28539__$1 == null);
var state_28556__$1 = (function (){var statearr_28561 = state_28556;
(statearr_28561[(7)] = inst_28539__$1);

return statearr_28561;
})();
if(cljs.core.truth_(inst_28540)){
var statearr_28562_28649 = state_28556__$1;
(statearr_28562_28649[(1)] = (7));

} else {
var statearr_28563_28650 = state_28556__$1;
(statearr_28563_28650[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (3))){
var inst_28554 = (state_28556[(2)]);
var state_28556__$1 = state_28556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28556__$1,inst_28554);
} else {
if((state_val_28557 === (12))){
var inst_28551 = (state_28556[(2)]);
var _ = (function (){var statearr_28564 = state_28556;
(statearr_28564[(4)] = cljs.core.rest((state_28556[(4)])));

return statearr_28564;
})();
var state_28556__$1 = state_28556;
var statearr_28565_28651 = state_28556__$1;
(statearr_28565_28651[(2)] = inst_28551);

(statearr_28565_28651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (2))){
var _ = (function (){var statearr_28566 = state_28556;
(statearr_28566[(4)] = cljs.core.cons((5),(state_28556[(4)])));

return statearr_28566;
})();
var inst_28530 = (30);
var inst_28532 = fluree.db.dbproto._rootdb(this$);
var inst_28533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28534 = [inst_28530,tag_name];
var inst_28535 = (new cljs.core.PersistentVector(null,2,(5),inst_28533,inst_28534,null));
var inst_28536 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_28532,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_28535);
var state_28556__$1 = state_28556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28556__$1,(6),inst_28536);
} else {
if((state_val_28557 === (11))){
var inst_28545 = (state_28556[(8)]);
var inst_28549 = inst_28545.s;
var state_28556__$1 = state_28556;
var statearr_28568_28652 = state_28556__$1;
(statearr_28568_28652[(2)] = inst_28549);

(statearr_28568_28652[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (9))){
var inst_28545 = (state_28556[(8)]);
var inst_28545__$1 = (state_28556[(2)]);
var inst_28546 = (inst_28545__$1 == null);
var state_28556__$1 = (function (){var statearr_28569 = state_28556;
(statearr_28569[(8)] = inst_28545__$1);

return statearr_28569;
})();
if(cljs.core.truth_(inst_28546)){
var statearr_28570_28653 = state_28556__$1;
(statearr_28570_28653[(1)] = (10));

} else {
var statearr_28571_28654 = state_28556__$1;
(statearr_28571_28654[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (5))){
var _ = (function (){var statearr_28572 = state_28556;
(statearr_28572[(4)] = cljs.core.rest((state_28556[(4)])));

return statearr_28572;
})();
var state_28556__$1 = state_28556;
var ex28567 = (state_28556__$1[(2)]);
var statearr_28573_28655 = state_28556__$1;
(statearr_28573_28655[(5)] = ex28567);


if((ex28567 instanceof Error)){
var statearr_28574_28656 = state_28556__$1;
(statearr_28574_28656[(1)] = (4));

(statearr_28574_28656[(5)] = null);

} else {
throw ex28567;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (10))){
var state_28556__$1 = state_28556;
var statearr_28575_28657 = state_28556__$1;
(statearr_28575_28657[(2)] = null);

(statearr_28575_28657[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28557 === (8))){
var inst_28539 = (state_28556[(7)]);
var inst_28543 = cljs.core.first(inst_28539);
var state_28556__$1 = state_28556;
var statearr_28576_28658 = state_28556__$1;
(statearr_28576_28658[(2)] = inst_28543);

(statearr_28576_28658[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_28577 = [null,null,null,null,null,null,null,null,null];
(statearr_28577[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_28577[(1)] = (1));

return statearr_28577;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_28556){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28556);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28578){var ex__2687__auto__ = e28578;
var statearr_28579_28659 = state_28556;
(statearr_28579_28659[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28556[(4)]))){
var statearr_28580_28660 = state_28556;
(statearr_28580_28660[(1)] = cljs.core.first((state_28556[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28661 = state_28556;
state_28556 = G__28661;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_28556){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_28556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28581 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28581[(6)] = c__2706__auto__);

return statearr_28581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28616){
var state_val_28617 = (state_28616[(1)]);
if((state_val_28617 === (7))){
var inst_28595 = typeof pred === 'string';
var state_28616__$1 = state_28616;
if(cljs.core.truth_(inst_28595)){
var statearr_28618_28662 = state_28616__$1;
(statearr_28618_28662[(1)] = (10));

} else {
var statearr_28619_28663 = state_28616__$1;
(statearr_28619_28663[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (1))){
var state_28616__$1 = state_28616;
var statearr_28620_28664 = state_28616__$1;
(statearr_28620_28664[(2)] = null);

(statearr_28620_28664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (4))){
var inst_28582 = (state_28616[(2)]);
var state_28616__$1 = state_28616;
var statearr_28621_28665 = state_28616__$1;
(statearr_28621_28665[(2)] = inst_28582);

(statearr_28621_28665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (15))){
var inst_28609 = (state_28616[(2)]);
var state_28616__$1 = state_28616;
var statearr_28622_28666 = state_28616__$1;
(statearr_28622_28666[(2)] = inst_28609);

(statearr_28622_28666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (13))){
var inst_28600 = (state_28616[(7)]);
var inst_28602 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28600),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_28603 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_28602);
var state_28616__$1 = state_28616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28616__$1,(16),inst_28603);
} else {
if((state_val_28617 === (6))){
var inst_28590 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_28616__$1 = state_28616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28616__$1,(9),inst_28590);
} else {
if((state_val_28617 === (3))){
var inst_28614 = (state_28616[(2)]);
var state_28616__$1 = state_28616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28616__$1,inst_28614);
} else {
if((state_val_28617 === (12))){
var inst_28600 = (state_28616[(7)]);
var inst_28600__$1 = (state_28616[(2)]);
var state_28616__$1 = (function (){var statearr_28623 = state_28616;
(statearr_28623[(7)] = inst_28600__$1);

return statearr_28623;
})();
if(cljs.core.truth_(inst_28600__$1)){
var statearr_28624_28667 = state_28616__$1;
(statearr_28624_28667[(1)] = (13));

} else {
var statearr_28625_28668 = state_28616__$1;
(statearr_28625_28668[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (2))){
var _ = (function (){var statearr_28626 = state_28616;
(statearr_28626[(4)] = cljs.core.cons((5),(state_28616[(4)])));

return statearr_28626;
})();
var inst_28588 = clojure.string.includes_QMARK_(tag_name,"/");
var state_28616__$1 = state_28616;
if(inst_28588){
var statearr_28627_28669 = state_28616__$1;
(statearr_28627_28669[(1)] = (6));

} else {
var statearr_28628_28670 = state_28616__$1;
(statearr_28628_28670[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (11))){
var inst_28598 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28616__$1 = state_28616;
var statearr_28630_28671 = state_28616__$1;
(statearr_28630_28671[(2)] = inst_28598);

(statearr_28630_28671[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (9))){
var inst_28592 = (state_28616[(2)]);
var inst_28593 = fluree.db.util.async.throw_err(inst_28592);
var state_28616__$1 = state_28616;
var statearr_28631_28672 = state_28616__$1;
(statearr_28631_28672[(2)] = inst_28593);

(statearr_28631_28672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (5))){
var _ = (function (){var statearr_28632 = state_28616;
(statearr_28632[(4)] = cljs.core.rest((state_28616[(4)])));

return statearr_28632;
})();
var state_28616__$1 = state_28616;
var ex28629 = (state_28616__$1[(2)]);
var statearr_28633_28673 = state_28616__$1;
(statearr_28633_28673[(5)] = ex28629);


if((ex28629 instanceof Error)){
var statearr_28634_28674 = state_28616__$1;
(statearr_28634_28674[(1)] = (4));

(statearr_28634_28674[(5)] = null);

} else {
throw ex28629;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (14))){
var state_28616__$1 = state_28616;
var statearr_28635_28675 = state_28616__$1;
(statearr_28635_28675[(2)] = null);

(statearr_28635_28675[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (16))){
var inst_28605 = (state_28616[(2)]);
var inst_28606 = fluree.db.util.async.throw_err(inst_28605);
var state_28616__$1 = state_28616;
var statearr_28636_28676 = state_28616__$1;
(statearr_28636_28676[(2)] = inst_28606);

(statearr_28636_28676[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (10))){
var state_28616__$1 = state_28616;
var statearr_28637_28677 = state_28616__$1;
(statearr_28637_28677[(2)] = pred);

(statearr_28637_28677[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28617 === (8))){
var inst_28611 = (state_28616[(2)]);
var _ = (function (){var statearr_28638 = state_28616;
(statearr_28638[(4)] = cljs.core.rest((state_28616[(4)])));

return statearr_28638;
})();
var state_28616__$1 = state_28616;
var statearr_28639_28678 = state_28616__$1;
(statearr_28639_28678[(2)] = inst_28611);

(statearr_28639_28678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_28640 = [null,null,null,null,null,null,null,null];
(statearr_28640[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_28640[(1)] = (1));

return statearr_28640;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_28616){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28616);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28641){var ex__2687__auto__ = e28641;
var statearr_28642_28679 = state_28616;
(statearr_28642_28679[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28616[(4)]))){
var statearr_28643_28680 = state_28616;
(statearr_28643_28680[(1)] = cljs.core.first((state_28616[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28681 = state_28616;
state_28616 = G__28681;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_28616){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_28616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28644 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28644[(6)] = c__2706__auto__);

return statearr_28644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k28683,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__28687 = k28683;
var G__28687__$1 = (((G__28687 instanceof cljs.core.Keyword))?G__28687.fqn:null);
switch (G__28687__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28683,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__28688){
var vec__28689 = p__28688;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28689,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28689,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28682){
var self__ = this;
var G__28682__$1 = this;
return (new cljs.core.RecordIter((0),G__28682__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__28692 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__28692(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28684,other28685){
var self__ = this;
var this28684__$1 = this;
return (((!((other28685 == null)))) && ((((this28684__$1.constructor === other28685.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.conn,other28685.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.network,other28685.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.dbid,other28685.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.block,other28685.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.t,other28685.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.tt_id,other28685.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.stats,other28685.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.spot,other28685.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.psot,other28685.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.post,other28685.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.opst,other28685.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.schema,other28685.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.settings,other28685.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.index_configs,other28685.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.schema_cache,other28685.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.novelty,other28685.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.permissions,other28685.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.fork,other28685.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.fork_block,other28685.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.current_db_fn,other28685.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28684__$1.__extmap,other28685.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k28683){
var self__ = this;
var this__5350__auto____$1 = this;
var G__28693 = k28683;
var G__28693__$1 = (((G__28693 instanceof cljs.core.Keyword))?G__28693.fqn:null);
switch (G__28693__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28683);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__28682){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__28694 = cljs.core.keyword_identical_QMARK_;
var expr__28695 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__28697 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__28698 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28697,G__28698) : pred__28694.call(null,G__28697,G__28698));
})())){
return (new fluree.db.graphdb.GraphDb(G__28682,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28699 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__28700 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28699,G__28700) : pred__28694.call(null,G__28699,G__28700));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__28682,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28701 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__28702 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28701,G__28702) : pred__28694.call(null,G__28701,G__28702));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__28682,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28703 = new cljs.core.Keyword(null,"block","block",664686210);
var G__28704 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28703,G__28704) : pred__28694.call(null,G__28703,G__28704));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__28682,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28705 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__28706 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28705,G__28706) : pred__28694.call(null,G__28705,G__28706));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__28682,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28707 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__28708 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28707,G__28708) : pred__28694.call(null,G__28707,G__28708));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__28682,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28709 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__28710 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28709,G__28710) : pred__28694.call(null,G__28709,G__28710));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__28682,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28711 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__28712 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28711,G__28712) : pred__28694.call(null,G__28711,G__28712));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__28682,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28713 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__28714 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28713,G__28714) : pred__28694.call(null,G__28713,G__28714));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__28682,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28715 = new cljs.core.Keyword(null,"post","post",269697687);
var G__28716 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28715,G__28716) : pred__28694.call(null,G__28715,G__28716));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__28682,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28717 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__28718 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28717,G__28718) : pred__28694.call(null,G__28717,G__28718));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__28682,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28719 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__28720 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28719,G__28720) : pred__28694.call(null,G__28719,G__28720));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__28682,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28721 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__28722 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28721,G__28722) : pred__28694.call(null,G__28721,G__28722));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__28682,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28723 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__28724 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28723,G__28724) : pred__28694.call(null,G__28723,G__28724));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__28682,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28725 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__28726 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28725,G__28726) : pred__28694.call(null,G__28725,G__28726));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__28682,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28727 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__28728 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28727,G__28728) : pred__28694.call(null,G__28727,G__28728));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__28682,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28729 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__28730 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28729,G__28730) : pred__28694.call(null,G__28729,G__28730));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__28682,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28731 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__28732 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28731,G__28732) : pred__28694.call(null,G__28731,G__28732));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__28682,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28733 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__28734 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28733,G__28734) : pred__28694.call(null,G__28733,G__28734));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__28682,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28735 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__28736 = expr__28695;
return (pred__28694.cljs$core$IFn$_invoke$arity$2 ? pred__28694.cljs$core$IFn$_invoke$arity$2(G__28735,G__28736) : pred__28694.call(null,G__28735,G__28736));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__28682,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__28682),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__28682){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__28682,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__28686){
var extmap__5385__auto__ = (function (){var G__28737 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28686,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__28686)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28737);
} else {
return G__28737;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__28686),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__28686),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
