// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__19566 = arguments.length;
switch (G__19566) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__19569 = arguments.length;
switch (G__19569) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___19622 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19600){
var state_val_19601 = (state_19600[(1)]);
if((state_val_19601 === (1))){
var state_19600__$1 = state_19600;
var statearr_19602_19623 = state_19600__$1;
(statearr_19602_19623[(2)] = null);

(statearr_19602_19623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (2))){
var _ = (function (){var statearr_19603 = state_19600;
(statearr_19603[(4)] = cljs.core.cons((5),(state_19600[(4)])));

return statearr_19603;
})();
var inst_19577 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_19600__$1 = state_19600;
if(cljs.core.truth_(inst_19577)){
var statearr_19604_19624 = state_19600__$1;
(statearr_19604_19624[(1)] = (6));

} else {
var statearr_19605_19625 = state_19600__$1;
(statearr_19605_19625[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (3))){
var inst_19598 = (state_19600[(2)]);
var state_19600__$1 = state_19600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19600__$1,inst_19598);
} else {
if((state_val_19601 === (4))){
var inst_19570 = (state_19600[(2)]);
var inst_19571 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_19570);
var state_19600__$1 = state_19600;
var statearr_19607_19626 = state_19600__$1;
(statearr_19607_19626[(2)] = inst_19571);

(statearr_19607_19626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (5))){
var _ = (function (){var statearr_19608 = state_19600;
(statearr_19608[(4)] = cljs.core.rest((state_19600[(4)])));

return statearr_19608;
})();
var state_19600__$1 = state_19600;
var ex19606 = (state_19600__$1[(2)]);
var statearr_19609_19627 = state_19600__$1;
(statearr_19609_19627[(5)] = ex19606);


var statearr_19610_19628 = state_19600__$1;
(statearr_19610_19628[(1)] = (4));

(statearr_19610_19628[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (6))){
var inst_19579 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19580 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_19581 = cljs.core.PersistentHashMap.fromArrays(inst_19579,inst_19580);
var inst_19582 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_19581);
var inst_19583 = (function(){throw inst_19582})();
var state_19600__$1 = state_19600;
var statearr_19611_19629 = state_19600__$1;
(statearr_19611_19629[(2)] = inst_19583);

(statearr_19611_19629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (7))){
var inst_19585 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19587 = [operation,data,pc,opts];
var inst_19588 = (new cljs.core.PersistentVector(null,4,(5),inst_19586,inst_19587,null));
var inst_19589 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19585,inst_19588);
var inst_19590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19591 = [operation,data,pc,opts];
var inst_19592 = (new cljs.core.PersistentVector(null,4,(5),inst_19590,inst_19591,null));
var inst_19593 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_19592], 0));
var state_19600__$1 = (function (){var statearr_19612 = state_19600;
(statearr_19612[(7)] = inst_19589);

return statearr_19612;
})();
var statearr_19613_19630 = state_19600__$1;
(statearr_19613_19630[(2)] = inst_19593);

(statearr_19613_19630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (8))){
var inst_19595 = (state_19600[(2)]);
var _ = (function (){var statearr_19614 = state_19600;
(statearr_19614[(4)] = cljs.core.rest((state_19600[(4)])));

return statearr_19614;
})();
var state_19600__$1 = state_19600;
var statearr_19615_19631 = state_19600__$1;
(statearr_19615_19631[(2)] = inst_19595);

(statearr_19615_19631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_19616 = [null,null,null,null,null,null,null,null];
(statearr_19616[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_19616[(1)] = (1));

return statearr_19616;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_19600){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19600);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19617){var ex__2687__auto__ = e19617;
var statearr_19618_19632 = state_19600;
(statearr_19618_19632[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19600[(4)]))){
var statearr_19619_19633 = state_19600;
(statearr_19619_19633[(1)] = cljs.core.first((state_19600[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19634 = state_19600;
state_19600 = G__19634;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_19600){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_19600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19620 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19620[(6)] = c__2706__auto___19622);

return statearr_19620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__19636 = arguments.length;
switch (G__19636) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__19637){
var map__19638 = p__19637;
var map__19638__$1 = cljs.core.__destructure_map(map__19638);
var opts = map__19638__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19638__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__19639 = session;
var map__19639__$1 = cljs.core.__destructure_map(map__19639);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19639__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19639__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19639__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___19666 = arguments.length;
var i__5770__auto___19667 = (0);
while(true){
if((i__5770__auto___19667 < len__5769__auto___19666)){
args__5775__auto__.push((arguments[i__5770__auto___19667]));

var G__19668 = (i__5770__auto___19667 + (1));
i__5770__auto___19667 = G__19668;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__19643){
var vec__19644 = p__19643;
var map__19647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19644,(0),null);
var map__19647__$1 = cljs.core.__destructure_map(map__19647);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19647__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19647__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__19644;
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19659){
var state_val_19660 = (state_19659[(1)]);
if((state_val_19660 === (1))){
var inst_19649 = session;
var inst_19650 = cljs.core.__destructure_map(inst_19649);
var inst_19651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19650,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19650,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19650,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19654 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_19655 = [inst_19651,inst_19652,toBlock,toTime];
var inst_19656 = cljs.core.PersistentHashMap.fromArrays(inst_19654,inst_19655);
var inst_19657 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_19653,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_19656);
var state_19659__$1 = state_19659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19659__$1,inst_19657);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_19661 = [null,null,null,null,null,null,null];
(statearr_19661[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_19661[(1)] = (1));

return statearr_19661;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_19659){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19659);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19662){var ex__2687__auto__ = e19662;
var statearr_19663_19669 = state_19659;
(statearr_19663_19669[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19659[(4)]))){
var statearr_19664_19670 = state_19659;
(statearr_19664_19670[(1)] = cljs.core.first((state_19659[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19671 = state_19659;
state_19659 = G__19671;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_19659){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_19659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19665 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19665[(6)] = c__2706__auto__);

return statearr_19665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq19641){
var G__19642 = cljs.core.first(seq19641);
var seq19641__$1 = cljs.core.next(seq19641);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19642,seq19641__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__19672 = session;
var map__19672__$1 = cljs.core.__destructure_map(map__19672);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19672__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19672__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19672__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__19674 = arguments.length;
switch (G__19674) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__19675 = opts;
var map__19675__$1 = cljs.core.__destructure_map(map__19675);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19675__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19675__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
