// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode.call(null,(16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js.call(null,iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67570 = arguments.length;
var i__5770__auto___67571 = (0);
while(true){
if((i__5770__auto___67571 < len__5769__auto___67570)){
args__5775__auto__.push((arguments[i__5770__auto___67571]));

var G__67572 = (i__5770__auto___67571 + (1));
i__5770__auto___67571 = G__67572;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__67564){
var vec__67565 = p__67564;
var map__67568 = cljs.core.nth.call(null,vec__67565,(0),null);
var map__67568__$1 = cljs.core.__destructure_map.call(null,map__67568);
var iv = cljs.core.get.call(null,map__67568__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.call(null,map__67568__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes.call(null,x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_.call(null,iv,key_ba,ba);
var G__67569 = cljs.core.keyword.call(null,output_format);
var G__67569__$1 = (((G__67569 instanceof cljs.core.Keyword))?G__67569.fqn:null);
switch (G__67569__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64.call(null,encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67569__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq67561){
var G__67562 = cljs.core.first.call(null,seq67561);
var seq67561__$1 = cljs.core.next.call(null,seq67561);
var G__67563 = cljs.core.first.call(null,seq67561__$1);
var seq67561__$2 = cljs.core.next.call(null,seq67561__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67562,G__67563,seq67561__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode.call(null,(16),cbc.decrypt(x_ba,cljs.core.clj__GT_js.call(null,iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67585 = arguments.length;
var i__5770__auto___67586 = (0);
while(true){
if((i__5770__auto___67586 < len__5769__auto___67585)){
args__5775__auto__.push((arguments[i__5770__auto___67586]));

var G__67587 = (i__5770__auto___67586 + (1));
i__5770__auto___67586 = G__67587;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__67578){
var vec__67579 = p__67578;
var map__67582 = cljs.core.nth.call(null,vec__67579,(0),null);
var map__67582__$1 = cljs.core.__destructure_map.call(null,map__67582);
var iv = cljs.core.get.call(null,map__67582__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.call(null,map__67582__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.call(null,map__67582__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__67583 = cljs.core.keyword.call(null,input_format);
var G__67583__$1 = (((G__67583 instanceof cljs.core.Keyword))?G__67583.fqn:null);
switch (G__67583__$1) {
case "hex":
return alphabase.core.hex__GT_bytes.call(null,x);

break;
case "base64":
return alphabase.core.base64__GT_bytes.call(null,x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67583__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_.call(null,iv,key_ba,x_ba);
var G__67584 = cljs.core.keyword.call(null,output_format);
var G__67584__$1 = (((G__67584 instanceof cljs.core.Keyword))?G__67584.fqn:null);
switch (G__67584__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string.call(null,decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67584__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq67575){
var G__67576 = cljs.core.first.call(null,seq67575);
var seq67575__$1 = cljs.core.next.call(null,seq67575);
var G__67577 = cljs.core.first.call(null,seq67575__$1);
var seq67575__$2 = cljs.core.next.call(null,seq67575__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67576,G__67577,seq67575__$2);
}));

