// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__48250 = arguments.length;
switch (G__48250) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2743__auto___48289 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48271){
var state_val_48272 = (state_48271[(1)]);
if((state_val_48272 === (1))){
var state_48271__$1 = state_48271;
var statearr_48273_48290 = state_48271__$1;
(statearr_48273_48290[(2)] = null);

(statearr_48273_48290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48272 === (2))){
var _ = (function (){var statearr_48274 = state_48271;
(statearr_48274[(4)] = cljs.core.cons.call(null,(5),(state_48271[(4)])));

return statearr_48274;
})();
var inst_48257 = fluree.db.session.db.call(null,conn,ledger,null);
var state_48271__$1 = state_48271;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48271__$1,(7),inst_48257);
} else {
if((state_val_48272 === (3))){
var inst_48267 = (state_48271[(2)]);
var inst_48268 = cljs.core.async.put_BANG_.call(null,pc,inst_48267);
var inst_48269 = cljs.core.async.close_BANG_.call(null,pc);
var state_48271__$1 = (function (){var statearr_48276 = state_48271;
(statearr_48276[(7)] = inst_48268);

return statearr_48276;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48271__$1,inst_48269);
} else {
if((state_val_48272 === (4))){
var inst_48251 = (state_48271[(2)]);
var state_48271__$1 = state_48271;
var statearr_48277_48291 = state_48271__$1;
(statearr_48277_48291[(2)] = inst_48251);

(statearr_48277_48291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48272 === (5))){
var _ = (function (){var statearr_48278 = state_48271;
(statearr_48278[(4)] = cljs.core.rest.call(null,(state_48271[(4)])));

return statearr_48278;
})();
var state_48271__$1 = state_48271;
var ex48275 = (state_48271__$1[(2)]);
var statearr_48279_48292 = state_48271__$1;
(statearr_48279_48292[(5)] = ex48275);


var statearr_48280_48293 = state_48271__$1;
(statearr_48280_48293[(1)] = (4));

(statearr_48280_48293[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48272 === (6))){
var inst_48263 = (state_48271[(2)]);
var inst_48264 = fluree.db.util.async.throw_err.call(null,inst_48263);
var _ = (function (){var statearr_48281 = state_48271;
(statearr_48281[(4)] = cljs.core.rest.call(null,(state_48271[(4)])));

return statearr_48281;
})();
var state_48271__$1 = state_48271;
var statearr_48282_48294 = state_48271__$1;
(statearr_48282_48294[(2)] = inst_48264);

(statearr_48282_48294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48272 === (7))){
var inst_48259 = (state_48271[(2)]);
var inst_48260 = fluree.db.util.async.throw_err.call(null,inst_48259);
var inst_48261 = fluree.db.time_travel.as_of_block.call(null,inst_48260,block);
var state_48271__$1 = state_48271;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48271__$1,(6),inst_48261);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2721__auto__ = null;
var fluree$db$api$ledger$state_machine__2721__auto____0 = (function (){
var statearr_48283 = [null,null,null,null,null,null,null,null];
(statearr_48283[(0)] = fluree$db$api$ledger$state_machine__2721__auto__);

(statearr_48283[(1)] = (1));

return statearr_48283;
});
var fluree$db$api$ledger$state_machine__2721__auto____1 = (function (state_48271){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48284){var ex__2724__auto__ = e48284;
var statearr_48285_48295 = state_48271;
(statearr_48285_48295[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48271[(4)]))){
var statearr_48286_48296 = state_48271;
(statearr_48286_48296[(1)] = cljs.core.first.call(null,(state_48271[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48297 = state_48271;
state_48271 = G__48297;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2721__auto__ = function(state_48271){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2721__auto____1.call(this,state_48271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2721__auto____0;
fluree$db$api$ledger$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2721__auto____1;
return fluree$db$api$ledger$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48287 = f__2744__auto__.call(null);
(statearr_48287[(6)] = c__2743__auto___48289);

return statearr_48287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48338){
var state_val_48339 = (state_48338[(1)]);
if((state_val_48339 === (7))){
var inst_48307 = cljs.core._EQ_.call(null,(0),auth);
var state_48338__$1 = state_48338;
if(inst_48307){
var statearr_48340_48371 = state_48338__$1;
(statearr_48340_48371[(1)] = (9));

} else {
var statearr_48341_48372 = state_48338__$1;
(statearr_48341_48372[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (1))){
var state_48338__$1 = state_48338;
var statearr_48342_48373 = state_48338__$1;
(statearr_48342_48373[(2)] = null);

(statearr_48342_48373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (4))){
var inst_48298 = (state_48338[(2)]);
var state_48338__$1 = state_48338;
var statearr_48343_48374 = state_48338__$1;
(statearr_48343_48374[(2)] = inst_48298);

(statearr_48343_48374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (15))){
var inst_48315 = (state_48338[(7)]);
var inst_48314 = (state_48338[(2)]);
var inst_48315__$1 = fluree.db.util.async.throw_err.call(null,inst_48314);
var state_48338__$1 = (function (){var statearr_48344 = state_48338;
(statearr_48344[(7)] = inst_48315__$1);

return statearr_48344;
})();
if(cljs.core.truth_(inst_48315__$1)){
var statearr_48345_48375 = state_48338__$1;
(statearr_48345_48375[(1)] = (16));

} else {
var statearr_48346_48376 = state_48338__$1;
(statearr_48346_48376[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (13))){
var state_48338__$1 = state_48338;
var statearr_48347_48377 = state_48338__$1;
(statearr_48347_48377[(2)] = null);

(statearr_48347_48377[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (6))){
var state_48338__$1 = state_48338;
var statearr_48348_48378 = state_48338__$1;
(statearr_48348_48378[(2)] = db);

(statearr_48348_48378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (17))){
var inst_48319 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_48320 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_48321 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_48322 = cljs.core.PersistentHashMap.fromArrays(inst_48320,inst_48321);
var inst_48323 = cljs.core.ex_info.call(null,inst_48319,inst_48322);
var inst_48324 = (function(){throw inst_48323})();
var state_48338__$1 = state_48338;
var statearr_48349_48379 = state_48338__$1;
(statearr_48349_48379[(2)] = inst_48324);

(statearr_48349_48379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (3))){
var inst_48336 = (state_48338[(2)]);
var state_48338__$1 = state_48338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48338__$1,inst_48336);
} else {
if((state_val_48339 === (12))){
var inst_48312 = fluree.db.dbproto._subid.call(null,db,auth);
var state_48338__$1 = state_48338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48338__$1,(15),inst_48312);
} else {
if((state_val_48339 === (2))){
var _ = (function (){var statearr_48350 = state_48338;
(statearr_48350[(4)] = cljs.core.cons.call(null,(5),(state_48338[(4)])));

return statearr_48350;
})();
var inst_48304 = cljs.core.not.call(null,auth);
var state_48338__$1 = state_48338;
if(inst_48304){
var statearr_48351_48380 = state_48338__$1;
(statearr_48351_48380[(1)] = (6));

} else {
var statearr_48352_48381 = state_48338__$1;
(statearr_48352_48381[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (11))){
var inst_48331 = (state_48338[(2)]);
var state_48338__$1 = state_48338;
var statearr_48354_48382 = state_48338__$1;
(statearr_48354_48382[(2)] = inst_48331);

(statearr_48354_48382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (9))){
var inst_48309 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_48338__$1 = state_48338;
var statearr_48355_48383 = state_48338__$1;
(statearr_48355_48383[(2)] = inst_48309);

(statearr_48355_48383[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (5))){
var _ = (function (){var statearr_48356 = state_48338;
(statearr_48356[(4)] = cljs.core.rest.call(null,(state_48338[(4)])));

return statearr_48356;
})();
var state_48338__$1 = state_48338;
var ex48353 = (state_48338__$1[(2)]);
var statearr_48357_48384 = state_48338__$1;
(statearr_48357_48384[(5)] = ex48353);


if((ex48353 instanceof Error)){
var statearr_48358_48385 = state_48338__$1;
(statearr_48358_48385[(1)] = (4));

(statearr_48358_48385[(5)] = null);

} else {
throw ex48353;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (14))){
var inst_48329 = (state_48338[(2)]);
var state_48338__$1 = state_48338;
var statearr_48359_48386 = state_48338__$1;
(statearr_48359_48386[(2)] = inst_48329);

(statearr_48359_48386[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (16))){
var inst_48315 = (state_48338[(7)]);
var inst_48317 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_48315);
var state_48338__$1 = state_48338;
var statearr_48360_48387 = state_48338__$1;
(statearr_48360_48387[(2)] = inst_48317);

(statearr_48360_48387[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (10))){
var state_48338__$1 = state_48338;
var statearr_48361_48388 = state_48338__$1;
(statearr_48361_48388[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (18))){
var inst_48326 = (state_48338[(2)]);
var state_48338__$1 = state_48338;
var statearr_48363_48389 = state_48338__$1;
(statearr_48363_48389[(2)] = inst_48326);

(statearr_48363_48389[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48339 === (8))){
var inst_48333 = (state_48338[(2)]);
var _ = (function (){var statearr_48364 = state_48338;
(statearr_48364[(4)] = cljs.core.rest.call(null,(state_48338[(4)])));

return statearr_48364;
})();
var state_48338__$1 = state_48338;
var statearr_48365_48390 = state_48338__$1;
(statearr_48365_48390[(2)] = inst_48333);

(statearr_48365_48390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto____0 = (function (){
var statearr_48366 = [null,null,null,null,null,null,null,null];
(statearr_48366[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto__);

(statearr_48366[(1)] = (1));

return statearr_48366;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto____1 = (function (state_48338){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48367){var ex__2724__auto__ = e48367;
var statearr_48368_48391 = state_48338;
(statearr_48368_48391[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48338[(4)]))){
var statearr_48369_48392 = state_48338;
(statearr_48369_48392[(1)] = cljs.core.first.call(null,(state_48338[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48393 = state_48338;
state_48338 = G__48393;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto__ = function(state_48338){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto____1.call(this,state_48338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48370 = f__2744__auto__.call(null);
(statearr_48370[(6)] = c__2743__auto__);

return statearr_48370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48457){
var state_val_48458 = (state_48457[(1)]);
if((state_val_48458 === (7))){
var inst_48403 = cljs.core._EQ_.call(null,(0),auth);
var state_48457__$1 = state_48457;
if(inst_48403){
var statearr_48459_48508 = state_48457__$1;
(statearr_48459_48508[(1)] = (9));

} else {
var statearr_48460_48509 = state_48457__$1;
(statearr_48460_48509[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (20))){
var inst_48427 = (state_48457[(7)]);
var state_48457__$1 = state_48457;
if(cljs.core.truth_(inst_48427)){
var statearr_48461_48510 = state_48457__$1;
(statearr_48461_48510[(1)] = (22));

} else {
var statearr_48462_48511 = state_48457__$1;
(statearr_48462_48511[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (27))){
var state_48457__$1 = state_48457;
var statearr_48463_48512 = state_48457__$1;
(statearr_48463_48512[(2)] = null);

(statearr_48463_48512[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (1))){
var state_48457__$1 = state_48457;
var statearr_48464_48513 = state_48457__$1;
(statearr_48464_48513[(2)] = null);

(statearr_48464_48513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (24))){
var inst_48441 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48465_48514 = state_48457__$1;
(statearr_48465_48514[(2)] = inst_48441);

(statearr_48465_48514[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (4))){
var inst_48394 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48466_48515 = state_48457__$1;
(statearr_48466_48515[(2)] = inst_48394);

(statearr_48466_48515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (15))){
var inst_48410 = (state_48457[(8)]);
var inst_48409 = (state_48457[(2)]);
var inst_48410__$1 = fluree.db.util.async.throw_err.call(null,inst_48409);
var state_48457__$1 = (function (){var statearr_48467 = state_48457;
(statearr_48467[(8)] = inst_48410__$1);

return statearr_48467;
})();
if(cljs.core.truth_(inst_48410__$1)){
var statearr_48468_48516 = state_48457__$1;
(statearr_48468_48516[(1)] = (16));

} else {
var statearr_48469_48517 = state_48457__$1;
(statearr_48469_48517[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (21))){
var inst_48443 = (state_48457[(9)]);
var inst_48443__$1 = (state_48457[(2)]);
var state_48457__$1 = (function (){var statearr_48470 = state_48457;
(statearr_48470[(9)] = inst_48443__$1);

return statearr_48470;
})();
if(cljs.core.truth_(inst_48443__$1)){
var statearr_48471_48518 = state_48457__$1;
(statearr_48471_48518[(1)] = (29));

} else {
var statearr_48472_48519 = state_48457__$1;
(statearr_48472_48519[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (31))){
var inst_48443 = (state_48457[(9)]);
var inst_48427 = (state_48457[(7)]);
var inst_48451 = (state_48457[(2)]);
var inst_48452 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_48427,new cljs.core.Keyword(null,"roles","roles",143379530),inst_48443,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_48451);
var _ = (function (){var statearr_48473 = state_48457;
(statearr_48473[(4)] = cljs.core.rest.call(null,(state_48457[(4)])));

return statearr_48473;
})();
var state_48457__$1 = state_48457;
var statearr_48474_48520 = state_48457__$1;
(statearr_48474_48520[(2)] = inst_48452);

(statearr_48474_48520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (32))){
var inst_48447 = (state_48457[(2)]);
var inst_48448 = fluree.db.util.async.throw_err.call(null,inst_48447);
var state_48457__$1 = state_48457;
var statearr_48475_48521 = state_48457__$1;
(statearr_48475_48521[(2)] = inst_48448);

(statearr_48475_48521[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (13))){
var state_48457__$1 = state_48457;
var statearr_48476_48522 = state_48457__$1;
(statearr_48476_48522[(2)] = null);

(statearr_48476_48522[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (22))){
var inst_48427 = (state_48457[(7)]);
var inst_48431 = fluree.db.auth.roles.call(null,db,inst_48427);
var state_48457__$1 = state_48457;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48457__$1,(25),inst_48431);
} else {
if((state_val_48458 === (29))){
var inst_48443 = (state_48457[(9)]);
var inst_48445 = fluree.db.permissions.permission_map.call(null,db,inst_48443,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_48457__$1 = state_48457;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48457__$1,(32),inst_48445);
} else {
if((state_val_48458 === (6))){
var state_48457__$1 = state_48457;
var statearr_48477_48523 = state_48457__$1;
(statearr_48477_48523[(2)] = null);

(statearr_48477_48523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (28))){
var inst_48439 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48478_48524 = state_48457__$1;
(statearr_48478_48524[(2)] = inst_48439);

(statearr_48478_48524[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (25))){
var inst_48433 = (state_48457[(2)]);
var inst_48434 = fluree.db.util.async.throw_err.call(null,inst_48433);
var state_48457__$1 = state_48457;
var statearr_48479_48525 = state_48457__$1;
(statearr_48479_48525[(2)] = inst_48434);

(statearr_48479_48525[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (17))){
var inst_48413 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_48414 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_48415 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_48416 = cljs.core.PersistentHashMap.fromArrays(inst_48414,inst_48415);
var inst_48417 = cljs.core.ex_info.call(null,inst_48413,inst_48416);
var inst_48418 = (function(){throw inst_48417})();
var state_48457__$1 = state_48457;
var statearr_48480_48526 = state_48457__$1;
(statearr_48480_48526[(2)] = inst_48418);

(statearr_48480_48526[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (3))){
var inst_48455 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48457__$1,inst_48455);
} else {
if((state_val_48458 === (12))){
var inst_48407 = fluree.db.dbproto._subid.call(null,db,auth);
var state_48457__$1 = state_48457;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48457__$1,(15),inst_48407);
} else {
if((state_val_48458 === (2))){
var _ = (function (){var statearr_48481 = state_48457;
(statearr_48481[(4)] = cljs.core.cons.call(null,(5),(state_48457[(4)])));

return statearr_48481;
})();
var inst_48400 = (auth == null);
var state_48457__$1 = state_48457;
if(cljs.core.truth_(inst_48400)){
var statearr_48482_48527 = state_48457__$1;
(statearr_48482_48527[(1)] = (6));

} else {
var statearr_48483_48528 = state_48457__$1;
(statearr_48483_48528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (23))){
var state_48457__$1 = state_48457;
var statearr_48484_48529 = state_48457__$1;
(statearr_48484_48529[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (19))){
var state_48457__$1 = state_48457;
var statearr_48486_48530 = state_48457__$1;
(statearr_48486_48530[(2)] = roles);

(statearr_48486_48530[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (11))){
var inst_48425 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48488_48531 = state_48457__$1;
(statearr_48488_48531[(2)] = inst_48425);

(statearr_48488_48531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (9))){
var state_48457__$1 = state_48457;
var statearr_48489_48532 = state_48457__$1;
(statearr_48489_48532[(2)] = (0));

(statearr_48489_48532[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (5))){
var _ = (function (){var statearr_48490 = state_48457;
(statearr_48490[(4)] = cljs.core.rest.call(null,(state_48457[(4)])));

return statearr_48490;
})();
var state_48457__$1 = state_48457;
var ex48487 = (state_48457__$1[(2)]);
var statearr_48491_48533 = state_48457__$1;
(statearr_48491_48533[(5)] = ex48487);


if((ex48487 instanceof Error)){
var statearr_48492_48534 = state_48457__$1;
(statearr_48492_48534[(1)] = (4));

(statearr_48492_48534[(5)] = null);

} else {
throw ex48487;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (14))){
var inst_48423 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48493_48535 = state_48457__$1;
(statearr_48493_48535[(2)] = inst_48423);

(statearr_48493_48535[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (26))){
var state_48457__$1 = state_48457;
var statearr_48494_48536 = state_48457__$1;
(statearr_48494_48536[(2)] = null);

(statearr_48494_48536[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (16))){
var inst_48410 = (state_48457[(8)]);
var state_48457__$1 = state_48457;
var statearr_48495_48537 = state_48457__$1;
(statearr_48495_48537[(2)] = inst_48410);

(statearr_48495_48537[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (30))){
var state_48457__$1 = state_48457;
var statearr_48496_48538 = state_48457__$1;
(statearr_48496_48538[(2)] = null);

(statearr_48496_48538[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (10))){
var state_48457__$1 = state_48457;
if(cljs.core.truth_(auth)){
var statearr_48497_48539 = state_48457__$1;
(statearr_48497_48539[(1)] = (12));

} else {
var statearr_48498_48540 = state_48457__$1;
(statearr_48498_48540[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (18))){
var inst_48420 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48499_48541 = state_48457__$1;
(statearr_48499_48541[(2)] = inst_48420);

(statearr_48499_48541[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (8))){
var inst_48427 = (state_48457[(2)]);
var state_48457__$1 = (function (){var statearr_48500 = state_48457;
(statearr_48500[(7)] = inst_48427);

return statearr_48500;
})();
if(cljs.core.truth_(roles)){
var statearr_48501_48542 = state_48457__$1;
(statearr_48501_48542[(1)] = (19));

} else {
var statearr_48502_48543 = state_48457__$1;
(statearr_48502_48543[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto____0 = (function (){
var statearr_48503 = [null,null,null,null,null,null,null,null,null,null];
(statearr_48503[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto__);

(statearr_48503[(1)] = (1));

return statearr_48503;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto____1 = (function (state_48457){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48457);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48504){var ex__2724__auto__ = e48504;
var statearr_48505_48544 = state_48457;
(statearr_48505_48544[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48457[(4)]))){
var statearr_48506_48545 = state_48457;
(statearr_48506_48545[(1)] = cljs.core.first.call(null,(state_48457[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48546 = state_48457;
state_48457 = G__48546;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto__ = function(state_48457){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto____1.call(this,state_48457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48507 = f__2744__auto__.call(null);
(statearr_48507[(6)] = c__2743__auto__);

return statearr_48507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__48547 = db;
var map__48547__$1 = cljs.core.__destructure_map.call(null,map__48547);
var conn = cljs.core.get.call(null,map__48547__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__48547__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__48547__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48554){
var state_val_48555 = (state_48554[(1)]);
if((state_val_48555 === (1))){
var inst_48548 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_48549 = fluree.db.session.db.call(null,conn,inst_48548,null);
var state_48554__$1 = state_48554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48554__$1,(2),inst_48549);
} else {
if((state_val_48555 === (2))){
var inst_48551 = (state_48554[(2)]);
var inst_48552 = cljs.core.async.put_BANG_.call(null,resp_port,inst_48551);
var state_48554__$1 = state_48554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48554__$1,inst_48552);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____0 = (function (){
var statearr_48556 = [null,null,null,null,null,null,null];
(statearr_48556[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__);

(statearr_48556[(1)] = (1));

return statearr_48556;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____1 = (function (state_48554){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48557){var ex__2724__auto__ = e48557;
var statearr_48558_48585 = state_48554;
(statearr_48558_48585[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48554[(4)]))){
var statearr_48559_48586 = state_48554;
(statearr_48559_48586[(1)] = cljs.core.first.call(null,(state_48554[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48587 = state_48554;
state_48554 = G__48587;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__ = function(state_48554){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____1.call(this,state_48554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48560 = f__2744__auto__.call(null);
(statearr_48560[(6)] = c__2743__auto__);

return statearr_48560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48573){
var state_val_48574 = (state_48573[(1)]);
if((state_val_48574 === (1))){
var inst_48561 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_48562 = fluree.db.session.db.call(null,conn,inst_48561,null);
var state_48573__$1 = state_48573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48573__$1,(2),inst_48562);
} else {
if((state_val_48574 === (2))){
var inst_48564 = (state_48573[(7)]);
var inst_48564__$1 = (state_48573[(2)]);
var inst_48565 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_48564__$1);
var inst_48566 = newer_block_QMARK_.call(null,inst_48565);
var state_48573__$1 = (function (){var statearr_48575 = state_48573;
(statearr_48575[(7)] = inst_48564__$1);

return statearr_48575;
})();
if(inst_48566){
var statearr_48576_48588 = state_48573__$1;
(statearr_48576_48588[(1)] = (3));

} else {
var statearr_48577_48589 = state_48573__$1;
(statearr_48577_48589[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48574 === (3))){
var inst_48564 = (state_48573[(7)]);
var inst_48568 = cljs.core.async.put_BANG_.call(null,resp_port,inst_48564);
var state_48573__$1 = state_48573;
var statearr_48578_48590 = state_48573__$1;
(statearr_48578_48590[(2)] = inst_48568);

(statearr_48578_48590[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48574 === (4))){
var state_48573__$1 = state_48573;
var statearr_48579_48591 = state_48573__$1;
(statearr_48579_48591[(2)] = null);

(statearr_48579_48591[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48574 === (5))){
var inst_48571 = (state_48573[(2)]);
var state_48573__$1 = state_48573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48573__$1,inst_48571);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____0 = (function (){
var statearr_48580 = [null,null,null,null,null,null,null,null];
(statearr_48580[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__);

(statearr_48580[(1)] = (1));

return statearr_48580;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____1 = (function (state_48573){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48581){var ex__2724__auto__ = e48581;
var statearr_48582_48592 = state_48573;
(statearr_48582_48592[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48573[(4)]))){
var statearr_48583_48593 = state_48573;
(statearr_48583_48593[(1)] = cljs.core.first.call(null,(state_48573[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48594 = state_48573;
state_48573 = G__48594;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__ = function(state_48573){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____1.call(this,state_48573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48584 = f__2744__auto__.call(null);
(statearr_48584[(6)] = c__2743__auto__);

return statearr_48584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__48595 = db;
var map__48595__$1 = cljs.core.__destructure_map.call(null,map__48595);
var conn = cljs.core.get.call(null,map__48595__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__48595__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__48595__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2743__auto___48671 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48645){
var state_val_48646 = (state_48645[(1)]);
if((state_val_48646 === (7))){
var inst_48611 = (state_48645[(7)]);
var inst_48622 = cljs.core._EQ_.call(null,inst_48611,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_48645__$1 = state_48645;
if(inst_48622){
var statearr_48647_48672 = state_48645__$1;
(statearr_48647_48672[(1)] = (9));

} else {
var statearr_48648_48673 = state_48645__$1;
(statearr_48648_48673[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (1))){
var inst_48604 = (state_48645[(8)]);
var inst_48596 = (state_48645[(9)]);
var inst_48596__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_48604__$1 = res_port;
var inst_48605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48606 = [inst_48596__$1,inst_48604__$1];
var inst_48607 = (new cljs.core.PersistentVector(null,2,(5),inst_48605,inst_48606,null));
var state_48645__$1 = (function (){var statearr_48649 = state_48645;
(statearr_48649[(8)] = inst_48604__$1);

(statearr_48649[(9)] = inst_48596__$1);

return statearr_48649;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_48645__$1,(2),inst_48607);
} else {
if((state_val_48646 === (4))){
var inst_48611 = (state_48645[(7)]);
var inst_48604 = (state_48645[(8)]);
var inst_48615 = cljs.core._EQ_.call(null,inst_48611,inst_48604);
var state_48645__$1 = state_48645;
if(inst_48615){
var statearr_48650_48674 = state_48645__$1;
(statearr_48650_48674[(1)] = (6));

} else {
var statearr_48651_48675 = state_48645__$1;
(statearr_48651_48675[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (13))){
var inst_48630 = (state_48645[(10)]);
var inst_48641 = cljs.core.async.put_BANG_.call(null,pc,inst_48630);
var state_48645__$1 = state_48645;
var statearr_48652_48676 = state_48645__$1;
(statearr_48652_48676[(2)] = inst_48641);

(statearr_48652_48676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (6))){
var inst_48609 = (state_48645[(11)]);
var inst_48620 = cljs.core.nth.call(null,inst_48609,(0),null);
var state_48645__$1 = state_48645;
var statearr_48653_48677 = state_48645__$1;
(statearr_48653_48677[(2)] = inst_48620);

(statearr_48653_48677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (3))){
var state_48645__$1 = state_48645;
var statearr_48654_48678 = state_48645__$1;
(statearr_48654_48678[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_48654_48678[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (12))){
var inst_48634 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_48635 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_48636 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_48637 = cljs.core.PersistentHashMap.fromArrays(inst_48635,inst_48636);
var inst_48638 = cljs.core.ex_info.call(null,inst_48634,inst_48637);
var inst_48639 = cljs.core.async.put_BANG_.call(null,pc,inst_48638);
var state_48645__$1 = state_48645;
var statearr_48655_48679 = state_48645__$1;
(statearr_48655_48679[(2)] = inst_48639);

(statearr_48655_48679[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (2))){
var inst_48611 = (state_48645[(7)]);
var inst_48609 = (state_48645[(11)]);
var inst_48596 = (state_48645[(9)]);
var inst_48609__$1 = (state_48645[(2)]);
var inst_48610 = cljs.core.nth.call(null,inst_48609__$1,(0),null);
var inst_48611__$1 = cljs.core.nth.call(null,inst_48609__$1,(1),null);
var inst_48612 = cljs.core._EQ_.call(null,inst_48611__$1,inst_48596);
var state_48645__$1 = (function (){var statearr_48656 = state_48645;
(statearr_48656[(7)] = inst_48611__$1);

(statearr_48656[(12)] = inst_48610);

(statearr_48656[(11)] = inst_48609__$1);

return statearr_48656;
})();
if(inst_48612){
var statearr_48657_48680 = state_48645__$1;
(statearr_48657_48680[(1)] = (3));

} else {
var statearr_48658_48681 = state_48645__$1;
(statearr_48658_48681[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (11))){
var inst_48626 = (state_48645[(2)]);
var state_48645__$1 = state_48645;
var statearr_48659_48682 = state_48645__$1;
(statearr_48659_48682[(2)] = inst_48626);

(statearr_48659_48682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (9))){
var inst_48610 = (state_48645[(12)]);
var state_48645__$1 = state_48645;
var statearr_48660_48683 = state_48645__$1;
(statearr_48660_48683[(2)] = inst_48610);

(statearr_48660_48683[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (5))){
var inst_48630 = (state_48645[(10)]);
var inst_48630__$1 = (state_48645[(2)]);
var inst_48631 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_48632 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_48630__$1);
var state_48645__$1 = (function (){var statearr_48661 = state_48645;
(statearr_48661[(13)] = inst_48631);

(statearr_48661[(10)] = inst_48630__$1);

return statearr_48661;
})();
if(inst_48632){
var statearr_48662_48684 = state_48645__$1;
(statearr_48662_48684[(1)] = (12));

} else {
var statearr_48663_48685 = state_48645__$1;
(statearr_48663_48685[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (14))){
var inst_48643 = (state_48645[(2)]);
var state_48645__$1 = state_48645;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48645__$1,inst_48643);
} else {
if((state_val_48646 === (10))){
var state_48645__$1 = state_48645;
var statearr_48664_48686 = state_48645__$1;
(statearr_48664_48686[(2)] = null);

(statearr_48664_48686[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48646 === (8))){
var inst_48628 = (state_48645[(2)]);
var state_48645__$1 = state_48645;
var statearr_48665_48687 = state_48645__$1;
(statearr_48665_48687[(2)] = inst_48628);

(statearr_48665_48687[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto____0 = (function (){
var statearr_48666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48666[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto__);

(statearr_48666[(1)] = (1));

return statearr_48666;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto____1 = (function (state_48645){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48645);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48667){var ex__2724__auto__ = e48667;
var statearr_48668_48688 = state_48645;
(statearr_48668_48688[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48645[(4)]))){
var statearr_48669_48689 = state_48645;
(statearr_48669_48689[(1)] = cljs.core.first.call(null,(state_48645[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48690 = state_48645;
state_48645 = G__48690;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto__ = function(state_48645){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto____1.call(this,state_48645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48670 = f__2744__auto__.call(null);
(statearr_48670[(6)] = c__2743__auto___48671);

return statearr_48670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__48692 = arguments.length;
switch (G__48692) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__48693){
var map__48694 = p__48693;
var map__48694__$1 = cljs.core.__destructure_map.call(null,map__48694);
var opts = map__48694__$1;
var roles = cljs.core.get.call(null,map__48694__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__48694__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__48694__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__48694__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__48694__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2743__auto___48783 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48745){
var state_val_48746 = (state_48745[(1)]);
if((state_val_48746 === (7))){
var inst_48707 = (state_48745[(7)]);
var inst_48709 = fluree.db.api.ledger.syncTo_db.call(null,inst_48707,syncTo,syncTimeout);
var state_48745__$1 = state_48745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48745__$1,(10),inst_48709);
} else {
if((state_val_48746 === (20))){
var inst_48731 = (state_48745[(8)]);
var state_48745__$1 = state_48745;
var statearr_48747_48784 = state_48745__$1;
(statearr_48747_48784[(2)] = inst_48731);

(statearr_48747_48784[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (1))){
var state_48745__$1 = state_48745;
var statearr_48748_48785 = state_48745__$1;
(statearr_48748_48785[(2)] = null);

(statearr_48748_48785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (4))){
var inst_48695 = (state_48745[(2)]);
var inst_48696 = cljs.core.async.put_BANG_.call(null,pc,inst_48695);
var inst_48697 = cljs.core.async.close_BANG_.call(null,pc);
var state_48745__$1 = (function (){var statearr_48749 = state_48745;
(statearr_48749[(9)] = inst_48696);

return statearr_48749;
})();
var statearr_48750_48786 = state_48745__$1;
(statearr_48750_48786[(2)] = inst_48697);

(statearr_48750_48786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (15))){
var inst_48723 = (state_48745[(10)]);
var inst_48725 = fluree.db.api.ledger.add_db_permissions.call(null,inst_48723,auth,roles);
var state_48745__$1 = state_48745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48745__$1,(18),inst_48725);
} else {
if((state_val_48746 === (21))){
var inst_48739 = (state_48745[(2)]);
var inst_48740 = cljs.core.async.put_BANG_.call(null,pc,inst_48739);
var _ = (function (){var statearr_48751 = state_48745;
(statearr_48751[(4)] = cljs.core.rest.call(null,(state_48745[(4)])));

return statearr_48751;
})();
var state_48745__$1 = state_48745;
var statearr_48752_48787 = state_48745__$1;
(statearr_48752_48787[(2)] = inst_48740);

(statearr_48752_48787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (13))){
var inst_48723 = (state_48745[(2)]);
var state_48745__$1 = (function (){var statearr_48753 = state_48745;
(statearr_48753[(10)] = inst_48723);

return statearr_48753;
})();
if(cljs.core.truth_(roles)){
var statearr_48754_48788 = state_48745__$1;
(statearr_48754_48788[(1)] = (15));

} else {
var statearr_48755_48789 = state_48745__$1;
(statearr_48755_48789[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (22))){
var inst_48735 = (state_48745[(2)]);
var inst_48736 = fluree.db.util.async.throw_err.call(null,inst_48735);
var state_48745__$1 = state_48745;
var statearr_48756_48790 = state_48745__$1;
(statearr_48756_48790[(2)] = inst_48736);

(statearr_48756_48790[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (6))){
var inst_48706 = (state_48745[(2)]);
var inst_48707 = fluree.db.util.async.throw_err.call(null,inst_48706);
var state_48745__$1 = (function (){var statearr_48757 = state_48745;
(statearr_48757[(7)] = inst_48707);

return statearr_48757;
})();
if(cljs.core.truth_(syncTo)){
var statearr_48758_48791 = state_48745__$1;
(statearr_48758_48791[(1)] = (7));

} else {
var statearr_48759_48792 = state_48745__$1;
(statearr_48759_48792[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (17))){
var inst_48731 = (state_48745[(2)]);
var state_48745__$1 = (function (){var statearr_48760 = state_48745;
(statearr_48760[(8)] = inst_48731);

return statearr_48760;
})();
if(cljs.core.truth_(auth)){
var statearr_48761_48793 = state_48745__$1;
(statearr_48761_48793[(1)] = (19));

} else {
var statearr_48762_48794 = state_48745__$1;
(statearr_48762_48794[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (3))){
var inst_48743 = (state_48745[(2)]);
var state_48745__$1 = state_48745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48745__$1,inst_48743);
} else {
if((state_val_48746 === (12))){
var inst_48715 = (state_48745[(11)]);
var state_48745__$1 = state_48745;
var statearr_48763_48795 = state_48745__$1;
(statearr_48763_48795[(2)] = inst_48715);

(statearr_48763_48795[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (2))){
var _ = (function (){var statearr_48764 = state_48745;
(statearr_48764[(4)] = cljs.core.cons.call(null,(5),(state_48745[(4)])));

return statearr_48764;
})();
var inst_48704 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_48745__$1 = state_48745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48745__$1,(6),inst_48704);
} else {
if((state_val_48746 === (19))){
var inst_48731 = (state_48745[(8)]);
var inst_48733 = fluree.db.api.ledger.add_db_permissions.call(null,inst_48731,auth,roles);
var state_48745__$1 = state_48745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48745__$1,(22),inst_48733);
} else {
if((state_val_48746 === (11))){
var inst_48715 = (state_48745[(11)]);
var inst_48717 = fluree.db.time_travel.as_of_block.call(null,inst_48715,block);
var state_48745__$1 = state_48745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48745__$1,(14),inst_48717);
} else {
if((state_val_48746 === (9))){
var inst_48715 = (state_48745[(2)]);
var state_48745__$1 = (function (){var statearr_48766 = state_48745;
(statearr_48766[(11)] = inst_48715);

return statearr_48766;
})();
if(cljs.core.truth_(block)){
var statearr_48767_48796 = state_48745__$1;
(statearr_48767_48796[(1)] = (11));

} else {
var statearr_48768_48797 = state_48745__$1;
(statearr_48768_48797[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (5))){
var _ = (function (){var statearr_48769 = state_48745;
(statearr_48769[(4)] = cljs.core.rest.call(null,(state_48745[(4)])));

return statearr_48769;
})();
var state_48745__$1 = state_48745;
var ex48765 = (state_48745__$1[(2)]);
var statearr_48770_48798 = state_48745__$1;
(statearr_48770_48798[(5)] = ex48765);


var statearr_48771_48799 = state_48745__$1;
(statearr_48771_48799[(1)] = (4));

(statearr_48771_48799[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (14))){
var inst_48719 = (state_48745[(2)]);
var inst_48720 = fluree.db.util.async.throw_err.call(null,inst_48719);
var state_48745__$1 = state_48745;
var statearr_48772_48800 = state_48745__$1;
(statearr_48772_48800[(2)] = inst_48720);

(statearr_48772_48800[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (16))){
var inst_48723 = (state_48745[(10)]);
var state_48745__$1 = state_48745;
var statearr_48773_48801 = state_48745__$1;
(statearr_48773_48801[(2)] = inst_48723);

(statearr_48773_48801[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (10))){
var inst_48711 = (state_48745[(2)]);
var inst_48712 = fluree.db.util.async.throw_err.call(null,inst_48711);
var state_48745__$1 = state_48745;
var statearr_48774_48802 = state_48745__$1;
(statearr_48774_48802[(2)] = inst_48712);

(statearr_48774_48802[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (18))){
var inst_48727 = (state_48745[(2)]);
var inst_48728 = fluree.db.util.async.throw_err.call(null,inst_48727);
var state_48745__$1 = state_48745;
var statearr_48775_48803 = state_48745__$1;
(statearr_48775_48803[(2)] = inst_48728);

(statearr_48775_48803[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48746 === (8))){
var inst_48707 = (state_48745[(7)]);
var state_48745__$1 = state_48745;
var statearr_48776_48804 = state_48745__$1;
(statearr_48776_48804[(2)] = inst_48707);

(statearr_48776_48804[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2721__auto__ = null;
var fluree$db$api$ledger$state_machine__2721__auto____0 = (function (){
var statearr_48777 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48777[(0)] = fluree$db$api$ledger$state_machine__2721__auto__);

(statearr_48777[(1)] = (1));

return statearr_48777;
});
var fluree$db$api$ledger$state_machine__2721__auto____1 = (function (state_48745){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48778){var ex__2724__auto__ = e48778;
var statearr_48779_48805 = state_48745;
(statearr_48779_48805[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48745[(4)]))){
var statearr_48780_48806 = state_48745;
(statearr_48780_48806[(1)] = cljs.core.first.call(null,(state_48745[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48807 = state_48745;
state_48745 = G__48807;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2721__auto__ = function(state_48745){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2721__auto____1.call(this,state_48745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2721__auto____0;
fluree$db$api$ledger$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2721__auto____1;
return fluree$db$api$ledger$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48781 = f__2744__auto__.call(null);
(statearr_48781[(6)] = c__2743__auto___48783);

return statearr_48781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

