// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__42662 = arguments.length;
switch (G__42662) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2743__auto___42810 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_42749){
var state_val_42750 = (state_42749[(1)]);
if((state_val_42750 === (7))){
var inst_42680 = (state_42749[(7)]);
var inst_42683 = cljs.core.not_EQ_.call(null,(0),inst_42680);
var state_42749__$1 = state_42749;
var statearr_42751_42811 = state_42749__$1;
(statearr_42751_42811[(2)] = inst_42683);

(statearr_42751_42811[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (20))){
var inst_42704 = (state_42749[(8)]);
var inst_42675 = (state_42749[(9)]);
var inst_42708 = fluree.db.auth.roles.call(null,inst_42675,inst_42704);
var state_42749__$1 = state_42749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42749__$1,(23),inst_42708);
} else {
if((state_val_42750 === (27))){
var inst_42675 = (state_42749[(9)]);
var inst_42723 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_42724 = fluree.db.time_travel.as_of_block.call(null,inst_42675,inst_42723);
var state_42749__$1 = state_42749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42749__$1,(30),inst_42724);
} else {
if((state_val_42750 === (1))){
var state_42749__$1 = state_42749;
var statearr_42752_42812 = state_42749__$1;
(statearr_42752_42812[(2)] = null);

(statearr_42752_42812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (24))){
var inst_42716 = (state_42749[(10)]);
var inst_42675 = (state_42749[(9)]);
var inst_42718 = fluree.db.permissions.permission_map.call(null,inst_42675,inst_42716,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_42749__$1 = state_42749;
var statearr_42753_42813 = state_42749__$1;
(statearr_42753_42813[(2)] = inst_42718);

(statearr_42753_42813[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (4))){
var inst_42663 = (state_42749[(2)]);
var inst_42664 = cljs.core.async.put_BANG_.call(null,pc,inst_42663);
var inst_42665 = cljs.core.async.close_BANG_.call(null,pc);
var state_42749__$1 = (function (){var statearr_42754 = state_42749;
(statearr_42754[(11)] = inst_42664);

return statearr_42754;
})();
var statearr_42755_42814 = state_42749__$1;
(statearr_42755_42814[(2)] = inst_42665);

(statearr_42755_42814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (15))){
var inst_42680 = (state_42749[(7)]);
var inst_42694 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42680)," unknown."].join('');
var inst_42695 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42696 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_42697 = cljs.core.PersistentHashMap.fromArrays(inst_42695,inst_42696);
var inst_42698 = cljs.core.ex_info.call(null,inst_42694,inst_42697);
var inst_42699 = (function(){throw inst_42698})();
var state_42749__$1 = state_42749;
var statearr_42756_42815 = state_42749__$1;
(statearr_42756_42815[(2)] = inst_42699);

(statearr_42756_42815[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (21))){
var state_42749__$1 = state_42749;
var statearr_42757_42816 = state_42749__$1;
(statearr_42757_42816[(2)] = null);

(statearr_42757_42816[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (31))){
var inst_42730 = (state_42749[(12)]);
var inst_42680 = (state_42749[(7)]);
var inst_42732 = cljs.core.assoc.call(null,inst_42730,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_42680);
var state_42749__$1 = state_42749;
var statearr_42758_42817 = state_42749__$1;
(statearr_42758_42817[(2)] = inst_42732);

(statearr_42758_42817[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (32))){
var inst_42730 = (state_42749[(12)]);
var state_42749__$1 = state_42749;
var statearr_42759_42818 = state_42749__$1;
(statearr_42759_42818[(2)] = inst_42730);

(statearr_42759_42818[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (33))){
var inst_42716 = (state_42749[(10)]);
var inst_42735 = (state_42749[(2)]);
var state_42749__$1 = (function (){var statearr_42760 = state_42749;
(statearr_42760[(13)] = inst_42735);

return statearr_42760;
})();
if(cljs.core.truth_(inst_42716)){
var statearr_42761_42819 = state_42749__$1;
(statearr_42761_42819[(1)] = (34));

} else {
var statearr_42762_42820 = state_42749__$1;
(statearr_42762_42820[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (13))){
var inst_42691 = (state_42749[(14)]);
var inst_42690 = (state_42749[(2)]);
var inst_42691__$1 = fluree.db.util.async.throw_err.call(null,inst_42690);
var state_42749__$1 = (function (){var statearr_42763 = state_42749;
(statearr_42763[(14)] = inst_42691__$1);

return statearr_42763;
})();
if(cljs.core.truth_(inst_42691__$1)){
var statearr_42764_42821 = state_42749__$1;
(statearr_42764_42821[(1)] = (14));

} else {
var statearr_42765_42822 = state_42749__$1;
(statearr_42765_42822[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (22))){
var inst_42714 = (state_42749[(2)]);
var state_42749__$1 = state_42749;
var statearr_42766_42823 = state_42749__$1;
(statearr_42766_42823[(2)] = inst_42714);

(statearr_42766_42823[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (36))){
var inst_42743 = (state_42749[(2)]);
var inst_42744 = cljs.core.async.put_BANG_.call(null,pc,inst_42743);
var _ = (function (){var statearr_42767 = state_42749;
(statearr_42767[(4)] = cljs.core.rest.call(null,(state_42749[(4)])));

return statearr_42767;
})();
var state_42749__$1 = state_42749;
var statearr_42768_42824 = state_42749__$1;
(statearr_42768_42824[(2)] = inst_42744);

(statearr_42768_42824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (29))){
var inst_42680 = (state_42749[(7)]);
var inst_42730 = (state_42749[(2)]);
var state_42749__$1 = (function (){var statearr_42769 = state_42749;
(statearr_42769[(12)] = inst_42730);

return statearr_42769;
})();
if(cljs.core.truth_(inst_42680)){
var statearr_42770_42825 = state_42749__$1;
(statearr_42770_42825[(1)] = (31));

} else {
var statearr_42771_42826 = state_42749__$1;
(statearr_42771_42826[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (6))){
var inst_42680 = (state_42749[(7)]);
var inst_42674 = (state_42749[(2)]);
var inst_42675 = fluree.db.util.async.throw_err.call(null,inst_42674);
var inst_42676 = opts;
var inst_42677 = cljs.core.__destructure_map.call(null,inst_42676);
var inst_42678 = cljs.core.get.call(null,inst_42677,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_42679 = cljs.core.get.call(null,inst_42677,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_42680__$1 = cljs.core.get.call(null,inst_42677,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_42681 = cljs.core.get.call(null,inst_42677,new cljs.core.Keyword(null,"block","block",664686210));
var state_42749__$1 = (function (){var statearr_42772 = state_42749;
(statearr_42772[(7)] = inst_42680__$1);

(statearr_42772[(9)] = inst_42675);

(statearr_42772[(15)] = inst_42679);

(statearr_42772[(16)] = inst_42681);

(statearr_42772[(17)] = inst_42678);

return statearr_42772;
})();
if(cljs.core.truth_(inst_42680__$1)){
var statearr_42773_42827 = state_42749__$1;
(statearr_42773_42827[(1)] = (7));

} else {
var statearr_42774_42828 = state_42749__$1;
(statearr_42774_42828[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (28))){
var inst_42675 = (state_42749[(9)]);
var state_42749__$1 = state_42749;
var statearr_42775_42829 = state_42749__$1;
(statearr_42775_42829[(2)] = inst_42675);

(statearr_42775_42829[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (25))){
var state_42749__$1 = state_42749;
var statearr_42776_42830 = state_42749__$1;
(statearr_42776_42830[(2)] = null);

(statearr_42776_42830[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (34))){
var inst_42721 = (state_42749[(18)]);
var state_42749__$1 = state_42749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42749__$1,(37),inst_42721);
} else {
if((state_val_42750 === (17))){
var inst_42678 = (state_42749[(17)]);
var state_42749__$1 = state_42749;
var statearr_42777_42831 = state_42749__$1;
(statearr_42777_42831[(2)] = inst_42678);

(statearr_42777_42831[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (3))){
var inst_42747 = (state_42749[(2)]);
var state_42749__$1 = state_42749;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42749__$1,inst_42747);
} else {
if((state_val_42750 === (12))){
var inst_42678 = (state_42749[(17)]);
var inst_42704 = (state_42749[(2)]);
var state_42749__$1 = (function (){var statearr_42778 = state_42749;
(statearr_42778[(8)] = inst_42704);

return statearr_42778;
})();
if(cljs.core.truth_(inst_42678)){
var statearr_42779_42832 = state_42749__$1;
(statearr_42779_42832[(1)] = (17));

} else {
var statearr_42780_42833 = state_42749__$1;
(statearr_42780_42833[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (2))){
var _ = (function (){var statearr_42781 = state_42749;
(statearr_42781[(4)] = cljs.core.cons.call(null,(5),(state_42749[(4)])));

return statearr_42781;
})();
var inst_42672 = fluree.db.session.db.call(null,conn,ledger,null);
var state_42749__$1 = state_42749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42749__$1,(6),inst_42672);
} else {
if((state_val_42750 === (23))){
var inst_42710 = (state_42749[(2)]);
var inst_42711 = fluree.db.util.async.throw_err.call(null,inst_42710);
var state_42749__$1 = state_42749;
var statearr_42782_42834 = state_42749__$1;
(statearr_42782_42834[(2)] = inst_42711);

(statearr_42782_42834[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (35))){
var inst_42735 = (state_42749[(13)]);
var state_42749__$1 = state_42749;
var statearr_42783_42835 = state_42749__$1;
(statearr_42783_42835[(2)] = inst_42735);

(statearr_42783_42835[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (19))){
var inst_42716 = (state_42749[(10)]);
var inst_42716__$1 = (state_42749[(2)]);
var state_42749__$1 = (function (){var statearr_42784 = state_42749;
(statearr_42784[(10)] = inst_42716__$1);

return statearr_42784;
})();
if(cljs.core.truth_(inst_42716__$1)){
var statearr_42785_42836 = state_42749__$1;
(statearr_42785_42836[(1)] = (24));

} else {
var statearr_42786_42837 = state_42749__$1;
(statearr_42786_42837[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (11))){
var state_42749__$1 = state_42749;
var statearr_42788_42838 = state_42749__$1;
(statearr_42788_42838[(2)] = null);

(statearr_42788_42838[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (9))){
var inst_42686 = (state_42749[(2)]);
var state_42749__$1 = state_42749;
if(cljs.core.truth_(inst_42686)){
var statearr_42789_42839 = state_42749__$1;
(statearr_42789_42839[(1)] = (10));

} else {
var statearr_42790_42840 = state_42749__$1;
(statearr_42790_42840[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (5))){
var _ = (function (){var statearr_42791 = state_42749;
(statearr_42791[(4)] = cljs.core.rest.call(null,(state_42749[(4)])));

return statearr_42791;
})();
var state_42749__$1 = state_42749;
var ex42787 = (state_42749__$1[(2)]);
var statearr_42792_42841 = state_42749__$1;
(statearr_42792_42841[(5)] = ex42787);


var statearr_42793_42842 = state_42749__$1;
(statearr_42793_42842[(1)] = (4));

(statearr_42793_42842[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (14))){
var inst_42691 = (state_42749[(14)]);
var state_42749__$1 = state_42749;
var statearr_42794_42843 = state_42749__$1;
(statearr_42794_42843[(2)] = inst_42691);

(statearr_42794_42843[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (26))){
var inst_42681 = (state_42749[(16)]);
var inst_42721 = (state_42749[(2)]);
var state_42749__$1 = (function (){var statearr_42795 = state_42749;
(statearr_42795[(18)] = inst_42721);

return statearr_42795;
})();
if(cljs.core.truth_(inst_42681)){
var statearr_42796_42844 = state_42749__$1;
(statearr_42796_42844[(1)] = (27));

} else {
var statearr_42797_42845 = state_42749__$1;
(statearr_42797_42845[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (16))){
var inst_42701 = (state_42749[(2)]);
var state_42749__$1 = state_42749;
var statearr_42798_42846 = state_42749__$1;
(statearr_42798_42846[(2)] = inst_42701);

(statearr_42798_42846[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (30))){
var inst_42726 = (state_42749[(2)]);
var inst_42727 = fluree.db.util.async.throw_err.call(null,inst_42726);
var state_42749__$1 = state_42749;
var statearr_42799_42847 = state_42749__$1;
(statearr_42799_42847[(2)] = inst_42727);

(statearr_42799_42847[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (10))){
var inst_42680 = (state_42749[(7)]);
var inst_42675 = (state_42749[(9)]);
var inst_42688 = fluree.db.dbproto._subid.call(null,inst_42675,inst_42680);
var state_42749__$1 = state_42749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42749__$1,(13),inst_42688);
} else {
if((state_val_42750 === (18))){
var inst_42704 = (state_42749[(8)]);
var state_42749__$1 = state_42749;
if(cljs.core.truth_(inst_42704)){
var statearr_42800_42848 = state_42749__$1;
(statearr_42800_42848[(1)] = (20));

} else {
var statearr_42801_42849 = state_42749__$1;
(statearr_42801_42849[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (37))){
var inst_42735 = (state_42749[(13)]);
var inst_42738 = (state_42749[(2)]);
var inst_42739 = fluree.db.util.async.throw_err.call(null,inst_42738);
var inst_42740 = cljs.core.assoc.call(null,inst_42735,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_42739);
var state_42749__$1 = state_42749;
var statearr_42802_42850 = state_42749__$1;
(statearr_42802_42850[(2)] = inst_42740);

(statearr_42802_42850[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42750 === (8))){
var inst_42680 = (state_42749[(7)]);
var state_42749__$1 = state_42749;
var statearr_42803_42851 = state_42749__$1;
(statearr_42803_42851[(2)] = inst_42680);

(statearr_42803_42851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2721__auto__ = null;
var fluree$db$api$query$state_machine__2721__auto____0 = (function (){
var statearr_42804 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42804[(0)] = fluree$db$api$query$state_machine__2721__auto__);

(statearr_42804[(1)] = (1));

return statearr_42804;
});
var fluree$db$api$query$state_machine__2721__auto____1 = (function (state_42749){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_42749);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e42805){var ex__2724__auto__ = e42805;
var statearr_42806_42852 = state_42749;
(statearr_42806_42852[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_42749[(4)]))){
var statearr_42807_42853 = state_42749;
(statearr_42807_42853[(1)] = cljs.core.first.call(null,(state_42749[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42854 = state_42749;
state_42749 = G__42854;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2721__auto__ = function(state_42749){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2721__auto____1.call(this,state_42749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2721__auto____0;
fluree$db$api$query$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2721__auto____1;
return fluree$db$api$query$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_42808 = f__2744__auto__.call(null);
(statearr_42808[(6)] = c__2743__auto___42810);

return statearr_42808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_42995){
var state_val_42996 = (state_42995[(1)]);
if((state_val_42996 === (7))){
var inst_42875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42876 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_42877 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_42878 = [inst_42876,inst_42877];
var inst_42879 = (new cljs.core.PersistentVector(null,2,(5),inst_42875,inst_42878,null));
var state_42995__$1 = state_42995;
var statearr_42997_43067 = state_42995__$1;
(statearr_42997_43067[(2)] = inst_42879);

(statearr_42997_43067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (20))){
var inst_42905 = (state_42995[(7)]);
var state_42995__$1 = state_42995;
var statearr_42998_43068 = state_42995__$1;
(statearr_42998_43068[(2)] = inst_42905);

(statearr_42998_43068[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (27))){
var state_42995__$1 = state_42995;
var statearr_42999_43069 = state_42995__$1;
(statearr_42999_43069[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (1))){
var state_42995__$1 = state_42995;
var statearr_43001_43070 = state_42995__$1;
(statearr_43001_43070[(2)] = null);

(statearr_43001_43070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (24))){
var inst_42904 = (state_42995[(8)]);
var state_42995__$1 = state_42995;
if(cljs.core.truth_(inst_42904)){
var statearr_43002_43071 = state_42995__$1;
(statearr_43002_43071[(1)] = (26));

} else {
var statearr_43003_43072 = state_42995__$1;
(statearr_43003_43072[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (39))){
var inst_42950 = (state_42995[(9)]);
var inst_42951 = (state_42995[(10)]);
var inst_42976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42977 = [inst_42950,inst_42951];
var inst_42978 = (new cljs.core.PersistentVector(null,2,(5),inst_42976,inst_42977,null));
var state_42995__$1 = state_42995;
var statearr_43004_43073 = state_42995__$1;
(statearr_43004_43073[(2)] = inst_42978);

(statearr_43004_43073[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (4))){
var inst_42855 = (state_42995[(2)]);
var state_42995__$1 = state_42995;
var statearr_43005_43074 = state_42995__$1;
(statearr_43005_43074[(2)] = inst_42855);

(statearr_43005_43074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (15))){
var inst_42884 = (state_42995[(11)]);
var inst_42889 = (state_42995[(12)]);
var inst_42898 = (state_42995[(2)]);
var inst_42899 = [inst_42889,inst_42898];
var inst_42900 = (new cljs.core.PersistentVector(null,2,(5),inst_42884,inst_42899,null));
var state_42995__$1 = state_42995;
var statearr_43006_43075 = state_42995__$1;
(statearr_43006_43075[(2)] = inst_42900);

(statearr_43006_43075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (21))){
var inst_42904 = (state_42995[(8)]);
var state_42995__$1 = state_42995;
var statearr_43007_43076 = state_42995__$1;
(statearr_43007_43076[(2)] = inst_42904);

(statearr_43007_43076[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (31))){
var inst_42945 = (state_42995[(2)]);
var state_42995__$1 = state_42995;
var statearr_43008_43077 = state_42995__$1;
(statearr_43008_43077[(2)] = inst_42945);

(statearr_43008_43077[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (32))){
var inst_42951 = (state_42995[(10)]);
var inst_42954 = cljs.core.pos_int_QMARK_.call(null,inst_42951);
var state_42995__$1 = state_42995;
var statearr_43009_43078 = state_42995__$1;
(statearr_43009_43078[(2)] = inst_42954);

(statearr_43009_43078[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (40))){
var inst_42982 = (state_42995[(13)]);
var inst_42906 = (state_42995[(14)]);
var inst_42980 = (state_42995[(2)]);
var inst_42981 = cljs.core.nth.call(null,inst_42980,(0),null);
var inst_42982__$1 = cljs.core.nth.call(null,inst_42980,(1),null);
var inst_42983 = (inst_42982__$1 > inst_42906);
var state_42995__$1 = (function (){var statearr_43010 = state_42995;
(statearr_43010[(13)] = inst_42982__$1);

(statearr_43010[(15)] = inst_42981);

return statearr_43010;
})();
if(cljs.core.truth_(inst_42983)){
var statearr_43011_43079 = state_42995__$1;
(statearr_43011_43079[(1)] = (41));

} else {
var statearr_43012_43080 = state_42995__$1;
(statearr_43012_43080[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (33))){
var inst_42952 = (state_42995[(16)]);
var state_42995__$1 = state_42995;
var statearr_43013_43081 = state_42995__$1;
(statearr_43013_43081[(2)] = inst_42952);

(statearr_43013_43081[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (13))){
var inst_42890 = (state_42995[(17)]);
var inst_42892 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_42890);
var state_42995__$1 = state_42995;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42995__$1,(16),inst_42892);
} else {
if((state_val_42996 === (22))){
var inst_42923 = (state_42995[(2)]);
var state_42995__$1 = state_42995;
if(cljs.core.truth_(inst_42923)){
var statearr_43014_43082 = state_42995__$1;
(statearr_43014_43082[(1)] = (23));

} else {
var statearr_43015_43083 = state_42995__$1;
(statearr_43015_43083[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (36))){
var state_42995__$1 = state_42995;
var statearr_43016_43084 = state_42995__$1;
(statearr_43016_43084[(2)] = null);

(statearr_43016_43084[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (41))){
var inst_42906 = (state_42995[(14)]);
var state_42995__$1 = state_42995;
var statearr_43017_43085 = state_42995__$1;
(statearr_43017_43085[(2)] = inst_42906);

(statearr_43017_43085[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (43))){
var inst_42981 = (state_42995[(15)]);
var inst_42987 = (state_42995[(2)]);
var inst_42988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42989 = [inst_42981,inst_42987];
var inst_42990 = (new cljs.core.PersistentVector(null,2,(5),inst_42988,inst_42989,null));
var _ = (function (){var statearr_43018 = state_42995;
(statearr_43018[(4)] = cljs.core.rest.call(null,(state_42995[(4)])));

return statearr_43018;
})();
var state_42995__$1 = state_42995;
var statearr_43019_43086 = state_42995__$1;
(statearr_43019_43086[(2)] = inst_42990);

(statearr_43019_43086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (29))){
var inst_42881 = (state_42995[(18)]);
var inst_42936 = cljs.core.pr_str.call(null,inst_42881);
var inst_42937 = ["Invalid block range provided: ",inst_42936].join('');
var inst_42938 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42939 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_42940 = cljs.core.PersistentHashMap.fromArrays(inst_42938,inst_42939);
var inst_42941 = cljs.core.ex_info.call(null,inst_42937,inst_42940);
var inst_42942 = (function(){throw inst_42941})();
var state_42995__$1 = state_42995;
var statearr_43020_43087 = state_42995__$1;
(statearr_43020_43087[(2)] = inst_42942);

(statearr_43020_43087[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (6))){
var inst_42873 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_42995__$1 = state_42995;
var statearr_43021_43088 = state_42995__$1;
(statearr_43021_43088[(2)] = inst_42873);

(statearr_43021_43088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (28))){
var inst_42947 = (state_42995[(2)]);
var state_42995__$1 = state_42995;
var statearr_43022_43089 = state_42995__$1;
(statearr_43022_43089[(2)] = inst_42947);

(statearr_43022_43089[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (25))){
var inst_42950 = (state_42995[(9)]);
var inst_42952 = (state_42995[(16)]);
var inst_42949 = (state_42995[(2)]);
var inst_42950__$1 = cljs.core.nth.call(null,inst_42949,(0),null);
var inst_42951 = cljs.core.nth.call(null,inst_42949,(1),null);
var inst_42952__$1 = cljs.core.pos_int_QMARK_.call(null,inst_42950__$1);
var state_42995__$1 = (function (){var statearr_43023 = state_42995;
(statearr_43023[(9)] = inst_42950__$1);

(statearr_43023[(16)] = inst_42952__$1);

(statearr_43023[(10)] = inst_42951);

return statearr_43023;
})();
if(inst_42952__$1){
var statearr_43024_43090 = state_42995__$1;
(statearr_43024_43090[(1)] = (32));

} else {
var statearr_43025_43091 = state_42995__$1;
(statearr_43025_43091[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (34))){
var inst_42957 = (state_42995[(2)]);
var inst_42958 = cljs.core.not.call(null,inst_42957);
var state_42995__$1 = state_42995;
if(inst_42958){
var statearr_43026_43092 = state_42995__$1;
(statearr_43026_43092[(1)] = (35));

} else {
var statearr_43027_43093 = state_42995__$1;
(statearr_43027_43093[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (17))){
var inst_42904 = (state_42995[(8)]);
var inst_42906 = (state_42995[(14)]);
var inst_42909 = cljs.core.pr_str.call(null,inst_42904);
var inst_42910 = cljs.core.pr_str.call(null,inst_42906);
var inst_42911 = ["Start block is out of range for this ledger. Start block provided: ",inst_42909,". Database block: ",inst_42910].join('');
var inst_42912 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42913 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_42914 = cljs.core.PersistentHashMap.fromArrays(inst_42912,inst_42913);
var inst_42915 = cljs.core.ex_info.call(null,inst_42911,inst_42914);
var inst_42916 = (function(){throw inst_42915})();
var state_42995__$1 = state_42995;
var statearr_43028_43094 = state_42995__$1;
(statearr_43028_43094[(2)] = inst_42916);

(statearr_43028_43094[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (3))){
var inst_42993 = (state_42995[(2)]);
var state_42995__$1 = state_42995;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42995__$1,inst_42993);
} else {
if((state_val_42996 === (12))){
var inst_42890 = (state_42995[(17)]);
var inst_42881 = (state_42995[(18)]);
var inst_42888 = (state_42995[(2)]);
var inst_42889 = fluree.db.util.async.throw_err.call(null,inst_42888);
var inst_42890__$1 = cljs.core.second.call(null,inst_42881);
var state_42995__$1 = (function (){var statearr_43029 = state_42995;
(statearr_43029[(12)] = inst_42889);

(statearr_43029[(17)] = inst_42890__$1);

return statearr_43029;
})();
if(cljs.core.truth_(inst_42890__$1)){
var statearr_43030_43095 = state_42995__$1;
(statearr_43030_43095[(1)] = (13));

} else {
var statearr_43031_43096 = state_42995__$1;
(statearr_43031_43096[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (2))){
var _ = (function (){var statearr_43032 = state_42995;
(statearr_43032[(4)] = cljs.core.cons.call(null,(5),(state_42995[(4)])));

return statearr_43032;
})();
var inst_42870 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_42871 = cljs.core.sequential_QMARK_.call(null,inst_42870);
var state_42995__$1 = state_42995;
if(inst_42871){
var statearr_43033_43097 = state_42995__$1;
(statearr_43033_43097[(1)] = (6));

} else {
var statearr_43034_43098 = state_42995__$1;
(statearr_43034_43098[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (23))){
var inst_42905 = (state_42995[(7)]);
var inst_42904 = (state_42995[(8)]);
var inst_42925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42926 = [inst_42904,inst_42905];
var inst_42927 = (new cljs.core.PersistentVector(null,2,(5),inst_42925,inst_42926,null));
var state_42995__$1 = state_42995;
var statearr_43035_43099 = state_42995__$1;
(statearr_43035_43099[(2)] = inst_42927);

(statearr_43035_43099[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (35))){
var inst_42881 = (state_42995[(18)]);
var inst_42960 = cljs.core.pr_str.call(null,inst_42881);
var inst_42961 = ["Invalid block range provided: ",inst_42960].join('');
var inst_42962 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42963 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_42964 = cljs.core.PersistentHashMap.fromArrays(inst_42962,inst_42963);
var inst_42965 = cljs.core.ex_info.call(null,inst_42961,inst_42964);
var inst_42966 = (function(){throw inst_42965})();
var state_42995__$1 = state_42995;
var statearr_43036_43100 = state_42995__$1;
(statearr_43036_43100[(2)] = inst_42966);

(statearr_43036_43100[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (19))){
var inst_42904 = (state_42995[(8)]);
var inst_42919 = (state_42995[(2)]);
var state_42995__$1 = (function (){var statearr_43037 = state_42995;
(statearr_43037[(19)] = inst_42919);

return statearr_43037;
})();
if(cljs.core.truth_(inst_42904)){
var statearr_43038_43101 = state_42995__$1;
(statearr_43038_43101[(1)] = (20));

} else {
var statearr_43039_43102 = state_42995__$1;
(statearr_43039_43102[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (11))){
var inst_42904 = (state_42995[(8)]);
var inst_42906 = (state_42995[(14)]);
var inst_42903 = (state_42995[(2)]);
var inst_42904__$1 = cljs.core.nth.call(null,inst_42903,(0),null);
var inst_42905 = cljs.core.nth.call(null,inst_42903,(1),null);
var inst_42906__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_42907 = (inst_42904__$1 > inst_42906__$1);
var state_42995__$1 = (function (){var statearr_43041 = state_42995;
(statearr_43041[(7)] = inst_42905);

(statearr_43041[(8)] = inst_42904__$1);

(statearr_43041[(14)] = inst_42906__$1);

return statearr_43041;
})();
if(cljs.core.truth_(inst_42907)){
var statearr_43042_43103 = state_42995__$1;
(statearr_43042_43103[(1)] = (17));

} else {
var statearr_43043_43104 = state_42995__$1;
(statearr_43043_43104[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (9))){
var inst_42881 = (state_42995[(18)]);
var inst_42884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42885 = cljs.core.first.call(null,inst_42881);
var inst_42886 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_42885);
var state_42995__$1 = (function (){var statearr_43044 = state_42995;
(statearr_43044[(11)] = inst_42884);

return statearr_43044;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42995__$1,(12),inst_42886);
} else {
if((state_val_42996 === (5))){
var _ = (function (){var statearr_43045 = state_42995;
(statearr_43045[(4)] = cljs.core.rest.call(null,(state_42995[(4)])));

return statearr_43045;
})();
var state_42995__$1 = state_42995;
var ex43040 = (state_42995__$1[(2)]);
var statearr_43046_43105 = state_42995__$1;
(statearr_43046_43105[(5)] = ex43040);


if((ex43040 instanceof Error)){
var statearr_43047_43106 = state_42995__$1;
(statearr_43047_43106[(1)] = (4));

(statearr_43047_43106[(5)] = null);

} else {
throw ex43040;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (14))){
var state_42995__$1 = state_42995;
var statearr_43048_43107 = state_42995__$1;
(statearr_43048_43107[(2)] = null);

(statearr_43048_43107[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (26))){
var inst_42904 = (state_42995[(8)]);
var inst_42930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42931 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_42932 = [inst_42904,inst_42931];
var inst_42933 = (new cljs.core.PersistentVector(null,2,(5),inst_42930,inst_42932,null));
var state_42995__$1 = state_42995;
var statearr_43049_43108 = state_42995__$1;
(statearr_43049_43108[(2)] = inst_42933);

(statearr_43049_43108[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (16))){
var inst_42894 = (state_42995[(2)]);
var inst_42895 = fluree.db.util.async.throw_err.call(null,inst_42894);
var state_42995__$1 = state_42995;
var statearr_43050_43109 = state_42995__$1;
(statearr_43050_43109[(2)] = inst_42895);

(statearr_43050_43109[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (38))){
var inst_42950 = (state_42995[(9)]);
var inst_42951 = (state_42995[(10)]);
var inst_42972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42973 = [inst_42951,inst_42950];
var inst_42974 = (new cljs.core.PersistentVector(null,2,(5),inst_42972,inst_42973,null));
var state_42995__$1 = state_42995;
var statearr_43051_43110 = state_42995__$1;
(statearr_43051_43110[(2)] = inst_42974);

(statearr_43051_43110[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (30))){
var state_42995__$1 = state_42995;
var statearr_43052_43111 = state_42995__$1;
(statearr_43052_43111[(2)] = null);

(statearr_43052_43111[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (10))){
var inst_42881 = (state_42995[(18)]);
var state_42995__$1 = state_42995;
var statearr_43053_43112 = state_42995__$1;
(statearr_43053_43112[(2)] = inst_42881);

(statearr_43053_43112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (18))){
var state_42995__$1 = state_42995;
var statearr_43054_43113 = state_42995__$1;
(statearr_43054_43113[(2)] = null);

(statearr_43054_43113[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (42))){
var inst_42982 = (state_42995[(13)]);
var state_42995__$1 = state_42995;
var statearr_43055_43114 = state_42995__$1;
(statearr_43055_43114[(2)] = inst_42982);

(statearr_43055_43114[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (37))){
var inst_42950 = (state_42995[(9)]);
var inst_42951 = (state_42995[(10)]);
var inst_42969 = (state_42995[(2)]);
var inst_42970 = (inst_42951 < inst_42950);
var state_42995__$1 = (function (){var statearr_43056 = state_42995;
(statearr_43056[(20)] = inst_42969);

return statearr_43056;
})();
if(cljs.core.truth_(inst_42970)){
var statearr_43057_43115 = state_42995__$1;
(statearr_43057_43115[(1)] = (38));

} else {
var statearr_43058_43116 = state_42995__$1;
(statearr_43058_43116[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42996 === (8))){
var inst_42881 = (state_42995[(18)]);
var inst_42881__$1 = (state_42995[(2)]);
var inst_42882 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_42881__$1);
var state_42995__$1 = (function (){var statearr_43059 = state_42995;
(statearr_43059[(18)] = inst_42881__$1);

return statearr_43059;
})();
if(cljs.core.truth_(inst_42882)){
var statearr_43060_43117 = state_42995__$1;
(statearr_43060_43117[(1)] = (9));

} else {
var statearr_43061_43118 = state_42995__$1;
(statearr_43061_43118[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto____0 = (function (){
var statearr_43062 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43062[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto__);

(statearr_43062[(1)] = (1));

return statearr_43062;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto____1 = (function (state_42995){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_42995);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e43063){var ex__2724__auto__ = e43063;
var statearr_43064_43119 = state_42995;
(statearr_43064_43119[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_42995[(4)]))){
var statearr_43065_43120 = state_42995;
(statearr_43065_43120[(1)] = cljs.core.first.call(null,(state_42995[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43121 = state_42995;
state_42995 = G__43121;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto__ = function(state_42995){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto____1.call(this,state_42995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_43066 = f__2744__auto__.call(null);
(statearr_43066[(6)] = c__2743__auto__);

return statearr_43066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_43271){
var state_val_43272 = (state_43271[(1)]);
if((state_val_43272 === (7))){
var inst_43183 = (state_43271[(2)]);
var inst_43184 = cljs.core.nth.call(null,inst_43183,(0),null);
var inst_43185 = cljs.core.nth.call(null,inst_43183,(1),null);
var inst_43193 = cljs.core.vals.call(null,inst_43185);
var inst_43194 = cljs.core.seq.call(null,inst_43193);
var inst_43195 = cljs.core.first.call(null,inst_43194);
var inst_43196 = cljs.core.next.call(null,inst_43194);
var inst_43197 = cljs.core.PersistentVector.EMPTY;
var inst_43198 = inst_43193;
var inst_43199 = inst_43197;
var state_43271__$1 = (function (){var statearr_43273 = state_43271;
(statearr_43273[(7)] = inst_43184);

(statearr_43273[(8)] = inst_43198);

(statearr_43273[(9)] = inst_43199);

(statearr_43273[(10)] = inst_43195);

(statearr_43273[(11)] = inst_43196);

return statearr_43273;
})();
var statearr_43274_43327 = state_43271__$1;
(statearr_43274_43327[(2)] = null);

(statearr_43274_43327[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (20))){
var inst_43205 = (state_43271[(12)]);
var inst_43210 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_43211 = cljs.core.PersistentHashMap.EMPTY;
var inst_43212 = [true,inst_43211];
var inst_43213 = cljs.core.PersistentHashMap.fromArrays(inst_43210,inst_43212);
var inst_43214 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_43213,inst_43205);
var state_43271__$1 = state_43271;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43271__$1,(22),inst_43214);
} else {
if((state_val_43272 === (27))){
var inst_43259 = (state_43271[(2)]);
var state_43271__$1 = state_43271;
var statearr_43275_43328 = state_43271__$1;
(statearr_43275_43328[(2)] = inst_43259);

(statearr_43275_43328[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (1))){
var state_43271__$1 = state_43271;
var statearr_43276_43329 = state_43271__$1;
(statearr_43276_43329[(2)] = null);

(statearr_43276_43329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (24))){
var inst_43223 = (state_43271[(13)]);
var inst_43261 = (state_43271[(2)]);
var inst_43262 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_43263 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_43264 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_43265 = [inst_43263,inst_43264,inst_43223,inst_43261];
var inst_43266 = cljs.core.PersistentHashMap.fromArrays(inst_43262,inst_43265);
var _ = (function (){var statearr_43278 = state_43271;
(statearr_43278[(4)] = cljs.core.rest.call(null,(state_43271[(4)])));

return statearr_43278;
})();
var state_43271__$1 = state_43271;
var statearr_43279_43330 = state_43271__$1;
(statearr_43279_43330[(2)] = inst_43266);

(statearr_43279_43330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (4))){
var inst_43124 = (state_43271[(2)]);
var state_43271__$1 = state_43271;
var statearr_43280_43331 = state_43271__$1;
(statearr_43280_43331[(2)] = inst_43124);

(statearr_43280_43331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (15))){
var inst_43143 = (state_43271[(14)]);
var inst_43155 = (state_43271[(15)]);
var inst_43164 = (state_43271[(16)]);
var inst_43142 = (state_43271[(17)]);
var inst_43169 = (state_43271[(18)]);
var inst_43147 = (state_43271[(19)]);
var inst_43154 = (state_43271[(20)]);
var inst_43146 = (state_43271[(21)]);
var inst_43148 = (state_43271[(22)]);
var inst_43162 = (state_43271[(23)]);
var inst_43140 = (state_43271[(24)]);
var inst_43175 = (function (){var G__43136 = inst_43146;
var first__43139 = inst_43142;
var subject = inst_43162;
var flake = inst_43154;
var r = inst_43155;
var asserted_subjects = inst_43147;
var seq__43138 = inst_43143;
var vec__43150 = inst_43146;
var vec__43137 = inst_43140;
var flake_SINGLEQUOTE_ = inst_43169;
var retracted_subjects = inst_43148;
var asserted_QMARK_ = inst_43164;
var seq__43151 = inst_43155;
var first__43152 = inst_43154;
return (function (p1__43123_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__43123_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_43176 = cljs.core.update.call(null,inst_43148,inst_43162,inst_43175);
var tmp43277 = inst_43147;
var inst_43146__$1 = inst_43155;
var inst_43147__$1 = tmp43277;
var inst_43148__$1 = inst_43176;
var state_43271__$1 = (function (){var statearr_43281 = state_43271;
(statearr_43281[(19)] = inst_43147__$1);

(statearr_43281[(21)] = inst_43146__$1);

(statearr_43281[(22)] = inst_43148__$1);

return statearr_43281;
})();
var statearr_43282_43332 = state_43271__$1;
(statearr_43282_43332[(2)] = null);

(statearr_43282_43332[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (21))){
var inst_43221 = (state_43271[(2)]);
var state_43271__$1 = state_43271;
var statearr_43283_43333 = state_43271__$1;
(statearr_43283_43333[(2)] = inst_43221);

(statearr_43283_43333[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (13))){
var inst_43164 = (state_43271[(16)]);
var inst_43169 = (state_43271[(2)]);
var state_43271__$1 = (function (){var statearr_43284 = state_43271;
(statearr_43284[(18)] = inst_43169);

return statearr_43284;
})();
if(cljs.core.truth_(inst_43164)){
var statearr_43285_43334 = state_43271__$1;
(statearr_43285_43334[(1)] = (14));

} else {
var statearr_43286_43335 = state_43271__$1;
(statearr_43286_43335[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (22))){
var inst_43199 = (state_43271[(9)]);
var inst_43206 = (state_43271[(25)]);
var inst_43216 = (state_43271[(2)]);
var inst_43217 = fluree.db.util.async.throw_err.call(null,inst_43216);
var inst_43218 = cljs.core.conj.call(null,inst_43199,inst_43217);
var inst_43198 = inst_43206;
var inst_43199__$1 = inst_43218;
var state_43271__$1 = (function (){var statearr_43287 = state_43271;
(statearr_43287[(8)] = inst_43198);

(statearr_43287[(9)] = inst_43199__$1);

return statearr_43287;
})();
var statearr_43288_43336 = state_43271__$1;
(statearr_43288_43336[(2)] = null);

(statearr_43288_43336[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (6))){
var inst_43154 = (state_43271[(20)]);
var inst_43146 = (state_43271[(21)]);
var inst_43153 = cljs.core.seq.call(null,inst_43146);
var inst_43154__$1 = cljs.core.first.call(null,inst_43153);
var inst_43155 = cljs.core.next.call(null,inst_43153);
var inst_43156 = cljs.core.not.call(null,inst_43154__$1);
var state_43271__$1 = (function (){var statearr_43289 = state_43271;
(statearr_43289[(15)] = inst_43155);

(statearr_43289[(20)] = inst_43154__$1);

return statearr_43289;
})();
if(inst_43156){
var statearr_43290_43337 = state_43271__$1;
(statearr_43290_43337[(1)] = (8));

} else {
var statearr_43291_43338 = state_43271__$1;
(statearr_43291_43338[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (28))){
var inst_43237 = (state_43271[(26)]);
var inst_43244 = (state_43271[(27)]);
var inst_43254 = (state_43271[(2)]);
var inst_43255 = fluree.db.util.async.throw_err.call(null,inst_43254);
var inst_43256 = cljs.core.conj.call(null,inst_43237,inst_43255);
var inst_43236 = inst_43244;
var inst_43237__$1 = inst_43256;
var state_43271__$1 = (function (){var statearr_43292 = state_43271;
(statearr_43292[(26)] = inst_43237__$1);

(statearr_43292[(28)] = inst_43236);

return statearr_43292;
})();
var statearr_43293_43339 = state_43271__$1;
(statearr_43293_43339[(2)] = null);

(statearr_43293_43339[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (25))){
var inst_43237 = (state_43271[(26)]);
var state_43271__$1 = state_43271;
var statearr_43294_43340 = state_43271__$1;
(statearr_43294_43340[(2)] = inst_43237);

(statearr_43294_43340[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (17))){
var inst_43198 = (state_43271[(8)]);
var inst_43205 = (state_43271[(12)]);
var inst_43204 = cljs.core.seq.call(null,inst_43198);
var inst_43205__$1 = cljs.core.first.call(null,inst_43204);
var inst_43206 = cljs.core.next.call(null,inst_43204);
var inst_43207 = cljs.core.not.call(null,inst_43205__$1);
var state_43271__$1 = (function (){var statearr_43295 = state_43271;
(statearr_43295[(12)] = inst_43205__$1);

(statearr_43295[(25)] = inst_43206);

return statearr_43295;
})();
if(inst_43207){
var statearr_43296_43341 = state_43271__$1;
(statearr_43296_43341[(1)] = (19));

} else {
var statearr_43297_43342 = state_43271__$1;
(statearr_43297_43342[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (3))){
var inst_43269 = (state_43271[(2)]);
var state_43271__$1 = state_43271;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43271__$1,inst_43269);
} else {
if((state_val_43272 === (12))){
var inst_43154 = (state_43271[(20)]);
var inst_43167 = fluree.db.flake.flip_flake.call(null,inst_43154);
var state_43271__$1 = state_43271;
var statearr_43298_43343 = state_43271__$1;
(statearr_43298_43343[(2)] = inst_43167);

(statearr_43298_43343[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (2))){
var inst_43140 = (state_43271[(24)]);
var _ = (function (){var statearr_43299 = state_43271;
(statearr_43299[(4)] = cljs.core.cons.call(null,(5),(state_43271[(4)])));

return statearr_43299;
})();
var inst_43140__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_43141 = cljs.core.seq.call(null,inst_43140__$1);
var inst_43142 = cljs.core.first.call(null,inst_43141);
var inst_43143 = cljs.core.next.call(null,inst_43141);
var inst_43144 = cljs.core.PersistentHashMap.EMPTY;
var inst_43145 = cljs.core.PersistentHashMap.EMPTY;
var inst_43146 = inst_43140__$1;
var inst_43147 = inst_43144;
var inst_43148 = inst_43145;
var state_43271__$1 = (function (){var statearr_43300 = state_43271;
(statearr_43300[(14)] = inst_43143);

(statearr_43300[(17)] = inst_43142);

(statearr_43300[(19)] = inst_43147);

(statearr_43300[(21)] = inst_43146);

(statearr_43300[(22)] = inst_43148);

(statearr_43300[(24)] = inst_43140__$1);

return statearr_43300;
})();
var statearr_43301_43344 = state_43271__$1;
(statearr_43301_43344[(2)] = null);

(statearr_43301_43344[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (23))){
var inst_43243 = (state_43271[(29)]);
var inst_43236 = (state_43271[(28)]);
var inst_43242 = cljs.core.seq.call(null,inst_43236);
var inst_43243__$1 = cljs.core.first.call(null,inst_43242);
var inst_43244 = cljs.core.next.call(null,inst_43242);
var inst_43245 = cljs.core.not.call(null,inst_43243__$1);
var state_43271__$1 = (function (){var statearr_43302 = state_43271;
(statearr_43302[(29)] = inst_43243__$1);

(statearr_43302[(27)] = inst_43244);

return statearr_43302;
})();
if(inst_43245){
var statearr_43303_43345 = state_43271__$1;
(statearr_43303_43345[(1)] = (25));

} else {
var statearr_43304_43346 = state_43271__$1;
(statearr_43304_43346[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (19))){
var inst_43199 = (state_43271[(9)]);
var state_43271__$1 = state_43271;
var statearr_43305_43347 = state_43271__$1;
(statearr_43305_43347[(2)] = inst_43199);

(statearr_43305_43347[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (11))){
var inst_43154 = (state_43271[(20)]);
var state_43271__$1 = state_43271;
var statearr_43307_43348 = state_43271__$1;
(statearr_43307_43348[(2)] = inst_43154);

(statearr_43307_43348[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (9))){
var inst_43164 = (state_43271[(16)]);
var inst_43154 = (state_43271[(20)]);
var inst_43162 = inst_43154.s;
var inst_43163 = inst_43154.op;
var inst_43164__$1 = inst_43163 === true;
var state_43271__$1 = (function (){var statearr_43309 = state_43271;
(statearr_43309[(16)] = inst_43164__$1);

(statearr_43309[(23)] = inst_43162);

return statearr_43309;
})();
if(cljs.core.truth_(inst_43164__$1)){
var statearr_43310_43349 = state_43271__$1;
(statearr_43310_43349[(1)] = (11));

} else {
var statearr_43311_43350 = state_43271__$1;
(statearr_43311_43350[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (5))){
var _ = (function (){var statearr_43312 = state_43271;
(statearr_43312[(4)] = cljs.core.rest.call(null,(state_43271[(4)])));

return statearr_43312;
})();
var state_43271__$1 = state_43271;
var ex43306 = (state_43271__$1[(2)]);
var statearr_43313_43351 = state_43271__$1;
(statearr_43313_43351[(5)] = ex43306);


if((ex43306 instanceof Error)){
var statearr_43314_43352 = state_43271__$1;
(statearr_43314_43352[(1)] = (4));

(statearr_43314_43352[(5)] = null);

} else {
throw ex43306;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (14))){
var inst_43143 = (state_43271[(14)]);
var inst_43155 = (state_43271[(15)]);
var inst_43164 = (state_43271[(16)]);
var inst_43142 = (state_43271[(17)]);
var inst_43169 = (state_43271[(18)]);
var inst_43147 = (state_43271[(19)]);
var inst_43154 = (state_43271[(20)]);
var inst_43146 = (state_43271[(21)]);
var inst_43148 = (state_43271[(22)]);
var inst_43162 = (state_43271[(23)]);
var inst_43140 = (state_43271[(24)]);
var inst_43171 = (function (){var G__43136 = inst_43146;
var first__43139 = inst_43142;
var subject = inst_43162;
var flake = inst_43154;
var r = inst_43155;
var asserted_subjects = inst_43147;
var seq__43138 = inst_43143;
var vec__43150 = inst_43146;
var vec__43137 = inst_43140;
var flake_SINGLEQUOTE_ = inst_43169;
var retracted_subjects = inst_43148;
var asserted_QMARK_ = inst_43164;
var seq__43151 = inst_43155;
var first__43152 = inst_43154;
return (function (p1__43122_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__43122_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_43172 = cljs.core.update.call(null,inst_43147,inst_43162,inst_43171);
var tmp43308 = inst_43148;
var inst_43146__$1 = inst_43155;
var inst_43147__$1 = inst_43172;
var inst_43148__$1 = tmp43308;
var state_43271__$1 = (function (){var statearr_43315 = state_43271;
(statearr_43315[(19)] = inst_43147__$1);

(statearr_43315[(21)] = inst_43146__$1);

(statearr_43315[(22)] = inst_43148__$1);

return statearr_43315;
})();
var statearr_43316_43353 = state_43271__$1;
(statearr_43316_43353[(2)] = null);

(statearr_43316_43353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (26))){
var inst_43243 = (state_43271[(29)]);
var inst_43248 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_43249 = cljs.core.PersistentHashMap.EMPTY;
var inst_43250 = [true,inst_43249];
var inst_43251 = cljs.core.PersistentHashMap.fromArrays(inst_43248,inst_43250);
var inst_43252 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_43251,inst_43243);
var state_43271__$1 = state_43271;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43271__$1,(28),inst_43252);
} else {
if((state_val_43272 === (16))){
var inst_43179 = (state_43271[(2)]);
var state_43271__$1 = state_43271;
var statearr_43317_43354 = state_43271__$1;
(statearr_43317_43354[(2)] = inst_43179);

(statearr_43317_43354[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (10))){
var inst_43181 = (state_43271[(2)]);
var state_43271__$1 = state_43271;
var statearr_43318_43355 = state_43271__$1;
(statearr_43318_43355[(2)] = inst_43181);

(statearr_43318_43355[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (18))){
var inst_43184 = (state_43271[(7)]);
var inst_43223 = (state_43271[(2)]);
var inst_43231 = cljs.core.vals.call(null,inst_43184);
var inst_43232 = cljs.core.seq.call(null,inst_43231);
var inst_43233 = cljs.core.first.call(null,inst_43232);
var inst_43234 = cljs.core.next.call(null,inst_43232);
var inst_43235 = cljs.core.PersistentVector.EMPTY;
var inst_43236 = inst_43231;
var inst_43237 = inst_43235;
var state_43271__$1 = (function (){var statearr_43319 = state_43271;
(statearr_43319[(30)] = inst_43234);

(statearr_43319[(26)] = inst_43237);

(statearr_43319[(13)] = inst_43223);

(statearr_43319[(28)] = inst_43236);

(statearr_43319[(31)] = inst_43233);

return statearr_43319;
})();
var statearr_43320_43356 = state_43271__$1;
(statearr_43320_43356[(2)] = null);

(statearr_43320_43356[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43272 === (8))){
var inst_43147 = (state_43271[(19)]);
var inst_43148 = (state_43271[(22)]);
var inst_43158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43159 = [inst_43147,inst_43148];
var inst_43160 = (new cljs.core.PersistentVector(null,2,(5),inst_43158,inst_43159,null));
var state_43271__$1 = state_43271;
var statearr_43321_43357 = state_43271__$1;
(statearr_43321_43357[(2)] = inst_43160);

(statearr_43321_43357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto____0 = (function (){
var statearr_43322 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43322[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto__);

(statearr_43322[(1)] = (1));

return statearr_43322;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto____1 = (function (state_43271){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_43271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e43323){var ex__2724__auto__ = e43323;
var statearr_43324_43358 = state_43271;
(statearr_43324_43358[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_43271[(4)]))){
var statearr_43325_43359 = state_43271;
(statearr_43325_43359[(1)] = cljs.core.first.call(null,(state_43271[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43360 = state_43271;
state_43271 = G__43360;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto__ = function(state_43271){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto____1.call(this,state_43271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_43326 = f__2744__auto__.call(null);
(statearr_43326[(6)] = c__2743__auto__);

return statearr_43326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_43392){
var state_val_43393 = (state_43392[(1)]);
if((state_val_43393 === (1))){
var inst_43361 = cljs.core.volatile_BANG_.call(null,(0));
var inst_43362 = cljs.core.PersistentHashMap.EMPTY;
var inst_43363 = cljs.core.volatile_BANG_.call(null,inst_43362);
var inst_43364 = cljs.core.first.call(null,resp);
var inst_43365 = cljs.core.rest.call(null,resp);
var inst_43366 = cljs.core.PersistentVector.EMPTY;
var inst_43367 = inst_43361;
var inst_43368 = inst_43363;
var inst_43369 = inst_43364;
var inst_43370 = inst_43365;
var inst_43371 = inst_43366;
var state_43392__$1 = (function (){var statearr_43394 = state_43392;
(statearr_43394[(7)] = inst_43370);

(statearr_43394[(8)] = inst_43368);

(statearr_43394[(9)] = inst_43371);

(statearr_43394[(10)] = inst_43367);

(statearr_43394[(11)] = inst_43369);

return statearr_43394;
})();
var statearr_43395_43410 = state_43392__$1;
(statearr_43395_43410[(2)] = null);

(statearr_43395_43410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43393 === (2))){
var inst_43368 = (state_43392[(8)]);
var inst_43367 = (state_43392[(10)]);
var inst_43369 = (state_43392[(11)]);
var inst_43373 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_43369,inst_43368,inst_43367);
var state_43392__$1 = state_43392;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43392__$1,(4),inst_43373);
} else {
if((state_val_43393 === (3))){
var inst_43390 = (state_43392[(2)]);
var state_43392__$1 = state_43392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43392__$1,inst_43390);
} else {
if((state_val_43393 === (4))){
var inst_43370 = (state_43392[(7)]);
var inst_43371 = (state_43392[(9)]);
var inst_43375 = (state_43392[(2)]);
var inst_43376 = fluree.db.util.async.throw_err.call(null,inst_43375);
var inst_43377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43378 = [inst_43376];
var inst_43379 = (new cljs.core.PersistentVector(null,1,(5),inst_43377,inst_43378,null));
var inst_43380 = cljs.core.concat.call(null,inst_43371,inst_43379);
var inst_43381 = cljs.core.first.call(null,inst_43370);
var state_43392__$1 = (function (){var statearr_43398 = state_43392;
(statearr_43398[(12)] = inst_43380);

return statearr_43398;
})();
if(cljs.core.truth_(inst_43381)){
var statearr_43399_43411 = state_43392__$1;
(statearr_43399_43411[(1)] = (5));

} else {
var statearr_43400_43412 = state_43392__$1;
(statearr_43400_43412[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43393 === (5))){
var inst_43370 = (state_43392[(7)]);
var inst_43380 = (state_43392[(12)]);
var inst_43368 = (state_43392[(8)]);
var inst_43367 = (state_43392[(10)]);
var inst_43383 = cljs.core.first.call(null,inst_43370);
var inst_43384 = cljs.core.rest.call(null,inst_43370);
var tmp43396 = inst_43368;
var tmp43397 = inst_43367;
var inst_43367__$1 = tmp43397;
var inst_43368__$1 = tmp43396;
var inst_43369 = inst_43383;
var inst_43370__$1 = inst_43384;
var inst_43371 = inst_43380;
var state_43392__$1 = (function (){var statearr_43401 = state_43392;
(statearr_43401[(7)] = inst_43370__$1);

(statearr_43401[(8)] = inst_43368__$1);

(statearr_43401[(9)] = inst_43371);

(statearr_43401[(10)] = inst_43367__$1);

(statearr_43401[(11)] = inst_43369);

return statearr_43401;
})();
var statearr_43402_43413 = state_43392__$1;
(statearr_43402_43413[(2)] = null);

(statearr_43402_43413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43393 === (6))){
var inst_43380 = (state_43392[(12)]);
var state_43392__$1 = state_43392;
var statearr_43403_43414 = state_43392__$1;
(statearr_43403_43414[(2)] = inst_43380);

(statearr_43403_43414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43393 === (7))){
var inst_43388 = (state_43392[(2)]);
var state_43392__$1 = state_43392;
var statearr_43404_43415 = state_43392__$1;
(statearr_43404_43415[(2)] = inst_43388);

(statearr_43404_43415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto____0 = (function (){
var statearr_43405 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43405[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto__);

(statearr_43405[(1)] = (1));

return statearr_43405;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto____1 = (function (state_43392){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_43392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e43406){var ex__2724__auto__ = e43406;
var statearr_43407_43416 = state_43392;
(statearr_43407_43416[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_43392[(4)]))){
var statearr_43408_43417 = state_43392;
(statearr_43408_43417[(1)] = cljs.core.first.call(null,(state_43392[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43418 = state_43392;
state_43392 = G__43418;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto__ = function(state_43392){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto____1.call(this,state_43392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_43409 = f__2744__auto__.call(null);
(statearr_43409[(6)] = c__2743__auto__);

return statearr_43409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__43420 = arguments.length;
switch (G__43420) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__43422){
var map__43423 = p__43422;
var map__43423__$1 = cljs.core.__destructure_map.call(null,map__43423);
var query = map__43423__$1;
var opts = cljs.core.get.call(null,map__43423__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_43508){
var state_val_43509 = (state_43508[(1)]);
if((state_val_43509 === (7))){
var inst_43434 = (state_43508[(7)]);
var inst_43438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43439 = ["_auth/id",inst_43434];
var inst_43440 = (new cljs.core.PersistentVector(null,2,(5),inst_43438,inst_43439,null));
var state_43508__$1 = state_43508;
var statearr_43510_43554 = state_43508__$1;
(statearr_43510_43554[(2)] = inst_43440);

(statearr_43510_43554[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (20))){
var inst_43488 = (state_43508[(2)]);
var inst_43489 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_43508__$1 = (function (){var statearr_43511 = state_43508;
(statearr_43511[(8)] = inst_43488);

return statearr_43511;
})();
if(cljs.core.truth_(inst_43489)){
var statearr_43512_43555 = state_43508__$1;
(statearr_43512_43555[(1)] = (22));

} else {
var statearr_43513_43556 = state_43508__$1;
(statearr_43513_43556[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (27))){
var inst_43491 = (state_43508[(9)]);
var inst_43435 = (state_43508[(10)]);
var inst_43497 = (state_43508[(2)]);
var inst_43498 = fluree.db.util.core.response_time_formatted.call(null,inst_43435);
var inst_43499 = [(200),inst_43497,(100),inst_43498];
var inst_43500 = cljs.core.PersistentHashMap.fromArrays(inst_43491,inst_43499);
var state_43508__$1 = state_43508;
var statearr_43514_43557 = state_43508__$1;
(statearr_43514_43557[(2)] = inst_43500);

(statearr_43514_43557[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (1))){
var state_43508__$1 = state_43508;
var statearr_43515_43558 = state_43508__$1;
(statearr_43515_43558[(2)] = null);

(statearr_43515_43558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (24))){
var inst_43503 = (state_43508[(2)]);
var _ = (function (){var statearr_43516 = state_43508;
(statearr_43516[(4)] = cljs.core.rest.call(null,(state_43508[(4)])));

return statearr_43516;
})();
var state_43508__$1 = state_43508;
var statearr_43517_43559 = state_43508__$1;
(statearr_43517_43559[(2)] = inst_43503);

(statearr_43517_43559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (4))){
var inst_43424 = (state_43508[(2)]);
var state_43508__$1 = state_43508;
var statearr_43518_43560 = state_43508__$1;
(statearr_43518_43560[(2)] = inst_43424);

(statearr_43518_43560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (15))){
var inst_43475 = (state_43508[(11)]);
var state_43508__$1 = state_43508;
var statearr_43519_43561 = state_43508__$1;
(statearr_43519_43561[(2)] = inst_43475);

(statearr_43519_43561[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (21))){
var inst_43484 = (state_43508[(2)]);
var inst_43485 = fluree.db.util.async.throw_err.call(null,inst_43484);
var state_43508__$1 = state_43508;
var statearr_43520_43562 = state_43508__$1;
(statearr_43520_43562[(2)] = inst_43485);

(statearr_43520_43562[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (13))){
var inst_43433 = (state_43508[(12)]);
var inst_43475 = (state_43508[(11)]);
var inst_43474 = (state_43508[(2)]);
var inst_43475__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_43433);
var state_43508__$1 = (function (){var statearr_43521 = state_43508;
(statearr_43521[(11)] = inst_43475__$1);

(statearr_43521[(13)] = inst_43474);

return statearr_43521;
})();
if(cljs.core.truth_(inst_43475__$1)){
var statearr_43522_43563 = state_43508__$1;
(statearr_43522_43563[(1)] = (15));

} else {
var statearr_43523_43564 = state_43508__$1;
(statearr_43523_43564[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (22))){
var inst_43488 = (state_43508[(8)]);
var inst_43491 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_43492 = cljs.core.sequential_QMARK_.call(null,inst_43488);
var state_43508__$1 = (function (){var statearr_43524 = state_43508;
(statearr_43524[(9)] = inst_43491);

return statearr_43524;
})();
if(inst_43492){
var statearr_43525_43565 = state_43508__$1;
(statearr_43525_43565[(1)] = (25));

} else {
var statearr_43526_43566 = state_43508__$1;
(statearr_43526_43566[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (6))){
var inst_43433 = (state_43508[(12)]);
var inst_43449 = (state_43508[(14)]);
var inst_43448 = (state_43508[(2)]);
var inst_43449__$1 = fluree.db.util.async.throw_err.call(null,inst_43448);
var inst_43450 = fluree.db.api.query.resolve_block_range.call(null,inst_43449__$1,inst_43433);
var state_43508__$1 = (function (){var statearr_43527 = state_43508;
(statearr_43527[(14)] = inst_43449__$1);

return statearr_43527;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43508__$1,(10),inst_43450);
} else {
if((state_val_43509 === (25))){
var inst_43488 = (state_43508[(8)]);
var inst_43494 = cljs.core.doall.call(null,inst_43488);
var state_43508__$1 = state_43508;
var statearr_43528_43567 = state_43508__$1;
(statearr_43528_43567[(2)] = inst_43494);

(statearr_43528_43567[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (17))){
var inst_43480 = (state_43508[(2)]);
var state_43508__$1 = state_43508;
if(cljs.core.truth_(inst_43480)){
var statearr_43529_43568 = state_43508__$1;
(statearr_43529_43568[(1)] = (18));

} else {
var statearr_43530_43569 = state_43508__$1;
(statearr_43530_43569[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (3))){
var inst_43506 = (state_43508[(2)]);
var state_43508__$1 = state_43508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43508__$1,inst_43506);
} else {
if((state_val_43509 === (12))){
var inst_43433 = (state_43508[(12)]);
var inst_43466 = cljs.core.pr_str.call(null,inst_43433);
var inst_43467 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_43466].join('');
var inst_43468 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43469 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_43470 = cljs.core.PersistentHashMap.fromArrays(inst_43468,inst_43469);
var inst_43471 = cljs.core.ex_info.call(null,inst_43467,inst_43470);
var inst_43472 = (function(){throw inst_43471})();
var state_43508__$1 = state_43508;
var statearr_43531_43570 = state_43508__$1;
(statearr_43531_43570[(2)] = inst_43472);

(statearr_43531_43570[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (2))){
var inst_43434 = (state_43508[(7)]);
var _ = (function (){var statearr_43532 = state_43508;
(statearr_43532[(4)] = cljs.core.cons.call(null,(5),(state_43508[(4)])));

return statearr_43532;
})();
var inst_43433 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_43434__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_43435 = fluree.db.util.core.current_time_millis.call(null);
var inst_43436 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_43508__$1 = (function (){var statearr_43533 = state_43508;
(statearr_43533[(15)] = inst_43436);

(statearr_43533[(7)] = inst_43434__$1);

(statearr_43533[(12)] = inst_43433);

(statearr_43533[(10)] = inst_43435);

return statearr_43533;
})();
if(cljs.core.truth_(inst_43434__$1)){
var statearr_43534_43571 = state_43508__$1;
(statearr_43534_43571[(1)] = (7));

} else {
var statearr_43535_43572 = state_43508__$1;
(statearr_43535_43572[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (23))){
var inst_43488 = (state_43508[(8)]);
var state_43508__$1 = state_43508;
var statearr_43536_43573 = state_43508__$1;
(statearr_43536_43573[(2)] = inst_43488);

(statearr_43536_43573[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (19))){
var inst_43474 = (state_43508[(13)]);
var state_43508__$1 = state_43508;
var statearr_43537_43574 = state_43508__$1;
(statearr_43537_43574[(2)] = inst_43474);

(statearr_43537_43574[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (11))){
var inst_43455 = (state_43508[(16)]);
var inst_43454 = (state_43508[(17)]);
var inst_43449 = (state_43508[(14)]);
var inst_43461 = fluree.db.api.query.block_range.call(null,inst_43449,inst_43454,inst_43455,opts);
var state_43508__$1 = state_43508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43508__$1,(14),inst_43461);
} else {
if((state_val_43509 === (9))){
var inst_43436 = (state_43508[(15)]);
var inst_43443 = (state_43508[(2)]);
var inst_43444 = [inst_43443];
var inst_43445 = cljs.core.PersistentHashMap.fromArrays(inst_43436,inst_43444);
var inst_43446 = fluree.db.api.query.db.call(null,conn,ledger,inst_43445);
var state_43508__$1 = state_43508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43508__$1,(6),inst_43446);
} else {
if((state_val_43509 === (5))){
var _ = (function (){var statearr_43539 = state_43508;
(statearr_43539[(4)] = cljs.core.rest.call(null,(state_43508[(4)])));

return statearr_43539;
})();
var state_43508__$1 = state_43508;
var ex43538 = (state_43508__$1[(2)]);
var statearr_43540_43575 = state_43508__$1;
(statearr_43540_43575[(5)] = ex43538);


if((ex43538 instanceof Error)){
var statearr_43541_43576 = state_43508__$1;
(statearr_43541_43576[(1)] = (4));

(statearr_43541_43576[(5)] = null);

} else {
throw ex43538;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (14))){
var inst_43463 = (state_43508[(2)]);
var inst_43464 = fluree.db.util.async.throw_err.call(null,inst_43463);
var state_43508__$1 = state_43508;
var statearr_43542_43577 = state_43508__$1;
(statearr_43542_43577[(2)] = inst_43464);

(statearr_43542_43577[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (26))){
var inst_43488 = (state_43508[(8)]);
var state_43508__$1 = state_43508;
var statearr_43543_43578 = state_43508__$1;
(statearr_43543_43578[(2)] = inst_43488);

(statearr_43543_43578[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (16))){
var inst_43433 = (state_43508[(12)]);
var inst_43478 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_43433);
var state_43508__$1 = state_43508;
var statearr_43544_43579 = state_43508__$1;
(statearr_43544_43579[(2)] = inst_43478);

(statearr_43544_43579[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (10))){
var inst_43433 = (state_43508[(12)]);
var inst_43452 = (state_43508[(2)]);
var inst_43453 = fluree.db.util.async.throw_err.call(null,inst_43452);
var inst_43454 = cljs.core.nth.call(null,inst_43453,(0),null);
var inst_43455 = cljs.core.nth.call(null,inst_43453,(1),null);
var inst_43456 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_43457 = cljs.core.dissoc.call(null,inst_43433,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_43458 = cljs.core.keys.call(null,inst_43457);
var inst_43459 = cljs.core._EQ_.call(null,inst_43456,inst_43458);
var state_43508__$1 = (function (){var statearr_43545 = state_43508;
(statearr_43545[(16)] = inst_43455);

(statearr_43545[(17)] = inst_43454);

return statearr_43545;
})();
if(inst_43459){
var statearr_43546_43580 = state_43508__$1;
(statearr_43546_43580[(1)] = (11));

} else {
var statearr_43547_43581 = state_43508__$1;
(statearr_43547_43581[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43509 === (18))){
var inst_43449 = (state_43508[(14)]);
var inst_43474 = (state_43508[(13)]);
var inst_43482 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_43449,inst_43474);
var state_43508__$1 = state_43508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43508__$1,(21),inst_43482);
} else {
if((state_val_43509 === (8))){
var state_43508__$1 = state_43508;
var statearr_43548_43582 = state_43508__$1;
(statearr_43548_43582[(2)] = null);

(statearr_43548_43582[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2721__auto____0 = (function (){
var statearr_43549 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43549[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2721__auto__);

(statearr_43549[(1)] = (1));

return statearr_43549;
});
var fluree$db$api$query$block_query_async_$_state_machine__2721__auto____1 = (function (state_43508){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_43508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e43550){var ex__2724__auto__ = e43550;
var statearr_43551_43583 = state_43508;
(statearr_43551_43583[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_43508[(4)]))){
var statearr_43552_43584 = state_43508;
(statearr_43552_43584[(1)] = cljs.core.first.call(null,(state_43508[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43585 = state_43508;
state_43508 = G__43585;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2721__auto__ = function(state_43508){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2721__auto____1.call(this,state_43508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2721__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2721__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_43553 = f__2744__auto__.call(null);
(statearr_43553[(6)] = c__2743__auto__);

return statearr_43553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__43586 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__43586,(0),null);
var p = cljs.core.nth.call(null,vec__43586,(1),null);
var o = cljs.core.nth.call(null,vec__43586,(2),null);
var t = cljs.core.nth.call(null,vec__43586,(3),null);
var vec__43589 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__43589,(0),null);
var idx = cljs.core.nth.call(null,vec__43589,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__43592 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__43592,(0),null);
var id = cljs.core.nth.call(null,vec__43592,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___43596 = arguments.length;
var i__5770__auto___43597 = (0);
while(true){
if((i__5770__auto___43597 < len__5769__auto___43596)){
args__5775__auto__.push((arguments[i__5770__auto___43597]));

var G__43598 = (i__5770__auto___43597 + (1));
i__5770__auto___43597 = G__43598;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq43595){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq43595));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_43794){
var state_val_43795 = (state_43794[(1)]);
if((state_val_43795 === (7))){
var inst_43714 = (state_43794[(7)]);
var inst_43721 = (state_43794[(8)]);
var inst_43720 = cljs.core.seq.call(null,inst_43714);
var inst_43721__$1 = cljs.core.first.call(null,inst_43720);
var inst_43722 = cljs.core.next.call(null,inst_43720);
var state_43794__$1 = (function (){var statearr_43796 = state_43794;
(statearr_43796[(9)] = inst_43722);

(statearr_43796[(8)] = inst_43721__$1);

return statearr_43796;
})();
if(cljs.core.truth_(inst_43721__$1)){
var statearr_43797_43897 = state_43794__$1;
(statearr_43797_43897[(1)] = (9));

} else {
var statearr_43798_43898 = state_43794__$1;
(statearr_43798_43898[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (20))){
var inst_43784 = (state_43794[(2)]);
var state_43794__$1 = state_43794;
var statearr_43799_43899 = state_43794__$1;
(statearr_43799_43899[(2)] = inst_43784);

(statearr_43799_43899[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (27))){
var inst_43760 = (state_43794[(10)]);
var inst_43742 = (state_43794[(11)]);
var inst_43739 = (state_43794[(12)]);
var inst_43762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43763 = [inst_43742,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_43764 = (new cljs.core.PersistentVector(null,2,(5),inst_43762,inst_43763,null));
var inst_43765 = cljs.core.update_in.call(null,inst_43760,inst_43764,fluree.db.api.query.min_safe,inst_43739);
var state_43794__$1 = state_43794;
var statearr_43800_43900 = state_43794__$1;
(statearr_43800_43900[(2)] = inst_43765);

(statearr_43800_43900[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (1))){
var state_43794__$1 = state_43794;
var statearr_43801_43901 = state_43794__$1;
(statearr_43801_43901[(2)] = null);

(statearr_43801_43901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (24))){
var inst_43752 = (state_43794[(13)]);
var inst_43742 = (state_43794[(11)]);
var inst_43721 = (state_43794[(8)]);
var inst_43754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43755 = [inst_43742,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_43756 = (new cljs.core.PersistentVector(null,2,(5),inst_43754,inst_43755,null));
var inst_43757 = cljs.core.update_in.call(null,inst_43752,inst_43756,cljs.core.conj,inst_43721);
var state_43794__$1 = state_43794;
var statearr_43803_43902 = state_43794__$1;
(statearr_43803_43902[(2)] = inst_43757);

(statearr_43803_43902[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (4))){
var inst_43600 = (state_43794[(2)]);
var state_43794__$1 = state_43794;
var statearr_43804_43903 = state_43794__$1;
(statearr_43804_43903[(2)] = inst_43600);

(statearr_43804_43903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (15))){
var inst_43722 = (state_43794[(9)]);
var inst_43715 = (state_43794[(14)]);
var tmp43802 = inst_43715;
var inst_43714 = inst_43722;
var inst_43715__$1 = tmp43802;
var state_43794__$1 = (function (){var statearr_43805 = state_43794;
(statearr_43805[(7)] = inst_43714);

(statearr_43805[(14)] = inst_43715__$1);

return statearr_43805;
})();
var statearr_43806_43904 = state_43794__$1;
(statearr_43806_43904[(2)] = null);

(statearr_43806_43904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (21))){
var inst_43742 = (state_43794[(11)]);
var inst_43715 = (state_43794[(14)]);
var inst_43746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43747 = [inst_43742,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_43748 = (new cljs.core.PersistentVector(null,2,(5),inst_43746,inst_43747,null));
var inst_43749 = cljs.core.assoc_in.call(null,inst_43715,inst_43748,inst_43742);
var state_43794__$1 = state_43794;
var statearr_43807_43905 = state_43794__$1;
(statearr_43807_43905[(2)] = inst_43749);

(statearr_43807_43905[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (31))){
var inst_43768 = (state_43794[(15)]);
var state_43794__$1 = state_43794;
var statearr_43808_43906 = state_43794__$1;
(statearr_43808_43906[(2)] = inst_43768);

(statearr_43808_43906[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (32))){
var inst_43722 = (state_43794[(9)]);
var inst_43776 = (state_43794[(2)]);
var inst_43714 = inst_43722;
var inst_43715 = inst_43776;
var state_43794__$1 = (function (){var statearr_43809 = state_43794;
(statearr_43809[(7)] = inst_43714);

(statearr_43809[(14)] = inst_43715);

return statearr_43809;
})();
var statearr_43810_43907 = state_43794__$1;
(statearr_43810_43907[(2)] = null);

(statearr_43810_43907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (33))){
var inst_43715 = (state_43794[(14)]);
var state_43794__$1 = state_43794;
var statearr_43811_43908 = state_43794__$1;
(statearr_43811_43908[(2)] = inst_43715);

(statearr_43811_43908[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (13))){
var inst_43724 = (state_43794[(16)]);
var state_43794__$1 = state_43794;
var statearr_43812_43909 = state_43794__$1;
(statearr_43812_43909[(2)] = inst_43724);

(statearr_43812_43909[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (22))){
var inst_43715 = (state_43794[(14)]);
var state_43794__$1 = state_43794;
var statearr_43813_43910 = state_43794__$1;
(statearr_43813_43910[(2)] = inst_43715);

(statearr_43813_43910[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (29))){
var inst_43768 = (state_43794[(2)]);
var state_43794__$1 = (function (){var statearr_43814 = state_43794;
(statearr_43814[(15)] = inst_43768);

return statearr_43814;
})();
if(cljs.core.truth_(show_auth)){
var statearr_43815_43911 = state_43794__$1;
(statearr_43815_43911[(1)] = (30));

} else {
var statearr_43816_43912 = state_43794__$1;
(statearr_43816_43912[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (6))){
var inst_43700 = (state_43794[(2)]);
var inst_43701 = fluree.db.util.async.throw_err.call(null,inst_43700);
var inst_43709 = resp;
var inst_43710 = cljs.core.seq.call(null,inst_43709);
var inst_43711 = cljs.core.first.call(null,inst_43710);
var inst_43712 = cljs.core.next.call(null,inst_43710);
var inst_43713 = cljs.core.PersistentHashMap.EMPTY;
var inst_43714 = inst_43709;
var inst_43715 = inst_43713;
var state_43794__$1 = (function (){var statearr_43817 = state_43794;
(statearr_43817[(7)] = inst_43714);

(statearr_43817[(17)] = inst_43712);

(statearr_43817[(18)] = inst_43701);

(statearr_43817[(19)] = inst_43711);

(statearr_43817[(14)] = inst_43715);

return statearr_43817;
})();
var statearr_43818_43913 = state_43794__$1;
(statearr_43818_43913[(2)] = null);

(statearr_43818_43913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (28))){
var inst_43760 = (state_43794[(10)]);
var state_43794__$1 = state_43794;
var statearr_43819_43914 = state_43794__$1;
(statearr_43819_43914[(2)] = inst_43760);

(statearr_43819_43914[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (25))){
var inst_43752 = (state_43794[(13)]);
var state_43794__$1 = state_43794;
var statearr_43820_43915 = state_43794__$1;
(statearr_43820_43915[(2)] = inst_43752);

(statearr_43820_43915[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (34))){
var state_43794__$1 = state_43794;
var statearr_43821_43916 = state_43794__$1;
(statearr_43821_43916[(2)] = null);

(statearr_43821_43916[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (17))){
var inst_43786 = (state_43794[(2)]);
var state_43794__$1 = state_43794;
var statearr_43822_43917 = state_43794__$1;
(statearr_43822_43917[(2)] = inst_43786);

(statearr_43822_43917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (3))){
var inst_43792 = (state_43794[(2)]);
var state_43794__$1 = state_43794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43794__$1,inst_43792);
} else {
if((state_val_43795 === (12))){
var inst_43701 = (state_43794[(18)]);
var inst_43721 = (state_43794[(8)]);
var inst_43726 = fluree.db.api.query.auth_match.call(null,auth,inst_43701,inst_43721);
var inst_43727 = cljs.core.not.call(null,inst_43726);
var state_43794__$1 = state_43794;
var statearr_43823_43918 = state_43794__$1;
(statearr_43823_43918[(2)] = inst_43727);

(statearr_43823_43918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (2))){
var _ = (function (){var statearr_43824 = state_43794;
(statearr_43824[(4)] = cljs.core.cons.call(null,(5),(state_43794[(4)])));

return statearr_43824;
})();
var inst_43606 = (function (){return (function (p1__43599_SHARP_){
return p1__43599_SHARP_.t;
});
})();
var inst_43607 = cljs.core.map.call(null,inst_43606,resp);
var inst_43608 = cljs.core.set.call(null,inst_43607);
var inst_43696 = cljs.core.async.chan.call(null,(1));
var inst_43697 = (function (){var ts = inst_43608;
var c__2743__auto____$1 = inst_43696;
return (function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_43694){
var state_val_43695 = (state_43694[(1)]);
if((state_val_43695 === (7))){
var inst_43634 = (state_43694[(7)]);
var inst_43640 = (state_43694[(8)]);
var inst_43628 = (state_43694[(9)]);
var inst_43622 = (state_43694[(10)]);
var inst_43633 = (state_43694[(2)]);
var inst_43634__$1 = fluree.db.util.async.throw_err.call(null,inst_43633);
var inst_43636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43637 = [inst_43628,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_43638 = (new cljs.core.PersistentVector(null,2,(5),inst_43636,inst_43637,null));
var inst_43639 = cljs.core.assoc_in.call(null,inst_43622,inst_43638,inst_43634__$1);
var inst_43640__$1 = auth;
var state_43694__$1 = (function (){var statearr_43825 = state_43694;
(statearr_43825[(7)] = inst_43634__$1);

(statearr_43825[(11)] = inst_43639);

(statearr_43825[(8)] = inst_43640__$1);

return statearr_43825;
})();
if(cljs.core.truth_(inst_43640__$1)){
var statearr_43826_43919 = state_43694__$1;
(statearr_43826_43919[(1)] = (8));

} else {
var statearr_43827_43920 = state_43694__$1;
(statearr_43827_43920[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (1))){
var inst_43616 = (state_43694[(12)]);
var inst_43616__$1 = ts;
var inst_43617 = cljs.core.seq.call(null,inst_43616__$1);
var inst_43618 = cljs.core.first.call(null,inst_43617);
var inst_43619 = cljs.core.next.call(null,inst_43617);
var inst_43620 = cljs.core.PersistentHashMap.EMPTY;
var inst_43621 = inst_43616__$1;
var inst_43622 = inst_43620;
var state_43694__$1 = (function (){var statearr_43828 = state_43694;
(statearr_43828[(13)] = inst_43621);

(statearr_43828[(12)] = inst_43616__$1);

(statearr_43828[(14)] = inst_43619);

(statearr_43828[(15)] = inst_43618);

(statearr_43828[(10)] = inst_43622);

return statearr_43828;
})();
var statearr_43829_43921 = state_43694__$1;
(statearr_43829_43921[(2)] = null);

(statearr_43829_43921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (4))){
var inst_43628 = (state_43694[(9)]);
var inst_43631 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_43628);
var state_43694__$1 = state_43694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43694__$1,(7),inst_43631);
} else {
if((state_val_43695 === (13))){
var inst_43629 = (state_43694[(16)]);
var inst_43686 = (state_43694[(2)]);
var inst_43621 = inst_43629;
var inst_43622 = inst_43686;
var state_43694__$1 = (function (){var statearr_43830 = state_43694;
(statearr_43830[(13)] = inst_43621);

(statearr_43830[(10)] = inst_43622);

return statearr_43830;
})();
var statearr_43831_43922 = state_43694__$1;
(statearr_43831_43922[(2)] = null);

(statearr_43831_43922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (6))){
var inst_43690 = (state_43694[(2)]);
var state_43694__$1 = state_43694;
var statearr_43832_43923 = state_43694__$1;
(statearr_43832_43923[(2)] = inst_43690);

(statearr_43832_43923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (3))){
var inst_43692 = (state_43694[(2)]);
var state_43694__$1 = state_43694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43694__$1,inst_43692);
} else {
if((state_val_43695 === (12))){
var inst_43639 = (state_43694[(11)]);
var state_43694__$1 = state_43694;
var statearr_43833_43924 = state_43694__$1;
(statearr_43833_43924[(2)] = inst_43639);

(statearr_43833_43924[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (2))){
var inst_43621 = (state_43694[(13)]);
var inst_43628 = (state_43694[(9)]);
var inst_43627 = cljs.core.seq.call(null,inst_43621);
var inst_43628__$1 = cljs.core.first.call(null,inst_43627);
var inst_43629 = cljs.core.next.call(null,inst_43627);
var state_43694__$1 = (function (){var statearr_43834 = state_43694;
(statearr_43834[(16)] = inst_43629);

(statearr_43834[(9)] = inst_43628__$1);

return statearr_43834;
})();
if(cljs.core.truth_(inst_43628__$1)){
var statearr_43835_43925 = state_43694__$1;
(statearr_43835_43925[(1)] = (4));

} else {
var statearr_43836_43926 = state_43694__$1;
(statearr_43836_43926[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (11))){
var inst_43634 = (state_43694[(7)]);
var inst_43621 = (state_43694[(13)]);
var inst_43616 = (state_43694[(12)]);
var inst_43629 = (state_43694[(16)]);
var inst_43619 = (state_43694[(14)]);
var inst_43639 = (state_43694[(11)]);
var inst_43628 = (state_43694[(9)]);
var inst_43618 = (state_43694[(15)]);
var inst_43622 = (state_43694[(10)]);
var inst_43646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43647 = [inst_43628,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_43648 = (new cljs.core.PersistentVector(null,2,(5),inst_43646,inst_43647,null));
var inst_43661 = cljs.core.async.chan.call(null,(1));
var inst_43662 = (function (){var t = inst_43628;
var G__43612 = inst_43621;
var block = inst_43634;
var first__43615 = inst_43618;
var r = inst_43629;
var seq__43614 = inst_43619;
var vec__43624 = inst_43621;
var c__2743__auto____$2 = inst_43661;
var acc = inst_43622;
var G__43635 = inst_43639;
var first__43626 = inst_43628;
var vec__43613 = inst_43616;
var seq__43625 = inst_43629;
return (function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_43659){
var state_val_43660 = (state_43659[(1)]);
if((state_val_43660 === (1))){
var state_43659__$1 = state_43659;
var statearr_43837_43927 = state_43659__$1;
(statearr_43837_43927[(2)] = null);

(statearr_43837_43927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43660 === (2))){
var ___$1 = (function (){var statearr_43838 = state_43659;
(statearr_43838[(4)] = cljs.core.cons.call(null,(5),(state_43659[(4)])));

return statearr_43838;
})();
var ___$2 = (function (){var statearr_43839 = state_43659;
(statearr_43839[(4)] = cljs.core.rest.call(null,(state_43659[(4)])));

return statearr_43839;
})();
var state_43659__$1 = state_43659;
var statearr_43840_43928 = state_43659__$1;
(statearr_43840_43928[(2)] = db);

(statearr_43840_43928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43660 === (3))){
var inst_43657 = (state_43659[(2)]);
var state_43659__$1 = state_43659;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43659__$1,inst_43657);
} else {
if((state_val_43660 === (4))){
var inst_43649 = (state_43659[(2)]);
var state_43659__$1 = state_43659;
var statearr_43842_43929 = state_43659__$1;
(statearr_43842_43929[(2)] = inst_43649);

(statearr_43842_43929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43660 === (5))){
var ___$1 = (function (){var statearr_43843 = state_43659;
(statearr_43843[(4)] = cljs.core.rest.call(null,(state_43659[(4)])));

return statearr_43843;
})();
var state_43659__$1 = state_43659;
var ex43841 = (state_43659__$1[(2)]);
var statearr_43844_43930 = state_43659__$1;
(statearr_43844_43930[(5)] = ex43841);


if((ex43841 instanceof Error)){
var statearr_43845_43931 = state_43659__$1;
(statearr_43845_43931[(1)] = (4));

(statearr_43845_43931[(5)] = null);

} else {
throw ex43841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0 = (function (){
var statearr_43846 = [null,null,null,null,null,null,null];
(statearr_43846[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__);

(statearr_43846[(1)] = (1));

return statearr_43846;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1 = (function (state_43659){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_43659);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e43847){var ex__2724__auto__ = e43847;
var statearr_43848_43932 = state_43659;
(statearr_43848_43932[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_43659[(4)]))){
var statearr_43849_43933 = state_43659;
(statearr_43849_43933[(1)] = cljs.core.first.call(null,(state_43659[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43934 = state_43659;
state_43659 = G__43934;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__ = function(state_43659){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1.call(this,state_43659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_43850 = f__2744__auto__.call(null);
(statearr_43850[(6)] = c__2743__auto____$2);

return statearr_43850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
});
})();
var inst_43663 = cljs.core.async.impl.dispatch.run.call(null,inst_43662);
var inst_43664 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_43665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43666 = ["?auth","?id"];
var inst_43667 = (new cljs.core.PersistentVector(null,2,(5),inst_43665,inst_43666,null));
var inst_43668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43670 = [inst_43628,"_tx/auth","?auth"];
var inst_43671 = (new cljs.core.PersistentVector(null,3,(5),inst_43669,inst_43670,null));
var inst_43672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43673 = ["?auth","_auth/id","?id"];
var inst_43674 = (new cljs.core.PersistentVector(null,3,(5),inst_43672,inst_43673,null));
var inst_43675 = [inst_43671,inst_43674];
var inst_43676 = (new cljs.core.PersistentVector(null,2,(5),inst_43668,inst_43675,null));
var inst_43677 = [inst_43667,inst_43676];
var inst_43678 = cljs.core.PersistentHashMap.fromArrays(inst_43664,inst_43677);
var inst_43679 = fluree.db.api.query.query_async.call(null,inst_43661,inst_43678);
var state_43694__$1 = (function (){var statearr_43851 = state_43694;
(statearr_43851[(17)] = inst_43648);

(statearr_43851[(18)] = inst_43663);

return statearr_43851;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43694__$1,(14),inst_43679);
} else {
if((state_val_43695 === (9))){
var state_43694__$1 = state_43694;
var statearr_43852_43935 = state_43694__$1;
(statearr_43852_43935[(2)] = show_auth);

(statearr_43852_43935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (5))){
var inst_43622 = (state_43694[(10)]);
var state_43694__$1 = state_43694;
var statearr_43853_43936 = state_43694__$1;
(statearr_43853_43936[(2)] = inst_43622);

(statearr_43853_43936[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (14))){
var inst_43648 = (state_43694[(17)]);
var inst_43639 = (state_43694[(11)]);
var inst_43681 = (state_43694[(2)]);
var inst_43682 = fluree.db.util.async.throw_err.call(null,inst_43681);
var inst_43683 = cljs.core.assoc_in.call(null,inst_43639,inst_43648,inst_43682);
var state_43694__$1 = state_43694;
var statearr_43854_43937 = state_43694__$1;
(statearr_43854_43937[(2)] = inst_43683);

(statearr_43854_43937[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (10))){
var inst_43644 = (state_43694[(2)]);
var state_43694__$1 = state_43694;
if(cljs.core.truth_(inst_43644)){
var statearr_43855_43938 = state_43694__$1;
(statearr_43855_43938[(1)] = (11));

} else {
var statearr_43856_43939 = state_43694__$1;
(statearr_43856_43939[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43695 === (8))){
var inst_43640 = (state_43694[(8)]);
var state_43694__$1 = state_43694;
var statearr_43857_43940 = state_43694__$1;
(statearr_43857_43940[(2)] = inst_43640);

(statearr_43857_43940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0 = (function (){
var statearr_43858 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43858[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__);

(statearr_43858[(1)] = (1));

return statearr_43858;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1 = (function (state_43694){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_43694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e43859){var ex__2724__auto__ = e43859;
var statearr_43860_43941 = state_43694;
(statearr_43860_43941[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_43694[(4)]))){
var statearr_43861_43942 = state_43694;
(statearr_43861_43942[(1)] = cljs.core.first.call(null,(state_43694[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43943 = state_43694;
state_43694 = G__43943;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__ = function(state_43694){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1.call(this,state_43694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_43862 = f__2744__auto__.call(null);
(statearr_43862[(6)] = c__2743__auto____$1);

return statearr_43862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
});
})();
var inst_43698 = cljs.core.async.impl.dispatch.run.call(null,inst_43697);
var state_43794__$1 = (function (){var statearr_43863 = state_43794;
(statearr_43863[(20)] = inst_43698);

return statearr_43863;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43794__$1,(6),inst_43696);
} else {
if((state_val_43795 === (23))){
var inst_43752 = (state_43794[(2)]);
var state_43794__$1 = (function (){var statearr_43864 = state_43794;
(statearr_43864[(13)] = inst_43752);

return statearr_43864;
})();
var statearr_43865_43944 = state_43794__$1;
(statearr_43865_43944[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (35))){
var inst_43782 = (state_43794[(2)]);
var state_43794__$1 = state_43794;
var statearr_43867_43945 = state_43794__$1;
(statearr_43867_43945[(2)] = inst_43782);

(statearr_43867_43945[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (19))){
var state_43794__$1 = state_43794;
var statearr_43868_43946 = state_43794__$1;
(statearr_43868_43946[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (11))){
var inst_43733 = (state_43794[(2)]);
var state_43794__$1 = state_43794;
if(cljs.core.truth_(inst_43733)){
var statearr_43871_43947 = state_43794__$1;
(statearr_43871_43947[(1)] = (15));

} else {
var statearr_43872_43948 = state_43794__$1;
(statearr_43872_43948[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (9))){
var inst_43724 = (state_43794[(16)]);
var inst_43724__$1 = auth;
var state_43794__$1 = (function (){var statearr_43873 = state_43794;
(statearr_43873[(16)] = inst_43724__$1);

return statearr_43873;
})();
if(cljs.core.truth_(inst_43724__$1)){
var statearr_43874_43949 = state_43794__$1;
(statearr_43874_43949[(1)] = (12));

} else {
var statearr_43875_43950 = state_43794__$1;
(statearr_43875_43950[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (5))){
var _ = (function (){var statearr_43876 = state_43794;
(statearr_43876[(4)] = cljs.core.rest.call(null,(state_43794[(4)])));

return statearr_43876;
})();
var state_43794__$1 = state_43794;
var ex43870 = (state_43794__$1[(2)]);
var statearr_43877_43951 = state_43794__$1;
(statearr_43877_43951[(5)] = ex43870);


if((ex43870 instanceof Error)){
var statearr_43878_43952 = state_43794__$1;
(statearr_43878_43952[(1)] = (4));

(statearr_43878_43952[(5)] = null);

} else {
throw ex43870;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (14))){
var inst_43730 = (state_43794[(2)]);
var state_43794__$1 = state_43794;
var statearr_43879_43953 = state_43794__$1;
(statearr_43879_43953[(2)] = inst_43730);

(statearr_43879_43953[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (26))){
var inst_43760 = (state_43794[(2)]);
var state_43794__$1 = (function (){var statearr_43880 = state_43794;
(statearr_43880[(10)] = inst_43760);

return statearr_43880;
})();
var statearr_43881_43954 = state_43794__$1;
(statearr_43881_43954[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (16))){
var inst_43721 = (state_43794[(8)]);
var state_43794__$1 = state_43794;
if(cljs.core.truth_(inst_43721)){
var statearr_43883_43955 = state_43794__$1;
(statearr_43883_43955[(1)] = (18));

} else {
var statearr_43884_43956 = state_43794__$1;
(statearr_43884_43956[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (30))){
var inst_43742 = (state_43794[(11)]);
var inst_43743 = (state_43794[(21)]);
var inst_43768 = (state_43794[(15)]);
var inst_43770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43771 = [inst_43742,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_43772 = (new cljs.core.PersistentVector(null,2,(5),inst_43770,inst_43771,null));
var inst_43773 = cljs.core.assoc_in.call(null,inst_43768,inst_43772,inst_43743);
var state_43794__$1 = state_43794;
var statearr_43885_43957 = state_43794__$1;
(statearr_43885_43957[(2)] = inst_43773);

(statearr_43885_43957[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (10))){
var inst_43721 = (state_43794[(8)]);
var state_43794__$1 = state_43794;
var statearr_43886_43958 = state_43794__$1;
(statearr_43886_43958[(2)] = inst_43721);

(statearr_43886_43958[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (18))){
var inst_43701 = (state_43794[(18)]);
var inst_43739 = (state_43794[(12)]);
var inst_43721 = (state_43794[(8)]);
var inst_43739__$1 = inst_43721.t;
var inst_43740 = cljs.core.get.call(null,inst_43701,inst_43739__$1);
var inst_43741 = cljs.core.__destructure_map.call(null,inst_43740);
var inst_43742 = cljs.core.get.call(null,inst_43741,new cljs.core.Keyword(null,"block","block",664686210));
var inst_43743 = cljs.core.get.call(null,inst_43741,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_43794__$1 = (function (){var statearr_43887 = state_43794;
(statearr_43887[(11)] = inst_43742);

(statearr_43887[(21)] = inst_43743);

(statearr_43887[(12)] = inst_43739__$1);

return statearr_43887;
})();
var statearr_43888_43959 = state_43794__$1;
(statearr_43888_43959[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43795 === (8))){
var inst_43788 = (state_43794[(2)]);
var inst_43789 = cljs.core.vals.call(null,inst_43788);
var _ = (function (){var statearr_43890 = state_43794;
(statearr_43890[(4)] = cljs.core.rest.call(null,(state_43794[(4)])));

return statearr_43890;
})();
var state_43794__$1 = state_43794;
var statearr_43891_43960 = state_43794__$1;
(statearr_43891_43960[(2)] = inst_43789);

(statearr_43891_43960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0 = (function (){
var statearr_43892 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43892[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__);

(statearr_43892[(1)] = (1));

return statearr_43892;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1 = (function (state_43794){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_43794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e43893){var ex__2724__auto__ = e43893;
var statearr_43894_43961 = state_43794;
(statearr_43894_43961[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_43794[(4)]))){
var statearr_43895_43962 = state_43794;
(statearr_43895_43962[(1)] = cljs.core.first.call(null,(state_43794[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43963 = state_43794;
state_43794 = G__43963;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__ = function(state_43794){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1.call(this,state_43794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2721__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_43896 = f__2744__auto__.call(null);
(statearr_43896[(6)] = c__2743__auto__);

return statearr_43896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_44090){
var state_val_44091 = (state_44090[(1)]);
if((state_val_44091 === (7))){
var inst_43986 = (state_44090[(7)]);
var inst_43988 = fluree.db.api.query.resolve_block_range.call(null,inst_43986,query_map);
var state_44090__$1 = state_44090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44090__$1,(10),inst_43988);
} else {
if((state_val_44091 === (20))){
var inst_44015 = (state_44090[(2)]);
var inst_44016 = fluree.db.util.async.throw_err.call(null,inst_44015);
var inst_44017 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_44016);
var inst_44018 = (inst_44017 - (1));
var state_44090__$1 = state_44090;
var statearr_44092_44155 = state_44090__$1;
(statearr_44092_44155[(2)] = inst_44018);

(statearr_44092_44155[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (27))){
var state_44090__$1 = state_44090;
var statearr_44093_44156 = state_44090__$1;
(statearr_44093_44156[(2)] = null);

(statearr_44093_44156[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (1))){
var state_44090__$1 = state_44090;
var statearr_44094_44157 = state_44090__$1;
(statearr_44094_44157[(2)] = null);

(statearr_44094_44157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (24))){
var inst_44025 = (state_44090[(2)]);
var inst_44026 = fluree.db.util.async.throw_err.call(null,inst_44025);
var inst_44027 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_44026);
var state_44090__$1 = state_44090;
var statearr_44095_44158 = state_44090__$1;
(statearr_44095_44158[(2)] = inst_44027);

(statearr_44095_44158[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (39))){
var inst_44062 = (state_44090[(2)]);
var inst_44063 = fluree.db.util.async.throw_err.call(null,inst_44062);
var state_44090__$1 = state_44090;
var statearr_44096_44159 = state_44090__$1;
(statearr_44096_44159[(2)] = inst_44063);

(statearr_44096_44159[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (4))){
var inst_43964 = (state_44090[(2)]);
var state_44090__$1 = state_44090;
var statearr_44097_44160 = state_44090__$1;
(statearr_44097_44160[(2)] = inst_43964);

(statearr_44097_44160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (15))){
var inst_43995 = (state_44090[(8)]);
var state_44090__$1 = state_44090;
var statearr_44098_44161 = state_44090__$1;
(statearr_44098_44161[(2)] = inst_43995);

(statearr_44098_44161[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (21))){
var inst_43996 = (state_44090[(9)]);
var inst_43986 = (state_44090[(7)]);
var inst_44023 = fluree.db.time_travel.as_of_block.call(null,inst_43986,inst_43996);
var state_44090__$1 = state_44090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44090__$1,(24),inst_44023);
} else {
if((state_val_44091 === (31))){
var inst_43980 = (state_44090[(10)]);
var state_44090__$1 = state_44090;
var statearr_44099_44162 = state_44090__$1;
(statearr_44099_44162[(2)] = inst_43980);

(statearr_44099_44162[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (32))){
var inst_44046 = (state_44090[(11)]);
var inst_43986 = (state_44090[(7)]);
var inst_44041 = (state_44090[(12)]);
var inst_44050 = (state_44090[(2)]);
var inst_44051 = fluree.db.api.query.format_history_resp.call(null,inst_43986,inst_44041,inst_44046,inst_44050);
var state_44090__$1 = state_44090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44090__$1,(29),inst_44051);
} else {
if((state_val_44091 === (40))){
var inst_44067 = (state_44090[(13)]);
var inst_44041 = (state_44090[(12)]);
var inst_44069 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_44070 = cljs.core.count.call(null,inst_44041);
var inst_44071 = [inst_44067,inst_44070,(200)];
var inst_44072 = cljs.core.PersistentHashMap.fromArrays(inst_44069,inst_44071);
var state_44090__$1 = state_44090;
var statearr_44100_44163 = state_44090__$1;
(statearr_44100_44163[(2)] = inst_44072);

(statearr_44100_44163[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (33))){
var inst_43979 = (state_44090[(14)]);
var state_44090__$1 = state_44090;
var statearr_44101_44164 = state_44090__$1;
(statearr_44101_44164[(2)] = inst_43979);

(statearr_44101_44164[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (13))){
var inst_44085 = (state_44090[(2)]);
var _ = (function (){var statearr_44102 = state_44090;
(statearr_44102[(4)] = cljs.core.rest.call(null,(state_44090[(4)])));

return statearr_44102;
})();
var state_44090__$1 = state_44090;
var statearr_44103_44165 = state_44090__$1;
(statearr_44103_44165[(2)] = inst_44085);

(statearr_44103_44165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (22))){
var inst_43986 = (state_44090[(7)]);
var inst_44029 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_43986);
var state_44090__$1 = state_44090;
var statearr_44104_44166 = state_44090__$1;
(statearr_44104_44166[(2)] = inst_44029);

(statearr_44104_44166[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (36))){
var inst_44054 = (state_44090[(15)]);
var inst_43986 = (state_44090[(7)]);
var inst_44060 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_43986,inst_44054);
var state_44090__$1 = state_44090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44090__$1,(39),inst_44060);
} else {
if((state_val_44091 === (41))){
var inst_44067 = (state_44090[(13)]);
var state_44090__$1 = state_44090;
var statearr_44105_44167 = state_44090__$1;
(statearr_44105_44167[(2)] = inst_44067);

(statearr_44105_44167[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (29))){
var inst_43979 = (state_44090[(14)]);
var inst_44053 = (state_44090[(2)]);
var inst_44054 = fluree.db.util.async.throw_err.call(null,inst_44053);
var state_44090__$1 = (function (){var statearr_44106 = state_44090;
(statearr_44106[(15)] = inst_44054);

return statearr_44106;
})();
if(cljs.core.truth_(inst_43979)){
var statearr_44107_44168 = state_44090__$1;
(statearr_44107_44168[(1)] = (33));

} else {
var statearr_44108_44169 = state_44090__$1;
(statearr_44108_44169[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (6))){
var inst_43976 = (state_44090[(16)]);
var inst_43985 = (state_44090[(2)]);
var inst_43986 = fluree.db.util.async.throw_err.call(null,inst_43985);
var state_44090__$1 = (function (){var statearr_44109 = state_44090;
(statearr_44109[(7)] = inst_43986);

return statearr_44109;
})();
if(cljs.core.truth_(inst_43976)){
var statearr_44110_44170 = state_44090__$1;
(statearr_44110_44170[(1)] = (7));

} else {
var statearr_44111_44171 = state_44090__$1;
(statearr_44111_44171[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (28))){
var inst_43981 = (state_44090[(17)]);
var inst_44046 = (state_44090[(2)]);
var state_44090__$1 = (function (){var statearr_44112 = state_44090;
(statearr_44112[(11)] = inst_44046);

return statearr_44112;
})();
if(cljs.core.truth_(inst_43981)){
var statearr_44113_44172 = state_44090__$1;
(statearr_44113_44172[(1)] = (30));

} else {
var statearr_44114_44173 = state_44090__$1;
(statearr_44114_44173[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (25))){
var inst_43982 = (state_44090[(18)]);
var inst_44040 = (state_44090[(2)]);
var inst_44041 = fluree.db.util.async.throw_err.call(null,inst_44040);
var state_44090__$1 = (function (){var statearr_44115 = state_44090;
(statearr_44115[(12)] = inst_44041);

return statearr_44115;
})();
if(cljs.core.truth_(inst_43982)){
var statearr_44116_44174 = state_44090__$1;
(statearr_44116_44174[(1)] = (26));

} else {
var statearr_44117_44175 = state_44090__$1;
(statearr_44117_44175[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (34))){
var inst_43978 = (state_44090[(19)]);
var state_44090__$1 = state_44090;
var statearr_44118_44176 = state_44090__$1;
(statearr_44118_44176[(2)] = inst_43978);

(statearr_44118_44176[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (17))){
var inst_43986 = (state_44090[(7)]);
var inst_43995 = (state_44090[(8)]);
var inst_44012 = (inst_43995 - (1));
var inst_44013 = fluree.db.time_travel.as_of_block.call(null,inst_43986,inst_44012);
var state_44090__$1 = state_44090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44090__$1,(20),inst_44013);
} else {
if((state_val_44091 === (3))){
var inst_44088 = (state_44090[(2)]);
var state_44090__$1 = state_44090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44090__$1,inst_44088);
} else {
if((state_val_44091 === (12))){
var inst_44077 = cljs.core.pr_str.call(null,query_map);
var inst_44078 = ["History query not properly formatted. Provided ",inst_44077].join('');
var inst_44079 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44080 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_44081 = cljs.core.PersistentHashMap.fromArrays(inst_44079,inst_44080);
var inst_44082 = cljs.core.ex_info.call(null,inst_44078,inst_44081);
var inst_44083 = (function(){throw inst_44082})();
var state_44090__$1 = state_44090;
var statearr_44119_44177 = state_44090__$1;
(statearr_44119_44177[(2)] = inst_44083);

(statearr_44119_44177[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (2))){
var _ = (function (){var statearr_44120 = state_44090;
(statearr_44120[(4)] = cljs.core.cons.call(null,(5),(state_44090[(4)])));

return statearr_44120;
})();
var inst_43974 = query_map;
var inst_43975 = cljs.core.__destructure_map.call(null,inst_43974);
var inst_43976 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"block","block",664686210));
var inst_43977 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_43978 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_43979 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_43980 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_43981 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_43982 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_43983 = cljs.core.get.call(null,inst_43975,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_44090__$1 = (function (){var statearr_44121 = state_44090;
(statearr_44121[(18)] = inst_43982);

(statearr_44121[(20)] = inst_43977);

(statearr_44121[(14)] = inst_43979);

(statearr_44121[(19)] = inst_43978);

(statearr_44121[(10)] = inst_43980);

(statearr_44121[(16)] = inst_43976);

(statearr_44121[(21)] = inst_43983);

(statearr_44121[(17)] = inst_43981);

return statearr_44121;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44090__$1,(6),sources);
} else {
if((state_val_44091 === (23))){
var inst_43977 = (state_44090[(20)]);
var inst_44021 = (state_44090[(22)]);
var inst_43986 = (state_44090[(7)]);
var inst_44031 = (state_44090[(2)]);
var inst_44032 = fluree.db.api.query.get_history_pattern.call(null,inst_43977);
var inst_44033 = cljs.core.nth.call(null,inst_44032,(0),null);
var inst_44034 = cljs.core.nth.call(null,inst_44032,(1),null);
var inst_44035 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_44036 = [inst_44021,inst_44031];
var inst_44037 = cljs.core.PersistentHashMap.fromArrays(inst_44035,inst_44036);
var inst_44038 = fluree.db.query.range.time_range.call(null,inst_43986,inst_44034,cljs.core._EQ_,inst_44033,inst_44037);
var state_44090__$1 = state_44090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44090__$1,(25),inst_44038);
} else {
if((state_val_44091 === (35))){
var inst_44058 = (state_44090[(2)]);
var state_44090__$1 = state_44090;
if(cljs.core.truth_(inst_44058)){
var statearr_44122_44178 = state_44090__$1;
(statearr_44122_44178[(1)] = (36));

} else {
var statearr_44123_44179 = state_44090__$1;
(statearr_44123_44179[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (19))){
var inst_43996 = (state_44090[(9)]);
var inst_44021 = (state_44090[(2)]);
var state_44090__$1 = (function (){var statearr_44124 = state_44090;
(statearr_44124[(22)] = inst_44021);

return statearr_44124;
})();
if(cljs.core.truth_(inst_43996)){
var statearr_44125_44180 = state_44090__$1;
(statearr_44125_44180[(1)] = (21));

} else {
var statearr_44126_44181 = state_44090__$1;
(statearr_44126_44181[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (11))){
var inst_43983 = (state_44090[(21)]);
var inst_43995 = (state_44090[(8)]);
var inst_44005 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_43983);
var state_44090__$1 = (function (){var statearr_44128 = state_44090;
(statearr_44128[(23)] = inst_44005);

return statearr_44128;
})();
if(cljs.core.truth_(inst_43995)){
var statearr_44129_44182 = state_44090__$1;
(statearr_44129_44182[(1)] = (14));

} else {
var statearr_44130_44183 = state_44090__$1;
(statearr_44130_44183[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (9))){
var inst_43994 = (state_44090[(2)]);
var inst_43995 = cljs.core.nth.call(null,inst_43994,(0),null);
var inst_43996 = cljs.core.nth.call(null,inst_43994,(1),null);
var inst_43997 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_43998 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_43999 = cljs.core.keys.call(null,inst_43998);
var inst_44000 = cljs.core._EQ_.call(null,inst_43997,inst_43999);
var state_44090__$1 = (function (){var statearr_44131 = state_44090;
(statearr_44131[(9)] = inst_43996);

(statearr_44131[(8)] = inst_43995);

return statearr_44131;
})();
if(inst_44000){
var statearr_44132_44184 = state_44090__$1;
(statearr_44132_44184[(1)] = (11));

} else {
var statearr_44133_44185 = state_44090__$1;
(statearr_44133_44185[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (5))){
var _ = (function (){var statearr_44134 = state_44090;
(statearr_44134[(4)] = cljs.core.rest.call(null,(state_44090[(4)])));

return statearr_44134;
})();
var state_44090__$1 = state_44090;
var ex44127 = (state_44090__$1[(2)]);
var statearr_44135_44186 = state_44090__$1;
(statearr_44135_44186[(5)] = ex44127);


if((ex44127 instanceof Error)){
var statearr_44136_44187 = state_44090__$1;
(statearr_44136_44187[(1)] = (4));

(statearr_44136_44187[(5)] = null);

} else {
throw ex44127;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (14))){
var inst_43995 = (state_44090[(8)]);
var inst_44007 = cljs.core.not_EQ_.call(null,(1),inst_43995);
var state_44090__$1 = state_44090;
var statearr_44137_44188 = state_44090__$1;
(statearr_44137_44188[(2)] = inst_44007);

(statearr_44137_44188[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (26))){
var inst_43982 = (state_44090[(18)]);
var inst_44043 = cljs.core.set.call(null,inst_43982);
var state_44090__$1 = state_44090;
var statearr_44138_44189 = state_44090__$1;
(statearr_44138_44189[(2)] = inst_44043);

(statearr_44138_44189[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (16))){
var inst_44010 = (state_44090[(2)]);
var state_44090__$1 = state_44090;
if(cljs.core.truth_(inst_44010)){
var statearr_44139_44190 = state_44090__$1;
(statearr_44139_44190[(1)] = (17));

} else {
var statearr_44140_44191 = state_44090__$1;
(statearr_44140_44191[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (38))){
var inst_44005 = (state_44090[(23)]);
var inst_44067 = (state_44090[(2)]);
var state_44090__$1 = (function (){var statearr_44141 = state_44090;
(statearr_44141[(13)] = inst_44067);

return statearr_44141;
})();
if(cljs.core.truth_(inst_44005)){
var statearr_44142_44192 = state_44090__$1;
(statearr_44142_44192[(1)] = (40));

} else {
var statearr_44143_44193 = state_44090__$1;
(statearr_44143_44193[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (30))){
var inst_43981 = (state_44090[(17)]);
var state_44090__$1 = state_44090;
var statearr_44144_44194 = state_44090__$1;
(statearr_44144_44194[(2)] = inst_43981);

(statearr_44144_44194[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (10))){
var inst_43990 = (state_44090[(2)]);
var inst_43991 = fluree.db.util.async.throw_err.call(null,inst_43990);
var state_44090__$1 = state_44090;
var statearr_44145_44195 = state_44090__$1;
(statearr_44145_44195[(2)] = inst_43991);

(statearr_44145_44195[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (18))){
var state_44090__$1 = state_44090;
var statearr_44146_44196 = state_44090__$1;
(statearr_44146_44196[(2)] = (-1));

(statearr_44146_44196[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (42))){
var inst_44075 = (state_44090[(2)]);
var state_44090__$1 = state_44090;
var statearr_44147_44197 = state_44090__$1;
(statearr_44147_44197[(2)] = inst_44075);

(statearr_44147_44197[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (37))){
var inst_44054 = (state_44090[(15)]);
var inst_44065 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_44054);
var state_44090__$1 = state_44090;
var statearr_44148_44198 = state_44090__$1;
(statearr_44148_44198[(2)] = inst_44065);

(statearr_44148_44198[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44091 === (8))){
var state_44090__$1 = state_44090;
var statearr_44149_44199 = state_44090__$1;
(statearr_44149_44199[(2)] = null);

(statearr_44149_44199[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2721__auto____0 = (function (){
var statearr_44150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44150[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2721__auto__);

(statearr_44150[(1)] = (1));

return statearr_44150;
});
var fluree$db$api$query$history_query_async_$_state_machine__2721__auto____1 = (function (state_44090){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_44090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e44151){var ex__2724__auto__ = e44151;
var statearr_44152_44200 = state_44090;
(statearr_44152_44200[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_44090[(4)]))){
var statearr_44153_44201 = state_44090;
(statearr_44153_44201[(1)] = cljs.core.first.call(null,(state_44090[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44202 = state_44090;
state_44090 = G__44202;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2721__auto__ = function(state_44090){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2721__auto____1.call(this,state_44090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2721__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2721__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_44154 = f__2744__auto__.call(null);
(statearr_44154[(6)] = c__2743__auto__);

return statearr_44154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_44335){
var state_val_44336 = (state_44335[(1)]);
if((state_val_44336 === (7))){
var inst_44232 = cljs.core.pr_str.call(null,flureeQL);
var inst_44233 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_44232].join('');
var inst_44234 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44235 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_44236 = cljs.core.PersistentHashMap.fromArrays(inst_44234,inst_44235);
var inst_44237 = cljs.core.ex_info.call(null,inst_44233,inst_44236);
var inst_44238 = (function(){throw inst_44237})();
var state_44335__$1 = state_44335;
var statearr_44337_44416 = state_44335__$1;
(statearr_44337_44416[(2)] = inst_44238);

(statearr_44337_44416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (20))){
var inst_44270 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
if(cljs.core.truth_(inst_44270)){
var statearr_44338_44417 = state_44335__$1;
(statearr_44338_44417[(1)] = (21));

} else {
var statearr_44339_44418 = state_44335__$1;
(statearr_44339_44418[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (27))){
var inst_44214 = (state_44335[(7)]);
var state_44335__$1 = state_44335;
var statearr_44340_44419 = state_44335__$1;
(statearr_44340_44419[(2)] = inst_44214);

(statearr_44340_44419[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (1))){
var state_44335__$1 = state_44335;
var statearr_44341_44420 = state_44335__$1;
(statearr_44341_44420[(2)] = null);

(statearr_44341_44420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (24))){
var inst_44276 = (state_44335[(8)]);
var state_44335__$1 = state_44335;
var statearr_44342_44421 = state_44335__$1;
(statearr_44342_44421[(2)] = inst_44276);

(statearr_44342_44421[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (39))){
var inst_44220 = (state_44335[(9)]);
var state_44335__$1 = state_44335;
if(cljs.core.truth_(inst_44220)){
var statearr_44343_44422 = state_44335__$1;
(statearr_44343_44422[(1)] = (42));

} else {
var statearr_44344_44423 = state_44335__$1;
(statearr_44344_44423[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (46))){
var inst_44308 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44309 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_44310 = cljs.core.PersistentHashMap.fromArrays(inst_44308,inst_44309);
var inst_44311 = cljs.core.ex_info.call(null,"Invalid query.",inst_44310);
var inst_44312 = (function(){throw inst_44311})();
var state_44335__$1 = state_44335;
var statearr_44345_44424 = state_44335__$1;
(statearr_44345_44424[(2)] = inst_44312);

(statearr_44345_44424[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (4))){
var inst_44204 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
var statearr_44346_44425 = state_44335__$1;
(statearr_44346_44425[(2)] = inst_44204);

(statearr_44346_44425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (15))){
var inst_44255 = (state_44335[(10)]);
var inst_44217 = (state_44335[(11)]);
var inst_44257 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_44255);
var inst_44258 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_44255);
var inst_44259 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_44255);
var inst_44260 = fluree.db.api.query.get_sources.call(null,inst_44257,inst_44258,inst_44259,inst_44217);
var state_44335__$1 = state_44335;
var statearr_44347_44426 = state_44335__$1;
(statearr_44347_44426[(2)] = inst_44260);

(statearr_44347_44426[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (48))){
var inst_44265 = (state_44335[(12)]);
var inst_44319 = (state_44335[(2)]);
var inst_44320 = fluree.db.util.async.throw_err.call(null,inst_44319);
var state_44335__$1 = (function (){var statearr_44348 = state_44335;
(statearr_44348[(13)] = inst_44320);

return statearr_44348;
})();
if(cljs.core.truth_(inst_44265)){
var statearr_44349_44427 = state_44335__$1;
(statearr_44349_44427[(1)] = (49));

} else {
var statearr_44350_44428 = state_44335__$1;
(statearr_44350_44428[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (50))){
var inst_44320 = (state_44335[(13)]);
var state_44335__$1 = state_44335;
var statearr_44351_44429 = state_44335__$1;
(statearr_44351_44429[(2)] = inst_44320);

(statearr_44351_44429[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (21))){
var inst_44272 = cljs.core.volatile_BANG_.call(null,(0));
var state_44335__$1 = state_44335;
var statearr_44352_44430 = state_44335__$1;
(statearr_44352_44430[(2)] = inst_44272);

(statearr_44352_44430[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (31))){
var inst_44218 = (state_44335[(14)]);
var state_44335__$1 = state_44335;
if(cljs.core.truth_(inst_44218)){
var statearr_44353_44431 = state_44335__$1;
(statearr_44353_44431[(1)] = (33));

} else {
var statearr_44354_44432 = state_44335__$1;
(statearr_44354_44432[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (32))){
var inst_44295 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
var statearr_44355_44433 = state_44335__$1;
(statearr_44355_44433[(2)] = inst_44295);

(statearr_44355_44433[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (40))){
var inst_44297 = (state_44335[(15)]);
var state_44335__$1 = state_44335;
var statearr_44356_44434 = state_44335__$1;
(statearr_44356_44434[(2)] = inst_44297);

(statearr_44356_44434[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (33))){
var inst_44218 = (state_44335[(14)]);
var state_44335__$1 = state_44335;
var statearr_44357_44435 = state_44335__$1;
(statearr_44357_44435[(2)] = inst_44218);

(statearr_44357_44435[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (13))){
var inst_44215 = (state_44335[(16)]);
var inst_44244 = (state_44335[(2)]);
var inst_44245 = fluree.db.util.async.throw_err.call(null,inst_44244);
var inst_44246 = fluree.db.time_travel.as_of_block.call(null,inst_44245,inst_44215);
var state_44335__$1 = state_44335;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44335__$1,(12),inst_44246);
} else {
if((state_val_44336 === (22))){
var state_44335__$1 = state_44335;
var statearr_44358_44436 = state_44335__$1;
(statearr_44358_44436[(2)] = null);

(statearr_44358_44436[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (36))){
var inst_44222 = (state_44335[(17)]);
var state_44335__$1 = state_44335;
var statearr_44359_44437 = state_44335__$1;
(statearr_44359_44437[(2)] = inst_44222);

(statearr_44359_44437[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (41))){
var inst_44305 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
if(cljs.core.truth_(inst_44305)){
var statearr_44360_44438 = state_44335__$1;
(statearr_44360_44438[(1)] = (45));

} else {
var statearr_44361_44439 = state_44335__$1;
(statearr_44361_44439[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (43))){
var inst_44216 = (state_44335[(18)]);
var state_44335__$1 = state_44335;
var statearr_44362_44440 = state_44335__$1;
(statearr_44362_44440[(2)] = inst_44216);

(statearr_44362_44440[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (29))){
var inst_44297 = (state_44335[(15)]);
var inst_44297__$1 = (state_44335[(2)]);
var state_44335__$1 = (function (){var statearr_44363 = state_44335;
(statearr_44363[(15)] = inst_44297__$1);

return statearr_44363;
})();
if(cljs.core.truth_(inst_44297__$1)){
var statearr_44364_44441 = state_44335__$1;
(statearr_44364_44441[(1)] = (39));

} else {
var statearr_44365_44442 = state_44335__$1;
(statearr_44365_44442[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (44))){
var inst_44302 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
var statearr_44366_44443 = state_44335__$1;
(statearr_44366_44443[(2)] = inst_44302);

(statearr_44366_44443[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (6))){
var state_44335__$1 = state_44335;
var statearr_44367_44444 = state_44335__$1;
(statearr_44367_44444[(2)] = null);

(statearr_44367_44444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (28))){
var inst_44219 = (state_44335[(19)]);
var state_44335__$1 = state_44335;
if(cljs.core.truth_(inst_44219)){
var statearr_44368_44445 = state_44335__$1;
(statearr_44368_44445[(1)] = (30));

} else {
var statearr_44369_44446 = state_44335__$1;
(statearr_44369_44446[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (51))){
var inst_44330 = (state_44335[(2)]);
var _ = (function (){var statearr_44370 = state_44335;
(statearr_44370[(4)] = cljs.core.rest.call(null,(state_44335[(4)])));

return statearr_44370;
})();
var state_44335__$1 = state_44335;
var statearr_44371_44447 = state_44335__$1;
(statearr_44371_44447[(2)] = inst_44330);

(statearr_44371_44447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (25))){
var state_44335__$1 = state_44335;
var statearr_44372_44448 = state_44335__$1;
(statearr_44372_44448[(2)] = (1000000));

(statearr_44372_44448[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (34))){
var inst_44222 = (state_44335[(17)]);
var state_44335__$1 = state_44335;
if(cljs.core.truth_(inst_44222)){
var statearr_44373_44449 = state_44335__$1;
(statearr_44373_44449[(1)] = (36));

} else {
var statearr_44374_44450 = state_44335__$1;
(statearr_44374_44450[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (17))){
var inst_44221 = (state_44335[(20)]);
var inst_44266 = (state_44335[(21)]);
var inst_44264 = (state_44335[(2)]);
var inst_44265 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_44221);
var inst_44266__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_44221);
var state_44335__$1 = (function (){var statearr_44375 = state_44335;
(statearr_44375[(12)] = inst_44265);

(statearr_44375[(22)] = inst_44264);

(statearr_44375[(21)] = inst_44266__$1);

return statearr_44375;
})();
if(cljs.core.truth_(inst_44266__$1)){
var statearr_44376_44451 = state_44335__$1;
(statearr_44376_44451[(1)] = (18));

} else {
var statearr_44377_44452 = state_44335__$1;
(statearr_44377_44452[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (3))){
var inst_44333 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44335__$1,inst_44333);
} else {
if((state_val_44336 === (12))){
var inst_44248 = (state_44335[(2)]);
var inst_44249 = fluree.db.util.async.throw_err.call(null,inst_44248);
var state_44335__$1 = state_44335;
var statearr_44378_44453 = state_44335__$1;
(statearr_44378_44453[(2)] = inst_44249);

(statearr_44378_44453[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (2))){
var inst_44220 = (state_44335[(9)]);
var inst_44214 = (state_44335[(7)]);
var inst_44218 = (state_44335[(14)]);
var inst_44213 = (state_44335[(23)]);
var inst_44221 = (state_44335[(20)]);
var inst_44217 = (state_44335[(11)]);
var inst_44222 = (state_44335[(17)]);
var inst_44219 = (state_44335[(19)]);
var inst_44216 = (state_44335[(18)]);
var inst_44215 = (state_44335[(16)]);
var _ = (function (){var statearr_44379 = state_44335;
(statearr_44379[(4)] = cljs.core.cons.call(null,(5),(state_44335[(4)])));

return statearr_44379;
})();
var inst_44211 = flureeQL;
var inst_44212 = cljs.core.__destructure_map.call(null,inst_44211);
var inst_44213__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_44214__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_44215__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"block","block",664686210));
var inst_44216__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_44217__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_44218__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_44219__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_44220__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_44221__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_44222__$1 = cljs.core.get.call(null,inst_44212,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_44223 = (function (){var construct = inst_44213__$1;
var select = inst_44214__$1;
var block = inst_44215__$1;
var where = inst_44216__$1;
var prefixes = inst_44217__$1;
var map__44210 = inst_44212;
var selectDistinct = inst_44218__$1;
var selectOne = inst_44219__$1;
var from = inst_44220__$1;
var opts = inst_44221__$1;
var selectReduced = inst_44222__$1;
return (function (p1__44203_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__44203_SHARP_);
});
})();
var inst_44224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44225 = [inst_44214__$1,inst_44219__$1,inst_44218__$1,inst_44222__$1];
var inst_44226 = (new cljs.core.PersistentVector(null,4,(5),inst_44224,inst_44225,null));
var inst_44227 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_44226);
var inst_44228 = cljs.core.count.call(null,inst_44227);
var inst_44229 = inst_44223.call(null,inst_44228);
var state_44335__$1 = (function (){var statearr_44380 = state_44335;
(statearr_44380[(9)] = inst_44220__$1);

(statearr_44380[(7)] = inst_44214__$1);

(statearr_44380[(14)] = inst_44218__$1);

(statearr_44380[(23)] = inst_44213__$1);

(statearr_44380[(20)] = inst_44221__$1);

(statearr_44380[(11)] = inst_44217__$1);

(statearr_44380[(17)] = inst_44222__$1);

(statearr_44380[(19)] = inst_44219__$1);

(statearr_44380[(18)] = inst_44216__$1);

(statearr_44380[(16)] = inst_44215__$1);

return statearr_44380;
})();
if(cljs.core.truth_(inst_44229)){
var statearr_44381_44454 = state_44335__$1;
(statearr_44381_44454[(1)] = (6));

} else {
var statearr_44382_44455 = state_44335__$1;
(statearr_44382_44455[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (23))){
var inst_44276 = (state_44335[(8)]);
var inst_44221 = (state_44335[(20)]);
var inst_44275 = (state_44335[(2)]);
var inst_44276__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_44221);
var state_44335__$1 = (function (){var statearr_44383 = state_44335;
(statearr_44383[(8)] = inst_44276__$1);

(statearr_44383[(24)] = inst_44275);

return statearr_44383;
})();
if(cljs.core.truth_(inst_44276__$1)){
var statearr_44384_44456 = state_44335__$1;
(statearr_44384_44456[(1)] = (24));

} else {
var statearr_44385_44457 = state_44335__$1;
(statearr_44385_44457[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (47))){
var inst_44255 = (state_44335[(10)]);
var inst_44281 = (state_44335[(25)]);
var inst_44314 = (state_44335[(2)]);
var inst_44315 = fluree.db.util.core.current_time_millis.call(null);
var inst_44316 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_44281);
var inst_44317 = fluree.db.query.fql.query.call(null,inst_44255,inst_44316);
var state_44335__$1 = (function (){var statearr_44386 = state_44335;
(statearr_44386[(26)] = inst_44315);

(statearr_44386[(27)] = inst_44314);

return statearr_44386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44335__$1,(48),inst_44317);
} else {
if((state_val_44336 === (35))){
var inst_44293 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
var statearr_44387_44458 = state_44335__$1;
(statearr_44387_44458[(2)] = inst_44293);

(statearr_44387_44458[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (19))){
var inst_44265 = (state_44335[(12)]);
var state_44335__$1 = state_44335;
var statearr_44388_44459 = state_44335__$1;
(statearr_44388_44459[(2)] = inst_44265);

(statearr_44388_44459[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (11))){
var inst_44217 = (state_44335[(11)]);
var inst_44255 = (state_44335[(2)]);
var state_44335__$1 = (function (){var statearr_44390 = state_44335;
(statearr_44390[(10)] = inst_44255);

return statearr_44390;
})();
if(cljs.core.truth_(inst_44217)){
var statearr_44391_44460 = state_44335__$1;
(statearr_44391_44460[(1)] = (15));

} else {
var statearr_44392_44461 = state_44335__$1;
(statearr_44392_44461[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (9))){
var inst_44241 = (state_44335[(28)]);
var state_44335__$1 = state_44335;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44335__$1,(13),inst_44241);
} else {
if((state_val_44336 === (5))){
var _ = (function (){var statearr_44393 = state_44335;
(statearr_44393[(4)] = cljs.core.rest.call(null,(state_44335[(4)])));

return statearr_44393;
})();
var state_44335__$1 = state_44335;
var ex44389 = (state_44335__$1[(2)]);
var statearr_44394_44462 = state_44335__$1;
(statearr_44394_44462[(5)] = ex44389);


if((ex44389 instanceof Error)){
var statearr_44395_44463 = state_44335__$1;
(statearr_44395_44463[(1)] = (4));

(statearr_44395_44463[(5)] = null);

} else {
throw ex44389;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (14))){
var inst_44252 = (state_44335[(2)]);
var inst_44253 = fluree.db.util.async.throw_err.call(null,inst_44252);
var state_44335__$1 = state_44335;
var statearr_44396_44464 = state_44335__$1;
(statearr_44396_44464[(2)] = inst_44253);

(statearr_44396_44464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (45))){
var state_44335__$1 = state_44335;
var statearr_44397_44465 = state_44335__$1;
(statearr_44397_44465[(2)] = null);

(statearr_44397_44465[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (26))){
var inst_44214 = (state_44335[(7)]);
var inst_44264 = (state_44335[(22)]);
var inst_44221 = (state_44335[(20)]);
var inst_44275 = (state_44335[(24)]);
var inst_44280 = (state_44335[(2)]);
var inst_44281 = cljs.core.assoc.call(null,inst_44221,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_44264,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_44280,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_44275);
var state_44335__$1 = (function (){var statearr_44398 = state_44335;
(statearr_44398[(25)] = inst_44281);

return statearr_44398;
})();
if(cljs.core.truth_(inst_44214)){
var statearr_44399_44466 = state_44335__$1;
(statearr_44399_44466[(1)] = (27));

} else {
var statearr_44400_44467 = state_44335__$1;
(statearr_44400_44467[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (16))){
var inst_44262 = cljs.core.PersistentHashMap.EMPTY;
var state_44335__$1 = state_44335;
var statearr_44401_44468 = state_44335__$1;
(statearr_44401_44468[(2)] = inst_44262);

(statearr_44401_44468[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (38))){
var inst_44291 = (state_44335[(2)]);
var state_44335__$1 = state_44335;
var statearr_44402_44469 = state_44335__$1;
(statearr_44402_44469[(2)] = inst_44291);

(statearr_44402_44469[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (30))){
var inst_44219 = (state_44335[(19)]);
var state_44335__$1 = state_44335;
var statearr_44403_44470 = state_44335__$1;
(statearr_44403_44470[(2)] = inst_44219);

(statearr_44403_44470[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (10))){
var inst_44241 = (state_44335[(28)]);
var state_44335__$1 = state_44335;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44335__$1,(14),inst_44241);
} else {
if((state_val_44336 === (18))){
var inst_44266 = (state_44335[(21)]);
var state_44335__$1 = state_44335;
var statearr_44404_44471 = state_44335__$1;
(statearr_44404_44471[(2)] = inst_44266);

(statearr_44404_44471[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (42))){
var inst_44220 = (state_44335[(9)]);
var state_44335__$1 = state_44335;
var statearr_44405_44472 = state_44335__$1;
(statearr_44405_44472[(2)] = inst_44220);

(statearr_44405_44472[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (37))){
var inst_44213 = (state_44335[(23)]);
var state_44335__$1 = state_44335;
var statearr_44406_44473 = state_44335__$1;
(statearr_44406_44473[(2)] = inst_44213);

(statearr_44406_44473[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (8))){
var inst_44215 = (state_44335[(16)]);
var inst_44240 = (state_44335[(2)]);
var inst_44241 = sources;
var state_44335__$1 = (function (){var statearr_44407 = state_44335;
(statearr_44407[(28)] = inst_44241);

(statearr_44407[(29)] = inst_44240);

return statearr_44407;
})();
if(cljs.core.truth_(inst_44215)){
var statearr_44408_44474 = state_44335__$1;
(statearr_44408_44474[(1)] = (9));

} else {
var statearr_44409_44475 = state_44335__$1;
(statearr_44409_44475[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44336 === (49))){
var inst_44255 = (state_44335[(10)]);
var inst_44315 = (state_44335[(26)]);
var inst_44320 = (state_44335[(13)]);
var inst_44275 = (state_44335[(24)]);
var inst_44322 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_44323 = cljs.core.deref.call(null,inst_44275);
var inst_44324 = fluree.db.util.core.response_time_formatted.call(null,inst_44315);
var inst_44325 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_44255);
var inst_44326 = [(200),inst_44320,inst_44323,inst_44324,inst_44325];
var inst_44327 = cljs.core.PersistentHashMap.fromArrays(inst_44322,inst_44326);
var state_44335__$1 = state_44335;
var statearr_44410_44476 = state_44335__$1;
(statearr_44410_44476[(2)] = inst_44327);

(statearr_44410_44476[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2721__auto____0 = (function (){
var statearr_44411 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44411[(0)] = fluree$db$api$query$query_async_$_state_machine__2721__auto__);

(statearr_44411[(1)] = (1));

return statearr_44411;
});
var fluree$db$api$query$query_async_$_state_machine__2721__auto____1 = (function (state_44335){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_44335);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e44412){var ex__2724__auto__ = e44412;
var statearr_44413_44477 = state_44335;
(statearr_44413_44477[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_44335[(4)]))){
var statearr_44414_44478 = state_44335;
(statearr_44414_44478[(1)] = cljs.core.first.call(null,(state_44335[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44479 = state_44335;
state_44335 = G__44479;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2721__auto__ = function(state_44335){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2721__auto____1.call(this,state_44335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2721__auto____0;
fluree$db$api$query$query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2721__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_44415 = f__2744__auto__.call(null);
(statearr_44415[(6)] = c__2743__auto__);

return statearr_44415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_44620){
var state_val_44621 = (state_44620[(1)]);
if((state_val_44621 === (7))){
var inst_44615 = (state_44620[(2)]);
var _ = (function (){var statearr_44622 = state_44620;
(statearr_44622[(4)] = cljs.core.rest.call(null,(state_44620[(4)])));

return statearr_44622;
})();
var state_44620__$1 = state_44620;
var statearr_44623_44699 = state_44620__$1;
(statearr_44623_44699[(2)] = inst_44615);

(statearr_44623_44699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (20))){
var inst_44587 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44624_44700 = state_44620__$1;
(statearr_44624_44700[(2)] = inst_44587);

(statearr_44624_44700[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (27))){
var inst_44567 = (state_44620[(7)]);
var state_44620__$1 = state_44620;
var statearr_44625_44701 = state_44620__$1;
(statearr_44625_44701[(2)] = inst_44567);

(statearr_44625_44701[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (1))){
var state_44620__$1 = state_44620;
var statearr_44626_44702 = state_44620__$1;
(statearr_44626_44702[(2)] = null);

(statearr_44626_44702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (24))){
var inst_44564 = (state_44620[(8)]);
var state_44620__$1 = state_44620;
var statearr_44627_44703 = state_44620__$1;
(statearr_44627_44703[(2)] = inst_44564);

(statearr_44627_44703[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (39))){
var inst_44554 = (state_44620[(9)]);
var inst_44532 = (state_44620[(10)]);
var inst_44521 = (state_44620[(11)]);
var inst_44598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44599 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_44532];
var inst_44600 = (new cljs.core.PersistentVector(null,2,(5),inst_44598,inst_44599,null));
var inst_44601 = cljs.core.assoc_in.call(null,inst_44521,inst_44600,inst_44554);
var state_44620__$1 = state_44620;
var statearr_44628_44704 = state_44620__$1;
(statearr_44628_44704[(2)] = inst_44601);

(statearr_44628_44704[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (4))){
var inst_44480 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44629_44705 = state_44620__$1;
(statearr_44629_44705[(2)] = inst_44480);

(statearr_44629_44705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (15))){
var inst_44554 = (state_44620[(9)]);
var inst_44519 = (state_44620[(12)]);
var inst_44557 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_44554);
var inst_44558 = (inst_44519 == null);
var state_44620__$1 = (function (){var statearr_44630 = state_44620;
(statearr_44630[(13)] = inst_44557);

return statearr_44630;
})();
if(cljs.core.truth_(inst_44558)){
var statearr_44631_44706 = state_44620__$1;
(statearr_44631_44706[(1)] = (18));

} else {
var statearr_44632_44707 = state_44620__$1;
(statearr_44632_44707[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (21))){
var inst_44557 = (state_44620[(13)]);
var state_44620__$1 = state_44620;
var statearr_44633_44708 = state_44620__$1;
(statearr_44633_44708[(2)] = inst_44557);

(statearr_44633_44708[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (31))){
var state_44620__$1 = state_44620;
var statearr_44634_44709 = state_44620__$1;
(statearr_44634_44709[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (32))){
var inst_44583 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44636_44710 = state_44620__$1;
(statearr_44636_44710[(2)] = inst_44583);

(statearr_44636_44710[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (40))){
var inst_44552 = (state_44620[(14)]);
var state_44620__$1 = state_44620;
if(cljs.core.truth_(inst_44552)){
var statearr_44637_44711 = state_44620__$1;
(statearr_44637_44711[(1)] = (42));

} else {
var statearr_44638_44712 = state_44620__$1;
(statearr_44638_44712[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (33))){
var inst_44519 = (state_44620[(12)]);
var inst_44557 = (state_44620[(13)]);
var inst_44578 = ((inst_44557 > inst_44519) ? inst_44557 : inst_44519);
var state_44620__$1 = state_44620;
var statearr_44639_44713 = state_44620__$1;
(statearr_44639_44713[(2)] = inst_44578);

(statearr_44639_44713[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (13))){
var inst_44543 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44640_44714 = state_44620__$1;
(statearr_44640_44714[(2)] = inst_44543);

(statearr_44640_44714[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (22))){
var inst_44564 = (state_44620[(8)]);
var inst_44557 = (state_44620[(13)]);
var inst_44564__$1 = cljs.core._EQ_.call(null,(200),inst_44557);
var state_44620__$1 = (function (){var statearr_44641 = state_44620;
(statearr_44641[(8)] = inst_44564__$1);

return statearr_44641;
})();
if(inst_44564__$1){
var statearr_44642_44715 = state_44620__$1;
(statearr_44642_44715[(1)] = (24));

} else {
var statearr_44643_44716 = state_44620__$1;
(statearr_44643_44716[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (36))){
var inst_44554 = (state_44620[(9)]);
var inst_44520 = (state_44620[(15)]);
var inst_44592 = cljs.core.get.call(null,inst_44554,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_44593 = (inst_44520 + inst_44592);
var state_44620__$1 = state_44620;
var statearr_44644_44717 = state_44620__$1;
(statearr_44644_44717[(2)] = inst_44593);

(statearr_44644_44717[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (41))){
var inst_44596 = (state_44620[(16)]);
var inst_44590 = (state_44620[(17)]);
var inst_44531 = (state_44620[(18)]);
var inst_44610 = (state_44620[(2)]);
var inst_44518 = inst_44531;
var inst_44519 = inst_44590;
var inst_44520 = inst_44596;
var inst_44521 = inst_44610;
var state_44620__$1 = (function (){var statearr_44645 = state_44620;
(statearr_44645[(12)] = inst_44519);

(statearr_44645[(19)] = inst_44518);

(statearr_44645[(15)] = inst_44520);

(statearr_44645[(11)] = inst_44521);

return statearr_44645;
})();
var statearr_44646_44718 = state_44620__$1;
(statearr_44646_44718[(2)] = null);

(statearr_44646_44718[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (43))){
var inst_44554 = (state_44620[(9)]);
var state_44620__$1 = state_44620;
var statearr_44647_44719 = state_44620__$1;
(statearr_44647_44719[(2)] = inst_44554);

(statearr_44647_44719[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (29))){
var inst_44572 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44648_44720 = state_44620__$1;
(statearr_44648_44720[(2)] = inst_44572);

(statearr_44648_44720[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (44))){
var inst_44532 = (state_44620[(10)]);
var inst_44521 = (state_44620[(11)]);
var inst_44607 = (state_44620[(2)]);
var inst_44608 = cljs.core.assoc.call(null,inst_44521,inst_44532,inst_44607);
var state_44620__$1 = state_44620;
var statearr_44649_44721 = state_44620__$1;
(statearr_44649_44721[(2)] = inst_44608);

(statearr_44649_44721[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (6))){
var inst_44533 = (state_44620[(20)]);
var inst_44518 = (state_44620[(19)]);
var inst_44529 = cljs.core.seq.call(null,inst_44518);
var inst_44530 = cljs.core.first.call(null,inst_44529);
var inst_44531 = cljs.core.next.call(null,inst_44529);
var inst_44532 = cljs.core.nth.call(null,inst_44530,(0),null);
var inst_44533__$1 = cljs.core.nth.call(null,inst_44530,(1),null);
var inst_44534 = (inst_44533__$1 == null);
var state_44620__$1 = (function (){var statearr_44650 = state_44620;
(statearr_44650[(10)] = inst_44532);

(statearr_44650[(20)] = inst_44533__$1);

(statearr_44650[(18)] = inst_44531);

return statearr_44650;
})();
if(cljs.core.truth_(inst_44534)){
var statearr_44651_44722 = state_44620__$1;
(statearr_44651_44722[(1)] = (8));

} else {
var statearr_44652_44723 = state_44620__$1;
(statearr_44652_44723[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (28))){
var inst_44519 = (state_44620[(12)]);
var inst_44570 = cljs.core._EQ_.call(null,(207),inst_44519);
var state_44620__$1 = state_44620;
var statearr_44653_44724 = state_44620__$1;
(statearr_44653_44724[(2)] = inst_44570);

(statearr_44653_44724[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (25))){
var inst_44567 = (state_44620[(7)]);
var inst_44519 = (state_44620[(12)]);
var inst_44567__$1 = cljs.core._EQ_.call(null,(200),inst_44519);
var state_44620__$1 = (function (){var statearr_44654 = state_44620;
(statearr_44654[(7)] = inst_44567__$1);

return statearr_44654;
})();
if(inst_44567__$1){
var statearr_44655_44725 = state_44620__$1;
(statearr_44655_44725[(1)] = (27));

} else {
var statearr_44656_44726 = state_44620__$1;
(statearr_44656_44726[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (34))){
var state_44620__$1 = state_44620;
var statearr_44657_44727 = state_44620__$1;
(statearr_44657_44727[(2)] = null);

(statearr_44657_44727[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (17))){
var inst_44551 = (state_44620[(21)]);
var inst_44590 = (state_44620[(2)]);
var state_44620__$1 = (function (){var statearr_44658 = state_44620;
(statearr_44658[(17)] = inst_44590);

return statearr_44658;
})();
if(cljs.core.truth_(inst_44551)){
var statearr_44659_44728 = state_44620__$1;
(statearr_44659_44728[(1)] = (36));

} else {
var statearr_44660_44729 = state_44620__$1;
(statearr_44660_44729[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (3))){
var inst_44618 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44620__$1,inst_44618);
} else {
if((state_val_44621 === (12))){
var inst_44521 = (state_44620[(11)]);
var state_44620__$1 = state_44620;
var statearr_44661_44730 = state_44620__$1;
(statearr_44661_44730[(2)] = inst_44521);

(statearr_44661_44730[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (2))){
var inst_44494 = (state_44620[(22)]);
var inst_44495 = (state_44620[(23)]);
var inst_44490 = (state_44620[(24)]);
var _ = (function (){var statearr_44662 = state_44620;
(statearr_44662[(4)] = cljs.core.cons.call(null,(5),(state_44620[(4)])));

return statearr_44662;
})();
var inst_44486 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_44487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44488 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_44489 = (new cljs.core.PersistentVector(null,2,(5),inst_44487,inst_44488,null));
var inst_44490__$1 = cljs.core.get_in.call(null,flureeQL,inst_44489);
var inst_44491 = (function (){var global_block = inst_44486;
var global_meta_QMARK_ = inst_44490__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_44492 = cljs.core.PersistentHashMap.EMPTY;
var inst_44493 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_44494__$1 = cljs.core.reduce_kv.call(null,inst_44491,inst_44492,inst_44493);
var inst_44495__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_44497 = (function (){var global_block = inst_44486;
var global_meta_QMARK_ = inst_44490__$1;
var queries = inst_44494__$1;
var start_time = inst_44495__$1;
return (function (p__44496){
var vec__44663 = p__44496;
var alias = cljs.core.nth.call(null,vec__44663,(0),null);
var q = cljs.core.nth.call(null,vec__44663,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_44498 = cljs.core.map.call(null,inst_44497,inst_44494__$1);
var inst_44512 = cljs.core.seq.call(null,inst_44498);
var inst_44513 = cljs.core.first.call(null,inst_44512);
var inst_44514 = cljs.core.next.call(null,inst_44512);
var inst_44515 = cljs.core.nth.call(null,inst_44513,(0),null);
var inst_44516 = cljs.core.nth.call(null,inst_44513,(1),null);
var inst_44517 = cljs.core.PersistentHashMap.EMPTY;
var inst_44518 = inst_44498;
var inst_44519 = null;
var inst_44520 = (0);
var inst_44521 = inst_44517;
var state_44620__$1 = (function (){var statearr_44666 = state_44620;
(statearr_44666[(12)] = inst_44519);

(statearr_44666[(25)] = inst_44514);

(statearr_44666[(22)] = inst_44494__$1);

(statearr_44666[(26)] = inst_44516);

(statearr_44666[(19)] = inst_44518);

(statearr_44666[(23)] = inst_44495__$1);

(statearr_44666[(27)] = inst_44515);

(statearr_44666[(15)] = inst_44520);

(statearr_44666[(11)] = inst_44521);

(statearr_44666[(24)] = inst_44490__$1);

return statearr_44666;
})();
var statearr_44667_44731 = state_44620__$1;
(statearr_44667_44731[(2)] = null);

(statearr_44667_44731[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (23))){
var inst_44585 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44668_44732 = state_44620__$1;
(statearr_44668_44732[(2)] = inst_44585);

(statearr_44668_44732[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (35))){
var inst_44581 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44669_44733 = state_44620__$1;
(statearr_44669_44733[(2)] = inst_44581);

(statearr_44669_44733[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (19))){
var inst_44519 = (state_44620[(12)]);
var inst_44557 = (state_44620[(13)]);
var inst_44561 = cljs.core._EQ_.call(null,inst_44519,inst_44557);
var state_44620__$1 = state_44620;
if(inst_44561){
var statearr_44670_44734 = state_44620__$1;
(statearr_44670_44734[(1)] = (21));

} else {
var statearr_44671_44735 = state_44620__$1;
(statearr_44671_44735[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (11))){
var inst_44519 = (state_44620[(12)]);
var inst_44495 = (state_44620[(23)]);
var inst_44520 = (state_44620[(15)]);
var inst_44521 = (state_44620[(11)]);
var inst_44537 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_44538 = fluree.db.util.core.response_time_formatted.call(null,inst_44495);
var inst_44539 = [inst_44521,inst_44520,inst_44519,inst_44538];
var inst_44540 = cljs.core.PersistentHashMap.fromArrays(inst_44537,inst_44539);
var state_44620__$1 = state_44620;
var statearr_44673_44736 = state_44620__$1;
(statearr_44673_44736[(2)] = inst_44540);

(statearr_44673_44736[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (9))){
var inst_44494 = (state_44620[(22)]);
var inst_44532 = (state_44620[(10)]);
var inst_44533 = (state_44620[(20)]);
var inst_44546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44547 = [inst_44532,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_44548 = (new cljs.core.PersistentVector(null,2,(5),inst_44546,inst_44547,null));
var inst_44549 = cljs.core.get_in.call(null,inst_44494,inst_44548);
var inst_44550 = cljs.core.__destructure_map.call(null,inst_44549);
var inst_44551 = cljs.core.get.call(null,inst_44550,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_44552 = cljs.core.get.call(null,inst_44550,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_44620__$1 = (function (){var statearr_44674 = state_44620;
(statearr_44674[(21)] = inst_44551);

(statearr_44674[(14)] = inst_44552);

return statearr_44674;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44620__$1,(14),inst_44533);
} else {
if((state_val_44621 === (5))){
var _ = (function (){var statearr_44675 = state_44620;
(statearr_44675[(4)] = cljs.core.rest.call(null,(state_44620[(4)])));

return statearr_44675;
})();
var state_44620__$1 = state_44620;
var ex44672 = (state_44620__$1[(2)]);
var statearr_44676_44737 = state_44620__$1;
(statearr_44676_44737[(5)] = ex44672);


var statearr_44677_44738 = state_44620__$1;
(statearr_44677_44738[(1)] = (4));

(statearr_44677_44738[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (14))){
var inst_44551 = (state_44620[(21)]);
var inst_44554 = (state_44620[(9)]);
var inst_44554__$1 = (state_44620[(2)]);
var inst_44555 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_44554__$1);
var state_44620__$1 = (function (){var statearr_44678 = state_44620;
(statearr_44678[(9)] = inst_44554__$1);

(statearr_44678[(28)] = inst_44555);

return statearr_44678;
})();
if(cljs.core.truth_(inst_44551)){
var statearr_44679_44739 = state_44620__$1;
(statearr_44679_44739[(1)] = (15));

} else {
var statearr_44680_44740 = state_44620__$1;
(statearr_44680_44740[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (26))){
var inst_44574 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
if(cljs.core.truth_(inst_44574)){
var statearr_44681_44741 = state_44620__$1;
(statearr_44681_44741[(1)] = (30));

} else {
var statearr_44682_44742 = state_44620__$1;
(statearr_44682_44742[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (16))){
var state_44620__$1 = state_44620;
var statearr_44683_44743 = state_44620__$1;
(statearr_44683_44743[(2)] = null);

(statearr_44683_44743[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (38))){
var inst_44555 = (state_44620[(28)]);
var inst_44596 = (state_44620[(2)]);
var state_44620__$1 = (function (){var statearr_44684 = state_44620;
(statearr_44684[(16)] = inst_44596);

return statearr_44684;
})();
if(cljs.core.truth_(inst_44555)){
var statearr_44685_44744 = state_44620__$1;
(statearr_44685_44744[(1)] = (39));

} else {
var statearr_44686_44745 = state_44620__$1;
(statearr_44686_44745[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (30))){
var state_44620__$1 = state_44620;
var statearr_44687_44746 = state_44620__$1;
(statearr_44687_44746[(2)] = (207));

(statearr_44687_44746[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (10))){
var inst_44613 = (state_44620[(2)]);
var state_44620__$1 = state_44620;
var statearr_44688_44747 = state_44620__$1;
(statearr_44688_44747[(2)] = inst_44613);

(statearr_44688_44747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (18))){
var inst_44557 = (state_44620[(13)]);
var state_44620__$1 = state_44620;
var statearr_44689_44748 = state_44620__$1;
(statearr_44689_44748[(2)] = inst_44557);

(statearr_44689_44748[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (42))){
var inst_44554 = (state_44620[(9)]);
var inst_44604 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_44554);
var state_44620__$1 = state_44620;
var statearr_44690_44749 = state_44620__$1;
(statearr_44690_44749[(2)] = inst_44604);

(statearr_44690_44749[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (37))){
var state_44620__$1 = state_44620;
var statearr_44691_44750 = state_44620__$1;
(statearr_44691_44750[(2)] = null);

(statearr_44691_44750[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44621 === (8))){
var inst_44490 = (state_44620[(24)]);
var state_44620__$1 = state_44620;
if(cljs.core.truth_(inst_44490)){
var statearr_44692_44751 = state_44620__$1;
(statearr_44692_44751[(1)] = (11));

} else {
var statearr_44693_44752 = state_44620__$1;
(statearr_44693_44752[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2721__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2721__auto____0 = (function (){
var statearr_44694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44694[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2721__auto__);

(statearr_44694[(1)] = (1));

return statearr_44694;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2721__auto____1 = (function (state_44620){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_44620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e44695){var ex__2724__auto__ = e44695;
var statearr_44696_44753 = state_44620;
(statearr_44696_44753[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_44620[(4)]))){
var statearr_44697_44754 = state_44620;
(statearr_44697_44754[(1)] = cljs.core.first.call(null,(state_44620[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44755 = state_44620;
state_44620 = G__44755;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2721__auto__ = function(state_44620){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2721__auto____1.call(this,state_44620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2721__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2721__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_44698 = f__2744__auto__.call(null);
(statearr_44698[(6)] = c__2743__auto__);

return statearr_44698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__44756 = query_type;
var G__44756__$1 = (((G__44756 instanceof cljs.core.Keyword))?G__44756.fqn:null);
switch (G__44756__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44756__$1)].join('')));

}
});
