// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___46376 = arguments.length;
var i__5770__auto___46377 = (0);
while(true){
if((i__5770__auto___46377 < len__5769__auto___46376)){
args__5775__auto__.push((arguments[i__5770__auto___46377]));

var G__46378 = (i__5770__auto___46377 + (1));
i__5770__auto___46377 = G__46378;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__46308){
var vec__46309 = p__46308;
var opts = cljs.core.nth.call(null,vec__46309,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2743__auto___46379 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46353){
var state_val_46354 = (state_46353[(1)]);
if((state_val_46354 === (7))){
var inst_46339 = (state_46353[(7)]);
var inst_46330 = (state_46353[(8)]);
var inst_46341 = fluree.db.time_travel.as_of_block.call(null,inst_46339,inst_46330);
var state_46353__$1 = state_46353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46353__$1,(10),inst_46341);
} else {
if((state_val_46354 === (1))){
var state_46353__$1 = state_46353;
var statearr_46355_46380 = state_46353__$1;
(statearr_46355_46380[(2)] = null);

(statearr_46355_46380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46354 === (4))){
var inst_46312 = (state_46353[(2)]);
var inst_46313 = fluree.db.util.log.error.call(null,inst_46312);
var inst_46314 = cljs.core.async.put_BANG_.call(null,pc,inst_46312);
var inst_46315 = cljs.core.async.close_BANG_.call(null,pc);
var state_46353__$1 = (function (){var statearr_46356 = state_46353;
(statearr_46356[(9)] = inst_46314);

(statearr_46356[(10)] = inst_46313);

return statearr_46356;
})();
var statearr_46357_46381 = state_46353__$1;
(statearr_46357_46381[(2)] = inst_46315);

(statearr_46357_46381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46354 === (6))){
var inst_46330 = (state_46353[(8)]);
var inst_46334 = (state_46353[(11)]);
var inst_46333 = (state_46353[(12)]);
var inst_46337 = (state_46353[(2)]);
var inst_46338 = fluree.db.util.async.throw_err.call(null,inst_46337);
var inst_46339 = cljs.core.assoc.call(null,inst_46338,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_46333,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_46334);
var state_46353__$1 = (function (){var statearr_46358 = state_46353;
(statearr_46358[(7)] = inst_46339);

return statearr_46358;
})();
if(cljs.core.truth_(inst_46330)){
var statearr_46359_46382 = state_46353__$1;
(statearr_46359_46382[(1)] = (7));

} else {
var statearr_46360_46383 = state_46353__$1;
(statearr_46360_46383[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46354 === (3))){
var inst_46351 = (state_46353[(2)]);
var state_46353__$1 = state_46353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46353__$1,inst_46351);
} else {
if((state_val_46354 === (2))){
var _ = (function (){var statearr_46362 = state_46353;
(statearr_46362[(4)] = cljs.core.cons.call(null,(5),(state_46353[(4)])));

return statearr_46362;
})();
var inst_46325 = opts;
var inst_46326 = cljs.core.__destructure_map.call(null,inst_46325);
var inst_46327 = cljs.core.get.call(null,inst_46326,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_46328 = cljs.core.get.call(null,inst_46326,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_46329 = cljs.core.get.call(null,inst_46326,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_46330 = cljs.core.get.call(null,inst_46326,new cljs.core.Keyword(null,"block","block",664686210));
var inst_46331 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_46332 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_46333 = cljs.core.nth.call(null,inst_46332,(0),null);
var inst_46334 = cljs.core.nth.call(null,inst_46332,(1),null);
var inst_46335 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_46353__$1 = (function (){var statearr_46363 = state_46353;
(statearr_46363[(13)] = inst_46328);

(statearr_46363[(14)] = inst_46331);

(statearr_46363[(8)] = inst_46330);

(statearr_46363[(11)] = inst_46334);

(statearr_46363[(15)] = inst_46327);

(statearr_46363[(12)] = inst_46333);

(statearr_46363[(16)] = inst_46329);

return statearr_46363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46353__$1,(6),inst_46335);
} else {
if((state_val_46354 === (9))){
var inst_46347 = (state_46353[(2)]);
var inst_46348 = cljs.core.async.put_BANG_.call(null,pc,inst_46347);
var _ = (function (){var statearr_46364 = state_46353;
(statearr_46364[(4)] = cljs.core.rest.call(null,(state_46353[(4)])));

return statearr_46364;
})();
var state_46353__$1 = state_46353;
var statearr_46365_46384 = state_46353__$1;
(statearr_46365_46384[(2)] = inst_46348);

(statearr_46365_46384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46354 === (5))){
var _ = (function (){var statearr_46366 = state_46353;
(statearr_46366[(4)] = cljs.core.rest.call(null,(state_46353[(4)])));

return statearr_46366;
})();
var state_46353__$1 = state_46353;
var ex46361 = (state_46353__$1[(2)]);
var statearr_46367_46385 = state_46353__$1;
(statearr_46367_46385[(5)] = ex46361);


var statearr_46368_46386 = state_46353__$1;
(statearr_46368_46386[(1)] = (4));

(statearr_46368_46386[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46354 === (10))){
var inst_46343 = (state_46353[(2)]);
var inst_46344 = fluree.db.util.async.throw_err.call(null,inst_46343);
var state_46353__$1 = state_46353;
var statearr_46369_46387 = state_46353__$1;
(statearr_46369_46387[(2)] = inst_46344);

(statearr_46369_46387[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46354 === (8))){
var inst_46339 = (state_46353[(7)]);
var state_46353__$1 = state_46353;
var statearr_46370_46388 = state_46353__$1;
(statearr_46370_46388[(2)] = inst_46339);

(statearr_46370_46388[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_46371 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46371[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_46371[(1)] = (1));

return statearr_46371;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_46353){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46372){var ex__2724__auto__ = e46372;
var statearr_46373_46389 = state_46353;
(statearr_46373_46389[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46353[(4)]))){
var statearr_46374_46390 = state_46353;
(statearr_46374_46390[(1)] = cljs.core.first.call(null,(state_46353[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46391 = state_46353;
state_46353 = G__46391;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_46353){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_46353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46375 = f__2744__auto__.call(null);
(statearr_46375[(6)] = c__2743__auto___46379);

return statearr_46375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq46305){
var G__46306 = cljs.core.first.call(null,seq46305);
var seq46305__$1 = cljs.core.next.call(null,seq46305);
var G__46307 = cljs.core.first.call(null,seq46305__$1);
var seq46305__$2 = cljs.core.next.call(null,seq46305__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46306,G__46307,seq46305__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__46393 = arguments.length;
switch (G__46393) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46519){
var state_val_46520 = (state_46519[(1)]);
if((state_val_46520 === (7))){
var inst_46409 = (state_46519[(7)]);
var inst_46419 = (state_46519[(8)]);
var inst_46421 = fluree.db.time_travel.as_of_block.call(null,inst_46419,inst_46409);
var state_46519__$1 = state_46519;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46519__$1,(10),inst_46421);
} else {
if((state_val_46520 === (20))){
var inst_46413 = (state_46519[(9)]);
var state_46519__$1 = state_46519;
var statearr_46521_46601 = state_46519__$1;
(statearr_46521_46601[(2)] = inst_46413);

(statearr_46521_46601[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (27))){
var inst_46407 = (state_46519[(10)]);
var state_46519__$1 = state_46519;
var statearr_46522_46602 = state_46519__$1;
(statearr_46522_46602[(2)] = inst_46407);

(statearr_46522_46602[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (1))){
var state_46519__$1 = state_46519;
var statearr_46523_46603 = state_46519__$1;
(statearr_46523_46603[(2)] = null);

(statearr_46523_46603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (24))){
var inst_46416 = (state_46519[(11)]);
var state_46519__$1 = state_46519;
if(cljs.core.truth_(inst_46416)){
var statearr_46524_46604 = state_46519__$1;
(statearr_46524_46604[(1)] = (26));

} else {
var statearr_46525_46605 = state_46519__$1;
(statearr_46525_46605[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (39))){
var inst_46481 = (state_46519[(12)]);
var inst_46484 = cljs.core.ex_data.call(null,inst_46481);
var inst_46485 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46486 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_46484);
var inst_46487 = cljs.core.ex_message.call(null,inst_46481);
var inst_46488 = [inst_46486,inst_46487,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_46489 = cljs.core.PersistentHashMap.fromArrays(inst_46485,inst_46488);
var state_46519__$1 = state_46519;
var statearr_46526_46606 = state_46519__$1;
(statearr_46526_46606[(2)] = inst_46489);

(statearr_46526_46606[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (46))){
var inst_46481 = (state_46519[(12)]);
var state_46519__$1 = state_46519;
var statearr_46527_46607 = state_46519__$1;
(statearr_46527_46607[(2)] = inst_46481);

(statearr_46527_46607[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (4))){
var inst_46394 = (state_46519[(2)]);
var inst_46395 = fluree.db.util.log.error.call(null,inst_46394);
var inst_46396 = cljs.core.ex_data.call(null,inst_46394);
var inst_46397 = cljs.core.ex_message.call(null,inst_46394);
var inst_46398 = cljs.core.assoc.call(null,inst_46396,new cljs.core.Keyword(null,"message","message",-406056002),inst_46397);
var state_46519__$1 = (function (){var statearr_46528 = state_46519;
(statearr_46528[(13)] = inst_46395);

return statearr_46528;
})();
var statearr_46529_46608 = state_46519__$1;
(statearr_46529_46608[(2)] = inst_46398);

(statearr_46529_46608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (15))){
var state_46519__$1 = state_46519;
var statearr_46530_46609 = state_46519__$1;
(statearr_46530_46609[(2)] = (1000000));

(statearr_46530_46609[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (48))){
var inst_46481 = (state_46519[(12)]);
var state_46519__$1 = state_46519;
var statearr_46531_46610 = state_46519__$1;
(statearr_46531_46610[(2)] = inst_46481);

(statearr_46531_46610[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (50))){
var inst_46508 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
var statearr_46532_46611 = state_46519__$1;
(statearr_46532_46611[(2)] = inst_46508);

(statearr_46532_46611[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (21))){
var inst_46412 = (state_46519[(14)]);
var state_46519__$1 = state_46519;
if(cljs.core.truth_(inst_46412)){
var statearr_46533_46612 = state_46519__$1;
(statearr_46533_46612[(1)] = (23));

} else {
var statearr_46534_46613 = state_46519__$1;
(statearr_46534_46613[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (31))){
var inst_46470 = (state_46519[(2)]);
var inst_46471 = cljs.core.not.call(null,inst_46470);
var state_46519__$1 = state_46519;
if(inst_46471){
var statearr_46535_46614 = state_46519__$1;
(statearr_46535_46614[(1)] = (35));

} else {
var statearr_46536_46615 = state_46519__$1;
(statearr_46536_46615[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (32))){
var inst_46414 = (state_46519[(15)]);
var state_46519__$1 = state_46519;
var statearr_46537_46616 = state_46519__$1;
(statearr_46537_46616[(2)] = inst_46414);

(statearr_46537_46616[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (40))){
var inst_46444 = (state_46519[(16)]);
var state_46519__$1 = state_46519;
if(cljs.core.truth_(inst_46444)){
var statearr_46538_46617 = state_46519__$1;
(statearr_46538_46617[(1)] = (42));

} else {
var statearr_46539_46618 = state_46519__$1;
(statearr_46539_46618[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (33))){
var inst_46410 = (state_46519[(17)]);
var state_46519__$1 = state_46519;
var statearr_46540_46619 = state_46519__$1;
(statearr_46540_46619[(2)] = inst_46410);

(statearr_46540_46619[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (13))){
var inst_46439 = (state_46519[(18)]);
var inst_46415 = (state_46519[(19)]);
var inst_46437 = (state_46519[(2)]);
var inst_46438 = cljs.core.volatile_BANG_.call(null,(0));
var inst_46439__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_46415);
var state_46519__$1 = (function (){var statearr_46541 = state_46519;
(statearr_46541[(20)] = inst_46437);

(statearr_46541[(21)] = inst_46438);

(statearr_46541[(18)] = inst_46439__$1);

return statearr_46541;
})();
if(cljs.core.truth_(inst_46439__$1)){
var statearr_46542_46620 = state_46519__$1;
(statearr_46542_46620[(1)] = (14));

} else {
var statearr_46543_46621 = state_46519__$1;
(statearr_46543_46621[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (22))){
var inst_46460 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
var statearr_46544_46622 = state_46519__$1;
(statearr_46544_46622[(2)] = inst_46460);

(statearr_46544_46622[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (36))){
var inst_46446 = (state_46519[(22)]);
var inst_46427 = (state_46519[(23)]);
var inst_46477 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_46446);
var inst_46478 = fluree.db.query.fql.query.call(null,inst_46427,inst_46477);
var state_46519__$1 = state_46519;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46519__$1,(38),inst_46478);
} else {
if((state_val_46520 === (41))){
var inst_46512 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
var statearr_46545_46623 = state_46519__$1;
(statearr_46545_46623[(2)] = inst_46512);

(statearr_46545_46623[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (43))){
var state_46519__$1 = state_46519;
var statearr_46546_46624 = state_46519__$1;
(statearr_46546_46624[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (29))){
var inst_46414 = (state_46519[(15)]);
var state_46519__$1 = state_46519;
if(cljs.core.truth_(inst_46414)){
var statearr_46548_46625 = state_46519__$1;
(statearr_46548_46625[(1)] = (32));

} else {
var statearr_46549_46626 = state_46519__$1;
(statearr_46549_46626[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (44))){
var inst_46510 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
var statearr_46550_46627 = state_46519__$1;
(statearr_46550_46627[(2)] = inst_46510);

(statearr_46550_46627[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (6))){
var inst_46409 = (state_46519[(7)]);
var inst_46418 = (state_46519[(2)]);
var inst_46419 = fluree.db.util.async.throw_err.call(null,inst_46418);
var state_46519__$1 = (function (){var statearr_46551 = state_46519;
(statearr_46551[(8)] = inst_46419);

return statearr_46551;
})();
if(cljs.core.truth_(inst_46409)){
var statearr_46552_46628 = state_46519__$1;
(statearr_46552_46628[(1)] = (7));

} else {
var statearr_46553_46629 = state_46519__$1;
(statearr_46553_46629[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (28))){
var inst_46456 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
var statearr_46554_46630 = state_46519__$1;
(statearr_46554_46630[(2)] = inst_46456);

(statearr_46554_46630[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (25))){
var inst_46458 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
var statearr_46555_46631 = state_46519__$1;
(statearr_46555_46631[(2)] = inst_46458);

(statearr_46555_46631[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (34))){
var inst_46467 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
var statearr_46556_46632 = state_46519__$1;
(statearr_46556_46632[(2)] = inst_46467);

(statearr_46556_46632[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (17))){
var inst_46408 = (state_46519[(24)]);
var state_46519__$1 = state_46519;
var statearr_46557_46633 = state_46519__$1;
(statearr_46557_46633[(2)] = inst_46408);

(statearr_46557_46633[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (3))){
var inst_46517 = (state_46519[(2)]);
var state_46519__$1 = state_46519;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46519__$1,inst_46517);
} else {
if((state_val_46520 === (12))){
var inst_46435 = cljs.core.PersistentHashMap.EMPTY;
var state_46519__$1 = state_46519;
var statearr_46558_46634 = state_46519__$1;
(statearr_46558_46634[(2)] = inst_46435);

(statearr_46558_46634[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (2))){
var _ = (function (){var statearr_46559 = state_46519;
(statearr_46559[(4)] = cljs.core.cons.call(null,(5),(state_46519[(4)])));

return statearr_46559;
})();
var inst_46405 = query_map;
var inst_46406 = cljs.core.__destructure_map.call(null,inst_46405);
var inst_46407 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_46408 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_46409 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"block","block",664686210));
var inst_46410 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_46411 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_46412 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_46413 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_46414 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_46415 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_46416 = cljs.core.get.call(null,inst_46406,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_46519__$1 = (function (){var statearr_46560 = state_46519;
(statearr_46560[(17)] = inst_46410);

(statearr_46560[(9)] = inst_46413);

(statearr_46560[(10)] = inst_46407);

(statearr_46560[(7)] = inst_46409);

(statearr_46560[(15)] = inst_46414);

(statearr_46560[(24)] = inst_46408);

(statearr_46560[(25)] = inst_46411);

(statearr_46560[(11)] = inst_46416);

(statearr_46560[(14)] = inst_46412);

(statearr_46560[(19)] = inst_46415);

return statearr_46560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46519__$1,(6),sources);
} else {
if((state_val_46520 === (23))){
var inst_46412 = (state_46519[(14)]);
var state_46519__$1 = state_46519;
var statearr_46561_46635 = state_46519__$1;
(statearr_46561_46635[(2)] = inst_46412);

(statearr_46561_46635[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (47))){
var inst_46445 = (state_46519[(26)]);
var inst_46492 = (state_46519[(27)]);
var inst_46438 = (state_46519[(21)]);
var inst_46427 = (state_46519[(23)]);
var inst_46498 = (state_46519[(2)]);
var inst_46499 = cljs.core.deref.call(null,inst_46438);
var inst_46500 = fluree.db.util.core.response_time_formatted.call(null,inst_46445);
var inst_46501 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_46427);
var inst_46502 = [(200),inst_46498,inst_46499,inst_46500,inst_46501];
var inst_46503 = cljs.core.PersistentHashMap.fromArrays(inst_46492,inst_46502);
var state_46519__$1 = state_46519;
var statearr_46562_46636 = state_46519__$1;
(statearr_46562_46636[(2)] = inst_46503);

(statearr_46562_46636[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (35))){
var inst_46473 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46474 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_46475 = cljs.core.PersistentHashMap.fromArrays(inst_46473,inst_46474);
var state_46519__$1 = state_46519;
var statearr_46563_46637 = state_46519__$1;
(statearr_46563_46637[(2)] = inst_46475);

(statearr_46563_46637[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (19))){
var inst_46462 = (state_46519[(28)]);
var inst_46462__$1 = (state_46519[(2)]);
var state_46519__$1 = (function (){var statearr_46564 = state_46519;
(statearr_46564[(28)] = inst_46462__$1);

return statearr_46564;
})();
if(cljs.core.truth_(inst_46462__$1)){
var statearr_46565_46638 = state_46519__$1;
(statearr_46565_46638[(1)] = (29));

} else {
var statearr_46566_46639 = state_46519__$1;
(statearr_46566_46639[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (11))){
var inst_46428 = (state_46519[(29)]);
var inst_46427 = (state_46519[(23)]);
var inst_46411 = (state_46519[(25)]);
var inst_46430 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_46427);
var inst_46431 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_46428);
var inst_46432 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_46427);
var inst_46433 = fluree.db.api_js.get_sources.call(null,inst_46428,inst_46430,inst_46431,inst_46432,inst_46411,db_fn);
var state_46519__$1 = state_46519;
var statearr_46568_46640 = state_46519__$1;
(statearr_46568_46640[(2)] = inst_46433);

(statearr_46568_46640[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (9))){
var inst_46427 = (state_46519[(23)]);
var inst_46411 = (state_46519[(25)]);
var inst_46427__$1 = (state_46519[(2)]);
var inst_46428 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_46427__$1);
var state_46519__$1 = (function (){var statearr_46569 = state_46519;
(statearr_46569[(29)] = inst_46428);

(statearr_46569[(23)] = inst_46427__$1);

return statearr_46569;
})();
if(cljs.core.truth_(inst_46411)){
var statearr_46570_46641 = state_46519__$1;
(statearr_46570_46641[(1)] = (11));

} else {
var statearr_46571_46642 = state_46519__$1;
(statearr_46571_46642[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (5))){
var _ = (function (){var statearr_46572 = state_46519;
(statearr_46572[(4)] = cljs.core.rest.call(null,(state_46519[(4)])));

return statearr_46572;
})();
var state_46519__$1 = state_46519;
var ex46567 = (state_46519__$1[(2)]);
var statearr_46573_46643 = state_46519__$1;
(statearr_46573_46643[(5)] = ex46567);


var statearr_46574_46644 = state_46519__$1;
(statearr_46574_46644[(1)] = (4));

(statearr_46574_46644[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (14))){
var inst_46439 = (state_46519[(18)]);
var state_46519__$1 = state_46519;
var statearr_46575_46645 = state_46519__$1;
(statearr_46575_46645[(2)] = inst_46439);

(statearr_46575_46645[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (45))){
var inst_46481 = (state_46519[(12)]);
var inst_46495 = cljs.core.doall.call(null,inst_46481);
var state_46519__$1 = state_46519;
var statearr_46576_46646 = state_46519__$1;
(statearr_46576_46646[(2)] = inst_46495);

(statearr_46576_46646[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (26))){
var inst_46416 = (state_46519[(11)]);
var state_46519__$1 = state_46519;
var statearr_46577_46647 = state_46519__$1;
(statearr_46577_46647[(2)] = inst_46416);

(statearr_46577_46647[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (16))){
var inst_46437 = (state_46519[(20)]);
var inst_46438 = (state_46519[(21)]);
var inst_46408 = (state_46519[(24)]);
var inst_46415 = (state_46519[(19)]);
var inst_46443 = (state_46519[(2)]);
var inst_46444 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_46415);
var inst_46445 = fluree.db.util.core.current_time_millis.call(null);
var inst_46446 = cljs.core.assoc.call(null,inst_46415,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_46437,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_46443,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_46438);
var state_46519__$1 = (function (){var statearr_46578 = state_46519;
(statearr_46578[(26)] = inst_46445);

(statearr_46578[(16)] = inst_46444);

(statearr_46578[(22)] = inst_46446);

return statearr_46578;
})();
if(cljs.core.truth_(inst_46408)){
var statearr_46579_46648 = state_46519__$1;
(statearr_46579_46648[(1)] = (17));

} else {
var statearr_46580_46649 = state_46519__$1;
(statearr_46580_46649[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (38))){
var inst_46481 = (state_46519[(12)]);
var inst_46480 = (state_46519[(2)]);
var inst_46481__$1 = fluree.db.util.async.throw_err.call(null,inst_46480);
var inst_46482 = (inst_46481__$1 instanceof cljs.core.ExceptionInfo);
var state_46519__$1 = (function (){var statearr_46581 = state_46519;
(statearr_46581[(12)] = inst_46481__$1);

return statearr_46581;
})();
if(cljs.core.truth_(inst_46482)){
var statearr_46582_46650 = state_46519__$1;
(statearr_46582_46650[(1)] = (39));

} else {
var statearr_46583_46651 = state_46519__$1;
(statearr_46583_46651[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (30))){
var inst_46462 = (state_46519[(28)]);
var state_46519__$1 = state_46519;
var statearr_46584_46652 = state_46519__$1;
(statearr_46584_46652[(2)] = inst_46462);

(statearr_46584_46652[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (10))){
var inst_46423 = (state_46519[(2)]);
var inst_46424 = fluree.db.util.async.throw_err.call(null,inst_46423);
var state_46519__$1 = state_46519;
var statearr_46585_46653 = state_46519__$1;
(statearr_46585_46653[(2)] = inst_46424);

(statearr_46585_46653[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (18))){
var inst_46413 = (state_46519[(9)]);
var state_46519__$1 = state_46519;
if(cljs.core.truth_(inst_46413)){
var statearr_46586_46654 = state_46519__$1;
(statearr_46586_46654[(1)] = (20));

} else {
var statearr_46587_46655 = state_46519__$1;
(statearr_46587_46655[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (42))){
var inst_46481 = (state_46519[(12)]);
var inst_46492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_46493 = cljs.core.sequential_QMARK_.call(null,inst_46481);
var state_46519__$1 = (function (){var statearr_46588 = state_46519;
(statearr_46588[(27)] = inst_46492);

return statearr_46588;
})();
if(inst_46493){
var statearr_46589_46656 = state_46519__$1;
(statearr_46589_46656[(1)] = (45));

} else {
var statearr_46590_46657 = state_46519__$1;
(statearr_46590_46657[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (37))){
var inst_46514 = (state_46519[(2)]);
var _ = (function (){var statearr_46591 = state_46519;
(statearr_46591[(4)] = cljs.core.rest.call(null,(state_46519[(4)])));

return statearr_46591;
})();
var state_46519__$1 = state_46519;
var statearr_46592_46658 = state_46519__$1;
(statearr_46592_46658[(2)] = inst_46514);

(statearr_46592_46658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (8))){
var inst_46419 = (state_46519[(8)]);
var state_46519__$1 = state_46519;
var statearr_46593_46659 = state_46519__$1;
(statearr_46593_46659[(2)] = inst_46419);

(statearr_46593_46659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46520 === (49))){
var state_46519__$1 = state_46519;
var statearr_46594_46660 = state_46519__$1;
(statearr_46594_46660[(2)] = null);

(statearr_46594_46660[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_46595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46595[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_46595[(1)] = (1));

return statearr_46595;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_46519){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46519);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46596){var ex__2724__auto__ = e46596;
var statearr_46597_46661 = state_46519;
(statearr_46597_46661[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46519[(4)]))){
var statearr_46598_46662 = state_46519;
(statearr_46598_46662[(1)] = cljs.core.first.call(null,(state_46519[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46663 = state_46519;
state_46519 = G__46663;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_46519){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_46519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46599 = f__2744__auto__.call(null);
(statearr_46599[(6)] = c__2743__auto__);

return statearr_46599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__46664_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__46664_SHARP_);
}));

var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46686){
var state_val_46687 = (state_46686[(1)]);
if((state_val_46687 === (1))){
var inst_46668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46669 = [resp_chan,timeout_chan];
var inst_46670 = (new cljs.core.PersistentVector(null,2,(5),inst_46668,inst_46669,null));
var state_46686__$1 = state_46686;
return cljs.core.async.ioc_alts_BANG_.call(null,state_46686__$1,(2),inst_46670);
} else {
if((state_val_46687 === (2))){
var inst_46672 = (state_46686[(2)]);
var inst_46673 = cljs.core.nth.call(null,inst_46672,(0),null);
var inst_46674 = cljs.core.nth.call(null,inst_46672,(1),null);
var inst_46675 = cljs.core._EQ_.call(null,timeout_chan,inst_46674);
var state_46686__$1 = (function (){var statearr_46688 = state_46686;
(statearr_46688[(7)] = inst_46673);

return statearr_46688;
})();
if(inst_46675){
var statearr_46689_46699 = state_46686__$1;
(statearr_46689_46699[(1)] = (3));

} else {
var statearr_46690_46700 = state_46686__$1;
(statearr_46690_46700[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46687 === (3))){
var inst_46677 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_46678 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_46679 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_46680 = [tid,(408),inst_46679];
var inst_46681 = cljs.core.PersistentHashMap.fromArrays(inst_46678,inst_46680);
var state_46686__$1 = (function (){var statearr_46691 = state_46686;
(statearr_46691[(8)] = inst_46677);

return statearr_46691;
})();
var statearr_46692_46701 = state_46686__$1;
(statearr_46692_46701[(2)] = inst_46681);

(statearr_46692_46701[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46687 === (4))){
var inst_46673 = (state_46686[(7)]);
var state_46686__$1 = state_46686;
var statearr_46693_46702 = state_46686__$1;
(statearr_46693_46702[(2)] = inst_46673);

(statearr_46693_46702[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46687 === (5))){
var inst_46684 = (state_46686[(2)]);
var state_46686__$1 = state_46686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46686__$1,inst_46684);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2721__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2721__auto____0 = (function (){
var statearr_46694 = [null,null,null,null,null,null,null,null,null];
(statearr_46694[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2721__auto__);

(statearr_46694[(1)] = (1));

return statearr_46694;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2721__auto____1 = (function (state_46686){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46695){var ex__2724__auto__ = e46695;
var statearr_46696_46703 = state_46686;
(statearr_46696_46703[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46686[(4)]))){
var statearr_46697_46704 = state_46686;
(statearr_46697_46704[(1)] = cljs.core.first.call(null,(state_46686[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46705 = state_46686;
state_46686 = G__46705;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2721__auto__ = function(state_46686){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2721__auto____1.call(this,state_46686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2721__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2721__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46698 = f__2744__auto__.call(null);
(statearr_46698[(6)] = c__2743__auto__);

return statearr_46698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__46707 = arguments.length;
switch (G__46707) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__46708 = opts;
var map__46708__$1 = cljs.core.__destructure_map.call(null,map__46708);
var auth = cljs.core.get.call(null,map__46708__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__46708__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__46708__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__46708__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__46709 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__46709,(0),null);
var authority = cljs.core.nth.call(null,vec__46709,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e46712){var e = e46712;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__46715 = arguments.length;
switch (G__46715) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46781){
var state_val_46782 = (state_46781[(1)]);
if((state_val_46782 === (7))){
var inst_46732 = (state_46781[(7)]);
var inst_46737 = (state_46781[(8)]);
var inst_46735 = (state_46781[(9)]);
var inst_46736 = (state_46781[(10)]);
var inst_46734 = (state_46781[(11)]);
var inst_46750 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_46751 = [ledger,txn,inst_46732,inst_46734,inst_46735,inst_46736,inst_46737];
var inst_46752 = cljs.core.PersistentHashMap.fromArrays(inst_46750,inst_46751);
var inst_46753 = fluree.db.util.core.without_nils.call(null,inst_46752);
var inst_46754 = fluree.db.operations.transact_async.call(null,conn,inst_46753);
var state_46781__$1 = state_46781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46781__$1,(13),inst_46754);
} else {
if((state_val_46782 === (20))){
var inst_46772 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
var statearr_46783_46819 = state_46781__$1;
(statearr_46783_46819[(2)] = inst_46772);

(statearr_46783_46819[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (1))){
var state_46781__$1 = state_46781;
var statearr_46784_46820 = state_46781__$1;
(statearr_46784_46820[(2)] = null);

(statearr_46784_46820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (4))){
var inst_46716 = (state_46781[(2)]);
var inst_46717 = fluree.db.util.log.error.call(null,inst_46716);
var inst_46718 = cljs.core.ex_data.call(null,inst_46716);
var inst_46719 = cljs.core.ex_message.call(null,inst_46716);
var inst_46720 = cljs.core.assoc.call(null,inst_46718,new cljs.core.Keyword(null,"message","message",-406056002),inst_46719);
var state_46781__$1 = (function (){var statearr_46785 = state_46781;
(statearr_46785[(12)] = inst_46717);

return statearr_46785;
})();
var statearr_46786_46821 = state_46781__$1;
(statearr_46786_46821[(2)] = inst_46720);

(statearr_46786_46821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (15))){
var inst_46731 = (state_46781[(13)]);
var inst_46756 = (state_46781[(14)]);
var inst_46759 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_46756,inst_46731);
var state_46781__$1 = state_46781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46781__$1,(17),inst_46759);
} else {
if((state_val_46782 === (13))){
var inst_46730 = (state_46781[(15)]);
var inst_46756 = (state_46781[(2)]);
var state_46781__$1 = (function (){var statearr_46787 = state_46781;
(statearr_46787[(14)] = inst_46756);

return statearr_46787;
})();
if(cljs.core.truth_(inst_46730)){
var statearr_46788_46822 = state_46781__$1;
(statearr_46788_46822[(1)] = (14));

} else {
var statearr_46789_46823 = state_46781__$1;
(statearr_46789_46823[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (6))){
var inst_46730 = (state_46781[(15)]);
var inst_46729 = (state_46781[(16)]);
var inst_46739 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_46729,opts);
var inst_46740 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_46739);
var inst_46741 = fluree.db.operations.command_async.call(null,conn,inst_46739);
var state_46781__$1 = (function (){var statearr_46790 = state_46781;
(statearr_46790[(17)] = inst_46740);

(statearr_46790[(18)] = inst_46741);

return statearr_46790;
})();
if(cljs.core.truth_(inst_46730)){
var statearr_46791_46824 = state_46781__$1;
(statearr_46791_46824[(1)] = (9));

} else {
var statearr_46792_46825 = state_46781__$1;
(statearr_46792_46825[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (17))){
var inst_46761 = (state_46781[(19)]);
var inst_46761__$1 = (state_46781[(2)]);
var inst_46762 = (inst_46761__$1 instanceof cljs.core.ExceptionInfo);
var state_46781__$1 = (function (){var statearr_46793 = state_46781;
(statearr_46793[(19)] = inst_46761__$1);

return statearr_46793;
})();
if(cljs.core.truth_(inst_46762)){
var statearr_46794_46826 = state_46781__$1;
(statearr_46794_46826[(1)] = (18));

} else {
var statearr_46795_46827 = state_46781__$1;
(statearr_46795_46827[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (3))){
var inst_46779 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46781__$1,inst_46779);
} else {
if((state_val_46782 === (12))){
var inst_46746 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
var statearr_46796_46828 = state_46781__$1;
(statearr_46796_46828[(2)] = inst_46746);

(statearr_46796_46828[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (2))){
var inst_46729 = (state_46781[(16)]);
var _ = (function (){var statearr_46797 = state_46781;
(statearr_46797[(4)] = cljs.core.cons.call(null,(5),(state_46781[(4)])));

return statearr_46797;
})();
var inst_46727 = opts;
var inst_46728 = cljs.core.__destructure_map.call(null,inst_46727);
var inst_46729__$1 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_46730 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_46731 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_46732 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_46733 = fluree.db.util.core.current_time_millis.call(null);
var inst_46734 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_46733);
var inst_46735 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_46736 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_46737 = cljs.core.get.call(null,inst_46728,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_46781__$1 = (function (){var statearr_46798 = state_46781;
(statearr_46798[(7)] = inst_46732);

(statearr_46798[(8)] = inst_46737);

(statearr_46798[(13)] = inst_46731);

(statearr_46798[(9)] = inst_46735);

(statearr_46798[(10)] = inst_46736);

(statearr_46798[(11)] = inst_46734);

(statearr_46798[(15)] = inst_46730);

(statearr_46798[(16)] = inst_46729__$1);

return statearr_46798;
})();
if(cljs.core.truth_(inst_46729__$1)){
var statearr_46799_46829 = state_46781__$1;
(statearr_46799_46829[(1)] = (6));

} else {
var statearr_46800_46830 = state_46781__$1;
(statearr_46800_46830[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (19))){
var inst_46761 = (state_46781[(19)]);
var state_46781__$1 = state_46781;
var statearr_46801_46831 = state_46781__$1;
(statearr_46801_46831[(2)] = inst_46761);

(statearr_46801_46831[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (11))){
var inst_46748 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
var statearr_46803_46832 = state_46781__$1;
(statearr_46803_46832[(2)] = inst_46748);

(statearr_46803_46832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (9))){
var inst_46741 = (state_46781[(18)]);
var state_46781__$1 = state_46781;
var statearr_46804_46833 = state_46781__$1;
(statearr_46804_46833[(2)] = inst_46741);

(statearr_46804_46833[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (5))){
var _ = (function (){var statearr_46805 = state_46781;
(statearr_46805[(4)] = cljs.core.rest.call(null,(state_46781[(4)])));

return statearr_46805;
})();
var state_46781__$1 = state_46781;
var ex46802 = (state_46781__$1[(2)]);
var statearr_46806_46834 = state_46781__$1;
(statearr_46806_46834[(5)] = ex46802);


var statearr_46807_46835 = state_46781__$1;
(statearr_46807_46835[(1)] = (4));

(statearr_46807_46835[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (14))){
var inst_46756 = (state_46781[(14)]);
var state_46781__$1 = state_46781;
var statearr_46808_46836 = state_46781__$1;
(statearr_46808_46836[(2)] = inst_46756);

(statearr_46808_46836[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (16))){
var inst_46774 = (state_46781[(2)]);
var state_46781__$1 = state_46781;
var statearr_46809_46837 = state_46781__$1;
(statearr_46809_46837[(2)] = inst_46774);

(statearr_46809_46837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (10))){
var inst_46740 = (state_46781[(17)]);
var inst_46731 = (state_46781[(13)]);
var inst_46744 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_46740,inst_46731);
var state_46781__$1 = state_46781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46781__$1,(12),inst_46744);
} else {
if((state_val_46782 === (18))){
var inst_46761 = (state_46781[(19)]);
var inst_46764 = cljs.core.ex_data.call(null,inst_46761);
var inst_46765 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46766 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_46764);
var inst_46767 = cljs.core.ex_message.call(null,inst_46761);
var inst_46768 = [inst_46766,inst_46767,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_46769 = cljs.core.PersistentHashMap.fromArrays(inst_46765,inst_46768);
var state_46781__$1 = state_46781;
var statearr_46810_46838 = state_46781__$1;
(statearr_46810_46838[(2)] = inst_46769);

(statearr_46810_46838[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46782 === (8))){
var inst_46776 = (state_46781[(2)]);
var _ = (function (){var statearr_46811 = state_46781;
(statearr_46811[(4)] = cljs.core.rest.call(null,(state_46781[(4)])));

return statearr_46811;
})();
var state_46781__$1 = state_46781;
var statearr_46812_46839 = state_46781__$1;
(statearr_46812_46839[(2)] = inst_46776);

(statearr_46812_46839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_46813 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46813[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_46813[(1)] = (1));

return statearr_46813;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_46781){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46814){var ex__2724__auto__ = e46814;
var statearr_46815_46840 = state_46781;
(statearr_46815_46840[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46781[(4)]))){
var statearr_46816_46841 = state_46781;
(statearr_46816_46841[(1)] = cljs.core.first.call(null,(state_46781[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46842 = state_46781;
state_46781 = G__46842;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_46781){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_46781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46817 = f__2744__auto__.call(null);
(statearr_46817[(6)] = c__2743__auto__);

return statearr_46817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___46844 = arguments.length;
var i__5770__auto___46845 = (0);
while(true){
if((i__5770__auto___46845 < len__5769__auto___46844)){
args__5775__auto__.push((arguments[i__5770__auto___46845]));

var G__46846 = (i__5770__auto___46845 + (1));
i__5770__auto___46845 = G__46846;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq46843){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46843));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46877){
var state_val_46878 = (state_46877[(1)]);
if((state_val_46878 === (1))){
var inst_46847 = cljs.core.first.call(null,flakes);
var inst_46848 = cljs.core.rest.call(null,flakes);
var inst_46849 = cljs.core.PersistentVector.EMPTY;
var inst_46850 = inst_46847;
var inst_46851 = inst_46848;
var inst_46852 = inst_46849;
var state_46877__$1 = (function (){var statearr_46879 = state_46877;
(statearr_46879[(7)] = inst_46852);

(statearr_46879[(8)] = inst_46851);

(statearr_46879[(9)] = inst_46850);

return statearr_46879;
})();
var statearr_46880_46893 = state_46877__$1;
(statearr_46880_46893[(2)] = null);

(statearr_46880_46893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46878 === (2))){
var inst_46850 = (state_46877[(9)]);
var inst_46854 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_46855 = cljs.core.PersistentHashMap.EMPTY;
var inst_46856 = [true,inst_46855];
var inst_46857 = cljs.core.PersistentHashMap.fromArrays(inst_46854,inst_46856);
var inst_46858 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_46857,inst_46850);
var state_46877__$1 = state_46877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46877__$1,(4),inst_46858);
} else {
if((state_val_46878 === (3))){
var inst_46875 = (state_46877[(2)]);
var state_46877__$1 = state_46877;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46877__$1,inst_46875);
} else {
if((state_val_46878 === (4))){
var inst_46852 = (state_46877[(7)]);
var inst_46851 = (state_46877[(8)]);
var inst_46860 = (state_46877[(2)]);
var inst_46861 = fluree.db.util.async.throw_err.call(null,inst_46860);
var inst_46862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46863 = [inst_46861];
var inst_46864 = (new cljs.core.PersistentVector(null,1,(5),inst_46862,inst_46863,null));
var inst_46865 = cljs.core.concat.call(null,inst_46852,inst_46864);
var inst_46866 = cljs.core.first.call(null,inst_46851);
var state_46877__$1 = (function (){var statearr_46881 = state_46877;
(statearr_46881[(10)] = inst_46865);

return statearr_46881;
})();
if(cljs.core.truth_(inst_46866)){
var statearr_46882_46894 = state_46877__$1;
(statearr_46882_46894[(1)] = (5));

} else {
var statearr_46883_46895 = state_46877__$1;
(statearr_46883_46895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46878 === (5))){
var inst_46851 = (state_46877[(8)]);
var inst_46865 = (state_46877[(10)]);
var inst_46868 = cljs.core.first.call(null,inst_46851);
var inst_46869 = cljs.core.rest.call(null,inst_46851);
var inst_46850 = inst_46868;
var inst_46851__$1 = inst_46869;
var inst_46852 = inst_46865;
var state_46877__$1 = (function (){var statearr_46884 = state_46877;
(statearr_46884[(7)] = inst_46852);

(statearr_46884[(8)] = inst_46851__$1);

(statearr_46884[(9)] = inst_46850);

return statearr_46884;
})();
var statearr_46885_46896 = state_46877__$1;
(statearr_46885_46896[(2)] = null);

(statearr_46885_46896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46878 === (6))){
var inst_46865 = (state_46877[(10)]);
var state_46877__$1 = state_46877;
var statearr_46886_46897 = state_46877__$1;
(statearr_46886_46897[(2)] = inst_46865);

(statearr_46886_46897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46878 === (7))){
var inst_46873 = (state_46877[(2)]);
var state_46877__$1 = state_46877;
var statearr_46887_46898 = state_46877__$1;
(statearr_46887_46898[(2)] = inst_46873);

(statearr_46887_46898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto____0 = (function (){
var statearr_46888 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46888[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto__);

(statearr_46888[(1)] = (1));

return statearr_46888;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto____1 = (function (state_46877){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46889){var ex__2724__auto__ = e46889;
var statearr_46890_46899 = state_46877;
(statearr_46890_46899[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46877[(4)]))){
var statearr_46891_46900 = state_46877;
(statearr_46891_46900[(1)] = cljs.core.first.call(null,(state_46877[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46901 = state_46877;
state_46877 = G__46901;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto__ = function(state_46877){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto____1.call(this,state_46877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46892 = f__2744__auto__.call(null);
(statearr_46892[(6)] = c__2743__auto__);

return statearr_46892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46969){
var state_val_46970 = (state_46969[(1)]);
if((state_val_46970 === (7))){
var inst_46929 = (state_46969[(2)]);
var inst_46930 = fluree.db.util.async.throw_err.call(null,inst_46929);
var state_46969__$1 = state_46969;
var statearr_46971_46997 = state_46969__$1;
(statearr_46971_46997[(2)] = inst_46930);

(statearr_46971_46997[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (1))){
var inst_46906 = cljs.core.volatile_BANG_.call(null,(0));
var inst_46907 = cljs.core.PersistentHashMap.EMPTY;
var inst_46908 = cljs.core.volatile_BANG_.call(null,inst_46907);
var inst_46909 = cljs.core.first.call(null,resp);
var inst_46910 = cljs.core.rest.call(null,resp);
var inst_46911 = cljs.core.PersistentVector.EMPTY;
var inst_46912 = inst_46906;
var inst_46913 = inst_46908;
var inst_46914 = inst_46909;
var inst_46915 = inst_46910;
var inst_46916 = inst_46911;
var state_46969__$1 = (function (){var statearr_46972 = state_46969;
(statearr_46972[(7)] = inst_46912);

(statearr_46972[(8)] = inst_46914);

(statearr_46972[(9)] = inst_46915);

(statearr_46972[(10)] = inst_46913);

(statearr_46972[(11)] = inst_46916);

return statearr_46972;
})();
var statearr_46973_46998 = state_46969__$1;
(statearr_46973_46998[(2)] = null);

(statearr_46973_46998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (4))){
var inst_46912 = (state_46969[(7)]);
var inst_46920 = (state_46969[(12)]);
var inst_46914 = (state_46969[(8)]);
var inst_46918 = (state_46969[(13)]);
var inst_46915 = (state_46969[(9)]);
var inst_46913 = (state_46969[(10)]);
var inst_46916 = (state_46969[(11)]);
var inst_46924 = (function (){var fuel = inst_46912;
var cache = inst_46913;
var curr_block = inst_46914;
var rest_blocks = inst_46915;
var acc = inst_46916;
var flakes = inst_46918;
var asserted = inst_46920;
return (function (p1__46903_SHARP_){
return p1__46903_SHARP_.s;
});
})();
var inst_46925 = cljs.core.group_by.call(null,inst_46924,inst_46920);
var inst_46926 = cljs.core.vals.call(null,inst_46925);
var inst_46927 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_46913,inst_46912,inst_46926);
var state_46969__$1 = state_46969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46969__$1,(7),inst_46927);
} else {
if((state_val_46970 === (13))){
var inst_46957 = (state_46969[(14)]);
var state_46969__$1 = state_46969;
var statearr_46974_46999 = state_46969__$1;
(statearr_46974_46999[(2)] = inst_46957);

(statearr_46974_46999[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (6))){
var inst_46912 = (state_46969[(7)]);
var inst_46920 = (state_46969[(12)]);
var inst_46914 = (state_46969[(8)]);
var inst_46918 = (state_46969[(13)]);
var inst_46915 = (state_46969[(9)]);
var inst_46935 = (state_46969[(15)]);
var inst_46933 = (state_46969[(16)]);
var inst_46913 = (state_46969[(10)]);
var inst_46916 = (state_46969[(11)]);
var inst_46933__$1 = (state_46969[(2)]);
var inst_46934 = (function (){var fuel = inst_46912;
var cache = inst_46913;
var curr_block = inst_46914;
var rest_blocks = inst_46915;
var acc = inst_46916;
var flakes = inst_46918;
var asserted = inst_46920;
var asserted_SINGLEQUOTE_ = inst_46933__$1;
return (function (p1__46904_SHARP_){
return p1__46904_SHARP_.op === false;
});
})();
var inst_46935__$1 = cljs.core.filter.call(null,inst_46934,inst_46918);
var inst_46936 = cljs.core.empty_QMARK_.call(null,inst_46935__$1);
var inst_46937 = (!(inst_46936));
var state_46969__$1 = (function (){var statearr_46977 = state_46969;
(statearr_46977[(15)] = inst_46935__$1);

(statearr_46977[(16)] = inst_46933__$1);

return statearr_46977;
})();
if(inst_46937){
var statearr_46978_47000 = state_46969__$1;
(statearr_46978_47000[(1)] = (8));

} else {
var statearr_46979_47001 = state_46969__$1;
(statearr_46979_47001[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (3))){
var inst_46967 = (state_46969[(2)]);
var state_46969__$1 = state_46969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46969__$1,inst_46967);
} else {
if((state_val_46970 === (12))){
var inst_46912 = (state_46969[(7)]);
var inst_46915 = (state_46969[(9)]);
var inst_46957 = (state_46969[(14)]);
var inst_46913 = (state_46969[(10)]);
var inst_46960 = cljs.core.first.call(null,inst_46915);
var inst_46961 = cljs.core.rest.call(null,inst_46915);
var tmp46975 = inst_46912;
var tmp46976 = inst_46913;
var inst_46912__$1 = tmp46975;
var inst_46913__$1 = tmp46976;
var inst_46914 = inst_46960;
var inst_46915__$1 = inst_46961;
var inst_46916 = inst_46957;
var state_46969__$1 = (function (){var statearr_46980 = state_46969;
(statearr_46980[(7)] = inst_46912__$1);

(statearr_46980[(8)] = inst_46914);

(statearr_46980[(9)] = inst_46915__$1);

(statearr_46980[(10)] = inst_46913__$1);

(statearr_46980[(11)] = inst_46916);

return statearr_46980;
})();
var statearr_46981_47002 = state_46969__$1;
(statearr_46981_47002[(2)] = null);

(statearr_46981_47002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (2))){
var inst_46912 = (state_46969[(7)]);
var inst_46920 = (state_46969[(12)]);
var inst_46914 = (state_46969[(8)]);
var inst_46918 = (state_46969[(13)]);
var inst_46915 = (state_46969[(9)]);
var inst_46913 = (state_46969[(10)]);
var inst_46916 = (state_46969[(11)]);
var inst_46918__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_46914);
var inst_46919 = (function (){var fuel = inst_46912;
var cache = inst_46913;
var curr_block = inst_46914;
var rest_blocks = inst_46915;
var acc = inst_46916;
var flakes = inst_46918__$1;
return (function (p1__46902_SHARP_){
return p1__46902_SHARP_.op;
});
})();
var inst_46920__$1 = cljs.core.filter.call(null,inst_46919,inst_46918__$1);
var inst_46921 = cljs.core.empty_QMARK_.call(null,inst_46920__$1);
var inst_46922 = (!(inst_46921));
var state_46969__$1 = (function (){var statearr_46982 = state_46969;
(statearr_46982[(12)] = inst_46920__$1);

(statearr_46982[(13)] = inst_46918__$1);

return statearr_46982;
})();
if(inst_46922){
var statearr_46983_47003 = state_46969__$1;
(statearr_46983_47003[(1)] = (4));

} else {
var statearr_46984_47004 = state_46969__$1;
(statearr_46984_47004[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (11))){
var inst_46945 = (state_46969[(2)]);
var inst_46946 = fluree.db.util.async.throw_err.call(null,inst_46945);
var state_46969__$1 = state_46969;
var statearr_46985_47005 = state_46969__$1;
(statearr_46985_47005[(2)] = inst_46946);

(statearr_46985_47005[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (9))){
var state_46969__$1 = state_46969;
var statearr_46986_47006 = state_46969__$1;
(statearr_46986_47006[(2)] = null);

(statearr_46986_47006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (5))){
var state_46969__$1 = state_46969;
var statearr_46987_47007 = state_46969__$1;
(statearr_46987_47007[(2)] = null);

(statearr_46987_47007[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (14))){
var inst_46965 = (state_46969[(2)]);
var state_46969__$1 = state_46969;
var statearr_46988_47008 = state_46969__$1;
(statearr_46988_47008[(2)] = inst_46965);

(statearr_46988_47008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (10))){
var inst_46914 = (state_46969[(8)]);
var inst_46915 = (state_46969[(9)]);
var inst_46933 = (state_46969[(16)]);
var inst_46916 = (state_46969[(11)]);
var inst_46949 = (state_46969[(2)]);
var inst_46950 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_46951 = [inst_46933,inst_46949];
var inst_46952 = cljs.core.PersistentHashMap.fromArrays(inst_46950,inst_46951);
var inst_46953 = cljs.core.assoc.call(null,inst_46914,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_46952);
var inst_46954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46955 = [inst_46953];
var inst_46956 = (new cljs.core.PersistentVector(null,1,(5),inst_46954,inst_46955,null));
var inst_46957 = cljs.core.concat.call(null,inst_46916,inst_46956);
var inst_46958 = cljs.core.first.call(null,inst_46915);
var state_46969__$1 = (function (){var statearr_46989 = state_46969;
(statearr_46989[(14)] = inst_46957);

return statearr_46989;
})();
if(cljs.core.truth_(inst_46958)){
var statearr_46990_47009 = state_46969__$1;
(statearr_46990_47009[(1)] = (12));

} else {
var statearr_46991_47010 = state_46969__$1;
(statearr_46991_47010[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46970 === (8))){
var inst_46912 = (state_46969[(7)]);
var inst_46920 = (state_46969[(12)]);
var inst_46914 = (state_46969[(8)]);
var inst_46918 = (state_46969[(13)]);
var inst_46915 = (state_46969[(9)]);
var inst_46935 = (state_46969[(15)]);
var inst_46933 = (state_46969[(16)]);
var inst_46913 = (state_46969[(10)]);
var inst_46916 = (state_46969[(11)]);
var inst_46939 = (function (){var flakes = inst_46918;
var rest_blocks = inst_46915;
var curr_block = inst_46914;
var asserted_SINGLEQUOTE_ = inst_46933;
var acc = inst_46916;
var fuel = inst_46912;
var cache = inst_46913;
var retracted = inst_46935;
var asserted = inst_46920;
return (function (p1__46905_SHARP_){
return p1__46905_SHARP_.s;
});
})();
var inst_46940 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_46935);
var inst_46941 = cljs.core.group_by.call(null,inst_46939,inst_46940);
var inst_46942 = cljs.core.vals.call(null,inst_46941);
var inst_46943 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_46913,inst_46912,inst_46942);
var state_46969__$1 = state_46969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46969__$1,(11),inst_46943);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto____0 = (function (){
var statearr_46992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46992[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto__);

(statearr_46992[(1)] = (1));

return statearr_46992;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto____1 = (function (state_46969){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46993){var ex__2724__auto__ = e46993;
var statearr_46994_47011 = state_46969;
(statearr_46994_47011[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46969[(4)]))){
var statearr_46995_47012 = state_46969;
(statearr_46995_47012[(1)] = cljs.core.first.call(null,(state_46969[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47013 = state_46969;
state_46969 = G__47013;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto__ = function(state_46969){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto____1.call(this,state_46969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46996 = f__2744__auto__.call(null);
(statearr_46996[(6)] = c__2743__auto__);

return statearr_46996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_47113){
var state_val_47114 = (state_47113[(1)]);
if((state_val_47114 === (7))){
var inst_47085 = (state_47113[(7)]);
var inst_47078 = (state_47113[(8)]);
var inst_47084 = cljs.core.seq.call(null,inst_47078);
var inst_47085__$1 = cljs.core.first.call(null,inst_47084);
var inst_47086 = cljs.core.next.call(null,inst_47084);
var state_47113__$1 = (function (){var statearr_47115 = state_47113;
(statearr_47115[(9)] = inst_47086);

(statearr_47115[(7)] = inst_47085__$1);

return statearr_47115;
})();
if(cljs.core.truth_(inst_47085__$1)){
var statearr_47116_47153 = state_47113__$1;
(statearr_47116_47153[(1)] = (9));

} else {
var statearr_47117_47154 = state_47113__$1;
(statearr_47117_47154[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (1))){
var state_47113__$1 = state_47113;
var statearr_47118_47155 = state_47113__$1;
(statearr_47118_47155[(2)] = null);

(statearr_47118_47155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (4))){
var inst_47015 = (state_47113[(2)]);
var state_47113__$1 = state_47113;
var statearr_47119_47156 = state_47113__$1;
(statearr_47119_47156[(2)] = inst_47015);

(statearr_47119_47156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (6))){
var inst_47064 = (state_47113[(2)]);
var inst_47065 = fluree.db.util.async.throw_err.call(null,inst_47064);
var inst_47073 = resp;
var inst_47074 = cljs.core.seq.call(null,inst_47073);
var inst_47075 = cljs.core.first.call(null,inst_47074);
var inst_47076 = cljs.core.next.call(null,inst_47074);
var inst_47077 = cljs.core.PersistentHashMap.EMPTY;
var inst_47078 = inst_47073;
var inst_47079 = inst_47077;
var state_47113__$1 = (function (){var statearr_47120 = state_47113;
(statearr_47120[(10)] = inst_47079);

(statearr_47120[(11)] = inst_47076);

(statearr_47120[(8)] = inst_47078);

(statearr_47120[(12)] = inst_47065);

(statearr_47120[(13)] = inst_47075);

return statearr_47120;
})();
var statearr_47121_47157 = state_47113__$1;
(statearr_47121_47157[(2)] = null);

(statearr_47121_47157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (3))){
var inst_47111 = (state_47113[(2)]);
var state_47113__$1 = state_47113;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47113__$1,inst_47111);
} else {
if((state_val_47114 === (2))){
var _ = (function (){var statearr_47122 = state_47113;
(statearr_47122[(4)] = cljs.core.cons.call(null,(5),(state_47113[(4)])));

return statearr_47122;
})();
var inst_47021 = (function (){return (function (p1__47014_SHARP_){
return p1__47014_SHARP_.t;
});
})();
var inst_47022 = cljs.core.map.call(null,inst_47021,resp);
var inst_47023 = cljs.core.set.call(null,inst_47022);
var inst_47060 = cljs.core.async.chan.call(null,(1));
var inst_47061 = (function (){var ts = inst_47023;
var c__2743__auto____$1 = inst_47060;
return (function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_47058){
var state_val_47059 = (state_47058[(1)]);
if((state_val_47059 === (1))){
var inst_47031 = ts;
var inst_47032 = cljs.core.seq.call(null,inst_47031);
var inst_47033 = cljs.core.first.call(null,inst_47032);
var inst_47034 = cljs.core.next.call(null,inst_47032);
var inst_47035 = cljs.core.PersistentHashMap.EMPTY;
var inst_47036 = inst_47031;
var inst_47037 = inst_47035;
var state_47058__$1 = (function (){var statearr_47123 = state_47058;
(statearr_47123[(7)] = inst_47033);

(statearr_47123[(8)] = inst_47034);

(statearr_47123[(9)] = inst_47037);

(statearr_47123[(10)] = inst_47036);

return statearr_47123;
})();
var statearr_47124_47158 = state_47058__$1;
(statearr_47124_47158[(2)] = null);

(statearr_47124_47158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47059 === (2))){
var inst_47043 = (state_47058[(11)]);
var inst_47036 = (state_47058[(10)]);
var inst_47042 = cljs.core.seq.call(null,inst_47036);
var inst_47043__$1 = cljs.core.first.call(null,inst_47042);
var inst_47044 = cljs.core.next.call(null,inst_47042);
var state_47058__$1 = (function (){var statearr_47125 = state_47058;
(statearr_47125[(11)] = inst_47043__$1);

(statearr_47125[(12)] = inst_47044);

return statearr_47125;
})();
if(cljs.core.truth_(inst_47043__$1)){
var statearr_47126_47159 = state_47058__$1;
(statearr_47126_47159[(1)] = (4));

} else {
var statearr_47127_47160 = state_47058__$1;
(statearr_47127_47160[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47059 === (3))){
var inst_47056 = (state_47058[(2)]);
var state_47058__$1 = state_47058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47058__$1,inst_47056);
} else {
if((state_val_47059 === (4))){
var inst_47043 = (state_47058[(11)]);
var inst_47046 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_47043);
var state_47058__$1 = state_47058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47058__$1,(7),inst_47046);
} else {
if((state_val_47059 === (5))){
var inst_47037 = (state_47058[(9)]);
var state_47058__$1 = state_47058;
var statearr_47128_47161 = state_47058__$1;
(statearr_47128_47161[(2)] = inst_47037);

(statearr_47128_47161[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47059 === (6))){
var inst_47054 = (state_47058[(2)]);
var state_47058__$1 = state_47058;
var statearr_47129_47162 = state_47058__$1;
(statearr_47129_47162[(2)] = inst_47054);

(statearr_47129_47162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47059 === (7))){
var inst_47043 = (state_47058[(11)]);
var inst_47044 = (state_47058[(12)]);
var inst_47037 = (state_47058[(9)]);
var inst_47048 = (state_47058[(2)]);
var inst_47049 = fluree.db.util.async.throw_err.call(null,inst_47048);
var inst_47050 = cljs.core.assoc.call(null,inst_47037,inst_47043,inst_47049);
var inst_47036 = inst_47044;
var inst_47037__$1 = inst_47050;
var state_47058__$1 = (function (){var statearr_47130 = state_47058;
(statearr_47130[(9)] = inst_47037__$1);

(statearr_47130[(10)] = inst_47036);

return statearr_47130;
})();
var statearr_47131_47163 = state_47058__$1;
(statearr_47131_47163[(2)] = null);

(statearr_47131_47163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____0 = (function (){
var statearr_47132 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47132[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__);

(statearr_47132[(1)] = (1));

return statearr_47132;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____1 = (function (state_47058){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_47058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e47133){var ex__2724__auto__ = e47133;
var statearr_47134_47164 = state_47058;
(statearr_47134_47164[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_47058[(4)]))){
var statearr_47135_47165 = state_47058;
(statearr_47135_47165[(1)] = cljs.core.first.call(null,(state_47058[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47166 = state_47058;
state_47058 = G__47166;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__ = function(state_47058){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____1.call(this,state_47058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_47136 = f__2744__auto__.call(null);
(statearr_47136[(6)] = c__2743__auto____$1);

return statearr_47136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
});
})();
var inst_47062 = cljs.core.async.impl.dispatch.run.call(null,inst_47061);
var state_47113__$1 = (function (){var statearr_47137 = state_47113;
(statearr_47137[(14)] = inst_47062);

return statearr_47137;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47113__$1,(6),inst_47060);
} else {
if((state_val_47114 === (11))){
var inst_47105 = (state_47113[(2)]);
var state_47113__$1 = state_47113;
var statearr_47139_47167 = state_47113__$1;
(statearr_47139_47167[(2)] = inst_47105);

(statearr_47139_47167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (9))){
var inst_47079 = (state_47113[(10)]);
var inst_47086 = (state_47113[(9)]);
var inst_47085 = (state_47113[(7)]);
var inst_47065 = (state_47113[(12)]);
var inst_47088 = inst_47085.t;
var inst_47089 = cljs.core.get.call(null,inst_47065,inst_47088);
var inst_47090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47091 = [inst_47089,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_47092 = (new cljs.core.PersistentVector(null,2,(5),inst_47090,inst_47091,null));
var inst_47093 = cljs.core.assoc_in.call(null,inst_47079,inst_47092,inst_47089);
var inst_47094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47095 = [inst_47089,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_47096 = (new cljs.core.PersistentVector(null,2,(5),inst_47094,inst_47095,null));
var inst_47097 = cljs.core.update_in.call(null,inst_47093,inst_47096,cljs.core.conj,inst_47085);
var inst_47098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47099 = [inst_47089,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_47100 = (new cljs.core.PersistentVector(null,2,(5),inst_47098,inst_47099,null));
var inst_47101 = cljs.core.update_in.call(null,inst_47097,inst_47100,fluree.db.api_js.min_safe,inst_47088);
var inst_47078 = inst_47086;
var inst_47079__$1 = inst_47101;
var state_47113__$1 = (function (){var statearr_47140 = state_47113;
(statearr_47140[(10)] = inst_47079__$1);

(statearr_47140[(8)] = inst_47078);

return statearr_47140;
})();
var statearr_47141_47168 = state_47113__$1;
(statearr_47141_47168[(2)] = null);

(statearr_47141_47168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (5))){
var _ = (function (){var statearr_47142 = state_47113;
(statearr_47142[(4)] = cljs.core.rest.call(null,(state_47113[(4)])));

return statearr_47142;
})();
var state_47113__$1 = state_47113;
var ex47138 = (state_47113__$1[(2)]);
var statearr_47143_47169 = state_47113__$1;
(statearr_47143_47169[(5)] = ex47138);


if((ex47138 instanceof Error)){
var statearr_47144_47170 = state_47113__$1;
(statearr_47144_47170[(1)] = (4));

(statearr_47144_47170[(5)] = null);

} else {
throw ex47138;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (10))){
var inst_47079 = (state_47113[(10)]);
var state_47113__$1 = state_47113;
var statearr_47145_47171 = state_47113__$1;
(statearr_47145_47171[(2)] = inst_47079);

(statearr_47145_47171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47114 === (8))){
var inst_47107 = (state_47113[(2)]);
var inst_47108 = cljs.core.vals.call(null,inst_47107);
var _ = (function (){var statearr_47146 = state_47113;
(statearr_47146[(4)] = cljs.core.rest.call(null,(state_47113[(4)])));

return statearr_47146;
})();
var state_47113__$1 = state_47113;
var statearr_47147_47172 = state_47113__$1;
(statearr_47147_47172[(2)] = inst_47108);

(statearr_47147_47172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____0 = (function (){
var statearr_47148 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47148[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__);

(statearr_47148[(1)] = (1));

return statearr_47148;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____1 = (function (state_47113){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_47113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e47149){var ex__2724__auto__ = e47149;
var statearr_47150_47173 = state_47113;
(statearr_47150_47173[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_47113[(4)]))){
var statearr_47151_47174 = state_47113;
(statearr_47151_47174[(1)] = cljs.core.first.call(null,(state_47113[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47175 = state_47113;
state_47113 = G__47175;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__ = function(state_47113){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____1.call(this,state_47113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2721__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_47152 = f__2744__auto__.call(null);
(statearr_47152[(6)] = c__2743__auto__);

return statearr_47152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_47320){
var state_val_47321 = (state_47320[(1)]);
if((state_val_47321 === (7))){
var inst_47200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47201 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_47202 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_47203 = [inst_47201,inst_47202];
var inst_47204 = (new cljs.core.PersistentVector(null,2,(5),inst_47200,inst_47203,null));
var state_47320__$1 = state_47320;
var statearr_47322_47393 = state_47320__$1;
(statearr_47322_47393[(2)] = inst_47204);

(statearr_47322_47393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (20))){
var inst_47230 = (state_47320[(7)]);
var state_47320__$1 = state_47320;
var statearr_47323_47394 = state_47320__$1;
(statearr_47323_47394[(2)] = inst_47230);

(statearr_47323_47394[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (27))){
var state_47320__$1 = state_47320;
var statearr_47324_47395 = state_47320__$1;
(statearr_47324_47395[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (1))){
var state_47320__$1 = state_47320;
var statearr_47326_47396 = state_47320__$1;
(statearr_47326_47396[(2)] = null);

(statearr_47326_47396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (24))){
var inst_47229 = (state_47320[(8)]);
var state_47320__$1 = state_47320;
if(cljs.core.truth_(inst_47229)){
var statearr_47327_47397 = state_47320__$1;
(statearr_47327_47397[(1)] = (26));

} else {
var statearr_47328_47398 = state_47320__$1;
(statearr_47328_47398[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (39))){
var inst_47276 = (state_47320[(9)]);
var inst_47275 = (state_47320[(10)]);
var inst_47301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47302 = [inst_47275,inst_47276];
var inst_47303 = (new cljs.core.PersistentVector(null,2,(5),inst_47301,inst_47302,null));
var state_47320__$1 = state_47320;
var statearr_47329_47399 = state_47320__$1;
(statearr_47329_47399[(2)] = inst_47303);

(statearr_47329_47399[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (4))){
var inst_47176 = (state_47320[(2)]);
var inst_47177 = fluree.db.util.log.error.call(null,inst_47176);
var inst_47178 = cljs.core.ex_data.call(null,inst_47176);
var inst_47179 = cljs.core.ex_message.call(null,inst_47176);
var inst_47180 = cljs.core.assoc.call(null,inst_47178,new cljs.core.Keyword(null,"message","message",-406056002),inst_47179);
var state_47320__$1 = (function (){var statearr_47330 = state_47320;
(statearr_47330[(11)] = inst_47177);

return statearr_47330;
})();
var statearr_47331_47400 = state_47320__$1;
(statearr_47331_47400[(2)] = inst_47180);

(statearr_47331_47400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (15))){
var inst_47209 = (state_47320[(12)]);
var inst_47214 = (state_47320[(13)]);
var inst_47223 = (state_47320[(2)]);
var inst_47224 = [inst_47214,inst_47223];
var inst_47225 = (new cljs.core.PersistentVector(null,2,(5),inst_47209,inst_47224,null));
var state_47320__$1 = state_47320;
var statearr_47332_47401 = state_47320__$1;
(statearr_47332_47401[(2)] = inst_47225);

(statearr_47332_47401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (21))){
var inst_47229 = (state_47320[(8)]);
var state_47320__$1 = state_47320;
var statearr_47333_47402 = state_47320__$1;
(statearr_47333_47402[(2)] = inst_47229);

(statearr_47333_47402[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (31))){
var inst_47270 = (state_47320[(2)]);
var state_47320__$1 = state_47320;
var statearr_47334_47403 = state_47320__$1;
(statearr_47334_47403[(2)] = inst_47270);

(statearr_47334_47403[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (32))){
var inst_47276 = (state_47320[(9)]);
var inst_47279 = cljs.core.pos_int_QMARK_.call(null,inst_47276);
var state_47320__$1 = state_47320;
var statearr_47335_47404 = state_47320__$1;
(statearr_47335_47404[(2)] = inst_47279);

(statearr_47335_47404[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (40))){
var inst_47231 = (state_47320[(14)]);
var inst_47307 = (state_47320[(15)]);
var inst_47305 = (state_47320[(2)]);
var inst_47306 = cljs.core.nth.call(null,inst_47305,(0),null);
var inst_47307__$1 = cljs.core.nth.call(null,inst_47305,(1),null);
var inst_47308 = (inst_47307__$1 > inst_47231);
var state_47320__$1 = (function (){var statearr_47336 = state_47320;
(statearr_47336[(16)] = inst_47306);

(statearr_47336[(15)] = inst_47307__$1);

return statearr_47336;
})();
if(cljs.core.truth_(inst_47308)){
var statearr_47337_47405 = state_47320__$1;
(statearr_47337_47405[(1)] = (41));

} else {
var statearr_47338_47406 = state_47320__$1;
(statearr_47338_47406[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (33))){
var inst_47277 = (state_47320[(17)]);
var state_47320__$1 = state_47320;
var statearr_47339_47407 = state_47320__$1;
(statearr_47339_47407[(2)] = inst_47277);

(statearr_47339_47407[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (13))){
var inst_47215 = (state_47320[(18)]);
var inst_47217 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_47215);
var state_47320__$1 = state_47320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47320__$1,(16),inst_47217);
} else {
if((state_val_47321 === (22))){
var inst_47248 = (state_47320[(2)]);
var state_47320__$1 = state_47320;
if(cljs.core.truth_(inst_47248)){
var statearr_47340_47408 = state_47320__$1;
(statearr_47340_47408[(1)] = (23));

} else {
var statearr_47341_47409 = state_47320__$1;
(statearr_47341_47409[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (36))){
var state_47320__$1 = state_47320;
var statearr_47342_47410 = state_47320__$1;
(statearr_47342_47410[(2)] = null);

(statearr_47342_47410[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (41))){
var inst_47231 = (state_47320[(14)]);
var state_47320__$1 = state_47320;
var statearr_47343_47411 = state_47320__$1;
(statearr_47343_47411[(2)] = inst_47231);

(statearr_47343_47411[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (43))){
var inst_47306 = (state_47320[(16)]);
var inst_47312 = (state_47320[(2)]);
var inst_47313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47314 = [inst_47306,inst_47312];
var inst_47315 = (new cljs.core.PersistentVector(null,2,(5),inst_47313,inst_47314,null));
var _ = (function (){var statearr_47344 = state_47320;
(statearr_47344[(4)] = cljs.core.rest.call(null,(state_47320[(4)])));

return statearr_47344;
})();
var state_47320__$1 = state_47320;
var statearr_47345_47412 = state_47320__$1;
(statearr_47345_47412[(2)] = inst_47315);

(statearr_47345_47412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (29))){
var inst_47206 = (state_47320[(19)]);
var inst_47261 = cljs.core.pr_str.call(null,inst_47206);
var inst_47262 = ["Invalid block range provided: ",inst_47261].join('');
var inst_47263 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47264 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_47265 = cljs.core.PersistentHashMap.fromArrays(inst_47263,inst_47264);
var inst_47266 = cljs.core.ex_info.call(null,inst_47262,inst_47265);
var inst_47267 = (function(){throw inst_47266})();
var state_47320__$1 = state_47320;
var statearr_47346_47413 = state_47320__$1;
(statearr_47346_47413[(2)] = inst_47267);

(statearr_47346_47413[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (6))){
var inst_47198 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_47320__$1 = state_47320;
var statearr_47347_47414 = state_47320__$1;
(statearr_47347_47414[(2)] = inst_47198);

(statearr_47347_47414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (28))){
var inst_47272 = (state_47320[(2)]);
var state_47320__$1 = state_47320;
var statearr_47348_47415 = state_47320__$1;
(statearr_47348_47415[(2)] = inst_47272);

(statearr_47348_47415[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (25))){
var inst_47277 = (state_47320[(17)]);
var inst_47275 = (state_47320[(10)]);
var inst_47274 = (state_47320[(2)]);
var inst_47275__$1 = cljs.core.nth.call(null,inst_47274,(0),null);
var inst_47276 = cljs.core.nth.call(null,inst_47274,(1),null);
var inst_47277__$1 = cljs.core.pos_int_QMARK_.call(null,inst_47275__$1);
var state_47320__$1 = (function (){var statearr_47349 = state_47320;
(statearr_47349[(17)] = inst_47277__$1);

(statearr_47349[(9)] = inst_47276);

(statearr_47349[(10)] = inst_47275__$1);

return statearr_47349;
})();
if(inst_47277__$1){
var statearr_47350_47416 = state_47320__$1;
(statearr_47350_47416[(1)] = (32));

} else {
var statearr_47351_47417 = state_47320__$1;
(statearr_47351_47417[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (34))){
var inst_47282 = (state_47320[(2)]);
var inst_47283 = cljs.core.not.call(null,inst_47282);
var state_47320__$1 = state_47320;
if(inst_47283){
var statearr_47352_47418 = state_47320__$1;
(statearr_47352_47418[(1)] = (35));

} else {
var statearr_47353_47419 = state_47320__$1;
(statearr_47353_47419[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (17))){
var inst_47231 = (state_47320[(14)]);
var inst_47229 = (state_47320[(8)]);
var inst_47234 = cljs.core.pr_str.call(null,inst_47229);
var inst_47235 = cljs.core.pr_str.call(null,inst_47231);
var inst_47236 = ["Start block is out of range for this ledger. Start block provided: ",inst_47234,". Database block: ",inst_47235].join('');
var inst_47237 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47238 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_47239 = cljs.core.PersistentHashMap.fromArrays(inst_47237,inst_47238);
var inst_47240 = cljs.core.ex_info.call(null,inst_47236,inst_47239);
var inst_47241 = (function(){throw inst_47240})();
var state_47320__$1 = state_47320;
var statearr_47354_47420 = state_47320__$1;
(statearr_47354_47420[(2)] = inst_47241);

(statearr_47354_47420[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (3))){
var inst_47318 = (state_47320[(2)]);
var state_47320__$1 = state_47320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47320__$1,inst_47318);
} else {
if((state_val_47321 === (12))){
var inst_47215 = (state_47320[(18)]);
var inst_47206 = (state_47320[(19)]);
var inst_47213 = (state_47320[(2)]);
var inst_47214 = fluree.db.util.async.throw_err.call(null,inst_47213);
var inst_47215__$1 = cljs.core.second.call(null,inst_47206);
var state_47320__$1 = (function (){var statearr_47355 = state_47320;
(statearr_47355[(18)] = inst_47215__$1);

(statearr_47355[(13)] = inst_47214);

return statearr_47355;
})();
if(cljs.core.truth_(inst_47215__$1)){
var statearr_47356_47421 = state_47320__$1;
(statearr_47356_47421[(1)] = (13));

} else {
var statearr_47357_47422 = state_47320__$1;
(statearr_47357_47422[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (2))){
var _ = (function (){var statearr_47358 = state_47320;
(statearr_47358[(4)] = cljs.core.cons.call(null,(5),(state_47320[(4)])));

return statearr_47358;
})();
var inst_47195 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_47196 = cljs.core.sequential_QMARK_.call(null,inst_47195);
var state_47320__$1 = state_47320;
if(inst_47196){
var statearr_47359_47423 = state_47320__$1;
(statearr_47359_47423[(1)] = (6));

} else {
var statearr_47360_47424 = state_47320__$1;
(statearr_47360_47424[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (23))){
var inst_47230 = (state_47320[(7)]);
var inst_47229 = (state_47320[(8)]);
var inst_47250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47251 = [inst_47229,inst_47230];
var inst_47252 = (new cljs.core.PersistentVector(null,2,(5),inst_47250,inst_47251,null));
var state_47320__$1 = state_47320;
var statearr_47361_47425 = state_47320__$1;
(statearr_47361_47425[(2)] = inst_47252);

(statearr_47361_47425[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (35))){
var inst_47206 = (state_47320[(19)]);
var inst_47285 = cljs.core.pr_str.call(null,inst_47206);
var inst_47286 = ["Invalid block range provided: ",inst_47285].join('');
var inst_47287 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47288 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_47289 = cljs.core.PersistentHashMap.fromArrays(inst_47287,inst_47288);
var inst_47290 = cljs.core.ex_info.call(null,inst_47286,inst_47289);
var inst_47291 = (function(){throw inst_47290})();
var state_47320__$1 = state_47320;
var statearr_47362_47426 = state_47320__$1;
(statearr_47362_47426[(2)] = inst_47291);

(statearr_47362_47426[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (19))){
var inst_47229 = (state_47320[(8)]);
var inst_47244 = (state_47320[(2)]);
var state_47320__$1 = (function (){var statearr_47363 = state_47320;
(statearr_47363[(20)] = inst_47244);

return statearr_47363;
})();
if(cljs.core.truth_(inst_47229)){
var statearr_47364_47427 = state_47320__$1;
(statearr_47364_47427[(1)] = (20));

} else {
var statearr_47365_47428 = state_47320__$1;
(statearr_47365_47428[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (11))){
var inst_47231 = (state_47320[(14)]);
var inst_47229 = (state_47320[(8)]);
var inst_47228 = (state_47320[(2)]);
var inst_47229__$1 = cljs.core.nth.call(null,inst_47228,(0),null);
var inst_47230 = cljs.core.nth.call(null,inst_47228,(1),null);
var inst_47231__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_47232 = (inst_47229__$1 > inst_47231__$1);
var state_47320__$1 = (function (){var statearr_47367 = state_47320;
(statearr_47367[(7)] = inst_47230);

(statearr_47367[(14)] = inst_47231__$1);

(statearr_47367[(8)] = inst_47229__$1);

return statearr_47367;
})();
if(cljs.core.truth_(inst_47232)){
var statearr_47368_47429 = state_47320__$1;
(statearr_47368_47429[(1)] = (17));

} else {
var statearr_47369_47430 = state_47320__$1;
(statearr_47369_47430[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (9))){
var inst_47206 = (state_47320[(19)]);
var inst_47209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47210 = cljs.core.first.call(null,inst_47206);
var inst_47211 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_47210);
var state_47320__$1 = (function (){var statearr_47370 = state_47320;
(statearr_47370[(12)] = inst_47209);

return statearr_47370;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47320__$1,(12),inst_47211);
} else {
if((state_val_47321 === (5))){
var _ = (function (){var statearr_47371 = state_47320;
(statearr_47371[(4)] = cljs.core.rest.call(null,(state_47320[(4)])));

return statearr_47371;
})();
var state_47320__$1 = state_47320;
var ex47366 = (state_47320__$1[(2)]);
var statearr_47372_47431 = state_47320__$1;
(statearr_47372_47431[(5)] = ex47366);


var statearr_47373_47432 = state_47320__$1;
(statearr_47373_47432[(1)] = (4));

(statearr_47373_47432[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (14))){
var state_47320__$1 = state_47320;
var statearr_47374_47433 = state_47320__$1;
(statearr_47374_47433[(2)] = null);

(statearr_47374_47433[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (26))){
var inst_47229 = (state_47320[(8)]);
var inst_47255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47256 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_47257 = [inst_47229,inst_47256];
var inst_47258 = (new cljs.core.PersistentVector(null,2,(5),inst_47255,inst_47257,null));
var state_47320__$1 = state_47320;
var statearr_47375_47434 = state_47320__$1;
(statearr_47375_47434[(2)] = inst_47258);

(statearr_47375_47434[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (16))){
var inst_47219 = (state_47320[(2)]);
var inst_47220 = fluree.db.util.async.throw_err.call(null,inst_47219);
var state_47320__$1 = state_47320;
var statearr_47376_47435 = state_47320__$1;
(statearr_47376_47435[(2)] = inst_47220);

(statearr_47376_47435[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (38))){
var inst_47276 = (state_47320[(9)]);
var inst_47275 = (state_47320[(10)]);
var inst_47297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47298 = [inst_47276,inst_47275];
var inst_47299 = (new cljs.core.PersistentVector(null,2,(5),inst_47297,inst_47298,null));
var state_47320__$1 = state_47320;
var statearr_47377_47436 = state_47320__$1;
(statearr_47377_47436[(2)] = inst_47299);

(statearr_47377_47436[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (30))){
var state_47320__$1 = state_47320;
var statearr_47378_47437 = state_47320__$1;
(statearr_47378_47437[(2)] = null);

(statearr_47378_47437[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (10))){
var inst_47206 = (state_47320[(19)]);
var state_47320__$1 = state_47320;
var statearr_47379_47438 = state_47320__$1;
(statearr_47379_47438[(2)] = inst_47206);

(statearr_47379_47438[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (18))){
var state_47320__$1 = state_47320;
var statearr_47380_47439 = state_47320__$1;
(statearr_47380_47439[(2)] = null);

(statearr_47380_47439[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (42))){
var inst_47307 = (state_47320[(15)]);
var state_47320__$1 = state_47320;
var statearr_47381_47440 = state_47320__$1;
(statearr_47381_47440[(2)] = inst_47307);

(statearr_47381_47440[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (37))){
var inst_47276 = (state_47320[(9)]);
var inst_47275 = (state_47320[(10)]);
var inst_47294 = (state_47320[(2)]);
var inst_47295 = (inst_47276 < inst_47275);
var state_47320__$1 = (function (){var statearr_47382 = state_47320;
(statearr_47382[(21)] = inst_47294);

return statearr_47382;
})();
if(cljs.core.truth_(inst_47295)){
var statearr_47383_47441 = state_47320__$1;
(statearr_47383_47441[(1)] = (38));

} else {
var statearr_47384_47442 = state_47320__$1;
(statearr_47384_47442[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47321 === (8))){
var inst_47206 = (state_47320[(19)]);
var inst_47206__$1 = (state_47320[(2)]);
var inst_47207 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_47206__$1);
var state_47320__$1 = (function (){var statearr_47385 = state_47320;
(statearr_47385[(19)] = inst_47206__$1);

return statearr_47385;
})();
if(cljs.core.truth_(inst_47207)){
var statearr_47386_47443 = state_47320__$1;
(statearr_47386_47443[(1)] = (9));

} else {
var statearr_47387_47444 = state_47320__$1;
(statearr_47387_47444[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto____0 = (function (){
var statearr_47388 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47388[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto__);

(statearr_47388[(1)] = (1));

return statearr_47388;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto____1 = (function (state_47320){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_47320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e47389){var ex__2724__auto__ = e47389;
var statearr_47390_47445 = state_47320;
(statearr_47390_47445[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_47320[(4)]))){
var statearr_47391_47446 = state_47320;
(statearr_47391_47446[(1)] = cljs.core.first.call(null,(state_47320[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47447 = state_47320;
state_47320 = G__47447;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto__ = function(state_47320){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto____1.call(this,state_47320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_47392 = f__2744__auto__.call(null);
(statearr_47392[(6)] = c__2743__auto__);

return statearr_47392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__47449 = arguments.length;
switch (G__47449) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_47540){
var state_val_47541 = (state_47540[(1)]);
if((state_val_47541 === (7))){
var inst_47472 = (state_47540[(7)]);
var inst_47475 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_47472);
var state_47540__$1 = state_47540;
var statearr_47542_47593 = state_47540__$1;
(statearr_47542_47593[(2)] = inst_47475);

(statearr_47542_47593[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (20))){
var inst_47511 = (state_47540[(8)]);
var inst_47514 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_47511);
var state_47540__$1 = state_47540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47540__$1,(23),inst_47514);
} else {
if((state_val_47541 === (27))){
var inst_47520 = (state_47540[(9)]);
var inst_47526 = cljs.core.doall.call(null,inst_47520);
var state_47540__$1 = state_47540;
var statearr_47543_47594 = state_47540__$1;
(statearr_47543_47594[(2)] = inst_47526);

(statearr_47543_47594[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (1))){
var state_47540__$1 = state_47540;
var statearr_47544_47595 = state_47540__$1;
(statearr_47544_47595[(2)] = null);

(statearr_47544_47595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (24))){
var inst_47520 = (state_47540[(9)]);
var inst_47523 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_47524 = cljs.core.sequential_QMARK_.call(null,inst_47520);
var state_47540__$1 = (function (){var statearr_47545 = state_47540;
(statearr_47545[(10)] = inst_47523);

return statearr_47545;
})();
if(inst_47524){
var statearr_47546_47596 = state_47540__$1;
(statearr_47546_47596[(1)] = (27));

} else {
var statearr_47547_47597 = state_47540__$1;
(statearr_47547_47597[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (4))){
var inst_47450 = (state_47540[(2)]);
var inst_47451 = fluree.db.util.log.error.call(null,inst_47450);
var inst_47452 = cljs.core.ex_data.call(null,inst_47450);
var inst_47453 = cljs.core.ex_message.call(null,inst_47450);
var inst_47454 = cljs.core.assoc.call(null,inst_47452,new cljs.core.Keyword(null,"message","message",-406056002),inst_47453);
var state_47540__$1 = (function (){var statearr_47548 = state_47540;
(statearr_47548[(11)] = inst_47451);

return statearr_47548;
})();
var statearr_47549_47598 = state_47540__$1;
(statearr_47549_47598[(2)] = inst_47454);

(statearr_47549_47598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (15))){
var inst_47472 = (state_47540[(7)]);
var inst_47485 = (state_47540[(2)]);
var inst_47486 = cljs.core.ex_info.call(null,inst_47485,inst_47472);
var inst_47487 = (function(){throw inst_47486})();
var state_47540__$1 = state_47540;
var statearr_47550_47599 = state_47540__$1;
(statearr_47550_47599[(2)] = inst_47487);

(statearr_47550_47599[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (21))){
var inst_47511 = (state_47540[(8)]);
var state_47540__$1 = state_47540;
var statearr_47551_47600 = state_47540__$1;
(statearr_47551_47600[(2)] = inst_47511);

(statearr_47551_47600[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (13))){
var inst_47480 = (state_47540[(12)]);
var state_47540__$1 = state_47540;
var statearr_47552_47601 = state_47540__$1;
(statearr_47552_47601[(2)] = inst_47480);

(statearr_47552_47601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (22))){
var inst_47520 = (state_47540[(2)]);
var inst_47521 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_47540__$1 = (function (){var statearr_47553 = state_47540;
(statearr_47553[(9)] = inst_47520);

return statearr_47553;
})();
if(cljs.core.truth_(inst_47521)){
var statearr_47554_47602 = state_47540__$1;
(statearr_47554_47602[(1)] = (24));

} else {
var statearr_47555_47603 = state_47540__$1;
(statearr_47555_47603[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (29))){
var inst_47464 = (state_47540[(13)]);
var inst_47523 = (state_47540[(10)]);
var inst_47529 = (state_47540[(2)]);
var inst_47530 = fluree.db.util.core.response_time_formatted.call(null,inst_47464);
var inst_47531 = [(200),inst_47529,(100),inst_47530];
var inst_47532 = cljs.core.PersistentHashMap.fromArrays(inst_47523,inst_47531);
var state_47540__$1 = state_47540;
var statearr_47556_47604 = state_47540__$1;
(statearr_47556_47604[(2)] = inst_47532);

(statearr_47556_47604[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (6))){
var inst_47473 = (state_47540[(14)]);
var inst_47472 = (state_47540[(7)]);
var inst_47471 = (state_47540[(2)]);
var inst_47472__$1 = fluree.db.util.async.throw_err.call(null,inst_47471);
var inst_47473__$1 = cljs.core.map_QMARK_.call(null,inst_47472__$1);
var state_47540__$1 = (function (){var statearr_47557 = state_47540;
(statearr_47557[(14)] = inst_47473__$1);

(statearr_47557[(7)] = inst_47472__$1);

return statearr_47557;
})();
if(inst_47473__$1){
var statearr_47558_47605 = state_47540__$1;
(statearr_47558_47605[(1)] = (7));

} else {
var statearr_47559_47606 = state_47540__$1;
(statearr_47559_47606[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (28))){
var inst_47520 = (state_47540[(9)]);
var state_47540__$1 = state_47540;
var statearr_47560_47607 = state_47540__$1;
(statearr_47560_47607[(2)] = inst_47520);

(statearr_47560_47607[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (25))){
var inst_47520 = (state_47540[(9)]);
var state_47540__$1 = state_47540;
var statearr_47561_47608 = state_47540__$1;
(statearr_47561_47608[(2)] = inst_47520);

(statearr_47561_47608[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (17))){
var inst_47503 = cljs.core.pr_str.call(null,query_map);
var inst_47504 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_47503].join('');
var inst_47505 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47506 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_47507 = cljs.core.PersistentHashMap.fromArrays(inst_47505,inst_47506);
var inst_47508 = cljs.core.ex_info.call(null,inst_47504,inst_47507);
var inst_47509 = (function(){throw inst_47508})();
var state_47540__$1 = state_47540;
var statearr_47562_47609 = state_47540__$1;
(statearr_47562_47609[(2)] = inst_47509);

(statearr_47562_47609[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (3))){
var inst_47538 = (state_47540[(2)]);
var state_47540__$1 = state_47540;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47540__$1,inst_47538);
} else {
if((state_val_47541 === (12))){
var inst_47472 = (state_47540[(7)]);
var inst_47490 = (state_47540[(2)]);
var inst_47491 = cljs.core.nth.call(null,inst_47472,(0),null);
var inst_47492 = cljs.core.nth.call(null,inst_47472,(1),null);
var inst_47493 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_47494 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_47495 = cljs.core.keys.call(null,inst_47494);
var inst_47496 = cljs.core._EQ_.call(null,inst_47493,inst_47495);
var state_47540__$1 = (function (){var statearr_47563 = state_47540;
(statearr_47563[(15)] = inst_47490);

(statearr_47563[(16)] = inst_47492);

(statearr_47563[(17)] = inst_47491);

return statearr_47563;
})();
if(inst_47496){
var statearr_47564_47610 = state_47540__$1;
(statearr_47564_47610[(1)] = (16));

} else {
var statearr_47565_47611 = state_47540__$1;
(statearr_47565_47611[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (2))){
var _ = (function (){var statearr_47566 = state_47540;
(statearr_47566[(4)] = cljs.core.cons.call(null,(5),(state_47540[(4)])));

return statearr_47566;
})();
var inst_47464 = fluree.db.util.core.current_time_millis.call(null);
var inst_47465 = db;
var inst_47466 = cljs.core.__destructure_map.call(null,inst_47465);
var inst_47467 = cljs.core.get.call(null,inst_47466,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_47468 = cljs.core.get.call(null,inst_47466,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_47469 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_47540__$1 = (function (){var statearr_47567 = state_47540;
(statearr_47567[(13)] = inst_47464);

(statearr_47567[(18)] = inst_47467);

(statearr_47567[(19)] = inst_47468);

return statearr_47567;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47540__$1,(6),inst_47469);
} else {
if((state_val_47541 === (23))){
var inst_47516 = (state_47540[(2)]);
var inst_47517 = fluree.db.util.async.throw_err.call(null,inst_47516);
var state_47540__$1 = state_47540;
var statearr_47568_47612 = state_47540__$1;
(statearr_47568_47612[(2)] = inst_47517);

(statearr_47568_47612[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (19))){
var inst_47500 = (state_47540[(2)]);
var inst_47501 = fluree.db.util.async.throw_err.call(null,inst_47500);
var state_47540__$1 = state_47540;
var statearr_47569_47613 = state_47540__$1;
(statearr_47569_47613[(2)] = inst_47501);

(statearr_47569_47613[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (11))){
var state_47540__$1 = state_47540;
var statearr_47571_47614 = state_47540__$1;
(statearr_47571_47614[(2)] = null);

(statearr_47571_47614[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (9))){
var inst_47478 = (state_47540[(2)]);
var state_47540__$1 = state_47540;
if(cljs.core.truth_(inst_47478)){
var statearr_47572_47615 = state_47540__$1;
(statearr_47572_47615[(1)] = (10));

} else {
var statearr_47573_47616 = state_47540__$1;
(statearr_47573_47616[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (5))){
var _ = (function (){var statearr_47574 = state_47540;
(statearr_47574[(4)] = cljs.core.rest.call(null,(state_47540[(4)])));

return statearr_47574;
})();
var state_47540__$1 = state_47540;
var ex47570 = (state_47540__$1[(2)]);
var statearr_47575_47617 = state_47540__$1;
(statearr_47575_47617[(5)] = ex47570);


var statearr_47576_47618 = state_47540__$1;
(statearr_47576_47618[(1)] = (4));

(statearr_47576_47618[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (14))){
var inst_47467 = (state_47540[(18)]);
var inst_47468 = (state_47540[(19)]);
var inst_47483 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47467),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47468)].join('');
var state_47540__$1 = state_47540;
var statearr_47577_47619 = state_47540__$1;
(statearr_47577_47619[(2)] = inst_47483);

(statearr_47577_47619[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (26))){
var inst_47535 = (state_47540[(2)]);
var _ = (function (){var statearr_47578 = state_47540;
(statearr_47578[(4)] = cljs.core.rest.call(null,(state_47540[(4)])));

return statearr_47578;
})();
var state_47540__$1 = state_47540;
var statearr_47579_47620 = state_47540__$1;
(statearr_47579_47620[(2)] = inst_47535);

(statearr_47579_47620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (16))){
var inst_47492 = (state_47540[(16)]);
var inst_47491 = (state_47540[(17)]);
var inst_47498 = fluree.db.query.block.block_range.call(null,db,inst_47491,inst_47492,opts);
var state_47540__$1 = state_47540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47540__$1,(19),inst_47498);
} else {
if((state_val_47541 === (10))){
var inst_47480 = (state_47540[(12)]);
var inst_47472 = (state_47540[(7)]);
var inst_47480__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_47472);
var state_47540__$1 = (function (){var statearr_47580 = state_47540;
(statearr_47580[(12)] = inst_47480__$1);

return statearr_47580;
})();
if(cljs.core.truth_(inst_47480__$1)){
var statearr_47581_47621 = state_47540__$1;
(statearr_47581_47621[(1)] = (13));

} else {
var statearr_47582_47622 = state_47540__$1;
(statearr_47582_47622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (18))){
var inst_47511 = (state_47540[(2)]);
var inst_47512 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_47540__$1 = (function (){var statearr_47583 = state_47540;
(statearr_47583[(8)] = inst_47511);

return statearr_47583;
})();
if(cljs.core.truth_(inst_47512)){
var statearr_47584_47623 = state_47540__$1;
(statearr_47584_47623[(1)] = (20));

} else {
var statearr_47585_47624 = state_47540__$1;
(statearr_47585_47624[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (8))){
var inst_47473 = (state_47540[(14)]);
var state_47540__$1 = state_47540;
var statearr_47586_47625 = state_47540__$1;
(statearr_47586_47625[(2)] = inst_47473);

(statearr_47586_47625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_47587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47587[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_47587[(1)] = (1));

return statearr_47587;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_47540){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_47540);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e47588){var ex__2724__auto__ = e47588;
var statearr_47589_47626 = state_47540;
(statearr_47589_47626[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_47540[(4)]))){
var statearr_47590_47627 = state_47540;
(statearr_47590_47627[(1)] = cljs.core.first.call(null,(state_47540[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47628 = state_47540;
state_47540 = G__47628;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_47540){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_47540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_47591 = f__2744__auto__.call(null);
(statearr_47591[(6)] = c__2743__auto__);

return statearr_47591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__47630 = arguments.length;
switch (G__47630) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_47825){
var state_val_47826 = (state_47825[(1)]);
if((state_val_47826 === (62))){
var inst_47823 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47825__$1,inst_47823);
} else {
if((state_val_47826 === (7))){
var inst_47651 = (state_47825[(7)]);
var inst_47661 = cljs.core.not_EQ_.call(null,(1),inst_47651);
var state_47825__$1 = state_47825;
var statearr_47827_47918 = state_47825__$1;
(statearr_47827_47918[(2)] = inst_47661);

(statearr_47827_47918[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (59))){
var inst_47811 = (state_47825[(2)]);
var inst_47812 = fluree.db.util.async.throw_err.call(null,inst_47811);
var state_47825__$1 = state_47825;
var statearr_47828_47919 = state_47825__$1;
(statearr_47828_47919[(2)] = inst_47812);

(statearr_47828_47919[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (20))){
var inst_47727 = (state_47825[(8)]);
var inst_47719 = (state_47825[(9)]);
var inst_47719__$1 = (state_47825[(2)]);
var inst_47720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47721 = cljs.core.get.call(null,inst_47719__$1,(0));
var inst_47722 = cljs.core.get.call(null,inst_47719__$1,(1));
var inst_47723 = cljs.core.get.call(null,inst_47719__$1,(2));
var inst_47724 = cljs.core.get.call(null,inst_47719__$1,(3));
var inst_47725 = [inst_47721,inst_47722,inst_47723,inst_47724];
var inst_47726 = (new cljs.core.PersistentVector(null,4,(5),inst_47720,inst_47725,null));
var inst_47727__$1 = cljs.core.nth.call(null,inst_47726,(0),null);
var inst_47728 = cljs.core.nth.call(null,inst_47726,(1),null);
var inst_47729 = cljs.core.nth.call(null,inst_47726,(2),null);
var inst_47730 = cljs.core.nth.call(null,inst_47726,(3),null);
var inst_47731 = (inst_47727__$1 == null);
var inst_47732 = cljs.core.not.call(null,inst_47731);
var state_47825__$1 = (function (){var statearr_47829 = state_47825;
(statearr_47829[(8)] = inst_47727__$1);

(statearr_47829[(9)] = inst_47719__$1);

(statearr_47829[(10)] = inst_47728);

(statearr_47829[(11)] = inst_47730);

(statearr_47829[(12)] = inst_47729);

return statearr_47829;
})();
if(inst_47732){
var statearr_47830_47920 = state_47825__$1;
(statearr_47830_47920[(1)] = (30));

} else {
var statearr_47831_47921 = state_47825__$1;
(statearr_47831_47921[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (58))){
var inst_47659 = (state_47825[(13)]);
var inst_47815 = (state_47825[(2)]);
var state_47825__$1 = (function (){var statearr_47832 = state_47825;
(statearr_47832[(14)] = inst_47815);

return statearr_47832;
})();
if(cljs.core.truth_(inst_47659)){
var statearr_47833_47922 = state_47825__$1;
(statearr_47833_47922[(1)] = (60));

} else {
var statearr_47834_47923 = state_47825__$1;
(statearr_47834_47923[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (60))){
var inst_47803 = (state_47825[(15)]);
var inst_47815 = (state_47825[(14)]);
var inst_47817 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_47818 = cljs.core.count.call(null,inst_47803);
var inst_47819 = [inst_47815,inst_47818,(200)];
var inst_47820 = cljs.core.PersistentHashMap.fromArrays(inst_47817,inst_47819);
var state_47825__$1 = state_47825;
var statearr_47835_47924 = state_47825__$1;
(statearr_47835_47924[(2)] = inst_47820);

(statearr_47835_47924[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (27))){
var inst_47638 = (state_47825[(16)]);
var inst_47707 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47638)].join('');
var inst_47708 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47709 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_47710 = cljs.core.PersistentHashMap.fromArrays(inst_47708,inst_47709);
var inst_47711 = cljs.core.ex_info.call(null,inst_47707,inst_47710);
var inst_47712 = (function(){throw inst_47711})();
var state_47825__$1 = state_47825;
var statearr_47836_47925 = state_47825__$1;
(statearr_47836_47925[(2)] = inst_47712);

(statearr_47836_47925[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (1))){
var inst_47635 = query_map;
var inst_47636 = cljs.core.__destructure_map.call(null,inst_47635);
var inst_47637 = cljs.core.get.call(null,inst_47636,new cljs.core.Keyword(null,"block","block",664686210));
var inst_47638 = cljs.core.get.call(null,inst_47636,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_47639 = cljs.core.get.call(null,inst_47636,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_47825__$1 = (function (){var statearr_47837 = state_47825;
(statearr_47837[(17)] = inst_47639);

(statearr_47837[(18)] = inst_47637);

(statearr_47837[(16)] = inst_47638);

return statearr_47837;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47825__$1,(2),sources);
} else {
if((state_val_47826 === (24))){
var inst_47638 = (state_47825[(16)]);
var inst_47696 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47638)].join('');
var inst_47697 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47698 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_47699 = cljs.core.PersistentHashMap.fromArrays(inst_47697,inst_47698);
var inst_47700 = cljs.core.ex_info.call(null,inst_47696,inst_47699);
var inst_47701 = (function(){throw inst_47700})();
var state_47825__$1 = state_47825;
var statearr_47838_47926 = state_47825__$1;
(statearr_47838_47926[(2)] = inst_47701);

(statearr_47838_47926[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (55))){
var inst_47639 = (state_47825[(17)]);
var inst_47806 = (state_47825[(2)]);
var inst_47807 = fluree.db.util.async.throw_err.call(null,inst_47806);
var state_47825__$1 = (function (){var statearr_47839 = state_47825;
(statearr_47839[(19)] = inst_47807);

return statearr_47839;
})();
if(cljs.core.truth_(inst_47639)){
var statearr_47840_47927 = state_47825__$1;
(statearr_47840_47927[(1)] = (56));

} else {
var statearr_47841_47928 = state_47825__$1;
(statearr_47841_47928[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (39))){
var inst_47727 = (state_47825[(8)]);
var inst_47728 = (state_47825[(10)]);
var inst_47730 = (state_47825[(11)]);
var inst_47729 = (state_47825[(12)]);
var inst_47751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47753 = [inst_47728,inst_47727,inst_47729,inst_47730];
var inst_47754 = (new cljs.core.PersistentVector(null,4,(5),inst_47752,inst_47753,null));
var inst_47755 = [inst_47754,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_47756 = (new cljs.core.PersistentVector(null,2,(5),inst_47751,inst_47755,null));
var state_47825__$1 = state_47825;
var statearr_47842_47929 = state_47825__$1;
(statearr_47842_47929[(2)] = inst_47756);

(statearr_47842_47929[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (46))){
var inst_47761 = (state_47825[(20)]);
var state_47825__$1 = state_47825;
var statearr_47843_47930 = state_47825__$1;
(statearr_47843_47930[(2)] = inst_47761);

(statearr_47843_47930[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (4))){
var state_47825__$1 = state_47825;
var statearr_47844_47931 = state_47825__$1;
(statearr_47844_47931[(2)] = null);

(statearr_47844_47931[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (54))){
var inst_47803 = (state_47825[(15)]);
var inst_47642 = (state_47825[(21)]);
var inst_47802 = (state_47825[(2)]);
var inst_47803__$1 = fluree.db.util.async.throw_err.call(null,inst_47802);
var inst_47804 = fluree.db.api_js.format_history_resp.call(null,inst_47642,inst_47803__$1);
var state_47825__$1 = (function (){var statearr_47845 = state_47825;
(statearr_47845[(15)] = inst_47803__$1);

return statearr_47845;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47825__$1,(55),inst_47804);
} else {
if((state_val_47826 === (15))){
var inst_47642 = (state_47825[(21)]);
var inst_47683 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_47642);
var state_47825__$1 = state_47825;
var statearr_47846_47932 = state_47825__$1;
(statearr_47846_47932[(2)] = inst_47683);

(statearr_47846_47932[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (48))){
var inst_47727 = (state_47825[(8)]);
var inst_47728 = (state_47825[(10)]);
var inst_47730 = (state_47825[(11)]);
var inst_47729 = (state_47825[(12)]);
var inst_47772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47774 = [inst_47728,inst_47729,inst_47727,inst_47730];
var inst_47775 = (new cljs.core.PersistentVector(null,4,(5),inst_47773,inst_47774,null));
var inst_47776 = [inst_47775,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_47777 = (new cljs.core.PersistentVector(null,2,(5),inst_47772,inst_47776,null));
var state_47825__$1 = state_47825;
var statearr_47847_47933 = state_47825__$1;
(statearr_47847_47933[(2)] = inst_47777);

(statearr_47847_47933[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (50))){
var inst_47790 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47848_47934 = state_47825__$1;
(statearr_47848_47934[(2)] = inst_47790);

(statearr_47848_47934[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (21))){
var inst_47638 = (state_47825[(16)]);
var inst_47694 = cljs.core.empty_QMARK_.call(null,inst_47638);
var state_47825__$1 = state_47825;
if(inst_47694){
var statearr_47849_47935 = state_47825__$1;
(statearr_47849_47935[(1)] = (24));

} else {
var statearr_47850_47936 = state_47825__$1;
(statearr_47850_47936[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (31))){
var inst_47738 = (state_47825[(22)]);
var inst_47727 = (state_47825[(8)]);
var inst_47738__$1 = (inst_47727 == null);
var state_47825__$1 = (function (){var statearr_47851 = state_47825;
(statearr_47851[(22)] = inst_47738__$1);

return statearr_47851;
})();
if(cljs.core.truth_(inst_47738__$1)){
var statearr_47852_47937 = state_47825__$1;
(statearr_47852_47937[(1)] = (33));

} else {
var statearr_47853_47938 = state_47825__$1;
(statearr_47853_47938[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (32))){
var inst_47642 = (state_47825[(21)]);
var inst_47685 = (state_47825[(23)]);
var inst_47675 = (state_47825[(24)]);
var inst_47794 = (state_47825[(2)]);
var inst_47795 = cljs.core.nth.call(null,inst_47794,(0),null);
var inst_47796 = cljs.core.nth.call(null,inst_47794,(1),null);
var inst_47797 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_47798 = [inst_47675,inst_47685];
var inst_47799 = cljs.core.PersistentHashMap.fromArrays(inst_47797,inst_47798);
var inst_47800 = fluree.db.query.range.time_range.call(null,inst_47642,inst_47796,cljs.core._EQ_,inst_47795,inst_47799);
var state_47825__$1 = state_47825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47825__$1,(54),inst_47800);
} else {
if((state_val_47826 === (40))){
var inst_47758 = (state_47825[(25)]);
var inst_47727 = (state_47825[(8)]);
var inst_47758__$1 = (inst_47727 == null);
var state_47825__$1 = (function (){var statearr_47854 = state_47825;
(statearr_47854[(25)] = inst_47758__$1);

return statearr_47854;
})();
if(cljs.core.truth_(inst_47758__$1)){
var statearr_47855_47939 = state_47825__$1;
(statearr_47855_47939[(1)] = (42));

} else {
var statearr_47856_47940 = state_47825__$1;
(statearr_47856_47940[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (56))){
var inst_47642 = (state_47825[(21)]);
var inst_47807 = (state_47825[(19)]);
var inst_47809 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_47642,inst_47807);
var state_47825__$1 = state_47825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47825__$1,(59),inst_47809);
} else {
if((state_val_47826 === (33))){
var inst_47741 = (state_47825[(26)]);
var inst_47728 = (state_47825[(10)]);
var inst_47740 = (inst_47728 == null);
var inst_47741__$1 = cljs.core.not.call(null,inst_47740);
var state_47825__$1 = (function (){var statearr_47857 = state_47825;
(statearr_47857[(26)] = inst_47741__$1);

return statearr_47857;
})();
if(inst_47741__$1){
var statearr_47858_47941 = state_47825__$1;
(statearr_47858_47941[(1)] = (36));

} else {
var statearr_47859_47942 = state_47825__$1;
(statearr_47859_47942[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (13))){
var inst_47669 = (state_47825[(2)]);
var inst_47670 = fluree.db.util.async.throw_err.call(null,inst_47669);
var inst_47671 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_47670);
var inst_47672 = (inst_47671 - (1));
var state_47825__$1 = state_47825;
var statearr_47860_47943 = state_47825__$1;
(statearr_47860_47943[(2)] = inst_47672);

(statearr_47860_47943[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (22))){
var state_47825__$1 = state_47825;
var statearr_47861_47944 = state_47825__$1;
(statearr_47861_47944[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (36))){
var inst_47729 = (state_47825[(12)]);
var inst_47743 = (inst_47729 == null);
var state_47825__$1 = state_47825;
var statearr_47863_47945 = state_47825__$1;
(statearr_47863_47945[(2)] = inst_47743);

(statearr_47863_47945[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (41))){
var inst_47792 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47864_47946 = state_47825__$1;
(statearr_47864_47946[(2)] = inst_47792);

(statearr_47864_47946[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (43))){
var inst_47758 = (state_47825[(25)]);
var state_47825__$1 = state_47825;
var statearr_47865_47947 = state_47825__$1;
(statearr_47865_47947[(2)] = inst_47758);

(statearr_47865_47947[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (61))){
var inst_47815 = (state_47825[(14)]);
var state_47825__$1 = state_47825;
var statearr_47866_47948 = state_47825__$1;
(statearr_47866_47948[(2)] = inst_47815);

(statearr_47866_47948[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (29))){
var inst_47715 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47867_47949 = state_47825__$1;
(statearr_47867_47949[(2)] = inst_47715);

(statearr_47867_47949[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (44))){
var inst_47770 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
if(cljs.core.truth_(inst_47770)){
var statearr_47868_47950 = state_47825__$1;
(statearr_47868_47950[(1)] = (48));

} else {
var statearr_47869_47951 = state_47825__$1;
(statearr_47869_47951[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (6))){
var inst_47646 = (state_47825[(2)]);
var inst_47647 = fluree.db.util.async.throw_err.call(null,inst_47646);
var state_47825__$1 = state_47825;
var statearr_47870_47952 = state_47825__$1;
(statearr_47870_47952[(2)] = inst_47647);

(statearr_47870_47952[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (28))){
var state_47825__$1 = state_47825;
var statearr_47871_47953 = state_47825__$1;
(statearr_47871_47953[(2)] = null);

(statearr_47871_47953[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (51))){
var inst_47638 = (state_47825[(16)]);
var inst_47780 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47638)].join('');
var inst_47781 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47782 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_47783 = cljs.core.PersistentHashMap.fromArrays(inst_47781,inst_47782);
var inst_47784 = cljs.core.ex_info.call(null,inst_47780,inst_47783);
var inst_47785 = (function(){throw inst_47784})();
var state_47825__$1 = state_47825;
var statearr_47872_47954 = state_47825__$1;
(statearr_47872_47954[(2)] = inst_47785);

(statearr_47872_47954[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (25))){
var inst_47638 = (state_47825[(16)]);
var state_47825__$1 = state_47825;
var statearr_47873_47955 = state_47825__$1;
(statearr_47873_47955[(2)] = inst_47638);

(statearr_47873_47955[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (34))){
var inst_47738 = (state_47825[(22)]);
var state_47825__$1 = state_47825;
var statearr_47874_47956 = state_47825__$1;
(statearr_47874_47956[(2)] = inst_47738);

(statearr_47874_47956[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (17))){
var inst_47679 = (state_47825[(2)]);
var inst_47680 = fluree.db.util.async.throw_err.call(null,inst_47679);
var inst_47681 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_47680);
var state_47825__$1 = state_47825;
var statearr_47875_47957 = state_47825__$1;
(statearr_47875_47957[(2)] = inst_47681);

(statearr_47875_47957[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (3))){
var inst_47642 = (state_47825[(21)]);
var inst_47644 = fluree.db.api_js.resolve_block_range.call(null,inst_47642,query_map);
var state_47825__$1 = state_47825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47825__$1,(6),inst_47644);
} else {
if((state_val_47826 === (12))){
var inst_47652 = (state_47825[(27)]);
var inst_47675 = (state_47825[(2)]);
var state_47825__$1 = (function (){var statearr_47876 = state_47825;
(statearr_47876[(24)] = inst_47675);

return statearr_47876;
})();
if(cljs.core.truth_(inst_47652)){
var statearr_47877_47958 = state_47825__$1;
(statearr_47877_47958[(1)] = (14));

} else {
var statearr_47878_47959 = state_47825__$1;
(statearr_47878_47959[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (2))){
var inst_47637 = (state_47825[(18)]);
var inst_47641 = (state_47825[(2)]);
var inst_47642 = fluree.db.util.async.throw_err.call(null,inst_47641);
var state_47825__$1 = (function (){var statearr_47879 = state_47825;
(statearr_47879[(21)] = inst_47642);

return statearr_47879;
})();
if(cljs.core.truth_(inst_47637)){
var statearr_47880_47960 = state_47825__$1;
(statearr_47880_47960[(1)] = (3));

} else {
var statearr_47881_47961 = state_47825__$1;
(statearr_47881_47961[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (23))){
var inst_47717 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47882_47962 = state_47825__$1;
(statearr_47882_47962[(2)] = inst_47717);

(statearr_47882_47962[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (47))){
var inst_47767 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47883_47963 = state_47825__$1;
(statearr_47883_47963[(2)] = inst_47767);

(statearr_47883_47963[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (35))){
var inst_47749 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
if(cljs.core.truth_(inst_47749)){
var statearr_47884_47964 = state_47825__$1;
(statearr_47884_47964[(1)] = (39));

} else {
var statearr_47885_47965 = state_47825__$1;
(statearr_47885_47965[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (19))){
var inst_47638 = (state_47825[(16)]);
var inst_47692 = cljs.core.sequential_QMARK_.call(null,inst_47638);
var state_47825__$1 = state_47825;
if(inst_47692){
var statearr_47886_47966 = state_47825__$1;
(statearr_47886_47966[(1)] = (21));

} else {
var statearr_47887_47967 = state_47825__$1;
(statearr_47887_47967[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (57))){
var inst_47807 = (state_47825[(19)]);
var state_47825__$1 = state_47825;
var statearr_47888_47968 = state_47825__$1;
(statearr_47888_47968[(2)] = inst_47807);

(statearr_47888_47968[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (11))){
var state_47825__$1 = state_47825;
var statearr_47889_47969 = state_47825__$1;
(statearr_47889_47969[(2)] = (-1));

(statearr_47889_47969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (9))){
var inst_47664 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
if(cljs.core.truth_(inst_47664)){
var statearr_47890_47970 = state_47825__$1;
(statearr_47890_47970[(1)] = (10));

} else {
var statearr_47891_47971 = state_47825__$1;
(statearr_47891_47971[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (5))){
var inst_47651 = (state_47825[(7)]);
var inst_47650 = (state_47825[(2)]);
var inst_47651__$1 = cljs.core.nth.call(null,inst_47650,(0),null);
var inst_47652 = cljs.core.nth.call(null,inst_47650,(1),null);
var inst_47659 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_47825__$1 = (function (){var statearr_47892 = state_47825;
(statearr_47892[(7)] = inst_47651__$1);

(statearr_47892[(13)] = inst_47659);

(statearr_47892[(27)] = inst_47652);

return statearr_47892;
})();
if(cljs.core.truth_(inst_47651__$1)){
var statearr_47893_47972 = state_47825__$1;
(statearr_47893_47972[(1)] = (7));

} else {
var statearr_47894_47973 = state_47825__$1;
(statearr_47894_47973[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (14))){
var inst_47642 = (state_47825[(21)]);
var inst_47652 = (state_47825[(27)]);
var inst_47677 = fluree.db.time_travel.as_of_block.call(null,inst_47642,inst_47652);
var state_47825__$1 = state_47825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47825__$1,(17),inst_47677);
} else {
if((state_val_47826 === (45))){
var inst_47729 = (state_47825[(12)]);
var inst_47763 = (inst_47729 == null);
var inst_47764 = cljs.core.not.call(null,inst_47763);
var state_47825__$1 = state_47825;
var statearr_47895_47974 = state_47825__$1;
(statearr_47895_47974[(2)] = inst_47764);

(statearr_47895_47974[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (53))){
var inst_47788 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47896_47975 = state_47825__$1;
(statearr_47896_47975[(2)] = inst_47788);

(statearr_47896_47975[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (26))){
var inst_47704 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47897_47976 = state_47825__$1;
(statearr_47897_47976[(2)] = inst_47704);

(statearr_47897_47976[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (16))){
var inst_47638 = (state_47825[(16)]);
var inst_47685 = (state_47825[(2)]);
var inst_47686 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_47638);
var state_47825__$1 = (function (){var statearr_47898 = state_47825;
(statearr_47898[(23)] = inst_47685);

return statearr_47898;
})();
if(inst_47686){
var statearr_47899_47977 = state_47825__$1;
(statearr_47899_47977[(1)] = (18));

} else {
var statearr_47900_47978 = state_47825__$1;
(statearr_47900_47978[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (38))){
var inst_47746 = (state_47825[(2)]);
var state_47825__$1 = state_47825;
var statearr_47901_47979 = state_47825__$1;
(statearr_47901_47979[(2)] = inst_47746);

(statearr_47901_47979[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (30))){
var inst_47719 = (state_47825[(9)]);
var inst_47734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47735 = [inst_47719,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_47736 = (new cljs.core.PersistentVector(null,2,(5),inst_47734,inst_47735,null));
var state_47825__$1 = state_47825;
var statearr_47902_47980 = state_47825__$1;
(statearr_47902_47980[(2)] = inst_47736);

(statearr_47902_47980[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (10))){
var inst_47651 = (state_47825[(7)]);
var inst_47642 = (state_47825[(21)]);
var inst_47666 = (inst_47651 - (1));
var inst_47667 = fluree.db.time_travel.as_of_block.call(null,inst_47642,inst_47666);
var state_47825__$1 = state_47825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47825__$1,(13),inst_47667);
} else {
if((state_val_47826 === (18))){
var inst_47638 = (state_47825[(16)]);
var inst_47688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47689 = [inst_47638];
var inst_47690 = (new cljs.core.PersistentVector(null,1,(5),inst_47688,inst_47689,null));
var state_47825__$1 = state_47825;
var statearr_47903_47981 = state_47825__$1;
(statearr_47903_47981[(2)] = inst_47690);

(statearr_47903_47981[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (52))){
var state_47825__$1 = state_47825;
var statearr_47904_47982 = state_47825__$1;
(statearr_47904_47982[(2)] = null);

(statearr_47904_47982[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (42))){
var inst_47761 = (state_47825[(20)]);
var inst_47728 = (state_47825[(10)]);
var inst_47760 = (inst_47728 == null);
var inst_47761__$1 = cljs.core.not.call(null,inst_47760);
var state_47825__$1 = (function (){var statearr_47905 = state_47825;
(statearr_47905[(20)] = inst_47761__$1);

return statearr_47905;
})();
if(inst_47761__$1){
var statearr_47906_47983 = state_47825__$1;
(statearr_47906_47983[(1)] = (45));

} else {
var statearr_47907_47984 = state_47825__$1;
(statearr_47907_47984[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (37))){
var inst_47741 = (state_47825[(26)]);
var state_47825__$1 = state_47825;
var statearr_47908_47985 = state_47825__$1;
(statearr_47908_47985[(2)] = inst_47741);

(statearr_47908_47985[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (8))){
var inst_47651 = (state_47825[(7)]);
var state_47825__$1 = state_47825;
var statearr_47909_47986 = state_47825__$1;
(statearr_47909_47986[(2)] = inst_47651);

(statearr_47909_47986[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47826 === (49))){
var state_47825__$1 = state_47825;
var statearr_47910_47987 = state_47825__$1;
(statearr_47910_47987[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_47912 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47912[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_47912[(1)] = (1));

return statearr_47912;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_47825){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_47825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e47913){var ex__2724__auto__ = e47913;
var statearr_47914_47988 = state_47825;
(statearr_47914_47988[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_47825[(4)]))){
var statearr_47915_47989 = state_47825;
(statearr_47915_47989[(1)] = cljs.core.first.call(null,(state_47825[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47990 = state_47825;
state_47825 = G__47990;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_47825){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_47825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_47916 = f__2744__auto__.call(null);
(statearr_47916[(6)] = c__2743__auto__);

return statearr_47916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__47998 = arguments.length;
switch (G__47998) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__47991_SHARP_){
return cljs.core.dissoc.call(null,p1__47991_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48087){
var state_val_48088 = (state_48087[(1)]);
if((state_val_48088 === (7))){
var inst_48044 = (state_48087[(7)]);
var inst_48041 = (state_48087[(8)]);
var inst_48048 = (state_48087[(9)]);
var inst_48038 = (state_48087[(10)]);
var inst_48054 = (function (){var responses = inst_48038;
var responses_STAR_ = inst_48041;
var statuses = inst_48044;
var fuel = inst_48048;
return (function (p1__47994_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__47994_SHARP_);
});
})();
var inst_48055 = cljs.core.some.call(null,inst_48054,inst_48044);
var state_48087__$1 = state_48087;
if(cljs.core.truth_(inst_48055)){
var statearr_48089_48137 = state_48087__$1;
(statearr_48089_48137[(1)] = (9));

} else {
var statearr_48090_48138 = state_48087__$1;
(statearr_48090_48138[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (20))){
var inst_48082 = (state_48087[(2)]);
var state_48087__$1 = state_48087;
var statearr_48091_48139 = state_48087__$1;
(statearr_48091_48139[(2)] = inst_48082);

(statearr_48091_48139[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (1))){
var inst_48033 = cljs.core.async.chan.call(null,(1));
var inst_48034 = (function (){var c__2743__auto____$1 = inst_48033;
return (function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48031){
var state_val_48032 = (state_48031[(1)]);
if((state_val_48032 === (1))){
var inst_47999 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_48000 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_48001 = cljs.core.assoc.call(null,inst_48000,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_48002 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_48003 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_48004 = cljs.core.PersistentHashMap.EMPTY;
var inst_48005 = inst_47999;
var inst_48006 = inst_48001;
var inst_48007 = inst_48002;
var inst_48008 = inst_48003;
var inst_48009 = inst_48004;
var state_48031__$1 = (function (){var statearr_48092 = state_48031;
(statearr_48092[(7)] = inst_48006);

(statearr_48092[(8)] = inst_48005);

(statearr_48092[(9)] = inst_48008);

(statearr_48092[(10)] = inst_48007);

(statearr_48092[(11)] = inst_48009);

return statearr_48092;
})();
var statearr_48093_48140 = state_48031__$1;
(statearr_48093_48140[(2)] = null);

(statearr_48093_48140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48032 === (2))){
var inst_48006 = (state_48031[(7)]);
var inst_48011 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_48006);
var inst_48012 = cljs.core.merge.call(null,opts,inst_48011);
var inst_48013 = cljs.core.assoc.call(null,inst_48006,new cljs.core.Keyword(null,"opts","opts",155075701),inst_48012);
var inst_48014 = fluree.db.api_js.query_async.call(null,db,inst_48013,db_fn);
var state_48031__$1 = state_48031;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48031__$1,(4),inst_48014);
} else {
if((state_val_48032 === (3))){
var inst_48029 = (state_48031[(2)]);
var state_48031__$1 = state_48031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48031__$1,inst_48029);
} else {
if((state_val_48032 === (4))){
var inst_48005 = (state_48031[(8)]);
var inst_48007 = (state_48031[(10)]);
var inst_48009 = (state_48031[(11)]);
var inst_48016 = (state_48031[(2)]);
var inst_48017 = cljs.core.assoc.call(null,inst_48009,inst_48005,inst_48016);
var inst_48018 = cljs.core.first.call(null,inst_48007);
var state_48031__$1 = (function (){var statearr_48094 = state_48031;
(statearr_48094[(12)] = inst_48017);

return statearr_48094;
})();
if(cljs.core.truth_(inst_48018)){
var statearr_48095_48141 = state_48031__$1;
(statearr_48095_48141[(1)] = (5));

} else {
var statearr_48096_48142 = state_48031__$1;
(statearr_48096_48142[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48032 === (5))){
var inst_48017 = (state_48031[(12)]);
var inst_48008 = (state_48031[(9)]);
var inst_48007 = (state_48031[(10)]);
var inst_48020 = cljs.core.first.call(null,inst_48007);
var inst_48021 = cljs.core.first.call(null,inst_48008);
var inst_48022 = cljs.core.rest.call(null,inst_48007);
var inst_48023 = cljs.core.rest.call(null,inst_48008);
var inst_48005 = inst_48020;
var inst_48006 = inst_48021;
var inst_48007__$1 = inst_48022;
var inst_48008__$1 = inst_48023;
var inst_48009 = inst_48017;
var state_48031__$1 = (function (){var statearr_48097 = state_48031;
(statearr_48097[(7)] = inst_48006);

(statearr_48097[(8)] = inst_48005);

(statearr_48097[(9)] = inst_48008__$1);

(statearr_48097[(10)] = inst_48007__$1);

(statearr_48097[(11)] = inst_48009);

return statearr_48097;
})();
var statearr_48098_48143 = state_48031__$1;
(statearr_48098_48143[(2)] = null);

(statearr_48098_48143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48032 === (6))){
var inst_48017 = (state_48031[(12)]);
var state_48031__$1 = state_48031;
var statearr_48099_48144 = state_48031__$1;
(statearr_48099_48144[(2)] = inst_48017);

(statearr_48099_48144[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48032 === (7))){
var inst_48027 = (state_48031[(2)]);
var state_48031__$1 = state_48031;
var statearr_48100_48145 = state_48031__$1;
(statearr_48100_48145[(2)] = inst_48027);

(statearr_48100_48145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_48101 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48101[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_48101[(1)] = (1));

return statearr_48101;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_48031){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48102){var ex__2724__auto__ = e48102;
var statearr_48103_48146 = state_48031;
(statearr_48103_48146[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48031[(4)]))){
var statearr_48104_48147 = state_48031;
(statearr_48104_48147[(1)] = cljs.core.first.call(null,(state_48031[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48148 = state_48031;
state_48031 = G__48148;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_48031){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_48031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48105 = f__2744__auto__.call(null);
(statearr_48105[(6)] = c__2743__auto____$1);

return statearr_48105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
});
})();
var inst_48035 = cljs.core.async.impl.dispatch.run.call(null,inst_48034);
var state_48087__$1 = (function (){var statearr_48106 = state_48087;
(statearr_48106[(11)] = inst_48035);

return statearr_48106;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48087__$1,(2),inst_48033);
} else {
if((state_val_48088 === (4))){
var inst_48038 = (state_48087[(10)]);
var state_48087__$1 = state_48087;
var statearr_48107_48149 = state_48087__$1;
(statearr_48107_48149[(2)] = inst_48038);

(statearr_48107_48149[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (15))){
var state_48087__$1 = state_48087;
var statearr_48108_48150 = state_48087__$1;
(statearr_48108_48150[(2)] = (400));

(statearr_48108_48150[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (13))){
var state_48087__$1 = state_48087;
var statearr_48109_48151 = state_48087__$1;
(statearr_48109_48151[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (6))){
var inst_48044 = (state_48087[(7)]);
var inst_48052 = cljs.core.first.call(null,inst_48044);
var state_48087__$1 = state_48087;
var statearr_48111_48152 = state_48087__$1;
(statearr_48111_48152[(2)] = inst_48052);

(statearr_48111_48152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (17))){
var inst_48065 = (state_48087[(2)]);
var state_48087__$1 = state_48087;
var statearr_48112_48153 = state_48087__$1;
(statearr_48112_48153[(2)] = inst_48065);

(statearr_48112_48153[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (3))){
var inst_48044 = (state_48087[(7)]);
var inst_48041 = (state_48087[(8)]);
var inst_48048 = (state_48087[(9)]);
var inst_48038 = (state_48087[(10)]);
var inst_48043 = cljs.core.vals.call(null,inst_48038);
var inst_48044__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_48043);
var inst_48045 = (function (){var responses = inst_48038;
var responses_STAR_ = inst_48041;
var statuses = inst_48044__$1;
return (function (p1__47992_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__47992_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_48046 = cljs.core.vals.call(null,inst_48038);
var inst_48047 = cljs.core.map.call(null,inst_48045,inst_48046);
var inst_48048__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_48047);
var inst_48049 = (function (){var responses = inst_48038;
var responses_STAR_ = inst_48041;
var statuses = inst_48044__$1;
var fuel = inst_48048__$1;
return (function (p1__47993_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__47993_SHARP_);
});
})();
var inst_48050 = cljs.core.every_QMARK_.call(null,inst_48049,inst_48044__$1);
var state_48087__$1 = (function (){var statearr_48113 = state_48087;
(statearr_48113[(7)] = inst_48044__$1);

(statearr_48113[(9)] = inst_48048__$1);

return statearr_48113;
})();
if(inst_48050){
var statearr_48114_48154 = state_48087__$1;
(statearr_48114_48154[(1)] = (6));

} else {
var statearr_48115_48155 = state_48087__$1;
(statearr_48115_48155[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (12))){
var state_48087__$1 = state_48087;
var statearr_48116_48156 = state_48087__$1;
(statearr_48116_48156[(2)] = (500));

(statearr_48116_48156[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (2))){
var inst_48038 = (state_48087[(10)]);
var inst_48037 = (state_48087[(2)]);
var inst_48038__$1 = fluree.db.util.async.throw_err.call(null,inst_48037);
var inst_48039 = (function (){var responses = inst_48038__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_48040 = cljs.core.PersistentHashMap.EMPTY;
var inst_48041 = cljs.core.reduce_kv.call(null,inst_48039,inst_48040,inst_48038__$1);
var state_48087__$1 = (function (){var statearr_48117 = state_48087;
(statearr_48117[(8)] = inst_48041);

(statearr_48117[(10)] = inst_48038__$1);

return statearr_48117;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_48118_48157 = state_48087__$1;
(statearr_48118_48157[(1)] = (3));

} else {
var statearr_48119_48158 = state_48087__$1;
(statearr_48119_48158[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (19))){
var inst_48071 = (state_48087[(12)]);
var inst_48041 = (state_48087[(8)]);
var inst_48048 = (state_48087[(9)]);
var inst_48080 = cljs.core.assoc.call(null,inst_48041,new cljs.core.Keyword(null,"status","status",-1997798413),inst_48071,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_48048);
var state_48087__$1 = state_48087;
var statearr_48120_48159 = state_48087__$1;
(statearr_48120_48159[(2)] = inst_48080);

(statearr_48120_48159[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (11))){
var inst_48069 = (state_48087[(2)]);
var state_48087__$1 = state_48087;
var statearr_48121_48160 = state_48087__$1;
(statearr_48121_48160[(2)] = inst_48069);

(statearr_48121_48160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (9))){
var state_48087__$1 = state_48087;
var statearr_48122_48161 = state_48087__$1;
(statearr_48122_48161[(2)] = (207));

(statearr_48122_48161[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (5))){
var inst_48085 = (state_48087[(2)]);
var state_48087__$1 = state_48087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48087__$1,inst_48085);
} else {
if((state_val_48088 === (14))){
var inst_48067 = (state_48087[(2)]);
var state_48087__$1 = state_48087;
var statearr_48123_48162 = state_48087__$1;
(statearr_48123_48162[(2)] = inst_48067);

(statearr_48123_48162[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (16))){
var state_48087__$1 = state_48087;
var statearr_48124_48163 = state_48087__$1;
(statearr_48124_48163[(2)] = null);

(statearr_48124_48163[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (10))){
var inst_48044 = (state_48087[(7)]);
var inst_48041 = (state_48087[(8)]);
var inst_48048 = (state_48087[(9)]);
var inst_48038 = (state_48087[(10)]);
var inst_48058 = (function (){var responses = inst_48038;
var responses_STAR_ = inst_48041;
var statuses = inst_48044;
var fuel = inst_48048;
return (function (p1__47995_SHARP_){
return ((499) < p1__47995_SHARP_);
});
})();
var inst_48059 = cljs.core.some.call(null,inst_48058,inst_48044);
var state_48087__$1 = state_48087;
if(cljs.core.truth_(inst_48059)){
var statearr_48125_48164 = state_48087__$1;
(statearr_48125_48164[(1)] = (12));

} else {
var statearr_48126_48165 = state_48087__$1;
(statearr_48126_48165[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (18))){
var inst_48071 = (state_48087[(12)]);
var inst_48041 = (state_48087[(8)]);
var inst_48048 = (state_48087[(9)]);
var inst_48076 = (state_48087[(13)]);
var inst_48078 = cljs.core.assoc.call(null,inst_48041,new cljs.core.Keyword(null,"status","status",-1997798413),inst_48071,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_48048,new cljs.core.Keyword(null,"block","block",664686210),inst_48076);
var state_48087__$1 = state_48087;
var statearr_48127_48166 = state_48087__$1;
(statearr_48127_48166[(2)] = inst_48078);

(statearr_48127_48166[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48088 === (8))){
var inst_48071 = (state_48087[(12)]);
var inst_48044 = (state_48087[(7)]);
var inst_48041 = (state_48087[(8)]);
var inst_48048 = (state_48087[(9)]);
var inst_48038 = (state_48087[(10)]);
var inst_48076 = (state_48087[(13)]);
var inst_48071__$1 = (state_48087[(2)]);
var inst_48072 = (function (){var responses = inst_48038;
var responses_STAR_ = inst_48041;
var statuses = inst_48044;
var fuel = inst_48048;
var status = inst_48071__$1;
return (function (p1__47996_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__47996_SHARP_));
});
})();
var inst_48073 = cljs.core.vals.call(null,inst_48038);
var inst_48074 = cljs.core.filter.call(null,inst_48072,inst_48073);
var inst_48075 = cljs.core.first.call(null,inst_48074);
var inst_48076__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_48075);
var state_48087__$1 = (function (){var statearr_48128 = state_48087;
(statearr_48128[(12)] = inst_48071__$1);

(statearr_48128[(13)] = inst_48076__$1);

return statearr_48128;
})();
if(cljs.core.truth_(inst_48076__$1)){
var statearr_48129_48167 = state_48087__$1;
(statearr_48129_48167[(1)] = (18));

} else {
var statearr_48130_48168 = state_48087__$1;
(statearr_48130_48168[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_48131 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48131[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_48131[(1)] = (1));

return statearr_48131;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_48087){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48132){var ex__2724__auto__ = e48132;
var statearr_48133_48169 = state_48087;
(statearr_48133_48169[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48087[(4)]))){
var statearr_48134_48170 = state_48087;
(statearr_48134_48170[(1)] = cljs.core.first.call(null,(state_48087[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48171 = state_48087;
state_48087 = G__48171;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_48087){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_48087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48135 = f__2744__auto__.call(null);
(statearr_48135[(6)] = c__2743__auto__);

return statearr_48135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__48173 = arguments.length;
switch (G__48173) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__48174 = opts;
var map__48174__$1 = cljs.core.__destructure_map.call(null,map__48174);
var auth = cljs.core.get.call(null,map__48174__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__48174__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__48174__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__48174__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__48175 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__48175,(0),null);
var authority = cljs.core.nth.call(null,vec__48175,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e48178){var e = e48178;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__48181 = arguments.length;
switch (G__48181) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_48212){
var state_val_48213 = (state_48212[(1)]);
if((state_val_48213 === (7))){
var state_48212__$1 = state_48212;
var statearr_48214_48235 = state_48212__$1;
(statearr_48214_48235[(2)] = opts);

(statearr_48214_48235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48213 === (1))){
var state_48212__$1 = state_48212;
var statearr_48215_48236 = state_48212__$1;
(statearr_48215_48236[(2)] = null);

(statearr_48215_48236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48213 === (4))){
var inst_48182 = (state_48212[(2)]);
var inst_48183 = fluree.db.util.log.error.call(null,inst_48182);
var inst_48184 = cljs.core.ex_data.call(null,inst_48182);
var inst_48185 = cljs.core.ex_message.call(null,inst_48182);
var inst_48186 = cljs.core.assoc.call(null,inst_48184,new cljs.core.Keyword(null,"message","message",-406056002),inst_48185);
var state_48212__$1 = (function (){var statearr_48216 = state_48212;
(statearr_48216[(7)] = inst_48183);

return statearr_48216;
})();
var statearr_48217_48237 = state_48212__$1;
(statearr_48217_48237[(2)] = inst_48186);

(statearr_48217_48237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48213 === (6))){
var inst_48196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48197 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_48198 = (new cljs.core.PersistentVector(null,1,(5),inst_48196,inst_48197,null));
var inst_48199 = cljs.core.assoc_in.call(null,opts,inst_48198,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_48212__$1 = state_48212;
var statearr_48218_48238 = state_48212__$1;
(statearr_48218_48238[(2)] = inst_48199);

(statearr_48218_48238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48213 === (3))){
var inst_48210 = (state_48212[(2)]);
var state_48212__$1 = state_48212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48212__$1,inst_48210);
} else {
if((state_val_48213 === (2))){
var _ = (function (){var statearr_48220 = state_48212;
(statearr_48220[(4)] = cljs.core.cons.call(null,(5),(state_48212[(4)])));

return statearr_48220;
})();
var inst_48192 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_48193 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_48194 = (inst_48193 == null);
var state_48212__$1 = (function (){var statearr_48221 = state_48212;
(statearr_48221[(8)] = inst_48192);

return statearr_48221;
})();
if(cljs.core.truth_(inst_48194)){
var statearr_48222_48239 = state_48212__$1;
(statearr_48222_48239[(1)] = (6));

} else {
var statearr_48223_48240 = state_48212__$1;
(statearr_48223_48240[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48213 === (9))){
var inst_48206 = (state_48212[(2)]);
var inst_48207 = fluree.db.util.async.throw_err.call(null,inst_48206);
var _ = (function (){var statearr_48224 = state_48212;
(statearr_48224[(4)] = cljs.core.rest.call(null,(state_48212[(4)])));

return statearr_48224;
})();
var state_48212__$1 = state_48212;
var statearr_48225_48241 = state_48212__$1;
(statearr_48225_48241[(2)] = inst_48207);

(statearr_48225_48241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48213 === (5))){
var _ = (function (){var statearr_48226 = state_48212;
(statearr_48226[(4)] = cljs.core.rest.call(null,(state_48212[(4)])));

return statearr_48226;
})();
var state_48212__$1 = state_48212;
var ex48219 = (state_48212__$1[(2)]);
var statearr_48227_48242 = state_48212__$1;
(statearr_48227_48242[(5)] = ex48219);


var statearr_48228_48243 = state_48212__$1;
(statearr_48228_48243[(1)] = (4));

(statearr_48228_48243[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48213 === (8))){
var inst_48192 = (state_48212[(8)]);
var inst_48202 = (state_48212[(2)]);
var inst_48203 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_48192,inst_48202);
var inst_48204 = fluree.db.operations.command_async.call(null,conn,inst_48203);
var state_48212__$1 = state_48212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48212__$1,(9),inst_48204);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2721__auto__ = null;
var fluree$db$api_js$state_machine__2721__auto____0 = (function (){
var statearr_48229 = [null,null,null,null,null,null,null,null,null];
(statearr_48229[(0)] = fluree$db$api_js$state_machine__2721__auto__);

(statearr_48229[(1)] = (1));

return statearr_48229;
});
var fluree$db$api_js$state_machine__2721__auto____1 = (function (state_48212){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_48212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e48230){var ex__2724__auto__ = e48230;
var statearr_48231_48244 = state_48212;
(statearr_48231_48244[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_48212[(4)]))){
var statearr_48232_48245 = state_48212;
(statearr_48232_48245[(1)] = cljs.core.first.call(null,(state_48212[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48246 = state_48212;
state_48212 = G__48246;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2721__auto__ = function(state_48212){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2721__auto____1.call(this,state_48212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2721__auto____0;
fluree$db$api_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2721__auto____1;
return fluree$db$api_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_48233 = f__2744__auto__.call(null);
(statearr_48233[(6)] = c__2743__auto__);

return statearr_48233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

