// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__45769 = arguments.length;
switch (G__45769) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45811){
var state_val_45812 = (state_45811[(1)]);
if((state_val_45812 === (7))){
var inst_45781 = typeof user === 'string';
var state_45811__$1 = state_45811;
if(cljs.core.truth_(inst_45781)){
var statearr_45813_45842 = state_45811__$1;
(statearr_45813_45842[(1)] = (9));

} else {
var statearr_45814_45843 = state_45811__$1;
(statearr_45814_45843[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (1))){
var state_45811__$1 = state_45811;
var statearr_45815_45844 = state_45811__$1;
(statearr_45815_45844[(2)] = null);

(statearr_45815_45844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (4))){
var inst_45770 = (state_45811[(2)]);
var inst_45771 = fluree.db.util.log.error.call(null,inst_45770);
var inst_45772 = reject.call(null,inst_45770);
var state_45811__$1 = (function (){var statearr_45816 = state_45811;
(statearr_45816[(7)] = inst_45771);

return statearr_45816;
})();
var statearr_45817_45845 = state_45811__$1;
(statearr_45817_45845[(2)] = inst_45772);

(statearr_45817_45845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (15))){
var inst_45800 = (state_45811[(2)]);
var inst_45801 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_45800);
var inst_45802 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45803 = cljs.core.constantly.call(null,inst_45801);
var inst_45804 = cljs.core.swap_BANG_.call(null,inst_45802,inst_45803);
var inst_45805 = fluree.db.connection.add_token.call(null,conn,inst_45801);
var inst_45806 = resolve.call(null,inst_45800);
var _ = (function (){var statearr_45818 = state_45811;
(statearr_45818[(4)] = cljs.core.rest.call(null,(state_45811[(4)])));

return statearr_45818;
})();
var state_45811__$1 = (function (){var statearr_45819 = state_45811;
(statearr_45819[(8)] = inst_45805);

(statearr_45819[(9)] = inst_45804);

return statearr_45819;
})();
var statearr_45820_45846 = state_45811__$1;
(statearr_45820_45846[(2)] = inst_45806);

(statearr_45820_45846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (13))){
var state_45811__$1 = state_45811;
var statearr_45821_45847 = state_45811__$1;
(statearr_45821_45847[(2)] = null);

(statearr_45821_45847[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (6))){
var state_45811__$1 = state_45811;
var statearr_45822_45848 = state_45811__$1;
(statearr_45822_45848[(2)] = user);

(statearr_45822_45848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (3))){
var inst_45809 = (state_45811[(2)]);
var state_45811__$1 = state_45811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45811__$1,inst_45809);
} else {
if((state_val_45812 === (12))){
var state_45811__$1 = state_45811;
var statearr_45823_45849 = state_45811__$1;
(statearr_45823_45849[(2)] = user);

(statearr_45823_45849[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (2))){
var _ = (function (){var statearr_45824 = state_45811;
(statearr_45824[(4)] = cljs.core.cons.call(null,(5),(state_45811[(4)])));

return statearr_45824;
})();
var inst_45778 = typeof user === 'number';
var state_45811__$1 = state_45811;
if(cljs.core.truth_(inst_45778)){
var statearr_45825_45850 = state_45811__$1;
(statearr_45825_45850[(1)] = (6));

} else {
var statearr_45826_45851 = state_45811__$1;
(statearr_45826_45851[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (11))){
var inst_45792 = (state_45811[(2)]);
var state_45811__$1 = state_45811;
var statearr_45828_45852 = state_45811__$1;
(statearr_45828_45852[(2)] = inst_45792);

(statearr_45828_45852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (9))){
var inst_45783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45784 = ["_user/username",user];
var inst_45785 = (new cljs.core.PersistentVector(null,2,(5),inst_45783,inst_45784,null));
var state_45811__$1 = state_45811;
var statearr_45829_45853 = state_45811__$1;
(statearr_45829_45853[(2)] = inst_45785);

(statearr_45829_45853[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (5))){
var _ = (function (){var statearr_45830 = state_45811;
(statearr_45830[(4)] = cljs.core.rest.call(null,(state_45811[(4)])));

return statearr_45830;
})();
var state_45811__$1 = state_45811;
var ex45827 = (state_45811__$1[(2)]);
var statearr_45831_45854 = state_45811__$1;
(statearr_45831_45854[(5)] = ex45827);


var statearr_45832_45855 = state_45811__$1;
(statearr_45832_45855[(1)] = (4));

(statearr_45832_45855[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (14))){
var inst_45790 = (state_45811[(2)]);
var state_45811__$1 = state_45811;
var statearr_45833_45856 = state_45811__$1;
(statearr_45833_45856[(2)] = inst_45790);

(statearr_45833_45856[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (10))){
var state_45811__$1 = state_45811;
var statearr_45834_45857 = state_45811__$1;
(statearr_45834_45857[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45812 === (8))){
var inst_45794 = (state_45811[(2)]);
var inst_45795 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_45796 = [account,inst_45794,password,expireSeconds,syncTo];
var inst_45797 = cljs.core.PersistentHashMap.fromArrays(inst_45795,inst_45796);
var inst_45798 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_45797);
var state_45811__$1 = state_45811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45811__$1,(15),inst_45798);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2721__auto__ = null;
var fluree$db$connection_js$state_machine__2721__auto____0 = (function (){
var statearr_45836 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45836[(0)] = fluree$db$connection_js$state_machine__2721__auto__);

(statearr_45836[(1)] = (1));

return statearr_45836;
});
var fluree$db$connection_js$state_machine__2721__auto____1 = (function (state_45811){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45837){var ex__2724__auto__ = e45837;
var statearr_45838_45858 = state_45811;
(statearr_45838_45858[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45811[(4)]))){
var statearr_45839_45859 = state_45811;
(statearr_45839_45859[(1)] = cljs.core.first.call(null,(state_45811[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45860 = state_45811;
state_45811 = G__45860;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2721__auto__ = function(state_45811){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2721__auto____1.call(this,state_45811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2721__auto____0;
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2721__auto____1;
return fluree$db$connection_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45840 = f__2744__auto__.call(null);
(statearr_45840[(6)] = c__2743__auto__);

return statearr_45840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__45862 = arguments.length;
switch (G__45862) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45871){
var state_val_45872 = (state_45871[(1)]);
if((state_val_45872 === (1))){
var inst_45863 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45865 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_45866 = (new cljs.core.PersistentVector(null,4,(5),inst_45864,inst_45865,null));
var inst_45867 = cljs.core.async.put_BANG_.call(null,inst_45863,inst_45866);
var inst_45868 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__45873 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__45874 = null;
var count__45875 = (0);
var i__45876 = (0);
while(true){
if((i__45876 < count__45875)){
var k = cljs.core._nth.call(null,chunk__45874,i__45876);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__45884 = seq__45873;
var G__45885 = chunk__45874;
var G__45886 = count__45875;
var G__45887 = (i__45876 + (1));
seq__45873 = G__45884;
chunk__45874 = G__45885;
count__45875 = G__45886;
i__45876 = G__45887;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__45873);
if(temp__5804__auto__){
var seq__45873__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45873__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__45873__$1);
var G__45888 = cljs.core.chunk_rest.call(null,seq__45873__$1);
var G__45889 = c__5568__auto__;
var G__45890 = cljs.core.count.call(null,c__5568__auto__);
var G__45891 = (0);
seq__45873 = G__45888;
chunk__45874 = G__45889;
count__45875 = G__45890;
i__45876 = G__45891;
continue;
} else {
var k = cljs.core.first.call(null,seq__45873__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__45892 = cljs.core.next.call(null,seq__45873__$1);
var G__45893 = null;
var G__45894 = (0);
var G__45895 = (0);
seq__45873 = G__45892;
chunk__45874 = G__45893;
count__45875 = G__45894;
i__45876 = G__45895;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_45869 = cljs.core.async.take_BANG_.call(null,pc,inst_45868);
var state_45871__$1 = (function (){var statearr_45877 = state_45871;
(statearr_45877[(7)] = inst_45867);

return statearr_45877;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45871__$1,inst_45869);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2721__auto__ = null;
var fluree$db$connection_js$state_machine__2721__auto____0 = (function (){
var statearr_45878 = [null,null,null,null,null,null,null,null];
(statearr_45878[(0)] = fluree$db$connection_js$state_machine__2721__auto__);

(statearr_45878[(1)] = (1));

return statearr_45878;
});
var fluree$db$connection_js$state_machine__2721__auto____1 = (function (state_45871){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45879){var ex__2724__auto__ = e45879;
var statearr_45880_45896 = state_45871;
(statearr_45880_45896[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45871[(4)]))){
var statearr_45881_45897 = state_45871;
(statearr_45881_45897[(1)] = cljs.core.first.call(null,(state_45871[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45898 = state_45871;
state_45871 = G__45898;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2721__auto__ = function(state_45871){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2721__auto____1.call(this,state_45871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2721__auto____0;
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2721__auto____1;
return fluree$db$connection_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45882 = f__2744__auto__.call(null);
(statearr_45882[(6)] = c__2743__auto__);

return statearr_45882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__45900 = arguments.length;
switch (G__45900) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45934){
var state_val_45935 = (state_45934[(1)]);
if((state_val_45935 === (1))){
var state_45934__$1 = state_45934;
var statearr_45936_45957 = state_45934__$1;
(statearr_45936_45957[(2)] = null);

(statearr_45936_45957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45935 === (2))){
var _ = (function (){var statearr_45937 = state_45934;
(statearr_45937[(4)] = cljs.core.cons.call(null,(5),(state_45934[(4)])));

return statearr_45937;
})();
var inst_45909 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_45910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45911 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_45912 = (new cljs.core.PersistentVector(null,1,(5),inst_45910,inst_45911,null));
var inst_45913 = cljs.core.PersistentHashMap.EMPTY;
var inst_45914 = cljs.core.atom.call(null,inst_45913);
var inst_45915 = cljs.core.assoc_in.call(null,inst_45909,inst_45912,inst_45914);
var inst_45916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45917 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_45918 = (new cljs.core.PersistentVector(null,1,(5),inst_45916,inst_45917,null));
var inst_45919 = cljs.core.PersistentHashMap.EMPTY;
var inst_45920 = cljs.core.atom.call(null,inst_45919);
var inst_45921 = cljs.core.assoc_in.call(null,inst_45915,inst_45918,inst_45920);
var inst_45922 = cljs.core.async.promise_chan.call(null);
var inst_45923 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_45921);
var inst_45924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45925 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_45922,null];
var inst_45926 = (new cljs.core.PersistentVector(null,4,(5),inst_45924,inst_45925,null));
var inst_45927 = cljs.core.async.put_BANG_.call(null,inst_45923,inst_45926);
var inst_45928 = (function (){var conn = inst_45921;
var pc = inst_45922;
return (function (x){
if((x == null)){
} else {
var seq__45938_45958 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__45939_45959 = null;
var count__45940_45960 = (0);
var i__45941_45961 = (0);
while(true){
if((i__45941_45961 < count__45940_45960)){
var k_45962 = cljs.core._nth.call(null,chunk__45939_45959,i__45941_45961);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_45962], null),cljs.core.get.call(null,x,k_45962,null));


var G__45963 = seq__45938_45958;
var G__45964 = chunk__45939_45959;
var G__45965 = count__45940_45960;
var G__45966 = (i__45941_45961 + (1));
seq__45938_45958 = G__45963;
chunk__45939_45959 = G__45964;
count__45940_45960 = G__45965;
i__45941_45961 = G__45966;
continue;
} else {
var temp__5804__auto___45967 = cljs.core.seq.call(null,seq__45938_45958);
if(temp__5804__auto___45967){
var seq__45938_45968__$1 = temp__5804__auto___45967;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45938_45968__$1)){
var c__5568__auto___45969 = cljs.core.chunk_first.call(null,seq__45938_45968__$1);
var G__45970 = cljs.core.chunk_rest.call(null,seq__45938_45968__$1);
var G__45971 = c__5568__auto___45969;
var G__45972 = cljs.core.count.call(null,c__5568__auto___45969);
var G__45973 = (0);
seq__45938_45958 = G__45970;
chunk__45939_45959 = G__45971;
count__45940_45960 = G__45972;
i__45941_45961 = G__45973;
continue;
} else {
var k_45974 = cljs.core.first.call(null,seq__45938_45968__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_45974], null),cljs.core.get.call(null,x,k_45974,null));


var G__45975 = cljs.core.next.call(null,seq__45938_45968__$1);
var G__45976 = null;
var G__45977 = (0);
var G__45978 = (0);
seq__45938_45958 = G__45975;
chunk__45939_45959 = G__45976;
count__45940_45960 = G__45977;
i__45941_45961 = G__45978;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_45929 = cljs.core.async.take_BANG_.call(null,inst_45922,inst_45928);
var ___$1 = (function (){var statearr_45942 = state_45934;
(statearr_45942[(4)] = cljs.core.rest.call(null,(state_45934[(4)])));

return statearr_45942;
})();
var state_45934__$1 = (function (){var statearr_45943 = state_45934;
(statearr_45943[(7)] = inst_45927);

return statearr_45943;
})();
var statearr_45944_45979 = state_45934__$1;
(statearr_45944_45979[(2)] = inst_45929);

(statearr_45944_45979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45935 === (3))){
var inst_45932 = (state_45934[(2)]);
var state_45934__$1 = state_45934;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45934__$1,inst_45932);
} else {
if((state_val_45935 === (4))){
var inst_45901 = (state_45934[(2)]);
var inst_45902 = fluree.db.util.log.error.call(null,inst_45901);
var inst_45903 = reject.call(null,inst_45901);
var state_45934__$1 = (function (){var statearr_45946 = state_45934;
(statearr_45946[(8)] = inst_45902);

return statearr_45946;
})();
var statearr_45947_45980 = state_45934__$1;
(statearr_45947_45980[(2)] = inst_45903);

(statearr_45947_45980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45935 === (5))){
var _ = (function (){var statearr_45948 = state_45934;
(statearr_45948[(4)] = cljs.core.rest.call(null,(state_45934[(4)])));

return statearr_45948;
})();
var state_45934__$1 = state_45934;
var ex45945 = (state_45934__$1[(2)]);
var statearr_45949_45981 = state_45934__$1;
(statearr_45949_45981[(5)] = ex45945);


var statearr_45950_45982 = state_45934__$1;
(statearr_45950_45982[(1)] = (4));

(statearr_45950_45982[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2721__auto__ = null;
var fluree$db$connection_js$state_machine__2721__auto____0 = (function (){
var statearr_45951 = [null,null,null,null,null,null,null,null,null];
(statearr_45951[(0)] = fluree$db$connection_js$state_machine__2721__auto__);

(statearr_45951[(1)] = (1));

return statearr_45951;
});
var fluree$db$connection_js$state_machine__2721__auto____1 = (function (state_45934){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45934);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45952){var ex__2724__auto__ = e45952;
var statearr_45953_45983 = state_45934;
(statearr_45953_45983[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45934[(4)]))){
var statearr_45954_45984 = state_45934;
(statearr_45954_45984[(1)] = cljs.core.first.call(null,(state_45934[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45985 = state_45934;
state_45934 = G__45985;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2721__auto__ = function(state_45934){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2721__auto____1.call(this,state_45934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2721__auto____0;
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2721__auto____1;
return fluree$db$connection_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45955 = f__2744__auto__.call(null);
(statearr_45955[(6)] = c__2743__auto__);

return statearr_45955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__45987 = arguments.length;
switch (G__45987) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__45989 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__45989,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__45989,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__45992 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__45992,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__45992,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46045){
var state_val_46046 = (state_46045[(1)]);
if((state_val_46046 === (7))){
var inst_46006 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46007 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_46008 = cljs.core.PersistentHashMap.fromArrays(inst_46006,inst_46007);
var inst_46009 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_46008);
var inst_46010 = (function(){throw inst_46009})();
var state_46045__$1 = state_46045;
var statearr_46047_46076 = state_46045__$1;
(statearr_46047_46076[(2)] = inst_46010);

(statearr_46047_46076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (1))){
var state_46045__$1 = state_46045;
var statearr_46048_46077 = state_46045__$1;
(statearr_46048_46077[(2)] = null);

(statearr_46048_46077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (4))){
var inst_45995 = (state_46045[(2)]);
var inst_45996 = cljs.core.clj__GT_js.call(null,inst_45995);
var inst_45997 = reject.call(null,inst_45996);
var state_46045__$1 = state_46045;
var statearr_46049_46078 = state_46045__$1;
(statearr_46049_46078[(2)] = inst_45997);

(statearr_46049_46078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (13))){
var inst_46024 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46025 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_46026 = cljs.core.PersistentHashMap.fromArrays(inst_46024,inst_46025);
var inst_46027 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_46026);
var inst_46028 = (function(){throw inst_46027})();
var state_46045__$1 = state_46045;
var statearr_46050_46079 = state_46045__$1;
(statearr_46050_46079[(2)] = inst_46028);

(statearr_46050_46079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (6))){
var state_46045__$1 = state_46045;
var statearr_46051_46080 = state_46045__$1;
(statearr_46051_46080[(2)] = null);

(statearr_46051_46080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (3))){
var inst_46043 = (state_46045[(2)]);
var state_46045__$1 = state_46045;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46045__$1,inst_46043);
} else {
if((state_val_46046 === (12))){
var state_46045__$1 = state_46045;
var statearr_46052_46081 = state_46045__$1;
(statearr_46052_46081[(2)] = null);

(statearr_46052_46081[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (2))){
var _ = (function (){var statearr_46053 = state_46045;
(statearr_46053[(4)] = cljs.core.cons.call(null,(5),(state_46045[(4)])));

return statearr_46053;
})();
var inst_46003 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_46045__$1 = state_46045;
if(cljs.core.truth_(inst_46003)){
var statearr_46054_46082 = state_46045__$1;
(statearr_46054_46082[(1)] = (6));

} else {
var statearr_46055_46083 = state_46045__$1;
(statearr_46055_46083[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (11))){
var inst_46021 = (state_46045[(2)]);
var state_46045__$1 = (function (){var statearr_46057 = state_46045;
(statearr_46057[(7)] = inst_46021);

return statearr_46057;
})();
if(cljs.core.truth_(password)){
var statearr_46058_46084 = state_46045__$1;
(statearr_46058_46084[(1)] = (12));

} else {
var statearr_46059_46085 = state_46045__$1;
(statearr_46059_46085[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (9))){
var state_46045__$1 = state_46045;
var statearr_46060_46086 = state_46045__$1;
(statearr_46060_46086[(2)] = null);

(statearr_46060_46086[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (5))){
var _ = (function (){var statearr_46061 = state_46045;
(statearr_46061[(4)] = cljs.core.rest.call(null,(state_46045[(4)])));

return statearr_46061;
})();
var state_46045__$1 = state_46045;
var ex46056 = (state_46045__$1[(2)]);
var statearr_46062_46087 = state_46045__$1;
(statearr_46062_46087[(5)] = ex46056);


var statearr_46063_46088 = state_46045__$1;
(statearr_46063_46088[(1)] = (4));

(statearr_46063_46088[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (14))){
var inst_46030 = (state_46045[(2)]);
var inst_46031 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_46032 = fluree.db.util.core.without_nils.call(null,inst_46031);
var inst_46033 = cljs.core.async.promise_chan.call(null);
var inst_46034 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_46035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46036 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_46032,inst_46033,null];
var inst_46037 = (new cljs.core.PersistentVector(null,4,(5),inst_46035,inst_46036,null));
var inst_46038 = cljs.core.async.put_BANG_.call(null,inst_46034,inst_46037);
var inst_46039 = (function (){var _ = inst_46030;
var data = inst_46032;
var pc = inst_46033;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_46040 = cljs.core.async.take_BANG_.call(null,inst_46033,inst_46039);
var _ = (function (){var statearr_46064 = state_46045;
(statearr_46064[(4)] = cljs.core.rest.call(null,(state_46045[(4)])));

return statearr_46064;
})();
var state_46045__$1 = (function (){var statearr_46065 = state_46045;
(statearr_46065[(8)] = inst_46038);

return statearr_46065;
})();
var statearr_46066_46089 = state_46045__$1;
(statearr_46066_46089[(2)] = inst_46040);

(statearr_46066_46089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (10))){
var inst_46015 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46016 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_46017 = cljs.core.PersistentHashMap.fromArrays(inst_46015,inst_46016);
var inst_46018 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_46017);
var inst_46019 = (function(){throw inst_46018})();
var state_46045__$1 = state_46045;
var statearr_46067_46090 = state_46045__$1;
(statearr_46067_46090[(2)] = inst_46019);

(statearr_46067_46090[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46046 === (8))){
var inst_46012 = (state_46045[(2)]);
var state_46045__$1 = (function (){var statearr_46068 = state_46045;
(statearr_46068[(9)] = inst_46012);

return statearr_46068;
})();
if(cljs.core.truth_(ledger)){
var statearr_46069_46091 = state_46045__$1;
(statearr_46069_46091[(1)] = (9));

} else {
var statearr_46070_46092 = state_46045__$1;
(statearr_46070_46092[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2721__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2721__auto____0 = (function (){
var statearr_46071 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46071[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2721__auto__);

(statearr_46071[(1)] = (1));

return statearr_46071;
});
var fluree$db$connection_js$password_generate_$_state_machine__2721__auto____1 = (function (state_46045){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46072){var ex__2724__auto__ = e46072;
var statearr_46073_46093 = state_46045;
(statearr_46073_46093[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46045[(4)]))){
var statearr_46074_46094 = state_46045;
(statearr_46074_46094[(1)] = cljs.core.first.call(null,(state_46045[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46095 = state_46045;
state_46045 = G__46095;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2721__auto__ = function(state_46045){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2721__auto____1.call(this,state_46045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2721__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2721__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46075 = f__2744__auto__.call(null);
(statearr_46075[(6)] = c__2743__auto__);

return statearr_46075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__46097 = arguments.length;
switch (G__46097) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46164){
var state_val_46165 = (state_46164[(1)]);
if((state_val_46165 === (7))){
var inst_46109 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46110 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_46111 = cljs.core.PersistentHashMap.fromArrays(inst_46109,inst_46110);
var inst_46112 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_46111);
var inst_46113 = (function(){throw inst_46112})();
var state_46164__$1 = state_46164;
var statearr_46166_46205 = state_46164__$1;
(statearr_46166_46205[(2)] = inst_46113);

(statearr_46166_46205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (20))){
var inst_46147 = (state_46164[(2)]);
var inst_46148 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_46149 = [ledger,password,user,auth,expire];
var inst_46150 = cljs.core.PersistentHashMap.fromArrays(inst_46148,inst_46149);
var inst_46151 = fluree.db.util.core.without_nils.call(null,inst_46150);
var inst_46152 = cljs.core.async.promise_chan.call(null);
var inst_46153 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_46154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46155 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_46151,inst_46152,null];
var inst_46156 = (new cljs.core.PersistentVector(null,4,(5),inst_46154,inst_46155,null));
var inst_46157 = cljs.core.async.put_BANG_.call(null,inst_46153,inst_46156);
var inst_46158 = (function (){var _ = inst_46147;
var data = inst_46151;
var pc = inst_46152;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_46159 = cljs.core.async.take_BANG_.call(null,inst_46152,inst_46158);
var _ = (function (){var statearr_46167 = state_46164;
(statearr_46167[(4)] = cljs.core.rest.call(null,(state_46164[(4)])));

return statearr_46167;
})();
var state_46164__$1 = (function (){var statearr_46168 = state_46164;
(statearr_46168[(7)] = inst_46157);

return statearr_46168;
})();
var statearr_46169_46206 = state_46164__$1;
(statearr_46169_46206[(2)] = inst_46159);

(statearr_46169_46206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (1))){
var state_46164__$1 = state_46164;
var statearr_46170_46207 = state_46164__$1;
(statearr_46170_46207[(2)] = null);

(statearr_46170_46207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (4))){
var inst_46098 = (state_46164[(2)]);
var inst_46099 = cljs.core.clj__GT_js.call(null,inst_46098);
var inst_46100 = reject.call(null,inst_46099);
var state_46164__$1 = state_46164;
var statearr_46171_46208 = state_46164__$1;
(statearr_46171_46208[(2)] = inst_46100);

(statearr_46171_46208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (15))){
var inst_46134 = (state_46164[(8)]);
var state_46164__$1 = state_46164;
var statearr_46172_46209 = state_46164__$1;
(statearr_46172_46209[(2)] = inst_46134);

(statearr_46172_46209[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (13))){
var inst_46127 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46128 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_46129 = cljs.core.PersistentHashMap.fromArrays(inst_46127,inst_46128);
var inst_46130 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_46129);
var inst_46131 = (function(){throw inst_46130})();
var state_46164__$1 = state_46164;
var statearr_46173_46210 = state_46164__$1;
(statearr_46173_46210[(2)] = inst_46131);

(statearr_46173_46210[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (6))){
var state_46164__$1 = state_46164;
var statearr_46174_46211 = state_46164__$1;
(statearr_46174_46211[(2)] = null);

(statearr_46174_46211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (17))){
var inst_46138 = (state_46164[(2)]);
var state_46164__$1 = state_46164;
if(cljs.core.truth_(inst_46138)){
var statearr_46175_46212 = state_46164__$1;
(statearr_46175_46212[(1)] = (18));

} else {
var statearr_46176_46213 = state_46164__$1;
(statearr_46176_46213[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (3))){
var inst_46162 = (state_46164[(2)]);
var state_46164__$1 = state_46164;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46164__$1,inst_46162);
} else {
if((state_val_46165 === (12))){
var state_46164__$1 = state_46164;
var statearr_46177_46214 = state_46164__$1;
(statearr_46177_46214[(2)] = null);

(statearr_46177_46214[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (2))){
var _ = (function (){var statearr_46178 = state_46164;
(statearr_46178[(4)] = cljs.core.cons.call(null,(5),(state_46164[(4)])));

return statearr_46178;
})();
var inst_46106 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_46164__$1 = state_46164;
if(cljs.core.truth_(inst_46106)){
var statearr_46179_46215 = state_46164__$1;
(statearr_46179_46215[(1)] = (6));

} else {
var statearr_46180_46216 = state_46164__$1;
(statearr_46180_46216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (19))){
var inst_46141 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46142 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_46143 = cljs.core.PersistentHashMap.fromArrays(inst_46141,inst_46142);
var inst_46144 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_46143);
var inst_46145 = (function(){throw inst_46144})();
var state_46164__$1 = state_46164;
var statearr_46181_46217 = state_46164__$1;
(statearr_46181_46217[(2)] = inst_46145);

(statearr_46181_46217[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (11))){
var inst_46124 = (state_46164[(2)]);
var state_46164__$1 = (function (){var statearr_46183 = state_46164;
(statearr_46183[(9)] = inst_46124);

return statearr_46183;
})();
if(cljs.core.truth_(password)){
var statearr_46184_46218 = state_46164__$1;
(statearr_46184_46218[(1)] = (12));

} else {
var statearr_46185_46219 = state_46164__$1;
(statearr_46185_46219[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (9))){
var state_46164__$1 = state_46164;
var statearr_46186_46220 = state_46164__$1;
(statearr_46186_46220[(2)] = null);

(statearr_46186_46220[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (5))){
var _ = (function (){var statearr_46187 = state_46164;
(statearr_46187[(4)] = cljs.core.rest.call(null,(state_46164[(4)])));

return statearr_46187;
})();
var state_46164__$1 = state_46164;
var ex46182 = (state_46164__$1[(2)]);
var statearr_46188_46221 = state_46164__$1;
(statearr_46188_46221[(5)] = ex46182);


var statearr_46189_46222 = state_46164__$1;
(statearr_46189_46222[(1)] = (4));

(statearr_46189_46222[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (14))){
var inst_46134 = (state_46164[(8)]);
var inst_46133 = (state_46164[(2)]);
var inst_46134__$1 = user;
var state_46164__$1 = (function (){var statearr_46190 = state_46164;
(statearr_46190[(10)] = inst_46133);

(statearr_46190[(8)] = inst_46134__$1);

return statearr_46190;
})();
if(cljs.core.truth_(inst_46134__$1)){
var statearr_46191_46223 = state_46164__$1;
(statearr_46191_46223[(1)] = (15));

} else {
var statearr_46192_46224 = state_46164__$1;
(statearr_46192_46224[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (16))){
var state_46164__$1 = state_46164;
var statearr_46193_46225 = state_46164__$1;
(statearr_46193_46225[(2)] = auth);

(statearr_46193_46225[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (10))){
var inst_46118 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46119 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_46120 = cljs.core.PersistentHashMap.fromArrays(inst_46118,inst_46119);
var inst_46121 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_46120);
var inst_46122 = (function(){throw inst_46121})();
var state_46164__$1 = state_46164;
var statearr_46194_46226 = state_46164__$1;
(statearr_46194_46226[(2)] = inst_46122);

(statearr_46194_46226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (18))){
var state_46164__$1 = state_46164;
var statearr_46195_46227 = state_46164__$1;
(statearr_46195_46227[(2)] = null);

(statearr_46195_46227[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46165 === (8))){
var inst_46115 = (state_46164[(2)]);
var state_46164__$1 = (function (){var statearr_46196 = state_46164;
(statearr_46196[(11)] = inst_46115);

return statearr_46196;
})();
if(cljs.core.truth_(ledger)){
var statearr_46197_46228 = state_46164__$1;
(statearr_46197_46228[(1)] = (9));

} else {
var statearr_46198_46229 = state_46164__$1;
(statearr_46198_46229[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2721__auto__ = null;
var fluree$db$connection_js$state_machine__2721__auto____0 = (function (){
var statearr_46199 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46199[(0)] = fluree$db$connection_js$state_machine__2721__auto__);

(statearr_46199[(1)] = (1));

return statearr_46199;
});
var fluree$db$connection_js$state_machine__2721__auto____1 = (function (state_46164){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46200){var ex__2724__auto__ = e46200;
var statearr_46201_46230 = state_46164;
(statearr_46201_46230[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46164[(4)]))){
var statearr_46202_46231 = state_46164;
(statearr_46202_46231[(1)] = cljs.core.first.call(null,(state_46164[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46232 = state_46164;
state_46164 = G__46232;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2721__auto__ = function(state_46164){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2721__auto____1.call(this,state_46164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2721__auto____0;
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2721__auto____1;
return fluree$db$connection_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46203 = f__2744__auto__.call(null);
(statearr_46203[(6)] = c__2743__auto__);

return statearr_46203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__46234 = arguments.length;
switch (G__46234) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_46269){
var state_val_46270 = (state_46269[(1)]);
if((state_val_46270 === (1))){
var state_46269__$1 = state_46269;
var statearr_46271_46291 = state_46269__$1;
(statearr_46271_46291[(2)] = null);

(statearr_46271_46291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46270 === (2))){
var _ = (function (){var statearr_46272 = state_46269;
(statearr_46272[(4)] = cljs.core.cons.call(null,(5),(state_46269[(4)])));

return statearr_46272;
})();
var inst_46243 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_46269__$1 = state_46269;
if(cljs.core.truth_(inst_46243)){
var statearr_46273_46292 = state_46269__$1;
(statearr_46273_46292[(1)] = (6));

} else {
var statearr_46274_46293 = state_46269__$1;
(statearr_46274_46293[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46270 === (3))){
var inst_46267 = (state_46269[(2)]);
var state_46269__$1 = state_46269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46269__$1,inst_46267);
} else {
if((state_val_46270 === (4))){
var inst_46235 = (state_46269[(2)]);
var inst_46236 = cljs.core.clj__GT_js.call(null,inst_46235);
var inst_46237 = reject.call(null,inst_46236);
var state_46269__$1 = state_46269;
var statearr_46276_46294 = state_46269__$1;
(statearr_46276_46294[(2)] = inst_46237);

(statearr_46276_46294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46270 === (5))){
var _ = (function (){var statearr_46277 = state_46269;
(statearr_46277[(4)] = cljs.core.rest.call(null,(state_46269[(4)])));

return statearr_46277;
})();
var state_46269__$1 = state_46269;
var ex46275 = (state_46269__$1[(2)]);
var statearr_46278_46295 = state_46269__$1;
(statearr_46278_46295[(5)] = ex46275);


var statearr_46279_46296 = state_46269__$1;
(statearr_46279_46296[(1)] = (4));

(statearr_46279_46296[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46270 === (6))){
var state_46269__$1 = state_46269;
var statearr_46280_46297 = state_46269__$1;
(statearr_46280_46297[(2)] = null);

(statearr_46280_46297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46270 === (7))){
var inst_46246 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46247 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_46248 = cljs.core.PersistentHashMap.fromArrays(inst_46246,inst_46247);
var inst_46249 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_46248);
var inst_46250 = (function(){throw inst_46249})();
var state_46269__$1 = state_46269;
var statearr_46281_46298 = state_46269__$1;
(statearr_46281_46298[(2)] = inst_46250);

(statearr_46281_46298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46270 === (8))){
var inst_46252 = (state_46269[(2)]);
var inst_46253 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_46254 = [jwt,expire];
var inst_46255 = cljs.core.PersistentHashMap.fromArrays(inst_46253,inst_46254);
var inst_46256 = fluree.db.util.core.without_nils.call(null,inst_46255);
var inst_46257 = cljs.core.async.promise_chan.call(null);
var inst_46258 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_46259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46260 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_46256,inst_46257,null];
var inst_46261 = (new cljs.core.PersistentVector(null,4,(5),inst_46259,inst_46260,null));
var inst_46262 = cljs.core.async.put_BANG_.call(null,inst_46258,inst_46261);
var inst_46263 = (function (){var _ = inst_46252;
var data = inst_46256;
var pc = inst_46257;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_46264 = cljs.core.async.take_BANG_.call(null,inst_46257,inst_46263);
var _ = (function (){var statearr_46282 = state_46269;
(statearr_46282[(4)] = cljs.core.rest.call(null,(state_46269[(4)])));

return statearr_46282;
})();
var state_46269__$1 = (function (){var statearr_46283 = state_46269;
(statearr_46283[(7)] = inst_46262);

return statearr_46283;
})();
var statearr_46284_46299 = state_46269__$1;
(statearr_46284_46299[(2)] = inst_46264);

(statearr_46284_46299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2721__auto__ = null;
var fluree$db$connection_js$state_machine__2721__auto____0 = (function (){
var statearr_46285 = [null,null,null,null,null,null,null,null];
(statearr_46285[(0)] = fluree$db$connection_js$state_machine__2721__auto__);

(statearr_46285[(1)] = (1));

return statearr_46285;
});
var fluree$db$connection_js$state_machine__2721__auto____1 = (function (state_46269){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_46269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e46286){var ex__2724__auto__ = e46286;
var statearr_46287_46300 = state_46269;
(statearr_46287_46300[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_46269[(4)]))){
var statearr_46288_46301 = state_46269;
(statearr_46288_46301[(1)] = cljs.core.first.call(null,(state_46269[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46302 = state_46269;
state_46269 = G__46302;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2721__auto__ = function(state_46269){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2721__auto____1.call(this,state_46269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2721__auto____0;
fluree$db$connection_js$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2721__auto____1;
return fluree$db$connection_js$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_46289 = f__2744__auto__.call(null);
(statearr_46289[(6)] = c__2743__auto__);

return statearr_46289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

