// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29411 = arguments.length;
var i__5770__auto___29412 = (0);
while(true){
if((i__5770__auto___29412 < len__5769__auto___29411)){
args__5775__auto__.push((arguments[i__5770__auto___29412]));

var G__29413 = (i__5770__auto___29412 + (1));
i__5770__auto___29412 = G__29413;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq29408){
var G__29409 = cljs.core.first.call(null,seq29408);
var seq29408__$1 = cljs.core.next.call(null,seq29408);
var G__29410 = cljs.core.first.call(null,seq29408__$1);
var seq29408__$2 = cljs.core.next.call(null,seq29408__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29409,G__29410,seq29408__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e29414){var e = e29414;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e29415){var e = e29415;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e29416){var e = e29416;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e29417){var e = e29417;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e29418){var e = e29418;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29421 = arguments.length;
var i__5770__auto___29422 = (0);
while(true){
if((i__5770__auto___29422 < len__5769__auto___29421)){
args__5775__auto__.push((arguments[i__5770__auto___29422]));

var G__29423 = (i__5770__auto___29422 + (1));
i__5770__auto___29422 = G__29423;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29420){var e = e29420;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq29419){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29419));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29426 = arguments.length;
var i__5770__auto___29427 = (0);
while(true){
if((i__5770__auto___29427 < len__5769__auto___29426)){
args__5775__auto__.push((arguments[i__5770__auto___29427]));

var G__29428 = (i__5770__auto___29427 + (1));
i__5770__auto___29427 = G__29428;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29425){var e = e29425;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq29424){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29424));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e29429){var e = e29429;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29432 = arguments.length;
var i__5770__auto___29433 = (0);
while(true){
if((i__5770__auto___29433 < len__5769__auto___29432)){
args__5775__auto__.push((arguments[i__5770__auto___29433]));

var G__29434 = (i__5770__auto___29433 + (1));
i__5770__auto___29433 = G__29434;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e29431){var e = e29431;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq29430){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29430));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29437 = arguments.length;
var i__5770__auto___29438 = (0);
while(true){
if((i__5770__auto___29438 < len__5769__auto___29437)){
args__5775__auto__.push((arguments[i__5770__auto___29438]));

var G__29439 = (i__5770__auto___29438 + (1));
i__5770__auto___29438 = G__29439;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e29436){var e = e29436;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq29435){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29435));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e29440){var e = e29440;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e29441){var e = e29441;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29444 = arguments.length;
var i__5770__auto___29445 = (0);
while(true){
if((i__5770__auto___29445 < len__5769__auto___29444)){
args__5775__auto__.push((arguments[i__5770__auto___29445]));

var G__29446 = (i__5770__auto___29445 + (1));
i__5770__auto___29445 = G__29446;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29443){var e = e29443;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq29442){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29442));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29449 = arguments.length;
var i__5770__auto___29450 = (0);
while(true){
if((i__5770__auto___29450 < len__5769__auto___29449)){
args__5775__auto__.push((arguments[i__5770__auto___29450]));

var G__29451 = (i__5770__auto___29450 + (1));
i__5770__auto___29450 = G__29451;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29448){var e = e29448;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq29447){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29447));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29454 = arguments.length;
var i__5770__auto___29455 = (0);
while(true){
if((i__5770__auto___29455 < len__5769__auto___29454)){
args__5775__auto__.push((arguments[i__5770__auto___29455]));

var G__29456 = (i__5770__auto___29455 + (1));
i__5770__auto___29455 = G__29456;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e29453){var e = e29453;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq29452){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29452));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29459 = arguments.length;
var i__5770__auto___29460 = (0);
while(true){
if((i__5770__auto___29460 < len__5769__auto___29459)){
args__5775__auto__.push((arguments[i__5770__auto___29460]));

var G__29461 = (i__5770__auto___29460 + (1));
i__5770__auto___29460 = G__29461;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e29458){var e = e29458;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq29457){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29457));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29464 = arguments.length;
var i__5770__auto___29465 = (0);
while(true){
if((i__5770__auto___29465 < len__5769__auto___29464)){
args__5775__auto__.push((arguments[i__5770__auto___29465]));

var G__29466 = (i__5770__auto___29465 + (1));
i__5770__auto___29465 = G__29466;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e29463){var e = e29463;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq29462){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29462));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29469 = arguments.length;
var i__5770__auto___29470 = (0);
while(true){
if((i__5770__auto___29470 < len__5769__auto___29469)){
args__5775__auto__.push((arguments[i__5770__auto___29470]));

var G__29471 = (i__5770__auto___29470 + (1));
i__5770__auto___29470 = G__29471;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e29468){var e = e29468;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq29467){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29467));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29474 = arguments.length;
var i__5770__auto___29475 = (0);
while(true){
if((i__5770__auto___29475 < len__5769__auto___29474)){
args__5775__auto__.push((arguments[i__5770__auto___29475]));

var G__29476 = (i__5770__auto___29475 + (1));
i__5770__auto___29475 = G__29476;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e29473){var e = e29473;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq29472){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29472));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__29478 = arguments.length;
switch (G__29478) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29506){
var state_val_29507 = (state_29506[(1)]);
if((state_val_29507 === (7))){
var inst_29491 = (state_29506[(7)]);
var inst_29494 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29491,"query",query_map);
var state_29506__$1 = state_29506;
var statearr_29508_29594 = state_29506__$1;
(statearr_29508_29594[(2)] = inst_29494);

(statearr_29508_29594[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29507 === (1))){
var state_29506__$1 = state_29506;
var statearr_29509_29595 = state_29506__$1;
(statearr_29509_29595[(2)] = null);

(statearr_29509_29595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29507 === (4))){
var inst_29479 = (state_29506[(2)]);
var state_29506__$1 = state_29506;
var statearr_29510_29596 = state_29506__$1;
(statearr_29510_29596[(2)] = inst_29479);

(statearr_29510_29596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29507 === (6))){
var inst_29491 = (state_29506[(7)]);
var inst_29491__$1 = (state_29506[(2)]);
var inst_29492 = fluree.db.util.core.exception_QMARK_.call(null,inst_29491__$1);
var state_29506__$1 = (function (){var statearr_29511 = state_29506;
(statearr_29511[(7)] = inst_29491__$1);

return statearr_29511;
})();
if(inst_29492){
var statearr_29512_29597 = state_29506__$1;
(statearr_29512_29597[(1)] = (7));

} else {
var statearr_29513_29598 = state_29506__$1;
(statearr_29513_29598[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29507 === (3))){
var inst_29504 = (state_29506[(2)]);
var state_29506__$1 = state_29506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29506__$1,inst_29504);
} else {
if((state_val_29507 === (2))){
var inst_29485 = (state_29506[(8)]);
var _ = (function (){var statearr_29515 = state_29506;
(statearr_29515[(4)] = cljs.core.cons.call(null,(5),(state_29506[(4)])));

return statearr_29515;
})();
var inst_29485__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_29486 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_29487 = cljs.core.assoc.call(null,inst_29486,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_29485__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_29488 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_29487);
var inst_29489 = fluree.db.query.fql.query.call(null,db,inst_29488);
var state_29506__$1 = (function (){var statearr_29516 = state_29506;
(statearr_29516[(8)] = inst_29485__$1);

return statearr_29516;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29506__$1,(6),inst_29489);
} else {
if((state_val_29507 === (9))){
var inst_29501 = (state_29506[(2)]);
var _ = (function (){var statearr_29517 = state_29506;
(statearr_29517[(4)] = cljs.core.rest.call(null,(state_29506[(4)])));

return statearr_29517;
})();
var state_29506__$1 = state_29506;
var statearr_29518_29599 = state_29506__$1;
(statearr_29518_29599[(2)] = inst_29501);

(statearr_29518_29599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29507 === (5))){
var _ = (function (){var statearr_29519 = state_29506;
(statearr_29519[(4)] = cljs.core.rest.call(null,(state_29506[(4)])));

return statearr_29519;
})();
var state_29506__$1 = state_29506;
var ex29514 = (state_29506__$1[(2)]);
var statearr_29520_29600 = state_29506__$1;
(statearr_29520_29600[(5)] = ex29514);


if((ex29514 instanceof Error)){
var statearr_29521_29601 = state_29506__$1;
(statearr_29521_29601[(1)] = (4));

(statearr_29521_29601[(5)] = null);

} else {
throw ex29514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29507 === (8))){
var inst_29491 = (state_29506[(7)]);
var inst_29485 = (state_29506[(8)]);
var inst_29496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29497 = cljs.core.deref.call(null,inst_29485);
var inst_29498 = [inst_29491,inst_29497];
var inst_29499 = (new cljs.core.PersistentVector(null,2,(5),inst_29496,inst_29498,null));
var state_29506__$1 = state_29506;
var statearr_29522_29602 = state_29506__$1;
(statearr_29522_29602[(2)] = inst_29499);

(statearr_29522_29602[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2703__auto____0 = (function (){
var statearr_29523 = [null,null,null,null,null,null,null,null,null];
(statearr_29523[(0)] = fluree$db$dbfunctions$internal$state_machine__2703__auto__);

(statearr_29523[(1)] = (1));

return statearr_29523;
});
var fluree$db$dbfunctions$internal$state_machine__2703__auto____1 = (function (state_29506){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29524){var ex__2706__auto__ = e29524;
var statearr_29525_29603 = state_29506;
(statearr_29525_29603[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29506[(4)]))){
var statearr_29526_29604 = state_29506;
(statearr_29526_29604[(1)] = cljs.core.first.call(null,(state_29506[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29605 = state_29506;
state_29506 = G__29605;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2703__auto__ = function(state_29506){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____1.call(this,state_29506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29527 = f__2726__auto__.call(null);
(statearr_29527[(6)] = c__2725__auto__);

return statearr_29527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29572){
var state_val_29573 = (state_29572[(1)]);
if((state_val_29573 === (7))){
var inst_29558 = (state_29572[(2)]);
var inst_29559 = fluree.db.query.fql.query.call(null,db,inst_29558);
var state_29572__$1 = state_29572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29572__$1,(8),inst_29559);
} else {
if((state_val_29573 === (1))){
var inst_29528 = typeof select === 'string';
var state_29572__$1 = state_29572;
if(cljs.core.truth_(inst_29528)){
var statearr_29574_29606 = state_29572__$1;
(statearr_29574_29606[(1)] = (2));

} else {
var statearr_29575_29607 = state_29572__$1;
(statearr_29575_29607[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (4))){
var inst_29534 = (state_29572[(7)]);
var inst_29541 = (state_29572[(8)]);
var inst_29533 = (state_29572[(2)]);
var inst_29534__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_29535 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29536 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_29537 = [inst_29534__$1,(100000)];
var inst_29538 = cljs.core.PersistentHashMap.fromArrays(inst_29536,inst_29537);
var inst_29539 = [inst_29533,from,where,block,limit,inst_29538];
var inst_29540 = cljs.core.PersistentHashMap.fromArrays(inst_29535,inst_29539);
var inst_29541__$1 = fluree.db.util.core.without_nils.call(null,inst_29540);
var inst_29542 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29541__$1);
var inst_29543 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29541__$1);
var inst_29544 = cljs.core.first.call(null,inst_29543);
var inst_29545 = fluree.db.dbfunctions.internal.str.call(null,inst_29544);
var inst_29546 = cljs.core._EQ_.call(null,"[",inst_29545);
var inst_29547 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29541__$1);
var inst_29548 = cljs.core.last.call(null,inst_29547);
var inst_29549 = fluree.db.dbfunctions.internal.str.call(null,inst_29548);
var inst_29550 = cljs.core._EQ_.call(null,"]",inst_29549);
var inst_29551 = fluree.db.dbfunctions.internal.and.call(null,inst_29542,inst_29546,inst_29550);
var state_29572__$1 = (function (){var statearr_29576 = state_29572;
(statearr_29576[(7)] = inst_29534__$1);

(statearr_29576[(8)] = inst_29541__$1);

return statearr_29576;
})();
if(cljs.core.truth_(inst_29551)){
var statearr_29577_29608 = state_29572__$1;
(statearr_29577_29608[(1)] = (5));

} else {
var statearr_29578_29609 = state_29572__$1;
(statearr_29578_29609[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (6))){
var inst_29541 = (state_29572[(8)]);
var state_29572__$1 = state_29572;
var statearr_29579_29610 = state_29572__$1;
(statearr_29579_29610[(2)] = inst_29541);

(statearr_29579_29610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (3))){
var state_29572__$1 = state_29572;
var statearr_29580_29611 = state_29572__$1;
(statearr_29580_29611[(2)] = select);

(statearr_29580_29611[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (2))){
var inst_29530 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_29572__$1 = state_29572;
var statearr_29581_29612 = state_29572__$1;
(statearr_29581_29612[(2)] = inst_29530);

(statearr_29581_29612[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (11))){
var inst_29570 = (state_29572[(2)]);
var state_29572__$1 = state_29572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29572__$1,inst_29570);
} else {
if((state_val_29573 === (9))){
var inst_29561 = (state_29572[(9)]);
var state_29572__$1 = state_29572;
var statearr_29582_29613 = state_29572__$1;
(statearr_29582_29613[(2)] = inst_29561);

(statearr_29582_29613[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (5))){
var inst_29541 = (state_29572[(8)]);
var inst_29553 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29541);
var inst_29554 = cljs.reader.read_string.call(null,inst_29553);
var inst_29555 = cljs.core.assoc.call(null,inst_29541,new cljs.core.Keyword(null,"where","where",-2044795965),inst_29554);
var state_29572__$1 = state_29572;
var statearr_29583_29614 = state_29572__$1;
(statearr_29583_29614[(2)] = inst_29555);

(statearr_29583_29614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (10))){
var inst_29534 = (state_29572[(7)]);
var inst_29561 = (state_29572[(9)]);
var inst_29565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29566 = cljs.core.deref.call(null,inst_29534);
var inst_29567 = [inst_29561,inst_29566];
var inst_29568 = (new cljs.core.PersistentVector(null,2,(5),inst_29565,inst_29567,null));
var state_29572__$1 = state_29572;
var statearr_29584_29615 = state_29572__$1;
(statearr_29584_29615[(2)] = inst_29568);

(statearr_29584_29615[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29573 === (8))){
var inst_29561 = (state_29572[(9)]);
var inst_29561__$1 = (state_29572[(2)]);
var inst_29562 = fluree.db.util.core.exception_QMARK_.call(null,inst_29561__$1);
var state_29572__$1 = (function (){var statearr_29585 = state_29572;
(statearr_29585[(9)] = inst_29561__$1);

return statearr_29585;
})();
if(inst_29562){
var statearr_29586_29616 = state_29572__$1;
(statearr_29586_29616[(1)] = (9));

} else {
var statearr_29587_29617 = state_29572__$1;
(statearr_29587_29617[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2703__auto____0 = (function (){
var statearr_29588 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29588[(0)] = fluree$db$dbfunctions$internal$state_machine__2703__auto__);

(statearr_29588[(1)] = (1));

return statearr_29588;
});
var fluree$db$dbfunctions$internal$state_machine__2703__auto____1 = (function (state_29572){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29589){var ex__2706__auto__ = e29589;
var statearr_29590_29618 = state_29572;
(statearr_29590_29618[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29572[(4)]))){
var statearr_29591_29619 = state_29572;
(statearr_29591_29619[(1)] = cljs.core.first.call(null,(state_29572[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29620 = state_29572;
state_29572 = G__29620;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2703__auto__ = function(state_29572){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____1.call(this,state_29572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29592 = f__2726__auto__.call(null);
(statearr_29592[(6)] = c__2725__auto__);

return statearr_29592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__29624 = path;
var vec__29625 = G__29624;
var seq__29626 = cljs.core.seq.call(null,vec__29625);
var first__29627 = cljs.core.first.call(null,seq__29626);
var seq__29626__$1 = cljs.core.next.call(null,seq__29626);
var var$ = first__29627;
var r = seq__29626__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__29624__$1 = G__29624;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__29631 = G__29624__$1;
var seq__29632 = cljs.core.seq.call(null,vec__29631);
var first__29633 = cljs.core.first.call(null,seq__29632);
var seq__29632__$1 = cljs.core.next.call(null,seq__29632);
var var$__$1 = first__29633;
var r__$1 = seq__29632__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__29634 = r__$1;
var G__29635 = n__$2;
var G__29636 = next_clauses;
G__29624__$1 = G__29634;
n__$1 = G__29635;
where_clauses__$1 = G__29636;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__29637 = r__$1;
var G__29638 = next_n;
var G__29639 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__29624__$1 = G__29637;
n__$1 = G__29638;
where_clauses__$1 = G__29639;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29676){
var state_val_29677 = (state_29676[(1)]);
if((state_val_29677 === (7))){
var inst_29649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29650 = [path];
var inst_29651 = (new cljs.core.PersistentVector(null,1,(5),inst_29649,inst_29650,null));
var state_29676__$1 = state_29676;
var statearr_29678_29706 = state_29676__$1;
(statearr_29678_29706[(2)] = inst_29651);

(statearr_29678_29706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (1))){
var state_29676__$1 = state_29676;
var statearr_29679_29707 = state_29676__$1;
(statearr_29679_29707[(2)] = null);

(statearr_29679_29707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (4))){
var inst_29640 = (state_29676[(2)]);
var state_29676__$1 = state_29676;
var statearr_29680_29708 = state_29676__$1;
(statearr_29680_29708[(2)] = inst_29640);

(statearr_29680_29708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (13))){
var inst_29667 = (state_29676[(2)]);
var inst_29668 = fluree.db.util.async.throw_err.call(null,inst_29667);
var _ = (function (){var statearr_29681 = state_29676;
(statearr_29681[(4)] = cljs.core.rest.call(null,(state_29676[(4)])));

return statearr_29681;
})();
var state_29676__$1 = state_29676;
var statearr_29682_29709 = state_29676__$1;
(statearr_29682_29709[(2)] = inst_29668);

(statearr_29682_29709[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (6))){
var state_29676__$1 = state_29676;
var statearr_29684_29710 = state_29676__$1;
(statearr_29684_29710[(2)] = path);

(statearr_29684_29710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (3))){
var inst_29674 = (state_29676[(2)]);
var state_29676__$1 = state_29676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29676__$1,inst_29674);
} else {
if((state_val_29677 === (12))){
var _ = (function (){var statearr_29685 = state_29676;
(statearr_29685[(4)] = cljs.core.rest.call(null,(state_29676[(4)])));

return statearr_29685;
})();
var state_29676__$1 = state_29676;
var ex29683 = (state_29676__$1[(2)]);
var statearr_29686_29711 = state_29676__$1;
(statearr_29686_29711[(5)] = ex29683);


var statearr_29687_29712 = state_29676__$1;
(statearr_29687_29712[(1)] = (11));

(statearr_29687_29712[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (2))){
var _ = (function (){var statearr_29688 = state_29676;
(statearr_29688[(4)] = cljs.core.cons.call(null,(5),(state_29676[(4)])));

return statearr_29688;
})();
var inst_29646 = cljs.core.vector_QMARK_.call(null,path);
var state_29676__$1 = state_29676;
if(inst_29646){
var statearr_29689_29713 = state_29676__$1;
(statearr_29689_29713[(1)] = (6));

} else {
var statearr_29690_29714 = state_29676__$1;
(statearr_29690_29714[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (11))){
var inst_29653 = (state_29676[(7)]);
var inst_29658 = (state_29676[(2)]);
var inst_29659 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29658,"relationship?",startSubject,inst_29653,endSubject);
var state_29676__$1 = state_29676;
var statearr_29692_29715 = state_29676__$1;
(statearr_29692_29715[(2)] = inst_29659);

(statearr_29692_29715[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (9))){
var inst_29657 = (state_29676[(8)]);
var _ = (function (){var statearr_29693 = state_29676;
(statearr_29693[(4)] = cljs.core.cons.call(null,(12),(state_29676[(4)])));

return statearr_29693;
})();
var inst_29665 = fluree.db.dbfunctions.internal.query.call(null,db,inst_29657);
var state_29676__$1 = state_29676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29676__$1,(13),inst_29665);
} else {
if((state_val_29677 === (5))){
var _ = (function (){var statearr_29694 = state_29676;
(statearr_29694[(4)] = cljs.core.rest.call(null,(state_29676[(4)])));

return statearr_29694;
})();
var state_29676__$1 = state_29676;
var ex29691 = (state_29676__$1[(2)]);
var statearr_29695_29716 = state_29676__$1;
(statearr_29695_29716[(5)] = ex29691);


if((ex29691 instanceof Error)){
var statearr_29696_29717 = state_29676__$1;
(statearr_29696_29717[(1)] = (4));

(statearr_29696_29717[(5)] = null);

} else {
throw ex29691;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (10))){
var inst_29671 = (state_29676[(2)]);
var _ = (function (){var statearr_29697 = state_29676;
(statearr_29697[(4)] = cljs.core.rest.call(null,(state_29676[(4)])));

return statearr_29697;
})();
var state_29676__$1 = state_29676;
var statearr_29698_29718 = state_29676__$1;
(statearr_29698_29718[(2)] = inst_29671);

(statearr_29698_29718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29677 === (8))){
var inst_29653 = (state_29676[(7)]);
var inst_29653__$1 = (state_29676[(2)]);
var inst_29654 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_29653__$1,endSubject);
var inst_29655 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_29656 = ["?var1",inst_29654];
var inst_29657 = cljs.core.PersistentHashMap.fromArrays(inst_29655,inst_29656);
var state_29676__$1 = (function (){var statearr_29699 = state_29676;
(statearr_29699[(7)] = inst_29653__$1);

(statearr_29699[(8)] = inst_29657);

return statearr_29699;
})();
var statearr_29700_29719 = state_29676__$1;
(statearr_29700_29719[(2)] = null);

(statearr_29700_29719[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto____0 = (function (){
var statearr_29701 = [null,null,null,null,null,null,null,null,null];
(statearr_29701[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto__);

(statearr_29701[(1)] = (1));

return statearr_29701;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto____1 = (function (state_29676){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29702){var ex__2706__auto__ = e29702;
var statearr_29703_29720 = state_29676;
(statearr_29703_29720[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29676[(4)]))){
var statearr_29704_29721 = state_29676;
(statearr_29704_29721[(1)] = cljs.core.first.call(null,(state_29676[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29722 = state_29676;
state_29676 = G__29722;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto__ = function(state_29676){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto____1.call(this,state_29676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29705 = f__2726__auto__.call(null);
(statearr_29705[(6)] = c__2725__auto__);

return statearr_29705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e29723){var e = e29723;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e29724){var e = e29724;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e29725){var e = e29725;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e29726){var e = e29726;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29729 = arguments.length;
var i__5770__auto___29730 = (0);
while(true){
if((i__5770__auto___29730 < len__5769__auto___29729)){
args__5775__auto__.push((arguments[i__5770__auto___29730]));

var G__29731 = (i__5770__auto___29730 + (1));
i__5770__auto___29730 = G__29731;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e29728){var e = e29728;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq29727){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29727));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29734 = arguments.length;
var i__5770__auto___29735 = (0);
while(true){
if((i__5770__auto___29735 < len__5769__auto___29734)){
args__5775__auto__.push((arguments[i__5770__auto___29735]));

var G__29736 = (i__5770__auto___29735 + (1));
i__5770__auto___29735 = G__29736;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e29733){var e = e29733;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq29732){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29732));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29739 = arguments.length;
var i__5770__auto___29740 = (0);
while(true){
if((i__5770__auto___29740 < len__5769__auto___29739)){
args__5775__auto__.push((arguments[i__5770__auto___29740]));

var G__29741 = (i__5770__auto___29740 + (1));
i__5770__auto___29740 = G__29741;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e29738){var e = e29738;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq29737){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29737));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29744 = arguments.length;
var i__5770__auto___29745 = (0);
while(true){
if((i__5770__auto___29745 < len__5769__auto___29744)){
args__5775__auto__.push((arguments[i__5770__auto___29745]));

var G__29746 = (i__5770__auto___29745 + (1));
i__5770__auto___29745 = G__29746;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e29743){var e = e29743;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq29742){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29742));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e29747){var e = e29747;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e29748){var e = e29748;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e29749){var e = e29749;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e29750){var e = e29750;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e29751){var e = e29751;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__29757 = path;
var vec__29758 = G__29757;
var seq__29759 = cljs.core.seq.call(null,vec__29758);
var first__29760 = cljs.core.first.call(null,seq__29759);
var seq__29759__$1 = cljs.core.next.call(null,seq__29759);
var pred = first__29760;
var r = seq__29759__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__29757__$1 = G__29757;
var subjects__$1 = subjects;
while(true){
var vec__29764 = G__29757__$1;
var seq__29765 = cljs.core.seq.call(null,vec__29764);
var first__29766 = cljs.core.first.call(null,seq__29765);
var seq__29765__$1 = cljs.core.next.call(null,seq__29765);
var pred__$1 = first__29766;
var r__$1 = seq__29765__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__29757__$1,subjects__$1,vec__29764,seq__29765,first__29766,seq__29765__$1,pred__$1,r__$1,subjects__$2,G__29757,vec__29758,seq__29759,first__29760,seq__29759__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__29757__$1,subjects__$1,vec__29764,seq__29765,first__29766,seq__29765__$1,pred__$1,r__$1,subjects__$2,G__29757,vec__29758,seq__29759,first__29760,seq__29759__$1,pred,r,subjects){
return (function (p1__29752_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__29752_SHARP_,pred__$1);
});})(G__29757__$1,subjects__$1,vec__29764,seq__29765,first__29766,seq__29765__$1,pred__$1,r__$1,subjects__$2,G__29757,vec__29758,seq__29759,first__29760,seq__29759__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__29757__$1,subjects__$1,vec__29764,seq__29765,first__29766,seq__29765__$1,pred__$1,r__$1,subjects__$2,G__29757,vec__29758,seq__29759,first__29760,seq__29759__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__29767 = r__$1;
var G__29768 = next_subjects;
G__29757__$1 = G__29767;
subjects__$1 = G__29768;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e29753){var e = e29753;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e29769){var e = e29769;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e29770){var e = e29770;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29773 = arguments.length;
var i__5770__auto___29774 = (0);
while(true){
if((i__5770__auto___29774 < len__5769__auto___29773)){
args__5775__auto__.push((arguments[i__5770__auto___29774]));

var G__29775 = (i__5770__auto___29774 + (1));
i__5770__auto___29774 = G__29775;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e29772){var e = e29772;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq29771){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29771));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e29776){var e = e29776;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29779 = arguments.length;
var i__5770__auto___29780 = (0);
while(true){
if((i__5770__auto___29780 < len__5769__auto___29779)){
args__5775__auto__.push((arguments[i__5770__auto___29780]));

var G__29781 = (i__5770__auto___29780 + (1));
i__5770__auto___29780 = G__29781;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e29778){var e = e29778;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq29777){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29777));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e29782){var e = e29782;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29839){
var state_val_29840 = (state_29839[(1)]);
if((state_val_29840 === (7))){
var inst_29785 = (state_29839[(2)]);
var state_29839__$1 = state_29839;
var statearr_29841_29875 = state_29839__$1;
(statearr_29841_29875[(2)] = inst_29785);

(statearr_29841_29875[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (1))){
var state_29839__$1 = state_29839;
var statearr_29842_29876 = state_29839__$1;
(statearr_29842_29876[(2)] = null);

(statearr_29842_29876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (4))){
var inst_29784 = (state_29839[(2)]);
var state_29839__$1 = (function (){var statearr_29843 = state_29839;
(statearr_29843[(7)] = inst_29784);

return statearr_29843;
})();
var statearr_29844_29877 = state_29839__$1;
(statearr_29844_29877[(2)] = null);

(statearr_29844_29877[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (15))){
var inst_29809 = (state_29839[(8)]);
var inst_29807 = (state_29839[(9)]);
var inst_29820 = (state_29839[(10)]);
var inst_29822 = (state_29839[(11)]);
var inst_29810 = (state_29839[(12)]);
var inst_29819 = (state_29839[(13)]);
var inst_29826 = (function (){var db = inst_29807;
var prevT = inst_29809;
var db_SINGLEQUOTE_ = inst_29810;
var prev_vals = inst_29819;
var fuel = inst_29820;
var G__29821 = inst_29822;
return (function (p1__29783_SHARP_){
var f = p1__29783_SHARP_;
return f.o;
});
})();
var inst_29827 = inst_29826.call(null,inst_29822);
var state_29839__$1 = state_29839;
var statearr_29845_29878 = state_29839__$1;
(statearr_29845_29878[(2)] = inst_29827);

(statearr_29845_29878[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (13))){
var inst_29822 = (state_29839[(11)]);
var inst_29819 = (state_29839[(13)]);
var inst_29818 = (state_29839[(2)]);
var inst_29819__$1 = fluree.db.util.async.throw_err.call(null,inst_29818);
var inst_29820 = fluree.db.dbfunctions.internal.count.call(null,inst_29819__$1);
var inst_29822__$1 = cljs.core.first.call(null,inst_29819__$1);
var inst_29823 = (inst_29822__$1 == null);
var state_29839__$1 = (function (){var statearr_29846 = state_29839;
(statearr_29846[(10)] = inst_29820);

(statearr_29846[(11)] = inst_29822__$1);

(statearr_29846[(13)] = inst_29819__$1);

return statearr_29846;
})();
if(cljs.core.truth_(inst_29823)){
var statearr_29847_29879 = state_29839__$1;
(statearr_29847_29879[(1)] = (14));

} else {
var statearr_29848_29880 = state_29839__$1;
(statearr_29848_29880[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (6))){
var inst_29794 = (state_29839[(2)]);
var state_29839__$1 = state_29839;
var statearr_29849_29881 = state_29839__$1;
(statearr_29849_29881[(2)] = inst_29794);

(statearr_29849_29881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (3))){
var inst_29837 = (state_29839[(2)]);
var state_29839__$1 = state_29839;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29839__$1,inst_29837);
} else {
if((state_val_29840 === (12))){
var inst_29834 = (state_29839[(2)]);
var _ = (function (){var statearr_29850 = state_29839;
(statearr_29850[(4)] = cljs.core.rest.call(null,(state_29839[(4)])));

return statearr_29850;
})();
var state_29839__$1 = state_29839;
var statearr_29851_29882 = state_29839__$1;
(statearr_29851_29882[(2)] = inst_29834);

(statearr_29851_29882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (2))){
var _ = (function (){var statearr_29853 = state_29839;
(statearr_29853[(4)] = cljs.core.cons.call(null,(9),(state_29839[(4)])));

return statearr_29853;
})();
var inst_29800 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29801 = typeof inst_29800 === 'string';
var state_29839__$1 = state_29839;
if(cljs.core.truth_(inst_29801)){
var statearr_29854_29883 = state_29839__$1;
(statearr_29854_29883[(1)] = (10));

} else {
var statearr_29855_29884 = state_29839__$1;
(statearr_29855_29884[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (11))){
var inst_29809 = (state_29839[(8)]);
var inst_29807 = (state_29839[(9)]);
var inst_29810 = (state_29839[(12)]);
var inst_29807__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29808 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_29807__$1);
var inst_29809__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_29808);
var inst_29810__$1 = cljs.core.assoc.call(null,inst_29807__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_29809__$1);
var inst_29811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29812 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29813 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29814 = [inst_29812,inst_29813];
var inst_29815 = (new cljs.core.PersistentVector(null,2,(5),inst_29811,inst_29814,null));
var inst_29816 = fluree.db.dbproto._search.call(null,inst_29810__$1,inst_29815);
var state_29839__$1 = (function (){var statearr_29856 = state_29839;
(statearr_29856[(8)] = inst_29809__$1);

(statearr_29856[(9)] = inst_29807__$1);

(statearr_29856[(12)] = inst_29810__$1);

return statearr_29856;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29839__$1,(13),inst_29816);
} else {
if((state_val_29840 === (9))){
var _ = (function (){var statearr_29857 = state_29839;
(statearr_29857[(4)] = cljs.core.rest.call(null,(state_29839[(4)])));

return statearr_29857;
})();
var state_29839__$1 = state_29839;
var ex29852 = (state_29839__$1[(2)]);
var statearr_29858_29885 = state_29839__$1;
(statearr_29858_29885[(5)] = ex29852);


var statearr_29859_29886 = state_29839__$1;
(statearr_29859_29886[(1)] = (4));

(statearr_29859_29886[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (5))){
var inst_29784 = (state_29839[(7)]);
var _ = (function (){var statearr_29860 = state_29839;
(statearr_29860[(4)] = cljs.core.cons.call(null,(8),(state_29839[(4)])));

return statearr_29860;
})();
var inst_29791 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29784,"?pO","Context Object");
var ___$1 = (function (){var statearr_29861 = state_29839;
(statearr_29861[(4)] = cljs.core.rest.call(null,(state_29839[(4)])));

return statearr_29861;
})();
var state_29839__$1 = state_29839;
var statearr_29862_29887 = state_29839__$1;
(statearr_29862_29887[(2)] = inst_29791);

(statearr_29862_29887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (14))){
var state_29839__$1 = state_29839;
var statearr_29863_29888 = state_29839__$1;
(statearr_29863_29888[(2)] = null);

(statearr_29863_29888[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (16))){
var inst_29820 = (state_29839[(10)]);
var inst_29829 = (state_29839[(2)]);
var inst_29830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29831 = [inst_29829,inst_29820];
var inst_29832 = (new cljs.core.PersistentVector(null,2,(5),inst_29830,inst_29831,null));
var state_29839__$1 = state_29839;
var statearr_29865_29889 = state_29839__$1;
(statearr_29865_29889[(2)] = inst_29832);

(statearr_29865_29889[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (10))){
var inst_29803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29804 = [null,(0)];
var inst_29805 = (new cljs.core.PersistentVector(null,2,(5),inst_29803,inst_29804,null));
var state_29839__$1 = state_29839;
var statearr_29866_29890 = state_29839__$1;
(statearr_29866_29890[(2)] = inst_29805);

(statearr_29866_29890[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29840 === (8))){
var _ = (function (){var statearr_29867 = state_29839;
(statearr_29867[(4)] = cljs.core.rest.call(null,(state_29839[(4)])));

return statearr_29867;
})();
var state_29839__$1 = state_29839;
var ex29864 = (state_29839__$1[(2)]);
var statearr_29868_29891 = state_29839__$1;
(statearr_29868_29891[(5)] = ex29864);


var statearr_29869_29892 = state_29839__$1;
(statearr_29869_29892[(1)] = (7));

(statearr_29869_29892[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto____0 = (function (){
var statearr_29870 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29870[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto__);

(statearr_29870[(1)] = (1));

return statearr_29870;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto____1 = (function (state_29839){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29871){var ex__2706__auto__ = e29871;
var statearr_29872_29893 = state_29839;
(statearr_29872_29893[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29839[(4)]))){
var statearr_29873_29894 = state_29839;
(statearr_29873_29894[(1)] = cljs.core.first.call(null,(state_29839[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29895 = state_29839;
state_29839 = G__29895;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto__ = function(state_29839){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto____1.call(this,state_29839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29874 = f__2726__auto__.call(null);
(statearr_29874[(6)] = c__2725__auto__);

return statearr_29874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29947){
var state_val_29948 = (state_29947[(1)]);
if((state_val_29948 === (7))){
var inst_29897 = (state_29947[(2)]);
var state_29947__$1 = state_29947;
var statearr_29949_29978 = state_29947__$1;
(statearr_29949_29978[(2)] = inst_29897);

(statearr_29949_29978[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (1))){
var state_29947__$1 = state_29947;
var statearr_29950_29979 = state_29947__$1;
(statearr_29950_29979[(2)] = null);

(statearr_29950_29979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (4))){
var inst_29896 = (state_29947[(2)]);
var state_29947__$1 = (function (){var statearr_29951 = state_29947;
(statearr_29951[(7)] = inst_29896);

return statearr_29951;
})();
var statearr_29952_29980 = state_29947__$1;
(statearr_29952_29980[(2)] = null);

(statearr_29952_29980[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (13))){
var inst_29942 = (state_29947[(2)]);
var _ = (function (){var statearr_29953 = state_29947;
(statearr_29953[(4)] = cljs.core.rest.call(null,(state_29947[(4)])));

return statearr_29953;
})();
var state_29947__$1 = state_29947;
var statearr_29954_29981 = state_29947__$1;
(statearr_29954_29981[(2)] = inst_29942);

(statearr_29954_29981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (6))){
var inst_29906 = (state_29947[(2)]);
var state_29947__$1 = state_29947;
var statearr_29955_29982 = state_29947__$1;
(statearr_29955_29982[(2)] = inst_29906);

(statearr_29955_29982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (3))){
var inst_29945 = (state_29947[(2)]);
var state_29947__$1 = state_29947;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29947__$1,inst_29945);
} else {
if((state_val_29948 === (12))){
var inst_29929 = (state_29947[(8)]);
var inst_29938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29939 = [null,inst_29929];
var inst_29940 = (new cljs.core.PersistentVector(null,2,(5),inst_29938,inst_29939,null));
var state_29947__$1 = state_29947;
var statearr_29956_29983 = state_29947__$1;
(statearr_29956_29983[(2)] = inst_29940);

(statearr_29956_29983[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (2))){
var _ = (function (){var statearr_29958 = state_29947;
(statearr_29958[(4)] = cljs.core.cons.call(null,(9),(state_29947[(4)])));

return statearr_29958;
})();
var inst_29915 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29918 = [null,pred_name,"?o"];
var inst_29919 = (new cljs.core.PersistentVector(null,3,(5),inst_29917,inst_29918,null));
var inst_29920 = [inst_29919];
var inst_29921 = (new cljs.core.PersistentVector(null,1,(5),inst_29916,inst_29920,null));
var inst_29922 = ["?o",inst_29921,opts];
var inst_29923 = cljs.core.PersistentHashMap.fromArrays(inst_29915,inst_29922);
var inst_29924 = fluree.db.dbfunctions.internal.query.call(null,db,inst_29923);
var state_29947__$1 = state_29947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29947__$1,(10),inst_29924);
} else {
if((state_val_29948 === (11))){
var inst_29929 = (state_29947[(8)]);
var inst_29928 = (state_29947[(9)]);
var inst_29933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29934 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_29928);
var inst_29935 = [inst_29934,inst_29929];
var inst_29936 = (new cljs.core.PersistentVector(null,2,(5),inst_29933,inst_29935,null));
var state_29947__$1 = state_29947;
var statearr_29959_29984 = state_29947__$1;
(statearr_29959_29984[(2)] = inst_29936);

(statearr_29959_29984[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (9))){
var _ = (function (){var statearr_29960 = state_29947;
(statearr_29960[(4)] = cljs.core.rest.call(null,(state_29947[(4)])));

return statearr_29960;
})();
var state_29947__$1 = state_29947;
var ex29957 = (state_29947__$1[(2)]);
var statearr_29961_29985 = state_29947__$1;
(statearr_29961_29985[(5)] = ex29957);


var statearr_29962_29986 = state_29947__$1;
(statearr_29962_29986[(1)] = (4));

(statearr_29962_29986[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (5))){
var inst_29896 = (state_29947[(7)]);
var _ = (function (){var statearr_29964 = state_29947;
(statearr_29964[(4)] = cljs.core.cons.call(null,(8),(state_29947[(4)])));

return statearr_29964;
})();
var inst_29903 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29896,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_29965 = state_29947;
(statearr_29965[(4)] = cljs.core.rest.call(null,(state_29947[(4)])));

return statearr_29965;
})();
var state_29947__$1 = state_29947;
var statearr_29966_29987 = state_29947__$1;
(statearr_29966_29987[(2)] = inst_29903);

(statearr_29966_29987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (10))){
var inst_29928 = (state_29947[(9)]);
var inst_29926 = (state_29947[(2)]);
var inst_29927 = fluree.db.util.async.throw_err.call(null,inst_29926);
var inst_29928__$1 = cljs.core.nth.call(null,inst_29927,(0),null);
var inst_29929 = cljs.core.nth.call(null,inst_29927,(1),null);
var inst_29930 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_29928__$1);
var inst_29931 = cljs.core.not.call(null,inst_29930);
var state_29947__$1 = (function (){var statearr_29967 = state_29947;
(statearr_29967[(8)] = inst_29929);

(statearr_29967[(9)] = inst_29928__$1);

return statearr_29967;
})();
if(inst_29931){
var statearr_29968_29988 = state_29947__$1;
(statearr_29968_29988[(1)] = (11));

} else {
var statearr_29969_29989 = state_29947__$1;
(statearr_29969_29989[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29948 === (8))){
var _ = (function (){var statearr_29970 = state_29947;
(statearr_29970[(4)] = cljs.core.rest.call(null,(state_29947[(4)])));

return statearr_29970;
})();
var state_29947__$1 = state_29947;
var ex29963 = (state_29947__$1[(2)]);
var statearr_29971_29990 = state_29947__$1;
(statearr_29971_29990[(5)] = ex29963);


var statearr_29972_29991 = state_29947__$1;
(statearr_29972_29991[(1)] = (7));

(statearr_29972_29991[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto____0 = (function (){
var statearr_29973 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29973[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto__);

(statearr_29973[(1)] = (1));

return statearr_29973;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto____1 = (function (state_29947){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29947);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29974){var ex__2706__auto__ = e29974;
var statearr_29975_29992 = state_29947;
(statearr_29975_29992[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29947[(4)]))){
var statearr_29976_29993 = state_29947;
(statearr_29976_29993[(1)] = cljs.core.first.call(null,(state_29947[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29994 = state_29947;
state_29947 = G__29994;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto__ = function(state_29947){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto____1.call(this,state_29947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29977 = f__2726__auto__.call(null);
(statearr_29977[(6)] = c__2725__auto__);

return statearr_29977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e29995){var e = e29995;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29997 = arguments.length;
switch (G__29997) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_30067){
var state_val_30068 = (state_30067[(1)]);
if((state_val_30068 === (7))){
var inst_29999 = (state_30067[(2)]);
var state_30067__$1 = state_30067;
var statearr_30069_30113 = state_30067__$1;
(statearr_30069_30113[(2)] = inst_29999);

(statearr_30069_30113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (20))){
var inst_30043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30044 = ["*"];
var inst_30045 = (new cljs.core.PersistentVector(null,1,(5),inst_30043,inst_30044,null));
var state_30067__$1 = state_30067;
var statearr_30070_30114 = state_30067__$1;
(statearr_30070_30114[(2)] = inst_30045);

(statearr_30070_30114[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (1))){
var state_30067__$1 = state_30067;
var statearr_30071_30115 = state_30067__$1;
(statearr_30071_30115[(2)] = null);

(statearr_30071_30115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (4))){
var inst_29998 = (state_30067[(2)]);
var state_30067__$1 = (function (){var statearr_30072 = state_30067;
(statearr_30072[(7)] = inst_29998);

return statearr_30072;
})();
var statearr_30073_30116 = state_30067__$1;
(statearr_30073_30116[(2)] = null);

(statearr_30073_30116[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (15))){
var inst_30062 = (state_30067[(2)]);
var _ = (function (){var statearr_30074 = state_30067;
(statearr_30074[(4)] = cljs.core.rest.call(null,(state_30067[(4)])));

return statearr_30074;
})();
var state_30067__$1 = state_30067;
var statearr_30075_30117 = state_30067__$1;
(statearr_30075_30117[(2)] = inst_30062);

(statearr_30075_30117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (21))){
var inst_30026 = (state_30067[(8)]);
var inst_30033 = (state_30067[(9)]);
var inst_30047 = (state_30067[(2)]);
var inst_30048 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30049 = cljs.core.PersistentHashMap.EMPTY;
var inst_30050 = [inst_30047,inst_30033,inst_30049];
var inst_30051 = cljs.core.PersistentHashMap.fromArrays(inst_30048,inst_30050);
var inst_30052 = fluree.db.dbfunctions.internal.query.call(null,inst_30026,inst_30051);
var state_30067__$1 = state_30067;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30067__$1,(22),inst_30052);
} else {
if((state_val_30068 === (13))){
var inst_30021 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30067__$1 = state_30067;
var statearr_30076_30118 = state_30067__$1;
(statearr_30076_30118[(2)] = inst_30021);

(statearr_30076_30118[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (22))){
var inst_30054 = (state_30067[(2)]);
var inst_30055 = fluree.db.util.async.throw_err.call(null,inst_30054);
var inst_30056 = cljs.core.nth.call(null,inst_30055,(0),null);
var inst_30057 = cljs.core.nth.call(null,inst_30055,(1),null);
var inst_30058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30059 = [inst_30056,inst_30057];
var inst_30060 = (new cljs.core.PersistentVector(null,2,(5),inst_30058,inst_30059,null));
var state_30067__$1 = state_30067;
var statearr_30077_30119 = state_30067__$1;
(statearr_30077_30119[(2)] = inst_30060);

(statearr_30077_30119[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (6))){
var inst_30008 = (state_30067[(2)]);
var state_30067__$1 = state_30067;
var statearr_30078_30120 = state_30067__$1;
(statearr_30078_30120[(2)] = inst_30008);

(statearr_30078_30120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (17))){
var inst_30030 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30031 = fluree.db.dbfunctions.internal.get.call(null,inst_30030,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_30067__$1 = state_30067;
var statearr_30079_30121 = state_30067__$1;
(statearr_30079_30121[(2)] = inst_30031);

(statearr_30079_30121[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (3))){
var inst_30065 = (state_30067[(2)]);
var state_30067__$1 = state_30067;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30067__$1,inst_30065);
} else {
if((state_val_30068 === (12))){
var inst_30019 = (state_30067[(2)]);
var state_30067__$1 = state_30067;
if(cljs.core.truth_(inst_30019)){
var statearr_30080_30122 = state_30067__$1;
(statearr_30080_30122[(1)] = (13));

} else {
var statearr_30081_30123 = state_30067__$1;
(statearr_30081_30123[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (2))){
var inst_30014 = (state_30067[(10)]);
var _ = (function (){var statearr_30082 = state_30067;
(statearr_30082[(4)] = cljs.core.cons.call(null,(9),(state_30067[(4)])));

return statearr_30082;
})();
var inst_30014__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30067__$1 = (function (){var statearr_30083 = state_30067;
(statearr_30083[(10)] = inst_30014__$1);

return statearr_30083;
})();
if(cljs.core.truth_(inst_30014__$1)){
var statearr_30084_30124 = state_30067__$1;
(statearr_30084_30124[(1)] = (10));

} else {
var statearr_30085_30125 = state_30067__$1;
(statearr_30085_30125[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (19))){
var inst_30035 = cljs.core.PersistentVector.EMPTY;
var inst_30036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30037 = ["*"];
var inst_30038 = (new cljs.core.PersistentVector(null,1,(5),inst_30036,inst_30037,null));
var inst_30039 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_30040 = cljs.core.concat.call(null,inst_30038,inst_30039);
var inst_30041 = cljs.core.into.call(null,inst_30035,inst_30040);
var state_30067__$1 = state_30067;
var statearr_30087_30126 = state_30067__$1;
(statearr_30087_30126[(2)] = inst_30041);

(statearr_30087_30126[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (11))){
var inst_30014 = (state_30067[(10)]);
var state_30067__$1 = state_30067;
var statearr_30088_30127 = state_30067__$1;
(statearr_30088_30127[(2)] = inst_30014);

(statearr_30088_30127[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (9))){
var _ = (function (){var statearr_30089 = state_30067;
(statearr_30089[(4)] = cljs.core.rest.call(null,(state_30067[(4)])));

return statearr_30089;
})();
var state_30067__$1 = state_30067;
var ex30086 = (state_30067__$1[(2)]);
var statearr_30090_30128 = state_30067__$1;
(statearr_30090_30128[(5)] = ex30086);


var statearr_30091_30129 = state_30067__$1;
(statearr_30091_30129[(1)] = (4));

(statearr_30091_30129[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (5))){
var inst_29998 = (state_30067[(7)]);
var _ = (function (){var statearr_30092 = state_30067;
(statearr_30092[(4)] = cljs.core.cons.call(null,(8),(state_30067[(4)])));

return statearr_30092;
})();
var inst_30005 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29998,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_30093 = state_30067;
(statearr_30093[(4)] = cljs.core.rest.call(null,(state_30067[(4)])));

return statearr_30093;
})();
var state_30067__$1 = state_30067;
var statearr_30094_30130 = state_30067__$1;
(statearr_30094_30130[(2)] = inst_30005);

(statearr_30094_30130[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (14))){
var inst_30027 = (state_30067[(11)]);
var inst_30026 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30027__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30067__$1 = (function (){var statearr_30095 = state_30067;
(statearr_30095[(8)] = inst_30026);

(statearr_30095[(11)] = inst_30027__$1);

return statearr_30095;
})();
if(cljs.core.truth_(inst_30027__$1)){
var statearr_30096_30131 = state_30067__$1;
(statearr_30096_30131[(1)] = (16));

} else {
var statearr_30097_30132 = state_30067__$1;
(statearr_30097_30132[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (16))){
var inst_30027 = (state_30067[(11)]);
var state_30067__$1 = state_30067;
var statearr_30098_30133 = state_30067__$1;
(statearr_30098_30133[(2)] = inst_30027);

(statearr_30098_30133[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (10))){
var inst_30016 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_30067__$1 = state_30067;
var statearr_30100_30134 = state_30067__$1;
(statearr_30100_30134[(2)] = inst_30016);

(statearr_30100_30134[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (18))){
var inst_30033 = (state_30067[(2)]);
var state_30067__$1 = (function (){var statearr_30101 = state_30067;
(statearr_30101[(9)] = inst_30033);

return statearr_30101;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30102_30135 = state_30067__$1;
(statearr_30102_30135[(1)] = (19));

} else {
var statearr_30103_30136 = state_30067__$1;
(statearr_30103_30136[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30068 === (8))){
var _ = (function (){var statearr_30104 = state_30067;
(statearr_30104[(4)] = cljs.core.rest.call(null,(state_30067[(4)])));

return statearr_30104;
})();
var state_30067__$1 = state_30067;
var ex30099 = (state_30067__$1[(2)]);
var statearr_30105_30137 = state_30067__$1;
(statearr_30105_30137[(5)] = ex30099);


var statearr_30106_30138 = state_30067__$1;
(statearr_30106_30138[(1)] = (7));

(statearr_30106_30138[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2703__auto____0 = (function (){
var statearr_30107 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30107[(0)] = fluree$db$dbfunctions$internal$state_machine__2703__auto__);

(statearr_30107[(1)] = (1));

return statearr_30107;
});
var fluree$db$dbfunctions$internal$state_machine__2703__auto____1 = (function (state_30067){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_30067);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e30108){var ex__2706__auto__ = e30108;
var statearr_30109_30139 = state_30067;
(statearr_30109_30139[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_30067[(4)]))){
var statearr_30110_30140 = state_30067;
(statearr_30110_30140[(1)] = cljs.core.first.call(null,(state_30067[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30141 = state_30067;
state_30067 = G__30141;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2703__auto__ = function(state_30067){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____1.call(this,state_30067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_30111 = f__2726__auto__.call(null);
(statearr_30111[(6)] = c__2725__auto__);

return statearr_30111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__30143 = arguments.length;
switch (G__30143) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_30187){
var state_val_30188 = (state_30187[(1)]);
if((state_val_30188 === (7))){
var inst_30165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30166 = ["*"];
var inst_30167 = (new cljs.core.PersistentVector(null,1,(5),inst_30165,inst_30166,null));
var state_30187__$1 = state_30187;
var statearr_30189_30209 = state_30187__$1;
(statearr_30189_30209[(2)] = inst_30167);

(statearr_30189_30209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (1))){
var state_30187__$1 = state_30187;
var statearr_30190_30210 = state_30187__$1;
(statearr_30190_30210[(2)] = null);

(statearr_30190_30210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (4))){
var inst_30144 = (state_30187[(2)]);
var inst_30145 = fluree.db.dbfunctions.internal.function_error.call(null,inst_30144,"?p","Context Object",additional_params);
var state_30187__$1 = state_30187;
var statearr_30191_30211 = state_30187__$1;
(statearr_30191_30211[(2)] = inst_30145);

(statearr_30191_30211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (6))){
var inst_30157 = cljs.core.PersistentVector.EMPTY;
var inst_30158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30159 = ["*"];
var inst_30160 = (new cljs.core.PersistentVector(null,1,(5),inst_30158,inst_30159,null));
var inst_30161 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_30162 = cljs.core.concat.call(null,inst_30160,inst_30161);
var inst_30163 = cljs.core.into.call(null,inst_30157,inst_30162);
var state_30187__$1 = state_30187;
var statearr_30192_30212 = state_30187__$1;
(statearr_30192_30212[(2)] = inst_30163);

(statearr_30192_30212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (3))){
var inst_30185 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30187__$1,inst_30185);
} else {
if((state_val_30188 === (2))){
var _ = (function (){var statearr_30194 = state_30187;
(statearr_30194[(4)] = cljs.core.cons.call(null,(5),(state_30187[(4)])));

return statearr_30194;
})();
var inst_30154 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30155 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30187__$1 = (function (){var statearr_30195 = state_30187;
(statearr_30195[(7)] = inst_30154);

(statearr_30195[(8)] = inst_30155);

return statearr_30195;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30196_30213 = state_30187__$1;
(statearr_30196_30213[(1)] = (6));

} else {
var statearr_30197_30214 = state_30187__$1;
(statearr_30197_30214[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (9))){
var inst_30176 = (state_30187[(2)]);
var inst_30177 = fluree.db.util.async.throw_err.call(null,inst_30176);
var inst_30178 = cljs.core.nth.call(null,inst_30177,(0),null);
var inst_30179 = cljs.core.nth.call(null,inst_30177,(1),null);
var inst_30180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30181 = [inst_30178,inst_30179];
var inst_30182 = (new cljs.core.PersistentVector(null,2,(5),inst_30180,inst_30181,null));
var _ = (function (){var statearr_30198 = state_30187;
(statearr_30198[(4)] = cljs.core.rest.call(null,(state_30187[(4)])));

return statearr_30198;
})();
var state_30187__$1 = state_30187;
var statearr_30199_30215 = state_30187__$1;
(statearr_30199_30215[(2)] = inst_30182);

(statearr_30199_30215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (5))){
var _ = (function (){var statearr_30200 = state_30187;
(statearr_30200[(4)] = cljs.core.rest.call(null,(state_30187[(4)])));

return statearr_30200;
})();
var state_30187__$1 = state_30187;
var ex30193 = (state_30187__$1[(2)]);
var statearr_30201_30216 = state_30187__$1;
(statearr_30201_30216[(5)] = ex30193);


var statearr_30202_30217 = state_30187__$1;
(statearr_30202_30217[(1)] = (4));

(statearr_30202_30217[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (8))){
var inst_30154 = (state_30187[(7)]);
var inst_30155 = (state_30187[(8)]);
var inst_30169 = (state_30187[(2)]);
var inst_30170 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30171 = cljs.core.PersistentHashMap.EMPTY;
var inst_30172 = [inst_30169,inst_30155,inst_30171];
var inst_30173 = cljs.core.PersistentHashMap.fromArrays(inst_30170,inst_30172);
var inst_30174 = fluree.db.dbfunctions.internal.query.call(null,inst_30154,inst_30173);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30187__$1,(9),inst_30174);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2703__auto____0 = (function (){
var statearr_30203 = [null,null,null,null,null,null,null,null,null];
(statearr_30203[(0)] = fluree$db$dbfunctions$internal$state_machine__2703__auto__);

(statearr_30203[(1)] = (1));

return statearr_30203;
});
var fluree$db$dbfunctions$internal$state_machine__2703__auto____1 = (function (state_30187){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_30187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e30204){var ex__2706__auto__ = e30204;
var statearr_30205_30218 = state_30187;
(statearr_30205_30218[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_30187[(4)]))){
var statearr_30206_30219 = state_30187;
(statearr_30206_30219[(1)] = cljs.core.first.call(null,(state_30187[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30220 = state_30187;
state_30187 = G__30220;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2703__auto__ = function(state_30187){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2703__auto____1.call(this,state_30187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_30207 = f__2726__auto__.call(null);
(statearr_30207[(6)] = c__2725__auto__);

return statearr_30207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_30264){
var state_val_30265 = (state_30264[(1)]);
if((state_val_30265 === (1))){
var state_30264__$1 = state_30264;
var statearr_30266_30280 = state_30264__$1;
(statearr_30266_30280[(2)] = null);

(statearr_30266_30280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (2))){
var _ = (function (){var statearr_30267 = state_30264;
(statearr_30267[(4)] = cljs.core.cons.call(null,(5),(state_30264[(4)])));

return statearr_30267;
})();
var inst_30231 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30233 = ["_user/_auth"];
var inst_30234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30235 = ["*"];
var inst_30236 = (new cljs.core.PersistentVector(null,1,(5),inst_30234,inst_30235,null));
var inst_30237 = [inst_30236];
var inst_30238 = cljs.core.PersistentHashMap.fromArrays(inst_30233,inst_30237);
var inst_30239 = [inst_30238];
var inst_30240 = (new cljs.core.PersistentVector(null,1,(5),inst_30232,inst_30239,null));
var inst_30241 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30242 = cljs.core.PersistentHashMap.EMPTY;
var inst_30243 = [inst_30240,inst_30241,inst_30242];
var inst_30244 = cljs.core.PersistentHashMap.fromArrays(inst_30231,inst_30243);
var inst_30245 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30246 = fluree.db.dbfunctions.internal.query.call(null,inst_30245,inst_30244);
var state_30264__$1 = state_30264;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30264__$1,(6),inst_30246);
} else {
if((state_val_30265 === (3))){
var inst_30262 = (state_30264[(2)]);
var state_30264__$1 = state_30264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30264__$1,inst_30262);
} else {
if((state_val_30265 === (4))){
var inst_30221 = (state_30264[(2)]);
var inst_30222 = fluree.db.dbfunctions.internal.function_error.call(null,inst_30221,"?user_id-from-auth","Context Object");
var state_30264__$1 = state_30264;
var statearr_30269_30281 = state_30264__$1;
(statearr_30269_30281[(2)] = inst_30222);

(statearr_30269_30281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (5))){
var _ = (function (){var statearr_30270 = state_30264;
(statearr_30270[(4)] = cljs.core.rest.call(null,(state_30264[(4)])));

return statearr_30270;
})();
var state_30264__$1 = state_30264;
var ex30268 = (state_30264__$1[(2)]);
var statearr_30271_30282 = state_30264__$1;
(statearr_30271_30282[(5)] = ex30268);


var statearr_30272_30283 = state_30264__$1;
(statearr_30272_30283[(1)] = (4));

(statearr_30272_30283[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (6))){
var inst_30248 = (state_30264[(2)]);
var inst_30249 = fluree.db.util.async.throw_err.call(null,inst_30248);
var inst_30250 = cljs.core.nth.call(null,inst_30249,(0),null);
var inst_30251 = cljs.core.nth.call(null,inst_30249,(1),null);
var inst_30252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30253 = ["_user/_auth","_id"];
var inst_30254 = (new cljs.core.PersistentVector(null,2,(5),inst_30252,inst_30253,null));
var inst_30255 = fluree.db.dbfunctions.internal.get_in.call(null,inst_30250,inst_30254);
var inst_30256 = cljs.core.first.call(null,inst_30255);
var inst_30257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30258 = [inst_30256,inst_30251];
var inst_30259 = (new cljs.core.PersistentVector(null,2,(5),inst_30257,inst_30258,null));
var _ = (function (){var statearr_30273 = state_30264;
(statearr_30273[(4)] = cljs.core.rest.call(null,(state_30264[(4)])));

return statearr_30273;
})();
var state_30264__$1 = state_30264;
var statearr_30274_30284 = state_30264__$1;
(statearr_30274_30284[(2)] = inst_30259);

(statearr_30274_30284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto____0 = (function (){
var statearr_30275 = [null,null,null,null,null,null,null];
(statearr_30275[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto__);

(statearr_30275[(1)] = (1));

return statearr_30275;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto____1 = (function (state_30264){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_30264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e30276){var ex__2706__auto__ = e30276;
var statearr_30277_30285 = state_30264;
(statearr_30277_30285[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_30264[(4)]))){
var statearr_30278_30286 = state_30264;
(statearr_30278_30286[(1)] = cljs.core.first.call(null,(state_30264[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30287 = state_30264;
state_30264 = G__30287;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto__ = function(state_30264){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto____1.call(this,state_30264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_30279 = f__2726__auto__.call(null);
(statearr_30279[(6)] = c__2725__auto__);

return statearr_30279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_30304){
var state_val_30305 = (state_30304[(1)]);
if((state_val_30305 === (1))){
var state_30304__$1 = state_30304;
var statearr_30306_30320 = state_30304__$1;
(statearr_30306_30320[(2)] = null);

(statearr_30306_30320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (2))){
var _ = (function (){var statearr_30307 = state_30304;
(statearr_30307[(4)] = cljs.core.cons.call(null,(5),(state_30304[(4)])));

return statearr_30307;
})();
var inst_30294 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30295 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30296 = fluree.db.dbproto._subid.call(null,inst_30295,inst_30294);
var state_30304__$1 = state_30304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30304__$1,(6),inst_30296);
} else {
if((state_val_30305 === (3))){
var inst_30302 = (state_30304[(2)]);
var state_30304__$1 = state_30304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30304__$1,inst_30302);
} else {
if((state_val_30305 === (4))){
var inst_30288 = (state_30304[(2)]);
var state_30304__$1 = state_30304;
var statearr_30309_30321 = state_30304__$1;
(statearr_30309_30321[(2)] = inst_30288);

(statearr_30309_30321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (5))){
var _ = (function (){var statearr_30310 = state_30304;
(statearr_30310[(4)] = cljs.core.rest.call(null,(state_30304[(4)])));

return statearr_30310;
})();
var state_30304__$1 = state_30304;
var ex30308 = (state_30304__$1[(2)]);
var statearr_30311_30322 = state_30304__$1;
(statearr_30311_30322[(5)] = ex30308);


if((ex30308 instanceof Error)){
var statearr_30312_30323 = state_30304__$1;
(statearr_30312_30323[(1)] = (4));

(statearr_30312_30323[(5)] = null);

} else {
throw ex30308;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (6))){
var inst_30298 = (state_30304[(2)]);
var inst_30299 = fluree.db.util.async.throw_err.call(null,inst_30298);
var _ = (function (){var statearr_30313 = state_30304;
(statearr_30313[(4)] = cljs.core.rest.call(null,(state_30304[(4)])));

return statearr_30313;
})();
var state_30304__$1 = state_30304;
var statearr_30314_30324 = state_30304__$1;
(statearr_30314_30324[(2)] = inst_30299);

(statearr_30314_30324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto____0 = (function (){
var statearr_30315 = [null,null,null,null,null,null,null];
(statearr_30315[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto__);

(statearr_30315[(1)] = (1));

return statearr_30315;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto____1 = (function (state_30304){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_30304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e30316){var ex__2706__auto__ = e30316;
var statearr_30317_30325 = state_30304;
(statearr_30317_30325[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_30304[(4)]))){
var statearr_30318_30326 = state_30304;
(statearr_30318_30326[(1)] = cljs.core.first.call(null,(state_30304[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30327 = state_30304;
state_30304 = G__30327;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto__ = function(state_30304){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto____1.call(this,state_30304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_30319 = f__2726__auto__.call(null);
(statearr_30319[(6)] = c__2725__auto__);

return statearr_30319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__30328_SHARP_){
return p1__30328_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__30329_SHARP_){
return p1__30329_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e30330){var e = e30330;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__30331_SHARP_){
return p1__30331_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__30332_SHARP_){
return p1__30332_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e30333){var e = e30333;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e30334){var e = e30334;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_30414){
var state_val_30415 = (state_30414[(1)]);
if((state_val_30415 === (7))){
var inst_30353 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_30354 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30355 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30356 = cljs.core.PersistentHashMap.fromArrays(inst_30354,inst_30355);
var inst_30357 = cljs.core.ex_info.call(null,inst_30353,inst_30356);
var inst_30358 = (function(){throw inst_30357})();
var state_30414__$1 = state_30414;
var statearr_30416_30451 = state_30414__$1;
(statearr_30416_30451[(2)] = inst_30358);

(statearr_30416_30451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (1))){
var state_30414__$1 = state_30414;
var statearr_30417_30452 = state_30414__$1;
(statearr_30417_30452[(2)] = null);

(statearr_30417_30452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (4))){
var inst_30335 = (state_30414[(2)]);
var state_30414__$1 = state_30414;
var statearr_30418_30453 = state_30414__$1;
(statearr_30418_30453[(2)] = inst_30335);

(statearr_30418_30453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (15))){
var inst_30398 = (state_30414[(7)]);
var inst_30394 = (state_30414[(2)]);
var inst_30395 = fluree.db.util.async.throw_err.call(null,inst_30394);
var inst_30396 = cljs.core.nth.call(null,inst_30395,(0),null);
var inst_30397 = cljs.core.nth.call(null,inst_30395,(1),null);
var inst_30398__$1 = cljs.core.first.call(null,inst_30396);
var inst_30399 = cljs.core._EQ_.call(null,inst_30398__$1,compare_val);
var state_30414__$1 = (function (){var statearr_30419 = state_30414;
(statearr_30419[(7)] = inst_30398__$1);

(statearr_30419[(8)] = inst_30397);

return statearr_30419;
})();
if(inst_30399){
var statearr_30420_30454 = state_30414__$1;
(statearr_30420_30454[(1)] = (16));

} else {
var statearr_30421_30455 = state_30414__$1;
(statearr_30421_30455[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (13))){
var state_30414__$1 = state_30414;
var statearr_30422_30456 = state_30414__$1;
(statearr_30422_30456[(2)] = null);

(statearr_30422_30456[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (6))){
var state_30414__$1 = state_30414;
var statearr_30423_30457 = state_30414__$1;
(statearr_30423_30457[(2)] = null);

(statearr_30423_30457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (17))){
var inst_30398 = (state_30414[(7)]);
var inst_30402 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30398)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_30403 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30404 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30405 = cljs.core.PersistentHashMap.fromArrays(inst_30403,inst_30404);
var inst_30406 = cljs.core.ex_info.call(null,inst_30402,inst_30405);
var inst_30407 = (function(){throw inst_30406})();
var state_30414__$1 = state_30414;
var statearr_30424_30458 = state_30414__$1;
(statearr_30424_30458[(2)] = inst_30407);

(statearr_30424_30458[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (3))){
var inst_30412 = (state_30414[(2)]);
var state_30414__$1 = state_30414;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30414__$1,inst_30412);
} else {
if((state_val_30415 === (12))){
var inst_30350 = (state_30414[(9)]);
var inst_30373 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_30350);
var inst_30374 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30375 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30376 = cljs.core.PersistentHashMap.fromArrays(inst_30374,inst_30375);
var inst_30377 = cljs.core.ex_info.call(null,inst_30373,inst_30376);
var inst_30378 = (function(){throw inst_30377})();
var state_30414__$1 = state_30414;
var statearr_30425_30459 = state_30414__$1;
(statearr_30425_30459[(2)] = inst_30378);

(statearr_30425_30459[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (2))){
var inst_30348 = (state_30414[(10)]);
var inst_30349 = (state_30414[(11)]);
var inst_30347 = (state_30414[(12)]);
var _ = (function (){var statearr_30426 = state_30414;
(statearr_30426[(4)] = cljs.core.cons.call(null,(5),(state_30414[(4)])));

return statearr_30426;
})();
var inst_30345 = _QMARK_ctx;
var inst_30346 = cljs.core.__destructure_map.call(null,inst_30345);
var inst_30347__$1 = cljs.core.get.call(null,inst_30346,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_30348__$1 = cljs.core.get.call(null,inst_30346,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_30349__$1 = cljs.core.get.call(null,inst_30346,new cljs.core.Keyword(null,"db","db",993250759));
var inst_30350 = fluree.db.dbproto._p_prop.call(null,inst_30349__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_30348__$1);
var state_30414__$1 = (function (){var statearr_30427 = state_30414;
(statearr_30427[(10)] = inst_30348__$1);

(statearr_30427[(9)] = inst_30350);

(statearr_30427[(11)] = inst_30349__$1);

(statearr_30427[(12)] = inst_30347__$1);

return statearr_30427;
})();
if(cljs.core.truth_(inst_30347__$1)){
var statearr_30428_30460 = state_30414__$1;
(statearr_30428_30460[(1)] = (6));

} else {
var statearr_30429_30461 = state_30414__$1;
(statearr_30429_30461[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (11))){
var inst_30348 = (state_30414[(10)]);
var inst_30349 = (state_30414[(11)]);
var inst_30370 = (state_30414[(2)]);
var inst_30371 = fluree.db.dbproto._p_prop.call(null,inst_30349,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_30348);
var state_30414__$1 = (function (){var statearr_30431 = state_30414;
(statearr_30431[(13)] = inst_30370);

return statearr_30431;
})();
if(cljs.core.truth_(inst_30371)){
var statearr_30432_30462 = state_30414__$1;
(statearr_30432_30462[(1)] = (12));

} else {
var statearr_30433_30463 = state_30414__$1;
(statearr_30433_30463[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (9))){
var state_30414__$1 = state_30414;
var statearr_30434_30464 = state_30414__$1;
(statearr_30434_30464[(2)] = null);

(statearr_30434_30464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (5))){
var _ = (function (){var statearr_30435 = state_30414;
(statearr_30435[(4)] = cljs.core.rest.call(null,(state_30414[(4)])));

return statearr_30435;
})();
var state_30414__$1 = state_30414;
var ex30430 = (state_30414__$1[(2)]);
var statearr_30436_30465 = state_30414__$1;
(statearr_30436_30465[(5)] = ex30430);


if((ex30430 instanceof Error)){
var statearr_30437_30466 = state_30414__$1;
(statearr_30437_30466[(1)] = (4));

(statearr_30437_30466[(5)] = null);

} else {
throw ex30430;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (14))){
var inst_30350 = (state_30414[(9)]);
var inst_30349 = (state_30414[(11)]);
var inst_30347 = (state_30414[(12)]);
var inst_30381 = (state_30414[(2)]);
var inst_30382 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30385 = [inst_30347,inst_30350,"?current-val"];
var inst_30386 = (new cljs.core.PersistentVector(null,3,(5),inst_30384,inst_30385,null));
var inst_30387 = [inst_30386];
var inst_30388 = (new cljs.core.PersistentVector(null,1,(5),inst_30383,inst_30387,null));
var inst_30389 = cljs.core.PersistentHashMap.EMPTY;
var inst_30390 = ["?current-val",inst_30388,inst_30389];
var inst_30391 = cljs.core.PersistentHashMap.fromArrays(inst_30382,inst_30390);
var inst_30392 = fluree.db.dbfunctions.internal.query.call(null,inst_30349,inst_30391);
var state_30414__$1 = (function (){var statearr_30438 = state_30414;
(statearr_30438[(14)] = inst_30381);

return statearr_30438;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30414__$1,(15),inst_30392);
} else {
if((state_val_30415 === (16))){
var state_30414__$1 = state_30414;
var statearr_30439_30467 = state_30414__$1;
(statearr_30439_30467[(2)] = new_val);

(statearr_30439_30467[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (10))){
var inst_30363 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_30364 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30365 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30366 = cljs.core.PersistentHashMap.fromArrays(inst_30364,inst_30365);
var inst_30367 = cljs.core.ex_info.call(null,inst_30363,inst_30366);
var inst_30368 = (function(){throw inst_30367})();
var state_30414__$1 = state_30414;
var statearr_30440_30468 = state_30414__$1;
(statearr_30440_30468[(2)] = inst_30368);

(statearr_30440_30468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (18))){
var inst_30409 = (state_30414[(2)]);
var _ = (function (){var statearr_30441 = state_30414;
(statearr_30441[(4)] = cljs.core.rest.call(null,(state_30414[(4)])));

return statearr_30441;
})();
var state_30414__$1 = state_30414;
var statearr_30442_30469 = state_30414__$1;
(statearr_30442_30469[(2)] = inst_30409);

(statearr_30442_30469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30415 === (8))){
var inst_30350 = (state_30414[(9)]);
var inst_30360 = (state_30414[(2)]);
var state_30414__$1 = (function (){var statearr_30443 = state_30414;
(statearr_30443[(15)] = inst_30360);

return statearr_30443;
})();
if(cljs.core.truth_(inst_30350)){
var statearr_30444_30470 = state_30414__$1;
(statearr_30444_30470[(1)] = (9));

} else {
var statearr_30445_30471 = state_30414__$1;
(statearr_30445_30471[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto____0 = (function (){
var statearr_30446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30446[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto__);

(statearr_30446[(1)] = (1));

return statearr_30446;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto____1 = (function (state_30414){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_30414);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e30447){var ex__2706__auto__ = e30447;
var statearr_30448_30472 = state_30414;
(statearr_30448_30472[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_30414[(4)]))){
var statearr_30449_30473 = state_30414;
(statearr_30449_30473[(1)] = cljs.core.first.call(null,(state_30414[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30474 = state_30414;
state_30414 = G__30474;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto__ = function(state_30414){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto____1.call(this,state_30414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_30450 = f__2726__auto__.call(null);
(statearr_30450[(6)] = c__2725__auto__);

return statearr_30450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
