// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__27202 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__27202,(0),null);
var network = cljs.core.nth.call(null,vec__27202,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__27202,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__27205){
var map__27206 = p__27205;
var map__27206__$1 = cljs.core.__destructure_map.call(null,map__27206);
var opts = map__27206__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__27206__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_27266){
var state_val_27267 = (state_27266[(1)]);
if((state_val_27267 === (7))){
var inst_27237 = cljs.core.not.call(null,reindex_QMARK_);
var state_27266__$1 = state_27266;
var statearr_27268_27292 = state_27266__$1;
(statearr_27268_27292[(2)] = inst_27237);

(statearr_27268_27292[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (1))){
var state_27266__$1 = state_27266;
var statearr_27269_27293 = state_27266__$1;
(statearr_27269_27293[(2)] = null);

(statearr_27269_27293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (4))){
var inst_27207 = (state_27266[(2)]);
var state_27266__$1 = state_27266;
var statearr_27270_27294 = state_27266__$1;
(statearr_27270_27294[(2)] = inst_27207);

(statearr_27270_27294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (6))){
var inst_27221 = (state_27266[(7)]);
var inst_27227 = (state_27266[(8)]);
var inst_27235 = (state_27266[(9)]);
var inst_27220 = (state_27266[(2)]);
var inst_27221__$1 = fluree.db.util.async.throw_err.call(null,inst_27220);
var inst_27222 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_27223 = cljs.core.__destructure_map.call(null,inst_27222);
var inst_27224 = cljs.core.get.call(null,inst_27223,new cljs.core.Keyword(null,"post","post",269697687));
var inst_27225 = cljs.core.get.call(null,inst_27223,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_27226 = fluree.db.flake.size_bytes.call(null,inst_27221__$1);
var inst_27227__$1 = (inst_27225 + inst_27226);
var inst_27228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27229 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_27230 = (new cljs.core.PersistentVector(null,2,(5),inst_27228,inst_27229,null));
var inst_27231 = cljs.core.get_in.call(null,db,inst_27230);
var inst_27232 = cljs.core.__destructure_map.call(null,inst_27231);
var inst_27233 = cljs.core.get.call(null,inst_27232,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_27234 = cljs.core.get.call(null,inst_27232,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_27235__$1 = (inst_27227__$1 > inst_27234);
var state_27266__$1 = (function (){var statearr_27271 = state_27266;
(statearr_27271[(10)] = inst_27224);

(statearr_27271[(7)] = inst_27221__$1);

(statearr_27271[(11)] = inst_27233);

(statearr_27271[(8)] = inst_27227__$1);

(statearr_27271[(9)] = inst_27235__$1);

return statearr_27271;
})();
if(cljs.core.truth_(inst_27235__$1)){
var statearr_27272_27295 = state_27266__$1;
(statearr_27272_27295[(1)] = (7));

} else {
var statearr_27273_27296 = state_27266__$1;
(statearr_27273_27296[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (3))){
var inst_27264 = (state_27266[(2)]);
var state_27266__$1 = state_27266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27266__$1,inst_27264);
} else {
if((state_val_27267 === (12))){
var inst_27224 = (state_27266[(10)]);
var inst_27221 = (state_27266[(7)]);
var inst_27227 = (state_27266[(8)]);
var inst_27250 = (state_27266[(2)]);
var inst_27251 = cljs.core.into.call(null,inst_27224,inst_27221);
var inst_27252 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_27253 = cljs.core.swap_BANG_.call(null,inst_27252,cljs.core.empty);
var inst_27254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27255 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27256 = (new cljs.core.PersistentVector(null,2,(5),inst_27254,inst_27255,null));
var inst_27257 = cljs.core.assoc_in.call(null,db,inst_27256,inst_27251);
var inst_27258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27259 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27260 = (new cljs.core.PersistentVector(null,2,(5),inst_27258,inst_27259,null));
var inst_27261 = cljs.core.assoc_in.call(null,inst_27257,inst_27260,inst_27227);
var _ = (function (){var statearr_27274 = state_27266;
(statearr_27274[(4)] = cljs.core.rest.call(null,(state_27266[(4)])));

return statearr_27274;
})();
var state_27266__$1 = (function (){var statearr_27275 = state_27266;
(statearr_27275[(12)] = inst_27253);

(statearr_27275[(13)] = inst_27250);

return statearr_27275;
})();
var statearr_27276_27297 = state_27266__$1;
(statearr_27276_27297[(2)] = inst_27261);

(statearr_27276_27297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (2))){
var _ = (function (){var statearr_27277 = state_27266;
(statearr_27277[(4)] = cljs.core.cons.call(null,(5),(state_27266[(4)])));

return statearr_27277;
})();
var inst_27215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27216 = [pred_id];
var inst_27217 = (new cljs.core.PersistentVector(null,1,(5),inst_27215,inst_27216,null));
var inst_27218 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_27217);
var state_27266__$1 = state_27266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27266__$1,(6),inst_27218);
} else {
if((state_val_27267 === (11))){
var state_27266__$1 = state_27266;
var statearr_27279_27298 = state_27266__$1;
(statearr_27279_27298[(2)] = null);

(statearr_27279_27298[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (9))){
var inst_27240 = (state_27266[(2)]);
var state_27266__$1 = state_27266;
if(cljs.core.truth_(inst_27240)){
var statearr_27280_27299 = state_27266__$1;
(statearr_27280_27299[(1)] = (10));

} else {
var statearr_27281_27300 = state_27266__$1;
(statearr_27281_27300[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (5))){
var _ = (function (){var statearr_27282 = state_27266;
(statearr_27282[(4)] = cljs.core.rest.call(null,(state_27266[(4)])));

return statearr_27282;
})();
var state_27266__$1 = state_27266;
var ex27278 = (state_27266__$1[(2)]);
var statearr_27283_27301 = state_27266__$1;
(statearr_27283_27301[(5)] = ex27278);


if((ex27278 instanceof Error)){
var statearr_27284_27302 = state_27266__$1;
(statearr_27284_27302[(1)] = (4));

(statearr_27284_27302[(5)] = null);

} else {
throw ex27278;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (10))){
var inst_27242 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_27243 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_27244 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_27245 = cljs.core.PersistentHashMap.fromArrays(inst_27243,inst_27244);
var inst_27246 = cljs.core.ex_info.call(null,inst_27242,inst_27245);
var inst_27247 = (function(){throw inst_27246})();
var state_27266__$1 = state_27266;
var statearr_27285_27303 = state_27266__$1;
(statearr_27285_27303[(2)] = inst_27247);

(statearr_27285_27303[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27267 === (8))){
var inst_27235 = (state_27266[(9)]);
var state_27266__$1 = state_27266;
var statearr_27286_27304 = state_27266__$1;
(statearr_27286_27304[(2)] = inst_27235);

(statearr_27286_27304[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto____0 = (function (){
var statearr_27287 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27287[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto__);

(statearr_27287[(1)] = (1));

return statearr_27287;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto____1 = (function (state_27266){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_27266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e27288){var ex__2706__auto__ = e27288;
var statearr_27289_27305 = state_27266;
(statearr_27289_27305[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_27266[(4)]))){
var statearr_27290_27306 = state_27266;
(statearr_27290_27306[(1)] = cljs.core.first.call(null,(state_27266[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27307 = state_27266;
state_27266 = G__27307;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto__ = function(state_27266){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto____1.call(this,state_27266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_27291 = f__2726__auto__.call(null);
(statearr_27291[(6)] = c__2725__auto__);

return statearr_27291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__27312 = arguments.length;
switch (G__27312) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_27508){
var state_val_27509 = (state_27508[(1)]);
if((state_val_27509 === (7))){
var state_27508__$1 = state_27508;
var statearr_27510_27577 = state_27508__$1;
(statearr_27510_27577[(2)] = null);

(statearr_27510_27577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (20))){
var inst_27430 = (state_27508[(7)]);
var inst_27351 = (state_27508[(8)]);
var inst_27433 = (state_27508[(9)]);
var inst_27350 = (state_27508[(10)]);
var inst_27432 = (state_27508[(11)]);
var inst_27434 = (state_27508[(12)]);
var inst_27431 = (state_27508[(13)]);
var inst_27401 = (state_27508[(14)]);
var inst_27444 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27446 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27447 = (new cljs.core.PersistentVector(null,2,(5),inst_27445,inst_27446,null));
var inst_27448 = cljs.core.get_in.call(null,inst_27401,inst_27447);
var inst_27449 = (inst_27350 + inst_27448);
var inst_27450 = [inst_27430,inst_27431,inst_27432,inst_27433,inst_27449];
var inst_27451 = cljs.core.PersistentHashMap.fromArrays(inst_27444,inst_27450);
var inst_27452 = cljs.core.assoc.call(null,inst_27401,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_27434,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_27451);
var state_27508__$1 = (function (){var statearr_27511 = state_27508;
(statearr_27511[(15)] = inst_27452);

return statearr_27511;
})();
if(cljs.core.truth_(inst_27351)){
var statearr_27512_27578 = state_27508__$1;
(statearr_27512_27578[(1)] = (23));

} else {
var statearr_27513_27579 = state_27508__$1;
(statearr_27513_27579[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (27))){
var inst_27452 = (state_27508[(15)]);
var state_27508__$1 = state_27508;
var statearr_27514_27580 = state_27508__$1;
(statearr_27514_27580[(2)] = inst_27452);

(statearr_27514_27580[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (1))){
var state_27508__$1 = state_27508;
var statearr_27515_27581 = state_27508__$1;
(statearr_27515_27581[(2)] = null);

(statearr_27515_27581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (24))){
var inst_27452 = (state_27508[(15)]);
var inst_27455 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_27452);
var inst_27456 = (inst_27455 == null);
var state_27508__$1 = state_27508;
var statearr_27516_27582 = state_27508__$1;
(statearr_27516_27582[(2)] = inst_27456);

(statearr_27516_27582[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (39))){
var inst_27482 = (state_27508[(16)]);
var inst_27491 = (state_27508[(17)]);
var inst_27484 = (state_27508[(18)]);
var inst_27441 = (state_27508[(19)]);
var inst_27483 = (state_27508[(20)]);
var inst_27498 = (state_27508[(2)]);
var inst_27429 = inst_27441;
var inst_27430 = inst_27483;
var inst_27431 = inst_27484;
var inst_27432 = inst_27491;
var inst_27433 = inst_27498;
var inst_27434 = inst_27482;
var state_27508__$1 = (function (){var statearr_27517 = state_27508;
(statearr_27517[(7)] = inst_27430);

(statearr_27517[(9)] = inst_27433);

(statearr_27517[(11)] = inst_27432);

(statearr_27517[(12)] = inst_27434);

(statearr_27517[(21)] = inst_27429);

(statearr_27517[(13)] = inst_27431);

return statearr_27517;
})();
var statearr_27518_27583 = state_27508__$1;
(statearr_27518_27583[(2)] = null);

(statearr_27518_27583[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (4))){
var inst_27313 = (state_27508[(2)]);
var state_27508__$1 = state_27508;
var statearr_27519_27584 = state_27508__$1;
(statearr_27519_27584[(2)] = inst_27313);

(statearr_27519_27584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (15))){
var inst_27373 = (state_27508[(22)]);
var state_27508__$1 = state_27508;
var statearr_27520_27585 = state_27508__$1;
(statearr_27520_27585[(2)] = inst_27373);

(statearr_27520_27585[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (21))){
var inst_27341 = (state_27508[(23)]);
var inst_27411 = (state_27508[(24)]);
var inst_27335 = (state_27508[(25)]);
var inst_27320 = (state_27508[(26)]);
var inst_27410 = (state_27508[(27)]);
var inst_27440 = (state_27508[(28)]);
var inst_27337 = (state_27508[(29)]);
var inst_27352 = (state_27508[(30)]);
var inst_27345 = (state_27508[(31)]);
var inst_27430 = (state_27508[(7)]);
var inst_27351 = (state_27508[(8)]);
var inst_27433 = (state_27508[(9)]);
var inst_27350 = (state_27508[(10)]);
var inst_27432 = (state_27508[(11)]);
var inst_27434 = (state_27508[(12)]);
var inst_27429 = (state_27508[(21)]);
var inst_27431 = (state_27508[(13)]);
var inst_27349 = (state_27508[(32)]);
var inst_27354 = (state_27508[(33)]);
var inst_27441 = (state_27508[(19)]);
var inst_27401 = (state_27508[(14)]);
var inst_27360 = (state_27508[(34)]);
var inst_27479 = inst_27440.s;
var inst_27480 = fluree.db.flake.sid__GT_cid.call(null,inst_27479);
var inst_27481 = (function (){var flakes_bytes = inst_27350;
var seq__27407 = inst_27411;
var t = inst_27320;
var G__27405 = inst_27429;
var spot = inst_27430;
var add_flakes = inst_27337;
var vec__27406 = inst_27337;
var root_setting_change_QMARK_ = inst_27352;
var ref_QMARK__map = inst_27349;
var r = inst_27441;
var psot = inst_27431;
var first__27408 = inst_27410;
var add_pred_to_idx_QMARK_ = inst_27360;
var _ = inst_27335;
var cid = inst_27480;
var ecount = inst_27434;
var pred_ecount = inst_27354;
var db_STAR_ = inst_27401;
var schema_change_QMARK_ = inst_27351;
var vec__27436 = inst_27429;
var add_preds = inst_27341;
var first__27438 = inst_27440;
var opst = inst_27433;
var seq__27437 = inst_27441;
var idx_QMARK__map = inst_27345;
var post = inst_27432;
var f = inst_27440;
return (function (p1__27310_SHARP_){
if(cljs.core.truth_(p1__27310_SHARP_)){
var x__5130__auto__ = p1__27310_SHARP_;
var y__5131__auto__ = f.s;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return f.s;
}
});
})();
var inst_27482 = cljs.core.update.call(null,inst_27434,inst_27480,inst_27481);
var inst_27483 = cljs.core.conj.call(null,inst_27430,inst_27440);
var inst_27484 = cljs.core.conj.call(null,inst_27431,inst_27440);
var inst_27485 = inst_27440.p;
var inst_27486 = cljs.core.get.call(null,inst_27345,inst_27485);
var state_27508__$1 = (function (){var statearr_27521 = state_27508;
(statearr_27521[(16)] = inst_27482);

(statearr_27521[(18)] = inst_27484);

(statearr_27521[(20)] = inst_27483);

return statearr_27521;
})();
if(cljs.core.truth_(inst_27486)){
var statearr_27522_27586 = state_27508__$1;
(statearr_27522_27586[(1)] = (34));

} else {
var statearr_27523_27587 = state_27508__$1;
(statearr_27523_27587[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (31))){
var inst_27467 = (state_27508[(35)]);
var state_27508__$1 = state_27508;
var statearr_27524_27588 = state_27508__$1;
(statearr_27524_27588[(2)] = inst_27467);

(statearr_27524_27588[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (32))){
var inst_27477 = (state_27508[(2)]);
var state_27508__$1 = state_27508;
var statearr_27525_27589 = state_27508__$1;
(statearr_27525_27589[(2)] = inst_27477);

(statearr_27525_27589[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (33))){
var inst_27467 = (state_27508[(35)]);
var inst_27472 = (state_27508[(2)]);
var inst_27473 = fluree.db.util.async.throw_err.call(null,inst_27472);
var inst_27474 = cljs.core.assoc.call(null,inst_27467,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27473);
var state_27508__$1 = state_27508;
var statearr_27526_27590 = state_27508__$1;
(statearr_27526_27590[(2)] = inst_27474);

(statearr_27526_27590[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (13))){
var inst_27320 = (state_27508[(26)]);
var inst_27337 = (state_27508[(29)]);
var inst_27350 = (state_27508[(10)]);
var inst_27401 = (state_27508[(14)]);
var inst_27391 = (state_27508[(2)]);
var inst_27392 = cljs.core.assoc.call(null,inst_27391,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27320);
var inst_27393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27394 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27395 = (new cljs.core.PersistentVector(null,2,(5),inst_27393,inst_27394,null));
var inst_27396 = cljs.core.update_in.call(null,inst_27392,inst_27395,cljs.core._PLUS_,inst_27350);
var inst_27397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27398 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_27399 = (new cljs.core.PersistentVector(null,2,(5),inst_27397,inst_27398,null));
var inst_27400 = cljs.core.count.call(null,inst_27337);
var inst_27401__$1 = cljs.core.update_in.call(null,inst_27396,inst_27399,cljs.core._PLUS_,inst_27400);
var inst_27409 = cljs.core.seq.call(null,inst_27337);
var inst_27410 = cljs.core.first.call(null,inst_27409);
var inst_27411 = cljs.core.next.call(null,inst_27409);
var inst_27412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27413 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_27414 = (new cljs.core.PersistentVector(null,2,(5),inst_27412,inst_27413,null));
var inst_27415 = cljs.core.get_in.call(null,inst_27401__$1,inst_27414);
var inst_27416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27417 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_27418 = (new cljs.core.PersistentVector(null,2,(5),inst_27416,inst_27417,null));
var inst_27419 = cljs.core.get_in.call(null,inst_27401__$1,inst_27418);
var inst_27420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27421 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27422 = (new cljs.core.PersistentVector(null,2,(5),inst_27420,inst_27421,null));
var inst_27423 = cljs.core.get_in.call(null,inst_27401__$1,inst_27422);
var inst_27424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27425 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27426 = (new cljs.core.PersistentVector(null,2,(5),inst_27424,inst_27425,null));
var inst_27427 = cljs.core.get_in.call(null,inst_27401__$1,inst_27426);
var inst_27428 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27429 = inst_27337;
var inst_27430 = inst_27415;
var inst_27431 = inst_27419;
var inst_27432 = inst_27423;
var inst_27433 = inst_27427;
var inst_27434 = inst_27428;
var state_27508__$1 = (function (){var statearr_27527 = state_27508;
(statearr_27527[(24)] = inst_27411);

(statearr_27527[(27)] = inst_27410);

(statearr_27527[(7)] = inst_27430);

(statearr_27527[(9)] = inst_27433);

(statearr_27527[(11)] = inst_27432);

(statearr_27527[(12)] = inst_27434);

(statearr_27527[(21)] = inst_27429);

(statearr_27527[(13)] = inst_27431);

(statearr_27527[(14)] = inst_27401__$1);

return statearr_27527;
})();
var statearr_27528_27591 = state_27508__$1;
(statearr_27528_27591[(2)] = null);

(statearr_27528_27591[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (22))){
var inst_27501 = (state_27508[(2)]);
var state_27508__$1 = state_27508;
var statearr_27529_27592 = state_27508__$1;
(statearr_27529_27592[(2)] = inst_27501);

(statearr_27529_27592[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (36))){
var inst_27440 = (state_27508[(28)]);
var inst_27349 = (state_27508[(32)]);
var inst_27491 = (state_27508[(2)]);
var inst_27492 = inst_27440.p;
var inst_27493 = cljs.core.get.call(null,inst_27349,inst_27492);
var state_27508__$1 = (function (){var statearr_27530 = state_27508;
(statearr_27530[(17)] = inst_27491);

return statearr_27530;
})();
if(cljs.core.truth_(inst_27493)){
var statearr_27531_27593 = state_27508__$1;
(statearr_27531_27593[(1)] = (37));

} else {
var statearr_27532_27594 = state_27508__$1;
(statearr_27532_27594[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (29))){
var inst_27452 = (state_27508[(15)]);
var inst_27462 = (state_27508[(2)]);
var inst_27463 = fluree.db.util.async.throw_err.call(null,inst_27462);
var inst_27464 = cljs.core.assoc.call(null,inst_27452,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27463);
var state_27508__$1 = state_27508;
var statearr_27533_27595 = state_27508__$1;
(statearr_27533_27595[(2)] = inst_27464);

(statearr_27533_27595[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (6))){
var inst_27320 = (state_27508[(26)]);
var inst_27325 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27326 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27327 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27325)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27326)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27320),"."].join('');
var inst_27328 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27329 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27330 = cljs.core.PersistentHashMap.fromArrays(inst_27328,inst_27329);
var inst_27331 = cljs.core.ex_info.call(null,inst_27327,inst_27330);
var inst_27332 = (function(){throw inst_27331})();
var state_27508__$1 = state_27508;
var statearr_27534_27596 = state_27508__$1;
(statearr_27534_27596[(2)] = inst_27332);

(statearr_27534_27596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (28))){
var inst_27352 = (state_27508[(30)]);
var inst_27467 = (state_27508[(2)]);
var state_27508__$1 = (function (){var statearr_27535 = state_27508;
(statearr_27535[(35)] = inst_27467);

return statearr_27535;
})();
if(cljs.core.truth_(inst_27352)){
var statearr_27536_27597 = state_27508__$1;
(statearr_27536_27597[(1)] = (30));

} else {
var statearr_27537_27598 = state_27508__$1;
(statearr_27537_27598[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (25))){
var inst_27458 = (state_27508[(2)]);
var state_27508__$1 = state_27508;
if(cljs.core.truth_(inst_27458)){
var statearr_27538_27599 = state_27508__$1;
(statearr_27538_27599[(1)] = (26));

} else {
var statearr_27539_27600 = state_27508__$1;
(statearr_27539_27600[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (34))){
var inst_27440 = (state_27508[(28)]);
var inst_27432 = (state_27508[(11)]);
var inst_27488 = cljs.core.conj.call(null,inst_27432,inst_27440);
var state_27508__$1 = state_27508;
var statearr_27540_27601 = state_27508__$1;
(statearr_27540_27601[(2)] = inst_27488);

(statearr_27540_27601[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (17))){
var inst_27380 = (state_27508[(36)]);
var inst_27384 = (state_27508[(2)]);
var inst_27385 = fluree.db.util.async.throw_err.call(null,inst_27384);
var inst_27372 = inst_27380;
var inst_27373 = inst_27385;
var state_27508__$1 = (function (){var statearr_27541 = state_27508;
(statearr_27541[(22)] = inst_27373);

(statearr_27541[(37)] = inst_27372);

return statearr_27541;
})();
var statearr_27542_27602 = state_27508__$1;
(statearr_27542_27602[(2)] = null);

(statearr_27542_27602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (3))){
var inst_27506 = (state_27508[(2)]);
var state_27508__$1 = state_27508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27508__$1,inst_27506);
} else {
if((state_val_27509 === (12))){
var inst_27379 = (state_27508[(38)]);
var inst_27372 = (state_27508[(37)]);
var inst_27378 = cljs.core.seq.call(null,inst_27372);
var inst_27379__$1 = cljs.core.first.call(null,inst_27378);
var inst_27380 = cljs.core.next.call(null,inst_27378);
var state_27508__$1 = (function (){var statearr_27543 = state_27508;
(statearr_27543[(38)] = inst_27379__$1);

(statearr_27543[(36)] = inst_27380);

return statearr_27543;
})();
if(cljs.core.truth_(inst_27379__$1)){
var statearr_27544_27603 = state_27508__$1;
(statearr_27544_27603[(1)] = (14));

} else {
var statearr_27545_27604 = state_27508__$1;
(statearr_27545_27604[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (2))){
var inst_27320 = (state_27508[(26)]);
var _ = (function (){var statearr_27546 = state_27508;
(statearr_27546[(4)] = cljs.core.cons.call(null,(5),(state_27508[(4)])));

return statearr_27546;
})();
var inst_27319 = cljs.core.first.call(null,flakes);
var inst_27320__$1 = inst_27319.t;
var inst_27321 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27322 = (inst_27321 - (1));
var inst_27323 = cljs.core.not_EQ_.call(null,inst_27320__$1,inst_27322);
var state_27508__$1 = (function (){var statearr_27547 = state_27508;
(statearr_27547[(26)] = inst_27320__$1);

return statearr_27547;
})();
if(inst_27323){
var statearr_27548_27605 = state_27508__$1;
(statearr_27548_27605[(1)] = (6));

} else {
var statearr_27549_27606 = state_27508__$1;
(statearr_27549_27606[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (23))){
var inst_27351 = (state_27508[(8)]);
var state_27508__$1 = state_27508;
var statearr_27550_27607 = state_27508__$1;
(statearr_27550_27607[(2)] = inst_27351);

(statearr_27550_27607[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (35))){
var inst_27432 = (state_27508[(11)]);
var state_27508__$1 = state_27508;
var statearr_27551_27608 = state_27508__$1;
(statearr_27551_27608[(2)] = inst_27432);

(statearr_27551_27608[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (19))){
var inst_27503 = (state_27508[(2)]);
var _ = (function (){var statearr_27552 = state_27508;
(statearr_27552[(4)] = cljs.core.rest.call(null,(state_27508[(4)])));

return statearr_27552;
})();
var state_27508__$1 = state_27508;
var statearr_27553_27609 = state_27508__$1;
(statearr_27553_27609[(2)] = inst_27503);

(statearr_27553_27609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (11))){
var inst_27360 = (state_27508[(34)]);
var inst_27360__$1 = (state_27508[(2)]);
var inst_27368 = cljs.core.seq.call(null,inst_27360__$1);
var inst_27369 = cljs.core.first.call(null,inst_27368);
var inst_27370 = cljs.core.next.call(null,inst_27368);
var inst_27371 = db;
var inst_27372 = inst_27360__$1;
var inst_27373 = inst_27371;
var state_27508__$1 = (function (){var statearr_27555 = state_27508;
(statearr_27555[(22)] = inst_27373);

(statearr_27555[(39)] = inst_27370);

(statearr_27555[(37)] = inst_27372);

(statearr_27555[(34)] = inst_27360__$1);

(statearr_27555[(40)] = inst_27369);

return statearr_27555;
})();
var statearr_27556_27610 = state_27508__$1;
(statearr_27556_27610[(2)] = null);

(statearr_27556_27610[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (9))){
var inst_27337 = (state_27508[(29)]);
var inst_27354 = (state_27508[(33)]);
var inst_27356 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_27337,inst_27354);
var state_27508__$1 = state_27508;
var statearr_27557_27611 = state_27508__$1;
(statearr_27557_27611[(2)] = inst_27356);

(statearr_27557_27611[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (5))){
var _ = (function (){var statearr_27558 = state_27508;
(statearr_27558[(4)] = cljs.core.rest.call(null,(state_27508[(4)])));

return statearr_27558;
})();
var state_27508__$1 = state_27508;
var ex27554 = (state_27508__$1[(2)]);
var statearr_27559_27612 = state_27508__$1;
(statearr_27559_27612[(5)] = ex27554);


if((ex27554 instanceof Error)){
var statearr_27560_27613 = state_27508__$1;
(statearr_27560_27613[(1)] = (4));

(statearr_27560_27613[(5)] = null);

} else {
throw ex27554;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (14))){
var inst_27373 = (state_27508[(22)]);
var inst_27379 = (state_27508[(38)]);
var inst_27382 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_27373,inst_27379,opts);
var state_27508__$1 = state_27508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27508__$1,(17),inst_27382);
} else {
if((state_val_27509 === (26))){
var inst_27452 = (state_27508[(15)]);
var inst_27460 = fluree.db.query.schema.schema_map.call(null,inst_27452);
var state_27508__$1 = state_27508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27508__$1,(29),inst_27460);
} else {
if((state_val_27509 === (16))){
var inst_27389 = (state_27508[(2)]);
var state_27508__$1 = state_27508;
var statearr_27561_27614 = state_27508__$1;
(statearr_27561_27614[(2)] = inst_27389);

(statearr_27561_27614[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (38))){
var inst_27433 = (state_27508[(9)]);
var state_27508__$1 = state_27508;
var statearr_27562_27615 = state_27508__$1;
(statearr_27562_27615[(2)] = inst_27433);

(statearr_27562_27615[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (30))){
var inst_27467 = (state_27508[(35)]);
var inst_27470 = fluree.db.query.schema.setting_map.call(null,inst_27467);
var state_27508__$1 = state_27508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27508__$1,(33),inst_27470);
} else {
if((state_val_27509 === (10))){
var inst_27358 = cljs.core.PersistentVector.EMPTY;
var state_27508__$1 = state_27508;
var statearr_27563_27616 = state_27508__$1;
(statearr_27563_27616[(2)] = inst_27358);

(statearr_27563_27616[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (18))){
var inst_27440 = (state_27508[(28)]);
var inst_27429 = (state_27508[(21)]);
var inst_27439 = cljs.core.seq.call(null,inst_27429);
var inst_27440__$1 = cljs.core.first.call(null,inst_27439);
var inst_27441 = cljs.core.next.call(null,inst_27439);
var inst_27442 = cljs.core.not.call(null,inst_27440__$1);
var state_27508__$1 = (function (){var statearr_27564 = state_27508;
(statearr_27564[(28)] = inst_27440__$1);

(statearr_27564[(19)] = inst_27441);

return statearr_27564;
})();
if(inst_27442){
var statearr_27565_27617 = state_27508__$1;
(statearr_27565_27617[(1)] = (20));

} else {
var statearr_27566_27618 = state_27508__$1;
(statearr_27566_27618[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (37))){
var inst_27440 = (state_27508[(28)]);
var inst_27433 = (state_27508[(9)]);
var inst_27495 = cljs.core.conj.call(null,inst_27433,inst_27440);
var state_27508__$1 = state_27508;
var statearr_27567_27619 = state_27508__$1;
(statearr_27567_27619[(2)] = inst_27495);

(statearr_27567_27619[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27509 === (8))){
var inst_27341 = (state_27508[(23)]);
var inst_27335 = (state_27508[(25)]);
var inst_27320 = (state_27508[(26)]);
var inst_27337 = (state_27508[(29)]);
var inst_27345 = (state_27508[(31)]);
var inst_27351 = (state_27508[(8)]);
var inst_27335__$1 = (state_27508[(2)]);
var inst_27336 = (function (){var t = inst_27320;
var _ = inst_27335__$1;
return (function (p1__27308_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__27308_SHARP_.p));
});
})();
var inst_27337__$1 = cljs.core.filter.call(null,inst_27336,flakes);
var inst_27338 = cljs.core.PersistentHashSet.EMPTY;
var inst_27339 = (function (){var t = inst_27320;
var _ = inst_27335__$1;
var add_flakes = inst_27337__$1;
return (function (p1__27309_SHARP_){
return p1__27309_SHARP_.p;
});
})();
var inst_27340 = cljs.core.map.call(null,inst_27339,inst_27337__$1);
var inst_27341__$1 = cljs.core.into.call(null,inst_27338,inst_27340);
var inst_27342 = cljs.core.PersistentHashMap.EMPTY;
var inst_27343 = (function (){var t = inst_27320;
var _ = inst_27335__$1;
var add_flakes = inst_27337__$1;
var add_preds = inst_27341__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_27344 = cljs.core.map.call(null,inst_27343,inst_27341__$1);
var inst_27345__$1 = cljs.core.into.call(null,inst_27342,inst_27344);
var inst_27346 = cljs.core.PersistentHashMap.EMPTY;
var inst_27347 = (function (){var t = inst_27320;
var _ = inst_27335__$1;
var add_flakes = inst_27337__$1;
var add_preds = inst_27341__$1;
var idx_QMARK__map = inst_27345__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_27348 = cljs.core.map.call(null,inst_27347,inst_27341__$1);
var inst_27349 = cljs.core.into.call(null,inst_27346,inst_27348);
var inst_27350 = fluree.db.flake.size_bytes.call(null,inst_27337__$1);
var inst_27351__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_27337__$1);
var inst_27352 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_27337__$1);
var inst_27353 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27354 = cljs.core.get.call(null,inst_27353,(0));
var state_27508__$1 = (function (){var statearr_27568 = state_27508;
(statearr_27568[(23)] = inst_27341__$1);

(statearr_27568[(25)] = inst_27335__$1);

(statearr_27568[(29)] = inst_27337__$1);

(statearr_27568[(30)] = inst_27352);

(statearr_27568[(31)] = inst_27345__$1);

(statearr_27568[(8)] = inst_27351__$1);

(statearr_27568[(10)] = inst_27350);

(statearr_27568[(32)] = inst_27349);

(statearr_27568[(33)] = inst_27354);

return statearr_27568;
})();
if(cljs.core.truth_(inst_27351__$1)){
var statearr_27569_27620 = state_27508__$1;
(statearr_27569_27620[(1)] = (9));

} else {
var statearr_27570_27621 = state_27508__$1;
(statearr_27570_27621[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2703__auto__ = null;
var fluree$db$graphdb$state_machine__2703__auto____0 = (function (){
var statearr_27571 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27571[(0)] = fluree$db$graphdb$state_machine__2703__auto__);

(statearr_27571[(1)] = (1));

return statearr_27571;
});
var fluree$db$graphdb$state_machine__2703__auto____1 = (function (state_27508){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_27508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e27572){var ex__2706__auto__ = e27572;
var statearr_27573_27622 = state_27508;
(statearr_27573_27622[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_27508[(4)]))){
var statearr_27574_27623 = state_27508;
(statearr_27574_27623[(1)] = cljs.core.first.call(null,(state_27508[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27624 = state_27508;
state_27508 = G__27624;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2703__auto__ = function(state_27508){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2703__auto____1.call(this,state_27508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2703__auto____0;
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2703__auto____1;
return fluree$db$graphdb$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_27575 = f__2726__auto__.call(null);
(statearr_27575[(6)] = c__2725__auto__);

return statearr_27575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__27626 = arguments.length;
switch (G__27626) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2725__auto___27773 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_27722){
var state_val_27723 = (state_27722[(1)]);
if((state_val_27723 === (7))){
var state_27722__$1 = state_27722;
var statearr_27724_27774 = state_27722__$1;
(statearr_27724_27774[(2)] = null);

(statearr_27724_27774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (20))){
var inst_27670 = (state_27722[(7)]);
var inst_27672 = (state_27722[(8)]);
var inst_27671 = (state_27722[(9)]);
var inst_27691 = (inst_27670 + (1));
var inst_27692 = cljs.core.assoc.call(null,inst_27672,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27691);
var inst_27693 = fluree.db.graphdb.with_t.call(null,inst_27692,inst_27671,opts);
var state_27722__$1 = state_27722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27722__$1,(23),inst_27693);
} else {
if((state_val_27723 === (1))){
var state_27722__$1 = state_27722;
var statearr_27725_27775 = state_27722__$1;
(statearr_27725_27775[(2)] = null);

(statearr_27725_27775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (24))){
var inst_27696 = (state_27722[(10)]);
var inst_27699 = cljs.core.assoc.call(null,inst_27696,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_27722__$1 = state_27722;
var statearr_27726_27776 = state_27722__$1;
(statearr_27726_27776[(2)] = inst_27699);

(statearr_27726_27776[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (4))){
var inst_27627 = (state_27722[(2)]);
var inst_27628 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_27627);
var state_27722__$1 = state_27722;
var statearr_27727_27777 = state_27722__$1;
(statearr_27727_27777[(2)] = inst_27628);

(statearr_27727_27777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (15))){
var inst_27678 = (state_27722[(11)]);
var state_27722__$1 = state_27722;
var statearr_27728_27778 = state_27722__$1;
(statearr_27728_27778[(2)] = inst_27678);

(statearr_27728_27778[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (21))){
var state_27722__$1 = state_27722;
var statearr_27729_27779 = state_27722__$1;
(statearr_27729_27779[(2)] = null);

(statearr_27729_27779[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (13))){
var inst_27714 = (state_27722[(2)]);
var inst_27715 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_27714);
var state_27722__$1 = state_27722;
var statearr_27730_27780 = state_27722__$1;
(statearr_27730_27780[(2)] = inst_27715);

(statearr_27730_27780[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (22))){
var inst_27710 = (state_27722[(2)]);
var state_27722__$1 = state_27722;
var statearr_27731_27781 = state_27722__$1;
(statearr_27731_27781[(2)] = inst_27710);

(statearr_27731_27781[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (6))){
var inst_27638 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27639 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27640 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27638)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27639)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27641 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27642 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27643 = cljs.core.PersistentHashMap.fromArrays(inst_27641,inst_27642);
var inst_27644 = cljs.core.ex_info.call(null,inst_27640,inst_27643);
var inst_27645 = (function(){throw inst_27644})();
var state_27722__$1 = state_27722;
var statearr_27734_27782 = state_27722__$1;
(statearr_27734_27782[(2)] = inst_27645);

(statearr_27734_27782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (25))){
var inst_27679 = (state_27722[(12)]);
var inst_27678 = (state_27722[(11)]);
var inst_27696 = (state_27722[(10)]);
var inst_27701 = inst_27678.t;
var inst_27702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27703 = [inst_27678];
var inst_27704 = (new cljs.core.PersistentVector(null,1,(5),inst_27702,inst_27703,null));
var inst_27669 = inst_27679;
var inst_27670 = inst_27701;
var inst_27671 = inst_27704;
var inst_27672 = inst_27696;
var state_27722__$1 = (function (){var statearr_27735 = state_27722;
(statearr_27735[(7)] = inst_27670);

(statearr_27735[(13)] = inst_27669);

(statearr_27735[(8)] = inst_27672);

(statearr_27735[(9)] = inst_27671);

return statearr_27735;
})();
var statearr_27736_27783 = state_27722__$1;
(statearr_27736_27783[(2)] = null);

(statearr_27736_27783[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (17))){
var inst_27670 = (state_27722[(7)]);
var inst_27679 = (state_27722[(12)]);
var inst_27678 = (state_27722[(11)]);
var inst_27672 = (state_27722[(8)]);
var inst_27671 = (state_27722[(9)]);
var inst_27687 = cljs.core.conj.call(null,inst_27671,inst_27678);
var tmp27732 = inst_27670;
var tmp27733 = inst_27672;
var inst_27669 = inst_27679;
var inst_27670__$1 = tmp27732;
var inst_27671__$1 = inst_27687;
var inst_27672__$1 = tmp27733;
var state_27722__$1 = (function (){var statearr_27737 = state_27722;
(statearr_27737[(7)] = inst_27670__$1);

(statearr_27737[(13)] = inst_27669);

(statearr_27737[(8)] = inst_27672__$1);

(statearr_27737[(9)] = inst_27671__$1);

return statearr_27737;
})();
var statearr_27738_27784 = state_27722__$1;
(statearr_27738_27784[(2)] = null);

(statearr_27738_27784[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (3))){
var inst_27720 = (state_27722[(2)]);
var state_27722__$1 = state_27722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27722__$1,inst_27720);
} else {
if((state_val_27723 === (12))){
var inst_27669 = (state_27722[(13)]);
var inst_27678 = (state_27722[(11)]);
var inst_27677 = cljs.core.seq.call(null,inst_27669);
var inst_27678__$1 = cljs.core.first.call(null,inst_27677);
var inst_27679 = cljs.core.next.call(null,inst_27677);
var state_27722__$1 = (function (){var statearr_27739 = state_27722;
(statearr_27739[(12)] = inst_27679);

(statearr_27739[(11)] = inst_27678__$1);

return statearr_27739;
})();
if(cljs.core.truth_(inst_27678__$1)){
var statearr_27740_27785 = state_27722__$1;
(statearr_27740_27785[(1)] = (14));

} else {
var statearr_27741_27786 = state_27722__$1;
(statearr_27741_27786[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (2))){
var _ = (function (){var statearr_27742 = state_27722;
(statearr_27742[(4)] = cljs.core.cons.call(null,(5),(state_27722[(4)])));

return statearr_27742;
})();
var inst_27634 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27635 = (inst_27634 + (1));
var inst_27636 = cljs.core.not_EQ_.call(null,block,inst_27635);
var state_27722__$1 = state_27722;
if(inst_27636){
var statearr_27743_27787 = state_27722__$1;
(statearr_27743_27787[(1)] = (6));

} else {
var statearr_27744_27788 = state_27722__$1;
(statearr_27744_27788[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (23))){
var inst_27678 = (state_27722[(11)]);
var inst_27695 = (state_27722[(2)]);
var inst_27696 = fluree.db.util.async.throw_err.call(null,inst_27695);
var inst_27697 = (inst_27678 == null);
var state_27722__$1 = (function (){var statearr_27745 = state_27722;
(statearr_27745[(10)] = inst_27696);

return statearr_27745;
})();
if(cljs.core.truth_(inst_27697)){
var statearr_27746_27789 = state_27722__$1;
(statearr_27746_27789[(1)] = (24));

} else {
var statearr_27747_27790 = state_27722__$1;
(statearr_27747_27790[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (19))){
var inst_27712 = (state_27722[(2)]);
var state_27722__$1 = state_27722;
var statearr_27748_27791 = state_27722__$1;
(statearr_27748_27791[(2)] = inst_27712);

(statearr_27748_27791[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (11))){
var inst_27717 = (state_27722[(2)]);
var _ = (function (){var statearr_27750 = state_27722;
(statearr_27750[(4)] = cljs.core.rest.call(null,(state_27722[(4)])));

return statearr_27750;
})();
var state_27722__$1 = state_27722;
var statearr_27751_27792 = state_27722__$1;
(statearr_27751_27792[(2)] = inst_27717);

(statearr_27751_27792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (9))){
var inst_27651 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_27652 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_27651);
var state_27722__$1 = state_27722;
var statearr_27752_27793 = state_27722__$1;
(statearr_27752_27793[(2)] = inst_27652);

(statearr_27752_27793[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (5))){
var _ = (function (){var statearr_27753 = state_27722;
(statearr_27753[(4)] = cljs.core.rest.call(null,(state_27722[(4)])));

return statearr_27753;
})();
var state_27722__$1 = state_27722;
var ex27749 = (state_27722__$1[(2)]);
var statearr_27754_27794 = state_27722__$1;
(statearr_27754_27794[(5)] = ex27749);


var statearr_27755_27795 = state_27722__$1;
(statearr_27755_27795[(1)] = (4));

(statearr_27755_27795[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (14))){
var inst_27670 = (state_27722[(7)]);
var inst_27678 = (state_27722[(11)]);
var inst_27681 = inst_27678.t;
var inst_27682 = cljs.core._EQ_.call(null,inst_27670,inst_27681);
var state_27722__$1 = state_27722;
var statearr_27756_27796 = state_27722__$1;
(statearr_27756_27796[(2)] = inst_27682);

(statearr_27756_27796[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (26))){
var inst_27707 = (state_27722[(2)]);
var state_27722__$1 = state_27722;
var statearr_27757_27797 = state_27722__$1;
(statearr_27757_27797[(2)] = inst_27707);

(statearr_27757_27797[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (16))){
var inst_27685 = (state_27722[(2)]);
var state_27722__$1 = state_27722;
if(cljs.core.truth_(inst_27685)){
var statearr_27758_27798 = state_27722__$1;
(statearr_27758_27798[(1)] = (17));

} else {
var statearr_27759_27799 = state_27722__$1;
(statearr_27759_27799[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (10))){
var inst_27654 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_27655 = cljs.core.first.call(null,inst_27654);
var inst_27663 = cljs.core.seq.call(null,inst_27654);
var inst_27664 = cljs.core.first.call(null,inst_27663);
var inst_27665 = cljs.core.next.call(null,inst_27663);
var inst_27666 = inst_27655.t;
var inst_27667 = cljs.core.PersistentVector.EMPTY;
var inst_27668 = db;
var inst_27669 = inst_27654;
var inst_27670 = inst_27666;
var inst_27671 = inst_27667;
var inst_27672 = inst_27668;
var state_27722__$1 = (function (){var statearr_27760 = state_27722;
(statearr_27760[(14)] = inst_27664);

(statearr_27760[(15)] = inst_27665);

(statearr_27760[(7)] = inst_27670);

(statearr_27760[(13)] = inst_27669);

(statearr_27760[(8)] = inst_27672);

(statearr_27760[(9)] = inst_27671);

return statearr_27760;
})();
var statearr_27761_27800 = state_27722__$1;
(statearr_27761_27800[(2)] = null);

(statearr_27761_27800[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (18))){
var state_27722__$1 = state_27722;
var statearr_27762_27801 = state_27722__$1;
(statearr_27762_27801[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27723 === (8))){
var inst_27648 = (state_27722[(2)]);
var inst_27649 = cljs.core.empty_QMARK_.call(null,flakes);
var state_27722__$1 = (function (){var statearr_27764 = state_27722;
(statearr_27764[(16)] = inst_27648);

return statearr_27764;
})();
if(inst_27649){
var statearr_27765_27802 = state_27722__$1;
(statearr_27765_27802[(1)] = (9));

} else {
var statearr_27766_27803 = state_27722__$1;
(statearr_27766_27803[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2703__auto__ = null;
var fluree$db$graphdb$state_machine__2703__auto____0 = (function (){
var statearr_27767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27767[(0)] = fluree$db$graphdb$state_machine__2703__auto__);

(statearr_27767[(1)] = (1));

return statearr_27767;
});
var fluree$db$graphdb$state_machine__2703__auto____1 = (function (state_27722){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_27722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e27768){var ex__2706__auto__ = e27768;
var statearr_27769_27804 = state_27722;
(statearr_27769_27804[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_27722[(4)]))){
var statearr_27770_27805 = state_27722;
(statearr_27770_27805[(1)] = cljs.core.first.call(null,(state_27722[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27806 = state_27722;
state_27722 = G__27806;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2703__auto__ = function(state_27722){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2703__auto____1.call(this,state_27722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2703__auto____0;
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2703__auto____1;
return fluree$db$graphdb$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_27771 = f__2726__auto__.call(null);
(statearr_27771[(6)] = c__2725__auto___27773);

return statearr_27771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_27862){
var state_val_27863 = (state_27862[(1)]);
if((state_val_27863 === (7))){
var state_27862__$1 = state_27862;
var statearr_27864_27891 = state_27862__$1;
(statearr_27864_27891[(2)] = tt_id);

(statearr_27864_27891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (1))){
var state_27862__$1 = state_27862;
var statearr_27865_27892 = state_27862__$1;
(statearr_27865_27892[(2)] = null);

(statearr_27865_27892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (4))){
var inst_27807 = (state_27862[(2)]);
var state_27862__$1 = state_27862;
var statearr_27866_27893 = state_27862__$1;
(statearr_27866_27893[(2)] = inst_27807);

(statearr_27866_27893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (13))){
var inst_27855 = (state_27862[(2)]);
var state_27862__$1 = state_27862;
var statearr_27867_27894 = state_27862__$1;
(statearr_27867_27894[(2)] = inst_27855);

(statearr_27867_27894[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (6))){
var inst_27815 = fluree.db.util.core.random_uuid.call(null);
var state_27862__$1 = state_27862;
var statearr_27868_27895 = state_27862__$1;
(statearr_27868_27895[(2)] = inst_27815);

(statearr_27868_27895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (3))){
var inst_27860 = (state_27862[(2)]);
var state_27862__$1 = state_27862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27862__$1,inst_27860);
} else {
if((state_val_27863 === (12))){
var inst_27838 = (state_27862[(7)]);
var state_27862__$1 = state_27862;
var statearr_27869_27896 = state_27862__$1;
(statearr_27869_27896[(2)] = inst_27838);

(statearr_27869_27896[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (2))){
var _ = (function (){var statearr_27870 = state_27862;
(statearr_27870[(4)] = cljs.core.cons.call(null,(5),(state_27862[(4)])));

return statearr_27870;
})();
var inst_27813 = (tt_id == null);
var state_27862__$1 = state_27862;
if(cljs.core.truth_(inst_27813)){
var statearr_27871_27897 = state_27862__$1;
(statearr_27871_27897[(1)] = (6));

} else {
var statearr_27872_27898 = state_27862__$1;
(statearr_27872_27898[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (11))){
var inst_27838 = (state_27862[(7)]);
var inst_27845 = (state_27862[(8)]);
var inst_27848 = fluree.db.graphdb.with_t.call(null,inst_27838,inst_27845);
var state_27862__$1 = state_27862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27862__$1,(14),inst_27848);
} else {
if((state_val_27863 === (9))){
var inst_27839 = (state_27862[(9)]);
var inst_27845 = (state_27862[(8)]);
var inst_27844 = cljs.core.seq.call(null,inst_27839);
var inst_27845__$1 = cljs.core.first.call(null,inst_27844);
var inst_27846 = cljs.core.next.call(null,inst_27844);
var state_27862__$1 = (function (){var statearr_27874 = state_27862;
(statearr_27874[(10)] = inst_27846);

(statearr_27874[(8)] = inst_27845__$1);

return statearr_27874;
})();
if(cljs.core.truth_(inst_27845__$1)){
var statearr_27875_27899 = state_27862__$1;
(statearr_27875_27899[(1)] = (11));

} else {
var statearr_27876_27900 = state_27862__$1;
(statearr_27876_27900[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (5))){
var _ = (function (){var statearr_27877 = state_27862;
(statearr_27877[(4)] = cljs.core.rest.call(null,(state_27862[(4)])));

return statearr_27877;
})();
var state_27862__$1 = state_27862;
var ex27873 = (state_27862__$1[(2)]);
var statearr_27878_27901 = state_27862__$1;
(statearr_27878_27901[(5)] = ex27873);


if((ex27873 instanceof Error)){
var statearr_27879_27902 = state_27862__$1;
(statearr_27879_27902[(1)] = (4));

(statearr_27879_27902[(5)] = null);

} else {
throw ex27873;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (14))){
var inst_27846 = (state_27862[(10)]);
var inst_27850 = (state_27862[(2)]);
var inst_27851 = fluree.db.util.async.throw_err.call(null,inst_27850);
var inst_27838 = inst_27851;
var inst_27839 = inst_27846;
var state_27862__$1 = (function (){var statearr_27880 = state_27862;
(statearr_27880[(7)] = inst_27838);

(statearr_27880[(9)] = inst_27839);

return statearr_27880;
})();
var statearr_27881_27903 = state_27862__$1;
(statearr_27881_27903[(2)] = null);

(statearr_27881_27903[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (10))){
var inst_27857 = (state_27862[(2)]);
var _ = (function (){var statearr_27882 = state_27862;
(statearr_27882[(4)] = cljs.core.rest.call(null,(state_27862[(4)])));

return statearr_27882;
})();
var state_27862__$1 = state_27862;
var statearr_27883_27904 = state_27862__$1;
(statearr_27883_27904[(2)] = inst_27857);

(statearr_27883_27904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (8))){
var inst_27818 = (state_27862[(2)]);
var inst_27819 = (function (){var tt_id_SINGLEQUOTE_ = inst_27818;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27820 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27818);
var inst_27821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27822 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27823 = (new cljs.core.PersistentVector(null,4,(5),inst_27821,inst_27822,null));
var inst_27824 = cljs.core.reduce.call(null,inst_27819,inst_27820,inst_27823);
var inst_27825 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27826 = cljs.core.reverse.call(null,inst_27825);
var inst_27827 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27826);
var inst_27835 = cljs.core.seq.call(null,inst_27827);
var inst_27836 = cljs.core.first.call(null,inst_27835);
var inst_27837 = cljs.core.next.call(null,inst_27835);
var inst_27838 = inst_27824;
var inst_27839 = inst_27827;
var state_27862__$1 = (function (){var statearr_27884 = state_27862;
(statearr_27884[(7)] = inst_27838);

(statearr_27884[(11)] = inst_27836);

(statearr_27884[(12)] = inst_27837);

(statearr_27884[(9)] = inst_27839);

return statearr_27884;
})();
var statearr_27885_27905 = state_27862__$1;
(statearr_27885_27905[(2)] = null);

(statearr_27885_27905[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto____0 = (function (){
var statearr_27886 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27886[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto__);

(statearr_27886[(1)] = (1));

return statearr_27886;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto____1 = (function (state_27862){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_27862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e27887){var ex__2706__auto__ = e27887;
var statearr_27888_27906 = state_27862;
(statearr_27888_27906[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_27862[(4)]))){
var statearr_27889_27907 = state_27862;
(statearr_27889_27907[(1)] = cljs.core.first.call(null,(state_27862[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27908 = state_27862;
state_27862 = G__27908;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto__ = function(state_27862){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto____1.call(this,state_27862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_27890 = f__2726__auto__.call(null);
(statearr_27890[(6)] = c__2725__auto__);

return statearr_27890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2725__auto___28095 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28026){
var state_val_28027 = (state_28026[(1)]);
if((state_val_28027 === (7))){
var inst_27936 = (state_28026[(7)]);
var inst_27936__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_28026__$1 = (function (){var statearr_28028 = state_28026;
(statearr_28028[(7)] = inst_27936__$1);

return statearr_28028;
})();
if(inst_27936__$1){
var statearr_28029_28096 = state_28026__$1;
(statearr_28029_28096[(1)] = (13));

} else {
var statearr_28030_28097 = state_28026__$1;
(statearr_28030_28097[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (20))){
var state_28026__$1 = state_28026;
var statearr_28031_28098 = state_28026__$1;
(statearr_28031_28098[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (27))){
var inst_27972 = (state_28026[(8)]);
var inst_27976 = inst_27972.s;
var state_28026__$1 = state_28026;
var statearr_28033_28099 = state_28026__$1;
(statearr_28033_28099[(2)] = inst_27976);

(statearr_28033_28099[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (1))){
var state_28026__$1 = state_28026;
var statearr_28034_28100 = state_28026__$1;
(statearr_28034_28100[(2)] = null);

(statearr_28034_28100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (24))){
var inst_27966 = (state_28026[(9)]);
var inst_27970 = cljs.core.first.call(null,inst_27966);
var state_28026__$1 = state_28026;
var statearr_28035_28101 = state_28026__$1;
(statearr_28035_28101[(2)] = inst_27970);

(statearr_28035_28101[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (39))){
var state_28026__$1 = state_28026;
var statearr_28036_28102 = state_28026__$1;
(statearr_28036_28102[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (4))){
var inst_27909 = (state_28026[(2)]);
var inst_27910 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27911 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27912 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27913 = cljs.core.PersistentHashMap.fromArrays(inst_27911,inst_27912);
var inst_27914 = cljs.core.ex_info.call(null,inst_27910,inst_27913,inst_27909);
var inst_27915 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27914);
var state_28026__$1 = state_28026;
var statearr_28038_28103 = state_28026__$1;
(statearr_28038_28103[(2)] = inst_27915);

(statearr_28038_28103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (15))){
var inst_27943 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
if(cljs.core.truth_(inst_27943)){
var statearr_28039_28104 = state_28026__$1;
(statearr_28039_28104[(1)] = (16));

} else {
var statearr_28040_28105 = state_28026__$1;
(statearr_28040_28105[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (21))){
var inst_27992 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
var statearr_28041_28106 = state_28026__$1;
(statearr_28041_28106[(2)] = inst_27992);

(statearr_28041_28106[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (31))){
var inst_27990 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
var statearr_28042_28107 = state_28026__$1;
(statearr_28042_28107[(2)] = inst_27990);

(statearr_28042_28107[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (32))){
var inst_27996 = (state_28026[(10)]);
var inst_27998 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27996);
var state_28026__$1 = state_28026;
var statearr_28043_28108 = state_28026__$1;
(statearr_28043_28108[(2)] = inst_27998);

(statearr_28043_28108[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (40))){
var inst_28019 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
var statearr_28044_28109 = state_28026__$1;
(statearr_28044_28109[(2)] = inst_28019);

(statearr_28044_28109[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (33))){
var inst_27996 = (state_28026[(10)]);
var inst_28000 = (state_28026[(11)]);
var inst_28000__$1 = (inst_27996 == null);
var state_28026__$1 = (function (){var statearr_28045 = state_28026;
(statearr_28045[(11)] = inst_28000__$1);

return statearr_28045;
})();
if(cljs.core.truth_(inst_28000__$1)){
var statearr_28046_28110 = state_28026__$1;
(statearr_28046_28110[(1)] = (35));

} else {
var statearr_28047_28111 = state_28026__$1;
(statearr_28047_28111[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (13))){
var inst_27938 = cljs.core.first.call(null,ident);
var inst_27939 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27938);
var inst_27940 = (inst_27939 == null);
var state_28026__$1 = state_28026;
var statearr_28048_28112 = state_28026__$1;
(statearr_28048_28112[(2)] = inst_27940);

(statearr_28048_28112[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (22))){
var inst_27966 = (state_28026[(9)]);
var inst_27965 = (state_28026[(2)]);
var inst_27966__$1 = fluree.db.util.async.throw_err.call(null,inst_27965);
var inst_27967 = (inst_27966__$1 == null);
var state_28026__$1 = (function (){var statearr_28049 = state_28026;
(statearr_28049[(9)] = inst_27966__$1);

return statearr_28049;
})();
if(cljs.core.truth_(inst_27967)){
var statearr_28050_28113 = state_28026__$1;
(statearr_28050_28113[(1)] = (23));

} else {
var statearr_28051_28114 = state_28026__$1;
(statearr_28051_28114[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (36))){
var inst_28000 = (state_28026[(11)]);
var state_28026__$1 = state_28026;
var statearr_28052_28115 = state_28026__$1;
(statearr_28052_28115[(2)] = inst_28000);

(statearr_28052_28115[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (41))){
var inst_28014 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_28026__$1 = state_28026;
var statearr_28053_28116 = state_28026__$1;
(statearr_28053_28116[(2)] = inst_28014);

(statearr_28053_28116[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (43))){
var inst_28017 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
var statearr_28054_28117 = state_28026__$1;
(statearr_28054_28117[(2)] = inst_28017);

(statearr_28054_28117[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (29))){
var inst_27981 = cljs.core.pr_str.call(null,ident);
var inst_27982 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27981].join('');
var inst_27983 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27984 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27985 = cljs.core.PersistentHashMap.fromArrays(inst_27983,inst_27984);
var inst_27986 = cljs.core.ex_info.call(null,inst_27982,inst_27985);
var inst_27987 = (function(){throw inst_27986})();
var state_28026__$1 = state_28026;
var statearr_28055_28118 = state_28026__$1;
(statearr_28055_28118[(2)] = inst_27987);

(statearr_28055_28118[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (6))){
var inst_27923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27924 = [ident];
var inst_27925 = (new cljs.core.PersistentVector(null,1,(5),inst_27923,inst_27924,null));
var inst_27926 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27925);
var state_28026__$1 = state_28026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28026__$1,(9),inst_27926);
} else {
if((state_val_28027 === (28))){
var inst_27978 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
var statearr_28056_28119 = state_28026__$1;
(statearr_28056_28119[(2)] = inst_27978);

(statearr_28056_28119[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (25))){
var inst_27972 = (state_28026[(8)]);
var inst_27972__$1 = (state_28026[(2)]);
var inst_27973 = (inst_27972__$1 == null);
var state_28026__$1 = (function (){var statearr_28057 = state_28026;
(statearr_28057[(8)] = inst_27972__$1);

return statearr_28057;
})();
if(cljs.core.truth_(inst_27973)){
var statearr_28058_28120 = state_28026__$1;
(statearr_28058_28120[(1)] = (26));

} else {
var statearr_28059_28121 = state_28026__$1;
(statearr_28059_28121[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (34))){
var inst_28021 = (state_28026[(2)]);
var _ = (function (){var statearr_28060 = state_28026;
(statearr_28060[(4)] = cljs.core.rest.call(null,(state_28026[(4)])));

return statearr_28060;
})();
var state_28026__$1 = state_28026;
var statearr_28061_28122 = state_28026__$1;
(statearr_28061_28122[(2)] = inst_28021);

(statearr_28061_28122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (17))){
var inst_27954 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_28026__$1 = state_28026;
if(inst_27954){
var statearr_28062_28123 = state_28026__$1;
(statearr_28062_28123[(1)] = (19));

} else {
var statearr_28063_28124 = state_28026__$1;
(statearr_28063_28124[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (3))){
var inst_28024 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28026__$1,inst_28024);
} else {
if((state_val_28027 === (12))){
var inst_27934 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
var statearr_28064_28125 = state_28026__$1;
(statearr_28064_28125[(2)] = inst_27934);

(statearr_28064_28125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (2))){
var _ = (function (){var statearr_28065 = state_28026;
(statearr_28065[(4)] = cljs.core.cons.call(null,(5),(state_28026[(4)])));

return statearr_28065;
})();
var inst_27921 = typeof ident === 'number';
var state_28026__$1 = state_28026;
if(cljs.core.truth_(inst_27921)){
var statearr_28066_28126 = state_28026__$1;
(statearr_28066_28126[(1)] = (6));

} else {
var statearr_28067_28127 = state_28026__$1;
(statearr_28067_28127[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (23))){
var state_28026__$1 = state_28026;
var statearr_28068_28128 = state_28026__$1;
(statearr_28068_28128[(2)] = null);

(statearr_28068_28128[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (35))){
var state_28026__$1 = state_28026;
var statearr_28069_28129 = state_28026__$1;
(statearr_28069_28129[(2)] = strict_QMARK_);

(statearr_28069_28129[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (19))){
var inst_27957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27958 = cljs.core.first.call(null,ident);
var inst_27959 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27958);
var inst_27960 = cljs.core.second.call(null,ident);
var inst_27961 = [inst_27959,inst_27960];
var inst_27962 = (new cljs.core.PersistentVector(null,2,(5),inst_27957,inst_27961,null));
var inst_27963 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27962);
var state_28026__$1 = state_28026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28026__$1,(22),inst_27963);
} else {
if((state_val_28027 === (11))){
var state_28026__$1 = state_28026;
var statearr_28071_28130 = state_28026__$1;
(statearr_28071_28130[(2)] = null);

(statearr_28071_28130[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (9))){
var inst_27928 = (state_28026[(2)]);
var inst_27929 = fluree.db.util.async.throw_err.call(null,inst_27928);
var inst_27930 = cljs.core.not_empty.call(null,inst_27929);
var state_28026__$1 = state_28026;
if(cljs.core.truth_(inst_27930)){
var statearr_28072_28131 = state_28026__$1;
(statearr_28072_28131[(1)] = (10));

} else {
var statearr_28073_28132 = state_28026__$1;
(statearr_28073_28132[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (5))){
var _ = (function (){var statearr_28074 = state_28026;
(statearr_28074[(4)] = cljs.core.rest.call(null,(state_28026[(4)])));

return statearr_28074;
})();
var state_28026__$1 = state_28026;
var ex28070 = (state_28026__$1[(2)]);
var statearr_28075_28133 = state_28026__$1;
(statearr_28075_28133[(5)] = ex28070);


var statearr_28076_28134 = state_28026__$1;
(statearr_28076_28134[(1)] = (4));

(statearr_28076_28134[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (14))){
var inst_27936 = (state_28026[(7)]);
var state_28026__$1 = state_28026;
var statearr_28077_28135 = state_28026__$1;
(statearr_28077_28135[(2)] = inst_27936);

(statearr_28077_28135[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (26))){
var state_28026__$1 = state_28026;
var statearr_28078_28136 = state_28026__$1;
(statearr_28078_28136[(2)] = null);

(statearr_28078_28136[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (16))){
var inst_27945 = cljs.core.first.call(null,ident);
var inst_27946 = cljs.core.pr_str.call(null,inst_27945);
var inst_27947 = ["Subject ID lookup failed. The predicate ",inst_27946," does not exist."].join('');
var inst_27948 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27949 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27950 = cljs.core.PersistentHashMap.fromArrays(inst_27948,inst_27949);
var inst_27951 = cljs.core.ex_info.call(null,inst_27947,inst_27950);
var inst_27952 = (function(){throw inst_27951})();
var state_28026__$1 = state_28026;
var statearr_28079_28137 = state_28026__$1;
(statearr_28079_28137[(2)] = inst_27952);

(statearr_28079_28137[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (38))){
var inst_28006 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_28007 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28008 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_28009 = cljs.core.PersistentHashMap.fromArrays(inst_28007,inst_28008);
var inst_28010 = cljs.core.ex_info.call(null,inst_28006,inst_28009);
var inst_28011 = cljs.core.async.put_BANG_.call(null,return_chan,inst_28010);
var state_28026__$1 = state_28026;
var statearr_28080_28138 = state_28026__$1;
(statearr_28080_28138[(2)] = inst_28011);

(statearr_28080_28138[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (30))){
var state_28026__$1 = state_28026;
var statearr_28081_28139 = state_28026__$1;
(statearr_28081_28139[(2)] = null);

(statearr_28081_28139[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (10))){
var state_28026__$1 = state_28026;
var statearr_28082_28140 = state_28026__$1;
(statearr_28082_28140[(2)] = ident);

(statearr_28082_28140[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (18))){
var inst_27994 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
var statearr_28083_28141 = state_28026__$1;
(statearr_28083_28141[(2)] = inst_27994);

(statearr_28083_28141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (42))){
var state_28026__$1 = state_28026;
var statearr_28084_28142 = state_28026__$1;
(statearr_28084_28142[(2)] = null);

(statearr_28084_28142[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (37))){
var inst_28004 = (state_28026[(2)]);
var state_28026__$1 = state_28026;
if(cljs.core.truth_(inst_28004)){
var statearr_28085_28143 = state_28026__$1;
(statearr_28085_28143[(1)] = (38));

} else {
var statearr_28086_28144 = state_28026__$1;
(statearr_28086_28144[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28027 === (8))){
var inst_27996 = (state_28026[(10)]);
var inst_27996__$1 = (state_28026[(2)]);
var state_28026__$1 = (function (){var statearr_28087 = state_28026;
(statearr_28087[(10)] = inst_27996__$1);

return statearr_28087;
})();
if(cljs.core.truth_(inst_27996__$1)){
var statearr_28088_28145 = state_28026__$1;
(statearr_28088_28145[(1)] = (32));

} else {
var statearr_28089_28146 = state_28026__$1;
(statearr_28089_28146[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2703__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2703__auto____0 = (function (){
var statearr_28090 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28090[(0)] = fluree$db$graphdb$subid_$_state_machine__2703__auto__);

(statearr_28090[(1)] = (1));

return statearr_28090;
});
var fluree$db$graphdb$subid_$_state_machine__2703__auto____1 = (function (state_28026){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28091){var ex__2706__auto__ = e28091;
var statearr_28092_28147 = state_28026;
(statearr_28092_28147[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28026[(4)]))){
var statearr_28093_28148 = state_28026;
(statearr_28093_28148[(1)] = cljs.core.first.call(null,(state_28026[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28149 = state_28026;
state_28026 = G__28149;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2703__auto__ = function(state_28026){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2703__auto____1.call(this,state_28026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2703__auto____0;
fluree$db$graphdb$subid_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2703__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28094 = f__2726__auto__.call(null);
(statearr_28094[(6)] = c__2725__auto___28095);

return statearr_28094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__28150){
var map__28151 = p__28150;
var map__28151__$1 = cljs.core.__destructure_map.call(null,map__28151);
var db = map__28151__$1;
var current_db_fn = cljs.core.get.call(null,map__28151__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__28151__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28167){
var state_val_28168 = (state_28167[(1)]);
if((state_val_28168 === (1))){
var state_28167__$1 = state_28167;
var statearr_28169_28183 = state_28167__$1;
(statearr_28169_28183[(2)] = null);

(statearr_28169_28183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28168 === (2))){
var _ = (function (){var statearr_28170 = state_28167;
(statearr_28170[(4)] = cljs.core.cons.call(null,(5),(state_28167[(4)])));

return statearr_28170;
})();
var inst_28158 = current_db_fn.call(null,db);
var state_28167__$1 = state_28167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28167__$1,(6),inst_28158);
} else {
if((state_val_28168 === (3))){
var inst_28165 = (state_28167[(2)]);
var state_28167__$1 = state_28167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28167__$1,inst_28165);
} else {
if((state_val_28168 === (4))){
var inst_28152 = (state_28167[(2)]);
var state_28167__$1 = state_28167;
var statearr_28172_28184 = state_28167__$1;
(statearr_28172_28184[(2)] = inst_28152);

(statearr_28172_28184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28168 === (5))){
var _ = (function (){var statearr_28173 = state_28167;
(statearr_28173[(4)] = cljs.core.rest.call(null,(state_28167[(4)])));

return statearr_28173;
})();
var state_28167__$1 = state_28167;
var ex28171 = (state_28167__$1[(2)]);
var statearr_28174_28185 = state_28167__$1;
(statearr_28174_28185[(5)] = ex28171);


if((ex28171 instanceof Error)){
var statearr_28175_28186 = state_28167__$1;
(statearr_28175_28186[(1)] = (4));

(statearr_28175_28186[(5)] = null);

} else {
throw ex28171;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28168 === (6))){
var inst_28160 = (state_28167[(2)]);
var inst_28161 = fluree.db.util.async.throw_err.call(null,inst_28160);
var inst_28162 = cljs.core.assoc.call(null,inst_28161,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_28176 = state_28167;
(statearr_28176[(4)] = cljs.core.rest.call(null,(state_28167[(4)])));

return statearr_28176;
})();
var state_28167__$1 = state_28167;
var statearr_28177_28187 = state_28167__$1;
(statearr_28177_28187[(2)] = inst_28162);

(statearr_28177_28187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto____0 = (function (){
var statearr_28178 = [null,null,null,null,null,null,null];
(statearr_28178[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto__);

(statearr_28178[(1)] = (1));

return statearr_28178;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto____1 = (function (state_28167){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28179){var ex__2706__auto__ = e28179;
var statearr_28180_28188 = state_28167;
(statearr_28180_28188[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28167[(4)]))){
var statearr_28181_28189 = state_28167;
(statearr_28181_28189[(1)] = cljs.core.first.call(null,(state_28167[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28190 = state_28167;
state_28167 = G__28190;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto__ = function(state_28167){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto____1.call(this,state_28167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28182 = f__2726__auto__.call(null);
(statearr_28182[(6)] = c__2725__auto__);

return statearr_28182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__28191,property,collection){
var map__28192 = p__28191;
var map__28192__$1 = cljs.core.__destructure_map.call(null,map__28192);
var schema = cljs.core.get.call(null,map__28192__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__28193,property,predicate){
var map__28194 = p__28193;
var map__28194__$1 = cljs.core.__destructure_map.call(null,map__28194);
var this$ = map__28194__$1;
var schema = cljs.core.get.call(null,map__28194__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__28195 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__28195);
} else {
return G__28195;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__28197 = arguments.length;
switch (G__28197) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28229){
var state_val_28230 = (state_28229[(1)]);
if((state_val_28230 === (7))){
var state_28229__$1 = state_28229;
var statearr_28231_28325 = state_28229__$1;
(statearr_28231_28325[(2)] = null);

(statearr_28231_28325[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (1))){
var state_28229__$1 = state_28229;
var statearr_28232_28326 = state_28229__$1;
(statearr_28232_28326[(2)] = null);

(statearr_28232_28326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (4))){
var inst_28198 = (state_28229[(2)]);
var state_28229__$1 = state_28229;
var statearr_28233_28327 = state_28229__$1;
(statearr_28233_28327[(2)] = inst_28198);

(statearr_28233_28327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (6))){
var inst_28212 = (state_28229[(7)]);
var inst_28211 = (state_28229[(2)]);
var inst_28212__$1 = fluree.db.util.async.throw_err.call(null,inst_28211);
var inst_28213 = (inst_28212__$1 == null);
var state_28229__$1 = (function (){var statearr_28234 = state_28229;
(statearr_28234[(7)] = inst_28212__$1);

return statearr_28234;
})();
if(cljs.core.truth_(inst_28213)){
var statearr_28235_28328 = state_28229__$1;
(statearr_28235_28328[(1)] = (7));

} else {
var statearr_28236_28329 = state_28229__$1;
(statearr_28236_28329[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (3))){
var inst_28227 = (state_28229[(2)]);
var state_28229__$1 = state_28229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28229__$1,inst_28227);
} else {
if((state_val_28230 === (12))){
var inst_28224 = (state_28229[(2)]);
var _ = (function (){var statearr_28237 = state_28229;
(statearr_28237[(4)] = cljs.core.rest.call(null,(state_28229[(4)])));

return statearr_28237;
})();
var state_28229__$1 = state_28229;
var statearr_28238_28330 = state_28229__$1;
(statearr_28238_28330[(2)] = inst_28224);

(statearr_28238_28330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (2))){
var _ = (function (){var statearr_28239 = state_28229;
(statearr_28239[(4)] = cljs.core.cons.call(null,(5),(state_28229[(4)])));

return statearr_28239;
})();
var inst_28205 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_28206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28207 = [tag_id,(30)];
var inst_28208 = (new cljs.core.PersistentVector(null,2,(5),inst_28206,inst_28207,null));
var inst_28209 = fluree.db.query.range.index_range.call(null,inst_28205,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28208);
var state_28229__$1 = state_28229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28229__$1,(6),inst_28209);
} else {
if((state_val_28230 === (11))){
var inst_28218 = (state_28229[(8)]);
var inst_28222 = inst_28218.o;
var state_28229__$1 = state_28229;
var statearr_28241_28331 = state_28229__$1;
(statearr_28241_28331[(2)] = inst_28222);

(statearr_28241_28331[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (9))){
var inst_28218 = (state_28229[(8)]);
var inst_28218__$1 = (state_28229[(2)]);
var inst_28219 = (inst_28218__$1 == null);
var state_28229__$1 = (function (){var statearr_28242 = state_28229;
(statearr_28242[(8)] = inst_28218__$1);

return statearr_28242;
})();
if(cljs.core.truth_(inst_28219)){
var statearr_28243_28332 = state_28229__$1;
(statearr_28243_28332[(1)] = (10));

} else {
var statearr_28244_28333 = state_28229__$1;
(statearr_28244_28333[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (5))){
var _ = (function (){var statearr_28245 = state_28229;
(statearr_28245[(4)] = cljs.core.rest.call(null,(state_28229[(4)])));

return statearr_28245;
})();
var state_28229__$1 = state_28229;
var ex28240 = (state_28229__$1[(2)]);
var statearr_28246_28334 = state_28229__$1;
(statearr_28246_28334[(5)] = ex28240);


if((ex28240 instanceof Error)){
var statearr_28247_28335 = state_28229__$1;
(statearr_28247_28335[(1)] = (4));

(statearr_28247_28335[(5)] = null);

} else {
throw ex28240;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (10))){
var state_28229__$1 = state_28229;
var statearr_28248_28336 = state_28229__$1;
(statearr_28248_28336[(2)] = null);

(statearr_28248_28336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28230 === (8))){
var inst_28212 = (state_28229[(7)]);
var inst_28216 = cljs.core.first.call(null,inst_28212);
var state_28229__$1 = state_28229;
var statearr_28249_28337 = state_28229__$1;
(statearr_28249_28337[(2)] = inst_28216);

(statearr_28249_28337[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2703__auto__ = null;
var fluree$db$graphdb$state_machine__2703__auto____0 = (function (){
var statearr_28250 = [null,null,null,null,null,null,null,null,null];
(statearr_28250[(0)] = fluree$db$graphdb$state_machine__2703__auto__);

(statearr_28250[(1)] = (1));

return statearr_28250;
});
var fluree$db$graphdb$state_machine__2703__auto____1 = (function (state_28229){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28251){var ex__2706__auto__ = e28251;
var statearr_28252_28338 = state_28229;
(statearr_28252_28338[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28229[(4)]))){
var statearr_28253_28339 = state_28229;
(statearr_28253_28339[(1)] = cljs.core.first.call(null,(state_28229[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28340 = state_28229;
state_28229 = G__28340;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2703__auto__ = function(state_28229){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2703__auto____1.call(this,state_28229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2703__auto____0;
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2703__auto____1;
return fluree$db$graphdb$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28254 = f__2726__auto__.call(null);
(statearr_28254[(6)] = c__2725__auto__);

return statearr_28254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28290){
var state_val_28291 = (state_28290[(1)]);
if((state_val_28291 === (7))){
var inst_28264 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28290__$1 = state_28290;
var statearr_28292_28341 = state_28290__$1;
(statearr_28292_28341[(2)] = inst_28264);

(statearr_28292_28341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (1))){
var state_28290__$1 = state_28290;
var statearr_28293_28342 = state_28290__$1;
(statearr_28293_28342[(2)] = null);

(statearr_28293_28342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (4))){
var inst_28255 = (state_28290[(2)]);
var state_28290__$1 = state_28290;
var statearr_28294_28343 = state_28290__$1;
(statearr_28294_28343[(2)] = inst_28255);

(statearr_28294_28343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (15))){
var inst_28285 = (state_28290[(2)]);
var _ = (function (){var statearr_28295 = state_28290;
(statearr_28295[(4)] = cljs.core.rest.call(null,(state_28290[(4)])));

return statearr_28295;
})();
var state_28290__$1 = state_28290;
var statearr_28296_28344 = state_28290__$1;
(statearr_28296_28344[(2)] = inst_28285);

(statearr_28296_28344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (13))){
var inst_28270 = (state_28290[(7)]);
var inst_28276 = clojure.string.includes_QMARK_.call(null,inst_28270,":");
var state_28290__$1 = state_28290;
if(inst_28276){
var statearr_28297_28345 = state_28290__$1;
(statearr_28297_28345[(1)] = (16));

} else {
var statearr_28298_28346 = state_28290__$1;
(statearr_28298_28346[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (6))){
var state_28290__$1 = state_28290;
var statearr_28299_28347 = state_28290__$1;
(statearr_28299_28347[(2)] = pred);

(statearr_28299_28347[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (17))){
var inst_28270 = (state_28290[(7)]);
var state_28290__$1 = state_28290;
var statearr_28300_28348 = state_28290__$1;
(statearr_28300_28348[(2)] = inst_28270);

(statearr_28300_28348[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (3))){
var inst_28288 = (state_28290[(2)]);
var state_28290__$1 = state_28290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28290__$1,inst_28288);
} else {
if((state_val_28291 === (12))){
var inst_28274 = (state_28290[(2)]);
var state_28290__$1 = state_28290;
if(cljs.core.truth_(inst_28274)){
var statearr_28301_28349 = state_28290__$1;
(statearr_28301_28349[(1)] = (13));

} else {
var statearr_28302_28350 = state_28290__$1;
(statearr_28302_28350[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (2))){
var _ = (function (){var statearr_28303 = state_28290;
(statearr_28303[(4)] = cljs.core.cons.call(null,(5),(state_28290[(4)])));

return statearr_28303;
})();
var inst_28261 = typeof pred === 'string';
var state_28290__$1 = state_28290;
if(cljs.core.truth_(inst_28261)){
var statearr_28304_28351 = state_28290__$1;
(statearr_28304_28351[(1)] = (6));

} else {
var statearr_28305_28352 = state_28290__$1;
(statearr_28305_28352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (11))){
var inst_28266 = (state_28290[(8)]);
var state_28290__$1 = state_28290;
var statearr_28307_28353 = state_28290__$1;
(statearr_28307_28353[(2)] = inst_28266);

(statearr_28307_28353[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (9))){
var inst_28266 = (state_28290[(8)]);
var inst_28269 = (state_28290[(2)]);
var inst_28270 = fluree.db.util.async.throw_err.call(null,inst_28269);
var state_28290__$1 = (function (){var statearr_28308 = state_28290;
(statearr_28308[(7)] = inst_28270);

return statearr_28308;
})();
if(cljs.core.truth_(inst_28266)){
var statearr_28309_28354 = state_28290__$1;
(statearr_28309_28354[(1)] = (10));

} else {
var statearr_28310_28355 = state_28290__$1;
(statearr_28310_28355[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (5))){
var _ = (function (){var statearr_28311 = state_28290;
(statearr_28311[(4)] = cljs.core.rest.call(null,(state_28290[(4)])));

return statearr_28311;
})();
var state_28290__$1 = state_28290;
var ex28306 = (state_28290__$1[(2)]);
var statearr_28312_28356 = state_28290__$1;
(statearr_28312_28356[(5)] = ex28306);


if((ex28306 instanceof Error)){
var statearr_28313_28357 = state_28290__$1;
(statearr_28313_28357[(1)] = (4));

(statearr_28313_28357[(5)] = null);

} else {
throw ex28306;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (14))){
var state_28290__$1 = state_28290;
var statearr_28314_28358 = state_28290__$1;
(statearr_28314_28358[(2)] = null);

(statearr_28314_28358[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (16))){
var inst_28270 = (state_28290[(7)]);
var inst_28278 = clojure.string.split.call(null,inst_28270,/:/);
var inst_28279 = cljs.core.second.call(null,inst_28278);
var state_28290__$1 = state_28290;
var statearr_28315_28359 = state_28290__$1;
(statearr_28315_28359[(2)] = inst_28279);

(statearr_28315_28359[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (10))){
var inst_28270 = (state_28290[(7)]);
var state_28290__$1 = state_28290;
var statearr_28316_28360 = state_28290__$1;
(statearr_28316_28360[(2)] = inst_28270);

(statearr_28316_28360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (18))){
var inst_28282 = (state_28290[(2)]);
var state_28290__$1 = state_28290;
var statearr_28317_28361 = state_28290__$1;
(statearr_28317_28361[(2)] = inst_28282);

(statearr_28317_28361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28291 === (8))){
var inst_28266 = (state_28290[(2)]);
var inst_28267 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_28290__$1 = (function (){var statearr_28318 = state_28290;
(statearr_28318[(8)] = inst_28266);

return statearr_28318;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28290__$1,(9),inst_28267);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2703__auto__ = null;
var fluree$db$graphdb$state_machine__2703__auto____0 = (function (){
var statearr_28319 = [null,null,null,null,null,null,null,null,null];
(statearr_28319[(0)] = fluree$db$graphdb$state_machine__2703__auto__);

(statearr_28319[(1)] = (1));

return statearr_28319;
});
var fluree$db$graphdb$state_machine__2703__auto____1 = (function (state_28290){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28320){var ex__2706__auto__ = e28320;
var statearr_28321_28362 = state_28290;
(statearr_28321_28362[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28290[(4)]))){
var statearr_28322_28363 = state_28290;
(statearr_28322_28363[(1)] = cljs.core.first.call(null,(state_28290[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28364 = state_28290;
state_28290 = G__28364;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2703__auto__ = function(state_28290){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2703__auto____1.call(this,state_28290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2703__auto____0;
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2703__auto____1;
return fluree$db$graphdb$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28323 = f__2726__auto__.call(null);
(statearr_28323[(6)] = c__2725__auto__);

return statearr_28323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__28366 = arguments.length;
switch (G__28366) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28399){
var state_val_28400 = (state_28399[(1)]);
if((state_val_28400 === (7))){
var state_28399__$1 = state_28399;
var statearr_28401_28489 = state_28399__$1;
(statearr_28401_28489[(2)] = null);

(statearr_28401_28489[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (1))){
var state_28399__$1 = state_28399;
var statearr_28402_28490 = state_28399__$1;
(statearr_28402_28490[(2)] = null);

(statearr_28402_28490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (4))){
var inst_28367 = (state_28399[(2)]);
var state_28399__$1 = state_28399;
var statearr_28403_28491 = state_28399__$1;
(statearr_28403_28491[(2)] = inst_28367);

(statearr_28403_28491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (6))){
var inst_28382 = (state_28399[(7)]);
var inst_28381 = (state_28399[(2)]);
var inst_28382__$1 = fluree.db.util.async.throw_err.call(null,inst_28381);
var inst_28383 = (inst_28382__$1 == null);
var state_28399__$1 = (function (){var statearr_28404 = state_28399;
(statearr_28404[(7)] = inst_28382__$1);

return statearr_28404;
})();
if(cljs.core.truth_(inst_28383)){
var statearr_28405_28492 = state_28399__$1;
(statearr_28405_28492[(1)] = (7));

} else {
var statearr_28406_28493 = state_28399__$1;
(statearr_28406_28493[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (3))){
var inst_28397 = (state_28399[(2)]);
var state_28399__$1 = state_28399;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28399__$1,inst_28397);
} else {
if((state_val_28400 === (12))){
var inst_28394 = (state_28399[(2)]);
var _ = (function (){var statearr_28407 = state_28399;
(statearr_28407[(4)] = cljs.core.rest.call(null,(state_28399[(4)])));

return statearr_28407;
})();
var state_28399__$1 = state_28399;
var statearr_28408_28494 = state_28399__$1;
(statearr_28408_28494[(2)] = inst_28394);

(statearr_28408_28494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (2))){
var _ = (function (){var statearr_28409 = state_28399;
(statearr_28409[(4)] = cljs.core.cons.call(null,(5),(state_28399[(4)])));

return statearr_28409;
})();
var inst_28373 = (30);
var inst_28375 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_28376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28377 = [inst_28373,tag_name];
var inst_28378 = (new cljs.core.PersistentVector(null,2,(5),inst_28376,inst_28377,null));
var inst_28379 = fluree.db.query.range.index_range.call(null,inst_28375,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_28378);
var state_28399__$1 = state_28399;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28399__$1,(6),inst_28379);
} else {
if((state_val_28400 === (11))){
var inst_28388 = (state_28399[(8)]);
var inst_28392 = inst_28388.s;
var state_28399__$1 = state_28399;
var statearr_28411_28495 = state_28399__$1;
(statearr_28411_28495[(2)] = inst_28392);

(statearr_28411_28495[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (9))){
var inst_28388 = (state_28399[(8)]);
var inst_28388__$1 = (state_28399[(2)]);
var inst_28389 = (inst_28388__$1 == null);
var state_28399__$1 = (function (){var statearr_28412 = state_28399;
(statearr_28412[(8)] = inst_28388__$1);

return statearr_28412;
})();
if(cljs.core.truth_(inst_28389)){
var statearr_28413_28496 = state_28399__$1;
(statearr_28413_28496[(1)] = (10));

} else {
var statearr_28414_28497 = state_28399__$1;
(statearr_28414_28497[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (5))){
var _ = (function (){var statearr_28415 = state_28399;
(statearr_28415[(4)] = cljs.core.rest.call(null,(state_28399[(4)])));

return statearr_28415;
})();
var state_28399__$1 = state_28399;
var ex28410 = (state_28399__$1[(2)]);
var statearr_28416_28498 = state_28399__$1;
(statearr_28416_28498[(5)] = ex28410);


if((ex28410 instanceof Error)){
var statearr_28417_28499 = state_28399__$1;
(statearr_28417_28499[(1)] = (4));

(statearr_28417_28499[(5)] = null);

} else {
throw ex28410;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (10))){
var state_28399__$1 = state_28399;
var statearr_28418_28500 = state_28399__$1;
(statearr_28418_28500[(2)] = null);

(statearr_28418_28500[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (8))){
var inst_28382 = (state_28399[(7)]);
var inst_28386 = cljs.core.first.call(null,inst_28382);
var state_28399__$1 = state_28399;
var statearr_28419_28501 = state_28399__$1;
(statearr_28419_28501[(2)] = inst_28386);

(statearr_28419_28501[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2703__auto__ = null;
var fluree$db$graphdb$state_machine__2703__auto____0 = (function (){
var statearr_28420 = [null,null,null,null,null,null,null,null,null];
(statearr_28420[(0)] = fluree$db$graphdb$state_machine__2703__auto__);

(statearr_28420[(1)] = (1));

return statearr_28420;
});
var fluree$db$graphdb$state_machine__2703__auto____1 = (function (state_28399){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28399);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28421){var ex__2706__auto__ = e28421;
var statearr_28422_28502 = state_28399;
(statearr_28422_28502[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28399[(4)]))){
var statearr_28423_28503 = state_28399;
(statearr_28423_28503[(1)] = cljs.core.first.call(null,(state_28399[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28504 = state_28399;
state_28399 = G__28504;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2703__auto__ = function(state_28399){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2703__auto____1.call(this,state_28399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2703__auto____0;
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2703__auto____1;
return fluree$db$graphdb$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28424 = f__2726__auto__.call(null);
(statearr_28424[(6)] = c__2725__auto__);

return statearr_28424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28459){
var state_val_28460 = (state_28459[(1)]);
if((state_val_28460 === (7))){
var inst_28438 = typeof pred === 'string';
var state_28459__$1 = state_28459;
if(cljs.core.truth_(inst_28438)){
var statearr_28461_28505 = state_28459__$1;
(statearr_28461_28505[(1)] = (10));

} else {
var statearr_28462_28506 = state_28459__$1;
(statearr_28462_28506[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (1))){
var state_28459__$1 = state_28459;
var statearr_28463_28507 = state_28459__$1;
(statearr_28463_28507[(2)] = null);

(statearr_28463_28507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (4))){
var inst_28425 = (state_28459[(2)]);
var state_28459__$1 = state_28459;
var statearr_28464_28508 = state_28459__$1;
(statearr_28464_28508[(2)] = inst_28425);

(statearr_28464_28508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (15))){
var inst_28452 = (state_28459[(2)]);
var state_28459__$1 = state_28459;
var statearr_28465_28509 = state_28459__$1;
(statearr_28465_28509[(2)] = inst_28452);

(statearr_28465_28509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (13))){
var inst_28443 = (state_28459[(7)]);
var inst_28445 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28443),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_28446 = fluree.db.dbproto._tag_id.call(null,this$,inst_28445);
var state_28459__$1 = state_28459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28459__$1,(16),inst_28446);
} else {
if((state_val_28460 === (6))){
var inst_28433 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_28459__$1 = state_28459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28459__$1,(9),inst_28433);
} else {
if((state_val_28460 === (3))){
var inst_28457 = (state_28459[(2)]);
var state_28459__$1 = state_28459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28459__$1,inst_28457);
} else {
if((state_val_28460 === (12))){
var inst_28443 = (state_28459[(7)]);
var inst_28443__$1 = (state_28459[(2)]);
var state_28459__$1 = (function (){var statearr_28466 = state_28459;
(statearr_28466[(7)] = inst_28443__$1);

return statearr_28466;
})();
if(cljs.core.truth_(inst_28443__$1)){
var statearr_28467_28510 = state_28459__$1;
(statearr_28467_28510[(1)] = (13));

} else {
var statearr_28468_28511 = state_28459__$1;
(statearr_28468_28511[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (2))){
var _ = (function (){var statearr_28469 = state_28459;
(statearr_28469[(4)] = cljs.core.cons.call(null,(5),(state_28459[(4)])));

return statearr_28469;
})();
var inst_28431 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_28459__$1 = state_28459;
if(inst_28431){
var statearr_28470_28512 = state_28459__$1;
(statearr_28470_28512[(1)] = (6));

} else {
var statearr_28471_28513 = state_28459__$1;
(statearr_28471_28513[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (11))){
var inst_28441 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28459__$1 = state_28459;
var statearr_28473_28514 = state_28459__$1;
(statearr_28473_28514[(2)] = inst_28441);

(statearr_28473_28514[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (9))){
var inst_28435 = (state_28459[(2)]);
var inst_28436 = fluree.db.util.async.throw_err.call(null,inst_28435);
var state_28459__$1 = state_28459;
var statearr_28474_28515 = state_28459__$1;
(statearr_28474_28515[(2)] = inst_28436);

(statearr_28474_28515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (5))){
var _ = (function (){var statearr_28475 = state_28459;
(statearr_28475[(4)] = cljs.core.rest.call(null,(state_28459[(4)])));

return statearr_28475;
})();
var state_28459__$1 = state_28459;
var ex28472 = (state_28459__$1[(2)]);
var statearr_28476_28516 = state_28459__$1;
(statearr_28476_28516[(5)] = ex28472);


if((ex28472 instanceof Error)){
var statearr_28477_28517 = state_28459__$1;
(statearr_28477_28517[(1)] = (4));

(statearr_28477_28517[(5)] = null);

} else {
throw ex28472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (14))){
var state_28459__$1 = state_28459;
var statearr_28478_28518 = state_28459__$1;
(statearr_28478_28518[(2)] = null);

(statearr_28478_28518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (16))){
var inst_28448 = (state_28459[(2)]);
var inst_28449 = fluree.db.util.async.throw_err.call(null,inst_28448);
var state_28459__$1 = state_28459;
var statearr_28479_28519 = state_28459__$1;
(statearr_28479_28519[(2)] = inst_28449);

(statearr_28479_28519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (10))){
var state_28459__$1 = state_28459;
var statearr_28480_28520 = state_28459__$1;
(statearr_28480_28520[(2)] = pred);

(statearr_28480_28520[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (8))){
var inst_28454 = (state_28459[(2)]);
var _ = (function (){var statearr_28481 = state_28459;
(statearr_28481[(4)] = cljs.core.rest.call(null,(state_28459[(4)])));

return statearr_28481;
})();
var state_28459__$1 = state_28459;
var statearr_28482_28521 = state_28459__$1;
(statearr_28482_28521[(2)] = inst_28454);

(statearr_28482_28521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2703__auto__ = null;
var fluree$db$graphdb$state_machine__2703__auto____0 = (function (){
var statearr_28483 = [null,null,null,null,null,null,null,null];
(statearr_28483[(0)] = fluree$db$graphdb$state_machine__2703__auto__);

(statearr_28483[(1)] = (1));

return statearr_28483;
});
var fluree$db$graphdb$state_machine__2703__auto____1 = (function (state_28459){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28484){var ex__2706__auto__ = e28484;
var statearr_28485_28522 = state_28459;
(statearr_28485_28522[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28459[(4)]))){
var statearr_28486_28523 = state_28459;
(statearr_28486_28523[(1)] = cljs.core.first.call(null,(state_28459[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28524 = state_28459;
state_28459 = G__28524;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2703__auto__ = function(state_28459){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2703__auto____1.call(this,state_28459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2703__auto____0;
fluree$db$graphdb$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2703__auto____1;
return fluree$db$graphdb$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28487 = f__2726__auto__.call(null);
(statearr_28487[(6)] = c__2725__auto__);

return statearr_28487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k28526,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__28530 = k28526;
var G__28530__$1 = (((G__28530 instanceof cljs.core.Keyword))?G__28530.fqn:null);
switch (G__28530__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28526,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__28531){
var vec__28532 = p__28531;
var k__5367__auto__ = cljs.core.nth.call(null,vec__28532,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__28532,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28525){
var self__ = this;
var G__28525__$1 = this;
return (new cljs.core.RecordIter((0),G__28525__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28527,other28528){
var self__ = this;
var this28527__$1 = this;
return (((!((other28528 == null)))) && ((((this28527__$1.constructor === other28528.constructor)) && (((cljs.core._EQ_.call(null,this28527__$1.conn,other28528.conn)) && (((cljs.core._EQ_.call(null,this28527__$1.network,other28528.network)) && (((cljs.core._EQ_.call(null,this28527__$1.dbid,other28528.dbid)) && (((cljs.core._EQ_.call(null,this28527__$1.block,other28528.block)) && (((cljs.core._EQ_.call(null,this28527__$1.t,other28528.t)) && (((cljs.core._EQ_.call(null,this28527__$1.tt_id,other28528.tt_id)) && (((cljs.core._EQ_.call(null,this28527__$1.stats,other28528.stats)) && (((cljs.core._EQ_.call(null,this28527__$1.spot,other28528.spot)) && (((cljs.core._EQ_.call(null,this28527__$1.psot,other28528.psot)) && (((cljs.core._EQ_.call(null,this28527__$1.post,other28528.post)) && (((cljs.core._EQ_.call(null,this28527__$1.opst,other28528.opst)) && (((cljs.core._EQ_.call(null,this28527__$1.schema,other28528.schema)) && (((cljs.core._EQ_.call(null,this28527__$1.settings,other28528.settings)) && (((cljs.core._EQ_.call(null,this28527__$1.index_configs,other28528.index_configs)) && (((cljs.core._EQ_.call(null,this28527__$1.schema_cache,other28528.schema_cache)) && (((cljs.core._EQ_.call(null,this28527__$1.novelty,other28528.novelty)) && (((cljs.core._EQ_.call(null,this28527__$1.permissions,other28528.permissions)) && (((cljs.core._EQ_.call(null,this28527__$1.fork,other28528.fork)) && (((cljs.core._EQ_.call(null,this28527__$1.fork_block,other28528.fork_block)) && (((cljs.core._EQ_.call(null,this28527__$1.current_db_fn,other28528.current_db_fn)) && (cljs.core._EQ_.call(null,this28527__$1.__extmap,other28528.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k28526){
var self__ = this;
var this__5350__auto____$1 = this;
var G__28535 = k28526;
var G__28535__$1 = (((G__28535 instanceof cljs.core.Keyword))?G__28535.fqn:null);
switch (G__28535__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k28526);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__28525){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__28536 = cljs.core.keyword_identical_QMARK_;
var expr__28537 = k__5352__auto__;
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__28537))){
return (new fluree.db.graphdb.GraphDb(G__28525,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__28525,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__28525,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__28525,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__28525,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__28525,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__28525,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__28525,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__28525,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__28525,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__28525,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__28525,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__28525,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__28525,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__28525,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__28525,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__28525,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__28525,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__28525,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28536.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__28537))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__28525,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__28525),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__28525){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__28525,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__28529){
var extmap__5385__auto__ = (function (){var G__28539 = cljs.core.dissoc.call(null,G__28529,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__28529)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__28539);
} else {
return G__28539;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__28529),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__28529),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
