// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e20838){var e = e20838;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__20839_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__20839_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__20839_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__20839_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20840_SHARP_){
return cljs.core.conj.call(null,p1__20840_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20841_SHARP_){
return cljs.core.conj.call(null,p1__20841_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20846 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__20846,(0),null);
var _ = cljs.core.nth.call(null,vec__20846,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20842_SHARP_){
return cljs.core.conj.call(null,p1__20842_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20849 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__20849,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__20849,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20843_SHARP_){
return cljs.core.conj.call(null,p1__20843_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20844_SHARP_){
return cljs.core.conj.call(null,p1__20844_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20845_SHARP_){
return cljs.core.conj.call(null,p1__20845_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__20852_SHARP_){
return cljs.core.nth.call(null,array,p1__20852_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20855,optional_QMARK_,fuel,max_fuel){
var map__20856 = p__20855;
var map__20856__$1 = cljs.core.__destructure_map.call(null,map__20856);
var res = map__20856__$1;
var vars = cljs.core.get.call(null,map__20856__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_20922){
var state_val_20923 = (state_20922[(1)]);
if((state_val_20923 === (7))){
var inst_20911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20912 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_20913 = cljs.core.conj.call(null,inst_20912,clause);
var inst_20914 = [null,inst_20913];
var inst_20915 = (new cljs.core.PersistentVector(null,2,(5),inst_20911,inst_20914,null));
var state_20922__$1 = state_20922;
var statearr_20924_20952 = state_20922__$1;
(statearr_20924_20952[(2)] = inst_20915);

(statearr_20924_20952[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (1))){
var state_20922__$1 = state_20922;
var statearr_20925_20953 = state_20922__$1;
(statearr_20925_20953[(2)] = null);

(statearr_20925_20953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (4))){
var inst_20857 = (state_20922[(2)]);
var state_20922__$1 = state_20922;
var statearr_20926_20954 = state_20922__$1;
(statearr_20926_20954[(2)] = inst_20857);

(statearr_20926_20954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (15))){
var inst_20900 = (state_20922[(2)]);
var inst_20901 = fluree.db.util.async.throw_err.call(null,inst_20900);
var inst_20902 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20901);
var inst_20903 = cljs.core.count.call(null,inst_20902);
var inst_20904 = fluree.db.query.analytical.add_fuel.call(null,inst_20903,fuel,max_fuel);
var inst_20905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20906 = [inst_20901,r];
var inst_20907 = (new cljs.core.PersistentVector(null,2,(5),inst_20905,inst_20906,null));
var state_20922__$1 = (function (){var statearr_20927 = state_20922;
(statearr_20927[(7)] = inst_20904);

return statearr_20927;
})();
var statearr_20928_20955 = state_20922__$1;
(statearr_20928_20955[(2)] = inst_20907);

(statearr_20928_20955[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (13))){
var inst_20866 = (state_20922[(8)]);
var inst_20879 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20880 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_20879);
var inst_20881 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20866);
var inst_20882 = cljs.core.apply.call(null,cljs.core.concat,inst_20881);
var inst_20883 = cljs.core.set.call(null,inst_20882);
var inst_20884 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20880);
var inst_20885 = cljs.core.apply.call(null,cljs.core.concat,inst_20884);
var inst_20886 = cljs.core.into.call(null,inst_20883,inst_20885);
var inst_20887 = (function (){var all_wd = inst_20866;
var optional = inst_20880;
var all_wd_vars = inst_20883;
var all_vars = inst_20886;
return (function (p1__20853_SHARP_){
return all_vars.call(null,p1__20853_SHARP_);
});
})();
var inst_20888 = cljs.core.keys.call(null,vars);
var inst_20889 = cljs.core.map.call(null,inst_20887,inst_20888);
var inst_20890 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_20889);
var inst_20891 = cljs.core.set.call(null,inst_20890);
var inst_20892 = (function (){var all_wd = inst_20866;
var optional = inst_20880;
var all_wd_vars = inst_20883;
var all_vars = inst_20886;
var intersecting_vars = inst_20891;
return (function (p1__20854_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__20854_SHARP_);
});
})();
var inst_20893 = cljs.core.map.call(null,inst_20892,inst_20866);
var inst_20894 = cljs.core.apply.call(null,cljs.core.concat,inst_20893);
var inst_20895 = fluree.db.query.analytical.select_from_tuples.call(null,inst_20894,res);
var inst_20896 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_20866,inst_20891,vars);
var inst_20897 = cljs.core.remove.call(null,inst_20891,inst_20886);
var inst_20898 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_20896,inst_20894,inst_20895,inst_20897,inst_20880);
var state_20922__$1 = state_20922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20922__$1,(15),inst_20898);
} else {
if((state_val_20923 === (6))){
var inst_20867 = (state_20922[(9)]);
var inst_20865 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20866 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_20865);
var inst_20867__$1 = optional_QMARK_;
var state_20922__$1 = (function (){var statearr_20929 = state_20922;
(statearr_20929[(9)] = inst_20867__$1);

(statearr_20929[(8)] = inst_20866);

return statearr_20929;
})();
if(cljs.core.truth_(inst_20867__$1)){
var statearr_20930_20956 = state_20922__$1;
(statearr_20930_20956[(1)] = (9));

} else {
var statearr_20931_20957 = state_20922__$1;
(statearr_20931_20957[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (3))){
var inst_20920 = (state_20922[(2)]);
var state_20922__$1 = state_20922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20922__$1,inst_20920);
} else {
if((state_val_20923 === (12))){
var inst_20875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20876 = [null,r];
var inst_20877 = (new cljs.core.PersistentVector(null,2,(5),inst_20875,inst_20876,null));
var state_20922__$1 = state_20922;
var statearr_20932_20958 = state_20922__$1;
(statearr_20932_20958[(2)] = inst_20877);

(statearr_20932_20958[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (2))){
var _ = (function (){var statearr_20933 = state_20922;
(statearr_20933[(4)] = cljs.core.cons.call(null,(5),(state_20922[(4)])));

return statearr_20933;
})();
var inst_20863 = (r == null);
var state_20922__$1 = state_20922;
if(cljs.core.truth_(inst_20863)){
var statearr_20934_20959 = state_20922__$1;
(statearr_20934_20959[(1)] = (6));

} else {
var statearr_20935_20960 = state_20922__$1;
(statearr_20935_20960[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (11))){
var inst_20873 = (state_20922[(2)]);
var state_20922__$1 = state_20922;
if(cljs.core.truth_(inst_20873)){
var statearr_20937_20961 = state_20922__$1;
(statearr_20937_20961[(1)] = (12));

} else {
var statearr_20938_20962 = state_20922__$1;
(statearr_20938_20962[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (9))){
var inst_20866 = (state_20922[(8)]);
var inst_20869 = cljs.core.empty_QMARK_.call(null,inst_20866);
var inst_20870 = (!(inst_20869));
var state_20922__$1 = state_20922;
var statearr_20939_20963 = state_20922__$1;
(statearr_20939_20963[(2)] = inst_20870);

(statearr_20939_20963[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (5))){
var _ = (function (){var statearr_20940 = state_20922;
(statearr_20940[(4)] = cljs.core.rest.call(null,(state_20922[(4)])));

return statearr_20940;
})();
var state_20922__$1 = state_20922;
var ex20936 = (state_20922__$1[(2)]);
var statearr_20941_20964 = state_20922__$1;
(statearr_20941_20964[(5)] = ex20936);


if((ex20936 instanceof Error)){
var statearr_20942_20965 = state_20922__$1;
(statearr_20942_20965[(1)] = (4));

(statearr_20942_20965[(5)] = null);

} else {
throw ex20936;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (14))){
var inst_20909 = (state_20922[(2)]);
var state_20922__$1 = state_20922;
var statearr_20943_20966 = state_20922__$1;
(statearr_20943_20966[(2)] = inst_20909);

(statearr_20943_20966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (10))){
var inst_20867 = (state_20922[(9)]);
var state_20922__$1 = state_20922;
var statearr_20944_20967 = state_20922__$1;
(statearr_20944_20967[(2)] = inst_20867);

(statearr_20944_20967[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20923 === (8))){
var inst_20917 = (state_20922[(2)]);
var _ = (function (){var statearr_20945 = state_20922;
(statearr_20945[(4)] = cljs.core.rest.call(null,(state_20922[(4)])));

return statearr_20945;
})();
var state_20922__$1 = state_20922;
var statearr_20946_20968 = state_20922__$1;
(statearr_20946_20968[(2)] = inst_20917);

(statearr_20946_20968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto____0 = (function (){
var statearr_20947 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20947[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto__);

(statearr_20947[(1)] = (1));

return statearr_20947;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto____1 = (function (state_20922){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_20922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e20948){var ex__2706__auto__ = e20948;
var statearr_20949_20969 = state_20922;
(statearr_20949_20969[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_20922[(4)]))){
var statearr_20950_20970 = state_20922;
(statearr_20950_20970[(1)] = cljs.core.first.call(null,(state_20922[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20971 = state_20922;
state_20922 = G__20971;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto__ = function(state_20922){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto____1.call(this,state_20922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_20951 = f__2726__auto__.call(null);
(statearr_20951[(6)] = c__2725__auto__);

return statearr_20951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20973 = arguments.length;
switch (G__20973) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_21067){
var state_val_21068 = (state_21067[(1)]);
if((state_val_21068 === (7))){
var inst_20980 = (state_21067[(7)]);
var inst_20990 = clojure.string.starts_with_QMARK_.call(null,inst_20980,"$fdb");
var state_21067__$1 = state_21067;
if(inst_20990){
var statearr_21069_21118 = state_21067__$1;
(statearr_21069_21118[(1)] = (9));

} else {
var statearr_21070_21119 = state_21067__$1;
(statearr_21070_21119[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (20))){
var state_21067__$1 = state_21067;
var statearr_21071_21120 = state_21067__$1;
(statearr_21071_21120[(2)] = null);

(statearr_21071_21120[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (27))){
var inst_21030 = (state_21067[(8)]);
var state_21067__$1 = state_21067;
var statearr_21072_21121 = state_21067__$1;
(statearr_21072_21121[(2)] = inst_21030);

(statearr_21072_21121[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (1))){
var state_21067__$1 = state_21067;
var statearr_21073_21122 = state_21067__$1;
(statearr_21073_21122[(2)] = null);

(statearr_21073_21122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (24))){
var inst_21053 = (state_21067[(2)]);
var state_21067__$1 = state_21067;
var statearr_21074_21123 = state_21067__$1;
(statearr_21074_21123[(2)] = inst_21053);

(statearr_21074_21123[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (4))){
var inst_20974 = (state_21067[(2)]);
var state_21067__$1 = state_21067;
var statearr_21075_21124 = state_21067__$1;
(statearr_21075_21124[(2)] = inst_20974);

(statearr_21075_21124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (15))){
var inst_20997 = (state_21067[(9)]);
var inst_21003 = (state_21067[(2)]);
var inst_21004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21005 = cljs.core.PersistentVector.EMPTY;
var inst_21006 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_21007 = cljs.core.into.call(null,inst_21005,inst_21006);
var inst_21008 = [inst_20997,inst_21007];
var inst_21009 = (new cljs.core.PersistentVector(null,2,(5),inst_21004,inst_21008,null));
var state_21067__$1 = (function (){var statearr_21076 = state_21067;
(statearr_21076[(10)] = inst_21003);

return statearr_21076;
})();
var statearr_21077_21125 = state_21067__$1;
(statearr_21077_21125[(2)] = inst_21009);

(statearr_21077_21125[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (21))){
var inst_21056 = (state_21067[(2)]);
var state_21067__$1 = state_21067;
var statearr_21078_21126 = state_21067__$1;
(statearr_21078_21126[(2)] = inst_21056);

(statearr_21078_21126[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (13))){
var inst_20997 = (state_21067[(9)]);
var inst_21000 = (function(){throw inst_20997})();
var state_21067__$1 = state_21067;
var statearr_21079_21127 = state_21067__$1;
(statearr_21079_21127[(2)] = inst_21000);

(statearr_21079_21127[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (22))){
var inst_21021 = (state_21067[(11)]);
var inst_21019 = (state_21067[(12)]);
var inst_21023 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_21019);
var inst_21024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21025 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_21021];
var inst_21026 = (new cljs.core.PersistentVector(null,2,(5),inst_21024,inst_21025,null));
var inst_21027 = cljs.core.get_in.call(null,opts,inst_21026);
var state_21067__$1 = (function (){var statearr_21080 = state_21067;
(statearr_21080[(13)] = inst_21023);

return statearr_21080;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21067__$1,(25),inst_21027);
} else {
if((state_val_21068 === (29))){
var inst_21034 = (state_21067[(2)]);
var inst_21035 = fluree.db.util.async.throw_err.call(null,inst_21034);
var state_21067__$1 = state_21067;
var statearr_21081_21128 = state_21067__$1;
(statearr_21081_21128[(2)] = inst_21035);

(statearr_21081_21128[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (6))){
var inst_20983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20984 = cljs.core.PersistentVector.EMPTY;
var inst_20985 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20986 = cljs.core.into.call(null,inst_20984,inst_20985);
var inst_20987 = [db,inst_20986];
var inst_20988 = (new cljs.core.PersistentVector(null,2,(5),inst_20983,inst_20987,null));
var state_21067__$1 = state_21067;
var statearr_21082_21129 = state_21067__$1;
(statearr_21082_21129[(2)] = inst_20988);

(statearr_21082_21129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (28))){
var inst_21038 = (state_21067[(2)]);
var inst_21039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21040 = cljs.core.PersistentVector.EMPTY;
var inst_21041 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_21042 = cljs.core.into.call(null,inst_21040,inst_21041);
var inst_21043 = [inst_21038,inst_21042];
var inst_21044 = (new cljs.core.PersistentVector(null,2,(5),inst_21039,inst_21043,null));
var state_21067__$1 = state_21067;
var statearr_21083_21130 = state_21067__$1;
(statearr_21083_21130[(2)] = inst_21044);

(statearr_21083_21130[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (25))){
var inst_21023 = (state_21067[(13)]);
var inst_21029 = (state_21067[(2)]);
var inst_21030 = fluree.db.util.async.throw_err.call(null,inst_21029);
var state_21067__$1 = (function (){var statearr_21084 = state_21067;
(statearr_21084[(8)] = inst_21030);

return statearr_21084;
})();
if(cljs.core.truth_(inst_21023)){
var statearr_21085_21131 = state_21067__$1;
(statearr_21085_21131[(1)] = (26));

} else {
var statearr_21086_21132 = state_21067__$1;
(statearr_21086_21132[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (17))){
var state_21067__$1 = state_21067;
var statearr_21087_21133 = state_21067__$1;
(statearr_21087_21133[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (3))){
var inst_21065 = (state_21067[(2)]);
var state_21067__$1 = state_21067;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21067__$1,inst_21065);
} else {
if((state_val_21068 === (12))){
var inst_20997 = (state_21067[(9)]);
var inst_20996 = (state_21067[(2)]);
var inst_20997__$1 = fluree.db.util.async.throw_err.call(null,inst_20996);
var inst_20998 = fluree.db.util.core.exception_QMARK_.call(null,inst_20997__$1);
var state_21067__$1 = (function (){var statearr_21089 = state_21067;
(statearr_21089[(9)] = inst_20997__$1);

return statearr_21089;
})();
if(inst_20998){
var statearr_21090_21134 = state_21067__$1;
(statearr_21090_21134[(1)] = (13));

} else {
var statearr_21091_21135 = state_21067__$1;
(statearr_21091_21135[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (2))){
var inst_20980 = (state_21067[(7)]);
var _ = (function (){var statearr_21092 = state_21067;
(statearr_21092[(4)] = cljs.core.cons.call(null,(5),(state_21067[(4)])));

return statearr_21092;
})();
var inst_20980__$1 = cljs.core.first.call(null,clause);
var inst_20981 = cljs.core._EQ_.call(null,"$fdb",inst_20980__$1);
var state_21067__$1 = (function (){var statearr_21093 = state_21067;
(statearr_21093[(7)] = inst_20980__$1);

return statearr_21093;
})();
if(inst_20981){
var statearr_21094_21136 = state_21067__$1;
(statearr_21094_21136[(1)] = (6));

} else {
var statearr_21095_21137 = state_21067__$1;
(statearr_21095_21137[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (23))){
var inst_20980 = (state_21067[(7)]);
var inst_21046 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20980)," is not supported in Fluree"].join('');
var inst_21047 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21048 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21049 = cljs.core.PersistentHashMap.fromArrays(inst_21047,inst_21048);
var inst_21050 = cljs.core.ex_info.call(null,inst_21046,inst_21049);
var inst_21051 = (function(){throw inst_21050})();
var state_21067__$1 = state_21067;
var statearr_21096_21138 = state_21067__$1;
(statearr_21096_21138[(2)] = inst_21051);

(statearr_21096_21138[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (19))){
var inst_21021 = (state_21067[(11)]);
var inst_20980 = (state_21067[(7)]);
var inst_21018 = fluree.db.query.analytical.isolate_source_name.call(null,inst_20980);
var inst_21019 = fluree.db.query.analytical.isolate_source_block.call(null,inst_20980);
var inst_21020 = cljs.core.keyword.call(null,inst_21018);
var inst_21021__$1 = cljs.core.get.call(null,prefixes,inst_21020);
var state_21067__$1 = (function (){var statearr_21097 = state_21067;
(statearr_21097[(11)] = inst_21021__$1);

(statearr_21097[(12)] = inst_21019);

return statearr_21097;
})();
if(cljs.core.truth_(inst_21021__$1)){
var statearr_21098_21139 = state_21067__$1;
(statearr_21098_21139[(1)] = (22));

} else {
var statearr_21099_21140 = state_21067__$1;
(statearr_21099_21140[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (11))){
var inst_21060 = (state_21067[(2)]);
var state_21067__$1 = state_21067;
var statearr_21101_21141 = state_21067__$1;
(statearr_21101_21141[(2)] = inst_21060);

(statearr_21101_21141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (9))){
var inst_20980 = (state_21067[(7)]);
var inst_20992 = cljs.core.subs.call(null,inst_20980,(4));
var inst_20993 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20992);
var inst_20994 = fluree.db.time_travel.as_of_block.call(null,db,inst_20993);
var state_21067__$1 = state_21067;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21067__$1,(12),inst_20994);
} else {
if((state_val_21068 === (5))){
var _ = (function (){var statearr_21102 = state_21067;
(statearr_21102[(4)] = cljs.core.rest.call(null,(state_21067[(4)])));

return statearr_21102;
})();
var state_21067__$1 = state_21067;
var ex21100 = (state_21067__$1[(2)]);
var statearr_21103_21142 = state_21067__$1;
(statearr_21103_21142[(5)] = ex21100);


if((ex21100 instanceof Error)){
var statearr_21104_21143 = state_21067__$1;
(statearr_21104_21143[(1)] = (4));

(statearr_21104_21143[(5)] = null);

} else {
throw ex21100;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (14))){
var state_21067__$1 = state_21067;
var statearr_21105_21144 = state_21067__$1;
(statearr_21105_21144[(2)] = null);

(statearr_21105_21144[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (26))){
var inst_21030 = (state_21067[(8)]);
var inst_21023 = (state_21067[(13)]);
var inst_21032 = fluree.db.time_travel.as_of_block.call(null,inst_21030,inst_21023);
var state_21067__$1 = state_21067;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21067__$1,(29),inst_21032);
} else {
if((state_val_21068 === (16))){
var inst_21013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21014 = ["$wd",clause];
var inst_21015 = (new cljs.core.PersistentVector(null,2,(5),inst_21013,inst_21014,null));
var state_21067__$1 = state_21067;
var statearr_21106_21145 = state_21067__$1;
(statearr_21106_21145[(2)] = inst_21015);

(statearr_21106_21145[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (10))){
var inst_20980 = (state_21067[(7)]);
var inst_21011 = cljs.core._EQ_.call(null,"$wd",inst_20980);
var state_21067__$1 = state_21067;
if(inst_21011){
var statearr_21107_21146 = state_21067__$1;
(statearr_21107_21146[(1)] = (16));

} else {
var statearr_21108_21147 = state_21067__$1;
(statearr_21108_21147[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (18))){
var inst_21058 = (state_21067[(2)]);
var state_21067__$1 = state_21067;
var statearr_21109_21148 = state_21067__$1;
(statearr_21109_21148[(2)] = inst_21058);

(statearr_21109_21148[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21068 === (8))){
var inst_21062 = (state_21067[(2)]);
var _ = (function (){var statearr_21110 = state_21067;
(statearr_21110[(4)] = cljs.core.rest.call(null,(state_21067[(4)])));

return statearr_21110;
})();
var state_21067__$1 = state_21067;
var statearr_21111_21149 = state_21067__$1;
(statearr_21111_21149[(2)] = inst_21062);

(statearr_21111_21149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2703__auto__ = null;
var fluree$db$query$analytical$state_machine__2703__auto____0 = (function (){
var statearr_21112 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21112[(0)] = fluree$db$query$analytical$state_machine__2703__auto__);

(statearr_21112[(1)] = (1));

return statearr_21112;
});
var fluree$db$query$analytical$state_machine__2703__auto____1 = (function (state_21067){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_21067);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e21113){var ex__2706__auto__ = e21113;
var statearr_21114_21150 = state_21067;
(statearr_21114_21150[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_21067[(4)]))){
var statearr_21115_21151 = state_21067;
(statearr_21115_21151[(1)] = cljs.core.first.call(null,(state_21067[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21152 = state_21067;
state_21067 = G__21152;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2703__auto__ = function(state_21067){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2703__auto____1.call(this,state_21067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2703__auto____0;
fluree$db$query$analytical$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2703__auto____1;
return fluree$db$query$analytical$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_21116 = f__2726__auto__.call(null);
(statearr_21116[(6)] = c__2725__auto__);

return statearr_21116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__21153){
var vec__21154 = p__21153;
var sub = cljs.core.nth.call(null,vec__21154,(0),null);
var obj = cljs.core.nth.call(null,vec__21154,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__21157_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__21157_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__21161 = subjects;
var vec__21162 = G__21161;
var seq__21163 = cljs.core.seq.call(null,vec__21162);
var first__21164 = cljs.core.first.call(null,seq__21163);
var seq__21163__$1 = cljs.core.next.call(null,seq__21163);
var subject = first__21164;
var r = seq__21163__$1;
var acc = expanded_map;
var G__21161__$1 = G__21161;
var acc__$1 = acc;
while(true){
var vec__21168 = G__21161__$1;
var seq__21169 = cljs.core.seq.call(null,vec__21168);
var first__21170 = cljs.core.first.call(null,seq__21169);
var seq__21169__$1 = cljs.core.next.call(null,seq__21169);
var subject__$1 = first__21170;
var r__$1 = seq__21169__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__21171 = r__$1;
var G__21172 = acc__$2;
G__21161__$1 = G__21171;
acc__$1 = G__21172;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__21161__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21168,seq__21169,first__21170,seq__21169__$1,subject__$1,r__$1,acc__$2,G__21161,vec__21162,seq__21163,first__21164,seq__21163__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__21161__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21168,seq__21169,first__21170,seq__21169__$1,subject__$1,r__$1,acc__$2,G__21161,vec__21162,seq__21163,first__21164,seq__21163__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__21161__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21168,seq__21169,first__21170,seq__21169__$1,subject__$1,r__$1,acc__$2,G__21161,vec__21162,seq__21163,first__21164,seq__21163__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__21161__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21168,seq__21169,first__21170,seq__21169__$1,subject__$1,r__$1,acc__$2,G__21161,vec__21162,seq__21163,first__21164,seq__21163__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__21161__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21168,seq__21169,first__21170,seq__21169__$1,subject__$1,r__$1,acc__$2,G__21161,vec__21162,seq__21163,first__21164,seq__21163__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__21161__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21168,seq__21169,first__21170,seq__21169__$1,subject__$1,r__$1,acc__$2,G__21161,vec__21162,seq__21163,first__21164,seq__21163__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__21173 = r__$1;
var G__21174 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__21161__$1 = G__21173;
acc__$1 = G__21174;
continue;
} else {
var G__21175 = subjects;
var G__21176 = acc_STAR_;
G__21161__$1 = G__21175;
acc__$1 = G__21176;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__21177_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__21177_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_21268){
var state_val_21269 = (state_21268[(1)]);
if((state_val_21269 === (7))){
var state_21268__$1 = state_21268;
var statearr_21270_21316 = state_21268__$1;
(statearr_21270_21316[(2)] = (100));

(statearr_21270_21316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (20))){
var inst_21217 = (state_21268[(7)]);
var state_21268__$1 = state_21268;
var statearr_21271_21317 = state_21268__$1;
(statearr_21271_21317[(2)] = inst_21217);

(statearr_21271_21317[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (1))){
var state_21268__$1 = state_21268;
var statearr_21272_21318 = state_21268__$1;
(statearr_21272_21318[(2)] = null);

(statearr_21272_21318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (24))){
var inst_21256 = (state_21268[(8)]);
var inst_21255 = (state_21268[(9)]);
var inst_21254 = (state_21268[(10)]);
var inst_21189 = (state_21268[(11)]);
var inst_21259 = (function (){var max_depth = inst_21189;
var recur_map__$1 = inst_21255;
var subjects = inst_21254;
var tuples = inst_21256;
return (function (p1__21178_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__21178_SHARP_)],null));
});
})();
var inst_21260 = cljs.core.map.call(null,inst_21259,inst_21256);
var inst_21261 = cljs.core.distinct.call(null,inst_21260);
var state_21268__$1 = state_21268;
var statearr_21273_21319 = state_21268__$1;
(statearr_21273_21319[(2)] = inst_21261);

(statearr_21273_21319[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (4))){
var inst_21179 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
var statearr_21274_21320 = state_21268__$1;
(statearr_21274_21320[(2)] = inst_21179);

(statearr_21274_21320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (15))){
var inst_21202 = (state_21268[(12)]);
var inst_21213 = cljs.core.PersistentVector.EMPTY;
var inst_21214 = cljs.core.seq.call(null,inst_21202);
var inst_21215 = cljs.core.first.call(null,inst_21214);
var inst_21216 = cljs.core.next.call(null,inst_21214);
var inst_21217 = inst_21213;
var inst_21218 = inst_21202;
var state_21268__$1 = (function (){var statearr_21275 = state_21268;
(statearr_21275[(13)] = inst_21218);

(statearr_21275[(14)] = inst_21216);

(statearr_21275[(15)] = inst_21215);

(statearr_21275[(7)] = inst_21217);

return statearr_21275;
})();
var statearr_21276_21321 = state_21268__$1;
(statearr_21276_21321[(2)] = null);

(statearr_21276_21321[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (21))){
var inst_21238 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
var statearr_21277_21322 = state_21268__$1;
(statearr_21277_21322[(2)] = inst_21238);

(statearr_21277_21322[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (13))){
var inst_21251 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
var statearr_21278_21323 = state_21268__$1;
(statearr_21278_21323[(2)] = inst_21251);

(statearr_21278_21323[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (22))){
var inst_21225 = (state_21268[(16)]);
var inst_21217 = (state_21268[(7)]);
var inst_21232 = (state_21268[(2)]);
var inst_21233 = fluree.db.util.async.throw_err.call(null,inst_21232);
var inst_21234 = cljs.core.concat.call(null,inst_21217,inst_21233);
var inst_21217__$1 = inst_21234;
var inst_21218 = inst_21225;
var state_21268__$1 = (function (){var statearr_21279 = state_21268;
(statearr_21279[(13)] = inst_21218);

(statearr_21279[(7)] = inst_21217__$1);

return statearr_21279;
})();
var statearr_21280_21324 = state_21268__$1;
(statearr_21280_21324[(2)] = null);

(statearr_21280_21324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (6))){
var inst_21185 = (state_21268[(17)]);
var state_21268__$1 = state_21268;
var statearr_21281_21325 = state_21268__$1;
(statearr_21281_21325[(2)] = inst_21185);

(statearr_21281_21325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (25))){
var inst_21263 = (state_21268[(2)]);
var _ = (function (){var statearr_21282 = state_21268;
(statearr_21282[(4)] = cljs.core.rest.call(null,(state_21268[(4)])));

return statearr_21282;
})();
var state_21268__$1 = state_21268;
var statearr_21283_21326 = state_21268__$1;
(statearr_21283_21326[(2)] = inst_21263);

(statearr_21283_21326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (17))){
var inst_21218 = (state_21268[(13)]);
var inst_21224 = (state_21268[(18)]);
var inst_21223 = cljs.core.seq.call(null,inst_21218);
var inst_21224__$1 = cljs.core.first.call(null,inst_21223);
var inst_21225 = cljs.core.next.call(null,inst_21223);
var state_21268__$1 = (function (){var statearr_21284 = state_21268;
(statearr_21284[(16)] = inst_21225);

(statearr_21284[(18)] = inst_21224__$1);

return statearr_21284;
})();
if(cljs.core.truth_(inst_21224__$1)){
var statearr_21285_21327 = state_21268__$1;
(statearr_21285_21327[(1)] = (19));

} else {
var statearr_21286_21328 = state_21268__$1;
(statearr_21286_21328[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (3))){
var inst_21266 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21268__$1,inst_21266);
} else {
if((state_val_21269 === (12))){
var inst_21191 = (state_21268[(19)]);
var inst_21202 = (state_21268[(12)]);
var inst_21197 = cljs.core.vals.call(null,inst_21191);
var inst_21198 = cljs.core.flatten.call(null,inst_21197);
var inst_21199 = cljs.core.set.call(null,inst_21198);
var inst_21200 = cljs.core.keys.call(null,inst_21191);
var inst_21201 = cljs.core.set.call(null,inst_21200);
var inst_21202__$1 = clojure.set.difference.call(null,inst_21199,inst_21201);
var inst_21203 = cljs.core.empty_QMARK_.call(null,inst_21202__$1);
var state_21268__$1 = (function (){var statearr_21287 = state_21268;
(statearr_21287[(12)] = inst_21202__$1);

return statearr_21287;
})();
if(inst_21203){
var statearr_21288_21329 = state_21268__$1;
(statearr_21288_21329[(1)] = (14));

} else {
var statearr_21289_21330 = state_21268__$1;
(statearr_21289_21330[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (2))){
var inst_21185 = (state_21268[(17)]);
var _ = (function (){var statearr_21290 = state_21268;
(statearr_21290[(4)] = cljs.core.cons.call(null,(5),(state_21268[(4)])));

return statearr_21290;
})();
var inst_21185__$1 = depth;
var state_21268__$1 = (function (){var statearr_21291 = state_21268;
(statearr_21291[(17)] = inst_21185__$1);

return statearr_21291;
})();
if(cljs.core.truth_(inst_21185__$1)){
var statearr_21292_21331 = state_21268__$1;
(statearr_21292_21331[(1)] = (6));

} else {
var statearr_21293_21332 = state_21268__$1;
(statearr_21293_21332[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (23))){
var inst_21256 = (state_21268[(8)]);
var state_21268__$1 = state_21268;
var statearr_21294_21333 = state_21268__$1;
(statearr_21294_21333[(2)] = inst_21256);

(statearr_21294_21333[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (19))){
var inst_21224 = (state_21268[(18)]);
var inst_21227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21228 = [inst_21224,predicate];
var inst_21229 = (new cljs.core.PersistentVector(null,2,(5),inst_21227,inst_21228,null));
var inst_21230 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21229);
var state_21268__$1 = state_21268;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21268__$1,(22),inst_21230);
} else {
if((state_val_21269 === (11))){
var inst_21191 = (state_21268[(19)]);
var state_21268__$1 = state_21268;
var statearr_21296_21334 = state_21268__$1;
(statearr_21296_21334[(2)] = inst_21191);

(statearr_21296_21334[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (9))){
var inst_21192 = (state_21268[(20)]);
var inst_21189 = (state_21268[(11)]);
var inst_21194 = (inst_21192 >= inst_21189);
var state_21268__$1 = state_21268;
if(cljs.core.truth_(inst_21194)){
var statearr_21297_21335 = state_21268__$1;
(statearr_21297_21335[(1)] = (11));

} else {
var statearr_21298_21336 = state_21268__$1;
(statearr_21298_21336[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (5))){
var _ = (function (){var statearr_21299 = state_21268;
(statearr_21299[(4)] = cljs.core.rest.call(null,(state_21268[(4)])));

return statearr_21299;
})();
var state_21268__$1 = state_21268;
var ex21295 = (state_21268__$1[(2)]);
var statearr_21300_21337 = state_21268__$1;
(statearr_21300_21337[(5)] = ex21295);


if((ex21295 instanceof Error)){
var statearr_21301_21338 = state_21268__$1;
(statearr_21301_21338[(1)] = (4));

(statearr_21301_21338[(5)] = null);

} else {
throw ex21295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (14))){
var inst_21191 = (state_21268[(19)]);
var state_21268__$1 = state_21268;
var statearr_21302_21339 = state_21268__$1;
(statearr_21302_21339[(2)] = inst_21191);

(statearr_21302_21339[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (16))){
var inst_21249 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
var statearr_21303_21340 = state_21268__$1;
(statearr_21303_21340[(2)] = inst_21249);

(statearr_21303_21340[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (10))){
var inst_21255 = (state_21268[(9)]);
var inst_21254 = (state_21268[(10)]);
var inst_21253 = (state_21268[(2)]);
var inst_21254__$1 = cljs.core.keys.call(null,inst_21253);
var inst_21255__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_21254__$1,inst_21253);
var inst_21256 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_21254__$1,inst_21255__$1);
var state_21268__$1 = (function (){var statearr_21304 = state_21268;
(statearr_21304[(8)] = inst_21256);

(statearr_21304[(9)] = inst_21255__$1);

(statearr_21304[(10)] = inst_21254__$1);

return statearr_21304;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_21305_21341 = state_21268__$1;
(statearr_21305_21341[(1)] = (23));

} else {
var statearr_21306_21342 = state_21268__$1;
(statearr_21306_21342[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (18))){
var inst_21191 = (state_21268[(19)]);
var inst_21192 = (state_21268[(20)]);
var inst_21240 = (state_21268[(2)]);
var inst_21241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21242 = [(0),(2)];
var inst_21243 = (new cljs.core.PersistentVector(null,2,(5),inst_21241,inst_21242,null));
var inst_21244 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_21243,inst_21240);
var inst_21245 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_21191,inst_21244);
var inst_21246 = (inst_21192 + (1));
var inst_21191__$1 = inst_21245;
var inst_21192__$1 = inst_21246;
var state_21268__$1 = (function (){var statearr_21307 = state_21268;
(statearr_21307[(19)] = inst_21191__$1);

(statearr_21307[(20)] = inst_21192__$1);

return statearr_21307;
})();
var statearr_21308_21343 = state_21268__$1;
(statearr_21308_21343[(2)] = null);

(statearr_21308_21343[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (8))){
var inst_21189 = (state_21268[(2)]);
var inst_21190 = recur_map;
var inst_21191 = inst_21190;
var inst_21192 = (1);
var state_21268__$1 = (function (){var statearr_21309 = state_21268;
(statearr_21309[(19)] = inst_21191);

(statearr_21309[(20)] = inst_21192);

(statearr_21309[(11)] = inst_21189);

return statearr_21309;
})();
var statearr_21310_21344 = state_21268__$1;
(statearr_21310_21344[(2)] = null);

(statearr_21310_21344[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto____0 = (function (){
var statearr_21311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21311[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto__);

(statearr_21311[(1)] = (1));

return statearr_21311;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto____1 = (function (state_21268){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_21268);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e21312){var ex__2706__auto__ = e21312;
var statearr_21313_21345 = state_21268;
(statearr_21313_21345[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_21268[(4)]))){
var statearr_21314_21346 = state_21268;
(statearr_21314_21346[(1)] = cljs.core.first.call(null,(state_21268[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21347 = state_21268;
state_21268 = G__21347;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto__ = function(state_21268){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto____1.call(this,state_21268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_21315 = f__2726__auto__.call(null);
(statearr_21315[(6)] = c__2725__auto__);

return statearr_21315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__21348,clause,fuel,max_fuel){
var map__21349 = p__21348;
var map__21349__$1 = cljs.core.__destructure_map.call(null,map__21349);
var res = map__21349__$1;
var headers = cljs.core.get.call(null,map__21349__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__21349__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__21349__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_21460){
var state_val_21461 = (state_21460[(1)]);
if((state_val_21461 === (7))){
var inst_21366 = (state_21460[(7)]);
var state_21460__$1 = state_21460;
var statearr_21462_21515 = state_21460__$1;
(statearr_21462_21515[(2)] = inst_21366);

(statearr_21462_21515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (20))){
var inst_21394 = (state_21460[(8)]);
var inst_21425 = typeof inst_21394 === 'number';
var state_21460__$1 = state_21460;
if(cljs.core.truth_(inst_21425)){
var statearr_21463_21516 = state_21460__$1;
(statearr_21463_21516[(1)] = (22));

} else {
var statearr_21464_21517 = state_21460__$1;
(statearr_21464_21517[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (27))){
var inst_21440 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21465_21518 = state_21460__$1;
(statearr_21465_21518[(2)] = inst_21440);

(statearr_21465_21518[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (1))){
var state_21460__$1 = state_21460;
var statearr_21466_21519 = state_21460__$1;
(statearr_21466_21519[(2)] = null);

(statearr_21466_21519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (24))){
var inst_21442 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21467_21520 = state_21460__$1;
(statearr_21467_21520[(2)] = inst_21442);

(statearr_21467_21520[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (4))){
var inst_21350 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21468_21521 = state_21460__$1;
(statearr_21468_21521[(2)] = inst_21350);

(statearr_21468_21521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (15))){
var inst_21408 = (state_21460[(2)]);
var inst_21409 = cljs.core.nth.call(null,clause,(2));
var inst_21410 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21409);
var state_21460__$1 = (function (){var statearr_21469 = state_21460;
(statearr_21469[(9)] = inst_21408);

return statearr_21469;
})();
if(cljs.core.truth_(inst_21410)){
var statearr_21470_21522 = state_21460__$1;
(statearr_21470_21522[(1)] = (16));

} else {
var statearr_21471_21523 = state_21460__$1;
(statearr_21471_21523[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (21))){
var inst_21397 = (state_21460[(10)]);
var inst_21367 = (state_21460[(11)]);
var inst_21396 = (state_21460[(12)]);
var inst_21444 = (state_21460[(2)]);
var inst_21445 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_21397,inst_21444,inst_21367,inst_21396);
var state_21460__$1 = state_21460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21460__$1,(28),inst_21445);
} else {
if((state_val_21461 === (13))){
var inst_21376 = (state_21460[(13)]);
var inst_21400 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21376)].join('');
var inst_21401 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21402 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21403 = cljs.core.PersistentHashMap.fromArrays(inst_21401,inst_21402);
var inst_21404 = cljs.core.ex_info.call(null,inst_21400,inst_21403);
var inst_21405 = (function(){throw inst_21404})();
var state_21460__$1 = state_21460;
var statearr_21472_21524 = state_21460__$1;
(statearr_21472_21524[(2)] = inst_21405);

(statearr_21472_21524[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (22))){
var inst_21392 = (state_21460[(14)]);
var inst_21394 = (state_21460[(8)]);
var inst_21427 = cljs.core.PersistentHashMap.EMPTY;
var inst_21428 = cljs.core.flatten.call(null,inst_21392);
var inst_21429 = cljs.core.assoc.call(null,inst_21427,inst_21394,inst_21428);
var state_21460__$1 = state_21460;
var statearr_21473_21525 = state_21460__$1;
(statearr_21473_21525[(2)] = inst_21429);

(statearr_21473_21525[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (6))){
var inst_21378 = (state_21460[(15)]);
var state_21460__$1 = state_21460;
var statearr_21474_21526 = state_21460__$1;
(statearr_21474_21526[(2)] = inst_21378);

(statearr_21474_21526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (28))){
var inst_21447 = (state_21460[(2)]);
var inst_21448 = fluree.db.util.async.throw_err.call(null,inst_21447);
var state_21460__$1 = state_21460;
var statearr_21475_21527 = state_21460__$1;
(statearr_21475_21527[(2)] = inst_21448);

(statearr_21475_21527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (25))){
var inst_21392 = (state_21460[(14)]);
var inst_21388 = (state_21460[(16)]);
var inst_21433 = cljs.core.PersistentHashMap.EMPTY;
var inst_21434 = cljs.core.first.call(null,inst_21388);
var inst_21435 = cljs.core.first.call(null,inst_21434);
var inst_21436 = cljs.core.flatten.call(null,inst_21392);
var inst_21437 = cljs.core.assoc.call(null,inst_21433,inst_21435,inst_21436);
var state_21460__$1 = state_21460;
var statearr_21476_21528 = state_21460__$1;
(statearr_21476_21528[(2)] = inst_21437);

(statearr_21476_21528[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (17))){
var inst_21376 = (state_21460[(13)]);
var inst_21413 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21376)].join('');
var inst_21414 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21415 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21416 = cljs.core.PersistentHashMap.fromArrays(inst_21414,inst_21415);
var inst_21417 = cljs.core.ex_info.call(null,inst_21413,inst_21416);
var inst_21418 = (function(){throw inst_21417})();
var state_21460__$1 = state_21460;
var statearr_21477_21529 = state_21460__$1;
(statearr_21477_21529[(2)] = inst_21418);

(statearr_21477_21529[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (3))){
var inst_21458 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21460__$1,inst_21458);
} else {
if((state_val_21461 === (12))){
var inst_21363 = (state_21460[(17)]);
var inst_21451 = (state_21460[(2)]);
var inst_21452 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_21453 = cljs.core.keys.call(null,inst_21363);
var inst_21454 = [inst_21453,vars,inst_21451];
var inst_21455 = cljs.core.PersistentHashMap.fromArrays(inst_21452,inst_21454);
var _ = (function (){var statearr_21478 = state_21460;
(statearr_21478[(4)] = cljs.core.rest.call(null,(state_21460[(4)])));

return statearr_21478;
})();
var state_21460__$1 = state_21460;
var statearr_21479_21530 = state_21460__$1;
(statearr_21479_21530[(2)] = inst_21455);

(statearr_21479_21530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (2))){
var inst_21366 = (state_21460[(7)]);
var inst_21363 = (state_21460[(17)]);
var inst_21367 = (state_21460[(11)]);
var inst_21378 = (state_21460[(15)]);
var _ = (function (){var statearr_21480 = state_21460;
(statearr_21480[(4)] = cljs.core.cons.call(null,(5),(state_21460[(4)])));

return statearr_21480;
})();
var inst_21360 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_21361 = cljs.core.__destructure_map.call(null,inst_21360);
var inst_21362 = cljs.core.get.call(null,inst_21361,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_21363__$1 = cljs.core.get.call(null,inst_21361,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_21364 = cljs.core.get.call(null,inst_21361,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_21365 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_21366__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21364);
var inst_21367__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_21364);
var inst_21369 = (function (){var map__21356 = inst_21361;
var search = inst_21362;
var rel = inst_21363__$1;
var opts = inst_21364;
var common_keys = inst_21365;
var object_fn = inst_21366__$1;
var recur_depth = inst_21367__$1;
return (function (p__21368,common_key){
var vec__21481 = p__21368;
var acc = cljs.core.nth.call(null,vec__21481,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__21481,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__21484 = cljs.core._EQ_;
var expr__21485 = idx_of;
if(cljs.core.truth_(pred__21484.call(null,(0),expr__21485))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__21484.call(null,(1),expr__21485))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__21484.call(null,(2),expr__21485))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__21485)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_21370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21371 = cljs.core.PersistentHashMap.EMPTY;
var inst_21372 = [inst_21371,inst_21362];
var inst_21373 = (new cljs.core.PersistentVector(null,2,(5),inst_21370,inst_21372,null));
var inst_21374 = cljs.core.reduce.call(null,inst_21369,inst_21373,inst_21365);
var inst_21375 = cljs.core.nth.call(null,inst_21374,(0),null);
var inst_21376 = cljs.core.nth.call(null,inst_21374,(1),null);
var inst_21377 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_21378__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21375);
var state_21460__$1 = (function (){var statearr_21487 = state_21460;
(statearr_21487[(13)] = inst_21376);

(statearr_21487[(7)] = inst_21366__$1);

(statearr_21487[(17)] = inst_21363__$1);

(statearr_21487[(11)] = inst_21367__$1);

(statearr_21487[(15)] = inst_21378__$1);

(statearr_21487[(18)] = inst_21377);

return statearr_21487;
})();
if(cljs.core.truth_(inst_21378__$1)){
var statearr_21488_21531 = state_21460__$1;
(statearr_21488_21531[(1)] = (6));

} else {
var statearr_21489_21532 = state_21460__$1;
(statearr_21489_21532[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (23))){
var inst_21394 = (state_21460[(8)]);
var inst_21431 = cljs.core.coll_QMARK_.call(null,inst_21394);
var state_21460__$1 = state_21460;
if(inst_21431){
var statearr_21490_21533 = state_21460__$1;
(statearr_21490_21533[(1)] = (25));

} else {
var statearr_21491_21534 = state_21460__$1;
(statearr_21491_21534[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (19))){
var inst_21392 = (state_21460[(14)]);
var inst_21422 = cljs.core.PersistentHashMap.EMPTY;
var inst_21423 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_21422,inst_21392);
var state_21460__$1 = state_21460;
var statearr_21492_21535 = state_21460__$1;
(statearr_21492_21535[(2)] = inst_21423);

(statearr_21492_21535[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (11))){
var inst_21392 = (state_21460[(14)]);
var state_21460__$1 = state_21460;
var statearr_21494_21536 = state_21460__$1;
(statearr_21494_21536[(2)] = inst_21392);

(statearr_21494_21536[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (9))){
var inst_21363 = (state_21460[(17)]);
var inst_21367 = (state_21460[(11)]);
var inst_21388 = (state_21460[(16)]);
var inst_21387 = (state_21460[(2)]);
var inst_21388__$1 = fluree.db.util.async.throw_err.call(null,inst_21387);
var inst_21389 = cljs.core.count.call(null,inst_21388__$1);
var inst_21390 = fluree.db.query.analytical.add_fuel.call(null,inst_21389,fuel,max_fuel);
var inst_21391 = cljs.core.vals.call(null,inst_21363);
var inst_21392 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_21391,inst_21388__$1);
var state_21460__$1 = (function (){var statearr_21495 = state_21460;
(statearr_21495[(19)] = inst_21390);

(statearr_21495[(14)] = inst_21392);

(statearr_21495[(16)] = inst_21388__$1);

return statearr_21495;
})();
if(cljs.core.truth_(inst_21367)){
var statearr_21496_21537 = state_21460__$1;
(statearr_21496_21537[(1)] = (10));

} else {
var statearr_21497_21538 = state_21460__$1;
(statearr_21497_21538[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (5))){
var _ = (function (){var statearr_21498 = state_21460;
(statearr_21498[(4)] = cljs.core.rest.call(null,(state_21460[(4)])));

return statearr_21498;
})();
var state_21460__$1 = state_21460;
var ex21493 = (state_21460__$1[(2)]);
var statearr_21499_21539 = state_21460__$1;
(statearr_21499_21539[(5)] = ex21493);


if((ex21493 instanceof Error)){
var statearr_21500_21540 = state_21460__$1;
(statearr_21500_21540[(1)] = (4));

(statearr_21500_21540[(5)] = null);

} else {
throw ex21493;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (14))){
var state_21460__$1 = state_21460;
var statearr_21501_21541 = state_21460__$1;
(statearr_21501_21541[(2)] = null);

(statearr_21501_21541[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (26))){
var state_21460__$1 = state_21460;
var statearr_21502_21542 = state_21460__$1;
(statearr_21502_21542[(2)] = null);

(statearr_21502_21542[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (16))){
var state_21460__$1 = state_21460;
var statearr_21503_21543 = state_21460__$1;
(statearr_21503_21543[(2)] = null);

(statearr_21503_21543[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (10))){
var inst_21376 = (state_21460[(13)]);
var inst_21397 = (state_21460[(10)]);
var inst_21394 = cljs.core.first.call(null,inst_21376);
var inst_21395 = cljs.core.first.call(null,clause);
var inst_21396 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21395);
var inst_21397__$1 = cljs.core.nth.call(null,inst_21376,(1));
var inst_21398 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21397__$1);
var state_21460__$1 = (function (){var statearr_21504 = state_21460;
(statearr_21504[(10)] = inst_21397__$1);

(statearr_21504[(8)] = inst_21394);

(statearr_21504[(12)] = inst_21396);

return statearr_21504;
})();
if(cljs.core.truth_(inst_21398)){
var statearr_21505_21544 = state_21460__$1;
(statearr_21505_21544[(1)] = (13));

} else {
var statearr_21506_21545 = state_21460__$1;
(statearr_21506_21545[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (18))){
var inst_21396 = (state_21460[(12)]);
var inst_21420 = (state_21460[(2)]);
var state_21460__$1 = (function (){var statearr_21507 = state_21460;
(statearr_21507[(20)] = inst_21420);

return statearr_21507;
})();
if(cljs.core.truth_(inst_21396)){
var statearr_21508_21546 = state_21460__$1;
(statearr_21508_21546[(1)] = (19));

} else {
var statearr_21509_21547 = state_21460__$1;
(statearr_21509_21547[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (8))){
var inst_21376 = (state_21460[(13)]);
var inst_21377 = (state_21460[(18)]);
var inst_21382 = (state_21460[(2)]);
var inst_21383 = [inst_21382];
var inst_21384 = cljs.core.PersistentHashMap.fromArrays(inst_21377,inst_21383);
var inst_21385 = fluree.db.query.range.search.call(null,db,inst_21376,inst_21384);
var state_21460__$1 = state_21460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21460__$1,(9),inst_21385);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto____0 = (function (){
var statearr_21510 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21510[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto__);

(statearr_21510[(1)] = (1));

return statearr_21510;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto____1 = (function (state_21460){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_21460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e21511){var ex__2706__auto__ = e21511;
var statearr_21512_21548 = state_21460;
(statearr_21512_21548[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_21460[(4)]))){
var statearr_21513_21549 = state_21460;
(statearr_21513_21549[(1)] = cljs.core.first.call(null,(state_21460[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21550 = state_21460;
state_21460 = G__21550;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto__ = function(state_21460){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto____1.call(this,state_21460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_21514 = f__2726__auto__.call(null);
(statearr_21514[(6)] = c__2725__auto__);

return statearr_21514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__21551,res,clause){
var map__21552 = p__21551;
var map__21552__$1 = cljs.core.__destructure_map.call(null,map__21552);
var db = map__21552__$1;
var conn = cljs.core.get.call(null,map__21552__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__21552__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__21552__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_21666){
var state_val_21667 = (state_21666[(1)]);
if((state_val_21667 === (7))){
var inst_21561 = (state_21666[(7)]);
var state_21666__$1 = state_21666;
var statearr_21668_21713 = state_21666__$1;
(statearr_21668_21713[(2)] = inst_21561);

(statearr_21668_21713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (20))){
var inst_21597 = (state_21666[(8)]);
var inst_21561 = (state_21666[(7)]);
var inst_21595 = (state_21666[(9)]);
var inst_21598 = (state_21666[(10)]);
var inst_21563 = (state_21666[(11)]);
var inst_21613 = (state_21666[(2)]);
var inst_21614 = (function (){var subject_var = inst_21561;
var object_var = inst_21563;
var partition = inst_21595;
var max_sid = inst_21597;
var min_sid = inst_21598;
var flakes = inst_21613;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_21615 = cljs.core.map.call(null,inst_21614);
var inst_21616 = cljs.core.distinct.call(null);
var inst_21617 = cljs.core.comp.call(null,inst_21615,inst_21616);
var inst_21618 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21620 = [inst_21561];
var inst_21621 = (new cljs.core.PersistentVector(null,1,(5),inst_21619,inst_21620,null));
var inst_21622 = cljs.core.sequence.call(null,inst_21617,inst_21613);
var inst_21623 = cljs.core.PersistentHashMap.EMPTY;
var inst_21624 = [inst_21621,inst_21622,inst_21623];
var inst_21625 = cljs.core.PersistentHashMap.fromArrays(inst_21618,inst_21624);
var state_21666__$1 = state_21666;
var statearr_21669_21714 = state_21666__$1;
(statearr_21669_21714[(2)] = inst_21625);

(statearr_21669_21714[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (27))){
var inst_21563 = (state_21666[(11)]);
var inst_21639 = (state_21666[(2)]);
var inst_21640 = fluree.db.flake.sid__GT_cid.call(null,inst_21639);
var inst_21641 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_21640);
var inst_21642 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21644 = [inst_21563];
var inst_21645 = (new cljs.core.PersistentVector(null,1,(5),inst_21643,inst_21644,null));
var inst_21646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21648 = [inst_21641];
var inst_21649 = (new cljs.core.PersistentVector(null,1,(5),inst_21647,inst_21648,null));
var inst_21650 = [inst_21649];
var inst_21651 = (new cljs.core.PersistentVector(null,1,(5),inst_21646,inst_21650,null));
var inst_21652 = cljs.core.PersistentHashMap.EMPTY;
var inst_21653 = [inst_21645,inst_21651,inst_21652];
var inst_21654 = cljs.core.PersistentHashMap.fromArrays(inst_21642,inst_21653);
var state_21666__$1 = state_21666;
var statearr_21670_21715 = state_21666__$1;
(statearr_21670_21715[(2)] = inst_21654);

(statearr_21670_21715[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (1))){
var state_21666__$1 = state_21666;
var statearr_21671_21716 = state_21666__$1;
(statearr_21671_21716[(2)] = null);

(statearr_21671_21716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (24))){
var inst_21657 = (state_21666[(2)]);
var state_21666__$1 = state_21666;
var statearr_21672_21717 = state_21666__$1;
(statearr_21672_21717[(2)] = inst_21657);

(statearr_21672_21717[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (4))){
var inst_21554 = (state_21666[(2)]);
var state_21666__$1 = state_21666;
var statearr_21673_21718 = state_21666__$1;
(statearr_21673_21718[(2)] = inst_21554);

(statearr_21673_21718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (15))){
var inst_21561 = (state_21666[(7)]);
var inst_21563 = (state_21666[(11)]);
var inst_21582 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_21583 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21585 = [inst_21561];
var inst_21586 = (new cljs.core.PersistentVector(null,1,(5),inst_21584,inst_21585,null));
var inst_21587 = (function (){var subject_var = inst_21561;
var object_var = inst_21563;
var min_sid = inst_21582;
var max_sid = (0);
return (function (p1__21553_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__21553_SHARP_);
});
})();
var inst_21588 = cljs.core.range.call(null,inst_21582,(0));
var inst_21589 = cljs.core.map.call(null,inst_21587,inst_21588);
var inst_21590 = cljs.core.PersistentHashMap.EMPTY;
var inst_21591 = [inst_21586,inst_21589,inst_21590];
var inst_21592 = cljs.core.PersistentHashMap.fromArrays(inst_21583,inst_21591);
var state_21666__$1 = state_21666;
var statearr_21674_21719 = state_21666__$1;
(statearr_21674_21719[(2)] = inst_21592);

(statearr_21674_21719[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (21))){
var inst_21608 = (state_21666[(2)]);
var inst_21609 = fluree.db.util.async.throw_err.call(null,inst_21608);
var state_21666__$1 = state_21666;
var statearr_21675_21720 = state_21666__$1;
(statearr_21675_21720[(2)] = inst_21609);

(statearr_21675_21720[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (13))){
var inst_21563 = (state_21666[(11)]);
var state_21666__$1 = state_21666;
if(cljs.core.truth_(inst_21563)){
var statearr_21676_21721 = state_21666__$1;
(statearr_21676_21721[(1)] = (22));

} else {
var statearr_21677_21722 = state_21666__$1;
(statearr_21677_21722[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (22))){
var inst_21630 = (state_21666[(12)]);
var inst_21630__$1 = cljs.core.first.call(null,clause);
var inst_21631 = typeof inst_21630__$1 === 'number';
var state_21666__$1 = (function (){var statearr_21678 = state_21666;
(statearr_21678[(12)] = inst_21630__$1);

return statearr_21678;
})();
if(cljs.core.truth_(inst_21631)){
var statearr_21679_21723 = state_21666__$1;
(statearr_21679_21723[(1)] = (25));

} else {
var statearr_21680_21724 = state_21666__$1;
(statearr_21680_21724[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (6))){
var inst_21563 = (state_21666[(11)]);
var state_21666__$1 = state_21666;
var statearr_21681_21725 = state_21666__$1;
(statearr_21681_21725[(2)] = inst_21563);

(statearr_21681_21725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (28))){
var inst_21636 = (state_21666[(2)]);
var inst_21637 = fluree.db.util.async.throw_err.call(null,inst_21636);
var state_21666__$1 = state_21666;
var statearr_21682_21726 = state_21666__$1;
(statearr_21682_21726[(2)] = inst_21637);

(statearr_21682_21726[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (25))){
var inst_21630 = (state_21666[(12)]);
var state_21666__$1 = state_21666;
var statearr_21683_21727 = state_21666__$1;
(statearr_21683_21727[(2)] = inst_21630);

(statearr_21683_21727[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (17))){
var inst_21627 = (state_21666[(2)]);
var state_21666__$1 = state_21666;
var statearr_21684_21728 = state_21666__$1;
(statearr_21684_21728[(2)] = inst_21627);

(statearr_21684_21728[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (3))){
var inst_21664 = (state_21666[(2)]);
var state_21666__$1 = state_21666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21666__$1,inst_21664);
} else {
if((state_val_21667 === (12))){
var inst_21576 = ["_tx",null,"_block",null];
var inst_21577 = (new cljs.core.PersistentArrayMap(null,2,inst_21576,null));
var inst_21578 = (new cljs.core.PersistentHashSet(null,inst_21577,null));
var inst_21579 = cljs.core.last.call(null,clause);
var inst_21580 = inst_21578.call(null,inst_21579);
var state_21666__$1 = state_21666;
if(cljs.core.truth_(inst_21580)){
var statearr_21685_21729 = state_21666__$1;
(statearr_21685_21729[(1)] = (15));

} else {
var statearr_21686_21730 = state_21666__$1;
(statearr_21686_21730[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (2))){
var inst_21561 = (state_21666[(7)]);
var _ = (function (){var statearr_21687 = state_21666;
(statearr_21687[(4)] = cljs.core.cons.call(null,(5),(state_21666[(4)])));

return statearr_21687;
})();
var inst_21560 = cljs.core.first.call(null,clause);
var inst_21561__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21560);
var inst_21562 = cljs.core.last.call(null,clause);
var inst_21563 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21562);
var state_21666__$1 = (function (){var statearr_21688 = state_21666;
(statearr_21688[(7)] = inst_21561__$1);

(statearr_21688[(11)] = inst_21563);

return statearr_21688;
})();
if(cljs.core.truth_(inst_21561__$1)){
var statearr_21689_21731 = state_21666__$1;
(statearr_21689_21731[(1)] = (6));

} else {
var statearr_21690_21732 = state_21666__$1;
(statearr_21690_21732[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (23))){
var state_21666__$1 = state_21666;
var statearr_21691_21733 = state_21666__$1;
(statearr_21691_21733[(2)] = null);

(statearr_21691_21733[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (19))){
var inst_21611 = cljs.core.PersistentVector.EMPTY;
var state_21666__$1 = state_21666;
var statearr_21692_21734 = state_21666__$1;
(statearr_21692_21734[(2)] = inst_21611);

(statearr_21692_21734[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (11))){
var inst_21661 = (state_21666[(2)]);
var _ = (function (){var statearr_21694 = state_21666;
(statearr_21694[(4)] = cljs.core.rest.call(null,(state_21666[(4)])));

return statearr_21694;
})();
var state_21666__$1 = state_21666;
var statearr_21695_21735 = state_21666__$1;
(statearr_21695_21735[(2)] = inst_21661);

(statearr_21695_21735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (9))){
var inst_21569 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21570 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21571 = cljs.core.PersistentHashMap.fromArrays(inst_21569,inst_21570);
var inst_21572 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_21571);
var inst_21573 = (function(){throw inst_21572})();
var state_21666__$1 = state_21666;
var statearr_21696_21736 = state_21666__$1;
(statearr_21696_21736[(2)] = inst_21573);

(statearr_21696_21736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (5))){
var _ = (function (){var statearr_21697 = state_21666;
(statearr_21697[(4)] = cljs.core.rest.call(null,(state_21666[(4)])));

return statearr_21697;
})();
var state_21666__$1 = state_21666;
var ex21693 = (state_21666__$1[(2)]);
var statearr_21698_21737 = state_21666__$1;
(statearr_21698_21737[(5)] = ex21693);


if((ex21693 instanceof Error)){
var statearr_21699_21738 = state_21666__$1;
(statearr_21699_21738[(1)] = (4));

(statearr_21699_21738[(5)] = null);

} else {
throw ex21693;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (14))){
var inst_21659 = (state_21666[(2)]);
var state_21666__$1 = state_21666;
var statearr_21700_21739 = state_21666__$1;
(statearr_21700_21739[(2)] = inst_21659);

(statearr_21700_21739[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (26))){
var inst_21630 = (state_21666[(12)]);
var inst_21634 = fluree.db.dbproto._subid.call(null,db,inst_21630);
var state_21666__$1 = state_21666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21666__$1,(28),inst_21634);
} else {
if((state_val_21667 === (16))){
var inst_21597 = (state_21666[(8)]);
var inst_21595 = (state_21666[(9)]);
var inst_21594 = cljs.core.last.call(null,clause);
var inst_21595__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_21594);
var inst_21596 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_21597__$1 = cljs.core.get.call(null,inst_21596,inst_21595__$1);
var inst_21598 = fluree.db.flake.min_subject_id.call(null,inst_21595__$1);
var state_21666__$1 = (function (){var statearr_21701 = state_21666;
(statearr_21701[(8)] = inst_21597__$1);

(statearr_21701[(9)] = inst_21595__$1);

(statearr_21701[(10)] = inst_21598);

return statearr_21701;
})();
if(cljs.core.truth_(inst_21597__$1)){
var statearr_21702_21740 = state_21666__$1;
(statearr_21702_21740[(1)] = (18));

} else {
var statearr_21703_21741 = state_21666__$1;
(statearr_21703_21741[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (10))){
var inst_21561 = (state_21666[(7)]);
var state_21666__$1 = state_21666;
if(cljs.core.truth_(inst_21561)){
var statearr_21704_21742 = state_21666__$1;
(statearr_21704_21742[(1)] = (12));

} else {
var statearr_21705_21743 = state_21666__$1;
(statearr_21705_21743[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21667 === (18))){
var inst_21597 = (state_21666[(8)]);
var inst_21598 = (state_21666[(10)]);
var inst_21600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21601 = [inst_21597];
var inst_21602 = (new cljs.core.PersistentVector(null,1,(5),inst_21600,inst_21601,null));
var inst_21603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21604 = [inst_21598];
var inst_21605 = (new cljs.core.PersistentVector(null,1,(5),inst_21603,inst_21604,null));
var inst_21606 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_21602,cljs.core._LT__EQ_,inst_21605);
var state_21666__$1 = state_21666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21666__$1,(21),inst_21606);
} else {
if((state_val_21667 === (8))){
var inst_21567 = (state_21666[(2)]);
var state_21666__$1 = state_21666;
if(cljs.core.truth_(inst_21567)){
var statearr_21706_21744 = state_21666__$1;
(statearr_21706_21744[(1)] = (9));

} else {
var statearr_21707_21745 = state_21666__$1;
(statearr_21707_21745[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto____0 = (function (){
var statearr_21708 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21708[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto__);

(statearr_21708[(1)] = (1));

return statearr_21708;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto____1 = (function (state_21666){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_21666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e21709){var ex__2706__auto__ = e21709;
var statearr_21710_21746 = state_21666;
(statearr_21710_21746[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_21666[(4)]))){
var statearr_21711_21747 = state_21666;
(statearr_21711_21747[(1)] = cljs.core.first.call(null,(state_21666[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21748 = state_21666;
state_21666 = G__21748;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto__ = function(state_21666){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto____1.call(this,state_21666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_21712 = f__2726__auto__.call(null);
(statearr_21712[(6)] = c__2725__auto__);

return statearr_21712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__21754 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__21754 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__21754;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__21755(s__21756){
return (new cljs.core.LazySeq(null,(function (){
var s__21756__$1 = s__21756;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__21756__$1);
if(temp__5804__auto__){
var s__21756__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21756__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__21756__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__21758 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__21757 = (0);
while(true){
if((i__21757 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__21757);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__21758,(delta * delta));

var G__21759 = (i__21757 + (1));
i__21757 = G__21759;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21758),fluree$db$query$analytical$variance_$_iter__21755.call(null,cljs.core.chunk_rest.call(null,s__21756__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21758),null);
}
} else {
var x = cljs.core.first.call(null,s__21756__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__21755.call(null,cljs.core.rest.call(null,s__21756__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21760 = null;
var G__21760__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21760__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21760 = function(n,coll){
switch(arguments.length){
case 1:
return G__21760__1.call(this,n);
case 2:
return G__21760__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21760.cljs$core$IFn$_invoke$arity$1 = G__21760__1;
G__21760.cljs$core$IFn$_invoke$arity$2 = G__21760__2;
return G__21760;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21761 = null;
var G__21761__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21761__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21761 = function(n,coll){
switch(arguments.length){
case 1:
return G__21761__1.call(this,n);
case 2:
return G__21761__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21761.cljs$core$IFn$_invoke$arity$1 = G__21761__1;
G__21761.cljs$core$IFn$_invoke$arity$2 = G__21761__2;
return G__21761;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21762 = null;
var G__21762__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__21762__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__21762 = function(n,coll){
switch(arguments.length){
case 1:
return G__21762__1.call(this,n);
case 2:
return G__21762__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21762.cljs$core$IFn$_invoke$arity$1 = G__21762__1;
G__21762.cljs$core$IFn$_invoke$arity$2 = G__21762__2;
return G__21762;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__21763 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__21763,(0),null);
var arg = cljs.core.nth.call(null,vec__21763,(1),null);
var var$ = cljs.core.nth.call(null,vec__21763,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21766 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__21766,(0),null);
var variable = cljs.core.nth.call(null,vec__21766,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21769 = agg;
var map__21769__$1 = cljs.core.__destructure_map.call(null,map__21769);
var variable = cljs.core.get.call(null,map__21769__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__21769__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__21769__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__21771 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__21771,(0),null);
var agg_result = cljs.core.nth.call(null,vec__21771,(1),null);
var map__21774 = res__$1;
var map__21774__$1 = cljs.core.__destructure_map.call(null,map__21774);
var headers = cljs.core.get.call(null,map__21774__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__21774__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21770_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__21770_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__21775_SHARP_){
return cljs.core.nth.call(null,tuple,p1__21775_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__21776_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21776_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__21777_SHARP_,p2__21778_SHARP_){
return cljs.core.conj.call(null,p1__21777_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__21778_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__21779_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21779_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__21782,row,b_tuple){
var vec__21783 = p__21782;
var acc = cljs.core.nth.call(null,vec__21783,(0),null);
var b_rows = cljs.core.nth.call(null,vec__21783,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__21780_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21780_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__21781_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21781_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__21786_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21786_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21787_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21787_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21789_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21789_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21788_SHARP_){
return cljs.core.range.call(null,(0),p1__21788_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__21790_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21790_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__21791_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21791_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21792_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21792_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21794_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21794_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21793_SHARP_){
return cljs.core.range.call(null,(0),p1__21793_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__21795_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21795_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__21797 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__21797,(0),null);
var _ = cljs.core.nth.call(null,vec__21797,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__21796_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__21796_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__21802 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__21802,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__21802,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__21800_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__21800_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__21801_SHARP_){
return cljs.core.nth.call(null,clause,p1__21801_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21805,filters,optional_QMARK_){
var map__21806 = p__21805;
var map__21806__$1 = cljs.core.__destructure_map.call(null,map__21806);
var tuple_map = map__21806__$1;
var headers = cljs.core.get.call(null,map__21806__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21806__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__21806__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21807 = clause;
var k = cljs.core.nth.call(null,vec__21807,(0),null);
var v = cljs.core.nth.call(null,vec__21807,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21810 = res;
var map__21810__$1 = cljs.core.__destructure_map.call(null,map__21810);
var headers = cljs.core.get.call(null,map__21810__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21810__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_21866){
var state_val_21867 = (state_21866[(1)]);
if((state_val_21867 === (7))){
var inst_21840 = (state_21866[(7)]);
var inst_21838 = (state_21866[(2)]);
var inst_21839 = fluree.db.util.async.throw_err.call(null,inst_21838);
var inst_21840__$1 = cljs.core.nth.call(null,inst_21839,(0),null);
var inst_21841 = cljs.core.nth.call(null,inst_21839,(1),null);
var inst_21842 = (inst_21840__$1 == null);
var state_21866__$1 = (function (){var statearr_21868 = state_21866;
(statearr_21868[(7)] = inst_21840__$1);

(statearr_21868[(8)] = inst_21841);

return statearr_21868;
})();
if(cljs.core.truth_(inst_21842)){
var statearr_21869_21898 = state_21866__$1;
(statearr_21869_21898[(1)] = (8));

} else {
var statearr_21870_21899 = state_21866__$1;
(statearr_21870_21899[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (1))){
var inst_21818 = optional_clauses;
var inst_21819 = cljs.core.seq.call(null,inst_21818);
var inst_21820 = cljs.core.first.call(null,inst_21819);
var inst_21821 = cljs.core.next.call(null,inst_21819);
var inst_21822 = where_tuples;
var inst_21823 = inst_21818;
var inst_21824 = inst_21822;
var state_21866__$1 = (function (){var statearr_21871 = state_21866;
(statearr_21871[(9)] = inst_21820);

(statearr_21871[(10)] = inst_21824);

(statearr_21871[(11)] = inst_21821);

(statearr_21871[(12)] = inst_21823);

return statearr_21871;
})();
var statearr_21872_21900 = state_21866__$1;
(statearr_21872_21900[(2)] = null);

(statearr_21872_21900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (4))){
var inst_21830 = (state_21866[(13)]);
var inst_21831 = (state_21866[(14)]);
var inst_21824 = (state_21866[(10)]);
var inst_21836 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21824,inst_21830,inst_21831,true,fuel,max_fuel,opts);
var state_21866__$1 = state_21866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21866__$1,(7),inst_21836);
} else {
if((state_val_21867 === (15))){
var state_21866__$1 = state_21866;
var statearr_21873_21901 = state_21866__$1;
(statearr_21873_21901[(2)] = null);

(statearr_21873_21901[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (13))){
var inst_21857 = (state_21866[(2)]);
var state_21866__$1 = state_21866;
var statearr_21874_21902 = state_21866__$1;
(statearr_21874_21902[(2)] = inst_21857);

(statearr_21874_21902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (6))){
var inst_21862 = (state_21866[(2)]);
var state_21866__$1 = state_21866;
var statearr_21875_21903 = state_21866__$1;
(statearr_21875_21903[(2)] = inst_21862);

(statearr_21875_21903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (3))){
var inst_21864 = (state_21866[(2)]);
var state_21866__$1 = state_21866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21866__$1,inst_21864);
} else {
if((state_val_21867 === (12))){
var state_21866__$1 = state_21866;
var statearr_21876_21904 = state_21866__$1;
(statearr_21876_21904[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (2))){
var inst_21830 = (state_21866[(13)]);
var inst_21823 = (state_21866[(12)]);
var inst_21829 = cljs.core.seq.call(null,inst_21823);
var inst_21830__$1 = cljs.core.first.call(null,inst_21829);
var inst_21831 = cljs.core.next.call(null,inst_21829);
var state_21866__$1 = (function (){var statearr_21878 = state_21866;
(statearr_21878[(13)] = inst_21830__$1);

(statearr_21878[(14)] = inst_21831);

return statearr_21878;
})();
if(cljs.core.truth_(inst_21830__$1)){
var statearr_21879_21905 = state_21866__$1;
(statearr_21879_21905[(1)] = (4));

} else {
var statearr_21880_21906 = state_21866__$1;
(statearr_21880_21906[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (11))){
var inst_21840 = (state_21866[(7)]);
var inst_21841 = (state_21866[(8)]);
var inst_21823 = inst_21841;
var inst_21824 = inst_21840;
var state_21866__$1 = (function (){var statearr_21881 = state_21866;
(statearr_21881[(10)] = inst_21824);

(statearr_21881[(12)] = inst_21823);

return statearr_21881;
})();
var statearr_21882_21907 = state_21866__$1;
(statearr_21882_21907[(2)] = null);

(statearr_21882_21907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (9))){
var inst_21830 = (state_21866[(13)]);
var inst_21846 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21830);
var state_21866__$1 = state_21866;
if(cljs.core.truth_(inst_21846)){
var statearr_21883_21908 = state_21866__$1;
(statearr_21883_21908[(1)] = (11));

} else {
var statearr_21884_21909 = state_21866__$1;
(statearr_21884_21909[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (5))){
var inst_21824 = (state_21866[(10)]);
var state_21866__$1 = state_21866;
var statearr_21885_21910 = state_21866__$1;
(statearr_21885_21910[(2)] = inst_21824);

(statearr_21885_21910[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (14))){
var inst_21840 = (state_21866[(7)]);
var inst_21824 = (state_21866[(10)]);
var inst_21841 = (state_21866[(8)]);
var inst_21851 = fluree.db.query.analytical.left_outer_join.call(null,inst_21824,inst_21840);
var inst_21823 = inst_21841;
var inst_21824__$1 = inst_21851;
var state_21866__$1 = (function (){var statearr_21886 = state_21866;
(statearr_21886[(10)] = inst_21824__$1);

(statearr_21886[(12)] = inst_21823);

return statearr_21886;
})();
var statearr_21887_21911 = state_21866__$1;
(statearr_21887_21911[(2)] = null);

(statearr_21887_21911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (16))){
var inst_21855 = (state_21866[(2)]);
var state_21866__$1 = state_21866;
var statearr_21889_21912 = state_21866__$1;
(statearr_21889_21912[(2)] = inst_21855);

(statearr_21889_21912[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (10))){
var inst_21859 = (state_21866[(2)]);
var state_21866__$1 = state_21866;
var statearr_21890_21913 = state_21866__$1;
(statearr_21890_21913[(2)] = inst_21859);

(statearr_21890_21913[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21867 === (8))){
var inst_21824 = (state_21866[(10)]);
var inst_21841 = (state_21866[(8)]);
var tmp21888 = inst_21824;
var inst_21823 = inst_21841;
var inst_21824__$1 = tmp21888;
var state_21866__$1 = (function (){var statearr_21891 = state_21866;
(statearr_21891[(10)] = inst_21824__$1);

(statearr_21891[(12)] = inst_21823);

return statearr_21891;
})();
var statearr_21892_21914 = state_21866__$1;
(statearr_21892_21914[(2)] = null);

(statearr_21892_21914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto____0 = (function (){
var statearr_21893 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21893[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto__);

(statearr_21893[(1)] = (1));

return statearr_21893;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto____1 = (function (state_21866){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_21866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e21894){var ex__2706__auto__ = e21894;
var statearr_21895_21915 = state_21866;
(statearr_21895_21915[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_21866[(4)]))){
var statearr_21896_21916 = state_21866;
(statearr_21896_21916[(1)] = cljs.core.first.call(null,(state_21866[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21917 = state_21866;
state_21866 = G__21917;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto__ = function(state_21866){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto____1.call(this,state_21866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_21897 = f__2726__auto__.call(null);
(statearr_21897[(6)] = c__2725__auto__);

return statearr_21897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__21919){
var vec__21920 = p__21919;
var var_name = cljs.core.nth.call(null,vec__21920,(0),null);
var var_val = cljs.core.nth.call(null,vec__21920,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21918_SHARP_){
return cljs.core.conj.call(null,p1__21918_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21924,p__21925,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21926 = p__21924;
var map__21926__$1 = cljs.core.__destructure_map.call(null,map__21926);
var q_map = map__21926__$1;
var prefixes = cljs.core.get.call(null,map__21926__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21927 = p__21925;
var map__21927__$1 = cljs.core.__destructure_map.call(null,map__21927);
var res = map__21927__$1;
var vars = cljs.core.get.call(null,map__21927__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_22164){
var state_val_22165 = (state_22164[(1)]);
if((state_val_22165 === (65))){
var inst_22113 = (state_22164[(7)]);
var inst_22114 = (state_22164[(8)]);
var inst_22125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22126 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_22113,res,inst_22114);
var inst_22127 = [inst_22126,r];
var inst_22128 = (new cljs.core.PersistentVector(null,2,(5),inst_22125,inst_22127,null));
var state_22164__$1 = state_22164;
var statearr_22166_22271 = state_22164__$1;
(statearr_22166_22271[(2)] = inst_22128);

(statearr_22166_22271[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (70))){
var inst_22140 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22167_22272 = state_22164__$1;
(statearr_22167_22272[(2)] = inst_22140);

(statearr_22167_22272[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (62))){
var inst_22114 = (state_22164[(8)]);
var inst_22122 = cljs.core.second.call(null,inst_22114);
var inst_22123 = clojure.string.starts_with_QMARK_.call(null,inst_22122,"fullText:");
var state_22164__$1 = state_22164;
if(inst_22123){
var statearr_22168_22273 = state_22164__$1;
(statearr_22168_22273[(1)] = (65));

} else {
var statearr_22169_22274 = state_22164__$1;
(statearr_22169_22274[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (7))){
var inst_22033 = (state_22164[(9)]);
var inst_22032 = cljs.core.count.call(null,clause);
var inst_22033__$1 = cljs.core._EQ_.call(null,(3),inst_22032);
var state_22164__$1 = (function (){var statearr_22170 = state_22164;
(statearr_22170[(9)] = inst_22033__$1);

return statearr_22170;
})();
if(inst_22033__$1){
var statearr_22171_22275 = state_22164__$1;
(statearr_22171_22275[(1)] = (31));

} else {
var statearr_22172_22276 = state_22164__$1;
(statearr_22172_22276[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (59))){
var inst_22147 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22173_22277 = state_22164__$1;
(statearr_22173_22277[(2)] = inst_22147);

(statearr_22173_22277[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (20))){
var inst_21996 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22174_22278 = state_22164__$1;
(statearr_22174_22278[(2)] = inst_21996);

(statearr_22174_22278[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (58))){
var state_22164__$1 = state_22164;
var statearr_22175_22279 = state_22164__$1;
(statearr_22175_22279[(2)] = null);

(statearr_22175_22279[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (60))){
var inst_22113 = (state_22164[(7)]);
var inst_22111 = (state_22164[(2)]);
var inst_22112 = fluree.db.util.async.throw_err.call(null,inst_22111);
var inst_22113__$1 = cljs.core.nth.call(null,inst_22112,(0),null);
var inst_22114 = cljs.core.nth.call(null,inst_22112,(1),null);
var inst_22115 = cljs.core._EQ_.call(null,"$wd",inst_22113__$1);
var state_22164__$1 = (function (){var statearr_22176 = state_22164;
(statearr_22176[(7)] = inst_22113__$1);

(statearr_22176[(8)] = inst_22114);

return statearr_22176;
})();
if(inst_22115){
var statearr_22177_22280 = state_22164__$1;
(statearr_22177_22280[(1)] = (61));

} else {
var statearr_22178_22281 = state_22164__$1;
(statearr_22178_22281[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (27))){
var inst_22026 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22179_22282 = state_22164__$1;
(statearr_22179_22282[(2)] = inst_22026);

(statearr_22179_22282[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (1))){
var state_22164__$1 = state_22164;
var statearr_22180_22283 = state_22164__$1;
(statearr_22180_22283[(2)] = null);

(statearr_22180_22283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (69))){
var state_22164__$1 = state_22164;
var statearr_22181_22284 = state_22164__$1;
(statearr_22181_22284[(2)] = null);

(statearr_22181_22284[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (24))){
var inst_21990 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22182_22285 = state_22164__$1;
(statearr_22182_22285[(2)] = inst_21990);

(statearr_22182_22285[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (55))){
var inst_22096 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22097 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22098 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22099 = cljs.core.PersistentHashMap.fromArrays(inst_22097,inst_22098);
var inst_22100 = cljs.core.ex_info.call(null,inst_22096,inst_22099);
var inst_22101 = (function(){throw inst_22100})();
var state_22164__$1 = state_22164;
var statearr_22183_22286 = state_22164__$1;
(statearr_22183_22286[(2)] = inst_22101);

(statearr_22183_22286[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (39))){
var inst_22053 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
if(cljs.core.truth_(inst_22053)){
var statearr_22184_22287 = state_22164__$1;
(statearr_22184_22287[(1)] = (40));

} else {
var statearr_22185_22288 = state_22164__$1;
(statearr_22185_22288[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (46))){
var inst_22153 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22186_22289 = state_22164__$1;
(statearr_22186_22289[(2)] = inst_22153);

(statearr_22186_22289[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (4))){
var inst_21928 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22187_22290 = state_22164__$1;
(statearr_22187_22290[(2)] = inst_21928);

(statearr_22187_22290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (54))){
var inst_22089 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22090 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22091 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22092 = cljs.core.PersistentHashMap.fromArrays(inst_22090,inst_22091);
var inst_22093 = cljs.core.ex_info.call(null,inst_22089,inst_22092);
var inst_22094 = (function(){throw inst_22093})();
var state_22164__$1 = state_22164;
var statearr_22188_22291 = state_22164__$1;
(statearr_22188_22291[(2)] = inst_22094);

(statearr_22188_22291[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (15))){
var inst_22028 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22189_22292 = state_22164__$1;
(statearr_22189_22292[(2)] = inst_22028);

(statearr_22189_22292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (48))){
var inst_22077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22078 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_22079 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22078);
var inst_22080 = [inst_22079,r];
var inst_22081 = (new cljs.core.PersistentVector(null,2,(5),inst_22077,inst_22080,null));
var state_22164__$1 = state_22164;
var statearr_22190_22293 = state_22164__$1;
(statearr_22190_22293[(2)] = inst_22081);

(statearr_22190_22293[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (50))){
var inst_22151 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22191_22294 = state_22164__$1;
(statearr_22191_22294[(2)] = inst_22151);

(statearr_22191_22294[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (21))){
var inst_21962 = (state_22164[(10)]);
var inst_21941 = (state_22164[(11)]);
var inst_21964 = (state_22164[(12)]);
var inst_21973 = (state_22164[(13)]);
var inst_21965 = (state_22164[(14)]);
var inst_21974 = (state_22164[(15)]);
var inst_21967 = (state_22164[(16)]);
var inst_21937 = (state_22164[(17)]);
var inst_21966 = (state_22164[(18)]);
var inst_21978 = (state_22164[(2)]);
var inst_21979 = fluree.db.util.async.throw_err.call(null,inst_21978);
var inst_21980 = (function (){var seq__21970 = inst_21974;
var new_res = inst_21979;
var rest = inst_21974;
var tuples = inst_21967;
var pred__21938 = inst_21941;
var seq__21960 = inst_21965;
var G__21958 = inst_21966;
var first__21971 = inst_21973;
var segment_type = inst_21937;
var vec__21969 = inst_21966;
var first__21961 = inst_21964;
var vec__21959 = inst_21962;
var expr__21939 = inst_21937;
var clause_group = inst_21973;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21981 = cljs.core.keys.call(null,vars);
var inst_21982 = cljs.core.reduce.call(null,inst_21980,inst_21979,inst_21981);
var inst_21983 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_21982);
var state_22164__$1 = (function (){var statearr_22192 = state_22164;
(statearr_22192[(19)] = inst_21983);

return statearr_22192;
})();
if(cljs.core.truth_(inst_21967)){
var statearr_22193_22295 = state_22164__$1;
(statearr_22193_22295[(1)] = (22));

} else {
var statearr_22194_22296 = state_22164__$1;
(statearr_22194_22296[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (31))){
var inst_22035 = cljs.core.second.call(null,clause);
var inst_22036 = clojure.string.starts_with_QMARK_.call(null,inst_22035,"fullText:");
var state_22164__$1 = state_22164;
var statearr_22195_22297 = state_22164__$1;
(statearr_22195_22297[(2)] = inst_22036);

(statearr_22195_22297[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (32))){
var inst_22033 = (state_22164[(9)]);
var state_22164__$1 = state_22164;
var statearr_22196_22298 = state_22164__$1;
(statearr_22196_22298[(2)] = inst_22033);

(statearr_22196_22298[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (40))){
var inst_22055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22056 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_22164__$1 = (function (){var statearr_22197 = state_22164;
(statearr_22197[(20)] = inst_22055);

return statearr_22197;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(43),inst_22056);
} else {
if((state_val_22165 === (56))){
var inst_22103 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22198_22299 = state_22164__$1;
(statearr_22198_22299[(2)] = inst_22103);

(statearr_22198_22299[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (33))){
var inst_22039 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
if(cljs.core.truth_(inst_22039)){
var statearr_22199_22300 = state_22164__$1;
(statearr_22199_22300[(1)] = (34));

} else {
var statearr_22200_22301 = state_22164__$1;
(statearr_22200_22301[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (13))){
var inst_21962 = (state_22164[(10)]);
var inst_21962__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21963 = cljs.core.seq.call(null,inst_21962__$1);
var inst_21964 = cljs.core.first.call(null,inst_21963);
var inst_21965 = cljs.core.next.call(null,inst_21963);
var inst_21966 = inst_21962__$1;
var inst_21967 = null;
var state_22164__$1 = (function (){var statearr_22201 = state_22164;
(statearr_22201[(10)] = inst_21962__$1);

(statearr_22201[(12)] = inst_21964);

(statearr_22201[(14)] = inst_21965);

(statearr_22201[(16)] = inst_21967);

(statearr_22201[(18)] = inst_21966);

return statearr_22201;
})();
var statearr_22202_22302 = state_22164__$1;
(statearr_22202_22302[(2)] = null);

(statearr_22202_22302[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (22))){
var inst_21983 = (state_22164[(19)]);
var inst_21974 = (state_22164[(15)]);
var inst_21967 = (state_22164[(16)]);
var inst_21985 = fluree.db.query.union.results.call(null,inst_21967,inst_21983);
var inst_21966 = inst_21974;
var inst_21967__$1 = inst_21985;
var state_22164__$1 = (function (){var statearr_22203 = state_22164;
(statearr_22203[(16)] = inst_21967__$1);

(statearr_22203[(18)] = inst_21966);

return statearr_22203;
})();
var statearr_22204_22303 = state_22164__$1;
(statearr_22204_22303[(2)] = null);

(statearr_22204_22303[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (36))){
var inst_22157 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22205_22304 = state_22164__$1;
(statearr_22205_22304[(2)] = inst_22157);

(statearr_22205_22304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (41))){
var inst_22063 = cljs.core.count.call(null,clause);
var inst_22064 = cljs.core._EQ_.call(null,(3),inst_22063);
var state_22164__$1 = state_22164;
if(inst_22064){
var statearr_22206_22305 = state_22164__$1;
(statearr_22206_22305[(1)] = (44));

} else {
var statearr_22207_22306 = state_22164__$1;
(statearr_22207_22306[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (43))){
var inst_22055 = (state_22164[(20)]);
var inst_22058 = (state_22164[(2)]);
var inst_22059 = fluree.db.util.async.throw_err.call(null,inst_22058);
var inst_22060 = [inst_22059,r];
var inst_22061 = (new cljs.core.PersistentVector(null,2,(5),inst_22055,inst_22060,null));
var state_22164__$1 = state_22164;
var statearr_22208_22307 = state_22164__$1;
(statearr_22208_22307[(2)] = inst_22061);

(statearr_22208_22307[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (61))){
var inst_22114 = (state_22164[(8)]);
var inst_22117 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_22114,r,res,optional_QMARK_,fuel,max_fuel);
var state_22164__$1 = state_22164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(64),inst_22117);
} else {
if((state_val_22165 === (29))){
var inst_21937 = (state_22164[(17)]);
var inst_22020 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21937)].join('');
var inst_22021 = (new Error(inst_22020));
var inst_22022 = (function(){throw inst_22021})();
var state_22164__$1 = state_22164;
var statearr_22209_22308 = state_22164__$1;
(statearr_22209_22308[(2)] = inst_22022);

(statearr_22209_22308[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (44))){
var inst_22066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22067 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_22164__$1 = (function (){var statearr_22210 = state_22164;
(statearr_22210[(21)] = inst_22066);

return statearr_22210;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(47),inst_22067);
} else {
if((state_val_22165 === (6))){
var inst_21941 = (state_22164[(11)]);
var inst_21937 = (state_22164[(17)]);
var inst_21936 = cljs.core.keys.call(null,clause);
var inst_21937__$1 = cljs.core.first.call(null,inst_21936);
var inst_21941__$1 = cljs.core._EQ_;
var inst_21942 = inst_21941__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_21937__$1);
var state_22164__$1 = (function (){var statearr_22211 = state_22164;
(statearr_22211[(11)] = inst_21941__$1);

(statearr_22211[(17)] = inst_21937__$1);

return statearr_22211;
})();
if(cljs.core.truth_(inst_21942)){
var statearr_22212_22309 = state_22164__$1;
(statearr_22212_22309[(1)] = (9));

} else {
var statearr_22213_22310 = state_22164__$1;
(statearr_22213_22310[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (28))){
var inst_22014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22015 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22016 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_22015,optional_QMARK_);
var inst_22017 = [inst_22016,r];
var inst_22018 = (new cljs.core.PersistentVector(null,2,(5),inst_22014,inst_22017,null));
var state_22164__$1 = state_22164;
var statearr_22214_22311 = state_22164__$1;
(statearr_22214_22311[(2)] = inst_22018);

(statearr_22214_22311[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (64))){
var inst_22119 = (state_22164[(2)]);
var inst_22120 = fluree.db.util.async.throw_err.call(null,inst_22119);
var state_22164__$1 = state_22164;
var statearr_22215_22312 = state_22164__$1;
(statearr_22215_22312[(2)] = inst_22120);

(statearr_22215_22312[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (51))){
var inst_22086 = cljs.core.first.call(null,clause);
var inst_22087 = cljs.core.sequential_QMARK_.call(null,inst_22086);
var state_22164__$1 = state_22164;
if(inst_22087){
var statearr_22216_22313 = state_22164__$1;
(statearr_22216_22313[(1)] = (54));

} else {
var statearr_22217_22314 = state_22164__$1;
(statearr_22217_22314[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (25))){
var inst_21941 = (state_22164[(11)]);
var inst_21937 = (state_22164[(17)]);
var inst_22002 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22003 = (function (){var segment_type = inst_21937;
var pred__21938 = inst_21941;
var expr__21939 = inst_21937;
var bindings = inst_22002;
return (function (p1__21923_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__21923_SHARP_);
});
})();
var inst_22004 = cljs.core.map.call(null,inst_22003,inst_22002);
var inst_22005 = cljs.core.PersistentHashMap.EMPTY;
var inst_22006 = cljs.core.into.call(null,inst_22005,inst_22004);
var inst_22007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22008 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22006);
var inst_22009 = [inst_22008,r];
var inst_22010 = (new cljs.core.PersistentVector(null,2,(5),inst_22007,inst_22009,null));
var state_22164__$1 = state_22164;
var statearr_22218_22315 = state_22164__$1;
(statearr_22218_22315[(2)] = inst_22010);

(statearr_22218_22315[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (34))){
var inst_22041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22042 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_22043 = [inst_22042,r];
var inst_22044 = (new cljs.core.PersistentVector(null,2,(5),inst_22041,inst_22043,null));
var state_22164__$1 = state_22164;
var statearr_22219_22316 = state_22164__$1;
(statearr_22219_22316[(2)] = inst_22044);

(statearr_22219_22316[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (17))){
var inst_21998 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22220_22317 = state_22164__$1;
(statearr_22220_22317[(2)] = inst_21998);

(statearr_22220_22317[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (3))){
var inst_22162 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22164__$1,inst_22162);
} else {
if((state_val_22165 === (12))){
var inst_21944 = (state_22164[(22)]);
var inst_21948 = (state_22164[(2)]);
var inst_21949 = fluree.db.util.async.throw_err.call(null,inst_21948);
var inst_21950 = [inst_21949,r];
var inst_21951 = (new cljs.core.PersistentVector(null,2,(5),inst_21944,inst_21950,null));
var state_22164__$1 = state_22164;
var statearr_22221_22318 = state_22164__$1;
(statearr_22221_22318[(2)] = inst_21951);

(statearr_22221_22318[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (2))){
var _ = (function (){var statearr_22222 = state_22164;
(statearr_22222[(4)] = cljs.core.cons.call(null,(5),(state_22164[(4)])));

return statearr_22222;
})();
var inst_21934 = cljs.core.map_QMARK_.call(null,clause);
var state_22164__$1 = state_22164;
if(inst_21934){
var statearr_22223_22319 = state_22164__$1;
(statearr_22223_22319[(1)] = (6));

} else {
var statearr_22224_22320 = state_22164__$1;
(statearr_22224_22320[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (66))){
var state_22164__$1 = state_22164;
var statearr_22225_22321 = state_22164__$1;
(statearr_22225_22321[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (23))){
var inst_21983 = (state_22164[(19)]);
var inst_21974 = (state_22164[(15)]);
var inst_21966 = inst_21974;
var inst_21967 = inst_21983;
var state_22164__$1 = (function (){var statearr_22227 = state_22164;
(statearr_22227[(16)] = inst_21967);

(statearr_22227[(18)] = inst_21966);

return statearr_22227;
})();
var statearr_22228_22322 = state_22164__$1;
(statearr_22228_22322[(2)] = null);

(statearr_22228_22322[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (47))){
var inst_22066 = (state_22164[(21)]);
var inst_22069 = (state_22164[(2)]);
var inst_22070 = fluree.db.util.async.throw_err.call(null,inst_22069);
var inst_22071 = [inst_22070,r];
var inst_22072 = (new cljs.core.PersistentVector(null,2,(5),inst_22066,inst_22071,null));
var state_22164__$1 = state_22164;
var statearr_22229_22323 = state_22164__$1;
(statearr_22229_22323[(2)] = inst_22072);

(statearr_22229_22323[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (35))){
var inst_22047 = (state_22164[(23)]);
var inst_22046 = cljs.core.count.call(null,clause);
var inst_22047__$1 = cljs.core._EQ_.call(null,(3),inst_22046);
var state_22164__$1 = (function (){var statearr_22230 = state_22164;
(statearr_22230[(23)] = inst_22047__$1);

return statearr_22230;
})();
if(inst_22047__$1){
var statearr_22231_22324 = state_22164__$1;
(statearr_22231_22324[(1)] = (37));

} else {
var statearr_22232_22325 = state_22164__$1;
(statearr_22232_22325[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (19))){
var inst_21967 = (state_22164[(16)]);
var inst_21992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21993 = [inst_21967,r];
var inst_21994 = (new cljs.core.PersistentVector(null,2,(5),inst_21992,inst_21993,null));
var state_22164__$1 = state_22164;
var statearr_22233_22326 = state_22164__$1;
(statearr_22233_22326[(2)] = inst_21994);

(statearr_22233_22326[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (57))){
var inst_22109 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_22164__$1 = state_22164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(60),inst_22109);
} else {
if((state_val_22165 === (68))){
var inst_22113 = (state_22164[(7)]);
var inst_22114 = (state_22164[(8)]);
var inst_22131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22132 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_22113,res,inst_22114,fuel,max_fuel);
var state_22164__$1 = (function (){var statearr_22234 = state_22164;
(statearr_22234[(24)] = inst_22131);

return statearr_22234;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(71),inst_22132);
} else {
if((state_val_22165 === (11))){
var inst_22030 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22236_22327 = state_22164__$1;
(statearr_22236_22327[(2)] = inst_22030);

(statearr_22236_22327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (9))){
var inst_21944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21945 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21946 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21945,res,fuel,max_fuel,opts);
var state_22164__$1 = (function (){var statearr_22237 = state_22164;
(statearr_22237[(22)] = inst_21944);

return statearr_22237;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(12),inst_21946);
} else {
if((state_val_22165 === (5))){
var _ = (function (){var statearr_22238 = state_22164;
(statearr_22238[(4)] = cljs.core.rest.call(null,(state_22164[(4)])));

return statearr_22238;
})();
var state_22164__$1 = state_22164;
var ex22235 = (state_22164__$1[(2)]);
var statearr_22239_22328 = state_22164__$1;
(statearr_22239_22328[(5)] = ex22235);


if((ex22235 instanceof Error)){
var statearr_22240_22329 = state_22164__$1;
(statearr_22240_22329[(1)] = (4));

(statearr_22240_22329[(5)] = null);

} else {
throw ex22235;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (14))){
var inst_21941 = (state_22164[(11)]);
var inst_21937 = (state_22164[(17)]);
var inst_22000 = inst_21941.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_21937);
var state_22164__$1 = state_22164;
if(cljs.core.truth_(inst_22000)){
var statearr_22241_22330 = state_22164__$1;
(statearr_22241_22330[(1)] = (25));

} else {
var statearr_22242_22331 = state_22164__$1;
(statearr_22242_22331[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (45))){
var inst_22074 = cljs.core.count.call(null,clause);
var inst_22075 = cljs.core._EQ_.call(null,(2),inst_22074);
var state_22164__$1 = state_22164;
if(inst_22075){
var statearr_22243_22332 = state_22164__$1;
(statearr_22243_22332[(1)] = (48));

} else {
var statearr_22244_22333 = state_22164__$1;
(statearr_22244_22333[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (53))){
var inst_22149 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22245_22334 = state_22164__$1;
(statearr_22245_22334[(2)] = inst_22149);

(statearr_22245_22334[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (26))){
var inst_21941 = (state_22164[(11)]);
var inst_21937 = (state_22164[(17)]);
var inst_22012 = inst_21941.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_21937);
var state_22164__$1 = state_22164;
if(cljs.core.truth_(inst_22012)){
var statearr_22246_22335 = state_22164__$1;
(statearr_22246_22335[(1)] = (28));

} else {
var statearr_22247_22336 = state_22164__$1;
(statearr_22247_22336[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (16))){
var inst_21973 = (state_22164[(13)]);
var inst_21966 = (state_22164[(18)]);
var inst_21972 = cljs.core.seq.call(null,inst_21966);
var inst_21973__$1 = cljs.core.first.call(null,inst_21972);
var inst_21974 = cljs.core.next.call(null,inst_21972);
var state_22164__$1 = (function (){var statearr_22248 = state_22164;
(statearr_22248[(13)] = inst_21973__$1);

(statearr_22248[(15)] = inst_21974);

return statearr_22248;
})();
if(cljs.core.truth_(inst_21973__$1)){
var statearr_22249_22337 = state_22164__$1;
(statearr_22249_22337[(1)] = (18));

} else {
var statearr_22250_22338 = state_22164__$1;
(statearr_22250_22338[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (38))){
var inst_22047 = (state_22164[(23)]);
var state_22164__$1 = state_22164;
var statearr_22251_22339 = state_22164__$1;
(statearr_22251_22339[(2)] = inst_22047);

(statearr_22251_22339[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (30))){
var inst_22024 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22252_22340 = state_22164__$1;
(statearr_22252_22340[(2)] = inst_22024);

(statearr_22252_22340[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (10))){
var inst_21941 = (state_22164[(11)]);
var inst_21937 = (state_22164[(17)]);
var inst_21953 = inst_21941.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_21937);
var state_22164__$1 = state_22164;
if(cljs.core.truth_(inst_21953)){
var statearr_22253_22341 = state_22164__$1;
(statearr_22253_22341[(1)] = (13));

} else {
var statearr_22254_22342 = state_22164__$1;
(statearr_22254_22342[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (18))){
var inst_21973 = (state_22164[(13)]);
var inst_21976 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21973,q_map,vars,fuel,max_fuel,opts);
var state_22164__$1 = state_22164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(21),inst_21976);
} else {
if((state_val_22165 === (52))){
var state_22164__$1 = state_22164;
var statearr_22255_22343 = state_22164__$1;
(statearr_22255_22343[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (67))){
var inst_22142 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22257_22344 = state_22164__$1;
(statearr_22257_22344[(2)] = inst_22142);

(statearr_22257_22344[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (71))){
var inst_22131 = (state_22164[(24)]);
var inst_22134 = (state_22164[(2)]);
var inst_22135 = fluree.db.util.async.throw_err.call(null,inst_22134);
var inst_22136 = [inst_22135,r];
var inst_22137 = (new cljs.core.PersistentVector(null,2,(5),inst_22131,inst_22136,null));
var state_22164__$1 = state_22164;
var statearr_22258_22345 = state_22164__$1;
(statearr_22258_22345[(2)] = inst_22137);

(statearr_22258_22345[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (42))){
var inst_22155 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22259_22346 = state_22164__$1;
(statearr_22259_22346[(2)] = inst_22155);

(statearr_22259_22346[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (37))){
var inst_22049 = cljs.core.second.call(null,clause);
var inst_22050 = cljs.core._EQ_.call(null,inst_22049,"rdf:type");
var state_22164__$1 = state_22164;
var statearr_22260_22347 = state_22164__$1;
(statearr_22260_22347[(2)] = inst_22050);

(statearr_22260_22347[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (63))){
var inst_22144 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22261_22348 = state_22164__$1;
(statearr_22261_22348[(2)] = inst_22144);

(statearr_22261_22348[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (8))){
var inst_22159 = (state_22164[(2)]);
var _ = (function (){var statearr_22262 = state_22164;
(statearr_22262[(4)] = cljs.core.rest.call(null,(state_22164[(4)])));

return statearr_22262;
})();
var state_22164__$1 = state_22164;
var statearr_22263_22349 = state_22164__$1;
(statearr_22263_22349[(2)] = inst_22159);

(statearr_22263_22349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (49))){
var inst_22083 = cljs.core.count.call(null,clause);
var inst_22084 = cljs.core._EQ_.call(null,(1),inst_22083);
var state_22164__$1 = state_22164;
if(inst_22084){
var statearr_22264_22350 = state_22164__$1;
(statearr_22264_22350[(1)] = (51));

} else {
var statearr_22265_22351 = state_22164__$1;
(statearr_22265_22351[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto____0 = (function (){
var statearr_22266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22266[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto__);

(statearr_22266[(1)] = (1));

return statearr_22266;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto____1 = (function (state_22164){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_22164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e22267){var ex__2706__auto__ = e22267;
var statearr_22268_22352 = state_22164;
(statearr_22268_22352[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_22164[(4)]))){
var statearr_22269_22353 = state_22164;
(statearr_22269_22353[(1)] = cljs.core.first.call(null,(state_22164[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22354 = state_22164;
state_22164 = G__22354;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto__ = function(state_22164){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto____1.call(this,state_22164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_22270 = f__2726__auto__.call(null);
(statearr_22270[(6)] = c__2725__auto__);

return statearr_22270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__22356 = arguments.length;
switch (G__22356) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_22436){
var state_val_22437 = (state_22436[(1)]);
if((state_val_22437 === (7))){
var inst_22431 = (state_22436[(2)]);
var _ = (function (){var statearr_22438 = state_22436;
(statearr_22438[(4)] = cljs.core.rest.call(null,(state_22436[(4)])));

return statearr_22438;
})();
var state_22436__$1 = state_22436;
var statearr_22439_22487 = state_22436__$1;
(statearr_22439_22487[(2)] = inst_22431);

(statearr_22439_22487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (20))){
var inst_22396 = (state_22436[(7)]);
var inst_22408 = (state_22436[(2)]);
var inst_22378 = inst_22396;
var inst_22379 = inst_22408;
var state_22436__$1 = (function (){var statearr_22440 = state_22436;
(statearr_22440[(8)] = inst_22379);

(statearr_22440[(9)] = inst_22378);

return statearr_22440;
})();
var statearr_22441_22488 = state_22436__$1;
(statearr_22441_22488[(2)] = null);

(statearr_22441_22488[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (1))){
var state_22436__$1 = state_22436;
var statearr_22442_22489 = state_22436__$1;
(statearr_22442_22489[(2)] = null);

(statearr_22442_22489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (24))){
var inst_22396 = (state_22436[(7)]);
var inst_22379 = (state_22436[(8)]);
var inst_22395 = (state_22436[(10)]);
var inst_22416 = fluree.db.query.analytical.inner_join.call(null,inst_22379,inst_22395);
var inst_22378 = inst_22396;
var inst_22379__$1 = inst_22416;
var state_22436__$1 = (function (){var statearr_22443 = state_22436;
(statearr_22443[(8)] = inst_22379__$1);

(statearr_22443[(9)] = inst_22378);

return statearr_22443;
})();
var statearr_22444_22490 = state_22436__$1;
(statearr_22444_22490[(2)] = null);

(statearr_22444_22490[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (4))){
var inst_22357 = (state_22436[(2)]);
var state_22436__$1 = state_22436;
var statearr_22446_22491 = state_22436__$1;
(statearr_22446_22491[(2)] = inst_22357);

(statearr_22446_22491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (15))){
var inst_22395 = (state_22436[(10)]);
var state_22436__$1 = state_22436;
if(cljs.core.truth_(inst_22395)){
var statearr_22447_22492 = state_22436__$1;
(statearr_22447_22492[(1)] = (18));

} else {
var statearr_22448_22493 = state_22436__$1;
(statearr_22448_22493[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (21))){
var inst_22396 = (state_22436[(7)]);
var inst_22379 = (state_22436[(8)]);
var tmp22445 = inst_22379;
var inst_22378 = inst_22396;
var inst_22379__$1 = tmp22445;
var state_22436__$1 = (function (){var statearr_22449 = state_22436;
(statearr_22449[(8)] = inst_22379__$1);

(statearr_22449[(9)] = inst_22378);

return statearr_22449;
})();
var statearr_22450_22494 = state_22436__$1;
(statearr_22450_22494[(2)] = null);

(statearr_22450_22494[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (13))){
var inst_22379 = (state_22436[(8)]);
var inst_22402 = cljs.core.dissoc.call(null,inst_22379,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22403 = cljs.core.empty_QMARK_.call(null,inst_22402);
var state_22436__$1 = state_22436;
if(inst_22403){
var statearr_22451_22495 = state_22436__$1;
(statearr_22451_22495[(1)] = (15));

} else {
var statearr_22452_22496 = state_22436__$1;
(statearr_22452_22496[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (22))){
var state_22436__$1 = state_22436;
var statearr_22453_22497 = state_22436__$1;
(statearr_22453_22497[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (6))){
var inst_22385 = (state_22436[(11)]);
var inst_22378 = (state_22436[(9)]);
var inst_22384 = cljs.core.seq.call(null,inst_22378);
var inst_22385__$1 = cljs.core.first.call(null,inst_22384);
var inst_22386 = cljs.core.next.call(null,inst_22384);
var state_22436__$1 = (function (){var statearr_22455 = state_22436;
(statearr_22455[(11)] = inst_22385__$1);

(statearr_22455[(12)] = inst_22386);

return statearr_22455;
})();
if(cljs.core.truth_(inst_22385__$1)){
var statearr_22456_22498 = state_22436__$1;
(statearr_22456_22498[(1)] = (8));

} else {
var statearr_22457_22499 = state_22436__$1;
(statearr_22457_22499[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (25))){
var state_22436__$1 = state_22436;
var statearr_22458_22500 = state_22436__$1;
(statearr_22458_22500[(2)] = null);

(statearr_22458_22500[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (17))){
var inst_22424 = (state_22436[(2)]);
var state_22436__$1 = state_22436;
var statearr_22459_22501 = state_22436__$1;
(statearr_22459_22501[(2)] = inst_22424);

(statearr_22459_22501[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (3))){
var inst_22434 = (state_22436[(2)]);
var state_22436__$1 = state_22436;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22436__$1,inst_22434);
} else {
if((state_val_22437 === (12))){
var inst_22396 = (state_22436[(7)]);
var inst_22395 = (state_22436[(10)]);
var inst_22378 = inst_22396;
var inst_22379 = inst_22395;
var state_22436__$1 = (function (){var statearr_22460 = state_22436;
(statearr_22460[(8)] = inst_22379);

(statearr_22460[(9)] = inst_22378);

return statearr_22460;
})();
var statearr_22461_22502 = state_22436__$1;
(statearr_22461_22502[(2)] = null);

(statearr_22461_22502[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (2))){
var _ = (function (){var statearr_22462 = state_22436;
(statearr_22462[(4)] = cljs.core.cons.call(null,(5),(state_22436[(4)])));

return statearr_22462;
})();
var inst_22370 = where;
var inst_22371 = cljs.core.seq.call(null,inst_22370);
var inst_22372 = cljs.core.first.call(null,inst_22371);
var inst_22373 = cljs.core.next.call(null,inst_22371);
var inst_22374 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_22375 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_22376 = [inst_22375];
var inst_22377 = cljs.core.PersistentHashMap.fromArrays(inst_22374,inst_22376);
var inst_22378 = inst_22370;
var inst_22379 = inst_22377;
var state_22436__$1 = (function (){var statearr_22463 = state_22436;
(statearr_22463[(13)] = inst_22373);

(statearr_22463[(8)] = inst_22379);

(statearr_22463[(14)] = inst_22372);

(statearr_22463[(9)] = inst_22378);

return statearr_22463;
})();
var statearr_22464_22503 = state_22436__$1;
(statearr_22464_22503[(2)] = null);

(statearr_22464_22503[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (23))){
var inst_22422 = (state_22436[(2)]);
var state_22436__$1 = state_22436;
var statearr_22465_22504 = state_22436__$1;
(statearr_22465_22504[(2)] = inst_22422);

(statearr_22465_22504[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (19))){
var inst_22379 = (state_22436[(8)]);
var state_22436__$1 = state_22436;
var statearr_22466_22505 = state_22436__$1;
(statearr_22466_22505[(2)] = inst_22379);

(statearr_22466_22505[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (11))){
var inst_22385 = (state_22436[(11)]);
var inst_22393 = (state_22436[(2)]);
var inst_22394 = fluree.db.util.async.throw_err.call(null,inst_22393);
var inst_22395 = cljs.core.nth.call(null,inst_22394,(0),null);
var inst_22396 = cljs.core.nth.call(null,inst_22394,(1),null);
var inst_22397 = cljs.core.count.call(null,inst_22385);
var inst_22398 = cljs.core._EQ_.call(null,(2),inst_22397);
var state_22436__$1 = (function (){var statearr_22468 = state_22436;
(statearr_22468[(7)] = inst_22396);

(statearr_22468[(10)] = inst_22395);

return statearr_22468;
})();
if(inst_22398){
var statearr_22469_22506 = state_22436__$1;
(statearr_22469_22506[(1)] = (12));

} else {
var statearr_22470_22507 = state_22436__$1;
(statearr_22470_22507[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (9))){
var inst_22379 = (state_22436[(8)]);
var state_22436__$1 = state_22436;
var statearr_22471_22508 = state_22436__$1;
(statearr_22471_22508[(2)] = inst_22379);

(statearr_22471_22508[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (5))){
var _ = (function (){var statearr_22472 = state_22436;
(statearr_22472[(4)] = cljs.core.rest.call(null,(state_22436[(4)])));

return statearr_22472;
})();
var state_22436__$1 = state_22436;
var ex22467 = (state_22436__$1[(2)]);
var statearr_22473_22509 = state_22436__$1;
(statearr_22473_22509[(5)] = ex22467);


if((ex22467 instanceof Error)){
var statearr_22474_22510 = state_22436__$1;
(statearr_22474_22510[(1)] = (4));

(statearr_22474_22510[(5)] = null);

} else {
throw ex22467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (14))){
var inst_22426 = (state_22436[(2)]);
var state_22436__$1 = state_22436;
var statearr_22475_22511 = state_22436__$1;
(statearr_22475_22511[(2)] = inst_22426);

(statearr_22475_22511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (26))){
var inst_22420 = (state_22436[(2)]);
var state_22436__$1 = state_22436;
var statearr_22476_22512 = state_22436__$1;
(statearr_22476_22512[(2)] = inst_22420);

(statearr_22476_22512[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (16))){
var inst_22395 = (state_22436[(10)]);
var inst_22411 = (inst_22395 == null);
var state_22436__$1 = state_22436;
if(cljs.core.truth_(inst_22411)){
var statearr_22477_22513 = state_22436__$1;
(statearr_22477_22513[(1)] = (21));

} else {
var statearr_22478_22514 = state_22436__$1;
(statearr_22478_22514[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (10))){
var inst_22429 = (state_22436[(2)]);
var state_22436__$1 = state_22436;
var statearr_22479_22515 = state_22436__$1;
(statearr_22479_22515[(2)] = inst_22429);

(statearr_22479_22515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (18))){
var inst_22395 = (state_22436[(10)]);
var state_22436__$1 = state_22436;
var statearr_22480_22516 = state_22436__$1;
(statearr_22480_22516[(2)] = inst_22395);

(statearr_22480_22516[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22437 === (8))){
var inst_22385 = (state_22436[(11)]);
var inst_22379 = (state_22436[(8)]);
var inst_22386 = (state_22436[(12)]);
var inst_22391 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_22379,inst_22385,inst_22386,false,fuel,max_fuel,opts);
var state_22436__$1 = state_22436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22436__$1,(11),inst_22391);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2703__auto__ = null;
var fluree$db$query$analytical$state_machine__2703__auto____0 = (function (){
var statearr_22481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22481[(0)] = fluree$db$query$analytical$state_machine__2703__auto__);

(statearr_22481[(1)] = (1));

return statearr_22481;
});
var fluree$db$query$analytical$state_machine__2703__auto____1 = (function (state_22436){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_22436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e22482){var ex__2706__auto__ = e22482;
var statearr_22483_22517 = state_22436;
(statearr_22483_22517[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_22436[(4)]))){
var statearr_22484_22518 = state_22436;
(statearr_22484_22518[(1)] = cljs.core.first.call(null,(state_22436[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22519 = state_22436;
state_22436 = G__22519;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2703__auto__ = function(state_22436){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2703__auto____1.call(this,state_22436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2703__auto____0;
fluree$db$query$analytical$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2703__auto____1;
return fluree$db$query$analytical$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_22485 = f__2726__auto__.call(null);
(statearr_22485[(6)] = c__2725__auto__);

return statearr_22485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_22554){
var state_val_22555 = (state_22554[(1)]);
if((state_val_22555 === (7))){
var inst_22531 = (state_22554[(7)]);
var inst_22536 = (state_22554[(8)]);
var inst_22538 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_22531,inst_22536,fuel,max_fuel,opts);
var state_22554__$1 = state_22554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22554__$1,(10),inst_22538);
} else {
if((state_val_22555 === (1))){
var state_22554__$1 = state_22554;
var statearr_22556_22581 = state_22554__$1;
(statearr_22556_22581[(2)] = null);

(statearr_22556_22581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (4))){
var inst_22520 = (state_22554[(2)]);
var state_22554__$1 = state_22554;
var statearr_22557_22582 = state_22554__$1;
(statearr_22557_22582[(2)] = inst_22520);

(statearr_22557_22582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (13))){
var inst_22549 = (state_22554[(2)]);
var _ = (function (){var statearr_22558 = state_22554;
(statearr_22558[(4)] = cljs.core.rest.call(null,(state_22554[(4)])));

return statearr_22558;
})();
var state_22554__$1 = state_22554;
var statearr_22559_22583 = state_22554__$1;
(statearr_22559_22583[(2)] = inst_22549);

(statearr_22559_22583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (6))){
var inst_22531 = (state_22554[(7)]);
var inst_22535 = (state_22554[(2)]);
var inst_22536 = fluree.db.util.async.throw_err.call(null,inst_22535);
var state_22554__$1 = (function (){var statearr_22560 = state_22554;
(statearr_22560[(8)] = inst_22536);

return statearr_22560;
})();
if(cljs.core.truth_(inst_22531)){
var statearr_22561_22584 = state_22554__$1;
(statearr_22561_22584[(1)] = (7));

} else {
var statearr_22562_22585 = state_22554__$1;
(statearr_22562_22585[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (3))){
var inst_22552 = (state_22554[(2)]);
var state_22554__$1 = state_22554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22554__$1,inst_22552);
} else {
if((state_val_22555 === (12))){
var inst_22544 = (state_22554[(9)]);
var state_22554__$1 = state_22554;
var statearr_22563_22586 = state_22554__$1;
(statearr_22563_22586[(2)] = inst_22544);

(statearr_22563_22586[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (2))){
var _ = (function (){var statearr_22564 = state_22554;
(statearr_22564[(4)] = cljs.core.cons.call(null,(5),(state_22554[(4)])));

return statearr_22564;
})();
var inst_22527 = q_map;
var inst_22528 = cljs.core.__destructure_map.call(null,inst_22527);
var inst_22529 = cljs.core.get.call(null,inst_22528,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22530 = cljs.core.get.call(null,inst_22528,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_22531 = cljs.core.get.call(null,inst_22528,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_22532 = cljs.core.get.call(null,inst_22528,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_22533 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_22530,q_map,inst_22529,fuel,max_fuel,opts);
var state_22554__$1 = (function (){var statearr_22565 = state_22554;
(statearr_22565[(7)] = inst_22531);

(statearr_22565[(10)] = inst_22532);

return statearr_22565;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22554__$1,(6),inst_22533);
} else {
if((state_val_22555 === (11))){
var inst_22544 = (state_22554[(9)]);
var inst_22532 = (state_22554[(10)]);
var inst_22546 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_22544,inst_22532,null);
var state_22554__$1 = state_22554;
var statearr_22567_22587 = state_22554__$1;
(statearr_22567_22587[(2)] = inst_22546);

(statearr_22567_22587[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (9))){
var inst_22532 = (state_22554[(10)]);
var inst_22544 = (state_22554[(2)]);
var state_22554__$1 = (function (){var statearr_22568 = state_22554;
(statearr_22568[(9)] = inst_22544);

return statearr_22568;
})();
if(cljs.core.truth_(inst_22532)){
var statearr_22569_22588 = state_22554__$1;
(statearr_22569_22588[(1)] = (11));

} else {
var statearr_22570_22589 = state_22554__$1;
(statearr_22570_22589[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (5))){
var _ = (function (){var statearr_22571 = state_22554;
(statearr_22571[(4)] = cljs.core.rest.call(null,(state_22554[(4)])));

return statearr_22571;
})();
var state_22554__$1 = state_22554;
var ex22566 = (state_22554__$1[(2)]);
var statearr_22572_22590 = state_22554__$1;
(statearr_22572_22590[(5)] = ex22566);


if((ex22566 instanceof Error)){
var statearr_22573_22591 = state_22554__$1;
(statearr_22573_22591[(1)] = (4));

(statearr_22573_22591[(5)] = null);

} else {
throw ex22566;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (10))){
var inst_22540 = (state_22554[(2)]);
var inst_22541 = fluree.db.util.async.throw_err.call(null,inst_22540);
var state_22554__$1 = state_22554;
var statearr_22574_22592 = state_22554__$1;
(statearr_22574_22592[(2)] = inst_22541);

(statearr_22574_22592[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22555 === (8))){
var inst_22536 = (state_22554[(8)]);
var state_22554__$1 = state_22554;
var statearr_22575_22593 = state_22554__$1;
(statearr_22575_22593[(2)] = inst_22536);

(statearr_22575_22593[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2703__auto____0 = (function (){
var statearr_22576 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22576[(0)] = fluree$db$query$analytical$q_$_state_machine__2703__auto__);

(statearr_22576[(1)] = (1));

return statearr_22576;
});
var fluree$db$query$analytical$q_$_state_machine__2703__auto____1 = (function (state_22554){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_22554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e22577){var ex__2706__auto__ = e22577;
var statearr_22578_22594 = state_22554;
(statearr_22578_22594[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_22554[(4)]))){
var statearr_22579_22595 = state_22554;
(statearr_22579_22595[(1)] = cljs.core.first.call(null,(state_22554[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22596 = state_22554;
state_22554 = G__22596;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2703__auto__ = function(state_22554){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2703__auto____1.call(this,state_22554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2703__auto____0;
fluree$db$query$analytical$q_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2703__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_22580 = f__2726__auto__.call(null);
(statearr_22580[(6)] = c__2725__auto__);

return statearr_22580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
