// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__20620_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20620_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__20624 = coll;
var vec__20625 = G__20624;
var seq__20626 = cljs.core.seq.call(null,vec__20625);
var first__20627 = cljs.core.first.call(null,seq__20626);
var seq__20626__$1 = cljs.core.next.call(null,seq__20626);
var clause = first__20627;
var r = seq__20626__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20624__$1 = G__20624;
var res__$1 = res;
while(true){
var vec__20631 = G__20624__$1;
var seq__20632 = cljs.core.seq.call(null,vec__20631);
var first__20633 = cljs.core.first.call(null,seq__20632);
var seq__20632__$1 = cljs.core.next.call(null,seq__20632);
var clause__$1 = first__20633;
var r__$1 = seq__20632__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__20634 = r__$1;
var G__20635 = cljs.core.conj.call(null,res__$2,clause__$1);
G__20624__$1 = G__20634;
res__$1 = G__20635;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__20636){
var map__20637 = p__20636;
var map__20637__$1 = cljs.core.__destructure_map.call(null,map__20637);
var optional = cljs.core.get.call(null,map__20637__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__20641 = coll;
var vec__20642 = G__20641;
var seq__20643 = cljs.core.seq.call(null,vec__20642);
var first__20644 = cljs.core.first.call(null,seq__20643);
var seq__20643__$1 = cljs.core.next.call(null,seq__20643);
var clause = first__20644;
var r = seq__20643__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20641__$1 = G__20641;
var res__$1 = res;
while(true){
var vec__20648 = G__20641__$1;
var seq__20649 = cljs.core.seq.call(null,vec__20648);
var first__20650 = cljs.core.first.call(null,seq__20649);
var seq__20649__$1 = cljs.core.next.call(null,seq__20649);
var clause__$1 = first__20650;
var r__$1 = seq__20649__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__20651 = r__$1;
var G__20652 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__20641__$1 = G__20651;
res__$1 = G__20652;
continue;
} else {
var G__20653 = r__$1;
var G__20654 = res__$2;
G__20641__$1 = G__20653;
res__$1 = G__20654;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__20658 = coll;
var vec__20659 = G__20658;
var seq__20660 = cljs.core.seq.call(null,vec__20659);
var first__20661 = cljs.core.first.call(null,seq__20660);
var seq__20660__$1 = cljs.core.next.call(null,seq__20660);
var clause = first__20661;
var r = seq__20660__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20658__$1 = G__20658;
var res__$1 = res;
while(true){
var vec__20665 = G__20658__$1;
var seq__20666 = cljs.core.seq.call(null,vec__20665);
var first__20667 = cljs.core.first.call(null,seq__20666);
var seq__20666__$1 = cljs.core.next.call(null,seq__20666);
var clause__$1 = first__20667;
var r__$1 = seq__20666__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__20668 = r__$1;
var G__20669 = res__$2;
G__20658__$1 = G__20668;
res__$1 = G__20669;
continue;
} else {
var G__20670 = r__$1;
var G__20671 = cljs.core.conj.call(null,res__$2,clause__$1);
G__20658__$1 = G__20670;
res__$1 = G__20671;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__20674 = clause;
var G__20674__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__20674):G__20674);
var G__20674__$2 = clojure.string.join.call(null," ",G__20674__$1)
;
var G__20674__$3 = (function (p1__20672_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20672_SHARP_)," ."].join('');
}).call(null,G__20674__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__20673_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20673_SHARP_),"}"].join('');
}).call(null,G__20674__$3);
} else {
return G__20674__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__20678 = opts;
var map__20678__$1 = cljs.core.__destructure_map.call(null,map__20678);
var limit = cljs.core.get.call(null,map__20678__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__20678__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__20678__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__20678__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__20678__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__20675_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20675_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__20676_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__20676_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__20677_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__20677_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_20692){
var state_val_20693 = (state_20692[(1)]);
if((state_val_20693 === (1))){
var inst_20679 = fluree.db.util.core.url_encode.call(null,query);
var inst_20680 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20679)].join('');
var inst_20681 = ["User-Agent","Accept"];
var inst_20682 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_20683 = cljs.core.PersistentHashMap.fromArrays(inst_20681,inst_20682);
var inst_20684 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_20685 = [inst_20683,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_20686 = cljs.core.PersistentHashMap.fromArrays(inst_20684,inst_20685);
var inst_20687 = fluree.db.util.xhttp.get.call(null,inst_20680,inst_20686);
var state_20692__$1 = state_20692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20692__$1,(2),inst_20687);
} else {
if((state_val_20693 === (2))){
var inst_20689 = (state_20692[(2)]);
var inst_20690 = fluree.db.util.async.throw_err.call(null,inst_20689);
var state_20692__$1 = state_20692;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20692__$1,inst_20690);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto____0 = (function (){
var statearr_20694 = [null,null,null,null,null,null,null];
(statearr_20694[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto__);

(statearr_20694[(1)] = (1));

return statearr_20694;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto____1 = (function (state_20692){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_20692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e20695){var ex__2706__auto__ = e20695;
var statearr_20696_20699 = state_20692;
(statearr_20696_20699[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_20692[(4)]))){
var statearr_20697_20700 = state_20692;
(statearr_20697_20700[(1)] = cljs.core.first.call(null,(state_20692[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20701 = state_20692;
state_20692 = G__20701;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto__ = function(state_20692){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto____1.call(this,state_20692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_20698 = f__2726__auto__.call(null);
(statearr_20698[(6)] = c__2725__auto__);

return statearr_20698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_20719){
var state_val_20720 = (state_20719[(1)]);
if((state_val_20720 === (1))){
var inst_20702 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_20719__$1 = state_20719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20719__$1,(2),inst_20702);
} else {
if((state_val_20720 === (2))){
var inst_20705 = (state_20719[(7)]);
var inst_20704 = (state_20719[(2)]);
var inst_20705__$1 = fluree.db.util.async.throw_err.call(null,inst_20704);
var inst_20706 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20705__$1);
var inst_20707 = cljs.core.not_EQ_.call(null,(200),inst_20706);
var state_20719__$1 = (function (){var statearr_20721 = state_20719;
(statearr_20721[(7)] = inst_20705__$1);

return statearr_20721;
})();
if(inst_20707){
var statearr_20722_20731 = state_20719__$1;
(statearr_20722_20731[(1)] = (3));

} else {
var statearr_20723_20732 = state_20719__$1;
(statearr_20723_20732[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20720 === (3))){
var inst_20705 = (state_20719[(7)]);
var state_20719__$1 = state_20719;
var statearr_20724_20733 = state_20719__$1;
(statearr_20724_20733[(2)] = inst_20705);

(statearr_20724_20733[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20720 === (4))){
var inst_20705 = (state_20719[(7)]);
var inst_20710 = (function (){var body = inst_20705;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20711 = cljs.core.second.call(null,inst_20705);
var inst_20712 = cljs.core.second.call(null,inst_20711);
var inst_20713 = cljs.core.first.call(null,inst_20712);
var inst_20714 = cljs.core.second.call(null,inst_20713);
var inst_20715 = cljs.core.mapv.call(null,inst_20710,inst_20714);
var state_20719__$1 = state_20719;
var statearr_20725_20734 = state_20719__$1;
(statearr_20725_20734[(2)] = inst_20715);

(statearr_20725_20734[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20720 === (5))){
var inst_20717 = (state_20719[(2)]);
var state_20719__$1 = state_20719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20719__$1,inst_20717);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto____0 = (function (){
var statearr_20726 = [null,null,null,null,null,null,null,null];
(statearr_20726[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto__);

(statearr_20726[(1)] = (1));

return statearr_20726;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto____1 = (function (state_20719){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_20719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e20727){var ex__2706__auto__ = e20727;
var statearr_20728_20735 = state_20719;
(statearr_20728_20735[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_20719[(4)]))){
var statearr_20729_20736 = state_20719;
(statearr_20729_20736[(1)] = cljs.core.first.call(null,(state_20719[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20737 = state_20719;
state_20719 = G__20737;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto__ = function(state_20719){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto____1.call(this,state_20719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_20730 = f__2726__auto__.call(null);
(statearr_20730[(6)] = c__2725__auto__);

return statearr_20730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__20738_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20738_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__20739_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20739_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__20740_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__20740_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_20786){
var state_val_20787 = (state_20786[(1)]);
if((state_val_20787 === (7))){
var inst_20751 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_20786__$1 = state_20786;
var statearr_20788_20816 = state_20786__$1;
(statearr_20788_20816[(2)] = inst_20751);

(statearr_20788_20816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (1))){
var state_20786__$1 = state_20786;
var statearr_20789_20817 = state_20786__$1;
(statearr_20789_20817[(2)] = null);

(statearr_20789_20817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (4))){
var inst_20741 = (state_20786[(2)]);
var state_20786__$1 = state_20786;
var statearr_20790_20818 = state_20786__$1;
(statearr_20790_20818[(2)] = inst_20741);

(statearr_20790_20818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (15))){
var inst_20759 = (state_20786[(7)]);
var inst_20765 = (state_20786[(8)]);
var inst_20760 = (state_20786[(9)]);
var inst_20770 = (state_20786[(2)]);
var inst_20771 = cljs.core.subs.call(null,inst_20765,(0),inst_20770);
var inst_20772 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20773 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20759);
var inst_20774 = [inst_20760,inst_20773];
var inst_20775 = cljs.core.PersistentHashMap.fromArrays(inst_20772,inst_20774);
var inst_20776 = cljs.core.ex_info.call(null,inst_20771,inst_20775);
var inst_20777 = (function(){throw inst_20776})();
var state_20786__$1 = state_20786;
var statearr_20791_20819 = state_20786__$1;
(statearr_20791_20819[(2)] = inst_20777);

(statearr_20791_20819[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (13))){
var inst_20764 = (state_20786[(10)]);
var state_20786__$1 = state_20786;
var statearr_20792_20820 = state_20786__$1;
(statearr_20792_20820[(2)] = inst_20764);

(statearr_20792_20820[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (6))){
var state_20786__$1 = state_20786;
var statearr_20793_20821 = state_20786__$1;
(statearr_20793_20821[(2)] = null);

(statearr_20793_20821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (3))){
var inst_20784 = (state_20786[(2)]);
var state_20786__$1 = state_20786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20786__$1,inst_20784);
} else {
if((state_val_20787 === (12))){
var inst_20781 = (state_20786[(2)]);
var _ = (function (){var statearr_20794 = state_20786;
(statearr_20794[(4)] = cljs.core.rest.call(null,(state_20786[(4)])));

return statearr_20794;
})();
var state_20786__$1 = state_20786;
var statearr_20795_20822 = state_20786__$1;
(statearr_20795_20822[(2)] = inst_20781);

(statearr_20795_20822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (2))){
var _ = (function (){var statearr_20796 = state_20786;
(statearr_20796[(4)] = cljs.core.cons.call(null,(5),(state_20786[(4)])));

return statearr_20796;
})();
var inst_20748 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_20786__$1 = state_20786;
if(inst_20748){
var statearr_20797_20823 = state_20786__$1;
(statearr_20797_20823[(1)] = (6));

} else {
var statearr_20798_20824 = state_20786__$1;
(statearr_20798_20824[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (11))){
var inst_20759 = (state_20786[(7)]);
var inst_20779 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_20759,all_vars);
var state_20786__$1 = state_20786;
var statearr_20800_20825 = state_20786__$1;
(statearr_20800_20825[(2)] = inst_20779);

(statearr_20800_20825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (9))){
var inst_20759 = (state_20786[(7)]);
var inst_20760 = (state_20786[(9)]);
var inst_20757 = (state_20786[(2)]);
var inst_20758 = fluree.db.util.async.throw_err.call(null,inst_20757);
var inst_20759__$1 = cljs.core.__destructure_map.call(null,inst_20758);
var inst_20760__$1 = cljs.core.get.call(null,inst_20759__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20761 = cljs.core.get.call(null,inst_20759__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20762 = cljs.core._EQ_.call(null,(400),inst_20760__$1);
var state_20786__$1 = (function (){var statearr_20801 = state_20786;
(statearr_20801[(7)] = inst_20759__$1);

(statearr_20801[(11)] = inst_20761);

(statearr_20801[(9)] = inst_20760__$1);

return statearr_20801;
})();
if(inst_20762){
var statearr_20802_20826 = state_20786__$1;
(statearr_20802_20826[(1)] = (10));

} else {
var statearr_20803_20827 = state_20786__$1;
(statearr_20803_20827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (5))){
var _ = (function (){var statearr_20804 = state_20786;
(statearr_20804[(4)] = cljs.core.rest.call(null,(state_20786[(4)])));

return statearr_20804;
})();
var state_20786__$1 = state_20786;
var ex20799 = (state_20786__$1[(2)]);
var statearr_20805_20828 = state_20786__$1;
(statearr_20805_20828[(5)] = ex20799);


if((ex20799 instanceof Error)){
var statearr_20806_20829 = state_20786__$1;
(statearr_20806_20829[(1)] = (4));

(statearr_20806_20829[(5)] = null);

} else {
throw ex20799;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (14))){
var state_20786__$1 = state_20786;
var statearr_20807_20830 = state_20786__$1;
(statearr_20807_20830[(2)] = (1000));

(statearr_20807_20830[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (10))){
var inst_20759 = (state_20786[(7)]);
var inst_20764 = (state_20786[(10)]);
var inst_20761 = (state_20786[(11)]);
var inst_20764__$1 = cljs.core.count.call(null,inst_20761);
var inst_20765 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20759);
var inst_20766 = (inst_20764__$1 < (1000));
var state_20786__$1 = (function (){var statearr_20808 = state_20786;
(statearr_20808[(8)] = inst_20765);

(statearr_20808[(10)] = inst_20764__$1);

return statearr_20808;
})();
if(cljs.core.truth_(inst_20766)){
var statearr_20809_20831 = state_20786__$1;
(statearr_20809_20831[(1)] = (13));

} else {
var statearr_20810_20832 = state_20786__$1;
(statearr_20810_20832[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20787 === (8))){
var inst_20753 = (state_20786[(2)]);
var inst_20754 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_20753,optional_clauses);
var inst_20755 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_20754);
var state_20786__$1 = state_20786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20786__$1,(9),inst_20755);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto____0 = (function (){
var statearr_20811 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20811[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto__);

(statearr_20811[(1)] = (1));

return statearr_20811;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto____1 = (function (state_20786){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_20786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e20812){var ex__2706__auto__ = e20812;
var statearr_20813_20833 = state_20786;
(statearr_20813_20833[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_20786[(4)]))){
var statearr_20814_20834 = state_20786;
(statearr_20814_20834[(1)] = cljs.core.first.call(null,(state_20786[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20835 = state_20786;
state_20786 = G__20835;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto__ = function(state_20786){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto____1.call(this,state_20786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_20815 = f__2726__auto__.call(null);
(statearr_20815[(6)] = c__2725__auto__);

return statearr_20815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
