// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22774 = arguments.length;
switch (G__22774) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22777 = arguments.length;
switch (G__22777) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22779 = null;
var G__22779__0 = (function (){
return xf.call(null);
});
var G__22779__1 = (function (result){
return xf.call(null,result);
});
var G__22779__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22779 = function(result,flake){
switch(arguments.length){
case 0:
return G__22779__0.call(this);
case 1:
return G__22779__1.call(this,result);
case 2:
return G__22779__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22779.cljs$core$IFn$_invoke$arity$0 = G__22779__0;
G__22779.cljs$core$IFn$_invoke$arity$1 = G__22779__1;
G__22779.cljs$core$IFn$_invoke$arity$2 = G__22779__2;
return G__22779;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22780 = null;
var G__22780__0 = (function (){
return xf.call(null);
});
var G__22780__1 = (function (result){
return xf.call(null,result);
});
var G__22780__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,cljs.core.count.call(null,flakes));

return xf.call(null,result,flakes);
});
G__22780 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22780__0.call(this);
case 1:
return G__22780__1.call(this,result);
case 2:
return G__22780__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22780.cljs$core$IFn$_invoke$arity$0 = G__22780__0;
G__22780.cljs$core$IFn$_invoke$arity$1 = G__22780__1;
G__22780.cljs$core$IFn$_invoke$arity$2 = G__22780__2;
return G__22780;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__22782 = res;
var G__22782__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__22781_SHARP_){
return cljs.core.get.call(null,p1__22781_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22782):G__22782);
var G__22782__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__22782__$1):G__22782__$1);
var G__22782__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__22782__$2):G__22782__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__22782__$3);
} else {
return G__22782__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22786 = arguments.length;
switch (G__22786) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_23225){
var state_val_23226 = (state_23225[(1)]);
if((state_val_23226 === (121))){
var inst_23148 = (state_23225[(2)]);
var inst_23149 = fluree.db.util.async.throw_err.call(null,inst_23148);
var inst_23150 = cljs.core.seq.call(null,inst_23149);
var state_23225__$1 = state_23225;
if(inst_23150){
var statearr_23227_23441 = state_23225__$1;
(statearr_23227_23441[(1)] = (122));

} else {
var statearr_23228_23442 = state_23225__$1;
(statearr_23228_23442[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (65))){
var inst_22941 = (state_23225[(7)]);
var inst_22940 = (state_23225[(2)]);
var inst_22941__$1 = fluree.db.util.async.throw_err.call(null,inst_22940);
var inst_22942 = cljs.core.seq.call(null,inst_22941__$1);
var state_23225__$1 = (function (){var statearr_23229 = state_23225;
(statearr_23229[(7)] = inst_22941__$1);

return statearr_23229;
})();
if(inst_22942){
var statearr_23230_23443 = state_23225__$1;
(statearr_23230_23443[(1)] = (66));

} else {
var statearr_23231_23444 = state_23225__$1;
(statearr_23231_23444[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (70))){
var inst_22941 = (state_23225[(7)]);
var inst_22952 = cljs.core.count.call(null,inst_22941);
var inst_22953 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22952);
var state_23225__$1 = state_23225;
var statearr_23232_23445 = state_23225__$1;
(statearr_23232_23445[(2)] = inst_22953);

(statearr_23232_23445[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (62))){
var inst_22931 = (state_23225[(8)]);
var inst_22934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22935 = inst_22931.o;
var inst_22936 = [inst_22935];
var inst_22937 = (new cljs.core.PersistentVector(null,1,(5),inst_22934,inst_22936,null));
var inst_22938 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22937);
var state_23225__$1 = state_23225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23225__$1,(65),inst_22938);
} else {
if((state_val_23226 === (74))){
var inst_22925 = (state_23225[(9)]);
var state_23225__$1 = state_23225;
var statearr_23233_23446 = state_23225__$1;
(statearr_23233_23446[(2)] = inst_22925);

(statearr_23233_23446[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (110))){
var inst_23110 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_23111 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_23110);
var inst_23112 = inst_23111 === true;
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_23112)){
var statearr_23234_23447 = state_23225__$1;
(statearr_23234_23447[(1)] = (113));

} else {
var statearr_23235_23448 = state_23225__$1;
(statearr_23235_23448[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (130))){
var inst_23220 = (state_23225[(2)]);
var _ = (function (){var statearr_23236 = state_23225;
(statearr_23236[(4)] = cljs.core.rest.call(null,(state_23225[(4)])));

return statearr_23236;
})();
var state_23225__$1 = state_23225;
var statearr_23237_23449 = state_23225__$1;
(statearr_23237_23449[(2)] = inst_23220);

(statearr_23237_23449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (128))){
var inst_23195 = (state_23225[(10)]);
var inst_23198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23199 = [acc,inst_23195];
var inst_23200 = (new cljs.core.PersistentVector(null,2,(5),inst_23198,inst_23199,null));
var state_23225__$1 = state_23225;
var statearr_23238_23450 = state_23225__$1;
(statearr_23238_23450[(2)] = inst_23200);

(statearr_23238_23450[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (7))){
var inst_22798 = (state_23225[(11)]);
var state_23225__$1 = state_23225;
var statearr_23239_23451 = state_23225__$1;
(statearr_23239_23451[(2)] = inst_22798);

(statearr_23239_23451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (59))){
var inst_23189 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23240_23452 = state_23225__$1;
(statearr_23240_23452[(2)] = inst_23189);

(statearr_23240_23452[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (86))){
var inst_23019 = (state_23225[(12)]);
var inst_23019__$1 = (state_23225[(2)]);
var state_23225__$1 = (function (){var statearr_23241 = state_23225;
(statearr_23241[(12)] = inst_23019__$1);

return statearr_23241;
})();
if(cljs.core.truth_(inst_23019__$1)){
var statearr_23242_23453 = state_23225__$1;
(statearr_23242_23453[(1)] = (88));

} else {
var statearr_23243_23454 = state_23225__$1;
(statearr_23243_23454[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (20))){
var inst_22840 = (state_23225[(13)]);
var inst_22839 = (state_23225[(14)]);
var inst_22827 = (state_23225[(15)]);
var inst_22838 = (state_23225[(2)]);
var inst_22839__$1 = cljs.core.__destructure_map.call(null,inst_22827);
var inst_22840__$1 = cljs.core.get.call(null,inst_22839__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22841 = cljs.core.get.call(null,inst_22839__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22842 = cljs.core.get.call(null,inst_22839__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22843 = cljs.core.get.call(null,inst_22839__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22844 = cljs.core.get.call(null,inst_22839__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22845 = cljs.core.get.call(null,inst_22839__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_23225__$1 = (function (){var statearr_23244 = state_23225;
(statearr_23244[(16)] = inst_22838);

(statearr_23244[(17)] = inst_22843);

(statearr_23244[(18)] = inst_22842);

(statearr_23244[(19)] = inst_22845);

(statearr_23244[(13)] = inst_22840__$1);

(statearr_23244[(14)] = inst_22839__$1);

(statearr_23244[(20)] = inst_22841);

(statearr_23244[(21)] = inst_22844);

return statearr_23244;
})();
if(cljs.core.truth_(inst_22840__$1)){
var statearr_23245_23455 = state_23225__$1;
(statearr_23245_23455[(1)] = (24));

} else {
var statearr_23246_23456 = state_23225__$1;
(statearr_23246_23456[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (72))){
var inst_22950 = (state_23225[(22)]);
var inst_22956 = (state_23225[(2)]);
var inst_22957 = cljs.core.seq.call(null,inst_22950);
var state_23225__$1 = (function (){var statearr_23247 = state_23225;
(statearr_23247[(23)] = inst_22956);

return statearr_23247;
})();
if(inst_22957){
var statearr_23248_23457 = state_23225__$1;
(statearr_23248_23457[(1)] = (73));

} else {
var statearr_23249_23458 = state_23225__$1;
(statearr_23249_23458[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (58))){
var inst_22827 = (state_23225[(15)]);
var inst_22972 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22827);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22972)){
var statearr_23250_23459 = state_23225__$1;
(statearr_23250_23459[(1)] = (76));

} else {
var statearr_23251_23460 = state_23225__$1;
(statearr_23251_23460[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (60))){
var inst_22931 = (state_23225[(8)]);
var inst_22924 = (state_23225[(24)]);
var inst_22930 = cljs.core.seq.call(null,inst_22924);
var inst_22931__$1 = cljs.core.first.call(null,inst_22930);
var inst_22932 = cljs.core.next.call(null,inst_22930);
var state_23225__$1 = (function (){var statearr_23252 = state_23225;
(statearr_23252[(8)] = inst_22931__$1);

(statearr_23252[(25)] = inst_22932);

return statearr_23252;
})();
if(cljs.core.truth_(inst_22931__$1)){
var statearr_23253_23461 = state_23225__$1;
(statearr_23253_23461[(1)] = (62));

} else {
var statearr_23254_23462 = state_23225__$1;
(statearr_23254_23462[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (27))){
var inst_22848 = (state_23225[(26)]);
var inst_22844 = (state_23225[(21)]);
var inst_22848__$1 = cljs.core.not_EQ_.call(null,(0),inst_22844);
var state_23225__$1 = (function (){var statearr_23255 = state_23225;
(statearr_23255[(26)] = inst_22848__$1);

return statearr_23255;
})();
if(inst_22848__$1){
var statearr_23256_23463 = state_23225__$1;
(statearr_23256_23463[(1)] = (30));

} else {
var statearr_23257_23464 = state_23225__$1;
(statearr_23257_23464[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (1))){
var state_23225__$1 = state_23225;
var statearr_23258_23465 = state_23225__$1;
(statearr_23258_23465[(2)] = null);

(statearr_23258_23465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (69))){
var inst_22946 = (state_23225[(2)]);
var inst_22947 = fluree.db.util.async.throw_err.call(null,inst_22946);
var state_23225__$1 = state_23225;
var statearr_23259_23466 = state_23225__$1;
(statearr_23259_23466[(2)] = inst_22947);

(statearr_23259_23466[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (101))){
var inst_23103 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23260_23467 = state_23225__$1;
(statearr_23260_23467[(2)] = inst_23103);

(statearr_23260_23467[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (24))){
var inst_22844 = (state_23225[(21)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22844)){
var statearr_23261_23468 = state_23225__$1;
(statearr_23261_23468[(1)] = (27));

} else {
var statearr_23262_23469 = state_23225__$1;
(statearr_23262_23469[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (102))){
var inst_23075 = (state_23225[(27)]);
var inst_23074 = (state_23225[(2)]);
var inst_23075__$1 = fluree.db.util.async.throw_err.call(null,inst_23074);
var inst_23076 = cljs.core.empty_QMARK_.call(null,inst_23075__$1);
var state_23225__$1 = (function (){var statearr_23263 = state_23225;
(statearr_23263[(27)] = inst_23075__$1);

return statearr_23263;
})();
if(inst_23076){
var statearr_23264_23470 = state_23225__$1;
(statearr_23264_23470[(1)] = (103));

} else {
var statearr_23265_23471 = state_23225__$1;
(statearr_23265_23471[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (135))){
var state_23225__$1 = state_23225;
var statearr_23266_23472 = state_23225__$1;
(statearr_23266_23472[(2)] = null);

(statearr_23266_23472[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (55))){
var inst_22827 = (state_23225[(15)]);
var inst_22900 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22827);
var state_23225__$1 = state_23225;
var statearr_23267_23473 = state_23225__$1;
(statearr_23267_23473[(2)] = inst_22900);

(statearr_23267_23473[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (85))){
var inst_22994 = (state_23225[(28)]);
var inst_22827 = (state_23225[(15)]);
var inst_23006 = inst_22994.o;
var inst_23007 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22827);
var inst_23008 = fluree.db.dbproto._tag.call(null,db,inst_23006,inst_23007);
var state_23225__$1 = state_23225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23225__$1,(87),inst_23008);
} else {
if((state_val_23226 === (39))){
var inst_22843 = (state_23225[(17)]);
var inst_22875 = (state_23225[(29)]);
var inst_22875__$1 = cljs.core.not.call(null,inst_22843);
var state_23225__$1 = (function (){var statearr_23268 = state_23225;
(statearr_23268[(29)] = inst_22875__$1);

return statearr_23268;
})();
if(inst_22875__$1){
var statearr_23269_23474 = state_23225__$1;
(statearr_23269_23474[(1)] = (42));

} else {
var statearr_23270_23475 = state_23225__$1;
(statearr_23270_23475[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (88))){
var inst_22988 = (state_23225[(30)]);
var inst_23019 = (state_23225[(12)]);
var inst_23021 = cljs.core.conj.call(null,inst_22988,inst_23019);
var state_23225__$1 = state_23225;
var statearr_23271_23476 = state_23225__$1;
(statearr_23271_23476[(2)] = inst_23021);

(statearr_23271_23476[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (46))){
var inst_22842 = (state_23225[(18)]);
var state_23225__$1 = state_23225;
var statearr_23272_23477 = state_23225__$1;
(statearr_23272_23477[(2)] = inst_22842);

(statearr_23272_23477[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (4))){
var inst_22787 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23273_23478 = state_23225__$1;
(statearr_23273_23478[(2)] = inst_22787);

(statearr_23273_23478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (77))){
var inst_23034 = (state_23225[(31)]);
var inst_23034__$1 = componentFollow_QMARK_;
var state_23225__$1 = (function (){var statearr_23274 = state_23225;
(statearr_23274[(31)] = inst_23034__$1);

return statearr_23274;
})();
if(cljs.core.truth_(inst_23034__$1)){
var statearr_23275_23479 = state_23225__$1;
(statearr_23275_23479[(1)] = (91));

} else {
var statearr_23276_23480 = state_23225__$1;
(statearr_23276_23480[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (106))){
var inst_23055 = (state_23225[(32)]);
var inst_23089 = (state_23225[(2)]);
var inst_23090 = fluree.db.util.async.throw_err.call(null,inst_23089);
var inst_23091 = cljs.core.conj.call(null,inst_23055,inst_23090);
var state_23225__$1 = state_23225;
var statearr_23277_23481 = state_23225__$1;
(statearr_23277_23481[(2)] = inst_23091);

(statearr_23277_23481[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (119))){
var inst_23133 = (state_23225[(33)]);
var inst_23163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23164 = [inst_23133,offset_map];
var inst_23165 = (new cljs.core.PersistentVector(null,2,(5),inst_23163,inst_23164,null));
var state_23225__$1 = state_23225;
var statearr_23278_23482 = state_23225__$1;
(statearr_23278_23482[(2)] = inst_23165);

(statearr_23278_23482[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (95))){
var inst_22841 = (state_23225[(20)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22841)){
var statearr_23279_23483 = state_23225__$1;
(statearr_23279_23483[(1)] = (110));

} else {
var statearr_23280_23484 = state_23225__$1;
(statearr_23280_23484[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (54))){
var inst_22897 = (state_23225[(34)]);
var state_23225__$1 = state_23225;
var statearr_23281_23485 = state_23225__$1;
(statearr_23281_23485[(2)] = inst_22897);

(statearr_23281_23485[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (92))){
var inst_23034 = (state_23225[(31)]);
var state_23225__$1 = state_23225;
var statearr_23282_23486 = state_23225__$1;
(statearr_23282_23486[(2)] = inst_23034);

(statearr_23282_23486[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (104))){
var inst_23075 = (state_23225[(27)]);
var inst_22797 = (state_23225[(35)]);
var inst_23084 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_23085 = [true,inst_22797];
var inst_23086 = cljs.core.PersistentHashMap.fromArrays(inst_23084,inst_23085);
var inst_23087 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23086,inst_23075);
var state_23225__$1 = state_23225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23225__$1,(106),inst_23087);
} else {
if((state_val_23226 === (15))){
var inst_22797 = (state_23225[(35)]);
var inst_22820 = (state_23225[(36)]);
var inst_22824 = cljs.core.assoc.call(null,inst_22820,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22797);
var state_23225__$1 = state_23225;
var statearr_23283_23487 = state_23225__$1;
(statearr_23283_23487[(2)] = inst_22824);

(statearr_23283_23487[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (48))){
var inst_22891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22892 = [null,offset_map];
var inst_22893 = (new cljs.core.PersistentVector(null,2,(5),inst_22891,inst_22892,null));
var state_23225__$1 = state_23225;
var statearr_23284_23488 = state_23225__$1;
(statearr_23284_23488[(2)] = inst_22893);

(statearr_23284_23488[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (50))){
var inst_23191 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23285_23489 = state_23225__$1;
(statearr_23285_23489[(2)] = inst_23191);

(statearr_23285_23489[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (116))){
var inst_23139 = (state_23225[(37)]);
var inst_23132 = (state_23225[(38)]);
var inst_23138 = cljs.core.seq.call(null,inst_23132);
var inst_23139__$1 = cljs.core.first.call(null,inst_23138);
var inst_23140 = cljs.core.next.call(null,inst_23138);
var state_23225__$1 = (function (){var statearr_23286 = state_23225;
(statearr_23286[(37)] = inst_23139__$1);

(statearr_23286[(39)] = inst_23140);

return statearr_23286;
})();
if(cljs.core.truth_(inst_23139__$1)){
var statearr_23287_23490 = state_23225__$1;
(statearr_23287_23490[(1)] = (118));

} else {
var statearr_23288_23491 = state_23225__$1;
(statearr_23288_23491[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (75))){
var inst_22932 = (state_23225[(25)]);
var inst_22962 = (state_23225[(2)]);
var inst_22924 = inst_22932;
var inst_22925 = inst_22962;
var state_23225__$1 = (function (){var statearr_23289 = state_23225;
(statearr_23289[(9)] = inst_22925);

(statearr_23289[(24)] = inst_22924);

return statearr_23289;
})();
var statearr_23290_23492 = state_23225__$1;
(statearr_23290_23492[(2)] = null);

(statearr_23290_23492[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (99))){
var inst_23061 = (state_23225[(40)]);
var inst_22827 = (state_23225[(15)]);
var inst_23064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23065 = inst_23061.o;
var inst_23066 = [inst_23065];
var inst_23067 = (new cljs.core.PersistentVector(null,1,(5),inst_23064,inst_23066,null));
var inst_23068 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23069 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22827);
var inst_23070 = [inst_23069];
var inst_23071 = cljs.core.PersistentHashMap.fromArrays(inst_23068,inst_23070);
var inst_23072 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23067,inst_23071);
var state_23225__$1 = state_23225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23225__$1,(102),inst_23072);
} else {
if((state_val_23226 === (21))){
var inst_22831 = (state_23225[(41)]);
var state_23225__$1 = state_23225;
var statearr_23291_23493 = state_23225__$1;
(statearr_23291_23493[(2)] = inst_22831);

(statearr_23291_23493[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (31))){
var inst_22848 = (state_23225[(26)]);
var state_23225__$1 = state_23225;
var statearr_23292_23494 = state_23225__$1;
(statearr_23292_23494[(2)] = inst_22848);

(statearr_23292_23494[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (113))){
var inst_22838 = (state_23225[(16)]);
var inst_22843 = (state_23225[(17)]);
var inst_22842 = (state_23225[(18)]);
var inst_22845 = (state_23225[(19)]);
var inst_22840 = (state_23225[(13)]);
var inst_22797 = (state_23225[(35)]);
var inst_22839 = (state_23225[(14)]);
var inst_22827 = (state_23225[(15)]);
var inst_22812 = (state_23225[(42)]);
var inst_22841 = (state_23225[(20)]);
var inst_22844 = (state_23225[(21)]);
var inst_23114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23115 = (function (){var p = inst_22845;
var pred_spec__$1 = inst_22812;
var orderBy = inst_22843;
var multi_QMARK_ = inst_22840;
var limit = inst_22842;
var offset = inst_22844;
var map__22793 = inst_22839;
var k = inst_22838;
var compact_QMARK_ = inst_22797;
var pred_spec_SINGLEQUOTE_ = inst_22827;
var ref_QMARK_ = inst_22841;
return (function (p1__22783_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22783_SHARP_.o]);
});
})();
var inst_23116 = cljs.core.mapv.call(null,inst_23115,flakes);
var inst_23117 = [inst_23116,offset_map];
var inst_23118 = (new cljs.core.PersistentVector(null,2,(5),inst_23114,inst_23117,null));
var state_23225__$1 = state_23225;
var statearr_23293_23495 = state_23225__$1;
(statearr_23293_23495[(2)] = inst_23118);

(statearr_23293_23495[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (32))){
var inst_22854 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23294_23496 = state_23225__$1;
(statearr_23294_23496[(2)] = inst_22854);

(statearr_23294_23496[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (136))){
var inst_23216 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23295_23497 = state_23225__$1;
(statearr_23295_23497[(2)] = inst_23216);

(statearr_23295_23497[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (40))){
var inst_22840 = (state_23225[(13)]);
var state_23225__$1 = state_23225;
var statearr_23296_23498 = state_23225__$1;
(statearr_23296_23498[(2)] = inst_22840);

(statearr_23296_23498[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (129))){
var inst_22840 = (state_23225[(13)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22840)){
var statearr_23297_23499 = state_23225__$1;
(statearr_23297_23499[(1)] = (131));

} else {
var statearr_23298_23500 = state_23225__$1;
(statearr_23298_23500[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (91))){
var inst_22827 = (state_23225[(15)]);
var inst_23036 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22827);
var state_23225__$1 = state_23225;
var statearr_23299_23501 = state_23225__$1;
(statearr_23299_23501[(2)] = inst_23036);

(statearr_23299_23501[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (117))){
var inst_23169 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23300_23502 = state_23225__$1;
(statearr_23300_23502[(2)] = inst_23169);

(statearr_23300_23502[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (108))){
var state_23225__$1 = state_23225;
var statearr_23301_23503 = state_23225__$1;
(statearr_23301_23503[(2)] = null);

(statearr_23301_23503[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (56))){
var inst_22902 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23302_23504 = state_23225__$1;
(statearr_23302_23504[(2)] = inst_22902);

(statearr_23302_23504[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (33))){
var inst_22845 = (state_23225[(19)]);
var inst_22862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22863 = cljs.core.get.call(null,offset_map,inst_22845);
var state_23225__$1 = (function (){var statearr_23303 = state_23225;
(statearr_23303[(43)] = inst_22862);

return statearr_23303;
})();
if(cljs.core.truth_(inst_22863)){
var statearr_23304_23505 = state_23225__$1;
(statearr_23304_23505[(1)] = (36));

} else {
var statearr_23305_23506 = state_23225__$1;
(statearr_23305_23506[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (13))){
var inst_22812 = (state_23225[(42)]);
var state_23225__$1 = state_23225;
var statearr_23306_23507 = state_23225__$1;
(statearr_23306_23507[(2)] = inst_22812);

(statearr_23306_23507[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (22))){
var inst_22827 = (state_23225[(15)]);
var inst_22834 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22827);
var state_23225__$1 = state_23225;
var statearr_23307_23508 = state_23225__$1;
(statearr_23307_23508[(2)] = inst_22834);

(statearr_23307_23508[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (90))){
var inst_22995 = (state_23225[(44)]);
var inst_23024 = (state_23225[(2)]);
var inst_22987 = inst_22995;
var inst_22988 = inst_23024;
var state_23225__$1 = (function (){var statearr_23308 = state_23225;
(statearr_23308[(45)] = inst_22987);

(statearr_23308[(30)] = inst_22988);

return statearr_23308;
})();
var statearr_23309_23509 = state_23225__$1;
(statearr_23309_23509[(2)] = null);

(statearr_23309_23509[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (109))){
var inst_23093 = (state_23225[(46)]);
var inst_23062 = (state_23225[(47)]);
var inst_23099 = (state_23225[(2)]);
var inst_23054 = inst_23062;
var inst_23055 = inst_23093;
var state_23225__$1 = (function (){var statearr_23310 = state_23225;
(statearr_23310[(48)] = inst_23099);

(statearr_23310[(49)] = inst_23054);

(statearr_23310[(32)] = inst_23055);

return statearr_23310;
})();
var statearr_23311_23510 = state_23225__$1;
(statearr_23311_23510[(2)] = null);

(statearr_23311_23510[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (36))){
var inst_22845 = (state_23225[(19)]);
var inst_22865 = cljs.core.update.call(null,offset_map,inst_22845,cljs.core.dec);
var state_23225__$1 = state_23225;
var statearr_23312_23511 = state_23225__$1;
(statearr_23312_23511[(2)] = inst_22865);

(statearr_23312_23511[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (41))){
var inst_22889 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22889)){
var statearr_23313_23512 = state_23225__$1;
(statearr_23313_23512[(1)] = (48));

} else {
var statearr_23314_23513 = state_23225__$1;
(statearr_23314_23513[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (118))){
var inst_23139 = (state_23225[(37)]);
var inst_23142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23143 = inst_23139.o;
var inst_23144 = [inst_23143];
var inst_23145 = (new cljs.core.PersistentVector(null,1,(5),inst_23142,inst_23144,null));
var inst_23146 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23145);
var state_23225__$1 = state_23225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23225__$1,(121),inst_23146);
} else {
if((state_val_23226 === (89))){
var inst_22988 = (state_23225[(30)]);
var state_23225__$1 = state_23225;
var statearr_23315_23514 = state_23225__$1;
(statearr_23315_23514[(2)] = inst_22988);

(statearr_23315_23514[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (100))){
var inst_23055 = (state_23225[(32)]);
var state_23225__$1 = state_23225;
var statearr_23316_23515 = state_23225__$1;
(statearr_23316_23515[(2)] = inst_23055);

(statearr_23316_23515[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (131))){
var inst_23194 = (state_23225[(50)]);
var inst_22838 = (state_23225[(16)]);
var inst_23195 = (state_23225[(10)]);
var inst_23203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23204 = cljs.core.assoc.call(null,acc,inst_22838,inst_23194);
var inst_23205 = [inst_23204,inst_23195];
var inst_23206 = (new cljs.core.PersistentVector(null,2,(5),inst_23203,inst_23205,null));
var state_23225__$1 = state_23225;
var statearr_23317_23516 = state_23225__$1;
(statearr_23317_23516[(2)] = inst_23206);

(statearr_23317_23516[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (122))){
var inst_23139 = (state_23225[(37)]);
var inst_23133 = (state_23225[(33)]);
var inst_23140 = (state_23225[(39)]);
var inst_23152 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23153 = inst_23139.o;
var inst_23154 = [inst_23153];
var inst_23155 = cljs.core.PersistentHashMap.fromArrays(inst_23152,inst_23154);
var inst_23156 = cljs.core.conj.call(null,inst_23133,inst_23155);
var inst_23132 = inst_23140;
var inst_23133__$1 = inst_23156;
var state_23225__$1 = (function (){var statearr_23318 = state_23225;
(statearr_23318[(33)] = inst_23133__$1);

(statearr_23318[(38)] = inst_23132);

return statearr_23318;
})();
var statearr_23319_23517 = state_23225__$1;
(statearr_23319_23517[(2)] = null);

(statearr_23319_23517[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (43))){
var inst_22875 = (state_23225[(29)]);
var state_23225__$1 = state_23225;
var statearr_23320_23518 = state_23225__$1;
(statearr_23320_23518[(2)] = inst_22875);

(statearr_23320_23518[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (61))){
var inst_22911 = (state_23225[(51)]);
var inst_22968 = (state_23225[(2)]);
var inst_22969 = [inst_22968,offset_map];
var inst_22970 = (new cljs.core.PersistentVector(null,2,(5),inst_22911,inst_22969,null));
var state_23225__$1 = state_23225;
var statearr_23321_23519 = state_23225__$1;
(statearr_23321_23519[(2)] = inst_22970);

(statearr_23321_23519[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (29))){
var inst_22857 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23322_23520 = state_23225__$1;
(statearr_23322_23520[(2)] = inst_22857);

(statearr_23322_23520[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (44))){
var inst_22886 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23323_23521 = state_23225__$1;
(statearr_23323_23521[(2)] = inst_22886);

(statearr_23323_23521[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (93))){
var inst_23039 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_23039)){
var statearr_23324_23522 = state_23225__$1;
(statearr_23324_23522[(1)] = (94));

} else {
var statearr_23325_23523 = state_23225__$1;
(statearr_23325_23523[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (6))){
var inst_22800 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22801 = (inst_22800 == null);
var state_23225__$1 = state_23225;
var statearr_23326_23524 = state_23225__$1;
(statearr_23326_23524[(2)] = inst_22801);

(statearr_23326_23524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (111))){
var state_23225__$1 = state_23225;
var statearr_23327_23525 = state_23225__$1;
(statearr_23327_23525[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (28))){
var inst_22844 = (state_23225[(21)]);
var state_23225__$1 = state_23225;
var statearr_23329_23526 = state_23225__$1;
(statearr_23329_23526[(2)] = inst_22844);

(statearr_23329_23526[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (134))){
var inst_23194 = (state_23225[(50)]);
var inst_22838 = (state_23225[(16)]);
var inst_23195 = (state_23225[(10)]);
var inst_23209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23210 = cljs.core.first.call(null,inst_23194);
var inst_23211 = cljs.core.assoc.call(null,acc,inst_22838,inst_23210);
var inst_23212 = [inst_23211,inst_23195];
var inst_23213 = (new cljs.core.PersistentVector(null,2,(5),inst_23209,inst_23212,null));
var state_23225__$1 = state_23225;
var statearr_23330_23527 = state_23225__$1;
(statearr_23330_23527[(2)] = inst_23213);

(statearr_23330_23527[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (64))){
var inst_22966 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23331_23528 = state_23225__$1;
(statearr_23331_23528[(2)] = inst_22966);

(statearr_23331_23528[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (103))){
var inst_23055 = (state_23225[(32)]);
var inst_23061 = (state_23225[(40)]);
var inst_23078 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23079 = inst_23061.o;
var inst_23080 = [inst_23079];
var inst_23081 = cljs.core.PersistentHashMap.fromArrays(inst_23078,inst_23080);
var inst_23082 = cljs.core.conj.call(null,inst_23055,inst_23081);
var state_23225__$1 = state_23225;
var statearr_23332_23529 = state_23225__$1;
(statearr_23332_23529[(2)] = inst_23082);

(statearr_23332_23529[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (51))){
var inst_22897 = (state_23225[(34)]);
var inst_22827 = (state_23225[(15)]);
var inst_22897__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22827);
var state_23225__$1 = (function (){var statearr_23333 = state_23225;
(statearr_23333[(34)] = inst_22897__$1);

return statearr_23333;
})();
if(cljs.core.truth_(inst_22897__$1)){
var statearr_23334_23530 = state_23225__$1;
(statearr_23334_23530[(1)] = (54));

} else {
var statearr_23335_23531 = state_23225__$1;
(statearr_23335_23531[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (25))){
var inst_22840 = (state_23225[(13)]);
var state_23225__$1 = state_23225;
var statearr_23336_23532 = state_23225__$1;
(statearr_23336_23532[(2)] = inst_22840);

(statearr_23336_23532[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (34))){
var inst_22840 = (state_23225[(13)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22840)){
var statearr_23337_23533 = state_23225__$1;
(statearr_23337_23533[(1)] = (39));

} else {
var statearr_23338_23534 = state_23225__$1;
(statearr_23338_23534[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (125))){
var inst_22838 = (state_23225[(16)]);
var inst_22843 = (state_23225[(17)]);
var inst_22842 = (state_23225[(18)]);
var inst_22845 = (state_23225[(19)]);
var inst_22840 = (state_23225[(13)]);
var inst_22797 = (state_23225[(35)]);
var inst_22839 = (state_23225[(14)]);
var inst_22827 = (state_23225[(15)]);
var inst_22812 = (state_23225[(42)]);
var inst_22841 = (state_23225[(20)]);
var inst_22844 = (state_23225[(21)]);
var inst_23174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23175 = (function (){var p = inst_22845;
var pred_spec__$1 = inst_22812;
var orderBy = inst_22843;
var multi_QMARK_ = inst_22840;
var limit = inst_22842;
var offset = inst_22844;
var map__22793 = inst_22839;
var k = inst_22838;
var compact_QMARK_ = inst_22797;
var pred_spec_SINGLEQUOTE_ = inst_22827;
var ref_QMARK_ = inst_22841;
return (function (p1__22784_SHARP_){
return p1__22784_SHARP_.o;
});
})();
var inst_23176 = cljs.core.mapv.call(null,inst_23175,flakes);
var inst_23177 = [inst_23176,offset_map];
var inst_23178 = (new cljs.core.PersistentVector(null,2,(5),inst_23174,inst_23177,null));
var state_23225__$1 = state_23225;
var statearr_23339_23535 = state_23225__$1;
(statearr_23339_23535[(2)] = inst_23178);

(statearr_23339_23535[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (17))){
var inst_22828 = (state_23225[(52)]);
var inst_22827 = (state_23225[(15)]);
var inst_22827__$1 = (state_23225[(2)]);
var inst_22828__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22827__$1);
var state_23225__$1 = (function (){var statearr_23340 = state_23225;
(statearr_23340[(52)] = inst_22828__$1);

(statearr_23340[(15)] = inst_22827__$1);

return statearr_23340;
})();
if(cljs.core.truth_(inst_22828__$1)){
var statearr_23341_23536 = state_23225__$1;
(statearr_23341_23536[(1)] = (18));

} else {
var statearr_23342_23537 = state_23225__$1;
(statearr_23342_23537[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (3))){
var inst_23223 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23225__$1,inst_23223);
} else {
if((state_val_23226 === (12))){
var inst_22812 = (state_23225[(42)]);
var inst_22817 = cljs.core.assoc.call(null,inst_22812,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_23225__$1 = state_23225;
var statearr_23343_23538 = state_23225__$1;
(statearr_23343_23538[(2)] = inst_22817);

(statearr_23343_23538[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (2))){
var inst_22798 = (state_23225[(11)]);
var _ = (function (){var statearr_23344 = state_23225;
(statearr_23344[(4)] = cljs.core.cons.call(null,(5),(state_23225[(4)])));

return statearr_23344;
})();
var inst_22797 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22798__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23225__$1 = (function (){var statearr_23345 = state_23225;
(statearr_23345[(35)] = inst_22797);

(statearr_23345[(11)] = inst_22798__$1);

return statearr_23345;
})();
if(cljs.core.truth_(inst_22798__$1)){
var statearr_23346_23539 = state_23225__$1;
(statearr_23346_23539[(1)] = (6));

} else {
var statearr_23347_23540 = state_23225__$1;
(statearr_23347_23540[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (66))){
var inst_22910 = (state_23225[(53)]);
var inst_22941 = (state_23225[(7)]);
var inst_22944 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22910,inst_22941);
var state_23225__$1 = state_23225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23225__$1,(69),inst_22944);
} else {
if((state_val_23226 === (107))){
var inst_23075 = (state_23225[(27)]);
var inst_23095 = cljs.core.count.call(null,inst_23075);
var inst_23096 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_23095);
var state_23225__$1 = state_23225;
var statearr_23348_23541 = state_23225__$1;
(statearr_23348_23541[(2)] = inst_23096);

(statearr_23348_23541[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (23))){
var inst_22836 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23349_23542 = state_23225__$1;
(statearr_23349_23542[(2)] = inst_22836);

(statearr_23349_23542[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (47))){
var inst_22883 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23350_23543 = state_23225__$1;
(statearr_23350_23543[(2)] = inst_22883);

(statearr_23350_23543[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (35))){
var inst_23194 = (state_23225[(50)]);
var inst_23193 = (state_23225[(2)]);
var inst_23194__$1 = cljs.core.nth.call(null,inst_23193,(0),null);
var inst_23195 = cljs.core.nth.call(null,inst_23193,(1),null);
var inst_23196 = cljs.core.empty_QMARK_.call(null,inst_23194__$1);
var state_23225__$1 = (function (){var statearr_23351 = state_23225;
(statearr_23351[(50)] = inst_23194__$1);

(statearr_23351[(10)] = inst_23195);

return statearr_23351;
})();
if(inst_23196){
var statearr_23352_23544 = state_23225__$1;
(statearr_23352_23544[(1)] = (128));

} else {
var statearr_23353_23545 = state_23225__$1;
(statearr_23353_23545[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (127))){
var inst_23181 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23354_23546 = state_23225__$1;
(statearr_23354_23546[(2)] = inst_23181);

(statearr_23354_23546[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (82))){
var inst_22988 = (state_23225[(30)]);
var state_23225__$1 = state_23225;
var statearr_23355_23547 = state_23225__$1;
(statearr_23355_23547[(2)] = inst_22988);

(statearr_23355_23547[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (76))){
var inst_22974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22982 = flakes;
var inst_22983 = cljs.core.seq.call(null,inst_22982);
var inst_22984 = cljs.core.first.call(null,inst_22983);
var inst_22985 = cljs.core.next.call(null,inst_22983);
var inst_22986 = cljs.core.PersistentVector.EMPTY;
var inst_22987 = inst_22982;
var inst_22988 = inst_22986;
var state_23225__$1 = (function (){var statearr_23356 = state_23225;
(statearr_23356[(45)] = inst_22987);

(statearr_23356[(30)] = inst_22988);

(statearr_23356[(54)] = inst_22974);

(statearr_23356[(55)] = inst_22985);

(statearr_23356[(56)] = inst_22984);

return statearr_23356;
})();
var statearr_23357_23548 = state_23225__$1;
(statearr_23357_23548[(2)] = null);

(statearr_23357_23548[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (97))){
var inst_23054 = (state_23225[(49)]);
var inst_23061 = (state_23225[(40)]);
var inst_23060 = cljs.core.seq.call(null,inst_23054);
var inst_23061__$1 = cljs.core.first.call(null,inst_23060);
var inst_23062 = cljs.core.next.call(null,inst_23060);
var state_23225__$1 = (function (){var statearr_23358 = state_23225;
(statearr_23358[(47)] = inst_23062);

(statearr_23358[(40)] = inst_23061__$1);

return statearr_23358;
})();
if(cljs.core.truth_(inst_23061__$1)){
var statearr_23359_23549 = state_23225__$1;
(statearr_23359_23549[(1)] = (99));

} else {
var statearr_23360_23550 = state_23225__$1;
(statearr_23360_23550[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (19))){
var inst_22831 = (state_23225[(41)]);
var inst_22827 = (state_23225[(15)]);
var inst_22831__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22827);
var state_23225__$1 = (function (){var statearr_23361 = state_23225;
(statearr_23361[(41)] = inst_22831__$1);

return statearr_23361;
})();
if(cljs.core.truth_(inst_22831__$1)){
var statearr_23362_23551 = state_23225__$1;
(statearr_23362_23551[(1)] = (21));

} else {
var statearr_23363_23552 = state_23225__$1;
(statearr_23363_23552[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (57))){
var inst_22827 = (state_23225[(15)]);
var inst_22907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22908 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22909 = (new cljs.core.PersistentVector(null,3,(5),inst_22907,inst_22908,null));
var inst_22910 = cljs.core.select_keys.call(null,inst_22827,inst_22909);
var inst_22911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22919 = flakes;
var inst_22920 = cljs.core.seq.call(null,inst_22919);
var inst_22921 = cljs.core.first.call(null,inst_22920);
var inst_22922 = cljs.core.next.call(null,inst_22920);
var inst_22923 = cljs.core.PersistentVector.EMPTY;
var inst_22924 = inst_22919;
var inst_22925 = inst_22923;
var state_23225__$1 = (function (){var statearr_23364 = state_23225;
(statearr_23364[(9)] = inst_22925);

(statearr_23364[(57)] = inst_22921);

(statearr_23364[(53)] = inst_22910);

(statearr_23364[(24)] = inst_22924);

(statearr_23364[(51)] = inst_22911);

(statearr_23364[(58)] = inst_22922);

return statearr_23364;
})();
var statearr_23365_23553 = state_23225__$1;
(statearr_23365_23553[(2)] = null);

(statearr_23365_23553[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (68))){
var inst_22950 = (state_23225[(2)]);
var state_23225__$1 = (function (){var statearr_23366 = state_23225;
(statearr_23366[(22)] = inst_22950);

return statearr_23366;
})();
if(cljs.core.truth_(fuel)){
var statearr_23367_23554 = state_23225__$1;
(statearr_23367_23554[(1)] = (70));

} else {
var statearr_23368_23555 = state_23225__$1;
(statearr_23368_23555[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (11))){
var inst_22812 = (state_23225[(42)]);
var inst_22812__$1 = (state_23225[(2)]);
var inst_22814 = cljs.core.contains_QMARK_.call(null,inst_22812__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22815 = (!(inst_22814));
var state_23225__$1 = (function (){var statearr_23369 = state_23225;
(statearr_23369[(42)] = inst_22812__$1);

return statearr_23369;
})();
if(inst_22815){
var statearr_23370_23556 = state_23225__$1;
(statearr_23370_23556[(1)] = (12));

} else {
var statearr_23371_23557 = state_23225__$1;
(statearr_23371_23557[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (115))){
var inst_23171 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23373_23558 = state_23225__$1;
(statearr_23373_23558[(2)] = inst_23171);

(statearr_23373_23558[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (9))){
var inst_22806 = cljs.core.first.call(null,flakes);
var inst_22807 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22806);
var inst_22808 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22809 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_22807,inst_22808);
var state_23225__$1 = state_23225;
var statearr_23374_23559 = state_23225__$1;
(statearr_23374_23559[(2)] = inst_22809);

(statearr_23374_23559[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (5))){
var _ = (function (){var statearr_23375 = state_23225;
(statearr_23375[(4)] = cljs.core.rest.call(null,(state_23225[(4)])));

return statearr_23375;
})();
var state_23225__$1 = state_23225;
var ex23372 = (state_23225__$1[(2)]);
var statearr_23376_23560 = state_23225__$1;
(statearr_23376_23560[(5)] = ex23372);


if((ex23372 instanceof Error)){
var statearr_23377_23561 = state_23225__$1;
(statearr_23377_23561[(1)] = (4));

(statearr_23377_23561[(5)] = null);

} else {
throw ex23372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (112))){
var inst_23183 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23378_23562 = state_23225__$1;
(statearr_23378_23562[(2)] = inst_23183);

(statearr_23378_23562[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (83))){
var inst_23028 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23379_23563 = state_23225__$1;
(statearr_23379_23563[(2)] = inst_23028);

(statearr_23379_23563[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (14))){
var inst_22812 = (state_23225[(42)]);
var inst_22820 = (state_23225[(2)]);
var inst_22821 = cljs.core.contains_QMARK_.call(null,inst_22812,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22822 = (!(inst_22821));
var state_23225__$1 = (function (){var statearr_23380 = state_23225;
(statearr_23380[(36)] = inst_22820);

return statearr_23380;
})();
if(inst_22822){
var statearr_23381_23564 = state_23225__$1;
(statearr_23381_23564[(1)] = (15));

} else {
var statearr_23382_23565 = state_23225__$1;
(statearr_23382_23565[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (45))){
var inst_22838 = (state_23225[(16)]);
var inst_22842 = (state_23225[(18)]);
var inst_22878 = cljs.core.get.call(null,acc,inst_22838);
var inst_22879 = cljs.core.count.call(null,inst_22878);
var inst_22880 = (inst_22879 >= inst_22842);
var state_23225__$1 = state_23225;
var statearr_23383_23566 = state_23225__$1;
(statearr_23383_23566[(2)] = inst_22880);

(statearr_23383_23566[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (53))){
var inst_22905 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22905)){
var statearr_23384_23567 = state_23225__$1;
(statearr_23384_23567[(1)] = (57));

} else {
var statearr_23385_23568 = state_23225__$1;
(statearr_23385_23568[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (78))){
var inst_23187 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23386_23569 = state_23225__$1;
(statearr_23386_23569[(2)] = inst_23187);

(statearr_23386_23569[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (132))){
var state_23225__$1 = state_23225;
var statearr_23388_23570 = state_23225__$1;
(statearr_23388_23570[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (26))){
var inst_22860 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22860)){
var statearr_23390_23571 = state_23225__$1;
(statearr_23390_23571[(1)] = (33));

} else {
var statearr_23391_23572 = state_23225__$1;
(statearr_23391_23572[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (123))){
var inst_23133 = (state_23225[(33)]);
var inst_23140 = (state_23225[(39)]);
var tmp23387 = inst_23133;
var inst_23132 = inst_23140;
var inst_23133__$1 = tmp23387;
var state_23225__$1 = (function (){var statearr_23392 = state_23225;
(statearr_23392[(33)] = inst_23133__$1);

(statearr_23392[(38)] = inst_23132);

return statearr_23392;
})();
var statearr_23393_23573 = state_23225__$1;
(statearr_23393_23573[(2)] = null);

(statearr_23393_23573[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (16))){
var inst_22820 = (state_23225[(36)]);
var state_23225__$1 = state_23225;
var statearr_23394_23574 = state_23225__$1;
(statearr_23394_23574[(2)] = inst_22820);

(statearr_23394_23574[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (133))){
var inst_23218 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23395_23575 = state_23225__$1;
(statearr_23395_23575[(2)] = inst_23218);

(statearr_23395_23575[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (81))){
var inst_22994 = (state_23225[(28)]);
var inst_22827 = (state_23225[(15)]);
var inst_23003 = (state_23225[(59)]);
var inst_22997 = cljs.core.deref.call(null,cache);
var inst_22998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22999 = inst_22994.o;
var inst_23000 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22827);
var inst_23001 = [inst_22999,inst_23000];
var inst_23002 = (new cljs.core.PersistentVector(null,2,(5),inst_22998,inst_23001,null));
var inst_23003__$1 = cljs.core.get.call(null,inst_22997,inst_23002);
var state_23225__$1 = (function (){var statearr_23396 = state_23225;
(statearr_23396[(59)] = inst_23003__$1);

return statearr_23396;
})();
if(cljs.core.truth_(inst_23003__$1)){
var statearr_23397_23576 = state_23225__$1;
(statearr_23397_23576[(1)] = (84));

} else {
var statearr_23398_23577 = state_23225__$1;
(statearr_23398_23577[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (120))){
var inst_23167 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23399_23578 = state_23225__$1;
(statearr_23399_23578[(2)] = inst_23167);

(statearr_23399_23578[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (79))){
var inst_22987 = (state_23225[(45)]);
var inst_22994 = (state_23225[(28)]);
var inst_22993 = cljs.core.seq.call(null,inst_22987);
var inst_22994__$1 = cljs.core.first.call(null,inst_22993);
var inst_22995 = cljs.core.next.call(null,inst_22993);
var state_23225__$1 = (function (){var statearr_23400 = state_23225;
(statearr_23400[(44)] = inst_22995);

(statearr_23400[(28)] = inst_22994__$1);

return statearr_23400;
})();
if(cljs.core.truth_(inst_22994__$1)){
var statearr_23401_23579 = state_23225__$1;
(statearr_23401_23579[(1)] = (81));

} else {
var statearr_23402_23580 = state_23225__$1;
(statearr_23402_23580[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (38))){
var inst_22862 = (state_23225[(43)]);
var inst_22870 = (state_23225[(2)]);
var inst_22871 = [null,inst_22870];
var inst_22872 = (new cljs.core.PersistentVector(null,2,(5),inst_22862,inst_22871,null));
var state_23225__$1 = state_23225;
var statearr_23403_23581 = state_23225__$1;
(statearr_23403_23581[(2)] = inst_22872);

(statearr_23403_23581[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (126))){
var state_23225__$1 = state_23225;
var statearr_23404_23582 = state_23225__$1;
(statearr_23404_23582[(2)] = null);

(statearr_23404_23582[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (98))){
var inst_23041 = (state_23225[(60)]);
var inst_23105 = (state_23225[(2)]);
var inst_23106 = [inst_23105,offset_map];
var inst_23107 = (new cljs.core.PersistentVector(null,2,(5),inst_23041,inst_23106,null));
var state_23225__$1 = state_23225;
var statearr_23405_23583 = state_23225__$1;
(statearr_23405_23583[(2)] = inst_23107);

(statearr_23405_23583[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (124))){
var inst_23161 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23406_23584 = state_23225__$1;
(statearr_23406_23584[(2)] = inst_23161);

(statearr_23406_23584[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (87))){
var inst_22994 = (state_23225[(28)]);
var inst_22827 = (state_23225[(15)]);
var inst_23010 = (state_23225[(2)]);
var inst_23011 = fluree.db.util.async.throw_err.call(null,inst_23010);
var inst_23012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23013 = inst_22994.o;
var inst_23014 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22827);
var inst_23015 = [inst_23013,inst_23014];
var inst_23016 = (new cljs.core.PersistentVector(null,2,(5),inst_23012,inst_23015,null));
var inst_23017 = fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_23016,inst_23011);
var state_23225__$1 = (function (){var statearr_23407 = state_23225;
(statearr_23407[(61)] = inst_23017);

return statearr_23407;
})();
var statearr_23408_23585 = state_23225__$1;
(statearr_23408_23585[(2)] = inst_23011);

(statearr_23408_23585[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (30))){
var inst_22845 = (state_23225[(19)]);
var inst_22850 = cljs.core.get.call(null,offset_map,inst_22845);
var inst_22851 = cljs.core.not_EQ_.call(null,(0),inst_22850);
var state_23225__$1 = state_23225;
var statearr_23409_23586 = state_23225__$1;
(statearr_23409_23586[(2)] = inst_22851);

(statearr_23409_23586[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (73))){
var inst_22925 = (state_23225[(9)]);
var inst_22950 = (state_23225[(22)]);
var inst_22959 = cljs.core.conj.call(null,inst_22925,inst_22950);
var state_23225__$1 = state_23225;
var statearr_23410_23587 = state_23225__$1;
(statearr_23410_23587[(2)] = inst_22959);

(statearr_23410_23587[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (96))){
var inst_23185 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
var statearr_23411_23588 = state_23225__$1;
(statearr_23411_23588[(2)] = inst_23185);

(statearr_23411_23588[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (10))){
var state_23225__$1 = state_23225;
var statearr_23412_23589 = state_23225__$1;
(statearr_23412_23589[(2)] = pred_spec);

(statearr_23412_23589[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (18))){
var inst_22828 = (state_23225[(52)]);
var state_23225__$1 = state_23225;
var statearr_23413_23590 = state_23225__$1;
(statearr_23413_23590[(2)] = inst_22828);

(statearr_23413_23590[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (105))){
var inst_23093 = (state_23225[(2)]);
var state_23225__$1 = (function (){var statearr_23414 = state_23225;
(statearr_23414[(46)] = inst_23093);

return statearr_23414;
})();
if(cljs.core.truth_(fuel)){
var statearr_23415_23591 = state_23225__$1;
(statearr_23415_23591[(1)] = (107));

} else {
var statearr_23416_23592 = state_23225__$1;
(statearr_23416_23592[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (52))){
var inst_22895 = (state_23225[(62)]);
var state_23225__$1 = state_23225;
var statearr_23417_23593 = state_23225__$1;
(statearr_23417_23593[(2)] = inst_22895);

(statearr_23417_23593[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (114))){
var inst_23127 = flakes;
var inst_23128 = cljs.core.seq.call(null,inst_23127);
var inst_23129 = cljs.core.first.call(null,inst_23128);
var inst_23130 = cljs.core.next.call(null,inst_23128);
var inst_23131 = cljs.core.PersistentVector.EMPTY;
var inst_23132 = inst_23127;
var inst_23133 = inst_23131;
var state_23225__$1 = (function (){var statearr_23418 = state_23225;
(statearr_23418[(63)] = inst_23130);

(statearr_23418[(33)] = inst_23133);

(statearr_23418[(38)] = inst_23132);

(statearr_23418[(64)] = inst_23129);

return statearr_23418;
})();
var statearr_23419_23594 = state_23225__$1;
(statearr_23419_23594[(2)] = null);

(statearr_23419_23594[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (67))){
var state_23225__$1 = state_23225;
var statearr_23420_23595 = state_23225__$1;
(statearr_23420_23595[(2)] = null);

(statearr_23420_23595[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (71))){
var state_23225__$1 = state_23225;
var statearr_23421_23596 = state_23225__$1;
(statearr_23421_23596[(2)] = null);

(statearr_23421_23596[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (42))){
var inst_22842 = (state_23225[(18)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22842)){
var statearr_23422_23597 = state_23225__$1;
(statearr_23422_23597[(1)] = (45));

} else {
var statearr_23423_23598 = state_23225__$1;
(statearr_23423_23598[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (80))){
var inst_22974 = (state_23225[(54)]);
var inst_23030 = (state_23225[(2)]);
var inst_23031 = [inst_23030,offset_map];
var inst_23032 = (new cljs.core.PersistentVector(null,2,(5),inst_22974,inst_23031,null));
var state_23225__$1 = state_23225;
var statearr_23424_23599 = state_23225__$1;
(statearr_23424_23599[(2)] = inst_23032);

(statearr_23424_23599[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (37))){
var inst_22845 = (state_23225[(19)]);
var inst_22844 = (state_23225[(21)]);
var inst_22867 = (inst_22844 - (1));
var inst_22868 = cljs.core.assoc.call(null,offset_map,inst_22845,inst_22867);
var state_23225__$1 = state_23225;
var statearr_23425_23600 = state_23225__$1;
(statearr_23425_23600[(2)] = inst_22868);

(statearr_23425_23600[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (63))){
var inst_22925 = (state_23225[(9)]);
var state_23225__$1 = state_23225;
var statearr_23426_23601 = state_23225__$1;
(statearr_23426_23601[(2)] = inst_22925);

(statearr_23426_23601[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (94))){
var inst_23041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23049 = flakes;
var inst_23050 = cljs.core.seq.call(null,inst_23049);
var inst_23051 = cljs.core.first.call(null,inst_23050);
var inst_23052 = cljs.core.next.call(null,inst_23050);
var inst_23053 = cljs.core.PersistentVector.EMPTY;
var inst_23054 = inst_23049;
var inst_23055 = inst_23053;
var state_23225__$1 = (function (){var statearr_23427 = state_23225;
(statearr_23427[(49)] = inst_23054);

(statearr_23427[(32)] = inst_23055);

(statearr_23427[(60)] = inst_23041);

(statearr_23427[(65)] = inst_23051);

(statearr_23427[(66)] = inst_23052);

return statearr_23427;
})();
var statearr_23428_23602 = state_23225__$1;
(statearr_23428_23602[(2)] = null);

(statearr_23428_23602[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (8))){
var inst_22804 = (state_23225[(2)]);
var state_23225__$1 = state_23225;
if(cljs.core.truth_(inst_22804)){
var statearr_23429_23603 = state_23225__$1;
(statearr_23429_23603[(1)] = (9));

} else {
var statearr_23430_23604 = state_23225__$1;
(statearr_23430_23604[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (49))){
var inst_22895 = (state_23225[(62)]);
var inst_22895__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_23225__$1 = (function (){var statearr_23431 = state_23225;
(statearr_23431[(62)] = inst_22895__$1);

return statearr_23431;
})();
if(inst_22895__$1){
var statearr_23432_23605 = state_23225__$1;
(statearr_23432_23605[(1)] = (51));

} else {
var statearr_23433_23606 = state_23225__$1;
(statearr_23433_23606[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23226 === (84))){
var inst_23003 = (state_23225[(59)]);
var state_23225__$1 = state_23225;
var statearr_23434_23607 = state_23225__$1;
(statearr_23434_23607[(2)] = inst_23003);

(statearr_23434_23607[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2703__auto__ = null;
var fluree$db$query$fql$state_machine__2703__auto____0 = (function (){
var statearr_23435 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23435[(0)] = fluree$db$query$fql$state_machine__2703__auto__);

(statearr_23435[(1)] = (1));

return statearr_23435;
});
var fluree$db$query$fql$state_machine__2703__auto____1 = (function (state_23225){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_23225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e23436){var ex__2706__auto__ = e23436;
var statearr_23437_23608 = state_23225;
(statearr_23437_23608[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_23225[(4)]))){
var statearr_23438_23609 = state_23225;
(statearr_23438_23609[(1)] = cljs.core.first.call(null,(state_23225[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23610 = state_23225;
state_23225 = G__23610;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2703__auto__ = function(state_23225){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2703__auto____1.call(this,state_23225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2703__auto____0;
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2703__auto____1;
return fluree$db$query$fql$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_23439 = f__2726__auto__.call(null);
(statearr_23439[(6)] = c__2725__auto__);

return statearr_23439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_23770){
var state_val_23771 = (state_23770[(1)]);
if((state_val_23771 === (7))){
var inst_23765 = (state_23770[(2)]);
var _ = (function (){var statearr_23772 = state_23770;
(statearr_23772[(4)] = cljs.core.rest.call(null,(state_23770[(4)])));

return statearr_23772;
})();
var state_23770__$1 = state_23770;
var statearr_23773_23855 = state_23770__$1;
(statearr_23773_23855[(2)] = inst_23765);

(statearr_23773_23855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (20))){
var inst_23692 = (state_23770[(7)]);
var state_23770__$1 = state_23770;
var statearr_23774_23856 = state_23770__$1;
(statearr_23774_23856[(2)] = inst_23692);

(statearr_23774_23856[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (27))){
var inst_23647 = (state_23770[(8)]);
var state_23770__$1 = state_23770;
if(cljs.core.truth_(inst_23647)){
var statearr_23775_23857 = state_23770__$1;
(statearr_23775_23857[(1)] = (29));

} else {
var statearr_23776_23858 = state_23770__$1;
(statearr_23776_23858[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (1))){
var state_23770__$1 = state_23770;
var statearr_23777_23859 = state_23770__$1;
(statearr_23777_23859[(2)] = null);

(statearr_23777_23859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (24))){
var inst_23648 = (state_23770[(9)]);
var state_23770__$1 = state_23770;
var statearr_23778_23860 = state_23770__$1;
(statearr_23778_23860[(2)] = inst_23648);

(statearr_23778_23860[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (39))){
var inst_23684 = (state_23770[(10)]);
var state_23770__$1 = state_23770;
var statearr_23779_23861 = state_23770__$1;
(statearr_23779_23861[(2)] = inst_23684);

(statearr_23779_23861[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (46))){
var inst_23649 = (state_23770[(11)]);
var state_23770__$1 = state_23770;
var statearr_23780_23862 = state_23770__$1;
(statearr_23780_23862[(2)] = inst_23649);

(statearr_23780_23862[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (4))){
var inst_23611 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
var statearr_23781_23863 = state_23770__$1;
(statearr_23781_23863[(2)] = inst_23611);

(statearr_23781_23863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (15))){
var inst_23660 = (state_23770[(12)]);
var inst_23666 = cljs.core.count.call(null,inst_23660);
var inst_23667 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_23666,max_fuel);
var state_23770__$1 = state_23770;
var statearr_23782_23864 = state_23770__$1;
(statearr_23782_23864[(2)] = inst_23667);

(statearr_23782_23864[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (48))){
var inst_23751 = (state_23770[(13)]);
var inst_23636 = (state_23770[(14)]);
var inst_23629 = (state_23770[(15)]);
var inst_23759 = (state_23770[(2)]);
var inst_23760 = cljs.core.assoc.call(null,inst_23629,inst_23759,inst_23751);
var inst_23628 = inst_23636;
var inst_23629__$1 = inst_23760;
var state_23770__$1 = (function (){var statearr_23783 = state_23770;
(statearr_23783[(16)] = inst_23628);

(statearr_23783[(15)] = inst_23629__$1);

return statearr_23783;
})();
var statearr_23784_23865 = state_23770__$1;
(statearr_23784_23865[(2)] = null);

(statearr_23784_23865[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (50))){
var inst_23651 = (state_23770[(17)]);
var state_23770__$1 = state_23770;
var statearr_23785_23866 = state_23770__$1;
(statearr_23785_23866[(2)] = inst_23651);

(statearr_23785_23866[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (21))){
var inst_23648 = (state_23770[(9)]);
var state_23770__$1 = state_23770;
if(cljs.core.truth_(inst_23648)){
var statearr_23787_23867 = state_23770__$1;
(statearr_23787_23867[(1)] = (23));

} else {
var statearr_23788_23868 = state_23770__$1;
(statearr_23788_23868[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (31))){
var inst_23708 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
if(cljs.core.truth_(inst_23708)){
var statearr_23789_23869 = state_23770__$1;
(statearr_23789_23869[(1)] = (32));

} else {
var statearr_23790_23870 = state_23770__$1;
(statearr_23790_23870[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (32))){
var inst_23691 = (state_23770[(18)]);
var inst_23684 = (state_23770[(10)]);
var inst_23683 = (state_23770[(19)]);
var inst_23710 = (inst_23683 + (1));
var tmp23786 = inst_23684;
var inst_23682 = inst_23691;
var inst_23683__$1 = inst_23710;
var inst_23684__$1 = tmp23786;
var state_23770__$1 = (function (){var statearr_23791 = state_23770;
(statearr_23791[(20)] = inst_23682);

(statearr_23791[(10)] = inst_23684__$1);

(statearr_23791[(19)] = inst_23683__$1);

return statearr_23791;
})();
var statearr_23792_23871 = state_23770__$1;
(statearr_23792_23871[(2)] = null);

(statearr_23792_23871[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (40))){
var state_23770__$1 = state_23770;
if(cljs.core.truth_(fuel)){
var statearr_23793_23872 = state_23770__$1;
(statearr_23793_23872[(1)] = (42));

} else {
var statearr_23794_23873 = state_23770__$1;
(statearr_23794_23873[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (33))){
var state_23770__$1 = state_23770;
var statearr_23795_23874 = state_23770__$1;
(statearr_23795_23874[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (13))){
var inst_23660 = (state_23770[(12)]);
var state_23770__$1 = state_23770;
var statearr_23797_23875 = state_23770__$1;
(statearr_23797_23875[(2)] = inst_23660);

(statearr_23797_23875[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (22))){
var inst_23701 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
if(cljs.core.truth_(inst_23701)){
var statearr_23798_23876 = state_23770__$1;
(statearr_23798_23876[(1)] = (26));

} else {
var statearr_23799_23877 = state_23770__$1;
(statearr_23799_23877[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (36))){
var state_23770__$1 = state_23770;
var statearr_23800_23878 = state_23770__$1;
(statearr_23800_23878[(2)] = null);

(statearr_23800_23878[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (41))){
var inst_23691 = (state_23770[(18)]);
var inst_23683 = (state_23770[(19)]);
var inst_23740 = (state_23770[(2)]);
var inst_23741 = (inst_23683 + (1));
var inst_23682 = inst_23691;
var inst_23683__$1 = inst_23741;
var inst_23684 = inst_23740;
var state_23770__$1 = (function (){var statearr_23801 = state_23770;
(statearr_23801[(20)] = inst_23682);

(statearr_23801[(10)] = inst_23684);

(statearr_23801[(19)] = inst_23683__$1);

return statearr_23801;
})();
var statearr_23802_23879 = state_23770__$1;
(statearr_23802_23879[(2)] = null);

(statearr_23802_23879[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (43))){
var state_23770__$1 = state_23770;
var statearr_23803_23880 = state_23770__$1;
(statearr_23803_23880[(2)] = null);

(statearr_23803_23880[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (29))){
var inst_23647 = (state_23770[(8)]);
var inst_23683 = (state_23770[(19)]);
var inst_23705 = (inst_23683 < inst_23647);
var state_23770__$1 = state_23770;
var statearr_23804_23881 = state_23770__$1;
(statearr_23804_23881[(2)] = inst_23705);

(statearr_23804_23881[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (44))){
var inst_23724 = (state_23770[(21)]);
var inst_23720 = (state_23770[(22)]);
var inst_23733 = (state_23770[(2)]);
var inst_23734 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23724,inst_23720);
var state_23770__$1 = (function (){var statearr_23805 = state_23770;
(statearr_23805[(23)] = inst_23733);

return statearr_23805;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23770__$1,(45),inst_23734);
} else {
if((state_val_23771 === (6))){
var inst_23628 = (state_23770[(16)]);
var inst_23635 = (state_23770[(24)]);
var inst_23634 = cljs.core.seq.call(null,inst_23628);
var inst_23635__$1 = cljs.core.first.call(null,inst_23634);
var inst_23636 = cljs.core.next.call(null,inst_23634);
var inst_23637 = cljs.core.not.call(null,inst_23635__$1);
var state_23770__$1 = (function (){var statearr_23806 = state_23770;
(statearr_23806[(14)] = inst_23636);

(statearr_23806[(24)] = inst_23635__$1);

return statearr_23806;
})();
if(inst_23637){
var statearr_23807_23882 = state_23770__$1;
(statearr_23807_23882[(1)] = (8));

} else {
var statearr_23808_23883 = state_23770__$1;
(statearr_23808_23883[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (28))){
var inst_23749 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
var statearr_23809_23884 = state_23770__$1;
(statearr_23809_23884[(2)] = inst_23749);

(statearr_23809_23884[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (51))){
var inst_23757 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
var statearr_23810_23885 = state_23770__$1;
(statearr_23810_23885[(2)] = inst_23757);

(statearr_23810_23885[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (25))){
var inst_23699 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
var statearr_23811_23886 = state_23770__$1;
(statearr_23811_23886[(2)] = inst_23699);

(statearr_23811_23886[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (34))){
var inst_23747 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
var statearr_23812_23887 = state_23770__$1;
(statearr_23812_23887[(2)] = inst_23747);

(statearr_23812_23887[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (17))){
var inst_23660 = (state_23770[(12)]);
var inst_23670 = (state_23770[(2)]);
var inst_23678 = cljs.core.seq.call(null,inst_23660);
var inst_23679 = cljs.core.first.call(null,inst_23678);
var inst_23680 = cljs.core.next.call(null,inst_23678);
var inst_23681 = cljs.core.PersistentVector.EMPTY;
var inst_23682 = inst_23660;
var inst_23683 = (0);
var inst_23684 = inst_23681;
var state_23770__$1 = (function (){var statearr_23813 = state_23770;
(statearr_23813[(25)] = inst_23679);

(statearr_23813[(26)] = inst_23670);

(statearr_23813[(20)] = inst_23682);

(statearr_23813[(10)] = inst_23684);

(statearr_23813[(27)] = inst_23680);

(statearr_23813[(19)] = inst_23683);

return statearr_23813;
})();
var statearr_23814_23888 = state_23770__$1;
(statearr_23814_23888[(2)] = null);

(statearr_23814_23888[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (3))){
var inst_23768 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23770__$1,inst_23768);
} else {
if((state_val_23771 === (12))){
var state_23770__$1 = state_23770;
var statearr_23815_23889 = state_23770__$1;
(statearr_23815_23889[(2)] = fuel);

(statearr_23815_23889[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (2))){
var _ = (function (){var statearr_23816 = state_23770;
(statearr_23816[(4)] = cljs.core.cons.call(null,(5),(state_23770[(4)])));

return statearr_23816;
})();
var inst_23624 = reverse_refs_specs;
var inst_23625 = cljs.core.seq.call(null,inst_23624);
var inst_23626 = cljs.core.first.call(null,inst_23625);
var inst_23627 = cljs.core.next.call(null,inst_23625);
var inst_23628 = inst_23624;
var inst_23629 = null;
var state_23770__$1 = (function (){var statearr_23817 = state_23770;
(statearr_23817[(16)] = inst_23628);

(statearr_23817[(28)] = inst_23626);

(statearr_23817[(29)] = inst_23627);

(statearr_23817[(15)] = inst_23629);

return statearr_23817;
})();
var statearr_23818_23890 = state_23770__$1;
(statearr_23818_23890[(2)] = null);

(statearr_23818_23890[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (23))){
var inst_23648 = (state_23770[(9)]);
var inst_23683 = (state_23770[(19)]);
var inst_23696 = (inst_23683 >= inst_23648);
var state_23770__$1 = state_23770;
var statearr_23819_23891 = state_23770__$1;
(statearr_23819_23891[(2)] = inst_23696);

(statearr_23819_23891[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (47))){
var inst_23650 = (state_23770[(30)]);
var state_23770__$1 = state_23770;
if(cljs.core.truth_(inst_23650)){
var statearr_23820_23892 = state_23770__$1;
(statearr_23820_23892[(1)] = (49));

} else {
var statearr_23821_23893 = state_23770__$1;
(statearr_23821_23893[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (35))){
var inst_23690 = (state_23770[(31)]);
var inst_23714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23715 = [inst_23690];
var inst_23716 = (new cljs.core.PersistentVector(null,1,(5),inst_23714,inst_23715,null));
var inst_23717 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23716);
var state_23770__$1 = state_23770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23770__$1,(38),inst_23717);
} else {
if((state_val_23771 === (19))){
var inst_23649 = (state_23770[(11)]);
var inst_23751 = (state_23770[(2)]);
var state_23770__$1 = (function (){var statearr_23822 = state_23770;
(statearr_23822[(13)] = inst_23751);

return statearr_23822;
})();
if(cljs.core.truth_(inst_23649)){
var statearr_23823_23894 = state_23770__$1;
(statearr_23823_23894[(1)] = (46));

} else {
var statearr_23824_23895 = state_23770__$1;
(statearr_23824_23895[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (11))){
var inst_23660 = (state_23770[(12)]);
var inst_23657 = (state_23770[(2)]);
var inst_23658 = fluree.db.util.async.throw_err.call(null,inst_23657);
var inst_23659 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_23658);
var inst_23660__$1 = cljs.core.not_empty.call(null,inst_23659);
var state_23770__$1 = (function (){var statearr_23826 = state_23770;
(statearr_23826[(12)] = inst_23660__$1);

return statearr_23826;
})();
if(cljs.core.truth_(inst_23660__$1)){
var statearr_23827_23896 = state_23770__$1;
(statearr_23827_23896[(1)] = (12));

} else {
var statearr_23828_23897 = state_23770__$1;
(statearr_23828_23897[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (9))){
var inst_23645 = (state_23770[(32)]);
var inst_23635 = (state_23770[(24)]);
var inst_23644 = cljs.core.nth.call(null,inst_23635,(0),null);
var inst_23645__$1 = cljs.core.nth.call(null,inst_23635,(1),null);
var inst_23646 = cljs.core.__destructure_map.call(null,inst_23645__$1);
var inst_23647 = cljs.core.get.call(null,inst_23646,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23648 = cljs.core.get.call(null,inst_23646,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23649 = cljs.core.get.call(null,inst_23646,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23650 = cljs.core.get.call(null,inst_23646,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_23651 = cljs.core.get.call(null,inst_23646,new cljs.core.Keyword(null,"p","p",151049309));
var inst_23652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23653 = [subject_id,inst_23644];
var inst_23654 = (new cljs.core.PersistentVector(null,2,(5),inst_23652,inst_23653,null));
var inst_23655 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_23654);
var state_23770__$1 = (function (){var statearr_23829 = state_23770;
(statearr_23829[(8)] = inst_23647);

(statearr_23829[(32)] = inst_23645__$1);

(statearr_23829[(17)] = inst_23651);

(statearr_23829[(11)] = inst_23649);

(statearr_23829[(30)] = inst_23650);

(statearr_23829[(9)] = inst_23648);

return statearr_23829;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23770__$1,(11),inst_23655);
} else {
if((state_val_23771 === (5))){
var _ = (function (){var statearr_23830 = state_23770;
(statearr_23830[(4)] = cljs.core.rest.call(null,(state_23770[(4)])));

return statearr_23830;
})();
var state_23770__$1 = state_23770;
var ex23825 = (state_23770__$1[(2)]);
var statearr_23831_23898 = state_23770__$1;
(statearr_23831_23898[(5)] = ex23825);


if((ex23825 instanceof Error)){
var statearr_23832_23899 = state_23770__$1;
(statearr_23832_23899[(1)] = (4));

(statearr_23832_23899[(5)] = null);

} else {
throw ex23825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (14))){
var inst_23664 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
if(cljs.core.truth_(inst_23664)){
var statearr_23833_23900 = state_23770__$1;
(statearr_23833_23900[(1)] = (15));

} else {
var statearr_23834_23901 = state_23770__$1;
(statearr_23834_23901[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (45))){
var inst_23684 = (state_23770[(10)]);
var inst_23736 = (state_23770[(2)]);
var inst_23737 = fluree.db.util.async.throw_err.call(null,inst_23736);
var inst_23738 = cljs.core.conj.call(null,inst_23684,inst_23737);
var state_23770__$1 = state_23770;
var statearr_23835_23902 = state_23770__$1;
(statearr_23835_23902[(2)] = inst_23738);

(statearr_23835_23902[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (26))){
var inst_23684 = (state_23770[(10)]);
var state_23770__$1 = state_23770;
var statearr_23836_23903 = state_23770__$1;
(statearr_23836_23903[(2)] = inst_23684);

(statearr_23836_23903[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (16))){
var state_23770__$1 = state_23770;
var statearr_23837_23904 = state_23770__$1;
(statearr_23837_23904[(2)] = null);

(statearr_23837_23904[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (38))){
var inst_23645 = (state_23770[(32)]);
var inst_23720 = (state_23770[(22)]);
var inst_23719 = (state_23770[(2)]);
var inst_23720__$1 = fluree.db.util.async.throw_err.call(null,inst_23719);
var inst_23721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23722 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23723 = (new cljs.core.PersistentVector(null,4,(5),inst_23721,inst_23722,null));
var inst_23724 = cljs.core.select_keys.call(null,inst_23645,inst_23723);
var inst_23725 = cljs.core.empty_QMARK_.call(null,inst_23720__$1);
var state_23770__$1 = (function (){var statearr_23838 = state_23770;
(statearr_23838[(21)] = inst_23724);

(statearr_23838[(22)] = inst_23720__$1);

return statearr_23838;
})();
if(inst_23725){
var statearr_23839_23905 = state_23770__$1;
(statearr_23839_23905[(1)] = (39));

} else {
var statearr_23840_23906 = state_23770__$1;
(statearr_23840_23906[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (30))){
var inst_23647 = (state_23770[(8)]);
var state_23770__$1 = state_23770;
var statearr_23841_23907 = state_23770__$1;
(statearr_23841_23907[(2)] = inst_23647);

(statearr_23841_23907[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (10))){
var inst_23763 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
var statearr_23842_23908 = state_23770__$1;
(statearr_23842_23908[(2)] = inst_23763);

(statearr_23842_23908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (18))){
var inst_23690 = (state_23770[(31)]);
var inst_23682 = (state_23770[(20)]);
var inst_23692 = (state_23770[(7)]);
var inst_23689 = cljs.core.seq.call(null,inst_23682);
var inst_23690__$1 = cljs.core.first.call(null,inst_23689);
var inst_23691 = cljs.core.next.call(null,inst_23689);
var inst_23692__$1 = cljs.core.not.call(null,inst_23690__$1);
var state_23770__$1 = (function (){var statearr_23843 = state_23770;
(statearr_23843[(18)] = inst_23691);

(statearr_23843[(31)] = inst_23690__$1);

(statearr_23843[(7)] = inst_23692__$1);

return statearr_23843;
})();
if(inst_23692__$1){
var statearr_23844_23909 = state_23770__$1;
(statearr_23844_23909[(1)] = (20));

} else {
var statearr_23845_23910 = state_23770__$1;
(statearr_23845_23910[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (42))){
var inst_23720 = (state_23770[(22)]);
var inst_23729 = cljs.core.count.call(null,inst_23720);
var inst_23730 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_23729,max_fuel);
var state_23770__$1 = state_23770;
var statearr_23846_23911 = state_23770__$1;
(statearr_23846_23911[(2)] = inst_23730);

(statearr_23846_23911[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (37))){
var inst_23745 = (state_23770[(2)]);
var state_23770__$1 = state_23770;
var statearr_23847_23912 = state_23770__$1;
(statearr_23847_23912[(2)] = inst_23745);

(statearr_23847_23912[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (8))){
var inst_23629 = (state_23770[(15)]);
var state_23770__$1 = state_23770;
var statearr_23848_23913 = state_23770__$1;
(statearr_23848_23913[(2)] = inst_23629);

(statearr_23848_23913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23771 === (49))){
var inst_23650 = (state_23770[(30)]);
var state_23770__$1 = state_23770;
var statearr_23849_23914 = state_23770__$1;
(statearr_23849_23914[(2)] = inst_23650);

(statearr_23849_23914[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto____0 = (function (){
var statearr_23850 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23850[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto__);

(statearr_23850[(1)] = (1));

return statearr_23850;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto____1 = (function (state_23770){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_23770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e23851){var ex__2706__auto__ = e23851;
var statearr_23852_23915 = state_23770;
(statearr_23852_23915[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_23770[(4)]))){
var statearr_23853_23916 = state_23770;
(statearr_23853_23916[(1)] = cljs.core.first.call(null,(state_23770[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23917 = state_23770;
state_23770 = G__23917;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto__ = function(state_23770){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto____1.call(this,state_23770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_23854 = f__2726__auto__.call(null);
(statearr_23854[(6)] = c__2725__auto__);

return statearr_23854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23918 = select_spec;
var map__23918__$1 = cljs.core.__destructure_map.call(null,map__23918);
var recur_seen = cljs.core.get.call(null,map__23918__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__23918__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_24032){
var state_val_24033 = (state_24032[(1)]);
if((state_val_24033 === (7))){
var inst_23944 = flakes;
var inst_23945 = cljs.core.seq.call(null,inst_23944);
var inst_23946 = cljs.core.first.call(null,inst_23945);
var inst_23947 = cljs.core.next.call(null,inst_23945);
var inst_23948 = cljs.core.PersistentVector.EMPTY;
var inst_23949 = inst_23944;
var inst_23950 = (0);
var inst_23951 = inst_23948;
var state_24032__$1 = (function (){var statearr_24034 = state_24032;
(statearr_24034[(7)] = inst_23949);

(statearr_24034[(8)] = inst_23947);

(statearr_24034[(9)] = inst_23946);

(statearr_24034[(10)] = inst_23950);

(statearr_24034[(11)] = inst_23951);

return statearr_24034;
})();
var statearr_24035_24101 = state_24032__$1;
(statearr_24035_24101[(2)] = null);

(statearr_24035_24101[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (20))){
var state_24032__$1 = state_24032;
var statearr_24036_24102 = state_24032__$1;
(statearr_24036_24102[(2)] = results);

(statearr_24036_24102[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (27))){
var state_24032__$1 = state_24032;
var statearr_24037_24103 = state_24032__$1;
(statearr_24037_24103[(2)] = null);

(statearr_24037_24103[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (1))){
var state_24032__$1 = state_24032;
var statearr_24038_24104 = state_24032__$1;
(statearr_24038_24104[(2)] = null);

(statearr_24038_24104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (24))){
var state_24032__$1 = state_24032;
var statearr_24039_24105 = state_24032__$1;
(statearr_24039_24105[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (39))){
var inst_23958 = (state_24032[(12)]);
var inst_24013 = (state_24032[(13)]);
var inst_23951 = (state_24032[(11)]);
var inst_24016 = (state_24032[(2)]);
var inst_24017 = fluree.db.util.async.throw_err.call(null,inst_24016);
var inst_24018 = cljs.core.conj.call(null,inst_23951,inst_24017);
var inst_23949 = inst_23958;
var inst_23950 = inst_24013;
var inst_23951__$1 = inst_24018;
var state_24032__$1 = (function (){var statearr_24041 = state_24032;
(statearr_24041[(7)] = inst_23949);

(statearr_24041[(10)] = inst_23950);

(statearr_24041[(11)] = inst_23951__$1);

return statearr_24041;
})();
var statearr_24042_24106 = state_24032__$1;
(statearr_24042_24106[(2)] = null);

(statearr_24042_24106[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (4))){
var inst_23919 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24043_24107 = state_24032__$1;
(statearr_24043_24107[(2)] = inst_23919);

(statearr_24043_24107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (15))){
var inst_23932 = (state_24032[(14)]);
var state_24032__$1 = state_24032;
var statearr_24044_24108 = state_24032__$1;
(statearr_24044_24108[(2)] = inst_23932);

(statearr_24044_24108[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (21))){
var inst_23928 = (state_24032[(15)]);
var state_24032__$1 = state_24032;
if(cljs.core.truth_(inst_23928)){
var statearr_24045_24109 = state_24032__$1;
(statearr_24045_24109[(1)] = (23));

} else {
var statearr_24046_24110 = state_24032__$1;
(statearr_24046_24110[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (31))){
var inst_23996 = (state_24032[(16)]);
var state_24032__$1 = state_24032;
var statearr_24047_24111 = state_24032__$1;
(statearr_24047_24111[(2)] = inst_23996);

(statearr_24047_24111[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (32))){
var inst_23988 = (state_24032[(17)]);
var inst_24002 = (state_24032[(2)]);
var state_24032__$1 = (function (){var statearr_24048 = state_24032;
(statearr_24048[(18)] = inst_24002);

return statearr_24048;
})();
if(cljs.core.truth_(inst_23988)){
var statearr_24049_24112 = state_24032__$1;
(statearr_24049_24112[(1)] = (33));

} else {
var statearr_24050_24113 = state_24032__$1;
(statearr_24050_24113[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (33))){
var inst_23988 = (state_24032[(17)]);
var state_24032__$1 = state_24032;
var statearr_24051_24114 = state_24032__$1;
(statearr_24051_24114[(2)] = inst_23988);

(statearr_24051_24114[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (13))){
var inst_23968 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
if(cljs.core.truth_(inst_23968)){
var statearr_24053_24115 = state_24032__$1;
(statearr_24053_24115[(1)] = (17));

} else {
var statearr_24054_24116 = state_24032__$1;
(statearr_24054_24116[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (22))){
var inst_23985 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24055_24117 = state_24032__$1;
(statearr_24055_24117[(2)] = inst_23985);

(statearr_24055_24117[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (36))){
var inst_23958 = (state_24032[(12)]);
var inst_23950 = (state_24032[(10)]);
var inst_23951 = (state_24032[(11)]);
var inst_24010 = (inst_23950 + (1));
var tmp24052 = inst_23951;
var inst_23949 = inst_23958;
var inst_23950__$1 = inst_24010;
var inst_23951__$1 = tmp24052;
var state_24032__$1 = (function (){var statearr_24056 = state_24032;
(statearr_24056[(7)] = inst_23949);

(statearr_24056[(10)] = inst_23950__$1);

(statearr_24056[(11)] = inst_23951__$1);

return statearr_24056;
})();
var statearr_24057_24118 = state_24032__$1;
(statearr_24057_24118[(2)] = null);

(statearr_24057_24118[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (29))){
var inst_23995 = (state_24032[(2)]);
var inst_23996 = fluree.db.util.async.throw_err.call(null,inst_23995);
var state_24032__$1 = (function (){var statearr_24058 = state_24032;
(statearr_24058[(16)] = inst_23996);

return statearr_24058;
})();
if(cljs.core.truth_(fuel)){
var statearr_24059_24119 = state_24032__$1;
(statearr_24059_24119[(1)] = (30));

} else {
var statearr_24060_24120 = state_24032__$1;
(statearr_24060_24120[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (6))){
var state_24032__$1 = state_24032;
var statearr_24061_24121 = state_24032__$1;
(statearr_24061_24121[(2)] = results);

(statearr_24061_24121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (28))){
var inst_23981 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24062_24122 = state_24032__$1;
(statearr_24062_24122[(2)] = inst_23981);

(statearr_24062_24122[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (25))){
var inst_23983 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24063_24123 = state_24032__$1;
(statearr_24063_24123[(2)] = inst_23983);

(statearr_24063_24123[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (34))){
var inst_24002 = (state_24032[(18)]);
var inst_24005 = cljs.core.empty_QMARK_.call(null,inst_24002);
var state_24032__$1 = state_24032;
var statearr_24064_24124 = state_24032__$1;
(statearr_24064_24124[(2)] = inst_24005);

(statearr_24064_24124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (17))){
var inst_23951 = (state_24032[(11)]);
var inst_23970 = cljs.core.empty_QMARK_.call(null,inst_23951);
var state_24032__$1 = state_24032;
if(inst_23970){
var statearr_24065_24125 = state_24032__$1;
(statearr_24065_24125[(1)] = (20));

} else {
var statearr_24066_24126 = state_24032__$1;
(statearr_24066_24126[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (3))){
var inst_24030 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24032__$1,inst_24030);
} else {
if((state_val_24033 === (12))){
var inst_23932 = (state_24032[(14)]);
var state_24032__$1 = state_24032;
if(cljs.core.truth_(inst_23932)){
var statearr_24067_24127 = state_24032__$1;
(statearr_24067_24127[(1)] = (14));

} else {
var statearr_24068_24128 = state_24032__$1;
(statearr_24068_24128[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (2))){
var _ = (function (){var statearr_24069 = state_24032;
(statearr_24069[(4)] = cljs.core.cons.call(null,(5),(state_24032[(4)])));

return statearr_24069;
})();
var inst_23926 = select_spec;
var inst_23927 = cljs.core.__destructure_map.call(null,inst_23926);
var inst_23928 = cljs.core.get.call(null,inst_23927,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23929 = cljs.core.get.call(null,inst_23927,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23930 = cljs.core.get.call(null,inst_23927,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23931 = cljs.core.get.call(null,inst_23927,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23932 = cljs.core.get.call(null,inst_23927,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23933 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23934 = (inst_23931 > inst_23933);
var state_24032__$1 = (function (){var statearr_24070 = state_24032;
(statearr_24070[(19)] = inst_23930);

(statearr_24070[(14)] = inst_23932);

(statearr_24070[(20)] = inst_23929);

(statearr_24070[(15)] = inst_23928);

return statearr_24070;
})();
if(cljs.core.truth_(inst_23934)){
var statearr_24071_24129 = state_24032__$1;
(statearr_24071_24129[(1)] = (6));

} else {
var statearr_24072_24130 = state_24032__$1;
(statearr_24072_24130[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (23))){
var inst_23929 = (state_24032[(20)]);
var inst_23951 = (state_24032[(11)]);
var inst_23974 = cljs.core.assoc.call(null,results,inst_23929,inst_23951);
var state_24032__$1 = state_24032;
var statearr_24073_24131 = state_24032__$1;
(statearr_24073_24131[(2)] = inst_23974);

(statearr_24073_24131[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (35))){
var inst_23957 = (state_24032[(21)]);
var inst_24007 = (state_24032[(2)]);
var inst_24008 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,inst_23957);
var state_24032__$1 = (function (){var statearr_24074 = state_24032;
(statearr_24074[(22)] = inst_24008);

return statearr_24074;
})();
if(cljs.core.truth_(inst_24007)){
var statearr_24075_24132 = state_24032__$1;
(statearr_24075_24132[(1)] = (36));

} else {
var statearr_24076_24133 = state_24032__$1;
(statearr_24076_24133[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (19))){
var inst_24023 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24077_24134 = state_24032__$1;
(statearr_24077_24134[(2)] = inst_24023);

(statearr_24077_24134[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (11))){
var inst_23959 = (state_24032[(23)]);
var state_24032__$1 = state_24032;
var statearr_24079_24135 = state_24032__$1;
(statearr_24079_24135[(2)] = inst_23959);

(statearr_24079_24135[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (9))){
var inst_23949 = (state_24032[(7)]);
var inst_23959 = (state_24032[(23)]);
var inst_23957 = (state_24032[(21)]);
var inst_23956 = cljs.core.seq.call(null,inst_23949);
var inst_23957__$1 = cljs.core.first.call(null,inst_23956);
var inst_23958 = cljs.core.next.call(null,inst_23956);
var inst_23959__$1 = cljs.core.not.call(null,inst_23957__$1);
var state_24032__$1 = (function (){var statearr_24080 = state_24032;
(statearr_24080[(23)] = inst_23959__$1);

(statearr_24080[(21)] = inst_23957__$1);

(statearr_24080[(12)] = inst_23958);

return statearr_24080;
})();
if(inst_23959__$1){
var statearr_24081_24136 = state_24032__$1;
(statearr_24081_24136[(1)] = (11));

} else {
var statearr_24082_24137 = state_24032__$1;
(statearr_24082_24137[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (5))){
var _ = (function (){var statearr_24083 = state_24032;
(statearr_24083[(4)] = cljs.core.rest.call(null,(state_24032[(4)])));

return statearr_24083;
})();
var state_24032__$1 = state_24032;
var ex24078 = (state_24032__$1[(2)]);
var statearr_24084_24138 = state_24032__$1;
(statearr_24084_24138[(5)] = ex24078);


if((ex24078 instanceof Error)){
var statearr_24085_24139 = state_24032__$1;
(statearr_24085_24139[(1)] = (4));

(statearr_24085_24139[(5)] = null);

} else {
throw ex24078;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (14))){
var inst_23950 = (state_24032[(10)]);
var inst_23932 = (state_24032[(14)]);
var inst_23963 = (inst_23950 < inst_23932);
var state_24032__$1 = state_24032;
var statearr_24086_24140 = state_24032__$1;
(statearr_24086_24140[(2)] = inst_23963);

(statearr_24086_24140[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (26))){
var inst_23929 = (state_24032[(20)]);
var inst_23951 = (state_24032[(11)]);
var inst_23977 = cljs.core.first.call(null,inst_23951);
var inst_23978 = cljs.core.assoc.call(null,results,inst_23929,inst_23977);
var state_24032__$1 = state_24032;
var statearr_24087_24141 = state_24032__$1;
(statearr_24087_24141[(2)] = inst_23978);

(statearr_24087_24141[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (16))){
var inst_23966 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24088_24142 = state_24032__$1;
(statearr_24088_24142[(2)] = inst_23966);

(statearr_24088_24142[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (38))){
var inst_24021 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24089_24143 = state_24032__$1;
(statearr_24089_24143[(2)] = inst_24021);

(statearr_24089_24143[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (30))){
var inst_23996 = (state_24032[(16)]);
var inst_23998 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_23999 = cljs.core.sequence.call(null,inst_23998,inst_23996);
var state_24032__$1 = state_24032;
var statearr_24090_24144 = state_24032__$1;
(statearr_24090_24144[(2)] = inst_23999);

(statearr_24090_24144[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (10))){
var inst_24025 = (state_24032[(2)]);
var state_24032__$1 = state_24032;
var statearr_24091_24145 = state_24032__$1;
(statearr_24091_24145[(2)] = inst_24025);

(statearr_24091_24145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24033 === (18))){
var inst_23957 = (state_24032[(21)]);
var inst_23930 = (state_24032[(19)]);
var inst_23987 = inst_23957.o;
var inst_23988 = cljs.core.contains_QMARK_.call(null,inst_23930,inst_23987);
var inst_23990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23991 = [inst_23987];
var inst_23992 = (new cljs.core.PersistentVector(null,1,(5),inst_23990,inst_23991,null));
var inst_23993 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23992);
var state_24032__$1 = (function (){var statearr_24092 = state_24032;
(statearr_24092[(17)] = inst_23988);

return statearr_24092;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24032__$1,(29),inst_23993);
} else {
if((state_val_24033 === (37))){
var inst_24008 = (state_24032[(22)]);
var inst_23950 = (state_24032[(10)]);
var inst_24002 = (state_24032[(18)]);
var inst_24013 = (inst_23950 + (1));
var inst_24014 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_24008,inst_24002);
var state_24032__$1 = (function (){var statearr_24093 = state_24032;
(statearr_24093[(13)] = inst_24013);

return statearr_24093;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24032__$1,(39),inst_24014);
} else {
if((state_val_24033 === (8))){
var inst_24027 = (state_24032[(2)]);
var _ = (function (){var statearr_24094 = state_24032;
(statearr_24094[(4)] = cljs.core.rest.call(null,(state_24032[(4)])));

return statearr_24094;
})();
var state_24032__$1 = state_24032;
var statearr_24095_24146 = state_24032__$1;
(statearr_24095_24146[(2)] = inst_24027);

(statearr_24095_24146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto____0 = (function (){
var statearr_24096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24096[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto__);

(statearr_24096[(1)] = (1));

return statearr_24096;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto____1 = (function (state_24032){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_24032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e24097){var ex__2706__auto__ = e24097;
var statearr_24098_24147 = state_24032;
(statearr_24098_24147[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_24032[(4)]))){
var statearr_24099_24148 = state_24032;
(statearr_24099_24148[(1)] = cljs.core.first.call(null,(state_24032[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24149 = state_24032;
state_24032 = G__24149;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto__ = function(state_24032){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto____1.call(this,state_24032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_24100 = f__2726__auto__.call(null);
(statearr_24100[(6)] = c__2725__auto__);

return statearr_24100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_24330){
var state_val_24331 = (state_24330[(1)]);
if((state_val_24331 === (7))){
var state_24330__$1 = state_24330;
var statearr_24332_24418 = state_24330__$1;
(statearr_24332_24418[(2)] = null);

(statearr_24332_24418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (20))){
var inst_24188 = cljs.core.PersistentHashMap.EMPTY;
var state_24330__$1 = state_24330;
var statearr_24333_24419 = state_24330__$1;
(statearr_24333_24419[(2)] = inst_24188);

(statearr_24333_24419[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (27))){
var inst_24206 = (state_24330[(7)]);
var inst_24190 = (state_24330[(8)]);
var inst_24176 = (state_24330[(9)]);
var inst_24170 = (state_24330[(10)]);
var inst_24309 = (state_24330[(2)]);
var inst_24310 = (function (){var top_level_subject = inst_24170;
var select_spec = inst_24176;
var base_acc = inst_24190;
var acc_PLUS_refs = inst_24206;
var result = inst_24309;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_24311 = cljs.core.PersistentVector.EMPTY;
var inst_24312 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24176);
var inst_24313 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_24312);
var inst_24314 = cljs.core.vals.call(null,inst_24313);
var inst_24315 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24176);
var inst_24316 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_24315);
var inst_24317 = cljs.core.vals.call(null,inst_24316);
var inst_24318 = cljs.core.concat.call(null,inst_24314,inst_24317);
var inst_24319 = cljs.core.reduce.call(null,inst_24310,inst_24311,inst_24318);
var inst_24321 = (function (){var top_level_subject = inst_24170;
var select_spec = inst_24176;
var base_acc = inst_24190;
var acc_PLUS_refs = inst_24206;
var result = inst_24309;
var sort_preds = inst_24319;
return (function (acc,p__24320){
var vec__24334 = p__24320;
var selectPred = cljs.core.nth.call(null,vec__24334,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__24334,(1),null);
var sortPred = cljs.core.nth.call(null,vec__24334,(2),null);
var limit = cljs.core.nth.call(null,vec__24334,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_24322 = cljs.core.reduce.call(null,inst_24321,inst_24309,inst_24319);
var state_24330__$1 = state_24330;
var statearr_24337_24420 = state_24330__$1;
(statearr_24337_24420[(2)] = inst_24322);

(statearr_24337_24420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (1))){
var state_24330__$1 = state_24330;
var statearr_24338_24421 = state_24330__$1;
(statearr_24338_24421[(2)] = null);

(statearr_24338_24421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (24))){
var inst_24206 = (state_24330[(7)]);
var inst_24206__$1 = (state_24330[(2)]);
var inst_24207 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_24208 = cljs.core.PersistentHashMap.EMPTY;
var inst_24209 = inst_24207;
var inst_24210 = inst_24206__$1;
var inst_24211 = inst_24208;
var state_24330__$1 = (function (){var statearr_24339 = state_24330;
(statearr_24339[(11)] = inst_24211);

(statearr_24339[(7)] = inst_24206__$1);

(statearr_24339[(12)] = inst_24209);

(statearr_24339[(13)] = inst_24210);

return statearr_24339;
})();
var statearr_24340_24422 = state_24330__$1;
(statearr_24340_24422[(2)] = null);

(statearr_24340_24422[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (39))){
var inst_24226 = (state_24330[(14)]);
var inst_24176 = (state_24330[(9)]);
var inst_24219 = (state_24330[(15)]);
var inst_24210 = (state_24330[(13)]);
var inst_24255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24256 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_24210,inst_24176,inst_24219,inst_24226,false);
var state_24330__$1 = (function (){var statearr_24341 = state_24330;
(statearr_24341[(16)] = inst_24255);

return statearr_24341;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24330__$1,(42),inst_24256);
} else {
if((state_val_24331 === (46))){
var inst_24211 = (state_24330[(11)]);
var inst_24209 = (state_24330[(12)]);
var inst_24219 = (state_24330[(15)]);
var inst_24273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24274 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24275 = cljs.core.first.call(null,inst_24219);
var inst_24276 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24275);
var inst_24277 = [inst_24276];
var inst_24278 = cljs.core.PersistentHashMap.fromArrays(inst_24274,inst_24277);
var inst_24279 = cljs.core.rest.call(null,inst_24209);
var inst_24280 = [inst_24278,inst_24279,inst_24211];
var inst_24281 = (new cljs.core.PersistentVector(null,3,(5),inst_24273,inst_24280,null));
var state_24330__$1 = state_24330;
var statearr_24342_24423 = state_24330__$1;
(statearr_24342_24423[(2)] = inst_24281);

(statearr_24342_24423[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (4))){
var inst_24150 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
var statearr_24343_24424 = state_24330__$1;
(statearr_24343_24424[(2)] = inst_24150);

(statearr_24343_24424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (15))){
var inst_24177 = (state_24330[(17)]);
var inst_24176 = (state_24330[(9)]);
var inst_24176__$1 = (state_24330[(2)]);
var inst_24177__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24176__$1);
var state_24330__$1 = (function (){var statearr_24344 = state_24330;
(statearr_24344[(17)] = inst_24177__$1);

(statearr_24344[(9)] = inst_24176__$1);

return statearr_24344;
})();
if(cljs.core.truth_(inst_24177__$1)){
var statearr_24345_24425 = state_24330__$1;
(statearr_24345_24425[(1)] = (16));

} else {
var statearr_24346_24426 = state_24330__$1;
(statearr_24346_24426[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (48))){
var inst_24292 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
var statearr_24347_24427 = state_24330__$1;
(statearr_24347_24427[(2)] = inst_24292);

(statearr_24347_24427[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (50))){
var state_24330__$1 = state_24330;
var statearr_24348_24428 = state_24330__$1;
(statearr_24348_24428[(2)] = null);

(statearr_24348_24428[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (21))){
var inst_24176 = (state_24330[(9)]);
var inst_24190 = (state_24330[(2)]);
var inst_24191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24192 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_24193 = (new cljs.core.PersistentVector(null,2,(5),inst_24191,inst_24192,null));
var inst_24194 = cljs.core.get_in.call(null,inst_24176,inst_24193);
var state_24330__$1 = (function (){var statearr_24349 = state_24330;
(statearr_24349[(8)] = inst_24190);

return statearr_24349;
})();
if(cljs.core.truth_(inst_24194)){
var statearr_24350_24429 = state_24330__$1;
(statearr_24350_24429[(1)] = (22));

} else {
var statearr_24351_24430 = state_24330__$1;
(statearr_24351_24430[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (31))){
var inst_24225 = (state_24330[(18)]);
var inst_24219 = (state_24330[(15)]);
var inst_24210 = (state_24330[(13)]);
var inst_24229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24230 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_24219,inst_24225,inst_24210,fuel,max_fuel,cache);
var state_24330__$1 = (function (){var statearr_24352 = state_24330;
(statearr_24352[(19)] = inst_24229);

return statearr_24352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24330__$1,(34),inst_24230);
} else {
if((state_val_24331 === (32))){
var inst_24225 = (state_24330[(18)]);
var state_24330__$1 = state_24330;
if(cljs.core.truth_(inst_24225)){
var statearr_24353_24431 = state_24330__$1;
(statearr_24353_24431[(1)] = (35));

} else {
var statearr_24354_24432 = state_24330__$1;
(statearr_24354_24432[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (40))){
var inst_24266 = (state_24330[(20)]);
var inst_24176 = (state_24330[(9)]);
var inst_24265 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24176);
var inst_24266__$1 = cljs.core.empty_QMARK_.call(null,inst_24265);
var state_24330__$1 = (function (){var statearr_24355 = state_24330;
(statearr_24355[(20)] = inst_24266__$1);

return statearr_24355;
})();
if(inst_24266__$1){
var statearr_24356_24433 = state_24330__$1;
(statearr_24356_24433[(1)] = (43));

} else {
var statearr_24357_24434 = state_24330__$1;
(statearr_24357_24434[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (33))){
var inst_24219 = (state_24330[(15)]);
var inst_24298 = (state_24330[(2)]);
var inst_24299 = cljs.core.nth.call(null,inst_24298,(0),null);
var inst_24300 = cljs.core.nth.call(null,inst_24298,(1),null);
var inst_24301 = cljs.core.nth.call(null,inst_24298,(2),null);
var inst_24302 = cljs.core.first.call(null,inst_24219);
var inst_24303 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24302);
var inst_24304 = cljs.core.assoc.call(null,inst_24299,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24303);
var inst_24209 = inst_24300;
var inst_24210 = inst_24304;
var inst_24211 = inst_24301;
var state_24330__$1 = (function (){var statearr_24358 = state_24330;
(statearr_24358[(11)] = inst_24211);

(statearr_24358[(12)] = inst_24209);

(statearr_24358[(13)] = inst_24210);

return statearr_24358;
})();
var statearr_24359_24435 = state_24330__$1;
(statearr_24359_24435[(2)] = null);

(statearr_24359_24435[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (13))){
var inst_24170 = (state_24330[(10)]);
var inst_24173 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_24170);
var state_24330__$1 = state_24330;
var statearr_24360_24436 = state_24330__$1;
(statearr_24360_24436[(2)] = inst_24173);

(statearr_24360_24436[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (22))){
var inst_24176 = (state_24330[(9)]);
var inst_24196 = cljs.core.first.call(null,flakes);
var inst_24197 = fluree.db.query.fql.s.call(null,inst_24196);
var inst_24198 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_24176);
var inst_24199 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_24197,inst_24198);
var state_24330__$1 = state_24330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24330__$1,(25),inst_24199);
} else {
if((state_val_24331 === (36))){
var inst_24176 = (state_24330[(9)]);
var inst_24253 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24176);
var state_24330__$1 = state_24330;
if(cljs.core.truth_(inst_24253)){
var statearr_24361_24437 = state_24330__$1;
(statearr_24361_24437[(1)] = (39));

} else {
var statearr_24362_24438 = state_24330__$1;
(statearr_24362_24438[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (41))){
var inst_24294 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
var statearr_24363_24439 = state_24330__$1;
(statearr_24363_24439[(2)] = inst_24294);

(statearr_24363_24439[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (43))){
var inst_24176 = (state_24330[(9)]);
var inst_24268 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24176);
var state_24330__$1 = state_24330;
var statearr_24364_24440 = state_24330__$1;
(statearr_24364_24440[(2)] = inst_24268);

(statearr_24364_24440[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (29))){
var inst_24176 = (state_24330[(9)]);
var inst_24209 = (state_24330[(12)]);
var inst_24225 = (state_24330[(18)]);
var inst_24219 = (state_24330[(15)]);
var inst_24219__$1 = cljs.core.first.call(null,inst_24209);
var inst_24220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24221 = cljs.core.first.call(null,inst_24219__$1);
var inst_24222 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_24221);
var inst_24223 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_24222];
var inst_24224 = (new cljs.core.PersistentVector(null,3,(5),inst_24220,inst_24223,null));
var inst_24225__$1 = cljs.core.get_in.call(null,inst_24176,inst_24224);
var inst_24226 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_24225__$1,inst_24176);
var inst_24227 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_24225__$1);
var state_24330__$1 = (function (){var statearr_24365 = state_24330;
(statearr_24365[(14)] = inst_24226);

(statearr_24365[(18)] = inst_24225__$1);

(statearr_24365[(15)] = inst_24219__$1);

return statearr_24365;
})();
if(cljs.core.truth_(inst_24227)){
var statearr_24366_24441 = state_24330__$1;
(statearr_24366_24441[(1)] = (31));

} else {
var statearr_24367_24442 = state_24330__$1;
(statearr_24367_24442[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (44))){
var inst_24266 = (state_24330[(20)]);
var state_24330__$1 = state_24330;
var statearr_24368_24443 = state_24330__$1;
(statearr_24368_24443[(2)] = inst_24266);

(statearr_24368_24443[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (6))){
var state_24330__$1 = state_24330;
var statearr_24369_24444 = state_24330__$1;
(statearr_24369_24444[(2)] = null);

(statearr_24369_24444[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (28))){
var inst_24210 = (state_24330[(13)]);
var state_24330__$1 = state_24330;
var statearr_24370_24445 = state_24330__$1;
(statearr_24370_24445[(2)] = inst_24210);

(statearr_24370_24445[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (51))){
var inst_24290 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
var statearr_24371_24446 = state_24330__$1;
(statearr_24371_24446[(2)] = inst_24290);

(statearr_24371_24446[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (25))){
var inst_24190 = (state_24330[(8)]);
var inst_24201 = (state_24330[(2)]);
var inst_24202 = fluree.db.util.async.throw_err.call(null,inst_24201);
var inst_24203 = cljs.core.merge.call(null,inst_24190,inst_24202);
var state_24330__$1 = state_24330;
var statearr_24372_24447 = state_24330__$1;
(statearr_24372_24447[(2)] = inst_24203);

(statearr_24372_24447[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (34))){
var inst_24211 = (state_24330[(11)]);
var inst_24209 = (state_24330[(12)]);
var inst_24229 = (state_24330[(19)]);
var inst_24232 = (state_24330[(2)]);
var inst_24233 = fluree.db.util.async.throw_err.call(null,inst_24232);
var inst_24234 = cljs.core.rest.call(null,inst_24209);
var inst_24235 = [inst_24233,inst_24234,inst_24211];
var inst_24236 = (new cljs.core.PersistentVector(null,3,(5),inst_24229,inst_24235,null));
var state_24330__$1 = state_24330;
var statearr_24373_24448 = state_24330__$1;
(statearr_24373_24448[(2)] = inst_24236);

(statearr_24373_24448[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (17))){
var inst_24176 = (state_24330[(9)]);
var inst_24180 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24176);
var state_24330__$1 = state_24330;
var statearr_24375_24449 = state_24330__$1;
(statearr_24375_24449[(2)] = inst_24180);

(statearr_24375_24449[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (3))){
var inst_24328 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24330__$1,inst_24328);
} else {
if((state_val_24331 === (12))){
var _ = (function (){var statearr_24376 = state_24330;
(statearr_24376[(4)] = cljs.core.rest.call(null,(state_24330[(4)])));

return statearr_24376;
})();
var state_24330__$1 = state_24330;
var ex24374 = (state_24330__$1[(2)]);
var statearr_24377_24450 = state_24330__$1;
(statearr_24377_24450[(5)] = ex24374);


var statearr_24378_24451 = state_24330__$1;
(statearr_24378_24451[(1)] = (11));

(statearr_24378_24451[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (2))){
var _ = (function (){var statearr_24379 = state_24330;
(statearr_24379[(4)] = cljs.core.cons.call(null,(5),(state_24330[(4)])));

return statearr_24379;
})();
var inst_24156 = cljs.core.not_empty.call(null,flakes);
var state_24330__$1 = state_24330;
if(cljs.core.truth_(inst_24156)){
var statearr_24380_24452 = state_24330__$1;
(statearr_24380_24452[(1)] = (6));

} else {
var statearr_24381_24453 = state_24330__$1;
(statearr_24381_24453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (23))){
var inst_24190 = (state_24330[(8)]);
var state_24330__$1 = state_24330;
var statearr_24382_24454 = state_24330__$1;
(statearr_24382_24454[(2)] = inst_24190);

(statearr_24382_24454[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (47))){
var state_24330__$1 = state_24330;
var statearr_24383_24455 = state_24330__$1;
(statearr_24383_24455[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (35))){
var inst_24226 = (state_24330[(14)]);
var inst_24211 = (state_24330[(11)]);
var inst_24225 = (state_24330[(18)]);
var inst_24219 = (state_24330[(15)]);
var inst_24210 = (state_24330[(13)]);
var inst_24242 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_24210,inst_24225,inst_24219,inst_24226,false,inst_24211);
var state_24330__$1 = state_24330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24330__$1,(38),inst_24242);
} else {
if((state_val_24331 === (19))){
var inst_24170 = (state_24330[(10)]);
var inst_24184 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24185 = [inst_24170];
var inst_24186 = cljs.core.PersistentHashMap.fromArrays(inst_24184,inst_24185);
var state_24330__$1 = state_24330;
var statearr_24385_24456 = state_24330__$1;
(statearr_24385_24456[(2)] = inst_24186);

(statearr_24385_24456[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (11))){
var inst_24158 = (state_24330[(2)]);
var inst_24159 = fluree.db.util.log.error.call(null,inst_24158);
var inst_24160 = (function(){throw inst_24158})();
var state_24330__$1 = (function (){var statearr_24387 = state_24330;
(statearr_24387[(21)] = inst_24159);

return statearr_24387;
})();
var statearr_24388_24457 = state_24330__$1;
(statearr_24388_24457[(2)] = inst_24160);

(statearr_24388_24457[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (9))){
var _ = (function (){var statearr_24389 = state_24330;
(statearr_24389[(4)] = cljs.core.cons.call(null,(12),(state_24330[(4)])));

return statearr_24389;
})();
var inst_24166 = cljs.core.first.call(null,flakes);
var inst_24167 = fluree.db.query.fql.s.call(null,inst_24166);
var ___$1 = (function (){var statearr_24390 = state_24330;
(statearr_24390[(4)] = cljs.core.rest.call(null,(state_24330[(4)])));

return statearr_24390;
})();
var state_24330__$1 = state_24330;
var statearr_24391_24458 = state_24330__$1;
(statearr_24391_24458[(2)] = inst_24167);

(statearr_24391_24458[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (5))){
var _ = (function (){var statearr_24392 = state_24330;
(statearr_24392[(4)] = cljs.core.rest.call(null,(state_24330[(4)])));

return statearr_24392;
})();
var state_24330__$1 = state_24330;
var ex24386 = (state_24330__$1[(2)]);
var statearr_24393_24459 = state_24330__$1;
(statearr_24393_24459[(5)] = ex24386);


if((ex24386 instanceof Error)){
var statearr_24394_24460 = state_24330__$1;
(statearr_24394_24460[(1)] = (4));

(statearr_24394_24460[(5)] = null);

} else {
throw ex24386;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (14))){
var state_24330__$1 = state_24330;
var statearr_24395_24461 = state_24330__$1;
(statearr_24395_24461[(2)] = base_select_spec);

(statearr_24395_24461[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (45))){
var inst_24271 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
if(cljs.core.truth_(inst_24271)){
var statearr_24396_24462 = state_24330__$1;
(statearr_24396_24462[(1)] = (46));

} else {
var statearr_24397_24463 = state_24330__$1;
(statearr_24397_24463[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (26))){
var inst_24209 = (state_24330[(12)]);
var inst_24213 = cljs.core.empty_QMARK_.call(null,inst_24209);
var state_24330__$1 = state_24330;
if(inst_24213){
var statearr_24398_24464 = state_24330__$1;
(statearr_24398_24464[(1)] = (28));

} else {
var statearr_24399_24465 = state_24330__$1;
(statearr_24399_24465[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (16))){
var inst_24177 = (state_24330[(17)]);
var state_24330__$1 = state_24330;
var statearr_24400_24466 = state_24330__$1;
(statearr_24400_24466[(2)] = inst_24177);

(statearr_24400_24466[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (38))){
var inst_24209 = (state_24330[(12)]);
var inst_24244 = (state_24330[(2)]);
var inst_24245 = fluree.db.util.async.throw_err.call(null,inst_24244);
var inst_24246 = cljs.core.nth.call(null,inst_24245,(0),null);
var inst_24247 = cljs.core.nth.call(null,inst_24245,(1),null);
var inst_24248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24249 = cljs.core.rest.call(null,inst_24209);
var inst_24250 = [inst_24246,inst_24249,inst_24247];
var inst_24251 = (new cljs.core.PersistentVector(null,3,(5),inst_24248,inst_24250,null));
var state_24330__$1 = state_24330;
var statearr_24401_24467 = state_24330__$1;
(statearr_24401_24467[(2)] = inst_24251);

(statearr_24401_24467[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (30))){
var inst_24307 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
var statearr_24402_24468 = state_24330__$1;
(statearr_24402_24468[(2)] = inst_24307);

(statearr_24402_24468[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (10))){
var inst_24170 = (state_24330[(2)]);
var inst_24171 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_24330__$1 = (function (){var statearr_24403 = state_24330;
(statearr_24403[(10)] = inst_24170);

return statearr_24403;
})();
if(cljs.core.truth_(inst_24171)){
var statearr_24404_24469 = state_24330__$1;
(statearr_24404_24469[(1)] = (13));

} else {
var statearr_24405_24470 = state_24330__$1;
(statearr_24405_24470[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (18))){
var inst_24182 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
if(cljs.core.truth_(inst_24182)){
var statearr_24406_24471 = state_24330__$1;
(statearr_24406_24471[(1)] = (19));

} else {
var statearr_24407_24472 = state_24330__$1;
(statearr_24407_24472[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (42))){
var inst_24211 = (state_24330[(11)]);
var inst_24209 = (state_24330[(12)]);
var inst_24255 = (state_24330[(16)]);
var inst_24258 = (state_24330[(2)]);
var inst_24259 = fluree.db.util.async.throw_err.call(null,inst_24258);
var inst_24260 = cljs.core.first.call(null,inst_24259);
var inst_24261 = cljs.core.rest.call(null,inst_24209);
var inst_24262 = [inst_24260,inst_24261,inst_24211];
var inst_24263 = (new cljs.core.PersistentVector(null,3,(5),inst_24255,inst_24262,null));
var state_24330__$1 = state_24330;
var statearr_24408_24473 = state_24330__$1;
(statearr_24408_24473[(2)] = inst_24263);

(statearr_24408_24473[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (37))){
var inst_24296 = (state_24330[(2)]);
var state_24330__$1 = state_24330;
var statearr_24409_24474 = state_24330__$1;
(statearr_24409_24474[(2)] = inst_24296);

(statearr_24409_24474[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (8))){
var inst_24325 = (state_24330[(2)]);
var _ = (function (){var statearr_24410 = state_24330;
(statearr_24410[(4)] = cljs.core.rest.call(null,(state_24330[(4)])));

return statearr_24410;
})();
var state_24330__$1 = state_24330;
var statearr_24411_24475 = state_24330__$1;
(statearr_24411_24475[(2)] = inst_24325);

(statearr_24411_24475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24331 === (49))){
var inst_24211 = (state_24330[(11)]);
var inst_24209 = (state_24330[(12)]);
var inst_24210 = (state_24330[(13)]);
var inst_24284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24285 = cljs.core.rest.call(null,inst_24209);
var inst_24286 = [inst_24210,inst_24285,inst_24211];
var inst_24287 = (new cljs.core.PersistentVector(null,3,(5),inst_24284,inst_24286,null));
var state_24330__$1 = state_24330;
var statearr_24412_24476 = state_24330__$1;
(statearr_24412_24476[(2)] = inst_24287);

(statearr_24412_24476[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto____0 = (function (){
var statearr_24413 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24413[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto__);

(statearr_24413[(1)] = (1));

return statearr_24413;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto____1 = (function (state_24330){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_24330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e24414){var ex__2706__auto__ = e24414;
var statearr_24415_24477 = state_24330;
(statearr_24415_24477[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_24330[(4)]))){
var statearr_24416_24478 = state_24330;
(statearr_24416_24478[(1)] = cljs.core.first.call(null,(state_24330[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24479 = state_24330;
state_24330 = G__24479;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto__ = function(state_24330){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto____1.call(this,state_24330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_24417 = f__2726__auto__.call(null);
(statearr_24417[(6)] = c__2725__auto__);

return statearr_24417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__24482 = arguments.length;
switch (G__24482) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_24524){
var state_val_24525 = (state_24524[(1)]);
if((state_val_24525 === (7))){
var inst_24490 = (state_24524[(7)]);
var state_24524__$1 = state_24524;
var statearr_24526_24556 = state_24524__$1;
(statearr_24526_24556[(2)] = inst_24490);

(statearr_24526_24556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (1))){
var state_24524__$1 = state_24524;
var statearr_24527_24557 = state_24524__$1;
(statearr_24527_24557[(2)] = null);

(statearr_24527_24557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (4))){
var inst_24483 = (state_24524[(2)]);
var state_24524__$1 = state_24524;
var statearr_24528_24558 = state_24524__$1;
(statearr_24528_24558[(2)] = inst_24483);

(statearr_24528_24558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (15))){
var inst_24518 = (state_24524[(2)]);
var inst_24519 = fluree.db.util.async.throw_err.call(null,inst_24518);
var _ = (function (){var statearr_24529 = state_24524;
(statearr_24529[(4)] = cljs.core.rest.call(null,(state_24524[(4)])));

return statearr_24529;
})();
var state_24524__$1 = state_24524;
var statearr_24530_24559 = state_24524__$1;
(statearr_24530_24559[(2)] = inst_24519);

(statearr_24530_24559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (13))){
var inst_24502 = (state_24524[(8)]);
var state_24524__$1 = state_24524;
var statearr_24531_24560 = state_24524__$1;
(statearr_24531_24560[(2)] = inst_24502);

(statearr_24531_24560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (6))){
var inst_24490 = (state_24524[(7)]);
var inst_24492 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_24493 = cljs.core.comp.call(null,inst_24490,inst_24492);
var state_24524__$1 = state_24524;
var statearr_24532_24561 = state_24524__$1;
(statearr_24532_24561[(2)] = inst_24493);

(statearr_24532_24561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (3))){
var inst_24522 = (state_24524[(2)]);
var state_24524__$1 = state_24524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24524__$1,inst_24522);
} else {
if((state_val_24525 === (12))){
var inst_24502 = (state_24524[(8)]);
var inst_24504 = cljs.core.take.call(null,limit);
var inst_24505 = cljs.core.comp.call(null,inst_24502,inst_24504);
var state_24524__$1 = state_24524;
var statearr_24533_24562 = state_24524__$1;
(statearr_24533_24562[(2)] = inst_24505);

(statearr_24533_24562[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (2))){
var _ = (function (){var statearr_24534 = state_24524;
(statearr_24534[(4)] = cljs.core.cons.call(null,(5),(state_24524[(4)])));

return statearr_24534;
})();
var inst_24490 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_24524__$1 = (function (){var statearr_24535 = state_24524;
(statearr_24535[(7)] = inst_24490);

return statearr_24535;
})();
if(cljs.core.truth_(fuel)){
var statearr_24536_24563 = state_24524__$1;
(statearr_24536_24563[(1)] = (6));

} else {
var statearr_24537_24564 = state_24524__$1;
(statearr_24537_24564[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (11))){
var inst_24502 = (state_24524[(2)]);
var state_24524__$1 = (function (){var statearr_24539 = state_24524;
(statearr_24539[(8)] = inst_24502);

return statearr_24539;
})();
if(cljs.core.truth_(limit)){
var statearr_24540_24565 = state_24524__$1;
(statearr_24540_24565[(1)] = (12));

} else {
var statearr_24541_24566 = state_24524__$1;
(statearr_24541_24566[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (9))){
var inst_24496 = (state_24524[(9)]);
var inst_24498 = cljs.core.drop.call(null,offset);
var inst_24499 = cljs.core.comp.call(null,inst_24496,inst_24498);
var state_24524__$1 = state_24524;
var statearr_24542_24567 = state_24524__$1;
(statearr_24542_24567[(2)] = inst_24499);

(statearr_24542_24567[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (5))){
var _ = (function (){var statearr_24543 = state_24524;
(statearr_24543[(4)] = cljs.core.rest.call(null,(state_24524[(4)])));

return statearr_24543;
})();
var state_24524__$1 = state_24524;
var ex24538 = (state_24524__$1[(2)]);
var statearr_24544_24568 = state_24524__$1;
(statearr_24544_24568[(5)] = ex24538);


if((ex24538 instanceof Error)){
var statearr_24545_24569 = state_24524__$1;
(statearr_24545_24569[(1)] = (4));

(statearr_24545_24569[(5)] = null);

} else {
throw ex24538;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (14))){
var inst_24508 = (state_24524[(2)]);
var inst_24509 = (function (){return (function (x){
var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__5043__auto__;
}
});
})();
var inst_24510 = cljs.core.halt_when.call(null,inst_24509);
var inst_24511 = cljs.core.comp.call(null,inst_24508,inst_24510);
var inst_24512 = cljs.core.sequence.call(null,inst_24511,flakes);
var inst_24513 = cljs.core.PersistentVector.EMPTY;
var inst_24514 = (function (){var xf = inst_24511;
var flakes_by_sub = inst_24512;
return (function (p1__24480_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__24480_SHARP_);
});
})();
var inst_24515 = cljs.core.map.call(null,inst_24514,inst_24512);
var inst_24516 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_24513,inst_24515);
var state_24524__$1 = state_24524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24524__$1,(15),inst_24516);
} else {
if((state_val_24525 === (10))){
var inst_24496 = (state_24524[(9)]);
var state_24524__$1 = state_24524;
var statearr_24546_24570 = state_24524__$1;
(statearr_24546_24570[(2)] = inst_24496);

(statearr_24546_24570[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24525 === (8))){
var inst_24496 = (state_24524[(2)]);
var state_24524__$1 = (function (){var statearr_24547 = state_24524;
(statearr_24547[(9)] = inst_24496);

return statearr_24547;
})();
if(cljs.core.truth_(offset)){
var statearr_24548_24571 = state_24524__$1;
(statearr_24548_24571[(1)] = (9));

} else {
var statearr_24549_24572 = state_24524__$1;
(statearr_24549_24572[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2703__auto__ = null;
var fluree$db$query$fql$state_machine__2703__auto____0 = (function (){
var statearr_24550 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24550[(0)] = fluree$db$query$fql$state_machine__2703__auto__);

(statearr_24550[(1)] = (1));

return statearr_24550;
});
var fluree$db$query$fql$state_machine__2703__auto____1 = (function (state_24524){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_24524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e24551){var ex__2706__auto__ = e24551;
var statearr_24552_24573 = state_24524;
(statearr_24552_24573[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_24524[(4)]))){
var statearr_24553_24574 = state_24524;
(statearr_24553_24574[(1)] = cljs.core.first.call(null,(state_24524[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24575 = state_24524;
state_24524 = G__24575;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2703__auto__ = function(state_24524){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2703__auto____1.call(this,state_24524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2703__auto____0;
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2703__auto____1;
return fluree$db$query$fql$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_24554 = f__2726__auto__.call(null);
(statearr_24554[(6)] = c__2725__auto__);

return statearr_24554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__24577 = arguments.length;
switch (G__24577) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_24663){
var state_val_24664 = (state_24663[(1)]);
if((state_val_24664 === (7))){
var inst_24658 = (state_24663[(2)]);
var _ = (function (){var statearr_24666 = state_24663;
(statearr_24666[(4)] = cljs.core.rest.call(null,(state_24663[(4)])));

return statearr_24666;
})();
var state_24663__$1 = state_24663;
var statearr_24667_24719 = state_24663__$1;
(statearr_24667_24719[(2)] = inst_24658);

(statearr_24667_24719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (20))){
var inst_24598 = (state_24663[(7)]);
var inst_24605 = (state_24663[(8)]);
var inst_24597 = (state_24663[(9)]);
var inst_24626 = (inst_24597 + (1));
var tmp24665 = inst_24598;
var inst_24596 = inst_24605;
var inst_24597__$1 = inst_24626;
var inst_24598__$1 = tmp24665;
var state_24663__$1 = (function (){var statearr_24668 = state_24663;
(statearr_24668[(7)] = inst_24598__$1);

(statearr_24668[(10)] = inst_24596);

(statearr_24668[(9)] = inst_24597__$1);

return statearr_24668;
})();
var statearr_24669_24720 = state_24663__$1;
(statearr_24669_24720[(2)] = null);

(statearr_24669_24720[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (27))){
var inst_24636 = (state_24663[(11)]);
var inst_24638 = cljs.core.count.call(null,inst_24636);
var inst_24639 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24638);
var state_24663__$1 = state_24663;
var statearr_24670_24721 = state_24663__$1;
(statearr_24670_24721[(2)] = inst_24639);

(statearr_24670_24721[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (1))){
var state_24663__$1 = state_24663;
var statearr_24671_24722 = state_24663__$1;
(statearr_24671_24722[(2)] = null);

(statearr_24671_24722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (24))){
var state_24663__$1 = state_24663;
var statearr_24672_24723 = state_24663__$1;
(statearr_24672_24723[(2)] = null);

(statearr_24672_24723[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (4))){
var inst_24578 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
var statearr_24673_24724 = state_24663__$1;
(statearr_24673_24724[(2)] = inst_24578);

(statearr_24673_24724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (15))){
var inst_24619 = (state_24663[(12)]);
var inst_24619__$1 = offset;
var state_24663__$1 = (function (){var statearr_24674 = state_24663;
(statearr_24674[(12)] = inst_24619__$1);

return statearr_24674;
})();
if(cljs.core.truth_(inst_24619__$1)){
var statearr_24675_24725 = state_24663__$1;
(statearr_24675_24725[(1)] = (17));

} else {
var statearr_24676_24726 = state_24663__$1;
(statearr_24676_24726[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (21))){
var state_24663__$1 = state_24663;
var statearr_24677_24727 = state_24663__$1;
(statearr_24677_24727[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (13))){
var inst_24614 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
var statearr_24679_24728 = state_24663__$1;
(statearr_24679_24728[(2)] = inst_24614);

(statearr_24679_24728[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (22))){
var inst_24654 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
var statearr_24680_24729 = state_24663__$1;
(statearr_24680_24729[(2)] = inst_24654);

(statearr_24680_24729[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (29))){
var inst_24636 = (state_24663[(11)]);
var inst_24597 = (state_24663[(9)]);
var inst_24642 = (state_24663[(2)]);
var inst_24643 = (inst_24597 + (1));
var inst_24644 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,inst_24636);
var state_24663__$1 = (function (){var statearr_24681 = state_24663;
(statearr_24681[(13)] = inst_24643);

(statearr_24681[(14)] = inst_24642);

return statearr_24681;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24663__$1,(30),inst_24644);
} else {
if((state_val_24664 === (6))){
var inst_24596 = (state_24663[(10)]);
var inst_24604 = (state_24663[(15)]);
var inst_24606 = (state_24663[(16)]);
var inst_24603 = cljs.core.seq.call(null,inst_24596);
var inst_24604__$1 = cljs.core.first.call(null,inst_24603);
var inst_24605 = cljs.core.next.call(null,inst_24603);
var inst_24606__$1 = (inst_24604__$1 == null);
var state_24663__$1 = (function (){var statearr_24682 = state_24663;
(statearr_24682[(15)] = inst_24604__$1);

(statearr_24682[(8)] = inst_24605);

(statearr_24682[(16)] = inst_24606__$1);

return statearr_24682;
})();
if(cljs.core.truth_(inst_24606__$1)){
var statearr_24683_24730 = state_24663__$1;
(statearr_24683_24730[(1)] = (8));

} else {
var statearr_24684_24731 = state_24663__$1;
(statearr_24684_24731[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (28))){
var state_24663__$1 = state_24663;
var statearr_24685_24732 = state_24663__$1;
(statearr_24685_24732[(2)] = null);

(statearr_24685_24732[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (25))){
var inst_24652 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
var statearr_24686_24733 = state_24663__$1;
(statearr_24686_24733[(2)] = inst_24652);

(statearr_24686_24733[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (17))){
var inst_24597 = (state_24663[(9)]);
var inst_24621 = (inst_24597 < offset);
var state_24663__$1 = state_24663;
var statearr_24687_24734 = state_24663__$1;
(statearr_24687_24734[(2)] = inst_24621);

(statearr_24687_24734[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (3))){
var inst_24661 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24663__$1,inst_24661);
} else {
if((state_val_24664 === (12))){
var inst_24609 = (state_24663[(17)]);
var state_24663__$1 = state_24663;
var statearr_24688_24735 = state_24663__$1;
(statearr_24688_24735[(2)] = inst_24609);

(statearr_24688_24735[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (2))){
var _ = (function (){var statearr_24689 = state_24663;
(statearr_24689[(4)] = cljs.core.cons.call(null,(5),(state_24663[(4)])));

return statearr_24689;
})();
var inst_24591 = subjects;
var inst_24592 = cljs.core.seq.call(null,inst_24591);
var inst_24593 = cljs.core.first.call(null,inst_24592);
var inst_24594 = cljs.core.next.call(null,inst_24592);
var inst_24595 = cljs.core.PersistentVector.EMPTY;
var inst_24596 = inst_24591;
var inst_24597 = (0);
var inst_24598 = inst_24595;
var state_24663__$1 = (function (){var statearr_24690 = state_24663;
(statearr_24690[(7)] = inst_24598);

(statearr_24690[(10)] = inst_24596);

(statearr_24690[(18)] = inst_24594);

(statearr_24690[(19)] = inst_24593);

(statearr_24690[(9)] = inst_24597);

return statearr_24690;
})();
var statearr_24691_24736 = state_24663__$1;
(statearr_24691_24736[(2)] = null);

(statearr_24691_24736[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (23))){
var inst_24604 = (state_24663[(15)]);
var inst_24630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24631 = [inst_24604];
var inst_24632 = (new cljs.core.PersistentVector(null,1,(5),inst_24630,inst_24631,null));
var inst_24633 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24632);
var state_24663__$1 = state_24663;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24663__$1,(26),inst_24633);
} else {
if((state_val_24664 === (19))){
var inst_24624 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
if(cljs.core.truth_(inst_24624)){
var statearr_24692_24737 = state_24663__$1;
(statearr_24692_24737[(1)] = (20));

} else {
var statearr_24693_24738 = state_24663__$1;
(statearr_24693_24738[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (11))){
var inst_24597 = (state_24663[(9)]);
var inst_24611 = (inst_24597 > limit);
var state_24663__$1 = state_24663;
var statearr_24695_24739 = state_24663__$1;
(statearr_24695_24739[(2)] = inst_24611);

(statearr_24695_24739[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (9))){
var inst_24609 = (state_24663[(17)]);
var inst_24609__$1 = limit;
var state_24663__$1 = (function (){var statearr_24696 = state_24663;
(statearr_24696[(17)] = inst_24609__$1);

return statearr_24696;
})();
if(cljs.core.truth_(inst_24609__$1)){
var statearr_24697_24740 = state_24663__$1;
(statearr_24697_24740[(1)] = (11));

} else {
var statearr_24698_24741 = state_24663__$1;
(statearr_24698_24741[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (5))){
var _ = (function (){var statearr_24699 = state_24663;
(statearr_24699[(4)] = cljs.core.rest.call(null,(state_24663[(4)])));

return statearr_24699;
})();
var state_24663__$1 = state_24663;
var ex24694 = (state_24663__$1[(2)]);
var statearr_24700_24742 = state_24663__$1;
(statearr_24700_24742[(5)] = ex24694);


if((ex24694 instanceof Error)){
var statearr_24701_24743 = state_24663__$1;
(statearr_24701_24743[(1)] = (4));

(statearr_24701_24743[(5)] = null);

} else {
throw ex24694;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (14))){
var inst_24598 = (state_24663[(7)]);
var state_24663__$1 = state_24663;
var statearr_24702_24744 = state_24663__$1;
(statearr_24702_24744[(2)] = inst_24598);

(statearr_24702_24744[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (26))){
var inst_24635 = (state_24663[(2)]);
var inst_24636 = fluree.db.util.async.throw_err.call(null,inst_24635);
var state_24663__$1 = (function (){var statearr_24703 = state_24663;
(statearr_24703[(11)] = inst_24636);

return statearr_24703;
})();
if(cljs.core.truth_(fuel)){
var statearr_24704_24745 = state_24663__$1;
(statearr_24704_24745[(1)] = (27));

} else {
var statearr_24705_24746 = state_24663__$1;
(statearr_24705_24746[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (16))){
var inst_24656 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
var statearr_24706_24747 = state_24663__$1;
(statearr_24706_24747[(2)] = inst_24656);

(statearr_24706_24747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (30))){
var inst_24598 = (state_24663[(7)]);
var inst_24605 = (state_24663[(8)]);
var inst_24643 = (state_24663[(13)]);
var inst_24646 = (state_24663[(2)]);
var inst_24647 = fluree.db.util.async.throw_err.call(null,inst_24646);
var inst_24648 = cljs.core.conj.call(null,inst_24598,inst_24647);
var inst_24596 = inst_24605;
var inst_24597 = inst_24643;
var inst_24598__$1 = inst_24648;
var state_24663__$1 = (function (){var statearr_24707 = state_24663;
(statearr_24707[(7)] = inst_24598__$1);

(statearr_24707[(10)] = inst_24596);

(statearr_24707[(9)] = inst_24597);

return statearr_24707;
})();
var statearr_24708_24748 = state_24663__$1;
(statearr_24708_24748[(2)] = null);

(statearr_24708_24748[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (10))){
var inst_24616 = (state_24663[(2)]);
var state_24663__$1 = state_24663;
if(cljs.core.truth_(inst_24616)){
var statearr_24709_24749 = state_24663__$1;
(statearr_24709_24749[(1)] = (14));

} else {
var statearr_24710_24750 = state_24663__$1;
(statearr_24710_24750[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (18))){
var inst_24619 = (state_24663[(12)]);
var state_24663__$1 = state_24663;
var statearr_24711_24751 = state_24663__$1;
(statearr_24711_24751[(2)] = inst_24619);

(statearr_24711_24751[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24664 === (8))){
var inst_24606 = (state_24663[(16)]);
var state_24663__$1 = state_24663;
var statearr_24712_24752 = state_24663__$1;
(statearr_24712_24752[(2)] = inst_24606);

(statearr_24712_24752[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2703__auto__ = null;
var fluree$db$query$fql$state_machine__2703__auto____0 = (function (){
var statearr_24713 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24713[(0)] = fluree$db$query$fql$state_machine__2703__auto__);

(statearr_24713[(1)] = (1));

return statearr_24713;
});
var fluree$db$query$fql$state_machine__2703__auto____1 = (function (state_24663){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_24663);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e24714){var ex__2706__auto__ = e24714;
var statearr_24715_24753 = state_24663;
(statearr_24715_24753[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_24663[(4)]))){
var statearr_24716_24754 = state_24663;
(statearr_24716_24754[(1)] = cljs.core.first.call(null,(state_24663[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24755 = state_24663;
state_24663 = G__24755;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2703__auto__ = function(state_24663){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2703__auto____1.call(this,state_24663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2703__auto____0;
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2703__auto____1;
return fluree$db$query$fql$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_24717 = f__2726__auto__.call(null);
(statearr_24717[(6)] = c__2725__auto__);

return statearr_24717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24757 = arguments.length;
switch (G__24757) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24758){
var map__24759 = p__24758;
var map__24759__$1 = cljs.core.__destructure_map.call(null,map__24759);
var limit = cljs.core.get.call(null,map__24759__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24759__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_25023){
var state_val_25024 = (state_25023[(1)]);
if((state_val_25024 === (65))){
var inst_24986 = (state_25023[(7)]);
var inst_24986__$1 = (state_25023[(2)]);
var state_25023__$1 = (function (){var statearr_25025 = state_25023;
(statearr_25025[(7)] = inst_24986__$1);

return statearr_25025;
})();
if(cljs.core.truth_(inst_24986__$1)){
var statearr_25026_25144 = state_25023__$1;
(statearr_25026_25144[(1)] = (66));

} else {
var statearr_25027_25145 = state_25023__$1;
(statearr_25027_25145[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (70))){
var inst_24989 = (state_25023[(8)]);
var state_25023__$1 = state_25023;
var statearr_25028_25146 = state_25023__$1;
(statearr_25028_25146[(2)] = inst_24989);

(statearr_25028_25146[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (62))){
var inst_24977 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25029_25147 = state_25023__$1;
(statearr_25029_25147[(2)] = inst_24977);

(statearr_25029_25147[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (74))){
var inst_24996 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25030_25148 = state_25023__$1;
(statearr_25030_25148[(2)] = inst_24996);

(statearr_25030_25148[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (7))){
var inst_24772 = (state_25023[(9)]);
var state_25023__$1 = state_25023;
var statearr_25031_25149 = state_25023__$1;
(statearr_25031_25149[(2)] = inst_24772);

(statearr_25031_25149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (59))){
var inst_24801 = (state_25023[(10)]);
var inst_24969 = cljs.core.empty_QMARK_.call(null,inst_24801);
var state_25023__$1 = state_25023;
if(inst_24969){
var statearr_25032_25150 = state_25023__$1;
(statearr_25032_25150[(1)] = (60));

} else {
var statearr_25033_25151 = state_25023__$1;
(statearr_25033_25151[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (20))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(offset)){
var statearr_25034_25152 = state_25023__$1;
(statearr_25034_25152[(1)] = (23));

} else {
var statearr_25035_25153 = state_25023__$1;
(statearr_25035_25153[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (72))){
var inst_24786 = (state_25023[(11)]);
var inst_24966 = (state_25023[(12)]);
var inst_24992 = cljs.core.count.call(null,inst_24966);
var inst_24993 = (inst_24992 > inst_24786);
var state_25023__$1 = state_25023;
var statearr_25036_25154 = state_25023__$1;
(statearr_25036_25154[(2)] = inst_24993);

(statearr_25036_25154[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (58))){
var inst_24966 = (state_25023[(12)]);
var inst_24801 = (state_25023[(10)]);
var inst_24967 = cljs.core.into.call(null,inst_24801,inst_24966);
var state_25023__$1 = state_25023;
var statearr_25037_25155 = state_25023__$1;
(statearr_25037_25155[(2)] = inst_24967);

(statearr_25037_25155[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (60))){
var inst_24966 = (state_25023[(12)]);
var inst_24801 = (state_25023[(10)]);
var inst_24971 = cljs.core.into.call(null,inst_24801,inst_24966);
var state_25023__$1 = state_25023;
var statearr_25038_25156 = state_25023__$1;
(statearr_25038_25156[(2)] = inst_24971);

(statearr_25038_25156[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (27))){
var inst_24816 = (state_25023[(13)]);
var state_25023__$1 = state_25023;
var statearr_25039_25157 = state_25023__$1;
(statearr_25039_25157[(2)] = inst_24816);

(statearr_25039_25157[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (1))){
var state_25023__$1 = state_25023;
var statearr_25040_25158 = state_25023__$1;
(statearr_25040_25158[(2)] = null);

(statearr_25040_25158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (69))){
var inst_24786 = (state_25023[(11)]);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24786)){
var statearr_25041_25159 = state_25023__$1;
(statearr_25041_25159[(1)] = (72));

} else {
var statearr_25042_25160 = state_25023__$1;
(statearr_25042_25160[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (24))){
var inst_24801 = (state_25023[(10)]);
var state_25023__$1 = state_25023;
var statearr_25043_25161 = state_25023__$1;
(statearr_25043_25161[(2)] = inst_24801);

(statearr_25043_25161[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (55))){
var inst_24955 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25044_25162 = state_25023__$1;
(statearr_25044_25162[(2)] = inst_24955);

(statearr_25044_25162[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (39))){
var inst_24963 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25045_25163 = state_25023__$1;
(statearr_25045_25163[(2)] = inst_24963);

(statearr_25045_25163[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (46))){
var inst_24827 = (state_25023[(14)]);
var inst_24845 = (state_25023[(15)]);
var inst_24921 = inst_24845.call(null,cljs.core._LT_,inst_24827);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24921)){
var statearr_25046_25164 = state_25023__$1;
(statearr_25046_25164[(1)] = (49));

} else {
var statearr_25047_25165 = state_25023__$1;
(statearr_25047_25165[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (4))){
var inst_24760 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25048_25166 = state_25023__$1;
(statearr_25048_25166[(2)] = inst_24760);

(statearr_25048_25166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (77))){
var inst_25011 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25049_25167 = state_25023__$1;
(statearr_25049_25167[(2)] = inst_25011);

(statearr_25049_25167[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (54))){
var inst_24953 = cljs.core.PersistentVector.EMPTY;
var state_25023__$1 = state_25023;
var statearr_25050_25168 = state_25023__$1;
(statearr_25050_25168[(2)] = inst_24953);

(statearr_25050_25168[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (15))){
var inst_24771 = (state_25023[(16)]);
var inst_24796 = cljs.core.seq.call(null,inst_24771);
var inst_24797 = cljs.core.first.call(null,inst_24796);
var inst_24798 = cljs.core.next.call(null,inst_24796);
var inst_24799 = cljs.core.PersistentHashSet.EMPTY;
var inst_24800 = inst_24771;
var inst_24801 = inst_24799;
var state_25023__$1 = (function (){var statearr_25051 = state_25023;
(statearr_25051[(17)] = inst_24797);

(statearr_25051[(18)] = inst_24800);

(statearr_25051[(10)] = inst_24801);

(statearr_25051[(19)] = inst_24798);

return statearr_25051;
})();
var statearr_25052_25169 = state_25023__$1;
(statearr_25052_25169[(2)] = null);

(statearr_25052_25169[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (48))){
var inst_24918 = (state_25023[(2)]);
var inst_24919 = fluree.db.util.async.throw_err.call(null,inst_24918);
var state_25023__$1 = state_25023;
var statearr_25053_25170 = state_25023__$1;
(statearr_25053_25170[(2)] = inst_24919);

(statearr_25053_25170[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (50))){
var inst_24827 = (state_25023[(14)]);
var inst_24845 = (state_25023[(15)]);
var inst_24937 = inst_24845.call(null,cljs.core._LT__EQ_,inst_24827);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24937)){
var statearr_25054_25171 = state_25023__$1;
(statearr_25054_25171[(1)] = (53));

} else {
var statearr_25055_25172 = state_25023__$1;
(statearr_25055_25172[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (75))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(offset)){
var statearr_25056_25173 = state_25023__$1;
(statearr_25056_25173[(1)] = (78));

} else {
var statearr_25057_25174 = state_25023__$1;
(statearr_25057_25174[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (21))){
var inst_24826 = (state_25023[(20)]);
var inst_24807 = (state_25023[(21)]);
var inst_24826__$1 = cljs.core.nth.call(null,inst_24807,(0),null);
var inst_24827 = cljs.core.nth.call(null,inst_24807,(1),null);
var inst_24828 = cljs.core.nth.call(null,inst_24807,(2),null);
var inst_24829 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_24826__$1);
var inst_24830 = cljs.core.not.call(null,inst_24829);
var state_25023__$1 = (function (){var statearr_25058 = state_25023;
(statearr_25058[(14)] = inst_24827);

(statearr_25058[(20)] = inst_24826__$1);

(statearr_25058[(22)] = inst_24828);

return statearr_25058;
})();
if(inst_24830){
var statearr_25059_25175 = state_25023__$1;
(statearr_25059_25175[(1)] = (29));

} else {
var statearr_25060_25176 = state_25023__$1;
(statearr_25060_25176[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (31))){
var inst_24827 = (state_25023[(14)]);
var inst_24845 = (state_25023[(15)]);
var inst_24841 = (state_25023[(2)]);
var inst_24845__$1 = cljs.core.identical_QMARK_;
var inst_24846 = inst_24845__$1.call(null,cljs.core.not_EQ_,inst_24827);
var state_25023__$1 = (function (){var statearr_25061 = state_25023;
(statearr_25061[(15)] = inst_24845__$1);

(statearr_25061[(23)] = inst_24841);

return statearr_25061;
})();
if(cljs.core.truth_(inst_24846)){
var statearr_25062_25177 = state_25023__$1;
(statearr_25062_25177[(1)] = (32));

} else {
var statearr_25063_25178 = state_25023__$1;
(statearr_25063_25178[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (32))){
var inst_24786 = (state_25023[(11)]);
var inst_24826 = (state_25023[(20)]);
var inst_24828 = (state_25023[(22)]);
var inst_24848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24849 = [inst_24826,inst_24828];
var inst_24850 = (new cljs.core.PersistentVector(null,2,(5),inst_24848,inst_24849,null));
var inst_24851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24852 = [inst_24826];
var inst_24853 = (new cljs.core.PersistentVector(null,1,(5),inst_24851,inst_24852,null));
var inst_24854 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24855 = [inst_24786];
var inst_24856 = cljs.core.PersistentHashMap.fromArrays(inst_24854,inst_24855);
var inst_24857 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24850,cljs.core._LT__EQ_,inst_24853,inst_24856);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(35),inst_24857);
} else {
if((state_val_25024 === (40))){
var inst_24886 = (state_25023[(2)]);
var inst_24887 = fluree.db.util.async.throw_err.call(null,inst_24886);
var state_25023__$1 = state_25023;
var statearr_25064_25179 = state_25023__$1;
(statearr_25064_25179[(2)] = inst_24887);

(statearr_25064_25179[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (56))){
var inst_24950 = (state_25023[(2)]);
var inst_24951 = fluree.db.util.async.throw_err.call(null,inst_24950);
var state_25023__$1 = state_25023;
var statearr_25065_25180 = state_25023__$1;
(statearr_25065_25180[(2)] = inst_24951);

(statearr_25065_25180[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (33))){
var inst_24827 = (state_25023[(14)]);
var inst_24845 = (state_25023[(15)]);
var inst_24876 = inst_24845.call(null,cljs.core._EQ_,inst_24827);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24876)){
var statearr_25066_25181 = state_25023__$1;
(statearr_25066_25181[(1)] = (37));

} else {
var statearr_25067_25182 = state_25023__$1;
(statearr_25067_25182[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (13))){
var state_25023__$1 = state_25023;
var statearr_25068_25183 = state_25023__$1;
(statearr_25068_25183[(2)] = limit);

(statearr_25068_25183[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (22))){
var inst_25013 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25069_25184 = state_25023__$1;
(statearr_25069_25184[(2)] = inst_25013);

(statearr_25069_25184[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (36))){
var inst_24860 = (state_25023[(24)]);
var inst_24872 = (state_25023[(2)]);
var inst_24873 = fluree.db.util.async.throw_err.call(null,inst_24872);
var inst_24874 = cljs.core.concat.call(null,inst_24860,inst_24873);
var state_25023__$1 = state_25023;
var statearr_25070_25185 = state_25023__$1;
(statearr_25070_25185[(2)] = inst_24874);

(statearr_25070_25185[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (41))){
var inst_24786 = (state_25023[(11)]);
var inst_24826 = (state_25023[(20)]);
var inst_24828 = (state_25023[(22)]);
var inst_24891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24892 = [inst_24826,inst_24828];
var inst_24893 = (new cljs.core.PersistentVector(null,2,(5),inst_24891,inst_24892,null));
var inst_24894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24895 = [inst_24826];
var inst_24896 = (new cljs.core.PersistentVector(null,1,(5),inst_24894,inst_24895,null));
var inst_24897 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24898 = [inst_24786];
var inst_24899 = cljs.core.PersistentHashMap.fromArrays(inst_24897,inst_24898);
var inst_24900 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24893,cljs.core._LT__EQ_,inst_24896,inst_24899);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(44),inst_24900);
} else {
if((state_val_25024 === (43))){
var inst_24961 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25071_25186 = state_25023__$1;
(statearr_25071_25186[(2)] = inst_24961);

(statearr_25071_25186[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (61))){
var inst_24966 = (state_25023[(12)]);
var inst_24801 = (state_25023[(10)]);
var inst_24973 = cljs.core.PersistentHashSet.EMPTY;
var inst_24974 = cljs.core.into.call(null,inst_24973,inst_24966);
var inst_24975 = clojure.set.intersection.call(null,inst_24801,inst_24974);
var state_25023__$1 = state_25023;
var statearr_25072_25187 = state_25023__$1;
(statearr_25072_25187[(2)] = inst_24975);

(statearr_25072_25187[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (29))){
var inst_24826 = (state_25023[(20)]);
var inst_24832 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24826);
var inst_24833 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24832)].join('');
var inst_24834 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24835 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24836 = cljs.core.PersistentHashMap.fromArrays(inst_24834,inst_24835);
var inst_24837 = cljs.core.ex_info.call(null,inst_24833,inst_24836);
var inst_24838 = (function(){throw inst_24837})();
var state_25023__$1 = state_25023;
var statearr_25073_25188 = state_25023__$1;
(statearr_25073_25188[(2)] = inst_24838);

(statearr_25073_25188[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (44))){
var inst_24902 = (state_25023[(2)]);
var inst_24903 = fluree.db.util.async.throw_err.call(null,inst_24902);
var state_25023__$1 = state_25023;
var statearr_25074_25189 = state_25023__$1;
(statearr_25074_25189[(2)] = inst_24903);

(statearr_25074_25189[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (6))){
var inst_24770 = (state_25023[(25)]);
var inst_24774 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24770);
var state_25023__$1 = state_25023;
var statearr_25075_25190 = state_25023__$1;
(statearr_25075_25190[(2)] = inst_24774);

(statearr_25075_25190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (28))){
var inst_24821 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25076_25191 = state_25023__$1;
(statearr_25076_25191[(2)] = inst_24821);

(statearr_25076_25191[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (64))){
var inst_24981 = (state_25023[(26)]);
var state_25023__$1 = state_25023;
var statearr_25077_25192 = state_25023__$1;
(statearr_25077_25192[(2)] = inst_24981);

(statearr_25077_25192[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (51))){
var inst_24957 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25078_25193 = state_25023__$1;
(statearr_25078_25193[(2)] = inst_24957);

(statearr_25078_25193[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (25))){
var inst_24816 = (state_25023[(2)]);
var state_25023__$1 = (function (){var statearr_25079 = state_25023;
(statearr_25079[(13)] = inst_24816);

return statearr_25079;
})();
if(cljs.core.truth_(limit)){
var statearr_25080_25194 = state_25023__$1;
(statearr_25080_25194[(1)] = (26));

} else {
var statearr_25081_25195 = state_25023__$1;
(statearr_25081_25195[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (34))){
var inst_24770 = (state_25023[(25)]);
var inst_24965 = (state_25023[(2)]);
var inst_24966 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_24965);
var state_25023__$1 = (function (){var statearr_25082 = state_25023;
(statearr_25082[(12)] = inst_24966);

return statearr_25082;
})();
var G__25083_25196 = inst_24770;
var G__25083_25197__$1 = (((G__25083_25196 instanceof cljs.core.Keyword))?G__25083_25196.fqn:null);
switch (G__25083_25197__$1) {
case "or":
var statearr_25084_25199 = state_25023__$1;
(statearr_25084_25199[(1)] = (58));


break;
case "and":
var statearr_25085_25200 = state_25023__$1;
(statearr_25085_25200[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25083_25197__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (17))){
var inst_25018 = (state_25023[(2)]);
var _ = (function (){var statearr_25086 = state_25023;
(statearr_25086[(4)] = cljs.core.rest.call(null,(state_25023[(4)])));

return statearr_25086;
})();
var state_25023__$1 = state_25023;
var statearr_25087_25201 = state_25023__$1;
(statearr_25087_25201[(2)] = inst_25018);

(statearr_25087_25201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (3))){
var inst_25021 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25023__$1,inst_25021);
} else {
if((state_val_25024 === (12))){
var inst_24780 = (offset + limit);
var state_25023__$1 = state_25023;
var statearr_25088_25202 = state_25023__$1;
(statearr_25088_25202[(2)] = inst_24780);

(statearr_25088_25202[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (2))){
var inst_24772 = (state_25023[(9)]);
var _ = (function (){var statearr_25089 = state_25023;
(statearr_25089[(4)] = cljs.core.cons.call(null,(5),(state_25023[(4)])));

return statearr_25089;
})();
var inst_24769 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_24770 = cljs.core.nth.call(null,inst_24769,(0),null);
var inst_24771 = cljs.core.nth.call(null,inst_24769,(1),null);
var inst_24772__$1 = limit;
var state_25023__$1 = (function (){var statearr_25090 = state_25023;
(statearr_25090[(16)] = inst_24771);

(statearr_25090[(25)] = inst_24770);

(statearr_25090[(9)] = inst_24772__$1);

return statearr_25090;
})();
if(cljs.core.truth_(inst_24772__$1)){
var statearr_25091_25203 = state_25023__$1;
(statearr_25091_25203[(1)] = (6));

} else {
var statearr_25092_25204 = state_25023__$1;
(statearr_25092_25204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (66))){
var inst_24986 = (state_25023[(7)]);
var state_25023__$1 = state_25023;
var statearr_25093_25205 = state_25023__$1;
(statearr_25093_25205[(2)] = inst_24986);

(statearr_25093_25205[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (23))){
var inst_24801 = (state_25023[(10)]);
var inst_24813 = cljs.core.drop.call(null,offset,inst_24801);
var state_25023__$1 = state_25023;
var statearr_25094_25206 = state_25023__$1;
(statearr_25094_25206[(2)] = inst_24813);

(statearr_25094_25206[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (47))){
var inst_24959 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25095_25207 = state_25023__$1;
(statearr_25095_25207[(2)] = inst_24959);

(statearr_25095_25207[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (35))){
var inst_24786 = (state_25023[(11)]);
var inst_24826 = (state_25023[(20)]);
var inst_24828 = (state_25023[(22)]);
var inst_24859 = (state_25023[(2)]);
var inst_24860 = fluree.db.util.async.throw_err.call(null,inst_24859);
var inst_24861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24862 = [inst_24826];
var inst_24863 = (new cljs.core.PersistentVector(null,1,(5),inst_24861,inst_24862,null));
var inst_24864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24865 = [inst_24826,inst_24828];
var inst_24866 = (new cljs.core.PersistentVector(null,2,(5),inst_24864,inst_24865,null));
var inst_24867 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24868 = [inst_24786];
var inst_24869 = cljs.core.PersistentHashMap.fromArrays(inst_24867,inst_24868);
var inst_24870 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24863,cljs.core._LT_,inst_24866,inst_24869);
var state_25023__$1 = (function (){var statearr_25096 = state_25023;
(statearr_25096[(24)] = inst_24860);

return statearr_25096;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(36),inst_24870);
} else {
if((state_val_25024 === (76))){
var inst_24980 = (state_25023[(27)]);
var inst_24808 = (state_25023[(28)]);
var inst_24800 = inst_24808;
var inst_24801 = inst_24980;
var state_25023__$1 = (function (){var statearr_25097 = state_25023;
(statearr_25097[(18)] = inst_24800);

(statearr_25097[(10)] = inst_24801);

return statearr_25097;
})();
var statearr_25098_25208 = state_25023__$1;
(statearr_25098_25208[(2)] = null);

(statearr_25098_25208[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (19))){
var inst_25015 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25099_25209 = state_25023__$1;
(statearr_25099_25209[(2)] = inst_25015);

(statearr_25099_25209[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (57))){
var inst_24981 = (state_25023[(26)]);
var inst_24770 = (state_25023[(25)]);
var inst_24980 = (state_25023[(2)]);
var inst_24981__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24770);
var state_25023__$1 = (function (){var statearr_25100 = state_25023;
(statearr_25100[(26)] = inst_24981__$1);

(statearr_25100[(27)] = inst_24980);

return statearr_25100;
})();
if(inst_24981__$1){
var statearr_25101_25210 = state_25023__$1;
(statearr_25101_25210[(1)] = (63));

} else {
var statearr_25102_25211 = state_25023__$1;
(statearr_25102_25211[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (68))){
var inst_25001 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_25001)){
var statearr_25103_25212 = state_25023__$1;
(statearr_25103_25212[(1)] = (75));

} else {
var statearr_25104_25213 = state_25023__$1;
(statearr_25104_25213[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (11))){
var inst_24771 = (state_25023[(16)]);
var inst_24786 = (state_25023[(2)]);
var inst_24787 = cljs.core.not_empty.call(null,inst_24771);
var state_25023__$1 = (function (){var statearr_25106 = state_25023;
(statearr_25106[(11)] = inst_24786);

return statearr_25106;
})();
if(cljs.core.truth_(inst_24787)){
var statearr_25107_25214 = state_25023__$1;
(statearr_25107_25214[(1)] = (15));

} else {
var statearr_25108_25215 = state_25023__$1;
(statearr_25108_25215[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (9))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(offset)){
var statearr_25109_25216 = state_25023__$1;
(statearr_25109_25216[(1)] = (12));

} else {
var statearr_25110_25217 = state_25023__$1;
(statearr_25110_25217[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (5))){
var _ = (function (){var statearr_25111 = state_25023;
(statearr_25111[(4)] = cljs.core.rest.call(null,(state_25023[(4)])));

return statearr_25111;
})();
var state_25023__$1 = state_25023;
var ex25105 = (state_25023__$1[(2)]);
var statearr_25112_25218 = state_25023__$1;
(statearr_25112_25218[(5)] = ex25105);


if((ex25105 instanceof Error)){
var statearr_25113_25219 = state_25023__$1;
(statearr_25113_25219[(1)] = (4));

(statearr_25113_25219[(5)] = null);

} else {
throw ex25105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (14))){
var inst_24783 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25114_25220 = state_25023__$1;
(statearr_25114_25220[(2)] = inst_24783);

(statearr_25114_25220[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (45))){
var inst_24786 = (state_25023[(11)]);
var inst_24826 = (state_25023[(20)]);
var inst_24828 = (state_25023[(22)]);
var inst_24907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24908 = [inst_24826,inst_24828];
var inst_24909 = (new cljs.core.PersistentVector(null,2,(5),inst_24907,inst_24908,null));
var inst_24910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24911 = [inst_24826];
var inst_24912 = (new cljs.core.PersistentVector(null,1,(5),inst_24910,inst_24911,null));
var inst_24913 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24914 = [inst_24786];
var inst_24915 = cljs.core.PersistentHashMap.fromArrays(inst_24913,inst_24914);
var inst_24916 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24909,cljs.core._LT__EQ_,inst_24912,inst_24915);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(48),inst_24916);
} else {
if((state_val_25024 === (53))){
var inst_24786 = (state_25023[(11)]);
var inst_24826 = (state_25023[(20)]);
var inst_24828 = (state_25023[(22)]);
var inst_24939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24940 = [inst_24826];
var inst_24941 = (new cljs.core.PersistentVector(null,1,(5),inst_24939,inst_24940,null));
var inst_24942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24943 = [inst_24826,inst_24828];
var inst_24944 = (new cljs.core.PersistentVector(null,2,(5),inst_24942,inst_24943,null));
var inst_24945 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24946 = [inst_24786];
var inst_24947 = cljs.core.PersistentHashMap.fromArrays(inst_24945,inst_24946);
var inst_24948 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24941,cljs.core._LT__EQ_,inst_24944,inst_24947);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(56),inst_24948);
} else {
if((state_val_25024 === (78))){
var inst_24980 = (state_25023[(27)]);
var inst_25004 = cljs.core.drop.call(null,offset,inst_24980);
var state_25023__$1 = state_25023;
var statearr_25115_25221 = state_25023__$1;
(statearr_25115_25221[(2)] = inst_25004);

(statearr_25115_25221[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (26))){
var inst_24816 = (state_25023[(13)]);
var inst_24818 = cljs.core.take.call(null,limit,inst_24816);
var state_25023__$1 = state_25023;
var statearr_25116_25222 = state_25023__$1;
(statearr_25116_25222[(2)] = inst_24818);

(statearr_25116_25222[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (16))){
var state_25023__$1 = state_25023;
var statearr_25117_25223 = state_25023__$1;
(statearr_25117_25223[(2)] = null);

(statearr_25117_25223[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (79))){
var inst_24980 = (state_25023[(27)]);
var state_25023__$1 = state_25023;
var statearr_25118_25224 = state_25023__$1;
(statearr_25118_25224[(2)] = inst_24980);

(statearr_25118_25224[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (38))){
var inst_24827 = (state_25023[(14)]);
var inst_24845 = (state_25023[(15)]);
var inst_24889 = inst_24845.call(null,cljs.core._GT_,inst_24827);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24889)){
var statearr_25119_25225 = state_25023__$1;
(statearr_25119_25225[(1)] = (41));

} else {
var statearr_25120_25226 = state_25023__$1;
(statearr_25120_25226[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (30))){
var state_25023__$1 = state_25023;
var statearr_25121_25227 = state_25023__$1;
(statearr_25121_25227[(2)] = null);

(statearr_25121_25227[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (73))){
var inst_24786 = (state_25023[(11)]);
var state_25023__$1 = state_25023;
var statearr_25122_25228 = state_25023__$1;
(statearr_25122_25228[(2)] = inst_24786);

(statearr_25122_25228[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (10))){
var state_25023__$1 = state_25023;
var statearr_25123_25229 = state_25023__$1;
(statearr_25123_25229[(2)] = null);

(statearr_25123_25229[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (18))){
var inst_24800 = (state_25023[(18)]);
var inst_24807 = (state_25023[(21)]);
var inst_24806 = cljs.core.seq.call(null,inst_24800);
var inst_24807__$1 = cljs.core.first.call(null,inst_24806);
var inst_24808 = cljs.core.next.call(null,inst_24806);
var inst_24809 = cljs.core.not.call(null,inst_24807__$1);
var state_25023__$1 = (function (){var statearr_25124 = state_25023;
(statearr_25124[(28)] = inst_24808);

(statearr_25124[(21)] = inst_24807__$1);

return statearr_25124;
})();
if(inst_24809){
var statearr_25125_25230 = state_25023__$1;
(statearr_25125_25230[(1)] = (20));

} else {
var statearr_25126_25231 = state_25023__$1;
(statearr_25126_25231[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (52))){
var inst_24934 = (state_25023[(2)]);
var inst_24935 = fluree.db.util.async.throw_err.call(null,inst_24934);
var state_25023__$1 = state_25023;
var statearr_25127_25232 = state_25023__$1;
(statearr_25127_25232[(2)] = inst_24935);

(statearr_25127_25232[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (67))){
var inst_24770 = (state_25023[(25)]);
var inst_24989 = (state_25023[(8)]);
var inst_24989__$1 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24770);
var state_25023__$1 = (function (){var statearr_25128 = state_25023;
(statearr_25128[(8)] = inst_24989__$1);

return statearr_25128;
})();
if(inst_24989__$1){
var statearr_25129_25233 = state_25023__$1;
(statearr_25129_25233[(1)] = (69));

} else {
var statearr_25130_25234 = state_25023__$1;
(statearr_25130_25234[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (71))){
var inst_24999 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25131_25235 = state_25023__$1;
(statearr_25131_25235[(2)] = inst_24999);

(statearr_25131_25235[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (42))){
var inst_24827 = (state_25023[(14)]);
var inst_24845 = (state_25023[(15)]);
var inst_24905 = inst_24845.call(null,cljs.core._GT__EQ_,inst_24827);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24905)){
var statearr_25132_25236 = state_25023__$1;
(statearr_25132_25236[(1)] = (45));

} else {
var statearr_25133_25237 = state_25023__$1;
(statearr_25133_25237[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (80))){
var inst_25007 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25134_25238 = state_25023__$1;
(statearr_25134_25238[(2)] = inst_25007);

(statearr_25134_25238[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (37))){
var inst_24786 = (state_25023[(11)]);
var inst_24826 = (state_25023[(20)]);
var inst_24828 = (state_25023[(22)]);
var inst_24878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24879 = [inst_24826,inst_24828];
var inst_24880 = (new cljs.core.PersistentVector(null,2,(5),inst_24878,inst_24879,null));
var inst_24881 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24882 = [inst_24786];
var inst_24883 = cljs.core.PersistentHashMap.fromArrays(inst_24881,inst_24882);
var inst_24884 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24880,inst_24883);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(40),inst_24884);
} else {
if((state_val_25024 === (63))){
var inst_24980 = (state_25023[(27)]);
var inst_24983 = cljs.core.empty_QMARK_.call(null,inst_24980);
var state_25023__$1 = state_25023;
var statearr_25135_25239 = state_25023__$1;
(statearr_25135_25239[(2)] = inst_24983);

(statearr_25135_25239[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (8))){
var inst_24777 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24777)){
var statearr_25136_25240 = state_25023__$1;
(statearr_25136_25240[(1)] = (9));

} else {
var statearr_25137_25241 = state_25023__$1;
(statearr_25137_25241[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (49))){
var inst_24786 = (state_25023[(11)]);
var inst_24826 = (state_25023[(20)]);
var inst_24828 = (state_25023[(22)]);
var inst_24923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24924 = [inst_24826];
var inst_24925 = (new cljs.core.PersistentVector(null,1,(5),inst_24923,inst_24924,null));
var inst_24926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24927 = [inst_24826,inst_24828];
var inst_24928 = (new cljs.core.PersistentVector(null,2,(5),inst_24926,inst_24927,null));
var inst_24929 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24930 = [inst_24786];
var inst_24931 = cljs.core.PersistentHashMap.fromArrays(inst_24929,inst_24930);
var inst_24932 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24925,cljs.core._LT_,inst_24928,inst_24931);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(52),inst_24932);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2703__auto__ = null;
var fluree$db$query$fql$state_machine__2703__auto____0 = (function (){
var statearr_25138 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25138[(0)] = fluree$db$query$fql$state_machine__2703__auto__);

(statearr_25138[(1)] = (1));

return statearr_25138;
});
var fluree$db$query$fql$state_machine__2703__auto____1 = (function (state_25023){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_25023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e25139){var ex__2706__auto__ = e25139;
var statearr_25140_25242 = state_25023;
(statearr_25140_25242[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_25023[(4)]))){
var statearr_25141_25243 = state_25023;
(statearr_25141_25243[(1)] = cljs.core.first.call(null,(state_25023[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25244 = state_25023;
state_25023 = G__25244;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2703__auto__ = function(state_25023){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2703__auto____1.call(this,state_25023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2703__auto____0;
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2703__auto____1;
return fluree$db$query$fql$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_25142 = f__2726__auto__.call(null);
(statearr_25142[(6)] = c__2725__auto__);

return statearr_25142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__25245_SHARP_){
return ((typeof p1__25245_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__25245_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__25246_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__25246_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__25250 = vars;
var vec__25251 = G__25250;
var seq__25252 = cljs.core.seq.call(null,vec__25251);
var first__25253 = cljs.core.first.call(null,seq__25252);
var seq__25252__$1 = cljs.core.next.call(null,seq__25252);
var var$ = first__25253;
var r = seq__25252__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__25250__$1 = G__25250;
var all_vars__$1 = all_vars;
while(true){
var vec__25257 = G__25250__$1;
var seq__25258 = cljs.core.seq.call(null,vec__25257);
var first__25259 = cljs.core.first.call(null,seq__25258);
var seq__25258__$1 = cljs.core.next.call(null,seq__25258);
var var$__$1 = first__25259;
var r__$1 = seq__25258__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__25260 = r__$1;
var G__25261 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__25250__$1 = G__25260;
all_vars__$1 = G__25261;
continue;
} else {
var G__25262 = r__$1;
var G__25263 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__25250__$1 = G__25262;
all_vars__$1 = G__25263;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_25298){
var state_val_25299 = (state_25298[(1)]);
if((state_val_25299 === (1))){
var inst_25271 = functionArray;
var inst_25272 = cljs.core.seq.call(null,inst_25271);
var inst_25273 = cljs.core.first.call(null,inst_25272);
var inst_25274 = cljs.core.next.call(null,inst_25272);
var inst_25275 = cljs.core.PersistentVector.EMPTY;
var inst_25276 = inst_25271;
var inst_25277 = inst_25275;
var state_25298__$1 = (function (){var statearr_25300 = state_25298;
(statearr_25300[(7)] = inst_25276);

(statearr_25300[(8)] = inst_25273);

(statearr_25300[(9)] = inst_25274);

(statearr_25300[(10)] = inst_25277);

return statearr_25300;
})();
var statearr_25301_25314 = state_25298__$1;
(statearr_25301_25314[(2)] = null);

(statearr_25301_25314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (2))){
var inst_25276 = (state_25298[(7)]);
var inst_25283 = (state_25298[(11)]);
var inst_25282 = cljs.core.seq.call(null,inst_25276);
var inst_25283__$1 = cljs.core.first.call(null,inst_25282);
var inst_25284 = cljs.core.next.call(null,inst_25282);
var state_25298__$1 = (function (){var statearr_25302 = state_25298;
(statearr_25302[(12)] = inst_25284);

(statearr_25302[(11)] = inst_25283__$1);

return statearr_25302;
})();
if(cljs.core.truth_(inst_25283__$1)){
var statearr_25303_25315 = state_25298__$1;
(statearr_25303_25315[(1)] = (4));

} else {
var statearr_25304_25316 = state_25298__$1;
(statearr_25304_25316[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (3))){
var inst_25296 = (state_25298[(2)]);
var state_25298__$1 = state_25298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25298__$1,inst_25296);
} else {
if((state_val_25299 === (4))){
var inst_25283 = (state_25298[(11)]);
var inst_25286 = inst_25283.call(null,tuple);
var state_25298__$1 = state_25298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25298__$1,(7),inst_25286);
} else {
if((state_val_25299 === (5))){
var inst_25277 = (state_25298[(10)]);
var state_25298__$1 = state_25298;
var statearr_25305_25317 = state_25298__$1;
(statearr_25305_25317[(2)] = inst_25277);

(statearr_25305_25317[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (6))){
var inst_25294 = (state_25298[(2)]);
var state_25298__$1 = state_25298;
var statearr_25306_25318 = state_25298__$1;
(statearr_25306_25318[(2)] = inst_25294);

(statearr_25306_25318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (7))){
var inst_25284 = (state_25298[(12)]);
var inst_25277 = (state_25298[(10)]);
var inst_25288 = (state_25298[(2)]);
var inst_25289 = fluree.db.util.async.throw_err.call(null,inst_25288);
var inst_25290 = cljs.core.conj.call(null,inst_25277,inst_25289);
var inst_25276 = inst_25284;
var inst_25277__$1 = inst_25290;
var state_25298__$1 = (function (){var statearr_25307 = state_25298;
(statearr_25307[(7)] = inst_25276);

(statearr_25307[(10)] = inst_25277__$1);

return statearr_25307;
})();
var statearr_25308_25319 = state_25298__$1;
(statearr_25308_25319[(2)] = null);

(statearr_25308_25319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2703__auto____0 = (function (){
var statearr_25309 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25309[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2703__auto__);

(statearr_25309[(1)] = (1));

return statearr_25309;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2703__auto____1 = (function (state_25298){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_25298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e25310){var ex__2706__auto__ = e25310;
var statearr_25311_25320 = state_25298;
(statearr_25311_25320[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_25298[(4)]))){
var statearr_25312_25321 = state_25298;
(statearr_25312_25321[(1)] = cljs.core.first.call(null,(state_25298[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25322 = state_25298;
state_25298 = G__25322;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2703__auto__ = function(state_25298){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2703__auto____1.call(this,state_25298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2703__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2703__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_25313 = f__2726__auto__.call(null);
(statearr_25313[(6)] = c__2725__auto__);

return statearr_25313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__25323){
var vec__25324 = p__25323;
var tuple_index = cljs.core.nth.call(null,vec__25324,(0),null);
var query_map = cljs.core.nth.call(null,vec__25324,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_25338){
var state_val_25339 = (state_25338[(1)]);
if((state_val_25339 === (1))){
var inst_25327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25328 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_25329 = [query_map,_id,query_opts];
var inst_25330 = cljs.core.PersistentHashMap.fromArrays(inst_25328,inst_25329);
var inst_25331 = fluree.db.query.fql.query.call(null,db,inst_25330);
var state_25338__$1 = (function (){var statearr_25340 = state_25338;
(statearr_25340[(7)] = inst_25327);

return statearr_25340;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25338__$1,(2),inst_25331);
} else {
if((state_val_25339 === (2))){
var inst_25327 = (state_25338[(7)]);
var inst_25333 = (state_25338[(2)]);
var inst_25334 = fluree.db.util.async.throw_err.call(null,inst_25333);
var inst_25335 = [tuple_index,inst_25334];
var inst_25336 = (new cljs.core.PersistentVector(null,2,(5),inst_25327,inst_25335,null));
var state_25338__$1 = state_25338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25338__$1,inst_25336);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2703__auto____0 = (function (){
var statearr_25341 = [null,null,null,null,null,null,null,null];
(statearr_25341[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2703__auto__);

(statearr_25341[(1)] = (1));

return statearr_25341;
});
var fluree$db$query$fql$expand_map_$_state_machine__2703__auto____1 = (function (state_25338){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_25338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e25342){var ex__2706__auto__ = e25342;
var statearr_25343_25346 = state_25338;
(statearr_25343_25346[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_25338[(4)]))){
var statearr_25344_25347 = state_25338;
(statearr_25344_25347[(1)] = cljs.core.first.call(null,(state_25338[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25348 = state_25338;
state_25338 = G__25348;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2703__auto__ = function(state_25338){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2703__auto____1.call(this,state_25338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2703__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2703__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_25345 = f__2726__auto__.call(null);
(statearr_25345[(6)] = c__2725__auto__);

return statearr_25345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__25349 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__25349,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__25349,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_25412){
var state_val_25413 = (state_25412[(1)]);
if((state_val_25413 === (7))){
var inst_25407 = (state_25412[(2)]);
var _ = (function (){var statearr_25414 = state_25412;
(statearr_25414[(4)] = cljs.core.rest.call(null,(state_25412[(4)])));

return statearr_25414;
})();
var state_25412__$1 = state_25412;
var statearr_25415_25506 = state_25412__$1;
(statearr_25415_25506[(2)] = inst_25407);

(statearr_25415_25506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (20))){
var inst_25398 = (state_25412[(2)]);
var state_25412__$1 = state_25412;
var statearr_25416_25507 = state_25412__$1;
(statearr_25416_25507[(2)] = inst_25398);

(statearr_25416_25507[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (1))){
var state_25412__$1 = state_25412;
var statearr_25417_25508 = state_25412__$1;
(statearr_25417_25508[(2)] = null);

(statearr_25417_25508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (4))){
var inst_25354 = (state_25412[(2)]);
var state_25412__$1 = state_25412;
var statearr_25418_25509 = state_25412__$1;
(statearr_25418_25509[(2)] = inst_25354);

(statearr_25418_25509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (15))){
var inst_25374 = (state_25412[(7)]);
var inst_25383 = cljs.core.second.call(null,inst_25374);
var inst_25384 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_25383);
var inst_25385 = (inst_25384 > max_fuel);
var state_25412__$1 = state_25412;
if(cljs.core.truth_(inst_25385)){
var statearr_25419_25510 = state_25412__$1;
(statearr_25419_25510[(1)] = (18));

} else {
var statearr_25420_25511 = state_25412__$1;
(statearr_25420_25511[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (13))){
var state_25412__$1 = state_25412;
var statearr_25421_25512 = state_25412__$1;
(statearr_25421_25512[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (6))){
var inst_25362 = (state_25412[(8)]);
var state_25412__$1 = state_25412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25412__$1,(8),inst_25362);
} else {
if((state_val_25413 === (17))){
var inst_25401 = (state_25412[(2)]);
var state_25412__$1 = state_25412;
var statearr_25423_25513 = state_25412__$1;
(statearr_25423_25513[(2)] = inst_25401);

(statearr_25423_25513[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (3))){
var inst_25410 = (state_25412[(2)]);
var state_25412__$1 = state_25412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25412__$1,inst_25410);
} else {
if((state_val_25413 === (12))){
var inst_25374 = (state_25412[(7)]);
var inst_25363 = (state_25412[(9)]);
var inst_25380 = inst_25363.call(null);
var state_25412__$1 = (function (){var statearr_25424 = state_25412;
(statearr_25424[(10)] = inst_25380);

return statearr_25424;
})();
var statearr_25425_25514 = state_25412__$1;
(statearr_25425_25514[(2)] = inst_25374);

(statearr_25425_25514[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (2))){
var inst_25362 = (state_25412[(8)]);
var inst_25363 = (state_25412[(9)]);
var _ = (function (){var statearr_25426 = state_25412;
(statearr_25426[(4)] = cljs.core.cons.call(null,(5),(state_25412[(4)])));

return statearr_25426;
})();
var inst_25360 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_25361 = cljs.core.async.chan.call(null);
var inst_25362__$1 = cljs.core.async.chan.call(null);
var inst_25363__$1 = (function (){var expandMaps = inst_25360;
var queue_ch = inst_25361;
var res_ch = inst_25362__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_25364 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_25365 = cljs.core.volatile_BANG_.call(null,(0));
var inst_25366 = cljs.core.assoc.call(null,inst_25364,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_25365);
var inst_25367 = (function (){var expandMaps = inst_25360;
var queue_ch = inst_25361;
var res_ch = inst_25362__$1;
var stop_BANG_ = inst_25363__$1;
var opts_STAR_ = inst_25366;
return (function (tuple_res,port){
var c__2725__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_25459){
var state_val_25460 = (state_25459[(1)]);
if((state_val_25460 === (7))){
var state_25459__$1 = state_25459;
var statearr_25461_25515 = state_25459__$1;
(statearr_25461_25515[(2)] = tuple_res);

(statearr_25461_25515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25460 === (1))){
var state_25459__$1 = state_25459;
var statearr_25462_25516 = state_25459__$1;
(statearr_25462_25516[(2)] = null);

(statearr_25462_25516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25460 === (4))){
var inst_25427 = (state_25459[(2)]);
var inst_25428 = cljs.core.async.put_BANG_.call(null,port,inst_25427);
var inst_25429 = cljs.core.async.close_BANG_.call(null,port);
var state_25459__$1 = (function (){var statearr_25463 = state_25459;
(statearr_25463[(7)] = inst_25428);

return statearr_25463;
})();
var statearr_25464_25517 = state_25459__$1;
(statearr_25464_25517[(2)] = inst_25429);

(statearr_25464_25517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25460 === (6))){
var inst_25436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25437 = [tuple_res];
var inst_25438 = (new cljs.core.PersistentVector(null,1,(5),inst_25436,inst_25437,null));
var state_25459__$1 = state_25459;
var statearr_25465_25518 = state_25459__$1;
(statearr_25465_25518[(2)] = inst_25438);

(statearr_25465_25518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25460 === (3))){
var inst_25457 = (state_25459[(2)]);
var state_25459__$1 = state_25459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25459__$1,inst_25457);
} else {
if((state_val_25460 === (2))){
var ___$1 = (function (){var statearr_25467 = state_25459;
(statearr_25467[(4)] = cljs.core.cons.call(null,(5),(state_25459[(4)])));

return statearr_25467;
})();
var state_25459__$1 = state_25459;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_25468_25519 = state_25459__$1;
(statearr_25468_25519[(1)] = (6));

} else {
var statearr_25469_25520 = state_25459__$1;
(statearr_25469_25520[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25460 === (9))){
var inst_25441 = (state_25459[(8)]);
var inst_25443 = (state_25459[(9)]);
var inst_25450 = (state_25459[(2)]);
var inst_25451 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_25441,inst_25450);
var inst_25452 = inst_25443.call(null,inst_25451);
var inst_25453 = cljs.core.async.put_BANG_.call(null,port,inst_25452);
var inst_25454 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_25470 = state_25459;
(statearr_25470[(4)] = cljs.core.rest.call(null,(state_25459[(4)])));

return statearr_25470;
})();
var state_25459__$1 = (function (){var statearr_25471 = state_25459;
(statearr_25471[(10)] = inst_25453);

return statearr_25471;
})();
var statearr_25472_25521 = state_25459__$1;
(statearr_25472_25521[(2)] = inst_25454);

(statearr_25472_25521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25460 === (5))){
var ___$1 = (function (){var statearr_25473 = state_25459;
(statearr_25473[(4)] = cljs.core.rest.call(null,(state_25459[(4)])));

return statearr_25473;
})();
var state_25459__$1 = state_25459;
var ex25466 = (state_25459__$1[(2)]);
var statearr_25474_25522 = state_25459__$1;
(statearr_25474_25522[(5)] = ex25466);


var statearr_25475_25523 = state_25459__$1;
(statearr_25475_25523[(1)] = (4));

(statearr_25475_25523[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25460 === (8))){
var inst_25441 = (state_25459[(8)]);
var inst_25441__$1 = (state_25459[(2)]);
var inst_25442 = cljs.core.volatile_BANG_.call(null,(0));
var inst_25443 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25441__$1;
var query_fuel = inst_25442;
return (function (p1__25353_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__25353_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25353_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_25444 = cljs.core.PersistentVector.EMPTY;
var inst_25445 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25441__$1;
var query_fuel = inst_25442;
return (function (p1__25352_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__25352_SHARP_);
});
})();
var inst_25446 = cljs.core.keep.call(null,inst_25445,expandMaps);
var inst_25447 = cljs.core.async.merge.call(null,inst_25446);
var inst_25448 = cljs.core.async.into.call(null,inst_25444,inst_25447);
var state_25459__$1 = (function (){var statearr_25476 = state_25459;
(statearr_25476[(8)] = inst_25441__$1);

(statearr_25476[(9)] = inst_25443);

return statearr_25476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25459__$1,(9),inst_25448);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____0 = (function (){
var statearr_25477 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25477[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__);

(statearr_25477[(1)] = (1));

return statearr_25477;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____1 = (function (state_25459){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_25459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e25478){var ex__2706__auto__ = e25478;
var statearr_25479_25524 = state_25459;
(statearr_25479_25524[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_25459[(4)]))){
var statearr_25480_25525 = state_25459;
(statearr_25480_25525[(1)] = cljs.core.first.call(null,(state_25459[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25526 = state_25459;
state_25459 = G__25526;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__ = function(state_25459){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____1.call(this,state_25459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_25481 = f__2726__auto__.call(null);
(statearr_25481[(6)] = c__2725__auto____$1);

return statearr_25481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto____$1;
});
})();
var inst_25368 = cljs.core.async.onto_chan_BANG_.call(null,inst_25361,tuples_res);
var inst_25369 = cljs.core.async.pipeline_async.call(null,parallelism,inst_25362__$1,inst_25367,inst_25361);
var inst_25370 = cljs.core.PersistentVector.EMPTY;
var inst_25371 = inst_25370;
var state_25412__$1 = (function (){var statearr_25482 = state_25412;
(statearr_25482[(8)] = inst_25362__$1);

(statearr_25482[(11)] = inst_25371);

(statearr_25482[(9)] = inst_25363__$1);

(statearr_25482[(12)] = inst_25369);

(statearr_25482[(13)] = inst_25368);

return statearr_25482;
})();
var statearr_25483_25527 = state_25412__$1;
(statearr_25483_25527[(2)] = null);

(statearr_25483_25527[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (19))){
var inst_25374 = (state_25412[(7)]);
var inst_25371 = (state_25412[(11)]);
var inst_25394 = cljs.core.first.call(null,inst_25374);
var inst_25395 = cljs.core.conj.call(null,inst_25371,inst_25394);
var inst_25371__$1 = inst_25395;
var state_25412__$1 = (function (){var statearr_25484 = state_25412;
(statearr_25484[(11)] = inst_25371__$1);

return statearr_25484;
})();
var statearr_25485_25528 = state_25412__$1;
(statearr_25485_25528[(2)] = null);

(statearr_25485_25528[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (11))){
var inst_25405 = (state_25412[(2)]);
var state_25412__$1 = state_25412;
var statearr_25487_25529 = state_25412__$1;
(statearr_25487_25529[(2)] = inst_25405);

(statearr_25487_25529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (9))){
var inst_25371 = (state_25412[(11)]);
var state_25412__$1 = state_25412;
var statearr_25488_25530 = state_25412__$1;
(statearr_25488_25530[(2)] = inst_25371);

(statearr_25488_25530[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (5))){
var _ = (function (){var statearr_25489 = state_25412;
(statearr_25489[(4)] = cljs.core.rest.call(null,(state_25412[(4)])));

return statearr_25489;
})();
var state_25412__$1 = state_25412;
var ex25486 = (state_25412__$1[(2)]);
var statearr_25490_25531 = state_25412__$1;
(statearr_25490_25531[(5)] = ex25486);


if((ex25486 instanceof Error)){
var statearr_25491_25532 = state_25412__$1;
(statearr_25491_25532[(1)] = (4));

(statearr_25491_25532[(5)] = null);

} else {
throw ex25486;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (14))){
var inst_25403 = (state_25412[(2)]);
var state_25412__$1 = state_25412;
var statearr_25492_25533 = state_25412__$1;
(statearr_25492_25533[(2)] = inst_25403);

(statearr_25492_25533[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (16))){
var state_25412__$1 = state_25412;
var statearr_25493_25534 = state_25412__$1;
(statearr_25493_25534[(2)] = null);

(statearr_25493_25534[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (10))){
var inst_25374 = (state_25412[(7)]);
var inst_25378 = fluree.db.util.core.exception_QMARK_.call(null,inst_25374);
var state_25412__$1 = state_25412;
if(inst_25378){
var statearr_25494_25535 = state_25412__$1;
(statearr_25494_25535[(1)] = (12));

} else {
var statearr_25495_25536 = state_25412__$1;
(statearr_25495_25536[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (18))){
var inst_25363 = (state_25412[(9)]);
var inst_25387 = inst_25363.call(null);
var inst_25388 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_25389 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25390 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_25391 = cljs.core.PersistentHashMap.fromArrays(inst_25389,inst_25390);
var inst_25392 = cljs.core.ex_info.call(null,inst_25388,inst_25391);
var state_25412__$1 = (function (){var statearr_25496 = state_25412;
(statearr_25496[(14)] = inst_25387);

return statearr_25496;
})();
var statearr_25497_25537 = state_25412__$1;
(statearr_25497_25537[(2)] = inst_25392);

(statearr_25497_25537[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25413 === (8))){
var inst_25374 = (state_25412[(7)]);
var inst_25374__$1 = (state_25412[(2)]);
var inst_25375 = (inst_25374__$1 == null);
var state_25412__$1 = (function (){var statearr_25498 = state_25412;
(statearr_25498[(7)] = inst_25374__$1);

return statearr_25498;
})();
if(cljs.core.truth_(inst_25375)){
var statearr_25499_25538 = state_25412__$1;
(statearr_25499_25538[(1)] = (9));

} else {
var statearr_25500_25539 = state_25412__$1;
(statearr_25500_25539[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____0 = (function (){
var statearr_25501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25501[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__);

(statearr_25501[(1)] = (1));

return statearr_25501;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____1 = (function (state_25412){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_25412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e25502){var ex__2706__auto__ = e25502;
var statearr_25503_25540 = state_25412;
(statearr_25503_25540[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_25412[(4)]))){
var statearr_25504_25541 = state_25412;
(statearr_25504_25541[(1)] = cljs.core.first.call(null,(state_25412[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25542 = state_25412;
state_25412 = G__25542;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__ = function(state_25412){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____1.call(this,state_25412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_25505 = f__2726__auto__.call(null);
(statearr_25505[(6)] = c__2725__auto__);

return statearr_25505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25543 = select;
var map__25543__$1 = cljs.core.__destructure_map.call(null,map__25543);
var as = cljs.core.get.call(null,map__25543__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__25543__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__25543__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25546 = orderBy;
var order = cljs.core.nth.call(null,vec__25546,(0),null);
var var$ = cljs.core.nth.call(null,vec__25546,(1),null);
var option = cljs.core.nth.call(null,vec__25546,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25544_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__25544_SHARP_,compare_idx));
}):(function (p1__25545_SHARP_){
return cljs.core.nth.call(null,p1__25545_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25551 = arguments.length;
switch (G__25551) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25552,p__25553,group_limit,opts){
var map__25554 = p__25552;
var map__25554__$1 = cljs.core.__destructure_map.call(null,map__25554);
var res = map__25554__$1;
var vars = cljs.core.get.call(null,map__25554__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25555 = p__25553;
var map__25555__$1 = cljs.core.__destructure_map.call(null,map__25555);
var select_spec = map__25555__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__25555__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_25692){
var state_val_25693 = (state_25692[(1)]);
if((state_val_25693 === (7))){
var inst_25562 = (state_25692[(7)]);
var state_25692__$1 = state_25692;
var statearr_25694_25796 = state_25692__$1;
(statearr_25694_25796[(2)] = inst_25562);

(statearr_25694_25796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (59))){
var inst_25685 = (state_25692[(2)]);
var state_25692__$1 = state_25692;
var statearr_25695_25797 = state_25692__$1;
(statearr_25695_25797[(2)] = inst_25685);

(statearr_25695_25797[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (20))){
var inst_25598 = (state_25692[(8)]);
var inst_25601 = (state_25692[(9)]);
var inst_25597 = (state_25692[(2)]);
var inst_25598__$1 = cljs.core.__destructure_map.call(null,inst_25597);
var inst_25599 = cljs.core.get.call(null,inst_25598__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25600 = cljs.core.get.call(null,inst_25598__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25601__$1 = offset;
var state_25692__$1 = (function (){var statearr_25696 = state_25692;
(statearr_25696[(8)] = inst_25598__$1);

(statearr_25696[(10)] = inst_25600);

(statearr_25696[(9)] = inst_25601__$1);

(statearr_25696[(11)] = inst_25599);

return statearr_25696;
})();
if(cljs.core.truth_(inst_25601__$1)){
var statearr_25697_25798 = state_25692__$1;
(statearr_25697_25798[(1)] = (21));

} else {
var statearr_25698_25799 = state_25692__$1;
(statearr_25698_25799[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (58))){
var inst_25677 = (state_25692[(12)]);
var state_25692__$1 = state_25692;
var statearr_25699_25800 = state_25692__$1;
(statearr_25699_25800[(2)] = inst_25677);

(statearr_25699_25800[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (60))){
var inst_25681 = (state_25692[(2)]);
var inst_25682 = fluree.db.util.async.throw_err.call(null,inst_25681);
var state_25692__$1 = state_25692;
var statearr_25700_25801 = state_25692__$1;
(statearr_25700_25801[(2)] = inst_25682);

(statearr_25700_25801[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (27))){
var inst_25613 = cljs.core.not.call(null,inVector_QMARK_);
var state_25692__$1 = state_25692;
var statearr_25701_25802 = state_25692__$1;
(statearr_25701_25802[(2)] = inst_25613);

(statearr_25701_25802[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (1))){
var state_25692__$1 = state_25692;
var statearr_25702_25803 = state_25692__$1;
(statearr_25702_25803[(2)] = null);

(statearr_25702_25803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (24))){
var state_25692__$1 = state_25692;
var statearr_25703_25804 = state_25692__$1;
(statearr_25703_25804[(2)] = offset);

(statearr_25703_25804[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (55))){
var inst_25671 = (state_25692[(13)]);
var state_25692__$1 = state_25692;
var statearr_25704_25805 = state_25692__$1;
(statearr_25704_25805[(2)] = inst_25671);

(statearr_25704_25805[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (39))){
var inst_25639 = (state_25692[(14)]);
var inst_25641 = cljs.core.distinct.call(null);
var inst_25642 = cljs.core.conj.call(null,inst_25639,inst_25641);
var state_25692__$1 = state_25692;
var statearr_25705_25806 = state_25692__$1;
(statearr_25705_25806[(2)] = inst_25642);

(statearr_25705_25806[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (46))){
var inst_25651 = (state_25692[(15)]);
var state_25692__$1 = state_25692;
var statearr_25706_25807 = state_25692__$1;
(statearr_25706_25807[(2)] = inst_25651);

(statearr_25706_25807[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (4))){
var inst_25556 = (state_25692[(2)]);
var state_25692__$1 = state_25692;
var statearr_25707_25808 = state_25692__$1;
(statearr_25707_25808[(2)] = inst_25556);

(statearr_25707_25808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (54))){
var inst_25665 = (state_25692[(16)]);
var inst_25671 = (state_25692[(13)]);
var inst_25673 = cljs.core.PersistentVector.EMPTY;
var inst_25674 = cljs.core.into.call(null,inst_25673,inst_25665,inst_25671);
var state_25692__$1 = state_25692;
var statearr_25708_25809 = state_25692__$1;
(statearr_25708_25809[(2)] = inst_25674);

(statearr_25708_25809[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (15))){
var inst_25583 = (state_25692[(17)]);
var inst_25585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25586 = [inst_25583];
var inst_25587 = (new cljs.core.PersistentVector(null,1,(5),inst_25585,inst_25586,null));
var state_25692__$1 = state_25692;
var statearr_25709_25810 = state_25692__$1;
(statearr_25709_25810[(2)] = inst_25587);

(statearr_25709_25810[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (48))){
var inst_25598 = (state_25692[(8)]);
var inst_25616 = (state_25692[(18)]);
var inst_25600 = (state_25692[(10)]);
var inst_25657 = (state_25692[(19)]);
var inst_25610 = (state_25692[(20)]);
var inst_25621 = (state_25692[(21)]);
var inst_25599 = (state_25692[(11)]);
var inst_25659 = (function (){var map__25592 = inst_25598;
var headers = inst_25599;
var tuples = inst_25600;
var offset_SINGLEQUOTE_ = inst_25610;
var single_result_QMARK_ = inst_25616;
var pp_keys = inst_25621;
var G__25622 = inst_25657;
return (function (p1__25549_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__25549_SHARP_);
});
})();
var inst_25660 = cljs.core.map.call(null,inst_25659);
var inst_25661 = cljs.core.conj.call(null,inst_25657,inst_25660);
var state_25692__$1 = state_25692;
var statearr_25710_25811 = state_25692__$1;
(statearr_25710_25811[(2)] = inst_25661);

(statearr_25710_25811[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (50))){
var inst_25664 = (state_25692[(2)]);
var inst_25665 = cljs.core.apply.call(null,cljs.core.comp,inst_25664);
var state_25692__$1 = (function (){var statearr_25711 = state_25692;
(statearr_25711[(16)] = inst_25665);

return statearr_25711;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25712_25812 = state_25692__$1;
(statearr_25712_25812[(1)] = (51));

} else {
var statearr_25713_25813 = state_25692__$1;
(statearr_25713_25813[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (21))){
var inst_25603 = cljs.core.not.call(null,groupBy);
var state_25692__$1 = state_25692;
var statearr_25714_25814 = state_25692__$1;
(statearr_25714_25814[(2)] = inst_25603);

(statearr_25714_25814[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (31))){
var state_25692__$1 = state_25692;
var statearr_25715_25815 = state_25692__$1;
(statearr_25715_25815[(2)] = null);

(statearr_25715_25815[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (32))){
var inst_25616 = (state_25692[(18)]);
var inst_25599 = (state_25692[(11)]);
var inst_25621 = (state_25692[(2)]);
var inst_25623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25624 = fluree.db.query.fql.select_tuples_fn.call(null,inst_25599,vars,select);
var inst_25625 = cljs.core.map.call(null,inst_25624);
var inst_25626 = [inst_25625];
var inst_25627 = (new cljs.core.PersistentVector(null,1,(5),inst_25623,inst_25626,null));
var state_25692__$1 = (function (){var statearr_25716 = state_25692;
(statearr_25716[(22)] = inst_25627);

(statearr_25716[(21)] = inst_25621);

return statearr_25716;
})();
if(cljs.core.truth_(inst_25616)){
var statearr_25717_25816 = state_25692__$1;
(statearr_25717_25816[(1)] = (33));

} else {
var statearr_25718_25817 = state_25692__$1;
(statearr_25718_25817[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (40))){
var inst_25639 = (state_25692[(14)]);
var state_25692__$1 = state_25692;
var statearr_25719_25818 = state_25692__$1;
(statearr_25719_25818[(2)] = inst_25639);

(statearr_25719_25818[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (56))){
var inst_25677 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25720 = state_25692;
(statearr_25720[(12)] = inst_25677);

return statearr_25720;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25721_25819 = state_25692__$1;
(statearr_25721_25819[(1)] = (57));

} else {
var statearr_25722_25820 = state_25692__$1;
(statearr_25722_25820[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (33))){
var inst_25627 = (state_25692[(22)]);
var inst_25629 = cljs.core.map.call(null,cljs.core.first);
var inst_25630 = cljs.core.conj.call(null,inst_25627,inst_25629);
var state_25692__$1 = state_25692;
var statearr_25723_25821 = state_25692__$1;
(statearr_25723_25821[(2)] = inst_25630);

(statearr_25723_25821[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (13))){
var inst_25572 = (state_25692[(23)]);
var state_25692__$1 = state_25692;
var statearr_25724_25822 = state_25692__$1;
(statearr_25724_25822[(2)] = inst_25572);

(statearr_25724_25822[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (22))){
var inst_25601 = (state_25692[(9)]);
var state_25692__$1 = state_25692;
var statearr_25725_25823 = state_25692__$1;
(statearr_25725_25823[(2)] = inst_25601);

(statearr_25725_25823[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (36))){
var inst_25633 = (state_25692[(24)]);
var inst_25635 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_25636 = cljs.core.conj.call(null,inst_25633,inst_25635);
var state_25692__$1 = state_25692;
var statearr_25726_25824 = state_25692__$1;
(statearr_25726_25824[(2)] = inst_25636);

(statearr_25726_25824[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (41))){
var inst_25610 = (state_25692[(20)]);
var inst_25645 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25727 = state_25692;
(statearr_25727[(25)] = inst_25645);

return statearr_25727;
})();
if(cljs.core.truth_(inst_25610)){
var statearr_25728_25825 = state_25692__$1;
(statearr_25728_25825[(1)] = (42));

} else {
var statearr_25729_25826 = state_25692__$1;
(statearr_25729_25826[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (43))){
var inst_25645 = (state_25692[(25)]);
var state_25692__$1 = state_25692;
var statearr_25730_25827 = state_25692__$1;
(statearr_25730_25827[(2)] = inst_25645);

(statearr_25730_25827[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (29))){
var inst_25616 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25731 = state_25692;
(statearr_25731[(18)] = inst_25616);

return statearr_25731;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25732_25828 = state_25692__$1;
(statearr_25732_25828[(1)] = (30));

} else {
var statearr_25733_25829 = state_25692__$1;
(statearr_25733_25829[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (44))){
var inst_25651 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25734 = state_25692;
(statearr_25734[(15)] = inst_25651);

return statearr_25734;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25735_25830 = state_25692__$1;
(statearr_25735_25830[(1)] = (45));

} else {
var statearr_25736_25831 = state_25692__$1;
(statearr_25736_25831[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (6))){
var inst_25564 = cljs.core.count.call(null,select);
var inst_25565 = cljs.core._EQ_.call(null,(1),inst_25564);
var state_25692__$1 = state_25692;
var statearr_25737_25832 = state_25692__$1;
(statearr_25737_25832[(2)] = inst_25565);

(statearr_25737_25832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (28))){
var inst_25611 = (state_25692[(26)]);
var state_25692__$1 = state_25692;
var statearr_25738_25833 = state_25692__$1;
(statearr_25738_25833[(2)] = inst_25611);

(statearr_25738_25833[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (51))){
var inst_25600 = (state_25692[(10)]);
var inst_25599 = (state_25692[(11)]);
var inst_25668 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_25599,orderBy,inst_25600);
var state_25692__$1 = state_25692;
var statearr_25739_25834 = state_25692__$1;
(statearr_25739_25834[(2)] = inst_25668);

(statearr_25739_25834[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (25))){
var state_25692__$1 = state_25692;
var statearr_25740_25835 = state_25692__$1;
(statearr_25740_25835[(2)] = null);

(statearr_25740_25835[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (34))){
var inst_25627 = (state_25692[(22)]);
var state_25692__$1 = state_25692;
var statearr_25741_25836 = state_25692__$1;
(statearr_25741_25836[(2)] = inst_25627);

(statearr_25741_25836[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (17))){
var inst_25590 = (state_25692[(2)]);
var state_25692__$1 = state_25692;
var statearr_25742_25837 = state_25692__$1;
(statearr_25742_25837[(2)] = inst_25590);

(statearr_25742_25837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (3))){
var inst_25690 = (state_25692[(2)]);
var state_25692__$1 = state_25692;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25692__$1,inst_25690);
} else {
if((state_val_25693 === (12))){
var inst_25572 = (state_25692[(23)]);
var inst_25574 = cljs.core.first.call(null,select);
var inst_25575 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25574);
var inst_25576 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25575);
var inst_25577 = cljs.core.subs.call(null,inst_25576,(1));
var inst_25578 = [inst_25577];
var inst_25579 = [inst_25572];
var inst_25580 = cljs.core.PersistentHashMap.fromArrays(inst_25578,inst_25579);
var state_25692__$1 = state_25692;
var statearr_25743_25838 = state_25692__$1;
(statearr_25743_25838[(2)] = inst_25580);

(statearr_25743_25838[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (2))){
var inst_25562 = (state_25692[(7)]);
var _ = (function (){var statearr_25744 = state_25692;
(statearr_25744[(4)] = cljs.core.cons.call(null,(5),(state_25692[(4)])));

return statearr_25744;
})();
var inst_25562__$1 = aggregates;
var state_25692__$1 = (function (){var statearr_25745 = state_25692;
(statearr_25745[(7)] = inst_25562__$1);

return statearr_25745;
})();
if(cljs.core.truth_(inst_25562__$1)){
var statearr_25746_25839 = state_25692__$1;
(statearr_25746_25839[(1)] = (6));

} else {
var statearr_25747_25840 = state_25692__$1;
(statearr_25747_25840[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (23))){
var inst_25606 = (state_25692[(2)]);
var state_25692__$1 = state_25692;
if(cljs.core.truth_(inst_25606)){
var statearr_25748_25841 = state_25692__$1;
(statearr_25748_25841[(1)] = (24));

} else {
var statearr_25749_25842 = state_25692__$1;
(statearr_25749_25842[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (47))){
var inst_25657 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25750 = state_25692;
(statearr_25750[(19)] = inst_25657);

return statearr_25750;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25751_25843 = state_25692__$1;
(statearr_25751_25843[(1)] = (48));

} else {
var statearr_25752_25844 = state_25692__$1;
(statearr_25752_25844[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (35))){
var inst_25633 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25753 = state_25692;
(statearr_25753[(24)] = inst_25633);

return statearr_25753;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25754_25845 = state_25692__$1;
(statearr_25754_25845[(1)] = (36));

} else {
var statearr_25755_25846 = state_25692__$1;
(statearr_25755_25846[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (19))){
var state_25692__$1 = state_25692;
var statearr_25756_25847 = state_25692__$1;
(statearr_25756_25847[(2)] = res);

(statearr_25756_25847[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (57))){
var inst_25677 = (state_25692[(12)]);
var inst_25616 = (state_25692[(18)]);
var inst_25621 = (state_25692[(21)]);
var inst_25679 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_25621,inst_25616,db,fuel,max_fuel,opts,(8),inst_25677);
var state_25692__$1 = state_25692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25692__$1,(60),inst_25679);
} else {
if((state_val_25693 === (11))){
var inst_25687 = (state_25692[(2)]);
var _ = (function (){var statearr_25758 = state_25692;
(statearr_25758[(4)] = cljs.core.rest.call(null,(state_25692[(4)])));

return statearr_25758;
})();
var state_25692__$1 = state_25692;
var statearr_25759_25848 = state_25692__$1;
(statearr_25759_25848[(2)] = inst_25687);

(statearr_25759_25848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (9))){
var inst_25570 = cljs.core.first.call(null,aggregates);
var inst_25571 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_25570);
var inst_25572 = cljs.core.second.call(null,inst_25571);
var state_25692__$1 = (function (){var statearr_25760 = state_25692;
(statearr_25760[(23)] = inst_25572);

return statearr_25760;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25761_25849 = state_25692__$1;
(statearr_25761_25849[(1)] = (12));

} else {
var statearr_25762_25850 = state_25692__$1;
(statearr_25762_25850[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (5))){
var _ = (function (){var statearr_25763 = state_25692;
(statearr_25763[(4)] = cljs.core.rest.call(null,(state_25692[(4)])));

return statearr_25763;
})();
var state_25692__$1 = state_25692;
var ex25757 = (state_25692__$1[(2)]);
var statearr_25764_25851 = state_25692__$1;
(statearr_25764_25851[(5)] = ex25757);


if((ex25757 instanceof Error)){
var statearr_25765_25852 = state_25692__$1;
(statearr_25765_25852[(1)] = (4));

(statearr_25765_25852[(5)] = null);

} else {
throw ex25757;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (14))){
var inst_25583 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25766 = state_25692;
(statearr_25766[(17)] = inst_25583);

return statearr_25766;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25767_25853 = state_25692__$1;
(statearr_25767_25853[(1)] = (15));

} else {
var statearr_25768_25854 = state_25692__$1;
(statearr_25768_25854[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (45))){
var inst_25651 = (state_25692[(15)]);
var inst_25653 = cljs.core.take.call(null,group_limit);
var inst_25654 = cljs.core.conj.call(null,inst_25651,inst_25653);
var state_25692__$1 = state_25692;
var statearr_25769_25855 = state_25692__$1;
(statearr_25769_25855[(2)] = inst_25654);

(statearr_25769_25855[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (53))){
var inst_25671 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25770 = state_25692;
(statearr_25770[(13)] = inst_25671);

return statearr_25770;
})();
var statearr_25771_25856 = state_25692__$1;
(statearr_25771_25856[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (26))){
var inst_25611 = (state_25692[(26)]);
var inst_25610 = (state_25692[(2)]);
var inst_25611__$1 = cljs.core.not.call(null,prettyPrint);
var state_25692__$1 = (function (){var statearr_25773 = state_25692;
(statearr_25773[(26)] = inst_25611__$1);

(statearr_25773[(20)] = inst_25610);

return statearr_25773;
})();
if(inst_25611__$1){
var statearr_25774_25857 = state_25692__$1;
(statearr_25774_25857[(1)] = (27));

} else {
var statearr_25775_25858 = state_25692__$1;
(statearr_25775_25858[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (16))){
var inst_25583 = (state_25692[(17)]);
var state_25692__$1 = state_25692;
var statearr_25776_25859 = state_25692__$1;
(statearr_25776_25859[(2)] = inst_25583);

(statearr_25776_25859[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (38))){
var inst_25639 = (state_25692[(2)]);
var state_25692__$1 = (function (){var statearr_25777 = state_25692;
(statearr_25777[(14)] = inst_25639);

return statearr_25777;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25778_25860 = state_25692__$1;
(statearr_25778_25860[(1)] = (39));

} else {
var statearr_25779_25861 = state_25692__$1;
(statearr_25779_25861[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (30))){
var inst_25618 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_25692__$1 = state_25692;
var statearr_25780_25862 = state_25692__$1;
(statearr_25780_25862[(2)] = inst_25618);

(statearr_25780_25862[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (10))){
var state_25692__$1 = state_25692;
if(cljs.core.truth_(aggregates)){
var statearr_25781_25863 = state_25692__$1;
(statearr_25781_25863[(1)] = (18));

} else {
var statearr_25782_25864 = state_25692__$1;
(statearr_25782_25864[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (18))){
var inst_25594 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_25692__$1 = state_25692;
var statearr_25783_25865 = state_25692__$1;
(statearr_25783_25865[(2)] = inst_25594);

(statearr_25783_25865[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (52))){
var inst_25600 = (state_25692[(10)]);
var state_25692__$1 = state_25692;
var statearr_25784_25866 = state_25692__$1;
(statearr_25784_25866[(2)] = inst_25600);

(statearr_25784_25866[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (42))){
var inst_25610 = (state_25692[(20)]);
var inst_25645 = (state_25692[(25)]);
var inst_25647 = cljs.core.drop.call(null,inst_25610);
var inst_25648 = cljs.core.conj.call(null,inst_25645,inst_25647);
var state_25692__$1 = state_25692;
var statearr_25785_25867 = state_25692__$1;
(statearr_25785_25867[(2)] = inst_25648);

(statearr_25785_25867[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (37))){
var inst_25633 = (state_25692[(24)]);
var state_25692__$1 = state_25692;
var statearr_25786_25868 = state_25692__$1;
(statearr_25786_25868[(2)] = inst_25633);

(statearr_25786_25868[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (8))){
var inst_25568 = (state_25692[(2)]);
var state_25692__$1 = state_25692;
if(cljs.core.truth_(inst_25568)){
var statearr_25787_25869 = state_25692__$1;
(statearr_25787_25869[(1)] = (9));

} else {
var statearr_25788_25870 = state_25692__$1;
(statearr_25788_25870[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25693 === (49))){
var inst_25657 = (state_25692[(19)]);
var state_25692__$1 = state_25692;
var statearr_25789_25871 = state_25692__$1;
(statearr_25789_25871[(2)] = inst_25657);

(statearr_25789_25871[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2703__auto__ = null;
var fluree$db$query$fql$state_machine__2703__auto____0 = (function (){
var statearr_25790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25790[(0)] = fluree$db$query$fql$state_machine__2703__auto__);

(statearr_25790[(1)] = (1));

return statearr_25790;
});
var fluree$db$query$fql$state_machine__2703__auto____1 = (function (state_25692){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_25692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e25791){var ex__2706__auto__ = e25791;
var statearr_25792_25872 = state_25692;
(statearr_25792_25872[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_25692[(4)]))){
var statearr_25793_25873 = state_25692;
(statearr_25793_25873[(1)] = cljs.core.first.call(null,(state_25692[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25874 = state_25692;
state_25692 = G__25874;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2703__auto__ = function(state_25692){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2703__auto____1.call(this,state_25692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2703__auto____0;
fluree$db$query$fql$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2703__auto____1;
return fluree$db$query$fql$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_25794 = f__2726__auto__.call(null);
(statearr_25794[(6)] = c__2725__auto__);

return statearr_25794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25877,groupBy){
var map__25878 = p__25877;
var map__25878__$1 = cljs.core.__destructure_map.call(null,map__25878);
var res = map__25878__$1;
var headers = cljs.core.get.call(null,map__25878__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25878__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25879 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25879,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25879,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25875_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25875_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25876_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25876_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25882 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25882,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25882,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25885,p__25886,opts){
var map__25887 = p__25885;
var map__25887__$1 = cljs.core.__destructure_map.call(null,map__25887);
var res = map__25887__$1;
var headers = cljs.core.get.call(null,map__25887__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25887__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25888 = p__25886;
var map__25888__$1 = cljs.core.__destructure_map.call(null,map__25888);
var select_spec = map__25888__$1;
var groupBy = cljs.core.get.call(null,map__25888__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25888__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25888__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25888__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25888__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25888__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25888__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_26130){
var state_val_26131 = (state_26130[(1)]);
if((state_val_26131 === (65))){
var state_26130__$1 = state_26130;
var statearr_26132_26283 = state_26130__$1;
(statearr_26132_26283[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (70))){
var inst_26051 = (state_26130[(7)]);
var state_26130__$1 = state_26130;
var statearr_26134_26284 = state_26130__$1;
(statearr_26134_26284[(2)] = inst_26051);

(statearr_26134_26284[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (62))){
var state_26130__$1 = state_26130;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26135_26285 = state_26130__$1;
(statearr_26135_26285[(1)] = (64));

} else {
var statearr_26136_26286 = state_26130__$1;
(statearr_26136_26286[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (74))){
var inst_25958 = (state_26130[(8)]);
var inst_26026 = (state_26130[(9)]);
var inst_25967 = (state_26130[(10)]);
var inst_26059 = cljs.core.assoc.call(null,inst_25958,inst_25967,inst_26026);
var state_26130__$1 = state_26130;
var statearr_26137_26287 = state_26130__$1;
(statearr_26137_26287[(2)] = inst_26059);

(statearr_26137_26287[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (7))){
var state_26130__$1 = state_26130;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26138_26288 = state_26130__$1;
(statearr_26138_26288[(1)] = (82));

} else {
var statearr_26139_26289 = state_26130__$1;
(statearr_26139_26289[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (59))){
var inst_26026 = (state_26130[(9)]);
var inst_25956 = (state_26130[(11)]);
var inst_26030 = cljs.core.count.call(null,inst_26026);
var inst_26031 = (inst_25956 - inst_26030);
var state_26130__$1 = state_26130;
var statearr_26140_26290 = state_26130__$1;
(statearr_26140_26290[(2)] = inst_26031);

(statearr_26140_26290[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (86))){
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_26141_26291 = state_26130__$1;
(statearr_26141_26291[(1)] = (89));

} else {
var statearr_26142_26292 = state_26130__$1;
(statearr_26142_26292[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (20))){
var state_26130__$1 = state_26130;
var statearr_26143_26293 = state_26130__$1;
(statearr_26143_26293[(2)] = (0));

(statearr_26143_26293[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (72))){
var inst_26056 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_26056)){
var statearr_26144_26294 = state_26130__$1;
(statearr_26144_26294[(1)] = (73));

} else {
var statearr_26145_26295 = state_26130__$1;
(statearr_26145_26295[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (58))){
var state_26130__$1 = state_26130;
var statearr_26146_26296 = state_26130__$1;
(statearr_26146_26296[(2)] = null);

(statearr_26146_26296[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (60))){
var inst_25957 = (state_26130[(12)]);
var inst_26033 = (state_26130[(2)]);
var inst_26034 = (inst_25957 <= (0));
var state_26130__$1 = (function (){var statearr_26147 = state_26130;
(statearr_26147[(13)] = inst_26033);

return statearr_26147;
})();
if(cljs.core.truth_(inst_26034)){
var statearr_26148_26297 = state_26130__$1;
(statearr_26148_26297[(1)] = (61));

} else {
var statearr_26149_26298 = state_26130__$1;
(statearr_26149_26298[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (27))){
var inst_25956 = (state_26130[(11)]);
var inst_25980 = (inst_25956 < (1));
var state_26130__$1 = state_26130;
var statearr_26150_26299 = state_26130__$1;
(statearr_26150_26299[(2)] = inst_25980);

(statearr_26150_26299[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (1))){
var state_26130__$1 = state_26130;
var statearr_26151_26300 = state_26130__$1;
(statearr_26151_26300[(2)] = null);

(statearr_26151_26300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (69))){
var inst_26046 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26152_26301 = state_26130__$1;
(statearr_26152_26301[(2)] = inst_26046);

(statearr_26152_26301[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (24))){
var inst_25958 = (state_26130[(8)]);
var state_26130__$1 = state_26130;
var statearr_26153_26302 = state_26130__$1;
(statearr_26153_26302[(2)] = inst_25958);

(statearr_26153_26302[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (55))){
var inst_25956 = (state_26130[(11)]);
var inst_26016 = (state_26130[(14)]);
var inst_26023 = cljs.core.take.call(null,inst_25956,inst_26016);
var state_26130__$1 = state_26130;
var statearr_26154_26303 = state_26130__$1;
(statearr_26154_26303[(2)] = inst_26023);

(statearr_26154_26303[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (85))){
var inst_26101 = (state_26130[(15)]);
var inst_26100 = (state_26130[(2)]);
var inst_26101__$1 = fluree.db.util.async.throw_err.call(null,inst_26100);
var inst_26102 = cljs.core.coll_QMARK_.call(null,inst_26101__$1);
var inst_26103 = (!(inst_26102));
var state_26130__$1 = (function (){var statearr_26155 = state_26130;
(statearr_26155[(15)] = inst_26101__$1);

return statearr_26155;
})();
if(inst_26103){
var statearr_26156_26304 = state_26130__$1;
(statearr_26156_26304[(1)] = (86));

} else {
var statearr_26157_26305 = state_26130__$1;
(statearr_26157_26305[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (39))){
var inst_25975 = (state_26130[(16)]);
var inst_25997 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25998 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25999 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25975,inst_25997,inst_25998);
var state_26130__$1 = state_26130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26130__$1,(42),inst_25999);
} else {
if((state_val_26131 === (88))){
var inst_26123 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26158_26306 = state_26130__$1;
(statearr_26158_26306[(2)] = inst_26123);

(statearr_26158_26306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (46))){
var inst_25957 = (state_26130[(12)]);
var inst_26011 = ((0) < inst_25957);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_26011)){
var statearr_26159_26307 = state_26130__$1;
(statearr_26159_26307[(1)] = (49));

} else {
var statearr_26160_26308 = state_26130__$1;
(statearr_26160_26308[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (4))){
var inst_25889 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26161_26309 = state_26130__$1;
(statearr_26161_26309[(2)] = inst_25889);

(statearr_26161_26309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (77))){
var inst_25956 = (state_26130[(11)]);
var inst_26067 = (inst_25956 - (1));
var state_26130__$1 = state_26130;
var statearr_26162_26310 = state_26130__$1;
(statearr_26162_26310[(2)] = inst_26067);

(statearr_26162_26310[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (95))){
var inst_26101 = (state_26130[(15)]);
var state_26130__$1 = state_26130;
var statearr_26163_26311 = state_26130__$1;
(statearr_26163_26311[(2)] = inst_26101);

(statearr_26163_26311[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (54))){
var inst_26021 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_26021)){
var statearr_26164_26312 = state_26130__$1;
(statearr_26164_26312[(1)] = (55));

} else {
var statearr_26165_26313 = state_26130__$1;
(statearr_26165_26313[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (92))){
var inst_26101 = (state_26130[(15)]);
var inst_26114 = cljs.core.first.call(null,inst_26101);
var state_26130__$1 = state_26130;
var statearr_26166_26314 = state_26130__$1;
(statearr_26166_26314[(2)] = inst_26114);

(statearr_26166_26314[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (15))){
var inst_25907 = (state_26130[(17)]);
var inst_25915 = (state_26130[(2)]);
var inst_25916 = fluree.db.util.async.throw_err.call(null,inst_25915);
var inst_25917 = [inst_25907];
var inst_25918 = [inst_25916];
var inst_25919 = cljs.core.PersistentHashMap.fromArrays(inst_25917,inst_25918);
var state_26130__$1 = state_26130;
var statearr_26167_26315 = state_26130__$1;
(statearr_26167_26315[(2)] = inst_25919);

(statearr_26167_26315[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (48))){
var inst_26079 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26168_26316 = state_26130__$1;
(statearr_26168_26316[(2)] = inst_26079);

(statearr_26168_26316[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (50))){
var inst_26002 = (state_26130[(18)]);
var state_26130__$1 = state_26130;
var statearr_26169_26317 = state_26130__$1;
(statearr_26169_26317[(2)] = inst_26002);

(statearr_26169_26317[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (75))){
var inst_25968 = (state_26130[(19)]);
var inst_26050 = (state_26130[(20)]);
var inst_25971 = (state_26130[(21)]);
var inst_26033 = (state_26130[(13)]);
var inst_26061 = (state_26130[(2)]);
var inst_25954 = inst_25968;
var inst_25955 = inst_25971;
var inst_25956 = inst_26033;
var inst_25957 = inst_26050;
var inst_25958 = inst_26061;
var state_26130__$1 = (function (){var statearr_26170 = state_26130;
(statearr_26170[(22)] = inst_25954);

(statearr_26170[(8)] = inst_25958);

(statearr_26170[(11)] = inst_25956);

(statearr_26170[(12)] = inst_25957);

(statearr_26170[(23)] = inst_25955);

return statearr_26170;
})();
var statearr_26171_26318 = state_26130__$1;
(statearr_26171_26318[(2)] = null);

(statearr_26171_26318[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (21))){
var inst_25947 = (state_26130[(24)]);
var inst_25935 = (state_26130[(25)]);
var inst_25939 = (state_26130[(26)]);
var inst_25952 = (state_26130[(2)]);
var inst_25953 = cljs.core.PersistentHashMap.EMPTY;
var inst_25954 = inst_25935;
var inst_25955 = inst_25939;
var inst_25956 = inst_25947;
var inst_25957 = inst_25952;
var inst_25958 = inst_25953;
var state_26130__$1 = (function (){var statearr_26172 = state_26130;
(statearr_26172[(22)] = inst_25954);

(statearr_26172[(8)] = inst_25958);

(statearr_26172[(11)] = inst_25956);

(statearr_26172[(12)] = inst_25957);

(statearr_26172[(23)] = inst_25955);

return statearr_26172;
})();
var statearr_26173_26319 = state_26130__$1;
(statearr_26173_26319[(2)] = null);

(statearr_26173_26319[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (31))){
var inst_25972 = (state_26130[(27)]);
var inst_25957 = (state_26130[(12)]);
var inst_25986 = (inst_25957 >= inst_25972);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_25986)){
var statearr_26174_26320 = state_26130__$1;
(statearr_26174_26320[(1)] = (33));

} else {
var statearr_26175_26321 = state_26130__$1;
(statearr_26175_26321[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (32))){
var inst_26086 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26176_26322 = state_26130__$1;
(statearr_26176_26322[(2)] = inst_26086);

(statearr_26176_26322[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (40))){
var state_26130__$1 = state_26130;
var statearr_26177_26323 = state_26130__$1;
(statearr_26177_26323[(2)] = null);

(statearr_26177_26323[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (91))){
var inst_26111 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26178_26324 = state_26130__$1;
(statearr_26178_26324[(2)] = inst_26111);

(statearr_26178_26324[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (56))){
var inst_26016 = (state_26130[(14)]);
var state_26130__$1 = state_26130;
var statearr_26179_26325 = state_26130__$1;
(statearr_26179_26325[(2)] = inst_26016);

(statearr_26179_26325[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (33))){
var state_26130__$1 = state_26130;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26180_26326 = state_26130__$1;
(statearr_26180_26326[(1)] = (36));

} else {
var statearr_26181_26327 = state_26130__$1;
(statearr_26181_26327[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (13))){
var inst_25935 = (state_26130[(25)]);
var inst_25939 = (state_26130[(26)]);
var inst_25904 = (state_26130[(28)]);
var inst_25935__$1 = cljs.core.keys.call(null,inst_25904);
var inst_25936 = cljs.core.seq.call(null,inst_25935__$1);
var inst_25937 = cljs.core.first.call(null,inst_25936);
var inst_25938 = cljs.core.next.call(null,inst_25936);
var inst_25939__$1 = cljs.core.vals.call(null,inst_25904);
var inst_25940 = cljs.core.seq.call(null,inst_25939__$1);
var inst_25941 = cljs.core.first.call(null,inst_25940);
var inst_25942 = cljs.core.next.call(null,inst_25940);
var inst_25943 = cljs.core._EQ_.call(null,(0),limit);
var state_26130__$1 = (function (){var statearr_26182 = state_26130;
(statearr_26182[(29)] = inst_25941);

(statearr_26182[(30)] = inst_25937);

(statearr_26182[(31)] = inst_25938);

(statearr_26182[(32)] = inst_25942);

(statearr_26182[(25)] = inst_25935__$1);

(statearr_26182[(26)] = inst_25939__$1);

return statearr_26182;
})();
if(inst_25943){
var statearr_26183_26328 = state_26130__$1;
(statearr_26183_26328[(1)] = (16));

} else {
var statearr_26184_26329 = state_26130__$1;
(statearr_26184_26329[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (22))){
var inst_25954 = (state_26130[(22)]);
var inst_25955 = (state_26130[(23)]);
var inst_25966 = cljs.core.seq.call(null,inst_25954);
var inst_25967 = cljs.core.first.call(null,inst_25966);
var inst_25968 = cljs.core.next.call(null,inst_25966);
var inst_25969 = cljs.core.seq.call(null,inst_25955);
var inst_25970 = cljs.core.first.call(null,inst_25969);
var inst_25971 = cljs.core.next.call(null,inst_25969);
var inst_25972 = cljs.core.count.call(null,inst_25970);
var inst_25973 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25974 = [headers,vars,inst_25970];
var inst_25975 = cljs.core.PersistentHashMap.fromArrays(inst_25973,inst_25974);
var inst_25976 = (inst_25970 == null);
var state_26130__$1 = (function (){var statearr_26185 = state_26130;
(statearr_26185[(19)] = inst_25968);

(statearr_26185[(27)] = inst_25972);

(statearr_26185[(10)] = inst_25967);

(statearr_26185[(21)] = inst_25971);

(statearr_26185[(16)] = inst_25975);

return statearr_26185;
})();
if(cljs.core.truth_(inst_25976)){
var statearr_26186_26330 = state_26130__$1;
(statearr_26186_26330[(1)] = (24));

} else {
var statearr_26187_26331 = state_26130__$1;
(statearr_26187_26331[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (90))){
var inst_26101 = (state_26130[(15)]);
var state_26130__$1 = state_26130;
var statearr_26188_26332 = state_26130__$1;
(statearr_26188_26332[(2)] = inst_26101);

(statearr_26188_26332[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (36))){
var inst_25957 = (state_26130[(12)]);
var inst_25989 = (inst_25957 - (1));
var state_26130__$1 = state_26130;
var statearr_26189_26333 = state_26130__$1;
(statearr_26189_26333[(2)] = inst_25989);

(statearr_26189_26333[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (41))){
var inst_26082 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26190_26334 = state_26130__$1;
(statearr_26190_26334[(2)] = inst_26082);

(statearr_26190_26334[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (89))){
var inst_26101 = (state_26130[(15)]);
var inst_26106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26107 = [inst_26101];
var inst_26108 = (new cljs.core.PersistentVector(null,1,(5),inst_26106,inst_26107,null));
var state_26130__$1 = state_26130;
var statearr_26191_26335 = state_26130__$1;
(statearr_26191_26335[(2)] = inst_26108);

(statearr_26191_26335[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (43))){
var inst_26002 = (state_26130[(18)]);
var inst_26005 = cljs.core.seq.call(null,inst_26002);
var state_26130__$1 = state_26130;
var statearr_26192_26336 = state_26130__$1;
(statearr_26192_26336[(2)] = inst_26005);

(statearr_26192_26336[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (61))){
var state_26130__$1 = state_26130;
var statearr_26193_26337 = state_26130__$1;
(statearr_26193_26337[(2)] = (0));

(statearr_26193_26337[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (29))){
var inst_25983 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_25983)){
var statearr_26194_26338 = state_26130__$1;
(statearr_26194_26338[(1)] = (30));

} else {
var statearr_26195_26339 = state_26130__$1;
(statearr_26195_26339[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (44))){
var inst_26003 = (state_26130[(33)]);
var state_26130__$1 = state_26130;
var statearr_26196_26340 = state_26130__$1;
(statearr_26196_26340[(2)] = inst_26003);

(statearr_26196_26340[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (93))){
var state_26130__$1 = state_26130;
var statearr_26197_26341 = state_26130__$1;
(statearr_26197_26341[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (6))){
var inst_25896 = (state_26130[(34)]);
var inst_25896__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25898 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_26130__$1 = (function (){var statearr_26199 = state_26130;
(statearr_26199[(35)] = inst_25898);

(statearr_26199[(34)] = inst_25896__$1);

return statearr_26199;
})();
if(cljs.core.truth_(inst_25896__$1)){
var statearr_26200_26342 = state_26130__$1;
(statearr_26200_26342[(1)] = (9));

} else {
var statearr_26201_26343 = state_26130__$1;
(statearr_26201_26343[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (28))){
var inst_25956 = (state_26130[(11)]);
var state_26130__$1 = state_26130;
var statearr_26202_26344 = state_26130__$1;
(statearr_26202_26344[(2)] = inst_25956);

(statearr_26202_26344[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (64))){
var inst_25957 = (state_26130[(12)]);
var inst_26038 = (inst_25957 - (1));
var state_26130__$1 = state_26130;
var statearr_26203_26345 = state_26130__$1;
(statearr_26203_26345[(2)] = inst_26038);

(statearr_26203_26345[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (51))){
var inst_25956 = (state_26130[(11)]);
var inst_26016 = (state_26130[(2)]);
var state_26130__$1 = (function (){var statearr_26204 = state_26130;
(statearr_26204[(14)] = inst_26016);

return statearr_26204;
})();
if(cljs.core.truth_(inst_25956)){
var statearr_26205_26346 = state_26130__$1;
(statearr_26205_26346[(1)] = (52));

} else {
var statearr_26206_26347 = state_26130__$1;
(statearr_26206_26347[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (25))){
var inst_25956 = (state_26130[(11)]);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_25956)){
var statearr_26207_26348 = state_26130__$1;
(statearr_26207_26348[(1)] = (27));

} else {
var statearr_26208_26349 = state_26130__$1;
(statearr_26208_26349[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (34))){
var state_26130__$1 = state_26130;
var statearr_26209_26350 = state_26130__$1;
(statearr_26209_26350[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (17))){
var state_26130__$1 = state_26130;
var statearr_26211_26351 = state_26130__$1;
(statearr_26211_26351[(2)] = limit);

(statearr_26211_26351[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (3))){
var inst_26128 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26130__$1,inst_26128);
} else {
if((state_val_26131 === (12))){
var inst_25904 = (state_26130[(28)]);
var inst_25906 = cljs.core.keys.call(null,inst_25904);
var inst_25907 = cljs.core.first.call(null,inst_25906);
var inst_25908 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25909 = cljs.core.vals.call(null,inst_25904);
var inst_25910 = cljs.core.first.call(null,inst_25909);
var inst_25911 = [headers,vars,inst_25910];
var inst_25912 = cljs.core.PersistentHashMap.fromArrays(inst_25908,inst_25911);
var inst_25913 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25912,select_spec,limit,opts);
var state_26130__$1 = (function (){var statearr_26212 = state_26130;
(statearr_26212[(17)] = inst_25907);

return statearr_26212;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26130__$1,(15),inst_25913);
} else {
if((state_val_26131 === (2))){
var _ = (function (){var statearr_26213 = state_26130;
(statearr_26213[(4)] = cljs.core.cons.call(null,(5),(state_26130[(4)])));

return statearr_26213;
})();
var state_26130__$1 = state_26130;
if(cljs.core.truth_(groupBy)){
var statearr_26214_26352 = state_26130__$1;
(statearr_26214_26352[(1)] = (6));

} else {
var statearr_26215_26353 = state_26130__$1;
(statearr_26215_26353[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (66))){
var inst_26048 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26216_26354 = state_26130__$1;
(statearr_26216_26354[(2)] = inst_26048);

(statearr_26216_26354[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (23))){
var inst_26090 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26217_26355 = state_26130__$1;
(statearr_26217_26355[(2)] = inst_26090);

(statearr_26217_26355[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (47))){
var inst_25956 = (state_26130[(11)]);
var inst_26064 = (inst_25956 == null);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_26064)){
var statearr_26218_26356 = state_26130__$1;
(statearr_26218_26356[(1)] = (76));

} else {
var statearr_26219_26357 = state_26130__$1;
(statearr_26219_26357[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (35))){
var inst_26084 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26220_26358 = state_26130__$1;
(statearr_26220_26358[(2)] = inst_26084);

(statearr_26220_26358[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (82))){
var state_26130__$1 = state_26130;
var statearr_26221_26359 = state_26130__$1;
(statearr_26221_26359[(2)] = (1));

(statearr_26221_26359[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (76))){
var state_26130__$1 = state_26130;
var statearr_26222_26360 = state_26130__$1;
(statearr_26222_26360[(2)] = null);

(statearr_26222_26360[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (97))){
var inst_26119 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26223_26361 = state_26130__$1;
(statearr_26223_26361[(2)] = inst_26119);

(statearr_26223_26361[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (19))){
var inst_25948 = (state_26130[(36)]);
var state_26130__$1 = state_26130;
var statearr_26224_26362 = state_26130__$1;
(statearr_26224_26362[(2)] = inst_25948);

(statearr_26224_26362[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (57))){
var inst_25956 = (state_26130[(11)]);
var inst_26026 = (state_26130[(2)]);
var inst_26027 = (inst_25956 == null);
var state_26130__$1 = (function (){var statearr_26225 = state_26130;
(statearr_26225[(9)] = inst_26026);

return statearr_26225;
})();
if(cljs.core.truth_(inst_26027)){
var statearr_26226_26363 = state_26130__$1;
(statearr_26226_26363[(1)] = (58));

} else {
var statearr_26227_26364 = state_26130__$1;
(statearr_26227_26364[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (68))){
var state_26130__$1 = state_26130;
var statearr_26228_26365 = state_26130__$1;
(statearr_26228_26365[(2)] = null);

(statearr_26228_26365[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (11))){
var inst_25904 = (state_26130[(2)]);
var state_26130__$1 = (function (){var statearr_26230 = state_26130;
(statearr_26230[(28)] = inst_25904);

return statearr_26230;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26231_26366 = state_26130__$1;
(statearr_26231_26366[(1)] = (12));

} else {
var statearr_26232_26367 = state_26130__$1;
(statearr_26232_26367[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (9))){
var inst_25898 = (state_26130[(35)]);
var inst_25896 = (state_26130[(34)]);
var inst_25900 = cljs.core.sorted_map_by.call(null,inst_25896);
var inst_25901 = cljs.core.into.call(null,inst_25900,inst_25898);
var state_26130__$1 = state_26130;
var statearr_26233_26368 = state_26130__$1;
(statearr_26233_26368[(2)] = inst_25901);

(statearr_26233_26368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (5))){
var _ = (function (){var statearr_26234 = state_26130;
(statearr_26234[(4)] = cljs.core.rest.call(null,(state_26130[(4)])));

return statearr_26234;
})();
var state_26130__$1 = state_26130;
var ex26229 = (state_26130__$1[(2)]);
var statearr_26235_26369 = state_26130__$1;
(statearr_26235_26369[(5)] = ex26229);


if((ex26229 instanceof Error)){
var statearr_26236_26370 = state_26130__$1;
(statearr_26236_26370[(1)] = (4));

(statearr_26236_26370[(5)] = null);

} else {
throw ex26229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (83))){
var state_26130__$1 = state_26130;
var statearr_26237_26371 = state_26130__$1;
(statearr_26237_26371[(2)] = limit);

(statearr_26237_26371[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (14))){
var inst_26092 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26238_26372 = state_26130__$1;
(statearr_26238_26372[(2)] = inst_26092);

(statearr_26238_26372[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (45))){
var inst_26008 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
if(cljs.core.truth_(inst_26008)){
var statearr_26239_26373 = state_26130__$1;
(statearr_26239_26373[(1)] = (46));

} else {
var statearr_26240_26374 = state_26130__$1;
(statearr_26240_26374[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (53))){
var inst_25956 = (state_26130[(11)]);
var state_26130__$1 = state_26130;
var statearr_26241_26375 = state_26130__$1;
(statearr_26241_26375[(2)] = inst_25956);

(statearr_26241_26375[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (78))){
var inst_25957 = (state_26130[(12)]);
var inst_26069 = (state_26130[(2)]);
var inst_26070 = (inst_25957 <= (0));
var state_26130__$1 = (function (){var statearr_26242 = state_26130;
(statearr_26242[(37)] = inst_26069);

return statearr_26242;
})();
if(cljs.core.truth_(inst_26070)){
var statearr_26243_26376 = state_26130__$1;
(statearr_26243_26376[(1)] = (79));

} else {
var statearr_26244_26377 = state_26130__$1;
(statearr_26244_26377[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (26))){
var inst_26088 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26245_26378 = state_26130__$1;
(statearr_26245_26378[(2)] = inst_26088);

(statearr_26245_26378[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (16))){
var state_26130__$1 = state_26130;
var statearr_26246_26379 = state_26130__$1;
(statearr_26246_26379[(2)] = null);

(statearr_26246_26379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (81))){
var inst_25968 = (state_26130[(19)]);
var inst_25958 = (state_26130[(8)]);
var inst_26002 = (state_26130[(18)]);
var inst_25967 = (state_26130[(10)]);
var inst_25971 = (state_26130[(21)]);
var inst_26069 = (state_26130[(37)]);
var inst_26075 = (state_26130[(2)]);
var inst_26076 = cljs.core.assoc.call(null,inst_25958,inst_25967,inst_26002);
var inst_25954 = inst_25968;
var inst_25955 = inst_25971;
var inst_25956 = inst_26069;
var inst_25957 = inst_26075;
var inst_25958__$1 = inst_26076;
var state_26130__$1 = (function (){var statearr_26249 = state_26130;
(statearr_26249[(22)] = inst_25954);

(statearr_26249[(8)] = inst_25958__$1);

(statearr_26249[(11)] = inst_25956);

(statearr_26249[(12)] = inst_25957);

(statearr_26249[(23)] = inst_25955);

return statearr_26249;
})();
var statearr_26250_26380 = state_26130__$1;
(statearr_26250_26380[(2)] = null);

(statearr_26250_26380[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (79))){
var state_26130__$1 = state_26130;
var statearr_26251_26381 = state_26130__$1;
(statearr_26251_26381[(2)] = (0));

(statearr_26251_26381[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (38))){
var inst_25968 = (state_26130[(19)]);
var inst_25958 = (state_26130[(8)]);
var inst_25956 = (state_26130[(11)]);
var inst_25971 = (state_26130[(21)]);
var inst_25993 = (state_26130[(2)]);
var tmp26247 = inst_25958;
var tmp26248 = inst_25956;
var inst_25954 = inst_25968;
var inst_25955 = inst_25971;
var inst_25956__$1 = tmp26248;
var inst_25957 = inst_25993;
var inst_25958__$1 = tmp26247;
var state_26130__$1 = (function (){var statearr_26252 = state_26130;
(statearr_26252[(22)] = inst_25954);

(statearr_26252[(8)] = inst_25958__$1);

(statearr_26252[(11)] = inst_25956__$1);

(statearr_26252[(12)] = inst_25957);

(statearr_26252[(23)] = inst_25955);

return statearr_26252;
})();
var statearr_26253_26382 = state_26130__$1;
(statearr_26253_26382[(2)] = null);

(statearr_26253_26382[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (87))){
var state_26130__$1 = state_26130;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26254_26383 = state_26130__$1;
(statearr_26254_26383[(1)] = (92));

} else {
var statearr_26255_26384 = state_26130__$1;
(statearr_26255_26384[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (30))){
var inst_25958 = (state_26130[(8)]);
var state_26130__$1 = state_26130;
var statearr_26256_26385 = state_26130__$1;
(statearr_26256_26385[(2)] = inst_25958);

(statearr_26256_26385[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (73))){
var inst_25958 = (state_26130[(8)]);
var state_26130__$1 = state_26130;
var statearr_26257_26386 = state_26130__$1;
(statearr_26257_26386[(2)] = inst_25958);

(statearr_26257_26386[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (96))){
var state_26130__$1 = state_26130;
var statearr_26258_26387 = state_26130__$1;
(statearr_26258_26387[(2)] = null);

(statearr_26258_26387[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (10))){
var inst_25898 = (state_26130[(35)]);
var state_26130__$1 = state_26130;
var statearr_26259_26388 = state_26130__$1;
(statearr_26259_26388[(2)] = inst_25898);

(statearr_26259_26388[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (18))){
var inst_25948 = (state_26130[(36)]);
var inst_25947 = (state_26130[(2)]);
var inst_25948__$1 = offset;
var state_26130__$1 = (function (){var statearr_26260 = state_26130;
(statearr_26260[(24)] = inst_25947);

(statearr_26260[(36)] = inst_25948__$1);

return statearr_26260;
})();
if(cljs.core.truth_(inst_25948__$1)){
var statearr_26261_26389 = state_26130__$1;
(statearr_26261_26389[(1)] = (19));

} else {
var statearr_26262_26390 = state_26130__$1;
(statearr_26262_26390[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (52))){
var inst_25956 = (state_26130[(11)]);
var inst_26018 = ((0) < inst_25956);
var state_26130__$1 = state_26130;
var statearr_26263_26391 = state_26130__$1;
(statearr_26263_26391[(2)] = inst_26018);

(statearr_26263_26391[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (67))){
var inst_26026 = (state_26130[(9)]);
var inst_25972 = (state_26130[(27)]);
var inst_25957 = (state_26130[(12)]);
var inst_26041 = cljs.core.count.call(null,inst_26026);
var inst_26042 = (inst_25972 - inst_26041);
var inst_26043 = (inst_25957 - inst_26042);
var state_26130__$1 = state_26130;
var statearr_26264_26392 = state_26130__$1;
(statearr_26264_26392[(2)] = inst_26043);

(statearr_26264_26392[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (71))){
var inst_26026 = (state_26130[(9)]);
var inst_26054 = cljs.core.empty_QMARK_.call(null,inst_26026);
var state_26130__$1 = state_26130;
var statearr_26265_26393 = state_26130__$1;
(statearr_26265_26393[(2)] = inst_26054);

(statearr_26265_26393[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (42))){
var inst_26002 = (state_26130[(18)]);
var inst_26003 = (state_26130[(33)]);
var inst_26001 = (state_26130[(2)]);
var inst_26002__$1 = fluree.db.util.async.throw_err.call(null,inst_26001);
var inst_26003__$1 = cljs.core.coll_QMARK_.call(null,inst_26002__$1);
var state_26130__$1 = (function (){var statearr_26266 = state_26130;
(statearr_26266[(18)] = inst_26002__$1);

(statearr_26266[(33)] = inst_26003__$1);

return statearr_26266;
})();
if(inst_26003__$1){
var statearr_26267_26394 = state_26130__$1;
(statearr_26267_26394[(1)] = (43));

} else {
var statearr_26268_26395 = state_26130__$1;
(statearr_26268_26395[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (80))){
var inst_25957 = (state_26130[(12)]);
var inst_26073 = (inst_25957 - (1));
var state_26130__$1 = state_26130;
var statearr_26269_26396 = state_26130__$1;
(statearr_26269_26396[(2)] = inst_26073);

(statearr_26269_26396[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (37))){
var inst_25972 = (state_26130[(27)]);
var inst_25957 = (state_26130[(12)]);
var inst_25991 = (inst_25957 - inst_25972);
var state_26130__$1 = state_26130;
var statearr_26270_26397 = state_26130__$1;
(statearr_26270_26397[(2)] = inst_25991);

(statearr_26270_26397[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (63))){
var inst_26051 = (state_26130[(7)]);
var inst_26026 = (state_26130[(9)]);
var inst_26050 = (state_26130[(2)]);
var inst_26051__$1 = (inst_26026 == null);
var state_26130__$1 = (function (){var statearr_26271 = state_26130;
(statearr_26271[(7)] = inst_26051__$1);

(statearr_26271[(20)] = inst_26050);

return statearr_26271;
})();
if(cljs.core.truth_(inst_26051__$1)){
var statearr_26272_26398 = state_26130__$1;
(statearr_26272_26398[(1)] = (70));

} else {
var statearr_26273_26399 = state_26130__$1;
(statearr_26273_26399[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (94))){
var inst_26121 = (state_26130[(2)]);
var state_26130__$1 = state_26130;
var statearr_26274_26400 = state_26130__$1;
(statearr_26274_26400[(2)] = inst_26121);

(statearr_26274_26400[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (8))){
var inst_26125 = (state_26130[(2)]);
var _ = (function (){var statearr_26275 = state_26130;
(statearr_26275[(4)] = cljs.core.rest.call(null,(state_26130[(4)])));

return statearr_26275;
})();
var state_26130__$1 = state_26130;
var statearr_26276_26401 = state_26130__$1;
(statearr_26276_26401[(2)] = inst_26125);

(statearr_26276_26401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (49))){
var inst_26002 = (state_26130[(18)]);
var inst_25957 = (state_26130[(12)]);
var inst_26013 = cljs.core.drop.call(null,inst_25957,inst_26002);
var state_26130__$1 = state_26130;
var statearr_26277_26402 = state_26130__$1;
(statearr_26277_26402[(2)] = inst_26013);

(statearr_26277_26402[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26131 === (84))){
var inst_26097 = (state_26130[(2)]);
var inst_26098 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_26097,opts);
var state_26130__$1 = state_26130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26130__$1,(85),inst_26098);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto____0 = (function (){
var statearr_26278 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26278[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto__);

(statearr_26278[(1)] = (1));

return statearr_26278;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto____1 = (function (state_26130){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_26130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e26279){var ex__2706__auto__ = e26279;
var statearr_26280_26403 = state_26130;
(statearr_26280_26403[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_26130[(4)]))){
var statearr_26281_26404 = state_26130;
(statearr_26281_26404[(1)] = cljs.core.first.call(null,(state_26130[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26405 = state_26130;
state_26130 = G__26405;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto__ = function(state_26130){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto____1.call(this,state_26130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_26282 = f__2726__auto__.call(null);
(statearr_26282[(6)] = c__2725__auto__);

return statearr_26282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__26408,opts){
var map__26409 = p__26408;
var map__26409__$1 = cljs.core.__destructure_map.call(null,map__26409);
var selectOne = cljs.core.get.call(null,map__26409__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__26409__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__26409__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__26409__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__26406_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__26406_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__26407_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__26407_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__5043__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})(),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__26410,p__26411){
var map__26412 = p__26410;
var map__26412__$1 = cljs.core.__destructure_map.call(null,map__26412);
var query_map = map__26412__$1;
var construct = cljs.core.get.call(null,map__26412__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__26413 = p__26411;
var map__26413__$1 = cljs.core.__destructure_map.call(null,map__26413);
var where_result = map__26413__$1;
var headers = cljs.core.get.call(null,map__26413__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__26413__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__26414 = cljs.core.map.call(null,(function (construct_item){
var temp__5802__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5802__auto__)){
var index_of = temp__5802__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__26414,(0),null);
var fn2 = cljs.core.nth.call(null,vec__26414,(1),null);
var fn3 = cljs.core.nth.call(null,vec__26414,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_26447){
var state_val_26448 = (state_26447[(1)]);
if((state_val_26448 === (7))){
var inst_26426 = (state_26447[(7)]);
var state_26447__$1 = state_26447;
var statearr_26449_26472 = state_26447__$1;
(statearr_26449_26472[(2)] = inst_26426);

(statearr_26449_26472[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (1))){
var state_26447__$1 = state_26447;
var statearr_26450_26473 = state_26447__$1;
(statearr_26450_26473[(2)] = null);

(statearr_26450_26473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (4))){
var inst_26417 = (state_26447[(2)]);
var state_26447__$1 = state_26447;
var statearr_26451_26474 = state_26447__$1;
(statearr_26451_26474[(2)] = inst_26417);

(statearr_26451_26474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (13))){
var inst_26436 = (state_26447[(2)]);
var inst_26437 = fluree.db.util.async.throw_err.call(null,inst_26436);
var state_26447__$1 = state_26447;
var statearr_26452_26475 = state_26447__$1;
(statearr_26452_26475[(2)] = inst_26437);

(statearr_26452_26475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (6))){
var inst_26426 = (state_26447[(7)]);
var inst_26425 = (state_26447[(2)]);
var inst_26426__$1 = fluree.db.util.async.throw_err.call(null,inst_26425);
var inst_26427 = fluree.db.util.core.exception_QMARK_.call(null,inst_26426__$1);
var state_26447__$1 = (function (){var statearr_26453 = state_26447;
(statearr_26453[(7)] = inst_26426__$1);

return statearr_26453;
})();
if(inst_26427){
var statearr_26454_26476 = state_26447__$1;
(statearr_26454_26476[(1)] = (7));

} else {
var statearr_26455_26477 = state_26447__$1;
(statearr_26455_26477[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (3))){
var inst_26445 = (state_26447[(2)]);
var state_26447__$1 = state_26447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26447__$1,inst_26445);
} else {
if((state_val_26448 === (12))){
var inst_26440 = (state_26447[(2)]);
var state_26447__$1 = state_26447;
var statearr_26456_26478 = state_26447__$1;
(statearr_26456_26478[(2)] = inst_26440);

(statearr_26456_26478[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (2))){
var _ = (function (){var statearr_26457 = state_26447;
(statearr_26457[(4)] = cljs.core.cons.call(null,(5),(state_26447[(4)])));

return statearr_26457;
})();
var inst_26423 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_26447__$1 = state_26447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26447__$1,(6),inst_26423);
} else {
if((state_val_26448 === (11))){
var state_26447__$1 = state_26447;
var statearr_26459_26479 = state_26447__$1;
(statearr_26459_26479[(2)] = null);

(statearr_26459_26479[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (9))){
var inst_26442 = (state_26447[(2)]);
var _ = (function (){var statearr_26460 = state_26447;
(statearr_26460[(4)] = cljs.core.rest.call(null,(state_26447[(4)])));

return statearr_26460;
})();
var state_26447__$1 = state_26447;
var statearr_26461_26480 = state_26447__$1;
(statearr_26461_26480[(2)] = inst_26442);

(statearr_26461_26480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (5))){
var _ = (function (){var statearr_26462 = state_26447;
(statearr_26462[(4)] = cljs.core.rest.call(null,(state_26447[(4)])));

return statearr_26462;
})();
var state_26447__$1 = state_26447;
var ex26458 = (state_26447__$1[(2)]);
var statearr_26463_26481 = state_26447__$1;
(statearr_26463_26481[(5)] = ex26458);


if((ex26458 instanceof Error)){
var statearr_26464_26482 = state_26447__$1;
(statearr_26464_26482[(1)] = (4));

(statearr_26464_26482[(5)] = null);

} else {
throw ex26458;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26448 === (10))){
var inst_26426 = (state_26447[(7)]);
var inst_26431 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_26426);
var inst_26432 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_26426);
var inst_26433 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_26431,inst_26432,query_map,opts);
var inst_26434 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_26426,inst_26433,opts);
var state_26447__$1 = state_26447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26447__$1,(13),inst_26434);
} else {
if((state_val_26448 === (8))){
var state_26447__$1 = state_26447;
var statearr_26465_26483 = state_26447__$1;
(statearr_26465_26483[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto____0 = (function (){
var statearr_26467 = [null,null,null,null,null,null,null,null];
(statearr_26467[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto__);

(statearr_26467[(1)] = (1));

return statearr_26467;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto____1 = (function (state_26447){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_26447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e26468){var ex__2706__auto__ = e26468;
var statearr_26469_26484 = state_26447;
(statearr_26469_26484[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_26447[(4)]))){
var statearr_26470_26485 = state_26447;
(statearr_26470_26485[(1)] = cljs.core.first.call(null,(state_26447[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26486 = state_26447;
state_26447 = G__26486;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto__ = function(state_26447){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto____1.call(this,state_26447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_26471 = f__2726__auto__.call(null);
(statearr_26471[(6)] = c__2725__auto__);

return statearr_26471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

var map__26487 = query_map;
var map__26487__$1 = cljs.core.__destructure_map.call(null,map__26487);
var select = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__26487__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__26488 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__26488,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__26488;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = max_fuel;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_26844){
var state_val_26845 = (state_26844[(1)]);
if((state_val_26845 === (121))){
var inst_26805 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26846_27041 = state_26844__$1;
(statearr_26846_27041[(2)] = inst_26805);

(statearr_26846_27041[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (65))){
var inst_26682 = typeof from === 'string';
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26682)){
var statearr_26847_27042 = state_26844__$1;
(statearr_26847_27042[(1)] = (72));

} else {
var statearr_26848_27043 = state_26844__$1;
(statearr_26848_27043[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (70))){
var inst_26548 = (state_26844[(7)]);
var inst_26550 = (state_26844[(8)]);
var inst_26675 = (state_26844[(2)]);
var inst_26676 = fluree.db.util.async.throw_err.call(null,inst_26675);
var inst_26677 = fluree.db.query.fql.flake_select.call(null,db,inst_26550,fuel,max_fuel,inst_26548,inst_26676);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(71),inst_26677);
} else {
if((state_val_26845 === (62))){
var inst_26655 = (state_26844[(9)]);
var state_26844__$1 = state_26844;
var statearr_26849_27044 = state_26844__$1;
(statearr_26849_27044[(2)] = inst_26655);

(statearr_26849_27044[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (74))){
var inst_26811 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26850_27045 = state_26844__$1;
(statearr_26850_27045[(2)] = inst_26811);

(statearr_26850_27045[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (110))){
var inst_26746 = (state_26844[(10)]);
var state_26844__$1 = state_26844;
var statearr_26851_27046 = state_26844__$1;
(statearr_26851_27046[(2)] = inst_26746);

(statearr_26851_27046[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (130))){
var inst_26831 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26852_27047 = state_26844__$1;
(statearr_26852_27047[(2)] = inst_26831);

(statearr_26852_27047[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (128))){
var inst_26822 = (state_26844[(11)]);
var inst_26827 = fluree.db.util.core.exception_QMARK_.call(null,inst_26822);
var inst_26828 = (!(inst_26827));
var state_26844__$1 = state_26844;
var statearr_26853_27048 = state_26844__$1;
(statearr_26853_27048[(2)] = inst_26828);

(statearr_26853_27048[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (7))){
var inst_26518 = (state_26844[(12)]);
var inst_26518__$1 = selectOne;
var state_26844__$1 = (function (){var statearr_26854 = state_26844;
(statearr_26854[(12)] = inst_26518__$1);

return statearr_26854;
})();
if(cljs.core.truth_(inst_26518__$1)){
var statearr_26855_27049 = state_26844__$1;
(statearr_26855_27049[(1)] = (9));

} else {
var statearr_26856_27050 = state_26844__$1;
(statearr_26856_27050[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (59))){
var inst_26633 = (state_26844[(13)]);
var inst_26538 = (state_26844[(14)]);
var inst_26548 = (state_26844[(7)]);
var inst_26550 = (state_26844[(8)]);
var inst_26647 = (state_26844[(2)]);
var inst_26648 = fluree.db.util.async.throw_err.call(null,inst_26647);
var inst_26649 = cljs.core.sequence.call(null,inst_26633,inst_26648);
var inst_26650 = fluree.db.query.fql.subject_select.call(null,db,inst_26550,fuel,max_fuel,inst_26548,inst_26649,inst_26538);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(60),inst_26650);
} else {
if((state_val_26845 === (86))){
var inst_26538 = (state_26844[(14)]);
var inst_26540 = (state_26844[(15)]);
var inst_26548 = (state_26844[(7)]);
var inst_26550 = (state_26844[(8)]);
var inst_26715 = (state_26844[(2)]);
var inst_26716 = fluree.db.query.fql.subject_select.call(null,db,inst_26550,fuel,max_fuel,inst_26548,inst_26715,inst_26538,inst_26540);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(87),inst_26716);
} else {
if((state_val_26845 === (20))){
var inst_26582 = (state_26844[(2)]);
var inst_26583 = cljs.core.nth.call(null,inst_26582,(0),null);
var inst_26584 = cljs.core.nth.call(null,inst_26582,(1),null);
var inst_26585 = typeof where === 'string';
var state_26844__$1 = (function (){var statearr_26857 = state_26844;
(statearr_26857[(16)] = inst_26583);

(statearr_26857[(17)] = inst_26584);

return statearr_26857;
})();
if(cljs.core.truth_(inst_26585)){
var statearr_26858_27051 = state_26844__$1;
(statearr_26858_27051[(1)] = (30));

} else {
var statearr_26859_27052 = state_26844__$1;
(statearr_26859_27052[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (72))){
var inst_26537 = (state_26844[(18)]);
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26537)){
var statearr_26860_27053 = state_26844__$1;
(statearr_26860_27053[(1)] = (75));

} else {
var statearr_26861_27054 = state_26844__$1;
(statearr_26861_27054[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (58))){
var inst_26641 = (state_26844[(2)]);
var inst_26642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26643 = [from];
var inst_26644 = (new cljs.core.PersistentVector(null,1,(5),inst_26642,inst_26643,null));
var inst_26645 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26644,inst_26641);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(59),inst_26645);
} else {
if((state_val_26845 === (60))){
var inst_26652 = (state_26844[(2)]);
var inst_26653 = fluree.db.util.async.throw_err.call(null,inst_26652);
var state_26844__$1 = state_26844;
var statearr_26862_27055 = state_26844__$1;
(statearr_26862_27055[(2)] = inst_26653);

(statearr_26862_27055[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (27))){
var inst_26567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26568 = [null,null];
var inst_26569 = (new cljs.core.PersistentVector(null,2,(5),inst_26567,inst_26568,null));
var state_26844__$1 = state_26844;
var statearr_26863_27056 = state_26844__$1;
(statearr_26863_27056[(2)] = inst_26569);

(statearr_26863_27056[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (1))){
var state_26844__$1 = state_26844;
var statearr_26864_27057 = state_26844__$1;
(statearr_26864_27057[(2)] = null);

(statearr_26864_27057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (69))){
var inst_26672 = (state_26844[(2)]);
var inst_26673 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_26672);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(70),inst_26673);
} else {
if((state_val_26845 === (101))){
var inst_26778 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26865_27058 = state_26844__$1;
(statearr_26865_27058[(2)] = inst_26778);

(statearr_26865_27058[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (24))){
var inst_26537 = (state_26844[(18)]);
var inst_26562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26563 = [inst_26537,"ASC"];
var inst_26564 = (new cljs.core.PersistentVector(null,2,(5),inst_26562,inst_26563,null));
var state_26844__$1 = state_26844;
var statearr_26866_27059 = state_26844__$1;
(statearr_26866_27059[(2)] = inst_26564);

(statearr_26866_27059[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (102))){
var inst_26752 = (state_26844[(19)]);
var state_26844__$1 = state_26844;
var statearr_26867_27060 = state_26844__$1;
(statearr_26867_27060[(2)] = inst_26752);

(statearr_26867_27060[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (55))){
var inst_26537 = (state_26844[(18)]);
var inst_26633 = (state_26844[(2)]);
var state_26844__$1 = (function (){var statearr_26868 = state_26844;
(statearr_26868[(13)] = inst_26633);

return statearr_26868;
})();
if(cljs.core.truth_(inst_26537)){
var statearr_26869_27061 = state_26844__$1;
(statearr_26869_27061[(1)] = (56));

} else {
var statearr_26870_27062 = state_26844__$1;
(statearr_26870_27062[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (85))){
var inst_26707 = (state_26844[(20)]);
var inst_26711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26712 = [inst_26707];
var inst_26713 = (new cljs.core.PersistentVector(null,1,(5),inst_26711,inst_26712,null));
var state_26844__$1 = state_26844;
var statearr_26871_27063 = state_26844__$1;
(statearr_26871_27063[(2)] = inst_26713);

(statearr_26871_27063[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (39))){
var inst_26538 = (state_26844[(14)]);
var state_26844__$1 = state_26844;
var statearr_26872_27064 = state_26844__$1;
(statearr_26872_27064[(2)] = inst_26538);

(statearr_26872_27064[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (88))){
var inst_26721 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26844__$1 = state_26844;
var statearr_26873_27065 = state_26844__$1;
(statearr_26873_27065[(2)] = inst_26721);

(statearr_26873_27065[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (46))){
var inst_26618 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26618)){
var statearr_26874_27066 = state_26844__$1;
(statearr_26874_27066[(1)] = (47));

} else {
var statearr_26875_27067 = state_26844__$1;
(statearr_26875_27067[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (4))){
var inst_26505 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26876_27068 = state_26844__$1;
(statearr_26876_27068[(2)] = inst_26505);

(statearr_26876_27068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (77))){
var inst_26691 = (state_26844[(2)]);
var inst_26692 = fluree.db.query.range.collection.call(null,db,from,inst_26691);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(78),inst_26692);
} else {
if((state_val_26845 === (106))){
var state_26844__$1 = state_26844;
var statearr_26877_27069 = state_26844__$1;
(statearr_26877_27069[(2)] = null);

(statearr_26877_27069[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (119))){
var inst_26797 = cljs.core.pr_str.call(null,query_map);
var inst_26798 = ["Invalid 'from' in query:",inst_26797].join('');
var inst_26799 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26800 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26801 = cljs.core.PersistentHashMap.fromArrays(inst_26799,inst_26800);
var inst_26802 = cljs.core.ex_info.call(null,inst_26798,inst_26801);
var state_26844__$1 = state_26844;
var statearr_26878_27070 = state_26844__$1;
(statearr_26878_27070[(2)] = inst_26802);

(statearr_26878_27070[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (95))){
var state_26844__$1 = state_26844;
var statearr_26879_27071 = state_26844__$1;
(statearr_26879_27071[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (54))){
var inst_26627 = (state_26844[(21)]);
var state_26844__$1 = state_26844;
var statearr_26881_27072 = state_26844__$1;
(statearr_26881_27072[(2)] = inst_26627);

(statearr_26881_27072[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (92))){
var inst_26726 = (state_26844[(22)]);
var state_26844__$1 = state_26844;
var statearr_26882_27073 = state_26844__$1;
(statearr_26882_27073[(2)] = inst_26726);

(statearr_26882_27073[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (104))){
var inst_26770 = (state_26844[(23)]);
var inst_26770__$1 = (state_26844[(2)]);
var state_26844__$1 = (function (){var statearr_26883 = state_26844;
(statearr_26883[(23)] = inst_26770__$1);

return statearr_26883;
})();
if(cljs.core.truth_(inst_26770__$1)){
var statearr_26884_27074 = state_26844__$1;
(statearr_26884_27074[(1)] = (109));

} else {
var statearr_26885_27075 = state_26844__$1;
(statearr_26885_27075[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (15))){
var inst_26539 = (state_26844[(24)]);
var inst_26541 = (state_26844[(25)]);
var inst_26545 = cljs.core.assoc.call(null,inst_26541,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_26539);
var state_26844__$1 = state_26844;
var statearr_26886_27076 = state_26844__$1;
(statearr_26886_27076[(2)] = inst_26545);

(statearr_26886_27076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (48))){
var inst_26655 = (state_26844[(9)]);
var inst_26655__$1 = typeof from === 'string';
var state_26844__$1 = (function (){var statearr_26887 = state_26844;
(statearr_26887[(9)] = inst_26655__$1);

return statearr_26887;
})();
if(cljs.core.truth_(inst_26655__$1)){
var statearr_26888_27077 = state_26844__$1;
(statearr_26888_27077[(1)] = (61));

} else {
var statearr_26889_27078 = state_26844__$1;
(statearr_26889_27078[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (50))){
var inst_26621 = (state_26844[(26)]);
var inst_26623 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_26624 = cljs.core.comp.call(null,inst_26621,inst_26623);
var state_26844__$1 = state_26844;
var statearr_26890_27079 = state_26844__$1;
(statearr_26890_27079[(2)] = inst_26624);

(statearr_26890_27079[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (116))){
var state_26844__$1 = state_26844;
var statearr_26891_27080 = state_26844__$1;
(statearr_26891_27080[(2)] = null);

(statearr_26891_27080[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (75))){
var inst_26685 = cljs.core.PersistentHashMap.EMPTY;
var state_26844__$1 = state_26844;
var statearr_26892_27081 = state_26844__$1;
(statearr_26892_27081[(2)] = inst_26685);

(statearr_26892_27081[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (99))){
var inst_26746 = (state_26844[(10)]);
var state_26844__$1 = state_26844;
var statearr_26893_27082 = state_26844__$1;
(statearr_26893_27082[(2)] = inst_26746);

(statearr_26893_27082[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (21))){
var inst_26537 = (state_26844[(18)]);
var inst_26554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26555 = cljs.core.second.call(null,inst_26537);
var inst_26556 = cljs.core.first.call(null,inst_26537);
var inst_26557 = [inst_26555,inst_26556];
var inst_26558 = (new cljs.core.PersistentVector(null,2,(5),inst_26554,inst_26557,null));
var state_26844__$1 = state_26844;
var statearr_26894_27083 = state_26844__$1;
(statearr_26894_27083[(2)] = inst_26558);

(statearr_26894_27083[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (31))){
var inst_26612 = (state_26844[(27)]);
var inst_26612__$1 = typeof from === 'string';
var state_26844__$1 = (function (){var statearr_26895 = state_26844;
(statearr_26895[(27)] = inst_26612__$1);

return statearr_26895;
})();
if(cljs.core.truth_(inst_26612__$1)){
var statearr_26896_27084 = state_26844__$1;
(statearr_26896_27084[(1)] = (44));

} else {
var statearr_26897_27085 = state_26844__$1;
(statearr_26897_27085[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (113))){
var state_26844__$1 = state_26844;
var statearr_26898_27086 = state_26844__$1;
(statearr_26898_27086[(2)] = null);

(statearr_26898_27086[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (32))){
var inst_26583 = (state_26844[(16)]);
var inst_26817 = (state_26844[(2)]);
var state_26844__$1 = (function (){var statearr_26899 = state_26844;
(statearr_26899[(28)] = inst_26817);

return statearr_26899;
})();
if(cljs.core.truth_(inst_26583)){
var statearr_26900_27087 = state_26844__$1;
(statearr_26900_27087[(1)] = (122));

} else {
var statearr_26901_27088 = state_26844__$1;
(statearr_26901_27088[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (40))){
var inst_26537 = (state_26844[(18)]);
var inst_26602 = (state_26844[(2)]);
var state_26844__$1 = (function (){var statearr_26902 = state_26844;
(statearr_26902[(29)] = inst_26602);

return statearr_26902;
})();
if(cljs.core.truth_(inst_26537)){
var statearr_26903_27089 = state_26844__$1;
(statearr_26903_27089[(1)] = (41));

} else {
var statearr_26904_27090 = state_26844__$1;
(statearr_26904_27090[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (129))){
var inst_26825 = (state_26844[(30)]);
var state_26844__$1 = state_26844;
var statearr_26905_27091 = state_26844__$1;
(statearr_26905_27091[(2)] = inst_26825);

(statearr_26905_27091[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (91))){
var inst_26728 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_26844__$1 = state_26844;
var statearr_26906_27092 = state_26844__$1;
(statearr_26906_27092[(2)] = inst_26728);

(statearr_26906_27092[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (117))){
var inst_26540 = (state_26844[(15)]);
var state_26844__$1 = state_26844;
var statearr_26907_27093 = state_26844__$1;
(statearr_26907_27093[(2)] = inst_26540);

(statearr_26907_27093[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (108))){
var inst_26767 = (state_26844[(2)]);
var inst_26768 = fluree.db.util.async.throw_err.call(null,inst_26767);
var state_26844__$1 = state_26844;
var statearr_26908_27094 = state_26844__$1;
(statearr_26908_27094[(2)] = inst_26768);

(statearr_26908_27094[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (56))){
var inst_26635 = cljs.core.PersistentHashMap.EMPTY;
var state_26844__$1 = state_26844;
var statearr_26909_27095 = state_26844__$1;
(statearr_26909_27095[(2)] = inst_26635);

(statearr_26909_27095[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (33))){
var state_26844__$1 = state_26844;
var statearr_26910_27096 = state_26844__$1;
(statearr_26910_27096[(2)] = from);

(statearr_26910_27096[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (13))){
var inst_26524 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26525 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26526 = cljs.core.PersistentHashMap.fromArrays(inst_26524,inst_26525);
var inst_26527 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_26526);
var inst_26528 = (function(){throw inst_26527})();
var state_26844__$1 = state_26844;
var statearr_26911_27097 = state_26844__$1;
(statearr_26911_27097[(2)] = inst_26528);

(statearr_26911_27097[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (22))){
var inst_26537 = (state_26844[(18)]);
var inst_26560 = typeof inst_26537 === 'string';
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26560)){
var statearr_26912_27098 = state_26844__$1;
(statearr_26912_27098[(1)] = (24));

} else {
var statearr_26913_27099 = state_26844__$1;
(statearr_26913_27099[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (90))){
var inst_26719 = (state_26844[(31)]);
var inst_26724 = (state_26844[(2)]);
var state_26844__$1 = (function (){var statearr_26914 = state_26844;
(statearr_26914[(32)] = inst_26724);

return statearr_26914;
})();
var statearr_26915_27100 = state_26844__$1;
(statearr_26915_27100[(2)] = inst_26719);

(statearr_26915_27100[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (109))){
var inst_26770 = (state_26844[(23)]);
var inst_26746 = (state_26844[(10)]);
var inst_26772 = cljs.core.conj.call(null,inst_26746,inst_26770);
var state_26844__$1 = state_26844;
var statearr_26916_27101 = state_26844__$1;
(statearr_26916_27101[(2)] = inst_26772);

(statearr_26916_27101[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (36))){
var inst_26537 = (state_26844[(18)]);
var inst_26597 = (state_26844[(2)]);
var inst_26598 = fluree.db.util.async.throw_err.call(null,inst_26597);
var state_26844__$1 = (function (){var statearr_26917 = state_26844;
(statearr_26917[(33)] = inst_26598);

return statearr_26917;
})();
if(cljs.core.truth_(inst_26537)){
var statearr_26918_27102 = state_26844__$1;
(statearr_26918_27102[(1)] = (38));

} else {
var statearr_26919_27103 = state_26844__$1;
(statearr_26919_27103[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (41))){
var state_26844__$1 = state_26844;
var statearr_26920_27104 = state_26844__$1;
(statearr_26920_27104[(2)] = null);

(statearr_26920_27104[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (118))){
var inst_26782 = (state_26844[(34)]);
var inst_26786 = (state_26844[(35)]);
var inst_26548 = (state_26844[(7)]);
var inst_26550 = (state_26844[(8)]);
var inst_26790 = (state_26844[(2)]);
var inst_26791 = fluree.db.query.fql.subject_select.call(null,db,inst_26550,fuel,max_fuel,inst_26548,inst_26782,inst_26786,inst_26790);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(112),inst_26791);
} else {
if((state_val_26845 === (89))){
var state_26844__$1 = state_26844;
var statearr_26921_27105 = state_26844__$1;
(statearr_26921_27105[(2)] = null);

(statearr_26921_27105[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (100))){
var inst_26752 = (state_26844[(19)]);
var inst_26757 = cljs.core.int_QMARK_.call(null,inst_26752);
var state_26844__$1 = state_26844;
if(inst_26757){
var statearr_26922_27106 = state_26844__$1;
(statearr_26922_27106[(1)] = (102));

} else {
var statearr_26923_27107 = state_26844__$1;
(statearr_26923_27107[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (131))){
var inst_26822 = (state_26844[(11)]);
var inst_26836 = cljs.core.first.call(null,inst_26822);
var state_26844__$1 = state_26844;
var statearr_26924_27108 = state_26844__$1;
(statearr_26924_27108[(2)] = inst_26836);

(statearr_26924_27108[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (122))){
var inst_26538 = (state_26844[(14)]);
var inst_26540 = (state_26844[(15)]);
var inst_26583 = (state_26844[(16)]);
var inst_26584 = (state_26844[(17)]);
var inst_26817 = (state_26844[(28)]);
var inst_26819 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_26583,inst_26584,inst_26540,inst_26538,inst_26817);
var state_26844__$1 = state_26844;
var statearr_26925_27109 = state_26844__$1;
(statearr_26925_27109[(2)] = inst_26819);

(statearr_26925_27109[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (43))){
var inst_26602 = (state_26844[(29)]);
var inst_26598 = (state_26844[(33)]);
var inst_26548 = (state_26844[(7)]);
var inst_26550 = (state_26844[(8)]);
var inst_26606 = (state_26844[(2)]);
var inst_26607 = fluree.db.query.fql.subject_select.call(null,db,inst_26550,fuel,max_fuel,inst_26548,inst_26598,inst_26602,inst_26606);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(37),inst_26607);
} else {
if((state_val_26845 === (61))){
var inst_26657 = ["_tx",null,"_block",null];
var inst_26658 = (new cljs.core.PersistentArrayMap(null,2,inst_26657,null));
var inst_26659 = (new cljs.core.PersistentHashSet(null,inst_26658,null));
var inst_26660 = inst_26659.call(null,from);
var state_26844__$1 = state_26844;
var statearr_26926_27110 = state_26844__$1;
(statearr_26926_27110[(2)] = inst_26660);

(statearr_26926_27110[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (29))){
var inst_26572 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26927_27111 = state_26844__$1;
(statearr_26927_27111[(2)] = inst_26572);

(statearr_26927_27111[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (44))){
var inst_26614 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_26615 = clojure.string.includes_QMARK_.call(null,inst_26614,"/");
var state_26844__$1 = state_26844;
var statearr_26928_27112 = state_26844__$1;
(statearr_26928_27112[(2)] = inst_26615);

(statearr_26928_27112[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (93))){
var inst_26731 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26731)){
var statearr_26929_27113 = state_26844__$1;
(statearr_26929_27113[(1)] = (94));

} else {
var statearr_26930_27114 = state_26844__$1;
(statearr_26930_27114[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (6))){
var inst_26515 = (state_26844[(36)]);
var state_26844__$1 = state_26844;
var statearr_26931_27115 = state_26844__$1;
(statearr_26931_27115[(2)] = inst_26515);

(statearr_26931_27115[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (111))){
var inst_26753 = (state_26844[(37)]);
var inst_26775 = (state_26844[(2)]);
var inst_26745 = inst_26753;
var inst_26746 = inst_26775;
var state_26844__$1 = (function (){var statearr_26932 = state_26844;
(statearr_26932[(38)] = inst_26745);

(statearr_26932[(10)] = inst_26746);

return statearr_26932;
})();
var statearr_26933_27116 = state_26844__$1;
(statearr_26933_27116[(2)] = null);

(statearr_26933_27116[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (28))){
var state_26844__$1 = state_26844;
var statearr_26934_27117 = state_26844__$1;
(statearr_26934_27117[(2)] = null);

(statearr_26934_27117[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (64))){
var inst_26537 = (state_26844[(18)]);
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26537)){
var statearr_26935_27118 = state_26844__$1;
(statearr_26935_27118[(1)] = (67));

} else {
var statearr_26936_27119 = state_26844__$1;
(statearr_26936_27119[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (103))){
var state_26844__$1 = state_26844;
if(cljs.core.truth_(fuel)){
var statearr_26937_27120 = state_26844__$1;
(statearr_26937_27120[(1)] = (105));

} else {
var statearr_26938_27121 = state_26844__$1;
(statearr_26938_27121[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (51))){
var inst_26621 = (state_26844[(26)]);
var state_26844__$1 = state_26844;
var statearr_26939_27122 = state_26844__$1;
(statearr_26939_27122[(2)] = inst_26621);

(statearr_26939_27122[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (25))){
var state_26844__$1 = state_26844;
var statearr_26940_27123 = state_26844__$1;
(statearr_26940_27123[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (34))){
var state_26844__$1 = state_26844;
var statearr_26942_27124 = state_26844__$1;
(statearr_26942_27124[(2)] = null);

(statearr_26942_27124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (125))){
var inst_26825 = (state_26844[(30)]);
var inst_26822 = (state_26844[(11)]);
var inst_26825__$1 = cljs.core.coll_QMARK_.call(null,inst_26822);
var state_26844__$1 = (function (){var statearr_26943 = state_26844;
(statearr_26943[(30)] = inst_26825__$1);

return statearr_26943;
})();
if(inst_26825__$1){
var statearr_26944_27125 = state_26844__$1;
(statearr_26944_27125[(1)] = (128));

} else {
var statearr_26945_27126 = state_26844__$1;
(statearr_26945_27126[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (17))){
var inst_26537 = (state_26844[(18)]);
var inst_26548 = (state_26844[(2)]);
var inst_26549 = cljs.core.PersistentHashMap.EMPTY;
var inst_26550 = cljs.core.volatile_BANG_.call(null,inst_26549);
var state_26844__$1 = (function (){var statearr_26946 = state_26844;
(statearr_26946[(7)] = inst_26548);

(statearr_26946[(8)] = inst_26550);

return statearr_26946;
})();
if(cljs.core.truth_(inst_26537)){
var statearr_26947_27127 = state_26844__$1;
(statearr_26947_27127[(1)] = (18));

} else {
var statearr_26948_27128 = state_26844__$1;
(statearr_26948_27128[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (3))){
var inst_26842 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26844__$1,inst_26842);
} else {
if((state_val_26845 === (12))){
var inst_26521 = (state_26844[(39)]);
var state_26844__$1 = state_26844;
var statearr_26949_27129 = state_26844__$1;
(statearr_26949_27129[(2)] = inst_26521);

(statearr_26949_27129[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (2))){
var inst_26515 = (state_26844[(36)]);
var _ = (function (){var statearr_26950 = state_26844;
(statearr_26950[(4)] = cljs.core.cons.call(null,(5),(state_26844[(4)])));

return statearr_26950;
})();
var inst_26515__$1 = select;
var state_26844__$1 = (function (){var statearr_26951 = state_26844;
(statearr_26951[(36)] = inst_26515__$1);

return statearr_26951;
})();
if(cljs.core.truth_(inst_26515__$1)){
var statearr_26952_27130 = state_26844__$1;
(statearr_26952_27130[(1)] = (6));

} else {
var statearr_26953_27131 = state_26844__$1;
(statearr_26953_27131[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (66))){
var inst_26813 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26954_27132 = state_26844__$1;
(statearr_26954_27132[(2)] = inst_26813);

(statearr_26954_27132[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (107))){
var inst_26752 = (state_26844[(19)]);
var inst_26764 = (state_26844[(2)]);
var inst_26765 = fluree.db.dbproto._subid.call(null,db,inst_26752,false);
var state_26844__$1 = (function (){var statearr_26955 = state_26844;
(statearr_26955[(40)] = inst_26764);

return statearr_26955;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(108),inst_26765);
} else {
if((state_val_26845 === (23))){
var inst_26576 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26956_27133 = state_26844__$1;
(statearr_26956_27133[(2)] = inst_26576);

(statearr_26956_27133[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (47))){
var inst_26621 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_26844__$1 = (function (){var statearr_26957 = state_26844;
(statearr_26957[(26)] = inst_26621);

return statearr_26957;
})();
if(cljs.core.truth_(fuel)){
var statearr_26958_27134 = state_26844__$1;
(statearr_26958_27134[(1)] = (50));

} else {
var statearr_26959_27135 = state_26844__$1;
(statearr_26959_27135[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (35))){
var inst_26538 = (state_26844[(14)]);
var inst_26540 = (state_26844[(15)]);
var inst_26591 = (state_26844[(2)]);
var inst_26592 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26593 = [inst_26538,inst_26540];
var inst_26594 = cljs.core.PersistentHashMap.fromArrays(inst_26592,inst_26593);
var inst_26595 = fluree.db.query.fql.where_filter.call(null,db,where,inst_26591,inst_26594);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(36),inst_26595);
} else {
if((state_val_26845 === (127))){
var inst_26834 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26834)){
var statearr_26960_27136 = state_26844__$1;
(statearr_26960_27136[(1)] = (131));

} else {
var statearr_26961_27137 = state_26844__$1;
(statearr_26961_27137[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (82))){
var inst_26809 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26962_27138 = state_26844__$1;
(statearr_26962_27138[(2)] = inst_26809);

(statearr_26962_27138[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (76))){
var inst_26538 = (state_26844[(14)]);
var inst_26540 = (state_26844[(15)]);
var inst_26687 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26688 = [inst_26538,inst_26540];
var inst_26689 = cljs.core.PersistentHashMap.fromArrays(inst_26687,inst_26688);
var state_26844__$1 = state_26844;
var statearr_26963_27139 = state_26844__$1;
(statearr_26963_27139[(2)] = inst_26689);

(statearr_26963_27139[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (97))){
var inst_26745 = (state_26844[(38)]);
var inst_26752 = (state_26844[(19)]);
var inst_26751 = cljs.core.seq.call(null,inst_26745);
var inst_26752__$1 = cljs.core.first.call(null,inst_26751);
var inst_26753 = cljs.core.next.call(null,inst_26751);
var inst_26754 = cljs.core.not.call(null,inst_26752__$1);
var state_26844__$1 = (function (){var statearr_26964 = state_26844;
(statearr_26964[(19)] = inst_26752__$1);

(statearr_26964[(37)] = inst_26753);

return statearr_26964;
})();
if(inst_26754){
var statearr_26965_27140 = state_26844__$1;
(statearr_26965_27140[(1)] = (99));

} else {
var statearr_26966_27141 = state_26844__$1;
(statearr_26966_27141[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (19))){
var inst_26578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26579 = [null,null];
var inst_26580 = (new cljs.core.PersistentVector(null,2,(5),inst_26578,inst_26579,null));
var state_26844__$1 = state_26844;
var statearr_26967_27142 = state_26844__$1;
(statearr_26967_27142[(2)] = inst_26580);

(statearr_26967_27142[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (57))){
var inst_26538 = (state_26844[(14)]);
var inst_26540 = (state_26844[(15)]);
var inst_26637 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26638 = [inst_26538,inst_26540];
var inst_26639 = cljs.core.PersistentHashMap.fromArrays(inst_26637,inst_26638);
var state_26844__$1 = state_26844;
var statearr_26968_27143 = state_26844__$1;
(statearr_26968_27143[(2)] = inst_26639);

(statearr_26968_27143[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (68))){
var inst_26538 = (state_26844[(14)]);
var inst_26540 = (state_26844[(15)]);
var inst_26668 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26669 = [inst_26538,inst_26540];
var inst_26670 = cljs.core.PersistentHashMap.fromArrays(inst_26668,inst_26669);
var state_26844__$1 = state_26844;
var statearr_26969_27144 = state_26844__$1;
(statearr_26969_27144[(2)] = inst_26670);

(statearr_26969_27144[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (11))){
var inst_26532 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26970_27145 = state_26844__$1;
(statearr_26970_27145[(2)] = inst_26532);

(statearr_26970_27145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (115))){
var inst_26537 = (state_26844[(18)]);
var inst_26786 = (state_26844[(2)]);
var state_26844__$1 = (function (){var statearr_26972 = state_26844;
(statearr_26972[(35)] = inst_26786);

return statearr_26972;
})();
if(cljs.core.truth_(inst_26537)){
var statearr_26973_27146 = state_26844__$1;
(statearr_26973_27146[(1)] = (116));

} else {
var statearr_26974_27147 = state_26844__$1;
(statearr_26974_27147[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (9))){
var inst_26518 = (state_26844[(12)]);
var state_26844__$1 = state_26844;
var statearr_26975_27148 = state_26844__$1;
(statearr_26975_27148[(2)] = inst_26518);

(statearr_26975_27148[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (5))){
var _ = (function (){var statearr_26976 = state_26844;
(statearr_26976[(4)] = cljs.core.rest.call(null,(state_26844[(4)])));

return statearr_26976;
})();
var state_26844__$1 = state_26844;
var ex26971 = (state_26844__$1[(2)]);
var statearr_26977_27149 = state_26844__$1;
(statearr_26977_27149[(5)] = ex26971);


if((ex26971 instanceof Error)){
var statearr_26978_27150 = state_26844__$1;
(statearr_26978_27150[(1)] = (4));

(statearr_26978_27150[(5)] = null);

} else {
throw ex26971;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (112))){
var inst_26793 = (state_26844[(2)]);
var inst_26794 = fluree.db.util.async.throw_err.call(null,inst_26793);
var state_26844__$1 = state_26844;
var statearr_26979_27151 = state_26844__$1;
(statearr_26979_27151[(2)] = inst_26794);

(statearr_26979_27151[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (83))){
var inst_26707 = (state_26844[(20)]);
var inst_26706 = (state_26844[(2)]);
var inst_26707__$1 = fluree.db.util.async.throw_err.call(null,inst_26706);
var inst_26708 = (inst_26707__$1 == null);
var state_26844__$1 = (function (){var statearr_26980 = state_26844;
(statearr_26980[(20)] = inst_26707__$1);

return statearr_26980;
})();
if(cljs.core.truth_(inst_26708)){
var statearr_26981_27152 = state_26844__$1;
(statearr_26981_27152[(1)] = (84));

} else {
var statearr_26982_27153 = state_26844__$1;
(statearr_26982_27153[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (14))){
var inst_26530 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26983_27154 = state_26844__$1;
(statearr_26983_27154[(2)] = inst_26530);

(statearr_26983_27154[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (45))){
var inst_26612 = (state_26844[(27)]);
var state_26844__$1 = state_26844;
var statearr_26984_27155 = state_26844__$1;
(statearr_26984_27155[(2)] = inst_26612);

(statearr_26984_27155[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (53))){
var inst_26627 = (state_26844[(21)]);
var inst_26629 = cljs.core.distinct.call(null);
var inst_26630 = cljs.core.comp.call(null,inst_26627,inst_26629);
var state_26844__$1 = state_26844;
var statearr_26985_27156 = state_26844__$1;
(statearr_26985_27156[(2)] = inst_26630);

(statearr_26985_27156[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (78))){
var inst_26548 = (state_26844[(7)]);
var inst_26550 = (state_26844[(8)]);
var inst_26694 = (state_26844[(2)]);
var inst_26695 = fluree.db.util.async.throw_err.call(null,inst_26694);
var inst_26696 = fluree.db.query.fql.flake_select.call(null,db,inst_26550,fuel,max_fuel,inst_26548,inst_26695);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(79),inst_26696);
} else {
if((state_val_26845 === (132))){
var inst_26822 = (state_26844[(11)]);
var state_26844__$1 = state_26844;
var statearr_26986_27157 = state_26844__$1;
(statearr_26986_27157[(2)] = inst_26822);

(statearr_26986_27157[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (26))){
var inst_26574 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_26987_27158 = state_26844__$1;
(statearr_26987_27158[(2)] = inst_26574);

(statearr_26987_27158[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (123))){
var inst_26817 = (state_26844[(28)]);
var state_26844__$1 = state_26844;
var statearr_26988_27159 = state_26844__$1;
(statearr_26988_27159[(2)] = inst_26817);

(statearr_26988_27159[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (16))){
var inst_26541 = (state_26844[(25)]);
var state_26844__$1 = state_26844;
var statearr_26989_27160 = state_26844__$1;
(statearr_26989_27160[(2)] = inst_26541);

(statearr_26989_27160[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (133))){
var inst_26839 = (state_26844[(2)]);
var _ = (function (){var statearr_26990 = state_26844;
(statearr_26990[(4)] = cljs.core.rest.call(null,(state_26844[(4)])));

return statearr_26990;
})();
var state_26844__$1 = state_26844;
var statearr_26991_27161 = state_26844__$1;
(statearr_26991_27161[(2)] = inst_26839);

(statearr_26991_27161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (81))){
var inst_26726 = (state_26844[(22)]);
var inst_26726__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_26844__$1 = (function (){var statearr_26992 = state_26844;
(statearr_26992[(22)] = inst_26726__$1);

return statearr_26992;
})();
if(inst_26726__$1){
var statearr_26993_27162 = state_26844__$1;
(statearr_26993_27162[(1)] = (91));

} else {
var statearr_26994_27163 = state_26844__$1;
(statearr_26994_27163[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (120))){
var state_26844__$1 = state_26844;
var statearr_26995_27164 = state_26844__$1;
(statearr_26995_27164[(2)] = null);

(statearr_26995_27164[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (79))){
var inst_26698 = (state_26844[(2)]);
var inst_26699 = fluree.db.util.async.throw_err.call(null,inst_26698);
var state_26844__$1 = state_26844;
var statearr_26996_27165 = state_26844__$1;
(statearr_26996_27165[(2)] = inst_26699);

(statearr_26996_27165[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (38))){
var state_26844__$1 = state_26844;
var statearr_26997_27166 = state_26844__$1;
(statearr_26997_27166[(2)] = null);

(statearr_26997_27166[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (126))){
var inst_26823 = (state_26844[(41)]);
var state_26844__$1 = state_26844;
var statearr_26998_27167 = state_26844__$1;
(statearr_26998_27167[(2)] = inst_26823);

(statearr_26998_27167[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (98))){
var inst_26537 = (state_26844[(18)]);
var inst_26780 = (state_26844[(2)]);
var inst_26781 = cljs.core.PersistentVector.EMPTY;
var inst_26782 = cljs.core.into.call(null,inst_26781,inst_26780);
var state_26844__$1 = (function (){var statearr_26999 = state_26844;
(statearr_26999[(34)] = inst_26782);

return statearr_26999;
})();
if(cljs.core.truth_(inst_26537)){
var statearr_27000_27168 = state_26844__$1;
(statearr_27000_27168[(1)] = (113));

} else {
var statearr_27001_27169 = state_26844__$1;
(statearr_27001_27169[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (124))){
var inst_26823 = (state_26844[(41)]);
var inst_26822 = (state_26844[(2)]);
var inst_26823__$1 = selectOne;
var state_26844__$1 = (function (){var statearr_27002 = state_26844;
(statearr_27002[(41)] = inst_26823__$1);

(statearr_27002[(11)] = inst_26822);

return statearr_27002;
})();
if(cljs.core.truth_(inst_26823__$1)){
var statearr_27003_27170 = state_26844__$1;
(statearr_27003_27170[(1)] = (125));

} else {
var statearr_27004_27171 = state_26844__$1;
(statearr_27004_27171[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (87))){
var inst_26718 = (state_26844[(2)]);
var inst_26719 = fluree.db.util.async.throw_err.call(null,inst_26718);
var state_26844__$1 = (function (){var statearr_27005 = state_26844;
(statearr_27005[(31)] = inst_26719);

return statearr_27005;
})();
if(cljs.core.truth_(fuel)){
var statearr_27006_27172 = state_26844__$1;
(statearr_27006_27172[(1)] = (88));

} else {
var statearr_27007_27173 = state_26844__$1;
(statearr_27007_27173[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (30))){
var inst_26587 = typeof from === 'string';
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26587)){
var statearr_27008_27174 = state_26844__$1;
(statearr_27008_27174[(1)] = (33));

} else {
var statearr_27009_27175 = state_26844__$1;
(statearr_27009_27175[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (73))){
var inst_26701 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_26844__$1 = state_26844;
if(inst_26701){
var statearr_27010_27176 = state_26844__$1;
(statearr_27010_27176[(1)] = (80));

} else {
var statearr_27011_27177 = state_26844__$1;
(statearr_27011_27177[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (96))){
var inst_26807 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_27012_27178 = state_26844__$1;
(statearr_27012_27178[(2)] = inst_26807);

(statearr_27012_27178[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (10))){
var inst_26521 = (state_26844[(39)]);
var inst_26521__$1 = selectDistinct;
var state_26844__$1 = (function (){var statearr_27013 = state_26844;
(statearr_27013[(39)] = inst_26521__$1);

return statearr_27013;
})();
if(cljs.core.truth_(inst_26521__$1)){
var statearr_27014_27179 = state_26844__$1;
(statearr_27014_27179[(1)] = (12));

} else {
var statearr_27015_27180 = state_26844__$1;
(statearr_27015_27180[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (18))){
var inst_26537 = (state_26844[(18)]);
var inst_26552 = cljs.core.vector_QMARK_.call(null,inst_26537);
var state_26844__$1 = state_26844;
if(inst_26552){
var statearr_27016_27181 = state_26844__$1;
(statearr_27016_27181[(1)] = (21));

} else {
var statearr_27017_27182 = state_26844__$1;
(statearr_27017_27182[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (105))){
var inst_26761 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26844__$1 = state_26844;
var statearr_27018_27183 = state_26844__$1;
(statearr_27018_27183[(2)] = inst_26761);

(statearr_27018_27183[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (52))){
var inst_26627 = (state_26844[(2)]);
var state_26844__$1 = (function (){var statearr_27019 = state_26844;
(statearr_27019[(21)] = inst_26627);

return statearr_27019;
})();
var statearr_27020_27184 = state_26844__$1;
(statearr_27020_27184[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (114))){
var inst_26538 = (state_26844[(14)]);
var state_26844__$1 = state_26844;
var statearr_27022_27185 = state_26844__$1;
(statearr_27022_27185[(2)] = inst_26538);

(statearr_27022_27185[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (67))){
var inst_26666 = cljs.core.PersistentHashMap.EMPTY;
var state_26844__$1 = state_26844;
var statearr_27023_27186 = state_26844__$1;
(statearr_27023_27186[(2)] = inst_26666);

(statearr_27023_27186[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (71))){
var inst_26679 = (state_26844[(2)]);
var inst_26680 = fluree.db.util.async.throw_err.call(null,inst_26679);
var state_26844__$1 = state_26844;
var statearr_27024_27187 = state_26844__$1;
(statearr_27024_27187[(2)] = inst_26680);

(statearr_27024_27187[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (42))){
var inst_26540 = (state_26844[(15)]);
var state_26844__$1 = state_26844;
var statearr_27025_27188 = state_26844__$1;
(statearr_27025_27188[(2)] = inst_26540);

(statearr_27025_27188[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (80))){
var inst_26704 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_26844__$1 = state_26844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26844__$1,(83),inst_26704);
} else {
if((state_val_26845 === (37))){
var inst_26609 = (state_26844[(2)]);
var inst_26610 = fluree.db.util.async.throw_err.call(null,inst_26609);
var state_26844__$1 = state_26844;
var statearr_27026_27189 = state_26844__$1;
(statearr_27026_27189[(2)] = inst_26610);

(statearr_27026_27189[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (63))){
var inst_26663 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
if(cljs.core.truth_(inst_26663)){
var statearr_27027_27190 = state_26844__$1;
(statearr_27027_27190[(1)] = (64));

} else {
var statearr_27028_27191 = state_26844__$1;
(statearr_27028_27191[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (94))){
var inst_26740 = from;
var inst_26741 = cljs.core.seq.call(null,inst_26740);
var inst_26742 = cljs.core.first.call(null,inst_26741);
var inst_26743 = cljs.core.next.call(null,inst_26741);
var inst_26744 = cljs.core.PersistentVector.EMPTY;
var inst_26745 = inst_26740;
var inst_26746 = inst_26744;
var state_26844__$1 = (function (){var statearr_27029 = state_26844;
(statearr_27029[(38)] = inst_26745);

(statearr_27029[(42)] = inst_26743);

(statearr_27029[(43)] = inst_26742);

(statearr_27029[(10)] = inst_26746);

return statearr_27029;
})();
var statearr_27030_27192 = state_26844__$1;
(statearr_27030_27192[(2)] = null);

(statearr_27030_27192[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (8))){
var inst_26539 = (state_26844[(24)]);
var inst_26534 = (state_26844[(2)]);
var inst_26535 = opts_SINGLEQUOTE_;
var inst_26536 = cljs.core.__destructure_map.call(null,inst_26535);
var inst_26537 = cljs.core.get.call(null,inst_26536,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_26538 = cljs.core.get.call(null,inst_26536,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_26539__$1 = cljs.core.get.call(null,inst_26536,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_26540 = cljs.core.get.call(null,inst_26536,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_26541 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_26534,opts_SINGLEQUOTE_);
var inst_26542 = (inst_26539__$1 == null);
var inst_26543 = cljs.core.not.call(null,inst_26542);
var state_26844__$1 = (function (){var statearr_27031 = state_26844;
(statearr_27031[(14)] = inst_26538);

(statearr_27031[(15)] = inst_26540);

(statearr_27031[(18)] = inst_26537);

(statearr_27031[(24)] = inst_26539__$1);

(statearr_27031[(25)] = inst_26541);

return statearr_27031;
})();
if(inst_26543){
var statearr_27032_27193 = state_26844__$1;
(statearr_27032_27193[(1)] = (15));

} else {
var statearr_27033_27194 = state_26844__$1;
(statearr_27033_27194[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (49))){
var inst_26815 = (state_26844[(2)]);
var state_26844__$1 = state_26844;
var statearr_27034_27195 = state_26844__$1;
(statearr_27034_27195[(2)] = inst_26815);

(statearr_27034_27195[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26845 === (84))){
var state_26844__$1 = state_26844;
var statearr_27035_27196 = state_26844__$1;
(statearr_27035_27196[(2)] = null);

(statearr_27035_27196[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2703__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2703__auto____0 = (function (){
var statearr_27036 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27036[(0)] = fluree$db$query$fql$query_$_state_machine__2703__auto__);

(statearr_27036[(1)] = (1));

return statearr_27036;
});
var fluree$db$query$fql$query_$_state_machine__2703__auto____1 = (function (state_26844){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_26844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e27037){var ex__2706__auto__ = e27037;
var statearr_27038_27197 = state_26844;
(statearr_27038_27197[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_26844[(4)]))){
var statearr_27039_27198 = state_26844;
(statearr_27039_27198[(1)] = cljs.core.first.call(null,(state_26844[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27199 = state_26844;
state_26844 = G__27199;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2703__auto__ = function(state_26844){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2703__auto____1.call(this,state_26844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2703__auto____0;
fluree$db$query$fql$query_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2703__auto____1;
return fluree$db$query$fql$query_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_27040 = f__2726__auto__.call(null);
(statearr_27040[(6)] = c__2725__auto__);

return statearr_27040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}

});
