// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14512 = match;
var p1 = cljs.core.nth.call(null,vec__14512,(0),null);
var p2 = cljs.core.nth.call(null,vec__14512,(1),null);
var p3 = cljs.core.nth.call(null,vec__14512,(2),null);
var t = cljs.core.nth.call(null,vec__14512,(3),null);
var op = cljs.core.nth.call(null,vec__14512,(4),null);
var m = cljs.core.nth.call(null,vec__14512,(5),null);
var G__14515 = idx;
var G__14515__$1 = (((G__14515 instanceof cljs.core.Keyword))?G__14515.fqn:null);
switch (G__14515__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14515__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14517 = idx;
var G__14517__$1 = (((G__14517 instanceof cljs.core.Keyword))?G__14517.fqn:null);
switch (G__14517__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14517__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14519 = idx;
var G__14519__$1 = (((G__14519 instanceof cljs.core.Keyword))?G__14519.fqn:null);
switch (G__14519__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14519__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14522 = arguments.length;
switch (G__14522) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14523 = (function (){var pred__14526 = cljs.core.identical_QMARK_;
var expr__14527 = test;
if(cljs.core.truth_(pred__14526.call(null,cljs.core._EQ_,expr__14527))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14526.call(null,cljs.core._LT_,expr__14527))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14526.call(null,cljs.core._LT__EQ_,expr__14527))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14526.call(null,cljs.core._GT_,expr__14527))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14526.call(null,cljs.core._GT__EQ_,expr__14527))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14527)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__14523,(0),null);
var start_match = cljs.core.nth.call(null,vec__14523,(1),null);
var end_test = cljs.core.nth.call(null,vec__14523,(2),null);
var end_match = cljs.core.nth.call(null,vec__14523,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_14766){
var state_val_14767 = (state_14766[(1)]);
if((state_val_14767 === (65))){
var inst_14681 = (state_14766[(7)]);
var inst_14737 = (state_14766[(8)]);
var inst_14737__$1 = (state_14766[(2)]);
var inst_14738 = cljs.core.count.call(null,inst_14737__$1);
var state_14766__$1 = (function (){var statearr_14768 = state_14766;
(statearr_14768[(9)] = inst_14738);

(statearr_14768[(8)] = inst_14737__$1);

return statearr_14768;
})();
if(cljs.core.truth_(inst_14681)){
var statearr_14769_14906 = state_14766__$1;
(statearr_14769_14906[(1)] = (81));

} else {
var statearr_14770_14907 = state_14766__$1;
(statearr_14770_14907[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (70))){
var inst_14712 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
if(cljs.core.truth_(inst_14712)){
var statearr_14771_14908 = state_14766__$1;
(statearr_14771_14908[(1)] = (71));

} else {
var statearr_14772_14909 = state_14766__$1;
(statearr_14772_14909[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (62))){
var inst_14651 = (state_14766[(10)]);
var inst_14665 = (state_14766[(11)]);
var inst_14680 = (state_14766[(2)]);
var inst_14681 = fluree.db.dbproto._rhs.call(null,inst_14665);
var state_14766__$1 = (function (){var statearr_14773 = state_14766;
(statearr_14773[(7)] = inst_14681);

(statearr_14773[(12)] = inst_14680);

return statearr_14773;
})();
if(cljs.core.truth_(inst_14651)){
var statearr_14774_14910 = state_14766__$1;
(statearr_14774_14910[(1)] = (63));

} else {
var statearr_14775_14911 = state_14766__$1;
(statearr_14775_14911[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (74))){
var inst_14705 = (state_14766[(13)]);
var inst_14719 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_14705);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(77),inst_14719);
} else {
if((state_val_14767 === (7))){
var inst_14542 = (state_14766[(14)]);
var state_14766__$1 = state_14766;
var statearr_14776_14912 = state_14766__$1;
(statearr_14776_14912[(2)] = inst_14542);

(statearr_14776_14912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (59))){
var inst_14627 = (state_14766[(15)]);
var inst_14628 = (state_14766[(16)]);
var inst_14672 = (state_14766[(17)]);
var inst_14671 = (state_14766[(2)]);
var inst_14672__$1 = fluree.db.util.async.throw_err.call(null,inst_14671);
var inst_14673 = fluree.db.flake.subrange.call(null,inst_14672__$1,start_test,inst_14627,end_test,inst_14628);
var inst_14674 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_14627,inst_14628);
var state_14766__$1 = (function (){var statearr_14777 = state_14766;
(statearr_14777[(17)] = inst_14672__$1);

(statearr_14777[(18)] = inst_14673);

return statearr_14777;
})();
if(inst_14674){
var statearr_14778_14913 = state_14766__$1;
(statearr_14778_14913[(1)] = (60));

} else {
var statearr_14779_14914 = state_14766__$1;
(statearr_14779_14914[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (86))){
var inst_14746 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14780_14915 = state_14766__$1;
(statearr_14780_14915[(2)] = inst_14746);

(statearr_14780_14915[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (20))){
var inst_14543 = (state_14766[(19)]);
var inst_14591 = (state_14766[(20)]);
var inst_14590 = (state_14766[(2)]);
var inst_14591__$1 = (inst_14543 == null);
var state_14766__$1 = (function (){var statearr_14781 = state_14766;
(statearr_14781[(21)] = inst_14590);

(statearr_14781[(20)] = inst_14591__$1);

return statearr_14781;
})();
if(cljs.core.truth_(inst_14591__$1)){
var statearr_14782_14916 = state_14766__$1;
(statearr_14782_14916[(1)] = (22));

} else {
var statearr_14783_14917 = state_14766__$1;
(statearr_14783_14917[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (72))){
var inst_14698 = (state_14766[(22)]);
var inst_14716 = (inst_14698 + (1));
var inst_14717 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14766__$1 = (function (){var statearr_14784 = state_14766;
(statearr_14784[(23)] = inst_14716);

return statearr_14784;
})();
if(cljs.core.truth_(inst_14717)){
var statearr_14785_14918 = state_14766__$1;
(statearr_14785_14918[(1)] = (74));

} else {
var statearr_14786_14919 = state_14766__$1;
(statearr_14786_14919[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (58))){
var inst_14761 = (state_14766[(2)]);
var _ = (function (){var statearr_14787 = state_14766;
(statearr_14787[(4)] = cljs.core.rest.call(null,(state_14766[(4)])));

return statearr_14787;
})();
var state_14766__$1 = state_14766;
var statearr_14788_14920 = state_14766__$1;
(statearr_14788_14920[(2)] = inst_14761);

(statearr_14788_14920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (60))){
var inst_14644 = (state_14766[(24)]);
var inst_14627 = (state_14766[(15)]);
var inst_14545 = (state_14766[(25)]);
var inst_14626 = (state_14766[(26)]);
var inst_14617 = (state_14766[(27)]);
var inst_14628 = (state_14766[(16)]);
var inst_14599 = (state_14766[(28)]);
var inst_14667 = (state_14766[(29)]);
var inst_14638 = (state_14766[(30)]);
var inst_14633 = (state_14766[(31)]);
var inst_14666 = (state_14766[(32)]);
var inst_14634 = (state_14766[(33)]);
var inst_14548 = (state_14766[(34)]);
var inst_14590 = (state_14766[(21)]);
var inst_14645 = (state_14766[(35)]);
var inst_14672 = (state_14766[(17)]);
var inst_14608 = (state_14766[(36)]);
var inst_14552 = (state_14766[(37)]);
var inst_14581 = (state_14766[(38)]);
var inst_14563 = (state_14766[(39)]);
var inst_14553 = (state_14766[(40)]);
var inst_14572 = (state_14766[(41)]);
var inst_14546 = (state_14766[(42)]);
var inst_14660 = (state_14766[(43)]);
var inst_14651 = (state_14766[(10)]);
var inst_14655 = (state_14766[(44)]);
var inst_14673 = (state_14766[(18)]);
var inst_14541 = (state_14766[(45)]);
var inst_14665 = (state_14766[(11)]);
var inst_14676 = (function (){var no_filter_QMARK_ = inst_14651;
var next_node = inst_14665;
var flakes = inst_14672;
var s1 = inst_14563;
var o2 = inst_14590;
var t1 = inst_14545;
var i = inst_14666;
var m1 = inst_14617;
var root_node = inst_14660;
var to_t = inst_14645;
var s2 = inst_14572;
var vec__14538 = inst_14548;
var p2 = inst_14608;
var permissions = inst_14634;
var limit = inst_14633;
var start_flake = inst_14627;
var vec__14535 = inst_14541;
var acc = inst_14667;
var t2 = inst_14552;
var op1 = inst_14546;
var o1 = inst_14581;
var end_flake = inst_14628;
var base_result = inst_14673;
var p1 = inst_14599;
var idx_compare = inst_14638;
var op2 = inst_14553;
var from_t = inst_14644;
var m2 = inst_14626;
var novelty = inst_14655;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_14677 = cljs.core.reduce.call(null,inst_14676,inst_14673,inst_14673);
var state_14766__$1 = state_14766;
var statearr_14789_14921 = state_14766__$1;
(statearr_14789_14921[(2)] = inst_14677);

(statearr_14789_14921[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (27))){
var inst_14600 = (state_14766[(46)]);
var inst_14550 = (state_14766[(47)]);
var inst_14599 = (state_14766[(2)]);
var inst_14600__$1 = (inst_14550 == null);
var state_14766__$1 = (function (){var statearr_14790 = state_14766;
(statearr_14790[(28)] = inst_14599);

(statearr_14790[(46)] = inst_14600__$1);

return statearr_14790;
})();
if(cljs.core.truth_(inst_14600__$1)){
var statearr_14791_14922 = state_14766__$1;
(statearr_14791_14922[(1)] = (28));

} else {
var statearr_14792_14923 = state_14766__$1;
(statearr_14792_14923[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (1))){
var state_14766__$1 = state_14766;
var statearr_14793_14924 = state_14766__$1;
(statearr_14793_14924[(2)] = null);

(statearr_14793_14924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (69))){
var inst_14633 = (state_14766[(31)]);
var inst_14698 = (state_14766[(22)]);
var inst_14710 = (inst_14698 > inst_14633);
var state_14766__$1 = state_14766;
var statearr_14794_14925 = state_14766__$1;
(statearr_14794_14925[(2)] = inst_14710);

(statearr_14794_14925[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (24))){
var inst_14595 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
if(cljs.core.truth_(inst_14595)){
var statearr_14795_14926 = state_14766__$1;
(statearr_14795_14926[(1)] = (25));

} else {
var statearr_14796_14927 = state_14766__$1;
(statearr_14796_14927[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (55))){
var inst_14627 = (state_14766[(15)]);
var inst_14660 = (state_14766[(43)]);
var inst_14659 = (state_14766[(2)]);
var inst_14660__$1 = fluree.db.util.async.throw_err.call(null,inst_14659);
var inst_14661 = fluree.db.dbproto._lookup_leaf.call(null,inst_14660__$1,inst_14627);
var state_14766__$1 = (function (){var statearr_14797 = state_14766;
(statearr_14797[(43)] = inst_14660__$1);

return statearr_14797;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(56),inst_14661);
} else {
if((state_val_14767 === (85))){
var inst_14741 = (state_14766[(48)]);
var state_14766__$1 = state_14766;
var statearr_14798_14928 = state_14766__$1;
(statearr_14798_14928[(2)] = inst_14741);

(statearr_14798_14928[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (39))){
var inst_14615 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14799_14929 = state_14766__$1;
(statearr_14799_14929[(2)] = inst_14615);

(statearr_14799_14929[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (88))){
var inst_14681 = (state_14766[(7)]);
var inst_14660 = (state_14766[(43)]);
var inst_14753 = fluree.db.dbproto._lookup_leaf.call(null,inst_14660,inst_14681);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(90),inst_14753);
} else {
if((state_val_14767 === (46))){
var inst_14629 = (state_14766[(49)]);
var state_14766__$1 = state_14766;
var statearr_14800_14930 = state_14766__$1;
(statearr_14800_14930[(2)] = inst_14629);

(statearr_14800_14930[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (4))){
var inst_14529 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14801_14931 = state_14766__$1;
(statearr_14801_14931[(2)] = inst_14529);

(statearr_14801_14931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (77))){
var inst_14721 = (state_14766[(2)]);
var inst_14722 = fluree.db.util.async.throw_err.call(null,inst_14721);
var state_14766__$1 = state_14766;
if(cljs.core.truth_(inst_14722)){
var statearr_14802_14932 = state_14766__$1;
(statearr_14802_14932[(1)] = (78));

} else {
var statearr_14803_14933 = state_14766__$1;
(statearr_14803_14933[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (54))){
var inst_14651 = (state_14766[(2)]);
var inst_14652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14653 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14654 = (new cljs.core.PersistentVector(null,2,(5),inst_14652,inst_14653,null));
var inst_14655 = cljs.core.get_in.call(null,db,inst_14654);
var inst_14656 = cljs.core.get.call(null,db,idx);
var inst_14657 = fluree.db.dbproto._resolve.call(null,inst_14656);
var state_14766__$1 = (function (){var statearr_14804 = state_14766;
(statearr_14804[(10)] = inst_14651);

(statearr_14804[(44)] = inst_14655);

return statearr_14804;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(55),inst_14657);
} else {
if((state_val_14767 === (15))){
var inst_14544 = (state_14766[(50)]);
var state_14766__$1 = state_14766;
var statearr_14805_14934 = state_14766__$1;
(statearr_14805_14934[(2)] = inst_14544);

(statearr_14805_14934[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (48))){
var inst_14639 = (state_14766[(51)]);
var inst_14633 = (state_14766[(2)]);
var inst_14634 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14636 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14637 = (new cljs.core.PersistentVector(null,3,(5),inst_14635,inst_14636,null));
var inst_14638 = cljs.core.get_in.call(null,db,inst_14637);
var inst_14639__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14766__$1 = (function (){var statearr_14806 = state_14766;
(statearr_14806[(30)] = inst_14638);

(statearr_14806[(31)] = inst_14633);

(statearr_14806[(33)] = inst_14634);

(statearr_14806[(51)] = inst_14639__$1);

return statearr_14806;
})();
if(cljs.core.truth_(inst_14639__$1)){
var statearr_14807_14935 = state_14766__$1;
(statearr_14807_14935[(1)] = (49));

} else {
var statearr_14808_14936 = state_14766__$1;
(statearr_14808_14936[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (50))){
var inst_14642 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14766__$1 = state_14766;
var statearr_14809_14937 = state_14766__$1;
(statearr_14809_14937[(2)] = inst_14642);

(statearr_14809_14937[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (75))){
var inst_14699 = (state_14766[(52)]);
var state_14766__$1 = state_14766;
var statearr_14810_14938 = state_14766__$1;
(statearr_14810_14938[(2)] = inst_14699);

(statearr_14810_14938[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (21))){
var inst_14586 = (state_14766[(2)]);
var inst_14587 = fluree.db.util.async.throw_err.call(null,inst_14586);
var state_14766__$1 = state_14766;
var statearr_14811_14939 = state_14766__$1;
(statearr_14811_14939[(2)] = inst_14587);

(statearr_14811_14939[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (31))){
var state_14766__$1 = state_14766;
var statearr_14812_14940 = state_14766__$1;
(statearr_14812_14940[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14812_14940[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (32))){
var inst_14550 = (state_14766[(47)]);
var state_14766__$1 = state_14766;
var statearr_14813_14941 = state_14766__$1;
(statearr_14813_14941[(2)] = inst_14550);

(statearr_14813_14941[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (40))){
var inst_14554 = (state_14766[(53)]);
var state_14766__$1 = state_14766;
var statearr_14814_14942 = state_14766__$1;
(statearr_14814_14942[(2)] = inst_14554);

(statearr_14814_14942[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (56))){
var inst_14663 = (state_14766[(2)]);
var inst_14664 = fluree.db.util.async.throw_err.call(null,inst_14663);
var inst_14665 = inst_14664;
var inst_14666 = (0);
var inst_14667 = null;
var state_14766__$1 = (function (){var statearr_14815 = state_14766;
(statearr_14815[(29)] = inst_14667);

(statearr_14815[(32)] = inst_14666);

(statearr_14815[(11)] = inst_14665);

return statearr_14815;
})();
var statearr_14816_14943 = state_14766__$1;
(statearr_14816_14943[(2)] = null);

(statearr_14816_14943[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (33))){
var inst_14547 = (state_14766[(54)]);
var inst_14608 = (state_14766[(2)]);
var state_14766__$1 = (function (){var statearr_14817 = state_14766;
(statearr_14817[(36)] = inst_14608);

return statearr_14817;
})();
if(cljs.core.truth_(inst_14547)){
var statearr_14818_14944 = state_14766__$1;
(statearr_14818_14944[(1)] = (34));

} else {
var statearr_14819_14945 = state_14766__$1;
(statearr_14819_14945[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (13))){
var inst_14568 = (state_14766[(2)]);
var inst_14569 = fluree.db.util.async.throw_err.call(null,inst_14568);
var state_14766__$1 = state_14766;
var statearr_14820_14946 = state_14766__$1;
(statearr_14820_14946[(2)] = inst_14569);

(statearr_14820_14946[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (22))){
var inst_14581 = (state_14766[(38)]);
var state_14766__$1 = state_14766;
var statearr_14821_14947 = state_14766__$1;
(statearr_14821_14947[(2)] = inst_14581);

(statearr_14821_14947[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (90))){
var inst_14738 = (state_14766[(9)]);
var inst_14737 = (state_14766[(8)]);
var inst_14755 = (state_14766[(2)]);
var inst_14756 = fluree.db.util.async.throw_err.call(null,inst_14755);
var inst_14665 = inst_14756;
var inst_14666 = inst_14738;
var inst_14667 = inst_14737;
var state_14766__$1 = (function (){var statearr_14822 = state_14766;
(statearr_14822[(29)] = inst_14667);

(statearr_14822[(32)] = inst_14666);

(statearr_14822[(11)] = inst_14665);

return statearr_14822;
})();
var statearr_14823_14948 = state_14766__$1;
(statearr_14823_14948[(2)] = null);

(statearr_14823_14948[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (36))){
var inst_14554 = (state_14766[(53)]);
var inst_14617 = (state_14766[(2)]);
var state_14766__$1 = (function (){var statearr_14824 = state_14766;
(statearr_14824[(27)] = inst_14617);

return statearr_14824;
})();
if(cljs.core.truth_(inst_14554)){
var statearr_14825_14949 = state_14766__$1;
(statearr_14825_14949[(1)] = (40));

} else {
var statearr_14826_14950 = state_14766__$1;
(statearr_14826_14950[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (41))){
var inst_14620 = (cljs.core._LT__EQ_ === end_test);
var state_14766__$1 = state_14766;
if(cljs.core.truth_(inst_14620)){
var statearr_14827_14951 = state_14766__$1;
(statearr_14827_14951[(1)] = (43));

} else {
var statearr_14828_14952 = state_14766__$1;
(statearr_14828_14952[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (89))){
var inst_14759 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14829_14953 = state_14766__$1;
(statearr_14829_14953[(2)] = inst_14759);

(statearr_14829_14953[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (43))){
var state_14766__$1 = state_14766;
var statearr_14830_14954 = state_14766__$1;
(statearr_14830_14954[(2)] = (2147483647));

(statearr_14830_14954[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (61))){
var inst_14673 = (state_14766[(18)]);
var state_14766__$1 = state_14766;
var statearr_14831_14955 = state_14766__$1;
(statearr_14831_14955[(2)] = inst_14673);

(statearr_14831_14955[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (29))){
var inst_14600 = (state_14766[(46)]);
var state_14766__$1 = state_14766;
var statearr_14832_14956 = state_14766__$1;
(statearr_14832_14956[(2)] = inst_14600);

(statearr_14832_14956[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (44))){
var state_14766__$1 = state_14766;
var statearr_14833_14957 = state_14766__$1;
(statearr_14833_14957[(2)] = fluree.db.util.core.min_integer);

(statearr_14833_14957[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (6))){
var inst_14542 = (state_14766[(14)]);
var inst_14557 = fluree.db.dbproto._subid.call(null,db,inst_14542);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(9),inst_14557);
} else {
if((state_val_14767 === (28))){
var inst_14590 = (state_14766[(21)]);
var state_14766__$1 = state_14766;
var statearr_14834_14958 = state_14766__$1;
(statearr_14834_14958[(2)] = inst_14590);

(statearr_14834_14958[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (64))){
var inst_14666 = (state_14766[(32)]);
var inst_14680 = (state_14766[(12)]);
var inst_14694 = cljs.core.seq.call(null,inst_14680);
var inst_14695 = cljs.core.first.call(null,inst_14694);
var inst_14696 = cljs.core.next.call(null,inst_14694);
var inst_14697 = inst_14680;
var inst_14698 = inst_14666;
var inst_14699 = inst_14680;
var state_14766__$1 = (function (){var statearr_14835 = state_14766;
(statearr_14835[(55)] = inst_14697);

(statearr_14835[(52)] = inst_14699);

(statearr_14835[(56)] = inst_14696);

(statearr_14835[(57)] = inst_14695);

(statearr_14835[(22)] = inst_14698);

return statearr_14835;
})();
var statearr_14836_14959 = state_14766__$1;
(statearr_14836_14959[(2)] = null);

(statearr_14836_14959[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (51))){
var inst_14644 = (state_14766[(2)]);
var inst_14645 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_14646 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14766__$1 = (function (){var statearr_14837 = state_14766;
(statearr_14837[(24)] = inst_14644);

(statearr_14837[(35)] = inst_14645);

return statearr_14837;
})();
if(cljs.core.truth_(inst_14646)){
var statearr_14838_14960 = state_14766__$1;
(statearr_14838_14960[(1)] = (52));

} else {
var statearr_14839_14961 = state_14766__$1;
(statearr_14839_14961[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (25))){
var state_14766__$1 = state_14766;
var statearr_14840_14962 = state_14766__$1;
(statearr_14840_14962[(2)] = (-1));

(statearr_14840_14962[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (34))){
var inst_14547 = (state_14766[(54)]);
var state_14766__$1 = state_14766;
var statearr_14841_14963 = state_14766__$1;
(statearr_14841_14963[(2)] = inst_14547);

(statearr_14841_14963[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (17))){
var inst_14577 = (state_14766[(2)]);
var inst_14578 = fluree.db.util.async.throw_err.call(null,inst_14577);
var state_14766__$1 = state_14766;
var statearr_14842_14964 = state_14766__$1;
(statearr_14842_14964[(2)] = inst_14578);

(statearr_14842_14964[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (3))){
var inst_14764 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14766__$1,inst_14764);
} else {
if((state_val_14767 === (12))){
var inst_14544 = (state_14766[(50)]);
var inst_14572 = (state_14766[(2)]);
var inst_14573 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14544);
var state_14766__$1 = (function (){var statearr_14843 = state_14766;
(statearr_14843[(41)] = inst_14572);

return statearr_14843;
})();
if(inst_14573){
var statearr_14844_14965 = state_14766__$1;
(statearr_14844_14965[(1)] = (14));

} else {
var statearr_14845_14966 = state_14766__$1;
(statearr_14845_14966[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (2))){
var inst_14542 = (state_14766[(14)]);
var inst_14548 = (state_14766[(34)]);
var inst_14541 = (state_14766[(45)]);
var _ = (function (){var statearr_14846 = state_14766;
(statearr_14846[(4)] = cljs.core.cons.call(null,(5),(state_14766[(4)])));

return statearr_14846;
})();
var inst_14541__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_14542__$1 = cljs.core.nth.call(null,inst_14541__$1,(0),null);
var inst_14543 = cljs.core.nth.call(null,inst_14541__$1,(1),null);
var inst_14544 = cljs.core.nth.call(null,inst_14541__$1,(2),null);
var inst_14545 = cljs.core.nth.call(null,inst_14541__$1,(3),null);
var inst_14546 = cljs.core.nth.call(null,inst_14541__$1,(4),null);
var inst_14547 = cljs.core.nth.call(null,inst_14541__$1,(5),null);
var inst_14548__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_14549 = cljs.core.nth.call(null,inst_14548__$1,(0),null);
var inst_14550 = cljs.core.nth.call(null,inst_14548__$1,(1),null);
var inst_14551 = cljs.core.nth.call(null,inst_14548__$1,(2),null);
var inst_14552 = cljs.core.nth.call(null,inst_14548__$1,(3),null);
var inst_14553 = cljs.core.nth.call(null,inst_14548__$1,(4),null);
var inst_14554 = cljs.core.nth.call(null,inst_14548__$1,(5),null);
var inst_14555 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14542__$1);
var state_14766__$1 = (function (){var statearr_14847 = state_14766;
(statearr_14847[(25)] = inst_14545);

(statearr_14847[(14)] = inst_14542__$1);

(statearr_14847[(34)] = inst_14548__$1);

(statearr_14847[(50)] = inst_14544);

(statearr_14847[(37)] = inst_14552);

(statearr_14847[(58)] = inst_14549);

(statearr_14847[(19)] = inst_14543);

(statearr_14847[(40)] = inst_14553);

(statearr_14847[(53)] = inst_14554);

(statearr_14847[(47)] = inst_14550);

(statearr_14847[(54)] = inst_14547);

(statearr_14847[(42)] = inst_14546);

(statearr_14847[(45)] = inst_14541__$1);

(statearr_14847[(59)] = inst_14551);

return statearr_14847;
})();
if(inst_14555){
var statearr_14848_14967 = state_14766__$1;
(statearr_14848_14967[(1)] = (6));

} else {
var statearr_14849_14968 = state_14766__$1;
(statearr_14849_14968[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (66))){
var inst_14697 = (state_14766[(55)]);
var inst_14707 = (state_14766[(60)]);
var inst_14705 = (state_14766[(13)]);
var inst_14704 = cljs.core.seq.call(null,inst_14697);
var inst_14705__$1 = cljs.core.first.call(null,inst_14704);
var inst_14706 = cljs.core.next.call(null,inst_14704);
var inst_14707__$1 = (inst_14705__$1 == null);
var state_14766__$1 = (function (){var statearr_14850 = state_14766;
(statearr_14850[(60)] = inst_14707__$1);

(statearr_14850[(61)] = inst_14706);

(statearr_14850[(13)] = inst_14705__$1);

return statearr_14850;
})();
if(cljs.core.truth_(inst_14707__$1)){
var statearr_14851_14969 = state_14766__$1;
(statearr_14851_14969[(1)] = (68));

} else {
var statearr_14852_14970 = state_14766__$1;
(statearr_14852_14970[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (23))){
var inst_14591 = (state_14766[(20)]);
var state_14766__$1 = state_14766;
var statearr_14853_14971 = state_14766__$1;
(statearr_14853_14971[(2)] = inst_14591);

(statearr_14853_14971[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (47))){
var state_14766__$1 = state_14766;
var statearr_14854_14972 = state_14766__$1;
(statearr_14854_14972[(2)] = fluree.db.util.core.max_long);

(statearr_14854_14972[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (35))){
var inst_14611 = (cljs.core._GT__EQ_ === start_test);
var state_14766__$1 = state_14766;
if(cljs.core.truth_(inst_14611)){
var statearr_14855_14973 = state_14766__$1;
(statearr_14855_14973[(1)] = (37));

} else {
var statearr_14856_14974 = state_14766__$1;
(statearr_14856_14974[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (82))){
var inst_14681 = (state_14766[(7)]);
var state_14766__$1 = state_14766;
var statearr_14857_14975 = state_14766__$1;
(statearr_14857_14975[(2)] = inst_14681);

(statearr_14857_14975[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (76))){
var inst_14706 = (state_14766[(61)]);
var inst_14716 = (state_14766[(23)]);
var inst_14730 = (state_14766[(2)]);
var inst_14697 = inst_14706;
var inst_14698 = inst_14716;
var inst_14699 = inst_14730;
var state_14766__$1 = (function (){var statearr_14858 = state_14766;
(statearr_14858[(55)] = inst_14697);

(statearr_14858[(52)] = inst_14699);

(statearr_14858[(22)] = inst_14698);

return statearr_14858;
})();
var statearr_14859_14976 = state_14766__$1;
(statearr_14859_14976[(2)] = null);

(statearr_14859_14976[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (19))){
var inst_14551 = (state_14766[(59)]);
var state_14766__$1 = state_14766;
var statearr_14860_14977 = state_14766__$1;
(statearr_14860_14977[(2)] = inst_14551);

(statearr_14860_14977[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (57))){
var inst_14644 = (state_14766[(24)]);
var inst_14645 = (state_14766[(35)]);
var inst_14655 = (state_14766[(44)]);
var inst_14665 = (state_14766[(11)]);
var inst_14669 = fluree.db.dbproto._resolve_history_range.call(null,inst_14665,inst_14644,inst_14645,inst_14655);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(59),inst_14669);
} else {
if((state_val_14767 === (68))){
var inst_14707 = (state_14766[(60)]);
var state_14766__$1 = state_14766;
var statearr_14861_14978 = state_14766__$1;
(statearr_14861_14978[(2)] = inst_14707);

(statearr_14861_14978[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (11))){
var inst_14549 = (state_14766[(58)]);
var state_14766__$1 = state_14766;
var statearr_14863_14979 = state_14766__$1;
(statearr_14863_14979[(2)] = inst_14549);

(statearr_14863_14979[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (9))){
var inst_14559 = (state_14766[(2)]);
var inst_14560 = fluree.db.util.async.throw_err.call(null,inst_14559);
var state_14766__$1 = state_14766;
var statearr_14864_14980 = state_14766__$1;
(statearr_14864_14980[(2)] = inst_14560);

(statearr_14864_14980[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (5))){
var _ = (function (){var statearr_14865 = state_14766;
(statearr_14865[(4)] = cljs.core.rest.call(null,(state_14766[(4)])));

return statearr_14865;
})();
var state_14766__$1 = state_14766;
var ex14862 = (state_14766__$1[(2)]);
var statearr_14866_14981 = state_14766__$1;
(statearr_14866_14981[(5)] = ex14862);


if((ex14862 instanceof Error)){
var statearr_14867_14982 = state_14766__$1;
(statearr_14867_14982[(1)] = (4));

(statearr_14867_14982[(5)] = null);

} else {
throw ex14862;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (83))){
var inst_14749 = (state_14766[(2)]);
var inst_14750 = cljs.core.not.call(null,inst_14749);
var state_14766__$1 = state_14766;
if(inst_14750){
var statearr_14868_14983 = state_14766__$1;
(statearr_14868_14983[(1)] = (87));

} else {
var statearr_14869_14984 = state_14766__$1;
(statearr_14869_14984[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (14))){
var inst_14544 = (state_14766[(50)]);
var inst_14575 = fluree.db.dbproto._subid.call(null,db,inst_14544);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(17),inst_14575);
} else {
if((state_val_14767 === (45))){
var inst_14624 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14870_14985 = state_14766__$1;
(statearr_14870_14985[(2)] = inst_14624);

(statearr_14870_14985[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (53))){
var state_14766__$1 = state_14766;
var statearr_14871_14986 = state_14766__$1;
(statearr_14871_14986[(2)] = true);

(statearr_14871_14986[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (78))){
var inst_14699 = (state_14766[(52)]);
var state_14766__$1 = state_14766;
var statearr_14872_14987 = state_14766__$1;
(statearr_14872_14987[(2)] = inst_14699);

(statearr_14872_14987[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (26))){
var inst_14543 = (state_14766[(19)]);
var state_14766__$1 = state_14766;
var statearr_14873_14988 = state_14766__$1;
(statearr_14873_14988[(2)] = inst_14543);

(statearr_14873_14988[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (16))){
var inst_14551 = (state_14766[(59)]);
var inst_14581 = (state_14766[(2)]);
var inst_14582 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14551);
var state_14766__$1 = (function (){var statearr_14874 = state_14766;
(statearr_14874[(38)] = inst_14581);

return statearr_14874;
})();
if(inst_14582){
var statearr_14875_14989 = state_14766__$1;
(statearr_14875_14989[(1)] = (18));

} else {
var statearr_14876_14990 = state_14766__$1;
(statearr_14876_14990[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (81))){
var inst_14628 = (state_14766[(16)]);
var inst_14638 = (state_14766[(30)]);
var inst_14741 = (state_14766[(48)]);
var inst_14681 = (state_14766[(7)]);
var inst_14740 = inst_14638.call(null,inst_14681,inst_14628);
var inst_14741__$1 = (inst_14740 < (0));
var state_14766__$1 = (function (){var statearr_14877 = state_14766;
(statearr_14877[(48)] = inst_14741__$1);

return statearr_14877;
})();
if(cljs.core.truth_(inst_14741__$1)){
var statearr_14878_14991 = state_14766__$1;
(statearr_14878_14991[(1)] = (84));

} else {
var statearr_14879_14992 = state_14766__$1;
(statearr_14879_14992[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (79))){
var inst_14699 = (state_14766[(52)]);
var inst_14705 = (state_14766[(13)]);
var inst_14725 = cljs.core.disj.call(null,inst_14699,inst_14705);
var state_14766__$1 = state_14766;
var statearr_14880_14993 = state_14766__$1;
(statearr_14880_14993[(2)] = inst_14725);

(statearr_14880_14993[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (38))){
var state_14766__$1 = state_14766;
var statearr_14881_14994 = state_14766__$1;
(statearr_14881_14994[(2)] = (2147483647));

(statearr_14881_14994[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (87))){
var inst_14737 = (state_14766[(8)]);
var state_14766__$1 = state_14766;
var statearr_14882_14995 = state_14766__$1;
(statearr_14882_14995[(2)] = inst_14737);

(statearr_14882_14995[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (30))){
var inst_14604 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
if(cljs.core.truth_(inst_14604)){
var statearr_14883_14996 = state_14766__$1;
(statearr_14883_14996[(1)] = (31));

} else {
var statearr_14884_14997 = state_14766__$1;
(statearr_14884_14997[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (73))){
var inst_14733 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14885_14998 = state_14766__$1;
(statearr_14885_14998[(2)] = inst_14733);

(statearr_14885_14998[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (10))){
var inst_14549 = (state_14766[(58)]);
var inst_14566 = fluree.db.dbproto._subid.call(null,db,inst_14549);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(13),inst_14566);
} else {
if((state_val_14767 === (18))){
var inst_14551 = (state_14766[(59)]);
var inst_14584 = fluree.db.dbproto._subid.call(null,db,inst_14551);
var state_14766__$1 = state_14766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14766__$1,(21),inst_14584);
} else {
if((state_val_14767 === (52))){
var inst_14599 = (state_14766[(28)]);
var inst_14634 = (state_14766[(33)]);
var inst_14608 = (state_14766[(36)]);
var inst_14563 = (state_14766[(39)]);
var inst_14572 = (state_14766[(41)]);
var inst_14648 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_14634,inst_14563,inst_14572,inst_14599,inst_14608);
var state_14766__$1 = state_14766;
var statearr_14886_14999 = state_14766__$1;
(statearr_14886_14999[(2)] = inst_14648);

(statearr_14886_14999[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (67))){
var inst_14735 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14887_15000 = state_14766__$1;
(statearr_14887_15000[(2)] = inst_14735);

(statearr_14887_15000[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (71))){
var inst_14699 = (state_14766[(52)]);
var inst_14667 = (state_14766[(29)]);
var inst_14714 = cljs.core.into.call(null,inst_14699,inst_14667);
var state_14766__$1 = state_14766;
var statearr_14888_15001 = state_14766__$1;
(statearr_14888_15001[(2)] = inst_14714);

(statearr_14888_15001[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (42))){
var inst_14545 = (state_14766[(25)]);
var inst_14626 = (state_14766[(26)]);
var inst_14629 = (state_14766[(49)]);
var inst_14617 = (state_14766[(27)]);
var inst_14599 = (state_14766[(28)]);
var inst_14590 = (state_14766[(21)]);
var inst_14608 = (state_14766[(36)]);
var inst_14552 = (state_14766[(37)]);
var inst_14581 = (state_14766[(38)]);
var inst_14563 = (state_14766[(39)]);
var inst_14553 = (state_14766[(40)]);
var inst_14572 = (state_14766[(41)]);
var inst_14546 = (state_14766[(42)]);
var inst_14626__$1 = (state_14766[(2)]);
var inst_14627 = fluree.db.flake.__GT_Flake.call(null,inst_14563,inst_14599,inst_14581,inst_14545,inst_14546,inst_14617);
var inst_14628 = fluree.db.flake.__GT_Flake.call(null,inst_14572,inst_14608,inst_14590,inst_14552,inst_14553,inst_14626__$1);
var inst_14629__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14766__$1 = (function (){var statearr_14889 = state_14766;
(statearr_14889[(15)] = inst_14627);

(statearr_14889[(26)] = inst_14626__$1);

(statearr_14889[(49)] = inst_14629__$1);

(statearr_14889[(16)] = inst_14628);

return statearr_14889;
})();
if(cljs.core.truth_(inst_14629__$1)){
var statearr_14890_15002 = state_14766__$1;
(statearr_14890_15002[(1)] = (46));

} else {
var statearr_14891_15003 = state_14766__$1;
(statearr_14891_15003[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (80))){
var inst_14727 = (state_14766[(2)]);
var state_14766__$1 = state_14766;
var statearr_14892_15004 = state_14766__$1;
(statearr_14892_15004[(2)] = inst_14727);

(statearr_14892_15004[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (37))){
var state_14766__$1 = state_14766;
var statearr_14893_15005 = state_14766__$1;
(statearr_14893_15005[(2)] = fluree.db.util.core.min_integer);

(statearr_14893_15005[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (63))){
var inst_14667 = (state_14766[(29)]);
var inst_14633 = (state_14766[(31)]);
var inst_14666 = (state_14766[(32)]);
var inst_14680 = (state_14766[(12)]);
var inst_14683 = (inst_14633 - inst_14666);
var inst_14684 = fluree.db.flake.take.call(null,inst_14683,inst_14680);
var inst_14685 = cljs.core.into.call(null,inst_14684,inst_14667);
var state_14766__$1 = state_14766;
var statearr_14894_15006 = state_14766__$1;
(statearr_14894_15006[(2)] = inst_14685);

(statearr_14894_15006[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (8))){
var inst_14549 = (state_14766[(58)]);
var inst_14563 = (state_14766[(2)]);
var inst_14564 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14549);
var state_14766__$1 = (function (){var statearr_14895 = state_14766;
(statearr_14895[(39)] = inst_14563);

return statearr_14895;
})();
if(inst_14564){
var statearr_14896_15007 = state_14766__$1;
(statearr_14896_15007[(1)] = (10));

} else {
var statearr_14897_15008 = state_14766__$1;
(statearr_14897_15008[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (49))){
var inst_14639 = (state_14766[(51)]);
var state_14766__$1 = state_14766;
var statearr_14898_15009 = state_14766__$1;
(statearr_14898_15009[(2)] = inst_14639);

(statearr_14898_15009[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14767 === (84))){
var inst_14633 = (state_14766[(31)]);
var inst_14738 = (state_14766[(9)]);
var inst_14743 = (inst_14738 < inst_14633);
var state_14766__$1 = state_14766;
var statearr_14899_15010 = state_14766__$1;
(statearr_14899_15010[(2)] = inst_14743);

(statearr_14899_15010[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2703__auto__ = null;
var fluree$db$query$range$state_machine__2703__auto____0 = (function (){
var statearr_14900 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14900[(0)] = fluree$db$query$range$state_machine__2703__auto__);

(statearr_14900[(1)] = (1));

return statearr_14900;
});
var fluree$db$query$range$state_machine__2703__auto____1 = (function (state_14766){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_14766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e14901){var ex__2706__auto__ = e14901;
var statearr_14902_15011 = state_14766;
(statearr_14902_15011[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_14766[(4)]))){
var statearr_14903_15012 = state_14766;
(statearr_14903_15012[(1)] = cljs.core.first.call(null,(state_14766[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15013 = state_14766;
state_14766 = G__15013;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2703__auto__ = function(state_14766){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2703__auto____1.call(this,state_14766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2703__auto____0;
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2703__auto____1;
return fluree$db$query$range$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_14904 = f__2726__auto__.call(null);
(statearr_14904[(6)] = c__2725__auto__);

return statearr_14904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_15088){
var state_val_15089 = (state_15088[(1)]);
if((state_val_15089 === (7))){
var inst_15083 = (state_15088[(2)]);
var _ = (function (){var statearr_15090 = state_15088;
(statearr_15090[(4)] = cljs.core.rest.call(null,(state_15088[(4)])));

return statearr_15090;
})();
var state_15088__$1 = state_15088;
var statearr_15091_15131 = state_15088__$1;
(statearr_15091_15131[(2)] = inst_15083);

(statearr_15091_15131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (20))){
var inst_15065 = (state_15088[(2)]);
var inst_15066 = fluree.db.util.async.throw_err.call(null,inst_15065);
var state_15088__$1 = state_15088;
var statearr_15092_15132 = state_15088__$1;
(statearr_15092_15132[(2)] = inst_15066);

(statearr_15092_15132[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (1))){
var state_15088__$1 = state_15088;
var statearr_15093_15133 = state_15088__$1;
(statearr_15093_15133[(2)] = null);

(statearr_15093_15133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (4))){
var inst_15014 = (state_15088[(2)]);
var state_15088__$1 = state_15088;
var statearr_15094_15134 = state_15088__$1;
(statearr_15094_15134[(2)] = inst_15014);

(statearr_15094_15134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (15))){
var inst_15061 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15088__$1 = state_15088;
if(cljs.core.truth_(inst_15061)){
var statearr_15095_15135 = state_15088__$1;
(statearr_15095_15135[(1)] = (17));

} else {
var statearr_15096_15136 = state_15088__$1;
(statearr_15096_15136[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (21))){
var state_15088__$1 = state_15088;
var statearr_15097_15137 = state_15088__$1;
(statearr_15097_15137[(2)] = (0));

(statearr_15097_15137[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (13))){
var inst_15053 = (state_15088[(2)]);
var state_15088__$1 = state_15088;
var statearr_15098_15138 = state_15088__$1;
(statearr_15098_15138[(2)] = inst_15053);

(statearr_15098_15138[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (22))){
var state_15088__$1 = state_15088;
var statearr_15099_15139 = state_15088__$1;
(statearr_15099_15139[(2)] = (1));

(statearr_15099_15139[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (6))){
var inst_15045 = (state_15088[(7)]);
var inst_15034 = (state_15088[(8)]);
var inst_15043 = (state_15088[(9)]);
var inst_15042 = cljs.core.seq.call(null,inst_15034);
var inst_15043__$1 = cljs.core.first.call(null,inst_15042);
var inst_15044 = cljs.core.next.call(null,inst_15042);
var inst_15045__$1 = (inst_15043__$1 == null);
var state_15088__$1 = (function (){var statearr_15100 = state_15088;
(statearr_15100[(7)] = inst_15045__$1);

(statearr_15100[(10)] = inst_15044);

(statearr_15100[(9)] = inst_15043__$1);

return statearr_15100;
})();
if(cljs.core.truth_(inst_15045__$1)){
var statearr_15101_15140 = state_15088__$1;
(statearr_15101_15140[(1)] = (8));

} else {
var statearr_15102_15141 = state_15088__$1;
(statearr_15102_15141[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (17))){
var inst_15043 = (state_15088[(9)]);
var inst_15063 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_15043);
var state_15088__$1 = state_15088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15088__$1,(20),inst_15063);
} else {
if((state_val_15089 === (3))){
var inst_15086 = (state_15088[(2)]);
var state_15088__$1 = state_15088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15088__$1,inst_15086);
} else {
if((state_val_15089 === (12))){
var inst_15036 = (state_15088[(11)]);
var inst_15051 = (inst_15036 >= subject_limit);
var state_15088__$1 = state_15088;
var statearr_15103_15142 = state_15088__$1;
(statearr_15103_15142[(2)] = inst_15051);

(statearr_15103_15142[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (2))){
var _ = (function (){var statearr_15104 = state_15088;
(statearr_15104[(4)] = cljs.core.cons.call(null,(5),(state_15088[(4)])));

return statearr_15104;
})();
var inst_15027 = subject_groups;
var inst_15028 = cljs.core.seq.call(null,inst_15027);
var inst_15029 = cljs.core.first.call(null,inst_15028);
var inst_15030 = cljs.core.next.call(null,inst_15028);
var inst_15031 = flake_start;
var inst_15032 = subject_start;
var inst_15033 = cljs.core.PersistentVector.EMPTY;
var inst_15034 = inst_15027;
var inst_15035 = inst_15031;
var inst_15036 = inst_15032;
var inst_15037 = inst_15033;
var state_15088__$1 = (function (){var statearr_15105 = state_15088;
(statearr_15105[(12)] = inst_15030);

(statearr_15105[(13)] = inst_15029);

(statearr_15105[(14)] = inst_15037);

(statearr_15105[(11)] = inst_15036);

(statearr_15105[(15)] = inst_15035);

(statearr_15105[(8)] = inst_15034);

return statearr_15105;
})();
var statearr_15106_15143 = state_15088__$1;
(statearr_15106_15143[(2)] = null);

(statearr_15106_15143[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (23))){
var inst_15069 = (state_15088[(16)]);
var inst_15037 = (state_15088[(14)]);
var inst_15036 = (state_15088[(11)]);
var inst_15035 = (state_15088[(15)]);
var inst_15070 = (state_15088[(17)]);
var inst_15044 = (state_15088[(10)]);
var inst_15075 = (state_15088[(2)]);
var inst_15076 = (inst_15035 + inst_15070);
var inst_15077 = (inst_15036 + inst_15075);
var inst_15078 = cljs.core.into.call(null,inst_15037,inst_15069);
var inst_15034 = inst_15044;
var inst_15035__$1 = inst_15076;
var inst_15036__$1 = inst_15077;
var inst_15037__$1 = inst_15078;
var state_15088__$1 = (function (){var statearr_15107 = state_15088;
(statearr_15107[(14)] = inst_15037__$1);

(statearr_15107[(11)] = inst_15036__$1);

(statearr_15107[(15)] = inst_15035__$1);

(statearr_15107[(8)] = inst_15034);

return statearr_15107;
})();
var statearr_15108_15144 = state_15088__$1;
(statearr_15108_15144[(2)] = null);

(statearr_15108_15144[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (19))){
var inst_15069 = (state_15088[(16)]);
var inst_15070 = (state_15088[(17)]);
var inst_15069__$1 = (state_15088[(2)]);
var inst_15070__$1 = cljs.core.count.call(null,inst_15069__$1);
var inst_15071 = cljs.core._EQ_.call(null,(0),inst_15070__$1);
var state_15088__$1 = (function (){var statearr_15109 = state_15088;
(statearr_15109[(16)] = inst_15069__$1);

(statearr_15109[(17)] = inst_15070__$1);

return statearr_15109;
})();
if(inst_15071){
var statearr_15110_15145 = state_15088__$1;
(statearr_15110_15145[(1)] = (21));

} else {
var statearr_15111_15146 = state_15088__$1;
(statearr_15111_15146[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (11))){
var inst_15048 = (state_15088[(18)]);
var state_15088__$1 = state_15088;
var statearr_15113_15147 = state_15088__$1;
(statearr_15113_15147[(2)] = inst_15048);

(statearr_15113_15147[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (9))){
var inst_15048 = (state_15088[(18)]);
var inst_15035 = (state_15088[(15)]);
var inst_15048__$1 = (inst_15035 >= flake_limit);
var state_15088__$1 = (function (){var statearr_15114 = state_15088;
(statearr_15114[(18)] = inst_15048__$1);

return statearr_15114;
})();
if(cljs.core.truth_(inst_15048__$1)){
var statearr_15115_15148 = state_15088__$1;
(statearr_15115_15148[(1)] = (11));

} else {
var statearr_15116_15149 = state_15088__$1;
(statearr_15116_15149[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (5))){
var _ = (function (){var statearr_15117 = state_15088;
(statearr_15117[(4)] = cljs.core.rest.call(null,(state_15088[(4)])));

return statearr_15117;
})();
var state_15088__$1 = state_15088;
var ex15112 = (state_15088__$1[(2)]);
var statearr_15118_15150 = state_15088__$1;
(statearr_15118_15150[(5)] = ex15112);


if((ex15112 instanceof Error)){
var statearr_15119_15151 = state_15088__$1;
(statearr_15119_15151[(1)] = (4));

(statearr_15119_15151[(5)] = null);

} else {
throw ex15112;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (14))){
var inst_15037 = (state_15088[(14)]);
var inst_15036 = (state_15088[(11)]);
var inst_15035 = (state_15088[(15)]);
var inst_15057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15058 = [inst_15035,inst_15036,inst_15037];
var inst_15059 = (new cljs.core.PersistentVector(null,3,(5),inst_15057,inst_15058,null));
var state_15088__$1 = state_15088;
var statearr_15120_15152 = state_15088__$1;
(statearr_15120_15152[(2)] = inst_15059);

(statearr_15120_15152[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (16))){
var inst_15081 = (state_15088[(2)]);
var state_15088__$1 = state_15088;
var statearr_15121_15153 = state_15088__$1;
(statearr_15121_15153[(2)] = inst_15081);

(statearr_15121_15153[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (10))){
var inst_15055 = (state_15088[(2)]);
var state_15088__$1 = state_15088;
if(cljs.core.truth_(inst_15055)){
var statearr_15122_15154 = state_15088__$1;
(statearr_15122_15154[(1)] = (14));

} else {
var statearr_15123_15155 = state_15088__$1;
(statearr_15123_15155[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (18))){
var inst_15043 = (state_15088[(9)]);
var state_15088__$1 = state_15088;
var statearr_15124_15156 = state_15088__$1;
(statearr_15124_15156[(2)] = inst_15043);

(statearr_15124_15156[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15089 === (8))){
var inst_15045 = (state_15088[(7)]);
var state_15088__$1 = state_15088;
var statearr_15125_15157 = state_15088__$1;
(statearr_15125_15157[(2)] = inst_15045);

(statearr_15125_15157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto____0 = (function (){
var statearr_15126 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15126[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto__);

(statearr_15126[(1)] = (1));

return statearr_15126;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto____1 = (function (state_15088){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_15088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e15127){var ex__2706__auto__ = e15127;
var statearr_15128_15158 = state_15088;
(statearr_15128_15158[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_15088[(4)]))){
var statearr_15129_15159 = state_15088;
(statearr_15129_15159[(1)] = cljs.core.first.call(null,(state_15088[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15160 = state_15088;
state_15088 = G__15160;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto__ = function(state_15088){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto____1.call(this,state_15088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_15130 = f__2726__auto__.call(null);
(statearr_15130[(6)] = c__2725__auto__);

return statearr_15130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_15206){
var state_val_15207 = (state_15206[(1)]);
if((state_val_15207 === (7))){
var state_15206__$1 = state_15206;
var statearr_15208_15246 = state_15206__$1;
(statearr_15208_15246[(2)] = null);

(statearr_15208_15246[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (20))){
var inst_15192 = (state_15206[(2)]);
var inst_15193 = fluree.db.util.async.throw_err.call(null,inst_15192);
var inst_15171 = inst_15193;
var state_15206__$1 = (function (){var statearr_15209 = state_15206;
(statearr_15209[(7)] = inst_15171);

return statearr_15209;
})();
var statearr_15210_15247 = state_15206__$1;
(statearr_15210_15247[(2)] = null);

(statearr_15210_15247[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (1))){
var state_15206__$1 = state_15206;
var statearr_15211_15248 = state_15206__$1;
(statearr_15211_15248[(2)] = null);

(statearr_15211_15248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (4))){
var inst_15161 = (state_15206[(2)]);
var state_15206__$1 = state_15206;
var statearr_15212_15249 = state_15206__$1;
(statearr_15212_15249[(2)] = inst_15161);

(statearr_15212_15249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (15))){
var inst_15171 = (state_15206[(7)]);
var inst_15188 = (state_15206[(8)]);
var inst_15188__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_15171);
var state_15206__$1 = (function (){var statearr_15213 = state_15206;
(statearr_15213[(8)] = inst_15188__$1);

return statearr_15213;
})();
if(cljs.core.truth_(inst_15188__$1)){
var statearr_15214_15250 = state_15206__$1;
(statearr_15214_15250[(1)] = (17));

} else {
var statearr_15215_15251 = state_15206__$1;
(statearr_15215_15251[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (13))){
var inst_15181 = (state_15206[(2)]);
var inst_15182 = fluree.db.util.async.throw_err.call(null,inst_15181);
var _ = (function (){var statearr_15216 = state_15206;
(statearr_15216[(4)] = cljs.core.rest.call(null,(state_15206[(4)])));

return statearr_15216;
})();
var state_15206__$1 = state_15206;
var statearr_15217_15252 = state_15206__$1;
(statearr_15217_15252[(2)] = inst_15182);

(statearr_15217_15252[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (6))){
var inst_15169 = (state_15206[(2)]);
var inst_15170 = fluree.db.util.async.throw_err.call(null,inst_15169);
var inst_15171 = inst_15170;
var state_15206__$1 = (function (){var statearr_15218 = state_15206;
(statearr_15218[(7)] = inst_15171);

return statearr_15218;
})();
var statearr_15219_15253 = state_15206__$1;
(statearr_15219_15253[(2)] = null);

(statearr_15219_15253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (17))){
var inst_15188 = (state_15206[(8)]);
var inst_15190 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_15188);
var state_15206__$1 = state_15206;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15206__$1,(20),inst_15190);
} else {
if((state_val_15207 === (3))){
var inst_15204 = (state_15206[(2)]);
var state_15206__$1 = state_15206;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15206__$1,inst_15204);
} else {
if((state_val_15207 === (12))){
var _ = (function (){var statearr_15221 = state_15206;
(statearr_15221[(4)] = cljs.core.rest.call(null,(state_15206[(4)])));

return statearr_15221;
})();
var state_15206__$1 = state_15206;
var ex15220 = (state_15206__$1[(2)]);
var statearr_15222_15254 = state_15206__$1;
(statearr_15222_15254[(5)] = ex15220);


var statearr_15223_15255 = state_15206__$1;
(statearr_15223_15255[(1)] = (11));

(statearr_15223_15255[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (2))){
var _ = (function (){var statearr_15224 = state_15206;
(statearr_15224[(4)] = cljs.core.cons.call(null,(5),(state_15206[(4)])));

return statearr_15224;
})();
var inst_15167 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_15206__$1 = state_15206;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15206__$1,(6),inst_15167);
} else {
if((state_val_15207 === (19))){
var inst_15197 = (state_15206[(2)]);
var state_15206__$1 = state_15206;
var statearr_15225_15256 = state_15206__$1;
(statearr_15225_15256[(2)] = inst_15197);

(statearr_15225_15256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (11))){
var inst_15173 = (state_15206[(2)]);
var state_15206__$1 = (function (){var statearr_15227 = state_15206;
(statearr_15227[(9)] = inst_15173);

return statearr_15227;
})();
var statearr_15228_15257 = state_15206__$1;
(statearr_15228_15257[(2)] = null);

(statearr_15228_15257[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (9))){
var inst_15171 = (state_15206[(7)]);
var _ = (function (){var statearr_15229 = state_15206;
(statearr_15229[(4)] = cljs.core.cons.call(null,(12),(state_15206[(4)])));

return statearr_15229;
})();
var inst_15179 = fluree.db.dbproto._resolve_to_t.call(null,inst_15171,t,novelty,fast_forward_db_QMARK_);
var state_15206__$1 = state_15206;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15206__$1,(13),inst_15179);
} else {
if((state_val_15207 === (5))){
var _ = (function (){var statearr_15230 = state_15206;
(statearr_15230[(4)] = cljs.core.rest.call(null,(state_15206[(4)])));

return statearr_15230;
})();
var state_15206__$1 = state_15206;
var ex15226 = (state_15206__$1[(2)]);
var statearr_15231_15258 = state_15206__$1;
(statearr_15231_15258[(5)] = ex15226);


if((ex15226 instanceof Error)){
var statearr_15232_15259 = state_15206__$1;
(statearr_15232_15259[(1)] = (4));

(statearr_15232_15259[(5)] = null);

} else {
throw ex15226;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (14))){
var inst_15185 = (state_15206[(10)]);
var state_15206__$1 = state_15206;
var statearr_15233_15260 = state_15206__$1;
(statearr_15233_15260[(2)] = inst_15185);

(statearr_15233_15260[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (16))){
var inst_15199 = (state_15206[(2)]);
var state_15206__$1 = state_15206;
var statearr_15234_15261 = state_15206__$1;
(statearr_15234_15261[(2)] = inst_15199);

(statearr_15234_15261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (10))){
var inst_15185 = (state_15206[(10)]);
var inst_15185__$1 = (state_15206[(2)]);
var state_15206__$1 = (function (){var statearr_15235 = state_15206;
(statearr_15235[(10)] = inst_15185__$1);

return statearr_15235;
})();
if(cljs.core.truth_(inst_15185__$1)){
var statearr_15236_15262 = state_15206__$1;
(statearr_15236_15262[(1)] = (14));

} else {
var statearr_15237_15263 = state_15206__$1;
(statearr_15237_15263[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (18))){
var state_15206__$1 = state_15206;
var statearr_15238_15264 = state_15206__$1;
(statearr_15238_15264[(2)] = null);

(statearr_15238_15264[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15207 === (8))){
var inst_15201 = (state_15206[(2)]);
var _ = (function (){var statearr_15239 = state_15206;
(statearr_15239[(4)] = cljs.core.rest.call(null,(state_15206[(4)])));

return statearr_15239;
})();
var state_15206__$1 = state_15206;
var statearr_15240_15265 = state_15206__$1;
(statearr_15240_15265[(2)] = inst_15201);

(statearr_15240_15265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto____0 = (function (){
var statearr_15241 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15241[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto__);

(statearr_15241[(1)] = (1));

return statearr_15241;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto____1 = (function (state_15206){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_15206);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e15242){var ex__2706__auto__ = e15242;
var statearr_15243_15266 = state_15206;
(statearr_15243_15266[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_15206[(4)]))){
var statearr_15244_15267 = state_15206;
(statearr_15244_15267[(1)] = cljs.core.first.call(null,(state_15206[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15268 = state_15206;
state_15206 = G__15268;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto__ = function(state_15206){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto____1.call(this,state_15206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_15245 = f__2726__auto__.call(null);
(statearr_15245[(6)] = c__2725__auto__);

return statearr_15245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15275 = arguments.length;
switch (G__15275) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15276 = (function (){var pred__15279 = cljs.core.identical_QMARK_;
var expr__15280 = test;
if(cljs.core.truth_(pred__15279.call(null,cljs.core._EQ_,expr__15280))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15279.call(null,cljs.core._LT_,expr__15280))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__15279.call(null,cljs.core._LT__EQ_,expr__15280))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15279.call(null,cljs.core._GT_,expr__15280))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__15279.call(null,cljs.core._GT__EQ_,expr__15280))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15280)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__15276,(0),null);
var start_match = cljs.core.nth.call(null,vec__15276,(1),null);
var end_test = cljs.core.nth.call(null,vec__15276,(2),null);
var end_match = cljs.core.nth.call(null,vec__15276,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_15652){
var state_val_15653 = (state_15652[(1)]);
if((state_val_15653 === (121))){
var inst_15608 = (state_15652[(7)]);
var state_15652__$1 = state_15652;
var statearr_15654_15847 = state_15652__$1;
(statearr_15654_15847[(2)] = inst_15608);

(statearr_15654_15847[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (65))){
var inst_15460 = (state_15652[(8)]);
var inst_15466 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15655 = state_15652;
(statearr_15655[(9)] = inst_15466);

return statearr_15655;
})();
if(cljs.core.truth_(inst_15460)){
var statearr_15656_15848 = state_15652__$1;
(statearr_15656_15848[(1)] = (66));

} else {
var statearr_15657_15849 = state_15652__$1;
(statearr_15657_15849[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (70))){
var inst_15644 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15658_15850 = state_15652__$1;
(statearr_15658_15850[(2)] = inst_15644);

(statearr_15658_15850[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (62))){
var inst_15459 = (state_15652[(2)]);
var inst_15460 = fluree.db.util.async.throw_err.call(null,inst_15459);
var inst_15461 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15652__$1 = (function (){var statearr_15659 = state_15652;
(statearr_15659[(8)] = inst_15460);

return statearr_15659;
})();
if(cljs.core.truth_(inst_15461)){
var statearr_15660_15851 = state_15652__$1;
(statearr_15660_15851[(1)] = (63));

} else {
var statearr_15661_15852 = state_15652__$1;
(statearr_15661_15852[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (74))){
var inst_15439 = (state_15652[(10)]);
var inst_15470 = (state_15652[(11)]);
var inst_15466 = (state_15652[(9)]);
var inst_15451 = (state_15652[(12)]);
var inst_15473 = (state_15652[(13)]);
var inst_15302 = (state_15652[(14)]);
var inst_15307 = (state_15652[(15)]);
var inst_15429 = (state_15652[(16)]);
var inst_15371 = (state_15652[(17)]);
var inst_15401 = (state_15652[(18)]);
var inst_15446 = (state_15652[(19)]);
var inst_15309 = (state_15652[(20)]);
var inst_15319 = (state_15652[(21)]);
var inst_15392 = (state_15652[(22)]);
var inst_15318 = (state_15652[(23)]);
var inst_15317 = (state_15652[(24)]);
var inst_15383 = (state_15652[(25)]);
var inst_15419 = (state_15652[(26)]);
var inst_15338 = (state_15652[(27)]);
var inst_15460 = (state_15652[(8)]);
var inst_15479 = (state_15652[(28)]);
var inst_15313 = (state_15652[(29)]);
var inst_15430 = (state_15652[(30)]);
var inst_15314 = (state_15652[(31)]);
var inst_15471 = (state_15652[(32)]);
var inst_15445 = (state_15652[(33)]);
var inst_15432 = (state_15652[(34)]);
var inst_15441 = (state_15652[(35)]);
var inst_15450 = (state_15652[(36)]);
var inst_15370 = (state_15652[(37)]);
var inst_15306 = (state_15652[(38)]);
var inst_15440 = (state_15652[(39)]);
var inst_15469 = (state_15652[(40)]);
var inst_15472 = (state_15652[(41)]);
var inst_15329 = (state_15652[(42)]);
var inst_15456 = (state_15652[(43)]);
var inst_15410 = (state_15652[(44)]);
var inst_15428 = (state_15652[(45)]);
var inst_15487 = (state_15652[(46)]);
var inst_15433 = (state_15652[(47)]);
var inst_15374 = (state_15652[(48)]);
var inst_15489 = (function (){var no_filter_QMARK_ = inst_15466;
var t = inst_15446;
var max_limit_QMARK_ = inst_15440;
var next_node = inst_15469;
var fast_forward_db_QMARK_ = inst_15451;
var s1 = inst_15329;
var o2 = inst_15392;
var t1 = inst_15306;
var predicate_fn = inst_15319;
var i = inst_15471;
var m1 = inst_15419;
var root_node = inst_15456;
var s2 = inst_15338;
var vec__15295 = inst_15370;
var p2 = inst_15410;
var map__15294 = inst_15317;
var permissions = inst_15441;
var vec__15288 = inst_15302;
var limit = inst_15439;
var start_flake = inst_15429;
var flake_limit = inst_15433;
var offset = inst_15470;
var acc = inst_15473;
var vec__15291 = inst_15309;
var t2 = inst_15313;
var op1 = inst_15307;
var o1 = inst_15383;
var end_flake = inst_15430;
var base_result = inst_15479;
var s = inst_15472;
var node_start = inst_15460;
var p1 = inst_15401;
var subject_fn = inst_15318;
var G__15480 = inst_15487;
var vec__15298 = inst_15371;
var object_fn = inst_15374;
var idx_compare = inst_15445;
var op2 = inst_15314;
var m2 = inst_15428;
var map__15301 = inst_15432;
var novelty = inst_15450;
return (function (p1__15270_SHARP_){
return subject_fn.call(null,p1__15270_SHARP_.s);
});
})();
var inst_15490 = cljs.core.filter.call(null,inst_15489,inst_15487);
var state_15652__$1 = state_15652;
var statearr_15662_15853 = state_15652__$1;
(statearr_15662_15853[(2)] = inst_15490);

(statearr_15662_15853[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (110))){
var inst_15621 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15663_15854 = state_15652__$1;
(statearr_15663_15854[(2)] = inst_15621);

(statearr_15663_15854[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (7))){
var inst_15303 = (state_15652[(49)]);
var state_15652__$1 = state_15652;
var statearr_15664_15855 = state_15652__$1;
(statearr_15664_15855[(2)] = inst_15303);

(statearr_15664_15855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (59))){
var state_15652__$1 = state_15652;
var statearr_15665_15856 = state_15652__$1;
(statearr_15665_15856[(2)] = fluree.db.util.core.max_long);

(statearr_15665_15856[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (86))){
var inst_15466 = (state_15652[(9)]);
var state_15652__$1 = state_15652;
var statearr_15666_15857 = state_15652__$1;
(statearr_15666_15857[(2)] = inst_15466);

(statearr_15666_15857[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (20))){
var state_15652__$1 = state_15652;
var statearr_15667_15858 = state_15652__$1;
(statearr_15667_15858[(2)] = null);

(statearr_15667_15858[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (72))){
var inst_15479 = (state_15652[(28)]);
var state_15652__$1 = state_15652;
var statearr_15668_15859 = state_15652__$1;
(statearr_15668_15859[(2)] = inst_15479);

(statearr_15668_15859[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (58))){
var inst_15434 = (state_15652[(50)]);
var state_15652__$1 = state_15652;
var statearr_15669_15860 = state_15652__$1;
(statearr_15669_15860[(2)] = inst_15434);

(statearr_15669_15860[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (60))){
var inst_15439 = (state_15652[(10)]);
var inst_15439__$1 = (state_15652[(2)]);
var inst_15440 = cljs.core._EQ_.call(null,inst_15439__$1,fluree.db.util.core.max_long);
var inst_15441 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_15442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15443 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_15444 = (new cljs.core.PersistentVector(null,3,(5),inst_15442,inst_15443,null));
var inst_15445 = cljs.core.get_in.call(null,db,inst_15444);
var inst_15446 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_15447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15448 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_15449 = (new cljs.core.PersistentVector(null,2,(5),inst_15447,inst_15448,null));
var inst_15450 = cljs.core.get_in.call(null,db,inst_15449);
var inst_15451 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_15452 = cljs.core.get.call(null,db,idx);
var inst_15453 = fluree.db.dbproto._resolve.call(null,inst_15452);
var state_15652__$1 = (function (){var statearr_15670 = state_15652;
(statearr_15670[(10)] = inst_15439__$1);

(statearr_15670[(12)] = inst_15451);

(statearr_15670[(19)] = inst_15446);

(statearr_15670[(33)] = inst_15445);

(statearr_15670[(35)] = inst_15441);

(statearr_15670[(36)] = inst_15450);

(statearr_15670[(39)] = inst_15440);

return statearr_15670;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(61),inst_15453);
} else {
if((state_val_15653 === (27))){
var inst_15372 = (state_15652[(51)]);
var state_15652__$1 = state_15652;
var statearr_15671_15861 = state_15652__$1;
(statearr_15671_15861[(2)] = inst_15372);

(statearr_15671_15861[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (1))){
var state_15652__$1 = state_15652;
var statearr_15672_15862 = state_15652__$1;
(statearr_15672_15862[(2)] = null);

(statearr_15672_15862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (69))){
var inst_15429 = (state_15652[(16)]);
var inst_15430 = (state_15652[(30)]);
var inst_15469 = (state_15652[(40)]);
var inst_15478 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_15469);
var inst_15479 = fluree.db.flake.subrange.call(null,inst_15478,start_test,inst_15429,end_test,inst_15430);
var inst_15481 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_15429,inst_15430);
var state_15652__$1 = (function (){var statearr_15673 = state_15652;
(statearr_15673[(28)] = inst_15479);

return statearr_15673;
})();
if(inst_15481){
var statearr_15674_15863 = state_15652__$1;
(statearr_15674_15863[(1)] = (71));

} else {
var statearr_15675_15864 = state_15652__$1;
(statearr_15675_15864[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (101))){
var inst_15567 = (state_15652[(52)]);
var inst_15565 = (state_15652[(53)]);
var inst_15566 = (state_15652[(54)]);
var inst_15433 = (state_15652[(47)]);
var inst_15570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15571 = (inst_15567 - inst_15433);
var inst_15572 = (inst_15566 - inst_15571);
var inst_15573 = cljs.core.take.call(null,inst_15572,inst_15565);
var inst_15574 = [inst_15433,inst_15573];
var inst_15575 = (new cljs.core.PersistentVector(null,2,(5),inst_15570,inst_15574,null));
var state_15652__$1 = state_15652;
var statearr_15676_15865 = state_15652__$1;
(statearr_15676_15865[(2)] = inst_15575);

(statearr_15676_15865[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (24))){
var inst_15304 = (state_15652[(55)]);
var inst_15302 = (state_15652[(14)]);
var inst_15307 = (state_15652[(15)]);
var inst_15312 = (state_15652[(56)]);
var inst_15315 = (state_15652[(57)]);
var inst_15308 = (state_15652[(58)]);
var inst_15309 = (state_15652[(20)]);
var inst_15311 = (state_15652[(59)]);
var inst_15319 = (state_15652[(21)]);
var inst_15318 = (state_15652[(23)]);
var inst_15317 = (state_15652[(24)]);
var inst_15338 = (state_15652[(27)]);
var inst_15320 = (state_15652[(60)]);
var inst_15313 = (state_15652[(29)]);
var inst_15314 = (state_15652[(31)]);
var inst_15305 = (state_15652[(61)]);
var inst_15306 = (state_15652[(38)]);
var inst_15329 = (state_15652[(42)]);
var inst_15352 = (state_15652[(62)]);
var inst_15362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15364 = [null,null];
var inst_15365 = (new cljs.core.PersistentVector(null,2,(5),inst_15363,inst_15364,null));
var inst_15366 = (function (){var bool = inst_15352;
var s1 = inst_15329;
var o2 = inst_15312;
var t1 = inst_15306;
var predicate_fn = inst_15319;
var m1 = inst_15308;
var s2 = inst_15338;
var p2 = inst_15311;
var map__15294 = inst_15317;
var vec__15288 = inst_15302;
var vec__15291 = inst_15309;
var t2 = inst_15313;
var op1 = inst_15307;
var o1 = inst_15305;
var p1 = inst_15304;
var subject_fn = inst_15318;
var temp__5806__auto__ = inst_15352;
var object_fn = inst_15320;
var op2 = inst_15314;
var m2 = inst_15315;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_15367 = [inst_15365,inst_15366];
var inst_15368 = (new cljs.core.PersistentVector(null,2,(5),inst_15362,inst_15367,null));
var state_15652__$1 = state_15652;
var statearr_15677_15866 = state_15652__$1;
(statearr_15677_15866[(2)] = inst_15368);

(statearr_15677_15866[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (102))){
var inst_15567 = (state_15652[(52)]);
var inst_15565 = (state_15652[(53)]);
var inst_15577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15578 = [inst_15567,inst_15565];
var inst_15579 = (new cljs.core.PersistentVector(null,2,(5),inst_15577,inst_15578,null));
var state_15652__$1 = state_15652;
var statearr_15678_15867 = state_15652__$1;
(statearr_15678_15867[(2)] = inst_15579);

(statearr_15678_15867[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (55))){
var state_15652__$1 = state_15652;
var statearr_15679_15868 = state_15652__$1;
(statearr_15679_15868[(2)] = (2147483647));

(statearr_15679_15868[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (85))){
var inst_15515 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
if(cljs.core.truth_(inst_15515)){
var statearr_15680_15869 = state_15652__$1;
(statearr_15680_15869[(1)] = (89));

} else {
var statearr_15681_15870 = state_15652__$1;
(statearr_15681_15870[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (39))){
var inst_15311 = (state_15652[(59)]);
var inst_15402 = (state_15652[(63)]);
var inst_15401 = (state_15652[(2)]);
var inst_15402__$1 = (inst_15311 == null);
var state_15652__$1 = (function (){var statearr_15682 = state_15652;
(statearr_15682[(18)] = inst_15401);

(statearr_15682[(63)] = inst_15402__$1);

return statearr_15682;
})();
if(cljs.core.truth_(inst_15402__$1)){
var statearr_15683_15871 = state_15652__$1;
(statearr_15683_15871[(1)] = (40));

} else {
var statearr_15684_15872 = state_15652__$1;
(statearr_15684_15872[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (88))){
var inst_15512 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15685_15873 = state_15652__$1;
(statearr_15685_15873[(2)] = inst_15512);

(statearr_15685_15873[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (46))){
var inst_15308 = (state_15652[(58)]);
var state_15652__$1 = state_15652;
var statearr_15686_15874 = state_15652__$1;
(statearr_15686_15874[(2)] = inst_15308);

(statearr_15686_15874[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (4))){
var inst_15282 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15687_15875 = state_15652__$1;
(statearr_15687_15875[(2)] = inst_15282);

(statearr_15687_15875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (77))){
var inst_15439 = (state_15652[(10)]);
var inst_15470 = (state_15652[(11)]);
var inst_15466 = (state_15652[(9)]);
var inst_15451 = (state_15652[(12)]);
var inst_15473 = (state_15652[(13)]);
var inst_15302 = (state_15652[(14)]);
var inst_15307 = (state_15652[(15)]);
var inst_15429 = (state_15652[(16)]);
var inst_15371 = (state_15652[(17)]);
var inst_15401 = (state_15652[(18)]);
var inst_15446 = (state_15652[(19)]);
var inst_15309 = (state_15652[(20)]);
var inst_15319 = (state_15652[(21)]);
var inst_15392 = (state_15652[(22)]);
var inst_15318 = (state_15652[(23)]);
var inst_15317 = (state_15652[(24)]);
var inst_15383 = (state_15652[(25)]);
var inst_15419 = (state_15652[(26)]);
var inst_15338 = (state_15652[(27)]);
var inst_15460 = (state_15652[(8)]);
var inst_15493 = (state_15652[(64)]);
var inst_15479 = (state_15652[(28)]);
var inst_15313 = (state_15652[(29)]);
var inst_15430 = (state_15652[(30)]);
var inst_15314 = (state_15652[(31)]);
var inst_15471 = (state_15652[(32)]);
var inst_15445 = (state_15652[(33)]);
var inst_15432 = (state_15652[(34)]);
var inst_15441 = (state_15652[(35)]);
var inst_15450 = (state_15652[(36)]);
var inst_15370 = (state_15652[(37)]);
var inst_15306 = (state_15652[(38)]);
var inst_15440 = (state_15652[(39)]);
var inst_15469 = (state_15652[(40)]);
var inst_15472 = (state_15652[(41)]);
var inst_15329 = (state_15652[(42)]);
var inst_15456 = (state_15652[(43)]);
var inst_15410 = (state_15652[(44)]);
var inst_15428 = (state_15652[(45)]);
var inst_15433 = (state_15652[(47)]);
var inst_15374 = (state_15652[(48)]);
var inst_15495 = (function (){var no_filter_QMARK_ = inst_15466;
var t = inst_15446;
var max_limit_QMARK_ = inst_15440;
var next_node = inst_15469;
var fast_forward_db_QMARK_ = inst_15451;
var s1 = inst_15329;
var o2 = inst_15392;
var t1 = inst_15306;
var predicate_fn = inst_15319;
var i = inst_15471;
var m1 = inst_15419;
var root_node = inst_15456;
var s2 = inst_15338;
var vec__15295 = inst_15370;
var p2 = inst_15410;
var map__15294 = inst_15317;
var permissions = inst_15441;
var vec__15288 = inst_15302;
var limit = inst_15439;
var start_flake = inst_15429;
var flake_limit = inst_15433;
var offset = inst_15470;
var acc = inst_15473;
var vec__15291 = inst_15309;
var t2 = inst_15313;
var op1 = inst_15307;
var o1 = inst_15383;
var end_flake = inst_15430;
var base_result = inst_15479;
var s = inst_15472;
var node_start = inst_15460;
var p1 = inst_15401;
var subject_fn = inst_15318;
var G__15480 = inst_15493;
var vec__15298 = inst_15371;
var object_fn = inst_15374;
var idx_compare = inst_15445;
var op2 = inst_15314;
var m2 = inst_15428;
var map__15301 = inst_15432;
var novelty = inst_15450;
return (function (p1__15271_SHARP_){
return predicate_fn.call(null,p1__15271_SHARP_.p);
});
})();
var inst_15496 = cljs.core.filter.call(null,inst_15495,inst_15493);
var state_15652__$1 = state_15652;
var statearr_15688_15876 = state_15652__$1;
(statearr_15688_15876[(2)] = inst_15496);

(statearr_15688_15876[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (106))){
var inst_15506 = (state_15652[(65)]);
var state_15652__$1 = state_15652;
var statearr_15689_15877 = state_15652__$1;
(statearr_15689_15877[(2)] = inst_15506);

(statearr_15689_15877[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (119))){
var inst_15624 = (state_15652[(66)]);
var state_15652__$1 = state_15652;
var statearr_15690_15878 = state_15652__$1;
(statearr_15690_15878[(2)] = inst_15624);

(statearr_15690_15878[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (95))){
var inst_15439 = (state_15652[(10)]);
var inst_15548 = (state_15652[(67)]);
var inst_15549 = (state_15652[(68)]);
var inst_15472 = (state_15652[(41)]);
var inst_15547 = (state_15652[(69)]);
var inst_15539 = (state_15652[(70)]);
var inst_15547__$1 = cljs.core.count.call(null,inst_15539);
var inst_15548__$1 = (inst_15472 + inst_15547__$1);
var inst_15549__$1 = (inst_15548__$1 - inst_15439);
var inst_15550 = cljs.core.pos_int_QMARK_.call(null,inst_15549__$1);
var state_15652__$1 = (function (){var statearr_15691 = state_15652;
(statearr_15691[(67)] = inst_15548__$1);

(statearr_15691[(68)] = inst_15549__$1);

(statearr_15691[(69)] = inst_15547__$1);

return statearr_15691;
})();
if(inst_15550){
var statearr_15692_15879 = state_15652__$1;
(statearr_15692_15879[(1)] = (98));

} else {
var statearr_15693_15880 = state_15652__$1;
(statearr_15693_15880[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (54))){
var inst_15307 = (state_15652[(15)]);
var inst_15401 = (state_15652[(18)]);
var inst_15392 = (state_15652[(22)]);
var inst_15383 = (state_15652[(25)]);
var inst_15419 = (state_15652[(26)]);
var inst_15338 = (state_15652[(27)]);
var inst_15313 = (state_15652[(29)]);
var inst_15314 = (state_15652[(31)]);
var inst_15432 = (state_15652[(34)]);
var inst_15306 = (state_15652[(38)]);
var inst_15329 = (state_15652[(42)]);
var inst_15410 = (state_15652[(44)]);
var inst_15428 = (state_15652[(45)]);
var inst_15434 = (state_15652[(50)]);
var inst_15428__$1 = (state_15652[(2)]);
var inst_15429 = fluree.db.flake.__GT_Flake.call(null,inst_15329,inst_15401,inst_15383,inst_15306,inst_15307,inst_15419);
var inst_15430 = fluree.db.flake.__GT_Flake.call(null,inst_15338,inst_15410,inst_15392,inst_15313,inst_15314,inst_15428__$1);
var inst_15431 = opts;
var inst_15432__$1 = cljs.core.__destructure_map.call(null,inst_15431);
var inst_15433 = cljs.core.get.call(null,inst_15432__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_15434__$1 = cljs.core.get.call(null,inst_15432__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_15435 = cljs.core.get.call(null,inst_15432__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_15652__$1 = (function (){var statearr_15694 = state_15652;
(statearr_15694[(16)] = inst_15429);

(statearr_15694[(30)] = inst_15430);

(statearr_15694[(34)] = inst_15432__$1);

(statearr_15694[(45)] = inst_15428__$1);

(statearr_15694[(71)] = inst_15435);

(statearr_15694[(47)] = inst_15433);

(statearr_15694[(50)] = inst_15434__$1);

return statearr_15694;
})();
if(cljs.core.truth_(inst_15434__$1)){
var statearr_15695_15881 = state_15652__$1;
(statearr_15695_15881[(1)] = (58));

} else {
var statearr_15696_15882 = state_15652__$1;
(statearr_15696_15882[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (92))){
var inst_15470 = (state_15652[(11)]);
var inst_15473 = (state_15652[(13)]);
var inst_15528 = (state_15652[(72)]);
var inst_15471 = (state_15652[(32)]);
var inst_15472 = (state_15652[(41)]);
var inst_15531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15532 = (inst_15470 - inst_15528);
var inst_15533 = [inst_15532,inst_15471,inst_15472,inst_15473];
var inst_15534 = (new cljs.core.PersistentVector(null,4,(5),inst_15531,inst_15533,null));
var state_15652__$1 = state_15652;
var statearr_15697_15883 = state_15652__$1;
(statearr_15697_15883[(2)] = inst_15534);

(statearr_15697_15883[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (104))){
var inst_15590 = (state_15652[(2)]);
var inst_15591 = fluree.db.util.async.throw_err.call(null,inst_15590);
var state_15652__$1 = state_15652;
var statearr_15698_15884 = state_15652__$1;
(statearr_15698_15884[(2)] = inst_15591);

(statearr_15698_15884[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (15))){
var inst_15312 = (state_15652[(56)]);
var inst_15342 = cljs.core.boolean_QMARK_.call(null,inst_15312);
var state_15652__$1 = state_15652;
if(inst_15342){
var statearr_15699_15885 = state_15652__$1;
(statearr_15699_15885[(1)] = (17));

} else {
var statearr_15700_15886 = state_15652__$1;
(statearr_15700_15886[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (48))){
var inst_15315 = (state_15652[(57)]);
var inst_15419 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15701 = state_15652;
(statearr_15701[(26)] = inst_15419);

return statearr_15701;
})();
if(cljs.core.truth_(inst_15315)){
var statearr_15702_15887 = state_15652__$1;
(statearr_15702_15887[(1)] = (52));

} else {
var statearr_15703_15888 = state_15652__$1;
(statearr_15703_15888[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (50))){
var state_15652__$1 = state_15652;
var statearr_15704_15889 = state_15652__$1;
(statearr_15704_15889[(2)] = (2147483647));

(statearr_15704_15889[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (116))){
var inst_15624 = (state_15652[(66)]);
var inst_15632 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15705 = state_15652;
(statearr_15705[(73)] = inst_15632);

return statearr_15705;
})();
if(cljs.core.truth_(inst_15624)){
var statearr_15706_15890 = state_15652__$1;
(statearr_15706_15890[(1)] = (118));

} else {
var statearr_15707_15891 = state_15652__$1;
(statearr_15707_15891[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (75))){
var inst_15487 = (state_15652[(46)]);
var state_15652__$1 = state_15652;
var statearr_15708_15892 = state_15652__$1;
(statearr_15708_15892[(2)] = inst_15487);

(statearr_15708_15892[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (99))){
var inst_15548 = (state_15652[(67)]);
var inst_15557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15558 = [inst_15548,inst_15548];
var inst_15559 = (new cljs.core.PersistentVector(null,2,(5),inst_15557,inst_15558,null));
var state_15652__$1 = state_15652;
var statearr_15709_15893 = state_15652__$1;
(statearr_15709_15893[(2)] = inst_15559);

(statearr_15709_15893[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (21))){
var state_15652__$1 = state_15652;
var statearr_15710_15894 = state_15652__$1;
(statearr_15710_15894[(2)] = null);

(statearr_15710_15894[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (31))){
var inst_15373 = (state_15652[(74)]);
var state_15652__$1 = state_15652;
var statearr_15711_15895 = state_15652__$1;
(statearr_15711_15895[(2)] = inst_15373);

(statearr_15711_15895[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (113))){
var inst_15618 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15712_15896 = state_15652__$1;
(statearr_15712_15896[(2)] = inst_15618);

(statearr_15712_15896[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (32))){
var inst_15304 = (state_15652[(55)]);
var inst_15393 = (state_15652[(75)]);
var inst_15392 = (state_15652[(2)]);
var inst_15393__$1 = (inst_15304 == null);
var state_15652__$1 = (function (){var statearr_15713 = state_15652;
(statearr_15713[(22)] = inst_15392);

(statearr_15713[(75)] = inst_15393__$1);

return statearr_15713;
})();
if(cljs.core.truth_(inst_15393__$1)){
var statearr_15714_15897 = state_15652__$1;
(statearr_15714_15897[(1)] = (34));

} else {
var statearr_15715_15898 = state_15652__$1;
(statearr_15715_15898[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (40))){
var inst_15392 = (state_15652[(22)]);
var state_15652__$1 = state_15652;
var statearr_15716_15899 = state_15652__$1;
(statearr_15716_15899[(2)] = inst_15392);

(statearr_15716_15899[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (91))){
var inst_15506 = (state_15652[(65)]);
var inst_15604 = (state_15652[(2)]);
var inst_15605 = cljs.core.nth.call(null,inst_15604,(0),null);
var inst_15606 = cljs.core.nth.call(null,inst_15604,(1),null);
var inst_15607 = cljs.core.nth.call(null,inst_15604,(2),null);
var inst_15608 = cljs.core.nth.call(null,inst_15604,(3),null);
var state_15652__$1 = (function (){var statearr_15717 = state_15652;
(statearr_15717[(76)] = inst_15607);

(statearr_15717[(77)] = inst_15606);

(statearr_15717[(78)] = inst_15605);

(statearr_15717[(7)] = inst_15608);

return statearr_15717;
})();
if(cljs.core.truth_(inst_15506)){
var statearr_15718_15900 = state_15652__$1;
(statearr_15718_15900[(1)] = (105));

} else {
var statearr_15719_15901 = state_15652__$1;
(statearr_15719_15901[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (117))){
var inst_15628 = (state_15652[(2)]);
var inst_15629 = fluree.db.util.async.throw_err.call(null,inst_15628);
var state_15652__$1 = state_15652;
var statearr_15720_15902 = state_15652__$1;
(statearr_15720_15902[(2)] = inst_15629);

(statearr_15720_15902[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (108))){
var inst_15613 = (state_15652[(79)]);
var inst_15606 = (state_15652[(77)]);
var inst_15433 = (state_15652[(47)]);
var inst_15613__$1 = (inst_15606 < inst_15433);
var state_15652__$1 = (function (){var statearr_15721 = state_15652;
(statearr_15721[(79)] = inst_15613__$1);

return statearr_15721;
})();
if(cljs.core.truth_(inst_15613__$1)){
var statearr_15722_15903 = state_15652__$1;
(statearr_15722_15903[(1)] = (111));

} else {
var statearr_15723_15904 = state_15652__$1;
(statearr_15723_15904[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (56))){
var state_15652__$1 = state_15652;
var statearr_15724_15905 = state_15652__$1;
(statearr_15724_15905[(2)] = fluree.db.util.core.min_integer);

(statearr_15724_15905[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (33))){
var inst_15388 = (state_15652[(2)]);
var inst_15389 = fluree.db.util.async.throw_err.call(null,inst_15388);
var state_15652__$1 = state_15652;
var statearr_15725_15906 = state_15652__$1;
(statearr_15725_15906[(2)] = inst_15389);

(statearr_15725_15906[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (13))){
var inst_15334 = (state_15652[(2)]);
var inst_15335 = fluree.db.util.async.throw_err.call(null,inst_15334);
var state_15652__$1 = state_15652;
var statearr_15726_15907 = state_15652__$1;
(statearr_15726_15907[(2)] = inst_15335);

(statearr_15726_15907[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (22))){
var inst_15348 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15727_15908 = state_15652__$1;
(statearr_15727_15908[(2)] = inst_15348);

(statearr_15727_15908[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (90))){
var inst_15439 = (state_15652[(10)]);
var inst_15470 = (state_15652[(11)]);
var inst_15466 = (state_15652[(9)]);
var inst_15451 = (state_15652[(12)]);
var inst_15473 = (state_15652[(13)]);
var inst_15302 = (state_15652[(14)]);
var inst_15307 = (state_15652[(15)]);
var inst_15429 = (state_15652[(16)]);
var inst_15371 = (state_15652[(17)]);
var inst_15527 = (state_15652[(80)]);
var inst_15401 = (state_15652[(18)]);
var inst_15446 = (state_15652[(19)]);
var inst_15309 = (state_15652[(20)]);
var inst_15319 = (state_15652[(21)]);
var inst_15528 = (state_15652[(72)]);
var inst_15506 = (state_15652[(65)]);
var inst_15392 = (state_15652[(22)]);
var inst_15318 = (state_15652[(23)]);
var inst_15317 = (state_15652[(24)]);
var inst_15383 = (state_15652[(25)]);
var inst_15419 = (state_15652[(26)]);
var inst_15338 = (state_15652[(27)]);
var inst_15460 = (state_15652[(8)]);
var inst_15479 = (state_15652[(28)]);
var inst_15505 = (state_15652[(81)]);
var inst_15313 = (state_15652[(29)]);
var inst_15430 = (state_15652[(30)]);
var inst_15314 = (state_15652[(31)]);
var inst_15471 = (state_15652[(32)]);
var inst_15445 = (state_15652[(33)]);
var inst_15432 = (state_15652[(34)]);
var inst_15441 = (state_15652[(35)]);
var inst_15450 = (state_15652[(36)]);
var inst_15370 = (state_15652[(37)]);
var inst_15306 = (state_15652[(38)]);
var inst_15440 = (state_15652[(39)]);
var inst_15469 = (state_15652[(40)]);
var inst_15472 = (state_15652[(41)]);
var inst_15329 = (state_15652[(42)]);
var inst_15456 = (state_15652[(43)]);
var inst_15410 = (state_15652[(44)]);
var inst_15428 = (state_15652[(45)]);
var inst_15433 = (state_15652[(47)]);
var inst_15374 = (state_15652[(48)]);
var inst_15526 = (function (){var no_filter_QMARK_ = inst_15466;
var base_result_SINGLEQUOTE_ = inst_15505;
var t = inst_15446;
var max_limit_QMARK_ = inst_15440;
var next_node = inst_15469;
var fast_forward_db_QMARK_ = inst_15451;
var s1 = inst_15329;
var o2 = inst_15392;
var t1 = inst_15306;
var predicate_fn = inst_15319;
var i = inst_15471;
var rhs = inst_15506;
var m1 = inst_15419;
var root_node = inst_15456;
var s2 = inst_15338;
var vec__15295 = inst_15370;
var p2 = inst_15410;
var map__15294 = inst_15317;
var permissions = inst_15441;
var vec__15288 = inst_15302;
var limit = inst_15439;
var start_flake = inst_15429;
var flake_limit = inst_15433;
var offset = inst_15470;
var acc = inst_15473;
var vec__15291 = inst_15309;
var t2 = inst_15313;
var op1 = inst_15307;
var o1 = inst_15383;
var end_flake = inst_15430;
var base_result = inst_15479;
var s = inst_15472;
var node_start = inst_15460;
var p1 = inst_15401;
var subject_fn = inst_15318;
var vec__15298 = inst_15371;
var object_fn = inst_15374;
var idx_compare = inst_15445;
var op2 = inst_15314;
var m2 = inst_15428;
var map__15301 = inst_15432;
var novelty = inst_15450;
return (function (p1__15273_SHARP_){
return p1__15273_SHARP_.s;
});
})();
var inst_15527__$1 = cljs.core.partition_by.call(null,inst_15526,inst_15505);
var inst_15528__$1 = cljs.core.count.call(null,inst_15527__$1);
var inst_15529 = (inst_15470 > inst_15528__$1);
var state_15652__$1 = (function (){var statearr_15728 = state_15652;
(statearr_15728[(80)] = inst_15527__$1);

(statearr_15728[(72)] = inst_15528__$1);

return statearr_15728;
})();
if(cljs.core.truth_(inst_15529)){
var statearr_15729_15909 = state_15652__$1;
(statearr_15729_15909[(1)] = (92));

} else {
var statearr_15730_15910 = state_15652__$1;
(statearr_15730_15910[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (109))){
var inst_15611 = (state_15652[(82)]);
var state_15652__$1 = state_15652;
var statearr_15731_15911 = state_15652__$1;
(statearr_15731_15911[(2)] = inst_15611);

(statearr_15731_15911[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (36))){
var inst_15397 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
if(cljs.core.truth_(inst_15397)){
var statearr_15732_15912 = state_15652__$1;
(statearr_15732_15912[(1)] = (37));

} else {
var statearr_15733_15913 = state_15652__$1;
(statearr_15733_15913[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (41))){
var inst_15402 = (state_15652[(63)]);
var state_15652__$1 = state_15652;
var statearr_15734_15914 = state_15652__$1;
(statearr_15734_15914[(2)] = inst_15402);

(statearr_15734_15914[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (118))){
var inst_15632 = (state_15652[(73)]);
var state_15652__$1 = state_15652;
var statearr_15735_15915 = state_15652__$1;
(statearr_15735_15915[(2)] = inst_15632);

(statearr_15735_15915[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (89))){
var inst_15473 = (state_15652[(13)]);
var inst_15505 = (state_15652[(81)]);
var inst_15471 = (state_15652[(32)]);
var inst_15472 = (state_15652[(41)]);
var inst_15433 = (state_15652[(47)]);
var inst_15517 = cljs.core.count.call(null,inst_15505);
var inst_15518 = (inst_15433 - inst_15471);
var inst_15519 = cljs.core.take.call(null,inst_15518,inst_15505);
var inst_15520 = cljs.core.into.call(null,inst_15473,inst_15519);
var inst_15521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15522 = (inst_15471 + inst_15517);
var inst_15523 = [(0),inst_15522,inst_15472,inst_15520];
var inst_15524 = (new cljs.core.PersistentVector(null,4,(5),inst_15521,inst_15523,null));
var state_15652__$1 = state_15652;
var statearr_15736_15916 = state_15652__$1;
(statearr_15736_15916[(2)] = inst_15524);

(statearr_15736_15916[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (100))){
var inst_15567 = (state_15652[(52)]);
var inst_15565 = (state_15652[(53)]);
var inst_15471 = (state_15652[(32)]);
var inst_15566 = (state_15652[(54)]);
var inst_15433 = (state_15652[(47)]);
var inst_15539 = (state_15652[(70)]);
var inst_15561 = (state_15652[(2)]);
var inst_15562 = cljs.core.nth.call(null,inst_15561,(0),null);
var inst_15563 = cljs.core.nth.call(null,inst_15561,(1),null);
var inst_15564 = cljs.core.take.call(null,inst_15563,inst_15539);
var inst_15565__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_15564);
var inst_15566__$1 = cljs.core.count.call(null,inst_15565__$1);
var inst_15567__$1 = (inst_15471 + inst_15566__$1);
var inst_15568 = (inst_15567__$1 > inst_15433);
var state_15652__$1 = (function (){var statearr_15737 = state_15652;
(statearr_15737[(52)] = inst_15567__$1);

(statearr_15737[(53)] = inst_15565__$1);

(statearr_15737[(54)] = inst_15566__$1);

(statearr_15737[(83)] = inst_15562);

return statearr_15737;
})();
if(cljs.core.truth_(inst_15568)){
var statearr_15738_15917 = state_15652__$1;
(statearr_15738_15917[(1)] = (101));

} else {
var statearr_15739_15918 = state_15652__$1;
(statearr_15739_15918[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (122))){
var inst_15632 = (state_15652[(73)]);
var inst_15607 = (state_15652[(76)]);
var inst_15606 = (state_15652[(77)]);
var inst_15605 = (state_15652[(78)]);
var inst_15608 = (state_15652[(7)]);
var inst_15469 = inst_15632;
var inst_15470 = inst_15605;
var inst_15471 = inst_15606;
var inst_15472 = inst_15607;
var inst_15473 = inst_15608;
var state_15652__$1 = (function (){var statearr_15740 = state_15652;
(statearr_15740[(11)] = inst_15470);

(statearr_15740[(13)] = inst_15473);

(statearr_15740[(32)] = inst_15471);

(statearr_15740[(40)] = inst_15469);

(statearr_15740[(41)] = inst_15472);

return statearr_15740;
})();
var statearr_15741_15919 = state_15652__$1;
(statearr_15741_15919[(2)] = null);

(statearr_15741_15919[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (43))){
var state_15652__$1 = state_15652;
var statearr_15742_15920 = state_15652__$1;
(statearr_15742_15920[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15742_15920[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (61))){
var inst_15451 = (state_15652[(12)]);
var inst_15429 = (state_15652[(16)]);
var inst_15446 = (state_15652[(19)]);
var inst_15450 = (state_15652[(36)]);
var inst_15456 = (state_15652[(43)]);
var inst_15455 = (state_15652[(2)]);
var inst_15456__$1 = fluree.db.util.async.throw_err.call(null,inst_15455);
var inst_15457 = fluree.db.query.range.find_next_valid_node.call(null,inst_15456__$1,inst_15429,inst_15446,inst_15450,inst_15451);
var state_15652__$1 = (function (){var statearr_15743 = state_15652;
(statearr_15743[(43)] = inst_15456__$1);

return statearr_15743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(62),inst_15457);
} else {
if((state_val_15653 === (29))){
var inst_15379 = (state_15652[(2)]);
var inst_15380 = fluree.db.util.async.throw_err.call(null,inst_15379);
var state_15652__$1 = state_15652;
var statearr_15744_15921 = state_15652__$1;
(statearr_15744_15921[(2)] = inst_15380);

(statearr_15744_15921[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (44))){
var inst_15311 = (state_15652[(59)]);
var state_15652__$1 = state_15652;
var statearr_15745_15922 = state_15652__$1;
(statearr_15745_15922[(2)] = inst_15311);

(statearr_15745_15922[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (93))){
var inst_15470 = (state_15652[(11)]);
var inst_15466 = (state_15652[(9)]);
var inst_15527 = (state_15652[(80)]);
var inst_15539 = cljs.core.drop.call(null,inst_15470,inst_15527);
var state_15652__$1 = (function (){var statearr_15746 = state_15652;
(statearr_15746[(70)] = inst_15539);

return statearr_15746;
})();
if(cljs.core.truth_(inst_15466)){
var statearr_15747_15923 = state_15652__$1;
(statearr_15747_15923[(1)] = (95));

} else {
var statearr_15748_15924 = state_15652__$1;
(statearr_15748_15924[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (6))){
var inst_15303 = (state_15652[(49)]);
var inst_15323 = fluree.db.dbproto._subid.call(null,db,inst_15303);
var state_15652__$1 = state_15652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(9),inst_15323);
} else {
if((state_val_15653 === (111))){
var inst_15439 = (state_15652[(10)]);
var inst_15607 = (state_15652[(76)]);
var inst_15615 = (inst_15607 < inst_15439);
var state_15652__$1 = state_15652;
var statearr_15749_15925 = state_15652__$1;
(statearr_15749_15925[(2)] = inst_15615);

(statearr_15749_15925[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (28))){
var inst_15373 = (state_15652[(74)]);
var inst_15383 = (state_15652[(2)]);
var inst_15384 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15373);
var state_15652__$1 = (function (){var statearr_15750 = state_15652;
(statearr_15750[(25)] = inst_15383);

return statearr_15750;
})();
if(inst_15384){
var statearr_15751_15926 = state_15652__$1;
(statearr_15751_15926[(1)] = (30));

} else {
var statearr_15752_15927 = state_15652__$1;
(statearr_15752_15927[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (64))){
var state_15652__$1 = state_15652;
var statearr_15753_15928 = state_15652__$1;
(statearr_15753_15928[(2)] = true);

(statearr_15753_15928[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (103))){
var inst_15562 = (state_15652[(83)]);
var inst_15581 = (state_15652[(2)]);
var inst_15582 = cljs.core.nth.call(null,inst_15581,(0),null);
var inst_15583 = cljs.core.nth.call(null,inst_15581,(1),null);
var inst_15584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15585 = [inst_15582,inst_15562,inst_15583];
var inst_15586 = (new cljs.core.PersistentVector(null,3,(5),inst_15584,inst_15585,null));
var state_15652__$1 = state_15652;
var statearr_15754_15929 = state_15652__$1;
(statearr_15754_15929[(2)] = inst_15586);

(statearr_15754_15929[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (51))){
var inst_15417 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15755_15930 = state_15652__$1;
(statearr_15755_15930[(2)] = inst_15417);

(statearr_15755_15930[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (25))){
var inst_15371 = (state_15652[(17)]);
var inst_15372 = (state_15652[(51)]);
var inst_15370 = (state_15652[(37)]);
var inst_15370__$1 = (state_15652[(2)]);
var inst_15371__$1 = cljs.core.nth.call(null,inst_15370__$1,(0),null);
var inst_15372__$1 = cljs.core.nth.call(null,inst_15371__$1,(0),null);
var inst_15373 = cljs.core.nth.call(null,inst_15371__$1,(1),null);
var inst_15374 = cljs.core.nth.call(null,inst_15370__$1,(1),null);
var inst_15375 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15372__$1);
var state_15652__$1 = (function (){var statearr_15756 = state_15652;
(statearr_15756[(17)] = inst_15371__$1);

(statearr_15756[(74)] = inst_15373);

(statearr_15756[(51)] = inst_15372__$1);

(statearr_15756[(37)] = inst_15370__$1);

(statearr_15756[(48)] = inst_15374);

return statearr_15756;
})();
if(inst_15375){
var statearr_15757_15931 = state_15652__$1;
(statearr_15757_15931[(1)] = (26));

} else {
var statearr_15758_15932 = state_15652__$1;
(statearr_15758_15932[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (34))){
var inst_15383 = (state_15652[(25)]);
var state_15652__$1 = state_15652;
var statearr_15759_15933 = state_15652__$1;
(statearr_15759_15933[(2)] = inst_15383);

(statearr_15759_15933[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (17))){
var inst_15312 = (state_15652[(56)]);
var state_15652__$1 = state_15652;
var statearr_15760_15934 = state_15652__$1;
(statearr_15760_15934[(2)] = inst_15312);

(statearr_15760_15934[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (3))){
var inst_15650 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15652__$1,inst_15650);
} else {
if((state_val_15653 === (12))){
var inst_15305 = (state_15652[(61)]);
var inst_15338 = (state_15652[(2)]);
var inst_15339 = cljs.core.boolean_QMARK_.call(null,inst_15305);
var state_15652__$1 = (function (){var statearr_15761 = state_15652;
(statearr_15761[(27)] = inst_15338);

return statearr_15761;
})();
if(inst_15339){
var statearr_15762_15935 = state_15652__$1;
(statearr_15762_15935[(1)] = (14));

} else {
var statearr_15763_15936 = state_15652__$1;
(statearr_15763_15936[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (2))){
var inst_15302 = (state_15652[(14)]);
var inst_15309 = (state_15652[(20)]);
var inst_15317 = (state_15652[(24)]);
var inst_15303 = (state_15652[(49)]);
var _ = (function (){var statearr_15764 = state_15652;
(statearr_15764[(4)] = cljs.core.cons.call(null,(5),(state_15652[(4)])));

return statearr_15764;
})();
var inst_15302__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_15303__$1 = cljs.core.nth.call(null,inst_15302__$1,(0),null);
var inst_15304 = cljs.core.nth.call(null,inst_15302__$1,(1),null);
var inst_15305 = cljs.core.nth.call(null,inst_15302__$1,(2),null);
var inst_15306 = cljs.core.nth.call(null,inst_15302__$1,(3),null);
var inst_15307 = cljs.core.nth.call(null,inst_15302__$1,(4),null);
var inst_15308 = cljs.core.nth.call(null,inst_15302__$1,(5),null);
var inst_15309__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_15310 = cljs.core.nth.call(null,inst_15309__$1,(0),null);
var inst_15311 = cljs.core.nth.call(null,inst_15309__$1,(1),null);
var inst_15312 = cljs.core.nth.call(null,inst_15309__$1,(2),null);
var inst_15313 = cljs.core.nth.call(null,inst_15309__$1,(3),null);
var inst_15314 = cljs.core.nth.call(null,inst_15309__$1,(4),null);
var inst_15315 = cljs.core.nth.call(null,inst_15309__$1,(5),null);
var inst_15316 = opts;
var inst_15317__$1 = cljs.core.__destructure_map.call(null,inst_15316);
var inst_15318 = cljs.core.get.call(null,inst_15317__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_15319 = cljs.core.get.call(null,inst_15317__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_15320 = cljs.core.get.call(null,inst_15317__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_15321 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15303__$1);
var state_15652__$1 = (function (){var statearr_15765 = state_15652;
(statearr_15765[(55)] = inst_15304);

(statearr_15765[(14)] = inst_15302__$1);

(statearr_15765[(15)] = inst_15307);

(statearr_15765[(56)] = inst_15312);

(statearr_15765[(57)] = inst_15315);

(statearr_15765[(58)] = inst_15308);

(statearr_15765[(20)] = inst_15309__$1);

(statearr_15765[(84)] = inst_15310);

(statearr_15765[(59)] = inst_15311);

(statearr_15765[(21)] = inst_15319);

(statearr_15765[(23)] = inst_15318);

(statearr_15765[(24)] = inst_15317__$1);

(statearr_15765[(60)] = inst_15320);

(statearr_15765[(29)] = inst_15313);

(statearr_15765[(31)] = inst_15314);

(statearr_15765[(61)] = inst_15305);

(statearr_15765[(38)] = inst_15306);

(statearr_15765[(49)] = inst_15303__$1);

return statearr_15765;
})();
if(inst_15321){
var statearr_15766_15937 = state_15652__$1;
(statearr_15766_15937[(1)] = (6));

} else {
var statearr_15767_15938 = state_15652__$1;
(statearr_15767_15938[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (66))){
var inst_15460 = (state_15652[(8)]);
var inst_15435 = (state_15652[(71)]);
var inst_15468 = cljs.core.PersistentVector.EMPTY;
var inst_15469 = inst_15460;
var inst_15470 = inst_15435;
var inst_15471 = (0);
var inst_15472 = (0);
var inst_15473 = inst_15468;
var state_15652__$1 = (function (){var statearr_15768 = state_15652;
(statearr_15768[(11)] = inst_15470);

(statearr_15768[(13)] = inst_15473);

(statearr_15768[(32)] = inst_15471);

(statearr_15768[(40)] = inst_15469);

(statearr_15768[(41)] = inst_15472);

return statearr_15768;
})();
var statearr_15769_15939 = state_15652__$1;
(statearr_15769_15939[(2)] = null);

(statearr_15769_15939[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (107))){
var inst_15624 = (state_15652[(66)]);
var inst_15624__$1 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15770 = state_15652;
(statearr_15770[(66)] = inst_15624__$1);

return statearr_15770;
})();
if(cljs.core.truth_(inst_15624__$1)){
var statearr_15771_15940 = state_15652__$1;
(statearr_15771_15940[(1)] = (114));

} else {
var statearr_15772_15941 = state_15652__$1;
(statearr_15772_15941[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (23))){
var inst_15312 = (state_15652[(56)]);
var inst_15320 = (state_15652[(60)]);
var inst_15305 = (state_15652[(61)]);
var inst_15355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15357 = [inst_15305,inst_15312];
var inst_15358 = (new cljs.core.PersistentVector(null,2,(5),inst_15356,inst_15357,null));
var inst_15359 = [inst_15358,inst_15320];
var inst_15360 = (new cljs.core.PersistentVector(null,2,(5),inst_15355,inst_15359,null));
var state_15652__$1 = state_15652;
var statearr_15773_15942 = state_15652__$1;
(statearr_15773_15942[(2)] = inst_15360);

(statearr_15773_15942[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (47))){
var inst_15413 = (cljs.core._GT__EQ_ === start_test);
var state_15652__$1 = state_15652;
if(cljs.core.truth_(inst_15413)){
var statearr_15774_15943 = state_15652__$1;
(statearr_15774_15943[(1)] = (49));

} else {
var statearr_15775_15944 = state_15652__$1;
(statearr_15775_15944[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (35))){
var inst_15393 = (state_15652[(75)]);
var state_15652__$1 = state_15652;
var statearr_15776_15945 = state_15652__$1;
(statearr_15776_15945[(2)] = inst_15393);

(statearr_15776_15945[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (82))){
var inst_15440 = (state_15652[(39)]);
var inst_15469 = (state_15652[(40)]);
var inst_15505 = (state_15652[(2)]);
var inst_15506 = fluree.db.dbproto._rhs.call(null,inst_15469);
var state_15652__$1 = (function (){var statearr_15777 = state_15652;
(statearr_15777[(65)] = inst_15506);

(statearr_15777[(81)] = inst_15505);

return statearr_15777;
})();
if(cljs.core.truth_(inst_15440)){
var statearr_15778_15946 = state_15652__$1;
(statearr_15778_15946[(1)] = (83));

} else {
var statearr_15779_15947 = state_15652__$1;
(statearr_15779_15947[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (76))){
var inst_15319 = (state_15652[(21)]);
var inst_15493 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15780 = state_15652;
(statearr_15780[(64)] = inst_15493);

return statearr_15780;
})();
if(cljs.core.truth_(inst_15319)){
var statearr_15781_15948 = state_15652__$1;
(statearr_15781_15948[(1)] = (77));

} else {
var statearr_15782_15949 = state_15652__$1;
(statearr_15782_15949[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (97))){
var inst_15473 = (state_15652[(13)]);
var inst_15593 = (state_15652[(2)]);
var inst_15594 = cljs.core.nth.call(null,inst_15593,(0),null);
var inst_15595 = cljs.core.nth.call(null,inst_15593,(1),null);
var inst_15596 = cljs.core.nth.call(null,inst_15593,(2),null);
var inst_15597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15598 = cljs.core.into.call(null,inst_15473,inst_15596);
var inst_15599 = [(0),inst_15594,inst_15595,inst_15598];
var inst_15600 = (new cljs.core.PersistentVector(null,4,(5),inst_15597,inst_15599,null));
var state_15652__$1 = state_15652;
var statearr_15783_15950 = state_15652__$1;
(statearr_15783_15950[(2)] = inst_15600);

(statearr_15783_15950[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (19))){
var inst_15350 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15784_15951 = state_15652__$1;
(statearr_15784_15951[(2)] = inst_15350);

(statearr_15784_15951[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (57))){
var inst_15426 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15785_15952 = state_15652__$1;
(statearr_15785_15952[(2)] = inst_15426);

(statearr_15785_15952[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (68))){
var inst_15647 = (state_15652[(2)]);
var _ = (function (){var statearr_15786 = state_15652;
(statearr_15786[(4)] = cljs.core.rest.call(null,(state_15652[(4)])));

return statearr_15786;
})();
var state_15652__$1 = state_15652;
var statearr_15787_15953 = state_15652__$1;
(statearr_15787_15953[(2)] = inst_15647);

(statearr_15787_15953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (11))){
var inst_15310 = (state_15652[(84)]);
var state_15652__$1 = state_15652;
var statearr_15788_15954 = state_15652__$1;
(statearr_15788_15954[(2)] = inst_15310);

(statearr_15788_15954[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (115))){
var state_15652__$1 = state_15652;
var statearr_15790_15955 = state_15652__$1;
(statearr_15790_15955[(2)] = null);

(statearr_15790_15955[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (9))){
var inst_15325 = (state_15652[(2)]);
var inst_15326 = fluree.db.util.async.throw_err.call(null,inst_15325);
var state_15652__$1 = state_15652;
var statearr_15791_15956 = state_15652__$1;
(statearr_15791_15956[(2)] = inst_15326);

(statearr_15791_15956[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (5))){
var _ = (function (){var statearr_15792 = state_15652;
(statearr_15792[(4)] = cljs.core.rest.call(null,(state_15652[(4)])));

return statearr_15792;
})();
var state_15652__$1 = state_15652;
var ex15789 = (state_15652__$1[(2)]);
var statearr_15793_15957 = state_15652__$1;
(statearr_15793_15957[(5)] = ex15789);


if((ex15789 instanceof Error)){
var statearr_15794_15958 = state_15652__$1;
(statearr_15794_15958[(1)] = (4));

(statearr_15794_15958[(5)] = null);

} else {
throw ex15789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (112))){
var inst_15613 = (state_15652[(79)]);
var state_15652__$1 = state_15652;
var statearr_15795_15959 = state_15652__$1;
(statearr_15795_15959[(2)] = inst_15613);

(statearr_15795_15959[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (83))){
var inst_15470 = (state_15652[(11)]);
var inst_15508 = (state_15652[(85)]);
var inst_15508__$1 = cljs.core._EQ_.call(null,(0),inst_15470);
var state_15652__$1 = (function (){var statearr_15796 = state_15652;
(statearr_15796[(85)] = inst_15508__$1);

return statearr_15796;
})();
if(inst_15508__$1){
var statearr_15797_15960 = state_15652__$1;
(statearr_15797_15960[(1)] = (86));

} else {
var statearr_15798_15961 = state_15652__$1;
(statearr_15798_15961[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (14))){
var inst_15305 = (state_15652[(61)]);
var state_15652__$1 = state_15652;
var statearr_15799_15962 = state_15652__$1;
(statearr_15799_15962[(2)] = inst_15305);

(statearr_15799_15962[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (45))){
var inst_15308 = (state_15652[(58)]);
var inst_15410 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15800 = state_15652;
(statearr_15800[(44)] = inst_15410);

return statearr_15800;
})();
if(cljs.core.truth_(inst_15308)){
var statearr_15801_15963 = state_15652__$1;
(statearr_15801_15963[(1)] = (46));

} else {
var statearr_15802_15964 = state_15652__$1;
(statearr_15802_15964[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (53))){
var inst_15422 = (cljs.core._LT__EQ_ === end_test);
var state_15652__$1 = state_15652;
if(cljs.core.truth_(inst_15422)){
var statearr_15803_15965 = state_15652__$1;
(statearr_15803_15965[(1)] = (55));

} else {
var statearr_15804_15966 = state_15652__$1;
(statearr_15804_15966[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (78))){
var inst_15493 = (state_15652[(64)]);
var state_15652__$1 = state_15652;
var statearr_15805_15967 = state_15652__$1;
(statearr_15805_15967[(2)] = inst_15493);

(statearr_15805_15967[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (26))){
var inst_15372 = (state_15652[(51)]);
var inst_15377 = fluree.db.dbproto._subid.call(null,db,inst_15372);
var state_15652__$1 = state_15652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(29),inst_15377);
} else {
if((state_val_15653 === (123))){
var inst_15642 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15806_15968 = state_15652__$1;
(statearr_15806_15968[(2)] = inst_15642);

(statearr_15806_15968[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (16))){
var inst_15352 = (state_15652[(62)]);
var inst_15352__$1 = (state_15652[(2)]);
var inst_15353 = (inst_15352__$1 == null);
var state_15652__$1 = (function (){var statearr_15807 = state_15652;
(statearr_15807[(62)] = inst_15352__$1);

return statearr_15807;
})();
if(cljs.core.truth_(inst_15353)){
var statearr_15808_15969 = state_15652__$1;
(statearr_15808_15969[(1)] = (23));

} else {
var statearr_15809_15970 = state_15652__$1;
(statearr_15809_15970[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (81))){
var inst_15499 = (state_15652[(86)]);
var state_15652__$1 = state_15652;
var statearr_15810_15971 = state_15652__$1;
(statearr_15810_15971[(2)] = inst_15499);

(statearr_15810_15971[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (120))){
var inst_15636 = (state_15652[(2)]);
var inst_15637 = cljs.core.not.call(null,inst_15636);
var state_15652__$1 = state_15652;
if(inst_15637){
var statearr_15811_15972 = state_15652__$1;
(statearr_15811_15972[(1)] = (121));

} else {
var statearr_15812_15973 = state_15652__$1;
(statearr_15812_15973[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (79))){
var inst_15374 = (state_15652[(48)]);
var inst_15499 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15813 = state_15652;
(statearr_15813[(86)] = inst_15499);

return statearr_15813;
})();
if(cljs.core.truth_(inst_15374)){
var statearr_15814_15974 = state_15652__$1;
(statearr_15814_15974[(1)] = (80));

} else {
var statearr_15815_15975 = state_15652__$1;
(statearr_15815_15975[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (38))){
var inst_15304 = (state_15652[(55)]);
var state_15652__$1 = state_15652;
var statearr_15816_15976 = state_15652__$1;
(statearr_15816_15976[(2)] = inst_15304);

(statearr_15816_15976[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (98))){
var inst_15439 = (state_15652[(10)]);
var inst_15549 = (state_15652[(68)]);
var inst_15547 = (state_15652[(69)]);
var inst_15552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15553 = (inst_15547 - inst_15549);
var inst_15554 = [inst_15439,inst_15553];
var inst_15555 = (new cljs.core.PersistentVector(null,2,(5),inst_15552,inst_15554,null));
var state_15652__$1 = state_15652;
var statearr_15817_15977 = state_15652__$1;
(statearr_15817_15977[(2)] = inst_15555);

(statearr_15817_15977[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (87))){
var inst_15508 = (state_15652[(85)]);
var state_15652__$1 = state_15652;
var statearr_15818_15978 = state_15652__$1;
(statearr_15818_15978[(2)] = inst_15508);

(statearr_15818_15978[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (30))){
var inst_15373 = (state_15652[(74)]);
var inst_15386 = fluree.db.dbproto._subid.call(null,db,inst_15373);
var state_15652__$1 = state_15652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(33),inst_15386);
} else {
if((state_val_15653 === (73))){
var inst_15318 = (state_15652[(23)]);
var inst_15487 = (state_15652[(2)]);
var state_15652__$1 = (function (){var statearr_15819 = state_15652;
(statearr_15819[(46)] = inst_15487);

return statearr_15819;
})();
if(cljs.core.truth_(inst_15318)){
var statearr_15820_15979 = state_15652__$1;
(statearr_15820_15979[(1)] = (74));

} else {
var statearr_15821_15980 = state_15652__$1;
(statearr_15821_15980[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (96))){
var inst_15439 = (state_15652[(10)]);
var inst_15471 = (state_15652[(32)]);
var inst_15472 = (state_15652[(41)]);
var inst_15433 = (state_15652[(47)]);
var inst_15539 = (state_15652[(70)]);
var inst_15588 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_15539,inst_15471,inst_15472,inst_15433,inst_15439);
var state_15652__$1 = state_15652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(104),inst_15588);
} else {
if((state_val_15653 === (10))){
var inst_15310 = (state_15652[(84)]);
var inst_15332 = fluree.db.dbproto._subid.call(null,db,inst_15310);
var state_15652__$1 = state_15652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(13),inst_15332);
} else {
if((state_val_15653 === (18))){
var state_15652__$1 = state_15652;
var statearr_15822_15981 = state_15652__$1;
(statearr_15822_15981[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (105))){
var inst_15506 = (state_15652[(65)]);
var inst_15430 = (state_15652[(30)]);
var inst_15445 = (state_15652[(33)]);
var inst_15611 = (state_15652[(82)]);
var inst_15610 = inst_15445.call(null,inst_15506,inst_15430);
var inst_15611__$1 = (inst_15610 < (0));
var state_15652__$1 = (function (){var statearr_15824 = state_15652;
(statearr_15824[(82)] = inst_15611__$1);

return statearr_15824;
})();
if(cljs.core.truth_(inst_15611__$1)){
var statearr_15825_15982 = state_15652__$1;
(statearr_15825_15982[(1)] = (108));

} else {
var statearr_15826_15983 = state_15652__$1;
(statearr_15826_15983[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (52))){
var inst_15315 = (state_15652[(57)]);
var state_15652__$1 = state_15652;
var statearr_15827_15984 = state_15652__$1;
(statearr_15827_15984[(2)] = inst_15315);

(statearr_15827_15984[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (114))){
var inst_15451 = (state_15652[(12)]);
var inst_15446 = (state_15652[(19)]);
var inst_15506 = (state_15652[(65)]);
var inst_15450 = (state_15652[(36)]);
var inst_15456 = (state_15652[(43)]);
var inst_15626 = fluree.db.query.range.find_next_valid_node.call(null,inst_15456,inst_15506,inst_15446,inst_15450,inst_15451);
var state_15652__$1 = state_15652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15652__$1,(117),inst_15626);
} else {
if((state_val_15653 === (67))){
var state_15652__$1 = state_15652;
var statearr_15828_15985 = state_15652__$1;
(statearr_15828_15985[(2)] = null);

(statearr_15828_15985[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (71))){
var inst_15439 = (state_15652[(10)]);
var inst_15470 = (state_15652[(11)]);
var inst_15466 = (state_15652[(9)]);
var inst_15451 = (state_15652[(12)]);
var inst_15473 = (state_15652[(13)]);
var inst_15302 = (state_15652[(14)]);
var inst_15307 = (state_15652[(15)]);
var inst_15429 = (state_15652[(16)]);
var inst_15371 = (state_15652[(17)]);
var inst_15401 = (state_15652[(18)]);
var inst_15446 = (state_15652[(19)]);
var inst_15309 = (state_15652[(20)]);
var inst_15319 = (state_15652[(21)]);
var inst_15392 = (state_15652[(22)]);
var inst_15318 = (state_15652[(23)]);
var inst_15317 = (state_15652[(24)]);
var inst_15383 = (state_15652[(25)]);
var inst_15419 = (state_15652[(26)]);
var inst_15338 = (state_15652[(27)]);
var inst_15460 = (state_15652[(8)]);
var inst_15479 = (state_15652[(28)]);
var inst_15313 = (state_15652[(29)]);
var inst_15430 = (state_15652[(30)]);
var inst_15314 = (state_15652[(31)]);
var inst_15471 = (state_15652[(32)]);
var inst_15445 = (state_15652[(33)]);
var inst_15432 = (state_15652[(34)]);
var inst_15441 = (state_15652[(35)]);
var inst_15450 = (state_15652[(36)]);
var inst_15370 = (state_15652[(37)]);
var inst_15306 = (state_15652[(38)]);
var inst_15440 = (state_15652[(39)]);
var inst_15469 = (state_15652[(40)]);
var inst_15472 = (state_15652[(41)]);
var inst_15329 = (state_15652[(42)]);
var inst_15456 = (state_15652[(43)]);
var inst_15410 = (state_15652[(44)]);
var inst_15428 = (state_15652[(45)]);
var inst_15433 = (state_15652[(47)]);
var inst_15374 = (state_15652[(48)]);
var inst_15483 = (function (){var no_filter_QMARK_ = inst_15466;
var t = inst_15446;
var max_limit_QMARK_ = inst_15440;
var next_node = inst_15469;
var fast_forward_db_QMARK_ = inst_15451;
var s1 = inst_15329;
var o2 = inst_15392;
var t1 = inst_15306;
var predicate_fn = inst_15319;
var i = inst_15471;
var m1 = inst_15419;
var root_node = inst_15456;
var s2 = inst_15338;
var vec__15295 = inst_15370;
var p2 = inst_15410;
var map__15294 = inst_15317;
var permissions = inst_15441;
var vec__15288 = inst_15302;
var limit = inst_15439;
var start_flake = inst_15429;
var flake_limit = inst_15433;
var offset = inst_15470;
var acc = inst_15473;
var vec__15291 = inst_15309;
var t2 = inst_15313;
var op1 = inst_15307;
var o1 = inst_15383;
var end_flake = inst_15430;
var base_result = inst_15479;
var s = inst_15472;
var node_start = inst_15460;
var p1 = inst_15401;
var subject_fn = inst_15318;
var G__15480 = inst_15479;
var vec__15298 = inst_15371;
var object_fn = inst_15374;
var idx_compare = inst_15445;
var op2 = inst_15314;
var m2 = inst_15428;
var map__15301 = inst_15432;
var novelty = inst_15450;
return (function (p1__15269_SHARP_){
return cljs.core._EQ_.call(null,p1__15269_SHARP_.o,start_flake.o);
});
})();
var inst_15484 = cljs.core.filter.call(null,inst_15483,inst_15479);
var state_15652__$1 = state_15652;
var statearr_15829_15986 = state_15652__$1;
(statearr_15829_15986[(2)] = inst_15484);

(statearr_15829_15986[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (42))){
var inst_15406 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
if(cljs.core.truth_(inst_15406)){
var statearr_15830_15987 = state_15652__$1;
(statearr_15830_15987[(1)] = (43));

} else {
var statearr_15831_15988 = state_15652__$1;
(statearr_15831_15988[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (80))){
var inst_15439 = (state_15652[(10)]);
var inst_15470 = (state_15652[(11)]);
var inst_15466 = (state_15652[(9)]);
var inst_15451 = (state_15652[(12)]);
var inst_15473 = (state_15652[(13)]);
var inst_15302 = (state_15652[(14)]);
var inst_15307 = (state_15652[(15)]);
var inst_15429 = (state_15652[(16)]);
var inst_15371 = (state_15652[(17)]);
var inst_15401 = (state_15652[(18)]);
var inst_15446 = (state_15652[(19)]);
var inst_15309 = (state_15652[(20)]);
var inst_15319 = (state_15652[(21)]);
var inst_15392 = (state_15652[(22)]);
var inst_15318 = (state_15652[(23)]);
var inst_15317 = (state_15652[(24)]);
var inst_15499 = (state_15652[(86)]);
var inst_15383 = (state_15652[(25)]);
var inst_15419 = (state_15652[(26)]);
var inst_15338 = (state_15652[(27)]);
var inst_15460 = (state_15652[(8)]);
var inst_15479 = (state_15652[(28)]);
var inst_15313 = (state_15652[(29)]);
var inst_15430 = (state_15652[(30)]);
var inst_15314 = (state_15652[(31)]);
var inst_15471 = (state_15652[(32)]);
var inst_15445 = (state_15652[(33)]);
var inst_15432 = (state_15652[(34)]);
var inst_15441 = (state_15652[(35)]);
var inst_15450 = (state_15652[(36)]);
var inst_15370 = (state_15652[(37)]);
var inst_15306 = (state_15652[(38)]);
var inst_15440 = (state_15652[(39)]);
var inst_15469 = (state_15652[(40)]);
var inst_15472 = (state_15652[(41)]);
var inst_15329 = (state_15652[(42)]);
var inst_15456 = (state_15652[(43)]);
var inst_15410 = (state_15652[(44)]);
var inst_15428 = (state_15652[(45)]);
var inst_15433 = (state_15652[(47)]);
var inst_15374 = (state_15652[(48)]);
var inst_15501 = (function (){var no_filter_QMARK_ = inst_15466;
var t = inst_15446;
var max_limit_QMARK_ = inst_15440;
var next_node = inst_15469;
var fast_forward_db_QMARK_ = inst_15451;
var s1 = inst_15329;
var o2 = inst_15392;
var t1 = inst_15306;
var predicate_fn = inst_15319;
var i = inst_15471;
var m1 = inst_15419;
var root_node = inst_15456;
var s2 = inst_15338;
var vec__15295 = inst_15370;
var p2 = inst_15410;
var map__15294 = inst_15317;
var permissions = inst_15441;
var vec__15288 = inst_15302;
var limit = inst_15439;
var start_flake = inst_15429;
var flake_limit = inst_15433;
var offset = inst_15470;
var acc = inst_15473;
var vec__15291 = inst_15309;
var t2 = inst_15313;
var op1 = inst_15307;
var o1 = inst_15383;
var end_flake = inst_15430;
var base_result = inst_15479;
var s = inst_15472;
var node_start = inst_15460;
var p1 = inst_15401;
var subject_fn = inst_15318;
var G__15480 = inst_15499;
var vec__15298 = inst_15371;
var object_fn = inst_15374;
var idx_compare = inst_15445;
var op2 = inst_15314;
var m2 = inst_15428;
var map__15301 = inst_15432;
var novelty = inst_15450;
return (function (p1__15272_SHARP_){
return object_fn.call(null,p1__15272_SHARP_.o);
});
})();
var inst_15502 = cljs.core.filter.call(null,inst_15501,inst_15499);
var state_15652__$1 = state_15652;
var statearr_15832_15989 = state_15652__$1;
(statearr_15832_15989[(2)] = inst_15502);

(statearr_15832_15989[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (37))){
var state_15652__$1 = state_15652;
var statearr_15833_15990 = state_15652__$1;
(statearr_15833_15990[(2)] = (-1));

(statearr_15833_15990[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (63))){
var inst_15401 = (state_15652[(18)]);
var inst_15338 = (state_15652[(27)]);
var inst_15441 = (state_15652[(35)]);
var inst_15329 = (state_15652[(42)]);
var inst_15410 = (state_15652[(44)]);
var inst_15463 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_15441,inst_15329,inst_15338,inst_15401,inst_15410);
var state_15652__$1 = state_15652;
var statearr_15834_15991 = state_15652__$1;
(statearr_15834_15991[(2)] = inst_15463);

(statearr_15834_15991[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (94))){
var inst_15602 = (state_15652[(2)]);
var state_15652__$1 = state_15652;
var statearr_15835_15992 = state_15652__$1;
(statearr_15835_15992[(2)] = inst_15602);

(statearr_15835_15992[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (8))){
var inst_15310 = (state_15652[(84)]);
var inst_15329 = (state_15652[(2)]);
var inst_15330 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15310);
var state_15652__$1 = (function (){var statearr_15836 = state_15652;
(statearr_15836[(42)] = inst_15329);

return statearr_15836;
})();
if(inst_15330){
var statearr_15837_15993 = state_15652__$1;
(statearr_15837_15993[(1)] = (10));

} else {
var statearr_15838_15994 = state_15652__$1;
(statearr_15838_15994[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (49))){
var state_15652__$1 = state_15652;
var statearr_15839_15995 = state_15652__$1;
(statearr_15839_15995[(2)] = fluree.db.util.core.min_integer);

(statearr_15839_15995[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15653 === (84))){
var inst_15440 = (state_15652[(39)]);
var state_15652__$1 = state_15652;
var statearr_15840_15996 = state_15652__$1;
(statearr_15840_15996[(2)] = inst_15440);

(statearr_15840_15996[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2703__auto__ = null;
var fluree$db$query$range$state_machine__2703__auto____0 = (function (){
var statearr_15841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15841[(0)] = fluree$db$query$range$state_machine__2703__auto__);

(statearr_15841[(1)] = (1));

return statearr_15841;
});
var fluree$db$query$range$state_machine__2703__auto____1 = (function (state_15652){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_15652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e15842){var ex__2706__auto__ = e15842;
var statearr_15843_15997 = state_15652;
(statearr_15843_15997[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_15652[(4)]))){
var statearr_15844_15998 = state_15652;
(statearr_15844_15998[(1)] = cljs.core.first.call(null,(state_15652[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15999 = state_15652;
state_15652 = G__15999;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2703__auto__ = function(state_15652){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2703__auto____1.call(this,state_15652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2703__auto____0;
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2703__auto____1;
return fluree$db$query$range$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_15845 = f__2726__auto__.call(null);
(statearr_15845[(6)] = c__2725__auto__);

return statearr_15845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_16055){
var state_val_16056 = (state_16055[(1)]);
if((state_val_16056 === (7))){
var inst_16029 = (state_16055[(7)]);
var inst_16019 = (state_16055[(8)]);
var inst_16027 = fluree.db.flake.Flake__GT_parts.call(null,inst_16019);
var inst_16028 = cljs.core.nth.call(null,inst_16027,(0),null);
var inst_16029__$1 = cljs.core.nth.call(null,inst_16027,(1),null);
var inst_16030 = cljs.core.nth.call(null,inst_16027,(2),null);
var inst_16031 = cljs.core.nth.call(null,inst_16027,(3),null);
var inst_16032 = cljs.core.nth.call(null,inst_16027,(4),null);
var inst_16033 = cljs.core.nth.call(null,inst_16027,(5),null);
var inst_16034 = fluree.db.dbproto._tag.call(null,db,inst_16030,inst_16029__$1);
var state_16055__$1 = (function (){var statearr_16057 = state_16055;
(statearr_16057[(9)] = inst_16028);

(statearr_16057[(7)] = inst_16029__$1);

(statearr_16057[(10)] = inst_16033);

(statearr_16057[(11)] = inst_16032);

(statearr_16057[(12)] = inst_16031);

return statearr_16057;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16055__$1,(10),inst_16034);
} else {
if((state_val_16056 === (1))){
var inst_16007 = flakes;
var inst_16008 = cljs.core.seq.call(null,inst_16007);
var inst_16009 = cljs.core.first.call(null,inst_16008);
var inst_16010 = cljs.core.next.call(null,inst_16008);
var inst_16011 = cljs.core.PersistentVector.EMPTY;
var inst_16012 = inst_16007;
var inst_16013 = inst_16011;
var state_16055__$1 = (function (){var statearr_16058 = state_16055;
(statearr_16058[(13)] = inst_16012);

(statearr_16058[(14)] = inst_16013);

(statearr_16058[(15)] = inst_16010);

(statearr_16058[(16)] = inst_16009);

return statearr_16058;
})();
var statearr_16059_16077 = state_16055__$1;
(statearr_16059_16077[(2)] = null);

(statearr_16059_16077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16056 === (4))){
var inst_16019 = (state_16055[(8)]);
var inst_16022 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_16019);
var state_16055__$1 = state_16055;
if(inst_16022){
var statearr_16060_16078 = state_16055__$1;
(statearr_16060_16078[(1)] = (7));

} else {
var statearr_16061_16079 = state_16055__$1;
(statearr_16061_16079[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16056 === (6))){
var inst_16051 = (state_16055[(2)]);
var state_16055__$1 = state_16055;
var statearr_16062_16080 = state_16055__$1;
(statearr_16062_16080[(2)] = inst_16051);

(statearr_16062_16080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16056 === (3))){
var inst_16053 = (state_16055[(2)]);
var state_16055__$1 = state_16055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16055__$1,inst_16053);
} else {
if((state_val_16056 === (2))){
var inst_16019 = (state_16055[(8)]);
var inst_16012 = (state_16055[(13)]);
var inst_16018 = cljs.core.seq.call(null,inst_16012);
var inst_16019__$1 = cljs.core.first.call(null,inst_16018);
var inst_16020 = cljs.core.next.call(null,inst_16018);
var state_16055__$1 = (function (){var statearr_16063 = state_16055;
(statearr_16063[(17)] = inst_16020);

(statearr_16063[(8)] = inst_16019__$1);

return statearr_16063;
})();
if(cljs.core.truth_(inst_16019__$1)){
var statearr_16064_16081 = state_16055__$1;
(statearr_16064_16081[(1)] = (4));

} else {
var statearr_16065_16082 = state_16055__$1;
(statearr_16065_16082[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16056 === (9))){
var inst_16048 = (state_16055[(2)]);
var state_16055__$1 = state_16055;
var statearr_16066_16083 = state_16055__$1;
(statearr_16066_16083[(2)] = inst_16048);

(statearr_16066_16083[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16056 === (5))){
var inst_16013 = (state_16055[(14)]);
var state_16055__$1 = state_16055;
var statearr_16067_16084 = state_16055__$1;
(statearr_16067_16084[(2)] = inst_16013);

(statearr_16067_16084[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16056 === (10))){
var inst_16028 = (state_16055[(9)]);
var inst_16020 = (state_16055[(17)]);
var inst_16029 = (state_16055[(7)]);
var inst_16033 = (state_16055[(10)]);
var inst_16032 = (state_16055[(11)]);
var inst_16013 = (state_16055[(14)]);
var inst_16031 = (state_16055[(12)]);
var inst_16036 = (state_16055[(2)]);
var inst_16037 = fluree.db.util.async.throw_err.call(null,inst_16036);
var inst_16038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16039 = [inst_16028,inst_16029,inst_16037,inst_16031,inst_16032,inst_16033];
var inst_16040 = (new cljs.core.PersistentVector(null,6,(5),inst_16038,inst_16039,null));
var inst_16041 = fluree.db.flake.parts__GT_Flake.call(null,inst_16040);
var inst_16042 = cljs.core.conj.call(null,inst_16013,inst_16041);
var inst_16012 = inst_16020;
var inst_16013__$1 = inst_16042;
var state_16055__$1 = (function (){var statearr_16068 = state_16055;
(statearr_16068[(13)] = inst_16012);

(statearr_16068[(14)] = inst_16013__$1);

return statearr_16068;
})();
var statearr_16069_16085 = state_16055__$1;
(statearr_16069_16085[(2)] = null);

(statearr_16069_16085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16056 === (8))){
var inst_16020 = (state_16055[(17)]);
var inst_16019 = (state_16055[(8)]);
var inst_16013 = (state_16055[(14)]);
var inst_16045 = cljs.core.conj.call(null,inst_16013,inst_16019);
var inst_16012 = inst_16020;
var inst_16013__$1 = inst_16045;
var state_16055__$1 = (function (){var statearr_16070 = state_16055;
(statearr_16070[(13)] = inst_16012);

(statearr_16070[(14)] = inst_16013__$1);

return statearr_16070;
})();
var statearr_16071_16086 = state_16055__$1;
(statearr_16071_16086[(2)] = null);

(statearr_16071_16086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto____0 = (function (){
var statearr_16072 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16072[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto__);

(statearr_16072[(1)] = (1));

return statearr_16072;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto____1 = (function (state_16055){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_16055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e16073){var ex__2706__auto__ = e16073;
var statearr_16074_16087 = state_16055;
(statearr_16074_16087[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_16055[(4)]))){
var statearr_16075_16088 = state_16055;
(statearr_16075_16088[(1)] = cljs.core.first.call(null,(state_16055[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16089 = state_16055;
state_16055 = G__16089;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto__ = function(state_16055){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto____1.call(this,state_16055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_16076 = f__2726__auto__.call(null);
(statearr_16076[(6)] = c__2725__auto__);

return statearr_16076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__16091 = arguments.length;
switch (G__16091) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_16261){
var state_val_16262 = (state_16261[(1)]);
if((state_val_16262 === (65))){
var state_16261__$1 = state_16261;
var statearr_16263_16363 = state_16261__$1;
(statearr_16263_16363[(2)] = null);

(statearr_16263_16363[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (70))){
var inst_16256 = (state_16261[(2)]);
var _ = (function (){var statearr_16264 = state_16261;
(statearr_16264[(4)] = cljs.core.rest.call(null,(state_16261[(4)])));

return statearr_16264;
})();
var state_16261__$1 = state_16261;
var statearr_16265_16364 = state_16261__$1;
(statearr_16265_16364[(2)] = inst_16256);

(statearr_16265_16364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (62))){
var inst_16242 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16266_16365 = state_16261__$1;
(statearr_16266_16365[(2)] = inst_16242);

(statearr_16266_16365[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (7))){
var state_16261__$1 = state_16261;
var statearr_16267_16366 = state_16261__$1;
(statearr_16267_16366[(2)] = false);

(statearr_16267_16366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (59))){
var inst_16216 = (state_16261[(2)]);
var inst_16217 = fluree.db.util.async.throw_err.call(null,inst_16216);
var state_16261__$1 = state_16261;
var statearr_16268_16367 = state_16261__$1;
(statearr_16268_16367[(2)] = inst_16217);

(statearr_16268_16367[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (20))){
var state_16261__$1 = state_16261;
var statearr_16269_16368 = state_16261__$1;
(statearr_16269_16368[(2)] = null);

(statearr_16269_16368[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (58))){
var inst_16206 = (state_16261[(2)]);
var inst_16207 = fluree.db.util.async.throw_err.call(null,inst_16206);
var inst_16208 = cljs.core.take.call(null,(1),inst_16207);
var state_16261__$1 = state_16261;
var statearr_16270_16369 = state_16261__$1;
(statearr_16270_16369[(2)] = inst_16208);

(statearr_16270_16369[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (60))){
var inst_16103 = (state_16261[(7)]);
var inst_16102 = (state_16261[(8)]);
var inst_16105 = (state_16261[(9)]);
var inst_16142 = (state_16261[(10)]);
var inst_16222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16223 = [inst_16103,inst_16102,inst_16142,inst_16105];
var inst_16224 = (new cljs.core.PersistentVector(null,4,(5),inst_16222,inst_16223,null));
var inst_16225 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16224,opts);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(63),inst_16225);
} else {
if((state_val_16262 === (27))){
var inst_16153 = (state_16261[(11)]);
var inst_16142 = (state_16261[(10)]);
var inst_16153__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_16142);
var state_16261__$1 = (function (){var statearr_16271 = state_16261;
(statearr_16271[(11)] = inst_16153__$1);

return statearr_16271;
})();
if(inst_16153__$1){
var statearr_16272_16370 = state_16261__$1;
(statearr_16272_16370[(1)] = (30));

} else {
var statearr_16273_16371 = state_16261__$1;
(statearr_16273_16371[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (1))){
var state_16261__$1 = state_16261;
var statearr_16274_16372 = state_16261__$1;
(statearr_16274_16372[(2)] = null);

(statearr_16274_16372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (69))){
var inst_16248 = (state_16261[(12)]);
var state_16261__$1 = state_16261;
var statearr_16275_16373 = state_16261__$1;
(statearr_16275_16373[(2)] = inst_16248);

(statearr_16275_16373[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (24))){
var inst_16103 = (state_16261[(7)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16103)){
var statearr_16276_16374 = state_16261__$1;
(statearr_16276_16374[(1)] = (27));

} else {
var statearr_16277_16375 = state_16261__$1;
(statearr_16277_16375[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (55))){
var inst_16142 = (state_16261[(10)]);
var inst_16200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16201 = [inst_16142];
var inst_16202 = (new cljs.core.PersistentVector(null,1,(5),inst_16200,inst_16201,null));
var inst_16203 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_16204 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16202,inst_16203);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(58),inst_16204);
} else {
if((state_val_16262 === (39))){
var inst_16173 = (state_16261[(2)]);
var inst_16174 = fluree.db.util.async.throw_err.call(null,inst_16173);
var state_16261__$1 = state_16261;
var statearr_16278_16376 = state_16261__$1;
(statearr_16278_16376[(2)] = inst_16174);

(statearr_16278_16376[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (46))){
var inst_16186 = (state_16261[(13)]);
var inst_16186__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_16261__$1 = (function (){var statearr_16279 = state_16261;
(statearr_16279[(13)] = inst_16186__$1);

return statearr_16279;
})();
if(cljs.core.truth_(inst_16186__$1)){
var statearr_16280_16377 = state_16261__$1;
(statearr_16280_16377[(1)] = (49));

} else {
var statearr_16281_16378 = state_16261__$1;
(statearr_16281_16378[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (4))){
var inst_16092 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16282_16379 = state_16261__$1;
(statearr_16282_16379[(2)] = inst_16092);

(statearr_16282_16379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (54))){
var inst_16198 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16198)){
var statearr_16283_16380 = state_16261__$1;
(statearr_16283_16380[(1)] = (55));

} else {
var statearr_16284_16381 = state_16261__$1;
(statearr_16284_16381[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (15))){
var inst_16104 = (state_16261[(14)]);
var inst_16123 = fluree.db.dbproto._tag_id.call(null,db,inst_16104);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(18),inst_16123);
} else {
if((state_val_16262 === (48))){
var inst_16244 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16285_16382 = state_16261__$1;
(statearr_16285_16382[(2)] = inst_16244);

(statearr_16285_16382[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (50))){
var inst_16186 = (state_16261[(13)]);
var inst_16117 = (state_16261[(15)]);
var inst_16112 = (state_16261[(16)]);
var inst_16103 = (state_16261[(7)]);
var inst_16102 = (state_16261[(8)]);
var inst_16106 = (state_16261[(17)]);
var inst_16105 = (state_16261[(9)]);
var inst_16142 = (state_16261[(10)]);
var inst_16101 = (state_16261[(18)]);
var inst_16190 = (function (){var t = inst_16105;
var temp__5802__auto__ = inst_16186;
var p = inst_16103;
var idx_predicate_QMARK_ = inst_16106;
var o = inst_16142;
var vec__16098 = inst_16101;
var tag_predicate_QMARK_ = inst_16112;
var s = inst_16102;
var o_coerce_QMARK_ = inst_16117;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_16261__$1 = state_16261;
var statearr_16286_16383 = state_16261__$1;
(statearr_16286_16383[(2)] = inst_16190);

(statearr_16286_16383[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (21))){
var inst_16138 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16287_16384 = state_16261__$1;
(statearr_16287_16384[(2)] = inst_16138);

(statearr_16287_16384[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (31))){
var inst_16153 = (state_16261[(11)]);
var state_16261__$1 = state_16261;
var statearr_16288_16385 = state_16261__$1;
(statearr_16288_16385[(2)] = inst_16153);

(statearr_16288_16385[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (32))){
var inst_16163 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16289_16386 = state_16261__$1;
(statearr_16289_16386[(2)] = inst_16163);

(statearr_16289_16386[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (40))){
var inst_16106 = (state_16261[(17)]);
var inst_16177 = (state_16261[(19)]);
var inst_16177__$1 = cljs.core.not.call(null,inst_16106);
var state_16261__$1 = (function (){var statearr_16290 = state_16261;
(statearr_16290[(19)] = inst_16177__$1);

return statearr_16290;
})();
if(inst_16177__$1){
var statearr_16291_16387 = state_16261__$1;
(statearr_16291_16387[(1)] = (43));

} else {
var statearr_16292_16388 = state_16261__$1;
(statearr_16292_16388[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (56))){
var inst_16192 = (state_16261[(20)]);
var inst_16103 = (state_16261[(7)]);
var inst_16102 = (state_16261[(8)]);
var inst_16105 = (state_16261[(9)]);
var inst_16210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16211 = [inst_16103,inst_16102,null,inst_16105];
var inst_16212 = (new cljs.core.PersistentVector(null,4,(5),inst_16210,inst_16211,null));
var inst_16213 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_16192);
var inst_16214 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16212,inst_16213);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(59),inst_16214);
} else {
if((state_val_16262 === (33))){
var inst_16142 = (state_16261[(10)]);
var inst_16156 = cljs.core.fn_QMARK_.call(null,inst_16142);
var inst_16157 = (!(inst_16156));
var state_16261__$1 = state_16261;
var statearr_16293_16389 = state_16261__$1;
(statearr_16293_16389[(2)] = inst_16157);

(statearr_16293_16389[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (13))){
var inst_16104 = (state_16261[(14)]);
var inst_16121 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_16104);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16121)){
var statearr_16294_16390 = state_16261__$1;
(statearr_16294_16390[(1)] = (15));

} else {
var statearr_16295_16391 = state_16261__$1;
(statearr_16295_16391[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (22))){
var inst_16134 = (state_16261[(2)]);
var inst_16135 = fluree.db.util.async.throw_err.call(null,inst_16134);
var state_16261__$1 = state_16261;
var statearr_16296_16392 = state_16261__$1;
(statearr_16296_16392[(2)] = inst_16135);

(statearr_16296_16392[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (36))){
var inst_16103 = (state_16261[(7)]);
var inst_16102 = (state_16261[(8)]);
var inst_16105 = (state_16261[(9)]);
var inst_16142 = (state_16261[(10)]);
var inst_16168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16169 = [inst_16103,inst_16142,inst_16102,inst_16105];
var inst_16170 = (new cljs.core.PersistentVector(null,4,(5),inst_16168,inst_16169,null));
var inst_16171 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_16170,opts);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(39),inst_16171);
} else {
if((state_val_16262 === (41))){
var inst_16103 = (state_16261[(7)]);
var state_16261__$1 = state_16261;
var statearr_16297_16393 = state_16261__$1;
(statearr_16297_16393[(2)] = inst_16103);

(statearr_16297_16393[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (43))){
var inst_16142 = (state_16261[(10)]);
var state_16261__$1 = state_16261;
var statearr_16298_16394 = state_16261__$1;
(statearr_16298_16394[(2)] = inst_16142);

(statearr_16298_16394[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (61))){
var inst_16142 = (state_16261[(10)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16142)){
var statearr_16299_16395 = state_16261__$1;
(statearr_16299_16395[(1)] = (64));

} else {
var statearr_16300_16396 = state_16261__$1;
(statearr_16300_16396[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (29))){
var inst_16166 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16166)){
var statearr_16301_16397 = state_16261__$1;
(statearr_16301_16397[(1)] = (36));

} else {
var statearr_16302_16398 = state_16261__$1;
(statearr_16302_16398[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (44))){
var inst_16177 = (state_16261[(19)]);
var state_16261__$1 = state_16261;
var statearr_16303_16399 = state_16261__$1;
(statearr_16303_16399[(2)] = inst_16177);

(statearr_16303_16399[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (6))){
var inst_16103 = (state_16261[(7)]);
var inst_16108 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_16103);
var inst_16109 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_16108);
var state_16261__$1 = state_16261;
var statearr_16304_16400 = state_16261__$1;
(statearr_16304_16400[(2)] = inst_16109);

(statearr_16304_16400[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (28))){
var inst_16103 = (state_16261[(7)]);
var state_16261__$1 = state_16261;
var statearr_16305_16401 = state_16261__$1;
(statearr_16305_16401[(2)] = inst_16103);

(statearr_16305_16401[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (64))){
var inst_16103 = (state_16261[(7)]);
var inst_16102 = (state_16261[(8)]);
var inst_16105 = (state_16261[(9)]);
var inst_16142 = (state_16261[(10)]);
var inst_16231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16232 = [inst_16142,inst_16103,inst_16102,inst_16105];
var inst_16233 = (new cljs.core.PersistentVector(null,4,(5),inst_16231,inst_16232,null));
var inst_16234 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_16233,opts);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(67),inst_16234);
} else {
if((state_val_16262 === (51))){
var inst_16193 = (state_16261[(21)]);
var inst_16103 = (state_16261[(7)]);
var inst_16192 = (state_16261[(2)]);
var inst_16193__$1 = cljs.core._EQ_.call(null,"_id",inst_16103);
var state_16261__$1 = (function (){var statearr_16306 = state_16261;
(statearr_16306[(21)] = inst_16193__$1);

(statearr_16306[(20)] = inst_16192);

return statearr_16306;
})();
if(inst_16193__$1){
var statearr_16307_16402 = state_16261__$1;
(statearr_16307_16402[(1)] = (52));

} else {
var statearr_16308_16403 = state_16261__$1;
(statearr_16308_16403[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (25))){
var inst_16112 = (state_16261[(16)]);
var inst_16248 = (state_16261[(2)]);
var state_16261__$1 = (function (){var statearr_16309 = state_16261;
(statearr_16309[(12)] = inst_16248);

return statearr_16309;
})();
if(cljs.core.truth_(inst_16112)){
var statearr_16310_16404 = state_16261__$1;
(statearr_16310_16404[(1)] = (68));

} else {
var statearr_16311_16405 = state_16261__$1;
(statearr_16311_16405[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (34))){
var inst_16106 = (state_16261[(17)]);
var state_16261__$1 = state_16261;
var statearr_16312_16406 = state_16261__$1;
(statearr_16312_16406[(2)] = inst_16106);

(statearr_16312_16406[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (17))){
var inst_16140 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16313_16407 = state_16261__$1;
(statearr_16313_16407[(2)] = inst_16140);

(statearr_16313_16407[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (3))){
var inst_16259 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16261__$1,inst_16259);
} else {
if((state_val_16262 === (12))){
var inst_16104 = (state_16261[(14)]);
var state_16261__$1 = state_16261;
var statearr_16314_16408 = state_16261__$1;
(statearr_16314_16408[(2)] = inst_16104);

(statearr_16314_16408[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (2))){
var inst_16103 = (state_16261[(7)]);
var inst_16101 = (state_16261[(18)]);
var _ = (function (){var statearr_16315 = state_16261;
(statearr_16315[(4)] = cljs.core.cons.call(null,(5),(state_16261[(4)])));

return statearr_16315;
})();
var inst_16101__$1 = fparts;
var inst_16102 = cljs.core.nth.call(null,inst_16101__$1,(0),null);
var inst_16103__$1 = cljs.core.nth.call(null,inst_16101__$1,(1),null);
var inst_16104 = cljs.core.nth.call(null,inst_16101__$1,(2),null);
var inst_16105 = cljs.core.nth.call(null,inst_16101__$1,(3),null);
var inst_16106 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_16103__$1);
var state_16261__$1 = (function (){var statearr_16316 = state_16261;
(statearr_16316[(14)] = inst_16104);

(statearr_16316[(7)] = inst_16103__$1);

(statearr_16316[(8)] = inst_16102);

(statearr_16316[(17)] = inst_16106);

(statearr_16316[(9)] = inst_16105);

(statearr_16316[(18)] = inst_16101__$1);

return statearr_16316;
})();
if(cljs.core.truth_(inst_16103__$1)){
var statearr_16317_16409 = state_16261__$1;
(statearr_16317_16409[(1)] = (6));

} else {
var statearr_16318_16410 = state_16261__$1;
(statearr_16318_16410[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (66))){
var inst_16240 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16319_16411 = state_16261__$1;
(statearr_16319_16411[(2)] = inst_16240);

(statearr_16319_16411[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (23))){
var inst_16103 = (state_16261[(7)]);
var inst_16102 = (state_16261[(8)]);
var inst_16105 = (state_16261[(9)]);
var inst_16142 = (state_16261[(10)]);
var inst_16144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16145 = [inst_16102,inst_16103,inst_16142,inst_16105];
var inst_16146 = (new cljs.core.PersistentVector(null,4,(5),inst_16144,inst_16145,null));
var inst_16147 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16146,opts);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(26),inst_16147);
} else {
if((state_val_16262 === (47))){
var inst_16103 = (state_16261[(7)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16103)){
var statearr_16320_16412 = state_16261__$1;
(statearr_16320_16412[(1)] = (60));

} else {
var statearr_16321_16413 = state_16261__$1;
(statearr_16321_16413[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (35))){
var inst_16160 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16322_16414 = state_16261__$1;
(statearr_16322_16414[(2)] = inst_16160);

(statearr_16322_16414[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (19))){
var inst_16104 = (state_16261[(14)]);
var inst_16103 = (state_16261[(7)]);
var inst_16130 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16103);
var inst_16131 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16130),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16104)].join('');
var inst_16132 = fluree.db.dbproto._tag_id.call(null,db,inst_16131);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(22),inst_16132);
} else {
if((state_val_16262 === (57))){
var inst_16219 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16323_16415 = state_16261__$1;
(statearr_16323_16415[(2)] = inst_16219);

(statearr_16323_16415[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (68))){
var inst_16248 = (state_16261[(12)]);
var inst_16250 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_16248);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16261__$1,(71),inst_16250);
} else {
if((state_val_16262 === (11))){
var inst_16117 = (state_16261[(15)]);
var inst_16117__$1 = (state_16261[(2)]);
var inst_16118 = cljs.core.not.call(null,inst_16117__$1);
var state_16261__$1 = (function (){var statearr_16325 = state_16261;
(statearr_16325[(15)] = inst_16117__$1);

return statearr_16325;
})();
if(inst_16118){
var statearr_16326_16416 = state_16261__$1;
(statearr_16326_16416[(1)] = (12));

} else {
var statearr_16327_16417 = state_16261__$1;
(statearr_16327_16417[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (9))){
var inst_16104 = (state_16261[(14)]);
var inst_16114 = typeof inst_16104 === 'string';
var state_16261__$1 = state_16261;
var statearr_16328_16418 = state_16261__$1;
(statearr_16328_16418[(2)] = inst_16114);

(statearr_16328_16418[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (5))){
var _ = (function (){var statearr_16329 = state_16261;
(statearr_16329[(4)] = cljs.core.rest.call(null,(state_16261[(4)])));

return statearr_16329;
})();
var state_16261__$1 = state_16261;
var ex16324 = (state_16261__$1[(2)]);
var statearr_16330_16419 = state_16261__$1;
(statearr_16330_16419[(5)] = ex16324);


if((ex16324 instanceof Error)){
var statearr_16331_16420 = state_16261__$1;
(statearr_16331_16420[(1)] = (4));

(statearr_16331_16420[(5)] = null);

} else {
throw ex16324;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (14))){
var inst_16102 = (state_16261[(8)]);
var inst_16142 = (state_16261[(2)]);
var state_16261__$1 = (function (){var statearr_16332 = state_16261;
(statearr_16332[(10)] = inst_16142);

return statearr_16332;
})();
if(cljs.core.truth_(inst_16102)){
var statearr_16333_16421 = state_16261__$1;
(statearr_16333_16421[(1)] = (23));

} else {
var statearr_16334_16422 = state_16261__$1;
(statearr_16334_16422[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (45))){
var inst_16181 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16335_16423 = state_16261__$1;
(statearr_16335_16423[(2)] = inst_16181);

(statearr_16335_16423[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (53))){
var inst_16193 = (state_16261[(21)]);
var state_16261__$1 = state_16261;
var statearr_16336_16424 = state_16261__$1;
(statearr_16336_16424[(2)] = inst_16193);

(statearr_16336_16424[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (26))){
var inst_16149 = (state_16261[(2)]);
var inst_16150 = fluree.db.util.async.throw_err.call(null,inst_16149);
var state_16261__$1 = state_16261;
var statearr_16337_16425 = state_16261__$1;
(statearr_16337_16425[(2)] = inst_16150);

(statearr_16337_16425[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (16))){
var inst_16104 = (state_16261[(14)]);
var inst_16128 = typeof inst_16104 === 'string';
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16128)){
var statearr_16338_16426 = state_16261__$1;
(statearr_16338_16426[(1)] = (19));

} else {
var statearr_16339_16427 = state_16261__$1;
(statearr_16339_16427[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (38))){
var inst_16246 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16340_16428 = state_16261__$1;
(statearr_16340_16428[(2)] = inst_16246);

(statearr_16340_16428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (30))){
var inst_16106 = (state_16261[(17)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16106)){
var statearr_16341_16429 = state_16261__$1;
(statearr_16341_16429[(1)] = (33));

} else {
var statearr_16342_16430 = state_16261__$1;
(statearr_16342_16430[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (10))){
var inst_16112 = (state_16261[(16)]);
var state_16261__$1 = state_16261;
var statearr_16343_16431 = state_16261__$1;
(statearr_16343_16431[(2)] = inst_16112);

(statearr_16343_16431[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (18))){
var inst_16125 = (state_16261[(2)]);
var inst_16126 = fluree.db.util.async.throw_err.call(null,inst_16125);
var state_16261__$1 = state_16261;
var statearr_16344_16432 = state_16261__$1;
(statearr_16344_16432[(2)] = inst_16126);

(statearr_16344_16432[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (52))){
var inst_16142 = (state_16261[(10)]);
var inst_16195 = cljs.core.int_QMARK_.call(null,inst_16142);
var state_16261__$1 = state_16261;
var statearr_16345_16433 = state_16261__$1;
(statearr_16345_16433[(2)] = inst_16195);

(statearr_16345_16433[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (67))){
var inst_16236 = (state_16261[(2)]);
var inst_16237 = fluree.db.util.async.throw_err.call(null,inst_16236);
var state_16261__$1 = state_16261;
var statearr_16346_16434 = state_16261__$1;
(statearr_16346_16434[(2)] = inst_16237);

(statearr_16346_16434[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (71))){
var inst_16252 = (state_16261[(2)]);
var inst_16253 = fluree.db.util.async.throw_err.call(null,inst_16252);
var state_16261__$1 = state_16261;
var statearr_16347_16435 = state_16261__$1;
(statearr_16347_16435[(2)] = inst_16253);

(statearr_16347_16435[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (42))){
var inst_16184 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16184)){
var statearr_16348_16436 = state_16261__$1;
(statearr_16348_16436[(1)] = (46));

} else {
var statearr_16349_16437 = state_16261__$1;
(statearr_16349_16437[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (37))){
var inst_16103 = (state_16261[(7)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16103)){
var statearr_16350_16438 = state_16261__$1;
(statearr_16350_16438[(1)] = (40));

} else {
var statearr_16351_16439 = state_16261__$1;
(statearr_16351_16439[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (63))){
var inst_16227 = (state_16261[(2)]);
var inst_16228 = fluree.db.util.async.throw_err.call(null,inst_16227);
var state_16261__$1 = state_16261;
var statearr_16352_16440 = state_16261__$1;
(statearr_16352_16440[(2)] = inst_16228);

(statearr_16352_16440[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (8))){
var inst_16112 = (state_16261[(16)]);
var inst_16112__$1 = (state_16261[(2)]);
var state_16261__$1 = (function (){var statearr_16353 = state_16261;
(statearr_16353[(16)] = inst_16112__$1);

return statearr_16353;
})();
if(cljs.core.truth_(inst_16112__$1)){
var statearr_16354_16441 = state_16261__$1;
(statearr_16354_16441[(1)] = (9));

} else {
var statearr_16355_16442 = state_16261__$1;
(statearr_16355_16442[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (49))){
var inst_16186 = (state_16261[(13)]);
var inst_16117 = (state_16261[(15)]);
var inst_16112 = (state_16261[(16)]);
var inst_16103 = (state_16261[(7)]);
var inst_16102 = (state_16261[(8)]);
var inst_16106 = (state_16261[(17)]);
var inst_16105 = (state_16261[(9)]);
var inst_16142 = (state_16261[(10)]);
var inst_16101 = (state_16261[(18)]);
var inst_16188 = (function (){var obj_fn = inst_16186;
var t = inst_16105;
var temp__5802__auto__ = inst_16186;
var p = inst_16103;
var idx_predicate_QMARK_ = inst_16106;
var o = inst_16142;
var vec__16098 = inst_16101;
var tag_predicate_QMARK_ = inst_16112;
var s = inst_16102;
var o_coerce_QMARK_ = inst_16117;
return (function (x){
var and__5043__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_16261__$1 = state_16261;
var statearr_16356_16443 = state_16261__$1;
(statearr_16356_16443[(2)] = inst_16188);

(statearr_16356_16443[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2703__auto__ = null;
var fluree$db$query$range$state_machine__2703__auto____0 = (function (){
var statearr_16357 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16357[(0)] = fluree$db$query$range$state_machine__2703__auto__);

(statearr_16357[(1)] = (1));

return statearr_16357;
});
var fluree$db$query$range$state_machine__2703__auto____1 = (function (state_16261){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_16261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e16358){var ex__2706__auto__ = e16358;
var statearr_16359_16444 = state_16261;
(statearr_16359_16444[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_16261[(4)]))){
var statearr_16360_16445 = state_16261;
(statearr_16360_16445[(1)] = cljs.core.first.call(null,(state_16261[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16446 = state_16261;
state_16261 = G__16446;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2703__auto__ = function(state_16261){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2703__auto____1.call(this,state_16261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2703__auto____0;
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2703__auto____1;
return fluree$db$query$range$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_16361 = f__2726__auto__.call(null);
(statearr_16361[(6)] = c__2725__auto__);

return statearr_16361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__16448 = arguments.length;
switch (G__16448) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_16483){
var state_val_16484 = (state_16483[(1)]);
if((state_val_16484 === (7))){
var inst_16470 = cljs.core.pr_str.call(null,name);
var inst_16471 = ["Invalid collection name: ",inst_16470].join('');
var inst_16472 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16473 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_16474 = cljs.core.PersistentHashMap.fromArrays(inst_16472,inst_16473);
var inst_16475 = cljs.core.ex_info.call(null,inst_16471,inst_16474);
var inst_16476 = (function(){throw inst_16475})();
var state_16483__$1 = state_16483;
var statearr_16485_16505 = state_16483__$1;
(statearr_16485_16505[(2)] = inst_16476);

(statearr_16485_16505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16484 === (1))){
var state_16483__$1 = state_16483;
var statearr_16486_16506 = state_16483__$1;
(statearr_16486_16506[(2)] = null);

(statearr_16486_16506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16484 === (4))){
var inst_16449 = (state_16483[(2)]);
var state_16483__$1 = state_16483;
var statearr_16487_16507 = state_16483__$1;
(statearr_16487_16507[(2)] = inst_16449);

(statearr_16487_16507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16484 === (6))){
var inst_16455 = (state_16483[(7)]);
var inst_16457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16458 = fluree.db.flake.max_subject_id.call(null,inst_16455);
var inst_16459 = [inst_16458];
var inst_16460 = (new cljs.core.PersistentVector(null,1,(5),inst_16457,inst_16459,null));
var inst_16461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16462 = fluree.db.flake.min_subject_id.call(null,inst_16455);
var inst_16463 = [inst_16462];
var inst_16464 = (new cljs.core.PersistentVector(null,1,(5),inst_16461,inst_16463,null));
var inst_16465 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16460,cljs.core._LT__EQ_,inst_16464,opts);
var state_16483__$1 = state_16483;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16483__$1,(9),inst_16465);
} else {
if((state_val_16484 === (3))){
var inst_16481 = (state_16483[(2)]);
var state_16483__$1 = state_16483;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16483__$1,inst_16481);
} else {
if((state_val_16484 === (2))){
var inst_16455 = (state_16483[(7)]);
var _ = (function (){var statearr_16489 = state_16483;
(statearr_16489[(4)] = cljs.core.cons.call(null,(5),(state_16483[(4)])));

return statearr_16489;
})();
var inst_16455__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_16483__$1 = (function (){var statearr_16490 = state_16483;
(statearr_16490[(7)] = inst_16455__$1);

return statearr_16490;
})();
if(cljs.core.truth_(inst_16455__$1)){
var statearr_16491_16508 = state_16483__$1;
(statearr_16491_16508[(1)] = (6));

} else {
var statearr_16492_16509 = state_16483__$1;
(statearr_16492_16509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16484 === (9))){
var inst_16467 = (state_16483[(2)]);
var inst_16468 = fluree.db.util.async.throw_err.call(null,inst_16467);
var state_16483__$1 = state_16483;
var statearr_16493_16510 = state_16483__$1;
(statearr_16493_16510[(2)] = inst_16468);

(statearr_16493_16510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16484 === (5))){
var _ = (function (){var statearr_16494 = state_16483;
(statearr_16494[(4)] = cljs.core.rest.call(null,(state_16483[(4)])));

return statearr_16494;
})();
var state_16483__$1 = state_16483;
var ex16488 = (state_16483__$1[(2)]);
var statearr_16495_16511 = state_16483__$1;
(statearr_16495_16511[(5)] = ex16488);


var statearr_16496_16512 = state_16483__$1;
(statearr_16496_16512[(1)] = (4));

(statearr_16496_16512[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16484 === (8))){
var inst_16478 = (state_16483[(2)]);
var _ = (function (){var statearr_16497 = state_16483;
(statearr_16497[(4)] = cljs.core.rest.call(null,(state_16483[(4)])));

return statearr_16497;
})();
var state_16483__$1 = state_16483;
var statearr_16498_16513 = state_16483__$1;
(statearr_16498_16513[(2)] = inst_16478);

(statearr_16498_16513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2703__auto__ = null;
var fluree$db$query$range$state_machine__2703__auto____0 = (function (){
var statearr_16499 = [null,null,null,null,null,null,null,null];
(statearr_16499[(0)] = fluree$db$query$range$state_machine__2703__auto__);

(statearr_16499[(1)] = (1));

return statearr_16499;
});
var fluree$db$query$range$state_machine__2703__auto____1 = (function (state_16483){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_16483);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e16500){var ex__2706__auto__ = e16500;
var statearr_16501_16514 = state_16483;
(statearr_16501_16514[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_16483[(4)]))){
var statearr_16502_16515 = state_16483;
(statearr_16502_16515[(1)] = cljs.core.first.call(null,(state_16483[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16516 = state_16483;
state_16483 = G__16516;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2703__auto__ = function(state_16483){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2703__auto____1.call(this,state_16483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2703__auto____0;
fluree$db$query$range$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2703__auto____1;
return fluree$db$query$range$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_16503 = f__2726__auto__.call(null);
(statearr_16503[(6)] = c__2725__auto__);

return statearr_16503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__16520 = flakes;
var vec__16521 = G__16520;
var seq__16522 = cljs.core.seq.call(null,vec__16521);
var first__16523 = cljs.core.first.call(null,seq__16522);
var seq__16522__$1 = cljs.core.next.call(null,seq__16522);
var flake_SINGLEQUOTE_ = first__16523;
var r = seq__16522__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16520__$1 = G__16520;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16529 = G__16520__$1;
var seq__16530 = cljs.core.seq.call(null,vec__16529);
var first__16531 = cljs.core.first.call(null,seq__16530);
var seq__16530__$1 = cljs.core.next.call(null,seq__16530);
var flake_SINGLEQUOTE___$1 = first__16531;
var r__$1 = seq__16530__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e16533){var e = e16533;
return null;
}})();
var map__16532 = cmd_map;
var map__16532__$1 = cljs.core.__destructure_map.call(null,map__16532);
var type = cljs.core.get.call(null,map__16532__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__16532__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__16532__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__16532__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__16532__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__16532__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16534 = r__$1;
var G__16535 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__16520__$1 = G__16534;
result_STAR___$1 = G__16535;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16544 = blocks;
var vec__16545 = G__16544;
var seq__16546 = cljs.core.seq.call(null,vec__16545);
var first__16547 = cljs.core.first.call(null,seq__16546);
var seq__16546__$1 = cljs.core.next.call(null,seq__16546);
var block_SINGLEQUOTE_ = first__16547;
var r = seq__16546__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16544__$1 = G__16544;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16552 = G__16544__$1;
var seq__16553 = cljs.core.seq.call(null,vec__16552);
var first__16554 = cljs.core.first.call(null,seq__16553);
var seq__16553__$1 = cljs.core.next.call(null,seq__16553);
var block_SINGLEQUOTE___$1 = first__16554;
var r__$1 = seq__16553__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16555 = block_SINGLEQUOTE___$1;
var map__16555__$1 = cljs.core.__destructure_map.call(null,map__16555);
var block = cljs.core.get.call(null,map__16555__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__16555__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__16555__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16536_SHARP_){
var f = p1__16536_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16537_SHARP_){
var f = p1__16537_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,hash,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16538_SHARP_){
var f = p1__16538_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,hash,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,hash,instant,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16539_SHARP_){
var f = p1__16539_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,hash,instant,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16540_SHARP_){
return cljs.core._EQ_.call(null,p1__16540_SHARP_.p,(106));
});})(G__16544__$1,result_STAR___$1,map__16555,map__16555__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16552,seq__16553,first__16554,seq__16553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16544,vec__16545,seq__16546,first__16547,seq__16546__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__16556 = r__$1;
var G__16557 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16544__$1 = G__16556;
result_STAR___$1 = G__16557;
continue;
}
break;
}
});
