// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_17977){
var state_val_17978 = (state_17977[(1)]);
if((state_val_17978 === (7))){
var inst_17966 = (state_17977[(7)]);
var inst_17968 = fluree.db.storage.core.serde.call(null,conn);
var inst_17969 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17968,inst_17966);
var state_17977__$1 = state_17977;
var statearr_17979_17998 = state_17977__$1;
(statearr_17979_17998[(2)] = inst_17969);

(statearr_17979_17998[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17978 === (1))){
var state_17977__$1 = state_17977;
var statearr_17980_17999 = state_17977__$1;
(statearr_17980_17999[(2)] = null);

(statearr_17980_17999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17978 === (4))){
var inst_17956 = (state_17977[(2)]);
var state_17977__$1 = state_17977;
var statearr_17981_18000 = state_17977__$1;
(statearr_17981_18000[(2)] = inst_17956);

(statearr_17981_18000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17978 === (6))){
var inst_17966 = (state_17977[(7)]);
var inst_17965 = (state_17977[(2)]);
var inst_17966__$1 = fluree.db.util.async.throw_err.call(null,inst_17965);
var state_17977__$1 = (function (){var statearr_17982 = state_17977;
(statearr_17982[(7)] = inst_17966__$1);

return statearr_17982;
})();
if(cljs.core.truth_(inst_17966__$1)){
var statearr_17983_18001 = state_17977__$1;
(statearr_17983_18001[(1)] = (7));

} else {
var statearr_17984_18002 = state_17977__$1;
(statearr_17984_18002[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17978 === (3))){
var inst_17975 = (state_17977[(2)]);
var state_17977__$1 = state_17977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17977__$1,inst_17975);
} else {
if((state_val_17978 === (2))){
var _ = (function (){var statearr_17986 = state_17977;
(statearr_17986[(4)] = cljs.core.cons.call(null,(5),(state_17977[(4)])));

return statearr_17986;
})();
var inst_17962 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17963 = fluree.db.storage.core.storage_read.call(null,conn,inst_17962);
var state_17977__$1 = state_17977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17977__$1,(6),inst_17963);
} else {
if((state_val_17978 === (9))){
var inst_17972 = (state_17977[(2)]);
var _ = (function (){var statearr_17987 = state_17977;
(statearr_17987[(4)] = cljs.core.rest.call(null,(state_17977[(4)])));

return statearr_17987;
})();
var state_17977__$1 = state_17977;
var statearr_17988_18003 = state_17977__$1;
(statearr_17988_18003[(2)] = inst_17972);

(statearr_17988_18003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17978 === (5))){
var _ = (function (){var statearr_17989 = state_17977;
(statearr_17989[(4)] = cljs.core.rest.call(null,(state_17977[(4)])));

return statearr_17989;
})();
var state_17977__$1 = state_17977;
var ex17985 = (state_17977__$1[(2)]);
var statearr_17990_18004 = state_17977__$1;
(statearr_17990_18004[(5)] = ex17985);


if((ex17985 instanceof Error)){
var statearr_17991_18005 = state_17977__$1;
(statearr_17991_18005[(1)] = (4));

(statearr_17991_18005[(5)] = null);

} else {
throw ex17985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17978 === (8))){
var state_17977__$1 = state_17977;
var statearr_17992_18006 = state_17977__$1;
(statearr_17992_18006[(2)] = null);

(statearr_17992_18006[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2703__auto____0 = (function (){
var statearr_17993 = [null,null,null,null,null,null,null,null];
(statearr_17993[(0)] = fluree$db$storage$core$read_block_$_state_machine__2703__auto__);

(statearr_17993[(1)] = (1));

return statearr_17993;
});
var fluree$db$storage$core$read_block_$_state_machine__2703__auto____1 = (function (state_17977){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_17977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e17994){var ex__2706__auto__ = e17994;
var statearr_17995_18007 = state_17977;
(statearr_17995_18007[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_17977[(4)]))){
var statearr_17996_18008 = state_17977;
(statearr_17996_18008[(1)] = cljs.core.first.call(null,(state_17977[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18009 = state_17977;
state_17977 = G__18009;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2703__auto__ = function(state_17977){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2703__auto____1.call(this,state_17977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2703__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2703__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_17997 = f__2726__auto__.call(null);
(statearr_17997[(6)] = c__2725__auto__);

return statearr_17997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18032){
var state_val_18033 = (state_18032[(1)]);
if((state_val_18033 === (7))){
var inst_18021 = (state_18032[(7)]);
var inst_18023 = fluree.db.storage.core.serde.call(null,conn);
var inst_18024 = fluree.db.serde.protocol._deserialize_block.call(null,inst_18023,inst_18021);
var state_18032__$1 = state_18032;
var statearr_18034_18053 = state_18032__$1;
(statearr_18034_18053[(2)] = inst_18024);

(statearr_18034_18053[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18033 === (1))){
var state_18032__$1 = state_18032;
var statearr_18035_18054 = state_18032__$1;
(statearr_18035_18054[(2)] = null);

(statearr_18035_18054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18033 === (4))){
var inst_18010 = (state_18032[(2)]);
var state_18032__$1 = state_18032;
var statearr_18036_18055 = state_18032__$1;
(statearr_18036_18055[(2)] = inst_18010);

(statearr_18036_18055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18033 === (6))){
var inst_18021 = (state_18032[(7)]);
var inst_18020 = (state_18032[(2)]);
var inst_18021__$1 = fluree.db.util.async.throw_err.call(null,inst_18020);
var state_18032__$1 = (function (){var statearr_18037 = state_18032;
(statearr_18037[(7)] = inst_18021__$1);

return statearr_18037;
})();
if(cljs.core.truth_(inst_18021__$1)){
var statearr_18038_18056 = state_18032__$1;
(statearr_18038_18056[(1)] = (7));

} else {
var statearr_18039_18057 = state_18032__$1;
(statearr_18039_18057[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18033 === (3))){
var inst_18030 = (state_18032[(2)]);
var state_18032__$1 = state_18032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18032__$1,inst_18030);
} else {
if((state_val_18033 === (2))){
var _ = (function (){var statearr_18041 = state_18032;
(statearr_18041[(4)] = cljs.core.cons.call(null,(5),(state_18032[(4)])));

return statearr_18041;
})();
var inst_18016 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_18017 = [inst_18016,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18018 = fluree.db.storage.core.storage_read.call(null,conn,inst_18017);
var state_18032__$1 = state_18032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18032__$1,(6),inst_18018);
} else {
if((state_val_18033 === (9))){
var inst_18027 = (state_18032[(2)]);
var _ = (function (){var statearr_18042 = state_18032;
(statearr_18042[(4)] = cljs.core.rest.call(null,(state_18032[(4)])));

return statearr_18042;
})();
var state_18032__$1 = state_18032;
var statearr_18043_18058 = state_18032__$1;
(statearr_18043_18058[(2)] = inst_18027);

(statearr_18043_18058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18033 === (5))){
var _ = (function (){var statearr_18044 = state_18032;
(statearr_18044[(4)] = cljs.core.rest.call(null,(state_18032[(4)])));

return statearr_18044;
})();
var state_18032__$1 = state_18032;
var ex18040 = (state_18032__$1[(2)]);
var statearr_18045_18059 = state_18032__$1;
(statearr_18045_18059[(5)] = ex18040);


if((ex18040 instanceof Error)){
var statearr_18046_18060 = state_18032__$1;
(statearr_18046_18060[(1)] = (4));

(statearr_18046_18060[(5)] = null);

} else {
throw ex18040;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18033 === (8))){
var state_18032__$1 = state_18032;
var statearr_18047_18061 = state_18032__$1;
(statearr_18047_18061[(2)] = null);

(statearr_18047_18061[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2703__auto____0 = (function (){
var statearr_18048 = [null,null,null,null,null,null,null,null];
(statearr_18048[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2703__auto__);

(statearr_18048[(1)] = (1));

return statearr_18048;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2703__auto____1 = (function (state_18032){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18049){var ex__2706__auto__ = e18049;
var statearr_18050_18062 = state_18032;
(statearr_18050_18062[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18032[(4)]))){
var statearr_18051_18063 = state_18032;
(statearr_18051_18063[(1)] = cljs.core.first.call(null,(state_18032[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18064 = state_18032;
state_18032 = G__18064;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2703__auto__ = function(state_18032){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2703__auto____1.call(this,state_18032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2703__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2703__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18052 = f__2726__auto__.call(null);
(statearr_18052[(6)] = c__2725__auto__);

return statearr_18052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18088){
var state_val_18089 = (state_18088[(1)]);
if((state_val_18089 === (1))){
var state_18088__$1 = state_18088;
var statearr_18090_18104 = state_18088__$1;
(statearr_18090_18104[(2)] = null);

(statearr_18090_18104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (2))){
var _ = (function (){var statearr_18091 = state_18088;
(statearr_18091[(4)] = cljs.core.cons.call(null,(5),(state_18088[(4)])));

return statearr_18091;
})();
var inst_18071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18072 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18073 = (new cljs.core.PersistentVector(null,3,(5),inst_18071,inst_18072,null));
var inst_18074 = cljs.core.select_keys.call(null,block_data,inst_18073);
var inst_18075 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18074);
var inst_18076 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_18075);
var inst_18077 = [inst_18076,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18078 = fluree.db.storage.core.serde.call(null,conn);
var inst_18079 = fluree.db.serde.protocol._serialize_block.call(null,inst_18078,inst_18074);
var inst_18080 = fluree.db.storage.core.storage_write.call(null,conn,inst_18077,inst_18079);
var state_18088__$1 = state_18088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18088__$1,(6),inst_18080);
} else {
if((state_val_18089 === (3))){
var inst_18086 = (state_18088[(2)]);
var state_18088__$1 = state_18088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18088__$1,inst_18086);
} else {
if((state_val_18089 === (4))){
var inst_18065 = (state_18088[(2)]);
var state_18088__$1 = state_18088;
var statearr_18093_18105 = state_18088__$1;
(statearr_18093_18105[(2)] = inst_18065);

(statearr_18093_18105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (5))){
var _ = (function (){var statearr_18094 = state_18088;
(statearr_18094[(4)] = cljs.core.rest.call(null,(state_18088[(4)])));

return statearr_18094;
})();
var state_18088__$1 = state_18088;
var ex18092 = (state_18088__$1[(2)]);
var statearr_18095_18106 = state_18088__$1;
(statearr_18095_18106[(5)] = ex18092);


if((ex18092 instanceof Error)){
var statearr_18096_18107 = state_18088__$1;
(statearr_18096_18107[(1)] = (4));

(statearr_18096_18107[(5)] = null);

} else {
throw ex18092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (6))){
var inst_18082 = (state_18088[(2)]);
var inst_18083 = fluree.db.util.async.throw_err.call(null,inst_18082);
var _ = (function (){var statearr_18097 = state_18088;
(statearr_18097[(4)] = cljs.core.rest.call(null,(state_18088[(4)])));

return statearr_18097;
})();
var state_18088__$1 = state_18088;
var statearr_18098_18108 = state_18088__$1;
(statearr_18098_18108[(2)] = inst_18083);

(statearr_18098_18108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2703__auto____0 = (function (){
var statearr_18099 = [null,null,null,null,null,null,null];
(statearr_18099[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2703__auto__);

(statearr_18099[(1)] = (1));

return statearr_18099;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2703__auto____1 = (function (state_18088){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18100){var ex__2706__auto__ = e18100;
var statearr_18101_18109 = state_18088;
(statearr_18101_18109[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18088[(4)]))){
var statearr_18102_18110 = state_18088;
(statearr_18102_18110[(1)] = cljs.core.first.call(null,(state_18088[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18111 = state_18088;
state_18088 = G__18111;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2703__auto__ = function(state_18088){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2703__auto____1.call(this,state_18088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2703__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2703__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18103 = f__2726__auto__.call(null);
(statearr_18103[(6)] = c__2725__auto__);

return statearr_18103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18134){
var state_val_18135 = (state_18134[(1)]);
if((state_val_18135 === (1))){
var state_18134__$1 = state_18134;
var statearr_18136_18150 = state_18134__$1;
(statearr_18136_18150[(2)] = null);

(statearr_18136_18150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18135 === (2))){
var _ = (function (){var statearr_18137 = state_18134;
(statearr_18137[(4)] = cljs.core.cons.call(null,(5),(state_18134[(4)])));

return statearr_18137;
})();
var inst_18118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18119 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18120 = (new cljs.core.PersistentVector(null,3,(5),inst_18118,inst_18119,null));
var inst_18121 = cljs.core.select_keys.call(null,block_data,inst_18120);
var inst_18122 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18121);
var inst_18123 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_18122);
var inst_18124 = fluree.db.storage.core.serde.call(null,conn);
var inst_18125 = fluree.db.serde.protocol._serialize_block.call(null,inst_18124,inst_18121);
var inst_18126 = fluree.db.storage.core.storage_write.call(null,conn,inst_18123,inst_18125);
var state_18134__$1 = state_18134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18134__$1,(6),inst_18126);
} else {
if((state_val_18135 === (3))){
var inst_18132 = (state_18134[(2)]);
var state_18134__$1 = state_18134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18134__$1,inst_18132);
} else {
if((state_val_18135 === (4))){
var inst_18112 = (state_18134[(2)]);
var state_18134__$1 = state_18134;
var statearr_18139_18151 = state_18134__$1;
(statearr_18139_18151[(2)] = inst_18112);

(statearr_18139_18151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18135 === (5))){
var _ = (function (){var statearr_18140 = state_18134;
(statearr_18140[(4)] = cljs.core.rest.call(null,(state_18134[(4)])));

return statearr_18140;
})();
var state_18134__$1 = state_18134;
var ex18138 = (state_18134__$1[(2)]);
var statearr_18141_18152 = state_18134__$1;
(statearr_18141_18152[(5)] = ex18138);


if((ex18138 instanceof Error)){
var statearr_18142_18153 = state_18134__$1;
(statearr_18142_18153[(1)] = (4));

(statearr_18142_18153[(5)] = null);

} else {
throw ex18138;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18135 === (6))){
var inst_18128 = (state_18134[(2)]);
var inst_18129 = fluree.db.util.async.throw_err.call(null,inst_18128);
var _ = (function (){var statearr_18143 = state_18134;
(statearr_18143[(4)] = cljs.core.rest.call(null,(state_18134[(4)])));

return statearr_18143;
})();
var state_18134__$1 = state_18134;
var statearr_18144_18154 = state_18134__$1;
(statearr_18144_18154[(2)] = inst_18129);

(statearr_18144_18154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2703__auto____0 = (function (){
var statearr_18145 = [null,null,null,null,null,null,null];
(statearr_18145[(0)] = fluree$db$storage$core$write_block_$_state_machine__2703__auto__);

(statearr_18145[(1)] = (1));

return statearr_18145;
});
var fluree$db$storage$core$write_block_$_state_machine__2703__auto____1 = (function (state_18134){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18146){var ex__2706__auto__ = e18146;
var statearr_18147_18155 = state_18134;
(statearr_18147_18155[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18134[(4)]))){
var statearr_18148_18156 = state_18134;
(statearr_18148_18156[(1)] = cljs.core.first.call(null,(state_18134[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18157 = state_18134;
state_18134 = G__18157;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2703__auto__ = function(state_18134){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2703__auto____1.call(this,state_18134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2703__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2703__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18149 = f__2726__auto__.call(null);
(statearr_18149[(6)] = c__2725__auto__);

return statearr_18149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18177){
var state_val_18178 = (state_18177[(1)]);
if((state_val_18178 === (1))){
var state_18177__$1 = state_18177;
var statearr_18179_18193 = state_18177__$1;
(statearr_18179_18193[(2)] = null);

(statearr_18179_18193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (2))){
var _ = (function (){var statearr_18180 = state_18177;
(statearr_18180[(4)] = cljs.core.cons.call(null,(5),(state_18177[(4)])));

return statearr_18180;
})();
var inst_18164 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18165 = [history,next_his_key];
var inst_18166 = cljs.core.PersistentHashMap.fromArrays(inst_18164,inst_18165);
var inst_18167 = fluree.db.storage.core.serde.call(null,conn);
var inst_18168 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_18167,inst_18166);
var inst_18169 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_18168);
var state_18177__$1 = state_18177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18177__$1,(6),inst_18169);
} else {
if((state_val_18178 === (3))){
var inst_18175 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18177__$1,inst_18175);
} else {
if((state_val_18178 === (4))){
var inst_18158 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
var statearr_18182_18194 = state_18177__$1;
(statearr_18182_18194[(2)] = inst_18158);

(statearr_18182_18194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (5))){
var _ = (function (){var statearr_18183 = state_18177;
(statearr_18183[(4)] = cljs.core.rest.call(null,(state_18177[(4)])));

return statearr_18183;
})();
var state_18177__$1 = state_18177;
var ex18181 = (state_18177__$1[(2)]);
var statearr_18184_18195 = state_18177__$1;
(statearr_18184_18195[(5)] = ex18181);


if((ex18181 instanceof Error)){
var statearr_18185_18196 = state_18177__$1;
(statearr_18185_18196[(1)] = (4));

(statearr_18185_18196[(5)] = null);

} else {
throw ex18181;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (6))){
var inst_18171 = (state_18177[(2)]);
var inst_18172 = fluree.db.util.async.throw_err.call(null,inst_18171);
var _ = (function (){var statearr_18186 = state_18177;
(statearr_18186[(4)] = cljs.core.rest.call(null,(state_18177[(4)])));

return statearr_18186;
})();
var state_18177__$1 = state_18177;
var statearr_18187_18197 = state_18177__$1;
(statearr_18187_18197[(2)] = inst_18172);

(statearr_18187_18197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2703__auto____0 = (function (){
var statearr_18188 = [null,null,null,null,null,null,null];
(statearr_18188[(0)] = fluree$db$storage$core$write_history_$_state_machine__2703__auto__);

(statearr_18188[(1)] = (1));

return statearr_18188;
});
var fluree$db$storage$core$write_history_$_state_machine__2703__auto____1 = (function (state_18177){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18189){var ex__2706__auto__ = e18189;
var statearr_18190_18198 = state_18177;
(statearr_18190_18198[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18177[(4)]))){
var statearr_18191_18199 = state_18177;
(statearr_18191_18199[(1)] = cljs.core.first.call(null,(state_18177[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18200 = state_18177;
state_18177 = G__18200;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2703__auto__ = function(state_18177){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2703__auto____1.call(this,state_18177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2703__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2703__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18192 = f__2726__auto__.call(null);
(statearr_18192[(6)] = c__2725__auto__);

return statearr_18192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18226){
var state_val_18227 = (state_18226[(1)]);
if((state_val_18227 === (1))){
var state_18226__$1 = state_18226;
var statearr_18228_18245 = state_18226__$1;
(statearr_18228_18245[(2)] = null);

(statearr_18228_18245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18227 === (2))){
var inst_18207 = (state_18226[(7)]);
var _ = (function (){var statearr_18229 = state_18226;
(statearr_18229[(4)] = cljs.core.cons.call(null,(5),(state_18226[(4)])));

return statearr_18229;
})();
var inst_18207__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_18208 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18207__$1),"-his"].join('');
var inst_18209 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18210 = [flakes,inst_18208];
var inst_18211 = cljs.core.PersistentHashMap.fromArrays(inst_18209,inst_18210);
var inst_18212 = fluree.db.storage.core.serde.call(null,conn);
var inst_18213 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_18212,inst_18211);
var inst_18214 = fluree.db.storage.core.write_history.call(null,conn,history,inst_18208,null);
var inst_18215 = fluree.db.storage.core.storage_write.call(null,conn,inst_18207__$1,inst_18213);
var state_18226__$1 = (function (){var statearr_18230 = state_18226;
(statearr_18230[(7)] = inst_18207__$1);

(statearr_18230[(8)] = inst_18215);

return statearr_18230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18226__$1,(6),inst_18214);
} else {
if((state_val_18227 === (3))){
var inst_18224 = (state_18226[(2)]);
var state_18226__$1 = state_18226;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18226__$1,inst_18224);
} else {
if((state_val_18227 === (4))){
var inst_18201 = (state_18226[(2)]);
var state_18226__$1 = state_18226;
var statearr_18232_18246 = state_18226__$1;
(statearr_18232_18246[(2)] = inst_18201);

(statearr_18232_18246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18227 === (5))){
var _ = (function (){var statearr_18233 = state_18226;
(statearr_18233[(4)] = cljs.core.rest.call(null,(state_18226[(4)])));

return statearr_18233;
})();
var state_18226__$1 = state_18226;
var ex18231 = (state_18226__$1[(2)]);
var statearr_18234_18247 = state_18226__$1;
(statearr_18234_18247[(5)] = ex18231);


if((ex18231 instanceof Error)){
var statearr_18235_18248 = state_18226__$1;
(statearr_18235_18248[(1)] = (4));

(statearr_18235_18248[(5)] = null);

} else {
throw ex18231;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18227 === (6))){
var inst_18215 = (state_18226[(8)]);
var inst_18217 = (state_18226[(2)]);
var inst_18218 = fluree.db.util.async.throw_err.call(null,inst_18217);
var state_18226__$1 = (function (){var statearr_18236 = state_18226;
(statearr_18236[(9)] = inst_18218);

return statearr_18236;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18226__$1,(7),inst_18215);
} else {
if((state_val_18227 === (7))){
var inst_18207 = (state_18226[(7)]);
var inst_18220 = (state_18226[(2)]);
var inst_18221 = fluree.db.util.async.throw_err.call(null,inst_18220);
var _ = (function (){var statearr_18237 = state_18226;
(statearr_18237[(4)] = cljs.core.rest.call(null,(state_18226[(4)])));

return statearr_18237;
})();
var state_18226__$1 = (function (){var statearr_18238 = state_18226;
(statearr_18238[(10)] = inst_18221);

return statearr_18238;
})();
var statearr_18239_18249 = state_18226__$1;
(statearr_18239_18249[(2)] = inst_18207);

(statearr_18239_18249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2703__auto____0 = (function (){
var statearr_18240 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18240[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2703__auto__);

(statearr_18240[(1)] = (1));

return statearr_18240;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2703__auto____1 = (function (state_18226){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18241){var ex__2706__auto__ = e18241;
var statearr_18242_18250 = state_18226;
(statearr_18242_18250[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18226[(4)]))){
var statearr_18243_18251 = state_18226;
(statearr_18243_18251[(1)] = cljs.core.first.call(null,(state_18226[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18252 = state_18226;
state_18226 = G__18252;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2703__auto__ = function(state_18226){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2703__auto____1.call(this,state_18226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2703__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2703__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18244 = f__2726__auto__.call(null);
(statearr_18244[(6)] = c__2725__auto__);

return statearr_18244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18269){
var state_val_18270 = (state_18269[(1)]);
if((state_val_18270 === (1))){
var state_18269__$1 = state_18269;
var statearr_18271_18286 = state_18269__$1;
(statearr_18271_18286[(2)] = null);

(statearr_18271_18286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18270 === (2))){
var _ = (function (){var statearr_18272 = state_18269;
(statearr_18272[(4)] = cljs.core.cons.call(null,(5),(state_18269[(4)])));

return statearr_18272;
})();
var inst_18259 = fluree.db.storage.core.serde.call(null,conn);
var inst_18260 = fluree.db.serde.protocol._serialize_branch.call(null,inst_18259,data);
var inst_18261 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_18260);
var state_18269__$1 = state_18269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18269__$1,(6),inst_18261);
} else {
if((state_val_18270 === (3))){
var inst_18267 = (state_18269[(2)]);
var state_18269__$1 = state_18269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18269__$1,inst_18267);
} else {
if((state_val_18270 === (4))){
var inst_18253 = (state_18269[(2)]);
var state_18269__$1 = state_18269;
var statearr_18274_18287 = state_18269__$1;
(statearr_18274_18287[(2)] = inst_18253);

(statearr_18274_18287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18270 === (5))){
var _ = (function (){var statearr_18275 = state_18269;
(statearr_18275[(4)] = cljs.core.rest.call(null,(state_18269[(4)])));

return statearr_18275;
})();
var state_18269__$1 = state_18269;
var ex18273 = (state_18269__$1[(2)]);
var statearr_18276_18288 = state_18269__$1;
(statearr_18276_18288[(5)] = ex18273);


if((ex18273 instanceof Error)){
var statearr_18277_18289 = state_18269__$1;
(statearr_18277_18289[(1)] = (4));

(statearr_18277_18289[(5)] = null);

} else {
throw ex18273;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18270 === (6))){
var inst_18263 = (state_18269[(2)]);
var inst_18264 = fluree.db.util.async.throw_err.call(null,inst_18263);
var _ = (function (){var statearr_18278 = state_18269;
(statearr_18278[(4)] = cljs.core.rest.call(null,(state_18269[(4)])));

return statearr_18278;
})();
var state_18269__$1 = (function (){var statearr_18279 = state_18269;
(statearr_18279[(7)] = inst_18264);

return statearr_18279;
})();
var statearr_18280_18290 = state_18269__$1;
(statearr_18280_18290[(2)] = key);

(statearr_18280_18290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto____0 = (function (){
var statearr_18281 = [null,null,null,null,null,null,null,null];
(statearr_18281[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto__);

(statearr_18281[(1)] = (1));

return statearr_18281;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto____1 = (function (state_18269){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18282){var ex__2706__auto__ = e18282;
var statearr_18283_18291 = state_18269;
(statearr_18283_18291[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18269[(4)]))){
var statearr_18284_18292 = state_18269;
(statearr_18284_18292[(1)] = cljs.core.first.call(null,(state_18269[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18293 = state_18269;
state_18269 = G__18293;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto__ = function(state_18269){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto____1.call(this,state_18269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18285 = f__2726__auto__.call(null);
(statearr_18285[(6)] = c__2725__auto__);

return statearr_18285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__18294_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__18294_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__18295){
var map__18296 = p__18295;
var map__18296__$1 = cljs.core.__destructure_map.call(null,map__18296);
var progress = map__18296__$1;
var garbage = cljs.core.get.call(null,map__18296__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18324){
var state_val_18325 = (state_18324[(1)]);
if((state_val_18325 === (1))){
var state_18324__$1 = state_18324;
var statearr_18326_18342 = state_18324__$1;
(statearr_18326_18342[(2)] = null);

(statearr_18326_18342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18325 === (2))){
var inst_18310 = (state_18324[(7)]);
var _ = (function (){var statearr_18327 = state_18324;
(statearr_18327[(4)] = cljs.core.cons.call(null,(5),(state_18324[(4)])));

return statearr_18327;
})();
var inst_18304 = db;
var inst_18305 = cljs.core.__destructure_map.call(null,inst_18304);
var inst_18306 = cljs.core.get.call(null,inst_18305,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18307 = cljs.core.get.call(null,inst_18305,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18308 = cljs.core.get.call(null,inst_18305,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18309 = cljs.core.get.call(null,inst_18305,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18310__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_18307,inst_18308,inst_18309);
var inst_18311 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_18312 = [inst_18308,inst_18309,garbage];
var inst_18313 = cljs.core.PersistentHashMap.fromArrays(inst_18311,inst_18312);
var inst_18314 = fluree.db.storage.core.serde.call(null,inst_18306);
var inst_18315 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_18314,inst_18313);
var inst_18316 = fluree.db.storage.core.storage_write.call(null,inst_18306,inst_18310__$1,inst_18315);
var state_18324__$1 = (function (){var statearr_18328 = state_18324;
(statearr_18328[(7)] = inst_18310__$1);

return statearr_18328;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18324__$1,(6),inst_18316);
} else {
if((state_val_18325 === (3))){
var inst_18322 = (state_18324[(2)]);
var state_18324__$1 = state_18324;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18324__$1,inst_18322);
} else {
if((state_val_18325 === (4))){
var inst_18297 = (state_18324[(2)]);
var state_18324__$1 = state_18324;
var statearr_18330_18343 = state_18324__$1;
(statearr_18330_18343[(2)] = inst_18297);

(statearr_18330_18343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18325 === (5))){
var _ = (function (){var statearr_18331 = state_18324;
(statearr_18331[(4)] = cljs.core.rest.call(null,(state_18324[(4)])));

return statearr_18331;
})();
var state_18324__$1 = state_18324;
var ex18329 = (state_18324__$1[(2)]);
var statearr_18332_18344 = state_18324__$1;
(statearr_18332_18344[(5)] = ex18329);


if((ex18329 instanceof Error)){
var statearr_18333_18345 = state_18324__$1;
(statearr_18333_18345[(1)] = (4));

(statearr_18333_18345[(5)] = null);

} else {
throw ex18329;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18325 === (6))){
var inst_18310 = (state_18324[(7)]);
var inst_18318 = (state_18324[(2)]);
var inst_18319 = fluree.db.util.async.throw_err.call(null,inst_18318);
var _ = (function (){var statearr_18334 = state_18324;
(statearr_18334[(4)] = cljs.core.rest.call(null,(state_18324[(4)])));

return statearr_18334;
})();
var state_18324__$1 = (function (){var statearr_18335 = state_18324;
(statearr_18335[(8)] = inst_18319);

return statearr_18335;
})();
var statearr_18336_18346 = state_18324__$1;
(statearr_18336_18346[(2)] = inst_18310);

(statearr_18336_18346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2703__auto____0 = (function (){
var statearr_18337 = [null,null,null,null,null,null,null,null,null];
(statearr_18337[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2703__auto__);

(statearr_18337[(1)] = (1));

return statearr_18337;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2703__auto____1 = (function (state_18324){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18338){var ex__2706__auto__ = e18338;
var statearr_18339_18347 = state_18324;
(statearr_18339_18347[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18324[(4)]))){
var statearr_18340_18348 = state_18324;
(statearr_18340_18348[(1)] = cljs.core.first.call(null,(state_18324[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18349 = state_18324;
state_18324 = G__18349;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2703__auto__ = function(state_18324){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2703__auto____1.call(this,state_18324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2703__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2703__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18341 = f__2726__auto__.call(null);
(statearr_18341[(6)] = c__2725__auto__);

return statearr_18341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__18351 = arguments.length;
switch (G__18351) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18407){
var state_val_18408 = (state_18407[(1)]);
if((state_val_18408 === (7))){
var state_18407__$1 = state_18407;
var statearr_18409_18435 = state_18407__$1;
(statearr_18409_18435[(2)] = (0));

(statearr_18409_18435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (1))){
var state_18407__$1 = state_18407;
var statearr_18410_18436 = state_18407__$1;
(statearr_18410_18436[(2)] = null);

(statearr_18410_18436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (4))){
var inst_18352 = (state_18407[(2)]);
var state_18407__$1 = state_18407;
var statearr_18411_18437 = state_18407__$1;
(statearr_18411_18437[(2)] = inst_18352);

(statearr_18411_18437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (6))){
var inst_18377 = (state_18407[(7)]);
var state_18407__$1 = state_18407;
var statearr_18412_18438 = state_18407__$1;
(statearr_18412_18438[(2)] = inst_18377);

(statearr_18412_18438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (3))){
var inst_18405 = (state_18407[(2)]);
var state_18407__$1 = state_18407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18407__$1,inst_18405);
} else {
if((state_val_18408 === (12))){
var inst_18374 = (state_18407[(8)]);
var inst_18401 = (state_18407[(2)]);
var inst_18402 = fluree.db.util.async.throw_err.call(null,inst_18401);
var _ = (function (){var statearr_18413 = state_18407;
(statearr_18413[(4)] = cljs.core.rest.call(null,(state_18407[(4)])));

return statearr_18413;
})();
var state_18407__$1 = (function (){var statearr_18414 = state_18407;
(statearr_18414[(9)] = inst_18402);

return statearr_18414;
})();
var statearr_18415_18439 = state_18407__$1;
(statearr_18415_18439[(2)] = inst_18374);

(statearr_18415_18439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (2))){
var inst_18365 = (state_18407[(10)]);
var inst_18367 = (state_18407[(11)]);
var inst_18377 = (state_18407[(7)]);
var inst_18369 = (state_18407[(12)]);
var _ = (function (){var statearr_18416 = state_18407;
(statearr_18416[(4)] = cljs.core.cons.call(null,(5),(state_18407[(4)])));

return statearr_18416;
})();
var inst_18359 = db;
var inst_18360 = cljs.core.__destructure_map.call(null,inst_18359);
var inst_18361 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18362 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_18363 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_18364 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_18365__$1 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_18366 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18367__$1 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18368 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_18369__$1 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18370 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_18371 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_18372 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_18373 = cljs.core.get.call(null,inst_18360,new cljs.core.Keyword(null,"post","post",269697687));
var inst_18374 = fluree.db.storage.core.ledger_root_key.call(null,inst_18361,inst_18369__$1,inst_18367__$1);
var inst_18375 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_18376 = fluree.db.storage.core.child_data.call(null,inst_18368);
var inst_18377__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_18365__$1);
var state_18407__$1 = (function (){var statearr_18417 = state_18407;
(statearr_18417[(13)] = inst_18364);

(statearr_18417[(14)] = inst_18370);

(statearr_18417[(10)] = inst_18365__$1);

(statearr_18417[(11)] = inst_18367__$1);

(statearr_18417[(15)] = inst_18363);

(statearr_18417[(7)] = inst_18377__$1);

(statearr_18417[(16)] = inst_18376);

(statearr_18417[(17)] = inst_18362);

(statearr_18417[(12)] = inst_18369__$1);

(statearr_18417[(18)] = inst_18373);

(statearr_18417[(19)] = inst_18371);

(statearr_18417[(20)] = inst_18375);

(statearr_18417[(21)] = inst_18372);

(statearr_18417[(8)] = inst_18374);

(statearr_18417[(22)] = inst_18366);

return statearr_18417;
})();
if(cljs.core.truth_(inst_18377__$1)){
var statearr_18418_18440 = state_18407__$1;
(statearr_18418_18440[(1)] = (6));

} else {
var statearr_18419_18441 = state_18407__$1;
(statearr_18419_18441[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (11))){
var inst_18364 = (state_18407[(13)]);
var inst_18365 = (state_18407[(10)]);
var inst_18367 = (state_18407[(11)]);
var inst_18363 = (state_18407[(15)]);
var inst_18376 = (state_18407[(16)]);
var inst_18362 = (state_18407[(17)]);
var inst_18369 = (state_18407[(12)]);
var inst_18373 = (state_18407[(18)]);
var inst_18371 = (state_18407[(19)]);
var inst_18375 = (state_18407[(20)]);
var inst_18381 = (state_18407[(23)]);
var inst_18372 = (state_18407[(21)]);
var inst_18374 = (state_18407[(8)]);
var inst_18366 = (state_18407[(22)]);
var inst_18386 = (state_18407[(2)]);
var inst_18387 = fluree.db.storage.core.child_data.call(null,inst_18371);
var inst_18388 = fluree.db.storage.core.child_data.call(null,inst_18373);
var inst_18389 = fluree.db.util.core.current_time_millis.call(null);
var inst_18390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18391 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_18392 = (new cljs.core.PersistentVector(null,2,(5),inst_18390,inst_18391,null));
var inst_18393 = cljs.core.select_keys.call(null,inst_18365,inst_18392);
var inst_18394 = fluree.db.storage.core.child_data.call(null,inst_18364);
var inst_18395 = [inst_18367,inst_18376,inst_18369,inst_18381,inst_18386,inst_18387,inst_18388,inst_18362,inst_18389,inst_18363,inst_18372,inst_18393,inst_18394];
var inst_18396 = cljs.core.PersistentHashMap.fromArrays(inst_18375,inst_18395);
var inst_18397 = fluree.db.storage.core.serde.call(null,inst_18366);
var inst_18398 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_18397,inst_18396);
var inst_18399 = fluree.db.storage.core.storage_write.call(null,inst_18366,inst_18374,inst_18398);
var state_18407__$1 = state_18407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18407__$1,(12),inst_18399);
} else {
if((state_val_18408 === (9))){
var inst_18382 = (state_18407[(24)]);
var state_18407__$1 = state_18407;
var statearr_18421_18442 = state_18407__$1;
(statearr_18421_18442[(2)] = inst_18382);

(statearr_18421_18442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (5))){
var _ = (function (){var statearr_18422 = state_18407;
(statearr_18422[(4)] = cljs.core.rest.call(null,(state_18407[(4)])));

return statearr_18422;
})();
var state_18407__$1 = state_18407;
var ex18420 = (state_18407__$1[(2)]);
var statearr_18423_18443 = state_18407__$1;
(statearr_18423_18443[(5)] = ex18420);


if((ex18420 instanceof Error)){
var statearr_18424_18444 = state_18407__$1;
(statearr_18424_18444[(1)] = (4));

(statearr_18424_18444[(5)] = null);

} else {
throw ex18420;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (10))){
var inst_18370 = (state_18407[(14)]);
var state_18407__$1 = state_18407;
var statearr_18425_18445 = state_18407__$1;
(statearr_18425_18445[(2)] = inst_18370);

(statearr_18425_18445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18408 === (8))){
var inst_18382 = (state_18407[(24)]);
var inst_18381 = (state_18407[(2)]);
var inst_18382__$1 = custom_ecount;
var state_18407__$1 = (function (){var statearr_18426 = state_18407;
(statearr_18426[(24)] = inst_18382__$1);

(statearr_18426[(23)] = inst_18381);

return statearr_18426;
})();
if(cljs.core.truth_(inst_18382__$1)){
var statearr_18427_18446 = state_18407__$1;
(statearr_18427_18446[(1)] = (9));

} else {
var statearr_18428_18447 = state_18407__$1;
(statearr_18428_18447[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2703__auto__ = null;
var fluree$db$storage$core$state_machine__2703__auto____0 = (function (){
var statearr_18429 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18429[(0)] = fluree$db$storage$core$state_machine__2703__auto__);

(statearr_18429[(1)] = (1));

return statearr_18429;
});
var fluree$db$storage$core$state_machine__2703__auto____1 = (function (state_18407){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18430){var ex__2706__auto__ = e18430;
var statearr_18431_18448 = state_18407;
(statearr_18431_18448[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18407[(4)]))){
var statearr_18432_18449 = state_18407;
(statearr_18432_18449[(1)] = cljs.core.first.call(null,(state_18407[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18450 = state_18407;
state_18407 = G__18450;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2703__auto__ = function(state_18407){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2703__auto____1.call(this,state_18407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2703__auto____0;
fluree$db$storage$core$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2703__auto____1;
return fluree$db$storage$core$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18433 = f__2726__auto__.call(null);
(statearr_18433[(6)] = c__2725__auto__);

return statearr_18433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2725__auto___18509 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18483){
var state_val_18484 = (state_18483[(1)]);
if((state_val_18484 === (7))){
var inst_18463 = (state_18483[(7)]);
var state_18483__$1 = state_18483;
var statearr_18485_18510 = state_18483__$1;
(statearr_18485_18510[(2)] = inst_18463);

(statearr_18485_18510[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (1))){
var state_18483__$1 = state_18483;
var statearr_18486_18511 = state_18483__$1;
(statearr_18486_18511[(2)] = null);

(statearr_18486_18511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (4))){
var inst_18451 = (state_18483[(2)]);
var inst_18452 = error_fn.call(null);
var inst_18453 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18451);
var inst_18454 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18483__$1 = (function (){var statearr_18487 = state_18483;
(statearr_18487[(8)] = inst_18452);

(statearr_18487[(9)] = inst_18453);

return statearr_18487;
})();
var statearr_18488_18512 = state_18483__$1;
(statearr_18488_18512[(2)] = inst_18454);

(statearr_18488_18512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (6))){
var inst_18462 = (state_18483[(10)]);
var inst_18463 = (state_18483[(7)]);
var inst_18462__$1 = (state_18483[(2)]);
var inst_18463__$1 = (inst_18462__$1 == null);
var state_18483__$1 = (function (){var statearr_18489 = state_18483;
(statearr_18489[(10)] = inst_18462__$1);

(statearr_18489[(7)] = inst_18463__$1);

return statearr_18489;
})();
if(cljs.core.truth_(inst_18463__$1)){
var statearr_18490_18513 = state_18483__$1;
(statearr_18490_18513[(1)] = (7));

} else {
var statearr_18491_18514 = state_18483__$1;
(statearr_18491_18514[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (3))){
var inst_18481 = (state_18483[(2)]);
var state_18483__$1 = state_18483;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18483__$1,inst_18481);
} else {
if((state_val_18484 === (12))){
var inst_18478 = (state_18483[(2)]);
var _ = (function (){var statearr_18492 = state_18483;
(statearr_18492[(4)] = cljs.core.rest.call(null,(state_18483[(4)])));

return statearr_18492;
})();
var state_18483__$1 = state_18483;
var statearr_18493_18515 = state_18483__$1;
(statearr_18493_18515[(2)] = inst_18478);

(statearr_18493_18515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (2))){
var _ = (function (){var statearr_18494 = state_18483;
(statearr_18494[(4)] = cljs.core.cons.call(null,(5),(state_18483[(4)])));

return statearr_18494;
})();
var inst_18460 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18483__$1 = state_18483;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18483__$1,(6),inst_18460);
} else {
if((state_val_18484 === (11))){
var inst_18462 = (state_18483[(10)]);
var inst_18472 = fluree.db.storage.core.serde.call(null,conn);
var inst_18473 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_18472,inst_18462);
var inst_18474 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18473);
var inst_18475 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_18474);
var inst_18476 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18475);
var state_18483__$1 = state_18483;
var statearr_18496_18516 = state_18483__$1;
(statearr_18496_18516[(2)] = inst_18476);

(statearr_18496_18516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (9))){
var inst_18468 = (state_18483[(2)]);
var state_18483__$1 = state_18483;
if(cljs.core.truth_(inst_18468)){
var statearr_18497_18517 = state_18483__$1;
(statearr_18497_18517[(1)] = (10));

} else {
var statearr_18498_18518 = state_18483__$1;
(statearr_18498_18518[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (5))){
var _ = (function (){var statearr_18499 = state_18483;
(statearr_18499[(4)] = cljs.core.rest.call(null,(state_18483[(4)])));

return statearr_18499;
})();
var state_18483__$1 = state_18483;
var ex18495 = (state_18483__$1[(2)]);
var statearr_18500_18519 = state_18483__$1;
(statearr_18500_18519[(5)] = ex18495);


var statearr_18501_18520 = state_18483__$1;
(statearr_18501_18520[(1)] = (4));

(statearr_18501_18520[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (10))){
var inst_18470 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18483__$1 = state_18483;
var statearr_18502_18521 = state_18483__$1;
(statearr_18502_18521[(2)] = inst_18470);

(statearr_18502_18521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18484 === (8))){
var inst_18462 = (state_18483[(10)]);
var inst_18466 = (inst_18462 instanceof Error);
var state_18483__$1 = state_18483;
var statearr_18503_18522 = state_18483__$1;
(statearr_18503_18522[(2)] = inst_18466);

(statearr_18503_18522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2703__auto____0 = (function (){
var statearr_18504 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18504[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2703__auto__);

(statearr_18504[(1)] = (1));

return statearr_18504;
});
var fluree$db$storage$core$reify_history_$_state_machine__2703__auto____1 = (function (state_18483){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18483);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18505){var ex__2706__auto__ = e18505;
var statearr_18506_18523 = state_18483;
(statearr_18506_18523[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18483[(4)]))){
var statearr_18507_18524 = state_18483;
(statearr_18507_18524[(1)] = cljs.core.first.call(null,(state_18483[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18525 = state_18483;
state_18483 = G__18525;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2703__auto__ = function(state_18483){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2703__auto____1.call(this,state_18483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2703__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2703__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18508 = f__2726__auto__.call(null);
(statearr_18508[(6)] = c__2725__auto___18509);

return statearr_18508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__18527 = arguments.length;
switch (G__18527) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2725__auto___18637 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18590){
var state_val_18591 = (state_18590[(1)]);
if((state_val_18591 === (7))){
var state_18590__$1 = state_18590;
var statearr_18592_18638 = state_18590__$1;
(statearr_18592_18638[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_18592_18638[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (20))){
var inst_18569 = cljs.core.PersistentVector.EMPTY;
var state_18590__$1 = state_18590;
var statearr_18593_18639 = state_18590__$1;
(statearr_18593_18639[(2)] = inst_18569);

(statearr_18593_18639[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (1))){
var state_18590__$1 = state_18590;
var statearr_18594_18640 = state_18590__$1;
(statearr_18594_18640[(2)] = null);

(statearr_18594_18640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (24))){
var state_18590__$1 = state_18590;
var statearr_18595_18641 = state_18590__$1;
(statearr_18595_18641[(2)] = null);

(statearr_18595_18641[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (4))){
var inst_18530 = (state_18590[(2)]);
var inst_18531 = error_fn.call(null);
var inst_18532 = cljs.core.async.put_BANG_.call(null,result_ch,inst_18530);
var inst_18533 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_18590__$1 = (function (){var statearr_18596 = state_18590;
(statearr_18596[(7)] = inst_18531);

(statearr_18596[(8)] = inst_18532);

return statearr_18596;
})();
var statearr_18597_18642 = state_18590__$1;
(statearr_18597_18642[(2)] = inst_18533);

(statearr_18597_18642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (15))){
var inst_18555 = (state_18590[(2)]);
var state_18590__$1 = state_18590;
var statearr_18598_18643 = state_18590__$1;
(statearr_18598_18643[(2)] = inst_18555);

(statearr_18598_18643[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (21))){
var inst_18559 = (state_18590[(9)]);
var inst_18543 = (state_18590[(10)]);
var inst_18572 = (state_18590[(11)]);
var inst_18544 = (state_18590[(12)]);
var inst_18542 = (state_18590[(13)]);
var inst_18579 = (state_18590[(2)]);
var inst_18580 = (function (){var base_node = inst_18542;
var first_flake = inst_18543;
var node_t = inst_18544;
var source = inst_18559;
var coll = inst_18572;
var conj_QMARK_ = inst_18579;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__5045__auto__ = remove_preds;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_18581 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18542);
var inst_18582 = cljs.core.reduce.call(null,inst_18580,inst_18581,inst_18572);
var inst_18583 = cljs.core.doall.call(null,inst_18582);
var inst_18584 = cljs.core.assoc.call(null,inst_18542,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18583);
var inst_18585 = cljs.core.async.put_BANG_.call(null,result_ch,inst_18584);
var _ = (function (){var statearr_18599 = state_18590;
(statearr_18599[(4)] = cljs.core.rest.call(null,(state_18590[(4)])));

return statearr_18599;
})();
var state_18590__$1 = state_18590;
var statearr_18600_18644 = state_18590__$1;
(statearr_18600_18644[(2)] = inst_18585);

(statearr_18600_18644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (13))){
var state_18590__$1 = state_18590;
var statearr_18601_18645 = state_18590__$1;
(statearr_18601_18645[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_18601_18645[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (22))){
var inst_18559 = (state_18590[(9)]);
var inst_18543 = (state_18590[(10)]);
var inst_18572 = (state_18590[(11)]);
var inst_18544 = (state_18590[(12)]);
var inst_18542 = (state_18590[(13)]);
var inst_18573 = (function (){var base_node = inst_18542;
var first_flake = inst_18543;
var node_t = inst_18544;
var source = inst_18559;
var coll = inst_18572;
return (function (f){
return f.op === true;
});
})();
var state_18590__$1 = state_18590;
var statearr_18602_18646 = state_18590__$1;
(statearr_18602_18646[(2)] = inst_18573);

(statearr_18602_18646[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (6))){
var inst_18544 = (state_18590[(12)]);
var inst_18542 = (state_18590[(13)]);
var inst_18541 = (state_18590[(2)]);
var inst_18542__$1 = fluree.db.util.async.throw_err.call(null,inst_18541);
var inst_18543 = fluree.db.dbproto._first_flake.call(null,inst_18542__$1);
var inst_18544__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_18542__$1);
var inst_18545 = (inst_18544__$1 > t);
var state_18590__$1 = (function (){var statearr_18603 = state_18590;
(statearr_18603[(10)] = inst_18543);

(statearr_18603[(12)] = inst_18544__$1);

(statearr_18603[(13)] = inst_18542__$1);

return statearr_18603;
})();
if(cljs.core.truth_(inst_18545)){
var statearr_18604_18647 = state_18590__$1;
(statearr_18604_18647[(1)] = (7));

} else {
var statearr_18605_18648 = state_18590__$1;
(statearr_18605_18648[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (17))){
var inst_18543 = (state_18590[(10)]);
var inst_18560 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_18543,rhs,leftmost_QMARK_,t);
var state_18590__$1 = state_18590;
var statearr_18606_18649 = state_18590__$1;
(statearr_18606_18649[(2)] = inst_18560);

(statearr_18606_18649[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (3))){
var inst_18588 = (state_18590[(2)]);
var state_18590__$1 = state_18590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18590__$1,inst_18588);
} else {
if((state_val_18591 === (12))){
var inst_18557 = (state_18590[(2)]);
var state_18590__$1 = state_18590;
var statearr_18607_18650 = state_18590__$1;
(statearr_18607_18650[(2)] = inst_18557);

(statearr_18607_18650[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (2))){
var _ = (function (){var statearr_18608 = state_18590;
(statearr_18608[(4)] = cljs.core.cons.call(null,(5),(state_18590[(4)])));

return statearr_18608;
})();
var inst_18539 = fluree.db.dbproto._resolve.call(null,node);
var state_18590__$1 = state_18590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18590__$1,(6),inst_18539);
} else {
if((state_val_18591 === (23))){
var inst_18559 = (state_18590[(9)]);
var inst_18543 = (state_18590[(10)]);
var inst_18572 = (state_18590[(11)]);
var inst_18544 = (state_18590[(12)]);
var inst_18542 = (state_18590[(13)]);
var inst_18575 = (function (){var base_node = inst_18542;
var first_flake = inst_18543;
var node_t = inst_18544;
var source = inst_18559;
var coll = inst_18572;
return (function (f){
return f.op === false;
});
})();
var state_18590__$1 = state_18590;
var statearr_18609_18651 = state_18590__$1;
(statearr_18609_18651[(2)] = inst_18575);

(statearr_18609_18651[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (19))){
var inst_18562 = (state_18590[(14)]);
var inst_18565 = (state_18590[(2)]);
var inst_18566 = fluree.db.util.async.throw_err.call(null,inst_18565);
var inst_18567 = cljs.core.take_while.call(null,inst_18562,inst_18566);
var state_18590__$1 = state_18590;
var statearr_18610_18652 = state_18590__$1;
(statearr_18610_18652[(2)] = inst_18567);

(statearr_18610_18652[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (11))){
var inst_18544 = (state_18590[(12)]);
var inst_18551 = cljs.core._EQ_.call(null,inst_18544,t);
var state_18590__$1 = state_18590;
if(inst_18551){
var statearr_18612_18653 = state_18590__$1;
(statearr_18612_18653[(1)] = (13));

} else {
var statearr_18613_18654 = state_18590__$1;
(statearr_18613_18654[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (9))){
var inst_18559 = (state_18590[(9)]);
var inst_18559__$1 = (state_18590[(2)]);
var state_18590__$1 = (function (){var statearr_18614 = state_18590;
(statearr_18614[(9)] = inst_18559__$1);

return statearr_18614;
})();
var G__18615_18655 = inst_18559__$1;
var G__18615_18656__$1 = (((G__18615_18655 instanceof cljs.core.Keyword))?G__18615_18655.fqn:null);
switch (G__18615_18656__$1) {
case "novelty":
var statearr_18616_18658 = state_18590__$1;
(statearr_18616_18658[(1)] = (17));


break;
case "history":
var statearr_18617_18659 = state_18590__$1;
(statearr_18617_18659[(1)] = (18));


break;
case "none":
var statearr_18618_18660 = state_18590__$1;
(statearr_18618_18660[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18615_18656__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (5))){
var _ = (function (){var statearr_18619 = state_18590;
(statearr_18619[(4)] = cljs.core.rest.call(null,(state_18590[(4)])));

return statearr_18619;
})();
var state_18590__$1 = state_18590;
var ex18611 = (state_18590__$1[(2)]);
var statearr_18620_18661 = state_18590__$1;
(statearr_18620_18661[(5)] = ex18611);


var statearr_18621_18662 = state_18590__$1;
(statearr_18621_18662[(1)] = (4));

(statearr_18621_18662[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (14))){
var state_18590__$1 = state_18590;
var statearr_18622_18663 = state_18590__$1;
(statearr_18622_18663[(2)] = null);

(statearr_18622_18663[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (16))){
var inst_18559 = (state_18590[(9)]);
var inst_18572 = (state_18590[(2)]);
var state_18590__$1 = (function (){var statearr_18623 = state_18590;
(statearr_18623[(11)] = inst_18572);

return statearr_18623;
})();
var G__18624_18664 = inst_18559;
var G__18624_18665__$1 = (((G__18624_18664 instanceof cljs.core.Keyword))?G__18624_18664.fqn:null);
switch (G__18624_18665__$1) {
case "novelty":
var statearr_18625_18667 = state_18590__$1;
(statearr_18625_18667[(1)] = (22));


break;
case "history":
var statearr_18626_18668 = state_18590__$1;
(statearr_18626_18668[(1)] = (23));


break;
case "none":
var statearr_18627_18669 = state_18590__$1;
(statearr_18627_18669[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18624_18665__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (10))){
var state_18590__$1 = state_18590;
var statearr_18628_18670 = state_18590__$1;
(statearr_18628_18670[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_18628_18670[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18591 === (18))){
var inst_18559 = (state_18590[(9)]);
var inst_18543 = (state_18590[(10)]);
var inst_18544 = (state_18590[(12)]);
var inst_18542 = (state_18590[(13)]);
var inst_18562 = (function (){var base_node = inst_18542;
var first_flake = inst_18543;
var node_t = inst_18544;
var source = inst_18559;
return (function (p1__18529_SHARP_){
return (p1__18529_SHARP_.t <= t);
});
})();
var inst_18563 = fluree.db.dbproto._resolve_history.call(null,node);
var state_18590__$1 = (function (){var statearr_18629 = state_18590;
(statearr_18629[(14)] = inst_18562);

return statearr_18629;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18590__$1,(19),inst_18563);
} else {
if((state_val_18591 === (8))){
var inst_18544 = (state_18590[(12)]);
var inst_18548 = (inst_18544 < t);
var state_18590__$1 = state_18590;
if(cljs.core.truth_(inst_18548)){
var statearr_18630_18671 = state_18590__$1;
(statearr_18630_18671[(1)] = (10));

} else {
var statearr_18631_18672 = state_18590__$1;
(statearr_18631_18672[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2703__auto____0 = (function (){
var statearr_18632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18632[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2703__auto__);

(statearr_18632[(1)] = (1));

return statearr_18632;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2703__auto____1 = (function (state_18590){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18633){var ex__2706__auto__ = e18633;
var statearr_18634_18673 = state_18590;
(statearr_18634_18673[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18590[(4)]))){
var statearr_18635_18674 = state_18590;
(statearr_18635_18674[(1)] = cljs.core.first.call(null,(state_18590[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18675 = state_18590;
state_18590 = G__18675;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2703__auto__ = function(state_18590){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2703__auto____1.call(this,state_18590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2703__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2703__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18636 = f__2726__auto__.call(null);
(statearr_18636[(6)] = c__2725__auto___18637);

return statearr_18636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18735){
var state_val_18736 = (state_18735[(1)]);
if((state_val_18736 === (7))){
var inst_18686 = (state_18735[(7)]);
var inst_18690 = (inst_18686 <= from_t);
var state_18735__$1 = state_18735;
var statearr_18737_18777 = state_18735__$1;
(statearr_18737_18777[(2)] = inst_18690);

(statearr_18737_18777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (20))){
var inst_18720 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_18721 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18720)].join('');
var inst_18722 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18723 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18724 = cljs.core.PersistentHashMap.fromArrays(inst_18722,inst_18723);
var inst_18725 = cljs.core.ex_info.call(null,inst_18721,inst_18724);
var inst_18726 = (function(){throw inst_18725})();
var state_18735__$1 = state_18735;
var statearr_18738_18778 = state_18735__$1;
(statearr_18738_18778[(2)] = inst_18726);

(statearr_18738_18778[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (1))){
var state_18735__$1 = state_18735;
var statearr_18739_18779 = state_18735__$1;
(statearr_18739_18779[(2)] = null);

(statearr_18739_18779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (4))){
var inst_18678 = (state_18735[(2)]);
var inst_18679 = fluree.db.util.log.error.call(null,inst_18678);
var inst_18680 = (function(){throw inst_18678})();
var state_18735__$1 = (function (){var statearr_18740 = state_18735;
(statearr_18740[(8)] = inst_18679);

return statearr_18740;
})();
var statearr_18741_18780 = state_18735__$1;
(statearr_18741_18780[(2)] = inst_18680);

(statearr_18741_18780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (15))){
var inst_18705 = (state_18735[(2)]);
var state_18735__$1 = (function (){var statearr_18742 = state_18735;
(statearr_18742[(9)] = inst_18705);

return statearr_18742;
})();
if(cljs.core.truth_(from_t)){
var statearr_18743_18781 = state_18735__$1;
(statearr_18743_18781[(1)] = (16));

} else {
var statearr_18744_18782 = state_18735__$1;
(statearr_18744_18782[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (21))){
var inst_18716 = (state_18735[(10)]);
var inst_18714 = (state_18735[(11)]);
var inst_18715 = (state_18735[(12)]);
var inst_18728 = (state_18735[(2)]);
var inst_18729 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_18715,inst_18716,leftmost_QMARK_,to_t);
var inst_18730 = cljs.core.into.call(null,inst_18729,inst_18714);
var _ = (function (){var statearr_18745 = state_18735;
(statearr_18745[(4)] = cljs.core.rest.call(null,(state_18735[(4)])));

return statearr_18745;
})();
var state_18735__$1 = (function (){var statearr_18746 = state_18735;
(statearr_18746[(13)] = inst_18728);

return statearr_18746;
})();
var statearr_18747_18783 = state_18735__$1;
(statearr_18747_18783[(2)] = inst_18730);

(statearr_18747_18783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (13))){
var inst_18698 = (state_18735[(14)]);
var inst_18686 = (state_18735[(7)]);
var inst_18701 = (function (){var node_t = inst_18686;
var G__18694 = inst_18698;
return (function (p1__18676_SHARP_){
return (p1__18676_SHARP_.t < to_t);
});
})();
var inst_18702 = cljs.core.drop_while.call(null,inst_18701,inst_18698);
var state_18735__$1 = state_18735;
var statearr_18748_18784 = state_18735__$1;
(statearr_18748_18784[(2)] = inst_18702);

(statearr_18748_18784[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (6))){
var inst_18687 = (state_18735[(15)]);
var state_18735__$1 = state_18735;
var statearr_18749_18785 = state_18735__$1;
(statearr_18749_18785[(2)] = inst_18687);

(statearr_18749_18785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (17))){
var inst_18705 = (state_18735[(9)]);
var state_18735__$1 = state_18735;
var statearr_18750_18786 = state_18735__$1;
(statearr_18750_18786[(2)] = inst_18705);

(statearr_18750_18786[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (3))){
var inst_18733 = (state_18735[(2)]);
var state_18735__$1 = state_18735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18735__$1,inst_18733);
} else {
if((state_val_18736 === (12))){
var inst_18686 = (state_18735[(7)]);
var inst_18697 = (state_18735[(2)]);
var inst_18698 = fluree.db.util.async.throw_err.call(null,inst_18697);
var inst_18699 = (to_t > inst_18686);
var state_18735__$1 = (function (){var statearr_18751 = state_18735;
(statearr_18751[(14)] = inst_18698);

return statearr_18751;
})();
if(cljs.core.truth_(inst_18699)){
var statearr_18752_18787 = state_18735__$1;
(statearr_18752_18787[(1)] = (13));

} else {
var statearr_18753_18788 = state_18735__$1;
(statearr_18753_18788[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (2))){
var inst_18687 = (state_18735[(15)]);
var _ = (function (){var statearr_18754 = state_18735;
(statearr_18754[(4)] = cljs.core.cons.call(null,(5),(state_18735[(4)])));

return statearr_18754;
})();
var inst_18686 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_18687__$1 = (from_t == null);
var state_18735__$1 = (function (){var statearr_18755 = state_18735;
(statearr_18755[(15)] = inst_18687__$1);

(statearr_18755[(7)] = inst_18686);

return statearr_18755;
})();
if(cljs.core.truth_(inst_18687__$1)){
var statearr_18756_18789 = state_18735__$1;
(statearr_18756_18789[(1)] = (6));

} else {
var statearr_18757_18790 = state_18735__$1;
(statearr_18757_18790[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (19))){
var state_18735__$1 = state_18735;
var statearr_18758_18791 = state_18735__$1;
(statearr_18758_18791[(2)] = null);

(statearr_18758_18791[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (11))){
var inst_18714 = (state_18735[(2)]);
var inst_18715 = fluree.db.dbproto._first_flake.call(null,node);
var inst_18716 = fluree.db.dbproto._rhs.call(null,node);
var inst_18717 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18735__$1 = (function (){var statearr_18760 = state_18735;
(statearr_18760[(10)] = inst_18716);

(statearr_18760[(11)] = inst_18714);

(statearr_18760[(12)] = inst_18715);

return statearr_18760;
})();
if(cljs.core.truth_(inst_18717)){
var statearr_18761_18792 = state_18735__$1;
(statearr_18761_18792[(1)] = (19));

} else {
var statearr_18762_18793 = state_18735__$1;
(statearr_18762_18793[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (9))){
var inst_18695 = fluree.db.dbproto._resolve_history.call(null,node);
var state_18735__$1 = state_18735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18735__$1,(12),inst_18695);
} else {
if((state_val_18736 === (5))){
var _ = (function (){var statearr_18763 = state_18735;
(statearr_18763[(4)] = cljs.core.rest.call(null,(state_18735[(4)])));

return statearr_18763;
})();
var state_18735__$1 = state_18735;
var ex18759 = (state_18735__$1[(2)]);
var statearr_18764_18794 = state_18735__$1;
(statearr_18764_18794[(5)] = ex18759);


var statearr_18765_18795 = state_18735__$1;
(statearr_18765_18795[(1)] = (4));

(statearr_18765_18795[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (14))){
var inst_18698 = (state_18735[(14)]);
var state_18735__$1 = state_18735;
var statearr_18766_18796 = state_18735__$1;
(statearr_18766_18796[(2)] = inst_18698);

(statearr_18766_18796[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (16))){
var inst_18686 = (state_18735[(7)]);
var inst_18705 = (state_18735[(9)]);
var inst_18707 = (function (){var node_t = inst_18686;
var G__18694 = inst_18705;
return (function (p1__18677_SHARP_){
return (p1__18677_SHARP_.t <= from_t);
});
})();
var inst_18708 = cljs.core.take_while.call(null,inst_18707,inst_18705);
var state_18735__$1 = state_18735;
var statearr_18767_18797 = state_18735__$1;
(statearr_18767_18797[(2)] = inst_18708);

(statearr_18767_18797[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (10))){
var state_18735__$1 = state_18735;
var statearr_18768_18798 = state_18735__$1;
(statearr_18768_18798[(2)] = null);

(statearr_18768_18798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (18))){
var inst_18711 = (state_18735[(2)]);
var state_18735__$1 = state_18735;
var statearr_18769_18799 = state_18735__$1;
(statearr_18769_18799[(2)] = inst_18711);

(statearr_18769_18799[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (8))){
var inst_18692 = (state_18735[(2)]);
var state_18735__$1 = state_18735;
if(cljs.core.truth_(inst_18692)){
var statearr_18770_18800 = state_18735__$1;
(statearr_18770_18800[(1)] = (9));

} else {
var statearr_18771_18801 = state_18735__$1;
(statearr_18771_18801[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto____0 = (function (){
var statearr_18772 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18772[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto__);

(statearr_18772[(1)] = (1));

return statearr_18772;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto____1 = (function (state_18735){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18773){var ex__2706__auto__ = e18773;
var statearr_18774_18802 = state_18735;
(statearr_18774_18802[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18735[(4)]))){
var statearr_18775_18803 = state_18735;
(statearr_18775_18803[(1)] = cljs.core.first.call(null,(state_18735[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18804 = state_18735;
state_18735 = G__18804;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto__ = function(state_18735){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto____1.call(this,state_18735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18776 = f__2726__auto__.call(null);
(statearr_18776[(6)] = c__2725__auto__);

return statearr_18776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__5045__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18825){
var state_val_18826 = (state_18825[(1)]);
if((state_val_18826 === (7))){
var inst_18814 = (state_18825[(7)]);
var inst_18816 = fluree.db.storage.core.serde.call(null,conn);
var inst_18817 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_18816,inst_18814);
var state_18825__$1 = state_18825;
var statearr_18827_18846 = state_18825__$1;
(statearr_18827_18846[(2)] = inst_18817);

(statearr_18827_18846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (1))){
var state_18825__$1 = state_18825;
var statearr_18828_18847 = state_18825__$1;
(statearr_18828_18847[(2)] = null);

(statearr_18828_18847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (4))){
var inst_18805 = (state_18825[(2)]);
var state_18825__$1 = state_18825;
var statearr_18829_18848 = state_18825__$1;
(statearr_18829_18848[(2)] = inst_18805);

(statearr_18829_18848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (6))){
var inst_18814 = (state_18825[(7)]);
var inst_18813 = (state_18825[(2)]);
var inst_18814__$1 = fluree.db.util.async.throw_err.call(null,inst_18813);
var state_18825__$1 = (function (){var statearr_18830 = state_18825;
(statearr_18830[(7)] = inst_18814__$1);

return statearr_18830;
})();
if(cljs.core.truth_(inst_18814__$1)){
var statearr_18831_18849 = state_18825__$1;
(statearr_18831_18849[(1)] = (7));

} else {
var statearr_18832_18850 = state_18825__$1;
(statearr_18832_18850[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (3))){
var inst_18823 = (state_18825[(2)]);
var state_18825__$1 = state_18825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18825__$1,inst_18823);
} else {
if((state_val_18826 === (2))){
var _ = (function (){var statearr_18834 = state_18825;
(statearr_18834[(4)] = cljs.core.cons.call(null,(5),(state_18825[(4)])));

return statearr_18834;
})();
var inst_18811 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18825__$1 = state_18825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18825__$1,(6),inst_18811);
} else {
if((state_val_18826 === (9))){
var inst_18820 = (state_18825[(2)]);
var _ = (function (){var statearr_18835 = state_18825;
(statearr_18835[(4)] = cljs.core.rest.call(null,(state_18825[(4)])));

return statearr_18835;
})();
var state_18825__$1 = state_18825;
var statearr_18836_18851 = state_18825__$1;
(statearr_18836_18851[(2)] = inst_18820);

(statearr_18836_18851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (5))){
var _ = (function (){var statearr_18837 = state_18825;
(statearr_18837[(4)] = cljs.core.rest.call(null,(state_18825[(4)])));

return statearr_18837;
})();
var state_18825__$1 = state_18825;
var ex18833 = (state_18825__$1[(2)]);
var statearr_18838_18852 = state_18825__$1;
(statearr_18838_18852[(5)] = ex18833);


if((ex18833 instanceof Error)){
var statearr_18839_18853 = state_18825__$1;
(statearr_18839_18853[(1)] = (4));

(statearr_18839_18853[(5)] = null);

} else {
throw ex18833;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18826 === (8))){
var state_18825__$1 = state_18825;
var statearr_18840_18854 = state_18825__$1;
(statearr_18840_18854[(2)] = null);

(statearr_18840_18854[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2703__auto____0 = (function (){
var statearr_18841 = [null,null,null,null,null,null,null,null];
(statearr_18841[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2703__auto__);

(statearr_18841[(1)] = (1));

return statearr_18841;
});
var fluree$db$storage$core$read_branch_$_state_machine__2703__auto____1 = (function (state_18825){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18842){var ex__2706__auto__ = e18842;
var statearr_18843_18855 = state_18825;
(statearr_18843_18855[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18825[(4)]))){
var statearr_18844_18856 = state_18825;
(statearr_18844_18856[(1)] = cljs.core.first.call(null,(state_18825[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18857 = state_18825;
state_18825 = G__18857;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2703__auto__ = function(state_18825){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2703__auto____1.call(this,state_18825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2703__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2703__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18845 = f__2726__auto__.call(null);
(statearr_18845[(6)] = c__2725__auto__);

return statearr_18845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2725__auto___18936 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18908){
var state_val_18909 = (state_18908[(1)]);
if((state_val_18909 === (7))){
var inst_18875 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18877 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18878 = cljs.core.PersistentHashMap.fromArrays(inst_18876,inst_18877);
var inst_18879 = cljs.core.ex_info.call(null,inst_18875,inst_18878);
var inst_18880 = (function(){throw inst_18879})();
var state_18908__$1 = state_18908;
var statearr_18910_18937 = state_18908__$1;
(statearr_18910_18937[(2)] = inst_18880);

(statearr_18910_18937[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (1))){
var state_18908__$1 = state_18908;
var statearr_18911_18938 = state_18908__$1;
(statearr_18911_18938[(2)] = null);

(statearr_18911_18938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (4))){
var inst_18858 = (state_18908[(2)]);
var inst_18859 = error_fn.call(null);
var inst_18860 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18858);
var inst_18861 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18908__$1 = (function (){var statearr_18912 = state_18908;
(statearr_18912[(7)] = inst_18860);

(statearr_18912[(8)] = inst_18859);

return statearr_18912;
})();
var statearr_18913_18939 = state_18908__$1;
(statearr_18913_18939[(2)] = inst_18861);

(statearr_18913_18939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (6))){
var inst_18872 = (state_18908[(9)]);
var inst_18871 = (state_18908[(2)]);
var inst_18872__$1 = fluree.db.util.async.throw_err.call(null,inst_18871);
var inst_18873 = (inst_18872__$1 == null);
var state_18908__$1 = (function (){var statearr_18914 = state_18908;
(statearr_18914[(9)] = inst_18872__$1);

return statearr_18914;
})();
if(cljs.core.truth_(inst_18873)){
var statearr_18915_18940 = state_18908__$1;
(statearr_18915_18940[(1)] = (7));

} else {
var statearr_18916_18941 = state_18908__$1;
(statearr_18916_18941[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (3))){
var inst_18906 = (state_18908[(2)]);
var state_18908__$1 = state_18908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18908__$1,inst_18906);
} else {
if((state_val_18909 === (12))){
var inst_18872 = (state_18908[(9)]);
var inst_18889 = (state_18908[(2)]);
var inst_18890 = cljs.core.__destructure_map.call(null,inst_18872);
var inst_18891 = cljs.core.get.call(null,inst_18890,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18892 = cljs.core.get.call(null,inst_18890,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18893 = config;
var inst_18894 = cljs.core.__destructure_map.call(null,inst_18893);
var inst_18895 = cljs.core.get.call(null,inst_18894,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18897 = (function (){var data = inst_18872;
var _ = inst_18889;
var map__18867 = inst_18890;
var children = inst_18891;
var rhs = inst_18892;
var map__18868 = inst_18894;
var comparator = inst_18895;
return (function (idx,p__18896){
var map__18917 = p__18896;
var map__18917__$1 = cljs.core.__destructure_map.call(null,map__18917);
var child = map__18917__$1;
var id = cljs.core.get.call(null,map__18917__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__18917__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__18917__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__18917__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__18917__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (idx === (0));
} else {
return and__5043__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_18898 = cljs.core.map_indexed.call(null,inst_18897,inst_18891);
var inst_18899 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_18898);
var inst_18900 = cljs.core.interleave.call(null,inst_18899,inst_18898);
var inst_18901 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_18895,inst_18900);
var inst_18902 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_18892,inst_18901,config,leftmost_QMARK_);
var inst_18903 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18902);
var _ = (function (){var statearr_18918 = state_18908;
(statearr_18918[(4)] = cljs.core.rest.call(null,(state_18908[(4)])));

return statearr_18918;
})();
var state_18908__$1 = state_18908;
var statearr_18919_18942 = state_18908__$1;
(statearr_18919_18942[(2)] = inst_18903);

(statearr_18919_18942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (2))){
var _ = (function (){var statearr_18920 = state_18908;
(statearr_18920[(4)] = cljs.core.cons.call(null,(5),(state_18908[(4)])));

return statearr_18920;
})();
var inst_18869 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_18908__$1 = state_18908;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18908__$1,(6),inst_18869);
} else {
if((state_val_18909 === (11))){
var state_18908__$1 = state_18908;
var statearr_18922_18943 = state_18908__$1;
(statearr_18922_18943[(2)] = null);

(statearr_18922_18943[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (9))){
var inst_18872 = (state_18908[(9)]);
var inst_18883 = (state_18908[(2)]);
var inst_18884 = fluree.db.util.core.exception_QMARK_.call(null,inst_18872);
var state_18908__$1 = (function (){var statearr_18923 = state_18908;
(statearr_18923[(10)] = inst_18883);

return statearr_18923;
})();
if(inst_18884){
var statearr_18924_18944 = state_18908__$1;
(statearr_18924_18944[(1)] = (10));

} else {
var statearr_18925_18945 = state_18908__$1;
(statearr_18925_18945[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (5))){
var _ = (function (){var statearr_18926 = state_18908;
(statearr_18926[(4)] = cljs.core.rest.call(null,(state_18908[(4)])));

return statearr_18926;
})();
var state_18908__$1 = state_18908;
var ex18921 = (state_18908__$1[(2)]);
var statearr_18927_18946 = state_18908__$1;
(statearr_18927_18946[(5)] = ex18921);


var statearr_18928_18947 = state_18908__$1;
(statearr_18928_18947[(1)] = (4));

(statearr_18928_18947[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (10))){
var inst_18872 = (state_18908[(9)]);
var inst_18886 = (function(){throw inst_18872})();
var state_18908__$1 = state_18908;
var statearr_18929_18948 = state_18908__$1;
(statearr_18929_18948[(2)] = inst_18886);

(statearr_18929_18948[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18909 === (8))){
var state_18908__$1 = state_18908;
var statearr_18930_18949 = state_18908__$1;
(statearr_18930_18949[(2)] = null);

(statearr_18930_18949[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2703__auto____0 = (function (){
var statearr_18931 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18931[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2703__auto__);

(statearr_18931[(1)] = (1));

return statearr_18931;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2703__auto____1 = (function (state_18908){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18932){var ex__2706__auto__ = e18932;
var statearr_18933_18950 = state_18908;
(statearr_18933_18950[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18908[(4)]))){
var statearr_18934_18951 = state_18908;
(statearr_18934_18951[(1)] = cljs.core.first.call(null,(state_18908[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18952 = state_18908;
state_18908 = G__18952;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2703__auto__ = function(state_18908){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2703__auto____1.call(this,state_18908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2703__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2703__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18935 = f__2726__auto__.call(null);
(statearr_18935[(6)] = c__2725__auto___18936);

return statearr_18935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_18973){
var state_val_18974 = (state_18973[(1)]);
if((state_val_18974 === (7))){
var state_18973__$1 = state_18973;
var statearr_18975_18995 = state_18973__$1;
(statearr_18975_18995[(2)] = null);

(statearr_18975_18995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18974 === (1))){
var state_18973__$1 = state_18973;
var statearr_18976_18996 = state_18973__$1;
(statearr_18976_18996[(2)] = null);

(statearr_18976_18996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18974 === (4))){
var inst_18953 = (state_18973[(2)]);
var state_18973__$1 = state_18973;
var statearr_18977_18997 = state_18973__$1;
(statearr_18977_18997[(2)] = inst_18953);

(statearr_18977_18997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18974 === (6))){
var inst_18959 = (state_18973[(7)]);
var inst_18961 = fluree.db.storage.core.serde.call(null,conn);
var state_18973__$1 = (function (){var statearr_18978 = state_18973;
(statearr_18978[(8)] = inst_18961);

return statearr_18978;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18973__$1,(9),inst_18959);
} else {
if((state_val_18974 === (3))){
var inst_18971 = (state_18973[(2)]);
var state_18973__$1 = state_18973;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18973__$1,inst_18971);
} else {
if((state_val_18974 === (2))){
var inst_18959 = (state_18973[(7)]);
var _ = (function (){var statearr_18980 = state_18973;
(statearr_18980[(4)] = cljs.core.cons.call(null,(5),(state_18973[(4)])));

return statearr_18980;
})();
var inst_18959__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18973__$1 = (function (){var statearr_18981 = state_18973;
(statearr_18981[(7)] = inst_18959__$1);

return statearr_18981;
})();
if(cljs.core.truth_(inst_18959__$1)){
var statearr_18982_18998 = state_18973__$1;
(statearr_18982_18998[(1)] = (6));

} else {
var statearr_18983_18999 = state_18973__$1;
(statearr_18983_18999[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18974 === (9))){
var inst_18961 = (state_18973[(8)]);
var inst_18963 = (state_18973[(2)]);
var inst_18964 = fluree.db.util.async.throw_err.call(null,inst_18963);
var inst_18965 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_18961,inst_18964);
var state_18973__$1 = state_18973;
var statearr_18984_19000 = state_18973__$1;
(statearr_18984_19000[(2)] = inst_18965);

(statearr_18984_19000[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18974 === (5))){
var _ = (function (){var statearr_18985 = state_18973;
(statearr_18985[(4)] = cljs.core.rest.call(null,(state_18973[(4)])));

return statearr_18985;
})();
var state_18973__$1 = state_18973;
var ex18979 = (state_18973__$1[(2)]);
var statearr_18986_19001 = state_18973__$1;
(statearr_18986_19001[(5)] = ex18979);


if((ex18979 instanceof Error)){
var statearr_18987_19002 = state_18973__$1;
(statearr_18987_19002[(1)] = (4));

(statearr_18987_19002[(5)] = null);

} else {
throw ex18979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18974 === (8))){
var inst_18968 = (state_18973[(2)]);
var _ = (function (){var statearr_18988 = state_18973;
(statearr_18988[(4)] = cljs.core.rest.call(null,(state_18973[(4)])));

return statearr_18988;
})();
var state_18973__$1 = state_18973;
var statearr_18989_19003 = state_18973__$1;
(statearr_18989_19003[(2)] = inst_18968);

(statearr_18989_19003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2703__auto____0 = (function (){
var statearr_18990 = [null,null,null,null,null,null,null,null,null];
(statearr_18990[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2703__auto__);

(statearr_18990[(1)] = (1));

return statearr_18990;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2703__auto____1 = (function (state_18973){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_18973);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e18991){var ex__2706__auto__ = e18991;
var statearr_18992_19004 = state_18973;
(statearr_18992_19004[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_18973[(4)]))){
var statearr_18993_19005 = state_18973;
(statearr_18993_19005[(1)] = cljs.core.first.call(null,(state_18973[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19006 = state_18973;
state_18973 = G__19006;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2703__auto__ = function(state_18973){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2703__auto____1.call(this,state_18973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2703__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2703__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_18994 = f__2726__auto__.call(null);
(statearr_18994[(6)] = c__2725__auto__);

return statearr_18994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2725__auto___19079 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19051){
var state_val_19052 = (state_19051[(1)]);
if((state_val_19052 === (7))){
var inst_19023 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_19024 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19025 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_19026 = cljs.core.PersistentHashMap.fromArrays(inst_19024,inst_19025);
var inst_19027 = cljs.core.ex_info.call(null,inst_19023,inst_19026);
var inst_19028 = (function(){throw inst_19027})();
var state_19051__$1 = state_19051;
var statearr_19053_19080 = state_19051__$1;
(statearr_19053_19080[(2)] = inst_19028);

(statearr_19053_19080[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (1))){
var state_19051__$1 = state_19051;
var statearr_19054_19081 = state_19051__$1;
(statearr_19054_19081[(2)] = null);

(statearr_19054_19081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (4))){
var inst_19007 = (state_19051[(2)]);
var inst_19008 = error_fn.call(null);
var inst_19009 = cljs.core.async.put_BANG_.call(null,return_ch,inst_19007);
var inst_19010 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_19051__$1 = (function (){var statearr_19055 = state_19051;
(statearr_19055[(7)] = inst_19008);

(statearr_19055[(8)] = inst_19009);

return statearr_19055;
})();
var statearr_19056_19082 = state_19051__$1;
(statearr_19056_19082[(2)] = inst_19010);

(statearr_19056_19082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (6))){
var inst_19020 = (state_19051[(9)]);
var inst_19020__$1 = (state_19051[(2)]);
var inst_19021 = (inst_19020__$1 == null);
var state_19051__$1 = (function (){var statearr_19057 = state_19051;
(statearr_19057[(9)] = inst_19020__$1);

return statearr_19057;
})();
if(cljs.core.truth_(inst_19021)){
var statearr_19058_19083 = state_19051__$1;
(statearr_19058_19083[(1)] = (7));

} else {
var statearr_19059_19084 = state_19051__$1;
(statearr_19059_19084[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (3))){
var inst_19049 = (state_19051[(2)]);
var state_19051__$1 = state_19051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19051__$1,inst_19049);
} else {
if((state_val_19052 === (12))){
var inst_19020 = (state_19051[(9)]);
var inst_19037 = (state_19051[(2)]);
var inst_19038 = cljs.core.__destructure_map.call(null,inst_19020);
var inst_19039 = cljs.core.get.call(null,inst_19038,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_19040 = cljs.core.get.call(null,inst_19038,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_19041 = config;
var inst_19042 = cljs.core.__destructure_map.call(null,inst_19041);
var inst_19043 = cljs.core.get.call(null,inst_19042,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_19044 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_19043,inst_19039);
var inst_19045 = fluree.db.index.data_node.call(null,block,t,inst_19044,rhs,config);
var inst_19046 = cljs.core.async.put_BANG_.call(null,return_ch,inst_19045);
var _ = (function (){var statearr_19060 = state_19051;
(statearr_19060[(4)] = cljs.core.rest.call(null,(state_19051[(4)])));

return statearr_19060;
})();
var state_19051__$1 = (function (){var statearr_19061 = state_19051;
(statearr_19061[(10)] = inst_19037);

(statearr_19061[(11)] = inst_19040);

return statearr_19061;
})();
var statearr_19062_19085 = state_19051__$1;
(statearr_19062_19085[(2)] = inst_19046);

(statearr_19062_19085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (2))){
var _ = (function (){var statearr_19063 = state_19051;
(statearr_19063[(4)] = cljs.core.cons.call(null,(5),(state_19051[(4)])));

return statearr_19063;
})();
var inst_19018 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_19051__$1 = state_19051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19051__$1,(6),inst_19018);
} else {
if((state_val_19052 === (11))){
var state_19051__$1 = state_19051;
var statearr_19065_19086 = state_19051__$1;
(statearr_19065_19086[(2)] = null);

(statearr_19065_19086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (9))){
var inst_19020 = (state_19051[(9)]);
var inst_19031 = (state_19051[(2)]);
var inst_19032 = fluree.db.util.core.exception_QMARK_.call(null,inst_19020);
var state_19051__$1 = (function (){var statearr_19066 = state_19051;
(statearr_19066[(12)] = inst_19031);

return statearr_19066;
})();
if(inst_19032){
var statearr_19067_19087 = state_19051__$1;
(statearr_19067_19087[(1)] = (10));

} else {
var statearr_19068_19088 = state_19051__$1;
(statearr_19068_19088[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (5))){
var _ = (function (){var statearr_19069 = state_19051;
(statearr_19069[(4)] = cljs.core.rest.call(null,(state_19051[(4)])));

return statearr_19069;
})();
var state_19051__$1 = state_19051;
var ex19064 = (state_19051__$1[(2)]);
var statearr_19070_19089 = state_19051__$1;
(statearr_19070_19089[(5)] = ex19064);


var statearr_19071_19090 = state_19051__$1;
(statearr_19071_19090[(1)] = (4));

(statearr_19071_19090[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (10))){
var inst_19020 = (state_19051[(9)]);
var inst_19034 = (function(){throw inst_19020})();
var state_19051__$1 = state_19051;
var statearr_19072_19091 = state_19051__$1;
(statearr_19072_19091[(2)] = inst_19034);

(statearr_19072_19091[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19052 === (8))){
var state_19051__$1 = state_19051;
var statearr_19073_19092 = state_19051__$1;
(statearr_19073_19092[(2)] = null);

(statearr_19073_19092[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto____0 = (function (){
var statearr_19074 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19074[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto__);

(statearr_19074[(1)] = (1));

return statearr_19074;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto____1 = (function (state_19051){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19075){var ex__2706__auto__ = e19075;
var statearr_19076_19093 = state_19051;
(statearr_19076_19093[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19051[(4)]))){
var statearr_19077_19094 = state_19051;
(statearr_19077_19094[(1)] = cljs.core.first.call(null,(state_19051[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19095 = state_19051;
state_19051 = G__19095;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto__ = function(state_19051){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto____1.call(this,state_19051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19078 = f__2726__auto__.call(null);
(statearr_19078[(6)] = c__2725__auto___19079);

return statearr_19078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k19097,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__19101 = k19097;
var G__19101__$1 = (((G__19101 instanceof cljs.core.Keyword))?G__19101.fqn:null);
switch (G__19101__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19097,else__5346__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__19102){
var vec__19103 = p__19102;
var k__5367__auto__ = cljs.core.nth.call(null,vec__19103,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__19103,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19096){
var self__ = this;
var G__19096__$1 = this;
return (new cljs.core.RecordIter((0),G__19096__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19098,other19099){
var self__ = this;
var this19098__$1 = this;
return (((!((other19099 == null)))) && ((((this19098__$1.constructor === other19099.constructor)) && (((cljs.core._EQ_.call(null,this19098__$1.conn,other19099.conn)) && (((cljs.core._EQ_.call(null,this19098__$1.config,other19099.config)) && (((cljs.core._EQ_.call(null,this19098__$1.network,other19099.network)) && (((cljs.core._EQ_.call(null,this19098__$1.dbid,other19099.dbid)) && (((cljs.core._EQ_.call(null,this19098__$1.id,other19099.id)) && (((cljs.core._EQ_.call(null,this19098__$1.leaf,other19099.leaf)) && (((cljs.core._EQ_.call(null,this19098__$1.first,other19099.first)) && (((cljs.core._EQ_.call(null,this19098__$1.rhs,other19099.rhs)) && (((cljs.core._EQ_.call(null,this19098__$1.size,other19099.size)) && (((cljs.core._EQ_.call(null,this19098__$1.block,other19099.block)) && (((cljs.core._EQ_.call(null,this19098__$1.t,other19099.t)) && (((cljs.core._EQ_.call(null,this19098__$1.tt_id,other19099.tt_id)) && (((cljs.core._EQ_.call(null,this19098__$1.leftmost_QMARK_,other19099.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this19098__$1.tempid,other19099.tempid)) && (cljs.core._EQ_.call(null,this19098__$1.__extmap,other19099.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k19097){
var self__ = this;
var this__5350__auto____$1 = this;
var G__19106 = k19097;
var G__19106__$1 = (((G__19106 instanceof cljs.core.Keyword))?G__19106.fqn:null);
switch (G__19106__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k19097);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__19096){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__19107 = cljs.core.keyword_identical_QMARK_;
var expr__19108 = k__5352__auto__;
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(G__19096,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__19096,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__19096,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__19096,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__19096,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__19096,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__19096,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__19096,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__19096,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__19096,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__19096,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__19096,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__19096,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19107.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__19108))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__19096,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__19096),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__19096){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__19096,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__19100){
var extmap__5385__auto__ = (function (){var G__19110 = cljs.core.dissoc.call(null,G__19100,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__19100)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19110);
} else {
return G__19110;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__19100),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__19100),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__5045__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__19113 = blank_db;
var map__19113__$1 = cljs.core.__destructure_map.call(null,map__19113);
var network = cljs.core.get.call(null,map__19113__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__19113__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__19113__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__19114 = root_data;
var map__19114__$1 = cljs.core.__destructure_map.call(null,map__19114);
var block = cljs.core.get.call(null,map__19114__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__19114__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__19114__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__19114__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19136){
var state_val_19137 = (state_19136[(1)]);
if((state_val_19137 === (7))){
var state_19136__$1 = state_19136;
var statearr_19138_19158 = state_19136__$1;
(statearr_19138_19158[(2)] = null);

(statearr_19138_19158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19137 === (1))){
var state_19136__$1 = state_19136;
var statearr_19139_19159 = state_19136__$1;
(statearr_19139_19159[(2)] = null);

(statearr_19139_19159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19137 === (4))){
var inst_19115 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
var statearr_19140_19160 = state_19136__$1;
(statearr_19140_19160[(2)] = inst_19115);

(statearr_19140_19160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19137 === (6))){
var inst_19122 = (state_19136[(7)]);
var inst_19124 = fluree.db.storage.core.serde.call(null,conn);
var state_19136__$1 = (function (){var statearr_19141 = state_19136;
(statearr_19141[(8)] = inst_19124);

return statearr_19141;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19136__$1,(9),inst_19122);
} else {
if((state_val_19137 === (3))){
var inst_19134 = (state_19136[(2)]);
var state_19136__$1 = state_19136;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19136__$1,inst_19134);
} else {
if((state_val_19137 === (2))){
var inst_19122 = (state_19136[(7)]);
var _ = (function (){var statearr_19143 = state_19136;
(statearr_19143[(4)] = cljs.core.cons.call(null,(5),(state_19136[(4)])));

return statearr_19143;
})();
var inst_19121 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_19122__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_19121);
var state_19136__$1 = (function (){var statearr_19144 = state_19136;
(statearr_19144[(7)] = inst_19122__$1);

return statearr_19144;
})();
if(cljs.core.truth_(inst_19122__$1)){
var statearr_19145_19161 = state_19136__$1;
(statearr_19145_19161[(1)] = (6));

} else {
var statearr_19146_19162 = state_19136__$1;
(statearr_19146_19162[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19137 === (9))){
var inst_19124 = (state_19136[(8)]);
var inst_19126 = (state_19136[(2)]);
var inst_19127 = fluree.db.util.async.throw_err.call(null,inst_19126);
var inst_19128 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_19124,inst_19127);
var state_19136__$1 = state_19136;
var statearr_19147_19163 = state_19136__$1;
(statearr_19147_19163[(2)] = inst_19128);

(statearr_19147_19163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19137 === (5))){
var _ = (function (){var statearr_19148 = state_19136;
(statearr_19148[(4)] = cljs.core.rest.call(null,(state_19136[(4)])));

return statearr_19148;
})();
var state_19136__$1 = state_19136;
var ex19142 = (state_19136__$1[(2)]);
var statearr_19149_19164 = state_19136__$1;
(statearr_19149_19164[(5)] = ex19142);


if((ex19142 instanceof Error)){
var statearr_19150_19165 = state_19136__$1;
(statearr_19150_19165[(1)] = (4));

(statearr_19150_19165[(5)] = null);

} else {
throw ex19142;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19137 === (8))){
var inst_19131 = (state_19136[(2)]);
var _ = (function (){var statearr_19151 = state_19136;
(statearr_19151[(4)] = cljs.core.rest.call(null,(state_19136[(4)])));

return statearr_19151;
})();
var state_19136__$1 = state_19136;
var statearr_19152_19166 = state_19136__$1;
(statearr_19152_19166[(2)] = inst_19131);

(statearr_19152_19166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2703__auto____0 = (function (){
var statearr_19153 = [null,null,null,null,null,null,null,null,null];
(statearr_19153[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2703__auto__);

(statearr_19153[(1)] = (1));

return statearr_19153;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2703__auto____1 = (function (state_19136){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19136);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19154){var ex__2706__auto__ = e19154;
var statearr_19155_19167 = state_19136;
(statearr_19155_19167[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19136[(4)]))){
var statearr_19156_19168 = state_19136;
(statearr_19156_19168[(1)] = cljs.core.first.call(null,(state_19136[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19169 = state_19136;
state_19136 = G__19169;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2703__auto__ = function(state_19136){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2703__auto____1.call(this,state_19136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2703__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2703__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19157 = f__2726__auto__.call(null);
(statearr_19157[(6)] = c__2725__auto__);

return statearr_19157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19191){
var state_val_19192 = (state_19191[(1)]);
if((state_val_19192 === (7))){
var inst_19180 = (state_19191[(7)]);
var inst_19182 = fluree.db.storage.core.serde.call(null,conn);
var inst_19183 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_19182,inst_19180);
var state_19191__$1 = state_19191;
var statearr_19193_19212 = state_19191__$1;
(statearr_19193_19212[(2)] = inst_19183);

(statearr_19193_19212[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19192 === (1))){
var state_19191__$1 = state_19191;
var statearr_19194_19213 = state_19191__$1;
(statearr_19194_19213[(2)] = null);

(statearr_19194_19213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19192 === (4))){
var inst_19170 = (state_19191[(2)]);
var state_19191__$1 = state_19191;
var statearr_19195_19214 = state_19191__$1;
(statearr_19195_19214[(2)] = inst_19170);

(statearr_19195_19214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19192 === (6))){
var inst_19180 = (state_19191[(7)]);
var inst_19179 = (state_19191[(2)]);
var inst_19180__$1 = fluree.db.util.async.throw_err.call(null,inst_19179);
var state_19191__$1 = (function (){var statearr_19196 = state_19191;
(statearr_19196[(7)] = inst_19180__$1);

return statearr_19196;
})();
if(cljs.core.truth_(inst_19180__$1)){
var statearr_19197_19215 = state_19191__$1;
(statearr_19197_19215[(1)] = (7));

} else {
var statearr_19198_19216 = state_19191__$1;
(statearr_19198_19216[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19192 === (3))){
var inst_19189 = (state_19191[(2)]);
var state_19191__$1 = state_19191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19191__$1,inst_19189);
} else {
if((state_val_19192 === (2))){
var _ = (function (){var statearr_19200 = state_19191;
(statearr_19200[(4)] = cljs.core.cons.call(null,(5),(state_19191[(4)])));

return statearr_19200;
})();
var inst_19176 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_19177 = fluree.db.storage.core.storage_read.call(null,conn,inst_19176);
var state_19191__$1 = state_19191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19191__$1,(6),inst_19177);
} else {
if((state_val_19192 === (9))){
var inst_19186 = (state_19191[(2)]);
var _ = (function (){var statearr_19201 = state_19191;
(statearr_19201[(4)] = cljs.core.rest.call(null,(state_19191[(4)])));

return statearr_19201;
})();
var state_19191__$1 = state_19191;
var statearr_19202_19217 = state_19191__$1;
(statearr_19202_19217[(2)] = inst_19186);

(statearr_19202_19217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19192 === (5))){
var _ = (function (){var statearr_19203 = state_19191;
(statearr_19203[(4)] = cljs.core.rest.call(null,(state_19191[(4)])));

return statearr_19203;
})();
var state_19191__$1 = state_19191;
var ex19199 = (state_19191__$1[(2)]);
var statearr_19204_19218 = state_19191__$1;
(statearr_19204_19218[(5)] = ex19199);


if((ex19199 instanceof Error)){
var statearr_19205_19219 = state_19191__$1;
(statearr_19205_19219[(1)] = (4));

(statearr_19205_19219[(5)] = null);

} else {
throw ex19199;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19192 === (8))){
var state_19191__$1 = state_19191;
var statearr_19206_19220 = state_19191__$1;
(statearr_19206_19220[(2)] = null);

(statearr_19206_19220[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2703__auto____0 = (function (){
var statearr_19207 = [null,null,null,null,null,null,null,null];
(statearr_19207[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2703__auto__);

(statearr_19207[(1)] = (1));

return statearr_19207;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2703__auto____1 = (function (state_19191){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19208){var ex__2706__auto__ = e19208;
var statearr_19209_19221 = state_19191;
(statearr_19209_19221[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19191[(4)]))){
var statearr_19210_19222 = state_19191;
(statearr_19210_19222[(1)] = cljs.core.first.call(null,(state_19191[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19223 = state_19191;
state_19191 = G__19223;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2703__auto__ = function(state_19191){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2703__auto____1.call(this,state_19191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2703__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2703__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19211 = f__2726__auto__.call(null);
(statearr_19211[(6)] = c__2725__auto__);

return statearr_19211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19259){
var state_val_19260 = (state_19259[(1)]);
if((state_val_19260 === (7))){
var inst_19233 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_19234 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19235 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_19236 = cljs.core.PersistentHashMap.fromArrays(inst_19234,inst_19235);
var inst_19237 = cljs.core.ex_info.call(null,inst_19233,inst_19236);
var inst_19238 = (function(){throw inst_19237})();
var state_19259__$1 = state_19259;
var statearr_19261_19283 = state_19259__$1;
(statearr_19261_19283[(2)] = inst_19238);

(statearr_19261_19283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19260 === (1))){
var state_19259__$1 = state_19259;
var statearr_19262_19284 = state_19259__$1;
(statearr_19262_19284[(2)] = null);

(statearr_19262_19284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19260 === (4))){
var inst_19224 = (state_19259[(2)]);
var state_19259__$1 = state_19259;
var statearr_19263_19285 = state_19259__$1;
(statearr_19263_19285[(2)] = inst_19224);

(statearr_19263_19285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19260 === (6))){
var state_19259__$1 = state_19259;
var statearr_19264_19286 = state_19259__$1;
(statearr_19264_19286[(2)] = null);

(statearr_19264_19286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19260 === (3))){
var inst_19257 = (state_19259[(2)]);
var state_19259__$1 = state_19259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19259__$1,inst_19257);
} else {
if((state_val_19260 === (2))){
var inst_19230 = (state_19259[(7)]);
var _ = (function (){var statearr_19265 = state_19259;
(statearr_19265[(4)] = cljs.core.cons.call(null,(5),(state_19259[(4)])));

return statearr_19265;
})();
var inst_19230__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_19259__$1 = (function (){var statearr_19266 = state_19259;
(statearr_19266[(7)] = inst_19230__$1);

return statearr_19266;
})();
if(cljs.core.truth_(inst_19230__$1)){
var statearr_19267_19287 = state_19259__$1;
(statearr_19267_19287[(1)] = (6));

} else {
var statearr_19268_19288 = state_19259__$1;
(statearr_19268_19288[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19260 === (11))){
var inst_19249 = (state_19259[(8)]);
var inst_19252 = (state_19259[(2)]);
var inst_19253 = fluree.db.util.async.throw_err.call(null,inst_19252);
var inst_19254 = cljs.core.assoc.call(null,inst_19249,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_19253);
var _ = (function (){var statearr_19270 = state_19259;
(statearr_19270[(4)] = cljs.core.rest.call(null,(state_19259[(4)])));

return statearr_19270;
})();
var state_19259__$1 = state_19259;
var statearr_19271_19289 = state_19259__$1;
(statearr_19271_19289[(2)] = inst_19254);

(statearr_19271_19289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19260 === (9))){
var inst_19244 = (state_19259[(9)]);
var inst_19242 = (state_19259[(2)]);
var inst_19243 = fluree.db.util.async.throw_err.call(null,inst_19242);
var inst_19244__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_19243);
var inst_19245 = fluree.db.query.schema.schema_map.call(null,inst_19244__$1);
var state_19259__$1 = (function (){var statearr_19272 = state_19259;
(statearr_19272[(9)] = inst_19244__$1);

return statearr_19272;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19259__$1,(10),inst_19245);
} else {
if((state_val_19260 === (5))){
var _ = (function (){var statearr_19273 = state_19259;
(statearr_19273[(4)] = cljs.core.rest.call(null,(state_19259[(4)])));

return statearr_19273;
})();
var state_19259__$1 = state_19259;
var ex19269 = (state_19259__$1[(2)]);
var statearr_19274_19290 = state_19259__$1;
(statearr_19274_19290[(5)] = ex19269);


if((ex19269 instanceof Error)){
var statearr_19275_19291 = state_19259__$1;
(statearr_19275_19291[(1)] = (4));

(statearr_19275_19291[(5)] = null);

} else {
throw ex19269;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19260 === (10))){
var inst_19244 = (state_19259[(9)]);
var inst_19249 = (state_19259[(8)]);
var inst_19247 = (state_19259[(2)]);
var inst_19248 = fluree.db.util.async.throw_err.call(null,inst_19247);
var inst_19249__$1 = cljs.core.assoc.call(null,inst_19244,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_19248);
var inst_19250 = fluree.db.query.schema.setting_map.call(null,inst_19249__$1);
var state_19259__$1 = (function (){var statearr_19276 = state_19259;
(statearr_19276[(8)] = inst_19249__$1);

return statearr_19276;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19259__$1,(11),inst_19250);
} else {
if((state_val_19260 === (8))){
var inst_19230 = (state_19259[(7)]);
var inst_19240 = (state_19259[(2)]);
var state_19259__$1 = (function (){var statearr_19277 = state_19259;
(statearr_19277[(10)] = inst_19240);

return statearr_19277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19259__$1,(9),inst_19230);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2703__auto____0 = (function (){
var statearr_19278 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19278[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2703__auto__);

(statearr_19278[(1)] = (1));

return statearr_19278;
});
var fluree$db$storage$core$reify_db_$_state_machine__2703__auto____1 = (function (state_19259){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19279){var ex__2706__auto__ = e19279;
var statearr_19280_19292 = state_19259;
(statearr_19280_19292[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19259[(4)]))){
var statearr_19281_19293 = state_19259;
(statearr_19281_19293[(1)] = cljs.core.first.call(null,(state_19259[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19294 = state_19259;
state_19259 = G__19294;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2703__auto__ = function(state_19259){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2703__auto____1.call(this,state_19259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2703__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2703__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19282 = f__2726__auto__.call(null);
(statearr_19282[(6)] = c__2725__auto__);

return statearr_19282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__19296 = arguments.length;
switch (G__19296) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19349){
var state_val_19350 = (state_19349[(1)]);
if((state_val_19350 === (7))){
var inst_19306 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_19307 = (new Error(inst_19306));
var inst_19308 = (function(){throw inst_19307})();
var state_19349__$1 = state_19349;
var statearr_19351_19391 = state_19349__$1;
(statearr_19351_19391[(2)] = inst_19308);

(statearr_19351_19391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (20))){
var inst_19340 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
var statearr_19352_19392 = state_19349__$1;
(statearr_19352_19392[(2)] = inst_19340);

(statearr_19352_19392[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (1))){
var state_19349__$1 = state_19349;
var statearr_19353_19393 = state_19349__$1;
(statearr_19353_19393[(2)] = null);

(statearr_19353_19393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (4))){
var inst_19297 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
var statearr_19354_19394 = state_19349__$1;
(statearr_19354_19394[(2)] = inst_19297);

(statearr_19354_19394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (15))){
var inst_19315 = (state_19349[(7)]);
var state_19349__$1 = state_19349;
var statearr_19355_19395 = state_19349__$1;
(statearr_19355_19395[(2)] = inst_19315);

(statearr_19355_19395[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (21))){
var inst_19314 = (state_19349[(8)]);
var inst_19315 = (state_19349[(7)]);
var inst_19319 = (state_19349[(9)]);
var inst_19333 = (inst_19314 + (1));
var inst_19334 = cljs.core.conj.call(null,inst_19315,inst_19319);
var inst_19314__$1 = inst_19333;
var inst_19315__$1 = inst_19334;
var state_19349__$1 = (function (){var statearr_19356 = state_19349;
(statearr_19356[(8)] = inst_19314__$1);

(statearr_19356[(7)] = inst_19315__$1);

return statearr_19356;
})();
var statearr_19357_19396 = state_19349__$1;
(statearr_19357_19396[(2)] = null);

(statearr_19357_19396[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (13))){
var inst_19319 = (state_19349[(9)]);
var inst_19323 = (inst_19319 instanceof Error);
var state_19349__$1 = state_19349;
var statearr_19358_19397 = state_19349__$1;
(statearr_19358_19397[(2)] = inst_19323);

(statearr_19358_19397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (22))){
var state_19349__$1 = state_19349;
var statearr_19359_19398 = state_19349__$1;
(statearr_19359_19398[(2)] = null);

(statearr_19359_19398[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (6))){
var state_19349__$1 = state_19349;
var statearr_19360_19399 = state_19349__$1;
(statearr_19360_19399[(2)] = null);

(statearr_19360_19399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (17))){
var inst_19342 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
var statearr_19361_19400 = state_19349__$1;
(statearr_19361_19400[(2)] = inst_19342);

(statearr_19361_19400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (3))){
var inst_19347 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19349__$1,inst_19347);
} else {
if((state_val_19350 === (12))){
var inst_19320 = (state_19349[(10)]);
var state_19349__$1 = state_19349;
var statearr_19362_19401 = state_19349__$1;
(statearr_19362_19401[(2)] = inst_19320);

(statearr_19362_19401[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (2))){
var _ = (function (){var statearr_19363 = state_19349;
(statearr_19363[(4)] = cljs.core.cons.call(null,(5),(state_19349[(4)])));

return statearr_19363;
})();
var inst_19303 = (end >= start);
var state_19349__$1 = state_19349;
if(cljs.core.truth_(inst_19303)){
var statearr_19364_19402 = state_19349__$1;
(statearr_19364_19402[(1)] = (6));

} else {
var statearr_19365_19403 = state_19349__$1;
(statearr_19365_19403[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (23))){
var inst_19338 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
var statearr_19366_19404 = state_19349__$1;
(statearr_19366_19404[(2)] = inst_19338);

(statearr_19366_19404[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (19))){
var state_19349__$1 = state_19349;
var statearr_19367_19405 = state_19349__$1;
(statearr_19367_19405[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (11))){
var inst_19319 = (state_19349[(9)]);
var inst_19320 = (state_19349[(10)]);
var inst_19319__$1 = (state_19349[(2)]);
var inst_19320__$1 = (inst_19319__$1 == null);
var state_19349__$1 = (function (){var statearr_19370 = state_19349;
(statearr_19370[(9)] = inst_19319__$1);

(statearr_19370[(10)] = inst_19320__$1);

return statearr_19370;
})();
if(cljs.core.truth_(inst_19320__$1)){
var statearr_19371_19406 = state_19349__$1;
(statearr_19371_19406[(1)] = (12));

} else {
var statearr_19372_19407 = state_19349__$1;
(statearr_19372_19407[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (9))){
var inst_19314 = (state_19349[(8)]);
var inst_19317 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_19314);
var state_19349__$1 = state_19349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19349__$1,(11),inst_19317);
} else {
if((state_val_19350 === (5))){
var _ = (function (){var statearr_19373 = state_19349;
(statearr_19373[(4)] = cljs.core.rest.call(null,(state_19349[(4)])));

return statearr_19373;
})();
var state_19349__$1 = state_19349;
var ex19369 = (state_19349__$1[(2)]);
var statearr_19374_19408 = state_19349__$1;
(statearr_19374_19408[(5)] = ex19369);


if((ex19369 instanceof Error)){
var statearr_19375_19409 = state_19349__$1;
(statearr_19375_19409[(1)] = (4));

(statearr_19375_19409[(5)] = null);

} else {
throw ex19369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (14))){
var inst_19325 = (state_19349[(2)]);
var state_19349__$1 = state_19349;
if(cljs.core.truth_(inst_19325)){
var statearr_19376_19410 = state_19349__$1;
(statearr_19376_19410[(1)] = (15));

} else {
var statearr_19377_19411 = state_19349__$1;
(statearr_19377_19411[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (16))){
var inst_19314 = (state_19349[(8)]);
var inst_19328 = cljs.core._EQ_.call(null,inst_19314,end);
var state_19349__$1 = state_19349;
if(inst_19328){
var statearr_19378_19412 = state_19349__$1;
(statearr_19378_19412[(1)] = (18));

} else {
var statearr_19379_19413 = state_19349__$1;
(statearr_19379_19413[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (10))){
var inst_19344 = (state_19349[(2)]);
var _ = (function (){var statearr_19380 = state_19349;
(statearr_19380[(4)] = cljs.core.rest.call(null,(state_19349[(4)])));

return statearr_19380;
})();
var state_19349__$1 = state_19349;
var statearr_19381_19414 = state_19349__$1;
(statearr_19381_19414[(2)] = inst_19344);

(statearr_19381_19414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (18))){
var inst_19315 = (state_19349[(7)]);
var inst_19319 = (state_19349[(9)]);
var inst_19330 = cljs.core.conj.call(null,inst_19315,inst_19319);
var state_19349__$1 = state_19349;
var statearr_19382_19415 = state_19349__$1;
(statearr_19382_19415[(2)] = inst_19330);

(statearr_19382_19415[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19350 === (8))){
var inst_19310 = (state_19349[(2)]);
var inst_19311 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19312 = start;
var inst_19313 = cljs.core.PersistentVector.EMPTY;
var inst_19314 = inst_19312;
var inst_19315 = inst_19313;
var state_19349__$1 = (function (){var statearr_19383 = state_19349;
(statearr_19383[(11)] = inst_19310);

(statearr_19383[(8)] = inst_19314);

(statearr_19383[(12)] = inst_19311);

(statearr_19383[(7)] = inst_19315);

return statearr_19383;
})();
var statearr_19384_19416 = state_19349__$1;
(statearr_19384_19416[(2)] = null);

(statearr_19384_19416[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2703__auto__ = null;
var fluree$db$storage$core$state_machine__2703__auto____0 = (function (){
var statearr_19385 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19385[(0)] = fluree$db$storage$core$state_machine__2703__auto__);

(statearr_19385[(1)] = (1));

return statearr_19385;
});
var fluree$db$storage$core$state_machine__2703__auto____1 = (function (state_19349){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19386){var ex__2706__auto__ = e19386;
var statearr_19387_19417 = state_19349;
(statearr_19387_19417[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19349[(4)]))){
var statearr_19388_19418 = state_19349;
(statearr_19388_19418[(1)] = cljs.core.first.call(null,(state_19349[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19419 = state_19349;
state_19349 = G__19419;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2703__auto__ = function(state_19349){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2703__auto____1.call(this,state_19349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2703__auto____0;
fluree$db$storage$core$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2703__auto____1;
return fluree$db$storage$core$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19389 = f__2726__auto__.call(null);
(statearr_19389[(6)] = c__2725__auto__);

return statearr_19389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19435){
var state_val_19436 = (state_19435[(1)]);
if((state_val_19436 === (1))){
var state_19435__$1 = state_19435;
var statearr_19437_19451 = state_19435__$1;
(statearr_19437_19451[(2)] = null);

(statearr_19437_19451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (2))){
var _ = (function (){var statearr_19438 = state_19435;
(statearr_19438[(4)] = cljs.core.cons.call(null,(5),(state_19435[(4)])));

return statearr_19438;
})();
var inst_19426 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_19435__$1 = state_19435;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19435__$1,(6),inst_19426);
} else {
if((state_val_19436 === (3))){
var inst_19433 = (state_19435[(2)]);
var state_19435__$1 = state_19435;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19435__$1,inst_19433);
} else {
if((state_val_19436 === (4))){
var inst_19420 = (state_19435[(2)]);
var state_19435__$1 = state_19435;
var statearr_19440_19452 = state_19435__$1;
(statearr_19440_19452[(2)] = inst_19420);

(statearr_19440_19452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (5))){
var _ = (function (){var statearr_19441 = state_19435;
(statearr_19441[(4)] = cljs.core.rest.call(null,(state_19435[(4)])));

return statearr_19441;
})();
var state_19435__$1 = state_19435;
var ex19439 = (state_19435__$1[(2)]);
var statearr_19442_19453 = state_19435__$1;
(statearr_19442_19453[(5)] = ex19439);


if((ex19439 instanceof Error)){
var statearr_19443_19454 = state_19435__$1;
(statearr_19443_19454[(1)] = (4));

(statearr_19443_19454[(5)] = null);

} else {
throw ex19439;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19436 === (6))){
var inst_19428 = (state_19435[(2)]);
var inst_19429 = fluree.db.util.async.throw_err.call(null,inst_19428);
var inst_19430 = cljs.core.first.call(null,inst_19429);
var _ = (function (){var statearr_19444 = state_19435;
(statearr_19444[(4)] = cljs.core.rest.call(null,(state_19435[(4)])));

return statearr_19444;
})();
var state_19435__$1 = state_19435;
var statearr_19445_19455 = state_19435__$1;
(statearr_19445_19455[(2)] = inst_19430);

(statearr_19445_19455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2703__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2703__auto____0 = (function (){
var statearr_19446 = [null,null,null,null,null,null,null];
(statearr_19446[(0)] = fluree$db$storage$core$block_$_state_machine__2703__auto__);

(statearr_19446[(1)] = (1));

return statearr_19446;
});
var fluree$db$storage$core$block_$_state_machine__2703__auto____1 = (function (state_19435){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19447){var ex__2706__auto__ = e19447;
var statearr_19448_19456 = state_19435;
(statearr_19448_19456[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19435[(4)]))){
var statearr_19449_19457 = state_19435;
(statearr_19449_19457[(1)] = cljs.core.first.call(null,(state_19435[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19458 = state_19435;
state_19435 = G__19458;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2703__auto__ = function(state_19435){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2703__auto____1.call(this,state_19435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2703__auto____0;
fluree$db$storage$core$block_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2703__auto____1;
return fluree$db$storage$core$block_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19450 = f__2726__auto__.call(null);
(statearr_19450[(6)] = c__2725__auto__);

return statearr_19450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
