// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs._init_state = (function flureenjs$_init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Follows an subject down the provided path and returns a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,788,null,788,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,788,null,new cljs.core.Symbol(null,"any","any",-948528346,null),788,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,7,531,null,531,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,531,null,new cljs.core.Symbol(null,"any","any",-948528346,null),531,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",16,7,357,null,357,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,357,null,new cljs.core.Symbol(null,"any","any",-948528346,null),357,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,144,null,144,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,144,null,new cljs.core.Symbol(null,"any","any",-948528346,null),144,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,489,null,489,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),489,null,489,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,7,760,null,760,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,760,null,new cljs.core.Symbol(null,"any","any",-948528346,null),760,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,7,669,null,669,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,669,null,new cljs.core.Symbol(null,"any","any",-948528346,null),669,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,555,null,555,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,555,null,new cljs.core.Symbol(null,"any","any",-948528346,null),555,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,411,null,411,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),411,null,new cljs.core.Symbol(null,"any","any",-948528346,null),411,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,7,810,null,810,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,810,null,new cljs.core.Symbol(null,"any","any",-948528346,null),810,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,7,299,null,299,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,299,null,new cljs.core.Symbol(null,"any","any",-948528346,null),299,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,180,null,180,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,180,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),180,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,748,null,748,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,748,null,new cljs.core.Symbol(null,"any","any",-948528346,null),748,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,798,null,798,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,798,null,new cljs.core.Symbol(null,"any","any",-948528346,null),798,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),50,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),50,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,50,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),50,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,424,null,424,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),424,null,new cljs.core.Symbol(null,"any","any",-948528346,null),424,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,604,null,604,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),604,null,new cljs.core.Symbol(null,"any","any",-948528346,null),604,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,476,null,476,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),476,null,new cljs.core.Symbol(null,"any","any",-948528346,null),476,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,281,null,281,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,281,null,new cljs.core.Symbol(null,"any","any",-948528346,null),281,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,311,null,311,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,311,null,new cljs.core.Symbol(null,"any","any",-948528346,null),311,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,7,120,null,120,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,120,null,new cljs.core.Symbol(null,"any","any",-948528346,null),120,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,630,null,630,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,630,null,new cljs.core.Symbol(null,"any","any",-948528346,null),630,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,568,null,568,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,568,null,new cljs.core.Symbol(null,"any","any",-948528346,null),568,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,450,null,450,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),450,null,new cljs.core.Symbol(null,"any","any",-948528346,null),450,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),61,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),61,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,61,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),61,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,7,84,null,84,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,84,null,new cljs.core.Symbol(null,"any","any",-948528346,null),84,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,772,null,772,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),772,null,772,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,398,null,398,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),398,null,new cljs.core.Symbol(null,"any","any",-948528346,null),398,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,643,null,643,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,643,null,new cljs.core.Symbol(null,"any","any",-948528346,null),643,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,7,156,null,156,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,156,null,new cljs.core.Symbol(null,"any","any",-948528346,null),156,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,591,null,591,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),591,null,new cljs.core.Symbol(null,"any","any",-948528346,null),591,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,371,null,371,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns a hash-set of values","9 + count of items in hash-set"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),371,null,new cljs.core.Symbol(null,"any","any",-948528346,null),371,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values","9 + count of items in hash-set"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,254,null,254,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),254,null,new cljs.core.Symbol(null,"any","any",-948528346,null),254,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,7,694,null,694,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,694,null,new cljs.core.Symbol(null,"any","any",-948528346,null),694,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),22,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),22,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,22,new cljs.core.Symbol(null,"any","any",-948528346,null),22,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,212,null,212,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),212,null,212,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,656,null,656,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,656,null,new cljs.core.Symbol(null,"any","any",-948528346,null),656,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,69,null,69,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,69,null,new cljs.core.Symbol(null,"any","any",-948528346,null),69,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,97,null,97,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,97,null,new cljs.core.Symbol(null,"any","any",-948528346,null),97,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,822,null,822,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,822,null,new cljs.core.Symbol(null,"any","any",-948528346,null),822,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,7,681,null,681,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,681,null,new cljs.core.Symbol(null,"any","any",-948528346,null),681,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,109,null,109,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,109,null,new cljs.core.Symbol(null,"any","any",-948528346,null),109,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),617,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,437,null,437,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),437,null,new cljs.core.Symbol(null,"any","any",-948528346,null),437,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,7,168,null,168,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,168,null,new cljs.core.Symbol(null,"any","any",-948528346,null),168,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,7,543,null,543,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,543,null,new cljs.core.Symbol(null,"any","any",-948528346,null),543,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,578,null,578,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),578,null,new cljs.core.Symbol(null,"any","any",-948528346,null),578,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,132,null,132,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),132,null,new cljs.core.Symbol(null,"any","any",-948528346,null),132,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,736,null,736,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,736,null,new cljs.core.Symbol(null,"any","any",-948528346,null),736,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,463,null,463,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),463,null,new cljs.core.Symbol(null,"any","any",-948528346,null),463,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,385,null,385,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),385,null,new cljs.core.Symbol(null,"any","any",-948528346,null),385,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,7,267,null,267,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,267,null,new cljs.core.Symbol(null,"any","any",-948528346,null),267,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,7,324,null,324,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,324,null,new cljs.core.Symbol(null,"any","any",-948528346,null),324,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,225,null,225,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),225,null,225,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),44,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),44,new cljs.core.Keyword(null,"end-column","end-column",1425389514),12,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,44,new cljs.core.Symbol(null,"any","any",-948528346,null),44,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,7,724,null,724,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,724,null,new cljs.core.Symbol(null,"any","any",-948528346,null),724,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),14,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,14,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),14,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,7,706,null,706,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,706,null,new cljs.core.Symbol(null,"any","any",-948528346,null),706,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",20,7,516,null,516,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,516,null,new cljs.core.Symbol(null,"any","any",-948528346,null),516,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,241,null,241,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),241,null,new cljs.core.Symbol(null,"any","any",-948528346,null),241,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,7,199,null,199,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,199,null,new cljs.core.Symbol(null,"any","any",-948528346,null),199,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,7,343,null,343,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,343,null,new cljs.core.Symbol(null,"any","any",-948528346,null),343,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null,cljs.core.PersistentArrayMap.EMPTY]));
});
flureenjs._ns_state = cljs.js.empty_state.call(null,flureenjs._init_state);
var st_50100 = flureenjs._ns_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_50100,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs._app_state !== 'undefined')){
} else {
flureenjs._app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v1.0.0-rc21"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)));
flureenjs._njs_crypto = (function (){try{return require("crypto");
}catch (e50101){var ex = e50101;
fluree.db.util.log.warn.call(null,["Error: Unable to access Node.js crypto module:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join(''));

fluree.db.util.log.warn.call(null,"Private key generation is not available.");

return null;
}})();
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureenjs.setLogging = (function flureenjs$setLogging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__50103 = opts_SINGLEQUOTE_;
var map__50103__$1 = cljs.core.__destructure_map.call(null,map__50103);
var level = cljs.core.get.call(null,map__50103__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.setLogging', flureenjs.setLogging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.accountId = (function flureenjs$accountId(var_args){
var G__50105 = arguments.length;
switch (G__50105) {
case 1:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.accountId', flureenjs.accountId);

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.accountId.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.httpSignature = (function flureenjs$httpSignature(var_args){
var G__50108 = arguments.length;
switch (G__50108) {
case 4:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.httpSignature', flureenjs.httpSignature);

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.httpSignature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.httpSignature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.publicKeyFromPrivate = (function flureenjs$publicKeyFromPrivate(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.publicKeyFromPrivate', flureenjs.publicKeyFromPrivate);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.publicKey = (function flureenjs$publicKey(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.publicKey', flureenjs.publicKey);
/**
 * Generates a private-public key pair using the Node.js
 *     crypto module. The JavaScript code looks like:
 * 
 *        const ecdh = crypto.createECDH('secp256k1');
 *        ecdh.generateKeys()
 *        return { private: ecdh.getPrivateKey('hex'),
 *                 public:  ecdh.getPublicKey('hex','compressed')};
 *     
 */
flureenjs._generate_key_pair = (function flureenjs$_generate_key_pair(){
if(cljs.core.truth_(flureenjs._njs_crypto)){
var ecdh = cljs.core.js_invoke.call(null,flureenjs._njs_crypto,"createECDH","secp256k1");
var _ = cljs.core.js_invoke.call(null,ecdh,"generateKeys");
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),cljs.core.js_invoke.call(null,ecdh,"getPrivateKey","hex"),new cljs.core.Keyword(null,"public","public",1566243851),cljs.core.js_invoke.call(null,ecdh,"getPublicKey","hex","compressed")], null);
} else {
throw "Node.js crypto module not accessible";
}
});
/**
 * Generates a new private key, returned in a map along with
 *    the public key and account id. Return keys are :public,
 *    :private, and :id.
 *    
 */
flureenjs.newPrivateKey = (function flureenjs$newPrivateKey(){
try{var kp = flureenjs._generate_key_pair.call(null);
var account = fluree.crypto.account_id_from_private.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(kp));
return cljs.core.assoc.call(null,kp,new cljs.core.Keyword(null,"id","id",-1388402092),account);
}catch (e50110){var e = e50110;
fluree.db.util.log.error.call(null,["Unable to generate private key. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e)].join(''));

throw e;
}});
goog.exportSymbol('flureenjs.newPrivateKey', flureenjs.newPrivateKey);
/**
 * Returns a signature for a message given a private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or db level.
 *    This will only succeed if signed by the default private key for the tx-group,
 *    or if setting for a ledger-id, either the tx-group or network.
 * 
 *    It will overwrite any existing default private key.
 * 
 *    It will respond with true or false.
 * 
 *    Returns promise that eventually contains the results. 
 */
flureenjs.setDefaultKey = (function flureenjs$setDefaultKey(var_args){
var G__50112 = arguments.length;
switch (G__50112) {
case 2:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.setDefaultKey', flureenjs.setDefaultKey);

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.setDefaultKey.call(null,conn,null,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,ledger_id,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,ledger_id,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,private_key,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50168){
var state_val_50169 = (state_50168[(1)]);
if((state_val_50169 === (7))){
var inst_50127 = (state_50168[(7)]);
var state_50168__$1 = state_50168;
var statearr_50170_50211 = state_50168__$1;
(statearr_50170_50211[(2)] = inst_50127);

(statearr_50170_50211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (20))){
var inst_50139 = (state_50168[(8)]);
var inst_50157 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_50139);
var state_50168__$1 = state_50168;
var statearr_50171_50212 = state_50168__$1;
(statearr_50171_50212[(2)] = inst_50157);

(statearr_50171_50212[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (1))){
var state_50168__$1 = state_50168;
var statearr_50172_50213 = state_50168__$1;
(statearr_50172_50213[(2)] = null);

(statearr_50172_50213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (4))){
var inst_50113 = (state_50168[(2)]);
var inst_50114 = fluree.db.util.log.error.call(null,inst_50113);
var inst_50115 = reject.call(null,inst_50113);
var state_50168__$1 = (function (){var statearr_50173 = state_50168;
(statearr_50173[(9)] = inst_50114);

return statearr_50173;
})();
var statearr_50174_50214 = state_50168__$1;
(statearr_50174_50214[(2)] = inst_50115);

(statearr_50174_50214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (15))){
var inst_50126 = (state_50168[(10)]);
var inst_50145 = (state_50168[(11)]);
var inst_50147 = fluree.crypto.sign_message.call(null,inst_50145,inst_50126);
var state_50168__$1 = state_50168;
var statearr_50175_50215 = state_50168__$1;
(statearr_50175_50215[(2)] = inst_50147);

(statearr_50175_50215[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (21))){
var inst_50159 = (state_50168[(2)]);
var state_50168__$1 = state_50168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50168__$1,(18),inst_50159);
} else {
if((state_val_50169 === (13))){
var state_50168__$1 = state_50168;
var statearr_50176_50216 = state_50168__$1;
(statearr_50176_50216[(2)] = null);

(statearr_50176_50216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (6))){
var inst_50124 = (state_50168[(12)]);
var state_50168__$1 = state_50168;
var statearr_50177_50217 = state_50168__$1;
(statearr_50177_50217[(2)] = inst_50124);

(statearr_50177_50217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (17))){
var inst_50126 = (state_50168[(10)]);
var inst_50150 = (state_50168[(2)]);
var state_50168__$1 = (function (){var statearr_50178 = state_50168;
(statearr_50178[(13)] = inst_50150);

return statearr_50178;
})();
if(cljs.core.truth_(inst_50126)){
var statearr_50179_50218 = state_50168__$1;
(statearr_50179_50218[(1)] = (19));

} else {
var statearr_50180_50219 = state_50168__$1;
(statearr_50180_50219[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (3))){
var inst_50166 = (state_50168[(2)]);
var state_50168__$1 = state_50168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50168__$1,inst_50166);
} else {
if((state_val_50169 === (12))){
var inst_50139 = (state_50168[(8)]);
var inst_50141 = fluree.db.util.core.without_nils.call(null,inst_50139);
var inst_50142 = fluree.db.util.json.stringify.call(null,inst_50141);
var state_50168__$1 = state_50168;
var statearr_50181_50220 = state_50168__$1;
(statearr_50181_50220[(2)] = inst_50142);

(statearr_50181_50220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (2))){
var inst_50124 = (state_50168[(12)]);
var _ = (function (){var statearr_50182 = state_50168;
(statearr_50182[(4)] = cljs.core.cons.call(null,(5),(state_50168[(4)])));

return statearr_50182;
})();
var inst_50122 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_50123 = cljs.core.__destructure_map.call(null,inst_50122);
var inst_50124__$1 = cljs.core.get.call(null,inst_50123,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_50125 = cljs.core.get.call(null,inst_50123,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_50126 = cljs.core.get.call(null,inst_50123,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_50127 = fluree.db.util.core.current_time_millis.call(null);
var state_50168__$1 = (function (){var statearr_50183 = state_50168;
(statearr_50183[(14)] = inst_50125);

(statearr_50183[(10)] = inst_50126);

(statearr_50183[(7)] = inst_50127);

(statearr_50183[(12)] = inst_50124__$1);

return statearr_50183;
})();
if(cljs.core.truth_(inst_50124__$1)){
var statearr_50184_50221 = state_50168__$1;
(statearr_50184_50221[(1)] = (6));

} else {
var statearr_50185_50222 = state_50168__$1;
(statearr_50185_50222[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (19))){
var inst_50150 = (state_50168[(13)]);
var inst_50145 = (state_50168[(11)]);
var inst_50152 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_50153 = [inst_50145,inst_50150];
var inst_50154 = cljs.core.PersistentHashMap.fromArrays(inst_50152,inst_50153);
var inst_50155 = fluree.db.operations.command_async.call(null,conn,inst_50154);
var state_50168__$1 = state_50168;
var statearr_50186_50223 = state_50168__$1;
(statearr_50186_50223[(2)] = inst_50155);

(statearr_50186_50223[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (11))){
var inst_50126 = (state_50168[(10)]);
var inst_50131 = (state_50168[(15)]);
var inst_50136 = (state_50168[(2)]);
var inst_50137 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_50138 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,ledger_id,private_key,inst_50131,inst_50136];
var inst_50139 = cljs.core.PersistentHashMap.fromArrays(inst_50137,inst_50138);
var state_50168__$1 = (function (){var statearr_50188 = state_50168;
(statearr_50188[(8)] = inst_50139);

return statearr_50188;
})();
if(cljs.core.truth_(inst_50126)){
var statearr_50189_50224 = state_50168__$1;
(statearr_50189_50224[(1)] = (12));

} else {
var statearr_50190_50225 = state_50168__$1;
(statearr_50190_50225[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (9))){
var inst_50125 = (state_50168[(14)]);
var state_50168__$1 = state_50168;
var statearr_50191_50226 = state_50168__$1;
(statearr_50191_50226[(2)] = inst_50125);

(statearr_50191_50226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (5))){
var _ = (function (){var statearr_50192 = state_50168;
(statearr_50192[(4)] = cljs.core.rest.call(null,(state_50168[(4)])));

return statearr_50192;
})();
var state_50168__$1 = state_50168;
var ex50187 = (state_50168__$1[(2)]);
var statearr_50193_50227 = state_50168__$1;
(statearr_50193_50227[(5)] = ex50187);


var statearr_50194_50228 = state_50168__$1;
(statearr_50194_50228[(1)] = (4));

(statearr_50194_50228[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (14))){
var inst_50126 = (state_50168[(10)]);
var inst_50145 = (state_50168[(2)]);
var state_50168__$1 = (function (){var statearr_50195 = state_50168;
(statearr_50195[(11)] = inst_50145);

return statearr_50195;
})();
if(cljs.core.truth_(inst_50126)){
var statearr_50196_50229 = state_50168__$1;
(statearr_50196_50229[(1)] = (15));

} else {
var statearr_50197_50230 = state_50168__$1;
(statearr_50197_50230[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (16))){
var state_50168__$1 = state_50168;
var statearr_50198_50231 = state_50168__$1;
(statearr_50198_50231[(2)] = null);

(statearr_50198_50231[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (10))){
var inst_50127 = (state_50168[(7)]);
var inst_50134 = (inst_50127 + (30000));
var state_50168__$1 = state_50168;
var statearr_50199_50232 = state_50168__$1;
(statearr_50199_50232[(2)] = inst_50134);

(statearr_50199_50232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (18))){
var inst_50161 = (state_50168[(2)]);
var inst_50162 = cljs.core.clj__GT_js.call(null,inst_50161);
var inst_50163 = resolve.call(null,inst_50162);
var _ = (function (){var statearr_50200 = state_50168;
(statearr_50200[(4)] = cljs.core.rest.call(null,(state_50168[(4)])));

return statearr_50200;
})();
var state_50168__$1 = state_50168;
var statearr_50201_50233 = state_50168__$1;
(statearr_50201_50233[(2)] = inst_50163);

(statearr_50201_50233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (8))){
var inst_50125 = (state_50168[(14)]);
var inst_50131 = (state_50168[(2)]);
var state_50168__$1 = (function (){var statearr_50202 = state_50168;
(statearr_50202[(15)] = inst_50131);

return statearr_50202;
})();
if(cljs.core.truth_(inst_50125)){
var statearr_50203_50234 = state_50168__$1;
(statearr_50203_50234[(1)] = (9));

} else {
var statearr_50204_50235 = state_50168__$1;
(statearr_50204_50235[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_50205 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50205[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_50205[(1)] = (1));

return statearr_50205;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_50168){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50206){var ex__2724__auto__ = e50206;
var statearr_50207_50236 = state_50168;
(statearr_50207_50236[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50168[(4)]))){
var statearr_50208_50237 = state_50168;
(statearr_50208_50237[(1)] = cljs.core.first.call(null,(state_50168[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50238 = state_50168;
state_50168 = G__50238;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_50168){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_50168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50209 = f__2744__auto__.call(null);
(statearr_50209[(6)] = c__2743__auto__);

return statearr_50209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.setDefaultKey.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 *     Returns a promise that eventually contains the connection object.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___50245 = arguments.length;
var i__5770__auto___50246 = (0);
while(true){
if((i__5770__auto___50246 < len__5769__auto___50245)){
args__5775__auto__.push((arguments[i__5770__auto___50246]));

var G__50247 = (i__5770__auto___50246 + (1));
i__5770__auto___50246 = G__50247;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__50241){
var vec__50242 = p__50241;
var opts = cljs.core.nth.call(null,vec__50242,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq50239){
var G__50240 = cljs.core.first.call(null,seq50239);
var seq50239__$1 = cljs.core.next.call(null,seq50239);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50240,seq50239__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *    Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordGenerate = (function flureenjs$passwordGenerate(var_args){
var G__50249 = arguments.length;
switch (G__50249) {
case 4:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordGenerate', flureenjs.passwordGenerate);

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.passwordGenerate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.passwordGenerate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 * 
 *    Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordLogin = (function flureenjs$passwordLogin(var_args){
var G__50252 = arguments.length;
switch (G__50252) {
case 4:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordLogin', flureenjs.passwordLogin);

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.passwordLogin.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureenjs.renewToken = (function flureenjs$renewToken(var_args){
var G__50255 = arguments.length;
switch (G__50255) {
case 2:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renewToken', flureenjs.renewToken);

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renewToken.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *    :retracted key containing maps of data organized by subject
 *    and containing full predicate names.
 */
flureenjs.blockEventToMap = (function flureenjs$blockEventToMap(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50286){
var state_val_50287 = (state_50286[(1)]);
if((state_val_50287 === (1))){
var state_50286__$1 = state_50286;
var statearr_50288_50303 = state_50286__$1;
(statearr_50288_50303[(2)] = null);

(statearr_50288_50303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50287 === (2))){
var _ = (function (){var statearr_50289 = state_50286;
(statearr_50289[(4)] = cljs.core.cons.call(null,(5),(state_50286[(4)])));

return statearr_50289;
})();
var inst_50267 = flureenjs._db_instance.call(null,conn,ledger);
var state_50286__$1 = state_50286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50286__$1,(6),inst_50267);
} else {
if((state_val_50287 === (3))){
var inst_50284 = (state_50286[(2)]);
var state_50286__$1 = state_50286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50286__$1,inst_50284);
} else {
if((state_val_50287 === (4))){
var inst_50258 = (state_50286[(2)]);
var inst_50259 = fluree.db.util.log.error.call(null,inst_50258);
var inst_50260 = reject.call(null,inst_50258);
var state_50286__$1 = (function (){var statearr_50291 = state_50286;
(statearr_50291[(7)] = inst_50259);

return statearr_50291;
})();
var statearr_50292_50304 = state_50286__$1;
(statearr_50292_50304[(2)] = inst_50260);

(statearr_50292_50304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50287 === (5))){
var _ = (function (){var statearr_50293 = state_50286;
(statearr_50293[(4)] = cljs.core.rest.call(null,(state_50286[(4)])));

return statearr_50293;
})();
var state_50286__$1 = state_50286;
var ex50290 = (state_50286__$1[(2)]);
var statearr_50294_50305 = state_50286__$1;
(statearr_50294_50305[(5)] = ex50290);


var statearr_50295_50306 = state_50286__$1;
(statearr_50295_50306[(1)] = (4));

(statearr_50295_50306[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50287 === (6))){
var inst_50269 = (state_50286[(2)]);
var inst_50270 = fluree.db.util.async.throw_err.call(null,inst_50269);
var inst_50271 = (function (){var db = inst_50270;
return (function (p1__50257_SHARP_){
return cljs.core.nth.call(null,p1__50257_SHARP_,(4));
});
})();
var inst_50272 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_50273 = cljs.core.group_by.call(null,inst_50271,inst_50272);
var inst_50274 = cljs.core.__destructure_map.call(null,inst_50273);
var inst_50275 = cljs.core.get.call(null,inst_50274,true);
var inst_50276 = cljs.core.get.call(null,inst_50274,false);
var inst_50277 = (function (){var db = inst_50270;
var map__50266 = inst_50274;
var add = inst_50275;
var retract = inst_50276;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_50278 = inst_50277.call(null,inst_50275);
var inst_50279 = inst_50277.call(null,inst_50276);
var inst_50280 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_50278,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_50279);
var inst_50281 = resolve.call(null,inst_50280);
var _ = (function (){var statearr_50296 = state_50286;
(statearr_50296[(4)] = cljs.core.rest.call(null,(state_50286[(4)])));

return statearr_50296;
})();
var state_50286__$1 = state_50286;
var statearr_50297_50307 = state_50286__$1;
(statearr_50297_50307[(2)] = inst_50281);

(statearr_50297_50307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$blockEventToMap_$_state_machine__2721__auto__ = null;
var flureenjs$blockEventToMap_$_state_machine__2721__auto____0 = (function (){
var statearr_50298 = [null,null,null,null,null,null,null,null];
(statearr_50298[(0)] = flureenjs$blockEventToMap_$_state_machine__2721__auto__);

(statearr_50298[(1)] = (1));

return statearr_50298;
});
var flureenjs$blockEventToMap_$_state_machine__2721__auto____1 = (function (state_50286){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50299){var ex__2724__auto__ = e50299;
var statearr_50300_50308 = state_50286;
(statearr_50300_50308[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50286[(4)]))){
var statearr_50301_50309 = state_50286;
(statearr_50301_50309[(1)] = cljs.core.first.call(null,(state_50286[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50310 = state_50286;
state_50286 = G__50310;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$blockEventToMap_$_state_machine__2721__auto__ = function(state_50286){
switch(arguments.length){
case 0:
return flureenjs$blockEventToMap_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$blockEventToMap_$_state_machine__2721__auto____1.call(this,state_50286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$blockEventToMap_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$blockEventToMap_$_state_machine__2721__auto____0;
flureenjs$blockEventToMap_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$blockEventToMap_$_state_machine__2721__auto____1;
return flureenjs$blockEventToMap_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50302 = f__2744__auto__.call(null);
(statearr_50302[(6)] = c__2743__auto__);

return statearr_50302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.closeListener = (function flureenjs$closeListener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.closeListener', flureenjs.closeListener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs._db_instance = (function flureenjs$_db_instance(var_args){
var G__50312 = arguments.length;
switch (G__50312) {
case 2:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs._db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2743__auto___50385 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50358){
var state_val_50359 = (state_50358[(1)]);
if((state_val_50359 === (7))){
var inst_50329 = (state_50358[(7)]);
var state_50358__$1 = state_50358;
if(cljs.core.truth_(inst_50329)){
var statearr_50360_50386 = state_50358__$1;
(statearr_50360_50386[(1)] = (9));

} else {
var statearr_50361_50387 = state_50358__$1;
(statearr_50361_50387[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (1))){
var state_50358__$1 = state_50358;
var statearr_50362_50388 = state_50358__$1;
(statearr_50362_50388[(2)] = null);

(statearr_50362_50388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (4))){
var inst_50313 = (state_50358[(2)]);
var inst_50314 = fluree.db.util.log.error.call(null,inst_50313);
var inst_50315 = cljs.core.async.put_BANG_.call(null,pc,inst_50313);
var inst_50316 = cljs.core.async.close_BANG_.call(null,pc);
var state_50358__$1 = (function (){var statearr_50363 = state_50358;
(statearr_50363[(8)] = inst_50314);

(statearr_50363[(9)] = inst_50315);

return statearr_50363;
})();
var statearr_50364_50389 = state_50358__$1;
(statearr_50364_50389[(2)] = inst_50316);

(statearr_50364_50389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (6))){
var inst_50328 = (state_50358[(10)]);
var state_50358__$1 = state_50358;
var statearr_50365_50390 = state_50358__$1;
(statearr_50365_50390[(2)] = inst_50328);

(statearr_50365_50390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (3))){
var inst_50356 = (state_50358[(2)]);
var state_50358__$1 = state_50358;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50358__$1,inst_50356);
} else {
if((state_val_50359 === (12))){
var inst_50333 = (state_50358[(11)]);
var inst_50332 = (state_50358[(12)]);
var inst_50350 = (state_50358[(2)]);
var inst_50351 = fluree.db.util.async.throw_err.call(null,inst_50350);
var inst_50352 = cljs.core.assoc.call(null,inst_50351,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_50332,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_50333);
var inst_50353 = cljs.core.async.put_BANG_.call(null,pc,inst_50352);
var _ = (function (){var statearr_50366 = state_50358;
(statearr_50366[(4)] = cljs.core.rest.call(null,(state_50358[(4)])));

return statearr_50366;
})();
var state_50358__$1 = state_50358;
var statearr_50367_50391 = state_50358__$1;
(statearr_50367_50391[(2)] = inst_50353);

(statearr_50367_50391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (2))){
var inst_50328 = (state_50358[(10)]);
var _ = (function (){var statearr_50368 = state_50358;
(statearr_50368[(4)] = cljs.core.cons.call(null,(5),(state_50358[(4)])));

return statearr_50368;
})();
var inst_50326 = opts;
var inst_50327 = cljs.core.__destructure_map.call(null,inst_50326);
var inst_50328__$1 = cljs.core.get.call(null,inst_50327,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_50329 = cljs.core.get.call(null,inst_50327,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_50330 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_50331 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_50332 = cljs.core.nth.call(null,inst_50331,(0),null);
var inst_50333 = cljs.core.nth.call(null,inst_50331,(1),null);
var state_50358__$1 = (function (){var statearr_50369 = state_50358;
(statearr_50369[(11)] = inst_50333);

(statearr_50369[(7)] = inst_50329);

(statearr_50369[(13)] = inst_50330);

(statearr_50369[(12)] = inst_50332);

(statearr_50369[(10)] = inst_50328__$1);

return statearr_50369;
})();
if(cljs.core.truth_(inst_50328__$1)){
var statearr_50370_50392 = state_50358__$1;
(statearr_50370_50392[(1)] = (6));

} else {
var statearr_50371_50393 = state_50358__$1;
(statearr_50371_50393[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (11))){
var inst_50344 = (state_50358[(2)]);
var state_50358__$1 = state_50358;
var statearr_50373_50394 = state_50358__$1;
(statearr_50373_50394[(2)] = inst_50344);

(statearr_50373_50394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (9))){
var inst_50329 = (state_50358[(7)]);
var inst_50337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50338 = fluree.db.connection_js.validate_token.call(null,conn,inst_50329);
var inst_50339 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_50338);
var inst_50340 = ["_auth/id",inst_50339];
var inst_50341 = (new cljs.core.PersistentVector(null,2,(5),inst_50337,inst_50340,null));
var state_50358__$1 = state_50358;
var statearr_50374_50395 = state_50358__$1;
(statearr_50374_50395[(2)] = inst_50341);

(statearr_50374_50395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (5))){
var _ = (function (){var statearr_50375 = state_50358;
(statearr_50375[(4)] = cljs.core.rest.call(null,(state_50358[(4)])));

return statearr_50375;
})();
var state_50358__$1 = state_50358;
var ex50372 = (state_50358__$1[(2)]);
var statearr_50376_50396 = state_50358__$1;
(statearr_50376_50396[(5)] = ex50372);


var statearr_50377_50397 = state_50358__$1;
(statearr_50377_50397[(1)] = (4));

(statearr_50377_50397[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (10))){
var state_50358__$1 = state_50358;
var statearr_50378_50398 = state_50358__$1;
(statearr_50378_50398[(2)] = null);

(statearr_50378_50398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50359 === (8))){
var inst_50346 = (state_50358[(2)]);
var inst_50347 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_50346);
var inst_50348 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_50347);
var state_50358__$1 = state_50358;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50358__$1,(12),inst_50348);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_50379 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50379[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_50379[(1)] = (1));

return statearr_50379;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_50358){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50358);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50380){var ex__2724__auto__ = e50380;
var statearr_50381_50399 = state_50358;
(statearr_50381_50399[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50358[(4)]))){
var statearr_50382_50400 = state_50358;
(statearr_50382_50400[(1)] = cljs.core.first.call(null,(state_50358[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50401 = state_50358;
state_50358 = G__50401;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_50358){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_50358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50383 = f__2744__auto__.call(null);
(statearr_50383[(6)] = c__2743__auto___50385);

return statearr_50383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));


return pc;
}));

(flureenjs._db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___50441 = arguments.length;
var i__5770__auto___50442 = (0);
while(true){
if((i__5770__auto___50442 < len__5769__auto___50441)){
args__5775__auto__.push((arguments[i__5770__auto___50442]));

var G__50443 = (i__5770__auto___50442 + (1));
i__5770__auto___50442 = G__50443;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__50405){
var vec__50406 = p__50405;
var opts = cljs.core.nth.call(null,vec__50406,(0),null);
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50424){
var state_val_50425 = (state_50424[(1)]);
if((state_val_50425 === (1))){
var state_50424__$1 = state_50424;
var statearr_50426_50444 = state_50424__$1;
(statearr_50426_50444[(2)] = null);

(statearr_50426_50444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50425 === (2))){
var _ = (function (){var statearr_50427 = state_50424;
(statearr_50427[(4)] = cljs.core.cons.call(null,(5),(state_50424[(4)])));

return statearr_50427;
})();
var inst_50417 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_50418 = flureenjs._db_instance.call(null,conn,ledger,inst_50417);
var inst_50419 = resolve.call(null,inst_50418);
var ___$1 = (function (){var statearr_50428 = state_50424;
(statearr_50428[(4)] = cljs.core.rest.call(null,(state_50424[(4)])));

return statearr_50428;
})();
var state_50424__$1 = state_50424;
var statearr_50429_50445 = state_50424__$1;
(statearr_50429_50445[(2)] = inst_50419);

(statearr_50429_50445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50425 === (3))){
var inst_50422 = (state_50424[(2)]);
var state_50424__$1 = state_50424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50424__$1,inst_50422);
} else {
if((state_val_50425 === (4))){
var inst_50409 = (state_50424[(2)]);
var inst_50410 = fluree.db.util.log.error.call(null,inst_50409);
var inst_50411 = reject.call(null,inst_50409);
var state_50424__$1 = (function (){var statearr_50431 = state_50424;
(statearr_50431[(7)] = inst_50410);

return statearr_50431;
})();
var statearr_50432_50446 = state_50424__$1;
(statearr_50432_50446[(2)] = inst_50411);

(statearr_50432_50446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50425 === (5))){
var _ = (function (){var statearr_50433 = state_50424;
(statearr_50433[(4)] = cljs.core.rest.call(null,(state_50424[(4)])));

return statearr_50433;
})();
var state_50424__$1 = state_50424;
var ex50430 = (state_50424__$1[(2)]);
var statearr_50434_50447 = state_50424__$1;
(statearr_50434_50447[(5)] = ex50430);


var statearr_50435_50448 = state_50424__$1;
(statearr_50435_50448[(1)] = (4));

(statearr_50435_50448[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_50436 = [null,null,null,null,null,null,null,null];
(statearr_50436[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_50436[(1)] = (1));

return statearr_50436;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_50424){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50437){var ex__2724__auto__ = e50437;
var statearr_50438_50449 = state_50424;
(statearr_50438_50449[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50424[(4)]))){
var statearr_50439_50450 = state_50424;
(statearr_50439_50450[(1)] = cljs.core.first.call(null,(state_50424[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50451 = state_50424;
state_50424 = G__50451;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_50424){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_50424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50440 = f__2744__auto__.call(null);
(statearr_50440[(6)] = c__2743__auto__);

return statearr_50440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq50402){
var G__50403 = cljs.core.first.call(null,seq50402);
var seq50402__$1 = cljs.core.next.call(null,seq50402);
var G__50404 = cljs.core.first.call(null,seq50402__$1);
var seq50402__$2 = cljs.core.next.call(null,seq50402__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50403,G__50404,seq50402__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *    If collection doesn't exist, returns nil.
 */
flureenjs.collectionId = (function flureenjs$collectionId(db,collection){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50471){
var state_val_50472 = (state_50471[(1)]);
if((state_val_50472 === (1))){
var state_50471__$1 = state_50471;
var statearr_50473_50489 = state_50471__$1;
(statearr_50473_50489[(2)] = null);

(statearr_50473_50489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50472 === (2))){
var _ = (function (){var statearr_50474 = state_50471;
(statearr_50474[(4)] = cljs.core.cons.call(null,(5),(state_50471[(4)])));

return statearr_50474;
})();
var inst_50460 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_50471__$1 = (function (){var statearr_50475 = state_50471;
(statearr_50475[(7)] = inst_50460);

return statearr_50475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50471__$1,(6),db);
} else {
if((state_val_50472 === (3))){
var inst_50469 = (state_50471[(2)]);
var state_50471__$1 = state_50471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50471__$1,inst_50469);
} else {
if((state_val_50472 === (4))){
var inst_50452 = (state_50471[(2)]);
var inst_50453 = fluree.db.util.log.error.call(null,inst_50452);
var inst_50454 = reject.call(null,inst_50452);
var state_50471__$1 = (function (){var statearr_50477 = state_50471;
(statearr_50477[(8)] = inst_50453);

return statearr_50477;
})();
var statearr_50478_50490 = state_50471__$1;
(statearr_50478_50490[(2)] = inst_50454);

(statearr_50478_50490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50472 === (5))){
var _ = (function (){var statearr_50479 = state_50471;
(statearr_50479[(4)] = cljs.core.rest.call(null,(state_50471[(4)])));

return statearr_50479;
})();
var state_50471__$1 = state_50471;
var ex50476 = (state_50471__$1[(2)]);
var statearr_50480_50491 = state_50471__$1;
(statearr_50480_50491[(5)] = ex50476);


var statearr_50481_50492 = state_50471__$1;
(statearr_50481_50492[(1)] = (4));

(statearr_50481_50492[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50472 === (6))){
var inst_50460 = (state_50471[(7)]);
var inst_50462 = (state_50471[(2)]);
var inst_50463 = fluree.db.util.async.throw_err.call(null,inst_50462);
var inst_50464 = fluree.db.dbproto._c_prop.call(null,inst_50463,new cljs.core.Keyword(null,"id","id",-1388402092),inst_50460);
var inst_50465 = cljs.core.clj__GT_js.call(null,inst_50464);
var inst_50466 = resolve.call(null,inst_50465);
var _ = (function (){var statearr_50482 = state_50471;
(statearr_50482[(4)] = cljs.core.rest.call(null,(state_50471[(4)])));

return statearr_50482;
})();
var state_50471__$1 = state_50471;
var statearr_50483_50493 = state_50471__$1;
(statearr_50483_50493[(2)] = inst_50466);

(statearr_50483_50493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionId_$_state_machine__2721__auto__ = null;
var flureenjs$collectionId_$_state_machine__2721__auto____0 = (function (){
var statearr_50484 = [null,null,null,null,null,null,null,null,null];
(statearr_50484[(0)] = flureenjs$collectionId_$_state_machine__2721__auto__);

(statearr_50484[(1)] = (1));

return statearr_50484;
});
var flureenjs$collectionId_$_state_machine__2721__auto____1 = (function (state_50471){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50485){var ex__2724__auto__ = e50485;
var statearr_50486_50494 = state_50471;
(statearr_50486_50494[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50471[(4)]))){
var statearr_50487_50495 = state_50471;
(statearr_50487_50495[(1)] = cljs.core.first.call(null,(state_50471[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50496 = state_50471;
state_50471 = G__50496;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$collectionId_$_state_machine__2721__auto__ = function(state_50471){
switch(arguments.length){
case 0:
return flureenjs$collectionId_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$collectionId_$_state_machine__2721__auto____1.call(this,state_50471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionId_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionId_$_state_machine__2721__auto____0;
flureenjs$collectionId_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionId_$_state_machine__2721__auto____1;
return flureenjs$collectionId_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50488 = f__2744__auto__.call(null);
(statearr_50488[(6)] = c__2743__auto__);

return statearr_50488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionId', flureenjs.collectionId);
/**
 * Returns promise containing predicate id given a predicate.
 *    If predicate doesn't exist, returns nil.
 */
flureenjs.predicateId = (function flureenjs$predicateId(db,predicate){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50516){
var state_val_50517 = (state_50516[(1)]);
if((state_val_50517 === (1))){
var state_50516__$1 = state_50516;
var statearr_50518_50534 = state_50516__$1;
(statearr_50518_50534[(2)] = null);

(statearr_50518_50534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50517 === (2))){
var _ = (function (){var statearr_50519 = state_50516;
(statearr_50519[(4)] = cljs.core.cons.call(null,(5),(state_50516[(4)])));

return statearr_50519;
})();
var inst_50505 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_50516__$1 = (function (){var statearr_50520 = state_50516;
(statearr_50520[(7)] = inst_50505);

return statearr_50520;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50516__$1,(6),db);
} else {
if((state_val_50517 === (3))){
var inst_50514 = (state_50516[(2)]);
var state_50516__$1 = state_50516;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50516__$1,inst_50514);
} else {
if((state_val_50517 === (4))){
var inst_50497 = (state_50516[(2)]);
var inst_50498 = fluree.db.util.log.error.call(null,inst_50497);
var inst_50499 = reject.call(null,inst_50497);
var state_50516__$1 = (function (){var statearr_50522 = state_50516;
(statearr_50522[(8)] = inst_50498);

return statearr_50522;
})();
var statearr_50523_50535 = state_50516__$1;
(statearr_50523_50535[(2)] = inst_50499);

(statearr_50523_50535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50517 === (5))){
var _ = (function (){var statearr_50524 = state_50516;
(statearr_50524[(4)] = cljs.core.rest.call(null,(state_50516[(4)])));

return statearr_50524;
})();
var state_50516__$1 = state_50516;
var ex50521 = (state_50516__$1[(2)]);
var statearr_50525_50536 = state_50516__$1;
(statearr_50525_50536[(5)] = ex50521);


var statearr_50526_50537 = state_50516__$1;
(statearr_50526_50537[(1)] = (4));

(statearr_50526_50537[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50517 === (6))){
var inst_50505 = (state_50516[(7)]);
var inst_50507 = (state_50516[(2)]);
var inst_50508 = fluree.db.util.async.throw_err.call(null,inst_50507);
var inst_50509 = fluree.db.dbproto._p_prop.call(null,inst_50508,new cljs.core.Keyword(null,"id","id",-1388402092),inst_50505);
var inst_50510 = cljs.core.clj__GT_js.call(null,inst_50509);
var inst_50511 = resolve.call(null,inst_50510);
var _ = (function (){var statearr_50527 = state_50516;
(statearr_50527[(4)] = cljs.core.rest.call(null,(state_50516[(4)])));

return statearr_50527;
})();
var state_50516__$1 = state_50516;
var statearr_50528_50538 = state_50516__$1;
(statearr_50528_50538[(2)] = inst_50511);

(statearr_50528_50538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateId_$_state_machine__2721__auto__ = null;
var flureenjs$predicateId_$_state_machine__2721__auto____0 = (function (){
var statearr_50529 = [null,null,null,null,null,null,null,null,null];
(statearr_50529[(0)] = flureenjs$predicateId_$_state_machine__2721__auto__);

(statearr_50529[(1)] = (1));

return statearr_50529;
});
var flureenjs$predicateId_$_state_machine__2721__auto____1 = (function (state_50516){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50516);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50530){var ex__2724__auto__ = e50530;
var statearr_50531_50539 = state_50516;
(statearr_50531_50539[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50516[(4)]))){
var statearr_50532_50540 = state_50516;
(statearr_50532_50540[(1)] = cljs.core.first.call(null,(state_50516[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50541 = state_50516;
state_50516 = G__50541;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$predicateId_$_state_machine__2721__auto__ = function(state_50516){
switch(arguments.length){
case 0:
return flureenjs$predicateId_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$predicateId_$_state_machine__2721__auto____1.call(this,state_50516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateId_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateId_$_state_machine__2721__auto____0;
flureenjs$predicateId_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateId_$_state_machine__2721__auto____1;
return flureenjs$predicateId_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50533 = f__2744__auto__.call(null);
(statearr_50533[(6)] = c__2743__auto__);

return statearr_50533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateId', flureenjs.predicateId);
/**
 * Returns promise containing predicate name given a predicate.
 *    If predicate doesn't exist, returns nil.
 */
flureenjs.predicateName = (function flureenjs$predicateName(db,predicate){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50561){
var state_val_50562 = (state_50561[(1)]);
if((state_val_50562 === (1))){
var state_50561__$1 = state_50561;
var statearr_50563_50579 = state_50561__$1;
(statearr_50563_50579[(2)] = null);

(statearr_50563_50579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50562 === (2))){
var _ = (function (){var statearr_50564 = state_50561;
(statearr_50564[(4)] = cljs.core.cons.call(null,(5),(state_50561[(4)])));

return statearr_50564;
})();
var inst_50550 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_50561__$1 = (function (){var statearr_50565 = state_50561;
(statearr_50565[(7)] = inst_50550);

return statearr_50565;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50561__$1,(6),db);
} else {
if((state_val_50562 === (3))){
var inst_50559 = (state_50561[(2)]);
var state_50561__$1 = state_50561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50561__$1,inst_50559);
} else {
if((state_val_50562 === (4))){
var inst_50542 = (state_50561[(2)]);
var inst_50543 = fluree.db.util.log.error.call(null,inst_50542);
var inst_50544 = reject.call(null,inst_50542);
var state_50561__$1 = (function (){var statearr_50567 = state_50561;
(statearr_50567[(8)] = inst_50543);

return statearr_50567;
})();
var statearr_50568_50580 = state_50561__$1;
(statearr_50568_50580[(2)] = inst_50544);

(statearr_50568_50580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50562 === (5))){
var _ = (function (){var statearr_50569 = state_50561;
(statearr_50569[(4)] = cljs.core.rest.call(null,(state_50561[(4)])));

return statearr_50569;
})();
var state_50561__$1 = state_50561;
var ex50566 = (state_50561__$1[(2)]);
var statearr_50570_50581 = state_50561__$1;
(statearr_50570_50581[(5)] = ex50566);


var statearr_50571_50582 = state_50561__$1;
(statearr_50571_50582[(1)] = (4));

(statearr_50571_50582[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50562 === (6))){
var inst_50550 = (state_50561[(7)]);
var inst_50552 = (state_50561[(2)]);
var inst_50553 = fluree.db.util.async.throw_err.call(null,inst_50552);
var inst_50554 = fluree.db.dbproto._p_prop.call(null,inst_50553,new cljs.core.Keyword(null,"name","name",1843675177),inst_50550);
var inst_50555 = cljs.core.clj__GT_js.call(null,inst_50554);
var inst_50556 = resolve.call(null,inst_50555);
var _ = (function (){var statearr_50572 = state_50561;
(statearr_50572[(4)] = cljs.core.rest.call(null,(state_50561[(4)])));

return statearr_50572;
})();
var state_50561__$1 = state_50561;
var statearr_50573_50583 = state_50561__$1;
(statearr_50573_50583[(2)] = inst_50556);

(statearr_50573_50583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateName_$_state_machine__2721__auto__ = null;
var flureenjs$predicateName_$_state_machine__2721__auto____0 = (function (){
var statearr_50574 = [null,null,null,null,null,null,null,null,null];
(statearr_50574[(0)] = flureenjs$predicateName_$_state_machine__2721__auto__);

(statearr_50574[(1)] = (1));

return statearr_50574;
});
var flureenjs$predicateName_$_state_machine__2721__auto____1 = (function (state_50561){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50575){var ex__2724__auto__ = e50575;
var statearr_50576_50584 = state_50561;
(statearr_50576_50584[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50561[(4)]))){
var statearr_50577_50585 = state_50561;
(statearr_50577_50585[(1)] = cljs.core.first.call(null,(state_50561[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50586 = state_50561;
state_50561 = G__50586;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$predicateName_$_state_machine__2721__auto__ = function(state_50561){
switch(arguments.length){
case 0:
return flureenjs$predicateName_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$predicateName_$_state_machine__2721__auto____1.call(this,state_50561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateName_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateName_$_state_machine__2721__auto____0;
flureenjs$predicateName_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateName_$_state_machine__2721__auto____1;
return flureenjs$predicateName_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50578 = f__2744__auto__.call(null);
(statearr_50578[(6)] = c__2743__auto__);

return statearr_50578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateName', flureenjs.predicateName);
/**
 * Returns promise containing subject id given a subject
 *    identity or a subject id.
 *    If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50609){
var state_val_50610 = (state_50609[(1)]);
if((state_val_50610 === (1))){
var state_50609__$1 = state_50609;
var statearr_50611_50627 = state_50609__$1;
(statearr_50611_50627[(2)] = null);

(statearr_50611_50627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50610 === (2))){
var _ = (function (){var statearr_50612 = state_50609;
(statearr_50612[(4)] = cljs.core.cons.call(null,(5),(state_50609[(4)])));

return statearr_50612;
})();
var inst_50595 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_50609__$1 = (function (){var statearr_50613 = state_50609;
(statearr_50613[(7)] = inst_50595);

return statearr_50613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50609__$1,(7),db);
} else {
if((state_val_50610 === (3))){
var inst_50607 = (state_50609[(2)]);
var state_50609__$1 = state_50609;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50609__$1,inst_50607);
} else {
if((state_val_50610 === (4))){
var inst_50587 = (state_50609[(2)]);
var inst_50588 = fluree.db.util.log.error.call(null,inst_50587);
var inst_50589 = reject.call(null,inst_50587);
var state_50609__$1 = (function (){var statearr_50615 = state_50609;
(statearr_50615[(8)] = inst_50588);

return statearr_50615;
})();
var statearr_50616_50628 = state_50609__$1;
(statearr_50616_50628[(2)] = inst_50589);

(statearr_50616_50628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50610 === (5))){
var _ = (function (){var statearr_50617 = state_50609;
(statearr_50617[(4)] = cljs.core.rest.call(null,(state_50609[(4)])));

return statearr_50617;
})();
var state_50609__$1 = state_50609;
var ex50614 = (state_50609__$1[(2)]);
var statearr_50618_50629 = state_50609__$1;
(statearr_50618_50629[(5)] = ex50614);


var statearr_50619_50630 = state_50609__$1;
(statearr_50619_50630[(1)] = (4));

(statearr_50619_50630[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50610 === (6))){
var inst_50601 = (state_50609[(2)]);
var inst_50602 = fluree.db.util.async.throw_err.call(null,inst_50601);
var inst_50603 = cljs.core.clj__GT_js.call(null,inst_50602);
var inst_50604 = resolve.call(null,inst_50603);
var _ = (function (){var statearr_50620 = state_50609;
(statearr_50620[(4)] = cljs.core.rest.call(null,(state_50609[(4)])));

return statearr_50620;
})();
var state_50609__$1 = state_50609;
var statearr_50621_50631 = state_50609__$1;
(statearr_50621_50631[(2)] = inst_50604);

(statearr_50621_50631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50610 === (7))){
var inst_50595 = (state_50609[(7)]);
var inst_50597 = (state_50609[(2)]);
var inst_50598 = fluree.db.util.async.throw_err.call(null,inst_50597);
var inst_50599 = fluree.db.dbproto._subid.call(null,inst_50598,inst_50595,false);
var state_50609__$1 = state_50609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50609__$1,(6),inst_50599);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__2721__auto__ = null;
var flureenjs$subid_$_state_machine__2721__auto____0 = (function (){
var statearr_50622 = [null,null,null,null,null,null,null,null,null];
(statearr_50622[(0)] = flureenjs$subid_$_state_machine__2721__auto__);

(statearr_50622[(1)] = (1));

return statearr_50622;
});
var flureenjs$subid_$_state_machine__2721__auto____1 = (function (state_50609){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50609);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50623){var ex__2724__auto__ = e50623;
var statearr_50624_50632 = state_50609;
(statearr_50624_50632[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50609[(4)]))){
var statearr_50625_50633 = state_50609;
(statearr_50625_50633[(1)] = cljs.core.first.call(null,(state_50609[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50634 = state_50609;
state_50609 = G__50634;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__2721__auto__ = function(state_50609){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__2721__auto____1.call(this,state_50609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__2721__auto____0;
flureenjs$subid_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__2721__auto____1;
return flureenjs$subid_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50626 = f__2744__auto__.call(null);
(statearr_50626[(6)] = c__2743__auto__);

return statearr_50626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.deleteLedger = (function flureenjs$deleteLedger(var_args){
var G__50636 = arguments.length;
switch (G__50636) {
case 2:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.deleteLedger', flureenjs.deleteLedger);

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.deleteLedger.call(null,conn,ledger,null);
}));

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50706){
var state_val_50707 = (state_50706[(1)]);
if((state_val_50707 === (7))){
var inst_50649 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_50706__$1 = state_50706;
var statearr_50708_50753 = state_50706__$1;
(statearr_50708_50753[(2)] = inst_50649);

(statearr_50708_50753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (20))){
var inst_50657 = (state_50706[(7)]);
var inst_50681 = (state_50706[(2)]);
var state_50706__$1 = (function (){var statearr_50709 = state_50706;
(statearr_50709[(8)] = inst_50681);

return statearr_50709;
})();
if(cljs.core.truth_(inst_50657)){
var statearr_50710_50754 = state_50706__$1;
(statearr_50710_50754[(1)] = (21));

} else {
var statearr_50711_50755 = state_50706__$1;
(statearr_50711_50755[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (1))){
var state_50706__$1 = state_50706;
var statearr_50712_50756 = state_50706__$1;
(statearr_50712_50756[(2)] = null);

(statearr_50712_50756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (24))){
var inst_50688 = (state_50706[(2)]);
var inst_50689 = fluree.db.util.async.throw_err.call(null,inst_50688);
var state_50706__$1 = state_50706;
var statearr_50713_50757 = state_50706__$1;
(statearr_50713_50757[(2)] = inst_50689);

(statearr_50713_50757[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (4))){
var inst_50637 = (state_50706[(2)]);
var inst_50638 = fluree.db.util.log.error.call(null,inst_50637);
var inst_50639 = reject.call(null,inst_50637);
var state_50706__$1 = (function (){var statearr_50714 = state_50706;
(statearr_50714[(9)] = inst_50638);

return statearr_50714;
})();
var statearr_50715_50758 = state_50706__$1;
(statearr_50715_50758[(2)] = inst_50639);

(statearr_50715_50758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (15))){
var inst_50670 = (state_50706[(10)]);
var inst_50672 = fluree.db.util.core.without_nils.call(null,inst_50670);
var inst_50673 = fluree.db.util.json.stringify.call(null,inst_50672);
var state_50706__$1 = state_50706;
var statearr_50716_50759 = state_50706__$1;
(statearr_50716_50759[(2)] = inst_50673);

(statearr_50716_50759[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (21))){
var inst_50681 = (state_50706[(8)]);
var inst_50676 = (state_50706[(11)]);
var inst_50683 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_50684 = [inst_50676,inst_50681];
var inst_50685 = cljs.core.PersistentHashMap.fromArrays(inst_50683,inst_50684);
var inst_50686 = fluree.db.operations.command_async.call(null,conn,inst_50685);
var state_50706__$1 = state_50706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50706__$1,(24),inst_50686);
} else {
if((state_val_50707 === (13))){
var inst_50658 = (state_50706[(12)]);
var inst_50665 = (inst_50658 + (30000));
var state_50706__$1 = state_50706;
var statearr_50717_50760 = state_50706__$1;
(statearr_50717_50760[(2)] = inst_50665);

(statearr_50717_50760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (22))){
var inst_50670 = (state_50706[(10)]);
var inst_50691 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_50670);
var state_50706__$1 = state_50706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50706__$1,(25),inst_50691);
} else {
if((state_val_50707 === (6))){
var state_50706__$1 = state_50706;
var statearr_50718_50761 = state_50706__$1;
(statearr_50718_50761[(2)] = null);

(statearr_50718_50761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (25))){
var inst_50693 = (state_50706[(2)]);
var inst_50694 = fluree.db.util.async.throw_err.call(null,inst_50693);
var state_50706__$1 = state_50706;
var statearr_50719_50762 = state_50706__$1;
(statearr_50719_50762[(2)] = inst_50694);

(statearr_50719_50762[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (17))){
var inst_50657 = (state_50706[(7)]);
var inst_50676 = (state_50706[(2)]);
var state_50706__$1 = (function (){var statearr_50720 = state_50706;
(statearr_50720[(11)] = inst_50676);

return statearr_50720;
})();
if(cljs.core.truth_(inst_50657)){
var statearr_50721_50763 = state_50706__$1;
(statearr_50721_50763[(1)] = (18));

} else {
var statearr_50722_50764 = state_50706__$1;
(statearr_50722_50764[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (3))){
var inst_50704 = (state_50706[(2)]);
var state_50706__$1 = state_50706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50706__$1,inst_50704);
} else {
if((state_val_50707 === (12))){
var inst_50655 = (state_50706[(13)]);
var state_50706__$1 = state_50706;
var statearr_50723_50765 = state_50706__$1;
(statearr_50723_50765[(2)] = inst_50655);

(statearr_50723_50765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (2))){
var _ = (function (){var statearr_50724 = state_50706;
(statearr_50724[(4)] = cljs.core.cons.call(null,(5),(state_50706[(4)])));

return statearr_50724;
})();
var inst_50646 = (opts == null);
var state_50706__$1 = state_50706;
if(cljs.core.truth_(inst_50646)){
var statearr_50725_50766 = state_50706__$1;
(statearr_50725_50766[(1)] = (6));

} else {
var statearr_50726_50767 = state_50706__$1;
(statearr_50726_50767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (23))){
var inst_50696 = (state_50706[(2)]);
var inst_50697 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_50698 = [(200),inst_50696];
var inst_50699 = cljs.core.PersistentHashMap.fromArrays(inst_50697,inst_50698);
var inst_50700 = cljs.core.clj__GT_js.call(null,inst_50699);
var inst_50701 = resolve.call(null,inst_50700);
var _ = (function (){var statearr_50727 = state_50706;
(statearr_50727[(4)] = cljs.core.rest.call(null,(state_50706[(4)])));

return statearr_50727;
})();
var state_50706__$1 = state_50706;
var statearr_50728_50768 = state_50706__$1;
(statearr_50728_50768[(2)] = inst_50701);

(statearr_50728_50768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (19))){
var state_50706__$1 = state_50706;
var statearr_50729_50769 = state_50706__$1;
(statearr_50729_50769[(2)] = null);

(statearr_50729_50769[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (11))){
var inst_50655 = (state_50706[(13)]);
var inst_50662 = (state_50706[(2)]);
var state_50706__$1 = (function (){var statearr_50731 = state_50706;
(statearr_50731[(14)] = inst_50662);

return statearr_50731;
})();
if(cljs.core.truth_(inst_50655)){
var statearr_50732_50770 = state_50706__$1;
(statearr_50732_50770[(1)] = (12));

} else {
var statearr_50733_50771 = state_50706__$1;
(statearr_50733_50771[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (9))){
var inst_50654 = (state_50706[(15)]);
var state_50706__$1 = state_50706;
var statearr_50734_50772 = state_50706__$1;
(statearr_50734_50772[(2)] = inst_50654);

(statearr_50734_50772[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (5))){
var _ = (function (){var statearr_50735 = state_50706;
(statearr_50735[(4)] = cljs.core.rest.call(null,(state_50706[(4)])));

return statearr_50735;
})();
var state_50706__$1 = state_50706;
var ex50730 = (state_50706__$1[(2)]);
var statearr_50736_50773 = state_50706__$1;
(statearr_50736_50773[(5)] = ex50730);


var statearr_50737_50774 = state_50706__$1;
(statearr_50737_50774[(1)] = (4));

(statearr_50737_50774[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (14))){
var inst_50662 = (state_50706[(14)]);
var inst_50657 = (state_50706[(7)]);
var inst_50667 = (state_50706[(2)]);
var inst_50668 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_50669 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_50662,inst_50667];
var inst_50670 = cljs.core.PersistentHashMap.fromArrays(inst_50668,inst_50669);
var state_50706__$1 = (function (){var statearr_50738 = state_50706;
(statearr_50738[(10)] = inst_50670);

return statearr_50738;
})();
if(cljs.core.truth_(inst_50657)){
var statearr_50739_50775 = state_50706__$1;
(statearr_50739_50775[(1)] = (15));

} else {
var statearr_50740_50776 = state_50706__$1;
(statearr_50740_50776[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (16))){
var state_50706__$1 = state_50706;
var statearr_50741_50777 = state_50706__$1;
(statearr_50741_50777[(2)] = null);

(statearr_50741_50777[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (10))){
var inst_50658 = (state_50706[(12)]);
var state_50706__$1 = state_50706;
var statearr_50742_50778 = state_50706__$1;
(statearr_50742_50778[(2)] = inst_50658);

(statearr_50742_50778[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (18))){
var inst_50676 = (state_50706[(11)]);
var inst_50657 = (state_50706[(7)]);
var inst_50678 = fluree.crypto.sign_message.call(null,inst_50676,inst_50657);
var state_50706__$1 = state_50706;
var statearr_50743_50779 = state_50706__$1;
(statearr_50743_50779[(2)] = inst_50678);

(statearr_50743_50779[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50707 === (8))){
var inst_50654 = (state_50706[(15)]);
var inst_50651 = (state_50706[(2)]);
var inst_50652 = fluree.db.connection_js.check_connection.call(null,conn,inst_50651);
var inst_50653 = cljs.core.__destructure_map.call(null,inst_50651);
var inst_50654__$1 = cljs.core.get.call(null,inst_50653,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_50655 = cljs.core.get.call(null,inst_50653,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_50656 = cljs.core.get.call(null,inst_50653,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_50657 = cljs.core.get.call(null,inst_50653,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_50658 = fluree.db.util.core.current_time_millis.call(null);
var state_50706__$1 = (function (){var statearr_50744 = state_50706;
(statearr_50744[(16)] = inst_50652);

(statearr_50744[(12)] = inst_50658);

(statearr_50744[(15)] = inst_50654__$1);

(statearr_50744[(17)] = inst_50656);

(statearr_50744[(13)] = inst_50655);

(statearr_50744[(7)] = inst_50657);

return statearr_50744;
})();
if(cljs.core.truth_(inst_50654__$1)){
var statearr_50745_50780 = state_50706__$1;
(statearr_50745_50780[(1)] = (9));

} else {
var statearr_50746_50781 = state_50706__$1;
(statearr_50746_50781[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_50747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50747[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_50747[(1)] = (1));

return statearr_50747;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_50706){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50748){var ex__2724__auto__ = e50748;
var statearr_50749_50782 = state_50706;
(statearr_50749_50782[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50706[(4)]))){
var statearr_50750_50783 = state_50706;
(statearr_50750_50783[(1)] = cljs.core.first.call(null,(state_50706[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50784 = state_50706;
state_50706 = G__50784;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_50706){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_50706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50751 = f__2744__auto__.call(null);
(statearr_50751[(6)] = c__2743__auto__);

return statearr_50751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.deleteLedger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *    If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledgerInfo = (function flureenjs$ledgerInfo(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50803){
var state_val_50804 = (state_50803[(1)]);
if((state_val_50804 === (1))){
var state_50803__$1 = state_50803;
var statearr_50805_50820 = state_50803__$1;
(statearr_50805_50820[(2)] = null);

(statearr_50805_50820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50804 === (2))){
var _ = (function (){var statearr_50806 = state_50803;
(statearr_50806[(4)] = cljs.core.cons.call(null,(5),(state_50803[(4)])));

return statearr_50806;
})();
var inst_50793 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_50803__$1 = state_50803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50803__$1,(6),inst_50793);
} else {
if((state_val_50804 === (3))){
var inst_50801 = (state_50803[(2)]);
var state_50803__$1 = state_50803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50803__$1,inst_50801);
} else {
if((state_val_50804 === (4))){
var inst_50785 = (state_50803[(2)]);
var inst_50786 = fluree.db.util.log.error.call(null,inst_50785);
var inst_50787 = reject.call(null,inst_50785);
var state_50803__$1 = (function (){var statearr_50808 = state_50803;
(statearr_50808[(7)] = inst_50786);

return statearr_50808;
})();
var statearr_50809_50821 = state_50803__$1;
(statearr_50809_50821[(2)] = inst_50787);

(statearr_50809_50821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50804 === (5))){
var _ = (function (){var statearr_50810 = state_50803;
(statearr_50810[(4)] = cljs.core.rest.call(null,(state_50803[(4)])));

return statearr_50810;
})();
var state_50803__$1 = state_50803;
var ex50807 = (state_50803__$1[(2)]);
var statearr_50811_50822 = state_50803__$1;
(statearr_50811_50822[(5)] = ex50807);


var statearr_50812_50823 = state_50803__$1;
(statearr_50812_50823[(1)] = (4));

(statearr_50812_50823[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50804 === (6))){
var inst_50795 = (state_50803[(2)]);
var inst_50796 = fluree.db.util.async.throw_err.call(null,inst_50795);
var inst_50797 = cljs.core.clj__GT_js.call(null,inst_50796);
var inst_50798 = resolve.call(null,inst_50797);
var _ = (function (){var statearr_50813 = state_50803;
(statearr_50813[(4)] = cljs.core.rest.call(null,(state_50803[(4)])));

return statearr_50813;
})();
var state_50803__$1 = state_50803;
var statearr_50814_50824 = state_50803__$1;
(statearr_50814_50824[(2)] = inst_50798);

(statearr_50814_50824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerInfo_$_state_machine__2721__auto__ = null;
var flureenjs$ledgerInfo_$_state_machine__2721__auto____0 = (function (){
var statearr_50815 = [null,null,null,null,null,null,null,null];
(statearr_50815[(0)] = flureenjs$ledgerInfo_$_state_machine__2721__auto__);

(statearr_50815[(1)] = (1));

return statearr_50815;
});
var flureenjs$ledgerInfo_$_state_machine__2721__auto____1 = (function (state_50803){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50816){var ex__2724__auto__ = e50816;
var statearr_50817_50825 = state_50803;
(statearr_50817_50825[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50803[(4)]))){
var statearr_50818_50826 = state_50803;
(statearr_50818_50826[(1)] = cljs.core.first.call(null,(state_50803[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50827 = state_50803;
state_50803 = G__50827;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$ledgerInfo_$_state_machine__2721__auto__ = function(state_50803){
switch(arguments.length){
case 0:
return flureenjs$ledgerInfo_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$ledgerInfo_$_state_machine__2721__auto____1.call(this,state_50803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerInfo_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerInfo_$_state_machine__2721__auto____0;
flureenjs$ledgerInfo_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerInfo_$_state_machine__2721__auto____1;
return flureenjs$ledgerInfo_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50819 = f__2744__auto__.call(null);
(statearr_50819[(6)] = c__2743__auto__);

return statearr_50819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerInfo', flureenjs.ledgerInfo);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledgerList = (function flureenjs$ledgerList(conn){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50846){
var state_val_50847 = (state_50846[(1)]);
if((state_val_50847 === (1))){
var state_50846__$1 = state_50846;
var statearr_50848_50863 = state_50846__$1;
(statearr_50848_50863[(2)] = null);

(statearr_50848_50863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50847 === (2))){
var _ = (function (){var statearr_50849 = state_50846;
(statearr_50849[(4)] = cljs.core.cons.call(null,(5),(state_50846[(4)])));

return statearr_50849;
})();
var inst_50836 = fluree.db.operations.ledgers_async.call(null,conn);
var state_50846__$1 = state_50846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50846__$1,(6),inst_50836);
} else {
if((state_val_50847 === (3))){
var inst_50844 = (state_50846[(2)]);
var state_50846__$1 = state_50846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50846__$1,inst_50844);
} else {
if((state_val_50847 === (4))){
var inst_50828 = (state_50846[(2)]);
var inst_50829 = fluree.db.util.log.error.call(null,inst_50828);
var inst_50830 = reject.call(null,inst_50828);
var state_50846__$1 = (function (){var statearr_50851 = state_50846;
(statearr_50851[(7)] = inst_50829);

return statearr_50851;
})();
var statearr_50852_50864 = state_50846__$1;
(statearr_50852_50864[(2)] = inst_50830);

(statearr_50852_50864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50847 === (5))){
var _ = (function (){var statearr_50853 = state_50846;
(statearr_50853[(4)] = cljs.core.rest.call(null,(state_50846[(4)])));

return statearr_50853;
})();
var state_50846__$1 = state_50846;
var ex50850 = (state_50846__$1[(2)]);
var statearr_50854_50865 = state_50846__$1;
(statearr_50854_50865[(5)] = ex50850);


var statearr_50855_50866 = state_50846__$1;
(statearr_50855_50866[(1)] = (4));

(statearr_50855_50866[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50847 === (6))){
var inst_50838 = (state_50846[(2)]);
var inst_50839 = fluree.db.util.async.throw_err.call(null,inst_50838);
var inst_50840 = cljs.core.clj__GT_js.call(null,inst_50839);
var inst_50841 = resolve.call(null,inst_50840);
var _ = (function (){var statearr_50856 = state_50846;
(statearr_50856[(4)] = cljs.core.rest.call(null,(state_50846[(4)])));

return statearr_50856;
})();
var state_50846__$1 = state_50846;
var statearr_50857_50867 = state_50846__$1;
(statearr_50857_50867[(2)] = inst_50841);

(statearr_50857_50867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerList_$_state_machine__2721__auto__ = null;
var flureenjs$ledgerList_$_state_machine__2721__auto____0 = (function (){
var statearr_50858 = [null,null,null,null,null,null,null,null];
(statearr_50858[(0)] = flureenjs$ledgerList_$_state_machine__2721__auto__);

(statearr_50858[(1)] = (1));

return statearr_50858;
});
var flureenjs$ledgerList_$_state_machine__2721__auto____1 = (function (state_50846){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e50859){var ex__2724__auto__ = e50859;
var statearr_50860_50868 = state_50846;
(statearr_50860_50868[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50846[(4)]))){
var statearr_50861_50869 = state_50846;
(statearr_50861_50869[(1)] = cljs.core.first.call(null,(state_50846[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50870 = state_50846;
state_50846 = G__50870;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$ledgerList_$_state_machine__2721__auto__ = function(state_50846){
switch(arguments.length){
case 0:
return flureenjs$ledgerList_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$ledgerList_$_state_machine__2721__auto____1.call(this,state_50846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerList_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerList_$_state_machine__2721__auto____0;
flureenjs$ledgerList_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerList_$_state_machine__2721__auto____1;
return flureenjs$ledgerList_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_50862 = f__2744__auto__.call(null);
(statearr_50862[(6)] = c__2743__auto__);

return statearr_50862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerList', flureenjs.ledgerList);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 *     
 */
flureenjs.newLedger = (function flureenjs$newLedger(var_args){
var G__50872 = arguments.length;
switch (G__50872) {
case 2:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.newLedger', flureenjs.newLedger);

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.newLedger.call(null,conn,ledger,null);
}));

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_50990){
var state_val_50991 = (state_50990[(1)]);
if((state_val_50991 === (7))){
var inst_50895 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_50990__$1 = state_50990;
var statearr_50992_51057 = state_50990__$1;
(statearr_50992_51057[(2)] = inst_50895);

(statearr_50992_51057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (20))){
var inst_50902 = (state_50990[(7)]);
var inst_50940 = (state_50990[(2)]);
var inst_50941 = fluree.db.util.core.current_time_millis.call(null);
var state_50990__$1 = (function (){var statearr_50993 = state_50990;
(statearr_50993[(8)] = inst_50941);

(statearr_50993[(9)] = inst_50940);

return statearr_50993;
})();
if(cljs.core.truth_(inst_50902)){
var statearr_50994_51058 = state_50990__$1;
(statearr_50994_51058[(1)] = (21));

} else {
var statearr_50995_51059 = state_50990__$1;
(statearr_50995_51059[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (27))){
var inst_50954 = (state_50990[(10)]);
var inst_50956 = fluree.db.util.core.without_nils.call(null,inst_50954);
var inst_50957 = fluree.db.util.json.stringify.call(null,inst_50956);
var state_50990__$1 = state_50990;
var statearr_50996_51060 = state_50990__$1;
(statearr_50996_51060[(2)] = inst_50957);

(statearr_50996_51060[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (1))){
var state_50990__$1 = state_50990;
var statearr_50997_51061 = state_50990__$1;
(statearr_50997_51061[(2)] = null);

(statearr_50997_51061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (24))){
var inst_50908 = (state_50990[(11)]);
var state_50990__$1 = state_50990;
var statearr_50998_51062 = state_50990__$1;
(statearr_50998_51062[(2)] = inst_50908);

(statearr_50998_51062[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (4))){
var inst_50873 = (state_50990[(2)]);
var inst_50874 = fluree.db.util.log.error.call(null,inst_50873);
var inst_50875 = cljs.core.ex_data.call(null,inst_50873);
var inst_50876 = cljs.core.ex_message.call(null,inst_50873);
var inst_50877 = cljs.core.assoc.call(null,inst_50875,new cljs.core.Keyword(null,"message","message",-406056002),inst_50876);
var inst_50878 = cljs.core.clj__GT_js.call(null,inst_50877);
var inst_50879 = reject.call(null,inst_50878);
var state_50990__$1 = (function (){var statearr_50999 = state_50990;
(statearr_50999[(12)] = inst_50874);

return statearr_50999;
})();
var statearr_51000_51063 = state_50990__$1;
(statearr_51000_51063[(2)] = inst_50879);

(statearr_51000_51063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (15))){
var inst_50930 = (state_50990[(13)]);
var inst_50932 = fluree.db.graphdb.validate_ledger_name.call(null,inst_50930,"alias");
var state_50990__$1 = state_50990;
var statearr_51001_51064 = state_50990__$1;
(statearr_51001_51064[(2)] = inst_50932);

(statearr_51001_51064[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (21))){
var inst_50902 = (state_50990[(7)]);
var state_50990__$1 = state_50990;
var statearr_51002_51065 = state_50990__$1;
(statearr_51002_51065[(2)] = inst_50902);

(statearr_51002_51065[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (31))){
var state_50990__$1 = state_50990;
var statearr_51003_51066 = state_50990__$1;
(statearr_51003_51066[(2)] = null);

(statearr_51003_51066[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (32))){
var inst_50904 = (state_50990[(14)]);
var inst_50965 = (state_50990[(2)]);
var state_50990__$1 = (function (){var statearr_51004 = state_50990;
(statearr_51004[(15)] = inst_50965);

return statearr_51004;
})();
if(cljs.core.truth_(inst_50904)){
var statearr_51005_51067 = state_50990__$1;
(statearr_51005_51067[(1)] = (33));

} else {
var statearr_51006_51068 = state_50990__$1;
(statearr_51006_51068[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (33))){
var inst_50965 = (state_50990[(15)]);
var inst_50960 = (state_50990[(16)]);
var inst_50967 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_50968 = [inst_50960,inst_50965];
var inst_50969 = cljs.core.PersistentHashMap.fromArrays(inst_50967,inst_50968);
var inst_50970 = fluree.db.operations.command_async.call(null,conn,inst_50969);
var state_50990__$1 = state_50990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50990__$1,(36),inst_50970);
} else {
if((state_val_50991 === (13))){
var state_50990__$1 = state_50990;
var statearr_51007_51069 = state_50990__$1;
(statearr_51007_51069[(2)] = null);

(statearr_51007_51069[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (22))){
var inst_50941 = (state_50990[(8)]);
var state_50990__$1 = state_50990;
var statearr_51008_51070 = state_50990__$1;
(statearr_51008_51070[(2)] = inst_50941);

(statearr_51008_51070[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (36))){
var inst_50972 = (state_50990[(2)]);
var inst_50973 = fluree.db.util.async.throw_err.call(null,inst_50972);
var state_50990__$1 = state_50990;
var statearr_51009_51071 = state_50990__$1;
(statearr_51009_51071[(2)] = inst_50973);

(statearr_51009_51071[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (29))){
var inst_50904 = (state_50990[(14)]);
var inst_50960 = (state_50990[(2)]);
var state_50990__$1 = (function (){var statearr_51010 = state_50990;
(statearr_51010[(16)] = inst_50960);

return statearr_51010;
})();
if(cljs.core.truth_(inst_50904)){
var statearr_51011_51072 = state_50990__$1;
(statearr_51011_51072[(1)] = (30));

} else {
var statearr_51012_51073 = state_50990__$1;
(statearr_51012_51073[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (6))){
var state_50990__$1 = state_50990;
var statearr_51013_51074 = state_50990__$1;
(statearr_51013_51074[(2)] = null);

(statearr_51013_51074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (28))){
var state_50990__$1 = state_50990;
var statearr_51014_51075 = state_50990__$1;
(statearr_51014_51075[(2)] = null);

(statearr_51014_51075[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (25))){
var inst_50941 = (state_50990[(8)]);
var inst_50948 = (inst_50941 + (30000));
var state_50990__$1 = state_50990;
var statearr_51015_51076 = state_50990__$1;
(statearr_51015_51076[(2)] = inst_50948);

(statearr_51015_51076[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (34))){
var inst_50954 = (state_50990[(10)]);
var inst_50975 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_50954);
var state_50990__$1 = state_50990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50990__$1,(37),inst_50975);
} else {
if((state_val_50991 === (17))){
var inst_50911 = (state_50990[(17)]);
var inst_50935 = (state_50990[(2)]);
var state_50990__$1 = (function (){var statearr_51016 = state_50990;
(statearr_51016[(18)] = inst_50935);

return statearr_51016;
})();
if(cljs.core.truth_(inst_50911)){
var statearr_51017_51077 = state_50990__$1;
(statearr_51017_51077[(1)] = (18));

} else {
var statearr_51018_51078 = state_50990__$1;
(statearr_51018_51078[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (3))){
var inst_50988 = (state_50990[(2)]);
var state_50990__$1 = state_50990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50990__$1,inst_50988);
} else {
if((state_val_50991 === (12))){
var inst_50925 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_50990__$1 = state_50990;
var statearr_51019_51079 = state_50990__$1;
(statearr_51019_51079[(2)] = inst_50925);

(statearr_51019_51079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (2))){
var _ = (function (){var statearr_51020 = state_50990;
(statearr_51020[(4)] = cljs.core.cons.call(null,(5),(state_50990[(4)])));

return statearr_51020;
})();
var inst_50892 = (opts == null);
var state_50990__$1 = state_50990;
if(cljs.core.truth_(inst_50892)){
var statearr_51021_51080 = state_50990__$1;
(statearr_51021_51080[(1)] = (6));

} else {
var statearr_51022_51081 = state_50990__$1;
(statearr_51022_51081[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (23))){
var inst_50908 = (state_50990[(11)]);
var inst_50945 = (state_50990[(2)]);
var state_50990__$1 = (function (){var statearr_51023 = state_50990;
(statearr_51023[(19)] = inst_50945);

return statearr_51023;
})();
if(cljs.core.truth_(inst_50908)){
var statearr_51024_51082 = state_50990__$1;
(statearr_51024_51082[(1)] = (24));

} else {
var statearr_51025_51083 = state_50990__$1;
(statearr_51025_51083[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (35))){
var inst_50980 = (state_50990[(2)]);
var inst_50981 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_50982 = [(200),inst_50980];
var inst_50983 = cljs.core.PersistentHashMap.fromArrays(inst_50981,inst_50982);
var inst_50984 = cljs.core.clj__GT_js.call(null,inst_50983);
var inst_50985 = resolve.call(null,inst_50984);
var _ = (function (){var statearr_51026 = state_50990;
(statearr_51026[(4)] = cljs.core.rest.call(null,(state_50990[(4)])));

return statearr_51026;
})();
var state_50990__$1 = state_50990;
var statearr_51027_51084 = state_50990__$1;
(statearr_51027_51084[(2)] = inst_50985);

(statearr_51027_51084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (19))){
var state_50990__$1 = state_50990;
var statearr_51028_51085 = state_50990__$1;
(statearr_51028_51085[(2)] = null);

(statearr_51028_51085[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (11))){
var inst_50914 = (state_50990[(20)]);
var inst_50921 = (state_50990[(21)]);
var inst_50911 = (state_50990[(17)]);
var inst_50921__$1 = (state_50990[(2)]);
var inst_50922 = fluree.db.graphdb.validate_ledger_name.call(null,inst_50921__$1,"ledger");
var inst_50923 = fluree.db.graphdb.validate_ledger_name.call(null,inst_50914,"network");
var state_50990__$1 = (function (){var statearr_51030 = state_50990;
(statearr_51030[(21)] = inst_50921__$1);

(statearr_51030[(22)] = inst_50923);

(statearr_51030[(23)] = inst_50922);

return statearr_51030;
})();
if(cljs.core.truth_(inst_50911)){
var statearr_51031_51086 = state_50990__$1;
(statearr_51031_51086[(1)] = (12));

} else {
var statearr_51032_51087 = state_50990__$1;
(statearr_51032_51087[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (9))){
var inst_50915 = (state_50990[(24)]);
var inst_50918 = cljs.core.subs.call(null,inst_50915,(1));
var state_50990__$1 = state_50990;
var statearr_51033_51088 = state_50990__$1;
(statearr_51033_51088[(2)] = inst_50918);

(statearr_51033_51088[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (5))){
var _ = (function (){var statearr_51034 = state_50990;
(statearr_51034[(4)] = cljs.core.rest.call(null,(state_50990[(4)])));

return statearr_51034;
})();
var state_50990__$1 = state_50990;
var ex51029 = (state_50990__$1[(2)]);
var statearr_51035_51089 = state_50990__$1;
(statearr_51035_51089[(5)] = ex51029);


var statearr_51036_51090 = state_50990__$1;
(statearr_51036_51090[(1)] = (4));

(statearr_51036_51090[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (14))){
var inst_50911 = (state_50990[(17)]);
var inst_50928 = (state_50990[(2)]);
var inst_50929 = cljs.core.nth.call(null,inst_50928,(0),null);
var inst_50930 = cljs.core.nth.call(null,inst_50928,(1),null);
var state_50990__$1 = (function (){var statearr_51037 = state_50990;
(statearr_51037[(13)] = inst_50930);

(statearr_51037[(25)] = inst_50929);

return statearr_51037;
})();
if(cljs.core.truth_(inst_50911)){
var statearr_51038_51091 = state_50990__$1;
(statearr_51038_51091[(1)] = (15));

} else {
var statearr_51039_51092 = state_50990__$1;
(statearr_51039_51092[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (26))){
var inst_50906 = (state_50990[(26)]);
var inst_50914 = (state_50990[(20)]);
var inst_50910 = (state_50990[(27)]);
var inst_50903 = (state_50990[(28)]);
var inst_50921 = (state_50990[(21)]);
var inst_50912 = (state_50990[(29)]);
var inst_50901 = (state_50990[(30)]);
var inst_50907 = (state_50990[(31)]);
var inst_50905 = (state_50990[(32)]);
var inst_50945 = (state_50990[(19)]);
var inst_50940 = (state_50990[(9)]);
var inst_50904 = (state_50990[(14)]);
var inst_50909 = (state_50990[(33)]);
var inst_50950 = (state_50990[(2)]);
var inst_50951 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_50952 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50914),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50921)].join('');
var inst_50953 = [inst_50952,inst_50906,inst_50907,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_50950,inst_50909,inst_50940,inst_50912,inst_50910,inst_50901,inst_50945,inst_50903,inst_50905];
var inst_50954 = cljs.core.PersistentHashMap.fromArrays(inst_50951,inst_50953);
var state_50990__$1 = (function (){var statearr_51040 = state_50990;
(statearr_51040[(10)] = inst_50954);

return statearr_51040;
})();
if(cljs.core.truth_(inst_50904)){
var statearr_51041_51093 = state_50990__$1;
(statearr_51041_51093[(1)] = (27));

} else {
var statearr_51042_51094 = state_50990__$1;
(statearr_51042_51094[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (16))){
var state_50990__$1 = state_50990;
var statearr_51043_51095 = state_50990__$1;
(statearr_51043_51095[(2)] = null);

(statearr_51043_51095[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (30))){
var inst_50960 = (state_50990[(16)]);
var inst_50904 = (state_50990[(14)]);
var inst_50962 = fluree.crypto.sign_message.call(null,inst_50960,inst_50904);
var state_50990__$1 = state_50990;
var statearr_51044_51096 = state_50990__$1;
(statearr_51044_51096[(2)] = inst_50962);

(statearr_51044_51096[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (10))){
var inst_50915 = (state_50990[(24)]);
var state_50990__$1 = state_50990;
var statearr_51045_51097 = state_50990__$1;
(statearr_51045_51097[(2)] = inst_50915);

(statearr_51045_51097[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (18))){
var inst_50930 = (state_50990[(13)]);
var inst_50929 = (state_50990[(25)]);
var inst_50937 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50929),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50930)].join('');
var state_50990__$1 = state_50990;
var statearr_51046_51098 = state_50990__$1;
(statearr_51046_51098[(2)] = inst_50937);

(statearr_51046_51098[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (37))){
var inst_50977 = (state_50990[(2)]);
var inst_50978 = fluree.db.util.async.throw_err.call(null,inst_50977);
var state_50990__$1 = state_50990;
var statearr_51047_51099 = state_50990__$1;
(statearr_51047_51099[(2)] = inst_50978);

(statearr_51047_51099[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50991 === (8))){
var inst_50915 = (state_50990[(24)]);
var inst_50897 = (state_50990[(2)]);
var inst_50898 = fluree.db.connection_js.check_connection.call(null,conn,inst_50897);
var inst_50899 = cljs.core.__destructure_map.call(null,inst_50897);
var inst_50900 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_50901 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_50902 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_50903 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_50904 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_50905 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_50906 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_50907 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_50908 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_50909 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_50910 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_50911 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_50912 = cljs.core.get.call(null,inst_50899,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_50913 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_50914 = cljs.core.nth.call(null,inst_50913,(0),null);
var inst_50915__$1 = cljs.core.nth.call(null,inst_50913,(1),null);
var inst_50916 = clojure.string.starts_with_QMARK_.call(null,inst_50915__$1,"$");
var state_50990__$1 = (function (){var statearr_51048 = state_50990;
(statearr_51048[(34)] = inst_50898);

(statearr_51048[(11)] = inst_50908);

(statearr_51048[(26)] = inst_50906);

(statearr_51048[(20)] = inst_50914);

(statearr_51048[(27)] = inst_50910);

(statearr_51048[(7)] = inst_50902);

(statearr_51048[(28)] = inst_50903);

(statearr_51048[(17)] = inst_50911);

(statearr_51048[(29)] = inst_50912);

(statearr_51048[(30)] = inst_50901);

(statearr_51048[(31)] = inst_50907);

(statearr_51048[(35)] = inst_50900);

(statearr_51048[(32)] = inst_50905);

(statearr_51048[(24)] = inst_50915__$1);

(statearr_51048[(14)] = inst_50904);

(statearr_51048[(33)] = inst_50909);

return statearr_51048;
})();
if(inst_50916){
var statearr_51049_51100 = state_50990__$1;
(statearr_51049_51100[(1)] = (9));

} else {
var statearr_51050_51101 = state_50990__$1;
(statearr_51050_51101[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_51051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51051[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_51051[(1)] = (1));

return statearr_51051;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_50990){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_50990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51052){var ex__2724__auto__ = e51052;
var statearr_51053_51102 = state_50990;
(statearr_51053_51102[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_50990[(4)]))){
var statearr_51054_51103 = state_50990;
(statearr_51054_51103[(1)] = cljs.core.first.call(null,(state_50990[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51104 = state_50990;
state_50990 = G__51104;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_50990){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_50990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51055 = f__2744__auto__.call(null);
(statearr_51055[(6)] = c__2743__auto__);

return statearr_51055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.newLedger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *    tuple of either [network ledger alias] or [network ledger].
 * 
 *    An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *    the provided name is a ledger id.
 * 
 *    If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *    can be used for the name portion of the db-ident.
 * 
 *    i.e.
 *    - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *    - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolveLedger = (function flureenjs$resolveLedger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51120){
var state_val_51121 = (state_51120[(1)]);
if((state_val_51121 === (1))){
var state_51120__$1 = state_51120;
var statearr_51122_51137 = state_51120__$1;
(statearr_51122_51137[(2)] = null);

(statearr_51122_51137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51121 === (2))){
var _ = (function (){var statearr_51123 = state_51120;
(statearr_51123[(4)] = cljs.core.cons.call(null,(5),(state_51120[(4)])));

return statearr_51123;
})();
var inst_51113 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_51114 = cljs.core.clj__GT_js.call(null,inst_51113);
var inst_51115 = resolve.call(null,inst_51114);
var ___$1 = (function (){var statearr_51124 = state_51120;
(statearr_51124[(4)] = cljs.core.rest.call(null,(state_51120[(4)])));

return statearr_51124;
})();
var state_51120__$1 = state_51120;
var statearr_51125_51138 = state_51120__$1;
(statearr_51125_51138[(2)] = inst_51115);

(statearr_51125_51138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51121 === (3))){
var inst_51118 = (state_51120[(2)]);
var state_51120__$1 = state_51120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51120__$1,inst_51118);
} else {
if((state_val_51121 === (4))){
var inst_51105 = (state_51120[(2)]);
var inst_51106 = fluree.db.util.log.error.call(null,inst_51105);
var inst_51107 = reject.call(null,inst_51105);
var state_51120__$1 = (function (){var statearr_51127 = state_51120;
(statearr_51127[(7)] = inst_51106);

return statearr_51127;
})();
var statearr_51128_51139 = state_51120__$1;
(statearr_51128_51139[(2)] = inst_51107);

(statearr_51128_51139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51121 === (5))){
var _ = (function (){var statearr_51129 = state_51120;
(statearr_51129[(4)] = cljs.core.rest.call(null,(state_51120[(4)])));

return statearr_51129;
})();
var state_51120__$1 = state_51120;
var ex51126 = (state_51120__$1[(2)]);
var statearr_51130_51140 = state_51120__$1;
(statearr_51130_51140[(5)] = ex51126);


var statearr_51131_51141 = state_51120__$1;
(statearr_51131_51141[(1)] = (4));

(statearr_51131_51141[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolveLedger_$_state_machine__2721__auto__ = null;
var flureenjs$resolveLedger_$_state_machine__2721__auto____0 = (function (){
var statearr_51132 = [null,null,null,null,null,null,null,null];
(statearr_51132[(0)] = flureenjs$resolveLedger_$_state_machine__2721__auto__);

(statearr_51132[(1)] = (1));

return statearr_51132;
});
var flureenjs$resolveLedger_$_state_machine__2721__auto____1 = (function (state_51120){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51133){var ex__2724__auto__ = e51133;
var statearr_51134_51142 = state_51120;
(statearr_51134_51142[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51120[(4)]))){
var statearr_51135_51143 = state_51120;
(statearr_51135_51143[(1)] = cljs.core.first.call(null,(state_51120[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51144 = state_51120;
state_51120 = G__51144;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$resolveLedger_$_state_machine__2721__auto__ = function(state_51120){
switch(arguments.length){
case 0:
return flureenjs$resolveLedger_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$resolveLedger_$_state_machine__2721__auto____1.call(this,state_51120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolveLedger_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolveLedger_$_state_machine__2721__auto____0;
flureenjs$resolveLedger_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolveLedger_$_state_machine__2721__auto____1;
return flureenjs$resolveLedger_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51136 = f__2744__auto__.call(null);
(statearr_51136[(6)] = c__2743__auto__);

return statearr_51136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.resolveLedger', flureenjs.resolveLedger);
/**
 * Returns session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51160){
var state_val_51161 = (state_51160[(1)]);
if((state_val_51161 === (1))){
var state_51160__$1 = state_51160;
var statearr_51162_51177 = state_51160__$1;
(statearr_51162_51177[(2)] = null);

(statearr_51162_51177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51161 === (2))){
var _ = (function (){var statearr_51163 = state_51160;
(statearr_51163[(4)] = cljs.core.cons.call(null,(5),(state_51160[(4)])));

return statearr_51163;
})();
var inst_51153 = fluree.db.session.session.call(null,conn,ledger);
var inst_51154 = cljs.core.clj__GT_js.call(null,inst_51153);
var inst_51155 = resolve.call(null,inst_51154);
var ___$1 = (function (){var statearr_51164 = state_51160;
(statearr_51164[(4)] = cljs.core.rest.call(null,(state_51160[(4)])));

return statearr_51164;
})();
var state_51160__$1 = state_51160;
var statearr_51165_51178 = state_51160__$1;
(statearr_51165_51178[(2)] = inst_51155);

(statearr_51165_51178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51161 === (3))){
var inst_51158 = (state_51160[(2)]);
var state_51160__$1 = state_51160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51160__$1,inst_51158);
} else {
if((state_val_51161 === (4))){
var inst_51145 = (state_51160[(2)]);
var inst_51146 = fluree.db.util.log.error.call(null,inst_51145);
var inst_51147 = reject.call(null,inst_51145);
var state_51160__$1 = (function (){var statearr_51167 = state_51160;
(statearr_51167[(7)] = inst_51146);

return statearr_51167;
})();
var statearr_51168_51179 = state_51160__$1;
(statearr_51168_51179[(2)] = inst_51147);

(statearr_51168_51179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51161 === (5))){
var _ = (function (){var statearr_51169 = state_51160;
(statearr_51169[(4)] = cljs.core.rest.call(null,(state_51160[(4)])));

return statearr_51169;
})();
var state_51160__$1 = state_51160;
var ex51166 = (state_51160__$1[(2)]);
var statearr_51170_51180 = state_51160__$1;
(statearr_51170_51180[(5)] = ex51166);


var statearr_51171_51181 = state_51160__$1;
(statearr_51171_51181[(1)] = (4));

(statearr_51171_51181[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__2721__auto__ = null;
var flureenjs$session_$_state_machine__2721__auto____0 = (function (){
var statearr_51172 = [null,null,null,null,null,null,null,null];
(statearr_51172[(0)] = flureenjs$session_$_state_machine__2721__auto__);

(statearr_51172[(1)] = (1));

return statearr_51172;
});
var flureenjs$session_$_state_machine__2721__auto____1 = (function (state_51160){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51173){var ex__2724__auto__ = e51173;
var statearr_51174_51182 = state_51160;
(statearr_51174_51182[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51160[(4)]))){
var statearr_51175_51183 = state_51160;
(statearr_51175_51183[(1)] = cljs.core.first.call(null,(state_51160[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51184 = state_51160;
state_51160 = G__51184;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__2721__auto__ = function(state_51160){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__2721__auto____1.call(this,state_51160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__2721__auto____0;
flureenjs$session_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__2721__auto____1;
return flureenjs$session_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51176 = f__2744__auto__.call(null);
(statearr_51176[(6)] = c__2743__auto__);

return statearr_51176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51208){
var state_val_51209 = (state_51208[(1)]);
if((state_val_51209 === (1))){
var state_51208__$1 = state_51208;
var statearr_51210_51226 = state_51208__$1;
(statearr_51210_51226[(2)] = null);

(statearr_51210_51226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51209 === (2))){
var _ = (function (){var statearr_51211 = state_51208;
(statearr_51211[(4)] = cljs.core.cons.call(null,(5),(state_51208[(4)])));

return statearr_51211;
})();
var inst_51193 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_51208__$1 = (function (){var statearr_51212 = state_51208;
(statearr_51212[(7)] = inst_51193);

return statearr_51212;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51208__$1,(7),db);
} else {
if((state_val_51209 === (3))){
var inst_51206 = (state_51208[(2)]);
var state_51208__$1 = state_51208;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51208__$1,inst_51206);
} else {
if((state_val_51209 === (4))){
var inst_51185 = (state_51208[(2)]);
var inst_51186 = fluree.db.util.log.error.call(null,inst_51185);
var inst_51187 = reject.call(null,inst_51185);
var state_51208__$1 = (function (){var statearr_51214 = state_51208;
(statearr_51214[(8)] = inst_51186);

return statearr_51214;
})();
var statearr_51215_51227 = state_51208__$1;
(statearr_51215_51227[(2)] = inst_51187);

(statearr_51215_51227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51209 === (5))){
var _ = (function (){var statearr_51216 = state_51208;
(statearr_51216[(4)] = cljs.core.rest.call(null,(state_51208[(4)])));

return statearr_51216;
})();
var state_51208__$1 = state_51208;
var ex51213 = (state_51208__$1[(2)]);
var statearr_51217_51228 = state_51208__$1;
(statearr_51217_51228[(5)] = ex51213);


var statearr_51218_51229 = state_51208__$1;
(statearr_51218_51229[(1)] = (4));

(statearr_51218_51229[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51209 === (6))){
var inst_51199 = (state_51208[(2)]);
var inst_51200 = fluree.db.util.async.throw_err.call(null,inst_51199);
var inst_51201 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_51200);
var inst_51202 = cljs.core.clj__GT_js.call(null,inst_51201);
var inst_51203 = resolve.call(null,inst_51202);
var _ = (function (){var statearr_51219 = state_51208;
(statearr_51219[(4)] = cljs.core.rest.call(null,(state_51208[(4)])));

return statearr_51219;
})();
var state_51208__$1 = state_51208;
var statearr_51220_51230 = state_51208__$1;
(statearr_51220_51230[(2)] = inst_51203);

(statearr_51220_51230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51209 === (7))){
var inst_51193 = (state_51208[(7)]);
var inst_51195 = (state_51208[(2)]);
var inst_51196 = fluree.db.util.async.throw_err.call(null,inst_51195);
var inst_51197 = fluree.db.dbproto._search.call(null,inst_51196,inst_51193);
var state_51208__$1 = state_51208;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51208__$1,(6),inst_51197);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__2721__auto__ = null;
var flureenjs$search_$_state_machine__2721__auto____0 = (function (){
var statearr_51221 = [null,null,null,null,null,null,null,null,null];
(statearr_51221[(0)] = flureenjs$search_$_state_machine__2721__auto__);

(statearr_51221[(1)] = (1));

return statearr_51221;
});
var flureenjs$search_$_state_machine__2721__auto____1 = (function (state_51208){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51208);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51222){var ex__2724__auto__ = e51222;
var statearr_51223_51231 = state_51208;
(statearr_51223_51231[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51208[(4)]))){
var statearr_51224_51232 = state_51208;
(statearr_51224_51232[(1)] = cljs.core.first.call(null,(state_51208[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51233 = state_51208;
state_51208 = G__51233;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__2721__auto__ = function(state_51208){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__2721__auto____1.call(this,state_51208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__2721__auto____0;
flureenjs$search_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__2721__auto____1;
return flureenjs$search_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51225 = f__2744__auto__.call(null);
(statearr_51225[(6)] = c__2743__auto__);

return statearr_51225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 *     including the provided flakes. Flakes can contain one or more 't's,
 *     but should be sequential and start after the current 't' of the provided
 *     db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 *     't' is negative and thus should be in descending order.
 * 
 *     A forward-time-travel db can be further forward-time-traveled.
 * 
 *     A forward-time travel DB is held in memory, and is not shared across servers.
 *     Ensure you have adequate memory to hold the flakes you generate and add. If
 *     access is provided via an external API, do any desired size restrictions or
 *     controls within your API endpoint.
 * 
 *     Remember schema operations done via forward-time-travel should be done in a
 *     't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forwardTimeTravel = (function flureenjs$forwardTimeTravel(db,flakes){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51254){
var state_val_51255 = (state_51254[(1)]);
if((state_val_51255 === (1))){
var state_51254__$1 = state_51254;
var statearr_51256_51272 = state_51254__$1;
(statearr_51256_51272[(2)] = null);

(statearr_51256_51272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51255 === (2))){
var _ = (function (){var statearr_51257 = state_51254;
(statearr_51257[(4)] = cljs.core.cons.call(null,(5),(state_51254[(4)])));

return statearr_51257;
})();
var inst_51242 = cljs.core.js__GT_clj.call(null,flakes);
var inst_51243 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_51242);
var state_51254__$1 = (function (){var statearr_51258 = state_51254;
(statearr_51258[(7)] = inst_51243);

return statearr_51258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51254__$1,(6),db);
} else {
if((state_val_51255 === (3))){
var inst_51252 = (state_51254[(2)]);
var state_51254__$1 = state_51254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51254__$1,inst_51252);
} else {
if((state_val_51255 === (4))){
var inst_51234 = (state_51254[(2)]);
var inst_51235 = fluree.db.util.log.error.call(null,inst_51234);
var inst_51236 = reject.call(null,inst_51234);
var state_51254__$1 = (function (){var statearr_51260 = state_51254;
(statearr_51260[(8)] = inst_51235);

return statearr_51260;
})();
var statearr_51261_51273 = state_51254__$1;
(statearr_51261_51273[(2)] = inst_51236);

(statearr_51261_51273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51255 === (5))){
var _ = (function (){var statearr_51262 = state_51254;
(statearr_51262[(4)] = cljs.core.rest.call(null,(state_51254[(4)])));

return statearr_51262;
})();
var state_51254__$1 = state_51254;
var ex51259 = (state_51254__$1[(2)]);
var statearr_51263_51274 = state_51254__$1;
(statearr_51263_51274[(5)] = ex51259);


var statearr_51264_51275 = state_51254__$1;
(statearr_51264_51275[(1)] = (4));

(statearr_51264_51275[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51255 === (6))){
var inst_51243 = (state_51254[(7)]);
var inst_51245 = (state_51254[(2)]);
var inst_51246 = fluree.db.util.async.throw_err.call(null,inst_51245);
var inst_51247 = fluree.db.graphdb.forward_time_travel.call(null,inst_51246,null,inst_51243);
var inst_51248 = cljs.core.clj__GT_js.call(null,inst_51247);
var inst_51249 = resolve.call(null,inst_51248);
var _ = (function (){var statearr_51265 = state_51254;
(statearr_51265[(4)] = cljs.core.rest.call(null,(state_51254[(4)])));

return statearr_51265;
})();
var state_51254__$1 = state_51254;
var statearr_51266_51276 = state_51254__$1;
(statearr_51266_51276[(2)] = inst_51249);

(statearr_51266_51276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forwardTimeTravel_$_state_machine__2721__auto__ = null;
var flureenjs$forwardTimeTravel_$_state_machine__2721__auto____0 = (function (){
var statearr_51267 = [null,null,null,null,null,null,null,null,null];
(statearr_51267[(0)] = flureenjs$forwardTimeTravel_$_state_machine__2721__auto__);

(statearr_51267[(1)] = (1));

return statearr_51267;
});
var flureenjs$forwardTimeTravel_$_state_machine__2721__auto____1 = (function (state_51254){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51268){var ex__2724__auto__ = e51268;
var statearr_51269_51277 = state_51254;
(statearr_51269_51277[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51254[(4)]))){
var statearr_51270_51278 = state_51254;
(statearr_51270_51278[(1)] = cljs.core.first.call(null,(state_51254[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51279 = state_51254;
state_51254 = G__51279;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$forwardTimeTravel_$_state_machine__2721__auto__ = function(state_51254){
switch(arguments.length){
case 0:
return flureenjs$forwardTimeTravel_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$forwardTimeTravel_$_state_machine__2721__auto____1.call(this,state_51254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forwardTimeTravel_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forwardTimeTravel_$_state_machine__2721__auto____0;
flureenjs$forwardTimeTravel_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forwardTimeTravel_$_state_machine__2721__auto____1;
return flureenjs$forwardTimeTravel_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51271 = f__2744__auto__.call(null);
(statearr_51271[(6)] = c__2743__auto__);

return statearr_51271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.forwardTimeTravel', flureenjs.forwardTimeTravel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.isForwardTimeTravelDb = (function flureenjs$isForwardTimeTravelDb(db){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51303){
var state_val_51304 = (state_51303[(1)]);
if((state_val_51304 === (7))){
var state_51303__$1 = state_51303;
var statearr_51305_51324 = state_51303__$1;
(statearr_51305_51324[(2)] = db);

(statearr_51305_51324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51304 === (1))){
var state_51303__$1 = state_51303;
var statearr_51306_51325 = state_51303__$1;
(statearr_51306_51325[(2)] = null);

(statearr_51306_51325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51304 === (4))){
var inst_51280 = (state_51303[(2)]);
var inst_51281 = fluree.db.util.log.error.call(null,inst_51280);
var inst_51282 = reject.call(null,inst_51280);
var state_51303__$1 = (function (){var statearr_51307 = state_51303;
(statearr_51307[(7)] = inst_51281);

return statearr_51307;
})();
var statearr_51308_51326 = state_51303__$1;
(statearr_51308_51326[(2)] = inst_51282);

(statearr_51308_51326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51304 === (6))){
var state_51303__$1 = state_51303;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51303__$1,(9),db);
} else {
if((state_val_51304 === (3))){
var inst_51301 = (state_51303[(2)]);
var state_51303__$1 = state_51303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51303__$1,inst_51301);
} else {
if((state_val_51304 === (2))){
var _ = (function (){var statearr_51310 = state_51303;
(statearr_51310[(4)] = cljs.core.cons.call(null,(5),(state_51303[(4)])));

return statearr_51310;
})();
var inst_51288 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_51303__$1 = state_51303;
if(inst_51288){
var statearr_51311_51327 = state_51303__$1;
(statearr_51311_51327[(1)] = (6));

} else {
var statearr_51312_51328 = state_51303__$1;
(statearr_51312_51328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51304 === (9))){
var inst_51291 = (state_51303[(2)]);
var inst_51292 = fluree.db.util.async.throw_err.call(null,inst_51291);
var state_51303__$1 = state_51303;
var statearr_51313_51329 = state_51303__$1;
(statearr_51313_51329[(2)] = inst_51292);

(statearr_51313_51329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51304 === (5))){
var _ = (function (){var statearr_51314 = state_51303;
(statearr_51314[(4)] = cljs.core.rest.call(null,(state_51303[(4)])));

return statearr_51314;
})();
var state_51303__$1 = state_51303;
var ex51309 = (state_51303__$1[(2)]);
var statearr_51315_51330 = state_51303__$1;
(statearr_51315_51330[(5)] = ex51309);


var statearr_51316_51331 = state_51303__$1;
(statearr_51316_51331[(1)] = (4));

(statearr_51316_51331[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51304 === (8))){
var inst_51295 = (state_51303[(2)]);
var inst_51296 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_51295);
var inst_51297 = cljs.core.clj__GT_js.call(null,inst_51296);
var inst_51298 = resolve.call(null,inst_51297);
var _ = (function (){var statearr_51317 = state_51303;
(statearr_51317[(4)] = cljs.core.rest.call(null,(state_51303[(4)])));

return statearr_51317;
})();
var state_51303__$1 = state_51303;
var statearr_51318_51332 = state_51303__$1;
(statearr_51318_51332[(2)] = inst_51298);

(statearr_51318_51332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto__ = null;
var flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto____0 = (function (){
var statearr_51319 = [null,null,null,null,null,null,null,null];
(statearr_51319[(0)] = flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto__);

(statearr_51319[(1)] = (1));

return statearr_51319;
});
var flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto____1 = (function (state_51303){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51320){var ex__2724__auto__ = e51320;
var statearr_51321_51333 = state_51303;
(statearr_51321_51333[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51303[(4)]))){
var statearr_51322_51334 = state_51303;
(statearr_51322_51334[(1)] = cljs.core.first.call(null,(state_51303[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51335 = state_51303;
state_51303 = G__51335;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto__ = function(state_51303){
switch(arguments.length){
case 0:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto____1.call(this,state_51303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto____0;
flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto____1;
return flureenjs$isForwardTimeTravelDb_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51323 = f__2744__auto__.call(null);
(statearr_51323[(6)] = c__2743__auto__);

return statearr_51323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.isForwardTimeTravelDb', flureenjs.isForwardTimeTravelDb);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitorTx = (function flureenjs$monitorTx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51355){
var state_val_51356 = (state_51355[(1)]);
if((state_val_51356 === (1))){
var state_51355__$1 = state_51355;
var statearr_51357_51373 = state_51355__$1;
(statearr_51357_51373[(2)] = null);

(statearr_51357_51373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51356 === (2))){
var _ = (function (){var statearr_51358 = state_51355;
(statearr_51358[(4)] = cljs.core.cons.call(null,(5),(state_51355[(4)])));

return statearr_51358;
})();
var inst_51345 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_51346 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_51355__$1 = (function (){var statearr_51359 = state_51355;
(statearr_51359[(7)] = inst_51345);

return statearr_51359;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51355__$1,(6),inst_51346);
} else {
if((state_val_51356 === (3))){
var inst_51353 = (state_51355[(2)]);
var state_51355__$1 = state_51355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51355__$1,inst_51353);
} else {
if((state_val_51356 === (4))){
var inst_51336 = (state_51355[(2)]);
var inst_51337 = fluree.db.util.log.error.call(null,inst_51336);
var inst_51338 = cljs.core.clj__GT_js.call(null,inst_51336);
var inst_51339 = reject.call(null,inst_51338);
var state_51355__$1 = (function (){var statearr_51361 = state_51355;
(statearr_51361[(8)] = inst_51337);

return statearr_51361;
})();
var statearr_51362_51374 = state_51355__$1;
(statearr_51362_51374[(2)] = inst_51339);

(statearr_51362_51374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51356 === (5))){
var _ = (function (){var statearr_51363 = state_51355;
(statearr_51363[(4)] = cljs.core.rest.call(null,(state_51355[(4)])));

return statearr_51363;
})();
var state_51355__$1 = state_51355;
var ex51360 = (state_51355__$1[(2)]);
var statearr_51364_51375 = state_51355__$1;
(statearr_51364_51375[(5)] = ex51360);


var statearr_51365_51376 = state_51355__$1;
(statearr_51365_51376[(1)] = (4));

(statearr_51365_51376[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51356 === (6))){
var inst_51348 = (state_51355[(2)]);
var inst_51349 = cljs.core.clj__GT_js.call(null,inst_51348);
var inst_51350 = resolve.call(null,inst_51349);
var _ = (function (){var statearr_51366 = state_51355;
(statearr_51366[(4)] = cljs.core.rest.call(null,(state_51355[(4)])));

return statearr_51366;
})();
var state_51355__$1 = state_51355;
var statearr_51367_51377 = state_51355__$1;
(statearr_51367_51377[(2)] = inst_51350);

(statearr_51367_51377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitorTx_$_state_machine__2721__auto__ = null;
var flureenjs$monitorTx_$_state_machine__2721__auto____0 = (function (){
var statearr_51368 = [null,null,null,null,null,null,null,null,null];
(statearr_51368[(0)] = flureenjs$monitorTx_$_state_machine__2721__auto__);

(statearr_51368[(1)] = (1));

return statearr_51368;
});
var flureenjs$monitorTx_$_state_machine__2721__auto____1 = (function (state_51355){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51369){var ex__2724__auto__ = e51369;
var statearr_51370_51378 = state_51355;
(statearr_51370_51378[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51355[(4)]))){
var statearr_51371_51379 = state_51355;
(statearr_51371_51379[(1)] = cljs.core.first.call(null,(state_51355[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51380 = state_51355;
state_51355 = G__51380;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$monitorTx_$_state_machine__2721__auto__ = function(state_51355){
switch(arguments.length){
case 0:
return flureenjs$monitorTx_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$monitorTx_$_state_machine__2721__auto____1.call(this,state_51355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitorTx_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitorTx_$_state_machine__2721__auto____0;
flureenjs$monitorTx_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitorTx_$_state_machine__2721__auto____1;
return flureenjs$monitorTx_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51372 = f__2744__auto__.call(null);
(statearr_51372[(6)] = c__2743__auto__);

return statearr_51372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.monitorTx', flureenjs.monitorTx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *    producing a signed command.
 * 
 *    Optional opts is a map with the following keys. If not provided,
 *    defaults will be attempted.
 *    - auth        - The auth id for the auth record being used. The private key must
 *                    correspond to this auth record, or an authority of this auth record.
 *    - expire      - When this transaction should expire if not yet attempted.
 *                    Defaults to 5 minutes.
 *    - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                    By default epoch milliseconds is used.
 *    - deps        - Not yet implemented, list of dependent transactions.
 * 
 *    If successful, will return a map with four keys:
 *      - cmd  - a map with the command/transaction data as a JSON string
 *      - sig  - the signature of the above stringified map
 *      - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *      - db   - the ledger for this transaction
 */
flureenjs.txToCommand = (function flureenjs$txToCommand(var_args){
var G__51382 = arguments.length;
switch (G__51382) {
case 3:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.txToCommand.call(null,ledger,txn,private_key,null);
}));

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51491){
var state_val_51492 = (state_51491[(1)]);
if((state_val_51492 === (7))){
var state_51491__$1 = state_51491;
var statearr_51493_51560 = state_51491__$1;
(statearr_51493_51560[(2)] = ledger);

(statearr_51493_51560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (20))){
var inst_51408 = (state_51491[(7)]);
var inst_51448 = (state_51491[(2)]);
var inst_51449 = cljs.core.nth.call(null,inst_51448,(0),null);
var inst_51450 = cljs.core.nth.call(null,inst_51448,(1),null);
var inst_51451 = fluree.db.util.core.current_time_millis.call(null);
var state_51491__$1 = (function (){var statearr_51494 = state_51491;
(statearr_51494[(8)] = inst_51450);

(statearr_51494[(9)] = inst_51449);

(statearr_51494[(10)] = inst_51451);

return statearr_51494;
})();
if(cljs.core.truth_(inst_51408)){
var statearr_51495_51561 = state_51491__$1;
(statearr_51495_51561[(1)] = (27));

} else {
var statearr_51496_51562 = state_51491__$1;
(statearr_51496_51562[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (27))){
var inst_51408 = (state_51491[(7)]);
var state_51491__$1 = state_51491;
var statearr_51497_51563 = state_51491__$1;
(statearr_51497_51563[(2)] = inst_51408);

(statearr_51497_51563[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (1))){
var state_51491__$1 = state_51491;
var statearr_51498_51564 = state_51491__$1;
(statearr_51498_51564[(2)] = null);

(statearr_51498_51564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (24))){
var inst_51422 = (state_51491[(11)]);
var inst_51439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51440 = [inst_51422,null];
var inst_51441 = (new cljs.core.PersistentVector(null,2,(5),inst_51439,inst_51440,null));
var state_51491__$1 = state_51491;
var statearr_51499_51565 = state_51491__$1;
(statearr_51499_51565[(2)] = inst_51441);

(statearr_51499_51565[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (4))){
var inst_51383 = (state_51491[(2)]);
var inst_51384 = fluree.db.util.log.error.call(null,inst_51383);
var inst_51385 = cljs.core.clj__GT_js.call(null,inst_51383);
var inst_51386 = reject.call(null,inst_51385);
var state_51491__$1 = (function (){var statearr_51500 = state_51491;
(statearr_51500[(12)] = inst_51384);

return statearr_51500;
})();
var statearr_51501_51566 = state_51491__$1;
(statearr_51501_51566[(2)] = inst_51386);

(statearr_51501_51566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (15))){
var inst_51422 = (state_51491[(11)]);
var inst_51406 = (state_51491[(13)]);
var inst_51424 = cljs.core.not_EQ_.call(null,inst_51406,inst_51422);
var state_51491__$1 = state_51491;
var statearr_51502_51567 = state_51491__$1;
(statearr_51502_51567[(2)] = inst_51424);

(statearr_51502_51567[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (21))){
var inst_51406 = (state_51491[(13)]);
var inst_51434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51435 = [inst_51406,null];
var inst_51436 = (new cljs.core.PersistentVector(null,2,(5),inst_51434,inst_51435,null));
var state_51491__$1 = state_51491;
var statearr_51503_51568 = state_51491__$1;
(statearr_51503_51568[(2)] = inst_51436);

(statearr_51503_51568[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (31))){
var inst_51451 = (state_51491[(10)]);
var inst_51458 = (inst_51451 + (30000));
var state_51491__$1 = state_51491;
var statearr_51504_51569 = state_51491__$1;
(statearr_51504_51569[(2)] = inst_51458);

(statearr_51504_51569[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (32))){
var inst_51460 = (state_51491[(2)]);
var state_51491__$1 = (function (){var statearr_51505 = state_51491;
(statearr_51505[(14)] = inst_51460);

return statearr_51505;
})();
var statearr_51506_51570 = state_51491__$1;
(statearr_51506_51570[(2)] = null);

(statearr_51506_51570[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (33))){
var inst_51450 = (state_51491[(8)]);
var inst_51403 = (state_51491[(15)]);
var inst_51409 = (state_51491[(16)]);
var inst_51460 = (state_51491[(14)]);
var inst_51449 = (state_51491[(9)]);
var inst_51455 = (state_51491[(17)]);
var _ = (function (){var statearr_51507 = state_51491;
(statearr_51507[(4)] = cljs.core.cons.call(null,(36),(state_51491[(4)])));

return statearr_51507;
})();
var inst_51473 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_51474 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_51403,txn,inst_51455,inst_51449,inst_51450,inst_51460,inst_51409];
var inst_51475 = cljs.core.PersistentHashMap.fromArrays(inst_51473,inst_51474);
var inst_51476 = fluree.db.util.core.without_nils.call(null,inst_51475);
var inst_51477 = fluree.db.util.json.stringify.call(null,inst_51476);
var ___$1 = (function (){var statearr_51508 = state_51491;
(statearr_51508[(4)] = cljs.core.rest.call(null,(state_51491[(4)])));

return statearr_51508;
})();
var state_51491__$1 = state_51491;
var statearr_51509_51571 = state_51491__$1;
(statearr_51509_51571[(2)] = inst_51477);

(statearr_51509_51571[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (13))){
var inst_51414 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_51415 = (new Error(inst_51414));
var inst_51416 = (function(){throw inst_51415})();
var state_51491__$1 = state_51491;
var statearr_51511_51572 = state_51491__$1;
(statearr_51511_51572[(2)] = inst_51416);

(statearr_51511_51572[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (22))){
var state_51491__$1 = state_51491;
var statearr_51512_51573 = state_51491__$1;
(statearr_51512_51573[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (36))){
var _ = (function (){var statearr_51514 = state_51491;
(statearr_51514[(4)] = cljs.core.rest.call(null,(state_51491[(4)])));

return statearr_51514;
})();
var state_51491__$1 = state_51491;
var ex51510 = (state_51491__$1[(2)]);
var statearr_51515_51574 = state_51491__$1;
(statearr_51515_51574[(5)] = ex51510);


var statearr_51516_51575 = state_51491__$1;
(statearr_51516_51575[(1)] = (35));

(statearr_51516_51575[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (29))){
var inst_51407 = (state_51491[(18)]);
var inst_51455 = (state_51491[(2)]);
var state_51491__$1 = (function (){var statearr_51517 = state_51491;
(statearr_51517[(17)] = inst_51455);

return statearr_51517;
})();
if(cljs.core.truth_(inst_51407)){
var statearr_51518_51576 = state_51491__$1;
(statearr_51518_51576[(1)] = (30));

} else {
var statearr_51519_51577 = state_51491__$1;
(statearr_51519_51577[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (6))){
var inst_51398 = cljs.core.first.call(null,ledger);
var inst_51399 = cljs.core.second.call(null,ledger);
var inst_51400 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51398),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51399)].join('');
var state_51491__$1 = state_51491;
var statearr_51520_51578 = state_51491__$1;
(statearr_51520_51578[(2)] = inst_51400);

(statearr_51520_51578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (28))){
var inst_51451 = (state_51491[(10)]);
var state_51491__$1 = state_51491;
var statearr_51521_51579 = state_51491__$1;
(statearr_51521_51579[(2)] = inst_51451);

(statearr_51521_51579[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (25))){
var state_51491__$1 = state_51491;
var statearr_51522_51580 = state_51491__$1;
(statearr_51522_51580[(2)] = null);

(statearr_51522_51580[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (34))){
var inst_51480 = (state_51491[(2)]);
var inst_51481 = fluree.crypto.sign_message.call(null,inst_51480,private_key);
var inst_51482 = fluree.crypto.sha3_256.call(null,inst_51480);
var inst_51483 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"db","db",993250759)];
var inst_51484 = [inst_51480,inst_51481,inst_51482,ledger];
var inst_51485 = cljs.core.PersistentHashMap.fromArrays(inst_51483,inst_51484);
var inst_51486 = resolve.call(null,inst_51485);
var _ = (function (){var statearr_51523 = state_51491;
(statearr_51523[(4)] = cljs.core.rest.call(null,(state_51491[(4)])));

return statearr_51523;
})();
var state_51491__$1 = state_51491;
var statearr_51524_51581 = state_51491__$1;
(statearr_51524_51581[(2)] = inst_51486);

(statearr_51524_51581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (17))){
var inst_51427 = (state_51491[(2)]);
var state_51491__$1 = state_51491;
if(cljs.core.truth_(inst_51427)){
var statearr_51525_51582 = state_51491__$1;
(statearr_51525_51582[(1)] = (18));

} else {
var statearr_51526_51583 = state_51491__$1;
(statearr_51526_51583[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (3))){
var inst_51489 = (state_51491[(2)]);
var state_51491__$1 = state_51491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51491__$1,inst_51489);
} else {
if((state_val_51492 === (12))){
var state_51491__$1 = state_51491;
var statearr_51527_51584 = state_51491__$1;
(statearr_51527_51584[(2)] = null);

(statearr_51527_51584[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (2))){
var _ = (function (){var statearr_51528 = state_51491;
(statearr_51528[(4)] = cljs.core.cons.call(null,(5),(state_51491[(4)])));

return statearr_51528;
})();
var inst_51396 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_51491__$1 = state_51491;
if(inst_51396){
var statearr_51529_51585 = state_51491__$1;
(statearr_51529_51585[(1)] = (6));

} else {
var statearr_51530_51586 = state_51491__$1;
(statearr_51530_51586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (23))){
var inst_51446 = (state_51491[(2)]);
var state_51491__$1 = state_51491;
var statearr_51531_51587 = state_51491__$1;
(statearr_51531_51587[(2)] = inst_51446);

(statearr_51531_51587[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (35))){
var inst_51461 = (state_51491[(2)]);
var inst_51462 = fluree.db.util.log.error.call(null,inst_51461);
var inst_51463 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_51464 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_51465 = cljs.core.PersistentHashMap.fromArrays(inst_51463,inst_51464);
var inst_51466 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_51465);
var inst_51467 = (function(){throw inst_51466})();
var state_51491__$1 = (function (){var statearr_51532 = state_51491;
(statearr_51532[(19)] = inst_51462);

return statearr_51532;
})();
var statearr_51533_51588 = state_51491__$1;
(statearr_51533_51588[(2)] = inst_51467);

(statearr_51533_51588[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (19))){
var inst_51406 = (state_51491[(13)]);
var state_51491__$1 = state_51491;
if(cljs.core.truth_(inst_51406)){
var statearr_51534_51589 = state_51491__$1;
(statearr_51534_51589[(1)] = (21));

} else {
var statearr_51535_51590 = state_51491__$1;
(statearr_51535_51590[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (11))){
var inst_51406 = (state_51491[(13)]);
var inst_51421 = (state_51491[(2)]);
var inst_51422 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_51491__$1 = (function (){var statearr_51537 = state_51491;
(statearr_51537[(11)] = inst_51422);

(statearr_51537[(20)] = inst_51421);

return statearr_51537;
})();
if(cljs.core.truth_(inst_51406)){
var statearr_51538_51591 = state_51491__$1;
(statearr_51538_51591[(1)] = (15));

} else {
var statearr_51539_51592 = state_51491__$1;
(statearr_51539_51592[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (9))){
var inst_51409 = (state_51491[(16)]);
var inst_51411 = cljs.core.sequential_QMARK_.call(null,inst_51409);
var state_51491__$1 = state_51491;
if(inst_51411){
var statearr_51540_51593 = state_51491__$1;
(statearr_51540_51593[(1)] = (12));

} else {
var statearr_51541_51594 = state_51491__$1;
(statearr_51541_51594[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (5))){
var _ = (function (){var statearr_51542 = state_51491;
(statearr_51542[(4)] = cljs.core.rest.call(null,(state_51491[(4)])));

return statearr_51542;
})();
var state_51491__$1 = state_51491;
var ex51536 = (state_51491__$1[(2)]);
var statearr_51543_51595 = state_51491__$1;
(statearr_51543_51595[(5)] = ex51536);


var statearr_51544_51596 = state_51491__$1;
(statearr_51544_51596[(1)] = (4));

(statearr_51544_51596[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (14))){
var inst_51418 = (state_51491[(2)]);
var state_51491__$1 = state_51491;
var statearr_51545_51597 = state_51491__$1;
(statearr_51545_51597[(2)] = inst_51418);

(statearr_51545_51597[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (26))){
var inst_51444 = (state_51491[(2)]);
var state_51491__$1 = state_51491;
var statearr_51546_51598 = state_51491__$1;
(statearr_51546_51598[(2)] = inst_51444);

(statearr_51546_51598[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (16))){
var inst_51406 = (state_51491[(13)]);
var state_51491__$1 = state_51491;
var statearr_51547_51599 = state_51491__$1;
(statearr_51547_51599[(2)] = inst_51406);

(statearr_51547_51599[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (30))){
var inst_51407 = (state_51491[(18)]);
var state_51491__$1 = state_51491;
var statearr_51548_51600 = state_51491__$1;
(statearr_51548_51600[(2)] = inst_51407);

(statearr_51548_51600[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (10))){
var state_51491__$1 = state_51491;
var statearr_51549_51601 = state_51491__$1;
(statearr_51549_51601[(2)] = null);

(statearr_51549_51601[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (18))){
var inst_51422 = (state_51491[(11)]);
var inst_51406 = (state_51491[(13)]);
var inst_51429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51430 = [inst_51406,inst_51422];
var inst_51431 = (new cljs.core.PersistentVector(null,2,(5),inst_51429,inst_51430,null));
var state_51491__$1 = state_51491;
var statearr_51550_51602 = state_51491__$1;
(statearr_51550_51602[(2)] = inst_51431);

(statearr_51550_51602[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51492 === (8))){
var inst_51409 = (state_51491[(16)]);
var inst_51403 = (state_51491[(2)]);
var inst_51404 = opts;
var inst_51405 = cljs.core.__destructure_map.call(null,inst_51404);
var inst_51406 = cljs.core.get.call(null,inst_51405,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_51407 = cljs.core.get.call(null,inst_51405,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_51408 = cljs.core.get.call(null,inst_51405,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_51409__$1 = cljs.core.get.call(null,inst_51405,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_51491__$1 = (function (){var statearr_51551 = state_51491;
(statearr_51551[(13)] = inst_51406);

(statearr_51551[(15)] = inst_51403);

(statearr_51551[(16)] = inst_51409__$1);

(statearr_51551[(18)] = inst_51407);

(statearr_51551[(7)] = inst_51408);

return statearr_51551;
})();
if(cljs.core.truth_(inst_51409__$1)){
var statearr_51552_51603 = state_51491__$1;
(statearr_51552_51603[(1)] = (9));

} else {
var statearr_51553_51604 = state_51491__$1;
(statearr_51553_51604[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_51554 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51554[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_51554[(1)] = (1));

return statearr_51554;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_51491){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51555){var ex__2724__auto__ = e51555;
var statearr_51556_51605 = state_51491;
(statearr_51556_51605[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51491[(4)]))){
var statearr_51557_51606 = state_51491;
(statearr_51557_51606[(1)] = cljs.core.first.call(null,(state_51491[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51607 = state_51491;
state_51491 = G__51607;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_51491){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_51491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51558 = f__2744__auto__.call(null);
(statearr_51558[(6)] = c__2743__auto__);

return statearr_51558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.txToCommand.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__51609 = arguments.length;
switch (G__51609) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51635){
var state_val_51636 = (state_51635[(1)]);
if((state_val_51636 === (7))){
var inst_51621 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_51635__$1 = state_51635;
var statearr_51637_51658 = state_51635__$1;
(statearr_51637_51658[(2)] = inst_51621);

(statearr_51637_51658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51636 === (1))){
var state_51635__$1 = state_51635;
var statearr_51638_51659 = state_51635__$1;
(statearr_51638_51659[(2)] = null);

(statearr_51638_51659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51636 === (4))){
var inst_51610 = (state_51635[(2)]);
var inst_51611 = fluree.db.util.log.error.call(null,inst_51610);
var inst_51612 = reject.call(null,inst_51610);
var state_51635__$1 = (function (){var statearr_51639 = state_51635;
(statearr_51639[(7)] = inst_51611);

return statearr_51639;
})();
var statearr_51640_51660 = state_51635__$1;
(statearr_51640_51660[(2)] = inst_51612);

(statearr_51640_51660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51636 === (6))){
var state_51635__$1 = state_51635;
var statearr_51641_51661 = state_51635__$1;
(statearr_51641_51661[(2)] = null);

(statearr_51641_51661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51636 === (3))){
var inst_51633 = (state_51635[(2)]);
var state_51635__$1 = state_51635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51635__$1,inst_51633);
} else {
if((state_val_51636 === (2))){
var _ = (function (){var statearr_51643 = state_51635;
(statearr_51643[(4)] = cljs.core.cons.call(null,(5),(state_51635[(4)])));

return statearr_51643;
})();
var inst_51618 = (opts == null);
var state_51635__$1 = state_51635;
if(cljs.core.truth_(inst_51618)){
var statearr_51644_51662 = state_51635__$1;
(statearr_51644_51662[(1)] = (6));

} else {
var statearr_51645_51663 = state_51635__$1;
(statearr_51645_51663[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51636 === (9))){
var inst_51628 = (state_51635[(2)]);
var inst_51629 = cljs.core.clj__GT_js.call(null,inst_51628);
var inst_51630 = resolve.call(null,inst_51629);
var _ = (function (){var statearr_51646 = state_51635;
(statearr_51646[(4)] = cljs.core.rest.call(null,(state_51635[(4)])));

return statearr_51646;
})();
var state_51635__$1 = state_51635;
var statearr_51647_51664 = state_51635__$1;
(statearr_51647_51664[(2)] = inst_51630);

(statearr_51647_51664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51636 === (5))){
var _ = (function (){var statearr_51648 = state_51635;
(statearr_51648[(4)] = cljs.core.rest.call(null,(state_51635[(4)])));

return statearr_51648;
})();
var state_51635__$1 = state_51635;
var ex51642 = (state_51635__$1[(2)]);
var statearr_51649_51665 = state_51635__$1;
(statearr_51649_51665[(5)] = ex51642);


var statearr_51650_51666 = state_51635__$1;
(statearr_51650_51666[(1)] = (4));

(statearr_51650_51666[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51636 === (8))){
var inst_51623 = (state_51635[(2)]);
var inst_51624 = fluree.db.connection_js.check_connection.call(null,conn,inst_51623);
var inst_51625 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_51626 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_51625,inst_51623);
var state_51635__$1 = (function (){var statearr_51651 = state_51635;
(statearr_51651[(8)] = inst_51624);

return statearr_51651;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51635__$1,(9),inst_51626);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_51652 = [null,null,null,null,null,null,null,null,null];
(statearr_51652[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_51652[(1)] = (1));

return statearr_51652;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_51635){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51653){var ex__2724__auto__ = e51653;
var statearr_51654_51667 = state_51635;
(statearr_51654_51667[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51635[(4)]))){
var statearr_51655_51668 = state_51635;
(statearr_51655_51668[(1)] = cljs.core.first.call(null,(state_51635[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51669 = state_51635;
state_51635 = G__51669;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_51635){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_51635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51656 = f__2744__auto__.call(null);
(statearr_51656[(6)] = c__2743__auto__);

return statearr_51656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureenjs.blockRangeWithTxn = (function flureenjs$blockRangeWithTxn(var_args){
var G__51671 = arguments.length;
switch (G__51671) {
case 3:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRangeWithTxn', flureenjs.blockRangeWithTxn);

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.blockRangeWithTxn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51700){
var state_val_51701 = (state_51700[(1)]);
if((state_val_51701 === (1))){
var state_51700__$1 = state_51700;
var statearr_51702_51719 = state_51700__$1;
(statearr_51702_51719[(2)] = null);

(statearr_51702_51719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51701 === (2))){
var inst_51681 = (state_51700[(7)]);
var _ = (function (){var statearr_51703 = state_51700;
(statearr_51703[(4)] = cljs.core.cons.call(null,(5),(state_51700[(4)])));

return statearr_51703;
})();
var inst_51681__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_51682 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_51683 = cljs.core.__destructure_map.call(null,inst_51682);
var inst_51684 = cljs.core.get.call(null,inst_51683,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_51685 = cljs.core.get.call(null,inst_51683,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_51686 = flureenjs._db_instance.call(null,conn,ledger,inst_51681__$1);
var state_51700__$1 = (function (){var statearr_51704 = state_51700;
(statearr_51704[(8)] = inst_51684);

(statearr_51704[(7)] = inst_51681__$1);

(statearr_51704[(9)] = inst_51685);

return statearr_51704;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51700__$1,(6),inst_51686);
} else {
if((state_val_51701 === (3))){
var inst_51698 = (state_51700[(2)]);
var state_51700__$1 = state_51700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51700__$1,inst_51698);
} else {
if((state_val_51701 === (4))){
var inst_51672 = (state_51700[(2)]);
var inst_51673 = fluree.db.util.log.error.call(null,inst_51672);
var inst_51674 = reject.call(null,inst_51672);
var state_51700__$1 = (function (){var statearr_51706 = state_51700;
(statearr_51706[(10)] = inst_51673);

return statearr_51706;
})();
var statearr_51707_51720 = state_51700__$1;
(statearr_51707_51720[(2)] = inst_51674);

(statearr_51707_51720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51701 === (5))){
var _ = (function (){var statearr_51708 = state_51700;
(statearr_51708[(4)] = cljs.core.rest.call(null,(state_51700[(4)])));

return statearr_51708;
})();
var state_51700__$1 = state_51700;
var ex51705 = (state_51700__$1[(2)]);
var statearr_51709_51721 = state_51700__$1;
(statearr_51709_51721[(5)] = ex51705);


var statearr_51710_51722 = state_51700__$1;
(statearr_51710_51722[(1)] = (4));

(statearr_51710_51722[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51701 === (6))){
var inst_51684 = (state_51700[(8)]);
var inst_51681 = (state_51700[(7)]);
var inst_51685 = (state_51700[(9)]);
var inst_51688 = (state_51700[(2)]);
var inst_51689 = fluree.db.query.block.block_range.call(null,inst_51688,inst_51684,inst_51685,inst_51681);
var state_51700__$1 = state_51700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51700__$1,(7),inst_51689);
} else {
if((state_val_51701 === (7))){
var inst_51691 = (state_51700[(2)]);
var inst_51692 = fluree.db.util.async.throw_err.call(null,inst_51691);
var inst_51693 = fluree.db.query.range.block_with_tx_data.call(null,inst_51692);
var inst_51694 = cljs.core.clj__GT_js.call(null,inst_51693);
var inst_51695 = resolve.call(null,inst_51694);
var _ = (function (){var statearr_51711 = state_51700;
(statearr_51711[(4)] = cljs.core.rest.call(null,(state_51700[(4)])));

return statearr_51711;
})();
var state_51700__$1 = state_51700;
var statearr_51712_51723 = state_51700__$1;
(statearr_51712_51723[(2)] = inst_51695);

(statearr_51712_51723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_51713 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_51713[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_51713[(1)] = (1));

return statearr_51713;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_51700){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51714){var ex__2724__auto__ = e51714;
var statearr_51715_51724 = state_51700;
(statearr_51715_51724[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51700[(4)]))){
var statearr_51716_51725 = state_51700;
(statearr_51716_51725[(1)] = cljs.core.first.call(null,(state_51700[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51726 = state_51700;
state_51700 = G__51726;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_51700){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_51700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51717 = f__2744__auto__.call(null);
(statearr_51717[(6)] = c__2743__auto__);

return statearr_51717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.blockRangeWithTxn.cljs$lang$maxFixedArity = 4);

flureenjs.blockQuery = (function flureenjs$blockQuery(var_args){
var G__51728 = arguments.length;
switch (G__51728) {
case 3:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockQuery', flureenjs.blockQuery);

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.blockQuery.call(null,conn,ledger,query_map,null);
}));

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51786){
var state_val_51787 = (state_51786[(1)]);
if((state_val_51787 === (7))){
var state_51786__$1 = state_51786;
var statearr_51788_51829 = state_51786__$1;
(statearr_51788_51829[(2)] = null);

(statearr_51788_51829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (20))){
var inst_51765 = (state_51786[(2)]);
var state_51786__$1 = state_51786;
var statearr_51789_51830 = state_51786__$1;
(statearr_51789_51830[(2)] = inst_51765);

(statearr_51789_51830[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (1))){
var state_51786__$1 = state_51786;
var statearr_51790_51831 = state_51786__$1;
(statearr_51790_51831[(2)] = null);

(statearr_51790_51831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (4))){
var inst_51729 = (state_51786[(2)]);
var inst_51730 = fluree.db.util.log.error.call(null,inst_51729);
var inst_51731 = reject.call(null,inst_51729);
var state_51786__$1 = (function (){var statearr_51791 = state_51786;
(statearr_51791[(7)] = inst_51730);

return statearr_51791;
})();
var statearr_51792_51832 = state_51786__$1;
(statearr_51792_51832[(2)] = inst_51731);

(statearr_51792_51832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (15))){
var state_51786__$1 = state_51786;
var statearr_51793_51833 = state_51786__$1;
(statearr_51793_51833[(2)] = null);

(statearr_51793_51833[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (21))){
var inst_51778 = (state_51786[(2)]);
var inst_51779 = fluree.db.util.async.throw_err.call(null,inst_51778);
var inst_51780 = cljs.core.clj__GT_js.call(null,inst_51779);
var inst_51781 = resolve.call(null,inst_51780);
var _ = (function (){var statearr_51794 = state_51786;
(statearr_51794[(4)] = cljs.core.rest.call(null,(state_51786[(4)])));

return statearr_51794;
})();
var state_51786__$1 = state_51786;
var statearr_51795_51834 = state_51786__$1;
(statearr_51795_51834[(2)] = inst_51781);

(statearr_51795_51834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (13))){
var inst_51753 = (state_51786[(8)]);
var inst_51744 = (state_51786[(9)]);
var inst_51753__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_51744);
var inst_51754 = (inst_51753__$1 == null);
var state_51786__$1 = (function (){var statearr_51796 = state_51786;
(statearr_51796[(8)] = inst_51753__$1);

return statearr_51796;
})();
if(cljs.core.truth_(inst_51754)){
var statearr_51797_51835 = state_51786__$1;
(statearr_51797_51835[(1)] = (15));

} else {
var statearr_51798_51836 = state_51786__$1;
(statearr_51798_51836[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (6))){
var inst_51740 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_51786__$1 = state_51786;
var statearr_51799_51837 = state_51786__$1;
(statearr_51799_51837[(2)] = inst_51740);

(statearr_51799_51837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (17))){
var inst_51759 = (state_51786[(10)]);
var inst_51759__$1 = (state_51786[(2)]);
var inst_51760 = (inst_51759__$1 == null);
var state_51786__$1 = (function (){var statearr_51800 = state_51786;
(statearr_51800[(10)] = inst_51759__$1);

return statearr_51800;
})();
if(cljs.core.truth_(inst_51760)){
var statearr_51801_51838 = state_51786__$1;
(statearr_51801_51838[(1)] = (18));

} else {
var statearr_51802_51839 = state_51786__$1;
(statearr_51802_51839[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (3))){
var inst_51784 = (state_51786[(2)]);
var state_51786__$1 = state_51786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51786__$1,inst_51784);
} else {
if((state_val_51787 === (12))){
var inst_51749 = (state_51786[(11)]);
var state_51786__$1 = state_51786;
var statearr_51803_51840 = state_51786__$1;
(statearr_51803_51840[(2)] = inst_51749);

(statearr_51803_51840[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (2))){
var inst_51737 = (state_51786[(12)]);
var _ = (function (){var statearr_51804 = state_51786;
(statearr_51804[(4)] = cljs.core.cons.call(null,(5),(state_51786[(4)])));

return statearr_51804;
})();
var inst_51737__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_51738 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_51737__$1);
var state_51786__$1 = (function (){var statearr_51805 = state_51786;
(statearr_51805[(13)] = inst_51738);

(statearr_51805[(12)] = inst_51737__$1);

return statearr_51805;
})();
if(cljs.core.truth_(opts)){
var statearr_51806_51841 = state_51786__$1;
(statearr_51806_51841[(1)] = (6));

} else {
var statearr_51807_51842 = state_51786__$1;
(statearr_51807_51842[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (19))){
var inst_51759 = (state_51786[(10)]);
var inst_51763 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_51759);
var state_51786__$1 = state_51786;
var statearr_51808_51843 = state_51786__$1;
(statearr_51808_51843[(2)] = inst_51763);

(statearr_51808_51843[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (11))){
var inst_51744 = (state_51786[(9)]);
var inst_51737 = (state_51786[(12)]);
var inst_51769 = (state_51786[(2)]);
var inst_51770 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_51771 = [inst_51769];
var inst_51772 = cljs.core.PersistentHashMap.fromArrays(inst_51770,inst_51771);
var inst_51773 = fluree.db.util.core.without_nils.call(null,inst_51772);
var inst_51774 = cljs.core.merge.call(null,inst_51744,inst_51773);
var inst_51775 = cljs.core.update.call(null,inst_51737,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_51774);
var inst_51776 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_51775);
var state_51786__$1 = state_51786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51786__$1,(21),inst_51776);
} else {
if((state_val_51787 === (9))){
var inst_51746 = (state_51786[(14)]);
var state_51786__$1 = state_51786;
var statearr_51810_51844 = state_51786__$1;
(statearr_51810_51844[(2)] = inst_51746);

(statearr_51810_51844[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (5))){
var _ = (function (){var statearr_51811 = state_51786;
(statearr_51811[(4)] = cljs.core.rest.call(null,(state_51786[(4)])));

return statearr_51811;
})();
var state_51786__$1 = state_51786;
var ex51809 = (state_51786__$1[(2)]);
var statearr_51812_51845 = state_51786__$1;
(statearr_51812_51845[(5)] = ex51809);


var statearr_51813_51846 = state_51786__$1;
(statearr_51813_51846[(1)] = (4));

(statearr_51813_51846[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (14))){
var inst_51767 = (state_51786[(2)]);
var state_51786__$1 = state_51786;
var statearr_51814_51847 = state_51786__$1;
(statearr_51814_51847[(2)] = inst_51767);

(statearr_51814_51847[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (16))){
var inst_51753 = (state_51786[(8)]);
var inst_51757 = fluree.db.connection_js.validate_token.call(null,conn,inst_51753);
var state_51786__$1 = state_51786;
var statearr_51815_51848 = state_51786__$1;
(statearr_51815_51848[(2)] = inst_51757);

(statearr_51815_51848[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (10))){
var inst_51744 = (state_51786[(9)]);
var inst_51749 = (state_51786[(11)]);
var inst_51749__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_51744);
var state_51786__$1 = (function (){var statearr_51816 = state_51786;
(statearr_51816[(11)] = inst_51749__$1);

return statearr_51816;
})();
if(cljs.core.truth_(inst_51749__$1)){
var statearr_51817_51849 = state_51786__$1;
(statearr_51817_51849[(1)] = (12));

} else {
var statearr_51818_51850 = state_51786__$1;
(statearr_51818_51850[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (18))){
var state_51786__$1 = state_51786;
var statearr_51819_51851 = state_51786__$1;
(statearr_51819_51851[(2)] = null);

(statearr_51819_51851[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51787 === (8))){
var inst_51738 = (state_51786[(13)]);
var inst_51744 = (state_51786[(9)]);
var inst_51746 = (state_51786[(14)]);
var inst_51743 = (state_51786[(2)]);
var inst_51744__$1 = cljs.core.merge.call(null,inst_51738,inst_51743);
var inst_51745 = fluree.db.connection_js.check_connection.call(null,conn,inst_51744__$1);
var inst_51746__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_51744__$1);
var state_51786__$1 = (function (){var statearr_51820 = state_51786;
(statearr_51820[(15)] = inst_51745);

(statearr_51820[(9)] = inst_51744__$1);

(statearr_51820[(14)] = inst_51746__$1);

return statearr_51820;
})();
if(cljs.core.truth_(inst_51746__$1)){
var statearr_51821_51852 = state_51786__$1;
(statearr_51821_51852[(1)] = (9));

} else {
var statearr_51822_51853 = state_51786__$1;
(statearr_51822_51853[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_51823 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51823[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_51823[(1)] = (1));

return statearr_51823;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_51786){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51824){var ex__2724__auto__ = e51824;
var statearr_51825_51854 = state_51786;
(statearr_51825_51854[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51786[(4)]))){
var statearr_51826_51855 = state_51786;
(statearr_51826_51855[(1)] = cljs.core.first.call(null,(state_51786[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51856 = state_51786;
state_51786 = G__51856;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_51786){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_51786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51827 = f__2744__auto__.call(null);
(statearr_51827[(6)] = c__2743__auto__);

return statearr_51827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.blockQuery.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 *     to end if provided (exclusive).
 * 
 *     Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.blockRange = (function flureenjs$blockRange(var_args){
var G__51858 = arguments.length;
switch (G__51858) {
case 2:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRange', flureenjs.blockRange);

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.blockRange.call(null,db,start,null,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.blockRange.call(null,db,start,end,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51882){
var state_val_51883 = (state_51882[(1)]);
if((state_val_51883 === (1))){
var state_51882__$1 = state_51882;
var statearr_51884_51901 = state_51882__$1;
(statearr_51884_51901[(2)] = null);

(statearr_51884_51901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51883 === (2))){
var _ = (function (){var statearr_51885 = state_51882;
(statearr_51885[(4)] = cljs.core.cons.call(null,(5),(state_51882[(4)])));

return statearr_51885;
})();
var inst_51867 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_51882__$1 = (function (){var statearr_51886 = state_51882;
(statearr_51886[(7)] = inst_51867);

return statearr_51886;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51882__$1,(7),db);
} else {
if((state_val_51883 === (3))){
var inst_51880 = (state_51882[(2)]);
var state_51882__$1 = state_51882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51882__$1,inst_51880);
} else {
if((state_val_51883 === (4))){
var inst_51859 = (state_51882[(2)]);
var inst_51860 = fluree.db.util.log.error.call(null,inst_51859);
var inst_51861 = reject.call(null,inst_51859);
var state_51882__$1 = (function (){var statearr_51888 = state_51882;
(statearr_51888[(8)] = inst_51860);

return statearr_51888;
})();
var statearr_51889_51902 = state_51882__$1;
(statearr_51889_51902[(2)] = inst_51861);

(statearr_51889_51902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51883 === (5))){
var _ = (function (){var statearr_51890 = state_51882;
(statearr_51890[(4)] = cljs.core.rest.call(null,(state_51882[(4)])));

return statearr_51890;
})();
var state_51882__$1 = state_51882;
var ex51887 = (state_51882__$1[(2)]);
var statearr_51891_51903 = state_51882__$1;
(statearr_51891_51903[(5)] = ex51887);


var statearr_51892_51904 = state_51882__$1;
(statearr_51892_51904[(1)] = (4));

(statearr_51892_51904[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51883 === (6))){
var inst_51873 = (state_51882[(2)]);
var inst_51874 = fluree.db.util.async.throw_err.call(null,inst_51873);
var inst_51875 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_51874);
var inst_51876 = cljs.core.clj__GT_js.call(null,inst_51875);
var inst_51877 = resolve.call(null,inst_51876);
var _ = (function (){var statearr_51893 = state_51882;
(statearr_51893[(4)] = cljs.core.rest.call(null,(state_51882[(4)])));

return statearr_51893;
})();
var state_51882__$1 = state_51882;
var statearr_51894_51905 = state_51882__$1;
(statearr_51894_51905[(2)] = inst_51877);

(statearr_51894_51905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51883 === (7))){
var inst_51867 = (state_51882[(7)]);
var inst_51869 = (state_51882[(2)]);
var inst_51870 = fluree.db.util.async.throw_err.call(null,inst_51869);
var inst_51871 = fluree.db.query.block.block_range.call(null,inst_51870,start,end,inst_51867);
var state_51882__$1 = state_51882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51882__$1,(6),inst_51871);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_51895 = [null,null,null,null,null,null,null,null,null];
(statearr_51895[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_51895[(1)] = (1));

return statearr_51895;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_51882){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51896){var ex__2724__auto__ = e51896;
var statearr_51897_51906 = state_51882;
(statearr_51897_51906[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51882[(4)]))){
var statearr_51898_51907 = state_51882;
(statearr_51898_51907[(1)] = cljs.core.first.call(null,(state_51882[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51908 = state_51882;
state_51882 = G__51908;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_51882){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_51882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51899 = f__2744__auto__.call(null);
(statearr_51899[(6)] = c__2743__auto__);

return statearr_51899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.blockRange.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collectionFlakes = (function flureenjs$collectionFlakes(db,collection){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_51931){
var state_val_51932 = (state_51931[(1)]);
if((state_val_51932 === (1))){
var state_51931__$1 = state_51931;
var statearr_51933_51948 = state_51931__$1;
(statearr_51933_51948[(2)] = null);

(statearr_51933_51948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51932 === (2))){
var _ = (function (){var statearr_51934 = state_51931;
(statearr_51934[(4)] = cljs.core.cons.call(null,(5),(state_51931[(4)])));

return statearr_51934;
})();
var state_51931__$1 = state_51931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51931__$1,(7),db);
} else {
if((state_val_51932 === (3))){
var inst_51929 = (state_51931[(2)]);
var state_51931__$1 = state_51931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51931__$1,inst_51929);
} else {
if((state_val_51932 === (4))){
var inst_51909 = (state_51931[(2)]);
var inst_51910 = fluree.db.util.log.error.call(null,inst_51909);
var inst_51911 = reject.call(null,inst_51909);
var state_51931__$1 = (function (){var statearr_51936 = state_51931;
(statearr_51936[(7)] = inst_51910);

return statearr_51936;
})();
var statearr_51937_51949 = state_51931__$1;
(statearr_51937_51949[(2)] = inst_51911);

(statearr_51937_51949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51932 === (5))){
var _ = (function (){var statearr_51938 = state_51931;
(statearr_51938[(4)] = cljs.core.rest.call(null,(state_51931[(4)])));

return statearr_51938;
})();
var state_51931__$1 = state_51931;
var ex51935 = (state_51931__$1[(2)]);
var statearr_51939_51950 = state_51931__$1;
(statearr_51939_51950[(5)] = ex51935);


var statearr_51940_51951 = state_51931__$1;
(statearr_51940_51951[(1)] = (4));

(statearr_51940_51951[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51932 === (6))){
var inst_51922 = (state_51931[(2)]);
var inst_51923 = fluree.db.util.async.throw_err.call(null,inst_51922);
var inst_51924 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_51923);
var inst_51925 = cljs.core.clj__GT_js.call(null,inst_51924);
var inst_51926 = resolve.call(null,inst_51925);
var _ = (function (){var statearr_51941 = state_51931;
(statearr_51941[(4)] = cljs.core.rest.call(null,(state_51931[(4)])));

return statearr_51941;
})();
var state_51931__$1 = state_51931;
var statearr_51942_51952 = state_51931__$1;
(statearr_51942_51952[(2)] = inst_51926);

(statearr_51942_51952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51932 === (7))){
var inst_51918 = (state_51931[(2)]);
var inst_51919 = fluree.db.util.async.throw_err.call(null,inst_51918);
var inst_51920 = fluree.db.query.range.collection.call(null,inst_51919,collection);
var state_51931__$1 = state_51931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51931__$1,(6),inst_51920);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionFlakes_$_state_machine__2721__auto__ = null;
var flureenjs$collectionFlakes_$_state_machine__2721__auto____0 = (function (){
var statearr_51943 = [null,null,null,null,null,null,null,null];
(statearr_51943[(0)] = flureenjs$collectionFlakes_$_state_machine__2721__auto__);

(statearr_51943[(1)] = (1));

return statearr_51943;
});
var flureenjs$collectionFlakes_$_state_machine__2721__auto____1 = (function (state_51931){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_51931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e51944){var ex__2724__auto__ = e51944;
var statearr_51945_51953 = state_51931;
(statearr_51945_51953[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_51931[(4)]))){
var statearr_51946_51954 = state_51931;
(statearr_51946_51954[(1)] = cljs.core.first.call(null,(state_51931[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51955 = state_51931;
state_51931 = G__51955;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$collectionFlakes_$_state_machine__2721__auto__ = function(state_51931){
switch(arguments.length){
case 0:
return flureenjs$collectionFlakes_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$collectionFlakes_$_state_machine__2721__auto____1.call(this,state_51931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionFlakes_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionFlakes_$_state_machine__2721__auto____0;
flureenjs$collectionFlakes_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionFlakes_$_state_machine__2721__auto____1;
return flureenjs$collectionFlakes_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_51947 = f__2744__auto__.call(null);
(statearr_51947[(6)] = c__2743__auto__);

return statearr_51947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionFlakes', flureenjs.collectionFlakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__51957 = arguments.length;
switch (G__51957) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_52059){
var state_val_52060 = (state_52059[(1)]);
if((state_val_52060 === (7))){
var state_52059__$1 = state_52059;
var statearr_52061_52113 = state_52059__$1;
(statearr_52061_52113[(2)] = null);

(statearr_52061_52113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (20))){
var inst_51987 = (state_52059[(7)]);
var inst_51976 = (state_52059[(8)]);
var inst_51983 = (state_52059[(9)]);
var inst_52008 = cljs.core.dissoc.call(null,inst_51987,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_52009 = cljs.core.assoc.call(null,inst_52008,new cljs.core.Keyword(null,"opts","opts",155075701),inst_51976);
var inst_52010 = fluree.db.api.query.history_query_async.call(null,inst_51983,inst_52009);
var state_52059__$1 = state_52059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52059__$1,(23),inst_52010);
} else {
if((state_val_52060 === (27))){
var inst_52022 = (state_52059[(2)]);
var inst_52023 = fluree.db.util.async.throw_err.call(null,inst_52022);
var state_52059__$1 = state_52059;
var statearr_52062_52114 = state_52059__$1;
(statearr_52062_52114[(2)] = inst_52023);

(statearr_52062_52114[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (1))){
var state_52059__$1 = state_52059;
var statearr_52063_52115 = state_52059__$1;
(statearr_52063_52115[(2)] = null);

(statearr_52063_52115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (24))){
var inst_51987 = (state_52059[(7)]);
var inst_51976 = (state_52059[(8)]);
var inst_52018 = cljs.core.dissoc.call(null,inst_51987,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_52019 = cljs.core.assoc.call(null,inst_52018,new cljs.core.Keyword(null,"opts","opts",155075701),inst_51976);
var inst_52020 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_52019);
var state_52059__$1 = state_52059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52059__$1,(27),inst_52020);
} else {
if((state_val_52060 === (4))){
var inst_51958 = (state_52059[(2)]);
var inst_51959 = fluree.db.util.log.error.call(null,inst_51958);
var inst_51960 = cljs.core.clj__GT_js.call(null,inst_51958);
var inst_51961 = reject.call(null,inst_51960);
var state_52059__$1 = (function (){var statearr_52064 = state_52059;
(statearr_52064[(10)] = inst_51959);

return statearr_52064;
})();
var statearr_52065_52116 = state_52059__$1;
(statearr_52065_52116[(2)] = inst_51961);

(statearr_52065_52116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (15))){
var inst_51987 = (state_52059[(7)]);
var inst_52005 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_51987);
var inst_52006 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_52005);
var state_52059__$1 = state_52059;
if(inst_52006){
var statearr_52066_52117 = state_52059__$1;
(statearr_52066_52117[(1)] = (20));

} else {
var statearr_52067_52118 = state_52059__$1;
(statearr_52067_52118[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (21))){
var inst_51987 = (state_52059[(7)]);
var inst_52015 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_51987);
var inst_52016 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_52015);
var state_52059__$1 = state_52059;
if(inst_52016){
var statearr_52068_52119 = state_52059__$1;
(statearr_52068_52119[(1)] = (24));

} else {
var statearr_52069_52120 = state_52059__$1;
(statearr_52069_52120[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (31))){
var inst_52030 = (state_52059[(2)]);
var inst_52031 = fluree.db.util.async.throw_err.call(null,inst_52030);
var state_52059__$1 = state_52059;
var statearr_52070_52121 = state_52059__$1;
(statearr_52070_52121[(2)] = inst_52031);

(statearr_52070_52121[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (32))){
var inst_51987 = (state_52059[(7)]);
var inst_51980 = (state_52059[(11)]);
var inst_51976 = (state_52059[(8)]);
var inst_52034 = cljs.core.dissoc.call(null,inst_51987,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_52035 = cljs.core.assoc.call(null,inst_52034,new cljs.core.Keyword(null,"opts","opts",155075701),inst_51976);
var inst_52036 = fluree.db.api.query.multi_query_async.call(null,inst_51980,inst_52035);
var state_52059__$1 = state_52059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52059__$1,(35),inst_52036);
} else {
if((state_val_52060 === (33))){
var state_52059__$1 = state_52059;
var statearr_52071_52122 = state_52059__$1;
(statearr_52071_52122[(2)] = null);

(statearr_52071_52122[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (13))){
var inst_52052 = (state_52059[(2)]);
var inst_52053 = cljs.core.clj__GT_js.call(null,inst_52052);
var inst_52054 = resolve.call(null,inst_52053);
var _ = (function (){var statearr_52072 = state_52059;
(statearr_52072[(4)] = cljs.core.rest.call(null,(state_52059[(4)])));

return statearr_52072;
})();
var state_52059__$1 = state_52059;
var statearr_52073_52123 = state_52059__$1;
(statearr_52073_52123[(2)] = inst_52054);

(statearr_52073_52123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (22))){
var inst_52048 = (state_52059[(2)]);
var state_52059__$1 = state_52059;
var statearr_52074_52124 = state_52059__$1;
(statearr_52074_52124[(2)] = inst_52048);

(statearr_52074_52124[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (29))){
var state_52059__$1 = state_52059;
var statearr_52075_52125 = state_52059__$1;
(statearr_52075_52125[(1)] = (32));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (6))){
var inst_51972 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_52059__$1 = state_52059;
var statearr_52077_52126 = state_52059__$1;
(statearr_52077_52126[(2)] = inst_51972);

(statearr_52077_52126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (28))){
var inst_51987 = (state_52059[(7)]);
var inst_51976 = (state_52059[(8)]);
var inst_52027 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_51987);
var inst_52028 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_52027,inst_51976);
var state_52059__$1 = state_52059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52059__$1,(31),inst_52028);
} else {
if((state_val_52060 === (25))){
var inst_51987 = (state_52059[(7)]);
var inst_52025 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_51987);
var state_52059__$1 = state_52059;
if(cljs.core.truth_(inst_52025)){
var statearr_52078_52127 = state_52059__$1;
(statearr_52078_52127[(1)] = (28));

} else {
var statearr_52079_52128 = state_52059__$1;
(statearr_52079_52128[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (34))){
var inst_52042 = (state_52059[(2)]);
var state_52059__$1 = state_52059;
var statearr_52080_52129 = state_52059__$1;
(statearr_52080_52129[(2)] = inst_52042);

(statearr_52080_52129[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (17))){
var inst_51987 = (state_52059[(7)]);
var inst_51999 = cljs.core.dissoc.call(null,inst_51987,new cljs.core.Keyword(null,"type","type",1174270348));
var state_52059__$1 = state_52059;
var statearr_52081_52130 = state_52059__$1;
(statearr_52081_52130[(2)] = inst_51999);

(statearr_52081_52130[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (3))){
var inst_52057 = (state_52059[(2)]);
var state_52059__$1 = state_52059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52059__$1,inst_52057);
} else {
if((state_val_52060 === (12))){
var inst_51987 = (state_52059[(7)]);
var inst_51991 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_51992 = (new cljs.core.PersistentArrayMap(null,2,inst_51991,null));
var inst_51993 = (new cljs.core.PersistentHashSet(null,inst_51992,null));
var inst_51994 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_51987);
var inst_51995 = inst_51993.call(null,inst_51994);
var state_52059__$1 = state_52059;
if(cljs.core.truth_(inst_51995)){
var statearr_52082_52131 = state_52059__$1;
(statearr_52082_52131[(1)] = (14));

} else {
var statearr_52083_52132 = state_52059__$1;
(statearr_52083_52132[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (2))){
var inst_51969 = (state_52059[(12)]);
var _ = (function (){var statearr_52084 = state_52059;
(statearr_52084[(4)] = cljs.core.cons.call(null,(5),(state_52059[(4)])));

return statearr_52084;
})();
var inst_51968 = fluree.db.util.json.parse.call(null,param);
var inst_51969__$1 = cljs.core.js__GT_clj.call(null,inst_51968,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_51970 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_51969__$1);
var state_52059__$1 = (function (){var statearr_52085 = state_52059;
(statearr_52085[(12)] = inst_51969__$1);

(statearr_52085[(13)] = inst_51970);

return statearr_52085;
})();
if(cljs.core.truth_(opts)){
var statearr_52086_52133 = state_52059__$1;
(statearr_52086_52133[(1)] = (6));

} else {
var statearr_52087_52134 = state_52059__$1;
(statearr_52087_52134[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (23))){
var inst_52012 = (state_52059[(2)]);
var inst_52013 = fluree.db.util.async.throw_err.call(null,inst_52012);
var state_52059__$1 = state_52059;
var statearr_52088_52135 = state_52059__$1;
(statearr_52088_52135[(2)] = inst_52013);

(statearr_52088_52135[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (35))){
var inst_52038 = (state_52059[(2)]);
var inst_52039 = fluree.db.util.async.throw_err.call(null,inst_52038);
var state_52059__$1 = state_52059;
var statearr_52089_52136 = state_52059__$1;
(statearr_52089_52136[(2)] = inst_52039);

(statearr_52089_52136[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (19))){
var inst_52003 = (state_52059[(2)]);
var state_52059__$1 = state_52059;
var statearr_52090_52137 = state_52059__$1;
(statearr_52090_52137[(2)] = inst_52003);

(statearr_52090_52137[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (11))){
var inst_51987 = (state_52059[(7)]);
var state_52059__$1 = state_52059;
var statearr_52092_52138 = state_52059__$1;
(statearr_52092_52138[(2)] = inst_51987);

(statearr_52092_52138[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (9))){
var inst_51979 = (state_52059[(14)]);
var inst_51978 = (state_52059[(15)]);
var inst_51976 = (state_52059[(8)]);
var inst_51983 = (state_52059[(9)]);
var inst_51982 = (state_52059[(2)]);
var inst_51983__$1 = fluree.db.util.async.throw_err.call(null,inst_51982);
var inst_51984 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_51983__$1,inst_51978,inst_51979,inst_51976);
var state_52059__$1 = (function (){var statearr_52093 = state_52059;
(statearr_52093[(9)] = inst_51983__$1);

return statearr_52093;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52059__$1,(10),inst_51984);
} else {
if((state_val_52060 === (5))){
var _ = (function (){var statearr_52094 = state_52059;
(statearr_52094[(4)] = cljs.core.rest.call(null,(state_52059[(4)])));

return statearr_52094;
})();
var state_52059__$1 = state_52059;
var ex52091 = (state_52059__$1[(2)]);
var statearr_52095_52139 = state_52059__$1;
(statearr_52095_52139[(5)] = ex52091);


var statearr_52096_52140 = state_52059__$1;
(statearr_52096_52140[(1)] = (4));

(statearr_52096_52140[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (14))){
var inst_51976 = (state_52059[(8)]);
var inst_51997 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_51976);
var state_52059__$1 = state_52059;
if(cljs.core.truth_(inst_51997)){
var statearr_52097_52141 = state_52059__$1;
(statearr_52097_52141[(1)] = (17));

} else {
var statearr_52098_52142 = state_52059__$1;
(statearr_52098_52142[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (26))){
var inst_52046 = (state_52059[(2)]);
var state_52059__$1 = state_52059;
var statearr_52099_52143 = state_52059__$1;
(statearr_52099_52143[(2)] = inst_52046);

(statearr_52099_52143[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (16))){
var inst_52050 = (state_52059[(2)]);
var state_52059__$1 = state_52059;
var statearr_52100_52144 = state_52059__$1;
(statearr_52100_52144[(2)] = inst_52050);

(statearr_52100_52144[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (30))){
var inst_52044 = (state_52059[(2)]);
var state_52059__$1 = state_52059;
var statearr_52101_52145 = state_52059__$1;
(statearr_52101_52145[(2)] = inst_52044);

(statearr_52101_52145[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (10))){
var inst_51987 = (state_52059[(7)]);
var inst_51986 = (state_52059[(2)]);
var inst_51987__$1 = fluree.db.util.async.throw_err.call(null,inst_51986);
var inst_51988 = fluree.db.util.core.exception_QMARK_.call(null,inst_51987__$1);
var state_52059__$1 = (function (){var statearr_52102 = state_52059;
(statearr_52102[(7)] = inst_51987__$1);

return statearr_52102;
})();
if(inst_51988){
var statearr_52103_52146 = state_52059__$1;
(statearr_52103_52146[(1)] = (11));

} else {
var statearr_52104_52147 = state_52059__$1;
(statearr_52104_52147[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (18))){
var inst_51987 = (state_52059[(7)]);
var inst_52001 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_51987);
var state_52059__$1 = state_52059;
var statearr_52105_52148 = state_52059__$1;
(statearr_52105_52148[(2)] = inst_52001);

(statearr_52105_52148[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52060 === (8))){
var inst_51969 = (state_52059[(12)]);
var inst_51970 = (state_52059[(13)]);
var inst_51980 = (state_52059[(11)]);
var inst_51976 = (state_52059[(8)]);
var inst_51975 = (state_52059[(2)]);
var inst_51976__$1 = cljs.core.merge.call(null,inst_51970,inst_51975);
var inst_51977 = cljs.core.__destructure_map.call(null,inst_51969);
var inst_51978 = cljs.core.get.call(null,inst_51977,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_51979 = cljs.core.get.call(null,inst_51977,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_51980__$1 = flureenjs._db_instance.call(null,conn,ledger,inst_51976__$1);
var state_52059__$1 = (function (){var statearr_52106 = state_52059;
(statearr_52106[(14)] = inst_51979);

(statearr_52106[(11)] = inst_51980__$1);

(statearr_52106[(15)] = inst_51978);

(statearr_52106[(8)] = inst_51976__$1);

return statearr_52106;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52059__$1,(9),inst_51980__$1);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_52107 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52107[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_52107[(1)] = (1));

return statearr_52107;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_52059){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_52059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e52108){var ex__2724__auto__ = e52108;
var statearr_52109_52149 = state_52059;
(statearr_52109_52149[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_52059[(4)]))){
var statearr_52110_52150 = state_52059;
(statearr_52110_52150[(1)] = cljs.core.first.call(null,(state_52059[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52151 = state_52059;
state_52059 = G__52151;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_52059){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_52059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_52111 = f__2744__auto__.call(null);
(statearr_52111[(6)] = c__2743__auto__);

return statearr_52111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.historyQuery = (function flureenjs$historyQuery(var_args){
var G__52153 = arguments.length;
switch (G__52153) {
case 2:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.historyQuery', flureenjs.historyQuery);

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.historyQuery.call(null,sources,query_map,null);
}));

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_52180){
var state_val_52181 = (state_52180[(1)]);
if((state_val_52181 === (1))){
var state_52180__$1 = state_52180;
var statearr_52182_52198 = state_52180__$1;
(statearr_52182_52198[(2)] = null);

(statearr_52182_52198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52181 === (2))){
var _ = (function (){var statearr_52183 = state_52180;
(statearr_52183[(4)] = cljs.core.cons.call(null,(5),(state_52180[(4)])));

return statearr_52183;
})();
var inst_52162 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_52163 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_52162);
var inst_52164 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_52165 = cljs.core.merge.call(null,inst_52163,inst_52164);
var inst_52166 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_52167 = [inst_52165];
var inst_52168 = cljs.core.PersistentHashMap.fromArrays(inst_52166,inst_52167);
var inst_52169 = cljs.core.merge.call(null,inst_52162,inst_52168);
var inst_52170 = fluree.db.api.query.history_query_async.call(null,sources,inst_52169);
var state_52180__$1 = state_52180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52180__$1,(6),inst_52170);
} else {
if((state_val_52181 === (3))){
var inst_52178 = (state_52180[(2)]);
var state_52180__$1 = state_52180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52180__$1,inst_52178);
} else {
if((state_val_52181 === (4))){
var inst_52154 = (state_52180[(2)]);
var inst_52155 = fluree.db.util.log.error.call(null,inst_52154);
var inst_52156 = reject.call(null,inst_52154);
var state_52180__$1 = (function (){var statearr_52185 = state_52180;
(statearr_52185[(7)] = inst_52155);

return statearr_52185;
})();
var statearr_52186_52199 = state_52180__$1;
(statearr_52186_52199[(2)] = inst_52156);

(statearr_52186_52199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52181 === (5))){
var _ = (function (){var statearr_52187 = state_52180;
(statearr_52187[(4)] = cljs.core.rest.call(null,(state_52180[(4)])));

return statearr_52187;
})();
var state_52180__$1 = state_52180;
var ex52184 = (state_52180__$1[(2)]);
var statearr_52188_52200 = state_52180__$1;
(statearr_52188_52200[(5)] = ex52184);


var statearr_52189_52201 = state_52180__$1;
(statearr_52189_52201[(1)] = (4));

(statearr_52189_52201[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52181 === (6))){
var inst_52172 = (state_52180[(2)]);
var inst_52173 = fluree.db.util.async.throw_err.call(null,inst_52172);
var inst_52174 = cljs.core.clj__GT_js.call(null,inst_52173);
var inst_52175 = resolve.call(null,inst_52174);
var _ = (function (){var statearr_52190 = state_52180;
(statearr_52190[(4)] = cljs.core.rest.call(null,(state_52180[(4)])));

return statearr_52190;
})();
var state_52180__$1 = state_52180;
var statearr_52191_52202 = state_52180__$1;
(statearr_52191_52202[(2)] = inst_52175);

(statearr_52191_52202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_52192 = [null,null,null,null,null,null,null,null];
(statearr_52192[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_52192[(1)] = (1));

return statearr_52192;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_52180){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_52180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e52193){var ex__2724__auto__ = e52193;
var statearr_52194_52203 = state_52180;
(statearr_52194_52203[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_52180[(4)]))){
var statearr_52195_52204 = state_52180;
(statearr_52195_52204[(1)] = cljs.core.first.call(null,(state_52180[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52205 = state_52180;
state_52180 = G__52205;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_52180){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_52180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_52196 = f__2744__auto__.call(null);
(statearr_52196[(6)] = c__2743__auto__);

return statearr_52196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.historyQuery.cljs$lang$maxFixedArity = 3);

flureenjs.multiQuery = (function flureenjs$multiQuery(var_args){
var G__52207 = arguments.length;
switch (G__52207) {
case 2:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multiQuery', flureenjs.multiQuery);

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multiQuery.call(null,source,multi_query_map,null);
}));

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_52234){
var state_val_52235 = (state_52234[(1)]);
if((state_val_52235 === (1))){
var state_52234__$1 = state_52234;
var statearr_52236_52252 = state_52234__$1;
(statearr_52236_52252[(2)] = null);

(statearr_52236_52252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52235 === (2))){
var _ = (function (){var statearr_52237 = state_52234;
(statearr_52237[(4)] = cljs.core.cons.call(null,(5),(state_52234[(4)])));

return statearr_52237;
})();
var inst_52216 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_52217 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_52216);
var inst_52218 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_52219 = cljs.core.merge.call(null,inst_52217,inst_52218);
var inst_52220 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_52221 = [inst_52219];
var inst_52222 = cljs.core.PersistentHashMap.fromArrays(inst_52220,inst_52221);
var inst_52223 = cljs.core.merge.call(null,inst_52216,inst_52222);
var inst_52224 = fluree.db.api.query.multi_query_async.call(null,source,inst_52223);
var state_52234__$1 = state_52234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52234__$1,(6),inst_52224);
} else {
if((state_val_52235 === (3))){
var inst_52232 = (state_52234[(2)]);
var state_52234__$1 = state_52234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52234__$1,inst_52232);
} else {
if((state_val_52235 === (4))){
var inst_52208 = (state_52234[(2)]);
var inst_52209 = fluree.db.util.log.error.call(null,inst_52208);
var inst_52210 = reject.call(null,inst_52208);
var state_52234__$1 = (function (){var statearr_52239 = state_52234;
(statearr_52239[(7)] = inst_52209);

return statearr_52239;
})();
var statearr_52240_52253 = state_52234__$1;
(statearr_52240_52253[(2)] = inst_52210);

(statearr_52240_52253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52235 === (5))){
var _ = (function (){var statearr_52241 = state_52234;
(statearr_52241[(4)] = cljs.core.rest.call(null,(state_52234[(4)])));

return statearr_52241;
})();
var state_52234__$1 = state_52234;
var ex52238 = (state_52234__$1[(2)]);
var statearr_52242_52254 = state_52234__$1;
(statearr_52242_52254[(5)] = ex52238);


var statearr_52243_52255 = state_52234__$1;
(statearr_52243_52255[(1)] = (4));

(statearr_52243_52255[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52235 === (6))){
var inst_52226 = (state_52234[(2)]);
var inst_52227 = fluree.db.util.async.throw_err.call(null,inst_52226);
var inst_52228 = cljs.core.clj__GT_js.call(null,inst_52227);
var inst_52229 = resolve.call(null,inst_52228);
var _ = (function (){var statearr_52244 = state_52234;
(statearr_52244[(4)] = cljs.core.rest.call(null,(state_52234[(4)])));

return statearr_52244;
})();
var state_52234__$1 = state_52234;
var statearr_52245_52256 = state_52234__$1;
(statearr_52245_52256[(2)] = inst_52229);

(statearr_52245_52256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_52246 = [null,null,null,null,null,null,null,null];
(statearr_52246[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_52246[(1)] = (1));

return statearr_52246;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_52234){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_52234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e52247){var ex__2724__auto__ = e52247;
var statearr_52248_52257 = state_52234;
(statearr_52248_52257[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_52234[(4)]))){
var statearr_52249_52258 = state_52234;
(statearr_52249_52258[(1)] = cljs.core.first.call(null,(state_52234[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52259 = state_52234;
state_52234 = G__52259;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_52234){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_52234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_52250 = f__2744__auto__.call(null);
(statearr_52250[(6)] = c__2743__auto__);

return statearr_52250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.multiQuery.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise that eventually contains the results or
 *    an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_52280){
var state_val_52281 = (state_52280[(1)]);
if((state_val_52281 === (1))){
var state_52280__$1 = state_52280;
var statearr_52282_52297 = state_52280__$1;
(statearr_52282_52297[(2)] = null);

(statearr_52282_52297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52281 === (2))){
var _ = (function (){var statearr_52283 = state_52280;
(statearr_52283[(4)] = cljs.core.cons.call(null,(5),(state_52280[(4)])));

return statearr_52283;
})();
var inst_52269 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_52270 = fluree.db.api.query.query.call(null,source,inst_52269);
var state_52280__$1 = state_52280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52280__$1,(6),inst_52270);
} else {
if((state_val_52281 === (3))){
var inst_52278 = (state_52280[(2)]);
var state_52280__$1 = state_52280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52280__$1,inst_52278);
} else {
if((state_val_52281 === (4))){
var inst_52260 = (state_52280[(2)]);
var inst_52261 = fluree.db.util.log.error.call(null,inst_52260);
var inst_52262 = cljs.core.clj__GT_js.call(null,inst_52260);
var inst_52263 = reject.call(null,inst_52262);
var state_52280__$1 = (function (){var statearr_52285 = state_52280;
(statearr_52285[(7)] = inst_52261);

return statearr_52285;
})();
var statearr_52286_52298 = state_52280__$1;
(statearr_52286_52298[(2)] = inst_52263);

(statearr_52286_52298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52281 === (5))){
var _ = (function (){var statearr_52287 = state_52280;
(statearr_52287[(4)] = cljs.core.rest.call(null,(state_52280[(4)])));

return statearr_52287;
})();
var state_52280__$1 = state_52280;
var ex52284 = (state_52280__$1[(2)]);
var statearr_52288_52299 = state_52280__$1;
(statearr_52288_52299[(5)] = ex52284);


var statearr_52289_52300 = state_52280__$1;
(statearr_52289_52300[(1)] = (4));

(statearr_52289_52300[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52281 === (6))){
var inst_52272 = (state_52280[(2)]);
var inst_52273 = fluree.db.util.async.throw_err.call(null,inst_52272);
var inst_52274 = cljs.core.clj__GT_js.call(null,inst_52273);
var inst_52275 = resolve.call(null,inst_52274);
var _ = (function (){var statearr_52290 = state_52280;
(statearr_52290[(4)] = cljs.core.rest.call(null,(state_52280[(4)])));

return statearr_52290;
})();
var state_52280__$1 = state_52280;
var statearr_52291_52301 = state_52280__$1;
(statearr_52291_52301[(2)] = inst_52275);

(statearr_52291_52301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__2721__auto__ = null;
var flureenjs$query_$_state_machine__2721__auto____0 = (function (){
var statearr_52292 = [null,null,null,null,null,null,null,null];
(statearr_52292[(0)] = flureenjs$query_$_state_machine__2721__auto__);

(statearr_52292[(1)] = (1));

return statearr_52292;
});
var flureenjs$query_$_state_machine__2721__auto____1 = (function (state_52280){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_52280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e52293){var ex__2724__auto__ = e52293;
var statearr_52294_52302 = state_52280;
(statearr_52294_52302[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_52280[(4)]))){
var statearr_52295_52303 = state_52280;
(statearr_52295_52303[(1)] = cljs.core.first.call(null,(state_52280[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52304 = state_52280;
state_52280 = G__52304;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__2721__auto__ = function(state_52280){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__2721__auto____1.call(this,state_52280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__2721__auto____0;
flureenjs$query_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__2721__auto____1;
return flureenjs$query_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_52296 = f__2744__auto__.call(null);
(statearr_52296[(6)] = c__2743__auto__);

return statearr_52296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *    given flakes applied.
 * 
 *    Returns promise that eventually contains the results or
 *    an exception.
 */
flureenjs.queryWith = (function flureenjs$queryWith(db,param){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_52334){
var state_val_52335 = (state_52334[(1)]);
if((state_val_52335 === (1))){
var state_52334__$1 = state_52334;
var statearr_52336_52352 = state_52334__$1;
(statearr_52336_52352[(2)] = null);

(statearr_52336_52352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52335 === (2))){
var _ = (function (){var statearr_52337 = state_52334;
(statearr_52337[(4)] = cljs.core.cons.call(null,(5),(state_52334[(4)])));

return statearr_52337;
})();
var inst_52315 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_52316 = cljs.core.__destructure_map.call(null,inst_52315);
var inst_52317 = cljs.core.get.call(null,inst_52316,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_52318 = cljs.core.get.call(null,inst_52316,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_52319 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_52318);
var state_52334__$1 = (function (){var statearr_52338 = state_52334;
(statearr_52338[(7)] = inst_52319);

(statearr_52338[(8)] = inst_52317);

return statearr_52338;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52334__$1,(6),db);
} else {
if((state_val_52335 === (3))){
var inst_52332 = (state_52334[(2)]);
var state_52334__$1 = state_52334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52334__$1,inst_52332);
} else {
if((state_val_52335 === (4))){
var inst_52305 = (state_52334[(2)]);
var inst_52306 = fluree.db.util.log.error.call(null,inst_52305);
var inst_52307 = cljs.core.clj__GT_js.call(null,inst_52305);
var inst_52308 = reject.call(null,inst_52307);
var state_52334__$1 = (function (){var statearr_52340 = state_52334;
(statearr_52340[(9)] = inst_52306);

return statearr_52340;
})();
var statearr_52341_52353 = state_52334__$1;
(statearr_52341_52353[(2)] = inst_52308);

(statearr_52341_52353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52335 === (5))){
var _ = (function (){var statearr_52342 = state_52334;
(statearr_52342[(4)] = cljs.core.rest.call(null,(state_52334[(4)])));

return statearr_52342;
})();
var state_52334__$1 = state_52334;
var ex52339 = (state_52334__$1[(2)]);
var statearr_52343_52354 = state_52334__$1;
(statearr_52343_52354[(5)] = ex52339);


var statearr_52344_52355 = state_52334__$1;
(statearr_52344_52355[(1)] = (4));

(statearr_52344_52355[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52335 === (6))){
var inst_52319 = (state_52334[(7)]);
var inst_52317 = (state_52334[(8)]);
var inst_52321 = (state_52334[(2)]);
var inst_52322 = fluree.db.util.async.throw_err.call(null,inst_52321);
var inst_52323 = fluree.db.dbproto._forward_time_travel.call(null,inst_52322,inst_52319);
var inst_52324 = fluree.db.api.query.query.call(null,inst_52323,inst_52317);
var state_52334__$1 = state_52334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52334__$1,(7),inst_52324);
} else {
if((state_val_52335 === (7))){
var inst_52326 = (state_52334[(2)]);
var inst_52327 = fluree.db.util.async.throw_err.call(null,inst_52326);
var inst_52328 = cljs.core.clj__GT_js.call(null,inst_52327);
var inst_52329 = resolve.call(null,inst_52328);
var _ = (function (){var statearr_52345 = state_52334;
(statearr_52345[(4)] = cljs.core.rest.call(null,(state_52334[(4)])));

return statearr_52345;
})();
var state_52334__$1 = state_52334;
var statearr_52346_52356 = state_52334__$1;
(statearr_52346_52356[(2)] = inst_52329);

(statearr_52346_52356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$queryWith_$_state_machine__2721__auto__ = null;
var flureenjs$queryWith_$_state_machine__2721__auto____0 = (function (){
var statearr_52347 = [null,null,null,null,null,null,null,null,null,null];
(statearr_52347[(0)] = flureenjs$queryWith_$_state_machine__2721__auto__);

(statearr_52347[(1)] = (1));

return statearr_52347;
});
var flureenjs$queryWith_$_state_machine__2721__auto____1 = (function (state_52334){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_52334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e52348){var ex__2724__auto__ = e52348;
var statearr_52349_52357 = state_52334;
(statearr_52349_52357[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_52334[(4)]))){
var statearr_52350_52358 = state_52334;
(statearr_52350_52358[(1)] = cljs.core.first.call(null,(state_52334[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52359 = state_52334;
state_52334 = G__52359;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$queryWith_$_state_machine__2721__auto__ = function(state_52334){
switch(arguments.length){
case 0:
return flureenjs$queryWith_$_state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$queryWith_$_state_machine__2721__auto____1.call(this,state_52334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$queryWith_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$queryWith_$_state_machine__2721__auto____0;
flureenjs$queryWith_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$queryWith_$_state_machine__2721__auto____1;
return flureenjs$queryWith_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_52351 = f__2744__auto__.call(null);
(statearr_52351[(6)] = c__2743__auto__);

return statearr_52351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
});
goog.exportSymbol('flureenjs.queryWith', flureenjs.queryWith);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__52361 = arguments.length;
switch (G__52361) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_52391){
var state_val_52392 = (state_52391[(1)]);
if((state_val_52392 === (7))){
var state_52391__$1 = state_52391;
var statearr_52393_52414 = state_52391__$1;
(statearr_52393_52414[(2)] = null);

(statearr_52393_52414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52392 === (1))){
var state_52391__$1 = state_52391;
var statearr_52394_52415 = state_52391__$1;
(statearr_52394_52415[(2)] = null);

(statearr_52394_52415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52392 === (4))){
var inst_52362 = (state_52391[(2)]);
var inst_52363 = fluree.db.util.log.error.call(null,inst_52362);
var inst_52364 = cljs.core.clj__GT_js.call(null,inst_52362);
var inst_52365 = reject.call(null,inst_52364);
var state_52391__$1 = (function (){var statearr_52395 = state_52391;
(statearr_52395[(7)] = inst_52363);

return statearr_52395;
})();
var statearr_52396_52416 = state_52391__$1;
(statearr_52396_52416[(2)] = inst_52365);

(statearr_52396_52416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52392 === (6))){
var inst_52375 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_52391__$1 = state_52391;
var statearr_52397_52417 = state_52391__$1;
(statearr_52397_52417[(2)] = inst_52375);

(statearr_52397_52417[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52392 === (3))){
var inst_52389 = (state_52391[(2)]);
var state_52391__$1 = state_52391;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52391__$1,inst_52389);
} else {
if((state_val_52392 === (2))){
var inst_52372 = (state_52391[(8)]);
var _ = (function (){var statearr_52399 = state_52391;
(statearr_52399[(4)] = cljs.core.cons.call(null,(5),(state_52391[(4)])));

return statearr_52399;
})();
var inst_52371 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_52372__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_52371);
var inst_52373 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_52372__$1);
var state_52391__$1 = (function (){var statearr_52400 = state_52391;
(statearr_52400[(9)] = inst_52373);

(statearr_52400[(8)] = inst_52372__$1);

return statearr_52400;
})();
if(cljs.core.truth_(opts)){
var statearr_52401_52418 = state_52391__$1;
(statearr_52401_52418[(1)] = (6));

} else {
var statearr_52402_52419 = state_52391__$1;
(statearr_52402_52419[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52392 === (9))){
var inst_52383 = (state_52391[(2)]);
var inst_52384 = fluree.db.util.async.throw_err.call(null,inst_52383);
var inst_52385 = cljs.core.clj__GT_js.call(null,inst_52384);
var inst_52386 = resolve.call(null,inst_52385);
var _ = (function (){var statearr_52403 = state_52391;
(statearr_52403[(4)] = cljs.core.rest.call(null,(state_52391[(4)])));

return statearr_52403;
})();
var state_52391__$1 = state_52391;
var statearr_52404_52420 = state_52391__$1;
(statearr_52404_52420[(2)] = inst_52386);

(statearr_52404_52420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52392 === (5))){
var _ = (function (){var statearr_52405 = state_52391;
(statearr_52405[(4)] = cljs.core.rest.call(null,(state_52391[(4)])));

return statearr_52405;
})();
var state_52391__$1 = state_52391;
var ex52398 = (state_52391__$1[(2)]);
var statearr_52406_52421 = state_52391__$1;
(statearr_52406_52421[(5)] = ex52398);


var statearr_52407_52422 = state_52391__$1;
(statearr_52407_52422[(1)] = (4));

(statearr_52407_52422[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52392 === (8))){
var inst_52373 = (state_52391[(9)]);
var inst_52372 = (state_52391[(8)]);
var inst_52378 = (state_52391[(2)]);
var inst_52379 = cljs.core.merge.call(null,inst_52373,inst_52378);
var inst_52380 = cljs.core.assoc.call(null,inst_52372,new cljs.core.Keyword(null,"opts","opts",155075701),inst_52379);
var inst_52381 = fluree.db.api.query.query_async.call(null,db,inst_52380);
var state_52391__$1 = state_52391;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52391__$1,(9),inst_52381);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_52408 = [null,null,null,null,null,null,null,null,null,null];
(statearr_52408[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_52408[(1)] = (1));

return statearr_52408;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_52391){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_52391);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e52409){var ex__2724__auto__ = e52409;
var statearr_52410_52423 = state_52391;
(statearr_52410_52423[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_52391[(4)]))){
var statearr_52411_52424 = state_52391;
(statearr_52411_52424[(1)] = cljs.core.first.call(null,(state_52391[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52425 = state_52391;
state_52391 = G__52425;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_52391){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_52391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_52412 = f__2744__auto__.call(null);
(statearr_52412[(6)] = c__2743__auto__);

return statearr_52412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__52427 = arguments.length;
switch (G__52427) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_52451){
var state_val_52452 = (state_52451[(1)]);
if((state_val_52452 === (1))){
var state_52451__$1 = state_52451;
var statearr_52453_52469 = state_52451__$1;
(statearr_52453_52469[(2)] = null);

(statearr_52453_52469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52452 === (2))){
var _ = (function (){var statearr_52454 = state_52451;
(statearr_52454[(4)] = cljs.core.cons.call(null,(5),(state_52451[(4)])));

return statearr_52454;
})();
var inst_52437 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_52438 = fluree.db.util.json.parse.call(null,sql_str);
var inst_52439 = fluree.db.query.sql.parse.call(null,inst_52438);
var inst_52440 = cljs.core.update.call(null,inst_52439,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_52437);
var inst_52441 = fluree.db.api.query.query_async.call(null,db,inst_52440);
var state_52451__$1 = state_52451;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52451__$1,(6),inst_52441);
} else {
if((state_val_52452 === (3))){
var inst_52449 = (state_52451[(2)]);
var state_52451__$1 = state_52451;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52451__$1,inst_52449);
} else {
if((state_val_52452 === (4))){
var inst_52428 = (state_52451[(2)]);
var inst_52429 = fluree.db.util.log.error.call(null,inst_52428);
var inst_52430 = cljs.core.clj__GT_js.call(null,inst_52428);
var inst_52431 = reject.call(null,inst_52430);
var state_52451__$1 = (function (){var statearr_52456 = state_52451;
(statearr_52456[(7)] = inst_52429);

return statearr_52456;
})();
var statearr_52457_52470 = state_52451__$1;
(statearr_52457_52470[(2)] = inst_52431);

(statearr_52457_52470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52452 === (5))){
var _ = (function (){var statearr_52458 = state_52451;
(statearr_52458[(4)] = cljs.core.rest.call(null,(state_52451[(4)])));

return statearr_52458;
})();
var state_52451__$1 = state_52451;
var ex52455 = (state_52451__$1[(2)]);
var statearr_52459_52471 = state_52451__$1;
(statearr_52459_52471[(5)] = ex52455);


var statearr_52460_52472 = state_52451__$1;
(statearr_52460_52472[(1)] = (4));

(statearr_52460_52472[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52452 === (6))){
var inst_52443 = (state_52451[(2)]);
var inst_52444 = fluree.db.util.async.throw_err.call(null,inst_52443);
var inst_52445 = cljs.core.clj__GT_js.call(null,inst_52444);
var inst_52446 = resolve.call(null,inst_52445);
var _ = (function (){var statearr_52461 = state_52451;
(statearr_52461[(4)] = cljs.core.rest.call(null,(state_52451[(4)])));

return statearr_52461;
})();
var state_52451__$1 = state_52451;
var statearr_52462_52473 = state_52451__$1;
(statearr_52462_52473[(2)] = inst_52446);

(statearr_52462_52473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2721__auto__ = null;
var flureenjs$state_machine__2721__auto____0 = (function (){
var statearr_52463 = [null,null,null,null,null,null,null,null];
(statearr_52463[(0)] = flureenjs$state_machine__2721__auto__);

(statearr_52463[(1)] = (1));

return statearr_52463;
});
var flureenjs$state_machine__2721__auto____1 = (function (state_52451){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_52451);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e52464){var ex__2724__auto__ = e52464;
var statearr_52465_52474 = state_52451;
(statearr_52465_52474[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_52451[(4)]))){
var statearr_52466_52475 = state_52451;
(statearr_52466_52475[(1)] = cljs.core.first.call(null,(state_52451[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52476 = state_52451;
state_52451 = G__52476;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
flureenjs$state_machine__2721__auto__ = function(state_52451){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2721__auto____0.call(this);
case 1:
return flureenjs$state_machine__2721__auto____1.call(this,state_52451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2721__auto____0;
flureenjs$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2721__auto____1;
return flureenjs$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_52467 = f__2744__auto__.call(null);
(statearr_52467[(6)] = c__2743__auto__);

return statearr_52467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

