// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('alphabase.base32');
goog.require('cljs.core');
goog.require('alphabase.codec');
goog.require('clojure.set');
alphabase.base32.base32_chars = "abcdefghijklmnopqrstuvwxyz234567";
alphabase.base32.base32_set = cljs.core.set("abcdefghijklmnopqrstuvwxyz234567");
/**
 * Test if input is base32.
 */
alphabase.base32.base32_QMARK_ = (function alphabase$base32$base32_QMARK_(x){
return ((typeof x === 'string') && (clojure.set.subset_QMARK_(cljs.core.set(x),alphabase.base32.base32_set)));
});
/**
 * Converts a byte array into a base32 string.
 */
alphabase.base32.encode = (function alphabase$base32$encode(ba){
return alphabase.codec.encode("abcdefghijklmnopqrstuvwxyz234567",ba);
});
/**
 * Decodes a base32 string into a byte array.
 */
alphabase.base32.decode = (function alphabase$base32$decode(b32_string){
return alphabase.codec.decode("abcdefghijklmnopqrstuvwxyz234567",b32_string);
});
