// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__64019 = arguments.length;
switch (G__64019) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___64058 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64040){
var state_val_64041 = (state_64040[(1)]);
if((state_val_64041 === (1))){
var state_64040__$1 = state_64040;
var statearr_64042_64059 = state_64040__$1;
(statearr_64042_64059[(2)] = null);

(statearr_64042_64059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64041 === (2))){
var _ = (function (){var statearr_64043 = state_64040;
(statearr_64043[(4)] = cljs.core.cons((5),(state_64040[(4)])));

return statearr_64043;
})();
var inst_64026 = fluree.db.session.db(conn,ledger,null);
var state_64040__$1 = state_64040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64040__$1,(7),inst_64026);
} else {
if((state_val_64041 === (3))){
var inst_64036 = (state_64040[(2)]);
var inst_64037 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64036);
var inst_64038 = cljs.core.async.close_BANG_(pc);
var state_64040__$1 = (function (){var statearr_64045 = state_64040;
(statearr_64045[(7)] = inst_64037);

return statearr_64045;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64040__$1,inst_64038);
} else {
if((state_val_64041 === (4))){
var inst_64020 = (state_64040[(2)]);
var state_64040__$1 = state_64040;
var statearr_64046_64060 = state_64040__$1;
(statearr_64046_64060[(2)] = inst_64020);

(statearr_64046_64060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64041 === (5))){
var _ = (function (){var statearr_64047 = state_64040;
(statearr_64047[(4)] = cljs.core.rest((state_64040[(4)])));

return statearr_64047;
})();
var state_64040__$1 = state_64040;
var ex64044 = (state_64040__$1[(2)]);
var statearr_64048_64061 = state_64040__$1;
(statearr_64048_64061[(5)] = ex64044);


var statearr_64049_64062 = state_64040__$1;
(statearr_64049_64062[(1)] = (4));

(statearr_64049_64062[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64041 === (6))){
var inst_64032 = (state_64040[(2)]);
var inst_64033 = fluree.db.util.async.throw_err(inst_64032);
var _ = (function (){var statearr_64050 = state_64040;
(statearr_64050[(4)] = cljs.core.rest((state_64040[(4)])));

return statearr_64050;
})();
var state_64040__$1 = state_64040;
var statearr_64051_64063 = state_64040__$1;
(statearr_64051_64063[(2)] = inst_64033);

(statearr_64051_64063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64041 === (7))){
var inst_64028 = (state_64040[(2)]);
var inst_64029 = fluree.db.util.async.throw_err(inst_64028);
var inst_64030 = fluree.db.time_travel.as_of_block(inst_64029,block);
var state_64040__$1 = state_64040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64040__$1,(6),inst_64030);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_64052 = [null,null,null,null,null,null,null,null];
(statearr_64052[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_64052[(1)] = (1));

return statearr_64052;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_64040){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64040);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64053){var ex__2687__auto__ = e64053;
var statearr_64054_64064 = state_64040;
(statearr_64054_64064[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64040[(4)]))){
var statearr_64055_64065 = state_64040;
(statearr_64055_64065[(1)] = cljs.core.first((state_64040[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64066 = state_64040;
state_64040 = G__64066;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_64040){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_64040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64056 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64056[(6)] = c__2706__auto___64058);

return statearr_64056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64107){
var state_val_64108 = (state_64107[(1)]);
if((state_val_64108 === (7))){
var inst_64076 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64107__$1 = state_64107;
if(inst_64076){
var statearr_64109_64140 = state_64107__$1;
(statearr_64109_64140[(1)] = (9));

} else {
var statearr_64110_64141 = state_64107__$1;
(statearr_64110_64141[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (1))){
var state_64107__$1 = state_64107;
var statearr_64111_64142 = state_64107__$1;
(statearr_64111_64142[(2)] = null);

(statearr_64111_64142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (4))){
var inst_64067 = (state_64107[(2)]);
var state_64107__$1 = state_64107;
var statearr_64112_64143 = state_64107__$1;
(statearr_64112_64143[(2)] = inst_64067);

(statearr_64112_64143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (15))){
var inst_64084 = (state_64107[(7)]);
var inst_64083 = (state_64107[(2)]);
var inst_64084__$1 = fluree.db.util.async.throw_err(inst_64083);
var state_64107__$1 = (function (){var statearr_64113 = state_64107;
(statearr_64113[(7)] = inst_64084__$1);

return statearr_64113;
})();
if(cljs.core.truth_(inst_64084__$1)){
var statearr_64114_64144 = state_64107__$1;
(statearr_64114_64144[(1)] = (16));

} else {
var statearr_64115_64145 = state_64107__$1;
(statearr_64115_64145[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (13))){
var state_64107__$1 = state_64107;
var statearr_64116_64146 = state_64107__$1;
(statearr_64116_64146[(2)] = null);

(statearr_64116_64146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (6))){
var state_64107__$1 = state_64107;
var statearr_64117_64147 = state_64107__$1;
(statearr_64117_64147[(2)] = db);

(statearr_64117_64147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (17))){
var inst_64088 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64089 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64090 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64091 = cljs.core.PersistentHashMap.fromArrays(inst_64089,inst_64090);
var inst_64092 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64088,inst_64091);
var inst_64093 = (function(){throw inst_64092})();
var state_64107__$1 = state_64107;
var statearr_64118_64148 = state_64107__$1;
(statearr_64118_64148[(2)] = inst_64093);

(statearr_64118_64148[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (3))){
var inst_64105 = (state_64107[(2)]);
var state_64107__$1 = state_64107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64107__$1,inst_64105);
} else {
if((state_val_64108 === (12))){
var inst_64081 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64107__$1 = state_64107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64107__$1,(15),inst_64081);
} else {
if((state_val_64108 === (2))){
var _ = (function (){var statearr_64119 = state_64107;
(statearr_64119[(4)] = cljs.core.cons((5),(state_64107[(4)])));

return statearr_64119;
})();
var inst_64073 = cljs.core.not(auth);
var state_64107__$1 = state_64107;
if(inst_64073){
var statearr_64120_64149 = state_64107__$1;
(statearr_64120_64149[(1)] = (6));

} else {
var statearr_64121_64150 = state_64107__$1;
(statearr_64121_64150[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (11))){
var inst_64100 = (state_64107[(2)]);
var state_64107__$1 = state_64107;
var statearr_64123_64151 = state_64107__$1;
(statearr_64123_64151[(2)] = inst_64100);

(statearr_64123_64151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (9))){
var inst_64078 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_64107__$1 = state_64107;
var statearr_64124_64152 = state_64107__$1;
(statearr_64124_64152[(2)] = inst_64078);

(statearr_64124_64152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (5))){
var _ = (function (){var statearr_64125 = state_64107;
(statearr_64125[(4)] = cljs.core.rest((state_64107[(4)])));

return statearr_64125;
})();
var state_64107__$1 = state_64107;
var ex64122 = (state_64107__$1[(2)]);
var statearr_64126_64153 = state_64107__$1;
(statearr_64126_64153[(5)] = ex64122);


if((ex64122 instanceof Error)){
var statearr_64127_64154 = state_64107__$1;
(statearr_64127_64154[(1)] = (4));

(statearr_64127_64154[(5)] = null);

} else {
throw ex64122;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (14))){
var inst_64098 = (state_64107[(2)]);
var state_64107__$1 = state_64107;
var statearr_64128_64155 = state_64107__$1;
(statearr_64128_64155[(2)] = inst_64098);

(statearr_64128_64155[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (16))){
var inst_64084 = (state_64107[(7)]);
var inst_64086 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64084);
var state_64107__$1 = state_64107;
var statearr_64129_64156 = state_64107__$1;
(statearr_64129_64156[(2)] = inst_64086);

(statearr_64129_64156[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (10))){
var state_64107__$1 = state_64107;
var statearr_64130_64157 = state_64107__$1;
(statearr_64130_64157[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (18))){
var inst_64095 = (state_64107[(2)]);
var state_64107__$1 = state_64107;
var statearr_64132_64158 = state_64107__$1;
(statearr_64132_64158[(2)] = inst_64095);

(statearr_64132_64158[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64108 === (8))){
var inst_64102 = (state_64107[(2)]);
var _ = (function (){var statearr_64133 = state_64107;
(statearr_64133[(4)] = cljs.core.rest((state_64107[(4)])));

return statearr_64133;
})();
var state_64107__$1 = state_64107;
var statearr_64134_64159 = state_64107__$1;
(statearr_64134_64159[(2)] = inst_64102);

(statearr_64134_64159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0 = (function (){
var statearr_64135 = [null,null,null,null,null,null,null,null];
(statearr_64135[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__);

(statearr_64135[(1)] = (1));

return statearr_64135;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1 = (function (state_64107){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64107);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64136){var ex__2687__auto__ = e64136;
var statearr_64137_64160 = state_64107;
(statearr_64137_64160[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64107[(4)]))){
var statearr_64138_64161 = state_64107;
(statearr_64138_64161[(1)] = cljs.core.first((state_64107[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64162 = state_64107;
state_64107 = G__64162;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = function(state_64107){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1.call(this,state_64107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64139 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64139[(6)] = c__2706__auto__);

return statearr_64139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64226){
var state_val_64227 = (state_64226[(1)]);
if((state_val_64227 === (7))){
var inst_64172 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64226__$1 = state_64226;
if(inst_64172){
var statearr_64228_64277 = state_64226__$1;
(statearr_64228_64277[(1)] = (9));

} else {
var statearr_64229_64278 = state_64226__$1;
(statearr_64229_64278[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (20))){
var inst_64196 = (state_64226[(7)]);
var state_64226__$1 = state_64226;
if(cljs.core.truth_(inst_64196)){
var statearr_64230_64279 = state_64226__$1;
(statearr_64230_64279[(1)] = (22));

} else {
var statearr_64231_64280 = state_64226__$1;
(statearr_64231_64280[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (27))){
var state_64226__$1 = state_64226;
var statearr_64232_64281 = state_64226__$1;
(statearr_64232_64281[(2)] = null);

(statearr_64232_64281[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (1))){
var state_64226__$1 = state_64226;
var statearr_64233_64282 = state_64226__$1;
(statearr_64233_64282[(2)] = null);

(statearr_64233_64282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (24))){
var inst_64210 = (state_64226[(2)]);
var state_64226__$1 = state_64226;
var statearr_64234_64283 = state_64226__$1;
(statearr_64234_64283[(2)] = inst_64210);

(statearr_64234_64283[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (4))){
var inst_64163 = (state_64226[(2)]);
var state_64226__$1 = state_64226;
var statearr_64235_64284 = state_64226__$1;
(statearr_64235_64284[(2)] = inst_64163);

(statearr_64235_64284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (15))){
var inst_64179 = (state_64226[(8)]);
var inst_64178 = (state_64226[(2)]);
var inst_64179__$1 = fluree.db.util.async.throw_err(inst_64178);
var state_64226__$1 = (function (){var statearr_64236 = state_64226;
(statearr_64236[(8)] = inst_64179__$1);

return statearr_64236;
})();
if(cljs.core.truth_(inst_64179__$1)){
var statearr_64237_64285 = state_64226__$1;
(statearr_64237_64285[(1)] = (16));

} else {
var statearr_64238_64286 = state_64226__$1;
(statearr_64238_64286[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (21))){
var inst_64212 = (state_64226[(9)]);
var inst_64212__$1 = (state_64226[(2)]);
var state_64226__$1 = (function (){var statearr_64239 = state_64226;
(statearr_64239[(9)] = inst_64212__$1);

return statearr_64239;
})();
if(cljs.core.truth_(inst_64212__$1)){
var statearr_64240_64287 = state_64226__$1;
(statearr_64240_64287[(1)] = (29));

} else {
var statearr_64241_64288 = state_64226__$1;
(statearr_64241_64288[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (31))){
var inst_64212 = (state_64226[(9)]);
var inst_64196 = (state_64226[(7)]);
var inst_64220 = (state_64226[(2)]);
var inst_64221 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64196,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_64212,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_64220], 0));
var _ = (function (){var statearr_64242 = state_64226;
(statearr_64242[(4)] = cljs.core.rest((state_64226[(4)])));

return statearr_64242;
})();
var state_64226__$1 = state_64226;
var statearr_64243_64289 = state_64226__$1;
(statearr_64243_64289[(2)] = inst_64221);

(statearr_64243_64289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (32))){
var inst_64216 = (state_64226[(2)]);
var inst_64217 = fluree.db.util.async.throw_err(inst_64216);
var state_64226__$1 = state_64226;
var statearr_64244_64290 = state_64226__$1;
(statearr_64244_64290[(2)] = inst_64217);

(statearr_64244_64290[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (13))){
var state_64226__$1 = state_64226;
var statearr_64245_64291 = state_64226__$1;
(statearr_64245_64291[(2)] = null);

(statearr_64245_64291[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (22))){
var inst_64196 = (state_64226[(7)]);
var inst_64200 = fluree.db.auth.roles(db,inst_64196);
var state_64226__$1 = state_64226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64226__$1,(25),inst_64200);
} else {
if((state_val_64227 === (29))){
var inst_64212 = (state_64226[(9)]);
var inst_64214 = fluree.db.permissions.permission_map(db,inst_64212,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64226__$1 = state_64226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64226__$1,(32),inst_64214);
} else {
if((state_val_64227 === (6))){
var state_64226__$1 = state_64226;
var statearr_64246_64292 = state_64226__$1;
(statearr_64246_64292[(2)] = null);

(statearr_64246_64292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (28))){
var inst_64208 = (state_64226[(2)]);
var state_64226__$1 = state_64226;
var statearr_64247_64293 = state_64226__$1;
(statearr_64247_64293[(2)] = inst_64208);

(statearr_64247_64293[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (25))){
var inst_64202 = (state_64226[(2)]);
var inst_64203 = fluree.db.util.async.throw_err(inst_64202);
var state_64226__$1 = state_64226;
var statearr_64248_64294 = state_64226__$1;
(statearr_64248_64294[(2)] = inst_64203);

(statearr_64248_64294[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (17))){
var inst_64182 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64183 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64184 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64185 = cljs.core.PersistentHashMap.fromArrays(inst_64183,inst_64184);
var inst_64186 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64182,inst_64185);
var inst_64187 = (function(){throw inst_64186})();
var state_64226__$1 = state_64226;
var statearr_64249_64295 = state_64226__$1;
(statearr_64249_64295[(2)] = inst_64187);

(statearr_64249_64295[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (3))){
var inst_64224 = (state_64226[(2)]);
var state_64226__$1 = state_64226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64226__$1,inst_64224);
} else {
if((state_val_64227 === (12))){
var inst_64176 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64226__$1 = state_64226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64226__$1,(15),inst_64176);
} else {
if((state_val_64227 === (2))){
var _ = (function (){var statearr_64250 = state_64226;
(statearr_64250[(4)] = cljs.core.cons((5),(state_64226[(4)])));

return statearr_64250;
})();
var inst_64169 = (auth == null);
var state_64226__$1 = state_64226;
if(cljs.core.truth_(inst_64169)){
var statearr_64251_64296 = state_64226__$1;
(statearr_64251_64296[(1)] = (6));

} else {
var statearr_64252_64297 = state_64226__$1;
(statearr_64252_64297[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (23))){
var state_64226__$1 = state_64226;
var statearr_64253_64298 = state_64226__$1;
(statearr_64253_64298[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (19))){
var state_64226__$1 = state_64226;
var statearr_64255_64299 = state_64226__$1;
(statearr_64255_64299[(2)] = roles);

(statearr_64255_64299[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (11))){
var inst_64194 = (state_64226[(2)]);
var state_64226__$1 = state_64226;
var statearr_64257_64300 = state_64226__$1;
(statearr_64257_64300[(2)] = inst_64194);

(statearr_64257_64300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (9))){
var state_64226__$1 = state_64226;
var statearr_64258_64301 = state_64226__$1;
(statearr_64258_64301[(2)] = (0));

(statearr_64258_64301[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (5))){
var _ = (function (){var statearr_64259 = state_64226;
(statearr_64259[(4)] = cljs.core.rest((state_64226[(4)])));

return statearr_64259;
})();
var state_64226__$1 = state_64226;
var ex64256 = (state_64226__$1[(2)]);
var statearr_64260_64302 = state_64226__$1;
(statearr_64260_64302[(5)] = ex64256);


if((ex64256 instanceof Error)){
var statearr_64261_64303 = state_64226__$1;
(statearr_64261_64303[(1)] = (4));

(statearr_64261_64303[(5)] = null);

} else {
throw ex64256;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (14))){
var inst_64192 = (state_64226[(2)]);
var state_64226__$1 = state_64226;
var statearr_64262_64304 = state_64226__$1;
(statearr_64262_64304[(2)] = inst_64192);

(statearr_64262_64304[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (26))){
var state_64226__$1 = state_64226;
var statearr_64263_64305 = state_64226__$1;
(statearr_64263_64305[(2)] = null);

(statearr_64263_64305[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (16))){
var inst_64179 = (state_64226[(8)]);
var state_64226__$1 = state_64226;
var statearr_64264_64306 = state_64226__$1;
(statearr_64264_64306[(2)] = inst_64179);

(statearr_64264_64306[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (30))){
var state_64226__$1 = state_64226;
var statearr_64265_64307 = state_64226__$1;
(statearr_64265_64307[(2)] = null);

(statearr_64265_64307[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (10))){
var state_64226__$1 = state_64226;
if(cljs.core.truth_(auth)){
var statearr_64266_64308 = state_64226__$1;
(statearr_64266_64308[(1)] = (12));

} else {
var statearr_64267_64309 = state_64226__$1;
(statearr_64267_64309[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (18))){
var inst_64189 = (state_64226[(2)]);
var state_64226__$1 = state_64226;
var statearr_64268_64310 = state_64226__$1;
(statearr_64268_64310[(2)] = inst_64189);

(statearr_64268_64310[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64227 === (8))){
var inst_64196 = (state_64226[(2)]);
var state_64226__$1 = (function (){var statearr_64269 = state_64226;
(statearr_64269[(7)] = inst_64196);

return statearr_64269;
})();
if(cljs.core.truth_(roles)){
var statearr_64270_64311 = state_64226__$1;
(statearr_64270_64311[(1)] = (19));

} else {
var statearr_64271_64312 = state_64226__$1;
(statearr_64271_64312[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0 = (function (){
var statearr_64272 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64272[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__);

(statearr_64272[(1)] = (1));

return statearr_64272;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1 = (function (state_64226){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64226);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64273){var ex__2687__auto__ = e64273;
var statearr_64274_64313 = state_64226;
(statearr_64274_64313[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64226[(4)]))){
var statearr_64275_64314 = state_64226;
(statearr_64275_64314[(1)] = cljs.core.first((state_64226[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64315 = state_64226;
state_64226 = G__64315;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = function(state_64226){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1.call(this,state_64226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64276 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64276[(6)] = c__2706__auto__);

return statearr_64276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__64316 = db;
var map__64316__$1 = cljs.core.__destructure_map(map__64316);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64316__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64316__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64316__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64323){
var state_val_64324 = (state_64323[(1)]);
if((state_val_64324 === (1))){
var inst_64317 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64318 = fluree.db.session.db(conn,inst_64317,null);
var state_64323__$1 = state_64323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64323__$1,(2),inst_64318);
} else {
if((state_val_64324 === (2))){
var inst_64320 = (state_64323[(2)]);
var inst_64321 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64320);
var state_64323__$1 = state_64323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64323__$1,inst_64321);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_64325 = [null,null,null,null,null,null,null];
(statearr_64325[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_64325[(1)] = (1));

return statearr_64325;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_64323){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64323);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64326){var ex__2687__auto__ = e64326;
var statearr_64327_64354 = state_64323;
(statearr_64327_64354[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64323[(4)]))){
var statearr_64328_64355 = state_64323;
(statearr_64328_64355[(1)] = cljs.core.first((state_64323[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64356 = state_64323;
state_64323 = G__64356;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_64323){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_64323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64329 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64329[(6)] = c__2706__auto__);

return statearr_64329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64342){
var state_val_64343 = (state_64342[(1)]);
if((state_val_64343 === (1))){
var inst_64330 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64331 = fluree.db.session.db(conn,inst_64330,null);
var state_64342__$1 = state_64342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64342__$1,(2),inst_64331);
} else {
if((state_val_64343 === (2))){
var inst_64333 = (state_64342[(7)]);
var inst_64333__$1 = (state_64342[(2)]);
var inst_64334 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64333__$1);
var inst_64335 = newer_block_QMARK_(inst_64334);
var state_64342__$1 = (function (){var statearr_64344 = state_64342;
(statearr_64344[(7)] = inst_64333__$1);

return statearr_64344;
})();
if(inst_64335){
var statearr_64345_64357 = state_64342__$1;
(statearr_64345_64357[(1)] = (3));

} else {
var statearr_64346_64358 = state_64342__$1;
(statearr_64346_64358[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64343 === (3))){
var inst_64333 = (state_64342[(7)]);
var inst_64337 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64333);
var state_64342__$1 = state_64342;
var statearr_64347_64359 = state_64342__$1;
(statearr_64347_64359[(2)] = inst_64337);

(statearr_64347_64359[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64343 === (4))){
var state_64342__$1 = state_64342;
var statearr_64348_64360 = state_64342__$1;
(statearr_64348_64360[(2)] = null);

(statearr_64348_64360[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64343 === (5))){
var inst_64340 = (state_64342[(2)]);
var state_64342__$1 = state_64342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64342__$1,inst_64340);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_64349 = [null,null,null,null,null,null,null,null];
(statearr_64349[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_64349[(1)] = (1));

return statearr_64349;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_64342){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64342);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64350){var ex__2687__auto__ = e64350;
var statearr_64351_64361 = state_64342;
(statearr_64351_64361[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64342[(4)]))){
var statearr_64352_64362 = state_64342;
(statearr_64352_64362[(1)] = cljs.core.first((state_64342[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64363 = state_64342;
state_64342 = G__64363;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_64342){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_64342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64353 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64353[(6)] = c__2706__auto__);

return statearr_64353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__64364 = db;
var map__64364__$1 = cljs.core.__destructure_map(map__64364);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64364__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64364__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64364__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2706__auto___64440 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64414){
var state_val_64415 = (state_64414[(1)]);
if((state_val_64415 === (7))){
var inst_64380 = (state_64414[(7)]);
var inst_64391 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64380,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_64414__$1 = state_64414;
if(inst_64391){
var statearr_64416_64441 = state_64414__$1;
(statearr_64416_64441[(1)] = (9));

} else {
var statearr_64417_64442 = state_64414__$1;
(statearr_64417_64442[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (1))){
var inst_64373 = (state_64414[(8)]);
var inst_64365 = (state_64414[(9)]);
var inst_64365__$1 = cljs.core.async.timeout(timeout);
var inst_64373__$1 = res_port;
var inst_64374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64375 = [inst_64365__$1,inst_64373__$1];
var inst_64376 = (new cljs.core.PersistentVector(null,2,(5),inst_64374,inst_64375,null));
var state_64414__$1 = (function (){var statearr_64418 = state_64414;
(statearr_64418[(8)] = inst_64373__$1);

(statearr_64418[(9)] = inst_64365__$1);

return statearr_64418;
})();
return cljs.core.async.ioc_alts_BANG_(state_64414__$1,(2),inst_64376);
} else {
if((state_val_64415 === (4))){
var inst_64380 = (state_64414[(7)]);
var inst_64373 = (state_64414[(8)]);
var inst_64384 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64380,inst_64373);
var state_64414__$1 = state_64414;
if(inst_64384){
var statearr_64419_64443 = state_64414__$1;
(statearr_64419_64443[(1)] = (6));

} else {
var statearr_64420_64444 = state_64414__$1;
(statearr_64420_64444[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (13))){
var inst_64399 = (state_64414[(10)]);
var inst_64410 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64399);
var state_64414__$1 = state_64414;
var statearr_64421_64445 = state_64414__$1;
(statearr_64421_64445[(2)] = inst_64410);

(statearr_64421_64445[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (6))){
var inst_64378 = (state_64414[(11)]);
var inst_64389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64378,(0),null);
var state_64414__$1 = state_64414;
var statearr_64422_64446 = state_64414__$1;
(statearr_64422_64446[(2)] = inst_64389);

(statearr_64422_64446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (3))){
var state_64414__$1 = state_64414;
var statearr_64423_64447 = state_64414__$1;
(statearr_64423_64447[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_64423_64447[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (12))){
var inst_64403 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_64404 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64405 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_64406 = cljs.core.PersistentHashMap.fromArrays(inst_64404,inst_64405);
var inst_64407 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64403,inst_64406);
var inst_64408 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64407);
var state_64414__$1 = state_64414;
var statearr_64424_64448 = state_64414__$1;
(statearr_64424_64448[(2)] = inst_64408);

(statearr_64424_64448[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (2))){
var inst_64380 = (state_64414[(7)]);
var inst_64365 = (state_64414[(9)]);
var inst_64378 = (state_64414[(11)]);
var inst_64378__$1 = (state_64414[(2)]);
var inst_64379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64378__$1,(0),null);
var inst_64380__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64378__$1,(1),null);
var inst_64381 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64380__$1,inst_64365);
var state_64414__$1 = (function (){var statearr_64425 = state_64414;
(statearr_64425[(12)] = inst_64379);

(statearr_64425[(7)] = inst_64380__$1);

(statearr_64425[(11)] = inst_64378__$1);

return statearr_64425;
})();
if(inst_64381){
var statearr_64426_64449 = state_64414__$1;
(statearr_64426_64449[(1)] = (3));

} else {
var statearr_64427_64450 = state_64414__$1;
(statearr_64427_64450[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (11))){
var inst_64395 = (state_64414[(2)]);
var state_64414__$1 = state_64414;
var statearr_64428_64451 = state_64414__$1;
(statearr_64428_64451[(2)] = inst_64395);

(statearr_64428_64451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (9))){
var inst_64379 = (state_64414[(12)]);
var state_64414__$1 = state_64414;
var statearr_64429_64452 = state_64414__$1;
(statearr_64429_64452[(2)] = inst_64379);

(statearr_64429_64452[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (5))){
var inst_64399 = (state_64414[(10)]);
var inst_64399__$1 = (state_64414[(2)]);
var inst_64400 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_64401 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_64399__$1);
var state_64414__$1 = (function (){var statearr_64430 = state_64414;
(statearr_64430[(10)] = inst_64399__$1);

(statearr_64430[(13)] = inst_64400);

return statearr_64430;
})();
if(inst_64401){
var statearr_64431_64453 = state_64414__$1;
(statearr_64431_64453[(1)] = (12));

} else {
var statearr_64432_64454 = state_64414__$1;
(statearr_64432_64454[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (14))){
var inst_64412 = (state_64414[(2)]);
var state_64414__$1 = state_64414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64414__$1,inst_64412);
} else {
if((state_val_64415 === (10))){
var state_64414__$1 = state_64414;
var statearr_64433_64455 = state_64414__$1;
(statearr_64433_64455[(2)] = null);

(statearr_64433_64455[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64415 === (8))){
var inst_64397 = (state_64414[(2)]);
var state_64414__$1 = state_64414;
var statearr_64434_64456 = state_64414__$1;
(statearr_64434_64456[(2)] = inst_64397);

(statearr_64434_64456[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0 = (function (){
var statearr_64435 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64435[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__);

(statearr_64435[(1)] = (1));

return statearr_64435;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1 = (function (state_64414){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64414);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64436){var ex__2687__auto__ = e64436;
var statearr_64437_64457 = state_64414;
(statearr_64437_64457[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64414[(4)]))){
var statearr_64438_64458 = state_64414;
(statearr_64438_64458[(1)] = cljs.core.first((state_64414[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64459 = state_64414;
state_64414 = G__64459;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = function(state_64414){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1.call(this,state_64414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64439 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64439[(6)] = c__2706__auto___64440);

return statearr_64439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__64461 = arguments.length;
switch (G__64461) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__64462){
var map__64463 = p__64462;
var map__64463__$1 = cljs.core.__destructure_map(map__64463);
var opts = map__64463__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64463__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64463__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64463__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64463__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64463__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2706__auto___64552 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64514){
var state_val_64515 = (state_64514[(1)]);
if((state_val_64515 === (7))){
var inst_64476 = (state_64514[(7)]);
var inst_64478 = fluree.db.api.ledger.syncTo_db(inst_64476,syncTo,syncTimeout);
var state_64514__$1 = state_64514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64514__$1,(10),inst_64478);
} else {
if((state_val_64515 === (20))){
var inst_64500 = (state_64514[(8)]);
var state_64514__$1 = state_64514;
var statearr_64516_64553 = state_64514__$1;
(statearr_64516_64553[(2)] = inst_64500);

(statearr_64516_64553[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (1))){
var state_64514__$1 = state_64514;
var statearr_64517_64554 = state_64514__$1;
(statearr_64517_64554[(2)] = null);

(statearr_64517_64554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (4))){
var inst_64464 = (state_64514[(2)]);
var inst_64465 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64464);
var inst_64466 = cljs.core.async.close_BANG_(pc);
var state_64514__$1 = (function (){var statearr_64518 = state_64514;
(statearr_64518[(9)] = inst_64465);

return statearr_64518;
})();
var statearr_64519_64555 = state_64514__$1;
(statearr_64519_64555[(2)] = inst_64466);

(statearr_64519_64555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (15))){
var inst_64492 = (state_64514[(10)]);
var inst_64494 = fluree.db.api.ledger.add_db_permissions(inst_64492,auth,roles);
var state_64514__$1 = state_64514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64514__$1,(18),inst_64494);
} else {
if((state_val_64515 === (21))){
var inst_64508 = (state_64514[(2)]);
var inst_64509 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64508);
var _ = (function (){var statearr_64520 = state_64514;
(statearr_64520[(4)] = cljs.core.rest((state_64514[(4)])));

return statearr_64520;
})();
var state_64514__$1 = state_64514;
var statearr_64521_64556 = state_64514__$1;
(statearr_64521_64556[(2)] = inst_64509);

(statearr_64521_64556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (13))){
var inst_64492 = (state_64514[(2)]);
var state_64514__$1 = (function (){var statearr_64522 = state_64514;
(statearr_64522[(10)] = inst_64492);

return statearr_64522;
})();
if(cljs.core.truth_(roles)){
var statearr_64523_64557 = state_64514__$1;
(statearr_64523_64557[(1)] = (15));

} else {
var statearr_64524_64558 = state_64514__$1;
(statearr_64524_64558[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (22))){
var inst_64504 = (state_64514[(2)]);
var inst_64505 = fluree.db.util.async.throw_err(inst_64504);
var state_64514__$1 = state_64514;
var statearr_64525_64559 = state_64514__$1;
(statearr_64525_64559[(2)] = inst_64505);

(statearr_64525_64559[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (6))){
var inst_64475 = (state_64514[(2)]);
var inst_64476 = fluree.db.util.async.throw_err(inst_64475);
var state_64514__$1 = (function (){var statearr_64526 = state_64514;
(statearr_64526[(7)] = inst_64476);

return statearr_64526;
})();
if(cljs.core.truth_(syncTo)){
var statearr_64527_64560 = state_64514__$1;
(statearr_64527_64560[(1)] = (7));

} else {
var statearr_64528_64561 = state_64514__$1;
(statearr_64528_64561[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (17))){
var inst_64500 = (state_64514[(2)]);
var state_64514__$1 = (function (){var statearr_64529 = state_64514;
(statearr_64529[(8)] = inst_64500);

return statearr_64529;
})();
if(cljs.core.truth_(auth)){
var statearr_64530_64562 = state_64514__$1;
(statearr_64530_64562[(1)] = (19));

} else {
var statearr_64531_64563 = state_64514__$1;
(statearr_64531_64563[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (3))){
var inst_64512 = (state_64514[(2)]);
var state_64514__$1 = state_64514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64514__$1,inst_64512);
} else {
if((state_val_64515 === (12))){
var inst_64484 = (state_64514[(11)]);
var state_64514__$1 = state_64514;
var statearr_64532_64564 = state_64514__$1;
(statearr_64532_64564[(2)] = inst_64484);

(statearr_64532_64564[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (2))){
var _ = (function (){var statearr_64533 = state_64514;
(statearr_64533[(4)] = cljs.core.cons((5),(state_64514[(4)])));

return statearr_64533;
})();
var inst_64473 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_64514__$1 = state_64514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64514__$1,(6),inst_64473);
} else {
if((state_val_64515 === (19))){
var inst_64500 = (state_64514[(8)]);
var inst_64502 = fluree.db.api.ledger.add_db_permissions(inst_64500,auth,roles);
var state_64514__$1 = state_64514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64514__$1,(22),inst_64502);
} else {
if((state_val_64515 === (11))){
var inst_64484 = (state_64514[(11)]);
var inst_64486 = fluree.db.time_travel.as_of_block(inst_64484,block);
var state_64514__$1 = state_64514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64514__$1,(14),inst_64486);
} else {
if((state_val_64515 === (9))){
var inst_64484 = (state_64514[(2)]);
var state_64514__$1 = (function (){var statearr_64535 = state_64514;
(statearr_64535[(11)] = inst_64484);

return statearr_64535;
})();
if(cljs.core.truth_(block)){
var statearr_64536_64565 = state_64514__$1;
(statearr_64536_64565[(1)] = (11));

} else {
var statearr_64537_64566 = state_64514__$1;
(statearr_64537_64566[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (5))){
var _ = (function (){var statearr_64538 = state_64514;
(statearr_64538[(4)] = cljs.core.rest((state_64514[(4)])));

return statearr_64538;
})();
var state_64514__$1 = state_64514;
var ex64534 = (state_64514__$1[(2)]);
var statearr_64539_64567 = state_64514__$1;
(statearr_64539_64567[(5)] = ex64534);


var statearr_64540_64568 = state_64514__$1;
(statearr_64540_64568[(1)] = (4));

(statearr_64540_64568[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (14))){
var inst_64488 = (state_64514[(2)]);
var inst_64489 = fluree.db.util.async.throw_err(inst_64488);
var state_64514__$1 = state_64514;
var statearr_64541_64569 = state_64514__$1;
(statearr_64541_64569[(2)] = inst_64489);

(statearr_64541_64569[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (16))){
var inst_64492 = (state_64514[(10)]);
var state_64514__$1 = state_64514;
var statearr_64542_64570 = state_64514__$1;
(statearr_64542_64570[(2)] = inst_64492);

(statearr_64542_64570[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (10))){
var inst_64480 = (state_64514[(2)]);
var inst_64481 = fluree.db.util.async.throw_err(inst_64480);
var state_64514__$1 = state_64514;
var statearr_64543_64571 = state_64514__$1;
(statearr_64543_64571[(2)] = inst_64481);

(statearr_64543_64571[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (18))){
var inst_64496 = (state_64514[(2)]);
var inst_64497 = fluree.db.util.async.throw_err(inst_64496);
var state_64514__$1 = state_64514;
var statearr_64544_64572 = state_64514__$1;
(statearr_64544_64572[(2)] = inst_64497);

(statearr_64544_64572[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64515 === (8))){
var inst_64476 = (state_64514[(7)]);
var state_64514__$1 = state_64514;
var statearr_64545_64573 = state_64514__$1;
(statearr_64545_64573[(2)] = inst_64476);

(statearr_64545_64573[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_64546 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64546[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_64546[(1)] = (1));

return statearr_64546;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_64514){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64514);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64547){var ex__2687__auto__ = e64547;
var statearr_64548_64574 = state_64514;
(statearr_64548_64574[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64514[(4)]))){
var statearr_64549_64575 = state_64514;
(statearr_64549_64575[(1)] = cljs.core.first((state_64514[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64576 = state_64514;
state_64514 = G__64576;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_64514){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_64514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64550 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64550[(6)] = c__2706__auto___64552);

return statearr_64550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

