// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__60268 = arguments.length;
switch (G__60268) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___60416 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_60355){
var state_val_60356 = (state_60355[(1)]);
if((state_val_60356 === (7))){
var inst_60286 = (state_60355[(7)]);
var inst_60289 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_60286);
var state_60355__$1 = state_60355;
var statearr_60357_60417 = state_60355__$1;
(statearr_60357_60417[(2)] = inst_60289);

(statearr_60357_60417[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (20))){
var inst_60310 = (state_60355[(8)]);
var inst_60281 = (state_60355[(9)]);
var inst_60314 = fluree.db.auth.roles(inst_60281,inst_60310);
var state_60355__$1 = state_60355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60355__$1,(23),inst_60314);
} else {
if((state_val_60356 === (27))){
var inst_60281 = (state_60355[(9)]);
var inst_60329 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60330 = fluree.db.time_travel.as_of_block(inst_60281,inst_60329);
var state_60355__$1 = state_60355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60355__$1,(30),inst_60330);
} else {
if((state_val_60356 === (1))){
var state_60355__$1 = state_60355;
var statearr_60358_60418 = state_60355__$1;
(statearr_60358_60418[(2)] = null);

(statearr_60358_60418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (24))){
var inst_60281 = (state_60355[(9)]);
var inst_60322 = (state_60355[(10)]);
var inst_60324 = fluree.db.permissions.permission_map(inst_60281,inst_60322,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60355__$1 = state_60355;
var statearr_60359_60419 = state_60355__$1;
(statearr_60359_60419[(2)] = inst_60324);

(statearr_60359_60419[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (4))){
var inst_60269 = (state_60355[(2)]);
var inst_60270 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60269);
var inst_60271 = cljs.core.async.close_BANG_(pc);
var state_60355__$1 = (function (){var statearr_60360 = state_60355;
(statearr_60360[(11)] = inst_60270);

return statearr_60360;
})();
var statearr_60361_60420 = state_60355__$1;
(statearr_60361_60420[(2)] = inst_60271);

(statearr_60361_60420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (15))){
var inst_60286 = (state_60355[(7)]);
var inst_60300 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_60286)," unknown."].join('');
var inst_60301 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60302 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_60303 = cljs.core.PersistentHashMap.fromArrays(inst_60301,inst_60302);
var inst_60304 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60300,inst_60303);
var inst_60305 = (function(){throw inst_60304})();
var state_60355__$1 = state_60355;
var statearr_60362_60421 = state_60355__$1;
(statearr_60362_60421[(2)] = inst_60305);

(statearr_60362_60421[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (21))){
var state_60355__$1 = state_60355;
var statearr_60363_60422 = state_60355__$1;
(statearr_60363_60422[(2)] = null);

(statearr_60363_60422[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (31))){
var inst_60286 = (state_60355[(7)]);
var inst_60336 = (state_60355[(12)]);
var inst_60338 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60336,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_60286);
var state_60355__$1 = state_60355;
var statearr_60364_60423 = state_60355__$1;
(statearr_60364_60423[(2)] = inst_60338);

(statearr_60364_60423[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (32))){
var inst_60336 = (state_60355[(12)]);
var state_60355__$1 = state_60355;
var statearr_60365_60424 = state_60355__$1;
(statearr_60365_60424[(2)] = inst_60336);

(statearr_60365_60424[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (33))){
var inst_60322 = (state_60355[(10)]);
var inst_60341 = (state_60355[(2)]);
var state_60355__$1 = (function (){var statearr_60366 = state_60355;
(statearr_60366[(13)] = inst_60341);

return statearr_60366;
})();
if(cljs.core.truth_(inst_60322)){
var statearr_60367_60425 = state_60355__$1;
(statearr_60367_60425[(1)] = (34));

} else {
var statearr_60368_60426 = state_60355__$1;
(statearr_60368_60426[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (13))){
var inst_60297 = (state_60355[(14)]);
var inst_60296 = (state_60355[(2)]);
var inst_60297__$1 = fluree.db.util.async.throw_err(inst_60296);
var state_60355__$1 = (function (){var statearr_60369 = state_60355;
(statearr_60369[(14)] = inst_60297__$1);

return statearr_60369;
})();
if(cljs.core.truth_(inst_60297__$1)){
var statearr_60370_60427 = state_60355__$1;
(statearr_60370_60427[(1)] = (14));

} else {
var statearr_60371_60428 = state_60355__$1;
(statearr_60371_60428[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (22))){
var inst_60320 = (state_60355[(2)]);
var state_60355__$1 = state_60355;
var statearr_60372_60429 = state_60355__$1;
(statearr_60372_60429[(2)] = inst_60320);

(statearr_60372_60429[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (36))){
var inst_60349 = (state_60355[(2)]);
var inst_60350 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60349);
var _ = (function (){var statearr_60373 = state_60355;
(statearr_60373[(4)] = cljs.core.rest((state_60355[(4)])));

return statearr_60373;
})();
var state_60355__$1 = state_60355;
var statearr_60374_60430 = state_60355__$1;
(statearr_60374_60430[(2)] = inst_60350);

(statearr_60374_60430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (29))){
var inst_60286 = (state_60355[(7)]);
var inst_60336 = (state_60355[(2)]);
var state_60355__$1 = (function (){var statearr_60375 = state_60355;
(statearr_60375[(12)] = inst_60336);

return statearr_60375;
})();
if(cljs.core.truth_(inst_60286)){
var statearr_60376_60431 = state_60355__$1;
(statearr_60376_60431[(1)] = (31));

} else {
var statearr_60377_60432 = state_60355__$1;
(statearr_60377_60432[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (6))){
var inst_60286 = (state_60355[(7)]);
var inst_60280 = (state_60355[(2)]);
var inst_60281 = fluree.db.util.async.throw_err(inst_60280);
var inst_60282 = opts;
var inst_60283 = cljs.core.__destructure_map(inst_60282);
var inst_60284 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60283,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_60285 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60283,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_60286__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60283,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60283,new cljs.core.Keyword(null,"block","block",664686210));
var state_60355__$1 = (function (){var statearr_60378 = state_60355;
(statearr_60378[(7)] = inst_60286__$1);

(statearr_60378[(15)] = inst_60284);

(statearr_60378[(16)] = inst_60287);

(statearr_60378[(17)] = inst_60285);

(statearr_60378[(9)] = inst_60281);

return statearr_60378;
})();
if(cljs.core.truth_(inst_60286__$1)){
var statearr_60379_60433 = state_60355__$1;
(statearr_60379_60433[(1)] = (7));

} else {
var statearr_60380_60434 = state_60355__$1;
(statearr_60380_60434[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (28))){
var inst_60281 = (state_60355[(9)]);
var state_60355__$1 = state_60355;
var statearr_60381_60435 = state_60355__$1;
(statearr_60381_60435[(2)] = inst_60281);

(statearr_60381_60435[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (25))){
var state_60355__$1 = state_60355;
var statearr_60382_60436 = state_60355__$1;
(statearr_60382_60436[(2)] = null);

(statearr_60382_60436[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (34))){
var inst_60327 = (state_60355[(18)]);
var state_60355__$1 = state_60355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60355__$1,(37),inst_60327);
} else {
if((state_val_60356 === (17))){
var inst_60284 = (state_60355[(15)]);
var state_60355__$1 = state_60355;
var statearr_60383_60437 = state_60355__$1;
(statearr_60383_60437[(2)] = inst_60284);

(statearr_60383_60437[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (3))){
var inst_60353 = (state_60355[(2)]);
var state_60355__$1 = state_60355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60355__$1,inst_60353);
} else {
if((state_val_60356 === (12))){
var inst_60284 = (state_60355[(15)]);
var inst_60310 = (state_60355[(2)]);
var state_60355__$1 = (function (){var statearr_60384 = state_60355;
(statearr_60384[(8)] = inst_60310);

return statearr_60384;
})();
if(cljs.core.truth_(inst_60284)){
var statearr_60385_60438 = state_60355__$1;
(statearr_60385_60438[(1)] = (17));

} else {
var statearr_60386_60439 = state_60355__$1;
(statearr_60386_60439[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (2))){
var _ = (function (){var statearr_60387 = state_60355;
(statearr_60387[(4)] = cljs.core.cons((5),(state_60355[(4)])));

return statearr_60387;
})();
var inst_60278 = fluree.db.session.db(conn,ledger,null);
var state_60355__$1 = state_60355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60355__$1,(6),inst_60278);
} else {
if((state_val_60356 === (23))){
var inst_60316 = (state_60355[(2)]);
var inst_60317 = fluree.db.util.async.throw_err(inst_60316);
var state_60355__$1 = state_60355;
var statearr_60388_60440 = state_60355__$1;
(statearr_60388_60440[(2)] = inst_60317);

(statearr_60388_60440[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (35))){
var inst_60341 = (state_60355[(13)]);
var state_60355__$1 = state_60355;
var statearr_60389_60441 = state_60355__$1;
(statearr_60389_60441[(2)] = inst_60341);

(statearr_60389_60441[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (19))){
var inst_60322 = (state_60355[(10)]);
var inst_60322__$1 = (state_60355[(2)]);
var state_60355__$1 = (function (){var statearr_60390 = state_60355;
(statearr_60390[(10)] = inst_60322__$1);

return statearr_60390;
})();
if(cljs.core.truth_(inst_60322__$1)){
var statearr_60391_60442 = state_60355__$1;
(statearr_60391_60442[(1)] = (24));

} else {
var statearr_60392_60443 = state_60355__$1;
(statearr_60392_60443[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (11))){
var state_60355__$1 = state_60355;
var statearr_60394_60444 = state_60355__$1;
(statearr_60394_60444[(2)] = null);

(statearr_60394_60444[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (9))){
var inst_60292 = (state_60355[(2)]);
var state_60355__$1 = state_60355;
if(cljs.core.truth_(inst_60292)){
var statearr_60395_60445 = state_60355__$1;
(statearr_60395_60445[(1)] = (10));

} else {
var statearr_60396_60446 = state_60355__$1;
(statearr_60396_60446[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (5))){
var _ = (function (){var statearr_60397 = state_60355;
(statearr_60397[(4)] = cljs.core.rest((state_60355[(4)])));

return statearr_60397;
})();
var state_60355__$1 = state_60355;
var ex60393 = (state_60355__$1[(2)]);
var statearr_60398_60447 = state_60355__$1;
(statearr_60398_60447[(5)] = ex60393);


var statearr_60399_60448 = state_60355__$1;
(statearr_60399_60448[(1)] = (4));

(statearr_60399_60448[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (14))){
var inst_60297 = (state_60355[(14)]);
var state_60355__$1 = state_60355;
var statearr_60400_60449 = state_60355__$1;
(statearr_60400_60449[(2)] = inst_60297);

(statearr_60400_60449[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (26))){
var inst_60287 = (state_60355[(16)]);
var inst_60327 = (state_60355[(2)]);
var state_60355__$1 = (function (){var statearr_60401 = state_60355;
(statearr_60401[(18)] = inst_60327);

return statearr_60401;
})();
if(cljs.core.truth_(inst_60287)){
var statearr_60402_60450 = state_60355__$1;
(statearr_60402_60450[(1)] = (27));

} else {
var statearr_60403_60451 = state_60355__$1;
(statearr_60403_60451[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (16))){
var inst_60307 = (state_60355[(2)]);
var state_60355__$1 = state_60355;
var statearr_60404_60452 = state_60355__$1;
(statearr_60404_60452[(2)] = inst_60307);

(statearr_60404_60452[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (30))){
var inst_60332 = (state_60355[(2)]);
var inst_60333 = fluree.db.util.async.throw_err(inst_60332);
var state_60355__$1 = state_60355;
var statearr_60405_60453 = state_60355__$1;
(statearr_60405_60453[(2)] = inst_60333);

(statearr_60405_60453[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (10))){
var inst_60286 = (state_60355[(7)]);
var inst_60281 = (state_60355[(9)]);
var inst_60294 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_60281,inst_60286);
var state_60355__$1 = state_60355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60355__$1,(13),inst_60294);
} else {
if((state_val_60356 === (18))){
var inst_60310 = (state_60355[(8)]);
var state_60355__$1 = state_60355;
if(cljs.core.truth_(inst_60310)){
var statearr_60406_60454 = state_60355__$1;
(statearr_60406_60454[(1)] = (20));

} else {
var statearr_60407_60455 = state_60355__$1;
(statearr_60407_60455[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (37))){
var inst_60341 = (state_60355[(13)]);
var inst_60344 = (state_60355[(2)]);
var inst_60345 = fluree.db.util.async.throw_err(inst_60344);
var inst_60346 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60341,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60345);
var state_60355__$1 = state_60355;
var statearr_60408_60456 = state_60355__$1;
(statearr_60408_60456[(2)] = inst_60346);

(statearr_60408_60456[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60356 === (8))){
var inst_60286 = (state_60355[(7)]);
var state_60355__$1 = state_60355;
var statearr_60409_60457 = state_60355__$1;
(statearr_60409_60457[(2)] = inst_60286);

(statearr_60409_60457[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2684__auto__ = null;
var fluree$db$api$query$state_machine__2684__auto____0 = (function (){
var statearr_60410 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60410[(0)] = fluree$db$api$query$state_machine__2684__auto__);

(statearr_60410[(1)] = (1));

return statearr_60410;
});
var fluree$db$api$query$state_machine__2684__auto____1 = (function (state_60355){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_60355);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e60411){var ex__2687__auto__ = e60411;
var statearr_60412_60458 = state_60355;
(statearr_60412_60458[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_60355[(4)]))){
var statearr_60413_60459 = state_60355;
(statearr_60413_60459[(1)] = cljs.core.first((state_60355[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60460 = state_60355;
state_60355 = G__60460;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2684__auto__ = function(state_60355){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2684__auto____1.call(this,state_60355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2684__auto____0;
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2684__auto____1;
return fluree$db$api$query$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_60414 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_60414[(6)] = c__2706__auto___60416);

return statearr_60414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_60601){
var state_val_60602 = (state_60601[(1)]);
if((state_val_60602 === (7))){
var inst_60481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60482 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60483 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60484 = [inst_60482,inst_60483];
var inst_60485 = (new cljs.core.PersistentVector(null,2,(5),inst_60481,inst_60484,null));
var state_60601__$1 = state_60601;
var statearr_60603_60673 = state_60601__$1;
(statearr_60603_60673[(2)] = inst_60485);

(statearr_60603_60673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (20))){
var inst_60511 = (state_60601[(7)]);
var state_60601__$1 = state_60601;
var statearr_60604_60674 = state_60601__$1;
(statearr_60604_60674[(2)] = inst_60511);

(statearr_60604_60674[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (27))){
var state_60601__$1 = state_60601;
var statearr_60605_60675 = state_60601__$1;
(statearr_60605_60675[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (1))){
var state_60601__$1 = state_60601;
var statearr_60607_60676 = state_60601__$1;
(statearr_60607_60676[(2)] = null);

(statearr_60607_60676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (24))){
var inst_60510 = (state_60601[(8)]);
var state_60601__$1 = state_60601;
if(cljs.core.truth_(inst_60510)){
var statearr_60608_60677 = state_60601__$1;
(statearr_60608_60677[(1)] = (26));

} else {
var statearr_60609_60678 = state_60601__$1;
(statearr_60609_60678[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (39))){
var inst_60556 = (state_60601[(9)]);
var inst_60557 = (state_60601[(10)]);
var inst_60582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60583 = [inst_60556,inst_60557];
var inst_60584 = (new cljs.core.PersistentVector(null,2,(5),inst_60582,inst_60583,null));
var state_60601__$1 = state_60601;
var statearr_60610_60679 = state_60601__$1;
(statearr_60610_60679[(2)] = inst_60584);

(statearr_60610_60679[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (4))){
var inst_60461 = (state_60601[(2)]);
var state_60601__$1 = state_60601;
var statearr_60611_60680 = state_60601__$1;
(statearr_60611_60680[(2)] = inst_60461);

(statearr_60611_60680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (15))){
var inst_60490 = (state_60601[(11)]);
var inst_60495 = (state_60601[(12)]);
var inst_60504 = (state_60601[(2)]);
var inst_60505 = [inst_60495,inst_60504];
var inst_60506 = (new cljs.core.PersistentVector(null,2,(5),inst_60490,inst_60505,null));
var state_60601__$1 = state_60601;
var statearr_60612_60681 = state_60601__$1;
(statearr_60612_60681[(2)] = inst_60506);

(statearr_60612_60681[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (21))){
var inst_60510 = (state_60601[(8)]);
var state_60601__$1 = state_60601;
var statearr_60613_60682 = state_60601__$1;
(statearr_60613_60682[(2)] = inst_60510);

(statearr_60613_60682[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (31))){
var inst_60551 = (state_60601[(2)]);
var state_60601__$1 = state_60601;
var statearr_60614_60683 = state_60601__$1;
(statearr_60614_60683[(2)] = inst_60551);

(statearr_60614_60683[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (32))){
var inst_60557 = (state_60601[(10)]);
var inst_60560 = cljs.core.pos_int_QMARK_(inst_60557);
var state_60601__$1 = state_60601;
var statearr_60615_60684 = state_60601__$1;
(statearr_60615_60684[(2)] = inst_60560);

(statearr_60615_60684[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (40))){
var inst_60512 = (state_60601[(13)]);
var inst_60588 = (state_60601[(14)]);
var inst_60586 = (state_60601[(2)]);
var inst_60587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60586,(0),null);
var inst_60588__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60586,(1),null);
var inst_60589 = (inst_60588__$1 > inst_60512);
var state_60601__$1 = (function (){var statearr_60616 = state_60601;
(statearr_60616[(14)] = inst_60588__$1);

(statearr_60616[(15)] = inst_60587);

return statearr_60616;
})();
if(cljs.core.truth_(inst_60589)){
var statearr_60617_60685 = state_60601__$1;
(statearr_60617_60685[(1)] = (41));

} else {
var statearr_60618_60686 = state_60601__$1;
(statearr_60618_60686[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (33))){
var inst_60558 = (state_60601[(16)]);
var state_60601__$1 = state_60601;
var statearr_60619_60687 = state_60601__$1;
(statearr_60619_60687[(2)] = inst_60558);

(statearr_60619_60687[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (13))){
var inst_60496 = (state_60601[(17)]);
var inst_60498 = fluree.db.time_travel.block_to_int_format(db,inst_60496);
var state_60601__$1 = state_60601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60601__$1,(16),inst_60498);
} else {
if((state_val_60602 === (22))){
var inst_60529 = (state_60601[(2)]);
var state_60601__$1 = state_60601;
if(cljs.core.truth_(inst_60529)){
var statearr_60620_60688 = state_60601__$1;
(statearr_60620_60688[(1)] = (23));

} else {
var statearr_60621_60689 = state_60601__$1;
(statearr_60621_60689[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (36))){
var state_60601__$1 = state_60601;
var statearr_60622_60690 = state_60601__$1;
(statearr_60622_60690[(2)] = null);

(statearr_60622_60690[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (41))){
var inst_60512 = (state_60601[(13)]);
var state_60601__$1 = state_60601;
var statearr_60623_60691 = state_60601__$1;
(statearr_60623_60691[(2)] = inst_60512);

(statearr_60623_60691[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (43))){
var inst_60587 = (state_60601[(15)]);
var inst_60593 = (state_60601[(2)]);
var inst_60594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60595 = [inst_60587,inst_60593];
var inst_60596 = (new cljs.core.PersistentVector(null,2,(5),inst_60594,inst_60595,null));
var _ = (function (){var statearr_60624 = state_60601;
(statearr_60624[(4)] = cljs.core.rest((state_60601[(4)])));

return statearr_60624;
})();
var state_60601__$1 = state_60601;
var statearr_60625_60692 = state_60601__$1;
(statearr_60625_60692[(2)] = inst_60596);

(statearr_60625_60692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (29))){
var inst_60487 = (state_60601[(18)]);
var inst_60542 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60487], 0));
var inst_60543 = ["Invalid block range provided: ",inst_60542].join('');
var inst_60544 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60545 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60546 = cljs.core.PersistentHashMap.fromArrays(inst_60544,inst_60545);
var inst_60547 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60543,inst_60546);
var inst_60548 = (function(){throw inst_60547})();
var state_60601__$1 = state_60601;
var statearr_60626_60693 = state_60601__$1;
(statearr_60626_60693[(2)] = inst_60548);

(statearr_60626_60693[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (6))){
var inst_60479 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60601__$1 = state_60601;
var statearr_60627_60694 = state_60601__$1;
(statearr_60627_60694[(2)] = inst_60479);

(statearr_60627_60694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (28))){
var inst_60553 = (state_60601[(2)]);
var state_60601__$1 = state_60601;
var statearr_60628_60695 = state_60601__$1;
(statearr_60628_60695[(2)] = inst_60553);

(statearr_60628_60695[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (25))){
var inst_60556 = (state_60601[(9)]);
var inst_60558 = (state_60601[(16)]);
var inst_60555 = (state_60601[(2)]);
var inst_60556__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60555,(0),null);
var inst_60557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60555,(1),null);
var inst_60558__$1 = cljs.core.pos_int_QMARK_(inst_60556__$1);
var state_60601__$1 = (function (){var statearr_60629 = state_60601;
(statearr_60629[(9)] = inst_60556__$1);

(statearr_60629[(16)] = inst_60558__$1);

(statearr_60629[(10)] = inst_60557);

return statearr_60629;
})();
if(inst_60558__$1){
var statearr_60630_60696 = state_60601__$1;
(statearr_60630_60696[(1)] = (32));

} else {
var statearr_60631_60697 = state_60601__$1;
(statearr_60631_60697[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (34))){
var inst_60563 = (state_60601[(2)]);
var inst_60564 = cljs.core.not(inst_60563);
var state_60601__$1 = state_60601;
if(inst_60564){
var statearr_60632_60698 = state_60601__$1;
(statearr_60632_60698[(1)] = (35));

} else {
var statearr_60633_60699 = state_60601__$1;
(statearr_60633_60699[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (17))){
var inst_60510 = (state_60601[(8)]);
var inst_60512 = (state_60601[(13)]);
var inst_60515 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60510], 0));
var inst_60516 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60512], 0));
var inst_60517 = ["Start block is out of range for this ledger. Start block provided: ",inst_60515,". Database block: ",inst_60516].join('');
var inst_60518 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60519 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60520 = cljs.core.PersistentHashMap.fromArrays(inst_60518,inst_60519);
var inst_60521 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60517,inst_60520);
var inst_60522 = (function(){throw inst_60521})();
var state_60601__$1 = state_60601;
var statearr_60634_60700 = state_60601__$1;
(statearr_60634_60700[(2)] = inst_60522);

(statearr_60634_60700[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (3))){
var inst_60599 = (state_60601[(2)]);
var state_60601__$1 = state_60601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60601__$1,inst_60599);
} else {
if((state_val_60602 === (12))){
var inst_60487 = (state_60601[(18)]);
var inst_60496 = (state_60601[(17)]);
var inst_60494 = (state_60601[(2)]);
var inst_60495 = fluree.db.util.async.throw_err(inst_60494);
var inst_60496__$1 = cljs.core.second(inst_60487);
var state_60601__$1 = (function (){var statearr_60635 = state_60601;
(statearr_60635[(17)] = inst_60496__$1);

(statearr_60635[(12)] = inst_60495);

return statearr_60635;
})();
if(cljs.core.truth_(inst_60496__$1)){
var statearr_60636_60701 = state_60601__$1;
(statearr_60636_60701[(1)] = (13));

} else {
var statearr_60637_60702 = state_60601__$1;
(statearr_60637_60702[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (2))){
var _ = (function (){var statearr_60638 = state_60601;
(statearr_60638[(4)] = cljs.core.cons((5),(state_60601[(4)])));

return statearr_60638;
})();
var inst_60476 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60477 = cljs.core.sequential_QMARK_(inst_60476);
var state_60601__$1 = state_60601;
if(inst_60477){
var statearr_60639_60703 = state_60601__$1;
(statearr_60639_60703[(1)] = (6));

} else {
var statearr_60640_60704 = state_60601__$1;
(statearr_60640_60704[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (23))){
var inst_60510 = (state_60601[(8)]);
var inst_60511 = (state_60601[(7)]);
var inst_60531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60532 = [inst_60510,inst_60511];
var inst_60533 = (new cljs.core.PersistentVector(null,2,(5),inst_60531,inst_60532,null));
var state_60601__$1 = state_60601;
var statearr_60641_60705 = state_60601__$1;
(statearr_60641_60705[(2)] = inst_60533);

(statearr_60641_60705[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (35))){
var inst_60487 = (state_60601[(18)]);
var inst_60566 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60487], 0));
var inst_60567 = ["Invalid block range provided: ",inst_60566].join('');
var inst_60568 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60569 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60570 = cljs.core.PersistentHashMap.fromArrays(inst_60568,inst_60569);
var inst_60571 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60567,inst_60570);
var inst_60572 = (function(){throw inst_60571})();
var state_60601__$1 = state_60601;
var statearr_60642_60706 = state_60601__$1;
(statearr_60642_60706[(2)] = inst_60572);

(statearr_60642_60706[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (19))){
var inst_60510 = (state_60601[(8)]);
var inst_60525 = (state_60601[(2)]);
var state_60601__$1 = (function (){var statearr_60643 = state_60601;
(statearr_60643[(19)] = inst_60525);

return statearr_60643;
})();
if(cljs.core.truth_(inst_60510)){
var statearr_60644_60707 = state_60601__$1;
(statearr_60644_60707[(1)] = (20));

} else {
var statearr_60645_60708 = state_60601__$1;
(statearr_60645_60708[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (11))){
var inst_60510 = (state_60601[(8)]);
var inst_60512 = (state_60601[(13)]);
var inst_60509 = (state_60601[(2)]);
var inst_60510__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60509,(0),null);
var inst_60511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60509,(1),null);
var inst_60512__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60513 = (inst_60510__$1 > inst_60512__$1);
var state_60601__$1 = (function (){var statearr_60647 = state_60601;
(statearr_60647[(8)] = inst_60510__$1);

(statearr_60647[(13)] = inst_60512__$1);

(statearr_60647[(7)] = inst_60511);

return statearr_60647;
})();
if(cljs.core.truth_(inst_60513)){
var statearr_60648_60709 = state_60601__$1;
(statearr_60648_60709[(1)] = (17));

} else {
var statearr_60649_60710 = state_60601__$1;
(statearr_60649_60710[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (9))){
var inst_60487 = (state_60601[(18)]);
var inst_60490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60491 = cljs.core.first(inst_60487);
var inst_60492 = fluree.db.time_travel.block_to_int_format(db,inst_60491);
var state_60601__$1 = (function (){var statearr_60650 = state_60601;
(statearr_60650[(11)] = inst_60490);

return statearr_60650;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60601__$1,(12),inst_60492);
} else {
if((state_val_60602 === (5))){
var _ = (function (){var statearr_60651 = state_60601;
(statearr_60651[(4)] = cljs.core.rest((state_60601[(4)])));

return statearr_60651;
})();
var state_60601__$1 = state_60601;
var ex60646 = (state_60601__$1[(2)]);
var statearr_60652_60711 = state_60601__$1;
(statearr_60652_60711[(5)] = ex60646);


if((ex60646 instanceof Error)){
var statearr_60653_60712 = state_60601__$1;
(statearr_60653_60712[(1)] = (4));

(statearr_60653_60712[(5)] = null);

} else {
throw ex60646;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (14))){
var state_60601__$1 = state_60601;
var statearr_60654_60713 = state_60601__$1;
(statearr_60654_60713[(2)] = null);

(statearr_60654_60713[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (26))){
var inst_60510 = (state_60601[(8)]);
var inst_60536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60537 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60538 = [inst_60510,inst_60537];
var inst_60539 = (new cljs.core.PersistentVector(null,2,(5),inst_60536,inst_60538,null));
var state_60601__$1 = state_60601;
var statearr_60655_60714 = state_60601__$1;
(statearr_60655_60714[(2)] = inst_60539);

(statearr_60655_60714[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (16))){
var inst_60500 = (state_60601[(2)]);
var inst_60501 = fluree.db.util.async.throw_err(inst_60500);
var state_60601__$1 = state_60601;
var statearr_60656_60715 = state_60601__$1;
(statearr_60656_60715[(2)] = inst_60501);

(statearr_60656_60715[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (38))){
var inst_60556 = (state_60601[(9)]);
var inst_60557 = (state_60601[(10)]);
var inst_60578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60579 = [inst_60557,inst_60556];
var inst_60580 = (new cljs.core.PersistentVector(null,2,(5),inst_60578,inst_60579,null));
var state_60601__$1 = state_60601;
var statearr_60657_60716 = state_60601__$1;
(statearr_60657_60716[(2)] = inst_60580);

(statearr_60657_60716[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (30))){
var state_60601__$1 = state_60601;
var statearr_60658_60717 = state_60601__$1;
(statearr_60658_60717[(2)] = null);

(statearr_60658_60717[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (10))){
var inst_60487 = (state_60601[(18)]);
var state_60601__$1 = state_60601;
var statearr_60659_60718 = state_60601__$1;
(statearr_60659_60718[(2)] = inst_60487);

(statearr_60659_60718[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (18))){
var state_60601__$1 = state_60601;
var statearr_60660_60719 = state_60601__$1;
(statearr_60660_60719[(2)] = null);

(statearr_60660_60719[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (42))){
var inst_60588 = (state_60601[(14)]);
var state_60601__$1 = state_60601;
var statearr_60661_60720 = state_60601__$1;
(statearr_60661_60720[(2)] = inst_60588);

(statearr_60661_60720[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (37))){
var inst_60556 = (state_60601[(9)]);
var inst_60557 = (state_60601[(10)]);
var inst_60575 = (state_60601[(2)]);
var inst_60576 = (inst_60557 < inst_60556);
var state_60601__$1 = (function (){var statearr_60662 = state_60601;
(statearr_60662[(20)] = inst_60575);

return statearr_60662;
})();
if(cljs.core.truth_(inst_60576)){
var statearr_60663_60721 = state_60601__$1;
(statearr_60663_60721[(1)] = (38));

} else {
var statearr_60664_60722 = state_60601__$1;
(statearr_60664_60722[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60602 === (8))){
var inst_60487 = (state_60601[(18)]);
var inst_60487__$1 = (state_60601[(2)]);
var inst_60488 = cljs.core.some(cljs.core.string_QMARK_,inst_60487__$1);
var state_60601__$1 = (function (){var statearr_60665 = state_60601;
(statearr_60665[(18)] = inst_60487__$1);

return statearr_60665;
})();
if(cljs.core.truth_(inst_60488)){
var statearr_60666_60723 = state_60601__$1;
(statearr_60666_60723[(1)] = (9));

} else {
var statearr_60667_60724 = state_60601__$1;
(statearr_60667_60724[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_60668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60668[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__);

(statearr_60668[(1)] = (1));

return statearr_60668;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_60601){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_60601);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e60669){var ex__2687__auto__ = e60669;
var statearr_60670_60725 = state_60601;
(statearr_60670_60725[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_60601[(4)]))){
var statearr_60671_60726 = state_60601;
(statearr_60671_60726[(1)] = cljs.core.first((state_60601[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60727 = state_60601;
state_60601 = G__60727;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = function(state_60601){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_60601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_60672 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_60672[(6)] = c__2706__auto__);

return statearr_60672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_60877){
var state_val_60878 = (state_60877[(1)]);
if((state_val_60878 === (7))){
var inst_60789 = (state_60877[(2)]);
var inst_60790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60789,(0),null);
var inst_60791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60789,(1),null);
var inst_60799 = cljs.core.vals(inst_60791);
var inst_60800 = cljs.core.seq(inst_60799);
var inst_60801 = cljs.core.first(inst_60800);
var inst_60802 = cljs.core.next(inst_60800);
var inst_60803 = cljs.core.PersistentVector.EMPTY;
var inst_60804 = inst_60799;
var inst_60805 = inst_60803;
var state_60877__$1 = (function (){var statearr_60879 = state_60877;
(statearr_60879[(7)] = inst_60805);

(statearr_60879[(8)] = inst_60801);

(statearr_60879[(9)] = inst_60802);

(statearr_60879[(10)] = inst_60790);

(statearr_60879[(11)] = inst_60804);

return statearr_60879;
})();
var statearr_60880_60933 = state_60877__$1;
(statearr_60880_60933[(2)] = null);

(statearr_60880_60933[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (20))){
var inst_60811 = (state_60877[(12)]);
var inst_60816 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60817 = cljs.core.PersistentHashMap.EMPTY;
var inst_60818 = [true,inst_60817];
var inst_60819 = cljs.core.PersistentHashMap.fromArrays(inst_60816,inst_60818);
var inst_60820 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60819,inst_60811);
var state_60877__$1 = state_60877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60877__$1,(22),inst_60820);
} else {
if((state_val_60878 === (27))){
var inst_60865 = (state_60877[(2)]);
var state_60877__$1 = state_60877;
var statearr_60881_60934 = state_60877__$1;
(statearr_60881_60934[(2)] = inst_60865);

(statearr_60881_60934[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (1))){
var state_60877__$1 = state_60877;
var statearr_60882_60935 = state_60877__$1;
(statearr_60882_60935[(2)] = null);

(statearr_60882_60935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (24))){
var inst_60829 = (state_60877[(13)]);
var inst_60867 = (state_60877[(2)]);
var inst_60868 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60869 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60870 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60871 = [inst_60869,inst_60870,inst_60829,inst_60867];
var inst_60872 = cljs.core.PersistentHashMap.fromArrays(inst_60868,inst_60871);
var _ = (function (){var statearr_60884 = state_60877;
(statearr_60884[(4)] = cljs.core.rest((state_60877[(4)])));

return statearr_60884;
})();
var state_60877__$1 = state_60877;
var statearr_60885_60936 = state_60877__$1;
(statearr_60885_60936[(2)] = inst_60872);

(statearr_60885_60936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (4))){
var inst_60730 = (state_60877[(2)]);
var state_60877__$1 = state_60877;
var statearr_60886_60937 = state_60877__$1;
(statearr_60886_60937[(2)] = inst_60730);

(statearr_60886_60937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (15))){
var inst_60753 = (state_60877[(14)]);
var inst_60768 = (state_60877[(15)]);
var inst_60775 = (state_60877[(16)]);
var inst_60761 = (state_60877[(17)]);
var inst_60746 = (state_60877[(18)]);
var inst_60760 = (state_60877[(19)]);
var inst_60748 = (state_60877[(20)]);
var inst_60752 = (state_60877[(21)]);
var inst_60770 = (state_60877[(22)]);
var inst_60749 = (state_60877[(23)]);
var inst_60754 = (state_60877[(24)]);
var inst_60781 = (function (){var subject = inst_60768;
var flake = inst_60760;
var vec__60743 = inst_60746;
var first__60745 = inst_60748;
var r = inst_60761;
var asserted_subjects = inst_60753;
var seq__60744 = inst_60749;
var flake_SINGLEQUOTE_ = inst_60775;
var retracted_subjects = inst_60754;
var vec__60756 = inst_60752;
var seq__60757 = inst_60761;
var G__60742 = inst_60752;
var first__60758 = inst_60760;
var asserted_QMARK_ = inst_60770;
return (function (p1__60729_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60729_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60782 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60754,inst_60768,inst_60781);
var tmp60883 = inst_60753;
var inst_60752__$1 = inst_60761;
var inst_60753__$1 = tmp60883;
var inst_60754__$1 = inst_60782;
var state_60877__$1 = (function (){var statearr_60887 = state_60877;
(statearr_60887[(14)] = inst_60753__$1);

(statearr_60887[(21)] = inst_60752__$1);

(statearr_60887[(24)] = inst_60754__$1);

return statearr_60887;
})();
var statearr_60888_60938 = state_60877__$1;
(statearr_60888_60938[(2)] = null);

(statearr_60888_60938[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (21))){
var inst_60827 = (state_60877[(2)]);
var state_60877__$1 = state_60877;
var statearr_60889_60939 = state_60877__$1;
(statearr_60889_60939[(2)] = inst_60827);

(statearr_60889_60939[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (13))){
var inst_60770 = (state_60877[(22)]);
var inst_60775 = (state_60877[(2)]);
var state_60877__$1 = (function (){var statearr_60890 = state_60877;
(statearr_60890[(16)] = inst_60775);

return statearr_60890;
})();
if(cljs.core.truth_(inst_60770)){
var statearr_60891_60940 = state_60877__$1;
(statearr_60891_60940[(1)] = (14));

} else {
var statearr_60892_60941 = state_60877__$1;
(statearr_60892_60941[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (22))){
var inst_60812 = (state_60877[(25)]);
var inst_60805 = (state_60877[(7)]);
var inst_60822 = (state_60877[(2)]);
var inst_60823 = fluree.db.util.async.throw_err(inst_60822);
var inst_60824 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60805,inst_60823);
var inst_60804 = inst_60812;
var inst_60805__$1 = inst_60824;
var state_60877__$1 = (function (){var statearr_60893 = state_60877;
(statearr_60893[(7)] = inst_60805__$1);

(statearr_60893[(11)] = inst_60804);

return statearr_60893;
})();
var statearr_60894_60942 = state_60877__$1;
(statearr_60894_60942[(2)] = null);

(statearr_60894_60942[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (6))){
var inst_60760 = (state_60877[(19)]);
var inst_60752 = (state_60877[(21)]);
var inst_60759 = cljs.core.seq(inst_60752);
var inst_60760__$1 = cljs.core.first(inst_60759);
var inst_60761 = cljs.core.next(inst_60759);
var inst_60762 = cljs.core.not(inst_60760__$1);
var state_60877__$1 = (function (){var statearr_60895 = state_60877;
(statearr_60895[(17)] = inst_60761);

(statearr_60895[(19)] = inst_60760__$1);

return statearr_60895;
})();
if(inst_60762){
var statearr_60896_60943 = state_60877__$1;
(statearr_60896_60943[(1)] = (8));

} else {
var statearr_60897_60944 = state_60877__$1;
(statearr_60897_60944[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (28))){
var inst_60850 = (state_60877[(26)]);
var inst_60843 = (state_60877[(27)]);
var inst_60860 = (state_60877[(2)]);
var inst_60861 = fluree.db.util.async.throw_err(inst_60860);
var inst_60862 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60843,inst_60861);
var inst_60842 = inst_60850;
var inst_60843__$1 = inst_60862;
var state_60877__$1 = (function (){var statearr_60898 = state_60877;
(statearr_60898[(28)] = inst_60842);

(statearr_60898[(27)] = inst_60843__$1);

return statearr_60898;
})();
var statearr_60899_60945 = state_60877__$1;
(statearr_60899_60945[(2)] = null);

(statearr_60899_60945[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (25))){
var inst_60843 = (state_60877[(27)]);
var state_60877__$1 = state_60877;
var statearr_60900_60946 = state_60877__$1;
(statearr_60900_60946[(2)] = inst_60843);

(statearr_60900_60946[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (17))){
var inst_60811 = (state_60877[(12)]);
var inst_60804 = (state_60877[(11)]);
var inst_60810 = cljs.core.seq(inst_60804);
var inst_60811__$1 = cljs.core.first(inst_60810);
var inst_60812 = cljs.core.next(inst_60810);
var inst_60813 = cljs.core.not(inst_60811__$1);
var state_60877__$1 = (function (){var statearr_60901 = state_60877;
(statearr_60901[(25)] = inst_60812);

(statearr_60901[(12)] = inst_60811__$1);

return statearr_60901;
})();
if(inst_60813){
var statearr_60902_60947 = state_60877__$1;
(statearr_60902_60947[(1)] = (19));

} else {
var statearr_60903_60948 = state_60877__$1;
(statearr_60903_60948[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (3))){
var inst_60875 = (state_60877[(2)]);
var state_60877__$1 = state_60877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60877__$1,inst_60875);
} else {
if((state_val_60878 === (12))){
var inst_60760 = (state_60877[(19)]);
var inst_60773 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_60760);
var state_60877__$1 = state_60877;
var statearr_60904_60949 = state_60877__$1;
(statearr_60904_60949[(2)] = inst_60773);

(statearr_60904_60949[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (2))){
var inst_60746 = (state_60877[(18)]);
var _ = (function (){var statearr_60905 = state_60877;
(statearr_60905[(4)] = cljs.core.cons((5),(state_60877[(4)])));

return statearr_60905;
})();
var inst_60746__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60747 = cljs.core.seq(inst_60746__$1);
var inst_60748 = cljs.core.first(inst_60747);
var inst_60749 = cljs.core.next(inst_60747);
var inst_60750 = cljs.core.PersistentHashMap.EMPTY;
var inst_60751 = cljs.core.PersistentHashMap.EMPTY;
var inst_60752 = inst_60746__$1;
var inst_60753 = inst_60750;
var inst_60754 = inst_60751;
var state_60877__$1 = (function (){var statearr_60906 = state_60877;
(statearr_60906[(14)] = inst_60753);

(statearr_60906[(18)] = inst_60746__$1);

(statearr_60906[(20)] = inst_60748);

(statearr_60906[(21)] = inst_60752);

(statearr_60906[(23)] = inst_60749);

(statearr_60906[(24)] = inst_60754);

return statearr_60906;
})();
var statearr_60907_60950 = state_60877__$1;
(statearr_60907_60950[(2)] = null);

(statearr_60907_60950[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (23))){
var inst_60842 = (state_60877[(28)]);
var inst_60849 = (state_60877[(29)]);
var inst_60848 = cljs.core.seq(inst_60842);
var inst_60849__$1 = cljs.core.first(inst_60848);
var inst_60850 = cljs.core.next(inst_60848);
var inst_60851 = cljs.core.not(inst_60849__$1);
var state_60877__$1 = (function (){var statearr_60908 = state_60877;
(statearr_60908[(26)] = inst_60850);

(statearr_60908[(29)] = inst_60849__$1);

return statearr_60908;
})();
if(inst_60851){
var statearr_60909_60951 = state_60877__$1;
(statearr_60909_60951[(1)] = (25));

} else {
var statearr_60910_60952 = state_60877__$1;
(statearr_60910_60952[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (19))){
var inst_60805 = (state_60877[(7)]);
var state_60877__$1 = state_60877;
var statearr_60911_60953 = state_60877__$1;
(statearr_60911_60953[(2)] = inst_60805);

(statearr_60911_60953[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (11))){
var inst_60760 = (state_60877[(19)]);
var state_60877__$1 = state_60877;
var statearr_60913_60954 = state_60877__$1;
(statearr_60913_60954[(2)] = inst_60760);

(statearr_60913_60954[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (9))){
var inst_60760 = (state_60877[(19)]);
var inst_60770 = (state_60877[(22)]);
var inst_60768 = inst_60760.s;
var inst_60769 = inst_60760.op;
var inst_60770__$1 = inst_60769 === true;
var state_60877__$1 = (function (){var statearr_60915 = state_60877;
(statearr_60915[(15)] = inst_60768);

(statearr_60915[(22)] = inst_60770__$1);

return statearr_60915;
})();
if(cljs.core.truth_(inst_60770__$1)){
var statearr_60916_60955 = state_60877__$1;
(statearr_60916_60955[(1)] = (11));

} else {
var statearr_60917_60956 = state_60877__$1;
(statearr_60917_60956[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (5))){
var _ = (function (){var statearr_60918 = state_60877;
(statearr_60918[(4)] = cljs.core.rest((state_60877[(4)])));

return statearr_60918;
})();
var state_60877__$1 = state_60877;
var ex60912 = (state_60877__$1[(2)]);
var statearr_60919_60957 = state_60877__$1;
(statearr_60919_60957[(5)] = ex60912);


if((ex60912 instanceof Error)){
var statearr_60920_60958 = state_60877__$1;
(statearr_60920_60958[(1)] = (4));

(statearr_60920_60958[(5)] = null);

} else {
throw ex60912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (14))){
var inst_60753 = (state_60877[(14)]);
var inst_60768 = (state_60877[(15)]);
var inst_60775 = (state_60877[(16)]);
var inst_60761 = (state_60877[(17)]);
var inst_60746 = (state_60877[(18)]);
var inst_60760 = (state_60877[(19)]);
var inst_60748 = (state_60877[(20)]);
var inst_60752 = (state_60877[(21)]);
var inst_60770 = (state_60877[(22)]);
var inst_60749 = (state_60877[(23)]);
var inst_60754 = (state_60877[(24)]);
var inst_60777 = (function (){var subject = inst_60768;
var flake = inst_60760;
var vec__60743 = inst_60746;
var first__60745 = inst_60748;
var r = inst_60761;
var asserted_subjects = inst_60753;
var seq__60744 = inst_60749;
var flake_SINGLEQUOTE_ = inst_60775;
var retracted_subjects = inst_60754;
var vec__60756 = inst_60752;
var seq__60757 = inst_60761;
var G__60742 = inst_60752;
var first__60758 = inst_60760;
var asserted_QMARK_ = inst_60770;
return (function (p1__60728_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60728_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60778 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60753,inst_60768,inst_60777);
var tmp60914 = inst_60754;
var inst_60752__$1 = inst_60761;
var inst_60753__$1 = inst_60778;
var inst_60754__$1 = tmp60914;
var state_60877__$1 = (function (){var statearr_60921 = state_60877;
(statearr_60921[(14)] = inst_60753__$1);

(statearr_60921[(21)] = inst_60752__$1);

(statearr_60921[(24)] = inst_60754__$1);

return statearr_60921;
})();
var statearr_60922_60959 = state_60877__$1;
(statearr_60922_60959[(2)] = null);

(statearr_60922_60959[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (26))){
var inst_60849 = (state_60877[(29)]);
var inst_60854 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60855 = cljs.core.PersistentHashMap.EMPTY;
var inst_60856 = [true,inst_60855];
var inst_60857 = cljs.core.PersistentHashMap.fromArrays(inst_60854,inst_60856);
var inst_60858 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60857,inst_60849);
var state_60877__$1 = state_60877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60877__$1,(28),inst_60858);
} else {
if((state_val_60878 === (16))){
var inst_60785 = (state_60877[(2)]);
var state_60877__$1 = state_60877;
var statearr_60923_60960 = state_60877__$1;
(statearr_60923_60960[(2)] = inst_60785);

(statearr_60923_60960[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (10))){
var inst_60787 = (state_60877[(2)]);
var state_60877__$1 = state_60877;
var statearr_60924_60961 = state_60877__$1;
(statearr_60924_60961[(2)] = inst_60787);

(statearr_60924_60961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (18))){
var inst_60790 = (state_60877[(10)]);
var inst_60829 = (state_60877[(2)]);
var inst_60837 = cljs.core.vals(inst_60790);
var inst_60838 = cljs.core.seq(inst_60837);
var inst_60839 = cljs.core.first(inst_60838);
var inst_60840 = cljs.core.next(inst_60838);
var inst_60841 = cljs.core.PersistentVector.EMPTY;
var inst_60842 = inst_60837;
var inst_60843 = inst_60841;
var state_60877__$1 = (function (){var statearr_60925 = state_60877;
(statearr_60925[(30)] = inst_60840);

(statearr_60925[(13)] = inst_60829);

(statearr_60925[(28)] = inst_60842);

(statearr_60925[(31)] = inst_60839);

(statearr_60925[(27)] = inst_60843);

return statearr_60925;
})();
var statearr_60926_60962 = state_60877__$1;
(statearr_60926_60962[(2)] = null);

(statearr_60926_60962[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60878 === (8))){
var inst_60753 = (state_60877[(14)]);
var inst_60754 = (state_60877[(24)]);
var inst_60764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60765 = [inst_60753,inst_60754];
var inst_60766 = (new cljs.core.PersistentVector(null,2,(5),inst_60764,inst_60765,null));
var state_60877__$1 = state_60877;
var statearr_60927_60963 = state_60877__$1;
(statearr_60927_60963[(2)] = inst_60766);

(statearr_60927_60963[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_60928 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60928[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_60928[(1)] = (1));

return statearr_60928;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_60877){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_60877);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e60929){var ex__2687__auto__ = e60929;
var statearr_60930_60964 = state_60877;
(statearr_60930_60964[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_60877[(4)]))){
var statearr_60931_60965 = state_60877;
(statearr_60931_60965[(1)] = cljs.core.first((state_60877[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60966 = state_60877;
state_60877 = G__60966;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_60877){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_60877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_60932 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_60932[(6)] = c__2706__auto__);

return statearr_60932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_60998){
var state_val_60999 = (state_60998[(1)]);
if((state_val_60999 === (1))){
var inst_60967 = cljs.core.volatile_BANG_((0));
var inst_60968 = cljs.core.PersistentHashMap.EMPTY;
var inst_60969 = cljs.core.volatile_BANG_(inst_60968);
var inst_60970 = cljs.core.first(resp);
var inst_60971 = cljs.core.rest(resp);
var inst_60972 = cljs.core.PersistentVector.EMPTY;
var inst_60973 = inst_60967;
var inst_60974 = inst_60969;
var inst_60975 = inst_60970;
var inst_60976 = inst_60971;
var inst_60977 = inst_60972;
var state_60998__$1 = (function (){var statearr_61000 = state_60998;
(statearr_61000[(7)] = inst_60975);

(statearr_61000[(8)] = inst_60974);

(statearr_61000[(9)] = inst_60973);

(statearr_61000[(10)] = inst_60976);

(statearr_61000[(11)] = inst_60977);

return statearr_61000;
})();
var statearr_61001_61016 = state_60998__$1;
(statearr_61001_61016[(2)] = null);

(statearr_61001_61016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60999 === (2))){
var inst_60975 = (state_60998[(7)]);
var inst_60974 = (state_60998[(8)]);
var inst_60973 = (state_60998[(9)]);
var inst_60979 = fluree.db.api.query.format_block_resp_pretty(db,inst_60975,inst_60974,inst_60973);
var state_60998__$1 = state_60998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60998__$1,(4),inst_60979);
} else {
if((state_val_60999 === (3))){
var inst_60996 = (state_60998[(2)]);
var state_60998__$1 = state_60998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60998__$1,inst_60996);
} else {
if((state_val_60999 === (4))){
var inst_60976 = (state_60998[(10)]);
var inst_60977 = (state_60998[(11)]);
var inst_60981 = (state_60998[(2)]);
var inst_60982 = fluree.db.util.async.throw_err(inst_60981);
var inst_60983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60984 = [inst_60982];
var inst_60985 = (new cljs.core.PersistentVector(null,1,(5),inst_60983,inst_60984,null));
var inst_60986 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60977,inst_60985);
var inst_60987 = cljs.core.first(inst_60976);
var state_60998__$1 = (function (){var statearr_61004 = state_60998;
(statearr_61004[(12)] = inst_60986);

return statearr_61004;
})();
if(cljs.core.truth_(inst_60987)){
var statearr_61005_61017 = state_60998__$1;
(statearr_61005_61017[(1)] = (5));

} else {
var statearr_61006_61018 = state_60998__$1;
(statearr_61006_61018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60999 === (5))){
var inst_60974 = (state_60998[(8)]);
var inst_60973 = (state_60998[(9)]);
var inst_60976 = (state_60998[(10)]);
var inst_60986 = (state_60998[(12)]);
var inst_60989 = cljs.core.first(inst_60976);
var inst_60990 = cljs.core.rest(inst_60976);
var tmp61002 = inst_60974;
var tmp61003 = inst_60973;
var inst_60973__$1 = tmp61003;
var inst_60974__$1 = tmp61002;
var inst_60975 = inst_60989;
var inst_60976__$1 = inst_60990;
var inst_60977 = inst_60986;
var state_60998__$1 = (function (){var statearr_61007 = state_60998;
(statearr_61007[(7)] = inst_60975);

(statearr_61007[(8)] = inst_60974__$1);

(statearr_61007[(9)] = inst_60973__$1);

(statearr_61007[(10)] = inst_60976__$1);

(statearr_61007[(11)] = inst_60977);

return statearr_61007;
})();
var statearr_61008_61019 = state_60998__$1;
(statearr_61008_61019[(2)] = null);

(statearr_61008_61019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60999 === (6))){
var inst_60986 = (state_60998[(12)]);
var state_60998__$1 = state_60998;
var statearr_61009_61020 = state_60998__$1;
(statearr_61009_61020[(2)] = inst_60986);

(statearr_61009_61020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60999 === (7))){
var inst_60994 = (state_60998[(2)]);
var state_60998__$1 = state_60998;
var statearr_61010_61021 = state_60998__$1;
(statearr_61010_61021[(2)] = inst_60994);

(statearr_61010_61021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_61011 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61011[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__);

(statearr_61011[(1)] = (1));

return statearr_61011;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1 = (function (state_60998){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_60998);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e61012){var ex__2687__auto__ = e61012;
var statearr_61013_61022 = state_60998;
(statearr_61013_61022[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_60998[(4)]))){
var statearr_61014_61023 = state_60998;
(statearr_61014_61023[(1)] = cljs.core.first((state_60998[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61024 = state_60998;
state_60998 = G__61024;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = function(state_60998){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1.call(this,state_60998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_61015 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_61015[(6)] = c__2706__auto__);

return statearr_61015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__61026 = arguments.length;
switch (G__61026) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__61028){
var map__61029 = p__61028;
var map__61029__$1 = cljs.core.__destructure_map(map__61029);
var query = map__61029__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__61029__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_61114){
var state_val_61115 = (state_61114[(1)]);
if((state_val_61115 === (7))){
var inst_61040 = (state_61114[(7)]);
var inst_61044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61045 = ["_auth/id",inst_61040];
var inst_61046 = (new cljs.core.PersistentVector(null,2,(5),inst_61044,inst_61045,null));
var state_61114__$1 = state_61114;
var statearr_61116_61160 = state_61114__$1;
(statearr_61116_61160[(2)] = inst_61046);

(statearr_61116_61160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (20))){
var inst_61094 = (state_61114[(2)]);
var inst_61095 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_61114__$1 = (function (){var statearr_61117 = state_61114;
(statearr_61117[(8)] = inst_61094);

return statearr_61117;
})();
if(cljs.core.truth_(inst_61095)){
var statearr_61118_61161 = state_61114__$1;
(statearr_61118_61161[(1)] = (22));

} else {
var statearr_61119_61162 = state_61114__$1;
(statearr_61119_61162[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (27))){
var inst_61097 = (state_61114[(9)]);
var inst_61041 = (state_61114[(10)]);
var inst_61103 = (state_61114[(2)]);
var inst_61104 = fluree.db.util.core.response_time_formatted(inst_61041);
var inst_61105 = [(200),inst_61103,(100),inst_61104];
var inst_61106 = cljs.core.PersistentHashMap.fromArrays(inst_61097,inst_61105);
var state_61114__$1 = state_61114;
var statearr_61120_61163 = state_61114__$1;
(statearr_61120_61163[(2)] = inst_61106);

(statearr_61120_61163[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (1))){
var state_61114__$1 = state_61114;
var statearr_61121_61164 = state_61114__$1;
(statearr_61121_61164[(2)] = null);

(statearr_61121_61164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (24))){
var inst_61109 = (state_61114[(2)]);
var _ = (function (){var statearr_61122 = state_61114;
(statearr_61122[(4)] = cljs.core.rest((state_61114[(4)])));

return statearr_61122;
})();
var state_61114__$1 = state_61114;
var statearr_61123_61165 = state_61114__$1;
(statearr_61123_61165[(2)] = inst_61109);

(statearr_61123_61165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (4))){
var inst_61030 = (state_61114[(2)]);
var state_61114__$1 = state_61114;
var statearr_61124_61166 = state_61114__$1;
(statearr_61124_61166[(2)] = inst_61030);

(statearr_61124_61166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (15))){
var inst_61081 = (state_61114[(11)]);
var state_61114__$1 = state_61114;
var statearr_61125_61167 = state_61114__$1;
(statearr_61125_61167[(2)] = inst_61081);

(statearr_61125_61167[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (21))){
var inst_61090 = (state_61114[(2)]);
var inst_61091 = fluree.db.util.async.throw_err(inst_61090);
var state_61114__$1 = state_61114;
var statearr_61126_61168 = state_61114__$1;
(statearr_61126_61168[(2)] = inst_61091);

(statearr_61126_61168[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (13))){
var inst_61039 = (state_61114[(12)]);
var inst_61081 = (state_61114[(11)]);
var inst_61080 = (state_61114[(2)]);
var inst_61081__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_61039);
var state_61114__$1 = (function (){var statearr_61127 = state_61114;
(statearr_61127[(13)] = inst_61080);

(statearr_61127[(11)] = inst_61081__$1);

return statearr_61127;
})();
if(cljs.core.truth_(inst_61081__$1)){
var statearr_61128_61169 = state_61114__$1;
(statearr_61128_61169[(1)] = (15));

} else {
var statearr_61129_61170 = state_61114__$1;
(statearr_61129_61170[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (22))){
var inst_61094 = (state_61114[(8)]);
var inst_61097 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61098 = cljs.core.sequential_QMARK_(inst_61094);
var state_61114__$1 = (function (){var statearr_61130 = state_61114;
(statearr_61130[(9)] = inst_61097);

return statearr_61130;
})();
if(inst_61098){
var statearr_61131_61171 = state_61114__$1;
(statearr_61131_61171[(1)] = (25));

} else {
var statearr_61132_61172 = state_61114__$1;
(statearr_61132_61172[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (6))){
var inst_61039 = (state_61114[(12)]);
var inst_61055 = (state_61114[(14)]);
var inst_61054 = (state_61114[(2)]);
var inst_61055__$1 = fluree.db.util.async.throw_err(inst_61054);
var inst_61056 = fluree.db.api.query.resolve_block_range(inst_61055__$1,inst_61039);
var state_61114__$1 = (function (){var statearr_61133 = state_61114;
(statearr_61133[(14)] = inst_61055__$1);

return statearr_61133;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61114__$1,(10),inst_61056);
} else {
if((state_val_61115 === (25))){
var inst_61094 = (state_61114[(8)]);
var inst_61100 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_61094);
var state_61114__$1 = state_61114;
var statearr_61134_61173 = state_61114__$1;
(statearr_61134_61173[(2)] = inst_61100);

(statearr_61134_61173[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (17))){
var inst_61086 = (state_61114[(2)]);
var state_61114__$1 = state_61114;
if(cljs.core.truth_(inst_61086)){
var statearr_61135_61174 = state_61114__$1;
(statearr_61135_61174[(1)] = (18));

} else {
var statearr_61136_61175 = state_61114__$1;
(statearr_61136_61175[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (3))){
var inst_61112 = (state_61114[(2)]);
var state_61114__$1 = state_61114;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61114__$1,inst_61112);
} else {
if((state_val_61115 === (12))){
var inst_61039 = (state_61114[(12)]);
var inst_61072 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61039], 0));
var inst_61073 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_61072].join('');
var inst_61074 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61075 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61076 = cljs.core.PersistentHashMap.fromArrays(inst_61074,inst_61075);
var inst_61077 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61073,inst_61076);
var inst_61078 = (function(){throw inst_61077})();
var state_61114__$1 = state_61114;
var statearr_61137_61176 = state_61114__$1;
(statearr_61137_61176[(2)] = inst_61078);

(statearr_61137_61176[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (2))){
var inst_61040 = (state_61114[(7)]);
var _ = (function (){var statearr_61138 = state_61114;
(statearr_61138[(4)] = cljs.core.cons((5),(state_61114[(4)])));

return statearr_61138;
})();
var inst_61039 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61040__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_61041 = fluree.db.util.core.current_time_millis();
var inst_61042 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_61114__$1 = (function (){var statearr_61139 = state_61114;
(statearr_61139[(7)] = inst_61040__$1);

(statearr_61139[(12)] = inst_61039);

(statearr_61139[(15)] = inst_61042);

(statearr_61139[(10)] = inst_61041);

return statearr_61139;
})();
if(cljs.core.truth_(inst_61040__$1)){
var statearr_61140_61177 = state_61114__$1;
(statearr_61140_61177[(1)] = (7));

} else {
var statearr_61141_61178 = state_61114__$1;
(statearr_61141_61178[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (23))){
var inst_61094 = (state_61114[(8)]);
var state_61114__$1 = state_61114;
var statearr_61142_61179 = state_61114__$1;
(statearr_61142_61179[(2)] = inst_61094);

(statearr_61142_61179[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (19))){
var inst_61080 = (state_61114[(13)]);
var state_61114__$1 = state_61114;
var statearr_61143_61180 = state_61114__$1;
(statearr_61143_61180[(2)] = inst_61080);

(statearr_61143_61180[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (11))){
var inst_61060 = (state_61114[(16)]);
var inst_61061 = (state_61114[(17)]);
var inst_61055 = (state_61114[(14)]);
var inst_61067 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_61055,inst_61060,inst_61061,opts);
var state_61114__$1 = state_61114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61114__$1,(14),inst_61067);
} else {
if((state_val_61115 === (9))){
var inst_61042 = (state_61114[(15)]);
var inst_61049 = (state_61114[(2)]);
var inst_61050 = [inst_61049];
var inst_61051 = cljs.core.PersistentHashMap.fromArrays(inst_61042,inst_61050);
var inst_61052 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_61051);
var state_61114__$1 = state_61114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61114__$1,(6),inst_61052);
} else {
if((state_val_61115 === (5))){
var _ = (function (){var statearr_61145 = state_61114;
(statearr_61145[(4)] = cljs.core.rest((state_61114[(4)])));

return statearr_61145;
})();
var state_61114__$1 = state_61114;
var ex61144 = (state_61114__$1[(2)]);
var statearr_61146_61181 = state_61114__$1;
(statearr_61146_61181[(5)] = ex61144);


if((ex61144 instanceof Error)){
var statearr_61147_61182 = state_61114__$1;
(statearr_61147_61182[(1)] = (4));

(statearr_61147_61182[(5)] = null);

} else {
throw ex61144;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (14))){
var inst_61069 = (state_61114[(2)]);
var inst_61070 = fluree.db.util.async.throw_err(inst_61069);
var state_61114__$1 = state_61114;
var statearr_61148_61183 = state_61114__$1;
(statearr_61148_61183[(2)] = inst_61070);

(statearr_61148_61183[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (26))){
var inst_61094 = (state_61114[(8)]);
var state_61114__$1 = state_61114;
var statearr_61149_61184 = state_61114__$1;
(statearr_61149_61184[(2)] = inst_61094);

(statearr_61149_61184[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (16))){
var inst_61039 = (state_61114[(12)]);
var inst_61084 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_61039);
var state_61114__$1 = state_61114;
var statearr_61150_61185 = state_61114__$1;
(statearr_61150_61185[(2)] = inst_61084);

(statearr_61150_61185[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (10))){
var inst_61039 = (state_61114[(12)]);
var inst_61058 = (state_61114[(2)]);
var inst_61059 = fluree.db.util.async.throw_err(inst_61058);
var inst_61060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61059,(0),null);
var inst_61061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61059,(1),null);
var inst_61062 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_61063 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_61039,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_61064 = cljs.core.keys(inst_61063);
var inst_61065 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61062,inst_61064);
var state_61114__$1 = (function (){var statearr_61151 = state_61114;
(statearr_61151[(16)] = inst_61060);

(statearr_61151[(17)] = inst_61061);

return statearr_61151;
})();
if(inst_61065){
var statearr_61152_61186 = state_61114__$1;
(statearr_61152_61186[(1)] = (11));

} else {
var statearr_61153_61187 = state_61114__$1;
(statearr_61153_61187[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61115 === (18))){
var inst_61080 = (state_61114[(13)]);
var inst_61055 = (state_61114[(14)]);
var inst_61088 = fluree.db.api.query.format_blocks_resp_pretty(inst_61055,inst_61080);
var state_61114__$1 = state_61114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61114__$1,(21),inst_61088);
} else {
if((state_val_61115 === (8))){
var state_61114__$1 = state_61114;
var statearr_61154_61188 = state_61114__$1;
(statearr_61154_61188[(2)] = null);

(statearr_61154_61188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_61155 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61155[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2684__auto__);

(statearr_61155[(1)] = (1));

return statearr_61155;
});
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1 = (function (state_61114){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_61114);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e61156){var ex__2687__auto__ = e61156;
var statearr_61157_61189 = state_61114;
(statearr_61157_61189[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_61114[(4)]))){
var statearr_61158_61190 = state_61114;
(statearr_61158_61190[(1)] = cljs.core.first((state_61114[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61191 = state_61114;
state_61114 = G__61191;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = function(state_61114){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1.call(this,state_61114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_61159 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_61159[(6)] = c__2706__auto__);

return statearr_61159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__61192 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61192,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61192,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61192,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61192,(3),null);
var vec__61195 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61195,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61195,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__61198 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61198,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61198,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___61202 = arguments.length;
var i__5770__auto___61203 = (0);
while(true){
if((i__5770__auto___61203 < len__5769__auto___61202)){
args__5775__auto__.push((arguments[i__5770__auto___61203]));

var G__61204 = (i__5770__auto___61203 + (1));
i__5770__auto___61203 = G__61204;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq61201){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq61201));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_61400){
var state_val_61401 = (state_61400[(1)]);
if((state_val_61401 === (7))){
var inst_61320 = (state_61400[(7)]);
var inst_61327 = (state_61400[(8)]);
var inst_61326 = cljs.core.seq(inst_61320);
var inst_61327__$1 = cljs.core.first(inst_61326);
var inst_61328 = cljs.core.next(inst_61326);
var state_61400__$1 = (function (){var statearr_61402 = state_61400;
(statearr_61402[(9)] = inst_61328);

(statearr_61402[(8)] = inst_61327__$1);

return statearr_61402;
})();
if(cljs.core.truth_(inst_61327__$1)){
var statearr_61403_61503 = state_61400__$1;
(statearr_61403_61503[(1)] = (9));

} else {
var statearr_61404_61504 = state_61400__$1;
(statearr_61404_61504[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (20))){
var inst_61390 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
var statearr_61405_61505 = state_61400__$1;
(statearr_61405_61505[(2)] = inst_61390);

(statearr_61405_61505[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (27))){
var inst_61345 = (state_61400[(10)]);
var inst_61348 = (state_61400[(11)]);
var inst_61366 = (state_61400[(12)]);
var inst_61368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61369 = [inst_61348,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61370 = (new cljs.core.PersistentVector(null,2,(5),inst_61368,inst_61369,null));
var inst_61371 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61366,inst_61370,fluree.db.api.query.min_safe,inst_61345);
var state_61400__$1 = state_61400;
var statearr_61406_61506 = state_61400__$1;
(statearr_61406_61506[(2)] = inst_61371);

(statearr_61406_61506[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (1))){
var state_61400__$1 = state_61400;
var statearr_61407_61507 = state_61400__$1;
(statearr_61407_61507[(2)] = null);

(statearr_61407_61507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (24))){
var inst_61348 = (state_61400[(11)]);
var inst_61358 = (state_61400[(13)]);
var inst_61327 = (state_61400[(8)]);
var inst_61360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61361 = [inst_61348,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61362 = (new cljs.core.PersistentVector(null,2,(5),inst_61360,inst_61361,null));
var inst_61363 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61358,inst_61362,cljs.core.conj,inst_61327);
var state_61400__$1 = state_61400;
var statearr_61409_61508 = state_61400__$1;
(statearr_61409_61508[(2)] = inst_61363);

(statearr_61409_61508[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (4))){
var inst_61206 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
var statearr_61410_61509 = state_61400__$1;
(statearr_61410_61509[(2)] = inst_61206);

(statearr_61410_61509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (15))){
var inst_61321 = (state_61400[(14)]);
var inst_61328 = (state_61400[(9)]);
var tmp61408 = inst_61321;
var inst_61320 = inst_61328;
var inst_61321__$1 = tmp61408;
var state_61400__$1 = (function (){var statearr_61411 = state_61400;
(statearr_61411[(14)] = inst_61321__$1);

(statearr_61411[(7)] = inst_61320);

return statearr_61411;
})();
var statearr_61412_61510 = state_61400__$1;
(statearr_61412_61510[(2)] = null);

(statearr_61412_61510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (21))){
var inst_61321 = (state_61400[(14)]);
var inst_61348 = (state_61400[(11)]);
var inst_61352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61353 = [inst_61348,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61354 = (new cljs.core.PersistentVector(null,2,(5),inst_61352,inst_61353,null));
var inst_61355 = cljs.core.assoc_in(inst_61321,inst_61354,inst_61348);
var state_61400__$1 = state_61400;
var statearr_61413_61511 = state_61400__$1;
(statearr_61413_61511[(2)] = inst_61355);

(statearr_61413_61511[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (31))){
var inst_61374 = (state_61400[(15)]);
var state_61400__$1 = state_61400;
var statearr_61414_61512 = state_61400__$1;
(statearr_61414_61512[(2)] = inst_61374);

(statearr_61414_61512[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (32))){
var inst_61328 = (state_61400[(9)]);
var inst_61382 = (state_61400[(2)]);
var inst_61320 = inst_61328;
var inst_61321 = inst_61382;
var state_61400__$1 = (function (){var statearr_61415 = state_61400;
(statearr_61415[(14)] = inst_61321);

(statearr_61415[(7)] = inst_61320);

return statearr_61415;
})();
var statearr_61416_61513 = state_61400__$1;
(statearr_61416_61513[(2)] = null);

(statearr_61416_61513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (33))){
var inst_61321 = (state_61400[(14)]);
var state_61400__$1 = state_61400;
var statearr_61417_61514 = state_61400__$1;
(statearr_61417_61514[(2)] = inst_61321);

(statearr_61417_61514[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (13))){
var inst_61330 = (state_61400[(16)]);
var state_61400__$1 = state_61400;
var statearr_61418_61515 = state_61400__$1;
(statearr_61418_61515[(2)] = inst_61330);

(statearr_61418_61515[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (22))){
var inst_61321 = (state_61400[(14)]);
var state_61400__$1 = state_61400;
var statearr_61419_61516 = state_61400__$1;
(statearr_61419_61516[(2)] = inst_61321);

(statearr_61419_61516[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (29))){
var inst_61374 = (state_61400[(2)]);
var state_61400__$1 = (function (){var statearr_61420 = state_61400;
(statearr_61420[(15)] = inst_61374);

return statearr_61420;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61421_61517 = state_61400__$1;
(statearr_61421_61517[(1)] = (30));

} else {
var statearr_61422_61518 = state_61400__$1;
(statearr_61422_61518[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (6))){
var inst_61306 = (state_61400[(2)]);
var inst_61307 = fluree.db.util.async.throw_err(inst_61306);
var inst_61315 = resp;
var inst_61316 = cljs.core.seq(inst_61315);
var inst_61317 = cljs.core.first(inst_61316);
var inst_61318 = cljs.core.next(inst_61316);
var inst_61319 = cljs.core.PersistentHashMap.EMPTY;
var inst_61320 = inst_61315;
var inst_61321 = inst_61319;
var state_61400__$1 = (function (){var statearr_61423 = state_61400;
(statearr_61423[(14)] = inst_61321);

(statearr_61423[(7)] = inst_61320);

(statearr_61423[(17)] = inst_61318);

(statearr_61423[(18)] = inst_61307);

(statearr_61423[(19)] = inst_61317);

return statearr_61423;
})();
var statearr_61424_61519 = state_61400__$1;
(statearr_61424_61519[(2)] = null);

(statearr_61424_61519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (28))){
var inst_61366 = (state_61400[(12)]);
var state_61400__$1 = state_61400;
var statearr_61425_61520 = state_61400__$1;
(statearr_61425_61520[(2)] = inst_61366);

(statearr_61425_61520[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (25))){
var inst_61358 = (state_61400[(13)]);
var state_61400__$1 = state_61400;
var statearr_61426_61521 = state_61400__$1;
(statearr_61426_61521[(2)] = inst_61358);

(statearr_61426_61521[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (34))){
var state_61400__$1 = state_61400;
var statearr_61427_61522 = state_61400__$1;
(statearr_61427_61522[(2)] = null);

(statearr_61427_61522[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (17))){
var inst_61392 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
var statearr_61428_61523 = state_61400__$1;
(statearr_61428_61523[(2)] = inst_61392);

(statearr_61428_61523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (3))){
var inst_61398 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61400__$1,inst_61398);
} else {
if((state_val_61401 === (12))){
var inst_61327 = (state_61400[(8)]);
var inst_61307 = (state_61400[(18)]);
var inst_61332 = fluree.db.api.query.auth_match(auth,inst_61307,inst_61327);
var inst_61333 = cljs.core.not(inst_61332);
var state_61400__$1 = state_61400;
var statearr_61429_61524 = state_61400__$1;
(statearr_61429_61524[(2)] = inst_61333);

(statearr_61429_61524[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (2))){
var _ = (function (){var statearr_61430 = state_61400;
(statearr_61430[(4)] = cljs.core.cons((5),(state_61400[(4)])));

return statearr_61430;
})();
var inst_61212 = (function (){return (function (p1__61205_SHARP_){
return p1__61205_SHARP_.t;
});
})();
var inst_61213 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61212,resp);
var inst_61214 = cljs.core.set(inst_61213);
var inst_61302 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61303 = (function (){var ts = inst_61214;
var c__2706__auto____$1 = inst_61302;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_61300){
var state_val_61301 = (state_61300[(1)]);
if((state_val_61301 === (7))){
var inst_61234 = (state_61300[(7)]);
var inst_61240 = (state_61300[(8)]);
var inst_61246 = (state_61300[(9)]);
var inst_61228 = (state_61300[(10)]);
var inst_61239 = (state_61300[(2)]);
var inst_61240__$1 = fluree.db.util.async.throw_err(inst_61239);
var inst_61242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61243 = [inst_61234,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61244 = (new cljs.core.PersistentVector(null,2,(5),inst_61242,inst_61243,null));
var inst_61245 = cljs.core.assoc_in(inst_61228,inst_61244,inst_61240__$1);
var inst_61246__$1 = auth;
var state_61300__$1 = (function (){var statearr_61431 = state_61300;
(statearr_61431[(11)] = inst_61245);

(statearr_61431[(8)] = inst_61240__$1);

(statearr_61431[(9)] = inst_61246__$1);

return statearr_61431;
})();
if(cljs.core.truth_(inst_61246__$1)){
var statearr_61432_61525 = state_61300__$1;
(statearr_61432_61525[(1)] = (8));

} else {
var statearr_61433_61526 = state_61300__$1;
(statearr_61433_61526[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (1))){
var inst_61222 = (state_61300[(12)]);
var inst_61222__$1 = ts;
var inst_61223 = cljs.core.seq(inst_61222__$1);
var inst_61224 = cljs.core.first(inst_61223);
var inst_61225 = cljs.core.next(inst_61223);
var inst_61226 = cljs.core.PersistentHashMap.EMPTY;
var inst_61227 = inst_61222__$1;
var inst_61228 = inst_61226;
var state_61300__$1 = (function (){var statearr_61434 = state_61300;
(statearr_61434[(13)] = inst_61225);

(statearr_61434[(12)] = inst_61222__$1);

(statearr_61434[(14)] = inst_61227);

(statearr_61434[(15)] = inst_61224);

(statearr_61434[(10)] = inst_61228);

return statearr_61434;
})();
var statearr_61435_61527 = state_61300__$1;
(statearr_61435_61527[(2)] = null);

(statearr_61435_61527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (4))){
var inst_61234 = (state_61300[(7)]);
var inst_61237 = fluree.db.time_travel.non_border_t_to_block(db,inst_61234);
var state_61300__$1 = state_61300;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61300__$1,(7),inst_61237);
} else {
if((state_val_61301 === (13))){
var inst_61235 = (state_61300[(16)]);
var inst_61292 = (state_61300[(2)]);
var inst_61227 = inst_61235;
var inst_61228 = inst_61292;
var state_61300__$1 = (function (){var statearr_61436 = state_61300;
(statearr_61436[(14)] = inst_61227);

(statearr_61436[(10)] = inst_61228);

return statearr_61436;
})();
var statearr_61437_61528 = state_61300__$1;
(statearr_61437_61528[(2)] = null);

(statearr_61437_61528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (6))){
var inst_61296 = (state_61300[(2)]);
var state_61300__$1 = state_61300;
var statearr_61438_61529 = state_61300__$1;
(statearr_61438_61529[(2)] = inst_61296);

(statearr_61438_61529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (3))){
var inst_61298 = (state_61300[(2)]);
var state_61300__$1 = state_61300;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61300__$1,inst_61298);
} else {
if((state_val_61301 === (12))){
var inst_61245 = (state_61300[(11)]);
var state_61300__$1 = state_61300;
var statearr_61439_61530 = state_61300__$1;
(statearr_61439_61530[(2)] = inst_61245);

(statearr_61439_61530[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (2))){
var inst_61234 = (state_61300[(7)]);
var inst_61227 = (state_61300[(14)]);
var inst_61233 = cljs.core.seq(inst_61227);
var inst_61234__$1 = cljs.core.first(inst_61233);
var inst_61235 = cljs.core.next(inst_61233);
var state_61300__$1 = (function (){var statearr_61440 = state_61300;
(statearr_61440[(7)] = inst_61234__$1);

(statearr_61440[(16)] = inst_61235);

return statearr_61440;
})();
if(cljs.core.truth_(inst_61234__$1)){
var statearr_61441_61531 = state_61300__$1;
(statearr_61441_61531[(1)] = (4));

} else {
var statearr_61442_61532 = state_61300__$1;
(statearr_61442_61532[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (11))){
var inst_61245 = (state_61300[(11)]);
var inst_61225 = (state_61300[(13)]);
var inst_61234 = (state_61300[(7)]);
var inst_61222 = (state_61300[(12)]);
var inst_61240 = (state_61300[(8)]);
var inst_61227 = (state_61300[(14)]);
var inst_61224 = (state_61300[(15)]);
var inst_61235 = (state_61300[(16)]);
var inst_61228 = (state_61300[(10)]);
var inst_61252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61253 = [inst_61234,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61254 = (new cljs.core.PersistentVector(null,2,(5),inst_61252,inst_61253,null));
var inst_61267 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61268 = (function (){var t = inst_61234;
var vec__61230 = inst_61227;
var G__61218 = inst_61227;
var seq__61220 = inst_61225;
var block = inst_61240;
var r = inst_61235;
var vec__61219 = inst_61222;
var G__61241 = inst_61245;
var first__61232 = inst_61234;
var seq__61231 = inst_61235;
var acc = inst_61228;
var c__2706__auto____$2 = inst_61267;
var first__61221 = inst_61224;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_61265){
var state_val_61266 = (state_61265[(1)]);
if((state_val_61266 === (1))){
var state_61265__$1 = state_61265;
var statearr_61443_61533 = state_61265__$1;
(statearr_61443_61533[(2)] = null);

(statearr_61443_61533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61266 === (2))){
var ___$1 = (function (){var statearr_61444 = state_61265;
(statearr_61444[(4)] = cljs.core.cons((5),(state_61265[(4)])));

return statearr_61444;
})();
var ___$2 = (function (){var statearr_61445 = state_61265;
(statearr_61445[(4)] = cljs.core.rest((state_61265[(4)])));

return statearr_61445;
})();
var state_61265__$1 = state_61265;
var statearr_61446_61534 = state_61265__$1;
(statearr_61446_61534[(2)] = db);

(statearr_61446_61534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61266 === (3))){
var inst_61263 = (state_61265[(2)]);
var state_61265__$1 = state_61265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61265__$1,inst_61263);
} else {
if((state_val_61266 === (4))){
var inst_61255 = (state_61265[(2)]);
var state_61265__$1 = state_61265;
var statearr_61448_61535 = state_61265__$1;
(statearr_61448_61535[(2)] = inst_61255);

(statearr_61448_61535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61266 === (5))){
var ___$1 = (function (){var statearr_61449 = state_61265;
(statearr_61449[(4)] = cljs.core.rest((state_61265[(4)])));

return statearr_61449;
})();
var state_61265__$1 = state_61265;
var ex61447 = (state_61265__$1[(2)]);
var statearr_61450_61536 = state_61265__$1;
(statearr_61450_61536[(5)] = ex61447);


if((ex61447 instanceof Error)){
var statearr_61451_61537 = state_61265__$1;
(statearr_61451_61537[(1)] = (4));

(statearr_61451_61537[(5)] = null);

} else {
throw ex61447;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_61452 = [null,null,null,null,null,null,null];
(statearr_61452[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_61452[(1)] = (1));

return statearr_61452;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_61265){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_61265);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e61453){var ex__2687__auto__ = e61453;
var statearr_61454_61538 = state_61265;
(statearr_61454_61538[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_61265[(4)]))){
var statearr_61455_61539 = state_61265;
(statearr_61455_61539[(1)] = cljs.core.first((state_61265[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61540 = state_61265;
state_61265 = G__61540;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_61265){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_61265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_61456 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_61456[(6)] = c__2706__auto____$2);

return statearr_61456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_61269 = cljs.core.async.impl.dispatch.run(inst_61268);
var inst_61270 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_61271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61272 = ["?auth","?id"];
var inst_61273 = (new cljs.core.PersistentVector(null,2,(5),inst_61271,inst_61272,null));
var inst_61274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61276 = [inst_61234,"_tx/auth","?auth"];
var inst_61277 = (new cljs.core.PersistentVector(null,3,(5),inst_61275,inst_61276,null));
var inst_61278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61279 = ["?auth","_auth/id","?id"];
var inst_61280 = (new cljs.core.PersistentVector(null,3,(5),inst_61278,inst_61279,null));
var inst_61281 = [inst_61277,inst_61280];
var inst_61282 = (new cljs.core.PersistentVector(null,2,(5),inst_61274,inst_61281,null));
var inst_61283 = [inst_61273,inst_61282];
var inst_61284 = cljs.core.PersistentHashMap.fromArrays(inst_61270,inst_61283);
var inst_61285 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_61267,inst_61284) : fluree.db.api.query.query_async.call(null,inst_61267,inst_61284));
var state_61300__$1 = (function (){var statearr_61457 = state_61300;
(statearr_61457[(17)] = inst_61254);

(statearr_61457[(18)] = inst_61269);

return statearr_61457;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61300__$1,(14),inst_61285);
} else {
if((state_val_61301 === (9))){
var state_61300__$1 = state_61300;
var statearr_61458_61541 = state_61300__$1;
(statearr_61458_61541[(2)] = show_auth);

(statearr_61458_61541[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (5))){
var inst_61228 = (state_61300[(10)]);
var state_61300__$1 = state_61300;
var statearr_61459_61542 = state_61300__$1;
(statearr_61459_61542[(2)] = inst_61228);

(statearr_61459_61542[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (14))){
var inst_61245 = (state_61300[(11)]);
var inst_61254 = (state_61300[(17)]);
var inst_61287 = (state_61300[(2)]);
var inst_61288 = fluree.db.util.async.throw_err(inst_61287);
var inst_61289 = cljs.core.assoc_in(inst_61245,inst_61254,inst_61288);
var state_61300__$1 = state_61300;
var statearr_61460_61543 = state_61300__$1;
(statearr_61460_61543[(2)] = inst_61289);

(statearr_61460_61543[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (10))){
var inst_61250 = (state_61300[(2)]);
var state_61300__$1 = state_61300;
if(cljs.core.truth_(inst_61250)){
var statearr_61461_61544 = state_61300__$1;
(statearr_61461_61544[(1)] = (11));

} else {
var statearr_61462_61545 = state_61300__$1;
(statearr_61462_61545[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61301 === (8))){
var inst_61246 = (state_61300[(9)]);
var state_61300__$1 = state_61300;
var statearr_61463_61546 = state_61300__$1;
(statearr_61463_61546[(2)] = inst_61246);

(statearr_61463_61546[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_61464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61464[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_61464[(1)] = (1));

return statearr_61464;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_61300){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_61300);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e61465){var ex__2687__auto__ = e61465;
var statearr_61466_61547 = state_61300;
(statearr_61466_61547[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_61300[(4)]))){
var statearr_61467_61548 = state_61300;
(statearr_61467_61548[(1)] = cljs.core.first((state_61300[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61549 = state_61300;
state_61300 = G__61549;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_61300){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_61300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_61468 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_61468[(6)] = c__2706__auto____$1);

return statearr_61468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_61304 = cljs.core.async.impl.dispatch.run(inst_61303);
var state_61400__$1 = (function (){var statearr_61469 = state_61400;
(statearr_61469[(20)] = inst_61304);

return statearr_61469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61400__$1,(6),inst_61302);
} else {
if((state_val_61401 === (23))){
var inst_61358 = (state_61400[(2)]);
var state_61400__$1 = (function (){var statearr_61470 = state_61400;
(statearr_61470[(13)] = inst_61358);

return statearr_61470;
})();
var statearr_61471_61550 = state_61400__$1;
(statearr_61471_61550[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (35))){
var inst_61388 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
var statearr_61473_61551 = state_61400__$1;
(statearr_61473_61551[(2)] = inst_61388);

(statearr_61473_61551[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (19))){
var state_61400__$1 = state_61400;
var statearr_61474_61552 = state_61400__$1;
(statearr_61474_61552[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (11))){
var inst_61339 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
if(cljs.core.truth_(inst_61339)){
var statearr_61477_61553 = state_61400__$1;
(statearr_61477_61553[(1)] = (15));

} else {
var statearr_61478_61554 = state_61400__$1;
(statearr_61478_61554[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (9))){
var inst_61330 = (state_61400[(16)]);
var inst_61330__$1 = auth;
var state_61400__$1 = (function (){var statearr_61479 = state_61400;
(statearr_61479[(16)] = inst_61330__$1);

return statearr_61479;
})();
if(cljs.core.truth_(inst_61330__$1)){
var statearr_61480_61555 = state_61400__$1;
(statearr_61480_61555[(1)] = (12));

} else {
var statearr_61481_61556 = state_61400__$1;
(statearr_61481_61556[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (5))){
var _ = (function (){var statearr_61482 = state_61400;
(statearr_61482[(4)] = cljs.core.rest((state_61400[(4)])));

return statearr_61482;
})();
var state_61400__$1 = state_61400;
var ex61476 = (state_61400__$1[(2)]);
var statearr_61483_61557 = state_61400__$1;
(statearr_61483_61557[(5)] = ex61476);


if((ex61476 instanceof Error)){
var statearr_61484_61558 = state_61400__$1;
(statearr_61484_61558[(1)] = (4));

(statearr_61484_61558[(5)] = null);

} else {
throw ex61476;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (14))){
var inst_61336 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
var statearr_61485_61559 = state_61400__$1;
(statearr_61485_61559[(2)] = inst_61336);

(statearr_61485_61559[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (26))){
var inst_61366 = (state_61400[(2)]);
var state_61400__$1 = (function (){var statearr_61486 = state_61400;
(statearr_61486[(12)] = inst_61366);

return statearr_61486;
})();
var statearr_61487_61560 = state_61400__$1;
(statearr_61487_61560[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (16))){
var inst_61327 = (state_61400[(8)]);
var state_61400__$1 = state_61400;
if(cljs.core.truth_(inst_61327)){
var statearr_61489_61561 = state_61400__$1;
(statearr_61489_61561[(1)] = (18));

} else {
var statearr_61490_61562 = state_61400__$1;
(statearr_61490_61562[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (30))){
var inst_61349 = (state_61400[(21)]);
var inst_61348 = (state_61400[(11)]);
var inst_61374 = (state_61400[(15)]);
var inst_61376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61377 = [inst_61348,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61378 = (new cljs.core.PersistentVector(null,2,(5),inst_61376,inst_61377,null));
var inst_61379 = cljs.core.assoc_in(inst_61374,inst_61378,inst_61349);
var state_61400__$1 = state_61400;
var statearr_61491_61563 = state_61400__$1;
(statearr_61491_61563[(2)] = inst_61379);

(statearr_61491_61563[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (10))){
var inst_61327 = (state_61400[(8)]);
var state_61400__$1 = state_61400;
var statearr_61492_61564 = state_61400__$1;
(statearr_61492_61564[(2)] = inst_61327);

(statearr_61492_61564[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (18))){
var inst_61345 = (state_61400[(10)]);
var inst_61327 = (state_61400[(8)]);
var inst_61307 = (state_61400[(18)]);
var inst_61345__$1 = inst_61327.t;
var inst_61346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61307,inst_61345__$1);
var inst_61347 = cljs.core.__destructure_map(inst_61346);
var inst_61348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61347,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61347,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61400__$1 = (function (){var statearr_61493 = state_61400;
(statearr_61493[(10)] = inst_61345__$1);

(statearr_61493[(21)] = inst_61349);

(statearr_61493[(11)] = inst_61348);

return statearr_61493;
})();
var statearr_61494_61565 = state_61400__$1;
(statearr_61494_61565[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (8))){
var inst_61394 = (state_61400[(2)]);
var inst_61395 = cljs.core.vals(inst_61394);
var _ = (function (){var statearr_61496 = state_61400;
(statearr_61496[(4)] = cljs.core.rest((state_61400[(4)])));

return statearr_61496;
})();
var state_61400__$1 = state_61400;
var statearr_61497_61566 = state_61400__$1;
(statearr_61497_61566[(2)] = inst_61395);

(statearr_61497_61566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_61498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61498[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_61498[(1)] = (1));

return statearr_61498;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_61400){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_61400);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e61499){var ex__2687__auto__ = e61499;
var statearr_61500_61567 = state_61400;
(statearr_61500_61567[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_61400[(4)]))){
var statearr_61501_61568 = state_61400;
(statearr_61501_61568[(1)] = cljs.core.first((state_61400[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61569 = state_61400;
state_61400 = G__61569;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_61400){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_61400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_61502 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_61502[(6)] = c__2706__auto__);

return statearr_61502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_61696){
var state_val_61697 = (state_61696[(1)]);
if((state_val_61697 === (7))){
var inst_61592 = (state_61696[(7)]);
var inst_61594 = fluree.db.api.query.resolve_block_range(inst_61592,query_map);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(10),inst_61594);
} else {
if((state_val_61697 === (20))){
var inst_61621 = (state_61696[(2)]);
var inst_61622 = fluree.db.util.async.throw_err(inst_61621);
var inst_61623 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61622);
var inst_61624 = (inst_61623 - (1));
var state_61696__$1 = state_61696;
var statearr_61698_61761 = state_61696__$1;
(statearr_61698_61761[(2)] = inst_61624);

(statearr_61698_61761[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (27))){
var state_61696__$1 = state_61696;
var statearr_61699_61762 = state_61696__$1;
(statearr_61699_61762[(2)] = null);

(statearr_61699_61762[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (1))){
var state_61696__$1 = state_61696;
var statearr_61700_61763 = state_61696__$1;
(statearr_61700_61763[(2)] = null);

(statearr_61700_61763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (24))){
var inst_61631 = (state_61696[(2)]);
var inst_61632 = fluree.db.util.async.throw_err(inst_61631);
var inst_61633 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61632);
var state_61696__$1 = state_61696;
var statearr_61701_61764 = state_61696__$1;
(statearr_61701_61764[(2)] = inst_61633);

(statearr_61701_61764[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (39))){
var inst_61668 = (state_61696[(2)]);
var inst_61669 = fluree.db.util.async.throw_err(inst_61668);
var state_61696__$1 = state_61696;
var statearr_61702_61765 = state_61696__$1;
(statearr_61702_61765[(2)] = inst_61669);

(statearr_61702_61765[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (4))){
var inst_61570 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
var statearr_61703_61766 = state_61696__$1;
(statearr_61703_61766[(2)] = inst_61570);

(statearr_61703_61766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (15))){
var inst_61601 = (state_61696[(8)]);
var state_61696__$1 = state_61696;
var statearr_61704_61767 = state_61696__$1;
(statearr_61704_61767[(2)] = inst_61601);

(statearr_61704_61767[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (21))){
var inst_61592 = (state_61696[(7)]);
var inst_61602 = (state_61696[(9)]);
var inst_61629 = fluree.db.time_travel.as_of_block(inst_61592,inst_61602);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(24),inst_61629);
} else {
if((state_val_61697 === (31))){
var inst_61586 = (state_61696[(10)]);
var state_61696__$1 = state_61696;
var statearr_61705_61768 = state_61696__$1;
(statearr_61705_61768[(2)] = inst_61586);

(statearr_61705_61768[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (32))){
var inst_61647 = (state_61696[(11)]);
var inst_61652 = (state_61696[(12)]);
var inst_61592 = (state_61696[(7)]);
var inst_61656 = (state_61696[(2)]);
var inst_61657 = fluree.db.api.query.format_history_resp(inst_61592,inst_61647,inst_61652,inst_61656);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(29),inst_61657);
} else {
if((state_val_61697 === (40))){
var inst_61647 = (state_61696[(11)]);
var inst_61673 = (state_61696[(13)]);
var inst_61675 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61676 = cljs.core.count(inst_61647);
var inst_61677 = [inst_61673,inst_61676,(200)];
var inst_61678 = cljs.core.PersistentHashMap.fromArrays(inst_61675,inst_61677);
var state_61696__$1 = state_61696;
var statearr_61706_61769 = state_61696__$1;
(statearr_61706_61769[(2)] = inst_61678);

(statearr_61706_61769[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (33))){
var inst_61585 = (state_61696[(14)]);
var state_61696__$1 = state_61696;
var statearr_61707_61770 = state_61696__$1;
(statearr_61707_61770[(2)] = inst_61585);

(statearr_61707_61770[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (13))){
var inst_61691 = (state_61696[(2)]);
var _ = (function (){var statearr_61708 = state_61696;
(statearr_61708[(4)] = cljs.core.rest((state_61696[(4)])));

return statearr_61708;
})();
var state_61696__$1 = state_61696;
var statearr_61709_61771 = state_61696__$1;
(statearr_61709_61771[(2)] = inst_61691);

(statearr_61709_61771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (22))){
var inst_61592 = (state_61696[(7)]);
var inst_61635 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61592);
var state_61696__$1 = state_61696;
var statearr_61710_61772 = state_61696__$1;
(statearr_61710_61772[(2)] = inst_61635);

(statearr_61710_61772[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (36))){
var inst_61660 = (state_61696[(15)]);
var inst_61592 = (state_61696[(7)]);
var inst_61666 = fluree.db.api.query.format_blocks_resp_pretty(inst_61592,inst_61660);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(39),inst_61666);
} else {
if((state_val_61697 === (41))){
var inst_61673 = (state_61696[(13)]);
var state_61696__$1 = state_61696;
var statearr_61711_61773 = state_61696__$1;
(statearr_61711_61773[(2)] = inst_61673);

(statearr_61711_61773[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (29))){
var inst_61585 = (state_61696[(14)]);
var inst_61659 = (state_61696[(2)]);
var inst_61660 = fluree.db.util.async.throw_err(inst_61659);
var state_61696__$1 = (function (){var statearr_61712 = state_61696;
(statearr_61712[(15)] = inst_61660);

return statearr_61712;
})();
if(cljs.core.truth_(inst_61585)){
var statearr_61713_61774 = state_61696__$1;
(statearr_61713_61774[(1)] = (33));

} else {
var statearr_61714_61775 = state_61696__$1;
(statearr_61714_61775[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (6))){
var inst_61582 = (state_61696[(16)]);
var inst_61591 = (state_61696[(2)]);
var inst_61592 = fluree.db.util.async.throw_err(inst_61591);
var state_61696__$1 = (function (){var statearr_61715 = state_61696;
(statearr_61715[(7)] = inst_61592);

return statearr_61715;
})();
if(cljs.core.truth_(inst_61582)){
var statearr_61716_61776 = state_61696__$1;
(statearr_61716_61776[(1)] = (7));

} else {
var statearr_61717_61777 = state_61696__$1;
(statearr_61717_61777[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (28))){
var inst_61587 = (state_61696[(17)]);
var inst_61652 = (state_61696[(2)]);
var state_61696__$1 = (function (){var statearr_61718 = state_61696;
(statearr_61718[(12)] = inst_61652);

return statearr_61718;
})();
if(cljs.core.truth_(inst_61587)){
var statearr_61719_61778 = state_61696__$1;
(statearr_61719_61778[(1)] = (30));

} else {
var statearr_61720_61779 = state_61696__$1;
(statearr_61720_61779[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (25))){
var inst_61588 = (state_61696[(18)]);
var inst_61646 = (state_61696[(2)]);
var inst_61647 = fluree.db.util.async.throw_err(inst_61646);
var state_61696__$1 = (function (){var statearr_61721 = state_61696;
(statearr_61721[(11)] = inst_61647);

return statearr_61721;
})();
if(cljs.core.truth_(inst_61588)){
var statearr_61722_61780 = state_61696__$1;
(statearr_61722_61780[(1)] = (26));

} else {
var statearr_61723_61781 = state_61696__$1;
(statearr_61723_61781[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (34))){
var inst_61584 = (state_61696[(19)]);
var state_61696__$1 = state_61696;
var statearr_61724_61782 = state_61696__$1;
(statearr_61724_61782[(2)] = inst_61584);

(statearr_61724_61782[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (17))){
var inst_61601 = (state_61696[(8)]);
var inst_61592 = (state_61696[(7)]);
var inst_61618 = (inst_61601 - (1));
var inst_61619 = fluree.db.time_travel.as_of_block(inst_61592,inst_61618);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(20),inst_61619);
} else {
if((state_val_61697 === (3))){
var inst_61694 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61696__$1,inst_61694);
} else {
if((state_val_61697 === (12))){
var inst_61683 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_61684 = ["History query not properly formatted. Provided ",inst_61683].join('');
var inst_61685 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61686 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61687 = cljs.core.PersistentHashMap.fromArrays(inst_61685,inst_61686);
var inst_61688 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61684,inst_61687);
var inst_61689 = (function(){throw inst_61688})();
var state_61696__$1 = state_61696;
var statearr_61725_61783 = state_61696__$1;
(statearr_61725_61783[(2)] = inst_61689);

(statearr_61725_61783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (2))){
var _ = (function (){var statearr_61726 = state_61696;
(statearr_61726[(4)] = cljs.core.cons((5),(state_61696[(4)])));

return statearr_61726;
})();
var inst_61580 = query_map;
var inst_61581 = cljs.core.__destructure_map(inst_61580);
var inst_61582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61583 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61581,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61696__$1 = (function (){var statearr_61727 = state_61696;
(statearr_61727[(10)] = inst_61586);

(statearr_61727[(18)] = inst_61588);

(statearr_61727[(20)] = inst_61583);

(statearr_61727[(21)] = inst_61589);

(statearr_61727[(17)] = inst_61587);

(statearr_61727[(14)] = inst_61585);

(statearr_61727[(16)] = inst_61582);

(statearr_61727[(19)] = inst_61584);

return statearr_61727;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(6),sources);
} else {
if((state_val_61697 === (23))){
var inst_61583 = (state_61696[(20)]);
var inst_61592 = (state_61696[(7)]);
var inst_61627 = (state_61696[(22)]);
var inst_61637 = (state_61696[(2)]);
var inst_61638 = fluree.db.api.query.get_history_pattern(inst_61583);
var inst_61639 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61638,(0),null);
var inst_61640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61638,(1),null);
var inst_61641 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61642 = [inst_61627,inst_61637];
var inst_61643 = cljs.core.PersistentHashMap.fromArrays(inst_61641,inst_61642);
var inst_61644 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_61592,inst_61640,cljs.core._EQ_,inst_61639,inst_61643);
var state_61696__$1 = state_61696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61696__$1,(25),inst_61644);
} else {
if((state_val_61697 === (35))){
var inst_61664 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
if(cljs.core.truth_(inst_61664)){
var statearr_61728_61784 = state_61696__$1;
(statearr_61728_61784[(1)] = (36));

} else {
var statearr_61729_61785 = state_61696__$1;
(statearr_61729_61785[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (19))){
var inst_61602 = (state_61696[(9)]);
var inst_61627 = (state_61696[(2)]);
var state_61696__$1 = (function (){var statearr_61730 = state_61696;
(statearr_61730[(22)] = inst_61627);

return statearr_61730;
})();
if(cljs.core.truth_(inst_61602)){
var statearr_61731_61786 = state_61696__$1;
(statearr_61731_61786[(1)] = (21));

} else {
var statearr_61732_61787 = state_61696__$1;
(statearr_61732_61787[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (11))){
var inst_61601 = (state_61696[(8)]);
var inst_61589 = (state_61696[(21)]);
var inst_61611 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61589);
var state_61696__$1 = (function (){var statearr_61734 = state_61696;
(statearr_61734[(23)] = inst_61611);

return statearr_61734;
})();
if(cljs.core.truth_(inst_61601)){
var statearr_61735_61788 = state_61696__$1;
(statearr_61735_61788[(1)] = (14));

} else {
var statearr_61736_61789 = state_61696__$1;
(statearr_61736_61789[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (9))){
var inst_61600 = (state_61696[(2)]);
var inst_61601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61600,(0),null);
var inst_61602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61600,(1),null);
var inst_61603 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61604 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_61605 = cljs.core.keys(inst_61604);
var inst_61606 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61603,inst_61605);
var state_61696__$1 = (function (){var statearr_61737 = state_61696;
(statearr_61737[(8)] = inst_61601);

(statearr_61737[(9)] = inst_61602);

return statearr_61737;
})();
if(inst_61606){
var statearr_61738_61790 = state_61696__$1;
(statearr_61738_61790[(1)] = (11));

} else {
var statearr_61739_61791 = state_61696__$1;
(statearr_61739_61791[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (5))){
var _ = (function (){var statearr_61740 = state_61696;
(statearr_61740[(4)] = cljs.core.rest((state_61696[(4)])));

return statearr_61740;
})();
var state_61696__$1 = state_61696;
var ex61733 = (state_61696__$1[(2)]);
var statearr_61741_61792 = state_61696__$1;
(statearr_61741_61792[(5)] = ex61733);


if((ex61733 instanceof Error)){
var statearr_61742_61793 = state_61696__$1;
(statearr_61742_61793[(1)] = (4));

(statearr_61742_61793[(5)] = null);

} else {
throw ex61733;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (14))){
var inst_61601 = (state_61696[(8)]);
var inst_61613 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_61601);
var state_61696__$1 = state_61696;
var statearr_61743_61794 = state_61696__$1;
(statearr_61743_61794[(2)] = inst_61613);

(statearr_61743_61794[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (26))){
var inst_61588 = (state_61696[(18)]);
var inst_61649 = cljs.core.set(inst_61588);
var state_61696__$1 = state_61696;
var statearr_61744_61795 = state_61696__$1;
(statearr_61744_61795[(2)] = inst_61649);

(statearr_61744_61795[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (16))){
var inst_61616 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
if(cljs.core.truth_(inst_61616)){
var statearr_61745_61796 = state_61696__$1;
(statearr_61745_61796[(1)] = (17));

} else {
var statearr_61746_61797 = state_61696__$1;
(statearr_61746_61797[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (38))){
var inst_61611 = (state_61696[(23)]);
var inst_61673 = (state_61696[(2)]);
var state_61696__$1 = (function (){var statearr_61747 = state_61696;
(statearr_61747[(13)] = inst_61673);

return statearr_61747;
})();
if(cljs.core.truth_(inst_61611)){
var statearr_61748_61798 = state_61696__$1;
(statearr_61748_61798[(1)] = (40));

} else {
var statearr_61749_61799 = state_61696__$1;
(statearr_61749_61799[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (30))){
var inst_61587 = (state_61696[(17)]);
var state_61696__$1 = state_61696;
var statearr_61750_61800 = state_61696__$1;
(statearr_61750_61800[(2)] = inst_61587);

(statearr_61750_61800[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (10))){
var inst_61596 = (state_61696[(2)]);
var inst_61597 = fluree.db.util.async.throw_err(inst_61596);
var state_61696__$1 = state_61696;
var statearr_61751_61801 = state_61696__$1;
(statearr_61751_61801[(2)] = inst_61597);

(statearr_61751_61801[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (18))){
var state_61696__$1 = state_61696;
var statearr_61752_61802 = state_61696__$1;
(statearr_61752_61802[(2)] = (-1));

(statearr_61752_61802[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (42))){
var inst_61681 = (state_61696[(2)]);
var state_61696__$1 = state_61696;
var statearr_61753_61803 = state_61696__$1;
(statearr_61753_61803[(2)] = inst_61681);

(statearr_61753_61803[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (37))){
var inst_61660 = (state_61696[(15)]);
var inst_61671 = fluree.db.api.query.block_Flakes__GT_vector(inst_61660);
var state_61696__$1 = state_61696;
var statearr_61754_61804 = state_61696__$1;
(statearr_61754_61804[(2)] = inst_61671);

(statearr_61754_61804[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61697 === (8))){
var state_61696__$1 = state_61696;
var statearr_61755_61805 = state_61696__$1;
(statearr_61755_61805[(2)] = null);

(statearr_61755_61805[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_61756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61756[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2684__auto__);

(statearr_61756[(1)] = (1));

return statearr_61756;
});
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1 = (function (state_61696){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_61696);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e61757){var ex__2687__auto__ = e61757;
var statearr_61758_61806 = state_61696;
(statearr_61758_61806[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_61696[(4)]))){
var statearr_61759_61807 = state_61696;
(statearr_61759_61807[(1)] = cljs.core.first((state_61696[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61808 = state_61696;
state_61696 = G__61808;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = function(state_61696){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1.call(this,state_61696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_61760 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_61760[(6)] = c__2706__auto__);

return statearr_61760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_61941){
var state_val_61942 = (state_61941[(1)]);
if((state_val_61942 === (7))){
var inst_61838 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_61839 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61838].join('');
var inst_61840 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61841 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61842 = cljs.core.PersistentHashMap.fromArrays(inst_61840,inst_61841);
var inst_61843 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61839,inst_61842);
var inst_61844 = (function(){throw inst_61843})();
var state_61941__$1 = state_61941;
var statearr_61943_62022 = state_61941__$1;
(statearr_61943_62022[(2)] = inst_61844);

(statearr_61943_62022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (20))){
var inst_61876 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
if(cljs.core.truth_(inst_61876)){
var statearr_61944_62023 = state_61941__$1;
(statearr_61944_62023[(1)] = (21));

} else {
var statearr_61945_62024 = state_61941__$1;
(statearr_61945_62024[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (27))){
var inst_61820 = (state_61941[(7)]);
var state_61941__$1 = state_61941;
var statearr_61946_62025 = state_61941__$1;
(statearr_61946_62025[(2)] = inst_61820);

(statearr_61946_62025[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (1))){
var state_61941__$1 = state_61941;
var statearr_61947_62026 = state_61941__$1;
(statearr_61947_62026[(2)] = null);

(statearr_61947_62026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (24))){
var inst_61882 = (state_61941[(8)]);
var state_61941__$1 = state_61941;
var statearr_61948_62027 = state_61941__$1;
(statearr_61948_62027[(2)] = inst_61882);

(statearr_61948_62027[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (39))){
var inst_61826 = (state_61941[(9)]);
var state_61941__$1 = state_61941;
if(cljs.core.truth_(inst_61826)){
var statearr_61949_62028 = state_61941__$1;
(statearr_61949_62028[(1)] = (42));

} else {
var statearr_61950_62029 = state_61941__$1;
(statearr_61950_62029[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (46))){
var inst_61914 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61915 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61916 = cljs.core.PersistentHashMap.fromArrays(inst_61914,inst_61915);
var inst_61917 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_61916);
var inst_61918 = (function(){throw inst_61917})();
var state_61941__$1 = state_61941;
var statearr_61951_62030 = state_61941__$1;
(statearr_61951_62030[(2)] = inst_61918);

(statearr_61951_62030[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (4))){
var inst_61810 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
var statearr_61952_62031 = state_61941__$1;
(statearr_61952_62031[(2)] = inst_61810);

(statearr_61952_62031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (15))){
var inst_61823 = (state_61941[(10)]);
var inst_61861 = (state_61941[(11)]);
var inst_61863 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61861);
var inst_61864 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61861);
var inst_61865 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61861);
var inst_61866 = fluree.db.api.query.get_sources(inst_61863,inst_61864,inst_61865,inst_61823);
var state_61941__$1 = state_61941;
var statearr_61953_62032 = state_61941__$1;
(statearr_61953_62032[(2)] = inst_61866);

(statearr_61953_62032[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (48))){
var inst_61871 = (state_61941[(12)]);
var inst_61925 = (state_61941[(2)]);
var inst_61926 = fluree.db.util.async.throw_err(inst_61925);
var state_61941__$1 = (function (){var statearr_61954 = state_61941;
(statearr_61954[(13)] = inst_61926);

return statearr_61954;
})();
if(cljs.core.truth_(inst_61871)){
var statearr_61955_62033 = state_61941__$1;
(statearr_61955_62033[(1)] = (49));

} else {
var statearr_61956_62034 = state_61941__$1;
(statearr_61956_62034[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (50))){
var inst_61926 = (state_61941[(13)]);
var state_61941__$1 = state_61941;
var statearr_61957_62035 = state_61941__$1;
(statearr_61957_62035[(2)] = inst_61926);

(statearr_61957_62035[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (21))){
var inst_61878 = cljs.core.volatile_BANG_((0));
var state_61941__$1 = state_61941;
var statearr_61958_62036 = state_61941__$1;
(statearr_61958_62036[(2)] = inst_61878);

(statearr_61958_62036[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (31))){
var inst_61824 = (state_61941[(14)]);
var state_61941__$1 = state_61941;
if(cljs.core.truth_(inst_61824)){
var statearr_61959_62037 = state_61941__$1;
(statearr_61959_62037[(1)] = (33));

} else {
var statearr_61960_62038 = state_61941__$1;
(statearr_61960_62038[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (32))){
var inst_61901 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
var statearr_61961_62039 = state_61941__$1;
(statearr_61961_62039[(2)] = inst_61901);

(statearr_61961_62039[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (40))){
var inst_61903 = (state_61941[(15)]);
var state_61941__$1 = state_61941;
var statearr_61962_62040 = state_61941__$1;
(statearr_61962_62040[(2)] = inst_61903);

(statearr_61962_62040[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (33))){
var inst_61824 = (state_61941[(14)]);
var state_61941__$1 = state_61941;
var statearr_61963_62041 = state_61941__$1;
(statearr_61963_62041[(2)] = inst_61824);

(statearr_61963_62041[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (13))){
var inst_61821 = (state_61941[(16)]);
var inst_61850 = (state_61941[(2)]);
var inst_61851 = fluree.db.util.async.throw_err(inst_61850);
var inst_61852 = fluree.db.time_travel.as_of_block(inst_61851,inst_61821);
var state_61941__$1 = state_61941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61941__$1,(12),inst_61852);
} else {
if((state_val_61942 === (22))){
var state_61941__$1 = state_61941;
var statearr_61964_62042 = state_61941__$1;
(statearr_61964_62042[(2)] = null);

(statearr_61964_62042[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (36))){
var inst_61828 = (state_61941[(17)]);
var state_61941__$1 = state_61941;
var statearr_61965_62043 = state_61941__$1;
(statearr_61965_62043[(2)] = inst_61828);

(statearr_61965_62043[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (41))){
var inst_61911 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
if(cljs.core.truth_(inst_61911)){
var statearr_61966_62044 = state_61941__$1;
(statearr_61966_62044[(1)] = (45));

} else {
var statearr_61967_62045 = state_61941__$1;
(statearr_61967_62045[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (43))){
var inst_61822 = (state_61941[(18)]);
var state_61941__$1 = state_61941;
var statearr_61968_62046 = state_61941__$1;
(statearr_61968_62046[(2)] = inst_61822);

(statearr_61968_62046[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (29))){
var inst_61903 = (state_61941[(15)]);
var inst_61903__$1 = (state_61941[(2)]);
var state_61941__$1 = (function (){var statearr_61969 = state_61941;
(statearr_61969[(15)] = inst_61903__$1);

return statearr_61969;
})();
if(cljs.core.truth_(inst_61903__$1)){
var statearr_61970_62047 = state_61941__$1;
(statearr_61970_62047[(1)] = (39));

} else {
var statearr_61971_62048 = state_61941__$1;
(statearr_61971_62048[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (44))){
var inst_61908 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
var statearr_61972_62049 = state_61941__$1;
(statearr_61972_62049[(2)] = inst_61908);

(statearr_61972_62049[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (6))){
var state_61941__$1 = state_61941;
var statearr_61973_62050 = state_61941__$1;
(statearr_61973_62050[(2)] = null);

(statearr_61973_62050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (28))){
var inst_61825 = (state_61941[(19)]);
var state_61941__$1 = state_61941;
if(cljs.core.truth_(inst_61825)){
var statearr_61974_62051 = state_61941__$1;
(statearr_61974_62051[(1)] = (30));

} else {
var statearr_61975_62052 = state_61941__$1;
(statearr_61975_62052[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (51))){
var inst_61936 = (state_61941[(2)]);
var _ = (function (){var statearr_61976 = state_61941;
(statearr_61976[(4)] = cljs.core.rest((state_61941[(4)])));

return statearr_61976;
})();
var state_61941__$1 = state_61941;
var statearr_61977_62053 = state_61941__$1;
(statearr_61977_62053[(2)] = inst_61936);

(statearr_61977_62053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (25))){
var state_61941__$1 = state_61941;
var statearr_61978_62054 = state_61941__$1;
(statearr_61978_62054[(2)] = (1000000));

(statearr_61978_62054[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (34))){
var inst_61828 = (state_61941[(17)]);
var state_61941__$1 = state_61941;
if(cljs.core.truth_(inst_61828)){
var statearr_61979_62055 = state_61941__$1;
(statearr_61979_62055[(1)] = (36));

} else {
var statearr_61980_62056 = state_61941__$1;
(statearr_61980_62056[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (17))){
var inst_61872 = (state_61941[(20)]);
var inst_61827 = (state_61941[(21)]);
var inst_61870 = (state_61941[(2)]);
var inst_61871 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61827);
var inst_61872__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61827);
var state_61941__$1 = (function (){var statearr_61981 = state_61941;
(statearr_61981[(12)] = inst_61871);

(statearr_61981[(20)] = inst_61872__$1);

(statearr_61981[(22)] = inst_61870);

return statearr_61981;
})();
if(cljs.core.truth_(inst_61872__$1)){
var statearr_61982_62057 = state_61941__$1;
(statearr_61982_62057[(1)] = (18));

} else {
var statearr_61983_62058 = state_61941__$1;
(statearr_61983_62058[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (3))){
var inst_61939 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61941__$1,inst_61939);
} else {
if((state_val_61942 === (12))){
var inst_61854 = (state_61941[(2)]);
var inst_61855 = fluree.db.util.async.throw_err(inst_61854);
var state_61941__$1 = state_61941;
var statearr_61984_62059 = state_61941__$1;
(statearr_61984_62059[(2)] = inst_61855);

(statearr_61984_62059[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (2))){
var inst_61821 = (state_61941[(16)]);
var inst_61822 = (state_61941[(18)]);
var inst_61826 = (state_61941[(9)]);
var inst_61824 = (state_61941[(14)]);
var inst_61820 = (state_61941[(7)]);
var inst_61825 = (state_61941[(19)]);
var inst_61823 = (state_61941[(10)]);
var inst_61828 = (state_61941[(17)]);
var inst_61827 = (state_61941[(21)]);
var inst_61819 = (state_61941[(23)]);
var _ = (function (){var statearr_61985 = state_61941;
(statearr_61985[(4)] = cljs.core.cons((5),(state_61941[(4)])));

return statearr_61985;
})();
var inst_61817 = flureeQL;
var inst_61818 = cljs.core.__destructure_map(inst_61817);
var inst_61819__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61820__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61821__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61822__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61823__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61824__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61825__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61826__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61827__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61828__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61818,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61829 = (function (){var construct = inst_61819__$1;
var map__61816 = inst_61818;
var select = inst_61820__$1;
var block = inst_61821__$1;
var where = inst_61822__$1;
var prefixes = inst_61823__$1;
var selectDistinct = inst_61824__$1;
var selectOne = inst_61825__$1;
var from = inst_61826__$1;
var opts = inst_61827__$1;
var selectReduced = inst_61828__$1;
return (function (p1__61809_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__61809_SHARP_);
});
})();
var inst_61830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61831 = [inst_61820__$1,inst_61825__$1,inst_61824__$1,inst_61828__$1];
var inst_61832 = (new cljs.core.PersistentVector(null,4,(5),inst_61830,inst_61831,null));
var inst_61833 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_61832);
var inst_61834 = cljs.core.count(inst_61833);
var inst_61835 = (inst_61829.cljs$core$IFn$_invoke$arity$1 ? inst_61829.cljs$core$IFn$_invoke$arity$1(inst_61834) : inst_61829.call(null,inst_61834));
var state_61941__$1 = (function (){var statearr_61986 = state_61941;
(statearr_61986[(16)] = inst_61821__$1);

(statearr_61986[(18)] = inst_61822__$1);

(statearr_61986[(9)] = inst_61826__$1);

(statearr_61986[(14)] = inst_61824__$1);

(statearr_61986[(7)] = inst_61820__$1);

(statearr_61986[(19)] = inst_61825__$1);

(statearr_61986[(10)] = inst_61823__$1);

(statearr_61986[(17)] = inst_61828__$1);

(statearr_61986[(21)] = inst_61827__$1);

(statearr_61986[(23)] = inst_61819__$1);

return statearr_61986;
})();
if(cljs.core.truth_(inst_61835)){
var statearr_61987_62060 = state_61941__$1;
(statearr_61987_62060[(1)] = (6));

} else {
var statearr_61988_62061 = state_61941__$1;
(statearr_61988_62061[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (23))){
var inst_61882 = (state_61941[(8)]);
var inst_61827 = (state_61941[(21)]);
var inst_61881 = (state_61941[(2)]);
var inst_61882__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61827);
var state_61941__$1 = (function (){var statearr_61989 = state_61941;
(statearr_61989[(24)] = inst_61881);

(statearr_61989[(8)] = inst_61882__$1);

return statearr_61989;
})();
if(cljs.core.truth_(inst_61882__$1)){
var statearr_61990_62062 = state_61941__$1;
(statearr_61990_62062[(1)] = (24));

} else {
var statearr_61991_62063 = state_61941__$1;
(statearr_61991_62063[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (47))){
var inst_61887 = (state_61941[(25)]);
var inst_61861 = (state_61941[(11)]);
var inst_61920 = (state_61941[(2)]);
var inst_61921 = fluree.db.util.core.current_time_millis();
var inst_61922 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61887);
var inst_61923 = fluree.db.query.fql.query(inst_61861,inst_61922);
var state_61941__$1 = (function (){var statearr_61992 = state_61941;
(statearr_61992[(26)] = inst_61921);

(statearr_61992[(27)] = inst_61920);

return statearr_61992;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61941__$1,(48),inst_61923);
} else {
if((state_val_61942 === (35))){
var inst_61899 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
var statearr_61993_62064 = state_61941__$1;
(statearr_61993_62064[(2)] = inst_61899);

(statearr_61993_62064[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (19))){
var inst_61871 = (state_61941[(12)]);
var state_61941__$1 = state_61941;
var statearr_61994_62065 = state_61941__$1;
(statearr_61994_62065[(2)] = inst_61871);

(statearr_61994_62065[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (11))){
var inst_61823 = (state_61941[(10)]);
var inst_61861 = (state_61941[(2)]);
var state_61941__$1 = (function (){var statearr_61996 = state_61941;
(statearr_61996[(11)] = inst_61861);

return statearr_61996;
})();
if(cljs.core.truth_(inst_61823)){
var statearr_61997_62066 = state_61941__$1;
(statearr_61997_62066[(1)] = (15));

} else {
var statearr_61998_62067 = state_61941__$1;
(statearr_61998_62067[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (9))){
var inst_61847 = (state_61941[(28)]);
var state_61941__$1 = state_61941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61941__$1,(13),inst_61847);
} else {
if((state_val_61942 === (5))){
var _ = (function (){var statearr_61999 = state_61941;
(statearr_61999[(4)] = cljs.core.rest((state_61941[(4)])));

return statearr_61999;
})();
var state_61941__$1 = state_61941;
var ex61995 = (state_61941__$1[(2)]);
var statearr_62000_62068 = state_61941__$1;
(statearr_62000_62068[(5)] = ex61995);


if((ex61995 instanceof Error)){
var statearr_62001_62069 = state_61941__$1;
(statearr_62001_62069[(1)] = (4));

(statearr_62001_62069[(5)] = null);

} else {
throw ex61995;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (14))){
var inst_61858 = (state_61941[(2)]);
var inst_61859 = fluree.db.util.async.throw_err(inst_61858);
var state_61941__$1 = state_61941;
var statearr_62002_62070 = state_61941__$1;
(statearr_62002_62070[(2)] = inst_61859);

(statearr_62002_62070[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (45))){
var state_61941__$1 = state_61941;
var statearr_62003_62071 = state_61941__$1;
(statearr_62003_62071[(2)] = null);

(statearr_62003_62071[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (26))){
var inst_61881 = (state_61941[(24)]);
var inst_61820 = (state_61941[(7)]);
var inst_61827 = (state_61941[(21)]);
var inst_61870 = (state_61941[(22)]);
var inst_61886 = (state_61941[(2)]);
var inst_61887 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_61827,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61870,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61886,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61881], 0));
var state_61941__$1 = (function (){var statearr_62004 = state_61941;
(statearr_62004[(25)] = inst_61887);

return statearr_62004;
})();
if(cljs.core.truth_(inst_61820)){
var statearr_62005_62072 = state_61941__$1;
(statearr_62005_62072[(1)] = (27));

} else {
var statearr_62006_62073 = state_61941__$1;
(statearr_62006_62073[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (16))){
var inst_61868 = cljs.core.PersistentHashMap.EMPTY;
var state_61941__$1 = state_61941;
var statearr_62007_62074 = state_61941__$1;
(statearr_62007_62074[(2)] = inst_61868);

(statearr_62007_62074[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (38))){
var inst_61897 = (state_61941[(2)]);
var state_61941__$1 = state_61941;
var statearr_62008_62075 = state_61941__$1;
(statearr_62008_62075[(2)] = inst_61897);

(statearr_62008_62075[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (30))){
var inst_61825 = (state_61941[(19)]);
var state_61941__$1 = state_61941;
var statearr_62009_62076 = state_61941__$1;
(statearr_62009_62076[(2)] = inst_61825);

(statearr_62009_62076[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (10))){
var inst_61847 = (state_61941[(28)]);
var state_61941__$1 = state_61941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61941__$1,(14),inst_61847);
} else {
if((state_val_61942 === (18))){
var inst_61872 = (state_61941[(20)]);
var state_61941__$1 = state_61941;
var statearr_62010_62077 = state_61941__$1;
(statearr_62010_62077[(2)] = inst_61872);

(statearr_62010_62077[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (42))){
var inst_61826 = (state_61941[(9)]);
var state_61941__$1 = state_61941;
var statearr_62011_62078 = state_61941__$1;
(statearr_62011_62078[(2)] = inst_61826);

(statearr_62011_62078[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (37))){
var inst_61819 = (state_61941[(23)]);
var state_61941__$1 = state_61941;
var statearr_62012_62079 = state_61941__$1;
(statearr_62012_62079[(2)] = inst_61819);

(statearr_62012_62079[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (8))){
var inst_61821 = (state_61941[(16)]);
var inst_61846 = (state_61941[(2)]);
var inst_61847 = sources;
var state_61941__$1 = (function (){var statearr_62013 = state_61941;
(statearr_62013[(29)] = inst_61846);

(statearr_62013[(28)] = inst_61847);

return statearr_62013;
})();
if(cljs.core.truth_(inst_61821)){
var statearr_62014_62080 = state_61941__$1;
(statearr_62014_62080[(1)] = (9));

} else {
var statearr_62015_62081 = state_61941__$1;
(statearr_62015_62081[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61942 === (49))){
var inst_61881 = (state_61941[(24)]);
var inst_61921 = (state_61941[(26)]);
var inst_61926 = (state_61941[(13)]);
var inst_61861 = (state_61941[(11)]);
var inst_61928 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61929 = cljs.core.deref(inst_61881);
var inst_61930 = fluree.db.util.core.response_time_formatted(inst_61921);
var inst_61931 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61861);
var inst_61932 = [(200),inst_61926,inst_61929,inst_61930,inst_61931];
var inst_61933 = cljs.core.PersistentHashMap.fromArrays(inst_61928,inst_61932);
var state_61941__$1 = state_61941;
var statearr_62016_62082 = state_61941__$1;
(statearr_62016_62082[(2)] = inst_61933);

(statearr_62016_62082[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_62017 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62017[(0)] = fluree$db$api$query$query_async_$_state_machine__2684__auto__);

(statearr_62017[(1)] = (1));

return statearr_62017;
});
var fluree$db$api$query$query_async_$_state_machine__2684__auto____1 = (function (state_61941){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_61941);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e62018){var ex__2687__auto__ = e62018;
var statearr_62019_62083 = state_61941;
(statearr_62019_62083[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_61941[(4)]))){
var statearr_62020_62084 = state_61941;
(statearr_62020_62084[(1)] = cljs.core.first((state_61941[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62085 = state_61941;
state_61941 = G__62085;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2684__auto__ = function(state_61941){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____1.call(this,state_61941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_62021 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_62021[(6)] = c__2706__auto__);

return statearr_62021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_62226){
var state_val_62227 = (state_62226[(1)]);
if((state_val_62227 === (7))){
var inst_62221 = (state_62226[(2)]);
var _ = (function (){var statearr_62228 = state_62226;
(statearr_62228[(4)] = cljs.core.rest((state_62226[(4)])));

return statearr_62228;
})();
var state_62226__$1 = state_62226;
var statearr_62229_62305 = state_62226__$1;
(statearr_62229_62305[(2)] = inst_62221);

(statearr_62229_62305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (20))){
var inst_62193 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62230_62306 = state_62226__$1;
(statearr_62230_62306[(2)] = inst_62193);

(statearr_62230_62306[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (27))){
var inst_62173 = (state_62226[(7)]);
var state_62226__$1 = state_62226;
var statearr_62231_62307 = state_62226__$1;
(statearr_62231_62307[(2)] = inst_62173);

(statearr_62231_62307[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (1))){
var state_62226__$1 = state_62226;
var statearr_62232_62308 = state_62226__$1;
(statearr_62232_62308[(2)] = null);

(statearr_62232_62308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (24))){
var inst_62170 = (state_62226[(8)]);
var state_62226__$1 = state_62226;
var statearr_62233_62309 = state_62226__$1;
(statearr_62233_62309[(2)] = inst_62170);

(statearr_62233_62309[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (39))){
var inst_62160 = (state_62226[(9)]);
var inst_62127 = (state_62226[(10)]);
var inst_62138 = (state_62226[(11)]);
var inst_62204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62205 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_62138];
var inst_62206 = (new cljs.core.PersistentVector(null,2,(5),inst_62204,inst_62205,null));
var inst_62207 = cljs.core.assoc_in(inst_62127,inst_62206,inst_62160);
var state_62226__$1 = state_62226;
var statearr_62234_62310 = state_62226__$1;
(statearr_62234_62310[(2)] = inst_62207);

(statearr_62234_62310[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (4))){
var inst_62086 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62235_62311 = state_62226__$1;
(statearr_62235_62311[(2)] = inst_62086);

(statearr_62235_62311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (15))){
var inst_62125 = (state_62226[(12)]);
var inst_62160 = (state_62226[(9)]);
var inst_62163 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62160);
var inst_62164 = (inst_62125 == null);
var state_62226__$1 = (function (){var statearr_62236 = state_62226;
(statearr_62236[(13)] = inst_62163);

return statearr_62236;
})();
if(cljs.core.truth_(inst_62164)){
var statearr_62237_62312 = state_62226__$1;
(statearr_62237_62312[(1)] = (18));

} else {
var statearr_62238_62313 = state_62226__$1;
(statearr_62238_62313[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (21))){
var inst_62163 = (state_62226[(13)]);
var state_62226__$1 = state_62226;
var statearr_62239_62314 = state_62226__$1;
(statearr_62239_62314[(2)] = inst_62163);

(statearr_62239_62314[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (31))){
var state_62226__$1 = state_62226;
var statearr_62240_62315 = state_62226__$1;
(statearr_62240_62315[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (32))){
var inst_62189 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62242_62316 = state_62226__$1;
(statearr_62242_62316[(2)] = inst_62189);

(statearr_62242_62316[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (40))){
var inst_62158 = (state_62226[(14)]);
var state_62226__$1 = state_62226;
if(cljs.core.truth_(inst_62158)){
var statearr_62243_62317 = state_62226__$1;
(statearr_62243_62317[(1)] = (42));

} else {
var statearr_62244_62318 = state_62226__$1;
(statearr_62244_62318[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (33))){
var inst_62125 = (state_62226[(12)]);
var inst_62163 = (state_62226[(13)]);
var inst_62184 = ((inst_62163 > inst_62125) ? inst_62163 : inst_62125);
var state_62226__$1 = state_62226;
var statearr_62245_62319 = state_62226__$1;
(statearr_62245_62319[(2)] = inst_62184);

(statearr_62245_62319[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (13))){
var inst_62149 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62246_62320 = state_62226__$1;
(statearr_62246_62320[(2)] = inst_62149);

(statearr_62246_62320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (22))){
var inst_62163 = (state_62226[(13)]);
var inst_62170 = (state_62226[(8)]);
var inst_62170__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62163);
var state_62226__$1 = (function (){var statearr_62247 = state_62226;
(statearr_62247[(8)] = inst_62170__$1);

return statearr_62247;
})();
if(inst_62170__$1){
var statearr_62248_62321 = state_62226__$1;
(statearr_62248_62321[(1)] = (24));

} else {
var statearr_62249_62322 = state_62226__$1;
(statearr_62249_62322[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (36))){
var inst_62160 = (state_62226[(9)]);
var inst_62126 = (state_62226[(15)]);
var inst_62198 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62160,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_62199 = (inst_62126 + inst_62198);
var state_62226__$1 = state_62226;
var statearr_62250_62323 = state_62226__$1;
(statearr_62250_62323[(2)] = inst_62199);

(statearr_62250_62323[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (41))){
var inst_62137 = (state_62226[(16)]);
var inst_62196 = (state_62226[(17)]);
var inst_62202 = (state_62226[(18)]);
var inst_62216 = (state_62226[(2)]);
var inst_62124 = inst_62137;
var inst_62125 = inst_62196;
var inst_62126 = inst_62202;
var inst_62127 = inst_62216;
var state_62226__$1 = (function (){var statearr_62251 = state_62226;
(statearr_62251[(12)] = inst_62125);

(statearr_62251[(19)] = inst_62124);

(statearr_62251[(15)] = inst_62126);

(statearr_62251[(10)] = inst_62127);

return statearr_62251;
})();
var statearr_62252_62324 = state_62226__$1;
(statearr_62252_62324[(2)] = null);

(statearr_62252_62324[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (43))){
var inst_62160 = (state_62226[(9)]);
var state_62226__$1 = state_62226;
var statearr_62253_62325 = state_62226__$1;
(statearr_62253_62325[(2)] = inst_62160);

(statearr_62253_62325[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (29))){
var inst_62178 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62254_62326 = state_62226__$1;
(statearr_62254_62326[(2)] = inst_62178);

(statearr_62254_62326[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (44))){
var inst_62127 = (state_62226[(10)]);
var inst_62138 = (state_62226[(11)]);
var inst_62213 = (state_62226[(2)]);
var inst_62214 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62127,inst_62138,inst_62213);
var state_62226__$1 = state_62226;
var statearr_62255_62327 = state_62226__$1;
(statearr_62255_62327[(2)] = inst_62214);

(statearr_62255_62327[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (6))){
var inst_62139 = (state_62226[(20)]);
var inst_62124 = (state_62226[(19)]);
var inst_62135 = cljs.core.seq(inst_62124);
var inst_62136 = cljs.core.first(inst_62135);
var inst_62137 = cljs.core.next(inst_62135);
var inst_62138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62136,(0),null);
var inst_62139__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62136,(1),null);
var inst_62140 = (inst_62139__$1 == null);
var state_62226__$1 = (function (){var statearr_62256 = state_62226;
(statearr_62256[(16)] = inst_62137);

(statearr_62256[(20)] = inst_62139__$1);

(statearr_62256[(11)] = inst_62138);

return statearr_62256;
})();
if(cljs.core.truth_(inst_62140)){
var statearr_62257_62328 = state_62226__$1;
(statearr_62257_62328[(1)] = (8));

} else {
var statearr_62258_62329 = state_62226__$1;
(statearr_62258_62329[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (28))){
var inst_62125 = (state_62226[(12)]);
var inst_62176 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_62125);
var state_62226__$1 = state_62226;
var statearr_62259_62330 = state_62226__$1;
(statearr_62259_62330[(2)] = inst_62176);

(statearr_62259_62330[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (25))){
var inst_62125 = (state_62226[(12)]);
var inst_62173 = (state_62226[(7)]);
var inst_62173__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62125);
var state_62226__$1 = (function (){var statearr_62260 = state_62226;
(statearr_62260[(7)] = inst_62173__$1);

return statearr_62260;
})();
if(inst_62173__$1){
var statearr_62261_62331 = state_62226__$1;
(statearr_62261_62331[(1)] = (27));

} else {
var statearr_62262_62332 = state_62226__$1;
(statearr_62262_62332[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (34))){
var state_62226__$1 = state_62226;
var statearr_62263_62333 = state_62226__$1;
(statearr_62263_62333[(2)] = null);

(statearr_62263_62333[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (17))){
var inst_62157 = (state_62226[(21)]);
var inst_62196 = (state_62226[(2)]);
var state_62226__$1 = (function (){var statearr_62264 = state_62226;
(statearr_62264[(17)] = inst_62196);

return statearr_62264;
})();
if(cljs.core.truth_(inst_62157)){
var statearr_62265_62334 = state_62226__$1;
(statearr_62265_62334[(1)] = (36));

} else {
var statearr_62266_62335 = state_62226__$1;
(statearr_62266_62335[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (3))){
var inst_62224 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62226__$1,inst_62224);
} else {
if((state_val_62227 === (12))){
var inst_62127 = (state_62226[(10)]);
var state_62226__$1 = state_62226;
var statearr_62267_62336 = state_62226__$1;
(statearr_62267_62336[(2)] = inst_62127);

(statearr_62267_62336[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (2))){
var inst_62100 = (state_62226[(22)]);
var inst_62101 = (state_62226[(23)]);
var inst_62096 = (state_62226[(24)]);
var _ = (function (){var statearr_62268 = state_62226;
(statearr_62268[(4)] = cljs.core.cons((5),(state_62226[(4)])));

return statearr_62268;
})();
var inst_62092 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_62093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62094 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_62095 = (new cljs.core.PersistentVector(null,2,(5),inst_62093,inst_62094,null));
var inst_62096__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_62095);
var inst_62097 = (function (){var global_block = inst_62092;
var global_meta_QMARK_ = inst_62096__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_62098 = cljs.core.PersistentHashMap.EMPTY;
var inst_62099 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_62100__$1 = cljs.core.reduce_kv(inst_62097,inst_62098,inst_62099);
var inst_62101__$1 = fluree.db.util.core.current_time_millis();
var inst_62103 = (function (){var global_block = inst_62092;
var global_meta_QMARK_ = inst_62096__$1;
var queries = inst_62100__$1;
var start_time = inst_62101__$1;
return (function (p__62102){
var vec__62269 = p__62102;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62269,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62269,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_62104 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_62103,inst_62100__$1);
var inst_62118 = cljs.core.seq(inst_62104);
var inst_62119 = cljs.core.first(inst_62118);
var inst_62120 = cljs.core.next(inst_62118);
var inst_62121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62119,(0),null);
var inst_62122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62119,(1),null);
var inst_62123 = cljs.core.PersistentHashMap.EMPTY;
var inst_62124 = inst_62104;
var inst_62125 = null;
var inst_62126 = (0);
var inst_62127 = inst_62123;
var state_62226__$1 = (function (){var statearr_62272 = state_62226;
(statearr_62272[(12)] = inst_62125);

(statearr_62272[(25)] = inst_62120);

(statearr_62272[(26)] = inst_62122);

(statearr_62272[(27)] = inst_62121);

(statearr_62272[(19)] = inst_62124);

(statearr_62272[(22)] = inst_62100__$1);

(statearr_62272[(15)] = inst_62126);

(statearr_62272[(23)] = inst_62101__$1);

(statearr_62272[(10)] = inst_62127);

(statearr_62272[(24)] = inst_62096__$1);

return statearr_62272;
})();
var statearr_62273_62337 = state_62226__$1;
(statearr_62273_62337[(2)] = null);

(statearr_62273_62337[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (23))){
var inst_62191 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62274_62338 = state_62226__$1;
(statearr_62274_62338[(2)] = inst_62191);

(statearr_62274_62338[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (35))){
var inst_62187 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62275_62339 = state_62226__$1;
(statearr_62275_62339[(2)] = inst_62187);

(statearr_62275_62339[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (19))){
var inst_62125 = (state_62226[(12)]);
var inst_62163 = (state_62226[(13)]);
var inst_62167 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62125,inst_62163);
var state_62226__$1 = state_62226;
if(inst_62167){
var statearr_62276_62340 = state_62226__$1;
(statearr_62276_62340[(1)] = (21));

} else {
var statearr_62277_62341 = state_62226__$1;
(statearr_62277_62341[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (11))){
var inst_62125 = (state_62226[(12)]);
var inst_62126 = (state_62226[(15)]);
var inst_62101 = (state_62226[(23)]);
var inst_62127 = (state_62226[(10)]);
var inst_62143 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_62144 = fluree.db.util.core.response_time_formatted(inst_62101);
var inst_62145 = [inst_62127,inst_62126,inst_62125,inst_62144];
var inst_62146 = cljs.core.PersistentHashMap.fromArrays(inst_62143,inst_62145);
var state_62226__$1 = state_62226;
var statearr_62279_62342 = state_62226__$1;
(statearr_62279_62342[(2)] = inst_62146);

(statearr_62279_62342[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (9))){
var inst_62139 = (state_62226[(20)]);
var inst_62100 = (state_62226[(22)]);
var inst_62138 = (state_62226[(11)]);
var inst_62152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62153 = [inst_62138,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_62154 = (new cljs.core.PersistentVector(null,2,(5),inst_62152,inst_62153,null));
var inst_62155 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62100,inst_62154);
var inst_62156 = cljs.core.__destructure_map(inst_62155);
var inst_62157 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62156,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_62158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62156,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_62226__$1 = (function (){var statearr_62280 = state_62226;
(statearr_62280[(21)] = inst_62157);

(statearr_62280[(14)] = inst_62158);

return statearr_62280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62226__$1,(14),inst_62139);
} else {
if((state_val_62227 === (5))){
var _ = (function (){var statearr_62281 = state_62226;
(statearr_62281[(4)] = cljs.core.rest((state_62226[(4)])));

return statearr_62281;
})();
var state_62226__$1 = state_62226;
var ex62278 = (state_62226__$1[(2)]);
var statearr_62282_62343 = state_62226__$1;
(statearr_62282_62343[(5)] = ex62278);


var statearr_62283_62344 = state_62226__$1;
(statearr_62283_62344[(1)] = (4));

(statearr_62283_62344[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (14))){
var inst_62157 = (state_62226[(21)]);
var inst_62160 = (state_62226[(9)]);
var inst_62160__$1 = (state_62226[(2)]);
var inst_62161 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_62160__$1);
var state_62226__$1 = (function (){var statearr_62284 = state_62226;
(statearr_62284[(9)] = inst_62160__$1);

(statearr_62284[(28)] = inst_62161);

return statearr_62284;
})();
if(cljs.core.truth_(inst_62157)){
var statearr_62285_62345 = state_62226__$1;
(statearr_62285_62345[(1)] = (15));

} else {
var statearr_62286_62346 = state_62226__$1;
(statearr_62286_62346[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (26))){
var inst_62180 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
if(cljs.core.truth_(inst_62180)){
var statearr_62287_62347 = state_62226__$1;
(statearr_62287_62347[(1)] = (30));

} else {
var statearr_62288_62348 = state_62226__$1;
(statearr_62288_62348[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (16))){
var state_62226__$1 = state_62226;
var statearr_62289_62349 = state_62226__$1;
(statearr_62289_62349[(2)] = null);

(statearr_62289_62349[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (38))){
var inst_62161 = (state_62226[(28)]);
var inst_62202 = (state_62226[(2)]);
var state_62226__$1 = (function (){var statearr_62290 = state_62226;
(statearr_62290[(18)] = inst_62202);

return statearr_62290;
})();
if(cljs.core.truth_(inst_62161)){
var statearr_62291_62350 = state_62226__$1;
(statearr_62291_62350[(1)] = (39));

} else {
var statearr_62292_62351 = state_62226__$1;
(statearr_62292_62351[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (30))){
var state_62226__$1 = state_62226;
var statearr_62293_62352 = state_62226__$1;
(statearr_62293_62352[(2)] = (207));

(statearr_62293_62352[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (10))){
var inst_62219 = (state_62226[(2)]);
var state_62226__$1 = state_62226;
var statearr_62294_62353 = state_62226__$1;
(statearr_62294_62353[(2)] = inst_62219);

(statearr_62294_62353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (18))){
var inst_62163 = (state_62226[(13)]);
var state_62226__$1 = state_62226;
var statearr_62295_62354 = state_62226__$1;
(statearr_62295_62354[(2)] = inst_62163);

(statearr_62295_62354[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (42))){
var inst_62160 = (state_62226[(9)]);
var inst_62210 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_62160);
var state_62226__$1 = state_62226;
var statearr_62296_62355 = state_62226__$1;
(statearr_62296_62355[(2)] = inst_62210);

(statearr_62296_62355[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (37))){
var state_62226__$1 = state_62226;
var statearr_62297_62356 = state_62226__$1;
(statearr_62297_62356[(2)] = null);

(statearr_62297_62356[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62227 === (8))){
var inst_62096 = (state_62226[(24)]);
var state_62226__$1 = state_62226;
if(cljs.core.truth_(inst_62096)){
var statearr_62298_62357 = state_62226__$1;
(statearr_62298_62357[(1)] = (11));

} else {
var statearr_62299_62358 = state_62226__$1;
(statearr_62299_62358[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_62300 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62300[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__);

(statearr_62300[(1)] = (1));

return statearr_62300;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1 = (function (state_62226){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_62226);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e62301){var ex__2687__auto__ = e62301;
var statearr_62302_62359 = state_62226;
(statearr_62302_62359[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_62226[(4)]))){
var statearr_62303_62360 = state_62226;
(statearr_62303_62360[(1)] = cljs.core.first((state_62226[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62361 = state_62226;
state_62226 = G__62361;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = function(state_62226){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1.call(this,state_62226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_62304 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_62304[(6)] = c__2706__auto__);

return statearr_62304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__62362 = query_type;
var G__62362__$1 = (((G__62362 instanceof cljs.core.Keyword))?G__62362.fqn:null);
switch (G__62362__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62362__$1)].join('')));

}
});
