// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20946){var e = e20946;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20947_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20947_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20947_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20947_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20947_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20948_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20948_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20949_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20949_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20954 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20954,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20954,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20950_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20950_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20957 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20957,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20957,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20951_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20951_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20952_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20952_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20953_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20953_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20960_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__20960_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__20961 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20961) : intersecting_vars.call(null,G__20961));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20964,optional_QMARK_,fuel,max_fuel){
var map__20965 = p__20964;
var map__20965__$1 = cljs.core.__destructure_map(map__20965);
var res = map__20965__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20965__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21031){
var state_val_21032 = (state_21031[(1)]);
if((state_val_21032 === (7))){
var inst_21020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21021 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_21022 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21021,clause);
var inst_21023 = [null,inst_21022];
var inst_21024 = (new cljs.core.PersistentVector(null,2,(5),inst_21020,inst_21023,null));
var state_21031__$1 = state_21031;
var statearr_21033_21061 = state_21031__$1;
(statearr_21033_21061[(2)] = inst_21024);

(statearr_21033_21061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (1))){
var state_21031__$1 = state_21031;
var statearr_21034_21062 = state_21031__$1;
(statearr_21034_21062[(2)] = null);

(statearr_21034_21062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (4))){
var inst_20966 = (state_21031[(2)]);
var state_21031__$1 = state_21031;
var statearr_21035_21063 = state_21031__$1;
(statearr_21035_21063[(2)] = inst_20966);

(statearr_21035_21063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (15))){
var inst_21009 = (state_21031[(2)]);
var inst_21010 = fluree.db.util.async.throw_err(inst_21009);
var inst_21011 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_21010);
var inst_21012 = cljs.core.count(inst_21011);
var inst_21013 = fluree.db.query.analytical.add_fuel(inst_21012,fuel,max_fuel);
var inst_21014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21015 = [inst_21010,r];
var inst_21016 = (new cljs.core.PersistentVector(null,2,(5),inst_21014,inst_21015,null));
var state_21031__$1 = (function (){var statearr_21036 = state_21031;
(statearr_21036[(7)] = inst_21013);

return statearr_21036;
})();
var statearr_21037_21064 = state_21031__$1;
(statearr_21037_21064[(2)] = inst_21016);

(statearr_21037_21064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (13))){
var inst_20975 = (state_21031[(8)]);
var inst_20988 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20989 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20988);
var inst_20990 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20975);
var inst_20991 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20990);
var inst_20992 = cljs.core.set(inst_20991);
var inst_20993 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20989);
var inst_20994 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20993);
var inst_20995 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20992,inst_20994);
var inst_20996 = (function (){var all_wd = inst_20975;
var optional = inst_20989;
var all_wd_vars = inst_20992;
var all_vars = inst_20995;
return (function (p1__20962_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20962_SHARP_) : all_vars.call(null,p1__20962_SHARP_));
});
})();
var inst_20997 = cljs.core.keys(vars);
var inst_20998 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20996,inst_20997);
var inst_20999 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20998);
var inst_21000 = cljs.core.set(inst_20999);
var inst_21001 = (function (){var all_wd = inst_20975;
var optional = inst_20989;
var all_wd_vars = inst_20992;
var all_vars = inst_20995;
var intersecting_vars = inst_21000;
return (function (p1__20963_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20963_SHARP_);
});
})();
var inst_21002 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21001,inst_20975);
var inst_21003 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_21002);
var inst_21004 = fluree.db.query.analytical.select_from_tuples(inst_21003,res);
var inst_21005 = fluree.db.query.analytical.replace_vars_wikidata(inst_20975,inst_21000,vars);
var inst_21006 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_21000,inst_20995);
var inst_21007 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_21005,inst_21003,inst_21004,inst_21006,inst_20989);
var state_21031__$1 = state_21031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21031__$1,(15),inst_21007);
} else {
if((state_val_21032 === (6))){
var inst_20976 = (state_21031[(9)]);
var inst_20974 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20975 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20974);
var inst_20976__$1 = optional_QMARK_;
var state_21031__$1 = (function (){var statearr_21038 = state_21031;
(statearr_21038[(9)] = inst_20976__$1);

(statearr_21038[(8)] = inst_20975);

return statearr_21038;
})();
if(cljs.core.truth_(inst_20976__$1)){
var statearr_21039_21065 = state_21031__$1;
(statearr_21039_21065[(1)] = (9));

} else {
var statearr_21040_21066 = state_21031__$1;
(statearr_21040_21066[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (3))){
var inst_21029 = (state_21031[(2)]);
var state_21031__$1 = state_21031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21031__$1,inst_21029);
} else {
if((state_val_21032 === (12))){
var inst_20984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20985 = [null,r];
var inst_20986 = (new cljs.core.PersistentVector(null,2,(5),inst_20984,inst_20985,null));
var state_21031__$1 = state_21031;
var statearr_21041_21067 = state_21031__$1;
(statearr_21041_21067[(2)] = inst_20986);

(statearr_21041_21067[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (2))){
var _ = (function (){var statearr_21042 = state_21031;
(statearr_21042[(4)] = cljs.core.cons((5),(state_21031[(4)])));

return statearr_21042;
})();
var inst_20972 = (r == null);
var state_21031__$1 = state_21031;
if(cljs.core.truth_(inst_20972)){
var statearr_21043_21068 = state_21031__$1;
(statearr_21043_21068[(1)] = (6));

} else {
var statearr_21044_21069 = state_21031__$1;
(statearr_21044_21069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (11))){
var inst_20982 = (state_21031[(2)]);
var state_21031__$1 = state_21031;
if(cljs.core.truth_(inst_20982)){
var statearr_21046_21070 = state_21031__$1;
(statearr_21046_21070[(1)] = (12));

} else {
var statearr_21047_21071 = state_21031__$1;
(statearr_21047_21071[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (9))){
var inst_20975 = (state_21031[(8)]);
var inst_20978 = cljs.core.empty_QMARK_(inst_20975);
var inst_20979 = (!(inst_20978));
var state_21031__$1 = state_21031;
var statearr_21048_21072 = state_21031__$1;
(statearr_21048_21072[(2)] = inst_20979);

(statearr_21048_21072[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (5))){
var _ = (function (){var statearr_21049 = state_21031;
(statearr_21049[(4)] = cljs.core.rest((state_21031[(4)])));

return statearr_21049;
})();
var state_21031__$1 = state_21031;
var ex21045 = (state_21031__$1[(2)]);
var statearr_21050_21073 = state_21031__$1;
(statearr_21050_21073[(5)] = ex21045);


if((ex21045 instanceof Error)){
var statearr_21051_21074 = state_21031__$1;
(statearr_21051_21074[(1)] = (4));

(statearr_21051_21074[(5)] = null);

} else {
throw ex21045;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (14))){
var inst_21018 = (state_21031[(2)]);
var state_21031__$1 = state_21031;
var statearr_21052_21075 = state_21031__$1;
(statearr_21052_21075[(2)] = inst_21018);

(statearr_21052_21075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (10))){
var inst_20976 = (state_21031[(9)]);
var state_21031__$1 = state_21031;
var statearr_21053_21076 = state_21031__$1;
(statearr_21053_21076[(2)] = inst_20976);

(statearr_21053_21076[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (8))){
var inst_21026 = (state_21031[(2)]);
var _ = (function (){var statearr_21054 = state_21031;
(statearr_21054[(4)] = cljs.core.rest((state_21031[(4)])));

return statearr_21054;
})();
var state_21031__$1 = state_21031;
var statearr_21055_21077 = state_21031__$1;
(statearr_21055_21077[(2)] = inst_21026);

(statearr_21055_21077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_21056 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21056[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__);

(statearr_21056[(1)] = (1));

return statearr_21056;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1 = (function (state_21031){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21031);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21057){var ex__2687__auto__ = e21057;
var statearr_21058_21078 = state_21031;
(statearr_21058_21078[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21031[(4)]))){
var statearr_21059_21079 = state_21031;
(statearr_21059_21079[(1)] = cljs.core.first((state_21031[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21080 = state_21031;
state_21031 = G__21080;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = function(state_21031){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1.call(this,state_21031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21060 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21060[(6)] = c__2706__auto__);

return statearr_21060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__21082 = arguments.length;
switch (G__21082) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21176){
var state_val_21177 = (state_21176[(1)]);
if((state_val_21177 === (7))){
var inst_21089 = (state_21176[(7)]);
var inst_21099 = clojure.string.starts_with_QMARK_(inst_21089,"$fdb");
var state_21176__$1 = state_21176;
if(inst_21099){
var statearr_21178_21227 = state_21176__$1;
(statearr_21178_21227[(1)] = (9));

} else {
var statearr_21179_21228 = state_21176__$1;
(statearr_21179_21228[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (20))){
var state_21176__$1 = state_21176;
var statearr_21180_21229 = state_21176__$1;
(statearr_21180_21229[(2)] = null);

(statearr_21180_21229[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (27))){
var inst_21139 = (state_21176[(8)]);
var state_21176__$1 = state_21176;
var statearr_21181_21230 = state_21176__$1;
(statearr_21181_21230[(2)] = inst_21139);

(statearr_21181_21230[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (1))){
var state_21176__$1 = state_21176;
var statearr_21182_21231 = state_21176__$1;
(statearr_21182_21231[(2)] = null);

(statearr_21182_21231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (24))){
var inst_21162 = (state_21176[(2)]);
var state_21176__$1 = state_21176;
var statearr_21183_21232 = state_21176__$1;
(statearr_21183_21232[(2)] = inst_21162);

(statearr_21183_21232[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (4))){
var inst_21083 = (state_21176[(2)]);
var state_21176__$1 = state_21176;
var statearr_21184_21233 = state_21176__$1;
(statearr_21184_21233[(2)] = inst_21083);

(statearr_21184_21233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (15))){
var inst_21106 = (state_21176[(9)]);
var inst_21112 = (state_21176[(2)]);
var inst_21113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21114 = cljs.core.PersistentVector.EMPTY;
var inst_21115 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_21116 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21114,inst_21115);
var inst_21117 = [inst_21106,inst_21116];
var inst_21118 = (new cljs.core.PersistentVector(null,2,(5),inst_21113,inst_21117,null));
var state_21176__$1 = (function (){var statearr_21185 = state_21176;
(statearr_21185[(10)] = inst_21112);

return statearr_21185;
})();
var statearr_21186_21234 = state_21176__$1;
(statearr_21186_21234[(2)] = inst_21118);

(statearr_21186_21234[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (21))){
var inst_21165 = (state_21176[(2)]);
var state_21176__$1 = state_21176;
var statearr_21187_21235 = state_21176__$1;
(statearr_21187_21235[(2)] = inst_21165);

(statearr_21187_21235[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (13))){
var inst_21106 = (state_21176[(9)]);
var inst_21109 = (function(){throw inst_21106})();
var state_21176__$1 = state_21176;
var statearr_21188_21236 = state_21176__$1;
(statearr_21188_21236[(2)] = inst_21109);

(statearr_21188_21236[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (22))){
var inst_21130 = (state_21176[(11)]);
var inst_21128 = (state_21176[(12)]);
var inst_21132 = fluree.db.query.analytical.parse_block_from_source(inst_21128);
var inst_21133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21134 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_21130];
var inst_21135 = (new cljs.core.PersistentVector(null,2,(5),inst_21133,inst_21134,null));
var inst_21136 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_21135);
var state_21176__$1 = (function (){var statearr_21189 = state_21176;
(statearr_21189[(13)] = inst_21132);

return statearr_21189;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21176__$1,(25),inst_21136);
} else {
if((state_val_21177 === (29))){
var inst_21143 = (state_21176[(2)]);
var inst_21144 = fluree.db.util.async.throw_err(inst_21143);
var state_21176__$1 = state_21176;
var statearr_21190_21237 = state_21176__$1;
(statearr_21190_21237[(2)] = inst_21144);

(statearr_21190_21237[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (6))){
var inst_21092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21093 = cljs.core.PersistentVector.EMPTY;
var inst_21094 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_21095 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21093,inst_21094);
var inst_21096 = [db,inst_21095];
var inst_21097 = (new cljs.core.PersistentVector(null,2,(5),inst_21092,inst_21096,null));
var state_21176__$1 = state_21176;
var statearr_21191_21238 = state_21176__$1;
(statearr_21191_21238[(2)] = inst_21097);

(statearr_21191_21238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (28))){
var inst_21147 = (state_21176[(2)]);
var inst_21148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21149 = cljs.core.PersistentVector.EMPTY;
var inst_21150 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_21151 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21149,inst_21150);
var inst_21152 = [inst_21147,inst_21151];
var inst_21153 = (new cljs.core.PersistentVector(null,2,(5),inst_21148,inst_21152,null));
var state_21176__$1 = state_21176;
var statearr_21192_21239 = state_21176__$1;
(statearr_21192_21239[(2)] = inst_21153);

(statearr_21192_21239[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (25))){
var inst_21132 = (state_21176[(13)]);
var inst_21138 = (state_21176[(2)]);
var inst_21139 = fluree.db.util.async.throw_err(inst_21138);
var state_21176__$1 = (function (){var statearr_21193 = state_21176;
(statearr_21193[(8)] = inst_21139);

return statearr_21193;
})();
if(cljs.core.truth_(inst_21132)){
var statearr_21194_21240 = state_21176__$1;
(statearr_21194_21240[(1)] = (26));

} else {
var statearr_21195_21241 = state_21176__$1;
(statearr_21195_21241[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (17))){
var state_21176__$1 = state_21176;
var statearr_21196_21242 = state_21176__$1;
(statearr_21196_21242[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (3))){
var inst_21174 = (state_21176[(2)]);
var state_21176__$1 = state_21176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21176__$1,inst_21174);
} else {
if((state_val_21177 === (12))){
var inst_21106 = (state_21176[(9)]);
var inst_21105 = (state_21176[(2)]);
var inst_21106__$1 = fluree.db.util.async.throw_err(inst_21105);
var inst_21107 = fluree.db.util.core.exception_QMARK_(inst_21106__$1);
var state_21176__$1 = (function (){var statearr_21198 = state_21176;
(statearr_21198[(9)] = inst_21106__$1);

return statearr_21198;
})();
if(inst_21107){
var statearr_21199_21243 = state_21176__$1;
(statearr_21199_21243[(1)] = (13));

} else {
var statearr_21200_21244 = state_21176__$1;
(statearr_21200_21244[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (2))){
var inst_21089 = (state_21176[(7)]);
var _ = (function (){var statearr_21201 = state_21176;
(statearr_21201[(4)] = cljs.core.cons((5),(state_21176[(4)])));

return statearr_21201;
})();
var inst_21089__$1 = cljs.core.first(clause);
var inst_21090 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_21089__$1);
var state_21176__$1 = (function (){var statearr_21202 = state_21176;
(statearr_21202[(7)] = inst_21089__$1);

return statearr_21202;
})();
if(inst_21090){
var statearr_21203_21245 = state_21176__$1;
(statearr_21203_21245[(1)] = (6));

} else {
var statearr_21204_21246 = state_21176__$1;
(statearr_21204_21246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (23))){
var inst_21089 = (state_21176[(7)]);
var inst_21155 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21089)," is not supported in Fluree"].join('');
var inst_21156 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21157 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21158 = cljs.core.PersistentHashMap.fromArrays(inst_21156,inst_21157);
var inst_21159 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21155,inst_21158);
var inst_21160 = (function(){throw inst_21159})();
var state_21176__$1 = state_21176;
var statearr_21205_21247 = state_21176__$1;
(statearr_21205_21247[(2)] = inst_21160);

(statearr_21205_21247[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (19))){
var inst_21089 = (state_21176[(7)]);
var inst_21130 = (state_21176[(11)]);
var inst_21127 = fluree.db.query.analytical.isolate_source_name(inst_21089);
var inst_21128 = fluree.db.query.analytical.isolate_source_block(inst_21089);
var inst_21129 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_21127);
var inst_21130__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_21129);
var state_21176__$1 = (function (){var statearr_21206 = state_21176;
(statearr_21206[(11)] = inst_21130__$1);

(statearr_21206[(12)] = inst_21128);

return statearr_21206;
})();
if(cljs.core.truth_(inst_21130__$1)){
var statearr_21207_21248 = state_21176__$1;
(statearr_21207_21248[(1)] = (22));

} else {
var statearr_21208_21249 = state_21176__$1;
(statearr_21208_21249[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (11))){
var inst_21169 = (state_21176[(2)]);
var state_21176__$1 = state_21176;
var statearr_21210_21250 = state_21176__$1;
(statearr_21210_21250[(2)] = inst_21169);

(statearr_21210_21250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (9))){
var inst_21089 = (state_21176[(7)]);
var inst_21101 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_21089,(4));
var inst_21102 = fluree.db.query.analytical.parse_block_from_source(inst_21101);
var inst_21103 = fluree.db.time_travel.as_of_block(db,inst_21102);
var state_21176__$1 = state_21176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21176__$1,(12),inst_21103);
} else {
if((state_val_21177 === (5))){
var _ = (function (){var statearr_21211 = state_21176;
(statearr_21211[(4)] = cljs.core.rest((state_21176[(4)])));

return statearr_21211;
})();
var state_21176__$1 = state_21176;
var ex21209 = (state_21176__$1[(2)]);
var statearr_21212_21251 = state_21176__$1;
(statearr_21212_21251[(5)] = ex21209);


if((ex21209 instanceof Error)){
var statearr_21213_21252 = state_21176__$1;
(statearr_21213_21252[(1)] = (4));

(statearr_21213_21252[(5)] = null);

} else {
throw ex21209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (14))){
var state_21176__$1 = state_21176;
var statearr_21214_21253 = state_21176__$1;
(statearr_21214_21253[(2)] = null);

(statearr_21214_21253[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (26))){
var inst_21139 = (state_21176[(8)]);
var inst_21132 = (state_21176[(13)]);
var inst_21141 = fluree.db.time_travel.as_of_block(inst_21139,inst_21132);
var state_21176__$1 = state_21176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21176__$1,(29),inst_21141);
} else {
if((state_val_21177 === (16))){
var inst_21122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21123 = ["$wd",clause];
var inst_21124 = (new cljs.core.PersistentVector(null,2,(5),inst_21122,inst_21123,null));
var state_21176__$1 = state_21176;
var statearr_21215_21254 = state_21176__$1;
(statearr_21215_21254[(2)] = inst_21124);

(statearr_21215_21254[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (10))){
var inst_21089 = (state_21176[(7)]);
var inst_21120 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21089);
var state_21176__$1 = state_21176;
if(inst_21120){
var statearr_21216_21255 = state_21176__$1;
(statearr_21216_21255[(1)] = (16));

} else {
var statearr_21217_21256 = state_21176__$1;
(statearr_21217_21256[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (18))){
var inst_21167 = (state_21176[(2)]);
var state_21176__$1 = state_21176;
var statearr_21218_21257 = state_21176__$1;
(statearr_21218_21257[(2)] = inst_21167);

(statearr_21218_21257[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21177 === (8))){
var inst_21171 = (state_21176[(2)]);
var _ = (function (){var statearr_21219 = state_21176;
(statearr_21219[(4)] = cljs.core.rest((state_21176[(4)])));

return statearr_21219;
})();
var state_21176__$1 = state_21176;
var statearr_21220_21258 = state_21176__$1;
(statearr_21220_21258[(2)] = inst_21171);

(statearr_21220_21258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_21221 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21221[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_21221[(1)] = (1));

return statearr_21221;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_21176){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21176);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21222){var ex__2687__auto__ = e21222;
var statearr_21223_21259 = state_21176;
(statearr_21223_21259[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21176[(4)]))){
var statearr_21224_21260 = state_21176;
(statearr_21224_21260[(1)] = cljs.core.first((state_21176[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21261 = state_21176;
state_21176 = G__21261;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_21176){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_21176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21225 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21225[(6)] = c__2706__auto__);

return statearr_21225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21262){
var vec__21263 = p__21262;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21263,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21263,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21266_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__21266_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__21270 = subjects;
var vec__21271 = G__21270;
var seq__21272 = cljs.core.seq(vec__21271);
var first__21273 = cljs.core.first(seq__21272);
var seq__21272__$1 = cljs.core.next(seq__21272);
var subject = first__21273;
var r = seq__21272__$1;
var acc = expanded_map;
var G__21270__$1 = G__21270;
var acc__$1 = acc;
while(true){
var vec__21277 = G__21270__$1;
var seq__21278 = cljs.core.seq(vec__21277);
var first__21279 = cljs.core.first(seq__21278);
var seq__21278__$1 = cljs.core.next(seq__21278);
var subject__$1 = first__21279;
var r__$1 = seq__21278__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__21280 = r__$1;
var G__21281 = acc__$2;
G__21270__$1 = G__21280;
acc__$1 = G__21281;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__21270__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21277,seq__21278,first__21279,seq__21278__$1,subject__$1,r__$1,acc__$2,G__21270,vec__21271,seq__21272,first__21273,seq__21272__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__21270__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21277,seq__21278,first__21279,seq__21278__$1,subject__$1,r__$1,acc__$2,G__21270,vec__21271,seq__21272,first__21273,seq__21272__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__21270__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21277,seq__21278,first__21279,seq__21278__$1,subject__$1,r__$1,acc__$2,G__21270,vec__21271,seq__21272,first__21273,seq__21272__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__21270__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21277,seq__21278,first__21279,seq__21278__$1,subject__$1,r__$1,acc__$2,G__21270,vec__21271,seq__21272,first__21273,seq__21272__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__21270__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21277,seq__21278,first__21279,seq__21278__$1,subject__$1,r__$1,acc__$2,G__21270,vec__21271,seq__21272,first__21273,seq__21272__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__21270__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21277,seq__21278,first__21279,seq__21278__$1,subject__$1,r__$1,acc__$2,G__21270,vec__21271,seq__21272,first__21273,seq__21272__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__21282 = r__$1;
var G__21283 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__21270__$1 = G__21282;
acc__$1 = G__21283;
continue;
} else {
var G__21284 = subjects;
var G__21285 = acc_STAR_;
G__21270__$1 = G__21284;
acc__$1 = G__21285;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21286_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__21286_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21377){
var state_val_21378 = (state_21377[(1)]);
if((state_val_21378 === (7))){
var state_21377__$1 = state_21377;
var statearr_21379_21425 = state_21377__$1;
(statearr_21379_21425[(2)] = (100));

(statearr_21379_21425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (20))){
var inst_21326 = (state_21377[(7)]);
var state_21377__$1 = state_21377;
var statearr_21380_21426 = state_21377__$1;
(statearr_21380_21426[(2)] = inst_21326);

(statearr_21380_21426[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (1))){
var state_21377__$1 = state_21377;
var statearr_21381_21427 = state_21377__$1;
(statearr_21381_21427[(2)] = null);

(statearr_21381_21427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (24))){
var inst_21364 = (state_21377[(8)]);
var inst_21363 = (state_21377[(9)]);
var inst_21365 = (state_21377[(10)]);
var inst_21298 = (state_21377[(11)]);
var inst_21368 = (function (){var max_depth = inst_21298;
var recur_map__$1 = inst_21364;
var subjects = inst_21363;
var tuples = inst_21365;
return (function (p1__21287_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__21287_SHARP_)],null));
});
})();
var inst_21369 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21368,inst_21365);
var inst_21370 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_21369);
var state_21377__$1 = state_21377;
var statearr_21382_21428 = state_21377__$1;
(statearr_21382_21428[(2)] = inst_21370);

(statearr_21382_21428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (4))){
var inst_21288 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
var statearr_21383_21429 = state_21377__$1;
(statearr_21383_21429[(2)] = inst_21288);

(statearr_21383_21429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (15))){
var inst_21311 = (state_21377[(12)]);
var inst_21322 = cljs.core.PersistentVector.EMPTY;
var inst_21323 = cljs.core.seq(inst_21311);
var inst_21324 = cljs.core.first(inst_21323);
var inst_21325 = cljs.core.next(inst_21323);
var inst_21326 = inst_21322;
var inst_21327 = inst_21311;
var state_21377__$1 = (function (){var statearr_21384 = state_21377;
(statearr_21384[(7)] = inst_21326);

(statearr_21384[(13)] = inst_21327);

(statearr_21384[(14)] = inst_21325);

(statearr_21384[(15)] = inst_21324);

return statearr_21384;
})();
var statearr_21385_21430 = state_21377__$1;
(statearr_21385_21430[(2)] = null);

(statearr_21385_21430[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (21))){
var inst_21347 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
var statearr_21386_21431 = state_21377__$1;
(statearr_21386_21431[(2)] = inst_21347);

(statearr_21386_21431[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (13))){
var inst_21360 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
var statearr_21387_21432 = state_21377__$1;
(statearr_21387_21432[(2)] = inst_21360);

(statearr_21387_21432[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (22))){
var inst_21326 = (state_21377[(7)]);
var inst_21334 = (state_21377[(16)]);
var inst_21341 = (state_21377[(2)]);
var inst_21342 = fluree.db.util.async.throw_err(inst_21341);
var inst_21343 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_21326,inst_21342);
var inst_21326__$1 = inst_21343;
var inst_21327 = inst_21334;
var state_21377__$1 = (function (){var statearr_21388 = state_21377;
(statearr_21388[(7)] = inst_21326__$1);

(statearr_21388[(13)] = inst_21327);

return statearr_21388;
})();
var statearr_21389_21433 = state_21377__$1;
(statearr_21389_21433[(2)] = null);

(statearr_21389_21433[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (6))){
var inst_21294 = (state_21377[(17)]);
var state_21377__$1 = state_21377;
var statearr_21390_21434 = state_21377__$1;
(statearr_21390_21434[(2)] = inst_21294);

(statearr_21390_21434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (25))){
var inst_21372 = (state_21377[(2)]);
var _ = (function (){var statearr_21391 = state_21377;
(statearr_21391[(4)] = cljs.core.rest((state_21377[(4)])));

return statearr_21391;
})();
var state_21377__$1 = state_21377;
var statearr_21392_21435 = state_21377__$1;
(statearr_21392_21435[(2)] = inst_21372);

(statearr_21392_21435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (17))){
var inst_21327 = (state_21377[(13)]);
var inst_21333 = (state_21377[(18)]);
var inst_21332 = cljs.core.seq(inst_21327);
var inst_21333__$1 = cljs.core.first(inst_21332);
var inst_21334 = cljs.core.next(inst_21332);
var state_21377__$1 = (function (){var statearr_21393 = state_21377;
(statearr_21393[(16)] = inst_21334);

(statearr_21393[(18)] = inst_21333__$1);

return statearr_21393;
})();
if(cljs.core.truth_(inst_21333__$1)){
var statearr_21394_21436 = state_21377__$1;
(statearr_21394_21436[(1)] = (19));

} else {
var statearr_21395_21437 = state_21377__$1;
(statearr_21395_21437[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (3))){
var inst_21375 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21377__$1,inst_21375);
} else {
if((state_val_21378 === (12))){
var inst_21311 = (state_21377[(12)]);
var inst_21300 = (state_21377[(19)]);
var inst_21306 = cljs.core.vals(inst_21300);
var inst_21307 = cljs.core.flatten(inst_21306);
var inst_21308 = cljs.core.set(inst_21307);
var inst_21309 = cljs.core.keys(inst_21300);
var inst_21310 = cljs.core.set(inst_21309);
var inst_21311__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_21308,inst_21310);
var inst_21312 = cljs.core.empty_QMARK_(inst_21311__$1);
var state_21377__$1 = (function (){var statearr_21396 = state_21377;
(statearr_21396[(12)] = inst_21311__$1);

return statearr_21396;
})();
if(inst_21312){
var statearr_21397_21438 = state_21377__$1;
(statearr_21397_21438[(1)] = (14));

} else {
var statearr_21398_21439 = state_21377__$1;
(statearr_21398_21439[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (2))){
var inst_21294 = (state_21377[(17)]);
var _ = (function (){var statearr_21399 = state_21377;
(statearr_21399[(4)] = cljs.core.cons((5),(state_21377[(4)])));

return statearr_21399;
})();
var inst_21294__$1 = depth;
var state_21377__$1 = (function (){var statearr_21400 = state_21377;
(statearr_21400[(17)] = inst_21294__$1);

return statearr_21400;
})();
if(cljs.core.truth_(inst_21294__$1)){
var statearr_21401_21440 = state_21377__$1;
(statearr_21401_21440[(1)] = (6));

} else {
var statearr_21402_21441 = state_21377__$1;
(statearr_21402_21441[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (23))){
var inst_21365 = (state_21377[(10)]);
var state_21377__$1 = state_21377;
var statearr_21403_21442 = state_21377__$1;
(statearr_21403_21442[(2)] = inst_21365);

(statearr_21403_21442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (19))){
var inst_21333 = (state_21377[(18)]);
var inst_21336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21337 = [inst_21333,predicate];
var inst_21338 = (new cljs.core.PersistentVector(null,2,(5),inst_21336,inst_21337,null));
var inst_21339 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21338);
var state_21377__$1 = state_21377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21377__$1,(22),inst_21339);
} else {
if((state_val_21378 === (11))){
var inst_21300 = (state_21377[(19)]);
var state_21377__$1 = state_21377;
var statearr_21405_21443 = state_21377__$1;
(statearr_21405_21443[(2)] = inst_21300);

(statearr_21405_21443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (9))){
var inst_21301 = (state_21377[(20)]);
var inst_21298 = (state_21377[(11)]);
var inst_21303 = (inst_21301 >= inst_21298);
var state_21377__$1 = state_21377;
if(cljs.core.truth_(inst_21303)){
var statearr_21406_21444 = state_21377__$1;
(statearr_21406_21444[(1)] = (11));

} else {
var statearr_21407_21445 = state_21377__$1;
(statearr_21407_21445[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (5))){
var _ = (function (){var statearr_21408 = state_21377;
(statearr_21408[(4)] = cljs.core.rest((state_21377[(4)])));

return statearr_21408;
})();
var state_21377__$1 = state_21377;
var ex21404 = (state_21377__$1[(2)]);
var statearr_21409_21446 = state_21377__$1;
(statearr_21409_21446[(5)] = ex21404);


if((ex21404 instanceof Error)){
var statearr_21410_21447 = state_21377__$1;
(statearr_21410_21447[(1)] = (4));

(statearr_21410_21447[(5)] = null);

} else {
throw ex21404;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (14))){
var inst_21300 = (state_21377[(19)]);
var state_21377__$1 = state_21377;
var statearr_21411_21448 = state_21377__$1;
(statearr_21411_21448[(2)] = inst_21300);

(statearr_21411_21448[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (16))){
var inst_21358 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
var statearr_21412_21449 = state_21377__$1;
(statearr_21412_21449[(2)] = inst_21358);

(statearr_21412_21449[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (10))){
var inst_21364 = (state_21377[(8)]);
var inst_21363 = (state_21377[(9)]);
var inst_21362 = (state_21377[(2)]);
var inst_21363__$1 = cljs.core.keys(inst_21362);
var inst_21364__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_21363__$1,inst_21362);
var inst_21365 = fluree.db.query.analytical.recur_map__GT_tuples(inst_21363__$1,inst_21364__$1);
var state_21377__$1 = (function (){var statearr_21413 = state_21377;
(statearr_21413[(8)] = inst_21364__$1);

(statearr_21413[(9)] = inst_21363__$1);

(statearr_21413[(10)] = inst_21365);

return statearr_21413;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_21414_21450 = state_21377__$1;
(statearr_21414_21450[(1)] = (23));

} else {
var statearr_21415_21451 = state_21377__$1;
(statearr_21415_21451[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (18))){
var inst_21301 = (state_21377[(20)]);
var inst_21300 = (state_21377[(19)]);
var inst_21349 = (state_21377[(2)]);
var inst_21350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21351 = [(0),(2)];
var inst_21352 = (new cljs.core.PersistentVector(null,2,(5),inst_21350,inst_21351,null));
var inst_21353 = fluree.db.query.analytical.get_ns_arrays(inst_21352,inst_21349);
var inst_21354 = fluree.db.query.analytical.tuples__GT_map(inst_21300,inst_21353);
var inst_21355 = (inst_21301 + (1));
var inst_21300__$1 = inst_21354;
var inst_21301__$1 = inst_21355;
var state_21377__$1 = (function (){var statearr_21416 = state_21377;
(statearr_21416[(20)] = inst_21301__$1);

(statearr_21416[(19)] = inst_21300__$1);

return statearr_21416;
})();
var statearr_21417_21452 = state_21377__$1;
(statearr_21417_21452[(2)] = null);

(statearr_21417_21452[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (8))){
var inst_21298 = (state_21377[(2)]);
var inst_21299 = recur_map;
var inst_21300 = inst_21299;
var inst_21301 = (1);
var state_21377__$1 = (function (){var statearr_21418 = state_21377;
(statearr_21418[(20)] = inst_21301);

(statearr_21418[(11)] = inst_21298);

(statearr_21418[(19)] = inst_21300);

return statearr_21418;
})();
var statearr_21419_21453 = state_21377__$1;
(statearr_21419_21453[(2)] = null);

(statearr_21419_21453[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_21420 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21420[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__);

(statearr_21420[(1)] = (1));

return statearr_21420;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1 = (function (state_21377){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21377);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21421){var ex__2687__auto__ = e21421;
var statearr_21422_21454 = state_21377;
(statearr_21422_21454[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21377[(4)]))){
var statearr_21423_21455 = state_21377;
(statearr_21423_21455[(1)] = cljs.core.first((state_21377[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21456 = state_21377;
state_21377 = G__21456;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = function(state_21377){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1.call(this,state_21377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21424 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21424[(6)] = c__2706__auto__);

return statearr_21424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__21457,clause,fuel,max_fuel){
var map__21458 = p__21457;
var map__21458__$1 = cljs.core.__destructure_map(map__21458);
var res = map__21458__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21458__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21458__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21458__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21569){
var state_val_21570 = (state_21569[(1)]);
if((state_val_21570 === (7))){
var inst_21475 = (state_21569[(7)]);
var state_21569__$1 = state_21569;
var statearr_21571_21624 = state_21569__$1;
(statearr_21571_21624[(2)] = inst_21475);

(statearr_21571_21624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (20))){
var inst_21503 = (state_21569[(8)]);
var inst_21534 = typeof inst_21503 === 'number';
var state_21569__$1 = state_21569;
if(cljs.core.truth_(inst_21534)){
var statearr_21572_21625 = state_21569__$1;
(statearr_21572_21625[(1)] = (22));

} else {
var statearr_21573_21626 = state_21569__$1;
(statearr_21573_21626[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (27))){
var inst_21549 = (state_21569[(2)]);
var state_21569__$1 = state_21569;
var statearr_21574_21627 = state_21569__$1;
(statearr_21574_21627[(2)] = inst_21549);

(statearr_21574_21627[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (1))){
var state_21569__$1 = state_21569;
var statearr_21575_21628 = state_21569__$1;
(statearr_21575_21628[(2)] = null);

(statearr_21575_21628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (24))){
var inst_21551 = (state_21569[(2)]);
var state_21569__$1 = state_21569;
var statearr_21576_21629 = state_21569__$1;
(statearr_21576_21629[(2)] = inst_21551);

(statearr_21576_21629[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (4))){
var inst_21459 = (state_21569[(2)]);
var state_21569__$1 = state_21569;
var statearr_21577_21630 = state_21569__$1;
(statearr_21577_21630[(2)] = inst_21459);

(statearr_21577_21630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (15))){
var inst_21517 = (state_21569[(2)]);
var inst_21518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_21519 = fluree.db.query.analytical.variable_QMARK_(inst_21518);
var state_21569__$1 = (function (){var statearr_21578 = state_21569;
(statearr_21578[(9)] = inst_21517);

return statearr_21578;
})();
if(cljs.core.truth_(inst_21519)){
var statearr_21579_21631 = state_21569__$1;
(statearr_21579_21631[(1)] = (16));

} else {
var statearr_21580_21632 = state_21569__$1;
(statearr_21580_21632[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (21))){
var inst_21476 = (state_21569[(10)]);
var inst_21505 = (state_21569[(11)]);
var inst_21506 = (state_21569[(12)]);
var inst_21553 = (state_21569[(2)]);
var inst_21554 = fluree.db.query.analytical.tuples__GT_recur(db,inst_21506,inst_21553,inst_21476,inst_21505);
var state_21569__$1 = state_21569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21569__$1,(28),inst_21554);
} else {
if((state_val_21570 === (13))){
var inst_21485 = (state_21569[(13)]);
var inst_21509 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21485)].join('');
var inst_21510 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21511 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21512 = cljs.core.PersistentHashMap.fromArrays(inst_21510,inst_21511);
var inst_21513 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21509,inst_21512);
var inst_21514 = (function(){throw inst_21513})();
var state_21569__$1 = state_21569;
var statearr_21581_21633 = state_21569__$1;
(statearr_21581_21633[(2)] = inst_21514);

(statearr_21581_21633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (22))){
var inst_21503 = (state_21569[(8)]);
var inst_21501 = (state_21569[(14)]);
var inst_21536 = cljs.core.PersistentHashMap.EMPTY;
var inst_21537 = cljs.core.flatten(inst_21501);
var inst_21538 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21536,inst_21503,inst_21537);
var state_21569__$1 = state_21569;
var statearr_21582_21634 = state_21569__$1;
(statearr_21582_21634[(2)] = inst_21538);

(statearr_21582_21634[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (6))){
var inst_21487 = (state_21569[(15)]);
var state_21569__$1 = state_21569;
var statearr_21583_21635 = state_21569__$1;
(statearr_21583_21635[(2)] = inst_21487);

(statearr_21583_21635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (28))){
var inst_21556 = (state_21569[(2)]);
var inst_21557 = fluree.db.util.async.throw_err(inst_21556);
var state_21569__$1 = state_21569;
var statearr_21584_21636 = state_21569__$1;
(statearr_21584_21636[(2)] = inst_21557);

(statearr_21584_21636[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (25))){
var inst_21497 = (state_21569[(16)]);
var inst_21501 = (state_21569[(14)]);
var inst_21542 = cljs.core.PersistentHashMap.EMPTY;
var inst_21543 = cljs.core.first(inst_21497);
var inst_21544 = cljs.core.first(inst_21543);
var inst_21545 = cljs.core.flatten(inst_21501);
var inst_21546 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21542,inst_21544,inst_21545);
var state_21569__$1 = state_21569;
var statearr_21585_21637 = state_21569__$1;
(statearr_21585_21637[(2)] = inst_21546);

(statearr_21585_21637[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (17))){
var inst_21485 = (state_21569[(13)]);
var inst_21522 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21485)].join('');
var inst_21523 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21524 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21525 = cljs.core.PersistentHashMap.fromArrays(inst_21523,inst_21524);
var inst_21526 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21522,inst_21525);
var inst_21527 = (function(){throw inst_21526})();
var state_21569__$1 = state_21569;
var statearr_21586_21638 = state_21569__$1;
(statearr_21586_21638[(2)] = inst_21527);

(statearr_21586_21638[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (3))){
var inst_21567 = (state_21569[(2)]);
var state_21569__$1 = state_21569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21569__$1,inst_21567);
} else {
if((state_val_21570 === (12))){
var inst_21472 = (state_21569[(17)]);
var inst_21560 = (state_21569[(2)]);
var inst_21561 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_21562 = cljs.core.keys(inst_21472);
var inst_21563 = [inst_21562,vars,inst_21560];
var inst_21564 = cljs.core.PersistentHashMap.fromArrays(inst_21561,inst_21563);
var _ = (function (){var statearr_21587 = state_21569;
(statearr_21587[(4)] = cljs.core.rest((state_21569[(4)])));

return statearr_21587;
})();
var state_21569__$1 = state_21569;
var statearr_21588_21639 = state_21569__$1;
(statearr_21588_21639[(2)] = inst_21564);

(statearr_21588_21639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (2))){
var inst_21475 = (state_21569[(7)]);
var inst_21476 = (state_21569[(10)]);
var inst_21487 = (state_21569[(15)]);
var inst_21472 = (state_21569[(17)]);
var _ = (function (){var statearr_21589 = state_21569;
(statearr_21589[(4)] = cljs.core.cons((5),(state_21569[(4)])));

return statearr_21589;
})();
var inst_21469 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_21470 = cljs.core.__destructure_map(inst_21469);
var inst_21471 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21470,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_21472__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21470,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_21473 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21470,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_21474 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_21475__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21473);
var inst_21476__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_21473);
var inst_21478 = (function (){var map__21465 = inst_21470;
var search = inst_21471;
var rel = inst_21472__$1;
var opts = inst_21473;
var common_keys = inst_21474;
var object_fn = inst_21475__$1;
var recur_depth = inst_21476__$1;
return (function (p__21477,common_key){
var vec__21590 = p__21477;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21590,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21590,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__21593 = cljs.core._EQ_;
var expr__21594 = idx_of;
if(cljs.core.truth_((pred__21593.cljs$core$IFn$_invoke$arity$2 ? pred__21593.cljs$core$IFn$_invoke$arity$2((0),expr__21594) : pred__21593.call(null,(0),expr__21594)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__21593.cljs$core$IFn$_invoke$arity$2 ? pred__21593.cljs$core$IFn$_invoke$arity$2((1),expr__21594) : pred__21593.call(null,(1),expr__21594)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__21593.cljs$core$IFn$_invoke$arity$2 ? pred__21593.cljs$core$IFn$_invoke$arity$2((2),expr__21594) : pred__21593.call(null,(2),expr__21594)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__21594)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_21479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21480 = cljs.core.PersistentHashMap.EMPTY;
var inst_21481 = [inst_21480,inst_21471];
var inst_21482 = (new cljs.core.PersistentVector(null,2,(5),inst_21479,inst_21481,null));
var inst_21483 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21478,inst_21482,inst_21474);
var inst_21484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21483,(0),null);
var inst_21485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21483,(1),null);
var inst_21486 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_21487__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21484);
var state_21569__$1 = (function (){var statearr_21596 = state_21569;
(statearr_21596[(7)] = inst_21475__$1);

(statearr_21596[(10)] = inst_21476__$1);

(statearr_21596[(15)] = inst_21487__$1);

(statearr_21596[(18)] = inst_21486);

(statearr_21596[(13)] = inst_21485);

(statearr_21596[(17)] = inst_21472__$1);

return statearr_21596;
})();
if(cljs.core.truth_(inst_21487__$1)){
var statearr_21597_21640 = state_21569__$1;
(statearr_21597_21640[(1)] = (6));

} else {
var statearr_21598_21641 = state_21569__$1;
(statearr_21598_21641[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (23))){
var inst_21503 = (state_21569[(8)]);
var inst_21540 = cljs.core.coll_QMARK_(inst_21503);
var state_21569__$1 = state_21569;
if(inst_21540){
var statearr_21599_21642 = state_21569__$1;
(statearr_21599_21642[(1)] = (25));

} else {
var statearr_21600_21643 = state_21569__$1;
(statearr_21600_21643[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (19))){
var inst_21501 = (state_21569[(14)]);
var inst_21531 = cljs.core.PersistentHashMap.EMPTY;
var inst_21532 = fluree.db.query.analytical.tuples__GT_map(inst_21531,inst_21501);
var state_21569__$1 = state_21569;
var statearr_21601_21644 = state_21569__$1;
(statearr_21601_21644[(2)] = inst_21532);

(statearr_21601_21644[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (11))){
var inst_21501 = (state_21569[(14)]);
var state_21569__$1 = state_21569;
var statearr_21603_21645 = state_21569__$1;
(statearr_21603_21645[(2)] = inst_21501);

(statearr_21603_21645[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (9))){
var inst_21497 = (state_21569[(16)]);
var inst_21476 = (state_21569[(10)]);
var inst_21472 = (state_21569[(17)]);
var inst_21496 = (state_21569[(2)]);
var inst_21497__$1 = fluree.db.util.async.throw_err(inst_21496);
var inst_21498 = cljs.core.count(inst_21497__$1);
var inst_21499 = fluree.db.query.analytical.add_fuel(inst_21498,fuel,max_fuel);
var inst_21500 = cljs.core.vals(inst_21472);
var inst_21501 = fluree.db.query.analytical.get_ns_arrays(inst_21500,inst_21497__$1);
var state_21569__$1 = (function (){var statearr_21604 = state_21569;
(statearr_21604[(16)] = inst_21497__$1);

(statearr_21604[(19)] = inst_21499);

(statearr_21604[(14)] = inst_21501);

return statearr_21604;
})();
if(cljs.core.truth_(inst_21476)){
var statearr_21605_21646 = state_21569__$1;
(statearr_21605_21646[(1)] = (10));

} else {
var statearr_21606_21647 = state_21569__$1;
(statearr_21606_21647[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (5))){
var _ = (function (){var statearr_21607 = state_21569;
(statearr_21607[(4)] = cljs.core.rest((state_21569[(4)])));

return statearr_21607;
})();
var state_21569__$1 = state_21569;
var ex21602 = (state_21569__$1[(2)]);
var statearr_21608_21648 = state_21569__$1;
(statearr_21608_21648[(5)] = ex21602);


if((ex21602 instanceof Error)){
var statearr_21609_21649 = state_21569__$1;
(statearr_21609_21649[(1)] = (4));

(statearr_21609_21649[(5)] = null);

} else {
throw ex21602;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (14))){
var state_21569__$1 = state_21569;
var statearr_21610_21650 = state_21569__$1;
(statearr_21610_21650[(2)] = null);

(statearr_21610_21650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (26))){
var state_21569__$1 = state_21569;
var statearr_21611_21651 = state_21569__$1;
(statearr_21611_21651[(2)] = null);

(statearr_21611_21651[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (16))){
var state_21569__$1 = state_21569;
var statearr_21612_21652 = state_21569__$1;
(statearr_21612_21652[(2)] = null);

(statearr_21612_21652[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (10))){
var inst_21485 = (state_21569[(13)]);
var inst_21506 = (state_21569[(12)]);
var inst_21503 = cljs.core.first(inst_21485);
var inst_21504 = cljs.core.first(clause);
var inst_21505 = fluree.db.query.analytical.variable_QMARK_(inst_21504);
var inst_21506__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_21485,(1));
var inst_21507 = fluree.db.query.analytical.variable_QMARK_(inst_21506__$1);
var state_21569__$1 = (function (){var statearr_21613 = state_21569;
(statearr_21613[(8)] = inst_21503);

(statearr_21613[(11)] = inst_21505);

(statearr_21613[(12)] = inst_21506__$1);

return statearr_21613;
})();
if(cljs.core.truth_(inst_21507)){
var statearr_21614_21653 = state_21569__$1;
(statearr_21614_21653[(1)] = (13));

} else {
var statearr_21615_21654 = state_21569__$1;
(statearr_21615_21654[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (18))){
var inst_21505 = (state_21569[(11)]);
var inst_21529 = (state_21569[(2)]);
var state_21569__$1 = (function (){var statearr_21616 = state_21569;
(statearr_21616[(20)] = inst_21529);

return statearr_21616;
})();
if(cljs.core.truth_(inst_21505)){
var statearr_21617_21655 = state_21569__$1;
(statearr_21617_21655[(1)] = (19));

} else {
var statearr_21618_21656 = state_21569__$1;
(statearr_21618_21656[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21570 === (8))){
var inst_21486 = (state_21569[(18)]);
var inst_21485 = (state_21569[(13)]);
var inst_21491 = (state_21569[(2)]);
var inst_21492 = [inst_21491];
var inst_21493 = cljs.core.PersistentHashMap.fromArrays(inst_21486,inst_21492);
var inst_21494 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_21485,inst_21493);
var state_21569__$1 = state_21569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21569__$1,(9),inst_21494);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_21619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21619[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_21619[(1)] = (1));

return statearr_21619;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_21569){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21569);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21620){var ex__2687__auto__ = e21620;
var statearr_21621_21657 = state_21569;
(statearr_21621_21657[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21569[(4)]))){
var statearr_21622_21658 = state_21569;
(statearr_21622_21658[(1)] = cljs.core.first((state_21569[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21659 = state_21569;
state_21569 = G__21659;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = function(state_21569){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_21569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21623 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21623[(6)] = c__2706__auto__);

return statearr_21623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__21660,res,clause){
var map__21661 = p__21660;
var map__21661__$1 = cljs.core.__destructure_map(map__21661);
var db = map__21661__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21661__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21661__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21661__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21775){
var state_val_21776 = (state_21775[(1)]);
if((state_val_21776 === (7))){
var inst_21670 = (state_21775[(7)]);
var state_21775__$1 = state_21775;
var statearr_21777_21822 = state_21775__$1;
(statearr_21777_21822[(2)] = inst_21670);

(statearr_21777_21822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (20))){
var inst_21670 = (state_21775[(7)]);
var inst_21706 = (state_21775[(8)]);
var inst_21672 = (state_21775[(9)]);
var inst_21704 = (state_21775[(10)]);
var inst_21707 = (state_21775[(11)]);
var inst_21722 = (state_21775[(2)]);
var inst_21723 = (function (){var subject_var = inst_21670;
var object_var = inst_21672;
var partition = inst_21704;
var max_sid = inst_21706;
var min_sid = inst_21707;
var flakes = inst_21722;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_21724 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_21723);
var inst_21725 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_21726 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_21724,inst_21725);
var inst_21727 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21729 = [inst_21670];
var inst_21730 = (new cljs.core.PersistentVector(null,1,(5),inst_21728,inst_21729,null));
var inst_21731 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_21726,inst_21722);
var inst_21732 = cljs.core.PersistentHashMap.EMPTY;
var inst_21733 = [inst_21730,inst_21731,inst_21732];
var inst_21734 = cljs.core.PersistentHashMap.fromArrays(inst_21727,inst_21733);
var state_21775__$1 = state_21775;
var statearr_21778_21823 = state_21775__$1;
(statearr_21778_21823[(2)] = inst_21734);

(statearr_21778_21823[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (27))){
var inst_21672 = (state_21775[(9)]);
var inst_21748 = (state_21775[(2)]);
var inst_21749 = fluree.db.flake.sid__GT_cid(inst_21748);
var inst_21750 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_21749);
var inst_21751 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21753 = [inst_21672];
var inst_21754 = (new cljs.core.PersistentVector(null,1,(5),inst_21752,inst_21753,null));
var inst_21755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21757 = [inst_21750];
var inst_21758 = (new cljs.core.PersistentVector(null,1,(5),inst_21756,inst_21757,null));
var inst_21759 = [inst_21758];
var inst_21760 = (new cljs.core.PersistentVector(null,1,(5),inst_21755,inst_21759,null));
var inst_21761 = cljs.core.PersistentHashMap.EMPTY;
var inst_21762 = [inst_21754,inst_21760,inst_21761];
var inst_21763 = cljs.core.PersistentHashMap.fromArrays(inst_21751,inst_21762);
var state_21775__$1 = state_21775;
var statearr_21779_21824 = state_21775__$1;
(statearr_21779_21824[(2)] = inst_21763);

(statearr_21779_21824[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (1))){
var state_21775__$1 = state_21775;
var statearr_21780_21825 = state_21775__$1;
(statearr_21780_21825[(2)] = null);

(statearr_21780_21825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (24))){
var inst_21766 = (state_21775[(2)]);
var state_21775__$1 = state_21775;
var statearr_21781_21826 = state_21775__$1;
(statearr_21781_21826[(2)] = inst_21766);

(statearr_21781_21826[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (4))){
var inst_21663 = (state_21775[(2)]);
var state_21775__$1 = state_21775;
var statearr_21782_21827 = state_21775__$1;
(statearr_21782_21827[(2)] = inst_21663);

(statearr_21782_21827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (15))){
var inst_21670 = (state_21775[(7)]);
var inst_21672 = (state_21775[(9)]);
var inst_21691 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_21692 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21694 = [inst_21670];
var inst_21695 = (new cljs.core.PersistentVector(null,1,(5),inst_21693,inst_21694,null));
var inst_21696 = (function (){var subject_var = inst_21670;
var object_var = inst_21672;
var min_sid = inst_21691;
var max_sid = (0);
return (function (p1__21662_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__21662_SHARP_);
});
})();
var inst_21697 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_21691,(0));
var inst_21698 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21696,inst_21697);
var inst_21699 = cljs.core.PersistentHashMap.EMPTY;
var inst_21700 = [inst_21695,inst_21698,inst_21699];
var inst_21701 = cljs.core.PersistentHashMap.fromArrays(inst_21692,inst_21700);
var state_21775__$1 = state_21775;
var statearr_21783_21828 = state_21775__$1;
(statearr_21783_21828[(2)] = inst_21701);

(statearr_21783_21828[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (21))){
var inst_21717 = (state_21775[(2)]);
var inst_21718 = fluree.db.util.async.throw_err(inst_21717);
var state_21775__$1 = state_21775;
var statearr_21784_21829 = state_21775__$1;
(statearr_21784_21829[(2)] = inst_21718);

(statearr_21784_21829[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (13))){
var inst_21672 = (state_21775[(9)]);
var state_21775__$1 = state_21775;
if(cljs.core.truth_(inst_21672)){
var statearr_21785_21830 = state_21775__$1;
(statearr_21785_21830[(1)] = (22));

} else {
var statearr_21786_21831 = state_21775__$1;
(statearr_21786_21831[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (22))){
var inst_21739 = (state_21775[(12)]);
var inst_21739__$1 = cljs.core.first(clause);
var inst_21740 = typeof inst_21739__$1 === 'number';
var state_21775__$1 = (function (){var statearr_21787 = state_21775;
(statearr_21787[(12)] = inst_21739__$1);

return statearr_21787;
})();
if(cljs.core.truth_(inst_21740)){
var statearr_21788_21832 = state_21775__$1;
(statearr_21788_21832[(1)] = (25));

} else {
var statearr_21789_21833 = state_21775__$1;
(statearr_21789_21833[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (6))){
var inst_21672 = (state_21775[(9)]);
var state_21775__$1 = state_21775;
var statearr_21790_21834 = state_21775__$1;
(statearr_21790_21834[(2)] = inst_21672);

(statearr_21790_21834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (28))){
var inst_21745 = (state_21775[(2)]);
var inst_21746 = fluree.db.util.async.throw_err(inst_21745);
var state_21775__$1 = state_21775;
var statearr_21791_21835 = state_21775__$1;
(statearr_21791_21835[(2)] = inst_21746);

(statearr_21791_21835[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (25))){
var inst_21739 = (state_21775[(12)]);
var state_21775__$1 = state_21775;
var statearr_21792_21836 = state_21775__$1;
(statearr_21792_21836[(2)] = inst_21739);

(statearr_21792_21836[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (17))){
var inst_21736 = (state_21775[(2)]);
var state_21775__$1 = state_21775;
var statearr_21793_21837 = state_21775__$1;
(statearr_21793_21837[(2)] = inst_21736);

(statearr_21793_21837[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (3))){
var inst_21773 = (state_21775[(2)]);
var state_21775__$1 = state_21775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21775__$1,inst_21773);
} else {
if((state_val_21776 === (12))){
var inst_21685 = ["_tx",null,"_block",null];
var inst_21686 = (new cljs.core.PersistentArrayMap(null,2,inst_21685,null));
var inst_21687 = (new cljs.core.PersistentHashSet(null,inst_21686,null));
var inst_21688 = cljs.core.last(clause);
var inst_21689 = (inst_21687.cljs$core$IFn$_invoke$arity$1 ? inst_21687.cljs$core$IFn$_invoke$arity$1(inst_21688) : inst_21687.call(null,inst_21688));
var state_21775__$1 = state_21775;
if(cljs.core.truth_(inst_21689)){
var statearr_21794_21838 = state_21775__$1;
(statearr_21794_21838[(1)] = (15));

} else {
var statearr_21795_21839 = state_21775__$1;
(statearr_21795_21839[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (2))){
var inst_21670 = (state_21775[(7)]);
var _ = (function (){var statearr_21796 = state_21775;
(statearr_21796[(4)] = cljs.core.cons((5),(state_21775[(4)])));

return statearr_21796;
})();
var inst_21669 = cljs.core.first(clause);
var inst_21670__$1 = fluree.db.query.analytical.variable_QMARK_(inst_21669);
var inst_21671 = cljs.core.last(clause);
var inst_21672 = fluree.db.query.analytical.variable_QMARK_(inst_21671);
var state_21775__$1 = (function (){var statearr_21797 = state_21775;
(statearr_21797[(7)] = inst_21670__$1);

(statearr_21797[(9)] = inst_21672);

return statearr_21797;
})();
if(cljs.core.truth_(inst_21670__$1)){
var statearr_21798_21840 = state_21775__$1;
(statearr_21798_21840[(1)] = (6));

} else {
var statearr_21799_21841 = state_21775__$1;
(statearr_21799_21841[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (23))){
var state_21775__$1 = state_21775;
var statearr_21800_21842 = state_21775__$1;
(statearr_21800_21842[(2)] = null);

(statearr_21800_21842[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (19))){
var inst_21720 = cljs.core.PersistentVector.EMPTY;
var state_21775__$1 = state_21775;
var statearr_21801_21843 = state_21775__$1;
(statearr_21801_21843[(2)] = inst_21720);

(statearr_21801_21843[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (11))){
var inst_21770 = (state_21775[(2)]);
var _ = (function (){var statearr_21803 = state_21775;
(statearr_21803[(4)] = cljs.core.rest((state_21775[(4)])));

return statearr_21803;
})();
var state_21775__$1 = state_21775;
var statearr_21804_21844 = state_21775__$1;
(statearr_21804_21844[(2)] = inst_21770);

(statearr_21804_21844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (9))){
var inst_21678 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21679 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21680 = cljs.core.PersistentHashMap.fromArrays(inst_21678,inst_21679);
var inst_21681 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_21680);
var inst_21682 = (function(){throw inst_21681})();
var state_21775__$1 = state_21775;
var statearr_21805_21845 = state_21775__$1;
(statearr_21805_21845[(2)] = inst_21682);

(statearr_21805_21845[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (5))){
var _ = (function (){var statearr_21806 = state_21775;
(statearr_21806[(4)] = cljs.core.rest((state_21775[(4)])));

return statearr_21806;
})();
var state_21775__$1 = state_21775;
var ex21802 = (state_21775__$1[(2)]);
var statearr_21807_21846 = state_21775__$1;
(statearr_21807_21846[(5)] = ex21802);


if((ex21802 instanceof Error)){
var statearr_21808_21847 = state_21775__$1;
(statearr_21808_21847[(1)] = (4));

(statearr_21808_21847[(5)] = null);

} else {
throw ex21802;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (14))){
var inst_21768 = (state_21775[(2)]);
var state_21775__$1 = state_21775;
var statearr_21809_21848 = state_21775__$1;
(statearr_21809_21848[(2)] = inst_21768);

(statearr_21809_21848[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (26))){
var inst_21739 = (state_21775[(12)]);
var inst_21743 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_21739);
var state_21775__$1 = state_21775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21775__$1,(28),inst_21743);
} else {
if((state_val_21776 === (16))){
var inst_21706 = (state_21775[(8)]);
var inst_21704 = (state_21775[(10)]);
var inst_21703 = cljs.core.last(clause);
var inst_21704__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_21703);
var inst_21705 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_21706__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21705,inst_21704__$1);
var inst_21707 = fluree.db.flake.min_subject_id(inst_21704__$1);
var state_21775__$1 = (function (){var statearr_21810 = state_21775;
(statearr_21810[(8)] = inst_21706__$1);

(statearr_21810[(10)] = inst_21704__$1);

(statearr_21810[(11)] = inst_21707);

return statearr_21810;
})();
if(cljs.core.truth_(inst_21706__$1)){
var statearr_21811_21849 = state_21775__$1;
(statearr_21811_21849[(1)] = (18));

} else {
var statearr_21812_21850 = state_21775__$1;
(statearr_21812_21850[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (10))){
var inst_21670 = (state_21775[(7)]);
var state_21775__$1 = state_21775;
if(cljs.core.truth_(inst_21670)){
var statearr_21813_21851 = state_21775__$1;
(statearr_21813_21851[(1)] = (12));

} else {
var statearr_21814_21852 = state_21775__$1;
(statearr_21814_21852[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21776 === (18))){
var inst_21706 = (state_21775[(8)]);
var inst_21707 = (state_21775[(11)]);
var inst_21709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21710 = [inst_21706];
var inst_21711 = (new cljs.core.PersistentVector(null,1,(5),inst_21709,inst_21710,null));
var inst_21712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21713 = [inst_21707];
var inst_21714 = (new cljs.core.PersistentVector(null,1,(5),inst_21712,inst_21713,null));
var inst_21715 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_21711,cljs.core._LT__EQ_,inst_21714);
var state_21775__$1 = state_21775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21775__$1,(21),inst_21715);
} else {
if((state_val_21776 === (8))){
var inst_21676 = (state_21775[(2)]);
var state_21775__$1 = state_21775;
if(cljs.core.truth_(inst_21676)){
var statearr_21815_21853 = state_21775__$1;
(statearr_21815_21853[(1)] = (9));

} else {
var statearr_21816_21854 = state_21775__$1;
(statearr_21816_21854[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_21817 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21817[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__);

(statearr_21817[(1)] = (1));

return statearr_21817;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1 = (function (state_21775){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21775);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21818){var ex__2687__auto__ = e21818;
var statearr_21819_21855 = state_21775;
(statearr_21819_21855[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21775[(4)]))){
var statearr_21820_21856 = state_21775;
(statearr_21820_21856[(1)] = cljs.core.first((state_21775[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21857 = state_21775;
state_21775 = G__21857;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = function(state_21775){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1.call(this,state_21775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21821 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21821[(6)] = c__2706__auto__);

return statearr_21821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21864 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21864 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21864;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__21865(s__21866){
return (new cljs.core.LazySeq(null,(function (){
var s__21866__$1 = s__21866;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__21866__$1);
if(temp__5804__auto__){
var s__21866__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21866__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__21866__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__21868 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__21867 = (0);
while(true){
if((i__21867 < size__5522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__21867);
var delta = (x - mean);
cljs.core.chunk_append(b__21868,(delta * delta));

var G__21870 = (i__21867 + (1));
i__21867 = G__21870;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21868),fluree$db$query$analytical$variance_$_iter__21865(cljs.core.chunk_rest(s__21866__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21868),null);
}
} else {
var x = cljs.core.first(s__21866__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21865(cljs.core.rest(s__21866__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21869 = variance(coll);
return Math.sqrt(G__21869);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21871 = null;
var G__21871__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21871__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21871 = function(n,coll){
switch(arguments.length){
case 1:
return G__21871__1.call(this,n);
case 2:
return G__21871__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21871.cljs$core$IFn$_invoke$arity$1 = G__21871__1;
G__21871.cljs$core$IFn$_invoke$arity$2 = G__21871__2;
return G__21871;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21872 = null;
var G__21872__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21872__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21872 = function(n,coll){
switch(arguments.length){
case 1:
return G__21872__1.call(this,n);
case 2:
return G__21872__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21872.cljs$core$IFn$_invoke$arity$1 = G__21872__1;
G__21872.cljs$core$IFn$_invoke$arity$2 = G__21872__2;
return G__21872;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21873 = null;
var G__21873__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21873__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21873 = function(n,coll){
switch(arguments.length){
case 1:
return G__21873__1.call(this,n);
case 2:
return G__21873__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21873.cljs$core$IFn$_invoke$arity$1 = G__21873__1;
G__21873.cljs$core$IFn$_invoke$arity$2 = G__21873__2;
return G__21873;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__21874 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21874,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21874,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21874,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21877 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21880 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21880) : agg_fn.call(null,G__21880));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21877,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21877,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21881 = agg;
var map__21881__$1 = cljs.core.__destructure_map(map__21881);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21881__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21881__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21881__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21883 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21883,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21883,(1),null);
var map__21886 = res__$1;
var map__21886__$1 = cljs.core.__destructure_map(map__21886);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21886__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21886__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21882_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21882_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21887_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21887_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21888_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21888_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21889_SHARP_,p2__21890_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21889_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21890_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21891_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21891_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21894,row,b_tuple){
var vec__21895 = p__21894;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21895,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21895,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21892_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21892_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21893_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21893_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21898_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21898_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21899_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21899_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21904 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21906 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21905 = (function (p1__21900_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21900_SHARP_);
});
return fexpr__21905(G__21906);
})()),cljs.core.set(b_idxs));
var fexpr__21903 = (function (p1__21901_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21901_SHARP_);
});
return fexpr__21903(G__21904);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21902_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21902_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21907_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21907_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21908_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21908_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21913 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21915 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21914 = (function (p1__21909_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21909_SHARP_);
});
return fexpr__21914(G__21915);
})()),cljs.core.set(b_idxs));
var fexpr__21912 = (function (p1__21910_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21910_SHARP_);
});
return fexpr__21912(G__21913);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21911_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21911_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21917 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21917,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21917,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21916_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21916_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__21922 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21922,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21922,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21920_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21920_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21921_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21921_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21925,filters,optional_QMARK_){
var map__21926 = p__21925;
var map__21926__$1 = cljs.core.__destructure_map(map__21926);
var tuple_map = map__21926__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21926__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21926__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21926__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21927 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21927,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21927,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21930 = res;
var map__21930__$1 = cljs.core.__destructure_map(map__21930);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21930__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21930__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21986){
var state_val_21987 = (state_21986[(1)]);
if((state_val_21987 === (7))){
var inst_21960 = (state_21986[(7)]);
var inst_21958 = (state_21986[(2)]);
var inst_21959 = fluree.db.util.async.throw_err(inst_21958);
var inst_21960__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21959,(0),null);
var inst_21961 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21959,(1),null);
var inst_21962 = (inst_21960__$1 == null);
var state_21986__$1 = (function (){var statearr_21988 = state_21986;
(statearr_21988[(8)] = inst_21961);

(statearr_21988[(7)] = inst_21960__$1);

return statearr_21988;
})();
if(cljs.core.truth_(inst_21962)){
var statearr_21989_22018 = state_21986__$1;
(statearr_21989_22018[(1)] = (8));

} else {
var statearr_21990_22019 = state_21986__$1;
(statearr_21990_22019[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (1))){
var inst_21938 = optional_clauses;
var inst_21939 = cljs.core.seq(inst_21938);
var inst_21940 = cljs.core.first(inst_21939);
var inst_21941 = cljs.core.next(inst_21939);
var inst_21942 = where_tuples;
var inst_21943 = inst_21938;
var inst_21944 = inst_21942;
var state_21986__$1 = (function (){var statearr_21991 = state_21986;
(statearr_21991[(9)] = inst_21941);

(statearr_21991[(10)] = inst_21943);

(statearr_21991[(11)] = inst_21944);

(statearr_21991[(12)] = inst_21940);

return statearr_21991;
})();
var statearr_21992_22020 = state_21986__$1;
(statearr_21992_22020[(2)] = null);

(statearr_21992_22020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (4))){
var inst_21944 = (state_21986[(11)]);
var inst_21951 = (state_21986[(13)]);
var inst_21950 = (state_21986[(14)]);
var inst_21956 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21944,inst_21950,inst_21951,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21944,inst_21950,inst_21951,true,fuel,max_fuel,opts));
var state_21986__$1 = state_21986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21986__$1,(7),inst_21956);
} else {
if((state_val_21987 === (15))){
var state_21986__$1 = state_21986;
var statearr_21993_22021 = state_21986__$1;
(statearr_21993_22021[(2)] = null);

(statearr_21993_22021[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (13))){
var inst_21977 = (state_21986[(2)]);
var state_21986__$1 = state_21986;
var statearr_21994_22022 = state_21986__$1;
(statearr_21994_22022[(2)] = inst_21977);

(statearr_21994_22022[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (6))){
var inst_21982 = (state_21986[(2)]);
var state_21986__$1 = state_21986;
var statearr_21995_22023 = state_21986__$1;
(statearr_21995_22023[(2)] = inst_21982);

(statearr_21995_22023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (3))){
var inst_21984 = (state_21986[(2)]);
var state_21986__$1 = state_21986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21986__$1,inst_21984);
} else {
if((state_val_21987 === (12))){
var state_21986__$1 = state_21986;
var statearr_21996_22024 = state_21986__$1;
(statearr_21996_22024[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (2))){
var inst_21943 = (state_21986[(10)]);
var inst_21950 = (state_21986[(14)]);
var inst_21949 = cljs.core.seq(inst_21943);
var inst_21950__$1 = cljs.core.first(inst_21949);
var inst_21951 = cljs.core.next(inst_21949);
var state_21986__$1 = (function (){var statearr_21998 = state_21986;
(statearr_21998[(13)] = inst_21951);

(statearr_21998[(14)] = inst_21950__$1);

return statearr_21998;
})();
if(cljs.core.truth_(inst_21950__$1)){
var statearr_21999_22025 = state_21986__$1;
(statearr_21999_22025[(1)] = (4));

} else {
var statearr_22000_22026 = state_21986__$1;
(statearr_22000_22026[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (11))){
var inst_21961 = (state_21986[(8)]);
var inst_21960 = (state_21986[(7)]);
var inst_21943 = inst_21961;
var inst_21944 = inst_21960;
var state_21986__$1 = (function (){var statearr_22001 = state_21986;
(statearr_22001[(10)] = inst_21943);

(statearr_22001[(11)] = inst_21944);

return statearr_22001;
})();
var statearr_22002_22027 = state_21986__$1;
(statearr_22002_22027[(2)] = null);

(statearr_22002_22027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (9))){
var inst_21950 = (state_21986[(14)]);
var inst_21966 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21950);
var state_21986__$1 = state_21986;
if(cljs.core.truth_(inst_21966)){
var statearr_22003_22028 = state_21986__$1;
(statearr_22003_22028[(1)] = (11));

} else {
var statearr_22004_22029 = state_21986__$1;
(statearr_22004_22029[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (5))){
var inst_21944 = (state_21986[(11)]);
var state_21986__$1 = state_21986;
var statearr_22005_22030 = state_21986__$1;
(statearr_22005_22030[(2)] = inst_21944);

(statearr_22005_22030[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (14))){
var inst_21944 = (state_21986[(11)]);
var inst_21961 = (state_21986[(8)]);
var inst_21960 = (state_21986[(7)]);
var inst_21971 = fluree.db.query.analytical.left_outer_join(inst_21944,inst_21960);
var inst_21943 = inst_21961;
var inst_21944__$1 = inst_21971;
var state_21986__$1 = (function (){var statearr_22006 = state_21986;
(statearr_22006[(10)] = inst_21943);

(statearr_22006[(11)] = inst_21944__$1);

return statearr_22006;
})();
var statearr_22007_22031 = state_21986__$1;
(statearr_22007_22031[(2)] = null);

(statearr_22007_22031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (16))){
var inst_21975 = (state_21986[(2)]);
var state_21986__$1 = state_21986;
var statearr_22009_22032 = state_21986__$1;
(statearr_22009_22032[(2)] = inst_21975);

(statearr_22009_22032[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (10))){
var inst_21979 = (state_21986[(2)]);
var state_21986__$1 = state_21986;
var statearr_22010_22033 = state_21986__$1;
(statearr_22010_22033[(2)] = inst_21979);

(statearr_22010_22033[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21987 === (8))){
var inst_21944 = (state_21986[(11)]);
var inst_21961 = (state_21986[(8)]);
var tmp22008 = inst_21944;
var inst_21943 = inst_21961;
var inst_21944__$1 = tmp22008;
var state_21986__$1 = (function (){var statearr_22011 = state_21986;
(statearr_22011[(10)] = inst_21943);

(statearr_22011[(11)] = inst_21944__$1);

return statearr_22011;
})();
var statearr_22012_22034 = state_21986__$1;
(statearr_22012_22034[(2)] = null);

(statearr_22012_22034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0 = (function (){
var statearr_22013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22013[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__);

(statearr_22013[(1)] = (1));

return statearr_22013;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1 = (function (state_21986){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21986);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22014){var ex__2687__auto__ = e22014;
var statearr_22015_22035 = state_21986;
(statearr_22015_22035[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21986[(4)]))){
var statearr_22016_22036 = state_21986;
(statearr_22016_22036[(1)] = cljs.core.first((state_21986[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22037 = state_21986;
state_21986 = G__22037;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = function(state_21986){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1.call(this,state_21986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22017 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22017[(6)] = c__2706__auto__);

return statearr_22017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__22039){
var vec__22040 = p__22039;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22040,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22040,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__22038_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__22038_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__22044,p__22045,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__22046 = p__22044;
var map__22046__$1 = cljs.core.__destructure_map(map__22046);
var q_map = map__22046__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22046__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__22047 = p__22045;
var map__22047__$1 = cljs.core.__destructure_map(map__22047);
var res = map__22047__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22047__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22284){
var state_val_22285 = (state_22284[(1)]);
if((state_val_22285 === (65))){
var inst_22233 = (state_22284[(7)]);
var inst_22234 = (state_22284[(8)]);
var inst_22245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22246 = fluree.db.query.analytical.full_text__GT_tuples(inst_22233,res,inst_22234);
var inst_22247 = [inst_22246,r];
var inst_22248 = (new cljs.core.PersistentVector(null,2,(5),inst_22245,inst_22247,null));
var state_22284__$1 = state_22284;
var statearr_22286_22399 = state_22284__$1;
(statearr_22286_22399[(2)] = inst_22248);

(statearr_22286_22399[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (70))){
var inst_22260 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22287_22400 = state_22284__$1;
(statearr_22287_22400[(2)] = inst_22260);

(statearr_22287_22400[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (62))){
var inst_22234 = (state_22284[(8)]);
var inst_22242 = cljs.core.second(inst_22234);
var inst_22243 = clojure.string.starts_with_QMARK_(inst_22242,"fullText:");
var state_22284__$1 = state_22284;
if(inst_22243){
var statearr_22288_22401 = state_22284__$1;
(statearr_22288_22401[(1)] = (65));

} else {
var statearr_22289_22402 = state_22284__$1;
(statearr_22289_22402[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (7))){
var inst_22153 = (state_22284[(9)]);
var inst_22152 = cljs.core.count(clause);
var inst_22153__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_22152);
var state_22284__$1 = (function (){var statearr_22290 = state_22284;
(statearr_22290[(9)] = inst_22153__$1);

return statearr_22290;
})();
if(inst_22153__$1){
var statearr_22291_22403 = state_22284__$1;
(statearr_22291_22403[(1)] = (31));

} else {
var statearr_22292_22404 = state_22284__$1;
(statearr_22292_22404[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (59))){
var inst_22267 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22293_22405 = state_22284__$1;
(statearr_22293_22405[(2)] = inst_22267);

(statearr_22293_22405[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (20))){
var inst_22116 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22294_22406 = state_22284__$1;
(statearr_22294_22406[(2)] = inst_22116);

(statearr_22294_22406[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (58))){
var state_22284__$1 = state_22284;
var statearr_22295_22407 = state_22284__$1;
(statearr_22295_22407[(2)] = null);

(statearr_22295_22407[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (60))){
var inst_22233 = (state_22284[(7)]);
var inst_22231 = (state_22284[(2)]);
var inst_22232 = fluree.db.util.async.throw_err(inst_22231);
var inst_22233__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22232,(0),null);
var inst_22234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22232,(1),null);
var inst_22235 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_22233__$1);
var state_22284__$1 = (function (){var statearr_22296 = state_22284;
(statearr_22296[(7)] = inst_22233__$1);

(statearr_22296[(8)] = inst_22234);

return statearr_22296;
})();
if(inst_22235){
var statearr_22297_22408 = state_22284__$1;
(statearr_22297_22408[(1)] = (61));

} else {
var statearr_22298_22409 = state_22284__$1;
(statearr_22298_22409[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (27))){
var inst_22146 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22299_22410 = state_22284__$1;
(statearr_22299_22410[(2)] = inst_22146);

(statearr_22299_22410[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (1))){
var state_22284__$1 = state_22284;
var statearr_22300_22411 = state_22284__$1;
(statearr_22300_22411[(2)] = null);

(statearr_22300_22411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (69))){
var state_22284__$1 = state_22284;
var statearr_22301_22412 = state_22284__$1;
(statearr_22301_22412[(2)] = null);

(statearr_22301_22412[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (24))){
var inst_22110 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22302_22413 = state_22284__$1;
(statearr_22302_22413[(2)] = inst_22110);

(statearr_22302_22413[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (55))){
var inst_22216 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22217 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22218 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22219 = cljs.core.PersistentHashMap.fromArrays(inst_22217,inst_22218);
var inst_22220 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_22216,inst_22219);
var inst_22221 = (function(){throw inst_22220})();
var state_22284__$1 = state_22284;
var statearr_22303_22414 = state_22284__$1;
(statearr_22303_22414[(2)] = inst_22221);

(statearr_22303_22414[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (39))){
var inst_22173 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
if(cljs.core.truth_(inst_22173)){
var statearr_22304_22415 = state_22284__$1;
(statearr_22304_22415[(1)] = (40));

} else {
var statearr_22305_22416 = state_22284__$1;
(statearr_22305_22416[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (46))){
var inst_22273 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22306_22417 = state_22284__$1;
(statearr_22306_22417[(2)] = inst_22273);

(statearr_22306_22417[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (4))){
var inst_22048 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22307_22418 = state_22284__$1;
(statearr_22307_22418[(2)] = inst_22048);

(statearr_22307_22418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (54))){
var inst_22209 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22210 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22211 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22212 = cljs.core.PersistentHashMap.fromArrays(inst_22210,inst_22211);
var inst_22213 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_22209,inst_22212);
var inst_22214 = (function(){throw inst_22213})();
var state_22284__$1 = state_22284;
var statearr_22308_22419 = state_22284__$1;
(statearr_22308_22419[(2)] = inst_22214);

(statearr_22308_22419[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (15))){
var inst_22148 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22309_22420 = state_22284__$1;
(statearr_22309_22420[(2)] = inst_22148);

(statearr_22309_22420[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (48))){
var inst_22197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22198 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_22199 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22198);
var inst_22200 = [inst_22199,r];
var inst_22201 = (new cljs.core.PersistentVector(null,2,(5),inst_22197,inst_22200,null));
var state_22284__$1 = state_22284;
var statearr_22310_22421 = state_22284__$1;
(statearr_22310_22421[(2)] = inst_22201);

(statearr_22310_22421[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (50))){
var inst_22271 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22311_22422 = state_22284__$1;
(statearr_22311_22422[(2)] = inst_22271);

(statearr_22311_22422[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (21))){
var inst_22082 = (state_22284[(10)]);
var inst_22093 = (state_22284[(11)]);
var inst_22061 = (state_22284[(12)]);
var inst_22086 = (state_22284[(13)]);
var inst_22094 = (state_22284[(14)]);
var inst_22085 = (state_22284[(15)]);
var inst_22084 = (state_22284[(16)]);
var inst_22087 = (state_22284[(17)]);
var inst_22057 = (state_22284[(18)]);
var inst_22098 = (state_22284[(2)]);
var inst_22099 = fluree.db.util.async.throw_err(inst_22098);
var inst_22100 = (function (){var vec__22079 = inst_22082;
var new_res = inst_22099;
var seq__22090 = inst_22094;
var rest = inst_22094;
var tuples = inst_22087;
var first__22091 = inst_22093;
var seq__22080 = inst_22085;
var expr__22059 = inst_22057;
var G__22078 = inst_22086;
var segment_type = inst_22057;
var pred__22058 = inst_22061;
var vec__22089 = inst_22086;
var clause_group = inst_22093;
var first__22081 = inst_22084;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_22101 = cljs.core.keys(vars);
var inst_22102 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_22100,inst_22099,inst_22101);
var inst_22103 = fluree.db.query.analytical.res_absorb_vars(inst_22102);
var state_22284__$1 = (function (){var statearr_22312 = state_22284;
(statearr_22312[(19)] = inst_22103);

return statearr_22312;
})();
if(cljs.core.truth_(inst_22087)){
var statearr_22313_22423 = state_22284__$1;
(statearr_22313_22423[(1)] = (22));

} else {
var statearr_22314_22424 = state_22284__$1;
(statearr_22314_22424[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (31))){
var inst_22155 = cljs.core.second(clause);
var inst_22156 = clojure.string.starts_with_QMARK_(inst_22155,"fullText:");
var state_22284__$1 = state_22284;
var statearr_22315_22425 = state_22284__$1;
(statearr_22315_22425[(2)] = inst_22156);

(statearr_22315_22425[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (32))){
var inst_22153 = (state_22284[(9)]);
var state_22284__$1 = state_22284;
var statearr_22316_22426 = state_22284__$1;
(statearr_22316_22426[(2)] = inst_22153);

(statearr_22316_22426[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (40))){
var inst_22175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22176 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_22284__$1 = (function (){var statearr_22317 = state_22284;
(statearr_22317[(20)] = inst_22175);

return statearr_22317;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22284__$1,(43),inst_22176);
} else {
if((state_val_22285 === (56))){
var inst_22223 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22318_22427 = state_22284__$1;
(statearr_22318_22427[(2)] = inst_22223);

(statearr_22318_22427[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (33))){
var inst_22159 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
if(cljs.core.truth_(inst_22159)){
var statearr_22319_22428 = state_22284__$1;
(statearr_22319_22428[(1)] = (34));

} else {
var statearr_22320_22429 = state_22284__$1;
(statearr_22320_22429[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (13))){
var inst_22082 = (state_22284[(10)]);
var inst_22082__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22083 = cljs.core.seq(inst_22082__$1);
var inst_22084 = cljs.core.first(inst_22083);
var inst_22085 = cljs.core.next(inst_22083);
var inst_22086 = inst_22082__$1;
var inst_22087 = null;
var state_22284__$1 = (function (){var statearr_22321 = state_22284;
(statearr_22321[(10)] = inst_22082__$1);

(statearr_22321[(13)] = inst_22086);

(statearr_22321[(15)] = inst_22085);

(statearr_22321[(16)] = inst_22084);

(statearr_22321[(17)] = inst_22087);

return statearr_22321;
})();
var statearr_22322_22430 = state_22284__$1;
(statearr_22322_22430[(2)] = null);

(statearr_22322_22430[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (22))){
var inst_22103 = (state_22284[(19)]);
var inst_22094 = (state_22284[(14)]);
var inst_22087 = (state_22284[(17)]);
var inst_22105 = fluree.db.query.union.results(inst_22087,inst_22103);
var inst_22086 = inst_22094;
var inst_22087__$1 = inst_22105;
var state_22284__$1 = (function (){var statearr_22323 = state_22284;
(statearr_22323[(13)] = inst_22086);

(statearr_22323[(17)] = inst_22087__$1);

return statearr_22323;
})();
var statearr_22324_22431 = state_22284__$1;
(statearr_22324_22431[(2)] = null);

(statearr_22324_22431[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (36))){
var inst_22277 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22325_22432 = state_22284__$1;
(statearr_22325_22432[(2)] = inst_22277);

(statearr_22325_22432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (41))){
var inst_22183 = cljs.core.count(clause);
var inst_22184 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_22183);
var state_22284__$1 = state_22284;
if(inst_22184){
var statearr_22326_22433 = state_22284__$1;
(statearr_22326_22433[(1)] = (44));

} else {
var statearr_22327_22434 = state_22284__$1;
(statearr_22327_22434[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (43))){
var inst_22175 = (state_22284[(20)]);
var inst_22178 = (state_22284[(2)]);
var inst_22179 = fluree.db.util.async.throw_err(inst_22178);
var inst_22180 = [inst_22179,r];
var inst_22181 = (new cljs.core.PersistentVector(null,2,(5),inst_22175,inst_22180,null));
var state_22284__$1 = state_22284;
var statearr_22328_22435 = state_22284__$1;
(statearr_22328_22435[(2)] = inst_22181);

(statearr_22328_22435[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (61))){
var inst_22234 = (state_22284[(8)]);
var inst_22237 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_22234,r,res,optional_QMARK_,fuel,max_fuel);
var state_22284__$1 = state_22284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22284__$1,(64),inst_22237);
} else {
if((state_val_22285 === (29))){
var inst_22057 = (state_22284[(18)]);
var inst_22140 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_22057)].join('');
var inst_22141 = (new Error(inst_22140));
var inst_22142 = (function(){throw inst_22141})();
var state_22284__$1 = state_22284;
var statearr_22329_22436 = state_22284__$1;
(statearr_22329_22436[(2)] = inst_22142);

(statearr_22329_22436[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (44))){
var inst_22186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22187 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_22284__$1 = (function (){var statearr_22330 = state_22284;
(statearr_22330[(21)] = inst_22186);

return statearr_22330;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22284__$1,(47),inst_22187);
} else {
if((state_val_22285 === (6))){
var inst_22061 = (state_22284[(12)]);
var inst_22057 = (state_22284[(18)]);
var inst_22056 = cljs.core.keys(clause);
var inst_22057__$1 = cljs.core.first(inst_22056);
var inst_22061__$1 = cljs.core._EQ_;
var inst_22062 = (function (){var G__22331 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__22332 = inst_22057__$1;
return (inst_22061__$1.cljs$core$IFn$_invoke$arity$2 ? inst_22061__$1.cljs$core$IFn$_invoke$arity$2(G__22331,G__22332) : inst_22061__$1.call(null,G__22331,G__22332));
})();
var state_22284__$1 = (function (){var statearr_22333 = state_22284;
(statearr_22333[(12)] = inst_22061__$1);

(statearr_22333[(18)] = inst_22057__$1);

return statearr_22333;
})();
if(cljs.core.truth_(inst_22062)){
var statearr_22334_22437 = state_22284__$1;
(statearr_22334_22437[(1)] = (9));

} else {
var statearr_22335_22438 = state_22284__$1;
(statearr_22335_22438[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (28))){
var inst_22134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22135 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22136 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_22135,optional_QMARK_);
var inst_22137 = [inst_22136,r];
var inst_22138 = (new cljs.core.PersistentVector(null,2,(5),inst_22134,inst_22137,null));
var state_22284__$1 = state_22284;
var statearr_22336_22439 = state_22284__$1;
(statearr_22336_22439[(2)] = inst_22138);

(statearr_22336_22439[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (64))){
var inst_22239 = (state_22284[(2)]);
var inst_22240 = fluree.db.util.async.throw_err(inst_22239);
var state_22284__$1 = state_22284;
var statearr_22337_22440 = state_22284__$1;
(statearr_22337_22440[(2)] = inst_22240);

(statearr_22337_22440[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (51))){
var inst_22206 = cljs.core.first(clause);
var inst_22207 = cljs.core.sequential_QMARK_(inst_22206);
var state_22284__$1 = state_22284;
if(inst_22207){
var statearr_22338_22441 = state_22284__$1;
(statearr_22338_22441[(1)] = (54));

} else {
var statearr_22339_22442 = state_22284__$1;
(statearr_22339_22442[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (25))){
var inst_22061 = (state_22284[(12)]);
var inst_22057 = (state_22284[(18)]);
var inst_22122 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22123 = (function (){var segment_type = inst_22057;
var pred__22058 = inst_22061;
var expr__22059 = inst_22057;
var bindings = inst_22122;
return (function (p1__22043_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__22043_SHARP_);
});
})();
var inst_22124 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_22123,inst_22122);
var inst_22125 = cljs.core.PersistentHashMap.EMPTY;
var inst_22126 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_22125,inst_22124);
var inst_22127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22128 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22126);
var inst_22129 = [inst_22128,r];
var inst_22130 = (new cljs.core.PersistentVector(null,2,(5),inst_22127,inst_22129,null));
var state_22284__$1 = state_22284;
var statearr_22340_22443 = state_22284__$1;
(statearr_22340_22443[(2)] = inst_22130);

(statearr_22340_22443[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (34))){
var inst_22161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22162 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_22163 = [inst_22162,r];
var inst_22164 = (new cljs.core.PersistentVector(null,2,(5),inst_22161,inst_22163,null));
var state_22284__$1 = state_22284;
var statearr_22341_22444 = state_22284__$1;
(statearr_22341_22444[(2)] = inst_22164);

(statearr_22341_22444[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (17))){
var inst_22118 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22342_22445 = state_22284__$1;
(statearr_22342_22445[(2)] = inst_22118);

(statearr_22342_22445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (3))){
var inst_22282 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22284__$1,inst_22282);
} else {
if((state_val_22285 === (12))){
var inst_22064 = (state_22284[(22)]);
var inst_22068 = (state_22284[(2)]);
var inst_22069 = fluree.db.util.async.throw_err(inst_22068);
var inst_22070 = [inst_22069,r];
var inst_22071 = (new cljs.core.PersistentVector(null,2,(5),inst_22064,inst_22070,null));
var state_22284__$1 = state_22284;
var statearr_22343_22446 = state_22284__$1;
(statearr_22343_22446[(2)] = inst_22071);

(statearr_22343_22446[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (2))){
var _ = (function (){var statearr_22344 = state_22284;
(statearr_22344[(4)] = cljs.core.cons((5),(state_22284[(4)])));

return statearr_22344;
})();
var inst_22054 = cljs.core.map_QMARK_(clause);
var state_22284__$1 = state_22284;
if(inst_22054){
var statearr_22345_22447 = state_22284__$1;
(statearr_22345_22447[(1)] = (6));

} else {
var statearr_22346_22448 = state_22284__$1;
(statearr_22346_22448[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (66))){
var state_22284__$1 = state_22284;
var statearr_22347_22449 = state_22284__$1;
(statearr_22347_22449[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (23))){
var inst_22103 = (state_22284[(19)]);
var inst_22094 = (state_22284[(14)]);
var inst_22086 = inst_22094;
var inst_22087 = inst_22103;
var state_22284__$1 = (function (){var statearr_22349 = state_22284;
(statearr_22349[(13)] = inst_22086);

(statearr_22349[(17)] = inst_22087);

return statearr_22349;
})();
var statearr_22350_22450 = state_22284__$1;
(statearr_22350_22450[(2)] = null);

(statearr_22350_22450[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (47))){
var inst_22186 = (state_22284[(21)]);
var inst_22189 = (state_22284[(2)]);
var inst_22190 = fluree.db.util.async.throw_err(inst_22189);
var inst_22191 = [inst_22190,r];
var inst_22192 = (new cljs.core.PersistentVector(null,2,(5),inst_22186,inst_22191,null));
var state_22284__$1 = state_22284;
var statearr_22351_22451 = state_22284__$1;
(statearr_22351_22451[(2)] = inst_22192);

(statearr_22351_22451[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (35))){
var inst_22167 = (state_22284[(23)]);
var inst_22166 = cljs.core.count(clause);
var inst_22167__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_22166);
var state_22284__$1 = (function (){var statearr_22352 = state_22284;
(statearr_22352[(23)] = inst_22167__$1);

return statearr_22352;
})();
if(inst_22167__$1){
var statearr_22353_22452 = state_22284__$1;
(statearr_22353_22452[(1)] = (37));

} else {
var statearr_22354_22453 = state_22284__$1;
(statearr_22354_22453[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (19))){
var inst_22087 = (state_22284[(17)]);
var inst_22112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22113 = [inst_22087,r];
var inst_22114 = (new cljs.core.PersistentVector(null,2,(5),inst_22112,inst_22113,null));
var state_22284__$1 = state_22284;
var statearr_22355_22454 = state_22284__$1;
(statearr_22355_22454[(2)] = inst_22114);

(statearr_22355_22454[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (57))){
var inst_22229 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_22284__$1 = state_22284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22284__$1,(60),inst_22229);
} else {
if((state_val_22285 === (68))){
var inst_22233 = (state_22284[(7)]);
var inst_22234 = (state_22284[(8)]);
var inst_22251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22252 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_22233,res,inst_22234,fuel,max_fuel);
var state_22284__$1 = (function (){var statearr_22356 = state_22284;
(statearr_22356[(24)] = inst_22251);

return statearr_22356;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22284__$1,(71),inst_22252);
} else {
if((state_val_22285 === (11))){
var inst_22150 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22358_22455 = state_22284__$1;
(statearr_22358_22455[(2)] = inst_22150);

(statearr_22358_22455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (9))){
var inst_22064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22065 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22066 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_22065,res,fuel,max_fuel,opts);
var state_22284__$1 = (function (){var statearr_22359 = state_22284;
(statearr_22359[(22)] = inst_22064);

return statearr_22359;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22284__$1,(12),inst_22066);
} else {
if((state_val_22285 === (5))){
var _ = (function (){var statearr_22360 = state_22284;
(statearr_22360[(4)] = cljs.core.rest((state_22284[(4)])));

return statearr_22360;
})();
var state_22284__$1 = state_22284;
var ex22357 = (state_22284__$1[(2)]);
var statearr_22361_22456 = state_22284__$1;
(statearr_22361_22456[(5)] = ex22357);


if((ex22357 instanceof Error)){
var statearr_22362_22457 = state_22284__$1;
(statearr_22362_22457[(1)] = (4));

(statearr_22362_22457[(5)] = null);

} else {
throw ex22357;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (14))){
var inst_22061 = (state_22284[(12)]);
var inst_22057 = (state_22284[(18)]);
var inst_22120 = (function (){var G__22363 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__22364 = inst_22057;
return (inst_22061.cljs$core$IFn$_invoke$arity$2 ? inst_22061.cljs$core$IFn$_invoke$arity$2(G__22363,G__22364) : inst_22061.call(null,G__22363,G__22364));
})();
var state_22284__$1 = state_22284;
if(cljs.core.truth_(inst_22120)){
var statearr_22365_22458 = state_22284__$1;
(statearr_22365_22458[(1)] = (25));

} else {
var statearr_22366_22459 = state_22284__$1;
(statearr_22366_22459[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (45))){
var inst_22194 = cljs.core.count(clause);
var inst_22195 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_22194);
var state_22284__$1 = state_22284;
if(inst_22195){
var statearr_22367_22460 = state_22284__$1;
(statearr_22367_22460[(1)] = (48));

} else {
var statearr_22368_22461 = state_22284__$1;
(statearr_22368_22461[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (53))){
var inst_22269 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22369_22462 = state_22284__$1;
(statearr_22369_22462[(2)] = inst_22269);

(statearr_22369_22462[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (26))){
var inst_22061 = (state_22284[(12)]);
var inst_22057 = (state_22284[(18)]);
var inst_22132 = (function (){var G__22370 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__22371 = inst_22057;
return (inst_22061.cljs$core$IFn$_invoke$arity$2 ? inst_22061.cljs$core$IFn$_invoke$arity$2(G__22370,G__22371) : inst_22061.call(null,G__22370,G__22371));
})();
var state_22284__$1 = state_22284;
if(cljs.core.truth_(inst_22132)){
var statearr_22372_22463 = state_22284__$1;
(statearr_22372_22463[(1)] = (28));

} else {
var statearr_22373_22464 = state_22284__$1;
(statearr_22373_22464[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (16))){
var inst_22093 = (state_22284[(11)]);
var inst_22086 = (state_22284[(13)]);
var inst_22092 = cljs.core.seq(inst_22086);
var inst_22093__$1 = cljs.core.first(inst_22092);
var inst_22094 = cljs.core.next(inst_22092);
var state_22284__$1 = (function (){var statearr_22374 = state_22284;
(statearr_22374[(11)] = inst_22093__$1);

(statearr_22374[(14)] = inst_22094);

return statearr_22374;
})();
if(cljs.core.truth_(inst_22093__$1)){
var statearr_22375_22465 = state_22284__$1;
(statearr_22375_22465[(1)] = (18));

} else {
var statearr_22376_22466 = state_22284__$1;
(statearr_22376_22466[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (38))){
var inst_22167 = (state_22284[(23)]);
var state_22284__$1 = state_22284;
var statearr_22377_22467 = state_22284__$1;
(statearr_22377_22467[(2)] = inst_22167);

(statearr_22377_22467[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (30))){
var inst_22144 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22378_22468 = state_22284__$1;
(statearr_22378_22468[(2)] = inst_22144);

(statearr_22378_22468[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (10))){
var inst_22061 = (state_22284[(12)]);
var inst_22057 = (state_22284[(18)]);
var inst_22073 = (function (){var G__22379 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__22380 = inst_22057;
return (inst_22061.cljs$core$IFn$_invoke$arity$2 ? inst_22061.cljs$core$IFn$_invoke$arity$2(G__22379,G__22380) : inst_22061.call(null,G__22379,G__22380));
})();
var state_22284__$1 = state_22284;
if(cljs.core.truth_(inst_22073)){
var statearr_22381_22469 = state_22284__$1;
(statearr_22381_22469[(1)] = (13));

} else {
var statearr_22382_22470 = state_22284__$1;
(statearr_22382_22470[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (18))){
var inst_22093 = (state_22284[(11)]);
var inst_22096 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_22093,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_22093,q_map,vars,fuel,max_fuel,opts));
var state_22284__$1 = state_22284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22284__$1,(21),inst_22096);
} else {
if((state_val_22285 === (52))){
var state_22284__$1 = state_22284;
var statearr_22383_22471 = state_22284__$1;
(statearr_22383_22471[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (67))){
var inst_22262 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22385_22472 = state_22284__$1;
(statearr_22385_22472[(2)] = inst_22262);

(statearr_22385_22472[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (71))){
var inst_22251 = (state_22284[(24)]);
var inst_22254 = (state_22284[(2)]);
var inst_22255 = fluree.db.util.async.throw_err(inst_22254);
var inst_22256 = [inst_22255,r];
var inst_22257 = (new cljs.core.PersistentVector(null,2,(5),inst_22251,inst_22256,null));
var state_22284__$1 = state_22284;
var statearr_22386_22473 = state_22284__$1;
(statearr_22386_22473[(2)] = inst_22257);

(statearr_22386_22473[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (42))){
var inst_22275 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22387_22474 = state_22284__$1;
(statearr_22387_22474[(2)] = inst_22275);

(statearr_22387_22474[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (37))){
var inst_22169 = cljs.core.second(clause);
var inst_22170 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22169,"rdf:type");
var state_22284__$1 = state_22284;
var statearr_22388_22475 = state_22284__$1;
(statearr_22388_22475[(2)] = inst_22170);

(statearr_22388_22475[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (63))){
var inst_22264 = (state_22284[(2)]);
var state_22284__$1 = state_22284;
var statearr_22389_22476 = state_22284__$1;
(statearr_22389_22476[(2)] = inst_22264);

(statearr_22389_22476[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (8))){
var inst_22279 = (state_22284[(2)]);
var _ = (function (){var statearr_22390 = state_22284;
(statearr_22390[(4)] = cljs.core.rest((state_22284[(4)])));

return statearr_22390;
})();
var state_22284__$1 = state_22284;
var statearr_22391_22477 = state_22284__$1;
(statearr_22391_22477[(2)] = inst_22279);

(statearr_22391_22477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22285 === (49))){
var inst_22203 = cljs.core.count(clause);
var inst_22204 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_22203);
var state_22284__$1 = state_22284;
if(inst_22204){
var statearr_22392_22478 = state_22284__$1;
(statearr_22392_22478[(1)] = (51));

} else {
var statearr_22393_22479 = state_22284__$1;
(statearr_22393_22479[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_22394 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22394[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_22394[(1)] = (1));

return statearr_22394;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_22284){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22284);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22395){var ex__2687__auto__ = e22395;
var statearr_22396_22480 = state_22284;
(statearr_22396_22480[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22284[(4)]))){
var statearr_22397_22481 = state_22284;
(statearr_22397_22481[(1)] = cljs.core.first((state_22284[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22482 = state_22284;
state_22284 = G__22482;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = function(state_22284){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_22284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22398 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22398[(6)] = c__2706__auto__);

return statearr_22398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__22484 = arguments.length;
switch (G__22484) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22564){
var state_val_22565 = (state_22564[(1)]);
if((state_val_22565 === (7))){
var inst_22559 = (state_22564[(2)]);
var _ = (function (){var statearr_22566 = state_22564;
(statearr_22566[(4)] = cljs.core.rest((state_22564[(4)])));

return statearr_22566;
})();
var state_22564__$1 = state_22564;
var statearr_22567_22615 = state_22564__$1;
(statearr_22567_22615[(2)] = inst_22559);

(statearr_22567_22615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (20))){
var inst_22524 = (state_22564[(7)]);
var inst_22536 = (state_22564[(2)]);
var inst_22506 = inst_22524;
var inst_22507 = inst_22536;
var state_22564__$1 = (function (){var statearr_22568 = state_22564;
(statearr_22568[(8)] = inst_22506);

(statearr_22568[(9)] = inst_22507);

return statearr_22568;
})();
var statearr_22569_22616 = state_22564__$1;
(statearr_22569_22616[(2)] = null);

(statearr_22569_22616[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (1))){
var state_22564__$1 = state_22564;
var statearr_22570_22617 = state_22564__$1;
(statearr_22570_22617[(2)] = null);

(statearr_22570_22617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (24))){
var inst_22523 = (state_22564[(10)]);
var inst_22524 = (state_22564[(7)]);
var inst_22507 = (state_22564[(9)]);
var inst_22544 = fluree.db.query.analytical.inner_join(inst_22507,inst_22523);
var inst_22506 = inst_22524;
var inst_22507__$1 = inst_22544;
var state_22564__$1 = (function (){var statearr_22571 = state_22564;
(statearr_22571[(8)] = inst_22506);

(statearr_22571[(9)] = inst_22507__$1);

return statearr_22571;
})();
var statearr_22572_22618 = state_22564__$1;
(statearr_22572_22618[(2)] = null);

(statearr_22572_22618[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (4))){
var inst_22485 = (state_22564[(2)]);
var state_22564__$1 = state_22564;
var statearr_22574_22619 = state_22564__$1;
(statearr_22574_22619[(2)] = inst_22485);

(statearr_22574_22619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (15))){
var inst_22523 = (state_22564[(10)]);
var state_22564__$1 = state_22564;
if(cljs.core.truth_(inst_22523)){
var statearr_22575_22620 = state_22564__$1;
(statearr_22575_22620[(1)] = (18));

} else {
var statearr_22576_22621 = state_22564__$1;
(statearr_22576_22621[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (21))){
var inst_22524 = (state_22564[(7)]);
var inst_22507 = (state_22564[(9)]);
var tmp22573 = inst_22507;
var inst_22506 = inst_22524;
var inst_22507__$1 = tmp22573;
var state_22564__$1 = (function (){var statearr_22577 = state_22564;
(statearr_22577[(8)] = inst_22506);

(statearr_22577[(9)] = inst_22507__$1);

return statearr_22577;
})();
var statearr_22578_22622 = state_22564__$1;
(statearr_22578_22622[(2)] = null);

(statearr_22578_22622[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (13))){
var inst_22507 = (state_22564[(9)]);
var inst_22530 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_22507,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22531 = cljs.core.empty_QMARK_(inst_22530);
var state_22564__$1 = state_22564;
if(inst_22531){
var statearr_22579_22623 = state_22564__$1;
(statearr_22579_22623[(1)] = (15));

} else {
var statearr_22580_22624 = state_22564__$1;
(statearr_22580_22624[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (22))){
var state_22564__$1 = state_22564;
var statearr_22581_22625 = state_22564__$1;
(statearr_22581_22625[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (6))){
var inst_22506 = (state_22564[(8)]);
var inst_22513 = (state_22564[(11)]);
var inst_22512 = cljs.core.seq(inst_22506);
var inst_22513__$1 = cljs.core.first(inst_22512);
var inst_22514 = cljs.core.next(inst_22512);
var state_22564__$1 = (function (){var statearr_22583 = state_22564;
(statearr_22583[(12)] = inst_22514);

(statearr_22583[(11)] = inst_22513__$1);

return statearr_22583;
})();
if(cljs.core.truth_(inst_22513__$1)){
var statearr_22584_22626 = state_22564__$1;
(statearr_22584_22626[(1)] = (8));

} else {
var statearr_22585_22627 = state_22564__$1;
(statearr_22585_22627[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (25))){
var state_22564__$1 = state_22564;
var statearr_22586_22628 = state_22564__$1;
(statearr_22586_22628[(2)] = null);

(statearr_22586_22628[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (17))){
var inst_22552 = (state_22564[(2)]);
var state_22564__$1 = state_22564;
var statearr_22587_22629 = state_22564__$1;
(statearr_22587_22629[(2)] = inst_22552);

(statearr_22587_22629[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (3))){
var inst_22562 = (state_22564[(2)]);
var state_22564__$1 = state_22564;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22564__$1,inst_22562);
} else {
if((state_val_22565 === (12))){
var inst_22523 = (state_22564[(10)]);
var inst_22524 = (state_22564[(7)]);
var inst_22506 = inst_22524;
var inst_22507 = inst_22523;
var state_22564__$1 = (function (){var statearr_22588 = state_22564;
(statearr_22588[(8)] = inst_22506);

(statearr_22588[(9)] = inst_22507);

return statearr_22588;
})();
var statearr_22589_22630 = state_22564__$1;
(statearr_22589_22630[(2)] = null);

(statearr_22589_22630[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (2))){
var _ = (function (){var statearr_22590 = state_22564;
(statearr_22590[(4)] = cljs.core.cons((5),(state_22564[(4)])));

return statearr_22590;
})();
var inst_22498 = where;
var inst_22499 = cljs.core.seq(inst_22498);
var inst_22500 = cljs.core.first(inst_22499);
var inst_22501 = cljs.core.next(inst_22499);
var inst_22502 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_22503 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_22504 = [inst_22503];
var inst_22505 = cljs.core.PersistentHashMap.fromArrays(inst_22502,inst_22504);
var inst_22506 = inst_22498;
var inst_22507 = inst_22505;
var state_22564__$1 = (function (){var statearr_22591 = state_22564;
(statearr_22591[(8)] = inst_22506);

(statearr_22591[(13)] = inst_22500);

(statearr_22591[(14)] = inst_22501);

(statearr_22591[(9)] = inst_22507);

return statearr_22591;
})();
var statearr_22592_22631 = state_22564__$1;
(statearr_22592_22631[(2)] = null);

(statearr_22592_22631[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (23))){
var inst_22550 = (state_22564[(2)]);
var state_22564__$1 = state_22564;
var statearr_22593_22632 = state_22564__$1;
(statearr_22593_22632[(2)] = inst_22550);

(statearr_22593_22632[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (19))){
var inst_22507 = (state_22564[(9)]);
var state_22564__$1 = state_22564;
var statearr_22594_22633 = state_22564__$1;
(statearr_22594_22633[(2)] = inst_22507);

(statearr_22594_22633[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (11))){
var inst_22513 = (state_22564[(11)]);
var inst_22521 = (state_22564[(2)]);
var inst_22522 = fluree.db.util.async.throw_err(inst_22521);
var inst_22523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22522,(0),null);
var inst_22524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22522,(1),null);
var inst_22525 = cljs.core.count(inst_22513);
var inst_22526 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_22525);
var state_22564__$1 = (function (){var statearr_22596 = state_22564;
(statearr_22596[(10)] = inst_22523);

(statearr_22596[(7)] = inst_22524);

return statearr_22596;
})();
if(inst_22526){
var statearr_22597_22634 = state_22564__$1;
(statearr_22597_22634[(1)] = (12));

} else {
var statearr_22598_22635 = state_22564__$1;
(statearr_22598_22635[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (9))){
var inst_22507 = (state_22564[(9)]);
var state_22564__$1 = state_22564;
var statearr_22599_22636 = state_22564__$1;
(statearr_22599_22636[(2)] = inst_22507);

(statearr_22599_22636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (5))){
var _ = (function (){var statearr_22600 = state_22564;
(statearr_22600[(4)] = cljs.core.rest((state_22564[(4)])));

return statearr_22600;
})();
var state_22564__$1 = state_22564;
var ex22595 = (state_22564__$1[(2)]);
var statearr_22601_22637 = state_22564__$1;
(statearr_22601_22637[(5)] = ex22595);


if((ex22595 instanceof Error)){
var statearr_22602_22638 = state_22564__$1;
(statearr_22602_22638[(1)] = (4));

(statearr_22602_22638[(5)] = null);

} else {
throw ex22595;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (14))){
var inst_22554 = (state_22564[(2)]);
var state_22564__$1 = state_22564;
var statearr_22603_22639 = state_22564__$1;
(statearr_22603_22639[(2)] = inst_22554);

(statearr_22603_22639[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (26))){
var inst_22548 = (state_22564[(2)]);
var state_22564__$1 = state_22564;
var statearr_22604_22640 = state_22564__$1;
(statearr_22604_22640[(2)] = inst_22548);

(statearr_22604_22640[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (16))){
var inst_22523 = (state_22564[(10)]);
var inst_22539 = (inst_22523 == null);
var state_22564__$1 = state_22564;
if(cljs.core.truth_(inst_22539)){
var statearr_22605_22641 = state_22564__$1;
(statearr_22605_22641[(1)] = (21));

} else {
var statearr_22606_22642 = state_22564__$1;
(statearr_22606_22642[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (10))){
var inst_22557 = (state_22564[(2)]);
var state_22564__$1 = state_22564;
var statearr_22607_22643 = state_22564__$1;
(statearr_22607_22643[(2)] = inst_22557);

(statearr_22607_22643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (18))){
var inst_22523 = (state_22564[(10)]);
var state_22564__$1 = state_22564;
var statearr_22608_22644 = state_22564__$1;
(statearr_22608_22644[(2)] = inst_22523);

(statearr_22608_22644[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22565 === (8))){
var inst_22514 = (state_22564[(12)]);
var inst_22513 = (state_22564[(11)]);
var inst_22507 = (state_22564[(9)]);
var inst_22519 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_22507,inst_22513,inst_22514,false,fuel,max_fuel,opts);
var state_22564__$1 = state_22564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22564__$1,(11),inst_22519);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_22609 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22609[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_22609[(1)] = (1));

return statearr_22609;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_22564){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22564);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22610){var ex__2687__auto__ = e22610;
var statearr_22611_22645 = state_22564;
(statearr_22611_22645[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22564[(4)]))){
var statearr_22612_22646 = state_22564;
(statearr_22612_22646[(1)] = cljs.core.first((state_22564[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22647 = state_22564;
state_22564 = G__22647;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_22564){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_22564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22613 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22613[(6)] = c__2706__auto__);

return statearr_22613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22682){
var state_val_22683 = (state_22682[(1)]);
if((state_val_22683 === (7))){
var inst_22659 = (state_22682[(7)]);
var inst_22664 = (state_22682[(8)]);
var inst_22666 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_22659,inst_22664,fuel,max_fuel,opts);
var state_22682__$1 = state_22682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22682__$1,(10),inst_22666);
} else {
if((state_val_22683 === (1))){
var state_22682__$1 = state_22682;
var statearr_22684_22709 = state_22682__$1;
(statearr_22684_22709[(2)] = null);

(statearr_22684_22709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (4))){
var inst_22648 = (state_22682[(2)]);
var state_22682__$1 = state_22682;
var statearr_22685_22710 = state_22682__$1;
(statearr_22685_22710[(2)] = inst_22648);

(statearr_22685_22710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (13))){
var inst_22677 = (state_22682[(2)]);
var _ = (function (){var statearr_22686 = state_22682;
(statearr_22686[(4)] = cljs.core.rest((state_22682[(4)])));

return statearr_22686;
})();
var state_22682__$1 = state_22682;
var statearr_22687_22711 = state_22682__$1;
(statearr_22687_22711[(2)] = inst_22677);

(statearr_22687_22711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (6))){
var inst_22659 = (state_22682[(7)]);
var inst_22663 = (state_22682[(2)]);
var inst_22664 = fluree.db.util.async.throw_err(inst_22663);
var state_22682__$1 = (function (){var statearr_22688 = state_22682;
(statearr_22688[(8)] = inst_22664);

return statearr_22688;
})();
if(cljs.core.truth_(inst_22659)){
var statearr_22689_22712 = state_22682__$1;
(statearr_22689_22712[(1)] = (7));

} else {
var statearr_22690_22713 = state_22682__$1;
(statearr_22690_22713[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (3))){
var inst_22680 = (state_22682[(2)]);
var state_22682__$1 = state_22682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22682__$1,inst_22680);
} else {
if((state_val_22683 === (12))){
var inst_22672 = (state_22682[(9)]);
var state_22682__$1 = state_22682;
var statearr_22691_22714 = state_22682__$1;
(statearr_22691_22714[(2)] = inst_22672);

(statearr_22691_22714[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (2))){
var _ = (function (){var statearr_22692 = state_22682;
(statearr_22692[(4)] = cljs.core.cons((5),(state_22682[(4)])));

return statearr_22692;
})();
var inst_22655 = q_map;
var inst_22656 = cljs.core.__destructure_map(inst_22655);
var inst_22657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22656,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22656,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_22659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22656,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_22660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22656,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_22661 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_22658,q_map,inst_22657,fuel,max_fuel,opts);
var state_22682__$1 = (function (){var statearr_22693 = state_22682;
(statearr_22693[(7)] = inst_22659);

(statearr_22693[(10)] = inst_22660);

return statearr_22693;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22682__$1,(6),inst_22661);
} else {
if((state_val_22683 === (11))){
var inst_22672 = (state_22682[(9)]);
var inst_22660 = (state_22682[(10)]);
var inst_22674 = fluree.db.query.analytical.tuples__GT_filtered(inst_22672,inst_22660,null);
var state_22682__$1 = state_22682;
var statearr_22695_22715 = state_22682__$1;
(statearr_22695_22715[(2)] = inst_22674);

(statearr_22695_22715[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (9))){
var inst_22660 = (state_22682[(10)]);
var inst_22672 = (state_22682[(2)]);
var state_22682__$1 = (function (){var statearr_22696 = state_22682;
(statearr_22696[(9)] = inst_22672);

return statearr_22696;
})();
if(cljs.core.truth_(inst_22660)){
var statearr_22697_22716 = state_22682__$1;
(statearr_22697_22716[(1)] = (11));

} else {
var statearr_22698_22717 = state_22682__$1;
(statearr_22698_22717[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (5))){
var _ = (function (){var statearr_22699 = state_22682;
(statearr_22699[(4)] = cljs.core.rest((state_22682[(4)])));

return statearr_22699;
})();
var state_22682__$1 = state_22682;
var ex22694 = (state_22682__$1[(2)]);
var statearr_22700_22718 = state_22682__$1;
(statearr_22700_22718[(5)] = ex22694);


if((ex22694 instanceof Error)){
var statearr_22701_22719 = state_22682__$1;
(statearr_22701_22719[(1)] = (4));

(statearr_22701_22719[(5)] = null);

} else {
throw ex22694;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (10))){
var inst_22668 = (state_22682[(2)]);
var inst_22669 = fluree.db.util.async.throw_err(inst_22668);
var state_22682__$1 = state_22682;
var statearr_22702_22720 = state_22682__$1;
(statearr_22702_22720[(2)] = inst_22669);

(statearr_22702_22720[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22683 === (8))){
var inst_22664 = (state_22682[(8)]);
var state_22682__$1 = state_22682;
var statearr_22703_22721 = state_22682__$1;
(statearr_22703_22721[(2)] = inst_22664);

(statearr_22703_22721[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2684__auto____0 = (function (){
var statearr_22704 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22704[(0)] = fluree$db$query$analytical$q_$_state_machine__2684__auto__);

(statearr_22704[(1)] = (1));

return statearr_22704;
});
var fluree$db$query$analytical$q_$_state_machine__2684__auto____1 = (function (state_22682){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22682);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22705){var ex__2687__auto__ = e22705;
var statearr_22706_22722 = state_22682;
(statearr_22706_22722[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22682[(4)]))){
var statearr_22707_22723 = state_22682;
(statearr_22707_22723[(1)] = cljs.core.first((state_22682[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22724 = state_22682;
state_22682 = G__22724;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2684__auto__ = function(state_22682){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____1.call(this,state_22682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2684__auto____0;
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22708 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22708[(6)] = c__2706__auto__);

return statearr_22708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
