// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14529 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(5),null);
var G__14532 = idx;
var G__14532__$1 = (((G__14532 instanceof cljs.core.Keyword))?G__14532.fqn:null);
switch (G__14532__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14532__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14534 = idx;
var G__14534__$1 = (((G__14534 instanceof cljs.core.Keyword))?G__14534.fqn:null);
switch (G__14534__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14534__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14536 = idx;
var G__14536__$1 = (((G__14536 instanceof cljs.core.Keyword))?G__14536.fqn:null);
switch (G__14536__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14536__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14539 = arguments.length;
switch (G__14539) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14540 = (function (){var pred__14543 = cljs.core.identical_QMARK_;
var expr__14544 = test;
if(cljs.core.truth_((pred__14543.cljs$core$IFn$_invoke$arity$2 ? pred__14543.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14544) : pred__14543.call(null,cljs.core._EQ_,expr__14544)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14543.cljs$core$IFn$_invoke$arity$2 ? pred__14543.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14544) : pred__14543.call(null,cljs.core._LT_,expr__14544)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14543.cljs$core$IFn$_invoke$arity$2 ? pred__14543.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14544) : pred__14543.call(null,cljs.core._LT__EQ_,expr__14544)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14543.cljs$core$IFn$_invoke$arity$2 ? pred__14543.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14544) : pred__14543.call(null,cljs.core._GT_,expr__14544)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14543.cljs$core$IFn$_invoke$arity$2 ? pred__14543.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14544) : pred__14543.call(null,cljs.core._GT__EQ_,expr__14544)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14544)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14540,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14540,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14540,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14540,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14783){
var state_val_14784 = (state_14783[(1)]);
if((state_val_14784 === (65))){
var inst_14698 = (state_14783[(7)]);
var inst_14754 = (state_14783[(8)]);
var inst_14754__$1 = (state_14783[(2)]);
var inst_14755 = cljs.core.count(inst_14754__$1);
var state_14783__$1 = (function (){var statearr_14785 = state_14783;
(statearr_14785[(9)] = inst_14755);

(statearr_14785[(8)] = inst_14754__$1);

return statearr_14785;
})();
if(cljs.core.truth_(inst_14698)){
var statearr_14786_14923 = state_14783__$1;
(statearr_14786_14923[(1)] = (81));

} else {
var statearr_14787_14924 = state_14783__$1;
(statearr_14787_14924[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (70))){
var inst_14729 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
if(cljs.core.truth_(inst_14729)){
var statearr_14788_14925 = state_14783__$1;
(statearr_14788_14925[(1)] = (71));

} else {
var statearr_14789_14926 = state_14783__$1;
(statearr_14789_14926[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (62))){
var inst_14668 = (state_14783[(10)]);
var inst_14682 = (state_14783[(11)]);
var inst_14697 = (state_14783[(2)]);
var inst_14698 = fluree.db.dbproto._rhs(inst_14682);
var state_14783__$1 = (function (){var statearr_14790 = state_14783;
(statearr_14790[(12)] = inst_14697);

(statearr_14790[(7)] = inst_14698);

return statearr_14790;
})();
if(cljs.core.truth_(inst_14668)){
var statearr_14791_14927 = state_14783__$1;
(statearr_14791_14927[(1)] = (63));

} else {
var statearr_14792_14928 = state_14783__$1;
(statearr_14792_14928[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (74))){
var inst_14722 = (state_14783[(13)]);
var inst_14736 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_14722);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(77),inst_14736);
} else {
if((state_val_14784 === (7))){
var inst_14559 = (state_14783[(14)]);
var state_14783__$1 = state_14783;
var statearr_14793_14929 = state_14783__$1;
(statearr_14793_14929[(2)] = inst_14559);

(statearr_14793_14929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (59))){
var inst_14644 = (state_14783[(15)]);
var inst_14645 = (state_14783[(16)]);
var inst_14689 = (state_14783[(17)]);
var inst_14688 = (state_14783[(2)]);
var inst_14689__$1 = fluree.db.util.async.throw_err(inst_14688);
var inst_14690 = fluree.db.flake.subrange(inst_14689__$1,start_test,inst_14644,end_test,inst_14645);
var inst_14691 = fluree.db.query.range.value_with_nil_pred(idx,inst_14644,inst_14645);
var state_14783__$1 = (function (){var statearr_14794 = state_14783;
(statearr_14794[(17)] = inst_14689__$1);

(statearr_14794[(18)] = inst_14690);

return statearr_14794;
})();
if(inst_14691){
var statearr_14795_14930 = state_14783__$1;
(statearr_14795_14930[(1)] = (60));

} else {
var statearr_14796_14931 = state_14783__$1;
(statearr_14796_14931[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (86))){
var inst_14763 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14797_14932 = state_14783__$1;
(statearr_14797_14932[(2)] = inst_14763);

(statearr_14797_14932[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (20))){
var inst_14560 = (state_14783[(19)]);
var inst_14608 = (state_14783[(20)]);
var inst_14607 = (state_14783[(2)]);
var inst_14608__$1 = (inst_14560 == null);
var state_14783__$1 = (function (){var statearr_14798 = state_14783;
(statearr_14798[(21)] = inst_14607);

(statearr_14798[(20)] = inst_14608__$1);

return statearr_14798;
})();
if(cljs.core.truth_(inst_14608__$1)){
var statearr_14799_14933 = state_14783__$1;
(statearr_14799_14933[(1)] = (22));

} else {
var statearr_14800_14934 = state_14783__$1;
(statearr_14800_14934[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (72))){
var inst_14715 = (state_14783[(22)]);
var inst_14733 = (inst_14715 + (1));
var inst_14734 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14783__$1 = (function (){var statearr_14801 = state_14783;
(statearr_14801[(23)] = inst_14733);

return statearr_14801;
})();
if(cljs.core.truth_(inst_14734)){
var statearr_14802_14935 = state_14783__$1;
(statearr_14802_14935[(1)] = (74));

} else {
var statearr_14803_14936 = state_14783__$1;
(statearr_14803_14936[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (58))){
var inst_14778 = (state_14783[(2)]);
var _ = (function (){var statearr_14804 = state_14783;
(statearr_14804[(4)] = cljs.core.rest((state_14783[(4)])));

return statearr_14804;
})();
var state_14783__$1 = state_14783;
var statearr_14805_14937 = state_14783__$1;
(statearr_14805_14937[(2)] = inst_14778);

(statearr_14805_14937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (60))){
var inst_14644 = (state_14783[(15)]);
var inst_14668 = (state_14783[(10)]);
var inst_14589 = (state_14783[(24)]);
var inst_14662 = (state_14783[(25)]);
var inst_14661 = (state_14783[(26)]);
var inst_14607 = (state_14783[(21)]);
var inst_14562 = (state_14783[(27)]);
var inst_14643 = (state_14783[(28)]);
var inst_14565 = (state_14783[(29)]);
var inst_14650 = (state_14783[(30)]);
var inst_14558 = (state_14783[(31)]);
var inst_14683 = (state_14783[(32)]);
var inst_14634 = (state_14783[(33)]);
var inst_14684 = (state_14783[(34)]);
var inst_14645 = (state_14783[(16)]);
var inst_14672 = (state_14783[(35)]);
var inst_14677 = (state_14783[(36)]);
var inst_14563 = (state_14783[(37)]);
var inst_14689 = (state_14783[(17)]);
var inst_14682 = (state_14783[(11)]);
var inst_14625 = (state_14783[(38)]);
var inst_14690 = (state_14783[(18)]);
var inst_14651 = (state_14783[(39)]);
var inst_14616 = (state_14783[(40)]);
var inst_14655 = (state_14783[(41)]);
var inst_14580 = (state_14783[(42)]);
var inst_14598 = (state_14783[(43)]);
var inst_14569 = (state_14783[(44)]);
var inst_14570 = (state_14783[(45)]);
var inst_14693 = (function (){var no_filter_QMARK_ = inst_14668;
var vec__14555 = inst_14565;
var next_node = inst_14682;
var flakes = inst_14689;
var s1 = inst_14580;
var o2 = inst_14607;
var t1 = inst_14562;
var i = inst_14683;
var m1 = inst_14634;
var root_node = inst_14677;
var to_t = inst_14662;
var s2 = inst_14589;
var p2 = inst_14625;
var permissions = inst_14651;
var vec__14552 = inst_14558;
var limit = inst_14650;
var start_flake = inst_14644;
var acc = inst_14684;
var t2 = inst_14569;
var op1 = inst_14563;
var o1 = inst_14598;
var end_flake = inst_14645;
var base_result = inst_14690;
var p1 = inst_14616;
var idx_compare = inst_14655;
var op2 = inst_14570;
var from_t = inst_14661;
var m2 = inst_14643;
var novelty = inst_14672;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_14694 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_14693,inst_14690,inst_14690);
var state_14783__$1 = state_14783;
var statearr_14806_14938 = state_14783__$1;
(statearr_14806_14938[(2)] = inst_14694);

(statearr_14806_14938[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (27))){
var inst_14617 = (state_14783[(46)]);
var inst_14567 = (state_14783[(47)]);
var inst_14616 = (state_14783[(2)]);
var inst_14617__$1 = (inst_14567 == null);
var state_14783__$1 = (function (){var statearr_14807 = state_14783;
(statearr_14807[(46)] = inst_14617__$1);

(statearr_14807[(40)] = inst_14616);

return statearr_14807;
})();
if(cljs.core.truth_(inst_14617__$1)){
var statearr_14808_14939 = state_14783__$1;
(statearr_14808_14939[(1)] = (28));

} else {
var statearr_14809_14940 = state_14783__$1;
(statearr_14809_14940[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (1))){
var state_14783__$1 = state_14783;
var statearr_14810_14941 = state_14783__$1;
(statearr_14810_14941[(2)] = null);

(statearr_14810_14941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (69))){
var inst_14650 = (state_14783[(30)]);
var inst_14715 = (state_14783[(22)]);
var inst_14727 = (inst_14715 > inst_14650);
var state_14783__$1 = state_14783;
var statearr_14811_14942 = state_14783__$1;
(statearr_14811_14942[(2)] = inst_14727);

(statearr_14811_14942[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (24))){
var inst_14612 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
if(cljs.core.truth_(inst_14612)){
var statearr_14812_14943 = state_14783__$1;
(statearr_14812_14943[(1)] = (25));

} else {
var statearr_14813_14944 = state_14783__$1;
(statearr_14813_14944[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (55))){
var inst_14644 = (state_14783[(15)]);
var inst_14677 = (state_14783[(36)]);
var inst_14676 = (state_14783[(2)]);
var inst_14677__$1 = fluree.db.util.async.throw_err(inst_14676);
var inst_14678 = fluree.db.dbproto._lookup_leaf(inst_14677__$1,inst_14644);
var state_14783__$1 = (function (){var statearr_14814 = state_14783;
(statearr_14814[(36)] = inst_14677__$1);

return statearr_14814;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(56),inst_14678);
} else {
if((state_val_14784 === (85))){
var inst_14758 = (state_14783[(48)]);
var state_14783__$1 = state_14783;
var statearr_14815_14945 = state_14783__$1;
(statearr_14815_14945[(2)] = inst_14758);

(statearr_14815_14945[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (39))){
var inst_14632 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14816_14946 = state_14783__$1;
(statearr_14816_14946[(2)] = inst_14632);

(statearr_14816_14946[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (88))){
var inst_14677 = (state_14783[(36)]);
var inst_14698 = (state_14783[(7)]);
var inst_14770 = fluree.db.dbproto._lookup_leaf(inst_14677,inst_14698);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(90),inst_14770);
} else {
if((state_val_14784 === (46))){
var inst_14646 = (state_14783[(49)]);
var state_14783__$1 = state_14783;
var statearr_14817_14947 = state_14783__$1;
(statearr_14817_14947[(2)] = inst_14646);

(statearr_14817_14947[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (4))){
var inst_14546 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14818_14948 = state_14783__$1;
(statearr_14818_14948[(2)] = inst_14546);

(statearr_14818_14948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (77))){
var inst_14738 = (state_14783[(2)]);
var inst_14739 = fluree.db.util.async.throw_err(inst_14738);
var state_14783__$1 = state_14783;
if(cljs.core.truth_(inst_14739)){
var statearr_14819_14949 = state_14783__$1;
(statearr_14819_14949[(1)] = (78));

} else {
var statearr_14820_14950 = state_14783__$1;
(statearr_14820_14950[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (54))){
var inst_14668 = (state_14783[(2)]);
var inst_14669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14670 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14671 = (new cljs.core.PersistentVector(null,2,(5),inst_14669,inst_14670,null));
var inst_14672 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14671);
var inst_14673 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14674 = fluree.db.dbproto._resolve(inst_14673);
var state_14783__$1 = (function (){var statearr_14821 = state_14783;
(statearr_14821[(10)] = inst_14668);

(statearr_14821[(35)] = inst_14672);

return statearr_14821;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(55),inst_14674);
} else {
if((state_val_14784 === (15))){
var inst_14561 = (state_14783[(50)]);
var state_14783__$1 = state_14783;
var statearr_14822_14951 = state_14783__$1;
(statearr_14822_14951[(2)] = inst_14561);

(statearr_14822_14951[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (48))){
var inst_14656 = (state_14783[(51)]);
var inst_14650 = (state_14783[(2)]);
var inst_14651 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14653 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14654 = (new cljs.core.PersistentVector(null,3,(5),inst_14652,inst_14653,null));
var inst_14655 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14654);
var inst_14656__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14783__$1 = (function (){var statearr_14823 = state_14783;
(statearr_14823[(30)] = inst_14650);

(statearr_14823[(51)] = inst_14656__$1);

(statearr_14823[(39)] = inst_14651);

(statearr_14823[(41)] = inst_14655);

return statearr_14823;
})();
if(cljs.core.truth_(inst_14656__$1)){
var statearr_14824_14952 = state_14783__$1;
(statearr_14824_14952[(1)] = (49));

} else {
var statearr_14825_14953 = state_14783__$1;
(statearr_14825_14953[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (50))){
var inst_14659 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14783__$1 = state_14783;
var statearr_14826_14954 = state_14783__$1;
(statearr_14826_14954[(2)] = inst_14659);

(statearr_14826_14954[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (75))){
var inst_14716 = (state_14783[(52)]);
var state_14783__$1 = state_14783;
var statearr_14827_14955 = state_14783__$1;
(statearr_14827_14955[(2)] = inst_14716);

(statearr_14827_14955[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (21))){
var inst_14603 = (state_14783[(2)]);
var inst_14604 = fluree.db.util.async.throw_err(inst_14603);
var state_14783__$1 = state_14783;
var statearr_14828_14956 = state_14783__$1;
(statearr_14828_14956[(2)] = inst_14604);

(statearr_14828_14956[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (31))){
var state_14783__$1 = state_14783;
var statearr_14829_14957 = state_14783__$1;
(statearr_14829_14957[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14829_14957[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (32))){
var inst_14567 = (state_14783[(47)]);
var state_14783__$1 = state_14783;
var statearr_14830_14958 = state_14783__$1;
(statearr_14830_14958[(2)] = inst_14567);

(statearr_14830_14958[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (40))){
var inst_14571 = (state_14783[(53)]);
var state_14783__$1 = state_14783;
var statearr_14831_14959 = state_14783__$1;
(statearr_14831_14959[(2)] = inst_14571);

(statearr_14831_14959[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (56))){
var inst_14680 = (state_14783[(2)]);
var inst_14681 = fluree.db.util.async.throw_err(inst_14680);
var inst_14682 = inst_14681;
var inst_14683 = (0);
var inst_14684 = null;
var state_14783__$1 = (function (){var statearr_14832 = state_14783;
(statearr_14832[(32)] = inst_14683);

(statearr_14832[(34)] = inst_14684);

(statearr_14832[(11)] = inst_14682);

return statearr_14832;
})();
var statearr_14833_14960 = state_14783__$1;
(statearr_14833_14960[(2)] = null);

(statearr_14833_14960[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (33))){
var inst_14564 = (state_14783[(54)]);
var inst_14625 = (state_14783[(2)]);
var state_14783__$1 = (function (){var statearr_14834 = state_14783;
(statearr_14834[(38)] = inst_14625);

return statearr_14834;
})();
if(cljs.core.truth_(inst_14564)){
var statearr_14835_14961 = state_14783__$1;
(statearr_14835_14961[(1)] = (34));

} else {
var statearr_14836_14962 = state_14783__$1;
(statearr_14836_14962[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (13))){
var inst_14585 = (state_14783[(2)]);
var inst_14586 = fluree.db.util.async.throw_err(inst_14585);
var state_14783__$1 = state_14783;
var statearr_14837_14963 = state_14783__$1;
(statearr_14837_14963[(2)] = inst_14586);

(statearr_14837_14963[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (22))){
var inst_14598 = (state_14783[(43)]);
var state_14783__$1 = state_14783;
var statearr_14838_14964 = state_14783__$1;
(statearr_14838_14964[(2)] = inst_14598);

(statearr_14838_14964[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (90))){
var inst_14755 = (state_14783[(9)]);
var inst_14754 = (state_14783[(8)]);
var inst_14772 = (state_14783[(2)]);
var inst_14773 = fluree.db.util.async.throw_err(inst_14772);
var inst_14682 = inst_14773;
var inst_14683 = inst_14755;
var inst_14684 = inst_14754;
var state_14783__$1 = (function (){var statearr_14839 = state_14783;
(statearr_14839[(32)] = inst_14683);

(statearr_14839[(34)] = inst_14684);

(statearr_14839[(11)] = inst_14682);

return statearr_14839;
})();
var statearr_14840_14965 = state_14783__$1;
(statearr_14840_14965[(2)] = null);

(statearr_14840_14965[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (36))){
var inst_14571 = (state_14783[(53)]);
var inst_14634 = (state_14783[(2)]);
var state_14783__$1 = (function (){var statearr_14841 = state_14783;
(statearr_14841[(33)] = inst_14634);

return statearr_14841;
})();
if(cljs.core.truth_(inst_14571)){
var statearr_14842_14966 = state_14783__$1;
(statearr_14842_14966[(1)] = (40));

} else {
var statearr_14843_14967 = state_14783__$1;
(statearr_14843_14967[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (41))){
var inst_14637 = (cljs.core._LT__EQ_ === end_test);
var state_14783__$1 = state_14783;
if(cljs.core.truth_(inst_14637)){
var statearr_14844_14968 = state_14783__$1;
(statearr_14844_14968[(1)] = (43));

} else {
var statearr_14845_14969 = state_14783__$1;
(statearr_14845_14969[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (89))){
var inst_14776 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14846_14970 = state_14783__$1;
(statearr_14846_14970[(2)] = inst_14776);

(statearr_14846_14970[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (43))){
var state_14783__$1 = state_14783;
var statearr_14847_14971 = state_14783__$1;
(statearr_14847_14971[(2)] = (2147483647));

(statearr_14847_14971[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (61))){
var inst_14690 = (state_14783[(18)]);
var state_14783__$1 = state_14783;
var statearr_14848_14972 = state_14783__$1;
(statearr_14848_14972[(2)] = inst_14690);

(statearr_14848_14972[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (29))){
var inst_14617 = (state_14783[(46)]);
var state_14783__$1 = state_14783;
var statearr_14849_14973 = state_14783__$1;
(statearr_14849_14973[(2)] = inst_14617);

(statearr_14849_14973[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (44))){
var state_14783__$1 = state_14783;
var statearr_14850_14974 = state_14783__$1;
(statearr_14850_14974[(2)] = fluree.db.util.core.min_integer);

(statearr_14850_14974[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (6))){
var inst_14559 = (state_14783[(14)]);
var inst_14574 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14559);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(9),inst_14574);
} else {
if((state_val_14784 === (28))){
var inst_14607 = (state_14783[(21)]);
var state_14783__$1 = state_14783;
var statearr_14851_14975 = state_14783__$1;
(statearr_14851_14975[(2)] = inst_14607);

(statearr_14851_14975[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (64))){
var inst_14697 = (state_14783[(12)]);
var inst_14683 = (state_14783[(32)]);
var inst_14711 = cljs.core.seq(inst_14697);
var inst_14712 = cljs.core.first(inst_14711);
var inst_14713 = cljs.core.next(inst_14711);
var inst_14714 = inst_14697;
var inst_14715 = inst_14683;
var inst_14716 = inst_14697;
var state_14783__$1 = (function (){var statearr_14852 = state_14783;
(statearr_14852[(22)] = inst_14715);

(statearr_14852[(55)] = inst_14714);

(statearr_14852[(56)] = inst_14713);

(statearr_14852[(57)] = inst_14712);

(statearr_14852[(52)] = inst_14716);

return statearr_14852;
})();
var statearr_14853_14976 = state_14783__$1;
(statearr_14853_14976[(2)] = null);

(statearr_14853_14976[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (51))){
var inst_14661 = (state_14783[(2)]);
var inst_14662 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_14663 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14783__$1 = (function (){var statearr_14854 = state_14783;
(statearr_14854[(25)] = inst_14662);

(statearr_14854[(26)] = inst_14661);

return statearr_14854;
})();
if(cljs.core.truth_(inst_14663)){
var statearr_14855_14977 = state_14783__$1;
(statearr_14855_14977[(1)] = (52));

} else {
var statearr_14856_14978 = state_14783__$1;
(statearr_14856_14978[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (25))){
var state_14783__$1 = state_14783;
var statearr_14857_14979 = state_14783__$1;
(statearr_14857_14979[(2)] = (-1));

(statearr_14857_14979[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (34))){
var inst_14564 = (state_14783[(54)]);
var state_14783__$1 = state_14783;
var statearr_14858_14980 = state_14783__$1;
(statearr_14858_14980[(2)] = inst_14564);

(statearr_14858_14980[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (17))){
var inst_14594 = (state_14783[(2)]);
var inst_14595 = fluree.db.util.async.throw_err(inst_14594);
var state_14783__$1 = state_14783;
var statearr_14859_14981 = state_14783__$1;
(statearr_14859_14981[(2)] = inst_14595);

(statearr_14859_14981[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (3))){
var inst_14781 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14783__$1,inst_14781);
} else {
if((state_val_14784 === (12))){
var inst_14561 = (state_14783[(50)]);
var inst_14589 = (state_14783[(2)]);
var inst_14590 = fluree.db.util.core.pred_ident_QMARK_(inst_14561);
var state_14783__$1 = (function (){var statearr_14860 = state_14783;
(statearr_14860[(24)] = inst_14589);

return statearr_14860;
})();
if(inst_14590){
var statearr_14861_14982 = state_14783__$1;
(statearr_14861_14982[(1)] = (14));

} else {
var statearr_14862_14983 = state_14783__$1;
(statearr_14862_14983[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (2))){
var inst_14565 = (state_14783[(29)]);
var inst_14558 = (state_14783[(31)]);
var inst_14559 = (state_14783[(14)]);
var _ = (function (){var statearr_14863 = state_14783;
(statearr_14863[(4)] = cljs.core.cons((5),(state_14783[(4)])));

return statearr_14863;
})();
var inst_14558__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14559__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14558__$1,(0),null);
var inst_14560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14558__$1,(1),null);
var inst_14561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14558__$1,(2),null);
var inst_14562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14558__$1,(3),null);
var inst_14563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14558__$1,(4),null);
var inst_14564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14558__$1,(5),null);
var inst_14565__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14565__$1,(0),null);
var inst_14567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14565__$1,(1),null);
var inst_14568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14565__$1,(2),null);
var inst_14569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14565__$1,(3),null);
var inst_14570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14565__$1,(4),null);
var inst_14571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14565__$1,(5),null);
var inst_14572 = fluree.db.util.core.pred_ident_QMARK_(inst_14559__$1);
var state_14783__$1 = (function (){var statearr_14864 = state_14783;
(statearr_14864[(58)] = inst_14568);

(statearr_14864[(27)] = inst_14562);

(statearr_14864[(29)] = inst_14565__$1);

(statearr_14864[(19)] = inst_14560);

(statearr_14864[(31)] = inst_14558__$1);

(statearr_14864[(50)] = inst_14561);

(statearr_14864[(54)] = inst_14564);

(statearr_14864[(14)] = inst_14559__$1);

(statearr_14864[(47)] = inst_14567);

(statearr_14864[(37)] = inst_14563);

(statearr_14864[(53)] = inst_14571);

(statearr_14864[(44)] = inst_14569);

(statearr_14864[(59)] = inst_14566);

(statearr_14864[(45)] = inst_14570);

return statearr_14864;
})();
if(inst_14572){
var statearr_14865_14984 = state_14783__$1;
(statearr_14865_14984[(1)] = (6));

} else {
var statearr_14866_14985 = state_14783__$1;
(statearr_14866_14985[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (66))){
var inst_14724 = (state_14783[(60)]);
var inst_14722 = (state_14783[(13)]);
var inst_14714 = (state_14783[(55)]);
var inst_14721 = cljs.core.seq(inst_14714);
var inst_14722__$1 = cljs.core.first(inst_14721);
var inst_14723 = cljs.core.next(inst_14721);
var inst_14724__$1 = (inst_14722__$1 == null);
var state_14783__$1 = (function (){var statearr_14867 = state_14783;
(statearr_14867[(60)] = inst_14724__$1);

(statearr_14867[(13)] = inst_14722__$1);

(statearr_14867[(61)] = inst_14723);

return statearr_14867;
})();
if(cljs.core.truth_(inst_14724__$1)){
var statearr_14868_14986 = state_14783__$1;
(statearr_14868_14986[(1)] = (68));

} else {
var statearr_14869_14987 = state_14783__$1;
(statearr_14869_14987[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (23))){
var inst_14608 = (state_14783[(20)]);
var state_14783__$1 = state_14783;
var statearr_14870_14988 = state_14783__$1;
(statearr_14870_14988[(2)] = inst_14608);

(statearr_14870_14988[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (47))){
var state_14783__$1 = state_14783;
var statearr_14871_14989 = state_14783__$1;
(statearr_14871_14989[(2)] = fluree.db.util.core.max_long);

(statearr_14871_14989[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (35))){
var inst_14628 = (cljs.core._GT__EQ_ === start_test);
var state_14783__$1 = state_14783;
if(cljs.core.truth_(inst_14628)){
var statearr_14872_14990 = state_14783__$1;
(statearr_14872_14990[(1)] = (37));

} else {
var statearr_14873_14991 = state_14783__$1;
(statearr_14873_14991[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (82))){
var inst_14698 = (state_14783[(7)]);
var state_14783__$1 = state_14783;
var statearr_14874_14992 = state_14783__$1;
(statearr_14874_14992[(2)] = inst_14698);

(statearr_14874_14992[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (76))){
var inst_14733 = (state_14783[(23)]);
var inst_14723 = (state_14783[(61)]);
var inst_14747 = (state_14783[(2)]);
var inst_14714 = inst_14723;
var inst_14715 = inst_14733;
var inst_14716 = inst_14747;
var state_14783__$1 = (function (){var statearr_14875 = state_14783;
(statearr_14875[(22)] = inst_14715);

(statearr_14875[(55)] = inst_14714);

(statearr_14875[(52)] = inst_14716);

return statearr_14875;
})();
var statearr_14876_14993 = state_14783__$1;
(statearr_14876_14993[(2)] = null);

(statearr_14876_14993[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (19))){
var inst_14568 = (state_14783[(58)]);
var state_14783__$1 = state_14783;
var statearr_14877_14994 = state_14783__$1;
(statearr_14877_14994[(2)] = inst_14568);

(statearr_14877_14994[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (57))){
var inst_14662 = (state_14783[(25)]);
var inst_14661 = (state_14783[(26)]);
var inst_14672 = (state_14783[(35)]);
var inst_14682 = (state_14783[(11)]);
var inst_14686 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_14682,inst_14661,inst_14662,inst_14672);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(59),inst_14686);
} else {
if((state_val_14784 === (68))){
var inst_14724 = (state_14783[(60)]);
var state_14783__$1 = state_14783;
var statearr_14878_14995 = state_14783__$1;
(statearr_14878_14995[(2)] = inst_14724);

(statearr_14878_14995[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (11))){
var inst_14566 = (state_14783[(59)]);
var state_14783__$1 = state_14783;
var statearr_14880_14996 = state_14783__$1;
(statearr_14880_14996[(2)] = inst_14566);

(statearr_14880_14996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (9))){
var inst_14576 = (state_14783[(2)]);
var inst_14577 = fluree.db.util.async.throw_err(inst_14576);
var state_14783__$1 = state_14783;
var statearr_14881_14997 = state_14783__$1;
(statearr_14881_14997[(2)] = inst_14577);

(statearr_14881_14997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (5))){
var _ = (function (){var statearr_14882 = state_14783;
(statearr_14882[(4)] = cljs.core.rest((state_14783[(4)])));

return statearr_14882;
})();
var state_14783__$1 = state_14783;
var ex14879 = (state_14783__$1[(2)]);
var statearr_14883_14998 = state_14783__$1;
(statearr_14883_14998[(5)] = ex14879);


if((ex14879 instanceof Error)){
var statearr_14884_14999 = state_14783__$1;
(statearr_14884_14999[(1)] = (4));

(statearr_14884_14999[(5)] = null);

} else {
throw ex14879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (83))){
var inst_14766 = (state_14783[(2)]);
var inst_14767 = cljs.core.not(inst_14766);
var state_14783__$1 = state_14783;
if(inst_14767){
var statearr_14885_15000 = state_14783__$1;
(statearr_14885_15000[(1)] = (87));

} else {
var statearr_14886_15001 = state_14783__$1;
(statearr_14886_15001[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (14))){
var inst_14561 = (state_14783[(50)]);
var inst_14592 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14561);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(17),inst_14592);
} else {
if((state_val_14784 === (45))){
var inst_14641 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14887_15002 = state_14783__$1;
(statearr_14887_15002[(2)] = inst_14641);

(statearr_14887_15002[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (53))){
var state_14783__$1 = state_14783;
var statearr_14888_15003 = state_14783__$1;
(statearr_14888_15003[(2)] = true);

(statearr_14888_15003[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (78))){
var inst_14716 = (state_14783[(52)]);
var state_14783__$1 = state_14783;
var statearr_14889_15004 = state_14783__$1;
(statearr_14889_15004[(2)] = inst_14716);

(statearr_14889_15004[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (26))){
var inst_14560 = (state_14783[(19)]);
var state_14783__$1 = state_14783;
var statearr_14890_15005 = state_14783__$1;
(statearr_14890_15005[(2)] = inst_14560);

(statearr_14890_15005[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (16))){
var inst_14568 = (state_14783[(58)]);
var inst_14598 = (state_14783[(2)]);
var inst_14599 = fluree.db.util.core.pred_ident_QMARK_(inst_14568);
var state_14783__$1 = (function (){var statearr_14891 = state_14783;
(statearr_14891[(43)] = inst_14598);

return statearr_14891;
})();
if(inst_14599){
var statearr_14892_15006 = state_14783__$1;
(statearr_14892_15006[(1)] = (18));

} else {
var statearr_14893_15007 = state_14783__$1;
(statearr_14893_15007[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (81))){
var inst_14645 = (state_14783[(16)]);
var inst_14698 = (state_14783[(7)]);
var inst_14758 = (state_14783[(48)]);
var inst_14655 = (state_14783[(41)]);
var inst_14757 = (inst_14655.cljs$core$IFn$_invoke$arity$2 ? inst_14655.cljs$core$IFn$_invoke$arity$2(inst_14698,inst_14645) : inst_14655.call(null,inst_14698,inst_14645));
var inst_14758__$1 = (inst_14757 < (0));
var state_14783__$1 = (function (){var statearr_14894 = state_14783;
(statearr_14894[(48)] = inst_14758__$1);

return statearr_14894;
})();
if(cljs.core.truth_(inst_14758__$1)){
var statearr_14895_15008 = state_14783__$1;
(statearr_14895_15008[(1)] = (84));

} else {
var statearr_14896_15009 = state_14783__$1;
(statearr_14896_15009[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (79))){
var inst_14722 = (state_14783[(13)]);
var inst_14716 = (state_14783[(52)]);
var inst_14742 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_14716,inst_14722);
var state_14783__$1 = state_14783;
var statearr_14897_15010 = state_14783__$1;
(statearr_14897_15010[(2)] = inst_14742);

(statearr_14897_15010[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (38))){
var state_14783__$1 = state_14783;
var statearr_14898_15011 = state_14783__$1;
(statearr_14898_15011[(2)] = (2147483647));

(statearr_14898_15011[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (87))){
var inst_14754 = (state_14783[(8)]);
var state_14783__$1 = state_14783;
var statearr_14899_15012 = state_14783__$1;
(statearr_14899_15012[(2)] = inst_14754);

(statearr_14899_15012[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (30))){
var inst_14621 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
if(cljs.core.truth_(inst_14621)){
var statearr_14900_15013 = state_14783__$1;
(statearr_14900_15013[(1)] = (31));

} else {
var statearr_14901_15014 = state_14783__$1;
(statearr_14901_15014[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (73))){
var inst_14750 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14902_15015 = state_14783__$1;
(statearr_14902_15015[(2)] = inst_14750);

(statearr_14902_15015[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (10))){
var inst_14566 = (state_14783[(59)]);
var inst_14583 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14566);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(13),inst_14583);
} else {
if((state_val_14784 === (18))){
var inst_14568 = (state_14783[(58)]);
var inst_14601 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14568);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(21),inst_14601);
} else {
if((state_val_14784 === (52))){
var inst_14589 = (state_14783[(24)]);
var inst_14625 = (state_14783[(38)]);
var inst_14651 = (state_14783[(39)]);
var inst_14616 = (state_14783[(40)]);
var inst_14580 = (state_14783[(42)]);
var inst_14665 = fluree.db.permissions_validate.no_filter_QMARK_(inst_14651,inst_14580,inst_14589,inst_14616,inst_14625);
var state_14783__$1 = state_14783;
var statearr_14903_15016 = state_14783__$1;
(statearr_14903_15016[(2)] = inst_14665);

(statearr_14903_15016[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (67))){
var inst_14752 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14904_15017 = state_14783__$1;
(statearr_14904_15017[(2)] = inst_14752);

(statearr_14904_15017[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (71))){
var inst_14684 = (state_14783[(34)]);
var inst_14716 = (state_14783[(52)]);
var inst_14731 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14716,inst_14684);
var state_14783__$1 = state_14783;
var statearr_14905_15018 = state_14783__$1;
(statearr_14905_15018[(2)] = inst_14731);

(statearr_14905_15018[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (42))){
var inst_14589 = (state_14783[(24)]);
var inst_14607 = (state_14783[(21)]);
var inst_14562 = (state_14783[(27)]);
var inst_14643 = (state_14783[(28)]);
var inst_14646 = (state_14783[(49)]);
var inst_14634 = (state_14783[(33)]);
var inst_14563 = (state_14783[(37)]);
var inst_14625 = (state_14783[(38)]);
var inst_14616 = (state_14783[(40)]);
var inst_14580 = (state_14783[(42)]);
var inst_14598 = (state_14783[(43)]);
var inst_14569 = (state_14783[(44)]);
var inst_14570 = (state_14783[(45)]);
var inst_14643__$1 = (state_14783[(2)]);
var inst_14644 = fluree.db.flake.__GT_Flake(inst_14580,inst_14616,inst_14598,inst_14562,inst_14563,inst_14634);
var inst_14645 = fluree.db.flake.__GT_Flake(inst_14589,inst_14625,inst_14607,inst_14569,inst_14570,inst_14643__$1);
var inst_14646__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14783__$1 = (function (){var statearr_14906 = state_14783;
(statearr_14906[(15)] = inst_14644);

(statearr_14906[(28)] = inst_14643__$1);

(statearr_14906[(49)] = inst_14646__$1);

(statearr_14906[(16)] = inst_14645);

return statearr_14906;
})();
if(cljs.core.truth_(inst_14646__$1)){
var statearr_14907_15019 = state_14783__$1;
(statearr_14907_15019[(1)] = (46));

} else {
var statearr_14908_15020 = state_14783__$1;
(statearr_14908_15020[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (80))){
var inst_14744 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14909_15021 = state_14783__$1;
(statearr_14909_15021[(2)] = inst_14744);

(statearr_14909_15021[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (37))){
var state_14783__$1 = state_14783;
var statearr_14910_15022 = state_14783__$1;
(statearr_14910_15022[(2)] = fluree.db.util.core.min_integer);

(statearr_14910_15022[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (63))){
var inst_14697 = (state_14783[(12)]);
var inst_14650 = (state_14783[(30)]);
var inst_14683 = (state_14783[(32)]);
var inst_14684 = (state_14783[(34)]);
var inst_14700 = (inst_14650 - inst_14683);
var inst_14701 = fluree.db.flake.take(inst_14700,inst_14697);
var inst_14702 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14701,inst_14684);
var state_14783__$1 = state_14783;
var statearr_14911_15023 = state_14783__$1;
(statearr_14911_15023[(2)] = inst_14702);

(statearr_14911_15023[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (8))){
var inst_14566 = (state_14783[(59)]);
var inst_14580 = (state_14783[(2)]);
var inst_14581 = fluree.db.util.core.pred_ident_QMARK_(inst_14566);
var state_14783__$1 = (function (){var statearr_14912 = state_14783;
(statearr_14912[(42)] = inst_14580);

return statearr_14912;
})();
if(inst_14581){
var statearr_14913_15024 = state_14783__$1;
(statearr_14913_15024[(1)] = (10));

} else {
var statearr_14914_15025 = state_14783__$1;
(statearr_14914_15025[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (49))){
var inst_14656 = (state_14783[(51)]);
var state_14783__$1 = state_14783;
var statearr_14915_15026 = state_14783__$1;
(statearr_14915_15026[(2)] = inst_14656);

(statearr_14915_15026[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (84))){
var inst_14650 = (state_14783[(30)]);
var inst_14755 = (state_14783[(9)]);
var inst_14760 = (inst_14755 < inst_14650);
var state_14783__$1 = state_14783;
var statearr_14916_15027 = state_14783__$1;
(statearr_14916_15027[(2)] = inst_14760);

(statearr_14916_15027[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_14917 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14917[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_14917[(1)] = (1));

return statearr_14917;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_14783){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14783);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14918){var ex__2687__auto__ = e14918;
var statearr_14919_15028 = state_14783;
(statearr_14919_15028[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14783[(4)]))){
var statearr_14920_15029 = state_14783;
(statearr_14920_15029[(1)] = cljs.core.first((state_14783[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15030 = state_14783;
state_14783 = G__15030;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_14783){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_14783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14921 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14921[(6)] = c__2706__auto__);

return statearr_14921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15105){
var state_val_15106 = (state_15105[(1)]);
if((state_val_15106 === (7))){
var inst_15100 = (state_15105[(2)]);
var _ = (function (){var statearr_15107 = state_15105;
(statearr_15107[(4)] = cljs.core.rest((state_15105[(4)])));

return statearr_15107;
})();
var state_15105__$1 = state_15105;
var statearr_15108_15148 = state_15105__$1;
(statearr_15108_15148[(2)] = inst_15100);

(statearr_15108_15148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (20))){
var inst_15082 = (state_15105[(2)]);
var inst_15083 = fluree.db.util.async.throw_err(inst_15082);
var state_15105__$1 = state_15105;
var statearr_15109_15149 = state_15105__$1;
(statearr_15109_15149[(2)] = inst_15083);

(statearr_15109_15149[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (1))){
var state_15105__$1 = state_15105;
var statearr_15110_15150 = state_15105__$1;
(statearr_15110_15150[(2)] = null);

(statearr_15110_15150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (4))){
var inst_15031 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
var statearr_15111_15151 = state_15105__$1;
(statearr_15111_15151[(2)] = inst_15031);

(statearr_15111_15151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (15))){
var inst_15078 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15105__$1 = state_15105;
if(cljs.core.truth_(inst_15078)){
var statearr_15112_15152 = state_15105__$1;
(statearr_15112_15152[(1)] = (17));

} else {
var statearr_15113_15153 = state_15105__$1;
(statearr_15113_15153[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (21))){
var state_15105__$1 = state_15105;
var statearr_15114_15154 = state_15105__$1;
(statearr_15114_15154[(2)] = (0));

(statearr_15114_15154[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (13))){
var inst_15070 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
var statearr_15115_15155 = state_15105__$1;
(statearr_15115_15155[(2)] = inst_15070);

(statearr_15115_15155[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (22))){
var state_15105__$1 = state_15105;
var statearr_15116_15156 = state_15105__$1;
(statearr_15116_15156[(2)] = (1));

(statearr_15116_15156[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (6))){
var inst_15060 = (state_15105[(7)]);
var inst_15062 = (state_15105[(8)]);
var inst_15051 = (state_15105[(9)]);
var inst_15059 = cljs.core.seq(inst_15051);
var inst_15060__$1 = cljs.core.first(inst_15059);
var inst_15061 = cljs.core.next(inst_15059);
var inst_15062__$1 = (inst_15060__$1 == null);
var state_15105__$1 = (function (){var statearr_15117 = state_15105;
(statearr_15117[(7)] = inst_15060__$1);

(statearr_15117[(10)] = inst_15061);

(statearr_15117[(8)] = inst_15062__$1);

return statearr_15117;
})();
if(cljs.core.truth_(inst_15062__$1)){
var statearr_15118_15157 = state_15105__$1;
(statearr_15118_15157[(1)] = (8));

} else {
var statearr_15119_15158 = state_15105__$1;
(statearr_15119_15158[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (17))){
var inst_15060 = (state_15105[(7)]);
var inst_15080 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_15060);
var state_15105__$1 = state_15105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15105__$1,(20),inst_15080);
} else {
if((state_val_15106 === (3))){
var inst_15103 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15105__$1,inst_15103);
} else {
if((state_val_15106 === (12))){
var inst_15053 = (state_15105[(11)]);
var inst_15068 = (inst_15053 >= subject_limit);
var state_15105__$1 = state_15105;
var statearr_15120_15159 = state_15105__$1;
(statearr_15120_15159[(2)] = inst_15068);

(statearr_15120_15159[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (2))){
var _ = (function (){var statearr_15121 = state_15105;
(statearr_15121[(4)] = cljs.core.cons((5),(state_15105[(4)])));

return statearr_15121;
})();
var inst_15044 = subject_groups;
var inst_15045 = cljs.core.seq(inst_15044);
var inst_15046 = cljs.core.first(inst_15045);
var inst_15047 = cljs.core.next(inst_15045);
var inst_15048 = flake_start;
var inst_15049 = subject_start;
var inst_15050 = cljs.core.PersistentVector.EMPTY;
var inst_15051 = inst_15044;
var inst_15052 = inst_15048;
var inst_15053 = inst_15049;
var inst_15054 = inst_15050;
var state_15105__$1 = (function (){var statearr_15122 = state_15105;
(statearr_15122[(12)] = inst_15046);

(statearr_15122[(13)] = inst_15047);

(statearr_15122[(11)] = inst_15053);

(statearr_15122[(14)] = inst_15054);

(statearr_15122[(15)] = inst_15052);

(statearr_15122[(9)] = inst_15051);

return statearr_15122;
})();
var statearr_15123_15160 = state_15105__$1;
(statearr_15123_15160[(2)] = null);

(statearr_15123_15160[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (23))){
var inst_15087 = (state_15105[(16)]);
var inst_15053 = (state_15105[(11)]);
var inst_15054 = (state_15105[(14)]);
var inst_15061 = (state_15105[(10)]);
var inst_15086 = (state_15105[(17)]);
var inst_15052 = (state_15105[(15)]);
var inst_15092 = (state_15105[(2)]);
var inst_15093 = (inst_15052 + inst_15087);
var inst_15094 = (inst_15053 + inst_15092);
var inst_15095 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15054,inst_15086);
var inst_15051 = inst_15061;
var inst_15052__$1 = inst_15093;
var inst_15053__$1 = inst_15094;
var inst_15054__$1 = inst_15095;
var state_15105__$1 = (function (){var statearr_15124 = state_15105;
(statearr_15124[(11)] = inst_15053__$1);

(statearr_15124[(14)] = inst_15054__$1);

(statearr_15124[(15)] = inst_15052__$1);

(statearr_15124[(9)] = inst_15051);

return statearr_15124;
})();
var statearr_15125_15161 = state_15105__$1;
(statearr_15125_15161[(2)] = null);

(statearr_15125_15161[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (19))){
var inst_15087 = (state_15105[(16)]);
var inst_15086 = (state_15105[(17)]);
var inst_15086__$1 = (state_15105[(2)]);
var inst_15087__$1 = cljs.core.count(inst_15086__$1);
var inst_15088 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_15087__$1);
var state_15105__$1 = (function (){var statearr_15126 = state_15105;
(statearr_15126[(16)] = inst_15087__$1);

(statearr_15126[(17)] = inst_15086__$1);

return statearr_15126;
})();
if(inst_15088){
var statearr_15127_15162 = state_15105__$1;
(statearr_15127_15162[(1)] = (21));

} else {
var statearr_15128_15163 = state_15105__$1;
(statearr_15128_15163[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (11))){
var inst_15065 = (state_15105[(18)]);
var state_15105__$1 = state_15105;
var statearr_15130_15164 = state_15105__$1;
(statearr_15130_15164[(2)] = inst_15065);

(statearr_15130_15164[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (9))){
var inst_15052 = (state_15105[(15)]);
var inst_15065 = (state_15105[(18)]);
var inst_15065__$1 = (inst_15052 >= flake_limit);
var state_15105__$1 = (function (){var statearr_15131 = state_15105;
(statearr_15131[(18)] = inst_15065__$1);

return statearr_15131;
})();
if(cljs.core.truth_(inst_15065__$1)){
var statearr_15132_15165 = state_15105__$1;
(statearr_15132_15165[(1)] = (11));

} else {
var statearr_15133_15166 = state_15105__$1;
(statearr_15133_15166[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (5))){
var _ = (function (){var statearr_15134 = state_15105;
(statearr_15134[(4)] = cljs.core.rest((state_15105[(4)])));

return statearr_15134;
})();
var state_15105__$1 = state_15105;
var ex15129 = (state_15105__$1[(2)]);
var statearr_15135_15167 = state_15105__$1;
(statearr_15135_15167[(5)] = ex15129);


if((ex15129 instanceof Error)){
var statearr_15136_15168 = state_15105__$1;
(statearr_15136_15168[(1)] = (4));

(statearr_15136_15168[(5)] = null);

} else {
throw ex15129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (14))){
var inst_15053 = (state_15105[(11)]);
var inst_15054 = (state_15105[(14)]);
var inst_15052 = (state_15105[(15)]);
var inst_15074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15075 = [inst_15052,inst_15053,inst_15054];
var inst_15076 = (new cljs.core.PersistentVector(null,3,(5),inst_15074,inst_15075,null));
var state_15105__$1 = state_15105;
var statearr_15137_15169 = state_15105__$1;
(statearr_15137_15169[(2)] = inst_15076);

(statearr_15137_15169[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (16))){
var inst_15098 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
var statearr_15138_15170 = state_15105__$1;
(statearr_15138_15170[(2)] = inst_15098);

(statearr_15138_15170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (10))){
var inst_15072 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
if(cljs.core.truth_(inst_15072)){
var statearr_15139_15171 = state_15105__$1;
(statearr_15139_15171[(1)] = (14));

} else {
var statearr_15140_15172 = state_15105__$1;
(statearr_15140_15172[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (18))){
var inst_15060 = (state_15105[(7)]);
var state_15105__$1 = state_15105;
var statearr_15141_15173 = state_15105__$1;
(statearr_15141_15173[(2)] = inst_15060);

(statearr_15141_15173[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (8))){
var inst_15062 = (state_15105[(8)]);
var state_15105__$1 = state_15105;
var statearr_15142_15174 = state_15105__$1;
(statearr_15142_15174[(2)] = inst_15062);

(statearr_15142_15174[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_15143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15143[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto__);

(statearr_15143[(1)] = (1));

return statearr_15143;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto____1 = (function (state_15105){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15105);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15144){var ex__2687__auto__ = e15144;
var statearr_15145_15175 = state_15105;
(statearr_15145_15175[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15105[(4)]))){
var statearr_15146_15176 = state_15105;
(statearr_15146_15176[(1)] = cljs.core.first((state_15105[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15177 = state_15105;
state_15105 = G__15177;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto__ = function(state_15105){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto____1.call(this,state_15105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15147 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15147[(6)] = c__2706__auto__);

return statearr_15147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15223){
var state_val_15224 = (state_15223[(1)]);
if((state_val_15224 === (7))){
var state_15223__$1 = state_15223;
var statearr_15225_15263 = state_15223__$1;
(statearr_15225_15263[(2)] = null);

(statearr_15225_15263[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (20))){
var inst_15209 = (state_15223[(2)]);
var inst_15210 = fluree.db.util.async.throw_err(inst_15209);
var inst_15188 = inst_15210;
var state_15223__$1 = (function (){var statearr_15226 = state_15223;
(statearr_15226[(7)] = inst_15188);

return statearr_15226;
})();
var statearr_15227_15264 = state_15223__$1;
(statearr_15227_15264[(2)] = null);

(statearr_15227_15264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (1))){
var state_15223__$1 = state_15223;
var statearr_15228_15265 = state_15223__$1;
(statearr_15228_15265[(2)] = null);

(statearr_15228_15265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (4))){
var inst_15178 = (state_15223[(2)]);
var state_15223__$1 = state_15223;
var statearr_15229_15266 = state_15223__$1;
(statearr_15229_15266[(2)] = inst_15178);

(statearr_15229_15266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (15))){
var inst_15205 = (state_15223[(8)]);
var inst_15188 = (state_15223[(7)]);
var inst_15205__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_15188);
var state_15223__$1 = (function (){var statearr_15230 = state_15223;
(statearr_15230[(8)] = inst_15205__$1);

return statearr_15230;
})();
if(cljs.core.truth_(inst_15205__$1)){
var statearr_15231_15267 = state_15223__$1;
(statearr_15231_15267[(1)] = (17));

} else {
var statearr_15232_15268 = state_15223__$1;
(statearr_15232_15268[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (13))){
var inst_15198 = (state_15223[(2)]);
var inst_15199 = fluree.db.util.async.throw_err(inst_15198);
var _ = (function (){var statearr_15233 = state_15223;
(statearr_15233[(4)] = cljs.core.rest((state_15223[(4)])));

return statearr_15233;
})();
var state_15223__$1 = state_15223;
var statearr_15234_15269 = state_15223__$1;
(statearr_15234_15269[(2)] = inst_15199);

(statearr_15234_15269[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (6))){
var inst_15186 = (state_15223[(2)]);
var inst_15187 = fluree.db.util.async.throw_err(inst_15186);
var inst_15188 = inst_15187;
var state_15223__$1 = (function (){var statearr_15235 = state_15223;
(statearr_15235[(7)] = inst_15188);

return statearr_15235;
})();
var statearr_15236_15270 = state_15223__$1;
(statearr_15236_15270[(2)] = null);

(statearr_15236_15270[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (17))){
var inst_15205 = (state_15223[(8)]);
var inst_15207 = fluree.db.dbproto._lookup_leaf(root_node,inst_15205);
var state_15223__$1 = state_15223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15223__$1,(20),inst_15207);
} else {
if((state_val_15224 === (3))){
var inst_15221 = (state_15223[(2)]);
var state_15223__$1 = state_15223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15223__$1,inst_15221);
} else {
if((state_val_15224 === (12))){
var _ = (function (){var statearr_15238 = state_15223;
(statearr_15238[(4)] = cljs.core.rest((state_15223[(4)])));

return statearr_15238;
})();
var state_15223__$1 = state_15223;
var ex15237 = (state_15223__$1[(2)]);
var statearr_15239_15271 = state_15223__$1;
(statearr_15239_15271[(5)] = ex15237);


var statearr_15240_15272 = state_15223__$1;
(statearr_15240_15272[(1)] = (11));

(statearr_15240_15272[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (2))){
var _ = (function (){var statearr_15241 = state_15223;
(statearr_15241[(4)] = cljs.core.cons((5),(state_15223[(4)])));

return statearr_15241;
})();
var inst_15184 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_15223__$1 = state_15223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15223__$1,(6),inst_15184);
} else {
if((state_val_15224 === (19))){
var inst_15214 = (state_15223[(2)]);
var state_15223__$1 = state_15223;
var statearr_15242_15273 = state_15223__$1;
(statearr_15242_15273[(2)] = inst_15214);

(statearr_15242_15273[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (11))){
var inst_15190 = (state_15223[(2)]);
var state_15223__$1 = (function (){var statearr_15244 = state_15223;
(statearr_15244[(9)] = inst_15190);

return statearr_15244;
})();
var statearr_15245_15274 = state_15223__$1;
(statearr_15245_15274[(2)] = null);

(statearr_15245_15274[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (9))){
var inst_15188 = (state_15223[(7)]);
var _ = (function (){var statearr_15246 = state_15223;
(statearr_15246[(4)] = cljs.core.cons((12),(state_15223[(4)])));

return statearr_15246;
})();
var inst_15196 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_15188,t,novelty,fast_forward_db_QMARK_);
var state_15223__$1 = state_15223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15223__$1,(13),inst_15196);
} else {
if((state_val_15224 === (5))){
var _ = (function (){var statearr_15247 = state_15223;
(statearr_15247[(4)] = cljs.core.rest((state_15223[(4)])));

return statearr_15247;
})();
var state_15223__$1 = state_15223;
var ex15243 = (state_15223__$1[(2)]);
var statearr_15248_15275 = state_15223__$1;
(statearr_15248_15275[(5)] = ex15243);


if((ex15243 instanceof Error)){
var statearr_15249_15276 = state_15223__$1;
(statearr_15249_15276[(1)] = (4));

(statearr_15249_15276[(5)] = null);

} else {
throw ex15243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (14))){
var inst_15202 = (state_15223[(10)]);
var state_15223__$1 = state_15223;
var statearr_15250_15277 = state_15223__$1;
(statearr_15250_15277[(2)] = inst_15202);

(statearr_15250_15277[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (16))){
var inst_15216 = (state_15223[(2)]);
var state_15223__$1 = state_15223;
var statearr_15251_15278 = state_15223__$1;
(statearr_15251_15278[(2)] = inst_15216);

(statearr_15251_15278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (10))){
var inst_15202 = (state_15223[(10)]);
var inst_15202__$1 = (state_15223[(2)]);
var state_15223__$1 = (function (){var statearr_15252 = state_15223;
(statearr_15252[(10)] = inst_15202__$1);

return statearr_15252;
})();
if(cljs.core.truth_(inst_15202__$1)){
var statearr_15253_15279 = state_15223__$1;
(statearr_15253_15279[(1)] = (14));

} else {
var statearr_15254_15280 = state_15223__$1;
(statearr_15254_15280[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (18))){
var state_15223__$1 = state_15223;
var statearr_15255_15281 = state_15223__$1;
(statearr_15255_15281[(2)] = null);

(statearr_15255_15281[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15224 === (8))){
var inst_15218 = (state_15223[(2)]);
var _ = (function (){var statearr_15256 = state_15223;
(statearr_15256[(4)] = cljs.core.rest((state_15223[(4)])));

return statearr_15256;
})();
var state_15223__$1 = state_15223;
var statearr_15257_15282 = state_15223__$1;
(statearr_15257_15282[(2)] = inst_15218);

(statearr_15257_15282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto____0 = (function (){
var statearr_15258 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15258[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto__);

(statearr_15258[(1)] = (1));

return statearr_15258;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto____1 = (function (state_15223){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15223);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15259){var ex__2687__auto__ = e15259;
var statearr_15260_15283 = state_15223;
(statearr_15260_15283[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15223[(4)]))){
var statearr_15261_15284 = state_15223;
(statearr_15261_15284[(1)] = cljs.core.first((state_15223[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15285 = state_15223;
state_15223 = G__15285;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto__ = function(state_15223){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto____1.call(this,state_15223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15262 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15262[(6)] = c__2706__auto__);

return statearr_15262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15292 = arguments.length;
switch (G__15292) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15293 = (function (){var pred__15296 = cljs.core.identical_QMARK_;
var expr__15297 = test;
if(cljs.core.truth_((pred__15296.cljs$core$IFn$_invoke$arity$2 ? pred__15296.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__15297) : pred__15296.call(null,cljs.core._EQ_,expr__15297)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15296.cljs$core$IFn$_invoke$arity$2 ? pred__15296.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__15297) : pred__15296.call(null,cljs.core._LT_,expr__15297)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__15296.cljs$core$IFn$_invoke$arity$2 ? pred__15296.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__15297) : pred__15296.call(null,cljs.core._LT__EQ_,expr__15297)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15296.cljs$core$IFn$_invoke$arity$2 ? pred__15296.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__15297) : pred__15296.call(null,cljs.core._GT_,expr__15297)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__15296.cljs$core$IFn$_invoke$arity$2 ? pred__15296.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__15297) : pred__15296.call(null,cljs.core._GT__EQ_,expr__15297)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15297)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15293,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15293,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15293,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15293,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15669){
var state_val_15670 = (state_15669[(1)]);
if((state_val_15670 === (121))){
var inst_15625 = (state_15669[(7)]);
var state_15669__$1 = state_15669;
var statearr_15671_15867 = state_15669__$1;
(statearr_15671_15867[(2)] = inst_15625);

(statearr_15671_15867[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (65))){
var inst_15477 = (state_15669[(8)]);
var inst_15483 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15672 = state_15669;
(statearr_15672[(9)] = inst_15483);

return statearr_15672;
})();
if(cljs.core.truth_(inst_15477)){
var statearr_15673_15868 = state_15669__$1;
(statearr_15673_15868[(1)] = (66));

} else {
var statearr_15674_15869 = state_15669__$1;
(statearr_15674_15869[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (70))){
var inst_15661 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15675_15870 = state_15669__$1;
(statearr_15675_15870[(2)] = inst_15661);

(statearr_15675_15870[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (62))){
var inst_15476 = (state_15669[(2)]);
var inst_15477 = fluree.db.util.async.throw_err(inst_15476);
var inst_15478 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15669__$1 = (function (){var statearr_15676 = state_15669;
(statearr_15676[(8)] = inst_15477);

return statearr_15676;
})();
if(cljs.core.truth_(inst_15478)){
var statearr_15677_15871 = state_15669__$1;
(statearr_15677_15871[(1)] = (63));

} else {
var statearr_15678_15872 = state_15669__$1;
(statearr_15678_15872[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (74))){
var inst_15409 = (state_15669[(10)]);
var inst_15427 = (state_15669[(11)]);
var inst_15335 = (state_15669[(12)]);
var inst_15473 = (state_15669[(13)]);
var inst_15486 = (state_15669[(14)]);
var inst_15330 = (state_15669[(15)]);
var inst_15326 = (state_15669[(16)]);
var inst_15446 = (state_15669[(17)]);
var inst_15418 = (state_15669[(18)]);
var inst_15323 = (state_15669[(19)]);
var inst_15336 = (state_15669[(20)]);
var inst_15488 = (state_15669[(21)]);
var inst_15355 = (state_15669[(22)]);
var inst_15319 = (state_15669[(23)]);
var inst_15388 = (state_15669[(24)]);
var inst_15467 = (state_15669[(25)]);
var inst_15449 = (state_15669[(26)]);
var inst_15334 = (state_15669[(27)]);
var inst_15496 = (state_15669[(28)]);
var inst_15458 = (state_15669[(29)]);
var inst_15483 = (state_15669[(9)]);
var inst_15324 = (state_15669[(30)]);
var inst_15445 = (state_15669[(31)]);
var inst_15400 = (state_15669[(32)]);
var inst_15436 = (state_15669[(33)]);
var inst_15462 = (state_15669[(34)]);
var inst_15504 = (state_15669[(35)]);
var inst_15450 = (state_15669[(36)]);
var inst_15457 = (state_15669[(37)]);
var inst_15387 = (state_15669[(38)]);
var inst_15447 = (state_15669[(39)]);
var inst_15331 = (state_15669[(40)]);
var inst_15489 = (state_15669[(41)]);
var inst_15391 = (state_15669[(42)]);
var inst_15477 = (state_15669[(8)]);
var inst_15463 = (state_15669[(43)]);
var inst_15346 = (state_15669[(44)]);
var inst_15456 = (state_15669[(45)]);
var inst_15468 = (state_15669[(46)]);
var inst_15487 = (state_15669[(47)]);
var inst_15490 = (state_15669[(48)]);
var inst_15506 = (function (){var no_filter_QMARK_ = inst_15483;
var t = inst_15463;
var max_limit_QMARK_ = inst_15457;
var next_node = inst_15486;
var fast_forward_db_QMARK_ = inst_15468;
var s1 = inst_15346;
var o2 = inst_15409;
var t1 = inst_15323;
var predicate_fn = inst_15336;
var i = inst_15488;
var m1 = inst_15436;
var root_node = inst_15473;
var s2 = inst_15355;
var p2 = inst_15427;
var vec__15308 = inst_15326;
var permissions = inst_15458;
var limit = inst_15456;
var start_flake = inst_15446;
var vec__15315 = inst_15388;
var flake_limit = inst_15450;
var offset = inst_15487;
var acc = inst_15490;
var G__15497 = inst_15504;
var t2 = inst_15330;
var op1 = inst_15324;
var vec__15312 = inst_15387;
var o1 = inst_15400;
var end_flake = inst_15447;
var base_result = inst_15496;
var s = inst_15489;
var node_start = inst_15477;
var p1 = inst_15418;
var subject_fn = inst_15335;
var object_fn = inst_15391;
var idx_compare = inst_15462;
var map__15318 = inst_15449;
var op2 = inst_15331;
var m2 = inst_15445;
var map__15311 = inst_15334;
var vec__15305 = inst_15319;
var novelty = inst_15467;
return (function (p1__15287_SHARP_){
var G__15679 = p1__15287_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__15679) : subject_fn.call(null,G__15679));
});
})();
var inst_15507 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15506,inst_15504);
var state_15669__$1 = state_15669;
var statearr_15680_15873 = state_15669__$1;
(statearr_15680_15873[(2)] = inst_15507);

(statearr_15680_15873[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (110))){
var inst_15638 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15681_15874 = state_15669__$1;
(statearr_15681_15874[(2)] = inst_15638);

(statearr_15681_15874[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (7))){
var inst_15320 = (state_15669[(49)]);
var state_15669__$1 = state_15669;
var statearr_15682_15875 = state_15669__$1;
(statearr_15682_15875[(2)] = inst_15320);

(statearr_15682_15875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (59))){
var state_15669__$1 = state_15669;
var statearr_15683_15876 = state_15669__$1;
(statearr_15683_15876[(2)] = fluree.db.util.core.max_long);

(statearr_15683_15876[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (86))){
var inst_15483 = (state_15669[(9)]);
var state_15669__$1 = state_15669;
var statearr_15684_15877 = state_15669__$1;
(statearr_15684_15877[(2)] = inst_15483);

(statearr_15684_15877[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (20))){
var state_15669__$1 = state_15669;
var statearr_15685_15878 = state_15669__$1;
(statearr_15685_15878[(2)] = null);

(statearr_15685_15878[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (72))){
var inst_15496 = (state_15669[(28)]);
var state_15669__$1 = state_15669;
var statearr_15686_15879 = state_15669__$1;
(statearr_15686_15879[(2)] = inst_15496);

(statearr_15686_15879[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (58))){
var inst_15451 = (state_15669[(50)]);
var state_15669__$1 = state_15669;
var statearr_15687_15880 = state_15669__$1;
(statearr_15687_15880[(2)] = inst_15451);

(statearr_15687_15880[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (60))){
var inst_15456 = (state_15669[(45)]);
var inst_15456__$1 = (state_15669[(2)]);
var inst_15457 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15456__$1,fluree.db.util.core.max_long);
var inst_15458 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_15459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15460 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_15461 = (new cljs.core.PersistentVector(null,3,(5),inst_15459,inst_15460,null));
var inst_15462 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_15461);
var inst_15463 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_15464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15465 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_15466 = (new cljs.core.PersistentVector(null,2,(5),inst_15464,inst_15465,null));
var inst_15467 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_15466);
var inst_15468 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_15469 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_15470 = fluree.db.dbproto._resolve(inst_15469);
var state_15669__$1 = (function (){var statearr_15688 = state_15669;
(statearr_15688[(25)] = inst_15467);

(statearr_15688[(29)] = inst_15458);

(statearr_15688[(34)] = inst_15462);

(statearr_15688[(37)] = inst_15457);

(statearr_15688[(43)] = inst_15463);

(statearr_15688[(45)] = inst_15456__$1);

(statearr_15688[(46)] = inst_15468);

return statearr_15688;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(61),inst_15470);
} else {
if((state_val_15670 === (27))){
var inst_15389 = (state_15669[(51)]);
var state_15669__$1 = state_15669;
var statearr_15689_15881 = state_15669__$1;
(statearr_15689_15881[(2)] = inst_15389);

(statearr_15689_15881[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (1))){
var state_15669__$1 = state_15669;
var statearr_15690_15882 = state_15669__$1;
(statearr_15690_15882[(2)] = null);

(statearr_15690_15882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (69))){
var inst_15486 = (state_15669[(14)]);
var inst_15446 = (state_15669[(17)]);
var inst_15447 = (state_15669[(39)]);
var inst_15495 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_15486);
var inst_15496 = fluree.db.flake.subrange(inst_15495,start_test,inst_15446,end_test,inst_15447);
var inst_15498 = fluree.db.query.range.value_with_nil_pred(idx,inst_15446,inst_15447);
var state_15669__$1 = (function (){var statearr_15691 = state_15669;
(statearr_15691[(28)] = inst_15496);

return statearr_15691;
})();
if(inst_15498){
var statearr_15692_15883 = state_15669__$1;
(statearr_15692_15883[(1)] = (71));

} else {
var statearr_15693_15884 = state_15669__$1;
(statearr_15693_15884[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (101))){
var inst_15584 = (state_15669[(52)]);
var inst_15583 = (state_15669[(53)]);
var inst_15450 = (state_15669[(36)]);
var inst_15582 = (state_15669[(54)]);
var inst_15587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15588 = (inst_15584 - inst_15450);
var inst_15589 = (inst_15583 - inst_15588);
var inst_15590 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15589,inst_15582);
var inst_15591 = [inst_15450,inst_15590];
var inst_15592 = (new cljs.core.PersistentVector(null,2,(5),inst_15587,inst_15591,null));
var state_15669__$1 = state_15669;
var statearr_15694_15885 = state_15669__$1;
(statearr_15694_15885[(2)] = inst_15592);

(statearr_15694_15885[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (24))){
var inst_15335 = (state_15669[(12)]);
var inst_15330 = (state_15669[(15)]);
var inst_15326 = (state_15669[(16)]);
var inst_15321 = (state_15669[(55)]);
var inst_15323 = (state_15669[(19)]);
var inst_15336 = (state_15669[(20)]);
var inst_15355 = (state_15669[(22)]);
var inst_15319 = (state_15669[(23)]);
var inst_15369 = (state_15669[(56)]);
var inst_15332 = (state_15669[(57)]);
var inst_15334 = (state_15669[(27)]);
var inst_15337 = (state_15669[(58)]);
var inst_15324 = (state_15669[(30)]);
var inst_15322 = (state_15669[(59)]);
var inst_15325 = (state_15669[(60)]);
var inst_15328 = (state_15669[(61)]);
var inst_15331 = (state_15669[(40)]);
var inst_15329 = (state_15669[(62)]);
var inst_15346 = (state_15669[(44)]);
var inst_15379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15381 = [null,null];
var inst_15382 = (new cljs.core.PersistentVector(null,2,(5),inst_15380,inst_15381,null));
var inst_15383 = (function (){var bool = inst_15369;
var s1 = inst_15346;
var o2 = inst_15329;
var t1 = inst_15323;
var predicate_fn = inst_15336;
var m1 = inst_15325;
var s2 = inst_15355;
var p2 = inst_15328;
var vec__15308 = inst_15326;
var t2 = inst_15330;
var op1 = inst_15324;
var o1 = inst_15322;
var p1 = inst_15321;
var subject_fn = inst_15335;
var temp__5806__auto__ = inst_15369;
var object_fn = inst_15337;
var op2 = inst_15331;
var m2 = inst_15332;
var map__15311 = inst_15334;
var vec__15305 = inst_15319;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_15384 = [inst_15382,inst_15383];
var inst_15385 = (new cljs.core.PersistentVector(null,2,(5),inst_15379,inst_15384,null));
var state_15669__$1 = state_15669;
var statearr_15695_15886 = state_15669__$1;
(statearr_15695_15886[(2)] = inst_15385);

(statearr_15695_15886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (102))){
var inst_15584 = (state_15669[(52)]);
var inst_15582 = (state_15669[(54)]);
var inst_15594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15595 = [inst_15584,inst_15582];
var inst_15596 = (new cljs.core.PersistentVector(null,2,(5),inst_15594,inst_15595,null));
var state_15669__$1 = state_15669;
var statearr_15696_15887 = state_15669__$1;
(statearr_15696_15887[(2)] = inst_15596);

(statearr_15696_15887[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (55))){
var state_15669__$1 = state_15669;
var statearr_15697_15888 = state_15669__$1;
(statearr_15697_15888[(2)] = (2147483647));

(statearr_15697_15888[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (85))){
var inst_15532 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
if(cljs.core.truth_(inst_15532)){
var statearr_15698_15889 = state_15669__$1;
(statearr_15698_15889[(1)] = (89));

} else {
var statearr_15699_15890 = state_15669__$1;
(statearr_15699_15890[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (39))){
var inst_15419 = (state_15669[(63)]);
var inst_15328 = (state_15669[(61)]);
var inst_15418 = (state_15669[(2)]);
var inst_15419__$1 = (inst_15328 == null);
var state_15669__$1 = (function (){var statearr_15700 = state_15669;
(statearr_15700[(18)] = inst_15418);

(statearr_15700[(63)] = inst_15419__$1);

return statearr_15700;
})();
if(cljs.core.truth_(inst_15419__$1)){
var statearr_15701_15891 = state_15669__$1;
(statearr_15701_15891[(1)] = (40));

} else {
var statearr_15702_15892 = state_15669__$1;
(statearr_15702_15892[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (88))){
var inst_15529 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15703_15893 = state_15669__$1;
(statearr_15703_15893[(2)] = inst_15529);

(statearr_15703_15893[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (46))){
var inst_15325 = (state_15669[(60)]);
var state_15669__$1 = state_15669;
var statearr_15704_15894 = state_15669__$1;
(statearr_15704_15894[(2)] = inst_15325);

(statearr_15704_15894[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (4))){
var inst_15299 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15705_15895 = state_15669__$1;
(statearr_15705_15895[(2)] = inst_15299);

(statearr_15705_15895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (77))){
var inst_15409 = (state_15669[(10)]);
var inst_15427 = (state_15669[(11)]);
var inst_15335 = (state_15669[(12)]);
var inst_15473 = (state_15669[(13)]);
var inst_15486 = (state_15669[(14)]);
var inst_15330 = (state_15669[(15)]);
var inst_15326 = (state_15669[(16)]);
var inst_15446 = (state_15669[(17)]);
var inst_15418 = (state_15669[(18)]);
var inst_15323 = (state_15669[(19)]);
var inst_15336 = (state_15669[(20)]);
var inst_15488 = (state_15669[(21)]);
var inst_15355 = (state_15669[(22)]);
var inst_15319 = (state_15669[(23)]);
var inst_15388 = (state_15669[(24)]);
var inst_15467 = (state_15669[(25)]);
var inst_15449 = (state_15669[(26)]);
var inst_15334 = (state_15669[(27)]);
var inst_15496 = (state_15669[(28)]);
var inst_15458 = (state_15669[(29)]);
var inst_15483 = (state_15669[(9)]);
var inst_15324 = (state_15669[(30)]);
var inst_15445 = (state_15669[(31)]);
var inst_15400 = (state_15669[(32)]);
var inst_15436 = (state_15669[(33)]);
var inst_15462 = (state_15669[(34)]);
var inst_15450 = (state_15669[(36)]);
var inst_15510 = (state_15669[(64)]);
var inst_15457 = (state_15669[(37)]);
var inst_15387 = (state_15669[(38)]);
var inst_15447 = (state_15669[(39)]);
var inst_15331 = (state_15669[(40)]);
var inst_15489 = (state_15669[(41)]);
var inst_15391 = (state_15669[(42)]);
var inst_15477 = (state_15669[(8)]);
var inst_15463 = (state_15669[(43)]);
var inst_15346 = (state_15669[(44)]);
var inst_15456 = (state_15669[(45)]);
var inst_15468 = (state_15669[(46)]);
var inst_15487 = (state_15669[(47)]);
var inst_15490 = (state_15669[(48)]);
var inst_15512 = (function (){var no_filter_QMARK_ = inst_15483;
var t = inst_15463;
var max_limit_QMARK_ = inst_15457;
var next_node = inst_15486;
var fast_forward_db_QMARK_ = inst_15468;
var s1 = inst_15346;
var o2 = inst_15409;
var t1 = inst_15323;
var predicate_fn = inst_15336;
var i = inst_15488;
var m1 = inst_15436;
var root_node = inst_15473;
var s2 = inst_15355;
var p2 = inst_15427;
var vec__15308 = inst_15326;
var permissions = inst_15458;
var limit = inst_15456;
var start_flake = inst_15446;
var vec__15315 = inst_15388;
var flake_limit = inst_15450;
var offset = inst_15487;
var acc = inst_15490;
var G__15497 = inst_15510;
var t2 = inst_15330;
var op1 = inst_15324;
var vec__15312 = inst_15387;
var o1 = inst_15400;
var end_flake = inst_15447;
var base_result = inst_15496;
var s = inst_15489;
var node_start = inst_15477;
var p1 = inst_15418;
var subject_fn = inst_15335;
var object_fn = inst_15391;
var idx_compare = inst_15462;
var map__15318 = inst_15449;
var op2 = inst_15331;
var m2 = inst_15445;
var map__15311 = inst_15334;
var vec__15305 = inst_15319;
var novelty = inst_15467;
return (function (p1__15288_SHARP_){
var G__15706 = p1__15288_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__15706) : predicate_fn.call(null,G__15706));
});
})();
var inst_15513 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15512,inst_15510);
var state_15669__$1 = state_15669;
var statearr_15707_15896 = state_15669__$1;
(statearr_15707_15896[(2)] = inst_15513);

(statearr_15707_15896[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (106))){
var inst_15523 = (state_15669[(65)]);
var state_15669__$1 = state_15669;
var statearr_15708_15897 = state_15669__$1;
(statearr_15708_15897[(2)] = inst_15523);

(statearr_15708_15897[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (119))){
var inst_15641 = (state_15669[(66)]);
var state_15669__$1 = state_15669;
var statearr_15709_15898 = state_15669__$1;
(statearr_15709_15898[(2)] = inst_15641);

(statearr_15709_15898[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (95))){
var inst_15556 = (state_15669[(67)]);
var inst_15565 = (state_15669[(68)]);
var inst_15566 = (state_15669[(69)]);
var inst_15564 = (state_15669[(70)]);
var inst_15489 = (state_15669[(41)]);
var inst_15456 = (state_15669[(45)]);
var inst_15564__$1 = cljs.core.count(inst_15556);
var inst_15565__$1 = (inst_15489 + inst_15564__$1);
var inst_15566__$1 = (inst_15565__$1 - inst_15456);
var inst_15567 = cljs.core.pos_int_QMARK_(inst_15566__$1);
var state_15669__$1 = (function (){var statearr_15710 = state_15669;
(statearr_15710[(68)] = inst_15565__$1);

(statearr_15710[(69)] = inst_15566__$1);

(statearr_15710[(70)] = inst_15564__$1);

return statearr_15710;
})();
if(inst_15567){
var statearr_15711_15899 = state_15669__$1;
(statearr_15711_15899[(1)] = (98));

} else {
var statearr_15712_15900 = state_15669__$1;
(statearr_15712_15900[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (54))){
var inst_15409 = (state_15669[(10)]);
var inst_15427 = (state_15669[(11)]);
var inst_15451 = (state_15669[(50)]);
var inst_15330 = (state_15669[(15)]);
var inst_15418 = (state_15669[(18)]);
var inst_15323 = (state_15669[(19)]);
var inst_15355 = (state_15669[(22)]);
var inst_15449 = (state_15669[(26)]);
var inst_15324 = (state_15669[(30)]);
var inst_15445 = (state_15669[(31)]);
var inst_15400 = (state_15669[(32)]);
var inst_15436 = (state_15669[(33)]);
var inst_15331 = (state_15669[(40)]);
var inst_15346 = (state_15669[(44)]);
var inst_15445__$1 = (state_15669[(2)]);
var inst_15446 = fluree.db.flake.__GT_Flake(inst_15346,inst_15418,inst_15400,inst_15323,inst_15324,inst_15436);
var inst_15447 = fluree.db.flake.__GT_Flake(inst_15355,inst_15427,inst_15409,inst_15330,inst_15331,inst_15445__$1);
var inst_15448 = opts;
var inst_15449__$1 = cljs.core.__destructure_map(inst_15448);
var inst_15450 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_15449__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_15451__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15449__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_15452 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_15449__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_15669__$1 = (function (){var statearr_15713 = state_15669;
(statearr_15713[(50)] = inst_15451__$1);

(statearr_15713[(17)] = inst_15446);

(statearr_15713[(26)] = inst_15449__$1);

(statearr_15713[(31)] = inst_15445__$1);

(statearr_15713[(36)] = inst_15450);

(statearr_15713[(39)] = inst_15447);

(statearr_15713[(71)] = inst_15452);

return statearr_15713;
})();
if(cljs.core.truth_(inst_15451__$1)){
var statearr_15714_15901 = state_15669__$1;
(statearr_15714_15901[(1)] = (58));

} else {
var statearr_15715_15902 = state_15669__$1;
(statearr_15715_15902[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (92))){
var inst_15545 = (state_15669[(72)]);
var inst_15488 = (state_15669[(21)]);
var inst_15489 = (state_15669[(41)]);
var inst_15487 = (state_15669[(47)]);
var inst_15490 = (state_15669[(48)]);
var inst_15548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15549 = (inst_15487 - inst_15545);
var inst_15550 = [inst_15549,inst_15488,inst_15489,inst_15490];
var inst_15551 = (new cljs.core.PersistentVector(null,4,(5),inst_15548,inst_15550,null));
var state_15669__$1 = state_15669;
var statearr_15716_15903 = state_15669__$1;
(statearr_15716_15903[(2)] = inst_15551);

(statearr_15716_15903[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (104))){
var inst_15607 = (state_15669[(2)]);
var inst_15608 = fluree.db.util.async.throw_err(inst_15607);
var state_15669__$1 = state_15669;
var statearr_15717_15904 = state_15669__$1;
(statearr_15717_15904[(2)] = inst_15608);

(statearr_15717_15904[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (15))){
var inst_15329 = (state_15669[(62)]);
var inst_15359 = cljs.core.boolean_QMARK_(inst_15329);
var state_15669__$1 = state_15669;
if(inst_15359){
var statearr_15718_15905 = state_15669__$1;
(statearr_15718_15905[(1)] = (17));

} else {
var statearr_15719_15906 = state_15669__$1;
(statearr_15719_15906[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (48))){
var inst_15332 = (state_15669[(57)]);
var inst_15436 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15720 = state_15669;
(statearr_15720[(33)] = inst_15436);

return statearr_15720;
})();
if(cljs.core.truth_(inst_15332)){
var statearr_15721_15907 = state_15669__$1;
(statearr_15721_15907[(1)] = (52));

} else {
var statearr_15722_15908 = state_15669__$1;
(statearr_15722_15908[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (50))){
var state_15669__$1 = state_15669;
var statearr_15723_15909 = state_15669__$1;
(statearr_15723_15909[(2)] = (2147483647));

(statearr_15723_15909[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (116))){
var inst_15641 = (state_15669[(66)]);
var inst_15649 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15724 = state_15669;
(statearr_15724[(73)] = inst_15649);

return statearr_15724;
})();
if(cljs.core.truth_(inst_15641)){
var statearr_15725_15910 = state_15669__$1;
(statearr_15725_15910[(1)] = (118));

} else {
var statearr_15726_15911 = state_15669__$1;
(statearr_15726_15911[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (75))){
var inst_15504 = (state_15669[(35)]);
var state_15669__$1 = state_15669;
var statearr_15727_15912 = state_15669__$1;
(statearr_15727_15912[(2)] = inst_15504);

(statearr_15727_15912[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (99))){
var inst_15565 = (state_15669[(68)]);
var inst_15574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15575 = [inst_15565,inst_15565];
var inst_15576 = (new cljs.core.PersistentVector(null,2,(5),inst_15574,inst_15575,null));
var state_15669__$1 = state_15669;
var statearr_15728_15913 = state_15669__$1;
(statearr_15728_15913[(2)] = inst_15576);

(statearr_15728_15913[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (21))){
var state_15669__$1 = state_15669;
var statearr_15729_15914 = state_15669__$1;
(statearr_15729_15914[(2)] = null);

(statearr_15729_15914[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (31))){
var inst_15390 = (state_15669[(74)]);
var state_15669__$1 = state_15669;
var statearr_15730_15915 = state_15669__$1;
(statearr_15730_15915[(2)] = inst_15390);

(statearr_15730_15915[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (113))){
var inst_15635 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15731_15916 = state_15669__$1;
(statearr_15731_15916[(2)] = inst_15635);

(statearr_15731_15916[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (32))){
var inst_15321 = (state_15669[(55)]);
var inst_15410 = (state_15669[(75)]);
var inst_15409 = (state_15669[(2)]);
var inst_15410__$1 = (inst_15321 == null);
var state_15669__$1 = (function (){var statearr_15732 = state_15669;
(statearr_15732[(10)] = inst_15409);

(statearr_15732[(75)] = inst_15410__$1);

return statearr_15732;
})();
if(cljs.core.truth_(inst_15410__$1)){
var statearr_15733_15917 = state_15669__$1;
(statearr_15733_15917[(1)] = (34));

} else {
var statearr_15734_15918 = state_15669__$1;
(statearr_15734_15918[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (40))){
var inst_15409 = (state_15669[(10)]);
var state_15669__$1 = state_15669;
var statearr_15735_15919 = state_15669__$1;
(statearr_15735_15919[(2)] = inst_15409);

(statearr_15735_15919[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (91))){
var inst_15523 = (state_15669[(65)]);
var inst_15621 = (state_15669[(2)]);
var inst_15622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15621,(0),null);
var inst_15623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15621,(1),null);
var inst_15624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15621,(2),null);
var inst_15625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15621,(3),null);
var state_15669__$1 = (function (){var statearr_15736 = state_15669;
(statearr_15736[(76)] = inst_15623);

(statearr_15736[(7)] = inst_15625);

(statearr_15736[(77)] = inst_15624);

(statearr_15736[(78)] = inst_15622);

return statearr_15736;
})();
if(cljs.core.truth_(inst_15523)){
var statearr_15737_15920 = state_15669__$1;
(statearr_15737_15920[(1)] = (105));

} else {
var statearr_15738_15921 = state_15669__$1;
(statearr_15738_15921[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (117))){
var inst_15645 = (state_15669[(2)]);
var inst_15646 = fluree.db.util.async.throw_err(inst_15645);
var state_15669__$1 = state_15669;
var statearr_15739_15922 = state_15669__$1;
(statearr_15739_15922[(2)] = inst_15646);

(statearr_15739_15922[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (108))){
var inst_15623 = (state_15669[(76)]);
var inst_15630 = (state_15669[(79)]);
var inst_15450 = (state_15669[(36)]);
var inst_15630__$1 = (inst_15623 < inst_15450);
var state_15669__$1 = (function (){var statearr_15740 = state_15669;
(statearr_15740[(79)] = inst_15630__$1);

return statearr_15740;
})();
if(cljs.core.truth_(inst_15630__$1)){
var statearr_15741_15923 = state_15669__$1;
(statearr_15741_15923[(1)] = (111));

} else {
var statearr_15742_15924 = state_15669__$1;
(statearr_15742_15924[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (56))){
var state_15669__$1 = state_15669;
var statearr_15743_15925 = state_15669__$1;
(statearr_15743_15925[(2)] = fluree.db.util.core.min_integer);

(statearr_15743_15925[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (33))){
var inst_15405 = (state_15669[(2)]);
var inst_15406 = fluree.db.util.async.throw_err(inst_15405);
var state_15669__$1 = state_15669;
var statearr_15744_15926 = state_15669__$1;
(statearr_15744_15926[(2)] = inst_15406);

(statearr_15744_15926[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (13))){
var inst_15351 = (state_15669[(2)]);
var inst_15352 = fluree.db.util.async.throw_err(inst_15351);
var state_15669__$1 = state_15669;
var statearr_15745_15927 = state_15669__$1;
(statearr_15745_15927[(2)] = inst_15352);

(statearr_15745_15927[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (22))){
var inst_15365 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15746_15928 = state_15669__$1;
(statearr_15746_15928[(2)] = inst_15365);

(statearr_15746_15928[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (90))){
var inst_15545 = (state_15669[(72)]);
var inst_15409 = (state_15669[(10)]);
var inst_15427 = (state_15669[(11)]);
var inst_15335 = (state_15669[(12)]);
var inst_15473 = (state_15669[(13)]);
var inst_15486 = (state_15669[(14)]);
var inst_15330 = (state_15669[(15)]);
var inst_15326 = (state_15669[(16)]);
var inst_15446 = (state_15669[(17)]);
var inst_15418 = (state_15669[(18)]);
var inst_15323 = (state_15669[(19)]);
var inst_15336 = (state_15669[(20)]);
var inst_15522 = (state_15669[(80)]);
var inst_15488 = (state_15669[(21)]);
var inst_15355 = (state_15669[(22)]);
var inst_15319 = (state_15669[(23)]);
var inst_15388 = (state_15669[(24)]);
var inst_15467 = (state_15669[(25)]);
var inst_15449 = (state_15669[(26)]);
var inst_15334 = (state_15669[(27)]);
var inst_15496 = (state_15669[(28)]);
var inst_15458 = (state_15669[(29)]);
var inst_15483 = (state_15669[(9)]);
var inst_15324 = (state_15669[(30)]);
var inst_15445 = (state_15669[(31)]);
var inst_15400 = (state_15669[(32)]);
var inst_15436 = (state_15669[(33)]);
var inst_15462 = (state_15669[(34)]);
var inst_15450 = (state_15669[(36)]);
var inst_15457 = (state_15669[(37)]);
var inst_15387 = (state_15669[(38)]);
var inst_15523 = (state_15669[(65)]);
var inst_15447 = (state_15669[(39)]);
var inst_15331 = (state_15669[(40)]);
var inst_15489 = (state_15669[(41)]);
var inst_15391 = (state_15669[(42)]);
var inst_15477 = (state_15669[(8)]);
var inst_15463 = (state_15669[(43)]);
var inst_15346 = (state_15669[(44)]);
var inst_15456 = (state_15669[(45)]);
var inst_15468 = (state_15669[(46)]);
var inst_15544 = (state_15669[(81)]);
var inst_15487 = (state_15669[(47)]);
var inst_15490 = (state_15669[(48)]);
var inst_15543 = (function (){var no_filter_QMARK_ = inst_15483;
var base_result_SINGLEQUOTE_ = inst_15522;
var t = inst_15463;
var max_limit_QMARK_ = inst_15457;
var next_node = inst_15486;
var fast_forward_db_QMARK_ = inst_15468;
var s1 = inst_15346;
var o2 = inst_15409;
var t1 = inst_15323;
var predicate_fn = inst_15336;
var i = inst_15488;
var rhs = inst_15523;
var m1 = inst_15436;
var root_node = inst_15473;
var s2 = inst_15355;
var p2 = inst_15427;
var vec__15308 = inst_15326;
var permissions = inst_15458;
var limit = inst_15456;
var start_flake = inst_15446;
var vec__15315 = inst_15388;
var flake_limit = inst_15450;
var offset = inst_15487;
var acc = inst_15490;
var t2 = inst_15330;
var op1 = inst_15324;
var vec__15312 = inst_15387;
var o1 = inst_15400;
var end_flake = inst_15447;
var base_result = inst_15496;
var s = inst_15489;
var node_start = inst_15477;
var p1 = inst_15418;
var subject_fn = inst_15335;
var object_fn = inst_15391;
var idx_compare = inst_15462;
var map__15318 = inst_15449;
var op2 = inst_15331;
var m2 = inst_15445;
var map__15311 = inst_15334;
var vec__15305 = inst_15319;
var novelty = inst_15467;
return (function (p1__15290_SHARP_){
return p1__15290_SHARP_.s;
});
})();
var inst_15544__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_15543,inst_15522);
var inst_15545__$1 = cljs.core.count(inst_15544__$1);
var inst_15546 = (inst_15487 > inst_15545__$1);
var state_15669__$1 = (function (){var statearr_15747 = state_15669;
(statearr_15747[(72)] = inst_15545__$1);

(statearr_15747[(81)] = inst_15544__$1);

return statearr_15747;
})();
if(cljs.core.truth_(inst_15546)){
var statearr_15748_15929 = state_15669__$1;
(statearr_15748_15929[(1)] = (92));

} else {
var statearr_15749_15930 = state_15669__$1;
(statearr_15749_15930[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (109))){
var inst_15628 = (state_15669[(82)]);
var state_15669__$1 = state_15669;
var statearr_15750_15931 = state_15669__$1;
(statearr_15750_15931[(2)] = inst_15628);

(statearr_15750_15931[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (36))){
var inst_15414 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
if(cljs.core.truth_(inst_15414)){
var statearr_15751_15932 = state_15669__$1;
(statearr_15751_15932[(1)] = (37));

} else {
var statearr_15752_15933 = state_15669__$1;
(statearr_15752_15933[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (41))){
var inst_15419 = (state_15669[(63)]);
var state_15669__$1 = state_15669;
var statearr_15753_15934 = state_15669__$1;
(statearr_15753_15934[(2)] = inst_15419);

(statearr_15753_15934[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (118))){
var inst_15649 = (state_15669[(73)]);
var state_15669__$1 = state_15669;
var statearr_15754_15935 = state_15669__$1;
(statearr_15754_15935[(2)] = inst_15649);

(statearr_15754_15935[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (89))){
var inst_15522 = (state_15669[(80)]);
var inst_15488 = (state_15669[(21)]);
var inst_15450 = (state_15669[(36)]);
var inst_15489 = (state_15669[(41)]);
var inst_15490 = (state_15669[(48)]);
var inst_15534 = cljs.core.count(inst_15522);
var inst_15535 = (inst_15450 - inst_15488);
var inst_15536 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15535,inst_15522);
var inst_15537 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15490,inst_15536);
var inst_15538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15539 = (inst_15488 + inst_15534);
var inst_15540 = [(0),inst_15539,inst_15489,inst_15537];
var inst_15541 = (new cljs.core.PersistentVector(null,4,(5),inst_15538,inst_15540,null));
var state_15669__$1 = state_15669;
var statearr_15755_15936 = state_15669__$1;
(statearr_15755_15936[(2)] = inst_15541);

(statearr_15755_15936[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (100))){
var inst_15556 = (state_15669[(67)]);
var inst_15488 = (state_15669[(21)]);
var inst_15584 = (state_15669[(52)]);
var inst_15583 = (state_15669[(53)]);
var inst_15450 = (state_15669[(36)]);
var inst_15582 = (state_15669[(54)]);
var inst_15578 = (state_15669[(2)]);
var inst_15579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15578,(0),null);
var inst_15580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15578,(1),null);
var inst_15581 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15580,inst_15556);
var inst_15582__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_15581);
var inst_15583__$1 = cljs.core.count(inst_15582__$1);
var inst_15584__$1 = (inst_15488 + inst_15583__$1);
var inst_15585 = (inst_15584__$1 > inst_15450);
var state_15669__$1 = (function (){var statearr_15756 = state_15669;
(statearr_15756[(52)] = inst_15584__$1);

(statearr_15756[(53)] = inst_15583__$1);

(statearr_15756[(83)] = inst_15579);

(statearr_15756[(54)] = inst_15582__$1);

return statearr_15756;
})();
if(cljs.core.truth_(inst_15585)){
var statearr_15757_15937 = state_15669__$1;
(statearr_15757_15937[(1)] = (101));

} else {
var statearr_15758_15938 = state_15669__$1;
(statearr_15758_15938[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (122))){
var inst_15623 = (state_15669[(76)]);
var inst_15625 = (state_15669[(7)]);
var inst_15624 = (state_15669[(77)]);
var inst_15649 = (state_15669[(73)]);
var inst_15622 = (state_15669[(78)]);
var inst_15486 = inst_15649;
var inst_15487 = inst_15622;
var inst_15488 = inst_15623;
var inst_15489 = inst_15624;
var inst_15490 = inst_15625;
var state_15669__$1 = (function (){var statearr_15759 = state_15669;
(statearr_15759[(14)] = inst_15486);

(statearr_15759[(21)] = inst_15488);

(statearr_15759[(41)] = inst_15489);

(statearr_15759[(47)] = inst_15487);

(statearr_15759[(48)] = inst_15490);

return statearr_15759;
})();
var statearr_15760_15939 = state_15669__$1;
(statearr_15760_15939[(2)] = null);

(statearr_15760_15939[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (43))){
var state_15669__$1 = state_15669;
var statearr_15761_15940 = state_15669__$1;
(statearr_15761_15940[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15761_15940[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (61))){
var inst_15473 = (state_15669[(13)]);
var inst_15446 = (state_15669[(17)]);
var inst_15467 = (state_15669[(25)]);
var inst_15463 = (state_15669[(43)]);
var inst_15468 = (state_15669[(46)]);
var inst_15472 = (state_15669[(2)]);
var inst_15473__$1 = fluree.db.util.async.throw_err(inst_15472);
var inst_15474 = fluree.db.query.range.find_next_valid_node(inst_15473__$1,inst_15446,inst_15463,inst_15467,inst_15468);
var state_15669__$1 = (function (){var statearr_15762 = state_15669;
(statearr_15762[(13)] = inst_15473__$1);

return statearr_15762;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(62),inst_15474);
} else {
if((state_val_15670 === (29))){
var inst_15396 = (state_15669[(2)]);
var inst_15397 = fluree.db.util.async.throw_err(inst_15396);
var state_15669__$1 = state_15669;
var statearr_15763_15941 = state_15669__$1;
(statearr_15763_15941[(2)] = inst_15397);

(statearr_15763_15941[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (44))){
var inst_15328 = (state_15669[(61)]);
var state_15669__$1 = state_15669;
var statearr_15764_15942 = state_15669__$1;
(statearr_15764_15942[(2)] = inst_15328);

(statearr_15764_15942[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (93))){
var inst_15483 = (state_15669[(9)]);
var inst_15544 = (state_15669[(81)]);
var inst_15487 = (state_15669[(47)]);
var inst_15556 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_15487,inst_15544);
var state_15669__$1 = (function (){var statearr_15765 = state_15669;
(statearr_15765[(67)] = inst_15556);

return statearr_15765;
})();
if(cljs.core.truth_(inst_15483)){
var statearr_15766_15943 = state_15669__$1;
(statearr_15766_15943[(1)] = (95));

} else {
var statearr_15767_15944 = state_15669__$1;
(statearr_15767_15944[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (6))){
var inst_15320 = (state_15669[(49)]);
var inst_15340 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15320);
var state_15669__$1 = state_15669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(9),inst_15340);
} else {
if((state_val_15670 === (111))){
var inst_15624 = (state_15669[(77)]);
var inst_15456 = (state_15669[(45)]);
var inst_15632 = (inst_15624 < inst_15456);
var state_15669__$1 = state_15669;
var statearr_15768_15945 = state_15669__$1;
(statearr_15768_15945[(2)] = inst_15632);

(statearr_15768_15945[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (28))){
var inst_15390 = (state_15669[(74)]);
var inst_15400 = (state_15669[(2)]);
var inst_15401 = fluree.db.util.core.pred_ident_QMARK_(inst_15390);
var state_15669__$1 = (function (){var statearr_15769 = state_15669;
(statearr_15769[(32)] = inst_15400);

return statearr_15769;
})();
if(inst_15401){
var statearr_15770_15946 = state_15669__$1;
(statearr_15770_15946[(1)] = (30));

} else {
var statearr_15771_15947 = state_15669__$1;
(statearr_15771_15947[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (64))){
var state_15669__$1 = state_15669;
var statearr_15772_15948 = state_15669__$1;
(statearr_15772_15948[(2)] = true);

(statearr_15772_15948[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (103))){
var inst_15579 = (state_15669[(83)]);
var inst_15598 = (state_15669[(2)]);
var inst_15599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15598,(0),null);
var inst_15600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15598,(1),null);
var inst_15601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15602 = [inst_15599,inst_15579,inst_15600];
var inst_15603 = (new cljs.core.PersistentVector(null,3,(5),inst_15601,inst_15602,null));
var state_15669__$1 = state_15669;
var statearr_15773_15949 = state_15669__$1;
(statearr_15773_15949[(2)] = inst_15603);

(statearr_15773_15949[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (51))){
var inst_15434 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15774_15950 = state_15669__$1;
(statearr_15774_15950[(2)] = inst_15434);

(statearr_15774_15950[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (25))){
var inst_15388 = (state_15669[(24)]);
var inst_15389 = (state_15669[(51)]);
var inst_15387 = (state_15669[(38)]);
var inst_15387__$1 = (state_15669[(2)]);
var inst_15388__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15387__$1,(0),null);
var inst_15389__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15388__$1,(0),null);
var inst_15390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15388__$1,(1),null);
var inst_15391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15387__$1,(1),null);
var inst_15392 = fluree.db.util.core.pred_ident_QMARK_(inst_15389__$1);
var state_15669__$1 = (function (){var statearr_15775 = state_15669;
(statearr_15775[(24)] = inst_15388__$1);

(statearr_15775[(51)] = inst_15389__$1);

(statearr_15775[(38)] = inst_15387__$1);

(statearr_15775[(74)] = inst_15390);

(statearr_15775[(42)] = inst_15391);

return statearr_15775;
})();
if(inst_15392){
var statearr_15776_15951 = state_15669__$1;
(statearr_15776_15951[(1)] = (26));

} else {
var statearr_15777_15952 = state_15669__$1;
(statearr_15777_15952[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (34))){
var inst_15400 = (state_15669[(32)]);
var state_15669__$1 = state_15669;
var statearr_15778_15953 = state_15669__$1;
(statearr_15778_15953[(2)] = inst_15400);

(statearr_15778_15953[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (17))){
var inst_15329 = (state_15669[(62)]);
var state_15669__$1 = state_15669;
var statearr_15779_15954 = state_15669__$1;
(statearr_15779_15954[(2)] = inst_15329);

(statearr_15779_15954[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (3))){
var inst_15667 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15669__$1,inst_15667);
} else {
if((state_val_15670 === (12))){
var inst_15322 = (state_15669[(59)]);
var inst_15355 = (state_15669[(2)]);
var inst_15356 = cljs.core.boolean_QMARK_(inst_15322);
var state_15669__$1 = (function (){var statearr_15780 = state_15669;
(statearr_15780[(22)] = inst_15355);

return statearr_15780;
})();
if(inst_15356){
var statearr_15781_15955 = state_15669__$1;
(statearr_15781_15955[(1)] = (14));

} else {
var statearr_15782_15956 = state_15669__$1;
(statearr_15782_15956[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (2))){
var inst_15326 = (state_15669[(16)]);
var inst_15319 = (state_15669[(23)]);
var inst_15334 = (state_15669[(27)]);
var inst_15320 = (state_15669[(49)]);
var _ = (function (){var statearr_15783 = state_15669;
(statearr_15783[(4)] = cljs.core.cons((5),(state_15669[(4)])));

return statearr_15783;
})();
var inst_15319__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_15320__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15319__$1,(0),null);
var inst_15321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15319__$1,(1),null);
var inst_15322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15319__$1,(2),null);
var inst_15323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15319__$1,(3),null);
var inst_15324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15319__$1,(4),null);
var inst_15325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15319__$1,(5),null);
var inst_15326__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_15327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15326__$1,(0),null);
var inst_15328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15326__$1,(1),null);
var inst_15329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15326__$1,(2),null);
var inst_15330 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15326__$1,(3),null);
var inst_15331 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15326__$1,(4),null);
var inst_15332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15326__$1,(5),null);
var inst_15333 = opts;
var inst_15334__$1 = cljs.core.__destructure_map(inst_15333);
var inst_15335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15334__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_15336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15334__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_15337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15334__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_15338 = fluree.db.util.core.pred_ident_QMARK_(inst_15320__$1);
var state_15669__$1 = (function (){var statearr_15784 = state_15669;
(statearr_15784[(12)] = inst_15335);

(statearr_15784[(15)] = inst_15330);

(statearr_15784[(16)] = inst_15326__$1);

(statearr_15784[(55)] = inst_15321);

(statearr_15784[(19)] = inst_15323);

(statearr_15784[(20)] = inst_15336);

(statearr_15784[(23)] = inst_15319__$1);

(statearr_15784[(57)] = inst_15332);

(statearr_15784[(27)] = inst_15334__$1);

(statearr_15784[(49)] = inst_15320__$1);

(statearr_15784[(58)] = inst_15337);

(statearr_15784[(30)] = inst_15324);

(statearr_15784[(59)] = inst_15322);

(statearr_15784[(60)] = inst_15325);

(statearr_15784[(84)] = inst_15327);

(statearr_15784[(61)] = inst_15328);

(statearr_15784[(40)] = inst_15331);

(statearr_15784[(62)] = inst_15329);

return statearr_15784;
})();
if(inst_15338){
var statearr_15785_15957 = state_15669__$1;
(statearr_15785_15957[(1)] = (6));

} else {
var statearr_15786_15958 = state_15669__$1;
(statearr_15786_15958[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (66))){
var inst_15477 = (state_15669[(8)]);
var inst_15452 = (state_15669[(71)]);
var inst_15485 = cljs.core.PersistentVector.EMPTY;
var inst_15486 = inst_15477;
var inst_15487 = inst_15452;
var inst_15488 = (0);
var inst_15489 = (0);
var inst_15490 = inst_15485;
var state_15669__$1 = (function (){var statearr_15787 = state_15669;
(statearr_15787[(14)] = inst_15486);

(statearr_15787[(21)] = inst_15488);

(statearr_15787[(41)] = inst_15489);

(statearr_15787[(47)] = inst_15487);

(statearr_15787[(48)] = inst_15490);

return statearr_15787;
})();
var statearr_15788_15959 = state_15669__$1;
(statearr_15788_15959[(2)] = null);

(statearr_15788_15959[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (107))){
var inst_15641 = (state_15669[(66)]);
var inst_15641__$1 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15789 = state_15669;
(statearr_15789[(66)] = inst_15641__$1);

return statearr_15789;
})();
if(cljs.core.truth_(inst_15641__$1)){
var statearr_15790_15960 = state_15669__$1;
(statearr_15790_15960[(1)] = (114));

} else {
var statearr_15791_15961 = state_15669__$1;
(statearr_15791_15961[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (23))){
var inst_15337 = (state_15669[(58)]);
var inst_15322 = (state_15669[(59)]);
var inst_15329 = (state_15669[(62)]);
var inst_15372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15374 = [inst_15322,inst_15329];
var inst_15375 = (new cljs.core.PersistentVector(null,2,(5),inst_15373,inst_15374,null));
var inst_15376 = [inst_15375,inst_15337];
var inst_15377 = (new cljs.core.PersistentVector(null,2,(5),inst_15372,inst_15376,null));
var state_15669__$1 = state_15669;
var statearr_15792_15962 = state_15669__$1;
(statearr_15792_15962[(2)] = inst_15377);

(statearr_15792_15962[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (47))){
var inst_15430 = (cljs.core._GT__EQ_ === start_test);
var state_15669__$1 = state_15669;
if(cljs.core.truth_(inst_15430)){
var statearr_15793_15963 = state_15669__$1;
(statearr_15793_15963[(1)] = (49));

} else {
var statearr_15794_15964 = state_15669__$1;
(statearr_15794_15964[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (35))){
var inst_15410 = (state_15669[(75)]);
var state_15669__$1 = state_15669;
var statearr_15795_15965 = state_15669__$1;
(statearr_15795_15965[(2)] = inst_15410);

(statearr_15795_15965[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (82))){
var inst_15486 = (state_15669[(14)]);
var inst_15457 = (state_15669[(37)]);
var inst_15522 = (state_15669[(2)]);
var inst_15523 = fluree.db.dbproto._rhs(inst_15486);
var state_15669__$1 = (function (){var statearr_15796 = state_15669;
(statearr_15796[(80)] = inst_15522);

(statearr_15796[(65)] = inst_15523);

return statearr_15796;
})();
if(cljs.core.truth_(inst_15457)){
var statearr_15797_15966 = state_15669__$1;
(statearr_15797_15966[(1)] = (83));

} else {
var statearr_15798_15967 = state_15669__$1;
(statearr_15798_15967[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (76))){
var inst_15336 = (state_15669[(20)]);
var inst_15510 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15799 = state_15669;
(statearr_15799[(64)] = inst_15510);

return statearr_15799;
})();
if(cljs.core.truth_(inst_15336)){
var statearr_15800_15968 = state_15669__$1;
(statearr_15800_15968[(1)] = (77));

} else {
var statearr_15801_15969 = state_15669__$1;
(statearr_15801_15969[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (97))){
var inst_15490 = (state_15669[(48)]);
var inst_15610 = (state_15669[(2)]);
var inst_15611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15610,(0),null);
var inst_15612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15610,(1),null);
var inst_15613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15610,(2),null);
var inst_15614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15615 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15490,inst_15613);
var inst_15616 = [(0),inst_15611,inst_15612,inst_15615];
var inst_15617 = (new cljs.core.PersistentVector(null,4,(5),inst_15614,inst_15616,null));
var state_15669__$1 = state_15669;
var statearr_15802_15970 = state_15669__$1;
(statearr_15802_15970[(2)] = inst_15617);

(statearr_15802_15970[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (19))){
var inst_15367 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15803_15971 = state_15669__$1;
(statearr_15803_15971[(2)] = inst_15367);

(statearr_15803_15971[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (57))){
var inst_15443 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15804_15972 = state_15669__$1;
(statearr_15804_15972[(2)] = inst_15443);

(statearr_15804_15972[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (68))){
var inst_15664 = (state_15669[(2)]);
var _ = (function (){var statearr_15805 = state_15669;
(statearr_15805[(4)] = cljs.core.rest((state_15669[(4)])));

return statearr_15805;
})();
var state_15669__$1 = state_15669;
var statearr_15806_15973 = state_15669__$1;
(statearr_15806_15973[(2)] = inst_15664);

(statearr_15806_15973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (11))){
var inst_15327 = (state_15669[(84)]);
var state_15669__$1 = state_15669;
var statearr_15807_15974 = state_15669__$1;
(statearr_15807_15974[(2)] = inst_15327);

(statearr_15807_15974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (115))){
var state_15669__$1 = state_15669;
var statearr_15809_15975 = state_15669__$1;
(statearr_15809_15975[(2)] = null);

(statearr_15809_15975[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (9))){
var inst_15342 = (state_15669[(2)]);
var inst_15343 = fluree.db.util.async.throw_err(inst_15342);
var state_15669__$1 = state_15669;
var statearr_15810_15976 = state_15669__$1;
(statearr_15810_15976[(2)] = inst_15343);

(statearr_15810_15976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (5))){
var _ = (function (){var statearr_15811 = state_15669;
(statearr_15811[(4)] = cljs.core.rest((state_15669[(4)])));

return statearr_15811;
})();
var state_15669__$1 = state_15669;
var ex15808 = (state_15669__$1[(2)]);
var statearr_15812_15977 = state_15669__$1;
(statearr_15812_15977[(5)] = ex15808);


if((ex15808 instanceof Error)){
var statearr_15813_15978 = state_15669__$1;
(statearr_15813_15978[(1)] = (4));

(statearr_15813_15978[(5)] = null);

} else {
throw ex15808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (112))){
var inst_15630 = (state_15669[(79)]);
var state_15669__$1 = state_15669;
var statearr_15814_15979 = state_15669__$1;
(statearr_15814_15979[(2)] = inst_15630);

(statearr_15814_15979[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (83))){
var inst_15525 = (state_15669[(85)]);
var inst_15487 = (state_15669[(47)]);
var inst_15525__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_15487);
var state_15669__$1 = (function (){var statearr_15815 = state_15669;
(statearr_15815[(85)] = inst_15525__$1);

return statearr_15815;
})();
if(inst_15525__$1){
var statearr_15816_15980 = state_15669__$1;
(statearr_15816_15980[(1)] = (86));

} else {
var statearr_15817_15981 = state_15669__$1;
(statearr_15817_15981[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (14))){
var inst_15322 = (state_15669[(59)]);
var state_15669__$1 = state_15669;
var statearr_15818_15982 = state_15669__$1;
(statearr_15818_15982[(2)] = inst_15322);

(statearr_15818_15982[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (45))){
var inst_15325 = (state_15669[(60)]);
var inst_15427 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15819 = state_15669;
(statearr_15819[(11)] = inst_15427);

return statearr_15819;
})();
if(cljs.core.truth_(inst_15325)){
var statearr_15820_15983 = state_15669__$1;
(statearr_15820_15983[(1)] = (46));

} else {
var statearr_15821_15984 = state_15669__$1;
(statearr_15821_15984[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (53))){
var inst_15439 = (cljs.core._LT__EQ_ === end_test);
var state_15669__$1 = state_15669;
if(cljs.core.truth_(inst_15439)){
var statearr_15822_15985 = state_15669__$1;
(statearr_15822_15985[(1)] = (55));

} else {
var statearr_15823_15986 = state_15669__$1;
(statearr_15823_15986[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (78))){
var inst_15510 = (state_15669[(64)]);
var state_15669__$1 = state_15669;
var statearr_15824_15987 = state_15669__$1;
(statearr_15824_15987[(2)] = inst_15510);

(statearr_15824_15987[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (26))){
var inst_15389 = (state_15669[(51)]);
var inst_15394 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15389);
var state_15669__$1 = state_15669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(29),inst_15394);
} else {
if((state_val_15670 === (123))){
var inst_15659 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15825_15988 = state_15669__$1;
(statearr_15825_15988[(2)] = inst_15659);

(statearr_15825_15988[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (16))){
var inst_15369 = (state_15669[(56)]);
var inst_15369__$1 = (state_15669[(2)]);
var inst_15370 = (inst_15369__$1 == null);
var state_15669__$1 = (function (){var statearr_15826 = state_15669;
(statearr_15826[(56)] = inst_15369__$1);

return statearr_15826;
})();
if(cljs.core.truth_(inst_15370)){
var statearr_15827_15989 = state_15669__$1;
(statearr_15827_15989[(1)] = (23));

} else {
var statearr_15828_15990 = state_15669__$1;
(statearr_15828_15990[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (81))){
var inst_15516 = (state_15669[(86)]);
var state_15669__$1 = state_15669;
var statearr_15829_15991 = state_15669__$1;
(statearr_15829_15991[(2)] = inst_15516);

(statearr_15829_15991[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (120))){
var inst_15653 = (state_15669[(2)]);
var inst_15654 = cljs.core.not(inst_15653);
var state_15669__$1 = state_15669;
if(inst_15654){
var statearr_15830_15992 = state_15669__$1;
(statearr_15830_15992[(1)] = (121));

} else {
var statearr_15831_15993 = state_15669__$1;
(statearr_15831_15993[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (79))){
var inst_15391 = (state_15669[(42)]);
var inst_15516 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15832 = state_15669;
(statearr_15832[(86)] = inst_15516);

return statearr_15832;
})();
if(cljs.core.truth_(inst_15391)){
var statearr_15833_15994 = state_15669__$1;
(statearr_15833_15994[(1)] = (80));

} else {
var statearr_15834_15995 = state_15669__$1;
(statearr_15834_15995[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (38))){
var inst_15321 = (state_15669[(55)]);
var state_15669__$1 = state_15669;
var statearr_15835_15996 = state_15669__$1;
(statearr_15835_15996[(2)] = inst_15321);

(statearr_15835_15996[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (98))){
var inst_15566 = (state_15669[(69)]);
var inst_15564 = (state_15669[(70)]);
var inst_15456 = (state_15669[(45)]);
var inst_15569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15570 = (inst_15564 - inst_15566);
var inst_15571 = [inst_15456,inst_15570];
var inst_15572 = (new cljs.core.PersistentVector(null,2,(5),inst_15569,inst_15571,null));
var state_15669__$1 = state_15669;
var statearr_15836_15997 = state_15669__$1;
(statearr_15836_15997[(2)] = inst_15572);

(statearr_15836_15997[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (87))){
var inst_15525 = (state_15669[(85)]);
var state_15669__$1 = state_15669;
var statearr_15837_15998 = state_15669__$1;
(statearr_15837_15998[(2)] = inst_15525);

(statearr_15837_15998[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (30))){
var inst_15390 = (state_15669[(74)]);
var inst_15403 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15390);
var state_15669__$1 = state_15669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(33),inst_15403);
} else {
if((state_val_15670 === (73))){
var inst_15335 = (state_15669[(12)]);
var inst_15504 = (state_15669[(2)]);
var state_15669__$1 = (function (){var statearr_15838 = state_15669;
(statearr_15838[(35)] = inst_15504);

return statearr_15838;
})();
if(cljs.core.truth_(inst_15335)){
var statearr_15839_15999 = state_15669__$1;
(statearr_15839_15999[(1)] = (74));

} else {
var statearr_15840_16000 = state_15669__$1;
(statearr_15840_16000[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (96))){
var inst_15556 = (state_15669[(67)]);
var inst_15488 = (state_15669[(21)]);
var inst_15450 = (state_15669[(36)]);
var inst_15489 = (state_15669[(41)]);
var inst_15456 = (state_15669[(45)]);
var inst_15605 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_15556,inst_15488,inst_15489,inst_15450,inst_15456);
var state_15669__$1 = state_15669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(104),inst_15605);
} else {
if((state_val_15670 === (10))){
var inst_15327 = (state_15669[(84)]);
var inst_15349 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_15327);
var state_15669__$1 = state_15669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(13),inst_15349);
} else {
if((state_val_15670 === (18))){
var state_15669__$1 = state_15669;
var statearr_15841_16001 = state_15669__$1;
(statearr_15841_16001[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (105))){
var inst_15628 = (state_15669[(82)]);
var inst_15462 = (state_15669[(34)]);
var inst_15523 = (state_15669[(65)]);
var inst_15447 = (state_15669[(39)]);
var inst_15627 = (inst_15462.cljs$core$IFn$_invoke$arity$2 ? inst_15462.cljs$core$IFn$_invoke$arity$2(inst_15523,inst_15447) : inst_15462.call(null,inst_15523,inst_15447));
var inst_15628__$1 = (inst_15627 < (0));
var state_15669__$1 = (function (){var statearr_15843 = state_15669;
(statearr_15843[(82)] = inst_15628__$1);

return statearr_15843;
})();
if(cljs.core.truth_(inst_15628__$1)){
var statearr_15844_16002 = state_15669__$1;
(statearr_15844_16002[(1)] = (108));

} else {
var statearr_15845_16003 = state_15669__$1;
(statearr_15845_16003[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (52))){
var inst_15332 = (state_15669[(57)]);
var state_15669__$1 = state_15669;
var statearr_15846_16004 = state_15669__$1;
(statearr_15846_16004[(2)] = inst_15332);

(statearr_15846_16004[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (114))){
var inst_15473 = (state_15669[(13)]);
var inst_15467 = (state_15669[(25)]);
var inst_15523 = (state_15669[(65)]);
var inst_15463 = (state_15669[(43)]);
var inst_15468 = (state_15669[(46)]);
var inst_15643 = fluree.db.query.range.find_next_valid_node(inst_15473,inst_15523,inst_15463,inst_15467,inst_15468);
var state_15669__$1 = state_15669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15669__$1,(117),inst_15643);
} else {
if((state_val_15670 === (67))){
var state_15669__$1 = state_15669;
var statearr_15847_16005 = state_15669__$1;
(statearr_15847_16005[(2)] = null);

(statearr_15847_16005[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (71))){
var inst_15409 = (state_15669[(10)]);
var inst_15427 = (state_15669[(11)]);
var inst_15335 = (state_15669[(12)]);
var inst_15473 = (state_15669[(13)]);
var inst_15486 = (state_15669[(14)]);
var inst_15330 = (state_15669[(15)]);
var inst_15326 = (state_15669[(16)]);
var inst_15446 = (state_15669[(17)]);
var inst_15418 = (state_15669[(18)]);
var inst_15323 = (state_15669[(19)]);
var inst_15336 = (state_15669[(20)]);
var inst_15488 = (state_15669[(21)]);
var inst_15355 = (state_15669[(22)]);
var inst_15319 = (state_15669[(23)]);
var inst_15388 = (state_15669[(24)]);
var inst_15467 = (state_15669[(25)]);
var inst_15449 = (state_15669[(26)]);
var inst_15334 = (state_15669[(27)]);
var inst_15496 = (state_15669[(28)]);
var inst_15458 = (state_15669[(29)]);
var inst_15483 = (state_15669[(9)]);
var inst_15324 = (state_15669[(30)]);
var inst_15445 = (state_15669[(31)]);
var inst_15400 = (state_15669[(32)]);
var inst_15436 = (state_15669[(33)]);
var inst_15462 = (state_15669[(34)]);
var inst_15450 = (state_15669[(36)]);
var inst_15457 = (state_15669[(37)]);
var inst_15387 = (state_15669[(38)]);
var inst_15447 = (state_15669[(39)]);
var inst_15331 = (state_15669[(40)]);
var inst_15489 = (state_15669[(41)]);
var inst_15391 = (state_15669[(42)]);
var inst_15477 = (state_15669[(8)]);
var inst_15463 = (state_15669[(43)]);
var inst_15346 = (state_15669[(44)]);
var inst_15456 = (state_15669[(45)]);
var inst_15468 = (state_15669[(46)]);
var inst_15487 = (state_15669[(47)]);
var inst_15490 = (state_15669[(48)]);
var inst_15500 = (function (){var no_filter_QMARK_ = inst_15483;
var t = inst_15463;
var max_limit_QMARK_ = inst_15457;
var next_node = inst_15486;
var fast_forward_db_QMARK_ = inst_15468;
var s1 = inst_15346;
var o2 = inst_15409;
var t1 = inst_15323;
var predicate_fn = inst_15336;
var i = inst_15488;
var m1 = inst_15436;
var root_node = inst_15473;
var s2 = inst_15355;
var p2 = inst_15427;
var vec__15308 = inst_15326;
var permissions = inst_15458;
var limit = inst_15456;
var start_flake = inst_15446;
var vec__15315 = inst_15388;
var flake_limit = inst_15450;
var offset = inst_15487;
var acc = inst_15490;
var G__15497 = inst_15496;
var t2 = inst_15330;
var op1 = inst_15324;
var vec__15312 = inst_15387;
var o1 = inst_15400;
var end_flake = inst_15447;
var base_result = inst_15496;
var s = inst_15489;
var node_start = inst_15477;
var p1 = inst_15418;
var subject_fn = inst_15335;
var object_fn = inst_15391;
var idx_compare = inst_15462;
var map__15318 = inst_15449;
var op2 = inst_15331;
var m2 = inst_15445;
var map__15311 = inst_15334;
var vec__15305 = inst_15319;
var novelty = inst_15467;
return (function (p1__15286_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15286_SHARP_.o,start_flake.o);
});
})();
var inst_15501 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15500,inst_15496);
var state_15669__$1 = state_15669;
var statearr_15848_16006 = state_15669__$1;
(statearr_15848_16006[(2)] = inst_15501);

(statearr_15848_16006[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (42))){
var inst_15423 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
if(cljs.core.truth_(inst_15423)){
var statearr_15849_16007 = state_15669__$1;
(statearr_15849_16007[(1)] = (43));

} else {
var statearr_15850_16008 = state_15669__$1;
(statearr_15850_16008[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (80))){
var inst_15409 = (state_15669[(10)]);
var inst_15427 = (state_15669[(11)]);
var inst_15335 = (state_15669[(12)]);
var inst_15473 = (state_15669[(13)]);
var inst_15486 = (state_15669[(14)]);
var inst_15330 = (state_15669[(15)]);
var inst_15326 = (state_15669[(16)]);
var inst_15446 = (state_15669[(17)]);
var inst_15418 = (state_15669[(18)]);
var inst_15323 = (state_15669[(19)]);
var inst_15336 = (state_15669[(20)]);
var inst_15488 = (state_15669[(21)]);
var inst_15355 = (state_15669[(22)]);
var inst_15319 = (state_15669[(23)]);
var inst_15388 = (state_15669[(24)]);
var inst_15467 = (state_15669[(25)]);
var inst_15449 = (state_15669[(26)]);
var inst_15334 = (state_15669[(27)]);
var inst_15496 = (state_15669[(28)]);
var inst_15458 = (state_15669[(29)]);
var inst_15483 = (state_15669[(9)]);
var inst_15516 = (state_15669[(86)]);
var inst_15324 = (state_15669[(30)]);
var inst_15445 = (state_15669[(31)]);
var inst_15400 = (state_15669[(32)]);
var inst_15436 = (state_15669[(33)]);
var inst_15462 = (state_15669[(34)]);
var inst_15450 = (state_15669[(36)]);
var inst_15457 = (state_15669[(37)]);
var inst_15387 = (state_15669[(38)]);
var inst_15447 = (state_15669[(39)]);
var inst_15331 = (state_15669[(40)]);
var inst_15489 = (state_15669[(41)]);
var inst_15391 = (state_15669[(42)]);
var inst_15477 = (state_15669[(8)]);
var inst_15463 = (state_15669[(43)]);
var inst_15346 = (state_15669[(44)]);
var inst_15456 = (state_15669[(45)]);
var inst_15468 = (state_15669[(46)]);
var inst_15487 = (state_15669[(47)]);
var inst_15490 = (state_15669[(48)]);
var inst_15518 = (function (){var no_filter_QMARK_ = inst_15483;
var t = inst_15463;
var max_limit_QMARK_ = inst_15457;
var next_node = inst_15486;
var fast_forward_db_QMARK_ = inst_15468;
var s1 = inst_15346;
var o2 = inst_15409;
var t1 = inst_15323;
var predicate_fn = inst_15336;
var i = inst_15488;
var m1 = inst_15436;
var root_node = inst_15473;
var s2 = inst_15355;
var p2 = inst_15427;
var vec__15308 = inst_15326;
var permissions = inst_15458;
var limit = inst_15456;
var start_flake = inst_15446;
var vec__15315 = inst_15388;
var flake_limit = inst_15450;
var offset = inst_15487;
var acc = inst_15490;
var G__15497 = inst_15516;
var t2 = inst_15330;
var op1 = inst_15324;
var vec__15312 = inst_15387;
var o1 = inst_15400;
var end_flake = inst_15447;
var base_result = inst_15496;
var s = inst_15489;
var node_start = inst_15477;
var p1 = inst_15418;
var subject_fn = inst_15335;
var object_fn = inst_15391;
var idx_compare = inst_15462;
var map__15318 = inst_15449;
var op2 = inst_15331;
var m2 = inst_15445;
var map__15311 = inst_15334;
var vec__15305 = inst_15319;
var novelty = inst_15467;
return (function (p1__15289_SHARP_){
var G__15851 = p1__15289_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15851) : object_fn.call(null,G__15851));
});
})();
var inst_15519 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15518,inst_15516);
var state_15669__$1 = state_15669;
var statearr_15852_16009 = state_15669__$1;
(statearr_15852_16009[(2)] = inst_15519);

(statearr_15852_16009[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (37))){
var state_15669__$1 = state_15669;
var statearr_15853_16010 = state_15669__$1;
(statearr_15853_16010[(2)] = (-1));

(statearr_15853_16010[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (63))){
var inst_15427 = (state_15669[(11)]);
var inst_15418 = (state_15669[(18)]);
var inst_15355 = (state_15669[(22)]);
var inst_15458 = (state_15669[(29)]);
var inst_15346 = (state_15669[(44)]);
var inst_15480 = fluree.db.permissions_validate.no_filter_QMARK_(inst_15458,inst_15346,inst_15355,inst_15418,inst_15427);
var state_15669__$1 = state_15669;
var statearr_15854_16011 = state_15669__$1;
(statearr_15854_16011[(2)] = inst_15480);

(statearr_15854_16011[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (94))){
var inst_15619 = (state_15669[(2)]);
var state_15669__$1 = state_15669;
var statearr_15855_16012 = state_15669__$1;
(statearr_15855_16012[(2)] = inst_15619);

(statearr_15855_16012[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (8))){
var inst_15327 = (state_15669[(84)]);
var inst_15346 = (state_15669[(2)]);
var inst_15347 = fluree.db.util.core.pred_ident_QMARK_(inst_15327);
var state_15669__$1 = (function (){var statearr_15856 = state_15669;
(statearr_15856[(44)] = inst_15346);

return statearr_15856;
})();
if(inst_15347){
var statearr_15857_16013 = state_15669__$1;
(statearr_15857_16013[(1)] = (10));

} else {
var statearr_15858_16014 = state_15669__$1;
(statearr_15858_16014[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (49))){
var state_15669__$1 = state_15669;
var statearr_15859_16015 = state_15669__$1;
(statearr_15859_16015[(2)] = fluree.db.util.core.min_integer);

(statearr_15859_16015[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15670 === (84))){
var inst_15457 = (state_15669[(37)]);
var state_15669__$1 = state_15669;
var statearr_15860_16016 = state_15669__$1;
(statearr_15860_16016[(2)] = inst_15457);

(statearr_15860_16016[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15861[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15861[(1)] = (1));

return statearr_15861;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15669){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15669);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15862){var ex__2687__auto__ = e15862;
var statearr_15863_16017 = state_15669;
(statearr_15863_16017[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15669[(4)]))){
var statearr_15864_16018 = state_15669;
(statearr_15864_16018[(1)] = cljs.core.first((state_15669[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16019 = state_15669;
state_15669 = G__16019;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15669){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15865 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15865[(6)] = c__2706__auto__);

return statearr_15865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16075){
var state_val_16076 = (state_16075[(1)]);
if((state_val_16076 === (7))){
var inst_16039 = (state_16075[(7)]);
var inst_16049 = (state_16075[(8)]);
var inst_16047 = fluree.db.flake.Flake__GT_parts(inst_16039);
var inst_16048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16047,(0),null);
var inst_16049__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16047,(1),null);
var inst_16050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16047,(2),null);
var inst_16051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16047,(3),null);
var inst_16052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16047,(4),null);
var inst_16053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16047,(5),null);
var inst_16054 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_16050,inst_16049__$1);
var state_16075__$1 = (function (){var statearr_16077 = state_16075;
(statearr_16077[(9)] = inst_16048);

(statearr_16077[(10)] = inst_16053);

(statearr_16077[(11)] = inst_16052);

(statearr_16077[(8)] = inst_16049__$1);

(statearr_16077[(12)] = inst_16051);

return statearr_16077;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16075__$1,(10),inst_16054);
} else {
if((state_val_16076 === (1))){
var inst_16027 = flakes;
var inst_16028 = cljs.core.seq(inst_16027);
var inst_16029 = cljs.core.first(inst_16028);
var inst_16030 = cljs.core.next(inst_16028);
var inst_16031 = cljs.core.PersistentVector.EMPTY;
var inst_16032 = inst_16027;
var inst_16033 = inst_16031;
var state_16075__$1 = (function (){var statearr_16078 = state_16075;
(statearr_16078[(13)] = inst_16029);

(statearr_16078[(14)] = inst_16033);

(statearr_16078[(15)] = inst_16032);

(statearr_16078[(16)] = inst_16030);

return statearr_16078;
})();
var statearr_16079_16097 = state_16075__$1;
(statearr_16079_16097[(2)] = null);

(statearr_16079_16097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16076 === (4))){
var inst_16039 = (state_16075[(7)]);
var inst_16042 = fluree.db.query.range.is_tag_flake_QMARK_(inst_16039);
var state_16075__$1 = state_16075;
if(inst_16042){
var statearr_16080_16098 = state_16075__$1;
(statearr_16080_16098[(1)] = (7));

} else {
var statearr_16081_16099 = state_16075__$1;
(statearr_16081_16099[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16076 === (6))){
var inst_16071 = (state_16075[(2)]);
var state_16075__$1 = state_16075;
var statearr_16082_16100 = state_16075__$1;
(statearr_16082_16100[(2)] = inst_16071);

(statearr_16082_16100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16076 === (3))){
var inst_16073 = (state_16075[(2)]);
var state_16075__$1 = state_16075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16075__$1,inst_16073);
} else {
if((state_val_16076 === (2))){
var inst_16039 = (state_16075[(7)]);
var inst_16032 = (state_16075[(15)]);
var inst_16038 = cljs.core.seq(inst_16032);
var inst_16039__$1 = cljs.core.first(inst_16038);
var inst_16040 = cljs.core.next(inst_16038);
var state_16075__$1 = (function (){var statearr_16083 = state_16075;
(statearr_16083[(7)] = inst_16039__$1);

(statearr_16083[(17)] = inst_16040);

return statearr_16083;
})();
if(cljs.core.truth_(inst_16039__$1)){
var statearr_16084_16101 = state_16075__$1;
(statearr_16084_16101[(1)] = (4));

} else {
var statearr_16085_16102 = state_16075__$1;
(statearr_16085_16102[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16076 === (9))){
var inst_16068 = (state_16075[(2)]);
var state_16075__$1 = state_16075;
var statearr_16086_16103 = state_16075__$1;
(statearr_16086_16103[(2)] = inst_16068);

(statearr_16086_16103[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16076 === (5))){
var inst_16033 = (state_16075[(14)]);
var state_16075__$1 = state_16075;
var statearr_16087_16104 = state_16075__$1;
(statearr_16087_16104[(2)] = inst_16033);

(statearr_16087_16104[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16076 === (10))){
var inst_16048 = (state_16075[(9)]);
var inst_16033 = (state_16075[(14)]);
var inst_16053 = (state_16075[(10)]);
var inst_16052 = (state_16075[(11)]);
var inst_16049 = (state_16075[(8)]);
var inst_16051 = (state_16075[(12)]);
var inst_16040 = (state_16075[(17)]);
var inst_16056 = (state_16075[(2)]);
var inst_16057 = fluree.db.util.async.throw_err(inst_16056);
var inst_16058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16059 = [inst_16048,inst_16049,inst_16057,inst_16051,inst_16052,inst_16053];
var inst_16060 = (new cljs.core.PersistentVector(null,6,(5),inst_16058,inst_16059,null));
var inst_16061 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_16060);
var inst_16062 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_16033,inst_16061);
var inst_16032 = inst_16040;
var inst_16033__$1 = inst_16062;
var state_16075__$1 = (function (){var statearr_16088 = state_16075;
(statearr_16088[(14)] = inst_16033__$1);

(statearr_16088[(15)] = inst_16032);

return statearr_16088;
})();
var statearr_16089_16105 = state_16075__$1;
(statearr_16089_16105[(2)] = null);

(statearr_16089_16105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16076 === (8))){
var inst_16033 = (state_16075[(14)]);
var inst_16039 = (state_16075[(7)]);
var inst_16040 = (state_16075[(17)]);
var inst_16065 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_16033,inst_16039);
var inst_16032 = inst_16040;
var inst_16033__$1 = inst_16065;
var state_16075__$1 = (function (){var statearr_16090 = state_16075;
(statearr_16090[(14)] = inst_16033__$1);

(statearr_16090[(15)] = inst_16032);

return statearr_16090;
})();
var statearr_16091_16106 = state_16075__$1;
(statearr_16091_16106[(2)] = null);

(statearr_16091_16106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_16092 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16092[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__);

(statearr_16092[(1)] = (1));

return statearr_16092;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1 = (function (state_16075){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16075);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16093){var ex__2687__auto__ = e16093;
var statearr_16094_16107 = state_16075;
(statearr_16094_16107[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16075[(4)]))){
var statearr_16095_16108 = state_16075;
(statearr_16095_16108[(1)] = cljs.core.first((state_16075[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16109 = state_16075;
state_16075 = G__16109;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = function(state_16075){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1.call(this,state_16075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16096 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16096[(6)] = c__2706__auto__);

return statearr_16096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__16111 = arguments.length;
switch (G__16111) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16281){
var state_val_16282 = (state_16281[(1)]);
if((state_val_16282 === (65))){
var state_16281__$1 = state_16281;
var statearr_16283_16383 = state_16281__$1;
(statearr_16283_16383[(2)] = null);

(statearr_16283_16383[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (70))){
var inst_16276 = (state_16281[(2)]);
var _ = (function (){var statearr_16284 = state_16281;
(statearr_16284[(4)] = cljs.core.rest((state_16281[(4)])));

return statearr_16284;
})();
var state_16281__$1 = state_16281;
var statearr_16285_16384 = state_16281__$1;
(statearr_16285_16384[(2)] = inst_16276);

(statearr_16285_16384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (62))){
var inst_16262 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16286_16385 = state_16281__$1;
(statearr_16286_16385[(2)] = inst_16262);

(statearr_16286_16385[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (7))){
var state_16281__$1 = state_16281;
var statearr_16287_16386 = state_16281__$1;
(statearr_16287_16386[(2)] = false);

(statearr_16287_16386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (59))){
var inst_16236 = (state_16281[(2)]);
var inst_16237 = fluree.db.util.async.throw_err(inst_16236);
var state_16281__$1 = state_16281;
var statearr_16288_16387 = state_16281__$1;
(statearr_16288_16387[(2)] = inst_16237);

(statearr_16288_16387[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (20))){
var state_16281__$1 = state_16281;
var statearr_16289_16388 = state_16281__$1;
(statearr_16289_16388[(2)] = null);

(statearr_16289_16388[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (58))){
var inst_16226 = (state_16281[(2)]);
var inst_16227 = fluree.db.util.async.throw_err(inst_16226);
var inst_16228 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_16227);
var state_16281__$1 = state_16281;
var statearr_16290_16389 = state_16281__$1;
(statearr_16290_16389[(2)] = inst_16228);

(statearr_16290_16389[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (60))){
var inst_16123 = (state_16281[(7)]);
var inst_16162 = (state_16281[(8)]);
var inst_16125 = (state_16281[(9)]);
var inst_16122 = (state_16281[(10)]);
var inst_16242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16243 = [inst_16123,inst_16122,inst_16162,inst_16125];
var inst_16244 = (new cljs.core.PersistentVector(null,4,(5),inst_16242,inst_16243,null));
var inst_16245 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16244,opts);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(63),inst_16245);
} else {
if((state_val_16282 === (27))){
var inst_16162 = (state_16281[(8)]);
var inst_16173 = (state_16281[(11)]);
var inst_16173__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_16162);
var state_16281__$1 = (function (){var statearr_16291 = state_16281;
(statearr_16291[(11)] = inst_16173__$1);

return statearr_16291;
})();
if(inst_16173__$1){
var statearr_16292_16390 = state_16281__$1;
(statearr_16292_16390[(1)] = (30));

} else {
var statearr_16293_16391 = state_16281__$1;
(statearr_16293_16391[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (1))){
var state_16281__$1 = state_16281;
var statearr_16294_16392 = state_16281__$1;
(statearr_16294_16392[(2)] = null);

(statearr_16294_16392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (69))){
var inst_16268 = (state_16281[(12)]);
var state_16281__$1 = state_16281;
var statearr_16295_16393 = state_16281__$1;
(statearr_16295_16393[(2)] = inst_16268);

(statearr_16295_16393[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (24))){
var inst_16123 = (state_16281[(7)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16123)){
var statearr_16296_16394 = state_16281__$1;
(statearr_16296_16394[(1)] = (27));

} else {
var statearr_16297_16395 = state_16281__$1;
(statearr_16297_16395[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (55))){
var inst_16162 = (state_16281[(8)]);
var inst_16220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16221 = [inst_16162];
var inst_16222 = (new cljs.core.PersistentVector(null,1,(5),inst_16220,inst_16221,null));
var inst_16223 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_16224 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16222,inst_16223);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(58),inst_16224);
} else {
if((state_val_16282 === (39))){
var inst_16193 = (state_16281[(2)]);
var inst_16194 = fluree.db.util.async.throw_err(inst_16193);
var state_16281__$1 = state_16281;
var statearr_16298_16396 = state_16281__$1;
(statearr_16298_16396[(2)] = inst_16194);

(statearr_16298_16396[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (46))){
var inst_16206 = (state_16281[(13)]);
var inst_16206__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_16281__$1 = (function (){var statearr_16299 = state_16281;
(statearr_16299[(13)] = inst_16206__$1);

return statearr_16299;
})();
if(cljs.core.truth_(inst_16206__$1)){
var statearr_16300_16397 = state_16281__$1;
(statearr_16300_16397[(1)] = (49));

} else {
var statearr_16301_16398 = state_16281__$1;
(statearr_16301_16398[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (4))){
var inst_16112 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16302_16399 = state_16281__$1;
(statearr_16302_16399[(2)] = inst_16112);

(statearr_16302_16399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (54))){
var inst_16218 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16218)){
var statearr_16303_16400 = state_16281__$1;
(statearr_16303_16400[(1)] = (55));

} else {
var statearr_16304_16401 = state_16281__$1;
(statearr_16304_16401[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (15))){
var inst_16124 = (state_16281[(14)]);
var inst_16143 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_16124);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(18),inst_16143);
} else {
if((state_val_16282 === (48))){
var inst_16264 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16305_16402 = state_16281__$1;
(statearr_16305_16402[(2)] = inst_16264);

(statearr_16305_16402[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (50))){
var inst_16123 = (state_16281[(7)]);
var inst_16162 = (state_16281[(8)]);
var inst_16125 = (state_16281[(9)]);
var inst_16122 = (state_16281[(10)]);
var inst_16206 = (state_16281[(13)]);
var inst_16121 = (state_16281[(15)]);
var inst_16126 = (state_16281[(16)]);
var inst_16137 = (state_16281[(17)]);
var inst_16132 = (state_16281[(18)]);
var inst_16210 = (function (){var t = inst_16125;
var temp__5802__auto__ = inst_16206;
var p = inst_16123;
var idx_predicate_QMARK_ = inst_16126;
var o = inst_16162;
var vec__16118 = inst_16121;
var tag_predicate_QMARK_ = inst_16132;
var s = inst_16122;
var o_coerce_QMARK_ = inst_16137;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_16281__$1 = state_16281;
var statearr_16306_16403 = state_16281__$1;
(statearr_16306_16403[(2)] = inst_16210);

(statearr_16306_16403[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (21))){
var inst_16158 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16307_16404 = state_16281__$1;
(statearr_16307_16404[(2)] = inst_16158);

(statearr_16307_16404[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (31))){
var inst_16173 = (state_16281[(11)]);
var state_16281__$1 = state_16281;
var statearr_16308_16405 = state_16281__$1;
(statearr_16308_16405[(2)] = inst_16173);

(statearr_16308_16405[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (32))){
var inst_16183 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16309_16406 = state_16281__$1;
(statearr_16309_16406[(2)] = inst_16183);

(statearr_16309_16406[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (40))){
var inst_16197 = (state_16281[(19)]);
var inst_16126 = (state_16281[(16)]);
var inst_16197__$1 = cljs.core.not(inst_16126);
var state_16281__$1 = (function (){var statearr_16310 = state_16281;
(statearr_16310[(19)] = inst_16197__$1);

return statearr_16310;
})();
if(inst_16197__$1){
var statearr_16311_16407 = state_16281__$1;
(statearr_16311_16407[(1)] = (43));

} else {
var statearr_16312_16408 = state_16281__$1;
(statearr_16312_16408[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (56))){
var inst_16123 = (state_16281[(7)]);
var inst_16212 = (state_16281[(20)]);
var inst_16125 = (state_16281[(9)]);
var inst_16122 = (state_16281[(10)]);
var inst_16230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16231 = [inst_16123,inst_16122,null,inst_16125];
var inst_16232 = (new cljs.core.PersistentVector(null,4,(5),inst_16230,inst_16231,null));
var inst_16233 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_16212);
var inst_16234 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16232,inst_16233);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(59),inst_16234);
} else {
if((state_val_16282 === (33))){
var inst_16162 = (state_16281[(8)]);
var inst_16176 = cljs.core.fn_QMARK_(inst_16162);
var inst_16177 = (!(inst_16176));
var state_16281__$1 = state_16281;
var statearr_16313_16409 = state_16281__$1;
(statearr_16313_16409[(2)] = inst_16177);

(statearr_16313_16409[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (13))){
var inst_16124 = (state_16281[(14)]);
var inst_16141 = fluree.db.query.range.tag_string_QMARK_(inst_16124);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16141)){
var statearr_16314_16410 = state_16281__$1;
(statearr_16314_16410[(1)] = (15));

} else {
var statearr_16315_16411 = state_16281__$1;
(statearr_16315_16411[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (22))){
var inst_16154 = (state_16281[(2)]);
var inst_16155 = fluree.db.util.async.throw_err(inst_16154);
var state_16281__$1 = state_16281;
var statearr_16316_16412 = state_16281__$1;
(statearr_16316_16412[(2)] = inst_16155);

(statearr_16316_16412[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (36))){
var inst_16123 = (state_16281[(7)]);
var inst_16162 = (state_16281[(8)]);
var inst_16125 = (state_16281[(9)]);
var inst_16122 = (state_16281[(10)]);
var inst_16188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16189 = [inst_16123,inst_16162,inst_16122,inst_16125];
var inst_16190 = (new cljs.core.PersistentVector(null,4,(5),inst_16188,inst_16189,null));
var inst_16191 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_16190,opts);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(39),inst_16191);
} else {
if((state_val_16282 === (41))){
var inst_16123 = (state_16281[(7)]);
var state_16281__$1 = state_16281;
var statearr_16317_16413 = state_16281__$1;
(statearr_16317_16413[(2)] = inst_16123);

(statearr_16317_16413[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (43))){
var inst_16162 = (state_16281[(8)]);
var state_16281__$1 = state_16281;
var statearr_16318_16414 = state_16281__$1;
(statearr_16318_16414[(2)] = inst_16162);

(statearr_16318_16414[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (61))){
var inst_16162 = (state_16281[(8)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16162)){
var statearr_16319_16415 = state_16281__$1;
(statearr_16319_16415[(1)] = (64));

} else {
var statearr_16320_16416 = state_16281__$1;
(statearr_16320_16416[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (29))){
var inst_16186 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16186)){
var statearr_16321_16417 = state_16281__$1;
(statearr_16321_16417[(1)] = (36));

} else {
var statearr_16322_16418 = state_16281__$1;
(statearr_16322_16418[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (44))){
var inst_16197 = (state_16281[(19)]);
var state_16281__$1 = state_16281;
var statearr_16323_16419 = state_16281__$1;
(statearr_16323_16419[(2)] = inst_16197);

(statearr_16323_16419[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (6))){
var inst_16123 = (state_16281[(7)]);
var inst_16128 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_16123);
var inst_16129 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_16128);
var state_16281__$1 = state_16281;
var statearr_16324_16420 = state_16281__$1;
(statearr_16324_16420[(2)] = inst_16129);

(statearr_16324_16420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (28))){
var inst_16123 = (state_16281[(7)]);
var state_16281__$1 = state_16281;
var statearr_16325_16421 = state_16281__$1;
(statearr_16325_16421[(2)] = inst_16123);

(statearr_16325_16421[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (64))){
var inst_16123 = (state_16281[(7)]);
var inst_16162 = (state_16281[(8)]);
var inst_16125 = (state_16281[(9)]);
var inst_16122 = (state_16281[(10)]);
var inst_16251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16252 = [inst_16162,inst_16123,inst_16122,inst_16125];
var inst_16253 = (new cljs.core.PersistentVector(null,4,(5),inst_16251,inst_16252,null));
var inst_16254 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_16253,opts);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(67),inst_16254);
} else {
if((state_val_16282 === (51))){
var inst_16123 = (state_16281[(7)]);
var inst_16213 = (state_16281[(21)]);
var inst_16212 = (state_16281[(2)]);
var inst_16213__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_16123);
var state_16281__$1 = (function (){var statearr_16326 = state_16281;
(statearr_16326[(20)] = inst_16212);

(statearr_16326[(21)] = inst_16213__$1);

return statearr_16326;
})();
if(inst_16213__$1){
var statearr_16327_16422 = state_16281__$1;
(statearr_16327_16422[(1)] = (52));

} else {
var statearr_16328_16423 = state_16281__$1;
(statearr_16328_16423[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (25))){
var inst_16132 = (state_16281[(18)]);
var inst_16268 = (state_16281[(2)]);
var state_16281__$1 = (function (){var statearr_16329 = state_16281;
(statearr_16329[(12)] = inst_16268);

return statearr_16329;
})();
if(cljs.core.truth_(inst_16132)){
var statearr_16330_16424 = state_16281__$1;
(statearr_16330_16424[(1)] = (68));

} else {
var statearr_16331_16425 = state_16281__$1;
(statearr_16331_16425[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (34))){
var inst_16126 = (state_16281[(16)]);
var state_16281__$1 = state_16281;
var statearr_16332_16426 = state_16281__$1;
(statearr_16332_16426[(2)] = inst_16126);

(statearr_16332_16426[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (17))){
var inst_16160 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16333_16427 = state_16281__$1;
(statearr_16333_16427[(2)] = inst_16160);

(statearr_16333_16427[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (3))){
var inst_16279 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16281__$1,inst_16279);
} else {
if((state_val_16282 === (12))){
var inst_16124 = (state_16281[(14)]);
var state_16281__$1 = state_16281;
var statearr_16334_16428 = state_16281__$1;
(statearr_16334_16428[(2)] = inst_16124);

(statearr_16334_16428[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (2))){
var inst_16123 = (state_16281[(7)]);
var inst_16121 = (state_16281[(15)]);
var _ = (function (){var statearr_16335 = state_16281;
(statearr_16335[(4)] = cljs.core.cons((5),(state_16281[(4)])));

return statearr_16335;
})();
var inst_16121__$1 = fparts;
var inst_16122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16121__$1,(0),null);
var inst_16123__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16121__$1,(1),null);
var inst_16124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16121__$1,(2),null);
var inst_16125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16121__$1,(3),null);
var inst_16126 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_16123__$1);
var state_16281__$1 = (function (){var statearr_16336 = state_16281;
(statearr_16336[(7)] = inst_16123__$1);

(statearr_16336[(9)] = inst_16125);

(statearr_16336[(10)] = inst_16122);

(statearr_16336[(14)] = inst_16124);

(statearr_16336[(15)] = inst_16121__$1);

(statearr_16336[(16)] = inst_16126);

return statearr_16336;
})();
if(cljs.core.truth_(inst_16123__$1)){
var statearr_16337_16429 = state_16281__$1;
(statearr_16337_16429[(1)] = (6));

} else {
var statearr_16338_16430 = state_16281__$1;
(statearr_16338_16430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (66))){
var inst_16260 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16339_16431 = state_16281__$1;
(statearr_16339_16431[(2)] = inst_16260);

(statearr_16339_16431[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (23))){
var inst_16123 = (state_16281[(7)]);
var inst_16162 = (state_16281[(8)]);
var inst_16125 = (state_16281[(9)]);
var inst_16122 = (state_16281[(10)]);
var inst_16164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16165 = [inst_16122,inst_16123,inst_16162,inst_16125];
var inst_16166 = (new cljs.core.PersistentVector(null,4,(5),inst_16164,inst_16165,null));
var inst_16167 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16166,opts);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(26),inst_16167);
} else {
if((state_val_16282 === (47))){
var inst_16123 = (state_16281[(7)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16123)){
var statearr_16340_16432 = state_16281__$1;
(statearr_16340_16432[(1)] = (60));

} else {
var statearr_16341_16433 = state_16281__$1;
(statearr_16341_16433[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (35))){
var inst_16180 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16342_16434 = state_16281__$1;
(statearr_16342_16434[(2)] = inst_16180);

(statearr_16342_16434[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (19))){
var inst_16123 = (state_16281[(7)]);
var inst_16124 = (state_16281[(14)]);
var inst_16150 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16123);
var inst_16151 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16150),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16124)].join('');
var inst_16152 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_16151);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(22),inst_16152);
} else {
if((state_val_16282 === (57))){
var inst_16239 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16343_16435 = state_16281__$1;
(statearr_16343_16435[(2)] = inst_16239);

(statearr_16343_16435[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (68))){
var inst_16268 = (state_16281[(12)]);
var inst_16270 = fluree.db.query.range.coerce_tag_flakes(db,inst_16268);
var state_16281__$1 = state_16281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16281__$1,(71),inst_16270);
} else {
if((state_val_16282 === (11))){
var inst_16137 = (state_16281[(17)]);
var inst_16137__$1 = (state_16281[(2)]);
var inst_16138 = cljs.core.not(inst_16137__$1);
var state_16281__$1 = (function (){var statearr_16345 = state_16281;
(statearr_16345[(17)] = inst_16137__$1);

return statearr_16345;
})();
if(inst_16138){
var statearr_16346_16436 = state_16281__$1;
(statearr_16346_16436[(1)] = (12));

} else {
var statearr_16347_16437 = state_16281__$1;
(statearr_16347_16437[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (9))){
var inst_16124 = (state_16281[(14)]);
var inst_16134 = typeof inst_16124 === 'string';
var state_16281__$1 = state_16281;
var statearr_16348_16438 = state_16281__$1;
(statearr_16348_16438[(2)] = inst_16134);

(statearr_16348_16438[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (5))){
var _ = (function (){var statearr_16349 = state_16281;
(statearr_16349[(4)] = cljs.core.rest((state_16281[(4)])));

return statearr_16349;
})();
var state_16281__$1 = state_16281;
var ex16344 = (state_16281__$1[(2)]);
var statearr_16350_16439 = state_16281__$1;
(statearr_16350_16439[(5)] = ex16344);


if((ex16344 instanceof Error)){
var statearr_16351_16440 = state_16281__$1;
(statearr_16351_16440[(1)] = (4));

(statearr_16351_16440[(5)] = null);

} else {
throw ex16344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (14))){
var inst_16122 = (state_16281[(10)]);
var inst_16162 = (state_16281[(2)]);
var state_16281__$1 = (function (){var statearr_16352 = state_16281;
(statearr_16352[(8)] = inst_16162);

return statearr_16352;
})();
if(cljs.core.truth_(inst_16122)){
var statearr_16353_16441 = state_16281__$1;
(statearr_16353_16441[(1)] = (23));

} else {
var statearr_16354_16442 = state_16281__$1;
(statearr_16354_16442[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (45))){
var inst_16201 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16355_16443 = state_16281__$1;
(statearr_16355_16443[(2)] = inst_16201);

(statearr_16355_16443[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (53))){
var inst_16213 = (state_16281[(21)]);
var state_16281__$1 = state_16281;
var statearr_16356_16444 = state_16281__$1;
(statearr_16356_16444[(2)] = inst_16213);

(statearr_16356_16444[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (26))){
var inst_16169 = (state_16281[(2)]);
var inst_16170 = fluree.db.util.async.throw_err(inst_16169);
var state_16281__$1 = state_16281;
var statearr_16357_16445 = state_16281__$1;
(statearr_16357_16445[(2)] = inst_16170);

(statearr_16357_16445[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (16))){
var inst_16124 = (state_16281[(14)]);
var inst_16148 = typeof inst_16124 === 'string';
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16148)){
var statearr_16358_16446 = state_16281__$1;
(statearr_16358_16446[(1)] = (19));

} else {
var statearr_16359_16447 = state_16281__$1;
(statearr_16359_16447[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (38))){
var inst_16266 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
var statearr_16360_16448 = state_16281__$1;
(statearr_16360_16448[(2)] = inst_16266);

(statearr_16360_16448[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (30))){
var inst_16126 = (state_16281[(16)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16126)){
var statearr_16361_16449 = state_16281__$1;
(statearr_16361_16449[(1)] = (33));

} else {
var statearr_16362_16450 = state_16281__$1;
(statearr_16362_16450[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (10))){
var inst_16132 = (state_16281[(18)]);
var state_16281__$1 = state_16281;
var statearr_16363_16451 = state_16281__$1;
(statearr_16363_16451[(2)] = inst_16132);

(statearr_16363_16451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (18))){
var inst_16145 = (state_16281[(2)]);
var inst_16146 = fluree.db.util.async.throw_err(inst_16145);
var state_16281__$1 = state_16281;
var statearr_16364_16452 = state_16281__$1;
(statearr_16364_16452[(2)] = inst_16146);

(statearr_16364_16452[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (52))){
var inst_16162 = (state_16281[(8)]);
var inst_16215 = cljs.core.int_QMARK_(inst_16162);
var state_16281__$1 = state_16281;
var statearr_16365_16453 = state_16281__$1;
(statearr_16365_16453[(2)] = inst_16215);

(statearr_16365_16453[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (67))){
var inst_16256 = (state_16281[(2)]);
var inst_16257 = fluree.db.util.async.throw_err(inst_16256);
var state_16281__$1 = state_16281;
var statearr_16366_16454 = state_16281__$1;
(statearr_16366_16454[(2)] = inst_16257);

(statearr_16366_16454[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (71))){
var inst_16272 = (state_16281[(2)]);
var inst_16273 = fluree.db.util.async.throw_err(inst_16272);
var state_16281__$1 = state_16281;
var statearr_16367_16455 = state_16281__$1;
(statearr_16367_16455[(2)] = inst_16273);

(statearr_16367_16455[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (42))){
var inst_16204 = (state_16281[(2)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16204)){
var statearr_16368_16456 = state_16281__$1;
(statearr_16368_16456[(1)] = (46));

} else {
var statearr_16369_16457 = state_16281__$1;
(statearr_16369_16457[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (37))){
var inst_16123 = (state_16281[(7)]);
var state_16281__$1 = state_16281;
if(cljs.core.truth_(inst_16123)){
var statearr_16370_16458 = state_16281__$1;
(statearr_16370_16458[(1)] = (40));

} else {
var statearr_16371_16459 = state_16281__$1;
(statearr_16371_16459[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (63))){
var inst_16247 = (state_16281[(2)]);
var inst_16248 = fluree.db.util.async.throw_err(inst_16247);
var state_16281__$1 = state_16281;
var statearr_16372_16460 = state_16281__$1;
(statearr_16372_16460[(2)] = inst_16248);

(statearr_16372_16460[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (8))){
var inst_16132 = (state_16281[(18)]);
var inst_16132__$1 = (state_16281[(2)]);
var state_16281__$1 = (function (){var statearr_16373 = state_16281;
(statearr_16373[(18)] = inst_16132__$1);

return statearr_16373;
})();
if(cljs.core.truth_(inst_16132__$1)){
var statearr_16374_16461 = state_16281__$1;
(statearr_16374_16461[(1)] = (9));

} else {
var statearr_16375_16462 = state_16281__$1;
(statearr_16375_16462[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16282 === (49))){
var inst_16123 = (state_16281[(7)]);
var inst_16162 = (state_16281[(8)]);
var inst_16125 = (state_16281[(9)]);
var inst_16122 = (state_16281[(10)]);
var inst_16206 = (state_16281[(13)]);
var inst_16121 = (state_16281[(15)]);
var inst_16126 = (state_16281[(16)]);
var inst_16137 = (state_16281[(17)]);
var inst_16132 = (state_16281[(18)]);
var inst_16208 = (function (){var obj_fn = inst_16206;
var t = inst_16125;
var temp__5802__auto__ = inst_16206;
var p = inst_16123;
var idx_predicate_QMARK_ = inst_16126;
var o = inst_16162;
var vec__16118 = inst_16121;
var tag_predicate_QMARK_ = inst_16132;
var s = inst_16122;
var o_coerce_QMARK_ = inst_16137;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_16281__$1 = state_16281;
var statearr_16376_16463 = state_16281__$1;
(statearr_16376_16463[(2)] = inst_16208);

(statearr_16376_16463[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_16377 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16377[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_16377[(1)] = (1));

return statearr_16377;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_16281){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16281);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16378){var ex__2687__auto__ = e16378;
var statearr_16379_16464 = state_16281;
(statearr_16379_16464[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16281[(4)]))){
var statearr_16380_16465 = state_16281;
(statearr_16380_16465[(1)] = cljs.core.first((state_16281[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16466 = state_16281;
state_16281 = G__16466;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_16281){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_16281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16381 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16381[(6)] = c__2706__auto__);

return statearr_16381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__16468 = arguments.length;
switch (G__16468) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16503){
var state_val_16504 = (state_16503[(1)]);
if((state_val_16504 === (7))){
var inst_16490 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_16491 = ["Invalid collection name: ",inst_16490].join('');
var inst_16492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16493 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_16494 = cljs.core.PersistentHashMap.fromArrays(inst_16492,inst_16493);
var inst_16495 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16491,inst_16494);
var inst_16496 = (function(){throw inst_16495})();
var state_16503__$1 = state_16503;
var statearr_16505_16525 = state_16503__$1;
(statearr_16505_16525[(2)] = inst_16496);

(statearr_16505_16525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16504 === (1))){
var state_16503__$1 = state_16503;
var statearr_16506_16526 = state_16503__$1;
(statearr_16506_16526[(2)] = null);

(statearr_16506_16526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16504 === (4))){
var inst_16469 = (state_16503[(2)]);
var state_16503__$1 = state_16503;
var statearr_16507_16527 = state_16503__$1;
(statearr_16507_16527[(2)] = inst_16469);

(statearr_16507_16527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16504 === (6))){
var inst_16475 = (state_16503[(7)]);
var inst_16477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16478 = fluree.db.flake.max_subject_id(inst_16475);
var inst_16479 = [inst_16478];
var inst_16480 = (new cljs.core.PersistentVector(null,1,(5),inst_16477,inst_16479,null));
var inst_16481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16482 = fluree.db.flake.min_subject_id(inst_16475);
var inst_16483 = [inst_16482];
var inst_16484 = (new cljs.core.PersistentVector(null,1,(5),inst_16481,inst_16483,null));
var inst_16485 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16480,cljs.core._LT__EQ_,inst_16484,opts);
var state_16503__$1 = state_16503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16503__$1,(9),inst_16485);
} else {
if((state_val_16504 === (3))){
var inst_16501 = (state_16503[(2)]);
var state_16503__$1 = state_16503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16503__$1,inst_16501);
} else {
if((state_val_16504 === (2))){
var inst_16475 = (state_16503[(7)]);
var _ = (function (){var statearr_16509 = state_16503;
(statearr_16509[(4)] = cljs.core.cons((5),(state_16503[(4)])));

return statearr_16509;
})();
var inst_16475__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_16503__$1 = (function (){var statearr_16510 = state_16503;
(statearr_16510[(7)] = inst_16475__$1);

return statearr_16510;
})();
if(cljs.core.truth_(inst_16475__$1)){
var statearr_16511_16528 = state_16503__$1;
(statearr_16511_16528[(1)] = (6));

} else {
var statearr_16512_16529 = state_16503__$1;
(statearr_16512_16529[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16504 === (9))){
var inst_16487 = (state_16503[(2)]);
var inst_16488 = fluree.db.util.async.throw_err(inst_16487);
var state_16503__$1 = state_16503;
var statearr_16513_16530 = state_16503__$1;
(statearr_16513_16530[(2)] = inst_16488);

(statearr_16513_16530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16504 === (5))){
var _ = (function (){var statearr_16514 = state_16503;
(statearr_16514[(4)] = cljs.core.rest((state_16503[(4)])));

return statearr_16514;
})();
var state_16503__$1 = state_16503;
var ex16508 = (state_16503__$1[(2)]);
var statearr_16515_16531 = state_16503__$1;
(statearr_16515_16531[(5)] = ex16508);


var statearr_16516_16532 = state_16503__$1;
(statearr_16516_16532[(1)] = (4));

(statearr_16516_16532[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16504 === (8))){
var inst_16498 = (state_16503[(2)]);
var _ = (function (){var statearr_16517 = state_16503;
(statearr_16517[(4)] = cljs.core.rest((state_16503[(4)])));

return statearr_16517;
})();
var state_16503__$1 = state_16503;
var statearr_16518_16533 = state_16503__$1;
(statearr_16518_16533[(2)] = inst_16498);

(statearr_16518_16533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_16519 = [null,null,null,null,null,null,null,null];
(statearr_16519[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_16519[(1)] = (1));

return statearr_16519;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_16503){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16503);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16520){var ex__2687__auto__ = e16520;
var statearr_16521_16534 = state_16503;
(statearr_16521_16534[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16503[(4)]))){
var statearr_16522_16535 = state_16503;
(statearr_16522_16535[(1)] = cljs.core.first((state_16503[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16536 = state_16503;
state_16503 = G__16536;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_16503){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_16503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16523 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16523[(6)] = c__2706__auto__);

return statearr_16523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__16540 = flakes;
var vec__16541 = G__16540;
var seq__16542 = cljs.core.seq(vec__16541);
var first__16543 = cljs.core.first(seq__16542);
var seq__16542__$1 = cljs.core.next(seq__16542);
var flake_SINGLEQUOTE_ = first__16543;
var r = seq__16542__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16540__$1 = G__16540;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16549 = G__16540__$1;
var seq__16550 = cljs.core.seq(vec__16549);
var first__16551 = cljs.core.first(seq__16550);
var seq__16550__$1 = cljs.core.next(seq__16550);
var flake_SINGLEQUOTE___$1 = first__16551;
var r__$1 = seq__16550__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e16553){var e = e16553;
return null;
}})();
var map__16552 = cmd_map;
var map__16552__$1 = cljs.core.__destructure_map(map__16552);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16552__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16552__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16552__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16552__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16552__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16552__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16554 = r__$1;
var G__16555 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__16540__$1 = G__16554;
result_STAR___$1 = G__16555;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16564 = blocks;
var vec__16565 = G__16564;
var seq__16566 = cljs.core.seq(vec__16565);
var first__16567 = cljs.core.first(seq__16566);
var seq__16566__$1 = cljs.core.next(seq__16566);
var block_SINGLEQUOTE_ = first__16567;
var r = seq__16566__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16564__$1 = G__16564;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16572 = G__16564__$1;
var seq__16573 = cljs.core.seq(vec__16572);
var first__16574 = cljs.core.first(seq__16573);
var seq__16573__$1 = cljs.core.next(seq__16573);
var block_SINGLEQUOTE___$1 = first__16574;
var r__$1 = seq__16573__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16575 = block_SINGLEQUOTE___$1;
var map__16575__$1 = cljs.core.__destructure_map(map__16575);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16575__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16575__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16575__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16556_SHARP_){
var f = p1__16556_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16557_SHARP_){
var f = p1__16557_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,hash,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16558_SHARP_){
var f = p1__16558_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,hash,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,hash,instant,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16559_SHARP_){
var f = p1__16559_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,hash,instant,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16560_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__16560_SHARP_.p,(106));
});})(G__16564__$1,result_STAR___$1,map__16575,map__16575__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16572,seq__16573,first__16574,seq__16573__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16564,vec__16565,seq__16566,first__16567,seq__16566__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__16576 = r__$1;
var G__16577 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16564__$1 = G__16576;
result_STAR___$1 = G__16577;
continue;
}
break;
}
});
