// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18030){
var state_val_18031 = (state_18030[(1)]);
if((state_val_18031 === (7))){
var inst_18019 = (state_18030[(7)]);
var inst_18021 = fluree.db.storage.core.serde(conn);
var inst_18022 = fluree.db.serde.protocol._deserialize_block(inst_18021,inst_18019);
var state_18030__$1 = state_18030;
var statearr_18032_18051 = state_18030__$1;
(statearr_18032_18051[(2)] = inst_18022);

(statearr_18032_18051[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18031 === (1))){
var state_18030__$1 = state_18030;
var statearr_18033_18052 = state_18030__$1;
(statearr_18033_18052[(2)] = null);

(statearr_18033_18052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18031 === (4))){
var inst_18009 = (state_18030[(2)]);
var state_18030__$1 = state_18030;
var statearr_18034_18053 = state_18030__$1;
(statearr_18034_18053[(2)] = inst_18009);

(statearr_18034_18053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18031 === (6))){
var inst_18019 = (state_18030[(7)]);
var inst_18018 = (state_18030[(2)]);
var inst_18019__$1 = fluree.db.util.async.throw_err(inst_18018);
var state_18030__$1 = (function (){var statearr_18035 = state_18030;
(statearr_18035[(7)] = inst_18019__$1);

return statearr_18035;
})();
if(cljs.core.truth_(inst_18019__$1)){
var statearr_18036_18054 = state_18030__$1;
(statearr_18036_18054[(1)] = (7));

} else {
var statearr_18037_18055 = state_18030__$1;
(statearr_18037_18055[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18031 === (3))){
var inst_18028 = (state_18030[(2)]);
var state_18030__$1 = state_18030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18030__$1,inst_18028);
} else {
if((state_val_18031 === (2))){
var _ = (function (){var statearr_18039 = state_18030;
(statearr_18039[(4)] = cljs.core.cons((5),(state_18030[(4)])));

return statearr_18039;
})();
var inst_18015 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_18016 = fluree.db.storage.core.storage_read(conn,inst_18015);
var state_18030__$1 = state_18030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18030__$1,(6),inst_18016);
} else {
if((state_val_18031 === (9))){
var inst_18025 = (state_18030[(2)]);
var _ = (function (){var statearr_18040 = state_18030;
(statearr_18040[(4)] = cljs.core.rest((state_18030[(4)])));

return statearr_18040;
})();
var state_18030__$1 = state_18030;
var statearr_18041_18056 = state_18030__$1;
(statearr_18041_18056[(2)] = inst_18025);

(statearr_18041_18056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18031 === (5))){
var _ = (function (){var statearr_18042 = state_18030;
(statearr_18042[(4)] = cljs.core.rest((state_18030[(4)])));

return statearr_18042;
})();
var state_18030__$1 = state_18030;
var ex18038 = (state_18030__$1[(2)]);
var statearr_18043_18057 = state_18030__$1;
(statearr_18043_18057[(5)] = ex18038);


if((ex18038 instanceof Error)){
var statearr_18044_18058 = state_18030__$1;
(statearr_18044_18058[(1)] = (4));

(statearr_18044_18058[(5)] = null);

} else {
throw ex18038;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18031 === (8))){
var state_18030__$1 = state_18030;
var statearr_18045_18059 = state_18030__$1;
(statearr_18045_18059[(2)] = null);

(statearr_18045_18059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____0 = (function (){
var statearr_18046 = [null,null,null,null,null,null,null,null];
(statearr_18046[(0)] = fluree$db$storage$core$read_block_$_state_machine__2684__auto__);

(statearr_18046[(1)] = (1));

return statearr_18046;
});
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____1 = (function (state_18030){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18030);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18047){var ex__2687__auto__ = e18047;
var statearr_18048_18060 = state_18030;
(statearr_18048_18060[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18030[(4)]))){
var statearr_18049_18061 = state_18030;
(statearr_18049_18061[(1)] = cljs.core.first((state_18030[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18062 = state_18030;
state_18030 = G__18062;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = function(state_18030){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____1.call(this,state_18030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18050 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18050[(6)] = c__2706__auto__);

return statearr_18050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18085){
var state_val_18086 = (state_18085[(1)]);
if((state_val_18086 === (7))){
var inst_18074 = (state_18085[(7)]);
var inst_18076 = fluree.db.storage.core.serde(conn);
var inst_18077 = fluree.db.serde.protocol._deserialize_block(inst_18076,inst_18074);
var state_18085__$1 = state_18085;
var statearr_18087_18106 = state_18085__$1;
(statearr_18087_18106[(2)] = inst_18077);

(statearr_18087_18106[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (1))){
var state_18085__$1 = state_18085;
var statearr_18088_18107 = state_18085__$1;
(statearr_18088_18107[(2)] = null);

(statearr_18088_18107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (4))){
var inst_18063 = (state_18085[(2)]);
var state_18085__$1 = state_18085;
var statearr_18089_18108 = state_18085__$1;
(statearr_18089_18108[(2)] = inst_18063);

(statearr_18089_18108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (6))){
var inst_18074 = (state_18085[(7)]);
var inst_18073 = (state_18085[(2)]);
var inst_18074__$1 = fluree.db.util.async.throw_err(inst_18073);
var state_18085__$1 = (function (){var statearr_18090 = state_18085;
(statearr_18090[(7)] = inst_18074__$1);

return statearr_18090;
})();
if(cljs.core.truth_(inst_18074__$1)){
var statearr_18091_18109 = state_18085__$1;
(statearr_18091_18109[(1)] = (7));

} else {
var statearr_18092_18110 = state_18085__$1;
(statearr_18092_18110[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (3))){
var inst_18083 = (state_18085[(2)]);
var state_18085__$1 = state_18085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18085__$1,inst_18083);
} else {
if((state_val_18086 === (2))){
var _ = (function (){var statearr_18094 = state_18085;
(statearr_18094[(4)] = cljs.core.cons((5),(state_18085[(4)])));

return statearr_18094;
})();
var inst_18069 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_18070 = [inst_18069,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18071 = fluree.db.storage.core.storage_read(conn,inst_18070);
var state_18085__$1 = state_18085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18085__$1,(6),inst_18071);
} else {
if((state_val_18086 === (9))){
var inst_18080 = (state_18085[(2)]);
var _ = (function (){var statearr_18095 = state_18085;
(statearr_18095[(4)] = cljs.core.rest((state_18085[(4)])));

return statearr_18095;
})();
var state_18085__$1 = state_18085;
var statearr_18096_18111 = state_18085__$1;
(statearr_18096_18111[(2)] = inst_18080);

(statearr_18096_18111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (5))){
var _ = (function (){var statearr_18097 = state_18085;
(statearr_18097[(4)] = cljs.core.rest((state_18085[(4)])));

return statearr_18097;
})();
var state_18085__$1 = state_18085;
var ex18093 = (state_18085__$1[(2)]);
var statearr_18098_18112 = state_18085__$1;
(statearr_18098_18112[(5)] = ex18093);


if((ex18093 instanceof Error)){
var statearr_18099_18113 = state_18085__$1;
(statearr_18099_18113[(1)] = (4));

(statearr_18099_18113[(5)] = null);

} else {
throw ex18093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (8))){
var state_18085__$1 = state_18085;
var statearr_18100_18114 = state_18085__$1;
(statearr_18100_18114[(2)] = null);

(statearr_18100_18114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_18101 = [null,null,null,null,null,null,null,null];
(statearr_18101[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__);

(statearr_18101[(1)] = (1));

return statearr_18101;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1 = (function (state_18085){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18085);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18102){var ex__2687__auto__ = e18102;
var statearr_18103_18115 = state_18085;
(statearr_18103_18115[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18085[(4)]))){
var statearr_18104_18116 = state_18085;
(statearr_18104_18116[(1)] = cljs.core.first((state_18085[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18117 = state_18085;
state_18085 = G__18117;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = function(state_18085){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1.call(this,state_18085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18105 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18105[(6)] = c__2706__auto__);

return statearr_18105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18141){
var state_val_18142 = (state_18141[(1)]);
if((state_val_18142 === (1))){
var state_18141__$1 = state_18141;
var statearr_18143_18157 = state_18141__$1;
(statearr_18143_18157[(2)] = null);

(statearr_18143_18157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18142 === (2))){
var _ = (function (){var statearr_18144 = state_18141;
(statearr_18144[(4)] = cljs.core.cons((5),(state_18141[(4)])));

return statearr_18144;
})();
var inst_18124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18125 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18126 = (new cljs.core.PersistentVector(null,3,(5),inst_18124,inst_18125,null));
var inst_18127 = cljs.core.select_keys(block_data,inst_18126);
var inst_18128 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18127);
var inst_18129 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_18128);
var inst_18130 = [inst_18129,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18131 = fluree.db.storage.core.serde(conn);
var inst_18132 = fluree.db.serde.protocol._serialize_block(inst_18131,inst_18127);
var inst_18133 = fluree.db.storage.core.storage_write(conn,inst_18130,inst_18132);
var state_18141__$1 = state_18141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18141__$1,(6),inst_18133);
} else {
if((state_val_18142 === (3))){
var inst_18139 = (state_18141[(2)]);
var state_18141__$1 = state_18141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18141__$1,inst_18139);
} else {
if((state_val_18142 === (4))){
var inst_18118 = (state_18141[(2)]);
var state_18141__$1 = state_18141;
var statearr_18146_18158 = state_18141__$1;
(statearr_18146_18158[(2)] = inst_18118);

(statearr_18146_18158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18142 === (5))){
var _ = (function (){var statearr_18147 = state_18141;
(statearr_18147[(4)] = cljs.core.rest((state_18141[(4)])));

return statearr_18147;
})();
var state_18141__$1 = state_18141;
var ex18145 = (state_18141__$1[(2)]);
var statearr_18148_18159 = state_18141__$1;
(statearr_18148_18159[(5)] = ex18145);


if((ex18145 instanceof Error)){
var statearr_18149_18160 = state_18141__$1;
(statearr_18149_18160[(1)] = (4));

(statearr_18149_18160[(5)] = null);

} else {
throw ex18145;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18142 === (6))){
var inst_18135 = (state_18141[(2)]);
var inst_18136 = fluree.db.util.async.throw_err(inst_18135);
var _ = (function (){var statearr_18150 = state_18141;
(statearr_18150[(4)] = cljs.core.rest((state_18141[(4)])));

return statearr_18150;
})();
var state_18141__$1 = state_18141;
var statearr_18151_18161 = state_18141__$1;
(statearr_18151_18161[(2)] = inst_18136);

(statearr_18151_18161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_18152 = [null,null,null,null,null,null,null];
(statearr_18152[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__);

(statearr_18152[(1)] = (1));

return statearr_18152;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1 = (function (state_18141){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18141);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18153){var ex__2687__auto__ = e18153;
var statearr_18154_18162 = state_18141;
(statearr_18154_18162[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18141[(4)]))){
var statearr_18155_18163 = state_18141;
(statearr_18155_18163[(1)] = cljs.core.first((state_18141[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18164 = state_18141;
state_18141 = G__18164;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = function(state_18141){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1.call(this,state_18141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18156 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18156[(6)] = c__2706__auto__);

return statearr_18156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18187){
var state_val_18188 = (state_18187[(1)]);
if((state_val_18188 === (1))){
var state_18187__$1 = state_18187;
var statearr_18189_18203 = state_18187__$1;
(statearr_18189_18203[(2)] = null);

(statearr_18189_18203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18188 === (2))){
var _ = (function (){var statearr_18190 = state_18187;
(statearr_18190[(4)] = cljs.core.cons((5),(state_18187[(4)])));

return statearr_18190;
})();
var inst_18171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18172 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18173 = (new cljs.core.PersistentVector(null,3,(5),inst_18171,inst_18172,null));
var inst_18174 = cljs.core.select_keys(block_data,inst_18173);
var inst_18175 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18174);
var inst_18176 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_18175);
var inst_18177 = fluree.db.storage.core.serde(conn);
var inst_18178 = fluree.db.serde.protocol._serialize_block(inst_18177,inst_18174);
var inst_18179 = fluree.db.storage.core.storage_write(conn,inst_18176,inst_18178);
var state_18187__$1 = state_18187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18187__$1,(6),inst_18179);
} else {
if((state_val_18188 === (3))){
var inst_18185 = (state_18187[(2)]);
var state_18187__$1 = state_18187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18187__$1,inst_18185);
} else {
if((state_val_18188 === (4))){
var inst_18165 = (state_18187[(2)]);
var state_18187__$1 = state_18187;
var statearr_18192_18204 = state_18187__$1;
(statearr_18192_18204[(2)] = inst_18165);

(statearr_18192_18204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18188 === (5))){
var _ = (function (){var statearr_18193 = state_18187;
(statearr_18193[(4)] = cljs.core.rest((state_18187[(4)])));

return statearr_18193;
})();
var state_18187__$1 = state_18187;
var ex18191 = (state_18187__$1[(2)]);
var statearr_18194_18205 = state_18187__$1;
(statearr_18194_18205[(5)] = ex18191);


if((ex18191 instanceof Error)){
var statearr_18195_18206 = state_18187__$1;
(statearr_18195_18206[(1)] = (4));

(statearr_18195_18206[(5)] = null);

} else {
throw ex18191;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18188 === (6))){
var inst_18181 = (state_18187[(2)]);
var inst_18182 = fluree.db.util.async.throw_err(inst_18181);
var _ = (function (){var statearr_18196 = state_18187;
(statearr_18196[(4)] = cljs.core.rest((state_18187[(4)])));

return statearr_18196;
})();
var state_18187__$1 = state_18187;
var statearr_18197_18207 = state_18187__$1;
(statearr_18197_18207[(2)] = inst_18182);

(statearr_18197_18207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____0 = (function (){
var statearr_18198 = [null,null,null,null,null,null,null];
(statearr_18198[(0)] = fluree$db$storage$core$write_block_$_state_machine__2684__auto__);

(statearr_18198[(1)] = (1));

return statearr_18198;
});
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____1 = (function (state_18187){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18187);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18199){var ex__2687__auto__ = e18199;
var statearr_18200_18208 = state_18187;
(statearr_18200_18208[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18187[(4)]))){
var statearr_18201_18209 = state_18187;
(statearr_18201_18209[(1)] = cljs.core.first((state_18187[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18210 = state_18187;
state_18187 = G__18210;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = function(state_18187){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____1.call(this,state_18187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18202 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18202[(6)] = c__2706__auto__);

return statearr_18202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18230){
var state_val_18231 = (state_18230[(1)]);
if((state_val_18231 === (1))){
var state_18230__$1 = state_18230;
var statearr_18232_18246 = state_18230__$1;
(statearr_18232_18246[(2)] = null);

(statearr_18232_18246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18231 === (2))){
var _ = (function (){var statearr_18233 = state_18230;
(statearr_18233[(4)] = cljs.core.cons((5),(state_18230[(4)])));

return statearr_18233;
})();
var inst_18217 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18218 = [history,next_his_key];
var inst_18219 = cljs.core.PersistentHashMap.fromArrays(inst_18217,inst_18218);
var inst_18220 = fluree.db.storage.core.serde(conn);
var inst_18221 = fluree.db.serde.protocol._serialize_leaf(inst_18220,inst_18219);
var inst_18222 = fluree.db.storage.core.storage_write(conn,his_key,inst_18221);
var state_18230__$1 = state_18230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18230__$1,(6),inst_18222);
} else {
if((state_val_18231 === (3))){
var inst_18228 = (state_18230[(2)]);
var state_18230__$1 = state_18230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18230__$1,inst_18228);
} else {
if((state_val_18231 === (4))){
var inst_18211 = (state_18230[(2)]);
var state_18230__$1 = state_18230;
var statearr_18235_18247 = state_18230__$1;
(statearr_18235_18247[(2)] = inst_18211);

(statearr_18235_18247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18231 === (5))){
var _ = (function (){var statearr_18236 = state_18230;
(statearr_18236[(4)] = cljs.core.rest((state_18230[(4)])));

return statearr_18236;
})();
var state_18230__$1 = state_18230;
var ex18234 = (state_18230__$1[(2)]);
var statearr_18237_18248 = state_18230__$1;
(statearr_18237_18248[(5)] = ex18234);


if((ex18234 instanceof Error)){
var statearr_18238_18249 = state_18230__$1;
(statearr_18238_18249[(1)] = (4));

(statearr_18238_18249[(5)] = null);

} else {
throw ex18234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18231 === (6))){
var inst_18224 = (state_18230[(2)]);
var inst_18225 = fluree.db.util.async.throw_err(inst_18224);
var _ = (function (){var statearr_18239 = state_18230;
(statearr_18239[(4)] = cljs.core.rest((state_18230[(4)])));

return statearr_18239;
})();
var state_18230__$1 = state_18230;
var statearr_18240_18250 = state_18230__$1;
(statearr_18240_18250[(2)] = inst_18225);

(statearr_18240_18250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2684__auto____0 = (function (){
var statearr_18241 = [null,null,null,null,null,null,null];
(statearr_18241[(0)] = fluree$db$storage$core$write_history_$_state_machine__2684__auto__);

(statearr_18241[(1)] = (1));

return statearr_18241;
});
var fluree$db$storage$core$write_history_$_state_machine__2684__auto____1 = (function (state_18230){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18230);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18242){var ex__2687__auto__ = e18242;
var statearr_18243_18251 = state_18230;
(statearr_18243_18251[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18230[(4)]))){
var statearr_18244_18252 = state_18230;
(statearr_18244_18252[(1)] = cljs.core.first((state_18230[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18253 = state_18230;
state_18230 = G__18253;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2684__auto__ = function(state_18230){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2684__auto____1.call(this,state_18230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18245 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18245[(6)] = c__2706__auto__);

return statearr_18245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18279){
var state_val_18280 = (state_18279[(1)]);
if((state_val_18280 === (1))){
var state_18279__$1 = state_18279;
var statearr_18281_18298 = state_18279__$1;
(statearr_18281_18298[(2)] = null);

(statearr_18281_18298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18280 === (2))){
var inst_18260 = (state_18279[(7)]);
var _ = (function (){var statearr_18282 = state_18279;
(statearr_18282[(4)] = cljs.core.cons((5),(state_18279[(4)])));

return statearr_18282;
})();
var inst_18260__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_18261 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18260__$1),"-his"].join('');
var inst_18262 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18263 = [flakes,inst_18261];
var inst_18264 = cljs.core.PersistentHashMap.fromArrays(inst_18262,inst_18263);
var inst_18265 = fluree.db.storage.core.serde(conn);
var inst_18266 = fluree.db.serde.protocol._serialize_leaf(inst_18265,inst_18264);
var inst_18267 = fluree.db.storage.core.write_history(conn,history,inst_18261,null);
var inst_18268 = fluree.db.storage.core.storage_write(conn,inst_18260__$1,inst_18266);
var state_18279__$1 = (function (){var statearr_18283 = state_18279;
(statearr_18283[(7)] = inst_18260__$1);

(statearr_18283[(8)] = inst_18268);

return statearr_18283;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18279__$1,(6),inst_18267);
} else {
if((state_val_18280 === (3))){
var inst_18277 = (state_18279[(2)]);
var state_18279__$1 = state_18279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18279__$1,inst_18277);
} else {
if((state_val_18280 === (4))){
var inst_18254 = (state_18279[(2)]);
var state_18279__$1 = state_18279;
var statearr_18285_18299 = state_18279__$1;
(statearr_18285_18299[(2)] = inst_18254);

(statearr_18285_18299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18280 === (5))){
var _ = (function (){var statearr_18286 = state_18279;
(statearr_18286[(4)] = cljs.core.rest((state_18279[(4)])));

return statearr_18286;
})();
var state_18279__$1 = state_18279;
var ex18284 = (state_18279__$1[(2)]);
var statearr_18287_18300 = state_18279__$1;
(statearr_18287_18300[(5)] = ex18284);


if((ex18284 instanceof Error)){
var statearr_18288_18301 = state_18279__$1;
(statearr_18288_18301[(1)] = (4));

(statearr_18288_18301[(5)] = null);

} else {
throw ex18284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18280 === (6))){
var inst_18268 = (state_18279[(8)]);
var inst_18270 = (state_18279[(2)]);
var inst_18271 = fluree.db.util.async.throw_err(inst_18270);
var state_18279__$1 = (function (){var statearr_18289 = state_18279;
(statearr_18289[(9)] = inst_18271);

return statearr_18289;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18279__$1,(7),inst_18268);
} else {
if((state_val_18280 === (7))){
var inst_18260 = (state_18279[(7)]);
var inst_18273 = (state_18279[(2)]);
var inst_18274 = fluree.db.util.async.throw_err(inst_18273);
var _ = (function (){var statearr_18290 = state_18279;
(statearr_18290[(4)] = cljs.core.rest((state_18279[(4)])));

return statearr_18290;
})();
var state_18279__$1 = (function (){var statearr_18291 = state_18279;
(statearr_18291[(10)] = inst_18274);

return statearr_18291;
})();
var statearr_18292_18302 = state_18279__$1;
(statearr_18292_18302[(2)] = inst_18260);

(statearr_18292_18302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_18293 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18293[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2684__auto__);

(statearr_18293[(1)] = (1));

return statearr_18293;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2684__auto____1 = (function (state_18279){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18279);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18294){var ex__2687__auto__ = e18294;
var statearr_18295_18303 = state_18279;
(statearr_18295_18303[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18279[(4)]))){
var statearr_18296_18304 = state_18279;
(statearr_18296_18304[(1)] = cljs.core.first((state_18279[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18305 = state_18279;
state_18279 = G__18305;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2684__auto__ = function(state_18279){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2684__auto____1.call(this,state_18279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18297 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18297[(6)] = c__2706__auto__);

return statearr_18297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18322){
var state_val_18323 = (state_18322[(1)]);
if((state_val_18323 === (1))){
var state_18322__$1 = state_18322;
var statearr_18324_18339 = state_18322__$1;
(statearr_18324_18339[(2)] = null);

(statearr_18324_18339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18323 === (2))){
var _ = (function (){var statearr_18325 = state_18322;
(statearr_18325[(4)] = cljs.core.cons((5),(state_18322[(4)])));

return statearr_18325;
})();
var inst_18312 = fluree.db.storage.core.serde(conn);
var inst_18313 = fluree.db.serde.protocol._serialize_branch(inst_18312,data);
var inst_18314 = fluree.db.storage.core.storage_write(conn,key,inst_18313);
var state_18322__$1 = state_18322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18322__$1,(6),inst_18314);
} else {
if((state_val_18323 === (3))){
var inst_18320 = (state_18322[(2)]);
var state_18322__$1 = state_18322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18322__$1,inst_18320);
} else {
if((state_val_18323 === (4))){
var inst_18306 = (state_18322[(2)]);
var state_18322__$1 = state_18322;
var statearr_18327_18340 = state_18322__$1;
(statearr_18327_18340[(2)] = inst_18306);

(statearr_18327_18340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18323 === (5))){
var _ = (function (){var statearr_18328 = state_18322;
(statearr_18328[(4)] = cljs.core.rest((state_18322[(4)])));

return statearr_18328;
})();
var state_18322__$1 = state_18322;
var ex18326 = (state_18322__$1[(2)]);
var statearr_18329_18341 = state_18322__$1;
(statearr_18329_18341[(5)] = ex18326);


if((ex18326 instanceof Error)){
var statearr_18330_18342 = state_18322__$1;
(statearr_18330_18342[(1)] = (4));

(statearr_18330_18342[(5)] = null);

} else {
throw ex18326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18323 === (6))){
var inst_18316 = (state_18322[(2)]);
var inst_18317 = fluree.db.util.async.throw_err(inst_18316);
var _ = (function (){var statearr_18331 = state_18322;
(statearr_18331[(4)] = cljs.core.rest((state_18322[(4)])));

return statearr_18331;
})();
var state_18322__$1 = (function (){var statearr_18332 = state_18322;
(statearr_18332[(7)] = inst_18317);

return statearr_18332;
})();
var statearr_18333_18343 = state_18322__$1;
(statearr_18333_18343[(2)] = key);

(statearr_18333_18343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0 = (function (){
var statearr_18334 = [null,null,null,null,null,null,null,null];
(statearr_18334[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__);

(statearr_18334[(1)] = (1));

return statearr_18334;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1 = (function (state_18322){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18322);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18335){var ex__2687__auto__ = e18335;
var statearr_18336_18344 = state_18322;
(statearr_18336_18344[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18322[(4)]))){
var statearr_18337_18345 = state_18322;
(statearr_18337_18345[(1)] = cljs.core.first((state_18322[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18346 = state_18322;
state_18322 = G__18346;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = function(state_18322){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1.call(this,state_18322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18338 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18338[(6)] = c__2706__auto__);

return statearr_18338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__18347_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__18347_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__18348){
var map__18349 = p__18348;
var map__18349__$1 = cljs.core.__destructure_map(map__18349);
var progress = map__18349__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18349__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18377){
var state_val_18378 = (state_18377[(1)]);
if((state_val_18378 === (1))){
var state_18377__$1 = state_18377;
var statearr_18379_18395 = state_18377__$1;
(statearr_18379_18395[(2)] = null);

(statearr_18379_18395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18378 === (2))){
var inst_18363 = (state_18377[(7)]);
var _ = (function (){var statearr_18380 = state_18377;
(statearr_18380[(4)] = cljs.core.cons((5),(state_18377[(4)])));

return statearr_18380;
})();
var inst_18357 = db;
var inst_18358 = cljs.core.__destructure_map(inst_18357);
var inst_18359 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18358,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18360 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18358,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18361 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18358,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18362 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18358,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18363__$1 = fluree.db.storage.core.ledger_garbage_key(inst_18360,inst_18361,inst_18362);
var inst_18364 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_18365 = [inst_18361,inst_18362,garbage];
var inst_18366 = cljs.core.PersistentHashMap.fromArrays(inst_18364,inst_18365);
var inst_18367 = fluree.db.storage.core.serde(inst_18359);
var inst_18368 = fluree.db.serde.protocol._serialize_garbage(inst_18367,inst_18366);
var inst_18369 = fluree.db.storage.core.storage_write(inst_18359,inst_18363__$1,inst_18368);
var state_18377__$1 = (function (){var statearr_18381 = state_18377;
(statearr_18381[(7)] = inst_18363__$1);

return statearr_18381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18377__$1,(6),inst_18369);
} else {
if((state_val_18378 === (3))){
var inst_18375 = (state_18377[(2)]);
var state_18377__$1 = state_18377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18377__$1,inst_18375);
} else {
if((state_val_18378 === (4))){
var inst_18350 = (state_18377[(2)]);
var state_18377__$1 = state_18377;
var statearr_18383_18396 = state_18377__$1;
(statearr_18383_18396[(2)] = inst_18350);

(statearr_18383_18396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18378 === (5))){
var _ = (function (){var statearr_18384 = state_18377;
(statearr_18384[(4)] = cljs.core.rest((state_18377[(4)])));

return statearr_18384;
})();
var state_18377__$1 = state_18377;
var ex18382 = (state_18377__$1[(2)]);
var statearr_18385_18397 = state_18377__$1;
(statearr_18385_18397[(5)] = ex18382);


if((ex18382 instanceof Error)){
var statearr_18386_18398 = state_18377__$1;
(statearr_18386_18398[(1)] = (4));

(statearr_18386_18398[(5)] = null);

} else {
throw ex18382;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18378 === (6))){
var inst_18363 = (state_18377[(7)]);
var inst_18371 = (state_18377[(2)]);
var inst_18372 = fluree.db.util.async.throw_err(inst_18371);
var _ = (function (){var statearr_18387 = state_18377;
(statearr_18387[(4)] = cljs.core.rest((state_18377[(4)])));

return statearr_18387;
})();
var state_18377__$1 = (function (){var statearr_18388 = state_18377;
(statearr_18388[(8)] = inst_18372);

return statearr_18388;
})();
var statearr_18389_18399 = state_18377__$1;
(statearr_18389_18399[(2)] = inst_18363);

(statearr_18389_18399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_18390 = [null,null,null,null,null,null,null,null,null];
(statearr_18390[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__);

(statearr_18390[(1)] = (1));

return statearr_18390;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1 = (function (state_18377){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18377);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18391){var ex__2687__auto__ = e18391;
var statearr_18392_18400 = state_18377;
(statearr_18392_18400[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18377[(4)]))){
var statearr_18393_18401 = state_18377;
(statearr_18393_18401[(1)] = cljs.core.first((state_18377[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18402 = state_18377;
state_18377 = G__18402;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = function(state_18377){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1.call(this,state_18377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18394 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18394[(6)] = c__2706__auto__);

return statearr_18394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__18404 = arguments.length;
switch (G__18404) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18460){
var state_val_18461 = (state_18460[(1)]);
if((state_val_18461 === (7))){
var state_18460__$1 = state_18460;
var statearr_18462_18488 = state_18460__$1;
(statearr_18462_18488[(2)] = (0));

(statearr_18462_18488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (1))){
var state_18460__$1 = state_18460;
var statearr_18463_18489 = state_18460__$1;
(statearr_18463_18489[(2)] = null);

(statearr_18463_18489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (4))){
var inst_18405 = (state_18460[(2)]);
var state_18460__$1 = state_18460;
var statearr_18464_18490 = state_18460__$1;
(statearr_18464_18490[(2)] = inst_18405);

(statearr_18464_18490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (6))){
var inst_18430 = (state_18460[(7)]);
var state_18460__$1 = state_18460;
var statearr_18465_18491 = state_18460__$1;
(statearr_18465_18491[(2)] = inst_18430);

(statearr_18465_18491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (3))){
var inst_18458 = (state_18460[(2)]);
var state_18460__$1 = state_18460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18460__$1,inst_18458);
} else {
if((state_val_18461 === (12))){
var inst_18427 = (state_18460[(8)]);
var inst_18454 = (state_18460[(2)]);
var inst_18455 = fluree.db.util.async.throw_err(inst_18454);
var _ = (function (){var statearr_18466 = state_18460;
(statearr_18466[(4)] = cljs.core.rest((state_18460[(4)])));

return statearr_18466;
})();
var state_18460__$1 = (function (){var statearr_18467 = state_18460;
(statearr_18467[(9)] = inst_18455);

return statearr_18467;
})();
var statearr_18468_18492 = state_18460__$1;
(statearr_18468_18492[(2)] = inst_18427);

(statearr_18468_18492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (2))){
var inst_18420 = (state_18460[(10)]);
var inst_18430 = (state_18460[(7)]);
var inst_18418 = (state_18460[(11)]);
var inst_18422 = (state_18460[(12)]);
var _ = (function (){var statearr_18469 = state_18460;
(statearr_18469[(4)] = cljs.core.cons((5),(state_18460[(4)])));

return statearr_18469;
})();
var inst_18412 = db;
var inst_18413 = cljs.core.__destructure_map(inst_18412);
var inst_18414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18415 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_18416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_18417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_18418__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_18419 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18420__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_18422__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18423 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_18424 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_18425 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_18426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,new cljs.core.Keyword(null,"post","post",269697687));
var inst_18427 = fluree.db.storage.core.ledger_root_key(inst_18414,inst_18422__$1,inst_18420__$1);
var inst_18428 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_18429 = fluree.db.storage.core.child_data(inst_18421);
var inst_18430__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_18418__$1);
var state_18460__$1 = (function (){var statearr_18470 = state_18460;
(statearr_18470[(13)] = inst_18425);

(statearr_18470[(14)] = inst_18426);

(statearr_18470[(10)] = inst_18420__$1);

(statearr_18470[(7)] = inst_18430__$1);

(statearr_18470[(15)] = inst_18424);

(statearr_18470[(16)] = inst_18417);

(statearr_18470[(17)] = inst_18419);

(statearr_18470[(18)] = inst_18415);

(statearr_18470[(19)] = inst_18429);

(statearr_18470[(11)] = inst_18418__$1);

(statearr_18470[(8)] = inst_18427);

(statearr_18470[(12)] = inst_18422__$1);

(statearr_18470[(20)] = inst_18423);

(statearr_18470[(21)] = inst_18416);

(statearr_18470[(22)] = inst_18428);

return statearr_18470;
})();
if(cljs.core.truth_(inst_18430__$1)){
var statearr_18471_18493 = state_18460__$1;
(statearr_18471_18493[(1)] = (6));

} else {
var statearr_18472_18494 = state_18460__$1;
(statearr_18472_18494[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (11))){
var inst_18434 = (state_18460[(23)]);
var inst_18425 = (state_18460[(13)]);
var inst_18426 = (state_18460[(14)]);
var inst_18420 = (state_18460[(10)]);
var inst_18424 = (state_18460[(15)]);
var inst_18417 = (state_18460[(16)]);
var inst_18419 = (state_18460[(17)]);
var inst_18415 = (state_18460[(18)]);
var inst_18429 = (state_18460[(19)]);
var inst_18418 = (state_18460[(11)]);
var inst_18427 = (state_18460[(8)]);
var inst_18422 = (state_18460[(12)]);
var inst_18416 = (state_18460[(21)]);
var inst_18428 = (state_18460[(22)]);
var inst_18439 = (state_18460[(2)]);
var inst_18440 = fluree.db.storage.core.child_data(inst_18424);
var inst_18441 = fluree.db.storage.core.child_data(inst_18426);
var inst_18442 = fluree.db.util.core.current_time_millis();
var inst_18443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18444 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_18445 = (new cljs.core.PersistentVector(null,2,(5),inst_18443,inst_18444,null));
var inst_18446 = cljs.core.select_keys(inst_18418,inst_18445);
var inst_18447 = fluree.db.storage.core.child_data(inst_18417);
var inst_18448 = [inst_18420,inst_18429,inst_18422,inst_18434,inst_18439,inst_18440,inst_18441,inst_18415,inst_18442,inst_18416,inst_18425,inst_18446,inst_18447];
var inst_18449 = cljs.core.PersistentHashMap.fromArrays(inst_18428,inst_18448);
var inst_18450 = fluree.db.storage.core.serde(inst_18419);
var inst_18451 = fluree.db.serde.protocol._serialize_db_root(inst_18450,inst_18449);
var inst_18452 = fluree.db.storage.core.storage_write(inst_18419,inst_18427,inst_18451);
var state_18460__$1 = state_18460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18460__$1,(12),inst_18452);
} else {
if((state_val_18461 === (9))){
var inst_18435 = (state_18460[(24)]);
var state_18460__$1 = state_18460;
var statearr_18474_18495 = state_18460__$1;
(statearr_18474_18495[(2)] = inst_18435);

(statearr_18474_18495[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (5))){
var _ = (function (){var statearr_18475 = state_18460;
(statearr_18475[(4)] = cljs.core.rest((state_18460[(4)])));

return statearr_18475;
})();
var state_18460__$1 = state_18460;
var ex18473 = (state_18460__$1[(2)]);
var statearr_18476_18496 = state_18460__$1;
(statearr_18476_18496[(5)] = ex18473);


if((ex18473 instanceof Error)){
var statearr_18477_18497 = state_18460__$1;
(statearr_18477_18497[(1)] = (4));

(statearr_18477_18497[(5)] = null);

} else {
throw ex18473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (10))){
var inst_18423 = (state_18460[(20)]);
var state_18460__$1 = state_18460;
var statearr_18478_18498 = state_18460__$1;
(statearr_18478_18498[(2)] = inst_18423);

(statearr_18478_18498[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18461 === (8))){
var inst_18435 = (state_18460[(24)]);
var inst_18434 = (state_18460[(2)]);
var inst_18435__$1 = custom_ecount;
var state_18460__$1 = (function (){var statearr_18479 = state_18460;
(statearr_18479[(23)] = inst_18434);

(statearr_18479[(24)] = inst_18435__$1);

return statearr_18479;
})();
if(cljs.core.truth_(inst_18435__$1)){
var statearr_18480_18499 = state_18460__$1;
(statearr_18480_18499[(1)] = (9));

} else {
var statearr_18481_18500 = state_18460__$1;
(statearr_18481_18500[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_18482 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18482[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_18482[(1)] = (1));

return statearr_18482;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_18460){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18460);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18483){var ex__2687__auto__ = e18483;
var statearr_18484_18501 = state_18460;
(statearr_18484_18501[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18460[(4)]))){
var statearr_18485_18502 = state_18460;
(statearr_18485_18502[(1)] = cljs.core.first((state_18460[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18503 = state_18460;
state_18460 = G__18503;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_18460){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_18460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18486 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18486[(6)] = c__2706__auto__);

return statearr_18486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___18562 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18536){
var state_val_18537 = (state_18536[(1)]);
if((state_val_18537 === (7))){
var inst_18516 = (state_18536[(7)]);
var state_18536__$1 = state_18536;
var statearr_18538_18563 = state_18536__$1;
(statearr_18538_18563[(2)] = inst_18516);

(statearr_18538_18563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (1))){
var state_18536__$1 = state_18536;
var statearr_18539_18564 = state_18536__$1;
(statearr_18539_18564[(2)] = null);

(statearr_18539_18564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (4))){
var inst_18504 = (state_18536[(2)]);
var inst_18505 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18506 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18504);
var inst_18507 = cljs.core.async.close_BANG_(return_ch);
var state_18536__$1 = (function (){var statearr_18540 = state_18536;
(statearr_18540[(8)] = inst_18506);

(statearr_18540[(9)] = inst_18505);

return statearr_18540;
})();
var statearr_18541_18565 = state_18536__$1;
(statearr_18541_18565[(2)] = inst_18507);

(statearr_18541_18565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (6))){
var inst_18516 = (state_18536[(7)]);
var inst_18515 = (state_18536[(10)]);
var inst_18515__$1 = (state_18536[(2)]);
var inst_18516__$1 = (inst_18515__$1 == null);
var state_18536__$1 = (function (){var statearr_18542 = state_18536;
(statearr_18542[(7)] = inst_18516__$1);

(statearr_18542[(10)] = inst_18515__$1);

return statearr_18542;
})();
if(cljs.core.truth_(inst_18516__$1)){
var statearr_18543_18566 = state_18536__$1;
(statearr_18543_18566[(1)] = (7));

} else {
var statearr_18544_18567 = state_18536__$1;
(statearr_18544_18567[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (3))){
var inst_18534 = (state_18536[(2)]);
var state_18536__$1 = state_18536;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18536__$1,inst_18534);
} else {
if((state_val_18537 === (12))){
var inst_18531 = (state_18536[(2)]);
var _ = (function (){var statearr_18545 = state_18536;
(statearr_18545[(4)] = cljs.core.rest((state_18536[(4)])));

return statearr_18545;
})();
var state_18536__$1 = state_18536;
var statearr_18546_18568 = state_18536__$1;
(statearr_18546_18568[(2)] = inst_18531);

(statearr_18546_18568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (2))){
var _ = (function (){var statearr_18547 = state_18536;
(statearr_18547[(4)] = cljs.core.cons((5),(state_18536[(4)])));

return statearr_18547;
})();
var inst_18513 = fluree.db.storage.core.storage_read(conn,key);
var state_18536__$1 = state_18536;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18536__$1,(6),inst_18513);
} else {
if((state_val_18537 === (11))){
var inst_18515 = (state_18536[(10)]);
var inst_18525 = fluree.db.storage.core.serde(conn);
var inst_18526 = fluree.db.serde.protocol._deserialize_leaf(inst_18525,inst_18515);
var inst_18527 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18526);
var inst_18528 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_18527);
var inst_18529 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18528);
var state_18536__$1 = state_18536;
var statearr_18549_18569 = state_18536__$1;
(statearr_18549_18569[(2)] = inst_18529);

(statearr_18549_18569[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (9))){
var inst_18521 = (state_18536[(2)]);
var state_18536__$1 = state_18536;
if(cljs.core.truth_(inst_18521)){
var statearr_18550_18570 = state_18536__$1;
(statearr_18550_18570[(1)] = (10));

} else {
var statearr_18551_18571 = state_18536__$1;
(statearr_18551_18571[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (5))){
var _ = (function (){var statearr_18552 = state_18536;
(statearr_18552[(4)] = cljs.core.rest((state_18536[(4)])));

return statearr_18552;
})();
var state_18536__$1 = state_18536;
var ex18548 = (state_18536__$1[(2)]);
var statearr_18553_18572 = state_18536__$1;
(statearr_18553_18572[(5)] = ex18548);


var statearr_18554_18573 = state_18536__$1;
(statearr_18554_18573[(1)] = (4));

(statearr_18554_18573[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (10))){
var inst_18523 = cljs.core.async.close_BANG_(return_ch);
var state_18536__$1 = state_18536;
var statearr_18555_18574 = state_18536__$1;
(statearr_18555_18574[(2)] = inst_18523);

(statearr_18555_18574[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18537 === (8))){
var inst_18515 = (state_18536[(10)]);
var inst_18519 = (inst_18515 instanceof Error);
var state_18536__$1 = state_18536;
var statearr_18556_18575 = state_18536__$1;
(statearr_18556_18575[(2)] = inst_18519);

(statearr_18556_18575[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2684__auto____0 = (function (){
var statearr_18557 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18557[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2684__auto__);

(statearr_18557[(1)] = (1));

return statearr_18557;
});
var fluree$db$storage$core$reify_history_$_state_machine__2684__auto____1 = (function (state_18536){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18536);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18558){var ex__2687__auto__ = e18558;
var statearr_18559_18576 = state_18536;
(statearr_18559_18576[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18536[(4)]))){
var statearr_18560_18577 = state_18536;
(statearr_18560_18577[(1)] = cljs.core.first((state_18536[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18578 = state_18536;
state_18536 = G__18578;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2684__auto__ = function(state_18536){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2684__auto____1.call(this,state_18536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2684__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2684__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18561 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18561[(6)] = c__2706__auto___18562);

return statearr_18561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__18580 = arguments.length;
switch (G__18580) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___18692 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18643){
var state_val_18644 = (state_18643[(1)]);
if((state_val_18644 === (7))){
var state_18643__$1 = state_18643;
var statearr_18645_18693 = state_18643__$1;
(statearr_18645_18693[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_18645_18693[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (20))){
var inst_18622 = cljs.core.PersistentVector.EMPTY;
var state_18643__$1 = state_18643;
var statearr_18646_18694 = state_18643__$1;
(statearr_18646_18694[(2)] = inst_18622);

(statearr_18646_18694[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (1))){
var state_18643__$1 = state_18643;
var statearr_18647_18695 = state_18643__$1;
(statearr_18647_18695[(2)] = null);

(statearr_18647_18695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (24))){
var state_18643__$1 = state_18643;
var statearr_18648_18696 = state_18643__$1;
(statearr_18648_18696[(2)] = null);

(statearr_18648_18696[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (4))){
var inst_18583 = (state_18643[(2)]);
var inst_18584 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18585 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_18583);
var inst_18586 = cljs.core.async.close_BANG_(result_ch);
var state_18643__$1 = (function (){var statearr_18649 = state_18643;
(statearr_18649[(7)] = inst_18584);

(statearr_18649[(8)] = inst_18585);

return statearr_18649;
})();
var statearr_18650_18697 = state_18643__$1;
(statearr_18650_18697[(2)] = inst_18586);

(statearr_18650_18697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (15))){
var inst_18608 = (state_18643[(2)]);
var state_18643__$1 = state_18643;
var statearr_18651_18698 = state_18643__$1;
(statearr_18651_18698[(2)] = inst_18608);

(statearr_18651_18698[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (21))){
var inst_18612 = (state_18643[(9)]);
var inst_18625 = (state_18643[(10)]);
var inst_18596 = (state_18643[(11)]);
var inst_18595 = (state_18643[(12)]);
var inst_18597 = (state_18643[(13)]);
var inst_18632 = (state_18643[(2)]);
var inst_18633 = (function (){var base_node = inst_18595;
var first_flake = inst_18596;
var node_t = inst_18597;
var source = inst_18612;
var coll = inst_18625;
var conj_QMARK_ = inst_18632;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__18653 = f.p;
var fexpr__18652 = (function (){var or__5045__auto__ = remove_preds;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__18652.cljs$core$IFn$_invoke$arity$1 ? fexpr__18652.cljs$core$IFn$_invoke$arity$1(G__18653) : fexpr__18652.call(null,G__18653));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_18634 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18595);
var inst_18635 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_18633,inst_18634,inst_18625);
var inst_18636 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_18635);
var inst_18637 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18595,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18636);
var inst_18638 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_18637);
var _ = (function (){var statearr_18654 = state_18643;
(statearr_18654[(4)] = cljs.core.rest((state_18643[(4)])));

return statearr_18654;
})();
var state_18643__$1 = state_18643;
var statearr_18655_18699 = state_18643__$1;
(statearr_18655_18699[(2)] = inst_18638);

(statearr_18655_18699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (13))){
var state_18643__$1 = state_18643;
var statearr_18656_18700 = state_18643__$1;
(statearr_18656_18700[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_18656_18700[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (22))){
var inst_18612 = (state_18643[(9)]);
var inst_18625 = (state_18643[(10)]);
var inst_18596 = (state_18643[(11)]);
var inst_18595 = (state_18643[(12)]);
var inst_18597 = (state_18643[(13)]);
var inst_18626 = (function (){var base_node = inst_18595;
var first_flake = inst_18596;
var node_t = inst_18597;
var source = inst_18612;
var coll = inst_18625;
return (function (f){
return f.op === true;
});
})();
var state_18643__$1 = state_18643;
var statearr_18657_18701 = state_18643__$1;
(statearr_18657_18701[(2)] = inst_18626);

(statearr_18657_18701[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (6))){
var inst_18595 = (state_18643[(12)]);
var inst_18597 = (state_18643[(13)]);
var inst_18594 = (state_18643[(2)]);
var inst_18595__$1 = fluree.db.util.async.throw_err(inst_18594);
var inst_18596 = fluree.db.dbproto._first_flake(inst_18595__$1);
var inst_18597__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_18595__$1);
var inst_18598 = (inst_18597__$1 > t);
var state_18643__$1 = (function (){var statearr_18658 = state_18643;
(statearr_18658[(11)] = inst_18596);

(statearr_18658[(12)] = inst_18595__$1);

(statearr_18658[(13)] = inst_18597__$1);

return statearr_18658;
})();
if(cljs.core.truth_(inst_18598)){
var statearr_18659_18702 = state_18643__$1;
(statearr_18659_18702[(1)] = (7));

} else {
var statearr_18660_18703 = state_18643__$1;
(statearr_18660_18703[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (17))){
var inst_18596 = (state_18643[(11)]);
var inst_18613 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_18596,rhs,leftmost_QMARK_,t);
var state_18643__$1 = state_18643;
var statearr_18661_18704 = state_18643__$1;
(statearr_18661_18704[(2)] = inst_18613);

(statearr_18661_18704[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (3))){
var inst_18641 = (state_18643[(2)]);
var state_18643__$1 = state_18643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18643__$1,inst_18641);
} else {
if((state_val_18644 === (12))){
var inst_18610 = (state_18643[(2)]);
var state_18643__$1 = state_18643;
var statearr_18662_18705 = state_18643__$1;
(statearr_18662_18705[(2)] = inst_18610);

(statearr_18662_18705[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (2))){
var _ = (function (){var statearr_18663 = state_18643;
(statearr_18663[(4)] = cljs.core.cons((5),(state_18643[(4)])));

return statearr_18663;
})();
var inst_18592 = fluree.db.dbproto._resolve(node);
var state_18643__$1 = state_18643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18643__$1,(6),inst_18592);
} else {
if((state_val_18644 === (23))){
var inst_18612 = (state_18643[(9)]);
var inst_18625 = (state_18643[(10)]);
var inst_18596 = (state_18643[(11)]);
var inst_18595 = (state_18643[(12)]);
var inst_18597 = (state_18643[(13)]);
var inst_18628 = (function (){var base_node = inst_18595;
var first_flake = inst_18596;
var node_t = inst_18597;
var source = inst_18612;
var coll = inst_18625;
return (function (f){
return f.op === false;
});
})();
var state_18643__$1 = state_18643;
var statearr_18664_18706 = state_18643__$1;
(statearr_18664_18706[(2)] = inst_18628);

(statearr_18664_18706[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (19))){
var inst_18615 = (state_18643[(14)]);
var inst_18618 = (state_18643[(2)]);
var inst_18619 = fluree.db.util.async.throw_err(inst_18618);
var inst_18620 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_18615,inst_18619);
var state_18643__$1 = state_18643;
var statearr_18665_18707 = state_18643__$1;
(statearr_18665_18707[(2)] = inst_18620);

(statearr_18665_18707[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (11))){
var inst_18597 = (state_18643[(13)]);
var inst_18604 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18597,t);
var state_18643__$1 = state_18643;
if(inst_18604){
var statearr_18667_18708 = state_18643__$1;
(statearr_18667_18708[(1)] = (13));

} else {
var statearr_18668_18709 = state_18643__$1;
(statearr_18668_18709[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (9))){
var inst_18612 = (state_18643[(9)]);
var inst_18612__$1 = (state_18643[(2)]);
var state_18643__$1 = (function (){var statearr_18669 = state_18643;
(statearr_18669[(9)] = inst_18612__$1);

return statearr_18669;
})();
var G__18670_18710 = inst_18612__$1;
var G__18670_18711__$1 = (((G__18670_18710 instanceof cljs.core.Keyword))?G__18670_18710.fqn:null);
switch (G__18670_18711__$1) {
case "novelty":
var statearr_18671_18713 = state_18643__$1;
(statearr_18671_18713[(1)] = (17));


break;
case "history":
var statearr_18672_18714 = state_18643__$1;
(statearr_18672_18714[(1)] = (18));


break;
case "none":
var statearr_18673_18715 = state_18643__$1;
(statearr_18673_18715[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18670_18711__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (5))){
var _ = (function (){var statearr_18674 = state_18643;
(statearr_18674[(4)] = cljs.core.rest((state_18643[(4)])));

return statearr_18674;
})();
var state_18643__$1 = state_18643;
var ex18666 = (state_18643__$1[(2)]);
var statearr_18675_18716 = state_18643__$1;
(statearr_18675_18716[(5)] = ex18666);


var statearr_18676_18717 = state_18643__$1;
(statearr_18676_18717[(1)] = (4));

(statearr_18676_18717[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (14))){
var state_18643__$1 = state_18643;
var statearr_18677_18718 = state_18643__$1;
(statearr_18677_18718[(2)] = null);

(statearr_18677_18718[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (16))){
var inst_18612 = (state_18643[(9)]);
var inst_18625 = (state_18643[(2)]);
var state_18643__$1 = (function (){var statearr_18678 = state_18643;
(statearr_18678[(10)] = inst_18625);

return statearr_18678;
})();
var G__18679_18719 = inst_18612;
var G__18679_18720__$1 = (((G__18679_18719 instanceof cljs.core.Keyword))?G__18679_18719.fqn:null);
switch (G__18679_18720__$1) {
case "novelty":
var statearr_18680_18722 = state_18643__$1;
(statearr_18680_18722[(1)] = (22));


break;
case "history":
var statearr_18681_18723 = state_18643__$1;
(statearr_18681_18723[(1)] = (23));


break;
case "none":
var statearr_18682_18724 = state_18643__$1;
(statearr_18682_18724[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18679_18720__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (10))){
var state_18643__$1 = state_18643;
var statearr_18683_18725 = state_18643__$1;
(statearr_18683_18725[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_18683_18725[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18644 === (18))){
var inst_18612 = (state_18643[(9)]);
var inst_18596 = (state_18643[(11)]);
var inst_18595 = (state_18643[(12)]);
var inst_18597 = (state_18643[(13)]);
var inst_18615 = (function (){var base_node = inst_18595;
var first_flake = inst_18596;
var node_t = inst_18597;
var source = inst_18612;
return (function (p1__18582_SHARP_){
return (p1__18582_SHARP_.t <= t);
});
})();
var inst_18616 = fluree.db.dbproto._resolve_history(node);
var state_18643__$1 = (function (){var statearr_18684 = state_18643;
(statearr_18684[(14)] = inst_18615);

return statearr_18684;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18643__$1,(19),inst_18616);
} else {
if((state_val_18644 === (8))){
var inst_18597 = (state_18643[(13)]);
var inst_18601 = (inst_18597 < t);
var state_18643__$1 = state_18643;
if(cljs.core.truth_(inst_18601)){
var statearr_18685_18726 = state_18643__$1;
(statearr_18685_18726[(1)] = (10));

} else {
var statearr_18686_18727 = state_18643__$1;
(statearr_18686_18727[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2684__auto____0 = (function (){
var statearr_18687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18687[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2684__auto__);

(statearr_18687[(1)] = (1));

return statearr_18687;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2684__auto____1 = (function (state_18643){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18643);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18688){var ex__2687__auto__ = e18688;
var statearr_18689_18728 = state_18643;
(statearr_18689_18728[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18643[(4)]))){
var statearr_18690_18729 = state_18643;
(statearr_18690_18729[(1)] = cljs.core.first((state_18643[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18730 = state_18643;
state_18643 = G__18730;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2684__auto__ = function(state_18643){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2684__auto____1.call(this,state_18643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2684__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2684__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18691 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18691[(6)] = c__2706__auto___18692);

return statearr_18691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18790){
var state_val_18791 = (state_18790[(1)]);
if((state_val_18791 === (7))){
var inst_18741 = (state_18790[(7)]);
var inst_18745 = (inst_18741 <= from_t);
var state_18790__$1 = state_18790;
var statearr_18792_18832 = state_18790__$1;
(statearr_18792_18832[(2)] = inst_18745);

(statearr_18792_18832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (20))){
var inst_18775 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_18776 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18775)].join('');
var inst_18777 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18778 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18779 = cljs.core.PersistentHashMap.fromArrays(inst_18777,inst_18778);
var inst_18780 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18776,inst_18779);
var inst_18781 = (function(){throw inst_18780})();
var state_18790__$1 = state_18790;
var statearr_18793_18833 = state_18790__$1;
(statearr_18793_18833[(2)] = inst_18781);

(statearr_18793_18833[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (1))){
var state_18790__$1 = state_18790;
var statearr_18794_18834 = state_18790__$1;
(statearr_18794_18834[(2)] = null);

(statearr_18794_18834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (4))){
var inst_18733 = (state_18790[(2)]);
var inst_18734 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18733], 0));
var inst_18735 = (function(){throw inst_18733})();
var state_18790__$1 = (function (){var statearr_18795 = state_18790;
(statearr_18795[(8)] = inst_18734);

return statearr_18795;
})();
var statearr_18796_18835 = state_18790__$1;
(statearr_18796_18835[(2)] = inst_18735);

(statearr_18796_18835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (15))){
var inst_18760 = (state_18790[(2)]);
var state_18790__$1 = (function (){var statearr_18797 = state_18790;
(statearr_18797[(9)] = inst_18760);

return statearr_18797;
})();
if(cljs.core.truth_(from_t)){
var statearr_18798_18836 = state_18790__$1;
(statearr_18798_18836[(1)] = (16));

} else {
var statearr_18799_18837 = state_18790__$1;
(statearr_18799_18837[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (21))){
var inst_18771 = (state_18790[(10)]);
var inst_18770 = (state_18790[(11)]);
var inst_18769 = (state_18790[(12)]);
var inst_18783 = (state_18790[(2)]);
var inst_18784 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_18770,inst_18771,leftmost_QMARK_,to_t);
var inst_18785 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18784,inst_18769);
var _ = (function (){var statearr_18800 = state_18790;
(statearr_18800[(4)] = cljs.core.rest((state_18790[(4)])));

return statearr_18800;
})();
var state_18790__$1 = (function (){var statearr_18801 = state_18790;
(statearr_18801[(13)] = inst_18783);

return statearr_18801;
})();
var statearr_18802_18838 = state_18790__$1;
(statearr_18802_18838[(2)] = inst_18785);

(statearr_18802_18838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (13))){
var inst_18741 = (state_18790[(7)]);
var inst_18753 = (state_18790[(14)]);
var inst_18756 = (function (){var node_t = inst_18741;
var G__18749 = inst_18753;
return (function (p1__18731_SHARP_){
return (p1__18731_SHARP_.t < to_t);
});
})();
var inst_18757 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_18756,inst_18753);
var state_18790__$1 = state_18790;
var statearr_18803_18839 = state_18790__$1;
(statearr_18803_18839[(2)] = inst_18757);

(statearr_18803_18839[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (6))){
var inst_18742 = (state_18790[(15)]);
var state_18790__$1 = state_18790;
var statearr_18804_18840 = state_18790__$1;
(statearr_18804_18840[(2)] = inst_18742);

(statearr_18804_18840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (17))){
var inst_18760 = (state_18790[(9)]);
var state_18790__$1 = state_18790;
var statearr_18805_18841 = state_18790__$1;
(statearr_18805_18841[(2)] = inst_18760);

(statearr_18805_18841[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (3))){
var inst_18788 = (state_18790[(2)]);
var state_18790__$1 = state_18790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18790__$1,inst_18788);
} else {
if((state_val_18791 === (12))){
var inst_18741 = (state_18790[(7)]);
var inst_18752 = (state_18790[(2)]);
var inst_18753 = fluree.db.util.async.throw_err(inst_18752);
var inst_18754 = (to_t > inst_18741);
var state_18790__$1 = (function (){var statearr_18806 = state_18790;
(statearr_18806[(14)] = inst_18753);

return statearr_18806;
})();
if(cljs.core.truth_(inst_18754)){
var statearr_18807_18842 = state_18790__$1;
(statearr_18807_18842[(1)] = (13));

} else {
var statearr_18808_18843 = state_18790__$1;
(statearr_18808_18843[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (2))){
var inst_18742 = (state_18790[(15)]);
var _ = (function (){var statearr_18809 = state_18790;
(statearr_18809[(4)] = cljs.core.cons((5),(state_18790[(4)])));

return statearr_18809;
})();
var inst_18741 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_18742__$1 = (from_t == null);
var state_18790__$1 = (function (){var statearr_18810 = state_18790;
(statearr_18810[(15)] = inst_18742__$1);

(statearr_18810[(7)] = inst_18741);

return statearr_18810;
})();
if(cljs.core.truth_(inst_18742__$1)){
var statearr_18811_18844 = state_18790__$1;
(statearr_18811_18844[(1)] = (6));

} else {
var statearr_18812_18845 = state_18790__$1;
(statearr_18812_18845[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (19))){
var state_18790__$1 = state_18790;
var statearr_18813_18846 = state_18790__$1;
(statearr_18813_18846[(2)] = null);

(statearr_18813_18846[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (11))){
var inst_18769 = (state_18790[(2)]);
var inst_18770 = fluree.db.dbproto._first_flake(node);
var inst_18771 = fluree.db.dbproto._rhs(node);
var inst_18772 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18790__$1 = (function (){var statearr_18815 = state_18790;
(statearr_18815[(10)] = inst_18771);

(statearr_18815[(11)] = inst_18770);

(statearr_18815[(12)] = inst_18769);

return statearr_18815;
})();
if(cljs.core.truth_(inst_18772)){
var statearr_18816_18847 = state_18790__$1;
(statearr_18816_18847[(1)] = (19));

} else {
var statearr_18817_18848 = state_18790__$1;
(statearr_18817_18848[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (9))){
var inst_18750 = fluree.db.dbproto._resolve_history(node);
var state_18790__$1 = state_18790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18790__$1,(12),inst_18750);
} else {
if((state_val_18791 === (5))){
var _ = (function (){var statearr_18818 = state_18790;
(statearr_18818[(4)] = cljs.core.rest((state_18790[(4)])));

return statearr_18818;
})();
var state_18790__$1 = state_18790;
var ex18814 = (state_18790__$1[(2)]);
var statearr_18819_18849 = state_18790__$1;
(statearr_18819_18849[(5)] = ex18814);


var statearr_18820_18850 = state_18790__$1;
(statearr_18820_18850[(1)] = (4));

(statearr_18820_18850[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (14))){
var inst_18753 = (state_18790[(14)]);
var state_18790__$1 = state_18790;
var statearr_18821_18851 = state_18790__$1;
(statearr_18821_18851[(2)] = inst_18753);

(statearr_18821_18851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (16))){
var inst_18760 = (state_18790[(9)]);
var inst_18741 = (state_18790[(7)]);
var inst_18762 = (function (){var node_t = inst_18741;
var G__18749 = inst_18760;
return (function (p1__18732_SHARP_){
return (p1__18732_SHARP_.t <= from_t);
});
})();
var inst_18763 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_18762,inst_18760);
var state_18790__$1 = state_18790;
var statearr_18822_18852 = state_18790__$1;
(statearr_18822_18852[(2)] = inst_18763);

(statearr_18822_18852[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (10))){
var state_18790__$1 = state_18790;
var statearr_18823_18853 = state_18790__$1;
(statearr_18823_18853[(2)] = null);

(statearr_18823_18853[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (18))){
var inst_18766 = (state_18790[(2)]);
var state_18790__$1 = state_18790;
var statearr_18824_18854 = state_18790__$1;
(statearr_18824_18854[(2)] = inst_18766);

(statearr_18824_18854[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18791 === (8))){
var inst_18747 = (state_18790[(2)]);
var state_18790__$1 = state_18790;
if(cljs.core.truth_(inst_18747)){
var statearr_18825_18855 = state_18790__$1;
(statearr_18825_18855[(1)] = (9));

} else {
var statearr_18826_18856 = state_18790__$1;
(statearr_18826_18856[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto____0 = (function (){
var statearr_18827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18827[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto__);

(statearr_18827[(1)] = (1));

return statearr_18827;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto____1 = (function (state_18790){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18790);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18828){var ex__2687__auto__ = e18828;
var statearr_18829_18857 = state_18790;
(statearr_18829_18857[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18790[(4)]))){
var statearr_18830_18858 = state_18790;
(statearr_18830_18858[(1)] = cljs.core.first((state_18790[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18859 = state_18790;
state_18790 = G__18859;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto__ = function(state_18790){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto____1.call(this,state_18790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18831 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18831[(6)] = c__2706__auto__);

return statearr_18831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__5045__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__18860_18870 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18861_18871 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18860_18870,G__18861_18871) : object_cache.call(null,G__18860_18870,G__18861_18871));

var G__18862 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18863 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18864 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18865 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18864,G__18865) : object_cache.call(null,G__18864,G__18865));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18862,G__18863) : object_cache.call(null,G__18862,G__18863));
} else {
var G__18866 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18867 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18868 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18869 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18868,G__18869) : object_cache.call(null,G__18868,G__18869));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18866,G__18867) : object_cache.call(null,G__18866,G__18867));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18892){
var state_val_18893 = (state_18892[(1)]);
if((state_val_18893 === (7))){
var inst_18881 = (state_18892[(7)]);
var inst_18883 = fluree.db.storage.core.serde(conn);
var inst_18884 = fluree.db.serde.protocol._deserialize_branch(inst_18883,inst_18881);
var state_18892__$1 = state_18892;
var statearr_18894_18913 = state_18892__$1;
(statearr_18894_18913[(2)] = inst_18884);

(statearr_18894_18913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18893 === (1))){
var state_18892__$1 = state_18892;
var statearr_18895_18914 = state_18892__$1;
(statearr_18895_18914[(2)] = null);

(statearr_18895_18914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18893 === (4))){
var inst_18872 = (state_18892[(2)]);
var state_18892__$1 = state_18892;
var statearr_18896_18915 = state_18892__$1;
(statearr_18896_18915[(2)] = inst_18872);

(statearr_18896_18915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18893 === (6))){
var inst_18881 = (state_18892[(7)]);
var inst_18880 = (state_18892[(2)]);
var inst_18881__$1 = fluree.db.util.async.throw_err(inst_18880);
var state_18892__$1 = (function (){var statearr_18897 = state_18892;
(statearr_18897[(7)] = inst_18881__$1);

return statearr_18897;
})();
if(cljs.core.truth_(inst_18881__$1)){
var statearr_18898_18916 = state_18892__$1;
(statearr_18898_18916[(1)] = (7));

} else {
var statearr_18899_18917 = state_18892__$1;
(statearr_18899_18917[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18893 === (3))){
var inst_18890 = (state_18892[(2)]);
var state_18892__$1 = state_18892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18892__$1,inst_18890);
} else {
if((state_val_18893 === (2))){
var _ = (function (){var statearr_18901 = state_18892;
(statearr_18901[(4)] = cljs.core.cons((5),(state_18892[(4)])));

return statearr_18901;
})();
var inst_18878 = fluree.db.storage.core.storage_read(conn,key);
var state_18892__$1 = state_18892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18892__$1,(6),inst_18878);
} else {
if((state_val_18893 === (9))){
var inst_18887 = (state_18892[(2)]);
var _ = (function (){var statearr_18902 = state_18892;
(statearr_18902[(4)] = cljs.core.rest((state_18892[(4)])));

return statearr_18902;
})();
var state_18892__$1 = state_18892;
var statearr_18903_18918 = state_18892__$1;
(statearr_18903_18918[(2)] = inst_18887);

(statearr_18903_18918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18893 === (5))){
var _ = (function (){var statearr_18904 = state_18892;
(statearr_18904[(4)] = cljs.core.rest((state_18892[(4)])));

return statearr_18904;
})();
var state_18892__$1 = state_18892;
var ex18900 = (state_18892__$1[(2)]);
var statearr_18905_18919 = state_18892__$1;
(statearr_18905_18919[(5)] = ex18900);


if((ex18900 instanceof Error)){
var statearr_18906_18920 = state_18892__$1;
(statearr_18906_18920[(1)] = (4));

(statearr_18906_18920[(5)] = null);

} else {
throw ex18900;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18893 === (8))){
var state_18892__$1 = state_18892;
var statearr_18907_18921 = state_18892__$1;
(statearr_18907_18921[(2)] = null);

(statearr_18907_18921[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0 = (function (){
var statearr_18908 = [null,null,null,null,null,null,null,null];
(statearr_18908[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2684__auto__);

(statearr_18908[(1)] = (1));

return statearr_18908;
});
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1 = (function (state_18892){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18892);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18909){var ex__2687__auto__ = e18909;
var statearr_18910_18922 = state_18892;
(statearr_18910_18922[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18892[(4)]))){
var statearr_18911_18923 = state_18892;
(statearr_18911_18923[(1)] = cljs.core.first((state_18892[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18924 = state_18892;
state_18892 = G__18924;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = function(state_18892){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1.call(this,state_18892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18912 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18912[(6)] = c__2706__auto__);

return statearr_18912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___19003 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18975){
var state_val_18976 = (state_18975[(1)]);
if((state_val_18976 === (7))){
var inst_18942 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18943 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18944 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18945 = cljs.core.PersistentHashMap.fromArrays(inst_18943,inst_18944);
var inst_18946 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18942,inst_18945);
var inst_18947 = (function(){throw inst_18946})();
var state_18975__$1 = state_18975;
var statearr_18977_19004 = state_18975__$1;
(statearr_18977_19004[(2)] = inst_18947);

(statearr_18977_19004[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (1))){
var state_18975__$1 = state_18975;
var statearr_18978_19005 = state_18975__$1;
(statearr_18978_19005[(2)] = null);

(statearr_18978_19005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (4))){
var inst_18925 = (state_18975[(2)]);
var inst_18926 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18927 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18925);
var inst_18928 = cljs.core.async.close_BANG_(return_ch);
var state_18975__$1 = (function (){var statearr_18979 = state_18975;
(statearr_18979[(7)] = inst_18926);

(statearr_18979[(8)] = inst_18927);

return statearr_18979;
})();
var statearr_18980_19006 = state_18975__$1;
(statearr_18980_19006[(2)] = inst_18928);

(statearr_18980_19006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (6))){
var inst_18939 = (state_18975[(9)]);
var inst_18938 = (state_18975[(2)]);
var inst_18939__$1 = fluree.db.util.async.throw_err(inst_18938);
var inst_18940 = (inst_18939__$1 == null);
var state_18975__$1 = (function (){var statearr_18981 = state_18975;
(statearr_18981[(9)] = inst_18939__$1);

return statearr_18981;
})();
if(cljs.core.truth_(inst_18940)){
var statearr_18982_19007 = state_18975__$1;
(statearr_18982_19007[(1)] = (7));

} else {
var statearr_18983_19008 = state_18975__$1;
(statearr_18983_19008[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (3))){
var inst_18973 = (state_18975[(2)]);
var state_18975__$1 = state_18975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18975__$1,inst_18973);
} else {
if((state_val_18976 === (12))){
var inst_18939 = (state_18975[(9)]);
var inst_18956 = (state_18975[(2)]);
var inst_18957 = cljs.core.__destructure_map(inst_18939);
var inst_18958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18957,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18957,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18960 = config;
var inst_18961 = cljs.core.__destructure_map(inst_18960);
var inst_18962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18961,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18964 = (function (){var data = inst_18939;
var _ = inst_18956;
var map__18934 = inst_18957;
var children = inst_18958;
var rhs = inst_18959;
var map__18935 = inst_18961;
var comparator = inst_18962;
return (function (idx,p__18963){
var map__18984 = p__18963;
var map__18984__$1 = cljs.core.__destructure_map(map__18984);
var child = map__18984__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18984__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18984__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18984__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18984__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18984__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (idx === (0));
} else {
return and__5043__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_18965 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18964,inst_18958);
var inst_18966 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_18965);
var inst_18967 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_18966,inst_18965);
var inst_18968 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_18962,inst_18967);
var inst_18969 = fluree.db.index.__GT_IndexNode(block,t,inst_18959,inst_18968,config,leftmost_QMARK_);
var inst_18970 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18969);
var _ = (function (){var statearr_18985 = state_18975;
(statearr_18985[(4)] = cljs.core.rest((state_18975[(4)])));

return statearr_18985;
})();
var state_18975__$1 = state_18975;
var statearr_18986_19009 = state_18975__$1;
(statearr_18986_19009[(2)] = inst_18970);

(statearr_18986_19009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (2))){
var _ = (function (){var statearr_18987 = state_18975;
(statearr_18987[(4)] = cljs.core.cons((5),(state_18975[(4)])));

return statearr_18987;
})();
var inst_18936 = fluree.db.storage.core.read_branch(conn,key);
var state_18975__$1 = state_18975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18975__$1,(6),inst_18936);
} else {
if((state_val_18976 === (11))){
var state_18975__$1 = state_18975;
var statearr_18989_19010 = state_18975__$1;
(statearr_18989_19010[(2)] = null);

(statearr_18989_19010[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (9))){
var inst_18939 = (state_18975[(9)]);
var inst_18950 = (state_18975[(2)]);
var inst_18951 = fluree.db.util.core.exception_QMARK_(inst_18939);
var state_18975__$1 = (function (){var statearr_18990 = state_18975;
(statearr_18990[(10)] = inst_18950);

return statearr_18990;
})();
if(inst_18951){
var statearr_18991_19011 = state_18975__$1;
(statearr_18991_19011[(1)] = (10));

} else {
var statearr_18992_19012 = state_18975__$1;
(statearr_18992_19012[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (5))){
var _ = (function (){var statearr_18993 = state_18975;
(statearr_18993[(4)] = cljs.core.rest((state_18975[(4)])));

return statearr_18993;
})();
var state_18975__$1 = state_18975;
var ex18988 = (state_18975__$1[(2)]);
var statearr_18994_19013 = state_18975__$1;
(statearr_18994_19013[(5)] = ex18988);


var statearr_18995_19014 = state_18975__$1;
(statearr_18995_19014[(1)] = (4));

(statearr_18995_19014[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (10))){
var inst_18939 = (state_18975[(9)]);
var inst_18953 = (function(){throw inst_18939})();
var state_18975__$1 = state_18975;
var statearr_18996_19015 = state_18975__$1;
(statearr_18996_19015[(2)] = inst_18953);

(statearr_18996_19015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18976 === (8))){
var state_18975__$1 = state_18975;
var statearr_18997_19016 = state_18975__$1;
(statearr_18997_19016[(2)] = null);

(statearr_18997_19016[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2684__auto____0 = (function (){
var statearr_18998 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18998[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2684__auto__);

(statearr_18998[(1)] = (1));

return statearr_18998;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2684__auto____1 = (function (state_18975){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18975);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18999){var ex__2687__auto__ = e18999;
var statearr_19000_19017 = state_18975;
(statearr_19000_19017[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18975[(4)]))){
var statearr_19001_19018 = state_18975;
(statearr_19001_19018[(1)] = cljs.core.first((state_18975[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19019 = state_18975;
state_18975 = G__19019;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2684__auto__ = function(state_18975){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2684__auto____1.call(this,state_18975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2684__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2684__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19002 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19002[(6)] = c__2706__auto___19003);

return statearr_19002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19040){
var state_val_19041 = (state_19040[(1)]);
if((state_val_19041 === (7))){
var state_19040__$1 = state_19040;
var statearr_19042_19062 = state_19040__$1;
(statearr_19042_19062[(2)] = null);

(statearr_19042_19062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (1))){
var state_19040__$1 = state_19040;
var statearr_19043_19063 = state_19040__$1;
(statearr_19043_19063[(2)] = null);

(statearr_19043_19063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (4))){
var inst_19020 = (state_19040[(2)]);
var state_19040__$1 = state_19040;
var statearr_19044_19064 = state_19040__$1;
(statearr_19044_19064[(2)] = inst_19020);

(statearr_19044_19064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (6))){
var inst_19026 = (state_19040[(7)]);
var inst_19028 = fluree.db.storage.core.serde(conn);
var state_19040__$1 = (function (){var statearr_19045 = state_19040;
(statearr_19045[(8)] = inst_19028);

return statearr_19045;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19040__$1,(9),inst_19026);
} else {
if((state_val_19041 === (3))){
var inst_19038 = (state_19040[(2)]);
var state_19040__$1 = state_19040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19040__$1,inst_19038);
} else {
if((state_val_19041 === (2))){
var inst_19026 = (state_19040[(7)]);
var _ = (function (){var statearr_19047 = state_19040;
(statearr_19047[(4)] = cljs.core.cons((5),(state_19040[(4)])));

return statearr_19047;
})();
var inst_19026__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_19040__$1 = (function (){var statearr_19048 = state_19040;
(statearr_19048[(7)] = inst_19026__$1);

return statearr_19048;
})();
if(cljs.core.truth_(inst_19026__$1)){
var statearr_19049_19065 = state_19040__$1;
(statearr_19049_19065[(1)] = (6));

} else {
var statearr_19050_19066 = state_19040__$1;
(statearr_19050_19066[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (9))){
var inst_19028 = (state_19040[(8)]);
var inst_19030 = (state_19040[(2)]);
var inst_19031 = fluree.db.util.async.throw_err(inst_19030);
var inst_19032 = fluree.db.serde.protocol._deserialize_leaf(inst_19028,inst_19031);
var state_19040__$1 = state_19040;
var statearr_19051_19067 = state_19040__$1;
(statearr_19051_19067[(2)] = inst_19032);

(statearr_19051_19067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (5))){
var _ = (function (){var statearr_19052 = state_19040;
(statearr_19052[(4)] = cljs.core.rest((state_19040[(4)])));

return statearr_19052;
})();
var state_19040__$1 = state_19040;
var ex19046 = (state_19040__$1[(2)]);
var statearr_19053_19068 = state_19040__$1;
(statearr_19053_19068[(5)] = ex19046);


if((ex19046 instanceof Error)){
var statearr_19054_19069 = state_19040__$1;
(statearr_19054_19069[(1)] = (4));

(statearr_19054_19069[(5)] = null);

} else {
throw ex19046;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (8))){
var inst_19035 = (state_19040[(2)]);
var _ = (function (){var statearr_19055 = state_19040;
(statearr_19055[(4)] = cljs.core.rest((state_19040[(4)])));

return statearr_19055;
})();
var state_19040__$1 = state_19040;
var statearr_19056_19070 = state_19040__$1;
(statearr_19056_19070[(2)] = inst_19035);

(statearr_19056_19070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_19057 = [null,null,null,null,null,null,null,null,null];
(statearr_19057[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__);

(statearr_19057[(1)] = (1));

return statearr_19057;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1 = (function (state_19040){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19040);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19058){var ex__2687__auto__ = e19058;
var statearr_19059_19071 = state_19040;
(statearr_19059_19071[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19040[(4)]))){
var statearr_19060_19072 = state_19040;
(statearr_19060_19072[(1)] = cljs.core.first((state_19040[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19073 = state_19040;
state_19040 = G__19073;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = function(state_19040){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1.call(this,state_19040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19061 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19061[(6)] = c__2706__auto__);

return statearr_19061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___19146 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19118){
var state_val_19119 = (state_19118[(1)]);
if((state_val_19119 === (7))){
var inst_19090 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_19091 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19092 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_19093 = cljs.core.PersistentHashMap.fromArrays(inst_19091,inst_19092);
var inst_19094 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19090,inst_19093);
var inst_19095 = (function(){throw inst_19094})();
var state_19118__$1 = state_19118;
var statearr_19120_19147 = state_19118__$1;
(statearr_19120_19147[(2)] = inst_19095);

(statearr_19120_19147[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (1))){
var state_19118__$1 = state_19118;
var statearr_19121_19148 = state_19118__$1;
(statearr_19121_19148[(2)] = null);

(statearr_19121_19148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (4))){
var inst_19074 = (state_19118[(2)]);
var inst_19075 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_19076 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_19074);
var inst_19077 = cljs.core.async.close_BANG_(return_ch);
var state_19118__$1 = (function (){var statearr_19122 = state_19118;
(statearr_19122[(7)] = inst_19075);

(statearr_19122[(8)] = inst_19076);

return statearr_19122;
})();
var statearr_19123_19149 = state_19118__$1;
(statearr_19123_19149[(2)] = inst_19077);

(statearr_19123_19149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (6))){
var inst_19087 = (state_19118[(9)]);
var inst_19087__$1 = (state_19118[(2)]);
var inst_19088 = (inst_19087__$1 == null);
var state_19118__$1 = (function (){var statearr_19124 = state_19118;
(statearr_19124[(9)] = inst_19087__$1);

return statearr_19124;
})();
if(cljs.core.truth_(inst_19088)){
var statearr_19125_19150 = state_19118__$1;
(statearr_19125_19150[(1)] = (7));

} else {
var statearr_19126_19151 = state_19118__$1;
(statearr_19126_19151[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (3))){
var inst_19116 = (state_19118[(2)]);
var state_19118__$1 = state_19118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19118__$1,inst_19116);
} else {
if((state_val_19119 === (12))){
var inst_19087 = (state_19118[(9)]);
var inst_19104 = (state_19118[(2)]);
var inst_19105 = cljs.core.__destructure_map(inst_19087);
var inst_19106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19105,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_19107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19105,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_19108 = config;
var inst_19109 = cljs.core.__destructure_map(inst_19108);
var inst_19110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19109,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_19111 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_19110,inst_19106);
var inst_19112 = fluree.db.index.data_node(block,t,inst_19111,rhs,config);
var inst_19113 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_19112);
var _ = (function (){var statearr_19127 = state_19118;
(statearr_19127[(4)] = cljs.core.rest((state_19118[(4)])));

return statearr_19127;
})();
var state_19118__$1 = (function (){var statearr_19128 = state_19118;
(statearr_19128[(10)] = inst_19107);

(statearr_19128[(11)] = inst_19104);

return statearr_19128;
})();
var statearr_19129_19152 = state_19118__$1;
(statearr_19129_19152[(2)] = inst_19113);

(statearr_19129_19152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (2))){
var _ = (function (){var statearr_19130 = state_19118;
(statearr_19130[(4)] = cljs.core.cons((5),(state_19118[(4)])));

return statearr_19130;
})();
var inst_19085 = fluree.db.storage.core.read_leaf(conn,key);
var state_19118__$1 = state_19118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19118__$1,(6),inst_19085);
} else {
if((state_val_19119 === (11))){
var state_19118__$1 = state_19118;
var statearr_19132_19153 = state_19118__$1;
(statearr_19132_19153[(2)] = null);

(statearr_19132_19153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (9))){
var inst_19087 = (state_19118[(9)]);
var inst_19098 = (state_19118[(2)]);
var inst_19099 = fluree.db.util.core.exception_QMARK_(inst_19087);
var state_19118__$1 = (function (){var statearr_19133 = state_19118;
(statearr_19133[(12)] = inst_19098);

return statearr_19133;
})();
if(inst_19099){
var statearr_19134_19154 = state_19118__$1;
(statearr_19134_19154[(1)] = (10));

} else {
var statearr_19135_19155 = state_19118__$1;
(statearr_19135_19155[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (5))){
var _ = (function (){var statearr_19136 = state_19118;
(statearr_19136[(4)] = cljs.core.rest((state_19118[(4)])));

return statearr_19136;
})();
var state_19118__$1 = state_19118;
var ex19131 = (state_19118__$1[(2)]);
var statearr_19137_19156 = state_19118__$1;
(statearr_19137_19156[(5)] = ex19131);


var statearr_19138_19157 = state_19118__$1;
(statearr_19138_19157[(1)] = (4));

(statearr_19138_19157[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (10))){
var inst_19087 = (state_19118[(9)]);
var inst_19101 = (function(){throw inst_19087})();
var state_19118__$1 = state_19118;
var statearr_19139_19158 = state_19118__$1;
(statearr_19139_19158[(2)] = inst_19101);

(statearr_19139_19158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19119 === (8))){
var state_19118__$1 = state_19118;
var statearr_19140_19159 = state_19118__$1;
(statearr_19140_19159[(2)] = null);

(statearr_19140_19159[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_19141 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19141[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto__);

(statearr_19141[(1)] = (1));

return statearr_19141;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto____1 = (function (state_19118){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19118);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19142){var ex__2687__auto__ = e19142;
var statearr_19143_19160 = state_19118;
(statearr_19143_19160[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19118[(4)]))){
var statearr_19144_19161 = state_19118;
(statearr_19144_19161[(1)] = cljs.core.first((state_19118[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19162 = state_19118;
state_19118 = G__19162;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto__ = function(state_19118){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto____1.call(this,state_19118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19145 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19145[(6)] = c__2706__auto___19146);

return statearr_19145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k19164,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__19168 = k19164;
var G__19168__$1 = (((G__19168 instanceof cljs.core.Keyword))?G__19168.fqn:null);
switch (G__19168__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k19164,else__5346__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__19169){
var vec__19170 = p__19169;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19170,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19170,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19163){
var self__ = this;
var G__19163__$1 = this;
return (new cljs.core.RecordIter((0),G__19163__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__19173 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__19174 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__19175 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__19176 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19175,G__19176) : object_cache.call(null,G__19175,G__19176));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__19177 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__19178 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19177,G__19178) : object_cache.call(null,G__19177,G__19178));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19173,G__19174) : object_cache.call(null,G__19173,G__19174));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__19179 = history_id;
var G__19180 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19179,G__19180) : object_cache.call(null,G__19179,G__19180));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__19181 = (function (coll__5340__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__19181(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19165,other19166){
var self__ = this;
var this19165__$1 = this;
return (((!((other19166 == null)))) && ((((this19165__$1.constructor === other19166.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.conn,other19166.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.config,other19166.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.network,other19166.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.dbid,other19166.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.id,other19166.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.leaf,other19166.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.first,other19166.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.rhs,other19166.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.size,other19166.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.block,other19166.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.t,other19166.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.tt_id,other19166.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.leftmost_QMARK_,other19166.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.tempid,other19166.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19165__$1.__extmap,other19166.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k19164){
var self__ = this;
var this__5350__auto____$1 = this;
var G__19182 = k19164;
var G__19182__$1 = (((G__19182 instanceof cljs.core.Keyword))?G__19182.fqn:null);
switch (G__19182__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k19164);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__19163){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__19183 = cljs.core.keyword_identical_QMARK_;
var expr__19184 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__19186 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__19187 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19186,G__19187) : pred__19183.call(null,G__19186,G__19187));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__19163,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19188 = new cljs.core.Keyword(null,"config","config",994861415);
var G__19189 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19188,G__19189) : pred__19183.call(null,G__19188,G__19189));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__19163,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19190 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__19191 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19190,G__19191) : pred__19183.call(null,G__19190,G__19191));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__19163,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19192 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__19193 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19192,G__19193) : pred__19183.call(null,G__19192,G__19193));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__19163,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19194 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__19195 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19194,G__19195) : pred__19183.call(null,G__19194,G__19195));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__19163,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19196 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__19197 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19196,G__19197) : pred__19183.call(null,G__19196,G__19197));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__19163,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19198 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__19199 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19198,G__19199) : pred__19183.call(null,G__19198,G__19199));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__19163,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19200 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__19201 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19200,G__19201) : pred__19183.call(null,G__19200,G__19201));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__19163,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19202 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__19203 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19202,G__19203) : pred__19183.call(null,G__19202,G__19203));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__19163,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19204 = new cljs.core.Keyword(null,"block","block",664686210);
var G__19205 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19204,G__19205) : pred__19183.call(null,G__19204,G__19205));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__19163,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19206 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__19207 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19206,G__19207) : pred__19183.call(null,G__19206,G__19207));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__19163,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19208 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__19209 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19208,G__19209) : pred__19183.call(null,G__19208,G__19209));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__19163,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19210 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__19211 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19210,G__19211) : pred__19183.call(null,G__19210,G__19211));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__19163,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19212 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__19213 = expr__19184;
return (pred__19183.cljs$core$IFn$_invoke$arity$2 ? pred__19183.cljs$core$IFn$_invoke$arity$2(G__19212,G__19213) : pred__19183.call(null,G__19212,G__19213));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__19163,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__19163),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__19163){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__19163,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__19167){
var extmap__5385__auto__ = (function (){var G__19214 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__19167,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__19167)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__19214);
} else {
return G__19214;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__19167),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__19167),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__19217 = blank_db;
var map__19217__$1 = cljs.core.__destructure_map(map__19217);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19217__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19217__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19217__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__19218 = root_data;
var map__19218__$1 = cljs.core.__destructure_map(map__19218);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19218__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19218__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19218__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19218__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19240){
var state_val_19241 = (state_19240[(1)]);
if((state_val_19241 === (7))){
var state_19240__$1 = state_19240;
var statearr_19242_19262 = state_19240__$1;
(statearr_19242_19262[(2)] = null);

(statearr_19242_19262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19241 === (1))){
var state_19240__$1 = state_19240;
var statearr_19243_19263 = state_19240__$1;
(statearr_19243_19263[(2)] = null);

(statearr_19243_19263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19241 === (4))){
var inst_19219 = (state_19240[(2)]);
var state_19240__$1 = state_19240;
var statearr_19244_19264 = state_19240__$1;
(statearr_19244_19264[(2)] = inst_19219);

(statearr_19244_19264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19241 === (6))){
var inst_19226 = (state_19240[(7)]);
var inst_19228 = fluree.db.storage.core.serde(conn);
var state_19240__$1 = (function (){var statearr_19245 = state_19240;
(statearr_19245[(8)] = inst_19228);

return statearr_19245;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19240__$1,(9),inst_19226);
} else {
if((state_val_19241 === (3))){
var inst_19238 = (state_19240[(2)]);
var state_19240__$1 = state_19240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19240__$1,inst_19238);
} else {
if((state_val_19241 === (2))){
var inst_19226 = (state_19240[(7)]);
var _ = (function (){var statearr_19247 = state_19240;
(statearr_19247[(4)] = cljs.core.cons((5),(state_19240[(4)])));

return statearr_19247;
})();
var inst_19225 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_19226__$1 = fluree.db.storage.core.storage_read(conn,inst_19225);
var state_19240__$1 = (function (){var statearr_19248 = state_19240;
(statearr_19248[(7)] = inst_19226__$1);

return statearr_19248;
})();
if(cljs.core.truth_(inst_19226__$1)){
var statearr_19249_19265 = state_19240__$1;
(statearr_19249_19265[(1)] = (6));

} else {
var statearr_19250_19266 = state_19240__$1;
(statearr_19250_19266[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19241 === (9))){
var inst_19228 = (state_19240[(8)]);
var inst_19230 = (state_19240[(2)]);
var inst_19231 = fluree.db.util.async.throw_err(inst_19230);
var inst_19232 = fluree.db.serde.protocol._deserialize_garbage(inst_19228,inst_19231);
var state_19240__$1 = state_19240;
var statearr_19251_19267 = state_19240__$1;
(statearr_19251_19267[(2)] = inst_19232);

(statearr_19251_19267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19241 === (5))){
var _ = (function (){var statearr_19252 = state_19240;
(statearr_19252[(4)] = cljs.core.rest((state_19240[(4)])));

return statearr_19252;
})();
var state_19240__$1 = state_19240;
var ex19246 = (state_19240__$1[(2)]);
var statearr_19253_19268 = state_19240__$1;
(statearr_19253_19268[(5)] = ex19246);


if((ex19246 instanceof Error)){
var statearr_19254_19269 = state_19240__$1;
(statearr_19254_19269[(1)] = (4));

(statearr_19254_19269[(5)] = null);

} else {
throw ex19246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19241 === (8))){
var inst_19235 = (state_19240[(2)]);
var _ = (function (){var statearr_19255 = state_19240;
(statearr_19255[(4)] = cljs.core.rest((state_19240[(4)])));

return statearr_19255;
})();
var state_19240__$1 = state_19240;
var statearr_19256_19270 = state_19240__$1;
(statearr_19256_19270[(2)] = inst_19235);

(statearr_19256_19270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_19257 = [null,null,null,null,null,null,null,null,null];
(statearr_19257[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__);

(statearr_19257[(1)] = (1));

return statearr_19257;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1 = (function (state_19240){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19240);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19258){var ex__2687__auto__ = e19258;
var statearr_19259_19271 = state_19240;
(statearr_19259_19271[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19240[(4)]))){
var statearr_19260_19272 = state_19240;
(statearr_19260_19272[(1)] = cljs.core.first((state_19240[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19273 = state_19240;
state_19240 = G__19273;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = function(state_19240){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1.call(this,state_19240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19261 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19261[(6)] = c__2706__auto__);

return statearr_19261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19295){
var state_val_19296 = (state_19295[(1)]);
if((state_val_19296 === (7))){
var inst_19284 = (state_19295[(7)]);
var inst_19286 = fluree.db.storage.core.serde(conn);
var inst_19287 = fluree.db.serde.protocol._deserialize_db_root(inst_19286,inst_19284);
var state_19295__$1 = state_19295;
var statearr_19297_19316 = state_19295__$1;
(statearr_19297_19316[(2)] = inst_19287);

(statearr_19297_19316[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19296 === (1))){
var state_19295__$1 = state_19295;
var statearr_19298_19317 = state_19295__$1;
(statearr_19298_19317[(2)] = null);

(statearr_19298_19317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19296 === (4))){
var inst_19274 = (state_19295[(2)]);
var state_19295__$1 = state_19295;
var statearr_19299_19318 = state_19295__$1;
(statearr_19299_19318[(2)] = inst_19274);

(statearr_19299_19318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19296 === (6))){
var inst_19284 = (state_19295[(7)]);
var inst_19283 = (state_19295[(2)]);
var inst_19284__$1 = fluree.db.util.async.throw_err(inst_19283);
var state_19295__$1 = (function (){var statearr_19300 = state_19295;
(statearr_19300[(7)] = inst_19284__$1);

return statearr_19300;
})();
if(cljs.core.truth_(inst_19284__$1)){
var statearr_19301_19319 = state_19295__$1;
(statearr_19301_19319[(1)] = (7));

} else {
var statearr_19302_19320 = state_19295__$1;
(statearr_19302_19320[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19296 === (3))){
var inst_19293 = (state_19295[(2)]);
var state_19295__$1 = state_19295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19295__$1,inst_19293);
} else {
if((state_val_19296 === (2))){
var _ = (function (){var statearr_19304 = state_19295;
(statearr_19304[(4)] = cljs.core.cons((5),(state_19295[(4)])));

return statearr_19304;
})();
var inst_19280 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_19281 = fluree.db.storage.core.storage_read(conn,inst_19280);
var state_19295__$1 = state_19295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19295__$1,(6),inst_19281);
} else {
if((state_val_19296 === (9))){
var inst_19290 = (state_19295[(2)]);
var _ = (function (){var statearr_19305 = state_19295;
(statearr_19305[(4)] = cljs.core.rest((state_19295[(4)])));

return statearr_19305;
})();
var state_19295__$1 = state_19295;
var statearr_19306_19321 = state_19295__$1;
(statearr_19306_19321[(2)] = inst_19290);

(statearr_19306_19321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19296 === (5))){
var _ = (function (){var statearr_19307 = state_19295;
(statearr_19307[(4)] = cljs.core.rest((state_19295[(4)])));

return statearr_19307;
})();
var state_19295__$1 = state_19295;
var ex19303 = (state_19295__$1[(2)]);
var statearr_19308_19322 = state_19295__$1;
(statearr_19308_19322[(5)] = ex19303);


if((ex19303 instanceof Error)){
var statearr_19309_19323 = state_19295__$1;
(statearr_19309_19323[(1)] = (4));

(statearr_19309_19323[(5)] = null);

} else {
throw ex19303;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19296 === (8))){
var state_19295__$1 = state_19295;
var statearr_19310_19324 = state_19295__$1;
(statearr_19310_19324[(2)] = null);

(statearr_19310_19324[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0 = (function (){
var statearr_19311 = [null,null,null,null,null,null,null,null];
(statearr_19311[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__);

(statearr_19311[(1)] = (1));

return statearr_19311;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1 = (function (state_19295){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19295);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19312){var ex__2687__auto__ = e19312;
var statearr_19313_19325 = state_19295;
(statearr_19313_19325[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19295[(4)]))){
var statearr_19314_19326 = state_19295;
(statearr_19314_19326[(1)] = cljs.core.first((state_19295[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19327 = state_19295;
state_19295 = G__19327;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = function(state_19295){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1.call(this,state_19295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19315 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19315[(6)] = c__2706__auto__);

return statearr_19315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19363){
var state_val_19364 = (state_19363[(1)]);
if((state_val_19364 === (7))){
var inst_19337 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_19338 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19339 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_19340 = cljs.core.PersistentHashMap.fromArrays(inst_19338,inst_19339);
var inst_19341 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19337,inst_19340);
var inst_19342 = (function(){throw inst_19341})();
var state_19363__$1 = state_19363;
var statearr_19365_19387 = state_19363__$1;
(statearr_19365_19387[(2)] = inst_19342);

(statearr_19365_19387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (1))){
var state_19363__$1 = state_19363;
var statearr_19366_19388 = state_19363__$1;
(statearr_19366_19388[(2)] = null);

(statearr_19366_19388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (4))){
var inst_19328 = (state_19363[(2)]);
var state_19363__$1 = state_19363;
var statearr_19367_19389 = state_19363__$1;
(statearr_19367_19389[(2)] = inst_19328);

(statearr_19367_19389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (6))){
var state_19363__$1 = state_19363;
var statearr_19368_19390 = state_19363__$1;
(statearr_19368_19390[(2)] = null);

(statearr_19368_19390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (3))){
var inst_19361 = (state_19363[(2)]);
var state_19363__$1 = state_19363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19363__$1,inst_19361);
} else {
if((state_val_19364 === (2))){
var inst_19334 = (state_19363[(7)]);
var _ = (function (){var statearr_19369 = state_19363;
(statearr_19369[(4)] = cljs.core.cons((5),(state_19363[(4)])));

return statearr_19369;
})();
var inst_19334__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_19363__$1 = (function (){var statearr_19370 = state_19363;
(statearr_19370[(7)] = inst_19334__$1);

return statearr_19370;
})();
if(cljs.core.truth_(inst_19334__$1)){
var statearr_19371_19391 = state_19363__$1;
(statearr_19371_19391[(1)] = (6));

} else {
var statearr_19372_19392 = state_19363__$1;
(statearr_19372_19392[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (11))){
var inst_19353 = (state_19363[(8)]);
var inst_19356 = (state_19363[(2)]);
var inst_19357 = fluree.db.util.async.throw_err(inst_19356);
var inst_19358 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19353,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_19357);
var _ = (function (){var statearr_19374 = state_19363;
(statearr_19374[(4)] = cljs.core.rest((state_19363[(4)])));

return statearr_19374;
})();
var state_19363__$1 = state_19363;
var statearr_19375_19393 = state_19363__$1;
(statearr_19375_19393[(2)] = inst_19358);

(statearr_19375_19393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (9))){
var inst_19348 = (state_19363[(9)]);
var inst_19346 = (state_19363[(2)]);
var inst_19347 = fluree.db.util.async.throw_err(inst_19346);
var inst_19348__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_19347);
var inst_19349 = fluree.db.query.schema.schema_map(inst_19348__$1);
var state_19363__$1 = (function (){var statearr_19376 = state_19363;
(statearr_19376[(9)] = inst_19348__$1);

return statearr_19376;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19363__$1,(10),inst_19349);
} else {
if((state_val_19364 === (5))){
var _ = (function (){var statearr_19377 = state_19363;
(statearr_19377[(4)] = cljs.core.rest((state_19363[(4)])));

return statearr_19377;
})();
var state_19363__$1 = state_19363;
var ex19373 = (state_19363__$1[(2)]);
var statearr_19378_19394 = state_19363__$1;
(statearr_19378_19394[(5)] = ex19373);


if((ex19373 instanceof Error)){
var statearr_19379_19395 = state_19363__$1;
(statearr_19379_19395[(1)] = (4));

(statearr_19379_19395[(5)] = null);

} else {
throw ex19373;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19364 === (10))){
var inst_19353 = (state_19363[(8)]);
var inst_19348 = (state_19363[(9)]);
var inst_19351 = (state_19363[(2)]);
var inst_19352 = fluree.db.util.async.throw_err(inst_19351);
var inst_19353__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19348,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_19352);
var inst_19354 = fluree.db.query.schema.setting_map(inst_19353__$1);
var state_19363__$1 = (function (){var statearr_19380 = state_19363;
(statearr_19380[(8)] = inst_19353__$1);

return statearr_19380;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19363__$1,(11),inst_19354);
} else {
if((state_val_19364 === (8))){
var inst_19334 = (state_19363[(7)]);
var inst_19344 = (state_19363[(2)]);
var state_19363__$1 = (function (){var statearr_19381 = state_19363;
(statearr_19381[(10)] = inst_19344);

return statearr_19381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19363__$1,(9),inst_19334);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0 = (function (){
var statearr_19382 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19382[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2684__auto__);

(statearr_19382[(1)] = (1));

return statearr_19382;
});
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1 = (function (state_19363){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19363);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19383){var ex__2687__auto__ = e19383;
var statearr_19384_19396 = state_19363;
(statearr_19384_19396[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19363[(4)]))){
var statearr_19385_19397 = state_19363;
(statearr_19385_19397[(1)] = cljs.core.first((state_19363[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19398 = state_19363;
state_19363 = G__19398;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = function(state_19363){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1.call(this,state_19363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19386 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19386[(6)] = c__2706__auto__);

return statearr_19386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__19400 = arguments.length;
switch (G__19400) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19453){
var state_val_19454 = (state_19453[(1)]);
if((state_val_19454 === (7))){
var inst_19410 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_19411 = (new Error(inst_19410));
var inst_19412 = (function(){throw inst_19411})();
var state_19453__$1 = state_19453;
var statearr_19455_19495 = state_19453__$1;
(statearr_19455_19495[(2)] = inst_19412);

(statearr_19455_19495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (20))){
var inst_19444 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
var statearr_19456_19496 = state_19453__$1;
(statearr_19456_19496[(2)] = inst_19444);

(statearr_19456_19496[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (1))){
var state_19453__$1 = state_19453;
var statearr_19457_19497 = state_19453__$1;
(statearr_19457_19497[(2)] = null);

(statearr_19457_19497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (4))){
var inst_19401 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
var statearr_19458_19498 = state_19453__$1;
(statearr_19458_19498[(2)] = inst_19401);

(statearr_19458_19498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (15))){
var inst_19419 = (state_19453[(7)]);
var state_19453__$1 = state_19453;
var statearr_19459_19499 = state_19453__$1;
(statearr_19459_19499[(2)] = inst_19419);

(statearr_19459_19499[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (21))){
var inst_19419 = (state_19453[(7)]);
var inst_19418 = (state_19453[(8)]);
var inst_19423 = (state_19453[(9)]);
var inst_19437 = (inst_19418 + (1));
var inst_19438 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19419,inst_19423);
var inst_19418__$1 = inst_19437;
var inst_19419__$1 = inst_19438;
var state_19453__$1 = (function (){var statearr_19460 = state_19453;
(statearr_19460[(7)] = inst_19419__$1);

(statearr_19460[(8)] = inst_19418__$1);

return statearr_19460;
})();
var statearr_19461_19500 = state_19453__$1;
(statearr_19461_19500[(2)] = null);

(statearr_19461_19500[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (13))){
var inst_19423 = (state_19453[(9)]);
var inst_19427 = (inst_19423 instanceof Error);
var state_19453__$1 = state_19453;
var statearr_19462_19501 = state_19453__$1;
(statearr_19462_19501[(2)] = inst_19427);

(statearr_19462_19501[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (22))){
var state_19453__$1 = state_19453;
var statearr_19463_19502 = state_19453__$1;
(statearr_19463_19502[(2)] = null);

(statearr_19463_19502[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (6))){
var state_19453__$1 = state_19453;
var statearr_19464_19503 = state_19453__$1;
(statearr_19464_19503[(2)] = null);

(statearr_19464_19503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (17))){
var inst_19446 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
var statearr_19465_19504 = state_19453__$1;
(statearr_19465_19504[(2)] = inst_19446);

(statearr_19465_19504[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (3))){
var inst_19451 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19453__$1,inst_19451);
} else {
if((state_val_19454 === (12))){
var inst_19424 = (state_19453[(10)]);
var state_19453__$1 = state_19453;
var statearr_19466_19505 = state_19453__$1;
(statearr_19466_19505[(2)] = inst_19424);

(statearr_19466_19505[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (2))){
var _ = (function (){var statearr_19467 = state_19453;
(statearr_19467[(4)] = cljs.core.cons((5),(state_19453[(4)])));

return statearr_19467;
})();
var inst_19407 = (end >= start);
var state_19453__$1 = state_19453;
if(cljs.core.truth_(inst_19407)){
var statearr_19468_19506 = state_19453__$1;
(statearr_19468_19506[(1)] = (6));

} else {
var statearr_19469_19507 = state_19453__$1;
(statearr_19469_19507[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (23))){
var inst_19442 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
var statearr_19470_19508 = state_19453__$1;
(statearr_19470_19508[(2)] = inst_19442);

(statearr_19470_19508[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (19))){
var state_19453__$1 = state_19453;
var statearr_19471_19509 = state_19453__$1;
(statearr_19471_19509[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (11))){
var inst_19424 = (state_19453[(10)]);
var inst_19423 = (state_19453[(9)]);
var inst_19423__$1 = (state_19453[(2)]);
var inst_19424__$1 = (inst_19423__$1 == null);
var state_19453__$1 = (function (){var statearr_19474 = state_19453;
(statearr_19474[(10)] = inst_19424__$1);

(statearr_19474[(9)] = inst_19423__$1);

return statearr_19474;
})();
if(cljs.core.truth_(inst_19424__$1)){
var statearr_19475_19510 = state_19453__$1;
(statearr_19475_19510[(1)] = (12));

} else {
var statearr_19476_19511 = state_19453__$1;
(statearr_19476_19511[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (9))){
var inst_19418 = (state_19453[(8)]);
var inst_19421 = fluree.db.storage.core.read_block(conn,network,dbid,inst_19418);
var state_19453__$1 = state_19453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19453__$1,(11),inst_19421);
} else {
if((state_val_19454 === (5))){
var _ = (function (){var statearr_19477 = state_19453;
(statearr_19477[(4)] = cljs.core.rest((state_19453[(4)])));

return statearr_19477;
})();
var state_19453__$1 = state_19453;
var ex19473 = (state_19453__$1[(2)]);
var statearr_19478_19512 = state_19453__$1;
(statearr_19478_19512[(5)] = ex19473);


if((ex19473 instanceof Error)){
var statearr_19479_19513 = state_19453__$1;
(statearr_19479_19513[(1)] = (4));

(statearr_19479_19513[(5)] = null);

} else {
throw ex19473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (14))){
var inst_19429 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
if(cljs.core.truth_(inst_19429)){
var statearr_19480_19514 = state_19453__$1;
(statearr_19480_19514[(1)] = (15));

} else {
var statearr_19481_19515 = state_19453__$1;
(statearr_19481_19515[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (16))){
var inst_19418 = (state_19453[(8)]);
var inst_19432 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19418,end);
var state_19453__$1 = state_19453;
if(inst_19432){
var statearr_19482_19516 = state_19453__$1;
(statearr_19482_19516[(1)] = (18));

} else {
var statearr_19483_19517 = state_19453__$1;
(statearr_19483_19517[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (10))){
var inst_19448 = (state_19453[(2)]);
var _ = (function (){var statearr_19484 = state_19453;
(statearr_19484[(4)] = cljs.core.rest((state_19453[(4)])));

return statearr_19484;
})();
var state_19453__$1 = state_19453;
var statearr_19485_19518 = state_19453__$1;
(statearr_19485_19518[(2)] = inst_19448);

(statearr_19485_19518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (18))){
var inst_19419 = (state_19453[(7)]);
var inst_19423 = (state_19453[(9)]);
var inst_19434 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19419,inst_19423);
var state_19453__$1 = state_19453;
var statearr_19486_19519 = state_19453__$1;
(statearr_19486_19519[(2)] = inst_19434);

(statearr_19486_19519[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (8))){
var inst_19414 = (state_19453[(2)]);
var inst_19415 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19416 = start;
var inst_19417 = cljs.core.PersistentVector.EMPTY;
var inst_19418 = inst_19416;
var inst_19419 = inst_19417;
var state_19453__$1 = (function (){var statearr_19487 = state_19453;
(statearr_19487[(7)] = inst_19419);

(statearr_19487[(8)] = inst_19418);

(statearr_19487[(11)] = inst_19415);

(statearr_19487[(12)] = inst_19414);

return statearr_19487;
})();
var statearr_19488_19520 = state_19453__$1;
(statearr_19488_19520[(2)] = null);

(statearr_19488_19520[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_19489 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19489[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_19489[(1)] = (1));

return statearr_19489;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_19453){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19453);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19490){var ex__2687__auto__ = e19490;
var statearr_19491_19521 = state_19453;
(statearr_19491_19521[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19453[(4)]))){
var statearr_19492_19522 = state_19453;
(statearr_19492_19522[(1)] = cljs.core.first((state_19453[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19523 = state_19453;
state_19453 = G__19523;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_19453){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_19453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19493 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19493[(6)] = c__2706__auto__);

return statearr_19493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19539){
var state_val_19540 = (state_19539[(1)]);
if((state_val_19540 === (1))){
var state_19539__$1 = state_19539;
var statearr_19541_19555 = state_19539__$1;
(statearr_19541_19555[(2)] = null);

(statearr_19541_19555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (2))){
var _ = (function (){var statearr_19542 = state_19539;
(statearr_19542[(4)] = cljs.core.cons((5),(state_19539[(4)])));

return statearr_19542;
})();
var inst_19530 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_19539__$1 = state_19539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19539__$1,(6),inst_19530);
} else {
if((state_val_19540 === (3))){
var inst_19537 = (state_19539[(2)]);
var state_19539__$1 = state_19539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19539__$1,inst_19537);
} else {
if((state_val_19540 === (4))){
var inst_19524 = (state_19539[(2)]);
var state_19539__$1 = state_19539;
var statearr_19544_19556 = state_19539__$1;
(statearr_19544_19556[(2)] = inst_19524);

(statearr_19544_19556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (5))){
var _ = (function (){var statearr_19545 = state_19539;
(statearr_19545[(4)] = cljs.core.rest((state_19539[(4)])));

return statearr_19545;
})();
var state_19539__$1 = state_19539;
var ex19543 = (state_19539__$1[(2)]);
var statearr_19546_19557 = state_19539__$1;
(statearr_19546_19557[(5)] = ex19543);


if((ex19543 instanceof Error)){
var statearr_19547_19558 = state_19539__$1;
(statearr_19547_19558[(1)] = (4));

(statearr_19547_19558[(5)] = null);

} else {
throw ex19543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (6))){
var inst_19532 = (state_19539[(2)]);
var inst_19533 = fluree.db.util.async.throw_err(inst_19532);
var inst_19534 = cljs.core.first(inst_19533);
var _ = (function (){var statearr_19548 = state_19539;
(statearr_19548[(4)] = cljs.core.rest((state_19539[(4)])));

return statearr_19548;
})();
var state_19539__$1 = state_19539;
var statearr_19549_19559 = state_19539__$1;
(statearr_19549_19559[(2)] = inst_19534);

(statearr_19549_19559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2684__auto____0 = (function (){
var statearr_19550 = [null,null,null,null,null,null,null];
(statearr_19550[(0)] = fluree$db$storage$core$block_$_state_machine__2684__auto__);

(statearr_19550[(1)] = (1));

return statearr_19550;
});
var fluree$db$storage$core$block_$_state_machine__2684__auto____1 = (function (state_19539){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19539);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19551){var ex__2687__auto__ = e19551;
var statearr_19552_19560 = state_19539;
(statearr_19552_19560[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19539[(4)]))){
var statearr_19553_19561 = state_19539;
(statearr_19553_19561[(1)] = cljs.core.first((state_19539[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19562 = state_19539;
state_19539 = G__19562;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2684__auto__ = function(state_19539){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2684__auto____1.call(this,state_19539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2684__auto____0;
fluree$db$storage$core$block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19554 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19554[(6)] = c__2706__auto__);

return statearr_19554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
