// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
goog.require('goog.object');
goog.scope(function(){
fluree.db.util.json.goog$module$goog$object = goog.module.get('goog.object');
});
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__14396 = arguments.length;
switch (G__14396) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__14397 = options;
var map__14397__$1 = cljs.core.__destructure_map(map__14397);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14397__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__14436_14469 = cljs.core.seq(x__$1);
var chunk__14437_14470 = null;
var count__14438_14471 = (0);
var i__14439_14472 = (0);
while(true){
if((i__14439_14472 < count__14438_14471)){
var vec__14452_14473 = chunk__14437_14470.cljs$core$IIndexed$_nth$arity$2(null,i__14439_14472);
var k_14474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14452_14473,(0),null);
var v_14475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14452_14473,(1),null);
var G__14455_14476 = m;
var G__14456_14477 = keyfn(k_14474);
var G__14457_14478 = fluree$db$util$json$thisfn(v_14475);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__14455_14476,G__14456_14477,G__14457_14478);


var G__14479 = seq__14436_14469;
var G__14480 = chunk__14437_14470;
var G__14481 = count__14438_14471;
var G__14482 = (i__14439_14472 + (1));
seq__14436_14469 = G__14479;
chunk__14437_14470 = G__14480;
count__14438_14471 = G__14481;
i__14439_14472 = G__14482;
continue;
} else {
var temp__5804__auto___14483 = cljs.core.seq(seq__14436_14469);
if(temp__5804__auto___14483){
var seq__14436_14484__$1 = temp__5804__auto___14483;
if(cljs.core.chunked_seq_QMARK_(seq__14436_14484__$1)){
var c__5568__auto___14485 = cljs.core.chunk_first(seq__14436_14484__$1);
var G__14486 = cljs.core.chunk_rest(seq__14436_14484__$1);
var G__14487 = c__5568__auto___14485;
var G__14488 = cljs.core.count(c__5568__auto___14485);
var G__14489 = (0);
seq__14436_14469 = G__14486;
chunk__14437_14470 = G__14487;
count__14438_14471 = G__14488;
i__14439_14472 = G__14489;
continue;
} else {
var vec__14458_14490 = cljs.core.first(seq__14436_14484__$1);
var k_14491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14458_14490,(0),null);
var v_14492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14458_14490,(1),null);
var G__14461_14493 = m;
var G__14462_14494 = keyfn(k_14491);
var G__14463_14495 = fluree$db$util$json$thisfn(v_14492);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__14461_14493,G__14462_14494,G__14463_14495);


var G__14496 = cljs.core.next(seq__14436_14484__$1);
var G__14497 = null;
var G__14498 = (0);
var G__14499 = (0);
seq__14436_14469 = G__14496;
chunk__14437_14470 = G__14497;
count__14438_14471 = G__14498;
i__14439_14472 = G__14499;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__14464_14500 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__14465_14501 = null;
var count__14466_14502 = (0);
var i__14467_14503 = (0);
while(true){
if((i__14467_14503 < count__14466_14502)){
var x_14504__$2 = chunk__14465_14501.cljs$core$IIndexed$_nth$arity$2(null,i__14467_14503);
arr.push(x_14504__$2);


var G__14505 = seq__14464_14500;
var G__14506 = chunk__14465_14501;
var G__14507 = count__14466_14502;
var G__14508 = (i__14467_14503 + (1));
seq__14464_14500 = G__14505;
chunk__14465_14501 = G__14506;
count__14466_14502 = G__14507;
i__14467_14503 = G__14508;
continue;
} else {
var temp__5804__auto___14509 = cljs.core.seq(seq__14464_14500);
if(temp__5804__auto___14509){
var seq__14464_14510__$1 = temp__5804__auto___14509;
if(cljs.core.chunked_seq_QMARK_(seq__14464_14510__$1)){
var c__5568__auto___14511 = cljs.core.chunk_first(seq__14464_14510__$1);
var G__14512 = cljs.core.chunk_rest(seq__14464_14510__$1);
var G__14513 = c__5568__auto___14511;
var G__14514 = cljs.core.count(c__5568__auto___14511);
var G__14515 = (0);
seq__14464_14500 = G__14512;
chunk__14465_14501 = G__14513;
count__14466_14502 = G__14514;
i__14467_14503 = G__14515;
continue;
} else {
var x_14516__$2 = cljs.core.first(seq__14464_14510__$1);
arr.push(x_14516__$2);


var G__14517 = cljs.core.next(seq__14464_14510__$1);
var G__14518 = null;
var G__14519 = (0);
var G__14520 = (0);
seq__14464_14500 = G__14517;
chunk__14465_14501 = G__14518;
count__14466_14502 = G__14519;
i__14467_14503 = G__14520;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14521_SHARP_){
var G__14522 = (depth - (1));
var G__14523 = p1__14521_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__14522,G__14523) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__14522,G__14523));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__14524 = cljs.core.get_global_hierarchy;
return (fexpr__14524.cljs$core$IFn$_invoke$arity$0 ? fexpr__14524.cljs$core$IFn$_invoke$arity$0() : fexpr__14524.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__5043__auto__ = (function (){var or__5045__auto__ = (function (){var G__14525 = new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__14525) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__14525));
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return ((cljs.core.map_QMARK_(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__5043__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__14526_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__14526_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
