// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72902 = arguments.length;
var i__4865__auto___72903 = (0);
while(true){
if((i__4865__auto___72903 < len__4864__auto___72902)){
args__4870__auto__.push((arguments[i__4865__auto___72903]));

var G__72904 = (i__4865__auto___72903 + (1));
i__4865__auto___72903 = G__72904;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__72831){
var vec__72832 = p__72831;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72832,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___72905 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72879){
var state_val_72880 = (state_72879[(1)]);
if((state_val_72880 === (7))){
var inst_72856 = (state_72879[(7)]);
var inst_72865 = (state_72879[(8)]);
var inst_72867 = fluree.db.time_travel.as_of_block(inst_72865,inst_72856);
var state_72879__$1 = state_72879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72879__$1,(10),inst_72867);
} else {
if((state_val_72880 === (1))){
var state_72879__$1 = state_72879;
var statearr_72881_72906 = state_72879__$1;
(statearr_72881_72906[(2)] = null);

(statearr_72881_72906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72880 === (4))){
var inst_72835 = (state_72879[(2)]);
var inst_72836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72837 = [inst_72835];
var inst_72838 = (new cljs.core.PersistentVector(null,1,(5),inst_72836,inst_72837,null));
var inst_72839 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72838);
var inst_72840 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72835);
var inst_72841 = cljs.core.async.close_BANG_(pc);
var state_72879__$1 = (function (){var statearr_72882 = state_72879;
(statearr_72882[(9)] = inst_72840);

(statearr_72882[(10)] = inst_72839);

return statearr_72882;
})();
var statearr_72883_72907 = state_72879__$1;
(statearr_72883_72907[(2)] = inst_72841);

(statearr_72883_72907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72880 === (6))){
var inst_72856 = (state_72879[(7)]);
var inst_72860 = (state_72879[(11)]);
var inst_72859 = (state_72879[(12)]);
var inst_72863 = (state_72879[(2)]);
var inst_72864 = fluree.db.util.async.throw_err(inst_72863);
var inst_72865 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_72864,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_72859,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_72860], 0));
var state_72879__$1 = (function (){var statearr_72884 = state_72879;
(statearr_72884[(8)] = inst_72865);

return statearr_72884;
})();
if(cljs.core.truth_(inst_72856)){
var statearr_72885_72908 = state_72879__$1;
(statearr_72885_72908[(1)] = (7));

} else {
var statearr_72886_72909 = state_72879__$1;
(statearr_72886_72909[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72880 === (3))){
var inst_72877 = (state_72879[(2)]);
var state_72879__$1 = state_72879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72879__$1,inst_72877);
} else {
if((state_val_72880 === (2))){
var _ = (function (){var statearr_72888 = state_72879;
(statearr_72888[(4)] = cljs.core.cons((5),(state_72879[(4)])));

return statearr_72888;
})();
var inst_72851 = opts;
var inst_72852 = cljs.core.__destructure_map(inst_72851);
var inst_72853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72852,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_72854 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72852,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_72855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72852,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72852,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72857 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_72858 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_72859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72858,(0),null);
var inst_72860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72858,(1),null);
var inst_72861 = fluree.db.session.db(conn,ledger,opts);
var state_72879__$1 = (function (){var statearr_72889 = state_72879;
(statearr_72889[(13)] = inst_72855);

(statearr_72889[(14)] = inst_72857);

(statearr_72889[(7)] = inst_72856);

(statearr_72889[(15)] = inst_72853);

(statearr_72889[(16)] = inst_72854);

(statearr_72889[(11)] = inst_72860);

(statearr_72889[(12)] = inst_72859);

return statearr_72889;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72879__$1,(6),inst_72861);
} else {
if((state_val_72880 === (9))){
var inst_72873 = (state_72879[(2)]);
var inst_72874 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72873);
var _ = (function (){var statearr_72890 = state_72879;
(statearr_72890[(4)] = cljs.core.rest((state_72879[(4)])));

return statearr_72890;
})();
var state_72879__$1 = state_72879;
var statearr_72891_72910 = state_72879__$1;
(statearr_72891_72910[(2)] = inst_72874);

(statearr_72891_72910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72880 === (5))){
var _ = (function (){var statearr_72892 = state_72879;
(statearr_72892[(4)] = cljs.core.rest((state_72879[(4)])));

return statearr_72892;
})();
var state_72879__$1 = state_72879;
var ex72887 = (state_72879__$1[(2)]);
var statearr_72893_72911 = state_72879__$1;
(statearr_72893_72911[(5)] = ex72887);


var statearr_72894_72912 = state_72879__$1;
(statearr_72894_72912[(1)] = (4));

(statearr_72894_72912[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72880 === (10))){
var inst_72869 = (state_72879[(2)]);
var inst_72870 = fluree.db.util.async.throw_err(inst_72869);
var state_72879__$1 = state_72879;
var statearr_72895_72913 = state_72879__$1;
(statearr_72895_72913[(2)] = inst_72870);

(statearr_72895_72913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72880 === (8))){
var inst_72865 = (state_72879[(8)]);
var state_72879__$1 = state_72879;
var statearr_72896_72914 = state_72879__$1;
(statearr_72896_72914[(2)] = inst_72865);

(statearr_72896_72914[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_72897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72897[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_72897[(1)] = (1));

return statearr_72897;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_72879){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72879);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72898){var ex__2730__auto__ = e72898;
var statearr_72899_72915 = state_72879;
(statearr_72899_72915[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72879[(4)]))){
var statearr_72900_72916 = state_72879;
(statearr_72900_72916[(1)] = cljs.core.first((state_72879[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72917 = state_72879;
state_72879 = G__72917;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_72879){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_72879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72901 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72901[(6)] = c__2749__auto___72905);

return statearr_72901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq72828){
var G__72829 = cljs.core.first(seq72828);
var seq72828__$1 = cljs.core.next(seq72828);
var G__72830 = cljs.core.first(seq72828__$1);
var seq72828__$2 = cljs.core.next(seq72828__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72829,G__72830,seq72828__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__72919 = arguments.length;
switch (G__72919) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73048){
var state_val_73049 = (state_73048[(1)]);
if((state_val_73049 === (7))){
var inst_72948 = (state_73048[(7)]);
var inst_72938 = (state_73048[(8)]);
var inst_72950 = fluree.db.time_travel.as_of_block(inst_72948,inst_72938);
var state_73048__$1 = state_73048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73048__$1,(10),inst_72950);
} else {
if((state_val_73049 === (20))){
var inst_72942 = (state_73048[(9)]);
var state_73048__$1 = state_73048;
var statearr_73050_73130 = state_73048__$1;
(statearr_73050_73130[(2)] = inst_72942);

(statearr_73050_73130[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (27))){
var inst_72936 = (state_73048[(10)]);
var state_73048__$1 = state_73048;
var statearr_73051_73131 = state_73048__$1;
(statearr_73051_73131[(2)] = inst_72936);

(statearr_73051_73131[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (1))){
var state_73048__$1 = state_73048;
var statearr_73052_73132 = state_73048__$1;
(statearr_73052_73132[(2)] = null);

(statearr_73052_73132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (24))){
var inst_72945 = (state_73048[(11)]);
var state_73048__$1 = state_73048;
if(cljs.core.truth_(inst_72945)){
var statearr_73053_73133 = state_73048__$1;
(statearr_73053_73133[(1)] = (26));

} else {
var statearr_73054_73134 = state_73048__$1;
(statearr_73054_73134[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (39))){
var inst_73010 = (state_73048[(12)]);
var inst_73013 = cljs.core.ex_data(inst_73010);
var inst_73014 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73015 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73013);
var inst_73016 = cljs.core.ex_message(inst_73010);
var inst_73017 = [inst_73015,inst_73016,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73018 = cljs.core.PersistentHashMap.fromArrays(inst_73014,inst_73017);
var state_73048__$1 = state_73048;
var statearr_73055_73135 = state_73048__$1;
(statearr_73055_73135[(2)] = inst_73018);

(statearr_73055_73135[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (46))){
var inst_73010 = (state_73048[(12)]);
var state_73048__$1 = state_73048;
var statearr_73056_73136 = state_73048__$1;
(statearr_73056_73136[(2)] = inst_73010);

(statearr_73056_73136[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (4))){
var inst_72920 = (state_73048[(2)]);
var inst_72921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72922 = [inst_72920];
var inst_72923 = (new cljs.core.PersistentVector(null,1,(5),inst_72921,inst_72922,null));
var inst_72924 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72923);
var inst_72925 = cljs.core.ex_data(inst_72920);
var inst_72926 = cljs.core.ex_message(inst_72920);
var inst_72927 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_72925,new cljs.core.Keyword(null,"message","message",-406056002),inst_72926);
var state_73048__$1 = (function (){var statearr_73057 = state_73048;
(statearr_73057[(13)] = inst_72924);

return statearr_73057;
})();
var statearr_73058_73137 = state_73048__$1;
(statearr_73058_73137[(2)] = inst_72927);

(statearr_73058_73137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (15))){
var state_73048__$1 = state_73048;
var statearr_73059_73138 = state_73048__$1;
(statearr_73059_73138[(2)] = (1000000));

(statearr_73059_73138[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (48))){
var inst_73010 = (state_73048[(12)]);
var state_73048__$1 = state_73048;
var statearr_73060_73139 = state_73048__$1;
(statearr_73060_73139[(2)] = inst_73010);

(statearr_73060_73139[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (50))){
var inst_73037 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
var statearr_73061_73140 = state_73048__$1;
(statearr_73061_73140[(2)] = inst_73037);

(statearr_73061_73140[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (21))){
var inst_72941 = (state_73048[(14)]);
var state_73048__$1 = state_73048;
if(cljs.core.truth_(inst_72941)){
var statearr_73062_73141 = state_73048__$1;
(statearr_73062_73141[(1)] = (23));

} else {
var statearr_73063_73142 = state_73048__$1;
(statearr_73063_73142[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (31))){
var inst_72999 = (state_73048[(2)]);
var inst_73000 = cljs.core.not(inst_72999);
var state_73048__$1 = state_73048;
if(inst_73000){
var statearr_73064_73143 = state_73048__$1;
(statearr_73064_73143[(1)] = (35));

} else {
var statearr_73065_73144 = state_73048__$1;
(statearr_73065_73144[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (32))){
var inst_72943 = (state_73048[(15)]);
var state_73048__$1 = state_73048;
var statearr_73066_73145 = state_73048__$1;
(statearr_73066_73145[(2)] = inst_72943);

(statearr_73066_73145[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (40))){
var inst_72973 = (state_73048[(16)]);
var state_73048__$1 = state_73048;
if(cljs.core.truth_(inst_72973)){
var statearr_73067_73146 = state_73048__$1;
(statearr_73067_73146[(1)] = (42));

} else {
var statearr_73068_73147 = state_73048__$1;
(statearr_73068_73147[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (33))){
var inst_72939 = (state_73048[(17)]);
var state_73048__$1 = state_73048;
var statearr_73069_73148 = state_73048__$1;
(statearr_73069_73148[(2)] = inst_72939);

(statearr_73069_73148[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (13))){
var inst_72968 = (state_73048[(18)]);
var inst_72944 = (state_73048[(19)]);
var inst_72966 = (state_73048[(2)]);
var inst_72967 = cljs.core.volatile_BANG_((0));
var inst_72968__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72944);
var state_73048__$1 = (function (){var statearr_73070 = state_73048;
(statearr_73070[(18)] = inst_72968__$1);

(statearr_73070[(20)] = inst_72966);

(statearr_73070[(21)] = inst_72967);

return statearr_73070;
})();
if(cljs.core.truth_(inst_72968__$1)){
var statearr_73071_73149 = state_73048__$1;
(statearr_73071_73149[(1)] = (14));

} else {
var statearr_73072_73150 = state_73048__$1;
(statearr_73072_73150[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (22))){
var inst_72989 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
var statearr_73073_73151 = state_73048__$1;
(statearr_73073_73151[(2)] = inst_72989);

(statearr_73073_73151[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (36))){
var inst_72956 = (state_73048[(22)]);
var inst_72975 = (state_73048[(23)]);
var inst_73006 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_72975);
var inst_73007 = fluree.db.query.fql.query(inst_72956,inst_73006);
var state_73048__$1 = state_73048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73048__$1,(38),inst_73007);
} else {
if((state_val_73049 === (41))){
var inst_73041 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
var statearr_73074_73152 = state_73048__$1;
(statearr_73074_73152[(2)] = inst_73041);

(statearr_73074_73152[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (43))){
var state_73048__$1 = state_73048;
var statearr_73075_73153 = state_73048__$1;
(statearr_73075_73153[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (29))){
var inst_72943 = (state_73048[(15)]);
var state_73048__$1 = state_73048;
if(cljs.core.truth_(inst_72943)){
var statearr_73077_73154 = state_73048__$1;
(statearr_73077_73154[(1)] = (32));

} else {
var statearr_73078_73155 = state_73048__$1;
(statearr_73078_73155[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (44))){
var inst_73039 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
var statearr_73079_73156 = state_73048__$1;
(statearr_73079_73156[(2)] = inst_73039);

(statearr_73079_73156[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (6))){
var inst_72938 = (state_73048[(8)]);
var inst_72947 = (state_73048[(2)]);
var inst_72948 = fluree.db.util.async.throw_err(inst_72947);
var state_73048__$1 = (function (){var statearr_73080 = state_73048;
(statearr_73080[(7)] = inst_72948);

return statearr_73080;
})();
if(cljs.core.truth_(inst_72938)){
var statearr_73081_73157 = state_73048__$1;
(statearr_73081_73157[(1)] = (7));

} else {
var statearr_73082_73158 = state_73048__$1;
(statearr_73082_73158[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (28))){
var inst_72985 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
var statearr_73083_73159 = state_73048__$1;
(statearr_73083_73159[(2)] = inst_72985);

(statearr_73083_73159[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (25))){
var inst_72987 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
var statearr_73084_73160 = state_73048__$1;
(statearr_73084_73160[(2)] = inst_72987);

(statearr_73084_73160[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (34))){
var inst_72996 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
var statearr_73085_73161 = state_73048__$1;
(statearr_73085_73161[(2)] = inst_72996);

(statearr_73085_73161[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (17))){
var inst_72937 = (state_73048[(24)]);
var state_73048__$1 = state_73048;
var statearr_73086_73162 = state_73048__$1;
(statearr_73086_73162[(2)] = inst_72937);

(statearr_73086_73162[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (3))){
var inst_73046 = (state_73048[(2)]);
var state_73048__$1 = state_73048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73048__$1,inst_73046);
} else {
if((state_val_73049 === (12))){
var inst_72964 = cljs.core.PersistentHashMap.EMPTY;
var state_73048__$1 = state_73048;
var statearr_73087_73163 = state_73048__$1;
(statearr_73087_73163[(2)] = inst_72964);

(statearr_73087_73163[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (2))){
var _ = (function (){var statearr_73088 = state_73048;
(statearr_73088[(4)] = cljs.core.cons((5),(state_73048[(4)])));

return statearr_73088;
})();
var inst_72934 = query_map;
var inst_72935 = cljs.core.__destructure_map(inst_72934);
var inst_72936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_72937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_72938 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72939 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_72940 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_72941 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_72942 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_72943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_72944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72935,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_73048__$1 = (function (){var statearr_73089 = state_73048;
(statearr_73089[(10)] = inst_72936);

(statearr_73089[(25)] = inst_72940);

(statearr_73089[(14)] = inst_72941);

(statearr_73089[(9)] = inst_72942);

(statearr_73089[(17)] = inst_72939);

(statearr_73089[(19)] = inst_72944);

(statearr_73089[(11)] = inst_72945);

(statearr_73089[(15)] = inst_72943);

(statearr_73089[(8)] = inst_72938);

(statearr_73089[(24)] = inst_72937);

return statearr_73089;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73048__$1,(6),sources);
} else {
if((state_val_73049 === (23))){
var inst_72941 = (state_73048[(14)]);
var state_73048__$1 = state_73048;
var statearr_73090_73164 = state_73048__$1;
(statearr_73090_73164[(2)] = inst_72941);

(statearr_73090_73164[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (47))){
var inst_72956 = (state_73048[(22)]);
var inst_73021 = (state_73048[(26)]);
var inst_72967 = (state_73048[(21)]);
var inst_72974 = (state_73048[(27)]);
var inst_73027 = (state_73048[(2)]);
var inst_73028 = cljs.core.deref(inst_72967);
var inst_73029 = fluree.db.util.core.response_time_formatted(inst_72974);
var inst_73030 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_72956);
var inst_73031 = [(200),inst_73027,inst_73028,inst_73029,inst_73030];
var inst_73032 = cljs.core.PersistentHashMap.fromArrays(inst_73021,inst_73031);
var state_73048__$1 = state_73048;
var statearr_73091_73165 = state_73048__$1;
(statearr_73091_73165[(2)] = inst_73032);

(statearr_73091_73165[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (35))){
var inst_73002 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73003 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73004 = cljs.core.PersistentHashMap.fromArrays(inst_73002,inst_73003);
var state_73048__$1 = state_73048;
var statearr_73092_73166 = state_73048__$1;
(statearr_73092_73166[(2)] = inst_73004);

(statearr_73092_73166[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (19))){
var inst_72991 = (state_73048[(28)]);
var inst_72991__$1 = (state_73048[(2)]);
var state_73048__$1 = (function (){var statearr_73093 = state_73048;
(statearr_73093[(28)] = inst_72991__$1);

return statearr_73093;
})();
if(cljs.core.truth_(inst_72991__$1)){
var statearr_73094_73167 = state_73048__$1;
(statearr_73094_73167[(1)] = (29));

} else {
var statearr_73095_73168 = state_73048__$1;
(statearr_73095_73168[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (11))){
var inst_72956 = (state_73048[(22)]);
var inst_72957 = (state_73048[(29)]);
var inst_72940 = (state_73048[(25)]);
var inst_72959 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_72956);
var inst_72960 = fluree.db.connection_js.open_api_QMARK_(inst_72957);
var inst_72961 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_72956);
var inst_72962 = fluree.db.api_js.get_sources(inst_72957,inst_72959,inst_72960,inst_72961,inst_72940,db_fn);
var state_73048__$1 = state_73048;
var statearr_73097_73169 = state_73048__$1;
(statearr_73097_73169[(2)] = inst_72962);

(statearr_73097_73169[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (9))){
var inst_72956 = (state_73048[(22)]);
var inst_72940 = (state_73048[(25)]);
var inst_72956__$1 = (state_73048[(2)]);
var inst_72957 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_72956__$1);
var state_73048__$1 = (function (){var statearr_73098 = state_73048;
(statearr_73098[(22)] = inst_72956__$1);

(statearr_73098[(29)] = inst_72957);

return statearr_73098;
})();
if(cljs.core.truth_(inst_72940)){
var statearr_73099_73170 = state_73048__$1;
(statearr_73099_73170[(1)] = (11));

} else {
var statearr_73100_73171 = state_73048__$1;
(statearr_73100_73171[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (5))){
var _ = (function (){var statearr_73101 = state_73048;
(statearr_73101[(4)] = cljs.core.rest((state_73048[(4)])));

return statearr_73101;
})();
var state_73048__$1 = state_73048;
var ex73096 = (state_73048__$1[(2)]);
var statearr_73102_73172 = state_73048__$1;
(statearr_73102_73172[(5)] = ex73096);


var statearr_73103_73173 = state_73048__$1;
(statearr_73103_73173[(1)] = (4));

(statearr_73103_73173[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (14))){
var inst_72968 = (state_73048[(18)]);
var state_73048__$1 = state_73048;
var statearr_73104_73174 = state_73048__$1;
(statearr_73104_73174[(2)] = inst_72968);

(statearr_73104_73174[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (45))){
var inst_73010 = (state_73048[(12)]);
var inst_73024 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_73010);
var state_73048__$1 = state_73048;
var statearr_73105_73175 = state_73048__$1;
(statearr_73105_73175[(2)] = inst_73024);

(statearr_73105_73175[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (26))){
var inst_72945 = (state_73048[(11)]);
var state_73048__$1 = state_73048;
var statearr_73106_73176 = state_73048__$1;
(statearr_73106_73176[(2)] = inst_72945);

(statearr_73106_73176[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (16))){
var inst_72944 = (state_73048[(19)]);
var inst_72966 = (state_73048[(20)]);
var inst_72967 = (state_73048[(21)]);
var inst_72937 = (state_73048[(24)]);
var inst_72972 = (state_73048[(2)]);
var inst_72973 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_72944);
var inst_72974 = fluree.db.util.core.current_time_millis();
var inst_72975 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_72944,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_72966,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_72972,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_72967], 0));
var state_73048__$1 = (function (){var statearr_73107 = state_73048;
(statearr_73107[(16)] = inst_72973);

(statearr_73107[(27)] = inst_72974);

(statearr_73107[(23)] = inst_72975);

return statearr_73107;
})();
if(cljs.core.truth_(inst_72937)){
var statearr_73108_73177 = state_73048__$1;
(statearr_73108_73177[(1)] = (17));

} else {
var statearr_73109_73178 = state_73048__$1;
(statearr_73109_73178[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (38))){
var inst_73010 = (state_73048[(12)]);
var inst_73009 = (state_73048[(2)]);
var inst_73010__$1 = fluree.db.util.async.throw_err(inst_73009);
var inst_73011 = (inst_73010__$1 instanceof cljs.core.ExceptionInfo);
var state_73048__$1 = (function (){var statearr_73110 = state_73048;
(statearr_73110[(12)] = inst_73010__$1);

return statearr_73110;
})();
if(cljs.core.truth_(inst_73011)){
var statearr_73111_73179 = state_73048__$1;
(statearr_73111_73179[(1)] = (39));

} else {
var statearr_73112_73180 = state_73048__$1;
(statearr_73112_73180[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (30))){
var inst_72991 = (state_73048[(28)]);
var state_73048__$1 = state_73048;
var statearr_73113_73181 = state_73048__$1;
(statearr_73113_73181[(2)] = inst_72991);

(statearr_73113_73181[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (10))){
var inst_72952 = (state_73048[(2)]);
var inst_72953 = fluree.db.util.async.throw_err(inst_72952);
var state_73048__$1 = state_73048;
var statearr_73114_73182 = state_73048__$1;
(statearr_73114_73182[(2)] = inst_72953);

(statearr_73114_73182[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (18))){
var inst_72942 = (state_73048[(9)]);
var state_73048__$1 = state_73048;
if(cljs.core.truth_(inst_72942)){
var statearr_73115_73183 = state_73048__$1;
(statearr_73115_73183[(1)] = (20));

} else {
var statearr_73116_73184 = state_73048__$1;
(statearr_73116_73184[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (42))){
var inst_73010 = (state_73048[(12)]);
var inst_73021 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73022 = cljs.core.sequential_QMARK_(inst_73010);
var state_73048__$1 = (function (){var statearr_73117 = state_73048;
(statearr_73117[(26)] = inst_73021);

return statearr_73117;
})();
if(inst_73022){
var statearr_73118_73185 = state_73048__$1;
(statearr_73118_73185[(1)] = (45));

} else {
var statearr_73119_73186 = state_73048__$1;
(statearr_73119_73186[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (37))){
var inst_73043 = (state_73048[(2)]);
var _ = (function (){var statearr_73120 = state_73048;
(statearr_73120[(4)] = cljs.core.rest((state_73048[(4)])));

return statearr_73120;
})();
var state_73048__$1 = state_73048;
var statearr_73121_73187 = state_73048__$1;
(statearr_73121_73187[(2)] = inst_73043);

(statearr_73121_73187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (8))){
var inst_72948 = (state_73048[(7)]);
var state_73048__$1 = state_73048;
var statearr_73122_73188 = state_73048__$1;
(statearr_73122_73188[(2)] = inst_72948);

(statearr_73122_73188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73049 === (49))){
var state_73048__$1 = state_73048;
var statearr_73123_73189 = state_73048__$1;
(statearr_73123_73189[(2)] = null);

(statearr_73123_73189[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73124[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73124[(1)] = (1));

return statearr_73124;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73048){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73048);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73125){var ex__2730__auto__ = e73125;
var statearr_73126_73190 = state_73048;
(statearr_73126_73190[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73048[(4)]))){
var statearr_73127_73191 = state_73048;
(statearr_73127_73191[(1)] = cljs.core.first((state_73048[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73192 = state_73048;
state_73048 = G__73192;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73048){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73128 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73128[(6)] = c__2749__auto__);

return statearr_73128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__73193_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__73193_SHARP_);
}));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73215){
var state_val_73216 = (state_73215[(1)]);
if((state_val_73216 === (1))){
var inst_73197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73198 = [resp_chan,timeout_chan];
var inst_73199 = (new cljs.core.PersistentVector(null,2,(5),inst_73197,inst_73198,null));
var state_73215__$1 = state_73215;
return cljs.core.async.ioc_alts_BANG_(state_73215__$1,(2),inst_73199);
} else {
if((state_val_73216 === (2))){
var inst_73201 = (state_73215[(2)]);
var inst_73202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73201,(0),null);
var inst_73203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73201,(1),null);
var inst_73204 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_73203);
var state_73215__$1 = (function (){var statearr_73217 = state_73215;
(statearr_73217[(7)] = inst_73202);

return statearr_73217;
})();
if(inst_73204){
var statearr_73218_73228 = state_73215__$1;
(statearr_73218_73228[(1)] = (3));

} else {
var statearr_73219_73229 = state_73215__$1;
(statearr_73219_73229[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73216 === (3))){
var inst_73206 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_73207 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_73208 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_73209 = [tid,(408),inst_73208];
var inst_73210 = cljs.core.PersistentHashMap.fromArrays(inst_73207,inst_73209);
var state_73215__$1 = (function (){var statearr_73220 = state_73215;
(statearr_73220[(8)] = inst_73206);

return statearr_73220;
})();
var statearr_73221_73230 = state_73215__$1;
(statearr_73221_73230[(2)] = inst_73210);

(statearr_73221_73230[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73216 === (4))){
var inst_73202 = (state_73215[(7)]);
var state_73215__$1 = state_73215;
var statearr_73222_73231 = state_73215__$1;
(statearr_73222_73231[(2)] = inst_73202);

(statearr_73222_73231[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73216 === (5))){
var inst_73213 = (state_73215[(2)]);
var state_73215__$1 = state_73215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73215__$1,inst_73213);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_73223 = [null,null,null,null,null,null,null,null,null];
(statearr_73223[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__);

(statearr_73223[(1)] = (1));

return statearr_73223;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1 = (function (state_73215){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73215);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73224){var ex__2730__auto__ = e73224;
var statearr_73225_73232 = state_73215;
(statearr_73225_73232[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73215[(4)]))){
var statearr_73226_73233 = state_73215;
(statearr_73226_73233[(1)] = cljs.core.first((state_73215[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73234 = state_73215;
state_73215 = G__73234;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = function(state_73215){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1.call(this,state_73215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73227 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73227[(6)] = c__2749__auto__);

return statearr_73227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__73236 = arguments.length;
switch (G__73236) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__73237 = opts;
var map__73237__$1 = cljs.core.__destructure_map(map__73237);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73237__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73237__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73237__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73237__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__73238 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73238,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73238,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e73241){var e = e73241;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__73244 = arguments.length;
switch (G__73244) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73313){
var state_val_73314 = (state_73313[(1)]);
if((state_val_73314 === (7))){
var inst_73268 = (state_73313[(7)]);
var inst_73266 = (state_73313[(8)]);
var inst_73269 = (state_73313[(9)]);
var inst_73264 = (state_73313[(10)]);
var inst_73267 = (state_73313[(11)]);
var inst_73282 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_73283 = [ledger,txn,inst_73264,inst_73266,inst_73267,inst_73268,inst_73269];
var inst_73284 = cljs.core.PersistentHashMap.fromArrays(inst_73282,inst_73283);
var inst_73285 = fluree.db.util.core.without_nils(inst_73284);
var inst_73286 = fluree.db.operations.transact_async(conn,inst_73285);
var state_73313__$1 = state_73313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73313__$1,(13),inst_73286);
} else {
if((state_val_73314 === (20))){
var inst_73304 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
var statearr_73315_73351 = state_73313__$1;
(statearr_73315_73351[(2)] = inst_73304);

(statearr_73315_73351[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (1))){
var state_73313__$1 = state_73313;
var statearr_73316_73352 = state_73313__$1;
(statearr_73316_73352[(2)] = null);

(statearr_73316_73352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (4))){
var inst_73245 = (state_73313[(2)]);
var inst_73246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73247 = [inst_73245];
var inst_73248 = (new cljs.core.PersistentVector(null,1,(5),inst_73246,inst_73247,null));
var inst_73249 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73248);
var inst_73250 = cljs.core.ex_data(inst_73245);
var inst_73251 = cljs.core.ex_message(inst_73245);
var inst_73252 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73250,new cljs.core.Keyword(null,"message","message",-406056002),inst_73251);
var state_73313__$1 = (function (){var statearr_73317 = state_73313;
(statearr_73317[(12)] = inst_73249);

return statearr_73317;
})();
var statearr_73318_73353 = state_73313__$1;
(statearr_73318_73353[(2)] = inst_73252);

(statearr_73318_73353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (15))){
var inst_73288 = (state_73313[(13)]);
var inst_73263 = (state_73313[(14)]);
var inst_73291 = fluree.db.api_js.monitor_tx(conn,ledger,inst_73288,inst_73263);
var state_73313__$1 = state_73313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73313__$1,(17),inst_73291);
} else {
if((state_val_73314 === (13))){
var inst_73262 = (state_73313[(15)]);
var inst_73288 = (state_73313[(2)]);
var state_73313__$1 = (function (){var statearr_73319 = state_73313;
(statearr_73319[(13)] = inst_73288);

return statearr_73319;
})();
if(cljs.core.truth_(inst_73262)){
var statearr_73320_73354 = state_73313__$1;
(statearr_73320_73354[(1)] = (14));

} else {
var statearr_73321_73355 = state_73313__$1;
(statearr_73321_73355[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (6))){
var inst_73261 = (state_73313[(16)]);
var inst_73262 = (state_73313[(15)]);
var inst_73271 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_73261,opts);
var inst_73272 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_73271);
var inst_73273 = fluree.db.operations.command_async(conn,inst_73271);
var state_73313__$1 = (function (){var statearr_73322 = state_73313;
(statearr_73322[(17)] = inst_73273);

(statearr_73322[(18)] = inst_73272);

return statearr_73322;
})();
if(cljs.core.truth_(inst_73262)){
var statearr_73323_73356 = state_73313__$1;
(statearr_73323_73356[(1)] = (9));

} else {
var statearr_73324_73357 = state_73313__$1;
(statearr_73324_73357[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (17))){
var inst_73293 = (state_73313[(19)]);
var inst_73293__$1 = (state_73313[(2)]);
var inst_73294 = (inst_73293__$1 instanceof cljs.core.ExceptionInfo);
var state_73313__$1 = (function (){var statearr_73325 = state_73313;
(statearr_73325[(19)] = inst_73293__$1);

return statearr_73325;
})();
if(cljs.core.truth_(inst_73294)){
var statearr_73326_73358 = state_73313__$1;
(statearr_73326_73358[(1)] = (18));

} else {
var statearr_73327_73359 = state_73313__$1;
(statearr_73327_73359[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (3))){
var inst_73311 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73313__$1,inst_73311);
} else {
if((state_val_73314 === (12))){
var inst_73278 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
var statearr_73328_73360 = state_73313__$1;
(statearr_73328_73360[(2)] = inst_73278);

(statearr_73328_73360[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (2))){
var inst_73261 = (state_73313[(16)]);
var _ = (function (){var statearr_73329 = state_73313;
(statearr_73329[(4)] = cljs.core.cons((5),(state_73313[(4)])));

return statearr_73329;
})();
var inst_73259 = opts;
var inst_73260 = cljs.core.__destructure_map(inst_73259);
var inst_73261__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73260,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_73262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73260,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_73263 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73260,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_73264 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73260,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73265 = fluree.db.util.core.current_time_millis();
var inst_73266 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73260,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_73265);
var inst_73267 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73260,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_73268 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73260,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_73269 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73260,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_73313__$1 = (function (){var statearr_73330 = state_73313;
(statearr_73330[(7)] = inst_73268);

(statearr_73330[(8)] = inst_73266);

(statearr_73330[(16)] = inst_73261__$1);

(statearr_73330[(9)] = inst_73269);

(statearr_73330[(10)] = inst_73264);

(statearr_73330[(15)] = inst_73262);

(statearr_73330[(11)] = inst_73267);

(statearr_73330[(14)] = inst_73263);

return statearr_73330;
})();
if(cljs.core.truth_(inst_73261__$1)){
var statearr_73331_73361 = state_73313__$1;
(statearr_73331_73361[(1)] = (6));

} else {
var statearr_73332_73362 = state_73313__$1;
(statearr_73332_73362[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (19))){
var inst_73293 = (state_73313[(19)]);
var state_73313__$1 = state_73313;
var statearr_73333_73363 = state_73313__$1;
(statearr_73333_73363[(2)] = inst_73293);

(statearr_73333_73363[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (11))){
var inst_73280 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
var statearr_73335_73364 = state_73313__$1;
(statearr_73335_73364[(2)] = inst_73280);

(statearr_73335_73364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (9))){
var inst_73273 = (state_73313[(17)]);
var state_73313__$1 = state_73313;
var statearr_73336_73365 = state_73313__$1;
(statearr_73336_73365[(2)] = inst_73273);

(statearr_73336_73365[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (5))){
var _ = (function (){var statearr_73337 = state_73313;
(statearr_73337[(4)] = cljs.core.rest((state_73313[(4)])));

return statearr_73337;
})();
var state_73313__$1 = state_73313;
var ex73334 = (state_73313__$1[(2)]);
var statearr_73338_73366 = state_73313__$1;
(statearr_73338_73366[(5)] = ex73334);


var statearr_73339_73367 = state_73313__$1;
(statearr_73339_73367[(1)] = (4));

(statearr_73339_73367[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (14))){
var inst_73288 = (state_73313[(13)]);
var state_73313__$1 = state_73313;
var statearr_73340_73368 = state_73313__$1;
(statearr_73340_73368[(2)] = inst_73288);

(statearr_73340_73368[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (16))){
var inst_73306 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
var statearr_73341_73369 = state_73313__$1;
(statearr_73341_73369[(2)] = inst_73306);

(statearr_73341_73369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (10))){
var inst_73263 = (state_73313[(14)]);
var inst_73272 = (state_73313[(18)]);
var inst_73276 = fluree.db.api_js.monitor_tx(conn,ledger,inst_73272,inst_73263);
var state_73313__$1 = state_73313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73313__$1,(12),inst_73276);
} else {
if((state_val_73314 === (18))){
var inst_73293 = (state_73313[(19)]);
var inst_73296 = cljs.core.ex_data(inst_73293);
var inst_73297 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73298 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73296);
var inst_73299 = cljs.core.ex_message(inst_73293);
var inst_73300 = [inst_73298,inst_73299,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_73301 = cljs.core.PersistentHashMap.fromArrays(inst_73297,inst_73300);
var state_73313__$1 = state_73313;
var statearr_73342_73370 = state_73313__$1;
(statearr_73342_73370[(2)] = inst_73301);

(statearr_73342_73370[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (8))){
var inst_73308 = (state_73313[(2)]);
var _ = (function (){var statearr_73343 = state_73313;
(statearr_73343[(4)] = cljs.core.rest((state_73313[(4)])));

return statearr_73343;
})();
var state_73313__$1 = state_73313;
var statearr_73344_73371 = state_73313__$1;
(statearr_73344_73371[(2)] = inst_73308);

(statearr_73344_73371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73345 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73345[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73345[(1)] = (1));

return statearr_73345;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73313){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73313);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73346){var ex__2730__auto__ = e73346;
var statearr_73347_73372 = state_73313;
(statearr_73347_73372[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73313[(4)]))){
var statearr_73348_73373 = state_73313;
(statearr_73348_73373[(1)] = cljs.core.first((state_73313[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73374 = state_73313;
state_73313 = G__73374;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73313){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73349 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73349[(6)] = c__2749__auto__);

return statearr_73349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___73376 = arguments.length;
var i__4865__auto___73377 = (0);
while(true){
if((i__4865__auto___73377 < len__4864__auto___73376)){
args__4870__auto__.push((arguments[i__4865__auto___73377]));

var G__73378 = (i__4865__auto___73377 + (1));
i__4865__auto___73377 = G__73378;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq73375){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq73375));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73409){
var state_val_73410 = (state_73409[(1)]);
if((state_val_73410 === (1))){
var inst_73379 = cljs.core.first(flakes);
var inst_73380 = cljs.core.rest(flakes);
var inst_73381 = cljs.core.PersistentVector.EMPTY;
var inst_73382 = inst_73379;
var inst_73383 = inst_73380;
var inst_73384 = inst_73381;
var state_73409__$1 = (function (){var statearr_73411 = state_73409;
(statearr_73411[(7)] = inst_73383);

(statearr_73411[(8)] = inst_73382);

(statearr_73411[(9)] = inst_73384);

return statearr_73411;
})();
var statearr_73412_73425 = state_73409__$1;
(statearr_73412_73425[(2)] = null);

(statearr_73412_73425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73410 === (2))){
var inst_73382 = (state_73409[(8)]);
var inst_73386 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_73387 = cljs.core.PersistentHashMap.EMPTY;
var inst_73388 = [true,inst_73387];
var inst_73389 = cljs.core.PersistentHashMap.fromArrays(inst_73386,inst_73388);
var inst_73390 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_73389,inst_73382);
var state_73409__$1 = state_73409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73409__$1,(4),inst_73390);
} else {
if((state_val_73410 === (3))){
var inst_73407 = (state_73409[(2)]);
var state_73409__$1 = state_73409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73409__$1,inst_73407);
} else {
if((state_val_73410 === (4))){
var inst_73383 = (state_73409[(7)]);
var inst_73384 = (state_73409[(9)]);
var inst_73392 = (state_73409[(2)]);
var inst_73393 = fluree.db.util.async.throw_err(inst_73392);
var inst_73394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73395 = [inst_73393];
var inst_73396 = (new cljs.core.PersistentVector(null,1,(5),inst_73394,inst_73395,null));
var inst_73397 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_73384,inst_73396);
var inst_73398 = cljs.core.first(inst_73383);
var state_73409__$1 = (function (){var statearr_73413 = state_73409;
(statearr_73413[(10)] = inst_73397);

return statearr_73413;
})();
if(cljs.core.truth_(inst_73398)){
var statearr_73414_73426 = state_73409__$1;
(statearr_73414_73426[(1)] = (5));

} else {
var statearr_73415_73427 = state_73409__$1;
(statearr_73415_73427[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73410 === (5))){
var inst_73383 = (state_73409[(7)]);
var inst_73397 = (state_73409[(10)]);
var inst_73400 = cljs.core.first(inst_73383);
var inst_73401 = cljs.core.rest(inst_73383);
var inst_73382 = inst_73400;
var inst_73383__$1 = inst_73401;
var inst_73384 = inst_73397;
var state_73409__$1 = (function (){var statearr_73416 = state_73409;
(statearr_73416[(7)] = inst_73383__$1);

(statearr_73416[(8)] = inst_73382);

(statearr_73416[(9)] = inst_73384);

return statearr_73416;
})();
var statearr_73417_73428 = state_73409__$1;
(statearr_73417_73428[(2)] = null);

(statearr_73417_73428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73410 === (6))){
var inst_73397 = (state_73409[(10)]);
var state_73409__$1 = state_73409;
var statearr_73418_73429 = state_73409__$1;
(statearr_73418_73429[(2)] = inst_73397);

(statearr_73418_73429[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73410 === (7))){
var inst_73405 = (state_73409[(2)]);
var state_73409__$1 = state_73409;
var statearr_73419_73430 = state_73409__$1;
(statearr_73419_73430[(2)] = inst_73405);

(statearr_73419_73430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_73420 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73420[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__);

(statearr_73420[(1)] = (1));

return statearr_73420;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1 = (function (state_73409){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73409);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73421){var ex__2730__auto__ = e73421;
var statearr_73422_73431 = state_73409;
(statearr_73422_73431[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73409[(4)]))){
var statearr_73423_73432 = state_73409;
(statearr_73423_73432[(1)] = cljs.core.first((state_73409[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73433 = state_73409;
state_73409 = G__73433;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = function(state_73409){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1.call(this,state_73409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73424 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73424[(6)] = c__2749__auto__);

return statearr_73424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73501){
var state_val_73502 = (state_73501[(1)]);
if((state_val_73502 === (7))){
var inst_73461 = (state_73501[(2)]);
var inst_73462 = fluree.db.util.async.throw_err(inst_73461);
var state_73501__$1 = state_73501;
var statearr_73503_73529 = state_73501__$1;
(statearr_73503_73529[(2)] = inst_73462);

(statearr_73503_73529[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (1))){
var inst_73438 = cljs.core.volatile_BANG_((0));
var inst_73439 = cljs.core.PersistentHashMap.EMPTY;
var inst_73440 = cljs.core.volatile_BANG_(inst_73439);
var inst_73441 = cljs.core.first(resp);
var inst_73442 = cljs.core.rest(resp);
var inst_73443 = cljs.core.PersistentVector.EMPTY;
var inst_73444 = inst_73438;
var inst_73445 = inst_73440;
var inst_73446 = inst_73441;
var inst_73447 = inst_73442;
var inst_73448 = inst_73443;
var state_73501__$1 = (function (){var statearr_73504 = state_73501;
(statearr_73504[(7)] = inst_73445);

(statearr_73504[(8)] = inst_73448);

(statearr_73504[(9)] = inst_73444);

(statearr_73504[(10)] = inst_73447);

(statearr_73504[(11)] = inst_73446);

return statearr_73504;
})();
var statearr_73505_73530 = state_73501__$1;
(statearr_73505_73530[(2)] = null);

(statearr_73505_73530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (4))){
var inst_73445 = (state_73501[(7)]);
var inst_73448 = (state_73501[(8)]);
var inst_73444 = (state_73501[(9)]);
var inst_73447 = (state_73501[(10)]);
var inst_73446 = (state_73501[(11)]);
var inst_73450 = (state_73501[(12)]);
var inst_73452 = (state_73501[(13)]);
var inst_73456 = (function (){var fuel = inst_73444;
var cache = inst_73445;
var curr_block = inst_73446;
var rest_blocks = inst_73447;
var acc = inst_73448;
var flakes = inst_73450;
var asserted = inst_73452;
return (function (p1__73435_SHARP_){
return p1__73435_SHARP_.s;
});
})();
var inst_73457 = cljs.core.group_by(inst_73456,inst_73452);
var inst_73458 = cljs.core.vals(inst_73457);
var inst_73459 = fluree.db.api_js.format_flake_groups_pretty(db,inst_73445,inst_73444,inst_73458);
var state_73501__$1 = state_73501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73501__$1,(7),inst_73459);
} else {
if((state_val_73502 === (13))){
var inst_73489 = (state_73501[(14)]);
var state_73501__$1 = state_73501;
var statearr_73506_73531 = state_73501__$1;
(statearr_73506_73531[(2)] = inst_73489);

(statearr_73506_73531[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (6))){
var inst_73465 = (state_73501[(15)]);
var inst_73445 = (state_73501[(7)]);
var inst_73448 = (state_73501[(8)]);
var inst_73467 = (state_73501[(16)]);
var inst_73444 = (state_73501[(9)]);
var inst_73447 = (state_73501[(10)]);
var inst_73446 = (state_73501[(11)]);
var inst_73450 = (state_73501[(12)]);
var inst_73452 = (state_73501[(13)]);
var inst_73465__$1 = (state_73501[(2)]);
var inst_73466 = (function (){var fuel = inst_73444;
var cache = inst_73445;
var curr_block = inst_73446;
var rest_blocks = inst_73447;
var acc = inst_73448;
var flakes = inst_73450;
var asserted = inst_73452;
var asserted_SINGLEQUOTE_ = inst_73465__$1;
return (function (p1__73436_SHARP_){
return p1__73436_SHARP_.op === false;
});
})();
var inst_73467__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_73466,inst_73450);
var inst_73468 = cljs.core.empty_QMARK_(inst_73467__$1);
var inst_73469 = (!(inst_73468));
var state_73501__$1 = (function (){var statearr_73509 = state_73501;
(statearr_73509[(15)] = inst_73465__$1);

(statearr_73509[(16)] = inst_73467__$1);

return statearr_73509;
})();
if(inst_73469){
var statearr_73510_73532 = state_73501__$1;
(statearr_73510_73532[(1)] = (8));

} else {
var statearr_73511_73533 = state_73501__$1;
(statearr_73511_73533[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (3))){
var inst_73499 = (state_73501[(2)]);
var state_73501__$1 = state_73501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73501__$1,inst_73499);
} else {
if((state_val_73502 === (12))){
var inst_73445 = (state_73501[(7)]);
var inst_73489 = (state_73501[(14)]);
var inst_73444 = (state_73501[(9)]);
var inst_73447 = (state_73501[(10)]);
var inst_73492 = cljs.core.first(inst_73447);
var inst_73493 = cljs.core.rest(inst_73447);
var tmp73507 = inst_73445;
var tmp73508 = inst_73444;
var inst_73444__$1 = tmp73508;
var inst_73445__$1 = tmp73507;
var inst_73446 = inst_73492;
var inst_73447__$1 = inst_73493;
var inst_73448 = inst_73489;
var state_73501__$1 = (function (){var statearr_73512 = state_73501;
(statearr_73512[(7)] = inst_73445__$1);

(statearr_73512[(8)] = inst_73448);

(statearr_73512[(9)] = inst_73444__$1);

(statearr_73512[(10)] = inst_73447__$1);

(statearr_73512[(11)] = inst_73446);

return statearr_73512;
})();
var statearr_73513_73534 = state_73501__$1;
(statearr_73513_73534[(2)] = null);

(statearr_73513_73534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (2))){
var inst_73445 = (state_73501[(7)]);
var inst_73448 = (state_73501[(8)]);
var inst_73444 = (state_73501[(9)]);
var inst_73447 = (state_73501[(10)]);
var inst_73446 = (state_73501[(11)]);
var inst_73450 = (state_73501[(12)]);
var inst_73452 = (state_73501[(13)]);
var inst_73450__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_73446);
var inst_73451 = (function (){var fuel = inst_73444;
var cache = inst_73445;
var curr_block = inst_73446;
var rest_blocks = inst_73447;
var acc = inst_73448;
var flakes = inst_73450__$1;
return (function (p1__73434_SHARP_){
return p1__73434_SHARP_.op;
});
})();
var inst_73452__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_73451,inst_73450__$1);
var inst_73453 = cljs.core.empty_QMARK_(inst_73452__$1);
var inst_73454 = (!(inst_73453));
var state_73501__$1 = (function (){var statearr_73514 = state_73501;
(statearr_73514[(12)] = inst_73450__$1);

(statearr_73514[(13)] = inst_73452__$1);

return statearr_73514;
})();
if(inst_73454){
var statearr_73515_73535 = state_73501__$1;
(statearr_73515_73535[(1)] = (4));

} else {
var statearr_73516_73536 = state_73501__$1;
(statearr_73516_73536[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (11))){
var inst_73477 = (state_73501[(2)]);
var inst_73478 = fluree.db.util.async.throw_err(inst_73477);
var state_73501__$1 = state_73501;
var statearr_73517_73537 = state_73501__$1;
(statearr_73517_73537[(2)] = inst_73478);

(statearr_73517_73537[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (9))){
var state_73501__$1 = state_73501;
var statearr_73518_73538 = state_73501__$1;
(statearr_73518_73538[(2)] = null);

(statearr_73518_73538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (5))){
var state_73501__$1 = state_73501;
var statearr_73519_73539 = state_73501__$1;
(statearr_73519_73539[(2)] = null);

(statearr_73519_73539[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (14))){
var inst_73497 = (state_73501[(2)]);
var state_73501__$1 = state_73501;
var statearr_73520_73540 = state_73501__$1;
(statearr_73520_73540[(2)] = inst_73497);

(statearr_73520_73540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (10))){
var inst_73465 = (state_73501[(15)]);
var inst_73448 = (state_73501[(8)]);
var inst_73447 = (state_73501[(10)]);
var inst_73446 = (state_73501[(11)]);
var inst_73481 = (state_73501[(2)]);
var inst_73482 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_73483 = [inst_73465,inst_73481];
var inst_73484 = cljs.core.PersistentHashMap.fromArrays(inst_73482,inst_73483);
var inst_73485 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73446,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_73484);
var inst_73486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73487 = [inst_73485];
var inst_73488 = (new cljs.core.PersistentVector(null,1,(5),inst_73486,inst_73487,null));
var inst_73489 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_73448,inst_73488);
var inst_73490 = cljs.core.first(inst_73447);
var state_73501__$1 = (function (){var statearr_73521 = state_73501;
(statearr_73521[(14)] = inst_73489);

return statearr_73521;
})();
if(cljs.core.truth_(inst_73490)){
var statearr_73522_73541 = state_73501__$1;
(statearr_73522_73541[(1)] = (12));

} else {
var statearr_73523_73542 = state_73501__$1;
(statearr_73523_73542[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73502 === (8))){
var inst_73465 = (state_73501[(15)]);
var inst_73445 = (state_73501[(7)]);
var inst_73448 = (state_73501[(8)]);
var inst_73467 = (state_73501[(16)]);
var inst_73444 = (state_73501[(9)]);
var inst_73447 = (state_73501[(10)]);
var inst_73446 = (state_73501[(11)]);
var inst_73450 = (state_73501[(12)]);
var inst_73452 = (state_73501[(13)]);
var inst_73471 = (function (){var flakes = inst_73450;
var rest_blocks = inst_73447;
var curr_block = inst_73446;
var asserted_SINGLEQUOTE_ = inst_73465;
var acc = inst_73448;
var fuel = inst_73444;
var cache = inst_73445;
var retracted = inst_73467;
var asserted = inst_73452;
return (function (p1__73437_SHARP_){
return p1__73437_SHARP_.s;
});
})();
var inst_73472 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_73467);
var inst_73473 = cljs.core.group_by(inst_73471,inst_73472);
var inst_73474 = cljs.core.vals(inst_73473);
var inst_73475 = fluree.db.api_js.format_flake_groups_pretty(db,inst_73445,inst_73444,inst_73474);
var state_73501__$1 = state_73501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73501__$1,(11),inst_73475);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_73524 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73524[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_73524[(1)] = (1));

return statearr_73524;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_73501){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73501);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73525){var ex__2730__auto__ = e73525;
var statearr_73526_73543 = state_73501;
(statearr_73526_73543[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73501[(4)]))){
var statearr_73527_73544 = state_73501;
(statearr_73527_73544[(1)] = cljs.core.first((state_73501[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73545 = state_73501;
state_73501 = G__73545;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_73501){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_73501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73528 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73528[(6)] = c__2749__auto__);

return statearr_73528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73645){
var state_val_73646 = (state_73645[(1)]);
if((state_val_73646 === (7))){
var inst_73610 = (state_73645[(7)]);
var inst_73617 = (state_73645[(8)]);
var inst_73616 = cljs.core.seq(inst_73610);
var inst_73617__$1 = cljs.core.first(inst_73616);
var inst_73618 = cljs.core.next(inst_73616);
var state_73645__$1 = (function (){var statearr_73647 = state_73645;
(statearr_73647[(9)] = inst_73618);

(statearr_73647[(8)] = inst_73617__$1);

return statearr_73647;
})();
if(cljs.core.truth_(inst_73617__$1)){
var statearr_73648_73685 = state_73645__$1;
(statearr_73648_73685[(1)] = (9));

} else {
var statearr_73649_73686 = state_73645__$1;
(statearr_73649_73686[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (1))){
var state_73645__$1 = state_73645;
var statearr_73650_73687 = state_73645__$1;
(statearr_73650_73687[(2)] = null);

(statearr_73650_73687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (4))){
var inst_73547 = (state_73645[(2)]);
var state_73645__$1 = state_73645;
var statearr_73651_73688 = state_73645__$1;
(statearr_73651_73688[(2)] = inst_73547);

(statearr_73651_73688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (6))){
var inst_73596 = (state_73645[(2)]);
var inst_73597 = fluree.db.util.async.throw_err(inst_73596);
var inst_73605 = resp;
var inst_73606 = cljs.core.seq(inst_73605);
var inst_73607 = cljs.core.first(inst_73606);
var inst_73608 = cljs.core.next(inst_73606);
var inst_73609 = cljs.core.PersistentHashMap.EMPTY;
var inst_73610 = inst_73605;
var inst_73611 = inst_73609;
var state_73645__$1 = (function (){var statearr_73652 = state_73645;
(statearr_73652[(10)] = inst_73597);

(statearr_73652[(11)] = inst_73611);

(statearr_73652[(12)] = inst_73607);

(statearr_73652[(13)] = inst_73608);

(statearr_73652[(7)] = inst_73610);

return statearr_73652;
})();
var statearr_73653_73689 = state_73645__$1;
(statearr_73653_73689[(2)] = null);

(statearr_73653_73689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (3))){
var inst_73643 = (state_73645[(2)]);
var state_73645__$1 = state_73645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73645__$1,inst_73643);
} else {
if((state_val_73646 === (2))){
var _ = (function (){var statearr_73654 = state_73645;
(statearr_73654[(4)] = cljs.core.cons((5),(state_73645[(4)])));

return statearr_73654;
})();
var inst_73553 = (function (){return (function (p1__73546_SHARP_){
return p1__73546_SHARP_.t;
});
})();
var inst_73554 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_73553,resp);
var inst_73555 = cljs.core.set(inst_73554);
var inst_73592 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_73593 = (function (){var ts = inst_73555;
var c__2749__auto____$1 = inst_73592;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73590){
var state_val_73591 = (state_73590[(1)]);
if((state_val_73591 === (1))){
var inst_73563 = ts;
var inst_73564 = cljs.core.seq(inst_73563);
var inst_73565 = cljs.core.first(inst_73564);
var inst_73566 = cljs.core.next(inst_73564);
var inst_73567 = cljs.core.PersistentHashMap.EMPTY;
var inst_73568 = inst_73563;
var inst_73569 = inst_73567;
var state_73590__$1 = (function (){var statearr_73655 = state_73590;
(statearr_73655[(7)] = inst_73566);

(statearr_73655[(8)] = inst_73569);

(statearr_73655[(9)] = inst_73568);

(statearr_73655[(10)] = inst_73565);

return statearr_73655;
})();
var statearr_73656_73690 = state_73590__$1;
(statearr_73656_73690[(2)] = null);

(statearr_73656_73690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73591 === (2))){
var inst_73575 = (state_73590[(11)]);
var inst_73568 = (state_73590[(9)]);
var inst_73574 = cljs.core.seq(inst_73568);
var inst_73575__$1 = cljs.core.first(inst_73574);
var inst_73576 = cljs.core.next(inst_73574);
var state_73590__$1 = (function (){var statearr_73657 = state_73590;
(statearr_73657[(11)] = inst_73575__$1);

(statearr_73657[(12)] = inst_73576);

return statearr_73657;
})();
if(cljs.core.truth_(inst_73575__$1)){
var statearr_73658_73691 = state_73590__$1;
(statearr_73658_73691[(1)] = (4));

} else {
var statearr_73659_73692 = state_73590__$1;
(statearr_73659_73692[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73591 === (3))){
var inst_73588 = (state_73590[(2)]);
var state_73590__$1 = state_73590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73590__$1,inst_73588);
} else {
if((state_val_73591 === (4))){
var inst_73575 = (state_73590[(11)]);
var inst_73578 = fluree.db.time_travel.non_border_t_to_block(db,inst_73575);
var state_73590__$1 = state_73590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73590__$1,(7),inst_73578);
} else {
if((state_val_73591 === (5))){
var inst_73569 = (state_73590[(8)]);
var state_73590__$1 = state_73590;
var statearr_73660_73693 = state_73590__$1;
(statearr_73660_73693[(2)] = inst_73569);

(statearr_73660_73693[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73591 === (6))){
var inst_73586 = (state_73590[(2)]);
var state_73590__$1 = state_73590;
var statearr_73661_73694 = state_73590__$1;
(statearr_73661_73694[(2)] = inst_73586);

(statearr_73661_73694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73591 === (7))){
var inst_73569 = (state_73590[(8)]);
var inst_73575 = (state_73590[(11)]);
var inst_73576 = (state_73590[(12)]);
var inst_73580 = (state_73590[(2)]);
var inst_73581 = fluree.db.util.async.throw_err(inst_73580);
var inst_73582 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73569,inst_73575,inst_73581);
var inst_73568 = inst_73576;
var inst_73569__$1 = inst_73582;
var state_73590__$1 = (function (){var statearr_73662 = state_73590;
(statearr_73662[(8)] = inst_73569__$1);

(statearr_73662[(9)] = inst_73568);

return statearr_73662;
})();
var statearr_73663_73695 = state_73590__$1;
(statearr_73663_73695[(2)] = null);

(statearr_73663_73695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_73664 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73664[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_73664[(1)] = (1));

return statearr_73664;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_73590){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73590);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73665){var ex__2730__auto__ = e73665;
var statearr_73666_73696 = state_73590;
(statearr_73666_73696[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73590[(4)]))){
var statearr_73667_73697 = state_73590;
(statearr_73667_73697[(1)] = cljs.core.first((state_73590[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73698 = state_73590;
state_73590 = G__73698;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_73590){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_73590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73668 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73668[(6)] = c__2749__auto____$1);

return statearr_73668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_73594 = cljs.core.async.impl.dispatch.run(inst_73593);
var state_73645__$1 = (function (){var statearr_73669 = state_73645;
(statearr_73669[(14)] = inst_73594);

return statearr_73669;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73645__$1,(6),inst_73592);
} else {
if((state_val_73646 === (11))){
var inst_73637 = (state_73645[(2)]);
var state_73645__$1 = state_73645;
var statearr_73671_73699 = state_73645__$1;
(statearr_73671_73699[(2)] = inst_73637);

(statearr_73671_73699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (9))){
var inst_73597 = (state_73645[(10)]);
var inst_73611 = (state_73645[(11)]);
var inst_73618 = (state_73645[(9)]);
var inst_73617 = (state_73645[(8)]);
var inst_73620 = inst_73617.t;
var inst_73621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73597,inst_73620);
var inst_73622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73623 = [inst_73621,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73624 = (new cljs.core.PersistentVector(null,2,(5),inst_73622,inst_73623,null));
var inst_73625 = cljs.core.assoc_in(inst_73611,inst_73624,inst_73621);
var inst_73626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73627 = [inst_73621,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_73628 = (new cljs.core.PersistentVector(null,2,(5),inst_73626,inst_73627,null));
var inst_73629 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_73625,inst_73628,cljs.core.conj,inst_73617);
var inst_73630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73631 = [inst_73621,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_73632 = (new cljs.core.PersistentVector(null,2,(5),inst_73630,inst_73631,null));
var inst_73633 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_73629,inst_73632,fluree.db.api_js.min_safe,inst_73620);
var inst_73610 = inst_73618;
var inst_73611__$1 = inst_73633;
var state_73645__$1 = (function (){var statearr_73672 = state_73645;
(statearr_73672[(11)] = inst_73611__$1);

(statearr_73672[(7)] = inst_73610);

return statearr_73672;
})();
var statearr_73673_73700 = state_73645__$1;
(statearr_73673_73700[(2)] = null);

(statearr_73673_73700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (5))){
var _ = (function (){var statearr_73674 = state_73645;
(statearr_73674[(4)] = cljs.core.rest((state_73645[(4)])));

return statearr_73674;
})();
var state_73645__$1 = state_73645;
var ex73670 = (state_73645__$1[(2)]);
var statearr_73675_73701 = state_73645__$1;
(statearr_73675_73701[(5)] = ex73670);


if((ex73670 instanceof Error)){
var statearr_73676_73702 = state_73645__$1;
(statearr_73676_73702[(1)] = (4));

(statearr_73676_73702[(5)] = null);

} else {
throw ex73670;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (10))){
var inst_73611 = (state_73645[(11)]);
var state_73645__$1 = state_73645;
var statearr_73677_73703 = state_73645__$1;
(statearr_73677_73703[(2)] = inst_73611);

(statearr_73677_73703[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73646 === (8))){
var inst_73639 = (state_73645[(2)]);
var inst_73640 = cljs.core.vals(inst_73639);
var _ = (function (){var statearr_73678 = state_73645;
(statearr_73678[(4)] = cljs.core.rest((state_73645[(4)])));

return statearr_73678;
})();
var state_73645__$1 = state_73645;
var statearr_73679_73704 = state_73645__$1;
(statearr_73679_73704[(2)] = inst_73640);

(statearr_73679_73704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_73680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73680[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_73680[(1)] = (1));

return statearr_73680;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_73645){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73645);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73681){var ex__2730__auto__ = e73681;
var statearr_73682_73705 = state_73645;
(statearr_73682_73705[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73645[(4)]))){
var statearr_73683_73706 = state_73645;
(statearr_73683_73706[(1)] = cljs.core.first((state_73645[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73707 = state_73645;
state_73645 = G__73707;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_73645){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_73645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73684 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73684[(6)] = c__2749__auto__);

return statearr_73684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73855){
var state_val_73856 = (state_73855[(1)]);
if((state_val_73856 === (7))){
var inst_73735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73736 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73737 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73738 = [inst_73736,inst_73737];
var inst_73739 = (new cljs.core.PersistentVector(null,2,(5),inst_73735,inst_73738,null));
var state_73855__$1 = state_73855;
var statearr_73857_73928 = state_73855__$1;
(statearr_73857_73928[(2)] = inst_73739);

(statearr_73857_73928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (20))){
var inst_73765 = (state_73855[(7)]);
var state_73855__$1 = state_73855;
var statearr_73858_73929 = state_73855__$1;
(statearr_73858_73929[(2)] = inst_73765);

(statearr_73858_73929[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (27))){
var state_73855__$1 = state_73855;
var statearr_73859_73930 = state_73855__$1;
(statearr_73859_73930[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (1))){
var state_73855__$1 = state_73855;
var statearr_73861_73931 = state_73855__$1;
(statearr_73861_73931[(2)] = null);

(statearr_73861_73931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (24))){
var inst_73764 = (state_73855[(8)]);
var state_73855__$1 = state_73855;
if(cljs.core.truth_(inst_73764)){
var statearr_73862_73932 = state_73855__$1;
(statearr_73862_73932[(1)] = (26));

} else {
var statearr_73863_73933 = state_73855__$1;
(statearr_73863_73933[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (39))){
var inst_73811 = (state_73855[(9)]);
var inst_73810 = (state_73855[(10)]);
var inst_73836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73837 = [inst_73810,inst_73811];
var inst_73838 = (new cljs.core.PersistentVector(null,2,(5),inst_73836,inst_73837,null));
var state_73855__$1 = state_73855;
var statearr_73864_73934 = state_73855__$1;
(statearr_73864_73934[(2)] = inst_73838);

(statearr_73864_73934[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (4))){
var inst_73708 = (state_73855[(2)]);
var inst_73709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73710 = [inst_73708];
var inst_73711 = (new cljs.core.PersistentVector(null,1,(5),inst_73709,inst_73710,null));
var inst_73712 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73711);
var inst_73713 = cljs.core.ex_data(inst_73708);
var inst_73714 = cljs.core.ex_message(inst_73708);
var inst_73715 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73713,new cljs.core.Keyword(null,"message","message",-406056002),inst_73714);
var state_73855__$1 = (function (){var statearr_73865 = state_73855;
(statearr_73865[(11)] = inst_73712);

return statearr_73865;
})();
var statearr_73866_73935 = state_73855__$1;
(statearr_73866_73935[(2)] = inst_73715);

(statearr_73866_73935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (15))){
var inst_73749 = (state_73855[(12)]);
var inst_73744 = (state_73855[(13)]);
var inst_73758 = (state_73855[(2)]);
var inst_73759 = [inst_73749,inst_73758];
var inst_73760 = (new cljs.core.PersistentVector(null,2,(5),inst_73744,inst_73759,null));
var state_73855__$1 = state_73855;
var statearr_73867_73936 = state_73855__$1;
(statearr_73867_73936[(2)] = inst_73760);

(statearr_73867_73936[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (21))){
var inst_73764 = (state_73855[(8)]);
var state_73855__$1 = state_73855;
var statearr_73868_73937 = state_73855__$1;
(statearr_73868_73937[(2)] = inst_73764);

(statearr_73868_73937[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (31))){
var inst_73805 = (state_73855[(2)]);
var state_73855__$1 = state_73855;
var statearr_73869_73938 = state_73855__$1;
(statearr_73869_73938[(2)] = inst_73805);

(statearr_73869_73938[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (32))){
var inst_73811 = (state_73855[(9)]);
var inst_73814 = cljs.core.pos_int_QMARK_(inst_73811);
var state_73855__$1 = state_73855;
var statearr_73870_73939 = state_73855__$1;
(statearr_73870_73939[(2)] = inst_73814);

(statearr_73870_73939[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (40))){
var inst_73842 = (state_73855[(14)]);
var inst_73766 = (state_73855[(15)]);
var inst_73840 = (state_73855[(2)]);
var inst_73841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73840,(0),null);
var inst_73842__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73840,(1),null);
var inst_73843 = (inst_73842__$1 > inst_73766);
var state_73855__$1 = (function (){var statearr_73871 = state_73855;
(statearr_73871[(16)] = inst_73841);

(statearr_73871[(14)] = inst_73842__$1);

return statearr_73871;
})();
if(cljs.core.truth_(inst_73843)){
var statearr_73872_73940 = state_73855__$1;
(statearr_73872_73940[(1)] = (41));

} else {
var statearr_73873_73941 = state_73855__$1;
(statearr_73873_73941[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (33))){
var inst_73812 = (state_73855[(17)]);
var state_73855__$1 = state_73855;
var statearr_73874_73942 = state_73855__$1;
(statearr_73874_73942[(2)] = inst_73812);

(statearr_73874_73942[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (13))){
var inst_73750 = (state_73855[(18)]);
var inst_73752 = fluree.db.time_travel.block_to_int_format(db,inst_73750);
var state_73855__$1 = state_73855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73855__$1,(16),inst_73752);
} else {
if((state_val_73856 === (22))){
var inst_73783 = (state_73855[(2)]);
var state_73855__$1 = state_73855;
if(cljs.core.truth_(inst_73783)){
var statearr_73875_73943 = state_73855__$1;
(statearr_73875_73943[(1)] = (23));

} else {
var statearr_73876_73944 = state_73855__$1;
(statearr_73876_73944[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (36))){
var state_73855__$1 = state_73855;
var statearr_73877_73945 = state_73855__$1;
(statearr_73877_73945[(2)] = null);

(statearr_73877_73945[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (41))){
var inst_73766 = (state_73855[(15)]);
var state_73855__$1 = state_73855;
var statearr_73878_73946 = state_73855__$1;
(statearr_73878_73946[(2)] = inst_73766);

(statearr_73878_73946[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (43))){
var inst_73841 = (state_73855[(16)]);
var inst_73847 = (state_73855[(2)]);
var inst_73848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73849 = [inst_73841,inst_73847];
var inst_73850 = (new cljs.core.PersistentVector(null,2,(5),inst_73848,inst_73849,null));
var _ = (function (){var statearr_73879 = state_73855;
(statearr_73879[(4)] = cljs.core.rest((state_73855[(4)])));

return statearr_73879;
})();
var state_73855__$1 = state_73855;
var statearr_73880_73947 = state_73855__$1;
(statearr_73880_73947[(2)] = inst_73850);

(statearr_73880_73947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (29))){
var inst_73741 = (state_73855[(19)]);
var inst_73796 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73741], 0));
var inst_73797 = ["Invalid block range provided: ",inst_73796].join('');
var inst_73798 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73799 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73800 = cljs.core.PersistentHashMap.fromArrays(inst_73798,inst_73799);
var inst_73801 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73797,inst_73800);
var inst_73802 = (function(){throw inst_73801})();
var state_73855__$1 = state_73855;
var statearr_73881_73948 = state_73855__$1;
(statearr_73881_73948[(2)] = inst_73802);

(statearr_73881_73948[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (6))){
var inst_73733 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_73855__$1 = state_73855;
var statearr_73882_73949 = state_73855__$1;
(statearr_73882_73949[(2)] = inst_73733);

(statearr_73882_73949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (28))){
var inst_73807 = (state_73855[(2)]);
var state_73855__$1 = state_73855;
var statearr_73883_73950 = state_73855__$1;
(statearr_73883_73950[(2)] = inst_73807);

(statearr_73883_73950[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (25))){
var inst_73812 = (state_73855[(17)]);
var inst_73810 = (state_73855[(10)]);
var inst_73809 = (state_73855[(2)]);
var inst_73810__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73809,(0),null);
var inst_73811 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73809,(1),null);
var inst_73812__$1 = cljs.core.pos_int_QMARK_(inst_73810__$1);
var state_73855__$1 = (function (){var statearr_73884 = state_73855;
(statearr_73884[(9)] = inst_73811);

(statearr_73884[(17)] = inst_73812__$1);

(statearr_73884[(10)] = inst_73810__$1);

return statearr_73884;
})();
if(inst_73812__$1){
var statearr_73885_73951 = state_73855__$1;
(statearr_73885_73951[(1)] = (32));

} else {
var statearr_73886_73952 = state_73855__$1;
(statearr_73886_73952[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (34))){
var inst_73817 = (state_73855[(2)]);
var inst_73818 = cljs.core.not(inst_73817);
var state_73855__$1 = state_73855;
if(inst_73818){
var statearr_73887_73953 = state_73855__$1;
(statearr_73887_73953[(1)] = (35));

} else {
var statearr_73888_73954 = state_73855__$1;
(statearr_73888_73954[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (17))){
var inst_73764 = (state_73855[(8)]);
var inst_73766 = (state_73855[(15)]);
var inst_73769 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73764], 0));
var inst_73770 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73766], 0));
var inst_73771 = ["Start block is out of range for this ledger. Start block provided: ",inst_73769,". Database block: ",inst_73770].join('');
var inst_73772 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73773 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73774 = cljs.core.PersistentHashMap.fromArrays(inst_73772,inst_73773);
var inst_73775 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73771,inst_73774);
var inst_73776 = (function(){throw inst_73775})();
var state_73855__$1 = state_73855;
var statearr_73889_73955 = state_73855__$1;
(statearr_73889_73955[(2)] = inst_73776);

(statearr_73889_73955[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (3))){
var inst_73853 = (state_73855[(2)]);
var state_73855__$1 = state_73855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73855__$1,inst_73853);
} else {
if((state_val_73856 === (12))){
var inst_73750 = (state_73855[(18)]);
var inst_73741 = (state_73855[(19)]);
var inst_73748 = (state_73855[(2)]);
var inst_73749 = fluree.db.util.async.throw_err(inst_73748);
var inst_73750__$1 = cljs.core.second(inst_73741);
var state_73855__$1 = (function (){var statearr_73890 = state_73855;
(statearr_73890[(18)] = inst_73750__$1);

(statearr_73890[(12)] = inst_73749);

return statearr_73890;
})();
if(cljs.core.truth_(inst_73750__$1)){
var statearr_73891_73956 = state_73855__$1;
(statearr_73891_73956[(1)] = (13));

} else {
var statearr_73892_73957 = state_73855__$1;
(statearr_73892_73957[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (2))){
var _ = (function (){var statearr_73893 = state_73855;
(statearr_73893[(4)] = cljs.core.cons((5),(state_73855[(4)])));

return statearr_73893;
})();
var inst_73730 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73731 = cljs.core.sequential_QMARK_(inst_73730);
var state_73855__$1 = state_73855;
if(inst_73731){
var statearr_73894_73958 = state_73855__$1;
(statearr_73894_73958[(1)] = (6));

} else {
var statearr_73895_73959 = state_73855__$1;
(statearr_73895_73959[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (23))){
var inst_73765 = (state_73855[(7)]);
var inst_73764 = (state_73855[(8)]);
var inst_73785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73786 = [inst_73764,inst_73765];
var inst_73787 = (new cljs.core.PersistentVector(null,2,(5),inst_73785,inst_73786,null));
var state_73855__$1 = state_73855;
var statearr_73896_73960 = state_73855__$1;
(statearr_73896_73960[(2)] = inst_73787);

(statearr_73896_73960[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (35))){
var inst_73741 = (state_73855[(19)]);
var inst_73820 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73741], 0));
var inst_73821 = ["Invalid block range provided: ",inst_73820].join('');
var inst_73822 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73823 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73824 = cljs.core.PersistentHashMap.fromArrays(inst_73822,inst_73823);
var inst_73825 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73821,inst_73824);
var inst_73826 = (function(){throw inst_73825})();
var state_73855__$1 = state_73855;
var statearr_73897_73961 = state_73855__$1;
(statearr_73897_73961[(2)] = inst_73826);

(statearr_73897_73961[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (19))){
var inst_73764 = (state_73855[(8)]);
var inst_73779 = (state_73855[(2)]);
var state_73855__$1 = (function (){var statearr_73898 = state_73855;
(statearr_73898[(20)] = inst_73779);

return statearr_73898;
})();
if(cljs.core.truth_(inst_73764)){
var statearr_73899_73962 = state_73855__$1;
(statearr_73899_73962[(1)] = (20));

} else {
var statearr_73900_73963 = state_73855__$1;
(statearr_73900_73963[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (11))){
var inst_73764 = (state_73855[(8)]);
var inst_73766 = (state_73855[(15)]);
var inst_73763 = (state_73855[(2)]);
var inst_73764__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73763,(0),null);
var inst_73765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73763,(1),null);
var inst_73766__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73767 = (inst_73764__$1 > inst_73766__$1);
var state_73855__$1 = (function (){var statearr_73902 = state_73855;
(statearr_73902[(7)] = inst_73765);

(statearr_73902[(8)] = inst_73764__$1);

(statearr_73902[(15)] = inst_73766__$1);

return statearr_73902;
})();
if(cljs.core.truth_(inst_73767)){
var statearr_73903_73964 = state_73855__$1;
(statearr_73903_73964[(1)] = (17));

} else {
var statearr_73904_73965 = state_73855__$1;
(statearr_73904_73965[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (9))){
var inst_73741 = (state_73855[(19)]);
var inst_73744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73745 = cljs.core.first(inst_73741);
var inst_73746 = fluree.db.time_travel.block_to_int_format(db,inst_73745);
var state_73855__$1 = (function (){var statearr_73905 = state_73855;
(statearr_73905[(13)] = inst_73744);

return statearr_73905;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73855__$1,(12),inst_73746);
} else {
if((state_val_73856 === (5))){
var _ = (function (){var statearr_73906 = state_73855;
(statearr_73906[(4)] = cljs.core.rest((state_73855[(4)])));

return statearr_73906;
})();
var state_73855__$1 = state_73855;
var ex73901 = (state_73855__$1[(2)]);
var statearr_73907_73966 = state_73855__$1;
(statearr_73907_73966[(5)] = ex73901);


var statearr_73908_73967 = state_73855__$1;
(statearr_73908_73967[(1)] = (4));

(statearr_73908_73967[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (14))){
var state_73855__$1 = state_73855;
var statearr_73909_73968 = state_73855__$1;
(statearr_73909_73968[(2)] = null);

(statearr_73909_73968[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (26))){
var inst_73764 = (state_73855[(8)]);
var inst_73790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73791 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73792 = [inst_73764,inst_73791];
var inst_73793 = (new cljs.core.PersistentVector(null,2,(5),inst_73790,inst_73792,null));
var state_73855__$1 = state_73855;
var statearr_73910_73969 = state_73855__$1;
(statearr_73910_73969[(2)] = inst_73793);

(statearr_73910_73969[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (16))){
var inst_73754 = (state_73855[(2)]);
var inst_73755 = fluree.db.util.async.throw_err(inst_73754);
var state_73855__$1 = state_73855;
var statearr_73911_73970 = state_73855__$1;
(statearr_73911_73970[(2)] = inst_73755);

(statearr_73911_73970[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (38))){
var inst_73811 = (state_73855[(9)]);
var inst_73810 = (state_73855[(10)]);
var inst_73832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73833 = [inst_73811,inst_73810];
var inst_73834 = (new cljs.core.PersistentVector(null,2,(5),inst_73832,inst_73833,null));
var state_73855__$1 = state_73855;
var statearr_73912_73971 = state_73855__$1;
(statearr_73912_73971[(2)] = inst_73834);

(statearr_73912_73971[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (30))){
var state_73855__$1 = state_73855;
var statearr_73913_73972 = state_73855__$1;
(statearr_73913_73972[(2)] = null);

(statearr_73913_73972[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (10))){
var inst_73741 = (state_73855[(19)]);
var state_73855__$1 = state_73855;
var statearr_73914_73973 = state_73855__$1;
(statearr_73914_73973[(2)] = inst_73741);

(statearr_73914_73973[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (18))){
var state_73855__$1 = state_73855;
var statearr_73915_73974 = state_73855__$1;
(statearr_73915_73974[(2)] = null);

(statearr_73915_73974[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (42))){
var inst_73842 = (state_73855[(14)]);
var state_73855__$1 = state_73855;
var statearr_73916_73975 = state_73855__$1;
(statearr_73916_73975[(2)] = inst_73842);

(statearr_73916_73975[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (37))){
var inst_73811 = (state_73855[(9)]);
var inst_73810 = (state_73855[(10)]);
var inst_73829 = (state_73855[(2)]);
var inst_73830 = (inst_73811 < inst_73810);
var state_73855__$1 = (function (){var statearr_73917 = state_73855;
(statearr_73917[(21)] = inst_73829);

return statearr_73917;
})();
if(cljs.core.truth_(inst_73830)){
var statearr_73918_73976 = state_73855__$1;
(statearr_73918_73976[(1)] = (38));

} else {
var statearr_73919_73977 = state_73855__$1;
(statearr_73919_73977[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73856 === (8))){
var inst_73741 = (state_73855[(19)]);
var inst_73741__$1 = (state_73855[(2)]);
var inst_73742 = cljs.core.some(cljs.core.string_QMARK_,inst_73741__$1);
var state_73855__$1 = (function (){var statearr_73920 = state_73855;
(statearr_73920[(19)] = inst_73741__$1);

return statearr_73920;
})();
if(cljs.core.truth_(inst_73742)){
var statearr_73921_73978 = state_73855__$1;
(statearr_73921_73978[(1)] = (9));

} else {
var statearr_73922_73979 = state_73855__$1;
(statearr_73922_73979[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_73923 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73923[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__);

(statearr_73923[(1)] = (1));

return statearr_73923;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_73855){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73855);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73924){var ex__2730__auto__ = e73924;
var statearr_73925_73980 = state_73855;
(statearr_73925_73980[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73855[(4)]))){
var statearr_73926_73981 = state_73855;
(statearr_73926_73981[(1)] = cljs.core.first((state_73855[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73982 = state_73855;
state_73855 = G__73982;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = function(state_73855){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_73855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73927 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73927[(6)] = c__2749__auto__);

return statearr_73927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__73984 = arguments.length;
switch (G__73984) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74078){
var state_val_74079 = (state_74078[(1)]);
if((state_val_74079 === (7))){
var inst_74010 = (state_74078[(7)]);
var inst_74013 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_74010);
var state_74078__$1 = state_74078;
var statearr_74080_74131 = state_74078__$1;
(statearr_74080_74131[(2)] = inst_74013);

(statearr_74080_74131[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (20))){
var inst_74049 = (state_74078[(8)]);
var inst_74052 = fluree.db.api_js.format_block_resp_pretty(db,inst_74049);
var state_74078__$1 = state_74078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74078__$1,(23),inst_74052);
} else {
if((state_val_74079 === (27))){
var inst_74058 = (state_74078[(9)]);
var inst_74064 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_74058);
var state_74078__$1 = state_74078;
var statearr_74081_74132 = state_74078__$1;
(statearr_74081_74132[(2)] = inst_74064);

(statearr_74081_74132[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (1))){
var state_74078__$1 = state_74078;
var statearr_74082_74133 = state_74078__$1;
(statearr_74082_74133[(2)] = null);

(statearr_74082_74133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (24))){
var inst_74058 = (state_74078[(9)]);
var inst_74061 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_74062 = cljs.core.sequential_QMARK_(inst_74058);
var state_74078__$1 = (function (){var statearr_74083 = state_74078;
(statearr_74083[(10)] = inst_74061);

return statearr_74083;
})();
if(inst_74062){
var statearr_74084_74134 = state_74078__$1;
(statearr_74084_74134[(1)] = (27));

} else {
var statearr_74085_74135 = state_74078__$1;
(statearr_74085_74135[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (4))){
var inst_73985 = (state_74078[(2)]);
var inst_73986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73987 = [inst_73985];
var inst_73988 = (new cljs.core.PersistentVector(null,1,(5),inst_73986,inst_73987,null));
var inst_73989 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73988);
var inst_73990 = cljs.core.ex_data(inst_73985);
var inst_73991 = cljs.core.ex_message(inst_73985);
var inst_73992 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73990,new cljs.core.Keyword(null,"message","message",-406056002),inst_73991);
var state_74078__$1 = (function (){var statearr_74086 = state_74078;
(statearr_74086[(11)] = inst_73989);

return statearr_74086;
})();
var statearr_74087_74136 = state_74078__$1;
(statearr_74087_74136[(2)] = inst_73992);

(statearr_74087_74136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (15))){
var inst_74010 = (state_74078[(7)]);
var inst_74023 = (state_74078[(2)]);
var inst_74024 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74023,inst_74010);
var inst_74025 = (function(){throw inst_74024})();
var state_74078__$1 = state_74078;
var statearr_74088_74137 = state_74078__$1;
(statearr_74088_74137[(2)] = inst_74025);

(statearr_74088_74137[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (21))){
var inst_74049 = (state_74078[(8)]);
var state_74078__$1 = state_74078;
var statearr_74089_74138 = state_74078__$1;
(statearr_74089_74138[(2)] = inst_74049);

(statearr_74089_74138[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (13))){
var inst_74018 = (state_74078[(12)]);
var state_74078__$1 = state_74078;
var statearr_74090_74139 = state_74078__$1;
(statearr_74090_74139[(2)] = inst_74018);

(statearr_74090_74139[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (22))){
var inst_74058 = (state_74078[(2)]);
var inst_74059 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74078__$1 = (function (){var statearr_74091 = state_74078;
(statearr_74091[(9)] = inst_74058);

return statearr_74091;
})();
if(cljs.core.truth_(inst_74059)){
var statearr_74092_74140 = state_74078__$1;
(statearr_74092_74140[(1)] = (24));

} else {
var statearr_74093_74141 = state_74078__$1;
(statearr_74093_74141[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (29))){
var inst_74061 = (state_74078[(10)]);
var inst_74002 = (state_74078[(13)]);
var inst_74067 = (state_74078[(2)]);
var inst_74068 = fluree.db.util.core.response_time_formatted(inst_74002);
var inst_74069 = [(200),inst_74067,(100),inst_74068];
var inst_74070 = cljs.core.PersistentHashMap.fromArrays(inst_74061,inst_74069);
var state_74078__$1 = state_74078;
var statearr_74094_74142 = state_74078__$1;
(statearr_74094_74142[(2)] = inst_74070);

(statearr_74094_74142[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (6))){
var inst_74011 = (state_74078[(14)]);
var inst_74010 = (state_74078[(7)]);
var inst_74009 = (state_74078[(2)]);
var inst_74010__$1 = fluree.db.util.async.throw_err(inst_74009);
var inst_74011__$1 = cljs.core.map_QMARK_(inst_74010__$1);
var state_74078__$1 = (function (){var statearr_74095 = state_74078;
(statearr_74095[(14)] = inst_74011__$1);

(statearr_74095[(7)] = inst_74010__$1);

return statearr_74095;
})();
if(inst_74011__$1){
var statearr_74096_74143 = state_74078__$1;
(statearr_74096_74143[(1)] = (7));

} else {
var statearr_74097_74144 = state_74078__$1;
(statearr_74097_74144[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (28))){
var inst_74058 = (state_74078[(9)]);
var state_74078__$1 = state_74078;
var statearr_74098_74145 = state_74078__$1;
(statearr_74098_74145[(2)] = inst_74058);

(statearr_74098_74145[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (25))){
var inst_74058 = (state_74078[(9)]);
var state_74078__$1 = state_74078;
var statearr_74099_74146 = state_74078__$1;
(statearr_74099_74146[(2)] = inst_74058);

(statearr_74099_74146[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (17))){
var inst_74041 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_74042 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_74041].join('');
var inst_74043 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74044 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74045 = cljs.core.PersistentHashMap.fromArrays(inst_74043,inst_74044);
var inst_74046 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74042,inst_74045);
var inst_74047 = (function(){throw inst_74046})();
var state_74078__$1 = state_74078;
var statearr_74100_74147 = state_74078__$1;
(statearr_74100_74147[(2)] = inst_74047);

(statearr_74100_74147[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (3))){
var inst_74076 = (state_74078[(2)]);
var state_74078__$1 = state_74078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74078__$1,inst_74076);
} else {
if((state_val_74079 === (12))){
var inst_74010 = (state_74078[(7)]);
var inst_74028 = (state_74078[(2)]);
var inst_74029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74010,(0),null);
var inst_74030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74010,(1),null);
var inst_74031 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_74032 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_74033 = cljs.core.keys(inst_74032);
var inst_74034 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74031,inst_74033);
var state_74078__$1 = (function (){var statearr_74101 = state_74078;
(statearr_74101[(15)] = inst_74028);

(statearr_74101[(16)] = inst_74030);

(statearr_74101[(17)] = inst_74029);

return statearr_74101;
})();
if(inst_74034){
var statearr_74102_74148 = state_74078__$1;
(statearr_74102_74148[(1)] = (16));

} else {
var statearr_74103_74149 = state_74078__$1;
(statearr_74103_74149[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (2))){
var _ = (function (){var statearr_74104 = state_74078;
(statearr_74104[(4)] = cljs.core.cons((5),(state_74078[(4)])));

return statearr_74104;
})();
var inst_74002 = fluree.db.util.core.current_time_millis();
var inst_74003 = db;
var inst_74004 = cljs.core.__destructure_map(inst_74003);
var inst_74005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74004,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_74006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74004,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_74007 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_74078__$1 = (function (){var statearr_74105 = state_74078;
(statearr_74105[(18)] = inst_74006);

(statearr_74105[(19)] = inst_74005);

(statearr_74105[(13)] = inst_74002);

return statearr_74105;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74078__$1,(6),inst_74007);
} else {
if((state_val_74079 === (23))){
var inst_74054 = (state_74078[(2)]);
var inst_74055 = fluree.db.util.async.throw_err(inst_74054);
var state_74078__$1 = state_74078;
var statearr_74106_74150 = state_74078__$1;
(statearr_74106_74150[(2)] = inst_74055);

(statearr_74106_74150[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (19))){
var inst_74038 = (state_74078[(2)]);
var inst_74039 = fluree.db.util.async.throw_err(inst_74038);
var state_74078__$1 = state_74078;
var statearr_74107_74151 = state_74078__$1;
(statearr_74107_74151[(2)] = inst_74039);

(statearr_74107_74151[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (11))){
var state_74078__$1 = state_74078;
var statearr_74109_74152 = state_74078__$1;
(statearr_74109_74152[(2)] = null);

(statearr_74109_74152[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (9))){
var inst_74016 = (state_74078[(2)]);
var state_74078__$1 = state_74078;
if(cljs.core.truth_(inst_74016)){
var statearr_74110_74153 = state_74078__$1;
(statearr_74110_74153[(1)] = (10));

} else {
var statearr_74111_74154 = state_74078__$1;
(statearr_74111_74154[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (5))){
var _ = (function (){var statearr_74112 = state_74078;
(statearr_74112[(4)] = cljs.core.rest((state_74078[(4)])));

return statearr_74112;
})();
var state_74078__$1 = state_74078;
var ex74108 = (state_74078__$1[(2)]);
var statearr_74113_74155 = state_74078__$1;
(statearr_74113_74155[(5)] = ex74108);


var statearr_74114_74156 = state_74078__$1;
(statearr_74114_74156[(1)] = (4));

(statearr_74114_74156[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (14))){
var inst_74006 = (state_74078[(18)]);
var inst_74005 = (state_74078[(19)]);
var inst_74021 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74005),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74006)].join('');
var state_74078__$1 = state_74078;
var statearr_74115_74157 = state_74078__$1;
(statearr_74115_74157[(2)] = inst_74021);

(statearr_74115_74157[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (26))){
var inst_74073 = (state_74078[(2)]);
var _ = (function (){var statearr_74116 = state_74078;
(statearr_74116[(4)] = cljs.core.rest((state_74078[(4)])));

return statearr_74116;
})();
var state_74078__$1 = state_74078;
var statearr_74117_74158 = state_74078__$1;
(statearr_74117_74158[(2)] = inst_74073);

(statearr_74117_74158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (16))){
var inst_74030 = (state_74078[(16)]);
var inst_74029 = (state_74078[(17)]);
var inst_74036 = fluree.db.query.block.block_range(db,inst_74029,inst_74030,opts);
var state_74078__$1 = state_74078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74078__$1,(19),inst_74036);
} else {
if((state_val_74079 === (10))){
var inst_74018 = (state_74078[(12)]);
var inst_74010 = (state_74078[(7)]);
var inst_74018__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_74010);
var state_74078__$1 = (function (){var statearr_74118 = state_74078;
(statearr_74118[(12)] = inst_74018__$1);

return statearr_74118;
})();
if(cljs.core.truth_(inst_74018__$1)){
var statearr_74119_74159 = state_74078__$1;
(statearr_74119_74159[(1)] = (13));

} else {
var statearr_74120_74160 = state_74078__$1;
(statearr_74120_74160[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (18))){
var inst_74049 = (state_74078[(2)]);
var inst_74050 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74078__$1 = (function (){var statearr_74121 = state_74078;
(statearr_74121[(8)] = inst_74049);

return statearr_74121;
})();
if(cljs.core.truth_(inst_74050)){
var statearr_74122_74161 = state_74078__$1;
(statearr_74122_74161[(1)] = (20));

} else {
var statearr_74123_74162 = state_74078__$1;
(statearr_74123_74162[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74079 === (8))){
var inst_74011 = (state_74078[(14)]);
var state_74078__$1 = state_74078;
var statearr_74124_74163 = state_74078__$1;
(statearr_74124_74163[(2)] = inst_74011);

(statearr_74124_74163[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74125 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74125[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74125[(1)] = (1));

return statearr_74125;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74078){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74078);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74126){var ex__2730__auto__ = e74126;
var statearr_74127_74164 = state_74078;
(statearr_74127_74164[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74078[(4)]))){
var statearr_74128_74165 = state_74078;
(statearr_74128_74165[(1)] = cljs.core.first((state_74078[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74166 = state_74078;
state_74078 = G__74166;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74078){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74129 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74129[(6)] = c__2749__auto__);

return statearr_74129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__74168 = arguments.length;
switch (G__74168) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74363){
var state_val_74364 = (state_74363[(1)]);
if((state_val_74364 === (62))){
var inst_74361 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74363__$1,inst_74361);
} else {
if((state_val_74364 === (7))){
var inst_74189 = (state_74363[(7)]);
var inst_74199 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_74189);
var state_74363__$1 = state_74363;
var statearr_74365_74456 = state_74363__$1;
(statearr_74365_74456[(2)] = inst_74199);

(statearr_74365_74456[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (59))){
var inst_74349 = (state_74363[(2)]);
var inst_74350 = fluree.db.util.async.throw_err(inst_74349);
var state_74363__$1 = state_74363;
var statearr_74366_74457 = state_74363__$1;
(statearr_74366_74457[(2)] = inst_74350);

(statearr_74366_74457[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (20))){
var inst_74257 = (state_74363[(8)]);
var inst_74265 = (state_74363[(9)]);
var inst_74257__$1 = (state_74363[(2)]);
var inst_74258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74257__$1,(0));
var inst_74260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74257__$1,(1));
var inst_74261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74257__$1,(2));
var inst_74262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74257__$1,(3));
var inst_74263 = [inst_74259,inst_74260,inst_74261,inst_74262];
var inst_74264 = (new cljs.core.PersistentVector(null,4,(5),inst_74258,inst_74263,null));
var inst_74265__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74264,(0),null);
var inst_74266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74264,(1),null);
var inst_74267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74264,(2),null);
var inst_74268 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74264,(3),null);
var inst_74269 = (inst_74265__$1 == null);
var inst_74270 = cljs.core.not(inst_74269);
var state_74363__$1 = (function (){var statearr_74367 = state_74363;
(statearr_74367[(10)] = inst_74268);

(statearr_74367[(8)] = inst_74257__$1);

(statearr_74367[(11)] = inst_74266);

(statearr_74367[(9)] = inst_74265__$1);

(statearr_74367[(12)] = inst_74267);

return statearr_74367;
})();
if(inst_74270){
var statearr_74368_74458 = state_74363__$1;
(statearr_74368_74458[(1)] = (30));

} else {
var statearr_74369_74459 = state_74363__$1;
(statearr_74369_74459[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (58))){
var inst_74197 = (state_74363[(13)]);
var inst_74353 = (state_74363[(2)]);
var state_74363__$1 = (function (){var statearr_74370 = state_74363;
(statearr_74370[(14)] = inst_74353);

return statearr_74370;
})();
if(cljs.core.truth_(inst_74197)){
var statearr_74371_74460 = state_74363__$1;
(statearr_74371_74460[(1)] = (60));

} else {
var statearr_74372_74461 = state_74363__$1;
(statearr_74372_74461[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (60))){
var inst_74341 = (state_74363[(15)]);
var inst_74353 = (state_74363[(14)]);
var inst_74355 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_74356 = cljs.core.count(inst_74341);
var inst_74357 = [inst_74353,inst_74356,(200)];
var inst_74358 = cljs.core.PersistentHashMap.fromArrays(inst_74355,inst_74357);
var state_74363__$1 = state_74363;
var statearr_74373_74462 = state_74363__$1;
(statearr_74373_74462[(2)] = inst_74358);

(statearr_74373_74462[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (27))){
var inst_74176 = (state_74363[(16)]);
var inst_74245 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74176)].join('');
var inst_74246 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74247 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74248 = cljs.core.PersistentHashMap.fromArrays(inst_74246,inst_74247);
var inst_74249 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74245,inst_74248);
var inst_74250 = (function(){throw inst_74249})();
var state_74363__$1 = state_74363;
var statearr_74374_74463 = state_74363__$1;
(statearr_74374_74463[(2)] = inst_74250);

(statearr_74374_74463[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (1))){
var inst_74173 = query_map;
var inst_74174 = cljs.core.__destructure_map(inst_74173);
var inst_74175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74174,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74174,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_74177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74174,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_74363__$1 = (function (){var statearr_74375 = state_74363;
(statearr_74375[(16)] = inst_74176);

(statearr_74375[(17)] = inst_74177);

(statearr_74375[(18)] = inst_74175);

return statearr_74375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74363__$1,(2),sources);
} else {
if((state_val_74364 === (24))){
var inst_74176 = (state_74363[(16)]);
var inst_74234 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74176)].join('');
var inst_74235 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74236 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74237 = cljs.core.PersistentHashMap.fromArrays(inst_74235,inst_74236);
var inst_74238 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74234,inst_74237);
var inst_74239 = (function(){throw inst_74238})();
var state_74363__$1 = state_74363;
var statearr_74376_74464 = state_74363__$1;
(statearr_74376_74464[(2)] = inst_74239);

(statearr_74376_74464[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (55))){
var inst_74177 = (state_74363[(17)]);
var inst_74344 = (state_74363[(2)]);
var inst_74345 = fluree.db.util.async.throw_err(inst_74344);
var state_74363__$1 = (function (){var statearr_74377 = state_74363;
(statearr_74377[(19)] = inst_74345);

return statearr_74377;
})();
if(cljs.core.truth_(inst_74177)){
var statearr_74378_74465 = state_74363__$1;
(statearr_74378_74465[(1)] = (56));

} else {
var statearr_74379_74466 = state_74363__$1;
(statearr_74379_74466[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (39))){
var inst_74268 = (state_74363[(10)]);
var inst_74266 = (state_74363[(11)]);
var inst_74265 = (state_74363[(9)]);
var inst_74267 = (state_74363[(12)]);
var inst_74289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74291 = [inst_74266,inst_74265,inst_74267,inst_74268];
var inst_74292 = (new cljs.core.PersistentVector(null,4,(5),inst_74290,inst_74291,null));
var inst_74293 = [inst_74292,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_74294 = (new cljs.core.PersistentVector(null,2,(5),inst_74289,inst_74293,null));
var state_74363__$1 = state_74363;
var statearr_74380_74467 = state_74363__$1;
(statearr_74380_74467[(2)] = inst_74294);

(statearr_74380_74467[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (46))){
var inst_74299 = (state_74363[(20)]);
var state_74363__$1 = state_74363;
var statearr_74381_74468 = state_74363__$1;
(statearr_74381_74468[(2)] = inst_74299);

(statearr_74381_74468[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (4))){
var state_74363__$1 = state_74363;
var statearr_74382_74469 = state_74363__$1;
(statearr_74382_74469[(2)] = null);

(statearr_74382_74469[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (54))){
var inst_74180 = (state_74363[(21)]);
var inst_74341 = (state_74363[(15)]);
var inst_74340 = (state_74363[(2)]);
var inst_74341__$1 = fluree.db.util.async.throw_err(inst_74340);
var inst_74342 = fluree.db.api_js.format_history_resp(inst_74180,inst_74341__$1);
var state_74363__$1 = (function (){var statearr_74383 = state_74363;
(statearr_74383[(15)] = inst_74341__$1);

return statearr_74383;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74363__$1,(55),inst_74342);
} else {
if((state_val_74364 === (15))){
var inst_74180 = (state_74363[(21)]);
var inst_74221 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74180);
var state_74363__$1 = state_74363;
var statearr_74384_74470 = state_74363__$1;
(statearr_74384_74470[(2)] = inst_74221);

(statearr_74384_74470[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (48))){
var inst_74268 = (state_74363[(10)]);
var inst_74266 = (state_74363[(11)]);
var inst_74265 = (state_74363[(9)]);
var inst_74267 = (state_74363[(12)]);
var inst_74310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74312 = [inst_74266,inst_74267,inst_74265,inst_74268];
var inst_74313 = (new cljs.core.PersistentVector(null,4,(5),inst_74311,inst_74312,null));
var inst_74314 = [inst_74313,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_74315 = (new cljs.core.PersistentVector(null,2,(5),inst_74310,inst_74314,null));
var state_74363__$1 = state_74363;
var statearr_74385_74471 = state_74363__$1;
(statearr_74385_74471[(2)] = inst_74315);

(statearr_74385_74471[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (50))){
var inst_74328 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74386_74472 = state_74363__$1;
(statearr_74386_74472[(2)] = inst_74328);

(statearr_74386_74472[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (21))){
var inst_74176 = (state_74363[(16)]);
var inst_74232 = cljs.core.empty_QMARK_(inst_74176);
var state_74363__$1 = state_74363;
if(inst_74232){
var statearr_74387_74473 = state_74363__$1;
(statearr_74387_74473[(1)] = (24));

} else {
var statearr_74388_74474 = state_74363__$1;
(statearr_74388_74474[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (31))){
var inst_74276 = (state_74363[(22)]);
var inst_74265 = (state_74363[(9)]);
var inst_74276__$1 = (inst_74265 == null);
var state_74363__$1 = (function (){var statearr_74389 = state_74363;
(statearr_74389[(22)] = inst_74276__$1);

return statearr_74389;
})();
if(cljs.core.truth_(inst_74276__$1)){
var statearr_74390_74475 = state_74363__$1;
(statearr_74390_74475[(1)] = (33));

} else {
var statearr_74391_74476 = state_74363__$1;
(statearr_74391_74476[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (32))){
var inst_74213 = (state_74363[(23)]);
var inst_74180 = (state_74363[(21)]);
var inst_74223 = (state_74363[(24)]);
var inst_74332 = (state_74363[(2)]);
var inst_74333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74332,(0),null);
var inst_74334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74332,(1),null);
var inst_74335 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_74336 = [inst_74213,inst_74223];
var inst_74337 = cljs.core.PersistentHashMap.fromArrays(inst_74335,inst_74336);
var inst_74338 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_74180,inst_74334,cljs.core._EQ_,inst_74333,inst_74337);
var state_74363__$1 = state_74363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74363__$1,(54),inst_74338);
} else {
if((state_val_74364 === (40))){
var inst_74296 = (state_74363[(25)]);
var inst_74265 = (state_74363[(9)]);
var inst_74296__$1 = (inst_74265 == null);
var state_74363__$1 = (function (){var statearr_74392 = state_74363;
(statearr_74392[(25)] = inst_74296__$1);

return statearr_74392;
})();
if(cljs.core.truth_(inst_74296__$1)){
var statearr_74393_74477 = state_74363__$1;
(statearr_74393_74477[(1)] = (42));

} else {
var statearr_74394_74478 = state_74363__$1;
(statearr_74394_74478[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (56))){
var inst_74180 = (state_74363[(21)]);
var inst_74345 = (state_74363[(19)]);
var inst_74347 = fluree.db.api_js.format_block_resp_pretty(inst_74180,inst_74345);
var state_74363__$1 = state_74363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74363__$1,(59),inst_74347);
} else {
if((state_val_74364 === (33))){
var inst_74279 = (state_74363[(26)]);
var inst_74266 = (state_74363[(11)]);
var inst_74278 = (inst_74266 == null);
var inst_74279__$1 = cljs.core.not(inst_74278);
var state_74363__$1 = (function (){var statearr_74395 = state_74363;
(statearr_74395[(26)] = inst_74279__$1);

return statearr_74395;
})();
if(inst_74279__$1){
var statearr_74396_74479 = state_74363__$1;
(statearr_74396_74479[(1)] = (36));

} else {
var statearr_74397_74480 = state_74363__$1;
(statearr_74397_74480[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (13))){
var inst_74207 = (state_74363[(2)]);
var inst_74208 = fluree.db.util.async.throw_err(inst_74207);
var inst_74209 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74208);
var inst_74210 = (inst_74209 - (1));
var state_74363__$1 = state_74363;
var statearr_74398_74481 = state_74363__$1;
(statearr_74398_74481[(2)] = inst_74210);

(statearr_74398_74481[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (22))){
var state_74363__$1 = state_74363;
var statearr_74399_74482 = state_74363__$1;
(statearr_74399_74482[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (36))){
var inst_74267 = (state_74363[(12)]);
var inst_74281 = (inst_74267 == null);
var state_74363__$1 = state_74363;
var statearr_74401_74483 = state_74363__$1;
(statearr_74401_74483[(2)] = inst_74281);

(statearr_74401_74483[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (41))){
var inst_74330 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74402_74484 = state_74363__$1;
(statearr_74402_74484[(2)] = inst_74330);

(statearr_74402_74484[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (43))){
var inst_74296 = (state_74363[(25)]);
var state_74363__$1 = state_74363;
var statearr_74403_74485 = state_74363__$1;
(statearr_74403_74485[(2)] = inst_74296);

(statearr_74403_74485[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (61))){
var inst_74353 = (state_74363[(14)]);
var state_74363__$1 = state_74363;
var statearr_74404_74486 = state_74363__$1;
(statearr_74404_74486[(2)] = inst_74353);

(statearr_74404_74486[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (29))){
var inst_74253 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74405_74487 = state_74363__$1;
(statearr_74405_74487[(2)] = inst_74253);

(statearr_74405_74487[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (44))){
var inst_74308 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
if(cljs.core.truth_(inst_74308)){
var statearr_74406_74488 = state_74363__$1;
(statearr_74406_74488[(1)] = (48));

} else {
var statearr_74407_74489 = state_74363__$1;
(statearr_74407_74489[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (6))){
var inst_74184 = (state_74363[(2)]);
var inst_74185 = fluree.db.util.async.throw_err(inst_74184);
var state_74363__$1 = state_74363;
var statearr_74408_74490 = state_74363__$1;
(statearr_74408_74490[(2)] = inst_74185);

(statearr_74408_74490[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (28))){
var state_74363__$1 = state_74363;
var statearr_74409_74491 = state_74363__$1;
(statearr_74409_74491[(2)] = null);

(statearr_74409_74491[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (51))){
var inst_74176 = (state_74363[(16)]);
var inst_74318 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74176)].join('');
var inst_74319 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74320 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74321 = cljs.core.PersistentHashMap.fromArrays(inst_74319,inst_74320);
var inst_74322 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74318,inst_74321);
var inst_74323 = (function(){throw inst_74322})();
var state_74363__$1 = state_74363;
var statearr_74410_74492 = state_74363__$1;
(statearr_74410_74492[(2)] = inst_74323);

(statearr_74410_74492[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (25))){
var inst_74176 = (state_74363[(16)]);
var state_74363__$1 = state_74363;
var statearr_74411_74493 = state_74363__$1;
(statearr_74411_74493[(2)] = inst_74176);

(statearr_74411_74493[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (34))){
var inst_74276 = (state_74363[(22)]);
var state_74363__$1 = state_74363;
var statearr_74412_74494 = state_74363__$1;
(statearr_74412_74494[(2)] = inst_74276);

(statearr_74412_74494[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (17))){
var inst_74217 = (state_74363[(2)]);
var inst_74218 = fluree.db.util.async.throw_err(inst_74217);
var inst_74219 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74218);
var state_74363__$1 = state_74363;
var statearr_74413_74495 = state_74363__$1;
(statearr_74413_74495[(2)] = inst_74219);

(statearr_74413_74495[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (3))){
var inst_74180 = (state_74363[(21)]);
var inst_74182 = fluree.db.api_js.resolve_block_range(inst_74180,query_map);
var state_74363__$1 = state_74363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74363__$1,(6),inst_74182);
} else {
if((state_val_74364 === (12))){
var inst_74190 = (state_74363[(27)]);
var inst_74213 = (state_74363[(2)]);
var state_74363__$1 = (function (){var statearr_74414 = state_74363;
(statearr_74414[(23)] = inst_74213);

return statearr_74414;
})();
if(cljs.core.truth_(inst_74190)){
var statearr_74415_74496 = state_74363__$1;
(statearr_74415_74496[(1)] = (14));

} else {
var statearr_74416_74497 = state_74363__$1;
(statearr_74416_74497[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (2))){
var inst_74175 = (state_74363[(18)]);
var inst_74179 = (state_74363[(2)]);
var inst_74180 = fluree.db.util.async.throw_err(inst_74179);
var state_74363__$1 = (function (){var statearr_74417 = state_74363;
(statearr_74417[(21)] = inst_74180);

return statearr_74417;
})();
if(cljs.core.truth_(inst_74175)){
var statearr_74418_74498 = state_74363__$1;
(statearr_74418_74498[(1)] = (3));

} else {
var statearr_74419_74499 = state_74363__$1;
(statearr_74419_74499[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (23))){
var inst_74255 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74420_74500 = state_74363__$1;
(statearr_74420_74500[(2)] = inst_74255);

(statearr_74420_74500[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (47))){
var inst_74305 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74421_74501 = state_74363__$1;
(statearr_74421_74501[(2)] = inst_74305);

(statearr_74421_74501[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (35))){
var inst_74287 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
if(cljs.core.truth_(inst_74287)){
var statearr_74422_74502 = state_74363__$1;
(statearr_74422_74502[(1)] = (39));

} else {
var statearr_74423_74503 = state_74363__$1;
(statearr_74423_74503[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (19))){
var inst_74176 = (state_74363[(16)]);
var inst_74230 = cljs.core.sequential_QMARK_(inst_74176);
var state_74363__$1 = state_74363;
if(inst_74230){
var statearr_74424_74504 = state_74363__$1;
(statearr_74424_74504[(1)] = (21));

} else {
var statearr_74425_74505 = state_74363__$1;
(statearr_74425_74505[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (57))){
var inst_74345 = (state_74363[(19)]);
var state_74363__$1 = state_74363;
var statearr_74426_74506 = state_74363__$1;
(statearr_74426_74506[(2)] = inst_74345);

(statearr_74426_74506[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (11))){
var state_74363__$1 = state_74363;
var statearr_74427_74507 = state_74363__$1;
(statearr_74427_74507[(2)] = (-1));

(statearr_74427_74507[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (9))){
var inst_74202 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
if(cljs.core.truth_(inst_74202)){
var statearr_74428_74508 = state_74363__$1;
(statearr_74428_74508[(1)] = (10));

} else {
var statearr_74429_74509 = state_74363__$1;
(statearr_74429_74509[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (5))){
var inst_74189 = (state_74363[(7)]);
var inst_74188 = (state_74363[(2)]);
var inst_74189__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74188,(0),null);
var inst_74190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74188,(1),null);
var inst_74197 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74363__$1 = (function (){var statearr_74430 = state_74363;
(statearr_74430[(13)] = inst_74197);

(statearr_74430[(27)] = inst_74190);

(statearr_74430[(7)] = inst_74189__$1);

return statearr_74430;
})();
if(cljs.core.truth_(inst_74189__$1)){
var statearr_74431_74510 = state_74363__$1;
(statearr_74431_74510[(1)] = (7));

} else {
var statearr_74432_74511 = state_74363__$1;
(statearr_74432_74511[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (14))){
var inst_74180 = (state_74363[(21)]);
var inst_74190 = (state_74363[(27)]);
var inst_74215 = fluree.db.time_travel.as_of_block(inst_74180,inst_74190);
var state_74363__$1 = state_74363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74363__$1,(17),inst_74215);
} else {
if((state_val_74364 === (45))){
var inst_74267 = (state_74363[(12)]);
var inst_74301 = (inst_74267 == null);
var inst_74302 = cljs.core.not(inst_74301);
var state_74363__$1 = state_74363;
var statearr_74433_74512 = state_74363__$1;
(statearr_74433_74512[(2)] = inst_74302);

(statearr_74433_74512[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (53))){
var inst_74326 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74434_74513 = state_74363__$1;
(statearr_74434_74513[(2)] = inst_74326);

(statearr_74434_74513[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (26))){
var inst_74242 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74435_74514 = state_74363__$1;
(statearr_74435_74514[(2)] = inst_74242);

(statearr_74435_74514[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (16))){
var inst_74176 = (state_74363[(16)]);
var inst_74223 = (state_74363[(2)]);
var inst_74224 = fluree.db.util.core.subj_ident_QMARK_(inst_74176);
var state_74363__$1 = (function (){var statearr_74436 = state_74363;
(statearr_74436[(24)] = inst_74223);

return statearr_74436;
})();
if(inst_74224){
var statearr_74437_74515 = state_74363__$1;
(statearr_74437_74515[(1)] = (18));

} else {
var statearr_74438_74516 = state_74363__$1;
(statearr_74438_74516[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (38))){
var inst_74284 = (state_74363[(2)]);
var state_74363__$1 = state_74363;
var statearr_74439_74517 = state_74363__$1;
(statearr_74439_74517[(2)] = inst_74284);

(statearr_74439_74517[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (30))){
var inst_74257 = (state_74363[(8)]);
var inst_74272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74273 = [inst_74257,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_74274 = (new cljs.core.PersistentVector(null,2,(5),inst_74272,inst_74273,null));
var state_74363__$1 = state_74363;
var statearr_74440_74518 = state_74363__$1;
(statearr_74440_74518[(2)] = inst_74274);

(statearr_74440_74518[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (10))){
var inst_74180 = (state_74363[(21)]);
var inst_74189 = (state_74363[(7)]);
var inst_74204 = (inst_74189 - (1));
var inst_74205 = fluree.db.time_travel.as_of_block(inst_74180,inst_74204);
var state_74363__$1 = state_74363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74363__$1,(13),inst_74205);
} else {
if((state_val_74364 === (18))){
var inst_74176 = (state_74363[(16)]);
var inst_74226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74227 = [inst_74176];
var inst_74228 = (new cljs.core.PersistentVector(null,1,(5),inst_74226,inst_74227,null));
var state_74363__$1 = state_74363;
var statearr_74441_74519 = state_74363__$1;
(statearr_74441_74519[(2)] = inst_74228);

(statearr_74441_74519[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (52))){
var state_74363__$1 = state_74363;
var statearr_74442_74520 = state_74363__$1;
(statearr_74442_74520[(2)] = null);

(statearr_74442_74520[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (42))){
var inst_74266 = (state_74363[(11)]);
var inst_74299 = (state_74363[(20)]);
var inst_74298 = (inst_74266 == null);
var inst_74299__$1 = cljs.core.not(inst_74298);
var state_74363__$1 = (function (){var statearr_74443 = state_74363;
(statearr_74443[(20)] = inst_74299__$1);

return statearr_74443;
})();
if(inst_74299__$1){
var statearr_74444_74521 = state_74363__$1;
(statearr_74444_74521[(1)] = (45));

} else {
var statearr_74445_74522 = state_74363__$1;
(statearr_74445_74522[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (37))){
var inst_74279 = (state_74363[(26)]);
var state_74363__$1 = state_74363;
var statearr_74446_74523 = state_74363__$1;
(statearr_74446_74523[(2)] = inst_74279);

(statearr_74446_74523[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (8))){
var inst_74189 = (state_74363[(7)]);
var state_74363__$1 = state_74363;
var statearr_74447_74524 = state_74363__$1;
(statearr_74447_74524[(2)] = inst_74189);

(statearr_74447_74524[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74364 === (49))){
var state_74363__$1 = state_74363;
var statearr_74448_74525 = state_74363__$1;
(statearr_74448_74525[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74450[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74450[(1)] = (1));

return statearr_74450;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74363){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74363);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74451){var ex__2730__auto__ = e74451;
var statearr_74452_74526 = state_74363;
(statearr_74452_74526[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74363[(4)]))){
var statearr_74453_74527 = state_74363;
(statearr_74453_74527[(1)] = cljs.core.first((state_74363[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74528 = state_74363;
state_74363 = G__74528;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74363){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74454 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74454[(6)] = c__2749__auto__);

return statearr_74454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__74536 = arguments.length;
switch (G__74536) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__74529_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__74529_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74625){
var state_val_74626 = (state_74625[(1)]);
if((state_val_74626 === (7))){
var inst_74576 = (state_74625[(7)]);
var inst_74579 = (state_74625[(8)]);
var inst_74582 = (state_74625[(9)]);
var inst_74586 = (state_74625[(10)]);
var inst_74592 = (function (){var responses = inst_74576;
var responses_STAR_ = inst_74579;
var statuses = inst_74582;
var fuel = inst_74586;
return (function (p1__74532_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__74532_SHARP_);
});
})();
var inst_74593 = cljs.core.some(inst_74592,inst_74582);
var state_74625__$1 = state_74625;
if(cljs.core.truth_(inst_74593)){
var statearr_74627_74675 = state_74625__$1;
(statearr_74627_74675[(1)] = (9));

} else {
var statearr_74628_74676 = state_74625__$1;
(statearr_74628_74676[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (20))){
var inst_74620 = (state_74625[(2)]);
var state_74625__$1 = state_74625;
var statearr_74629_74677 = state_74625__$1;
(statearr_74629_74677[(2)] = inst_74620);

(statearr_74629_74677[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (1))){
var inst_74571 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74572 = (function (){var c__2749__auto____$1 = inst_74571;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74569){
var state_val_74570 = (state_74569[(1)]);
if((state_val_74570 === (1))){
var inst_74537 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_74538 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_74539 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74538,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_74540 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_74541 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_74542 = cljs.core.PersistentHashMap.EMPTY;
var inst_74543 = inst_74537;
var inst_74544 = inst_74539;
var inst_74545 = inst_74540;
var inst_74546 = inst_74541;
var inst_74547 = inst_74542;
var state_74569__$1 = (function (){var statearr_74630 = state_74569;
(statearr_74630[(7)] = inst_74543);

(statearr_74630[(8)] = inst_74545);

(statearr_74630[(9)] = inst_74544);

(statearr_74630[(10)] = inst_74546);

(statearr_74630[(11)] = inst_74547);

return statearr_74630;
})();
var statearr_74631_74678 = state_74569__$1;
(statearr_74631_74678[(2)] = null);

(statearr_74631_74678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74570 === (2))){
var inst_74544 = (state_74569[(9)]);
var inst_74549 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_74544);
var inst_74550 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_74549], 0));
var inst_74551 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74544,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74550);
var inst_74552 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_74551,db_fn);
var state_74569__$1 = state_74569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74569__$1,(4),inst_74552);
} else {
if((state_val_74570 === (3))){
var inst_74567 = (state_74569[(2)]);
var state_74569__$1 = state_74569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74569__$1,inst_74567);
} else {
if((state_val_74570 === (4))){
var inst_74543 = (state_74569[(7)]);
var inst_74545 = (state_74569[(8)]);
var inst_74547 = (state_74569[(11)]);
var inst_74554 = (state_74569[(2)]);
var inst_74555 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74547,inst_74543,inst_74554);
var inst_74556 = cljs.core.first(inst_74545);
var state_74569__$1 = (function (){var statearr_74632 = state_74569;
(statearr_74632[(12)] = inst_74555);

return statearr_74632;
})();
if(cljs.core.truth_(inst_74556)){
var statearr_74633_74679 = state_74569__$1;
(statearr_74633_74679[(1)] = (5));

} else {
var statearr_74634_74680 = state_74569__$1;
(statearr_74634_74680[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74570 === (5))){
var inst_74545 = (state_74569[(8)]);
var inst_74555 = (state_74569[(12)]);
var inst_74546 = (state_74569[(10)]);
var inst_74558 = cljs.core.first(inst_74545);
var inst_74559 = cljs.core.first(inst_74546);
var inst_74560 = cljs.core.rest(inst_74545);
var inst_74561 = cljs.core.rest(inst_74546);
var inst_74543 = inst_74558;
var inst_74544 = inst_74559;
var inst_74545__$1 = inst_74560;
var inst_74546__$1 = inst_74561;
var inst_74547 = inst_74555;
var state_74569__$1 = (function (){var statearr_74635 = state_74569;
(statearr_74635[(7)] = inst_74543);

(statearr_74635[(8)] = inst_74545__$1);

(statearr_74635[(9)] = inst_74544);

(statearr_74635[(10)] = inst_74546__$1);

(statearr_74635[(11)] = inst_74547);

return statearr_74635;
})();
var statearr_74636_74681 = state_74569__$1;
(statearr_74636_74681[(2)] = null);

(statearr_74636_74681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74570 === (6))){
var inst_74555 = (state_74569[(12)]);
var state_74569__$1 = state_74569;
var statearr_74637_74682 = state_74569__$1;
(statearr_74637_74682[(2)] = inst_74555);

(statearr_74637_74682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74570 === (7))){
var inst_74565 = (state_74569[(2)]);
var state_74569__$1 = state_74569;
var statearr_74638_74683 = state_74569__$1;
(statearr_74638_74683[(2)] = inst_74565);

(statearr_74638_74683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74639 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74639[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74639[(1)] = (1));

return statearr_74639;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74569){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74569);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74640){var ex__2730__auto__ = e74640;
var statearr_74641_74684 = state_74569;
(statearr_74641_74684[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74569[(4)]))){
var statearr_74642_74685 = state_74569;
(statearr_74642_74685[(1)] = cljs.core.first((state_74569[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74686 = state_74569;
state_74569 = G__74686;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74569){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74643 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74643[(6)] = c__2749__auto____$1);

return statearr_74643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_74573 = cljs.core.async.impl.dispatch.run(inst_74572);
var state_74625__$1 = (function (){var statearr_74644 = state_74625;
(statearr_74644[(11)] = inst_74573);

return statearr_74644;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74625__$1,(2),inst_74571);
} else {
if((state_val_74626 === (4))){
var inst_74576 = (state_74625[(7)]);
var state_74625__$1 = state_74625;
var statearr_74645_74687 = state_74625__$1;
(statearr_74645_74687[(2)] = inst_74576);

(statearr_74645_74687[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (15))){
var state_74625__$1 = state_74625;
var statearr_74646_74688 = state_74625__$1;
(statearr_74646_74688[(2)] = (400));

(statearr_74646_74688[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (13))){
var state_74625__$1 = state_74625;
var statearr_74647_74689 = state_74625__$1;
(statearr_74647_74689[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (6))){
var inst_74582 = (state_74625[(9)]);
var inst_74590 = cljs.core.first(inst_74582);
var state_74625__$1 = state_74625;
var statearr_74649_74690 = state_74625__$1;
(statearr_74649_74690[(2)] = inst_74590);

(statearr_74649_74690[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (17))){
var inst_74603 = (state_74625[(2)]);
var state_74625__$1 = state_74625;
var statearr_74650_74691 = state_74625__$1;
(statearr_74650_74691[(2)] = inst_74603);

(statearr_74650_74691[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (3))){
var inst_74576 = (state_74625[(7)]);
var inst_74579 = (state_74625[(8)]);
var inst_74582 = (state_74625[(9)]);
var inst_74586 = (state_74625[(10)]);
var inst_74581 = cljs.core.vals(inst_74576);
var inst_74582__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_74581);
var inst_74583 = (function (){var responses = inst_74576;
var responses_STAR_ = inst_74579;
var statuses = inst_74582__$1;
return (function (p1__74530_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__74530_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_74584 = cljs.core.vals(inst_74576);
var inst_74585 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_74583,inst_74584);
var inst_74586__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_74585);
var inst_74587 = (function (){var responses = inst_74576;
var responses_STAR_ = inst_74579;
var statuses = inst_74582__$1;
var fuel = inst_74586__$1;
return (function (p1__74531_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__74531_SHARP_);
});
})();
var inst_74588 = cljs.core.every_QMARK_(inst_74587,inst_74582__$1);
var state_74625__$1 = (function (){var statearr_74651 = state_74625;
(statearr_74651[(9)] = inst_74582__$1);

(statearr_74651[(10)] = inst_74586__$1);

return statearr_74651;
})();
if(inst_74588){
var statearr_74652_74692 = state_74625__$1;
(statearr_74652_74692[(1)] = (6));

} else {
var statearr_74653_74693 = state_74625__$1;
(statearr_74653_74693[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (12))){
var state_74625__$1 = state_74625;
var statearr_74654_74694 = state_74625__$1;
(statearr_74654_74694[(2)] = (500));

(statearr_74654_74694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (2))){
var inst_74576 = (state_74625[(7)]);
var inst_74575 = (state_74625[(2)]);
var inst_74576__$1 = fluree.db.util.async.throw_err(inst_74575);
var inst_74577 = (function (){var responses = inst_74576__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_74578 = cljs.core.PersistentHashMap.EMPTY;
var inst_74579 = cljs.core.reduce_kv(inst_74577,inst_74578,inst_74576__$1);
var state_74625__$1 = (function (){var statearr_74655 = state_74625;
(statearr_74655[(7)] = inst_74576__$1);

(statearr_74655[(8)] = inst_74579);

return statearr_74655;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_74656_74695 = state_74625__$1;
(statearr_74656_74695[(1)] = (3));

} else {
var statearr_74657_74696 = state_74625__$1;
(statearr_74657_74696[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (19))){
var inst_74609 = (state_74625[(12)]);
var inst_74579 = (state_74625[(8)]);
var inst_74586 = (state_74625[(10)]);
var inst_74618 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74579,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74609,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74586], 0));
var state_74625__$1 = state_74625;
var statearr_74658_74697 = state_74625__$1;
(statearr_74658_74697[(2)] = inst_74618);

(statearr_74658_74697[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (11))){
var inst_74607 = (state_74625[(2)]);
var state_74625__$1 = state_74625;
var statearr_74659_74698 = state_74625__$1;
(statearr_74659_74698[(2)] = inst_74607);

(statearr_74659_74698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (9))){
var state_74625__$1 = state_74625;
var statearr_74660_74699 = state_74625__$1;
(statearr_74660_74699[(2)] = (207));

(statearr_74660_74699[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (5))){
var inst_74623 = (state_74625[(2)]);
var state_74625__$1 = state_74625;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74625__$1,inst_74623);
} else {
if((state_val_74626 === (14))){
var inst_74605 = (state_74625[(2)]);
var state_74625__$1 = state_74625;
var statearr_74661_74700 = state_74625__$1;
(statearr_74661_74700[(2)] = inst_74605);

(statearr_74661_74700[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (16))){
var state_74625__$1 = state_74625;
var statearr_74662_74701 = state_74625__$1;
(statearr_74662_74701[(2)] = null);

(statearr_74662_74701[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (10))){
var inst_74576 = (state_74625[(7)]);
var inst_74579 = (state_74625[(8)]);
var inst_74582 = (state_74625[(9)]);
var inst_74586 = (state_74625[(10)]);
var inst_74596 = (function (){var responses = inst_74576;
var responses_STAR_ = inst_74579;
var statuses = inst_74582;
var fuel = inst_74586;
return (function (p1__74533_SHARP_){
return ((499) < p1__74533_SHARP_);
});
})();
var inst_74597 = cljs.core.some(inst_74596,inst_74582);
var state_74625__$1 = state_74625;
if(cljs.core.truth_(inst_74597)){
var statearr_74663_74702 = state_74625__$1;
(statearr_74663_74702[(1)] = (12));

} else {
var statearr_74664_74703 = state_74625__$1;
(statearr_74664_74703[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (18))){
var inst_74609 = (state_74625[(12)]);
var inst_74579 = (state_74625[(8)]);
var inst_74614 = (state_74625[(13)]);
var inst_74586 = (state_74625[(10)]);
var inst_74616 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74579,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74609,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74586,new cljs.core.Keyword(null,"block","block",664686210),inst_74614], 0));
var state_74625__$1 = state_74625;
var statearr_74665_74704 = state_74625__$1;
(statearr_74665_74704[(2)] = inst_74616);

(statearr_74665_74704[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74626 === (8))){
var inst_74576 = (state_74625[(7)]);
var inst_74609 = (state_74625[(12)]);
var inst_74579 = (state_74625[(8)]);
var inst_74614 = (state_74625[(13)]);
var inst_74582 = (state_74625[(9)]);
var inst_74586 = (state_74625[(10)]);
var inst_74609__$1 = (state_74625[(2)]);
var inst_74610 = (function (){var responses = inst_74576;
var responses_STAR_ = inst_74579;
var statuses = inst_74582;
var fuel = inst_74586;
var status = inst_74609__$1;
return (function (p1__74534_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__74534_SHARP_));
});
})();
var inst_74611 = cljs.core.vals(inst_74576);
var inst_74612 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_74610,inst_74611);
var inst_74613 = cljs.core.first(inst_74612);
var inst_74614__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74613);
var state_74625__$1 = (function (){var statearr_74666 = state_74625;
(statearr_74666[(12)] = inst_74609__$1);

(statearr_74666[(13)] = inst_74614__$1);

return statearr_74666;
})();
if(cljs.core.truth_(inst_74614__$1)){
var statearr_74667_74705 = state_74625__$1;
(statearr_74667_74705[(1)] = (18));

} else {
var statearr_74668_74706 = state_74625__$1;
(statearr_74668_74706[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74669 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74669[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74669[(1)] = (1));

return statearr_74669;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74625){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74625);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74670){var ex__2730__auto__ = e74670;
var statearr_74671_74707 = state_74625;
(statearr_74671_74707[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74625[(4)]))){
var statearr_74672_74708 = state_74625;
(statearr_74672_74708[(1)] = cljs.core.first((state_74625[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74709 = state_74625;
state_74625 = G__74709;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74625){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74673 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74673[(6)] = c__2749__auto__);

return statearr_74673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__74711 = arguments.length;
switch (G__74711) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__74712 = opts;
var map__74712__$1 = cljs.core.__destructure_map(map__74712);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74712__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74712__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74712__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74712__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__74713 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74713,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74713,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e74716){var e = e74716;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__74719 = arguments.length;
switch (G__74719) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74753){
var state_val_74754 = (state_74753[(1)]);
if((state_val_74754 === (7))){
var state_74753__$1 = state_74753;
var statearr_74755_74776 = state_74753__$1;
(statearr_74755_74776[(2)] = opts);

(statearr_74755_74776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74754 === (1))){
var state_74753__$1 = state_74753;
var statearr_74756_74777 = state_74753__$1;
(statearr_74756_74777[(2)] = null);

(statearr_74756_74777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74754 === (4))){
var inst_74720 = (state_74753[(2)]);
var inst_74721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74722 = [inst_74720];
var inst_74723 = (new cljs.core.PersistentVector(null,1,(5),inst_74721,inst_74722,null));
var inst_74724 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74723);
var inst_74725 = cljs.core.ex_data(inst_74720);
var inst_74726 = cljs.core.ex_message(inst_74720);
var inst_74727 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74725,new cljs.core.Keyword(null,"message","message",-406056002),inst_74726);
var state_74753__$1 = (function (){var statearr_74757 = state_74753;
(statearr_74757[(7)] = inst_74724);

return statearr_74757;
})();
var statearr_74758_74778 = state_74753__$1;
(statearr_74758_74778[(2)] = inst_74727);

(statearr_74758_74778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74754 === (6))){
var inst_74737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74738 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_74739 = (new cljs.core.PersistentVector(null,1,(5),inst_74737,inst_74738,null));
var inst_74740 = cljs.core.assoc_in(opts,inst_74739,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74753__$1 = state_74753;
var statearr_74759_74779 = state_74753__$1;
(statearr_74759_74779[(2)] = inst_74740);

(statearr_74759_74779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74754 === (3))){
var inst_74751 = (state_74753[(2)]);
var state_74753__$1 = state_74753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74753__$1,inst_74751);
} else {
if((state_val_74754 === (2))){
var _ = (function (){var statearr_74761 = state_74753;
(statearr_74761[(4)] = cljs.core.cons((5),(state_74753[(4)])));

return statearr_74761;
})();
var inst_74733 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74734 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74735 = (inst_74734 == null);
var state_74753__$1 = (function (){var statearr_74762 = state_74753;
(statearr_74762[(8)] = inst_74733);

return statearr_74762;
})();
if(cljs.core.truth_(inst_74735)){
var statearr_74763_74780 = state_74753__$1;
(statearr_74763_74780[(1)] = (6));

} else {
var statearr_74764_74781 = state_74753__$1;
(statearr_74764_74781[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74754 === (9))){
var inst_74747 = (state_74753[(2)]);
var inst_74748 = fluree.db.util.async.throw_err(inst_74747);
var _ = (function (){var statearr_74765 = state_74753;
(statearr_74765[(4)] = cljs.core.rest((state_74753[(4)])));

return statearr_74765;
})();
var state_74753__$1 = state_74753;
var statearr_74766_74782 = state_74753__$1;
(statearr_74766_74782[(2)] = inst_74748);

(statearr_74766_74782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74754 === (5))){
var _ = (function (){var statearr_74767 = state_74753;
(statearr_74767[(4)] = cljs.core.rest((state_74753[(4)])));

return statearr_74767;
})();
var state_74753__$1 = state_74753;
var ex74760 = (state_74753__$1[(2)]);
var statearr_74768_74783 = state_74753__$1;
(statearr_74768_74783[(5)] = ex74760);


var statearr_74769_74784 = state_74753__$1;
(statearr_74769_74784[(1)] = (4));

(statearr_74769_74784[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74754 === (8))){
var inst_74733 = (state_74753[(8)]);
var inst_74743 = (state_74753[(2)]);
var inst_74744 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_74733,inst_74743);
var inst_74745 = fluree.db.operations.command_async(conn,inst_74744);
var state_74753__$1 = state_74753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74753__$1,(9),inst_74745);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74770 = [null,null,null,null,null,null,null,null,null];
(statearr_74770[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74770[(1)] = (1));

return statearr_74770;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74753){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74753);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74771){var ex__2730__auto__ = e74771;
var statearr_74772_74785 = state_74753;
(statearr_74772_74785[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74753[(4)]))){
var statearr_74773_74786 = state_74753;
(statearr_74773_74786[(1)] = cljs.core.first((state_74753[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74787 = state_74753;
state_74753 = G__74787;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74753){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74774 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74774[(6)] = c__2749__auto__);

return statearr_74774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

