// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__71100_71281 = cljs.core.seq(servers);
var chunk__71101_71282 = null;
var count__71102_71283 = (0);
var i__71103_71284 = (0);
while(true){
if((i__71103_71284 < count__71102_71283)){
var server_71285 = chunk__71101_71282.cljs$core$IIndexed$_nth$arity$2(null,i__71103_71284);
var healthcheck_uri_71286 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71285),"/fdb/health"].join('');
var resp_chan_71287 = fluree.db.util.xhttp.post_json(healthcheck_uri_71286,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___71288 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71288,healthcheck_uri_71286,resp_chan_71287,server_71285){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71288,healthcheck_uri_71286,resp_chan_71287,server_71285){
return (function (state_71173){
var state_val_71174 = (state_71173[(1)]);
if((state_val_71174 === (1))){
var state_71173__$1 = state_71173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71173__$1,(2),resp_chan_71287);
} else {
if((state_val_71174 === (2))){
var inst_71159 = (state_71173[(7)]);
var inst_71159__$1 = (state_71173[(2)]);
var inst_71160 = fluree.db.util.core.exception_QMARK_(inst_71159__$1);
var state_71173__$1 = (function (){var statearr_71175 = state_71173;
(statearr_71175[(7)] = inst_71159__$1);

return statearr_71175;
})();
if(inst_71160){
var statearr_71176_71289 = state_71173__$1;
(statearr_71176_71289[(1)] = (3));

} else {
var statearr_71177_71290 = state_71173__$1;
(statearr_71177_71290[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71174 === (3))){
var inst_71159 = (state_71173[(7)]);
var inst_71162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71163 = cljs.core.ex_message(inst_71159);
var inst_71164 = cljs.core.ex_data(inst_71159);
var inst_71165 = ["Server contact error: ",inst_71163,inst_71164];
var inst_71166 = (new cljs.core.PersistentVector(null,3,(5),inst_71162,inst_71165,null));
var inst_71167 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71166);
var state_71173__$1 = state_71173;
var statearr_71178_71291 = state_71173__$1;
(statearr_71178_71291[(2)] = inst_71167);

(statearr_71178_71291[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71174 === (4))){
var inst_71169 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_71285);
var state_71173__$1 = state_71173;
var statearr_71179_71292 = state_71173__$1;
(statearr_71179_71292[(2)] = inst_71169);

(statearr_71179_71292[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71174 === (5))){
var inst_71171 = (state_71173[(2)]);
var state_71173__$1 = state_71173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71173__$1,inst_71171);
} else {
return null;
}
}
}
}
}
});})(seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71288,healthcheck_uri_71286,resp_chan_71287,server_71285))
;
return ((function (seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,switch__2726__auto__,c__2749__auto___71288,healthcheck_uri_71286,resp_chan_71287,server_71285){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71180 = [null,null,null,null,null,null,null,null];
(statearr_71180[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71180[(1)] = (1));

return statearr_71180;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71173){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71173);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71181){var ex__2730__auto__ = e71181;
var statearr_71182_71293 = state_71173;
(statearr_71182_71293[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71173[(4)]))){
var statearr_71183_71294 = state_71173;
(statearr_71183_71294[(1)] = cljs.core.first((state_71173[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71295 = state_71173;
state_71173 = G__71295;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71173){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,switch__2726__auto__,c__2749__auto___71288,healthcheck_uri_71286,resp_chan_71287,server_71285))
})();
var state__2751__auto__ = (function (){var statearr_71184 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71184[(6)] = c__2749__auto___71288);

return statearr_71184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71288,healthcheck_uri_71286,resp_chan_71287,server_71285))
);



var G__71296 = seq__71100_71281;
var G__71297 = chunk__71101_71282;
var G__71298 = count__71102_71283;
var G__71299 = (i__71103_71284 + (1));
seq__71100_71281 = G__71296;
chunk__71101_71282 = G__71297;
count__71102_71283 = G__71298;
i__71103_71284 = G__71299;
continue;
} else {
var temp__5804__auto___71300 = cljs.core.seq(seq__71100_71281);
if(temp__5804__auto___71300){
var seq__71100_71301__$1 = temp__5804__auto___71300;
if(cljs.core.chunked_seq_QMARK_(seq__71100_71301__$1)){
var c__4679__auto___71302 = cljs.core.chunk_first(seq__71100_71301__$1);
var G__71303 = cljs.core.chunk_rest(seq__71100_71301__$1);
var G__71304 = c__4679__auto___71302;
var G__71305 = cljs.core.count(c__4679__auto___71302);
var G__71306 = (0);
seq__71100_71281 = G__71303;
chunk__71101_71282 = G__71304;
count__71102_71283 = G__71305;
i__71103_71284 = G__71306;
continue;
} else {
var server_71307 = cljs.core.first(seq__71100_71301__$1);
var healthcheck_uri_71308 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71307),"/fdb/health"].join('');
var resp_chan_71309 = fluree.db.util.xhttp.post_json(healthcheck_uri_71308,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___71310 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71310,healthcheck_uri_71308,resp_chan_71309,server_71307,seq__71100_71301__$1,temp__5804__auto___71300){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71310,healthcheck_uri_71308,resp_chan_71309,server_71307,seq__71100_71301__$1,temp__5804__auto___71300){
return (function (state_71200){
var state_val_71201 = (state_71200[(1)]);
if((state_val_71201 === (1))){
var state_71200__$1 = state_71200;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71200__$1,(2),resp_chan_71309);
} else {
if((state_val_71201 === (2))){
var inst_71186 = (state_71200[(7)]);
var inst_71186__$1 = (state_71200[(2)]);
var inst_71187 = fluree.db.util.core.exception_QMARK_(inst_71186__$1);
var state_71200__$1 = (function (){var statearr_71202 = state_71200;
(statearr_71202[(7)] = inst_71186__$1);

return statearr_71202;
})();
if(inst_71187){
var statearr_71203_71311 = state_71200__$1;
(statearr_71203_71311[(1)] = (3));

} else {
var statearr_71204_71312 = state_71200__$1;
(statearr_71204_71312[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71201 === (3))){
var inst_71186 = (state_71200[(7)]);
var inst_71189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71190 = cljs.core.ex_message(inst_71186);
var inst_71191 = cljs.core.ex_data(inst_71186);
var inst_71192 = ["Server contact error: ",inst_71190,inst_71191];
var inst_71193 = (new cljs.core.PersistentVector(null,3,(5),inst_71189,inst_71192,null));
var inst_71194 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71193);
var state_71200__$1 = state_71200;
var statearr_71205_71313 = state_71200__$1;
(statearr_71205_71313[(2)] = inst_71194);

(statearr_71205_71313[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71201 === (4))){
var inst_71196 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_71307);
var state_71200__$1 = state_71200;
var statearr_71206_71314 = state_71200__$1;
(statearr_71206_71314[(2)] = inst_71196);

(statearr_71206_71314[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71201 === (5))){
var inst_71198 = (state_71200[(2)]);
var state_71200__$1 = state_71200;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71200__$1,inst_71198);
} else {
return null;
}
}
}
}
}
});})(seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71310,healthcheck_uri_71308,resp_chan_71309,server_71307,seq__71100_71301__$1,temp__5804__auto___71300))
;
return ((function (seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,switch__2726__auto__,c__2749__auto___71310,healthcheck_uri_71308,resp_chan_71309,server_71307,seq__71100_71301__$1,temp__5804__auto___71300){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71207 = [null,null,null,null,null,null,null,null];
(statearr_71207[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71207[(1)] = (1));

return statearr_71207;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71200){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71200);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71208){var ex__2730__auto__ = e71208;
var statearr_71209_71315 = state_71200;
(statearr_71209_71315[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71200[(4)]))){
var statearr_71210_71316 = state_71200;
(statearr_71210_71316[(1)] = cljs.core.first((state_71200[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71317 = state_71200;
state_71200 = G__71317;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71200){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,switch__2726__auto__,c__2749__auto___71310,healthcheck_uri_71308,resp_chan_71309,server_71307,seq__71100_71301__$1,temp__5804__auto___71300))
})();
var state__2751__auto__ = (function (){var statearr_71211 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71211[(6)] = c__2749__auto___71310);

return statearr_71211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__71100_71281,chunk__71101_71282,count__71102_71283,i__71103_71284,c__2749__auto___71310,healthcheck_uri_71308,resp_chan_71309,server_71307,seq__71100_71301__$1,temp__5804__auto___71300))
);



var G__71318 = cljs.core.next(seq__71100_71301__$1);
var G__71319 = null;
var G__71320 = (0);
var G__71321 = (0);
seq__71100_71281 = G__71318;
chunk__71101_71282 = G__71319;
count__71102_71283 = G__71320;
i__71103_71284 = G__71321;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71255){
var state_val_71256 = (state_71255[(1)]);
if((state_val_71256 === (7))){
var inst_71227 = (state_71255[(7)]);
var inst_71234 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71227,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_71255__$1 = state_71255;
if(inst_71234){
var statearr_71257_71322 = state_71255__$1;
(statearr_71257_71322[(1)] = (9));

} else {
var statearr_71258_71323 = state_71255__$1;
(statearr_71258_71323[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (1))){
var inst_71220 = (state_71255[(8)]);
var inst_71219 = (state_71255[(9)]);
var inst_71219__$1 = promise_chan;
var inst_71220__$1 = cljs.core.async.timeout((60000));
var inst_71221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71222 = [inst_71219__$1,inst_71220__$1];
var inst_71223 = (new cljs.core.PersistentVector(null,2,(5),inst_71221,inst_71222,null));
var state_71255__$1 = (function (){var statearr_71259 = state_71255;
(statearr_71259[(8)] = inst_71220__$1);

(statearr_71259[(9)] = inst_71219__$1);

return statearr_71259;
})();
return cljs.core.async.ioc_alts_BANG_(state_71255__$1,(2),inst_71223);
} else {
if((state_val_71256 === (4))){
var inst_71220 = (state_71255[(8)]);
var inst_71227 = (state_71255[(7)]);
var inst_71231 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71227,inst_71220);
var state_71255__$1 = state_71255;
if(inst_71231){
var statearr_71260_71324 = state_71255__$1;
(statearr_71260_71324[(1)] = (6));

} else {
var statearr_71261_71325 = state_71255__$1;
(statearr_71261_71325[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (13))){
var state_71255__$1 = state_71255;
var statearr_71262_71326 = state_71255__$1;
(statearr_71262_71326[(2)] = null);

(statearr_71262_71326[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (6))){
var state_71255__$1 = state_71255;
var statearr_71263_71327 = state_71255__$1;
(statearr_71263_71327[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_71263_71327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (3))){
var state_71255__$1 = state_71255;
var statearr_71264_71328 = state_71255__$1;
(statearr_71264_71328[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_71264_71328[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (12))){
var inst_71245 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_71246 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71247 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_71248 = cljs.core.PersistentHashMap.fromArrays(inst_71246,inst_71247);
var inst_71249 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_71248);
var inst_71250 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_71249);
var state_71255__$1 = (function (){var statearr_71265 = state_71255;
(statearr_71265[(10)] = inst_71245);

return statearr_71265;
})();
var statearr_71266_71329 = state_71255__$1;
(statearr_71266_71329[(2)] = inst_71250);

(statearr_71266_71329[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (2))){
var inst_71227 = (state_71255[(7)]);
var inst_71219 = (state_71255[(9)]);
var inst_71225 = (state_71255[(2)]);
var inst_71226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71225,(0),null);
var inst_71227__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71225,(1),null);
var inst_71228 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71227__$1,inst_71219);
var state_71255__$1 = (function (){var statearr_71267 = state_71255;
(statearr_71267[(11)] = inst_71226);

(statearr_71267[(7)] = inst_71227__$1);

return statearr_71267;
})();
if(inst_71228){
var statearr_71268_71330 = state_71255__$1;
(statearr_71268_71330[(1)] = (3));

} else {
var statearr_71269_71331 = state_71255__$1;
(statearr_71269_71331[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (11))){
var inst_71238 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
var statearr_71270_71332 = state_71255__$1;
(statearr_71270_71332[(2)] = inst_71238);

(statearr_71270_71332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (9))){
var inst_71226 = (state_71255[(11)]);
var state_71255__$1 = state_71255;
var statearr_71271_71333 = state_71255__$1;
(statearr_71271_71333[(2)] = inst_71226);

(statearr_71271_71333[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (5))){
var inst_71242 = (state_71255[(2)]);
var inst_71243 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_71242);
var state_71255__$1 = state_71255;
if(inst_71243){
var statearr_71272_71334 = state_71255__$1;
(statearr_71272_71334[(1)] = (12));

} else {
var statearr_71273_71335 = state_71255__$1;
(statearr_71273_71335[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (14))){
var inst_71253 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71255__$1,inst_71253);
} else {
if((state_val_71256 === (10))){
var state_71255__$1 = state_71255;
var statearr_71274_71336 = state_71255__$1;
(statearr_71274_71336[(2)] = null);

(statearr_71274_71336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71256 === (8))){
var inst_71240 = (state_71255[(2)]);
var state_71255__$1 = state_71255;
var statearr_71275_71337 = state_71255__$1;
(statearr_71275_71337[(2)] = inst_71240);

(statearr_71275_71337[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71276 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71276[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71276[(1)] = (1));

return statearr_71276;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71255){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71255);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71277){var ex__2730__auto__ = e71277;
var statearr_71278_71338 = state_71255;
(statearr_71278_71338[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71255[(4)]))){
var statearr_71279_71339 = state_71255;
(statearr_71279_71339[(1)] = cljs.core.first((state_71255[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71340 = state_71255;
state_71255 = G__71340;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71255){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71280 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71280[(6)] = c__2749__auto__);

return statearr_71280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71384){
var state_val_71385 = (state_71384[(1)]);
if((state_val_71385 === (7))){
var state_71384__$1 = state_71384;
var statearr_71386_71412 = state_71384__$1;
(statearr_71386_71412[(2)] = null);

(statearr_71386_71412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (1))){
var state_71384__$1 = state_71384;
var statearr_71387_71413 = state_71384__$1;
(statearr_71387_71413[(2)] = null);

(statearr_71387_71413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (4))){
var inst_71341 = (state_71384[(2)]);
var state_71384__$1 = state_71384;
var statearr_71388_71414 = state_71384__$1;
(statearr_71388_71414[(2)] = inst_71341);

(statearr_71388_71414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (6))){
var inst_71363 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_71384__$1 = state_71384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71384__$1,(9),inst_71363);
} else {
if((state_val_71385 === (3))){
var inst_71382 = (state_71384[(2)]);
var state_71384__$1 = state_71384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71384__$1,inst_71382);
} else {
if((state_val_71385 === (12))){
var inst_71376 = (state_71384[(2)]);
var state_71384__$1 = state_71384;
var statearr_71389_71415 = state_71384__$1;
(statearr_71389_71415[(2)] = inst_71376);

(statearr_71389_71415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (2))){
var inst_71347 = (state_71384[(7)]);
var inst_71357 = (state_71384[(8)]);
var inst_71352 = (state_71384[(9)]);
var _ = (function (){var statearr_71390 = state_71384;
(statearr_71390[(4)] = cljs.core.cons((5),(state_71384[(4)])));

return statearr_71390;
})();
var inst_71347__$1 = cljs.core.random_uuid();
var inst_71348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71349 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_71350 = (new cljs.core.PersistentVector(null,2,(5),inst_71348,inst_71349,null));
var inst_71351 = (function (){var lock_id = inst_71347__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_71352__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_71350,inst_71351);
var inst_71353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71354 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_71355 = (new cljs.core.PersistentVector(null,3,(5),inst_71353,inst_71354,null));
var inst_71356 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71352__$1,inst_71355);
var inst_71357__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71347__$1,inst_71356);
var inst_71358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71359 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71360 = (new cljs.core.PersistentVector(null,3,(5),inst_71358,inst_71359,null));
var inst_71361 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71352__$1,inst_71360);
var state_71384__$1 = (function (){var statearr_71391 = state_71384;
(statearr_71391[(7)] = inst_71347__$1);

(statearr_71391[(8)] = inst_71357__$1);

(statearr_71391[(9)] = inst_71352__$1);

(statearr_71391[(10)] = inst_71361);

return statearr_71391;
})();
if(inst_71357__$1){
var statearr_71392_71416 = state_71384__$1;
(statearr_71392_71416[(1)] = (6));

} else {
var statearr_71393_71417 = state_71384__$1;
(statearr_71393_71417[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (11))){
var inst_71367 = (state_71384[(11)]);
var inst_71368 = (state_71384[(12)]);
var inst_71361 = (state_71384[(10)]);
var inst_71374 = fluree.db.util.xhttp.try_socket(inst_71367,sub_chan,pub_chan,inst_71361,(60000),inst_71368);
var state_71384__$1 = state_71384;
var statearr_71395_71418 = state_71384__$1;
(statearr_71395_71418[(2)] = inst_71374);

(statearr_71395_71418[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (9))){
var inst_71347 = (state_71384[(7)]);
var inst_71365 = (state_71384[(13)]);
var inst_71367 = (state_71384[(11)]);
var inst_71357 = (state_71384[(8)]);
var inst_71352 = (state_71384[(9)]);
var inst_71361 = (state_71384[(10)]);
var inst_71365__$1 = (state_71384[(2)]);
var inst_71366 = clojure.string.replace(inst_71365__$1,"http","ws");
var inst_71367__$1 = [inst_71366,"/fdb/ws"].join('');
var inst_71368 = (function (){var lock_id = inst_71347;
var state = inst_71352;
var have_lock_QMARK_ = inst_71357;
var resp_chan = inst_71361;
var healthy_server = inst_71365__$1;
var ws_url = inst_71367__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_71369 = fluree.db.util.core.exception_QMARK_(inst_71365__$1);
var state_71384__$1 = (function (){var statearr_71396 = state_71384;
(statearr_71396[(13)] = inst_71365__$1);

(statearr_71396[(11)] = inst_71367__$1);

(statearr_71396[(12)] = inst_71368);

return statearr_71396;
})();
if(inst_71369){
var statearr_71397_71419 = state_71384__$1;
(statearr_71397_71419[(1)] = (10));

} else {
var statearr_71398_71420 = state_71384__$1;
(statearr_71398_71420[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (5))){
var _ = (function (){var statearr_71399 = state_71384;
(statearr_71399[(4)] = cljs.core.rest((state_71384[(4)])));

return statearr_71399;
})();
var state_71384__$1 = state_71384;
var ex71394 = (state_71384__$1[(2)]);
var statearr_71400_71421 = state_71384__$1;
(statearr_71400_71421[(5)] = ex71394);


if((ex71394 instanceof Error)){
var statearr_71401_71422 = state_71384__$1;
(statearr_71401_71422[(1)] = (4));

(statearr_71401_71422[(5)] = null);

} else {
throw ex71394;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (10))){
var inst_71365 = (state_71384[(13)]);
var inst_71361 = (state_71384[(10)]);
var inst_71371 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_71372 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_71361,inst_71365);
var state_71384__$1 = (function (){var statearr_71402 = state_71384;
(statearr_71402[(14)] = inst_71371);

return statearr_71402;
})();
var statearr_71403_71423 = state_71384__$1;
(statearr_71403_71423[(2)] = inst_71372);

(statearr_71403_71423[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71385 === (8))){
var inst_71361 = (state_71384[(10)]);
var inst_71379 = (state_71384[(2)]);
var _ = (function (){var statearr_71404 = state_71384;
(statearr_71404[(4)] = cljs.core.rest((state_71384[(4)])));

return statearr_71404;
})();
var state_71384__$1 = (function (){var statearr_71405 = state_71384;
(statearr_71405[(15)] = inst_71379);

return statearr_71405;
})();
var statearr_71406_71424 = state_71384__$1;
(statearr_71406_71424[(2)] = inst_71361);

(statearr_71406_71424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_71407 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71407[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_71407[(1)] = (1));

return statearr_71407;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_71384){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71384);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71408){var ex__2730__auto__ = e71408;
var statearr_71409_71425 = state_71384;
(statearr_71409_71425[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71384[(4)]))){
var statearr_71410_71426 = state_71384;
(statearr_71410_71426[(1)] = cljs.core.first((state_71384[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71427 = state_71384;
state_71384 = G__71427;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_71384){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_71384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71411 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71411[(6)] = c__2749__auto__);

return statearr_71411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k71429,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__71433 = k71429;
var G__71433__$1 = (((G__71433 instanceof cljs.core.Keyword))?G__71433.fqn:null);
switch (G__71433__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k71429,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__71434){
var vec__71435 = p__71434;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71435,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71435,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71428){
var self__ = this;
var G__71428__$1 = this;
return (new cljs.core.RecordIter((0),G__71428__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__71438 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__71438(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71430,other71431){
var self__ = this;
var this71430__$1 = this;
return (((!((other71431 == null)))) && ((((this71430__$1.constructor === other71431.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.id,other71431.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.servers,other71431.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.state,other71431.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.req_chan,other71431.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.sub_chan,other71431.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.pub_chan,other71431.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.group,other71431.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.storage_read,other71431.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.storage_list,other71431.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.storage_write,other71431.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.storage_exists,other71431.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.storage_rename,other71431.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.storage_delete,other71431.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.object_cache,other71431.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.async_cache,other71431.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.parallelism,other71431.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.serializer,other71431.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.default_network,other71431.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.transactor_QMARK_,other71431.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.publish,other71431.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.transact_handler,other71431.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.tx_private_key,other71431.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.tx_key_id,other71431.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.meta,other71431.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.add_listener,other71431.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.remove_listener,other71431.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.close,other71431.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71430__$1.__extmap,other71431.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__71439){
var self__ = this;
var map__71440 = p__71439;
var map__71440__$1 = cljs.core.__destructure_map(map__71440);
var node = map__71440__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71440__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71440__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71440__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__71441 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__71442 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__71443 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__71444 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__71443,G__71444) : self__.async_cache.call(null,G__71443,G__71444));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__71441,G__71442) : self__.async_cache.call(null,G__71441,G__71442));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k71429){
var self__ = this;
var this__4509__auto____$1 = this;
var G__71445 = k71429;
var G__71445__$1 = (((G__71445 instanceof cljs.core.Keyword))?G__71445.fqn:null);
switch (G__71445__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k71429);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__71428){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__71446 = cljs.core.keyword_identical_QMARK_;
var expr__71447 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__71449 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__71450 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71449,G__71450) : pred__71446.call(null,G__71449,G__71450));
})())){
return (new fluree.db.connection.Connection(G__71428,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71451 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__71452 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71451,G__71452) : pred__71446.call(null,G__71451,G__71452));
})())){
return (new fluree.db.connection.Connection(self__.id,G__71428,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71453 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__71454 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71453,G__71454) : pred__71446.call(null,G__71453,G__71454));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__71428,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71455 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__71456 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71455,G__71456) : pred__71446.call(null,G__71455,G__71456));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__71428,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71457 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__71458 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71457,G__71458) : pred__71446.call(null,G__71457,G__71458));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__71428,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71459 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__71460 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71459,G__71460) : pred__71446.call(null,G__71459,G__71460));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__71428,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71461 = new cljs.core.Keyword(null,"group","group",582596132);
var G__71462 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71461,G__71462) : pred__71446.call(null,G__71461,G__71462));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__71428,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71463 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__71464 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71463,G__71464) : pred__71446.call(null,G__71463,G__71464));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__71428,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71465 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__71466 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71465,G__71466) : pred__71446.call(null,G__71465,G__71466));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__71428,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71467 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__71468 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71467,G__71468) : pred__71446.call(null,G__71467,G__71468));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__71428,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71469 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__71470 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71469,G__71470) : pred__71446.call(null,G__71469,G__71470));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__71428,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71471 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__71472 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71471,G__71472) : pred__71446.call(null,G__71471,G__71472));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__71428,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71473 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__71474 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71473,G__71474) : pred__71446.call(null,G__71473,G__71474));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__71428,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71475 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__71476 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71475,G__71476) : pred__71446.call(null,G__71475,G__71476));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__71428,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71477 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__71478 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71477,G__71478) : pred__71446.call(null,G__71477,G__71478));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__71428,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71479 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__71480 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71479,G__71480) : pred__71446.call(null,G__71479,G__71480));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__71428,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71481 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__71482 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71481,G__71482) : pred__71446.call(null,G__71481,G__71482));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__71428,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71483 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__71484 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71483,G__71484) : pred__71446.call(null,G__71483,G__71484));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__71428,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71485 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__71486 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71485,G__71486) : pred__71446.call(null,G__71485,G__71486));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__71428,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71487 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__71488 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71487,G__71488) : pred__71446.call(null,G__71487,G__71488));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__71428,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71489 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__71490 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71489,G__71490) : pred__71446.call(null,G__71489,G__71490));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__71428,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71491 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__71492 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71491,G__71492) : pred__71446.call(null,G__71491,G__71492));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__71428,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71493 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__71494 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71493,G__71494) : pred__71446.call(null,G__71493,G__71494));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__71428,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71495 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__71496 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71495,G__71496) : pred__71446.call(null,G__71495,G__71496));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__71428,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71497 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__71498 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71497,G__71498) : pred__71446.call(null,G__71497,G__71498));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__71428,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71499 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__71500 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71499,G__71500) : pred__71446.call(null,G__71499,G__71500));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__71428,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71501 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__71502 = expr__71447;
return (pred__71446.cljs$core$IFn$_invoke$arity$2 ? pred__71446.cljs$core$IFn$_invoke$arity$2(G__71501,G__71502) : pred__71446.call(null,G__71501,G__71502));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__71428,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__71428),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__71428){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__71428,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__71432){
var extmap__4542__auto__ = (function (){var G__71503 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__71432,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__71432)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__71503);
} else {
return G__71503;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__71432),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__71432),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__71509 = servers_STAR_;
var vec__71510 = G__71509;
var seq__71511 = cljs.core.seq(vec__71510);
var first__71512 = cljs.core.first(seq__71511);
var seq__71511__$1 = cljs.core.next(seq__71511);
var server = first__71512;
var r = seq__71511__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__71509__$1 = G__71509;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__71516 = G__71509__$1;
var seq__71517 = cljs.core.seq(vec__71516);
var first__71518 = cljs.core.first(seq__71517);
var seq__71517__$1 = cljs.core.next(seq__71517);
var server__$1 = first__71518;
var r__$1 = seq__71517__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__71519 = r__$1;
var G__71520 = is_https_QMARK_;
var G__71521 = result_STAR_;
G__71509__$1 = G__71519;
https_QMARK___$1 = G__71520;
result__$1 = G__71521;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__71522 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__71522 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__71522);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71551){
var state_val_71552 = (state_71551[(1)]);
if((state_val_71552 === (7))){
var inst_71537 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71538 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71539 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71540 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71541 = fluree.db.connection.establish_socket(inst_71537,inst_71538,inst_71539,inst_71540);
var state_71551__$1 = state_71551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71551__$1,(9),inst_71541);
} else {
if((state_val_71552 === (1))){
var state_71551__$1 = state_71551;
var statearr_71553_71572 = state_71551__$1;
(statearr_71553_71572[(2)] = null);

(statearr_71553_71572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71552 === (4))){
var inst_71523 = (state_71551[(2)]);
var state_71551__$1 = state_71551;
var statearr_71554_71573 = state_71551__$1;
(statearr_71554_71573[(2)] = inst_71523);

(statearr_71554_71573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71552 === (6))){
var inst_71534 = (state_71551[(7)]);
var state_71551__$1 = state_71551;
var statearr_71555_71574 = state_71551__$1;
(statearr_71555_71574[(2)] = inst_71534);

(statearr_71555_71574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71552 === (3))){
var inst_71549 = (state_71551[(2)]);
var state_71551__$1 = state_71551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71551__$1,inst_71549);
} else {
if((state_val_71552 === (2))){
var inst_71534 = (state_71551[(7)]);
var _ = (function (){var statearr_71557 = state_71551;
(statearr_71557[(4)] = cljs.core.cons((5),(state_71551[(4)])));

return statearr_71557;
})();
var inst_71529 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_71530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71531 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71532 = [inst_71531,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71533 = (new cljs.core.PersistentVector(null,3,(5),inst_71530,inst_71532,null));
var inst_71534__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71529,inst_71533);
var state_71551__$1 = (function (){var statearr_71558 = state_71551;
(statearr_71558[(7)] = inst_71534__$1);

return statearr_71558;
})();
if(cljs.core.truth_(inst_71534__$1)){
var statearr_71559_71575 = state_71551__$1;
(statearr_71559_71575[(1)] = (6));

} else {
var statearr_71560_71576 = state_71551__$1;
(statearr_71560_71576[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71552 === (9))){
var inst_71543 = (state_71551[(2)]);
var inst_71544 = fluree.db.util.async.throw_err(inst_71543);
var state_71551__$1 = state_71551;
var statearr_71561_71577 = state_71551__$1;
(statearr_71561_71577[(2)] = inst_71544);

(statearr_71561_71577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71552 === (5))){
var _ = (function (){var statearr_71562 = state_71551;
(statearr_71562[(4)] = cljs.core.rest((state_71551[(4)])));

return statearr_71562;
})();
var state_71551__$1 = state_71551;
var ex71556 = (state_71551__$1[(2)]);
var statearr_71563_71578 = state_71551__$1;
(statearr_71563_71578[(5)] = ex71556);


if((ex71556 instanceof Error)){
var statearr_71564_71579 = state_71551__$1;
(statearr_71564_71579[(1)] = (4));

(statearr_71564_71579[(5)] = null);

} else {
throw ex71556;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71552 === (8))){
var inst_71546 = (state_71551[(2)]);
var _ = (function (){var statearr_71565 = state_71551;
(statearr_71565[(4)] = cljs.core.rest((state_71551[(4)])));

return statearr_71565;
})();
var state_71551__$1 = state_71551;
var statearr_71566_71580 = state_71551__$1;
(statearr_71566_71580[(2)] = inst_71546);

(statearr_71566_71580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_71567 = [null,null,null,null,null,null,null,null];
(statearr_71567[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_71567[(1)] = (1));

return statearr_71567;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_71551){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71551);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71568){var ex__2730__auto__ = e71568;
var statearr_71569_71581 = state_71551;
(statearr_71569_71581[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71551[(4)]))){
var statearr_71570_71582 = state_71551;
(statearr_71570_71582[(1)] = cljs.core.first((state_71551[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71583 = state_71551;
state_71551 = G__71583;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_71551){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_71551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71571 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71571[(6)] = c__2749__auto__);

return statearr_71571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e71584){var e = e71584;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__71586){
var map__71587 = p__71586;
var map__71587__$1 = cljs.core.__destructure_map(map__71587);
var conn = map__71587__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71587__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71587__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71587__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71733){
var state_val_71734 = (state_71733[(1)]);
if((state_val_71734 === (7))){
var inst_71729 = (state_71733[(2)]);
var state_71733__$1 = state_71733;
var statearr_71736_71810 = state_71733__$1;
(statearr_71736_71810[(2)] = inst_71729);

(statearr_71736_71810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (20))){
var _ = (function (){var statearr_71737 = state_71733;
(statearr_71737[(4)] = cljs.core.rest((state_71733[(4)])));

return statearr_71737;
})();
var state_71733__$1 = state_71733;
var ex71735 = (state_71733__$1[(2)]);
var statearr_71738_71811 = state_71733__$1;
(statearr_71738_71811[(5)] = ex71735);


var statearr_71739_71812 = state_71733__$1;
(statearr_71739_71812[(1)] = (10));

(statearr_71739_71812[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (27))){
var inst_71690 = (state_71733[(7)]);
var inst_71690__$1 = (state_71733[(2)]);
var inst_71691 = inst_71690__$1 === true;
var state_71733__$1 = (function (){var statearr_71740 = state_71733;
(statearr_71740[(7)] = inst_71690__$1);

return statearr_71740;
})();
if(cljs.core.truth_(inst_71691)){
var statearr_71741_71813 = state_71733__$1;
(statearr_71741_71813[(1)] = (28));

} else {
var statearr_71742_71814 = state_71733__$1;
(statearr_71742_71814[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (1))){
var inst_71588 = (0);
var state_71733__$1 = (function (){var statearr_71743 = state_71733;
(statearr_71743[(8)] = inst_71588);

return statearr_71743;
})();
var statearr_71744_71815 = state_71733__$1;
(statearr_71744_71815[(2)] = null);

(statearr_71744_71815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (24))){
var inst_71680 = (state_71733[(9)]);
var state_71733__$1 = state_71733;
var statearr_71745_71816 = state_71733__$1;
(statearr_71745_71816[(2)] = inst_71680);

(statearr_71745_71816[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (39))){
var inst_71715 = (state_71733[(2)]);
var state_71733__$1 = state_71733;
var statearr_71746_71817 = state_71733__$1;
(statearr_71746_71817[(2)] = inst_71715);

(statearr_71746_71817[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (4))){
var inst_71591 = (state_71733[(10)]);
var inst_71591__$1 = (state_71733[(2)]);
var state_71733__$1 = (function (){var statearr_71747 = state_71733;
(statearr_71747[(10)] = inst_71591__$1);

return statearr_71747;
})();
if(cljs.core.truth_(inst_71591__$1)){
var statearr_71748_71818 = state_71733__$1;
(statearr_71748_71818[(1)] = (5));

} else {
var statearr_71749_71819 = state_71733__$1;
(statearr_71749_71819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (15))){
var inst_71604 = (state_71733[(11)]);
var state_71733__$1 = state_71733;
var statearr_71750_71820 = state_71733__$1;
(statearr_71750_71820[(2)] = inst_71604);

(statearr_71750_71820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (21))){
var inst_71641 = (state_71733[(12)]);
var inst_71633 = (state_71733[(13)]);
var inst_71635 = (state_71733[(14)]);
var inst_71591 = (state_71733[(10)]);
var inst_71638 = (state_71733[(15)]);
var inst_71588 = (state_71733[(8)]);
var inst_71634 = (state_71733[(16)]);
var inst_71637 = (state_71733[(17)]);
var inst_71642 = (state_71733[(18)]);
var inst_71636 = (state_71733[(19)]);
var inst_71644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71645 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71641];
var inst_71646 = (new cljs.core.PersistentVector(null,2,(5),inst_71644,inst_71645,null));
var inst_71647 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_71646,inst_71636);
var inst_71674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71675 = (function (){var resp_chan = inst_71636;
var timeout = inst_71642;
var map__71629 = inst_71638;
var vec__71626 = inst_71591;
var c__2749__auto____$1 = inst_71674;
var i = inst_71588;
var data = inst_71635;
var _ = inst_71633;
var req_id = inst_71641;
var operation = inst_71634;
var msg = inst_71591;
var temp__5804__auto__ = inst_71591;
var opts = inst_71637;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71672){
var state_val_71673 = (state_71672[(1)]);
if((state_val_71673 === (1))){
var inst_71651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71652 = cljs.core.async.timeout(timeout);
var inst_71653 = [resp_chan,inst_71652];
var inst_71654 = (new cljs.core.PersistentVector(null,2,(5),inst_71651,inst_71653,null));
var state_71672__$1 = state_71672;
return cljs.core.async.ioc_alts_BANG_(state_71672__$1,(2),inst_71654);
} else {
if((state_val_71673 === (2))){
var inst_71657 = (state_71672[(7)]);
var inst_71656 = (state_71672[(2)]);
var inst_71657__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71656,(0),null);
var inst_71658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71656,(1),null);
var inst_71659 = (function (){var vec__71648 = inst_71656;
var resp = inst_71657__$1;
var c = inst_71658;
return (function (p1__71585_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__71585_SHARP_,req_id);
});
})();
var inst_71660 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71659);
var inst_71661 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71658,resp_chan);
var state_71672__$1 = (function (){var statearr_71751 = state_71672;
(statearr_71751[(7)] = inst_71657__$1);

(statearr_71751[(8)] = inst_71660);

return statearr_71751;
})();
if(inst_71661){
var statearr_71752_71821 = state_71672__$1;
(statearr_71752_71821[(1)] = (3));

} else {
var statearr_71753_71822 = state_71672__$1;
(statearr_71753_71822[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71673 === (3))){
var inst_71657 = (state_71672[(7)]);
var state_71672__$1 = state_71672;
var statearr_71754_71823 = state_71672__$1;
(statearr_71754_71823[(2)] = inst_71657);

(statearr_71754_71823[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71673 === (4))){
var inst_71664 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_71665 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71666 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_71667 = cljs.core.PersistentHashMap.fromArrays(inst_71665,inst_71666);
var inst_71668 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71664,inst_71667);
var state_71672__$1 = state_71672;
var statearr_71755_71824 = state_71672__$1;
(statearr_71755_71824[(2)] = inst_71668);

(statearr_71755_71824[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71673 === (5))){
var inst_71670 = (state_71672[(2)]);
var state_71672__$1 = state_71672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71672__$1,inst_71670);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_71756 = [null,null,null,null,null,null,null,null,null];
(statearr_71756[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_71756[(1)] = (1));

return statearr_71756;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_71672){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71672);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71757){var ex__2730__auto__ = e71757;
var statearr_71758_71825 = state_71672;
(statearr_71758_71825[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71672[(4)]))){
var statearr_71759_71826 = state_71672;
(statearr_71759_71826[(1)] = cljs.core.first((state_71672[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71827 = state_71672;
state_71672 = G__71827;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_71672){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_71672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71760 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71760[(6)] = c__2749__auto____$1);

return statearr_71760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_71676 = cljs.core.async.impl.dispatch.run(inst_71675);
var state_71733__$1 = (function (){var statearr_71761 = state_71733;
(statearr_71761[(20)] = inst_71647);

(statearr_71761[(21)] = inst_71676);

return statearr_71761;
})();
var statearr_71762_71828 = state_71733__$1;
(statearr_71762_71828[(2)] = inst_71674);

(statearr_71762_71828[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (31))){
var inst_71690 = (state_71733[(7)]);
var inst_71696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71697 = [inst_71690,"Error processing message in producer."];
var inst_71698 = (new cljs.core.PersistentVector(null,2,(5),inst_71696,inst_71697,null));
var inst_71699 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71698);
var state_71733__$1 = state_71733;
var statearr_71763_71829 = state_71733__$1;
(statearr_71763_71829[(2)] = inst_71699);

(statearr_71763_71829[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (32))){
var inst_71690 = (state_71733[(7)]);
var inst_71701 = (inst_71690 == null);
var state_71733__$1 = state_71733;
if(cljs.core.truth_(inst_71701)){
var statearr_71764_71830 = state_71733__$1;
(statearr_71764_71830[(1)] = (34));

} else {
var statearr_71765_71831 = state_71733__$1;
(statearr_71765_71831[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (33))){
var inst_71719 = (state_71733[(2)]);
var state_71733__$1 = state_71733;
var statearr_71766_71832 = state_71733__$1;
(statearr_71766_71832[(2)] = inst_71719);

(statearr_71766_71832[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (13))){
var inst_71604 = (state_71733[(11)]);
var inst_71601 = (state_71733[(2)]);
var inst_71602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71601,(0),null);
var inst_71603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71601,(1),null);
var inst_71604__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71601,(2),null);
var state_71733__$1 = (function (){var statearr_71767 = state_71733;
(statearr_71767[(22)] = inst_71603);

(statearr_71767[(23)] = inst_71602);

(statearr_71767[(11)] = inst_71604__$1);

return statearr_71767;
})();
if(cljs.core.truth_(inst_71604__$1)){
var statearr_71768_71833 = state_71733__$1;
(statearr_71768_71833[(1)] = (14));

} else {
var statearr_71769_71834 = state_71733__$1;
(statearr_71769_71834[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (22))){
var state_71733__$1 = state_71733;
var statearr_71770_71835 = state_71733__$1;
(statearr_71770_71835[(2)] = null);

(statearr_71770_71835[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (36))){
var inst_71717 = (state_71733[(2)]);
var state_71733__$1 = state_71733;
var statearr_71771_71836 = state_71733__$1;
(statearr_71771_71836[(2)] = inst_71717);

(statearr_71771_71836[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (29))){
var inst_71690 = (state_71733[(7)]);
var inst_71694 = fluree.db.util.core.exception_QMARK_(inst_71690);
var state_71733__$1 = state_71733;
if(inst_71694){
var statearr_71772_71837 = state_71733__$1;
(statearr_71772_71837[(1)] = (31));

} else {
var statearr_71773_71838 = state_71733__$1;
(statearr_71773_71838[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (6))){
var state_71733__$1 = state_71733;
var statearr_71774_71839 = state_71733__$1;
(statearr_71774_71839[(2)] = null);

(statearr_71774_71839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (28))){
var state_71733__$1 = state_71733;
var statearr_71775_71840 = state_71733__$1;
(statearr_71775_71840[(2)] = null);

(statearr_71775_71840[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (25))){
var state_71733__$1 = state_71733;
var statearr_71776_71841 = state_71733__$1;
(statearr_71776_71841[(2)] = fluree.db.connection.default_publish_fn);

(statearr_71776_71841[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (34))){
var inst_71703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71704 = ["Error processing message in producer. Socket closed."];
var inst_71705 = (new cljs.core.PersistentVector(null,1,(5),inst_71703,inst_71704,null));
var inst_71706 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71705);
var state_71733__$1 = state_71733;
var statearr_71777_71842 = state_71733__$1;
(statearr_71777_71842[(2)] = inst_71706);

(statearr_71777_71842[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (17))){
var inst_71593 = (state_71733[(24)]);
var inst_71604 = (state_71733[(11)]);
var inst_71611 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_71604,inst_71593);
var state_71733__$1 = state_71733;
var statearr_71778_71843 = state_71733__$1;
(statearr_71778_71843[(2)] = inst_71611);

(statearr_71778_71843[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (3))){
var inst_71731 = (state_71733[(2)]);
var state_71733__$1 = state_71733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71733__$1,inst_71731);
} else {
if((state_val_71734 === (12))){
var state_71733__$1 = state_71733;
var statearr_71779_71844 = state_71733__$1;
(statearr_71779_71844[(2)] = null);

(statearr_71779_71844[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (2))){
var state_71733__$1 = state_71733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71733__$1,(4),req_chan);
} else {
if((state_val_71734 === (23))){
var inst_71680 = (state_71733[(9)]);
var inst_71679 = (state_71733[(2)]);
var inst_71680__$1 = publish;
var state_71733__$1 = (function (){var statearr_71780 = state_71733;
(statearr_71780[(25)] = inst_71679);

(statearr_71780[(9)] = inst_71680__$1);

return statearr_71780;
})();
if(cljs.core.truth_(inst_71680__$1)){
var statearr_71781_71845 = state_71733__$1;
(statearr_71781_71845[(1)] = (24));

} else {
var statearr_71782_71846 = state_71733__$1;
(statearr_71782_71846[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (35))){
var state_71733__$1 = state_71733;
var statearr_71783_71847 = state_71733__$1;
(statearr_71783_71847[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (19))){
var inst_71620 = (state_71733[(2)]);
var state_71733__$1 = state_71733;
var statearr_71785_71848 = state_71733__$1;
(statearr_71785_71848[(2)] = inst_71620);

(statearr_71785_71848[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (11))){
var inst_71591 = (state_71733[(10)]);
var state_71733__$1 = state_71733;
var statearr_71786_71849 = state_71733__$1;
(statearr_71786_71849[(2)] = inst_71591);

(statearr_71786_71849[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (9))){
var inst_71588 = (state_71733[(8)]);
var inst_71724 = (state_71733[(2)]);
var inst_71725 = (inst_71588 + (1));
var inst_71588__$1 = inst_71725;
var state_71733__$1 = (function (){var statearr_71787 = state_71733;
(statearr_71787[(8)] = inst_71588__$1);

(statearr_71787[(26)] = inst_71724);

return statearr_71787;
})();
var statearr_71788_71850 = state_71733__$1;
(statearr_71788_71850[(2)] = null);

(statearr_71788_71850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (5))){
var state_71733__$1 = state_71733;
var statearr_71789_71851 = state_71733__$1;
(statearr_71789_71851[(2)] = null);

(statearr_71789_71851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (14))){
var inst_71604 = (state_71733[(11)]);
var inst_71606 = fluree.db.util.async.channel_QMARK_(inst_71604);
var state_71733__$1 = state_71733;
var statearr_71790_71852 = state_71733__$1;
(statearr_71790_71852[(2)] = inst_71606);

(statearr_71790_71852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (26))){
var inst_71641 = (state_71733[(12)]);
var inst_71635 = (state_71733[(14)]);
var inst_71634 = (state_71733[(16)]);
var inst_71684 = (state_71733[(2)]);
var inst_71685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71686 = [inst_71634,inst_71641,inst_71635];
var inst_71687 = (new cljs.core.PersistentVector(null,3,(5),inst_71685,inst_71686,null));
var inst_71688 = (inst_71684.cljs$core$IFn$_invoke$arity$2 ? inst_71684.cljs$core$IFn$_invoke$arity$2(conn,inst_71687) : inst_71684.call(null,conn,inst_71687));
var state_71733__$1 = state_71733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71733__$1,(27),inst_71688);
} else {
if((state_val_71734 === (16))){
var inst_71609 = (state_71733[(2)]);
var state_71733__$1 = state_71733;
if(cljs.core.truth_(inst_71609)){
var statearr_71791_71853 = state_71733__$1;
(statearr_71791_71853[(1)] = (17));

} else {
var statearr_71792_71854 = state_71733__$1;
(statearr_71792_71854[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (38))){
var state_71733__$1 = state_71733;
var statearr_71793_71855 = state_71733__$1;
(statearr_71793_71855[(2)] = null);

(statearr_71793_71855[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (30))){
var inst_71721 = (state_71733[(2)]);
var _ = (function (){var statearr_71794 = state_71733;
(statearr_71794[(4)] = cljs.core.rest((state_71733[(4)])));

return statearr_71794;
})();
var state_71733__$1 = state_71733;
var statearr_71795_71856 = state_71733__$1;
(statearr_71795_71856[(2)] = inst_71721);

(statearr_71795_71856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (10))){
var inst_71591 = (state_71733[(10)]);
var inst_71593 = (state_71733[(2)]);
var inst_71597 = cljs.core.sequential_QMARK_(inst_71591);
var state_71733__$1 = (function (){var statearr_71796 = state_71733;
(statearr_71796[(24)] = inst_71593);

return statearr_71796;
})();
if(inst_71597){
var statearr_71797_71857 = state_71733__$1;
(statearr_71797_71857[(1)] = (11));

} else {
var statearr_71798_71858 = state_71733__$1;
(statearr_71798_71858[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (18))){
var inst_71591 = (state_71733[(10)]);
var inst_71593 = (state_71733[(24)]);
var inst_71613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71614 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_71591], 0));
var inst_71615 = ["Error processing ledger request, no valid return channel: ",inst_71614].join('');
var inst_71616 = [inst_71593,inst_71615];
var inst_71617 = (new cljs.core.PersistentVector(null,2,(5),inst_71613,inst_71616,null));
var inst_71618 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71617);
var state_71733__$1 = state_71733;
var statearr_71799_71859 = state_71733__$1;
(statearr_71799_71859[(2)] = inst_71618);

(statearr_71799_71859[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (37))){
var inst_71690 = (state_71733[(7)]);
var inst_71709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71710 = ["Error processing message in producer. Socket closed. Published result",inst_71690];
var inst_71711 = (new cljs.core.PersistentVector(null,2,(5),inst_71709,inst_71710,null));
var inst_71712 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71711);
var state_71733__$1 = state_71733;
var statearr_71800_71860 = state_71733__$1;
(statearr_71800_71860[(2)] = inst_71712);

(statearr_71800_71860[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71734 === (8))){
var inst_71591 = (state_71733[(10)]);
var inst_71638 = (state_71733[(15)]);
var inst_71637 = (state_71733[(17)]);
var inst_71636 = (state_71733[(19)]);
var _ = (function (){var statearr_71801 = state_71733;
(statearr_71801[(4)] = cljs.core.cons((20),(state_71733[(4)])));

return statearr_71801;
})();
var inst_71630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71631 = ["Outgoing message to websocket: ",inst_71591];
var inst_71632 = (new cljs.core.PersistentVector(null,2,(5),inst_71630,inst_71631,null));
var inst_71633 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71632);
var inst_71634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71591,(0),null);
var inst_71635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71591,(1),null);
var inst_71636__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71591,(2),null);
var inst_71637__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71591,(3),null);
var inst_71638__$1 = cljs.core.__destructure_map(inst_71637__$1);
var inst_71639 = cljs.core.random_uuid();
var inst_71640 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71639);
var inst_71641 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_71638__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_71640);
var inst_71642 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_71638__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_71733__$1 = (function (){var statearr_71802 = state_71733;
(statearr_71802[(12)] = inst_71641);

(statearr_71802[(13)] = inst_71633);

(statearr_71802[(14)] = inst_71635);

(statearr_71802[(15)] = inst_71638__$1);

(statearr_71802[(16)] = inst_71634);

(statearr_71802[(17)] = inst_71637__$1);

(statearr_71802[(18)] = inst_71642);

(statearr_71802[(19)] = inst_71636__$1);

return statearr_71802;
})();
if(cljs.core.truth_(inst_71636__$1)){
var statearr_71803_71861 = state_71733__$1;
(statearr_71803_71861[(1)] = (21));

} else {
var statearr_71804_71862 = state_71733__$1;
(statearr_71804_71862[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_71805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71805[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_71805[(1)] = (1));

return statearr_71805;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_71733){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71733);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71806){var ex__2730__auto__ = e71806;
var statearr_71807_71863 = state_71733;
(statearr_71807_71863[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71733[(4)]))){
var statearr_71808_71864 = state_71733;
(statearr_71808_71864[(1)] = cljs.core.first((state_71733[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71865 = state_71733;
state_71733 = G__71865;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_71733){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_71733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71809 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71809[(6)] = c__2749__auto__);

return statearr_71809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__71866 = conn;
var map__71866__$1 = cljs.core.__destructure_map(map__71866);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71866__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71969){
var state_val_71970 = (state_71969[(1)]);
if((state_val_71970 === (7))){
var inst_71965 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_71971_72022 = state_71969__$1;
(statearr_71971_72022[(2)] = inst_71965);

(statearr_71971_72022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (20))){
var inst_71888 = (state_71969[(7)]);
var inst_71905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71906 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_71907 = [inst_71888];
var inst_71908 = cljs.core.PersistentHashMap.fromArrays(inst_71906,inst_71907);
var inst_71909 = ["Unsupported callback registered",inst_71908];
var inst_71910 = (new cljs.core.PersistentVector(null,2,(5),inst_71905,inst_71909,null));
var inst_71911 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71910);
var state_71969__$1 = state_71969;
var statearr_71972_72023 = state_71969__$1;
(statearr_71972_72023[(2)] = inst_71911);

(statearr_71972_72023[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (27))){
var state_71969__$1 = state_71969;
var statearr_71973_72024 = state_71969__$1;
(statearr_71973_72024[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (1))){
var inst_71867 = (0);
var state_71969__$1 = (function (){var statearr_71975 = state_71969;
(statearr_71975[(8)] = inst_71867);

return statearr_71975;
})();
var statearr_71976_72025 = state_71969__$1;
(statearr_71976_72025[(2)] = null);

(statearr_71976_72025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (24))){
var inst_71878 = (state_71969[(9)]);
var inst_71939 = fluree.db.util.core.exception_QMARK_(inst_71878);
var state_71969__$1 = state_71969;
if(inst_71939){
var statearr_71977_72026 = state_71969__$1;
(statearr_71977_72026[(1)] = (26));

} else {
var statearr_71978_72027 = state_71969__$1;
(statearr_71978_72027[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (4))){
var inst_71872 = (state_71969[(10)]);
var inst_71877 = (state_71969[(2)]);
var inst_71878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71877,(0),null);
var inst_71879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71877,(1),null);
var inst_71880 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71879,inst_71872);
var state_71969__$1 = (function (){var statearr_71979 = state_71969;
(statearr_71979[(9)] = inst_71878);

return statearr_71979;
})();
if(inst_71880){
var statearr_71980_72028 = state_71969__$1;
(statearr_71980_72028[(1)] = (5));

} else {
var statearr_71981_72029 = state_71969__$1;
(statearr_71981_72029[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (15))){
var inst_71888 = (state_71969[(7)]);
var inst_71900 = typeof inst_71888 === 'string';
var state_71969__$1 = state_71969;
if(cljs.core.truth_(inst_71900)){
var statearr_71982_72030 = state_71969__$1;
(statearr_71982_72030[(1)] = (17));

} else {
var statearr_71983_72031 = state_71969__$1;
(statearr_71983_72031[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (21))){
var state_71969__$1 = state_71969;
var statearr_71984_72032 = state_71969__$1;
(statearr_71984_72032[(2)] = null);

(statearr_71984_72032[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (31))){
var inst_71959 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_71985_72033 = state_71969__$1;
(statearr_71985_72033[(2)] = inst_71959);

(statearr_71985_72033[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (13))){
var inst_71920 = (state_71969[(2)]);
var inst_71921 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71922 = fluree.db.connection.close_websocket(inst_71921);
var inst_71923 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71924 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_71923);
var state_71969__$1 = (function (){var statearr_71986 = state_71969;
(statearr_71986[(11)] = inst_71922);

(statearr_71986[(12)] = inst_71920);

return statearr_71986;
})();
var statearr_71987_72034 = state_71969__$1;
(statearr_71987_72034[(2)] = inst_71924);

(statearr_71987_72034[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (22))){
var inst_71914 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_71988_72035 = state_71969__$1;
(statearr_71988_72035[(2)] = inst_71914);

(statearr_71988_72035[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (29))){
var inst_71878 = (state_71969[(9)]);
var inst_71948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71949 = fluree.db.util.json.parse(inst_71878);
var inst_71950 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_71949], 0));
var inst_71951 = ["Received message:",inst_71950];
var inst_71952 = (new cljs.core.PersistentVector(null,2,(5),inst_71948,inst_71951,null));
var inst_71953 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71952);
var inst_71954 = fluree.db.util.json.parse(inst_71878);
var inst_71955 = fluree.db.conn_events.process_events(conn,inst_71954);
var inst_71867 = (0);
var state_71969__$1 = (function (){var statearr_71989 = state_71969;
(statearr_71989[(13)] = inst_71955);

(statearr_71989[(8)] = inst_71867);

(statearr_71989[(14)] = inst_71953);

return statearr_71989;
})();
var statearr_71990_72036 = state_71969__$1;
(statearr_71990_72036[(2)] = null);

(statearr_71990_72036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (6))){
var inst_71878 = (state_71969[(9)]);
var inst_71932 = (inst_71878 == null);
var state_71969__$1 = state_71969;
if(cljs.core.truth_(inst_71932)){
var statearr_71991_72037 = state_71969__$1;
(statearr_71991_72037[(1)] = (23));

} else {
var statearr_71992_72038 = state_71969__$1;
(statearr_71992_72038[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (28))){
var inst_71961 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_71993_72039 = state_71969__$1;
(statearr_71993_72039[(2)] = inst_71961);

(statearr_71993_72039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (25))){
var inst_71963 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_71994_72040 = state_71969__$1;
(statearr_71994_72040[(2)] = inst_71963);

(statearr_71994_72040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (17))){
var inst_71888 = (state_71969[(7)]);
var inst_71902 = cljs.core.eval(inst_71888);
var state_71969__$1 = state_71969;
var statearr_71995_72041 = state_71969__$1;
(statearr_71995_72041[(2)] = inst_71902);

(statearr_71995_72041[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (3))){
var inst_71967 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71969__$1,inst_71967);
} else {
if((state_val_71970 === (12))){
var inst_71888 = (state_71969[(7)]);
var inst_71896 = cljs.core.fn_QMARK_(inst_71888);
var state_71969__$1 = state_71969;
if(inst_71896){
var statearr_71996_72042 = state_71969__$1;
(statearr_71996_72042[(1)] = (14));

} else {
var statearr_71997_72043 = state_71969__$1;
(statearr_71997_72043[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (2))){
var inst_71872 = (state_71969[(10)]);
var inst_71872__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_71873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71874 = [sub_chan,inst_71872__$1];
var inst_71875 = (new cljs.core.PersistentVector(null,2,(5),inst_71873,inst_71874,null));
var state_71969__$1 = (function (){var statearr_71998 = state_71969;
(statearr_71998[(10)] = inst_71872__$1);

return statearr_71998;
})();
return cljs.core.async.ioc_alts_BANG_(state_71969__$1,(4),inst_71875);
} else {
if((state_val_71970 === (23))){
var inst_71934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71935 = ["Connection closed."];
var inst_71936 = (new cljs.core.PersistentVector(null,1,(5),inst_71934,inst_71935,null));
var inst_71937 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_71936);
var state_71969__$1 = state_71969;
var statearr_71999_72044 = state_71969__$1;
(statearr_71999_72044[(2)] = inst_71937);

(statearr_71999_72044[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (19))){
var inst_71916 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_72000_72045 = state_71969__$1;
(statearr_72000_72045[(2)] = inst_71916);

(statearr_72000_72045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (11))){
var inst_71891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71892 = ["No keep-alive callback is registered"];
var inst_71893 = (new cljs.core.PersistentVector(null,1,(5),inst_71891,inst_71892,null));
var inst_71894 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71893);
var state_71969__$1 = state_71969;
var statearr_72001_72046 = state_71969__$1;
(statearr_72001_72046[(2)] = inst_71894);

(statearr_72001_72046[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (9))){
var inst_71867 = (state_71969[(8)]);
var inst_71926 = fluree.db.connection.ping_transactor(conn);
var inst_71927 = (inst_71867 + (1));
var inst_71867__$1 = inst_71927;
var state_71969__$1 = (function (){var statearr_72002 = state_71969;
(statearr_72002[(15)] = inst_71926);

(statearr_72002[(8)] = inst_71867__$1);

return statearr_72002;
})();
var statearr_72003_72047 = state_71969__$1;
(statearr_72003_72047[(2)] = null);

(statearr_72003_72047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (5))){
var inst_71867 = (state_71969[(8)]);
var inst_71882 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_71867);
var state_71969__$1 = state_71969;
if(inst_71882){
var statearr_72004_72048 = state_71969__$1;
(statearr_72004_72048[(1)] = (8));

} else {
var statearr_72005_72049 = state_71969__$1;
(statearr_72005_72049[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (14))){
var inst_71888 = (state_71969[(7)]);
var inst_71898 = (inst_71888.cljs$core$IFn$_invoke$arity$0 ? inst_71888.cljs$core$IFn$_invoke$arity$0() : inst_71888.call(null));
var state_71969__$1 = state_71969;
var statearr_72006_72050 = state_71969__$1;
(statearr_72006_72050[(2)] = inst_71898);

(statearr_72006_72050[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (26))){
var inst_71878 = (state_71969[(9)]);
var inst_71941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71942 = [inst_71878];
var inst_71943 = (new cljs.core.PersistentVector(null,1,(5),inst_71941,inst_71942,null));
var inst_71944 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71943);
var inst_71867 = (0);
var state_71969__$1 = (function (){var statearr_72007 = state_71969;
(statearr_72007[(16)] = inst_71944);

(statearr_72007[(8)] = inst_71867);

return statearr_72007;
})();
var statearr_72008_72051 = state_71969__$1;
(statearr_72008_72051[(2)] = null);

(statearr_72008_72051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (16))){
var inst_71918 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_72009_72052 = state_71969__$1;
(statearr_72009_72052[(2)] = inst_71918);

(statearr_72009_72052[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (30))){
var state_71969__$1 = state_71969;
var statearr_72010_72053 = state_71969__$1;
(statearr_72010_72053[(2)] = null);

(statearr_72010_72053[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (10))){
var inst_71930 = (state_71969[(2)]);
var state_71969__$1 = state_71969;
var statearr_72011_72054 = state_71969__$1;
(statearr_72011_72054[(2)] = inst_71930);

(statearr_72011_72054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (18))){
var state_71969__$1 = state_71969;
var statearr_72012_72055 = state_71969__$1;
(statearr_72012_72055[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71970 === (8))){
var inst_71888 = (state_71969[(7)]);
var inst_71884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71885 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_71886 = (new cljs.core.PersistentVector(null,1,(5),inst_71884,inst_71885,null));
var inst_71887 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71886);
var inst_71888__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71889 = (inst_71888__$1 == null);
var state_71969__$1 = (function (){var statearr_72014 = state_71969;
(statearr_72014[(7)] = inst_71888__$1);

(statearr_72014[(17)] = inst_71887);

return statearr_72014;
})();
if(cljs.core.truth_(inst_71889)){
var statearr_72015_72056 = state_71969__$1;
(statearr_72015_72056[(1)] = (11));

} else {
var statearr_72016_72057 = state_71969__$1;
(statearr_72016_72057[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_72017 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72017[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_72017[(1)] = (1));

return statearr_72017;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_71969){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71969);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72018){var ex__2730__auto__ = e72018;
var statearr_72019_72058 = state_71969;
(statearr_72019_72058[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71969[(4)]))){
var statearr_72020_72059 = state_71969;
(statearr_72020_72059[(1)] = cljs.core.first((state_71969[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72060 = state_71969;
state_71969 = G__72060;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_71969){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_71969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72021 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72021[(6)] = c__2749__auto__);

return statearr_72021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__72062 = arguments.length;
switch (G__72062) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__72063 = opts;
var map__72063__$1 = cljs.core.__destructure_map(map__72063);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72063__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72063__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72115){
var state_val_72116 = (state_72115[(1)]);
if((state_val_72116 === (7))){
var inst_72073 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_72074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72075 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72076 = (new cljs.core.PersistentVector(null,2,(5),inst_72074,inst_72075,null));
var inst_72077 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72073,inst_72076);
var state_72115__$1 = state_72115;
var statearr_72117_72148 = state_72115__$1;
(statearr_72117_72148[(2)] = inst_72077);

(statearr_72117_72148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (1))){
var state_72115__$1 = state_72115;
var statearr_72118_72149 = state_72115__$1;
(statearr_72118_72149[(2)] = null);

(statearr_72118_72149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (4))){
var inst_72064 = (state_72115[(2)]);
var state_72115__$1 = state_72115;
var statearr_72119_72150 = state_72115__$1;
(statearr_72119_72150[(2)] = inst_72064);

(statearr_72119_72150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (15))){
var inst_72084 = (state_72115[(7)]);
var inst_72103 = (state_72115[(2)]);
var inst_72104 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_72105 = [(5000),inst_72103,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_72106 = cljs.core.PersistentHashMap.fromArrays(inst_72104,inst_72105);
var inst_72107 = fluree.db.util.xhttp.get(inst_72084,inst_72106);
var state_72115__$1 = state_72115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72115__$1,(16),inst_72107);
} else {
if((state_val_72116 === (13))){
var inst_72094 = (state_72115[(8)]);
var inst_72084 = (state_72115[(7)]);
var inst_72096 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_72097 = [inst_72094];
var inst_72098 = cljs.core.PersistentHashMap.fromArrays(inst_72096,inst_72097);
var inst_72099 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_72084,inst_72098,private$);
var inst_72100 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_72099);
var state_72115__$1 = state_72115;
var statearr_72120_72151 = state_72115__$1;
(statearr_72120_72151[(2)] = inst_72100);

(statearr_72120_72151[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (6))){
var inst_72070 = (state_72115[(9)]);
var state_72115__$1 = state_72115;
var statearr_72121_72152 = state_72115__$1;
(statearr_72121_72152[(2)] = inst_72070);

(statearr_72121_72152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (3))){
var inst_72113 = (state_72115[(2)]);
var state_72115__$1 = state_72115;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72115__$1,inst_72113);
} else {
if((state_val_72116 === (12))){
var inst_72094 = (state_72115[(2)]);
var state_72115__$1 = (function (){var statearr_72122 = state_72115;
(statearr_72122[(8)] = inst_72094);

return statearr_72122;
})();
if(cljs.core.truth_(private$)){
var statearr_72123_72153 = state_72115__$1;
(statearr_72123_72153[(1)] = (13));

} else {
var statearr_72124_72154 = state_72115__$1;
(statearr_72124_72154[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (2))){
var inst_72070 = (state_72115[(9)]);
var _ = (function (){var statearr_72125 = state_72115;
(statearr_72125[(4)] = cljs.core.cons((5),(state_72115[(4)])));

return statearr_72125;
})();
var inst_72070__$1 = jwt;
var state_72115__$1 = (function (){var statearr_72126 = state_72115;
(statearr_72126[(9)] = inst_72070__$1);

return statearr_72126;
})();
if(cljs.core.truth_(inst_72070__$1)){
var statearr_72127_72155 = state_72115__$1;
(statearr_72127_72155[(1)] = (6));

} else {
var statearr_72128_72156 = state_72115__$1;
(statearr_72128_72156[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (11))){
var inst_72088 = (state_72115[(10)]);
var state_72115__$1 = state_72115;
var statearr_72130_72157 = state_72115__$1;
(statearr_72130_72157[(2)] = inst_72088);

(statearr_72130_72157[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (9))){
var inst_72080 = (state_72115[(11)]);
var inst_72079 = (state_72115[(12)]);
var inst_72083 = (state_72115[(2)]);
var inst_72084 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72083),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72080)].join('');
var inst_72086 = ["Accept"];
var inst_72087 = ["application/json"];
var inst_72088 = cljs.core.PersistentHashMap.fromArrays(inst_72086,inst_72087);
var state_72115__$1 = (function (){var statearr_72131 = state_72115;
(statearr_72131[(10)] = inst_72088);

(statearr_72131[(7)] = inst_72084);

return statearr_72131;
})();
if(cljs.core.truth_(inst_72079)){
var statearr_72132_72158 = state_72115__$1;
(statearr_72132_72158[(1)] = (10));

} else {
var statearr_72133_72159 = state_72115__$1;
(statearr_72133_72159[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (5))){
var _ = (function (){var statearr_72134 = state_72115;
(statearr_72134[(4)] = cljs.core.rest((state_72115[(4)])));

return statearr_72134;
})();
var state_72115__$1 = state_72115;
var ex72129 = (state_72115__$1[(2)]);
var statearr_72135_72160 = state_72115__$1;
(statearr_72135_72160[(5)] = ex72129);


if((ex72129 instanceof Error)){
var statearr_72136_72161 = state_72115__$1;
(statearr_72136_72161[(1)] = (4));

(statearr_72136_72161[(5)] = null);

} else {
throw ex72129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (14))){
var inst_72094 = (state_72115[(8)]);
var state_72115__$1 = state_72115;
var statearr_72137_72162 = state_72115__$1;
(statearr_72137_72162[(2)] = inst_72094);

(statearr_72137_72162[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (16))){
var inst_72109 = (state_72115[(2)]);
var inst_72110 = fluree.db.util.async.throw_err(inst_72109);
var _ = (function (){var statearr_72138 = state_72115;
(statearr_72138[(4)] = cljs.core.rest((state_72115[(4)])));

return statearr_72138;
})();
var state_72115__$1 = state_72115;
var statearr_72139_72163 = state_72115__$1;
(statearr_72139_72163[(2)] = inst_72110);

(statearr_72139_72163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (10))){
var inst_72088 = (state_72115[(10)]);
var inst_72079 = (state_72115[(12)]);
var inst_72090 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72079)].join('');
var inst_72091 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_72088,"Authorization",inst_72090);
var state_72115__$1 = state_72115;
var statearr_72140_72164 = state_72115__$1;
(statearr_72140_72164[(2)] = inst_72091);

(statearr_72140_72164[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72116 === (8))){
var inst_72079 = (state_72115[(2)]);
var inst_72080 = clojure.string.replace(k,"_","/");
var inst_72081 = fluree.db.connection.get_server(conn_id,servers);
var state_72115__$1 = (function (){var statearr_72141 = state_72115;
(statearr_72141[(11)] = inst_72080);

(statearr_72141[(12)] = inst_72079);

return statearr_72141;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72115__$1,(9),inst_72081);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_72142 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72142[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_72142[(1)] = (1));

return statearr_72142;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_72115){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72115);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72143){var ex__2730__auto__ = e72143;
var statearr_72144_72165 = state_72115;
(statearr_72144_72165[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72115[(4)]))){
var statearr_72145_72166 = state_72115;
(statearr_72145_72166[(1)] = cljs.core.first((state_72115[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72167 = state_72115;
state_72115 = G__72167;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_72115){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_72115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72146 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72146[(6)] = c__2749__auto__);

return statearr_72146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___72192 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___72192)){
var v_72193 = temp__5802__auto___72192;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_72193);
} else {
var c__2749__auto___72194 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72179){
var state_val_72180 = (state_72179[(1)]);
if((state_val_72180 === (1))){
var inst_72168 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_72179__$1 = state_72179;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72179__$1,(2),inst_72168);
} else {
if((state_val_72180 === (2))){
var inst_72170 = (state_72179[(7)]);
var inst_72170__$1 = (state_72179[(2)]);
var inst_72171 = fluree.db.util.core.exception_QMARK_(inst_72170__$1);
var state_72179__$1 = (function (){var statearr_72181 = state_72179;
(statearr_72181[(7)] = inst_72170__$1);

return statearr_72181;
})();
if(inst_72171){
var statearr_72182_72195 = state_72179__$1;
(statearr_72182_72195[(1)] = (3));

} else {
var statearr_72183_72196 = state_72179__$1;
(statearr_72183_72196[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72180 === (3))){
var state_72179__$1 = state_72179;
var statearr_72184_72197 = state_72179__$1;
(statearr_72184_72197[(2)] = null);

(statearr_72184_72197[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72180 === (4))){
var inst_72170 = (state_72179[(7)]);
var inst_72174 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_72170);
var state_72179__$1 = state_72179;
var statearr_72185_72198 = state_72179__$1;
(statearr_72185_72198[(2)] = inst_72174);

(statearr_72185_72198[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72180 === (5))){
var inst_72170 = (state_72179[(7)]);
var inst_72176 = (state_72179[(2)]);
var inst_72177 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_72170);
var state_72179__$1 = (function (){var statearr_72186 = state_72179;
(statearr_72186[(8)] = inst_72176);

return statearr_72186;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72179__$1,inst_72177);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_72187 = [null,null,null,null,null,null,null,null,null];
(statearr_72187[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__);

(statearr_72187[(1)] = (1));

return statearr_72187;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1 = (function (state_72179){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72179);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72188){var ex__2730__auto__ = e72188;
var statearr_72189_72199 = state_72179;
(statearr_72189_72199[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72179[(4)]))){
var statearr_72190_72200 = state_72179;
(statearr_72190_72200[(1)] = cljs.core.first((state_72179[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72201 = state_72179;
state_72179 = G__72201;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = function(state_72179){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1.call(this,state_72179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72191 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72191[(6)] = c__2749__auto___72194);

return statearr_72191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__72202_SHARP_){
if(cljs.core.truth_(p1__72202_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__72203_SHARP_){
var or__4253__auto__ = p1__72203_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e72204){var e = e72204;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__72205 = opts;
var map__72205__$1 = cljs.core.__destructure_map(map__72205);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72205__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72205__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__4253__auto__ = async_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__72206_72207 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__72206_72207.cljs$core$IFn$_invoke$arity$0 ? fexpr__72206_72207.cljs$core$IFn$_invoke$arity$0() : fexpr__72206_72207.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72251 = arguments.length;
var i__4865__auto___72252 = (0);
while(true){
if((i__4865__auto___72252 < len__4864__auto___72251)){
args__4870__auto__.push((arguments[i__4865__auto___72252]));

var G__72253 = (i__4865__auto___72252 + (1));
i__4865__auto___72252 = G__72253;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__72210){
var vec__72211 = p__72210;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72211,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___72254 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72234){
var state_val_72235 = (state_72234[(1)]);
if((state_val_72235 === (1))){
var inst_72214 = fluree.db.connection.get_socket(conn);
var state_72234__$1 = state_72234;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72234__$1,(2),inst_72214);
} else {
if((state_val_72235 === (2))){
var inst_72217 = (state_72234[(7)]);
var inst_72216 = (state_72234[(8)]);
var inst_72216__$1 = (state_72234[(2)]);
var inst_72217__$1 = (inst_72216__$1 == null);
var state_72234__$1 = (function (){var statearr_72236 = state_72234;
(statearr_72236[(7)] = inst_72217__$1);

(statearr_72236[(8)] = inst_72216__$1);

return statearr_72236;
})();
if(cljs.core.truth_(inst_72217__$1)){
var statearr_72237_72255 = state_72234__$1;
(statearr_72237_72255[(1)] = (3));

} else {
var statearr_72238_72256 = state_72234__$1;
(statearr_72238_72256[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72235 === (3))){
var inst_72217 = (state_72234[(7)]);
var state_72234__$1 = state_72234;
var statearr_72239_72257 = state_72234__$1;
(statearr_72239_72257[(2)] = inst_72217);

(statearr_72239_72257[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72235 === (4))){
var inst_72216 = (state_72234[(8)]);
var inst_72220 = fluree.db.util.core.exception_QMARK_(inst_72216);
var state_72234__$1 = state_72234;
var statearr_72240_72258 = state_72234__$1;
(statearr_72240_72258[(2)] = inst_72220);

(statearr_72240_72258[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72235 === (5))){
var inst_72222 = (state_72234[(2)]);
var state_72234__$1 = state_72234;
if(cljs.core.truth_(inst_72222)){
var statearr_72241_72259 = state_72234__$1;
(statearr_72241_72259[(1)] = (6));

} else {
var statearr_72242_72260 = state_72234__$1;
(statearr_72242_72260[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72235 === (6))){
var inst_72216 = (state_72234[(8)]);
var inst_72224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72225 = [inst_72216,"Cannot establish connection to a healthy server, disconnecting."];
var inst_72226 = (new cljs.core.PersistentVector(null,2,(5),inst_72224,inst_72225,null));
var inst_72227 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72226);
var inst_72228 = cljs.core.async.close_BANG_(conn);
var state_72234__$1 = (function (){var statearr_72243 = state_72234;
(statearr_72243[(9)] = inst_72227);

return statearr_72243;
})();
var statearr_72244_72261 = state_72234__$1;
(statearr_72244_72261[(2)] = inst_72228);

(statearr_72244_72261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72235 === (7))){
var inst_72230 = fluree.db.connection.msg_consumer(conn);
var state_72234__$1 = state_72234;
var statearr_72245_72262 = state_72234__$1;
(statearr_72245_72262[(2)] = inst_72230);

(statearr_72245_72262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72235 === (8))){
var inst_72232 = (state_72234[(2)]);
var state_72234__$1 = state_72234;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72234__$1,inst_72232);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_72246 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72246[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_72246[(1)] = (1));

return statearr_72246;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_72234){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72234);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72247){var ex__2730__auto__ = e72247;
var statearr_72248_72263 = state_72234;
(statearr_72248_72263[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72234[(4)]))){
var statearr_72249_72264 = state_72234;
(statearr_72249_72264[(1)] = cljs.core.first((state_72234[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72265 = state_72234;
state_72234 = G__72265;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_72234){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_72234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72250 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72250[(6)] = c__2749__auto___72254);

return statearr_72250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq72208){
var G__72209 = cljs.core.first(seq72208);
var seq72208__$1 = cljs.core.next(seq72208);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72209,seq72208__$1);
}));

